#ifndef CPU_PERF_H_
#define CPU_PERF_H_

#ifdef CONFIG_PROFILING

#ifdef CONFIG_CPU_PMU_PROFILING
#include "./pmu_perf.h"
#else
#include "./m1004kperf.h"
#endif

enum CPU_CNT_TYPE {
//G0
	CPU_TX_ALL = 0,
	CPU_TEST2,
	CPU_TEST3,
	CPU_TEST4,
	CPU_TEST5,
	CPU_TEST6,
	CPU_TEST7,
	CPU_TEST8,
//G1
	CPU_RX_ALL,
	CPU_TEST12,
	CPU_TEST13,
	CPU_TEST14,
	CPU_TEST15,
	CPU_TEST16,
	CPU_TEST17,
	CPU_TEST18,
//G2
	CPU_TX1,
	CPU_TX2,
	CPU_TX3,
	CPU_TX4,
	CPU_TX5,
	CPU_TX6,
	CPU_TX7,
	CPU_TX8,
	CPU_TX9,
//G3
	CPU_TX11,
	CPU_TX12,
	CPU_TX13,
	CPU_TX14,
	CPU_TX15,
	CPU_TX16,
	CPU_TX17,
	CPU_TX18,
//G4
	CPU_RX1, 
	CPU_RX2, 
	CPU_RX3, 
	CPU_RX4, 
	CPU_RX5, 
	CPU_RX6,
	CPU_RX7,
	CPU_RX8,
//G5
	CPU_RX11, 
	CPU_RX12, 
	CPU_RX13, 
	CPU_RX14, 
	CPU_RX15, 
	CPU_RX16,
	CPU_RX17,
	CPU_RX18,
//G6
	CPU_LOCK1,
	CPU_LOCK2,
	CPU_LOCK3,
	CPU_LOCK4,
	CPU_LOCK5,
	CPU_LOCK6,
	CPU_LOCK7,
	CPU_LOCK8,
//G7
	CPU_CACHE1,
	CPU_CACHE2,
	CPU_CACHE3,
	CPU_CACHE4,
	CPU_CACHE5,
	CPU_CACHE6,
	CPU_CACHE7,
	CPU_CACHE8,	
//G8
	CPU_PHY1,
	CPU_PHY2,
	CPU_PHY3,
	CPU_PHY4,
	CPU_PHY5,
	CPU_PHY6,
	CPU_PHY7,
	CPU_PHY8,	
//G9
	CPU_PHY11,
	CPU_PHY12,
	CPU_PHY13,
	CPU_PHY14,
	CPU_PHY15,
	CPU_PHY16,
	CPU_PHY17,
	CPU_PHY18,
//G10
	CPU_PHY21,
	CPU_PHY22,
	CPU_PHY23,
	CPU_PHY24,
	CPU_PHY25,
	CPU_PHY26,
	CPU_PHY27,
	CPU_PHY28,
//G11
	CPU_CACHE11,
	CPU_CACHE12,
	CPU_CACHE13,
	CPU_CACHE14,
	CPU_CACHE15,
	CPU_CACHE16,
	CPU_CACHE17,
	CPU_CACHE18, 
//G12
	CPU_TX21,
	CPU_TX22,
	CPU_TX23,
	CPU_TX24,
	CPU_TX25,
	CPU_TX26,
	CPU_TX27,
	CPU_TX28,
//G13
	CPU_PHLRX01,
	CPU_PHLRX02,
	CPU_PHLRX03,
	CPU_PHLRX04,
	CPU_PHLRX05,
	CPU_PHLRX06,
	CPU_PHLRX07,
	CPU_PHLRX08,
//G14
	CPU_PHLRX11,
	CPU_PHLRX12,
	CPU_PHLRX13,
	CPU_PHLRX14,
	CPU_PHLRX15,
	CPU_PHLRX16,
	CPU_PHLRX17,
	CPU_PHLRX18,	
//END
	CPU_CNT_MAX,
};

struct cnt_group 
{
	u32 group;
	u32 start;
	u32 end;
	u8  name[32];
};

#define CPU_GROUP_SPEC(_group, _start, _end, _name) { \
	.group        	= (_group), \
	.start         	= (_start), \
	.end        	= (_end), \
	.name         	= (_name), \
}

#else

#define hwperf_start(idx) {}
#define hwperf_stop(idx) {}

#endif

#endif
