/*
 *   Handling routines for 802.11 SME (Station Management Entity)
 *
 *  Copyright (c) 2017 Realtek Semiconductor Corp.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 */

#define _8192CD_SME_C_

#ifdef __KERNEL__
#ifdef __MIPSEB__
#include <asm/addrspace.h>
#include <linux/module.h>
#endif
#include <linux/list.h>
#include <linux/random.h>
#elif defined(__ECOS)
#include <cyg/io/eth/rltk/819x/wrapper/sys_support.h>
#include <cyg/io/eth/rltk/819x/wrapper/skbuff.h>
#include <cyg/io/eth/rltk/819x/wrapper/timer.h>
#include <cyg/io/eth/rltk/819x/wrapper/wrapper.h>
#ifdef CONFIG_RTL_REPORT_LINK_STATUS
#include <cyg/io/eth/rltk/819x/wrapper/if_status.h>
#endif
#endif
#include "./8192cd_cfg.h"
#include "./8192cd.h"
#include "./wifi.h"
#include "./8192cd_hw.h"
#include "./8192cd_headers.h"
#include "./8192cd_rx.h"
#include "./8192cd_debug.h"
#include "./EdcaTurboCheck.h"
#ifdef CONFIG_FON
#include "fonclient.h"
#endif
#include "./8192cd_psk.h"
#include "./8192cd_security.h"

#ifdef CONFIG_RTL_SIMPLE_CONFIG
#include "8192cd_profile.h"
#endif

#ifdef WIFI_HAPD
#include <net80211/ieee80211.h>
#include <net80211/ieee80211_ioctl.h>
#endif

#ifdef RTK_NL80211
#include "8192cd_cfg80211.h" 
#endif

#include "./core/core_sme.h"

#ifdef WIFI_SIMPLE_CONFIG
#ifdef P2P_SUPPORT
extern unsigned char WFA_OUI[];
extern unsigned char WFA_OUI_PLUS_TYPE[];
#define MAX_REASSEM_P2P_IE 512
#endif

#ifdef INCLUDE_WPS
#include "./wps/wsc.h"
#endif

#ifdef CONFIG_RTL_OFFLOAD_DRIVER
#include "Hal8814BFirmware.h"
#endif

#include <linux/math64.h>

#define TAG_REQUEST_TYPE	0x103a
#define TAG_RESPONSE_TYPE	0x103b

/*add for WPS2DOTX*/
#define TAG_VERSION2		0x1067	 
#define TAG_VENDOR_EXT		0x1049
#define VENDOR_VERSION2 	0x00
#if defined(__OSK__) && defined(CONFIG_WSC)
extern unsigned char WSC_VENDOR_OUI[3];
#else
unsigned char WSC_VENDOR_OUI[3] = {0x00, 0x37, 0x2a};
#endif
/*add for WPS2DOTX*/

#define MAX_REQUEST_TYPE_NUM 0x3
UINT8 WSC_IE_OUI[4] = {0x00, 0x50, 0xf2, 0x04};
UINT8 NEC_OUI[3] = {0x00, 0x0D, 0x02};
#ifdef CONFIG_RTK_WPS_MESH
static unsigned char MESH_VENDOR_OUI[3] = {0x00, 0xe0, 0x4c}; 
static unsigned char MESH_VENDOR_VAL[2] = {0x05, 0x79};
static unsigned char MESH_SERIAL_VAL[2] = {0x05, 0xa0}; /* Vendor Specific with type 5 (Mesh) and sybtype 0xa0 */
static unsigned char MESH_TARGET_VAL[2] = {0x05, 0xf0}; /* Vendor Specific with type 5 (Mesh) and subtype 0xf0 */
unsigned char MESH_TARGET_KEY[16] = {
	0x66, 0x65, 0x70, 0x6e, 0x70, 0x7a, 0x6c, 0x6f, 0x62, 0x64, 0x65, 0x72, 0x6e, 0x7f, 0x6f, 0x78
};
unsigned char MESH_SERIAL_KEY[16] = {
	0x6a, 0xff, 0x23, 0xa0, 0x3e, 0x20, 0xa8, 0xe4, 0x8c, 0xb2, 0x38, 0xc4, 0x41, 0x37, 0xff, 0xdd
};
#endif
#endif

#ifdef WIFI_WMM
unsigned char WMM_IE[] = {0x00, 0x50, 0xf2, 0x02, 0x00, 0x01};
unsigned char WMM_PARA_IE[6] = {0x00, 0x50, 0xf2, 0x02, 0x01, 0x01};/*cfg p2p cfg p2p*/
#endif

#if defined(CONFIG_IEEE80211W_CLI) || defined(CONFIG_IEEE80211R_CLI)
#include "./sha256.h"
#endif

#ifdef CONFIG_IEEE80211R_CLI 
#include "./8192cd_11r_cli.h"
#endif

#if (defined CONFIG_MBO) || (defined CONFIG_MBO_CLI)
#include "./8192cd_mbo.h"
#endif

/* for RTL865x suspend mode, the CPU can be suspended initially. */
int gCpuCanSuspend = 1;

/* Avoid STA mac would timeout in bridge hwtbl cause throughput penalty in veriwave test. */
#define BRFWTBL_TIMEOUT_INIT	240

/* Count the cumulative amount of keep alive during this time. */
#define DATACPU_KEEP_ALIVE_CHECK_TIME	60

#ifdef RTK_NL80211
static int rtl8192cd_query_psd_cfg80211(struct rtl8192cd_priv *priv, int chnl, int bw, int fft_pts);
#endif
static unsigned int OnAssocReq(struct rtl8192cd_priv *priv, struct rx_frinfo *pfrinfo);
static unsigned int OnProbeReq(struct rtl8192cd_priv *priv, struct rx_frinfo *pfrinfo);
static unsigned int OnProbeRsp(struct rtl8192cd_priv *priv, struct rx_frinfo *pfrinfo);
static unsigned int OnBeacon(struct rtl8192cd_priv *priv, struct rx_frinfo *pfrinfo);
static unsigned int OnDisassoc(struct rtl8192cd_priv *priv, struct rx_frinfo *pfrinfo);
static unsigned int OnAuth(struct rtl8192cd_priv *priv, struct rx_frinfo *pfrinfo);
static unsigned int OnDeAuth(struct rtl8192cd_priv *priv, struct rx_frinfo *pfrinfo);
static unsigned int OnWmmAction(struct rtl8192cd_priv *priv, struct rx_frinfo *pfrinfo);
static unsigned int DoReserved(struct rtl8192cd_priv *priv, struct rx_frinfo *pfrinfo);
#if defined(WDS) || defined(HS2_SUPPORT)
static void issue_probereq(struct rtl8192cd_priv * priv, unsigned char * ssid, int ssid_len, unsigned char * da);
#endif
#ifdef CLIENT_MODE
static unsigned int OnAssocRsp(struct rtl8192cd_priv *priv, struct rx_frinfo *pfrinfo);
static unsigned int OnBeaconClnt(struct rtl8192cd_priv *priv, struct rx_frinfo *pfrinfo);
static unsigned int OnATIM(struct rtl8192cd_priv *priv, struct rx_frinfo *pfrinfo);
static unsigned int OnDisassocClnt(struct rtl8192cd_priv *priv, struct rx_frinfo *pfrinfo);
static unsigned int OnAuthClnt(struct rtl8192cd_priv *priv, struct rx_frinfo *pfrinfo);
static unsigned int OnDeAuthClnt(struct rtl8192cd_priv *priv, struct rx_frinfo *pfrinfo);
//static void start_clnt_assoc(struct rtl8192cd_priv *priv);
static void calculate_rx_beacon(struct rtl8192cd_priv *priv);
static void updateTSF(struct rtl8192cd_priv *priv);
static void issue_PwrMgt_NullData(struct rtl8192cd_priv * priv);
static unsigned int isOurFrameBuffred(unsigned char* tim, unsigned int aid);
#ifdef WIFI_11N_2040_COEXIST
static void issue_coexist_mgt(struct rtl8192cd_priv *priv);
#endif
#endif

/*Site Survey and sorting result by profile related*/
static int compareTpyeByProfile(struct rtl8192cd_priv *priv , const void *entry1, const void *entry2 , int CompareType);
static int get_profile_index(struct rtl8192cd_priv *priv ,char* SSID2Search);
#ifdef MBSSID
/*under multi-repeater case when some STA has connect , the other one don't connect to diff channel AP ; skip this*/ 
static int multiRepeater_startlookup_chk(struct rtl8192cd_priv *priv , int db_idx);
static int multiRepeater_connection_status(struct rtl8192cd_priv *priv );
#endif

void SelectLowestInitRate(struct rtl8192cd_priv *priv);
void issue_op_mode_notify(struct rtl8192cd_priv *priv, struct stat_info *pstat, char mode);


#if (BEAMFORMING_SUPPORT == 1)
void DynamicSelectTxBFSTA(struct rtl8192cd_priv *priv); 
void DynamicSelect2STA(struct rtl8192cd_priv *priv);
#endif

struct mlme_handler {
	unsigned int   num;
	char* str;
	unsigned int (*func)(struct rtl8192cd_priv *priv, struct rx_frinfo *pfrinfo);
};

#ifdef CONFIG_RTK_MESH
struct mlme_handler mlme_mp_tbl[]={
	{WIFI_ASSOCREQ,		"OnAssocReq",	OnAssocReq_MP},
	{WIFI_ASSOCRSP,		"OnAssocRsp",	OnAssocRsp_MP},
	{WIFI_REASSOCREQ,	"OnReAssocReq",	OnAssocReq_MP},
	{WIFI_REASSOCRSP,	"OnReAssocRsp",	OnAssocRsp_MP},
	{WIFI_PROBEREQ,		"OnProbeReq",	OnProbeReq},
	{WIFI_PROBERSP,		"OnProbeRsp",	OnProbeRsp},

	/*----------------------------------------------------------
					below 2 are reserved
	-----------------------------------------------------------*/
	{0,					"DoReserved",	DoReserved},
	{0,					"DoReserved",	DoReserved},
	{WIFI_BEACON,		"OnBeacon",		OnBeacon},
	{WIFI_ATIM,			"OnATIM",		DoReserved},
	{WIFI_DISASSOC,		"OnDisassoc",	OnDisassoc_MP},
	{WIFI_AUTH,			"OnAuth",		OnAuth},
	{WIFI_DEAUTH,		"OnDeAuth",		OnDeAuth},
	{WIFI_WMM_ACTION,	"OnWmmAct",		OnWmmAction}
};
#endif	// CONFIG_RTK_MESH

struct mlme_handler mlme_ap_tbl[]={
	{WIFI_ASSOCREQ,		"OnAssocReq",	OnAssocReq},
	{WIFI_ASSOCRSP,		"OnAssocRsp",	DoReserved},
	{WIFI_REASSOCREQ,	"OnReAssocReq",	OnAssocReq},
	{WIFI_REASSOCRSP,	"OnReAssocRsp",	DoReserved},
	{WIFI_PROBEREQ,		"OnProbeReq",	OnProbeReq},
	{WIFI_PROBERSP,		"OnProbeRsp",	OnProbeRsp},

	/*----------------------------------------------------------
					below 2 are reserved
	-----------------------------------------------------------*/
	{0,					"DoReserved",	DoReserved},
	{0,					"DoReserved",	DoReserved},
	{WIFI_BEACON,		"OnBeacon",		OnBeacon},
	{WIFI_ATIM,			"OnATIM",		DoReserved},
	{WIFI_DISASSOC,		"OnDisassoc",	OnDisassoc},
	{WIFI_AUTH,			"OnAuth",		OnAuth},
	{WIFI_DEAUTH,		"OnDeAuth",		OnDeAuth},
	{WIFI_WMM_ACTION,	"OnWmmAct",		OnWmmAction}
};
#ifdef CLIENT_MODE
struct mlme_handler mlme_station_tbl[]={
	{WIFI_ASSOCREQ,		"OnAssocReq",	DoReserved},
	{WIFI_ASSOCRSP,		"OnAssocRsp",	OnAssocRsp},
	{WIFI_REASSOCREQ,	"OnReAssocReq",	DoReserved},
	{WIFI_REASSOCRSP,	"OnReAssocRsp",	OnAssocRsp},
	{WIFI_PROBEREQ,		"OnProbeReq",	OnProbeReq},
	{WIFI_PROBERSP,		"OnProbeRsp",	OnProbeRsp},

	/*----------------------------------------------------------
					below 2 are reserved
	-----------------------------------------------------------*/
	{0,					"DoReserved",	DoReserved},
	{0,					"DoReserved",	DoReserved},
	{WIFI_BEACON,		"OnBeacon",		OnBeaconClnt},
	{WIFI_ATIM,			"OnATIM",		OnATIM},
	{WIFI_DISASSOC,		"OnDisassoc",	OnDisassocClnt},
	{WIFI_AUTH,			"OnAuth",		OnAuthClnt},
	{WIFI_DEAUTH,		"OnDeAuth",		OnDeAuthClnt},
	{WIFI_WMM_ACTION,	"OnWmmAct",		OnWmmAction}
};
#endif

#ifdef CONFIG_RTL_WLAN_DOS_FILTER
#define MAX_BLOCK_MAC		4
unsigned char block_mac[MAX_BLOCK_MAC][6];
unsigned int block_mac_idx = 0;
unsigned int block_sta_time = 0;
unsigned long block_priv;
#endif

static inline void pwr_un_sleep(struct rtl8192cd_priv *priv, struct stat_info *pstat)
{
    if (pstat->state & WIFI_SLEEP_STATE) {
        pstat->state &= ~(WIFI_SLEEP_STATE);

#ifdef CONFIG_PCI_HCI
        if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE) {
            if (pstat == priv->pshare->txpause_pstat) {
#if defined(CONFIG_RTL_8812_SUPPORT) || defined(CONFIG_RTL_8723B_SUPPORT)
                if ((GET_CHIP_VER(priv) == VERSION_8812E || GET_CHIP_VER(priv) == VERSION_8723B) && (pstat->IOTPeer == HT_IOT_PEER_BROADCOM))
                    RTL_W16(REG_RL_8812, priv->pshare->RL_setting);
                else
#endif
                    RTL_W8(TXPAUSE, RTL_R8(TXPAUSE) & 0xe0);
                priv->pshare->txpause_pstat = NULL;
            }
        }
#endif // CONFIG_PCI_HCI

        if (!pstat->cmn_info.ra_info.disable_ra)
        {
#ifdef SW_TXQ_ATF
            pstat->swq.atf_sleep_time += (jiffies - pstat->txpause_time);
#endif
#ifdef CONFIG_WLAN_HAL
            if(IS_HAL_CHIP(priv))
            {
                if (pstat->txpdrop_flag) {
                    GET_HAL_INTERFACE(priv)->UpdateHalMSRRPTHandler(priv, pstat, INCREASE);
                    pstat->txpdrop_flag = 0;
                }
     	
                if (pstat->txpause_flag) {
#ifdef HW_DETECT_PS_OFFLOAD                        
                    GET_HAL_INTERFACE(priv)->MACIDPauseHandler(priv, REMAP_AID(pstat), 0);
                    pstat->txpause_flag = 0;
#else
                    DEBUG_WARN("[%s][%s][%d] client leave ps, Pwr_state jiffies = %lu diff = %lu\n",
                        __FUNCTION__, priv->dev->name, pstat->cmn_info.aid, jiffies, jiffies-pstat->txpause_time);
                    GET_HAL_INTERFACE(priv)->SetMACIDSleepHandler(priv, 0, REMAP_AID(pstat));                
                    pstat->txpause_flag = 0;
#endif                      
#ifndef STA_AGING_FUNC_OFFLOAD
                    if(priv->pshare->paused_sta_num)
                        priv->pshare->paused_sta_num--;						
#endif                        
                }
#if defined(AP_SWPS_OFFLOAD)
                if (IS_SUPPORT_AP_SWPS_OFFLOAD(priv)) {
                    if(SWPS_check_drop_done(pstat)){
                        //send H2C to clear drop id in ctrl info
                        GET_HAL_INTERFACE(priv)->ClearDropIDHandler(priv, REMAP_AID(pstat), pstat->Drop_ID-1);
                        //check reprepare done
                        if(!SWPS_check_reprepare_done(priv,pstat))
                            printk("STA wakeup, and not reprepare done.\n");
                        }else
                            printk("[%s][%s]not drop done when wakeup\n",__LINE__, __FUNCTION__); //debug
                        pstat->PS_get_SWPSRPT = 0;
                }
#endif                    
            } else
#endif
#if defined(CONFIG_RTL_8812_SUPPORT) || defined(CONFIG_RTL_8723B_SUPPORT)
            if (GET_CHIP_VER(priv)==VERSION_8812E || GET_CHIP_VER(priv)==VERSION_8723B) {
                if (pstat->txpdrop_flag) {
                    UpdateHalMSRRPT8812(priv, pstat, INCREASE);	
                    pstat->txpdrop_flag = 0;
                } 	   				
                if (pstat->txpause_flag) {
                    RTL8812_MACID_PAUSE(priv, 0, REMAP_AID(pstat));
                    pstat->txpause_flag = 0;
                    if(priv->pshare->paused_sta_num)
                        priv->pshare->paused_sta_num--;
                }
            } else
#endif               
#ifdef CONFIG_RTL_88E_SUPPORT
            if (GET_CHIP_VER(priv)==VERSION_8188E) {
                if (pstat->txpause_flag) {
                    RTL8188E_MACID_PAUSE(priv, 0, REMAP_AID(pstat));
                    pstat->txpause_flag = 0;
                }
            } else
#endif
            {
#if defined(CONFIG_RTL_92D_SUPPORT) || defined(CONFIG_RTL_92C_SUPPORT)				
                add_update_ps(priv, pstat);
#endif
            }
        }
    }
}

static int is_support_wpa_aes(struct rtl8192cd_priv *priv, unsigned char *pucIE, unsigned long ulIELength)
{
#ifdef __OSK__
	unsigned short usSuitCount;
	DOT11_RSN_IE_HEADER stDot11RSNIEHeader, *pDot11RSNIEHeader;
	DOT11_RSN_IE_SUITE stDot11RSNIESuite, *pDot11RSNIESuite;
	DOT11_RSN_IE_COUNT_SUITE stDot11RSNIECountSuite, *pDot11RSNIECountSuite;
#else
	unsigned short version, usSuitCount;
	DOT11_RSN_IE_HEADER *pDot11RSNIEHeader;
	DOT11_RSN_IE_SUITE *pDot11RSNIESuite;
	DOT11_RSN_IE_COUNT_SUITE *pDot11RSNIECountSuite;
#endif
	unsigned char *ptr;

	if (ulIELength < sizeof(DOT11_RSN_IE_HEADER)) {
		DEBUG_WARN("parseIE err 1!\n");
		return -1;
	}

#ifdef __OSK__
	memcpy(&stDot11RSNIEHeader, pucIE, sizeof(DOT11_RSN_IE_HEADER));
	pDot11RSNIEHeader = &stDot11RSNIEHeader;
	if (le16_to_cpu(pDot11RSNIEHeader->Version) != RSN_VER1) {
		DEBUG_WARN("parseIE err 2!\n");
		return -1;
	}
#else
	pDot11RSNIEHeader = (DOT11_RSN_IE_HEADER *)pucIE;
	ptr = (unsigned char *)&pDot11RSNIEHeader->Version;
	version = (ptr[1] << 8) | ptr[0];
	
	if (version != RSN_VER1) {
		DEBUG_WARN("parseIE err 2!\n");
		return -1;
	}
#endif

	if (pDot11RSNIEHeader->ElementID != RSN_ELEMENT_ID ||
			pDot11RSNIEHeader->Length != ulIELength -2 ||
			pDot11RSNIEHeader->OUI[0] != 0x00 || pDot11RSNIEHeader->OUI[1] != 0x50 ||
			pDot11RSNIEHeader->OUI[2] != 0xf2 || pDot11RSNIEHeader->OUI[3] != 0x01 ) {
		DEBUG_WARN("parseIE err 3!\n");
		return -1;
	}

	ulIELength -= sizeof(DOT11_RSN_IE_HEADER);
	pucIE += sizeof(DOT11_RSN_IE_HEADER);

	//----------------------------------------------------------------------------------
 	// Multicast Cipher Suite processing
	//----------------------------------------------------------------------------------
	if (ulIELength < sizeof(DOT11_RSN_IE_SUITE)) {
		DEBUG_WARN("parseIE err 4!\n");
		return -1;
	}

#ifdef __OSK__
	memcpy(&stDot11RSNIESuite, pucIE, sizeof(DOT11_RSN_IE_SUITE));
	pDot11RSNIESuite = &stDot11RSNIESuite;
#else
	pDot11RSNIESuite = (DOT11_RSN_IE_SUITE *)pucIE;
#endif
	if (pDot11RSNIESuite->OUI[0] != 0x00 ||
		pDot11RSNIESuite->OUI[1] != 0x50 ||
		pDot11RSNIESuite->OUI[2] != 0xF2) {
		DEBUG_WARN("parseIE err 5!\n");
		return -1;
	}

	ulIELength -= sizeof(DOT11_RSN_IE_SUITE);
	pucIE += sizeof(DOT11_RSN_IE_SUITE);

	//----------------------------------------------------------------------------------
	// Pairwise Cipher Suite processing
	//----------------------------------------------------------------------------------
	if (ulIELength < 2 + sizeof(DOT11_RSN_IE_SUITE)) {
		DEBUG_WARN("parseIE err 6!\n");
		return -1;
	}

#ifdef __OSK__
	memcpy(&stDot11RSNIECountSuite, pucIE, sizeof(DOT11_RSN_IE_COUNT_SUITE));
	pDot11RSNIECountSuite = &stDot11RSNIECountSuite;
	pDot11RSNIESuite = pDot11RSNIECountSuite->dot11RSNIESuite;
	usSuitCount = le16_to_cpu(pDot11RSNIECountSuite->SuiteCount);
#else
	pDot11RSNIECountSuite = (PDOT11_RSN_IE_COUNT_SUITE)pucIE;
	pDot11RSNIESuite = pDot11RSNIECountSuite->dot11RSNIESuite;
	ptr = (unsigned char *)&pDot11RSNIECountSuite->SuiteCount;
	usSuitCount = (ptr[1] << 8) | ptr[0];
#endif

	if (usSuitCount != 1 ||
			pDot11RSNIESuite->OUI[0] != 0x00 ||
			pDot11RSNIESuite->OUI[1] != 0x50 ||
			pDot11RSNIESuite->OUI[2] != 0xF2) {
		DEBUG_WARN("parseIE err 7!\n");
		return -1;
	}

	if (pDot11RSNIESuite->Type == DOT11_ENC_CCMP)
		return 1;
	else
		return 0;
}


static int is_support_wpa2_aes(struct rtl8192cd_priv *priv, 	unsigned char *pucIE, unsigned long ulIELength)
{
#ifdef __OSK__
	unsigned short usSuitCount;
	DOT11_WPA2_IE_HEADER stDot11WPA2IEHeader, *pDot11WPA2IEHeader = NULL;
	DOT11_RSN_IE_SUITE  stDot11RSNIESuite, *pDot11RSNIESuite = NULL;
	DOT11_RSN_IE_COUNT_SUITE stDot11RSNIECountSuite, *pDot11RSNIECountSuite = NULL;
#else
	unsigned short version, usSuitCount;
	DOT11_WPA2_IE_HEADER *pDot11WPA2IEHeader = NULL;
	DOT11_RSN_IE_SUITE  *pDot11RSNIESuite = NULL;
	DOT11_RSN_IE_COUNT_SUITE *pDot11RSNIECountSuite = NULL;
#endif
	unsigned char *ptr;

	if (ulIELength < sizeof(DOT11_WPA2_IE_HEADER)) {
		DEBUG_WARN("ERROR_INVALID_RSNIE_LEN, err 1\n");
		return -1;
	}

#ifdef __OSK__
	memcpy(&stDot11WPA2IEHeader, pucIE, sizeof(DOT11_WPA2_IE_HEADER));
	pDot11WPA2IEHeader = &stDot11WPA2IEHeader;
	if (le16_to_cpu(pDot11WPA2IEHeader->Version) != RSN_VER1) {
		DEBUG_WARN("ERROR_UNSUPPORTED_RSNEVERSION, err 2\n");
		return -1;
	}
#else
	pDot11WPA2IEHeader = (DOT11_WPA2_IE_HEADER *)pucIE;
	ptr = (unsigned char *)&pDot11WPA2IEHeader->Version;
	version = (ptr[1] << 8) | ptr[0];
	
	if (version != RSN_VER1) {
		DEBUG_WARN("ERROR_UNSUPPORTED_RSNEVERSION, err 2\n");
		return -1;
	}
#endif

	if (pDot11WPA2IEHeader->ElementID != WPA2_ELEMENT_ID ||
		pDot11WPA2IEHeader->Length != ulIELength -2 ) {
		DEBUG_WARN("ERROR_INVALID_RSNIE, err 3\n");
		return -1;
	}

	ulIELength -= sizeof(DOT11_WPA2_IE_HEADER);
	pucIE += sizeof(DOT11_WPA2_IE_HEADER);

	//----------------------------------------------------------------------------------
 	// Multicast Cipher Suite processing
	//----------------------------------------------------------------------------------
	if (ulIELength < sizeof(DOT11_RSN_IE_SUITE)) {
		DEBUG_WARN("ERROR_INVALID_RSNIE_LEN, err 4\n");
		return -1;
	}

#ifdef __OSK__
	memcpy(&stDot11RSNIESuite, pucIE, sizeof(DOT11_RSN_IE_SUITE));
	pDot11RSNIESuite = &stDot11RSNIESuite;
#else
	pDot11RSNIESuite = (DOT11_RSN_IE_SUITE *)pucIE;
#endif
	if (pDot11RSNIESuite->OUI[0] != 0x00 ||
			pDot11RSNIESuite->OUI[1] != 0x0F ||
				pDot11RSNIESuite->OUI[2] != 0xAC) {
		DEBUG_WARN("ERROR_INVALID_RSNIE, err 5\n");
		return -1;
	}

	if (pDot11RSNIESuite->Type > DOT11_ENC_WEP104)	{
		DEBUG_WARN("ERROR_INVALID_MULTICASTCIPHER, err 6\n");
		return -1;
	}

	ulIELength -= sizeof(DOT11_RSN_IE_SUITE);
	pucIE += sizeof(DOT11_RSN_IE_SUITE);

	//----------------------------------------------------------------------------------
	// Pairwise Cipher Suite processing
	//----------------------------------------------------------------------------------
	if (ulIELength < 2 + sizeof(DOT11_RSN_IE_SUITE)) {
		DEBUG_WARN("ERROR_INVALID_RSN_IE_SUITE_LEN, err 7\n");
		return -1;
	}

#ifdef OSK
	memcpy(&stDot11RSNIECountSuite, pucIE, sizeof(DOT11_RSN_IE_COUNT_SUITE));
	pDot11RSNIECountSuite = &stDot11RSNIECountSuite;
	pDot11RSNIESuite = pDot11RSNIECountSuite->dot11RSNIESuite;
	usSuitCount = le16_to_cpu(pDot11RSNIECountSuite->SuiteCount);
#else
	pDot11RSNIECountSuite = (PDOT11_RSN_IE_COUNT_SUITE)pucIE;
	pDot11RSNIESuite = pDot11RSNIECountSuite->dot11RSNIESuite;
	ptr = (unsigned char *)&pDot11RSNIECountSuite->SuiteCount;
	usSuitCount = (ptr[1] << 8) | ptr[0];
#endif

	if (usSuitCount != 1 ||
		pDot11RSNIESuite->OUI[0] != 0x00 ||
			pDot11RSNIESuite->OUI[1] != 0x0F ||
				pDot11RSNIESuite->OUI[2] != 0xAC) {
		DEBUG_WARN("ERROR_INVALID_RSNIE, err 8\n");
		return -1;
	}

	if (pDot11RSNIESuite->Type > DOT11_ENC_WEP104) {
		DEBUG_WARN("ERROR_INVALID_UNICASTCIPHER, err 9\n");
		return -1;
	}

	if (pDot11RSNIESuite->Type == DOT11_ENC_CCMP)
		return 1;
	else
		return 0;
}

#ifdef WLAN_DIAGNOSTIC
static unsigned char check_probe_sta_rssi_valid(struct rtl8192cd_priv *priv,unsigned char* addr, unsigned char rssi)
{
	int i, idx=-1;
	unsigned char *hwaddr;
	hwaddr = addr;
	for (i=0; i<MAX_PROBE_REQ_STA; i++) {
		if (!memcmp(priv->probe_sta[i].addr, addr, MACADDRLEN)){
			idx = i;
			break;// check if it is already in the list
		}
	}
	if (idx < 0){
		return 1;// if probe req sta isn't in the list, allow it 
	}	
	else{
		if (priv->probe_sta[idx].rssi && RTL_ABS(priv->probe_sta[idx].rssi,rssi) > 10)
			return 0;
		else
			return 1;	
	}
}

static void add_MAC_RSSI_Entry(struct rtl8192cd_priv *priv,unsigned char* addr, unsigned char rssi, unsigned char status, struct sta_mac_rssi *EntryDB, unsigned int *EntryOccupied, unsigned int *EntryNum)
{
	int i, idx=-1, idx2 = -1;
	unsigned char *hwaddr = addr;
	unsigned char rssi_input;
	if(priv->pmib->dot11StationConfigEntry.probe_info_enable == 2 || priv->pmib->dot11StationConfigEntry.unassoc_sta_scan_ongoing){
		for (i=0; i<MAX_PROBE_REQ_STA; i++) {
			if (!memcmp(EntryDB[i].addr, addr, MACADDRLEN)) {
				idx2 = i;
				break;// check if it is already in the list
			}
			if (idx <0 && (EntryDB[i].used == 0 || (jiffies - EntryDB[i].time_stamp) > RTL_SECONDS_TO_JIFFIES(priv->pmib->dot11StationConfigEntry.probe_info_timeout))) {
				idx = i; //search for empty entry
				continue;
			}
		}

		if(idx2 >= 0){
			rssi_input = ((EntryDB[idx2].rssi * 7)+(rssi * 3)) / 10;
			EntryDB[idx2].rssi = rssi_input;
			EntryDB[idx2].status = status;
			EntryDB[idx2].time_stamp= jiffies;
		}
		else if (idx >= 0){
			rssi_input = rssi;
			memcpy(EntryDB[idx].addr, addr, MACADDRLEN);	
			EntryDB[idx].used = 1;		
			EntryDB[idx].Entry = idx;//check which entry is the probe sta recorded
			EntryDB[idx].rssi = rssi_input;
			EntryDB[idx].status = status;
			EntryDB[idx].time_stamp= jiffies;
			if((priv->pmib->dot11StationConfigEntry.passive_scan || priv->pmib->dot11StationConfigEntry.unassoc_sta_scan_ongoing)&& priv->site_survey->ss_channel)
				EntryDB[idx].channel = priv->site_survey->ss_channel;
			else
				EntryDB[idx].channel = priv->pmib->dot11RFEntry.dot11channel;
		}
		return;
	}else {
		for (i=0; i<MAX_PROBE_REQ_STA; i++) {
			if (!memcmp(EntryDB[i].addr, addr, MACADDRLEN)) {
				idx2 = i;
				break;// check if it is already in the list
			}
		
			if (idx < 0 && EntryDB[i].used == 0) {
				idx = i; //search for empty entry
				continue;
			}
		}
		
		if (idx2 >= 0) {
			rssi_input = ((EntryDB[idx2].rssi * 7)+(rssi * 3)) / 10;
			EntryDB[idx2].rssi = rssi_input;
			EntryDB[idx2].status = status;
			return;
		}		
		else if (idx >= 0) {
			rssi_input = rssi;
			memcpy(EntryDB[idx].addr, addr, MACADDRLEN);	
			EntryDB[idx].used = 1;		
			EntryDB[idx].Entry = idx;//check which entry is the probe sta recorded
			EntryDB[idx].rssi = rssi_input;
			EntryDB[idx].status = status;
			(*EntryOccupied)++;
			return;
		}
		else if ((*EntryOccupied) == MAX_PROBE_REQ_STA) {// sta list full, need to replace sta
			idx = *EntryNum;
			memcpy(EntryDB[idx].addr, addr, MACADDRLEN);		
			EntryDB[idx].used = 1;
			EntryDB[idx].Entry = idx;		
			EntryDB[idx].rssi = rssi;
			EntryDB[idx].status = status;
			(*EntryNum)++;
			if( (*EntryNum) == MAX_PROBE_REQ_STA)	
				*EntryNum = 0; // Reset entry counter;
			return;
		}	
	}
}

#if defined(WLAN_DIAGNOSTIC) && !defined(CTC_FEATURE_SUPPORT)
static void add_MAC_RSSI_Entry_Detail(struct rtl8192cd_priv *priv,unsigned char* addr_ta, unsigned char* addr_ra, unsigned char rssi, unsigned char status, struct sta_mac_rssi_detail *EntryDB, unsigned int *EntryOccupied, unsigned int *EntryNum)
{
	int i, idx=-1, idx2 = -1, idx3 = -1, idx4 = -1, fill_idx = -1;
	unsigned char *hwaddr = addr_ta;   
	unsigned char rssi_input;	
	unsigned long min_time_ap = 0;
	
	struct stat_info *pstat = NULL;
	pstat = get_stainfo(priv, addr_ta);
	if(pstat)
		return;
	
	if(priv->pmib->dot11StationConfigEntry.probe_info_enable == 2 || priv->pmib->dot11StationConfigEntry.unassoc_sta_scan_ongoing){
		for (i=0; i<MAX_UNASSOC_STA; i++) {
			if (!memcmp(EntryDB[i].addr, addr_ta, MACADDRLEN)) {
				idx2 = i;
				break;// check if it is already in the list
			}
			if ( idx <0 && (EntryDB[i].used == 0 || (jiffies - EntryDB[i].time_stamp) > RTL_SECONDS_TO_JIFFIES(priv->pmib->dot11StationConfigEntry.probe_info_timeout))) {
				idx = i; //search for empty entry
				continue;
			}
		}
		
		if(idx2 >= 0){
			rssi_input = ((EntryDB[idx2].rssi * 7)+(rssi * 3)) / 10;
			EntryDB[idx2].rssi = rssi_input;
			EntryDB[idx2].status = status;
			EntryDB[idx2].time_stamp= jiffies;
			if(IS_MCAST(EntryDB[idx2].bssid) && !IS_MCAST(addr_ra))
				memcpy(EntryDB[idx2].bssid, addr_ra, MACADDRLEN);
		}
		else if (idx >= 0){
			rssi_input = rssi;
			memcpy(EntryDB[idx].addr, addr_ta, MACADDRLEN);
			if(IS_MCAST(addr_ra))
				memset(EntryDB[idx].bssid,255,MACADDRLEN);
			else
				memcpy(EntryDB[idx].bssid, addr_ra, MACADDRLEN);
			memset(EntryDB[idx].ssid,0,33);
			EntryDB[idx].ssid_length = 0;
			EntryDB[idx].encrypt = 0;
			//EntryDB[idx].type = 1;
			EntryDB[idx].used = 1;		
			EntryDB[idx].Entry = idx;//check which entry is the unassoc sta recorded
			EntryDB[idx].rssi = rssi_input;
			EntryDB[idx].status = status;
			EntryDB[idx].time_stamp= jiffies;
			if(priv->site_survey->target_channel)
				EntryDB[idx].channel = priv->site_survey->target_channel;
			else if((priv->pmib->dot11StationConfigEntry.passive_scan || priv->pmib->dot11StationConfigEntry.unassoc_sta_scan_ongoing) && priv->site_survey->ss_channel)
				EntryDB[idx].channel = priv->site_survey->ss_channel;
			else
				EntryDB[idx].channel = priv->pmib->dot11RFEntry.dot11channel;
		}
		return;
	}
}

static void add_unassoc_sta(struct rtl8192cd_priv *priv,unsigned char* addr_ta, unsigned char* addr_ra, unsigned char rssi)
{
	add_MAC_RSSI_Entry_Detail(priv, addr_ta, addr_ra, rssi, 0, priv->unassoc_sta, &(priv->UnassocSTAEntryOccupied), &(priv->UnassocSTAEntryNum));
}
#endif

static void add_probe_req_sta(struct rtl8192cd_priv *priv,unsigned char* addr, unsigned char rssi)
{
	add_MAC_RSSI_Entry(priv, addr, rssi, 0, priv->probe_sta, &(priv->ProbeReqEntryOccupied), &(priv->ProbeReqEntryNum));
}
#endif
#ifdef STA_ASSOC_STATISTIC
static void add_reject_sta(struct rtl8192cd_priv *priv,unsigned char* addr, unsigned char rssi)
{
	add_MAC_RSSI_Entry(priv, addr, rssi, 0, priv->reject_sta, &(priv->RejectAssocEntryOccupied), &(priv->RejectAssocEntryNum));
}
static void add_disconnect_sta(struct rtl8192cd_priv *priv,unsigned char* addr, unsigned char rssi)
{
	add_MAC_RSSI_Entry(priv, addr, rssi, 0, priv->removed_sta, &(priv->RemoveAssocEntryOccupied), &(priv->RemoveAssocEntryNum));
}

void add_sta_assoc_status(struct rtl8192cd_priv *priv,unsigned char* addr, unsigned char rssi, unsigned short status)
{
	struct sta_assoc_record *EntryDB = priv->assoc_sta;
	unsigned int *EntryOccupied = &(priv->AssocStatusEntryOccupied);
	unsigned int *EntryNum = &(priv->AssocStatusEntryNum);
	int i, idx=-1, idx2 =-1, expired_idx =-1;
	struct list_head	*phead, *plist;
	struct sta_assoc_act *act;
	struct stat_info	*pstat = NULL, *psta=NULL;

	if((status & 0xff00) == 0x0500)
		pstat = get_stainfo(priv, addr);
	for (i=0; i<MAX_ASSOC_STATUS_STA; i++) {
		if (EntryDB[i].used == 0) {
			if (idx < 0)
				idx = i; //search for empty entry
			continue;
		}
		if (!memcmp(EntryDB[i].addr, addr, MACADDRLEN)) {
			idx2 = i;
			break;// check if it is already in the list
		}		
		if(expired_idx == -1) {
			psta = get_stainfo(priv, EntryDB[i].addr);
			if(psta == NULL || psta->expire_to == 0)
				expired_idx = i;
		}
	}
	if (idx2>=0){
		phead = &(EntryDB[idx2].act_list);
		if (!list_empty(phead)) {			
			plist = phead->prev;
			act = list_entry(plist, struct sta_assoc_act, act_list);
			if( (((int)act->step<<8) | act->status) == status ) {
				struct tm	time_info;
				get_current_timeInfo(&time_info, 8);	
				if(memcmp(&act->time_info, &time_info, sizeof(time_info)-2*sizeof(int))==0)			//
					return;
			}
		}		
		phead = &EntryDB[idx2].act_pool;		
		if (list_empty(phead)) 
			plist = EntryDB[idx2].act_list.next;				
		else 
			plist = phead->next;
		list_del_init(plist);
		act = list_entry(plist, struct sta_assoc_act, act_list);
		act->step = (status>>8) & 0xff;
		act->status = status & 0xff;
		act->rssi = rssi;		
		if(pstat) 		
			memcpy(act->Reserved, pstat->currAP_Addr, MACADDRLEN);
		else 
			act->Reserved[0] = 0xff;
		get_current_timeInfo(&act->time_info, 8);
		phead = &EntryDB[idx2].act_list;
		list_add_tail(plist, phead);				
		return;
	}
	else if ((*EntryOccupied) == MAX_ASSOC_STATUS_STA) {// sta list full, need to replace sta
		if(expired_idx>=0) {
			idx = expired_idx;
		} else {	
			idx = *EntryNum;	
			(*EntryNum)++;			
			if( (*EntryNum) == MAX_ASSOC_STATUS_STA)	
				*EntryNum = 0; // Reset entry counter;
		}
	} else {
		(*EntryOccupied)++;
	}
	memcpy(EntryDB[idx].addr, addr, MACADDRLEN);
	EntryDB[idx].used = 1;
	INIT_LIST_HEAD(&EntryDB[idx].act_list);
	INIT_LIST_HEAD(&EntryDB[idx].act_pool);
	for(i=1; i< MAX_ASSOC_STA_ACT; i++)	{
		INIT_LIST_HEAD(&(EntryDB[idx].action[i].act_list));
		list_add_tail(&(EntryDB[idx].action[i].act_list), &EntryDB[idx].act_pool);
	}
	INIT_LIST_HEAD(&(EntryDB[idx].action[0].act_list)); 	
	list_add_tail(&(EntryDB[idx].action[0].act_list), &EntryDB[idx].act_list);
	get_current_timeInfo(&EntryDB[idx].action[0].time_info, 8);
	EntryDB[idx].action[0].step = (status>>8) & 0xff;
	EntryDB[idx].action[0].status = status & 0xff;
	EntryDB[idx].action[0].rssi = rssi;	
	if(pstat) 		
		memcpy(EntryDB[idx].action[0].Reserved, pstat->currAP_Addr, MACADDRLEN);
	else 
		EntryDB[idx].action[0].Reserved[0] = 0xff;
}
#endif

#ifdef WLAN_DIAGNOSTIC
unsigned char isDualBandClient(struct rtl8192cd_priv *priv, unsigned char* addr)
{
	int i;
	unsigned char *hwaddr = addr;
	struct sta_mac_rssi *EntryDB;
	if(!priv)
		return 0;
	EntryDB = priv->probe_sta;
	for(i=0; i<MAX_PROBE_REQ_STA; i++){
		if(EntryDB[i].used){
			if(!memcmp(EntryDB[i].addr, addr, MACADDRLEN)){
				//printk("Found probe request in other interface\n");
				return 1;
			}
		}
	}
	return 0;
}

void check_unassoc_sta_match(struct rtl8192cd_priv *priv, struct rx_frinfo *pfrinfo)
{
unsigned char	*pframe;
	unsigned char    *addr, *addr2;
	unsigned char    isbcst;
	
	if(priv->pmib->dot11StationConfigEntry.unassoc_sta_scan_ongoing != 1)
		return;
		
	isbcst = IS_BCAST2(priv->site_survey->target_macaddr);
	pframe = get_pframe(pfrinfo);
	addr2 = GetAddr2Ptr(pframe);
	addr = GetAddr1Ptr(pframe);
	
	
	if(!isbcst && memcmp(GetAddr2Ptr(pframe), priv->site_survey->target_macaddr,MACADDRLEN) != 0)
		return;
	//DEBUG_INFO("[Scan STA]%02X%02X%02X%02X%02X%02X->%02X%02X%02X%02X%02X%02X\n",addr2[0],addr2[1],addr2[2],addr2[3],addr2[4],addr2[5],addr[0],addr[1],addr[2],addr[3],addr[4],addr[5]);
#ifdef CTC_FEATURE_SUPPORT
	add_probe_req_sta(priv,GetAddr2Ptr(pframe),pfrinfo->rf_info.rssi);
#else
	if(pfrinfo->to_fr_ds == 2) //send from STA
		add_unassoc_sta(priv,GetAddr2Ptr(pframe), GetAddr1Ptr(pframe),pfrinfo->rf_info.rssi);
#endif
	if(!isbcst){
		priv->pmib->dot11StationConfigEntry.unassoc_sta_scan_ongoing = 2;
		RTL_W32(RCR,priv->site_survey->RCR_backup);
		DEBUG_INFO("[Scan STA]Find target STA, stop monitor mode\n");
	}

}
#endif

#ifdef BSS_MONITOR_SUPPORT
int add_monitor_sta(struct rtl8192cd_priv *priv,unsigned char* addr, unsigned char type, unsigned char rssi, unsigned int pktlen, unsigned char ch, unsigned char* ssid, unsigned short ssid_len)
{
	int i, idx=-1, idx2 =0;
	unsigned char *hwaddr = addr;
	struct monitor_station *EntryDB = priv->pshare->monitor_sta;
	for (i=0; i<MAX_MONITOR_STA; i++) {
		if (EntryDB[i].used && EntryDB[i].type==type && !memcmp(EntryDB[i].addr, addr, MACADDRLEN)) {	// already in the list
			if(EntryDB[i].rssi < rssi)
				EntryDB[i].rssi = rssi;
			if(ch)
				EntryDB[i].channel= ch;
			if(ssid_len) {
				memcpy(EntryDB[i].ssid, ssid, ssid_len);
				EntryDB[i].ssid_len = ssid_len;
				EntryDB[i].ssid[ssid_len] = '\0';
			}
			EntryDB[i].txbyte += pktlen;
			return i;
		}
		if (EntryDB[i].used == 0) {
			if (idx < 0)
				idx = i; //search for empty entry
			continue;
		}
	}
	if (idx >= 0 && idx < MAX_MONITOR_STA){	// add new
		memcpy(EntryDB[idx].addr, addr, MACADDRLEN);	
		EntryDB[idx].used = 1;		
		EntryDB[idx].type = type;
		EntryDB[idx].apIndex = -1;
		EntryDB[idx].rssi = rssi;
		EntryDB[idx].channel= ch;	
		if(ssid_len) {
			memcpy(EntryDB[idx].ssid, ssid, ssid_len);			
		} 
		EntryDB[idx].ssid_len = ssid_len;			
		EntryDB[idx].ssid[ssid_len] = '\0';
		
		EntryDB[idx].txbyte = pktlen;		
		INIT_LIST_HEAD(&(EntryDB[idx].asoc_list));
		return idx;
	}
	return -1;
}

void add_monitor_sta_relation(struct rtl8192cd_priv *priv, int ap_idx, int sta_idx)
{
	if (ap_idx >= 0 && sta_idx>=0){
		struct list_head *plist = &(priv->pshare->monitor_sta[ap_idx].asoc_list);
		struct list_head *node = &(priv->pshare->monitor_sta[sta_idx].asoc_list);		
		if (!list_empty(node)) {
			list_del_init(node);
		}
		list_add_tail(node, plist);
		priv->pshare->monitor_sta[sta_idx].apIndex = ap_idx;
	}
}

void collect_monitor_info(struct rtl8192cd_priv *priv, struct rx_frinfo *pfrinfo)
{
	unsigned char* pframe = get_pframe(pfrinfo);
	int ap_idx=-1, sta_idx=-1;
	unsigned int sub_frame_type = GetFrameSubType(pframe);
	priv = GET_ROOT(priv);	

	if(!priv->pshare->rf_ft_var.monitor_enable)
		return;
	
	if(sub_frame_type==WIFI_BEACON || sub_frame_type==WIFI_PROBERSP) {
		unsigned char channel = priv->pmib->dot11RFEntry.dot11channel;
		unsigned char *p;
		int len;

		unsigned char *get_ie(unsigned char *pbuf, int index, int *len, int limit);
		p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, _DSSET_IE_, &len,
			pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);
		if (p != NULL)
			channel = *(p+2);
		else {
			p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, _HT_IE_, &len,
				pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);
			if (p !=  NULL) 
				channel = *(p+2);
		}

		p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, _SSID_IE_, &len,
			pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);

		if(p==NULL || len >32)
			len =0;
		add_monitor_sta(priv, GetAddr2Ptr(pframe), 1, pfrinfo->rf_info.rssi, pfrinfo->pktlen, channel,
			(p+2), len);			// ap
	} else if(sub_frame_type == WIFI_DATA || sub_frame_type == WIFI_QOS_DATA ){
		if(pfrinfo->to_fr_ds==1) {			// ToDs=0, FromDs=1
			ap_idx = add_monitor_sta(priv, GetAddr2Ptr(pframe), 1, pfrinfo->rf_info.rssi, pfrinfo->pktlen, 0, NULL, 0);		// ap
			if(!IS_MCAST(GetAddr1Ptr(pframe))) {
				sta_idx = add_monitor_sta(priv, GetAddr1Ptr(pframe), 2, 0, 0, 0, NULL, 0);								// sta
				add_monitor_sta_relation(priv, ap_idx, sta_idx);
			}
		} else if(pfrinfo->to_fr_ds==2){	// ToDs=1, FromDs=0
			ap_idx = add_monitor_sta(priv, GetAddr1Ptr(pframe), 1, 0, 0, 0, NULL, 0);								// ap
			sta_idx = add_monitor_sta(priv, GetAddr2Ptr(pframe), 2, pfrinfo->rf_info.rssi, pfrinfo->pktlen, 0, NULL, 0);		// sta
			add_monitor_sta_relation(priv, ap_idx, sta_idx);			
		}
	}
}
#endif
#ifdef WIFI_SIMPLE_CONFIG
/* WPS2DOTX   */
#if defined(__OSK__) && defined(CONFIG_WSC)
extern unsigned char *search_VendorExt_tag(unsigned char *data, unsigned char id, int len, int *out_len);
#else
#if defined(__ECOS) && !defined(CONFIG_RTL_819X_ECOS) //search_VendorExt_tag() also defined in wsc/util.c. Static definition here to avoid confilct.
static 
#endif
unsigned char *search_VendorExt_tag(unsigned char *data, unsigned char id, int len, int *out_len)
{
	unsigned char tag, tag_len;
	int size;

	//skip WFA_VENDOR_LEN
	data+=3;
	len-=3;
	
	while (len > 0) {
		memcpy(&tag, data, 1);
		memcpy(&tag_len, data+1, 1);
		if (id == tag) {
			if (len >= (2 + tag_len)) {
				*out_len = (int)tag_len;
				return (&data[2]);
			}
			else {
				_DEBUG_ERR("Found VE tag [0x%x], but invalid length!\n", id);
				break;
			}
		}
		size = 2 + tag_len;
		data += size;
		len -= size;
	}

	return NULL;
}
#endif
/* WPS2DOTX   */

unsigned char *search_wsc_tag(unsigned char *data, unsigned short id, int len, int *out_len)
{
	unsigned short tag, tag_len;
	int size;

	while (len > 0) {
		memcpy(&tag, data, 2);
		memcpy(&tag_len, data+2, 2);
		tag = ntohs(tag);
		tag_len = ntohs(tag_len);

		if (id == tag) {
			if (len >= (4 + tag_len)) {
				*out_len = (int)tag_len;
				return (&data[4]);
			}
			else {
				_DEBUG_ERR("Found tag [0x%x], but invalid length!\n", id);
				break;
			}
		}
		size = 4 + tag_len;
		data += size;
		len -= size;
	}

	return NULL;
}


static struct wsc_probe_request_info *search_wsc_probe_sta(struct rtl8192cd_priv *priv, unsigned char *addr)
{
	int i, idx=-1;

	for (i=0; i<MAX_WSC_PROBE_STA; i++) {
		if (priv->wsc_sta[i].used == 0) {
			if (idx < 0)
				idx = i;
			continue;
		}
		if (!memcmp(priv->wsc_sta[i].addr, addr, MACADDRLEN))
			break;
	}

	if ( i != MAX_WSC_PROBE_STA)
		return (&priv->wsc_sta[i]); // return sta info for WSC sta

	if (idx >= 0)
		return (&priv->wsc_sta[idx]); // add sta info for WSC sta
	else {
		// sta list full, need to replace sta
		unsigned long oldest_time_stamp=jiffies;

		for (i=0; i<MAX_WSC_PROBE_STA; i++) {
			if (priv->wsc_sta[i].time_stamp < oldest_time_stamp) {
				oldest_time_stamp = priv->wsc_sta[i].time_stamp;
				idx = i;
			}
		}
		memset(&priv->wsc_sta[idx], 0, sizeof(struct wsc_probe_request_info));

		return (&priv->wsc_sta[idx]);
	}
}


static int search_wsc_pbc_probe_sta(struct rtl8192cd_priv *priv, unsigned char *addr)
{
	int i/*, idx=-1*/;
#ifndef SMP_SYNC
	unsigned long flags;
#endif
	SAVE_INT_AND_CLI(flags);

	for (i=0; i<MAX_WSC_PROBE_STA; i++) {
		if (priv->wsc_sta[i].used==1 && priv->wsc_sta[i].pbcactived==1) {

			if (!memcmp(priv->wsc_sta[i].addr, addr, MACADDRLEN)){

				priv->wsc_sta[i].used=0;
				priv->wsc_sta[i].pbcactived=0;				
				RESTORE_INT(flags);	
				return 1;
			}
		}
	}
	RESTORE_INT(flags);	
	return 0;
	
}

#define TAG_DEVICE_PASSWORD_ID		0x1012
#define PASS_ID_PB					0x4
static void wsc_forward_probe_request(struct rtl8192cd_priv *priv, unsigned char *pframe, unsigned char *IEaddr, unsigned int IElen)
{
	unsigned char *p=IEaddr;
	unsigned int len=IElen;
	unsigned char forwarding=0;
	struct wsc_probe_request_info *wsc_sta=NULL;
	DOT11_PROBE_REQUEST_IND ProbeReq_Ind;
#ifndef SMP_SYNC
	unsigned long flags;
#endif
	unsigned char *p2=IEaddr;
	unsigned int len2=IElen;	
	unsigned short pwid=0;	

	if (IEaddr == NULL || IElen == 0)
		return;
	if (IElen > PROBEIELEN) {
		DEBUG_WARN("[%s] IElen=%d\n", __FUNCTION__, IElen);
		return;
	}
	p = search_wsc_tag(p+2+4, TAG_REQUEST_TYPE, len-4, (int *)&len);
	if (p && (*p <= MAX_REQUEST_TYPE_NUM)) { //forward WPS IE to wsc daemon
		SAVE_INT_AND_CLI(flags);
		wsc_sta = search_wsc_probe_sta(priv, (unsigned char *)GetAddr2Ptr(pframe));
		p2 = search_wsc_tag(p2+2+4, TAG_DEVICE_PASSWORD_ID, len2-4, (int *)&len2);	
		if (p2 && len2 <= sizeof(pwid)) {
			memcpy(&pwid, p2, len2);		
			pwid = ntohs(pwid);
			if(pwid==PASS_ID_PB){
				wsc_sta->pbcactived=1;
			}
		}
		if (IElen <= sizeof(wsc_sta->ProbeIE)) {
			if (wsc_sta->used) {
				if ((wsc_sta->ProbeIELen != IElen) ||
					(memcmp(wsc_sta->ProbeIE, (void *)(IEaddr), IElen) != 0) ||
					((jiffies - wsc_sta->time_stamp) > RTL_SECONDS_TO_JIFFIES(3))) 
				{
					memcpy(wsc_sta->ProbeIE, (void *)(IEaddr), IElen);
					wsc_sta->ProbeIELen = IElen;
					wsc_sta->time_stamp = jiffies;
					forwarding = 1;
				}
			}
			else {
				memcpy(wsc_sta->addr, (void *)GetAddr2Ptr(pframe), MACADDRLEN);
				memcpy(wsc_sta->ProbeIE, (void *)(IEaddr), IElen);
				wsc_sta->ProbeIELen = IElen;
				wsc_sta->time_stamp = jiffies;
				wsc_sta->used = 1;
				forwarding = 1;
			}
		}
		RESTORE_INT(flags);

		if (forwarding) {
			memcpy((void *)ProbeReq_Ind.MACAddr, (void *)GetAddr2Ptr(pframe), MACADDRLEN);
			ProbeReq_Ind.EventId = DOT11_EVENT_WSC_PROBE_REQ_IND;
			ProbeReq_Ind.IsMoreEvent = 0;
			ProbeReq_Ind.ProbeIELen = IElen;
			memcpy((void *)ProbeReq_Ind.ProbeIE, (void *)(IEaddr), ProbeReq_Ind.ProbeIELen);
#ifdef INCLUDE_WPS
			//			wps_indicate_evt(priv);
			wps_NonQueue_indicate_evt(priv ,
				(UINT8 *)&ProbeReq_Ind,sizeof(DOT11_PROBE_REQUEST_IND));		
#else
			DOT11_EnQueue((unsigned long)priv, priv->pevent_queue, (UINT8 *)&ProbeReq_Ind, sizeof(DOT11_PROBE_REQUEST_IND));
#ifdef WIFI_HAPD
			event_indicate_hapd(priv, GetAddr2Ptr(pframe), HAPD_WPS_PROBEREQ, (UINT8 *)&ProbeReq_Ind); //_Eric ???? this event is not registered
#ifdef HAPD_DRV_PSK_WPS
			event_indicate(priv, GetAddr2Ptr(pframe), 1);
#endif
#else
			event_indicate(priv, GetAddr2Ptr(pframe), 1);
#endif
#endif
		}
	}
}


static __inline__ void wsc_probe_expire(struct rtl8192cd_priv *priv)
{
	int i;
	//unsigned long flags;

	//SAVE_INT_AND_CLI(flags);
	for (i=0; i<MAX_WSC_PROBE_STA; i++) {
		if (priv->wsc_sta[i].used == 0)
			continue;
		if ((jiffies - priv->wsc_sta[i].time_stamp) > RTL_SECONDS_TO_JIFFIES(180))
			memset(&priv->wsc_sta[i], 0, sizeof(struct wsc_probe_request_info));
	}
	//RESTORE_INT(flags);
}
#endif // WIFI_SIMPLE_CONFIG


static __inline__ UINT8 match_supp_rate(unsigned char *pRate, int len, UINT8 rate)
{
	int idx;
	for (idx=0; idx<len; idx++) {
		if ((pRate[idx] & 0x7f) == rate)
			return 1;
	}

	// TODO: need some more refinement
	if ((rate & 0x80) && ((rate & 0x7f) < 16))
		return 1;

	return 0;
}


// unchainned all the skb chainnned in a given list, like frag_list(type == 0)
void unchainned_all_frag(struct rtl8192cd_priv *priv, struct list_head *phead)
{
	struct rx_frinfo *pfrinfo;
	struct list_head *plist;
	struct sk_buff	 *pskb;

	while (!list_empty(phead)) {
		plist = phead->next;
		list_del(plist);

		pfrinfo = list_entry(plist, struct rx_frinfo, mpdu_list);
		pskb = get_pskb(pfrinfo);
		count_rx_data_drops(priv, pfrinfo);
		rtl_kfree_skb(priv, pskb, _SKB_RX_);
	}
}

static __always_inline void rtl8192cd_frag_timer(unsigned long task_priv)
{
	unsigned long flags;
	struct list_head	*phead, *plist;
	struct stat_info	*pstat;
	struct rtl8192cd_priv *priv = (struct rtl8192cd_priv *)task_priv;

	struct list_head frag_list;

	if (!(priv->drv_state & DRV_STATE_OPEN))
		return;

	INIT_LIST_HEAD(&frag_list);

	priv->frag_to ^= 0x01;

	phead = &priv->defrag_list;

	DEFRAG_LOCK(flags);

	plist = phead->next;
	while (plist != phead) {
		pstat = list_entry(plist, struct stat_info, defrag_list);
		plist = plist->next;

		if (pstat->frag_to == priv->frag_to) {
			list_del_init(&pstat->defrag_list);
			list_splice_init(&pstat->frag_list, &frag_list);
			pstat->frag_count = 0;
		}
	}

	DEFRAG_UNLOCK(flags);

	unchainned_all_frag(priv, &frag_list);

	rtk_mod_timer(&priv->frag_to_filter, jiffies + FRAG_TO);
}
DEFINE_TIMER_CALLBACK(rtl8192cd_frag_timer);

void init_frag_to_filter_timer(struct rtl8192cd_priv *priv)
{
	rtk_timer_setup(&(priv->frag_to_filter), rtl8192cd_frag_timer, (unsigned long)priv, 0);
}

#ifdef USB_PKT_RATE_CTRL_SUPPORT
usb_pktCnt_fn get_usb_pkt_cnt_hook = NULL;
register_usb_pkt_cnt_fn register_usb_hook = NULL;

void register_usb_pkt_cnt_f(void *usbPktFunc)
{
	get_usb_pkt_cnt_hook = (usb_pktCnt_fn)(usbPktFunc);
}


void usbPkt_timer_handler(struct rtl8192cd_priv *priv)
{
	unsigned int pkt_cnt, pkt_diff;

	if (!get_usb_pkt_cnt_hook)
		return;

	pkt_cnt = get_usb_pkt_cnt_hook();
	pkt_diff = pkt_cnt - priv->pre_pkt_cnt;

	if (pkt_diff) {
		priv->auto_rate_mask = 0x803fffff;
		priv->change_toggle = ((priv->change_toggle) ? 0 : 1);
	}

	priv->pre_pkt_cnt = pkt_cnt;
	priv->pkt_nsec_diff += pkt_diff;

	if ((++priv->poll_usb_cnt) % 10 == 0) {
		if ((priv->pkt_nsec_diff) < 10 ) {
			priv->auto_rate_mask = 0;
			priv->pkt_nsec_diff = 0;
		}
	}
}
#endif // USB_PKT_RATE_CTRL_SUPPORT

#if defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI) || defined(CONFIG_PCI_HCI)
static void auth_expire(struct rtl8192cd_priv *priv)
{
	struct stat_info	*pstat;
	struct list_head	*phead, *plist;
	struct list_head	local_head;
#ifdef SMP_SYNC
	unsigned long	flags = 0;
#endif

	INIT_LIST_HEAD(&local_head);

	SMP_LOCK_AUTH_LIST(flags);

	phead = &priv->auth_list;
	plist = phead->next;

	while (plist != phead) {
		pstat = list_entry(plist, struct stat_info, auth_list);
		plist = plist->next;

// #if defined(CONFIG_RTK_MESH) && defined(MESH_BOOTSEQ_AUTH) // Skip MP node
#ifdef CONFIG_RTK_MESH // Skip MP node
		if(isPossibleNeighbor(pstat))
			continue;
#endif // CONFIG_RTK_MESH

		pstat->expire_to--;

		if(priv->pshare->rf_ft_var.fix_expire_to_zero == 1) {
			pstat->expire_to = 0;
			priv->pshare->rf_ft_var.fix_expire_to_zero = 0;
		}

		if (pstat->expire_to == 0) {
			list_del(&pstat->auth_list);
			list_add_tail(&pstat->auth_list, &local_head);
		}
#ifdef CONFIG_IEEE80211R
		if (pstat->ft_auth_expire_to)
			pstat->ft_auth_expire_to--;
#endif
	}

	phead = &local_head;
	plist = phead->next;

	while (plist != phead) {
		pstat = list_entry(plist, struct stat_info, auth_list);
		list_del_init(plist);
		SMP_UNLOCK_AUTH_LIST(flags);

		//below should be take care... since auth fail, just free the stat info...
		DEBUG_INFO("auth expire %pm\n",	pstat->cmn_info.mac_addr);

		SMP_UNLOCK(flags);
		free_stainfo(priv, pstat);
		SMP_LOCK(flags);

		SMP_LOCK_AUTH_LIST(flags);
		plist = phead->next;
	}

	SMP_UNLOCK_AUTH_LIST(flags);
}
#else
static void auth_expire(struct rtl8192cd_priv *priv)
{
	struct stat_info	*pstat;
	struct list_head	*phead, *plist;
#ifdef SMP_SYNC
		unsigned long	flags = 0;
#endif

	phead = &priv->auth_list;
	plist = phead->next;

	//SAVE_INT_AND_CLI(flags);
	
	while(plist != phead)
	{
		pstat = list_entry(plist, struct stat_info, auth_list);
		plist = plist->next;

// #if defined(CONFIG_RTK_MESH) && defined(MESH_BOOTSEQ_AUTH) // Skip MP node
#ifdef CONFIG_RTK_MESH // Skip MP node
		if(isPossibleNeighbor(pstat))
			continue;
#endif // CONFIG_RTK_MESH

		pstat->expire_to--;

		if(priv->pshare->rf_ft_var.fix_expire_to_zero == 1) {
			pstat->expire_to = 0;
			priv->pshare->rf_ft_var.fix_expire_to_zero = 0;
		}

		if (pstat->expire_to == 0)
		{
			list_del_init(&pstat->auth_list);

			//below should be take care... since auth fail, just free the stat info...
			DEBUG_INFO("auth expire %pm\n", pstat->cmn_info.mac_addr);
			free_stainfo(priv, pstat);
		}
#ifdef CONFIG_IEEE80211R
		if (pstat->ft_auth_expire_to)
			pstat->ft_auth_expire_to--;
#endif
	}
	//RESTORE_INT(flags);
}
#endif

static void delsta_expire(struct rtl8192cd_priv *priv)
{
	struct stat_info	*pstat;
	struct list_head	*phead, *plist;
	struct list_head	local_head;
#ifdef SMP_SYNC
	unsigned long	flags = 0;
#endif

	INIT_LIST_HEAD(&local_head);

	SMP_LOCK_DELSTA_LIST(flags);

	phead = &priv->delsta_list;
	plist = phead->next;

	while (plist != phead) {
		pstat = list_entry(plist, struct stat_info, delsta_list);
		plist = plist->next;

		pstat->expire_to--;

		if (pstat->expire_to == 0) {
			list_del(&pstat->delsta_list);
			list_add_tail(&pstat->delsta_list, &local_head);
		}
	}

	SMP_UNLOCK_DELSTA_LIST(flags);

	phead = &local_head;
	plist = phead->next;

	while (plist != phead) {
		pstat = list_entry(plist, struct stat_info, delsta_list);
		list_del_init(plist);

		SMP_UNLOCK(flags);
		free_stainfo(priv, pstat);
		SMP_LOCK(flags);

		plist = phead->next;
	}
}

#if 0 /* def RTL8192SE*/
void reset_1r_sta_RA(struct rtl8192cd_priv *priv, unsigned int sg_rate){
	struct list_head	*phead, *plist;
	struct stat_info	*pstat;
#ifdef SMP_SYNC
	unsigned long flags=0;
#endif

	phead = &priv->asoc_list;

	SMP_LOCK_ASOC_LIST(flags);

	plist = phead->next;
	while(plist != phead)
	{

		unsigned int sta_band = 0;
		pstat = list_entry(plist, struct stat_info, asoc_list);
		plist = plist->next;

		if(pstat && !pstat->ht_cap_len)
			continue;

		if (pstat->tx_ra_bitmap & 0xffff000)
			sta_band |= WIRELESS_11N | WIRELESS_11G | WIRELESS_11B;
		else if (pstat->tx_ra_bitmap & 0xff0)
			sta_band |= WIRELESS_11G |WIRELESS_11B;
		else
			sta_band |= WIRELESS_11B;

		if((pstat->tx_ra_bitmap & 0x0ff00000) == 0 && (pstat->tx_ra_bitmap & BIT(28))!=0 && sg_rate == 0xffff){
			pstat->tx_ra_bitmap &= ~BIT(28); // disable short GI for 1R sta
			set_fw_reg(priv, (0xfd0000a2 | ((REMAP_AID(pstat) & 0x1f)<<4 | (sta_band & 0xf))<<8), pstat->tx_ra_bitmap, 1);
		}
		else if((pstat->tx_ra_bitmap & 0x0ff00000) == 0 && (pstat->tx_ra_bitmap & BIT(28))==0 && sg_rate == 0x7777){
			pstat->tx_ra_bitmap |= BIT(28); // enable short GI for 1R sta
			set_fw_reg(priv, (0xfd0000a2 | ((REMAP_AID(pstat) & 0x1f)<<4 | (sta_band & 0xf))<<8), pstat->tx_ra_bitmap, 1);
		}
	}

	SMP_UNLOCK_ASOC_LIST(flags);

	return;
}
#endif



// for simplify, we consider only two stations. Otherwise we may sorting all the stations and
// hard to maintain the code.
// 0 for path A/B selection(bg only or 1ss rate), 1 for TX Diversity (ex: DIR 655 clone)
#if 0
struct stat_info* switch_ant_enable(struct rtl8192cd_priv *priv, unsigned char flag)
{
	struct stat_info	*pstat, *pstat_chosen = NULL;
	struct list_head	*phead, *plist;
	unsigned int tp_2nd = 0, maxTP = 0;
	unsigned int rssi_2ndTp = 0, rssi_maxTp = 0;
	unsigned int tx_2s_avg = 0;
	unsigned int rx_2s_avg = 0;
	unsigned long total_sum = (priv->pshare->current_tx_bytes+priv->pshare->current_rx_bytes);
	unsigned char th_rssi = 0;
#ifdef SMP_SYNC
	unsigned long flags=0;
#endif

	phead = &priv->asoc_list;

	SMP_LOCK_ASOC_LIST(flags);

	plist = phead->next;
	while (plist != phead)
	{
		pstat = list_entry(plist, struct stat_info, asoc_list);
		plist = plist->next;

		if((pstat->tx_avarage + pstat->rx_avarage) > maxTP){
			tp_2nd = maxTP;
			rssi_2ndTp = rssi_maxTp;

			maxTP = pstat->tx_avarage + pstat->rx_avarage;
			rssi_maxTp = pstat->rssi;

			pstat_chosen = pstat;
		}
	}

	SMP_UNLOCK_ASOC_LIST(flags);

	// for debug
//	printk("maxTP: %d, second: %d\n", rssi_maxTp, rssi_2ndTp);

	if(pstat_chosen == NULL){
//		printk("ERROR! NULL pstat_chosen \n");
		return NULL;
	}

	if(total_sum != 0){
		tx_2s_avg = (unsigned int)((pstat_chosen->current_tx_bytes*100) / total_sum);
		rx_2s_avg = (unsigned int)((pstat_chosen->current_rx_bytes*100) / total_sum);
	}

	if( priv->assoc_num > 1 && (tx_2s_avg+rx_2s_avg) < (100/priv->assoc_num)){ // this is not a burst station
		pstat_chosen = NULL;
//		printk("avg is: %d\n", (tx_2s_avg+rx_2s_avg));
		goto out_switch_ant_enable;
	}

	if(flag == 1)
		goto out_switch_ant_enable;

	if(pstat_chosen && (!pstat_chosen->cmn_info.ra_info.disable_ra) && 
        !getSTABitMap(&priv->pshare->has_2r_sta, REMAP_AID(pstat_chosen)) // 1r STA
	  )
		th_rssi = 40;
	else
		th_rssi = 63;

	if((maxTP < tp_2nd*2 && (rssi_maxTp < th_rssi || rssi_2ndTp < th_rssi)))
		pstat_chosen = NULL;
	else if(maxTP >= tp_2nd*2 && rssi_maxTp < th_rssi)
		pstat_chosen = NULL;

out_switch_ant_enable:
	return pstat_chosen;
}
#endif


void dynamic_response_rate(struct rtl8192cd_priv *priv, short rssi)
{
		
		if(rssi<30){
			if(priv->pmib->dot11RFEntry.phyBandSelect & PHY_BAND_5G){
				if(priv->pshare->current_rsp_rate !=0x10){
					RTL_W16(RRSR,0x10);
					priv->pshare->current_rsp_rate=0x10;
					//SDEBUG("current_rsp_rate=%x\n" ,priv->pshare->current_rsp_rate);
				}
			}else if(priv->pmib->dot11RFEntry.phyBandSelect & PHY_BAND_2G){
				if(priv->pshare->current_rsp_rate!=0x1f){
					RTL_W16(RRSR,0x1f);
					priv->pshare->current_rsp_rate=0x1f;
				}
			}

		}else if(rssi>35){
			if(priv->pmib->dot11RFEntry.phyBandSelect & PHY_BAND_5G){
				
#if (MU_BEAMFORMING_SUPPORT == 1)
				PRT_BEAMFORMING_INFO		pBeamInfo = &(priv->pshare->BeamformingInfo);

				if(priv->pmib->dot11RFEntry.txbf_mu && (OPMODE & WIFI_STATION_STATE) && (pBeamInfo->beamformer_mu_cnt>0) ){ 
					if(priv->pshare->current_rsp_rate!=0x950){
						RTL_W16(RRSR,0x950); 
						RTL_W8(0x6DF,0x4B); //init CSI rate 54M
						priv->pshare->current_rsp_rate=0x950;
					}	

				}else
#endif
				{
					if(priv->pshare->current_rsp_rate!=0x150){
						RTL_W16(RRSR,0x150);
						priv->pshare->current_rsp_rate=0x150;
					}		
				}
			}else if(priv->pmib->dot11RFEntry.phyBandSelect & PHY_BAND_2G){
				if(priv->pshare->current_rsp_rate!=0x15f){
					RTL_W16(RRSR,0x15f);
					priv->pshare->current_rsp_rate=0x15f;
				}
			}
		}	
}

#ifdef RSSI_MIN_ADV_SEL
void collect_min_rssi_data(struct rtl8192cd_priv *priv, struct stat_info *pstat)
{
	struct priv_shared_info *pshare = priv->pshare;
	int i;
	
	if (0 == pshare->rf_ft_var.rssi_min_advsel)
		return;
	
	for (i = (int)pshare->min_rssi_data_cnt-1; i >= 0; --i) {
		if (pstat->rssi < pshare->min_rssi_data[i].rssi) {
			if (i != NR_RSSI_MIN_DATA-1) {
				memcpy(&pshare->min_rssi_data[i+1],
					&pshare->min_rssi_data[i], sizeof(struct rssi_search_entry));
			}
		} else
			break;
	}
	
	if (i != NR_RSSI_MIN_DATA-1) {
		++i;
		pshare->min_rssi_data[i].rssi = pstat->rssi;
		pshare->min_rssi_data[i].tx_rate = pstat->current_tx_rate;
		pshare->min_rssi_data[i].throughput = 
			(pstat->tx_avarage + pstat->rx_avarage) >> 17;
		if (pshare->min_rssi_data_cnt < NR_RSSI_MIN_DATA)
			pshare->min_rssi_data_cnt++;
	}
}

#define RSSI_MIN_LIMIT		15
void select_rssi_min_from_data(struct rtl8192cd_priv *priv)
{
	struct priv_shared_info *pshare = priv->pshare;
	struct rssi_search_entry *entry;
	unsigned char rssi_min, rssi_max;
	unsigned char loRate;
	int FA_counter;
	
	if (pshare->min_rssi_data_cnt <= 1) {
		pshare->rssi_min_prev = pshare->rssi_min;
		return;
	}

	entry = &pshare->min_rssi_data[0];
	loRate = ((entry->tx_rate <= _9M_RATE_)
		|| (_MCS0_RATE_ == entry->tx_rate) || (_MCS1_RATE_ == entry->tx_rate));
	rssi_min = entry->rssi;
	
	rssi_max = pshare->min_rssi_data[pshare->min_rssi_data_cnt-1].rssi;
	if ((rssi_min < RSSI_MIN_LIMIT) && (rssi_max >= RSSI_MIN_LIMIT))
		rssi_min = RSSI_MIN_LIMIT;
	
	FA_counter = ODMPTR->false_alm_cnt.cnt_all;
	if (loRate || (FA_counter >= 512)) {
		if (FA_counter > 2500)
			rssi_min = rssi_min + 8;
		else
			rssi_min = rssi_min + 5;
		if (rssi_min > rssi_max)
			rssi_min = rssi_max;
	}
	if (rssi_min + 2 < pshare->rssi_min_prev)
		rssi_min = pshare->rssi_min_prev -2;
	
	pshare->rssi_min = rssi_min;
	pshare->rssi_min_prev = pshare->rssi_min;
}
#endif // RSSI_MIN_ADV_SEL

#ifdef RTK_ATM//calc per SSID client's burst size
const u2Byte CCK_RATE[4] = {1, 2, 5,  11 }; /*CCK*/
const u2Byte OFDM_RATE[8] = {6, 9, 12, 18, 24, 36, 48, 54 };/*OFDM*/

static void atm_set_statxrate_idx(struct rtl8192cd_priv *priv, struct stat_info *pstat)
{
	int i;
	//memset(pstat->atm_tx_rate_id, 0x0, sizeof(pstat->atm_tx_rate_id));
	
	if(pstat->current_tx_rate >= 0x90){//VHT
		pstat->atm_tx_rate_id[0]= 2;//VHT

		pstat->atm_tx_rate_id[1]= MIN_NUM(pstat->tx_bw, 2);//bw
		pstat->atm_tx_rate_id[2]= ((pstat->ht_current_tx_info&TX_USE_SHORT_GI)?1:0);//sg
		pstat->atm_tx_rate_id[3]= (pstat->current_tx_rate - 0x90);
		
	} else if (is_MCS_rate(pstat->current_tx_rate)){//HT
		pstat->atm_tx_rate_id[0]= 1;//HT

		pstat->atm_tx_rate_id[1]= ((pstat->ht_current_tx_info&BIT(0))?1:0);//bw
		pstat->atm_tx_rate_id[2]= ((pstat->ht_current_tx_info&BIT(1))?1:0);//sg
		pstat->atm_tx_rate_id[3]= (pstat->current_tx_rate&0xf);//phy rate
		
	} else {
		pstat->atm_tx_rate_id[0]= 0;//OFDM_CCK
		
		if(priv->pmib->dot11RFEntry.phyBandSelect == PHY_BAND_2G){
			pstat->atm_tx_rate_id[1]= 0;//2G
			pstat->atm_tx_rate_id[2] = 3;//default

			for(i=0;i<4;i++){
				if(pstat->current_tx_rate/2 == CCK_RATE[i]){
					pstat->atm_tx_rate_id[2]=i;//phy rate
					break;
				}
			}
			
		}else if(priv->pmib->dot11RFEntry.phyBandSelect & PHY_BAND_5G){
			pstat->atm_tx_rate_id[1]= 1;//5G
			pstat->atm_tx_rate_id[2] = 7;//default

			for(i=0;i<8;i++){
				if(pstat->current_tx_rate/2 == OFDM_RATE[i]){
					pstat->atm_tx_rate_id[2]=i;//phy rate
					break;
				}
			}
		}					
	}

	//if ((priv->up_time % 2) == 0)
	//	panic_printk("cap=%d bw=%d sg=%d rid=%d\n", 
	//		pstat->atm_tx_rate_id[0], pstat->atm_tx_rate_id[1], pstat->atm_tx_rate_id[2], pstat->atm_tx_rate_id[3]);
}

static void atm_set_statime(struct rtl8192cd_priv *priv)
{
	unsigned int atm_time_per_sta=0;//average percetage of sta
	struct stat_info *pstat;
	struct list_head *phead, *plist;
	int vap_cnt = 0, iftime = 0;
#ifdef SMP_SYNC
    unsigned long flags = 0;
#endif

#ifdef MBSSID
	vap_cnt = GET_ROOT(priv)->vap_count;
#endif
	
	// 1:ssid auto 2:ssid manual 3:sta auto 4:sta manual
	if(priv->pshare->rf_ft_var.atm_mode == 1){
		//equal airtime to every interface then equal interface airtime to interface sta
		iftime = 100/(vap_cnt+1);
		atm_time_per_sta = iftime/priv->atm_sta_num;
	}
	else if(priv->pshare->rf_ft_var.atm_mode == 2){
		//equal pre-set interface airtime to interface sta
		atm_time_per_sta = priv->atm_iftime/priv->atm_sta_num;		
	}
	else if(priv->pshare->rf_ft_var.atm_mode == 3){
		//equal airtime to every sta
		atm_time_per_sta = 100/priv->pshare->atm_ttl_stanum;
	}
	else if(priv->pshare->rf_ft_var.atm_mode == 4){
		//equal rest airtime to no pre-set client
		atm_time_per_sta = (100-priv->pshare->atm_ttl_match_statime)/(priv->pshare->atm_ttl_stanum-priv->pshare->atm_ttl_match_stanum);
	}

#if 0//for debug
	if ((priv->up_time % 2)==0){
		printk("\n[ATM] [%s] [1/%d][%d%%] has %d sta(-%d), per_cli=%d%%\n", 
				priv->dev->name, (GET_ROOT(priv)->vap_count+1), 
				priv->atm_iftime, priv->atm_sta_num, 
				priv->atm_match_sta_num, atm_time_per_sta);
	}
#endif

	if(atm_time_per_sta == 0){		
		//printk("[ATM][WARNING] atm_time_per_sta = 0\n");
		atm_time_per_sta = 1;
	}

	phead = &priv->asoc_list;
	extern int query_vht_rate(struct stat_info *pstat);
	unsigned char *rate;

	SMP_LOCK_ASOC_LIST(flags);
	
	plist = phead->next;
	while(plist != phead){
		pstat = list_entry(plist, struct stat_info, asoc_list);		

		//printk("current_tx_rate = %d\n",pstat->current_tx_rate);

		//tx rate of sta
#ifdef RTK_AC_SUPPORT			
		if(pstat->current_tx_rate >= VHT_RATE_ID)
			pstat->atm_tx_rate = query_vht_rate(pstat);
		else
#endif			
		if (is_MCS_rate(pstat->current_tx_rate))
		{
			rate = (unsigned char *)MCS_DATA_RATEStr[(pstat->ht_current_tx_info&BIT(0))?1:0][(pstat->ht_current_tx_info&BIT(1))?1:0][(pstat->current_tx_rate - HT_RATE_ID)];
			pstat->atm_tx_rate = _atoi(rate, 10);
		}
		else
			pstat->atm_tx_rate = pstat->current_tx_rate/2;

		if(priv->pshare->rf_ft_var.atm_chk_newrty)
			atm_set_statxrate_idx(priv, pstat);
#if 0
		printk("[ATM] STA[%02x] atm_tx_rate=%d\n", pstat->cmn_info.mac_addr[5], pstat->atm_tx_rate);
#endif
		//assign atm_sta_time to client
		if(priv->pshare->rf_ft_var.atm_mode == 4)// mode=4, sta manual
		{
			if(pstat->atm_match_sta_time != 0)
				pstat->atm_sta_time = pstat->atm_match_sta_time;
			else
				pstat->atm_sta_time = atm_time_per_sta;
		}
		else//mode=1,2,3
			pstat->atm_sta_time = atm_time_per_sta;
			
			
#if 0//for debug
		if ((priv->up_time % 2) == 0)
			printk("[ATM] STA[%02x] txrate=%d occupy %d %% in [%s][%d%%]\n", 
				pstat->cmn_info.mac_addr[5], pstat->atm_tx_rate, pstat->atm_sta_time, 
				priv->dev->name, priv->atm_iftime);
#endif
		if (plist == plist->next)
			break;
		plist = plist->next;
	}

    SMP_UNLOCK_ASOC_LIST(flags);
}

static void atm_set_burst_size(struct rtl8192cd_priv *priv)
{
	int i, tx_rate=0, txrate_ratio=0;
	int enable_atm_swq=0, chg=0;
	int	is_low_tp=1;
	struct stat_info *pstat;
	unsigned int tx_avarage_all = 0;
	
	priv->pshare->atm_min_burstsize = 0xffff;
	priv->pshare->atm_min_txrate = 0xffff;
	priv->pshare->atm_max_burstsize = 0;
	priv->pshare->atm_max_txrate = 0;
	
	//priv->pshare->atm_ttl_stanum = 0;
	
	//find the min burst packet number
	for(i=0; i<NUM_STAT; i++) {
		if (priv->pshare->aidarray[i] && (priv->pshare->aidarray[i]->used == TRUE)){
			pstat = &(priv->pshare->aidarray[i]->station);

			//sta tx rate	
			//min
			if(pstat->atm_tx_rate < priv->pshare->atm_min_txrate)
				priv->pshare->atm_min_txrate = pstat->atm_tx_rate;
			//max
			if(pstat->atm_tx_rate > priv->pshare->atm_max_txrate)
				priv->pshare->atm_max_txrate = pstat->atm_tx_rate;

			//sta burst size
			//min
			if((pstat->atm_tx_rate*pstat->atm_sta_time) < priv->pshare->atm_min_burstsize)
				priv->pshare->atm_min_burstsize = pstat->atm_tx_rate*pstat->atm_sta_time;
			//max
			if((pstat->atm_tx_rate*pstat->atm_sta_time) > priv->pshare->atm_max_burstsize)
				priv->pshare->atm_max_burstsize = pstat->atm_tx_rate*pstat->atm_sta_time;
			
			pstat->atm_burst_size = pstat->atm_tx_rate*pstat->atm_sta_time;
			
			//priv->pshare->atm_ttl_stanum++;

			//200K~800K	25000
			//800K~2M	100000
			//2M~4M	250000
			//4M~15M	625000
			//15M~110M	1875000
			//110M~	13750000

			//check if atm swq on/off

			//one client tp > 15M, swq turn on
			if(pstat->tx_avarage >  1875000)//15M~110M
				enable_atm_swq = 1;

			//all client tp < 4M, swq turn off
			if(pstat->tx_avarage > 625000 && priv->pshare->atm_swq_en == 1)//4M~15M
				enable_atm_swq = 1;

			//if(pstat->tx_avarage > 625000 && is_low_tp == 1)
			//	is_low_tp = 0;

			tx_avarage_all += pstat->tx_avarage;

		}
	}

#if 0
	//max/min tx rate
	txrate_ratio = priv->pshare->atm_max_txrate/priv->pshare->atm_min_txrate;
	
	
	//adjust factor by max/min txrate ratio
	if(txrate_ratio < priv->pshare->rf_ft_var.atm_rlo)
	{
		//txrate_ratio<6
		//every client have similar tx rate. that max/min < lo
		priv->pshare->atm_burst_base = priv->pshare->rf_ft_var.atm_aggmax;//min burst unit
		priv->pshare->atm_timer = priv->pshare->rf_ft_var.atm_sto;//short timer				
	}
	else if(txrate_ratio<priv->pshare->rf_ft_var.atm_rhi && 
			txrate_ratio>=priv->pshare->rf_ft_var.atm_rlo)
	{
		//10>txrate_ratio>=6	
		//client has different tx rate, that hi> max.min >lo		
		priv->pshare->atm_burst_base = priv->pshare->rf_ft_var.atm_aggmin;//min burst unit
		priv->pshare->atm_timer = priv->pshare->rf_ft_var.atm_mto;//long timer
		if(enable_atm_swq == 0 && !is_low_tp)
			enable_atm_swq = 1;
	}
	else
	{
		//txrate_ratio>=10
		//client has very big gap in txrate, that max.min > hi
		priv->pshare->atm_burst_base = priv->pshare->rf_ft_var.atm_aggmin;//min burst unit
		priv->pshare->atm_timer = priv->pshare->rf_ft_var.atm_lto;//long timer
		if(enable_atm_swq == 0 && !is_low_tp)
			enable_atm_swq = 1;
	}
#else
	//priv->pshare->atm_burst_base = priv->pshare->rf_ft_var.atm_aggmax;
#ifndef SMP_LOAD_BALANCE_SUPPORT
	if (tx_avarage_all > 13750000)			 // 110M~
		priv->pshare->atm_timer = priv->pshare->rf_ft_var.atm_sto;
	else if (tx_avarage_all > 1875000)		//15M~110M
		priv->pshare->atm_timer = priv->pshare->rf_ft_var.atm_mto;
	else if (tx_avarage_all > 625000)		//4M~15M
		priv->pshare->atm_timer = priv->pshare->rf_ft_var.atm_lto;
#else
	priv->pshare->atm_timer = 1;
#endif
#endif

	// if there are more than 8 clients, enable atm swq anyway
	if(priv->pshare->atm_ttl_stanum >= 8)
		enable_atm_swq = 1;

	//force atm swq
	if(priv->pshare->rf_ft_var.atm_swqf == 1)
		enable_atm_swq = 1;

	if(enable_atm_swq){
		if(priv->pshare->atm_swq_en == 0){
			printk("[ATM] atm_swq_en on\n");
			priv->pshare->atm_swq_en = 1;			
			chg = 1;
		}
	}
	else{
		if(priv->pshare->atm_swq_en == 1){
			printk("[ATM] atm_swq_en off\n");
			priv->pshare->atm_swq_en = 0;
			priv->pshare->atm_timer_init = 0;//turn off timer
			chg = 1;
		}
	}

	//calc burst num
	if(priv->pshare->atm_min_burstsize != 0xffff){
		//printk("[ATM] atm_min_burstsize = %d\n", priv->pshare->atm_min_burstsize);
		for(i=0; i<NUM_STAT; i++) {
			if (priv->pshare->aidarray[i] && (priv->pshare->aidarray[i]->used == TRUE)){
				pstat = &(priv->pshare->aidarray[i]->station);
				pstat->atm_is_maxsta = 0;

				if(pstat->atm_adj_factor == 0)
					pstat->atm_adj_factor = 100;
				
				if((pstat->atm_tx_rate*pstat->atm_sta_time) == priv->pshare->atm_min_burstsize){
					if(priv->pshare->rf_ft_var.atm_chk_txtime)
						pstat->atm_burst_num = (priv->pshare->rf_ft_var.atm_quota*pstat->atm_adj_factor)/100;
					else
						pstat->atm_burst_num = priv->pshare->rf_ft_var.atm_quota;
				}else{					
					if(priv->pshare->rf_ft_var.atm_chk_txtime)
						pstat->atm_burst_num = (((pstat->atm_burst_size*priv->pshare->rf_ft_var.atm_quota)/priv->pshare->atm_min_burstsize)*pstat->atm_adj_factor)/100;
					else
						pstat->atm_burst_num = ((pstat->atm_burst_size*priv->pshare->rf_ft_var.atm_quota)/priv->pshare->atm_min_burstsize);
				}

				//check if the best client
				if(priv->pshare->atm_max_burstsize==pstat->atm_burst_size && priv->pshare->rf_ft_var.atm_chk_hista)
					pstat->atm_is_maxsta = 1;

				//if swq on/off, reset all param in sta
				if(chg){
					pstat->atm_burst_sent = 0;//reset when af swq enable
					pstat->atm_tx_time_static = 0;
					pstat->atm_adj_factor = 100;
					pstat->atm_tx_time = 0;
					pstat->atm_sta_time = 0;

					pstat->atm_full_sent_cnt = 0;
					pstat->atm_swq_sent_cnt = 0;
					pstat->atm_wait_cnt = 0;
					pstat->atm_swq_sent_cnt = 0;
					pstat->atm_drop_cnt = 0;
					
					pstat->atm_is_maxsta = 0;
					pstat->atm_swq_full = 0;

					pstat->atm_txbd_full[0] = 0;
					pstat->atm_txbd_full[1] = 0;
					pstat->atm_txbd_full[2] = 0;
					pstat->atm_txbd_full[3] = 0;
				}
			}
		}
	}	
}

//#define ATM_ADJUST_TIME 10

static void atm_check_statime(struct rtl8192cd_priv *priv)
{
	int i=0,j=0;
	struct stat_info *pstat;

	priv->pshare->atm_ttl_match_statime = 0;//reset to 0
	priv->pshare->atm_ttl_match_stanum = 0;//reset to 0
	priv->pshare->atm_ttl_stanum = 0;

	//check dedicated client exist
	for(i=0; i<NUM_STAT; i++) {
		if (priv->pshare->aidarray[i] && (priv->pshare->aidarray[i]->used == TRUE)){
			pstat = &(priv->pshare->aidarray[i]->station);

			pstat->atm_match_sta_time = 0;			
			priv->pshare->atm_ttl_stanum++;//ttl client in this radio 2.4/5G

			//check atm_mode = 4
			if(priv->pshare->rf_ft_var.atm_mode == 4){
				for(j=0; j<NUM_STAT; j++){
					if(priv->pshare->rf_ft_var.atm_sta_info[j].atm_time != 0){
						if(pstat->cmn_info.mac_addr[0] == priv->pshare->rf_ft_var.atm_sta_info[j].hwaddr[0] &&
							pstat->cmn_info.mac_addr[1] == priv->pshare->rf_ft_var.atm_sta_info[j].hwaddr[1] &&
							pstat->cmn_info.mac_addr[2] == priv->pshare->rf_ft_var.atm_sta_info[j].hwaddr[2] &&
							pstat->cmn_info.mac_addr[3] == priv->pshare->rf_ft_var.atm_sta_info[j].hwaddr[3] &&
							pstat->cmn_info.mac_addr[4] == priv->pshare->rf_ft_var.atm_sta_info[j].hwaddr[4] &&
							pstat->cmn_info.mac_addr[5] == priv->pshare->rf_ft_var.atm_sta_info[j].hwaddr[5])
						{
							//sta time accumelate
							priv->pshare->atm_ttl_match_statime += priv->pshare->rf_ft_var.atm_sta_info[j].atm_time;
							priv->pshare->atm_ttl_match_stanum++;
							pstat->atm_match_sta_time = priv->pshare->rf_ft_var.atm_sta_info[j].atm_time;								
							break;
						}
						else if(pstat->sta_ip[0] == priv->pshare->rf_ft_var.atm_sta_info[j].ipaddr[0] &&
								pstat->sta_ip[1] == priv->pshare->rf_ft_var.atm_sta_info[j].ipaddr[1] &&
								pstat->sta_ip[2] == priv->pshare->rf_ft_var.atm_sta_info[j].ipaddr[2] &&
								pstat->sta_ip[3] == priv->pshare->rf_ft_var.atm_sta_info[j].ipaddr[3])
						{							
							priv->pshare->atm_ttl_match_statime += priv->pshare->rf_ft_var.atm_sta_info[j].atm_time;
							priv->pshare->atm_ttl_match_stanum++;
							pstat->atm_match_sta_time = priv->pshare->rf_ft_var.atm_sta_info[j].atm_time;								
							break;		
						}
					}					
				}
			}
		}
	}
}

#ifdef TXRETRY_CNT
static void atm_calc_txretrytime(struct rtl8192cd_priv *priv, struct stat_info *pstat)
{
	int i, bw=0, sg=0, rate_idx=0;
	int retry_times=pstat->atm_txretry_avg;
	unsigned char *ht_rate;
	unsigned int ht_rate2;

	#ifdef RTK_AC_SUPPORT
	extern const u2Byte VHT_MCS_DATA_RATE[3][2][40];
	#endif
	extern const unsigned char* MCS_DATA_RATEStr[2][2][32];

	//if ((priv->up_time % 2) == 0)
	//	panic_printk("cap:%d bw=%d sg=%d rid=%d\n", 
	//		pstat->atm_tx_rate_id[0], pstat->atm_tx_rate_id[1], pstat->atm_tx_rate_id[2], pstat->atm_tx_rate_id[3]);

#ifdef RTK_AC_SUPPORT
	//VHT rate fall back txtime
	if(pstat->atm_tx_rate_id[0]==2){

		bw = pstat->atm_tx_rate_id[1];
		sg = pstat->atm_tx_rate_id[2];
		rate_idx = pstat->atm_tx_rate_id[3];//init rate

		while(retry_times>0){

			//rate fall back
			if(rate_idx>0)
			{
				rate_idx--;
				//panic_printk("VHT rate fallback from %d to %d\n", 
				//	(VHT_MCS_DATA_RATE[bw][sg][rate_idx+1]>>1), (VHT_MCS_DATA_RATE[bw][sg][rate_idx]>>1));
				pstat->atm_tx_time += ((pstat->tx_bytes_1s*8)/((VHT_MCS_DATA_RATE[bw][sg][rate_idx]>>1)*1024));
				retry_times--;
			}

			if(rate_idx==0 && retry_times>0){
				rate_idx = 16;//HT
				pstat->atm_tx_rate_id[0]=1;//fall back to HT rate
				break;
			}
		}
	}
#endif

	//HT rate fall back txtime
	if(pstat->atm_tx_rate_id[0]==1){
		
		bw = pstat->atm_tx_rate_id[1];
		sg = pstat->atm_tx_rate_id[2];
		rate_idx = pstat->atm_tx_rate_id[3];//init rate

		while(retry_times>0){

			//rate fall back
			if(rate_idx>0)
			{
				rate_idx--;
			
				ht_rate = (unsigned char *)MCS_DATA_RATEStr[bw][sg][rate_idx];
				ht_rate2 = _atoi(ht_rate, 10);
				//panic_printk("HT rate fallback from %s to %s(%d)\n", 
				//	MCS_DATA_RATEStr[bw][sg][rate_idx+1], MCS_DATA_RATEStr[bw][sg][rate_idx], ht_rate2);
				pstat->atm_tx_time += ((pstat->tx_bytes_1s*8)/(ht_rate2*1024));					
				retry_times--;
			}

			if(rate_idx==0 && retry_times>0){
				if(priv->pmib->dot11RFEntry.phyBandSelect == PHY_BAND_2G){
					pstat->atm_tx_rate_id[1]=0;
					pstat->atm_tx_rate_id[2]=4;//CCK
				}else if(priv->pmib->dot11RFEntry.phyBandSelect == PHY_BAND_5G){
					pstat->atm_tx_rate_id[1]=1;
					pstat->atm_tx_rate_id[2]=8;//CCK
				}
				pstat->atm_tx_rate_id[0]=0;//fall back to OFDM/CCK rate
				break;
			}
		}
	}

	//OFDM_CCK rate fall back txtime
	if(pstat->atm_tx_rate_id[0]==0){

		rate_idx = pstat->atm_tx_rate_id[2];//init rate		

		if(pstat->atm_tx_rate_id[1]==0){//2G			
			while(retry_times>0){

				//rate fall back
				if(rate_idx>0)
					rate_idx--;

				//panic_printk("CCK rate fallback from %d to %d\n", 
				//	(CCK_RATE[rate_idx+1]), (CCK_RATE[rate_idx]));
				pstat->atm_tx_time += ((pstat->tx_bytes_1s*8)/(CCK_RATE[rate_idx]*1024));				
				retry_times--;
			}
		}
		else if(pstat->atm_tx_rate_id[1]==1){//5G
			while(retry_times>0){

				//rate fall back
				if(rate_idx>0)
					rate_idx--;

				//panic_printk("OFDM rate fallback from %d to %d\n", 
				//	(OFDM_RATE[rate_idx+1]), (OFDM_RATE[rate_idx]));
				pstat->atm_tx_time += ((pstat->tx_bytes_1s*8)/(OFDM_RATE[rate_idx]*1024));				
				retry_times--;
			}
		}
	}
}
#endif

static void atm_calc_txtime(struct rtl8192cd_priv *priv)
{
	int i;
	struct stat_info *pstat;
	
	for(i=0; i<NUM_STAT; i++) {
		if (priv->pshare->aidarray[i] && (priv->pshare->aidarray[i]->used == TRUE)){
			pstat = &(priv->pshare->aidarray[i]->station);
			
			pstat->atm_tx_time = (((pstat->tx_bytes_1s*8)/(pstat->atm_tx_rate*1024))*1000)/1024;
			pstat->atm_tx_time_orig = pstat->atm_tx_time;
							
#if 0//debug and calc tx time			
			if ((priv->up_time % 2) == 0){				
				printk("[ATM] STA[%02x] txrate=%d tx_bytes_1s=%d pkt_burst_num=%d atm_burst_sent=%d atm_tx_time=%d\n", 
						pstat->cmn_info.mac_addr[5], pstat->atm_tx_rate, pstat->tx_bytes_1s, 
						pstat->atm_burst_num, pstat->atm_burst_sent, pstat->atm_tx_time);
			}
#endif

			if(priv->pshare->rf_ft_var.atm_chk_newrty)
			{
#ifdef TXRETRY_CNT			
				pstat->atm_txretry_avg = 0;//reset
	
				pstat->atm_txretry_1s = (pstat->total_tx_retry_cnt-pstat->atm_txretry_pre);
				pstat->atm_txpkt_1s = (pstat->tx_pkts-pstat->atm_txpkt_pre);
				
				if(priv->pshare->rf_ft_var.atm_chk_newrty && (pstat->total_tx_retry_cnt-pstat->atm_txretry_pre)>0)
					pstat->atm_txretry_avg = ((pstat->total_tx_retry_cnt-pstat->atm_txretry_pre)/(pstat->tx_pkts-pstat->atm_txpkt_pre))+1;
				else
					pstat->atm_txretry_avg = 0; 		
	
				//if ((priv->up_time % 2) == 0)
				//	panic_printk("tx_time_orig: %d ms\n", pstat->atm_tx_time);
				if(pstat->atm_txretry_avg > 0)
					atm_calc_txretrytime(priv, pstat);
#endif				
			}
			else
			{
				//use retry and retry time inrcease ratio to calc tx time
				//count retry every 1 sec
#ifdef TXRETRY_CNT
				// retry_ratio = ((total packet sent)+(total retry))/(total packet sent)
				if((pstat->tx_pkts-pstat->atm_txpkt_pre)>0){
					pstat->atm_txretry_ratio = 
					(((pstat->tx_pkts-pstat->atm_txpkt_pre)+(pstat->total_tx_retry_cnt-pstat->atm_txretry_pre))*100)/(pstat->tx_pkts-pstat->atm_txpkt_pre);
				}else{
					pstat->atm_txretry_ratio = 0;
				}
				//considering rate fall back for retry
				if(priv->pshare->rf_ft_var.atm_rty_ratio > 0)
					pstat->atm_txretry_ratio = (pstat->atm_txretry_ratio*priv->pshare->rf_ft_var.atm_rty_ratio)/100;
	
				//record packet and retry now
				pstat->atm_txpkt_pre = pstat->tx_pkts;
				pstat->atm_txretry_pre = pstat->total_tx_retry_cnt;
	
				//actual tx time after including retry num
				if(pstat->atm_txretry_ratio != 0)
					pstat->atm_tx_time = (pstat->atm_tx_time*pstat->atm_txretry_ratio)/100; 					
#endif
			}
	
			//accumulate interface tx time
			priv->atm_ttl_txtime += pstat->atm_tx_time;

			//accumulate sta tx time in adj period
			pstat->atm_tx_time_static += pstat->atm_tx_time;			

#if 0			
			if((priv->up_time % ATM_ADJUST_TIME) == 0){
#ifdef TXRETRY_CNT
				// retry_ratio = ((total packet sent)+(total retry))/(total packet sent)
				pstat->atm_txretry_ratio = 
					(((pstat->tx_pkts-pstat->atm_txpkt_pre)+(pstat->total_tx_retry_cnt-pstat->atm_txretry_pre))*100)/(pstat->tx_pkts-pstat->atm_txpkt_pre);

				//record packet and retry now
				pstat->atm_txpkt_pre = pstat->tx_pkts;
				pstat->atm_txretry_pre = pstat->total_tx_retry_cnt;

				//actual tx time after including retry num
				if(pstat->atm_txretry_ratio != 0)
					priv->atm_ttl_txtime += ((pstat->atm_tx_time_static/ATM_ADJUST_TIME)*pstat->atm_txretry_ratio)/100;
				else
#endif

					priv->atm_ttl_txtime += (pstat->atm_tx_time_static/ATM_ADJUST_TIME);
				
#if 0//debug				
				printk("[ATM] STA[%02x] txrate=%d tx_time_avg=%d\n", 
					pstat->cmn_info.mac_addr[5],pstat->atm_tx_rate, pstat->atm_tx_time_static/ATM_ADJUST_TIME);
#endif
			}
#endif			
		}
	}

	//calc adjust factor for burst num
	int sta_txtime=0;	
	if((priv->up_time % priv->pshare->rf_ft_var.atm_adj_time) == 0){
		for(i=0; i<NUM_STAT; i++) {
			if (priv->pshare->aidarray[i] && (priv->pshare->aidarray[i]->used == TRUE)){
				
				pstat = &(priv->pshare->aidarray[i]->station);

				//the real tx time sta should occupy
				sta_txtime = (priv->atm_ttl_txtime*pstat->atm_sta_time)/100;
				//increase or decrease ratio for this sta
				if (pstat->atm_tx_time_static)
					pstat->atm_adj_factor = (sta_txtime*100)/pstat->atm_tx_time_static;
				else
					pstat->atm_adj_factor = 0;
				//printk("[ATM] STA[%02x] should get %d but now %d tx time, adj=%d/100\n", 
				//	pstat->cmn_info.mac_addr[5], sta_txtime, pstat->atm_tx_time_static/ATM_ADJUST_TIME, pstat->atm_adj_factor);

				//reset accumuler tx time
				pstat->atm_tx_time_static = 0;				
			}
		}
		//reset interface tx time
		priv->atm_ttl_txtime = 0;
	}
}
#endif//RTK_ATM

#ifdef STA_RATE_STATISTIC
const u2Byte CCK_OFDM_DATA_RATE[12] = {1, 2, 5, 11, /*CCK*/
									6, 9, 12, 18, 24, 36, 48, 54/*OFDM*/};
static void sta_rate_statistics(struct stat_info *pstat)
{
	int tx_idx=0xff, rx_idx=0xff, i=0;
	unsigned int tmp=0;
	
	//check tx rate
#ifdef RTK_AC_SUPPORT	
	if(is_VHT_rate(pstat->current_tx_rate)){
		//NSS1 MCS0~9, NSS2 MCS0~9, NSS3 MCS0~9
		tx_idx = (pstat->current_tx_rate - VHT_RATE_ID) + (CCK_OFDM_RATE_NUM+HT_RATE_NUM);
		//panic_printk("[%d] tx rate = NSS%d MCS%d\n", 
		//	tx_idx, 
		//	(tx_idx-(CCK_OFDM_RATE_NUM+HT_RATE_NUM))/10+1, 
		//	(tx_idx-(CCK_OFDM_RATE_NUM+HT_RATE_NUM))%10);
	}
	else
#endif
	if(is_MCS_rate(pstat->current_tx_rate)){
		//MCS0~15 MCS16~31: 12~
		tx_idx = (pstat->current_tx_rate - HT_RATE_ID) + CCK_OFDM_RATE_NUM;
		//panic_printk("[%d] tx rate = MCS%d\n", tx_idx, tx_idx-CCK_OFDM_RATE_NUM);
	}else{
		//CCK:0~3, OFDM:4~11
		tmp = pstat->current_tx_rate/2;		
		for(i=0; i<12; i++){
			if(tmp == CCK_OFDM_DATA_RATE[i]){
				tx_idx = i;
				break;
			}
		}
		//panic_printk("[%d] tx rate = %d\n", tx_idx, tmp);
		if(tx_idx == 0xff)
			panic_printk("\n\nUndefined tx rate=%d\n\n", tmp);
	}

	//check rx rate
#ifdef RTK_AC_SUPPORT	
	if(is_VHT_rate(pstat->rx_rate)){
		//NSS1 MCS0~9, NSS2 MCS0~9, NSS3 MCS0~9
		rx_idx = (pstat->rx_rate - VHT_RATE_ID) + (CCK_OFDM_RATE_NUM+HT_RATE_NUM);
		//panic_printk("[%d] rx rate = NSS%d MCS%d\n", 
		//	rx_idx, 
		//	(rx_idx-(CCK_OFDM_RATE_NUM+HT_RATE_NUM))/10+1, 
		//	(rx_idx-(CCK_OFDM_RATE_NUM+HT_RATE_NUM))%10);
	}
	else
#endif		
	if(is_MCS_rate(pstat->rx_rate)){
		//MCS0~15 MCS16~31
		rx_idx = (pstat->rx_rate - HT_RATE_ID) + CCK_OFDM_RATE_NUM;
		//panic_printk("[%d] rx rate = MCS%d\n", rx_idx, rx_idx-CCK_OFDM_RATE_NUM);
	}else{
		//CCK:0~3, OFDM:4~11
		tmp = pstat->rx_rate/2;		
		for(i=0; i<12; i++){
			if(tmp == CCK_OFDM_DATA_RATE[i]){
				rx_idx = i;
				break;
			}
		}
		//panic_printk("[%d] rx rate = %d\n", rx_idx, tmp);
		if(rx_idx == 0xff)
			panic_printk("\n\nUndefined rx rate=%d\n\n", tmp);
	}

	if(tx_idx < STA_RATE_NUM)
		pstat->txrate_stat[tx_idx]++;
	else
		panic_printk("\n\nUndefined tx rate idx=%d, tx rate=%d\n\n", tx_idx, pstat->current_tx_rate);

	if(rx_idx < STA_RATE_NUM)
		pstat->rxrate_stat[rx_idx]++;
	else
		panic_printk("\n\nUndefined rx rate idx=%d, rx rate=%d\n\n", rx_idx, pstat->rx_rate);
}
#endif

#if defined(CONFIG_RTL8672) || defined(NOT_RTK_BSP)
void display_rssi_dump(struct rtl8192cd_priv *priv, struct stat_info *pstat)
{
	unsigned char retry_str[30] = {0};
	unsigned char mimorssi[4];
	unsigned int current_tx_rate;
	unsigned char txforce = priv->pshare->rf_ft_var.txforce;
	unsigned int FA_total_cnt = 0;
	unsigned int CCA_total_cnt= 0;
	unsigned int dump_tx_tp = (unsigned int)(pstat->tx_avarage>>17);
	unsigned int rx_try_ratio;
	unsigned int rx_try_cnt;

#if defined(TXRETRY_CNT)
	if (is_support_TxRetryCnt(priv))
	{
		if(pstat->cur_tx_ok || pstat->cur_tx_fail)
			sprintf(retry_str," [%2d%%] [%2d%%]", pstat->cur_tx_retry_ratio, pstat->cur_rx_retry_ratio);
		else
			sprintf(retry_str," [N/A] ");
	}
	else		
#endif
	{
		sprintf(retry_str," ");
	}

	/* transform txforce rate to driver rate */
	if (txforce != 0xff)
	{
		if (txforce >= 44)		
			current_tx_rate = (VHT_RATE_ID + txforce - 44);		
		else if (txforce >= 12)		
			current_tx_rate = (HT_RATE_ID + txforce - 12);		
		else
			current_tx_rate = dot11_rate_table[txforce];
	}
	else
		current_tx_rate = pstat->current_tx_rate;

#ifdef USE_OUT_SRC
#ifdef _OUTSRC_COEXIST
	if(IS_OUTSRC_CHIP(priv))
#endif
	{
#if (PHYDM_TDMA_DIG_SUPPORT == 1)
		if(ODMPTR->original_dig_restore == 1) {
			FA_total_cnt = ODMPTR->false_alm_cnt.cnt_all;
			CCA_total_cnt = ODMPTR->false_alm_cnt.cnt_cca_all;
		} else {
			FA_total_cnt = ODMPTR->false_alm_cnt_acc.cnt_all_1sec;
			CCA_total_cnt = ODMPTR->false_alm_cnt_acc.cnt_cca_all_1sec;
		}
#else
		FA_total_cnt = ODMPTR->false_alm_cnt.cnt_all;
		CCA_total_cnt = ODMPTR->false_alm_cnt.cnt_cca_all;
#endif		// #if (PHYDM_TDMA_DIG_SUPPORT == 1)
	}
#endif

#if !defined(USE_OUT_SRC) || defined(_OUTSRC_COEXIST)
#ifdef _OUTSRC_COEXIST
	if(!IS_OUTSRC_CHIP(priv))
#endif
	{
		FA_total_cnt = priv->pshare->FA_total_cnt;
		CCA_total_cnt = priv->pshare->CCA_total_cnt;
	}
#endif		

	memcpy(mimorssi, pstat->rf_info.mimorssi, 4);

#ifdef RTK_ATM
	if(priv->pshare->rf_ft_var.atm_en)
	{
		dump_tx_tp = (unsigned int)((pstat->tx_avarage_atm/priv->pshare->rf_ft_var.rssi_dump)>>17);		
		pstat->tx_avarage_atm = 0;		
	}
	else
#endif	
	{
		dump_tx_tp = (unsigned int)(pstat->tx_avarage>>17);
	}
		

	panic_printk("[%d] %d%%%stx%s %s%s%s%s%s%s%d%s rx %s%s%s%s%s%s%d%s ",
		pstat->cmn_info.aid, pstat->rssi, retry_str,
		((txforce != 0xff)?"force ":""),
		((current_tx_rate >= VHT_RATE_ID)) ? "VHT " : "",
		((current_tx_rate >= HT_RATE_ID) && (current_tx_rate < VHT_RATE_ID))? "MCS" : "",
		((current_tx_rate >= _NSS1_MCS0_RATE_) && (current_tx_rate <= _NSS1_MCS9_RATE_)) ? "NSS1 " : "",
		((current_tx_rate >= _NSS2_MCS0_RATE_) && (current_tx_rate <= _NSS2_MCS9_RATE_)) ? "NSS2 " : "",
		((current_tx_rate >= _NSS3_MCS0_RATE_) && (current_tx_rate <= _NSS3_MCS9_RATE_)) ? "NSS3 " : "",
		((current_tx_rate >= _NSS4_MCS0_RATE_) && (current_tx_rate <= _NSS4_MCS9_RATE_)) ? "NSS4 " : "",
		(current_tx_rate >= VHT_RATE_ID) ? ((current_tx_rate - VHT_RATE_ID)%10):((current_tx_rate >= HT_RATE_ID)? (current_tx_rate - HT_RATE_ID) : current_tx_rate/2),					
		(pstat->ht_current_tx_info&BIT(1))? "s" : " ",
		((pstat->rx_rate) >= VHT_RATE_ID)? "VHT " : "",
		((pstat->rx_rate >= _NSS1_MCS0_RATE_) && (pstat->rx_rate <= _NSS1_MCS9_RATE_)) ? "NSS1 " : "",
		((pstat->rx_rate >= _NSS2_MCS0_RATE_) && (pstat->rx_rate <= _NSS2_MCS9_RATE_)) ? "NSS2 " : "",
		((pstat->rx_rate >= _NSS3_MCS0_RATE_) && (pstat->rx_rate <= _NSS3_MCS9_RATE_)) ? "NSS3 " : "",
		((pstat->rx_rate >= _NSS4_MCS0_RATE_) && (pstat->rx_rate <= _NSS4_MCS9_RATE_)) ? "NSS4 " : "",
		((pstat->rx_rate >= HT_RATE_ID) && (pstat->rx_rate < VHT_RATE_ID))? "MCS" : "",
		((pstat->rx_rate) >= VHT_RATE_ID) ? ((pstat->rx_rate - VHT_RATE_ID)%10) : ((pstat->rx_rate >= HT_RATE_ID)? (pstat->rx_rate-HT_RATE_ID) : pstat->rx_rate/2),
		pstat->rx_splcp? "s" : " ");

#if defined(CONFIG_WLAN_HAL_8814AE)
	if(GET_CHIP_VER(priv) == VERSION_8814A)
		panic_printk(KERN_CONT " (ss %d %d %d %d)", mimorssi[0], mimorssi[1], mimorssi[2], mimorssi[3]);
	else
#endif
	{
		switch (priv->pshare->phw->MIMO_TR_hw_support) {
		case RF_1T1R:
			panic_printk(KERN_CONT " (ss %d)", mimorssi[0]);
			break;
		case RF_1T2R:
		case RF_2T2R:
			panic_printk(KERN_CONT " (ss %d %d)", mimorssi[0], mimorssi[1]);
			break;
		case RF_2T3R:
		case RF_3T3R:
			panic_printk(KERN_CONT " (ss %d %d %d)", mimorssi[0], mimorssi[1], mimorssi[2]);
			break;
		case RF_2T4R:
		case RF_3T4R:
		case RF_4T4R:
			panic_printk(KERN_CONT " (ss %d %d %d %d)", mimorssi[0], mimorssi[1], mimorssi[2], mimorssi[3]);
			break;
		default:
			panic_printk(KERN_CONT " (ss %d %d)", mimorssi[0], mimorssi[1]);
			break;
		}
	}
#if (PHYDM_TDMA_DIG_SUPPORT == 1)
		if (ODMPTR->original_dig_restore == 1) {
			panic_printk(KERN_CONT " (FA%4d)(CCA%5d)(DIG 0x%2x)(TP %3d,%3d)",
				FA_total_cnt,
				CCA_total_cnt,
				((GET_CHIP_VER(priv) == VERSION_8198F)||(GET_CHIP_VER(priv) == VERSION_8814B)||(GET_CHIP_VER(priv) == VERSION_8822C)||(GET_CHIP_VER(priv) == VERSION_8812F))? RTL_R8(0x1d70)&0x7f : RTL_R8(0xc50),
				dump_tx_tp,
				(unsigned int)(pstat->rx_avarage>>17));
		} else {
			panic_printk(KERN_CONT " (FA%4d)(CCA%5d)(L-DIG 0x%2x, H-DIG 0x%2x)(TP %3d,%3d)",
				FA_total_cnt,
				CCA_total_cnt,
				ODMPTR->dm_dig_table.low_ig_value,
				ODMPTR->dm_dig_table.cur_ig_value_tdma,
				dump_tx_tp,
				(unsigned int)(pstat->rx_avarage>>17));
		}
#else
		panic_printk(KERN_CONT " (FA %d)(CCA %d)(DIG 0x%x)(TP %d,%d)",
			FA_total_cnt, CCA_total_cnt,
			((GET_CHIP_VER(priv)==VERSION_8198F)||(GET_CHIP_VER(priv)==VERSION_8814B)||(GET_CHIP_VER(priv)==VERSION_8822C)||(GET_CHIP_VER(priv)==VERSION_8812F))?RTL_R8(0x1d70)&0x7f:RTL_R8(0xc50),
			dump_tx_tp, (unsigned int)(pstat->rx_avarage>>17));
#endif
#ifdef SW_TXQ_ATF
	if (priv->pshare->swq_atf_state)
		panic_printk(KERN_CONT "(HWQ %d)", rtl_atomic_read(&pstat->swq.atf_hwpkt_bytes) / 125 / pstat->swq.atf_txrate * pstat->swq.atf_retry_ratio / 100);
#endif
#ifdef RX_CRC_EXPTIMER
	if(priv->pshare->rf_ft_var.crc_enable) {
		panic_printk(KERN_CONT " (CRC %lu %lu)", priv->ext_stats.rx_packets_exptimer, priv->ext_stats.rx_crc_exptimer);
		priv->ext_stats.rx_crc_exptimer = priv->ext_stats.rx_packets_exptimer = 0;
	}
#endif
	panic_printk(KERN_CONT "\n");
}
#endif

static void translate_txforce_to_rateStr(unsigned char *str, unsigned int txforce)
{
	unsigned char dot11_rate_table[]={2,4,11,22,12,18,24,36,48,72,96,108,0};
	
	sprintf(str, "%s%s%s%s%s%s%d", 
		((txforce >= 44)) ? "VHT " : "",
		((txforce >= 12) && (txforce < 44))? "MCS" : "",
		((txforce >= 44) && (txforce < 54)) ? "NSS1 " : "",
		((txforce >= 54) && (txforce < 64)) ? "NSS2 " : "",
		((txforce >= 64) && (txforce < 74)) ? "NSS3 " : "",
		((txforce >= 74) && (txforce < 84)) ? "NSS4 " : "",
		(txforce >= 44) ? ((txforce-44)%10):((txforce >= 12)? txforce-12: dot11_rate_table[txforce]/2)
	);
}

static void translate_rateIndex_to_rateStr(unsigned char *str, unsigned int rate_index)
{
	sprintf(str, "%s%s%s%s%s%s%d", 
			((rate_index >= VHT_RATE_ID)) ? "VHT " : "",
			((rate_index >= HT_RATE_ID) && (rate_index < VHT_RATE_ID))? "MCS" : "",
			((rate_index >= _NSS1_MCS0_RATE_) && (rate_index <= _NSS1_MCS9_RATE_)) ? "NSS1 " : "",
			((rate_index >= _NSS2_MCS0_RATE_) && (rate_index <= _NSS2_MCS9_RATE_)) ? "NSS2 " : "",
			((rate_index >= _NSS3_MCS0_RATE_) && (rate_index <= _NSS3_MCS9_RATE_)) ? "NSS3 " : "",
			((rate_index >= _NSS4_MCS0_RATE_) && (rate_index <= _NSS4_MCS9_RATE_)) ? "NSS4 " : "",
			(rate_index >= VHT_RATE_ID) ? ((rate_index - VHT_RATE_ID)%10):((rate_index >= HT_RATE_ID)? (rate_index - HT_RATE_ID) : rate_index/2)
	);
}

static char * show_sta_trx_rate(struct rtl8192cd_priv *priv, struct stat_info	*pstat)
{
	static char strRate[100]="";
	char strTxRate[100]="";
	char strRxRate[100]="";
	

	
	if(priv->pshare->rf_ft_var.txforce != 0xff)
	{
		unsigned char txforce = priv->pshare->rf_ft_var.txforce;
		unsigned char dot11_rate_table[]={2,4,11,22,12,18,24,36,48,72,96,108,0};
		unsigned char args[200];

		translate_txforce_to_rateStr(strTxRate, txforce);
		translate_rateIndex_to_rateStr(strRxRate, pstat->rx_rate);
		
		sprintf(strRate, "txforce %s%s%s rx %s%s%s",
		strTxRate,
		(pstat->ht_current_tx_info&BIT(1))? "s" : " ",
		(txforce >= 44) ? "":((txforce >= 12)?(txforce >= 22?"	   ":"		"):(dot11_rate_table[txforce]/2 >= 11?" 	   ":"		   ")),
		strRxRate,
		pstat->rx_splcp? "s" : " ",
		(pstat->rx_rate >= VHT_RATE_ID) ? "":((pstat->rx_rate >= HT_RATE_ID)?(pstat->rx_rate >= HT_RATE_ID+10?" 	":" 	 "):(dot11_rate_table[pstat->rx_rate]/2 >= 11?" 	   ":"		   ")));
	} else {
		translate_rateIndex_to_rateStr(strTxRate, pstat->current_tx_rate);		
		translate_rateIndex_to_rateStr(strRxRate, pstat->rx_rate);		
		
		sprintf(strRate, "tx %s%s%s rx %s%s%s",
		strTxRate,
		(pstat->ht_current_tx_info&BIT(1))? "s" : " ",
		(pstat->current_tx_rate >= VHT_RATE_ID) ? "":((pstat->current_tx_rate >= HT_RATE_ID)?(pstat->current_tx_rate >= HT_RATE_ID+10?" 	":" 	 "):(pstat->current_tx_rate/2 >= 11?"		 ":"		 ")),
		strRxRate,
		pstat->rx_splcp? "s" : " ",
		(pstat->rx_rate >= VHT_RATE_ID) ? "  ":((pstat->rx_rate >= HT_RATE_ID)?(pstat->rx_rate >= HT_RATE_ID+10?" 	":" 	 "):(pstat->rx_rate/2 >= 11?"		 ":"		 ")));
	}
	return strRate;
}

#ifdef STA_ROAMING_CHECK
static int RoamingCheck(struct rtl8192cd_priv *priv, struct stat_info *pstat)
{
    int thresh, rssi_gap, time_gap, upvalue, actor;
    thresh = priv->pmib->rlr_profile.RSSIThreshold;
    rssi_gap = priv->pmib->rlr_profile.staRoamingRSSIGap;
    time_gap = priv->pmib->rlr_profile.staRoamingTimeGap;
    upvalue = 100*time_gap;
    
    if(pstat->rssi > thresh + rssi_gap){
        pstat->rtl_link_roaming_value = 0;
        return 0;
    }

    if(pstat->rssi < thresh - rssi_gap){
        return 1;
    }

    if(rssi_gap == 0)
        actor = 100;
    else 
        actor = ((thresh+rssi_gap) - pstat->rssi)*100/rssi_gap; //range: 0~200;

    pstat->rtl_link_roaming_value += actor;

    if(pstat->rtl_link_roaming_value >= upvalue)
        return 1;
    else
        return 0;
}
#endif

void _check_sta_continuous_icverr(struct rtl8192cd_priv *priv, struct stat_info *pstat)
{
	unsigned long kick_icverr = priv->pmib->miscEntry.kick_icverr;

	if (kick_icverr && (pstat->rx_pkts == pstat->rx_pkts_pre)) {
		if (pstat->rx_icverr_pkts) {
			pstat->rx_conti_icverr_pkts += pstat->rx_icverr_pkts;
			pstat->rx_conti_icverr_times++;
		}
		/* If continuous icv error pkts larger than threshold, and over 10 seconds no normal rx pkts,
		   delete this STA */
		if ((pstat->rx_conti_icverr_pkts > kick_icverr) &&
			(pstat->rx_conti_icverr_times >= 10) &&
			(pstat->leave_conti_icverr == 0)) {
			pstat->leave_conti_icverr = 1;
			pstat->rx_conti_icverr_pkts = 0;
			pstat->rx_conti_icverr_times = 0;
			del_station(priv, pstat, DEL_STA_SEND_DEAUTH, _RSON_DEAUTH_STA_LEAVING_);
			priv->cnt_icverr_deauth++;
		}
	}
	else {
		pstat->leave_conti_icverr = 0;
		pstat->rx_conti_icverr_pkts = 0;
		pstat->rx_conti_icverr_times = 0;
	}
	pstat->rx_icverr_pkts = 0;
}

static void assoc_expire(struct rtl8192cd_priv *priv)
{
	struct stat_info	*pstat;
	struct list_head	*phead, *plist;
	unsigned int	ok_curr, ok_pre;
	unsigned int	highest_tp = 0;
	struct stat_info	*pstat_highest=NULL;
    int i,j;
#ifdef SMP_SYNC
    unsigned long flags = 0, flags_xmit = 0;
#endif

#ifdef TX2_BK_QUEUE
    struct stat_info *tx2bk_first_sta=NULL;
    struct stat_info *tx2bk_chk_sta=NULL;
#endif

#ifdef CONFIG_RTL_WLAN_DIAGNOSTIC
	char temp_log[512] = {0};
#endif
#ifdef RTK_ATM
	if(priv->pshare->rf_ft_var.atm_en)
		priv->atm_sta_num = 0;//check sta num of per SSID
#endif

	phead = &priv->asoc_list;
	plist = phead;

	if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE)
		SMP_LOCK_ASOC_LIST(flags);
	while ((plist = asoc_list_get_next(priv, plist)) != phead)
	{
		pstat = list_entry(plist, struct stat_info, asoc_list);
		pstat->link_time++;
		pstat->brfwtbl_to++;

                if(pstat && pstat->rtsdrop_expire_to)
			pstat->rtsdrop_expire_to--;

#if defined(RTK_NL80211) && defined(A4_STA)
		if (OPMODE & WIFI_STATION_STATE) {
			if (!priv->pmib->miscEntry.a4_enable)
				pstat->state &= ~WIFI_A4_STA;
		}
#endif

		if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE)
			SMP_UNLOCK_ASOC_LIST(flags);
#ifdef CONFIG_FON
		int idx=wlan_find_idx_by_linux_name(priv->dev->name);
		Fonclient *pFonClient;
		int isFonClient=0;
		if(is_FON_SSID(idx))
		{
			isFonClient = FON_getClient_byMac(pstat->cmn_info.mac_addr, &pFonClient);
			if(isFonClient)
			{
				updateFonClientStat(pFonClient,pstat);
			}
		}
#endif

#if (MU_BEAMFORMING_SUPPORT == 1)
		if(pstat) {
			if(pstat->force_rate) {
				unsigned char *rate;
#ifdef RTK_AC_SUPPORT
				if(pstat->force_rate >= 44) {
					pstat->current_tx_rate = pstat->force_rate - 44 + 0xa0;
					pstat->mu_tx_rate = query_vht_rate(pstat);
				}
				else
#endif
				if (pstat->force_rate >=12)
				{
					pstat->current_tx_rate = pstat->force_rate - 12 + 0x80;
					rate = (unsigned char *)MCS_DATA_RATEStr[(pstat->ht_current_tx_info&BIT(0))?1:0][(pstat->ht_current_tx_info&BIT(1))?1:0][(pstat->current_tx_rate- HT_RATE_ID)];
					pstat->mu_tx_rate = _atoi(rate, 10);
				}
				else
					pstat->mu_tx_rate = pstat->force_rate/2;
			} else {
				unsigned char *rate;
#ifdef RTK_AC_SUPPORT
				if(pstat->current_tx_rate >= VHT_RATE_ID)
					pstat->mu_tx_rate = query_vht_rate(pstat);
				else
#endif
				if (is_MCS_rate(pstat->current_tx_rate))
				{
					rate = (unsigned char *)MCS_DATA_RATEStr[(pstat->ht_current_tx_info&BIT(0))?1:0][(pstat->ht_current_tx_info&BIT(1))?1:0][(pstat->current_tx_rate - HT_RATE_ID)];
					pstat->mu_tx_rate = _atoi(rate, 10);
				}
				else
					pstat->mu_tx_rate = pstat->current_tx_rate/2;
			}
		}
#endif

#ifdef DOT11K
		pstat->trx_1sec_pkt_delta = (pstat->tx_pkts - pstat->tx_pkts_pre)+(pstat->rx_pkts - pstat->rx_pkts_pre);
		//keep-alive packets timeout
		if (pstat->dka_pkt_timeout > 0)
			pstat->dka_pkt_timeout--;
#endif

#ifdef CLIENT_MODE
		if ((OPMODE & WIFI_STATION_STATE) && (pstat->expire_to > 0)) {
			if ((priv->pshare->rf_ft_var.sta_mode_ps && !priv->ps_state) ||
				(!priv->pshare->rf_ft_var.sta_mode_ps && priv->ps_state)) {
				if (!priv->ps_state)
					priv->ps_state++;
				else
					priv->ps_state = 0;

				issue_PwrMgt_NullData(priv);
			}
#ifdef MULTI_MAC_CLONE
			else if (!memcmp(GET_MIB(priv)->dot11OperationEntry.hwaddr, pstat->sa_addr, MACADDRLEN)) // repeater send null packet
			{
				if (--priv->repeater_to == 0)
				{
					issue_NullData(priv, pstat->cmn_info.mac_addr);
					priv->repeater_to = REPEATER_TO / HZ;
				}
			}
#endif
#if 0//def UNIVERSAL_REPEATER
			else if (IS_VXD_INTERFACE(priv)) // repeater send null packet to remote AP every 30sec
			{
				if(IS_BSSID(priv, pstat->cmn_info.mac_addr)){
					if ((priv->up_time % 30) == 0)						
						issue_NullData(priv, pstat->cmn_info.mac_addr);
					}
			}
#endif			
		}
#endif

#if defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI)
		if (GET_HCI_TYPE(priv) == RTL_HCI_USB || GET_HCI_TYPE(priv) == RTL_HCI_SDIO) {
			// free queued TX packets if STA keep sleeping a long time
			if ((pstat->state & WIFI_SLEEP_STATE) && pstat->expire_to) {
				if (time_after(jiffies, pstat->sleep_time+10*HZ)) {
					free_sta_tx_skb(priv, pstat);
					pstat->sleep_time = jiffies;
				}
			}
		}
#endif

		// Check idle using packet transmit....nctu note it
		ok_curr = pstat->tx_pkts - pstat->tx_fail;
		ok_pre = pstat->tx_pkts_pre - pstat->tx_fail_pre;

#ifdef CONFIG_SPECIAL_ENV_TEST
		if ((priv->pshare->rf_ft_var.spec_env_test_en & BIT(0)) && priv->assoc_num > 1
			&& pstat->expire_to > 1 && (pstat->aggre_mthd & AGGRE_MTHD_MPDU))
		{
			int sn_avg_gap = (priv->assoc_num?(4096/priv->assoc_num): 500);
			int tid=0;
		    
			if (pstat->sn_avg_gap != sn_avg_gap) {
		    	pstat->sn_avg_gap = sn_avg_gap;
#if defined(CONFIG_WLAN_HAL_8814BE)
				if (GET_CHIP_VER(priv) == VERSION_8814B)
				{
					prepare_ADDBAreq(priv, pstat, 6);
					prepare_ADDBAreq(priv, pstat, 0);
				}
				else
#endif
				{
	            issue_ADDBAreq(priv, pstat, 6); // default, VO stream
	            issue_ADDBAreq(priv, pstat, 0);	// usually, BE stream
				}
			}
		} 
#endif

		if (pstat->is_realtek_sta && pstat->IOTPeer == HT_IOT_PEER_REALTEK_8814 && pstat->expire_to > 1) {
		    unsigned int fail_num=0;

		    fail_num = TSF_DIFF(pstat->tx_fail, pstat->tx_fail_pre);
		    if (fail_num){
				pstat->tx_fail_continue += fail_num;
		    	if (pstat->tx_fail_continue > 32) {
#if defined(CONFIG_WLAN_HAL_8814BE)
					if (GET_CHIP_VER(priv) == VERSION_8814B)
						prepare_ADDBAreq(priv, pstat, 0);
					else
#endif
		    		issue_ADDBAreq(priv, pstat, 0); //just do BE queue now
		    		pstat->tx_fail_continue = 0;
		    		pstat->tx_fail_addba_cnt++;
				}

				if (((pstat->tx_fail_cnt++)>5) && ok_curr != ok_pre) {
				    pstat->tx_fail_continue = 0;
				    pstat->tx_fail_cnt = 0;
				}
			} else if ((pstat->tx_fail_cnt++)>5) {
		    	pstat->tx_fail_continue = 0;
				pstat->tx_fail_cnt = 0;
		    }
		}

#ifdef CONFIG_RTK_WLAN_MANAGER
		if (OPMODE & WIFI_AP_STATE)
			rtk_wlan_manager_nl_send_sta_rpt_msg(priv, pstat);
#endif

#ifdef LAZY_WDS
		if ((!(pstat->state & WIFI_WDS) &&
			(ok_curr == ok_pre) &&
			(pstat->rx_pkts == pstat->rx_pkts_pre)) ||
			((pstat->state & WIFI_WDS_LAZY) &&
				((pstat->rx_pkts == pstat->rx_pkts_pre) && !pstat->beacon_num)))
#else
#if defined(__ECOS) && defined(CONFIG_SDIO_HCI) && defined(CONFIG_RTL_88E_SUPPORT)
		if (pstat->rx_pkts == pstat->rx_pkts_pre)
#else
		if ((ok_curr == ok_pre) &&
			(pstat->rx_pkts == pstat->rx_pkts_pre))
#endif
#endif
		{
			if (pstat->expire_to > 0)
			{
				// free queued skb if sta is idle longer than 5 seconds
				if ((priv->expire_to - pstat->expire_to) == 5){			
					//remove this because some sta will idle over 5 sec, than the data path will disconnect for a while
					//free_sta_skb(priv, pstat);
    				for (i=0; i<8; i++)
	    				for (j=0; j<TUPLE_WINDOW; j++)
		    				pstat->tpcache[i][j] = 0xffff;
				    pstat->tpcache_mgt = 0xffff;
				}
				
				// calculate STA number
				if ((pstat->expire_to == 1)
#ifdef WDS
#ifdef LAZY_WDS
					&& (!(pstat->state & WIFI_WDS) || (pstat->state & WIFI_WDS_LAZY))
#else
					&& !(pstat->state & WIFI_WDS)
#endif
#endif
#ifdef A4_STA
                    && (!(pstat->state & WIFI_A4_STA) || ((pstat->state & WIFI_A4_STA) && pstat->leave))
#endif
				) {

#ifdef LAZY_WDS
					if (!(pstat->state & WIFI_WDS_LAZY)) 
#endif
					{
						cnt_assoc_num(priv, pstat, DECREASE, (char *)__FUNCTION__);
						check_sta_characteristic(priv, pstat, DECREASE);
					}

					// CAM entry update
					if (!SWCRYPTO && pstat->dot11KeyMapping.keyInCam) {
						if (CamDeleteOneEntry(priv, pstat->cmn_info.mac_addr, 0, 0)) {
							pstat->dot11KeyMapping.keyInCam = FALSE;
							pstat->tmp_rmv_key = TRUE;
							priv->pshare->CamEntryOccupied--;
						}
						#if defined(CONFIG_RTL_HW_WAPI_SUPPORT)
						if (CamDeleteOneEntry(priv, pstat->cmn_info.mac_addr, 0, 0)) {
							pstat->dot11KeyMapping.keyInCam = FALSE;
							pstat->tmp_rmv_key = TRUE;
							priv->pshare->CamEntryOccupied--;
						}
						#endif
					}

#if defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI)
					if (GET_HCI_TYPE(priv) == RTL_HCI_USB || GET_HCI_TYPE(priv) == RTL_HCI_SDIO) {
						sleep_list_del(priv, pstat);
					}
#endif

					DRV_RT_TRACE(priv, DRV_DBG_CONN_INFO, DRV_DBG_SERIOUS, "A STA is expired - %pm\n", pstat->cmn_info.mac_addr);

					DRV_RT_TRACE(priv, DRV_DBG_CONN_INFO, DRV_DBG_SERIOUS, "Active: %d, assocNum: %d\n",
						priv->assoc_num, get_assoc_sta_num(priv, 1));
					
					LOG_MSG("A STA is expired - %pm\n",pstat->cmn_info.mac_addr);

#if defined(__ECOS) && defined(CONFIG_SDIO_HCI)
					if (GET_HCI_TYPE(priv) == RTL_HCI_SDIO) {
						if ((OPMODE & WIFI_AP_STATE) && priv->sta_status_cb_func)
							priv->sta_status_cb_func("wlan0", pstat->cmn_info.mac_addr, WIFI_STA_STATUS_EXPIRED);
					}
#endif

#ifdef LAZY_WDS
					if (pstat->state & WIFI_WDS_LAZY) {
						asoc_list_unref(priv, pstat);
						delete_wds_entry(priv, pstat);
						return;
					}
#endif
				}

				if (pstat->cmn_info.dm_ctrl & STA_DM_CTRL_ACTIVE) {
					if ((priv->expire_to - pstat->expire_to) > 3)
						pstat->cmn_info.dm_ctrl &= ~STA_DM_CTRL_ACTIVE;
				}

				pstat->expire_to--;

				if(priv->pshare->rf_ft_var.fix_expire_to_zero == 1) {
					pstat->expire_to = 0;
					priv->pshare->rf_ft_var.fix_expire_to_zero = 0;
				}

				if (pstat->expire_to == 0) {
#if defined(BR_SHORTCUT) && defined(RTL_CACHED_BR_STA)
#ifdef CONFIG_VERIWAVE_CHECK
					if(!is_veriwave_testing(priv))
#endif
					release_brsc_cache(pstat->cmn_info.mac_addr);
#endif

#ifdef P2P_SUPPORT
/*cfg p2p cfg p2p*/
					if ((rtk_p2p_is_enabled(priv)) && (rtk_p2p_chk_role(priv,P2P_TMP_GO))) {
						if (pstat->is_p2p_client) {
							P2P_DEBUG("p2p client leaved excced %d seconds\n", P2P_CLIENT_ASSOC_EXPIRE);
                            if(rtk_p2p_is_enabled(priv)==PROPERTY_P2P)
    							p2p_client_remove(priv, pstat);
						}
					}
#endif
#if (BEAMFORMING_SUPPORT == 1)
					if ((priv->pmib->dot11RFEntry.txbf == 1) && (priv->pshare->WlanSupportAbility & WLAN_BEAMFORMING_SUPPORT))
					{
					    struct _RT_BEAMFORMING_INFO* 	pBeamformingInfo = &(priv->pshare->BeamformingInfo);
                                    
						PHYDM_DBG(ODMPTR, DBG_TXBF, "%s,\n", __FUNCTION__);
						pBeamformingInfo->CurDelBFerBFeeEntrySel = BFerBFeeEntry;

						if(Beamforming_DeInitEntry(priv, pstat->cmn_info.mac_addr))
							Beamforming_Notify(priv);

						// clean the del entry list of exist.
						if (isEqualMACAddr(pstat->cmn_info.mac_addr, pBeamformingInfo->DelEntryListByMACAddr.BFeeEntry_Idx0)) {
							memset(pBeamformingInfo->DelEntryListByMACAddr.BFeeEntry_Idx0, 0, 6);
						}
						else if (isEqualMACAddr(pstat->cmn_info.mac_addr, pBeamformingInfo->DelEntryListByMACAddr.BFeeEntry_Idx1)) {
							memset(pBeamformingInfo->DelEntryListByMACAddr.BFeeEntry_Idx1, 0, 6);
						}
						if (isEqualMACAddr(pstat->cmn_info.mac_addr, pBeamformingInfo->DelEntryListByMACAddr.BFerEntry_Idx0)) {
							memset(pBeamformingInfo->DelEntryListByMACAddr.BFerEntry_Idx0, 0, 6);
						}
						else if (isEqualMACAddr(pstat->cmn_info.mac_addr, pBeamformingInfo->DelEntryListByMACAddr.BFerEntry_Idx1)) {
							memset(pBeamformingInfo->DelEntryListByMACAddr.BFerEntry_Idx1, 0, 6);
						}
					}
#endif


#ifdef DEL_EXPIRE_STA
					if(priv->pmib->dot11StationConfigEntry.del_expire_station == 1)
#endif
#ifdef A4_STA
                    if (!(pstat->state & WIFI_A4_STA) || ((pstat->state & WIFI_A4_STA) && pstat->leave))
#endif
					{
						struct list_head *ptmp = plist->next;
						unsigned char ucChk = 0;
						if (plist == plist->next){
						    ucChk = 1;
						}
#ifdef MULTI_MAC_CLONE
						if (OPMODE & WIFI_STATION_STATE) {
							__del_mclone_addr(priv, pstat->sa_addr);
						}else
#endif
						{
						    pwr_un_sleep(priv, pstat);
							issue_deauth(priv, pstat->cmn_info.mac_addr, _RSON_DEAUTH_STA_LEAVING_);
							DRV_RT_TRACE(priv, DRV_DBG_CONN_INFO, DRV_DBG_SERIOUS, "issue_deauth - %pm\n",pstat->cmn_info.mac_addr);
							SMP_UNLOCK(flags);
							free_stainfo(priv, pstat);
							SMP_LOCK(flags);
						}

						if (ucChk == 1){
							if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE)
            					SMP_LOCK_ASOC_LIST(flags);
							break;  
						}else{
							plist = ptmp;
							if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE)
            					SMP_LOCK_ASOC_LIST(flags);
							continue;
						}
					}
				}
			}
			else {
				free_sta_tx_skb(priv, pstat);
			}
#ifdef CONFIG_FON
			if(isFonClient && pFonClient->accStarted){
				pFonClient->accIdleTimeoutCnt++;
				if(pFonClient->accIdleTimeoutCnt == pFonClient->accIdleTimeout)
				{
					pFonClient->accStopCause = 4;
				}
			}
#endif

		}
		else
		{
#ifdef CONFIG_FON
			if(isFonClient){
				pFonClient->accIdleTimeoutCnt=0;
			}
#endif
#if !defined(USE_OUT_SRC) || defined(_OUTSRC_COEXIST)
#ifdef _OUTSRC_COEXIST
			if(!IS_OUTSRC_CHIP(priv))
#endif
			{
				/*
				 * pass rssi info to f/w
				 */
#if defined(CONFIG_RTL_92C_SUPPORT) || defined(CONFIG_RTL_92D_SUPPORT)
				if(CHIP_VER_92X_SERIES(priv))  {
					if (!pstat->cmn_info.ra_info.disable_ra)
						add_update_rssi(priv, pstat);
				}
#endif
			}
#endif
			if((priv->up_time %3)==1) {
#ifdef MULTI_STA_REFINE 			
				pstat->dropPktTotal += pstat->dropPktCurr;
				pstat->dropPktCurr = 0;
#endif
			}
#ifdef RTK_ATM
			if(priv->pshare->rf_ft_var.atm_en)
				pstat->tx_avarage_atm += pstat->tx_avarage;
#endif
#ifdef RA_OFFSET_TRAINING
#if defined(TXRETRY_CNT)
			if (is_support_TxRetryCnt(priv)) {
				if((pstat->cur_tx_ok || pstat->cur_tx_fail) &&
					((pstat->tx_avarage>>17) > 5)) {
					unsigned int rto = (pstat->cur_tx_retry_cnt*100)/(pstat->cur_tx_ok+pstat->cur_tx_retry_cnt+pstat->cur_tx_fail);
					if (pstat->ra_offset.rty_ratio == 0)
						pstat->ra_offset.rty_ratio = rto;
					else
						pstat->ra_offset.rty_ratio = ((pstat->ra_offset.rty_ratio*7) + (rto*3))/10;
				}
				else
					pstat->ra_offset.rty_ratio = 0;
			}
#endif
#endif
#if defined(TXRETRY_CNT)
			unsigned long diff_rx_packets = (unsigned long)(priv->net_stats.rx_packets - priv->ext_stats.pre_rx_packets);
			if (is_support_TxRetryCnt(priv)) {
				if (priv->net_stats.rx_packets == priv->ext_stats.pre_rx_packets)
					pstat->cur_rx_retry_ratio = 0;
				else
					pstat->cur_rx_retry_ratio = ((priv->ext_stats.rx_retrys - priv->ext_stats.pre_rx_retrys) * 100) / diff_rx_packets;
				priv->ext_stats.pre_rx_retrys = (unsigned long long)priv->ext_stats.rx_retrys;
				priv->ext_stats.pre_rx_packets = (unsigned long long)priv->net_stats.rx_packets;

				if (GET_CHIP_VER(priv) == VERSION_8814B)
					pstat->cur_tx_retry_ratio = (pstat->cur_tx_retry_cnt*100) / (pstat->cur_tx_retry_pkts + 1);
				else
					pstat->cur_tx_retry_ratio = (pstat->cur_tx_retry_cnt*100) / (pstat->cur_tx_ok + pstat->cur_tx_retry_cnt + pstat->cur_tx_fail + 1);
#ifdef SW_TXQ_ATF
				unsigned int retry_ratio = 100;
				if (GET_CHIP_VER(priv) == VERSION_8192F) {
					if (pstat->cur_tx_retry_pkts)
						retry_ratio = (pstat->cur_tx_retry_pkts + pstat->cur_tx_retry_cnt + pstat->cur_tx_fail * 48) * 100 / pstat->cur_tx_retry_pkts;
				} else {
					if (pstat->cur_tx_ok + pstat->cur_tx_fail)
						retry_ratio = (pstat->cur_tx_retry_pkts + pstat->cur_tx_fail * 48) * 100 / (pstat->cur_tx_ok + pstat->cur_tx_fail);
				}
				if (retry_ratio < 100)
					retry_ratio = 100;
				pstat->swq.atf_retry_ratio = retry_ratio;
#endif /* SW_TXQ_ATF */
#ifdef CTC_ORIENTATION_REFINE
				ODMPTR->retry_cnt += pstat->cur_rx_retry_ratio + pstat->cur_tx_retry_ratio;
#endif
			} 
#endif
			if (priv->pshare->rf_ft_var.rssi_dump && !(priv->up_time % priv->pshare->rf_ft_var.rssi_dump)) {
#if defined(CONFIG_RTL8672) || defined(NOT_RTK_BSP)
				display_rssi_dump(priv, pstat);
#else
				unsigned char mimorssi[4];
				{
					mimorssi[0] = pstat->rf_info.mimorssi[0];
					mimorssi[1] = pstat->rf_info.mimorssi[1];
					mimorssi[2] = pstat->rf_info.mimorssi[2];
					mimorssi[3] = pstat->rf_info.mimorssi[3];						
				}
	
				unsigned int FA_total_cnt=0;
				unsigned int CCA_total_cnt=0;

#if defined(TXRETRY_CNT)
				unsigned char retry_str[30] = {0};

				if(is_support_TxRetryCnt(priv)) {
					if(pstat->cur_tx_ok || pstat->cur_tx_fail)
						sprintf(retry_str," [%2d%%] ",(pstat->total_tx_retry_cnt*100)/(pstat->cur_tx_ok+pstat->total_tx_retry_cnt+pstat->cur_tx_fail));
					else
						sprintf(retry_str," [N/A] ");
				} else
					sprintf(retry_str," ");
#endif
#ifdef USE_OUT_SRC
#ifdef _OUTSRC_COEXIST
				if(IS_OUTSRC_CHIP(priv))
#endif
				{
	#if (PHYDM_TDMA_DIG_SUPPORT == 1)					
					if(ODMPTR->original_dig_restore == 1) {
						FA_total_cnt = ODMPTR->false_alm_cnt.cnt_all;
						CCA_total_cnt = ODMPTR->false_alm_cnt.cnt_cca_all;
					} else {
						FA_total_cnt = ODMPTR->false_alm_cnt_acc.cnt_all_1sec;
						CCA_total_cnt = ODMPTR->false_alm_cnt_acc.cnt_cca_all_1sec;
					}
	#else				
					FA_total_cnt = ODMPTR->false_alm_cnt.cnt_all;
					CCA_total_cnt = ODMPTR->false_alm_cnt.cnt_cca_all;
	#endif		// #if (PHYDM_TDMA_DIG_SUPPORT == 1)
				}
#endif

#if !defined(USE_OUT_SRC) || defined(_OUTSRC_COEXIST)
#ifdef _OUTSRC_COEXIST
				if(!IS_OUTSRC_CHIP(priv))
#endif
				{
					FA_total_cnt = priv->pshare->FA_total_cnt;
					CCA_total_cnt = priv->pshare->CCA_total_cnt;
				}
#endif		
				
#if 1 /*txforce	*/

				unsigned int dump_tx_tp = (unsigned int)(pstat->tx_avarage>>17);
				#ifdef RTK_ATM
				if(priv->pshare->rf_ft_var.atm_en){
					dump_tx_tp = (unsigned int)((pstat->tx_avarage_atm/priv->pshare->rf_ft_var.rssi_dump)>>17);
					pstat->tx_avarage_atm = 0;
				}
				#endif
				
				if(priv->pshare->rf_ft_var.txforce != 0xff)
				{
					unsigned char txforce = priv->pshare->rf_ft_var.txforce;
					unsigned char dot11_rate_table[]={2,4,11,22,12,18,24,36,48,72,96,108,0};
					unsigned char args[200];
#if defined(TXRETRY_CNT)
					SPRINTT(args, "[%d]%s%s%d%%%stxforce %s%s%s%s%s%s%d%s%s rx %s%s%s%s%s%s%d%s%s ",
							pstat->cmn_info.aid, pstat->cmn_info.aid>9?"":" ", pstat->rssi<100?(pstat->rssi<10?"  ":" "):"", pstat->rssi, retry_str,
#else
					SPRINTT(args, "[%d]%s%s%d%%  txforce %s%s%s%s%s%s%d%s%s rx %s%s%s%s%s%s%d%s%s ",
							pstat->cmn_info.aid, pstat->cmn_info.aid>9?"":" ", pstat->rssi<100?(pstat->rssi<10?"  ":" "):"", pstat->rssi,
#endif
					((txforce >= 44)) ? "VHT " : "",
					((txforce >= 12) && (txforce < 44))? "MCS" : "",
					((txforce >= 44) && (txforce < 54)) ? "NSS1 " : "",
					((txforce >= 54) && (txforce < 64)) ? "NSS2 " : "",
					((txforce >= 64) && (txforce < 74)) ? "NSS3 " : "",
					((txforce >= 74) && (txforce < 84)) ? "NSS4 " : "",
					(txforce >= 44) ? ((txforce-44)%10):((txforce >= 12)? txforce-12: dot11_rate_table[txforce]/2),
					(pstat->ht_current_tx_info&BIT(1))? "s" : " ",
					(txforce >= 44) ? "":((txforce >= 12)?(txforce >= 22?"     ":"      "):(dot11_rate_table[txforce]/2 >= 11?"        ":"         ")),
					((pstat->rx_rate) >= VHT_RATE_ID)? "VHT " : "",
					((pstat->rx_rate >= _NSS1_MCS0_RATE_) && (pstat->rx_rate <= _NSS1_MCS9_RATE_)) ? "NSS1 " : "",
					((pstat->rx_rate >= _NSS2_MCS0_RATE_) && (pstat->rx_rate <= _NSS2_MCS9_RATE_)) ? "NSS2 " : "",	
					((pstat->rx_rate >= _NSS3_MCS0_RATE_) && (pstat->rx_rate <= _NSS3_MCS9_RATE_)) ? "NSS3 " : "",
					((pstat->rx_rate >= _NSS4_MCS0_RATE_) && (pstat->rx_rate <= _NSS4_MCS9_RATE_)) ? "NSS4 " : "",
					((pstat->rx_rate >= HT_RATE_ID) && (pstat->rx_rate < VHT_RATE_ID))? "MCS" : "",
					((pstat->rx_rate) >= VHT_RATE_ID) ? ((pstat->rx_rate - VHT_RATE_ID)%10) : ((pstat->rx_rate >= HT_RATE_ID)? (pstat->rx_rate - HT_RATE_ID) : pstat->rx_rate/2),
					pstat->rx_splcp? "s" : " ",
					(pstat->rx_rate >= VHT_RATE_ID) ? "":((pstat->rx_rate >= HT_RATE_ID)?(pstat->rx_rate >= HT_RATE_ID+10?"     ":"      "):(dot11_rate_table[pstat->rx_rate]/2 >= 11?"        ":"         ")));
#if defined(CONFIG_WLAN_HAL_8814AE) || defined(CONFIG_WLAN_HAL_8822BE) || defined(CONFIG_WLAN_HAL_8198F) || defined(CONFIG_WLAN_HAL_8814BE)
					if((GET_CHIP_VER(priv) == VERSION_8814A)||(GET_CHIP_VER(priv) == VERSION_8198F) || (GET_CHIP_VER(priv) == VERSION_8814B))
					SPRINTT_CONT(args, " (ss %2d %2d %2d %2d)",
								mimorssi[0],
								mimorssi[1],
								mimorssi[2],
								mimorssi[3]);
					else
					SPRINTT_CONT(args, " (ss %2d %2d)",
								mimorssi[0],
								mimorssi[1]);

#else
					SPRINTT_CONT(args, " (ss %2d %2d)",
#ifdef CONFIG_RTL_88E_SUPPORT
					(GET_CHIP_VER(priv)==VERSION_8188E)?0:
#endif
					mimorssi[0],
#ifdef CONFIG_RTL_88E_SUPPORT
					(GET_CHIP_VER(priv)==VERSION_8188E)?0:
#endif
					mimorssi[1]);
#endif
	#if (PHYDM_TDMA_DIG_SUPPORT == 1)
					if (ODMPTR->original_dig_restore == 1) {
						SPRINTT_CONT(args, " (FA%4d)(CCA%5d)(DIG 0x%2x)(TP %3d,%3d)",
							FA_total_cnt,
							CCA_total_cnt,
		   					((GET_CHIP_VER(priv) == VERSION_8198F)||(GET_CHIP_VER(priv) == VERSION_8814B)||(GET_CHIP_VER(priv) == VERSION_8822C)||(GET_CHIP_VER(priv) == VERSION_8812F))? RTL_R8(0x1d70)&0x7f : RTL_R8(0xc50),
							dump_tx_tp,
							(unsigned int)(pstat->rx_avarage>>17));
					} else {
						SPRINTT_CONT(args, " (FA%4d)(CCA%5d)(L-DIG 0x%2x, H-DIG 0x%2x)(TP %3d,%3d)",
							FA_total_cnt,
							CCA_total_cnt,
							ODMPTR->dm_dig_table.low_ig_value,
		   					ODMPTR->dm_dig_table.cur_ig_value_tdma,
							dump_tx_tp,
							(unsigned int)(pstat->rx_avarage>>17));
					}
	#else
					SPRINTT_CONT(args, " (FA%4d)(CCA%5d)(DIG 0x%2x)(TP %3d,%3d)",
						FA_total_cnt, CCA_total_cnt,
						((GET_CHIP_VER(priv) == VERSION_8198F)||(GET_CHIP_VER(priv) == VERSION_8814B)||(GET_CHIP_VER(priv) == VERSION_8822C)||(GET_CHIP_VER(priv) == VERSION_8812F))? RTL_R8(0x1d70)&0x7f : RTL_R8(0xc50),
						dump_tx_tp,
						(unsigned int)(pstat->rx_avarage>>17));
	#endif
#ifdef RX_CRC_EXPTIMER
					if(priv->pshare->rf_ft_var.crc_enable)
						SPRINTT_CONT(args, " (CRC %lu %lu)",
							priv->ext_stats.rx_packets_exptimer,
                    		priv->ext_stats.rx_crc_exptimer);
#endif
#ifdef CONFIG_RTL_WLAN_DIAGNOSTIC
					output_diag_log(args);
#else
					SPRINTT_CONT(args, "\n");
					//panic_printk("%s", args);
#endif
				}
				else
#endif
				{
					unsigned char args[200];

#if defined(TXRETRY_CNT)
					SPRINTT(args, "[%d]%s%s%d%%%stx %s%s%s%s%s%s%d%s%s rx %s%s%s%s%s%d%s%s ",
							pstat->cmn_info.aid, pstat->cmn_info.aid>9?"":" ", pstat->rssi<100?(pstat->rssi<10?"  ":" "):"", pstat->rssi, retry_str,
#else
					SPRINTT(args, "[%d]%s%s%d%%  tx %s%s%s%s%s%s%d%s%s rx %s%s%s%s%s%d%s%s ",
							pstat->cmn_info.aid, pstat->cmn_info.aid>9?"":" ", pstat->rssi<100?(pstat->rssi<10?"  ":" "):"", pstat->rssi,
#endif
					((pstat->current_tx_rate >= VHT_RATE_ID)) ? "VHT " : "",
					((pstat->current_tx_rate >= HT_RATE_ID) && (pstat->current_tx_rate < VHT_RATE_ID))? "MCS" : "",
					((pstat->current_tx_rate >=_NSS1_MCS0_RATE_) && (pstat->current_tx_rate < _NSS2_MCS0_RATE_)) ? "NSS1 " : "",
					((pstat->current_tx_rate >=_NSS2_MCS0_RATE_) && (pstat->current_tx_rate < _NSS3_MCS0_RATE_)) ? "NSS2 " : "",
					((pstat->current_tx_rate >=_NSS3_MCS0_RATE_) && (pstat->current_tx_rate < _NSS4_MCS0_RATE_)) ? "NSS3 " : "",
					((pstat->current_tx_rate >=_NSS4_MCS0_RATE_) && (pstat->current_tx_rate <= _NSS4_MCS9_RATE_)) ? "NSS4 " : "",
					(pstat->current_tx_rate >= VHT_RATE_ID) ? ((pstat->current_tx_rate - VHT_RATE_ID)%10):((pstat->current_tx_rate >= HT_RATE_ID)? (pstat->current_tx_rate - HT_RATE_ID) : pstat->current_tx_rate/2),					
					(pstat->ht_current_tx_info&BIT(1))? "s" : " ",
					(pstat->current_tx_rate >= VHT_RATE_ID) ? "":((pstat->current_tx_rate >= HT_RATE_ID)?(pstat->current_tx_rate >= HT_RATE_ID+10?"     ":"      "):(pstat->current_tx_rate/2 >= 11?"        ":"         ")),
					((pstat->rx_rate) >= VHT_RATE_ID)? "VHT " : "",
					((pstat->rx_rate >=_NSS1_MCS0_RATE_) && (pstat->rx_rate < _NSS2_MCS0_RATE_)) ? "NSS1 " : "",
					((pstat->rx_rate >=_NSS2_MCS0_RATE_) && (pstat->rx_rate < _NSS3_MCS0_RATE_)) ? "NSS2 " : "",
					((pstat->rx_rate >=_NSS3_MCS0_RATE_) && (pstat->rx_rate < _NSS4_MCS0_RATE_)) ? "NSS3 " : "",
					((pstat->rx_rate >= HT_RATE_ID) && (pstat->rx_rate < VHT_RATE_ID))? "MCS" : "",
					((pstat->rx_rate) >= VHT_RATE_ID) ? ((pstat->rx_rate - VHT_RATE_ID)%10) : ((pstat->rx_rate >= HT_RATE_ID)? (pstat->rx_rate-HT_RATE_ID) : pstat->rx_rate/2),
					pstat->rx_splcp? "s" : " ",
					(pstat->rx_rate >= VHT_RATE_ID) ? "":((pstat->rx_rate >= HT_RATE_ID)?(pstat->rx_rate >= HT_RATE_ID+10?"     ":"      "):(pstat->rx_rate/2 >= 11?"        ":"         ")));
#if defined(CONFIG_WLAN_HAL_8814AE) || defined(CONFIG_WLAN_HAL_8822BE) || defined(CONFIG_WLAN_HAL_8198F) || defined(CONFIG_WLAN_HAL_8814BE)
					if((GET_CHIP_VER(priv) == VERSION_8814A)||(GET_CHIP_VER(priv) == VERSION_8198F) ||(GET_CHIP_VER(priv) == VERSION_8814B))
					SPRINTT_CONT(args, " (ss %2d %2d %2d %2d)",
								mimorssi[0],
								mimorssi[1],
								mimorssi[2],
								mimorssi[3]);
					else
					SPRINTT_CONT(args, " (ss %2d %2d)",
								mimorssi[0],
								mimorssi[1]);
#else
					SPRINTT_CONT(args, " (ss %2d %2d)",
#ifdef CONFIG_RTL_88E_SUPPORT
					(GET_CHIP_VER(priv)==VERSION_8188E)?0:
#endif
					mimorssi[0],
#ifdef CONFIG_RTL_88E_SUPPORT
					(GET_CHIP_VER(priv)==VERSION_8188E)?0:
#endif
					mimorssi[1]);
#endif
	#if (PHYDM_TDMA_DIG_SUPPORT == 1)
					if (ODMPTR->original_dig_restore == 1) {
						SPRINTT_CONT(args, " (FA%4d)(CCA%5d)(DIG 0x%2x)(TP %3d,%3d)",
							FA_total_cnt,
							CCA_total_cnt,
							((GET_CHIP_VER(priv) == VERSION_8198F)||(GET_CHIP_VER(priv) == VERSION_8814B)||(GET_CHIP_VER(priv) == VERSION_8822C)||(GET_CHIP_VER(priv) == VERSION_8812F))? RTL_R8(0x1d70)&0x7f : RTL_R8(0xc50),
							dump_tx_tp,
							(unsigned int)(pstat->rx_avarage>>17));
					} else {
						SPRINTT_CONT(args, " (FA%4d)(CCA%5d)(L-DIG 0x%2x, H-DIG 0x%2x)(TP %3d,%3d)",
							FA_total_cnt,
							CCA_total_cnt,
							ODMPTR->dm_dig_table.low_ig_value,
							ODMPTR->dm_dig_table.cur_ig_value_tdma,
							dump_tx_tp,
							(unsigned int)(pstat->rx_avarage>>17));
					}
	#else
					SPRINTT_CONT(args, " (FA%4d)(CCA%5d)(DIG 0x%2x)(TP %3d,%3d)",
						FA_total_cnt, CCA_total_cnt,
						((GET_CHIP_VER(priv) == VERSION_8198F)||(GET_CHIP_VER(priv) == VERSION_8814B)||(GET_CHIP_VER(priv) == VERSION_8822C)||(GET_CHIP_VER(priv) == VERSION_8812F))? RTL_R8(0x1d70)&0x7f : RTL_R8(0xc50),
						dump_tx_tp,
						(unsigned int)(pstat->rx_avarage>>17));
	#endif	//#if (PHYDM_TDMA_DIG_SUPPORT == 1)

#ifdef RX_CRC_EXPTIMER
					if(priv->pshare->rf_ft_var.crc_enable)
						SPRINTT_CONT(args, " (CRC %d %d)",
							priv->ext_stats.rx_packets_exptimer,
                    		priv->ext_stats.rx_crc_exptimer);
#endif
#ifdef CONFIG_RTL_WLAN_DIAGNOSTIC
					output_diag_log(args);
#else
					SPRINTT_CONT(args, "\n");
#endif
				}
#if defined(TXRETRY_CNT)
			pstat->total_tx_retry_pkts = pstat->total_tx_retry_cnt = pstat->cur_tx_ok = pstat->cur_tx_fail = 0;
#endif
#ifdef RX_CRC_EXPTIMER
            priv->ext_stats.rx_crc_exptimer = 0;
            priv->ext_stats.rx_packets_exptimer = 0;
#endif
#endif	//#if defined(CONFIG_RTL8672) || defined(NOT_RTK_BSP)

			}
#if defined(TXRETRY_CNT)
			pstat->total_tx_retry_pkts = pstat->total_tx_retry_cnt = pstat->cur_tx_ok = pstat->cur_tx_fail = 0;
#endif

#ifdef RX_CRC_EXPTIMER	
			if (priv->pshare->rf_ft_var.crc_dump  && !(priv->up_time % priv->pshare->rf_ft_var.crc_dump)) {
#ifdef CONFIG_RTL_WLAN_DIAGNOSTIC
				output_diag_log("CRC ");
#else
				panic_printk("CRC ");
#endif
				for(i=_NSS1_MCS0_RATE_;i<=_NSS1_MCS9_RATE_;i++) {
					if(priv->ext_stats.rx_packets_by_rate[i])
#ifdef CONFIG_RTL_WLAN_DIAGNOSTIC
						{
							sprintf(temp_log,"NSS1MCS%d(%ld/%ld) ", i-_NSS1_MCS0_RATE_,priv->ext_stats.rx_packets_by_rate[i], priv->ext_stats.rx_crc_by_rate[i]);
							output_diag_log(temp_log);
						}	
#else
						panic_printk("NSS1MCS%d(%ld/%ld) ", i-_NSS1_MCS0_RATE_,priv->ext_stats.rx_packets_by_rate[i], priv->ext_stats.rx_crc_by_rate[i]);
#endif
				}
				for(i=_NSS2_MCS0_RATE_;i<=_NSS2_MCS9_RATE_;i++) {
					if(priv->ext_stats.rx_packets_by_rate[i])
#ifdef CONFIG_RTL_WLAN_DIAGNOSTIC
						{
							sprintf(temp_log,"NSS2MCS%d(%ld/%ld) ", i-_NSS2_MCS0_RATE_,priv->ext_stats.rx_packets_by_rate[i], priv->ext_stats.rx_crc_by_rate[i]);
							output_diag_log(temp_log);
						}
#else
						panic_printk("NSS2MCS%d(%ld/%ld) ", i-_NSS2_MCS0_RATE_,priv->ext_stats.rx_packets_by_rate[i], priv->ext_stats.rx_crc_by_rate[i]);
#endif
				}
				for(i=_NSS3_MCS0_RATE_;i<=_NSS3_MCS9_RATE_;i++) {
					if(priv->ext_stats.rx_packets_by_rate[i])
#ifdef CONFIG_RTL_WLAN_DIAGNOSTIC
						{
							sprintf(temp_log,"NSS3MCS%d(%ld/%ld) ", i-_NSS3_MCS0_RATE_,priv->ext_stats.rx_packets_by_rate[i], priv->ext_stats.rx_crc_by_rate[i]);
							output_diag_log(temp_log);
						}
#else
						panic_printk("NSS3MCS%d(%ld/%ld) ", i-_NSS3_MCS0_RATE_,priv->ext_stats.rx_packets_by_rate[i], priv->ext_stats.rx_crc_by_rate[i]);
#endif
				}
				for(i=_NSS4_MCS0_RATE_;i<=_NSS4_MCS9_RATE_;i++) {
					if(priv->ext_stats.rx_packets_by_rate[i])
#ifdef CONFIG_RTL_WLAN_DIAGNOSTIC
						{
							sprintf(temp_log,"NSS4MCS%d(%ld/%ld) ", i-_NSS4_MCS0_RATE_,priv->ext_stats.rx_packets_by_rate[i], priv->ext_stats.rx_crc_by_rate[i]);
							output_diag_log(temp_log);
						}
#else
						panic_printk("NSS4MCS%d(%ld/%ld) ", i-_NSS4_MCS0_RATE_,priv->ext_stats.rx_packets_by_rate[i], priv->ext_stats.rx_crc_by_rate[i]);
#endif
				}
				for(i=_MCS0_RATE_;i<=_MCS31_RATE_;i++) {
					if(priv->ext_stats.rx_packets_by_rate[i])
#ifdef CONFIG_RTL_WLAN_DIAGNOSTIC
						{
							sprintf(temp_log,"MCS%d(%ld/%ld) ", i-_MCS0_RATE_,priv->ext_stats.rx_packets_by_rate[i], priv->ext_stats.rx_crc_by_rate[i]);
							output_diag_log(temp_log);
						}
#else
						panic_printk("MCS%d(%ld/%ld) ", i-_MCS0_RATE_,priv->ext_stats.rx_packets_by_rate[i], priv->ext_stats.rx_crc_by_rate[i]);
#endif
				}
#ifdef CONFIG_RTL_WLAN_DIAGNOSTIC
				output_diag_log("\n");
#else
				panic_printk("\n");
#endif
				memset(priv->ext_stats.rx_crc_by_rate, 0, 256*sizeof(unsigned long));
				memset(priv->ext_stats.rx_packets_by_rate, 0, 256*sizeof(unsigned long));
			}
#endif

#if defined(CONFIG_RTL_88E_SUPPORT) && defined(TXREPORT)
			if ((GET_CHIP_VER(priv) == VERSION_8188E) && priv->pmib->dot11StationConfigEntry.autoRate)
#ifdef RATEADAPTIVE_BY_ODM
				ODMPTR->ra_info[pstat->cmn_info.aid].rssi_sta_ra = pstat->rssi;
#else
				priv->pshare->RaInfo[pstat->cmn_info.aid].rssi_sta_ra = pstat->rssi;
#endif
#endif
#ifdef MCR_WIRELESS_EXTEND
#ifdef CONFIG_WLAN_HAL
			if (IS_HAL_CHIP(priv) && (pstat->IOTPeer == HT_IOT_PEER_CMW)) {
				init_rainfo(priv,pstat);							
			}
#endif
#endif


#if defined(CONFIG_RTL_8812_SUPPORT)
			if (priv->pshare->rf_ft_var.rssi_ra)
			if ( (GET_CHIP_VER(priv) == VERSION_8812E)
				&& pstat->vht_cap_len && (priv->pmib->dot11BssType.net_work_type & WIRELESS_11AC) 
				&& (!should_restrict_Nrate(priv, pstat)))
			{
						unsigned char cur_rssi_level = 0;
						
						{
							if (pstat->rssi >= priv->pshare->rf_ft_var.rssi_thd1)
								cur_rssi_level = 1;
							else if (pstat->rssi >= priv->pshare->rf_ft_var.rssi_thd2)
								cur_rssi_level = 2;
							else
								cur_rssi_level = 3;
						}

						if(pstat->rssi_level_ac != cur_rssi_level) {

						  if(cur_rssi_level > pstat->rssi_level_ac) {

							if((cur_rssi_level==1) && (cur_rssi_level >= (priv->pshare->rf_ft_var.rssi_thd1+5)))
								UpdateHalRAMask8812(priv, pstat, 3);
							if((cur_rssi_level==2) && (cur_rssi_level >= (priv->pshare->rf_ft_var.rssi_thd2+5)))
								UpdateHalRAMask8812(priv, pstat, 3);

						  }
						  else
						  	UpdateHalRAMask8812(priv, pstat, 3);	

						}
			}
#endif

#ifdef CONFIG_WLAN_HAL
			if(IS_HAL_CHIP(priv)) {
				u1Byte MimoPs = MIMO_PS_NOLIMIT, MimoPs_enable = FALSE;
				if(pstat->MIMO_ps & _HT_MIMO_PS_STATIC_)
					MimoPs = MIMO_PS_STATIC;
				else if(pstat->MIMO_ps & _HT_MIMO_PS_DYNAMIC_)
					MimoPs = MIMO_PS_DYNAMIC;
				if (MimoPs < MIMO_PS_DYNAMIC)
					MimoPs_enable = TRUE;
				 else if((MimoPs == MIMO_PS_DYNAMIC) && (pstat->tx_avarage  < (3<<17))) {
						MimoPs_enable = TRUE;
				}
				if(MimoPs_enable != pstat->MimoPs_fw) {
					init_rainfo(priv,pstat); 	
				}
			}
#endif

			// calculate STA number
			if ((pstat->expire_to == 0)
#ifdef WDS
				&& !(pstat->state & WIFI_WDS)
#endif
#ifdef A4_STA
                && !(pstat->state & WIFI_A4_STA)
#endif

			) {
				cnt_assoc_num(priv, pstat, INCREASE, (char *)__FUNCTION__);
				check_sta_characteristic(priv, pstat, INCREASE);

				// CAM entry update
				if (!SWCRYPTO) {
					if (priv->pmib->dot118021xAuthEntry.dot118021xAlgrthm ||
							pstat->tmp_rmv_key == TRUE) {
						unsigned int privacy = pstat->dot11KeyMapping.dot11Privacy;

						if (CamAddOneEntry(priv, pstat->cmn_info.mac_addr, 0, privacy<<2, 0,
								pstat->dot11KeyMapping.dot11EncryptKey.dot11TTKey.skey)) {
							pstat->dot11KeyMapping.keyInCam = TRUE;
							pstat->tmp_rmv_key = FALSE;
							priv->pshare->CamEntryOccupied++;
							assign_aggre_mthod(priv, pstat);
						}
						else {
							if (pstat->aggre_mthd != AGGRE_MTHD_NONE)
								pstat->aggre_mthd = AGGRE_MTHD_NONE;
						}
					}
				}

				// Resume Ratid
#ifdef CONFIG_WLAN_HAL
				if (IS_HAL_CHIP(priv))
					init_rainfo(priv,pstat);
				else
#endif
#if defined(CONFIG_RTL_8812_SUPPORT) || defined(CONFIG_RTL_8723B_SUPPORT)
				if (GET_CHIP_VER(priv) == VERSION_8812E || GET_CHIP_VER(priv) == VERSION_8723B) 
					UpdateHalRAMask8812(priv, pstat, 3);
				else
#endif
#ifdef CONFIG_RTL_88E_SUPPORT
				if (GET_CHIP_VER(priv)==VERSION_8188E) {
#ifdef TXREPORT
					add_RATid(priv, pstat);
#endif
				} else
#endif
				{
#if defined(CONFIG_RTL_92C_SUPPORT) || defined(CONFIG_RTL_92D_SUPPORT)			
					if(CHIP_VER_92X_SERIES(priv))
						add_update_RATid(priv, pstat);
#endif
				}

				//pstat->dwngrade_probation_idx = pstat->upgrade_probation_idx = 0;	// unused
				LOG_MSG("A expired STA is resumed - %pm\n", pstat->cmn_info.mac_addr);
			}


#ifdef 	P2P_SUPPORT
/*cfg p2p cfg p2p*/
			if( (rtk_p2p_is_enabled(priv)) && (rtk_p2p_chk_role(priv,P2P_TMP_GO)) ){
				if(pstat->is_p2p_client)
					pstat->expire_to = P2P_CLIENT_ASSOC_EXPIRE;

			}else
#endif
			{
				pstat->expire_to = priv->expire_to;
				pstat->cmn_info.dm_ctrl |= STA_DM_CTRL_ACTIVE;
			}

			if ((pstat->rx_pkts - pstat->rx_mgnt_pkts) != (pstat->rx_pkts_pre - pstat->rx_mgnt_pkts_pre))
					pstat->brfwtbl_to = 0;				
			
			if (pstat->brfwtbl_to >= BRFWTBL_TIMEOUT_INIT){
				if (ok_curr - ok_pre > 5000) {
					update_fwtbl_asoclst(priv,pstat);
					pstat->brfwtbl_to = 0;
				}
			}
#ifdef RA_OFFSET_TRAINING			
			check_txrate_variation(priv, pstat);
#endif			
		}

#if defined(RTK_AC_SUPPORT)
			// operating mode notification
			if(priv->pshare->rf_ft_var.opmtest&2) {
				issue_op_mode_notify(priv, pstat, priv->pshare->rf_ft_var.oper_mode_field);
				priv->pshare->rf_ft_var.opmtest &= 1;
			}
#endif

#ifdef WDS
		if (pstat->state & WIFI_WDS) {
			if ((pstat->rx_pkts != pstat->rx_pkts_pre) || pstat->beacon_num)
				pstat->idle_time = 0;
			else
				pstat->idle_time++;

			if ((priv->up_time%2) == 0) {
				if ((pstat->beacon_num == 0) && (pstat->state & WIFI_WDS_RX_BEACON))
					pstat->state &= ~WIFI_WDS_RX_BEACON;
				if (pstat->beacon_num)
					pstat->beacon_num = 0;
			}
		}
#endif
		// update proc bssdesc
		if ((OPMODE & WIFI_STATION_STATE) && isEqualMACAddr(priv->pmib->dot11Bss.bssid, pstat->cmn_info.mac_addr)) {
			priv->pmib->dot11Bss.rssi = pstat->rssi; 
			priv->pmib->dot11Bss.sq = pstat->sq; 
		}

#if (BEAMFORMING_SUPPORT == 1) 
			if (((priv->up_time % 3) == 0) && (priv->pshare->WlanSupportAbility & WLAN_BEAMFORMING_SUPPORT)
				&& (priv->pmib->dot11RFEntry.txbf == 1) && (priv->pmib->dot11RFEntry.txbfer == 1))
			{
				pstat->bf_score = 0;
				if(((pstat->ht_cap_len && (cpu_to_le32(pstat->ht_cap_buf.txbf_cap)&_HTCAP_RECEIVED_NDP))
#ifdef RTK_AC_SUPPORT	
				|| (pstat->vht_cap_len && (cpu_to_le32(pstat->vht_cap_buf.vht_cap_info) & (BIT(SU_BFEE_S)|BIT(SU_BFER_S))))
#endif	
				)
#ifdef WDS
				&& (pstat->state & WIFI_WDS == 0)
#endif
				) {
					if( ( pstat->rssi > 10) && 
						( pstat->rx_pkts != pstat->rx_pkts_pre) && 
						(pstat->IOTPeer != HT_IOT_PEER_INTEL)
#ifdef DETECT_STA_EXISTANCE
						&& (!(pstat->leave)) 
#endif
					){
						u1Byte					Idx = 0;
													
						PRT_BEAMFORMING_ENTRY	pEntry, pBfeeEntry; 
						pEntry = Beamforming_GetEntryByMacId(priv, pstat->cmn_info.aid, &Idx);
						if(pEntry == NULL) {
                    		PHYDM_DBG(ODMPTR, DBG_TXBF, "[Beamforming]@%s, Beamforming_GetFreeBFeeEntry\n", __FUNCTION__);
							pBfeeEntry = Beamforming_GetFreeBFeeEntry(priv, &Idx, pstat->cmn_info.mac_addr);
							if(pBfeeEntry) {
								Beamforming_Enter(priv, pstat);
							}
						}
					}
					pstat->bf_score = 100 - pstat->rssi;
					if(pstat->tx_byte_cnt> (1<<16)) {			// 0.5M bps
						pstat->bf_score += 100;
					}
#if defined(UNIVERSAL_REPEATER)
					//make vxd connected AP prior to other stations connected to AP with traffic
					if(IS_VXD_INTERFACE(priv))
						pstat->bf_score += 1000;
#endif
					if ((pstat->cmn_info.ldpc_en & HT_LDPC_EN)
#ifdef RTK_AC_SUPPORT
						|| (pstat->cmn_info.ldpc_en & VHT_LDPC_EN)
#endif
					)
						pstat->bf_score -= 2;
					if ((pstat->cmn_info.stbc_en & HT_STBC_EN)
#ifdef RTK_AC_SUPPORT
						|| (pstat->cmn_info.stbc_en & VHT_STBC_EN)
#endif
					) {
						pstat->bf_score -= 5;
						if(!(pstat->MIMO_ps & _HT_MIMO_PS_STATIC_)) {
#ifdef RTK_AC_SUPPORT			
							if (pstat->vht_cap_len) {
								if(((le32_to_cpu(pstat->vht_cap_buf.vht_support_mcs[0]) >> 2) & 3) != 3)
									pstat->bf_score -=3;
							} else
#endif
							{
								pstat->tx_ra_bitmap = 0;
								if (pstat->ht_cap_len) {
									for (i=0; i<16; i++) {
										if (pstat->ht_cap_buf.support_mcs[i/8] & BIT(i%8))
											pstat->tx_ra_bitmap |= BIT(i+12);
									}
									if(pstat->tx_ra_bitmap & 0x0ff00000)
										pstat->bf_score -=3;
								}
							}
						}
					}
				}
			}
#endif

		_check_sta_continuous_icverr(priv, pstat);

		pstat->tx_bytes_1s = pstat->tx_bytes - pstat->tx_bytes_pre;
#if defined(RTK_ATM) || defined(RTK_CURRENT_RATE_ACCOUNTING)//count tx bytes 1s
		pstat->tx_bytes_pre = pstat->tx_bytes;
#endif
#ifdef RTK_CURRENT_RATE_ACCOUNTING
		pstat->rx_bytes_1s = pstat->rx_bytes - pstat->rx_bytes_pre;
		pstat->rx_bytes_pre = pstat->rx_bytes;
#endif
		pstat->tx_pkts_pre = pstat->tx_pkts;
		pstat->rx_pkts_pre = pstat->rx_pkts;
		pstat->tx_fail_pre = pstat->tx_fail;
		pstat->rx_mgnt_pkts_pre = pstat->rx_mgnt_pkts;

#ifdef SUPPORT_TX_MCAST2UNI		
		if(priv->pshare->rf_ft_var.txbuf_manual_aid != 0 ){
			if(pstat->mc2uc_pkts - pstat->mc2uc_pkts_pre > priv->pshare->rf_ft_var.IPTV_pkt_th){
				//if not set txbuf_manual_aid, than set it to this aid, else do nothing
				if(priv->pshare->rf_ft_var.txbuf_manual_aid == 255){
					printk("aid[%d], set txbuf_manual_aid \n", pstat->cmn_info.aid);
					priv->pshare->rf_ft_var.txbuf_manual_aid =pstat->cmn_info.aid;
				}
		
			}else if(pstat->mc2uc_pkts - pstat->mc2uc_pkts_pre < 50){
				// if this aid doesn't continue playing video, than set txbuf_manual_aid to auto (255)
				if( pstat->cmn_info.aid == priv->pshare->rf_ft_var.txbuf_manual_aid){
					printk("aid[%d], del txbuf_manual_aid \n", pstat->cmn_info.aid);
					priv->pshare->rf_ft_var.txbuf_manual_aid = 255;
				}

			}			
		}
		pstat->mc2uc_pkts_pre = pstat->mc2uc_pkts;
#endif

#ifdef TX2_BK_QUEUE
		if (get_assoc_sta_num(priv, 0) == 2 && priv->pshare->rf_ft_var.tx2bk_th_rssi) {
			if (tx2bk_first_sta == NULL) {
				tx2bk_first_sta = pstat;
			} else {
				if ( (tx2bk_first_sta->rssi < priv->pshare->rf_ft_var.tx2bk_th_rssi 
					|| pstat->rssi < priv->pshare->rf_ft_var.tx2bk_th_rssi) 
					&& ((unsigned int)(tx2bk_first_sta->tx_bytes_1s>>17) > 4 || (unsigned int)(pstat->tx_bytes_1s>>17) > 4) )
				{
					if (((tx2bk_first_sta->tx_bytes_1s*5) > (pstat->tx_bytes_1s*6)) 
						&& ((tx2bk_first_sta->rssi+4) > pstat->rssi))
					{
						tx2bk_first_sta->tx2bk_on=0;
						tx2bk_chk_sta = pstat;
					} else if (((tx2bk_first_sta->tx_bytes_1s*6) < (pstat->tx_bytes_1s*5))
						&& (tx2bk_first_sta->rssi < (pstat->rssi+4)) )
					{
						pstat->tx2bk_on=0;
						tx2bk_chk_sta = tx2bk_first_sta;
					} 
					
					if (tx2bk_chk_sta) {
						if (tx2bk_chk_sta->tx2bk_on == 0) {
							if (tx2bk_chk_sta->wireless_mode & (WIRELESS_MODE_AC_5G | WIRELESS_MODE_AC_24G))
							{
								if (tx2bk_chk_sta->current_tx_rate < priv->pshare->rf_ft_var.tx2bk_th_rate_11ac
									|| (tx2bk_chk_sta->current_tx_rate < _NSS2_MCS3_RATE_ 
									&& tx2bk_chk_sta->current_tx_rate >= _NSS2_MCS0_RATE_))
								{
									tx2bk_chk_sta->tx2bk_on=1;
								}
							} else if (tx2bk_chk_sta->wireless_mode & (WIRELESS_MODE_N_5G | WIRELESS_MODE_N_24G))
							{  
								if (tx2bk_chk_sta->current_tx_rate < priv->pshare->rf_ft_var.tx2bk_th_rate_11n
									|| (tx2bk_chk_sta->current_tx_rate < _MCS11_RATE_ 
									&& tx2bk_chk_sta->current_tx_rate >= _MCS8_RATE_))
								{
									tx2bk_chk_sta->tx2bk_on=1;
								}
							}
						} else {
						    if (tx2bk_chk_sta->wireless_mode & (WIRELESS_MODE_AC_5G | WIRELESS_MODE_AC_24G))
						    {
								if ((tx2bk_chk_sta->current_tx_rate > (priv->pshare->rf_ft_var.tx2bk_th_rate_11ac)
									&& (tx2bk_chk_sta->current_tx_rate < _NSS2_MCS0_RATE_))
									|| (tx2bk_chk_sta->current_tx_rate > _NSS2_MCS3_RATE_))
								{
									tx2bk_chk_sta->tx2bk_on=0;
								}
							} else if (tx2bk_chk_sta->wireless_mode & (WIRELESS_MODE_N_5G | WIRELESS_MODE_N_24G))
							{
							    if (((tx2bk_chk_sta->current_tx_rate > (priv->pshare->rf_ft_var.tx2bk_th_rate_11n))
									&& (tx2bk_chk_sta->current_tx_rate < _MCS8_RATE_))
									|| (tx2bk_chk_sta->current_tx_rate > _MCS11_RATE_))
								{
									tx2bk_chk_sta->tx2bk_on=0;
								}
							} else {
								tx2bk_chk_sta->tx2bk_on=0;
							}
						}
					} else {
						pstat->tx2bk_on=0;
						tx2bk_first_sta->tx2bk_on=0;
					}
				} else {
					pstat->tx2bk_on=0;
					tx2bk_first_sta->tx2bk_on=0;
				}
			}
		} else {
		    pstat->tx2bk_on=0;
			if (tx2bk_first_sta)
				tx2bk_first_sta->tx2bk_on=0;
		}
#endif

		if ((priv->up_time % 3) == 0) {
#ifndef DRVMAC_LB
#if !defined(USE_OUT_SRC) || defined(_OUTSRC_COEXIST)
			if (is_auto_rate(priv, pstat)
				|| (should_restrict_Nrate(priv, pstat) && is_fixedMCSTxRate(priv, pstat)))
				check_RA_by_rssi(priv, pstat);
#endif
#endif

#if defined(CONFIG_RTL_92C_SUPPORT) || defined(CONFIG_RTL_92D_SUPPORT)
			if(CHIP_VER_92X_SERIES(priv))
				check_txrate_by_reg(priv, pstat);
#endif

			/*Now 8812 use txreport for get txreport and inital tx rate*/ 
			#if	0	//defined(CONFIG_RTL_8812_SUPPORT)	
			if(GET_CHIP_VER(priv)==VERSION_8812E){
				check_txrate_by_reg_8812(priv, pstat);
			}
			#endif

			/*
			 *	Check if station is 2T
			 */
		 	if (!pstat->is_2t_mimo_sta && (pstat->highest_rx_rate >= _MCS8_RATE_))
				pstat->is_2t_mimo_sta = TRUE;
#ifdef RTK_AC_SUPPORT
			// Dynamic Enable/Disable LDPC
			if ((pstat->IOTPeer == HT_IOT_PEER_REALTEK_8812) && 
				(pstat->wireless_mode & (WIRELESS_MODE_AC_5G|WIRELESS_MODE_AC_24G)) &&
				( (pstat->ht_cap_buf.ht_cap_info & cpu_to_le16(_HTCAP_SHORTGI_20M_ | _HTCAP_SHORTGI_40M_))
				|| ( cpu_to_le32(pstat->vht_cap_buf.vht_cap_info) & BIT(SHORT_GI80M_E))	
			)) {
				const char thd = 45;
#ifdef MCR_WIRELESS_EXTEND
				thd = priv->pshare->rf_ft_var.disable_ldpc_thd;
#endif				
				if (pstat->cmn_info.ldpc_en && (pstat->rssi > thd+5))
					pstat->cmn_info.ldpc_en = 0;
				else if ((pstat->cmn_info.ldpc_en == 0) && (pstat->rssi < thd)) {
					if (priv->pmib->dot11nConfigEntry.dot11nLDPC) {
						if (pstat->ht_cap_len && (pstat->ht_cap_buf.ht_cap_info & cpu_to_le16(_HTCAP_SUPPORT_RX_LDPC_)))
							pstat->cmn_info.ldpc_en |= HT_LDPC_EN;
#ifdef RTK_AC_SUPPORT
						if (pstat->vht_cap_len && (pstat->vht_cap_buf.vht_cap_info & cpu_to_le32(_VHTCAP_RX_LDPC_CAP_)))
							pstat->cmn_info.ldpc_en |= VHT_LDPC_EN;
#endif
					}
				}

			}			
#endif
#if !defined(USE_OUT_SRC) || defined(_OUTSRC_COEXIST)
#ifdef _OUTSRC_COEXIST
			if(!IS_OUTSRC_CHIP(priv))
#endif
			{

						/*
						 *	Check if station is near by to use lower tx power
						 */
						if((priv->pshare->FA_total_cnt > 1000) || (priv->pshare->FA_total_cnt > 300 && (RTL_R8(0xc50) & 0x7f) >= 0x32)) {
							pstat->hp_level = 0;
						} else {
							if (priv->pshare->rf_ft_var.tx_pwr_ctrl) {
								if ((pstat->hp_level == 0) && (pstat->rssi > HP_LOWER+4)){
									pstat->hp_level = 1;
								}else if ((pstat->hp_level == 1) && (pstat->rssi < (HP_LOWER - 4) )){
									pstat->hp_level = 0;
			                    }
							}				
						}
			}
#endif
		}
#if 0		
		{	
#ifdef CONFIG_WLAN_HAL_8814AE			
			if(GET_CHIP_VER(priv)==VERSION_8814A) {
				pstat->useCts2self=0; // always RTS
			} else 
#endif			
			{
				if (!pstat->useCts2self && pstat->rssi > priv->pshare->rf_ft_var.rts_rssith+5)
					pstat->useCts2self=1; // cts2self
				else if(pstat->useCts2self && pstat->rssi<priv->pshare->rf_ft_var.rts_rssith) 
					pstat->useCts2self=0; // RTS
			}
		}
#endif	

#ifdef RTK_AC_SUPPORT
		if( (AC_SIGMA_MODE==AC_SIGMA_NONE)
		&& ((GET_CHIP_VER(priv) == VERSION_8812E) || (GET_CHIP_VER(priv) == VERSION_8812E) )
		&& (pstat->wireless_mode & WIRELESS_MODE_AC_5G)
		&& (((le32_to_cpu(pstat->vht_cap_buf.vht_support_mcs[0]) >> 2) & 3) == 3)		// 1T1R
		)
		{
			pstat->useCts2self=1; 
		} else 
#endif
		{
			pstat->useCts2self=0; // always RTS
		}

#ifdef dybw_tx
		if(OPMODE & WIFI_AP_STATE) {
			if(priv->pshare->rf_ft_var.bws_enable & 0x2) {
				if(GET_CHIP_VER(priv) == VERSION_8812E)
					dynamic_AC_bandwidth(priv,pstat);
#if defined(WIFI_11N_2040_COEXIST_EXT)
                if((GET_CHIP_VER(priv) == VERSION_8192E) && priv->pmib->dot11nConfigEntry.dot11nCoexist)
					dynamic_N_bandwidth(priv,pstat);
#endif
			}
		}
#endif

		if (pstat->IOTPeer == HT_IOT_PEER_INTEL)
		{
#if 0/*def CONFIG_RTL_92D_SUPPORT*/
			if (GET_CHIP_VER(priv) == VERSION_8192D) {
				if ((((priv->ext_stats.tx_avarage>>17) + (priv->ext_stats.rx_avarage>>17)) > 80) && (pstat->no_rts == 1))
					pstat->no_rts = 0;
				else if ((((priv->ext_stats.tx_avarage>>17) + (priv->ext_stats.rx_avarage>>17)) < 60) && (pstat->no_rts == 0))
					pstat->no_rts = 1;
			}
#endif
#if 0/*def CONFIG_RTL_88E_SUPPORT*/
			if (GET_CHIP_VER(priv)==VERSION_8188E) {
				const char thd = 20;
				if (!pstat->no_rts && pstat->rssi<thd)
					pstat->no_rts=1;
				else if(pstat->no_rts && pstat->rssi>thd+5) 
					pstat->no_rts=0;
			}
#endif
#if	defined(CONFIG_RTL_8812_SUPPORT) || defined(CONFIG_RTL_8723B_SUPPORT)
			if (GET_CHIP_VER(priv)==VERSION_8812E || GET_CHIP_VER(priv)==VERSION_8723B) {
				const char thd = 40;
				if (!pstat->no_rts && (pstat->rssi < thd))
				{
					pstat->no_rts=1;
					//printk("Disable rts !!\n");
				}
				else if(pstat->no_rts && (pstat->rssi > (thd+5))) 
				{
					pstat->no_rts=0;
					//printk("Enable rts !!\n");
				}
			}
#endif

			if(priv->pshare->rf_ft_var.rts_iot_th) {
				if (!pstat->no_rts && (pstat->rssi > priv->pshare->rf_ft_var.rts_iot_th))
				{
					pstat->no_rts=1;
					pstat->useCts2self=1;
				}
				else if(pstat->no_rts && (pstat->rssi < (priv->pshare->rf_ft_var.rts_iot_th-3))) 
				{
					pstat->no_rts=0;
					pstat->useCts2self=0;
				}
			}

			/* Count every Intel clients with complying throughput margin */
			if ((pstat->tx_byte_cnt + pstat->rx_byte_cnt) >= priv->pshare->rf_ft_var.intel_rtylmt_tp_margin)
				priv->pshare->intel_active_sta++;
		}

#ifdef USE_OUT_SRC	
#ifdef _OUTSRC_COEXIST
		if(IS_OUTSRC_CHIP(priv))
#endif
		ChooseIotMainSTA(priv, pstat);
#endif

#if !defined(USE_OUT_SRC) || defined(_OUTSRC_COEXIST)
#ifdef _OUTSRC_COEXIST
		if(!IS_OUTSRC_CHIP(priv))
#endif
		choose_IOT_main_sta(priv, pstat);
#endif

#ifdef SW_TX_QUEUE
		if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE) {
#ifdef RTK_ATM
			if(!priv->pshare->rf_ft_var.atm_en)
#endif
	        {
	            SMP_LOCK_XMIT(flags_xmit);  
	            for (i=BK_QUEUE;i<=VO_QUEUE;i++) 
	            {				
	                if(priv->pshare->swq_use_hw_timer) {
	                    if (priv->pshare->swq_en && pstat->swq.swq_en[i] && (pstat->tx_avarage > 25000) && (pstat->ht_cap_len)) {                        
	                        adjust_swq_setting(priv, pstat, i, CHECK_INC_AGGN);
	                    }                             
	                }
	                else {
	                    int q_aggnumIncSlow = (priv->assoc_num > 1) ? (2+pstat->swq.q_aggnumIncSlow[i]) : (1+pstat->swq.q_aggnumIncSlow[i]);
	                    if ((priv->pshare->swq_en == 0) /*|| (((priv->ext_stats.tx_avarage>>17) + (priv->ext_stats.rx_avarage>>17)) < 20)*/) { // disable check for small udp packet(88B) test with veriwave tool
	                        pstat->swq.q_aggnumIncSlow[i] = 0;
	                    }
	                    else if (((priv->up_time % q_aggnumIncSlow) == 0) && 
	                            ((priv->pshare->swqen_keeptime != 0) && 
	                            (priv->up_time > priv->pshare->swqen_keeptime+3)) && 
	                            (pstat->tx_avarage > 25000) && (pstat->ht_cap_len)) {
	                        adjust_swq_setting(priv, pstat, i, CHECK_INC_AGGN);
	                    }             

	                }

	                /*clear used*/
	                pstat->swq.q_used[i] = 0;
	                pstat->swq.q_TOCount[i] = 0;
	            }
	            SMP_UNLOCK_XMIT(flags_xmit);    
	        }
		}
#endif

#ifdef CONFIG_STATISTICS_INFO
		pstat->tx_average_int += (unsigned int)((pstat->tx_byte_cnt)>>7);
		pstat->rx_average_int += (unsigned int)(pstat->rx_byte_cnt>>7);
		if((priv->pshare->rf_ft_var.stats_int != 0) && !(priv->up_time % (priv->pshare->rf_ft_var.stats_int*60))) {
			DRV_RT_TRACE(priv, DRV_DBG_STATISTICS_INFO, DRV_DBG_SERIOUS, "aid: %d, hwaddr: %pm TX: %d, RX: %d (kbps)\n",
				pstat->aid, pstat->cmn_info.mac_addr,
				pstat->tx_average_int/(priv->pshare->rf_ft_var.stats_int*60),
				pstat->rx_average_int/(priv->pshare->rf_ft_var.stats_int*60));
			
			pstat->tx_average_int = 0;
			pstat->rx_average_int = 0;
		}
#endif

		// calculate tx/rx throughput
		pstat->tx_avarage = (pstat->tx_avarage/10)*7 + (pstat->tx_byte_cnt/10)*3;
		pstat->cmn_info.tx_moving_average_tp = (pstat->cmn_info.tx_moving_average_tp/10)*1 + ((pstat->tx_byte_cnt>>17)/10)*9;
		pstat->tx_byte_cnt = 0;
		pstat->rx_avarage = (pstat->rx_avarage/10)*7 + (pstat->rx_byte_cnt/10)*3;
		pstat->cmn_info.rx_moving_average_tp = (pstat->cmn_info.rx_moving_average_tp/10)*1 + ((pstat->rx_byte_cnt>>17)/10)*9;
		pstat->rx_byte_cnt = 0;

#ifdef PREVENT_BROADCAST_STORM
		// reset rx_pkts_bc in every one second
		pstat->rx_pkts_bc = 0;
#endif
		if ((pstat->tx_avarage + pstat->rx_avarage) > highest_tp) {
			highest_tp = pstat->tx_avarage + pstat->rx_avarage;
			pstat_highest = pstat;
		}
#if defined(HW_ANT_SWITCH)&&( defined(CONFIG_RTL_92C_SUPPORT) || defined(CONFIG_RTL_92D_SUPPORT))
		if(HW_DIV_ENABLE)
			dm_STA_Ant_Select(priv, pstat);
#endif

#ifdef SUPPORT_TX_AMSDU_SMALL_PKTS_ONLY
	if (priv->pmib->dot11nConfigEntry.dot11nAMSDUSmallPkts) {
		pstat->amsdu_tcpack_en = (pstat->rx_pkts2 - pstat->rx_pkts2_pre > priv->pshare->rf_ft_var.amsdu_tcpack_pkt_th) ? 1 : 0;
		if (priv->pmib->dot11nConfigEntry.dot11nAMSDUTCPAckDropDup) {
			int cnt = 0;
			for (i = 0; i < TCPACK_SESSION_MAX_ENTERY; i++) {
				if (pstat->amsdu_tcpack_ses[i].used == 2)
					cnt++;
				if (pstat->amsdu_tcpack_ses[i].flag)
					pstat->amsdu_tcpack_ses[i].timeout = TCPACK_SESSION_TIMEOUT;
				if (pstat->amsdu_tcpack_ses[i].timeout - 1 >= 0)
					pstat->amsdu_tcpack_ses[i].timeout--;

				pstat->amsdu_tcpack_ses[i].flag = 0;
				pstat->amsdu_tcpack_ses[i].ack_cnt = 0;
				if (pstat->amsdu_tcpack_ses[i].timeout == 0)
					pstat->amsdu_tcpack_ses[i].used = 0;
			}
			pstat->amsdu_tcpack_ses_cnt = cnt;
			if (pstat->amsdu_tcpack_en && pstat->amsdu_tcpack_ses_cnt >= 2)
				pstat->amsdu_dropdupack_en = 1;
			else
				pstat->amsdu_dropdupack_en = 0;
		}
	}
#endif

	/* veriwave 5G throughput TCP Rx check */
	if(priv->pshare->CurrentChannelBW == CHANNEL_WIDTH_80 && priv->pmib->dot11BssType.net_work_type & WIRELESS_11AC) {
		if(pstat->rx_pkts2 - pstat->rx_pkts2_pre > 33000 && pstat->tcpack_pkts - pstat->tcpack_pkts_pre > 15000)
			pstat->veriwave_5G_TCP_Rx_test = 1;
		else 
			pstat->veriwave_5G_TCP_Rx_test = 0;
	}
	
#ifdef TCP_ACK_ACC
	if(priv->pmib->miscEntry.tcpack_acc) {
	int sta_tcpack_acc_en = 0;
		if(priv->pmib->dot11BssType.net_work_type & WIRELESS_11AC) {
			if(pstat->rx_pkts2 - pstat->rx_pkts2_pre > 8700)
				sta_tcpack_acc_en = 1;
		}
		else if(priv->pmib->dot11BssType.net_work_type & WIRELESS_11N) {
			if(priv->pshare->CurrentChannelBW == CHANNEL_WIDTH_20) {
				if(pstat->rx_pkts2 - pstat->rx_pkts2_pre > 8700)
					sta_tcpack_acc_en = 2;
			}
			else if(priv->pshare->CurrentChannelBW == CHANNEL_WIDTH_40) {
				if(pstat->rx_pkts2 - pstat->rx_pkts2_pre > 14000)
					sta_tcpack_acc_en = 2;
			}
		}
		pstat->tcpack_acc_en = sta_tcpack_acc_en;
	}
#endif

#if 0 //def CONFIG_VERIWAVE_CHECK
	{
		unsigned int tmp_fa = 0;
#ifdef USE_OUT_SRC
#ifdef _OUTSRC_COEXIST
		if (IS_OUTSRC_CHIP(priv))//outsrc chip use odmFAStatistic
#endif
			tmp_fa = ODMPTR->FalseAlmCnt.Cnt_all;
#endif
#if !defined(USE_OUT_SRC) || defined(_OUTSRC_COEXIST)
#ifdef _OUTSRC_COEXIST
		if (!IS_OUTSRC_CHIP(priv))
#endif
			tmp_fa = priv->pshare->FA_total_cnt;	
#endif
		if(priv->assoc_num == 1 && tmp_fa <= priv->pshare->rf_ft_var.vwchk_fa
			&& (pstat->IOTPeer == HT_IOT_PEER_UNKNOWN || pstat->IOTPeer == HT_IOT_PEER_VERIWAVE) && pstat->tx_bw == CHANNEL_WIDTH_40
			&& (UINT32_DIFF(priv->pshare->wifi_rx_pkts[2], priv->pshare->wifi_rx_pkts[0]) < 2)
			&& (UINT32_DIFF(priv->pshare->check_MACBBTX_counter, priv->pshare->check_MACBBTX_counter_pre) > 2)
			&& (priv->pmib->dot11RFEntry.dot11channel <= 14)) 
		{
			pstat->veriwave_2G_RvR_test = 1;
		} else {
			if(pstat->veriwave_2G_RvR_test == 1 && (priv->pshare->check_MACBBTX_counter == priv->pshare->check_MACBBTX_counter_pre)) {
				pstat->veriwave_recover_cnt++;
				if(pstat->veriwave_recover_cnt == 6) 
				{
					pstat->veriwave_2G_RvR_test = 0;
					pstat->veriwave_recover_cnt = 0;
					pstat->current_tx_pkt_size = VERIWAVE_PKT_SIZE_BIG;

#ifdef CONFIG_WLAN_HAL_8192EE
					if(GET_CHIP_VER(priv) == VERSION_8192E) {
						GET_HAL_INTERFACE(priv)->UpdateHalRAMaskHandler(priv, pstat, 3);
					}
#endif
				}
			} else {
				pstat->veriwave_recover_cnt = 0;
			}
		}
		if(pstat->veriwave_2G_RvR_test == 1) {
			if(pstat->current_tx_pkt_size == VERIWAVE_PKT_SIZE_BIG) {
				if(pstat->tx_sml_pkts - pstat->tx_sml_pkts_pre > pstat->tx_big_pkts - pstat->tx_big_pkts_pre) {
					pstat->current_tx_pkt_size = VERIWAVE_PKT_SIZE_SML;
#ifdef CONFIG_WLAN_HAL_8192EE
					if(GET_CHIP_VER(priv) == VERSION_8192E) {
						GET_HAL_INTERFACE(priv)->UpdateHalRAMaskHandler(priv, pstat, 3);
					}
#endif
				}
			} else if(pstat->current_tx_pkt_size == VERIWAVE_PKT_SIZE_SML) {
				if(pstat->tx_sml_pkts - pstat->tx_sml_pkts_pre < pstat->tx_big_pkts - pstat->tx_big_pkts_pre) {
					pstat->current_tx_pkt_size = VERIWAVE_PKT_SIZE_BIG;
#ifdef CONFIG_WLAN_HAL_8192EE
					if(GET_CHIP_VER(priv) == VERSION_8192E) {
						GET_HAL_INTERFACE(priv)->UpdateHalRAMaskHandler(priv, pstat, 3);
					}
#endif
				}
			}
		}
	}
#endif

    //UDP veriwave throughput test  
            
    if(pstat->current_tx_pkt_size == VERIWAVE_PKT_SIZE_BIG){       
        if(pstat->tx_sml_pkts - pstat->tx_sml_pkts_pre > pstat->tx_big_pkts - pstat->tx_big_pkts_pre) 
            pstat->current_tx_pkt_size = VERIWAVE_PKT_SIZE_SML;       
        
    }else if(pstat->current_tx_pkt_size == VERIWAVE_PKT_SIZE_SML){
        if( pstat->tx_sml_pkts - pstat->tx_sml_pkts_pre < pstat->tx_big_pkts - pstat->tx_big_pkts_pre) 
            pstat->current_tx_pkt_size = VERIWAVE_PKT_SIZE_BIG;   
    }

		if (IS_SUPPORT_TX_AMSDU(priv)) {
            assign_aggre_mthod(priv,pstat);

#if (defined(CONFIG_WLAN_HAL_8822BE) || defined(CONFIG_WLAN_HAL_8812FE)) && defined(CONFIG_SPECIAL_ENV_TEST)
			//auto adjust dot11nCurAMSDUSendNum need refine...
			if(priv->pshare->rf_ft_var.auto_amsdu_vw){
				if((priv->pshare->in_spec_env_test_to) && ((GET_CHIP_VER(priv) == VERSION_8822B) || (GET_CHIP_VER(priv) == VERSION_8812F))) {
					if (pstat->current_tx_pkt_size == VERIWAVE_PKT_SIZE_BIG) {
						priv->pmib->dot11nConfigEntry.dot11nCurAMSDUSendNum = 4;
					} else if (pstat->current_tx_pkt_size == VERIWAVE_PKT_SIZE_SML) {
						priv->pmib->dot11nConfigEntry.dot11nCurAMSDUSendNum = 8;
					}
					if (priv->pmib->dot11nConfigEntry.dot11nCurAMSDUSendNum > WLAN_HAL_TX_AMSDU_MAX_NUM)
						priv->pmib->dot11nConfigEntry.dot11nCurAMSDUSendNum = WLAN_HAL_TX_AMSDU_MAX_NUM;
				}
			}
#endif
		}

		/*
	         * Broadcom, Intel IOT, dynamic inc or dec retry count
        	 */


			if ((pstat->IOTPeer == HT_IOT_PEER_BROADCOM) || (pstat->IOTPeer == HT_IOT_PEER_INTEL))
        	{
					if (((pstat->tx_avarage + pstat->rx_avarage >= RETRY_TRSHLD_H) 
#ifdef CLIENT_MODE
					|| ((OPMODE & WIFI_STATION_STATE) && (pstat->IOTPeer == HT_IOT_PEER_BROADCOM) &&  (pstat->rssi >= 45))
#endif
						) && (pstat->retry_inc == 0))
        	        {
#ifdef TX_SHORTCUT
				clearTxShortCutBufSize(priv, pstat);
#endif
	                        pstat->retry_inc = 1;
        	        }
					else if (((pstat->tx_avarage + pstat->rx_avarage < RETRY_TRSHLD_L) 
#ifdef CLIENT_MODE
						|| ((OPMODE & WIFI_STATION_STATE) && (pstat->IOTPeer == HT_IOT_PEER_BROADCOM) &&  (pstat->rssi <= 30))
#endif
						)&& (pstat->retry_inc == 1))
	                {
#ifdef TX_SHORTCUT
				clearTxShortCutBufSize(priv, pstat);
#endif
						pstat->retry_inc = 0;
        	        }
        	}

		if (((int)pstat->expire_to > ((int)priv->expire_to - priv->pshare->rf_ft_var.rssi_expire_to))
#ifdef DETECT_STA_EXISTANCE
			&& (!pstat->leave) 
#endif
			)
		{
			if (pstat->rssi < priv->pshare->rssi_min) {
				if ( !IEEE8021X_FUN ||
					(IEEE8021X_FUN && pstat->ieee8021x_ctrlport != DOT11_PortStatus_Unauthorized) )
					priv->pshare->rssi_min = pstat->rssi;
					
				for(i = 0; i <= 3; i++) {
					if(pstat->rf_info.mimorssi[i] != 0) {
						if(pstat->rf_info.mimorssi[i] < priv->pshare->mimorssi_min)
							priv->pshare->mimorssi_min = pstat->rf_info.mimorssi[i];
					}
				}
			}
			
#ifdef RSSI_MIN_ADV_SEL
			collect_min_rssi_data(priv, pstat);
#endif
		}

#ifdef MCR_WIRELESS_EXTEND
		if (pstat->IOTPeer == HT_IOT_PEER_CMW)
			priv->pshare->rssi_min = pstat->rssi;
#endif

#ifdef RTK_ATM
		if(priv->pshare->rf_ft_var.atm_en)
			priv->atm_sta_num++;//check sta num of per SSID					
#endif//RTK_ATM

		/*
		 *	Periodically clear ADDBAreq sent indicator
		 */
		if ((pstat->expire_to > 0) && pstat->ht_cap_len && (pstat->aggre_mthd & AGGRE_MTHD_MPDU))
			memset(pstat->ADDBA_sent, 0, 8);
			memset(pstat->ADDBA_accu, 0, 8);

#if defined(INCLUDE_WPA_PSK) && !defined(WIFI_HAPD) && !defined(RTK_NL80211) /*update unicast key by hostapd !*/
		// Update unicast key
		if (priv->pmib->dot1180211AuthEntry.dot11UKRekeyTime)
		{
			if (priv->pmib->dot1180211AuthEntry.dot11EnablePSK) {
				if (pstat->uk_timeout)
					pstat->uk_timeout --;
				else {
					if (pstat->wpa_sta_info->state == PSK_STATE_PTKINITDONE)
						UKRekeyTimeout(priv, pstat);
				}
			}
		}
#endif
		if (pstat->rssi < priv->pmib->dot11StationConfigEntry.RmStaRSSIThreshold) {			
			unsigned char sta_mac[16];		
			sprintf(sta_mac,"%pm", pstat->cmn_info.mac_addr);
#ifdef STA_ASSOC_STATISTIC
			add_disconnect_sta(priv, pstat->cmn_info.mac_addr, pstat->rssi);	
			add_sta_assoc_status(priv, pstat->cmn_info.mac_addr, pstat->rssi, 1 | 0x100);
#endif			
			DRV_RT_TRACE(priv, DRV_DBG_CONN_INFO, DRV_DBG_SERIOUS, "del_sta - %pm\n",pstat->cmn_info.mac_addr);
			del_sta(priv, sta_mac);
		}

#ifdef STA_ROAMING_CHECK
        int ret;
        if(pstat && priv->pmib->rlr_profile.roaming_switch && !priv->pmib->rlr_profile.roaming_qos) {
            ret = RoamingCheck(priv, pstat);
            if(ret)
            {
                unsigned char sta_mac[16];      
                sprintf(sta_mac,"%pm", pstat->cmn_info.mac_addr);
#ifdef STA_ASSOC_STATISTIC
                add_disconnect_sta(priv, pstat->cmn_info.mac_addr, pstat->rssi);
				add_sta_assoc_status(priv, pstat->cmn_info.mac_addr, pstat->rssi, 1 | 0x100);
#endif
				// del_sta branch 14, assoc_expire check rssi < RmStaRSSIThreshold
				//priv->del_sta_info.branch_code = 14;

                del_sta(priv, sta_mac);
            }    
        }
#endif

#ifdef STA_RATE_STATISTIC		
		sta_rate_statistics(pstat);
#endif
		
#if defined(SUPPORT_TX_AMSDU) && !defined(SUPPORT_TX_SWQ_AMSDU)
		if (AMSDU_ENABLE >= 2) {
			extern int amsdu_timer_add(struct rtl8192cd_priv *priv, struct stat_info *pstat, int tid, int from_timeout);
			int a;

			SMP_LOCK_XMIT(flags_xmit);
			for (a=0; a<8; a++) {
				if (skb_queue_len(&pstat->amsdu_tx_que[a]) > 0 && pstat->amsdu_timer_id[a] == 0)
					pstat->amsdu_timer_id[a] = amsdu_timer_add(priv, pstat, a, 2) + 1;
			}
			SMP_UNLOCK_XMIT(flags_xmit);
		}
#endif

#ifdef ROAMING_SUPPORT
		if(priv->pmib->roamingEntry.roaming_enable &&
		   (pstat->state & WIFI_ASOC_STATE) && (pstat->expire_to > 0))
		{
			if(pstat->link_time >= priv->pmib->roamingEntry.roaming_st_time){
				if(pstat->rssi < priv->pmib->roamingEntry.roaming_rssi_th1 && !pstat->roaming_indication){
					if(pstat->roaming_waitcount >= priv->pmib->roamingEntry.roaming_wait_time){
						DEBUG_INFO("[Roaming] STA %pm rssi too low (%d)\n",	pstat->cmn_info.mac_addr,pstat->rssi);
						pstat->roaming_indication = 1;
						general_IndicateEvent(priv,DOT11_EVENT_ROAMING_STA_RSSI_ALARM, pstat);
						pstat->roaming_waitcount = 0;
					}
					else{
						pstat->roaming_waitcount++;
					}
				}
				else if(pstat->rssi > priv->pmib->roamingEntry.roaming_rssi_th2 && pstat->roaming_indication == 1){
					if(pstat->roaming_waitcount >= priv->pmib->roamingEntry.roaming_wait_time){
						DEBUG_INFO("[Roaming] STA %pm close rssi alarm (%d)\n",
							pstat->cmn_info.mac_addr,pstat->rssi);
						pstat->roaming_indication = 0;
						general_IndicateEvent(priv,DOT11_EVENT_ROAMING_STA_RSSI_ALARM, pstat);
						pstat->roaming_waitcount = 0;
					}
					else{
						pstat->roaming_waitcount++;
					}
				}
				else{
					pstat->roaming_waitcount = 0;
				}
			}
			else{
				if(pstat->rssi < priv->pmib->roamingEntry.roaming_rssi_th1){
						pstat->roaming_waitcount++;
				}
				else{
					pstat->roaming_waitcount = 0;
				}
			}
			DEBUG_INFO("roaming_waitcount = %d,indication state = %d\n",pstat->roaming_waitcount,pstat->roaming_indication);
		}
		else{
			pstat->roaming_waitcount = 0;
		}
#endif

#ifdef DOT11K
	if ((pstat->sm.cca_result == MEASUREMENT_PROCESSING) || (pstat->sm.cca_result == MEASUREMENT_RECEIVED))
		sm_cca_expire(pstat);
	if ((pstat->sm.rpi_result == MEASUREMENT_PROCESSING) || (pstat->sm.rpi_result == MEASUREMENT_RECEIVED))
		sm_rpi_expire(pstat);
#endif

        if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE)
            SMP_LOCK_ASOC_LIST(flags);
		if (plist == plist->next)
			break;
	}	
	if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE)
		SMP_UNLOCK_ASOC_LIST(flags);
    
#ifdef RTK_ATM
	if(priv->pshare->rf_ft_var.atm_en){
		//set sta time connected to this interface
		if(priv->atm_sta_num > 0)
			atm_set_statime(priv);
	}
#endif

	/*dynamic tuning response date rate*/
#if defined(UNIVERSAL_REPEATER) || defined(MBSSID)
	if (IS_ROOT_INTERFACE(priv))
#endif
	{
#ifdef MP_TEST
		if (!((OPMODE & WIFI_MP_STATE) || priv->pshare->rf_ft_var.mp_specific))
#endif
		{		
			if (priv->up_time % 2){
				if(priv->pshare->rssi_min!=0xff){
					if(GET_CHIP_VER(priv) < VERSION_8814A)
						dynamic_response_rate(priv, priv->pshare->rssi_min);
				}
			}			
		}		
	}


#if defined(HW_ANT_SWITCH)&&( defined(CONFIG_RTL_92C_SUPPORT) || defined(CONFIG_RTL_92D_SUPPORT))
	if(HW_DIV_ENABLE)  {
		dm_HW_IdleAntennaSelect(priv);
	}
#endif

	/*
	 * Intel IOT, dynamic enhance beacon tx AGC
	 */
	pstat = pstat_highest;

	if (pstat && pstat->IOTPeer == HT_IOT_PEER_INTEL)
	{
		const char thd = 25;
		if (!priv->bcnTxAGC) {
			if (pstat->rssi < thd)
				priv->bcnTxAGC = 2;
			else if (pstat->rssi < thd+5)
				priv->bcnTxAGC = 1;
		} else if (priv->bcnTxAGC == 1) {
			if (pstat->rssi < thd)
				priv->bcnTxAGC = 2;
			else if (pstat->rssi > thd+10)
				priv->bcnTxAGC = 0;
		} else if (priv->bcnTxAGC == 2) {
			if (pstat->rssi > thd+10)
				priv->bcnTxAGC = 0;
			else if (pstat->rssi > thd+5)
				priv->bcnTxAGC = 1;
		}
 	} else {
		if (priv->bcnTxAGC)
		 	priv->bcnTxAGC = 0;
	}

#if defined(CONFIG_WLAN_HAL_8814BE)&& defined(SUPPORT_TX_SWQ_AMSDU) && defined(CONFIG_SPECIAL_ENV_TEST)
	if(GET_CHIP_VER(priv) == VERSION_8814B && !priv->pshare->rf_ft_var.manual_amsdu_merge) {
		if(priv->pshare->veriwave_sta_num) {
			priv->pshare->rf_ft_var.amsdu_merge = 8;
		} else if(pstat && priv->pshare->total_assoc_num == 1 && priv->pshare->macbook_sta_num) {
			if(pstat->aggre_mthd == AGGRE_MTHD_MPDU)
				priv->pshare->rf_ft_var.amsdu_merge = 2;
			else
				priv->pshare->rf_ft_var.amsdu_merge = 4;
		} else {
			priv->pshare->rf_ft_var.amsdu_merge = priv->pshare->rf_ft_var.amsdu_merge_default;
		}
	}
#endif

#ifdef CONFIG_RTL_OFFLOAD_DRIVER
    /* update sta_info to data cpu */
    dc_sta_update_group(priv);
#endif
}


#ifdef WDS
static void wds_probe_expire(struct rtl8192cd_priv *priv)
{
	struct stat_info	*pstat;
	unsigned int i;

	if ((priv->up_time % 30) != 5)
		return;

	for (i = 0; i < priv->pmib->dot11WdsInfo.wdsNum; i++) {
		pstat = get_stainfo(priv, priv->pmib->dot11WdsInfo.entry[i].macAddr);
		if (pstat) {
			if (pstat->wds_probe_done)
				continue;
			issue_probereq(priv, NULL, 0, pstat->cmn_info.mac_addr);
		}
	}
}
#endif

BOOLEAN check_adaptivity_test(struct rtl8192cd_priv *priv)
{			
	unsigned int 	value32 = 0;

	if ( !priv->pshare->rf_ft_var.adaptivity_enable )
		return FALSE;

#ifdef USE_OUT_SRC
	if (IS_OUTSRC_CHIP(priv)) 
	{
		struct dm_struct *dm = ODMPTR;
		return phydm_cmn_info_query(dm, PHYDM_INFO_EDCCA_FLAG);
	}	
	else if(_OUTSRC_COEXIST_CONF_EXIST)
#endif
	{
		phy_set_bb_reg(priv,0x908, bMaskDWord, 0x208);
		value32 = phy_query_bb_reg(priv, 0xdf4, bMaskDWord);

		if ( (GET_CHIP_VER(priv) == VERSION_8188E) && (value32 & BIT30) )	// for OSK platform
			return TRUE;
		else if(value32 & BIT29)
			return TRUE;
		else
			return FALSE;
	}
}

#ifdef CHECK_HANGUP
#ifdef CONFIG_PCI_HCI
#ifdef CHECK_TX_HANGUP
static int check_tx_hangup(struct rtl8192cd_priv *priv, int q_num, int *pTail, int *pIsEmpty)
{
	struct tx_desc	*pdescH, *pdesc;
	volatile int	head, tail;
	struct rtl8192cd_hw	*phw;

	phw	= GET_HW(priv);
	head	= get_txhead(phw, q_num);
	tail	= get_txtail(phw, q_num);
	pdescH	= get_txdesc(phw, q_num);

	*pTail = tail;
#ifdef OSK_LOW_TX_DESC
	if (CIRC_CNT_RTK(head, tail, ((q_num==BE_QUEUE || q_num==HIGH_QUEUE)?BE_TXDESC:NONBE_TXDESC) ))
#else
	if (CIRC_CNT_RTK(head, tail, CURRENT_NUM_TX_DESC))
#endif
	{
		*pIsEmpty = 0;
		pdesc = pdescH + (tail);

#ifdef __MIPSEB__
		pdesc = (struct tx_desc *)KSEG1ADDR(pdesc);
#endif
		if (pdesc && ((get_desc(pdesc->Dword0)) & TX_OWN)) // pending
		{	
			//	In adaptivity test, we need avoid check tx hang
		//	if( check_adaptivity_test(priv) )
		//		return 0;			
		//	else
			return 1;
		}
	}
	else
		*pIsEmpty = 1;

	return 0;
}
#endif


#ifdef CHECK_RX_HANGUP
static void check_rx_hangup_send_pkt(struct rtl8192cd_priv *priv)
{
	struct stat_info *pstat;
	struct list_head *phead = &priv->asoc_list;
	struct list_head *plist = phead;
	DECLARE_TXINSN(txinsn);

	while ((plist = asoc_list_get_next(priv, plist)) != phead)
	{
		pstat = list_entry(plist, struct stat_info, asoc_list);

		if (pstat->expire_to > 0) {
			txinsn.retry = priv->pmib->dot11OperationEntry.dot11ShortRetryLimit;

			txinsn.q_num = MANAGE_QUE_NUM;
#ifdef P2P_SUPPORT	/*cfg p2p cfg p2p*/
        	if( rtk_p2p_is_enabled(priv) ){
              	txinsn.tx_rate = _6M_RATE_;
        	}else
#endif            
			txinsn.tx_rate = find_rate(priv, NULL, 0, 1);
#ifndef TX_LOWESTRATE			
			txinsn.lowest_tx_rate = txinsn.tx_rate;
#endif			
			txinsn.fixed_rate = 1;
			txinsn.fr_type = _PRE_ALLOCHDR_;
			txinsn.phdr = get_wlanhdr_from_poll(priv);
			txinsn.pframe = NULL;

			if (txinsn.phdr == NULL)
				goto send_test_pkt_fail;

			memset((void *)(txinsn.phdr), 0, sizeof (struct	wlan_hdr));

			SetFrameSubType(txinsn.phdr, WIFI_DATA_NULL);

			if (OPMODE & WIFI_AP_STATE) {
				memcpy((void *)GetAddr1Ptr((txinsn.phdr)), pstat->cmn_info.mac_addr, MACADDRLEN);
				memcpy((void *)GetAddr2Ptr((txinsn.phdr)), BSSID, MACADDRLEN);
				memcpy((void *)GetAddr3Ptr((txinsn.phdr)), BSSID, MACADDRLEN);
			}
			else {
				memcpy((void *)GetAddr1Ptr((txinsn.phdr)), BSSID, MACADDRLEN);
				memcpy((void *)GetAddr2Ptr((txinsn.phdr)), pstat->cmn_info.mac_addr, MACADDRLEN);
				memcpy((void *)GetAddr3Ptr((txinsn.phdr)), BSSID, MACADDRLEN);
			}

			txinsn.hdr_len = WLAN_HDR_A3_LEN;

			if ((rtl8192cd_firetx(priv, &txinsn)) == SUCCESS) {
				asoc_list_unref(priv, pstat);
				return;
			}

send_test_pkt_fail:

			if (txinsn.phdr)
				release_wlanhdr_to_poll(priv, txinsn.phdr);
		}
	}
}


static void check_rx_hangup(struct rtl8192cd_priv *priv)
{
	if (priv->rx_start_monitor_running == 0) {
		if (UINT64_DIFF(priv->rx_packets_pre1, priv->rx_packets_pre2) > 20) {
			priv->rx_start_monitor_running = 1;
			//printk("start monitoring = %d\n", priv->rx_start_monitor_running);
		}
	}
#ifdef __LINUX_3_7__
	else if (priv->rx_start_monitor_running == 1) {
		if (UINT64_DIFF((unsigned long long)priv->net_stats.rx_packets, priv->rx_packets_pre1) == 0)
			priv->rx_start_monitor_running = 2;
		else if (UINT64_DIFF((unsigned long long)priv->net_stats.rx_packets, priv->rx_packets_pre1) < 2 &&
			UINT64_DIFF((unsigned long long)priv->net_stats.rx_packets, priv->rx_packets_pre1) > 0) {
			priv->rx_start_monitor_running = 0;
			//printk("stop monitoring = %d\n", priv->rx_start_monitor_running);
		}
	}
#else // ! __LINUX_3_7__
	else if (priv->rx_start_monitor_running == 1) {
		if (UINT32_DIFF(priv->net_stats.rx_packets, (unsigned long)priv->rx_packets_pre1) == 0)
			priv->rx_start_monitor_running = 2;
		else if (UINT32_DIFF(priv->net_stats.rx_packets, (unsigned long)priv->rx_packets_pre1) < 2 &&
			UINT32_DIFF(priv->net_stats.rx_packets, (unsigned long)priv->rx_packets_pre1) > 0) {
			priv->rx_start_monitor_running = 0;
			//printk("stop monitoring = %d\n", priv->rx_start_monitor_running);
		}
	}
#endif // __LINUX_3_7__

	if (priv->rx_start_monitor_running >= 2) {
		//printk("\n\n%s %d start monitoring = 2 rx_packets_pre1=%lu; rx_packets_pre2=%lu; net_stats.rx_packets=%lu\n",
			//__FUNCTION__, __LINE__,
			//priv->rx_packets_pre1, priv->rx_packets_pre2,
			//priv->net_stats.rx_packets);
		priv->pshare->rx_hang_checking = 1;
		priv->pshare->selected_priv = priv;;
	}
}


static __inline__ void check_rx_hangup_record_rxpkts(struct rtl8192cd_priv *priv)
{
	priv->rx_packets_pre2 = priv->rx_packets_pre1;
	priv->rx_packets_pre1 = (unsigned long long)priv->net_stats.rx_packets;
}
#endif // CHECK_RX_HANGUP


#ifdef CONFIG_RTL_92D_DMDP
void reset_dmdp_peer(struct rtl8192cd_priv *from)
{
	extern struct rtl8192cd_priv *if_priv[];
	struct rtl8192cd_priv *priv;
#ifdef FAST_RECOVERY
	struct backup_info *info = NULL;
#ifdef UNIVERSAL_REPEATER
	struct backup_info *vxd_info = NULL;
#endif
#endif

#ifdef MBSSID
	int i;
	struct backup_info *vap_info[RTL8192CD_NUM_VWLAN];
	memset(vap_info, 0, sizeof(vap_info));
#endif

	if (from->pshare->wlandev_idx == 0)
		priv = if_priv[1];
	else
		priv = if_priv[0];

	if (priv == NULL)
		return;

	if (!netif_running(priv->dev))
		return;

	priv->reset_hangup = 1;
#ifdef UNIVERSAL_REPEATER
	if (IS_DRV_OPEN(GET_VXD_PRIV(priv)))
		GET_VXD_PRIV(priv)->reset_hangup = 1;
#endif
#ifdef MBSSID
	if (GET_ROOT(priv)->pmib->miscEntry.vap_enable) {
		for (i=0; i<RTL8192CD_NUM_VWLAN; i++) {
			if (IS_DRV_OPEN(priv->pvap_priv[i]))
				priv->pvap_priv[i]->reset_hangup = 1;
		}
	}
#endif

#ifdef WDS
	if (priv->pmib->dot11WdsInfo.wdsEnabled &&
		(priv->pmib->dot11WdsInfo.wdsPrivacy == _TKIP_PRIVACY_ ||
			priv->pmib->dot11WdsInfo.wdsPrivacy == _CCMP_PRIVACY_) ) {
			int i;
			for (i=0; i<priv->pmib->dot11WdsInfo.wdsNum; i++)
				if (netif_running(priv->wds_dev[i]))
	 				priv->pmib->dot11WdsInfo.wdsMappingKeyLen[i]|=0x80000000;
	}
#endif

#ifdef FAST_RECOVERY
	if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE) {
		info = backup_sta(priv);
		info->func_off = priv->pmib->miscEntry.func_off;
		priv->pmib->miscEntry.func_off = 1;
#ifdef MBSSID
		if (GET_ROOT(priv)->pmib->miscEntry.vap_enable) {
			for (i=0; i<RTL8192CD_NUM_VWLAN; i++) {
				if (IS_DRV_OPEN(priv->pvap_priv[i])) {
					vap_info[i] = backup_sta(priv->pvap_priv[i]);
					vap_info[i]->func_off = priv->pvap_priv[i]->pmib->miscEntry.func_off;
					priv->pvap_priv[i]->pmib->miscEntry.func_off = 1;
				} else {
					vap_info[i] = NULL;
				}
			}
		}
#endif
#ifdef UNIVERSAL_REPEATER
		if (IS_DRV_OPEN(GET_VXD_PRIV(priv))) {
			vxd_info = backup_sta(GET_VXD_PRIV(priv));
			vxd_info->func_off = GET_VXD_PRIV(priv)->pmib->miscEntry.func_off;
			GET_VXD_PRIV(priv)->pmib->miscEntry.func_off = 1;
		}
#endif
	}
#endif // FAST_RECOVERY

	priv->pmib->dot11OperationEntry.keep_rsnie = 1;
#ifdef MBSSID
	if (GET_ROOT(priv)->pmib->miscEntry.vap_enable) {
		for (i=0; i<RTL8192CD_NUM_VWLAN; i++) {
			if (IS_DRV_OPEN(priv->pvap_priv[i]))
				priv->pvap_priv[i]->pmib->dot11OperationEntry.keep_rsnie = 1;
		}
	}
#endif
#ifdef UNIVERSAL_REPEATER
	if (IS_DRV_OPEN(GET_VXD_PRIV(priv)))
		GET_VXD_PRIV(priv)->pmib->dot11OperationEntry.keep_rsnie = 1;
#endif

    P2P_DEBUG("==>rtl8192cd_close + open\n");

	rtl8192cd_close(priv->dev);
	rtl8192cd_open(priv->dev);

#ifdef FAST_RECOVERY
	if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE) {
		if (info) {
			restore_backup_sta(priv, info);
			priv->pmib->miscEntry.func_off = info->func_off;
		}

#ifdef MBSSID
		if (GET_ROOT(priv)->pmib->miscEntry.vap_enable) {
			for (i=0; i<RTL8192CD_NUM_VWLAN; i++) {
				if (IS_DRV_OPEN(priv->pvap_priv[i]) && vap_info[i]) {
					restore_backup_sta(priv->pvap_priv[i], vap_info[i]);
					priv->pvap_priv[i]->pmib->miscEntry.func_off = vap_info[i]->func_off;
				}
			}
		}
#endif
#ifdef UNIVERSAL_REPEATER
		if (IS_DRV_OPEN(GET_VXD_PRIV(priv)) && vxd_info) {
			restore_backup_sta(GET_VXD_PRIV(priv), vxd_info);
			GET_VXD_PRIV(priv)->pmib->miscEntry.func_off = vxd_info->func_off;
		}
#endif
	}
#endif // FAST_RECOVERY

#ifdef CHECK_AFTER_RESET
	priv->pshare->reset_monitor_cnt_down = 3;
	priv->pshare->reset_monitor_pending = 0;
	priv->pshare->reset_monitor_rx_pkt_cnt = (unsigned long long)priv->net_stats.rx_packets;
#endif
}
#endif


int check_hangup_pci(struct rtl8192cd_priv *priv)
{
#ifdef CHECK_TX_HANGUP
	int tail, q_num, is_empty, alive=0, max_q_num;
#endif
	int txhangup, tx_dma_hangup, rxhangup, beacon_hangup, reset_fail_hangup, fw_error, data_cpu_dead;
	int pcie_tx_stuck=0, pcie_rx_stuck=0;
#ifdef CONFIG_WLAN_HAL
    u4Byte hal_hang_state = 0;
#endif // CONFIG_WLAN_HAL

#ifdef MBSSID
	int i;
#endif
#ifdef CHECK_RX_HANGUP
	unsigned int rx_cntreg;
#endif

/*
#if defined(CHECK_BEACON_HANGUP)
	unsigned int BcnQ_Val = 0;
#endif
*/

// for debug
#if 0
	__DRAM_IN_865X static unsigned char temp_reg_C50, temp_reg_C58,
 		temp_reg_C60, temp_reg_C68, temp_reg_A0A;
  	temp_reg_C50 = 0; temp_reg_C58 = 0; temp_reg_C60 = 0;
	temp_reg_C68 = 0; temp_reg_A0A = 0;
#endif
//---------------------------------------------------------
//	margin = -1;

	txhangup = tx_dma_hangup = rxhangup = beacon_hangup = reset_fail_hangup = fw_error = data_cpu_dead = 0;

#if defined(CONFIG_WLAN_HAL) 
    if (IS_HAL_CHIP(priv)) {

#if defined(CHECK_LX_DMA_ERROR)
		if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE) {
			if(priv->pshare->rf_ft_var.check_hang &  CHECK_LX_DMA_ERROR) {
		        hal_hang_state = GET_HAL_INTERFACE(priv)->CheckHangHandler(priv);

		        switch (hal_hang_state) {
		        case HANG_VAR_TX_STUCK:
					DRV_RT_TRACE(priv, DRV_DBG_SYS_INFO, DRV_DBG_SERIOUS, "check tx stuck hangup\n");
		            txhangup = 1;
					pcie_tx_stuck = 1;
		            break;
		        case HANG_VAR_RX_STUCK:
					DRV_RT_TRACE(priv, DRV_DBG_SYS_INFO, DRV_DBG_SERIOUS, "check rx stuck hangup\n");
		            rxhangup = 1;
					pcie_rx_stuck = 1;
		            break;
		        default: // HANG_VAR_NORMAL
		            break;
		        }
			}
		}
#endif
#ifdef CHECK_FW_ERROR
	if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE) {
#ifdef CONFIG_WLAN_HAL_8192EE
		if (GET_CHIP_VER(priv) == VERSION_8192E)	
		if (priv->pshare->rf_ft_var.check_hang &  CHECK_FW_ERROR) {
			int hmeter, mcutst2;
			hmeter = RTL_R8(HMETFR);
			mcutst2 = RTL_R16(MCUTST_II); 
			if( (hmeter == 0xf) && (priv->pshare->mcu_tst2 == mcutst2)) {
				if (priv->pshare->mcu_pending_cnt < 15) { 
					priv->pshare->mcu_pending_cnt++;
				} else {
					fw_error =1;
				}
			} else {
				priv->pshare->mcu_pending_cnt =0;
			}
			priv->pshare->mcu_tst2 = mcutst2;
		}
#endif
#ifdef CONFIG_RTL_OFFLOAD_DRIVER
		if (OFFLOAD_ENABLE(priv)) {
			if (priv->pshare->rf_ft_var.check_hang & CHECK_FW_ERROR)
				fw_error = priv->pshare->fw_download_status;
		}
#endif
	}
#endif

#ifdef CHECK_TX_HANGUP
	if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE) {
		max_q_num = 12;
		if(priv->pshare->rf_ft_var.check_hang &  CHECK_TX_HANGUP) {
			if (check_adaptivity_test(priv)) {
				for(q_num = 0; q_num<=max_q_num; q_num++)
					if(	priv->pshare->Q_info[q_num].pending_tick){
						priv->pshare->Q_info[q_num].pending_tick++;
						//panic_printk("%d q_num = %d,pending_tick %d\n",__LINE__,q_num,priv->pshare->Q_info[q_num].pending_tick);
					}
			} else {
				for(q_num = 0; q_num<=max_q_num; q_num++) {
					PHCI_TX_DMA_MANAGER_88XX	ptx_dma = (PHCI_TX_DMA_MANAGER_88XX)(_GET_HAL_DATA(priv)->PTxDMA88XX);	
					PHCI_TX_DMA_QUEUE_STRUCT_88XX	tx_q   = &(ptx_dma->tx_queue[q_num]);

					tail = 	RTL_R32(tx_q->reg_rwptr_idx);
					if( (0xffff & ((tail>>16)^ tail))==0) {
						if(priv->pshare->Q_info[q_num].pending_tick)
							alive++;
						priv->pshare->Q_info[q_num].pending_tick = 0;
					} else {
						tail = (tail>>16) & 0xffff;
						if (priv->pshare->Q_info[q_num].pending_tick &&
							(tail == priv->pshare->Q_info[q_num].pending_tail) &&
							(UINT32_DIFF(priv->up_time, priv->pshare->Q_info[q_num].pending_tick) >= PENDING_PERIOD)) {
							txhangup++;
						}					
						
						if ((priv->pshare->Q_info[q_num].pending_tick == 0) ||
							(tail != priv->pshare->Q_info[q_num].pending_tail)) {
							if (tail != priv->pshare->Q_info[q_num].pending_tail)
								alive++;
							priv->pshare->Q_info[q_num].pending_tick = priv->up_time;
							priv->pshare->Q_info[q_num].pending_tail = tail;
						}
						
						priv->pshare->Q_info[q_num].idle_tick = 0;
					}			
				}

				if(alive) {
					txhangup = 0;
					for(q_num = 0; q_num<=max_q_num; q_num++) {
						priv->pshare->Q_info[q_num].pending_tick = 0;
					}
				} 			
			}
#if defined(CONFIG_WLAN_HAL_8814BE)
			if(GET_CHIP_VER(priv)==VERSION_8814B) {
				if (priv->pshare->tx_dma_err_cnt != priv->pshare->tx_dma_err) {
					if (priv->pshare->tx_dma_status_bak & 0x6000) {
						int reg_value = RTL_R16(TXDMA_OFFSET_CHK);
						RTL_W16(TXDMA_OFFSET_CHK, reg_value | BIT(9));
						RTL_W16(TXDMA_OFFSET_CHK, reg_value & ~BIT(9));
						panic_printk("recovery tx dma error : %d, 0x%x\n", priv->pshare->tx_dma_err, priv->pshare->tx_dma_status_bak);
					}
					priv->pshare->tx_dma_err_cnt = priv->pshare->tx_dma_err;
					priv->pshare->tx_dma_status_bak = 0;
				}
			}
#endif
			if(priv->pshare->tx_dma_status & (BIT_PAYLOAD_UDN | BIT_PAYLOAD_OVF)){		
				priv->pshare->tx_dma_status1 |= priv->pshare->tx_dma_status;
				priv->pshare->tx_dma_status &=  ~(BIT_PAYLOAD_UDN | BIT_PAYLOAD_OVF);					
		   		tx_dma_hangup++;
		   	}

#if defined(CONFIG_WLAN_HAL_8812FE)		
			if (GET_CHIP_VER(priv) == VERSION_8812F) {
				if(priv->pshare->tx_dma_status & BIT_TXPKTBUF_REQ_ERR){		
					priv->pshare->tx_dma_status1 |= priv->pshare->tx_dma_status;
					priv->pshare->tx_dma_status &=  ~BIT_TXPKTBUF_REQ_ERR;					

					// Check if TxDMA error is resulted from sounding
					u8 bkp_sys_status1;
					u32 u32reg;

					bkp_sys_status1 = RTL_R8(REG_SYS_STATUS1 + 2);
					RTL_W8(REG_SYS_STATUS1 + 2, 0x1);

					RTL_W8(0x3a, 0x90);
					RTL_W8(0x260, 0x70);
					u32reg = RTL_R32(REG_DBG_PORT_SEL);

					RTL_W8(REG_SYS_STATUS1 + 2, bkp_sys_status1);

					// DONOT reset interface if TxDMA error is resulted from sounding
					if (u32reg & 0xFFA00000) {
						tx_dma_hangup++;
					} else {
						//printk("TxDMA error = 0x40000 is resulted from sounding\n");
						priv->pshare->tx_dma_0x40000++;
					}
				}
			}
#endif
			if(priv->pshare->tx_dma_status &  BIT_PAGE_OVF) {
				priv->pshare->tx_dma_status1 |= priv->pshare->tx_dma_status;
				priv->pshare->tx_dma_status &= ~BIT_PAGE_OVF;
				tx_dma_hangup++;
			}
		}
	}
#endif

    } else if(CONFIG_WLAN_NOT_HAL_EXIST)	
#endif // CONFIG_WLAN_HAL
	{
#ifdef CHECK_TX_HANGUP	
		if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE) {
			max_q_num = 5; // we check Q5, Q0, Q4, Q3, Q2, Q1
			if(priv->pshare->rf_ft_var.check_hang &  CHECK_TX_HANGUP) {
				if(check_adaptivity_test(priv)) {
					for(q_num = 0; q_num<=max_q_num; q_num++){
						if(	priv->pshare->Q_info[q_num].pending_tick){
							priv->pshare->Q_info[q_num].pending_tick++;
							//panic_printk("%d q_num = %d,pending_tick %d\n",__LINE__,q_num,priv->pshare->Q_info[q_num].pending_tick);
						}
					}
				} else {
					for(q_num = 0; q_num<=max_q_num; q_num++) {

						if (check_tx_hangup(priv, q_num, &tail, &is_empty)) {
							if (priv->pshare->Q_info[q_num].pending_tick &&
								(tail == priv->pshare->Q_info[q_num].pending_tail) &&
								(UINT32_DIFF(priv->up_time, priv->pshare->Q_info[q_num].pending_tick) >= PENDING_PERIOD)) {
								// the stopping is over the period => hangup!
								txhangup++;
				//				break;
							}					

							if ((priv->pshare->Q_info[q_num].pending_tick == 0) ||
								(tail != priv->pshare->Q_info[q_num].pending_tail)) {
								if(tail != priv->pshare->Q_info[q_num].pending_tail)
									alive++;
								// the first time stopping or the tail moved
								priv->pshare->Q_info[q_num].pending_tick = priv->up_time;
								priv->pshare->Q_info[q_num].pending_tail = tail;
							}
							priv->pshare->Q_info[q_num].idle_tick = 0;
				//			break;
						}
						else {
							if(priv->pshare->Q_info[q_num].pending_tick)
								alive++;
							else if (tail != priv->pshare->Q_info[q_num].pending_tail)
								alive++;
							priv->pshare->Q_info[q_num].pending_tail = tail;
							// empty or own bit is cleared
							priv->pshare->Q_info[q_num].pending_tick = 0;
							if (!is_empty &&
								priv->pshare->Q_info[q_num].idle_tick &&
								(tail == priv->pshare->Q_info[q_num].pending_tail) &&
								(UINT32_DIFF(priv->up_time, priv->pshare->Q_info[q_num].idle_tick) >= PENDING_PERIOD)) {
								// own bit is cleared, but the tail didn't move and is idle over the period => call DSR
#ifdef SMP_SYNC
								if (rtk_tasklet_set_triggered(&(priv->pshare->tx_tasklet))) {
#ifdef __ECOS
									priv->pshare->call_dsr = 1;
#else
									tasklet_schedule(&(priv->pshare->tx_tasklet.tasklet));
#endif
								}
#else // !(SMP_SYNC)
#ifdef __ECOS
								rtk_tasklet_set_triggered(&(priv->pshare->tx_tasklet))
								priv->pshare->call_dsr = 1;
#else
								rtl8192cd_tx_dsr((unsigned long)priv);
#endif
#endif // SMP_SYNC
								priv->pshare->Q_info[q_num].idle_tick = 0;
				//				break;
							}
							else {
								if (is_empty)
									priv->pshare->Q_info[q_num].idle_tick = 0;
								else {
									if ((priv->pshare->Q_info[q_num].idle_tick == 0) ||
										(tail != priv->pshare->Q_info[q_num].pending_tail)) {
										// the first time idle, or the own bit is cleared and the tail moved
										priv->pshare->Q_info[q_num].idle_tick = priv->up_time;
										priv->pshare->Q_info[q_num].pending_tail = tail;
				//						break;
									}
								}
							}
						}

					}
					if(alive) {
						txhangup = 0;
						for(q_num = 0; q_num<=max_q_num; q_num++) {
							priv->pshare->Q_info[q_num].pending_tick = 0;
						}
					} 	
				}
			}
		}
#endif
	}

#ifdef CHECK_RX_HANGUP
	// check for rx stop
	if (txhangup == 0) {
		if ((priv->assoc_num > 0
#ifdef WDS
			|| priv->pmib->dot11WdsInfo.wdsEnabled
#endif
			) && !priv->pshare->rx_hang_checking)
			check_rx_hangup(priv);

#ifdef UNIVERSAL_REPEATER
		if (IS_DRV_OPEN(GET_VXD_PRIV(priv)) &&
			GET_VXD_PRIV(priv)->assoc_num > 0 &&
			!priv->pshare->rx_hang_checking)
			check_rx_hangup(GET_VXD_PRIV(priv));
#endif
#ifdef MBSSID
		if (GET_ROOT(priv)->pmib->miscEntry.vap_enable) {
			for (i=0; i<RTL8192CD_NUM_VWLAN; i++) {
				if (IS_DRV_OPEN(priv->pvap_priv[i]) &&
					priv->pvap_priv[i]->assoc_num > 0 &&
					!priv->pshare->rx_hang_checking)
					check_rx_hangup(priv->pvap_priv[i]);
			}
		}
#endif

		if (priv->pshare->rx_hang_checking)
		{
			if (priv->pshare->rx_cntreg_log == 0)
				priv->pshare->rx_cntreg_log = RTL_R32(_RXPKTNUM_);
			else {
				rx_cntreg = RTL_R32(_RXPKTNUM_);
				if (priv->pshare->rx_cntreg_log == rx_cntreg) {
					if (priv->pshare->rx_stop_pending_tick) {
						if (UINT32_DIFF(priv->pshare->selected_priv->up_time, priv->pshare->rx_stop_pending_tick) >= (PENDING_PERIOD-1)) {
							rxhangup++;
							//printk("\n\n%s %d rxhangup++ rx_packets_pre1=%lu; rx_packets_pre2=%lu; net_stats.rx_packets=%lu\n",
									//__FUNCTION__, __LINE__,
									//priv->pshare->selected_priv->rx_packets_pre1, priv->pshare->selected_priv->rx_packets_pre2,
									//priv->pshare->selected_priv->net_stats.rx_packets);
						}
					}
					else {
						priv->pshare->rx_stop_pending_tick = priv->pshare->selected_priv->up_time;
						RTL_W32(_RCR_, RTL_R32(_RCR_) | _ACF_);
						check_rx_hangup_send_pkt(priv->pshare->selected_priv);
						//printk("\n\ncheck_rx_hangup_send_pkt!\n");
						//printk("%s %d rx_packets_pre1=%lu; rx_packets_pre2=%lu; net_stats.rx_packets=%lu\n",
								//__FUNCTION__, __LINE__,
								//priv->pshare->selected_priv->rx_packets_pre1, priv->pshare->selected_priv->rx_packets_pre2,
								//priv->pshare->selected_priv->net_stats.rx_packets);
					}
				}
				else {
					//printk("\n\n%s %d Recovered!\n" ,__FUNCTION__, __LINE__);
					priv->pshare->rx_hang_checking = 0;
					priv->pshare->rx_cntreg_log = 0;
					priv->pshare->selected_priv = NULL;
					priv->rx_start_monitor_running = 0;
#ifdef UNIVERSAL_REPEATER
					if (IS_DRV_OPEN(GET_VXD_PRIV(priv)))
						GET_VXD_PRIV(priv)->rx_start_monitor_running = 0;
#endif
#ifdef MBSSID
					if (GET_ROOT(priv)->pmib->miscEntry.vap_enable) {
						for (i=0; i<RTL8192CD_NUM_VWLAN; i++) {
							if (IS_DRV_OPEN(priv->pvap_priv[i]))
								priv->pvap_priv[i]->rx_start_monitor_running = 0;
						}
					}
#endif

					if (priv->pshare->rx_stop_pending_tick) {
						priv->pshare->rx_stop_pending_tick = 0;
						RTL_W32(_RCR_, RTL_R32(_RCR_) & (~_ACF_));
					}
				}
			}
		}

		if (rxhangup == 0) {
			if (priv->assoc_num > 0)
				check_rx_hangup_record_rxpkts(priv);
			else if (priv->rx_start_monitor_running) {
				priv->rx_start_monitor_running = 0;
				//printk("stop monitoring = %d\n", priv->rx_start_monitor_running);
			}
#ifdef UNIVERSAL_REPEATER
			if (IS_DRV_OPEN(GET_VXD_PRIV(priv))) {
				if (GET_VXD_PRIV(priv)->assoc_num > 0)
					check_rx_hangup_record_rxpkts(GET_VXD_PRIV(priv));
				else if (GET_VXD_PRIV(priv)->rx_start_monitor_running) {
					GET_VXD_PRIV(priv)->rx_start_monitor_running = 0;
					//printk("stop monitoring = %d\n", GET_VXD_PRIV(priv)->rx_start_monitor_running);
				}
			}
#endif
#ifdef MBSSID
			if (GET_ROOT(priv)->pmib->miscEntry.vap_enable) {
				for (i=0; i<RTL8192CD_NUM_VWLAN; i++) {
					if (IS_DRV_OPEN(priv->pvap_priv[i])) {
						if (priv->pvap_priv[i]->assoc_num > 0)
							check_rx_hangup_record_rxpkts(priv->pvap_priv[i]);
						else if (priv->pvap_priv[i]->rx_start_monitor_running) {
							priv->pvap_priv[i]->rx_start_monitor_running = 0;
							//printk("stop monitoring = %d\n", priv->pvap_priv[i]->rx_start_monitor_running);
						}
					}
				}
			}
#endif
		}
	}
#endif // CHECK_RX_HANGUP

#ifdef CHECK_RX_DMA_ERROR
	if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE) {
		if(priv->pshare->rf_ft_var.check_hang &  CHECK_RX_DMA_ERROR)
		if((GET_CHIP_VER(priv)==VERSION_8192C) || (GET_CHIP_VER(priv)==VERSION_8188C) 
			|| (GET_CHIP_VER(priv)==VERSION_8192D)|| (GET_CHIP_VER(priv) == VERSION_8188E) || (GET_CHIP_VER(priv) == VERSION_8192E)) 
		{
			int rxffptr, rxffpkt;

			rxffptr = RTL_R16(RXFF_PTR+2);
			rxffpkt = RTL_R8(RXPKT_NUM+3); 

			if((rxffptr%0x80) && rxffpkt && (RTL_R8(RXPKT_NUM+2)^2)){
				if( (priv->pshare->rx_byte_cnt == priv->net_stats.rx_bytes) &&
					!((rxffptr ^ priv->pshare->rxff_rdptr)|(rxffpkt ^ priv->pshare->rxff_pkt))) {
					if (priv->pshare->rx_dma_err_cnt < 15) { // continue for 15 seconds
						priv->pshare->rx_dma_err_cnt++;
					} else {
						unsigned char tmp;
						tmp = RTL_R8(0x1c);

						// Turn OFF BIT_WLOCK_ALL
						RTL_W8(0x1c, tmp & (~(BIT(0) | BIT(1))));
						// Turn ON BIT_SYSON_DIS_PMCREG_WRMSK
						RTL_W8(0xcc, RTL_R8(0xcc) | BIT(2));
						// Turn ON BIT_STOP_RXQ
						RTL_W8(0x301, RTL_R8(0x301) | BIT(0));
						// Reset flow
						RTL_W8(CR, 0);
						RTL_W8(SYS_FUNC_EN+1, RTL_R8(SYS_FUNC_EN+1) & (~BIT(0)));
						RTL_W8(SYS_FUNC_EN+1, RTL_R8(SYS_FUNC_EN+1) | BIT(0));
						// Turn OFF BIT_STOP_RXQ
						RTL_W8(0x301, RTL_R8(0x301) & (~BIT(0)));
						// Turn OFF BIT_SYSON_DIS_PMCREG_WRMSK
						RTL_W8(0xcc, RTL_R8(0xcc) & (~BIT(2)));
						// Restore BIT_WLOCK_ALL
						RTL_W8(0x1c, tmp);

						rxhangup++;
					}
				} else {
					priv->pshare->rx_dma_err_cnt = 0;
					priv->pshare->rxff_rdptr = rxffptr;
					priv->pshare->rxff_pkt = rxffpkt;
					priv->pshare->rx_byte_cnt = (unsigned long long)priv->net_stats.rx_bytes;
				}
			}
		}
	}
#endif

#ifdef CHECK_RX_TAG_ERROR
	if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE) {
#ifdef CONFIG_WLAN_HAL_8192EE
		if(priv->pshare->rf_ft_var.check_hang &  CHECK_RX_TAG_ERROR)
		if (GET_CHIP_VER(priv) == VERSION_8192E) 	{
			if(((priv->pshare->RxTagPollingCount >20)) && (RTL_R32(0)!=0xffffffff) ) {
				rxhangup++;
	//			panic_printk("%s, %d, Rx recover!!", __FUNCTION__, __LINE__);
			}
		}
#endif
	}
#endif

#ifdef CHECK_BEACON_HANGUP
	if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE) {
		if ((priv->pshare->rf_ft_var.check_hang &  CHECK_BEACON_HANGUP)
				&& ((OPMODE & WIFI_AP_STATE)
				&& !(OPMODE &WIFI_SITE_MONITOR)
				&& priv->pBeaconCapability	// beacon has init
#ifdef WDS
				&& !priv->pmib->dot11WdsInfo.wdsPure
#endif
#if defined(CONFIG_RTK_MESH)
				&& !priv->pmib->dot1180211sInfo.meshSilence
#endif
				//&& !priv->pmib->miscEntry.func_off
			   )
#if 0//def UNIVERSAL_REPEATER
				|| ((OPMODE & WIFI_STATION_STATE) && GET_VXD_PRIV(priv) &&
							(GET_VXD_PRIV(priv)->drv_state & DRV_STATE_VXD_AP_STARTED))
#endif
			) {
			unsigned long beacon_ok;

#if 0//def UNIVERSAL_REPEATER
			if (OPMODE & WIFI_STATION_STATE){
				beacon_ok = GET_VXD_PRIV(priv)->ext_stats.beacon_ok;
	/*
				BcnQ_Val = GET_VXD_PRIV(priv)->ext_stats.beaconQ_sts;
				GET_VXD_PRIV(priv)->ext_stats.beaconQ_sts = RTL_R32(0x120);
				if(BcnQ_Val == GET_VXD_PRIV(priv)->ext_stats.beaconQ_sts)
					beacon_hangup = 1;
	*/
			}
			else
#endif
			if(!priv->pmib->miscEntry.func_off)
			{
				beacon_ok = priv->ext_stats.beacon_ok + priv->ext_stats.beacon_er;
	/*
				BcnQ_Val = priv->ext_stats.beaconQ_sts;
				priv->ext_stats.beaconQ_sts = RTL_R32(0x120);// firmware beacon Q stats
				if(BcnQ_Val == priv->ext_stats.beaconQ_sts)
					beacon_hangup = 1;
	*/
			}
#ifdef MBSSID
			else if (priv->pmib->miscEntry.vap_enable) {
				for (i=0; i<RTL8192CD_NUM_VWLAN; i++) {
					if (IS_DRV_OPEN(priv->pvap_priv[i])) {
						if ((priv->pvap_priv[i])->pmib->miscEntry.func_off == 0) {
							beacon_ok = (priv->pvap_priv[i])->ext_stats.beacon_ok + (priv->pvap_priv[i])->ext_stats.beacon_er;
							break;
						}
					}
				}		
			}
#endif
			if((!priv->pmib->miscEntry.func_off) 
			#ifdef MBSSID	
				|| ((i!=RTL8192CD_NUM_VWLAN) && priv->pmib->miscEntry.vap_enable)
			#endif	
			)
			{
				if (priv->pshare->beacon_wait_cnt == 0) {
					if (priv->pshare->beacon_ok_cnt == beacon_ok) {
						int threshold=5;

						#ifdef CONFIG_RTK_WPS_MESH
						if(GET_MIB(priv)->wscEntry.wsc_meshmode > 0)
						{
							threshold = 100; 
						}
						#endif

						#if 0
						#ifdef MBSSID
						if (priv->pmib->miscEntry.vap_enable)
							threshold=3;
						#endif
						if (priv->pmib->dot11StationConfigEntry.dot11BeaconPeriod < 650)
							threshold = 0;
						#endif
						if (priv->pshare->beacon_pending_cnt++ >= threshold)
							beacon_hangup = 1;
					}
					else {
						priv->pshare->beacon_ok_cnt =beacon_ok;
						if (priv->pshare->beacon_pending_cnt > 0)
							priv->pshare->beacon_pending_cnt = 0;
					}
				}
				else
					priv->pshare->beacon_wait_cnt--;
			}
		}
	}
#endif

#ifdef CHECK_AFTER_RESET
	if (priv->pshare->reset_monitor_cnt_down > 0) {
		priv->pshare->reset_monitor_cnt_down--;
		if (priv->pshare->reset_monitor_rx_pkt_cnt == priv->net_stats.rx_packets)	{
//			if (priv->pshare->reset_monitor_pending++ > 1)
				reset_fail_hangup = 1;
		}
		else {
			priv->pshare->reset_monitor_rx_pkt_cnt = (unsigned long long)priv->net_stats.rx_packets;
			if (priv->pshare->reset_monitor_pending > 0)
				priv->pshare->reset_monitor_pending = 0;
		}
	}
#endif

#ifdef CHECK_DATACPU_HANGUP
#if defined(CONFIG_WLAN_HAL_8814BE)
	if(GET_CHIP_VER(priv) == VERSION_8814B){
		unsigned int value, flags;
		
		INDIRECT_READ(DC_SRAM_START, value);
		priv->pshare->datacpu_timer_cnt++;
		if(priv->pshare->datacpu_keep_alive_cnt == value) {
			if (priv->pshare->datacpu_timer_cnt >= DATACPU_KEEP_ALIVE_CHECK_TIME)
				data_cpu_dead = 1;
		} else {
			priv->pshare->datacpu_keep_alive_cnt = value;
			priv->pshare->datacpu_timer_cnt = 0;
		}
	}
#endif
#endif

	if (txhangup || tx_dma_hangup|| rxhangup || beacon_hangup || reset_fail_hangup || fw_error || data_cpu_dead) { // hangup happen

		if (txhangup) {
			DRV_RT_TRACE(priv, DRV_DBG_SYS_INFO, DRV_DBG_SERIOUS, "check tx hangup\n");
			priv->check_cnt_tx++;
		}else if (tx_dma_hangup) {
			DRV_RT_TRACE(priv, DRV_DBG_SYS_INFO, DRV_DBG_SERIOUS, "check tx dma hangup\n");
			priv->check_cnt_tx_dma++;
		}else if (rxhangup) {
			DRV_RT_TRACE(priv, DRV_DBG_SYS_INFO, DRV_DBG_SERIOUS, "check rx hangup\n");
			priv->check_cnt_rx++;
		} else if (beacon_hangup) {
			DRV_RT_TRACE(priv, DRV_DBG_SYS_INFO, DRV_DBG_SERIOUS, "check bcn hangup\n");
			priv->check_cnt_bcn++;
		} else if (reset_fail_hangup) {
			DRV_RT_TRACE(priv, DRV_DBG_SYS_INFO, DRV_DBG_SERIOUS, "check reset fail hangup\n");
			priv->check_cnt_rst++;
		} else if (fw_error) {
			DRV_RT_TRACE(priv, DRV_DBG_SYS_INFO, DRV_DBG_SERIOUS, "check fw hangup\n");
			priv->check_cnt_fw++;		
		} else if (data_cpu_dead) {
			DRV_RT_TRACE(priv, DRV_DBG_SYS_INFO, DRV_DBG_SERIOUS, "check data cpu hangup\n");
			priv->check_cnt_datacpu++;		
		}
#ifdef CHECK_HANG_DEBUG
#ifdef SW_TX_QUEUE
	if(priv->pshare->rf_ft_var.swq_dbg==0)
		GDEBUG("uptime=%ld,%s\n", priv->up_time, 
		    (txhangup) ? "txhangup" : 
		    (rxhangup) ? "rxhangup" : 
            (beacon_hangup) ? "beacon_hangup" : 
            (reset_fail_hangup) ? "reset_fail_hangup" : 
            (fw_error) ? "fw_error" : "");
#endif
	return 0;
#else
	if(priv->pmib->miscEntry.check_hang_hold)
		return 0;
#endif

		if (GET_ROOT(priv)->pmib->miscEntry.reset_hangup_dbg) {
// for debug
			if (txhangup)
				printk("WA: Tx reset, up-time=%lu sec\n", priv->up_time);
			else if (rxhangup)
				printk("WA: Rx reset, up-time=%lu sec\n", priv->up_time);
			else if (beacon_hangup)
				printk("WA: Beacon reset, up-time=%lu sec\n", priv->up_time);
			else if (reset_fail_hangup)
				printk("WA: Reset-fail reset, up-time=%lu sec\n", priv->up_time);
			else if (fw_error)
				printk("WA: FW reset, up-time=%lu sec\n", priv->up_time);
			else if (data_cpu_dead)
				printk("WA: Data CPU reset, up-time=%lu sec\n", priv->up_time);

			return 0;
		}

		PRINT_INFO("Status check! Tx[%d] Rx[%d] Bcnt[%d] Rst[%d] ...\n",
			priv->check_cnt_tx, priv->check_cnt_rx, priv->check_cnt_bcn, priv->check_cnt_rst);

#if defined(CONFIG_WLAN_HAL)
		if (IS_HAL_CHIP(priv)) {
			if (pcie_tx_stuck)
				priv->pcie_stuck |= BIT0;
			if (pcie_rx_stuck)
				priv->pcie_stuck |= BIT1;
		}
#endif

		if (!work_pending(&priv->reset_hangup_work))
			schedule_work(&priv->reset_hangup_work);

		return 1;
	}
	else
		return 0;
}

void reset_hangup_work(struct work_struct *work)
{
	struct rtl8192cd_priv *priv = container_of(work, struct rtl8192cd_priv, reset_hangup_work);
#ifdef FAST_RECOVERY
	struct backup_info *info = NULL;
#ifdef MBSSID
	struct backup_info *vap_info[RTL8192CD_NUM_VWLAN];
#endif
#ifdef UNIVERSAL_REPEATER
	struct backup_info *vxd_info = NULL;
#endif
#endif // FAST_RECOVERY

#ifndef SMP_SYNC
	unsigned long flags = 0;
#endif
	int i;

	rtnl_lock();

	if (!(priv->drv_state & DRV_STATE_OPEN))
		goto done;

	priv->reset_hangup = 1;
#ifdef MBSSID
	if (priv->pmib->miscEntry.vap_enable) {
		for (i = 0; i < RTL8192CD_NUM_VWLAN; i++) {
			if (IS_DRV_OPEN(priv->pvap_priv[i]))
				priv->pvap_priv[i]->reset_hangup = 1;
		}
	}
#endif
#ifdef UNIVERSAL_REPEATER
	if (IS_DRV_OPEN(GET_VXD_PRIV(priv)))
		GET_VXD_PRIV(priv)->reset_hangup = 1;
#endif

	// Set flag to re-init WDS key in rtl8192cd_open()
#ifdef WDS
	if (priv->pmib->dot11WdsInfo.wdsEnabled &&
		(priv->pmib->dot11WdsInfo.wdsPrivacy == _TKIP_PRIVACY_
		|| priv->pmib->dot11WdsInfo.wdsPrivacy == _CCMP_PRIVACY_)) {
		for (i = 0; i  < priv->pmib->dot11WdsInfo.wdsNum; i++)
			if (netif_running(priv->wds_dev[i]))
				priv->pmib->dot11WdsInfo.wdsMappingKeyLen[i]|=0x80000000;
	}
#endif
	//----------------------------- david+2006-06-30

#if defined(CONFIG_RTL_8197F) /*eric-dog */
	watchdog_kick();
#else
	watchdog_stop(priv);
#endif

	SAVE_INT_AND_CLI(flags);
	SMP_LOCK(flags);

#ifdef FAST_RECOVERY
	info = backup_sta(priv);
	info->func_off = priv->pmib->miscEntry.func_off;
	priv->pmib->miscEntry.func_off = 1;
#ifdef MBSSID
	if (priv->pmib->miscEntry.vap_enable) {
		for (i = 0; i < RTL8192CD_NUM_VWLAN; i++) {
			if (IS_DRV_OPEN(priv->pvap_priv[i])) {
				vap_info[i] = backup_sta(priv->pvap_priv[i]);
				vap_info[i]->func_off = priv->pvap_priv[i]->pmib->miscEntry.func_off;
				priv->pvap_priv[i]->pmib->miscEntry.func_off = 1;
			} else {
				vap_info[i] = NULL;
			}
		}
	}
#endif
#ifdef UNIVERSAL_REPEATER
	if (IS_DRV_OPEN(GET_VXD_PRIV(priv))) {
		vxd_info = backup_sta(GET_VXD_PRIV(priv));
		vxd_info->func_off = GET_VXD_PRIV(priv)->pmib->miscEntry.func_off;
		GET_VXD_PRIV(priv)->pmib->miscEntry.func_off = 1;
	}
#endif
#endif // FAST_RECOVERY

	priv->pmib->dot11OperationEntry.keep_rsnie = 1;
#ifdef MBSSID
	if (priv->pmib->miscEntry.vap_enable) {
		for (i = 0; i < RTL8192CD_NUM_VWLAN; i++) {
			if (IS_DRV_OPEN(priv->pvap_priv[i]))
				priv->pvap_priv[i]->pmib->dot11OperationEntry.keep_rsnie = 1;
		}
	}
#endif
#ifdef UNIVERSAL_REPEATER
	if (IS_DRV_OPEN(GET_VXD_PRIV(priv)))
		GET_VXD_PRIV(priv)->pmib->dot11OperationEntry.keep_rsnie = 1;
#endif

	SMP_UNLOCK(flags);

	rtl8192cd_close(priv->dev);

#if defined(CONFIG_RTL_8812_SUPPORT) || defined(CONFIG_RTL_8723B_SUPPORT)
	if (GET_CHIP_VER(priv) == VERSION_8812E || GET_CHIP_VER(priv) == VERSION_8723B) {
		RTL_W8(0x1c, RTL_R8(0x1c) & (~(BIT(0) | BIT(1))));
		RTL_W8(SYS_FUNC_EN+1, RTL_R8(SYS_FUNC_EN+1) & (~ BIT(0)));
		RTL_W8(SYS_FUNC_EN+1, RTL_R8(SYS_FUNC_EN+1) | BIT(0));
		RTL_W8(0x1c, RTL_R8(0x1c) | BIT(0) | BIT(1));
	}
#endif
#ifdef CONFIG_RTL_92D_DMDP
	if (priv->pmib->dot11RFEntry.macPhyMode == DUALMAC_DUALPHY)
		reset_dmdp_peer(priv);
#endif
#if defined(CONFIG_WLAN_HAL)
	if (IS_HAL_CHIP(priv) && priv->pcie_stuck) {
		int pcie_tx_stuck = (priv->pcie_stuck & BIT0) ? 1 : 0;
		int pcie_rx_stuck = (priv->pcie_stuck & BIT1) ? 1 : 0;
		panic_printk("PCIe eMAC tx stuck:%d, rx stuck:%d\n", pcie_tx_stuck, pcie_rx_stuck);
		GET_HAL_INTERFACE(priv)->ResetHWForSurpriseHandler(priv);
		priv->pcie_stuck = 0;
	}
#endif

	rtl8192cd_open(priv->dev);

	SMP_LOCK(flags);

#ifdef FAST_RECOVERY
#if defined(SMP_LOAD_BALANCE_SUPPORT) && defined(SW_TX_QUEUE)
	RTL_W32(TC4_CTRL, 0);
#endif
	if (info) {
		restore_backup_sta(priv, info);
		priv->pmib->miscEntry.func_off = info->func_off;
	}
#ifdef MBSSID
	if (priv->pmib->miscEntry.vap_enable) {
		for (i = 0; i < RTL8192CD_NUM_VWLAN; i++) {
			if (IS_DRV_OPEN(priv->pvap_priv[i]) && vap_info[i]) {
				restore_backup_sta(priv->pvap_priv[i], vap_info[i]);
				priv->pvap_priv[i]->pmib->miscEntry.func_off = vap_info[i]->func_off;
			}
		}
	}
#endif
#ifdef UNIVERSAL_REPEATER
	if (IS_DRV_OPEN(GET_VXD_PRIV(priv)) && vxd_info) {
		restore_backup_sta(GET_VXD_PRIV(priv), vxd_info);
		GET_VXD_PRIV(priv)->pmib->miscEntry.func_off = vxd_info->func_off;
	}
#endif
#if  defined(CONFIG_WLAN_HAL)
	if (IS_HAL_CHIP(priv)) {
		GET_HAL_INTERFACE(priv)->EnableIMRHandler(priv);
	}
#endif
#if defined(SMP_LOAD_BALANCE_SUPPORT) && defined(SW_TX_QUEUE)
	// shorten SWQ timeout set in open stage
	RTL_W32(TC4_CTRL, BIT26 | BIT25 | BIT24 | (RTL_MICROSECONDS_TO_GTIMERCOUNTER(1000) & 0x00FFFFFF));
#endif
#endif // FAST_RECOVERY

#ifdef CHECK_AFTER_RESET
	priv->pshare->reset_monitor_cnt_down = 3;
	priv->pshare->reset_monitor_pending = 0;
	priv->pshare->reset_monitor_rx_pkt_cnt = (unsigned long long)priv->net_stats.rx_packets;
#endif

	RESTORE_INT(flags);
	SMP_UNLOCK(flags);

#if defined(CONFIG_RTL_8197F) /*eric-dog */
	watchdog_kick();
#else
	watchdog_resume(priv);
#endif

done:
	rtnl_unlock();
}
#endif

#if defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI)
int check_hangup_usb(struct rtl8192cd_priv *priv)
{
	unsigned long	flags = 0;
	int txhangup, rxhangup, fw_error;
#ifdef MBSSID
	int i;
#endif
#ifdef FAST_RECOVERY
	struct backup_info *info = NULL;
#ifdef UNIVERSAL_REPEATER
	struct backup_info *vxd_info = NULL;
#endif
#endif // FAST_RECOVERY
#ifdef MBSSID
	struct backup_info *vap_info[RTL8192CD_NUM_VWLAN];
	memset(vap_info, 0, sizeof(vap_info));
#endif

	txhangup = rxhangup = fw_error = 0;
#ifdef CHECK_FW_ERROR
	if (priv->pshare->rf_ft_var.check_hang & CHECK_FW_ERROR) {
		int mcutst, mcutst2;
		mcutst = RTL_R8(MCUTST_I);
		mcutst2 = RTL_R16(MCUTST_II); 
		if ((mcutst&BIT1) || (priv->pshare->mcu_tst2 == mcutst2)) {
			if ((mcutst&BIT1) == 0 && 
#ifdef SDIO_AP_OFFLOAD
				priv->pshare->mcu_pending_cnt < 30
#else
				priv->pshare->mcu_pending_cnt < 15
#endif
			) { // continue for 15 seconds
				priv->pshare->mcu_pending_cnt++;
			} else {
				fw_error = 1;
			}
		} else {
			priv->pshare->mcu_pending_cnt = 0;
		}
		priv->pshare->mcu_tst2 = mcutst2;
	}
#endif

#ifdef CHECK_TX_HANGUP
	if (priv->pshare->rf_ft_var.check_hang & CHECK_TX_HANGUP) {
		if (RTL_R32(TXDMA_STATUS)) {
			txhangup++;
		}
	}
#endif

#ifdef CHECK_RX_DMA_ERROR
	if (priv->pshare->rf_ft_var.check_hang & CHECK_RX_DMA_ERROR) {
		if (RTL_R32(RXDMA_STATUS) & (~BIT5)) {
			rxhangup++;
		}
	}
#endif

	if (txhangup || rxhangup || fw_error) { // hangup happen
#ifdef SDIO_AP_OFFLOAD
		ap_offload_deactivate(priv, OFFLOAD_PROHIBIT_HANGUP);
#endif
		priv->reset_hangup = 1;
		printk("[%s] reset_hangup = %d\n", __FUNCTION__, priv->reset_hangup);

#ifdef UNIVERSAL_REPEATER
		if (IS_DRV_OPEN(GET_VXD_PRIV(priv)))
			GET_VXD_PRIV(priv)->reset_hangup = 1;
#endif
#ifdef MBSSID
		if (GET_ROOT(priv)->pmib->miscEntry.vap_enable) {
			for (i=0; i<RTL8192CD_NUM_VWLAN; i++) {
				if (IS_DRV_OPEN(priv->pvap_priv[i]))
					priv->pvap_priv[i]->reset_hangup = 1;
			}
		}
#endif

		if (txhangup)
			priv->check_cnt_tx++;
		else if (rxhangup)
			priv->check_cnt_rx++;
		else if (fw_error)
			priv->check_cnt_fw++;			

//--------------------------------------- for debug ---------------------------------------
#if 1
		if (txhangup)
			printk("WA: Tx reset, up-time=%lu sec\n", priv->up_time);
		else if (rxhangup)
			printk("WA: Rx reset, up-time=%lu sec\n", priv->up_time);
		else if (fw_error)
			printk("WA: FW reset, up-time=%lu sec\n", priv->up_time);			
#endif
//-----------------------------------------------------------------------------------------

// Set flag to re-init WDS key in rtl8192cd_open()
#ifdef WDS
	if (priv->pmib->dot11WdsInfo.wdsEnabled &&
		(priv->pmib->dot11WdsInfo.wdsPrivacy == _TKIP_PRIVACY_ ||
			priv->pmib->dot11WdsInfo.wdsPrivacy == _CCMP_PRIVACY_) ) {
			int i;
			for (i=0; i<priv->pmib->dot11WdsInfo.wdsNum; i++)
				if (netif_running(priv->wds_dev[i]))
	 				priv->pmib->dot11WdsInfo.wdsMappingKeyLen[i]|=0x80000000;
	}
#endif

		printk("Status check! Tx[%d] Rx[%d] FW[%d] ...\n", priv->check_cnt_tx, priv->check_cnt_rx, priv->check_cnt_fw);

		SMP_LOCK(flags);

#ifdef FAST_RECOVERY
		info = backup_sta(priv);
		info->func_off = priv->pmib->miscEntry.func_off;
		priv->pmib->miscEntry.func_off = 1;
#ifdef MBSSID
		if (GET_ROOT(priv)->pmib->miscEntry.vap_enable) {
			for (i=0; i<RTL8192CD_NUM_VWLAN; i++) {
				if (IS_DRV_OPEN(priv->pvap_priv[i])) {
					vap_info[i] = backup_sta(priv->pvap_priv[i]);
					vap_info[i]->func_off = priv->pvap_priv[i]->pmib->miscEntry.func_off;
					priv->pvap_priv[i]->pmib->miscEntry.func_off = 1;
				} else {
					vap_info[i] = NULL;
				}
			}
		}
#endif
#ifdef UNIVERSAL_REPEATER
		if (IS_DRV_OPEN(GET_VXD_PRIV(priv))) {
			vxd_info = backup_sta(GET_VXD_PRIV(priv));
			vxd_info->func_off = GET_VXD_PRIV(priv)->pmib->miscEntry.func_off;
			GET_VXD_PRIV(priv)->pmib->miscEntry.func_off = 1;
		}
#endif
#endif // FAST_RECOVERY

		priv->pmib->dot11OperationEntry.keep_rsnie = 1;
#ifdef MBSSID
		if (GET_ROOT(priv)->pmib->miscEntry.vap_enable) {
			for (i=0; i<RTL8192CD_NUM_VWLAN; i++) {
				if (IS_DRV_OPEN(priv->pvap_priv[i]))
					priv->pvap_priv[i]->pmib->dot11OperationEntry.keep_rsnie = 1;
			}
		}
#endif
#ifdef UNIVERSAL_REPEATER
		if (IS_DRV_OPEN(GET_VXD_PRIV(priv)))
			GET_VXD_PRIV(priv)->pmib->dot11OperationEntry.keep_rsnie = 1;
#endif

		SMP_UNLOCK(flags);
		rtl8192cd_close(priv->dev);
		rtl8192cd_open(priv->dev);
		SMP_LOCK(flags);

#ifdef FAST_RECOVERY
		if (info) {
			restore_backup_sta(priv, info);
			priv->pmib->miscEntry.func_off = info->func_off;
		}

#ifdef MBSSID
		if (GET_ROOT(priv)->pmib->miscEntry.vap_enable) {
			for (i=0; i<RTL8192CD_NUM_VWLAN; i++) {
				if (IS_DRV_OPEN(priv->pvap_priv[i]) && vap_info[i]) {
					restore_backup_sta(priv->pvap_priv[i], vap_info[i]);
					priv->pvap_priv[i]->pmib->miscEntry.func_off = vap_info[i]->func_off;
				}
			}
		}
#endif
#ifdef UNIVERSAL_REPEATER
		if (IS_DRV_OPEN(GET_VXD_PRIV(priv)) && vxd_info) {
			restore_backup_sta(GET_VXD_PRIV(priv), vxd_info);
			GET_VXD_PRIV(priv)->pmib->miscEntry.func_off = vxd_info->func_off;
		}
#endif
#endif // FAST_RECOVERY

		SMP_UNLOCK(flags);
#ifdef SDIO_AP_OFFLOAD
		ap_offload_activate(priv, OFFLOAD_PROHIBIT_HANGUP);
#endif
		return 1;
	}
	else
		return 0;
}
#endif
#endif // CHECK_HANGUP

#if defined(CONFIG_VERIWAVE_CHECK)
void rtl8192cd_check_veriwave_timer(unsigned long task_priv)// for veriwave test
{
	struct rtl8192cd_priv *priv = (struct rtl8192cd_priv *)task_priv;
	if(!IS_DRV_OPEN(priv))
		return;

	//update traffic information
	update_wifi_allitf_txrx_stats(priv);
	if ((UINT64_DIFF(priv->pshare->wifi_rx_pkts[2], priv->pshare->wifi_rx_pkts[1]) < 2)
		&& (UINT64_DIFF(priv->pshare->wifi_rx_pkts[1], priv->pshare->wifi_rx_pkts[0]) < 2))
	{
		unsigned char val = (RTL_R8(0x6b4) & 0x0f);
		unsigned int val2 = RTL_R16(0x664);
			
		if ((val) && (val == priv->pshare->Reg6B4_pre) && (val2) && (val2 == priv->pshare->Reg664_pre)) {
			DEBUG_WARN("0x6b4 = (0x%02x, 0x%02x), 0x664 = (0x%04x, 0x%04x)\n", val, priv->pshare->Reg6B4_pre, val2, priv->pshare->Reg664_pre);
			DEBUG_WARN("wifi_rx_pkts = (%llu, %llu)\n", priv->pshare->wifi_rx_pkts[2], priv->pshare->wifi_rx_pkts[1]);
			priv->pshare->vw_dig_cnt = 3;
			RTL_W8(0x6b4,0x80);// reset
			priv->pshare->check_MACBBTX_counter++;
		}
		priv->pshare->Reg6B4_pre = val;
		priv->pshare->Reg664_pre = val2;
	} else {
		priv->pshare->Reg6B4_pre = 0;
		priv->pshare->Reg664_pre = 0;
	}
}
#endif

#ifdef CONFIG_PCI_HCI
// quick fix of tx stuck especial in client mode
void tx_stuck_fix(struct rtl8192cd_priv *priv)
{
	struct rtl8192cd_hw *phw = GET_HW(priv);
	unsigned int val32;
#ifndef SMP_SYNC
	unsigned long flags;
#endif

#ifdef  CONFIG_WLAN_HAL
	if (IS_HAL_CHIP(priv))
		return;
	else if(CONFIG_WLAN_NOT_HAL_EXIST)
#endif
	{
	SAVE_INT_AND_CLI(flags);
//	RTL_W32(0x350, RTL_R32(0x350) | BIT(26));
	val32 = RTL_R32(0x350);
	if (val32 & BIT(24)) {	// tx stuck
			RTL_W8(0x301, RTL_R8(0x301) | BIT(0));
			delay_us(100);
			rtl8192cd_rx_isr(priv);
			RTL_W8(0x302, RTL_R8(0x302) | BIT(4));
			RTL_W8(0x3, RTL_R8(0x3) & (~BIT(0)));
			RTL_W8(0x3, RTL_R8(0x3) | BIT(0));
#ifdef DELAY_REFILL_RX_BUF
			{
				struct sk_buff	*pskb;

				while (phw->cur_rx_refill != phw->cur_rx) {
					pskb = rtl_dev_alloc_skb(priv, RX_BUF_LEN, _SKB_RX_, 1);
					if (pskb == NULL) {
						printk("[%s] can't allocate skbuff for RX!\n", __FUNCTION__);
					}
					init_rxdesc(pskb, phw->cur_rx_refill, priv);

					phw->cur_rx_refill = (phw->cur_rx_refill + 1) % NUM_RX_DESC_IF(priv);
				}
			}
			phw->cur_rx_refill = 0;
#endif
			phw->cur_rx = 0;
			RTL_W32(RX_DESA, (unsigned int)phw->ring_dma_addr);
			RTL_W8(0x301, RTL_R8(0x301) & (~BIT(0)));
			RTL_W8(PCIE_CTRL_REG, MGQ_POLL | BEQ_POLL);
	}
	RESTORE_INT(flags);
}
}
#endif // CONFIG_PCI_HCI

static struct ac_log_info *aclog_lookfor_entry(struct rtl8192cd_priv *priv, unsigned char *addr)
{
	int i, idx=-1;

	for (i=0; i<MAX_AC_LOG; i++) {
		if (priv->acLog[i].used == 0) {
			if (idx < 0)
				idx = i;
			continue;
		}
		if (isEqualMACAddr(priv->acLog[i].addr, addr))
			break;
	}

	if ( i != MAX_AC_LOG)
		return (&priv->acLog[i]);

	if (idx >= 0)
		return (&priv->acLog[idx]);

	return NULL; // table full
}


static void aclog_update_entry(struct ac_log_info *entry, unsigned char *addr)
{
	if (entry->used == 0) {
		memcpy(entry->addr, addr, MACADDRLEN);
		entry->used = 1;
	}
	entry->cur_cnt++;
	entry->last_attack_time = jiffies;
}


static int aclog_check(struct rtl8192cd_priv *priv)
{
	int i, used=0;

	for (i=0; i<MAX_AC_LOG; i++) {
		if (priv->acLog[i].used) {
			used++;
			if (priv->acLog[i].cur_cnt != priv->acLog[i].last_cnt) {
#if defined(CONFIG_RTL8196B_TR) || defined(CONFIG_RTL8196C_EC)
				LOG_MSG_DROP("Unauthorized wireless PC try to connect;note:%02X:%02X:%02X:%02X:%02X:%02X;\n",
					priv->acLog[i].addr[0], priv->acLog[i].addr[1], priv->acLog[i].addr[2],
					priv->acLog[i].addr[3], priv->acLog[i].addr[4], priv->acLog[i].addr[5]);
#elif defined(CONFIG_RTL865X_AC) || defined(CONFIG_RTL865X_KLD) || defined(CONFIG_RTL8196B_KLD) || defined(CONFIG_RTL8196C_KLD)
				LOG_MSG_DROP("Unauthorized wireless PC try to connect;note:%02X:%02X:%02X:%02X:%02X:%02X;\n",
					priv->acLog[i].addr[0], priv->acLog[i].addr[1], priv->acLog[i].addr[2],
					priv->acLog[i].addr[3], priv->acLog[i].addr[4], priv->acLog[i].addr[5]);
#elif defined(CONFIG_RTL8196B_TLD)
				LOG_MSG_DEL("[WLAN access denied] from MAC: %02x:%02x:%02x:%02x:%02x:%02x,\n",
					priv->acLog[i].addr[0], priv->acLog[i].addr[1], priv->acLog[i].addr[2],
					priv->acLog[i].addr[3], priv->acLog[i].addr[4], priv->acLog[i].addr[5]);
#else
				LOG_MSG("A wireless client (%02X:%02X:%02X:%02X:%02X:%02X) was rejected due to access control for %d times in 5 minutes\n",
					priv->acLog[i].addr[0], priv->acLog[i].addr[1], priv->acLog[i].addr[2],
					priv->acLog[i].addr[3], priv->acLog[i].addr[4], priv->acLog[i].addr[5],
					priv->acLog[i].cur_cnt - priv->acLog[i].last_cnt);
#endif
				priv->acLog[i].last_cnt = priv->acLog[i].cur_cnt;
			}
			else { // no update, check expired entry
				if ((jiffies - priv->acLog[i].last_attack_time) > AC_LOG_EXPIRE) {
					memset(&priv->acLog[i], '\0', sizeof(struct ac_log_info));
					used--;
				}
			}
		}
	}

	return used;
}


#ifdef WIFI_WMM
static void get_AP_Qos_Info(struct rtl8192cd_priv *priv, unsigned char *temp)
{
	temp[0] = GET_EDCA_PARA_UPDATE;
	temp[0] &= 0x0f;
	if (APSD_ENABLE)
		temp[0] |= BIT(7);
}


static void get_STA_AC_Para_Record(struct rtl8192cd_priv *priv, unsigned char *temp)
{
//BE
	temp[0] = GET_STA_AC_BE_PARA.AIFSN;
	temp[0] &= 0x0f;
	if (GET_STA_AC_BE_PARA.ACM)
		temp[0] |= BIT(4);
	temp[1] = GET_STA_AC_BE_PARA.ECWmax;
	temp[1] <<= 4;
	temp[1] |= GET_STA_AC_BE_PARA.ECWmin;
	temp[2] = GET_STA_AC_BE_PARA.TXOPlimit % 256;
	temp[3] = GET_STA_AC_BE_PARA.TXOPlimit / 256; // 2^8 = 256, for one byte's range

//BK
	temp[4] = GET_STA_AC_BK_PARA.AIFSN;
	temp[4] &= 0x0f;
	if (GET_STA_AC_BK_PARA.ACM)
		temp[4] |= BIT(4);
	temp[4] |= BIT(5);
	temp[5] = GET_STA_AC_BK_PARA.ECWmax;
	temp[5] <<= 4;
	temp[5] |= GET_STA_AC_BK_PARA.ECWmin;
	temp[6] = GET_STA_AC_BK_PARA.TXOPlimit % 256;
	temp[7] = GET_STA_AC_BK_PARA.TXOPlimit / 256;

//VI
	temp[8] = GET_STA_AC_VI_PARA.AIFSN;
	temp[8] &= 0x0f;
	if (GET_STA_AC_VI_PARA.ACM)
		temp[8] |= BIT(4);
	temp[8] |= BIT(6);
	temp[9] = GET_STA_AC_VI_PARA.ECWmax;
	temp[9] <<= 4;
	temp[9] |= GET_STA_AC_VI_PARA.ECWmin;
	temp[10] = GET_STA_AC_VI_PARA.TXOPlimit % 256;
	temp[11] = GET_STA_AC_VI_PARA.TXOPlimit / 256;

//VO
	temp[12] = GET_STA_AC_VO_PARA.AIFSN;
	temp[12] &= 0x0f;
	if (GET_STA_AC_VO_PARA.ACM)
		temp[12] |= BIT(4);
	temp[12] |= BIT(5)|BIT(6);
	temp[13] = GET_STA_AC_VO_PARA.ECWmax;
	temp[13] <<= 4;
	temp[13] |= GET_STA_AC_VO_PARA.ECWmin;
	temp[14] = GET_STA_AC_VO_PARA.TXOPlimit % 256;
	temp[15] = GET_STA_AC_VO_PARA.TXOPlimit /256;
}


void init_WMM_Para_Element(struct rtl8192cd_priv *priv, unsigned char *temp, unsigned long len)
{
	if (OPMODE & WIFI_AP_STATE) {
		if (len < 24)
			return;
		memcpy(temp, WMM_PARA_IE, 6);
//Qos Info field
		get_AP_Qos_Info(priv, &temp[6]);
//AC Parameters
		get_STA_AC_Para_Record(priv, &temp[8]);
 	}
#ifdef CLIENT_MODE
	else if ((OPMODE & WIFI_STATION_STATE) ||(OPMODE & WIFI_ADHOC_STATE)) {  //  WMM STA
		if (len < 7)
			return;
		memcpy(temp, WMM_IE, 6);
		temp[6] = 0x00;  //  set zero to WMM STA Qos Info field
#ifdef WMM_APSD
		if ((OPMODE & WIFI_STATION_STATE) && APSD_ENABLE && priv->uapsd_assoc) {
			if (priv->pmib->dot11QosEntry.UAPSD_AC_BE)
				temp[6] |= BIT(3);
			if (priv->pmib->dot11QosEntry.UAPSD_AC_BK)
				temp[6] |= BIT(2);
			if (priv->pmib->dot11QosEntry.UAPSD_AC_VI)
				temp[6] |= BIT(1);
			if (priv->pmib->dot11QosEntry.UAPSD_AC_VO)
				temp[6] |= BIT(0);
		}
#endif
	}
#endif
}

void default_WMM_para(struct rtl8192cd_priv *priv)
{
#ifdef RTL_MANUAL_EDCA
	if( priv->pmib->dot11QosEntry.ManualEDCA ) {
		GET_STA_AC_BE_PARA.ACM = priv->pmib->dot11QosEntry.STA_manualEDCA[BE].ACM;
		GET_STA_AC_BE_PARA.AIFSN = priv->pmib->dot11QosEntry.STA_manualEDCA[BE].AIFSN;
		GET_STA_AC_BE_PARA.ECWmin = priv->pmib->dot11QosEntry.STA_manualEDCA[BE].ECWmin;
		GET_STA_AC_BE_PARA.ECWmax = priv->pmib->dot11QosEntry.STA_manualEDCA[BE].ECWmax;
		GET_STA_AC_BE_PARA.TXOPlimit = priv->pmib->dot11QosEntry.STA_manualEDCA[BE].TXOPlimit;

		GET_STA_AC_BK_PARA.ACM = priv->pmib->dot11QosEntry.STA_manualEDCA[BK].ACM;
		GET_STA_AC_BK_PARA.AIFSN = priv->pmib->dot11QosEntry.STA_manualEDCA[BK].AIFSN;
		GET_STA_AC_BK_PARA.ECWmin = priv->pmib->dot11QosEntry.STA_manualEDCA[BK].ECWmin;
		GET_STA_AC_BK_PARA.ECWmax = priv->pmib->dot11QosEntry.STA_manualEDCA[BK].ECWmax;
		GET_STA_AC_BK_PARA.TXOPlimit = priv->pmib->dot11QosEntry.STA_manualEDCA[BK].TXOPlimit;

		GET_STA_AC_VI_PARA.ACM = priv->pmib->dot11QosEntry.STA_manualEDCA[VI].ACM;
		GET_STA_AC_VI_PARA.AIFSN = priv->pmib->dot11QosEntry.STA_manualEDCA[VI].AIFSN;
		GET_STA_AC_VI_PARA.ECWmin = priv->pmib->dot11QosEntry.STA_manualEDCA[VI].ECWmin;
		GET_STA_AC_VI_PARA.ECWmax = priv->pmib->dot11QosEntry.STA_manualEDCA[VI].ECWmax;
		GET_STA_AC_VI_PARA.TXOPlimit = priv->pmib->dot11QosEntry.STA_manualEDCA[VI].TXOPlimit; // 6.016ms

		GET_STA_AC_VO_PARA.ACM = priv->pmib->dot11QosEntry.STA_manualEDCA[VO].ACM;
		GET_STA_AC_VO_PARA.AIFSN = priv->pmib->dot11QosEntry.STA_manualEDCA[VO].AIFSN;
		GET_STA_AC_VO_PARA.ECWmin = priv->pmib->dot11QosEntry.STA_manualEDCA[VO].ECWmin;
		GET_STA_AC_VO_PARA.ECWmax = priv->pmib->dot11QosEntry.STA_manualEDCA[VO].ECWmax;
		GET_STA_AC_VO_PARA.TXOPlimit = priv->pmib->dot11QosEntry.STA_manualEDCA[VO].TXOPlimit; // 3.264ms
		} else
#endif
	{
		GET_STA_AC_BE_PARA.ACM = rtl_sta_EDCA[BE].ACM;
		GET_STA_AC_BE_PARA.AIFSN = rtl_sta_EDCA[BE].AIFSN;
#ifdef MULTI_STA_REFINE 
		if(priv->pshare->rf_ft_var.msta_refine&4 ) {
			GET_STA_AC_BE_PARA.ECWmin = 8;
		} 
		else
#endif
		{
			GET_STA_AC_BE_PARA.ECWmin = rtl_sta_EDCA[BE].ECWmin;			
		}	
		GET_STA_AC_BE_PARA.ECWmax = rtl_sta_EDCA[BE].ECWmax;
		GET_STA_AC_BE_PARA.TXOPlimit = rtl_sta_EDCA[BE].TXOPlimit;

		GET_STA_AC_BK_PARA.ACM = rtl_sta_EDCA[BK].ACM;
		GET_STA_AC_BK_PARA.AIFSN = rtl_sta_EDCA[BK].AIFSN;
		GET_STA_AC_BK_PARA.ECWmin = rtl_sta_EDCA[BK].ECWmin;
		GET_STA_AC_BK_PARA.ECWmax = rtl_sta_EDCA[BK].ECWmax;
		GET_STA_AC_BK_PARA.TXOPlimit = rtl_sta_EDCA[BK].TXOPlimit;

		GET_STA_AC_VI_PARA.ACM = rtl_sta_EDCA[VI].ACM;
		GET_STA_AC_VI_PARA.AIFSN = rtl_sta_EDCA[VI].AIFSN;
		GET_STA_AC_VI_PARA.ECWmin = rtl_sta_EDCA[VI].ECWmin;
		GET_STA_AC_VI_PARA.ECWmax = rtl_sta_EDCA[VI].ECWmax;
		if (priv->pmib->dot11BssType.net_work_type & (WIRELESS_11G|WIRELESS_11A))
			GET_STA_AC_VI_PARA.TXOPlimit = 94; // 3.008ms							GET_STA_AC_VI_PARA.TXOPlimit = rtl_sta_EDCA[VI_AG].TXOPlimit; // 3.008ms
		else
			GET_STA_AC_VI_PARA.TXOPlimit = 188; // 6.016ms								GET_STA_AC_VI_PARA.TXOPlimit = rtl_sta_EDCA[VI].TXOPlimit; // 6.016ms

		GET_STA_AC_VO_PARA.ACM = rtl_sta_EDCA[VO].ACM;
		GET_STA_AC_VO_PARA.AIFSN = rtl_sta_EDCA[VO].AIFSN;
		GET_STA_AC_VO_PARA.ECWmin = rtl_sta_EDCA[VO].ECWmin;
		GET_STA_AC_VO_PARA.ECWmax = rtl_sta_EDCA[VO].ECWmax;
		if (priv->pmib->dot11BssType.net_work_type & (WIRELESS_11G|WIRELESS_11A))
			GET_STA_AC_VO_PARA.TXOPlimit = 47; // 1.504ms							GET_STA_AC_VO_PARA.TXOPlimit = rtl_sta_EDCA[VO_AG].TXOPlimit; // 1.504ms
		else
			GET_STA_AC_VO_PARA.TXOPlimit = 102; // 3.264ms								GET_STA_AC_VO_PARA.TXOPlimit = rtl_sta_EDCA[VO].TXOPlimit; // 3.264ms
	}
}



#ifdef CLIENT_MODE
#ifdef CONFIG_RTL_KERNEL_MIPS16_WLAN
__NOMIPS16
#endif
static void process_WMM_para_ie(struct rtl8192cd_priv *priv, unsigned char *p)
{
	int ACI = (p[0] >> 5) & 0x03;
	/*avoid unaligned load*/
	unsigned short txoplimit;
	memcpy(&txoplimit,&p[2],sizeof(unsigned short));
//	if ((ACI >= 0) && (ACI <= 3)) {
		switch(ACI) {
			case 0:
				GET_STA_AC_BE_PARA.ACM = (p[0] >> 4) & 0x01;
				GET_STA_AC_BE_PARA.AIFSN = p[0] & 0x0f;
				GET_STA_AC_BE_PARA.ECWmin = p[1] & 0x0f;
				GET_STA_AC_BE_PARA.ECWmax = p[1] >> 4;
				GET_STA_AC_BE_PARA.TXOPlimit = le16_to_cpu(txoplimit);
				break;
			case 3:
				GET_STA_AC_VO_PARA.ACM = (p[0] >> 4) & 0x01;
				GET_STA_AC_VO_PARA.AIFSN = p[0] & 0x0f;
				GET_STA_AC_VO_PARA.ECWmin = p[1] & 0x0f;
				GET_STA_AC_VO_PARA.ECWmax = p[1] >> 4;
				GET_STA_AC_VO_PARA.TXOPlimit = le16_to_cpu(txoplimit);
				break;
			case 2:
				GET_STA_AC_VI_PARA.ACM = (p[0] >> 4) & 0x01;
				GET_STA_AC_VI_PARA.AIFSN = p[0] & 0x0f;
				GET_STA_AC_VI_PARA.ECWmin = p[1] & 0x0f;
				GET_STA_AC_VI_PARA.ECWmax = p[1] >> 4;
				GET_STA_AC_VI_PARA.TXOPlimit = le16_to_cpu(txoplimit);
				break;
			default:
				GET_STA_AC_BK_PARA.ACM = (p[0] >> 4) & 0x01;
				GET_STA_AC_BK_PARA.AIFSN = p[0] & 0x0f;
				GET_STA_AC_BK_PARA.ECWmin = p[1] & 0x0f;
				GET_STA_AC_BK_PARA.ECWmax = p[1] >> 4;
				GET_STA_AC_BK_PARA.TXOPlimit = le16_to_cpu(txoplimit);
				break;
		}
//	}
//	else
//		printk("WMM AP EDCA Parameter IE error!\n");
}


static void sta_config_EDCA_para(struct rtl8192cd_priv *priv)
{
	unsigned int slot_time = 20, ifs_time = 10;
	unsigned int vo_edca = 0, vi_edca = 0, be_edca = 0, bk_edca = 0;

	if ((priv->pmib->dot11BssType.net_work_type & WIRELESS_11N ) ||
		(priv->pmib->dot11BssType.net_work_type & WIRELESS_11G))
		slot_time = 9;

	if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11N)
		ifs_time = 16;
#if 1
	if (GET_STA_AC_VO_PARA.AIFSN) {
		vo_edca = (((unsigned short)(GET_STA_AC_VO_PARA.TXOPlimit)) << 16)
			| (((unsigned char)(GET_STA_AC_VO_PARA.ECWmax)) << 12)
			| (((unsigned char)(GET_STA_AC_VO_PARA.ECWmin)) << 8)
			| (ifs_time + GET_STA_AC_VO_PARA.AIFSN * slot_time);

		RTL_W32(EDCA_VO_PARA, vo_edca);
	}

	if (GET_STA_AC_VI_PARA.AIFSN) {
		vi_edca = (((unsigned short)(GET_STA_AC_VI_PARA.TXOPlimit)) << 16)
			| (((unsigned char)(GET_STA_AC_VI_PARA.ECWmax)) << 12)
			| (((unsigned char)(GET_STA_AC_VI_PARA.ECWmin)) << 8)
			| (ifs_time + GET_STA_AC_VI_PARA.AIFSN * slot_time);

		/* WiFi Client mode WMM test IOT refine */
		if (priv->pmib->dot11OperationEntry.wifi_specific && (GET_STA_AC_VI_PARA.AIFSN == 2))
			vi_edca = (vi_edca & ~0xff) | (ifs_time + (GET_STA_AC_VI_PARA.AIFSN + 1) * slot_time);

		RTL_W32(EDCA_VI_PARA, vi_edca);
	}

	if (GET_STA_AC_BE_PARA.AIFSN) {
		be_edca = (((unsigned short)(GET_STA_AC_BE_PARA.TXOPlimit)) << 16)
			| (((unsigned char)(GET_STA_AC_BE_PARA.ECWmax)) << 12)
			| (((unsigned char)(GET_STA_AC_BE_PARA.ECWmin)) << 8)
			| (ifs_time + GET_STA_AC_BE_PARA.AIFSN * slot_time);

		RTL_W32(EDCA_BE_PARA, be_edca);
	}

	if (GET_STA_AC_BK_PARA.AIFSN) {
		bk_edca = (((unsigned short)(GET_STA_AC_BK_PARA.TXOPlimit)) << 16)
			| (((unsigned char)(GET_STA_AC_BK_PARA.ECWmax)) << 12)
			| (((unsigned char)(GET_STA_AC_BK_PARA.ECWmin)) << 8)
			| (ifs_time + GET_STA_AC_BK_PARA.AIFSN * slot_time);
		
		RTL_W32(EDCA_BK_PARA, bk_edca);
	}
#else
	if(GET_STA_AC_VO_PARA.AIFSN > 0) {
		RTL_W32(EDCA_VO_PARA, (((unsigned short)(GET_STA_AC_VO_PARA.TXOPlimit)) << 16)
			| (((unsigned char)(GET_STA_AC_VO_PARA.ECWmax)) << 12)
			| (((unsigned char)(GET_STA_AC_VO_PARA.ECWmin)) << 8)
			| (ifs_time + GET_STA_AC_VO_PARA.AIFSN * slot_time));
		if(GET_STA_AC_VO_PARA.ACM > 0)
			RTL_W8(ACMHWCTRL, RTL_R8(ACMHWCTRL)|BIT(3));
	}

	if(GET_STA_AC_VI_PARA.AIFSN > 0) {
		RTL_W32(EDCA_VI_PARA, (((unsigned short)(GET_STA_AC_VI_PARA.TXOPlimit)) << 16)
			| (((unsigned char)(GET_STA_AC_VI_PARA.ECWmax)) << 12)
			| (((unsigned char)(GET_STA_AC_VI_PARA.ECWmin)) << 8)
			| (ifs_time + GET_STA_AC_VI_PARA.AIFSN * slot_time));
		if(GET_STA_AC_VI_PARA.ACM > 0)
			RTL_W8(ACMHWCTRL, RTL_R8(ACMHWCTRL)|BIT(2));
	}

	if(GET_STA_AC_BE_PARA.AIFSN > 0) {
		RTL_W32(EDCA_BE_PARA, (((unsigned short)(GET_STA_AC_BE_PARA.TXOPlimit)) << 16)
			| (((unsigned char)(GET_STA_AC_BE_PARA.ECWmax)) << 12)
			| (((unsigned char)(GET_STA_AC_BE_PARA.ECWmin)) << 8)
			| (ifs_time + GET_STA_AC_BE_PARA.AIFSN * slot_time));
		if(GET_STA_AC_BE_PARA.ACM > 0)
			RTL_W8(ACMHWCTRL, RTL_R8(ACMHWCTRL)|BIT(1));
	}

	if(GET_STA_AC_BK_PARA.AIFSN > 0) {
		RTL_W32(EDCA_BK_PARA, (((unsigned short)(GET_STA_AC_BK_PARA.TXOPlimit)) << 16)
			| (((unsigned char)(GET_STA_AC_BK_PARA.ECWmax)) << 12)
			| (((unsigned char)(GET_STA_AC_BK_PARA.ECWmin)) << 8)
			| (ifs_time + GET_STA_AC_BK_PARA.AIFSN * slot_time));
	}

	if ((GET_STA_AC_VO_PARA.ACM > 0) || (GET_STA_AC_VI_PARA.ACM > 0) || (GET_STA_AC_BE_PARA.ACM > 0))
		RTL_W8(ACMHWCTRL, RTL_R8(ACMHWCTRL)|BIT(0));
#endif

	priv->pmib->dot11QosEntry.EDCA_STA_config = 1;
	priv->pshare->iot_mode_enable = 0;
	if (priv->pshare->rf_ft_var.wifi_beq_iot)
		priv->pshare->iot_mode_VI_exist = 0;
	priv->pshare->iot_mode_VO_exist = 0;
#ifdef WMM_VIBE_PRI
	priv->pshare->iot_mode_BE_exist = 0;
#endif
#ifdef WMM_BEBK_PRI
	priv->pshare->iot_mode_BK_exist = 0;
#endif
#ifdef LOW_TP_TXOP
	priv->pshare->BE_cwmax_enhance = 0;
#endif
}


static void reset_EDCA_para(struct rtl8192cd_priv *priv)
{
	memset((void *)&GET_STA_AC_VO_PARA, 0, sizeof(struct ParaRecord));
	memset((void *)&GET_STA_AC_VI_PARA, 0, sizeof(struct ParaRecord));
	memset((void *)&GET_STA_AC_BE_PARA, 0, sizeof(struct ParaRecord));
	memset((void *)&GET_STA_AC_BK_PARA, 0, sizeof(struct ParaRecord));

#ifdef USE_OUT_SRC
#ifdef _OUTSRC_COEXIST
	if(IS_OUTSRC_CHIP(priv))
#endif
	EdcaParaInit(priv);
#endif

#if !defined(USE_OUT_SRC) || defined(_OUTSRC_COEXIST)
#ifdef _OUTSRC_COEXIST
	if(!IS_OUTSRC_CHIP(priv))
#endif
	init_EDCA_para(priv, priv->pmib->dot11BssType.net_work_type);
#endif

	priv->pmib->dot11QosEntry.EDCA_STA_config = 0;
}
#endif // CLIENT_MODE
#endif // WIFI_WMM


// Realtek proprietary IE
static void process_rtk_ie(struct rtl8192cd_priv *priv)
{
	struct stat_info *pstat;
	int use_long_slottime=0;
	unsigned int threshold;
#if defined(SMP_SYNC)/* && (defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI))*/
	unsigned long flags=0;
#endif

	if ((priv->up_time % 3) != 0)
		return;

	if ((get_rf_mimo_mode(priv) == RF_1T2R) || (get_rf_mimo_mode(priv) == RF_1T1R))
		threshold = 50*1024*1024/8;
	else
		threshold = 100*1024*1024/8;

	if (OPMODE & WIFI_AP_STATE)
	{
		struct list_head *phead = &priv->asoc_list;
		struct list_head *plist;

		SMP_LOCK_ASOC_LIST(flags);
		
		plist = phead->next;
		while(plist != phead)
		{
			pstat = list_entry(plist, struct stat_info, asoc_list);
			plist = plist->next;

			if ((pstat->expire_to > 0) &&
				(/*priv->pshare->is_giga_exist ||*/ !pstat->is_2t_mimo_sta) &&
				((pstat->is_realtek_sta && (pstat->IOTPeer!= HT_IOT_PEER_RTK_APCLIENT) && ((pstat->tx_avarage + pstat->rx_avarage) > threshold))
#ifdef WDS
				  || ((pstat->state & WIFI_WDS) && ((pstat->tx_avarage + pstat->rx_avarage) > (threshold*2/3)))
#endif
				  )) {
				use_long_slottime = 1;
				break;
			}
		}

		SMP_UNLOCK_ASOC_LIST(flags);

		if (priv->pshare->use_long_slottime == 0) {
			if (use_long_slottime) {
				priv->pshare->use_long_slottime = 1;
				set_slot_time(priv, 0);
				priv->pmib->dot11ErpInfo.shortSlot = 0;
				RESET_SHORTSLOT_IN_BEACON_CAP;
				priv->pshare->rtk_ie_buf[5] |= RTK_CAP_IE_USE_LONG_SLOT;
			}
		}
		else {
			if (use_long_slottime == 0) {
				priv->pshare->use_long_slottime = 0;
				check_protection_shortslot(priv);
				priv->pshare->rtk_ie_buf[5] &= (~RTK_CAP_IE_USE_LONG_SLOT);
			}
		}
	}
}

#ifdef RADIUS_ACCOUNTING
void indicate_sta_leaving(struct rtl8192cd_priv *priv,struct stat_info *pstat, unsigned long reason)
{
	DOT11_DISASSOCIATION_IND Disassociation_Ind;

	memcpy((void *)Disassociation_Ind.MACAddr, (void *)(pstat->cmn_info.mac_addr), MACADDRLEN);
	Disassociation_Ind.EventId = DOT11_EVENT_DISASSOCIATION_IND;
	Disassociation_Ind.IsMoreEvent = 0;
	Disassociation_Ind.Reason = reason;
	Disassociation_Ind.tx_packets = pstat->tx_pkts;
	Disassociation_Ind.rx_packets = pstat->rx_pkts;
	Disassociation_Ind.tx_bytes   = pstat->tx_bytes;
	Disassociation_Ind.rx_bytes   = pstat->rx_bytes;
	DOT11_EnQueue((unsigned long)priv, priv->pevent_queue, (UINT8 *)&Disassociation_Ind,
				sizeof(DOT11_DISASSOCIATION_IND));
	psk_indicate_evt(priv, DOT11_EVENT_DISASSOCIATION_IND, pstat->cmn_info.mac_addr, NULL, 0);
}

int cal_statistics_acct(struct rtl8192cd_priv *priv)
{
	unsigned long ret=0;
	struct list_head *phead=NULL, *plist=NULL;
	struct stat_info *pstat=NULL;
#ifdef SMP_SYNC
	unsigned long flags=0;
#endif

	phead = &priv->asoc_list;
	if( list_empty(phead) )
		goto acct_cal_out;

	SMP_LOCK_ASOC_LIST(flags);
	
	plist = phead->next;
	while (plist != phead) {
		pstat = list_entry(plist, struct stat_info, asoc_list);
		plist = plist->next;

		if( pstat->link_time%ACCT_TP_INT == 0 ){
			pstat->rx_bytes_1m = pstat->rx_bytes - pstat->rx_bytes_1m;
			pstat->tx_bytes_1m = pstat->tx_bytes - pstat->tx_bytes_1m;
		}
	}
	
	SMP_UNLOCK_ASOC_LIST(flags);

acct_cal_out:
	return ret;
}

int expire_sta_for_radiusacct(struct rtl8192cd_priv *priv)
{
	int ret=0;
	struct list_head *phead=NULL, *plist=NULL;
	struct stat_info *pstat=NULL;
#ifdef SMP_SYNC
    unsigned long flags = 0;
#endif

	if( (ACCT_FUN_TIME == 0) && (ACCT_FUN_TP == 0))
		goto acct_expire_out;

	phead = &priv->asoc_list;
	if(list_empty(phead))
		goto acct_expire_out;

	plist = phead;

	if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE)
		SMP_LOCK_ASOC_LIST(flags);
	while ((plist = asoc_list_get_next(priv, plist)) != phead) {
		pstat = list_entry(plist, struct stat_info, asoc_list);

		if(pstat->link_time > ACCT_FUN_TIME*60 ){
#if !defined(WITHOUT_ENQUEUE) && (defined(INCLUDE_WPA_PSK) || defined(WIFI_HAPD)  || defined(RTK_NL80211))
			indicate_sta_leaving(priv,pstat,_RSON_AUTH_NO_LONGER_VALID_);
#endif
			DRV_RT_TRACE(priv, DRV_DBG_CONN_INFO, DRV_DBG_SERIOUS, "A STA is rejected by 802.1x daemon - %pm, Reason=_RSON_AUTH_NO_LONGER_VALID_\n",
					pstat->cmn_info.mac_addr);
			issue_deauth(priv,pstat->cmn_info.mac_addr,_RSON_AUTH_NO_LONGER_VALID_);
			cnt_assoc_num(priv, pstat, DECREASE, (char *)__FUNCTION__);
			check_sta_characteristic(priv, pstat, DECREASE);
			LOG_MSG("A STA(%pm) is deleted for accounting becoz of time-out\n", pstat->cmn_info.mac_addr);
		}

		if(pstat->tx_bytes_1m+pstat->rx_bytes_1m < ACCT_FUN_TP*(2^20) ){
#if !defined(WITHOUT_ENQUEUE) && (defined(INCLUDE_WPA_PSK) || defined(WIFI_HAPD) || defined(RTK_NL80211))
			indicate_sta_leaving(priv,pstat,_RSON_AUTH_NO_LONGER_VALID_);
#endif
			DRV_RT_TRACE(priv, DRV_DBG_CONN_INFO, DRV_DBG_SERIOUS, "A STA is rejected by 802.1x daemon - %pm, Reason=_RSON_AUTH_NO_LONGER_VALID_\n",
					pstat->cmn_info.mac_addr);
			issue_deauth(priv,pstat->cmn_info.mac_addr,_RSON_AUTH_NO_LONGER_VALID_);
			cnt_assoc_num(priv, pstat, DECREASE, (char *)__FUNCTION__);
			check_sta_characteristic(priv, pstat, DECREASE);
			LOG_MSG("A STA(%pm) is deleted for accounting becoz of low TP\n",
				pstat->cmn_info.mac_addr);
		}
	}

acct_expire_out:
	if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE)
		SMP_UNLOCK_ASOC_LIST(flags);
	return ret;
}
#endif	//#ifdef RADIUS_ACCOUNTING


//#if defined(SMART_REPEATER_MODE) && !defined(RTK_NL80211)
#if 0//removed to prevent system hang-up after repeater follow remote AP to switch channel
static void switch_chan_to_vxd(struct rtl8192cd_priv *priv)
{
#ifdef MBSSID
	unsigned int i;
#endif

	priv->pmib->dot11RFEntry.dot11channel = priv->pshare->switch_chan_rp;
	priv->pmib->dot11nConfigEntry.dot11n2ndChOffset = priv->pshare->switch_2ndchoff_rp;
	GET_ROOT(priv)->pmib->dot11nConfigEntry.dot11nUse40M = priv->pshare->band_width_rp;
	RTL_W8(TXPAUSE, 0xff);

	// update vxd channel and 2ndChOffset
#ifdef UNIVERSAL_REPEATER	
    //	GET_VXD_PRIV(priv)->pmib->dot11RFEntry.dot11channel = priv->pshare->switch_chan_rp;
    //	GET_VXD_PRIV(priv)->pmib->dot11nConfigEntry.dot11n2ndChOffset = priv->pshare->switch_2ndchoff_rp;
#endif    

	DEBUG_INFO("3. Swiching channel to %d!\n", priv->pmib->dot11RFEntry.dot11channel);
	priv->pmib->dot11OperationEntry.keep_rsnie = 1; 
	
#ifdef MBSSID
	if (GET_ROOT(priv)->pmib->miscEntry.vap_enable) {
		for (i=0; i<RTL8192CD_NUM_VWLAN; i++) {
			if (IS_DRV_OPEN(priv->pvap_priv[i]))
				priv->pvap_priv[i]->pmib->dot11OperationEntry.keep_rsnie = 1;
		}
	}
#endif

#ifdef UNIVERSAL_REPEATER
	if (GET_VXD_PRIV(priv))
		GET_VXD_PRIV(priv)->pmib->dot11OperationEntry.keep_rsnie = 1;
#endif

	rtl8192cd_close(priv->dev);
	rtl8192cd_open(priv->dev);

	RTL_W8(TXPAUSE, 0x00);			
}
#endif

#ifdef HS2_SUPPORT
#ifdef HS2_CLIENT_TEST
//issue_GASreq for client test used
int issue_GASreq(struct rtl8192cd_priv *priv, DOT11_HS2_GAS_REQ *gas_req, unsigned short qid);
int testflg=0;
#endif
#endif
#if defined(TXREPORT) && defined(CONFIG_WLAN_HAL)
void requestTxReport88XX(struct rtl8192cd_priv *priv)
{
	//unsigned char h2cresult;
	struct stat_info *sta;
	unsigned char H2CCommand[3] = {0xff, 0xff, 0};

	if ( priv->pshare->sta_query_idx == -1)
		return;

#ifdef TXRETRY_CNT
	priv->pshare->sta_query_retry_idx = priv->pshare->sta_query_idx;
#endif

	sta = findNextSTA(priv, &priv->pshare->sta_query_idx);
	if (sta)
	{
		H2CCommand[0] = REMAP_AID(sta);
	}
	else {
		priv->pshare->sta_query_idx = -1;
		return;
	}

	sta = findNextSTA(priv, &priv->pshare->sta_query_idx);
	if (sta)	{
		H2CCommand[1] = REMAP_AID(sta);
	} else {
		priv->pshare->sta_query_idx = -1;
	}

	//WDEBUG("\n");
	//h2cresult = fill_h2c_cmd8812(priv, H2C_8812_TX_REPORT, 2 , H2CCommand);
	//WDEBUG("h2cresult=%d\n",h2cresult);
	GET_HAL_INTERFACE(priv)->fill_h2c_cmd_handler(priv, H2C_88XX_AP_REQ_TXREP, 3, H2CCommand);

}

#if (MU_BEAMFORMING_SUPPORT == 1)

void updateActiveGid(struct rtl8192cd_priv *priv) 
{
	PRT_BEAMFORMING_INFO pBeamformingInfo = &(priv->pshare->BeamformingInfo);
	
	unsigned char gid_to_pos0_index[30] = {0,1,0,2,0,3,0,4,0,5,
										   1,2,1,3,1,4,1,5,2,3,
										   2,4,2,5,3,4,3,5,4,5};
	
	unsigned char gid_to_pos1_index[30] = {1,0,2,0,3,0,4,0,5,0,
											2,1,3,1,4,1,5,1,3,2,
											4,2,5,2,4,3,5,3,5,4};
	unsigned char	isActive;
	int gid;
	
	for(gid = 0; gid< 30; gid++) {
		isActive = (pBeamformingInfo->beamformee_mu_reg_maping & BIT(gid_to_pos0_index[gid])) && (pBeamformingInfo->beamformee_mu_reg_maping & BIT(gid_to_pos1_index[gid]));
		pBeamformingInfo->active_gid[gid] = isActive;
	}
	
}
int findNextMUSTA(struct rtl8192cd_priv *priv, int *gid)
{
	int isExist, orig_gid, i;
	
	PRT_BEAMFORMING_INFO pBeamformingInfo = &(priv->pshare->BeamformingInfo);

	if(pBeamformingInfo->beamformee_mu_reg_maping != pBeamformingInfo->beamformee_mu_reg_maping_old) {
		pBeamformingInfo->beamformee_mu_reg_maping_old = pBeamformingInfo->beamformee_mu_reg_maping;
		updateActiveGid(priv);
	}

	if(*gid < 0x80) {
		panic_printk("(%s)gid (%d) < 0x80\n", __FUNCTION__, *gid);
		goto not_found;
	}
	
	orig_gid = *gid;	

	if(pBeamformingInfo->active_gid[orig_gid - 0x80]) {
		for(i = (orig_gid - 0x80) + 1; i<30; i++) {
			if(pBeamformingInfo->active_gid[i])	{
				*gid = 0x80 + i;				
				break;
			}				
		}
		if(i == 30) {
			*gid = -1;
		}
		
		return orig_gid;
	}

not_found:
	*gid = -1;
	return 0;
}

void requestTxReport88XX_MU(struct rtl8192cd_priv *priv)
{
	//unsigned char h2cresult;
	unsigned int i, gid;
	struct stat_info *sta;
	unsigned char H2CCommand[3] = {0xff, 0xff, 0};

	if ( priv->pshare->sta_query_idx == -1)
		return;
	
#ifdef TXRETRY_CNT
	priv->pshare->sta_query_retry_idx = priv->pshare->sta_query_idx;
#endif
	for(i=0;i<2;i++) {
		if(priv->pshare->sta_query_idx < 0x80) {
			sta = findNextSTA(priv, &priv->pshare->sta_query_idx);
			if (sta)
			{
				H2CCommand[i] = REMAP_AID(sta);
			}
			else {									
				priv->pshare->sta_query_idx = 0x80;
				gid = findNextMUSTA(priv, &priv->pshare->sta_query_idx);
				if(gid) {
					H2CCommand[i] = gid;	
					if(priv->pshare->sta_query_idx == -1)
						break;
				} else {
					if(i==0)
						return;
				}
			}
		} else {
			gid = findNextMUSTA(priv, &priv->pshare->sta_query_idx);
			if(gid) {
				H2CCommand[i] = gid;
				if(priv->pshare->sta_query_idx == -1)
					break;
			}
			else {
				if(i==0)
					return;
			}
			
			
		}
	}
	
	//WDEBUG("\n");
	//h2cresult = FillH2CCmd8812(priv, H2C_8812_TX_REPORT, 2 , H2CCommand);
	//WDEBUG("h2cresult=%d\n",h2cresult);
	GET_HAL_INTERFACE(priv)->fill_h2c_cmd_handler(priv, H2C_88XX_AP_REQ_TXREP, 3, H2CCommand);

}
#endif
#ifdef TXRETRY_CNT
void requestTxRetry88XX(struct rtl8192cd_priv *priv)
{
	unsigned char counter = 20;
	struct stat_info *sta;
	unsigned char H2CCommand[3] = {0xff, 0xff, 0x2};

	//panic_printk("%s %d \n", __FUNCTION__, __LINE__);

	if ( priv->pshare->sta_query_retry_idx == -1)
		return;

	while (is_h2c_buf_occupy(priv)) {
		delay_ms(2);
		if (--counter == 0)
			break;
	}

	if (!counter)
		return;

	//panic_printk("%s %d \n", __FUNCTION__, __LINE__);

	sta = findNextSTA(priv, &priv->pshare->sta_query_retry_idx);
	if (sta)
	{
		H2CCommand[0] = REMAP_AID(sta);
	}
	else {
		priv->pshare->sta_query_retry_idx = -1;
		return;
	}

	sta = findNextSTA(priv, &priv->pshare->sta_query_retry_idx);
	if (sta)	{
		H2CCommand[1] = REMAP_AID(sta);
	} else {
		priv->pshare->sta_query_retry_idx = -1;
	}

	priv->pshare->sta_query_retry_macid[0] = H2CCommand[0];
	priv->pshare->sta_query_retry_macid[1] = H2CCommand[1];

	GET_HAL_INTERFACE(priv)->fill_h2c_cmd_handler(priv, H2C_88XX_AP_REQ_TXREP, 3, H2CCommand);

}

#if (MU_BEAMFORMING_SUPPORT == 1)
void requestTxRetry88XX_MU(struct rtl8192cd_priv *priv)
{
	unsigned int i, gid;
	unsigned char counter = 20;
	struct stat_info *sta;
	unsigned char H2CCommand[3] = {0xff, 0xff, 0x2};

	//panic_printk("%s %d \n", __FUNCTION__, __LINE__);

	if ( priv->pshare->sta_query_retry_idx == -1)
		return;

	while (is_h2c_buf_occupy(priv)) {
		delay_ms(2);
		if (--counter == 0)
			break;
	}

	if (!counter)
		return;

	for(i=0;i<2;i++) {
		if(priv->pshare->sta_query_retry_idx < 0x80) {
			sta = findNextSTA(priv, &priv->pshare->sta_query_retry_idx);
			if (sta)
			{
				H2CCommand[i] = REMAP_AID(sta);
			}
			else {
				priv->pshare->sta_query_retry_idx = 0x80;
				gid = findNextMUSTA(priv, &priv->pshare->sta_query_retry_idx);
				if(gid) {
					H2CCommand[i] = gid;
					if(priv->pshare->sta_query_retry_idx == -1)
						break;
				} else {
					if(i==0)
						return;
				}
			}
		} else {
			gid = findNextMUSTA(priv, &priv->pshare->sta_query_retry_idx);
			if(gid) {
				H2CCommand[i] = gid;
				if(priv->pshare->sta_query_retry_idx == -1)
					break;
			}
			else {
				if(i==0)
					return;
			}
		}
	}

	priv->pshare->sta_query_retry_macid[0] = H2CCommand[0];
	priv->pshare->sta_query_retry_macid[1] = H2CCommand[1];

	GET_HAL_INTERFACE(priv)->fill_h2c_cmd_handler(priv, H2C_88XX_AP_REQ_TXREP, 3, H2CCommand);
}
#endif
#endif

#endif


int is_intel_connected(struct rtl8192cd_priv *priv)
{
	struct list_head *phead, *plist;
	struct stat_info *pstat;
	unsigned char intel_connected=0;
#if defined(SMP_SYNC)/* && (defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI))*/
	unsigned long flags = 0;
#endif

	phead = &priv->asoc_list;
	
	if (list_empty(phead)) {
		return 0;
	}

	SMP_LOCK_ASOC_LIST(flags);

	plist = phead->next;
	while (plist != phead) {
		pstat = list_entry(plist, struct stat_info, asoc_list);
		plist = plist->next;
						
		if(pstat->IOTPeer== HT_IOT_PEER_INTEL)
		{
			intel_connected = 1;
			break;
		}
	}

	SMP_UNLOCK_ASOC_LIST(flags);

	return intel_connected;
}

#if defined(RTK_NL80211) || defined(CH_LOAD_CAL)//survey_dump
const int MCS_DATA_RATEFloat[2][2][16] =
{
	{{6.5, 13, 19.5, 26, 39, 52, 58.5, 65, 13, 26, 39, 52, 78, 104, 117, 130},						  // Long GI, 20MHz
	 {7.2, 14.4, 21.7, 28.9, 43.3, 57.8, 65, 72.2, 14.4, 28.9, 43.3, 57.8, 86.7, 115.6, 130, 144.5}}, // Short GI, 20MHz
	{{13.5, 27, 40.5, 54, 81, 108, 121.5, 135, 27, 54, 81, 108, 162, 216, 243, 270},                  // Long GI, 40MHz
	 {15, 30, 45, 60, 90, 120, 135, 150, 30, 60, 90, 120, 180, 240, 270, 300}}                        // Short GI, 40MHz
};
#endif
#ifdef RTK_NL80211
void check_sta_throughput(struct rtl8192cd_priv *priv, unsigned int chan_idx)
{
	struct list_head *phead, *plist;
	struct stat_info *pstat;
	int tx_rate=0, rx_rate=0;
	int tx_time=0, rx_time=0;
#ifdef SMP_SYNC
    unsigned long flags = 0;
#endif

	//check every sta throughput
	phead = &priv->asoc_list;
	if (list_empty(phead)) {
		return;
	}

    SMP_LOCK_ASOC_LIST(flags);
    
	plist = phead->next;

	while (plist != phead)
	{
		pstat = list_entry(plist, struct stat_info, asoc_list);
		pstat->tx_time_total=0;
		pstat->rx_time_total=0;
		//cal current tx rate
#ifdef RTK_AC_SUPPORT  //vht rate , todo, dump vht rates in Mbps
		if(pstat->current_tx_rate >= 0x90)
		{
			tx_rate = query_vht_rate(pstat);
			rx_rate = query_vht_rate(pstat);
		}
		else
#endif
		if (is_MCS_rate(pstat->current_tx_rate)) 
		{
			tx_rate = MCS_DATA_RATEFloat[(pstat->ht_current_tx_info&BIT(0))?1:0][(pstat->ht_current_tx_info&BIT(1))?1:0][pstat->current_tx_rate&0xf];
			rx_rate = MCS_DATA_RATEFloat[pstat->rx_bw&0x01][pstat->rx_splcp&0x01][pstat->rx_rate&0xf];
		}
		else
		{
			tx_rate = pstat->current_tx_rate/2;
			rx_rate = pstat->rx_rate/2;
		}
		
		//last tx/rx time
		if(tx_rate != 0)
			pstat->tx_time_total += div_u64((pstat->tx_bytes - pstat->tx_byte_last)*8*1000, tx_rate*1024);
			//pstat->tx_time_total += (((pstat->tx_bytes - pstat->tx_byte_last)*8*1000)/(tx_rate*1024));
		if(rx_rate != 0)
			pstat->rx_time_total += div_u64((pstat->rx_bytes - pstat->rx_byte_last)*8*1000, rx_rate*1024);
			//pstat->rx_time_total += (((pstat->rx_bytes - pstat->rx_byte_last)*8*1000)/(rx_rate*1024));
		#if 0
		printk("tx: rate[%d] tx_byte[%d] tx_byte_last[%d]\n",
			tx_rate, pstat->tx_bytes - pstat->tx_byte_last,  pstat->tx_byte_last);
		printk("rx: rate[%d] rx_byte[%d] rx_byte_last[%d]\n",
			rx_rate, pstat->rx_bytes - pstat->rx_byte_last,  pstat->rx_byte_last);
		#endif
		//tx/rx byte last
		pstat->tx_byte_last = pstat->tx_bytes;
		pstat->rx_byte_last = pstat->rx_bytes;
		
		//count all traffic time
		tx_time += pstat->tx_time_total;
		rx_time += pstat->rx_time_total;

		plist = plist->next;
	}

    SMP_UNLOCK_ASOC_LIST(flags);
    
	priv->rtk->survey_info[chan_idx].tx_time = tx_time;
	priv->rtk->survey_info[chan_idx].rx_time = rx_time;

	//printk("tx_time=%d rx_time=%d\n",priv->rtk->survey_info[chan_idx].tx_time, priv->rtk->survey_info[chan_idx].rx_time);
}

void read_noise_report(struct rtl8192cd_priv *priv, int idx)
{
	s8 noise = 0;

#ifdef USE_OUT_SRC
	if (IS_OUTSRC_CHIP(priv)) {
		noise = odm_inband_noise_monitor(ODMPTR, TRUE, 0x32, 10);
	} else
#endif
	{
		/* not support */
	}

	priv->rtk->survey_info[idx].noise = noise;

	return;
}
#endif

#if defined(TXRETRY_CNT) || defined(CH_LOAD_CAL)
void per_sta_cal(struct rtl8192cd_priv *priv)
{
	struct list_head *phead, *plist;
	struct stat_info *pstat;
#ifdef SMP_SYNC
	unsigned long flags = 0;
#endif

#ifdef CH_LOAD_CAL
	int tx_rate=0, rx_rate=0;
	int tx_time=0, rx_time=0;
#endif

	//calculate every sta tx/rx time and retry ratio
	phead = &priv->asoc_list;
	if (list_empty(phead))
	{
		return;
	}

    SMP_LOCK_ASOC_LIST(flags);
    
	plist = phead->next;
	while (plist != phead)
	{
		pstat = list_entry(plist, struct stat_info, asoc_list);
        plist = plist->next;
        
#ifdef CH_LOAD_CAL
		pstat->total_tx_time=0;
		pstat->total_rx_time=0;
		//cal current tx rate
#ifdef RTK_AC_SUPPORT  //vht rate , todo, dump vht rates in Mbps
		if(pstat->current_tx_rate >= 0x90)
		{
			tx_rate = query_vht_rate(pstat);
			rx_rate = query_vht_rate(pstat);
		}
		else
#endif
		if (is_MCS_rate(pstat->current_tx_rate)) 
			tx_rate = MCS_DATA_RATEFloat[(pstat->ht_current_tx_info&BIT(0))?1:0][(pstat->ht_current_tx_info&BIT(1))?1:0][pstat->current_tx_rate&0xf];			
		else
			tx_rate = pstat->current_tx_rate/2;

		//rx rate
#ifdef RTK_AC_SUPPORT  //vht rate , todo, dump vht rates in Mbps
		if(pstat->rx_rate >= 0x90)
			rx_rate = query_vht_rate(pstat);
		else
#endif		
		if (is_MCS_rate(pstat->rx_rate)) 			
			rx_rate = MCS_DATA_RATEFloat[pstat->rx_bw&0x01][pstat->rx_splcp&0x01][pstat->rx_rate&0xf];
		else		
			rx_rate = pstat->rx_rate/2;
		
		//last tx/rx time
		if(tx_rate != 0)
			pstat->total_tx_time+= div_u64(div_u64((pstat->tx_bytes - pstat->prev_tx_byte)*8, tx_rate*1024)*1000, 1024);
			//pstat->total_tx_time+= ((((unsigned int)(pstat->tx_bytes - pstat->prev_tx_byte)*8)/(tx_rate*1024))*1000)/1024;
		if(rx_rate != 0)
			pstat->total_rx_time+= div_u64(div_u64((pstat->rx_bytes - pstat->prev_rx_byte)*8, rx_rate*1024)*1000, 1024);
			//pstat->total_rx_time+= ((((unsigned int)(pstat->rx_bytes - pstat->prev_rx_byte)*8)/(rx_rate*1024))*1000)/1024;
		
		//tx/rx byte last
		pstat->prev_tx_byte = pstat->tx_bytes;
		pstat->prev_rx_byte = pstat->rx_bytes;

		//count all traffic time
		tx_time += pstat->total_tx_time;
		rx_time += pstat->total_rx_time;
#endif
#ifdef TXRETRY_CNT
		int tx_pkts = pstat->tx_pkts-pstat->prev_tx_pkts;
		int retry_pkts = pstat->total_tx_retry_cnt-pstat->prev_tx_retry_pkts;
		if(retry_pkts>0)
			pstat->txretry_ratio = (retry_pkts*100)/(tx_pkts+retry_pkts);
		else
			pstat->txretry_ratio = 0;
		pstat->prev_tx_pkts = pstat->tx_pkts;
		pstat->prev_tx_retry_pkts = pstat->total_tx_retry_cnt;		
#endif
#ifdef RTK_MULTI_AP
		if(priv->pmib->multi_ap.multiap_report_rcpi_threshold != 0){
			rtk_multi_ap_sta_rssi_trigger(priv, pstat);
		}
#endif
	}

    SMP_UNLOCK_ASOC_LIST(flags);
    
#ifdef CH_LOAD_CAL
	priv->ext_stats.tx_time = tx_time;
	priv->ext_stats.rx_time = rx_time;
#endif

}
#endif

#if defined(CLIENT_MODE) && defined(WIFI_11N_2040_COEXIST)
void start_clnt_coexist_scan(struct rtl8192cd_priv *priv)
{
	static unsigned int to_issue_coexist_mgt = 0;
	int throughput = 0;

	if (((priv->pmib->dot11BssType.net_work_type & (WIRELESS_11N | WIRELESS_11G)) == (WIRELESS_11N | WIRELESS_11G)) &&
		priv->pmib->dot11nConfigEntry.dot11nCoexist &&
		priv->coexist_connection &&
		priv->pmib->dot11nConfigEntry.dot11nCoexist_obss_scan &&
		(!(priv->up_time % 85) || to_issue_coexist_mgt))
	{
		throughput = (priv->ext_stats.tx_avarage + priv->ext_stats.rx_avarage) >> 7; /*unit k bps*/

		/*more than 300k bps*/
		if (throughput > 300)
			goto skip_scan;

#ifdef UNIVERSAL_REPEATER
		if (IS_VXD_INTERFACE(priv)) {
			throughput = (GET_ROOT(priv)->ext_stats.tx_avarage + GET_ROOT(priv)->ext_stats.rx_avarage) >> 7;/*unit k bps*/
			/*more than 300k bps*/
			if (throughput > 300)
				goto skip_scan;

#ifdef MBSSID
			if (GET_ROOT(priv)->pmib->miscEntry.vap_enable) {
				int i;
				for (i=0; i<RTL8192CD_NUM_VWLAN; i++) {
					if (IS_DRV_OPEN(GET_ROOT(priv)->pvap_priv[i])) {
						throughput = (GET_ROOT(priv)->pvap_priv[i]->ext_stats.tx_avarage + GET_ROOT(priv)->pvap_priv[i]->ext_stats.rx_avarage) >> 7;/*unit k bps*/

						/*more than 300k bps*/
						if (throughput > 300)
							goto skip_scan;
					}	
				}
			}
#endif
		}
#endif

		if (!(priv->up_time % 85)) {
			priv->ss_ssidlen = 0;
			DEBUG_INFO("start_clnt_ss, trigger by %s, ss_ssidlen=0\n", (char *)__FUNCTION__);
			priv->ss_req_ongoing = SSFROM_WEB;
			start_clnt_ss(priv);
			to_issue_coexist_mgt++;
		}

skip_scan:
		if (to_issue_coexist_mgt && !(OPMODE & WIFI_SITE_MONITOR) &&
			(priv->bg_ap_timeout || priv->intolerant_timeout)) {
			issue_coexist_mgt(priv);
			to_issue_coexist_mgt = 0;
		}
	}
}
#endif

#if defined(CONFIG_IEEE80211W) || defined(CONFIG_IEEE80211V)
void issue_actionFrame(struct rtl8192cd_priv *priv)
{
	struct stat_info *pstat;
	struct list_head *phead, *plist;	
#ifdef SMP_SYNC
    unsigned long local_flags = 0;
#endif

	if(priv->pmib->dot11StationConfigEntry.pmftest == 1) { // for PMF case 4.4, protect broadcast mgmt frame by BIP
		PMFDEBUG("%s(%d) issue broadcast deauth\n", __FUNCTION__, __LINE__);
		memcpy(priv->pmib->dot11StationConfigEntry.deauth_mac,"\xff\xff\xff\xff\xff\xff",6);
		issue_deauth(priv, priv->pmib->dot11StationConfigEntry.deauth_mac, _RSON_UNSPECIFIED_);

		phead = &priv->asoc_list;
		if (netif_running(priv->dev) && !list_empty(phead)) {
            SMP_LOCK_ASOC_LIST(local_flags);
			plist = phead->next;
			while (plist != phead) {
				pstat = list_entry(plist, struct stat_info, asoc_list);
                SMP_UNLOCK_ASOC_LIST(local_flags);
				PMFDEBUG("pstat=%pm\n", pstat->cmn_info.mac_addr);
				del_station(priv, pstat, DEL_STA_SEND_NONE, _RSON_UNSPECIFIED_);
                SMP_LOCK_ASOC_LIST(local_flags);
				plist = phead->next;				
			}
            SMP_UNLOCK_ASOC_LIST(local_flags);
		}
		priv->pmib->dot11StationConfigEntry.pmftest = 0;
	} else if(priv->pmib->dot11StationConfigEntry.pmftest == 2) {
		PMFDEBUG("issue unicast deauth\n");
		pstat = get_stainfo(priv, priv->pmib->dot11StationConfigEntry.deauth_mac);
		if(!pstat) {
			PMFDEBUG("no associated STA (%02x%02x%02x%02x%02x%02x)\n"
										,priv->pmib->dot11StationConfigEntry.deauth_mac[0]
										,priv->pmib->dot11StationConfigEntry.deauth_mac[1]
										,priv->pmib->dot11StationConfigEntry.deauth_mac[2]
										,priv->pmib->dot11StationConfigEntry.deauth_mac[3]
										,priv->pmib->dot11StationConfigEntry.deauth_mac[4]
										,priv->pmib->dot11StationConfigEntry.deauth_mac[5]);
		} else {
			if (pstat && ((pstat->state & (WIFI_SLEEP_STATE | WIFI_ASOC_STATE)) ==
				(WIFI_SLEEP_STATE | WIFI_ASOC_STATE))){
				return;
			}else{	
				del_station(priv, pstat, DEL_STA_SEND_DEAUTH, _RSON_UNSPECIFIED_);
				priv->pmib->dot11StationConfigEntry.pmftest = 0;
			}
		}
	}
#ifdef CONFIG_IEEE80211W_CLI_DEBUG
    else if(priv->pmib->dot11StationConfigEntry.pmftest == 3){			
		panic_printk("%s(%d) issue unicast disassoc\n", __FUNCTION__, __LINE__);
		pstat = get_stainfo(priv, priv->pmib->dot11StationConfigEntry.deauth_mac);
		if(!pstat) {
			panic_printk("%s(%d) no associated STA (%02x%02x%02x%02x%02x%02x)\n", __FUNCTION__, __LINE__
										,priv->pmib->dot11StationConfigEntry.deauth_mac[0]
										,priv->pmib->dot11StationConfigEntry.deauth_mac[1]
										,priv->pmib->dot11StationConfigEntry.deauth_mac[2]
										,priv->pmib->dot11StationConfigEntry.deauth_mac[3]
										,priv->pmib->dot11StationConfigEntry.deauth_mac[4]
										,priv->pmib->dot11StationConfigEntry.deauth_mac[5]);
		} else {
			if (pstat && ((pstat->state & (WIFI_SLEEP_STATE | WIFI_ASOC_STATE)) ==
				(WIFI_SLEEP_STATE | WIFI_ASOC_STATE))){
				return;
			}else{
				issue_disassoc(priv, priv->pmib->dot11StationConfigEntry.deauth_mac, _RSON_UNSPECIFIED_);
				del_station(priv, pstat, DEL_STA_SEND_NONE, _RSON_UNSPECIFIED_);
				priv->pmib->dot11StationConfigEntry.pmftest = 0;
			}
		}
		
	}else if(priv->pmib->dot11StationConfigEntry.pmftest == 4){			
		panic_printk("%s(%d) issue SA Request\n", __FUNCTION__, __LINE__);
		pstat = get_stainfo(priv, priv->pmib->dot11StationConfigEntry.sa_req_mac);
		if(!pstat) {
			panic_printk("%s(%d) no associated STA (%02x%02x%02x%02x%02x%02x)\n", __FUNCTION__, __LINE__
										,priv->pmib->dot11StationConfigEntry.sa_req_mac[0]
										,priv->pmib->dot11StationConfigEntry.sa_req_mac[1]
										,priv->pmib->dot11StationConfigEntry.sa_req_mac[2]
										,priv->pmib->dot11StationConfigEntry.sa_req_mac[3]
										,priv->pmib->dot11StationConfigEntry.sa_req_mac[4]
										,priv->pmib->dot11StationConfigEntry.sa_req_mac[5]);
		} else {
			if (pstat && ((pstat->state & (WIFI_SLEEP_STATE | WIFI_ASOC_STATE)) ==
				(WIFI_SLEEP_STATE | WIFI_ASOC_STATE))){
				return;
			}else{
            if(pstat->sa_query_count == 0) {
                pstat->sa_query_count++;
                panic_printk("sa_query_end=%lu\n", pstat->sa_query_end);
                issue_SA_Query_Req(priv->dev,priv->pmib->dot11StationConfigEntry.sa_req_mac);

                rtk_mod_timer(&pstat->SA_timer, jiffies + RTL_MILISECONDS_TO_JIFFIES(SA_QUERY_RETRY_TO));
					priv->pmib->dot11StationConfigEntry.pmftest = 0;
	            }
            }
		}

	}else if(priv->pmib->dot11StationConfigEntry.pmftest == 5){ // for PMF case 4.4, protect broadcast mgmt frame by BIP
		panic_printk("%s(%d) issue broadcast diassoc\n", __FUNCTION__, __LINE__);
		memcpy(priv->pmib->dot11StationConfigEntry.deauth_mac,"\xff\xff\xff\xff\xff\xff",6);
		issue_disassoc(priv, priv->pmib->dot11StationConfigEntry.deauth_mac, _RSON_UNSPECIFIED_);

		phead = &priv->asoc_list;
		if (netif_running(priv->dev) && !list_empty(phead)) {
		    SMP_LOCK_ASOC_LIST(local_flags);
			plist = phead->next;
			while (plist != phead) {
				pstat = list_entry(plist, struct stat_info, asoc_list);
			    SMP_UNLOCK_ASOC_LIST(local_flags);

				panic_printk("pstat=%pm\n", pstat->cmn_info.mac_addr);
				del_station(priv, pstat, DEL_STA_SEND_NONE, _RSON_UNSPECIFIED_);
			    SMP_LOCK_ASOC_LIST(local_flags);
				plist = phead->next;
			}
		    SMP_UNLOCK_ASOC_LIST(local_flags);
		}
		priv->pmib->dot11StationConfigEntry.pmftest = 0;
    }
#endif
#ifdef CONFIG_IEEE80211V
    else if(WNM_ENABLE && priv->pmib->dot11StationConfigEntry.wnmtest == 1) { 
        process_BssTransReq(priv);
        priv->pmib->dot11StationConfigEntry.wnmtest = 0;
    }
#endif
}
#endif

void update_traffic_mode(struct rtl8192cd_priv *priv)
{
	struct rtl8192cd_priv *tmppriv;
	int i;
	unsigned long long tx_pkts, rx_pkts;
	unsigned long long tx_total_pkts, rx_total_pkts;
	unsigned long long tx_average, rx_average;
	int sta_num;
	
	tx_pkts = (unsigned long long)priv->net_stats.tx_packets;
	tx_total_pkts = UINT64_DIFF(tx_pkts,  priv->tx_packets_prev);
	priv->tx_packets_prev = tx_pkts;
	
	rx_pkts = (unsigned long long)priv->net_stats.rx_packets;
	rx_total_pkts = UINT64_DIFF(rx_pkts,  priv->rx_packets_prev);
	priv->rx_packets_prev = rx_pkts;

	tx_average = priv->ext_stats.tx_avarage;
	rx_average = priv->ext_stats.rx_avarage;
	sta_num = get_assoc_sta_num(priv, 1);

#ifdef MBSSID
	if (GET_ROOT(priv)->pmib->miscEntry.vap_enable) {
		for (i=0; i<RTL8192CD_NUM_VWLAN; ++i) {
			tmppriv = priv->pvap_priv[i];
			if (IS_DRV_OPEN(tmppriv)) {
				tx_pkts = (unsigned long long)tmppriv->net_stats.tx_packets;
				tx_total_pkts += UINT64_DIFF(tx_pkts,  tmppriv->tx_packets_prev);
				tmppriv->tx_packets_prev = tx_pkts;
				
				rx_pkts = (unsigned long long)tmppriv->net_stats.rx_packets;
				rx_total_pkts += UINT64_DIFF(rx_pkts,  tmppriv->rx_packets_prev);
				tmppriv->rx_packets_prev = rx_pkts;

				tx_average += tmppriv->ext_stats.tx_avarage;
				rx_average += tmppriv->ext_stats.rx_avarage;
				sta_num += get_assoc_sta_num(tmppriv, 1);
			}
		}
	}
#endif
#ifdef UNIVERSAL_REPEATER
	tmppriv = GET_VXD_PRIV(priv);
	if (IS_DRV_OPEN(tmppriv)) {
		tx_pkts = (unsigned long long)tmppriv->net_stats.tx_packets;
		tx_total_pkts += UINT64_DIFF(tx_pkts,  tmppriv->tx_packets_prev);
		tmppriv->tx_packets_prev = tx_pkts;
		
		rx_pkts = (unsigned long long)tmppriv->net_stats.rx_packets;
		rx_total_pkts += UINT64_DIFF(rx_pkts,  tmppriv->rx_packets_prev);
		tmppriv->rx_packets_prev = rx_pkts;

		tx_average += tmppriv->ext_stats.tx_avarage;
		rx_average += tmppriv->ext_stats.rx_avarage;
		sta_num += get_assoc_sta_num(tmppriv, 1);
	}
#endif

	if (tx_total_pkts > 100 && tx_total_pkts > (rx_total_pkts << 1)) {
		priv->pshare->traffic_mode = TRAFFIC_MODE_TX;
	} else if (rx_total_pkts > 100 && rx_total_pkts > (tx_total_pkts << 1)) {
		priv->pshare->traffic_mode = TRAFFIC_MODE_RX;
	} else if (rx_total_pkts > 800 && tx_total_pkts > 800) {
		priv->pshare->traffic_mode = TRAFFIC_MODE_BIDIR;
	} else {
		priv->pshare->traffic_mode = 0;
	}

	priv->pshare->total_tp = (unsigned int)(tx_average + rx_average) >> 17;
	priv->pshare->total_sta_num = sta_num;
//	printk("[%s] mode%d (pkt %d, %d)(tp %d, %d)\n",
//		__func__, priv->pshare->traffic_mode, tx_total_pkts, rx_total_pkts, tx_average>>7, rx_average>>7);
}

static void keep_pkts_pre_expire(struct rtl8192cd_priv *priv)
{
	struct stat_info	*pstat;
	struct list_head	*phead, *plist;
#ifdef SMP_SYNC
    unsigned long flags = 0;
#endif

#if defined(UNIVERSAL_REPEATER) || defined(MBSSID)
	if (IS_ROOT_INTERFACE(priv))
#endif
	{
#ifdef CONFIG_VERIWAVE_CHECK
		priv->pshare->check_MACBBTX_counter_pre = priv->pshare->check_MACBBTX_counter;
#endif
		update_all_wifi_txrx_pkts(priv);
		update_traffic_mode(priv);
	}

	phead = &priv->asoc_list;
    
    SMP_LOCK_ASOC_LIST(flags);
    
	plist = phead->next;
	while (plist != phead) {
		pstat = list_entry(plist, struct stat_info, asoc_list);
        plist = plist->next;
        
		pstat->tx_pkts_pre = pstat->tx_pkts;
		pstat->rx_pkts_pre = pstat->rx_pkts;
		pstat->tx_fail_pre2 = pstat->tx_fail_pre;
		pstat->tx_fail_pre = pstat->tx_fail;
		pstat->tx_pkts2_pre2 = pstat->tx_pkts2_pre;
		pstat->tx_pkts2_pre = pstat->tx_pkts2;
//#ifdef CONFIG_VERIWAVE_CHECK
		pstat->tx_big_pkts_pre = pstat->tx_big_pkts;
		pstat->tx_sml_pkts_pre = pstat->tx_sml_pkts;
//#endif
		pstat->rx_pkts2_pre2 = pstat->rx_pkts2_pre;
		pstat->rx_pkts2_pre = pstat->rx_pkts2;
		pstat->tcpack_pkts_pre = pstat->tcpack_pkts;
	}

    SMP_UNLOCK_ASOC_LIST(flags);
}

void rtl8192cd_expire_timer(unsigned long task_priv)
{
	int run = 0;

	struct rtl8192cd_priv *priv = (struct rtl8192cd_priv *)task_priv;
#ifndef SMP_SYNC
	unsigned long	flags=0;
#endif
    int somevapopened=0;
#if defined(MBSSID) || defined(DOT11K)
	int i;
#endif
	int index;
#ifdef CH_LOAD_CAL
	unsigned int clm_count=0;
	unsigned int channel_utilization=0;
#endif	
	if (!(priv->drv_state & DRV_STATE_OPEN))
		return;

	SAVE_INT_AND_CLI(flags);
	SMP_LOCK(flags);

#ifdef MULTI_MAC_CLONE
	ACTIVE_ID = 0;
#endif

	// advance driver up timer
	priv->up_time++;

#ifdef TLN_STATS
	if (priv->pshare->rf_ft_var.stats_time_interval) {
		if (priv->stats_time_countdown) {
			priv->stats_time_countdown--;
		} else {
			memset(&priv->wifi_stats, 0, sizeof(struct tln_wifi_stats));
			memset(&priv->ext_wifi_stats, 0, sizeof(struct tln_ext_wifi_stats));

			priv->stats_time_countdown = priv->pshare->rf_ft_var.stats_time_interval;
		}
	}
#endif

#ifdef	INCLUDE_WPS
	// mount wsp wps_1sec_routine
#if defined(UNIVERSAL_REPEATER) || defined(MBSSID)
	if (IS_ROOT_INTERFACE(priv))
#endif
	{

#ifndef CONFIG_MSC		// for verify
		if(priv->pshare->WSC_CONT_S.RdyGetConfig == 0){
			// if not get config from upnp yet ; send request		
			unsigned char tmp12[20];
			snprintf(tmp12, sizeof(tmp12), "wps_get_config=1");
			set_mib(priv , tmp12) ;	
		}
#endif			
		if(priv->pshare->WSC_CONT_S.oneSecTimeStart){
			wps_1sec_routine(priv);
		}
        else{
            printk("%s %d not enter wsc 1sec \n", __FUNCTION__, __LINE__);
        }
	}
#endif


#ifdef PCIE_POWER_SAVING
	if ((priv->pwr_state == L2) || (priv->pwr_state == L1)) {
		SMP_UNLOCK(flags);
		RESTORE_INT(flags);
		return;
	}
#endif
#ifdef PCIE_POWER_SAVING_TEST //yllin
    if((priv->pwr_state >= L2) || (priv->pwr_state == L1)) {
        SMP_UNLOCK(flags);
		RESTORE_INT(flags);
        return;
    }
#endif


#ifdef CONFIG_RTK_MESH
    if ((GET_MIB(priv)->dot1180211sInfo.mesh_enable == 1 )
#if defined(UNIVERSAL_REPEATER) || defined(MBSSID)
        && IS_ROOT_INTERFACE(priv)
#endif
        && netif_running(priv->mesh_dev)

    ) {
        if( priv->mesh_log )	// advance flow log timer Throughput statistics (sounder)
            priv->log_time++;

        mesh_expire(priv);
    }

#ifdef RTK_MESH_SIMPLE_CSA
	mesh_CSA_expire(priv);
#endif
#endif	// DOT11_MESH_MODE_

#ifdef AUTH_SAE
	if(priv->sae_peer_table)
		sae_peer_table_expire(priv);
#endif

	// check delsta_list
	delsta_expire(priv);

	// check auth_list
	auth_expire(priv);

#if defined(RTK_MULTI_AP)
	if (IS_ROOT_INTERFACE(priv)) {
		if(priv->pmib->miscEntry.vap_enable){
			for (i=0; i<RTL8192CD_NUM_VWLAN; i++) {
				if (IS_DRV_OPEN(priv->pvap_priv[i]) && priv->pvap_priv[i]->pmib->miscEntry.func_off) {
					rtk_multi_ap_terminateBackhaulApConnection(priv->pvap_priv[i]);
				}
			}
		}
#if (EASYMESH_VERSION >= MULTI_AP_VERSION(2,0,0))
		if (GET_MAP_PROFILE(priv) >= MAP_PROFILE_TWO) {
			if (priv->multiap_last_assoc_disallowed_status != priv->pmib->multi_ap.multiap_assoc_disallowed_status) {
				priv->multiap_last_assoc_disallowed_status = priv->pmib->multi_ap.multiap_assoc_disallowed_status;
				rtk_multi_ap_trigger_association_status_notification(BSSID, !priv->multiap_last_assoc_disallowed_status);
			}
		}
#endif
	}
	// if(IS_VAP_INTERFACE(priv) && priv->pmib->miscEntry.func_off)
		// rtk_multi_ap_terminateBackhaulApConnection(priv);
#if defined(UNIVERSAL_REPEATER)
	if(IS_VXD_INTERFACE(priv) && priv->pmib->miscEntry.func_off)
		rtk_multi_ap_terminateBackhaulStaConnection(priv);
#endif
#endif

#if defined(UNIVERSAL_REPEATER) || defined(MBSSID)
	if (IS_ROOT_INTERFACE(priv))
#endif
	{
		if ((priv->up_time % 2) == 0) {
			priv->pshare->highTP_found_pstat = NULL;
			priv->pshare->highTP_found_root_pstat = NULL;
			priv->pshare->highTP_found_vxd_pstat = NULL;
#ifdef CONFIG_WLAN_HAL_8814AE
			if(GET_CHIP_VER(priv) == VERSION_8814A)
				priv->pshare->th_mode = 0;
#endif
		}
		priv->pshare->rssi_min = 0xff;
		priv->pshare->mimorssi_min= 0xff;
		
#ifdef RSSI_MIN_ADV_SEL
		priv->pshare->min_rssi_data_cnt = 0;
#endif
#ifdef CLIENT_MODE		
		if((OPMODE & WIFI_ADHOC_STATE) && (priv->prev_tsf)) {
			UINT64		tsf, tsf_diff;
			tsf = RTL_R32(TSFTR+4);
			tsf = (tsf<<32) +  RTL_R32(TSFTR);
			tsf_diff = tsf - priv->prev_tsf;
			priv->prev_tsf = tsf;
			if( (tsf > priv->prev_tsf) && (tsf_diff > BIT(24))) {
#ifndef __OSK__
				tsf = cpu_to_le64(tsf);
#endif
				memcpy(priv->rx_timestamp, (void*)(&tsf), 8);				
				updateTSF(priv);
			}			
		}		
#endif		
	}

#ifdef RX_CRC_EXPTIMER
#if defined(CONFIG_WLAN_HAL_8814AE) || defined(CONFIG_WLAN_HAL_8197F) || defined(CONFIG_WLAN_HAL_8198F)
	if(GET_CHIP_VER(priv) == VERSION_8814A || GET_CHIP_VER(priv) == VERSION_8197F|| GET_CHIP_VER(priv) == VERSION_8198F) {
		if(priv->pshare->rf_ft_var.crc_enable || priv->pshare->rf_ft_var.crc_dump || priv->pshare->rf_ft_var.mp_specific)
			RTL_W16(0x608, RTL_R16(0x608) | BIT(8));
		else
			RTL_W16(0x608, RTL_R16(0x608) & ~BIT(8));
	}
#endif
#endif

#ifdef RTK_ATM
	// 1. if atm_mode = 4, check the pre-set client list 
	// 	and accumulate all sta_time in client list and asign client sta_time to atm_match_sta_time
	if(IS_ROOT_INTERFACE(priv)) //&& priv->pshare->rf_ft_var.atm_en)
	{		
		//if atm_mode=2 client mode, check matched client first
		//if(priv->pshare->atm_ttl_stanum > 0)
		if(priv->pshare->rf_ft_var.atm_en)
			atm_check_statime(priv);
	}
#endif

#if (MU_BEAMFORMING_SUPPORT == 1)
PRT_BEAMFORMING_INFO	pBeamInfo = &(priv->pshare->BeamformingInfo);

#if defined(CONFIG_WLAN_HAL_8822BE) || defined(CONFIG_WLAN_HAL_8812FE)
			if (GET_CHIP_VER(priv) == VERSION_8822B || GET_CHIP_VER(priv) == VERSION_8812F) {
				unsigned int Reg7D4 = RTL_R8(0x7d4);				
				if (pBeamInfo->beamformee_mu_reg_maping && (Reg7D4 & BIT3)) {
					Reg7D4 &= ~BIT3;
					RTL_W8(0x7d4, Reg7D4);
				} else if (!pBeamInfo->beamformee_mu_reg_maping && (Reg7D4 & BIT3)==0) {					
					Reg7D4 |= BIT3;
					RTL_W8(0x7d4, Reg7D4);
				}

	if (priv->pshare->rf_ft_var.mu_dump && !(priv->up_time % priv->pshare->rf_ft_var.mu_dump)) {
		int i;
		PRT_BEAMFORMING_ENTRY	pEntry = NULL;
		struct stat_info	*pstat;
		
		char strMuRate[20];
		unsigned char e1e2_to_gid[MAX_NUM_BEAMFORMEE_MU][MAX_NUM_BEAMFORMEE_MU]={{2,2,4,6,8,10},
  							{1,1,12,14,16,18},
  							{3,11,20,20,22,24},
  							{5,13,19,19,26,28},
  							{7,15,21,25,25,30},
  							{9,17,23,27,29,29}};
		u1Byte partnerIndex, groupIndex;
		
		for(i = 0; i < BEAMFORMEE_ENTRY_NUM; i++) {
			pEntry = &(pBeamInfo->BeamformeeEntry[i]);
			if( pEntry->bUsed && (pEntry->is_mu_sta == TXBF_TYPE_MU) && pEntry->priv == priv) {		
				pstat = pEntry->pSTA;
				if(pstat) {					
						if(pstat->muPartner_num) {						
						groupIndex = e1e2_to_gid[pEntry->mu_reg_index][priv->pshare->rf_ft_var.muPairResult[pEntry->mu_reg_index]] - 1;
						pEntry->mu_tx_rate = ODMPTR->dm_ra_table.mu1_rate[groupIndex];
						pEntry->pSTA->mu_rate = ODMPTR->dm_ra_table.mu1_rate[groupIndex];
					}
						
					translate_txforce_to_rateStr(strMuRate, (0x7f & pEntry->mu_tx_rate));
					
					panic_printk("[%d][P %d][SND %d %d] %s (H Corr %2x)(MU TX %s) (CSI %d %d) (TP %3d,%3d)\n", 
					   pstat->cmn_info.aid, 
						   (pstat->muPartner[0])?pstat->muPartner[0]->cmn_info.aid:0, 
					   priv->pshare->rf_ft_var.mu_ok[pEntry->mu_reg_index], 
					   priv->pshare->rf_ft_var.mu_fail[pEntry->mu_reg_index], 
					   show_sta_trx_rate(priv, pstat), 
					   RTL_R8(0x2f14),
					   strMuRate,
					   priv->pshare->rf_ft_var.mu_BB_ok, 
					   priv->pshare->rf_ft_var.mu_BB_fail, 
					   (unsigned int)(pstat->tx_avarage>>17),
					   (unsigned int)(pstat->rx_avarage>>17)
					   );
				}
			}
		}		
	}
	}
#elif defined(CONFIG_WLAN_HAL_8814BE)
				if (GET_CHIP_VER(priv) == VERSION_8814B) {
					unsigned int Reg7D4 = RTL_R8(0x7d4);
					if (pBeamInfo->beamformee_mu_reg_maping && (Reg7D4 & BIT3)) {
						Reg7D4 &= ~BIT3;
						RTL_W8(0x7d4, Reg7D4);
					} else if (!pBeamInfo->beamformee_mu_reg_maping && (Reg7D4 & BIT3) == 0) {
						Reg7D4 |= BIT3;
						RTL_W8(0x7d4, Reg7D4);
					}
#if 0
        if (pBeamInfo->beamformee_mu_cnt >= 2) {
            RTL_W16(0x50a, 0x138);
        }
#endif        
			
		if ((pBeamInfo->beamformee_mu_cnt >= 2) && priv->pshare->rf_ft_var.force_mu) {
			unsigned long reg14c0 = RTL_R32(0x14c0) & ~BIT(28);
			if ((priv->ext_stats.tx_avarage>>17) > priv->pshare->rf_ft_var.force_mutp_th)
				RTL_W32(0x14c0, reg14c0);
			else
				RTL_W32(0x14c0, reg14c0 | BIT(28));
		}
		
					if (priv->pshare->rf_ft_var.mu_dump && !(priv->up_time % priv->pshare->rf_ft_var.mu_dump)) {
						int i;
						PRT_BEAMFORMING_ENTRY	pEntry = NULL;
						struct stat_info	*pstat;
			
						char strMuRate[20];
						u1Byte partnerIndex, groupIndex;
			
						for (i = 0; i < BEAMFORMEE_ENTRY_NUM; i++) {
							pEntry = &(pBeamInfo->BeamformeeEntry[i]);
							if (pEntry->bUsed && (pEntry->is_mu_sta == TXBF_TYPE_MU) && pEntry->priv == priv) {
								pstat = pEntry->pSTA;
								if (pstat) {
									if (pstat->muPartner_num) {
										groupIndex = pEntry->mu_rate_index;
										pEntry->mu_tx_rate = ODMPTR->dm_ra_table.mu1_rate[groupIndex];
										pEntry->pSTA->mu_rate = ODMPTR->dm_ra_table.mu1_rate[groupIndex];
									}

									translate_txforce_to_rateStr(strMuRate, (0x7f & pEntry->mu_tx_rate));
			
									panic_printk("[%d][P %d][SND %d %d] %s (MU TX %s) (CSI %d %d) (TP %3d,%3d)\n",
										pstat->cmn_info.aid,
										(pstat->muPartner[0])?pstat->muPartner[0]->cmn_info.aid:0,
										priv->pshare->rf_ft_var.mu_ok[pEntry->mu_reg_index],
										priv->pshare->rf_ft_var.mu_fail[pEntry->mu_reg_index],
										show_sta_trx_rate(priv, pstat),
										strMuRate,
										priv->pshare->rf_ft_var.mu_BB_ok,
										priv->pshare->rf_ft_var.mu_BB_fail,
										(unsigned int)(pstat->tx_avarage>>17),
										(unsigned int)(pstat->rx_avarage>>17)
									);
								}
							}
						}
					}

					if (priv->pshare->rf_ft_var.mu_dump_snr && !(priv->up_time % priv->pshare->rf_ft_var.mu_dump_snr)) {
						int i, j, k;
						PRT_BEAMFORMING_ENTRY	pEntry = NULL, pPartner = NULL;
						struct stat_info	*pstat;
						char strMuRate[20];
						u1Byte partnerIndex, groupIndex;
						u4Byte enc_idx, snr34_off, sta_ant, mudbg_cnt;
			
						unsigned long snr_addr2[4][4] = {
							{0x0, 0x2f10, 0x2f14, 0x2f18},
							{0x2f1c, 0x0, 0x2f20, 0x2f24},
							{0x2f28, 0x2f2c, 0x0, 0x2f30},
							{0x2f34, 0x2f38, 0x2f3c, 0x0}
						};
						unsigned long snr_encode34[] = {
							234, 235, 245,
							324, 325, 345,
							423, 425, 435,
							523, 524, 534,
							2345, 3245, 4235, 5234
						};
						unsigned long snr_addr34[] = {
							0x2f40, 0x2f44, 0x2f48,
							0x2f4c, 0x2f50, 0x2f54,
							0x2f58, 0x2f5c, 0x2f60,
							0x2f64, 0x2f68, 0x2f6c,
							0x2f70, 0x2f74, 0x2f78, 0x2f7c
						};

						if (pBeamInfo->beamformee_mu_cnt >= 2) {
							mudbg_cnt = RTL_R16(0x14dc);
							RTL_W8(0x14de, RTL_R8(0x14de) | BIT(4));
						}
						
						for (i = 0; i < BEAMFORMEE_ENTRY_NUM; i++) {
							pEntry = &(pBeamInfo->BeamformeeEntry[i]);
							if (pEntry->bUsed && (pEntry->is_mu_sta == TXBF_TYPE_MU) && pEntry->priv == priv) {
								pstat = pEntry->pSTA;
								if (pstat && pstat->muPartner_num) {
									groupIndex = pEntry->mu_rate_index;
									pEntry->mu_tx_rate = ODMPTR->dm_ra_table.mu1_rate[groupIndex];
									pEntry->pSTA->mu_rate = ODMPTR->dm_ra_table.mu1_rate[groupIndex];

									translate_txforce_to_rateStr(strMuRate, (0x7f & pEntry->mu_tx_rate));
									
									if (pstat->muPartner_num == 1) {
										sta_ant = (get_sta_vht_mimo_mode(pstat) == RF_1T1R) ? 0 : 1;
										
										partnerIndex = 0xff;
										for (j = 0; j < BEAMFORMEE_ENTRY_NUM; j++) {
											pPartner = &(pBeamInfo->BeamformeeEntry[j]);
											if (pPartner->bUsed && pPartner->pSTA && pPartner->pSTA == pstat->muPartner[0]) {
												partnerIndex = pPartner->mu_reg_index;
												break;
											}
										}

										if (partnerIndex != 0xff) {
											panic_printk("[%d] (%d-%d %3d %3d) %s (MU TX %s) (TP %3d,%3d) (DBG %d)\n",
												pstat->cmn_info.aid,
												pEntry->mu_reg_index + 2, partnerIndex + 2,
												RTL_R8(snr_addr2[pEntry->mu_reg_index][partnerIndex] + (2 * sta_ant)) >> 4,
												RTL_R8(snr_addr2[pEntry->mu_reg_index][partnerIndex] + (2 * sta_ant) + 1),
												show_sta_trx_rate(priv, pstat),
												strMuRate,
												(unsigned int)(pstat->tx_avarage>>17),
												(unsigned int)(pstat->rx_avarage>>17),
												mudbg_cnt
											);
										}
									}
									else {
										enc_idx = pEntry->mu_reg_index + 2;

										panic_printk("[%d] ", pstat->cmn_info.aid);
										for (j = 0; j < pstat->muPartner_num; j++) {
											for (k = 0; k < BEAMFORMEE_ENTRY_NUM; k++) {
												pPartner = &(pBeamInfo->BeamformeeEntry[k]);
												if (pPartner->bUsed && pPartner->pSTA && pPartner->pSTA == pstat->muPartner[j]) {
													enc_idx = (enc_idx * 10) + pPartner->mu_reg_index + 2;

													panic_printk("(%d-%d %3d %3d) ", 
														pEntry->mu_reg_index + 2, pPartner->mu_reg_index + 2,
														RTL_R8(snr_addr2[pEntry->mu_reg_index][pPartner->mu_reg_index]) >> 4,
														RTL_R8(snr_addr2[pEntry->mu_reg_index][pPartner->mu_reg_index] + 1)
													);
													break;
												}
											}
										}
										if (pstat->muPartner_num == 2)
											panic_printk("(5-3-4 %3d %3d) ", 
												RTL_R8(0x2f6c) >> 4,
												RTL_R8(0x2f6c + 1)
											);
										else
											panic_printk("(5-2-3-4 %3d %3d) ",
												RTL_R8(0x2f7c) >> 4,
												RTL_R8(0x2f7c + 1)
											);
											
										panic_printk("%s (MU TX %s) (TP %3d,%3d) (DBG %d)\n",
											show_sta_trx_rate(priv, pstat),
											strMuRate,
											(unsigned int)(pstat->tx_avarage>>17),
											(unsigned int)(pstat->rx_avarage>>17),
											mudbg_cnt
										);
									}
								}
							}
						}
					}
				}
#endif
#if defined(CONFIG_WLAN_HAL_8812FE)		
		if (GET_CHIP_VER(priv) == VERSION_8812F && priv->pmib->dot11RFEntry.txbf_mu){
			char num_mu_valid_sta= 0, i;
			char tmp  = 0x3F & RTL_R8(0x14c0);
			//count # valid mu sta.
			for(i = 0; i < 6; i++) {	
				if(tmp & BIT(i)){
					num_mu_valid_sta++;
				}
			}
			if(num_mu_valid_sta >= 2){
				if(0x0 == RTL_R8(0x2f14)){ 
					RTL_W32(0xb2c, 0xafffafff);
				}else{
					RTL_W32(0xb2c, 0x3a0c3a0c);
				}
			}
			//dynamically lower power on band 4 mu-mimo 
			if(priv->pmib->dot11RFEntry.dot11channel>=149 && priv->pmib->dot11RFEntry.mu_low_pwr_en) {
				if( !priv->pshare->lowerPwr_8812F_MU && 
					priv->pshare->isSTAGrp && priv->pshare->isSTAGrp_pre){				
					char *tmp = "all=-12";
					set_reg_pg( priv, tmp);
						priv->pshare->lowerPwr_8812F_MU = 1;
					//printk("[LowerPwr_8812F_MU] set to 1 !!!\n");				
				}else if( priv->pshare->lowerPwr_8812F_MU && 
					!priv->pshare->isSTAGrp && !priv->pshare->isSTAGrp_pre){				
					char *tmp = "all=12";
					set_reg_pg( priv, tmp);
						priv->pshare->lowerPwr_8812F_MU = 0;
					//printk("[LowerPwr_8812F_MU] set to 0  !!! \n");				
			}
				priv->pshare->isSTAGrp_pre = priv->pshare->isSTAGrp;
			}
		}
#endif
		
#endif

#ifdef ADAPTIVITY_STATS_DEBUG
#if defined(UNIVERSAL_REPEATER) || defined(MBSSID)
	if (IS_ROOT_INTERFACE(priv))
#endif
	if (priv->pshare->rf_ft_var.adaptivity_enable)
		adaptivity_stats_check(priv);
#endif

#ifdef CONFIG_SPECIAL_ENV_TEST
	if (priv->pshare->spirent_sta_num == priv->pshare->rf_ft_var.spec_latency_sta_num) {
		priv->pshare->spec_env_latency_test = 1;
	} else if (priv->pshare->veriwave_sta_num == priv->pshare->rf_ft_var.spec_latency_sta_num) {
		priv->pshare->spec_env_latency_test = 1;
	} else {
		priv->pshare->spec_env_latency_test = 0;
	}
#endif

	// check asoc_list
#ifndef AP_SWPS_OFFLOAD_VERI
	assoc_expire(priv);
#endif

#if defined(WIFI_WMM) && defined(WIFI_QOS_ENHANCE)
	qos_enhance_proc(priv);
#endif

#ifdef SW_TX_QUEUE
	if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE) {
		if (priv->pshare->rf_ft_var.totaltp  && !(priv->up_time % priv->pshare->rf_ft_var.totaltp)) {
			panic_printk("totaltp (%d %d) drop(%lu) fail(%llu) SWQ(%lu %lu %lu %lu)\n", 
					(unsigned int)(priv->ext_stats.tx_avarage>>17), (unsigned int)(priv->ext_stats.rx_avarage>>17),  
					priv->ext_stats.tx_drops, priv->net_stats.tx_errors, 
					priv->ext_stats.swq_enque_pkt, priv->ext_stats.swq_xmit_out_pkt, priv->ext_stats.swq_residual_drop_pkt, priv->ext_stats.swq_overflow_drop_pkt);
	    }
	}
#endif	
#if defined(DRVMAC_LB) && defined(WIFI_WMM)
	if (priv->pmib->miscEntry.drvmac_lb && priv->pmib->miscEntry.lb_tps) {
		unsigned int i = 0;
		for (i = 0; i < priv->pmib->miscEntry.lb_tps; i++) {
			if (priv->pmib->miscEntry.lb_mlmp)
				SendLbQosData(priv);
			else
				SendLbQosNullData(priv);
		}
	}
#endif

#ifdef WIFI_SIMPLE_CONFIG
	// check wsc probe request list
	if (priv->pmib->wscEntry.wsc_enable & 2) // work as AP (not registrar)
		wsc_probe_expire(priv);
	wsc_disconn_list_expire(priv);
#endif

#ifdef WDS
	if ((OPMODE & WIFI_AP_STATE) && priv->pmib->dot11WdsInfo.wdsEnabled &&
		priv->pmib->dot11WdsInfo.wdsNum){
		wds_probe_expire(priv);		
	}
#endif

	// check link status and start/stop net queue
	priv->link_status = chklink_wkstaQ(priv);

#if defined(__ECOS) && defined(CONFIG_SDIO_HCI)
#ifdef CLIENT_MODE
	if (OPMODE & WIFI_STATION_STATE) {
		if (priv->link_status != priv->link_status_bak) {
			//WIFI_LINK_STATUS_CONNECTED or WIFI_LINK_STATUS_DISCONNECTED
#ifdef P2P_SUPPORT	
			if ((priv->link_status == WIFI_LINK_STATUS_CONNECTED) &&
			    rtk_p2p_is_enabled(priv) &&  rtk_p2p_chk_role(priv,P2P_CLIENT))
				priv->p2pPtr->clientmode_connected = 1;
#endif
			if (priv->link_status_cb_func)
				priv->link_status_cb_func("wlan0", priv->link_status);
		}
	}
#endif
	priv->link_status_bak = priv->link_status;

#ifdef P2P_SUPPORT
	if (rtk_p2p_is_enabled(priv) &&  rtk_p2p_chk_role(priv,P2P_TMP_GO) &&
	     (priv->assoc_num_bak) && (priv->assoc_num == 0)) {
		if (priv->p2p_event_indicate_cb_func)
			priv->p2p_event_indicate_cb_func("wlan0", WIFI_P2P_EVENT_BACK2DEV);
	}
#endif
	priv->assoc_num_bak = priv->assoc_num;
#endif

#ifdef RTK_AC_SUPPORT //for 11ac logo
	// channel switch
	if(priv->pshare->rf_ft_var.csa) {
		int ch = priv->pshare->rf_ft_var.csa;
		priv->pshare->rf_ft_var.csa = 0;
		
		GET_ROOT(priv)->pmib->dot11DFSEntry.DFS_detected = 1;
		priv->pshare->dfsSwitchChannel = ch;
		priv->pshare->dfsSwitchChCountDown = 6;
#if defined(RTK_MULTI_AP) && defined(RTK_MULTI_AP_R1_DFS)
		priv->pshare->dfsSwitchChCountDown = MULTI_AP_DFS_COUNTDOWN;
#endif
		if (priv->pmib->dot11StationConfigEntry.dot11DTIMPeriod >= priv->pshare->dfsSwitchChCountDown)
			priv->pshare->dfsSwitchChCountDown = priv->pmib->dot11StationConfigEntry.dot11DTIMPeriod+1;
	}
#endif

	// for SW LED
	if ((LED_TYPE >= LEDTYPE_SW_LINK_TXRX) && (LED_TYPE < LEDTYPE_SW_MAX))
	{
#if defined(UNIVERSAL_REPEATER) || defined(MBSSID)
		if (IS_ROOT_INTERFACE(priv))
#endif
#ifdef PCIE_POWER_SAVING
		if ((priv->pwr_state != L1) && (priv->pwr_state != L2))
#endif
			if (LED_TYPE != LEDTYPE_SW_LED_DO_NOTHING)
				calculate_sw_LED_interval(priv);
	}

#ifdef CONFIG_RTL_88E_SUPPORT
	if (GET_CHIP_VER(priv)!=VERSION_8188E)
#endif
	{
#ifdef CLIENT_MODE
		if (((OPMODE & WIFI_AP_STATE) ||
			((OPMODE & WIFI_ADHOC_STATE) &&
				((JOIN_RES == STATE_Sta_Ibss_Active) || (JOIN_RES == STATE_Sta_Ibss_Idle)))) &&
			(priv->pmib->dot11BssType.net_work_type & WIRELESS_11G))
#else
		if ((OPMODE & WIFI_AP_STATE) &&
			(priv->pmib->dot11BssType.net_work_type & WIRELESS_11G))
#endif
		{
			if (priv->pmib->dot11ErpInfo.olbcDetected) {
				if (priv->pmib->dot11ErpInfo.olbcExpired > 0)
					priv->pmib->dot11ErpInfo.olbcExpired--;

				if (priv->pmib->dot11ErpInfo.olbcExpired == 0) {
					priv->pmib->dot11ErpInfo.olbcDetected = 0;
					DEBUG_INFO("OLBC expired\n");
					check_protection_shortslot(priv);
				}
			}
		}
	}

#ifdef TX_EARLY_MODE
	priv->pshare->em_tx_byte_cnt  = priv->ext_stats.tx_byte_cnt;
#endif

#if !defined(CONFIG_RTK_SOC_RTL8198D) && defined(CONFIG_RTL9607C) && defined(CONFIG_RTL_OFFLOAD_DRIVER)
#ifdef DYNAMIC_CPU_ARRANGEMENT
{
extern int wifi_event_send_rxDistribute(int disableRxDistribute);

    if (OFFLOAD_ENABLE(priv) && (priv->pmib->dot11RFEntry.phyBandSelect & PHY_BAND_5G)) {
        if (!priv->tx_cpu_turbo && ((priv->ext_stats.tx_byte_cnt >> 17) > 10)) {
            priv->tx_cpu_turbo = 1;
            wifi_event_send_rxDistribute(priv->tx_cpu_turbo);
        }
        else if (priv->tx_cpu_turbo && ((priv->ext_stats.tx_byte_cnt >> 17) <= 10)) {
            priv->tx_cpu_turbo = 0;
            wifi_event_send_rxDistribute(priv->tx_cpu_turbo);
        }
    }
}
#endif
#endif

	// calculate tx/rx throughput
	priv->ext_stats.tx_avarage = (priv->ext_stats.tx_avarage/10)*7 + (priv->ext_stats.tx_byte_cnt/10)*3;
	priv->ext_stats.tx_byte_cnt = 0;
	priv->ext_stats.rx_avarage = (priv->ext_stats.rx_avarage/10)*7 + (priv->ext_stats.rx_byte_cnt/10)*3;
	priv->ext_stats.rx_byte_cnt = 0;

#ifdef RTK_MULTI_AP
	if(priv->pmib->multi_ap.multiap_cu_threshold != 0){
		rtk_multi_ap_ch_util_trigger(priv);
	}
#if 1
#ifdef CONFIG_IEEE80211V
	if(priv->pmib->multi_ap.multiap_steering_policy){
		rtk_multi_ap_agent_steering_trigger(priv);
	}
#endif
#endif
#endif

#if defined(TXRETRY_CNT) || defined(CH_LOAD_CAL)
	per_sta_cal(priv);
#endif

#if defined(CROSSBAND_REPEATER) || defined(RTK_MESH_METRIC_REFINE)
	//Retrieve channel utilization info
	priv->envinfo.info_record[priv->envinfo.index].cu_value = priv->ext_stats.ch_utilization;
#endif

#ifdef CROSSBAND_REPEATER
	if(IS_ROOT_INTERFACE(priv) && IS_DRV_OPEN(GET_VXD_PRIV(priv)))
	{
		struct stat_info *crossband_pstat;

		//Retrieve RSSI info
		crossband_pstat = get_stainfo(GET_VXD_PRIV(priv),GET_VXD_PRIV(priv)->pmib->dot11Bss.bssid);
		if(crossband_pstat){ //virtual interface associated
			priv->envinfo.info_record[priv->envinfo.index].rssi_value = crossband_pstat->rssi;
			priv->pmib->crossBand.crossband_assoc = 1;
		}
		else{
			priv->envinfo.info_record[priv->envinfo.index].rssi_value = 0;		
			priv->pmib->crossBand.crossband_assoc = 0;
		}

		//Update association status of both virtual interface, both required to have valid switch path
		if(priv->pmib->crossBand.crossband_assoc
			&& priv->crossband.crossband_priv_sc->pmib->crossBand.crossband_assoc)
			priv->pmib->crossBand.crossband_pathReady = 1;
		else
			priv->pmib->crossBand.crossband_pathReady = 0;
	}
#endif

#ifdef RTK_NL80211
#if 0 //brian, collect channel load information during sitesurvey in stead of here to make sure freshness
	//survey_dump
	int val = read_bbp_ch_load(priv);
	if(val != -1)
	{
		priv->rtk->chbusytime = (val/1000)*5;
		start_bbp_ch_load(priv);
	}
	check_sta_throughput(priv);
#endif
	//openwrt_psd
	if(priv->rtk->psd_chnl != 0)
		rtl8192cd_query_psd_cfg80211(priv, priv->rtk->psd_chnl, priv->rtk->psd_bw, priv->rtk->psd_pts);
	priv->rtk->psd_chnl=0;
	priv->rtk->psd_bw=0;
	priv->rtk->psd_pts=0;
#endif

#ifdef CONFIG_RTL8190_THROUGHPUT
#if defined(UNIVERSAL_REPEATER) || defined(MBSSID)
	if (IS_ROOT_INTERFACE(priv))
#endif
	{
		unsigned long throughput;

		throughput = (priv->ext_stats.tx_avarage + priv->ext_stats.rx_avarage) * 8 / 1024 / 1024; /* unit: Mbps */
		if (gCpuCanSuspend) {
			if (throughput > TP_HIGH_WATER_MARK) {
				gCpuCanSuspend = 0;
			}
		}
		else {
			if (throughput < TP_LOW_WATER_MARK) {
				gCpuCanSuspend = 1;
			}
		}
#if defined(CONFIG_RTL_8812_SUPPORT) || defined(CONFIG_RTL_8723B_SUPPORT)
	if(GET_CHIP_VER(priv)== VERSION_8812E || GET_CHIP_VER(priv)== VERSION_8723B) {            
        if( (((priv->ext_stats.tx_avarage+priv->ext_stats.rx_avarage) * 8)/1024)/1024 > 50 )	//when TH > 50Mbps
		{
            if(!priv->bIntMigration){    
                //RTL_W32(REG_INT_MIG_8812,0x30300000);
                RTL_W16(REG_PCIE_MULTIFET_CTRL_8812,0xF450);            
                priv->bIntMigration=1;
                //SDEBUG("bIntMigration=1\n");
            }
        }else{
            if(priv->bIntMigration){
                //RTL_W32(REG_INT_MIG_8812,0);
                RTL_W16(REG_PCIE_MULTIFET_CTRL_8812,0);
                priv->bIntMigration=0;
                //SDEBUG("bIntMigration=0\n");
            }            
        }
	}
#endif
	}
#endif

#if defined(CONFIG_RTL8196B_TR) || defined(CONFIG_RTL8196C_EC)
	if (priv->ext_stats.tx_avarage > priv->ext_stats.tx_peak)
		priv->ext_stats.tx_peak = priv->ext_stats.tx_avarage;

	if (priv->ext_stats.rx_avarage > priv->ext_stats.rx_peak)
		priv->ext_stats.rx_peak = priv->ext_stats.rx_avarage;
#endif
//#ifdef CONFIG_RTL865X_AC
#if defined(CONFIG_RTL865X_AC) || defined(CONFIG_RTL865X_KLD) || defined(CONFIG_RTL8196B_KLD) || defined(CONFIG_RTL8196C_KLD)
	if (priv->ext_stats.tx_avarage > priv->ext_stats.tx_peak)
		priv->ext_stats.tx_peak = priv->ext_stats.tx_avarage;

	if (priv->ext_stats.rx_avarage > priv->ext_stats.rx_peak)
		priv->ext_stats.rx_peak = priv->ext_stats.rx_avarage;
#endif

#ifdef CLIENT_MODE
	if (OPMODE & (WIFI_STATION_STATE | WIFI_ADHOC_STATE))
	{

		// calculate how many beacons we received and decide if should roaming
#ifdef DFS
		if (!priv->pshare->dfsSwCh_ongoing)
#endif
			calculate_rx_beacon(priv);

#ifdef RTK_BR_EXT
		// expire NAT2.5 entry
		nat25_db_expire(priv);

		if (priv->pppoe_connection_in_progress > 0)
			priv->pppoe_connection_in_progress--;
#endif
	}
#endif

#ifdef STA_CONTROL
    if(priv->stactrl.stactrl_status
#ifdef RTK_MULTI_AP
        && priv->pmib->multi_ap.multiap_steering_policy
		&& !(IS_VAP_INTERFACE(priv) && (priv->vap_id==0) && priv->pmib->miscEntry.a4_enable)
#endif
    ) { /*band steering enabled*/
        stactrl_expire(priv);

#ifdef STA_CONTROL_BAND_TRANSITION
		if (priv->pmib->staControl.stactrl_band_transit) {
			// Find STAs to conduct band transition
			stactrl_band_transition(priv);
		}
#endif
	}
#endif

#ifdef CONFIG_RTK_WLAN_MANAGER
	if ((OPMODE & WIFI_AP_STATE) && priv->up_time % 2 == 0) {
		rtk_wlan_manager_nl_send_intf_rpt_msg(priv);
		rtk_wlan_manager_nl_send_time_tick_msg(priv);
	}
#endif

#ifdef CONFIG_RTK_BAND_STEERING
	if ((OPMODE & WIFI_AP_STATE) && priv->up_time % 2 == 0)
		_band_steering_expire(priv);
#endif

#ifdef RTK_SMART_ROAMING
	smart_roaming_block_expire(priv, NULL);
	smart_roaming_csa_expire_check(priv);
#endif

#ifdef A4_STA
    a4_sta_expire(priv);
#endif

#ifdef TV_MODE
    if(OPMODE & WIFI_AP_STATE && (priv->up_time%2 == 0)) {
        if(priv->tv_mode_status & BIT1) { /*TV mode is auto, check if there is STA that support tv auto*/
            tv_mode_auto_support_check(priv);
        }
    }
#endif


#ifdef DOT11K
    if(priv->pmib->dot11StationConfigEntry.dot11RadioMeasurementActivated &&
        priv->pmib->dot11StationConfigEntry.dot11RMNeighborReportActivated) {       
        for(i = 0; i < MAX_NEIGHBOR_REPORT; i++) {
            if(priv->rm_neighbor_bitmask[i>>3] & (1<<(i&7))) {
                priv->rm_neighbor_info[i].aging++;
                if(priv->rm_neighbor_info[i].aging > priv->pmib->dot11StationConfigEntry.dot11RMNeighborReportExpireTime) {
                    priv->rm_neighbor_bitmask[i>>3] &= ~(1<<(i&7));
                }
            }
        }
    }
#endif

#ifdef MP_TEST
#ifdef CONFIG_PCI_HCI
	if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE) {
		if ((OPMODE & (WIFI_MP_CTX_BACKGROUND|WIFI_MP_CTX_BACKGROUND_PENDING)) ==
			(WIFI_MP_CTX_BACKGROUND|WIFI_MP_CTX_BACKGROUND_PENDING))
#ifdef SMP_SYNC
				if (rtk_tasklet_set_triggered(&(priv->pshare->tx_tasklet))) {
					tasklet_schedule(&(priv->pshare->tx_tasklet.tasklet));
				}
#else
			rtl8192cd_tx_dsr((unsigned long)priv);
#endif
	}
#endif // CONFIG_PCI_HCI


	if (OPMODE & WIFI_MP_RX) {
		if (priv->pshare->rf_ft_var.rssi_dump) {
#ifdef USE_OUT_SRC
#ifdef _OUTSRC_COEXIST
			if(IS_OUTSRC_CHIP(priv))
#endif
			{
				panic_printk("%d%%  (ss %d %d )(snr %d %d )(sq %d %d)\n",
				priv->pshare->mp_rssi,
				priv->pshare->mp_rf_info.mimorssi[0], priv->pshare->mp_rf_info.mimorssi[1],
				priv->pshare->mp_rf_info.RxSNRdB[0], priv->pshare->mp_rf_info.RxSNRdB[1],
				priv->pshare->mp_rf_info.mimosq[0], priv->pshare->mp_rf_info.mimosq[1]);
		}
#endif
			
#if !defined(USE_OUT_SRC) || defined(_OUTSRC_COEXIST)
#ifdef _OUTSRC_COEXIST
			if(!IS_OUTSRC_CHIP(priv))
#endif
			{
				panic_printk("%d%%  (ss %d %d )(snr %d %d )(sq %d %d)\n",
				priv->pshare->mp_rssi,
				priv->pshare->mp_rf_info.mimorssi[0], priv->pshare->mp_rf_info.mimorssi[1],
				priv->pshare->mp_rf_info.RxSNRdB[0], priv->pshare->mp_rf_info.RxSNRdB[1],
				priv->pshare->mp_rf_info.mimosq[0], priv->pshare->mp_rf_info.mimosq[1]);
			}
#endif
		}
	}
#endif

	// Realtek proprietary IE
#ifdef CONFIG_RTL_88E_SUPPORT
	if (GET_CHIP_VER(priv)!=VERSION_8188E)
#endif
		process_rtk_ie(priv);

	// check ACL log event
	if ((OPMODE & WIFI_AP_STATE) && priv->acLogCountdown > 0) {
		if (--priv->acLogCountdown == 0)
			if (aclog_check(priv) > 0) // still have active entry
				priv->acLogCountdown = AC_LOG_TIME;
	}

#ifdef CLIENT_MODE
	if (OPMODE & WIFI_AP_STATE)
#endif
	{
		// 11n protection count down
		if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11N) {
			if (priv->ht_legacy_obss_to > 0)
				priv->ht_legacy_obss_to--;
			if (priv->ht_nomember_legacy_sta_to > 0)
				priv->ht_nomember_legacy_sta_to--;
		}
	}
#ifdef WIFI_11N_2040_COEXIST
	if (priv->pmib->dot11nConfigEntry.dot11nCoexist && ((OPMODE & WIFI_AP_STATE) 
#ifdef CLIENT_MODE
		|| ((OPMODE & WIFI_STATION_STATE) && priv->coexist_connection)
#endif
		) && (priv->pmib->dot11BssType.net_work_type & (WIRELESS_11N|WIRELESS_11G))) {
		if (priv->bg_ap_timeout) {
			// don't go back to 40M mode for 6300 wrong channel issue
#if defined(CONFIG_PCI_HCI)
			if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE) {
				//priv->bg_ap_timeout--;
			}
#endif
#if defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI)
			if (GET_HCI_TYPE(priv) == RTL_HCI_USB || GET_HCI_TYPE(priv) == RTL_HCI_SDIO) {
				if (orSTABitMap(&priv->pshare->intel_sta_bitmap) == 0) {
					priv->bg_ap_timeout--;
					if (0 == priv->bg_ap_timeout) {
#if defined(CONFIG_RTL_8812_SUPPORT) || defined(CONFIG_WLAN_HAL)
						update_RAMask_to_FW(priv, 0);
#endif
						SetTxPowerLevel(priv, priv->pmib->dot11RFEntry.dot11channel);
#ifdef CONFIG_RTL_OFFLOAD_DRIVER
                        dc_if_update(priv, 1);
#endif
					}
				} else {
					priv->bg_ap_timeout = 60;
				}
			}
#endif
#ifdef CLIENT_MODE
			if (OPMODE & WIFI_STATION_STATE) {
				unsigned int i;
				for (i = 0; i < 14; i++)
					if (priv->bg_ap_timeout_ch[i])
						priv->bg_ap_timeout_ch[i]--;
			}
#endif
		}
#ifdef CLIENT_MODE
		if ((OPMODE & WIFI_STATION_STATE) && priv->intolerant_timeout)
			priv->intolerant_timeout--;
#endif
	}
#endif

	// Dump Rx FiFo overflow count
	if (priv->pshare->rf_ft_var.rxfifoO) {
		panic_printk("RxFiFo Overflow: %d\n", (unsigned int)(priv->ext_stats.rx_fifoO - priv->pshare->rxFiFoO_pre));
		priv->pshare->rxFiFoO_pre = priv->ext_stats.rx_fifoO;
	}

#if defined(UNIVERSAL_REPEATER) || defined(MBSSID)
	if (IS_ROOT_INTERFACE(priv))
#endif
	{
#ifdef WIFI_WMM
		if (QOS_ENABLE) {
#ifdef CLIENT_MODE
			if((OPMODE & WIFI_STATION_STATE) && (!priv->link_status) && (priv->pmib->dot11QosEntry.EDCA_STA_config)) {
				reset_EDCA_para(priv);
			}
#endif
		}
#endif

		if (fw_was_full(priv) && priv->pshare->fw_free_space > 0) { // there are free space for STA
			// do some algorithms to re-alloc STA into free space
			realloc_RATid(priv);
		}

#ifdef TX_EARLY_MODE
		if (GET_TX_EARLY_MODE) {
			if (!GET_EM_SWQ_ENABLE) {
				if (priv->pshare->em_tx_byte_cnt > EM_TP_UP_BOUND) 
					priv->pshare->reach_tx_limit_cnt++;				
				else					
					priv->pshare->reach_tx_limit_cnt = 0;	

				if (priv->pshare->txop_enlarge && priv->pshare->reach_tx_limit_cnt >= WAIT_TP_TIME) {			
					GET_EM_SWQ_ENABLE = 1;			
					priv->pshare->reach_tx_limit_cnt = 0;				
					enable_em(priv);			
				}
			}
			else {			
				if (priv->pshare->em_tx_byte_cnt < EM_TP_LOW_BOUND)
					priv->pshare->reach_tx_limit_cnt++;				
				else					
					priv->pshare->reach_tx_limit_cnt = 0;	

				if (!priv->pshare->txop_enlarge || priv->pshare->reach_tx_limit_cnt >= WAIT_TP_TIME) {
					GET_EM_SWQ_ENABLE = 0;
					priv->pshare->reach_tx_limit_cnt = 0;
					disable_em(priv);
				}
			}
		}		
#endif

		priv->pshare->phw->LowestInitRate	= _NSS4_MCS9_RATE_;
	}

#ifdef USB_PKT_RATE_CTRL_SUPPORT
	usbPkt_timer_handler(priv);
#endif

#if defined(CONFIG_RTL_92D_SUPPORT) || defined(CONFIG_RTL_92C_SUPPORT)
	if (CHIP_VER_92X_SERIES(priv))
	{
		if (priv->pshare->rf_ft_var.auto_rts_rate)
			SelectLowestInitRate(priv);
	}
#endif	
#ifdef UNIVERSAL_REPEATER
	if (IS_ROOT_INTERFACE(priv) && GET_VXD_PRIV(priv) &&
			netif_running(GET_VXD_PRIV(priv)->dev)) {
		SMP_UNLOCK(flags);
		rtl8192cd_expire_timer((unsigned long)GET_VXD_PRIV(priv));
		SMP_LOCK(flags);
	}
#endif


	if((GET_CHIP_VER(priv) != VERSION_8812E) && (GET_CHIP_VER(priv) != VERSION_8881A))
#ifdef MBSSID
	if (IS_ROOT_INTERFACE(priv)) 
#endif
	{
		unsigned char intel_sta_connected = 0;

		intel_sta_connected = orSTABitMap(&priv->pshare->intel_sta_bitmap);

		if (!intel_sta_connected) {
			unsigned int tmp_d2c = RTL_R32(0xd2c);
			if((tmp_d2c & BIT(11)) == 0)
			{
				tmp_d2c = tmp_d2c | BIT(11);
				RTL_W32(0xd2c, tmp_d2c);
#if 0	/*eric-8814 ??*/
				tmp_d2c = RTL_R32(0xd2c);
				if(tmp_d2c & BIT(11))
					printk("No Intel STA, BIT(11) of 0xd2c = %d, 0xd2c = 0x%x\n", 1, tmp_d2c);
				else
					printk("No Intel STA, BIT(11) of 0xd2c = %d, 0xd2c = 0x%x\n", 0, tmp_d2c);
#endif
			}
		}
	}

#ifdef MBSSID
	if (IS_ROOT_INTERFACE(priv)) {
		if (priv->pmib->miscEntry.vap_enable) {
			SMP_UNLOCK(flags);
			for (i=0; i<RTL8192CD_NUM_VWLAN; i++) {
				if (IS_DRV_OPEN(priv->pvap_priv[i])) {
					rtl8192cd_expire_timer((unsigned long)priv->pvap_priv[i]);
                    
                    if(priv->pvap_priv[i]->pmib->miscEntry.func_off==0){
                        somevapopened=1;
                    }
                }
			}
			SMP_LOCK(flags);
		}
	}

#endif

#ifdef RTK_ATM
	if (IS_ROOT_INTERFACE(priv)){
		if((priv->pshare->rf_ft_var.atm_en && priv->pshare->atm_ttl_stanum>1)||
			priv->pshare->rf_ft_var.atm_swqf == 1){
			//calc packet burst num every 2sec
			if((priv->up_time % priv->pshare->rf_ft_var.atm_adj_bto) == 0)
				atm_set_burst_size(priv);
		}
		if(priv->atm_sta_num && priv->pshare->rf_ft_var.atm_chk_txtime)
			atm_calc_txtime(priv);//count every 1sec
	}
#endif

#if CFG_HAL_ATM_REPORT
    if (IS_ROOT_INTERFACE(priv)){
        //the variable stored in priv is just temp for test
        GET_HAL_INTERFACE(priv)->SetATMReportCfgHandler(priv, 1, priv->ATMEnRanges, priv->ATM_period, priv->ATMSTAMACIDs, priv->ATMSTALengths, priv->ATMnumOfSTA);
	}
#endif

#ifdef MBSSID
	run = 0;
#if defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI)
	if (GET_HCI_TYPE(priv) == RTL_HCI_USB || GET_HCI_TYPE(priv) == RTL_HCI_SDIO) {
		run = 1;
	}
	if (run && (GET_ROOT(priv)->pmib->miscEntry.vap_enable)) {
		if (priv->pmib->miscEntry.func_off) {
			if (!priv->func_off_already) {
				rtl8192cd_sort_mbssid_bcn(priv);
			}
		} else {
			if (priv->func_off_already) {
				rtl8192cd_sort_mbssid_bcn(priv);
			}
		}
	} else
#endif
    if (IS_ROOT_INTERFACE(priv)) 
#endif    
    {  
        u4Byte TBTTcfg_reg, MBIDEN_reg;;
#if IS_RTL88XX_MAC_V4
        if(_GET_HAL_DATA(priv)->MacVersion.is_MAC_v4){
            TBTTcfg_reg = REG_TBTT_PROHIBIT_CFG;
            MBIDEN_reg = REG_MBSSID_CTRL_V1;
        }
#endif                
#if IS_RTL88XX_MAC_V1_V2_V3
        if(_GET_HAL_DATA(priv)->MacVersion.is_MAC_v1_v2_v3)
            TBTTcfg_reg = REG_TBTT_PROHIBIT; 
#endif        

#if IS_RTL88XX_MAC_V3
        if(_GET_HAL_DATA(priv)->MacVersion.is_MAC_v3)
            MBIDEN_reg = REG_MBID_BCNQ_EN;
#endif                
#if IS_RTL88XX_MAC_V1_V2
        if(_GET_HAL_DATA(priv)->MacVersion.is_MAC_v1_v2)
            MBIDEN_reg = REG_MBSSID_CTRL; 
#endif  

        if (priv->pmib->miscEntry.func_off) { //func_off=1        
			RTL_W8(MBIDEN_reg, RTL_R8(MBIDEN_reg) & ~(BIT(0)));
		
					if(somevapopened==0) {// not any VAP be opened and func_off not be enabled								
				   		RTL_W32(TBTTcfg_reg, (RTL_R32(TBTTcfg_reg)&0xfff000ff) | 0x100);/*minimum prohibit time[19:8] to 1*/
						if((GET_CHIP_VER(priv)== VERSION_8192E) || (GET_CHIP_VER(priv)== VERSION_8881A))
							RTL_W8(0x454,  RTL_R8(0x454) | BIT(6));
					} else {
			   			RTL_W32(TBTTcfg_reg, (RTL_R32(TBTTcfg_reg)&0xfff000ff) | 0x1df00);
					}
		
					if (!priv->func_off_already){				
						if(!IS_HAL_CHIP(priv)){
							priv->func_off_already = 1;
						}else{
							if(somevapopened==0)
								priv->func_off_already = 1;
						}				
					}

        } else {// func_off=0
        
            if (priv->func_off_already) {
                RTL_W8(MBIDEN_reg, RTL_R8(MBIDEN_reg) | BIT(0));
                priv->func_off_already = 0;
					
				if(somevapopened==0) {
					RTL_W32(TBTTcfg_reg, (RTL_R32(TBTTcfg_reg)&0xfff000ff) | 0x40000);
					if((GET_CHIP_VER(priv)== VERSION_8192E) || (GET_CHIP_VER(priv)== VERSION_8881A))
						RTL_W8(0x454, RTL_R8(0x454) & ~BIT(6));
				} else {
					RTL_W32(TBTTcfg_reg, (RTL_R32(TBTTcfg_reg)&0xfff000ff) | 0x1df00);				
				}
            }           
        }
    }
#ifdef MBSSID
    else
    if(IS_VAP_INTERFACE(priv))
    {  

        u4Byte MBIDEN_reg;;

#if IS_RTL88XX_MAC_V4
        if(_GET_HAL_DATA(priv)->MacVersion.is_MAC_v4)
            MBIDEN_reg = REG_MBSSID_CTRL_V1;
#endif
#if IS_RTL88XX_MAC_V3
        if(_GET_HAL_DATA(priv)->MacVersion.is_MAC_v3)
            MBIDEN_reg = REG_MBID_BCNQ_EN;
#endif               
#if IS_RTL88XX_MAC_V1_V2
        if(_GET_HAL_DATA(priv)->MacVersion.is_MAC_v1_v2)
            MBIDEN_reg = REG_MBSSID_CTRL; 
#endif
		if (priv->pmib->miscEntry.func_off) {
			int run = 1;
#ifdef CONFIG_PCI_HCI
			if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE) {
				if(!IS_HAL_CHIP(priv)) {
					run = 1;
				}
				else {
					run = 0;
				}
			}
#endif
			if (run && (!priv->func_off_already)) {
				RTL_W8(MBIDEN_reg, RTL_R8(MBIDEN_reg) & ~(1 << priv->vap_init_seq));
				priv->func_off_already = 1;
			}
		}
		else {
			if (priv->func_off_already) {
				RTL_W8(MBIDEN_reg, RTL_R8(MBIDEN_reg) | (1 << priv->vap_init_seq));
				priv->func_off_already = 0;
			}
		}
	}
#endif

#ifdef BEACON_VS_IE
	beacon_vsie_timeout_expire(priv);
#endif

#if defined(UNIVERSAL_REPEATER) || defined(MBSSID)
	if (IS_ROOT_INTERFACE(priv))
#endif
	{
#ifdef MP_TEST
		if (!((OPMODE & WIFI_MP_STATE) || priv->pshare->rf_ft_var.mp_specific))
#endif
		{
#ifdef RSSI_MIN_ADV_SEL
			select_rssi_min_from_data(priv);
#endif
#if defined(CH_LOAD_CAL) || defined(HS2_SUPPORT)
		if (priv->pmib->dot11StationConfigEntry.cu_enable) {
			channel_loading_measurement(priv, CLM_SAMPLE_NUM2);
    	}
#endif

#ifdef INTERFERENCE_CONTROL
			if (priv->pshare->rf_ft_var.rssi_dump && (priv->assoc_num == 0)) {
#ifdef CONFIG_RTL_88E_SUPPORT
				if (GET_CHIP_VER(priv) == VERSION_8188E)
					panic_printk("(FA %x ", RTL_R8(0xc50));
				else
#endif
					panic_printk("(FA %x,%x ", RTL_R8(0xc50), RTL_R8(0xc58));

				panic_printk("%d, %d)\n", priv->pshare->ofdm_FA_total_cnt, priv->pshare->cck_FA_cnt);
			}
#endif

#if (BEAMFORMING_SUPPORT == 1)
	if (((priv->up_time % 3) == 0) && (priv->pshare->WlanSupportAbility & WLAN_BEAMFORMING_SUPPORT)
		&& (priv->pmib->dot11RFEntry.txbf == 1) && (priv->pmib->dot11RFEntry.txbfer == 1))
	{
#if defined(CONFIG_WLAN_HAL_8822BE)
		if (GET_CHIP_VER(priv) == VERSION_8822B) 
			DynamicSelectTxBFSTA(priv);
		else
#endif
			DynamicSelect2STA(priv);
	}
#endif
#ifdef USE_OUT_SRC
		if(_OUTSRC_COEXIST_CONF_EXIST && !IS_OUTSRC_CHIP(priv))
#endif
		{
			if ( ((OPMODE & WIFI_AP_STATE)?(!(priv->assoc_num)):(!(OPMODE & WIFI_ASOC_STATE)))
#ifdef UNIVERSAL_REPEATER
				&& !(GET_VXD_PRIV(priv)->pmib->dot11OperationEntry.opmode & WIFI_ASOC_STATE)
#endif
			)
				priv->pshare->rf_ft_var.bLinked = FALSE;
			else
				priv->pshare->rf_ft_var.bLinked = TRUE;

			rtl8192cd_CheckAdaptivity(priv);
		}

#ifdef USE_OUT_SRC
#ifdef _OUTSRC_COEXIST
			if(IS_OUTSRC_CHIP(priv))
#endif
			{
				int idx = 0, link=0;
				struct stat_info* pEntry = findNextSTA(priv, &idx);
				while(pEntry) {
					if(pEntry && pEntry->expire_to) {
						link=1;
						break;
					}
					pEntry = findNextSTA(priv, &idx);
				};
				odm_cmn_info_update(ODMPTR, ODM_CMNINFO_LINK, link );
				odm_cmn_info_update(ODMPTR, ODM_CMNINFO_RSSI_MIN, priv->pshare->rssi_min);
				odm_cmn_info_update(ODMPTR, ODM_CMNINFO_RSSI_MIN_BY_PATH, priv->pshare->mimorssi_min);
#if (BEAMFORMING_SUPPORT == 1)
				Beamforming_CSIRate(priv);
#endif 
#ifdef UNIVERSAL_REPEATER
				link = IS_DRV_OPEN(GET_VXD_PRIV(priv))
					&& (GET_VXD_PRIV(priv)->pmib->dot11OperationEntry.opmode & WIFI_ASOC_STATE);
#endif			
				if(priv->pshare->rf_ft_var.dig_enable && priv->pshare->DIG_on)
					odm_cmn_info_update(ODMPTR, ODM_CMNINFO_ABILITY, ODMPTR->support_ability | ODM_BB_DIG);
				else
					odm_cmn_info_update(ODMPTR, ODM_CMNINFO_ABILITY, ODMPTR->support_ability & (~ODM_BB_DIG));






#ifdef CONFIG_VERIWAVE_CHECK
				//printk("FA=[%d], ", ODMPTR->false_alm_cnt.cnt_all);
				//printk("wifi_rx_pkts[2]=[%u], ", priv->pshare->wifi_rx_pkts[2]);
				//printk("wifi_rx_pkts[0]=[%u]\n", priv->pshare->wifi_rx_pkts[0]);
				if (priv->pshare->rf_ft_var.vwchk_cov_en
#ifdef CTC_ORIENTATION_REFINE
					&& !priv->pshare->rf_ft_var.interference_mode
#endif
					) {
					int assoc_num = priv->assoc_num;
#ifdef MBSSID
					struct rtl8192cd_priv *vap_priv;
					if (priv->pmib->miscEntry.vap_enable) {
						for (i=0; i<RTL8192CD_NUM_VWLAN; ++i) {
							vap_priv = priv->pvap_priv[i];
							if (IS_DRV_OPEN(vap_priv) && (GET_MIB(vap_priv)->dot11OperationEntry.opmode & WIFI_AP_STATE)) 
								assoc_num += vap_priv->assoc_num;
						}
					}
#endif /* MBSSID */
					if (assoc_num == 1) {
						if (ODMPTR->false_alm_cnt.cnt_all <= priv->pshare->rf_ft_var.vwchk_fa
							&& ((UINT64_DIFF(priv->pshare->wifi_rx_pkts[2], priv->pshare->wifi_rx_pkts[0]) < priv->pshare->rf_ft_var.vwchk_rxpkt) ||
							(priv->pshare->vw_dig_cnt)))
							priv->pshare->rf_ft_var.dig_oper_mode = PHYDM_BALANCE_MODE;
						else
							priv->pshare->rf_ft_var.dig_oper_mode = PHYDM_PERFORMANCE_MODE;
					}
					else
						priv->pshare->rf_ft_var.dig_oper_mode = PHYDM_BALANCE_MODE;
				}

#ifdef CONFIG_SPECIAL_ENV_TEST
				// Veriwave UDP TX Tput is degraded as BIT_SIFS_BK_EN is set.
				if (priv->pshare->veriwave_sta_num > 0 &&
					priv->pshare->rf_ft_var.vw_sifs_bk_en != priv->pshare->veriwave_sifs_bk_status) {
					RTL_W16(REG_TX_PTCL_CTRL, ((RTL_R16(REG_TX_PTCL_CTRL) & ~BIT_SIFS_BK_EN) | 
						(priv->pshare->rf_ft_var.vw_sifs_bk_en << 12)));
					priv->pshare->veriwave_sifs_bk_status = priv->pshare->rf_ft_var.vw_sifs_bk_en;
				}
#endif
#endif

				if (priv->auto_channel == 0 || priv->auto_channel == 2)
					phydm_watchdog(ODMPTR);
				dynamic_tx_power_ap(priv);
				
#ifdef CROSSBAND_REPEATER
				if(IS_ROOT_INTERFACE(priv) && IS_DRV_OPEN(GET_VXD_PRIV(priv)))
				{
					//priv->envinfo.info_record[priv->envinfo.index].noise_value = ODMPTR->NoisyDecision;
					priv->envinfo.info_record[priv->envinfo.index].noise_value = 0;
				}
#endif

#ifdef RTK_MESH_METRIC_REFINE
				priv->envinfo.info_record[priv->envinfo.index].noise_value = ODMPTR->noisy_decision;
#endif
				//if(GET_CHIP_VER(priv) != VERSION_8822B) //eric-8822 ?? No call IotEngine
				IotEngine(priv);
			}
#endif

#ifdef CROSSBAND_REPEATER
			if(IS_ROOT_INTERFACE(priv) && IS_DRV_OPEN(GET_VXD_PRIV(priv)))
			{
				priv->envinfo.rssi_metric = 0;
				priv->envinfo.cu_metric = 0;
				priv->envinfo.noise_metric = 0;
	
				index = priv->envinfo.index;
		
				priv->envinfo.index++;
				if(priv->envinfo.index >= RECORDING_DURATION)//reset index of circular buffer
					priv->envinfo.index = 0;
		
				for(i=0; i<RECORDING_DURATION; i++){
			
					if(priv->envinfo.info_record[index].noise_value){
						(i > 11 )?((i>21)?(priv->envinfo.noise_metric += 6):(priv->envinfo.noise_metric += 4)):(priv->envinfo.noise_metric += 1);
					}
					priv->envinfo.cu_metric += priv->envinfo.info_record[index].cu_value;
					priv->envinfo.rssi_metric += priv->envinfo.info_record[index].rssi_value;
					
					if(index >= (RECORDING_DURATION-1))
						index = 0;
					else
						index++;
				}
		
				priv->envinfo.cu_metric = (priv->envinfo.cu_metric / RECORDING_DURATION);
				priv->envinfo.rssi_metric = (priv->envinfo.rssi_metric / RECORDING_DURATION);
			}
#endif

#ifdef CONFIG_RTL_OFFLOAD_DRIVER
	if (OFFLOAD_ENABLE(priv)){
		if ((priv->pshare->rf_ft_var.dc_bcn_mode==1) && (priv->pshare->current_dc_bcn_mode  ==0) && (!priv->pmib->dot11DFSEntry.disable_tx)){
			dc_if_bcn_mode(priv,1);
			priv->pshare->current_dc_bcn_mode =1;
		}else if ((priv->pshare->rf_ft_var.dc_bcn_mode ==0) && (priv->pshare->current_dc_bcn_mode  ==1)){
			dc_if_bcn_mode(priv,0);
			priv->pshare->current_dc_bcn_mode =0;
		}

        if (priv->pshare->dc_debug_status != priv->pmib->miscEntry.dc_debug) {
            if (priv->pmib->miscEntry.dc_debug == 0) {
                priv->pshare->dc_debug_status = 0;
                rtl88XX_signin_h2d_cmd(priv, "0x0", h2d_sys_config);
            }
            else {
                priv->pmib->miscEntry.dc_debug = 1;
                priv->pshare->dc_debug_status = 1;
                rtl88XX_signin_h2d_cmd(priv, "0x80000000,pm", h2d_sys_config);
            }
        }
	}
#endif


#ifdef RTK_MESH_METRIC_REFINE
		priv->envinfo.rssi_metric = 0;
		priv->envinfo.cu_metric = 0;
		priv->envinfo.noise_metric = 0;

		index = priv->envinfo.index;

		priv->envinfo.index++;
		if(priv->envinfo.index >= RECORDING_DURATION)	//reset index of circular buffer
			priv->envinfo.index = 0;

		for(i=0; i<RECORDING_DURATION; i++){
			if(priv->envinfo.info_record[index].noise_value){
				(i > 11)?((i>21)?(priv->envinfo.noise_metric += 6):(priv->envinfo.noise_metric += 4)):(priv->envinfo.noise_metric += 1);
			}
			priv->envinfo.cu_metric += priv->envinfo.info_record[index].cu_value;
			priv->envinfo.rssi_metric += priv->envinfo.info_record[index].rssi_value;

			if(index >= (RECORDING_DURATION-1))
				index = 0;
			else
				index++;
		}

		priv->envinfo.cu_metric = (priv->envinfo.cu_metric / RECORDING_DURATION);
		priv->envinfo.rssi_metric = (priv->envinfo.rssi_metric / RECORDING_DURATION);		
#endif

#ifdef CONFIG_WLAN_HAL
            if (IS_HAL_CHIP(priv)) {
                //HAL timer callback entry point
                GET_HAL_INTERFACE(priv)->Timer1SecHandler(priv);
            }
#endif //CONFIG_WLAN_HAL

#ifdef AUTO_CHANNEL_TIMEOUT
if (priv->pmib->miscEntry.autoch_timeout) {
	auto_channel_timeout_expire(priv);
}
#endif

#ifdef CTC_2G_ACS
	atomic_add_unless(&(priv->pshare->ss_score_timeout_count), -1, 0);
	atomic_add_unless(&(priv->pshare->autoch_score_timeout), -1, 0);
#else
	if (priv->pmib->miscEntry.ss_score_timeout && priv->pshare->ss_score_timeout_count){
		priv->pshare->ss_score_timeout_count--;
	}
#endif /* CTC_2G_ACS */

#if !defined(USE_OUT_SRC) || defined(_OUTSRC_COEXIST)
#ifdef _OUTSRC_COEXIST
if(!IS_OUTSRC_CHIP(priv))
#endif
{
#if	defined(CONFIG_RTL_8812_SUPPORT) || defined(CONFIG_WLAN_HAL_8881A) || defined(CONFIG_WLAN_HAL_8814AE) || defined(CONFIG_RTL_8723B_SUPPORT)
if((GET_CHIP_VER(priv)== VERSION_8812E)||(GET_CHIP_VER(priv)== VERSION_8881A)||(GET_CHIP_VER(priv)== VERSION_8814A) || (GET_CHIP_VER(priv)== VERSION_8723B)){
}
else
#endif
{
			if (priv->up_time % 2) {
#ifdef CONFIG_RTL_NEW_AUTOCH
				if( priv->auto_channel ==0 || priv->auto_channel ==2 )
#endif
				FA_statistic(priv);

				if ((priv->up_time > 5) && priv->pshare->rf_ft_var.dig_enable)
					DIG_process(priv);
			}


			if (priv->pshare->rf_ft_var.auto_rts_rate) {
				priv->pshare->phw->RTSInitRate_Candidate = 
					get_rate_index_from_ieee_value(find_rts_rate(priv, priv->pshare->phw->LowestInitRate,
					priv->pmib->dot11ErpInfo.protection));
				
				if (priv->pshare->phw->RTSInitRate_Candidate != priv->pshare->phw->RTSInitRate) {
					priv->pshare->phw->RTSInitRate = priv->pshare->phw->RTSInitRate_Candidate;				
					RTL_W8(INIRTS_RATE_SEL, priv->pshare->phw->RTSInitRate);
				}
			}
			
}

#ifdef SW_ANT_SWITCH
			if ((SW_DIV_ENABLE)  && (priv->up_time % 4==1))
				dm_SW_AntennaSwitch(priv, SWAW_STEP_PEAK);
#endif
}
#endif

#ifdef CONFIG_1RCCA_RF_POWER_SAVING
			if (priv->pshare->rf_ft_var.one_path_cca_ps == 2) {
				if (priv->pshare->rssi_min == 0xff) {	// No Link
					one_path_cca_power_save(priv, 1);
				} else {
					if (priv->pshare->rssi_min > priv->pshare->rf_ft_var.one_path_cca_ps_rssi_thd)
						one_path_cca_power_save(priv, 1);
					else
						one_path_cca_power_save(priv, 0);
				}
			}
#endif // CONFIG_1RCCA_RF_POWER_SAVING
		}

		if (OPMODE & WIFI_MP_STATE) 
			halrf_watchdog(ODMPTR);

#ifdef CAM_SWAP
		if ((OPMODE & WIFI_AP_STATE) && 
			 (priv->pshare->rf_ft_var.cam_rotation)){
			if (priv->up_time % priv->pshare->rf_ft_var.cam_rotation == 0){

				int sta_use_sw_encrypt = 0;

				sta_use_sw_encrypt = get_sw_encrypt_sta_num(priv);

				printk("%s %d sta_use_sw_encrypt=%d \n", __FUNCTION__, __LINE__, sta_use_sw_encrypt);
				
				if(sta_use_sw_encrypt){
					cal_sta_traffic(priv, sta_use_sw_encrypt);
					rotate_sta_cam(priv, sta_use_sw_encrypt);
				}
			}
		}
#endif


#if defined(WIFI_11N_2040_COEXIST_EXT)
	if((OPMODE & WIFI_AP_STATE) && priv->pshare->rf_ft_var.bws_enable & 0x1)
		checkBandwidth(priv);
#endif	

#if !defined(USE_OUT_SRC) || defined(_OUTSRC_COEXIST)
#ifdef _OUTSRC_COEXIST
if(!IS_OUTSRC_CHIP(priv))
#endif
{
		
#ifdef HIGH_POWER_EXT_PA
		if(CHIP_VER_92X_SERIES(priv)) {
			if((priv->pshare->rf_ft_var.use_ext_pa) && (priv->pshare->rf_ft_var.tx_pwr_ctrl))
				tx_power_control(priv);
		}
#endif		
		IOT_engine(priv);
		rxBB_dm(priv);

}
#endif

#ifdef USE_OUT_SRC
#ifdef _OUTSRC_COEXIST
		if(IS_OUTSRC_CHIP(priv))
#endif
		{
			if ((priv->up_time % 3) == 1) {
				if (priv->pshare->rssi_min != 0xff) {
					if (priv->pshare->rf_ft_var.nbi_filter_enable) 
						check_NBI_by_rssi(priv, priv->pshare->rssi_min);
				}
			}					
		}
#endif

#if defined(CONFIG_RTL_92C_SUPPORT) || defined(CONFIG_RTL_92D_SUPPORT)			
		if (CHIP_VER_92X_SERIES(priv)) {
#ifdef CONFIG_PCI_HCI
			if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE) {
				if (priv->pshare->txpause_pstat != NULL) {
					if (TSF_DIFF(jiffies, priv->pshare->txpause_time) > RTL_SECONDS_TO_JIFFIES(1)) {
						RTL_W8(TXPAUSE, RTL_R8(TXPAUSE) & 0xe0);
						priv->pshare->txpause_pstat = NULL;
					}
				}
			}
#endif
		}
#endif

	}

#if defined(CONFIG_RTL_88E_SUPPORT) || defined(CONFIG_RTL_8812_SUPPORT) || defined(CONFIG_RTL_8723B_SUPPORT)
	if ((GET_CHIP_VER(priv) == VERSION_8188E) || (GET_CHIP_VER(priv) == VERSION_8812E) || (GET_CHIP_VER(priv) == VERSION_8723B)) {
		struct list_head	*plist, *phead;
		struct stat_info	*pstat;
#if defined(SMP_SYNC) /*&& (defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI))*/
		unsigned long local_flags = 0;
#endif
		phead = &priv->sleep_list;

		SMP_LOCK_SLEEP_LIST(local_flags);

		plist = phead->next;
		while(plist != phead)
		{
			pstat = list_entry(plist, struct stat_info, sleep_list);
			plist = plist->next;

			if (!pstat->cmn_info.ra_info.disable_ra) {
				if (pstat->txpause_flag && (TSF_DIFF(jiffies, pstat->txpause_time) > RTL_SECONDS_TO_JIFFIES(1))) {
#if defined(CONFIG_RTL_8812_SUPPORT) || defined(CONFIG_RTL_8723B_SUPPORT)
					if(GET_CHIP_VER(priv)==VERSION_8812E || GET_CHIP_VER(priv)==VERSION_8723B) {
						UpdateHalMSRRPT8812(priv, pstat, DECREASE);			
						pstat->txpdrop_flag = 1;
						pstat->drop_expire++;						
						RTL8812_MACID_PAUSE(priv, 0, REMAP_AID(pstat));
					}
					else
#endif
					{
#ifdef CONFIG_RTL_88E_SUPPORT
						RTL8188E_MACID_PAUSE(priv, 0, REMAP_AID(pstat));
#endif
					}
					pstat->txpause_flag = 0;
					if(priv->pshare->paused_sta_num)
						priv->pshare->paused_sta_num--;					
				}
			}
		}

		SMP_UNLOCK_SLEEP_LIST(local_flags);
	} else
#endif
//remove this because some sta will idle over 1 sec, than the data path will disconnect for a while
//#if 0
#ifdef CONFIG_WLAN_HAL
	if(IS_HAL_CHIP(priv))
	{
		struct list_head	*plist, *phead;
		struct stat_info	*pstat;
#ifdef FW_DROP_EXPIRE
		unsigned int fwDropTime =  priv->pmib->dot11OperationEntry.fwDropExpire;
#endif
#if defined(SMP_SYNC)/* && (defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI))*/
		unsigned long local_flags = 0;
#endif
#ifndef STA_AGING_FUNC_OFFLOAD
		phead = &priv->sleep_list;

		SMP_LOCK_SLEEP_LIST(local_flags);

		plist = phead->next;
		while(plist != phead)
		{
			pstat = list_entry(plist, struct stat_info, sleep_list);
			plist = plist->next;
#ifdef AP_SWPS_OFFLOAD            
            if(!pstat->EnSWPS)//not in SWPS will need aging function
#endif     
            {
#ifdef FW_DROP_EXPIRE
			if ((fwDropTime) && (pstat->txpause_flag && (TSF_DIFF(jiffies, pstat->txpause_time) > RTL_MILISECONDS_TO_JIFFIES(fwDropTime))))
	
#else            
			if (pstat->txpause_flag && (TSF_DIFF(jiffies, pstat->txpause_time) > RTL_SECONDS_TO_JIFFIES(1)))
#endif
			{
				DEBUG_WARN("[%s][%s][%d] set MACID %d\n", __FUNCTION__, priv->dev->name, pstat->cmn_info.aid, REMAP_AID(pstat));
				GET_HAL_INTERFACE(priv)->UpdateHalMSRRPTHandler(priv, pstat, DECREASE);
				pstat->txpdrop_flag = 1;
				pstat->drop_expire++;	
#ifdef HW_DETECT_PS_OFFLOAD                        
					GET_HAL_INTERFACE(priv)->MACIDPauseHandler(priv, REMAP_AID(pstat), 0);
					//priv->pshare->HWPwroldState[pstat->cmn_info.aid>>5] = priv->pshare->HWPwroldState[pstat->cmn_info.aid>>5] & ~BIT(pstat->cmn_info.aid&0x1F); //manual update pwr state								
#else                        
				GET_HAL_INTERFACE(priv)->SetMACIDSleepHandler(priv, 0, REMAP_AID(pstat));  
                        
#endif                    
				pstat->txpause_flag = 0;
				if (priv->pshare->paused_sta_num)
					priv->pshare->paused_sta_num--;
			}
		}
		}

		SMP_UNLOCK_SLEEP_LIST(local_flags);
#endif 
	} else
#endif // CONFIG_WLAN_HAL
	{}
//#endif
		
#if defined(TXREPORT)
	if ( CHIP_VER_92X_SERIES(priv) ||(GET_CHIP_VER(priv)==VERSION_8812E) 
	#ifdef CONFIG_RTL_8723B_SUPPORT 
		|| (GET_CHIP_VER(priv)==VERSION_8723B)
	#endif
	) { 
		

		if (!IS_TEST_CHIP(priv))
		#ifdef MP_TEST
		if (!((OPMODE & WIFI_MP_STATE) || priv->pshare->rf_ft_var.mp_specific))
		#endif
		#if defined(UNIVERSAL_REPEATER) || defined(MBSSID)
		if (IS_ROOT_INTERFACE(priv))
		#endif
		{

#if defined(DETECT_STA_EXISTANCE) && (defined(CONFIG_RTL_92C_SUPPORT) || defined(CONFIG_RTL_92D_SUPPORT))
			if(CHIP_VER_92X_SERIES(priv))
			LeavingSTA_RLCheck(priv);
#endif
			if (!(priv->up_time%priv->pmib->staDetectInfo.txRprDetectPeriod) && (priv->pshare->sta_query_idx==-1)) {
				priv->pshare->sta_query_idx = 0;
#if defined(CONFIG_RTL_8812_SUPPORT) || defined(CONFIG_RTL_8723B_SUPPORT)
				if((GET_CHIP_VER(priv)==VERSION_8812E) || (GET_CHIP_VER(priv)==VERSION_8723B)){
					requestTxReport_8812(priv);
				}
#endif
				if(CHIP_VER_92X_SERIES(priv)){
					requestTxReport(priv);
				}
			}
		}
	}
#if defined(CONFIG_RTL_88E_SUPPORT) 
		if (GET_CHIP_VER(priv) == VERSION_8188E)	
#if defined(UNIVERSAL_REPEATER) || defined(MBSSID)
		if (IS_ROOT_INTERFACE(priv))
#endif
		{
			LeavingSTA_RLCheck(priv);
		}
#endif	
#endif

#ifdef TXREPORT
#ifdef CONFIG_WLAN_HAL
      	if(IS_HAL_CHIP(priv)) {
#ifdef MP_TEST
			if (!((OPMODE & WIFI_MP_STATE) || priv->pshare->rf_ft_var.mp_specific))
#endif
#if defined(UNIVERSAL_REPEATER) || defined(MBSSID)
			if (IS_ROOT_INTERFACE(priv))
#endif
			if ( priv->pshare->sta_query_idx == -1) {
				priv->pshare->sta_query_idx = 0;
				priv->pshare->sta_query_idx_pre = -1;
#if (MU_BEAMFORMING_SUPPORT == 1)
				if(priv->pmib->dot11RFEntry.txbf_mu)					
					requestTxReport88XX_MU(priv);
				else
#endif				
				requestTxReport88XX(priv);
			} else {
				if (priv->pshare->sta_query_idx_pre != priv->pshare->sta_query_idx) {
					priv->pshare->sta_query_idx_pre = priv->pshare->sta_query_idx;
				} else {
#if (MU_BEAMFORMING_SUPPORT == 1)
					if(priv->pmib->dot11RFEntry.txbf_mu)
						requestTxReport88XX_MU(priv);
					else
#endif
						requestTxReport88XX(priv);
				}
			}
        }
#endif
#endif

#ifdef RTK_MULTI_AP
	expireEntryBlockList(priv);
#endif

#if defined(CONFIG_IEEE80211W) || defined(CONFIG_IEEE80211V)
#ifdef CONFIG_IEEE80211V 
	if(WNM_ENABLE) {
		BssTrans_ExpiredTimer(priv);
#ifdef CONFIG_MBO
		if(priv->pmib->wnmEntry.dot11vBssTermination == 2)
			BssTermination_ExpiredTimer(priv);
		else if(priv->pmib->wnmEntry.dot11vBssTermination == 3)
			BssTermination_DurationTimer(priv);
#endif

#ifndef RTK_MULTI_AP
		BssTrans_DiassocTimer(priv);
#endif

	#ifdef CONFIG_IEEE80211V_CLI
		BssTrans_ValidatePrefListTimer(priv);
		BssTrans_TerminationTimer(priv);
	#endif
	}
#endif // CONFIG_IEEE80211V 

	issue_actionFrame(priv);
#endif // CONFIG_IEEE80211W || CONFIG_IEEE80211V

#ifdef SW_TX_QUEUE
#ifdef CONFIG_MBO_CLI
	if(priv->pshare->rf_ft_var.swq_dbg == 50){
		issue_MBO_GAS_req(priv, _GAS_INIT_REQ_ACTION_ID_);
		priv->pshare->rf_ft_var.swq_dbg = 0;
	}
	else if(priv->pshare->rf_ft_var.swq_dbg == 51){
		issue_WNM_Notify_channel_report(priv);
		priv->pshare->rf_ft_var.swq_dbg = 0;
	}
	else if(priv->pshare->rf_ft_var.swq_dbg == 52){
		issue_MBO_GAS_req(priv, _GAS_COMBACK_REQ_ACTION_ID_);
		priv->pshare->rf_ft_var.swq_dbg = 0;
	}
#endif
	if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE) {
#ifdef HS2_SUPPORT
#ifdef HS2_CLIENT_TEST
		//printk("swq_dbg=%d\n",priv->pshare->rf_ft_var.swq_dbg);
		if (priv->pshare->rf_ft_var.swq_dbg != 0)
		{
			DOT11_HS2_GAS_REQ gas_req;
			unsigned short query_id;

		//if (priv->pshare->rf_ft_var.swq_dbg == 40 && IS_ROOT_INTERFACE(priv))
			
			if (priv->pshare->rf_ft_var.swq_dbg == 40  && IS_ROOT_INTERFACE(priv))
			{
				issue_WNM_Notify(priv);
				priv->pshare->rf_ft_var.swq_dbg = 0;
				goto hs_break;
				
			}		
			if (priv->pshare->rf_ft_var.swq_dbg == 41  && IS_ROOT_INTERFACE(priv))
			{
				issue_disassoc(priv,priv->pmib->hs2Entry.sta_mac,_RSON_AUTH_NO_LONGER_VALID_ );
				priv->pshare->rf_ft_var.swq_dbg = 0;
				goto hs_break;
				
			}		
			if (priv->pshare->rf_ft_var.swq_dbg == 44  && IS_ROOT_INTERFACE(priv))
			{		
				issue_deauth(priv,priv->pmib->hs2Entry.sta_mac,_RSON_AUTH_NO_LONGER_VALID_ );
				priv->pshare->rf_ft_var.swq_dbg = 0;
				goto hs_break;
				
			}
			if (priv->pshare->rf_ft_var.swq_dbg == 45  && IS_ROOT_INTERFACE(priv))
			{
				unsigned char zeromac[6]={0x00,0x00,0x00,0x00,0x00,0x00};
				//int issue_BSS_TxMgmt_req(struct rtl8192cd_priv *priv, unsigned char *da);
				if (memcmp(priv->pmib->hs2Entry.sta_mac, zeromac, 6))
				{
					DOT11_HS2_TSM_REQ tsmreq;
					HS2_DEBUG_INFO("send bss tx mgmt Req to STA:[%02x:%02x:%02x:%02x:%02x:%02x]\n", 
						priv->pmib->hs2Entry.sta_mac[0], priv->pmib->hs2Entry.sta_mac[1],
						priv->pmib->hs2Entry.sta_mac[2], priv->pmib->hs2Entry.sta_mac[3],
						priv->pmib->hs2Entry.sta_mac[4], priv->pmib->hs2Entry.sta_mac[5]);	
	                
					memcpy(tsmreq.MACAddr, priv->pmib->hs2Entry.sta_mac, 6);
					tsmreq.Req_mode = 16; // ESS Disassoc Imminent
					tsmreq.term_len = 0;

					tsmreq.Dialog_token = 5;
					tsmreq.Disassoc_timer = 100;
					tsmreq.Validity_intval = 0;	
					tsmreq.url_len = strlen(priv->pmib->hs2Entry.SessionInfoURL);
					if (tsmreq.url_len <= sizeof(tsmreq.Session_url))
						memcpy(tsmreq.Session_url, priv->pmib->hs2Entry.SessionInfoURL, tsmreq.url_len);
					tsmreq.list_len = 0;

					issue_BSS_TSM_req(priv, &tsmreq);

	               	if (rtk_timer_pending(&priv->disassoc_timer))
	            		rtk_del_timer_sync(&priv->disassoc_timer);

					rtk_mod_timer(&priv->disassoc_timer, jiffies + tsmreq.Disassoc_timer * RTL_MILISECONDS_TO_JIFFIES(priv->pmib->dot11StationConfigEntry.dot11BeaconPeriod));
				}
				priv->pshare->rf_ft_var.swq_dbg = 0;
			}
			if (priv->pshare->rf_ft_var.swq_dbg == 46  && IS_ROOT_INTERFACE(priv))
			{
				issue_WNM_Deauth_Req(priv,priv->pmib->hs2Entry.sta_mac, 0,1, "https://deauth_notification.r2-testbed.wi-fi.org");
				priv->pshare->rf_ft_var.swq_dbg = 0;
				goto hs_break;
			}

			if (priv->pshare->rf_ft_var.swq_dbg == 47  && IS_ROOT_INTERFACE(priv))
			{
				priv->pmib->hs2Entry.curQoSMap = 1;
				setQoSMapConf(priv);
				issue_QoS_MAP_Configure(priv, priv->pmib->hs2Entry.sta_mac, priv->pmib->hs2Entry.curQoSMap);
				priv->pshare->rf_ft_var.swq_dbg = 0;
				goto hs_break;
				
			}

			if (priv->pshare->rf_ft_var.swq_dbg == 48 && IS_ROOT_INTERFACE(priv))
			{
				issue_WNM_Deauth_Req(priv,priv->pmib->hs2Entry.sta_mac, 0,1, "");
				priv->pshare->rf_ft_var.swq_dbg = 0;
				goto hs_break;
				
			}
			if ((OPMODE & WIFI_ASOC_STATE) == 0)
			{
			    priv->pshare->CurrentChannelBW = CHANNEL_WIDTH_20;
			    SwBWMode(priv, priv->pshare->CurrentChannelBW, priv->pshare->offset_2nd_chan);
			    SwChnl(priv, priv->pmib->dot11RFEntry.dot11channel, priv->pshare->offset_2nd_chan);
			    delay_us(250);
			}

			if ((priv->pshare->rf_ft_var.swq_dbg >= 30) && (priv->pshare->rf_ft_var.swq_dbg <= 39))
			{
			    unsigned char tmpda[]={0xff,0xff,0xff,0xff,0xff,0xff};
		    //issue_probereq(priv,"",0, tmpda);
			    goto hs_break;
			}
			if (priv->pshare->rf_ft_var.swq_dbg == 20)
			{
			    unsigned char list[]={0x03,0x01,0x30,0x03,0x01,0x50};
			    issue_BSS_TSM_query(priv, list, sizeof(list));
			    priv->pshare->rf_ft_var.swq_dbg = 0;
			    goto hs_break;
			}



			// query_id is identified by the issue_GASreq function
			// refer to Table 8-184
			//capability List  (Test Case 4.2 Proc. (a) in HS2.0 R2 Test Plan v.0.01)
			if (priv->pshare->rf_ft_var.swq_dbg == 3)
			    query_id = 257;
			//Roaming Consortium list (Test Case 4.4 Step2 in HS2.0 R2 Test Plan v.0.01)
			else if (priv->pshare->rf_ft_var.swq_dbg == 4)
			    query_id = 261;
			//venue name  (Test Case 4.4 Step8 in HS2.0 R2 Test Plan v.0.01)    
			else if (priv->pshare->rf_ft_var.swq_dbg == 5)
			    query_id = 258;
			// Network Authentication Type Information  (Test Case 4.4 Step10 in HS2.0 R2 Test Plan v.0.01) 
			else if (priv->pshare->rf_ft_var.swq_dbg == 6)
			    query_id = 260; 
			//IP Address Type Availability Information  (Test Case 4.4 Step12 in HS2.0 R2 Test Plan v.0.01)
			else if (priv->pshare->rf_ft_var.swq_dbg == 7)
			    query_id = 262;
			//combine  nai_list+3gpp+domain_list  (Test Case 4.4 Step4 in HS2.0 R2 Test Plan v.0.01)
			else if (priv->pshare->rf_ft_var.swq_dbg == 8)
			    query_id = 10000;
			//HS Capability list and Operator Friendly Name  (Test Case 4.4 Step6 in HS2.0 R2 Test Plan v.0.01)
			else if (priv->pshare->rf_ft_var.swq_dbg == 9)
			    query_id = 501; 
			//HS WAN Metrics and Connection Lists  (Test Case 4.4 Step14 in HS2.0 R2 Test Plan v.0.01)
			else if (priv->pshare->rf_ft_var.swq_dbg == 10)
			    query_id = 502; 
			//hs wan+hs no support type 
			else if (priv->pshare->rf_ft_var.swq_dbg == 18)
			    query_id = 505;
			//hs home realm query, cnt=0
			else if (priv->pshare->rf_ft_var.swq_dbg == 19)
			    query_id = 506;
			//hs operating class
			else if (priv->pshare->rf_ft_var.swq_dbg == 21)
			    query_id = 507;
			//hs home realm query  (Test Case 4.4 Step16 in HS2.0 R2 Test Plan v.0.01)
			else if (priv->pshare->rf_ft_var.swq_dbg == 11)
			    query_id = 503; 
			//hs  2 home realm query
			else if (priv->pshare->rf_ft_var.swq_dbg == 17)
			    query_id = 504;
			//advt protocol error   
			else if (priv->pshare->rf_ft_var.swq_dbg == 12)
			    query_id = 262; 
			// Query element (qid = roaming list) + HS2 WAN Metrics element  + HS2 Operating Class Indication element
			else if (priv->pshare->rf_ft_var.swq_dbg == 13)
			    query_id = 270; 
			//roaming list    (qid = roaming list) + HS2 element (subtype = reserved) + HS Query List 
			else if (priv->pshare->rf_ft_var.swq_dbg == 14)
			    query_id = 271;     
			//nai list
			else if (priv->pshare->rf_ft_var.swq_dbg == 15)
			    query_id = 263;
			//capa+comback request
			else if (priv->pshare->rf_ft_var.swq_dbg == 16)
			{
			    query_id = 257;
			    testflg = 1;
			}
			else if (priv->pshare->rf_ft_var.swq_dbg == 22) // for Test Case 4.3 Step 4
			    query_id = 272;
			else if (priv->pshare->rf_ft_var.swq_dbg == 23) // for Test Case 4.3 Step 6
			    query_id = 0;
			else if (priv->pshare->rf_ft_var.swq_dbg == 42) { // ICON Request
			    query_id = 508;
			}
			else if (priv->pshare->rf_ft_var.swq_dbg == 43) { // Online Sign-Up Providers list
			    query_id = 509;
			}
			else
				goto hs_break;
			    
			gas_req.Dialog_token = 5;
			issue_GASreq(priv, &gas_req, query_id);
			HS2_DEBUG_INFO("send gas req\n");
			priv->pshare->rf_ft_var.swq_dbg = 0;
		} 
	hs_break:
#endif
#endif

#ifdef SW_TX_QUEUE_SMALL_PACKET_CHECK
	// add for small udp packet(88B) test with veriwave tool (let sw tx queue start quickly after first round test)
	// the interval between every round test is about 10sec
#if 1
		if ((priv->assoc_num > 1) && (AMPDU_ENABLE) && (priv->pshare->swq_txmac_chg >= priv->pshare->rf_ft_var.swq_en_highthd))
			priv->pshare->swq_boost_delay = 0;		
		else
			priv->pshare->swq_boost_delay++;

		if (priv->pshare->swq_boost_delay >= 10)
			priv->pshare->swq_boost_delay = 10;
#else
		priv->pshare->swq_boost_delay = 0;
#endif
#endif

		//for debug 
		//if (priv->pshare->rf_ft_var.swq_dbg)
		//	printk("sw cnt:%d:%d,0x%x\n", priv->swq_txmac_chg,priv->swq_en, RTL_R32(EDCA_BE_PARA));

		if (IS_ROOT_INTERFACE(priv))
	        priv->pshare->swq_txmac_chg = 0;
	}
#endif

#if defined(CLIENT_MODE) && defined(WIFI_11N_2040_COEXIST)
	if ((OPMODE & (WIFI_STATION_STATE | WIFI_ASOC_STATE)) == (WIFI_STATION_STATE | WIFI_ASOC_STATE))
		start_clnt_coexist_scan(priv);
#endif

#ifdef RADIUS_ACCOUNTING
	//brian add for accounting
	if(ACCT_FUN)
	{
		cal_statistics_acct(priv);
		expire_sta_for_radiusacct(priv);
	}
#endif

#if defined(UNIVERSAL_REPEATER) || defined(MBSSID)
	if (IS_ROOT_INTERFACE(priv))
#endif
	{
		switch(priv->pshare->intel_active_sta) {
		case 0:
		case 1:
			priv->pshare->intel_rty_lmt =  0x30; /* 48 times */
			break;
		case 2:
			priv->pshare->intel_rty_lmt =  0x18; /* 24 times */
			break;
		default:
			priv->pshare->intel_rty_lmt =  0; /* use system default */
			break;			
		}

		priv->pshare->intel_active_sta = 0;

//#if defined(SMART_REPEATER_MODE) && !defined(RTK_NL80211)
#if 0//removed to prevent system hang-up after repeater follow remote AP to switch channel
		if (priv->pshare->switch_chan_rp && 
				((priv->pmib->dot11RFEntry.dot11channel != priv->pshare->switch_chan_rp) ||
				  (priv->pmib->dot11nConfigEntry.dot11n2ndChOffset != priv->pshare->switch_2ndchoff_rp) ||
				  (priv->pmib->dot11nConfigEntry.dot11nUse40M != priv->pshare->band_width_rp)) ) {
			DEBUG_INFO("swtich chan=%d\n",  priv->pshare->switch_chan_rp);
			switch_chan_to_vxd(priv);			
			priv->pshare->switch_chan_rp = 0;
		}
#endif		
	}

    /*for delay wsc client mode do Scan; special on repeater mode 
	   if  client mode do Scan too frequent and continous
       will cause the client(that connected with repeater's AP interface) disconnect*/
#if defined( WIFI_SIMPLE_CONFIG	) && defined(UNIVERSAL_REPEATER)
    if(IS_VXD_INTERFACE(priv) && (OPMODE & WIFI_STATION_STATE)){
	    if(priv->wsc_ss_delay){
    	    //STADEBUG("wsc_ss_delay remain[%d]\n",priv->wsc_ss_delay);
	        priv->wsc_ss_delay--;
    	}
	}
#endif    

#if defined(CONFIG_RTL_SIMPLE_CONFIG)
	if(priv->pmib->dot11StationConfigEntry.sc_enabled == 1) 
	{
		priv->simple_config_time++;
		if(priv->simple_config_status == 0)
		{
			rtk_sc_start_simple_config(priv);
		}
		else if(priv->simple_config_status == 2)
		{
			//panic_printk("the channel is %d\n", priv->pmib->dot11RFEntry.dot11channel);
			if(priv->simple_config_time > priv->pmib->dot11StationConfigEntry.sc_get_sync_time)
			{
				if (get_sc_sync_state() ==1) {
					if (priv->simple_config_time > (priv->pmib->dot11StationConfigEntry.sc_get_sync_time +priv->pmib->dot11StationConfigEntry.sc_get_profile_time)) {
						panic_printk("get profile timeout\n");
						rtk_sc_restart_simple_config(priv);
					}
				} else {
				panic_printk("sync timeout\n");
				rtk_sc_restart_simple_config(priv);
			}
		}
		}
		else if(priv->simple_config_status>=3 && priv->simple_config_status<=5)
		{
			if (OPMODE & WIFI_ASOC_STATE)
			{
				struct stat_info *pstat;
				pstat = get_stainfo(priv, priv->pmib->dot11StationConfigEntry.dot11DesiredBssid);
				if( pstat)
				{
					if((pstat->link_time >= priv->pmib->dot11StationConfigEntry.sc_check_link_time) || (pstat->wpa_sta_info->clientHndshkDone))
					{
						priv->simple_config_status = 6;
						panic_printk("connect to %s now!\n", priv->pmib->dot11StationConfigEntry.dot11DesiredSSID);
						rtk_sc_stop_simple_config(priv);
					}
				}
			}
			else
			{
				if(priv->simple_config_time > priv->pmib->dot11StationConfigEntry.sc_connect_timeout)
				{
					rtk_sc_restart_simple_config(priv);
				}
			}
		}
		else if(priv->simple_config_status == 6)
		{
			//rtk_sc_stop_simple_config(priv);
		}
#if defined(CONFIG_RTL_SIMPLE_CONFIG_USE_WPS_BUTTON)
		if(priv->simple_config_status >= 2)
		{
			if(priv->pmib->wscEntry.wsc_enable)
				priv->pmib->wscEntry.wsc_enable = 0;
		}
#endif

		if(priv->pmib->dot11StationConfigEntry.sc_duration_time>0)
		{
			priv->pmib->dot11StationConfigEntry.sc_duration_time--;
			if(priv->pmib->dot11StationConfigEntry.sc_duration_time == 0)
			{
				rtk_sc_stop_simple_config(priv);
			}
		}
	}
	else
	{
		if(priv->simple_config_status != 0)
		{
			priv->simple_config_status = 0;
		}
		if(priv->simple_config_could_fix != 0)
		{
			priv->simple_config_could_fix = 0;
		}
	}
#endif
#ifdef BT_COEXIST
	if(GET_CHIP_VER(priv) == VERSION_8192E && priv->pshare->rf_ft_var.btc == 1
#if defined(UNIVERSAL_REPEATER) || defined(MBSSID)
		&& IS_ROOT_INTERFACE(priv)
#endif
			){
		/* 
		*	BT coexist dynamic mechanism 
		*/
		if(priv->up_time % 1 == 0){
			bt_coex_dm(priv); 
		}
		/* 
		* Query BT info 
		*/
		if(priv->up_time % 1 == 0){ 
			u1Byte		H2CCommand[1] = {0};
			H2CCommand[0] |= BIT0;
			FillH2CCmd88XX(priv, H2C_88XX_BT_INFO, 1, H2CCommand);
		}
		if(priv->pshare->rf_ft_var.bt_dump >= 2){
			panic_printk("--------------------------------------------------------------------\n");
			panic_printk("\n0x778:%8x\n",phy_query_bb_reg(priv, 0x778, bMaskDWord));
			panic_printk("0x92c:%8x,",phy_query_bb_reg(priv, 0x92c, bMaskDWord));
			panic_printk("   0x930:%8x\n",phy_query_bb_reg(priv, 0x930, bMaskDWord));
			panic_printk("0x40 :%8x,",phy_query_bb_reg(priv, 0x40,	bMaskDWord));
			panic_printk("   0x4f :%8x\n",phy_query_bb_reg(priv, 0x4c,  0xff000000));
			panic_printk("0x550:%8x,",phy_query_bb_reg(priv, 0x550, bMaskDWord));
			panic_printk("   0x522:%8x\n",phy_query_bb_reg(priv, 0x520, 0x00ff0000));
			panic_printk("0xc50:%8x,",phy_query_bb_reg(priv, 0xc50, bMaskDWord));
			panic_printk("   0xc58:%8x\n",phy_query_bb_reg(priv, 0xc58, bMaskDWord));
			panic_printk("0x6c0:%8x,",phy_query_bb_reg(priv, 0x6c0, bMaskDWord));
			panic_printk("   0x6c4:%8x,",phy_query_bb_reg(priv, 0x6c4, bMaskDWord));
			panic_printk("   0x6c8:%8x,",phy_query_bb_reg(priv, 0x6c8, bMaskDWord));
			panic_printk("   0x6cc:%8x\n",phy_query_bb_reg(priv, 0x6cc, bMaskDWord));
			panic_printk("0x770: hp rx:%d,",phy_query_bb_reg(priv, 0x770, bMaskHWord));
			panic_printk("   tx:%d\n",phy_query_bb_reg(priv, 0x770, bMaskLWord));
			panic_printk("0x774: lp rx:%d,",phy_query_bb_reg(priv, 0x774, bMaskHWord));
			panic_printk("	 tx:%d\n",phy_query_bb_reg(priv, 0x774, bMaskLWord));
			panic_printk("--------------------------------------------------------------------\n");
		}
		phy_set_bb_reg(priv, 0x76c, 0x00ff0000, 0x0c); /* reset BT counter*/
	}	
#endif

#ifdef CONFIG_IEEE80211R
	if (FT_ENABLE && priv->pmib->dot11FTEntry.dot11FTR0KeyLifetime) {
		check_r0key_expire(priv);
	}
	
#ifdef CONFIG_IEEE80211R_CLI
	if(FT_ENABLE && (OPMODE & WIFI_STATION_STATE)) {
		FT_EventTimer(priv);
	}
#endif	
#endif

#ifdef COCHANNEL_RTS
	if (priv->cochannel_to) {
		priv->cochannel_to --;
#ifdef CONFIG_RTL_OFFLOAD_DRIVER
        if (priv->cochannel_to == 0)
            dc_if_update(priv, 1);
#endif
	}
	
	if (GET_CHIP_VER(priv) == VERSION_8814B){
		if (priv->cochannel_to) 
				RTL_W16(0x546, 0xc0); 
		else
				RTL_W16(0x546,0x1b); 
	}		
	
#endif	

#ifdef THERMAL_CONTROL
	if(priv->up_time % priv->pshare->rf_ft_var.ther_dm_period == 0)
		thermal_control_dm(priv);
#endif
	keep_pkts_pre_expire(priv);

#ifdef DYN_AMPDU_NUM
	if (priv->pmib->miscEntry.dyn_ampdu) {
		if (priv->adj_ampdu_num == 0 &&
			((priv->ext_stats.tx_avarage >> 17) > 50 && 
			  priv->tx_pktlen_avg < 600)) {
				priv->adj_ampdu_num = 1;
				priv->bak_ampdu_num = RTL_R16(0x4ca);
				RTL_W16(0x4ca, 0x2020);
		}
		else if (priv->adj_ampdu_num == 1 &&
			((priv->ext_stats.tx_avarage >> 17) < 45 ||
			 priv->tx_pktlen_avg > 600)) {
				priv->adj_ampdu_num = 0;
				RTL_W16(0x4ca, priv->bak_ampdu_num);
		}
	}
	else {
		if (priv->adj_ampdu_num) {
			priv->adj_ampdu_num = 0;
			RTL_W16(0x4ca, priv->bak_ampdu_num);
		}
		priv->tx_pktlen_avg = 0;
	}
#endif

#ifdef RA_OFFSET_TRAINING
	if ((GET_CHIP_VER(priv) == VERSION_8192F) &&
		(priv->pmib->miscEntry.ra_training))
	{
		ra_offset_training(priv);
		if ((priv->ext_stats.tx_avarage + priv->ext_stats.rx_avarage)>>7 < 1000)
			if (priv->up_time % 10 == 0)
				priv->pshare->adjacent_intf = 0;
	}
#endif		

#ifdef CTC_AP_COEXIST
	if ((GET_CHIP_VER(priv) == VERSION_8192F) || (GET_CHIP_VER(priv) == VERSION_8812F)) {
		if(priv->pshare->rf_ft_var.ap_coexist_enable) {
			if (priv->pshare->rtk_ap_detected_to) {
				priv->pshare->rtk_ap_detected_to--;
			}

			if((GET_CHIP_VER(priv) == VERSION_8192F) && !priv->pshare->rf_ft_var.adaptivity_enable) {
				if (priv->pshare->rssi_min >= 65){					
					if (priv->pshare->interf_mode == false) {
						priv->pshare->interf_mode = true;
						phy_set_bb_reg(priv, 0xc4c, MASKBYTE0, 0x48);
						phy_set_bb_reg(priv, 0xc4c, MASKBYTE2, 0x40);
					}
				} else {
					if (priv->pshare->interf_mode == true) {
						priv->pshare->interf_mode= false;
						phy_set_bb_reg(priv, 0xc4c, MASKBYTE0, 0x7f);
						phy_set_bb_reg(priv, 0xc4c, MASKBYTE2, 0x7f);
					}
				}
			}
		}
	}
#endif

	if(IS_ROOT_INTERFACE(priv)){
		if(priv->site_survey->unassoc_sta_count == 1){
			if (priv->pmib->dot11StationConfigEntry.unassoc_sta_scan_ongoing) {
				if(priv->pmib->dot11StationConfigEntry.unassoc_sta_scan_ongoing == 1)
					RTL_W32(RCR,priv->site_survey->RCR_backup);
				priv->pmib->dot11StationConfigEntry.unassoc_sta_scan_ongoing = 0;
				priv->site_survey->target_channel = 0;
				DEBUG_INFO("STA scan req finish\n");
			}
		}
		if(priv->site_survey->unassoc_sta_count > 0){
			DEBUG_INFO("unassoc_sta_count = %d\n",priv->site_survey->unassoc_sta_count);
			priv->site_survey->unassoc_sta_count--;
		}
		
	}
#ifdef  SUPPORT_TX_MCAST2UNI
	int idx;
	for (idx=0; idx<MAX_UNKNOWN_MC_ENTRY; idx++) {
		priv->unknown_others_mc_pkt = 0;
		priv->unknown_mc[idx].mc_pkts = 0;
		if (priv->unknown_mc[idx].timeout > 0) {
			priv->unknown_mc[idx].timeout--;
			if (priv->unknown_mc[idx].timeout == 0)
				memset(priv->unknown_mc[idx].mcaddr, 0, 6);
		}

	}
#endif

#ifdef SMART_ADAPTIVE_ANT
        if (GET_CHIP_VER(priv) == VERSION_8814B) {
            if (priv->pmib->dot11RFEntry.adaptive_ant_dbg == 2) {
                priv->pmib->dot11RFEntry.adaptive_ant_dbg = 0;
                config_phydm_trx_mode_8814b(ODMPTR, BB_PATH_ABCD, BB_PATH_ABCD); 
                printk("%s: Switch to 4T4R\n", __FUNCTION__);
            }
            if (priv->pmib->dot11RFEntry.adaptive_ant_dbg == 1) {
                priv->pmib->dot11RFEntry.adaptive_ant_dbg = 0;
                config_phydm_trx_mode_8814b(ODMPTR, BB_PATH_AB, BB_PATH_AB); 
                printk("%s: Switch to 2T2R\n", __FUNCTION__);
            }

        }
#endif

#ifdef CONFIG_WLAN_HAL_8814BE
#if (MU_BEAMFORMING_SUPPORT == 1)
#if defined(UNIVERSAL_REPEATER) || defined(MBSSID)
	if (IS_ROOT_INTERFACE(priv))
#endif
	if (priv->pshare->rf_ft_var.mu_hotfix) {
		unsigned char group_idx = 0;
		struct _RT_BEAMFORMING_INFO* pBeamformingInfo = &(priv->pshare->BeamformingInfo);
		if((GET_CHIP_VER(priv) == VERSION_8814B) &&
			(priv->pshare->WlanSupportAbility & WLAN_BEAMFORMING_SUPPORT) &&
			(priv->pmib->dot11RFEntry.txbf == 1) &&
			(priv->pmib->dot11RFEntry.txbf_mu == 1)) {
			if ((pBeamformingInfo->beamformee_mu_cnt > 1) && (priv->up_time % 5 == 0)) {
#if 0
				RTL_W16(0x140, 0x660);
				group_idx = RTL_R8(0x8042);
				if (group_idx != 0x4)
					RTL_W8(0x8042, 0x4);
#else
                if(!VERSION_8814C) {
                	#define RPT_CTRL_INFO           0x18660000

                	unsigned long val32;
                
                	INDIRECT_READ(RPT_CTRL_INFO + 64, val32);
                	if (((val32 >> 16) & 0xff) != 0x4) {
                    		val32 = (val32 & 0xff00ffff) | (0x4 << 16);
                    		INDIRECT_WRITE(RPT_CTRL_INFO + 64, val32);
                	}
                }
#endif
			}
		}
	}
#endif
#endif

#ifdef SMART_ADAPTIVE_ANT
#if defined(CONFIG_WLAN_HAL_8814BE)
	if (GET_CHIP_VER(priv) == VERSION_8814B &&
		priv->pmib->dot11RFEntry.adaptive_ant)
	{
		unsigned int val;

		if (IS_ROOT_INTERFACE(priv)) {
			val = orSTABitMap(&priv->pshare->ant_Bitmap);
			if (!priv->pshare->ant_flag && !val && (priv->pshare->rssi_min < priv->pmib->dot11RFEntry.adaptive_ant_rssi)) {
				priv->pshare->ant_flag = 1;
				printk("%s: Switch to 4T4R\n", __FUNCTION__);
				config_phydm_trx_mode_8814b(ODMPTR, BB_PATH_ABCD, BB_PATH_ABCD);
			}	
			else if (priv->pshare->ant_flag && !val && (priv->pshare->rssi_min >= (priv->pmib->dot11RFEntry.adaptive_ant_rssi+priv->pmib->dot11RFEntry.adaptive_ant_tolerance)) && !priv->ant_adapt_mu) {
				priv->pshare->ant_flag = 0;
				printk("%s: Switch to 2T2R\n", __FUNCTION__);
				config_phydm_trx_mode_8814b(ODMPTR, BB_PATH_AB, BB_PATH_AB);
			}
		}
	}	
#endif
#endif

	RESTORE_INT(flags);
	SMP_UNLOCK(flags);
}


/*
 *	@brief	System 1 sec timer
 *
 *	@param	task_priv: priv
 *
 *	@retval	void
 */
#if defined(CONFIG_PCI_HCI)
#ifdef CONFIG_RTL_PCIE_LINK_PROTECTION
	extern void  check_pcie_link_status(void);
#endif
// #define CHECK_CRYPTO
#ifdef THERMAL_PROTECTION
#define DBG_THERMAL_PRO
#define MAX_THERMAL_MARK 63
#define MAX_HIT_COUNTER 10
#define DECREASE_POWER_ACTION 0x8814
#define RETRY_COUNT 60*10
#define NO_ACTION 0
extern int degrade_power(struct rtl8192cd_priv *priv, unsigned char action, unsigned char level);

int rtl8192cd_thermal_value(struct rtl8192cd_priv *priv)
{
	
	phy_set_rf_reg(priv, RF_PATH_A, 0x42, BIT(17), 0x1);

	 return 0;
	 
	 

}
int rtl8192cd_thermal_value_s2(struct rtl8192cd_priv *priv)
{
	int ther=0;
	
	 ther = phy_query_rf_reg(priv, RF_PATH_A, 0x42, 0xfc00, 1);
	 return ther;
	 
	 

}

void rtl8192cd_thermal_protection(struct rtl8192cd_priv *priv)
{
	int ther_val=0;
	if (!(priv->drv_state & DRV_STATE_OPEN))
		return;

	if(priv->read_flag !=0x1234)		
	{			rtl8192cd_thermal_value(priv);			
				priv->read_flag =0x1234;			
				return;		
	}		
	else
	{			
		ther_val= rtl8192cd_thermal_value_s2(priv);			
		priv->read_flag =0;		
	}	
	if(ther_val >= MAX_THERMAL_MARK)
	{
		if(priv->thermal_fireoff != DECREASE_POWER_ACTION)  //stage 1
		{
				priv->thermal_hit_counter++;
				if(priv->thermal_hit_counter > MAX_HIT_COUNTER)
				{
					degrade_power(priv,2,4); //decrease 12dB
					priv->thermal_fireoff=DECREASE_POWER_ACTION;
					#ifdef DBG_THERMAL_PRO
					panic_printk("%s TP:3=>Take Action to Decrease Power\r\n",priv->dev->name);
					#endif
					
				}
				else
				{
					#ifdef DBG_THERMAL_PRO
					panic_printk("%s TP:2->%d\r\n",priv->dev->name,ther_val);
					#endif
					return;
				}
		}
		else //stage 2
		{
			if(priv->thermal_hit_counter > (MAX_HIT_COUNTER+RETRY_COUNT))
			{
				//Disable The WLAN foreever;
				panic_printk("%s TP:5=>Disable The WLAN foreever\r\n",priv->dev->name);
				rtl8192cd_close(priv->dev);

				
			}
		}
		
	}
	else
	{	
		if(priv->thermal_fireoff != DECREASE_POWER_ACTION) //stage 1
		{
			priv->thermal_hit_counter=0;
			#ifdef DBG_THERMAL_PRO
			panic_printk("%s TP:0->%d\r\n",priv->dev->name,ther_val);
			#endif
			return;
		}
		else
		{
			priv->thermal_hit_counter--;
			if(priv->thermal_hit_counter ==1)
			{
				degrade_power(priv,0,0); //reset to original Tx power index
				priv->thermal_fireoff = NO_ACTION;
				#ifdef DBG_THERMAL_PRO
				panic_printk("%s TP:4 ==> Reset Tx power\r\n",priv->dev->name);
				#endif
			}
		}
	}
}
#endif // THERMAL_PROTECTION

static __always_inline void rtl8192cd_1sec_timer_pci(struct rtl8192cd_priv *priv)
{
#ifdef CHECK_CRYPTO
	unsigned long	flags;
#endif

	if (!(priv->drv_state & DRV_STATE_OPEN))
		return;

#ifdef PCIE_POWER_SAVING_TEST //yllin
	if ((priv->pwr_state >= L2) || (priv->pwr_state == L1)) {
		goto expire_timer;
	}
#endif

#ifdef PCIE_POWER_SAVING
	if ((priv->pwr_state == L2) || (priv->pwr_state == L1)) {
		goto expire_timer;
	}
#endif

#if defined(CONFIG_VERIWAVE_CHECK)
	if(priv->pshare->vw_dig_cnt > 0) {
		priv->pshare->vw_dig_cnt--;
	}
#endif

//Unlock TXPAUSE BCN for 8822B after timeout reached
	if(priv->pshare->rf_ft_var.lock5d1 &&
	  (GET_CHIP_VER(priv) == VERSION_8822B || GET_CHIP_VER(priv) == VERSION_8198F || GET_CHIP_VER(priv) == VERSION_8814B || GET_CHIP_VER(priv) == VERSION_8812F))
	if(((priv->up_time +1) >= priv->pshare->rf_ft_var.lock5d1) && (RTL_R8(0x5d1) != 0)){
		RTL_W8(0x5d1, RTL_R8(0x5d1) & ~STOP_BCN);
	}

#ifdef CONFIG_PCI_HCI
#ifdef  CONFIG_WLAN_HAL
	if (!IS_HAL_CHIP(priv)) 
#endif
#if defined(CONFIG_RTL_8812_SUPPORT) || defined(CONFIG_RTL_8723B_SUPPORT)
	if(GET_CHIP_VER(priv)!= VERSION_8812E && GET_CHIP_VER(priv)!= VERSION_8723B)
#endif
	if (!(priv->up_time % 5))
	tx_stuck_fix(priv);
#endif // CONFIG_PCI_HCI

// 2009.09.08
#ifdef CHECK_HANGUP
#ifdef MP_TEST
	if (!((OPMODE & WIFI_MP_STATE) || priv->pshare->rf_ft_var.mp_specific))
#endif
		if (check_hangup(priv))
			return;
#endif

#ifdef CHECK_CRYPTO
    // TODO: Filen, Check code below for 8881A & 92E
	if(GET_CHIP_VER(priv) != VERSION_8192D)        
		if((RTL_R32(0x6B8) & 0x3) == 0x3) {
			DEBUG_ERR("Cyrpto checked\n");
			SAVE_INT_AND_CLI(flags);
			RTL_W8(0x522, 0x0F);
			RTL_W8(0x6B8, 0xFF);
			RTL_W8(0x101,0x0);
			RTL_W8(0x21,0x35);
			delay_us(250);
			RTL_W8(0x101,0x02);
			RTL_W8(0x522,0x0);
			RESTORE_INT(flags);
		}
#endif

#ifdef SMP_SYNC
	priv->pshare->expire_timer_cpuid = smp_processor_id();
#endif

	// for Rx dynamic tasklet
#if defined(CONFIG_RTL8672) || defined(NOT_RTK_BSP)
	priv->pshare->rxInt_useTsklt = TRUE;
#else
	if (priv->pshare->rxInt_data_delta > priv->pmib->miscEntry.rxInt_thrd)
		priv->pshare->rxInt_useTsklt = TRUE;
	else
		priv->pshare->rxInt_useTsklt = FALSE;
#endif
	priv->pshare->rxInt_data_delta = 0;

#ifdef PCIE_POWER_SAVING
expire_timer:
#endif

#ifdef __KERNEL__
	tasklet_schedule(&priv->pshare->oneSec_tasklet);
#else
	rtl8192cd_expire_timer((unsigned long)priv);
#endif

#ifdef PCIE_POWER_SAVING_TEST
expire_timer:
#endif


#ifdef P2P_SUPPORT/*cfg p2p cfg p2p*/
	if (rtk_p2p_is_enabled(priv)==PROPERTY_P2P)
		P2P_1sec_timer(priv);
#endif

#ifdef CONFIG_RTL_WLAN_DOS_FILTER
	if ((block_sta_time > 0) && (block_priv == (unsigned long)priv))
	{
		block_sta_time--;
	}
#endif

////////////////////////////////////////////////////////////////////
	//patch for reboot issues
	if(GET_CHIP_VER(priv) == VERSION_8812E)
	{	
		RTL_W32(0x1c,0x7FEF922);
		RTL_W32(0x1c,0x7FEF962);
		
	}	
////////////////////////////////////////////////////////////////////

#ifdef CMCC_CTC_QOS
	if (priv->pshare->force_qos_timeout > 0)
		priv->pshare->force_qos_timeout--;
#endif


#ifdef THERMAL_PROTECTION
 rtl8192cd_thermal_protection(priv);
#endif
#ifdef CONFIG_RTL_PCIE_LINK_PROTECTION
	check_pcie_link_status();
#endif
	rtk_mod_timer(&priv->expire_timer, jiffies + EXPIRE_TO);
}
#endif
#if defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI)
#ifdef SDIO_STATISTICS
void update_sdio_statistics(struct rtl8192cd_priv *priv)
{
	struct priv_shared_info *pshare = priv->pshare;
	unsigned long diff_time;
	int i;
	
	diff_time = jiffies - pshare->statistic_update_time;
	pshare->statistic_update_time = jiffies;
	
	for (i = 0; i < MAX_XMITBUF_PKT; ++i) {
#ifdef SDIO_STATISTICS_TIME
		if (pshare->writeport_total_count[i])
			pshare->writeport_avg_time[i] = pshare->writeport_total_time[i] /pshare->writeport_total_count[i];
		else
			pshare->writeport_avg_time[i] = 0;
		pshare->writeport_total_time[i] = 0;
#endif
		pshare->writeport_avg_count[i] = pshare->writeport_total_count[i];
		pshare->writeport_total_count[i] = 0;
	}
}
#endif

static __always_inline void pre_rtl8192cd_1sec_timer(unsigned long task_priv)
{
	struct rtl8192cd_priv *priv = (struct rtl8192cd_priv *)task_priv;

	if (!(priv->drv_state & DRV_STATE_OPEN))
		return;

	if ((priv->pshare->bDriverStopped) || (priv->pshare->bSurpriseRemoved)) {
		printk("[%s] bDriverStopped(%d) OR bSurpriseRemoved(%d)\n",
			__FUNCTION__, priv->pshare->bDriverStopped, priv->pshare->bSurpriseRemoved);
		return;
	}

	rtw_enqueue_timer_event(priv, &priv->expire_timer_event, ENQUEUE_TO_TAIL);

#ifdef SDIO_STATISTICS
	update_sdio_statistics(priv);
#endif
}
DEFINE_TIMER_CALLBACK(pre_rtl8192cd_1sec_timer);

#ifdef CONFIG_POWER_SAVE
void rtl8192cd_offload_expire_timer(struct rtl8192cd_priv *priv)
{
	struct list_head *phead, *plist;
	struct stat_info *pstat;
	unsigned long flags = 0;
	int i, wakeup = 0;

	phead = &priv->asoc_list;
	
	SMP_LOCK_ASOC_LIST(flags);
	
	plist = phead->next;
	while (plist != phead) {
		pstat = list_entry(plist, struct stat_info, asoc_list);
		plist = plist->next;

		if (pstat->expire_to > 1)
			pstat->expire_to--;
		else if (pstat->expire_to == 1)
			wakeup = 1;

		if(priv->pshare->rf_ft_var.fix_expire_to_zero == 1) {
			pstat->expire_to = 0;
			priv->pshare->rf_ft_var.fix_expire_to_zero = 0;
		}
	}
	
	SMP_UNLOCK_ASOC_LIST(flags);
	
	if (priv->pshare->pwr_state == RTW_STS_SUSPEND && wakeup) {
		DEBUG_INFO("[%s,%d] STA expired time = 1, need resume driver to update aid map.\n", __FUNCTION__, __LINE__);
		priv->pshare->pwr_state = RTW_STS_NORMAL;
		priv->pshare->ps_ctrl = RTW_ACT_IDLE;
		schedule_work(&GET_ROOT(priv)->ap_cmd_queue);
	}

	if (IS_ROOT_INTERFACE(priv)) {
#ifdef UNIVERSAL_REPEATER
		if (GET_VXD_PRIV(priv) && netif_running(GET_VXD_PRIV(priv)->dev)) {
			rtl8192cd_offload_expire_timer(GET_VXD_PRIV(priv));
		}
#endif
#ifdef MBSSID
		if (priv->pmib->miscEntry.vap_enable) {
			for (i=0; i<RTL8192CD_NUM_VWLAN; i++) {
				if (IS_DRV_OPEN(priv->pvap_priv[i]))
					rtl8192cd_offload_expire_timer(priv->pvap_priv[i]);
			}
		}
#endif
	}
}
#endif // CONFIG_POWER_SAVE

static __always_inline void rtl8192cd_1sec_timer_usb_sdio(struct rtl8192cd_priv *priv)
{
	if (!(priv->drv_state & DRV_STATE_OPEN))
		return;

#ifdef SDIO_AP_OFFLOAD
	if (priv->pshare->offload_function_ctrl) {
#ifdef CONFIG_POWER_SAVE
		if (priv->pshare->total_assoc_num)
			rtl8192cd_offload_expire_timer(priv);
#endif
		goto out;
	}
#endif

#ifdef CHECK_HANGUP
	if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE) {
#ifdef MP_TEST
		if (!((OPMODE & WIFI_MP_STATE) || priv->pshare->rf_ft_var.mp_specific))
#endif
			if (check_hangup(priv))
				return;
	}
#endif

	rtl8192cd_expire_timer((unsigned long)priv);

#ifdef P2P_SUPPORT
	if (rtk_p2p_is_enabled(priv)==PROPERTY_P2P)
		P2P_1sec_timer(priv);
#endif

out:
	rtk_mod_timer(&priv->expire_timer, jiffies + EXPIRE_TO);
}
#endif // (CONFIG_USB_HCI || CONFIG_SDIO_HCI)

void rtl8192cd_1sec_timer(unsigned long task_priv)
{
	struct rtl8192cd_priv *priv = (struct rtl8192cd_priv *)task_priv;

#if defined(CONFIG_PCI_HCI)
	if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE) {
		rtl8192cd_1sec_timer_pci(priv);
	} else
#endif
#if defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI)
	{
		rtl8192cd_1sec_timer_usb_sdio(priv);
	}
#endif
	;
}
DEFINE_TIMER_CALLBACK(rtl8192cd_1sec_timer);

void init_expire_timer(struct rtl8192cd_priv *priv)
{
#if defined(CONFIG_PCI_HCI)
	if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE) {
		rtk_timer_setup(&(priv->expire_timer), rtl8192cd_1sec_timer, (unsigned long)priv, 0);
	} else
#endif
#if defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI)
	{
		rtk_timer_setup(&(priv->expire_timer), pre_rtl8192cd_1sec_timer, (unsigned long)priv, 0);
		INIT_TIMER_EVENT_ENTRY(&priv->expire_timer_event, rtl8192cd_1sec_timer, (unsigned long)priv);
	}
#endif
	;
}

#if !defined(__LINUX_2_6__) && !defined(__ECOS)  && !defined(__OSK__)
__IRAM_IN_865X
#endif
void pwr_state(struct rtl8192cd_priv *priv, struct rx_frinfo *pfrinfo)
{
#ifndef SMP_SYNC
    unsigned long	flags;
#endif
    struct stat_info *pstat;
    unsigned char	*sa, *pframe;
    unsigned char   PwrMgt;
#ifdef HW_DETEC_POWER_STATE    
    unsigned char result,i;
#endif

    pframe = get_pframe(pfrinfo);
    sa = pfrinfo->sa;
    pstat = get_stainfo(priv, sa);

    if (pstat == (struct stat_info *)NULL)
        return;

    if (!(pstat->state & WIFI_ASOC_STATE))
        return;

    #ifdef HW_DETEC_POWER_STATE              
    if (IS_SUPPORT_HW_DETEC_POWER_STATE(priv)) {    
        if (RT_STATUS_SUCCESS == GET_HAL_INTERFACE(priv)->CheckHWMACIDResultHandler(priv,pfrinfo->macid,&result)) {
        if(HWMACID_RESULT_SUCCESS == result)    {
            // hw detect ps state change return
            return;
        }
    }
    #ifdef HW_DETEC_POWER_STATE_PATCH
        if(HWMACID_RESULT_NOT_READY == result){ 
        
            DEBUG_WARN("%s %d HW_MACID_SEARCH_NOT_READY\n",__FUNCTION__,__LINE__);
            
        }
        if(HWMACID_RESULT_FAIL == result){ 
        
            DEBUG_WARN("%s %d HW_MACID_SEARCH_FAIL\n",__FUNCTION__,__LINE__);
            
        }
    #endif //#ifdef HW_DETEC_POWER_STATE_PATCH    
    }
    #endif //    #ifdef HW_DETEC_POWER_STATE                 
	
#if defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI)
	if (GET_HCI_TYPE(priv) == RTL_HCI_USB || GET_HCI_TYPE(priv) == RTL_HCI_SDIO) {
		local_bh_disable();
	}
#endif

#ifdef CONFIG_RTL_OFFLOAD_DRIVER
    if (OFFLOAD_ENABLE(priv)) {
        if (pfrinfo->rxpkt_info->pkt_type == RXPKTINFO_TYPE_8023
            || pfrinfo->rxpkt_info->pkt_type == RXPKTINFO_TYPE_AMSDU) {
            PwrMgt = GetPwrMgt(pfrinfo->rxpkt_info->frame_ctrl);
        } else
            PwrMgt = GetPwrMgt(pframe);
    }
    else
#endif
    {
        PwrMgt = GetPwrMgt(pframe);
    }

    if (PwrMgt)
    {

#if defined(CONFIG_VERIWAVE_CHECK)
#ifdef CONFIG_WLAN_HAL_8814BE
		if (GET_CHIP_VER(priv) != VERSION_8814B)
#endif
		if((pfrinfo->pktlen+_CRCLNG_)==32){
			unsigned int crc = 0;
			crc = rtk_crc32( pframe, pfrinfo->pktlen);
			crc = le32_to_cpu(crc);
			if(memcmp((void*)&crc, (void*)pframe+pfrinfo->pktlen, 4)){
				printk("[%s %d] CRC error!!\n", __FUNCTION__, __LINE__);
#ifdef _DEBUG_RTL8192CD_
				mem_dump("Pwr State CRC error", pframe, pfrinfo->pktlen+4);
#endif
				return;
			}
		}
#endif
        if ((pstat->state & WIFI_SLEEP_STATE) == 0) {
            pstat->state |= WIFI_SLEEP_STATE;
#if defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI)
			if (GET_HCI_TYPE(priv) == RTL_HCI_USB || GET_HCI_TYPE(priv) == RTL_HCI_SDIO) {
            	pstat->sleep_time = jiffies;
			}
#endif
#ifdef CONFIG_PCI_HCI
			if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE) {
	            if(CHIP_VER_92X_SERIES(priv))
	            {
	                if (pstat == priv->pshare->highTP_found_pstat) {
	                    if (priv->pshare->txpause_pstat == NULL) {
	                        RTL_W8(TXPAUSE, RTL_R8(TXPAUSE)|STOP_BE|STOP_BK);

	                        priv->pshare->txpause_time = jiffies;
	                        priv->pshare->txpause_pstat = pstat;

	                    }
	                }
	            }
			}
#endif // CONFIG_PCI_HCI

            if (!pstat->cmn_info.ra_info.disable_ra)
            {


#ifdef CONFIG_WLAN_HAL
                if(IS_HAL_CHIP(priv))
                {
#ifdef HW_DETECT_PS_OFFLOAD
                    GET_HAL_INTERFACE(priv)->MACIDPauseHandler(priv, REMAP_AID(pstat), 1);
                    //GET_HAL_INTERFACE(priv)->APPSOffloadMACIDPauseHandler(priv, pstat->cmn_info.aid, 1);   
                    
#else                
                    DEBUG_WARN("[%s][%s][%d] client into ps, Pwr_state jiffies = %lu\n",
                        __FUNCTION__, priv->dev->name, pstat->cmn_info.aid, jiffies);
                    GET_HAL_INTERFACE(priv)->SetMACIDSleepHandler(priv, 1, REMAP_AID(pstat)); 
#endif
#ifndef STA_AGING_FUNC_OFFLOAD   
					if(pstat->txpause_flag ==0){
						priv->pshare->paused_sta_num++;	
						pstat->cnt_sleep ++; 
					}
#endif
                    pstat->txpause_time = jiffies;                 
                    pstat->txpause_flag = 1;
					
#if defined(AP_SWPS_OFFLOAD)
                    if (IS_SUPPORT_AP_SWPS_OFFLOAD(priv)) {
                        //ReadQinfo(priv,REMAP_AID(pstat),0); 

                        if(pstat->Drop_ID==3)
                            pstat->Drop_ID=0;
                        else
                            pstat->Drop_ID++;
                        DEBUG_ERR("SWPS HW detect power state INT loss!!! drop id may be wrong.\n");
                        //switch to flag 0/1 to distinqish different sleep time of prepare ok
                        if(pstat->next_prepare_ok == 0){
                            if(pstat->process_dz_ok==1)
                                printk("not prepare done when wakeup, now goto sleep again, state machine may go wrong.\n");//debug
                            else
                                pstat->next_prepare_ok = 1;
                        }
                        else{
                            if(pstat->process_dz_ok==1)
                                pstat->next_prepare_ok = 0;
                            else
                                printk("not prepare done when wakeup, now goto sleep again, state machine may go wrong.\n");//debug
                        }
                    }
#if 0   //change to do it at receive SWPS report
                    for(i=0;i<4;i++){
                        
                            if(pstat->SWPS_seq[i]==1)
                                pstat->SWPS_last_seq[i]=4095;
                            else
                                pstat->SWPS_last_seq[i]=pstat->SWPS_seq[i]-1;
                        
                    }
#endif                    
#endif
					
#ifdef MULTI_STA_REFINE					
					if( priv->pshare->paused_sta_num > (MAXPAUSEDSTA<<((priv->ext_stats.tx_avarage>>19)?0:1))) { 
						{
							struct list_head	*phead = &(priv->sleep_list), *plist=phead;		
							struct stat_info *pstatd = pstat, *pstat2;
							while ((plist = plist->next) != phead)
							{
								pstat2 = list_entry(plist, struct stat_info, sleep_list);
								if(pstat2->txpause_flag && (pstat2->dropPktCurr) < (pstatd->dropPktCurr))
									pstatd = pstat2;									
								if (plist == plist->next)
									break;							
							}
							if(pstatd) {
								GET_HAL_INTERFACE(priv)->UpdateHalMSRRPTHandler(priv, pstatd, DECREASE);
								pstatd->txpdrop_flag = 1;							
								GET_HAL_INTERFACE(priv)->SetMACIDSleepHandler(priv, 0, REMAP_AID(pstatd));	
								pstatd->txpause_flag = 0;
								if(priv->pshare->paused_sta_num)
									priv->pshare->paused_sta_num--;
								priv->pshare->unlock_counter1++; 	
								pstatd->dropPktCurr ++;	
							}
						}
				}
#endif

                } else
#endif
#if defined(CONFIG_RTL_8812_SUPPORT) || defined(CONFIG_RTL_8723B_SUPPORT)
                if (GET_CHIP_VER(priv)==VERSION_8812E || GET_CHIP_VER(priv)==VERSION_8723B) {
                    RTL8812_MACID_PAUSE(priv, 1, REMAP_AID(pstat));
					if(pstat->txpause_flag ==0){
						priv->pshare->paused_sta_num++;						
						pstat->cnt_sleep ++; 
					}
                    pstat->txpause_time = jiffies;
                    pstat->txpause_flag = 1;
#ifdef MULTI_STA_REFINE					
					if( priv->pshare->paused_sta_num > (MAXPAUSEDSTA<<((priv->ext_stats.tx_avarage>>19)?0:1))) { 
						struct list_head	*phead = &(priv->sleep_list), *plist=phead;		
						struct stat_info *pstatd = pstat, *pstat2;
						while ((plist = plist->next) != phead) {
							pstat2 = list_entry(plist, struct stat_info, sleep_list);
							if(pstat2->txpause_flag && (pstat2->dropPktCurr) < (pstatd->dropPktCurr))
								pstatd = pstat2;									
							if (plist == plist->next)
								break;							
						}
						if(pstatd) {
							UpdateHalMSRRPT8812(priv, pstatd, DECREASE);											
							pstatd->txpdrop_flag = 1;							
							RTL8812_MACID_PAUSE(priv, 0, REMAP_AID(pstatd));
							pstatd->txpause_flag = 0;
							if(priv->pshare->paused_sta_num)
								priv->pshare->paused_sta_num--;
							pstatd->dropPktCurr ++;	
						}
					}
#endif					
                } else
#endif
#ifdef CONFIG_RTL_88E_SUPPORT
                if (GET_CHIP_VER(priv)==VERSION_8188E) {
                    RTL8188E_MACID_PAUSE(priv, 1, REMAP_AID(pstat));
                    pstat->txpause_time = jiffies;
                    pstat->txpause_flag = 1;
                } else
#endif
                {
#if defined(CONFIG_RTL_92D_SUPPORT) || defined(CONFIG_RTL_92C_SUPPORT)				
                    add_update_ps(priv, pstat);
#endif
                }
            }
        }

        SAVE_INT_AND_CLI(flags);
        if (wakeup_list_del(priv, pstat)) {
            DEBUG_INFO("Del fr wakeup_list %pm\n",sa);
        }
        if (sleep_list_add(priv, pstat)) {
            DEBUG_INFO("Add to sleep_list %pm\n",sa);
        }
        RESTORE_INT(flags);

#if defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI)
		if (GET_HCI_TYPE(priv) == RTL_HCI_USB || GET_HCI_TYPE(priv) == RTL_HCI_SDIO) {
        	stop_sta_xmit(priv, pstat);
		}
#endif
    } else {
        pwr_un_sleep(priv, pstat);
		
        SAVE_INT_AND_CLI(flags);
        if (sleep_list_del(priv, pstat)) {
            DEBUG_INFO("Del fr sleep_list %pm\n",sa);
        }
        RESTORE_INT(flags);

#if defined(CONFIG_PCI_HCI)
		if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE) {
	        if ((skb_queue_len(&pstat->dz_queue))
#ifdef WIFI_WMM
#ifdef WMM_APSD
	                ||(
#ifdef CLIENT_MODE
	                (OPMODE & WIFI_AP_STATE) &&
#endif
	                (QOS_ENABLE) && (APSD_ENABLE) && (pstat->QosEnabled) && (pstat->apsd_pkt_buffering) &&
	                ((!isFFempty(pstat->VO_dz_queue->head, pstat->VO_dz_queue->tail)) ||
	                (!isFFempty(pstat->VI_dz_queue->head, pstat->VI_dz_queue->tail)) ||
	                (!isFFempty(pstat->BE_dz_queue->head, pstat->BE_dz_queue->tail)) ||
	                (!isFFempty(pstat->BK_dz_queue->head, pstat->BK_dz_queue->tail))))
#endif
	                || (!isFFempty(pstat->MGT_dz_queue->head, pstat->MGT_dz_queue->tail))
#ifdef DZ_ADDBA_RSP
	                || pstat->dz_addba.used
#endif
#endif
	        ) {
	            SAVE_INT_AND_CLI(flags);
	            if (wakeup_list_add(priv, pstat)) {
	                DEBUG_INFO("Add to wakeup_list %pm\n", sa);
	            }
	            RESTORE_INT(flags);
	        }
	    }
#endif
#if defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI)
		if (GET_HCI_TYPE(priv) == RTL_HCI_USB || GET_HCI_TYPE(priv) == RTL_HCI_SDIO) {
        	wakeup_sta_xmit(priv, pstat);
		}
#endif

		if(pstat && pstat->delsta_flag) {
			del_station(priv, pstat, DEL_STA_SEND_DISASSOC, _RSON_DISASSOC_DUE_BSS_TRANSITION);
			pstat->delsta_flag =0;
		}
    }
	
#if defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI)
	if (GET_HCI_TYPE(priv) == RTL_HCI_USB || GET_HCI_TYPE(priv) == RTL_HCI_SDIO) {
		local_bh_enable();
	}
#endif

#if defined(CONFIG_WLAN_HAL) && defined(CONFIG_PCI_HCI)
	if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE) {
		if(IS_HAL_CHIP(priv))
			check_PS_set_HIQLMT(priv);
	}
#endif
	return;
}

#if defined(AP_SWPS_OFFLOAD)
int SWPS_check_reprepare_done(
    struct rtl8192cd_priv *priv,
    struct stat_info * pstat
)
{
    unsigned char prepare_done = 0;
    unsigned char qos_i = 0;

    if (!IS_SUPPORT_AP_SWPS_OFFLOAD(priv))
        return _TRUE;

    if(pstat->process_dz_ok == pstat->next_prepare_ok)
        return _TRUE;
    
        
        if((pstat->SWPS_last_seq[0]==0) || (pstat->SWPS_last_seq[1]==0) || (pstat->SWPS_last_seq[2]==0) || (pstat->SWPS_last_seq[3]==0)){
            if(pstat->SWPS_last_seq[0]==0)
                pstat->prepare_done[0]=1;
            if(pstat->SWPS_last_seq[1]==0)
                pstat->prepare_done[1]=1;
            if(pstat->SWPS_last_seq[2]==0)
                pstat->prepare_done[2]=1;
            if(pstat->SWPS_last_seq[3]==0)
                pstat->prepare_done[3]=1;
        }
        //printk("prepare_done[0]=%x, prepare_done[1]=%x, prepare_done[2]=%x, prepare_done[3]=%x\n",pstat->prepare_done[0],pstat->prepare_done[1],pstat->prepare_done[2],pstat->prepare_done[3]);
        if(pstat->prepare_done[0] && pstat->prepare_done[1] && pstat->prepare_done[2] && pstat->prepare_done[3]){ 
            prepare_done = 1;
        }

    if(prepare_done){

        if(pstat->next_prepare_ok==1)
            pstat->process_dz_ok = 1; 
        else
            pstat->process_dz_ok = 0;
        
        for(qos_i=0;qos_i<4;qos_i++){
            pstat->RPT_reprepare_SEQ[qos_i]=0;
            pstat->SWPS_last_seq[qos_i]=0; 
            pstat->prepare_done[qos_i]=0;
            //printk("[%s]reset SWPS_last_seq\n",__FUNCTION__);
        }
        return _TRUE;
    }else
        return _FALSE;

}
int SWPS_check_drop_done( //check when wakeup, need to be cleared in 4 sleep/wakeup time
    struct stat_info * pstat
)
{
    unsigned char drop_done = 0;
    unsigned char pkt_Qos;
    
    for(pkt_Qos=0;pkt_Qos<4;pkt_Qos++){
        if(pstat->SWPS_last_seq[pkt_Qos]==0)// no pkt to drop, means no pkt to reprepare too
            drop_done++;
        else if(pstat->RPT_DropByID_SEQ[pkt_Qos]==pstat->SWPS_last_seq[pkt_Qos])
            drop_done++;
    }
    if(drop_done==4){
        //cant reset here, SWPS_last_seq will be used when reprepare packet
        //for(pkt_Qos=0;pkt_Qos<4;pkt_Qos++)
        //    pstat->SWPS_last_seq[pkt_Qos]=0; //reset
        pstat->check_drop_done=0;
        return TRUE;
    }
    else{
    //debug
        pstat->check_drop_done++;
        GDEBUG("SWPS: not drop done when wakeup. times=%d\n",pstat->check_drop_done);
        GDEBUG("the drop bit in ctrl info = 0x%x\n",pstat->RPT_DropBit);
    }
    return FALSE;
    
}
#endif

#ifdef HW_DETEC_POWER_STATE
void detect_hw_pwr_state(struct rtl8192cd_priv *priv, unsigned char macIDGroup)
{
    unsigned char i,newPwrBit,oldPwrBit;
    unsigned int  pwr;    

    switch(macIDGroup)
    {
    case 0:
        GET_HAL_INTERFACE(priv)->GetHwRegHandler(priv, HW_VAR_HW_PS_STATE0, (pu1Byte)&pwr);                 
    break;        
    case 1:
        GET_HAL_INTERFACE(priv)->GetHwRegHandler(priv, HW_VAR_HW_PS_STATE1, (pu1Byte)&pwr);   
    break;
    case 2:
        GET_HAL_INTERFACE(priv)->GetHwRegHandler(priv, HW_VAR_HW_PS_STATE2, (pu1Byte)&pwr);   
    break;
    case 3:
        GET_HAL_INTERFACE(priv)->GetHwRegHandler(priv, HW_VAR_HW_PS_STATE3, (pu1Byte)&pwr);   
    break;
    }

    // check PS change                     
    for(i=0;i<32;i++)
    {
        // getHWPwrStateHander
        
        newPwrBit= (pwr & BIT(i))>>i;
        oldPwrBit = (priv->pshare->HWPwroldState[macIDGroup] & BIT(i))>>i;
        if(newPwrBit != oldPwrBit)        
        {
#ifndef CONFIG_8814_AP_MAC_VERI     

      //      printk("[%s][%d] MACID%x HW PS0=%x Seq=%x \n",
      //                     __FUNCTION__,__LINE__,i+(macIDGroup<<5),newPwrBit,RTL_R16(0x1152));

            pwr_state_enhaced(priv,i+(macIDGroup<<5),newPwrBit);
            #if IS_EXIST_RTL8192FE
			if (IS_HARDWARE_TYPE_8192FE(priv)) {
            	RTL_W8(0x728,(i+(macIDGroup<<5)) & 0x7F | BIT7);   // set for sw test
			}
			else
			#endif
			   RTL_W8(0x1150,1);   //98F setting     
            printk("[%s][%d] MACID%x HW PS0=%x \n",__FUNCTION__,__LINE__,i+(macIDGroup<<5),newPwrBit);


#endif 

#ifdef CONFIG_8814_AP_MAC_VERI
            priv->pwrStateHWCnt[i+(macIDGroup<<5)]++;
            priv->hw_seq[i+(macIDGroup<<5)] = RTL_R16(0x1152);
            priv->pwrHWState[i+(macIDGroup<<5)] = newPwrBit;
            priv->pwroldHWState[i+(macIDGroup<<5)] = oldPwrBit;

            if(priv->testResult == true)
            {
              printk("[%s][%d] MACID%x HW PS0=%x Seq=%x Cnt=%x\n",
                __FUNCTION__,__LINE__,i+(macIDGroup<<5),newPwrBit,priv->hw_seq[i+(macIDGroup<<5)],priv->pwrStateHWCnt[i+(macIDGroup<<5)]);
            }            
#endif //#ifdef CONFIG_8814_AP_MAC_VERI

        } 
    }

    // need for backup new power state
    priv->pshare->HWPwroldState[macIDGroup] = pwr;   
}

__IRAM_IN_865X
void pwr_state_enhaced(struct rtl8192cd_priv *priv, unsigned char macID, unsigned char PwrBit)
{
#ifndef SMP_SYNC
    unsigned long	flags;
#endif
    unsigned char   i;
    struct stat_info *pstat;
    //2 SWPS need to debug why no printk 1~7 will cause kernel segmentation falt and then sys hang
//printk("1\n");
    if(macID > 0)
    {
        if(_GET_HAL_DATA(priv)->MacVersion.is_MAC_v2_v3){
         if((macID == HW_MACID_SEARCH_NOT_READY)) //pwr_change_status_reg(0x114c BIT30 macid126) may be updated by packets which exceed RXFIFO FULL len 0x7D4[31:24]
            {

                return;
            }

            if((macID == HW_MACID_SEARCH_FAIL)) //pwr_change_status_reg(0x114c BIT31 macid127) may be updated by packets with not-found macid
            {
                return;
            }         
        }
        else if(_GET_HAL_DATA(priv)->MacVersion.is_MAC_v4){
            if((macID == HW_MACID_SEARCH_FAIL_V1))
        {
            return;
        }        
    }
    }
    if(macID ==0){
        printk("%s %d macid is 0 return\n",__FUNCTION__,__LINE__);
        return;
    }

    pstat = get_HW_mapping_sta(priv,macID);

    // get priv from aidarray
   
    priv = priv->pshare->aidarray[macID-1]->priv;

	if (pstat == (struct stat_info *)NULL)
	{
        printk("%s %d pstat NULL return\n",__FUNCTION__,__LINE__);
		return;
	}

    if (!(pstat->state & WIFI_ASOC_STATE))
    {
        printk("%s %d pstat is not in associated state\n",__FUNCTION__,__LINE__);        
        return;
    }

    if (PwrBit == 1)
    {
        if ((pstat->state & WIFI_SLEEP_STATE) == 0) {
            pstat->state |= WIFI_SLEEP_STATE;
            if (!pstat->cmn_info.ra_info.disable_ra)
            {
#ifndef HW_DETECT_PS_OFFLOAD            
                GET_HAL_INTERFACE(priv)->SetMACIDSleepHandler(priv, 1, REMAP_AID(pstat));             
#endif 
 
                pstat->txpause_time = jiffies;
                pstat->txpause_flag = 1;
#if defined (AP_SWPS_OFFLOAD)
                if (IS_SUPPORT_AP_SWPS_OFFLOAD(priv)) {

                    //ReadQinfo(priv,REMAP_AID(pstat),0); 
                    printk("[%s][%d]current last reprepare seq (need to minus 1)=[0]0x%x,[1]0x%x,[2]0x%x,[3]0x%x\n",__FUNCTION__,__LINE__,pstat->SWPS_seq[0],pstat->SWPS_seq[1],pstat->SWPS_seq[2],pstat->SWPS_seq[3]); //yllinSWPSprint
                    if(pstat->Drop_ID==3)
                        pstat->Drop_ID=0;
                    else
                        pstat->Drop_ID++;
                    //switch to flag 0/1 to distinqish different sleep time of prepare ok
                    if(pstat->next_prepare_ok == 0){
                        if(pstat->process_dz_ok==1)
                            printk("not prepare done when wakeup, now goto sleep again, state machine may go wrong.\n");//debug
                        else
                            pstat->next_prepare_ok = 1;
                    }
                    else{
                        if(pstat->process_dz_ok==1)
                            pstat->next_prepare_ok = 0;
                        else
                            printk("not prepare done when wakeup, now goto sleep again, state machine may go wrong.\n");//debug
                    }
                }
#if 0       //change to do it at receive SWPS report
                for(i=0;i<4;i++){ //to record the last issued pkt seq
                    
                        if(pstat->SWPS_seq[i]==1)
                            pstat->SWPS_last_seq[i]=4095;
                        else
                            pstat->SWPS_last_seq[i]=pstat->SWPS_seq[i]-1;
                    
                }
#endif                
#endif
            }
        }

        SAVE_INT_AND_CLI(flags);
        wakeup_list_del(priv, pstat);
        sleep_list_add(priv, pstat);
        RESTORE_INT(flags);
        //printk("6\n");

    } else {
        if (pstat->state & WIFI_SLEEP_STATE) {
            pstat->state &= ~(WIFI_SLEEP_STATE);

            if (!pstat->cmn_info.ra_info.disable_ra)
            {
                if (pstat->txpdrop_flag) {
                    GET_HAL_INTERFACE(priv)->UpdateHalMSRRPTHandler(priv, pstat, INCREASE);
                    pstat->txpdrop_flag = 0;
                } 
#ifndef HW_DETECT_PS_OFFLOAD               
                DEBUG_WARN("[%s][%s][%d] client leave ps, Pwr_state jiffies = %lu diff = %lu\n",
                    __FUNCTION__, priv->dev->name, pstat->cmn_info.aid, jiffies, jiffies-pstat->txpause_time);
                GET_HAL_INTERFACE(priv)->SetMACIDSleepHandler(priv, 0, REMAP_AID(pstat));                
#endif
                pstat->txpause_flag = 0;

            }
#if defined(AP_SWPS_OFFLOAD)
            if (IS_SUPPORT_AP_SWPS_OFFLOAD(priv)) {            
                if(SWPS_check_drop_done(pstat)){
                    //send H2C to clear drop id in ctrl info
                    GET_HAL_INTERFACE(priv)->ClearDropIDHandler(priv, REMAP_AID(pstat), pstat->Drop_ID-1);

                    //check reprepare done
                    if(!SWPS_check_reprepare_done(priv,pstat))
                        printk("STA wakeup, and not reprepare done.\n");
                    
                }else
                    printk("not drop done when wakeup.\n");
                pstat->PS_get_SWPSRPT = 0;
            }
#endif
            
        }

        SAVE_INT_AND_CLI(flags);
        sleep_list_del(priv, pstat);
        RESTORE_INT(flags);

        if ((skb_queue_len(&pstat->dz_queue))
#ifdef WIFI_WMM
#ifdef WMM_APSD
                ||(
#ifdef CLIENT_MODE
                (OPMODE & WIFI_AP_STATE) &&
#endif
                (QOS_ENABLE) && (APSD_ENABLE) && (pstat->QosEnabled) && (pstat->apsd_pkt_buffering) &&
                ((!isFFempty(pstat->VO_dz_queue->head, pstat->VO_dz_queue->tail)) ||
                (!isFFempty(pstat->VI_dz_queue->head, pstat->VI_dz_queue->tail)) ||
                (!isFFempty(pstat->BE_dz_queue->head, pstat->BE_dz_queue->tail)) ||
                (!isFFempty(pstat->BK_dz_queue->head, pstat->BK_dz_queue->tail))))
#endif
                || (!isFFempty(pstat->MGT_dz_queue->head, pstat->MGT_dz_queue->tail))
#ifdef DZ_ADDBA_RSP
                || pstat->dz_addba.used
#endif
#endif
        ) {
            SAVE_INT_AND_CLI(flags);
            if (wakeup_list_add(priv, pstat)) {
                //DEBUG_INFO("Add to wakeup_list %02X%02X%02X%02X%02X%02X\n", sa[0],sa[1],sa[2],sa[3],sa[4],sa[5]);
            }
            RESTORE_INT(flags); 
        }
    }

    if(IS_HAL_CHIP(priv))
        check_PS_set_HIQLMT(priv);

    return;
}
#endif //#ifdef HW_DETEC_POWER_STATE


#ifdef CONFIG_WLAN_HAL
void check_PS_set_HIQLMT(struct rtl8192cd_priv *priv)
{
	u2Byte HiQLMTEn;
	u2Byte tmp;

#ifdef MBSSID
	if(priv->sleep_list.next != &priv->sleep_list)  // one client into PS mode
	{
		if (IS_ROOT_INTERFACE(priv)) {
			GET_HAL_INTERFACE(priv)->GetHwRegHandler(priv, HW_VAR_HIQ_NO_LMT_EN, (pu1Byte)&HiQLMTEn); 
			HiQLMTEn = HiQLMTEn & (~BIT0);
			GET_HAL_INTERFACE(priv)->SetHwRegHandler(priv, HW_VAR_HIQ_NO_LMT_EN, (pu1Byte)&HiQLMTEn); 
			GET_HAL_INTERFACE(priv)->GetHwRegHandler(priv, HW_VAR_HIQ_NO_LMT_EN, (pu1Byte)&tmp);
		}
		else {
			if (GET_ROOT(priv)->pmib->miscEntry.vap_enable) {
				GET_HAL_INTERFACE(priv)->GetHwRegHandler(priv, HW_VAR_HIQ_NO_LMT_EN, (pu1Byte)&HiQLMTEn); 
				HiQLMTEn = HiQLMTEn & ~(BIT(priv->vap_init_seq));
				GET_HAL_INTERFACE(priv)->SetHwRegHandler(priv, HW_VAR_HIQ_NO_LMT_EN, (pu1Byte)&HiQLMTEn); 
				GET_HAL_INTERFACE(priv)->GetHwRegHandler(priv, HW_VAR_HIQ_NO_LMT_EN, (pu1Byte)&tmp);
			}
		}
	}
	else {  // all client leave PS mode
		if (IS_ROOT_INTERFACE(priv)) {
			GET_HAL_INTERFACE(priv)->GetHwRegHandler(priv, HW_VAR_HIQ_NO_LMT_EN, (pu1Byte)&HiQLMTEn); 
			HiQLMTEn = HiQLMTEn | BIT0;
			GET_HAL_INTERFACE(priv)->SetHwRegHandler(priv, HW_VAR_HIQ_NO_LMT_EN, (pu1Byte)&HiQLMTEn); 
			GET_HAL_INTERFACE(priv)->GetHwRegHandler(priv, HW_VAR_HIQ_NO_LMT_EN, (pu1Byte)&tmp);
		}
		else {
			if (GET_ROOT(priv)->pmib->miscEntry.vap_enable) {
				GET_HAL_INTERFACE(priv)->GetHwRegHandler(priv, HW_VAR_HIQ_NO_LMT_EN, (pu1Byte)&HiQLMTEn); 
				HiQLMTEn = HiQLMTEn | BIT(priv->vap_init_seq);
				GET_HAL_INTERFACE(priv)->SetHwRegHandler(priv, HW_VAR_HIQ_NO_LMT_EN, (pu1Byte)&HiQLMTEn); 
				GET_HAL_INTERFACE(priv)->GetHwRegHandler(priv, HW_VAR_HIQ_NO_LMT_EN, (pu1Byte)&tmp);
			}
		}
	}
#else
	if(priv->sleep_list.next != &priv->sleep_list)  // one client into PS mode
	{
		GET_HAL_INTERFACE(priv)->GetHwRegHandler(priv, HW_VAR_HIQ_NO_LMT_EN, (pu1Byte)&HiQLMTEn); 
		HiQLMTEn = HiQLMTEn & (~BIT0);
		GET_HAL_INTERFACE(priv)->SetHwRegHandler(priv, HW_VAR_HIQ_NO_LMT_EN, (pu1Byte)&HiQLMTEn); 
		GET_HAL_INTERFACE(priv)->GetHwRegHandler(priv, HW_VAR_HIQ_NO_LMT_EN, (pu1Byte)&tmp);
	}
	else {
		GET_HAL_INTERFACE(priv)->GetHwRegHandler(priv, HW_VAR_HIQ_NO_LMT_EN, (pu1Byte)&HiQLMTEn);
		HiQLMTEn = HiQLMTEn | BIT0;
		GET_HAL_INTERFACE(priv)->SetHwRegHandler(priv, HW_VAR_HIQ_NO_LMT_EN, (pu1Byte)&HiQLMTEn);
		GET_HAL_INTERFACE(priv)->GetHwRegHandler(priv, HW_VAR_HIQ_NO_LMT_EN, (pu1Byte)&tmp);
	}
#endif //#ifdef MBSSID
}
#endif //CONFIG_WLAN_HAL
#ifdef CONFIG_IEEE80211W

enum _ROBUST_FRAME_STATE_{
	NOT_ROBUST_MGMT = 0,
	IS_ROBUST_MGMT = 1,	
	MGMT_FRAME_MIC_ERR = 2,	
};

static int isCorrectRobustFrame(struct rtl8192cd_priv *priv, struct rx_frinfo *pfrinfo)
{
	unsigned char *pframe = get_pframe(pfrinfo);	
	unsigned char Category_field;
	struct stat_info *pstat = get_stainfo(priv, pfrinfo->sa);
#ifdef CONFIG_IEEE80211W_CLI
	unsigned char *da = GetAddr1Ptr(pframe);
#endif

	if(pframe[0] == WIFI_DEAUTH  || pframe[0] == WIFI_DISASSOC || pframe[0] == WIFI_WMM_ACTION) {
        if (GetPrivacy(pframe) && pstat == NULL) {
            return MGMT_FRAME_MIC_ERR;
		} else if (GetPrivacy(pframe) && pstat
#ifdef CONFIG_IEEE80211W_CLI
		&& !IS_MCAST(da)
#endif
		) {
			unsigned char mic[8];

			// Add sanity check to avoid core dump in aes_tx due to plen is extraordinary big(0xfffffffx)
			if (pfrinfo->pktlen <= pfrinfo->hdr_len+16)
				return MGMT_FRAME_MIC_ERR;

			memcpy(mic,pframe + pfrinfo->pktlen - 8, 8);			
			if (aesccmp_decrypt(priv, pfrinfo, 1) == FALSE)
				return MGMT_FRAME_MIC_ERR;

			if(!aesccmp_checkmic(priv, pfrinfo, mic)) {
                #ifdef PMF_DEBUGMSG
				if(pframe[0] == WIFI_DEAUTH){
					PMFDEBUG("DEAUTH MIC_ERR[%s]\n", priv->dev->name);
				}else if(pframe[0] == WIFI_DISASSOC){
					PMFDEBUG("DISASSOC MIC_ERR[%s]\n", priv->dev->name);                    
				}else{
					PMFDEBUG(" MIC_ERR[%s]\n", priv->dev->name);                                        
                }
                #endif
				return MGMT_FRAME_MIC_ERR;
			}
			else {
				memcpy(pframe + pfrinfo->hdr_len, pframe + pfrinfo->hdr_len + 8, pfrinfo->pktlen - pfrinfo->hdr_len - 8 - 8);				
				pfrinfo->pktlen = pfrinfo->pktlen - 16;
			}		
		}
#ifdef CONFIG_IEEE80211W_CLI
		if(priv->bss_support_pmf && pstat){
			pstat->isPMF = TRUE;
		}
#endif
	}
	
	if(pframe[0] == WIFI_DEAUTH  || pframe[0] == WIFI_DISASSOC) 
	{
		return IS_ROBUST_MGMT;
	}
	//pframe += WLAN_HDR_A3_LEN; // Action Field
	
	if(pframe[0] == WIFI_WMM_ACTION) {		
		Category_field = pframe[WLAN_HDR_A3_LEN];
	} else
		return NOT_ROBUST_MGMT;

	return (Category_field != 4) && (Category_field != 7) && (Category_field != 11)
			&& (Category_field != 15) && (Category_field != 127);	
}

#endif

#ifdef CONFIG_IEEE80211W			

#ifdef CONFIG_IEEE80211W_CLI


static int isMMICExist(struct rtl8192cd_priv *priv, struct rx_frinfo *pfrinfo)
{
	unsigned char *pframe = get_pframe(pfrinfo);

	if(pfrinfo->pktlen + MMIC_CRC_LEN <= MMIC_ILLEGAL_LEN)
		return FALSE;		
	
	if(pframe[BIP_HEADER_LEN] == _MMIC_IE_){	
		PMFDEBUG(" MMIC IE Exists!!\n"); 
		if(pframe[BIP_HEADER_LEN + MMIC_TAG_IE] == _MMIC_LEN_){
#ifdef CONFIG_IEEE80211W_CLI_DEBUG
			panic_printk("MMIC IE=");
			int idx;
			for(idx = 0; idx < _MMIC_LEN_; idx++)
				panic_printk("%02x", pframe[BIP_HEADER_LEN + MMIC_TAG_IE + MMIC_TAG_LEN + idx]);		
			panic_printk("\n");
#endif
		}
		return TRUE;
	}
	else{
		PMFDEBUG(" No MMIC IE Exists!!\n"); 
		return FALSE;
	}
}

static int CheckBIPMIC(struct rtl8192cd_priv *priv, struct rx_frinfo *pfrinfo)
{
	unsigned char *pframe = get_pframe(pfrinfo);
	
	if(MMIE_check(priv, pfrinfo)){
		PMFDEBUG("BIP: MIC Check PASS \n");
		return TRUE;
	}else{
		if(pframe[0] == WIFI_DEAUTH) {			
			PMFDEBUG("BIP: DEAUTH MIC_ERR\n");
		} else if(pframe[0] == WIFI_DISASSOC) {
			PMFDEBUG("BIP: DISASSOC MIC_ERR\n");
		} else {
			PMFDEBUG("BIP: MIC_ERR\n");
		}

		return FALSE;
	}
}

#endif

int legal_mgnt_frame(struct rtl8192cd_priv *priv, struct rx_frinfo *pfrinfo)
{
	unsigned char *pframe = get_pframe(pfrinfo);
	unsigned char *da = GetAddr1Ptr(pframe);	
    struct stat_info *pstat = get_stainfo(priv, pfrinfo->sa);    
	int ret = isCorrectRobustFrame(priv, pfrinfo);

	if (ret == MGMT_FRAME_MIC_ERR) { // mgmt frame with mic error
        // For the SA mismatch case, issue deauth to let STA reconnect.
        if (pstat == NULL && (OPMODE & WIFI_AP_STATE) && (pframe[0] == WIFI_DEAUTH || pframe[0] == WIFI_DISASSOC)) {
            PMFDEBUG("RX frame type:%X, reason:%d, sa:%pm\n",
				pframe[0], cpu_to_le16(*(unsigned short *)((unsigned long)pframe + WLAN_HDR_A3_LEN)), pfrinfo->sa);

            issue_deauth(priv, pfrinfo->sa, _RSON_CLS2_);
        }            	
        return MGNT_ERR;
	} else if(ret == IS_ROBUST_MGMT) { // robust mgmt frame
		if(priv->pmib->dot1180211AuthEntry.dot11IEEE80211W == NO_MGMT_FRAME_PROTECTION) {
			if (GetPrivacy(pframe))
		        return MGNT_ERR;
		}
		else if(priv->pmib->dot1180211AuthEntry.dot11IEEE80211W == MGMT_FRAME_PROTECTION_OPTIONAL || 
            priv->pmib->dot1180211AuthEntry.dot11IEEE80211W == MGMT_FRAME_PROTECTION_REQUIRED) {
			if (pstat == NULL) {
			    return MGNT_ERR;
			}
						
			if (pstat->isPMF == 0) { // MFPC=0
				if (GetPrivacy(pframe))
				    return MGNT_ERR;
			} else { // MFPC = 1
				if (!IS_MCAST(da)) {
                    if(!GetPrivacy(pframe))
                        return MGNT_PRIVACY_ERR;
                    else {
                        ClearPrivacy(pframe);
                        return MGNT_LEGAL;
                    }
				}// Does AP receive multicast robust frame from client?
#ifdef CONFIG_IEEE80211W_CLI
				else { // MMPDU has a group RA
                    if(!isMMICExist(priv ,pfrinfo))
                        return MGNT_BCAST_PRIVACY_ERR;
                    else {
                        if(!CheckBIPMIC(priv, pfrinfo)) 
                            return MGNT_BCAST_PRIVACY_ERR;
                    }                   
				}
#endif
			}
		}
	}
    
    return MGNT_LEGAL;
}
#endif	// CONFIG_IEEE80211W

void mgt_handler(struct rtl8192cd_priv *priv, struct rx_frinfo *pfrinfo)
{
	struct mlme_handler *ptable;
	unsigned int index;
	unsigned char *pframe = get_pframe(pfrinfo);
	unsigned char *sa = pfrinfo->sa;
	unsigned char *da = pfrinfo->da;
	struct stat_info *pstat = NULL;
	unsigned short frame_type;
#ifdef CONFIG_IEEE80211W
	int ret = 0;
#endif
	int i;

#if 0	/* already flush cache in rtl8192cd_rx_isr()*/
#ifdef __MIPSEB__
	pframe = (unsigned char*)KSEG1ADDR(pframe);
#endif
#endif

	if (OPMODE & WIFI_AP_STATE)
		ptable = mlme_ap_tbl;
#ifdef CLIENT_MODE
	else if (OPMODE & (WIFI_STATION_STATE | WIFI_ADHOC_STATE))
		ptable = mlme_station_tbl;
#endif
	else
	{
		DEBUG_ERR("Currently we do not support opmode=%d\n", OPMODE);
#if defined(UNIVERSAL_REPEATER) || defined(MBSSID)
		if (IS_ROOT_INTERFACE(priv) || (pfrinfo->is_br_mgnt == 0))
#endif
		rtl_kfree_skb(priv, pfrinfo->pskb, _SKB_RX_);
		return;
	}

	frame_type = GetFrameSubType(pframe);
	index = frame_type >> 4;
	if (index > 13)
	{
		DEBUG_ERR("Currently we do not support reserved sub-fr-type=%d\n", index);
#if defined(UNIVERSAL_REPEATER) || defined(MBSSID)
		if (IS_ROOT_INTERFACE(priv) || (pfrinfo->is_br_mgnt == 0))
#endif
		rtl_kfree_skb(priv, pfrinfo->pskb, _SKB_RX_);
		return;
	}
	ptable += index;

#ifdef CONFIG_RTK_MESH
	if(is_11s_mgt_frame(ptable->num, priv, pfrinfo))
	{
#if defined(UNIVERSAL_REPEATER) || defined(MBSSID)
		pfrinfo->is_br_mgnt = 0;
#endif
		pfrinfo->is_11s = 1;
		ptable = mlme_mp_tbl;
		ptable += index;
#ifdef MBSSID
		if(!IS_VAP_INTERFACE(priv))
#endif
			// An 11s mgt frame will have Addr3 = 00..00, it might be dispatched to vxd in validate_mpdu
			// Hence, we have to "correct" it here.
			priv = GET_ROOT(priv);
	}
#endif // CONFIG_RTK_MESH

	pstat = get_stainfo(priv, sa);

	if(IS_MCAST(GetAddr1Ptr(pframe))) {
		if (pstat) {
#ifdef HW_DETEC_POWER_STATE
			if (IS_SUPPORT_HW_DETEC_POWER_STATE(priv)) {
				// 8814 power state control only by HW, not by SW.
				// Only if HW detect macid not ready, SW patch this packet
				if(pfrinfo->macid == HW_MACID_SEARCH_NOT_READY)
				{
					printk("%s %d HW_MACID_SEARCH_NOT_READY",__FUNCTION__,__LINE__);
					if(priv->pshare->HWPwrStateUpdate[pstat->cmn_info.aid]==false)	 
					{
						printk("%s %d HW not update By SW Aid = %x \n",__FUNCTION__,__LINE__, pstat->cmn_info.aid);
						pwr_state(priv, pfrinfo);
					}
				}
				else if (pfrinfo->macid > HW_MACID_SEARCH_SUPPORT_NUM)
				{
					pwr_state(priv, pfrinfo);
				}
			} else 
#endif // HW_DETEC_POWER_STATE
			{
				pwr_state(priv, pfrinfo);
			}
		}
	}

	if ((pstat != NULL) && (WIFI_PROBEREQ != frame_type))
	{
#ifdef DETECT_STA_EXISTANCE
#ifdef CONFIG_RTL_88E_SUPPORT
		if (GET_CHIP_VER(priv)==VERSION_8188E) {
			if (pstat->leave!= 0)
				RTL8188E_MACID_NOLINK(priv, 0, REMAP_AID(pstat));
		}
#endif
#ifdef CONFIG_WLAN_HAL
		if (IS_HAL_CHIP(priv)) {
			if (pstat->leave) {
				GET_HAL_INTERFACE(priv)->UpdateHalMSRRPTHandler(priv, pstat, INCREASE);
				pstat->txpdrop_flag = 0;
				pstat->cmn_info.dm_ctrl |= STA_DM_CTRL_ACTIVE;
			}
		}
#endif
		pstat->leave = 0;
#endif
	}

	if (!IS_MCAST(da))
	{
		//pstat = get_stainfo(priv, sa);

		// only check last cache seq number for management frame, david -------------------------
		if (pstat != NULL) {
			if (GetRetry(pframe)) {
				if (GetTupleCache(pframe) == pstat->tpcache_mgt) {
					priv->ext_stats.rx_decache++;
#if defined(UNIVERSAL_REPEATER) || defined(MBSSID)
					if (IS_ROOT_INTERFACE(priv) || (pfrinfo->is_br_mgnt == 0))
#endif
					rtl_kfree_skb(priv, pfrinfo->pskb, _SKB_RX_);
					SNMP_MIB_INC(dot11FrameDuplicateCount, 1);
					return;
				}
				else
				{
					  pstat->tpcache_mgt = GetTupleCache(pframe);
				}
			}
			pstat->tpcache_mgt = GetTupleCache(pframe);
		}
	}

	// log rx statistics...
#ifdef WDS
	if (pstat && (pstat->state & WIFI_WDS) && (ptable->num == WIFI_BEACON)) {
		rx_sum_up(NULL, pstat, pfrinfo);

		update_sta_rssi(priv, pstat, pfrinfo);
	}
	else
#endif
#ifdef CONFIG_RTK_MESH
	if (pstat && pfrinfo->is_11s && (ptable->num == WIFI_BEACON)) {
		// count statistics for mesh points -- chris
		rx_sum_up(NULL, pstat, pfrinfo);

		update_sta_rssi(priv, pstat, pfrinfo);
	}
	else
#endif
	if (pstat != NULL)
	{
		if (!((OPMODE & WIFI_AP_STATE) && ((ptable->num == WIFI_BEACON) || (ptable->num == WIFI_PROBEREQ))))
		{
			rx_sum_up(NULL, pstat, pfrinfo);
	
			update_sta_rssi(priv, pstat, pfrinfo);
		}

#ifdef CLIENT_MODE
		if ((OPMODE & WIFI_STATION_STATE) && (ptable->num != WIFI_BEACON))
			priv->rxDataNumInPeriod++;
#endif
	}

#ifdef MBSSID
	if (
		GET_ROOT(priv)->pmib->miscEntry.vap_enable &&
		IS_VAP_INTERFACE(priv)) {
		if (IS_MCAST(da) || isEqualMACAddr(GET_MY_HWADDR, da))
		{
#ifdef CONFIG_IEEE80211W
			if(pstat && pstat->isPMF==0)
				ret=MGNT_LEGAL;
			else
				ret = legal_mgnt_frame(priv,pfrinfo);

			if(ret == MGNT_LEGAL)
#endif
			{
#ifdef CONFIG_POWER_SAVE
				if ((ptable->num != WIFI_BEACON) && (ptable->num != WIFI_PROBEREQ)
						&& (ptable->num != WIFI_PROBERSP)) {
					ap_offload_deactivate(priv, OFFLOAD_PROHIBIT_MGT);
					ptable->func(priv, pfrinfo);
					ap_offload_activate(priv, OFFLOAD_PROHIBIT_MGT);
				} else
#endif
				{
					ptable->func(priv, pfrinfo);
				}
			}
		}
	}
	else
#endif
	{
#ifdef CONFIG_IEEE80211W
		if(pstat && pstat->isPMF==0)
			ret=MGNT_LEGAL;
		else
			ret = legal_mgnt_frame(priv,pfrinfo);

		if(ret == MGNT_LEGAL)
#endif
		{
#ifdef CONFIG_POWER_SAVE
			if ((ptable->num != WIFI_BEACON) && (ptable->num != WIFI_PROBEREQ)
					&& (ptable->num != WIFI_PROBERSP)) {
				ap_offload_deactivate(priv, OFFLOAD_PROHIBIT_MGT);
				ptable->func(priv, pfrinfo);
				ap_offload_activate(priv, OFFLOAD_PROHIBIT_MGT);
			} else
#endif
			{
				ptable->func(priv, pfrinfo);
			}
		}
#ifdef CONFIG_IEEE80211W_CLI
		else if((OPMODE&WIFI_STATION_STATE)  &&  ret == MGNT_PRIVACY_ERR)
		{
			if (pframe[0] == WIFI_DEAUTH || pframe[0] == WIFI_DISASSOC)
			{
                if (pstat && pstat->sa_query_count == 0) {
                    pstat->sa_query_count++;
                    pstat->sa_query_end = jiffies + RTL_MILISECONDS_TO_JIFFIES(SA_QUERY_MAX_TO);
                    //PMFDEBUG("sa_query_end=%lu\n", pstat->sa_query_end);

                    issue_SA_Query_Req(priv->dev,pstat->cmn_info.mac_addr);
                    PMFDEBUG("issue_SA_Query_Req() when Receving Unprotected action frame !\n");
                    rtk_mod_timer(&pstat->SA_timer, jiffies + RTL_MILISECONDS_TO_JIFFIES(SA_QUERY_RETRY_TO));
                }
			}
		}else{
			log("ret=%d",ret);
		}
#endif
	}

#ifdef MBSSID
	if (IS_VAP_INTERFACE(priv)) {
		if (pfrinfo->is_br_mgnt) {
			rx_sum_up(priv, NULL, pfrinfo);
			return;
		}
	}
	else if (IS_ROOT_INTERFACE(priv) && pfrinfo->is_br_mgnt && (OPMODE & WIFI_AP_STATE)) {

		for (i=0; i<RTL8192CD_NUM_VWLAN; i++) {
			if ((IS_DRV_OPEN(priv->pvap_priv[i])) && ((IS_MCAST(da)) ||
				(isEqualMACAddr(priv->pvap_priv[i]->pmib->dot11StationConfigEntry.dot11Bssid, da))))
			{
#ifdef CONFIG_IEEE80211W
				if(pstat && pstat->isPMF==0)
					ret=MGNT_LEGAL;
				else
					ret = legal_mgnt_frame(priv->pvap_priv[i],pfrinfo);

				if(ret == MGNT_LEGAL)
#endif
				{
					mgt_handler(priv->pvap_priv[i], pfrinfo);
				}
#ifdef CONFIG_IEEE80211W_CLI
				else if((OPMODE&WIFI_STATION_STATE) && ret == MGNT_PRIVACY_ERR)
				{
                    if (pframe[0] == WIFI_DEAUTH || pframe[0] == WIFI_DISASSOC) {
                        if (pstat && pstat->sa_query_count == 0) {
                            pstat->sa_query_count++;
                            pstat->sa_query_end = jiffies + RTL_MILISECONDS_TO_JIFFIES(SA_QUERY_MAX_TO);
                            //PMFDEBUG("sa_query_end=%lu\n", pstat->sa_query_end);

                            issue_SA_Query_Req(priv->dev,pstat->cmn_info.mac_addr);
                            PMFDEBUG("issue_SA_Query_Req() when Receving Unprotected action frame !\n");
                            rtk_mod_timer(&pstat->SA_timer, jiffies + RTL_MILISECONDS_TO_JIFFIES(SA_QUERY_RETRY_TO));
                        }
                    }
				}else{
					log("MGNT_ERR! ret = %d ", ret);
				}
#endif
			}
		 }
	}
#endif

#ifdef UNIVERSAL_REPEATER
	if (pfrinfo->is_br_mgnt) {
		pfrinfo->is_br_mgnt = 0;

// fix hang-up issue when root-ap (A+B) + vxd-client ------------
		if (IS_DRV_OPEN(GET_VXD_PRIV(priv))) {
			if ((OPMODE & WIFI_AP_STATE) ||
				((OPMODE & WIFI_STATION_STATE) &&
				GET_VXD_PRIV(priv) && (GET_VXD_PRIV(priv)->drv_state & DRV_STATE_VXD_AP_STARTED))) {
//--------------------------------------------david+2006-07-17

				mgt_handler(GET_VXD_PRIV(priv), pfrinfo);
				return;
			}
		}
	}
#endif

	rtl_kfree_skb(priv, pfrinfo->pskb, _SKB_RX_);
}


/*----------------------------------------------------------------------------
// the purpose of this sub-routine
Any station has changed from sleep to active state, and has data buffer should
be dequeued here!
-----------------------------------------------------------------------------*/
#ifdef CONFIG_PCI_HCI
#ifdef AP_SWPS_OFFLOAD
void tx_reprepare_pkt(struct rtl8192cd_priv *priv, struct stat_info *pstat, u4Byte queueIndex, struct reprepare_info* pkt_info)
{
// need to seperate AMSDU , shoutcut..etc
#if IS_RTL88XX_MAC_V4
        if(_GET_HAL_DATA(priv)->MacVersion.is_MAC_v4)
            ReprepareFillTxDescSetTxBD_V1(priv, pstat, queueIndex, pkt_info);
#endif
#if IS_RTL88XX_MAC_V3
        if(_GET_HAL_DATA(priv)->MacVersion.is_MAC_v3)
            ReprepareFillTxDescSetTxBD(priv, pstat, queueIndex, pkt_info);
#endif
#if IS_RTL8192F_SERIES
		if (IS_HARDWARE_TYPE_8192FE(priv)) 
            ReprepareFillTxDescSetTxBD_92f(priv, pstat, queueIndex, pkt_info);
#endif
        GET_HAL_INTERFACE(priv)->SyncSWTXBDHostIdxToHWHandler(priv, queueIndex);
}
#endif

void process_dzqueue_pci(struct rtl8192cd_priv *priv)
{
	struct stat_info *pstat;
	struct sk_buff *pskb;
	struct list_head *phead = &priv->wakeup_list;
	struct list_head *plist = phead->next;
#if defined(AP_SWPS_OFFLOAD)
    struct reprepare_info pkt_info;
    unsigned int queueIndex;
    unsigned char reprepare_flag=FALSE;
#endif
    
#ifndef SMP_SYNC
	unsigned long flags;
#else
	unsigned long dz_flags;
#endif
	int round=0, round2 = 0, cnt=0;

	while(plist != phead)
	{
		pstat = list_entry(plist, struct stat_info, wakeup_list);
		plist = plist->next;

#if defined(AP_SWPS_OFFLOAD)
        if (IS_SUPPORT_AP_SWPS_OFFLOAD(priv)) {
            if(pstat->process_dz_ok == pstat->next_prepare_ok){            
                //prepare done, proceed
            }
            else
                continue;
        }
#endif

#ifdef SMP_SYNC
		SMP_LOCK_XMIT(dz_flags);
#endif

		cnt++;
		round2 = 0;

		while(1)
		{
// 2009.09.08
#if defined(AP_SWPS_OFFLOAD)
            reprepare_flag=FALSE;
#endif
			SAVE_INT_AND_CLI(flags);
#if defined(WIFI_WMM) && defined(WMM_APSD)
			if (
#ifdef CLIENT_MODE
				(OPMODE & WIFI_AP_STATE) &&
#endif
				(QOS_ENABLE) && (APSD_ENABLE) && pstat && (pstat->QosEnabled) && (pstat->apsd_pkt_buffering))
			{
				pskb = (struct sk_buff *)deque(priv, 
#if defined(AP_SWPS_OFFLOAD)
                    pstat->VO_dz_queue,
                    &pkt_info,
#endif
                    &(pstat->VO_dz_queue->head), &(pstat->VO_dz_queue->tail),
					(unsigned long)(pstat->VO_dz_queue->pSkb), NUM_APSD_TXPKT_QUEUE);
#if defined(AP_SWPS_OFFLOAD)
                queueIndex = VO_QUEUE; // 4
#endif                    
				if (pskb == NULL) {
					pskb = (struct sk_buff *)deque(priv, 
#if defined(AP_SWPS_OFFLOAD)
                        pstat->VI_dz_queue,
                        &pkt_info,
#endif                        
                        &(pstat->VI_dz_queue->head), &(pstat->VI_dz_queue->tail),
						(unsigned long)(pstat->VI_dz_queue->pSkb), NUM_APSD_TXPKT_QUEUE);
#if defined(AP_SWPS_OFFLOAD)
                    queueIndex = VI_QUEUE; // 3
#endif                    
					if (pskb == NULL) {
						pskb = (struct sk_buff *)deque(priv, 
#if defined(AP_SWPS_OFFLOAD)
                            pstat->BE_dz_queue,
                            &pkt_info,
#endif                                                        
                            &(pstat->BE_dz_queue->head), &(pstat->BE_dz_queue->tail),
							(unsigned long)(pstat->BE_dz_queue->pSkb), NUM_APSD_TXPKT_QUEUE);
#if defined(AP_SWPS_OFFLOAD)
                        queueIndex = BE_QUEUE; // 2
#endif                        
						if (pskb == NULL) {
							pskb = (struct sk_buff *)deque(priv,                                 
#if defined(AP_SWPS_OFFLOAD)
                                pstat->BK_dz_queue,
                                &pkt_info,
#endif                                
                                &(pstat->BK_dz_queue->head), &(pstat->BK_dz_queue->tail),
								(unsigned long)(pstat->BK_dz_queue->pSkb), NUM_APSD_TXPKT_QUEUE);
#if defined(AP_SWPS_OFFLOAD)
                            queueIndex = BK_QUEUE; // 1
#endif                            
							if (pskb == NULL) {
								pstat->apsd_pkt_buffering = 0;
								goto legacy_ps;
							}
							DEBUG_INFO("release BK pkt\n");
#if defined(AP_SWPS_OFFLOAD)                            
                            reprepare_flag = TRUE;
#endif
						} else {
							DEBUG_INFO("release BE pkt\n");
#if defined(AP_SWPS_OFFLOAD)                            
                            reprepare_flag = TRUE;
#endif
						}
					} else {
						DEBUG_INFO("release VI pkt\n");
#if defined(AP_SWPS_OFFLOAD)                        
                        reprepare_flag = TRUE;
#endif
					}
				} else {
					DEBUG_INFO("release VO pkt\n");
#if defined(AP_SWPS_OFFLOAD)                    
                    reprepare_flag = TRUE;
#endif
				}
			} else
legacy_ps:

#endif
#if defined(WIFI_WMM) 
			if (!isFFempty(pstat->MGT_dz_queue->head, pstat->MGT_dz_queue->tail)){
				struct tx_insn *tx_cfg;
				tx_cfg = (struct tx_insn *)deque(priv, 
#if defined(AP_SWPS_OFFLOAD)
                    NULL,
                    NULL,
#endif                                        
                    &(pstat->MGT_dz_queue->head), &(pstat->MGT_dz_queue->tail),
					(unsigned long)(pstat->MGT_dz_queue->ptx_insn), NUM_DZ_MGT_QUEUE);
				if ((rtl8192cd_firetx(priv, tx_cfg)) == SUCCESS){
					DEBUG_INFO("release MGT pkt\n");
				}else{
					DEBUG_ERR("release MGT pkt failed!\n");
					if (tx_cfg->phdr)
						release_wlanhdr_to_poll(priv, tx_cfg->phdr);
					if (tx_cfg->pframe)
						release_mgtbuf_to_poll(priv, tx_cfg->pframe);
				}
				kfree(tx_cfg);
				RESTORE_INT(flags);
				continue;
			}
			else
#ifdef DZ_ADDBA_RSP
			if (pstat->dz_addba.used) {
				issue_ADDBArsp(priv, pstat->cmn_info.mac_addr, pstat->dz_addba.dialog_token,
						pstat->dz_addba.TID, pstat->dz_addba.status_code, pstat->dz_addba.timeout, pstat->IOTPeer);
				pstat->dz_addba.used = 0;
				//printk("issue DZ addba!!!!!!!\n");
				RESTORE_INT(flags);
				continue;
			}
			else
#endif
#endif
#ifdef  AP_SWPS_OFFLOAD
            if(SWPS_check_reprepare_done(priv,pstat))
#endif                
            {
			pskb = (struct sk_buff *)skb_dequeue(&pstat->dz_queue);

#if defined(AP_SWPS_OFFLOAD)
            if (IS_SUPPORT_AP_SWPS_OFFLOAD(priv)) {
                //queueIndex = BE_QUEUE; // 2
                if((pstat->dz_list_head.next != &pstat->dz_list_head) && (pskb != NULL)){ //delete the swps seq, no use now
                    struct list_head* dznode;
                    struct dz_seq_node* node_tofree= NULL;
                    int amsdu_i = 0;
                    dznode = pstat->dz_list_head.next;
                    list_del_init(dznode);
                    node_tofree = list_entry(dznode,struct dz_seq_node,node);
                    reprepare_flag = TRUE;
                    queueIndex = node_tofree->queueIndex;

                    pkt_info.amsdu_flag = node_tofree->amsdu_flag;
                    pkt_info.hdr = node_tofree->hdr;
                    pkt_info.llchdr = node_tofree->llchdr;
                    pkt_info.hdr_len = node_tofree->hdr_len;
                    pkt_info.icv = node_tofree->icv;
                    pkt_info.mic = node_tofree->mic;
                    pkt_info.mic_icv_len = node_tofree->mic_icv_len;
                    pkt_info.skbbuf_len = node_tofree->skbbuf_len;
                    pkt_info.ptxdesc = node_tofree->ptxdesc;
                    pkt_info.swps_seq = node_tofree->swps_seq;
                    pkt_info.pSkb = pskb;
                    pkt_info.PSB_len = node_tofree->PSB_len;
                    #if CFG_HAL_SUPPORT_TXDESC_IE
                    pkt_info.IE_bitmap = node_tofree->IE_bitmap;
                    #endif
#ifdef SUPPORT_TX_AMSDU                    
                    pkt_info.amsdu_num = node_tofree->amsdu_num;
                    for(amsdu_i=0;amsdu_i<pkt_info.amsdu_num;amsdu_i++)
                        pkt_info.amsdubuf_len[amsdu_i] = node_tofree->amsdubuf_len[amsdu_i];
#endif
                    kfree(node_tofree);
                    node_tofree = NULL;
                }

                
            }
#endif           
            }
// 2009.09.08
			RESTORE_INT(flags);

			if (pskb == NULL)
				break;

#ifdef ENABLE_RTL_SKB_STATS
			rtl_atomic_dec(&priv->rtl_tx_skb_cnt);
#endif

#ifdef AP_SWPS_OFFLOAD
                if(IS_SUPPORT_AP_SWPS_OFFLOAD(priv) && reprepare_flag){
                    printk("tx reprepare pkt, original swps seq = %x\n",pkt_info.swps_seq);  //yllinSWPSprint
                    tx_reprepare_pkt(priv, pstat, queueIndex, &pkt_info);
                    pstat->reprepare_num[queueIndex-1]--;
                    
                }else
#endif
			if (__rtl8192cd_start_xmit(pskb, pskb->dev, TX_NO_MUL2UNI))
				rtl_kfree_skb(priv, pskb, _SKB_TX_);

			if (++round > (NUM_TXPKT_QUEUE<<5)) {
				panic_printk("%s[%d] while (1) goes too many\n", __FUNCTION__, __LINE__);
				break;
			}
			round2++;
		}

#ifdef SMP_SYNC
		SMP_UNLOCK_XMIT(dz_flags);
#endif

		SAVE_INT_AND_CLI(flags);
		if (wakeup_list_del(priv, pstat)) {
			DEBUG_INFO("Del fr wakeup_list %pm\n",pstat->cmn_info.mac_addr);
		}
		RESTORE_INT(flags); 
	}
}

#ifdef CONFIG_RTL_OFFLOAD_DRIVER
#define DCNT_CHECK_COOKIE       (0x70862266)
#define DC_SRAM_START           0x1fe00000

int get_mcast_send_quota(struct rtl8192cd_priv *priv, unsigned long *idx)
{
    static int use_dcnt = 0;
    static struct dcnt_pe_t *dcnt_pe;
    unsigned int value, magic, cookie;
    
    if (use_dcnt == 0) {
        INDIRECT_READ(DC_SRAM_START + 0x4, magic);
        INDIRECT_READ(magic + (DCNT_CAT_COOKIE * 4), cookie);
        if (cookie == DCNT_CHECK_COOKIE) {
            printk("########## dcnt inited..............\n");
            INDIRECT_READ(magic + (DCNT_CAT_PE * 4), value);
            dcnt_pe = (struct dcnt_pe_t *)value;

            use_dcnt = 1;
        }
        else {
            use_dcnt = -1;
            return use_dcnt;
        }
    }
    else if (use_dcnt == -1)
        return use_dcnt;

    INDIRECT_READ(0x18bc0128, value);
    *idx = value;
    
    INDIRECT_READ((u32)(&dcnt_pe->__cnt_hiq), value);
    return value;
}

#undef DCNT_CHECK_COOKIE
#undef DC_SRAM_START
#endif

void process_mcast_dzqueue_pci(struct rtl8192cd_priv *priv)
{
	struct sk_buff *pskb;
	int round = 0,dq_num=0;

#ifdef SMP_SYNC
	unsigned long dz_flags =0;
#endif

#ifdef CONFIG_RTL_OFFLOAD_DRIVER
    int allow_send;
    unsigned long hiq0_idx = 0;
#endif

#ifdef SMP_SYNC
	SMP_LOCK_XMIT(dz_flags);
#endif

#ifdef CONFIG_RTL_OFFLOAD_DRIVER
    if (OFFLOAD_ENABLE(priv)) {
        allow_send = get_mcast_send_quota(priv, &hiq0_idx);
    }
#endif

	priv->release_mcast = 1;
	while (1) {

#ifdef CONFIG_RTL_OFFLOAD_DRIVER
        if (OFFLOAD_ENABLE(priv)) {
            if ((allow_send == -1) || (round < allow_send))
                ;
            else
                break;
        }
#endif

		pskb = (struct sk_buff *)deque(priv, 
#if defined(AP_SWPS_OFFLOAD)
            NULL,
            NULL,
#endif            
            &(priv->dz_queue.head), &(priv->dz_queue.tail),
			(unsigned long)(priv->dz_queue.pSkb), NUM_TXPKT_QUEUE);

		if (pskb == NULL)
			break;
		
#ifdef ENABLE_RTL_SKB_STATS
		rtl_atomic_dec(&priv->rtl_tx_skb_cnt);
#endif

// stanley: I think using pskb->dev is correct IN THE FUTURE, when mesh0 also applies dzqueue
#ifdef CONFIG_RTK_MESH
		if (__rtl8192cd_start_xmit(pskb, pskb->dev, TX_NO_MUL2UNI))
#else
		if (__rtl8192cd_start_xmit(pskb, priv->dev, TX_NO_MUL2UNI))
#endif
			rtl_kfree_skb(priv, pskb, _SKB_TX_);

#ifdef CONFIG_RTL_OFFLOAD_DRIVER
		if (OFFLOAD_ENABLE(priv)) {
			if (++dq_num == 8) 
				break;		
		}
#endif		
		if (++round > (NUM_TXPKT_QUEUE<<3)) {
			panic_printk("%s[%d] while (1) goes too many\n", __FUNCTION__, __LINE__);
			break;
		}
	}

	priv->release_mcast = 0;
#ifdef CONFIG_RTL_OFFLOAD_DRIVER
	if (OFFLOAD_ENABLE(priv)) {
		if (isFFempty(priv->dz_queue.head, priv->dz_queue.tail))
			priv->pkt_in_dtimQ = 0;
		else
			priv->pkt_in_dtimQ = 1;
	}
#endif
#ifdef SMP_SYNC
	SMP_UNLOCK_XMIT(dz_flags);
#endif
}
#endif // CONFIG_PCI_HCI


#if 0
 int check_basic_rate(struct rtl8192cd_priv *priv, unsigned char *pRate, int pLen)
{
	int i, match, idx;
	UINT8 rate;

	// david, check if is there is any basic rate existed --
	int any_one_basic_rate_found = 0;

	for (i=0; i<pLen; i++) {
		if (pRate[i] & 0x80) {
			any_one_basic_rate_found = 1;
			break;
		}
	}

	for (i=0; i<AP_BSSRATE_LEN; i++) {
		if (AP_BSSRATE[i] & 0x80) {
			rate = AP_BSSRATE[i] & 0x7f;
			match = 0;
			for (idx=0; idx<pLen; idx++) {
				if ((pRate[idx] & 0x7f) == rate) {
					if (pRate[idx] & 0x80)
						match = 1;
					else {
						if (!any_one_basic_rate_found) {
							pRate[idx] |= 0x80;
							match = 1;
						}
					}
				}
			}
			if (match == 0)
				return FAIL;
		}
	}
	return SUCCESS;
}
#endif

#if (BEAMFORMING_SUPPORT == 1)

#if defined(CONFIG_WLAN_HAL_8822BE) || defined(CONFIG_WLAN_HAL_8814BE) || defined(CONFIG_WLAN_HAL_8812FE)

void dump_candicate
(	struct rtl8192cd_priv *priv, 
	struct stat_info** candidate, 
	unsigned char num, 
	unsigned char type)
{

	int idx = 0;
	struct stat_info *psta;


	for(idx=0 ; idx < num ; idx ++){
		if(candidate[idx]){
			psta = candidate[idx];
			
			panic_printk("[Candi %d][Type %d][%02x %02x %02x %02x %02x %02x] bf_score = %d \n",
			idx, type,
			psta->cmn_info.mac_addr[0], psta->cmn_info.mac_addr[1], psta->cmn_info.mac_addr[2], 
			psta->cmn_info.mac_addr[3], psta->cmn_info.mac_addr[4], psta->cmn_info.mac_addr[5], 
			psta->bf_score);
		}
		else {
			if(idx == 0)
				panic_printk("No Candicate !! \n");
			break;
		}

	}

}

void clear_bfee_entry(struct rtl8192cd_priv *priv, unsigned char type)
{
	int tmp =0;
	struct stat_info *pstat;

	PRT_BEAMFORMING_INFO	pBeamInfo = &(priv->pshare->BeamformingInfo);
	PRT_BEAMFORMING_ENTRY	pEntry;

	//panic_printk("[%s] type = %d +++ \n", __FUNCTION__, type);

	for(tmp = 0; tmp < BEAMFORMEE_ENTRY_NUM; tmp++) {
		if( pBeamInfo->BeamformeeEntry[tmp].bUsed) {
#if (MU_BEAMFORMING_SUPPORT == 1)
			if(pBeamInfo->BeamformeeEntry[tmp].is_mu_sta == type)
#endif
			{
				Beamforming_Leave(priv, pBeamInfo->BeamformeeEntry[tmp].MacAddr);
			}
		}
	}

	if(type == TXBF_TYPE_MU){
		//STOP MU TX
		unsigned int tmp32 = RTL_R32(0x14c0);

		tmp32 &= (~BIT7);
		RTL_W32(0x14c0, tmp32);
	}

}

unsigned char is_candicate(struct stat_info* psta, unsigned int num_candidate,  struct stat_info** candidate)
{
	int idx = 0;

	if(num_candidate==0)
		return 0;

	for(idx=0 ; idx < num_candidate ; idx ++){
		if(psta == candidate[idx])
			return 1;
	}

	return 0;

}

unsigned char is_support_bf(struct stat_info* psta, unsigned char type)
{

#ifdef RTK_AC_SUPPORT	
	if(type == TXBF_TYPE_MU){
		if(psta->error_csi == 1)
			return 0;
		if((psta->vht_cap_len && (cpu_to_le32(psta->vht_cap_buf.vht_cap_info) & BIT(MU_BFEE_S)) && get_sta_vht_mimo_mode(psta) == RF_1T1R))
			return 1;
	}
#endif
	else if(type == TXBF_TYPE_SU){
		if(psta->error_csi == 1)
			return 0;
		if((psta->ht_cap_len && (cpu_to_le32(psta->ht_cap_buf.txbf_cap)&_HTCAP_RECEIVED_NDP)) 	  // 
#ifdef RTK_AC_SUPPORT	
			|| (psta->vht_cap_len && (cpu_to_le32(psta->vht_cap_buf.vht_cap_info) & BIT(SU_BFEE_S))))
#endif	
		return 1;
	}

	return 0;

}

void dym_disable_bf_coeff(struct rtl8192cd_priv *priv) 
{
	u1Byte i, flags;
	
	PRT_BEAMFORMING_INFO pBeamformingInfo = &(priv->pshare->BeamformingInfo);
	PRT_SOUNDING_INFOV2 pSoundingInfo = &(pBeamformingInfo->SoundingInfoV2);
	PRT_BEAMFORMING_ENTRY	pBeamformEntry;

	flags = 0;
	for(i = 0; i < BEAMFORMEE_ENTRY_NUM; i++) { 			
		pBeamformEntry = &(pBeamformingInfo->BeamformeeEntry[i]);
		if( pBeamformEntry->bUsed && pBeamformEntry->pSTA && 
			(pBeamformEntry->pSTA->current_tx_rate >= _NSS1_MCS7_RATE_ && pBeamformEntry->pSTA->current_tx_rate <= _NSS1_MCS9_RATE_ )) {
			flags = 1;
			break;
		}
	}

#if defined(CONFIG_WLAN_HAL_8822BE)
	if (GET_CHIP_VER(priv) == VERSION_8822B)
	Beamforming_dym_disable_bf_coeff_8822B(priv, flags);
#endif

#if defined(CONFIG_WLAN_HAL_8814BE)
	if (GET_CHIP_VER(priv) == VERSION_8814B)
		Beamforming_dym_disable_bf_coeff_8814B(priv, flags);
#endif	
}

void get_bf_score(struct rtl8192cd_priv *priv)
{
	unsigned int idx, txtp = 0;
	struct stat_info* psta;

	idx = 0;

	psta = findNextSTA(priv, &idx); 

	while(psta) {
		txtp = (unsigned int)(psta->tx_avarage>>17);
		
		psta->bf_score = phydm_get_mu_bfee_snding_decision(ODMPTR, txtp);

		if(psta->IOTPeer == HT_IOT_PEER_INTEL) 
			psta->bf_score = 0;

#if 0		
		panic_printk("[%02x %02x %02x %02x %02x %02x] bf_score = %d \n", 
			psta->hwaddr[0], psta->hwaddr[1], psta->hwaddr[2], 
			psta->hwaddr[3], psta->hwaddr[4], psta->hwaddr[5], 
			psta->bf_score);
#endif
		psta = findNextSTA(priv, &idx); 
		
	}

}

void get_txbf_candidate
(	struct rtl8192cd_priv *priv, 
	struct stat_info** candidate, 
	unsigned char num, 
	unsigned char type)
{
	int idx, i = 0;
	struct stat_info* psta;
	struct stat_info* candidate_tmp;
	PRT_BEAMFORMING_INFO pBeamformingInfo = &(priv->pshare->BeamformingInfo);

	candidate[0] = NULL;

	for(i = 0; i<num; i++){	

		idx = 0;
		candidate_tmp = NULL;
		psta = findNextSTA(priv, &idx);
		
		while(psta) {
			if(psta && psta->expire_to) {
				if( (isEqualMACAddr(psta->cmn_info.mac_addr, pBeamformingInfo->DelEntryListByMACAddr.BFeeEntry_Idx0)) ){
					psta = findNextSTA(priv, &idx);
					continue;
				}
				if((isEqualMACAddr(psta->cmn_info.mac_addr, pBeamformingInfo->DelEntryListByMACAddr.BFeeEntry_Idx1))){
					psta = findNextSTA(priv, &idx);
					continue;
				}		

				if((!is_support_bf(psta, type)) ||
					(priv->pmib->dot11RFEntry.txbf_mu && type == TXBF_TYPE_SU && is_support_bf(psta, TXBF_TYPE_MU))){
					psta = findNextSTA(priv, &idx);
					continue;
				}
				
				if(is_candicate(psta, num, candidate)){
					psta = findNextSTA(priv, &idx);
					continue;
				}

				if(candidate_tmp == NULL)
					candidate_tmp = psta;
				else if(psta->bf_score > candidate_tmp->bf_score)
					candidate_tmp = psta;
			}

			psta = findNextSTA(priv, &idx);
		}

		if(candidate_tmp == NULL)
			break;

		candidate[i] = candidate_tmp;
	}

	//dump_candicate(priv,candidate,num,type);

	return;
}

void assign_txbf_candidate_to_entry
(	struct rtl8192cd_priv *priv, 
	struct stat_info** candidate, 
	unsigned char num, 
	unsigned char type)
{
	int idx, tmp, is_in_entry, need_reassign = 0;
	struct stat_info* psta;
	
	PRT_BEAMFORMING_INFO 	pBeamInfo = &(priv->pshare->BeamformingInfo);
	PRT_BEAMFORMING_ENTRY	pEntry;

	if(candidate[0] == NULL)
		return;

	for(idx = 0; idx < num; idx ++){

		if(candidate[idx] == NULL)
			break;

		psta = candidate[idx];

		is_in_entry = 0; 
	
		for(tmp = 0; tmp < BEAMFORMEE_ENTRY_NUM; tmp++) {
			if( pBeamInfo->BeamformeeEntry[tmp].bUsed &&
				(pBeamInfo->BeamformeeEntry[tmp].MacId == psta->cmn_info.aid)) 	
					is_in_entry = 1;
		}

		if(is_in_entry == 0){
			need_reassign = 1;
			break;
		}

	}

	//panic_printk("[%s] type = %d need_reassign = %d \n", __FUNCTION__, type, need_reassign);

	if(need_reassign){
		clear_bfee_entry(priv, type);
		
		for(idx = 0; idx < num; idx ++){
			if(candidate[idx] == NULL)
				break;

			psta = candidate[idx];
			Beamforming_Enter(priv, psta);
		}
	}
	

}

void DynamicSelectTxBFSTA(struct rtl8192cd_priv *priv)
{
	unsigned char num_su = MAX_NUM_BEAMFORMEE_SU;
#if (MU_BEAMFORMING_SUPPORT == 1) 
	unsigned char num_mu = MAX_NUM_BEAMFORMEE_MU;
#endif
	struct stat_info* candidate[NUM_TXBF_ALL];

	PRT_BEAMFORMING_INFO 	pBeamInfo = &(priv->pshare->BeamformingInfo);
	PRT_BEAMFORMING_ENTRY	pEntry;

	if(priv->pmib->dot11RFEntry.txbf == 0)
	return;

	//if(!priv->pshare->rf_ft_var.txbfselect)
	//return; 

	//priv->pshare->rf_ft_var.showtx = 2;

	if((GET_CHIP_VER(priv)== VERSION_8822B) && (GET_CHIP_VER_8822(priv) <= 0x2)) {
#if (MU_BEAMFORMING_SUPPORT == 1)		
		if(pBeamInfo->SoundingInfoV2.CandidateMUBFeeCnt)
			num_su = 0;
		else
#endif			
			num_su = 1;
	}

	//panic_printk("[%s] used entry number, mu=%d su=%d \n", 
		//__FUNCTION__ ,pBeamInfo->beamformee_mu_cnt, pBeamInfo->beamformee_su_cnt);
	dym_disable_bf_coeff(priv);
	
	memset(candidate, 0, sizeof(candidate));
	get_bf_score(priv);

	if(num_su == 0) {
		clear_bfee_entry(priv, TXBF_TYPE_SU);
	} else {
		get_txbf_candidate(priv, candidate, num_su, TXBF_TYPE_SU);
		assign_txbf_candidate_to_entry(priv, candidate, num_su, TXBF_TYPE_SU);
	}
#if (MU_BEAMFORMING_SUPPORT == 1)
	if(!priv->pmib->dot11RFEntry.txbf_mu)
		return;
	
	if(num_mu == 0) {
		clear_bfee_entry(priv, TXBF_TYPE_MU);
	} else {
		PHYDM_DBG(ODMPTR, DBG_TXBF, "%s %d\n", __FUNCTION__, __LINE__);
		get_txbf_candidate(priv, candidate, num_mu, TXBF_TYPE_MU);
		assign_txbf_candidate_to_entry(priv, candidate, num_mu, TXBF_TYPE_MU);
	}
#endif	

	return;
}
#endif
void DynamicSelect2STA(struct rtl8192cd_priv *priv)
{
#if 1/* (RTL8822B_SUPPORT != 1)*/
	int idx = 0, isCandidate, candidateCtr=0, bfeCtr=0;
	struct stat_info* psta, *candidate1=NULL, *candidate2=NULL;
	struct _RT_BEAMFORMING_INFO* pBeamformingInfo = &(priv->pshare->BeamformingInfo);	
	PRT_BEAMFORMING_ENTRY	pEntry; 			

	if (GET_CHIP_VER(priv) == VERSION_8822B)
		return;
	if(pBeamformingInfo->BeamformeeEntry[0].bUsed && pBeamformingInfo->BeamformeeEntry[1].bUsed) {
		psta = findNextSTA(priv, &idx);
		while(psta) {
			if(psta->expire_to
#ifdef WDS
				&& (psta->state & WIFI_WDS == 0)
#endif
			) {
				if (candidate1 == NULL || psta->bf_score > candidate1->bf_score)
					candidate1 = psta;
			}
			psta = findNextSTA(priv, &idx);
		}
		if(candidate1 ==NULL)
			return;
		idx = 0;
		psta = findNextSTA(priv, &idx);		
		while(psta) {
			if(psta != candidate1 && psta->expire_to
#ifdef WDS
				&& (psta->state & WIFI_WDS == 0)
#endif
			) {
				if(candidate2 == NULL || psta->bf_score > candidate2->bf_score)
					candidate2 = psta;
			}
			psta = findNextSTA(priv, &idx);
		}

		if(candidate1)
			++candidateCtr;
		if(candidate2)
			++candidateCtr;
		{
			for(idx = 0; idx < BEAMFORMEE_ENTRY_NUM; idx++) {
				if( pBeamformingInfo->BeamformeeEntry[idx].bUsed) {			
					isCandidate = 0;					
					if(candidate1 && (pBeamformingInfo->BeamformeeEntry[idx].MacId == candidate1->cmn_info.aid))
						++bfeCtr;
					else if(candidate2 && (pBeamformingInfo->BeamformeeEntry[idx].MacId == candidate2->cmn_info.aid))
						++bfeCtr;					
				}
			}
			candidateCtr -=bfeCtr;
			for(idx = 0; idx < BEAMFORMEE_ENTRY_NUM; idx++)
			{
				if(	pBeamformingInfo->BeamformeeEntry[idx].bUsed) {			
					isCandidate = 0;					
					if(candidate1 && (pBeamformingInfo->BeamformeeEntry[idx].MacId == candidate1->cmn_info.aid))
						isCandidate = 1;		 
					if(candidate2 && (pBeamformingInfo->BeamformeeEntry[idx].MacId == candidate2->cmn_info.aid))
						 isCandidate = 2;
					if(isCandidate==0 && candidateCtr) {
                        
                                        pBeamformingInfo->CurDelBFerBFeeEntrySel = BFeeEntry;

						PHYDM_DBG(ODMPTR, DBG_TXBF, "%s,\n", __FUNCTION__);

						if(Beamforming_DeInitEntry(priv, pBeamformingInfo->BeamformeeEntry[idx].MacAddr))
							Beamforming_Notify(priv);
						
						--candidateCtr;
					}
				}
			}

			if(candidate1) {				
				pEntry = Beamforming_GetEntryByMacId(priv, candidate1->cmn_info.aid, (unsigned char*)&idx);
				if(pEntry == NULL) {
					Beamforming_Enter(priv, candidate1);			
				}
			}
			if(candidate2) 	{				
				pEntry = Beamforming_GetEntryByMacId(priv, candidate2->cmn_info.aid, (unsigned char*)&idx);
				if(pEntry == NULL) {
					Beamforming_Enter(priv, candidate2);			
				}
			}	
		}
	}
#endif
}
#endif // BEAMFORMING_SUPPORT

// which: 0: set basic rates as mine, 1: set basic rates as peer's
 void get_matched_rate(struct rtl8192cd_priv *priv, unsigned char *pRate, int *pLen, int which, int size)
{
	int i, j, num=0;
	UINT8 rate;
	UINT8 found_rate[32];

	for (i=0; i<AP_BSSRATE_LEN; i++) {
		// see if supported rate existed and matched
		rate = AP_BSSRATE[i] & 0x7f;
		if (match_supp_rate(pRate, *pLen, rate)) {
			if (!which) {
				if (AP_BSSRATE[i] & 0x80)
					rate |= 0x80;
			}
			else {
				for (j=0; j<*pLen; j++) {
					if (rate == (pRate[j] & 0x7f)) {
						if (pRate[j] & 0x80)
							rate |= 0x80;
						break;
					}
				}
			}
			found_rate[num++] = rate;
			if (num >= sizeof(found_rate))
				break;
		}
	}

	if (num > size)
		return;

	if (which) {
		for (i=0; i<num; i++) {
			if (found_rate[i] & 0x80)
				break;
		}
		if (i == num) { // no any basic rates in found_rate
			j = 0;
			while(pRate[j] & 0x80)
				j++;
			if (j+num <= size) {
				memcpy(&(pRate[j]), found_rate, num);
				*pLen = j + num;
			}
			return;
		}
	}

	memcpy(pRate, found_rate, num);
	*pLen = num;
}


 void update_support_rate(struct	stat_info *pstat, unsigned char* buf, int len)
{
	if (len > sizeof(pstat->bssrateset))
		return;
	
	memset(pstat->bssrateset, 0, sizeof(pstat->bssrateset));
	pstat->bssratelen=len;
	memcpy(pstat->bssrateset, buf, len);
}


int isErpSta(struct	stat_info *pstat)
{
	int i, len=pstat->bssratelen;
	UINT8 *buf=pstat->bssrateset;

	for (i=0; i<len; i++) {
		if ( ((buf[i] & 0x7f) != 2) &&
				((buf[i] & 0x7f) != 4) &&
				((buf[i] & 0x7f) != 11) &&
				((buf[i] & 0x7f) != 22) )
			return 1;	// ERP sta existed
	}
	return 0;
}

void SelectLowestInitRate(struct rtl8192cd_priv *priv)
{
	struct stat_info	*pstat;
	struct list_head	*phead, *plist;
#ifdef SMP_SYNC
	unsigned long flags = 0;
#endif

	if (priv->pmib->dot11StationConfigEntry.autoRate)
	{
		phead = &priv->asoc_list;

        SMP_LOCK_ASOC_LIST(flags);
		
		plist = phead->next;
		while (plist != phead) 	{
			pstat = list_entry(plist, struct stat_info, asoc_list);
            plist = plist->next;
            
			if ((!pstat->cmn_info.ra_info.disable_ra) && (pstat->expire_to > 0)) {
				if(pstat->current_tx_rate < priv->pshare->phw->LowestInitRate)
					 priv->pshare->phw->LowestInitRate = pstat->current_tx_rate;
			}
		}

        SMP_UNLOCK_ASOC_LIST(flags);
	}
	else if (priv->pmib->dot11StationConfigEntry.fixedTxRate)
		priv->pshare->phw->LowestInitRate = priv->pmib->dot11StationConfigEntry.fixedTxRate;
	else
		priv->pshare->phw->LowestInitRate = _24M_RATE_;

}

/*----------------------------------------------------------------------------
index: the information element id index, limit is the limit for search
-----------------------------------------------------------------------------*/
/**
 *	@brief	Get Information Element
 *
 *		p (Find ID in limit)		\n
 *	+--- -+------------+-----+---	\n
 *	| ... | element ID | len |...	\n
 *	+--- -+------------+-----+---	\n
 *
 *	@param	pbuf	frame data for search
 *	@param	index	the information element id = index (search target)
 *	@param	limit	limit for search
 *
 *	@retval	p	pointer to element ID
 *	@retval	len	p(IE) len
 */
 unsigned char *get_ie(unsigned char *pbuf, int index, int *len, int limit)
{
	unsigned int tmp,i;
	unsigned char *p;

	if (limit < 1)
		return NULL;

	p = pbuf;
	i = 0;
	*len = 0;
	while(1)
	{
		if (*p == index)
		{
			*len = *(p + 1);
			return (p);
		}
		else
		{
			tmp = *(p + 1);
			p += (tmp + 2);
			i += (tmp + 2);
		}
		if (i >= limit)
			break;
	}
	return NULL;
}

/*----------------------------------------------------------------------------
index: the information element with specific oui, limit is the limit for search
-----------------------------------------------------------------------------*/
/**
 *	@brief	Get Information Element
 *
 *		p (Find ID in limit)		\n
 *	+--- -+------------+-----+---	\n
 *	| ... | element ID | len |...	\n
 *	+--- -+------------+-----+---	\n
 *
 *	@param	pbuf	frame data for search
 *	@param	oui		the information element of 221 with oui = oui (search target)
 *	@param	limit	limit for search
 *
 *	@retval	p	pointer to element ID
 *	@retval	len	p(IE) len
 */
unsigned char *get_oui(unsigned char *pbuf, unsigned char *oui, int *len, int limit)
{
	unsigned int tmp,i;
	unsigned char *p;

	if (limit < 1)
		return NULL;

	p = pbuf;
	i = 0;
	*len = 0;
	while(1)
	{
		if (*p == _VENDOR_SPECIFIC_IE_ && !memcmp(p+2,oui,3))
		{
			*len = *(p + 1);
			return (p);
		}
		else
		{
			tmp = *(p + 1);
			p += (tmp + 2);
			i += (tmp + 2);
		}
		if (i >= limit)
			break;
	}
	return NULL;
}

#ifdef RTL_WPA2
/*----------------------------------------------------------------------------
index: the information element id index, limit is the limit for search
-----------------------------------------------------------------------------*/
static unsigned char *get_rsn_ie(struct rtl8192cd_priv *priv, unsigned char *pbuf, int *len, int limit)
{
	unsigned char *p = NULL;

	if (priv->pmib->dot11RsnIE.rsnielen == 0)
		return NULL;

	if ((priv->pmib->dot11RsnIE.rsnie[0] == _RSN_IE_2_) ||
		((priv->pmib->dot11RsnIE.rsnielen > priv->pmib->dot11RsnIE.rsnie[1]) &&
			(priv->pmib->dot11RsnIE.rsnie[priv->pmib->dot11RsnIE.rsnie[1]+2] == _RSN_IE_2_))) {
		p = get_ie(pbuf, _RSN_IE_2_, len, limit);
		if (p != NULL)
			return p;
		else
			return get_ie(pbuf, _RSN_IE_1_, len, limit);
	}
	else {
		p = get_ie(pbuf, _RSN_IE_1_, len, limit);
		if (p != NULL)
			return p;
		else
			return get_ie(pbuf, _RSN_IE_2_, len, limit);
	}
}
#endif


/**
 *	@brief	Set Information Element
 *
 *	Difference between set_fixed_ie, reserve 2 Byte, for Element ID & length \n
 *	\n
 *	+-------+       +------------+--------+----------------+	\n
 *	| pbuf. | <---  | element ID | length |     source     |	\n
 *	+-------+       +------------+--------+----------------+	\n
 *
 *	@param pbuf		buffer(frame) for set
 *	@param index	IE element ID
 *	@param len		IE length content & set length
 *	@param source	IE data for buffer set
 *	@param frlen	total frame length
 *
 *	@retval	pbuf+len+2	pointer of buffer tail.(+2 because element ID and length total 2 bytes)
 */
 unsigned char *set_ie(unsigned char *pbuf, int index, unsigned int len, unsigned char *source,
				unsigned int *frlen)
{
	*pbuf = index;
	*(pbuf + 1) = len;
	if (len > 0)
		memcpy((void *)(pbuf + 2), (void *)source, len);
	*frlen = *frlen + (len + 2);
	return (pbuf + len + 2);
}


static __inline__ int set_virtual_bitmap(unsigned char *pbuf, unsigned int i)
{
	unsigned int r,s,t;

	r = (i >> 3) << 3;
	t = i - r;

	s = BIT(t);

	*(pbuf + (i >> 3)) |= s;

	return	(i >> 3);
}


static __inline__ unsigned char *update_tim(struct rtl8192cd_priv *priv,
				unsigned char *bcn_buf, unsigned int *frlen)
{
#ifdef CONFIG_PCI_HCI
	unsigned int	pre_head;
#endif
	unsigned int	i, set_pvb;
	unsigned char	val8;
#if 1/*!defined(SMP_SYNC) || (defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI))    */
	unsigned long	flags;
#endif
	struct list_head	*plist, *phead;
	struct stat_info	*pstat;
	unsigned char	bitmap[(NUM_STAT/8)+1];
	unsigned char	*pbuf= bcn_buf;
	unsigned char	N1, N2, bitmap_offset;

#ifdef CONFIG_PCI_HCI
#if defined(CONFIG_WLAN_HAL) || defined(CONFIG_RTL_8812_SUPPORT)|| defined(CONFIG_RTL_88E_SUPPORT) || defined(CONFIG_RTL_8723B_SUPPORT)
	unsigned char Q_info[16] = {0};
	unsigned char b_calhwqnum = 0;

	if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE) {
#ifdef  CONFIG_WLAN_HAL
	    if (IS_HAL_CHIP(priv)) {
#ifdef CONFIG_WLAN_HAL_8192FE
			if (GET_CHIP_VER(priv) == VERSION_8192F)
				b_calhwqnum = 16;
			else
#endif
#ifdef CONFIG_WLAN_HAL_8814BE
            if (GET_CHIP_VER(priv) == VERSION_8814B)
                b_calhwqnum = 0;
            else
#endif
	        b_calhwqnum = 8;
	    }
#endif		
#if defined(CONFIG_RTL_8812_SUPPORT) || defined(CONFIG_RTL_8723B_SUPPORT)
	    if(GET_CHIP_VER(priv)== VERSION_8812E || GET_CHIP_VER(priv)== VERSION_8723B)
	        b_calhwqnum = 8;
#endif
#ifdef CONFIG_RTL_88E_SUPPORT
	    if(GET_CHIP_VER(priv)== VERSION_8188E){
	        b_calhwqnum = 4;
	    }
#endif        
#ifdef MULTI_STA_REFINE
		if( priv->pshare->paused_sta_num < b_calhwqnum) 
#endif
		{
		if (b_calhwqnum == 16) {
			unsigned char tmpb = RTL_R8(0x414) & ~0x1f;
			for (i=0; i<16; i++) {
				RTL_W8(0x414, tmpb|i);
				if (RTL_R8(0x401))
					Q_info[i] = RTL_R8(0x404) & 0x7f;
				else
					Q_info[i] = 0;
			}		
		}
	    else if(b_calhwqnum == 8) {
	        for(i=0; i<4; i++) {
#if defined(CONFIG_WLAN_HAL_8814AE) || defined(CONFIG_WLAN_HAL_8822BE) || defined (CONFIG_WLAN_HAL_8197F) || defined(CONFIG_WLAN_HAL_8822CE) || defined(CONFIG_WLAN_HAL_8812FE) 
			if (GET_CHIP_VER(priv) == VERSION_8814A || GET_CHIP_VER(priv) == VERSION_8822B || GET_CHIP_VER(priv) == VERSION_8197F || GET_CHIP_VER(priv) == VERSION_8822C || GET_CHIP_VER(priv) == VERSION_8812F) {
					if((RTL_R16(0x1400+i*2) & 0xFFF))
		                Q_info[i] = (RTL_R8(0x400+i*4+3)>>1) & 0x7f; //31:25     7b
		            else 
		                Q_info[i] = 0;
		            if((RTL_R16(0x1408+i*2) & 0xFFF))
		                Q_info[i+4] = (RTL_R8(0x468+i*4+3)>>1) & 0x7f; //31:25     7b
		            else
		                Q_info[i+4] = 0;
				}
				else
#endif
				{
		            if(RTL_R8(0x400+i*4+1) & 0x7f) // 14:8     7b
		                Q_info[i] = (RTL_R8(0x400+i*4+3)>>1) & 0x7f; //31:25     7b
		            else 
		                Q_info[i] = 0;
		            if(RTL_R8(0x468+i*4+1) & 0x7f) // 14:8     7b
		                Q_info[i+4] = (RTL_R8(0x468+i*4+3)>>1) & 0x7f; //31:25     7b
		            else
		                Q_info[i+4] = 0;
				}
	        }
	    }
	    else if(b_calhwqnum == 4) {
	        for(i=0; i<4; i++) {
	            if(RTL_R8(0x400+i*4+1)){ // 15:8     7b
	                Q_info[i] = (RTL_R8(0x400+i*4+3)>>2) & 0x3f; //31:26     7b
	            }
	            else 
	                Q_info[i] = 0;
	        }

	    }
		}
	}
#endif
#endif // CONFIG_PCI_HCI

	memset(bitmap, 0, sizeof(bitmap));

#if 0/*def MBSSID*/
	if (GET_ROOT(priv)->pmib->miscEntry.vap_enable && IS_VAP_INTERFACE(priv))
		priv->dtimcount = GET_ROOT(priv)->dtimcount;
	else
#endif
	{
		if (priv->dtimcount == 0)
			priv->dtimcount = (priv->pmib->dot11StationConfigEntry.dot11DTIMPeriod - 1);
		else
			priv->dtimcount--;
	}

#ifdef CONFIG_PCI_HCI
	if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE) {
#ifdef  CONFIG_WLAN_HAL
		if (!IS_HAL_CHIP(priv)) 
#endif
		{
			//if (priv->pkt_in_dtimQ && (priv->dtimcount == 0))
			SMP_LOCK_XMIT(flags);
			pre_head = get_txhead(priv->pshare->phw, MCAST_QNUM);
#ifdef OSK_LOW_TX_DESC
			if (MCAST_QNUM!=BE_QUEUE && MCAST_QNUM!=HIGH_QUEUE)
				txdesc_rollback_nonbe(&pre_head);
			else
#endif
			txdesc_rollback(&pre_head);
			SMP_UNLOCK_XMIT(flags);

			if (priv->dtimcount == (priv->pmib->dot11StationConfigEntry.dot11DTIMPeriod - 1)
				&&(*((unsigned char *)priv->beaconbuf + priv->timoffset + 4) & 0x01))  {
				RTL_W16(RD_CTRL, RTL_R16(RD_CTRL) & (~ HIQ_NO_LMT_EN));
			}
			if(priv->dtimcount == (priv->pmib->dot11StationConfigEntry.dot11DTIMPeriod - 1)
				&& !(get_desc((get_txdesc(priv->pshare->phw, MCAST_QNUM) + pre_head)->Dword0) & TX_OWN))
				priv->pkt_in_hiQ = 0;
		}

		if ((priv->dtimcount == 0) &&
			(priv->pkt_in_dtimQ ||
		//		(get_desc((get_txdesc(priv->pshare->phw, MCAST_QNUM) + pre_head)->Dword0) & TX_OWN)))
				priv->pkt_in_hiQ))
			val8 = 0x01;
		else
			val8 = 0x00;
	}
#endif // CONFIG_PCI_HCI

#if defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI)
	if (GET_HCI_TYPE(priv) == RTL_HCI_USB || GET_HCI_TYPE(priv) == RTL_HCI_SDIO) {
		int run = 0;

#ifdef CONFIG_USB_HCI
		if (GET_HCI_TYPE(priv) == RTL_HCI_USB) {
			if (priv->pshare->tx_urb_waiting_queue[MCAST_QNUM].qlen > 0) {
				run = 1;
			}
		}
#endif
#ifdef CONFIG_SDIO_HCI
		if (GET_HCI_TYPE(priv) == RTL_HCI_SDIO) {
			if (priv->pshare->tx_xmitbuf_waiting_queue[MCAST_QNUM].qlen > 0) {
				run = 1;
			}
		}
#endif
		if ((priv->dtimcount == 0)
				&& (((MCAST_QNUM == priv->tx_mc_queue.q_num) && (tx_servq_len(&priv->tx_mc_queue) > 0))
				|| run
#if defined(CONFIG_RTL_88E_SUPPORT)
				|| (RTL_R8(HIQ_INFO+1))
#elif defined(CONFIG_WLAN_HAL_8192EE)
				|| (RTL_R8(HIQ_INFO+1) & 0x7F)
#else
				|| (RTL_R8(HIQ_INFO+2))
#endif
				))
			val8 = 0x01;
		else
			val8 = 0x00;
	}
#endif // CONFIG_USB_HCI || CONFIG_SDIO_HCI

#if defined(CONFIG_WLAN_HAL) && defined(CONFIG_PCI_HCI)
	if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE) {
	    if (IS_HAL_CHIP(priv)) 
	    {
	        u1Byte num_acq;
#if IS_RTL88XX_MAC_V4
	        if(_GET_HAL_DATA(priv)->MacVersion.is_MAC_v4)    
	            num_acq = NUM_AC_QUEUE_V1;
#endif
#if IS_RTL88XX_MAC_V1_V2
        if(_GET_HAL_DATA(priv)->MacVersion.is_MAC_v1_v2)    
	            num_acq = NUM_AC_QUEUE;
#endif
#if IS_RTL88XX_MAC_V3
        if(_GET_HAL_DATA(priv)->MacVersion.is_MAC_v3)    
            num_acq = NUM_AC_QUEUE_V2;
#endif

	        u1Byte	macID_list[num_acq];
	        u1Byte	macID_index;
	      	memset(macID_list, 0, num_acq);    
	        if(RT_STATUS_SUCCESS == GET_HAL_INTERFACE(priv)->GetMACIDQueueInTXPKTBUFHandler(priv,macID_list))
	        {
	            for(macID_index=0;macID_index < num_acq ;macID_index++)
	            {
	                if(macID_list[macID_index]!=0)
	                {
	                    set_virtual_bitmap(bitmap, macID_list[macID_index]);
	                }
	            }        
	        }
	    }
	}
#endif //#ifdef CONFIG_WLAN_HAL

	*pbuf = _TIM_IE_;
	*(pbuf + 2) = priv->dtimcount;
	*(pbuf + 3) = priv->pmib->dot11StationConfigEntry.dot11DTIMPeriod;

	phead = &priv->sleep_list;

	SAVE_INT_AND_CLI(flags);
	SMP_LOCK_SLEEP_LIST(flags);

	plist = phead->next;
	while(plist != phead)
	{
		pstat = list_entry(plist, struct stat_info, sleep_list);
		plist = plist->next;
		set_pvb = 0;
#if defined(MULTI_STA_REFINE) && defined(SW_TX_QUEUE)
		if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE && priv->pshare->paused_sta_num >= b_calhwqnum) {
			set_pvb = 0x01;
		} else 
#endif			
		{
#if defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI)
			if (GET_HCI_TYPE(priv) == RTL_HCI_USB || GET_HCI_TYPE(priv) == RTL_HCI_SDIO) {
				for (i = BK_QUEUE; i <= VO_QUEUE; ++i) {
					if (tx_servq_len(&pstat->tx_queue[i]) > 0) {
						set_pvb++;
						break;
					}
				}
			}
#endif
#if defined(CONFIG_PCI_HCI)
			if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE) {
#ifdef SW_TXQ_ATF
				if (pstat->swq.atf_cnt)
					set_pvb++;
				else
#endif
#if defined(WIFI_WMM)
				if(!isFFempty(pstat->MGT_dz_queue->head, pstat->MGT_dz_queue->tail))
					set_pvb++;
				else
#if defined(WMM_APSD)
				if ((QOS_ENABLE) && (APSD_ENABLE) && (pstat) && ((pstat->apsd_bitmap & 0x0f) == 0x0f) &&
					((!isFFempty(pstat->VO_dz_queue->head, pstat->VO_dz_queue->tail)) ||
					 (!isFFempty(pstat->VI_dz_queue->head, pstat->VI_dz_queue->tail)) ||
					 (!isFFempty(pstat->BE_dz_queue->head, pstat->BE_dz_queue->tail)) ||
					 (!isFFempty(pstat->BK_dz_queue->head, pstat->BK_dz_queue->tail)))) {
					set_pvb++;
				}
				else
#endif
#endif
				if (pstat->delsta_flag)
					set_pvb++;
				else if (skb_queue_len(&pstat->dz_queue))
					set_pvb++;

#if defined(CONFIG_WLAN_HAL) || defined(CONFIG_RTL_8812_SUPPORT)|| defined(CONFIG_RTL_88E_SUPPORT) || defined(CONFIG_RTL_8723B_SUPPORT)
		        if(set_pvb == 0 && b_calhwqnum) {
		            for(i=0; i<b_calhwqnum; i++) {
		                if(REMAP_AID(pstat) == Q_info[i]) {
		                    set_pvb++;
		                    break;
		                }
		            }
		        }
#endif
			}
#endif
		}

		if (set_pvb) {
			i = pstat->cmn_info.aid;
			i = set_virtual_bitmap(bitmap, i);
		}
	}

	SMP_UNLOCK_SLEEP_LIST(flags);
	RESTORE_INT(flags);

	if(priv->pshare->rf_ft_var.wakeforce) {

		unsigned int idx, txtp = 0;
		idx = 0;
		
		pstat = findNextSTA(priv, &idx); 
		
		while(pstat) {
				txtp = (unsigned int)(pstat->tx_avarage>>17);
				
				if(txtp >= priv->pshare->rf_ft_var.waketh) {
		
					if(priv->pshare->rf_ft_var.wakeforce == 1){
						val8 = 1;
						break;
					}
					else if(priv->pshare->rf_ft_var.wakeforce == 2){
						i = pstat->cmn_info.aid;
						i = set_virtual_bitmap(bitmap, i);
					}
				}
				
				pstat = findNextSTA(priv, &idx); 		
		}
		
	}

	N1 = 0;
	for(i=0; i<(NUM_STAT/8)+1; i++) {
		if(bitmap[i] != 0) {
			N1 = i;
			break;
		}
	}
	N2 = N1;
	for(i=(NUM_STAT/8); i>N1; i--) {
		if(bitmap[i] != 0) {
			N2 = i;
			break;
		}
	}

	// N1 should be an even number
	N1 = (N1 & 0x01)? (N1-1) : N1;
	bitmap_offset = N1 >> 1;	// == N1/2
	*(pbuf + 1) = N2 - N1 + 4;
	*(frlen) = *frlen + *(pbuf + 1) + 2;

	*(pbuf + 4) = val8 | (bitmap_offset << 1);
	memcpy((void *)(pbuf + 5), &bitmap[N1], (N2-N1+1));

	return (bcn_buf + *(pbuf + 1) + 2);
}

/**
 *	@brief	set fixed information element
 *
 *	set_fixed is haven't Element ID & length, Total length is frlen. \n
 *					 len	\n
 *	+-----------+-----------+	\n
 *	|	pbuf	|   source  |	\n
 *	+-----------+-----------+	\n
 *
 *	@param	pbuf	buffer(frame) for set
 *	@param	len		IE set length
 *	@param	source	IE data for buffer set
 *	@param	frlen	total frame length (Note: frlen have side effect??)
 *
 *	@retval	pbuf+len	pointer of buffer tail. \n
 */
 unsigned char *set_fixed_ie(unsigned char *pbuf, unsigned int len, unsigned char *source,
				unsigned int *frlen)
{
	memcpy((void *)pbuf, (void *)source, len);
	*frlen = *frlen + len;
	return (pbuf + len);
}

#if defined(HS2_SUPPORT) || defined(DOT11K)    
static unsigned char * construct_BSS_load_ie(struct rtl8192cd_priv *priv, unsigned char	*pbuf, unsigned int *frlen)
{
    *(unsigned short *)priv->pmib->hs2Entry.bssload_ie = cpu_to_le16((unsigned short)priv->assoc_num);
    priv->pmib->hs2Entry.bssload_ie[2] = priv->ext_stats.ch_utilization;
    priv->pmib->hs2Entry.bssload_ie[3] = 0;
    priv->pmib->hs2Entry.bssload_ie[4] = 0;
    pbuf = set_ie(pbuf, _BSS_LOAD_IE_, 5, priv->pmib->hs2Entry.bssload_ie, frlen);
    return pbuf;
}
#endif

void construct_ht_ie(struct rtl8192cd_priv *priv, int use_40m, int offset)
{
	struct ht_cap_elmt	*ht_cap;
	struct ht_info_elmt	*ht_ie;
	int ch_offset;

	if (priv->ht_cap_len == 0) {
		unsigned int sup_mcs = get_supported_mcs(priv);
		// construct HT Capabilities element
		priv->ht_cap_len = sizeof(struct ht_cap_elmt);
		ht_cap = &priv->ht_cap_buf;
		memset(ht_cap, 0, sizeof(struct ht_cap_elmt));
		if (use_40m >= CHANNEL_WIDTH_40 && use_40m <= CHANNEL_WIDTH_80_80){
			ht_cap->ht_cap_info |= cpu_to_le16(_HTCAP_SUPPORT_CH_WDTH_);
		}
		ht_cap->ht_cap_info |= cpu_to_le16(_HTCAP_SMPWR_DISABLE_);
		ht_cap->ht_cap_info |= cpu_to_le16(priv->pmib->dot11nConfigEntry.dot11nShortGIfor20M? _HTCAP_SHORTGI_20M_ : 0);

		if ((use_40m == CHANNEL_WIDTH_40 && use_40m <= CHANNEL_WIDTH_80_80) 
		|| (priv->pmib->dot11nConfigEntry.dot11nUse40M==1)  
		|| (priv->pmib->dot11nConfigEntry.dot11nUse40M==2)
		|| (priv->pmib->dot11nConfigEntry.dot11nUse40M==3)
		|| (priv->pmib->dot11nConfigEntry.dot11nUse40M==4)) {
			ht_cap->ht_cap_info |= cpu_to_le16(priv->pmib->dot11nConfigEntry.dot11nShortGIfor40M? _HTCAP_SHORTGI_40M_ : 0);
		}
		if ((get_rf_mimo_mode(priv) == RF_1T1R) 
#ifdef CONFIG_RTL_92C_SUPPORT
			|| (GET_CHIP_VER(priv) == VERSION_8192C)
#endif
		)
			ht_cap->ht_cap_info |= cpu_to_le16(priv->pmib->dot11nConfigEntry.dot11nSTBC? _HTCAP_RX_STBC_1S_ : 0);
		else {
#ifdef CONFIG_WLAN_HAL_8822BE
			//8822 A/B-cut disable RX STBC
			if(GET_CHIP_VER(priv) == VERSION_8822B && GET_CHIP_VER_8822(priv) <= 0x1)
				ht_cap->ht_cap_info |= cpu_to_le16(priv->pmib->dot11nConfigEntry.dot11nSTBC? _HTCAP_TX_STBC_ : 0);
			else
#endif
				ht_cap->ht_cap_info |= cpu_to_le16(priv->pmib->dot11nConfigEntry.dot11nSTBC? (_HTCAP_TX_STBC_ | _HTCAP_RX_STBC_1S_) : 0);
		}
		
		if (can_enable_rx_ldpc(priv)) 	
		ht_cap->ht_cap_info |= cpu_to_le16((priv->pmib->dot11nConfigEntry.dot11nLDPC&1)? (_HTCAP_SUPPORT_RX_LDPC_) : 0);

		ht_cap->ht_cap_info |= cpu_to_le16(priv->pmib->dot11nConfigEntry.dot11nAMSDURecvMax? _HTCAP_AMSDU_LEN_8K_ : 0);
		ht_cap->ht_cap_info |= cpu_to_le16(_HTCAP_CCK_IN_40M_);
// 64k
#if	defined(CONFIG_RTL_8812_SUPPORT) || defined(CONFIG_RTL_8723B_SUPPORT)
		if (GET_CHIP_VER(priv)==VERSION_8812E || GET_CHIP_VER(priv)==VERSION_8723B) {
#if 1
			ht_cap->ampdu_para = ((_HTCAP_AMPDU_SPC_16_US_ << _HTCAP_AMPDU_SPC_SHIFT_) | _HTCAP_AMPDU_FAC_64K_);		
#else
			if (priv->pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm)
				ht_cap->ampdu_para = ((_HTCAP_AMPDU_SPC_16_US_ << _HTCAP_AMPDU_SPC_SHIFT_) | _HTCAP_AMPDU_FAC_64K_);		
			else
				ht_cap->ampdu_para = ((_HTCAP_AMPDU_SPC_8_US_ << _HTCAP_AMPDU_SPC_SHIFT_) | _HTCAP_AMPDU_FAC_64K_);
#endif				
		} else 
#endif		
#if	defined(CONFIG_WLAN_HAL)
		if (GET_CHIP_VER(priv)==VERSION_8192E) {
			ht_cap->ampdu_para = ((_HTCAP_AMPDU_SPC_4_US_ << _HTCAP_AMPDU_SPC_SHIFT_) | _HTCAP_AMPDU_FAC_64K_);		
		} else if (GET_CHIP_VER(priv)==VERSION_8192F) {
			ht_cap->ampdu_para = ((_HTCAP_AMPDU_SPC_4_US_ << _HTCAP_AMPDU_SPC_SHIFT_) | _HTCAP_AMPDU_FAC_64K_);
		} else
#endif	
		{
			if (priv->pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm) {
#if defined(CONFIG_WLAN_HAL_8814AE) 	
				if ((GET_CHIP_VER(priv) == VERSION_8814A)) {
					if(priv->pmib->dot11nConfigEntry.dot11nUse40M == CHANNEL_WIDTH_20)
						ht_cap->ampdu_para = ((_HTCAP_AMPDU_SPC_4_US_ << _HTCAP_AMPDU_SPC_SHIFT_) | _HTCAP_AMPDU_FAC_32K_);	
					else
						ht_cap->ampdu_para = ((_HTCAP_AMPDU_SPC_4_US_ << _HTCAP_AMPDU_SPC_SHIFT_) | _HTCAP_AMPDU_FAC_64K_);					
				}	
				else
#endif	

#if	defined(CONFIG_WLAN_HAL_8822BE)		
				if (GET_CHIP_VER(priv)==VERSION_8822B) {
					ht_cap->ampdu_para = ((_HTCAP_AMPDU_SPC_4_US_ << _HTCAP_AMPDU_SPC_SHIFT_) | _HTCAP_AMPDU_FAC_64K_);
				}
				else
#endif
#if	defined(CONFIG_WLAN_HAL_8822CE)		
				if (GET_CHIP_VER(priv)==VERSION_8822C) {
					ht_cap->ampdu_para = ((_HTCAP_AMPDU_SPC_2_US_ << _HTCAP_AMPDU_SPC_SHIFT_) | _HTCAP_AMPDU_FAC_32K_); 
				}
				else
#endif
#if	defined(CONFIG_WLAN_HAL_8812FE)		
				if (GET_CHIP_VER(priv)==VERSION_8812F) {
					ht_cap->ampdu_para = ((_HTCAP_AMPDU_SPC_4_US_ << _HTCAP_AMPDU_SPC_SHIFT_) | _HTCAP_AMPDU_FAC_64K_);
				}
				else
#endif
#if	defined(CONFIG_WLAN_HAL_8198F) || defined(CONFIG_WLAN_HAL_8814BE)
				if ((GET_CHIP_VER(priv)==VERSION_8198F) || (GET_CHIP_VER(priv)==VERSION_8814B)) {
					ht_cap->ampdu_para = ((_HTCAP_AMPDU_SPC_2_US_ << _HTCAP_AMPDU_SPC_SHIFT_) | _HTCAP_AMPDU_FAC_64K_); 
				}
				else
#endif
				ht_cap->ampdu_para = ((_HTCAP_AMPDU_SPC_16_US_ << _HTCAP_AMPDU_SPC_SHIFT_) | _HTCAP_AMPDU_FAC_32K_);
			}
			else {
#ifdef RTK_AC_SUPPORT //for 11ac logo
#if	defined(CONFIG_WLAN_HAL_8822BE)
				if(GET_CHIP_VER(priv) == VERSION_8822B)
					ht_cap->ampdu_para = ((_HTCAP_AMPDU_SPC_4_US_ << _HTCAP_AMPDU_SPC_SHIFT_) | _HTCAP_AMPDU_FAC_64K_);
				else
#endif
				if ((GET_CHIP_VER(priv) == VERSION_8812E) || (GET_CHIP_VER(priv) == VERSION_8881A) || (GET_CHIP_VER(priv) == VERSION_8814A) || (GET_CHIP_VER(priv) == VERSION_8814B)) {
					if((GET_CHIP_VER(priv) == VERSION_8814A) && priv->pmib->dot11nConfigEntry.dot11nUse40M== CHANNEL_WIDTH_20)
						ht_cap->ampdu_para = ((_HTCAP_AMPDU_SPC_NORES_ << _HTCAP_AMPDU_SPC_SHIFT_) | _HTCAP_AMPDU_FAC_32K_);	
					else
						ht_cap->ampdu_para = ((_HTCAP_AMPDU_SPC_NORES_ << _HTCAP_AMPDU_SPC_SHIFT_) | _HTCAP_AMPDU_FAC_64K_);
				} else
#endif
#if	defined(CONFIG_WLAN_HAL_8812FE)
				if(GET_CHIP_VER(priv) == VERSION_8812F)
					ht_cap->ampdu_para = ((_HTCAP_AMPDU_SPC_4_US_ << _HTCAP_AMPDU_SPC_SHIFT_) | _HTCAP_AMPDU_FAC_64K_);
				else
#endif
#if	defined(CONFIG_WLAN_HAL_8198F)		
				if (GET_CHIP_VER(priv)==VERSION_8198F) {
					ht_cap->ampdu_para = ((_HTCAP_AMPDU_SPC_NORES_ << _HTCAP_AMPDU_SPC_SHIFT_) | _HTCAP_AMPDU_FAC_64K_); 
				}
				else
#endif
				ht_cap->ampdu_para = ((_HTCAP_AMPDU_SPC_8_US_ << _HTCAP_AMPDU_SPC_SHIFT_) | _HTCAP_AMPDU_FAC_32K_);
			}

		}
		if (priv->pshare->rf_ft_var.ampdu_min_spacing != 0xff) {
			ht_cap->ampdu_para &= ~_HTCAP_AMPDU_SPC_MASK_;
			ht_cap->ampdu_para |= (priv->pshare->rf_ft_var.ampdu_min_spacing <<_HTCAP_AMPDU_SPC_SHIFT_) & _HTCAP_AMPDU_SPC_MASK_;
		}
		ht_cap->support_mcs[0] = (sup_mcs & 0xff);
		ht_cap->support_mcs[1] = (sup_mcs & 0xff00) >> 8;
		ht_cap->support_mcs[2] = (sup_mcs & 0xff0000) >> 16;
		ht_cap->support_mcs[3] = (sup_mcs & 0xff000000) >> 24;
		ht_cap->ht_ext_cap = 0;
#if (BEAMFORMING_SUPPORT == 1)		
		if ((priv->pshare->WlanSupportAbility & WLAN_BEAMFORMING_SUPPORT) && (priv->pmib->dot11RFEntry.txbf == 1)){
			if ((priv->pmib->dot11RFEntry.txbfer == 1) && (priv->pmib->dot11RFEntry.txbfee == 0))
				{
				if((GET_CHIP_VER(priv) == VERSION_8814A)||(GET_CHIP_VER(priv) == VERSION_8814B)||(GET_CHIP_VER(priv) == VERSION_8198F))
					ht_cap->txbf_cap = cpu_to_le32(0x18000410);
				else
					ht_cap->txbf_cap = cpu_to_le32(0x08000410);
				}
			else if ((priv->pmib->dot11RFEntry.txbfer == 0) && (priv->pmib->dot11RFEntry.txbfee == 1))
				{
				if((GET_CHIP_VER(priv) == VERSION_8814A)||(GET_CHIP_VER(priv) == VERSION_8814B)||(GET_CHIP_VER(priv) == VERSION_8198F))
					ht_cap->txbf_cap = cpu_to_le32(0x01810008);
				else
					ht_cap->txbf_cap = cpu_to_le32(0x00810008);
				}
			else 
				{
				if((GET_CHIP_VER(priv) == VERSION_8814A)||(GET_CHIP_VER(priv) == VERSION_8814B)||(GET_CHIP_VER(priv) == VERSION_8198F)||(GET_CHIP_VER(priv) == VERSION_8812F))
					ht_cap->txbf_cap = cpu_to_le32(0x19810418);
				else
					ht_cap->txbf_cap = cpu_to_le32(0x08810418);
				}
		}
		else
#endif
		ht_cap->txbf_cap = 0;
		ht_cap->asel_cap = 0;

#ifdef CLIENT_MODE
		if ((OPMODE & WIFI_AP_STATE) || (OPMODE & WIFI_ADHOC_STATE))
#endif
		{
			// construct HT Information element
			priv->ht_ie_len = sizeof(struct ht_info_elmt);
			ht_ie = &priv->ht_ie_buf;
			memset(ht_ie, 0, sizeof(struct ht_info_elmt));
			ht_ie->primary_ch = priv->pmib->dot11RFEntry.dot11channel;
			if ((use_40m >= CHANNEL_WIDTH_40) && (use_40m <= CHANNEL_WIDTH_80_80)) { 
				if (offset == HT_2NDCH_OFFSET_BELOW)
					ch_offset = _HTIE_2NDCH_OFFSET_BL_ | _HTIE_STA_CH_WDTH_;
				else
					ch_offset = _HTIE_2NDCH_OFFSET_AB_ | _HTIE_STA_CH_WDTH_;
			} else {
				ch_offset = _HTIE_2NDCH_OFFSET_NO_;
			}

			ht_ie->info0 |= ch_offset;
			ht_ie->info1 = 0;
			ht_ie->info2 = 0;
			ht_ie->basic_mcs[0] = (priv->pmib->dot11nConfigEntry.dot11nBasicMCS & 0xff);
			ht_ie->basic_mcs[1] = (priv->pmib->dot11nConfigEntry.dot11nBasicMCS & 0xff00) >> 8;
			ht_ie->basic_mcs[2] = (priv->pmib->dot11nConfigEntry.dot11nBasicMCS & 0xff0000) >> 16;
			ht_ie->basic_mcs[3] = (priv->pmib->dot11nConfigEntry.dot11nBasicMCS & 0xff000000) >> 24;
		}
	}
	else
#ifdef CLIENT_MODE
	if ((OPMODE & WIFI_AP_STATE) || (OPMODE & WIFI_ADHOC_STATE) )
#endif
	{
#ifdef WIFI_11N_2040_COEXIST
		if (priv->pmib->dot11nConfigEntry.dot11nCoexist && (OPMODE & WIFI_AP_STATE)) {
			ht_ie = &priv->ht_ie_buf;
			ht_ie->info0 &= ~(_HTIE_2NDCH_OFFSET_BL_ | _HTIE_STA_CH_WDTH_);
			if (use_40m && (!COEXIST_ENABLE || !(priv->bg_ap_timeout || orForce20_Switch20Map(priv))) ) {
				if (offset == HT_2NDCH_OFFSET_BELOW)
					ch_offset = _HTIE_2NDCH_OFFSET_BL_ | _HTIE_STA_CH_WDTH_;
				else
					ch_offset = _HTIE_2NDCH_OFFSET_AB_ | _HTIE_STA_CH_WDTH_;
			} else {
				ch_offset = _HTIE_2NDCH_OFFSET_NO_;
			}
			ht_ie->info0 |= ch_offset;
		}
#endif
		if (!priv->pmib->dot11StationConfigEntry.protectionDisabled) {
			if (priv->ht_legacy_obss_to || priv->ht_legacy_sta_num)
				priv->ht_protection = 1;
			else
				priv->ht_protection = 0;;
		}

		if (priv->ht_legacy_sta_num) {
			priv->ht_ie_buf.info1 |= cpu_to_le16(_HTIE_OP_MODE3_);
		} else if (priv->ht_legacy_obss_to || priv->ht_nomember_legacy_sta_to) {
			priv->ht_ie_buf.info1 &= cpu_to_le16(~_HTIE_OP_MODE3_);
			priv->ht_ie_buf.info1 |= cpu_to_le16(_HTIE_OP_MODE1_);
		} else {
			priv->ht_ie_buf.info1 &= cpu_to_le16(~_HTIE_OP_MODE3_);
		}

		if (priv->ht_protection)
			priv->ht_ie_buf.info1 |= cpu_to_le16(_HTIE_OBSS_NHT_STA_);
		else
			priv->ht_ie_buf.info1 &= cpu_to_le16(~_HTIE_OBSS_NHT_STA_);
	}
#if defined(UNIVERSAL_REPEATER)
	if( IS_DRV_OPEN(GET_VXD_PRIV(GET_ROOT(priv)))) {
		ht_cap = &priv->ht_cap_buf;
		if( (GET_ROOT(priv)->pmib->dot11nConfigEntry.dot11nUse40M != CHANNEL_WIDTH_10)
		&& (GET_ROOT(priv)->pmib->dot11nConfigEntry.dot11nUse40M != CHANNEL_WIDTH_5)
		&& (GET_ROOT(priv)->pmib->dot11nConfigEntry.dot11nUse40M > CHANNEL_WIDTH_20 && GET_ROOT(priv)->pmib->dot11nConfigEntry.dot11nUse40M <= CHANNEL_WIDTH_80_80))
			ht_cap->ht_cap_info |= cpu_to_le16( _HTCAP_SUPPORT_CH_WDTH_ | _HTCAP_SHORTGI_40M_);
	}
#endif
}


unsigned char *construct_ht_ie_old_form(struct rtl8192cd_priv *priv, unsigned char *pbuf, unsigned int *frlen)
{
	unsigned char old_ht_ie_id[] = {0x00, 0x90, 0x4c};

	*pbuf = _RSN_IE_1_;
	*(pbuf + 1) = 3 + 1 + priv->ht_cap_len;
	memcpy((pbuf + 2), old_ht_ie_id, 3);
	*(pbuf + 5) = 0x33;
	memcpy((pbuf + 6), (unsigned char *)&priv->ht_cap_buf, priv->ht_cap_len);
	*frlen += (*(pbuf + 1) + 2);
	pbuf +=(*(pbuf + 1) + 2);

	*pbuf = _RSN_IE_1_;
	*(pbuf + 1) = 3 + 1 + priv->ht_ie_len;
	memcpy((pbuf + 2), old_ht_ie_id, 3);
	*(pbuf + 5) = 0x34;
	memcpy((pbuf + 6), (unsigned char *)&priv->ht_ie_buf, priv->ht_ie_len);
	*frlen += (*(pbuf + 1) + 2);
	pbuf +=(*(pbuf + 1) + 2);

	return pbuf;
}

#ifdef ENABLE_SAE_H2E
void construct_bss_mem_ie(struct rtl8192cd_priv *priv, u8 *tmp, u32 *flen)
{
	u8 len = *flen;

	if ( len == 8 || priv->pmib->dot1180211AuthEntry.dot11SAEPwe != 1 )
		return;

	*(tmp + len) = 0x80 | BSS_MEMBERSHIP_SELECTOR_SAE_H2E_ONLY;
	*flen = len + 1;
}

int construct_rsnxe_ie(u8 *tmp)
{
	u16 capab = 0;
	size_t flen;

	capab |= BIT(WLAN_RSNX_CAPAB_SAE_H2E);
	// capab |= BIT(WLAN_RSNX_CAPAB_SECURE_LTF);
	// capab |= BIT(WLAN_RSNX_CAPAB_SECURE_RTT);
	// capab |= BIT(WLAN_RSNX_CAPAB_PROT_RANGE_NEG);

	flen = (capab & 0xff00) ? 2 : 1;
	capab |= flen - 1;

	*tmp++ = capab & 0x00ff;
	capab >>= 8;
	if (capab)
		*tmp++ = capab;

	return flen;
}
#endif

#ifdef WIFI_11N_2040_COEXIST
void construct_obss_scan_para_ie(struct rtl8192cd_priv *priv)
{
	struct obss_scan_para_elmt		*obss_scan_para;

	if (priv->obss_scan_para_len == 0) {
		priv->obss_scan_para_len = sizeof(struct obss_scan_para_elmt);
		obss_scan_para = &priv->obss_scan_para_buf;
		memset(obss_scan_para, 0, sizeof(struct obss_scan_para_elmt));

		// except word2, all are default values and meaningless for ap at present
		obss_scan_para->word0 = cpu_to_le16(0x14);
		obss_scan_para->word1 = cpu_to_le16(0x0a);
		obss_scan_para->word2 = cpu_to_le16(180);	// set as 180 second for 11n test plan
		obss_scan_para->word3 = cpu_to_le16(0xc8);
		obss_scan_para->word4 = cpu_to_le16(0x14);
		obss_scan_para->word5 = cpu_to_le16(5);
		obss_scan_para->word6 = cpu_to_le16(0x19);
	}
}

int bg_ap_rssi_chk(struct rtl8192cd_priv *priv, struct rx_frinfo *pfrinfo, int channel)
{
	int i;
	int ch_begin = -1;
	int ch_end = -1;
	int chk_l = 0;
	int chk_h = 0;

	for (i = 0; i < priv->available_chnl_num; i++)
	{
		if (priv->available_chnl[i] <= 14)
		{
			if (ch_begin == -1)
				ch_begin = priv->available_chnl[i];

			ch_end = priv->available_chnl[i];
		}
		else
			break;
	}


	if (priv->pmib->dot11RFEntry.dot11channel && (priv->pmib->dot11RFEntry.dot11channel <= 14))
	{
		if (priv->pshare->offset_2nd_chan == HT_2NDCH_OFFSET_ABOVE)
		{
			chk_l = priv->pmib->dot11RFEntry.dot11channel + 2 - 5; 
			chk_h = priv->pmib->dot11RFEntry.dot11channel + 2 + 5; 
		}

		if (priv->pshare->offset_2nd_chan == HT_2NDCH_OFFSET_BELOW)
		{
			chk_l = priv->pmib->dot11RFEntry.dot11channel - 2 - 5; 
			chk_h = priv->pmib->dot11RFEntry.dot11channel - 2 + 5; 
		}
		
		if (chk_l < ch_begin)
			chk_l = ch_begin;
		if (chk_h > ch_end)
			chk_h = ch_end; 

		if ((channel >= chk_l) && (channel <= chk_h))
		{
			if (pfrinfo->rf_info.rssi >= priv->pmib->dot11nConfigEntry.dot11nBGAPRssiChkTh)
				return 1;
		}
	}
	
	return 0;
}
#endif

#ifdef CONFIG_IEEE80211R_CLI
unsigned char *ft_auth_construct_fast_bss_transition_ie(struct rtl8192cd_priv *priv, unsigned char *pbuf, unsigned int *frlen)
{
	struct r1_key_holder *r1kh;
	unsigned char *pos;
	unsigned char temp[512];
	memset(temp, 0, sizeof(temp));

	r1kh = search_r1kh(priv, priv->init_ap, priv->init_ap);
	if (!r1kh) {
		DEBUG_ERR("Can't ger R1KH\n");
		return -1;
	}

	pos = temp;
	memcpy((pos+2), priv->FT_MIC, KEY_MIC_LEN);
	SetFTMICCtrl(pos, 3);
	
	pos += 18;
	memcpy(pos, priv->ftie_ANonce.Octet, KEY_NONCE_LEN);
	pos += KEY_NONCE_LEN;
	memcpy(pos, priv->ftie_SNonce.Octet, KEY_NONCE_LEN);
	pos += KEY_NONCE_LEN;

	*pos++ = _FT_R1KH_ID_SUB_IE_;
	*pos++ = MACADDRLEN;
	memcpy(pos, priv->cur_ap, MACADDRLEN);
	pos += MACADDRLEN;

	*pos++ = _FT_R0KH_ID_SUB_IE_;
	*pos++ = r1kh->r0kh_id_len;
	memcpy(pos, r1kh->r0kh_id, r1kh->r0kh_id_len);
	pos += r1kh->r0kh_id_len;

	//debug_out("Reassoc req MIC ",priv->FT_MIC, KEY_MIC_LEN);
	pbuf = set_ie(pbuf, _FAST_BSS_TRANSITION_IE_, pos - temp, temp, frlen);
	return pbuf;
}

unsigned char *ft_auth_set_ft_rsnie_with_pmkid(struct rtl8192cd_priv *priv, unsigned char *pbuf, unsigned int *frlen)
{
	struct r1_key_holder *r1kh = NULL;
	WPA_GLOBAL_INFO *pGblInfo = priv->wpa_global_info;
	unsigned char *pos, *rsnie;
	unsigned int rsnie_len;

	pos = pbuf;
	
	if (priv->pmib->dot1180211AuthEntry.dot11EnablePSK) {
	
		rsnie = get_ie(pGblInfo->AuthInfoElement.Octet, _RSN_IE_2_, &rsnie_len, pGblInfo->AuthInfoElement.Length);
	} else
		rsnie = get_ie(priv->pmib->dot11RsnIE.rsnie, _RSN_IE_2_, &rsnie_len, priv->pmib->dot11RsnIE.rsnielen);
	
	
	if (!rsnie) {
		panic_printk("%s: fail to get rsnie\n", __FUNCTION__);
		return pbuf;
	}
	
	rsnie_len = pGblInfo->AuthInfoElement.Length;
	
#ifdef CONFIG_IEEE80211W
	if (priv->pmib->dot1180211AuthEntry.dot11IEEE80211W != NO_MGMT_FRAME_PROTECTION) {
		memcpy(pos, rsnie, rsnie_len - 6);
		pos += (rsnie_len - 6);
	} else
#endif	
	{
		memcpy(pos, rsnie, rsnie_len);
		pos += rsnie_len;
		
	}
	*((unsigned short *)pos) = cpu_to_le16(1);
	pos += 2;
	
	//PMR_R1_NAME
	r1kh = search_r1kh(priv, priv->cur_ap, priv->cur_ap);	
	memcpy(pos, r1kh->pmk_r1_name, PMKID_LEN);
	pos += PMKID_LEN;
	*(pbuf + 1) = PMKID_LEN + rsnie_len;

	*frlen += (pos - pbuf);
	
	return pos;
}


#endif

#ifdef CONFIG_IEEE80211R
unsigned char *set_ft_rsnie_with_pmkid(struct rtl8192cd_priv *priv, unsigned char *pbuf, unsigned int *frlen, struct stat_info *pstat, unsigned int id)
{
	struct r1_key_holder *r1kh = NULL;
	WPA_STA_INFO *pStaInfo = pstat->wpa_sta_info;
	WPA_GLOBAL_INFO *pGblInfo = priv->wpa_global_info;
	unsigned char *pos, *rsnie;
	unsigned int rsnie_len;
	
#ifdef CONFIG_IEEE80211R_CLI
	if((pstat->ft_state == state_ft_auth_req) && (OPMODE & WIFI_STATION_STATE)) {
		r1kh = search_r1kh(priv, priv->init_ap, priv->init_ap);
		if (!r1kh) 	return;
		
		//debug_out("R0kh name: ", r1kh->pmk_r0_name, PMKID_LEN);
	} else
#endif		
	if (id >= 3 || pStaInfo->r1kh == NULL) {
		return pbuf;
	}
	
	pos = pbuf;

	if (priv->pmib->dot1180211AuthEntry.dot11EnablePSK)
		rsnie = get_ie(pGblInfo->AuthInfoElement.Octet, _RSN_IE_2_, &rsnie_len, pGblInfo->AuthInfoElement.Length);
	else
		rsnie = get_ie(priv->pmib->dot11RsnIE.rsnie, _RSN_IE_2_, &rsnie_len, priv->pmib->dot11RsnIE.rsnielen);
	if (!rsnie) {
		DEBUG_WARN("%s: fail to get rsnie\n", __FUNCTION__);
		return pbuf;
	}

#ifdef CONFIG_IEEE80211R_CLI
	if((pstat->ft_state == state_ft_auth_req) && (OPMODE & WIFI_STATION_STATE)) 
		rsnie_len = pGblInfo->AuthInfoElement.Length;
	else
#endif
		rsnie_len += 2;

#ifdef CONFIG_IEEE80211W
	if (priv->pmib->dot1180211AuthEntry.dot11IEEE80211W != NO_MGMT_FRAME_PROTECTION) {
		memcpy(pos, rsnie, rsnie_len - 6);
		pos += (rsnie_len - 6);
	} else
#endif	
	{
		memcpy(pos, rsnie, rsnie_len);
		pos += rsnie_len;
	}
	
	*((unsigned short *)pos) = cpu_to_le16(1);
	pos += 2;
	if (id == 0) {
#ifdef CONFIG_IEEE80211R_CLI
		if((pstat->ft_state == state_ft_auth_req) && (OPMODE & WIFI_STATION_STATE)) 
			memcpy(pos, r1kh->pmk_r0_name, PMKID_LEN);
		else
#endif
			memcpy(pos, pStaInfo->r1kh->pmk_r0_name, PMKID_LEN);

		pos += PMKID_LEN;
	} else if (id == 1) {
		memcpy(pos, pStaInfo->r1kh->pmk_r1_name, PMKID_LEN);
		pos += PMKID_LEN;
	} else if (id == 2) {
		memcpy(pos, pStaInfo->cache_pmk_r0_name, PMKID_LEN);
		pos += PMKID_LEN;
	}
	
#ifdef CONFIG_IEEE80211W
		if (priv->pmib->dot1180211AuthEntry.dot11IEEE80211W != NO_MGMT_FRAME_PROTECTION) {
			memcpy(pos, rsnie + ( rsnie_len - 4 ), 4);
			pos += 4;
			*(pbuf + 1) += PMKID_LEN;
		} else
#endif
#ifdef CONFIG_IEEE80211R_CLI
			if((pstat->ft_state == state_ft_auth_req) && (OPMODE & WIFI_STATION_STATE)) 
				*(pbuf + 1) = PMKID_LEN + rsnie_len;
			else
#endif
			*(pbuf + 1) += (2 + PMKID_LEN);

#ifdef CONFIG_IEEE80211R_CLI_DEBUG
	panic_printk("(%s)line=%d, pstat->ft_state = %d, rsnie_len = %d\n", __FUNCTION__, __LINE__, pstat->ft_state, rsnie_len);
#endif

	*frlen += (pos - pbuf);

	return pos;
}

unsigned char *construct_mobility_domain_ie(struct rtl8192cd_priv *priv, unsigned char *pbuf, unsigned int *frlen)
{
	unsigned char temp[3];

	memset(temp, 0, sizeof(temp));
	memcpy(temp, MDID, 2);
	if (priv->pmib->dot11FTEntry.dot11FTOverDSEnabled)
		temp[2] |= BIT(0);
	if (priv->pmib->dot11FTEntry.dot11FTResourceRequestSupported)
		temp[2] |= BIT(1);

	pbuf = set_ie(pbuf, _MOBILITY_DOMAIN_IE_, 3, temp, frlen);
	return pbuf;
}

unsigned char *construct_fast_bss_transition_ie(struct rtl8192cd_priv *priv, unsigned char *pbuf, unsigned int *frlen, struct stat_info *pstat) 
{
	struct r1_key_holder *r1kh = NULL;
	WPA_GLOBAL_INFO *pGblInfo = priv->wpa_global_info;
	WPA_STA_INFO	*pStaInfo = pstat->wpa_sta_info;
	unsigned char temp[512];
	unsigned char gkout[128], *pos;
	unsigned short gkout_len;
	unsigned char gkey_len;

	memset(temp, 0, sizeof(temp));
	pos = temp;

	DEBUG_INFO("pstat->ft_state = %d\n", pstat->ft_state);
	
	if (pstat->ft_state == state_ft_assoc) {
		SetFTMICCtrl(pos, 3);	
	}
	pos += 18;

	// ANonce, SNonce
	if (pstat->ft_state == state_imd_assoc || pstat->ft_state == state_imd_4way) {
		pos += (2 * KEY_NONCE_LEN);
	}
	else {
	#ifdef CONFIG_IEEE80211R_CLI
		if((priv->CliFTAuthState == state_ft_auth_req) && (OPMODE & WIFI_STATION_STATE)) {
			memcpy(pos, priv->ftie_ANonce.Octet, KEY_NONCE_LEN);
			pos += KEY_NONCE_LEN;
			memcpy(pos, priv->ftie_SNonce.Octet, KEY_NONCE_LEN);
			pos += KEY_NONCE_LEN;	
		} else 
	#endif
		{
			memcpy(pos, pStaInfo->ANonce.Octet, KEY_NONCE_LEN);
			pos += KEY_NONCE_LEN;
			memcpy(pos, pStaInfo->SNonce.Octet, KEY_NONCE_LEN);
			pos += KEY_NONCE_LEN;
		}
	}

#ifdef CONFIG_IEEE80211R_CLI
	if((priv->CliFTAuthState == state_ft_auth) && (OPMODE & WIFI_STATION_STATE)) {  
		panic_printk("FT Auth Req doesn't have R1KH-id! \n");
	}else 
#endif
	{	
		// R1KH-ID
		*pos++ = _FT_R1KH_ID_SUB_IE_;
		*pos++ = MACADDRLEN;
		memcpy(pos, BSSID, MACADDRLEN);
		pos += MACADDRLEN;
	}

	// R0KH-ID
	if (pstat->ft_state >= state_ft_auth) {
	#ifdef CONFIG_IEEE80211R_CLI
		if((priv->CliFTAuthState = state_ft_auth_req) && (OPMODE & WIFI_STATION_STATE)) {
			r1kh = search_r1kh(priv, priv->init_ap, priv->init_ap);
			if (!r1kh) 	return;
			
			*pos++ = _FT_R0KH_ID_SUB_IE_;
			*pos++ = r1kh->r0kh_id_len;
			memcpy(pos, r1kh->r0kh_id, r1kh->r0kh_id_len);
			pos += r1kh->r0kh_id_len;
		}
	#endif	
		
		if (pStaInfo->r1kh) {
			*pos++ = _FT_R0KH_ID_SUB_IE_;
			*pos++ = pStaInfo->r1kh->r0kh_id_len;
			memcpy(pos, pStaInfo->r1kh->r0kh_id, pStaInfo->r1kh->r0kh_id_len);
			pos += pStaInfo->r1kh->r0kh_id_len;
		}
	}
	else {
		*pos++ = _FT_R0KH_ID_SUB_IE_;
		*pos++ = R0KH_ID_LEN;
		memcpy(pos, R0KH_ID, R0KH_ID_LEN);
		pos += R0KH_ID_LEN;
	}


	// GTK
	if (pstat->ft_state == state_ft_assoc) {
		gkey_len = (pGblInfo->MulticastCipher == DOT11_ENC_TKIP) ? 32 : 16;
		
		*pos++ = _FT_GTK_SUB_IE_;
		*pos++ = 11 + gkey_len + 8;
		*pos++ = pGblInfo->GN;
		pos++;
		*pos++ = gkey_len;
		*pos++ = priv->pmib->dot11GroupKeysTable.dot11EncryptKey.dot11TXPN48._byte_.TSC0;
		*pos++ = priv->pmib->dot11GroupKeysTable.dot11EncryptKey.dot11TXPN48._byte_.TSC1;
		*pos++ = priv->pmib->dot11GroupKeysTable.dot11EncryptKey.dot11TXPN48._byte_.TSC2;
		*pos++ = priv->pmib->dot11GroupKeysTable.dot11EncryptKey.dot11TXPN48._byte_.TSC3;
		*pos++ = priv->pmib->dot11GroupKeysTable.dot11EncryptKey.dot11TXPN48._byte_.TSC4;
		*pos++ = priv->pmib->dot11GroupKeysTable.dot11EncryptKey.dot11TXPN48._byte_.TSC5;
		*pos++ = 0;
		*pos++ = 0;

		ft_enc_gtk(priv, pstat, gkout, &gkout_len);

		memcpy(pos, gkout, gkout_len);
		pos += gkout_len;
	}

	//debug_out("FT_IE",temp, pos - temp);
	pbuf = set_ie(pbuf, _FAST_BSS_TRANSITION_IE_, pos - temp, temp, frlen);
	return pbuf;
}

unsigned char *construct_timeout_interval_ie(struct rtl8192cd_priv *priv, unsigned char *pbuf, unsigned int *frlen, int type, int value)
{
	unsigned char temp[5];

	if (type < TIE_TYPE_REASSOC_DEADLINE || type > TIE_TYPE_KEY_LIFETIME)
		return pbuf;

	temp[0] = type;
	*(unsigned int *)((unsigned long)temp + 1) = cpu_to_le32(value);

	pbuf = set_ie(pbuf, _TIMEOUT_INTERVAL_IE_, 5, temp, frlen);
	return pbuf;
}

void issue_ft_action(struct rtl8192cd_priv *priv, struct stat_info *pstat, unsigned char *data, unsigned int len)
{
	unsigned char	*pbuf;
	DECLARE_TXINSN(txinsn);

	txinsn.q_num = MANAGE_QUE_NUM;
	txinsn.fr_type = _PRE_ALLOCMEM_;

    txinsn.tx_rate = find_rate(priv, NULL, 0, 1);
#ifndef TX_LOWESTRATE
	txinsn.lowest_tx_rate = txinsn.tx_rate;
#endif	
	txinsn.fixed_rate = 1;	

#ifdef CONFIG_IEEE80211W		
	if(pstat)
		txinsn.isPMF = pstat->isPMF;
	else
		txinsn.isPMF = 0;	
#endif	

	pbuf = txinsn.pframe = get_mgtbuf_from_poll(priv);
	if (pbuf == NULL)
		goto issue_ft_action_fail;

	txinsn.phdr = get_wlanhdr_from_poll(priv);
	if (txinsn.phdr == NULL)
		goto issue_ft_action_fail;

	memset((void *)(txinsn.phdr), 0, sizeof(struct wlan_hdr));
	memcpy(pbuf, data, len);

	txinsn.fr_len = len;
	SetFrameSubType((txinsn.phdr), WIFI_WMM_ACTION);
	
#ifdef CONFIG_IEEE80211W
	if (txinsn.isPMF)
		*(unsigned char*)(txinsn.phdr+1) |= BIT(6); // enable privacy 
#endif
	memcpy((void *)GetAddr1Ptr((txinsn.phdr)), pstat->cmn_info.mac_addr, MACADDRLEN);
	memcpy((void *)GetAddr2Ptr((txinsn.phdr)), GET_MY_HWADDR, MACADDRLEN);
	memcpy((void *)GetAddr3Ptr((txinsn.phdr)), BSSID, MACADDRLEN);

	DEBUG_INFO("Send ft action\n");

	if ((rtl8192cd_firetx(priv, &txinsn)) == SUCCESS) {
		return;
	}

issue_ft_action_fail:

	if (txinsn.phdr)
		release_wlanhdr_to_poll(priv, txinsn.phdr);
	if (txinsn.pframe)
		release_mgtbuf_to_poll(priv, txinsn.pframe);
	return;
}
#endif


#if 1
//#ifdef PCIE_POWER_SAVING
void fill_bcn_desc(struct rtl8192cd_priv *priv, struct tx_desc *pdesc, void *dat_content, unsigned short txLength, char forceUpdate)
{
#if defined(CONFIG_RTL_8812_SUPPORT)	|| defined(CONFIG_RTL_8723B_SUPPORT)
if (GET_CHIP_VER(priv)==VERSION_8812E || GET_CHIP_VER(priv)==VERSION_8723B)
{
	memset(pdesc, 0, 40);	
	pdesc->Dword0 |= set_desc(TX_FirstSeg | TX_LastSeg);
	pdesc->Dword0 |= set_desc(TX_BMC| (40<<TX_OffsetSHIFT));
	pdesc->Dword10 = set_desc(get_physical_addr(priv, dat_content, txLength, PCI_DMA_TODEVICE));
	pdesc->Dword0 |= set_desc((unsigned short)(txLength) << TX_PktSizeSHIFT);
	pdesc->Dword1 |= set_desc(0x10 << TX_QSelSHIFT);
	pdesc->Dword9 |= set_desc((GetSequence(dat_content) & TXdesc_92E_TX_SeqMask)  << TXdesc_92E_TX_SeqSHIFT);
	pdesc->Dword3 = set_desc(TXdesc_92E_DisDataFB|TXdesc_92E_UseRate);

	if (priv->pshare->is_40m_bw == CHANNEL_WIDTH_80) {
		#ifdef RTK_AC_SUPPORT
		if(GET_CHIP_VER(priv) != VERSION_8723B)
			pdesc->Dword5 |= set_desc((priv->pshare->txsc_20 << TXdesc_92E_DataScSHIFT));
		#endif
	} else if (priv->pshare->is_40m_bw == CHANNEL_WIDTH_40)   	{
		if (priv->pshare->offset_2nd_chan == HT_2NDCH_OFFSET_BELOW)
			pdesc->Dword5 |= set_desc(2 << TXdesc_92E_DataScSHIFT);
		else
			pdesc->Dword5 |= set_desc(1 << TXdesc_92E_DataScSHIFT);
	}
	
    priv->pshare->is_40m_bw_bak = priv->pshare->is_40m_bw;
    
    priv->tx_beacon_len = txLength;

	pdesc->Dword7 |= set_desc((unsigned short)(txLength) & TX_TxBufSizeMask);
	pdesc->Dword9 |= set_desc((GetSequence(dat_content) & TXdesc_92E_TX_SeqMask)  << TXdesc_92E_TX_SeqSHIFT);
	//pdesc->Dword9 |= set_desc((priv->timoffset & TXdesc_92E_TX_GroupIEMask) | TXdesc_92E_TX_GroupIEEnable);

	pdesc->Dword4 |= set_desc(0x1f << DATA_RATE_FB_LIMIT);
	pdesc->Dword4 |= set_desc(0xf << RTS_RATE_FB_LIMIT);

	if ((priv->pmib->dot11RFEntry.phyBandSelect & PHY_BAND_5G)||(priv->pshare->CurrentChannelBW == CHANNEL_WIDTH_80)||
		((GET_CHIP_VER(priv)==VERSION_8814A) && (priv->pmib->dot11RFEntry.phyBandSelect ==  PHY_BAND_2G))) //AC2G_256QAM
	{
		pdesc->Dword4 |= set_desc((4 & TXdesc_92E_RtsRateMask) << TXdesc_92E_RtsRateSHIFT);
		if ((priv->pmib->dot11StationConfigEntry.beacon_rate != 0xff) &&
			(priv->pmib->dot11StationConfigEntry.beacon_rate > 3))
			pdesc->Dword4 |= set_desc((priv->pmib->dot11StationConfigEntry.beacon_rate & TXdesc_92E_DataRateMask) << TXdesc_92E_DataRateSHIFT);
		else
			pdesc->Dword4 |= set_desc((4 & TXdesc_92E_DataRateMask) << TXdesc_92E_DataRateSHIFT);
	}

/*
		 * Intel IOT, dynamic enhance beacon tx AGC
*/
	pdesc->Dword5 &= set_desc(~((TXdesc_8812_TxPwrOffetMask) << TXdesc_8812_TxPwrOffetSHIFT));
	
	if(priv->pmib->dot11RFEntry.bcnagc==1) {
		if(priv->pshare->rf_ft_var.bcn_pwr_idex+6 <= priv->pshare->rf_ft_var.bcn_pwr_max)
			pdesc->Dword5 |= set_desc((4 & TXdesc_8812_TxPwrOffetMask) << TXdesc_8812_TxPwrOffetSHIFT);
	} else if ( priv->pmib->dot11RFEntry.bcnagc==2) {
		if(priv->pshare->rf_ft_var.bcn_pwr_idex+12 <= priv->pshare->rf_ft_var.bcn_pwr_max)
			pdesc->Dword5 |= set_desc((5 & TXdesc_8812_TxPwrOffetMask) << TXdesc_8812_TxPwrOffetSHIFT);
		else if(priv->pshare->rf_ft_var.bcn_pwr_idex+6 <= priv->pshare->rf_ft_var.bcn_pwr_max)
			pdesc->Dword5 |= set_desc((4 & TXdesc_8812_TxPwrOffetMask) << TXdesc_8812_TxPwrOffetSHIFT);
	} else {
		if (priv->bcnTxAGC ==1)
			pdesc->Dword5 |= set_desc((4 & TXdesc_8812_TxPwrOffetMask) << TXdesc_8812_TxPwrOffetSHIFT);
		else if (priv->bcnTxAGC ==2)
			pdesc->Dword5 |= set_desc((5 & TXdesc_8812_TxPwrOffetMask) << TXdesc_8812_TxPwrOffetSHIFT);

		if (priv->pmib->dot11RFEntry.txpwr_reduction) {
			if (priv->pmib->dot11RFEntry.txpwr_reduction <= 3)
				pdesc->Dword5 |= set_desc((priv->pmib->dot11RFEntry.txpwr_reduction & TXdesc_8812_TxPwrOffetMask) << TXdesc_8812_TxPwrOffetSHIFT);
		}
	}

	return; //_eric_8812 ??
}	
#endif  //defined(CONFIG_RTL_8812_SUPPORT)
/*
     * Intel IOT, dynamic enhance beacon tx AGC
    */
	if (priv->bcnTxAGC_bak != priv->bcnTxAGC || forceUpdate)
    {
		memset((void *)&pdesc->Dword6, 0, 4);

#ifdef HIGH_POWER_EXT_PA
	    if (!priv->pshare->rf_ft_var.use_ext_pa)
#endif
        if (priv->bcnTxAGC) 
		{
			pdesc->Dword6 |= set_desc((((priv->bcnTxAGC*6) & 0xfffffffe) & TX_TxAgcAMask) << TX_TxAgcASHIFT);
			pdesc->Dword6 |= set_desc((((priv->bcnTxAGC*6) & 0xfffffffe) & TX_TxAgcBMask) << TX_TxAgcBSHIFT);
		}
        priv->bcnTxAGC_bak = priv->bcnTxAGC;
    }

	if (priv->pshare->is_40m_bw != priv->pshare->is_40m_bw_bak || forceUpdate) {
		memset((void *)&pdesc->Dword4, 0, 4);

		pdesc->Dword4 = set_desc(TX_DisDataFB | TX_UseRate);

		if (priv->pshare->is_40m_bw) {
			if (priv->pshare->offset_2nd_chan == HT_2NDCH_OFFSET_BELOW)
				pdesc->Dword4 |= set_desc(2 << TX_DataScSHIFT);
			else
				pdesc->Dword4 |= set_desc(1 << TX_DataScSHIFT);
		}
		priv->pshare->is_40m_bw_bak = priv->pshare->is_40m_bw;

#ifdef CONFIG_RTL_92D_SUPPORT
		if (priv->pmib->dot11RFEntry.phyBandSelect & PHY_BAND_5G)
			pdesc->Dword4 |= set_desc((4 & TX_RtsRateMask) << TX_RtsRateSHIFT);
#endif
	}

	if (txLength != priv->tx_beacon_len || forceUpdate)
	{
		memset(pdesc, 0, 24);
		
#if defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI)
		if (GET_HCI_TYPE(priv) == RTL_HCI_USB || GET_HCI_TYPE(priv) == RTL_HCI_SDIO) {
			pdesc->Dword0 |= set_desc(TX_OWN|TX_BMC|TX_FirstSeg | TX_LastSeg | ((32)<<TX_OffsetSHIFT));
		}
#endif
#if defined(CONFIG_PCI_HCI)
		if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE) {
			memset((void *)&pdesc->Dword7, 0, 8);			
			pdesc->Dword0 |= set_desc(TX_BMC|TX_FirstSeg | TX_LastSeg | ((32)<<TX_OffsetSHIFT));
		}
#endif
		pdesc->Dword0 |= set_desc((unsigned short)(txLength) << TX_PktSizeSHIFT);
		pdesc->Dword1 |= set_desc(0x10 << TX_QSelSHIFT);

		if (priv->pmib->dot11RFEntry.bcn2path){
			RTL_W32(0x80c,RTL_R32(0x80c)|BIT(31));
			pdesc->Dword2 &= set_desc(0x03ffffff); // clear related bits
			pdesc->Dword2 |= set_desc(3 << TX_TxAntCckSHIFT);	// Set Default CCK rate with 2T
		}
		pdesc->Dword3 |= set_desc((GetSequence(dat_content) & TX_SeqMask) << TX_SeqSHIFT);
		pdesc->Dword4 = set_desc(TX_DisDataFB | TX_UseRate);

		if (priv->pshare->is_40m_bw)
        {
			if (priv->pshare->offset_2nd_chan == HT_2NDCH_OFFSET_BELOW)
				pdesc->Dword4 |= set_desc(2 << TX_DataScSHIFT);
			else
				pdesc->Dword4 |= set_desc(1 << TX_DataScSHIFT);
		}
        priv->pshare->is_40m_bw_bak = priv->pshare->is_40m_bw;

		if (priv->pmib->dot11RFEntry.txbf == 1) {
			pdesc->Dword2 &= set_desc(0x03ffffff); // clear related bits

			pdesc->Dword2 |= set_desc(1 << TX_TxAntCckSHIFT);	// Set Default CCK rate with 1T
			pdesc->Dword2 |= set_desc(1 << TX_TxAntlSHIFT); 	// Set Default Legacy rate with 1T
			pdesc->Dword2 |= set_desc(1 << TX_TxAntHtSHIFT);	// Set Default Ht rate	
		}

#ifdef CONFIG_RTL_92D_SUPPORT
		if (GET_CHIP_VER(priv)==VERSION_8192D) {
			if (priv->pmib->dot11RFEntry.phyBandSelect & PHY_BAND_5G) {
				pdesc->Dword4 |= set_desc((4 & TX_RtsRateMask) << TX_RtsRateSHIFT);
				if ((priv->pmib->dot11StationConfigEntry.beacon_rate != 0xff) &&
					(priv->pmib->dot11StationConfigEntry.beacon_rate > 3))
					pdesc->Dword5 |= set_desc((priv->pmib->dot11StationConfigEntry.beacon_rate & TX_DataRateMask) << TX_DataRateSHIFT);
				else
					pdesc->Dword5 |= set_desc((4 & TX_DataRateMask) << TX_DataRateSHIFT);
			}
		}
		else
#endif
		if (priv->pmib->dot11StationConfigEntry.beacon_rate != 0xff)
			pdesc->Dword5 |= set_desc((priv->pmib->dot11StationConfigEntry.beacon_rate & TX_DataRateMask) << TX_DataRateSHIFT);

		priv->tx_beacon_len = txLength;

#ifdef CONFIG_PCI_HCI
		if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE) {
			pdesc->Dword7 |= set_desc((unsigned short)(txLength) & TX_TxBufSizeMask);
			pdesc->Dword8 = set_desc(get_physical_addr(priv, dat_content, txLength, PCI_DMA_TODEVICE));
		}
#endif // CONFIG_PCI_HCI
	}
	else
	{
		memset((void *)&pdesc->Dword3, 0, 4);
		pdesc->Dword3 |= set_desc((GetSequence(dat_content) & TX_SeqMask) << TX_SeqSHIFT);
	}
    
}
#endif

#ifdef CONFIG_PCI_HCI
void signin_beacon_desc(struct rtl8192cd_priv *priv, unsigned int *beaconbuf, unsigned int frlen)
{
	struct rtl8192cd_hw	*phw=GET_HW(priv);
	struct tx_desc		*pdesc;
//	unsigned int			next_idx = 1;

#ifdef MBSSID
	if (IS_VAP_INTERFACE(priv)) {
		pdesc = phw->tx_descB + priv->vap_init_seq;
//		next_idx =  priv->vap_init_seq + 1;
	}
	else
#endif
		pdesc = phw->tx_descB;

	//memset(pdesc, 0, 32);	// clear all bit

#ifdef DFS
	if (!priv->pmib->dot11DFSEntry.disable_DFS &&
		(rtk_timer_pending(&GET_ROOT(priv)->ch_avail_chk_timer)) &&
		(GET_CHIP_VER(priv) == VERSION_8192D)) {
			pdesc->Dword0 &= set_desc(~(TX_OWN));
			RTL_W16(PCIE_CTRL_REG, RTL_R16(PCIE_CTRL_REG)| (BCNQSTOP));
		return;
	}
#endif


	fill_bcn_desc(priv, pdesc, (void*)beaconbuf, frlen, 0);
	
#if defined(CONFIG_RTL_8812_SUPPORT) || defined(CONFIG_RTL_8723B_SUPPORT)	
	if(GET_CHIP_VER(priv)== VERSION_8812E || GET_CHIP_VER(priv)== VERSION_8723B)
	rtl_cache_sync_wback(priv, (unsigned long)bus_to_virt(get_desc(pdesc->Dword10)), frlen, PCI_DMA_TODEVICE);
	else
#endif
	rtl_cache_sync_wback(priv, (unsigned long)bus_to_virt(get_desc(pdesc->Dword8)), frlen, PCI_DMA_TODEVICE);


#ifdef MBSSID
if((GET_CHIP_VER(priv)== VERSION_8188C) || (GET_CHIP_VER(priv)== VERSION_8192C) || (GET_CHIP_VER(priv)== VERSION_8192D))
{
	unsigned int tmp_522 = RTL_R8(0x522); //TXPAUSE register
	if (priv->pmib->miscEntry.func_off && IS_ROOT_INTERFACE(priv))
		RTL_W8(0x522, tmp_522 | BIT(6));
	else if(tmp_522 & BIT(6))
		RTL_W8(0x522, tmp_522 & ~BIT(6));
}
#endif

	pdesc->Dword0 |= set_desc(TX_OWN);
}
#endif // CONFIG_PCI_HCI



/**
 *	@brief	Update beacon content
 *
 *	IBSS parameter set (STA), TIM (AP), ERP & Ext rate not set  \n \n
 *	+----------------------------+-----+--------------------+-----+---------------------+-----+------------+-----+	\n
 *	| DS parameter (init_beacon) | TIM | IBSS parameter set | ERP | EXT supported rates | RSN | Realtek IE | CRC |	\n
 *	+----------------------------+-----+--------------------+-----+---------------------+-----+------------+-----+	\n
 *	\n
 *	set_desc() set data to hardware, 8190n_hw.h define value
 */


#if 1/*def RTK_AC_SUPPORT //for 11ac logo*/
int get_center_channel(struct rtl8192cd_priv *priv, int channel, int offset, int cur) 
{
	int val = channel, bw=0;

	if (cur)
		bw = priv->pshare->CurrentChannelBW;
	else
		bw = priv->pmib->dot11nConfigEntry.dot11nUse40M;

#ifdef RTK_AC_SUPPORT
	if (bw == CHANNEL_WIDTH_80
		|| bw == CHANNEL_WIDTH_80_80)
	{
#if defined(AC2G_256QAM) || defined(CONFIG_WLAN_HAL_8814AE)
		if(is_ac2g(priv))
			val = 7;
		else
#endif
		if(channel <= 48)
			val = 42;
		else if(channel <= 64)
			val = 58;
		else if(channel <= 112)
			val = 106;
		else if(channel <= 128)
			val = 122;
		else if(channel <= 144)
			val = 138;
		else if(channel <= 161)
			val = 155;
		else if(channel <= 177)
			val = 171;	
	} else 
#endif		
	if (bw == CHANNEL_WIDTH_40) {
		if (offset == 1)
			val -= 2;
		else
			val += 2;
	}

	//SDEBUG("channel[%d] offset[%d] bw[%d] cent[%d]\n", channel, offset, bw, val);
	return val;
}


#endif


#if defined(UNIVERSAL_REPEATER) || defined(MBSSID)
int is_main_AP_interface(struct rtl8192cd_priv *priv)
{
	int i;

	if (IS_ROOT_INTERFACE(priv)) {
		if (priv->pmib->miscEntry.func_off == 0)
			return TRUE;
		else
			return FALSE;
	}
	else {	// vap interfaces
		if (GET_ROOT(priv)->pmib->miscEntry.func_off == 0)
			return FALSE;
#if defined(MBSSID)
		else {
			for (i=0; i<RTL8192CD_NUM_VWLAN; i++) {
				if (IS_DRV_OPEN(GET_ROOT(priv)->pvap_priv[i])) {
					if ((GET_ROOT(priv)->pvap_priv[i])->pmib->miscEntry.func_off == 0) {
						if (priv == (GET_ROOT(priv)->pvap_priv[i]))
							return TRUE;
						break;
					}
				}
			}
			return FALSE;
		}
#endif
	}
}
#endif


void update_beacon(struct rtl8192cd_priv *priv)
{
#if !defined(SMP_SYNC) && defined(CONFIG_RTL_WAPI_SUPPORT)
    unsigned long		flags;
#endif

    struct wifi_mib *pmib;
    struct rtl8192cd_hw	*phw;
    unsigned int	frlen;
    unsigned char	*pbuf;
#ifndef RTK_NL80211
    unsigned char	*pbssrate=NULL;
    unsigned int	bssrate_len = 0;
#endif
#ifdef CONFIG_MBO
	unsigned int	assoc_disallow = 0;
#endif
#if defined(TV_MODE) || defined(A4_STA) || defined(USER_ADDIE)   
    unsigned int	i;
#endif
	unsigned char extended_cap_ie[8];
#ifdef BEACON_VS_IE
	int y;
#endif

#ifdef	CONFIG_RTK_MESH
    UINT8		meshiearray[96];	// mesh IE buffer (Max byte is hw_serial_no)
#endif

#ifdef AUTO_CHANNEL_TIMEOUT
	if (priv->pshare->autoch_trigger_by_timeout)
		return;
#endif

#if defined(USE_OUT_SRC) || defined(CONFIG_POWER_SAVE) 
	if ( TRUE == priv->pshare->bScanInProcess )
		return;
#endif

#ifdef CONFIG_RTL_OFFLOAD_DRIVER
	if (OFFLOAD_ENABLE(priv) && priv->beacon_updated)
		return;
#endif

	memset(extended_cap_ie,0,8);

	pmib = GET_MIB(priv);
	phw = GET_HW(priv);

#if defined(UNIVERSAL_REPEATER) || defined(STA_CONTROL) 
	if(priv->hiddenAP_backup != priv->pmib->dot11OperationEntry.hiddenAP) {
		if(priv->pmib->dot11OperationEntry.hiddenAP
#ifdef STA_CONTROL
			|| priv->stactrl.stactrl_hiddenAP_aging > 0
#endif
		)
			HideAP(priv);
		else
			DehideAP(priv);

		priv->hiddenAP_backup = priv->pmib->dot11OperationEntry.hiddenAP;
	}
#endif

#ifdef CONFIG_MBO
#ifdef RTK_MULTI_AP
		assoc_disallow = GET_ROOT(priv)->pmib->multi_ap.multiap_assoc_disallowed_status;
#else
		assoc_disallow = check_association_disallowed(priv, WIFI_BEACON, 0);
#endif
#endif

    if (priv->update_bcn_period)
    {
        unsigned short val16 = 0;
        pbuf = (unsigned char *)priv->beaconbuf;
        frlen = 0;

        pbuf += 24;
        frlen += 24;

        frlen += _TIMESTAMP_;   // for timestamp
        pbuf += _TIMESTAMP_;

        //setup BeaconPeriod...
        val16 = cpu_to_le16(pmib->dot11StationConfigEntry.dot11BeaconPeriod);
        pbuf = set_fixed_ie(pbuf, _BEACON_ITERVAL_, (unsigned char *)&val16, &frlen);
        priv->update_bcn_period = 0;
    }
    frlen = priv->timoffset;
    pbuf = (unsigned char *)priv->beaconbuf + priv->timoffset;

    // setting tim field...
    if (OPMODE & WIFI_AP_STATE)
        pbuf = update_tim(priv, pbuf, &frlen);

    if (OPMODE & WIFI_ADHOC_STATE) {
        unsigned short val16 = 0;
        pbuf = set_ie(pbuf, _IBSS_PARA_IE_, 2, (unsigned char *)&val16, &frlen);
    }

#ifdef MCR_WIRELESS_EXTEND
	if (!priv->pshare->cmw_link)
#endif
	{
#if defined(DOT11D) || defined(DOT11H) || defined(DOT11K)
    if(priv->countryTableIdx)
    {
        pbuf = construct_country_ie(priv, pbuf, &frlen);   
    }
#endif

#if defined(DOT11H) || defined(DOT11K)
    if(priv->pmib->dot11hTPCEntry.tpc_enable || priv->pmib->dot11StationConfigEntry.dot11RadioMeasurementActivated)
    {
        pbuf = set_ie(pbuf, _PWR_CONSTRAINT_IE_, 1, &priv->pshare->rf_ft_var.lpwrc, &frlen);        
        pbuf = construct_TPC_report_ie(priv, pbuf, &frlen);
    }
#endif
	}
    if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11G) {
        // ERP infomation
        unsigned char val8 = 0;
        if (priv->pmib->dot11ErpInfo.protection)
            val8 |= BIT(1);
        if (priv->pmib->dot11ErpInfo.nonErpStaNum)
            val8 |= BIT(0);

        if (!SHORTPREAMBLE || priv->pmib->dot11ErpInfo.longPreambleStaNum)
            val8 |= BIT(2);

        pbuf = set_ie(pbuf, _ERPINFO_IE_, 1, &val8, &frlen);
    }

    // EXT supported rates
#ifdef RTK_NL80211
	if(priv->hapd_ext_supp_rates_len){
		memcpy(pbuf, priv->hapd_ext_supp_rates, priv->hapd_ext_supp_rates_len);
		pbuf += priv->hapd_ext_supp_rates_len;
		frlen += priv->hapd_ext_supp_rates_len;
	}
#else
    if (get_bssrate_set(priv, _EXT_SUPPORTEDRATES_IE_, &pbssrate, &bssrate_len))
    {
		u8 tmp[8];

		memcpy(tmp, pbssrate, bssrate_len);

#ifdef ENABLE_SAE_H2E
		// update_beacon
		if(support_wpa3(priv))
			construct_bss_mem_ie(priv, tmp, &bssrate_len);
#endif
        pbuf = set_ie(pbuf, _EXT_SUPPORTEDRATES_IE_, bssrate_len, tmp, &frlen);
    }
#endif

#ifdef ENABLE_SAE_H2E
    else if (support_wpa3(priv) && priv->pmib->dot1180211AuthEntry.dot11SAEPwe == 1)
    {
		u8 tmp[8];
		u32 extlen=0;
		construct_bss_mem_ie(priv, tmp, &extlen);
        pbuf = set_ie(pbuf, _EXT_SUPPORTEDRATES_IE_, extlen, tmp, &frlen);
    }
#endif

    #if defined(HS2_SUPPORT) || defined(DOT11K)
    pbuf = construct_BSS_load_ie(priv, pbuf, &frlen);
    #endif

    #ifdef DOT11K
    if(priv->pmib->dot11StationConfigEntry.dot11RadioMeasurementActivated)
    {
        /* AP Channel Report*/
        if((OPMODE & WIFI_AP_STATE) && priv->pmib->dot11StationConfigEntry.dot11RMAPChannelReportActivated)  {
            pbuf = construct_ap_channel_rep_ie(priv, pbuf, &frlen);
        }

        /* RM Enabled Capabilities*/
        pbuf = construct_rm_enable_cap_ie(priv, pbuf, &frlen);
    }
    #endif

#ifdef HAPD_11K
	if (priv->hapd_11k_ie_len) {
		/*priv->hapd_11k_ie_len  include IE(ID)+LEN+VAL */
		memcpy(pbuf, priv->hapd_11k_ie, priv->hapd_11k_ie_len);
		pbuf += priv->hapd_11k_ie_len;
		frlen += priv->hapd_11k_ie_len;
	}
#endif

#ifdef CONFIG_IEEE80211R
		if (FT_ENABLE)
			pbuf = construct_mobility_domain_ie(priv, pbuf, &frlen);
#endif

    /*
        2008-12-16, For Buffalo WLI_CB_AG54L 54Mbps NIC interoperability issue.
        This NIC can not connect to our AP when our AP is set to WPA/TKIP encryption.
        This issue can be fixed after move "HT Capability Info" and "Additional HT Info" in front of "WPA" and "WMM".
    */
    if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11N) {
        construct_ht_ie(priv, priv->pshare->is_40m_bw, priv->pshare->offset_2nd_chan);
        pbuf = set_ie(pbuf, _HT_CAP_, priv->ht_cap_len, (unsigned char *)&priv->ht_cap_buf, &frlen);
        pbuf = set_ie(pbuf, _HT_IE_, priv->ht_ie_len, (unsigned char *)&priv->ht_ie_buf, &frlen);
    }
// beacon
#ifdef RTK_AC_SUPPORT //for 11ac logo
	if((priv->pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm != _WEP_40_PRIVACY_)
		&& (priv->pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm != _WEP_104_PRIVACY_))
    if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11AC) {
#ifdef MCR_WIRELESS_EXTEND
		construct_vht_ie_mcr(priv, priv->pshare->working_channel, pstat);
#else
		construct_vht_ie(priv, priv->pshare->working_channel);
#endif		
        pbuf = set_ie(pbuf, EID_VHTCapability, priv->vht_cap_len, (unsigned char *)&priv->vht_cap_buf, &frlen);
        pbuf = set_ie(pbuf, EID_VHTOperation, priv->vht_oper_len, (unsigned char *)&priv->vht_oper_buf, &frlen);
        // 62 
        if(priv->pshare->rf_ft_var.lpwrc) {
            char tmp[4];
            pbuf = set_ie(pbuf, _PWR_CONSTRAINT_IE_, 1, &priv->pshare->rf_ft_var.lpwrc, &frlen);
            tmp[1] = tmp[2] = tmp[3] = priv->pshare->rf_ft_var.lpwrc;
            tmp[0] = priv->pshare->CurrentChannelBW;	//	20, 40, 80
            pbuf = set_ie(pbuf, EID_VHTTxPwrEnvelope, tmp[0]+2, tmp, &frlen);	
        }
    }
#endif


#ifdef CONFIG_RTK_MESH		// Mesh IE
    if (GET_MIB(priv)->dot1180211sInfo.mesh_enable) {
        // OFDM Parameter Set
        pbuf = set_ie(pbuf, _OFDM_PARAMETER_SET_IE_, mesh_ie_OFDM(priv, meshiearray), meshiearray, &frlen);
        // Mesh ID
        pbuf = set_ie(pbuf, _MESH_ID_IE_, mesh_ie_MeshID(priv, meshiearray, FALSE), meshiearray, &frlen);

        // WLAN Mesh Capability
        pbuf = set_ie(pbuf, _WLAN_MESH_CAP_IE_, mesh_ie_WLANMeshCAP(priv, meshiearray), meshiearray, &frlen);

        if(priv->mesh_swchnl_channel
#ifdef RTK_MESH_SIMPLE_CSA /* Root */
			|| priv->mesh_CSA_state == MESH_CSA_READY || priv->mesh_CSA_state == MESH_CSA_ONGOING
			|| priv->mesh_CSA_state == MESH_CSA_CROSSBAND_READY || priv->mesh_CSA_state == MESH_CSA_CROSSBAND_ONGOING
#endif
		) { /* mesh channel switch procedure is on-going */
            pbuf = set_ie(pbuf, _MESH_CHANNEL_SWITCH_IE_, mesh_ie_MeshChannelSwitch(priv, meshiearray), meshiearray, &frlen);
            pbuf = set_ie(pbuf, _CSA_IE_, mesh_ie_ChannelSwitchAnnoun(priv, meshiearray), meshiearray, &frlen);
            pbuf = set_ie(pbuf, _SECONDARY_CHANNEL_OFFSET_IE_, mesh_ie_SecondaryChannelOffset(priv, meshiearray), meshiearray, &frlen);
        }
    }
#ifdef RTK_MESH_SIMPLE_CSA
	else { /* Vap or non-mesh interface */
		if (GET_ROOT(priv)->mesh_CSA_state == MESH_CSA_READY || GET_ROOT(priv)->mesh_CSA_state == MESH_CSA_ONGOING) {
			pbuf = set_ie(pbuf, _CSA_IE_, mesh_ie_ChannelSwitchAnnoun(GET_ROOT(priv), meshiearray), meshiearray, &frlen);
            pbuf = set_ie(pbuf, _SECONDARY_CHANNEL_OFFSET_IE_, mesh_ie_SecondaryChannelOffset(GET_ROOT(priv), meshiearray), meshiearray, &frlen);
		}			
	}
#endif 

    /* if pure Mesh Point without mesh enable, don't send beacon*/
    if ( (OPMODE & WIFI_AP_STATE) && pmib->dot1180211sInfo.meshSilence )
        return;
#endif	// CONFIG_RTK_MESH

// 63
#if defined(DFS) || defined(RTK_AC_SUPPORT) /*for 11ac logo*/
if (priv->pmib->dot11RFEntry.phyBandSelect == PHY_BAND_5G) {
    if (GET_ROOT(priv)->pmib->dot11DFSEntry.DFS_detected && priv->pshare->dfsSwitchChannel) {
        static unsigned int set_stop_bcn = 0;

        if (priv->pshare->dfsSwitchChCountDown) {
            unsigned char tmpStr[3];
            tmpStr[0] = 1;	/* channel switch mode */
            tmpStr[1] = priv->pshare->dfsSwitchChannel;	/* new channel number */
            tmpStr[2] = priv->pshare->dfsSwitchChCountDown;	/* channel switch count */
            pbuf = set_ie(pbuf, _CSA_IE_, 3, tmpStr, &frlen);


            #ifdef CONFIG_RTK_MESH      // Mesh IE
            if (GET_MIB(priv)->dot1180211sInfo.mesh_enable) {
                pbuf = set_ie(pbuf, _MESH_CHANNEL_SWITCH_IE_, mesh_ie_MeshChannelSwitch(priv, meshiearray), meshiearray, &frlen);
            }
            #endif

#if defined(RTK_AC_SUPPORT) /*for 11ac logo*/
            if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11AC) {
                unsigned char tmp2[15];
                int len = 5;

                tmp2[0] = EID_WIDEBW_CH_SW;
                tmp2[1] = 3;
                tmp2[2] = (priv->pmib->dot11nConfigEntry.dot11nUse40M==2) ? 1 : 0;
                tmp2[3] = get_center_channel(priv, priv->pshare->dfsSwitchChannel, priv->pshare->offset_2nd_chan, 0);
                tmp2[4] = 0;
                pbuf = set_ie(pbuf, EID_CH_SW_WRAPPER, len, tmp2, &frlen);
            }
#endif

			
#if defined(UNIVERSAL_REPEATER) || defined(MBSSID)
            //if (IS_ROOT_INTERFACE(priv))
            if (is_main_AP_interface(priv))
#endif
            {
                priv->pshare->dfsSwitchChCountDown--;
                if (set_stop_bcn)
                    set_stop_bcn = 0;
            }
        }
        else {
#if defined(UNIVERSAL_REPEATER) || defined(MBSSID)
            //if (IS_ROOT_INTERFACE(priv))
            if (is_main_AP_interface(priv))
#endif
            {
#if	defined(CONFIG_RTL_8812_SUPPORT) || defined(CONFIG_WLAN_HAL_8881A) || defined(CONFIG_WLAN_HAL_8814AE) || defined(CONFIG_WLAN_HAL_8822BE) || defined(CONFIG_WLAN_HAL_8821CE) || defined(CONFIG_WLAN_HAL_8822CE) || defined(CONFIG_WLAN_HAL_8812FE)
                if ((GET_CHIP_VER(priv) == VERSION_8812E) || (GET_CHIP_VER(priv) == VERSION_8881A)|| (GET_CHIP_VER(priv) == VERSION_8814A) || (GET_CHIP_VER(priv) == VERSION_8822B) || (GET_CHIP_VER(priv) == VERSION_8821C) || GET_CHIP_VER(priv) == VERSION_8822C || GET_CHIP_VER(priv) == VERSION_8812F) {
                    if (GET_CHIP_VER(priv) == VERSION_8881A){
                        phy_set_bb_reg(priv, 0xcb0, 0x000000f0, 4);
                    }
                    SwitchChannel(GET_ROOT(priv));
                    if (GET_CHIP_VER(priv) == VERSION_8881A){
                        delay_us(500);
                        phy_set_bb_reg(priv, 0xcb0, 0x000000f0, 5);
                    }
                }
                else
#endif
                {
#ifdef DFS						
#ifdef __ECOS
                    priv->pshare->has_triggered_dfs_switch_channel = 1;
                    priv->pshare->call_dsr = 1;
#else
                    DFS_SwitchChannel(GET_ROOT(priv));
#endif
#endif
                }
            } 
#if defined(UNIVERSAL_REPEATER) || defined(MBSSID)
            else {
                if (!set_stop_bcn) {
#ifdef  CONFIG_WLAN_HAL
                    if (IS_HAL_CHIP(priv)) {
                        u8  RegTXPause;
                        GET_HAL_INTERFACE(priv)->GetHwRegHandler(priv, HW_VAR_TXPAUSE, (pu1Byte)&RegTXPause);
                        RegTXPause |= TXPAUSE_BCN_QUEUE_BIT;
                        GET_HAL_INTERFACE(priv)->SetHwRegHandler(priv, HW_VAR_TXPAUSE, (pu1Byte)&RegTXPause);
                    } else if(CONFIG_WLAN_NOT_HAL_EXIST)
#endif
                    {//not HAL
                        RTL_W8(TXPAUSE, RTL_R8(TXPAUSE) | STOP_BCN);
                    }
                    set_stop_bcn++;
                }
            }
#endif
            return;
        }
    }
}
#endif

#ifdef RTK_AC_SUPPORT //for 11ac logo
		if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11AC) {
		//66
		if(priv->pshare->rf_ft_var.opmtest&1) {
			pbuf = set_ie(pbuf, EID_VHTOperatingMode, 1, (unsigned char *)&(priv->pshare->rf_ft_var.oper_mode_field), &frlen);
		}	
	}
#endif	

#ifdef WIFI_11N_2040_COEXIST
	if ((OPMODE & WIFI_AP_STATE) && 
		((priv->pmib->dot11BssType.net_work_type & (WIRELESS_11N|WIRELESS_11G))==(WIRELESS_11N|WIRELESS_11G)) &&
		COEXIST_ENABLE) {

		extended_cap_ie[0] |= _2040_COEXIST_SUPPORT_;  // byte0
		if (priv->pshare->is_40m_bw) {
			construct_obss_scan_para_ie(priv);
			pbuf = set_ie(pbuf, _OBSS_SCAN_PARA_IE_, priv->obss_scan_para_len,
					(unsigned char *)&priv->obss_scan_para_buf, &frlen);
		}
	}
#endif

	if (pmib->dot11RsnIE.rsnielen) {
		memcpy(pbuf, pmib->dot11RsnIE.rsnie, pmib->dot11RsnIE.rsnielen);
		pbuf += pmib->dot11RsnIE.rsnielen;
		frlen += pmib->dot11RsnIE.rsnielen;
	}

#ifdef RTK_NL80211
	/*RSNXE*/
	if(priv->rsn_xe_len){
		memcpy(pbuf, priv->rsn_xe, priv->rsn_xe_len);
		pbuf += priv->rsn_xe_len;
		frlen += priv->rsn_xe_len;
	}
#endif

#ifdef WIFI_WMM
	//Set WMM Parameter Element
	if (QOS_ENABLE)
		pbuf = set_ie(pbuf, _RSN_IE_1_, _WMM_Para_Element_Length_, GET_WMM_PARA_IE, &frlen);
#endif

#ifdef ENABLE_SAE_H2E
	// update_beacon
	if ( support_wpa3(priv) && pmib->dot1180211AuthEntry.dot11SAEPwe != 0 ) {
		u8 tmp[2];
		size_t flen;

		flen = construct_rsnxe_ie(tmp);
		pbuf = set_ie(pbuf, _RSNX_IE_, flen, tmp, &frlen);
	}
#endif

#if defined(TV_MODE) || defined(A4_STA)
    i = 0;
#ifdef A4_STA
    if(priv->pmib->miscEntry.a4_enable == 2) {
        i |= BIT0;
    }
#endif

#ifdef TV_MODE
    i |= BIT1;
#endif
    if(i)
        pbuf = construct_ecm_tvm_ie(priv, pbuf, &frlen, i);
#endif //defined(TV_MODE) || defined(A4_STA)

	if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11N) {
		/*
			2008-12-16, For Buffalo WLI_CB_AG54L 54Mbps NIC interoperability issue.
			This NIC can not connect to our AP when our AP is set to WPA/TKIP encryption.
			This issue can be fixed after move "HT Capability Info" and "Additional HT Info" in front of "WPA" and "WMM".
		 */
		//construct_ht_ie(priv, priv->pshare->is_40m_bw, priv->pshare->offset_2nd_chan);
		//pbuf = set_ie(pbuf, _HT_CAP_, priv->ht_cap_len, (unsigned char *)&priv->ht_cap_buf, &frlen);
		//pbuf = set_ie(pbuf, _HT_IE_, priv->ht_ie_len, (unsigned char *)&priv->ht_ie_buf, &frlen);
		//pbuf = construct_ht_ie_old_form(priv, pbuf, &frlen);
	}

#ifdef CONFIG_MBO
	// MBO-OCE IE
	pbuf = construct_mbo_ie(pbuf, &frlen, assoc_disallow);
#endif

	// Realtek proprietary IE
	if (priv->pshare->rtk_ie_len)
		pbuf = set_ie(pbuf, _RSN_IE_1_, priv->pshare->rtk_ie_len, priv->pshare->rtk_ie_buf, &frlen);

	// Customer proprietary IE
	if (priv->pmib->miscEntry.private_ie_len) {
		memcpy(pbuf, pmib->miscEntry.private_ie, pmib->miscEntry.private_ie_len);
		pbuf += pmib->miscEntry.private_ie_len;
		frlen += pmib->miscEntry.private_ie_len;
	}

#ifdef CONFIG_RTK_WPS_MESH
	if (GET_MIB(priv)->dot1180211sInfo.mesh_enable) {
	    int	len = strlen(priv->hw_serial_no_cipher);
		if(len) {
			memcpy(meshiearray, MESH_VENDOR_OUI, 3);
			memcpy(&meshiearray[3], MESH_SERIAL_VAL, 2);
			memcpy(&meshiearray[5], priv->hw_serial_mac, MACADDRLEN);
			memcpy(&meshiearray[5+MACADDRLEN], priv->hw_serial_no_cipher, len);
			pbuf = set_ie(pbuf, _VENDOR_SPEC_IE_, 5+MACADDRLEN+len, meshiearray, &frlen);
		}
	}
#endif

#if defined(RTK_MULTI_AP) && defined(RTK_MULTI_AP_R1_DFS)
	unsigned char rtk_multiap_ie_data[7] = {0x00, 0xe0, 0x4c, 0x05, 0x06, 0x01, 0x40}; // [0][1][2] - rtkoui   [4] - type   [5] - subelement_id   [6] - subelement_length  [7] - value
	// unsigned char rtk_multiap_ie_data[7] = {0x00, 0xe0, 0x4c, 0x05, 0x06, 0x01, RTL_R8(TXPAUSE)}; // [0][1][2] - rtkoui   [4] - type   [5] - subelement_id   [6] - subelement_length  [7] - value
	pbuf = set_ie(pbuf, _RSN_IE_1_, 7, rtk_multiap_ie_data, &frlen);
#endif

	if(priv->pmib->miscEntry.stage) {
		unsigned char tmp[10] = { 0x00, 0x0d, 0x02, 0x07, 0x01, 0x00, 0x00 };
		if(priv->pmib->miscEntry.stage<=5)
			tmp[6] = 1<<(8-priv->pmib->miscEntry.stage);
		pbuf = set_ie(pbuf, _RSN_IE_1_, 7, tmp, &frlen);
	}
#if defined(CONFIG_RTL_WAPI_SUPPORT)
		if (priv->pmib->wapiInfo.wapiType!=wapiDisable)
		{
			SAVE_INT_AND_CLI(flags);
			*priv->pBeaconCapability |= cpu_to_le16(BIT(4));	/* set privacy	*/
			priv->wapiCachedBuf = pbuf+2;
			wapiSetIE(priv);
			pbuf[0] = _EID_WAPI_;
			pbuf[1] = priv->wapiCachedLen;
			pbuf += priv->wapiCachedLen+2;
			frlen += priv->wapiCachedLen+2;
			RESTORE_INT(flags);
		}
#endif

#ifdef WIFI_SIMPLE_CONFIG
/*modify for WPS2DOTX SUPPORT*/
	if (pmib->wscEntry.wsc_enable && pmib->wscEntry.beacon_ielen
		&& (priv->pmib->dot11StationConfigEntry.dot11AclMode != ACL_ALLOW || priv->pmib->dot11StationConfigEntry.dot11AclNum > 0))
	{
		memcpy(pbuf, pmib->wscEntry.beacon_ie, pmib->wscEntry.beacon_ielen);
		pbuf += pmib->wscEntry.beacon_ielen;
		frlen += pmib->wscEntry.beacon_ielen;
	}
#endif

#ifdef HS2_SUPPORT
	// support hs2 enable, p2p disable
	if ((OPMODE & WIFI_AP_STATE) && priv->pmib->hs2Entry.hs2_ielen)
	{
		//unsigned char p2ptmpie[]={0x50,0x6f,0x9a,0x09,0x02,0x02,0x00,0x00,0x00};
		unsigned char p2ptmpie[]={0x50,0x6f,0x9a,0x09,0x0a,0x01,0x00,0x05};
		pbuf = set_ie(pbuf, 221, sizeof(p2ptmpie), p2ptmpie, &frlen);
	}	
	if ((OPMODE & WIFI_AP_STATE) && priv->pmib->hs2Entry.hs2_ielen)
    {
        pbuf = set_ie(pbuf, _HS2_IE_, priv->pmib->hs2Entry.hs2_ielen, priv->pmib->hs2Entry.hs2_ie, &frlen);
    }
	if ((OPMODE & WIFI_AP_STATE) && priv->pmib->hs2Entry.interworking_ielen)
	{			
		unsigned char magicmac[MACADDRLEN]={0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};
		if (!memcmp(magicmac,priv->pmib->hs2Entry.interworking_ie+3,6))	{ // this case is used for HS2 testing (means MAC address of the AP)
			memcpy(priv->pmib->hs2Entry.interworking_ie+3, priv->pmib->dot11OperationEntry.hwaddr, MACADDRLEN);
			pbuf = set_ie(pbuf, _INTERWORKING_IE_, priv->pmib->hs2Entry.interworking_ielen, priv->pmib->hs2Entry.interworking_ie, &frlen);
			
		}
		else {
			pbuf = set_ie(pbuf, _INTERWORKING_IE_, priv->pmib->hs2Entry.interworking_ielen, priv->pmib->hs2Entry.interworking_ie, &frlen);
		}
	}		
	if ((OPMODE & WIFI_AP_STATE) && priv->pmib->hs2Entry.advt_proto_ielen)
	{
		pbuf = set_ie(pbuf, _ADVT_PROTO_IE_, priv->pmib->hs2Entry.advt_proto_ielen, priv->pmib->hs2Entry.advt_proto_ie, &frlen);
	}
	if ((OPMODE & WIFI_AP_STATE) && priv->pmib->hs2Entry.MBSSID_ielen)
	{
		pbuf = set_ie(pbuf, _MUL_BSSID_IE_, priv->pmib->hs2Entry.MBSSID_ielen, priv->pmib->hs2Entry.MBSSID_ie, &frlen);
	}
	if ((OPMODE & WIFI_AP_STATE) && priv->pmib->hs2Entry.roam_ielen && priv->pmib->hs2Entry.roam_enable)
	{
		pbuf = set_ie(pbuf, _ROAM_IE_, priv->pmib->hs2Entry.roam_ielen, priv->pmib->hs2Entry.roam_ie, &frlen);
	}

	if (priv->dtimcount == 0)
    {
		if (priv->timeadvt_dtimcount == 0)
		{	
			if ((OPMODE & WIFI_AP_STATE) && priv->pmib->hs2Entry.timeadvt_ielen)
			{
	            pbuf = set_ie(pbuf, _TIMEADVT_IE_, priv->pmib->hs2Entry.timeadvt_ielen, priv->pmib->hs2Entry.timeadvt_ie, &frlen);
			}
			if ((OPMODE & WIFI_AP_STATE) && priv->pmib->hs2Entry.timezone_ielen)
			{
	            pbuf = set_ie(pbuf, _TIMEZONE_IE_, priv->pmib->hs2Entry.timezone_ielen, priv->pmib->hs2Entry.timezone_ie, &frlen);
			}	
			priv->timeadvt_dtimcount = priv->pmib->hs2Entry.timeadvt_DTIMIntval-1;
		}
		else
		{
			priv->timeadvt_dtimcount--;
		}
	}
#endif

/* For easymesh R2 logo, wait for hostapd update beacon feature */
#if defined(RTK_MULTI_AP_LOGO) && defined(CONFIG_MBO)
	if (OPMODE & WIFI_AP_STATE)
	{
		unsigned char interworking_ie[1] = {0}, advt_proto[2] = {0};
		pbuf = set_ie(pbuf, _INTERWORKING_IE_, 1, interworking_ie, &frlen);
		extended_cap_ie[3] |= _INTERWORKING_SUPPORT_;

		advt_proto[0] = 127;
		advt_proto[1] = 0;
		pbuf = set_ie(pbuf, _ADVT_PROTO_IE_, 2, advt_proto, &frlen);

	}
#endif

#ifdef P2P_SUPPORT
	if ((rtk_p2p_is_enabled(priv)) && ((rtk_p2p_chk_role(priv,P2P_PRE_GO))||(rtk_p2p_chk_role(priv,P2P_TMP_GO))) ) 
	{
		if(priv->p2pPtr->p2p_beacon_ie_len){
			memcpy(pbuf, priv->p2pPtr->p2p_beacon_ie, priv->p2pPtr->p2p_beacon_ie_len);
			pbuf += priv->p2pPtr->p2p_beacon_ie_len;
			frlen += priv->p2pPtr->p2p_beacon_ie_len;
		}
	}
#endif

#ifdef USER_ADDIE
	for (i=0; i<MAX_USER_IE; i++) {
		if (priv->user_ie_list[i].used) {
			memcpy(pbuf, priv->user_ie_list[i].ie, priv->user_ie_list[i].ie_len);
			pbuf += priv->user_ie_list[i].ie_len;
			frlen += priv->user_ie_list[i].ie_len; 
		}
	}
#endif

#ifdef TDLS_SUPPORT 
	if(priv->pmib->dot11OperationEntry.tdls_prohibited){ 
		extended_cap_ie[4] |= _TDLS_PROHIBITED_;	// bit 38(tdls_prohibited)
	}else{
		if(priv->pmib->dot11OperationEntry.tdls_cs_prohibited){ 
			extended_cap_ie[4] |= _TDLS_CS_PROHIBITED_;	// bit 39(tdls_cs_prohibited)
		}
	}
#endif
#ifdef CONFIG_IEEE80211V
	if(WNM_ENABLE)
		extended_cap_ie[2] |= _BSS_TRANSITION_ ; // bit 19
#endif

#ifdef HAPD_11V
	if(priv->hapd_11v_enable)
		extended_cap_ie[2] |= _BSS_TRANSITION_ ; // bit 19
#endif

	#ifdef HS2_SUPPORT		/*process ext cap IE(IE ID=107) for HS2*/
	if (priv->pmib->hs2Entry.interworking_ielen)
	{	
		// byte0
		if (priv->proxy_arp){
			extended_cap_ie[1] |=_PROXY_ARP_ ;
		}		

		if ((priv->pmib->hs2Entry.timezone_ielen!=0) && (priv->pmib->hs2Entry.timeadvt_ielen)){
			extended_cap_ie[3] |= _UTC_TSF_OFFSET_ ;
		}
		extended_cap_ie[3] |= _INTERWORKING_SUPPORT_ ;			
		//HS2_CHECK
		if(priv->pmib->hs2Entry.QoSMap_ielen[0] || priv->pmib->hs2Entry.QoSMap_ielen[1])
			extended_cap_ie[4] |= _QOS_MAP_; // QoS MAP (Bit32) 		
			
		extended_cap_ie[5] |= _WNM_NOTIFY_; //WNM notification, Bit46
		
	}
	#endif

	#ifdef RTK_AC_SUPPORT //for 11ac logo 4.2.55
		if((priv->pmib->dot11BssType.net_work_type & WIRELESS_11AC)) 
		if((priv->pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm != _WEP_40_PRIVACY_)
			&& (priv->pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm != _WEP_104_PRIVACY_))
		{
			//41 operting mode
			{
				extended_cap_ie[7] |= 0x40;
			}
			
		}
	#endif
	/* ext cap IE fill in here! so far (HS2, AC,TDLS ) */	
	pbuf = set_ie(pbuf, _EXTENDED_CAP_IE_, 8, extended_cap_ie, &frlen);
	/*===========ext cap IE end=================*/
	/* Insert customized IE start*/
	if(priv->pptyIE) {
		unsigned char content[3+64+1];	//OUI+64-byte-content+1

		memcpy(content, priv->pptyIE->oui, 3);
		strcpy(content+3, priv->pptyIE->content);
		pbuf = set_ie(pbuf, priv->pptyIE->id, priv->pptyIE->length, content, &frlen);
	}

#ifdef BEACON_VS_IE
	for(y = 0; y < NUM_BCNVSIE_SERVICE; y++)
	{
		if((priv->bcn_vsie[y].service_name_len && priv->bcn_vsie[y].data_len) &&
			(priv->bcn_vsie[y].duration_count <= priv->bcn_vsie[y].duration))
		{
			unsigned char content[3+BEACON_VSIE_LEN];
			memcpy(content, priv->bcn_vsie[y].oui, 3);
			memcpy(content+3, priv->bcn_vsie[y].data, priv->bcn_vsie[y].data_len);
			pbuf = set_ie(pbuf, priv->bcn_vsie[y].id, priv->bcn_vsie[y].data_len+3, content, &frlen);
		}
	}
#endif
	/* Insert customized IE end*/
/*
	pdesc->Dword0 = set_desc(TX_FirstSeg| TX_LastSeg|  (32)<<TX_OffsetSHIFT | (frlen) << TX_PktSizeSHIFT);
	pdesc->Dword1 = set_desc(0x10 << TX_QSelSHIFT);
//		pdesc->Dword4 = set_desc((0x7 << TX_RaBRSRIDSHIFT) | TX_UseRate);	// need to confirm
	pdesc->Dword4 = set_desc(TX_UseRate);
	pdesc->Dword4 = set_desc(TX_DisDataFB);
	pdesc->Dword7 = set_desc(frlen & TX_TxBufSizeMask);
*/	// by signin_beacon_desc

#if defined(CONFIG_RTL8196B_TR) || defined(CONFIG_RTL8196C_EC)
	priv->ext_stats.tx_byte_cnt += frlen;
#endif
//#ifdef CONFIG_RTL865X_AC
#if defined(CONFIG_RTL865X_AC) || defined(CONFIG_RTL865X_KLD) || defined(CONFIG_RTL8196B_KLD) || defined(CONFIG_RTL8196C_KLD)
	priv->ext_stats.tx_byte_cnt += frlen;
#endif

#ifdef WDS
	// if pure WDS bridge, don't send beacon
	if ((OPMODE & WIFI_AP_STATE) && pmib->dot11WdsInfo.wdsPure)
		return;
#endif

        // if schedule off, don't send beacon
        if (priv->pmib->miscEntry.func_off)
        {
#ifdef MBSSID
            if(!((GET_CHIP_VER(priv)== VERSION_8188C) || (GET_CHIP_VER(priv)== VERSION_8192C) || (GET_CHIP_VER(priv)== VERSION_8192D)))
                return;
            else if(!IS_ROOT_INTERFACE(priv))
                return;
#else
                    return;
#endif
        }

	if (!IS_DRV_OPEN(priv))
		return;

#ifdef CONFIG_RTL_OFFLOAD_DRIVER
    if(OFFLOAD_ENABLE(priv)){
        //do nothing
    }else
#endif
    {
    //		pdesc->Dword0 |= set_desc(TX_OWN);	// by signin_beacon_desc
    	assign_wlanseq(phw, (unsigned char *)priv->beaconbuf, NULL ,pmib
#ifdef CONFIG_RTK_MESH	// For broadcast data frame via mesh (ex:ARP requst)
    		, 0
#endif
    		);
    //		pdesc->Dword3 |= set_desc((GetSequence(priv->beaconbuf) & TX_SeqMask)<< TX_SeqSHIFT);	// by signin_beacon_desc
    //		rtl_cache_sync_wback(priv, get_desc(pdesc->Dword8), 128*sizeof(unsigned int), PCI_DMA_TODEVICE);	// by signin_beacon_desc
    }

#ifdef CONFIG_PCI_HCI
	if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE) {
#ifdef PCIE_POWER_SAVING
#ifdef  CONFIG_WLAN_HAL
		if (IS_HAL_CHIP(priv)) {
			if ((priv->offload_ctrl & 1) && (priv->pshare->rf_ft_var.power_save & offload_en)) {
				// this section is for AP_OFFLOAD download 
				unsigned char *prsp;
#if (IS_RTL8822B_SERIES || IS_RTL8821C_SERIES || IS_RTL8822C_SERIES || IS_RTL8812F_SERIES)
	if (IS_HARDWARE_TYPE_8822B(priv) || IS_HARDWARE_TYPE_8821C(priv) || IS_HARDWARE_TYPE_8822C(priv) || IS_HARDWARE_TYPE_8812F(priv))
				const unsigned char txDesSize = SIZE_TXDESC_88XX_V1;
	else
			const unsigned char txDesSize = SIZE_TXDESC_88XX;
#else
				const unsigned char txDesSize = SIZE_TXDESC_88XX;
#endif
				unsigned char pkt_offset = 0;
				unsigned int dummy = 0;      
				unsigned int probePayloadLen = 0;                
				unsigned int totalPktLen = 0;               
	        		unsigned int len;

				len = frlen + txDesSize; // add beacon tx desc size, now len is represent from beacon desc + beacon payload

				dummy = GET_HAL_INTERFACE(priv)->GetRsvdPageLocHandler(priv,len, &pkt_offset); // dummy = bcn pkt_len + dummy
				priv->offload_ctrl = 1 | (dummy & 0x7f80);
	       
#if (IS_RTL8197F_SERIES || IS_RTL8822B_SERIES || IS_RTL8821C_SERIES || IS_RTL8822C_SERIES || IS_RTL8812F_SERIES)
			if (IS_HARDWARE_TYPE_8197F(priv) || IS_HARDWARE_TYPE_8822B(priv) || IS_HARDWARE_TYPE_8821C(priv) || IS_HARDWARE_TYPE_8822C(priv) || IS_HARDWARE_TYPE_8812F(priv)) { //3081
					priv->offload_bcn_page = RTL_R16(0x204) & 0x0fff;
					priv->offload_proc_page = priv->offload_bcn_page + pkt_offset;  
				}
#else
				priv->offload_bcn_page = RTL_R8(0x209);
				priv->offload_proc_page = RTL_R8(0x209) + pkt_offset;      
#endif
				printk("priv->offload_bcn_page = 0x%x\n", priv->offload_bcn_page);
				printk("priv->offload_proc_page = 0x%x\n", priv->offload_proc_page);  
				printk("dummy = 0x%x\n", dummy);              

				prsp = (unsigned char *)priv->beaconbuf + dummy ;
				memset(prsp, 0, WLAN_HDR_A3_LEN);
				probePayloadLen = WLAN_HDR_A3_LEN + fill_probe_rsp_content(priv, prsp, prsp + WLAN_HDR_A3_LEN, SSID, SSID_LEN, 1, 0, 0);
				len = probePayloadLen;

				assign_wlanseq(phw, prsp, NULL ,pmib
#ifdef CONFIG_RTK_MESH	// For broadcast data frame via mesh (ex:ARP requst)
						, 0
#endif
				);
	             
				totalPktLen = probePayloadLen + dummy;
	        
				GET_HAL_INTERFACE(priv)->SetRsvdPageHandler(priv, prsp, priv->beaconbuf, probePayloadLen, totalPktLen, frlen);

				priv->offload_ctrl &=  (~1); // finish download Rsvd Page
				RTL_W16(CR , RTL_R16(CR) & ~ENSWBCN); // disable sw beacon
				//delay_us(100);
				//printk("probePlayloadLen : %d\n", probePayloadLen);
				//mem_dump("beacon + probe",priv->beaconbuf, totalPktLen);	
			}
			else 
			{
				GET_HAL_INTERFACE(priv)->SigninBeaconTXBDHandler(priv, priv->beaconbuf, frlen);
				GET_HAL_INTERFACE(priv)->SetBeaconDownloadHandler(priv, HW_VAR_BEACON_ENABLE_DOWNLOAD);
			}
		}
#else // CONFIG_WLAN_HAL		
		if((priv->offload_ctrl&1) && priv->pshare->rf_ft_var.power_save) {
			unsigned char *prsp;
			int len	;
			struct tx_desc tx_desc;
			len = frlen + TX_DESC_SZ;
			if(len%PKT_PAGE_SZ)
				len = (len+PKT_PAGE_SZ-(len%PKT_PAGE_SZ)) ;
			priv->offload_ctrl =  1| (len&0x7f80);

			prsp = (unsigned char *)priv->beaconbuf  + len  ;
			memset(prsp, 0, WLAN_HDR_A3_LEN);
			len = WLAN_HDR_A3_LEN + fill_probe_rsp_content(priv, prsp, prsp+WLAN_HDR_A3_LEN, SSID, SSID_LEN, 1, 0, 0, 0);
			assign_wlanseq(phw, prsp, NULL ,pmib
#ifdef CONFIG_RTK_MESH	// For broadcast data frame via mesh (ex:ARP requst)
						, 0
#endif
			);
			memset(&tx_desc, 0, TX_DESC_SZ);
			fill_bcn_desc(priv, &tx_desc, (void*)prsp, len, 1);
			tx_desc.Dword5 |= set_desc(TX_RtyLmtEn);
			memcpy(prsp-TX_DESC_SZ, &tx_desc, TX_DESC_SZ );
			len += (priv->offload_ctrl&0x7f80) /*+TX_DESC_SZ*/;
			signin_beacon_desc(priv, priv->beaconbuf, len);
		}
	    else {
			signin_beacon_desc(priv, priv->beaconbuf, frlen);
		}

		// Now we use sw beacon, we need to poll it every time.
		RTL_W8(PCIE_CTRL_REG, BCNQ_POLL);
#endif // #ifdef  CONFIG_WLAN_HAL		
#else


#ifdef CONFIG_OFFLOAD_FUNCTION
#ifdef  CONFIG_WLAN_HAL
		if((priv->offload_function_ctrl&1)) {
	    // this section is for AP_OFFLOAD download 
			unsigned char *prsp;
			unsigned char txDesSize = 40;
	        unsigned char pkt_offset = 0;
	        unsigned int dummy = 0;      
	        unsigned int probePayloadLen = 0;                
	        unsigned int TotalPktLen = 0;               
	        
			unsigned int len	;
			
			// now len is represent from beacon desc + beacon payload

#if (IS_RTL8881A_SERIES || IS_RTL8192E_SERIES || IS_RTL8814A_SERIES || IS_RTL8197F_SERIES || IS_RTL8198F_SERIES)
	        if ( IS_HARDWARE_TYPE_8881A(priv) || IS_HARDWARE_TYPE_8192E(priv) || IS_HARDWARE_TYPE_8814A(priv) || IS_HARDWARE_TYPE_8197F(priv) || IS_HARDWARE_TYPE_8198F(priv)){
	            txDesSize = SIZE_TXDESC_88XX;
	        }
#endif   
#if (IS_RTL8822B_SERIES)
	        if(IS_HARDWARE_TYPE_8822B(priv))
	            txDesSize = SIZE_TXDESC_88XX_V1;
#endif        
#if (IS_RTL8822C_SERIES)
        if(IS_HARDWARE_TYPE_8822C(priv))
            txDesSize = SIZE_TXDESC_88XX_V1;
#endif    
#if (IS_RTL8812F_SERIES)
        if(IS_HARDWARE_TYPE_8812F(priv))
            txDesSize = SIZE_TXDESC_88XX_V1;
#endif    
#if (IS_RTL8814B_SERIES)        
	        if(IS_HARDWARE_TYPE_8814B(priv))
	            txDesSize = SIZE_TXDESC_88XX_V2_BCN;
#endif
			len = frlen + txDesSize; // add beacon tx desc size , 

	         dummy = GET_HAL_INTERFACE(priv)->GetRsvdPageLocHandler(priv,len,&pkt_offset);
	        // dummy = bcn pkt_len + dummy

#if (IS_RTL8881A_SERIES || IS_RTL8192E_SERIES )
	        if ( IS_HARDWARE_TYPE_8881A(priv) || IS_HARDWARE_TYPE_8192E(priv) ) { //8051
	        priv->offload_bcn_page = RTL_R8(0x209);
	        priv->offload_proc_page = RTL_R8(0x209) + pkt_offset;      
	        }
#endif
#if (IS_RTL8197F_SERIES || IS_RTL8822B_SERIES || IS_RTL8821C_SERIES || IS_RTL8198F_SERIES || IS_RTL8822C_SERIES || IS_RTL8812F_SERIES)
        if ( IS_HARDWARE_TYPE_8197F(priv) || IS_HARDWARE_TYPE_8822B(priv) || IS_HARDWARE_TYPE_8821C(priv)|| IS_HARDWARE_TYPE_8198F(priv) || IS_HARDWARE_TYPE_8822C(priv) || IS_HARDWARE_TYPE_8812F(priv)) { //3081
	            priv->offload_bcn_page = RTL_R16(0x204)&0x0fff;
	            priv->offload_proc_page = priv->offload_bcn_page + pkt_offset;  
	        }
#endif
#if (IS_RTL8814B_SERIES)
	        if ( IS_HARDWARE_TYPE_8814B(priv)){
	            priv->offload_bcn_page = RTL_R16(0x200)&0x0fff;
	            priv->offload_proc_page = priv->offload_bcn_page + pkt_offset; 
	        }
#endif

	        printk("priv->offload_bcn_page =%x \n",priv->offload_bcn_page);
	        printk("priv->offload_proc_page =%x \n",priv->offload_proc_page);  
	        printk("dummy =%x \n",dummy);              

			prsp = (unsigned char *)priv->beaconbuf  + dummy ;
			memset(prsp, 0, WLAN_HDR_A3_LEN);
			probePayloadLen = WLAN_HDR_A3_LEN + fill_probe_rsp_content(priv, prsp, prsp+WLAN_HDR_A3_LEN, SSID, SSID_LEN, 1, 0, 0, 0);
	        len = probePayloadLen;

			assign_wlanseq(phw, prsp, NULL ,pmib
#ifdef CONFIG_RTK_MESH	// For broadcast data frame via mesh (ex:ARP requst)
						, 0
#endif
			);
	             
	        TotalPktLen = probePayloadLen + dummy;

	        
	        GET_HAL_INTERFACE(priv)->SetRsvdPageHandler(priv,prsp,priv->beaconbuf,probePayloadLen,TotalPktLen,frlen);
	        //delay_us(100);
	        

	        // TODO: currently, we do not implement this function, so mark it temporarily
			// 8814 merge issue
	        //GET_HAL_INTERFACE(priv)->DownloadRsvdPageHandler(priv,priv->beaconbuf,frlen);
	        priv->offload_function_ctrl = 0;
		}
	    else 
#endif // #ifdef  CONFIG_WLAN_HAL		
#endif //#ifdef CONFIG_OFFLOAD_FUNCTION
	    {
#ifdef  CONFIG_WLAN_HAL
		if (IS_HAL_CHIP(priv)) {
	        GET_HAL_INTERFACE(priv)->SigninBeaconTXBDHandler(priv, priv->beaconbuf, frlen);
	        GET_HAL_INTERFACE(priv)->SetBeaconDownloadHandler(priv, HW_VAR_BEACON_ENABLE_DOWNLOAD);
		} else if(CONFIG_WLAN_NOT_HAL_EXIST)
#endif
	    {//not HAL
		    signin_beacon_desc(priv, priv->beaconbuf, frlen);
	    }

		// Now we use sw beacon, we need to poll it every time.
		//RTL_W8(PCIE_CTRL_REG, BCNQ_POLL);
	    }
#endif //PCIE_POWER_SAVING
	}
#endif // CONFIG_PCI_HCI

#if defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI)
	if (GET_HCI_TYPE(priv) == RTL_HCI_USB || GET_HCI_TYPE(priv) == RTL_HCI_SDIO) {
#ifdef SDIO_AP_OFFLOAD
		if ((RTW_PM_PREPROCESS == priv->pshare->offload_function_ctrl)
#ifdef MBSSID
			&& (0 == priv->vap_init_seq)
#endif
#ifdef CONFIG_SDIO_TX_INTERRUPT
			&& !GET_HAL_INTF_DATA(priv)->SdioTxIntStatus
#ifdef CONFIG_SDIO_TX_IN_INTERRUPT
			&& !priv->pshare->xmit_thread_state
#endif
#endif
			)
		{
			ap_offload_process(priv, frlen);
		}
		else
#endif
		{
		#if defined(CONFIG_RTL_TRIBAND_SUPPORT)
			signin_beacon_desc_usb(priv, priv->beaconbuf, frlen);
		#else
			signin_beacon_desc(priv, priv->beaconbuf, frlen);
		#endif
		}
	}
#endif // CONFIG_USB_HCI || CONFIG_SDIO_HCI
#ifdef CONFIG_RTL_OFFLOAD_DRIVER
	/* Temporary disable beacon update regularly */
	/* priv->beacon_updated = 1; */
#endif
}


#if defined(RTK_NL80211) && defined(UNIVERSAL_REPEATER) && defined(CLIENT_MODE) // wrt-adhoc
void construct_ibss_beacon(struct rtl8192cd_priv *priv)
{
    unsigned short	val16;
    unsigned char	val8;
    struct wifi_mib *pmib;
    unsigned char	*bssid;

    unsigned int	frlen=0;
    unsigned char	*pbuf=(unsigned char *)priv->beaconbuf_ibss_vxd;
    unsigned char	*pbssrate=NULL;
    unsigned int	bssrate_len=0;
    struct FWtemplate *txfw;
    struct FWtemplate Temptxfw;

    unsigned int rate;


	pmib = GET_MIB(priv);
	bssid = pmib->dot11StationConfigEntry.dot11Bssid;



    {
        unsigned char tmpbssid[MACADDRLEN];

        unsigned char random;
        int i =0;

        memset(tmpbssid, 0, MACADDRLEN);
        if (!memcmp(BSSID, tmpbssid, MACADDRLEN)) {
            // generate an unique Ibss ssid
#ifdef __ECOS
            {
                unsigned char random_buf[4];
                get_random_bytes(random_buf, 4);
                random = random_buf[3];
            }
#else
            get_random_bytes(&random, 1);
#endif
            tmpbssid[0] = 0x02;
            for (i=1; i<MACADDRLEN; i++)
                tmpbssid[i] = GET_MY_HWADDR[i-1] ^ GET_MY_HWADDR[i] ^ random;
            while(1) {
                for (i=0; i<priv->site_survey->count_target; i++) {
                    if (!memcmp(tmpbssid, priv->site_survey->bss_target[i].bssid, MACADDRLEN)) {
                        tmpbssid[5]++;
                        break;
                    }
                }
                if (i == priv->site_survey->count)
                    break;
            }
        }
    }

    memset(pbuf, 0, sizeof(priv->beaconbuf_ibss_vxd));

    txfw = &Temptxfw;
    rate = find_rate(priv, NULL, 0, 1);

    if (is_MCS_rate(rate)) {
        // can we use HT rates for beacon?
        txfw->txRate = rate & 0x7f;
        txfw->txHt = 1;
    }
    else {
        txfw->txRate = get_rate_index_from_ieee_value((UINT8)rate);
        if (priv->pshare->is_40m_bw) {
            if (priv->pshare->offset_2nd_chan == HT_2NDCH_OFFSET_BELOW)
                txfw->txSC = 2;
            else
                txfw->txSC = 1;
        }
    }

    SetFrameSubType(pbuf, WIFI_BEACON);

    memset((void *)GetAddr1Ptr(pbuf), 0xff, 6);
    memcpy((void *)GetAddr2Ptr(pbuf), GET_MY_HWADDR, 6);
    memcpy((void *)GetAddr3Ptr(pbuf), bssid, 6); // (Indeterminable set null mac (all zero)) (Refer: Draft 1.06, Page 12, 7.2.3, Line 21~30)

    pbuf += 24;
    frlen += 24;

    frlen += _TIMESTAMP_;	// for timestamp
    pbuf += _TIMESTAMP_;

    //setup BeaconPeriod...
    if(priv->beacon_period <= 0)
        priv->beacon_period	= pmib->dot11StationConfigEntry.dot11BeaconPeriod;

    if(priv->beacon_period)
        val16 = cpu_to_le16(priv->beacon_period);
    else
        val16 = cpu_to_le16(100);

    pbuf = set_fixed_ie(pbuf, _BEACON_ITERVAL_, (unsigned char *)&val16, &frlen);

    val16 = cpu_to_le16(BIT(1)); //IBSS


    if (priv->pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm)
        val16 |= cpu_to_le16(BIT(4));

    if (SHORTPREAMBLE)
        val16 |= cpu_to_le16(BIT(5));
#ifdef RTK_AC_SUPPORT //for 11ac logo
    if(priv->pshare->rf_ft_var.lpwrc)
        val16 |= cpu_to_le16(BIT(8));	/* set spectrum mgt */
#endif			

#ifdef DOT11K
    if(priv->pmib->dot11StationConfigEntry.dot11SMMeasurementActivated)
        val16 |= cpu_to_le16(BIT(8));	/* set spectrum mgt measurement */

    if(priv->pmib->dot11StationConfigEntry.dot11RadioMeasurementActivated)
        val16 |= cpu_to_le16(BIT(12));   /* set radio measurement */
#endif

#ifdef HAPD_11K
	if(priv->hapd_11k_ie_len){
		val16 |= cpu_to_le16(BIT(12));   /* set radio measurement */
	}
#endif

    pbuf = set_fixed_ie(pbuf, _CAPABILITY_, (unsigned char *)&val16, &frlen);
    priv->pBeaconCapability = (unsigned short *)(pbuf - _CAPABILITY_);

    if ((priv->pmib->dot11BssType.net_work_type & WIRELESS_11G) && (priv->pmib->dot11ErpInfo.shortSlot))
        SET_SHORTSLOT_IN_BEACON_CAP;
    else
        RESET_SHORTSLOT_IN_BEACON_CAP;

    //set ssid...
    pbuf = set_ie(pbuf, _SSID_IE_, SSID_LEN, SSID, &frlen);

    //supported rates...
    if (get_bssrate_set(priv, _SUPPORTEDRATES_IE_, &pbssrate, &bssrate_len))
    pbuf = set_ie(pbuf, _SUPPORTEDRATES_IE_, bssrate_len, pbssrate, &frlen);


    val16 = 0;
    pbuf = set_ie(pbuf, _IBSS_PARA_IE_, 2, (unsigned char *)&val16, &frlen);


#if defined(DOT11D) || defined(DOT11H) || defined(DOT11K)    
    if(priv->countryTableIdx) {    
        pbuf = construct_country_ie(priv, pbuf, &frlen);   
    }
#endif

#if defined(DOT11H) || defined(DOT11K)
    if(priv->pmib->dot11hTPCEntry.tpc_enable || priv->pmib->dot11StationConfigEntry.dot11RadioMeasurementActivated) {
        pbuf = set_ie(pbuf, _PWR_CONSTRAINT_IE_, 1, &priv->pshare->rf_ft_var.lpwrc, &frlen);        
        pbuf = construct_TPC_report_ie(priv, pbuf, &frlen);
    }
#endif
	
    if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11G) {
        // ERP infomation
        unsigned char val8 = 0;
        if (priv->pmib->dot11ErpInfo.protection)
            val8 |= BIT(1);
        if (priv->pmib->dot11ErpInfo.nonErpStaNum)
            val8 |= BIT(0);

        if (!SHORTPREAMBLE || priv->pmib->dot11ErpInfo.longPreambleStaNum)
            val8 |= BIT(2);

        pbuf = set_ie(pbuf, _ERPINFO_IE_, 1, &val8, &frlen);
    }

    // EXT supported rates
    if (get_bssrate_set(priv, _EXT_SUPPORTEDRATES_IE_, &pbssrate, &bssrate_len))
        pbuf = set_ie(pbuf, _EXT_SUPPORTEDRATES_IE_, bssrate_len, pbssrate, &frlen);

#ifdef DOT11K
    if(priv->pmib->dot11StationConfigEntry.dot11RadioMeasurementActivated)
    {
        /* RM Enabled Capabilities*/
        pbuf = construct_rm_enable_cap_ie(priv, pbuf, &frlen);
    }
#endif	

    if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11N) {
        construct_ht_ie(priv, priv->pshare->is_40m_bw, priv->pshare->offset_2nd_chan);
        pbuf = set_ie(pbuf, _HT_CAP_, priv->ht_cap_len, (unsigned char *)&priv->ht_cap_buf, &frlen);
        pbuf = set_ie(pbuf, _HT_IE_, priv->ht_ie_len, (unsigned char *)&priv->ht_ie_buf, &frlen);
    }
	// beacon
#ifdef RTK_AC_SUPPORT //for 11ac logo
	if((priv->pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm != _WEP_40_PRIVACY_)
		&& (priv->pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm != _WEP_104_PRIVACY_))
    if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11AC) {
        // 41
        {
            char tmp[8];
            memset(tmp, 0, 8);
            tmp[7] = 0x40;
            pbuf = set_ie(pbuf, _EXTENDED_CAP_IE_, 8, tmp, &frlen);
        }
        // 60, 61
        construct_vht_ie(priv, priv->pshare->working_channel);
        pbuf = set_ie(pbuf, EID_VHTCapability, priv->vht_cap_len, (unsigned char *)&priv->vht_cap_buf, &frlen);
        pbuf = set_ie(pbuf, EID_VHTOperation, priv->vht_oper_len, (unsigned char *)&priv->vht_oper_buf, &frlen);
        // 62 
        if(priv->pshare->rf_ft_var.lpwrc) {
            char tmp[4];
            pbuf = set_ie(pbuf, _PWR_CONSTRAINT_IE_, 1, &priv->pshare->rf_ft_var.lpwrc, &frlen);
            tmp[1] = tmp[2] = tmp[3] = priv->pshare->rf_ft_var.lpwrc;
            tmp[0] = priv->pshare->CurrentChannelBW;	//	20, 40, 80
            pbuf = set_ie(pbuf, EID_VHTTxPwrEnvelope, tmp[0]+2, tmp, &frlen);	
        }
    }
#endif
	
#ifdef RTK_AC_SUPPORT //for 11ac logo
    if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11AC) {
        //66
        if(priv->pshare->rf_ft_var.opmtest&1) {
            pbuf = set_ie(pbuf, EID_VHTOperatingMode, 1, (unsigned char *)&(priv->pshare->rf_ft_var.oper_mode_field), &frlen);
        }	
    }
#endif	

    if (pmib->dot11RsnIE.rsnielen) {
        memcpy(pbuf, pmib->dot11RsnIE.rsnie, pmib->dot11RsnIE.rsnielen);
        pbuf += pmib->dot11RsnIE.rsnielen;
        frlen += pmib->dot11RsnIE.rsnielen;
    }

#ifdef WIFI_WMM
    //Set WMM Parameter Element
    if (QOS_ENABLE)
        pbuf = set_ie(pbuf, _RSN_IE_1_, _WMM_Para_Element_Length_, GET_WMM_PARA_IE, &frlen);
#endif

    //if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11N) {
    //    pbuf = construct_ht_ie_old_form(priv, pbuf, &frlen);
    //}

    // Realtek proprietary IE
    if (priv->pshare->rtk_ie_len)
        pbuf = set_ie(pbuf, _RSN_IE_1_, priv->pshare->rtk_ie_len, priv->pshare->rtk_ie_buf, &frlen);

    // Customer proprietary IE
    if (priv->pmib->miscEntry.private_ie_len) {
        memcpy(pbuf, pmib->miscEntry.private_ie, pmib->miscEntry.private_ie_len);
        pbuf += pmib->miscEntry.private_ie_len;
        frlen += pmib->miscEntry.private_ie_len;
    }

    priv->beaconbuf_ibss_vxd_len = frlen;
}

void issue_beacon_ibss_vxd(struct rtl8192cd_priv *priv)
{
	unsigned long flags;
	DECLARE_TXINSN(txinsn);

	if (!(priv->drv_state & DRV_STATE_OPEN))
		return;

	SAVE_INT_AND_CLI(flags);
	SMP_LOCK(flags);

	if(priv->beaconbuf_ibss_vxd_len<=0)
		goto issue_beacon_ibss_done;

	if(!netif_running(priv->dev))
		goto issue_beacon_ibss_done;

	txinsn.q_num = MANAGE_QUE_NUM;
	txinsn.fr_type = _PRE_ALLOCMEM_;
	txinsn.tx_rate = find_rate(priv, NULL, 0, 1);
#ifndef TX_LOWESTRATE	
	txinsn.lowest_tx_rate = txinsn.tx_rate;
#endif	
	txinsn.fixed_rate = 1;
	txinsn.phdr = get_wlanhdr_from_poll(priv);
	txinsn.pframe = get_mgtbuf_from_poll(priv);

	if (txinsn.phdr == NULL)
		goto issue_beacon_ibss_fail;

	if (txinsn.pframe == NULL)
		goto issue_beacon_ibss_fail;

//fill MAC header
	memset((void *)(txinsn.phdr), 0, sizeof (struct	wlan_hdr));

	SetFrameSubType(txinsn.phdr, WIFI_BEACON);
	memset((void *)GetAddr1Ptr((txinsn.phdr)), 0xff, MACADDRLEN);
	memcpy((void *)GetAddr2Ptr((txinsn.phdr)), GET_MY_HWADDR, MACADDRLEN);
	memcpy((void *)GetAddr3Ptr((txinsn.phdr)), BSSID, MACADDRLEN);
	
//fill Beacon frames
	txinsn.fr_len = (priv->beaconbuf_ibss_vxd_len-24);

	if(txinsn.fr_len > 0)
		memcpy((unsigned char *)txinsn.pframe, (((unsigned char *)priv->beaconbuf_ibss_vxd)+24) , txinsn.fr_len);
	else 
		goto issue_beacon_ibss_fail;
	
	if ((rtl8192cd_firetx(priv, &txinsn)) == SUCCESS)
		goto issue_beacon_ibss_done;

issue_beacon_ibss_fail:
	if (txinsn.phdr)
		release_wlanhdr_to_poll(priv, txinsn.phdr);
	if (txinsn.pframe)
		release_mgtbuf_to_poll(priv, txinsn.pframe);

issue_beacon_ibss_done:
	RESTORE_INT(flags);
	SMP_UNLOCK(flags);

	rtk_mod_timer(&priv->pshare->vxd_ibss_beacon, jiffies + RTL_MILISECONDS_TO_JIFFIES(500));
}

static __always_inline void beacon_ibss_vxd_timer_cb(unsigned long task_priv)
{
	struct rtl8192cd_priv *priv = (struct rtl8192cd_priv *)task_priv;

	issue_beacon_ibss_vxd(priv);
}
DEFINE_TIMER_CALLBACK(beacon_ibss_vxd_timer_cb);

void init_vxd_ibss_beacon_timer(struct rtl8192cd_priv *priv)
{
	rtk_timer_setup(&(priv->pshare->vxd_ibss_beacon), beacon_ibss_vxd_timer_cb, (unsigned long)priv, 0);
}
#endif // RTK_NL80211 && UNIVERSAL_REPEATER && CLIENT_MODE

/**
 *	@brief	Initial beacon
 *
  *	Refer wifi.h and 8190mib.h about MIB define.	\n
 *  Refer 802.11 7,3,13 Beacon interval field	\n
 *	- Timestamp \n - Beacon interval \n - Capability \n - SSID \n - Support rate \n - DS Parameter set \n \n
 *	+-------+-------+-------+	\n
 *	| addr1 | addr2 | addr3 |	\n
 *	+-------+-------+-------+	\n
 *
 *	+-----------+-----------------+------------+------+--------------+------------------+	\n
 *	| Timestamp | Beacon interval | Capability | SSID | Support rate | DS Parameter set |	\n
 *	+-----------+-----------------+------------+------+--------------+------------------+	\n
 *	[Note] \n
 *	abridge FH (unused), CF (AP not support PCF), \n
 *	IBSS parameter set (STA), DTIM (AP), ERP ??Ext rate  IE complete in Update beacon.\n
 *	set_desc is important.
 */

void init_beacon(struct rtl8192cd_priv *priv)
{
    unsigned short	val16;
    unsigned char	val8;
    struct wifi_mib *pmib;
    unsigned char	*bssid;
    //		struct tx_desc		*pdesc;
    //		struct rtl8192cd_hw	*phw=GET_HW(priv);
    //		int next_idx = 1;

    unsigned int	frlen=0;
    unsigned char	*pbuf=(unsigned char *)priv->beaconbuf;
#ifndef RTK_NL80211
    unsigned char	*pbssrate=NULL;
    unsigned int	bssrate_len=0;
	int ret=0;
#endif
    struct FWtemplate *txfw;
    struct FWtemplate Temptxfw;

    unsigned int rate;

#ifdef RTK_NL80211 //wrt-adhoc
	if(IS_VXD_INTERFACE(priv) && (OPMODE & WIFI_ADHOC_STATE))
		return;
#endif
    //hapd11klog("hapd_11k_ie_len=[%d]\n",priv->hapd_11k_ie_len);
    pmib = GET_MIB(priv);
    bssid = pmib->dot11StationConfigEntry.dot11Bssid;

    //memset(pbuf, 0, 128*4);
    memset(pbuf, 0, sizeof(priv->beaconbuf));
    txfw = &Temptxfw;

#ifdef P2P_SUPPORT
    if(rtk_p2p_is_enabled(priv)){
        rate = _6M_RATE_;
    }else
#endif
        rate = find_rate(priv, NULL, 0, 1);

    if (is_MCS_rate(rate)) {
        // can we use HT rates for beacon?
        txfw->txRate = rate - HT_RATE_ID;
        txfw->txHt = 1;
    }
    else {
        txfw->txRate = get_rate_index_from_ieee_value((UINT8)rate);
        if (priv->pshare->is_40m_bw) {
            if (priv->pshare->offset_2nd_chan == HT_2NDCH_OFFSET_BELOW)
                txfw->txSC = 2;
            else
                txfw->txSC = 1;
        }
    }

    SetFrameSubType(pbuf, WIFI_BEACON);

    memset((void *)GetAddr1Ptr(pbuf), 0xff, 6);
    memcpy((void *)GetAddr2Ptr(pbuf), GET_MY_HWADDR, 6);
    memcpy((void *)GetAddr3Ptr(pbuf), bssid, 6); // (Indeterminable set null mac (all zero)) (Refer: Draft 1.06, Page 12, 7.2.3, Line 21~30)

    pbuf += 24;
    frlen += 24;

    frlen += _TIMESTAMP_;	// for timestamp
    pbuf += _TIMESTAMP_;

    //setup BeaconPeriod...
    val16 = cpu_to_le16(pmib->dot11StationConfigEntry.dot11BeaconPeriod);
#ifdef CLIENT_MODE
    if (OPMODE & WIFI_ADHOC_STATE)
        val16 = cpu_to_le16(priv->beacon_period);
#endif
    pbuf = set_fixed_ie(pbuf, _BEACON_ITERVAL_, (unsigned char *)&val16, &frlen);

#ifdef CONFIG_RTK_MESH
    if ((1 == GET_MIB(priv)->dot1180211sInfo.mesh_enable) && (0 == GET_MIB(priv)->dot1180211sInfo.mesh_ap_enable))	// non-AP MP (MAP)	only, popen:802.11s Draft 1.0 P17  7.3.1.4 : ESS & IBSS are "0" (PS:val reset here)
        val16 = 0;
    else
#endif	// CONFIG_RTK_MESH
    {
        if (OPMODE & WIFI_AP_STATE)
            val16 = cpu_to_le16(BIT(0)); //ESS
        else
            val16 = cpu_to_le16(BIT(1)); //IBSS
    }

    if (priv->pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm)
        val16 |= cpu_to_le16(BIT(4));

    if (SHORTPREAMBLE)
        val16 |= cpu_to_le16(BIT(5));
    
#ifdef DOT11H
    if(priv->pmib->dot11hTPCEntry.tpc_enable)
        val16 |= cpu_to_le16(BIT(8));	/* set spectrum mgt */
#endif
    
#ifdef DOT11K
    if(priv->pmib->dot11StationConfigEntry.dot11SMMeasurementActivated)
        val16 |= cpu_to_le16(BIT(8));	/* set spectrum mgt measurement */

    if(priv->pmib->dot11StationConfigEntry.dot11RadioMeasurementActivated)
        val16 |= cpu_to_le16(BIT(12));   /* set radio measurement */
#endif

#ifdef HAPD_11K
	if(priv->hapd_11k_ie_len){
		val16 |= cpu_to_le16(BIT(12));   /* set radio measurement */
	}
#endif

#if defined(WMM_APSD)
	if (APSD_ENABLE) 
		val16 |= cpu_to_le16(BIT(11));
#endif	

    pbuf = set_fixed_ie(pbuf, _CAPABILITY_, (unsigned char *)&val16, &frlen);
    priv->pBeaconCapability = (unsigned short *)(pbuf - _CAPABILITY_);

    if ((priv->pmib->dot11BssType.net_work_type & WIRELESS_11G) && (priv->pmib->dot11ErpInfo.shortSlot))
        SET_SHORTSLOT_IN_BEACON_CAP;
    else
        RESET_SHORTSLOT_IN_BEACON_CAP;

    //set ssid...
#ifdef WIFI_SIMPLE_CONFIG
    priv->pbeacon_ssid = pbuf;
#endif
#ifdef CONFIG_RTK_MESH
    if ((1 == GET_MIB(priv)->dot1180211sInfo.mesh_enable) && (0 == GET_MIB(priv)->dot1180211sInfo.mesh_ap_enable)) { // non-AP MP (MAP) only, popen:802.11s Draft 1.0, Page 11, SSID
        //pbuf = set_ie(pbuf, _SSID_IE_, 0, 0, &frlen);	// wildcard SSID (len = 0)
		unsigned char ssidbuf[32];
		memset(ssidbuf, 0, 32);
		pbuf = set_ie(pbuf, _SSID_IE_, SSID_LEN, ssidbuf, &frlen);
    }
    else
#endif
    {
        if (!HIDDEN_AP && pmib->miscEntry.raku_only == 0)
            pbuf = set_ie(pbuf, _SSID_IE_, SSID_LEN, SSID, &frlen);
        else {
#ifdef CONFIG_RTL8196B_TLD
            pbuf = set_ie(pbuf, _SSID_IE_, 0, NULL, &frlen);
#else
            if (HIDDEN_AP == 2) {
                pbuf = set_ie(pbuf, _SSID_IE_, 0, NULL, &frlen);
            } else {
                unsigned char ssidbuf[32];
                memset(ssidbuf, 0, 32);
                pbuf = set_ie(pbuf, _SSID_IE_, SSID_LEN, ssidbuf, &frlen);
            }
#endif
        }
    }

	//supported rates...
#ifdef RTK_NL80211
		/*supported rates for wpa3 r3 use it from hapd*/
		if(priv->hapd_supp_rates_len){
			memcpy(pbuf, priv->hapd_supp_rates, priv->hapd_supp_rates_len);
			pbuf += priv->hapd_supp_rates_len;
			frlen += priv->hapd_supp_rates_len;
		}
#else
/*cfg p2p cfg p2p*/	
#ifdef P2P_SUPPORT
    if(rtk_p2p_is_enabled(priv))
        ret = get_bssrate_set(priv, _SUPPORTED_RATES_NO_CCK_, &pbssrate, &bssrate_len);   
    else
#endif
        ret = get_bssrate_set(priv, _SUPPORTEDRATES_IE_, &pbssrate, &bssrate_len);

    if (ret)  {
		u8 tmp[8];

		memcpy(tmp, pbssrate, bssrate_len);
#ifdef ENABLE_SAE_H2E
		if(support_wpa3(priv))
			construct_bss_mem_ie(priv, tmp, &bssrate_len);
#endif

		pbuf = set_ie(pbuf, _SUPPORTEDRATES_IE_, bssrate_len, tmp, &frlen);
    }
#endif

    //ds parameter set...
    val8 = pmib->dot11RFEntry.dot11channel;
#if defined(RTK_5G_SUPPORT) 
    if ( priv->pmib->dot11RFEntry.phyBandSelect & PHY_BAND_2G)
#endif			
        pbuf = set_ie(pbuf, _DSSET_IE_, 1, &val8, &frlen);
    priv->timoffset = frlen;
    //		pdesc = phw->tx_descB;	// by signin_beacon_desc
    // clear all bit
    //		memset(pdesc, 0, 32);	// by signin_beacon_desc

    //		pdesc->Dword4 |= set_desc(0x08 << TX_RtsRateSHIFT);	// by signin_beacon_desc
    //		pdesc->Dword8 = set_desc(get_physical_addr(priv, priv->beaconbuf, 128*sizeof(unsigned int), PCI_DMA_TODEVICE));	// by signin_beacon_desc

    // next pointer should point to a descriptor, david
    //set NextDescAddress
    //		pdesc->Dword10 = set_desc(get_physical_addr(priv, &phw->tx_descB[next_idx], sizeof(struct tx_desc), PCI_DMA_TODEVICE));	// by signin_beacon_desc

    if (priv->pmib->dot11StationConfigEntry.beacon_rate != 0xff) {
        if (priv->pmib->dot11StationConfigEntry.beacon_rate > 11)
            panic_printk("[WARN] Beacon rate is not legacy rate!\n");
        if ((priv->pmib->dot11RFEntry.phyBandSelect & PHY_BAND_5G) &&
                (priv->pmib->dot11StationConfigEntry.beacon_rate < 4)) {
            panic_printk("[WARN] Beacon rate is CCK in 5G! Correct to OFDM rate\n");
            priv->pmib->dot11StationConfigEntry.beacon_rate = 4;
        }
    }

#ifdef CONFIG_PCI_HCI
	if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE) {
	    update_beacon(priv);

	    // enable tx bcn
	    //#if defined(UNIVERSAL_REPEATER) || defined(MBSSID)
	    //		if (IS_ROOT_INTERFACE(priv))
	    //#endif
	    //			RTL_W8(BCN_CTRL, EN_BCN_FUNCTION);

#ifdef  CONFIG_WLAN_HAL
	    if (IS_HAL_CHIP(priv)) {
	        GET_HAL_INTERFACE(priv)->TxPollingHandler(priv, TXPOLL_BEACON_QUEUE);
	    } else
#endif
	    {		
	    // use hw beacon
#if defined(CONFIG_RTL_8812_SUPPORT) || defined(CONFIG_RTL_8723B_SUPPORT)
	    if(GET_CHIP_VER(priv) != VERSION_8812E && GET_CHIP_VER(priv) != VERSION_8723B)
#endif
	        RTL_W8(PCIE_CTRL_REG, BCNQ_POLL);
	    }

#ifndef DRVMAC_LB 
#ifdef  CONFIG_WLAN_HAL
	    if (IS_HAL_CHIP(priv)) {    
	        GET_HAL_INTERFACE(priv)->SetHwRegHandler(priv, HW_VAR_ENABLE_BEACON_DMA, NULL);
	    } else if(CONFIG_WLAN_NOT_HAL_EXIST)
#endif	
	    {//not HAL
	        RTL_W16(PCIE_CTRL_REG, RTL_R16(PCIE_CTRL_REG)& (~ BCNQSTOP) );
	    }
#endif
	}
#endif // CONFIG_PCI_HCI

#ifdef CONFIG_USB_HCI
	if (GET_HCI_TYPE(priv) == RTL_HCI_USB) {
#if defined(CONFIG_RTL_92C_SUPPORT) || (!defined(CONFIG_SUPPORT_USB_INT) || !defined(CONFIG_INTERRUPT_BASED_TXBCN))
	    if (!rtk_timer_pending(&priv->pshare->beacon_timer))
	        rtk_mod_timer(&priv->pshare->beacon_timer, jiffies);
#endif
	}
#endif // CONFIG_USB_HCI

#ifdef CONFIG_SDIO_HCI
	if (GET_HCI_TYPE(priv) == RTL_HCI_SDIO) {
	    if (!rtk_timer_pending(&priv->pshare->beacon_timer))
	        rtk_mod_timer(&priv->pshare->beacon_timer, jiffies +
	                    RTL_MILISECONDS_TO_JIFFIES(priv->pmib->dot11StationConfigEntry.dot11BeaconPeriod));
	}
#endif // CONFIG_SDIO_HCI

#if defined(STA_CONTROL_BAND_TRANSITION) && defined(DOT11K)
	// init dot11k_neighbor_report for band transistion
	init_band_trans_neighbor_report(priv);
#endif // STA_CONTROL_BAND_TRANSITION
priv->ext_stats.is_init_beacon_finished = 1;
}


#ifndef CONFIG_RTL_NEW_AUTOCH
static void setChannelScore(int number, unsigned int *val, int min, int max)
{
	int i=0, score;

	if (number > max)
		return;

	*(val + number) += 5;

	if (number > min) {
		for (i=number-1, score=4; i>=min && score; i--, score--) {
			*(val + i) += score;
		}
	}
	if (number < max) {
		for (i=number+1, score=4; i<=max && score; i++, score--) {
			*(val +i) += score;
		}
	}
}
#endif


#if defined(CONFIG_RTL_NEW_AUTOCH) && defined(SS_CH_LOAD_PROC)
static void record_SS_report(struct rtl8192cd_priv *priv)
{
	int i, j;
	priv->ch_ss_rpt_cnt = priv->site_survey->count;
	memset(priv->ch_ss_rpt, 0, (sizeof(struct ss_report)*MAX_BSS_NUM));	
	
	for(i=0; i<priv->site_survey->count ;i++){
		priv->ch_ss_rpt[i].channel = priv->site_survey->bss[i].channel;
		priv->ch_ss_rpt[i].is40M = ((priv->site_survey->bss[i].t_stamp[1] & BIT(1)) ? 1 : 0);
		priv->ch_ss_rpt[i].rssi	= priv->site_survey->bss[i].rssi;
		for (j=0; j<priv->available_chnl_num; j++) {
			if (priv->ch_ss_rpt[i].channel == priv->available_chnl[j]) {
				priv->ch_ss_rpt[i].fa_count = priv->chnl_ss_fa_count[j];
				priv->ch_ss_rpt[i].cca_count = priv->chnl_ss_cca_count[j];
				priv->ch_ss_rpt[i].ch_load = priv->chnl_ss_load[j];
			}
		}
	}
}
#endif

struct ap_info {
	unsigned char ch;
	unsigned char bw;
	unsigned char rssi;
};

#define MASK_CH(_ch, _begin, _end) if ((_ch) >= (_begin) && (_ch) < (_end)) score[_ch] = 0xffffffff;
int find_clean_channel(struct rtl8192cd_priv *priv, unsigned int begin, unsigned int end, unsigned int *score)
{
	struct bss_desc *pBss=NULL;
	int i, j, y, found;
	int ap_count[MAX_2G_CHANNEL_NUM];
	struct ap_info ap_rec[MAX_BSS_NUM];
	unsigned int ap_rec_num = 0;
#ifdef CTC_2G_ACS
	unsigned int ap_1_6_11 = 0;
#endif

	memset(ap_count, 0, sizeof(ap_count));
	memset(ap_rec, 0, sizeof(ap_rec));
	
	for (y=begin; y<end; y++) {
		score[y] = priv->chnl_ss_fa_count[y];
	}
	
	for (i=0; i<priv->site_survey->count; i++) {
		pBss = &priv->site_survey->bss[i];

		ap_rec[ap_rec_num].ch = pBss->channel;
		if ((pBss->t_stamp[1] & 0x6) == 0) ap_rec[ap_rec_num].bw = 0;
		else if ((pBss->t_stamp[1] & 0x4) == 0) ap_rec[ap_rec_num].bw = 1;
		else ap_rec[ap_rec_num].bw = 2;
		ap_rec[ap_rec_num++].rssi = pBss->rssi;

		if (pBss->rssi > 15) {
			for (y=begin; y<end; y++) {
				if (pBss->channel == priv->available_chnl[y]) {
					ap_count[y]++;
					if ((pBss->t_stamp[1] & 0x6) == 0) {  // 20M
						for (j=-2; j<=2; j++)
							MASK_CH(y+j, begin, end);
					}	
					else if ((pBss->t_stamp[1] & 0x4) == 0) {  // 40M upper
						for (j=-2; j<=6; j++)
							MASK_CH(y+j, begin, end);
					}	
					else {  // 40M lower
						for (j=-6; j<=2; j++)
							MASK_CH(y+j, begin, end);
					}	
				}
			}
		}
	}

#ifdef CTC_2G_ACS
	if ((priv->pmib->dot11RFEntry.phyBandSelect & PHY_BAND_2G) && (priv->pmib->dot11nConfigEntry.dot11nUse40M == CHANNEL_WIDTH_20)) {
		for (i = 0; i < 13; i++) {
			if (ap_count[i])
				ap_1_6_11 |= BIT(i);
		}

		if (ap_count[0] > 1) // CH1
			ap_1_6_11 &= ~BIT(0);
		if (ap_count[5] > 1) // CH6
			ap_1_6_11 &= ~BIT(5);
		if (ap_count[10] > 1) // CH11
			ap_1_6_11 &= ~BIT(10);
	}
#endif /* CTC_2G_ACS */

	if ((priv->pmib->dot11BssType.net_work_type & WIRELESS_11N)
		&& priv->pshare->is_40m_bw) {
		for (y=begin; y<end; y++)
			if (priv->available_chnl[y] == 14)
				score[y] = 0xffffffff;		// mask chan14
	}

	if (priv->pmib->dot11RFEntry.disable_ch1213) {
		for (y=begin; y<end; y++) {
			int ch = priv->available_chnl[y];
			if ((ch == 12) || (ch == 13))
				score[y] = 0xffffffff;
		}
	}

	if (((priv->pmib->dot11StationConfigEntry.dot11RegDomain == DOMAIN_GLOBAL) ||
			(priv->pmib->dot11StationConfigEntry.dot11RegDomain == DOMAIN_WORLD_WIDE)) &&
		 (end >= 11) && (end < 14)) {
		score[13] = 0xffffffff;	// mask chan14
		score[12] = 0xffffffff; // mask chan13
		score[11] = 0xffffffff; // mask chan12
	}

#ifdef ACS_DEBUG_INFO
	for (y=begin; y<end; y++) {
		if (score[y] == 0xffffffff)
			printk("ch %d: ap_count: %d, score: 0xffffffff ", priv->available_chnl[y], ap_count[y]);
		else
			printk("ch %d: ap_count: %d, score: %d ", priv->available_chnl[y], ap_count[y], score[y]);

		for (i=0; i<ap_rec_num; i++) {
			if (priv->available_chnl[y] == ap_rec[i].ch) {
				printk("%s:%d ", ap_rec[i].bw==0?"N":(ap_rec[i].bw==1?"U":"L"), ap_rec[i].rssi);
			}
		}
		printk("\n");
	}
#endif

#ifdef CTC_2G_ACS
	if (ap_1_6_11 == (BIT(0) | BIT(5) | BIT(10))) {
#ifdef ACS_DEBUG_INFO
		printk("ap_1_6_11 HIT\n");
#endif
		for (y = begin; y < end; y++)
			score[y] = priv->chnl_ss_fa_count[y] + priv->chnl_ss_fa_count[10];
		score[10] = priv->chnl_ss_fa_count[10];
		return 1;
	} else if (ap_1_6_11 == (BIT(5) | BIT(10))) {
#ifdef ACS_DEBUG_INFO
		printk("ap_6_11 HIT\n");
#endif
		for (y = begin; y < end; y++)
			score[y] = priv->chnl_ss_fa_count[y] + priv->chnl_ss_fa_count[0];
		score[0] = priv->chnl_ss_fa_count[0];
		return 1;
	} else if (ap_1_6_11 == (BIT(0) | BIT(10))) {
#ifdef ACS_DEBUG_INFO
		printk("ap_1_11 HIT\n");
#endif
		for (y = begin; y < end; y++)
			score[y] = priv->chnl_ss_fa_count[y] + priv->chnl_ss_fa_count[5];
		score[5] = priv->chnl_ss_fa_count[5];
		return 1;
	}
#endif /* CTC_2G_ACS */
	
	for (y=begin; y<end; y++) {
		found = 1;
		if (priv->pmib->dot11nConfigEntry.dot11nUse40M == CHANNEL_WIDTH_40)
			i = 4;
		else
			i = 2;

		for (j=-i; j<=i; j++) {
			if ((y+j >= begin) && (y+j < end)) {
				if (score[y+j] == 0xffffffff) {
					found = 0;
					break;
				}
			}
		}

		if (found) 
			return 1;
	}

	return 0;
}

int selectClearChannel(struct rtl8192cd_priv *priv)
{
	static unsigned int score2G[MAX_2G_CHANNEL_NUM], score5G[MAX_5G_CHANNEL_NUM];
	unsigned int score[MAX_BSS_NUM], scoreSum[MAX_BSS_NUM], use_nhm = 0;
	unsigned int minScore=0xffffffff;
	unsigned int tmpScore, tmpIdx=0;
	unsigned int traffic_check 			= 0;
	unsigned int fa_count_weighting = 1;
	int i, j, idx=0, idx_2G_end=-1, idx_5G_begin=-1, minChan=0;
	struct bss_desc *pBss=NULL;
	int channel_index=0;
	unsigned int max_score=0;
	
	//move here for function use
	unsigned int y, ch_begin=0, ch_end= priv->available_chnl_num;
	unsigned int do_ap_check = 1, ap_ratio = 0;

#ifdef ACS_DEBUG_INFO
	char tmpbuf[400];
	int len=0;
#endif

	memset(score2G, '\0', sizeof(score2G));
	memset(score5G, '\0', sizeof(score5G));
	memset(scoreSum, '\0', sizeof(scoreSum));
	
	for (i=0; i<priv->available_chnl_num; i++) {
		if (priv->available_chnl[i] <= 14)
			idx_2G_end = i;
		else
			break;
	}

	for (i=0; i<priv->available_chnl_num; i++) {
		if (priv->available_chnl[i] > 14) {
			idx_5G_begin = i;
			break;
		}
	}

#ifdef ACS_DEBUG_INFO//for debug
	for (i=0; i<priv->site_survey->count; i++) {
		int bw;
		pBss = &priv->site_survey->bss[i];
#ifdef RTK_AC_SUPPORT			
		if (pBss->t_stamp[1] & (BSS_BW_MASK << BSS_BW_SHIFT)) {
			int tmp = (pBss->t_stamp[1] >> BSS_BW_SHIFT) & BSS_BW_MASK;
			switch (tmp) {
			case 0:
				bw = 20;
				break;
			case 1:
				bw = 40;
				break;
			case 2:
				bw = 80;
				break;
			case 3:
				bw = 160;
				break;
			case 4:
				bw = 10;
				break;
			case 5:
				bw = 5;
				break;
			}
		}
		else
#endif
		if (pBss->t_stamp[1] & BIT(1))
			bw = 40;
		else
			bw = 20;

		printk("[%3d] MAC %02x%02x%02x%02x%02x%02x ch %3d %3dM mode\n",
			i, pBss->bssid[0], pBss->bssid[1], pBss->bssid[2], pBss->bssid[3], pBss->bssid[4], pBss->bssid[5],
			pBss->channel, bw);
	}
#endif

#ifndef CONFIG_RTL_NEW_AUTOCH
	for (i=0; i<priv->site_survey->count; i++) {
		pBss = &priv->site_survey->bss[i];
		for (idx=0; idx<priv->available_chnl_num; idx++) {
			if (pBss->channel == priv->available_chnl[idx]) {
				if (pBss->channel <= 14)
					setChannelScore(idx, score2G, 0, MAX_2G_CHANNEL_NUM-1);
				else
					score5G[idx - idx_5G_begin] += 5;
				break;
			}
		}
	}
#endif

	if (idx_2G_end >= 0)
		for (i=0; i<=idx_2G_end; i++)
			score[i] = score2G[i];
	if (idx_5G_begin >= 0)
		for (i=idx_5G_begin; i<priv->available_chnl_num; i++)
			score[i] = score5G[i - idx_5G_begin];
		
#ifdef CONFIG_RTL_NEW_AUTOCH
	struct acs_info *acs = &priv->pshare->acs_info;

	{				
		if (idx_2G_end >= 0) 
			ch_end = idx_2G_end+1;
		if (idx_5G_begin >= 0)  
			ch_begin = idx_5G_begin;

#ifdef ACS_DEBUG_INFO//for debug
		printk("\n");
		for (y=ch_begin; y<ch_end; y++)
			printk("1. init: chnl[%d] 20M_rx[%d] 40M_rx[%d] fa_cnt[%d] score[%d]\n",
				priv->available_chnl[y], 
				priv->chnl_ss_mac_rx_count[y], 
				priv->chnl_ss_mac_rx_count_40M[y],
				priv->chnl_ss_fa_count[y],
				score[y]);
		printk("\n");
#endif	

		if (priv->pmib->dot11RFEntry.acs_type == 1) {
			unsigned int tmp_score[MAX_BSS_NUM];
			memcpy(tmp_score, score, sizeof(score));
			if (find_clean_channel(priv, ch_begin, ch_end, tmp_score)) {
#ifdef ACS_DEBUG_INFO
				//memcpy(score, tmp_score, sizeof(score));
				printk("!! Found clean channel, select minimum FA channel\n");
#endif
			} else {
#ifdef ACS_DEBUG_INFO
				printk("!! Not found clean channel, use NHM algorithm\n");
#endif
				use_nhm = 1;
			}
			for (y=ch_begin; y<ch_end; y++) {
				for (i=0; i<10; i++) {
					unsigned int val32 = acs->nhm_cnt[y][i];
					for (j=0; j<i; j++)
						val32 *= 3;
					score[y] += val32;
				}

#ifdef ACS_DEBUG_INFO				
				printk("nhm_cnt_%d: H<-[ %3d %3d %3d %3d %3d %3d %3d %3d %3d %3d]->L, score: %d\n", 
					priv->available_chnl[y], 
					acs->nhm_cnt[y][9], acs->nhm_cnt[y][8], acs->nhm_cnt[y][7], 
					acs->nhm_cnt[y][6], acs->nhm_cnt[y][5], acs->nhm_cnt[y][4],
					acs->nhm_cnt[y][3], acs->nhm_cnt[y][2], acs->nhm_cnt[y][1],
					acs->nhm_cnt[y][0], score[y]);
#endif
			}

			if (!use_nhm)
				memcpy(score, tmp_score, sizeof(score));
			
#ifdef ACS_DEBUG_INFO
			printk("use_nhm = %d\n", use_nhm);
			for (y=ch_begin; y<ch_end; y++) {
				printk("score[%d]: %d\n", priv->available_chnl[y], score[y]);
			}
#endif

			goto choose_ch;
		}
#ifdef NHM_ACS2_SUPPORT
		else if (priv->pmib->dot11RFEntry.acs_type==2) 
		{
			ACSDEBUG("[CH:%d] [BW:%d] [Use40M:%d] [RF0x18:%d]\n", priv->site_survey->ss_channel, priv->pshare->CurrentChannelBW, priv->pmib->dot11nConfigEntry.dot11nUse40M, PHY_QueryRFReg(priv, RF_PATH_A, 0x18, 0xff, 1));

			RTL_W8(0xa0a, priv->cck_th_backup); // restore "cck th"

			goto choose_ch;
		}
#endif
		/*
		 * 	For each channel, weighting behind channels with MAC RX counter
		 * 	For each channel, weighting the channel with FA counter
		 */
		if (priv->pmib->dot11RFEntry.acs_type != 3 && priv->pmib->dot11RFEntry.acs_type != 4 && priv->pmib->dot11RFEntry.acs_type != 5) {
		for (y=ch_begin; y<ch_end; y++) {
			score[y] += 8 * priv->chnl_ss_mac_rx_count[y];
			if (priv->chnl_ss_mac_rx_count[y] > 30)
				do_ap_check = 0;
			if( priv->chnl_ss_mac_rx_count[y] > MAC_RX_COUNT_THRESHOLD )
				traffic_check = 1;
			
#ifdef RTK_5G_SUPPORT
			if (priv->pmib->dot11RFEntry.phyBandSelect == PHY_BAND_2G)
#endif
			{
				if ((int)(y-4) >= (int)ch_begin)
					score[y-4] += 2 * priv->chnl_ss_mac_rx_count[y];				
				if ((int)(y-3) >= (int)ch_begin)
					score[y-3] += 8 * priv->chnl_ss_mac_rx_count[y];
				if ((int)(y-2) >= (int)ch_begin)
					score[y-2] += 8 * priv->chnl_ss_mac_rx_count[y];
				if ((int)(y-1) >= (int)ch_begin)
					score[y-1] += 10 * priv->chnl_ss_mac_rx_count[y];
				if ((int)(y+1) < (int)ch_end)
					score[y+1] += 10 * priv->chnl_ss_mac_rx_count[y];
				if ((int)(y+2) < (int)ch_end)
					score[y+2] += 8 * priv->chnl_ss_mac_rx_count[y];
				if ((int)(y+3) < (int)ch_end)
					score[y+3] += 8 * priv->chnl_ss_mac_rx_count[y];
				if ((int)(y+4) < (int)ch_end)
					score[y+4] += 2 * priv->chnl_ss_mac_rx_count[y];
			}

#ifdef SS_CH_LOAD_PROC
			//this is for CH_LOAD caculation
			if( priv->chnl_ss_cca_count[y] > priv->chnl_ss_fa_count[y])
				priv->chnl_ss_cca_count[y]-= priv->chnl_ss_fa_count[y];
			else
				priv->chnl_ss_cca_count[y] = 0;
#endif				
		}

#ifdef ACS_DEBUG_INFO//for debug
		printk("\n");
		for (y=ch_begin; y<ch_end; y++)
			printk("2. after 20M check: chnl[%d] score[%d]\n",priv->available_chnl[y], score[y]);
		printk("\n");
#endif	

		for (y=ch_begin; y<ch_end; y++) {
			if (priv->chnl_ss_mac_rx_count_40M[y]) {
				score[y] += 5 * priv->chnl_ss_mac_rx_count_40M[y];
				if (priv->chnl_ss_mac_rx_count_40M[y] > 30)
					do_ap_check = 0;
				if( priv->chnl_ss_mac_rx_count_40M[y] > MAC_RX_COUNT_THRESHOLD )
					traffic_check = 1;
				
#ifdef RTK_5G_SUPPORT
				if (priv->pmib->dot11RFEntry.phyBandSelect == PHY_BAND_2G)
#endif
				{
					if ((int)(y-6) >= (int)ch_begin)
						score[y-6] += 1 * priv->chnl_ss_mac_rx_count_40M[y];
					if ((int)(y-5) >= (int)ch_begin)
						score[y-5] += 4 * priv->chnl_ss_mac_rx_count_40M[y];
					if ((int)(y-4) >= (int)ch_begin)
						score[y-4] += 4 * priv->chnl_ss_mac_rx_count_40M[y];
					if ((int)(y-3) >= (int)ch_begin)
						score[y-3] += 5 * priv->chnl_ss_mac_rx_count_40M[y];
					if ((int)(y-2) >= (int)ch_begin)
						score[y-2] += (5 * priv->chnl_ss_mac_rx_count_40M[y])/2;
					if ((int)(y-1) >= (int)ch_begin)
						score[y-1] += 5 * priv->chnl_ss_mac_rx_count_40M[y];
					if ((int)(y+1) < (int)ch_end)
						score[y+1] += 5 * priv->chnl_ss_mac_rx_count_40M[y];
					if ((int)(y+2) < (int)ch_end)
						score[y+2] += (5 * priv->chnl_ss_mac_rx_count_40M[y])/2;
					if ((int)(y+3) < (int)ch_end)
						score[y+3] += 5 * priv->chnl_ss_mac_rx_count_40M[y];
					if ((int)(y+4) < (int)ch_end)
						score[y+4] += 4 * priv->chnl_ss_mac_rx_count_40M[y];
					if ((int)(y+5) < (int)ch_end)
						score[y+5] += 4 * priv->chnl_ss_mac_rx_count_40M[y];
					if ((int)(y+6) < (int)ch_end)
						score[y+6] += 1 * priv->chnl_ss_mac_rx_count_40M[y];
				}
			}
		}

#ifdef ACS_DEBUG_INFO//for debug
		printk("\n");
		for (y=ch_begin; y<ch_end; y++)
			printk("3. after 40M check: chnl[%d] score[%d]\n",priv->available_chnl[y], score[y]);
		printk("\n");
		printk("4. do_ap_check=%d traffic_check=%d\n", do_ap_check, traffic_check);
		printk("\n");
#endif

		if( traffic_check == 0)
			fa_count_weighting = 5;
		else
			fa_count_weighting = 1;

		for (y=ch_begin; y<ch_end; y++) {
			score[y] += fa_count_weighting * priv->chnl_ss_fa_count[y];
		}

#ifdef ACS_DEBUG_INFO//for debug
		printk("\n");
		for (y=ch_begin; y<ch_end; y++)
			printk("5. after fa check: chnl[%d] score[%d]\n",priv->available_chnl[y], score[y]);
		printk("\n");
#endif			
		} /* if acs_type != 3 */

		if (do_ap_check) {
			for (i=0; i<priv->site_survey->count; i++) {				
				pBss = &priv->site_survey->bss[i];
				for (y=ch_begin; y<ch_end; y++) {
					if (pBss->channel == priv->available_chnl[y]) {
						if ((priv->pmib->dot11RFEntry.acs_type == 4) || (priv->pmib->dot11RFEntry.acs_type == 5)) {
							score[y] += 100;	
							if (((int)y+1)<=(int)10)
								score[y+1] += 50;		
							if (((int)y-1)>=(int)0)
								score[y-1] += 50;		
							if (((int)y+2)<=(int)10)
								score[y+2] += 10;		
							if (((int)y-2)>=(int)0)
								score[y-2] += 10;		
						} else {																		
						if (pBss->channel <= 14) {
#ifdef ACS_DEBUG_INFO//for debug
						printk("\n");
						printk("chnl[%d] has ap rssi=%d bw[0x%02x]\n",
							pBss->channel, pBss->rssi, pBss->t_stamp[1]);
						printk("\n");
#endif
							if (pBss->rssi > 60)
								ap_ratio = 4;
							else if (pBss->rssi > 35)
								ap_ratio = 2;
							else
								ap_ratio = 1;
							
							if ((pBss->t_stamp[1] & 0x6) == 0) {
								score[y] += 50 * ap_ratio;
								if ((int)(y-4) >= (int)ch_begin)
									score[y-4] += 10 * ap_ratio;
								if ((int)(y-3) >= (int)ch_begin)
									score[y-3] += 20 * ap_ratio;
								if ((int)(y-2) >= (int)ch_begin)
									score[y-2] += 30 * ap_ratio;
								if ((int)(y-1) >= (int)ch_begin)
									score[y-1] += 40 * ap_ratio;
								if ((int)(y+1) < (int)ch_end)
									score[y+1] += 40 * ap_ratio;
								if ((int)(y+2) < (int)ch_end)
									score[y+2] += 30 * ap_ratio;
								if ((int)(y+3) < (int)ch_end)
									score[y+3] += 20 * ap_ratio;
								if ((int)(y+4) < (int)ch_end)
									score[y+4] += 10 * ap_ratio;
							}	
							else if ((pBss->t_stamp[1] & 0x4) == 0) {
								score[y] += 50 * ap_ratio;
								if ((int)(y-3) >= (int)ch_begin)
									score[y-3] += 20 * ap_ratio;
								if ((int)(y-2) >= (int)ch_begin)
									score[y-2] += 30 * ap_ratio;
								if ((int)(y-1) >= (int)ch_begin)
									score[y-1] += 40 * ap_ratio;
								if ((int)(y+1) < (int)ch_end)
									score[y+1] += 50 * ap_ratio;
								if ((int)(y+2) < (int)ch_end)
									score[y+2] += 50 * ap_ratio;
								if ((int)(y+3) < (int)ch_end)
									score[y+3] += 50 * ap_ratio;
								if ((int)(y+4) < (int)ch_end)
									score[y+4] += 50 * ap_ratio;
								if ((int)(y+5) < (int)ch_end)
									score[y+5] += 40 * ap_ratio;
								if ((int)(y+6) < (int)ch_end)
									score[y+6] += 30 * ap_ratio;
								if ((int)(y+7) < (int)ch_end)
									score[y+7] += 20 * ap_ratio;	
							}	
							else {
								score[y] += 50 * ap_ratio;
								if ((int)(y-7) >= (int)ch_begin)
									score[y-7] += 20 * ap_ratio;
								if ((int)(y-6) >= (int)ch_begin)
									score[y-6] += 30 * ap_ratio;
								if ((int)(y-5) >= (int)ch_begin)
									score[y-5] += 40 * ap_ratio;
								if ((int)(y-4) >= (int)ch_begin)
									score[y-4] += 50 * ap_ratio;
								if ((int)(y-3) >= (int)ch_begin)
									score[y-3] += 50 * ap_ratio;
								if ((int)(y-2) >= (int)ch_begin)
									score[y-2] += 50 * ap_ratio;
								if ((int)(y-1) >= (int)ch_begin)
									score[y-1] += 50 * ap_ratio;
								if ((int)(y+1) < (int)ch_end)
									score[y+1] += 40 * ap_ratio;
								if ((int)(y+2) < (int)ch_end)
									score[y+2] += 30 * ap_ratio;
								if ((int)(y+3) < (int)ch_end)
									score[y+3] += 20 * ap_ratio;
							}	
						}	
						else {
							if ((pBss->t_stamp[1] & 0x6) == 0) {
								score[y] += 500;
							}
							else if ((pBss->t_stamp[1] & 0x4) == 0) {
								score[y] += 500;
								if ((int)(y+1) < (int)ch_end)
									score[y+1] += 500;
							}
							else {	
								score[y] += 500;
								if ((int)(y-1) >= (int)ch_begin)
									score[y-1] += 500;
							}
						}
						}
						break;
					}
				}
			}
		}

#ifdef ACS_DEBUG_INFO//for debug
		printk("\n");
		for (y=ch_begin; y<ch_end; y++)
			printk("6. after ap check: chnl[%d]:%d\n", priv->available_chnl[y],score[y]);
		printk("\n");
#endif		

#ifdef 	SS_CH_LOAD_PROC

		// caculate noise level -- suggested by wilson
		for (y=ch_begin; y<ch_end; y++)  {
			int fa_lv=0, cca_lv=0;
			if (priv->chnl_ss_fa_count[y]>1000) {
				fa_lv = 100;
			} else if (priv->chnl_ss_fa_count[y]>500) {
				fa_lv = 34 * (priv->chnl_ss_fa_count[y]-500) / 500 + 66;
			} else if (priv->chnl_ss_fa_count[y]>200) {
				fa_lv = 33 * (priv->chnl_ss_fa_count[y] - 200) / 300 + 33;
			} else if (priv->chnl_ss_fa_count[y]>100) {
				fa_lv = 18 * (priv->chnl_ss_fa_count[y] - 100) / 100 + 15;
			} else {
				fa_lv = 15 * priv->chnl_ss_fa_count[y] / 100;
			} 
			if (priv->chnl_ss_cca_count[y]>400) {
				cca_lv = 100;
			} else if (priv->chnl_ss_cca_count[y]>200) {
				cca_lv = 34 * (priv->chnl_ss_cca_count[y] - 200) / 200 + 66;
			} else if (priv->chnl_ss_cca_count[y]>80) {
				cca_lv = 33 * (priv->chnl_ss_cca_count[y] - 80) / 120 + 33;
			} else if (priv->chnl_ss_cca_count[y]>40) {
				cca_lv = 18 * (priv->chnl_ss_cca_count[y] - 40) / 40 + 15;
			} else {
				cca_lv = 15 * priv->chnl_ss_cca_count[y] / 40;
			}

			priv->chnl_ss_load[y] = (((fa_lv > cca_lv)? fa_lv : cca_lv)*75+((score[y]>100)?100:score[y])*25)/100;

			DEBUG_INFO("ch:%d f=%d , c=%d , fl=%d, cl=%d, sc=%d, cu=%d\n", 
					priv->available_chnl[y],
					priv->chnl_ss_fa_count[y], 
					priv->chnl_ss_cca_count[y],
					fa_lv, 
					cca_lv,
					score[y],					
					priv->chnl_ss_load[y]);
			
		}		
#endif		
	}
#endif

choose_ch:

#ifdef DFS
	if (priv->pmib->dot11RFEntry.acs_type != 3 && priv->pmib->dot11StationConfigEntry.dot11RegDomain != DOMAIN_MX) {
		// heavy weighted DFS channel
		if (idx_5G_begin >= 0){
			for (i=idx_5G_begin; i<priv->available_chnl_num; i++) {
				if (!priv->pmib->dot11DFSEntry.disable_DFS && is_DFS_channel(priv, priv->available_chnl[i]) 
				&& (score[i]!= 0xffffffff)){
					score[i] += priv->pshare->rf_ft_var.dfs_acs_offset;
				}
			}
		}
	}
#endif
	if(priv->pmib->dot11StationConfigEntry.dot11RegDomain != DOMAIN_MX){
		// heavy weighted CH144 since older device may not support
		for (i=idx_5G_begin; i<priv->available_chnl_num; i++) {
				if (priv->available_chnl[i] == 144
				&& (score[i]!= 0xffffffff)){
						score[i] += 1600; 
						break;
			}
		}
	}

	if (idx_5G_begin >= 0){
		for (i=idx_5G_begin; i<priv->available_chnl_num; i++) {
			if (priv->available_chnl[i]!=60 && (score[i]!= 0xffffffff)){
				score[i] += priv->pshare->rf_ft_var.acs_not60_inc; 
			}
		}
	}

//prevent Auto Channel selecting wrong channel in 40M mode-----------------
	if ((priv->pmib->dot11BssType.net_work_type & WIRELESS_11N)
		&& priv->pshare->is_40m_bw) {
#if 0
		if (GET_MIB(priv)->dot11nConfigEntry.dot11n2ndChOffset == 1) {
			//Upper Primary Channel, cannot select the two lowest channels
			if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11G) {
				score[0] = 0xffffffff;
				score[1] = 0xffffffff;
				score[2] = 0xffffffff;
				score[3] = 0xffffffff;
				score[4] = 0xffffffff;

				score[13] = 0xffffffff;
				score[12] = 0xffffffff;
				score[11] = 0xffffffff;
			}

//			if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11A) {
//				score[idx_5G_begin] = 0xffffffff;
//				score[idx_5G_begin + 1] = 0xffffffff;
//			}
		}
		else if (GET_MIB(priv)->dot11nConfigEntry.dot11n2ndChOffset == 2) {
			//Lower Primary Channel, cannot select the two highest channels
			if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11G) {
				score[0] = 0xffffffff;
				score[1] = 0xffffffff;
				score[2] = 0xffffffff;

				score[13] = 0xffffffff;
				score[12] = 0xffffffff;
				score[11] = 0xffffffff;
				score[10] = 0xffffffff;
				score[9] = 0xffffffff;
			}

//			if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11A) {
//				score[priv->available_chnl_num - 2] = 0xffffffff;
//				score[priv->available_chnl_num - 1] = 0xffffffff;
//			}
		}
#endif
		for (i=0; i<=idx_2G_end; ++i)
			if (priv->available_chnl[i] == 14)
				score[i] = 0xffffffff;		// mask chan14

#ifdef RTK_5G_SUPPORT
		if (idx_5G_begin >= 0) {
			for (i=idx_5G_begin; i<priv->available_chnl_num; i++) {
				int ch = priv->available_chnl[i];
				if(priv->available_chnl[i] > 144) 
					--ch;
				if((ch%4) ||  ch == 164 )	//mask  ch 165, ch 184...
					score[i] = 0xffffffff;
				if(ch==140) 				//mask ch 140 if ch 144 not exist 
				{
					if(i < priv->available_chnl_num-1)
					{
						if(priv->available_chnl[i+1] != 144)
							score[i] = 0xffffffff;
					}
					else
						score[i] = 0xffffffff;
				}
			}
		}
#endif

	}
	
	#ifdef RTK_5G_SUPPORT
	int ch_val=0;
	int ch_bitmap_idx=0;		
	if(priv->pmib->miscEntry.autoch_5gmask){
		if (idx_5G_begin >= 0) {
			for (i=idx_5G_begin; i<priv->available_chnl_num; i++) {
				
				ch_val = priv->available_chnl[i];					
				ch_bitmap_idx = get_ch_bitmap_idx(priv, ch_val);
				
				//panic_printk("ch_val[%d] , ch_bitmap_idx[%d] \n",ch_val,ch_bitmap_idx);
				if(priv->pmib->miscEntry.autoch_5gmask & (1<<ch_bitmap_idx)){
					//panic_printk("i[%d] , ch[%d],score=0xffffff\n",i,ch_val);
					score[i] = 0xffffffff;						
				}										
			}
		}
	}
	#endif
		
	if (priv->pmib->dot11RFEntry.disable_ch1213) {
		for (i=0; i<=idx_2G_end; ++i) {
			int ch = priv->available_chnl[i];
			if ((ch == 12) || (ch == 13))
				score[i] = 0xffffffff;
		}
	}

	if (((priv->pmib->dot11StationConfigEntry.dot11RegDomain == DOMAIN_GLOBAL) ||
			(priv->pmib->dot11StationConfigEntry.dot11RegDomain == DOMAIN_WORLD_WIDE)) &&
		 (idx_2G_end >= 11) && (idx_2G_end < 14)) {
		score[13] = 0xffffffff;	// mask chan14
		score[12] = 0xffffffff; // mask chan13
		score[11] = 0xffffffff; // mask chan12
	}
	
#ifdef RTK_5G_SUPPORT
//it does not support  band 1 with bandwidth 80M in CHINA, filter channel of band 1 if country code is CN
#if defined(DOT11D) || defined(DOT11H) || defined(DOT11K)
	if ( (priv->pmib->dot11RFEntry.phyBandSelect == PHY_BAND_5G) && (priv->pmib->dot11nConfigEntry.dot11nUse40M == CHANNEL_WIDTH_80) && (priv->pshare->rf_ft_var.cn_acs_iot_enable))
		if((COUNTRY_CODE_ENABLED || priv->pmib->dot11hTPCEntry.tpc_enable) && (!memcmp(priv->pmib->dot11dCountry.dot11CountryString, "CN", 2)))
			if (idx_5G_begin >= 0) {
				for (i=idx_5G_begin; i<priv->available_chnl_num; i++) {
					int ch = priv->available_chnl[i];
					if(is_which_band_channel(ch, PHY_BAND_5G_1)) 
						score[i] = 0xffffffff;
				}
			}
#endif
#endif
	
//------------------------------------------------------------------

    if(priv->auto_channel_use_score)
    {
    	for(i=0; i<priv->available_chnl_num; i++)
    	{
    		if(priv->chnl_ss_score[i] == 100)
    			score[i] = 0xffffffff;
    		else
    			score[i] = priv->chnl_ss_score[i];
    	}
    	priv->auto_channel_use_score = 0;
    }

#ifdef ACS_DEBUG_INFO
	tmpbuf[0] = '\0';
	for (i=0; i<priv->available_chnl_num; i++) {
		len += snprintf(tmpbuf+len, sizeof(tmpbuf)-len, "ch%d:%u ", priv->available_chnl[i], score[i]);
	}
	strncat(tmpbuf, "\n", sizeof(tmpbuf) - strlen(tmpbuf) - 1);
	panic_printk("%s", tmpbuf);

#endif
	if(priv->ss_req_ongoing
#ifdef RTK_MESH_SIMPLE_CSA
		&& priv->mesh_CSA_state == MESH_CSA_NONE
#endif
	) //skip choosing channel process
		goto cal_and_record_score;

	if ( (priv->pmib->dot11RFEntry.phyBandSelect == PHY_BAND_5G)
		&& (priv->pmib->dot11nConfigEntry.dot11nUse40M == CHANNEL_WIDTH_80)
		&& (priv->pmib->dot11RFEntry.acs_type != 3))
	{
#ifdef NHM_ACS2_SUPPORT
		if (priv->pmib->dot11RFEntry.acs_type == 2) {
			idx = selectClearChannel_5g_acs2(priv);
		}
		else
#endif
		if(!priv->pmib->miscEntry.autoch_3664157_enable)
		{
		for (i=0; i<priv->available_chnl_num; i++) {
			if (is80MChannel(priv->available_chnl, priv->available_chnl_num, priv->available_chnl[i])) {
				if(priv->pmib->dot11StationConfigEntry.dot11RegDomain == DOMAIN_MX &&
				   !is_DFS_channel(priv, priv->available_chnl[i])) //choose DFS channel in DOMAIN_MX
				   continue;
				tmpScore = 0;
				for (j=0; j<4; j++) {
					if ((tmpScore != 0xffffffff) && (score[i+j] != 0xffffffff))
						tmpScore += score[i+j];
					else
						tmpScore = 0xffffffff;
				}
				tmpScore = tmpScore / 4;
				if (minScore > tmpScore) {
					minScore = tmpScore;

					tmpScore = 0xffffffff;
					for (j=0; j<4; j++) {
						if(priv->pmib->dot11StationConfigEntry.dot11RegDomain == DOMAIN_MX){
							if ((score[i+j] < tmpScore) && (priv->available_chnl[i+j] != 144)) {
								tmpScore = score[i+j];
								tmpIdx = i+j;
							}
						}
						else{
							if (score[i+j] < tmpScore) {
								tmpScore = score[i+j];
								tmpIdx = i+j;
							}
						}
					}

						idx = tmpIdx;
					}
					i += 3;
				}
			}
			if (priv->pmib->dot11StationConfigEntry.dot11RegDomain == DOMAIN_MX && minScore == 0xffffffff) {
				//there is no DFS channels available
				for (i=0; i<priv->available_chnl_num; i++) {
					if (is80MChannel(priv->available_chnl, priv->available_chnl_num, priv->available_chnl[i]) && !is_DFS_channel(priv, priv->available_chnl[i]) ) {
						tmpScore = 0;
						for (j=0; j<4; j++) {
							if ((tmpScore != 0xffffffff) && (score[i+j] != 0xffffffff))
								tmpScore += score[i+j];
							else
								tmpScore = 0xffffffff;
						}
						tmpScore = tmpScore / 4;
						if (minScore > tmpScore) {
							minScore = tmpScore;

							tmpScore = 0xffffffff;
							for (j=0; j<4; j++) {
								if ((score[i+j] < tmpScore) && (priv->available_chnl[i+j] != 144)) {
									tmpScore = score[i+j];
									tmpIdx = i+j;
								}
							}

							idx = tmpIdx;
						}
						i += 3;
					}
				}
			}
			if (minScore == 0xffffffff) {
				// there is no 80M channels
				priv->pshare->is_40m_bw = CHANNEL_WIDTH_20;
				for (i=0; i<priv->available_chnl_num; i++) {
					if(priv->pmib->dot11StationConfigEntry.dot11RegDomain == DOMAIN_MX && priv->available_chnl[i] == 144)
						continue;
					if (score[i] < minScore) {
						minScore = score[i];
						idx = i;
					}
				}
			}
		}
		else
		{
			for (i=0; i<priv->available_chnl_num; i++) {
				if(priv->available_chnl[i] == 36 || priv->available_chnl[i] == 64 || priv->available_chnl[i] == 157)
				{
					if (is80MChannel(priv->available_chnl, priv->available_chnl_num, priv->available_chnl[i])) {
						tmpScore = 0;
						int begin = 0, end = 0;
						if(priv->available_chnl[i] == 36)
						{
							begin = 0;
							end = 3;
						}
						if(priv->available_chnl[i] == 64)
						{
							begin = -3;
							end = 0;
						}
						if(priv->available_chnl[i] == 157)
						{
							begin = -2;
							end = 1;
						}
						for (j=begin; j<=end; j++) {
							if ((tmpScore != 0xffffffff) && (score[i+j] != 0xffffffff))
								tmpScore += score[i+j];
							else
								tmpScore = 0xffffffff;
						}
						tmpScore = tmpScore / 4;
						if (minScore > tmpScore) {
							minScore = tmpScore;
							idx = i;
						}
					}
				}
			}
			if (minScore == 0xffffffff) {
				// there is no 80M channels
				priv->pshare->is_40m_bw = CHANNEL_WIDTH_20;
				for (i=0; i<priv->available_chnl_num; i++) {
					if(priv->available_chnl[i] == 36 || priv->available_chnl[i] == 64 || priv->available_chnl[i] == 157){
						if (score[i] < minScore) {
							minScore = score[i];
							idx = i;
						}
					}
				}
			}
		}
	}
	else if( (priv->pmib->dot11RFEntry.phyBandSelect == PHY_BAND_5G)
			&& (priv->pmib->dot11nConfigEntry.dot11nUse40M == CHANNEL_WIDTH_40)
			&& (priv->pmib->dot11RFEntry.acs_type != 3))
 	{
#ifdef NHM_ACS2_SUPPORT
		if (priv->pmib->dot11RFEntry.acs_type == 2) {
			idx = selectClearChannel_5g_acs2(priv);
		}
		else
#endif			
 		{
		for (i=0; i<priv->available_chnl_num; i++) {
			if(is40MChannel(priv->available_chnl,priv->available_chnl_num,priv->available_chnl[i])) {
				if(priv->pmib->dot11StationConfigEntry.dot11RegDomain == DOMAIN_MX &&
				   !is_DFS_channel(priv, priv->available_chnl[i])) //choose DFS channel in DOMAIN_MX
				   continue;
				tmpScore = 0;
				for(j=0;j<2;j++) {
					if ((tmpScore != 0xffffffff) && (score[i+j] != 0xffffffff))
						tmpScore += score[i+j];
					else
						tmpScore = 0xffffffff;
				}
				tmpScore = tmpScore / 2;
				if(minScore > tmpScore) {
					minScore = tmpScore;

					tmpScore = 0xffffffff;
					for (j=0; j<2; j++) {
						if(priv->pmib->dot11StationConfigEntry.dot11RegDomain == DOMAIN_MX){
							if ((score[i+j] < tmpScore) && (priv->available_chnl[i+j] != 144)) {
								tmpScore = score[i+j];
								tmpIdx = i+j;
							}
						}
						else {
							if (score[i+j] < tmpScore) {
								tmpScore = score[i+j];
								tmpIdx = i+j;
							}
						}
					}

					idx = tmpIdx;
				}
				i += 1;
			}
		}
		if (priv->pmib->dot11StationConfigEntry.dot11RegDomain == DOMAIN_MX && minScore == 0xffffffff) {
			//there is no DFS channels available
			for (i=0; i<priv->available_chnl_num; i++) {
				if(is40MChannel(priv->available_chnl,priv->available_chnl_num,priv->available_chnl[i]) && !is_DFS_channel(priv, priv->available_chnl[i])) {
					tmpScore = 0;
					for(j=0;j<2;j++) {
						if ((tmpScore != 0xffffffff) && (score[i+j] != 0xffffffff))
							tmpScore += score[i+j];
						else
							tmpScore = 0xffffffff;
					}
					tmpScore = tmpScore / 2;
					if(minScore > tmpScore) {
						minScore = tmpScore;

						tmpScore = 0xffffffff;
						for (j=0; j<2; j++) {
							if ((score[i+j] < tmpScore) && (priv->available_chnl[i+j] != 144)) {
								tmpScore = score[i+j];
								tmpIdx = i+j;
							}
						}

						idx = tmpIdx;
					}
					i += 1;
				}
			}
		}
		if (minScore == 0xffffffff) {
			// there is no 40M channels
			priv->pshare->is_40m_bw = CHANNEL_WIDTH_20;
			for (i=0; i<priv->available_chnl_num; i++) {
				if(priv->pmib->dot11StationConfigEntry.dot11RegDomain == DOMAIN_MX && priv->available_chnl[i] == 144)
					continue;
				if (score[i] < minScore) {
					minScore = score[i];
					idx = i;
				}
			}
		}
	}
	}
	else if( (priv->pmib->dot11RFEntry.phyBandSelect == PHY_BAND_2G)
			&& ((priv->pmib->dot11nConfigEntry.dot11nUse40M == CHANNEL_WIDTH_40) || ((priv->pmib->dot11RFEntry.acs_type == 4) || (priv->pmib->dot11RFEntry.acs_type == 5)))
			&& (priv->available_chnl_num >= 8) )
	{	
#ifdef NHM_ACS2_SUPPORT
		if (priv->pmib->dot11RFEntry.acs_type == 2) {
			idx = selectClearChannel_2g_acs2(priv);
		}
		else
#endif			
	{
		unsigned int groupScore[14];

		if ((priv->pmib->dot11RFEntry.acs_type == 4) || (priv->pmib->dot11RFEntry.acs_type == 5))
		{
			unsigned int chTmp;
			chTmp = (priv->pmib->dot11StationConfigEntry.dot11RegDomain == DOMAIN_ETSI)?(ch_end-2):ch_end;
			for (i=ch_begin; i<chTmp; i++)
			{								
				if (priv->pmib->dot11RFEntry.acs_type == 4) {
					if (score[i] < minScore)				
					{					
						minScore = score[i];					
						idx = i;
					}
				}	
				else if (priv->pmib->dot11RFEntry.acs_type == 5) {
					scoreSum[i] += score[i];
					if ((i+1)<=(chTmp-1))
						scoreSum[i] += score[i+1];
					if ((i-1)>=0)
						scoreSum[i] += score[i-1];		
					
					if (scoreSum[i] < minScore)
					{
						minScore = scoreSum[i];
						idx = i;
					}
				}
			}

			if (idx <= 3) {
				GET_MIB(priv)->dot11nConfigEntry.dot11n2ndChOffset = HT_2NDCH_OFFSET_ABOVE;
				priv->pshare->offset_2nd_chan	  = HT_2NDCH_OFFSET_ABOVE;
			}		
			else if (idx >= 7) {
				GET_MIB(priv)->dot11nConfigEntry.dot11n2ndChOffset = HT_2NDCH_OFFSET_BELOW;
				priv->pshare->offset_2nd_chan	  = HT_2NDCH_OFFSET_BELOW;
			}		
			else  {
				if (score[idx-4] > score[idx+4]) {
					GET_MIB(priv)->dot11nConfigEntry.dot11n2ndChOffset = HT_2NDCH_OFFSET_ABOVE;
					priv->pshare->offset_2nd_chan	  = HT_2NDCH_OFFSET_ABOVE;
				}		
				else {
					GET_MIB(priv)->dot11nConfigEntry.dot11n2ndChOffset = HT_2NDCH_OFFSET_BELOW;
					priv->pshare->offset_2nd_chan	  = HT_2NDCH_OFFSET_BELOW;
				}		
			}
		}
		else
		{
		memset(groupScore, 0xff , sizeof(groupScore));
		for (i=0; i<priv->available_chnl_num-4; i++) {
			if (score[i] != 0xffffffff && score[i+4] != 0xffffffff) {
				groupScore[i] = score[i] + score[i+4];
				DEBUG_INFO("groupScore, ch %d,%d: %d\n", priv->available_chnl[i], priv->available_chnl[i+4], groupScore[i]);
				if (groupScore[i] < minScore) {
					if(priv->pmib->miscEntry.autoch_1611_enable)
					{
						if((priv->available_chnl[i]==1 && (score[i] < score[i+4])) ||
							(priv->available_chnl[i]==2 && (score[i] > score[i+4])) ||
							(priv->available_chnl[i]==6 && (score[i] < score[i+4])) ||
							(priv->available_chnl[i]==7 && (score[i] > score[i+4])))
						{
							minScore = groupScore[i];
							idx = i;
						}
					} else {
						minScore = groupScore[i];
						idx = i;
					}
				}
			}
		}

		if(minScore == 0xffffffff && priv->pmib->miscEntry.autoch_1611_enable){
			for (i=0; i<priv->available_chnl_num; i++) {
				if (score[i] < minScore) {
					if(priv->available_chnl[i]==1 || priv->available_chnl[i]==6 || priv->available_chnl[i]==11)
					{
						minScore = score[i];
						idx = i;
					}
				}
			}

			if(priv->available_chnl[idx] == 1){
				GET_MIB(priv)->dot11nConfigEntry.dot11n2ndChOffset = HT_2NDCH_OFFSET_ABOVE;
				priv->pshare->offset_2nd_chan	= HT_2NDCH_OFFSET_ABOVE;
			}else if(priv->available_chnl[idx] == 11){
				GET_MIB(priv)->dot11nConfigEntry.dot11n2ndChOffset = HT_2NDCH_OFFSET_BELOW;
				priv->pshare->offset_2nd_chan	= HT_2NDCH_OFFSET_BELOW;
			}else {//channel 6
				if(score[idx-4] > score[idx+4]){
					GET_MIB(priv)->dot11nConfigEntry.dot11n2ndChOffset = HT_2NDCH_OFFSET_ABOVE;
					priv->pshare->offset_2nd_chan	= HT_2NDCH_OFFSET_ABOVE;
				}else{
					GET_MIB(priv)->dot11nConfigEntry.dot11n2ndChOffset = HT_2NDCH_OFFSET_BELOW;
					priv->pshare->offset_2nd_chan	= HT_2NDCH_OFFSET_BELOW;
				}
			}
		} else {
			if (score[idx] < score[idx+4]) {
				GET_MIB(priv)->dot11nConfigEntry.dot11n2ndChOffset = HT_2NDCH_OFFSET_ABOVE;
				priv->pshare->offset_2nd_chan	= HT_2NDCH_OFFSET_ABOVE;
			} else {
				idx = idx + 4;
				GET_MIB(priv)->dot11nConfigEntry.dot11n2ndChOffset = HT_2NDCH_OFFSET_BELOW;
				priv->pshare->offset_2nd_chan	= HT_2NDCH_OFFSET_BELOW;
			}
		}
	}	
	}
	}
	else 
	{
#ifdef NHM_ACS2_SUPPORT
		if (priv->pmib->dot11RFEntry.acs_type == 2)
		{
			if (priv->pmib->dot11RFEntry.phyBandSelect == PHY_BAND_2G) {
				idx = selectClearChannel_2g_acs2(priv);
			} else {
				idx = selectClearChannel_5g_acs2(priv);
			}
		}
		else 
#endif		
	{
		for (i=0; i<priv->available_chnl_num; i++) {
			if (score[i] < minScore) {
				if(priv->pmib->dot11StationConfigEntry.dot11RegDomain == DOMAIN_MX && priv->available_chnl[i] == 144)
					continue;
				if(priv->pmib->miscEntry.autoch_1611_enable)
				{
					if(priv->available_chnl[i]==1 || priv->available_chnl[i]==6 || priv->available_chnl[i]==11)
					{
						minScore = score[i];
						idx = i;
					}
				} else {				
					minScore = score[i];
					idx = i;
					}
				}
			}
		}
	}

	if (IS_A_CUT_8881A(priv) &&
		(priv->pmib->dot11nConfigEntry.dot11nUse40M == CHANNEL_WIDTH_80)) {
		if ((priv->available_chnl[idx] == 36) ||
			(priv->available_chnl[idx] == 52) ||
			(priv->available_chnl[idx] == 100) ||
			(priv->available_chnl[idx] == 116) ||
			(priv->available_chnl[idx] == 132) ||
			(priv->available_chnl[idx] == 149) ||
			(priv->available_chnl[idx] == 165))
			idx++;
		else if ((priv->available_chnl[idx] == 48) ||
			(priv->available_chnl[idx] == 64) ||
			(priv->available_chnl[idx] == 112) ||
			(priv->available_chnl[idx] == 128) ||
			(priv->available_chnl[idx] == 144) ||
			(priv->available_chnl[idx] == 161) ||
			(priv->available_chnl[idx] == 177))
			idx--;
	}

	minChan = priv->available_chnl[idx];

	// skip channel 14 if don't support ofdm
	if ((priv->pmib->dot11RFEntry.disable_ch14_ofdm) &&
			(minChan == 14)) {
		score[idx] = 0xffffffff;
		
		minScore = 0xffffffff;
		for (i=0; i<priv->available_chnl_num; i++) {
			if (score[i] < minScore) {
				minScore = score[i];
				idx = i;
			}
		}
		minChan = priv->available_chnl[idx];
	}

#if 0
	//Check if selected channel available for 80M/40M BW or NOT ?
	if(priv->pmib->dot11RFEntry.phyBandSelect == PHY_BAND_5G)
	{
		if(priv->pmib->dot11nConfigEntry.dot11nUse40M == CHANNEL_WIDTH_80)
		{
			if(!is80MChannel(priv->available_chnl,priv->available_chnl_num,minChan))
			{
				//printk("BW=80M, selected channel = %d is unavaliable! reduce to 40M\n", minChan);
				//priv->pmib->dot11nConfigEntry.dot11nUse40M = CHANNEL_WIDTH_40;
				priv->pshare->is_40m_bw = CHANNEL_WIDTH_40;
			}
		}
			
		if(priv->pmib->dot11nConfigEntry.dot11nUse40M == CHANNEL_WIDTH_40)
		{
			if(!is40MChannel(priv->available_chnl,priv->available_chnl_num,minChan))
			{
				//printk("BW=40M, selected channel = %d is unavaliable! reduce to 20M\n", minChan);
				//priv->pmib->dot11nConfigEntry.dot11nUse40M = CHANNEL_WIDTH_20;
				priv->pshare->is_40m_bw = CHANNEL_WIDTH_20;
			}
		}
	}
#endif

#ifdef CONFIG_RTL_NEW_AUTOCH
	RTL_W32(RXERR_RPT, RXERR_RPT_RST);
#endif

// auto adjust contro-sideband
	if ((priv->pmib->dot11BssType.net_work_type & WIRELESS_11N)
			&& (priv->pshare->is_40m_bw ==1 || priv->pshare->is_40m_bw ==2)) {

#ifdef RTK_5G_SUPPORT
		if (priv->pmib->dot11RFEntry.phyBandSelect & PHY_BAND_5G) {
			if( (minChan>144) ? ((minChan-1)%8) : (minChan%8)) {
				GET_MIB(priv)->dot11nConfigEntry.dot11n2ndChOffset = HT_2NDCH_OFFSET_ABOVE;
				priv->pshare->offset_2nd_chan	= HT_2NDCH_OFFSET_ABOVE;
			} else {
				GET_MIB(priv)->dot11nConfigEntry.dot11n2ndChOffset = HT_2NDCH_OFFSET_BELOW;
				priv->pshare->offset_2nd_chan	= HT_2NDCH_OFFSET_BELOW;
			}

		} else
#endif		
		{
#if 0
#ifdef CONFIG_RTL_NEW_AUTOCH
			unsigned int ch_max;

			if (priv->available_chnl[idx_2G_end] >= 13)
				ch_max = 13;
			else
				ch_max = priv->available_chnl[idx_2G_end];

			if ((minChan >= 5) && (minChan <= (ch_max-5))) {
				if (score[minChan+4] > score[minChan-4]) { /* what if some channels were cancelled? */
					GET_MIB(priv)->dot11nConfigEntry.dot11n2ndChOffset = HT_2NDCH_OFFSET_BELOW;
					priv->pshare->offset_2nd_chan	= HT_2NDCH_OFFSET_BELOW;
				} else {
					GET_MIB(priv)->dot11nConfigEntry.dot11n2ndChOffset = HT_2NDCH_OFFSET_ABOVE;
					priv->pshare->offset_2nd_chan	= HT_2NDCH_OFFSET_ABOVE;
				}
			} else
#endif
			{
				if (minChan < 5) {
					GET_MIB(priv)->dot11nConfigEntry.dot11n2ndChOffset = HT_2NDCH_OFFSET_ABOVE;
					priv->pshare->offset_2nd_chan	= HT_2NDCH_OFFSET_ABOVE;
				}
				else if (minChan > 7) {
					GET_MIB(priv)->dot11nConfigEntry.dot11n2ndChOffset = HT_2NDCH_OFFSET_BELOW;
					priv->pshare->offset_2nd_chan	= HT_2NDCH_OFFSET_BELOW;
				}
			}
#endif
		}
	}
//-----------------------
cal_and_record_score:
#ifdef CTC_2G_ACS
	if (atomic_read(&(priv->pshare->autoch_score_timeout)) == 0)
#endif
	{
#ifdef ACS_DEBUG_INFO
		printk("%s(%d) Assign chnl_ss_score\n", __func__, __LINE__);
#endif
		unsigned int max_score = 0;
		for (y=ch_begin; y<ch_end; y++)  {
				if(score[y] > max_score && score[y] != 0xffffffff) max_score = score[y];
		}
		if(max_score == 0)
				max_score = 1;
		if(priv->pmib->dot11RFEntry.phyBandSelect == PHY_BAND_2G)
		{
			for (y=ch_begin; y<ch_end; y++)  {
				if(score[y] == 0xffffffff)
					priv->chnl_ss_score[y] = 100;
				else if((priv->pmib->dot11RFEntry.acs_type == 0) && (max_score == 248))
					priv->chnl_ss_score[y] = 0;
				else
					priv->chnl_ss_score[y] = (unsigned long int)score[y]*95/max_score;
			}
		}
		else if(priv->pmib->dot11RFEntry.phyBandSelect == PHY_BAND_5G)
		{
			for (y=ch_begin; y<ch_end; y++)  {
				if(score[y] == 0xffffffff)
					priv->chnl_ss_score[y] = 100;
				else
					priv->chnl_ss_score[y] = (unsigned long int)score[y]*95/max_score;
				//printk("ch:%u score=%u(%u,%u)\n",priv->available_chnl[y],priv->chnl_ss_score[y],score[y],max_score);
			}
		}
	}
	if(priv->auto_channel != 1
#ifdef RTK_MESH_SIMPLE_CSA
		&& priv->mesh_CSA_state == MESH_CSA_NONE
#endif
	)
		return 0;

#if defined(__ECOS) && defined(CONFIG_SDIO_HCI)
	panic_printk("Auto channel choose ch:%d\n", minChan);
#else
#ifdef _DEBUG_RTL8192CD_
	panic_printk("Auto channel choose ch:%d\n", minChan);
#endif
#endif
#ifdef ACS_DEBUG_INFO//for debug
	printk("7. minChan:%d 2nd_offset:%d\n", minChan, priv->pshare->offset_2nd_chan);
#endif

	return minChan;
}


#ifdef CONFIG_RTL_WLAN_DOS_FILTER
int issue_disassoc_from_kernel(void *priv, unsigned char *mac)
{
	memcpy(block_mac[block_mac_idx], mac, 6);
	block_mac_idx++;
	block_mac_idx = block_mac_idx % MAX_BLOCK_MAC;
	
	if (priv != NULL) {
//		issue_disassoc((struct rtl8192cd_priv *)priv, mac, _RSON_UNSPECIFIED_);
		issue_deauth((struct rtl8192cd_priv *)priv, mac, _RSON_UNSPECIFIED_);
		block_sta_time = ((struct rtl8192cd_priv *)priv)->pshare->rf_ft_var.dos_block_time;
		block_priv = (unsigned long)priv;
	}
	return 0;
}
#endif

/**
 *	@brief	issue de-authenticaion
 *
 *	Defragement fail will be de-authentication or STA issue deauthenticaion request
 *
 *	+---------------+-----+----+----+-------+-----+-------------+ \n
 *	| Frame Control | ... | DA | SA | BSSID | ... | Reason Code | \n
 *	+---------------+-----+----+----+-------+-----+-------------+ \n
 */
void issue_deauth(struct rtl8192cd_priv *priv, unsigned char *da, int reason)
{
#ifdef CONFIG_RTK_MESH
	issue_deauth_MP(priv, da, reason, FALSE);
}


void issue_deauth_MP(struct rtl8192cd_priv *priv,	unsigned char *da, int reason, UINT8 is_11s)
{
#endif
	struct wifi_mib *pmib;
	unsigned char	*bssid, *pbuf;
	unsigned short  val;
	#if defined(WIFI_WMM)
	int ret;
	#endif
	struct stat_info *pstat = get_stainfo(priv, da);    
	DECLARE_TXINSN(txinsn);

	if (!memcmp(da, "\x0\x0\x0\x0\x0\x0", 6))
		return;

	// check if da is legal
	if (da[0] & 0x01 
#ifdef CONFIG_IEEE80211W
		&& memcmp(da,"\xff\xff\xff\xff\xff\xff",6)
#endif
		){
		DEBUG_WARN("Send Deauth Req to bad DA %02x%02x%02x%02x%02x%02x", da[0], da[1], da[2], da[3], da[4], da[5]);
		return;
	}

#ifdef TLN_STATS
	stats_conn_rson_counts(priv, reason);
#endif
#ifdef STA_ASSOC_STATISTIC
	add_sta_assoc_status(priv, da, 0, reason | 0x400);
#endif
#ifdef CONFIG_RTL_88E_SUPPORT
	if (GET_CHIP_VER(priv)==VERSION_8188E) {
		if (pstat && (!pstat->cmn_info.ra_info.disable_ra)) {
			RTL8188E_MACID_NOLINK(priv, 1, REMAP_AID(pstat));
			RTL8188E_MACID_PAUSE(priv, 0, REMAP_AID(pstat));
            pstat->txpause_flag = 0;            
		}
	}
#endif

#ifdef CONFIG_WLAN_HAL
    if (IS_HAL_CHIP(priv)) {
        if (pstat && !pstat->cmn_info.ra_info.disable_ra) {
            DEBUG_WARN("[%s][%s][%d] set MACID %d\n", __FUNCTION__, priv->dev->name, pstat->cmn_info.aid, REMAP_AID(pstat));
			if (!pstat->txpdrop_flag) {
				GET_HAL_INTERFACE(priv)->UpdateHalMSRRPTHandler(priv, pstat, DECREASE);
				pstat->txpdrop_flag = 1;
			} 			
            GET_HAL_INTERFACE(priv)->SetMACIDSleepHandler(priv, 0, REMAP_AID(pstat));        
			if (pstat->txpause_flag) {
				pstat->txpause_flag = 0;
				if (priv->pshare->paused_sta_num)
					priv->pshare->paused_sta_num--;
			}
        }
    }
#endif
#ifdef CONFIG_RTL_8812_SUPPORT
	if (GET_CHIP_VER(priv)== VERSION_8812E) {
        if (pstat && !pstat->cmn_info.ra_info.disable_ra) {
			if (!pstat->txpdrop_flag) {
				UpdateHalMSRRPT8812(priv, pstat, DECREASE);			
				pstat->txpdrop_flag = 1;
			} 			
			RTL8812_MACID_PAUSE(priv, 0, REMAP_AID(pstat));
			if (pstat->txpause_flag) {
				pstat->txpause_flag = 0;
				if (priv->pshare->paused_sta_num)
					priv->pshare->paused_sta_num--;
			}
        }	
	}
#endif
	txinsn.retry = priv->pmib->dot11OperationEntry.dot11ShortRetryLimit;

	pmib= GET_MIB(priv);

	bssid = pmib->dot11StationConfigEntry.dot11Bssid;

#ifdef CONFIG_RTK_MESH
	txinsn.is_11s = is_11s;
#endif

	txinsn.q_num = MANAGE_QUE_NUM;
#ifdef P2P_SUPPORT	/*cfg p2p cfg p2p*/
        if(rtk_p2p_is_enabled(priv)){
            txinsn.tx_rate = _6M_RATE_;
        }else
#endif
    	txinsn.tx_rate  = find_rate(priv, NULL, 0, 1);
#ifndef TX_LOWESTRATE
	txinsn.lowest_tx_rate = txinsn.tx_rate;
#endif	
	txinsn.fixed_rate = 1;
	txinsn.fr_type = _PRE_ALLOCMEM_;
#ifdef CONFIG_IEEE80211W	
	if(!memcmp(da,"\xff\xff\xff\xff\xff\xff",6)) {
		txinsn.isPMF = 1; //?????
	} else {
	
		if(pstat)
			txinsn.isPMF = pstat->isPMF;
		else
			txinsn.isPMF = 0;	
	}	
	PMFDEBUG("txinsn.isPMF=%d,pstat=%p, da=%02x%02x%02x%02x%02x%02x\n",txinsn.isPMF,pstat,da[0],da[1],da[2],da[3],da[4],da[5]);
#endif	

	pbuf = txinsn.pframe  = get_mgtbuf_from_poll(priv);

	if (pbuf == NULL) {
		DRV_RT_TRACE(priv, DRV_DBG_CONN_INFO, DRV_DBG_SERIOUS, "issue_deauth_fail, pbuf == NULL\n");
		goto issue_deauth_fail;
	}

	txinsn.phdr = get_wlanhdr_from_poll(priv);

	if (txinsn.phdr == NULL) {
		DRV_RT_TRACE(priv, DRV_DBG_CONN_INFO, DRV_DBG_SERIOUS, "issue_deauth_fail, txinsn.phdr == NULL\n");
		goto issue_deauth_fail;
	}

	memset((void *)txinsn.phdr, 0, sizeof(struct  wlan_hdr));

	val = cpu_to_le16(reason);

	pbuf = set_fixed_ie(pbuf, _RSON_CODE_ , (unsigned char *)&val, &txinsn.fr_len);

#ifdef P2P_SUPPORT
/*cfg p2p cfg p2p*/
	if((rtk_p2p_is_enabled(priv)) && rtk_p2p_chk_role(priv,P2P_CLIENT)){
		if(priv->p2pPtr->p2p_disass_ie_len){
			memcpy(pbuf, priv->p2pPtr->p2p_disass_ie, priv->p2pPtr->p2p_disass_ie_len);
			pbuf += priv->p2pPtr->p2p_disass_ie_len;
			txinsn.fr_len += priv->p2pPtr->p2p_disass_ie_len;
		}
	}
#endif

#ifdef RTK_WLAN_EVENT_INDICATE
	rtk_wlan_event_indicate(priv->dev->name, WIFI_PEER_CONNECT_FAIL, da, reason);
#endif

	SetFrameType((txinsn.phdr),WIFI_MGT_TYPE);
	SetFrameSubType((txinsn.phdr),WIFI_DEAUTH);
#ifdef CONFIG_IEEE80211W
	if (txinsn.isPMF)
		*(unsigned char*)(txinsn.phdr+1) |= BIT(6); // enable privacy 
#endif

	memcpy((void *)GetAddr1Ptr((txinsn.phdr)), da, MACADDRLEN);
	memcpy((void *)GetAddr2Ptr((txinsn.phdr)), GET_MY_HWADDR, MACADDRLEN);
	memcpy((void *)GetAddr3Ptr((txinsn.phdr)), bssid, MACADDRLEN);

#if defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI)
	txinsn.is_urgent = 1;
#endif

	SNMP_MIB_ASSIGN(dot11DeauthenticateReason, reason);
	SNMP_MIB_COPY(dot11DeauthenticateStation, da, MACADDRLEN);

#ifdef MULTI_MAC_CLONE
	if (OPMODE & WIFI_AP_STATE) { //if priv is AP, disconnect the client in multi-Sta
	    __del_mclone_addr(priv, da);
	}
#endif

#ifdef AUTH_SAE
	log("delete_peer [%pm]", da);
	delete_peer(priv, da);
#endif

#if defined(WIFI_WMM)
	ret = check_dz_mgmt(priv, pstat, &txinsn);
	
	if (ret < 0) {
		DRV_RT_TRACE(priv, DRV_DBG_CONN_INFO, DRV_DBG_SERIOUS, "issue_deauth_fail, ret = %d\n", ret);
		goto issue_deauth_fail;
	} else if (ret==1){
		DRV_RT_TRACE(priv, DRV_DBG_CONN_INFO, DRV_DBG_SERIOUS, "issue_deauth_fail because sta have dz_mgnt queue\n");
		return;
	} else
#endif
	{
#ifdef RTK_WLAN_EVENT_INDICATE
		if (pstat && (pstat->expire_to == 0) && (reason == _RSON_DEAUTH_STA_LEAVING_)) {
			//DRV_RT_TRACE(priv, DRV_DBG_CONN_INFO, DRV_DBG_SERIOUS, "issue_deauth_success send WIFI_PEER_EXPIRE_DISCONNECT\n");
			rtk_wlan_event_indicate(priv->dev->name, WIFI_PEER_EXPIRE_DISCONNECT, da, reason);
		} else {
			//DRV_RT_TRACE(priv, DRV_DBG_CONN_INFO, DRV_DBG_SERIOUS, "issue_deauth_success send WIFI_DUT_DISCONNECT\n");
			rtk_wlan_event_indicate(priv->dev->name, WIFI_DUT_DISCONNECT, da, reason);
		}
#endif

#ifdef CTC_WIFI_DIAG
		ctcwifi_diag_log(priv, da, 1, "Deauthentication", (unsigned char *)(txinsn.pframe), txinsn.fr_len);
#endif

		if ((rtl8192cd_firetx(priv, &txinsn)) == SUCCESS){
#ifdef CONFIG_RTL_WLAN_STATUS
        	priv->wlan_status_flag=1;
#endif       
			return;
    	}
	}

issue_deauth_fail:

	if (txinsn.phdr)
		release_wlanhdr_to_poll(priv, txinsn.phdr);
	if (txinsn.pframe)
		release_mgtbuf_to_poll(priv, txinsn.pframe);
}


void issue_disassoc(struct rtl8192cd_priv *priv, unsigned char *da, int reason)
{
	struct wifi_mib *pmib;
	unsigned char	*bssid, *pbuf;
	unsigned short  val;
	struct stat_info *pstat;
	#if defined(WIFI_WMM)
	int ret;
	#endif
	DECLARE_TXINSN(txinsn);

	// check if da is legal
	if (da[0] & 0x01
#if 0//def CONFIG_IEEE80211W
		&& memcmp(da, "\xff\xff\xff\xff\xff\xff", 6)
#endif
	) {
		DEBUG_WARN("Send Disassoc Req to bad DA %02x%02x%02x%02x%02x%02x", da[0], da[1], da[2], da[3], da[4], da[5]);
		return;
	}
	pstat = get_stainfo(priv, da);

#ifdef TLN_STATS
	stats_conn_rson_counts(priv, reason);
#endif

#ifdef CONFIG_RTL_88E_SUPPORT
	if (GET_CHIP_VER(priv)==VERSION_8188E) {
		if (pstat && (!pstat->cmn_info.ra_info.disable_ra)) {
			RTL8188E_MACID_NOLINK(priv, 1, REMAP_AID(pstat));
			RTL8188E_MACID_PAUSE(priv, 0, REMAP_AID(pstat));
            pstat->txpause_flag = 0;            
		}
	}
#endif

#ifdef CONFIG_WLAN_HAL
        if (IS_HAL_CHIP(priv)) {
            if (pstat && !pstat->cmn_info.ra_info.disable_ra) {
                DEBUG_WARN("[%s][%s][%d] set MACID %d\n", __FUNCTION__, priv->dev->name, pstat->cmn_info.aid, REMAP_AID(pstat));
				if (!pstat->txpdrop_flag) {
					GET_HAL_INTERFACE(priv)->UpdateHalMSRRPTHandler(priv, pstat, DECREASE);
					pstat->txpdrop_flag = 1;
				}
                GET_HAL_INTERFACE(priv)->SetMACIDSleepHandler(priv, 0, REMAP_AID(pstat));
				if (pstat->txpause_flag) {
					pstat->txpause_flag = 0;
					if (priv->pshare->paused_sta_num)
						priv->pshare->paused_sta_num--;
				}
            }
        }
#endif

#ifdef CONFIG_RTL_8812_SUPPORT
	if (GET_CHIP_VER(priv)== VERSION_8812E) {
        if (pstat && !pstat->cmn_info.ra_info.disable_ra) {
			if (!pstat->txpdrop_flag) {
				UpdateHalMSRRPT8812(priv, pstat, DECREASE);
				pstat->txpdrop_flag = 1;
			} 			
			RTL8812_MACID_PAUSE(priv, 0, REMAP_AID(pstat));
			if (pstat->txpause_flag) {
				pstat->txpause_flag = 0;
				if (priv->pshare->paused_sta_num)
					priv->pshare->paused_sta_num--;
			}
        }
	}
#endif

#ifdef P2P_SUPPORT	/*P2P (DUT AS GO) IOT with Phone(M8,nexus7,s4 etc)*/ 
	if(rtk_p2p_is_enabled(priv)){
        if(!(pstat->state & WIFI_ASOC_STATE)){
            /*if peer has sent dis_assoc for DUT, dont' send disassoc to peer*/
    	    P2P_DEBUG("dont' send disassoc to peer\n");            
          	return;
        }
	}
#endif    

	txinsn.retry = priv->pmib->dot11OperationEntry.dot11ShortRetryLimit;

	pmib= GET_MIB(priv);

	bssid = pmib->dot11StationConfigEntry.dot11Bssid;

	txinsn.q_num = MANAGE_QUE_NUM;
	txinsn.fr_type = _PRE_ALLOCMEM_;
#ifdef CONFIG_IEEE80211W	
	if(!memcmp(da,"\xff\xff\xff\xff\xff\xff",6)) {
		txinsn.isPMF = 1; //?????
	} else {
		if(pstat)
			txinsn.isPMF = pstat->isPMF;
		else
			txinsn.isPMF = 0;
	}	
	PMFDEBUG("txinsn.isPMF=%d,pstat=%p, da=%02x%02x%02x%02x%02x%02x\n",txinsn.isPMF,pstat,da[0],da[1],da[2],da[3],da[4],da[5]);
#endif

#ifdef P2P_SUPPORT	/*cfg p2p cfg p2p*/
	if(rtk_p2p_is_enabled(priv)){
      	txinsn.tx_rate = _6M_RATE_;
	}else
#endif    
    	txinsn.tx_rate  = find_rate(priv, NULL, 0, 1);
#ifndef TX_LOWESTRATE
	txinsn.lowest_tx_rate = txinsn.tx_rate;
#endif	
	txinsn.fixed_rate = 1;

	pbuf = txinsn.pframe  = get_mgtbuf_from_poll(priv);

	if (pbuf == NULL)
		goto issue_disassoc_fail;

	txinsn.phdr = get_wlanhdr_from_poll(priv);

	if (txinsn.phdr == NULL)
		goto issue_disassoc_fail;

	memset((void *)txinsn.phdr, 0, sizeof(struct  wlan_hdr));

	val = cpu_to_le16(reason);

	pbuf = set_fixed_ie(pbuf, _RSON_CODE_, (unsigned char *)&val, &txinsn.fr_len);

#ifdef P2P_SUPPORT/*cfg p2p cfg p2p*/
	if((rtk_p2p_is_enabled(priv)) && rtk_p2p_chk_role(priv,P2P_CLIENT)){
		if(priv->p2pPtr->p2p_disass_ie_len){
			memcpy(pbuf, priv->p2pPtr->p2p_disass_ie, priv->p2pPtr->p2p_disass_ie_len);
			pbuf += priv->p2pPtr->p2p_disass_ie_len;
			txinsn.fr_len += priv->p2pPtr->p2p_disass_ie_len;
		}
	}
#endif

#ifdef RTK_WLAN_EVENT_INDICATE
	rtk_wlan_event_indicate(priv->dev->name, WIFI_PEER_CONNECT_FAIL, da, reason);
#endif

	SetFrameType((txinsn.phdr), WIFI_MGT_TYPE);
	SetFrameSubType((txinsn.phdr), WIFI_DISASSOC);

#ifdef CONFIG_IEEE80211W
	if (txinsn.isPMF)
		*(unsigned char*)(txinsn.phdr+1) |= BIT(6); // enable privacy 
#endif	

	memcpy((void *)GetAddr1Ptr((txinsn.phdr)), da, MACADDRLEN);
	memcpy((void *)GetAddr2Ptr((txinsn.phdr)), GET_MY_HWADDR, MACADDRLEN);
	memcpy((void *)GetAddr3Ptr((txinsn.phdr)), bssid, MACADDRLEN);

#if defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI)
	txinsn.is_urgent = 1;
#endif

	SNMP_MIB_ASSIGN(dot11DisassociateReason, reason);
	SNMP_MIB_COPY(dot11DisassociateStation, da, MACADDRLEN);

#ifdef MULTI_MAC_CLONE
	if (OPMODE & WIFI_AP_STATE) { //if priv is AP, disconnect the client in multi-Sta
	    __del_mclone_addr(priv, da);
	}
#endif
#ifdef AUTH_SAE
	log("delete_peer [%pm]", da);
	delete_peer(priv, da);
#endif

#if defined(WIFI_WMM)
	ret = check_dz_mgmt(priv, pstat, &txinsn);
	
	if (ret < 0)
		goto issue_disassoc_fail;
	else if (ret==1)
		return;
	else
#endif	
#if defined(CONFIG_AUTH_RESULT)
	if(authRes == 0 && reason == 3)
	{
		authRes = 25;
		//printk("set disassociate reason to %d\n", authRes);
	}
#endif

#ifdef RTK_WLAN_EVENT_INDICATE
	if (pstat && (pstat->expire_to == 0) && (reason == _RSON_DEAUTH_STA_LEAVING_)) {
		rtk_wlan_event_indicate(priv->dev->name, WIFI_PEER_EXPIRE_DISCONNECT, da, reason);
	}else {
		rtk_wlan_event_indicate(priv->dev->name, WIFI_DUT_DISCONNECT, da, reason);
	}
#endif
	{
#ifdef CTC_WIFI_DIAG
		ctcwifi_diag_log(priv, da, 1, "Disassociation", (unsigned char *)(txinsn.pframe), txinsn.fr_len);
#endif

	if ((rtl8192cd_firetx(priv, &txinsn)) == SUCCESS){
#ifdef CONFIG_RTL_WLAN_STATUS
        priv->wlan_status_flag=1;
#endif              
		return;
    }
	}

issue_disassoc_fail:

	if (txinsn.phdr)
		release_wlanhdr_to_poll(priv, txinsn.phdr);
	if (txinsn.pframe)
		release_mgtbuf_to_poll(priv, txinsn.pframe);
}

#if 0
// if pstat == NULL, indiate we are station now...
void issue_auth(struct rtl8192cd_priv *priv, struct stat_info *pstat, unsigned short status)
{
	struct wifi_mib *pmib;
	unsigned char	*bssid, *pbuf;
	unsigned short  val;
	int use_shared_key=0;

#if defined(CONFIG_RTK_MESH) && defined(MESH_BOOTSEQ_AUTH)
	UINT8	isMeshMP = FALSE;
#endif	// CONFIG_RTK_MESH
	
	struct stat_info *pstat_tmp=NULL;

#ifdef RTK_MULTI_AP
	if(OPMODE & WIFI_STATION_STATE){
		if((priv->pmib->multi_ap.multiap_bss_type & BIT(7)) && (priv->pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm == _NO_PRIVACY_) && (!priv->pmib->wscEntry.wsc_enable)){
			DEBUG_INFO("[MAP]Issue auth request to open BSS not allowed\n");
			return;
		}
	}
#endif

	DECLARE_TXINSN(txinsn);

	if(priv->pmib->dot1180211AuthEntry.dot11EnablePSK !=0) {
		if(OPMODE & WIFI_AP_STATE) {	
			//Reset 4-WAY STATE for some phones' connection issue
			if(pstat && pstat->wpa_sta_info)
			pstat->wpa_sta_info->state = PSK_STATE_IDLE;
		}
	}
	
	txinsn.retry = priv->pmib->dot11OperationEntry.dot11ShortRetryLimit;

	pmib= GET_MIB(priv);

#if defined(CONFIG_RTK_MESH) && defined(MESH_BOOTSEQ_AUTH)
	if ((NULL != pstat) && (1 == GET_MIB(priv)->dot1180211sInfo.mesh_enable) && isPossibleNeighbor(pstat))
		isMeshMP = TRUE;

	if ((pstat) || (TRUE == isMeshMP))
#else
	if (pstat)
#endif	//CONFIG_RTK_MESH
		bssid = BSSID;
	else
		bssid = priv->pmib->dot11Bss.bssid;
		
	/* avoid possible loop , when the same mac has connected.
	   RTK, Atheros IC is test ok. 
	   Ralink test fail.
	   BCM to be confirmed.
	*/		
	int j;
	for(j=0; j<NUM_STAT; j++)
    {	
        if (priv->pshare->aidarray[j] && (priv->pshare->aidarray[j]->used == TRUE)
#ifdef WDS
            && !(priv->pshare->aidarray[j]->station.state & WIFI_WDS)
#endif
        ) 
       	{
       		pstat_tmp = &(priv->pshare->aidarray[j]->station);
			if(isEqualMACAddr(bssid, pstat_tmp->cmn_info.mac_addr) && pstat_tmp->expire_to){
#ifdef MULTI_MAC_CLONE
				if( (ACTIVE_ID>0) && ((GET_MIB(priv))->dot11OperationEntry.opmode & WIFI_ASOC_STATE)){
					break;
				}else
#endif	
				{
					 panic_printk("[%s:%d] The same mac has connected. refused\n", __FUNCTION__,__LINE__);
					 goto issue_auth_fail;
				}
			}
        }
    }

	if (pstat)
		DRV_RT_TRACE(priv, DRV_DBG_CONN_INFO, DRV_DBG_TRACE, "sta=%02x:%02x:%02x:%02x:%02x:%02x, status=%d\n", pstat->cmn_info.mac_addr[0], pstat->cmn_info.mac_addr[1], pstat->cmn_info.mac_addr[2], pstat->cmn_info.mac_addr[3], pstat->cmn_info.mac_addr[4], pstat->cmn_info.mac_addr[5], status);	

#if defined(CLIENT_MODE) && (defined(INCLUDE_WPA_PSK) || defined(RTK_NL80211))
	if (priv->assoc_reject_on && !memcmp(priv->assoc_reject_mac, bssid, MACADDRLEN)) {
		DEBUG_INFO("[%s:%d] assoc_reject_on=1, "MACSTR"\n", __func__, __LINE__, MAC2STR(priv->assoc_reject_mac));
		DRV_RT_TRACE(priv, DRV_DBG_CONN_INFO, DRV_DBG_SERIOUS, "assoc_reject_mac=%02x:%02x:%02x:%02x:%02x:%02x\n", 
				priv->assoc_reject_mac[0], priv->assoc_reject_mac[1], 
				priv->assoc_reject_mac[2], priv->assoc_reject_mac[3], 
				priv->assoc_reject_mac[4], priv->assoc_reject_mac[5]);
		goto issue_auth_fail;
	}
#endif

	txinsn.q_num = MANAGE_QUE_NUM;
#ifdef P2P_SUPPORT	/*cfg p2p cfg p2p*/
    if(rtk_p2p_is_enabled(priv)){	// 2013
        txinsn.tx_rate = _6M_RATE_;
    }else
#endif
    	txinsn.tx_rate = find_rate(priv, NULL, 0, 1);
#ifndef TX_LOWESTRATE
	txinsn.lowest_tx_rate = txinsn.tx_rate;
#endif	
	txinsn.fixed_rate = 1;
	txinsn.fr_type = _PRE_ALLOCMEM_;

	pbuf = txinsn.pframe = get_mgtbuf_from_poll(priv);

	if (pbuf == NULL)
		goto issue_auth_fail;

	txinsn.phdr = get_wlanhdr_from_poll(priv);

	if (txinsn.phdr == NULL) {
		DRV_RT_TRACE(priv, DRV_DBG_CONN_INFO, DRV_DBG_SERIOUS, "txinsn.phdr == NULL\n");
		goto issue_auth_fail;
	}

	memset((void *)(txinsn.phdr), 0, sizeof (struct	wlan_hdr));

	// setting auth algm number
	/* In AP mode,	if auth is set to shared-key, use shared key
	 *		if auth is set to auto, use shared key if client use shared
	 *		otherwise set to open
	 * In client mode, if auth is set to shared-key or auto, and WEP is used,
	 *		use shared key algorithm
	 */
	val = 0;

#if defined(CONFIG_RTK_MESH) && defined(MESH_BOOTSEQ_AUTH)	/* skip SIMPLE_CONFIG and Auth check, force use open system auth */
	if (FALSE == isMeshMP)
#endif
	{

#ifdef WIFI_SIMPLE_CONFIG
	if (pmib->wscEntry.wsc_enable) {
		if (pstat && (status == _STATS_SUCCESSFUL_) && (pstat->auth_seq == 2) &&
			(pstat->state & WIFI_AUTH_SUCCESS) && (pstat->AuthAlgrthm == 0))
			goto skip_security_check;
		else if ((pstat == NULL) && (AUTH_SEQ == 1))
			goto skip_security_check;
	}
#endif

#if defined(CONFIG_IEEE80211R) || defined(CONFIG_IEEE80211R_CLI)
	if (FT_ENABLE && pstat && pstat->ft_state) {
		val = _AUTH_ALGM_FT_;
	} else
#endif
	if (priv->pmib->dot1180211AuthEntry.dot11AuthAlgrthm > 0) {
		if (pstat) {
			if (priv->pmib->dot1180211AuthEntry.dot11AuthAlgrthm == 1) // shared key
				val = 1;
			else { // auto mode, check client algorithm
				if (pstat && pstat->AuthAlgrthm)
					val = 1;
			}
		}
		else { // client mode, use shared key if WEP is enabled
			if (priv->pmib->dot1180211AuthEntry.dot11AuthAlgrthm == 1) { // shared-key ONLY
				if (priv->pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm == _WEP_40_PRIVACY_ ||
					priv->pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm == _WEP_104_PRIVACY_)
					val = 1;
			}
			else { // auto-auth
				if (priv->pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm == _WEP_40_PRIVACY_ ||
					priv->pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm == _WEP_104_PRIVACY_) {
					if (AUTH_SEQ == 1)
						AUTH_MODE_TOGGLE_VAL((AUTH_MODE_TOGGLE ? 0 : 1));

					if (AUTH_MODE_TOGGLE)
						val = 1;
				}
			}
		}

		if (val) {
			val = cpu_to_le16(val);
			use_shared_key = 1;
		}
	}

#ifdef CONFIG_IEEE80211R
	if (FT_ENABLE && pstat && pstat->ft_state) {
		val = cpu_to_le16(val);
	} else
#endif
	if (pstat && (status != _STATS_SUCCESSFUL_))
		val = cpu_to_le16(pstat->AuthAlgrthm);
	}

#ifdef WIFI_SIMPLE_CONFIG
skip_security_check:
#endif

	pbuf = set_fixed_ie(pbuf, _AUTH_ALGM_NUM_, (unsigned char *)&val, &txinsn.fr_len);

	// setting transaction sequence number...
#if defined(CONFIG_RTK_MESH) && defined(MESH_BOOTSEQ_AUTH)
	if ((pstat) || (TRUE == isMeshMP))
#else
	if (pstat)
#endif
		val = cpu_to_le16(pstat->auth_seq);	// Mesh only
	else
		val = cpu_to_le16(AUTH_SEQ);

	pbuf = set_fixed_ie(pbuf, _AUTH_SEQ_NUM_, (unsigned char *)&val, &txinsn.fr_len);

	// setting status code...
	val = cpu_to_le16(status);
	pbuf = set_fixed_ie(pbuf, _STATUS_CODE_, (unsigned char *)&val, &txinsn.fr_len);

	// then checking to see if sending challenging text... (Mesh skip this section)
	if (pstat)
	{
		if ((pstat->auth_seq == 2) && (pstat->state & WIFI_AUTH_STATE1) && use_shared_key)
			pbuf = set_ie(pbuf, _CHLGETXT_IE_, 128, pstat->chg_txt, &txinsn.fr_len);
	}
	else
	{
		if ((AUTH_SEQ == 3) && (OPMODE & WIFI_AUTH_STATE1) && use_shared_key)
		{
			pbuf = set_ie(pbuf, _CHLGETXT_IE_, 128, CHG_TXT, &txinsn.fr_len);
			SetPrivacy(txinsn.phdr);
			DEBUG_INFO("sending a privacy pkt with auth_seq=%d\n", AUTH_SEQ);
		}
	}

#if defined(CONFIG_IEEE80211R) || defined(CONFIG_IEEE80211R_CLI)
	if (FT_ENABLE && pstat && pstat->ft_state) {
		WPA_STA_INFO *pStaInfo = pstat->wpa_sta_info;
#ifdef RTK_NL80211
		if (pStaInfo->ft_ie_len && pStaInfo->rsn_ie_len && pStaInfo->md_ie_len) {
			pbuf = set_ie(pbuf, _RSN_IE_2_, pStaInfo->rsn_ie_len, pStaInfo->rsn_ie, &txinsn.fr_len);
			pbuf = set_ie(pbuf, _MOBILITY_DOMAIN_IE_, pStaInfo->md_ie_len, pStaInfo->md_ie, &txinsn.fr_len);
			pbuf = set_ie(pbuf, _FAST_BSS_TRANSITION_IE_, pStaInfo->ft_ie_len, pStaInfo->ft_ie, &txinsn.fr_len);
		}
#else /* RTK_NL80211 */
		if (pStaInfo->isFT) {
			pbuf = set_ft_rsnie_with_pmkid(priv, pbuf, &txinsn.fr_len, pstat, 2);
		}
		pbuf = construct_mobility_domain_ie(priv, pbuf, &txinsn.fr_len);
		if (pStaInfo->isFT)
			pbuf = construct_fast_bss_transition_ie(priv, pbuf, &txinsn.fr_len, pstat);
#endif /* RTK_NL80211 */
	}
#endif

	SetFrameSubType((txinsn.phdr), WIFI_AUTH);

#if defined(CONFIG_RTK_MESH) && defined(MESH_BOOTSEQ_AUTH)
	if ((pstat) || (TRUE == isMeshMP))
#else
	if (pstat)	// for AP mode
#endif
	{
		memcpy((void *)GetAddr1Ptr((txinsn.phdr)), pstat->cmn_info.mac_addr, MACADDRLEN);
		memcpy((void *)GetAddr2Ptr((txinsn.phdr)), bssid, MACADDRLEN);
	}
	else
	{
		memcpy((void *)GetAddr1Ptr((txinsn.phdr)), bssid, MACADDRLEN);
		memcpy((void *)GetAddr2Ptr((txinsn.phdr)), GET_MY_HWADDR, MACADDRLEN);
	}

#if defined(CONFIG_RTK_MESH) && defined(MESH_BOOTSEQ_AUTH)
	/* 
	 * Though spec define management frames Address 3 is "null mac" (all zero),
	 * but avoid filter out by other MP, set "Other MP MAC" (Refer: Draft 1.06, Page 12, 7.2.3, Line 29~30 2007/08/11 by popen)
	 */
	if (TRUE == isMeshMP)
		memcpy((void *)GetAddr3Ptr((txinsn.phdr)), pstat->cmn_info.mac_addr, MACADDRLEN);
	else
#endif
		memcpy((void *)GetAddr3Ptr((txinsn.phdr)), bssid, MACADDRLEN);

#if defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI)
	txinsn.is_urgent = 1;
#endif

#ifdef CTC_WIFI_DIAG
	if (pstat) {
		ctcwifi_diag_log(priv, pstat->cmn_info.mac_addr, 1, "Authentication", (unsigned char *)(txinsn.pframe), txinsn.fr_len);
	}
#endif

	if ((rtl8192cd_firetx(priv, &txinsn)) == SUCCESS)
		return;

issue_auth_fail:

	DRV_RT_TRACE(priv, DRV_DBG_CONN_INFO, DRV_DBG_SERIOUS, "issue_auth_fail\n");	
	if (txinsn.phdr)
		release_wlanhdr_to_poll(priv, txinsn.phdr);
	if (txinsn.pframe)
		release_mgtbuf_to_poll(priv, txinsn.pframe);
}
#endif
/*	before 20181116:if pstat == NULL, indiate we are station now...
	after  20181116:
		WPA3 STA mode need alloc stat_info early,
		so dismantle it to
			1 issue_auth_resp for AP/Mesh mode
			2 issue_auth_req for STA/adhoc mode*/

void issue_auth_resp(struct rtl8192cd_priv *priv, struct stat_info *pstat, unsigned short status)
{
	struct wifi_mib *pmib;
	unsigned char	*bssid, *pbuf;
	unsigned short  val;
	int use_shared_key=0;
	int j;

	UINT8	isMeshMP = FALSE;
	struct stat_info *pstat_tmp=NULL;
	if(pstat==NULL)
		return;
	
	pmib= GET_MIB(priv);
	bssid = BSSID;
	/* avoid possible loop , when the same mac has connected.
	RTK, Atheros IC is test ok.
	Ralink test fail.
	BCM to be confirmed.
	*/
	for(j=0; j<NUM_STAT; j++){
		if (priv->pshare->aidarray[j] && (priv->pshare->aidarray[j]->used == TRUE)
#ifdef WDS
		&& !(priv->pshare->aidarray[j]->station.state & WIFI_WDS)
#endif
		)
		{
			pstat_tmp = &(priv->pshare->aidarray[j]->station);
			if(isEqualMACAddr(bssid, pstat_tmp->cmn_info.mac_addr) && pstat_tmp->expire_to){
#ifdef MULTI_MAC_CLONE
				if( (ACTIVE_ID>0) && ((GET_MIB(priv))->dot11OperationEntry.opmode & WIFI_ASOC_STATE)){
					break;
				}else
#endif
				{
					panic_printk("[%s:%d] The same mac has connected. refused\n", __FUNCTION__,__LINE__);
					return;
				}
			}
		}
	}

	DECLARE_TXINSN(txinsn);


	if(priv->pmib->dot1180211AuthEntry.dot11EnablePSK !=0) {
		//Reset 4-WAY STATE for some phones' connection issue
		if(pstat->wpa_sta_info)
			pstat->wpa_sta_info->state = PSK_STATE_IDLE;
	}

	if (pstat){
		DRV_RT_TRACE(priv, DRV_DBG_CONN_INFO, DRV_DBG_TRACE,
			"sta=%pm, status=%d\n",pstat->cmn_info.mac_addr, status);
	}

	txinsn.retry = priv->pmib->dot11OperationEntry.dot11ShortRetryLimit;


	txinsn.q_num = MANAGE_QUE_NUM;
#ifdef P2P_SUPPORT
    if(rtk_p2p_is_enabled(priv))
        txinsn.tx_rate = _6M_RATE_;
    else
#endif
    	txinsn.tx_rate = find_rate(priv, NULL, 0, 1);
#ifndef TX_LOWESTRATE
	txinsn.lowest_tx_rate = txinsn.tx_rate;
#endif
	txinsn.fixed_rate = 1;
	txinsn.fr_type = _PRE_ALLOCMEM_;

	pbuf = txinsn.pframe = get_mgtbuf_from_poll(priv);

	if (pbuf == NULL)
		goto issue_auth_resp_fail;

	txinsn.phdr = get_wlanhdr_from_poll(priv);

	if (txinsn.phdr == NULL){
		DRV_RT_TRACE(priv, DRV_DBG_CONN_INFO, DRV_DBG_SERIOUS, "txinsn.phdr == NULL\n");
		goto issue_auth_resp_fail;
	}

	memset((void *)(txinsn.phdr), 0, sizeof (struct	wlan_hdr));

	/*----------------Auth Algm Number-------------------begin*/
	/* In AP mode,	if auth is set to shared-key, use shared key
	 *		if auth is set to auto, use shared key if client use shared
	 *		otherwise set to open
	 * In client mode, if auth is set to shared-key or auto, and WEP is used,
	 *		use shared key algorithm
	 */
	val = 0;

	/*skip SIMPLE_CONFIG and Auth check ,Force use open system auth.*/
	if (TRUE == isMeshMP)
		goto skip_security_check1;


#ifdef WIFI_SIMPLE_CONFIG
	if (pmib->wscEntry.wsc_enable) {
		if ((status == _STATS_SUCCESSFUL_) && (pstat->auth_seq == 2) &&
			(pstat->state & WIFI_AUTH_SUCCESS) && (pstat->AuthAlgrthm == 0))
			goto skip_security_check1;
	}
#endif

#if defined(CONFIG_IEEE80211R) || defined(CONFIG_IEEE80211R_CLI)
	if (FT_ENABLE && pstat->ft_state) {
		val = _AUTH_ALGM_FT_;
	} else
#endif
	if (priv->pmib->dot1180211AuthEntry.dot11AuthAlgrthm > 0) {

		if (priv->pmib->dot1180211AuthEntry.dot11AuthAlgrthm == 1) // shared key
			val = 1;
		else { // auto mode, check client algorithm
			if (pstat->AuthAlgrthm && (pstat->AuthAlgrthm != _AUTH_ALGM_SAE_))
				val = 1;
		}
		if (val) {
			val = cpu_to_le16(val);
			use_shared_key = 1;
		}
	}

#ifdef CONFIG_IEEE80211R
	if (FT_ENABLE && pstat->ft_state) {
		val = cpu_to_le16(val);
	} else
#endif
	if (pstat->AuthAlgrthm == _AUTH_ALGM_SAE_)
		val = cpu_to_le16(_AUTH_ALGM_SAE_);
	else if ((status != _STATS_SUCCESSFUL_))
		val = cpu_to_le16(pstat->AuthAlgrthm);

#ifdef CONFIG_RTL_MULTI_WIFI_MODULES
	if(pstat->is_sae_sta)
		val = cpu_to_le16(_AUTH_ALGM_SAE_);
#endif

skip_security_check1:


	pbuf = set_fixed_ie(pbuf, _AUTH_ALGM_NUM_, (unsigned char *)&val, &txinsn.fr_len);
	/*----------------Auth Algm Number-------------------end*/

	/*sequence number*/
	val = cpu_to_le16(pstat->auth_seq);
	pbuf = set_fixed_ie(pbuf, _AUTH_SEQ_NUM_, (unsigned char *)&val, &txinsn.fr_len);

	/*setting status code*/
	val = cpu_to_le16(status);
	pbuf = set_fixed_ie(pbuf, _STATUS_CODE_, (unsigned char *)&val, &txinsn.fr_len);

	/*use share key case*/
	if (use_shared_key && (pstat->auth_seq == 2) && (pstat->state & WIFI_AUTH_STATE1) )
		pbuf = set_ie(pbuf, _CHLGETXT_IE_, 128, pstat->chg_txt, &txinsn.fr_len);



#if defined(CONFIG_IEEE80211R) || defined(CONFIG_IEEE80211R_CLI)

	/*construct 11r IEs*/
	if (FT_ENABLE && pstat->ft_state) {
#ifdef RTK_NL80211
		WPA_STA_INFO *pStaInfo = pstat->wpa_sta_info;
		if (pStaInfo->ft_ie_len && pStaInfo->rsn_ie_len && pStaInfo->md_ie_len) {
			pbuf = set_ie(pbuf, _RSN_IE_2_, pStaInfo->rsn_ie_len, pStaInfo->rsn_ie, &txinsn.fr_len);
			pbuf = set_ie(pbuf, _MOBILITY_DOMAIN_IE_, pStaInfo->md_ie_len, pStaInfo->md_ie, &txinsn.fr_len);
			pbuf = set_ie(pbuf, _FAST_BSS_TRANSITION_IE_, pStaInfo->ft_ie_len, pStaInfo->ft_ie, &txinsn.fr_len);
		}
#else /* RTK_NL80211 */
		WPA_STA_INFO *pStaInfo = pstat->wpa_sta_info;
		if (pStaInfo->isFT) {
			pbuf = set_ft_rsnie_with_pmkid(priv, pbuf, &txinsn.fr_len, pstat, 2);
		}
		pbuf = construct_mobility_domain_ie(priv, pbuf, &txinsn.fr_len);
		if (pStaInfo->isFT)
			pbuf = construct_fast_bss_transition_ie(priv, pbuf, &txinsn.fr_len, pstat);
#endif
	}
#endif

#ifdef RTK_NL80211
	if(pstat->is_sae_sta){
		WPA_STA_INFO *pStaInfo = pstat->wpa_sta_info;
		pbuf = set_fixed_ie(pbuf,pStaInfo->sae_ie_len,pStaInfo->sae_ie,&txinsn.fr_len);
	}
#endif
	SetFrameSubType((txinsn.phdr), WIFI_AUTH);

	memcpy((void *)GetAddr1Ptr((txinsn.phdr)), pstat->cmn_info.mac_addr, MACADDRLEN);
	memcpy((void *)GetAddr2Ptr((txinsn.phdr)), bssid, MACADDRLEN);

	/*
		Though spec define management frames Address 3 is "null mac" (all zero),
		but avoid filter out by other MP, set "Other MP MAC")
		(Refer: Draft 1.06, Page 12, 7.2.3, Line 29~30 2007/08/11 by popen)
	*/

	if (TRUE == isMeshMP)
		memcpy((void *)GetAddr3Ptr((txinsn.phdr)), pstat->cmn_info.mac_addr, MACADDRLEN);
	else
		memcpy((void *)GetAddr3Ptr((txinsn.phdr)), bssid, MACADDRLEN);

#if defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI)
	txinsn.is_urgent = 1;
#endif
	log("resp %pm",pstat->cmn_info.mac_addr);

#ifdef CTC_WIFI_DIAG
	if (pstat) {
		ctcwifi_diag_log(priv, pstat->cmn_info.mac_addr, 1, "Authentication", (unsigned char *)(txinsn.pframe), txinsn.fr_len);
	}
#endif

	if ((rtl8192cd_firetx(priv, &txinsn)) == SUCCESS)
		return;
issue_auth_resp_fail:
	log("issue_auth_resp_fail %pm",pstat->cmn_info.mac_addr);

	if (txinsn.phdr)
		release_wlanhdr_to_poll(priv, txinsn.phdr);
	if (txinsn.pframe)
		release_mgtbuf_to_poll(priv, txinsn.pframe);
}

#ifdef SUPPORT_WPAS_SAE
int handle_wpas_sae_auth(
	struct rtl8192cd_priv *priv, unsigned char* peermac)
{
	struct stat_info *pstat=NULL;
	unsigned int t_stamp_1 = priv->pmib->dot11Bss.t_stamp[1];
	//struct pmksa_from_wpas *db=NULL;
	s32 ret = 0;
	//s32 inster_pmkod_ret = 0;
	u8 *pmkid_ptr = NULL;
	u8  pmkid_cnt = 0;
	wpaslog("peer[%pm]",priv->pmib->dot11Bss.bssid);

	/*DUT support WPA3, peer support WPA3*/
	if(support_wpa3(priv) && peer_support_wpa3(priv,t_stamp_1)){
		pstat = get_stainfo(priv,peermac);
		if(pstat==NULL){
			//log("advance alloc_sta for WPA3 STA mode");
			pstat = alloc_stainfo(priv, peermac, -1);
			if (pstat == NULL) {
				wpaslog("err");
				return ISSUE_AUTH_FAIL;
			}else{
				pstat->is_sae_sta = 1;
			}
		}else{
			pstat->is_sae_sta = 1;
		}

		/*if pmkid cache existed inster PMKID and go ISSUE_AUTH_GO_ON_NORMAL case*/
#if 1
		if(priv->pmib->dot11RsnIE.rsnielen >=24){
			ret = wpa2_ie_check(priv,priv->pmib->dot11RsnIE.rsnie,
				(int) (*(priv->pmib->dot11RsnIE.rsnie+1))+2, &pmkid_ptr , &pmkid_cnt);
			if(ret) wpaslog("ret[%d]",ret);

			if(pmkid_cnt){
				wpaslog("pmkid cache existed;go on normal");
				return ISSUE_AUTH_GO_ON_NORMAL;
			}
		}
#endif

		/*offload auth_req to wpas*/
		wpaslog("go on SAE");
		return ISSUE_AUTH_GO_ON_SAE;
	}
	else{
		/*go on normal issue_auth*/
		return ISSUE_AUTH_GO_ON_NORMAL;
	}
}

#endif
#ifdef AUTH_SAE_STA
/*for STA mode handle SAE auth*/
int handle_sae_auth(
	struct rtl8192cd_priv *priv, unsigned char* peermac)
{
	struct stat_info *pstat=NULL;
	unsigned char pmk_cache_idx=0;
	struct pmkid_caching *pmkid_cache_ptr = &priv->wpa_global_info->pmkid_cache;
	unsigned int t_stamp_1 = priv->pmib->dot11Bss.t_stamp[1];
	u8 with_h2e = 0;

	if(support_wpa3(priv) && peer_support_wpa3(priv,t_stamp_1)){
		log("DUT support WPA3, peer support WPA3");

		/*check if the peer mac on blacklist*/
		if(on_blacklist(priv, peermac)){
			log("peer on blacklist ignore it");
			return ISSUE_AUTH_BLACKLIST;
		}
		pstat = get_stainfo(priv,peermac);
		log("pstat[%p]",pstat);
		if(pstat==NULL){
			log("advance alloc_sta for WPA3 STA mode");
			pstat = alloc_stainfo(priv, peermac, -1);
			if (pstat == NULL) {
				log("fail, CHK!!");
				return ISSUE_AUTH_FAIL;
			}else{
				log("is_sae_sta , pstat's ptr[%p]",pstat);
				pstat->is_sae_sta = 1;
#ifdef ENABLE_SAE_H2E
				if ( peer_support_h2e(priv,t_stamp_1) ) {
					pstat->with_h2e = 1;
					with_h2e = 1;
				} else
					pstat->with_h2e = 0;
#endif
				log("is_sae_sta , pstat's ptr[%p] h2e_%d !!!!!!\n",
					pstat, pstat->with_h2e);
			}
		}
		/*check if PMK cached exist
		log("peer[%pm]",priv->pmib->dot11Bss.bssid);
		dump_hex("PMKID cache",pmkid_cache_ptr->pmkid[0],3);
		dump_hex("PMK cache",pmkid_cache_ptr->pmk[0],3);
		*/
		pstat->pmkid_caching_idx = search_by_mac_pmkid_cache(priv, pstat->cmn_info.mac_addr);
#ifdef RTK_MULTI_AP
		if(pmkid_cached(pstat) && !IS_VXD_INTERFACE(priv)) {
#else
		if(pmkid_cached(pstat)) {
#endif
			pmk_cache_idx = pstat->pmkid_caching_idx;
			log("pmk cache exist,use cached PMK/PMKID ,idx[%d]",pmk_cache_idx);

			memcpy(pstat->wpa_sta_info->PMK, &pmkid_cache_ptr->pmk[pmk_cache_idx], LEN_PMK);

			memcpy(pstat->sae_pmk, &pmkid_cache_ptr->pmk[pmk_cache_idx], LEN_PMK);

			memcpy(pstat->sae_pmkid, &pmkid_cache_ptr->pmkid[pmk_cache_idx], LEN_PMKID);

			dump_hex("cached PMK", pstat->sae_pmk , LEN_PMK);

			dump_hex("cached PMKID", pstat->sae_pmkid, LEN_PMKID);


			psk_init(priv);
			log("go on normal auth");
			/*go on normal issue_auth*/
			return ISSUE_AUTH_GO_ON_NORMAL;
		} else {
			log("no pmk cache,Starting SAE");
			client_send_commit_to_peer(priv, peermac, with_h2e);

			/*sae case goto wpa3_sae_auth_way*/
			return ISSUE_AUTH_GO_ON_SAE;
		}
	}
	else{
		/*go on normal issue_auth*/
		return ISSUE_AUTH_GO_ON_NORMAL;
	}
}

#endif
/*call by STA/adhoc mode*/
void issue_auth_req(
	struct rtl8192cd_priv *priv,
	struct stat_info *pstat, unsigned short status)
{
	struct wifi_mib *pmib;
	unsigned char *bssid, *pbuf;
	unsigned short val;
	int use_shared_key = 0;
#if	defined( AUTH_SAE_STA ) || defined(SUPPORT_WPAS_SAE)
	int sae_ret = 0;
#endif
	unsigned char my_auth_type = priv->pmib->dot1180211AuthEntry.dot11AuthAlgrthm;
	unsigned char my_ency_type = priv->pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm;

	pmib = GET_MIB(priv);
	bssid = priv->pmib->dot11Bss.bssid;
	//log("to peer[%pm]",bssid);
#ifdef SUPPORT_WPAS_SAE
		//if pmkid_exist   go on normal case
		/*execute SAE*/
		if (GET_CFG80211_REPORT_MGMT(priv, IEEE80211_STYPE_AUTH)) {
			sae_ret = handle_wpas_sae_auth(priv, bssid);
			if (sae_ret == ISSUE_AUTH_GO_ON_NORMAL) {
				wpaslog("normal auth");
			} else 
			{
				wpaslog("event wpas to prepare auth-sae-commit");
				sae_ret = wpas_issue_sae_auth_commit(priv);
				if (sae_ret) {
					if (PENDING_REAUTH_TIMER)
						DELETE_REAUTH_TIMER;
					MOD_REAUTH_TIMER(RTL_SECONDS_TO_JIFFIES(2));
				}
				return;
			}
		}
#endif
#ifdef AUTH_SAE_STA
	/*STA mode , deal WPA3 with peer AP:
		when peer Ap support  WPA3	after handle_sae_auth() peer's pstat will be created*/
	sae_ret = handle_sae_auth(priv, bssid);
	if (sae_ret == ISSUE_AUTH_FAIL) {
		log("fail");
		return;
	} else if (sae_ret == ISSUE_AUTH_GO_ON_SAE) {
		log("SAE_AUTH");
		return;
	}else if(sae_ret ==ISSUE_AUTH_BLACKLIST){
		log("ignore on blacklisk peer");
		return;
	}
#endif

#ifdef RTK_MULTI_AP
	if(OPMODE & WIFI_STATION_STATE){
		if((priv->pmib->multi_ap.multiap_bss_type & BIT(7)) &&
			(priv->pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm == _NO_PRIVACY_) &&
			(!priv->pmib->wscEntry.wsc_enable)){
			DEBUG_INFO("[MAP]Issue auth request to open BSS not allowed\n");
			return;
		}
	}
#endif

#if defined(INCLUDE_WPA_PSK)
	if (priv->assoc_reject_on && (memcmp(priv->assoc_reject_mac, bssid, MACADDRLEN) == 0)){
		DEBUG_INFO("[%s:%d] assoc_reject_on=1, "MACSTR"\n", __func__, __LINE__, MAC2STR(priv->assoc_reject_mac));
		DRV_RT_TRACE(priv, DRV_DBG_CONN_INFO, DRV_DBG_SERIOUS,
			"assoc_reject_mac=%pm\n",priv->assoc_reject_mac);
		return;
	}
#endif

	/*from here , if there is error
		need goto exit_issue_auth_req for free txinsn*/
	DECLARE_TXINSN(txinsn);
	txinsn.retry = priv->pmib->dot11OperationEntry.dot11ShortRetryLimit;

	txinsn.q_num = MANAGE_QUE_NUM;
#ifdef P2P_SUPPORT
	if (rtk_p2p_is_enabled(priv))
		txinsn.tx_rate = _6M_RATE_;
	else
#endif
		txinsn.tx_rate = find_rate(priv, NULL, 0, 1);
#ifndef TX_LOWESTRATE
	txinsn.lowest_tx_rate = txinsn.tx_rate;
#endif
	txinsn.fixed_rate = 1;
	txinsn.fr_type = _PRE_ALLOCMEM_;

	pbuf = txinsn.pframe = get_mgtbuf_from_poll(priv);

	if (pbuf == NULL)
		goto exit_issue_auth_req;

	txinsn.phdr = get_wlanhdr_from_poll(priv);

	if (txinsn.phdr == NULL){
		DRV_RT_TRACE(priv, DRV_DBG_CONN_INFO, DRV_DBG_SERIOUS, "txinsn.phdr == NULL\n");
		goto exit_issue_auth_req;
	}

	memset((void *)(txinsn.phdr), 0, sizeof(struct wlan_hdr));

	/*----------------auth algm number-----------------begin*/

	/* In AP mode,	if auth is set to shared-key, use shared key
	 *				if auth is set to auto, use shared key if client use shared
	 *				otherwise set to open
	 * In client mode, if auth is set to shared-key or auto, and WEP is used,
	 *				use shared key algorithm
	 */
	val = CONFIG_AUTH_OPEN;
#ifdef WIFI_SIMPLE_CONFIG
	if (pmib->wscEntry.wsc_enable && (AUTH_SEQ == 1)) {
		/*sta mode wps be trigger, skip auth type check */
	} else
#endif
	if (my_auth_type > 0) {
		/*client mode, use shared key if WEP is enabled */
		if (my_auth_type == CONFIG_AUTH_WEP_SHARED) {	// shared-key ONLY
			if (my_ency_type == _WEP_40_PRIVACY_ || my_ency_type == _WEP_104_PRIVACY_)
				val = CONFIG_AUTH_WEP_SHARED;
		} else {
			/*auto-auth(dot11AuthAlgrthm==2) */
			if (my_ency_type == _WEP_40_PRIVACY_ || my_ency_type == _WEP_104_PRIVACY_) {
				if (AUTH_SEQ == CONFIG_AUTH_WEP_SHARED)
					AUTH_MODE_TOGGLE_VAL((AUTH_MODE_TOGGLE ? 0 : 1));

				if (AUTH_MODE_TOGGLE)
					val = CONFIG_AUTH_WEP_SHARED;
			}
		}
		if (val) {
			val = cpu_to_le16(val);
			use_shared_key = CONFIG_AUTH_WEP_SHARED;
			log("auth type == share key");
		}
	}
	//log("my AuthType=[%d]",val);
	pbuf = set_fixed_ie(pbuf, _AUTH_ALGM_NUM_, (unsigned char *)&val, &txinsn.fr_len);
	/*----------------auth algm number-----------------begin*/

	/*sequence number */
	val = cpu_to_le16(AUTH_SEQ);
	pbuf = set_fixed_ie(pbuf, _AUTH_SEQ_NUM_, (unsigned char *)&val, &txinsn.fr_len);

	/*status code */
	val = cpu_to_le16(status);
	pbuf = set_fixed_ie(pbuf, _STATUS_CODE_, (unsigned char *)&val, &txinsn.fr_len);

	/*auth type == share key */
	if (use_shared_key && (AUTH_SEQ == 3) && (OPMODE & WIFI_AUTH_STATE1)) {
		pbuf = set_ie(pbuf, _CHLGETXT_IE_, 128, CHG_TXT, &txinsn.fr_len);
		SetPrivacy(txinsn.phdr);
		DEBUG_INFO("sending a privacy pkt with auth_seq=%d\n", AUTH_SEQ);
	}

	SetFrameSubType((txinsn.phdr), WIFI_AUTH);
	memcpy((void *)GetAddr1Ptr((txinsn.phdr)), bssid, MACADDRLEN);
	memcpy((void *)GetAddr2Ptr((txinsn.phdr)), GET_MY_HWADDR, MACADDRLEN);
	memcpy((void *)GetAddr3Ptr((txinsn.phdr)), bssid, MACADDRLEN);

	//log("ch=[%d]",priv->pmib->dot11RFEntry.dot11channel);

#if defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI)
	txinsn.is_urgent = 1;
#endif

#ifdef CTC_WIFI_DIAG
	if (pstat) {
		ctcwifi_diag_log(priv, pstat->cmn_info.mac_addr, 1, "Authentication", (unsigned char *)(txinsn.pframe), txinsn.fr_len);
	}
#endif

	if ((rtl8192cd_firetx(priv, &txinsn)) == SUCCESS){
		log("done");
		return;
	}

exit_issue_auth_req:

	if (txinsn.phdr)
		release_wlanhdr_to_poll(priv, txinsn.phdr);
	if (txinsn.pframe)
		release_mgtbuf_to_poll(priv, txinsn.pframe);
}

void issue_asocrsp(struct rtl8192cd_priv *priv, unsigned short status, struct stat_info *pstat, int pkt_type, unsigned int assoc_disallow)
{
	unsigned short	val;
	struct wifi_mib *pmib;
	unsigned char	*bssid,*pbuf;

#ifdef CONFIG_IEEE80211W
	unsigned char iebuf[5];
	unsigned int timeout;
#endif

	/*process all ext cap IE(107)*/
	unsigned char extended_cap_ie[8];
    DECLARE_TXINSN(txinsn);

	memset(extended_cap_ie,0,8);

#ifdef TLN_STATS
	stats_conn_status_counts(priv, status);
#endif

	txinsn.retry = priv->pmib->dot11OperationEntry.dot11ShortRetryLimit;

	pmib= GET_MIB(priv);

	bssid = pmib->dot11StationConfigEntry.dot11Bssid;

	txinsn.q_num = MANAGE_QUE_NUM;
	txinsn.fr_type = _PRE_ALLOCMEM_;
#ifdef P2P_SUPPORT	/*cfg p2p cfg p2p*/
	if(rtk_p2p_is_enabled(priv)){
      	txinsn.tx_rate = _6M_RATE_;
	}else
#endif    
    	txinsn.tx_rate = find_rate(priv, NULL, 0, 1);
#ifndef TX_LOWESTRATE
	txinsn.lowest_tx_rate = txinsn.tx_rate;
#endif	
	txinsn.fixed_rate = 1;
	pbuf = txinsn.pframe  = get_mgtbuf_from_poll(priv);

	if(pstat)
		DRV_RT_TRACE(priv, DRV_DBG_CONN_INFO, DRV_DBG_TRACE, "sta=%pm,status=%d\n", pstat->cmn_info.mac_addr, status);

#ifdef CONFIG_RTL_88E_SUPPORT
	if (GET_CHIP_VER(priv)==VERSION_8188E) {
		update_remapAid(priv,pstat);
		if (!pstat->cmn_info.ra_info.disable_ra)
		{
			RTL8188E_MACID_NOLINK(priv, (status == _STATS_SUCCESSFUL_)?0:1, REMAP_AID(pstat));
			RTL8188E_MACID_PAUSE(priv, 0, REMAP_AID(pstat));
            pstat->txpause_flag = 0;            
		}
	}
#endif

#ifdef CONFIG_WLAN_HAL
        if (IS_HAL_CHIP(priv)) {
            if (pstat && (status == _STATS_SUCCESSFUL_)) {
				GET_HAL_INTERFACE(priv)->UpdateHalMSRRPTHandler(priv, pstat, INCREASE);
				pstat->txpdrop_flag = 0;
                GET_HAL_INTERFACE(priv)->SetMACIDSleepHandler(priv, 0, REMAP_AID(pstat));
				if (pstat->txpause_flag) {
					pstat->txpause_flag = 0;
					if (priv->pshare->paused_sta_num)
						priv->pshare->paused_sta_num--;
				}
                DEBUG_WARN("[%s][%s][%d] set MACID %d\n", __FUNCTION__, priv->dev->name, pstat->cmn_info.aid, REMAP_AID(pstat));
            }
        }
#endif

#ifdef CONFIG_RTL_8812_SUPPORT
	if (GET_CHIP_VER(priv)== VERSION_8812E) {
        if (pstat && (status == _STATS_SUCCESSFUL_)) {
			UpdateHalMSRRPT8812(priv, pstat, INCREASE);
			pstat->txpdrop_flag = 0;
			RTL8812_MACID_PAUSE(priv, 0, REMAP_AID(pstat));
			if (pstat->txpause_flag) {
				pstat->txpause_flag = 0;
				if (priv->pshare->paused_sta_num)
					priv->pshare->paused_sta_num--;
			}
        }	
	}
#endif

	if (pbuf == NULL)
		goto issue_asocrsp_fail;

	txinsn.phdr = get_wlanhdr_from_poll(priv);

	if (txinsn.phdr == NULL)
		goto issue_asocrsp_fail;

	memset((void *)txinsn.phdr, 0, sizeof(struct  wlan_hdr));

	val = cpu_to_le16(BIT(0));

	if (pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm)
		val |= cpu_to_le16(BIT(4));

	if (SHORTPREAMBLE)
		val |= cpu_to_le16(BIT(5));

	if (priv->pmib->dot11ErpInfo.shortSlot)
		val |= cpu_to_le16(BIT(10));

#ifdef RTK_AC_SUPPORT //for 11ac logo
	if(priv->pshare->rf_ft_var.lpwrc)
		val |= cpu_to_le16(BIT(8));	/* set spectrum mgt */
#endif		
#ifdef DOT11K
	if(priv->pmib->dot11StationConfigEntry.dot11SMMeasurementActivated)
		val |= cpu_to_le16(BIT(8));	/* set spectrum mgt measurement */

	if(priv->pmib->dot11StationConfigEntry.dot11RadioMeasurementActivated)
		val |= cpu_to_le16(BIT(12));   /* set radio measurement */
#endif

#ifdef HAPD_11K
	if(priv->hapd_11k_ie_len){
		val |= cpu_to_le16(BIT(12));   /* set radio measurement */
	}
#endif

#if defined(WMM_APSD)
	if (APSD_ENABLE) 
		val |= cpu_to_le16(BIT(11));
#endif	

	pbuf = set_fixed_ie(pbuf, _CAPABILITY_, (unsigned char *)&val, &txinsn.fr_len);

	val = cpu_to_le16(status);
	pbuf = set_fixed_ie(pbuf, _STATUS_CODE_, (unsigned char *)&val, &txinsn.fr_len);

	val = cpu_to_le16(pstat->cmn_info.aid | 0xC000);
	pbuf = set_fixed_ie(pbuf, _ASOC_ID_, (unsigned char *)&val, &txinsn.fr_len);

	if (STAT_OPRATE_LEN > 0) {
		if (STAT_OPRATE_LEN <= 8)
			pbuf = set_ie(pbuf, _SUPPORTEDRATES_IE_, STAT_OPRATE_LEN, STAT_OPRATE, &txinsn.fr_len);
		else {
			pbuf = set_ie(pbuf, _SUPPORTEDRATES_IE_, 8, STAT_OPRATE, &txinsn.fr_len);
			pbuf = set_ie(pbuf, _EXT_SUPPORTEDRATES_IE_, STAT_OPRATE_LEN-8, STAT_OPRATE+8, &txinsn.fr_len);
		}
	}

#ifdef DOT11K
    if(pmib->dot11StationConfigEntry.dot11RadioMeasurementActivated)
    {
        pbuf = construct_rm_enable_cap_ie(priv, pbuf, &txinsn.fr_len);
    }
#endif

#ifdef HAPD_11K
	if (priv->hapd_11k_ie_len) {
		/*priv->hapd_11k_ie_len  include IE(ID)+LEN+VAL */
		memcpy(pbuf, priv->hapd_11k_ie, priv->hapd_11k_ie_len);
		pbuf += priv->hapd_11k_ie_len;
		txinsn.fr_len += priv->hapd_11k_ie_len;
	}
#endif

#ifdef CONFIG_IEEE80211R
	if (FT_ENABLE && pstat->ft_state) {
		unsigned char *mdie, *ftie, *rsnie;
		unsigned int mdie_len, ftie_len, rsnie_len;
#ifdef RTK_NL80211
		if (pstat->ft_state == state_ft_assoc || pstat->ft_state == state_imd_assoc) {
		
			FTDEBUG("construct ft-ie to assoc-rsp\n");
			WPA_STA_INFO *pStaInfo = pstat->wpa_sta_info;
			
			if (pStaInfo->rsn_ie_len)
				pbuf = set_ie(pbuf, _RSN_IE_2_, pStaInfo->rsn_ie_len, pStaInfo->rsn_ie, &txinsn.fr_len);

			if (pStaInfo->md_ie_len)
				pbuf = set_ie(pbuf, _MOBILITY_DOMAIN_IE_, pStaInfo->md_ie_len, pStaInfo->md_ie, &txinsn.fr_len);
			if (pStaInfo->ft_ie_len)
				pbuf = set_ie(pbuf, _FAST_BSS_TRANSITION_IE_, pStaInfo->ft_ie_len, pStaInfo->ft_ie, &txinsn.fr_len);
		}
#else /* RTK_NL80211 */
		if (pstat->ft_state == state_ft_assoc && pstat->wpa_sta_info->isFT) {
			rsnie = pbuf;
			pbuf = set_ft_rsnie_with_pmkid(priv, pbuf, &txinsn.fr_len, pstat, 1);
			rsnie_len = pbuf - rsnie;
		}

		mdie = pbuf;
		pbuf = construct_mobility_domain_ie(priv, pbuf, &txinsn.fr_len);
		mdie_len = pbuf - mdie;
		
		if (pstat->wpa_sta_info->RSNEnabled) {
			ftie = pbuf;
			pbuf = construct_fast_bss_transition_ie(priv, pbuf, &txinsn.fr_len, pstat);
			ftie_len = pbuf - ftie;

			if (pstat->ft_state == state_ft_assoc && pstat->wpa_sta_info->isFT) {
				calc_ft_mic(priv, pstat, rsnie, rsnie_len, mdie, mdie_len, ftie, ftie_len, 6);
			}
		}

		if (status == _STATS_SUCCESSFUL_ && pstat->ft_state == state_ft_assoc) {
			FT_IndicateEvent(priv, pstat, DOT11_EVENT_FT_ASSOC_IND, NULL);
		}

		pstat->ft_auth_expire_to = 0;
#endif /* RTK_NL80211 */
	}
#endif

#ifdef CONFIG_IEEE80211W	
	if(status == _STATS_ASSOC_REJ_TEMP_ && pstat->isPMF) {		
		iebuf[0] = ASSOC_COMEBACK_TIME;

        timeout = RTL_JIFFIES_TO_MILISECONDS(pstat->sa_query_end - jiffies);
		if(timeout < SA_QUERY_MAX_TO)
			timeout++;
        else if (timeout > SA_QUERY_MAX_TO)
            timeout = SA_QUERY_MAX_TO;
        
		PMFDEBUG("ASSOC comeback time, timeout=%d\n", timeout);
		timeout = cpu_to_le32(timeout);
		memcpy(&iebuf[1], &timeout, 4);
		pbuf = set_ie(pbuf, EID_TIMEOUT_INTERVAL, 5, iebuf, &txinsn.fr_len);
	}
#endif

#ifdef HS2_SUPPORT
	HS2_DEBUG_INFO("Driver:pmib->hs2Entry.QoSMap_ielen[0]=%d\n\n",pmib->hs2Entry.QoSMap_ielen[0]);
	if(pmib->hs2Entry.QoSMap_ielen[0]) {
		pbuf = set_ie(pbuf, _QOS_MAP_SET_IE_, pmib->hs2Entry.QoSMap_ielen[0], pmib->hs2Entry.QoSMap_ie[0], &txinsn.fr_len);
	}
#endif

#ifdef WIFI_WMM
	//Set WMM Parameter Element
	if ((QOS_ENABLE) && (pstat->QosEnabled))
		pbuf = set_ie(pbuf, _RSN_IE_1_, _WMM_Para_Element_Length_, GET_WMM_PARA_IE, &txinsn.fr_len);
#endif

#ifdef ENABLE_SAE_H2E
	// issue_asso_rsp
	if ( support_wpa3(priv) && pmib->dot1180211AuthEntry.dot11SAEPwe != 0 ) {
		u8 tmp[2];
		size_t flen;

		flen = construct_rsnxe_ie(tmp);
		pbuf = set_ie(pbuf, _RSNX_IE_, flen, tmp, &txinsn.fr_len);
	}
#endif

#ifdef WIFI_SIMPLE_CONFIG
/*modify for WPS2DOTX SUPPORT*/
	if (pmib->wscEntry.wsc_enable && pmib->wscEntry.assoc_ielen
		&& (priv->pmib->dot11StationConfigEntry.dot11AclMode != ACL_ALLOW || priv->pmib->dot11StationConfigEntry.dot11AclNum > 0)
		&& (txinsn.fr_len + pmib->wscEntry.assoc_ielen <= (PRE_ALLOCATED_BUFSIZE*4))) {
		memcpy(pbuf, pmib->wscEntry.assoc_ie, pmib->wscEntry.assoc_ielen);
		pbuf += pmib->wscEntry.assoc_ielen;
		txinsn.fr_len += pmib->wscEntry.assoc_ielen;
	}
#endif

	if ((priv->pmib->dot11BssType.net_work_type & WIRELESS_11N) && (pstat->ht_cap_len > 0)) {
		if (!should_restrict_Nrate(priv, pstat)) {
			pbuf = set_ie(pbuf, _HT_CAP_, priv->ht_cap_len, (unsigned char *)&priv->ht_cap_buf, &txinsn.fr_len);
			pbuf = set_ie(pbuf, _HT_IE_, priv->ht_ie_len, (unsigned char *)&priv->ht_ie_buf, &txinsn.fr_len);
			//pbuf = construct_ht_ie_old_form(priv, pbuf, &txinsn.fr_len);
		}

#ifdef WIFI_11N_2040_COEXIST
		if (priv->pmib->dot11nConfigEntry.dot11nCoexist &&
			(priv->pmib->dot11BssType.net_work_type & WIRELESS_11G)) {

			extended_cap_ie[0] |= _2040_COEXIST_SUPPORT_;  // byte0
			if (priv->pshare->is_40m_bw) {
				construct_obss_scan_para_ie(priv);
				pbuf = set_ie(pbuf, _OBSS_SCAN_PARA_IE_, priv->obss_scan_para_len,
						(unsigned char *)&priv->obss_scan_para_buf, &txinsn.fr_len);
			}
		}
#endif
	}
	
#if defined(STA_CONTROL) && defined(DOT11K) && defined(STA_CONTROL_BAND_TRANSITION) && defined(CONFIG_IEEE80211V)
	if (priv->stactrl.stactrl_priv_sc != NULL && status == _STATS_REJ_BSS_TRANSITION) {
		struct rtl8192cd_priv *priv_sc = priv->stactrl.stactrl_priv_sc;
		pbuf = construct_neighbor_report_ie(pbuf, &txinsn.fr_len, &priv_sc->band_trans_neighbor_report);
	}
#endif 

#ifdef RTK_AC_SUPPORT //for 11ac logo
	if((priv->pmib->dot11BssType.net_work_type & WIRELESS_11AC) && (!should_restrict_Nrate(priv, pstat)) && (pstat->vht_cap_len > 0)) 
	if((priv->pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm != _WEP_40_PRIVACY_)
		&& (priv->pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm != _WEP_104_PRIVACY_))
	{
		//41 operting mode
		{
			extended_cap_ie[7] |= 0x40;
		}
		
//60, 61
		construct_vht_ie(priv, priv->pshare->working_channel);
		pbuf = set_ie(pbuf, EID_VHTCapability, priv->vht_cap_len, (unsigned char *)&priv->vht_cap_buf, &txinsn.fr_len);
		pbuf = set_ie(pbuf, EID_VHTOperation, priv->vht_oper_len, (unsigned char *)&priv->vht_oper_buf, &txinsn.fr_len);
// 66
		if(priv->pshare->rf_ft_var.opmtest&1)
			pbuf = set_ie(pbuf, EID_VHTOperatingMode, 1, (unsigned char *)&(priv->pshare->rf_ft_var.oper_mode_field), &txinsn.fr_len);		
		
	}
#endif

#if defined(TV_MODE) || defined(A4_STA)
    val = 0;
#ifdef A4_STA
    if(priv->pmib->miscEntry.a4_enable == 2) {
        if(pstat->state & WIFI_A4_STA) {
            val |= BIT0;
        }
    }
#endif

#ifdef TV_MODE
    val |= BIT1;
#endif
    if(val)
        pbuf = construct_ecm_tvm_ie(priv, pbuf, &txinsn.fr_len, val);
#endif //defined(TV_MODE) || defined(A4_STA)

#ifdef CONFIG_MBO
	// MBO-OCE IE
	pbuf = construct_mbo_ie(pbuf, &txinsn.fr_len, assoc_disallow);

#endif

#ifdef RTK_MULTI_AP
	if(pstat->multiap_profile) {
		// int i;
		unsigned char map_bss_type = 0;
		unsigned short map_vlan_id = 0;
		map_bss_type |= priv->pmib->multi_ap.multiap_bss_type;
		// if (GET_ROOT(priv)->pmib->miscEntry.vap_enable) {
		// 	for (i=0; i<RTL8192CD_NUM_VWLAN; i++) {
		// 		if (IS_DRV_OPEN(GET_ROOT(priv)->pvap_priv[i]))
		// 			map_bss_type |= GET_ROOT(priv)->pvap_priv[i]->pmib->multi_ap.multiap_bss_type;
		// 	}
		// }
		if(map_bss_type) {
			if (MAP_VLAN_ENABLE) {
				map_vlan_id = MAP_VLAN_ID;
			}
			printk("Sending association response with Multi AP IE (vid: %d)\n", map_vlan_id);
			pbuf = construct_multiap_ie(pbuf, &txinsn.fr_len, GET_MAP_PROFILE(priv), map_bss_type, map_vlan_id);
		}
	}
#endif

	// Realtek proprietary IE
	if (priv->pshare->rtk_ie_len)
		pbuf = set_ie(pbuf, _RSN_IE_1_, priv->pshare->rtk_ie_len, priv->pshare->rtk_ie_buf, &txinsn.fr_len);

#ifdef P2P_SUPPORT/*cfg p2p cfg p2p*/
	if((rtk_p2p_is_enabled(priv)) && rtk_p2p_chk_role(priv,P2P_TMP_GO)){
		if(pstat->is_p2p_client){
			if(priv->p2pPtr->p2p_assoc_RspIe_len){
				memcpy(pbuf, priv->p2pPtr->p2p_assoc_RspIe , priv->p2pPtr->p2p_assoc_RspIe_len);
				pbuf += priv->p2pPtr->p2p_assoc_RspIe_len;
				txinsn.fr_len += priv->p2pPtr->p2p_assoc_RspIe_len;
			}
		}			
	}
#endif

#ifdef RTK_NL80211
	/*RSNXE*/
	if(priv->rsn_xe_len){
		memcpy(pbuf, priv->rsn_xe, priv->rsn_xe_len);
		pbuf += priv->rsn_xe_len;
		txinsn.fr_len += priv->rsn_xe_len;
	}
#endif

	#ifdef HS2_SUPPORT	/*process ext cap IE(IE ID=107) for HS2*/
	if (priv->pmib->hs2Entry.interworking_ielen)
	{	
			// byte0
		if (priv->proxy_arp){
			extended_cap_ie[1] |=_PROXY_ARP_ ;
		}
		
		if ((priv->pmib->hs2Entry.timezone_ielen!=0) && (priv->pmib->hs2Entry.timeadvt_ielen)){
			extended_cap_ie[3] |= _UTC_TSF_OFFSET_ ;
		}
		extended_cap_ie[3] |= _INTERWORKING_SUPPORT_ ;			
		//HS2_CHECK
		if(priv->pmib->hs2Entry.QoSMap_ielen[0] || priv->pmib->hs2Entry.QoSMap_ielen[1])
			extended_cap_ie[4] |= _QOS_MAP_; // QoS MAP (Bit32) 		
				
		extended_cap_ie[5] |= _WNM_NOTIFY_; //WNM notification, Bit46
			
	}
	#endif
#ifdef TDLS_SUPPORT 
	if(priv->pmib->dot11OperationEntry.tdls_prohibited){ 
		extended_cap_ie[4] |= _TDLS_PROHIBITED_;	// bit 38
	}else{
		if(priv->pmib->dot11OperationEntry.tdls_cs_prohibited){ 
			extended_cap_ie[4] |= _TDLS_CS_PROHIBITED_;	// bit 39
		}
	}
#endif
#ifdef CONFIG_IEEE80211V
	if(WNM_ENABLE)
		extended_cap_ie[2] |=_BSS_TRANSITION_ ; // bit 19
#endif

#ifdef HAPD_11V
	if(priv->hapd_11v_enable)
		extended_cap_ie[2] |= _BSS_TRANSITION_ ; // bit 19
#endif

	/*===========ext cap IE all in here! so far (HS2, AC,TDLS )!!=================*/
	pbuf = set_ie(pbuf, _EXTENDED_CAP_IE_, 8, extended_cap_ie, &txinsn.fr_len);
	/*===========ext cap IE all in here!!!=================*/
	

	if ((pkt_type == WIFI_ASSOCRSP) || (pkt_type == WIFI_REASSOCRSP))
		SetFrameSubType((txinsn.phdr), pkt_type);
	else
		goto issue_asocrsp_fail;

	memcpy((void *)GetAddr1Ptr((txinsn.phdr)), pstat->cmn_info.mac_addr, MACADDRLEN);
	memcpy((void *)GetAddr2Ptr((txinsn.phdr)), bssid, MACADDRLEN);
	memcpy((void *)GetAddr3Ptr((txinsn.phdr)), bssid, MACADDRLEN);

#if defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI)
	txinsn.is_urgent = 1;
#endif


if((GET_CHIP_VER(priv) != VERSION_8812E) && (GET_CHIP_VER(priv) != VERSION_8881A))
{
	unsigned int tmp_d2c = RTL_R32(0xd2c);
	unsigned int val_d2c = tmp_d2c;
	
	if (orSTABitMap(&priv->pshare->intel_sta_bitmap))
		tmp_d2c = (tmp_d2c & (~ BIT(11)));
	else
		tmp_d2c = (tmp_d2c | BIT(11));

	if (tmp_d2c ^ val_d2c)
	RTL_W32(0xd2c, tmp_d2c);

#if 1	
	tmp_d2c = RTL_R32(0xd2c);

	if(tmp_d2c & BIT(11)) {
		DEBUG_INFO("BIT(11) of 0xd2c = %d, 0xd2c = 0x%x\n", 1, tmp_d2c);
	} else {
		DEBUG_INFO("BIT(11) of 0xd2c = %d, 0xd2c = 0x%x\n", 0, tmp_d2c);
	}
#endif
	
}

#ifdef CTC_WIFI_DIAG
	if (pkt_type == WIFI_REASSOCRSP) {
		ctcwifi_diag_log(priv, pstat->cmn_info.mac_addr, 1, "Reassociation Response", (unsigned char *)(txinsn.pframe), txinsn.fr_len);
	}
	else {
		ctcwifi_diag_log(priv, pstat->cmn_info.mac_addr, 1, "Association Response", (unsigned char *)(txinsn.pframe), txinsn.fr_len);
	}
#endif
	log(" %pm",pstat->cmn_info.mac_addr);

	if ((rtl8192cd_firetx(priv, &txinsn)) == SUCCESS) {
//#if !defined(CONFIG_RTL865X_KLD) && !defined(CONFIG_RTL8196B_KLD)
#if 0
		if(!SWCRYPTO && !IEEE8021X_FUN &&
			(pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm == _WEP_104_PRIVACY_ ||
			 pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm == _WEP_40_PRIVACY_)) {
			DOT11_SET_KEY Set_Key;
			memcpy(Set_Key.MACAddr, pstat->cmn_info.mac_addr, 6);
			Set_Key.KeyType = DOT11_KeyType_Pairwise;
			Set_Key.EncType = pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm;

			Set_Key.KeyIndex = pmib->dot1180211AuthEntry.dot11PrivacyKeyIndex;
			DOT11_Process_Set_Key(priv->dev, NULL, &Set_Key,
				pmib->dot11DefaultKeysTable.keytype[Set_Key.KeyIndex].skey);
		}
#endif
		return;
	}

issue_asocrsp_fail:
	log("issue_asocrsp_fail %pm",pstat->cmn_info.mac_addr);

	DRV_RT_TRACE(priv, DRV_DBG_CONN_INFO, DRV_DBG_SERIOUS, "issue_asocrsp_fail\n");	
	
	if (txinsn.phdr)
		release_wlanhdr_to_poll(priv, txinsn.phdr);
	if (txinsn.pframe)
		release_mgtbuf_to_poll(priv, txinsn.pframe);
}


int fill_probe_rsp_content(struct rtl8192cd_priv *priv,
				UINT8 *phdr, UINT8 *pbuf,
				UINT8 *ssid, int ssid_len, int set_privacy, UINT8 is_11s, UINT8 is_11b_only, unsigned int assoc_disallow)
{
    unsigned short	val;
    struct wifi_mib *pmib;
    unsigned char	*bssid;
    UINT8	val8;
#ifndef RTK_NL80211
    unsigned char	*pbssrate=NULL;
    int 	bssrate_len = 0;
    int ret=0;
#endif
	int 	fr_len=0;
#ifdef CONFIG_RTK_MESH
    UINT8 meshiearray[32];	// mesh IE buffer (Max byte is mesh_ie_MeshID)
#endif

#if !defined(SMP_SYNC) && defined(CONFIG_RTL_WAPI_SUPPORT)
    unsigned long		flags;
#endif

#ifdef P2P_SUPPORT
    int need_include_p2pie = 0;
#endif

	unsigned char extended_cap_ie[8];	/*process all ext cap IE ;HS2_SUPPORT*/
	memset(extended_cap_ie,0,8);


    pmib= GET_MIB(priv);

    bssid = pmib->dot11StationConfigEntry.dot11Bssid;

    pbuf += _TIMESTAMP_;
    fr_len += _TIMESTAMP_;

    val = cpu_to_le16(pmib->dot11StationConfigEntry.dot11BeaconPeriod);
    pbuf = set_fixed_ie(pbuf,  _BEACON_ITERVAL_ , (unsigned char *)&val, (unsigned int *)&fr_len);

#ifdef P2P_SUPPORT/*cfg p2p cfg p2p*/
    if((rtk_p2p_is_enabled(priv))
        && (rtk_p2p_chk_role(priv,P2P_DEVICE)) 
        && (rtk_p2p_chk_state(priv,P2P_S_LISTEN)))
    {
        val |= cpu_to_le16(BIT(0)); //set ESS	 to 1
    }else
#endif
#ifdef CONFIG_RTK_MESH
    if ((1 == GET_MIB(priv)->dot1180211sInfo.mesh_enable) && (0 == GET_MIB(priv)->dot1180211sInfo.mesh_ap_enable)) // non-AP MP (MAP) only, popen:802.11s Draft 1.0 P17  7.3.1.4 : ESS & IBSS are "0" (PS:val Reset here.)
        val = 0;
    else
#endif
    {
        if (OPMODE & WIFI_AP_STATE)
            val = cpu_to_le16(BIT(0)); //ESS
        else
            val = cpu_to_le16(BIT(1)); //IBSS
    }

    if (pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm && set_privacy)
        val |= cpu_to_le16(BIT(4));

#if defined(CONFIG_RTL_WAPI_SUPPORT)
    if (priv->pmib->wapiInfo.wapiType!=wapiDisable)
    {
        val |= cpu_to_le16(BIT(4));	/* set privacy	*/
    }
#endif

    if (SHORTPREAMBLE)
        val |= cpu_to_le16(BIT(5));

    if (priv->pmib->dot11ErpInfo.shortSlot)
        val |= cpu_to_le16(BIT(10));

#ifdef DOT11H
    if(priv->pmib->dot11hTPCEntry.tpc_enable)
        val |= cpu_to_le16(BIT(8));	/* set spectrum mgt */
#endif

#ifdef DOT11K
    if(priv->pmib->dot11StationConfigEntry.dot11SMMeasurementActivated)
        val |= cpu_to_le16(BIT(8));	/* set spectrum mgt measurement */

    if(priv->pmib->dot11StationConfigEntry.dot11RadioMeasurementActivated)
        val |= cpu_to_le16(BIT(12));   /* set radio measurement */
#endif

#ifdef HAPD_11K
	if(priv->hapd_11k_ie_len){
		val |= cpu_to_le16(BIT(12));   /* set radio measurement */
	}
#endif

#if defined(WMM_APSD)
	if (APSD_ENABLE) 
		val |= cpu_to_le16(BIT(11));
#endif	
    pbuf = set_fixed_ie(pbuf, _CAPABILITY_, (unsigned char *)&val, (unsigned int *)&fr_len);

#ifdef WDS
	if(priv->pmib->dot11WdsInfo.wdsPure)
		pbuf = set_ie(pbuf, _SSID_IE_, 0, ssid, (unsigned int *)&fr_len);
	else
#endif		
    pbuf = set_ie(pbuf, _SSID_IE_, ssid_len, ssid, (unsigned int *)&fr_len);

#ifdef RTK_NL80211
		if(priv->hapd_supp_rates_len){
			memcpy(pbuf, priv->hapd_supp_rates, priv->hapd_supp_rates_len);
			pbuf += priv->hapd_supp_rates_len;
			fr_len += priv->hapd_supp_rates_len;
		}
		if(priv->hapd_ext_supp_rates_len){
			memcpy(pbuf, priv->hapd_ext_supp_rates, priv->hapd_ext_supp_rates_len);
			pbuf += priv->hapd_ext_supp_rates_len;
			fr_len += priv->hapd_ext_supp_rates_len;
		}
#else
#ifdef P2P_SUPPORT/*cfg p2p cfg p2p*/
    if(rtk_p2p_is_enabled(priv))
        ret = get_bssrate_set(priv, _SUPPORTED_RATES_NO_CCK_, &pbssrate, &bssrate_len);	
    else
#endif
        ret = get_bssrate_set(priv, _SUPPORTEDRATES_IE_, &pbssrate, &bssrate_len);

    if (ret)
        pbuf = set_ie(pbuf, _SUPPORTEDRATES_IE_, bssrate_len, pbssrate, (unsigned int *)&fr_len);

	 //EXT supported rates.
    if (get_bssrate_set(priv, _EXT_SUPPORTEDRATES_IE_, &pbssrate, &bssrate_len))
    {
		u8 tmp[8];

		memcpy(tmp, pbssrate, bssrate_len);
#ifdef ENABLE_SAE_H2E
		// fill probe rsp
		if(support_wpa3(priv))
			construct_bss_mem_ie(priv, tmp, &bssrate_len);
#endif
		pbuf = set_ie(pbuf, _EXT_SUPPORTEDRATES_IE_ , bssrate_len , tmp, (unsigned int *)&fr_len);
    }
#ifdef ENABLE_SAE_H2E
    else if (support_wpa3(priv) && priv->pmib->dot1180211AuthEntry.dot11SAEPwe == 1)
    {
		u8 tmp[8];
		u32 extlen=0;
		construct_bss_mem_ie(priv, tmp, &extlen);
        pbuf = set_ie(pbuf, _EXT_SUPPORTEDRATES_IE_, extlen, tmp, (unsigned int *)&fr_len);
    }
#endif
#endif

#ifdef P2P_SUPPORT		// fill DSSET
    /*cfg p2p cfg p2p*/
    if(rtk_p2p_is_enabled(priv) && (rtk_p2p_chk_role(priv,P2P_DEVICE))&& (rtk_p2p_chk_state(priv,P2P_S_LISTEN) )){
        val8 = priv->pmib->p2p_mib.p2p_listen_channel;
    }else
#endif
    {
        val8 = pmib->dot11RFEntry.dot11channel;
    }

#if defined(RTK_5G_SUPPORT) 
    if ( priv->pmib->dot11RFEntry.phyBandSelect & PHY_BAND_2G)
#endif
        pbuf = set_ie(pbuf, _DSSET_IE_, 1, &val8 , (unsigned int *)&fr_len);

    if (OPMODE & WIFI_ADHOC_STATE) {
        unsigned short val16 = 0;
        pbuf = set_ie(pbuf, _IBSS_PARA_IE_, 2, (unsigned char *)&val16, (unsigned int *)&fr_len);
    }

#if defined(DOT11D) || defined(DOT11H) || defined(DOT11K)
    if(priv->countryTableIdx)
    {
        pbuf = construct_country_ie(priv, pbuf, &fr_len);   
    }
#endif


#if defined(DOT11H) || defined(DOT11K)
    if(priv->pmib->dot11hTPCEntry.tpc_enable || priv->pmib->dot11StationConfigEntry.dot11RadioMeasurementActivated)
    {
        pbuf = set_ie(pbuf, _PWR_CONSTRAINT_IE_, 1, &priv->pshare->rf_ft_var.lpwrc, &fr_len);
        pbuf = construct_TPC_report_ie(priv, pbuf, &fr_len);
    }
#endif


    if (OPMODE & WIFI_AP_STATE) {
        if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11G) {
            //ERP infomation.
            val8=0;
            if (priv->pmib->dot11ErpInfo.protection)
                val8 |= BIT(1);
            if (priv->pmib->dot11ErpInfo.nonErpStaNum)
                val8 |= BIT(0);
            pbuf = set_ie(pbuf, _ERPINFO_IE_ , 1 , &val8, (unsigned int *)&fr_len);
        }
    }

    #if defined(HS2_SUPPORT) || defined(DOT11K)
    pbuf = construct_BSS_load_ie(priv, pbuf, &fr_len);
    #endif

#ifdef DOT11K
    if(priv->pmib->dot11StationConfigEntry.dot11RadioMeasurementActivated)
    {
        /* AP Channel Report*/
        if((OPMODE & WIFI_AP_STATE) && priv->pmib->dot11StationConfigEntry.dot11RMAPChannelReportActivated)  {
            pbuf = construct_ap_channel_rep_ie(priv, pbuf, &fr_len);
        }
        
        /* RM Enabled Capabilities*/
        pbuf = construct_rm_enable_cap_ie(priv, pbuf, &fr_len);
    }
#endif

#ifdef HAPD_11K
	if(priv->hapd_11k_ie_len){
		/* AP Channel Report ; reference on_probe_req and found AP Channel Report OUI , search => found_11k_oui*/

		/*RM Enabled Capabilities ;priv->hapd_11k_ie_len  include IE(ID)+LEN+VAL */
		memcpy(pbuf, priv->hapd_11k_ie, priv->hapd_11k_ie_len);
		pbuf += priv->hapd_11k_ie_len;
		fr_len += priv->hapd_11k_ie_len;
	}
#endif

#ifdef CONFIG_IEEE80211R
    if (FT_ENABLE)
        pbuf = construct_mobility_domain_ie(priv, pbuf, &fr_len);
#endif

	/*
		2008-12-16, For Buffalo WLI_CB_AG54L 54Mbps NIC interoperability issue.
		This NIC can not connect to our AP when our AP is set to WPA/TKIP encryption.
		This issue can be fixed after move "HT Capability Info" and "Additional HT Info" in front of "WPA" and "WMM".
	 */
    if ((priv->pmib->dot11BssType.net_work_type & WIRELESS_11N) && (!is_11b_only)) {
        pbuf = set_ie(pbuf, _HT_CAP_, priv->ht_cap_len, (unsigned char *)&priv->ht_cap_buf, (unsigned int *)&fr_len);
        pbuf = set_ie(pbuf, _HT_IE_, priv->ht_ie_len, (unsigned char *)&priv->ht_ie_buf, (unsigned int *)&fr_len);
    }
// probe

#ifdef RTK_AC_SUPPORT //for 11ac logo
	if((priv->pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm != _WEP_40_PRIVACY_)
		&& (priv->pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm != _WEP_104_PRIVACY_))
	if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11AC) {
		// 41		
		extended_cap_ie[7] |= 0x40;					
		// 60, 61
		construct_vht_ie(priv, priv->pshare->working_channel);
		pbuf = set_ie(pbuf, EID_VHTCapability, priv->vht_cap_len, (unsigned char *)&priv->vht_cap_buf, &fr_len);
		pbuf = set_ie(pbuf, EID_VHTOperation, priv->vht_oper_len, (unsigned char *)&priv->vht_oper_buf, &fr_len);
	
		// 62 
		if(priv->pshare->rf_ft_var.lpwrc) {
			char tmp[4];
			pbuf = set_ie(pbuf, _PWR_CONSTRAINT_IE_, 1, &priv->pshare->rf_ft_var.lpwrc, &fr_len);
			tmp[1] = tmp[2] = tmp[3] = priv->pshare->rf_ft_var.lpwrc;
			tmp[0] = priv->pshare->CurrentChannelBW;	//	20, 40, 80
			pbuf = set_ie(pbuf, EID_VHTTxPwrEnvelope, tmp[0]+2, tmp, &fr_len);	
		}

		//66
		if(priv->pshare->rf_ft_var.opmtest&1)
		pbuf = set_ie(pbuf, EID_VHTOperatingMode, 1, (unsigned char *)&(priv->pshare->rf_ft_var.oper_mode_field), &fr_len); 	
			
	}
#endif

#ifdef WIFI_11N_2040_COEXIST
	if ((OPMODE & WIFI_AP_STATE) && 
		(priv->pmib->dot11BssType.net_work_type & (WIRELESS_11N|WIRELESS_11G)) &&
		COEXIST_ENABLE) {

		extended_cap_ie[0] |= _2040_COEXIST_SUPPORT_;  // byte0
		if (priv->pshare->is_40m_bw) {
			construct_obss_scan_para_ie(priv);
			pbuf = set_ie(pbuf, _OBSS_SCAN_PARA_IE_, priv->obss_scan_para_len,
					(unsigned char *)&priv->obss_scan_para_buf, (unsigned int *)&fr_len);
		}
	}
#endif

	if (pmib->dot11RsnIE.rsnielen && set_privacy 
	#if defined(CONFIG_RTL_WAPI_SUPPORT)
		&&(pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm != _WAPI_SMS4_)
	#endif
		&& (fr_len + pmib->dot11RsnIE.rsnielen <= (PRE_ALLOCATED_BUFSIZE*4))) {
		memcpy(pbuf, pmib->dot11RsnIE.rsnie, pmib->dot11RsnIE.rsnielen);
		pbuf += pmib->dot11RsnIE.rsnielen;
		fr_len += pmib->dot11RsnIE.rsnielen;
	}

#ifdef ENABLE_SAE_H2E
	// fill probe rsp
	if ( support_wpa3(priv) && pmib->dot1180211AuthEntry.dot11SAEPwe != 0 ) {
		u8 tmp[2];
		size_t flen;

		flen = construct_rsnxe_ie(tmp);
		pbuf = set_ie(pbuf, _RSNX_IE_, flen, tmp, &fr_len);
	}
#endif

#ifdef RTK_NL80211
	/*RSNXE*/
	if(priv->rsn_xe_len){
		memcpy(pbuf, priv->rsn_xe, priv->rsn_xe_len);
		pbuf += priv->rsn_xe_len;
		fr_len += priv->rsn_xe_len;
	}
#endif

#ifdef WIFI_WMM
	//Set WMM Parameter Element
	if (QOS_ENABLE && (is_11b_only != 0xf))
		pbuf = set_ie(pbuf, _RSN_IE_1_, _WMM_Para_Element_Length_, GET_WMM_PARA_IE, (unsigned int *)&fr_len);
#endif


#if defined(TV_MODE) || defined(A4_STA)
    val8 = 0;
#ifdef A4_STA
    if(priv->pmib->miscEntry.a4_enable == 2) {
        val8 |= BIT0;
    }
#endif

#ifdef TV_MODE
    val8 |= BIT1;
#endif
    if(val8)
        pbuf = construct_ecm_tvm_ie(priv, pbuf, &fr_len, val8);
#endif //defined(TV_MODE) || defined(A4_STA)



	if ((priv->pmib->dot11BssType.net_work_type & WIRELESS_11N) && (!is_11b_only)) {
		/*
			2008-12-16, For Buffalo WLI_CB_AG54L 54Mbps NIC interoperability issue.
			This NIC can not connect to our AP when our AP is set to WPA/TKIP encryption.
			This issue can be fixed after move "HT Capability Info" and "Additional HT Info" in front of "WPA" and "WMM".
		 */
		//pbuf = set_ie(pbuf, _HT_CAP_, priv->ht_cap_len, (unsigned char *)&priv->ht_cap_buf, &txinsn.fr_len);
		//pbuf = set_ie(pbuf, _HT_IE_, priv->ht_ie_len, (unsigned char *)&priv->ht_ie_buf, &txinsn.fr_len);
		//pbuf = construct_ht_ie_old_form(priv, pbuf, (unsigned int *)&fr_len);
	}

#ifdef CONFIG_RTK_MESH
	if((TRUE == is_11s))
	{
        pbuf = set_ie(pbuf, _OFDM_PARAMETER_SET_IE_, mesh_ie_OFDM(priv, meshiearray), meshiearray, &fr_len);
		pbuf = set_ie(pbuf, _MESH_ID_IE_, mesh_ie_MeshID(priv, meshiearray, FALSE), meshiearray, &fr_len);
		pbuf = set_ie(pbuf, _WLAN_MESH_CAP_IE_, mesh_ie_WLANMeshCAP(priv, meshiearray), meshiearray, &fr_len);

        if(priv->mesh_swchnl_channel) { /*mesh channel switch procedure is on-going*/
            pbuf = set_ie(pbuf, _MESH_CHANNEL_SWITCH_IE_, mesh_ie_MeshChannelSwitch(priv, meshiearray), meshiearray, &fr_len);
            pbuf = set_ie(pbuf, _CSA_IE_, mesh_ie_ChannelSwitchAnnoun(priv, meshiearray), meshiearray, &fr_len);            
            pbuf = set_ie(pbuf, _SECONDARY_CHANNEL_OFFSET_IE_, mesh_ie_SecondaryChannelOffset(priv, meshiearray), meshiearray, &fr_len);
        }
	}
#endif

#ifdef CONFIG_MBO
		// MBO-OCE IE
		pbuf = construct_mbo_ie(pbuf, &fr_len, assoc_disallow);
#endif

	// Realtek proprietary IE
	if (priv->pshare->rtk_ie_len)
		pbuf = set_ie(pbuf, _RSN_IE_1_, priv->pshare->rtk_ie_len, priv->pshare->rtk_ie_buf, (unsigned int *)&fr_len);

	// Customer proprietary IE
	if (priv->pmib->miscEntry.private_ie_len 
		&& (fr_len + priv->pmib->miscEntry.private_ie_len <= (PRE_ALLOCATED_BUFSIZE*4))) {
		memcpy(pbuf, pmib->miscEntry.private_ie, pmib->miscEntry.private_ie_len);
		pbuf += pmib->miscEntry.private_ie_len;
		fr_len += pmib->miscEntry.private_ie_len;
	}
#ifdef USER_ADDIE
{
	int i;
	for (i=0; i<MAX_USER_IE; i++) {
		if (priv->user_ie_list[i].used) {
			memcpy(pbuf, priv->user_ie_list[i].ie, priv->user_ie_list[i].ie_len);
			pbuf += priv->user_ie_list[i].ie_len;
			fr_len += priv->user_ie_list[i].ie_len; 
		}
	}
}
#endif

	if(priv->pmib->miscEntry.stage) {
		unsigned char tmp[10] = { 0x00, 0x0d, 0x02, 0x07, 0x01, 0x00, 0x00 };
		if(priv->pmib->miscEntry.stage<=5)
			tmp[6] = 1<<(8-priv->pmib->miscEntry.stage);
		pbuf = set_ie(pbuf, _RSN_IE_1_, 7, tmp, &fr_len);
	}

/* For easymesh R2 logo, wait for hostapd update beacon feature */
#if defined(RTK_MULTI_AP_LOGO) && defined(CONFIG_MBO)
	if (OPMODE & WIFI_AP_STATE)
	{
		unsigned char interworking_ie[1] = {0}, advt_proto[2] = {0};
		pbuf = set_ie(pbuf, _INTERWORKING_IE_, 1, interworking_ie, &fr_len);
		extended_cap_ie[3] |= _INTERWORKING_SUPPORT_;

		advt_proto[0] = 127;
		advt_proto[1] = 0;
		pbuf = set_ie(pbuf, _ADVT_PROTO_IE_, 2, advt_proto, &fr_len);
	}
#endif

#ifdef HS2_SUPPORT
	//if support hs2 enable, p2p disable
    if ((OPMODE & WIFI_AP_STATE) && priv->pmib->hs2Entry.hs2_ielen)
    {
        //unsigned char p2ptmpie[]={0x50,0x6f,0x9a,0x09,0x02,0x02,0x00,0x00,0x00};
        unsigned char p2ptmpie[]={0x50,0x6f,0x9a,0x09,0x0a,0x01,0x00,0x01};
        pbuf = set_ie(pbuf, 221, sizeof(p2ptmpie), p2ptmpie, &fr_len);
    }
	//if ((OPMODE & WIFI_AP_STATE) && priv->pmib->hs2Entry.hs2_ielen)
	//{
    //    pbuf = set_ie(pbuf, _HS2_IE_, priv->pmib->hs2Entry.hs2_ielen, priv->pmib->hs2Entry.hs2_ie, &fr_len);
    //}
	if ((OPMODE & WIFI_AP_STATE) && priv->pmib->hs2Entry.hs2_ielen)
    {
        pbuf = set_ie(pbuf, _HS2_IE_, priv->pmib->hs2Entry.hs2_ielen, priv->pmib->hs2Entry.hs2_ie, &fr_len);
    }
	if ((OPMODE & WIFI_AP_STATE) && priv->pmib->hs2Entry.interworking_ielen)
	{
		pbuf = set_ie(pbuf, _INTERWORKING_IE_, priv->pmib->hs2Entry.interworking_ielen, priv->pmib->hs2Entry.interworking_ie, &fr_len);
	}
	if ((OPMODE & WIFI_AP_STATE) && priv->pmib->hs2Entry.advt_proto_ielen)
	{
		pbuf = set_ie(pbuf, _ADVT_PROTO_IE_, priv->pmib->hs2Entry.advt_proto_ielen, priv->pmib->hs2Entry.advt_proto_ie, &fr_len);
	}
	if ((OPMODE & WIFI_AP_STATE) && priv->pmib->hs2Entry.roam_ielen && priv->pmib->hs2Entry.roam_enable)
	{
		pbuf = set_ie(pbuf, _ROAM_IE_, priv->pmib->hs2Entry.roam_ielen, priv->pmib->hs2Entry.roam_ie, &fr_len);
	}
	if ((OPMODE & WIFI_AP_STATE) && priv->pmib->hs2Entry.timeadvt_ielen)
    {
        pbuf = set_ie(pbuf, _TIMEADVT_IE_, priv->pmib->hs2Entry.timeadvt_ielen, priv->pmib->hs2Entry.timeadvt_ie, &fr_len);
    }
	if ((OPMODE & WIFI_AP_STATE) && priv->pmib->hs2Entry.MBSSID_ielen)
    {
      pbuf = set_ie(pbuf, _MUL_BSSID_IE_, priv->pmib->hs2Entry.MBSSID_ielen, priv->pmib->hs2Entry.MBSSID_ie, &fr_len);
    }
    if ((OPMODE & WIFI_AP_STATE) && priv->pmib->hs2Entry.timezone_ielen)
    {
        pbuf = set_ie(pbuf, _TIMEZONE_IE_, priv->pmib->hs2Entry.timezone_ielen, priv->pmib->hs2Entry.timezone_ie, &fr_len);
    }
#endif
    


#ifdef P2P_SUPPORT		
    /*fill WSC IE*/
/*cfg p2p cfg p2p*/	
	//if(	rtk_p2p_is_enabled(priv))	 
	if((rtk_p2p_chk_role(priv,P2P_DEVICE)) && (rtk_p2p_chk_state(priv,P2P_S_LISTEN)))
	{
		if(pmib->wscEntry.probe_rsp_ielen){
			memcpy(pbuf, pmib->wscEntry.probe_rsp_ie, pmib->wscEntry.probe_rsp_ielen);
			pbuf += pmib->wscEntry.probe_rsp_ielen;
			fr_len += pmib->wscEntry.probe_rsp_ielen;
		}
	}
	else
#endif
#ifdef WIFI_SIMPLE_CONFIG
	{
		if (!priv->pshare->rf_ft_var.NDSi_support
			&& (priv->pmib->dot11StationConfigEntry.dot11AclMode != ACL_ALLOW || priv->pmib->dot11StationConfigEntry.dot11AclNum > 0))
		{
			if (pmib->wscEntry.wsc_enable && pmib->wscEntry.probe_rsp_ielen 
				&& (fr_len + pmib->wscEntry.probe_rsp_ielen <= (PRE_ALLOCATED_BUFSIZE*4))) {
				memcpy(pbuf, pmib->wscEntry.probe_rsp_ie, pmib->wscEntry.probe_rsp_ielen);
				pbuf += pmib->wscEntry.probe_rsp_ielen;
				fr_len += pmib->wscEntry.probe_rsp_ielen;
			}
		}
	}
#endif

#ifdef BEACON_VS_IE
	if(priv->probersp_vsie_idx != 0)
	{
	
		if(priv->prbrsp_vsie[priv->probersp_vsie_idx-1].data_len)
		{
			pbuf = set_ie(pbuf, _VENDOR_SPECIFIC_IE_, priv->prbrsp_vsie[priv->probersp_vsie_idx-1].data_len, priv->prbrsp_vsie[priv->probersp_vsie_idx-1].data, &fr_len);
		}
		priv->probersp_vsie_idx = 0;
	}
#endif

#ifdef P2P_SUPPORT
    /*fill P2P IE*/
/*cfg p2p cfg p2p*/	
	if( rtk_p2p_is_enabled(priv) && (rtk_p2p_chk_role(priv,P2P_TMP_GO)||rtk_p2p_chk_role(priv,P2P_PRE_GO))){
		if(priv->p2pPtr->probe_rps_to_p2p_dev){
			need_include_p2pie = 1;
			priv->p2pPtr->probe_rps_to_p2p_dev = 0;
		}
	}
/*cfg p2p cfg p2p*/
	if ( ((rtk_p2p_chk_role(priv,P2P_DEVICE)) && (rtk_p2p_chk_state(priv,P2P_S_LISTEN))) 
		 ||  need_include_p2pie ) 
	{
		if(priv->p2pPtr->p2p_probe_rsp_ie_len){
			memcpy(pbuf, priv->p2pPtr->p2p_probe_rsp_ie, priv->p2pPtr->p2p_probe_rsp_ie_len);
			pbuf += priv->p2pPtr->p2p_probe_rsp_ie_len ;
			fr_len += priv->p2pPtr->p2p_probe_rsp_ie_len ;
		}
	}	
#endif

	#ifdef HS2_SUPPORT	/*process ext cap IE(IE ID=107) for HS2*/
	if (priv->pmib->hs2Entry.interworking_ielen)
	{	
			// byte0
		if (priv->proxy_arp){
			extended_cap_ie[1] |=_PROXY_ARP_ ;
		}
		
		if ((priv->pmib->hs2Entry.timezone_ielen!=0) && (priv->pmib->hs2Entry.timeadvt_ielen)){
			extended_cap_ie[3] |= _UTC_TSF_OFFSET_ ;
		}
		extended_cap_ie[3] |= _INTERWORKING_SUPPORT_ ;			
			//HS2_CHECK
		if(priv->pmib->hs2Entry.QoSMap_ielen[0] || priv->pmib->hs2Entry.QoSMap_ielen[1])
			extended_cap_ie[4] |= _QOS_MAP_; // QoS MAP (Bit32) 		
				
		extended_cap_ie[5] |= _WNM_NOTIFY_; //WNM notification, Bit46			
	}
	#endif	
#ifdef TDLS_SUPPORT 
	if(priv->pmib->dot11OperationEntry.tdls_prohibited){ 
		extended_cap_ie[4] |= _TDLS_PROHIBITED_;	// bit 38
	}else{
		if(priv->pmib->dot11OperationEntry.tdls_cs_prohibited){ 
			extended_cap_ie[4] |= _TDLS_CS_PROHIBITED_;	// bit 39
		}
	}
#endif	
 #ifdef CONFIG_IEEE80211V
	if(WNM_ENABLE)
		extended_cap_ie[2] |=_BSS_TRANSITION_ ; // bit 19	
#endif

#ifdef HAPD_11V
	if(priv->hapd_11v_enable)
		extended_cap_ie[2] |= _BSS_TRANSITION_ ; // bit 19
#endif

	/*===========fill ext cap IE here! so far (HS2, AC,TDLS )*/		
	pbuf = set_ie(pbuf, _EXTENDED_CAP_IE_, 8, extended_cap_ie, &fr_len);
	/*===========ext cap IE all in here!!!=================*/


	SetFrameSubType((phdr), WIFI_PROBERSP);
	memcpy((void *)GetAddr2Ptr((phdr)), GET_MY_HWADDR, MACADDRLEN);

#ifdef CONFIG_RTL_WAPI_SUPPORT
		if (priv->pmib->wapiInfo.wapiType!=wapiDisable)
		{
			SAVE_INT_AND_CLI(flags);
			priv->wapiCachedBuf = pbuf+2;
			wapiSetIE(priv);
			pbuf[0] = _EID_WAPI_;
			pbuf[1] = priv->wapiCachedLen;
			pbuf += priv->wapiCachedLen+2;
			fr_len += priv->wapiCachedLen+2;
			RESTORE_INT(flags);
		}
#endif

#ifdef P2P_SUPPORT		
/*cfg p2p cfg p2p*/
	if(	(rtk_p2p_chk_role(priv,P2P_DEVICE)) && (rtk_p2p_chk_state(priv,P2P_S_LISTEN)))	{
		memcpy((void *)GetAddr3Ptr((phdr)), GET_MY_HWADDR , MACADDRLEN);
	}
	else
#endif
	{
		memcpy((void *)GetAddr3Ptr((phdr)), bssid, MACADDRLEN);
	}

	return fr_len;
}


/**
 *	@brief	issue probe response
 *
 *	- Timestamp \n - Beacon interval \n - Capability \n - SSID \n - Support rate \n - DS Parameter set \n \n
 *	+-------+-------+----+----+--------+	\n
 *	| Frame control | DA | SA |	BSS ID |	\n
 *	+-------+-------+----+----+--------+	\n
 *	\n
 *	+-----------+-----------------+------------+------+--------------+------------------+-----------+	\n
 *	| Timestamp | Beacon interval | Capability | SSID | Support rate | DS Parameter set | ERP info.	|	\n
 *	+-----------+-----------------+------------+------+--------------+------------------+-----------+	\n
 *
 *	\param	priv	device info.
 *	\param	da	address
 *	\param	sid	SSID
 *	\param	ssid_len	SSID length
 *	\param 	set_privacy	Use Robust security network
 */
//static 	;  extern for P2P_SUPPORT
void issue_probersp(struct rtl8192cd_priv *priv, unsigned char *da,
				UINT8 *ssid, int ssid_len, int set_privacy, UINT8 is_11b_only, unsigned int assoc_disallow)
{
#ifdef CONFIG_RTK_MESH
	issue_probersp_MP(priv, da, ssid, ssid_len, set_privacy, FALSE, is_11b_only);
}


void issue_probersp_MP(struct rtl8192cd_priv *priv, unsigned char *da,
				UINT8 *ssid, int ssid_len, int set_privacy, UINT8 is_11s, UINT8 is_11b_only)
{
//	UINT8 meshiearray[32];	// mesh IE buffer (Max byte is mesh_ie_MeshID)
#endif
	unsigned int z = 0;
#ifdef BEACON_VS_IE
	int i=0;
#endif
#if defined(WIFI_WMM)
	int ret;
	struct stat_info *pstat = get_stainfo(priv, da);  
#endif

	DECLARE_TXINSN(txinsn);

#ifdef CONFIG_RTK_BAND_STEERING
	if (_band_steering_block_chk(priv, da))
		return;
#endif

#ifdef SDIO_AP_OFFLOAD
	if (priv->pshare->offload_function_ctrl)
		return;
#endif

//	pmib= GET_MIB(priv);
//	bssid = pmib->dot11StationConfigEntry.dot11Bssid;
#ifdef CONFIG_RTK_MESH
	txinsn.is_11s = is_11s;
#endif
	txinsn.q_num = MANAGE_QUE_NUM;
	txinsn.fr_type = _PRE_ALLOCMEM_;


#ifdef P2P_SUPPORT
	if(rtk_p2p_is_enabled(priv) ){
      	txinsn.tx_rate = _6M_RATE_;
	}else
#endif    
    	txinsn.tx_rate = find_rate(priv, NULL, 0, 1);
#ifndef TX_LOWESTRATE
	txinsn.lowest_tx_rate = txinsn.tx_rate;
#endif	

	if (priv->pmib->dot11StationConfigEntry.prsp_rate != 0xff) {
		if (priv->pmib->dot11StationConfigEntry.prsp_rate > 11)
			panic_printk("[WARN] probe rsp rate is not legacy rate!\n");
		if ((priv->pmib->dot11RFEntry.phyBandSelect & PHY_BAND_5G) &&
			(priv->pmib->dot11StationConfigEntry.prsp_rate < 4)) {
			panic_printk("[WARN] probe rsp is CCK in 5G! Correct to OFDM rate\n");
			priv->pmib->dot11StationConfigEntry.prsp_rate = 4;
		}
		txinsn.tx_rate = get_rate_from_bit_value( BIT(priv->pmib->dot11StationConfigEntry.prsp_rate));
	}

	txinsn.fixed_rate = 1;
	txinsn.pframe  = get_mgtbuf_from_poll(priv);

	if (txinsn.pframe == NULL)
		goto issue_probersp_fail;

	txinsn.phdr = get_wlanhdr_from_poll(priv);

	if (txinsn.phdr == NULL)
		goto issue_probersp_fail;

	memset((void *)(txinsn.phdr), 0, sizeof (struct	wlan_hdr));

	if (is_11b_only &&
			(mac_oui_2_iot(OUI_TO_UINT32(da[0], da[1], da[2])) == HT_IOT_PEER_PSP)) {
		if (pstat)
			pstat->IOTPeer = HT_IOT_PEER_PSP;
		is_11b_only = 0xf;
		printMac(da);
	}

#ifdef BEACON_VS_IE
	priv->probersp_vsie_idx = 0;
	for(i=0; i<NUM_PRBVSIE_SERVICE; i++)
	{
		
		if(priv->prbrsp_vsie[i].service==1 && priv->prbrsp_vsie[i].data_len && isEqualMACAddr(priv->prbrsp_vsie[i].mac, da))
		{
			priv->probersp_vsie_idx = i+1;
			if(priv->prbrsp_vsie[i].if_info.is_used == 1 && memcmp(priv->prbrsp_vsie[i].if_info.ifname, priv->dev->name, sizeof(priv->prbrsp_vsie[i].if_info.ifname)) == 0)
			{
				priv->prbrsp_vsie[i].if_info.timestamp = jiffies/HZ;
				break;
			}
			else if(priv->prbrsp_vsie[i].if_info.is_used == 0)
			{
				memcpy(priv->prbrsp_vsie[i].if_info.ifname, priv->dev->name, sizeof(priv->prbrsp_vsie[i].if_info.ifname));
				priv->prbrsp_vsie[i].if_info.is_used = 1;
				priv->prbrsp_vsie[i].if_info.timestamp = jiffies/HZ;
			}
			break;
		}
	}
#endif

#ifdef CONFIG_RTK_MESH
	txinsn.fr_len = fill_probe_rsp_content(priv, txinsn.phdr, txinsn.pframe, ssid, ssid_len, set_privacy, is_11s, is_11b_only, 0);
#else
	txinsn.fr_len = fill_probe_rsp_content(priv, txinsn.phdr, txinsn.pframe, ssid, ssid_len, set_privacy, 0, is_11b_only, assoc_disallow);
#endif

	memcpy((void *)GetAddr1Ptr((txinsn.phdr)), da, MACADDRLEN);

#if defined(WIFI_WMM)
	ret = check_dz_mgmt(priv, pstat, &txinsn);
	
	if (ret < 0)
		goto issue_probersp_fail;
	else if (ret==1)
		return;
	else
#endif
	{
#ifdef CTC_WIFI_DIAG
		ctcwifi_diag_log(priv, da, 1, "Probe Response", (unsigned char *)(txinsn.pframe), txinsn.fr_len);
#endif

	if ((rtl8192cd_firetx(priv, &txinsn)) == SUCCESS)
		return;
	}

issue_probersp_fail:

	if (txinsn.phdr)
		release_wlanhdr_to_poll(priv, txinsn.phdr);
	if (txinsn.pframe)
		release_mgtbuf_to_poll(priv, txinsn.pframe);
}


/**
 *	@brief	STA issue prob request
 *
 *	+---------------+-----+------+-----------------+--------------------------+	\n
 *	| Frame Control | ... | SSID | Supported Rates | Extended Supported Rates |	\n
 *	+---------------+-----+------+-----------------+--------------------------+	\n
 *	@param	priv	device
 *	@param	ssid	ssid name
 *	@param	ssid_len	ssid length
 */
static void issue_probereq(struct rtl8192cd_priv *priv, unsigned char *ssid, int ssid_len, unsigned char *da)
{
#ifdef CONFIG_RTK_MESH
	issue_probereq_MP(priv, ssid, ssid_len, da, FALSE);
}


void issue_probereq_MP(struct rtl8192cd_priv *priv, unsigned char *ssid, int ssid_len, unsigned char *da, int is_11s)
{
    UINT8           meshiearray[32];	// mesh IE buffer (Max byte is mesh_ie_MeshID)
#endif

    struct wifi_mib *pmib;
    unsigned char	*hwaddr, *pbuf;
    unsigned char	*pbssrate=NULL;
    int		bssrate_len = 0;
    int ret =0;
#ifdef DOT11K
    unsigned char val8;
#endif
    DECLARE_TXINSN(txinsn);

#ifdef MP_TEST
    if (priv->pshare->rf_ft_var.mp_specific)
        return;
#endif
#ifdef CONFIG_IEEE80211V_CLI
	unsigned char extended_cap_ie[8];	
	memset(extended_cap_ie, 0, 8);
#endif	

#if	0	/*def DFS*/
#ifdef UNIVERSAL_REPEATER
	if(under_apmode_repeater(priv))
	{
		unsigned int channel = priv->pmib->dot11RFEntry.dot11channel; 
		unsigned char issue_ok = 0;
		unsigned int tmp_opmode =0;
		if(is_DFS_channel(priv, channel))
		{
			if((OPMODE & WIFI_ASOC_STATE) && (OPMODE & WIFI_STATION_STATE))
			{
				issue_ok = 1;
			}	
			
			if(IS_ROOT_INTERFACE(priv))
			{
				tmp_opmode = GET_VXD_PRIV(priv)->pmib->dot11OperationEntry.opmode;

				if((tmp_opmode & WIFI_ASOC_STATE) && (tmp_opmode & WIFI_STATION_STATE))
				{
					issue_ok = 1;
				}
			}
			
			//printk("DFS Channel=%d, issue_probeReq=%d\n", channel, issue_ok);
			
			if(issue_ok == 0)
				return;		
		}
	}
#endif
#endif

    txinsn.retry = priv->pmib->dot11OperationEntry.dot11ShortRetryLimit;

    pmib = GET_MIB(priv);

    hwaddr = pmib->dot11OperationEntry.hwaddr;
#ifdef CONFIG_RTK_MESH
    txinsn.is_11s = is_11s;
#endif
    txinsn.q_num = MANAGE_QUE_NUM;
    txinsn.fr_type = _PRE_ALLOCMEM_;

#ifdef P2P_SUPPORT	/*cfg p2p cfg p2p*/
    if(rtk_p2p_is_enabled(priv)){
        txinsn.tx_rate = _6M_RATE_;
    }else
#endif    
        txinsn.tx_rate = find_rate(priv, NULL, 0, 1);
#ifndef TX_LOWESTRATE
    txinsn.lowest_tx_rate = txinsn.tx_rate;
#endif	
    txinsn.fixed_rate = 1;
    pbuf = txinsn.pframe = get_mgtbuf_from_poll(priv);

    if (pbuf == NULL)
        goto issue_probereq_fail;

    txinsn.phdr = get_wlanhdr_from_poll(priv);

    if (txinsn.phdr == NULL)
        goto issue_probereq_fail;

    memset((void *)(txinsn.phdr), 0, sizeof (struct	wlan_hdr));

#ifdef HS2_SUPPORT
#ifdef HS2_CLIENT_TEST
	if ((priv->pshare->rf_ft_var.swq_dbg == 30) || (priv->pshare->rf_ft_var.swq_dbg == 31))
    {
		printk("Probe Request to SSID [Hotspot 2.0]\n");
        strcpy(ssid, "Hotspot 2.0");
        ssid[11] = '\0';
        ssid_len = strlen(ssid);
        pbuf = set_ie(pbuf, _SSID_IE_, ssid_len, ssid, &txinsn.fr_len);
    }
    else if ((priv->pshare->rf_ft_var.swq_dbg == 32) || (priv->pshare->rf_ft_var.swq_dbg == 33) || (priv->pshare->rf_ft_var.swq_dbg == 34) || (priv->pshare->rf_ft_var.swq_dbg == 35) || (priv->pshare->rf_ft_var.swq_dbg == 36) || (priv->pshare->rf_ft_var.swq_dbg == 37) || (priv->pshare->rf_ft_var.swq_dbg == 38) || (priv->pshare->rf_ft_var.swq_dbg == 39))
    {
        pbuf = set_ie(pbuf, _SSID_IE_, 0, ssid, &txinsn.fr_len);
    }
    else
#endif
#endif
	pbuf = set_ie(pbuf, _SSID_IE_, ssid_len, ssid, &txinsn.fr_len);
    /*fill supported rates*/ 

#ifdef P2P_SUPPORT/*cfg p2p cfg p2p*/
    if(rtk_p2p_is_enabled(priv)){
        ret = get_bssrate_set(priv, _SUPPORTED_RATES_NO_CCK_, &pbssrate, &bssrate_len);	
    }else
#endif
    {
        ret = get_bssrate_set(priv, _SUPPORTEDRATES_IE_, &pbssrate, &bssrate_len);	
    }

    if (ret)
        pbuf = set_ie(pbuf, _SUPPORTEDRATES_IE_ , bssrate_len , pbssrate, &txinsn.fr_len);

    if (get_bssrate_set(priv, _EXT_SUPPORTEDRATES_IE_, &pbssrate, &bssrate_len))
        pbuf = set_ie(pbuf, _EXT_SUPPORTEDRATES_IE_ , bssrate_len , pbssrate, &txinsn.fr_len);


#ifdef DOT11K
    if(priv->pmib->dot11StationConfigEntry.dot11RadioMeasurementActivated) {
        if (OPMODE & WIFI_SITE_MONITOR)
            val8 = priv->site_survey->ss_channel;
        else
            val8 = priv->pmib->dot11RFEntry.dot11channel;        
        pbuf = set_ie(pbuf, _DSSET_IE_, 1, &val8, &txinsn.fr_len);

        #ifdef CLIENT_MODE
        /*for Voice Over Wifi Enterprise certificate*/
        if(OPMODE & WIFI_STATION_STATE) {
            pbuf = construct_WFA_TPC_report_ie(priv, pbuf, &txinsn.fr_len);
        }
        #endif
    }
#endif


#ifdef RTK_AC_SUPPORT	// WDS-VHT support
    if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11AC) {
        //WDEBUG("construct_vht_ie\n");
        construct_vht_ie(priv, priv->pshare->working_channel);
        pbuf = set_ie(pbuf, EID_VHTCapability, priv->vht_cap_len, (unsigned char *)&priv->vht_cap_buf, &txinsn.fr_len);
        pbuf = set_ie(pbuf, EID_VHTOperation, priv->vht_oper_len, (unsigned char *)&priv->vht_oper_buf, &txinsn.fr_len);
    }
#endif

#ifdef P2P_SUPPORT		
	if (rtk_p2p_is_enabled(priv) )
	{		/*add wsc ie*/
		if(pmib->wscEntry.probe_req_ielen){
			memcpy(pbuf, pmib->wscEntry.probe_req_ie, pmib->wscEntry.probe_req_ielen);
			pbuf += pmib->wscEntry.probe_req_ielen;
			txinsn.fr_len += pmib->wscEntry.probe_req_ielen;
		}
	}
	else
#endif
#ifdef WIFI_SIMPLE_CONFIG
	{
		if (pmib->wscEntry.wsc_enable && pmib->wscEntry.probe_req_ielen
			&& (txinsn.fr_len + pmib->wscEntry.probe_req_ielen <= (PRE_ALLOCATED_BUFSIZE*4)))
		{
			memcpy(pbuf, pmib->wscEntry.probe_req_ie, pmib->wscEntry.probe_req_ielen);
			pbuf += pmib->wscEntry.probe_req_ielen;
			txinsn.fr_len += pmib->wscEntry.probe_req_ielen;
		}
	}
#endif

/*cfg p2p cfg p2p*/
#ifdef P2P_SUPPORT
	if (rtk_p2p_is_enabled(priv) )
	{
		if(priv->p2pPtr->p2p_probe_req_ie_len){
			memcpy(pbuf, priv->p2pPtr->p2p_probe_req_ie, priv->p2pPtr->p2p_probe_req_ie_len);			
			pbuf += priv->p2pPtr->p2p_probe_req_ie_len ;
			txinsn.fr_len += priv->p2pPtr->p2p_probe_req_ie_len ;			
		}
	}	
#endif
/*cfg p2p cfg p2p*/

#ifdef CONFIG_IEEE80211V_CLI
		if(WNM_ENABLE) {
			extended_cap_ie[2] |= _WNM_BSS_TRANS_SUPPORT_ ;
			pbuf = set_ie(pbuf, _EXTENDED_CAP_IE_, 8, extended_cap_ie, &txinsn.fr_len);
		 }
#endif

#ifdef HS2_SUPPORT
#ifdef HS2_CLIENT_TEST
	if (priv->pshare->rf_ft_var.swq_dbg == 30)
    {
		// HS2.0 AP does not transmit a probe response frame
		// HESSID is wrong.
		
        unsigned int temp_buf32, buf32 = _INTERWORKING_SUPPORT_BY_DW_, frlen=0;
        unsigned char tmp[]={0x02,0x50,0x6F,0x9A,0x00,0x00,0x01};

        temp_buf32 = cpu_to_le32(buf32);
        pbuf = set_ie(pbuf, _EXTENDED_CAP_IE_, 4, &temp_buf32, &frlen);
        txinsn.fr_len += frlen;

        frlen = 0;
        pbuf = set_ie(pbuf, _INTERWORKING_IE_, 7, tmp, &frlen);
        txinsn.fr_len += frlen;
    }
    else if (priv->pshare->rf_ft_var.swq_dbg == 31)
    {
		// HS2.0 AP does not transmit a probe response frame
		// HESSID is wrong.
        unsigned int temp_buf32, buf32 = _INTERWORKING_SUPPORT_BY_DW_, frlen=0;
        unsigned char tmp[]={0x02,0x00,0x00,0x50,0x6F,0x9A,0x00,0x00,0x01};

        temp_buf32 = cpu_to_le32(buf32);
        pbuf = set_ie(pbuf, _EXTENDED_CAP_IE_, 4, &temp_buf32, &frlen);
        txinsn.fr_len += frlen;

        frlen = 0;
        pbuf = set_ie(pbuf, _INTERWORKING_IE_, 9, tmp, &frlen);
        txinsn.fr_len += frlen;
    }
    else if (priv->pshare->rf_ft_var.swq_dbg == 32)
    {
		// APUT transmits Probe Response Message
        unsigned int temp_buf32, buf32 = _INTERWORKING_SUPPORT_BY_DW_, frlen=0;
        unsigned char tmp[]={0x02,0x00,0x33,0x44,0x55,0x66,0x77}; // HESSID = redir_mac, please refer to next line

		memcpy(&tmp[1], priv->pmib->hs2Entry.redir_mac, 6);

        temp_buf32 = cpu_to_le32(buf32);
        pbuf = set_ie(pbuf, _EXTENDED_CAP_IE_, 4, &temp_buf32, &frlen);
        txinsn.fr_len += frlen;

		frlen = 0;
        pbuf = set_ie(pbuf, _INTERWORKING_IE_, 7, tmp, &frlen);
        txinsn.fr_len += frlen;
    }
    else if (priv->pshare->rf_ft_var.swq_dbg == 33)
    {
		// APUT transmits Probe Response Message
        unsigned int temp_buf32, buf32 = _INTERWORKING_SUPPORT_BY_DW_, frlen=0;
        unsigned char tmp[]={0x02,0x00,0x00,0x00,0x33,0x44,0x55,0x66,0x77}; // HESSID = redir_mac, please refer to next line

		memcpy(&tmp[3], priv->pmib->hs2Entry.redir_mac, 6);

        temp_buf32 = cpu_to_le32(buf32);
        pbuf = set_ie(pbuf, _EXTENDED_CAP_IE_, 4, &temp_buf32, &frlen);
        txinsn.fr_len += frlen;

        frlen = 0;
        pbuf = set_ie(pbuf, _INTERWORKING_IE_, 9, tmp, &frlen);
        txinsn.fr_len += frlen;
    }
    else if (priv->pshare->rf_ft_var.swq_dbg == 34)
    {
        unsigned int temp_buf32, buf32 = _INTERWORKING_SUPPORT_BY_DW_, frlen=0;
        unsigned char tmp[]={0x03}; // HESSID is not present 

        temp_buf32 = cpu_to_le32(buf32);
        pbuf = set_ie(pbuf, _EXTENDED_CAP_IE_, 4, &temp_buf32, &frlen);
        txinsn.fr_len += frlen;

        frlen = 0;
        pbuf = set_ie(pbuf, _INTERWORKING_IE_, 1, tmp, &frlen);
        txinsn.fr_len += frlen;
    }
    else if (priv->pshare->rf_ft_var.swq_dbg == 35)
    {
        unsigned int temp_buf32, buf32 = _INTERWORKING_SUPPORT_BY_DW_, frlen=0;
        unsigned char tmp[]={0x03,0x00,0x00}; // HESSID is not present

		temp_buf32 = cpu_to_le32(buf32);
        pbuf = set_ie(pbuf, _EXTENDED_CAP_IE_, 4, &temp_buf32, &frlen);
        txinsn.fr_len += frlen;

        frlen = 0;
        pbuf = set_ie(pbuf, _INTERWORKING_IE_, 3, tmp, &frlen);
        txinsn.fr_len += frlen;
    }
    else if (priv->pshare->rf_ft_var.swq_dbg == 36)
    {
        unsigned int temp_buf32, buf32 = _INTERWORKING_SUPPORT_BY_DW_, frlen=0;
        unsigned char tmp[]={0x02,0xff,0xff,0xff,0xff,0xff,0xff};

        temp_buf32 = cpu_to_le32(buf32);
        pbuf = set_ie(pbuf, _EXTENDED_CAP_IE_, 4, &temp_buf32, &frlen);
        txinsn.fr_len += frlen;

        frlen = 0;
        pbuf = set_ie(pbuf, _INTERWORKING_IE_, 7, tmp, &frlen);
        txinsn.fr_len += frlen;
    }
    else if (priv->pshare->rf_ft_var.swq_dbg == 37)
    {
        unsigned int temp_buf32, buf32 = _INTERWORKING_SUPPORT_BY_DW_, frlen=0;
        unsigned char tmp[]={0x02,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff};

        temp_buf32 = cpu_to_le32(buf32);
        pbuf = set_ie(pbuf, _EXTENDED_CAP_IE_, 4, &temp_buf32, &frlen);
        txinsn.fr_len += frlen;

        frlen = 0;
        pbuf = set_ie(pbuf, _INTERWORKING_IE_, 9, tmp, &frlen);
        txinsn.fr_len += frlen;
    }
	else if (priv->pshare->rf_ft_var.swq_dbg == 38)
    {
        unsigned int temp_buf32, buf32 = _INTERWORKING_SUPPORT_BY_DW_, frlen=0;
        unsigned char tmp[]={0x0f,0xff,0xff,0xff,0xff,0xff,0xff};

        temp_buf32 = cpu_to_le32(buf32);
        pbuf = set_ie(pbuf, _EXTENDED_CAP_IE_, 4, &temp_buf32, &frlen);
        txinsn.fr_len += frlen;

        frlen = 0;
        pbuf = set_ie(pbuf, _INTERWORKING_IE_, 7, tmp, &frlen);
        txinsn.fr_len += frlen;
    }
    else if (priv->pshare->rf_ft_var.swq_dbg == 39)
    {
        unsigned int temp_buf32, buf32 = _INTERWORKING_SUPPORT_BY_DW_, frlen=0;
        unsigned char tmp[]={0x0f,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff};

        temp_buf32 = cpu_to_le32(buf32);
        pbuf = set_ie(pbuf, _EXTENDED_CAP_IE_, 4, &temp_buf32, &frlen);
        txinsn.fr_len += frlen;

        frlen = 0;
        pbuf = set_ie(pbuf, _INTERWORKING_IE_, 9, tmp, &frlen);
        txinsn.fr_len += frlen;
    }
#endif
#endif


#ifdef A4_STA
    if(priv->pmib->miscEntry.a4_enable == 2) {
        pbuf = construct_ecm_tvm_ie(priv, pbuf, &txinsn.fr_len, BIT0);
    }
#endif

#ifdef CONFIG_RTK_MESH	// mesh_profile Configure by WEB in the future, Maybe delete, Preservation before delete
	if((TRUE == is_11s) && (1 == GET_MIB(priv)->dot1180211sInfo.mesh_enable) && (TRUE == priv->mesh_profile[0].used)
			&& (MESH_PEER_LINK_CAP_NUM(priv) > 0))
	{
// ==== modified by GANTOE for site survey 2008/12/25 ====
		if(priv->auto_channel == 0)
			pbuf = set_ie(pbuf, _MESH_ID_IE_, 0, "", &txinsn.fr_len);
		else
			pbuf = set_ie(pbuf, _MESH_ID_IE_, mesh_ie_MeshID(priv, meshiearray, FALSE), meshiearray, &txinsn.fr_len);
		pbuf = set_ie(pbuf, _WLAN_MESH_CAP_IE_, mesh_ie_WLANMeshCAP(priv, meshiearray), meshiearray, &txinsn.fr_len);
	}
#endif

#ifdef CONFIG_MBO_CLI
		pbuf = construct_probe_req_mbo_ie(pbuf, &txinsn.fr_len);
#endif

	SetFrameSubType(txinsn.phdr, WIFI_PROBEREQ);

	if (da)
		memcpy((void *)GetAddr1Ptr((txinsn.phdr)), da, MACADDRLEN); // unicast
	else
		memset((void *)GetAddr1Ptr((txinsn.phdr)), 0xff, MACADDRLEN); // broadcast
	memcpy((void *)GetAddr2Ptr((txinsn.phdr)), hwaddr, MACADDRLEN);
	//nctu note
	// spec define ProbeREQ Address 3 is BSSID or wildcard) (Refer: Draft 1.06, Page 12, 7.2.3, Line 27~28)
	memset((void *)GetAddr3Ptr((txinsn.phdr)), 0xff, MACADDRLEN);

#ifdef CTC_WIFI_DIAG
	ctcwifi_diag_log(priv, da, 1, "Probe Request", (unsigned char *)(txinsn.pframe), txinsn.fr_len);
#endif

	if ((rtl8192cd_firetx(priv, &txinsn)) == SUCCESS)
        return;
	
issue_probereq_fail:
    NDEBUG("tx probe_req fail!!\n");    
    if(RTL_R8(TXPAUSE)){
        NDEBUG("!!!tx_pause_val[%X]\n",RTL_R8(TXPAUSE));
    } 

	if (txinsn.phdr)
		release_wlanhdr_to_poll(priv, txinsn.phdr);
	if (txinsn.pframe)
		release_mgtbuf_to_poll(priv, txinsn.pframe);
}


#if defined(CLIENT_MODE) && defined(WIFI_11N_2040_COEXIST)
static void issue_coexist_mgt(struct rtl8192cd_priv *priv)
{
	unsigned char	*pbuf;
	unsigned int len = 0, ch_len=0, i=0;
	DECLARE_TXINSN(txinsn);

	txinsn.q_num = MANAGE_QUE_NUM;
	txinsn.fr_type = _PRE_ALLOCMEM_;
#ifdef P2P_SUPPORT	/*cfg p2p cfg p2p*/
	if(rtk_p2p_is_enabled(priv)){
      	txinsn.tx_rate = _6M_RATE_;
	}else
#endif    
    	txinsn.tx_rate = find_rate(priv, NULL, 0, 1);
#ifndef TX_LOWESTRATE
	txinsn.lowest_tx_rate = txinsn.tx_rate;
#endif	
	txinsn.fixed_rate = 1;

	pbuf = txinsn.pframe = get_mgtbuf_from_poll(priv);
	if (pbuf == NULL)
		goto issue_coexist_mgt_fail;

	txinsn.phdr = get_wlanhdr_from_poll(priv);
	if (txinsn.phdr == NULL)
		goto issue_coexist_mgt_fail;

	memset((void *)(txinsn.phdr), 0, sizeof(struct wlan_hdr));

	pbuf[0] = _PUBLIC_CATEGORY_ID_;
	pbuf[1] = _2040_COEXIST_ACTION_ID_;
	len+=2;

	pbuf[2] = _2040_BSS_COEXIST_IE_;
	pbuf[3] = 1;
	len+=2;

	if (priv->intolerant_timeout)
		pbuf[4] = _20M_BSS_WIDTH_REQ_;
	else
		pbuf[4] = 0;
	len+=1;

	if (priv->bg_ap_timeout) {
		pbuf[5] = _2040_Intolerant_ChRpt_IE_;
		pbuf[7] = 0; /*set category*/
		for (i=0; i<14; i++) {
			if (priv->bg_ap_timeout_ch[i]) {
				pbuf[8+ch_len] = i+1;/*set channels*/
				ch_len++;
			}
		}
		pbuf[6] = ch_len+1;
		len += (pbuf[6]+2);
	}

	txinsn.fr_len = len;
	SetFrameSubType((txinsn.phdr), WIFI_WMM_ACTION);
	memcpy((void *)GetAddr1Ptr((txinsn.phdr)), BSSID, MACADDRLEN);
	memcpy((void *)GetAddr2Ptr((txinsn.phdr)), GET_MY_HWADDR, MACADDRLEN);
	memcpy((void *)GetAddr3Ptr((txinsn.phdr)), BSSID, MACADDRLEN);

	DEBUG_INFO("Coexist-mgt sent to AP\n");

	if ((rtl8192cd_firetx(priv, &txinsn)) == SUCCESS)
		return;

issue_coexist_mgt_fail:

	if (txinsn.phdr)
		release_wlanhdr_to_poll(priv, txinsn.phdr);
	if (txinsn.pframe)
		release_mgtbuf_to_poll(priv, txinsn.pframe);
	return;
}
#endif


#ifdef WIFI_WMM

#if 0
void issue_DELBA(struct rtl8192cd_priv *priv, struct stat_info *pstat, unsigned char TID, unsigned char initiator)
{
	unsigned char	*pbuf;
	unsigned short	delba_para = 0;
	DECLARE_TXINSN(txinsn);

	txinsn.q_num = MANAGE_QUE_NUM;
	txinsn.fr_type = _PRE_ALLOCMEM_;
	txinsn.tx_rate = find_rate(priv, NULL, 0, 1);
#ifndef TX_LOWESTRATE	
	txinsn.lowest_tx_rate = txinsn.tx_rate;
#endif	
	txinsn.fixed_rate = 1;

	pbuf = txinsn.pframe = get_mgtbuf_from_poll(priv);
	if (pbuf == NULL)
		goto issue_DELBA_fail;

	txinsn.phdr = get_wlanhdr_from_poll(priv);
	if (txinsn.phdr == NULL)
		goto issue_DELBA_fail;

	memset((void *)(txinsn.phdr), 0, sizeof(struct wlan_hdr));

	pbuf[0] = _BLOCK_ACK_CATEGORY_ID_;
	pbuf[1] = _DELBA_ACTION_ID_;
	delba_para = initiator << 11 | TID << 12;	// assign buffer size | assign TID | set Immediate Block Ack
	pbuf[2] = initiator << 3 | TID << 4;
	pbuf[3] = 0;
	pbuf[4] = 38;//reason code
	pbuf[5] = 0;

	/* set the immediate next seq number of the "TID", as Block Ack Starting Seq*/

	txinsn.fr_len = _DELBA_Frame_Length;

	SetFrameSubType((txinsn.phdr), WIFI_WMM_ACTION);
	memcpy((void *)GetAddr1Ptr((txinsn.phdr)), pstat->cmn_info.mac_addr, MACADDRLEN);
	memcpy((void *)GetAddr2Ptr((txinsn.phdr)), GET_MY_HWADDR, MACADDRLEN);
	memcpy((void *)GetAddr3Ptr((txinsn.phdr)), BSSID, MACADDRLEN);

	DEBUG_INFO("issue_DELBAreq sent to AID %d, token %d TID %d size %d seq %d\n",
		pstat->cmn_info.aid, pstat->dialog_token, TID, max_size, pstat->AC_seq[TID]);

	if ((rtl8192cd_firetx(priv, &txinsn)) == SUCCESS)
		return;

issue_DELBA_fail:

	if (txinsn.phdr)
		release_wlanhdr_to_poll(priv, txinsn.phdr);
	if (txinsn.pframe)
		release_mgtbuf_to_poll(priv, txinsn.pframe);
	return;
}
#endif

void issue_ADDBAreq(struct rtl8192cd_priv *priv, struct stat_info *pstat, unsigned char TID)
{
	unsigned char	*pbuf;
	unsigned short	ba_para = 0;
#ifdef WLAN_HAL_HW_SEQ
    unsigned char	cam_idx = 0;
    unsigned int	hw_seq = 0;
#endif //WLAN_HAL_HW_SEQ

#if defined(WIFI_WMM)
	int ret=0;
#endif
	int max_size;
	DECLARE_TXINSN(txinsn);

	txinsn.q_num = MANAGE_QUE_NUM;
	txinsn.fr_type = _PRE_ALLOCMEM_;

#ifdef CONFIG_IEEE80211W		
	if(pstat)
		txinsn.isPMF = pstat->isPMF;
	else
		txinsn.isPMF = 0;	
#endif	
	
#ifdef P2P_SUPPORT	/*cfg p2p cfg p2p*/
	if(rtk_p2p_is_enabled(priv)){
      	txinsn.tx_rate = _6M_RATE_;
	}else
#endif    
    	txinsn.tx_rate = find_rate(priv, NULL, 0, 1);
#ifndef TX_LOWESTRATE
	txinsn.lowest_tx_rate = txinsn.tx_rate;
#endif	
	txinsn.fixed_rate = 1;

	pbuf = txinsn.pframe = get_mgtbuf_from_poll(priv);
	if (pbuf == NULL)
		goto issue_ADDBAreq_fail;

	txinsn.phdr = get_wlanhdr_from_poll(priv);
	if (txinsn.phdr == NULL)
		goto issue_ADDBAreq_fail;

	memset((void *)(txinsn.phdr), 0, sizeof(struct wlan_hdr));

	if (!(++pstat->dialog_token))	// dialog token set to a non-zero value
		pstat->dialog_token++;

	pbuf[0] = _BLOCK_ACK_CATEGORY_ID_;
	pbuf[1] = _ADDBA_Req_ACTION_ID_;
	pbuf[2] = pstat->dialog_token;

	if (should_restrict_Nrate(priv, pstat))
		max_size = 1;
	else {
#ifdef CONFIG_RTL8196B_GW_8M
		if (pstat->IOTPeer==HT_IOT_PEER_BROADCOM)
			max_size = _ADDBA_Maximum_Buffer_Size_ / 2;
	else
#endif
		max_size = _ADDBA_Maximum_Buffer_Size_;
	}

	ba_para = (max_size<<6) | (TID<<2) | BIT(1);	// assign buffer size | assign TID | set Immediate Block Ack

#if defined(SUPPORT_RX_AMSDU_AMPDU)
	if(AMSDU_ENABLE >= 2) {
		if (!((GET_CHIP_VER(priv)== VERSION_8814A) && priv->pmib->dot11nConfigEntry.dot11nUse40M == 0))
			ba_para |= BIT(0);			// AMSDU
	}
#endif

	pbuf[3] = ba_para & 0x00ff;
	pbuf[4] = (ba_para & 0xff00) >> 8;

	// set Block Ack Timeout value to zero, to disable the timeout
	pbuf[5] = 0;
	pbuf[6] = 0;

#ifdef WLAN_HAL_HW_SEQ
    if(IS_SUPPORT_HW_SEQ(priv)) {
#if IS_RTL88XX_MAC_V4
        if(_GET_HAL_DATA(priv)->MacVersion.is_MAC_v4)
            cam_idx = GET_HAL_INTERFACE(priv)->GetSmhCamHandler(priv,pstat);
#endif
#if IS_RTL88XX_MAC_V2_V3
        if(_GET_HAL_DATA(priv)->MacVersion.is_MAC_v2_v3)
            cam_idx = REMAP_AID(pstat);
#endif      
        GET_HAL_INTERFACE(priv)->GetHwSequenceHandler(priv, cam_idx, TID, &hw_seq);      

    	pbuf[7] = ((hw_seq & 0xfff) << 4) & 0x00ff;
    	pbuf[8] = (((hw_seq & 0xfff) << 4) & 0xff00) >> 8;      
    }else
#endif 
    {
    	// set the immediate next seq number of the "TID", as Block Ack Starting Seq
#ifdef CONFIG_SPECIAL_ENV_TEST
		if (pstat->sn_avg_gap)
			pstat->AC_seq[TID] =((pstat->cmn_info.aid*pstat->sn_avg_gap) & 0xfff);
		else if ((priv->pshare->rf_ft_var.spec_env_test_en & BIT(0)) && priv->assoc_num > 1)
			pstat->AC_seq[TID] =((pstat->cmn_info.aid*500) & 0xfff);
#endif

    	pbuf[7] = ((pstat->AC_seq[TID] & 0xfff) << 4) & 0x00ff;
    	pbuf[8] = (((pstat->AC_seq[TID] & 0xfff) << 4) & 0xff00) >> 8;
    }

	txinsn.fr_len = _ADDBA_Req_Frame_Length_;
	SetFrameSubType((txinsn.phdr), WIFI_WMM_ACTION);
#ifdef CONFIG_IEEE80211W
	if (txinsn.isPMF)
		*(unsigned char*)(txinsn.phdr+1) |= BIT(6); // enable privacy
#endif

	memcpy((void *)GetAddr1Ptr((txinsn.phdr)), pstat->cmn_info.mac_addr, MACADDRLEN);
	memcpy((void *)GetAddr2Ptr((txinsn.phdr)), GET_MY_HWADDR, MACADDRLEN);
	memcpy((void *)GetAddr3Ptr((txinsn.phdr)), BSSID, MACADDRLEN);

	DEBUG_INFO("ADDBA-req sent to AID %d, token %d TID %d size %d seq %d\n",
		pstat->cmn_info.aid, pstat->dialog_token, TID, max_size, pstat->AC_seq[TID]);
	/*
	panic_printk("ADDBA-req sent to AID %d, token %d TID %d size %d seq %d\n",
		pstat->cmn_info.aid, pstat->dialog_token, TID, max_size, pstat->AC_seq[TID]);
	*/
#if defined(WIFI_WMM)
	ret = check_dz_mgmt(priv, pstat, &txinsn);
	if (ret < 0)
		goto issue_ADDBAreq_fail;
	else if (ret==1)
		return;
	else
#endif
	if ((rtl8192cd_firetx(priv, &txinsn)) == SUCCESS) {
		//pstat->ADDBA_ready++;
		return;
	}

issue_ADDBAreq_fail:

	if (txinsn.phdr)
		release_wlanhdr_to_poll(priv, txinsn.phdr);
	if (txinsn.pframe)
		release_mgtbuf_to_poll(priv, txinsn.pframe);
	return;
}

#if defined(CONFIG_WLAN_HAL_8814BE)
void prepare_ADDBAreq(struct rtl8192cd_priv *priv, struct stat_info *pstat, unsigned char TID)
{
	/* issue addba at _query_seq_done */
	dc_query_seq(priv, pstat, TID);
}
#endif

#ifdef HS2_SUPPORT
int issue_QoS_MAP_Configure(struct rtl8192cd_priv *priv, unsigned char *da, unsigned char indexQoSMAP) // QoS Action Frame (Robust)
{
	unsigned char rnd;
	unsigned char	*pbuf;
	struct stat_info *pstat;
	unsigned char zeromac[6]={0x00,0x00,0x00,0x00,0x00,0x00};

	struct wifi_mib *pmib;
	pmib = GET_MIB(priv);
			
#if defined(WIFI_WMM)
	int ret;
#endif	

	DECLARE_TXINSN(txinsn);

	if(priv->pmib->hs2Entry.QoSMap_ielen[indexQoSMAP] == 0)
		goto issue_QoS_MAP_CONFIGURE_fail;			

	HS2_DEBUG_INFO("iface: %s, da:%02x%02x%02x%02x%02x%02x\n",priv->dev->name,da[0],da[1],da[2],da[3],da[4],da[5]);

	txinsn.q_num = MANAGE_QUE_NUM;
	txinsn.fr_type = _PRE_ALLOCMEM_;
	
#ifdef CONFIG_IEEE80211W	
		struct stat_info *psta; 
		if(!memcmp(da,"\xff\xff\xff\xff\xff\xff",6)) {
			txinsn.isPMF = 1; //?????
		} else {
			psta = get_stainfo(priv,da);
			if(psta)
				txinsn.isPMF = psta->isPMF;
			else
				txinsn.isPMF = 0;
		}	
		//printk("deauth:txinsn.isPMF=%d\n",txinsn.isPMF);
#endif
	txinsn.tx_rate = find_rate(priv, NULL, 0, 1);
	txinsn.lowest_tx_rate = txinsn.tx_rate;
	txinsn.fixed_rate = 1;
	pbuf = txinsn.pframe = get_mgtbuf_from_poll(priv);
	if (pbuf == NULL)
		goto issue_QoS_MAP_CONFIGURE_fail;

	txinsn.phdr = get_wlanhdr_from_poll(priv);
	if (txinsn.phdr == NULL)
		goto issue_QoS_MAP_CONFIGURE_fail;

	memset((void *)(txinsn.phdr), 0, sizeof(struct wlan_hdr));

	pbuf[0] = _QOS_CATEGORY_ID_;
	pbuf[1] = _QOS_MAP_CONFIGURE_ID_;
	pbuf[2] = _QOS_MAP_SET_IE_;
	pbuf[3] = priv->pmib->hs2Entry.QoSMap_ielen[indexQoSMAP];

	if(priv->pmib->hs2Entry.QoSMap_ielen[indexQoSMAP] != 0) {
		memcpy(pbuf+4,priv->pmib->hs2Entry.QoSMap_ie[indexQoSMAP],priv->pmib->hs2Entry.QoSMap_ielen[indexQoSMAP]);	
		txinsn.fr_len += 4 + priv->pmib->hs2Entry.QoSMap_ielen[indexQoSMAP];
	}
	
	
	SetFrameSubType((txinsn.phdr), WIFI_WMM_ACTION);
	
#ifdef CONFIG_IEEE80211W	
	if (txinsn.isPMF)
		*(unsigned char*)(txinsn.phdr+1) |= BIT(6); // enable privacy 
#endif		

	memcpy((void *)GetAddr1Ptr((txinsn.phdr)), da, MACADDRLEN);
	memcpy((void *)GetAddr2Ptr((txinsn.phdr)), GET_MY_HWADDR, MACADDRLEN);
	memcpy((void *)GetAddr3Ptr((txinsn.phdr)), BSSID, MACADDRLEN);
	pstat = get_stainfo(priv, da);
	
	if (pstat == NULL)
		goto issue_QoS_MAP_CONFIGURE_fail; 	
		
	txinsn.pstat = pstat;
	
#if defined(WIFI_WMM)
	ret = check_dz_mgmt(priv, pstat, &txinsn);
	if (ret < 0)
		goto issue_QoS_MAP_CONFIGURE_fail;
	else if (ret==1) {
		HS2_DEBUG_INFO("issue_QoS_MAP_Configure success\n");
		return SUCCESS;
	}
	else
#endif
	{		
		if ((rtl8192cd_firetx(priv, &txinsn)) == SUCCESS) {
			HS2_DEBUG_INFO("issue_QoS_MAP_Configure success\n");
			return SUCCESS; 
		}
	}
	
issue_QoS_MAP_CONFIGURE_fail:
	HS2_DEBUG_ERR("issue_QoS_MAP_Configure failed\n");

	if (txinsn.phdr)
		release_wlanhdr_to_poll(priv, txinsn.phdr);
	if (txinsn.pframe)
		release_mgtbuf_to_poll(priv, txinsn.pframe);
		
	return FAIL;	
}


int issue_WNM_Notify(struct rtl8192cd_priv *priv)
{
	unsigned char rnd;
	unsigned char	*pbuf;
	struct stat_info *pstat;
	unsigned char zeromac[6]={0x00,0x00,0x00,0x00,0x00,0x00};

	struct wifi_mib *pmib;
	pmib = GET_MIB(priv);
			
#if defined(WIFI_WMM)
	int ret;
#endif	


	DECLARE_TXINSN(txinsn);

	HS2_DEBUG_INFO("iface: %s, sta_mac:%02x%02x%02x%02x%02x%02x\n",priv->dev->name,priv->pmib->hs2Entry.sta_mac[0],priv->pmib->hs2Entry.sta_mac[1],priv->pmib->hs2Entry.sta_mac[2],priv->pmib->hs2Entry.sta_mac[3],priv->pmib->hs2Entry.sta_mac[4],priv->pmib->hs2Entry.sta_mac[5]);
	if(!memcmp(priv->pmib->hs2Entry.sta_mac,zeromac,6))  {
		HS2_DEBUG_ERR("sta_mac is zeromac\n");
		goto issue_WNM_NOTIFY_fail;
	}			

	txinsn.q_num = MANAGE_QUE_NUM;
	txinsn.fr_type = _PRE_ALLOCMEM_;
	
#ifdef CONFIG_IEEE80211W	
		struct stat_info *psta; 
		if(!memcmp(priv->pmib->hs2Entry.sta_mac,"\xff\xff\xff\xff\xff\xff",6)) {
			HS2_DEBUG_ERR("WNM_NOTIFY_FAIL: Cannot be multicast da.\n");
			goto issue_WNM_NOTIFY_fail;
		} else {
			psta = get_stainfo(priv,priv->pmib->hs2Entry.sta_mac);
			if(psta)
				txinsn.isPMF = 1;
			else
				goto issue_WNM_NOTIFY_fail;
		}	
		//printk("deauth:txinsn.isPMF=%d\n",txinsn.isPMF);
#endif

    if(txinsn.isPMF == 0) {
		HS2_DEBUG_ERR("\n\nWNM_NOTIFY_FAIL: PMF is not Enabled, psta=%x\n\n");
		goto issue_WNM_NOTIFY_fail;
    }
 	txinsn.tx_rate = find_rate(priv, NULL, 0, 1);
	txinsn.lowest_tx_rate = txinsn.tx_rate;
	txinsn.fixed_rate = 1;
	pbuf = txinsn.pframe = get_mgtbuf_from_poll(priv);
	if (pbuf == NULL)
		goto issue_WNM_NOTIFY_fail;

	txinsn.phdr = get_wlanhdr_from_poll(priv);
	if (txinsn.phdr == NULL)
		goto issue_WNM_NOTIFY_fail;

	memset((void *)(txinsn.phdr), 0, sizeof(struct wlan_hdr));

	pbuf[0] = _WNM_CATEGORY_ID_;
	pbuf[1] = _WNM_NOTIF_REQ_ACTION_ID_;
	pbuf[2] = 4;			//token
	pbuf[3] = 1;				//type
	pbuf[4] = 221;	//Subelement ID
	pbuf[5] = 5 + strlen(priv->pmib->hs2Entry.remedSvrURL);
	pbuf[6] = 0x50;
	pbuf[7] = 0x6F;
	pbuf[8] = 0x9A;
	pbuf[9] = 0x00;	// Subelement Type
	pbuf[10] = strlen(priv->pmib->hs2Entry.remedSvrURL);
	strcpy(pbuf+11,priv->pmib->hs2Entry.remedSvrURL);
	#if 0
	pbuf[11+strlen(priv->pmib->hs2Entry.remedSvrURL)] = priv->pmib->hs2Entry.serverMethod;
	#endif
	
	SDEBUG("issue_WNM_Notify,remedSvrURL=%s\n",priv->pmib->hs2Entry.remedSvrURL);	
#if 0	
	SDEBUG("issue_WNM_Notify,serverMethod=%d\n",priv->pmib->hs2Entry.serverMethod);	
	txinsn.fr_len += 11 + strlen(priv->pmib->hs2Entry.remedSvrURL)+1;
#else
	txinsn.fr_len += 11 + strlen(priv->pmib->hs2Entry.remedSvrURL);
#endif
	
	
	
	SetFrameSubType((txinsn.phdr), WIFI_WMM_ACTION);
#ifdef CONFIG_IEEE80211W	
	if (txinsn.isPMF)
		*(unsigned char*)(txinsn.phdr+1) |= BIT(6); // enable privacy 
#endif		

	memcpy((void *)GetAddr1Ptr((txinsn.phdr)), priv->pmib->hs2Entry.sta_mac, MACADDRLEN);
	memcpy((void *)GetAddr2Ptr((txinsn.phdr)), GET_MY_HWADDR, MACADDRLEN);
	memcpy((void *)GetAddr3Ptr((txinsn.phdr)), BSSID, MACADDRLEN);
	pstat = get_stainfo(priv, priv->pmib->hs2Entry.sta_mac);
	
	if (pstat == NULL)
		goto issue_WNM_NOTIFY_fail;		
		
	txinsn.pstat = pstat;
	
#if defined(WIFI_WMM)
	ret = check_dz_mgmt(priv, pstat, &txinsn);
	if (ret < 0)
		goto issue_WNM_NOTIFY_fail;
	else if (ret==1) {
		HS2_DEBUG_INFO("issue_WNM_Notify success\n");
		return SUCCESS;
	}
	else
#endif
	{		
		if ((rtl8192cd_firetx(priv, &txinsn)) == SUCCESS) {
			HS2_DEBUG_INFO("issue_WNM_Notify success\n");
			return SUCCESS;	
		}
	}
	
issue_WNM_NOTIFY_fail:
	PMFDEBUG("issue_WNM_NOTIFY failed\n");

	if (txinsn.phdr)
		release_wlanhdr_to_poll(priv, txinsn.phdr);
	if (txinsn.pframe)
		release_mgtbuf_to_poll(priv, txinsn.pframe);
		
	return FAIL;	
}

int issue_WNM_Deauth_Req(struct rtl8192cd_priv *priv, unsigned char *da, unsigned char reason, unsigned short ReAuthDelay, unsigned char *URL)
{
	unsigned char rnd;
	unsigned char	*pbuf;
	struct stat_info *pstat;
	unsigned char zeromac[6]={0x00,0x00,0x00,0x00,0x00,0x00};

	struct wifi_mib *pmib;
	pmib = GET_MIB(priv);
			
#if defined(WIFI_WMM)
	int ret;
#endif	


	DECLARE_TXINSN(txinsn);

	HS2_DEBUG_INFO("iface: %s, da:%02x%02x%02x%02x%02x%02x\n",priv->dev->name,da[0],da[1],da[2],da[3],da[4],da[5]);
	if(!memcmp(da,zeromac,6))  {
		HS2_DEBUG_ERR("da is zeromac\n");
		goto issue_WNM_DEAUTH_fail;
	}

	txinsn.q_num = MANAGE_QUE_NUM;
	txinsn.fr_type = _PRE_ALLOCMEM_;
	
#ifdef CONFIG_IEEE80211W	
		struct stat_info *psta; 
		if(!memcmp(da,"\xff\xff\xff\xff\xff\xff",6)) {
			txinsn.isPMF = 1; //?????
		} else {
			psta = get_stainfo(priv,da);
			if(psta)
				txinsn.isPMF = psta->isPMF;
			else
				txinsn.isPMF = 0;
		}	
		//printk("deauth:txinsn.isPMF=%d\n",txinsn.isPMF);
#endif
	txinsn.tx_rate = find_rate(priv, NULL, 0, 1);
	txinsn.lowest_tx_rate = txinsn.tx_rate;
	txinsn.fixed_rate = 1;

	pbuf = txinsn.pframe = get_mgtbuf_from_poll(priv);
	if (pbuf == NULL) {
		HS2_DEBUG_ERR("issue_WNM_DEAUTH_fail\n");
		goto issue_WNM_DEAUTH_fail;
	}
	

	txinsn.phdr = get_wlanhdr_from_poll(priv);
	if (txinsn.phdr == NULL) {
		HS2_DEBUG_ERR("issue_WNM_DEAUTH_fail\n");
		goto issue_WNM_DEAUTH_fail;
	}

	memset((void *)(txinsn.phdr), 0, sizeof(struct wlan_hdr));

	pbuf[0] = _WNM_CATEGORY_ID_;
	pbuf[1] = _WNM_NOTIF_REQ_ACTION_ID_;
	pbuf[2] = 4;			//token
	pbuf[3] = 1;			//type
	pbuf[4] = 221;			//Subelement ID
	pbuf[5] = 8 + strlen(URL);
	pbuf[6] = 0x50;
	pbuf[7] = 0x6F;
	pbuf[8] = 0x9A;
	pbuf[9] = 0x01;	// Subelement Type
	pbuf[10] = reason;
	pbuf[11] = ReAuthDelay & 0x00ff;
	pbuf[12] = (ReAuthDelay & 0xff00) >> 8; 
	pbuf[13] = strlen(URL);	 // Reason URL Length

	strcpy(pbuf+14,URL); // Reason URL
	HS2_DEBUG_INFO("URL=%s\n",URL);	
	txinsn.fr_len += 14+strlen(URL);
	
	
	SetFrameSubType((txinsn.phdr), WIFI_WMM_ACTION);
#ifdef CONFIG_IEEE80211W	
	if (txinsn.isPMF)
		*(unsigned char*)(txinsn.phdr+1) |= BIT(6); // enable privacy 
#endif		
	memcpy((void *)GetAddr1Ptr((txinsn.phdr)), da, MACADDRLEN);
	memcpy((void *)GetAddr2Ptr((txinsn.phdr)), GET_MY_HWADDR, MACADDRLEN);
	memcpy((void *)GetAddr3Ptr((txinsn.phdr)), BSSID, MACADDRLEN);
	
	pstat = get_stainfo(priv, da);	
	if (pstat == NULL)
		goto issue_WNM_DEAUTH_fail;
			
	txinsn.pstat = pstat;
	
#if defined(WIFI_WMM)
	ret = check_dz_mgmt(priv, pstat, &txinsn);		
	if (ret < 0)
		goto issue_WNM_DEAUTH_fail;
	else if (ret==1) {
		return SUCCESS;
	}
	else
#endif
	{
		if ((rtl8192cd_firetx(priv, &txinsn)) == SUCCESS)
			return SUCCESS;	
	}
	
issue_WNM_DEAUTH_fail:
	HS2_DEBUG_INFO("issue_WNM_DEAUTH failed\n");

	if (txinsn.phdr)
		release_wlanhdr_to_poll(priv, txinsn.phdr);
	if (txinsn.pframe)
		release_mgtbuf_to_poll(priv, txinsn.pframe);
		
	return FAIL;	
}
#ifdef HS2_CLIENT_TEST

//issue_GASreq for client test used
int issue_GASreq(struct rtl8192cd_priv *priv, DOT11_HS2_GAS_REQ *gas_req, unsigned short qid)
{
	unsigned char	*pbuf;
	struct stat_info *pstat;
#if defined(WIFI_WMM)
	int ret;
#endif	
	DECLARE_TXINSN(txinsn);
	
	txinsn.q_num = MANAGE_QUE_NUM;
	txinsn.fr_type = _PRE_ALLOCMEM_;
	txinsn.tx_rate = find_rate(priv, NULL, 0, 1);
#ifndef TX_LOWESTRATE	
	txinsn.lowest_tx_rate = txinsn.tx_rate;
#endif	
	txinsn.fixed_rate = 1;
	
	pbuf = txinsn.pframe = get_mgtbuf_from_poll(priv);

	txinsn.phdr = get_wlanhdr_from_poll(priv);

	memset((void *)(txinsn.phdr), 0, sizeof(struct wlan_hdr));

	if (qid != 10000)
	{
		if (qid < 500)
		{	
			if (qid == 0)
				gas_req->Reqlen = 0;
			else if (qid == 270)
				gas_req->Reqlen = 26;	
			else if (qid == 271)
				gas_req->Reqlen = 27;
			// else if (qid == 272)
			// 	gas_req->Reqlen = 15;
			else
				gas_req->Reqlen = 6;
		}
		else if(qid == 501)
			gas_req->Reqlen = 12;
		else if(qid == 502)
			gas_req->Reqlen = 12;
		else if(qid == 503)
			gas_req->Reqlen = 24;		
		else if(qid == 504)
			gas_req->Reqlen = 36;
		else if(qid == 505)
			gas_req->Reqlen = 44;
		else if(qid == 506)
			gas_req->Reqlen = 11;
		else if(qid == 507)
			gas_req->Reqlen = 11;
		else if(qid == 508)
			gas_req->Reqlen = 25;
		else if(qid == 509)
			gas_req->Reqlen = 19;
	}
	else
		gas_req->Reqlen = 10;
	
	if ((OPMODE & WIFI_ASOC_STATE) == 0)
	{		
		//unsigned char tmpmac[]={0x00,0xe0,0x4c,0x09,0x08,0x10};
		//memcpy((GET_MIB(priv))->dot11StationConfigEntry.dot11Bssid, tmpmac, 6);
		memcpy((GET_MIB(priv))->dot11StationConfigEntry.dot11Bssid, priv->pmib->hs2Entry.redir_mac, 6);
	}	
	memcpy(gas_req->MACAddr , BSSID, 6);
//	gas_req->MACAddr[1] = 0x33;
//	gas_req->MACAddr[2] = 0x44;
//	gas_req->MACAddr[3] = 0x55;
//	gas_req->MACAddr[4] = 0x66;
//	gas_req->MACAddr[5] = 0x77;
	
	pbuf[0] = _PUBLIC_CATEGORY_ID_;
	if (qid != 0)
		pbuf[1] = _GAS_INIT_REQ_ACTION_ID_;
	else
		pbuf[1] = _GAS_COMBACK_REQ_ACTION_ID_;
		
	pbuf[2] = gas_req->Dialog_token;
	
	if (qid != 0)
	{
		// refer to Fig. 8-354 in IEEE 802.11 - 2012
		pbuf[3] = 108; // element ID: 108 (Advertisement Protocol IE)
		pbuf[4] = 2;  // length = 0x 02
		pbuf[5] = 0x00; // Query Response Length Limit
		pbuf[6] = 0;  // Advertisement Protcol ID = 0x0 (ANQP)
	if (priv->pshare->rf_ft_var.swq_dbg == 12)
		pbuf[6] = 1;	// Advertisement Protcol ID = 0x1 (MIH) 
	else	
		pbuf[6] = 0;	//  Advertisement Protcol ID = 0x0 (ANQP)
	pbuf[7] = gas_req->Reqlen & 0x00ff;	// Query Request length
	pbuf[8] = (gas_req->Reqlen & 0xff00) >> 8; // Query Request length
	pbuf[9] = 256 & 0x00ff; // Info ID = 256 ( Query List)
	// Query Request fields
	// Info ID = 256 ( Query List)
	pbuf[10] = (256 & 0xff00) >> 8;
	
	if (qid != 10000)
	{
		if (qid < 500)
		{
			if (qid == 270)
			{
				pbuf[11] = 2 & 0x00ff;			// length
				pbuf[12] = (2 & 0xff00) >> 8;
				pbuf[13] = 261 & 0x00ff;		// InfoID: Roaming list
				pbuf[14] = (261 & 0xff00) >> 8; // InfoID: Roaming list
				pbuf[15] = 0xdd;
				pbuf[16] = 0xdd;
				pbuf[17] = 0x06;
				pbuf[18] = 0x00;
				pbuf[19] = 0x50;
				pbuf[20] = 0x6f;
				pbuf[21] = 0x9a;
				pbuf[22] = 0x11;
				pbuf[23] = 0x04; // WAN Metrics
				pbuf[24] = 0x00;
				pbuf[25] = 0xdd;
				pbuf[26] = 0xdd;
				pbuf[27] = 0x06;
				pbuf[28] = 0x00;
				pbuf[29] = 0x50;
				pbuf[30] = 0x6f;
				pbuf[31] = 0x9a;
				pbuf[32] = 0x11;
				pbuf[33] = 0x07; // Operating Class Indication
				pbuf[34] = 0x00;
				txinsn.fr_len += 35;
			}
			else if (qid == 271)
			{
				pbuf[11] = 2 & 0x00ff;
				pbuf[12] = (2 & 0xff00) >> 8;
				pbuf[13] = 261 & 0x00ff;		// InfoID: Roaming list
				pbuf[14] = (261 & 0xff00) >> 8; // InfoID: Roaming list
				pbuf[15] = 0xdd;
				pbuf[16] = 0xdd;
				pbuf[17] = 0x06;
				pbuf[18] = 0x00;
				pbuf[19] = 0x50;
				pbuf[20] = 0x6f;
				pbuf[21] = 0x9a;
				pbuf[22] = 0x0b;
				pbuf[23] = 0x00; // Subtype = 0 (Reserved)
				pbuf[24] = 0x00;
				pbuf[25] = 0xdd;
				pbuf[26] = 0xdd;
				pbuf[27] = 0x07;
				pbuf[28] = 0x00;
				pbuf[29] = 0x50;
				pbuf[30] = 0x6f;
				pbuf[31] = 0x9a;
				pbuf[32] = 0x11;
				pbuf[33] = 0x01; // HS Query List
				pbuf[34] = 0x00;
				pbuf[35] = 0x07; // Query Operating Class Indication
				txinsn.fr_len += 24;
			} 
			// else if (qid  == 272) {
			// 	pbuf[11] = 2& 0x00ff;
			// 	pbuf[12] = (2& 0xff00) >> 8;
			// 	pbuf[13] = 261 & 0x00ff;		// InfoID: Roaming list
			// 	pbuf[14] = (261 & 0xff00) >> 8; // InfoID: Roaming list
			// 	pbuf[15] = 0xdd;
			// 	pbuf[16] = 0xdd;
			// 	pbuf[17] = 0x05;
			// 	pbuf[18] = 0x00;
			// 	pbuf[19] = 0x50;
			// 	pbuf[20] = 0x6f;
			// 	pbuf[21] = 0x9a;
			// 	pbuf[22] = 0x0b;
			// 	pbuf[23] = 0x00; // Subtype = 0 (Reserved)
			// 	txinsn.fr_len += 36;
			// }
			else
			{
				// ANQP Query List (Fig. 8-403 in IEEE 802.11-2012)
				// length = 2
				pbuf[11] = 2 & 0x00ff;	
				pbuf[12] = (2 & 0xff00) >> 8;
				// ANQP Query ID
				pbuf[13] = qid & 0x00ff;
				pbuf[14] = (qid & 0xff00) >> 8;
				txinsn.fr_len += 15;
			}
		}
		else if(qid == 501)
		{
			pbuf[9] = 56797 & 0x00ff;
			pbuf[10] = (56797 & 0xff00) >> 8;
			pbuf[11] = 0x08;
			pbuf[12] = 0;
			//OI
			pbuf[13] =0x50;
			pbuf[14] =0x6f;
			pbuf[15] =0x9a;
			pbuf[16] =0x11;			
			pbuf[17] =0x1; // HS query list
			pbuf[18] =0x0;
			//payload
			pbuf[19] =0x2; // HS Capability List
			pbuf[20] =0x3; // Operator Friendly Name
			txinsn.fr_len += 21;
		}
		else if(qid == 502)
		{
			pbuf[9] = 56797 & 0x00ff;
			pbuf[10] = (56797 & 0xff00) >> 8;
			pbuf[11] = 0x08;
			pbuf[12] = 0;
			//OI
			pbuf[13] =0x50;
			pbuf[14] =0x6f;
			pbuf[15] =0x9a;			
			pbuf[16] =0x11; 
			pbuf[17] =0x1; // HS query list
			pbuf[18] =0x0;
			//payload
			pbuf[19] =0x4;
			pbuf[20] =0x5;
			txinsn.fr_len += 21;
		}
		else if(qid == 505)
		{
			pbuf[9] = 56797 & 0x00ff;
            pbuf[10] = (56797 & 0xff00) >> 8;
            pbuf[11] = 0x08;
            pbuf[12] = 0;
			pbuf[13] =0x50;
            pbuf[14] =0x6f;
            pbuf[15] =0x9a;
			pbuf[16] =0x11;
			pbuf[17] =0x1; // HS query list
			pbuf[18] =0x0;
			pbuf[19] =0x4;
            pbuf[20] =0x5;
			pbuf[21] = 56797 & 0x00ff;
            pbuf[22] = (56797 & 0xff00) >> 8;
            pbuf[23] = 0x06;
            pbuf[24] = 0;
            pbuf[25] =0x50;
            pbuf[26] =0x6f;
            pbuf[27] =0x9a;
            pbuf[28] =0x0b;
            pbuf[29] =0x0; // Reserved
			pbuf[30] =0x0;
			pbuf[31] = 56797 & 0x00ff;
            pbuf[32] = (56797 & 0xff00) >> 8;
            pbuf[33] = 21;
            pbuf[34] = 0;
            pbuf[35] =0x50;
            pbuf[36] =0x6f;
            pbuf[37] =0x9a;
            pbuf[38] =0x11;
            pbuf[39] =0x06; // Subtype: NAI Home Realm Query
			pbuf[40] =0x0;
			pbuf[41] =0x1;
            pbuf[42] =0x0;
            pbuf[43] =0xc;
            pbuf[44] ='e';
            pbuf[45] ='x';
            pbuf[46] ='a';
            pbuf[47] ='m';
            pbuf[48] ='p';
            pbuf[49] ='l';
            pbuf[50] ='e';
            pbuf[51] ='.';
            pbuf[52] ='c';
            pbuf[53] ='o';
            pbuf[54] ='m';

            txinsn.fr_len += 55;

		}
		else if(qid == 503)
		{
			pbuf[9] = 56797 & 0x00ff;
			pbuf[10] = (56797 & 0xff00) >> 8;
			pbuf[11] = 21;
			pbuf[12] = 0;
			//OI
			pbuf[13] =0x50;
			pbuf[14] =0x6f;
			pbuf[15] =0x9a;
			//TYPE
			pbuf[16] =0x11;
			//home realm query
			pbuf[17] =0x6;
			pbuf[18] =0x0;
			//payload
			pbuf[19] =0x1;
			pbuf[20] =0x0;
			pbuf[21] =0xc;
			pbuf[22] ='e';
			pbuf[23] ='x';
			pbuf[24] ='a';
			pbuf[25] ='m';
			pbuf[26] ='p';
			pbuf[27] ='l';
			pbuf[28] ='e';
			pbuf[29] ='.';
			pbuf[30] ='c';
			pbuf[31] ='o';
			pbuf[32] ='m';
			txinsn.fr_len += 33;
		}
		else if (qid == 506)
		{
			pbuf[9] = 56797 & 0x00ff;
            pbuf[10] = (56797 & 0xff00) >> 8;
            pbuf[11] = 7;
            pbuf[12] = 0;
			pbuf[13] =0x50;
            pbuf[14] =0x6f;
            pbuf[15] =0x9a;
			pbuf[16] =0x11;
			pbuf[17] =0x6;
			pbuf[18] =0x0;
			pbuf[19] =0x0;
			txinsn.fr_len += 20;
		}
		else if (qid == 507)
        {
            pbuf[9] = 56797 & 0x00ff;
            pbuf[10] = (56797 & 0xff00) >> 8;
            pbuf[11] = 7;
            pbuf[12] = 0;
            pbuf[13] =0x50;
            pbuf[14] =0x6f;
            pbuf[15] =0x9a;
            pbuf[16] =0x11;
            pbuf[17] =0x1;
            pbuf[18] =0x0;
			pbuf[19] =0x7;
            txinsn.fr_len += 20;
        }
		else if (qid == 504)
		{
			pbuf[9] = 56797 & 0x00ff;
            pbuf[10] = (56797 & 0xff00) >> 8;
            pbuf[11] = 32;
            pbuf[12] = 0;
			pbuf[13] =0x50;
            pbuf[14] =0x6f;
            pbuf[15] =0x9a;
			pbuf[16] =0x11;
			pbuf[17] =0x6;
			pbuf[18] =0x0;
			pbuf[19] =0x2;
			pbuf[20] =0x0;
            pbuf[21] =0x9;
            pbuf[22] ='c';
            pbuf[23] ='i';
            pbuf[24] ='s';
            pbuf[25] ='c';
            pbuf[26] ='o';
            pbuf[27] ='.';
            pbuf[28] ='c';
            pbuf[29] ='o';
            pbuf[30] ='m';

            pbuf[31] =0x0;
            pbuf[32] =0xc;
            pbuf[33] ='e';
            pbuf[34] ='x';
            pbuf[35] ='a';
            pbuf[36] ='m';
            pbuf[37] ='p';
            pbuf[38] ='l';
            pbuf[39] ='e';
            pbuf[40] ='4';
            pbuf[41] ='.';
            pbuf[42] ='c';
            pbuf[43] ='o';
            pbuf[44] ='m';
            txinsn.fr_len += 45;
		}
		else if (qid == 508)
        {
            pbuf[9] = 56797 & 0x00ff;
            pbuf[10] = (56797 & 0xff00) >> 8;
            pbuf[11] = 15;
            pbuf[12] = 0;
            pbuf[13] =0x50;
            pbuf[14] =0x6f;
            pbuf[15] =0x9a;
            pbuf[16] =0x11;
            pbuf[17] =0xa;
            pbuf[18] =0x0;
			pbuf[19] ='1';
			pbuf[20] ='3';
			pbuf[21] ='5';
			pbuf[22] ='7';
			pbuf[23] ='1';			
			pbuf[24] ='6';
			pbuf[25] ='1';
			pbuf[26] ='4';
			pbuf[27] ='7';
			pbuf[28] ='5';
			pbuf[29] ='_';
			pbuf[30] ='w';
			pbuf[31] ='i';
			pbuf[32] ='f';
			pbuf[33] ='i';
			
            txinsn.fr_len += 34;
        }
		else if (qid == 509)
		{
			
			pbuf[11] = 4 & 0x00ff;			// length
			pbuf[12] = (4 & 0xff00) >> 8;
			pbuf[13] = 260 & 0x00ff;		// InfoID: Network Authentication Type
			pbuf[14] = (260 & 0xff00) >> 8; // InfoID: Network Authentication Type
			pbuf[15] = 263 & 0x00ff;		// InfoID: NAI Realm List
			pbuf[16] = (263 & 0xff00) >> 8; // InfoID: NAI Realm List
			pbuf[17] = 56797 & 0x00ff;
			pbuf[18] = (56797 & 0xff00) >> 8;
			pbuf[19] = 0x07;
			pbuf[20] = 0;
			//OI
			pbuf[21] =0x50;
			pbuf[22] =0x6f;
			pbuf[23] =0x9a;
			pbuf[24] =0x11;			
			pbuf[25] =0x1; // HS query list
			pbuf[26] =0x0;
			//payload
			pbuf[27] =0x8; // OSU Providers List
			txinsn.fr_len += 28;
		}
	}
	else
	{
		pbuf[11] = 6 & 0x00ff;
		pbuf[12] = (6 & 0xff00) >> 8;
		pbuf[13] = 263 & 0x00ff;
		pbuf[14] = (263 & 0xff00) >> 8;
		pbuf[15] = 264 & 0x00ff;
		pbuf[16] = (264 & 0xff00) >> 8;
		pbuf[17] = 268 & 0x00ff;
		pbuf[18] = (268 & 0xff00) >> 8;
		txinsn.fr_len += 19;
	}
	}
	else
	{
		txinsn.fr_len += 11;
	}
	SetFrameSubType((txinsn.phdr), WIFI_WMM_ACTION);

	memcpy((void *)GetAddr1Ptr((txinsn.phdr)), gas_req->MACAddr, MACADDRLEN);
	memcpy((void *)GetAddr2Ptr((txinsn.phdr)), GET_MY_HWADDR, MACADDRLEN);
	memcpy((void *)GetAddr3Ptr((txinsn.phdr)), gas_req->MACAddr, MACADDRLEN);
	
	if ((rtl8192cd_firetx(priv, &txinsn)) == SUCCESS)
		return SUCCESS;
}
#endif

int issue_GASrsp(struct rtl8192cd_priv *priv, DOT11_HS2_GAS_RSP *gas_rsp)
{
	unsigned char	*pbuf;
	struct stat_info *pstat;
#if defined(WIFI_WMM)
	int ret;
#endif	
	HS2_DEBUG_INFO("Rsp len=[%d]\n",gas_rsp->Rsplen);
	DECLARE_TXINSN(txinsn);
	
	txinsn.q_num = MANAGE_QUE_NUM;
	txinsn.fr_type = _PRE_ALLOCMEM_;
	txinsn.tx_rate = find_rate(priv, NULL, 0, 1);
#ifndef TX_LOWESTRATE
	txinsn.lowest_tx_rate = txinsn.tx_rate;
#endif	
	txinsn.fixed_rate = 1;
	
	pbuf = txinsn.pframe = get_mgtbuf_from_poll(priv);
	if (pbuf == NULL)
		goto issue_GASrsp_fail;

	txinsn.phdr = get_wlanhdr_from_poll(priv);
	if (txinsn.phdr == NULL)
		goto issue_GASrsp_fail;

	memset((void *)(txinsn.phdr), 0, sizeof(struct wlan_hdr));

	pbuf[0] = _PUBLIC_CATEGORY_ID_;
	pbuf[1] = gas_rsp->Action;
	pbuf[2] = gas_rsp->Dialog_token;
	pbuf[3] = gas_rsp->StatusCode & 0x00ff;
	pbuf[4] = (gas_rsp->StatusCode & 0xff00) >> 8;
	
	if (gas_rsp->Action == _GAS_INIT_RSP_ACTION_ID_)
	{
		pbuf[5] = gas_rsp->Comeback_delay & 0x00ff;
		pbuf[6] = (gas_rsp->Comeback_delay & 0xff00) >> 8;
		//advertisement protocol element
		pbuf[7] = 0x6c;
		pbuf[8] = 2;
		pbuf[9] = 0x20;
		pbuf[10] = 0;//gas_rsp->Advt_proto;
		//gas rsp
		pbuf[11] = gas_rsp->Rsplen & 0x00ff;
		pbuf[12] = (gas_rsp->Rsplen & 0xff00) >> 8;
		if (gas_rsp->Rsplen > 0)
			memcpy(&pbuf[13], gas_rsp->Rsp, gas_rsp->Rsplen);
		
		txinsn.fr_len += 13 +	gas_rsp->Rsplen;
	}
	else if (gas_rsp->Action == _GAS_COMBACK_RSP_ACTION_ID_)
	{
		pbuf[5] = gas_rsp->Rsp_fragment_id;
		pbuf[6] = gas_rsp->Comeback_delay & 0x00ff;
		pbuf[7] = (gas_rsp->Comeback_delay & 0xff00) >> 8;
		//advertisement protocol element
		pbuf[8] = 0x6c;
		pbuf[9] = 2;
		pbuf[10] = 0x20;
		pbuf[11] = 0;//gas_rsp->Advt_proto;
		//gas rsp
		pbuf[12] = gas_rsp->Rsplen & 0x00ff;
		pbuf[13] = (gas_rsp->Rsplen & 0xff00) >> 8;
		if (gas_rsp->Rsplen > 0)
			memcpy(&pbuf[14], gas_rsp->Rsp, gas_rsp->Rsplen);
	
		txinsn.fr_len += 14 +	gas_rsp->Rsplen;	
	}	
	else
	{
		//unknown action
		goto issue_GASrsp_fail;	
	}
	
	SetFrameSubType((txinsn.phdr), WIFI_WMM_ACTION);

	memcpy((void *)GetAddr1Ptr((txinsn.phdr)), gas_rsp->MACAddr, MACADDRLEN);
	memcpy((void *)GetAddr2Ptr((txinsn.phdr)), GET_MY_HWADDR, MACADDRLEN);
	
	pstat = get_stainfo(priv, gas_rsp->MACAddr);
#ifdef CONFIG_MBO
	// According to the MBO Spec, address 3 field set to the wildcard BSSID value
	if (pstat) {
		memcpy((void *)GetAddr3Ptr((txinsn.phdr)), BSSID, MACADDRLEN);
	}
	else {
		memset((void *)GetAddr3Ptr((txinsn.phdr)), 0xff, MACADDRLEN);
	}
#else
	memcpy((void *)GetAddr3Ptr((txinsn.phdr)), BSSID, MACADDRLEN);
#endif
	
#if defined(WIFI_WMM)
	ret = check_dz_mgmt(priv, pstat, &txinsn);
	
	if (ret < 0)
		goto issue_GASrsp_fail;
	else if (ret==1)
		return SUCCESS;
	else
#endif
	{
		if ((rtl8192cd_firetx(priv, &txinsn)) == SUCCESS)
			return SUCCESS;	
	}
	
issue_GASrsp_fail:
	HS2_DEBUG_INFO("issue_GASrsp_fail\n");
	if (txinsn.phdr)
		release_wlanhdr_to_poll(priv, txinsn.phdr);
	if (txinsn.pframe)
		release_mgtbuf_to_poll(priv, txinsn.pframe);
		
	return FAIL;	
}

int issue_BSS_TSM_req(struct rtl8192cd_priv *priv, DOT11_HS2_TSM_REQ *tsm_req)
{
	unsigned char	*pbuf;
	struct stat_info *pstat;
	unsigned int curLen;
#if defined(WIFI_WMM)
	int ret;
#endif	

	DECLARE_TXINSN(txinsn);
    HS2DEBUG("\n");

	txinsn.q_num = MANAGE_QUE_NUM;
	txinsn.fr_type = _PRE_ALLOCMEM_;
	txinsn.tx_rate = find_rate(priv, NULL, 0, 1);
#ifndef TX_LOWESTRATE	
	txinsn.lowest_tx_rate = txinsn.tx_rate;
#endif
	txinsn.fixed_rate = 1;
#ifdef CONFIG_IEEE80211W	
	struct stat_info *psta; 
	if(!memcmp(tsm_req->MACAddr,"\xff\xff\xff\xff\xff\xff",6)) {
		txinsn.isPMF = 1; //?????
	} else {
		psta = get_stainfo(priv,tsm_req->MACAddr);
		if(!psta) {
			printk("STA does not exist\n");
			return 0;
		}
		if(psta)
			txinsn.isPMF = psta->isPMF;
		else
			txinsn.isPMF = 0;
	}	
		//printk("deauth:txinsn.isPMF=%d\n",txinsn.isPMF);
#endif
	
	pbuf = txinsn.pframe = get_mgtbuf_from_poll(priv);
	if (pbuf == NULL)
		goto issue_BSS_TxMgmt_req_fail;

	txinsn.phdr = get_wlanhdr_from_poll(priv);
	if (txinsn.phdr == NULL)
		goto issue_BSS_TxMgmt_req_fail;

	memset((void *)(txinsn.phdr), 0, sizeof(struct wlan_hdr));

	pbuf[0] = _WNM_CATEGORY_ID_;
	pbuf[1] = _BSS_TSMREQ_ACTION_ID_;
	pbuf[2] = tsm_req->Dialog_token;			//token
	pbuf[3] = tsm_req->Req_mode;				//request mode
	pbuf[4] = tsm_req->Disassoc_timer & 0xff;	//disassociation timer
	pbuf[5] = (tsm_req->Disassoc_timer & 0xff00) >> 8;
	pbuf[6] = tsm_req->Validity_intval;			//validity interval
	curLen = 7;
	if (tsm_req->term_len != 0) { // BSS Termination Duration field
		memcpy(&pbuf[curLen], tsm_req->terminal_dur, 12); 
		curLen += tsm_req->term_len;
	}
	if (tsm_req->url_len != 0) { //Session Information URL field
		pbuf[curLen++] = tsm_req->url_len;
		memcpy(&pbuf[curLen], tsm_req->Session_url, tsm_req->url_len);
		curLen += tsm_req->url_len;
	}
	if (tsm_req->list_len != 0) {
		memcpy(&pbuf[curLen], tsm_req->Candidate_list, tsm_req->list_len);
		curLen += tsm_req->list_len;
	}

	txinsn.fr_len += 7+tsm_req->term_len+1+tsm_req->url_len+tsm_req->list_len;
	
	SetFrameSubType((txinsn.phdr), WIFI_WMM_ACTION);
	
#ifdef CONFIG_IEEE80211W	
	if (txinsn.isPMF)
		*(unsigned char*)(txinsn.phdr+1) |= BIT(6); // enable privacy 
#endif
	memcpy((void *)GetAddr1Ptr((txinsn.phdr)), tsm_req->MACAddr, MACADDRLEN);
	memcpy((void *)GetAddr2Ptr((txinsn.phdr)), GET_MY_HWADDR, MACADDRLEN);
	memcpy((void *)GetAddr3Ptr((txinsn.phdr)), BSSID, MACADDRLEN);
	
	pstat = get_stainfo(priv, tsm_req->MACAddr);
	
#if defined(WIFI_WMM)
	ret = check_dz_mgmt(priv, pstat, &txinsn);
	
	if (ret < 0)
		goto issue_BSS_TxMgmt_req_fail;
	else if (ret==1)
		return SUCCESS;
	else
#endif
	{
		if ((rtl8192cd_firetx(priv, &txinsn)) == SUCCESS)
			return SUCCESS;	
	}
	
issue_BSS_TxMgmt_req_fail:

	if (txinsn.phdr)
		release_wlanhdr_to_poll(priv, txinsn.phdr);
	if (txinsn.pframe)
		release_mgtbuf_to_poll(priv, txinsn.pframe);
		
	return FAIL;	
}

int issue_DLS_rsp(struct rtl8192cd_priv *priv, unsigned short status, unsigned char *da, unsigned char *dest, unsigned char *src)
{
	unsigned char   *pbuf;
    struct stat_info *pstat;
#if defined(WIFI_WMM)
    int ret;
#endif

    DECLARE_TXINSN(txinsn);

    txinsn.q_num = MANAGE_QUE_NUM;
    txinsn.fr_type = _PRE_ALLOCMEM_;
    txinsn.tx_rate = find_rate(priv, NULL, 0, 1);
#ifndef TX_LOWESTRATE
    txinsn.lowest_tx_rate = txinsn.tx_rate;
#endif	
    txinsn.fixed_rate = 1;

    pbuf = txinsn.pframe = get_mgtbuf_from_poll(priv);
	if (pbuf == NULL)
        goto issue_DLS_rsp_fail;

	txinsn.phdr = get_wlanhdr_from_poll(priv);
    if (txinsn.phdr == NULL)
        goto issue_DLS_rsp_fail;

    memset((void *)(txinsn.phdr), 0, sizeof(struct wlan_hdr));

	pbuf[0] = _DLS_CATEGORY_ID_;
    pbuf[1] = _DLS_RSP_ACTION_ID_;
    pbuf[2] = status & 0xff;
    pbuf[3] = (status >> 8) & 0xff;           //status code
	memcpy(&pbuf[4], dest, 6);
	memcpy(&pbuf[10], src, 6);

	txinsn.fr_len += 16;

	pstat = get_stainfo(priv, da);

	SetFrameSubType((txinsn.phdr), WIFI_WMM_ACTION);

	memcpy((void *)GetAddr1Ptr((txinsn.phdr)), da, MACADDRLEN);
    memcpy((void *)GetAddr2Ptr((txinsn.phdr)), GET_MY_HWADDR, MACADDRLEN);
    memcpy((void *)GetAddr3Ptr((txinsn.phdr)), BSSID, MACADDRLEN);

#if defined(WIFI_WMM)
    ret = check_dz_mgmt(priv, pstat, &txinsn);

    if (ret < 0)
        goto issue_DLS_rsp_fail;
    else if (ret==1)
        return SUCCESS;
    else
#endif
    {
        if ((rtl8192cd_firetx(priv, &txinsn)) == SUCCESS)
            return SUCCESS;
    }
    
issue_DLS_rsp_fail:
    if (txinsn.phdr)
        release_wlanhdr_to_poll(priv, txinsn.phdr);
    if (txinsn.pframe)
        release_mgtbuf_to_poll(priv, txinsn.pframe);

    return FAIL;
}

#ifdef HS2_CLIENT_TEST
//issue_TSM Query for client test used
int issue_BSS_TSM_query(struct rtl8192cd_priv *priv, unsigned char *list, unsigned char list_len)
{
	unsigned char	*pbuf;
	struct stat_info *pstat;
#if defined(WIFI_WMM)
	int ret;
#endif	
	unsigned char tmpda[]={0x00,0x33,0x44,0x055,0x66,0x77};
	
	DECLARE_TXINSN(txinsn);

	txinsn.q_num = MANAGE_QUE_NUM;
	txinsn.fr_type = _PRE_ALLOCMEM_;
	txinsn.tx_rate = find_rate(priv, NULL, 0, 1);
#ifndef TX_LOWESTRATE	
	txinsn.lowest_tx_rate = txinsn.tx_rate;
#endif	
	txinsn.fixed_rate = 1;
	
	pbuf = txinsn.pframe = get_mgtbuf_from_poll(priv);
	if (pbuf == NULL)
		goto issue_BSS_TxMgmt_query_fail;

	txinsn.phdr = get_wlanhdr_from_poll(priv);
	if (txinsn.phdr == NULL)
		goto issue_BSS_TxMgmt_query_fail;

	memset((void *)(txinsn.phdr), 0, sizeof(struct wlan_hdr));

	pbuf[0] = _WNM_CATEGORY_ID_;
	pbuf[1] = _WNM_TSMQUERY_ACTION_ID_;
	pbuf[2] = 20;			//token
	pbuf[3] = 18;				//request mode

	if (list_len >0 )
		memcpy(&pbuf[4], list, list_len);
	txinsn.fr_len += 4 + list_len;
	
	SetFrameSubType((txinsn.phdr), WIFI_WMM_ACTION);

	memcpy((void *)GetAddr1Ptr((txinsn.phdr)), BSSID, MACADDRLEN);
	memcpy((void *)GetAddr2Ptr((txinsn.phdr)), GET_MY_HWADDR, MACADDRLEN);
	memcpy((void *)GetAddr3Ptr((txinsn.phdr)), BSSID, MACADDRLEN);
	
	pstat = get_stainfo(priv, BSSID);
	
#if defined(WIFI_WMM)
	ret = check_dz_mgmt(priv, pstat, &txinsn);
	
	if (ret < 0)
		goto issue_BSS_TxMgmt_query_fail;
	else if (ret==1)
		return SUCCESS;
	else
#endif
	{
		if ((rtl8192cd_firetx(priv, &txinsn)) == SUCCESS)
			return SUCCESS;	
	}
	
issue_BSS_TxMgmt_query_fail:

	if (txinsn.phdr)
		release_wlanhdr_to_poll(priv, txinsn.phdr);
	if (txinsn.pframe)
		release_mgtbuf_to_poll(priv, txinsn.pframe);
		
	return FAIL;	
}

//issue_TSM response for client test used
int issue_BSS_TSM_rsp(struct rtl8192cd_priv *priv, unsigned char *token, unsigned char *list, unsigned char list_len)
{
	unsigned char	*pbuf;
	struct stat_info *pstat;
#if defined(WIFI_WMM)
	int ret;
#endif	
	unsigned char tmpda[]={0x00,0x33,0x44,0x055,0x66,0x77};
	
	DECLARE_TXINSN(txinsn);

	txinsn.q_num = MANAGE_QUE_NUM;
	txinsn.fr_type = _PRE_ALLOCMEM_;
	txinsn.tx_rate = find_rate(priv, NULL, 0, 1);
#ifndef TX_LOWESTRATE
	txinsn.lowest_tx_rate = txinsn.tx_rate;
#endif	
	txinsn.fixed_rate = 1;
	
	pbuf = txinsn.pframe = get_mgtbuf_from_poll(priv);
	if (pbuf == NULL)
		goto issue_BSS_TxMgmt_rsp_fail;

	txinsn.phdr = get_wlanhdr_from_poll(priv);
	if (txinsn.phdr == NULL)
		goto issue_BSS_TxMgmt_rsp_fail;

	memset((void *)(txinsn.phdr), 0, sizeof(struct wlan_hdr));

	pbuf[0] = _WNM_CATEGORY_ID_;
	pbuf[1] = _BSS_TSMRSP_ACTION_ID_;
	pbuf[2] = *token;			//token
	pbuf[3] = 0;				//request mode
	pbuf[4] = 0;

	if (list_len != 0)
		memcpy(&pbuf[5], list, list_len);
		
	txinsn.fr_len += 5+list_len;
	
	SetFrameSubType((txinsn.phdr), WIFI_WMM_ACTION);

	memcpy((void *)GetAddr1Ptr((txinsn.phdr)), BSSID, MACADDRLEN);
	memcpy((void *)GetAddr2Ptr((txinsn.phdr)), GET_MY_HWADDR, MACADDRLEN);
	memcpy((void *)GetAddr3Ptr((txinsn.phdr)), BSSID, MACADDRLEN);
	
	pstat = get_stainfo(priv, BSSID);
	
#if defined(WIFI_WMM)
	ret = check_dz_mgmt(priv, pstat, &txinsn);
	
	if (ret < 0)
		goto issue_BSS_TxMgmt_rsp_fail;
	else if (ret==1)
		return SUCCESS;
	else
#endif
	{
		if ((rtl8192cd_firetx(priv, &txinsn)) == SUCCESS)
			return SUCCESS;	
	}
	
issue_BSS_TxMgmt_rsp_fail:

	if (txinsn.phdr)
		release_wlanhdr_to_poll(priv, txinsn.phdr);
	if (txinsn.pframe)
		release_mgtbuf_to_poll(priv, txinsn.pframe);
		
	return FAIL;	
}
#endif
#endif

#if defined(WIFI_WMM)
#ifdef RTK_AC_SUPPORT //for 11ac logo

void issue_op_mode_notify(struct rtl8192cd_priv *priv, struct stat_info *pstat, char mode)
{
	unsigned char	*pbuf;
	DECLARE_TXINSN(txinsn);

	txinsn.q_num = MANAGE_QUE_NUM;
	txinsn.fr_type = _PRE_ALLOCMEM_;
#ifdef P2P_SUPPORT	/*cfg p2p cfg p2p*/
	if(rtk_p2p_is_enabled(priv)){
      	txinsn.tx_rate = _6M_RATE_;
	}else
#endif    
    	txinsn.tx_rate = find_rate(priv, NULL, 0, 1);
#ifndef TX_LOWESTRATE
	txinsn.lowest_tx_rate = txinsn.tx_rate;
#endif	
	txinsn.fixed_rate = 1;

	pbuf = txinsn.pframe = get_mgtbuf_from_poll(priv);
	if (pbuf == NULL)
		goto issue_opm_notification_fail;

	txinsn.phdr = get_wlanhdr_from_poll(priv);
	if (txinsn.phdr == NULL)
		goto issue_opm_notification_fail;

	memset((void *)(txinsn.phdr), 0, sizeof(struct wlan_hdr));

	pbuf[0] = _VHT_ACTION_CATEGORY_ID_;
	pbuf[1] = _VHT_ACTION_OPMNOTIF_ID_;
	pbuf[2] = mode;
	txinsn.fr_len = _OPMNOTIF_Frame_Length_;

	SetFrameSubType((txinsn.phdr), WIFI_WMM_ACTION);
	memcpy((void *)GetAddr1Ptr((txinsn.phdr)), pstat->cmn_info.mac_addr, MACADDRLEN);
	memcpy((void *)GetAddr2Ptr((txinsn.phdr)), GET_MY_HWADDR, MACADDRLEN);
	memcpy((void *)GetAddr3Ptr((txinsn.phdr)), BSSID, MACADDRLEN);


	if ((rtl8192cd_firetx(priv, &txinsn)) == SUCCESS) {
		return;
	}

issue_opm_notification_fail:

	if (txinsn.phdr)
		release_wlanhdr_to_poll(priv, txinsn.phdr);
	if (txinsn.pframe)
		release_mgtbuf_to_poll(priv, txinsn.pframe);
	return;
}

#endif

/*-------------------------------------------------------------------------------
	Check if packet should be queued
return value:
-1: fail
1: success
0: no queue
--------------------------------------------------------------------------------*/
#if defined(CONFIG_PCI_HCI)
int check_dz_mgmt_pci(struct rtl8192cd_priv *priv, struct stat_info *pstat, struct tx_insn* txcfg)
{
	if (pstat && ((pstat->state & (WIFI_SLEEP_STATE | WIFI_ASOC_STATE)) ==
			(WIFI_SLEEP_STATE | WIFI_ASOC_STATE))){
		int ret;
		struct tx_insn *ptx_insn;
		ptx_insn = (struct tx_insn*)kmalloc(sizeof(struct tx_insn), GFP_ATOMIC);

		if (ptx_insn == NULL){
			printk("%s: not enough memory\n", __FUNCTION__);
			return -1;
		}
		memcpy((void *)ptx_insn, (void *)txcfg, sizeof(struct tx_insn));
		
		//printk("%s %d\n",__FUNCTION__,__LINE__);
		DEBUG_INFO("h= %d t=%d\n", (pstat->MGT_dz_queue->head), (pstat->MGT_dz_queue->tail));
		ret = enque(priv, 
#if defined(AP_SWPS_OFFLOAD)
                    NULL,
#endif
                    &(pstat->MGT_dz_queue->head), &(pstat->MGT_dz_queue->tail),
					(unsigned long)(pstat->MGT_dz_queue->ptx_insn), NUM_DZ_MGT_QUEUE, (void *)ptx_insn);
		
		if (ret == FALSE) {
			kfree(ptx_insn);
			DEBUG_ERR("MGT_dz_queue full!\n");
			return -1;
		}
		
		return 1; // success
	}else{
		return 0; // no queue
	}
}
#endif /* defined(CONFIG_PCI_HCI) */

#if defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI)
static int _check_dz_mgmt(struct rtl8192cd_priv *priv, struct stat_info *pstat, struct tx_insn* txcfg)
{
	if (pstat && ((pstat->state & (WIFI_SLEEP_STATE | WIFI_ASOC_STATE)) ==
			(WIFI_SLEEP_STATE | WIFI_ASOC_STATE)))
	{
		if (update_txinsn_stage1(priv, txcfg) == FALSE)
			return -1;
		
		txcfg->next_txpath = TXPATH_FIRETX;
		if (rtw_xmit_enqueue(priv, txcfg) == FALSE) {
			return -1;
		}
		
		return 1; // success
	}
	
	return 0; // no queue
}

int check_dz_mgmt_usb_sdio(struct rtl8192cd_priv *priv, struct stat_info *pstat, struct tx_insn* txcfg)
{
	int res;

	local_bh_disable();
	res = _check_dz_mgmt(priv, pstat, txcfg);
	local_bh_enable();
	
	return res;
}
#endif /* defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI) */
#endif /* WIFI_WMM */



#ifdef BEACON_VS_IE
unsigned char set_beacon_vsie(struct rtl8192cd_priv * priv, unsigned char * data, unsigned int len)
{
	unsigned char ret;
	int i;
	unsigned char	service_name_len;
	unsigned char	service_name[64];
	unsigned int	duration;
	unsigned char	data_len;
	unsigned char	ie_data[BEACON_VSIE_LEN];
	unsigned char	oui[3];
	unsigned int 	left_len = len;

	DEBUG_INFO("[BEACON_VS_IE] set_bcn_vsie\n");

	memcpy(oui, data, 3);
	data += 3;
	left_len -= 3;

	service_name_len = data[0];
	data++;
	left_len--;
	DEBUG_INFO("service_name_len = %d\n",service_name_len);

	if(left_len < (unsigned int)service_name_len || service_name_len > 64)
	{
		ret = 1;
		DEBUG_INFO("service_name_len error: left_len: %d, service_name_len: %d\n",left_len, service_name_len);
		goto exit_bcn_vsie;
	}
	memcpy(service_name, data, service_name_len);
	data += service_name_len;
	left_len -= service_name_len;

	memcpy(&duration, data, sizeof(unsigned int));
	data += sizeof(unsigned int);
	left_len -= sizeof(unsigned int);

	if(duration > 300)
		duration = 300;
	DEBUG_INFO("duration = %u\n",duration);
	data_len = data[0];
	data++;
	left_len--;

	DEBUG_INFO("data_len = %d\n",data_len);
	if(left_len < (unsigned int)data_len || data_len > BEACON_VSIE_LEN)
	{
		ret = 1;
		DEBUG_INFO("data_len error: left_len: %d, data_len: %d\n",left_len,data_len);
		goto exit_bcn_vsie;
	}
	memcpy(ie_data, data, data_len);


	for(i = 0; i < NUM_BCNVSIE_SERVICE; i++)
	{
		if(priv->bcn_vsie[i].service_name_len == service_name_len &&
		   (memcmp(service_name, priv->bcn_vsie[i].service_name, service_name_len) == 0 ) &&
		    (memcmp(oui,priv->bcn_vsie[i].oui,3) == 0)){
		    DEBUG_INFO("[Exist] Beacon VS IE idx: %d\n", i);
		    memcpy(priv->bcn_vsie[i].data, ie_data, data_len);
		    priv->bcn_vsie[i].id = _VENDOR_SPECIFIC_IE_;
		    priv->bcn_vsie[i].duration = duration;
		    priv->bcn_vsie[i].duration_count = 0;
			priv->bcn_vsie[i].data_len = data_len;

			ret = 0;
			break;
		}
	}
	if(i == NUM_BCNVSIE_SERVICE)
	{
		for(i = 0; i < NUM_BCNVSIE_SERVICE; i++)
		{
			if(priv->bcn_vsie[i].service_name_len == 0){
				DEBUG_INFO("[Insert] Beacon VS IE idx: %d\n", i);
				memcpy(priv->bcn_vsie[i].data, ie_data, data_len);
				priv->bcn_vsie[i].id = _VENDOR_SPECIFIC_IE_;
				memcpy(priv->bcn_vsie[i].oui,oui,3);
				priv->bcn_vsie[i].service_name_len = service_name_len;
				memcpy(priv->bcn_vsie[i].service_name, service_name, service_name_len);
				priv->bcn_vsie[i].duration = duration;
				priv->bcn_vsie[i].duration_count = 0;
				priv->bcn_vsie[i].data_len = data_len;

				ret = 0;
				break;
			}
		}
	}

	if(i == NUM_BCNVSIE_SERVICE) //
	{
		ret = 2;
		goto exit_bcn_vsie;
	}
exit_bcn_vsie:
	return ret;
}

unsigned char set_probe_vsie(struct rtl8192cd_priv * priv, unsigned char * data, unsigned int len)
{
	unsigned char ret;
	int i;
	unsigned char	type; //1: add, 0: delete
	unsigned char	oui[3];
	unsigned char	service_name_len;
	unsigned char	service_name[64];

	if(len < 6)
	{
		DEBUG_INFO("Length too short: %d, at least 6\n", len);
		ret = 1;
		goto exit_prb_vsie;
	}
	type = data[0];
	memcpy(oui, data+1, 3);
	service_name_len = data[4];
	if(len < 5 + service_name_len)
	{
		DEBUG_INFO("Length too short: %d, at least %d\n", len, 5 + service_name_len);
		ret = 1;
		goto exit_prb_vsie;
	}
	memcpy(service_name, data + 5, service_name_len);

	if(type == 1)
	{
		for(i = 0; i < NUM_PRBVSIE_SERVICE; i++)
		{
			if(priv->prb_vsie[i].service_name_len == service_name_len &&
			   (memcmp(service_name, priv->prb_vsie[i].service_name, service_name_len) == 0 ) &&
			    (memcmp(oui,priv->prb_vsie[i].oui,3) == 0)){
			    DEBUG_INFO("[BEACON_VS_IE] ADD:Probe VS IE idx: %d, OUI %02X-%02X-%02X\n", i, oui[0],oui[1],oui[2]);
				ret = 0;
				break;
			}
		}
		if(i == NUM_PRBVSIE_SERVICE)
		{
			for(i = 0; i < NUM_PRBVSIE_SERVICE; i++)
			{
				if(priv->prb_vsie[i].service_name_len == 0){
					DEBUG_INFO("[BEACON_VS_IE] EXIST:Probe VS IE idx: %d, OUI %02X-%02X-%02X\n", i, oui[0],oui[1],oui[2]);
					memcpy(priv->prb_vsie[i].oui,oui,3);
					memcpy(priv->prb_vsie[i].service_name, service_name, service_name_len);
					priv->prb_vsie[i].service_name_len = service_name_len;
					ret = 0;
					break;
				}
			}
		}
		if(i == NUM_PRBVSIE_SERVICE) // Probe VSIE table full
		{
			ret = 2;
		}
	}
	else if(type == 0)
	{
		ret = 0;
		for(i = 0; i < NUM_PRBVSIE_SERVICE; i++)
		{
			if(priv->prb_vsie[i].service_name_len == service_name_len &&
			   (memcmp(service_name, priv->prb_vsie[i].service_name, service_name_len) == 0 ) &&
			    (memcmp(oui,priv->prb_vsie[i].oui,3) == 0)){
			    DEBUG_INFO("[BEACON_VS_IE] DEL:Probe VS IE idx: %d, OUI %02X-%02X-%02X\n", i, oui[0],oui[1],oui[2]);
			    memset(priv->prb_vsie[i].oui,'\0',3);
				priv->prb_vsie[i].service_name_len = 0;
				memset(priv->prb_vsie[i].service_name, '\0', 64);
			}
		}
	}
	else
	{
		ret = 1;
	}

exit_prb_vsie:
	return ret;
}
unsigned char set_probersp_vsie(struct rtl8192cd_priv * priv, unsigned char * data, unsigned int len)
{
	unsigned char ret;
	int i;
	unsigned char	type; //1: add, 0: delete
	unsigned char	mac[MACADDRLEN];
	unsigned char	iedata_len;
	unsigned char	ie_data[BEACON_VSIE_LEN];

	if(len < 6)
	{
		DEBUG_INFO("Length too short: %d, at least 6\n", len);
		ret = 1;
		goto exit_prbrsp_vsie;
	}
	
	type = data[0];
	memcpy(mac, data+1, MACADDRLEN);
	iedata_len = data[1+MACADDRLEN];
	
	if(len < 1 + MACADDRLEN + 1 + iedata_len)
	{
		DEBUG_INFO("Length too short: %d, at least %d\n", len, 1 + MACADDRLEN + 1 + iedata_len);
		ret = 1;
		goto exit_prbrsp_vsie;
	}
	memcpy(ie_data, data + 1 + MACADDRLEN + 1, iedata_len);

	if(type == 1)
	{
		priv->probersp_vsie_idx = 0;
		for(i = 0; i < NUM_PRBVSIE_SERVICE; i++)
		{
			if(priv->prbrsp_vsie[i].service == 1 && priv->prbrsp_vsie[i].data_len && (memcmp(mac, priv->prbrsp_vsie[i].mac, MACADDRLEN) == 0 )){
			    DEBUG_INFO("[Exist] PROBERSP VS IE idx: %d\n", i);
			    memcpy(priv->prbrsp_vsie[i].data, ie_data, iedata_len);
				priv->prbrsp_vsie[i].data_len = iedata_len;
				ret = 0;
				break;
			}

		}
		if(i == NUM_PRBVSIE_SERVICE)
		{
			for(i = 0; i < NUM_PRBVSIE_SERVICE; i++)
			{
				
				if(priv->prbrsp_vsie[i].service == 0 && priv->prbrsp_vsie[i].data_len == 0){
					DEBUG_INFO("[Insert] PROBERSP VS IE idx: %d\n", i);
					memcpy(priv->prbrsp_vsie[i].data, ie_data, iedata_len);
					priv->prbrsp_vsie[i].data_len = iedata_len;
					memcpy(priv->prbrsp_vsie[i].mac, mac, MACADDRLEN);
					priv->prbrsp_vsie[i].service = 1;
					ret = 0;
					break;
				}
			}
		}
		if(i == NUM_PRBVSIE_SERVICE) // Probe VSIE table full
		{
			ret = 2;
		}
	}
	else if(type == 0)
	{
		priv->probersp_vsie_idx = 0;
		ret = 0;
		for(i = 0; i < NUM_PRBVSIE_SERVICE; i++)
		{
			if(priv->prbrsp_vsie[i].service ==1 && priv->prbrsp_vsie[i].data_len && (memcmp(mac, priv->prbrsp_vsie[i].mac, MACADDRLEN) == 0 )){
				DEBUG_INFO("[BEACON_VS_IE] DEL:Probersp VS IE idx: %d", i);
				memset(priv->prbrsp_vsie[i].mac,'\0',MACADDRLEN);
				priv->prbrsp_vsie[i].data_len = 0;
				memset(priv->prbrsp_vsie[i].data, '\0', sizeof(priv->prbrsp_vsie[i].data));
				priv->prbrsp_vsie[i].service = 0;
			}
		}
	}
	else
	{
		ret = 1;
	}

exit_prbrsp_vsie:
	return ret;
}
#endif

#ifdef CONFIG_IEEE80211W

void stop_sa_query(struct stat_info *pstat)
{
	PMFDEBUG("RX 11W_SA_Rsp , stop send sa query again\n");
	if (rtk_timer_pending(&pstat->SA_timer))
		rtk_del_timer_sync(&pstat->SA_timer);
	pstat->sa_query_count = 0;
}


int check_sa_query_timeout(struct stat_info *pstat)
{
	if(time_after_eq(jiffies, pstat->sa_query_end)) {
		PMFDEBUG("sa query time out\n");
		pstat->sa_query_timed_out = 1;
		if (rtk_timer_pending(&pstat->SA_timer))
			rtk_del_timer_sync(&pstat->SA_timer);
		pstat->sa_query_count = 0;
		return 1;
	}

	return 0;
}

static __always_inline void rtl8192cd_sa_query_timer(unsigned long task_priv)
{
	struct stat_info        *pstat = (struct stat_info *)task_priv;
	struct rtl8192cd_priv *priv = NULL;
	struct aid_obj *aidobj;

	if(!pstat)
		return;

	aidobj = container_of(pstat, struct aid_obj, station);
	priv = aidobj->priv;

	
	if (!(priv->drv_state & DRV_STATE_OPEN))
		return;

    if(pstat->sa_query_count > 0 && check_sa_query_timeout(pstat)) {
		PMFDEBUG("check_sa_query_timeout\n");
        if (OPMODE & WIFI_AP_STATE){
            unsigned char *sa = pstat->cmn_info.mac_addr;            
            issue_disassoc(priv, sa, _RSON_AUTH_NO_LONGER_VALID_);
            pstat->isPMF = 0;
            DEBUG_INFO("[%s %d] issue_disassoc to peer:%pm\n", __FUNCTION__, __LINE__,sa);
        }
#ifdef CLIENT_MODE
        else if (OPMODE & WIFI_STATION_STATE){
            del_station(priv, pstat, DEL_STA_SEND_DISASSOC, _RSON_UNSPECIFIED_);
            DEBUG_INFO("[%s %d] issue_disassoc to peer[%pm]\n", __FUNCTION__, __LINE__, pstat->cmn_info.mac_addr);
        }
#endif
		return;
    }
	if(pstat->sa_query_count < SA_QUERY_MAX_NUM) {
		PMFDEBUG("re Send sa query\n");
		pstat->sa_query_count++;
		issue_SA_Query_Req(priv->dev,pstat->cmn_info.mac_addr);
	}
	rtk_mod_timer(&pstat->SA_timer, jiffies + RTL_MILISECONDS_TO_JIFFIES(SA_QUERY_RETRY_TO));
}
DEFINE_TIMER_CALLBACK(rtl8192cd_sa_query_timer);

void init_sta_SA_query_timer(struct stat_info *pstat)
{
	rtk_timer_setup(&(pstat->SA_timer), rtl8192cd_sa_query_timer, (unsigned long)pstat, 0);
}

int issue_SA_Query_Req(struct net_device *dev, unsigned char *da)
{
	struct rtl8192cd_priv *priv = GET_DEV_PRIV(dev);


	struct stat_info *pstat;
	unsigned char	*pbuf;
	int ret;
	DECLARE_TXINSN(txinsn);

	txinsn.q_num = MANAGE_QUE_NUM;
	txinsn.fr_type = _PRE_ALLOCMEM_;
	txinsn.tx_rate = find_rate(priv, NULL, 0, 1);
	
	txinsn.fixed_rate = 1;
	
	pstat = get_stainfo(priv, da);

	if (pstat == NULL)
		goto issue_SA_Query_Req_fail;

		txinsn.isPMF = pstat->isPMF;

	pbuf = txinsn.pframe = get_mgtbuf_from_poll(priv);
	if (pbuf == NULL)
		goto issue_SA_Query_Req_fail;

	txinsn.phdr = get_wlanhdr_from_poll(priv);
	if (txinsn.phdr == NULL)
		goto issue_SA_Query_Req_fail;

	memset((void *)(txinsn.phdr), 0, sizeof(struct wlan_hdr));

	pbuf[0] = _SA_QUERY_CATEGORY_ID_;
	pbuf[1] = _SA_QUERY_REQ_ACTION_ID_;

	get_random_bytes(&pstat->SA_TID[pstat->sa_query_count], sizeof(unsigned short));	
	
	pbuf[2] = pstat->SA_TID[pstat->sa_query_count] & 0xff;
	pbuf[3] = (pstat->SA_TID[pstat->sa_query_count] & 0xff00) >> 8;
#ifdef CONFIG_IEEE80211W_AP_DEBUG
	log("DA[%pm] STA_TID=[%02x%02x]\n",da,pbuf[2], pbuf[3]);
#endif
	txinsn.fr_len = 4;
	
	SetFrameSubType((txinsn.phdr), WIFI_WMM_ACTION);
	
	if (txinsn.isPMF)
		*(unsigned char*)(txinsn.phdr+1) |= BIT(6); // enable privacy 	
		
	memcpy((void *)GetAddr1Ptr((txinsn.phdr)), da, MACADDRLEN);
	memcpy((void *)GetAddr2Ptr((txinsn.phdr)), GET_MY_HWADDR, MACADDRLEN);
	memcpy((void *)GetAddr3Ptr((txinsn.phdr)), BSSID, MACADDRLEN);
	
	txinsn.pstat = pstat;
	
#if defined(WIFI_WMM)
	ret = check_dz_mgmt(priv, pstat, &txinsn);

	if (ret < 0){
		PMFDEBUG("issue_SA_Query_Req_fail\n");
		goto issue_SA_Query_Req_fail;
	}else if (ret==1) {
		PMFDEBUG("sta go to sleep... Q it\n");        
		return SUCCESS;
	}
	else
#endif
	{
		if ((rtl8192cd_firetx(priv, &txinsn)) == SUCCESS) {

    		PMFDEBUG("SUCCESS!!\n");            
			return SUCCESS;	
		}
	}
	
issue_SA_Query_Req_fail:

    PMFDEBUG("issue_SA_Query_Req_fail\n");

	if (txinsn.phdr)
		release_wlanhdr_to_poll(priv, txinsn.phdr);
	if (txinsn.pframe)
		release_mgtbuf_to_poll(priv, txinsn.pframe);
		
	return FAIL;
}


int issue_SA_Query_Rsp(struct net_device *dev, unsigned char *da, unsigned char *trans_id)
{
	struct rtl8192cd_priv *priv = GET_DEV_PRIV(dev);

	struct stat_info *pstat;
	unsigned char	*pbuf;
	int ret;
	DECLARE_TXINSN(txinsn);

	txinsn.q_num = MANAGE_QUE_NUM;
	txinsn.fr_type = _PRE_ALLOCMEM_;
	txinsn.tx_rate = find_rate(priv, NULL, 0, 1);
	
	txinsn.fixed_rate = 1;
	
	pstat = get_stainfo(priv, da);

	if (pstat == NULL)
		goto issue_SA_Query_Rsp_fail;

		txinsn.isPMF = pstat->isPMF;

	pbuf = txinsn.pframe = get_mgtbuf_from_poll(priv);
	if (pbuf == NULL)
		goto issue_SA_Query_Rsp_fail;

	txinsn.phdr = get_wlanhdr_from_poll(priv);
	if (txinsn.phdr == NULL)
		goto issue_SA_Query_Rsp_fail;

	memset((void *)(txinsn.phdr), 0, sizeof(struct wlan_hdr));

	pbuf[0] = _SA_QUERY_CATEGORY_ID_;
	pbuf[1] = _SA_QUERY_RSP_ACTION_ID_;
	memcpy(pbuf+2,trans_id, 2);
#ifdef CONFIG_IEEE80211W_CLI_DEBUG
	panic_printk("TID= %02x%02x\n", pbuf[2], pbuf[3]); 
#endif

	txinsn.fr_len = 4;
	
	SetFrameSubType((txinsn.phdr), WIFI_WMM_ACTION);
	
	if (txinsn.isPMF)
		*(unsigned char*)(txinsn.phdr+1) |= BIT(6); // enable privacy 	

	PMFDEBUG("\n");	
	memcpy((void *)GetAddr1Ptr((txinsn.phdr)), da, MACADDRLEN);
	memcpy((void *)GetAddr2Ptr((txinsn.phdr)), GET_MY_HWADDR, MACADDRLEN);
	memcpy((void *)GetAddr3Ptr((txinsn.phdr)), BSSID, MACADDRLEN);
#ifdef CONFIG_IEEE80211W_AP_DEBUG
       panic_printk("DA[%02x%02x%02x:%02x%02x%02x]\n",da[0],da[1],da[2],da[3],da[4],da[5]);
#endif
	
	txinsn.pstat = pstat;
	
#if defined(WIFI_WMM)
	ret = check_dz_mgmt(priv, pstat, &txinsn);
	if (ret < 0)
		goto issue_SA_Query_Rsp_fail;
	else if (ret==1) {
		return SUCCESS;
	}
	else
#endif
	{
		if ((rtl8192cd_firetx(priv, &txinsn)) == SUCCESS)
			return SUCCESS;	
	}
	
issue_SA_Query_Rsp_fail:
	PMFDEBUG("issue_SA_Query_Rsp_fail\n");

	if (txinsn.phdr)
		release_wlanhdr_to_poll(priv, txinsn.phdr);
	if (txinsn.pframe)
		release_mgtbuf_to_poll(priv, txinsn.pframe);
		
	return FAIL;
}
#endif

bool is_veriwave_testing (struct rtl8192cd_priv *priv)
{
#ifdef CONFIG_SPECIAL_ENV_TEST
	if(!priv->pshare->rf_ft_var.veriwave_interference)
		return false;
    if(priv->pshare->veriwave_sta_num > 0){
		return true;
	}
	else if ((UINT64_DIFF(priv->pshare->rx_packets_total, priv->pshare->rx_packets_pre2) < 2)
			|| (UINT64_DIFF(priv->pshare->tx_packets_total, priv->pshare->tx_packets_pre2) < 2)
			|| (((priv->pshare->veriwave_sta_num) > 0) && (ODMPTR->false_alm_cnt.cnt_all < 100))
			){

            return true;
    }
#endif

    return false;
}

int issue_ADDBArsp(struct rtl8192cd_priv *priv, unsigned char *da, unsigned char dialog_token,
				unsigned char TID, unsigned short status_code, unsigned short timeout, unsigned char ht_iot_peer)
{
	unsigned char	*pbuf;
	unsigned short	ba_para = 0;
	struct stat_info *pstat;
	int max_size = _ADDBA_Maximum_Buffer_Size_;
#if defined(WIFI_WMM)
	int ret;
#endif

	DECLARE_TXINSN(txinsn);

	txinsn.q_num = MANAGE_QUE_NUM;
	txinsn.fr_type = _PRE_ALLOCMEM_;
#ifdef P2P_SUPPORT	/*cfg p2p cfg p2p*/
	if(rtk_p2p_is_enabled(priv)){
      	txinsn.tx_rate = _6M_RATE_;
	}else
#endif    
    	txinsn.tx_rate = find_rate(priv, NULL, 0, 1);
#ifndef TX_LOWESTRATE
	txinsn.lowest_tx_rate = txinsn.tx_rate;
#endif	
	txinsn.fixed_rate = 1;

	pbuf = txinsn.pframe = get_mgtbuf_from_poll(priv);
	if (pbuf == NULL)
		goto issue_ADDBArsp_fail;

	txinsn.phdr = get_wlanhdr_from_poll(priv);
	if (txinsn.phdr == NULL)
		goto issue_ADDBArsp_fail;

	memset((void *)(txinsn.phdr), 0, sizeof(struct wlan_hdr));

	pbuf[0] = _BLOCK_ACK_CATEGORY_ID_;
	pbuf[1] = _ADDBA_Rsp_ACTION_ID_;
	pbuf[2] = dialog_token;
	pbuf[3] = status_code & 0x00ff;
	pbuf[4] = (status_code & 0xff00) >> 8;

	pstat = get_stainfo(priv, da);

#ifdef CONFIG_IEEE80211W
	 if(pstat)
		 txinsn.isPMF = pstat->isPMF;
	 else
		 txinsn.isPMF = 0;
		 //printk("deauth:txinsn.isPMF=%d\n",txinsn.isPMF);
#endif
	if (pstat && should_restrict_Nrate(priv, pstat))
		max_size = 1;
	else {
		if (priv->pmib->dot11nConfigEntry.dot11nAMPDURevSz){
			max_size = priv->pmib->dot11nConfigEntry.dot11nAMPDURevSz;
		}
#ifdef CONFIG_RTL8196B_GW_8M
		else if (pstat->IOTPeer==HT_IOT_PEER_BROADCOM && max_size > (_ADDBA_Maximum_Buffer_Size_/2))
			max_size = _ADDBA_Maximum_Buffer_Size_ / 2;
#endif
#if defined(CONFIG_WLAN_HAL_8192EE) || defined(CONFIG_WLAN_HAL_8192FE)
		else if ((GET_CHIP_VER(priv)==VERSION_8192E) || (GET_CHIP_VER(priv)==VERSION_8192F)) {
			switch (ht_iot_peer)
			{
				case HT_IOT_PEER_BROADCOM:
				case HT_IOT_PEER_APPLE:
					max_size = 42;
					break;
				case HT_IOT_PEER_INTEL:
					max_size = 42; /* 36 */
					break;
				default:
					max_size = _ADDBA_Maximum_Buffer_Size_;
					break;
			}
		}
#endif
#if defined(CONFIG_WLAN_HAL_8822BE) || defined(CONFIG_WLAN_HAL_8812FE)
		else if ((GET_CHIP_VER(priv)==VERSION_8822B) || (GET_CHIP_VER(priv)== VERSION_8812F)) {
			switch (ht_iot_peer)
			{
				case HT_IOT_PEER_INTEL:
					max_size = 64;
					break;
				default:
					max_size = _ADDBA_Maximum_Buffer_Size_;
					break;
			}
		}
#endif
#ifdef CONFIG_WLAN_HAL_8814AE
		else if (GET_CHIP_VER(priv)== VERSION_8814A) {
			switch (ht_iot_peer) {
			case HT_IOT_PEER_BROADCOM:
				if (priv->pshare->is_40m_bw == CHANNEL_WIDTH_20)
					max_size = 32;
				else
					max_size = 48;
				break;
			default:
				if (pstat && pstat->tx_bw == CHANNEL_WIDTH_20)
					max_size = 32;
			}
		}
#endif
#if defined(CONFIG_WLAN_HAL_8197F) || defined(CONFIG_WLAN_HAL_8192EE)
		else if((GET_CHIP_VER(priv)== VERSION_8197F || GET_CHIP_VER(priv)==VERSION_8192E) && pstat && pstat->tx_bw == CHANNEL_WIDTH_20)
			max_size = 16;
#endif
#ifdef CONFIG_WLAN_HAL_8814BE
		else if (GET_CHIP_VER(priv)== VERSION_8814B) {
#ifdef CONFIG_SPECIAL_ENV_TEST
			if (ht_iot_peer == HT_IOT_PEER_VERIWAVE)
				max_size = _ADDBA_Maximum_Buffer_Size_;
			else
#endif
				max_size = 64;
		}
#endif
#ifdef MULTI_STA_REFINE
		else if (priv->pshare->total_assoc_num > 10) {
			if (max_size > (_ADDBA_Maximum_Buffer_Size_ >> 2))
				max_size = _ADDBA_Maximum_Buffer_Size_ >> 2;
		}
#endif
	}

	ba_para = (max_size<<6) | (TID<<2) | BIT(1);	// assign buffer size | assign TID | set Immediate Block Ack

	if ((GET_MIB(priv))->dot11nConfigEntry.dot11nAMSDUAMPDURx)
			ba_para |= BIT(0);

#ifdef RTK_AC_SUPPORT //for 11ac logo
	if((AC_SIGMA_MODE == AC_SIGMA_APUT) && (AMSDU_ENABLE >= 1))
	ba_para |= BIT(0);
#endif

	pbuf[5] = ba_para & 0x00ff;
	pbuf[6] = (ba_para & 0xff00) >> 8;
	pbuf[7] = timeout & 0x00ff;
	pbuf[8] = (timeout & 0xff00) >> 8;

	txinsn.fr_len += _ADDBA_Rsp_Frame_Length_;

	SetFrameSubType((txinsn.phdr), WIFI_WMM_ACTION);
#ifdef CONFIG_IEEE80211W
	if (txinsn.isPMF)
		*(unsigned char*)(txinsn.phdr+1) |= BIT(6); // enable privacy 
#endif	
	memcpy((void *)GetAddr1Ptr((txinsn.phdr)), da, MACADDRLEN);
	memcpy((void *)GetAddr2Ptr((txinsn.phdr)), GET_MY_HWADDR, MACADDRLEN);
	memcpy((void *)GetAddr3Ptr((txinsn.phdr)), BSSID, MACADDRLEN);

	DEBUG_INFO("ADDBA-rsp sent to AID %d, token %d TID %d size %d status %d\n",
		(pstat ? pstat->cmn_info.aid : 0), dialog_token, TID, max_size, status_code);
#if defined(WIFI_WMM)
	ret = check_dz_mgmt(priv, pstat, &txinsn);
	
	if (ret < 0)
		goto issue_ADDBArsp_fail;
	else if (ret==1)
		return SUCCESS;
	else
#endif
	if ((rtl8192cd_firetx(priv, &txinsn)) == SUCCESS)
		return SUCCESS;

issue_ADDBArsp_fail:

	if (txinsn.phdr)
		release_wlanhdr_to_poll(priv, txinsn.phdr);
	if (txinsn.pframe)
		release_mgtbuf_to_poll(priv, txinsn.pframe);
	return FAIL;
}
#endif


#ifdef RTK_WOW
void issue_rtk_wow(struct rtl8192cd_priv *priv, unsigned char *da)
{
	unsigned char	*pbuf;
	unsigned int i;
	DECLARE_TXINSN(txinsn);

	if (!(OPMODE & WIFI_AP_STATE)) {
		DEBUG_WARN("rtk_wake_up pkt should be sent in AP mode!!\n");
		return;
	}

	txinsn.retry = priv->pmib->dot11OperationEntry.dot11ShortRetryLimit;
	txinsn.q_num = MANAGE_QUE_NUM;
	txinsn.fr_type = _PRE_ALLOCMEM_;
#ifdef P2P_SUPPORT	/*cfg p2p cfg p2p*/
	if(rtk_p2p_is_enabled(priv)){
      	txinsn.tx_rate = _6M_RATE_;
	}else
#endif    
    	txinsn.tx_rate = find_rate(priv, NULL, 0, 1);
#ifndef TX_LOWESTRATE
	txinsn.lowest_tx_rate = txinsn.tx_rate;
#endif	
	
	txinsn.fixed_rate = 1;

	pbuf = txinsn.pframe = get_mgtbuf_from_poll(priv);
	if (pbuf == NULL)
		goto send_rtk_wake_up_fail;

	txinsn.phdr = get_wlanhdr_from_poll(priv);
	if (txinsn.phdr == NULL)
		goto send_rtk_wake_up_fail;

	memset((void *)(txinsn.phdr), 0, sizeof (struct	wlan_hdr));

	SetFrameSubType(txinsn.phdr, WIFI_DATA);
	SetFrDs(txinsn.phdr);
	memcpy((void *)GetAddr1Ptr((txinsn.phdr)), da, MACADDRLEN);
	memcpy((void *)GetAddr2Ptr((txinsn.phdr)), BSSID, MACADDRLEN);
	memcpy((void *)GetAddr3Ptr((txinsn.phdr)), GET_MY_HWADDR, MACADDRLEN);

	// sync stream
	memset((void *)pbuf, 0xff, MACADDRLEN);
	pbuf += MACADDRLEN;
	txinsn.fr_len += MACADDRLEN;

	for(i=0; i<16; i++) {
		memcpy((void *)pbuf, da, MACADDRLEN);
		pbuf += MACADDRLEN;
		txinsn.fr_len += MACADDRLEN;
	}

	if ((rtl8192cd_firetx(priv, &txinsn)) == SUCCESS) {
		DEBUG_INFO("RTK wake up pkt sent\n");
		return;
	}
	else {
		DEBUG_ERR("Fail to send RTK wake up pkt\n");
	}

send_rtk_wake_up_fail:

	if (txinsn.phdr)
		release_wlanhdr_to_poll(priv, txinsn.phdr);
	if (txinsn.pframe)
		release_mgtbuf_to_poll(priv, txinsn.pframe);
}
#endif


#ifdef CONFIG_RTL_92D_SUPPORT
int clnt_ss_check_band(struct rtl8192cd_priv *priv, unsigned int channel)
{
#ifdef CLIENT_MODE
	if (OPMODE & (WIFI_STATION_STATE|WIFI_ADHOC_STATE)) {
		if (priv->pmib->dot11RFEntry.macPhyMode==SINGLEMAC_SINGLEPHY) {
			if (channel > 14 && priv->pmib->dot11RFEntry.phyBandSelect == PHY_BAND_2G){
				//printk("change to 5G %d\n", channel);
				// stop BB
				phy_set_bb_reg(priv, REG_FPGA0_ANALOG_PARAMETER4, 0x00f00000, 0xf);
				priv->pmib->dot11RFEntry.phyBandSelect = PHY_BAND_5G;
				priv->pshare->iqk_5g_done = 0;
				//priv->pmib->dot11BssType.net_work_type = (WIRELESS_11A|WIRELESS_11N);
				UpdateBBRFVal8192DE(priv);
				phy_set_bb_reg(priv, REG_FPGA0_ANALOG_PARAMETER4, 0x00f00000, 0x0);
				return 1;
			}
			
			if (channel <= 14 && priv->pmib->dot11RFEntry.phyBandSelect == PHY_BAND_5G){
				//printk("change to 2G %d\n", channel);
				phy_set_bb_reg(priv, REG_FPGA0_ANALOG_PARAMETER4, 0x00f00000, 0xf);
				priv->pmib->dot11RFEntry.phyBandSelect = PHY_BAND_2G;
				priv->pshare->iqk_2g_done = 0;
				//priv->pmib->dot11BssType.net_work_type = (WIRELESS_11B|WIRELESS_11G|WIRELESS_11N);
				//phy_set_bb_reg(priv, REG_FPGA0_ANALOG_PARAMETER4, 0x00f00000, 0x0);
				UpdateBBRFVal8192DE(priv);
				phy_set_bb_reg(priv, REG_FPGA0_ANALOG_PARAMETER4, 0x00f00000, 0x0);
				return 1;
			}
		}
	}
#endif
	return 0;
}
#endif

#if defined(RTK_MULTI_AP) || defined(DOT11K)
static __inline__ uint32_t bkpnset_avail_chnl(struct rtl8192cd_priv *priv, unsigned int *ch_list, unsigned int ch_num)
{
	if ((ch_num == 0) || (ch_num > MAX_CHANNEL_NUM))
		return 1;

	// Backup available channel
	priv->bkp_avail_chnl_num = priv->available_chnl_num;
	memcpy(priv->bkp_avail_chnl, priv->available_chnl, priv->available_chnl_num * sizeof(unsigned int));

	// Set channel to be scanned
	priv->available_chnl_num = ch_num;
	memcpy(priv->available_chnl, ch_list, ch_num * sizeof(unsigned int));

	return 0;
}

static __inline__ void restore_avail_chnl(struct rtl8192cd_priv *priv)
{
	// Restore backup available channel
	memcpy(priv->available_chnl, priv->bkp_avail_chnl, priv->bkp_avail_chnl_num * sizeof(unsigned int));
	priv->available_chnl_num = priv->bkp_avail_chnl_num;
	priv->bkp_avail_chnl_num = 0;
}
#endif // defined(RTK_MULTI_AP) || defined(DOT11K)

/**
 *	@brief	Process Site Survey
 *
 *	set site survery, reauth. , reassoc, idle_timer and proces Site survey \n
 *	PS: ss_timer is site survey timer	\n
 */
void start_clnt_ss(struct rtl8192cd_priv *priv)
{

#if !defined(SMP_SYNC) || defined(CONFIG_RTK_MESH) 
    unsigned long	flags;
#endif

#ifdef SUPPORT_MULTI_PROFILE
    int j;
#endif

#ifdef CONFIG_RTL_NEW_AUTOCH
	struct acs_info *acs = &priv->pshare->acs_info;
#endif

#ifdef RTK_MULTI_AP
	unsigned int multi_ap_ss_chnl[2];
#endif

/*cfg p2p cfg p2p*/
#if defined(CONFIG_P2P_RTK_SUPPORT) && defined(RTK_NL80211)
    /*cfg p2p wpas support*/
    u8 tx_pause_val;

    if (!(priv->drv_state & DRV_STATE_OPEN)){
        NDEBUG("NOT STARTED YET!\n");        
        return;
    }

    if(priv->pshare->rtk_remain_on_channel){
        NDEBUG3("deny scan by rtk_remain_on_channel\n");
        return;
    }

    if(priv->pshare->deny_scan_myself){
        NDEBUG3("deny scan by deny_scan_myself\n");
        return;
    }    

    if(priv->pmib->miscEntry.func_off){
        NDEBUG3("chk!!!func_off on\n");
    }

    tx_pause_val=RTL_R8(TXPAUSE);
    if(tx_pause_val){
        NDEBUG3("!!!tx_pause_val[%X]\n",tx_pause_val);
    }    
#endif

#ifdef WIFI_WPAS_CLI
    printk("acli: start_ss_t ss_req:%d scanning:%d is_root:%d  \n",
    priv->ss_req_ongoing, priv->pshare->bScanInProcess, IS_ROOT_INTERFACE(priv));
#endif

    if (rtk_timer_pending(&priv->ss_timer))
        rtk_del_timer(&priv->ss_timer);
#ifdef CLIENT_MODE
    if (PENDING_REAUTH_TIMER)
        DELETE_REAUTH_TIMER;
    if (PENDING_REASSOC_TIMER)
        DELETE_REASSOC_TIMER;
    if (rtk_timer_pending(&priv->idle_timer))
        rtk_del_timer(&priv->idle_timer);
#endif

#ifdef P2P_SUPPORT
    /*cfg p2p cfg p2p*/
    if( rtk_p2p_is_enabled(priv) && (rtk_p2p_chk_role(priv,P2P_DEVICE))&&(rtk_p2p_chk_state(priv,P2P_S_LISTEN))){
        NDEBUG("p2p device listen mode don't SS!!\n");
        return;
    }
#endif					

#ifdef SDIO_AP_OFFLOAD
	ap_offload_deactivate(priv, OFFLOAD_PROHIBIT_SITE_SURVEY);
#endif

#ifdef USE_OUT_SRC
#ifdef _OUTSRC_COEXIST
    if(IS_OUTSRC_CHIP(priv))
#endif
        priv->pshare->bScanInProcess = TRUE;
#endif

    OPMODE_VAL(OPMODE & (~WIFI_SITE_MONITOR));

    SAVE_INT_AND_CLI(flags);
    OPMODE_VAL(OPMODE | WIFI_SITE_MONITOR);

    /* Assign site_survey_times and list of channels to be scanned */
#if defined(SMART_REPEATER_MODE) && !defined(RTK_NL80211)
    if (priv->ss_req_ongoing == SSFROM_REPEATER_VXD){
#if defined(CONFIG_RTL_SIMPLE_CONFIG)
        if(priv->pmib->dot11StationConfigEntry.sc_enabled == 0){
            if(get_ss_level(priv) > SS_LV_WSTA){
                priv->site_survey_times = SS_COUNT-2;
            }else {
                priv->site_survey_times = SS_COUNT-1;
            }
        }else{
            priv->site_survey_times = 0;
        }
#else
#ifdef RTK_MULTI_AP
		if(priv->multiap_bssSteer_scan)
		{
			priv->site_survey_times = SS_COUNT-1;

			/* backup and set available_chnl */
			multi_ap_ss_chnl[0] = priv->multiap_bssSteer_channel;
			multi_ap_ss_chnl[1] = GET_ROOT(priv)->pmib->dot11RFEntry.dot11channel;

			if ((GET_ROOT(priv)->pmib->dot11RFEntry.dot11channel == priv->multiap_bssSteer_channel) || priv->auto_channel)
				bkpnset_avail_chnl(priv, multi_ap_ss_chnl, 1);
			else
				bkpnset_avail_chnl(priv, multi_ap_ss_chnl, 2);

			STADEBUG("Channel(s) to scan: %d\n", priv->available_chnl_num);
		}
		else
#endif
        if(get_ss_level(priv) > SS_LV_WSTA){
            priv->site_survey_times = SS_COUNT-2;
        }
        else{
            priv->site_survey_times = SS_COUNT-1;
        }
#endif	
    } else
#endif
#ifdef DOT11K
    if (priv->ss_req_ongoing == SSFROM_11K_BEACONREQ)
    {
        priv->site_survey_times = SS_COUNT-1;

        /* backup and set available_chnl */
        if (bkpnset_avail_chnl(priv, priv->rm.beacon_channel, priv->rm.beacon_channel_num)) {
            printk("Error: priv->rm.beacon_channel_num = %u\n", priv->rm.beacon_channel_num);
            goto restore_bScanInProcess;
        }
    }
    else
#endif
#if defined(RTK_MULTI_AP) && (EASYMESH_VERSION >= MULTI_AP_VERSION(2,0,0))
	if(priv->multiap_channel_scan)
	{
		//backup channels here
		//retrieve channel to scan from the request
		priv->site_survey_times = SS_COUNT-1;
		/*backup available_chnl*/
#ifdef DOT11K
		memcpy(priv->rm.available_chnl_backup, priv->available_chnl, priv->available_chnl_num * sizeof(unsigned int));
		priv->rm.available_chnl_num_backup = priv->available_chnl_num;
#endif
		priv->available_chnl_num = 0;

		priv->available_chnl_num = priv->multiap_requested_channel_nr;
		// memcpy(priv->available_chnl, priv->multiap_requested_channels, priv->multiap_requested_channel_nr);
		//handle diff in variable type
		unsigned char i;
		for (i = 0; i < priv->available_chnl_num; i++) {
			priv->available_chnl[i] = priv->multiap_requested_channels[i];
		}

		// priv->available_chnl[0] = 44;
		// priv->available_chnl[1] = 149;
		// priv->available_chnl_num = 2;
		STADEBUG("Channel(s) to scan: %d\n", priv->available_chnl_num);
	}
	else
#endif
    {
#if defined(RTK_NL80211)
#if defined(P2P_SUPPORT)
        if(rtk_p2p_is_enabled(priv) && priv->ss_ssidlen){
            priv->site_survey_times=0;
        }else
#endif
        {
        	//brian, only scan all channels one round, because Hostapd will scan 5 times by default
            priv->site_survey_times = SS_COUNT-1;
        }
#else
#ifdef WLAN_DIAGNOSTIC
		if (GET_MIB(priv)->dot11StationConfigEntry.probe_info_enable == 2 && GET_MIB(priv)->dot11StationConfigEntry.passive_scan)
			priv->site_survey_times = SS_COUNT-1;
		else if (GET_MIB(priv)->dot11StationConfigEntry.unassoc_sta_scan_ongoing)
			priv->site_survey_times = SS_COUNT-1;
		else
#endif
        priv->site_survey_times = 0;			//normal case ss SS_COUNT times
#endif
    }

#ifdef RTK_MULTI_AP
	priv->ss_passive_toggle = 1;
	priv->ss_passive_offset = 0;
#endif

	RTL_W8(TXPAUSE, RTL_R8(TXPAUSE) | STOP_BCN); //when start ss, disable beacon

	/* assign first channel to be scanned */
	if(priv->site_survey->target_channel)
	    priv->site_survey->ss_channel = priv->site_survey->target_channel;
	else
	    priv->site_survey->ss_channel = priv->available_chnl[0];
	priv->site_survey->original_channel = priv->pmib->dot11RFEntry.dot11channel;

	priv->site_survey->scan_count = 0;

#if defined(CONFIG_RTL_92D_SUPPORT) && !defined(CONFIG_RTL_DUAL_PCIESLOT_BIWLAN_D)
    if ((GET_CHIP_VER(priv) == VERSION_8192D) && priv->pmib->dot11RFEntry.macPhyMode==SINGLEMAC_SINGLEPHY) {
        clnt_ss_check_band(priv, priv->site_survey->ss_channel);
    }
#endif

#ifdef SWITCH_CHAN
    //let vxd can do ss under 5G
    if(IS_VXD_INTERFACE(priv) && priv->pmib->wscEntry.wsc_enable)
    	GET_ROOT(priv)->func_backup = GET_ROOT(priv)->pmib->miscEntry.func_off;
#endif

#ifdef DFS
    if (!priv->pmib->dot11DFSEntry.disable_DFS && is_DFS_channel(priv, priv->site_survey->ss_channel))
        priv->pmib->dot11DFSEntry.disable_tx = 1;
    else
        priv->pmib->dot11DFSEntry.disable_tx = 0;
#ifdef UNIVERSAL_REPEATER
		if (IS_ROOT_INTERFACE(priv) || 
			(IS_VXD_INTERFACE(priv) && !GET_ROOT(priv)->pmib->dot11DFSEntry.CAC_ss_counter ))				
#endif
#endif				
		{

    if(priv->pmib->dot11nConfigEntry.dot11nUse40M == CHANNEL_WIDTH_10)
        priv->pshare->CurrentChannelBW = CHANNEL_WIDTH_10;
    else if(priv->pmib->dot11nConfigEntry.dot11nUse40M == CHANNEL_WIDTH_5)
        priv->pshare->CurrentChannelBW = CHANNEL_WIDTH_5;
    else
        priv->pshare->CurrentChannelBW = CHANNEL_WIDTH_20;
	if(priv->pmib->dot11StationConfigEntry.unassoc_sta_scan_ongoing)
    	priv->pshare->CurrentChannelBW = priv->pmib->dot11nConfigEntry.dot11nUse40M;
#if defined(CONFIG_RTL_SIMPLE_CONFIG)
    if(!rtk_sc_is_channel_fixed(priv))
#endif
    {
		RESTORE_INT(flags);
        SwBWMode(priv, priv->pshare->CurrentChannelBW, priv->pshare->offset_2nd_chan);
        SwChnl(priv, priv->site_survey->ss_channel, priv->pshare->offset_2nd_chan);
		SAVE_INT_AND_CLI(flags);
    }

#ifdef UNIVERSAL_REPEATER
    if (IS_VXD_INTERFACE(priv) && priv->pmib->wscEntry.wsc_enable)
        GET_ROOT(priv)->pmib->miscEntry.func_off = 1;
#endif
	}
#ifdef DFS
	if (GET_ROOT(priv)->pmib->dot11DFSEntry.CAC_ss_counter){
		GET_ROOT(priv)->pmib->dot11DFSEntry.CAC_ss_counter--;
	}
#endif

#ifdef DOT11K
    if(priv->ss_req_ongoing != SSFROM_11K_BEACONREQ)
#endif
    {
        priv->site_survey->count = 0;
        priv->site_survey->hidden_ap_found = 0;
        memset((void *)priv->site_survey->bss, 0, sizeof(struct bss_desc)*MAX_BSS_NUM);

#ifdef WIFI_SIMPLE_CONFIG
#ifndef MULTI_MAC_CLONE
#if defined(WIFI_WPAS_CLI)
		if ((OPMODE & WIFI_STATION_STATE) || (SSFROM_WPAS == priv->ss_req_ongoing))
#elif defined(WIFI_WPAS) || defined(RTK_NL80211)
		if (OPMODE & WIFI_STATION_STATE) 
#else
		if (priv->ss_req_ongoing == SSFROM_WSC)	//simple-config scan-req
#endif
#endif
		{
            memset((void *)priv->site_survey->wscie, 0, sizeof(struct wps_ie_info)*MAX_BSS_NUM);
		}
#endif

#if defined(WIFI_WPAS) || defined(RTK_NL80211)
        if (priv->ss_req_ongoing == SSFROM_WSC) {
            memset((void *)&priv->site_survey->rtk_p2p_ie, 0, sizeof(struct p2p_ie_info)*MAX_BSS_NUM);
		}
#endif
    }

#if defined(TESTCHIP_SUPPORT) && defined(CONFIG_RTL_92C_SUPPORT)
    if(IS_TEST_CHIP(priv))
        RTL_W8(BCN_CTRL, RTL_R8(BCN_CTRL) | DIS_TSF_UPDATE);
    else
#endif
        RTL_W8(BCN_CTRL, RTL_R8(BCN_CTRL) | DIS_TSF_UPDATE_N);

#if defined(CLIENT_MODE)
#if defined(TESTCHIP_SUPPORT) && defined(CONFIG_RTL_92C_SUPPORT)
    if( IS_TEST_CHIP(priv) ) {		
        if ((OPMODE & WIFI_STATION_STATE) || (OPMODE & WIFI_ADHOC_STATE))
            RTL_W32(RCR, RTL_R32(RCR) & ~RCR_CBSSID);
    } else
#endif
    {
            RTL_W32(RCR, RTL_R32(RCR) & ~RCR_CBSSID_ADHOC);
    }
#endif

    DIG_for_site_survey(priv, TRUE);
#if defined(CONFIG_RTL_92D_SUPPORT) && defined(CONFIG_RTL_NOISE_CONTROL)
    if (GET_CHIP_VER(priv) == VERSION_8192D){
        if (priv->pshare->DNC_on){
            phy_set_bb_reg(priv, 0x870, bMaskDWord, 0x07000700);
        }
    }
#endif	

    /* Trigger CLM & NHM measurement */
#if defined(RTK_NL80211) || defined(CH_LOAD_CAL) || defined(USE_OUT_SRC)
    if (IS_OUTSRC_CHIP(priv)) {
        if (priv->auto_channel == 1 && priv->ss_req_ongoing == SS_INACTIVE) {
            odm_pause_dig(ODMPTR, PHYDM_PAUSE, PHYDM_PAUSE_LEVEL_2, ACS_STEP1_IGI);
        } else if (priv->ss_req_ongoing == SSFROM_WEB) {
            odm_pause_dig(ODMPTR, PHYDM_PAUSE, PHYDM_PAUSE_LEVEL_2, SS_IGI);
        }
        ss_trigger_clm_nhm(priv, (priv->ss_req_ongoing == SS_INACTIVE), 0);
    } else {
        //by brian, trigger channel load evaluation after channel switched
        start_bbp_ch_load(priv, CLM_SAMPLE_SS);
    }    
#endif    
    
    RESTORE_INT(flags);

#ifdef DOT11K
    if(priv->ss_req_ongoing == SSFROM_11K_BEACONREQ)
    {
        priv->rm.measure_time_lo =  RTL_R32(TSFTR);
        priv->rm.measure_time_hi =  RTL_R32(TSFTR + 4);
    }
#endif
    
#ifdef CONFIG_RTL_NEW_AUTOCH
    if (priv->auto_channel == 1) {
        reset_fa_reg(priv);

        if (OPMODE & WIFI_AP_STATE)
            RTL_W32(RXERR_RPT, RXERR_RPT_RST);

		acs->step = 0;
		if (priv->pmib->dot11RFEntry.acs_type) {					
			//phydm_auto_channel_select_setting_ap(priv, STORE_DEFAULT_NHM_SETTING);
			//phydm_auto_channel_select_setting_ap(priv, ACS_NHM_SETTING);

			RTL_W8(TXPAUSE, STOP_BCN);

			memset(acs->nhm_cnt, 0, sizeof(acs->nhm_cnt));
			acs->step = 1;
			//nhm_trigger(priv);
		}
    }
#endif
    
    /* issue probe request */
    if((priv->site_survey->hidden_ap_found == HIDE_AP_FOUND_DO_ACTIVE_SSAN) ||
        !is_passive_channel(priv, priv->pmib->dot11StationConfigEntry.dot11RegDomain, priv->site_survey->ss_channel))
    {

        #ifdef DOT11K
        if(priv->ss_req_ongoing == SSFROM_11K_BEACONREQ)
        {
            if(priv->rm.beacon_req.mode == BEACON_MODE_ACTIVE)
            {
                if (priv->ss_ssidlen == 0)
                    issue_probereq(priv, NULL, 0, NULL);
                else
                    issue_probereq(priv, priv->ss_ssid, priv->ss_ssidlen, NULL);
            }
        }
        else
        #endif
        #ifdef CONFIG_RTK_MESH
        if(GET_MIB(priv)->dot1180211sInfo.mesh_enable)
            issue_probereq_MP(priv, NULL, 0, NULL, TRUE);
        else
        #endif
#ifdef WLAN_DIAGNOSTIC
	if (!GET_MIB(priv)->dot11StationConfigEntry.passive_scan)
#endif
        {
            /*no assigned SSID*/
            if (priv->ss_ssidlen == 0){

                #ifdef P2P_SUPPORT						
                /*cfg p2p cfg p2p*/				
                if( rtk_p2p_is_enabled(priv) && ((rtk_p2p_chk_role(priv,P2P_DEVICE))||(rtk_p2p_chk_role(priv,P2P_CLIENT))) ){
                    P2P_DEBUG("p2p scan (chann:%d)\n",priv->site_survey->ss_channel);
                    issue_probereq(priv, "DIRECT-", 7, NULL);
                }else
                #endif
                {
                    //STADEBUG("issue_probereq no assigned SSID\n");	
                    if (!acs->step) {
						issue_probereq(priv, NULL, 0, NULL);
					}
                }

            }else{   /*has assigned SSID*/
                #ifdef SUPPORT_MULTI_PROFILE	/*per channel tx multi probe_req by profile_num*/ 		
                if (priv->pmib->ap_profile.enable_profile && priv->pmib->ap_profile.profile_num > 0) {
                    for(j=0;j<priv->pmib->ap_profile.profile_num;j++) {									
                        NDEBUG3("issue_probereq,ssid[%s],ch=[%d]\n",priv->pmib->ap_profile.profile[j].ssid,priv->site_survey->ss_channel);
                        issue_probereq(priv, priv->pmib->ap_profile.profile[j].ssid, strlen(priv->pmib->ap_profile.profile[j].ssid), NULL);
                    }												
                }
                else	
                #endif		
                {						
                    NDEBUG3("issue_probereq,ssid[%s],ch[%d]\n",priv->ss_ssid,priv->site_survey->ss_channel);
                    issue_probereq(priv, priv->ss_ssid, priv->ss_ssidlen, NULL);
                }

            }
        }
    }
#ifdef CTC_2G_ACS
	if (priv->auto_channel && priv->auto_channel_use_score == 0) {
		atomic_set(&(priv->pshare->ss_score_timeout_count), priv->pmib->miscEntry.ss_score_timeout);
	}
#else
	if (priv->auto_channel && priv->auto_channel_use_score == 0){
		priv->pshare->ss_score_timeout_count = priv->pmib->miscEntry.ss_score_timeout;
	}
#endif /* CTC_2G_ACS */

#ifdef CONFIG_RTK_MESH
    if(GET_MIB(priv)->dot1180211sInfo.mesh_enable && priv->auto_channel)
    {
        SET_PSEUDO_RANDOM_NUMBER(flags);
        flags %= SS_RAND_DEFER;
    } else
        flags=0;
#endif

    /*how long stady on current channel -start*/
	#ifdef RTK_MULTI_AP
    if(priv->multiap_bssSteer_scan
#if (EASYMESH_VERSION >= MULTI_AP_VERSION(2,0,0))
		|| priv->multiap_channel_scan
#endif
		)
    {
		if (priv->available_chnl_num == 1) {
			rtk_mod_timer(&priv->ss_timer, jiffies + RTL_MILISECONDS_TO_JIFFIES(500));
		}
		else {
        rtk_mod_timer(&priv->ss_timer, jiffies + RTL_MILISECONDS_TO_JIFFIES(300));
    }
    }
    else
	#endif
    #ifdef DOT11K
    if(priv->ss_req_ongoing == SSFROM_11K_BEACONREQ)
    {
        rtk_mod_timer(&priv->ss_timer, jiffies + RTL_MILISECONDS_TO_JIFFIES(priv->rm.beacon_req.measure_duration));
    }
    else
    #endif
    if(is_passive_channel(priv, priv->pmib->dot11StationConfigEntry.dot11RegDomain, priv->site_survey->ss_channel))
    {
        if(priv->pmib->miscEntry.passive_ss_int) {
            rtk_mod_timer(&priv->ss_timer, jiffies + RTL_MILISECONDS_TO_JIFFIES(priv->pmib->miscEntry.passive_ss_int)
                    #ifdef CONFIG_RTK_MESH
                    + ( flags ) // for the deafness problem
                    #endif
            );
        } else {
            rtk_mod_timer(&priv->ss_timer, jiffies + SS_PSSV_TO
                    #ifdef CONFIG_RTK_MESH
                    + ( flags ) // for the deafness problem
                    #endif
            );
        }
    }else
    #ifdef P2P_SUPPORT
    /*cfg p2p cfg p2p*/
    if(rtk_p2p_is_enabled(priv)){
        /*search phase (only 1,6,11) use 120ms*/
        //P2P_DEBUG("%dms\n",P2P_SEARCH_TIME_V);
        rtk_mod_timer(&priv->ss_timer, jiffies + P2P_SEARCH_TIME);
    }else
    #endif
    {
        #ifdef CONFIG_RTL_NEW_AUTOCH
        if (priv->auto_channel == 1){
            if (acs->step) {
#ifdef CTC_2G_ACS
				if (priv->pmib->dot11RFEntry.phyBandSelect == PHY_BAND_2G)
					rtk_mod_timer(&priv->ss_timer, jiffies + SS_AUTO_CHNL_NHM_TO_2G);
				else
					rtk_mod_timer(&priv->ss_timer, jiffies + SS_AUTO_CHNL_NHM_TO_5G);
#else
				rtk_mod_timer(&priv->ss_timer, jiffies + SS_AUTO_CHNL_NHM_TO);
#endif /* CTC_2G_ACS */
			} else
				rtk_mod_timer(&priv->ss_timer, jiffies + SS_AUTO_CHNL_TO
                    #ifdef CONFIG_RTK_MESH
                    + ( flags ) // for the deafness problem
                    #endif
            );
        }else
        #endif
#ifdef WLAN_DIAGNOSTIC
	if (priv->pmib->dot11StationConfigEntry.probe_info_enable == 2 &&
		priv->pmib->dot11StationConfigEntry.passive_scan &&
		priv->pmib->dot11StationConfigEntry.scan_interval)
		rtk_mod_timer(&priv->ss_timer, jiffies + RTL_MILISECONDS_TO_JIFFIES(priv->pmib->dot11StationConfigEntry.scan_interval));
	else
#endif
#ifdef WLAN_DIAGNOSTIC
	if (priv->pmib->dot11StationConfigEntry.unassoc_sta_scan_ongoing)
		rtk_mod_timer(&priv->ss_timer, jiffies + RTL_MILISECONDS_TO_JIFFIES(priv->pmib->dot11StationConfigEntry.scan_interval));
	else
#endif
        {
            rtk_mod_timer(&priv->ss_timer, jiffies + RTL_MILISECONDS_TO_JIFFIES(priv->pmib->miscEntry.ss_to)
                    #ifdef CONFIG_RTK_MESH
                    + ( flags ) // for the deafness problem
                    #endif
            );
        }
	}
    /*how long stady on current channel -end*/

    return;

restore_bScanInProcess:

#ifdef USE_OUT_SRC
#ifdef _OUTSRC_COEXIST
    if(IS_OUTSRC_CHIP(priv))
#endif
        priv->pshare->bScanInProcess = FALSE;
#endif

    RESTORE_INT(flags);

    return;
}

static void ProfileSort(struct rtl8192cd_priv *priv, int CompareType , void  *base, int nel, int width)
{
	int wgap, i, j, k;
	unsigned char tmp;

	if ((nel > 1) && (width > 0)) {
		//assert( nel <= ((size_t)(-1)) / width ); /* check for overflow */
		wgap = 0;
		do {
			wgap = 3 * wgap + 1;
		} while (wgap < (nel-1)/3);

        /* From the above, we know that either wgap == 1 < nel or */
		/* ((wgap-1)/3 < (int) ((nel-1)/3) <= (nel-1)/3 ==> wgap <  nel. */
        
		wgap *= width;			/* So this can not overflow if wnel doesn't. */
		nel *= width;			/* Convert nel to 'wnel' */
		do {
			i = wgap;
			do {
				j = i;
				do {
					register unsigned char *a;
					register unsigned char *b;

					j -= wgap;
					a = (unsigned char *)(j + ((char *)base));
					b = a + wgap;
					if ( compareTpyeByProfile(priv,a, b,CompareType) <= 0 ) {
						break;
					}
					k = width;
					do {
						tmp = *a;
						*a++ = *b;
						*b++ = tmp;
					} while ( --k );
				} while (j >= wgap);
				i += width;
			} while (i < nel);
			wgap = (wgap - width)/3;
		} while (wgap);
	}
}

//#if defined(CONFIG_IEEE80211V_CLI) ||defined(CONFIG_IEEE80211R_CLI)
#ifdef CONFIG_IEEE80211V
void qsort (void  *base, int nel, int width,
				int (*comp)(const void *, const void *))
#else
static void qsort (void  *base, int nel, int width,
				int (*comp)(const void *, const void *))
#endif
{
	int wgap, i, j, k;
	unsigned char tmp;

	if ((nel > 1) && (width > 0)) {
		//assert( nel <= ((size_t)(-1)) / width ); /* check for overflow */
		wgap = 0;
		do {
			wgap = 3 * wgap + 1;
		} while (wgap < (nel-1)/3);
		/* From the above, we know that either wgap == 1 < nel or */
		/* ((wgap-1)/3 < (int) ((nel-1)/3) <= (nel-1)/3 ==> wgap <  nel. */
		wgap *= width;			/* So this can not overflow if wnel doesn't. */
		nel *= width;			/* Convert nel to 'wnel' */
		do {
			i = wgap;
			do {
				j = i;
				do {
					register unsigned char *a;
					register unsigned char *b;

					j -= wgap;
					a = (unsigned char *)(j + ((char *)base));
					b = a + wgap;
					if ( (*comp)(a, b) <= 0 ) {
						break;
					}
					k = width;
					do {
						tmp = *a;
						*a++ = *b;
						*b++ = tmp;
					} while ( --k );
				} while (j >= wgap);
				i += width;
			} while (i < nel);
			wgap = (wgap - width)/3;
		} while (wgap);
	}
}


static int get_profile_index(struct rtl8192cd_priv *priv ,char* SSID2Search)
{
     int idx=0;
     int len1=0;
     int len2=0;     
     len1 = strlen(SSID2Search);

    
     for(idx=0 ; idx < priv->pmib->ap_profile.profile_num ; idx++){
         len2 = strlen(priv->pmib->ap_profile.profile[idx].ssid);
         if(len1==len2){
            if(!strcmp(priv->pmib->ap_profile.profile[idx].ssid,SSID2Search)){
                return idx;                
            }
         }
     }
     return -1;

}
static int compareTpyeByProfile(struct rtl8192cd_priv *priv , const void *entry1, const void *entry2 , int CompareType)
{
    int result1=0;
    int result2=0;
    switch(CompareType){
        case COMPARE_BSS:               
                result1=get_profile_index(priv,((struct bss_desc *)entry1)->ssid);
                result2=get_profile_index(priv,((struct bss_desc *)entry2)->ssid);
                break;
        case COMPARE_WSCIE:
                result1=get_profile_index(priv,((struct wps_ie_info *)entry1)->ssid);
                result2=get_profile_index(priv,((struct wps_ie_info *)entry2)->ssid);
                break;
#ifdef WIFI_WPAS                
        case COMPARE_WPAIE:
                result1=get_profile_index(priv,((struct wpa_ie_info *)entry1)->ssid);
                result2=get_profile_index(priv,((struct wpa_ie_info *)entry2)->ssid);
                break;  
        case COMPARE_RSNIE:
                result1=get_profile_index(priv,((struct rsn_ie_info *)entry1)->ssid);
                result2=get_profile_index(priv,((struct rsn_ie_info *)entry2)->ssid);
                break;
#endif                
        default:
            STADEBUG("unknow, check!!!\n\n");
    }

	/*result more small then list at more front*/
    if (  result1 < result2 )
        return -1;

    if (  result1 > result2 )
        return 1;

    return 0; 

}

static int compareBSS(const void *entry1, const void *entry2)
{
	if (((struct bss_desc *)entry1)->rssi > ((struct bss_desc *)entry2)->rssi)
		return -1;

	if (((struct bss_desc *)entry1)->rssi < ((struct bss_desc *)entry2)->rssi)
		return 1;

	return 0;
}


#ifdef WIFI_SIMPLE_CONFIG
static int compareBSS_for_2G(const void *entry1, const void *entry2)
{
	if (((struct bss_desc *)entry1)->channel <= 14 && ((struct bss_desc *)entry2)->channel > 14)
		return -1;

	if (((struct bss_desc *)entry1)->channel > 14 && ((struct bss_desc *)entry2)->channel <= 14)
		return 1;

	if (((struct bss_desc *)entry1)->rssi > ((struct bss_desc *)entry2)->rssi)
		return -1;

	if (((struct bss_desc *)entry1)->rssi < ((struct bss_desc *)entry2)->rssi)
		return 1;

	return 0;
}

static int compareWpsIE(const void *entry1, const void *entry2)
{
	if (((struct wps_ie_info *)entry1)->rssi > ((struct wps_ie_info *)entry2)->rssi)
		return -1;

	if (((struct wps_ie_info *)entry1)->rssi < ((struct wps_ie_info *)entry2)->rssi)
		return 1;

	return 0;
}

static int compareWpsIE_for_2G(const void *entry1, const void *entry2)
{
	if (((struct wps_ie_info *)entry1)->chan <= 14 && ((struct wps_ie_info *)entry2)->chan > 14	)
		return -1;

	if (((struct wps_ie_info *)entry1)->chan > 14 && ((struct wps_ie_info *)entry2)->chan <= 14	)
		return 1;

	if (((struct wps_ie_info *)entry1)->rssi > ((struct wps_ie_info *)entry2)->rssi)
		return -1;

	if (((struct wps_ie_info *)entry1)->rssi < ((struct wps_ie_info *)entry2)->rssi)
		return 1;

	return 0;
}
#endif

#if defined(WIFI_WPAS) || defined(RTK_NL80211)
static int compareWpaIE(const void *entry1, const void *entry2)
{
	if (((struct wpa_ie_info *)entry1)->rssi > ((struct wpa_ie_info *)entry2)->rssi)
		return -1;

	if (((struct wpa_ie_info *)entry1)->rssi < ((struct wpa_ie_info *)entry2)->rssi)
		return 1;

	return 0;
}

static int compareRsnIE(const void *entry1, const void *entry2)
{
	if (((struct rsn_ie_info *)entry1)->rssi > ((struct rsn_ie_info *)entry2)->rssi)
		return -1;

	if (((struct rsn_ie_info *)entry1)->rssi < ((struct rsn_ie_info *)entry2)->rssi)
		return 1;

	return 0;
}

static int compareP2PIE(const void *entry1, const void *entry2)
{
	if (((struct p2p_ie_info *)entry1)->rssi > ((struct p2p_ie_info *)entry2)->rssi)
		return -1;

	if (((struct p2p_ie_info *)entry1)->rssi < ((struct p2p_ie_info *)entry2)->rssi)
		return 1;

	return 0;
}
#endif

static void debug_print_bss(struct rtl8192cd_priv *priv)
{
#if 0
	STADEBUG("Got ssid count %d\n", priv->site_survey->count);

	int i;

	panic_printk("Got ssid count %d\n", priv->site_survey->count);
	panic_printk("SSID                 BSSID        ch  prd cap  bsc  oper ss sq bd 40m\n");
	for(i=0; i<priv->site_survey->count; i++)
	{
		char tmpbuf[33];
		UINT8 *mac = priv->site_survey->bss[i].bssid;

		memcpy(tmpbuf, priv->site_survey->bss[i].ssid, priv->site_survey->bss[i].ssidlen);
		if (priv->site_survey->bss[i].ssidlen < 20) {
			memset(tmpbuf+priv->site_survey->bss[i].ssidlen, ' ', 20-priv->site_survey->bss[i].ssidlen);
			tmpbuf[20] = '\0';
		}
		else
			tmpbuf[priv->site_survey->bss[i].ssidlen] = '\0';

		panic_printk("%s %02x%02x%02x%02x%02x%02x %2d %4d %04x %04x %04x %02x %02x %02x %3d\n",
			tmpbuf,mac[0],mac[1],mac[2],mac[3],mac[4],mac[5],priv->site_survey->bss[i].channel,
			priv->site_survey->bss[i].beacon_prd,priv->site_survey->bss[i].capability,
			(unsigned short)priv->site_survey->bss[i].basicrate,
			(unsigned short)priv->site_survey->bss[i].supportrate,
			priv->site_survey->bss[i].rssi,priv->site_survey->bss[i].sq,
			priv->site_survey->bss[i].network,
			((priv->site_survey->bss[i].t_stamp[1] & BIT(1)) ? 1 : 0)
			);
	}
    panic_printk("\n\n");
#endif
}

void rtl8192cd_ss_timer(unsigned long task_priv)
{
	struct rtl8192cd_priv *priv = (struct rtl8192cd_priv *)task_priv;
	int idx, loop_finish=0, scan_again=0, ret=0;
	int AUTOCH_SS_COUNT=SS_COUNT;//AUTOCH_SS_SPEEDUP
	int i,j;
	unsigned int max_ss_score = 0;

#ifdef CONFIG_RTL_NEW_AUTOCH
	struct acs_info *acs = &priv->pshare->acs_info;
#endif

	if(priv->pmib->miscEntry.ss_cnt)
		AUTOCH_SS_COUNT = priv->pmib->miscEntry.ss_cnt;

#ifdef SUPPORT_MULTI_PROFILE
	int jdx;
#endif
#if defined(CONFIG_P2P_RTK_SUPPORT) && defined(RTK_NL80211)
    u8 tx_pause_val;
#endif
	if (!(priv->drv_state & DRV_STATE_OPEN))
		return;

#ifndef WIFI_WPAS_CLI
#if (defined( UNIVERSAL_REPEATER) || defined(MBSSID)) && defined(CLIENT_MODE) && !defined(RTK_NL80211)
	//for RTK_NL80211, let scan triggered by upper layer
	if (priv->ss_req_ongoing == SS_INACTIVE) {
		if(!IS_ROOT_INTERFACE(priv)){
			start_repeater_ss(priv); // site survey by vxd or vap
    		return;
        }
	}
#endif    
#endif
/*cfg p2p cfg p2p*/
#if defined(P2P_SUPPORT) && defined(CONFIG_OPENWRT_SDK)
	if (!(priv->drv_state & DRV_STATE_OPEN)){
        P2P_DEBUG("abort ss_timer interface not opened yet\n");        
		return;
    }
    if(priv->pshare->deny_scan_myself){
        P2P_DEBUG("abort ss_timer by deny_scan_myself\n");
        goto abort_scan;
    }
    if(priv->pshare->rtk_remain_on_channel){
        P2P_DEBUG("abort ss_timer by rtk_remain_on_channel\n");
        goto abort_scan;

    }

#if defined(P2P_SUPPORT)
    if( rtk_p2p_is_enabled(priv) && (rtk_p2p_chk_role(priv,P2P_DEVICE))&&(rtk_p2p_chk_state(priv,P2P_S_LISTEN))){
        NDEBUG3("stop ss_timer when P2P_S_LISTEN\n");
        goto abort_scan;        
    }
#endif

    if(priv->pmib->miscEntry.func_off){
        P2P_DEBUG("chk!!!func_off on\n");
    } 
    if(tx_pause_val=RTL_R8(TXPAUSE)){
        P2P_DEBUG("tx_pause_val[%X]\n",tx_pause_val);
    }
#endif   


    SMP_LOCK(flags);

    /*cfg p2p cfg p2p*/
#ifdef CONFIG_RTK_MESH
    if(GET_MIB(priv)->dot1180211sInfo.mesh_enable && priv->auto_channel) {
        if(priv->mesh_swchnl_channel) {/* force abort mesh auto channel procedure*/           
            STADEBUG("Mesh Switch Channel, force abort auto channel procedure\n");
            goto abort_scan;
        }            

        #ifdef DFS
        if(GET_ROOT(priv)->pmib->dot11DFSEntry.DFS_detected) {
            STADEBUG("Detect Radar, force abort auto channel procedure\n");
            GET_ROOT(priv)->pmib->dot11DFSEntry.DFS_detected = 0;
            goto abort_scan; /* force abort mesh auto channel procedure*/
        }
        #endif         
    }
#endif

    STADEBUG("rtl8192cd_ss_timer,ss_channel=%d\n",priv->site_survey->ss_channel);


#ifdef MULTI_MAC_CLONE
	ACTIVE_ID = 0;
#endif

	for (idx=0; idx<priv->available_chnl_num; idx++)
		if (priv->site_survey->ss_channel == priv->available_chnl[idx])
			break;

	/* Collect CLM & NHM results and calculate channel statistic */
#if defined(USE_OUT_SRC) || defined(CH_LOAD_CAL)
	if (IS_OUTSRC_CHIP(priv)) {
		ret = calc_ch_ss_load(priv, &(priv->pshare->ch_ss_info[idx]), idx);
		if (ret == -1) {
			memset(&(priv->pshare->ch_ss_info[idx]), 0, sizeof(RT_CH_LOAD_SS_INFO));
		} else if (ret == -2) {
			scan_again = 1;
			priv->site_survey->scan_count++;
		}
#if defined(RTK_NL80211)
		priv->rtk->survey_info[idx].chbusytime = priv->pshare->ch_ss_info[idx].chload_time;
#endif

		priv->pshare->ch_ss_info[idx].channel = priv->site_survey->ss_channel;
	} else
#endif
	{
#if defined(RTK_NL80211)
		int val = read_bbp_ch_load(priv);
		if(val != -1) {
			priv->rtk->survey_info[idx].chbusytime = (val/1000)*5;
		} else {
			priv->rtk->survey_info[idx].chbusytime = 0;
			NDEBUG("Invalid channel load!\n");
		}

#endif
	}

#if defined(RTK_NL80211)
	priv->rtk->survey_info[idx].channel = priv->site_survey->ss_channel;
	check_sta_throughput(priv, idx);
	read_noise_report(priv, idx);
#endif

#ifdef CONFIG_RTL_NEW_AUTOCH
#ifdef AUTOCH_SS_SPEEDUP
	if (priv->auto_channel == 1)
		if(priv->pmib->miscEntry.autoch_ss_cnt>0)
			AUTOCH_SS_COUNT = priv->pmib->miscEntry.autoch_ss_cnt;
#endif
	if (priv->auto_channel == 1) {
		unsigned int ofdm_ok, cck_ok, ht_ok;

		if (!priv->site_survey->to_scan_40M && (acs->step <= 1)) {
			query_fa_static(priv, idx);
		}

		RTL_W32(RXERR_RPT, 0 << RXERR_RPT_SEL_SHIFT);
		ofdm_ok = RTL_R16(RXERR_RPT);

		RTL_W32(RXERR_RPT, 3 << RXERR_RPT_SEL_SHIFT);
		cck_ok = RTL_R16(RXERR_RPT);

		RTL_W32(RXERR_RPT, 6 << RXERR_RPT_SEL_SHIFT);
		ht_ok = RTL_R16(RXERR_RPT);

		RTL_W32(RXERR_RPT, RXERR_RPT_RST);

		if (priv->site_survey->to_scan_40M) {
			unsigned int z=0, ch_begin=0, ch_end=priv->available_chnl_num, 
				current_ch = phy_query_rf_reg(priv, RF_PATH_A, 0x18, 0xff, 1);
			int idx_2G_end=-1;
#if defined(RTK_5G_SUPPORT) 
			int idx_5G_begin=-1;
			if (priv->pmib->dot11RFEntry.phyBandSelect == PHY_BAND_5G) {
				for (z=0; z<priv->available_chnl_num; z++) {
					if (priv->available_chnl[z] > 14) {
						idx_5G_begin = z;
						break;
					}
				}
				if (idx_5G_begin >= 0) 
					ch_begin = idx_5G_begin;

				for (z=ch_begin; z < ch_end; z++) {
					if ((priv->available_chnl[z] == (current_ch+2)) || (priv->available_chnl[z] == (current_ch-2))) {
						priv->chnl_ss_mac_rx_count_40M[z] = ofdm_ok + cck_ok + ht_ok;
					}
				}
			} else
#endif
			{
				for (z=0; z<priv->available_chnl_num; z++) {
					if (priv->available_chnl[z] <= 14)
						idx_2G_end = z;
					else
						break;
				}
				if (idx_2G_end >= 0) 
					ch_end = idx_2G_end+1;

				for (z=ch_begin; z < ch_end; z++) {
					if (priv->available_chnl[z] == current_ch) {
						priv->chnl_ss_mac_rx_count_40M[z] = ofdm_ok + cck_ok + ht_ok;
						break;
					}
				}
			}
		} else {
			priv->chnl_ss_mac_rx_count[idx] = ofdm_ok + cck_ok + ht_ok;
		}

		//if (priv->pmib->dot11RFEntry.acs_type && acs->step)
		//	phydm_get_nhm_statistics_ap(priv, idx);    // @ 2G, Real channel number = idx+1
	}
#endif          // #ifdef CONFIG_RTL_NEW_AUTOCH

	priv->ss_channel_info[idx].channel = priv->site_survey->ss_channel;
	priv->ss_channel_info[idx].utilization = priv->ext_stats.ch_utilization;
	priv->ss_channel_info[idx].noise = (priv->pshare->FA_total_cnt)?(priv->pshare->CCA_total_cnt/priv->pshare->FA_total_cnt):(1);
	// panic_printk("Site survey channel: %d\t [%d]\t[%d]\n", priv->ss_channel_info[idx].channel, priv->ss_channel_info[idx].utilization, priv->ss_channel_info[idx].noise);

#ifdef RTK_MULTI_AP
	if(priv->multiap_bssSteer_scan
#if (EASYMESH_VERSION >= MULTI_AP_VERSION(2,0,0))
		|| priv->multiap_channel_scan
#endif
	){
		if(idx == (priv->available_chnl_num - 1)){
			loop_finish = 1;

			panic_printk("Site survey count: %d\n", priv->site_survey->count);
			// for(loop_finish = 0; loop_finish < priv->site_survey->count; loop_finish++){
			// 	panic_printk("Bssid: %02x%02x%02x%02x%02x%02x\n", priv->site_survey->bss[loop_finish].bssid[0],
			// 	priv->site_survey->bss[loop_finish].bssid[1],
			// 	priv->site_survey->bss[loop_finish].bssid[2],
			// 	priv->site_survey->bss[loop_finish].bssid[3],
			// 	priv->site_survey->bss[loop_finish].bssid[4],
			// 	priv->site_survey->bss[loop_finish].bssid[5]);
			// 	panic_printk("SSID: %s\n", priv->site_survey->bss[loop_finish].ssid);
			// 	panic_printk("Channel: %d\n", priv->site_survey->bss[loop_finish].channel);
			// 	panic_printk("Rssi: %d\n", priv->site_survey->bss[loop_finish].rssi);
			// }
#if (EASYMESH_VERSION >= MULTI_AP_VERSION(2,0,0))
			unsigned char i, j, k;
			for (i = 0; i < priv->site_survey->count; i++) {
				for (j = 0; j < priv->multiap_requested_channel_nr; j++) {
					for(k = 0; k < priv->available_chnl_num; k++) {
						if(priv->ss_channel_info[k].channel == priv->multiap_scan_result->channels[j].channel)
							break;
					}

					if(k == priv->available_chnl_num) {
						printk("Cannot find channel %d from %d channels!\n", priv->multiap_scan_result->channels[j].channel, priv->available_chnl_num);
						k = 0;
					}

					priv->multiap_scan_result->channels[j].channel_utilization = priv->ss_channel_info[k].utilization;
					priv->multiap_scan_result->channels[j].noise = priv->ss_channel_info[k].noise;
					//find the channel entry
					if (priv->multiap_scan_result->channels[j].channel == priv->site_survey->bss[i].channel) {
						//----Might need to remove this in future---
						//if(strcmp(priv->site_survey->bss[i].ssid, GET_VXD_PRIV(priv)->pmib->dot11StationConfigEntry.dot11DesiredSSID) != 0){
						// printk("ROOT ssid : %s\n", GET_ROOT(priv)->pmib->dot11StationConfigEntry.dot11DesiredSSID);
						// printk("Scaned ssid : %s\n", priv->site_survey->bss[i].ssid);
						// if(strcmp(priv->site_survey->bss[i].ssid, GET_ROOT(priv)->pmib->dot11StationConfigEntry.dot11DesiredSSID) != 0){
						// 	continue;
						// }
						// printk("Not continued...\n");
						//------------------------------------------
						priv->multiap_scan_result->channels[j].neighbors = (struct map_channel_scan_neighbor*)krealloc(priv->multiap_scan_result->channels[j].neighbors, (priv->multiap_scan_result->channels[j].neighbor_nr + 1) * sizeof(struct map_channel_scan_neighbor), GFP_ATOMIC);
						memcpy(priv->multiap_scan_result->channels[j].neighbors[priv->multiap_scan_result->channels[j].neighbor_nr].bssid, priv->site_survey->bss[i].bssid, 6);
						priv->multiap_scan_result->channels[j].neighbors[priv->multiap_scan_result->channels[j].neighbor_nr].ssid_length			= strlen(priv->site_survey->bss[i].ssid);
						priv->multiap_scan_result->channels[j].neighbors[priv->multiap_scan_result->channels[j].neighbor_nr].ssid					= (char*)kmalloc(priv->multiap_scan_result->channels[j].neighbors[priv->multiap_scan_result->channels[j].neighbor_nr].ssid_length + 1, GFP_ATOMIC);
						memcpy(priv->multiap_scan_result->channels[j].neighbors[priv->multiap_scan_result->channels[j].neighbor_nr].ssid, priv->site_survey->bss[i].ssid, priv->multiap_scan_result->channels[j].neighbors[priv->multiap_scan_result->channels[j].neighbor_nr].ssid_length + 1);
						priv->multiap_scan_result->channels[j].neighbors[priv->multiap_scan_result->channels[j].neighbor_nr].signal_strength		= priv->site_survey->bss[i].rssi;

						priv->multiap_scan_result->channels[j].neighbors[priv->multiap_scan_result->channels[j].neighbor_nr].channel_band_width		= 1; //hardcode 20
						priv->multiap_scan_result->channels[j].neighbors[priv->multiap_scan_result->channels[j].neighbor_nr].channel_utilization	= 0;
						priv->multiap_scan_result->channels[j].neighbors[priv->multiap_scan_result->channels[j].neighbor_nr].station_count			= 0;

						priv->multiap_scan_result->channels[j].neighbor_nr++;
						break;
					}
				}
			}
#endif

			loop_finish = 1;
		}
		else{
			if (priv->ss_req_ongoing == SSFROM_PASSIVE) {
				if ((priv->ss_passive_toggle) && (GET_ROOT(priv)->pmib->dot11RFEntry.dot11channel != priv->available_chnl[priv->ss_passive_offset]))
				{
					priv->ss_passive_toggle = 0;
					priv->site_survey->ss_channel = GET_ROOT(priv)->pmib->dot11RFEntry.dot11channel;
				}
				else
				{
					priv->ss_passive_toggle = 1;
					priv->site_survey->ss_channel = priv->available_chnl[priv->ss_passive_offset + 1];
					priv->ss_passive_offset++;
				}
		}
		else{
			priv->site_survey->ss_channel = priv->available_chnl[idx+1];             
		}		
	}
	}
	else
#endif
#ifdef DOT11K
    if(priv->ss_req_ongoing == SSFROM_11K_BEACONREQ) {
        if(priv->rm.force_stop_ss || idx == (priv->available_chnl_num - 1)){
            loop_finish = 1;                        
        }
        else {
            priv->site_survey->ss_channel = priv->available_chnl[idx+1];
        }
    }
    else
#endif
    if ((idx == (priv->available_chnl_num - 1) ||
        ((priv->site_survey->target_channel) && (priv->available_chnl[idx] == priv->site_survey->target_channel)) ||
		(priv->auto_channel_use_score))&&
        priv->site_survey->hidden_ap_found != HIDE_AP_FOUND) {
        loop_finish = 1;						

        //if (acs->step == 2)
        //	phydm_auto_channel_select_setting_ap(priv, RESTORE_DEFAULT_NHM_SETTING);
        odm_pause_dig(ODMPTR, PHYDM_RESUME, PHYDM_PAUSE_LEVEL_2, ACS_SS_IGI_RESUME);
    }
    else {
        if (priv->site_survey->hidden_ap_found != HIDE_AP_FOUND) {			
            #if defined(DFS)
            if(priv->site_survey->defered_ss) {
                priv->site_survey->defered_ss--;
            } else
            #endif
            {
#if defined(CONFIG_RTL_SIMPLE_CONFIG)
		if(!rtk_sc_is_channel_fixed(priv))
			clean_sc_syn();
#endif
			{
				if (!scan_again || priv->site_survey->scan_count >= 2) {
					priv->site_survey->ss_channel = priv->available_chnl[idx+1];
					priv->site_survey->scan_count = 0;
				}
			}
                #if defined(DFS)
                priv->site_survey->defered_ss = should_defer_ss(priv);
                #endif
            }

			if(priv->pmib->dot11RFEntry.disable_scan_ch14 && priv->site_survey->ss_channel == 14) {

				if( priv->available_chnl[(priv->available_chnl_num - 1)] == 14) 
					loop_finish = 1;
				else {

					for(idx=0; idx<priv->available_chnl_num; idx++){
						if(priv->available_chnl[idx] == 14)
							break;
					}

					priv->site_survey->ss_channel = priv->available_chnl[idx+1];

				}
			}

            priv->site_survey->hidden_ap_found = 0;
        }
        else{ 
            STADEBUG("HIDE_AP_FOUND_DO_ACTIVE_SSAN\n"); 
            priv->site_survey->hidden_ap_found = HIDE_AP_FOUND_DO_ACTIVE_SSAN;
        }
        #ifdef CONFIG_RTL_NEW_AUTOCH
        if ((priv->auto_channel == 1) && priv->site_survey->to_scan_40M) {
            #if defined(RTK_5G_SUPPORT) 
            if (priv->pmib->dot11RFEntry.phyBandSelect == PHY_BAND_5G) {
                unsigned int current_ch = phy_query_rf_reg(priv, RF_PATH_A, 0x18, 0xff, 1);

                if (((priv->site_survey->ss_channel+2) == current_ch) || ((priv->site_survey->ss_channel-2) == current_ch)) {
                    if ((idx+2) >= (priv->available_chnl_num - 1))
                        loop_finish = 1;
                    else
                        priv->site_survey->ss_channel = priv->available_chnl[idx+2];
                }
            } else
            #endif
            {
                if (priv->site_survey->ss_channel == 14)
                    loop_finish = 1;
            }
        }
        #endif
    }

    if (loop_finish) {
        priv->site_survey_times++;
#ifdef RTK_MULTI_AP
		priv->ss_passive_toggle = 0;
		priv->ss_passive_offset = 0;
#endif
#ifdef SIMPLE_CH_UNI_PROTOCOL
        if(priv->auto_channel == 1
			&& GET_MIB(priv)->dot1180211sInfo.mesh_enable
			&& priv->site_survey_times <= _11S_SS_COUNT1+_11S_SS_COUNT2
#ifdef RTK_MESH_SIMPLE_CSA
			&& priv->mesh_CSA_state == MESH_CSA_NONE
#endif
		)
        {
            int reorder_chnl = 0;
            if( priv->site_survey_times == _11S_SS_COUNT1+_11S_SS_COUNT2 ) {
                reorder_chnl = 1;
            }
            else if(priv->site_survey_times == _11S_SS_COUNT1) {
                if(priv->mesh_ChannelPrecedence == 0)/*not yet select channel or recieved others channel number*/
                {
                    reorder_chnl = 1; /*for selectClearChannel to collect parameters*/
                }
            }
            else if(priv->site_survey_times == _11S_SS_COUNT1+1) {
                if(priv->mesh_ChannelPrecedence == 0)/*not yet select channel or recieved others channel number*/
                {                 
                    priv->pmib->dot11RFEntry.dot11channel = selectClearChannel(priv);
                    SET_PSEUDO_RANDOM_NUMBER(priv->mesh_ChannelPrecedence);
                }
            }

            if(reorder_chnl) {
                get_available_channel(priv);
            }
            else {
                for(i=0; i<priv->available_chnl_num; i++)
                {
                    get_random_bytes(&(idx), sizeof(idx));
                    idx %= priv->available_chnl_num;
                    loop_finish = priv->available_chnl[idx];
                    priv->available_chnl[idx] = priv->available_chnl[i];
                    priv->available_chnl[i] = loop_finish;
                }
            }
            priv->site_survey->ss_channel = priv->available_chnl[0];
        }
        else

#endif

// only do multiple scan when site-survey request, david+2006-01-25
//		if (priv->site_survey_times < SS_COUNT)
		if (priv->ss_req_ongoing && priv->site_survey_times < AUTOCH_SS_COUNT) {//AUTOCH_SS_SPEEDUP
// mark by david ---------------------
            #if 0   // mark by david ---------------------
			// scan again
			if (priv->pmib->dot11RFEntry.dot11ch_low != 0)
				priv->site_survey->ss_channel = priv->pmib->dot11RFEntry.dot11ch_low;
			else
            #endif  //------------------------ 2007-04-14
			
			//if scan 40M, start channel from start_ch_40M
			if(priv->site_survey->to_scan_40M && priv->site_survey->start_ch_40M!=0)
				priv->site_survey->ss_channel = priv->site_survey->start_ch_40M;
			else {   
				#if defined(CONFIG_RTL_SIMPLE_CONFIG) && defined(CONFIG_WLAN_HAL_8197F)
					if ((GET_CHIP_VER(priv) == VERSION_8197F)){ 
						if ( priv->pshare->offset_2nd_chan  == HT_2NDCH_OFFSET_BELOW ){
							priv->site_survey->ss_channel = priv->available_chnl[2]; 							
						}else {
							priv->site_survey->ss_channel = priv->available_chnl[0];							
						}
					}
					else {
						priv->site_survey->ss_channel = priv->available_chnl[0];						
					}
				#else
					
					priv->site_survey->ss_channel = priv->available_chnl[0];
				#endif				
			}

			if(priv->pmib->miscEntry.ss_loop_delay) {
				//STADEBUG("loop delay for %d miliseconads\n",priv->pmib->miscEntry.ss_loop_delay);
				if(rtk_timer_pending(&priv->ss_timer))
					rtk_del_timer(&priv->ss_timer);
				rtk_mod_timer(&priv->ss_timer, jiffies + RTL_MILISECONDS_TO_JIFFIES(priv->pmib->miscEntry.ss_loop_delay));

				if(priv->ss_req_ongoing == SSFROM_REPEATER_VXD) {
					//STADEBUG("RollBack to ROOT's ch[%d] between loop\n",GET_ROOT(priv)->pmib->dot11RFEntry.dot11channel);
#if defined(CONFIG_RTL_SIMPLE_CONFIG)
					if(!rtk_sc_is_channel_fixed(priv))
#endif
					{
						if (GET_ROOT(priv)->pmib->dot11RFEntry.dot11channel == 0)
							GET_ROOT(priv)->pmib->dot11RFEntry.dot11channel = GET_ROOT(priv)->site_survey->original_channel;
						
						if (!is_DFS_channel(GET_ROOT(priv), GET_ROOT(priv)->pmib->dot11RFEntry.dot11channel))
							RTL_W8(TXPAUSE, RTL_R8(TXPAUSE)& ~STOP_BCN);
						else
							RTL_W8(TXPAUSE, RTL_R8(TXPAUSE) | STOP_BCN);
						SwBWMode(GET_ROOT(priv), GET_ROOT(priv)->pshare->CurrentChannelBW, GET_ROOT(priv)->pshare->offset_2nd_chan);
						SwChnl(GET_ROOT(priv), GET_ROOT(priv)->pmib->dot11RFEntry.dot11channel, GET_ROOT(priv)->pshare->offset_2nd_chan);
					}
#if defined(DFS)
					priv->pmib->dot11DFSEntry.disable_tx = 0;
#endif
				}
				return;
			}
		}
#ifdef CONFIG_RTL_NEW_AUTOCH
		else if ((priv->auto_channel == 1) && !priv->site_survey->to_scan_40M && (priv->ss_req_ongoing == SS_INACTIVE)) {
			unsigned int z=0, ch_begin=0, ch_end=priv->available_chnl_num;
			int idx_2G_end=-1;
			unsigned int proc_nhm = 0;
#if defined(RTK_5G_SUPPORT) 
			int idx_5G_begin=-1;
			if (priv->pmib->dot11RFEntry.phyBandSelect == PHY_BAND_5G) {
				for (z=0; z<priv->available_chnl_num; z++) {
					if (priv->available_chnl[z] > 14) {
						idx_5G_begin = z;
						break;
					}
				}
				if (idx_5G_begin < 0) 
					goto skip_40M_ss;
			} else 
#endif
			if (priv->pmib->dot11RFEntry.acs_type && acs->step == 1)
	        {
				//phydm_auto_channel_select_setting_ap(priv, ACS_NHM_SETTING);
				odm_pause_dig(ODMPTR, PHYDM_RESUME, PHYDM_PAUSE_LEVEL_2, ACS_SS_IGI_RESUME);
				odm_pause_dig(ODMPTR, PHYDM_PAUSE, PHYDM_PAUSE_LEVEL_2, ACS_STEP2_IGI);
				acs->step = 2;
		        priv->site_survey_times = 0;
		        priv->site_survey->ss_channel = priv->available_chnl[0];
		        proc_nhm = 1;
	        }        
	        else
			{
                if (acs->step == 2)
				{
					DEBUG_INFO(" Restart Beacon, auto_channel_step=%d\n", acs->step);
					RTL_W8(TXPAUSE, RTL_R8(TXPAUSE)&~STOP_BCN);
					acs->step = 0;
					goto skip_40M_ss;
				}
				
				for (z=0; z<priv->available_chnl_num; z++) {
					if (priv->available_chnl[z] < 14)
						idx_2G_end = z;
					else
						break;
				}
				if (idx_2G_end >= 0) 
					ch_end = idx_2G_end+1;

				for (z=ch_begin; z < ch_end; z++)
					if ((priv->available_chnl[z] >= 5) && (priv->available_chnl[z] < 14))
						break;
				if (z == ch_end)
					goto skip_40M_ss;
			}

			if (!proc_nhm) {
				priv->site_survey->to_scan_40M++;
				priv->site_survey->ss_channel = priv->available_chnl[z];
				priv->site_survey->start_ch_40M = priv->available_chnl[z];//when scan 40M, record start ch
				//priv->site_survey_times = 0;//Do not reset the ss_time because it will rescan SS_COUNT again //AUTOCH_SS_SPEEDUP
				priv->pshare->CurrentChannelBW = CHANNEL_WIDTH_40;
			}
		}
#endif
        else {
#ifdef CONFIG_RTL_NEW_AUTOCH
skip_40M_ss:
            priv->site_survey->to_scan_40M = 0;
#endif
            /*cfg p2p cfg p2p*/
#if (defined(CONFIG_P2P_RTK_SUPPORT) && defined(RTK_NL80211)) || defined(CONFIG_RTK_MESH)
abort_scan:
#endif
            // scan end			
            OPMODE_VAL(OPMODE & ~WIFI_SITE_MONITOR);
            //STADEBUG("End of scan\n"); 
			if(priv->site_survey->pptyIE) {
				if(priv->site_survey->pptyIE->content) {
					kfree(priv->site_survey->pptyIE->content);
					priv->site_survey->pptyIE->content = NULL;
				}

				kfree(priv->site_survey->pptyIE);
				priv->site_survey->pptyIE = NULL;
			}
#if defined(CONFIG_RTL_92D_SUPPORT) && defined(CONFIG_RTL_NOISE_CONTROL)
            if (GET_CHIP_VER(priv) == VERSION_8192D){
                if (priv->pshare->DNC_on){
                    phy_set_bb_reg(priv, 0x870, bMaskDWord, 0x07600760);
                }
            }
#endif

#if defined(CONFIG_RTL_92D_SUPPORT)
            if (GET_CHIP_VER(priv) == VERSION_8192D)
                clnt_ss_check_band(priv, priv->pmib->dot11RFEntry.dot11channel); 
#endif

#ifdef WLAN_DIAGNOSTIC
		if (priv->pmib->dot11StationConfigEntry.probe_info_enable == 2 && priv->pmib->dot11StationConfigEntry.probe_info_collecting
			&& priv->pmib->dot11StationConfigEntry.passive_scan == 1) {
			priv->pmib->dot11StationConfigEntry.passive_scan = 0;
			priv->pmib->dot11StationConfigEntry.probe_info_collecting = 0;
			priv->site_survey->target_channel = 0;
			DEBUG_INFO("probeinfo req finish\n");
			RTL_W8(0x608, RTL_R8(0x608)&~RCR_AAP);
		}
		if (priv->pmib->dot11StationConfigEntry.unassoc_sta_scan_ongoing) {
			if(priv->pmib->dot11StationConfigEntry.unassoc_sta_scan_ongoing == 1)
				RTL_W32(RCR,priv->site_survey->RCR_backup);
			priv->pmib->dot11StationConfigEntry.unassoc_sta_scan_ongoing = 0;
			priv->site_survey->target_channel = 0;
			DEBUG_INFO("STA scan req finish\n");
		}
#endif

            DIG_for_site_survey(priv, FALSE);
#ifdef USE_OUT_SRC
			priv->pshare->bScanInProcess = FALSE;
#endif
#if defined(TESTCHIP_SUPPORT) && defined(CONFIG_RTL_92C_SUPPORT)
            if( IS_TEST_CHIP(priv) ) {
                if ((OPMODE & WIFI_STATION_STATE) || (OPMODE & WIFI_ADHOC_STATE)) {
                    #ifdef UNIVERSAL_REPEATER
                    if (IS_ROOT_INTERFACE(priv) && !netif_running(GET_VXD_PRIV(priv)->dev))
                    #endif
                        RTL_W32(RCR, RTL_R32(RCR) | RCR_CBSSID);
                }
            } else
#endif
            {
#if 0
                if (OPMODE & WIFI_STATION_STATE) {
                    #if defined(UNIVERSAL_REPEATER) || defined(RTK_NL80211)	//wrt-adhoc
                    if (IS_ROOT_INTERFACE(priv) && !netif_running(GET_VXD_PRIV(priv)->dev))
                    #endif
                        RTL_W32(RCR, RTL_R32(RCR) | RCR_CBSSID);
                }
                else
#endif
#if defined(CONFIG_OPENWRT_SDK) && defined(UNIVERSAL_REPEATER) //wrt-adhoc
                if (IS_ROOT_INTERFACE(priv) && !netif_running(GET_VXD_PRIV(priv)->dev))
#endif
				{
#ifdef UNIVERSAL_REPEATER
					if ((IS_VXD_INTERFACE(priv)&& !rtk_timer_pending(&GET_ROOT(priv)->ss_timer))
						|| (IS_ROOT_INTERFACE(priv) && !rtk_timer_pending(&GET_VXD_PRIV(priv)->ss_timer)))
#endif
                    {
                            RTL_W8(TXPAUSE, RTL_R8(TXPAUSE) & ~STOP_BCN); 	// Re-enable beacon
                    }
				}

				if (OPMODE & WIFI_ADHOC_STATE)
					RTL_W32(RCR, RTL_R32(RCR) | RCR_CBSSID_ADHOC);

#if defined(CONFIG_RTL_SIMPLE_CONFIG)
				if(priv->pmib->dot11StationConfigEntry.sc_enabled == 0)
#endif
                if(IS_ROOT_INTERFACE(priv) && (OPMODE & WIFI_STATION_STATE))
                    RTL_W32(RCR, RTL_R32(RCR) | RCR_CBSSID_ADHOC);
            }

            #ifdef DFS
            if (!GET_ROOT(priv)->pmib->dot11DFSEntry.disable_DFS &&
                    (rtk_timer_pending(&GET_ROOT(priv)->ch_avail_chk_timer)))
                GET_ROOT(priv)->pmib->dot11DFSEntry.disable_tx = 1;
            else
                GET_ROOT(priv)->pmib->dot11DFSEntry.disable_tx = 0;
            #endif

			if (priv->ss_req_ongoing
#if defined(DFS) && defined (UNIVERSAL_REPEATER)
			&& (IS_ROOT_INTERFACE(priv) ||
			(IS_VXD_INTERFACE(priv) && !GET_ROOT(priv)->pmib->dot11DFSEntry.CAC_ss_counter ))
#endif
			)
			{
				GET_ROOT(priv)->pshare->CurrentChannelBW = GET_ROOT(priv)->pshare->is_40m_bw;
				STADEBUG("RollBack to ROOT's ch[%d] becoz scan done\n",GET_ROOT(priv)->pmib->dot11RFEntry.dot11channel);
#if defined(CONFIG_RTL_SIMPLE_CONFIG)
				if(!rtk_sc_is_channel_fixed(priv))
#endif
				{
					if(priv->pmib->dot11RFEntry.phyBandSelect == PHY_BAND_2G){
					    if ((GET_ROOT(priv)->pmib->dot11RFEntry.dot11channel < 5)
						    && GET_ROOT(priv)->pshare->offset_2nd_chan == HT_2NDCH_OFFSET_BELOW){
		        				GET_ROOT(priv)->pshare->offset_2nd_chan = HT_2NDCH_OFFSET_ABOVE;
					    }
					    else if ((GET_ROOT(priv)->pmib->dot11RFEntry.dot11channel > 9)
						    && (GET_ROOT(priv)->pshare->offset_2nd_chan == HT_2NDCH_OFFSET_ABOVE)){
               					GET_ROOT(priv)->pshare->offset_2nd_chan = HT_2NDCH_OFFSET_BELOW;
					    }
					}

					SwBWMode(GET_ROOT(priv), GET_ROOT(priv)->pshare->CurrentChannelBW, GET_ROOT(priv)->pshare->offset_2nd_chan);
					if (GET_ROOT(priv)->pmib->dot11RFEntry.dot11channel == 0)
						GET_ROOT(priv)->pmib->dot11RFEntry.dot11channel = GET_ROOT(priv)->site_survey->original_channel;
					SwChnl(GET_ROOT(priv), GET_ROOT(priv)->pmib->dot11RFEntry.dot11channel, GET_ROOT(priv)->pshare->offset_2nd_chan);
				}
			}	
            #ifdef UNIVERSAL_REPEATER
			if (IS_VXD_INTERFACE(priv) && priv->pmib->wscEntry.wsc_enable)
				GET_ROOT(priv)->pmib->miscEntry.func_off = GET_ROOT(priv)->func_backup;
            #endif

#if defined(RTK_MULTI_AP) && defined(DOT11K)
			if(priv->multiap_bssSteer_scan
#if (EASYMESH_VERSION >= MULTI_AP_VERSION(2,0,0))
				|| priv->multiap_channel_scan
#endif
			) {
				priv->ss_req_ongoing = SS_INACTIVE;
				/* restore available_chnl */
				restore_avail_chnl(priv);
				//priv->multiap_bssSteer_scan = 0;
#if (EASYMESH_VERSION >= MULTI_AP_VERSION(2,0,0))
				if (priv->multiap_channel_scan) {
					rtk_multi_ap_update_channel_scan_results(priv);
					priv->multiap_channel_scan = 0;
				}
#endif
			}
#endif
#ifdef DOT11K
            if(priv->ss_req_ongoing == SSFROM_11K_BEACONREQ) {
                /* restore available_chnl */
                restore_avail_chnl(priv);
                rm_beacon_done(priv);       
                priv->ss_req_ongoing = SS_INACTIVE;
                SMP_UNLOCK(flags);
                return;
            }
#endif



            #ifdef SUPPORT_MULTI_PROFILE
            if( priv->pmib->ap_profile.sortbyprofile && priv->pmib->ap_profile.enable_profile && priv->pmib->ap_profile.profile_num > 0){

                // sort by profile
                ProfileSort(priv,COMPARE_BSS, priv->site_survey->bss, priv->site_survey->count, sizeof(struct bss_desc));
                #ifdef WIFI_SIMPLE_CONFIG
                ProfileSort(priv,COMPARE_WSCIE, priv->site_survey->wscie, priv->site_survey->count, sizeof(struct wps_ie_info));
                #endif
            }else
            #endif
            {
		// sort by rssi
		qsort(priv->site_survey->bss, priv->site_survey->count, sizeof(struct bss_desc), compareBSS);
		#ifdef WIFI_SIMPLE_CONFIG
		qsort(priv->site_survey->wscie, priv->site_survey->count, sizeof(struct wps_ie_info), compareWpsIE);
		if (priv->pshare->rf_ft_var.prefer_2g) { // prefer 2G
			qsort(priv->site_survey->bss, priv->site_survey->count, sizeof(struct bss_desc), compareBSS_for_2G);
			qsort(priv->site_survey->wscie, priv->site_survey->count, sizeof(struct wps_ie_info), compareWpsIE_for_2G);
		}
		#endif
		#if defined(WIFI_WPAS) || defined(RTK_NL80211)
#if !defined(CONFIG_OPENWRT_SDK)
		qsort(priv->site_survey->rtk_p2p_ie, priv->site_survey->count, sizeof(struct p2p_ie_info), compareP2PIE);
#endif
                #endif
            }

    		debug_print_bss(priv);

#ifdef RTK_NL80211  //nl_clnt
			SMP_UNLOCK(flags);
			NDEBUG2("end of scan,==>realtek_cfg80211_inform_ss_result\n");
			realtek_cfg80211_inform_ss_result(priv);

            /*cfg p2p note:  priv-> ss_req_ongoing be set to 0 in event_indicate_cfg80211()*/
            #ifdef P2P_SUPPORT  /*cfg p2p cfg p2p*/
            if(rtk_p2p_is_enabled(priv)==CFG80211_P2P){
                /*under p2p case , even result count==0 report it*/
		        event_indicate_cfg80211(priv, NULL, CFG80211_SCAN_DONE, NULL);
            }else
            #endif  /*cfg p2p cfg p2p*/
            {
				//if(priv->site_survey->count) always report scan done, maight be SSID not found
					event_indicate_cfg80211(priv, NULL, CFG80211_SCAN_DONE, NULL);
            }

			SMP_LOCK(flags);			
#endif
			if (priv->auto_channel != 1 && priv->pmib->miscEntry.telco_selected == TELCO_CT && IS_ROOT_INTERFACE(priv)) {
				selectClearChannel(priv);
			}
            if (priv->auto_channel == 1) {
				int autoch_donot_DFS_silence = 0;//ACS_ONLY_SS
				int tmp_2nd_offset = 0;
				
                #ifdef SIMPLE_CH_UNI_PROTOCOL
                if(GET_MIB(priv)->dot1180211sInfo.mesh_enable) {
                    get_available_channel(priv);
                }                
                if(!GET_MIB(priv)->dot1180211sInfo.mesh_enable)
                #endif
                {
                    if (priv->ss_req_ongoing == SS_INACTIVE) //do not switch channel when ss
                	{
	                	//ACS_ONLY_SS
	                	if(priv->autoch_only_ss == 1)
						{
							priv->autoch_only_ss_clear_ch = selectClearChannel(priv);						
							priv->autoch_only_ss = 0;
							//backup bw and restore
							tmp_2nd_offset = priv->pshare->offset_2nd_chan;
							priv->pshare->offset_2nd_chan = priv->autoch_only_ss_2ndch_backup;
							priv->autoch_only_ss_clear_2ndch = tmp_2nd_offset;						
							autoch_donot_DFS_silence = 1;
						}
						else
						{
    				    	priv->pmib->dot11RFEntry.dot11channel = selectClearChannel(priv);
#ifdef CTC_2G_ACS
							if (priv->pmib->miscEntry.autoch_score_timeout_default)
								atomic_set(&(priv->pshare->autoch_score_timeout), priv->pmib->miscEntry.autoch_score_timeout_default);
#endif
#ifdef RTK_MULTI_AP
							if(priv->pmib->multi_ap.multiap_bss_type)
							{
								rtk_multi_ap_channel_change_notify();
							}
#endif
						}
                	}
                	else
                	{
                		selectClearChannel(priv);
#ifdef CTC_2G_ACS
                		atomic_set(&(priv->pshare->autoch_score_timeout), 0);
#endif
                	}
                    #ifdef P2P_SUPPORT/*cfg p2p cfg p2p*/
                    if(rtk_p2p_is_enabled(priv)==PROPERTY_P2P){
                        P2P_DEBUG("auto channel select to[%d],ch changed call rtk_p2p_init again\n\n",priv->pmib->dot11RFEntry.dot11channel);
                        rtk_p2p_init(priv);
                    }
                    #endif/*cfg p2p cfg p2p*/
    				DEBUG_INFO("auto channel select ch %d\n", priv->pmib->dot11RFEntry.dot11channel);
                    #if defined(CONFIG_RTL8196B_TR) || defined(CONFIG_RTL8196C_EC)
    				LOG_START_MSG();
                    #endif
                    #if defined(CONFIG_RTL865X_AC) || defined(CONFIG_RTL865X_KLD) || defined(CONFIG_RTL8196B_KLD) || defined(CONFIG_RTL8196C_KLD)
    				LOG_START_MSG();
                    #endif
                }
#ifdef DFS
		   if (priv->ss_req_ongoing == SS_INACTIVE)
		   {
                #if defined(UNIVERSAL_REPEATER) || defined(MBSSID)
				if (IS_ROOT_INTERFACE(priv))
                #endif
				{
					if(!priv->pmib->dot11DFSEntry.disable_DFS
					&& is_DFS_channel(priv, priv->pmib->dot11RFEntry.dot11channel) && (OPMODE & WIFI_AP_STATE)
					&& (autoch_donot_DFS_silence==0)) {//ACS_ONLY_SS
						if (rtk_timer_pending(&priv->DFS_timer))
							rtk_del_timer(&priv->DFS_timer);

						if (rtk_timer_pending(&priv->ch_avail_chk_timer))
							rtk_del_timer(&priv->ch_avail_chk_timer);

						if (rtk_timer_pending(&priv->dfs_det_chk_timer))
							rtk_del_timer(&priv->dfs_det_chk_timer);

						if (is_DFS_channel(priv, priv->pmib->dot11RFEntry.dot11channel)) {
							/* Init priv->ch_avail_chk_timer */
							init_ch_avail_chk_timer(priv, IGNORE_DRIVER_STATUS);

							if ((priv->pmib->dot11StationConfigEntry.dot11RegDomain == DOMAIN_ETSI) &&
								(IS_METEOROLOGY_CHANNEL(priv->pmib->dot11RFEntry.dot11channel)))
								rtk_mod_timer(&priv->ch_avail_chk_timer, jiffies + CH_AVAIL_CHK_TO_CE);
							else
								rtk_mod_timer(&priv->ch_avail_chk_timer, jiffies + CH_AVAIL_CHK_TO);

							/* Init priv->DFS_timer */
							init_DFS_timer(priv, IGNORE_DRIVER_STATUS);

							/* DFS activated after 5 sec; prevent switching channel due to DFS false alarm */
							rtk_mod_timer(&priv->DFS_timer, jiffies + RTL_SECONDS_TO_JIFFIES(5));

							/* Init priv->dfs_det_chk_timer */
							init_dfs_det_chk_timer(priv, IGNORE_DRIVER_STATUS);

							rtk_mod_timer(&priv->dfs_det_chk_timer, jiffies + RTL_MILISECONDS_TO_JIFFIES(priv->pshare->rf_ft_var.dfs_det_period*10));

							DFS_SetReg(priv);

							if (!priv->pmib->dot11DFSEntry.CAC_enable) {
								rtk_del_timer_sync(&priv->ch_avail_chk_timer);
								rtk_mod_timer(&priv->ch_avail_chk_timer, jiffies + RTL_MILISECONDS_TO_JIFFIES(200));
							}
				 		}
				 	}

					/* disable all of the transmissions during channel availability check */
					priv->pmib->dot11DFSEntry.disable_tx = 0;
					if (!priv->pmib->dot11DFSEntry.disable_DFS &&
					is_DFS_channel(priv, priv->pmib->dot11RFEntry.dot11channel) && (OPMODE & WIFI_AP_STATE)){
						if (autoch_donot_DFS_silence)
						{
							if (rtk_timer_pending(&priv->ch_avail_chk_timer))
								priv->pmib->dot11DFSEntry.disable_tx = 1;
						}
						else
							priv->pmib->dot11DFSEntry.disable_tx = 1;
					}
				}
		   }
#endif /* DFS */

				if (OPMODE & WIFI_AP_STATE)
					priv->auto_channel = 0;
				else
					priv->auto_channel = 2;

				priv->pshare->CurrentChannelBW = priv->pshare->is_40m_bw;
				if (priv->ss_req_ongoing == SS_INACTIVE) {
#if defined(CONFIG_RTL_SIMPLE_CONFIG)
				if(!rtk_sc_is_channel_fixed(priv))
#endif
				{
					SwBWMode(priv, priv->pshare->CurrentChannelBW, priv->pshare->offset_2nd_chan);
					SwChnl(priv, priv->pmib->dot11RFEntry.dot11channel, priv->pshare->offset_2nd_chan);
#ifdef GENERAL_EVENT
					unsigned char tmpbuf[2];
					tmpbuf[0] = priv->pmib->dot11RFEntry.dot11channel;
					tmpbuf[1] = 1;//ACS
					general_IndicateEvent(priv, DOT11_EVENT_CHANNEL_CHANGE, tmpbuf);
#endif
				}

#ifdef AUTO_CHANNEL_TIMEOUT
				if (priv->pmib->miscEntry.autoch_timeout && priv->pshare->autoch_trigger_by_timeout)
				{
					// Update channel.
					unsigned char *pbuf = (unsigned char *)priv->beaconbuf + priv->timoffset - 3;
				
					if (*pbuf == _DSSET_IE_&& *(pbuf+1) == 1) {
						*(pbuf + 2) = priv->pmib->dot11RFEntry.dot11channel;
					}
					priv->ht_cap_len = 0;
#ifdef MBSSID
					if (GET_ROOT(priv)->pmib->miscEntry.vap_enable) {
						for (i=0; i<RTL8192CD_NUM_VWLAN; i++) {
							priv->pvap_priv[i]->pmib->dot11RFEntry.dot11channel = priv->pmib->dot11RFEntry.dot11channel;
							priv->pvap_priv[i]->ht_cap_len = 0; // re-construct HT IE

							if (IS_DRV_OPEN(priv->pvap_priv[i])) {
								pbuf = (unsigned char *)priv->pvap_priv[i]->beaconbuf + priv->timoffset - 3;
								if (*pbuf == _DSSET_IE_&& *(pbuf+1) == 1) {
									*(pbuf + 2) = priv->pmib->dot11RFEntry.dot11channel;
								}									
							}								
						}
					}				
#endif
					priv->pshare->autoch_trigger_by_timeout = 0;
					printk("===> complete select channel curr = %d, 2ch = %d\n",
						priv->pmib->dot11RFEntry.dot11channel, priv->pshare->offset_2nd_chan);
				}
				else
#endif
				{
					priv->ht_cap_len = 0;	// re-construct HT IE
					init_beacon(priv);
#ifdef SIMPLE_CH_UNI_PROTOCOL
					STADEBUG("scan finish, sw ch to (#%d), init beacon\n", priv->pmib->dot11RFEntry.dot11channel);
#endif
#ifdef MBSSID
					if (GET_ROOT(priv)->pmib->miscEntry.vap_enable) {
						for (i=0; i<RTL8192CD_NUM_VWLAN; i++) {
							priv->pvap_priv[i]->pmib->dot11RFEntry.dot11channel = priv->pmib->dot11RFEntry.dot11channel;
							priv->pvap_priv[i]->ht_cap_len = 0;	// re-construct HT IE

							if (IS_DRV_OPEN(priv->pvap_priv[i]))
								init_beacon(priv->pvap_priv[i]);
						}
					}
#endif
				}
                }
#ifdef CLIENT_MODE
#ifdef HS2_CLIENT_TEST
				JOIN_RES = STATE_Sta_Ibss_Idle;
#else
				if (JOIN_RES == STATE_Sta_Ibss_Idle) {
					RTL_W32(CR, (RTL_R32(CR) & ~(NETYPE_Mask << NETYPE_SHIFT)) | ((NETYPE_ADHOC & NETYPE_Mask) << NETYPE_SHIFT));
					rtk_mod_timer(&priv->idle_timer, jiffies + RTL_SECONDS_TO_JIFFIES(5));
				}
#endif
#endif



				if (priv->ss_req_ongoing) {
					priv->site_survey->count_backup = priv->site_survey->count;
					memcpy(priv->site_survey->bss_backup, priv->site_survey->bss, sizeof(struct bss_desc)*priv->site_survey->count);
					priv->ss_req_ongoing = SS_INACTIVE;
				}

#if defined(CONFIG_RTL_NEW_AUTOCH) && defined(SS_CH_LOAD_PROC)
				record_SS_report(priv);
#endif

			}
			// backup the bss database
#ifdef WIFI_WPAS_CLI
			else if (SSFROM_WPAS == priv->ss_req_ongoing) {
				printk("cliW: scan ind to => sp:%d ss:%d\n", 
					priv->pshare->bScanInProcess, priv->ss_req_ongoing);

				/* report scan list to wpa_supplicant using ap scan */  
				GET_VXD_PRIV(priv)->site_survey->count_backup = priv->site_survey->count;
				memcpy(GET_VXD_PRIV(priv)->site_survey->bss_backup, priv->site_survey->bss, 
					sizeof(struct bss_desc)*priv->site_survey->count);
#ifdef WIFI_SIMPLE_CONFIG
				memcpy(GET_VXD_PRIV(priv)->site_survey->wscie, priv->site_survey->wscie,
					sizeof(struct wps_ie_info)*priv->site_survey->count);
#endif
				GET_VXD_PRIV(priv)->ss_req_ongoing = SS_INACTIVE;
				priv->ss_req_ongoing = SS_INACTIVE;
				printk("cliW: scan done 4 ss_req_ongoing = 0\n");
				event_indicate_wpas(GET_VXD_PRIV(priv), NULL, WPAS_SCAN_DONE, NULL);
			}
#endif // WIFI_WPAS_CLI
			else if (priv->ss_req_ongoing) {
#ifdef P2P_SUPPORT
                /*cfg p2p cfg p2p*/
                if((rtk_p2p_is_enabled(priv)==PROPERTY_P2P)
                    && P2P_DISCOVERY){
                    //for keep  priv->site_survey->count_backup when P2P discovery
                }
                else
#endif
				{
					priv->site_survey->count_backup = priv->site_survey->count;
					memcpy(priv->site_survey->bss_backup, priv->site_survey->bss, sizeof(struct bss_desc)*priv->site_survey->count);
				}				

/*cfg p2p;remove*/
/*cfg p2p;remove*/
#ifdef CLIENT_MODE
                #ifdef P2P_SUPPORT/*cfg p2p cfg p2p*/
                if(rtk_p2p_is_enabled(priv)&& P2P_DISCOVERY){
                    /*P2P discovery duration no need start_clnt_lookup*/
                }else
                #endif/*cfg p2p cfg p2p*/
#if 0 //defined(RTK_NL80211)
				if(priv->ss_req_ongoing != SSFROM_WSC)
#else
				if(priv->ss_req_ongoing != SSFROM_WSC && priv->ss_req_ongoing != SSFROM_REPEATER_VXD)
#endif
				{
				#ifndef CONFIG_RTL_MULTI_WIFI_MODULES
    				if (JOIN_RES == STATE_Sta_Ibss_Idle) {
                        STADEBUG("start_clnt_lookup(RESCAN)\n");    
    					start_clnt_lookup(priv, RESCAN);
    				}
    				else if (JOIN_RES == STATE_Sta_Auth_Success){
    					start_clnt_assoc(priv);
    				}
    				else if (JOIN_RES == STATE_Sta_Roaming_Scan) {
                        STADEBUG("start_clnt_lookup(RESCAN)\n");    
    					start_clnt_lookup(priv, RESCAN);
    				}
    				else if(JOIN_RES == STATE_Sta_No_Bss) {
                        STADEBUG("start_clnt_lookup(RESCAN)\n");    
    					JOIN_RES_VAL(STATE_Sta_Roaming_Scan);
    					start_clnt_lookup(priv, RESCAN);
    				}
				#endif
				}
#endif

#ifdef SMART_REPEATER_MODE
				if (priv->ss_req_ongoing == SSFROM_REPEATER_VXD) {
					// VXD Interface
#ifdef SUPPORT_MULTI_PROFILE
					if (GET_MIB(priv)->ap_profile.enable_profile &&
							GET_MIB(priv)->ap_profile.profile_num > 0) {
						SSID2SCAN_LEN = strlen(GET_MIB(priv)->ap_profile.profile[priv->profile_idx].ssid);
						memcpy(SSID2SCAN, GET_MIB(priv)->ap_profile.profile[priv->profile_idx].ssid, SSID2SCAN_LEN);					
					}
					else
#endif			
					{					
						SSID2SCAN_LEN = GET_MIB(priv)->dot11StationConfigEntry.dot11SSIDtoScanLen;
						memcpy(SSID2SCAN, GET_MIB(priv)->dot11StationConfigEntry.dot11SSIDtoScan, SSID2SCAN_LEN);
					}
					priv->site_survey->count_target = priv->site_survey->count;
					memcpy(priv->site_survey->bss_target, priv->site_survey->bss, sizeof(struct bss_desc)*priv->site_survey->count);					
					priv->join_index = -1;
					priv->join_res = STATE_Sta_Min; 
#if !defined(CONFIG_RTL_MULTI_WIFI_MODULES)
					start_clnt_lookup(priv, DONTRESCAN);
#endif
#if !defined(RTK_NL80211)
					STADEBUG("call set_vxd_rescan\n");
					if(priv->join_res == STATE_Sta_Min)
						set_vxd_rescan(priv,RESCAN_BY_NEXTTIME);
#endif
				}
#endif			

				priv->ss_req_ongoing = SS_INACTIVE;
                //STADEBUG("set priv->ss_req_ongoing to 0\n\n\n");				

#ifdef WIFI_WPAS
				event_indicate_wpas(priv, NULL, WPAS_SCAN_DONE, NULL);
#endif

#if defined(CONFIG_RTL_MULTI_WIFI_MODULES) && defined(CLIENT_MODE)
				if (IS_ROOT_INTERFACE(priv) && (OPMODE & WIFI_STATION_STATE)) {
					priv->site_survey->count_target = priv->site_survey->count;
					memcpy(priv->site_survey->bss_target, priv->site_survey->bss, sizeof(struct bss_desc)*priv->site_survey->count);					
					priv->join_index = -1;
				}
#endif

			}
#ifdef CLIENT_MODE
			else if (OPMODE & (WIFI_STATION_STATE | WIFI_ADHOC_STATE)) {
				priv->site_survey->count_target = priv->site_survey->count;
				memcpy(priv->site_survey->bss_target, priv->site_survey->bss, sizeof(struct bss_desc)*priv->site_survey->count);
				priv->join_index = -1;
#ifdef HS2_CLIENT_TEST
#else
                #ifdef P2P_SUPPORT/*cfg p2p cfg p2p*/
                if(rtk_p2p_is_enabled(priv)&& P2P_DISCOVERY){
                    /*P2P discovery duration no need start_clnt_lookup*/
                }else
                #endif  /*cfg p2p cfg p2p*/              
				if (JOIN_RES == STATE_Sta_Roaming_Scan){
                    STADEBUG("start_clnt_lookup(DONTRESCAN)\n");
					start_clnt_lookup(priv, DONTRESCAN);
                }

#endif
			}
#endif
			else {
				DEBUG_ERR("Faulty scanning\n");
			}
			
#ifdef CONFIG_RTL_COMAPI_WLTOOLS
            wake_up_interruptible(&priv->ss_wait);
#endif

#ifdef CHECK_BEACON_HANGUP
			if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE) {
            	priv->pshare->beacon_wait_cnt = 2;
			}
#endif
#ifdef CONFIG_RTL8672
            OPMODE_VAL(OPMODE & (~WIFI_WAIT_FOR_CHANNEL_SELECT));
#endif
            SMP_UNLOCK(flags);
            /*cfg p2p cfg p2p*/
            #ifdef P2P_SUPPORT
            if((rtk_p2p_is_enabled(priv))==PROPERTY_P2P
                    && P2P_DISCOVERY){
                P2P_DEBUG("Scan end\n");
                /* execute p2p_find_timer() */
                rtk_mod_timer(&priv->p2pPtr->p2p_find_timer_t, jiffies + RTL_MILISECONDS_TO_JIFFIES(100));
            }
            #endif
            NDEBUG2("endofscan\n");
            /*cfg p2p cfg p2p*/
#ifdef SDIO_AP_OFFLOAD
			ap_offload_activate(priv, OFFLOAD_PROHIBIT_SITE_SURVEY);
#endif
#ifdef RTK_MESH_SIMPLE_CSA
			if(priv->mesh_CSA_state == MESH_CSA_TRIGGER) {
				int swchnl = selectClearChannel(priv);
				if(GET_MIB(priv)->dot1180211sInfo.mesh_enable) {
					if(swchnl == priv->pmib->dot11RFEntry.dot11channel) {
						priv->mesh_CSA_state = MESH_CSA_IGNORE;
					} else {
						/* _MESH_CHANNEL_SWITCH_IE_ */
						priv->mesh_swchnl_ttl = _MESH_HEADER_TTL_;
						priv->mesh_swchnl_flag = (BIT1|BIT2);/*BIT1: initiator, BIT2: reason valid*/
						priv->mesh_swchnl_reason = _RSON_MESH_CHANNEL_SWITCH_REGULATORY_REQUIREMENTS_;
						SET_PSEUDO_RANDOM_NUMBER(priv->mesh_swchnl_precedence);
						/* _SECONDARY_CHANNEL_OFFSET_IE_ */
						priv->mesh_swchnl_offset = priv->pshare->offset_2nd_chan;
						/* _CSA_IE_ */
						priv->mesh_CSA_mode = priv->pshare->is_40m_bw | RTK_MESH_CSA_MODE;
						priv->mesh_CSA_channel = swchnl;
						/* Change CSA status */
						priv->mesh_CSA_state = MESH_CSA_READY;
					}
				}
				else if(priv->bss11v_priv_sc && GET_MIB(priv->bss11v_priv_sc)->dot1180211sInfo.mesh_enable) {
					/* _MESH_CHANNEL_SWITCH_IE_ */
					priv->mesh_swchnl_ttl = _MESH_HEADER_TTL_;
					priv->mesh_swchnl_flag = (BIT1|BIT2);/*BIT1: initiator, BIT2: reason valid*/
					priv->mesh_swchnl_reason = _RSON_MESH_CHANNEL_SWITCH_REGULATORY_REQUIREMENTS_;
					SET_PSEUDO_RANDOM_NUMBER(priv->mesh_swchnl_precedence);
					/* _SECONDARY_CHANNEL_OFFSET_IE_ */
					priv->mesh_swchnl_offset = priv->pshare->offset_2nd_chan;
					/* _CSA_IE_ */
					priv->mesh_CSA_mode = priv->pshare->is_40m_bw | RTK_MESH_CSA_MODE;
					priv->mesh_CSA_channel = swchnl;
					/* Change CSA status */
					priv->mesh_CSA_state = MESH_CSA_READY;

					/* _MESH_CHANNEL_SWITCH_IE_ */
					priv->bss11v_priv_sc->mesh_swchnl_ttl = _MESH_HEADER_TTL_;
					priv->bss11v_priv_sc->mesh_swchnl_flag = (BIT1|BIT2);/*BIT1: initiator, BIT2: reason valid*/
					priv->bss11v_priv_sc->mesh_swchnl_reason = _RSON_MESH_CHANNEL_SWITCH_REGULATORY_REQUIREMENTS_;
					SET_PSEUDO_RANDOM_NUMBER(priv->bss11v_priv_sc->mesh_swchnl_precedence);
					/* _SECONDARY_CHANNEL_OFFSET_IE_ */
					priv->bss11v_priv_sc->mesh_swchnl_offset = priv->pshare->offset_2nd_chan;
					/* _CSA_IE_ */
					priv->bss11v_priv_sc->mesh_CSA_mode = priv->pshare->is_40m_bw | RTK_MESH_CSA_MODE | RTK_MESH_CSA_CROSSBAND;
					priv->bss11v_priv_sc->mesh_CSA_channel = swchnl;
					/* Change CSA status */
					priv->bss11v_priv_sc->mesh_CSA_state = MESH_CSA_CROSSBAND_READY;
				}
				else {
					priv->mesh_CSA_state = MESH_CSA_NONE;
				}
			}
#endif
            return;
        }
    }//loop_finish



   /*switch channel; now, change RF channel... start*/

    #ifdef CONFIG_RTL_92D_SUPPORT
    int band_switch = 0;
    #endif
	
	// now, change RF channel...
    #ifdef DFS
    if (!priv->pmib->dot11DFSEntry.disable_DFS && is_DFS_channel(priv, priv->site_survey->ss_channel)){
        priv->pmib->dot11DFSEntry.disable_tx = 1;
    }else{
        priv->pmib->dot11DFSEntry.disable_tx = 0;
    }
    #endif

    #if defined(CONFIG_RTL_92D_SUPPORT) && !defined(CONFIG_RTL_DUAL_PCIESLOT_BIWLAN_D)
    if ((GET_CHIP_VER(priv) == VERSION_8192D) && priv->pmib->dot11RFEntry.macPhyMode==SINGLEMAC_SINGLEPHY) {
        band_switch = clnt_ss_check_band(priv, priv->site_survey->ss_channel);		
    }
    #endif

    #ifdef CONFIG_RTL_NEW_AUTOCH
    if (priv->site_survey->to_scan_40M) {
        #if defined(RTK_5G_SUPPORT) 
        if (GET_ROOT(priv)->pmib->dot11RFEntry.phyBandSelect & PHY_BAND_5G) {
        	
			if (!is_DFS_channel(priv, priv->site_survey->ss_channel))
				RTL_W8(TXPAUSE, RTL_R8(TXPAUSE) & ~STOP_BCN);
			else
				RTL_W8(TXPAUSE, RTL_R8(TXPAUSE) | STOP_BCN);
				
            if((priv->site_survey->ss_channel>144) ? ((priv->site_survey->ss_channel-1)%8) : (priv->site_survey->ss_channel%8)) {
                //STADEBUG("SwChnl=%d,2ndoffsetCh=%d\n",priv->site_survey->ss_channel,HT_2NDCH_OFFSET_ABOVE);
                #if defined(CONFIG_RTL_SIMPLE_CONFIG)
                if(!rtk_sc_is_channel_fixed(priv))
                #endif
                {
                    SwChnl(GET_ROOT(priv), priv->site_survey->ss_channel, HT_2NDCH_OFFSET_ABOVE);
                    SwBWMode(GET_ROOT(priv), priv->pshare->CurrentChannelBW, HT_2NDCH_OFFSET_ABOVE);
                }
            } else {
                //STADEBUG("SwChnl=%d,2ndoffsetCh=%d\n",priv->site_survey->ss_channel,HT_2NDCH_OFFSET_BELOW);
                #if defined(CONFIG_RTL_SIMPLE_CONFIG)
                if(!rtk_sc_is_channel_fixed(priv))
                #endif
                {
                    SwChnl(GET_ROOT(priv), priv->site_survey->ss_channel, HT_2NDCH_OFFSET_BELOW);
                    SwBWMode(GET_ROOT(priv), priv->pshare->CurrentChannelBW, HT_2NDCH_OFFSET_BELOW);
                }
            }
        } else
        #endif
        {
            /* set channel >= 5 for algo requirement */
            //STADEBUG("SwChnl=%d,2ndoffsetCh=%d\n",priv->site_survey->ss_channel,HT_2NDCH_OFFSET_BELOW);
            #if defined(CONFIG_RTL_SIMPLE_CONFIG)
            if(!rtk_sc_is_channel_fixed(priv))
            #endif
            {
                SwChnl(GET_ROOT(priv), priv->site_survey->ss_channel, HT_2NDCH_OFFSET_BELOW);
                SwBWMode(GET_ROOT(priv), priv->pshare->CurrentChannelBW, HT_2NDCH_OFFSET_BELOW);
            }
        }
    }
    else
    #endif
    {
#if defined(UNIVERSAL_REPEATER) && defined(SMART_REPEATER_MODE)
        #if defined(CONFIG_RTL_SIMPLE_CONFIG)
        if(rtk_sc_during_simple_config_scan(priv)){

            int max_bw = CHANNEL_WIDTH_20;
            int sc_scan_offset = HT_2NDCH_OFFSET_DONTCARE;

            //panic_printk("%s %d (idx=%d, channel=%d)+++\n", __FUNCTION__, __LINE__, idx, priv->available_chnl[idx]);
            if(((priv->pmib->dot11StationConfigEntry.sc_config_type&0x2) == 0x2) && (priv->pmib->dot11RFEntry.dot11channel<14))
            {
                if(priv->pmib->dot11BssType.net_work_type & WIRELESS_11N)
                    max_bw = CHANNEL_WIDTH_40;

            if(priv->pmib->dot11BssType.net_work_type & WIRELESS_11AC)
                max_bw = CHANNEL_WIDTH_80;

            if(max_bw != CHANNEL_WIDTH_20){
                sc_scan_offset = rtk_sc_get_scan_offset(GET_ROOT(priv), priv->site_survey->ss_channel, max_bw); 
            }

                GET_ROOT(priv)->pshare->offset_2nd_chan = sc_scan_offset;
                GET_ROOT(priv)->pshare->CurrentChannelBW = max_bw;
            }
            priv->pshare->offset_2nd_chan = sc_scan_offset;
            priv->pshare->CurrentChannelBW = max_bw;

            if(!rtk_sc_is_channel_fixed(priv)) {
                SwBWMode(GET_ROOT(priv), max_bw, sc_scan_offset);
                SwChnl(GET_ROOT(priv), priv->site_survey->ss_channel, sc_scan_offset);
            }

            if( (priv->site_survey->ss_channel >= 5) && (priv->site_survey->ss_channel <= 9)
            && (priv->pshare->offset_2nd_chan  == HT_2NDCH_OFFSET_BELOW) && (idx >= 0))
            priv->site_survey->ss_channel = priv->available_chnl[(idx)];


        }
        else
        #endif
#if defined(DFS) && defined (UNIVERSAL_REPEATER)
		if(IS_ROOT_INTERFACE(priv) ||
		(IS_VXD_INTERFACE(priv) && !GET_ROOT(priv)->pmib->dot11DFSEntry.CAC_ss_counter))
#endif
		{
	        if(priv->site_survey->defered_ss) {
	            //STADEBUG("Between B53&B56, stay AP's ch for %d miliseconds\n",priv->pmib->miscEntry.ss_delay);
	            //STADEBUG("SwChnl[%d],2ndCh[%d]\n",GET_ROOT(priv)->pmib->dot11RFEntry.dot11channel,GET_ROOT(priv)->pshare->offset_2nd_chan);                
	            #if defined(CONFIG_RTL_SIMPLE_CONFIG)
	            if(!rtk_sc_is_channel_fixed(priv))
	            #endif
	            {
				if (!is_DFS_channel(GET_ROOT(priv), GET_ROOT(priv)->pmib->dot11RFEntry.dot11channel))
					RTL_W8(TXPAUSE, RTL_R8(TXPAUSE)&~STOP_BCN);
				else
					RTL_W8(TXPAUSE, RTL_R8(TXPAUSE) | STOP_BCN);
	                SwBWMode(GET_ROOT(priv), GET_ROOT(priv)->pshare->CurrentChannelBW, GET_ROOT(priv)->pshare->offset_2nd_chan);
	                SwChnl(GET_ROOT(priv), GET_ROOT(priv)->pmib->dot11RFEntry.dot11channel, GET_ROOT(priv)->pshare->offset_2nd_chan);
	            }
	            priv->pmib->dot11DFSEntry.disable_tx = 0;

	        } else 
#endif
	        {	            
#if defined(CONFIG_RTL_SIMPLE_CONFIG)
	            if(!rtk_sc_is_channel_fixed(priv))
#endif
				{
					if (!is_DFS_channel(priv, priv->site_survey->ss_channel))
						RTL_W8(TXPAUSE, RTL_R8(TXPAUSE)&~STOP_BCN);
					else
						RTL_W8(TXPAUSE, RTL_R8(TXPAUSE) | STOP_BCN);
				}				
				SwChnl(GET_ROOT(priv), priv->site_survey->ss_channel, priv->pshare->offset_2nd_chan);

	            #ifdef CONFIG_RTL_NEW_AUTOCH
	            if (priv->auto_channel == 1) {
	                reset_fa_reg(priv);

					//if (priv->pmib->dot11RFEntry.acs_type && acs->step) {
					//	nhm_trigger(priv);
	                //}
	            }
	            #endif
	        }
#if defined(UNIVERSAL_REPEATER) && defined(SMART_REPEATER_MODE)
	    }    
#endif		
	}    

	channel_loading_measurement(priv, CLM_SAMPLE_NUM2);
	/*switch channel-end*/
#if defined(RTK_NL80211) || defined(CH_LOAD_CAL) || defined(USE_OUT_SRC)
	//by brian, trigger channel load evaluation after channel switched
	if (IS_OUTSRC_CHIP(priv)) {
		ss_trigger_clm_nhm(priv, (priv->ss_req_ongoing == SS_INACTIVE), acs->step);
	} else
		start_bbp_ch_load(priv, (45*1000)/4);
#endif

    /*TX probe_request -- start*/

#ifdef DOT11K
   if(priv->ss_req_ongoing == SSFROM_11K_BEACONREQ)
   {   
       priv->rm.measure_time_lo =  RTL_R32(TSFTR);
       priv->rm.measure_time_hi =  RTL_R32(TSFTR + 4);
   }
#endif

    if (priv->site_survey->hidden_ap_found == HIDE_AP_FOUND_DO_ACTIVE_SSAN ||
        !is_passive_channel(priv , priv->pmib->dot11StationConfigEntry.dot11RegDomain, priv->site_survey->ss_channel))            
    {               

        #ifdef DOT11K
        if(priv->ss_req_ongoing == SSFROM_11K_BEACONREQ)
        {   
            if(priv->rm.beacon_req.mode == BEACON_MODE_ACTIVE)
            {
                if (priv->ss_ssidlen == 0)
                    issue_probereq(priv, NULL, 0, NULL);
                else
                    issue_probereq(priv, priv->ss_ssid, priv->ss_ssidlen, NULL);
            }
        }
        else
        #endif //DOT11K
        #ifdef SIMPLE_CH_UNI_PROTOCOL
        if(GET_MIB(priv)->dot1180211sInfo.mesh_enable)
            issue_probereq_MP(priv, "MESH-SCAN", 9, NULL, TRUE);
        else
        #endif				
        if (priv->ss_ssidlen == 0){

            #ifdef P2P_SUPPORT
            /*cfg p2p cfg p2p*/
            if( rtk_p2p_is_enabled(priv)&&                     /*PROPERTY_P2P case run this way*/
                ((rtk_p2p_chk_role(priv,P2P_DEVICE))||(rtk_p2p_chk_role(priv,P2P_CLIENT))) ){
                P2P_DEBUG("p2p scan (chann:%d)\n",priv->site_survey->ss_channel);							
                issue_probereq(priv, "DIRECT-", 7, NULL);
            }/*cfg p2p cfg p2p*/
            else
            #endif					
            {
                if (!acs->step) {
                    issue_probereq(priv, NULL, 0, NULL);
                }
            }
        }else{
            #ifdef SUPPORT_MULTI_PROFILE	/*send multi probe_req by profile_num*/	
            if (priv->pmib->ap_profile.enable_profile && priv->pmib->ap_profile.profile_num > 0) {
                for(jdx=0;jdx<priv->pmib->ap_profile.profile_num;jdx++) {									
                    STADEBUG("issue_probereq[%s],ch=[%d]\n",priv->pmib->ap_profile.profile[jdx].ssid , priv->site_survey->ss_channel);
                    issue_probereq(priv, priv->pmib->ap_profile.profile[jdx].ssid, strlen(priv->pmib->ap_profile.profile[jdx].ssid), NULL);
                }												
            }
            else	
            #endif								
            {
                STADEBUG("issue_probereq,ssid[%s],ch[%d]\n",priv->ss_ssid,priv->site_survey->ss_channel);
                issue_probereq(priv, priv->ss_ssid, priv->ss_ssidlen, NULL);
            }

        }
    }

    /*TX probe_request -- End*/
    SMP_UNLOCK(flags);

	/*now, scheduling next ss_timer ; the time util to next timer executed is how long DUT stady in this channel*/
	// now, start another timer again.

    #ifdef DOT11K
    if(priv->ss_req_ongoing == SSFROM_11K_BEACONREQ)
    {
        rtk_mod_timer(&priv->ss_timer, jiffies + RTL_MILISECONDS_TO_JIFFIES(priv->rm.beacon_req.measure_duration));
    }
    else
    #endif
    if(is_passive_channel(priv , priv->pmib->dot11StationConfigEntry.dot11RegDomain, priv->site_survey->ss_channel))
    {
        #if defined(UNIVERSAL_REPEATER) && defined(SMART_REPEATER_MODE)
        if(priv->site_survey->defered_ss) {
            if(priv->pmib->miscEntry.ss_delay) {
                rtk_mod_timer(&priv->ss_timer, jiffies + RTL_MILISECONDS_TO_JIFFIES(priv->pmib->miscEntry.ss_delay));
            } else {
                if(priv->pmib->miscEntry.passive_ss_int) {
                    rtk_mod_timer(&priv->ss_timer, jiffies + RTL_MILISECONDS_TO_JIFFIES(priv->pmib->miscEntry.passive_ss_int));
                } else {
                    rtk_mod_timer(&priv->ss_timer, jiffies + SS_PSSV_TO);
                }
            }
        }
        else {
            if(priv->pmib->miscEntry.passive_ss_int) {
                rtk_mod_timer(&priv->ss_timer, jiffies + RTL_MILISECONDS_TO_JIFFIES(priv->pmib->miscEntry.passive_ss_int));
            } else {
                rtk_mod_timer(&priv->ss_timer, jiffies + SS_PSSV_TO);
            }
        }

        #else
        if(priv->pmib->miscEntry.passive_ss_int) {
            rtk_mod_timer(&priv->ss_timer, jiffies + RTL_MILISECONDS_TO_JIFFIES(priv->pmib->miscEntry.passive_ss_int));
        } else {
            rtk_mod_timer(&priv->ss_timer, jiffies + SS_PSSV_TO);
        }
        #endif

    }
    else
    {
        #ifdef CONFIG_RTL_NEW_AUTOCH
        if (priv->auto_channel == 1){
            #ifdef AUTOCH_SS_SPEEDUP
            if(priv->pmib->miscEntry.autoch_ss_to != 0)
                rtk_mod_timer(&priv->ss_timer, jiffies + RTL_MILISECONDS_TO_JIFFIES(priv->pmib->miscEntry.autoch_ss_to));
            else
            #endif
            if (acs->step) {
#ifdef CTC_2G_ACS
				if (priv->pmib->dot11RFEntry.phyBandSelect == PHY_BAND_2G)
					rtk_mod_timer(&priv->ss_timer, jiffies + SS_AUTO_CHNL_NHM_TO_2G);
				else
					rtk_mod_timer(&priv->ss_timer, jiffies + SS_AUTO_CHNL_NHM_TO_5G);
#else
				rtk_mod_timer(&priv->ss_timer, jiffies + SS_AUTO_CHNL_NHM_TO);
#endif /* CTC_2G_ACS */
			} else
                rtk_mod_timer(&priv->ss_timer, jiffies + SS_AUTO_CHNL_TO);
        }else
        #endif
        {
            #ifdef P2P_SUPPORT	// 2013
            /*cfg p2p cfg p2p*/
            if(rtk_p2p_is_enabled(priv)&& (rtk_p2p_chk_role(priv,P2P_DEVICE) || rtk_p2p_chk_role(priv,P2P_CLIENT))){
                /*search phase (only 1,6,11) use 120ms*/
                //P2P_DEBUG("[%d]ms\n",P2P_SEARCH_TIME_V);
                rtk_mod_timer(&priv->ss_timer, jiffies + P2P_SEARCH_TIME);
            }else
            #endif
#ifdef WLAN_DIAGNOSTIC
		if (priv->pmib->dot11StationConfigEntry.probe_info_enable == 2 &&
			priv->pmib->dot11StationConfigEntry.passive_scan &&
			priv->pmib->dot11StationConfigEntry.scan_interval)
			rtk_mod_timer(&priv->ss_timer, jiffies + RTL_MILISECONDS_TO_JIFFIES(priv->pmib->dot11StationConfigEntry.scan_interval));
	else
#endif
            {
#ifdef RTK_MULTI_AP
		if(priv->ss_req_ongoing  == SSFROM_PASSIVE) {
			rtk_mod_timer(&priv->ss_timer, jiffies + SS_MAP_TO);
		}
		else
#endif
	#if defined(CONFIG_RTL_SIMPLE_CONFIG)
		if (get_sc_sync_state() ==0) {
			rtk_mod_timer(&priv->ss_timer, jiffies + SS_TO_SYN);
		}else {
    	    		rtk_mod_timer(&priv->ss_timer, jiffies + RTL_MILISECONDS_TO_JIFFIES(priv->pmib->miscEntry.ss_to));
		}
	#else
    	    	rtk_mod_timer(&priv->ss_timer, jiffies + RTL_MILISECONDS_TO_JIFFIES(priv->pmib->miscEntry.ss_to));
	#endif
            }
        }
    }
}
DEFINE_TIMER_CALLBACK(rtl8192cd_ss_timer);

void init_ss_timer(struct rtl8192cd_priv *priv)
{
#if defined(CONFIG_PCI_HCI)
	if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE) {
		rtk_timer_setup(&(priv->ss_timer), rtl8192cd_ss_timer, (unsigned long)priv, 0);
	} else
#endif
#if defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI)
	{
		rtk_timer_setup(&(priv->ss_timer), timer_event_timer_fn, (unsigned long)(&(priv->ss_timer_event)), 0);
		INIT_TIMER_EVENT_ENTRY(&priv->ss_timer_event,rtl8192cd_ss_timer, (unsigned long)priv);
	}
#endif
	;
}

/**
 *	@brief  get WPA/WPA2 information
 *  start of unsigned int t_stamp[0]
 *	use 1 timestamp (32-bit variable) to carry WPA/WPA2 info
 *	1st 16-bit:                 WPA
 *  |          auth       |              unicast cipher              |              multicast cipher            |
 *     15    14    13   12      11      10     9     8       7      6      5       4      3     2       1      0
 *	+-----+-----+----+-----+--------+------+-----+------+-------+-----+--------+------+-----+------+-------+-----+
 *	| Rsv | PSK | 1X | Rsv | WEP104 | CCMP | Rsv | TKIP | WEP40 | Grp | WEP104 | CCMP | Rsv | TKIP | WEP40 | Grp |
 *	+-----+-----+----+-----+--------+------+-----+------+-------+-----+--------+------+-----+------+-------+-----+
 *	2nd 16-bit:                 WPA2
 *            auth       |              unicast cipher              |              multicast cipher            |
 *	  15    14    13   12      11      10     9     8       7      6      5       4      3     2       1      0	
 *  +-----+-----+----+-----+--------+------+-----+------+-------+-----+--------+------+-----+------+-------+-----+
 *	| Rsv | PSK | 1X | Rsv | WEP104 | CCMP | Rsv | TKIP | WEP40 | Grp | WEP104 | CCMP | Rsv | TKIP | WEP40 | Grp |
 *  +-----+-----+----+-----+--------+------+-----+------+-------+-----+--------+------+-----+------+-------+-----+
 */
static void get_security_info(struct rtl8192cd_priv *priv, struct rx_frinfo *pfrinfo, int index)
{
	int i, len, result;
	unsigned char *p, *pframe, *p_uni, *p_auth, val;
	unsigned short num;
	unsigned char OUI1[] = {0x00, 0x50, 0xf2};
	unsigned char OUI2[] = {0x00, 0x0f, 0xac};
#if defined(CONFIG_RTL_WAPI_SUPPORT)
	const unsigned char OUI3[] = {0x00, 0x14, 0x72};
#endif
#ifdef  CONFIG_IEEE80211W_CLI
	unsigned short	rsnie_cap;
	DOT11_RSN_CAPABILITY *pDot11RSNCapability = (unsigned char *)&priv->site_survey->wscie[index].data;
#endif

	//WPS2DOTX
	unsigned char *awPtr  =  (unsigned char *)&priv->site_survey->wscie[index].data;
	int foundtimes = 0;
	unsigned char *ptmp = NULL;
	unsigned int lentmp=0;
	unsigned int totallen=0;
	//WPS2DOTX
	u8 sae_en = 0;

	if (index >= MAX_BSS_NUM) {
		DEBUG_ERR("get_security_info Error: WSC IE index exceeds!\n");
		return;
	}

	pframe = get_pframe(pfrinfo);
	priv->site_survey->bss[index].t_stamp[0] = 0;

	/*-----pasre WPA IE-----*/
	p = pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_;
	len = 0;
	result = 0;
	do {
		p = get_ie(p, _RSN_IE_1_, &len,
			pfrinfo->pktlen - (p - pframe));
		if ((p != NULL) && (len > 18))
		{
			if (memcmp((p + 2), OUI1, 3))
				goto next_tag;
			if (*(p + 5) != 0x01)
				goto next_tag;
			if (memcmp((p + 8), OUI1, 3))
				goto next_tag;
			val = *(p + 11);
			priv->site_survey->bss[index].t_stamp[0] |= BIT(val);
			p_uni = p + 12;
			memcpy(&num, p_uni, 2);
			num = le16_to_cpu(num);
			for (i=0; i<num; i++) {
				if (memcmp((p_uni + 2 + 4 * i), OUI1, 3))
					goto next_tag;
				val = *(p_uni + 2 + 4 * i + 3);
				priv->site_survey->bss[index].t_stamp[0] |= (BIT(val) << 6);
			}
			p_auth = p_uni + 2 + 4 * num;
			memcpy(&num, p_auth, 2);
			num = le16_to_cpu(num);
			for (i=0; i<num; i++) {
				if (memcmp((p_auth + 2 + 4 * i), OUI1, 3))
					goto next_tag;
				val = *(p_auth + 2 + 4 * i + 3);
				priv->site_survey->bss[index].t_stamp[0] |= (BIT(val) << 12);
			}
			result = 1;
		}
next_tag:
		if (p != NULL)
			p = p + 2 + len;
	} while ((p != NULL) && (result != 1));

	if (result != 1)
	{
		priv->site_survey->bss[index].t_stamp[0] = 0;
	}

	/*-----pasre WPA2 IE-----*/
	p = pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_;
	len = 0;
	result = 0;
	do {
		p = get_ie(p, _RSN_IE_2_, &len,
			pfrinfo->pktlen - (p - pframe));
		if ((p != NULL) && (len > 12))
		{
			if (memcmp((p + 4), OUI2, 3))
				goto next_id;
			/*---group cipher---*/
			val = *(p + 7);
			priv->site_survey->bss[index].t_stamp[0] |= (BIT(val) << 16);
			/*---pairwise cipher---*/
			p_uni = p + 8;
			memcpy(&num, p_uni, 2);
			num = le16_to_cpu(num);
			for (i=0; i<num; i++) {
				if (memcmp((p_uni + 2 + 4 * i), OUI2, 3))
					goto next_id;
				val = *(p_uni + 2 + 4 * i + 3);
				priv->site_survey->bss[index].t_stamp[0] |= (BIT(val) << 22);
			}
			/*---Auth Key MGMT---*/
			p_auth = p_uni + 2 + 4 * num;
			memcpy(&num, p_auth, 2);
			num = le16_to_cpu(num);

#ifdef CONFIG_IEEE80211W_CLI 
			priv->bss_support_akmp = 0;
#endif
			for (i=0; i<num; i++) {
				if (memcmp((p_auth + 2 + 4 * i), OUI2, 3))
					goto next_id;
				val = *(p_auth + 2 + 4 * i + 3);
				priv->site_survey->bss[index].t_stamp[0] |= (BIT(val) << 28);

#ifdef CONFIG_IEEE80211W_CLI 
				priv->bss_support_akmp |= BIT(val);
#endif
#if defined(AUTH_SAE_STA) || defined(RTK_NL80211)
				/*---WPA3 check AKM---*/
				if(val==AKM_SAE_PSK ){
					log("peer support SAE AKM");
					priv->site_survey->bss[index].t_stamp[1] |= BIT(11);
					sae_en = 1;
				}
#endif
			}

			/*---Capability---*/
#ifdef CONFIG_IEEE80211W_CLI
			memcpy(&rsnie_cap, (p_auth + 2 + 4 * num), 2);
			priv->wpa_global_info->rsnie_cap = le16_to_cpu(rsnie_cap);	

			if((priv->wpa_global_info->rsnie_cap & BIT(6)) && (priv->wpa_global_info->rsnie_cap & BIT(7)))
					priv->site_survey->bss[index].t_stamp[1] |= PMF_REQ;
			else if(priv->wpa_global_info->rsnie_cap & BIT(7))
					priv->site_survey->bss[index].t_stamp[1] |= PMF_CAP;
				else
					priv->site_survey->bss[index].t_stamp[1] |= PMF_NONE;			
#endif
			result = 1;
		}
next_id:
		if (p != NULL)
			p = p + 2 + len;
	} while ((p != NULL) && (result != 1));

	if (result != 1)
	{
		priv->site_survey->bss[index].t_stamp[0] &= 0x0000ffff;
	}

//#ifdef ENABLE_SAE_H2E
	if ( sae_en ) {
		u16 ie_len = 0;
		p = pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_;
		len = 0;
		result = 0;

		ie_len = pfrinfo->pktlen - (p - pframe);

		// mem_dump("bea_info", p, ie_len);

		p = get_ie(p, _RSNX_IE_, &len,
			pfrinfo->pktlen - (p - pframe));

		if ( p != NULL ) {
			priv->site_survey->bss[index].t_stamp[1] |= BIT(12);
		}
	}
//#endif

#if defined(CONFIG_RTL_WAPI_SUPPORT)
	p = pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_;
	len = 0;
	result = 0;
	do {
		p = get_ie(p, _EID_WAPI_, &len,
			pfrinfo->pktlen - (p - pframe));
		if ((p != NULL) && (len >19))
		{
			i = *((uint16*)(p+4));
			if (i != 0x0100)
				goto next_id_wapi;
			if (memcmp((p + 6), OUI3, 3) || *(p+9)!=2)
				goto next_id_wapi;
			
			val = *(p + 9);
			priv->site_survey->bss[index].t_stamp[0] = SECURITY_INFO_WAPI;
			break;
		}
next_id_wapi:
		if (p != NULL)
			p = p + 2 + len;
	} while ((p != NULL) && (result != 1));
#endif

#ifdef WIFI_SIMPLE_CONFIG
/* WPS2DOTX*/
#ifndef MULTI_MAC_CLONE
#if defined(WIFI_WPAS_CLI)
	if ((OPMODE & WIFI_STATION_STATE) || (SSFROM_WPAS == priv->ss_req_ongoing))
#elif defined(WIFI_WPAS) || defined(RTK_NL80211)
	if (OPMODE & WIFI_STATION_STATE) 
#else
	if (priv->ss_req_ongoing == SSFROM_WSC)  //simple-config scan-req
#endif
#endif
	{
		//ptmp = pframe + WLAN_HDR_A3_LEN + _PROBEREQ_IE_OFFSET_;
		ptmp = pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_;		

		for (;;)
		{
			ptmp = get_ie(ptmp, _WPS_IE_, (int *)&lentmp,pfrinfo->pktlen - (ptmp - pframe));
			
			if (ptmp != NULL) {
				if (!memcmp(ptmp+2, WSC_IE_OUI, 4)) {
					foundtimes ++;
					if(foundtimes ==1){
						if (lentmp+2 > MAX_WSC_IE_LEN-totallen) {
							DEBUG_ERR("get_security_info Error: wps_ie len exceeds!\n");
							return;
						}
						memcpy(awPtr , ptmp ,lentmp + 2);
						awPtr+= (lentmp + 2);
						totallen += (lentmp + 2);
					}else{
						if ((lentmp < 4) || (lentmp-4 > MAX_WSC_IE_LEN-totallen)) {
							DEBUG_ERR("get_security_info Error: wps_ie len error!\n");
							return;
						}
						memcpy(awPtr , ptmp+2+4 ,lentmp-4);
						awPtr+= (lentmp-4);
						totallen += (lentmp-4);						
					}					
				}
			}
			else{
				break;
			}

			ptmp = ptmp + lentmp + 2;
		}
		if(foundtimes){
        	/*cfg p2p cfg p2p*/
			/*Save WSC IE*/ 
			priv->site_survey->wscie[index].wps_ie_len = totallen;
			//debug_out("WSC_IE",priv->site_survey.ie[index].data,totallen);
			//get the first wps ie to see the
			//search_wsc_tag(unsigned char *data, unsigned short id, int len, &target_len);
			priv->site_survey->bss[index].t_stamp[1] |= BIT(8);  //  set t_stamp[1] bit 8 when AP supports WPS
		} else {
			awPtr[0]='\0';
			priv->site_survey->bss[index].t_stamp[1] &= ~BIT(8);  // clear t_stamp[1] bit 8 when AP not supports WPS(do not have wps IE)
		}
	}

#endif
/* WPS2DOTX*/
}

#ifdef P2P_SUPPORT
/* type:  WIFI_BEACON: from beacon, WIFI_PROBERSP: from prob rsp*/
int p2p_collect_bss_info(struct rtl8192cd_priv *priv, struct rx_frinfo *pfrinfo, int type)
{
    int index;
    int len;
    unsigned char  *pframe, *sa, channel_tmp;
    int role;		
    unsigned char *ptmp=NULL;
    unsigned char *SsidPtr=NULL;
    int ssidlen = 0;

    /* p2p IE must support fragment and reassembly ;
    	this method is sample for support reassembly*/  
    static	unsigned char ReAssem_p2pie[MAX_REASSEM_P2P_IE];
    static	unsigned char ReAssem_wscie[MAX_REASSEM_P2P_IE];		

    int IEfoundtimes = 0 ;
    unsigned char *p2pIEPtr = ReAssem_p2pie ;
    int p2pIElen=0;

    unsigned char *wscIEPtr = ReAssem_wscie ;
    int wscIElen=0;	

    unsigned char* wsc_tag_ptr=NULL;
    int tag_len = 0;        
   

    struct device_info_s p2p_devic_info;
    memset(&p2p_devic_info,0,sizeof(struct device_info_s));

    pframe = get_pframe(pfrinfo);
    sa = GetAddr2Ptr(pframe);

    if (priv->site_survey->count_p2p >= MAX_BSS_NUM){
        P2P_DEBUG("bss count > MAX_BSS_NUM!!!\n");
        return 0;
    }

    /* chk DA is broadcast or my p2p device-addr (default use MY-HW-ADDR as p2p device addrree)*/
    if( memcmp(GetAddr1Ptr(pframe), "\xff\xff\xff\xff\xff\xff", 6) 
        && memcmp(GetAddr1Ptr(pframe), GET_MY_HWADDR, 6))
    {
        P2P_DEBUG("DA mismatch!\n");
        return 0;
    }

	
    /*get SSID*/ 
    SsidPtr = get_ie(pframe + WLAN_HDR_A3_LEN + _PROBERSP_IE_OFFSET_, _SSID_IE_, &ssidlen,
    pfrinfo->pktlen - WLAN_HDR_A3_LEN - _PROBERSP_IE_OFFSET_);


    /* chk ssid == wildcard SSID ("DIRECT-")*/ 
    /*cfg p2p cfg p2p*/
    if(SsidPtr && (ssidlen >= 7) && !memcmp(SsidPtr+2,"DIRECT-",7))
    {
		P2P_DEBUG("device: %02x%02x%02x:%02x%02x%02x\n" ,
			sa[0],sa[1],sa[2],sa[3],sa[4],sa[5]);					

    }else{	
        return 0;
    }


	/*----------------------------find P2P IE -----------------------------------start*/

	/*  Get P2P IE from Probe_RSP */
    IEfoundtimes = 0;
    len = 0 ;	
    ptmp = pframe + WLAN_HDR_A3_LEN + _PROBERSP_IE_OFFSET_ ;			

    /*support ReAssemble*/	
    for (;;)
    {
        ptmp = get_ie(ptmp, _P2P_IE_, &len,	
        pfrinfo->pktlen - WLAN_HDR_A3_LEN - _PROBERSP_IE_OFFSET_ - len);			

        if (ptmp) {
            if ((len >= 4) && !memcmp(ptmp+2, WFA_OUI_PLUS_TYPE, 4)) {
                if (p2pIElen+len-4 > MAX_REASSEM_P2P_IE) {
                    P2P_DEBUG("\n\n	ReAssem WSC IE exceed MAX_REASSEM_P2P_IE , chk!!!\n\n");
                    return 0;
                }
                IEfoundtimes ++;
                memcpy(p2pIEPtr , ptmp+6 ,len-4);
                p2pIEPtr+= (len-4);
                p2pIElen += (len-4);
            }

        }
        else{
            break;
        }
        ptmp = ptmp + len + 2;

    }


			
    if(IEfoundtimes){

    }else{
        return 0;
    }	
	/*----------------------------find P2P IE -----------------------------------end*/


	/*----------------------------find WSC IE -----------------------------------start*/

	/*  Get WSC IE from Probe Rsp */
    IEfoundtimes = 0;
    len = 0;

    ptmp = pframe + WLAN_HDR_A3_LEN + _PROBERSP_IE_OFFSET_ ;
    for (;;)
    {
        ptmp = get_ie(ptmp, _WPS_IE_, &len,	
        pfrinfo->pktlen - WLAN_HDR_A3_LEN - _PROBERSP_IE_OFFSET_ - len);			

        if (ptmp) {
            if ((len >= 4) && !memcmp(ptmp+2, WSC_IE_OUI, 4)) {
                if (wscIElen+len-4 > MAX_REASSEM_P2P_IE) {
                    P2P_DEBUG("\n\n	ReAssem WSC IE exceed MAX_REASSEM_P2P_IE , chk!!!\n\n");
                    return 0;
                }
                IEfoundtimes ++;
                memcpy(wscIEPtr , ptmp+6 ,len-4);
                wscIEPtr+= (len-4);
                wscIElen += (len-4); 
            }
        }
        else{
            break;
        }
        ptmp = ptmp + len + 2;

    }

    if(IEfoundtimes){

    }else{
        P2P_DEBUG("no found wsc IE \n");					
        return 0 ;
    }	
    /*----------------------------find wsc IE -----------------------------------end*/


    /*--- record rx form which channel from _DSSET_IE_ for later use---*/	
    ptmp = get_ie(pframe + WLAN_HDR_A3_LEN + _PROBERSP_IE_OFFSET_, _DSSET_IE_, &len,
    pfrinfo->pktlen - WLAN_HDR_A3_LEN - _PROBERSP_IE_OFFSET_);


    if (ptmp != NULL){
        channel_tmp = *(ptmp+2);
    }else{
        channel_tmp = priv->site_survey->ss_channel;	
    }	
	/*--- record rx form which channel from _DSSET_IE_ for later use---*/	


	
	/*-----chk target is GO or device-----*/
	//p2pIEPtr = ReAssem_p2pie;
		/*cfg p2p cfg p2p*/
    if((role = p2p_get_role_from_ie(priv,ReAssem_p2pie,p2pIElen)) == 0) {       
        P2P_DEBUG("no found TAG_P2P_CAPABILITY attribute\n");					
        return 0;
    }
    
    if(type == WIFI_PROBERSP){  
        if(p2p_get_device_info(priv,ReAssem_p2pie,p2pIElen,&p2p_devic_info) == FAIL) {
            P2P_DEBUG("no P2P DEVICE_INFO attribute in prob rsp frame\n");                    
            return 0;
        }
    }
    else if(type == WIFI_BEACON){
        if(p2p_get_GO_p2p_info(priv,ReAssem_p2pie,p2pIElen,&p2p_devic_info) == FAIL){
            /*no include device id addr in P2P IE*/ 
            P2P_DEBUG("no P2P DEVICE_ID attribute in beacon frame\n");                    
            return 0;
        }
    }
    else {
        return 0;
    }
    
    p2p_get_GO_wsc_info(priv,ReAssem_wscie,wscIElen,&p2p_devic_info);            

	/*-----chk target is GO or device-----*/
	
	/*---find free site_survey bss---*/
	// search if exist
    for(index = 0  ; index<priv->site_survey->count_p2p ; index++){
        if(!memcmp(priv->site_survey->bss_p2p[index].p2paddress, p2p_devic_info.dev_address , MACADDRLEN))
            break;
    }
    if(index == priv->site_survey->count_p2p){
        priv->site_survey->count_p2p++;
    }


    // now recored this bss info
    priv->site_survey->bss_p2p[index].channel = channel_tmp ;
    priv->site_survey->bss_p2p[index].p2prole = role;		

    memcpy(priv->site_survey->bss_p2p[index].p2paddress,p2p_devic_info.dev_address ,MACADDRLEN);
    //memcpy(priv->site_survey->bss_backup[index].p2pdevname , p2p_devic_info.devname ,33);	
    strcpy(priv->site_survey->bss_p2p[index].p2pdevname , p2p_devic_info.devname);	
    priv->site_survey->bss_p2p[index].p2pwscconfig = p2p_devic_info.config_method;		

    if(role == R_P2P_GO){
        memcpy(priv->site_survey->bss_p2p[index].ssid , SsidPtr+2	, ssidlen);	
        priv->site_survey->bss_p2p[index].ssid[ssidlen]='\0';
        //P2P_DEBUG("ssid=%s\n",priv->site_survey->bss_backup[index].ssid);
    }

    return SUCCESS;
}

#endif

// this shouldn't be seperated since AKM  suite type is needed to consider together
#if defined(CONFIG_IEEE80211W_CLI) || defined(CONFIG_IEEE80211R_CLI) 
unsigned char SHA256_AKM_SUITE[] = {0x00, 0x0F, 0xAC, 0x06};
void add_sha256_akm(struct rtl8192cd_priv *priv)
{
	WPA_GLOBAL_INFO *pGblInfo = priv->wpa_global_info;
	unsigned char AKM_buff[KEY_AKM_LEN];
	
	OCTET_STRING AKM;
	memcpy(AKM_buff, SHA256_AKM_SUITE, KEY_AKM_LEN);
	AKM.Octet = AKM_buff;
	AKM.Length = KEY_AKM_LEN;
	Message_setSha256AKM(pGblInfo->AuthInfoElement, AKM);
}

unsigned char FT_PSK_AKM_SUITE[] = {0x00, 0x0F, 0xAC, 0x04};
void add_ft_akm(struct rtl8192cd_priv *priv)
{
	WPA_GLOBAL_INFO *pGblInfo = priv->wpa_global_info;
	unsigned char AKM_buff[KEY_AKM_LEN];
	
	OCTET_STRING AKM;
	memcpy(AKM_buff, FT_PSK_AKM_SUITE, KEY_AKM_LEN);
	AKM.Octet = AKM_buff;
	AKM.Length = KEY_AKM_LEN;
	Message_setFTAKM(pGblInfo->AuthInfoElement, AKM);
}
#endif

inline BOOLEAN is_wep_encryption(unsigned short capability, unsigned int t_stamp)
{
	if ((capability & BIT4)	/* privacy enable */
		&& (t_stamp == 0))	/* no any rsn ie presented */
	{
		return TRUE;
	}
	else
		return FALSE;
}

/**
 *	@brief	After site survey, collect BSS information to site_survey->bss[index]
 *
 *	The function can find site
 *  Later finish site survey, call the function get BSS informat.
 */
int collect_bss_info(struct rtl8192cd_priv *priv, struct rx_frinfo *pfrinfo)
{
	int i, index, len = 0;
   	int min_idx = 0;
	unsigned long min_record = 0;
	unsigned char *addr, *p, *pframe, *sa, channel=0;
	UINT32	basicrate=0, supportrate=0, hiddenAP=0;
	UINT16	val16;
	struct wifi_mib *pmib;
	DOT11_WPA_MULTICAST_CIPHER wpaMulticastCipher;
	unsigned char OUI1[] = {0x00, 0x50, 0xf2, 0x01};
	DOT11_WPA2_MULTICAST_CIPHER wpa2MulticastCipher;
	unsigned char OUI2[] = {0x00, 0x0f, 0xac};

#if defined(P2P_SUPPORT) && defined(RTK_NL80211)        
	/*cfg p2p cfg p2p*/
    u8* IE_START_PTR;
    int IE_LEN =  pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_;	
    unsigned char *WSCIEPtr = NULL ;
    int WSCIElen=0;
	unsigned char *p2pIEPtr2 = NULL;    
	/*cfg p2p cfg p2p*/	
#endif    

    #ifdef P2P_SUPPORT  
	static	unsigned char ReAssem_p2pie[MAX_REASSEM_P2P_IE];
	int IEfoundtimes=0;
	unsigned char *p2pIEPtr = ReAssem_p2pie ;
	int p2pIElen=0;
    #endif

#ifdef SUPPORT_MULTI_PROFILE
	int jdx=0;
	int found=0;
	int ssid_len=0;
#endif
#ifdef CONFIG_RTK_WPS_MESH
	unsigned char *ptmp=NULL;
#endif
#ifdef AUTH_SAE_STA
	int result_tmp=0;
#endif

	pframe = get_pframe(pfrinfo);
#ifdef CONFIG_RTK_MESH
// GANTOE for site survey 2008/12/25 ====
	if(pfrinfo->is_11s)
		addr = GetAddr2Ptr(pframe);
	else
#endif
		addr = GetAddr3Ptr(pframe);

	sa = GetAddr2Ptr(pframe);
	pmib = GET_MIB(priv);

	if(priv->site_survey->pptyIE) {
		unsigned char str_content[65] = {0};

		p = get_oui(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, priv->site_survey->pptyIE->oui, &len,
			pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);

		if(len > 3) {
			memcpy(str_content, p+2+3, len-3);
			str_content[len-3] = '\0';

			//p+2 is the IE content
			if(p && strcmp(priv->site_survey->pptyIE->content,str_content))
				return 0;
		} else
			return 0;
	}
#if defined(P2P_SUPPORT) && defined(RTK_NL80211)    
	/*cfg p2p cfg p2p*/
    IE_START_PTR = pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_ ;

    /*-------------find wsc IE -----------------------------------*/
	WSCIEPtr = rtk_get_wps_ie(IE_START_PTR , IE_LEN , NULL , &WSCIElen);

    /*-------------find P2P IE -----------------------------------*/
    p2pIEPtr2 = rtk_get_p2p_ie(IE_START_PTR , IE_LEN , NULL , &p2pIElen);

/*-------------for p2p check da,ssid,wsc,p2p etc-----------------------*/    
	if(rtk_p2p_is_enabled(priv)==CFG80211_P2P && rtk_p2p_chk_role(priv,P2P_DEVICE)){
	    /* chk DA is broadcast or my p2p device-addr 
	              (default use MY-HW-ADDR as p2p device addrree)*/
	    if( memcmp(GetAddr1Ptr(pframe), "\xff\xff\xff\xff\xff\xff", 6) 
	        && memcmp(GetAddr1Ptr(pframe), GET_MY_HWADDR, 6)){


	        return 0;   
	    }            
	    /* chk ssid == wildcard SSID ("DIRECT-")*/ 
	    unsigned char *SSIDIEPtr=NULL;
	    int SSIDIELen = 0;  

	    SSIDIEPtr = get_ie(IE_START_PTR, _SSID_IE_, &SSIDIELen , IE_LEN);    
	    if(SSIDIEPtr && !memcmp(SSIDIEPtr+2,"DIRECT-",7))
	    {
	      // NDEBUG("device: %02x%02x%02x:%02x%02x%02x\n",sa[0],sa[1],sa[2],sa[3],sa[4],sa[5]); 
	    }else{  
	        //NDEBUG("ignore\n");                    
	        return 0;
	    }
	    
	    /*---------chk P2P IE------*/      
	    if(p2pIEPtr2==NULL){
	        NDEBUG2("ignore\n");                    
	        return 0; 
	    }        
	    /*---------chk WPS IE------*/      
	    if(WSCIEPtr==NULL){
	        NDEBUG2("ignore\n");                    
	        return 0; 
	    } 
	    
	}
#endif
	/*cfg p2p cfg p2p*/

#ifdef WIFI_11N_2040_COEXIST
	if (priv->pmib->dot11nConfigEntry.dot11nCoexist &&
		(priv->pmib->dot11BssType.net_work_type & (WIRELESS_11N|WIRELESS_11G)) && (
#ifdef CLIENT_MODE
		(OPMODE & WIFI_STATION_STATE) ||
#endif
		priv->pshare->is_40m_bw)) {
		p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, _HT_CAP_,
			&len, pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);
		if (p == NULL) {
			p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, _DSSET_IE_, &len,
			pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);
			if (p != NULL)
				channel = *(p+2);			
			if (OPMODE & WIFI_AP_STATE) {
				if (channel && (channel <= 14) && (priv->pmib->dot11nConfigEntry.dot11nCoexist_ch_chk ?				
				 (channel != priv->pmib->dot11RFEntry.dot11channel) : 1)) {				

					if(!priv->bg_ap_timeout) {
						priv->bg_ap_timeout = 60;
#if defined(CONFIG_RTL_8812_SUPPORT) || defined(CONFIG_WLAN_HAL) || defined(CONFIG_RTL_8723B_SUPPORT)					
						update_RAMask_to_FW(priv, 1);
#endif
						SetTxPowerLevel(priv, channel);
#ifdef CONFIG_RTL_OFFLOAD_DRIVER
                        dc_if_update(priv, 1);
#endif
					}

					//priv->bg_ap_timeout = 60;
				}
			}
#ifdef CLIENT_MODE
			else if ((OPMODE & WIFI_STATION_STATE) && priv->coexist_connection) {
				if (channel && (channel <= 14)) {
#if 0
//#if defined(CONFIG_RTL_8812_SUPPORT) || defined(CONFIG_WLAN_HAL)
					if(!priv->bg_ap_timeout) {
						priv->bg_ap_timeout = 180;
						update_RAMask_to_FW(priv, 1);
					}
#endif					
					priv->bg_ap_timeout = 180;
					priv->bg_ap_timeout_ch[channel-1] = 180;
					channel = 0;
				}
			}
#endif
		}
#ifdef CLIENT_MODE
		else if ((OPMODE & WIFI_STATION_STATE) && priv->coexist_connection) {
			/*
			 *	check if there is any 40M intolerant field set by other 11n AP
			 */
			struct ht_cap_elmt *ht_cap=(struct ht_cap_elmt *)(p+2);
			if (cpu_to_le16(ht_cap->ht_cap_info) & _HTCAP_40M_INTOLERANT_)
				priv->intolerant_timeout = 180;
		}
#endif
	}
#endif



	p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, _DSSET_IE_, &len,
		pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);
	if (p != NULL)
		channel = *(p+2);
	else {
		p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, _HT_IE_, &len,
			pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);
		if (p !=  NULL) 
			channel = *(p+2);
		else {
			if (priv->site_survey->ss_channel > 14 && !priv->site_survey->defered_ss)
				channel = priv->site_survey->ss_channel;	
			else {
				DEBUG_INFO("Beacon/Probe rsp doesn't carry channel info\n");
				return SUCCESS;
			}
		}
	}

#if defined(CONFIG_RTL_SIMPLE_CONFIG)
		if(priv->simple_config_status == 2 || priv->simple_config_status == 3)
                {
		if(!memcmp(priv->pmib->dot11StationConfigEntry.dot11DesiredBssid, sa, MACADDRLEN)) {
			int found_target_bss = 0;
			
			for(i=0; i<priv->site_survey->count; i++) {
				if(!memcmp(priv->pmib->dot11StationConfigEntry.dot11DesiredBssid, priv->site_survey->bss[i].bssid, MACADDRLEN)) {
					found_target_bss =1;
					break;
				}
				}

			if(!found_target_bss)
				goto collect_this_bss;
                        }
                }
#endif

	for(i=0; i<priv->site_survey->count; i++) {
		if (!memcmp((void *)addr, priv->site_survey->bss[i].bssid, MACADDRLEN)) {
#if defined(CLIENT_MODE) && defined(WIFI_WMM) && defined(WMM_APSD)  /*  WMM STA*/
			if ((OPMODE & WIFI_STATION_STATE) && QOS_ENABLE && APSD_ENABLE 
				&& (channel == priv->site_survey->bss[i].channel)) {  // get WMM IE / WMM Parameter IE
				p = pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_;
				for (;;) {
					p = get_ie(p, _RSN_IE_1_, &len,
						pfrinfo->pktlen - (p - pframe));
					if (p != NULL) {
						if (!memcmp(p+2, WMM_PARA_IE, 6)) {
							priv->site_survey->bss[i].t_stamp[1] |= BIT(0);  //  set t_stamp[1] bit 0 when AP supports WMM

							if (*(p+8) & BIT(7))
								priv->site_survey->bss[i].t_stamp[1] |= BIT(3);  //  set t_stamp[1] bit 3 when AP supports UAPSD
							else
								priv->site_survey->bss[i].t_stamp[1] &= ~(BIT(3));  //  reset t_stamp[1] bit 3 when AP not support UAPSD
							break;
						}
					} else {
						priv->site_survey->bss[i].t_stamp[1] &= ~(BIT(0)|BIT(3));  //  reset t_stamp[1] bit 0 when AP not support WMM & UAPSD
						break;
					}
					p = p + len + 2;
				}
			}
#endif

			if ((unsigned char)pfrinfo->rf_info.rssi > priv->site_survey->bss[i].rssi) {
				priv->site_survey->bss[i].rssi = (unsigned char)pfrinfo->rf_info.rssi;
				#ifdef WIFI_SIMPLE_CONFIG
				priv->site_survey->wscie[i].rssi = priv->site_survey->bss[i].rssi;
				#endif
				#if defined(WIFI_WPAS) || defined(RTK_NL80211)

					priv->site_survey->rtk_p2p_ie[i].rssi = priv->site_survey->bss[i].rssi;

				#endif
				if (channel == priv->site_survey->bss[i].channel) {
					if ((unsigned char)pfrinfo->rf_info.sq > priv->site_survey->bss[i].sq)
						priv->site_survey->bss[i].sq = (unsigned char)pfrinfo->rf_info.sq;
				} else {
					priv->site_survey->bss[i].channel = channel;
					priv->site_survey->bss[i].sq = (unsigned char)pfrinfo->rf_info.sq;
				}
			}
			priv->site_survey->bss_ext[i].time_record = jiffies;
			// STADEBUG("%s (%d) - Update BSSID: %02x%02x%02x%02x%02x%02x SSID: %s Channel: %d \n", __FUNCTION__, __LINE__,
			// 	addr[0], addr[1], addr[2], addr[3], addr[4], addr[5],
			// 	(priv->site_survey->bss[index].ssidlen)?priv->site_survey->bss[index].ssid:("hidden ssid"),
			// 	channel);
			return SUCCESS;
		}
	}

	// checking SSID
	p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, _SSID_IE_, &len,
		pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);

	if ((p == NULL) ||		// NULL AP case 1
		(len == 0) ||		// NULL AP case 2
		(*(p+2) == '\0'))	// NULL AP case 3 (like 8181/8186)
	{
		if (priv->ss_req_ongoing && pmib->miscEntry.show_hidden_bss)
			hiddenAP = 1;
		else if (priv->auto_channel == 1)
			hiddenAP = 1;
#ifdef CONFIG_RTK_MESH        
		else if(pfrinfo->is_11s)
			hiddenAP = 1;
#endif        
		else {
#ifdef CLIENT_MODE
			if ((OPMODE & WIFI_STATION_STATE) && 
		    //!priv->ss_req_ongoing &&	//20131218 , mark it for hidden + dfs ch AP connection
			//		!priv->auto_channel && 
			is_passive_channel(priv , priv->pmib->dot11StationConfigEntry.dot11RegDomain, priv->site_survey->ss_channel)) 
			{
                /*For eg: ch60 now and hidden_ap_found=1 ; next time ss_timer will keep at ch60=> issue probe_req; next time ss_timer change to ch64 and on going...                 
				hidden_ap_found status machine as below
                            1) 0->1,1st ch60
                            next time
                            2)1->2, 2nd ch 60, and don't 2->1(chk in here) else will bring loop,ch 60,60,60,60,60......util hidden AP gone
                            */
                if(	priv->site_survey->hidden_ap_found != HIDE_AP_FOUND_DO_ACTIVE_SSAN){
	                //STADEBUG("hidden_ap_found=1\n");
					priv->site_survey->hidden_ap_found = HIDE_AP_FOUND;
				}
			}
#endif	
			DEBUG_INFO("drop beacon/probersp due to null ssid\n");
#ifdef WDS
			if (!priv->pmib->dot11WdsInfo.wdsEnabled)
#endif
			return 0;
		}
	}

	// if scan specific SSID
	if (priv->ss_ssidlen > 0) 
    {
        /*when multiProfile enable,we send probe_req to all dev on profiles list , so chk if ssid match with ssid on profiles list*/
#ifdef SUPPORT_MULTI_PROFILE		
		if (priv->pmib->ap_profile.enable_profile && priv->pmib->ap_profile.profile_num > 0) {
			found = 0;			
			for(jdx=0;jdx<priv->pmib->ap_profile.profile_num;jdx++) {									
				ssid_len = strlen(priv->pmib->ap_profile.profile[jdx].ssid);
				if ((ssid_len == len) && !memcmp(priv->pmib->ap_profile.profile[jdx].ssid, p+2, len)) {
					//STADEBUG("Found ssid=%s,jdx=%d\n", priv->pmib->ap_profile.profile[jdx].ssid , jdx);
					found = 1;
                    break;
                }
			}			
            
			if(found == 0)
				return 0;
		}
		else	
#endif
		if ((priv->ss_ssidlen != len) || !p || memcmp(priv->ss_ssid, p+2, len)){
			/*cfg p2p cfg p2p*/
#if defined(P2P_SUPPORT) && defined(RTK_NL80211)    
			//CFG80211_P2P [1] case: both dev,GC run collect_bss_info()
			//PROPERTY_P2P [2] case: dev run p2p_collect_bss_info, others run this function
            if(rtk_p2p_is_enabled(priv)){   // under p2p mode when ssid = DIRECT-* , don't ignore, has checked above
				// let it go on
            }else
#endif
			{
                // NDEBUG("ignore!\n");
    			return 0;
            }
        }
	}

#ifdef CLIENT_MODE
// mantis#2523
	p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, _SSID_IE_, &len,
		pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);

	if( p && (SSID_LEN == len) && !memcmp(SSID, p+2, len)) {
		memcpy(priv->rx_timestamp, pframe+WLAN_HDR_A3_LEN, 8);
	}	
#endif

#ifdef CONFIG_IEEE80211R_CLI
	if(FT_ENABLE) {
		p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, _MOBILITY_DOMAIN_IE_, &len,
			pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);
		if(p != NULL) {
			if(len == 3) {
				memcpy((void *)priv->site_survey->bss[i].mdid, (void *)(p+2), 2);
				priv->site_survey->bss[i].ft_cap = *(unsigned char *)(p+4);
				priv->site_survey->bss[i].t_stamp[1] |= FT_SUPPORT;
			}
		}
	}
#endif

	//panic_printk("priv->ss_ssid = %s, priv->ss_ssidlen=%d\n", priv->ss_ssid, priv->ss_ssidlen);

	// if scan specific SSID && WPA2 enabled
	if (priv->ss_ssidlen > 0) {
		// search WPA2 IE
		p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, _RSN_IE_2_, &len,
			pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);
		if (p != NULL) {
			// RSN IE
			// 0	1	23	4567
			// ID	Len	Versin	GroupCipherSuite
			u8 *pmkid_ptr = NULL;
			u8	pmkid_cnt = 0;

		/*---test plan WPA2 Security Improvements ---*/
#ifdef AUTH_SAE_STA
			log("==>wpa2_ie_check");
			result_tmp = wpa2_ie_check(priv, p, len+2, &pmkid_ptr, &pmkid_cnt);
			if (result_tmp != WPA2IE_OK){
				log("check wpa2 RSN IE error[%d]",result_tmp);
				dump_hex("RSN IE",p,len+2);
				return 0;
			}
#endif
#if defined(CONFIG_IEEE80211W_CLI) || defined(CONFIG_IEEE80211R_CLI)
			if (priv->wpa_global_info->AuthInfoElement.Octet) {
				if((2 == WPA_GET_LE16(p+14))) { //AKM num >= 2	
					if(!memcmp((p+20), SHA256_AKM_SUITE, sizeof(SHA256_AKM_SUITE))){
						priv->support_sha256 = TRUE;
						add_sha256_akm(priv);
					}
					if(!memcmp((p+20), FT_PSK_AKM_SUITE, sizeof(FT_PSK_AKM_SUITE))) {
						add_ft_akm(priv);
					}
				}else if(!memcmp((p+16), SHA256_AKM_SUITE, sizeof(SHA256_AKM_SUITE))){
					priv->support_sha256 = TRUE;
					add_sha256_akm(priv);
				}else{
					priv->support_sha256 = FALSE;
				}
				priv->bss_support_sha256 = priv->support_sha256;
			}
#endif

			if ((len > 7) && (pmib->dot11RsnIE.rsnie[0] == _RSN_IE_2_) &&
					(pmib->dot11RsnIE.rsnie[7] != *(p+7)) &&
					!memcmp((p + 4), OUI2, 3)) {
				// set WPA2 Multicast Cipher as same as AP's
				//printk("WPA2 Multicast Cipher = %d\n", *(p+7));
				pmib->dot11RsnIE.rsnie[7] = *(p+7);
			}
#ifndef WITHOUT_ENQUEUE
			wpa2MulticastCipher.EventId = DOT11_EVENT_WPA2_MULTICAST_CIPHER;
			wpa2MulticastCipher.IsMoreEvent = 0;
			wpa2MulticastCipher.MulticastCipher = *(p+7);
			DOT11_EnQueue((unsigned long)priv, priv->pevent_queue, (UINT8 *)&wpa2MulticastCipher,
						sizeof(DOT11_WPA2_MULTICAST_CIPHER));
#endif
			event_indicate(priv, NULL, -1);

		}
	}

	// david, reported multicast cipher suite for WPA
	// if scan specific SSID && WPA2 enabled
	if (priv->ss_ssidlen > 0) {
		// search WPA IE, should skip that not real RSNIE (eg. Asus WL500g-Deluxe)
		p = pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_;
		len = 0;
		do {
			p = get_ie(p, _RSN_IE_1_, &len,
				pfrinfo->pktlen - (p - pframe));
			if (p != NULL) {
				if ((len > 11) && (pmib->dot11RsnIE.rsnie[0] == _RSN_IE_1_) &&
						(pmib->dot11RsnIE.rsnie[11] != *(p+11)) &&
						!memcmp((p + 2), OUI1, 4)) {
					// set WPA Multicast Cipher as same as AP's
					pmib->dot11RsnIE.rsnie[11] = *(p+11);

#ifndef WITHOUT_ENQUEUE
					wpaMulticastCipher.EventId = DOT11_EVENT_WPA_MULTICAST_CIPHER;
					wpaMulticastCipher.IsMoreEvent = 0;
					wpaMulticastCipher.MulticastCipher = *(p+11);
					DOT11_EnQueue((unsigned long)priv, priv->pevent_queue, (UINT8 *)&wpaMulticastCipher,
							sizeof(DOT11_WPA_MULTICAST_CIPHER));
#endif
					event_indicate(priv, NULL, -1);
				}
			}
			if (p != NULL)
				p = p + 2 + len;
		} while (p != NULL);
	}

	for(i=0; i<priv->available_chnl_num; i++) {
		if (channel == priv->available_chnl[i])
			break;
	}
	if (i == priv->available_chnl_num)	// receive the adjacent channel that is not our domain
		return 0;

	p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, _SUPPORTEDRATES_IE_, &len,
		pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);
	if (p && (len <= 8)) {
		for(i=0; i<len; i++) {
			if (p[2+i] & 0x80)
				basicrate |= get_bit_value_from_ieee_value(p[2+i] & 0x7f);
			supportrate |= get_bit_value_from_ieee_value(p[2+i] & 0x7f);
		}
	}

	p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, _EXT_SUPPORTEDRATES_IE_, &len,
		pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);
	if (p != NULL) {
		for(i=0; i<len; i++) {
			if (p[2+i] & 0x80)
				basicrate |= get_bit_value_from_ieee_value(p[2+i] & 0x7f);
			supportrate |= get_bit_value_from_ieee_value(p[2+i] & 0x7f);
		}
	}

	if (channel <= 14)
	{
#ifdef P2P_SUPPORT
			/*cfg p2p cfg p2p*/
		if(rtk_p2p_is_enabled(priv)){
			/*under P2P mode allow no support B rate*/ 
		}
		else
#endif
		if (!(pmib->dot11BssType.net_work_type & WIRELESS_11B)){
			if (((basicrate & 0xff0) == 0) && ((supportrate & 0xff0) == 0)){
				return 0;
			}
		}

		if (!(pmib->dot11BssType.net_work_type & WIRELESS_11G)){
			if (((basicrate & 0xf) == 0) && ((supportrate & 0xf) == 0)){
				return 0;
			}
		}
	}
#ifdef P2P_SUPPORT	
    if(rtk_p2p_is_enabled(priv) && rtk_p2p_chk_role(priv,P2P_PRE_CLIENT)){
        p = pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_ ;
        
        /*support ReAssemble*/  
        for (;;){
            
            p = get_ie(p, _P2P_IE_, &len,   
                pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_ - len);              
            if (p) {
                if ((len >= 4) && !memcmp(p+2, WFA_OUI_PLUS_TYPE, 4)) {
                    if (p2pIElen+len-4 > MAX_REASSEM_P2P_IE) {
                        P2P_DEBUG("\n\n reassemble P2P IE exceed MAX_REASSEM_P2P_IE , chk!!!\n\n");
                        return 0;
                    }
                    IEfoundtimes ++;
                    memcpy(p2pIEPtr , p+2+4 ,len-4);
                    p2pIEPtr+= (len-4);             
                    p2pIElen+= (len-4);
                }
            }
            else{
                break;
            }
            p = p + len + 2;
            
        }
        
        if(IEfoundtimes){
            if(IEfoundtimes>1){
                P2P_DEBUG("ReAssembly p2p IE\n");
            }       
                /*if target AP support management function ; skip it*/
                if(P2P_filter_manage_ap(priv , ReAssem_p2pie , p2pIElen )){
                    return 0;
                }
            }

    }	
#endif  

#if defined(CONFIG_RTL_SIMPLE_CONFIG)
collect_this_bss:
#endif
	/*
	 * okay, recording this bss...
	 */
	if (priv->site_survey->count >= MAX_BSS_NUM) {
		if (priv->pmib->dot11StationConfigEntry.unassoc_sta_scan_ongoing) { // replace oldest record
			min_record = priv->site_survey->bss_ext[0].time_record;
			for (index = 1; index < MAX_BSS_NUM; index++) {
				if (min_record > priv->site_survey->bss_ext[index].time_record){
					min_idx = index;
					min_record = priv->site_survey->bss_ext[index].time_record;
				}
			}
			index = min_idx;
		} else { // replace record with minimum rssi
			min_record = priv->site_survey->bss[0].rssi;
			for (index = 1; index < MAX_BSS_NUM; index++) {
				if (min_record > priv->site_survey->bss[index].rssi){
					min_idx = index;
					min_record = priv->site_survey->bss[index].rssi;
				}
			}
			index = min_idx;

			if (pfrinfo->rf_info.rssi <= priv->site_survey->bss[index].rssi)
				return 0;

		}
	} else {
		index = priv->site_survey->count;
		priv->site_survey->count++;
	}

	priv->site_survey->bss_ext[index].time_record = jiffies;
	memcpy(priv->site_survey->bss[index].bssid, addr, MACADDRLEN);

	if (hiddenAP) {
		priv->site_survey->bss[index].ssidlen = 0;
		memset((void *)(priv->site_survey->bss[index].ssid),0, 32);
	}
	else {
		p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, _SSID_IE_, &len,
			pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);
		if (p && (len<=32))
		{
			priv->site_survey->bss[index].ssidlen = len;
			memcpy((void *)(priv->site_survey->bss[index].ssid), (void *)(p+2), len);
			/*add for sorting by profile */
			#ifdef WIFI_SIMPLE_CONFIG
			memcpy((void *)(priv->site_survey->wscie[index].ssid), (void *)(p+2), len);
			#endif

			#if defined(WIFI_WPAS) || defined(RTK_NL80211)
			memcpy((void *)(priv->site_survey->rtk_p2p_ie[index].ssid), (void *)(p+2), len);
			#endif
		}
	}
#ifdef CONFIG_RTK_MESH
	// GANTOE for site survey 2008/12/25 ====
	//Mesh ID
	p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, _MESH_ID_IE_, (int *)&len,
		pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);
	if(NULL == p)
	{
		priv->site_survey->bss[index].meshidlen = 0;
		priv->site_survey->bss[index].meshid[0] = '\0';
	}
	else
	{
		priv->site_survey->bss[index].meshidlen = (len > MESH_ID_LEN ? MESH_ID_LEN : len);
		memcpy((void *)(priv->site_survey->bss[index].meshid), (void *)(p + 2), priv->site_survey->bss[index].meshidlen);
	}
#endif

	// we use t_stamp to carry other info so don't get timestamp here
#if 0
	memcpy(&val32, (pframe + WLAN_HDR_A3_LEN), 4);
	priv->site_survey->bss[index].t_stamp[0] = le32_to_cpu(val32);

	memcpy(&val32, (pframe + WLAN_HDR_A3_LEN + 4), 4);
	priv->site_survey->bss[index].t_stamp[1] = le32_to_cpu(val32);
#endif

#ifdef RTK_NL80211
	unsigned long long val64;
	memcpy(&val64, (pframe + WLAN_HDR_A3_LEN), 8);
	priv->site_survey->bss[index].timestamp = le64_to_cpu(val64);
#endif

	memcpy(&val16, (pframe + WLAN_HDR_A3_LEN + 8 ), 2);
	priv->site_survey->bss[index].beacon_prd = le16_to_cpu(val16);

	memcpy(&val16, (pframe + WLAN_HDR_A3_LEN + 8 + 2), 2);
	priv->site_survey->bss[index].capability = le16_to_cpu(val16);

	if ((priv->site_survey->bss[index].capability & BIT(0)) &&
		!(priv->site_survey->bss[index].capability & BIT(1)))
		priv->site_survey->bss[index].bsstype = WIFI_AP_STATE;
	else if (!(priv->site_survey->bss[index].capability & BIT(0)) &&
		(priv->site_survey->bss[index].capability & BIT(1)))
		priv->site_survey->bss[index].bsstype = WIFI_ADHOC_STATE;
	else
		priv->site_survey->bss[index].bsstype = 0;

	p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, _TIM_IE_, &len,
		pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);
	if (p != NULL)
		priv->site_survey->bss[index].dtim_prd = *(p+3);

	priv->site_survey->bss[index].channel = channel;
	priv->site_survey->bss[index].basicrate = basicrate;
	priv->site_survey->bss[index].supportrate = supportrate;

	memcpy(priv->site_survey->bss[index].bdsa, sa, MACADDRLEN);

	priv->site_survey->bss[index].rssi = (unsigned char)pfrinfo->rf_info.rssi;
	priv->site_survey->bss[index].sq = (unsigned char)pfrinfo->rf_info.sq;
	// STADEBUG("%s (%d) - Add BSSID: %02x%02x%02x%02x%02x%02x SSID: %s Channel: %d \n", __FUNCTION__, __LINE__,
	// 	addr[0], addr[1], addr[2], addr[3], addr[4], addr[5],
	// 	(priv->site_survey->bss[index].ssidlen)?priv->site_survey->bss[index].ssid:("hidden ssid"),
	// 	channel);
#ifdef WIFI_SIMPLE_CONFIG
	priv->site_survey->wscie[index].rssi = priv->site_survey->bss[index].rssi;
	priv->site_survey->wscie[index].chan = priv->site_survey->bss[index].channel;
#ifdef CONFIG_RTK_WPS_MESH
	len = 0;
	ptmp = pframe + WLAN_HDR_A3_LEN + _PROBERSP_IE_OFFSET_ ;
	priv->site_survey->wscie[index].mesh_IR = 0;
	for (;;)
	{
		ptmp = get_ie(ptmp, _VENDOR_SPEC_IE_, &len, 
						pfrinfo->pktlen - WLAN_HDR_A3_LEN - _PROBERSP_IE_OFFSET_ - len);
		if (ptmp){
			if (!memcmp(ptmp+2, MESH_VENDOR_OUI, 3)) {
				if(!memcmp(ptmp+2+3 , MESH_VENDOR_VAL, 2)){ 				
					priv->site_survey->wscie[index].mesh_IR = 1; 
					break;					
				}				
			}
		}
		else{
			break;
		}
		ptmp = ptmp + len + 2;
	}
#endif
#endif
	#if defined(WIFI_WPAS) || defined(RTK_NL80211)
		priv->site_survey->rtk_p2p_ie[index].rssi = priv->site_survey->bss[index].rssi;
	#endif

	if (channel >= 36)
		priv->site_survey->bss[index].network |= WIRELESS_11A;
	else {
		if ((basicrate & 0xff0) || (supportrate & 0xff0))
			priv->site_survey->bss[index].network |= WIRELESS_11G;
		if ((basicrate & 0xf) || (supportrate & 0xf))
			priv->site_survey->bss[index].network |= WIRELESS_11B;
	}

	p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, _HT_CAP_, &len,
				pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);
	if ((p !=  NULL) && (len <= sizeof(struct ht_cap_elmt))) {
		struct ht_cap_elmt *ht_cap=(struct ht_cap_elmt *)(p+2);
		if (cpu_to_le16(ht_cap->ht_cap_info) & _HTCAP_SUPPORT_CH_WDTH_)
			priv->site_survey->bss[index].t_stamp[1] |= BIT(1);
		else
			priv->site_survey->bss[index].t_stamp[1] &= ~(BIT(1));
		priv->site_survey->bss[index].network |= WIRELESS_11N;
#if defined(RTK_NL80211)
		memcpy(&priv->site_survey->bss[index].ht_cap, ht_cap, 26);
#endif
	} else {
		priv->site_survey->bss[index].t_stamp[1] &= ~(BIT(1));
	}
#ifdef RTK_AC_SUPPORT
	p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, EID_VHTCapability, &len,
			pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);
	if ((p !=  NULL) && (len <= sizeof(struct vht_cap_elmt))) {
		priv->site_survey->bss[index].network |= WIRELESS_11AC;
	}

	//Check if 80M AP
	p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, EID_VHTOperation, &len,
			pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);

	priv->site_survey->bss[index].t_stamp[1] &= ~(BSS_BW_MASK << BSS_BW_SHIFT);

	if ((p !=  NULL) && (len <= sizeof(struct vht_oper_elmt))) {					
		if (p[2] == 1) {         /* 80M */
			priv->site_survey->bss[index].t_stamp[1] |= (CHANNEL_WIDTH_80 << BSS_BW_SHIFT);
		} else if (p[2] == 2) { /* 160M */
			priv->site_survey->bss[index].t_stamp[1] |= (CHANNEL_WIDTH_80_80 << BSS_BW_SHIFT);
			priv->pmib->dot11nConfigEntry.dot11nComply160M = 1;
			priv->site_survey->bss[index].channel2 = channel + 16;			
		} else if (p[2] == 3) { /* 80+80M */
			priv->site_survey->bss[index].t_stamp[1] |= (CHANNEL_WIDTH_80_80 << BSS_BW_SHIFT);
			priv->pmib->dot11nConfigEntry.dot11nComply160M = 0;
			priv->site_survey->bss[index].channel2 = *(p+4);
		}
	}
#endif
	p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, _HT_IE_, &len,
			pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);

	if ((p !=  NULL) && (len <= sizeof(struct ht_info_elmt))) {
		struct ht_info_elmt *ht_info=(struct ht_info_elmt *)(p+2);
		if (!(ht_info->info0 & _HTIE_STA_CH_WDTH_))
			priv->site_survey->bss[index].t_stamp[1] &= ~(BIT(1)|BIT(2));
		else {
			if ((ht_info->info0 & _HTIE_2NDCH_OFFSET_BL_) == _HTIE_2NDCH_OFFSET_NO_)
				priv->site_survey->bss[index].t_stamp[1] &= ~(BIT(1)|BIT(2));
			else
			if ((ht_info->info0 & _HTIE_2NDCH_OFFSET_BL_) == _HTIE_2NDCH_OFFSET_BL_)
				priv->site_survey->bss[index].t_stamp[1] |= BIT(2);
			else
				priv->site_survey->bss[index].t_stamp[1] &= ~(BIT(2));
		}
#if defined(RTK_NL80211)
		memcpy(&priv->site_survey->bss[index].ht_info, ht_info, 22);
#endif
	}
	else
		priv->site_survey->bss[index].t_stamp[1] &= ~(BIT(1)|BIT(2));

	// get WPA/WPA2 information
	get_security_info(priv, pfrinfo, index);
	
	if ((priv->site_survey->bss[index].network & WIRELESS_11N) 	/* HT-INFO is presented */
		&& (is_wep_encryption(priv->site_survey->bss[index].capability, priv->site_survey->bss[index].t_stamp[0]))	/* encrytion wep */
	) {
		priv->site_survey->bss[index].network &= ~WIRELESS_11N;	
	}

	// Parse Multi Stage Element
	p = pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_; len = 0;
	for (;;)
	{
		unsigned char oui[] = { 0x00, 0x0d, 0x02 };
		unsigned char oui_type =7, ver1 = 0x01, ver2 = 0x00;
		p = get_ie(p, _RSN_IE_1_, &len,
			pfrinfo->pktlen - (p - pframe));
		if (p != NULL) {
			if (!memcmp(p+2, oui, 3) && (*(p+2+3) == oui_type)) {
				if ( (*(p+2+4) == ver1) && (*(p+2+5) == ver2))
				{	
					switch(*(p+2+6)) {
						case 0x80: priv->site_survey->bss[index].stage = 1; 
									break;
						case 0x40: priv->site_survey->bss[index].stage = 2;
									break;						
						case 0x20: priv->site_survey->bss[index].stage = 3; 
									break;
						case 0x10: priv->site_survey->bss[index].stage = 4; 
									break;
						case 0x08: priv->site_survey->bss[index].stage = 5; 
									break;
						default:
							priv->site_survey->bss[index].stage = 0;		
					};
				} else {
					priv->site_survey->bss[index].stage = 0;
				}
				break;
			}
		}
		else
			break;
		p = p + len + 2;
	}

    #if defined( P2P_SUPPORT	) && defined(RTK_NL80211)
    /*Get P2P IE*/ 
    if(rtk_p2p_is_enabled(priv)){
        priv->site_survey->rtk_p2p_ie[index].p2p_ie_len=0;

        if(p2pIEPtr){
           memcpy(priv->site_survey->rtk_p2p_ie[index].data , p2pIEPtr , p2pIElen); 
           
           priv->site_survey->rtk_p2p_ie[index].p2p_ie_len = p2pIElen;
           
           NDEBUG2("P2P IE LEN[%d],index[%d]\n",p2pIElen,index);
        }
    }	
    #endif
			/*cfg p2p*/
#ifdef WDS
	if (priv->pmib->dot11WdsInfo.wdsEnabled && priv->pmib->dot11WdsInfo.wdsNum) {
		// look for ERP rate. if no ERP rate existed, thought it is a legacy AP
		unsigned char supportedRates[32];
		int supplen=0;

		struct stat_info *pstat = get_stainfo(priv, GetAddr2Ptr(pframe));
		if (pstat && (pstat->state & WIFI_WDS)) {
			p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_,
					_SUPPORTEDRATES_IE_, &len,
					pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);
			if (p) {
				if (len>8)
					len=8;
				memcpy(&supportedRates[supplen], p+2, len);
				supplen += len;
			}

			p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_,
					_EXT_SUPPORTEDRATES_IE_, &len,
					pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);
			if (p) {
				if (len > sizeof(supportedRates)-supplen)
					len = sizeof(supportedRates)-supplen;
				memcpy(&supportedRates[supplen], p+2, len);
				supplen += len;
			}

			get_matched_rate(priv, supportedRates, &supplen, 0, sizeof(supportedRates));
			update_support_rate(pstat, supportedRates, supplen);
			if (supplen == 0)
				pstat->current_tx_rate = 0;
			else {
				if (priv->pmib->dot11WdsInfo.entry[pstat->wds_idx].txRate == 0) {
					pstat->current_tx_rate = find_rate(priv, pstat, 1, 0);
					//pstat->upper_tx_rate = 0;	// unused
				}
			}

			// Customer proprietary IE
			if (priv->pmib->miscEntry.private_ie_len) {
				p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_,
					priv->pmib->miscEntry.private_ie[0], &len,
					pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);
				if ((p) && (len+2 <= sizeof(pstat->private_ie))) {
					memcpy(pstat->private_ie, p, len + 2);
					pstat->private_ie_len = len + 2;
				}
			}

			// Realtek proprietary IE
			pstat->is_realtek_sta = FALSE;
			pstat->IOTPeer = HT_IOT_PEER_UNKNOWN;			
			p = pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_; len = 0;
			for (;;) {
				p = get_ie(p, _RSN_IE_1_, &len,
					pfrinfo->pktlen - (p - pframe));
				if (p != NULL) {
					if (!memcmp(p+2, Realtek_OUI, 3) && *(p+2+3) == 2) { /*found realtek out and type == 2*/
                        pstat->is_realtek_sta = TRUE;
                        pstat->IOTPeer = HT_IOT_PEER_REALTEK;

                        if (*(p+2+3+2) & RTK_CAP_IE_USE_AMPDU)
                            pstat->is_forced_ampdu = TRUE;
                        else
                            pstat->is_forced_ampdu = FALSE;

#ifdef RTK_WOW
                        if (*(p+2+3+2) & RTK_CAP_IE_USE_WOW)
                            pstat->IOTPeer = HT_IOT_PEER_REALTEK_WOW;
#endif
                        if (*(p+2+3+2) & RTK_CAP_IE_WLAN_8192SE)
                            pstat->IOTPeer = HT_IOT_PEER_REALTEK_92SE;
                        if (*(p+2+3+2) & RTK_CAP_IE_WLAN_88C92C)
                            pstat->IOTPeer = HT_IOT_PEER_REALTEK_81XX;

                        if (*(p+2+3+3) & ( RTK_CAP_IE_8812_BCUT | RTK_CAP_IE_8812_CCUT))
                            pstat->IOTPeer = HT_IOT_PEER_REALTEK_8812;

                        if (*(p+2+3+2) & RTK_CAP_IE_AP_CLIENT)
                            pstat->IOTPeer = HT_IOT_PEER_RTK_APCLIENT;
						break;
					}
				}
				else
					break;

				p = p + len + 2;
			}

#ifdef WIFI_WMM
			if (QOS_ENABLE) {
				p = pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_;
				for (;;) {
					p = get_ie(p, _RSN_IE_1_, &len,
							pfrinfo->pktlen - (p - pframe));
					if (p != NULL) {
						if (!memcmp(p+2, WMM_PARA_IE, 6)) {
							pstat->QosEnabled = 1;
							break;
						}
					}
					else {
						pstat->QosEnabled = 0;
						break;
					}
					p = p + len + 2;
				}
			}
#endif
			if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11N) {
				p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, _HT_CAP_, &len,
					pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);
				if ((p !=  NULL) && (len <= sizeof(struct ht_cap_elmt))) {
					pstat->ht_cap_len = len;
					memcpy((unsigned char *)&pstat->ht_cap_buf, p+2, len);
					if (cpu_to_le16(pstat->ht_cap_buf.ht_cap_info) & _HTCAP_AMSDU_LEN_8K_) {
						pstat->is_8k_amsdu = 1;
						pstat->amsdu_level = 7935 - sizeof(struct wlan_hdr);
					}
					else {
						pstat->is_8k_amsdu = 0;
						pstat->amsdu_level = 3839 - sizeof(struct wlan_hdr);
					}
				}
				else
					pstat->ht_cap_len = 0;
			}
			if (pstat->ht_cap_buf.ht_cap_info & cpu_to_le16(_HTCAP_SUPPORT_CH_WDTH_))
				pstat->tx_bw = CHANNEL_WIDTH_40;
			else
				pstat->tx_bw = CHANNEL_WIDTH_20;

#if defined(RTK_AC_SUPPORT) || defined(RTK_AC_TX_SUPPORT)
		//WDS-VHT support
			if ((priv->pmib->dot11BssType.net_work_type & WIRELESS_11AC) || priv->pshare->phw->is_AC_TX_support)
			{
				p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, EID_VHTCapability, &len,
						pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);

				if ((p !=  NULL) && (len <= sizeof(struct vht_cap_elmt))) {
					pstat->vht_cap_len = len;
					memcpy((unsigned char *)&pstat->vht_cap_buf, p+2, len);
					//WDEBUG("vht_cap len = %d \n",len);		
					//WDEBUG("vht_cap vht_cap_info:%04X \n",pstat->vht_cap_buf.vht_cap_info);	
					//WDEBUG("vht_cap vht_support_mcs[0]=[%04X] ; vht_support_mcs[1]=[%04X] \n", pstat->vht_cap_buf.vht_support_mcs[0],pstat->vht_cap_buf.vht_support_mcs[1]);					
				}

				p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, EID_VHTOperation, &len,
						pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);

				if ((p !=  NULL) && (len <= sizeof(struct vht_oper_elmt))) {
					pstat->vht_oper_len = len;
					memcpy((unsigned char *)&pstat->vht_oper_buf, p+2, len);
					//WDEBUG("vht_oper len = %d \n",len);
					//WDEBUG("vht_oper: 0[%02x],1[%02x],2[%02x] \n",pstat->vht_oper_buf.vht_oper_info[0],pstat->vht_oper_buf.vht_oper_info[1],pstat->vht_oper_buf.vht_oper_info[2]);						
					//WDEBUG("vht_oper [%02X]\n",pstat->vht_oper_buf.vht_basic_msc);					
				}


				if ((pstat->vht_cap_len))	{
					switch(cpu_to_le32(pstat->vht_cap_buf.vht_cap_info) & 0x3) {
						default:
						case 0:	
							pstat->is_8k_amsdu = 0;
							pstat->amsdu_level = 3895 - sizeof(struct wlan_hdr);
							break;
						case 1:
							pstat->is_8k_amsdu = 1;
							pstat->amsdu_level = 7991 - sizeof(struct wlan_hdr);
							break;
						case 2:	
							pstat->is_8k_amsdu = 1;
							pstat->amsdu_level = 11454 - sizeof(struct wlan_hdr);	
							break;
					}

					if ((priv->vht_oper_buf.vht_oper_info[0] == 1) && (pstat->vht_oper_buf.vht_oper_info[0] == 1)) {
						pstat->tx_bw = CHANNEL_WIDTH_80;
						priv->pshare->is_40m_bw	= CHANNEL_WIDTH_80;	
						//WDEBUG("pstat->tx_bw=80M\n");
					} else if ((priv->vht_oper_buf.vht_oper_info[0] == 2) && (pstat->vht_oper_buf.vht_oper_info[0] == 2)) {
						pstat->tx_bw = CHANNEL_WIDTH_80_80;
						priv->pshare->is_40m_bw	= CHANNEL_WIDTH_80_80;
						priv->pmib->dot11nConfigEntry.dot11nComply160M = 1;
						//WDEBUG("pstat->tx_bw=160M\n");
					} else if ((priv->vht_oper_buf.vht_oper_info[0] == 3) && (pstat->vht_oper_buf.vht_oper_info[0] == 3)) {
						pstat->tx_bw = CHANNEL_WIDTH_80_80;
						priv->pshare->is_40m_bw	= CHANNEL_WIDTH_80_80;
						priv->pmib->dot11nConfigEntry.dot11nComply160M = 0;
						//WDEBUG("pstat->tx_bw=80+80M\n");
					}
				}

				p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, EID_VHTOperatingMode, &len,
					pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);
				if ((p !=  NULL) && (len == 1)) {
						// check self capability....					
						if((p[2] &3) <= priv->pmib->dot11nConfigEntry.dot11nUse40M)
							pstat->tx_bw = p[2] &3;
						pstat->nss = ((p[2]>>4)&0x7)+1;											
						printk("[%s %d]receive opering mode data = %02X \n",__FUNCTION__,__LINE__ ,p[2]);
				}				
			
			}
#endif			
#if defined(CONFIG_RTL_8812_SUPPORT) || defined(CONFIG_RTL_8723B_SUPPORT)
			if(GET_CHIP_VER(priv)== VERSION_8812E || GET_CHIP_VER(priv)== VERSION_8723B){
				UpdateHalRAMask8812(priv, pstat, 3);
				//WDEBUG("UpdateHalRAMask8812\n");
			}
#endif
#ifdef  CONFIG_WLAN_HAL
			if (IS_HAL_CHIP(priv)){
				init_rainfo(priv, pstat);
			}
#endif
		}
	}
#endif

#ifdef WIFI_WMM  //  WMM STA
	if (QOS_ENABLE) {  // get WMM IE / WMM Parameter IE
		p = pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_;
		for (;;) {
			p = get_ie(p, _RSN_IE_1_, &len,
				pfrinfo->pktlen - (p - pframe));
			if (p != NULL) {
				if ((!memcmp(p+2, WMM_IE, 6)) || (!memcmp(p+2, WMM_PARA_IE, 6))) {
					priv->site_survey->bss[index].t_stamp[1] |= BIT(0);  //  set t_stamp[1] bit 0 when AP supports WMM
#if defined(CLIENT_MODE) && defined(WMM_APSD)
					if ((OPMODE & WIFI_STATION_STATE) && APSD_ENABLE) {
						if (!memcmp(p+2, WMM_PARA_IE, 6)) {
							if (*(p+8) & BIT(7))
								priv->site_survey->bss[index].t_stamp[1] |= BIT(3);  //  set t_stamp[1] bit 3 when AP supports UAPSD
							else
								priv->site_survey->bss[index].t_stamp[1] &= ~(BIT(3));  //  reset t_stamp[1] bit 3 when AP not support UAPSD
							break;
						} else {
							priv->site_survey->bss[index].t_stamp[1] &= ~(BIT(3));  //  reset t_stamp[1] bit 3 when AP not support UAPSD
						}
					} else
#endif
						break;
				}
			} else {
				priv->site_survey->bss[index].t_stamp[1] &= ~(BIT(0));  //  reset t_stamp[1] bit 0 when AP not support WMM
#if defined(CLIENT_MODE) && defined(WMM_APSD)
				if ((OPMODE & WIFI_STATION_STATE) && APSD_ENABLE)
					priv->site_survey->bss[index].t_stamp[1] &= ~(BIT(3));  //  reset t_stamp[1] bit 3 when AP not support UAPSD
#endif
				break;
			}
			p = p + len + 2;
		}
	}
#endif

#ifdef CONFIG_IEEE80211V_CLI
	if(WNM_ENABLE) {
		unsigned char ext_cap[8];
		memset(ext_cap, 0, 8);
		p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, _EXTENDED_CAP_IE_, &len,
				pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);
		if(p != NULL) {
			memcpy(ext_cap, p+2, 8);
			if(ext_cap[2] & _WNM_BSS_TRANS_SUPPORT_) {
				priv->site_survey->bss[index].t_stamp[1] |= BSS_TRANS_SUPPORT;	
			}
		}
	} 
#endif

#if defined(WIFI_WPAS) || defined(RTK_NL80211) || defined(CONFIG_RTL_COMAPI_WLTOOLS)
			priv->site_survey->bss[index].rsn_ie_len = 0;			/*cfg p2p cfg p2p*/
			priv->site_survey->bss[index].wpa_ie_len = 0;			/*cfg p2p cfg p2p*/

			p = pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_;
			p = get_ie(p, _RSN_IE_2_, &len,
				pfrinfo->pktlen - (p - pframe));
			if ((p != NULL) && (len > 7)) {
				if (len+2 > 256) {
					DEBUG_ERR("[%s] truncate IE len (%d) to avoid buffer overrun\n", __func__, len);
				} else {
					priv->site_survey->bss[index].rsn_ie_len = len + 2;			/*cfg p2p cfg p2p*/
					memcpy(priv->site_survey->bss[index].rsn_ie , p, len + 2);			/*cfg p2p cfg p2p*/
				}
			}

			len = 0;
			p = pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_;
			do {
				p = get_ie(p, _RSN_IE_1_, &len,
					pfrinfo->pktlen - (p - pframe));
				if ((p != NULL) && (len > 11) 			/*cfg p2p cfg p2p*/
					 && (!memcmp((p + 2), OUI1, 4)) ) {
					if (len+2 > 256) {
						DEBUG_ERR("[%s] truncate IE len (%d) to avoid buffer overrun\n", __func__, len);
				 	} else {
						priv->site_survey->bss[index].wpa_ie_len = len+2;
						memcpy(priv->site_survey->bss[index].wpa_ie, p, len + 2);
			 		}
				}			/*cfg p2p cfg p2p*/
				if (p != NULL)
					p = p + 2 + len;
			} while (p != NULL);

#endif


#if defined(CONFIG_RTL_SIMPLE_CONFIG)
	{
			if(!memcmp(priv->pmib->dot11StationConfigEntry.dot11DesiredBssid, sa, 6)) {
				int bss_bw = CHANNEL_WIDTH_40;
				int bss_offset = 0;			
	
#ifdef RTK_AC_SUPPORT			
				if(GET_CHIP_VER(priv)==VERSION_8812E || GET_CHIP_VER(priv)==VERSION_8881A){
					if((priv->site_survey->bss[index].t_stamp[1] & (BSS_BW_MASK << BSS_BW_SHIFT)) 
					== (CHANNEL_WIDTH_80 << BSS_BW_SHIFT))
					bss_bw = CHANNEL_WIDTH_80;									
				}
#endif
	
				if ((priv->site_survey->bss[index].t_stamp[1] & (BIT(1) | BIT(2))) == (BIT(1) | BIT(2)))
					bss_offset = HT_2NDCH_OFFSET_BELOW;
				else if ((priv->site_survey->bss[index].t_stamp[1] & (BIT(1) | BIT(2))) == BIT(1))
					bss_offset = HT_2NDCH_OFFSET_ABOVE;
				else { 
					if (priv->pmib->dot11nConfigEntry.dot11nUse40M == CHANNEL_WIDTH_10)
						bss_bw = CHANNEL_WIDTH_10;
					else if (priv->pmib->dot11nConfigEntry.dot11nUse40M == CHANNEL_WIDTH_5)
						bss_bw = CHANNEL_WIDTH_5;
					else
						bss_bw = CHANNEL_WIDTH_20;	
			
					bss_offset = HT_2NDCH_OFFSET_DONTCARE;
				}
	
		
				if(channel){
					
					if(priv->simple_config_could_fix)
					if(priv->simple_config_status == 2 || priv->simple_config_status == 3) {
							
						if(priv->pmib->dot11StationConfigEntry.sc_fix_channel == 0) {
							if(priv->pmib->dot11StationConfigEntry.sc_debug)
								panic_printk("Simple Config switch to remote AP's channel %d BW %d Offset %d\n", 
								channel, bss_bw, bss_offset);
											
							//sync channel
   							priv->pmib->dot11RFEntry.dot11channel = channel;

    						//sync bw
    						priv->pmib->dot11nConfigEntry.dot11nUse40M = bss_bw;
   							priv->pshare->CurrentChannelBW = bss_bw;
    						priv->pshare->is_40m_bw = bss_bw; 

    						//sync offset
    						priv->pmib->dot11nConfigEntry.dot11n2ndChOffset = bss_offset;
    						priv->pshare->offset_2nd_chan =  bss_offset;					

							SwBWMode(priv, bss_bw, bss_offset);
							SwChnl(priv, channel, bss_offset);
							
							rtk_sc_set_value(SC_FIX_CHANNEL, channel);
							priv->pmib->dot11StationConfigEntry.sc_fix_bw = bss_bw;
							priv->pmib->dot11StationConfigEntry.sc_fix_offset = bss_offset;
							
						}
										
						//if(priv->simple_config_status == 3)
						//	rtk_sc_check_security(priv, &(priv->site_survey->bss[index]));
						if(priv->pmib->dot11StationConfigEntry.sc_fix_encrypt == 0)
						{
							rtk_sc_check_security(priv, &(priv->site_survey->bss[index]));
							memcpy(&pmib->dot11Bss, &(priv->site_survey->bss[index]), sizeof(struct bss_desc));							
						}
					}
		
				}
				
			}
	}
#endif

	/*now we report beacon/probe_resp whole frame to wpas*/
	if (pfrinfo->pktlen <= PROBE_FRAME_SIZE) {
		memcpy(priv->site_survey->bss_ext[index].WholeFrame,pframe,pfrinfo->pktlen);
		priv->site_survey->bss_ext[index].WholeFrameLength = pfrinfo->pktlen;
	} else {
		priv->site_survey->bss_ext[index].WholeFrame[0] = '\0';
		priv->site_survey->bss_ext[index].WholeFrameLength = 0;
	}

	return SUCCESS;
}


void assign_tx_rate(struct rtl8192cd_priv *priv, struct stat_info *pstat, struct rx_frinfo *pfrinfo)
{
	int tx_rate=0;
	UINT8 rate;
	int auto_rate;

#ifdef WDS
	if (pstat->state & WIFI_WDS) {
		auto_rate =	(priv->pmib->dot11WdsInfo.entry[pstat->wds_idx].txRate==0) ? 1: 0;
		tx_rate = priv->pmib->dot11WdsInfo.entry[pstat->wds_idx].txRate;
	}
	else
#endif
	{
		auto_rate = priv->pmib->dot11StationConfigEntry.autoRate;
		tx_rate = priv->pmib->dot11StationConfigEntry.fixedTxRate;
	}

	if (auto_rate || 
#ifdef RTK_AC_SUPPORT
		(is_fixedVHTTxRate(priv, pstat) && !(pstat->vht_cap_len)) ||
#endif
		(should_restrict_Nrate(priv, pstat) && is_fixedMCSTxRate(priv, pstat))) {
#if 0
		// if auto rate, select highest or lowest rate depending on rssi
		if (pfrinfo && pfrinfo->rf_info.rssi > 30)
			pstat->current_tx_rate = find_rate(priv, pstat, 1, 0);
		else
			pstat->current_tx_rate = find_rate(priv, pstat, 0, 0);
#endif
		pstat->current_tx_rate = find_rate(priv, pstat, 1, 0);
	}
	else {
		// see if current fixed tx rate of mib is existed in supported rates set
		rate = get_rate_from_bit_value(tx_rate);
		if (match_supp_rate(pstat->bssrateset, pstat->bssratelen, rate))
			tx_rate = (int)rate;
		if (tx_rate == 0) // if not found, use highest supported rate for current tx rate
			tx_rate = find_rate(priv, pstat, 1, 0);

#if	defined(CONFIG_RTL_8812_SUPPORT) || defined(CONFIG_WLAN_HAL_8881A) || defined(CONFIG_WLAN_HAL_8814AE) || defined(CONFIG_RTL_8723B_SUPPORT) || defined(CONFIG_WLAN_HAL_8822BE) || defined(CONFIG_WLAN_HAL_8822CE) || defined(CONFIG_WLAN_HAL_8821CE) || defined(CONFIG_WLAN_HAL_8812FE) || defined(CONFIG_WLAN_HAL_8814BE)
		if((GET_CHIP_VER(priv)== VERSION_8812E)||(GET_CHIP_VER(priv)== VERSION_8881A)||(GET_CHIP_VER(priv)== VERSION_8814A) || (GET_CHIP_VER(priv)== VERSION_8723B) || (GET_CHIP_VER(priv)== VERSION_8822B) || (GET_CHIP_VER(priv)== VERSION_8822C) || (GET_CHIP_VER(priv)== VERSION_8821C) || (GET_CHIP_VER(priv)== VERSION_8812F) || (GET_CHIP_VER(priv)== VERSION_8814B)){
			pstat->current_tx_rate = rate;
		}else
#endif
		{
			pstat->current_tx_rate = tx_rate;
		}
// ToDo: 
// fixed 2T rate, but STA is 1R...		
	}

	if ((pstat->MIMO_ps & _HT_MIMO_PS_STATIC_) && is_2T_rate(pstat->current_tx_rate)) {
#ifdef RTK_AC_SUPPORT
		if( is_VHT_rate(pstat->current_tx_rate)){
			pstat->current_tx_rate = _NSS1_MCS9_RATE_;
		}else
#endif
		{
			pstat->current_tx_rate = _MCS7_RATE_;	// when HT MIMO Static power save is set and rate > MCS7, fix rate to MCS7
		}
	}

	if (pfrinfo)
		pstat->rssi = pfrinfo->rf_info.rssi;	// give the initial value to pstat->rssi

	pstat->ht_current_tx_info = 0;
	if ((priv->pmib->dot11BssType.net_work_type & WIRELESS_11N) && pstat->ht_cap_len) {
		if (priv->pshare->is_40m_bw && ((pstat->tx_bw == CHANNEL_WIDTH_40)||(pstat->tx_bw == CHANNEL_WIDTH_80))) {
			pstat->ht_current_tx_info |= TX_USE_40M_MODE;
			if (priv->pmib->dot11nConfigEntry.dot11nShortGIfor40M &&
				(pstat->ht_cap_buf.ht_cap_info & cpu_to_le16(_HTCAP_SHORTGI_40M_)))
				pstat->ht_current_tx_info |= TX_USE_SHORT_GI;
		}
		else {
			if (priv->pmib->dot11nConfigEntry.dot11nShortGIfor20M &&
				(pstat->ht_cap_buf.ht_cap_info & cpu_to_le16(_HTCAP_SHORTGI_20M_)))
				pstat->ht_current_tx_info |= TX_USE_SHORT_GI;
		}
	}

#ifdef SW_TXQ_ATF
#ifdef RTK_AC_SUPPORT
	if (pstat->current_tx_rate >= VHT_RATE_ID) {
		pstat->swq.atf_txrate = query_vht_rate(pstat);
	}
	else
#endif
	if (is_MCS_rate(pstat->current_tx_rate)) {
		unsigned char *rate;
		rate = (unsigned char *)MCS_DATA_RATEStr[(pstat->ht_current_tx_info&BIT(0))?1:0][(pstat->ht_current_tx_info&BIT(1))?1:0][(pstat->current_tx_rate - HT_RATE_ID)];
		pstat->swq.atf_txrate = _atoi(rate, 10);
	} else {
		pstat->swq.atf_txrate = pstat->current_tx_rate / 2;
	}
	pstat->swq.atf_base_quota =  priv->pshare->rf_ft_var.swq_atf_base_qta;   // set the default value
#endif /* SW_TXQ_ATF */

	if (priv->pshare->rf_ft_var.rssi_dump && pfrinfo)
	{
#ifdef  RTK_AC_SUPPORT	
		if(is_VHT_rate(pstat->current_tx_rate))
			printk("[%d] rssi=%d%% assign rate %s%d %d\n", pstat->cmn_info.aid, pfrinfo->rf_info.rssi,
					"VHT NSS", (((pstat->current_tx_rate-VHT_RATE_ID)/10)+1), ((pstat->current_tx_rate-VHT_RATE_ID)%10));
		else
#endif
			printk("[%d] rssi=%d%% assign rate %s%d\n", pstat->cmn_info.aid, pfrinfo->rf_info.rssi,
					is_MCS_rate(pstat->current_tx_rate)? "MCS" : "",
					is_MCS_rate(pstat->current_tx_rate)? (pstat->current_tx_rate-HT_RATE_ID) : pstat->current_tx_rate/2);
	}
}


// Assign aggregation method automatically.
// We according to the following rule:
// 1. Rtl8190: AMPDU
// 2. Broadcom: AMSDU
// 3. Station who supports only 4K AMSDU receiving: AMPDU
// 4. Others: AMSDU

#if (defined(RTK_AC_SUPPORT) || defined(RTK_AC_TX_SUPPORT)) && defined(SUPPORT_TX_AMSDU)
unsigned int amsduUpperTP(struct rtl8192cd_priv *priv, struct stat_info *pstat)
{
	unsigned int baseTP;
	u1Byte              rf_mimo_mode    = get_rf_mimo_mode(priv);
	u1Byte				mimo_mode;
	
	if(priv->pshare->CurrentChannelBW==CHANNEL_WIDTH_80)
		baseTP = 433*priv->pshare->rf_ft_var.amsdu_th/100;	//80M NSS1 MCS9  
	else if (priv->pshare->CurrentChannelBW==CHANNEL_WIDTH_40)
		baseTP = 200*priv->pshare->rf_ft_var.amsdu_th/100;  //40M NSS1 MCS9 
	else
		baseTP = 87*priv->pshare->rf_ft_var.amsdu_th/100;   //20M NSS1 MCS8 

	if (get_rf_NTx(pstat->sta_mimo_mode) > get_rf_NTx(rf_mimo_mode))		
		mimo_mode = rf_mimo_mode;
	else
		mimo_mode = pstat->sta_mimo_mode;
	
	if(mimo_mode == RF_4T4R)
		return 4*baseTP;
	else if(mimo_mode == RF_3T3R)
		return 3*baseTP;
	else if(mimo_mode == RF_2T2R)
		return 2*baseTP;
	else  // (mimo_mode == RF_1T1R)
		return baseTP;
}

unsigned int amsduLowerTP(struct rtl8192cd_priv *priv, struct stat_info *pstat)
{
	unsigned int baseTP;
	u1Byte              rf_mimo_mode    = get_rf_mimo_mode(priv);
	u1Byte				mimo_mode;
	
	if(priv->pshare->CurrentChannelBW==CHANNEL_WIDTH_80)
		baseTP = 433*priv->pshare->rf_ft_var.amsdu_th2/100;	//80M NSS1 MCS9  
	else if (priv->pshare->CurrentChannelBW==CHANNEL_WIDTH_40)
		baseTP = 200*priv->pshare->rf_ft_var.amsdu_th2/100;  //40M NSS1 MCS9 
	else
		baseTP = 87*priv->pshare->rf_ft_var.amsdu_th2/100;   //20M NSS1 MCS8 
		
	if (get_rf_NTx(pstat->sta_mimo_mode) > get_rf_NTx(rf_mimo_mode))		
		mimo_mode = rf_mimo_mode;
	else
		mimo_mode = pstat->sta_mimo_mode;

	if(mimo_mode == RF_4T4R)
		return 4*baseTP;
	else if(mimo_mode == RF_3T3R)
		return 3*baseTP;
	else if(mimo_mode == RF_2T2R)
		return 2*baseTP;
	else  // (mimo_mode == RF_1T1R)
		return baseTP;
}
#endif

#if (MU_BEAMFORMING_SUPPORT == 1)
int mu_amsdu_condition(struct rtl8192cd_priv *priv, struct stat_info *pstat)
{
    int ret = 0, i;
    struct stat_info *mu_pstat;
    int amsdu_th = priv->pshare->rf_ft_var.mutp_th_up;
    
    if (priv->pshare->rf_ft_var.mu_amsdu &&
        pstat->muPartner_num && 
        pstat->AMSDU_AMPDU_support &&
        (pstat->tx_avarage >> 17) > amsdu_th) {
        for (i = 0; i < pstat->muPartner_num; i++) {
            mu_pstat = pstat->muPartner[i];
            if (mu_pstat->muPartner_num &&
                mu_pstat->AMSDU_AMPDU_support &&
                (mu_pstat->tx_avarage >> 17) > amsdu_th)
                ;
            else
                break;
        }

        if (i == pstat->muPartner_num)
            ret = 1;
    }

    return ret;
}
#endif

void assign_aggre_mthod(struct rtl8192cd_priv *priv, struct stat_info *pstat)
{
	unsigned int txpkts = pstat->tx_pkts2 - pstat->tx_pkts2_pre - (pstat->tx_fail - pstat->tx_fail_pre);
	unsigned int assoc_num = (priv->assoc_num ? priv->assoc_num:1);
	unsigned int amsdu_pkt_th, amsdu_pkt_th2;
#if (MU_BEAMFORMING_SUPPORT == 1)
	PRT_BEAMFORMING_INFO pBeamInfo = &(priv->pshare->BeamformingInfo);
#endif

	if ((priv->pmib->dot11BssType.net_work_type & WIRELESS_11N) && pstat->ht_cap_len
#ifdef WDS
			&& (pstat->state & (WIFI_ASOC_STATE | WIFI_WDS))
#else
			&& (pstat->state & WIFI_ASOC_STATE)
#endif
			&& (get_sta_encrypt_algthm(priv, pstat) != _TKIP_PRIVACY_)) {
		if ((AMPDU_ENABLE) && (AMSDU_ENABLE >= 2)) {
#ifdef A4_STA
			if ((OPMODE & WIFI_STATION_STATE) && priv->pmib->miscEntry.a4_enable && (pstat->state & WIFI_A4_STA))
				pstat->aggre_mthd = AGGRE_MTHD_MPDU;
			else
#endif
#ifdef SUPPORT_TX_AMSDU
			if (pstat->AMSDU_AMPDU_support & STA_RX_AMSDU_SUPPORT) {
#if defined(RTK_AC_SUPPORT) || defined(RTK_AC_TX_SUPPORT)//for 11ac logo
				if (pstat->vht_cap_len || priv->pshare->phw->is_AC_TX_support) {
					amsdu_pkt_th = ((pstat->IOTPeer==HT_IOT_PEER_BROADCOM)? priv->pshare->rf_ft_var.brcm_amsdu_pkt_th: priv->pshare->rf_ft_var.amsdu_pkt_th) / assoc_num;
					amsdu_pkt_th2 = ((pstat->IOTPeer==HT_IOT_PEER_BROADCOM)? priv->pshare->rf_ft_var.brcm_amsdu_pkt_th2 : priv->pshare->rf_ft_var.amsdu_pkt_th2) / assoc_num;
#ifdef WDS
					if(pstat->state & (WIFI_WDS | WIFI_ADHOC_STATE)){
						pstat->aggre_mthd = AGGRE_MTHD_MPDU;
					} else
#endif
					{
#if (MU_BEAMFORMING_SUPPORT == 1)
						if(priv->pmib->dot11RFEntry.disable_mu_amsdu && pstat->muFlagForAMSDU) {
							pstat->aggre_mthd = AGGRE_MTHD_MPDU;
							pstat->amsdu_defer_to = 0;
							pstat->muFlagForAMSDU = 0;
						} else
#endif
						if(/*(pstat->aggre_mthd != AGGRE_MTHD_MPDU_AMSDU) &&*/
							priv->pshare->rf_ft_var.mustAmsdu == 1
							|| (((pstat->tx_avarage >> 17) >= amsduUpperTP(priv, pstat))
							|| txpkts > amsdu_pkt_th)
#if (MU_BEAMFORMING_SUPPORT == 1)
							|| mu_amsdu_condition(priv, pstat)
#endif
							) {
							//printk("TP:%d Mbps --> amsdu mode\n", (pstat->tx_avarage >> 17));
							pstat->aggre_mthd = AGGRE_MTHD_MPDU_AMSDU;
							pstat->amsdu_defer_to = 30;
							#if defined(CONFIG_WLAN_HAL_8822BE)|| defined(CONFIG_WLAN_HAL_8812FE)
							if((GET_CHIP_VER(priv) == VERSION_8822B) || (GET_CHIP_VER(priv) == VERSION_8812F)) {
								pstat->maxAggNum = (pstat->maxAggNumOrig >> 1);
							}
							#endif
							#if defined(CONFIG_WLAN_HAL_8814BE) 
								if(GET_CHIP_VER(priv) == VERSION_8814B){
     									       
									 if(priv->pmib->dot11nConfigEntry.dot11nCurAMSDUSendNum==3)
										  pstat->maxAggNum = 42;
									 else if (priv->pmib->dot11nConfigEntry.dot11nCurAMSDUSendNum==4)
										  pstat->maxAggNum = 32;
										
								}		
							#endif

						} else if((pstat->aggre_mthd == AGGRE_MTHD_MPDU_AMSDU) &&
							(((pstat->tx_avarage >> 17) < amsduLowerTP(priv, pstat)) && txpkts < amsdu_pkt_th2)) {
							//printk("TP:%d Mbps --> ampdu mode\n", (pstat->tx_avarage >> 17));
#ifdef CONFIG_SPECIAL_ENV_TEST
							if(pstat->amsdu_defer_to <= 0){
								pstat->aggre_mthd = AGGRE_MTHD_MPDU;
								pstat->amsdu_defer_to = 0;
							} else if (priv->pshare->in_spec_env_test_to){
								pstat->amsdu_defer_to--;
							} else
#endif
							{
								pstat->aggre_mthd = AGGRE_MTHD_MPDU;
								pstat->amsdu_defer_to = 0;
							}

							#if defined(CONFIG_WLAN_HAL_8822BE) || defined(CONFIG_WLAN_HAL_8814BE)|| defined(CONFIG_WLAN_HAL_8812FE)
							if((GET_CHIP_VER(priv) == VERSION_8822B) || (GET_CHIP_VER(priv) == VERSION_8814B) ||(GET_CHIP_VER(priv) == VERSION_8812F)) {
								pstat->maxAggNum = pstat->maxAggNumOrig;
							}
							#endif
						} else if (pstat->aggre_mthd == AGGRE_MTHD_NONE) {
							pstat->aggre_mthd = AGGRE_MTHD_MPDU;
							pstat->amsdu_defer_to = 0;
						}
					}
				}
				else
#endif // RTK_AC_SUPPORT
				{
					//11N AMSDU
					//small size packet will trigger amsdu_ampdu when pkt num is bigger than threshold
					amsdu_pkt_th = (pstat->tx_bw ? (priv->pshare->rf_ft_var.amsdu_pkt_th): (priv->pshare->rf_ft_var.amsdu_pkt_th>>1)) / assoc_num;
					amsdu_pkt_th2 = (pstat->tx_bw ? (priv->pshare->rf_ft_var.amsdu_pkt_th2) : (priv->pshare->rf_ft_var.amsdu_pkt_th2>>1)) / assoc_num;

					if (pstat->current_tx_pkt_size == VERIWAVE_PKT_SIZE_BIG &&
						pstat->IOTPeer == HT_IOT_PEER_VERIWAVE) {
					    amsdu_pkt_th /= 3;
					    amsdu_pkt_th2 /= 3;
				    }

					if(priv->pshare->rf_ft_var.mustAmsdu == 1 || txpkts > amsdu_pkt_th) {
						pstat->aggre_mthd = AGGRE_MTHD_MPDU_AMSDU;
						pstat->amsdu_defer_to = 30;
					}else if(pstat->aggre_mthd == AGGRE_MTHD_MPDU_AMSDU && txpkts <= amsdu_pkt_th2){
#ifdef CONFIG_SPECIAL_ENV_TEST
						if(pstat->amsdu_defer_to <= 0){
							pstat->aggre_mthd = AGGRE_MTHD_MPDU;
							pstat->amsdu_defer_to = 0;
						} else if (priv->pshare->in_spec_env_test_to){
							pstat->amsdu_defer_to--;
						} else
#endif
						{
							pstat->aggre_mthd = AGGRE_MTHD_MPDU;
							pstat->amsdu_defer_to = 0;
						}
					} else if (pstat->aggre_mthd == AGGRE_MTHD_NONE ||
								pstat->current_tx_pkt_size == VERIWAVE_PKT_SIZE_BIG) {
						pstat->aggre_mthd = AGGRE_MTHD_MPDU;
						pstat->amsdu_defer_to = 0;
					} else {
						/* keep same aggre_mthd */
					}
				}
			} else
#endif 
				pstat->aggre_mthd = AGGRE_MTHD_MPDU;
		} else
		if ((AMPDU_ENABLE == 1) || (AMSDU_ENABLE == 1))		// auto assignment
			pstat->aggre_mthd = AGGRE_MTHD_MPDU;
		else if ((AMPDU_ENABLE >= 2) && (AMSDU_ENABLE == 0))
			pstat->aggre_mthd = AGGRE_MTHD_MPDU;
		else if ((AMPDU_ENABLE == 0) && (AMSDU_ENABLE >= 2))
			pstat->aggre_mthd = AGGRE_MTHD_MSDU;									//5.2.38
		else
			pstat->aggre_mthd = AGGRE_MTHD_NONE;
	} else
		pstat->aggre_mthd = AGGRE_MTHD_NONE;

	if (should_restrict_Nrate(priv, pstat) && (pstat->aggre_mthd != AGGRE_MTHD_NONE))
		pstat->aggre_mthd = AGGRE_MTHD_NONE;

// Client mode IOT issue, Button 2009.07.17
// we won't restrict N rate with 8190
#ifdef CLIENT_MODE
	if(OPMODE & WIFI_STATION_STATE)
	{
		if((pstat->IOTPeer !=HT_IOT_PEER_REALTEK_92SE) && pstat->is_realtek_sta && pstat->is_legacy_encrpt)
			pstat->aggre_mthd = AGGRE_MTHD_NONE;
	}
#endif
}


void assign_aggre_size(struct rtl8192cd_priv *priv, struct stat_info *pstat)
{
    int sta_mimo_mode;
    if ((priv->pmib->dot11BssType.net_work_type & WIRELESS_11N) && pstat->ht_cap_len) {
        if ((priv->pmib->dot11nConfigEntry.dot11nAMPDUSendSz == 8) ||
            (priv->pmib->dot11nConfigEntry.dot11nAMPDUSendSz == 16) ||
            (priv->pmib->dot11nConfigEntry.dot11nAMPDUSendSz == 32)) {
            if (priv->pmib->dot11nConfigEntry.dot11nAMPDUSendSz == 8)
                pstat->diffAmpduSz = 0x44444444;
            else if (priv->pmib->dot11nConfigEntry.dot11nAMPDUSendSz == 16)
                pstat->diffAmpduSz = 0x88888888;
            else
                pstat->diffAmpduSz = 0xffffffff;
        } else {
            unsigned int ampdu_para = pstat->ht_cap_buf.ampdu_para & 0x03;
            pstat->diffAmpduSz = RTL_R32(AGGLEN_LMT);
            if ((!ampdu_para) || (ampdu_para == 1)) {
                if ((pstat->diffAmpduSz & 0xf) > 4*(ampdu_para+1))
                    pstat->diffAmpduSz = (pstat->diffAmpduSz & ~0xf) | 0x4*(ampdu_para+1);
                if (((pstat->diffAmpduSz & 0xf0) >> 4) > 4*(ampdu_para+1))
                    pstat->diffAmpduSz = (pstat->diffAmpduSz & ~0xf0) | 0x40*(ampdu_para+1);
                if (((pstat->diffAmpduSz & 0xf00) >> 8) > 4*(ampdu_para+1))
                    pstat->diffAmpduSz = (pstat->diffAmpduSz & ~0xf00) | 0x400*(ampdu_para+1);
                if (((pstat->diffAmpduSz & 0xf000) >> 12) > 4*(ampdu_para+1))
                    pstat->diffAmpduSz = (pstat->diffAmpduSz & ~0xf000) | 0x4000*(ampdu_para+1);
                if (((pstat->diffAmpduSz & 0xf0000) >> 16) > 4*(ampdu_para+1))
                    pstat->diffAmpduSz = (pstat->diffAmpduSz & ~0xf0000) | 0x40000*(ampdu_para+1);
                if (((pstat->diffAmpduSz & 0xf00000) >> 20) > 4*(ampdu_para+1))
                    pstat->diffAmpduSz = (pstat->diffAmpduSz & ~0xf00000) | 0x400000*(ampdu_para+1);
                if (((pstat->diffAmpduSz & 0xf000000) >> 24) > 4*(ampdu_para+1))
                    pstat->diffAmpduSz = (pstat->diffAmpduSz & ~0xf000000) | 0x4000000*(ampdu_para+1);
                if (((pstat->diffAmpduSz & 0xf0000000) >> 28) > 4*(ampdu_para+1))
                    pstat->diffAmpduSz = (pstat->diffAmpduSz & ~0xf0000000) | 0x40000000*(ampdu_para+1);
            }
        }
        DEBUG_INFO("assign aggregation size: %d\n", 8<<(pstat->ht_cap_buf.ampdu_para & 0x03));
    }

    //if (pstat->ht_cap_len)
    //	pstat->maxAggNum = ((1<<(pstat->ht_cap_buf.ampdu_para & 0x03))*5);
    if (pstat->ht_cap_len) {
        if((pstat->ht_cap_buf.ampdu_para & 0x03) == 3) {

            #ifdef CONFIG_RTK_MESH
            if(isPossibleNeighbor(pstat)) {
                pstat->maxAggNum = 41;
            }
            else
            #endif
                pstat->maxAggNum = 42;

        }
        else if((pstat->ht_cap_buf.ampdu_para & 0x03) == 2)
            pstat->maxAggNum = 21;
        else if((pstat->ht_cap_buf.ampdu_para & 0x03) == 1)
            pstat->maxAggNum = 10;
        else
            pstat->maxAggNum = 5;
    }
#ifdef RTK_AC_SUPPORT
    if ((priv->pmib->dot11BssType.net_work_type & WIRELESS_11AC) && (pstat->vht_cap_len)) {	
        pstat->maxAggNum = ((1<<((cpu_to_le32(pstat->vht_cap_buf.vht_cap_info) & 0x3800000)>>MAX_RXAMPDU_FACTOR_S))*5);
		if(pstat->IOTPeer == HT_IOT_PEER_INTEL) {
			pstat->maxAggNum = 48;
		}

#ifdef CONFIG_WLAN_HAL_8814AE			
        if (GET_CHIP_VER(priv)==VERSION_8814A) {
            if(((le32_to_cpu(pstat->vht_cap_buf.vht_support_mcs[0])>>8)&3)==3) // no support RX 5ss
                sta_mimo_mode = RF_4T4R;
            if(((le32_to_cpu(pstat->vht_cap_buf.vht_support_mcs[0])>>6)&3)==3) // no support RX 4ss
                sta_mimo_mode = RF_3T3R;
            if(((le32_to_cpu(pstat->vht_cap_buf.vht_support_mcs[0])>>4)&3)==3) // no support RX 3ss
                sta_mimo_mode = RF_2T2R;
            if(((le32_to_cpu(pstat->vht_cap_buf.vht_support_mcs[0])>>2)&3)==3) // no support RX 2ss
                sta_mimo_mode = RF_1T1R;
            if(sta_mimo_mode == RF_1T1R && pstat->maxAggNum > 16)
                pstat->maxAggNum = 16;
        }
#endif		
    }

#endif

    if(pstat->maxAggNum >= 0x3F)
        pstat->maxAggNum = 0x3F;

	pstat->maxAggNumOrig= pstat->maxAggNum;
}

#ifdef SUPPORT_MONITOR
static __always_inline void rtl8192cd_chan_switch_timer(unsigned long task_priv)
{
	struct rtl8192cd_priv *priv = (struct rtl8192cd_priv *)task_priv;

	if (!(priv->drv_state & DRV_STATE_OPEN))
		return;
	if(priv->is_monitor_mode==TRUE)
	{
		if(((priv->chan_num%priv->available_chnl_num)==0)&&(priv->chan_num>0))
			priv->chan_num = 0;
		else
			priv->chan_num++;

		priv->pshare->CurrentChannelBW = CHANNEL_WIDTH_20;
		SwBWMode(priv, priv->pshare->CurrentChannelBW, priv->pshare->offset_2nd_chan);
		SwChnl(priv, priv->available_chnl[priv->chan_num], priv->pshare->offset_2nd_chan);
		rtk_mod_timer(&priv->chan_switch_timer, jiffies + RTL_MILISECONDS_TO_JIFFIES(priv->pmib->miscEntry.chan_switch_time));
	}
}
DEFINE_TIMER_CALLBACK(rtl8192cd_chan_switch_timer);

void init_chan_switch_timer(struct rtl8192cd_priv *priv)
{
	rtk_timer_setup(&(priv->chan_switch_timer), rtl8192cd_chan_switch_timer, (unsigned long)priv, 0);
}
#endif  // SUPPORT_MONITOR

#ifndef USE_WEP_DEFAULT_KEY
void set_keymapping_wep(struct rtl8192cd_priv *priv, struct stat_info *pstat)
{
	struct wifi_mib	*pmib = GET_MIB(priv);

//	if ((GET_ROOT(priv)->pmib->dot11OperationEntry.opmode & WIFI_AP_STATE) &&
#ifdef MULTI_MAC_CLONE
	if (!IEEE8021X_FUN &&
#else
	if (!SWCRYPTO && !IEEE8021X_FUN &&
#endif
		((pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm == _WEP_40_PRIVACY_) ||
		 (pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm == _WEP_104_PRIVACY_)))
	{
		pstat->dot11KeyMapping.dot11Privacy = pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm;
		pstat->keyid = pmib->dot1180211AuthEntry.dot11PrivacyKeyIndex;
		if (pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm == _WEP_40_PRIVACY_) {
			pstat->dot11KeyMapping.dot11EncryptKey.dot11TTKeyLen = 5;
			memcpy(pstat->dot11KeyMapping.dot11EncryptKey.dot11TTKey.skey,
				   pmib->dot11DefaultKeysTable.keytype[pstat->keyid].skey, 5);
		}
		else {
			pstat->dot11KeyMapping.dot11EncryptKey.dot11TTKeyLen = 13;
			memcpy(pstat->dot11KeyMapping.dot11EncryptKey.dot11TTKey.skey,
				   pmib->dot11DefaultKeysTable.keytype[pstat->keyid].skey, 13);
		}

		DEBUG_INFO("going to set %s unicast key for sta %pm, id=%d\n",
			(pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm == _WEP_40_PRIVACY_)?"WEP40":"WEP104",
			pstat->cmn_info.mac_addr, pstat->keyid);
		if (!SWCRYPTO) {
			int retVal=0;

#ifdef USE_WEP_4_KEYS
#ifdef MULTI_MAC_CLONE
			if ((OPMODE & WIFI_STATION_STATE) && priv->pmib->ethBrExtInfo.macclone_enable) {
				retVal = CamAddOneEntry(priv, pstat->sa_addr, pstat->keyid,
					pstat->dot11KeyMapping.dot11Privacy<<2, 0, pstat->dot11KeyMapping.dot11EncryptKey.dot11TTKey.skey);
				if (retVal) {
					priv->pshare->CamEntryOccupied++;
					pstat->dot11KeyMapping.keyInCam = TRUE;
				}					
			} else			
#endif	
			{
				if(priv->pshare->total_cam_entry - priv->pshare->CamEntryOccupied >=4) {
					int keyid=0;
					for(;keyid<4; keyid++) {
						if (CamDeleteOneEntry(priv, pstat->cmn_info.mac_addr, keyid, 0)) {
							priv->pshare->CamEntryOccupied--;
						}					
						if (CamAddOneEntry(priv, pstat->cmn_info.mac_addr, keyid,
							pstat->dot11KeyMapping.dot11Privacy<<2, 0, 
							pmib->dot11DefaultKeysTable.keytype[keyid].skey)) {						
							priv->pshare->CamEntryOccupied++;
							retVal ++;
						}						
					}				
				} 
				if( retVal ==4) {
					pstat->dot11KeyMapping.keyInCam = TRUE;
				} else {
					int keyid=0;
					for(;keyid<4; keyid++) {
						if (CamDeleteOneEntry(priv, pstat->cmn_info.mac_addr, keyid, 0)) 
							priv->pshare->CamEntryOccupied--;					
					}
					pstat->dot11KeyMapping.keyInCam = FALSE;
				}		
			}	
			if (pstat->aggre_mthd != AGGRE_MTHD_NONE)
				pstat->aggre_mthd = AGGRE_MTHD_NONE;
#else
			retVal = CamDeleteOneEntry(priv, pstat->cmn_info.mac_addr, pstat->keyid, 0);
			if (retVal) {
				priv->pshare->CamEntryOccupied--;
				pstat->dot11KeyMapping.keyInCam = FALSE;
			}
#ifdef MULTI_MAC_CLONE
			if ((OPMODE & WIFI_STATION_STATE) && priv->pmib->ethBrExtInfo.macclone_enable)
				retVal = CamAddOneEntry(priv, pstat->sa_addr, pstat->keyid,
					pstat->dot11KeyMapping.dot11Privacy<<2, 0, pstat->dot11KeyMapping.dot11EncryptKey.dot11TTKey.skey);
			else			
#endif			
			retVal = CamAddOneEntry(priv, pstat->cmn_info.mac_addr, pstat->keyid,
				pstat->dot11KeyMapping.dot11Privacy<<2, 0, pstat->dot11KeyMapping.dot11EncryptKey.dot11TTKey.skey);
			if (retVal) {
				priv->pshare->CamEntryOccupied++;
				pstat->dot11KeyMapping.keyInCam = TRUE;
			}
			else {
				if (pstat->aggre_mthd != AGGRE_MTHD_NONE)
					pstat->aggre_mthd = AGGRE_MTHD_NONE;
			}
#endif			
		}
	}
}
#endif


/*-----------------------------------------------------------------------------
OnAssocReg:
	--> Reply DeAuth or AssocRsp
Capability Info, Listen Interval, SSID, SupportedRates
------------------------------------------------------------------------------*/
unsigned int OnAssocReq(struct rtl8192cd_priv *priv, struct rx_frinfo *pfrinfo)
{
	struct wifi_mib		*pmib;
	struct stat_info	*pstat;
	unsigned char		*pframe, *p;
	unsigned char		rsnie_hdr[4]={0x00, 0x50, 0xf2, 0x01};
#ifdef RTL_WPA2
	unsigned char		rsnie_hdr_wpa2[2]={0x01, 0x00};
#endif
#ifdef HS2_SUPPORT
	unsigned char		rsnie_hdr_OSEN[4]={0x50, 0x6F, 0x9A, 0x12};
#endif
	int		len;
#ifndef SMP_SYNC
	unsigned long		flags;
#endif
	DOT11_ASSOCIATION_IND     Association_Ind;
	DOT11_REASSOCIATION_IND   Reassociation_Ind;
	unsigned char		supportRate[32];
	int					supportRateNum = 0;
	unsigned int		status = _STATS_SUCCESSFUL_;
	unsigned short		frame_type, ie_offset=0, val16;
	unsigned int z = 0;

#ifdef P2P_SUPPORT
	unsigned char ReAssem_p2pie[MAX_REASSEM_P2P_IE];
	int IEfoundtimes=0;
	unsigned char *p2pIEPtr = ReAssem_p2pie ;
	int p2pIElen;
#endif

	unsigned int assoc_disallowed_status = 0;
	unsigned int oui = 0;
	HT_IOT_PEER_E IOTPeer = HT_IOT_PEER_UNKNOWN;
	int i;

	pmib = GET_MIB(priv);
	pframe = get_pframe(pfrinfo);
	pstat = get_stainfo(priv, GetAddr2Ptr(pframe));
#ifdef RTK_NL80211	
	struct ieee80211_mgmt *mgmt;
	struct station_info sinfo;
	memset(&sinfo, 0, sizeof(struct station_info));
	mgmt = (struct ieee80211_mgmt *)pframe;
	if (ieee80211_is_assoc_req(mgmt->frame_control) &&
			pfrinfo->pktlen >= sizeof(struct ieee80211_hdr_3addr) +
			sizeof(mgmt->u.assoc_req)){
	sinfo.assoc_req_ies_len = pfrinfo->pktlen - (IEEE80211_HDRLEN + sizeof(mgmt->u.assoc_req));
	sinfo.assoc_req_ies = mgmt->u.assoc_req.variable;
	NDEBUG("pktlen: %d ,HDRLEN: %d ,assoc_req :%d\n",pfrinfo->pktlen,IEEE80211_HDRLEN,sizeof(mgmt->u.assoc_req));
	}
	else if (ieee80211_is_reassoc_req(mgmt->frame_control) &&
			   pfrinfo->pktlen >= sizeof(struct ieee80211_hdr_3addr)
			   + sizeof(mgmt->u.reassoc_req)) {
	sinfo.assoc_req_ies_len = pfrinfo->pktlen - (IEEE80211_HDRLEN + sizeof(mgmt->u.reassoc_req));
	sinfo.assoc_req_ies = mgmt->u.reassoc_req.variable;
	NDEBUG("pktlen: %d ,HDRLEN: %d ,reassoc_req :%d\n",pfrinfo->pktlen,IEEE80211_HDRLEN,sizeof(mgmt->u.reassoc_req));
	}
#endif	
#ifdef CONFIG_MBO
	assoc_disallowed_status = check_association_disallowed(priv, WIFI_ASSOCREQ, pfrinfo->rf_info.rssi);
#endif
	if(pstat)
		log("peer %pm",pstat->cmn_info.mac_addr);

	if (!(OPMODE & WIFI_AP_STATE))
		return FAIL;

	if (!IS_DRV_OPEN(priv))
		return FAIL;

#ifdef WDS
	if (pmib->dot11WdsInfo.wdsPure)
		return FAIL;
#endif

	if (pmib->miscEntry.func_off || pmib->miscEntry.raku_only)
		return FAIL;

	if(priv->pmib->miscEntry.telco_selected == TELCO_CMCC){
#ifdef STA_ROAMING_CHECK
		if ((pfrinfo->rf_info.rssi < priv->pmib->dot11StationConfigEntry.staAssociateRSSIThreshold) ||
				(priv->pmib->rlr_profile.roaming_switch && !priv->pmib->rlr_profile.roaming_qos && (pfrinfo->rf_info.rssi < priv->pmib->rlr_profile.RSSIThreshold + priv->pmib->rlr_profile.staRoamingRSSIGap)))
#else
		if (pfrinfo->rf_info.rssi < priv->pmib->dot11StationConfigEntry.staAssociateRSSIThreshold)
#endif
		{
#ifdef STA_ASSOC_STATISTIC
			add_reject_sta(priv,GetAddr2Ptr(pframe), pfrinfo->rf_info.rssi);
#endif		
			return FAIL;
		}
	}else if(priv->pmib->miscEntry.telco_selected == TELCO_CT){
		if (pfrinfo->rf_info.rssi < priv->pmib->dot11StationConfigEntry.staAssociateRSSIThreshold)
		{
#ifdef STA_ASSOC_STATISTIC
			add_reject_sta(priv,GetAddr2Ptr(pframe), pfrinfo->rf_info.rssi);	
#endif		
			return FAIL;
		}
	}

#ifdef CONFIG_RTK_WLAN_MANAGER
	rtk_wlan_manager_nl_send_frame_rpt_msg(priv, WIFI_ASSOCREQ, GetAddr2Ptr(pframe), pfrinfo->rf_info.rssi);
#endif

#ifdef CONFIG_RTK_BAND_STEERING
	if (_band_steering_block_chk(priv, GetAddr2Ptr(pframe))) {
		status = _STATS_ASSOC_REJ_TEMP_;
		goto OnAssocReqFail;
	}
#endif

#ifdef DFS
	if (priv->pshare->rf_ft_var.dfs_det_period)
		priv->det_asoc_clear = 500 / priv->pshare->rf_ft_var.dfs_det_period;
	else
		priv->det_asoc_clear = 50;
#endif

#ifdef CONFIG_RTK_MESH

// KEY_MAP_KEY_PATCH_0223
	if((pmib->dot1180211sInfo.mesh_enable && !(GET_MIB(priv)->dot1180211sInfo.mesh_ap_enable)) || pmib->dot1180211sInfo.meshSilence)
// 2008.05.16
//		((pmib->dot11sKeysTable.dot11Privacy && pmib->dot11sKeysTable.keyInCam == FALSE )
//		||( (OPMODE & WIFI_AP_STATE) && !(GET_MIB(priv)->dot1180211sInfo.mesh_ap_enable))))
	{
		return FAIL;
	}
// KEY_MAP_KEY_PATCH_0223
// 2008.05.16
#endif

	if(pstat)
		DRV_RT_TRACE(priv, DRV_DBG_CONN_INFO, DRV_DBG_TRACE, "sta=%pm\n", pstat->cmn_info.mac_addr);

#ifdef CONFIG_POWER_SAVE
	priv->pshare->xfer_seq++;
#endif

//Ignore AssocReq during 4-WAY Handshake for some phones' connection issue
if((pstat) && (pstat->wpa_sta_info->state == PSK_STATE_PTKINITNEGOTIATING)) {
	panic_printk("%s (%d)\n", __FUNCTION__, __LINE__);
	return FAIL;
}

	frame_type = GetFrameSubType(pframe);
	if (frame_type == WIFI_ASSOCREQ)
		ie_offset = _ASOCREQ_IE_OFFSET_;
	else // WIFI_REASSOCREQ
		ie_offset = _REASOCREQ_IE_OFFSET_;

	if (pstat == (struct stat_info *)NULL)
	{
		status = _RSON_CLS2_;
		goto asoc_class2_error;
	}

	// check if this sta has been successfully authenticated/assocated and has not sent deauth request
	if (!((pstat->state) & WIFI_AUTH_SUCCESS) || (pstat->state & WIFI_DELETE_STATE))
	{
		status = _RSON_CLS2_;
		goto asoc_class2_error;
	}

#ifdef CTC_WIFI_DIAG
	if (frame_type == WIFI_REASSOCREQ) {
		ctcwifi_diag_log(priv, pstat->cmn_info.mac_addr, 0, "Reassociation Request", (pframe+WLAN_HDR_A3_LEN), (pfrinfo->pktlen-WLAN_HDR_A3_LEN));
	}
	else {
		ctcwifi_diag_log(priv, pstat->cmn_info.mac_addr, 0, "Association Request", (pframe+WLAN_HDR_A3_LEN), (pfrinfo->pktlen-WLAN_HDR_A3_LEN));
	}
#endif

#ifdef NOT_RTK_BSP
	if (priv->pmib->dot11StationConfigEntry.supportedStaNum) {
		if (priv->assoc_num >= priv->pmib->dot11StationConfigEntry.supportedStaNum) {
			DEBUG_ERR("Assoc()Exceed the upper limit of supported clients(%d)...\n",priv->pmib->dot11StationConfigEntry.supportedStaNum);
			status = _STATS_UNABLE_HANDLE_STA_;
			goto OnAssocReqFail;
		}
	}
#endif

	if (priv->assoc_reject_on)
	{
		DRV_RT_TRACE(priv, DRV_DBG_CONN_INFO, DRV_DBG_SERIOUS, "_STATS_OTHER_\n");
		status = _STATS_OTHER_;
#ifdef CTC_WIFI_DIAG
		ctcwifi_assoc_err(priv, pstat->cmn_info.mac_addr, "Authentication failed [assoc_reject_on=1]\n");
#endif
		goto OnAssocReqFail;
	}
#ifdef CONFIG_IEEE80211W
	if(((pstat->state) & WIFI_ASOC_STATE) &&
		pstat->isPMF &&
		!pstat->sa_query_timed_out &&
		pstat->sa_query_count) 	{
		check_sa_query_timeout(pstat);
	}
	
	if(((pstat->state) & WIFI_ASOC_STATE) &&
		pstat->isPMF &&
		!pstat->sa_query_timed_out) {

		status = _STATS_ASSOC_REJ_TEMP_;
		if(pstat->sa_query_count == 0) {
			pstat->sa_query_end = jiffies + RTL_MILISECONDS_TO_JIFFIES(SA_QUERY_MAX_TO);
		}
#ifdef RTK_NL80211
		cfg80211_new_sta(priv->dev, GetAddr2Ptr(pframe), &sinfo, GFP_ATOMIC);
		netif_wake_queue(priv->dev); //wrt-vap
#endif
		if (frame_type == WIFI_ASSOCREQ)
			issue_asocrsp(priv, status, pstat, WIFI_ASSOCRSP, assoc_disallowed_status);
		else
			issue_asocrsp(priv, status, pstat, WIFI_REASSOCRSP, assoc_disallowed_status);

#ifdef CTC_WIFI_DIAG
		ctcwifi_assoc_err(priv, pstat->cmn_info.mac_addr, "Authentication failed [temporary reject]\n");
#endif

		if(pstat->sa_query_count == 0) {
            //PMFDEBUG("sa_query_end=%lu\n", pstat->sa_query_end);
			pstat->sa_query_count++;

			issue_SA_Query_Req(priv->dev,pstat->cmn_info.mac_addr);
			rtk_mod_timer(&pstat->SA_timer, jiffies + RTL_MILISECONDS_TO_JIFFIES(SA_QUERY_RETRY_TO));
		}
		return FAIL;
	}
	pstat->sa_query_timed_out = 0;
#endif
#ifdef CONFIG_RTL_WLAN_DOS_FILTER
	if (block_sta_time)
	{
		int i;
		for (i=0; i<MAX_BLOCK_MAC;i++)
		{
			if (memcmp(pstat->cmn_info.mac_addr, block_mac[i], 6) == 0)
			{
				status = _STATS_OTHER_;
				DRV_RT_TRACE(priv, DRV_DBG_CONN_INFO, DRV_DBG_SERIOUS, "_STATS_OTHER_\n");
#ifdef CTC_WIFI_DIAG
				ctcwifi_assoc_err(priv, pstat->cmn_info.mac_addr, "Rejected by blacklist [rejected due to block_mac]\n");
#endif
				goto OnAssocReqFail;
			}				
		}
	}
#endif

#ifdef CONFIG_IEEE80211V
	if(WNM_ENABLE) {
		set_staBssTransCap(pstat, pframe, (pfrinfo->pktlen - WLAN_HDR_A3_LEN - ie_offset), ie_offset);
#ifdef WLAN_DIAGNOSTIC
		if(isDualBandClient(priv->bss11v_priv_sc, pstat->cmn_info.mac_addr))
			pstat->dual_band_capable = 1;
#endif		
		if (priv->startCounting == TRUE && priv->dot11vDiassocDeadline) {
			int i;
			for (i = 0 ; i < MAX_TRANS_LIST_NUM; i++) {
				if((priv->transition_list_bitmask[i>>3] & (1<<(i&7))) == 0)
					continue;

				if (0 == memcmp(GetAddr2Ptr(pframe), priv->transition_list[i].addr, MACADDRLEN)) {
					break;
				}
			}
		}
	}
#endif

#ifdef CONFIG_IEEE80211R
	if (FT_ENABLE) {
		p = get_ie(pframe + WLAN_HDR_A3_LEN + ie_offset, _MOBILITY_DOMAIN_IE_, &len, 
			pfrinfo->pktlen - WLAN_HDR_A3_LEN - ie_offset);
		if (p != NULL) {
#ifndef RTK_NL80211		
			if (pstat->ft_state == state_none) {				
				if (ft_check_imd_assoc(priv, pstat, pframe + WLAN_HDR_A3_LEN + ie_offset,
					pfrinfo->pktlen - WLAN_HDR_A3_LEN - ie_offset, &status)) {
					DEBUG_WARN("FT: imd assoc, not valid ie (%d), continue\n", status);
					status = _STATS_SUCCESSFUL_;
				} else {
                     pstat->ft_state = state_imd_assoc;
				   	 ft_init_1x(priv, pstat);
                 }
			} else if (pstat->ft_state == state_ft_auth || pstat->ft_state == state_ft_auth_rrq) {
				pstat->ft_state = state_ft_assoc;
				if (ft_check_ft_assoc(priv, pstat, pframe + WLAN_HDR_A3_LEN + ie_offset,
					pfrinfo->pktlen - WLAN_HDR_A3_LEN - ie_offset, &status)) {
					DEBUG_WARN("FT: ft assoc, not valid ie (%d)\n", status);
					goto OnAssocReqFail;
				}
			}
#else /* RTK_NL80211 */
			FTDEBUG("peer[%pm] with MDIE ft_state[%d]", pfrinfo->sa,pstat->ft_state);
			
			if (pstat->ft_state == state_none) {
				pstat->ft_state = state_imd_assoc;
				ft_init_1x(priv, pstat);
			} else if (pstat->ft_state == state_ft_auth || pstat->ft_state == state_ft_auth_rrq) {
				pstat->ft_state = state_ft_assoc;
			}
			
			memset(pstat->md_ie, 0, sizeof(pstat->md_ie));
			memcpy(pstat->md_ie, p, len + 2);
			
			p = get_ie(pframe + WLAN_HDR_A3_LEN + ie_offset, _RSN_IE_2_, &len, 
				pfrinfo->pktlen - WLAN_HDR_A3_LEN - ie_offset);
			if (p) {
				memset(pstat->wpa_ie, 0, sizeof(pstat->wpa_ie));
				memcpy(pstat->wpa_ie, p, len + 2);
			}
			
			p = get_ie(pframe + WLAN_HDR_A3_LEN + ie_offset, _FAST_BSS_TRANSITION_IE_, &len, 
				pfrinfo->pktlen - WLAN_HDR_A3_LEN - ie_offset);
			if (p) {
				memset(pstat->ft_ie, 0, sizeof(pstat->ft_ie));
				memcpy(pstat->ft_ie, p, len + 2);
			}
#endif /* RTK_NL80211 */
		}
	}
#endif


#ifdef DOT11K
    if(priv->pmib->dot11StationConfigEntry.dot11RadioMeasurementActivated) {
        p = get_ie(pframe + WLAN_HDR_A3_LEN + ie_offset, _RM_ENABLE_CAP_IE_, &len, 
                pfrinfo->pktlen - WLAN_HDR_A3_LEN - ie_offset);
        if (p != NULL) {
            memcpy(pstat->rm.rm_cap, p+2, 5);
        }    
    }
#endif

#ifdef HAPD_11K
	/*HAPD_11K right now assoc_req will be report to hapd*/
#endif
	/* Rate adpative algorithm */
	if (pstat->check_init_tx_rate)
		pstat->check_init_tx_rate = 0;

	// now we should check all the fields...

	// checking SSID
	p = get_ie(pframe + WLAN_HDR_A3_LEN + ie_offset, _SSID_IE_, &len,
		pfrinfo->pktlen - WLAN_HDR_A3_LEN - ie_offset);

	if (p == NULL)
	{
		status = _STATS_FAILURE_;
		DRV_RT_TRACE(priv, DRV_DBG_CONN_INFO, DRV_DBG_SERIOUS, "_STATS_FAILURE_\n");
#ifdef CTC_WIFI_DIAG
		ctcwifi_assoc_err(priv, pstat->cmn_info.mac_addr, "Capability checking failed [NULL SSID]\n");
#endif
		goto OnAssocReqFail;
	}

	if (len == 0) { // broadcast ssid, however it is not allowed in assocreq
		DRV_RT_TRACE(priv, DRV_DBG_CONN_INFO, DRV_DBG_SERIOUS, "_STATS_FAILURE_\n");
		status = _STATS_FAILURE_;
#ifdef CTC_WIFI_DIAG
		ctcwifi_assoc_err(priv, pstat->cmn_info.mac_addr, "Capability checking failed [broadcast SSID]\n");
#endif
	} else
	{
		// check if ssid match
		if (memcmp((void *)(p+2), SSID, SSID_LEN)) {
			DRV_RT_TRACE(priv, DRV_DBG_CONN_INFO, DRV_DBG_SERIOUS, " _STATS_FAILURE_\n");	
			status = _STATS_FAILURE_;
#ifdef CTC_WIFI_DIAG
			ctcwifi_assoc_err(priv, pstat->cmn_info.mac_addr, "Capability checking failed [SSID does not match]\n");
#endif
		}

		if (len != SSID_LEN) {
			DRV_RT_TRACE(priv, DRV_DBG_CONN_INFO, DRV_DBG_SERIOUS, "_STATS_FAILURE_\n");
			status = _STATS_FAILURE_;
#ifdef CTC_WIFI_DIAG
			ctcwifi_assoc_err(priv, pstat->cmn_info.mac_addr, "Capability checking failed [SSID length does not match]\n");
#endif
		}
	}
#ifdef AUTH_SAE
	// check if the PMKID is exist in pmkid cache
	p = get_ie(pframe + WLAN_HDR_A3_LEN + ie_offset, _RSN_IE_2_, &len,
			pfrinfo->pktlen - WLAN_HDR_A3_LEN - ie_offset);
	if ( p != NULL) {
		if( *(p+_ASOCREQ_RSN_AKM_type_IE_OFFSET_) == DOT11_AuthKeyType_SAE &&
			len >= _ASOCREQ_RSN_PMKID_COUNT_OFFSET_ &&
			*(p+_ASOCREQ_RSN_PMKID_COUNT_OFFSET_) != 0x0 ) {
			unsigned char pmkid_idx = search_pmkid_cache(priv, (p+_ASOCREQ_RSN_PMKID_IE_OFFSET_));
			if (pmkid_idx == NUM_PMKID_CACHE) {
				log("can't found pmkid from cache, ask Client to re-do SAE to gen new PMK....\n");
				status = __STATS_INVALID_IE_;
				goto OnAssocReqFail;
			}
		}
		if( *(p+_ASOCREQ_RSN_AKM_type_IE_OFFSET_) == DOT11_AuthKeyType_SAE){
			log("pstat is sae sta");
			pstat->is_sae_sta = 1;
		}
	}
#else
	p = get_ie(pframe + WLAN_HDR_A3_LEN + ie_offset, _RSN_IE_2_, &len,
			pfrinfo->pktlen - WLAN_HDR_A3_LEN - ie_offset);
	if( p != NULL && *(p+_ASOCREQ_RSN_AKM_type_IE_OFFSET_) == DOT11_AuthKeyType_SAE){
		log("pstat is sae sta");
		pstat->AuthAlgrthm = _AUTH_ALGM_SAE_;
#ifdef RTK_NL80211
		if (len >= _ASOCREQ_RSN_PMKID_COUNT_OFFSET_ &&
			*(p+_ASOCREQ_RSN_PMKID_COUNT_OFFSET_) != 0x0 ) {
			pstat->has_pmkid = 1;
		}
#endif
	}
#endif // AUTH_SAE

#ifdef RTK_NL80211
	// Record association typee
	pstat->assoc_type = frame_type;
#endif

	// check if the supported is ok
	p = get_ie(pframe + WLAN_HDR_A3_LEN + ie_offset, _SUPPORTEDRATES_IE_, &len,
		pfrinfo->pktlen - WLAN_HDR_A3_LEN - ie_offset);

	if (len > 8) {
		DRV_RT_TRACE(priv, DRV_DBG_CONN_INFO, DRV_DBG_SERIOUS, "_STATS_RATE_FAIL_\n");
		status = _STATS_RATE_FAIL_;
#ifdef CTC_WIFI_DIAG
		ctcwifi_assoc_err(priv, pstat->cmn_info.mac_addr, "Capability checking failed [supported rate length > 8]\n");
#endif
	} else if (p == NULL) {
		DEBUG_WARN("Rx a sta assoc-req which supported rate is empty!\n");
		// use our own rate set as statoin used
		memcpy(supportRate, AP_BSSRATE, AP_BSSRATE_LEN);
		supportRateNum = AP_BSSRATE_LEN;
	}
	else {
		memcpy(supportRate, p+2, len);
		supportRateNum = len;

		p = get_ie(pframe + WLAN_HDR_A3_LEN + ie_offset, _EXT_SUPPORTEDRATES_IE_ , &len,
				pfrinfo->pktlen - WLAN_HDR_A3_LEN - ie_offset);
		if ((p !=  NULL) && (len <= 8)) {
			memcpy(supportRate+supportRateNum, p+2, len);
			supportRateNum += len;
		}
	}
#ifdef STA_ASSOC_STATISTIC
	if (frame_type == WIFI_REASSOCREQ) {
		memcpy(pstat->currAP_Addr, pframe + WLAN_HDR_A3_LEN + _ASOCREQ_IE_OFFSET_, MACADDRLEN);
	}
#endif
#ifdef __DRAYTEK_OS__
	if (status == _STATS_SUCCESSFUL_) {
		status = cb_assoc_request(priv->dev, GetAddr2Ptr(pframe), pframe + WLAN_HDR_A3_LEN + _ASOCREQ_IE_OFFSET_,
				pfrinfo->pktlen-WLAN_HDR_A3_LEN-_ASOCREQ_IE_OFFSET_);
		if (status != _STATS_SUCCESSFUL_) {
			DEBUG_ERR("\rReject association from draytek OS, status=%d!\n", status);
			goto OnAssocReqFail;
		}
	}
#endif
#if 0	
#ifdef P2P_SUPPORT			/*cfg p2p cfg p2p*/
	if((rtk_p2p_is_enabled(priv)==PROPERTY_P2P)){
	}
	else
#endif
	{
	if (check_basic_rate(priv, supportRate, supportRateNum) == FAIL) {		// check basic rate. jimmylin 2004/12/02
		DEBUG_WARN("Rx a sta assoc-req which basic rates not match! %pm\n",
			pstat->cmn_info.mac_addr);
		if (priv->pmib->dot11OperationEntry.wifi_specific) {
			status = _STATS_RATE_FAIL_;
			goto OnAssocReqFail;
		}
	}
	}
#endif
	get_matched_rate(priv, supportRate, &supportRateNum, 0, sizeof(supportRate));
	update_support_rate(pstat, supportRate, supportRateNum);

	if ((priv->pmib->dot11BssType.net_work_type & WIRELESS_11G) &&
		!isErpSta(pstat) &&
		(priv->pmib->dot11StationConfigEntry.legacySTADeny & WIRELESS_11B)) {
		status = _STATS_RATE_FAIL_;
		DRV_RT_TRACE(priv, DRV_DBG_CONN_INFO, DRV_DBG_SERIOUS, "_STATS_RATE_FAIL_\n");
#ifdef CTC_WIFI_DIAG
		ctcwifi_assoc_err(priv, pstat->cmn_info.mac_addr, "Capability checking failed [deny legacy STA for data rate]\n");
#endif
		goto OnAssocReqFail;
	}

	val16 = cpu_to_le16(*(unsigned short*)((unsigned long)pframe + WLAN_HDR_A3_LEN));
	if (!(val16 & BIT(5))) // NOT use short preamble
		pstat->useShortPreamble = 0;
	else
		pstat->useShortPreamble = 1;

	pstat->state |= WIFI_ASOC_STATE;

	if (status != _STATS_SUCCESSFUL_) {
		DRV_RT_TRACE(priv, DRV_DBG_CONN_INFO, DRV_DBG_SERIOUS, "_STATS_RATE_FAIL_\n");
		goto OnAssocReqFail;
	}

#ifdef CONFIG_RTL_WAPI_SUPPORT
	if (priv->pmib->wapiInfo.wapiType!=wapiDisable)
	{
		SAVE_INT_AND_CLI(flags);
		if (pstat->wapiInfo==NULL)
		{
			pstat->wapiInfo = (wapiStaInfo*)kmalloc(sizeof(wapiStaInfo), GFP_ATOMIC);
			if (pstat->wapiInfo==NULL)
			{
				/*pstat->wapiInfo->wapiState = ST_WAPI_AE_IDLE;*/
				status = _RSON_UNABLE_HANDLE_;
				RESTORE_INT(flags);
				goto asoc_class2_error;
			}
			pstat->wapiInfo->priv = priv;
			wapiStationInit(pstat);
		}

		RESTORE_INT(flags);

		p = get_ie(pframe + WLAN_HDR_A3_LEN + ie_offset, _EID_WAPI_, &len,
				pfrinfo->pktlen - WLAN_HDR_A3_LEN - ie_offset);

		if (p==NULL)
		{
			pstat->wapiInfo->wapiState = ST_WAPI_AE_IDLE;
			status = _RSON_IE_NOT_CONSISTENT_;
			goto asoc_class2_error;
		}

		if (len+2 > sizeof(pstat->wapiInfo->asueWapiIE)) {
			DEBUG_ERR("[%s] truncate IE len (%d) to avoid buffer overrun\n", __func__, len);
			len = sizeof(pstat->wapiInfo->asueWapiIE)-2;
		}
		memcpy(pstat->wapiInfo->asueWapiIE, p, len+2);
		pstat->wapiInfo->asueWapiIELength= len+2;

		/*	check for KM	*/
		if ((status=wapiIEInfoInstall(priv, pstat))!=_STATS_SUCCESSFUL_)
		{
			pstat->wapiInfo->wapiState = ST_WAPI_AE_IDLE;
			goto asoc_class2_error;
		}
	}
#endif

#ifdef CONFIG_RTK_WLAN_MANAGER
	unsigned char idx, j, op_num, opclass;

	p = get_ie(pframe + WLAN_HDR_A3_LEN + ie_offset, _SUPPORTED_REGULATORY_CLASSES_IE_, &len,
			pfrinfo->pktlen - WLAN_HDR_A3_LEN - ie_offset);

	if(p != NULL && pstat != NULL)
	{
		op_num  = p[1];
		idx     = 0;
		printk("===================>>>>op_num:%u\n", op_num);
		while(idx < op_num)
		{
			opclass = p[idx+1];
			printk("%u ", opclass);
			for (j = 0; j < (int)(sizeof(global_op_class) / sizeof(OP_CLASS)); j++)
			{
				if(opclass == global_op_class[j].op_class) {
					switch (global_op_class[j].band) {
						case 1:
							pstat->supported_band |= PHY_BAND_2G;
							break;
						case 0:
							pstat->supported_band |= PHY_BAND_5G;
							break;
						default:
							break;
						}
						break;
				}
			}
			idx++;
		}
		printk("\n");
		printk("supported_band: %u\n", pstat->supported_band);
		printk("===================>>>>\n");
	}
#endif
    	// now the station is qualified to join our BSS...
        #if defined(BR_SHORTCUT) && defined(RTL_CACHED_BR_STA)
        release_brsc_cache(GetAddr2Ptr(pframe));
        #endif

#ifdef STA_CONTROL_BAND_TRANSITION
	// If the STA is in BandTransBlockList, reject the association request.
	if (priv->stactrl.stactrl_status && priv->pmib->staControl.stactrl_band_transit) {
		if (checkBandTransBlockList(priv, GetAddr2Ptr(pframe), WIFI_ASSOCREQ)) {
			DEBUG_INFO("[%s, %d]: reject WIFI_ASSOCREQ because of band steering\n", __FUNCTION__, __LINE__);
			status = _STATS_REJ_BSS_TRANSITION;
#ifdef CTC_WIFI_DIAG
			ctcwifi_assoc_err(priv, pstat->cmn_info.mac_addr,
					"Association ignored by band steering [ignore WIFI_ASSOCREQ because 11v band steering]\n");
#endif
			goto OnAssocReqFail;
		}
	}
#endif

#ifdef WIFI_WMM
	// check if there is WMM IE
	if (QOS_ENABLE) {
		p = pframe + WLAN_HDR_A3_LEN + ie_offset; len = 0;
		for (;;) {
			p = get_ie(p, _RSN_IE_1_, &len,
				pfrinfo->pktlen - (p - pframe));
			if (p != NULL) {
				if (!memcmp(p+2, WMM_IE, 6)) {
					pstat->QosEnabled = 1;
#ifdef WMM_APSD
					if (APSD_ENABLE)
						pstat->apsd_bitmap = *(p+8) & 0x0f;		// get QSTA APSD bitmap
#endif
					break;
				}
			}
			else {
				pstat->QosEnabled = 0;
#ifdef WMM_APSD
				pstat->apsd_bitmap = 0;
#endif
				break;
			}
			p = p + len + 2;
		}
	}
	else {
		pstat->QosEnabled = 0;
#ifdef WMM_APSD
		pstat->apsd_bitmap = 0;
#endif
	}
#endif
#if defined(RTK_AC_SUPPORT) || defined(RTK_AC_TX_SUPPORT)
	if ((priv->pmib->dot11BssType.net_work_type & WIRELESS_11AC) || priv->pshare->phw->is_AC_TX_support) {
		p = get_ie(pframe + WLAN_HDR_A3_LEN + ie_offset, EID_VHTCapability, &len,
				pfrinfo->pktlen - WLAN_HDR_A3_LEN - ie_offset);

		if ((p !=  NULL) && (len <= sizeof(struct vht_cap_elmt))) {
			pstat->vht_cap_len = len;
			memcpy((unsigned char *)&pstat->vht_cap_buf, p+2, len);

			if (priv->pmib->dot11nConfigEntry.dot11nSTBC &&
				(pstat->vht_cap_buf.vht_cap_info & cpu_to_le32(_VHTCAP_RX_STBC_CAP_)))
				pstat->cmn_info.stbc_en |= VHT_STBC_EN;
			if (priv->pmib->dot11nConfigEntry.dot11nLDPC &&
				(pstat->vht_cap_buf.vht_cap_info & cpu_to_le32(_VHTCAP_RX_LDPC_CAP_)))
				pstat->cmn_info.ldpc_en |= VHT_LDPC_EN;
		} else {
			if (priv->pshare->rf_ft_var.ac_tx_force && 
				((p = get_ie(pframe + WLAN_HDR_A3_LEN + ie_offset, _HT_CAP_, &len, 
					pfrinfo->pktlen - WLAN_HDR_A3_LEN - ie_offset)) != NULL) && 
				(len <= sizeof(struct ht_cap_elmt))) {
				// Generate VHT Cap.
				pstat->vht_cap_len = 0xc;
				pstat->vht_cap_buf.vht_cap_info = 0x33800022;
				if ((*(p+5) == 0xff) && (*(p+6) == 0xff) && (*(p+7) == 0xff)) {
					pstat->vht_cap_buf.vht_support_mcs[0] = 0x0492ffea;
					pstat->vht_cap_buf.vht_support_mcs[1] = 0x0000ffea;
				} else if ((*(p+5) == 0xff) && (*(p+6) == 0xff)) {
					pstat->vht_cap_buf.vht_support_mcs[0] = 0x030cfffa;
					pstat->vht_cap_buf.vht_support_mcs[1] = 0x0000fffa;					
				} else {
					pstat->vht_cap_buf.vht_support_mcs[0] = 0x0186fffe;
					pstat->vht_cap_buf.vht_support_mcs[1] = 0x0000fffe;					
				}
			} else if (priv->pmib->dot11RFEntry.phyBandSelect == PHY_BAND_2G) {
				unsigned char vht_ie_id[] = {0x00, 0x90, 0x4c};
				p = pframe + WLAN_HDR_A3_LEN + ie_offset; 
				len = 0;			

				for (;;) {
					//printk("\nOUI limit=%d\n", pfrinfo->pktlen - (p - pframe));
					p = get_ie(p, _RSN_IE_1_, &len, pfrinfo->pktlen - (p - pframe));
					if (p == NULL)
						break;
					
					#if 0//debug
					int i;
					for(i=0; i<len+2; i++){
						if((i%8)==0)
							panic_printk("\n");
						panic_printk("%02x ", *(p+i));						
					}
					panic_printk("\nlen=%d vht_len=%d\n",len, sizeof(struct vht_cap_elmt));
					#endif
					// Bcom VHT IE
					// {0xdd, 0x13} RSN_IE_1-221, length
					// {0x00, 0x90, 0x4c} oui // {0x04 0x08 } unknow
					// {0xbf, 0x0c} element id, length
					if (!memcmp(p+2, vht_ie_id, 3) && (*(p+7) == 0xbf) && ((*(p+8)) <= sizeof(struct vht_cap_elmt))) {
						pstat->vht_cap_len = *(p+8);
						memcpy((unsigned char *)&pstat->vht_cap_buf, p+9, pstat->vht_cap_len);

						if (priv->pmib->dot11nConfigEntry.dot11nSTBC &&
							(pstat->vht_cap_buf.vht_cap_info & cpu_to_le32(_VHTCAP_RX_STBC_CAP_)))
							pstat->cmn_info.stbc_en |= VHT_STBC_EN;
						if (priv->pmib->dot11nConfigEntry.dot11nLDPC &&
							(pstat->vht_cap_buf.vht_cap_info & cpu_to_le32(_VHTCAP_RX_LDPC_CAP_)))
							pstat->cmn_info.ldpc_en |= VHT_LDPC_EN;
						//panic_printk("\n get vht ie in OUI!!! len=%d\n\n", pstat->vht_cap_len);
						break;
					}

					p = p + len + 2;
				}
			}
		}

		p = get_ie(pframe + WLAN_HDR_A3_LEN + ie_offset, EID_VHTOperation, &len,
				pfrinfo->pktlen - WLAN_HDR_A3_LEN - ie_offset);

		if ((p !=  NULL) && (len <= sizeof(struct vht_oper_elmt))) {
			pstat->vht_oper_len = len;
			memcpy((unsigned char *)&pstat->vht_oper_buf, p+2, len);
//			SDEBUG("Receive vht_oper len = %d \n",len);	
		}
	}
#endif
// ====2011-0926 ;roll back ; ht issue 
#if 1
	if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11N) {
		p = get_ie(pframe + WLAN_HDR_A3_LEN + ie_offset, _HT_CAP_, &len,
				pfrinfo->pktlen - WLAN_HDR_A3_LEN - ie_offset);
		if ((p !=  NULL) && (len <= sizeof(struct ht_cap_elmt))) {
			pstat->ht_cap_len = len;
			memcpy((unsigned char *)&pstat->ht_cap_buf, p+2, len);
			if ((priv->pmib->dot11nConfigEntry.dot11nSTBC &&
				pstat->ht_cap_buf.ht_cap_info & cpu_to_le16(_HTCAP_RX_STBC_CAP_)))
				pstat->cmn_info.stbc_en |= HT_STBC_EN;
			if (priv->pmib->dot11nConfigEntry.dot11nLDPC &&
				(pstat->ht_cap_buf.ht_cap_info & cpu_to_le16(_HTCAP_SUPPORT_RX_LDPC_)))
				pstat->cmn_info.ldpc_en |= HT_LDPC_EN;
		}
		else {
			unsigned char old_ht_ie_id[] = {0x00, 0x90, 0x4c};
			p = pframe + WLAN_HDR_A3_LEN + ie_offset; len = 0;
			for (;;)
			{
				p = get_ie(p, _RSN_IE_1_, &len,
					pfrinfo->pktlen - (p - pframe));
				if (p != NULL) {
					if (!memcmp(p+2, old_ht_ie_id, 3) && (*(p+5) == 0x33) && ((len - 4) <= sizeof(struct ht_cap_elmt))) {
						pstat->ht_cap_len = len - 4;
						memcpy((unsigned char *)&pstat->ht_cap_buf, p+6, pstat->ht_cap_len);
						if ((priv->pmib->dot11nConfigEntry.dot11nSTBC &&
							pstat->ht_cap_buf.ht_cap_info & cpu_to_le16(_HTCAP_RX_STBC_CAP_)))
							pstat->cmn_info.stbc_en |= HT_STBC_EN;
						if (priv->pmib->dot11nConfigEntry.dot11nLDPC &&
							(pstat->ht_cap_buf.ht_cap_info & cpu_to_le16(_HTCAP_SUPPORT_RX_LDPC_)))
							pstat->cmn_info.ldpc_en |= HT_LDPC_EN;
						break;
					}
				}
				else
					break;

				p = p + len + 2;
			}
		}
	
		//AC mode only, deny N mode STA
#ifdef RTK_AC_SUPPORT		
		if (!pstat->vht_cap_len && (priv->pmib->dot11StationConfigEntry.legacySTADeny & (WIRELESS_11N))) {
			DEBUG_ERR("AC mode only, deny non-AC STA association!\n");
			DRV_RT_TRACE(priv, DRV_DBG_CONN_INFO, DRV_DBG_SERIOUS, "_STATS_RATE_FAIL_\n");
#ifdef CTC_WIFI_DIAG
			ctcwifi_assoc_err(priv, pstat->cmn_info.mac_addr, "Capability checking failed [AC mode only, deny non-AC STA association!]\n");
#endif
			status = _STATS_RATE_FAIL_;
			goto OnAssocReqFail;
		}
#endif		
		if (pstat->ht_cap_len) {
			// below is the process to check HT MIMO power save
			unsigned char mimo_ps = ((cpu_to_le16(pstat->ht_cap_buf.ht_cap_info)) >> 2)&0x0003;
			pstat->MIMO_ps = 0;
			if (!mimo_ps)
				pstat->MIMO_ps |= _HT_MIMO_PS_STATIC_;
			else if (mimo_ps == 1)
				pstat->MIMO_ps |= _HT_MIMO_PS_DYNAMIC_;
			if (cpu_to_le16(pstat->ht_cap_buf.ht_cap_info) & _HTCAP_AMSDU_LEN_8K_) {
				pstat->is_8k_amsdu = 1;
				if (AMPDU_ENABLE && (AMSDU_ENABLE >= 2)) {
					//pstat->amsdu_level = 4095 - sizeof(struct wlan_hdr);
					pstat->amsdu_level = 3144;	// =(512B+8B+4B)*6	// limit max agg num to 6 for 512B to achieve the maximum tput
				} else {
					pstat->amsdu_level = 7935 - sizeof(struct wlan_hdr);
				}
			}
			else {
				pstat->is_8k_amsdu = 0;
				pstat->amsdu_level = 3839 - sizeof(struct wlan_hdr);
			}

			if (pstat->ht_cap_buf.ht_cap_info & cpu_to_le16(_HTCAP_SUPPORT_CH_WDTH_))
				pstat->tx_bw = CHANNEL_WIDTH_40;
			else
				pstat->tx_bw = CHANNEL_WIDTH_20;

#ifdef RTK_AC_SUPPORT
			if ((priv->pmib->dot11BssType.net_work_type & WIRELESS_11AC) && (pstat->vht_cap_len)) 
			{
				switch(cpu_to_le32(pstat->vht_cap_buf.vht_cap_info) & 0x3) {
					default:
					case 0:	
						pstat->is_8k_amsdu = 0;
						pstat->amsdu_level = 3895 - sizeof(struct wlan_hdr);
						break;
					case 1:
						pstat->is_8k_amsdu = 1;
						pstat->amsdu_level = 7991 - sizeof(struct wlan_hdr);
						break;
					case 2:	
						pstat->is_8k_amsdu = 1;
						pstat->amsdu_level = 11454 - sizeof(struct wlan_hdr);	
						break;
				}
// force 4k
//				pstat->is_8k_amsdu = 0;
//				pstat->amsdu_level = 3895 - sizeof(struct wlan_hdr);
			}
#endif					
		}
		else {
			if(!priv->pmib->wscEntry.wsc_enable){
				if (priv->pmib->dot11StationConfigEntry.legacySTADeny & (WIRELESS_11G | WIRELESS_11A)) {
			DEBUG_ERR("Deny legacy STA association!\n");
			DRV_RT_TRACE(priv, DRV_DBG_CONN_INFO, DRV_DBG_SERIOUS, "Deny legacy STA association!\n");
#ifdef CTC_WIFI_DIAG
			ctcwifi_assoc_err(priv, pstat->cmn_info.mac_addr, "Capability checking failed [Deny legacy STA association!]\n");
#endif
			status = _STATS_RATE_FAIL_;
			goto OnAssocReqFail;
		}
		}
	}

#if defined(RTK_AC_SUPPORT) || defined(RTK_AC_TX_SUPPORT)
		if ((priv->pmib->dot11BssType.net_work_type & WIRELESS_11AC) || priv->pshare->phw->is_AC_TX_support) {
			if (pstat->vht_cap_len) {
				char sta_ch_width = (cpu_to_le32(pstat->vht_cap_buf.vht_cap_info) & _VHTCAP_SUPPORT_CH_WIDTH_) >> 2;
				if (priv->vht_oper_buf.vht_oper_info[0] == 1) {			/* 80 MHz */
						pstat->tx_bw = CHANNEL_WIDTH_80;
				} else if (priv->vht_oper_buf.vht_oper_info[0] == 2) {	/* 160 MHz */
					if (sta_ch_width == 1 || sta_ch_width == 2)
						pstat->tx_bw = CHANNEL_WIDTH_80_80;
					else
						pstat->tx_bw = CHANNEL_WIDTH_80;
				} else if (priv->vht_oper_buf.vht_oper_info[0] == 3) {	/* 80+80 MHz */
					if (sta_ch_width == 2)
						pstat->tx_bw = CHANNEL_WIDTH_80_80;
					else
						pstat->tx_bw = CHANNEL_WIDTH_80;
				}
			}
			
			p = get_ie(pframe + WLAN_HDR_A3_LEN + ie_offset, EID_VHTOperatingMode, &len,
				pfrinfo->pktlen - WLAN_HDR_A3_LEN - ie_offset);
			if ((p !=  NULL) && (len == 1)) {				
				// check self capability....
				if((p[2] &3) <= priv->pshare->CurrentChannelBW)
					pstat->tx_bw = p[2] &3;
				pstat->nss = ((p[2]>>4)&0x7)+1;											
				//printk("receive opering mode data = %x \n", p[2]);
			}
		}
#endif			
		pstat->tx_bw_bak = pstat->tx_bw;
		pstat->shrink_ac_bw = (pstat->tx_bw)? pstat->tx_bw<<2:2;
		pstat->shrink_ac_bw_bak = (priv->pshare->is_40m_bw)? priv->pshare->is_40m_bw<<2:2;
	}
#endif
// ====2011-0926 ; ht issue


#ifdef CONFIG_MBO
	if(assoc_disallowed_status > 0){
		status = _STATS_ASSOC_REJ_TEMP_;
		goto OnAssocReqFail;
	}
#endif

#ifdef STA_CONTROL
#if STA_CONTROL_ALGO == STA_CONTROL_ALGO3
	if(priv->stactrl.stactrl_status  /*band steering on*/
#ifdef RTK_MULTI_AP
		&& priv->pmib->multi_ap.multiap_steering_policy
#endif
	) {
	    if(stactrl_OnAssocReq(priv, GetAddr2Ptr(pframe), WIFI_ASSOCREQ, pfrinfo->rf_info.rssi, &pstat->stactrl_candidate)) {
			#ifdef RTK_SMART_ROAMING
			notify_hidden_ap(priv, STACTRL_HIDDEN_AP);
			#endif
			stactrl_hidden_ap(priv);
			status = _STATS_NO_ASOC_;
			//panic_printk("[%s]#### OnAssocReqFail fail\n",priv->dev->name);
	        goto OnAssocReqFail;
	    }
	}
#else
    if(priv->stactrl.stactrl_status && priv->stactrl.stactrl_prefer == 0
#ifdef RTK_MULTI_AP
		&& priv->pmib->multi_ap.multiap_steering_policy
#endif
	) {  /*band steering on and at non-prefer band*/
        if(!stactrl_pass_request(priv->stactrl.stactrl_priv_sc, GetAddr2Ptr(pframe), WIFI_ASSOCREQ)) {
#ifndef SMP_SYNC
            SAVE_INT_AND_CLI(flags);
            SMP_LOCK_STACONTROL_LIST(flags);
#endif
            val16 = stactrl_check_request(priv, GetAddr2Ptr(pframe), WIFI_ASSOCREQ, pfrinfo->rf_info.rssi);
#ifndef SMP_SYNC
            SMP_UNLOCK_STACONTROL_LIST(flags);
            RESTORE_INT(flags);
#endif
            if(val16 == 2) { /*status code */
		status = _STATS_REJ_BSS_TRANSITION;
		DRV_RT_TRACE(priv, DRV_DBG_CONN_INFO, DRV_DBG_SERIOUS, "STACTL _STATS_REJ_BSS_TRANSITION!\n");
#ifdef CTC_WIFI_DIAG
		ctcwifi_assoc_err(priv, pstat->cmn_info.mac_addr, "Association ignored by band steering [on non-prefer band, reject]\n");
#endif
                goto OnAssocReqFail;
            }
            else if(val16 == 1) {/* ignore */
#ifdef CTC_WIFI_DIAG
                ctcwifi_assoc_err(priv, pstat->cmn_info.mac_addr, "Association ignored by band steering [ignored]\n");
#endif
                return FAIL;
            }
            else if(val16 == 0) { /* do not start sta control process yet */
                pstat->stactrl_candidate = 1;
            }
        }
    }
	else if(priv->stactrl.stactrl_status && priv->stactrl.stactrl_prefer == 1
#ifdef RTK_MULTI_AP
		&& priv->pmib->multi_ap.multiap_steering_policy
#endif
	) {  /*band steering on and at prefer band*/
		stactrl_preferband_sta_add(priv, GetAddr2Ptr(pframe), pfrinfo->rf_info.rssi);
		if(stactrl_check_request_on_preferband(priv, GetAddr2Ptr(pframe), WIFI_ASSOCREQ, pfrinfo->rf_info.rssi)) {
			status = _STATS_REJ_BSS_TRANSITION;
#ifdef CTC_WIFI_DIAG
			ctcwifi_assoc_err(priv, pstat->cmn_info.mac_addr, "Association ignored by band steering [reject on prefer band]\n");
#endif
			goto OnAssocReqFail;
		}
	}
#endif
#endif

#if defined(RTK_MULTI_AP) && (defined(CONFIG_IEEE80211V) || defined(HAPD_11V))
	struct assoc_control_block_list *block_entry;
	block_entry = getEntryBlockList(priv, GetAddr2Ptr(pframe));
	if (block_entry != NULL) {
		//DOT11VDEBUG("Association Request is blocked!\n");
		printk("Association Request is blocked! (%u sec)\n", block_entry->timer);
#ifndef SMP_SYNC
		SAVE_INT_AND_CLI(flags);
		SMP_LOCK_BLOCK_LIST(flags);
#endif
		//deleteEntryBlockList(priv, GetAddr2Ptr(pframe)); //block the STA until time expires
#ifndef SMP_SYNC
		SMP_UNLOCK_BLOCK_LIST(flags);
		RESTORE_INT(flags);
#endif
		status = _STATS_INSUFFICIENT_BANDWIDTH_;
#ifdef CTC_WIFI_DIAG
			ctcwifi_assoc_err(priv, pstat->cmn_info.mac_addr, "Association ignored by multi ap [Association Request is blocked]\n");
#endif
		goto OnAssocReqFail;
	}
#endif // RTK_MULTI_AP || CONFIG_IEEE80211V || HAPD_11V
#ifdef RTK_MULTI_AP
	if (priv->pmib->multi_ap.multiap_max_device_reached) {
		status = _STATS_INSUFFICIENT_BANDWIDTH_;
#ifdef CTC_WIFI_DIAG
			ctcwifi_assoc_err(priv, pstat->cmn_info.mac_addr, "Association ignored by multi ap [max device reached]\n");
#endif
		goto OnAssocReqFail;
	}
#endif

#if (defined RTK_MULTI_AP) && (defined CONFIG_IEEE80211V)
	if (getEntryBlockList(priv, GetAddr2Ptr(pframe)) != NULL) {
		DOT11VDEBUG("Association Request is blocked!\n");
#ifndef SMP_SYNC
		SAVE_INT_AND_CLI(flags);
		SMP_LOCK_BLOCK_LIST(flags);
#endif
		//deleteEntryBlockList(priv, GetAddr2Ptr(pframe)); //block the STA until time expires
#ifndef SMP_SYNC
		SMP_UNLOCK_BLOCK_LIST(flags);
		RESTORE_INT(flags);
#endif
		status = _STATS_INSUFFICIENT_BANDWIDTH_;
		goto OnAssocReqFail;
	}
#endif
#ifdef RTK_MULTI_AP
	if (priv->pmib->multi_ap.multiap_max_device_reached) {
		status = _STATS_INSUFFICIENT_BANDWIDTH_;
		goto OnAssocReqFail;
	}
#endif

#ifdef RTK_SMART_ROAMING
	if(priv->sr_block.sr_block_status && smart_roaming_block_check_request(priv, GetAddr2Ptr(pframe)))
		return FAIL;
#endif

#ifdef WIFI_WMM
	if (QOS_ENABLE) {
		if ((pstat->QosEnabled == 0) && pstat->ht_cap_len) {
			DEBUG_INFO("STA supports HT but doesn't support WMM, force WMM supported\n");
			pstat->QosEnabled = 1;
		}
	}
#endif


#ifdef P2P_SUPPORT	
	if(rtk_p2p_is_enabled(priv)){			/*cfg p2p cfg p2p*/
		p = pframe + WLAN_HDR_A3_LEN + ie_offset ;
		p2pIElen = 0;
		for (;;)
		{
			p = get_ie(p, _P2P_IE_, &len,	
				pfrinfo->pktlen - WLAN_HDR_A3_LEN - ie_offset - len);				
			if (p) {
				if ((len >= 4) && !memcmp(p+2, WFA_OUI_PLUS_TYPE, 4)) {
					if (p2pIElen+len-4 > MAX_REASSEM_P2P_IE) {
						P2P_DEBUG("\n\n	reassemble P2P IE exceed MAX_REASSEM_P2P_IE , chk!!!\n\n");
						IEfoundtimes = 0;
						break;
					}
					IEfoundtimes ++;
					memcpy(p2pIEPtr , p+6 ,len-4);
					p2pIEPtr+= (len-4);
					p2pIElen += len-4;
				}
			}
			else{
				break;
			}
			p = p + len + 2;
			
		}

		if(IEfoundtimes){
			#if 0   // for debug			/*cfg p2p cfg p2p*/
			if(IEfoundtimes>1){
				P2P_DEBUG("ReAssembly p2p IE\n");
			}
            #endif			/*cfg p2p cfg p2p*/
			/*just start record GC's info when i am Real GO*/

                pstat->is_p2p_client = 1;                                    
			if(rtk_p2p_is_enabled(priv)==PROPERTY_P2P){
   					P2P_DEBUG("GC come from:\n");				                    
   					printMac(pfrinfo->sa);                    
					P2P_on_assoc_req(priv,ReAssem_p2pie+6 , p2pIElen-6 , pfrinfo->sa);
				}else if(rtk_p2p_is_enabled(priv)==CFG80211_P2P){
    				ReAssem_p2pie[1] = p2pIElen-2;  // recompute len if this p2p ie has ReAssembly
                    memcpy(pstat->p2p_ie, ReAssem_p2pie, p2pIElen); // report to cfg event , when new sat added
			}
		}
        else{
            memset(pstat->p2p_ie, 0 , 6);
        }
					/*cfg p2p cfg p2p*/
	} 
	
#endif

#if defined(CONFIG_MBO) && defined(CONFIG_IEEE80211V)
	// Identify MBO IE
	p = pframe + WLAN_HDR_A3_LEN + ie_offset; len = 0;
	unsigned char mbo_oui[]={0x50, 0x6f, 0x9a};
	for (;;)
	{
		p = get_ie(p, _VENDOR_SPECIFIC_IE_, &len,
			pfrinfo->pktlen - (p - pframe));
		if(p != NULL){
			if(!memcmp(p+2, mbo_oui, 3) && *(p+2+3) == 0x16){ /* found WFA OUI and type == 0x16 */
				p = p + 2 + 3 + 1;
				len = len - 4;
				while(len > 0){
					// printk("Attribute: %02x\n", *p);
					if(*p == 0x02){ /* found non-preferred channel report attribute */
						unsigned char attr_len;
						attr_len = *(p+1);
						if(attr_len > 0){
							// printk("Attr len: %02x\n", attr_len);
							unsigned char reason_offset, channel_count;
							reason_offset = 1 + attr_len;
							channel_count = attr_len - 3;
							if(attr_len == 3) { /*All channels in operating class*/

							}
							else if(*(p + reason_offset) == 0){ /* non-operable channel */
								memset(pstat->non_operable_channels, 0, sizeof(pstat->non_operable_channels));
								pstat->non_operable_channels_num = 0;
								// panic_printk("add non-operable channels:");
								for(i = 0; i < channel_count; i++){
									pstat->non_operable_channels[i] = *(p+3+i);
									pstat->non_operable_channels_num++;
									// panic_printk(" %d", pstat->non_operable_channels[i]);
								}
							}
							else if(*(p + reason_offset) == 1){ /* non-preferred channel */
								memset(pstat->non_preferred_channels, 0, sizeof(pstat->non_preferred_channels));
								pstat->non_preferred_channels_num = 0;
								// panic_printk("add non-preferred channels:");
								for(i = 0; i < channel_count; i++){
									pstat->non_preferred_channels[i] = *(p+3+i);
									pstat->non_preferred_channels_num++;
									// panic_printk(" %d", pstat->non_preferred_channels[i]);
								}
							}
							else if(*(p + reason_offset) == 255){ /* preferred channel */
								memset(pstat->preferred_channels, 0, sizeof(pstat->preferred_channels));
								pstat->preferred_channels_num = 0;
								// panic_printk("add preferred channels:");
								for(i = 0; i < channel_count; i++){
									pstat->preferred_channels[i] = *(p+3+i);
									pstat->preferred_channels_num++;
									// panic_printk(" %d", pstat->preferred_channels[i]);
								}
							}
							p = p + attr_len + 2; /* point to next attribute */
							len = len - (attr_len + 2);
						}
						else /* STA has no non-preferred channels */
							break;
					}
					else if(*p == 0x03){ /* found cellular data capabilities attribute */
						p = p + 3; // skip this attribute
						len = len - 3;
					}
				}
				break;
			}
		}
		else
			break;

		p = p + len + 2;
	}
#endif

#ifdef RTK_MULTI_AP
	unsigned char wifi_alliance_oui[3] = {0x50, 0x6f,0x9a};
	unsigned char multi_ap_profile = 0;
	pstat->multiap_profile = 0;
	{
		p = pframe + WLAN_HDR_A3_LEN + ie_offset; len = 0;
		for (;;)
		{
			p = get_ie(p, _VENDOR_SPECIFIC_IE_, &len, pfrinfo->pktlen - (p - pframe));

			if (p != NULL) {
				if (!memcmp(p+2, wifi_alliance_oui, 3) && *(p+2+3) == 0x1b) { /*found wifi alliance oui and type == 27*/
					printk("Found Multi-AP IE!!\n");
					if ( (*(p+2+3+1) == 0x06) && (*(p+2+3+3) & BIT7)) {
						pstat->multiap_profile = 1;
					}
					if (len > 7 && (*(p+2+3+3+1) == _MAP_PROFILE_SUBIE_ID_ )) {
						pstat->multiap_profile = *(p+2+3+3+3);
						printk("Multi-AP Profile %d\n", pstat->multiap_profile);
					}
					break;
				}
			}
			else
				break;

			p = p + len + 2;
			continue;
		}

#ifndef RTK_MULTI_AP_LOGO
		if (GET_MAP_PROFILE(priv)) {
			if(0 == (priv->pmib->multi_ap.multiap_bss_type & BIT6) && (0 == (priv->pmib->multi_ap.multiap_bss_type & BIT5)) && pstat->multiap_profile) {
				printk("Non Multi AP Backhaul/Fronthaul BSS, backhaul sta assoc req rejected\n");
				goto OnAssocReqFail;
			} else if ((priv->pmib->multi_ap.multiap_bss_type & BIT6) && (0 == (priv->pmib->multi_ap.multiap_bss_type & BIT5)) && !pstat->multiap_profile) {
				printk("Multi AP backhaul only bss, non backhaul sta assoc req rejected\n");
				goto OnAssocReqFail;
			}
		}
#endif

	}
	//pframe + WLAN_HDR_A3_LEN + ie_offset - copy here onwards
	// Avoid assoc_req_length bigger than assoc_req_body array size
	pstat->assoc_req_length = (pfrinfo->pktlen - WLAN_HDR_A3_LEN) > 255 ? 255 : (pfrinfo->pktlen - WLAN_HDR_A3_LEN);
	memset(pstat->assoc_req_body, 0 , 256);
	memcpy(pstat->assoc_req_body, pframe + WLAN_HDR_A3_LEN, pstat->assoc_req_length);
#endif

	// Use Vendor Specific IE to find IOT
	pstat->is_realtek_sta = FALSE;
	pstat->IOTPeer = HT_IOT_PEER_UNKNOWN;
	p = pframe + WLAN_HDR_A3_LEN + ie_offset; len = 0;
	for (;;) {
		p = get_ie(p, _RSN_IE_1_, &len, pfrinfo->pktlen - (p - pframe));
		if (p != NULL) {
			unsigned char *vsie_oui = p + 2;
			oui = OUI_TO_UINT32(vsie_oui[0], vsie_oui[1], vsie_oui[2]);
			IOTPeer = vsie_oui_2_iot(oui);

			if (IOTPeer == HT_IOT_PEER_REALTEK) {
				if (*(p + 2 + 3) == 2) { /* Found Realtek OUI and type == 2 */
					pstat->is_realtek_sta = TRUE;
					pstat->IOTPeer = HT_IOT_PEER_REALTEK;

					if (*(p+2+3+2) & RTK_CAP_IE_USE_AMPDU)
						pstat->is_forced_ampdu = TRUE;
					else
						pstat->is_forced_ampdu = FALSE;

#ifdef RTK_WOW
					if (*(p+2+3+2) & RTK_CAP_IE_USE_WOW)
							pstat->IOTPeer = HT_IOT_PEER_REALTEK_WOW;
#endif
					if (*(p+2+3+2) & RTK_CAP_IE_WLAN_8192SE)
							pstat->IOTPeer = HT_IOT_PEER_REALTEK_92SE;
					if (*(p+2+3+2) & RTK_CAP_IE_WLAN_88C92C)
							pstat->IOTPeer = HT_IOT_PEER_REALTEK_81XX;

					if (len==7 && (*(p+2+3+3) & ( RTK_CAP_IE_8812_BCUT | RTK_CAP_IE_8812_CCUT)))
								pstat->IOTPeer = HT_IOT_PEER_REALTEK_8812;

					if (pstat->ht_cap_buf.support_mcs[2]) { /* support 3 stream */
								pstat->IOTPeer = HT_IOT_PEER_REALTEK_8814;
					}

					if (*(p+2+3+2) & RTK_CAP_IE_AP_CLIENT)
						pstat->IOTPeer = HT_IOT_PEER_RTK_APCLIENT;

					/* Found IOT, exit VSIE search loop */
					break;
				} else {
					// A Realtek proprietary IE deesn't indicate this is a Realtek IC
					// Check next VSIE
				}
			} else if (IOTPeer != HT_IOT_PEER_UNKNOWN) {
				pstat->IOTPeer = IOTPeer;
				break;
			} else { /* IOTPeer == HT_IOT_PEER_UNKNOWN */
				// Check next VSIE
			}
		} else { /* No more VSIE */
			break;
		}

		p = p + len + 2;
	}

	// Use STA's MAC to find IOT
	if (pstat->IOTPeer == HT_IOT_PEER_UNKNOWN) {
		oui = OUI_TO_UINT32(pstat->cmn_info.mac_addr[0],
				pstat->cmn_info.mac_addr[1], pstat->cmn_info.mac_addr[2]);
		IOTPeer = mac_oui_2_iot(oui);

#ifndef CONFIG_SPECIAL_ENV_TEST
		if ((IOTPeer == HT_IOT_PEER_SPIRENT) ||
				(IOTPeer == HT_IOT_PEER_VERIWAVE)) {
			// Since CONFIG_SPECIAL_ENV_TEST is not defined
			// pstat->IOTPeer = HT_IOT_PEER_UNKNOWN;
		} else
#endif
		if (pstat->IOTPeer == HT_IOT_PEER_OCTOSCOPE) {
			if ((pstat->cmn_info.mac_addr[3] & 0xF0) == 0x90) {
				pstat->IOTPeer = HT_IOT_PEER_OCTOSCOPE;
			} else {
				// pstat->IOTPeer = HT_IOT_PEER_UNKNOWN;
			}
		} else {
			pstat->IOTPeer = IOTPeer;
		}
	}

#ifdef CONFIG_SPECIAL_ENV_TEST
	if (priv->pshare->rf_ft_var.spec_env_test_en & BIT7)
		pstat->IOTPeer = HT_IOT_PEER_VERIWAVE;
#endif
	
    if ((priv->pmib->dot11RFEntry.phyBandSelect & PHY_BAND_2G) && pstat->ht_cap_len
        && (get_rf_mimo_mode(priv) == RF_1T1R || get_rf_mimo_mode(priv) == RF_2T2R)
        /*&& pstat->IOTPeer != HT_IOT_PEER_SPIRENT && pstat->IOTPeer != HT_IOT_PEER_VERIWAVE*/)
    {
        pstat->is_8k_amsdu = 0;//11n set to 4k
		pstat->amsdu_level = 3839 - sizeof(struct wlan_hdr);
    }

#ifdef MCR_WIRELESS_EXTEND
	if ((GET_CHIP_VER(priv)==VERSION_8812E) || (GET_CHIP_VER(priv)==VERSION_8192E) || (GET_CHIP_VER(priv)==VERSION_8814A)) {
		if (!memcmp(pstat->cmn_info.mac_addr, "\x00\x01\x02\x03\x04\x05", MACADDRLEN)) {
			pstat->IOTPeer = HT_IOT_PEER_CMW;
			priv->pshare->cmw_link = 1;
			priv->pshare->rf_ft_var.tx_pwr_ctrl = 0;
#ifdef CONFIG_WLAN_HAL_8814AE			
			if (GET_CHIP_VER(priv)==VERSION_8814A) {
#ifdef DFS			
				priv->pshare->rf_ft_var.dfs_psd_idle_on= 0;
#endif				
				//phy_set_bb_reg(priv, 0x93c, 0xfff00000, 0x106);
				phy_set_bb_reg(priv, 0x808, 0xff, 0x66);

				//phy_set_bb_reg(priv, 0x808, 0x0f00, 0x0);

				if (priv->pshare->is_40m_bw == CHANNEL_WIDTH_80) {
					phy_set_bb_reg(priv, 0x838, BIT0, 0x1);
					if (get_rf_mimo_mode(priv) == RF_2T2R) {
						phy_set_bb_reg(priv, 0x82C, 0x0fff0000, 0x5a9);
						phy_set_bb_reg(priv, 0x838, 0x0fff0000, 0x788);
						phy_set_bb_reg(priv, 0x840, 0x0000f000, 0x6);
						RTL_W8(0x830,0xa);
					} else {
						phy_set_bb_reg(priv, 0x82C, 0x0fff0000, 0x398);
						phy_set_bb_reg(priv, 0x838, 0x0fff0000, 0x777);
						phy_set_bb_reg(priv, 0x840, 0x0000f000, 0x7);
						RTL_W8(0x830,0x8);
					} 
				} 		
			} else
#endif						
#ifdef CONFIG_RTL_8812_SUPPORT
			if (GET_CHIP_VER(priv)==VERSION_8812E) {
				phy_set_bb_reg(priv, 0x878, BIT(12)|BIT(13), 0);
			} else			
#endif
#ifdef CONFIG_WLAN_HAL_8192EE
			if (GET_CHIP_VER(priv)==VERSION_8192E) {
				RTL_W16(RESP_SIFS_CCK, 0x0808);
				RTL_W8(0xa2f, 0x0);
				RTL_W8(0xa20, 0x10);											
			}
#endif			
		}
	}
#endif

#ifdef A4_STA
    if(priv->pmib->miscEntry.a4_enable) {
        if(priv->pmib->miscEntry.a4_enable == 2) {
            if(0 < parse_a4_ie(priv, pframe + WLAN_HDR_A3_LEN + ie_offset, pfrinfo->pktlen - (WLAN_HDR_A3_LEN + ie_offset))) {
                add_a4_client(priv, pstat);
            }       
        }
        a4_sta_update(GET_ROOT(priv), NULL, pstat->cmn_info.mac_addr);
    }
#endif

#ifdef TV_MODE
    if(priv->tv_mode_status & BIT1){ /*tv mode is auto*/
        if(0 < parse_tv_mode_ie(priv, pframe + WLAN_HDR_A3_LEN + ie_offset, pfrinfo->pktlen - (WLAN_HDR_A3_LEN + ie_offset))) {
            pstat->tv_auto_support = 1;
            priv->tv_mode_status |= BIT0; /* set tv mode to auto(enable)*/
        }
    }
#endif

	assign_tx_rate(priv, pstat, pfrinfo);

	SAVE_INT_AND_CLI(flags);
	auth_list_del(priv, pstat);
	if (asoc_list_add(priv, pstat))
	{
		pstat->expire_to = priv->expire_to;
		//printk("wlan%d pstat->asoc_list = %p priv->asoc_list=%p\n",priv->pshare->wlandev_idx, pstat->asoc_list, priv->asoc_list);
		cnt_assoc_num(priv, pstat, INCREASE, (char *)__FUNCTION__);
		check_sta_characteristic(priv, pstat, INCREASE);
		if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11N)
			construct_ht_ie(priv, priv->pshare->is_40m_bw, priv->pshare->offset_2nd_chan);
#ifdef ADDRESS_CAM
		if(IS_SUPPORT_ADDR_CAM(priv))
			GET_HAL_INTERFACE(priv)->SetADDRCAMHandler(priv,(pu1Byte)pstat->cmn_info.mac_addr);
#endif
	}
	RESTORE_INT(flags);

#if defined(WIFI_11N_2040_COEXIST_EXT)
	update_40m_staMap(priv, pstat, 0);
	checkBandwidth(priv);
	if ((priv->pmib->dot11BssType.net_work_type & WIRELESS_11N) && (priv->ht_cap_len == 0))
		construct_ht_ie(priv, priv->pshare->is_40m_bw, priv->pshare->offset_2nd_chan);		
#endif

#ifdef CONFIG_WLAN_HAL
	if (IS_HAL_CHIP(priv)) {
		init_rainfo(priv, pstat);
	} else
#endif
#if defined(CONFIG_RTL_8812_SUPPORT) || defined(CONFIG_RTL_8723B_SUPPORT)
	if(GET_CHIP_VER(priv)== VERSION_8812E || GET_CHIP_VER(priv)== VERSION_8723B) {
		UpdateHalRAMask8812(priv, pstat, 3);
	} else
#endif
#ifdef CONFIG_RTL_88E_SUPPORT
	if (GET_CHIP_VER(priv)==VERSION_8188E) {
#ifdef TXREPORT
		add_RATid(priv, pstat);
#endif
	} else
#endif
	{
#if defined(CONFIG_RTL_92D_SUPPORT) || defined(CONFIG_RTL_92C_SUPPORT)	
		add_update_RATid(priv, pstat);
#endif
	}
	assign_aggre_mthod(priv, pstat);
	assign_aggre_size(priv, pstat);

	update_intel_sta_bitmap(priv, pstat, 0);
	
	// Customer proprietary IE
	if (priv->pmib->miscEntry.private_ie_len) {
		p = get_ie(pframe + WLAN_HDR_A3_LEN + ie_offset, priv->pmib->miscEntry.private_ie[0], &len,
				pfrinfo->pktlen - WLAN_HDR_A3_LEN - ie_offset);
		if (p && ((len+2)<=sizeof(pstat->private_ie))) {
			memcpy(pstat->private_ie, p, len + 2);
			pstat->private_ie_len = len + 2;
		}
	}

#ifdef ROAMING_SUPPORT
	if(priv->pmib->roamingEntry.roaming_enable)
	{
		general_IndicateEvent(priv,DOT11_EVENT_ROAMING_STA_INFO_REPORT,pstat);
	}
#endif

	DEBUG_INFO("%s %pm\n",(frame_type == WIFI_ASSOCREQ)? "OnAssocReq" : "OnReAssocReq",
		pstat->cmn_info.mac_addr);

#ifdef ENABLE_SAE_H2E
	// OnAssocReq
	if ( support_wpa3(priv) && pstat->is_sae_sta ) {
		p = pframe + WLAN_HDR_A3_LEN + ie_offset;
		len = 0;

		p = get_ie(p, _RSNX_IE_, &len, pfrinfo->pktlen);
		if ( ( p != NULL) && (len < 16) )  {
			memcpy(pstat->rsnxe_ie, p, (len +2) ); // +2 with ie header
			pstat->with_h2e = 1;
		} else
			pstat->with_h2e = 0;
	} else
		pstat->with_h2e = 0;
#endif

	/* 1. If 802.1x enabled, get RSN IE (if exists) and indicate ASSOIC_IND event
	 * 2. Set dot118021xAlgrthm, dot11PrivacyAlgrthm in pstat
	 */
	if (IEEE8021X_FUN || IAPP_ENABLE || priv->pmib->wscEntry.wsc_enable)
	{
		p = pframe + WLAN_HDR_A3_LEN + ie_offset; len = 0;
		for(;;)
		{
#ifdef RTL_WPA2
			char tmpbuf[128];
			int buf_len=0;
			p = get_rsn_ie(priv, p, &len,
				pfrinfo->pktlen - (p - pframe));

			buf_len = snprintf(tmpbuf, sizeof(tmpbuf), "RSNIE len = %d, p = %s", len, (p==NULL? "NULL":"non-NULL"));
			if (p != NULL)
				buf_len += snprintf(tmpbuf+buf_len, sizeof(tmpbuf)-buf_len, ", ID = %02X\n", *(unsigned char *)p);
			else
				buf_len += snprintf(tmpbuf+buf_len, sizeof(tmpbuf)-buf_len, "\n");
			DEBUG_INFO("%s", tmpbuf);
#else
			p = get_ie(p, _RSN_IE_1_, &len,
				pfrinfo->pktlen - (p - pframe));
#endif
			/*cfg p2p cfg p2p
			if (p == NULL)
#ifdef WIFI_HAPD
			{
				memset(pstat->wpa_ie, 0, 256);
				break;
			}
#else
				break;
#endif
			*/
			if (p == NULL){
                #if defined(WIFI_HAPD) || defined(RTK_NL80211)
                memset(pstat->wpa_ie, 0, 6);
                #endif
                break;
            }

			/*cfg p2p cfg p2p*/
#if defined(WIFI_HAPD) || defined(RTK_NL80211)
			if((*(unsigned char *)p == _RSN_IE_1_)&& (len >= 4))
			{
				pstat->wpa_sta_info->RSNEnabled = BIT(0);
				memcpy(pstat->wpa_ie, p, len+2);
			}
			else if((*(unsigned char *)p == _RSN_IE_2_) && (len >= 2))
			{
				pstat->wpa_sta_info->RSNEnabled = BIT(1);
				memcpy(pstat->wpa_ie, p, len+2);
			}
#endif

#ifdef WPA2_ENH
			if ((*(unsigned char *)p == _RSN_IE_2_)){
				if((len >= 2)) {
					if(memcmp((void *)(p + 2), (void *)rsnie_hdr_wpa2, 2)){
						log("RSN_IE_2 with invalid version %02x %02x", p[2], p[3]);
						status = __STATS_INVALID_IE_;
						goto OnAssocReqFail;
					}
				}
				else {
					log("RSN_IE_2 with invalid len[%d]", len);
					status = __STATS_INVALID_IE_;
					goto OnAssocReqFail;
				}
			}
#endif

#ifdef RTL_WPA2
			if ((*(unsigned char *)p == _RSN_IE_1_) && (len >= 4) && (!memcmp((void *)(p + 2), (void *)rsnie_hdr, 4))) {
#ifdef TLN_STATS
				pstat->enterpise_wpa_info = STATS_ETP_WPA;
#endif
				break;
}

			if ((*(unsigned char *)p == _RSN_IE_2_) && (len >= 2) && (!memcmp((void *)(p + 2), (void *)rsnie_hdr_wpa2, 2))) {
#ifdef TLN_STATS
				pstat->enterpise_wpa_info = STATS_ETP_WPA2;
#endif
				break;
			}

            #ifdef HS2_SUPPORT
            if ((*(unsigned char *)p == _RSN_IE_1_) && (len >= 4) && (!memcmp((void *)(p + 2), (void *)rsnie_hdr_OSEN, 4))) {
                HS2DEBUG("found OSEN IE in Assoc Req\n");
                #ifdef TLN_STATS
                pstat->enterpise_wpa_info = STATS_ETP_WPA2;
                #endif
                break;
            }
            #endif // HS2_SUPPORT

#else
			if ((len >= 4) && (!memcmp((void *)(p + 2), (void *)rsnie_hdr, 4))) {
#ifdef TLN_STATS
				pstat->enterpise_wpa_info = STATS_ETP_WPA;
#endif
				break;
			}
#endif

			p = p + len + 2;
		}

#ifdef WIFI_SIMPLE_CONFIG
/* WPS2DOTX   -start*/
		if (priv->pmib->wscEntry.wsc_enable & 2) { // work as AP (not registrar)
			unsigned char *ptmp;
			unsigned char *TagPtr=NULL;
			int IS_V2=0;
			int Taglen = 0;
			int Taglent2 = 0;
			unsigned int lentmp = 0;
			unsigned char passWscIE=0;
			unsigned char both_band_cred = 0;
			DOT11_WSC_ASSOC_IND wsc_Association_Ind;

		//================both_band_credential====================
		if(priv->pmib->wscEntry.both_band_multicredential){
			ptmp = pframe + WLAN_HDR_A3_LEN + ie_offset;
			for (;;)
			{
				ptmp = get_ie(ptmp, 221, (int *)&lentmp , pfrinfo->pktlen - (ptmp - pframe));
				if (ptmp != NULL) {
					if (!memcmp(ptmp+2, NEC_OUI, 3) && ptmp[5] == 0x06 && (ptmp[8] & BIT7)) {
						both_band_cred = 1;
						break;
					}
				}
				else{
					break;
				}
				ptmp = ptmp + lentmp + 2;
			}
		}
		//==================================================

			ptmp = pframe + WLAN_HDR_A3_LEN + ie_offset;

			for (;;)
			{
				ptmp = get_ie(ptmp, _WPS_IE_, (int *)&lentmp , pfrinfo->pktlen - (ptmp - pframe));
				if (ptmp != NULL) {
					if ((lentmp >= 4) && !memcmp(ptmp+2, WSC_IE_OUI, 4)) {
					if ((lentmp + 2) <= (MIN_NUM(PROBEIELEN,256))) {	//256 is size of pstat->wps_ie
#if (defined(RTK_NL80211) || defined(WIFI_HAPD)) && !defined(HAPD_DRV_PSK_WPS)
						//printk("copy wps_ie \n");
						memcpy(pstat->wps_ie, ptmp, lentmp+2);
#endif

						TagPtr = search_wsc_tag(ptmp+2+4, TAG_REQUEST_TYPE, lentmp-4, &Taglen);
						if (TagPtr && (*TagPtr <= MAX_REQUEST_TYPE_NUM)) {
							SME_DEBUG("found WSC_IE TAG_REQUEST_TYPE=%d (from %pm)\n",*TagPtr , pstat->cmn_info.mac_addr);
							passWscIE = 1;
						}

						TagPtr = search_wsc_tag(ptmp+2+4, TAG_VENDOR_EXT, lentmp-4, &Taglen);
						if (TagPtr != NULL)	{
							if(!memcmp(TagPtr , WSC_VENDOR_OUI ,3 )){
								SME_DEBUG("Found WFA-vendor OUI!!\n");
								TagPtr = search_VendorExt_tag(TagPtr ,VENDOR_VERSION2 , Taglen , &Taglent2);
								if(TagPtr){
									IS_V2 = 1;
									SME_DEBUG("sme Rev version2(0x%x) ProReq\n",TagPtr[0]);
								}
							}
						}

						break;
					} else {
						DEBUG_INFO(" from %pm, len(%d)>%d,chk!\n",pstat->cmn_info.mac_addr,	lentmp + 2, (MIN_NUM(PROBEIELEN,256)) );
					}
					}
				}
				else{
#if (defined(RTK_NL80211) || defined(WIFI_HAPD)) && !defined(HAPD_DRV_PSK_WPS)
					memset(pstat->wps_ie, 0, 256);
#endif
					break;
				}

				ptmp = ptmp + lentmp + 2;
			}

			memset(&wsc_Association_Ind, 0, sizeof(DOT11_WSC_ASSOC_IND));
			wsc_Association_Ind.EventId = DOT11_EVENT_WSC_ASSOC_REQ_IE_IND;
			memcpy((void *)wsc_Association_Ind.MACAddr, (void *)GetAddr2Ptr(pframe), MACADDRLEN);
			if (passWscIE) {
				if(both_band_cred){
					//indicates wscd for both_band_credential
					memcpy((void *)wsc_Association_Ind.AssocIE, "\x10\xFF\x00\x01\x01", 5); // T(0x10ff)L(1)V(1)
					if (wsc_Association_Ind.AssocIELen > (PROBEIELEN - 5))
						wsc_Association_Ind.AssocIELen = PROBEIELEN - 5;
					memcpy((void *)wsc_Association_Ind.AssocIE + 5, (void *)(ptmp), wsc_Association_Ind.AssocIELen);					
					panic_printk("[%s]%d both_band_cred_ind =1 \n",__FUNCTION__,__LINE__);
				}else{
					if (wsc_Association_Ind.AssocIELen > PROBEIELEN)
						wsc_Association_Ind.AssocIELen = PROBEIELEN;
					memcpy((void *)wsc_Association_Ind.AssocIE, (void *)(ptmp), wsc_Association_Ind.AssocIELen);
				}
				wsc_Association_Ind.wscIE_included = 1;
				wsc_Association_Ind.AssocIELen = lentmp + 2;

			}
			else {
				/*modify for WPS2DOTX SUPPORT*/
				if(IS_V2==0)
				{	
					/*when sta is wps1.1 case then should be run below path*/ 
					if (IEEE8021X_FUN &&
						(pstat->AuthAlgrthm == _NO_PRIVACY_) && // authentication is open
						(p == NULL)) // No SSN or RSN IE
					{ 
						wsc_Association_Ind.wscIE_included = 1; //treat this case as WSC IE included
						SME_DEBUG("Association : auth open & no SSN or RSN IE , for wps1.1 case\n");
					}
				}
			}

             /*   wscIE_included :
                  case 1:  make sure STA include WSC IE
                  case 2:  because auth == open & no SSN or RSN IE ;so we
                           treat this case as WSC IE included
             */
			/*modify for WPS2DOTX SUPPORT*/
			if ((wsc_Association_Ind.wscIE_included == 1) || !IEEE8021X_FUN){
#ifdef INCLUDE_WPS
			
				wps_NonQueue_indicate_evt(priv ,
					(UINT8 *)&wsc_Association_Ind,sizeof(DOT11_WSC_ASSOC_IND));
#else

				DOT11_EnQueue((unsigned long)priv, priv->pevent_queue, (UINT8 *)&wsc_Association_Ind,
						sizeof(DOT11_WSC_ASSOC_IND));
#endif
			}
			/*modify for WPS2DOTX SUPPORT*/
			if (wsc_Association_Ind.wscIE_included == 1) {
				pstat->state |= WIFI_WPS_JOIN;
				goto OnAssocReqSuccess;
			}
// Brad add for DWA-652 WPS interoperability 2008/03/13--------
			if ((pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm == _WEP_40_PRIVACY_ ||
     				pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm == _WEP_104_PRIVACY_) &&
     				!IEEE8021X_FUN)
				pstat->state |= WIFI_WPS_JOIN;
//------------------------- end

		}
/* WPS2DOTX   -end*/		
#endif

// ====2011-0926 ;roll back ; ht issue
#if 1
	if(priv->pmib->wscEntry.wsc_enable) {
		if (!pstat->ht_cap_len && (priv->pmib->dot11StationConfigEntry.legacySTADeny & (WIRELESS_11G | WIRELESS_11A))) {
			DEBUG_ERR("Deny legacy STA association!\n");
			status = _STATS_RATE_FAIL_;
			DRV_RT_TRACE(priv, DRV_DBG_CONN_INFO, DRV_DBG_SERIOUS, "Deny legacy STA association!\n");
			SAVE_INT_AND_CLI(flags);
			asoc_list_del(priv, pstat);
			cnt_assoc_num(priv, pstat, DECREASE, (char *)__FUNCTION__);
			check_sta_characteristic(priv, pstat, DECREASE);
			RESTORE_INT(flags);
#ifdef CTC_WIFI_DIAG
			ctcwifi_assoc_err(priv, pstat->cmn_info.mac_addr, "Capability checking failed [WSC: Deny legacy STA association!]\n");
#endif
			goto OnAssocReqFail;
		}
	}
#endif
// ====2011-0926 end


	if ((priv->pmib->dot11BssType.net_work_type & WIRELESS_11N) &&
		(pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm != _NO_PRIVACY_))
	{
		int mask_mcs_rate = 0;
		if 	((pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm == _WEP_40_PRIVACY_) ||
			 (pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm == _WEP_104_PRIVACY_))
			mask_mcs_rate = 2;
#ifdef CONFIG_RTL_WAPI_SUPPORT	
		else if(pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm == _WAPI_SMS4_) {
			mask_mcs_rate = 0;
		}
#endif
		else {
			if (p == NULL)
				mask_mcs_rate = 1;
			else {
				if (*p == _RSN_IE_1_) {
					if (is_support_wpa_aes(priv,  p, len+2) != 1)
						mask_mcs_rate = 1;
				}
				else if (*p == _RSN_IE_2_) {
					if (is_support_wpa2_aes(priv,  p, len+2) != 1)
						mask_mcs_rate = 1;
				}
				else
						mask_mcs_rate = 1;
			}
		}

		if (mask_mcs_rate) {
			pstat->is_legacy_encrpt = mask_mcs_rate;
			assign_tx_rate(priv, pstat, pfrinfo);
#ifdef CONFIG_WLAN_HAL
			if (IS_HAL_CHIP(priv)) {
				init_rainfo(priv, pstat);
			} else
#endif
#if defined(CONFIG_RTL_8812_SUPPORT) || defined(CONFIG_RTL_8723B_SUPPORT)
			if(GET_CHIP_VER(priv)== VERSION_8812E || GET_CHIP_VER(priv)== VERSION_8723B) {
				UpdateHalRAMask8812(priv, pstat, 3);
			} else
#endif
#ifdef CONFIG_RTL_88E_SUPPORT
			if (GET_CHIP_VER(priv)==VERSION_8188E) {
#ifdef TXREPORT
				add_RATid(priv, pstat);
#endif
			} else
#endif
			{
#if defined(CONFIG_RTL_92D_SUPPORT) || defined(CONFIG_RTL_92C_SUPPORT)
				add_update_RATid(priv, pstat);
#endif
			}
			assign_aggre_mthod(priv, pstat);
		}
	}

#ifndef WITHOUT_ENQUEUE
		if (frame_type == WIFI_ASSOCREQ)
		{
			memcpy((void *)Association_Ind.MACAddr, (void *)GetAddr2Ptr(pframe), MACADDRLEN);
			Association_Ind.EventId = DOT11_EVENT_ASSOCIATION_IND;
			Association_Ind.IsMoreEvent = 0;
			if (p == NULL)
				Association_Ind.RSNIELen = 0;
			else
			{
				DEBUG_INFO("assoc indication rsnie len=%d\n", len);
#ifdef RTL_WPA2
				// inlcude ID and Length
				Association_Ind.RSNIELen = len + 2;
				if (Association_Ind.RSNIELen > MAXRSNIELEN)
					Association_Ind.RSNIELen = MAXRSNIELEN;
				memcpy((void *)Association_Ind.RSNIE, (void *)(p), Association_Ind.RSNIELen);
#else
				Association_Ind.RSNIELen = len;
				if (Association_Ind.RSNIELen > MAXRSNIELEN)
					Association_Ind.RSNIELen = MAXRSNIELEN;
				memcpy((void *)Association_Ind.RSNIE, (void *)(p + 2), Association_Ind.RSNIELen);
#endif
			}
			// indicate if 11n sta associated
			Association_Ind.RSNIE[MAXRSNIELEN-1] = ((pstat->ht_cap_len==0) ? 0 : 1);

			DOT11_EnQueue((unsigned long)priv, priv->pevent_queue, (UINT8 *)&Association_Ind,
						sizeof(DOT11_ASSOCIATION_IND));
		}
		else
		{
			memcpy((void *)Reassociation_Ind.MACAddr, (void *)GetAddr2Ptr(pframe), MACADDRLEN);
			Reassociation_Ind.EventId = DOT11_EVENT_REASSOCIATION_IND;
			Reassociation_Ind.IsMoreEvent = 0;
			if (p == NULL)
				Reassociation_Ind.RSNIELen = 0;
			else
			{
				DEBUG_INFO("assoc indication rsnie len=%d\n", len);
#ifdef RTL_WPA2
				// inlcude ID and Length
				Reassociation_Ind.RSNIELen = len + 2;
				if (Reassociation_Ind.RSNIELen > MAXRSNIELEN)
					Reassociation_Ind.RSNIELen = MAXRSNIELEN;
				memcpy((void *)Reassociation_Ind.RSNIE, (void *)(p), Reassociation_Ind.RSNIELen);
#else
				Reassociation_Ind.RSNIELen = len;
				if (Reassociation_Ind.RSNIELen > MAXRSNIELEN)
					Reassociation_Ind.RSNIELen = MAXRSNIELEN;
				memcpy((void *)Reassociation_Ind.RSNIE, (void *)(p + 2), Reassociation_Ind.RSNIELen);
#endif
			}
			memcpy((void *)Reassociation_Ind.OldAPaddr,
				(void *)(pframe + WLAN_HDR_A3_LEN + _CAPABILITY_ + _LISTEN_INTERVAL_), MACADDRLEN);

			// indicate if 11n sta associated
			Reassociation_Ind.RSNIE[MAXRSNIELEN-1] = ((pstat->ht_cap_len==0) ? 0 : 1);

#ifdef CONFIG_IEEE80211R
			if (FT_ENABLE && pstat->wpa_sta_info->isFT && pstat->ft_state == state_ft_assoc) {
				// don't indicate to upper
			} else
#endif
			DOT11_EnQueue((unsigned long)priv, priv->pevent_queue, (UINT8 *)&Reassociation_Ind,
						sizeof(DOT11_REASSOCIATION_IND));
		}
#endif // WITHOUT_ENQUEUE

#ifdef RTK_NL80211
	//printk("pstat=0x%x at %d: %02x %02x %02x\n", pstat, __LINE__, pstat->wpa_ie[0], pstat->wpa_ie[1], pstat->wpa_ie[2]);
	//event_indicate_cfg80211(priv, GetAddr2Ptr(pframe), CFG80211_NEW_STA, pstat);
#endif

#if defined(INCLUDE_WPA_PSK) || defined(WIFI_HAPD) || defined(RTK_NL80211)
		{
			int id;
			unsigned char *pIE;
			int ie_len;

#if !(defined(__ECOS) && defined(CONFIG_SDIO_HCI))
			/*msg too much will cause veriwave 40STA hard to test*/
			//LOG_MSG("A wireless client is associated - %pm\n",pfrinfo->sa);
#endif

			if (frame_type == WIFI_ASSOCREQ)
				id = DOT11_EVENT_ASSOCIATION_IND;
			else
				id = DOT11_EVENT_REASSOCIATION_IND;

#ifdef RTL_WPA2
			ie_len = len + 2;
			pIE = p;
#else
			ie_len = len;
			pIE = p + 2;
#endif
#ifdef CONFIG_IEEE80211R
			if (FT_ENABLE && pstat->wpa_sta_info->isFT && pstat->ft_state == state_ft_assoc)
				psk_indicate_evt(priv, DOT11_EVENT_FT_ASSOC_IND, GetAddr2Ptr(pframe), pIE, ie_len);
			else
#endif
			if(priv->pmib->dot1180211AuthEntry.dot11EnablePSK &&
				(status = psk_indicate_evt(priv, id, GetAddr2Ptr(pframe), pIE, ie_len)) != 0)
				goto OnAssocReqFail;
		}
#endif // INCLUDE_WPA_PSK

#ifdef RTK_NL80211
		//printk("pstat=0x%x at %d: %02x %02x %02x\n", pstat, __LINE__, pstat->wpa_ie[0], pstat->wpa_ie[1], pstat->wpa_ie[2]);
		//event_indicate_cfg80211(priv, GetAddr2Ptr(pframe), CFG80211_NEW_STA, pstat);
#else //RTK_NL80211
#ifdef WIFI_HAPD
		event_indicate_hapd(priv, GetAddr2Ptr(pframe), HAPD_REGISTERED, NULL);
#ifdef HAPD_DRV_PSK_WPS
		event_indicate(priv, GetAddr2Ptr(pframe), 1);
#endif
#else
		event_indicate(priv, GetAddr2Ptr(pframe), 1);
#endif
#ifdef WIFI_WPAS
		//printk("_Eric WPAS_REGISTERED at %s %d \n", __FUNCTION__, __LINE__);
		event_indicate_wpas(priv, GetAddr2Ptr(pframe), WPAS_REGISTERED, NULL);
#endif
#ifdef RTK_NL80211
		event_indicate_cfg80211(priv, GetAddr2Ptr(pframe), CFG80211_CONNECT_RESULT, NULL);
#endif
#endif //RTK_NL80211
	}
#ifdef HS2_SUPPORT
	calcu_sta_v6ip(pstat);
#endif

//#ifndef INCLUDE_WPA_PSK
#if defined(CONFIG_RTL8196B_TR) || defined(CONFIG_RTL8196C_EC)
	if (!IEEE8021X_FUN &&
			!(priv->pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm == _TKIP_PRIVACY_ ||
			 priv->pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm == _CCMP_PRIVACY_))
			LOG_MSG_NOTICE("Wireless PC connected;note:%02x-%02x-%02x-%02x-%02x-%02x;\n",
				*GetAddr2Ptr(pframe), *(GetAddr2Ptr(pframe)+1), *(GetAddr2Ptr(pframe)+2),
				*(GetAddr2Ptr(pframe+3)), *(GetAddr2Ptr(pframe)+4), *(GetAddr2Ptr(pframe)+5));
#elif defined(CONFIG_RTL865X_AC) || defined(CONFIG_RTL865X_KLD) || defined(CONFIG_RTL8196B_KLD) || defined(CONFIG_RTL8196C_KLD)
	if (!IEEE8021X_FUN &&
			!(priv->pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm == _TKIP_PRIVACY_ ||
			 priv->pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm == _CCMP_PRIVACY_))
			LOG_MSG_NOTICE("Wireless PC connected;note:%02x-%02x-%02x-%02x-%02x-%02x;\n",
				*GetAddr2Ptr(pframe), *(GetAddr2Ptr(pframe)+1), *(GetAddr2Ptr(pframe)+2),
				*(GetAddr2Ptr(pframe+3)), *(GetAddr2Ptr(pframe)+4), *(GetAddr2Ptr(pframe)+5));
#elif defined(CONFIG_RTL8196B_TLD)
	if (!IEEE8021X_FUN &&
			!(priv->pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm == _TKIP_PRIVACY_ ||
			 priv->pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm == _CCMP_PRIVACY_)) {
			if (!list_empty(&priv->wlan_acl_list)) {
				LOG_MSG_DEL("[WLAN access allowed] from MAC: %02x:%02x:%02x:%02x:%02x:%02x,\n",
				*GetAddr2Ptr(pframe), *(GetAddr2Ptr(pframe)+1), *(GetAddr2Ptr(pframe)+2),
				*(GetAddr2Ptr(pframe+3)), *(GetAddr2Ptr(pframe)+4), *(GetAddr2Ptr(pframe)+5));
			}
	}
#elif defined(__ECOS) && defined(CONFIG_SDIO_HCI)
	if (priv->sta_status_cb_func)
		priv->sta_status_cb_func("wlan0", GetAddr2Ptr(pframe), ((frame_type == WIFI_ASSOCREQ)? WIFI_STA_STATUS_ASSOCIATED : WIFI_STA_STATUS_REASSOCIATED));
#else
		/*msg too much will cause veriwave 40 STA hard to test*/
		LOG_MSG("STA[%pm] has associated\n",pfrinfo->sa);
#endif
//#endif
#ifdef RTK_MULTI_AP
	if (pstat && pstat->IOTPeer == HT_IOT_PEER_RTK_APCLIENT) {
		panic_printk("repeater sta connect\n");
	}
	else {
		if (priv->pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm == _NO_PRIVACY_ ||
			priv->pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm == _WEP_40_PRIVACY_ ||
			priv->pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm == _WEP_104_PRIVACY_)
			client_join_notify(BSSID, pstat->cmn_info.mac_addr);
#if (EASYMESH_VERSION >= MULTI_AP_VERSION(2,0,0))
		if (GET_MAP_PROFILE(priv) >= MAP_PROFILE_TWO) {
			rtk_multi_ap_trigger_tunneled_message(pstat->cmn_info.mac_addr, 0x00, pstat->assoc_req_length, pstat->assoc_req_body);
		}
#endif
	}
#endif
#ifndef RTK_NL80211 //OPENWRT_RADIUS
	if (IEEE8021X_FUN || IAPP_ENABLE || priv->pmib->wscEntry.wsc_enable) {
#ifndef __DRAYTEK_OS__
		if (IEEE8021X_FUN &&	// in WPA, let user daemon check RSNIE and decide to accept or not
			(priv->pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm == _TKIP_PRIVACY_ ||
			 priv->pmib->dot1180211AuthEntry.dot11PrivacyAlgrthm == _CCMP_PRIVACY_)) {
			 
#if (BEAMFORMING_SUPPORT == 1)
			//panic_printk("%s, %x\n", __FUNCTION__, cpu_to_le32(pstat->vht_cap_buf.vht_cap_info));
				if (priv->pshare->WlanSupportAbility & WLAN_BEAMFORMING_SUPPORT)
				if((priv->pmib->dot11RFEntry.txbf == 1)  && ((pstat->ht_cap_len && (pstat->ht_cap_buf.txbf_cap)) 
#ifdef RTK_AC_SUPPORT	
					|| (pstat->vht_cap_len && (cpu_to_le32(pstat->vht_cap_buf.vht_cap_info) & (BIT(SU_BFEE_S)|BIT(SU_BFER_S))))
#endif	
				)){
					Beamforming_Enter(priv, pstat);
				}
#endif	

			return SUCCESS;
		}
#endif
	}
#endif

#ifdef WIFI_SIMPLE_CONFIG
OnAssocReqSuccess:
#endif

#ifdef RTK_WLAN_EVENT_INDICATE
	rtk_wlan_event_indicate(priv->dev->name, WIFI_PEER_CONNECT_SUCCESS,  pstat->cmn_info.mac_addr, 0);
#ifdef ROAMING_SUPPORT
	if(pstat)
		general_wlan_IndicateEvent(priv,DOT11_EVENT_ROAMING_STA_INFO_REPORT,pstat);
#endif
#endif
#ifdef STA_ASSOC_STATISTIC
//	add_sta_assoc_status(priv, pstat->cmn_info.mac_addr, pfrinfo->rf_info.rssi, status | ((frame_type == WIFI_REASSOCREQ)? 0x500 : 0x200));
	if(frame_type == WIFI_REASSOCREQ) {
		add_sta_assoc_status(priv, pstat->cmn_info.mac_addr, pfrinfo->rf_info.rssi,  0x505);
		add_sta_assoc_status(priv, pstat->cmn_info.mac_addr, pfrinfo->rf_info.rssi,  0x500 | status);
	} else {
		add_sta_assoc_status(priv, pstat->cmn_info.mac_addr, pfrinfo->rf_info.rssi,  0x200 | status);
	}
#endif

#if defined(RTK_NL80211) && defined(CONFIG_IEEE80211R)
	if (FT_ENABLE &&
		(pstat->ft_state == state_ft_assoc || pstat->ft_state == state_imd_assoc)) {
		FTDEBUG("offload ft-assoc-req to hostapd\n");
	} else
#endif
#ifdef RTK_NL80211
	if (!pstat->has_pmkid)
#endif
	{
		if (frame_type == WIFI_ASSOCREQ)
			issue_asocrsp(priv, status, pstat, WIFI_ASSOCRSP, assoc_disallowed_status);
		else
			issue_asocrsp(priv, status, pstat, WIFI_REASSOCRSP, assoc_disallowed_status);
	}

#if (BEAMFORMING_SUPPORT == 1)
	if (priv->pshare->WlanSupportAbility & WLAN_BEAMFORMING_SUPPORT)
	if((priv->pmib->dot11RFEntry.txbf == 1) &&
		((pstat->ht_cap_len && (pstat->ht_cap_buf.txbf_cap)) 
#ifdef RTK_AC_SUPPORT	
		||(pstat->vht_cap_len && (cpu_to_le32(pstat->vht_cap_buf.vht_cap_info) & (BIT(SU_BFEE_S)|BIT(SU_BFER_S))))
#endif
		)) {
			Beamforming_Enter(priv, pstat);
	}
#endif

//#ifdef BR_SHORTCUT
#if 0
	clear_shortcut_cache();
#endif

	update_fwtbl_asoclst(priv, pstat);

/*update mesh proxy table*/
#if defined(CONFIG_RTK_MESH)
    mesh_proxy_insert(GET_ROOT(priv), GetAddr2Ptr(pframe));

    #ifdef BR_SHORTCUT
    clear_shortcut_cache();
    #endif // BR_SHORTCUT
#endif
#ifdef RTK_NL80211
	/*cfg p2p cfg p2p*/
	//NDEBUG("pstat=0x%x: %02x %02x %02x\n", pstat, pstat->wpa_ie[0], pstat->wpa_ie[1], pstat->wpa_ie[2]);
	cfg80211_new_sta(priv->dev, GetAddr2Ptr(pframe), &sinfo, GFP_ATOMIC);
	 netif_wake_queue(priv->dev); //wrt-vap 
	//event_indicate_cfg80211(priv, GetAddr2Ptr(pframe), CFG80211_NEW_STA, pstat);
#else //RTK_NL80211

#ifdef WIFI_HAPD
	event_indicate_hapd(priv, GetAddr2Ptr(pframe), HAPD_REGISTERED, NULL);
#ifdef HAPD_DRV_PSK_WPS
	event_indicate(priv, GetAddr2Ptr(pframe), 1);
#endif
#else
	event_indicate(priv, GetAddr2Ptr(pframe), 1);
#endif
#ifdef WIFI_WPAS
	//printk("_Eric WPAS_REGISTERED at %s %d\n", __FUNCTION__, __LINE__);
	event_indicate_wpas(priv, GetAddr2Ptr(pframe), WPAS_REGISTERED, NULL);
#endif
#endif //RTK_NL80211

#ifndef USE_WEP_DEFAULT_KEY
	set_keymapping_wep(priv, pstat);
#endif

#ifdef CONFIG_RTL_WAPI_SUPPORT
	if (priv->pmib->wapiInfo.wapiType==wapiTypeCert)
	{
		wapiAssert(pstat->wapiInfo->wapiState==ST_WAPI_AE_IDLE);
		
		WAPI_LOCK(&pstat->wapiInfo->lock);
		pstat->wapiInfo->wapiRetry = 0;
		WAPI_UNLOCK(&pstat->wapiInfo->lock);
		
		wapiReqActiveCA(pstat);
		return SUCCESS;
	}
	else if (priv->pmib->wapiInfo.wapiType==wapiTypePSK)
	{
		wapiAssert(pstat->wapiInfo->wapiState==ST_WAPI_AE_IDLE);
		
		WAPI_LOCK(&pstat->wapiInfo->lock);
		pstat->wapiInfo->wapiRetry = 0;
		WAPI_UNLOCK(&pstat->wapiInfo->lock);
		
		wapiSetBK(pstat);
		if (wapiSendUnicastKeyAgrementRequeset(priv, pstat)==WAPI_RETURN_SUCCESS)
			return SUCCESS;
		else
			return FAIL;
	}
#endif

#if defined(AP_SWPS_OFFLOAD)
    if (IS_SUPPORT_AP_SWPS_OFFLOAD(priv)) {
        //polling a SWPS RPT, to update TXdone todate
        GET_HAL_INTERFACE(priv)->SetHwRegHandler(priv,HW_VAR_SWPS_RPT_POLLING,NULL);
        HAL_delay_ms(5); //wait for report update, not sure if its ok, 
    }
#endif

#ifdef RTK_SMART_ROAMING
	if(SMART_ROAMING_ENABLE 
#ifdef STA_ROAMING_CHECK
		|| RTL_LINK_ROAMING_ENABLE
#endif
		){
	if(pstat && pstat->is_realtek_sta) //pstat->IOTPeer == HT_IOT_PEER_RTK_APCLIENT) 		
		panic_printk("rtk board connect\n");			
		else
		{
			notify_new_sta(priv, pstat->cmn_info.mac_addr, ASSOC_NEW_STA, pfrinfo->rf_info.rssi);
		}
	}
#endif
	#ifdef RTK_MULTI_AP
	if(pstat && pstat->IOTPeer == HT_IOT_PEER_RTK_APCLIENT)
			panic_printk("repeater sta connect\n");
		else
			client_join_notify(BSSID, pstat->cmn_info.mac_addr);
	#endif

#ifdef CONFIG_RTK_WLAN_MANAGER
	rtk_wlan_manager_nl_send_new_sta_msg(priv, pstat->cmn_info.mac_addr);
#endif

	return SUCCESS;

asoc_class2_error:
#ifdef STA_ASSOC_STATISTIC
	add_sta_assoc_status(priv, GetAddr2Ptr(pframe), pfrinfo->rf_info.rssi, _RSON_CLS2_ | 0x200);
#endif	
	if (pstat) {
		DRV_RT_TRACE(priv, DRV_DBG_CONN_INFO, DRV_DBG_SERIOUS, "issue_deauth - %pm, asoc_class2_error\n",pstat->cmn_info.mac_addr);
	}
	issue_deauth(priv,	(void *)GetAddr2Ptr(pframe), status);
	if (pstat){
		free_stainfo(priv, pstat);
	}
	return FAIL;

OnAssocReqFail:
#ifdef STA_ASSOC_STATISTIC
	add_sta_assoc_status(priv, GetAddr2Ptr(pframe), pfrinfo->rf_info.rssi, status | 0x200);
#endif	

	if (frame_type == WIFI_ASSOCREQ)
		issue_asocrsp(priv, status, pstat, WIFI_ASSOCRSP, assoc_disallowed_status);
	else
		issue_asocrsp(priv, status, pstat, WIFI_REASSOCRSP, assoc_disallowed_status);

	return FAIL;
}

#ifdef P2P_SUPPORT
int is_brate(unsigned char rrate)
{
	if(rrate==0x82 || rrate==0x84 ||  rrate==0x8b || rrate==0x96 )
		return 1;
	else
		return 0;
}
#endif

unsigned int OnProbeReq(struct rtl8192cd_priv *priv, struct rx_frinfo *pfrinfo)
{
	struct wifi_mib	*pmib;
	unsigned char	*pframe, *p;
	unsigned char 	*sa;
	unsigned char	*ssidptrx=NULL;
	unsigned int	len;
	unsigned char	*bssid, is_11b_only=0;    
    #ifdef WDS
	unsigned int i;
    #endif
    #ifdef P2P_SUPPORT
	int idx=0;
	int brateonly = 1;
	static unsigned char ReAssem_p2pie[MAX_REASSEM_P2P_IE];
	unsigned char *p2pIEPtr = ReAssem_p2pie ;	
	int IEfoundtimes=0;
	int p2pIElen=0;
    #endif
    #if	defined(WIFI_SIMPLE_CONFIG) || defined(P2P_SUPPORT)
	static	unsigned char tmp_assem_wscie[512];
	unsigned char *awPtr = tmp_assem_wscie ;	
	unsigned int foundtimes=0;		
	int lenx =	0;    
	unsigned char *ptmp;
	unsigned int lentmp;
    #endif

#ifdef HAPD_11K
	unsigned char found_11k_oui=0;
#endif

	unsigned int assoc_disallowed_status = 0;

#ifdef BEACON_VS_IE
	unsigned char	*pvsie=NULL;
	unsigned char tmpbuf[256+MACADDRLEN];
	unsigned int j;
#endif
#ifdef RTK_MULTI_AP
	struct stat_info *pstat;
#endif
#ifdef STA_CONTROL
	unsigned char req_status;
	unsigned long flags;
#endif
	bssid  = BSSID;
	pmib   = GET_MIB(priv);
	pframe = get_pframe(pfrinfo);
	sa = GetAddr2Ptr(pframe);

	if (!IS_DRV_OPEN(priv))
		return FAIL;

#ifdef CONFIG_MBO
	assoc_disallowed_status = check_association_disallowed(priv, WIFI_PROBEREQ, pfrinfo->rf_info.rssi);
#endif
    
#ifdef CTC_WIFI_DIAG
	ctcwifi_diag_log(priv, sa, 0, "Probe Request", (pframe+WLAN_HDR_A3_LEN), (pfrinfo->pktlen-WLAN_HDR_A3_LEN));
#endif
    
#ifdef SIMPLE_CH_UNI_PROTOCOL
    if(!pfrinfo->is_11s) /*do not drop Progreq from other mesh node*/
#endif
    {
        if (priv->auto_channel == 1)
            return FAIL;
    }


#ifdef P2P_SUPPORT
        /*allow (p2p device mode && under listen state) can process probe_req frame*/			/*cfg p2p cfg p2p*/
		if(  rtk_p2p_is_enabled(priv) && 
			((rtk_p2p_chk_role(priv,P2P_DEVICE)) && (rtk_p2p_chk_state(priv,P2P_S_LISTEN)))){
				
            /*do no thing just allow go on*/ 
		}
		else
#endif
		{	
			if (!((OPMODE & WIFI_AP_STATE) || (OPMODE & WIFI_ADHOC_STATE))
#ifdef MP_TEST
			|| priv->pshare->rf_ft_var.mp_specific
#endif
			)
				return FAIL;

		}

		if (pfrinfo->rf_info.rssi < priv->pmib->dot11StationConfigEntry.staAssociateRSSIThreshold){	
			return FAIL;
		}
#ifdef WDS
	if (pmib->dot11WdsInfo.wdsEnabled && pmib->dot11WdsInfo.wdsPure) {
		if (pmib->dot11WdsInfo.wdsNum) {
			for (i = 0; i < pmib->dot11WdsInfo.wdsNum; i++) {
				if (!memcmp(pmib->dot11WdsInfo.entry[i].macAddr, (char *)GetAddr2Ptr(pframe), MACADDRLEN)) {
					break;
				}
			}
			if (i == pmib->dot11WdsInfo.wdsNum) {
				return FAIL;
			}
		}
		else{
			return FAIL;
		}
	}
#endif

	if (pmib->miscEntry.func_off || pmib->miscEntry.raku_only)
		return FAIL;
#ifdef CLIENT_MODE
	if ((OPMODE & WIFI_ADHOC_STATE) &&
			(!priv->ibss_tx_beacon || (OPMODE & WIFI_SITE_MONITOR)))
		return FAIL;
#endif
#ifdef WLAN_DIAGNOSTIC
	if(priv->pmib->dot11StationConfigEntry.probe_info_enable == 1){
		//if (check_probe_sta_rssi_valid(priv,GetAddr2Ptr(pframe),pfrinfo->rf_info.rssi))
			add_probe_req_sta(priv,GetAddr2Ptr(pframe),pfrinfo->rf_info.rssi);	
	}else if(priv->pmib->dot11StationConfigEntry.probe_info_enable == 2 && priv->pmib->dot11StationConfigEntry.probe_info_collecting){
			add_probe_req_sta(priv,GetAddr2Ptr(pframe),pfrinfo->rf_info.rssi);
	}
#endif
#ifdef RTK_MULTI_AP
	pstat = get_stainfo(priv, GetAddr2Ptr(pframe));
	if(pstat == NULL)
		if(priv->multiap_unassocStaEntryOccupied)
			update_unassoc_MAC_RSSI_Entry(priv,GetAddr2Ptr(pframe),pfrinfo->rf_info.rssi, 0, priv->multiap_unassoc_sta);
#endif
#ifdef CONFIG_RTK_WLAN_MANAGER
		rtk_wlan_manager_nl_send_frame_rpt_msg(priv, WIFI_PROBEREQ, GetAddr2Ptr(pframe), pfrinfo->rf_info.rssi);
#endif
	if ( (priv->pmib->dot11StationConfigEntry.disable_prsp)
		|| (pfrinfo->rf_info.rssi < priv->pmib->dot11StationConfigEntry.staAssociateRSSIThreshold)	)
		return FAIL;
#ifdef CONFIG_RTK_MESH
	if(pfrinfo->is_11s)
		return OnProbeReq_MP(priv, pfrinfo);
#endif

    /*PSP IOT*/ 
#if 0
	p = get_ie(pframe + WLAN_HDR_A3_LEN + _PROBEREQ_IE_OFFSET_, _EXT_SUPPORTEDRATES_IE_, (int *)&len,
			pfrinfo->pktlen - WLAN_HDR_A3_LEN - _PROBEREQ_IE_OFFSET_);
	if (p == NULL) {
		p = get_ie(pframe + WLAN_HDR_A3_LEN + _PROBEREQ_IE_OFFSET_, _SUPPORTEDRATES_IE_,  (int *)&len,
				pfrinfo->pktlen - WLAN_HDR_A3_LEN - _PROBEREQ_IE_OFFSET_);
		if( (p == NULL) || ( len<=4))
			is_11b_only = 1;
	}
#else
	{
	unsigned char * p2 = pframe + WLAN_HDR_A3_LEN + _PROBEREQ_IE_OFFSET_;
	unsigned rate_num =0;
	for (;;) {
		p2 = get_ie(p2, _EXT_SUPPORTEDRATES_IE_, &len, pfrinfo->pktlen - (p2 - pframe));
		if (!p2)
			break;
		rate_num += *(p2+1);
		p2 = p2 + len + 2;
	}
	p2 = pframe + WLAN_HDR_A3_LEN + _PROBEREQ_IE_OFFSET_;
	for (;;) {
		p2 = get_ie(p2, _SUPPORTEDRATES_IE_, &len, pfrinfo->pktlen - (p2 - pframe));
		if (!p2)
			break;
		rate_num += *(p2+1);
		p2 = p2 + len + 2;
	}
	if (rate_num<=4)
		is_11b_only = 1;
	}
#endif
    /*PSP IOT*/ 

#ifdef HAPD_11K
	/*parse 11K oui for rm_ap_channel_report, if found 
		#1 report to hapd, 
		#2 don't reply probe_resp myself 
		#3 	wait hapd send probe_resp from realtek_mgmt_tx
		#4 do not need record rm_ap_channel_report in wlan drv
		maybe here is no needed , hapd seem hasn't no handle WLAN_EID_AP_CHANNEL_REPORT*/
	if (priv->hapd_11k_ie_len) { /*hapd_11K has enabled*/
		ptmp = pframe + WLAN_HDR_A3_LEN + _PROBEREQ_IE_OFFSET_; lentmp = 0;
		for (;;){
			ptmp = get_ie(ptmp, _VENDOR_SPEC_IE_, (int *)&lentmp,pfrinfo->pktlen - (ptmp - pframe));
			if (ptmp) {
				if(lentmp>=4 && !memcmp(wfa_oui_11k_ap_report,ptmp+2,4))
					found_11k_oui=1;
			}
			else{
				break;
			}
			ptmp = ptmp + lentmp + 2;
		}
		if(found_11k_oui){
			/*report this probe_req to hapd*/
			//hapd11klog("has rm oui => realtek_process_cfg80211_event");
			//realtek_enqueue_cfg80211_event(priv, pfrinfo, 0);
			//return;
		}
	}
#endif

    #ifdef WIFI_SIMPLE_CONFIG
	if (priv->pmib->wscEntry.wsc_enable & 2) { // work as AP (not registrar)
		ptmp = pframe + WLAN_HDR_A3_LEN + _PROBEREQ_IE_OFFSET_; lentmp = 0;
		for (;;)
		{
			ptmp = get_ie(ptmp, _WPS_IE_, (int *)&lentmp,
			pfrinfo->pktlen - (ptmp - pframe));
			if (ptmp != NULL) {
				if ((lentmp >= 4) && !memcmp(ptmp+2, WSC_IE_OUI, 4)) {
					foundtimes ++;
					if(foundtimes ==1){
						if ( (lentmp + 2 ) > PROBEIELEN)
						{
							DEBUG_WARN("[%s] WPS_IE length is too big =%d\n", __FUNCTION__, (lentmp+2));
							foundtimes--;
							break;
						} else {
							memcpy(awPtr , ptmp ,lentmp + 2);
							awPtr+= (lentmp + 2);
							lenx += (lentmp + 2);
						}
					}else{
					    if ( (lenx + lentmp-4 ) > PROBEIELEN)
						{
							DEBUG_WARN("[%s] Total length of several WPS_IE is too big =%d, do not include the last WSC IEs\n", __FUNCTION__, (lenx+lentmp-4));
							foundtimes--;
							break;
						} else {
							memcpy(awPtr , ptmp+2+4 ,lentmp-4);
							awPtr+= (lentmp-4);
							lenx += (lentmp-4);
						}
					}					
				}
			}
			else{
				break;
			}

			ptmp = ptmp + lentmp + 2;
		}
		if(foundtimes){
			lenx = (int)(((unsigned long)awPtr)-((unsigned long)tmp_assem_wscie));	
			if(foundtimes>1){
				tmp_assem_wscie[1] = lenx-2;
				//debug_out("ReAss probe_Req wsc_ie ",tmp_assem_wscie,lenx);					
			}

#ifdef RTK_NL80211
			realtek_enqueue_cfg80211_event(priv, pfrinfo, NL80211_RXMGMT_FLAG_ANSWERED);
#else
			wsc_forward_probe_request(priv, pframe, tmp_assem_wscie, lenx);
#endif
		} else {	// 
			if( search_wsc_pbc_probe_sta(priv, (unsigned char *)GetAddr2Ptr(pframe))==1){
                DOT11_WSC_PIN_IND wsc_ind;
                wsc_ind.EventId = DOT11_EVENT_WSC_RM_PBC_STA ;
                wsc_ind.IsMoreEvent = 0;
				memcpy(wsc_ind.code,(unsigned char *)GetAddr2Ptr(pframe),6);
                DOT11_EnQueue((unsigned long)priv, priv->pevent_queue, (unsigned char*)&wsc_ind, sizeof(DOT11_WSC_PIN_IND));
                event_indicate(priv, NULL, -1);  
			}
		}		
	}
    /* WPS2DOTX   */

    #ifdef HS2_SUPPORT
	if (priv->pmib->hs2Entry.interworking_ielen)
	{
		unsigned char *ptmp;
		unsigned int  hs_len=0;
		ptmp = get_ie(pframe + WLAN_HDR_A3_LEN + _PROBEREQ_IE_OFFSET_, _EXTENDED_CAP_IE_, (int *)&hs_len,
				pfrinfo->pktlen - WLAN_HDR_A3_LEN - _PROBEREQ_IE_OFFSET_);

		if (ptmp)
		{
			unsigned char tmp[12];
	
			if (hs_len >= 4)
			{	
				memcpy(tmp, ptmp+2, hs_len);
		
				if (tmp[3] & _INTERWORKING_SUPPORT_)	/*interworking capability bit ; check bit 31(byte3 bit(7));*/
				{
				    hs_len=0;
					ptmp = get_ie(pframe + WLAN_HDR_A3_LEN + _PROBEREQ_IE_OFFSET_, _INTERWORKING_IE_, (int *)&hs_len,
							pfrinfo->pktlen - WLAN_HDR_A3_LEN - _PROBEREQ_IE_OFFSET_);
					
					if (ptmp && hs_len)
					{
						memcpy(tmp, ptmp+2, hs_len);
						//printk("Check Interworking element, hs_len=%d\n",hs_len);
						//check ant match or not
						if ((tmp[0] & 0x0f) != (priv->pmib->hs2Entry.interworking_ie[0] & 0x0f) && ((tmp[0] & 0x0f) != 15)) //access network type not match
						{
							//printk("ant (access network type) not match\n");	
							goto OnProbeReqFail;	
						}
					
						hs_len -= 1;
						if (hs_len > 1)
						{
							//printk("Case hs_len = %d\n",hs_len);
							if (hs_len == 8)
							{
								if (memcmp(tmp+3, priv->pmib->hs2Entry.interworking_ie+3, 6) && memcmp(tmp+3, "\xff\xff\xff\xff\xff\xff", 6)) //hessid not match
								{
									//printk("no match hessid1, %02x%02x%02x%02x%02x%02x\n",tmp[3],tmp[4],tmp[5],tmp[6],tmp[7],tmp[8]);
									goto OnProbeReqFail;
								}
							}
							else if (hs_len == 6)
							{
								if (memcmp(tmp+1, priv->pmib->hs2Entry.interworking_ie+3, 6) && memcmp(tmp+1, "\xff\xff\xff\xff\xff\xff", 6)) //hessid not match
								{
									//printk("no match hessid2, %02x%02x%02x%02x%02x%02x\n",tmp[1],tmp[2],tmp[3],tmp[4],tmp[5],tmp[6]);
									goto OnProbeReqFail;
								}
							}
							else {
								goto OnProbeReqFail;
							}
						}
					}
					else{
						HS2DEBUG("enable interworking bit, but no interworking ie!!\n");
                    }
				}
			}
		}
	}
    #endif
    #endif

#ifdef BEACON_VS_IE

	pvsie = pframe + WLAN_HDR_A3_LEN + _PROBEREQ_IE_OFFSET_;
	for(;;)
	{
		pvsie = get_ie(pvsie, _VENDOR_SPECIFIC_IE_, (int *)&len,
			pfrinfo->pktlen - (pvsie - pframe));
		//printk("%d\n", pfrinfo->pktlen - (pvsie - pframe));
		if(pvsie != NULL)
		{
			for(j = 0; j < NUM_PRBVSIE_SERVICE;j++)
			{
				if(priv->prb_vsie[j].service_name_len != 0)
				{
					if(memcmp(pvsie+2,priv->prb_vsie[j].oui,3) == 0)
					{
						memcpy(tmpbuf, GetAddr2Ptr(pframe), MACADDRLEN);
						memcpy(tmpbuf + MACADDRLEN, pvsie, pvsie[1]+2);
						general_IndicateEvent(priv, EVENT_PROBE_RX_VSIE, tmpbuf);
#ifdef RTK_WLAN_EVENT_INDICATE
						general_wlan_IndicateEvent(priv, EVENT_PROBE_RX_VSIE, tmpbuf);
#endif
						break;
					}
				}
			}
			pvsie += len+2;
		}
		else
			break;
		if(pfrinfo->pktlen - (pvsie - pframe) <= 0)
			break;
	}
#endif


#ifdef P2P_SUPPORT			/*cfg p2p cfg p2p*/
	if(rtk_p2p_is_enabled(priv))
	{
							
		
		/*check P2P Wildcard SSID: The SSID field ��DIRECT-��.*/
		ssidptrx = get_ie(pframe + WLAN_HDR_A3_LEN + _PROBEREQ_IE_OFFSET_, _SSID_IE_, (int *)&len,
				pfrinfo->pktlen - WLAN_HDR_A3_LEN - _PROBEREQ_IE_OFFSET_);

		if (ssidptrx == NULL){
			goto OnProbeReqFail;	
		}

		if(  len>=7 && !memcmp(ssidptrx+2,"DIRECT-",7))
		{
			//P2P_SME_P("chk (DIRECT-) ssid\n");
		}else{
			/*no included "DIRECT-" , rsp as normal dev*/ 
			if((rtk_p2p_chk_role(priv,P2P_DEVICE)) && (rtk_p2p_chk_state(priv,P2P_S_LISTEN))){
				goto OnProbeReqFail;		
			}else if(rtk_p2p_chk_role(priv,P2P_TMP_GO) || rtk_p2p_chk_role(priv,P2P_PRE_GO) ){
				goto normal_probe_req;
			}
		}
            
		if(is_11b_only){
            /* 1)P2P Devices shall not respond to Probe Request frames that indicate support for 11b rates only ;test plan 1.07,p25*/
            P2P_DEBUG("	all p2p devices don't care b rate only device\n");            
			goto OnProbeReqFail; // don't care b rate only device
		}


		/*------check include P2P IE ------*/
		ptmp = pframe + WLAN_HDR_A3_LEN + _PROBEREQ_IE_OFFSET_;	
		/*support ReAssemble*/
		for (;;)
		{
			ptmp = get_ie(ptmp, _P2P_IE_, (int *)&len,
				pfrinfo->pktlen - WLAN_HDR_A3_LEN - _PROBEREQ_IE_OFFSET_ - len);
			if (ptmp != NULL) {
				if ((len >= 4) && !memcmp(ptmp+2, WFA_OUI_PLUS_TYPE, 4)) {
					if (p2pIElen+len-4 > MAX_REASSEM_P2P_IE) {
						P2P_DEBUG("\n\n	reassemble P2P IE exceed MAX_REASSEM_P2P_IE , chk!!!\n\n");
						IEfoundtimes = 0;
						break;
					}
					IEfoundtimes ++;
					memcpy(p2pIEPtr , ptmp+6 ,len-4);
					p2pIEPtr+= (len-4);
					p2pIElen += (len-4);
				}
			}
			else{
				break;
			}
			ptmp = ptmp + len + 2;
			
		}
				
		if(IEfoundtimes){
			if(IEfoundtimes>1){
				P2P_DEBUG("ReAssembly p2p IE\n");
			}
			P2P_on_probe_req(priv, pfrinfo, ReAssem_p2pie, p2pIElen);
			return SUCCESS;
		}
		else{

			if((rtk_p2p_chk_role(priv,P2P_DEVICE)) && (rtk_p2p_chk_state(priv,P2P_S_LISTEN)))
				goto OnProbeReqFail;

		}	
		/*------chk include P2P IE ------*/

	}


normal_probe_req:
#endif
	ssidptrx = get_ie(pframe + WLAN_HDR_A3_LEN + _PROBEREQ_IE_OFFSET_, _SSID_IE_, (int *)&len,
			pfrinfo->pktlen - WLAN_HDR_A3_LEN - _PROBEREQ_IE_OFFSET_);

	if (ssidptrx == NULL)
		goto OnProbeReqFail;

	if (len == 0) {
		if (HIDDEN_AP || TAKEOVER_HIDDEN_AP)
			goto OnProbeReqFail;
		else
			goto send_rsp;
	}

	if ((len != SSID_LEN) ||
			memcmp((void *)(ssidptrx+2), (void *)SSID, SSID_LEN)) {
		if ((len == 3) &&
				((*(ssidptrx+2) == 'A') || (*(ssidptrx+2) == 'a')) &&
				((*(ssidptrx+3) == 'N') || (*(ssidptrx+3) == 'n')) &&
				((*(ssidptrx+4) == 'Y') || (*(ssidptrx+4) == 'y'))) {
			if (pmib->dot11OperationEntry.deny_any)
				goto OnProbeReqFail;
			else
				if (HIDDEN_AP || TAKEOVER_HIDDEN_AP)
					goto OnProbeReqFail;
				else
					goto send_rsp;
		}
		else
			goto OnProbeReqFail;
	}
	
send_rsp:

#if 0//def STA_CONTROL_BAND_TRANSITION
	// If the STA is in BandTransBlockList, ignore the probe request.
	if (priv->stactrl.stactrl_status && priv->pmib->staControl.stactrl_band_transit) {
		if (checkBandTransBlockList(priv, GetAddr2Ptr(pframe), WIFI_PROBEREQ)) {
			DEBUG_INFO("[%s, %d]: ignore WIFI_PROBEREQ because of band steering\n", __FUNCTION__, __LINE__);
			goto OnProbeReqFail;
		}
	}
#endif

#if defined(RTK_MULTI_AP) && defined(CONFIG_IEEE80211V)
	// If the STA is in assoc control block_list, ignore the probe request.
	if (getEntryBlockList(priv, GetAddr2Ptr(pframe)) != NULL) {
		//Do not send probe response since STA is blocked
		DEBUG_INFO("[%s, %d]: ignore WIFI_PROBEREQ because of assoc control\n", __FUNCTION__, __LINE__);
		goto OnProbeReqFail;
	}
#endif

#ifdef STA_CONTROL
    if(priv->stactrl.stactrl_status
#ifdef RTK_MULTI_AP
		&& priv->pmib->multi_ap.multiap_steering_policy
#endif
	) {        
#if STA_CONTROL_ALGO == STA_CONTROL_ALGO3
		if(priv->stactrl.stactrl_prefer) {
	        stactrl_preferband_sta_add(priv, GetAddr2Ptr(pframe), pfrinfo->rf_info.rssi, 0);//20170105
			if(STACTRL_BLOCK_5G) {
				SAVE_INT_AND_CLI(flags);
				SMP_LOCK_STACONTROL_LIST(flags);
	        	unsigned char req_status1 = stactrl_check_request_on_preferband(priv, GetAddr2Ptr(pframe), WIFI_PROBEREQ, pfrinfo->rf_info.rssi);
				SMP_UNLOCK_STACONTROL_LIST(flags);
				RESTORE_INT(flags);
	        	if(req_status1 && req_status1!=3)
	            	goto OnProbeReqFail;
			}
        }
		else {
			if(STACTRL_BLOCK_5G) {
				stactrl_preferband_sta_add(priv, GetAddr2Ptr(pframe), pfrinfo->rf_info.rssi, 0);
				SAVE_INT_AND_CLI(flags);
				SMP_LOCK_STACONTROL_LIST(flags);
				req_status = stactrl_check_request_on_nonpreferband(priv, GetAddr2Ptr(pframe), WIFI_PROBEREQ, pfrinfo->rf_info.rssi);
				SMP_UNLOCK_STACONTROL_LIST(flags);
				RESTORE_INT(flags);
				if(req_status)
					goto OnProbeReqFail;
			}
			else {
				SAVE_INT_AND_CLI(flags);
				SMP_LOCK_STACONTROL_LIST(flags);
				req_status = stactrl_check_request(priv, GetAddr2Ptr(pframe), WIFI_PROBEREQ, pfrinfo->rf_info.rssi);
				SMP_UNLOCK_STACONTROL_LIST(flags);
				RESTORE_INT(flags);
				if(req_status)
					goto OnProbeReqFail;
			}
		}
#else
		if(priv->stactrl.stactrl_prefer) {
            stactrl_preferband_sta_add(priv, GetAddr2Ptr(pframe), pfrinfo->rf_info.rssi);
			if(stactrl_check_request_on_preferband(priv, GetAddr2Ptr(pframe), WIFI_PROBEREQ, pfrinfo->rf_info.rssi)) {
					goto OnProbeReqFail;
			}
        }
        else {                       
			if(!stactrl_pass_request(priv->stactrl.stactrl_priv_sc, GetAddr2Ptr(pframe), WIFI_PROBEREQ)) {
                req_status = stactrl_check_request(priv, GetAddr2Ptr(pframe), WIFI_PROBEREQ, pfrinfo->rf_info.rssi);
                if(req_status == 1 || req_status == 2)
                    goto OnProbeReqFail;
            }
    	}
#endif
    }
#endif

#ifdef RTK_SMART_ROAMING
	if(priv->sr_block.sr_block_status && smart_roaming_block_check_request(priv, GetAddr2Ptr(pframe)))
		goto OnProbeReqFail;
#endif

    #ifdef CONFIG_RTK_MESH
    if(pmib->dot1180211sInfo.meshSilence) {
        return FAIL;
    }    
    else if( pmib->dot1180211sInfo.mesh_enable && !pmib->dot1180211sInfo.mesh_ap_enable) {
        issue_probersp(priv, GetAddr2Ptr(pframe), NULL, 0, 1, is_11b_only, assoc_disallowed_status);
    }
    else
    #endif      
    {
#if 0    
#ifdef WLAN_DIAGNOSTIC
		if(priv->pmib->dot11StationConfigEntry.probe_info_enable == 1){
			if (check_probe_sta_rssi_valid(priv,GetAddr2Ptr(pframe),pfrinfo->rf_info.rssi))
				add_probe_req_sta(priv,GetAddr2Ptr(pframe),pfrinfo->rf_info.rssi);	
		}else if(priv->pmib->dot11StationConfigEntry.probe_info_enable == 2){
			add_probe_req_sta(priv,GetAddr2Ptr(pframe),pfrinfo->rf_info.rssi);
		}
#endif		
#endif
#ifdef CONFIG_RTK_WPS_MESH
		if(3 == pmib->wscEntry.wsc_meshmode)					
			issue_probersp(priv, GetAddr2Ptr(pframe), pmib->wscEntry.dot11DesiredSSIDbak, pmib->wscEntry.dot11DesiredSSIDLenBak, 1, is_11b_only);
		else
#endif
        issue_probersp(priv, GetAddr2Ptr(pframe), SSID, SSID_LEN, 1, is_11b_only, assoc_disallowed_status);
    }
	return SUCCESS;

OnProbeReqFail:

	return FAIL;
}


unsigned int OnProbeRsp(struct rtl8192cd_priv *priv, struct rx_frinfo *pfrinfo)
{
#ifdef WDS
    struct stat_info *pstat = NULL;
#endif

#if defined(CONFIG_RTL_WAPI_SUPPORT)
    uint8		*p;
    int			len;
#endif

#if defined(WDS) || defined(CONFIG_RTL_WAPI_SUPPORT) || defined(DOT11K) || defined(CTC_WIFI_DIAG)
    unsigned char *pframe = get_pframe(pfrinfo);
    unsigned char *sa = GetAddr2Ptr(pframe);
#endif

#ifdef CTC_WIFI_DIAG
    ctcwifi_diag_log(priv, sa, 0, "Probe Response", (pframe+WLAN_HDR_A3_LEN), (pfrinfo->pktlen-WLAN_HDR_A3_LEN));
#endif

#ifdef BSS_MONITOR_SUPPORT
//	collect_monitor_info(priv, pfrinfo);
#endif
// ==== modified by GANTOE for site survey 2008/12/25 ====
    if (OPMODE & WIFI_SITE_MONITOR)
    {

#ifdef P2P_SUPPORT
        /*cfg p2p cfg p2p*/
        if( (rtk_p2p_is_enabled(priv)==PROPERTY_P2P) && P2P_DISCOVERY)
        {
            p2p_collect_bss_info(priv, pfrinfo, WIFI_PROBERSP);
        }
        else
#endif
#ifdef DOT11K
        if(priv->ss_req_ongoing == SSFROM_11K_BEACONREQ)
        {
            rm_collect_bss_info(priv, pfrinfo);
        }
        else
#endif
        {
#ifdef CONFIG_RTK_WPS_MESH
			unsigned char *addr;
			unsigned char null_mac[]={0,0,0,0,0,0};
			#ifdef CONFIG_RTK_MESH
			if(pfrinfo->is_11s)
				addr = GetAddr2Ptr(pframe);
			else
			#endif
				addr = GetAddr3Ptr(pframe);
			if(!((3 == priv->pmib->wscEntry.wsc_meshmode) && (isEqualMACAddr(addr, null_mac) || isEqualMACAddr(addr, priv->pmib->dot11OperationEntry.hwaddr))))							
#endif		
		collect_bss_info(priv, pfrinfo);
		
#if defined(CONFIG_RTL_WAPI_SUPPORT)
		p = get_ie(pframe + WLAN_HDR_A3_LEN, _EID_WAPI_, 
			&len, pfrinfo->pktlen);
		if (p)
		{
			if (len+2 > sizeof(priv->aeWapiIE)) {
				DEBUG_ERR("[%s] truncate IE len (%d) to avoid buffer overrun\n", __func__, len);
				len = sizeof(priv->aeWapiIE) - 2;
			}
			memcpy(priv->aeWapiIE, p, len+2);
			priv->aeWapiIELength = len+2;
		}
#endif
	}
    }
#ifdef WDS
	else if ((OPMODE & WIFI_AP_STATE) && priv->pmib->dot11WdsInfo.wdsEnabled &&
		priv->pmib->dot11WdsInfo.wdsNum) {
		pstat = get_stainfo(priv, (unsigned char *)GetAddr2Ptr(pframe));
		if (pstat && (pstat->state & WIFI_WDS)) {
			collect_bss_info(priv, pfrinfo);

#ifdef CONFIG_RTL_88E_SUPPORT
			if (GET_CHIP_VER(priv)==VERSION_8188E) {
#ifdef TXREPORT
				add_RATid(priv, pstat);
#endif
			} else
#endif
			{
#if defined(CONFIG_RTL_92D_SUPPORT) || defined(CONFIG_RTL_92C_SUPPORT)			
				add_update_RATid(priv, pstat);
#endif
			}
			assign_aggre_mthod(priv, pstat);
			assign_tx_rate(priv, pstat, pfrinfo);
			assign_aggre_size(priv, pstat);
#ifdef TX_SHORTCUT
			/*Clear WDS station tx sc info*/
#if defined(CONFIG_PCI_HCI)
			if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE) {
				memset(pstat->tx_sc_ent, 0x0, sizeof(pstat->tx_sc_ent));
			}
#endif
#if defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI)
			if (GET_HCI_TYPE(priv) == RTL_HCI_USB || GET_HCI_TYPE(priv) == RTL_HCI_SDIO) {
				memset(pstat->TX_SC_ENT, 0x0, sizeof(pstat->TX_SC_ENT));
			}
#endif
#endif //TX_SHORTCUT
			if (!pstat->wds_probe_done){
				//WDEBUG("\n=>wds_probe_done=1\n\n");
#ifdef CONFIG_WLAN_HAL					
				if(IS_HAL_CHIP(priv)){
					GET_HAL_INTERFACE(priv)->UpdateHalMSRRPTHandler(priv, pstat, INCREASE);
				// Have to inform firmware that wds is connectted, so RA can operate correctly			
				}
#endif
#if defined(CONFIG_RTL_8812_SUPPORT) || defined(CONFIG_RTL_8723B_SUPPORT)
				if(GET_CHIP_VER(priv)== VERSION_8812E || GET_CHIP_VER(priv)== VERSION_8723B){
					UpdateHalMSRRPT8812(priv, pstat, INCREASE);
				}
#endif
				pstat->txpdrop_flag = 0;
				pstat->wds_probe_done = 1;
			}
		}
	}
#endif
#ifdef CONFIG_RTK_MESH	// ==== GANTOE ====
	if(pfrinfo->is_11s)
		return OnProbeRsp_MP(priv, pfrinfo);
#endif

// issue_MBO_GAS_init_req
//#if defined(CONFIG_MBO_CLI) && defined(HS2_CLIENT_TEST)
//	issue_MBO_GAS_init_req(priv);
//#endif

#if defined(CLIENT_MODE) && defined(DOT11K)
    if ((OPMODE & (WIFI_STATION_STATE | WIFI_ASOC_STATE)) ==
         (WIFI_STATION_STATE | WIFI_ASOC_STATE)) { 
        if(priv->pmib->dot11StationConfigEntry.dot11RadioMeasurementActivated) 
        {   
            rm_parse_ap_channel_report(priv, pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);
        }
    }
 #endif


	return SUCCESS;
}

unsigned int beacon_sanity(unsigned char *pframe, int pktlen)
{
	BOOLEAN ssid_sanity = FALSE;
	u1Byte len;
	int remainder;
	unsigned char *p;

	p = pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_;
	remainder = pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_;

	while (remainder > 0) {
		len = *(p + 1);
		if (*p == _SSID_IE_ &&  len <= 32)
			ssid_sanity = TRUE;

		p += (len +2);
		remainder -= (len + 2);
	}

	return (remainder == 0 && ssid_sanity) ? TRUE : FALSE;
}

unsigned int OnBeacon(struct rtl8192cd_priv *priv, struct rx_frinfo *pfrinfo)
{
    int i, len;
    unsigned char *p, *pframe, channel;

#ifdef RA_OFFSET_TRAINING
	unsigned char acquire_ch;
	unsigned char ht_info_element1=0, neighbor_second_ch_offset=0, neighbor_ch_width=0;
	unsigned char self_primary_ch_hi=0, self_primary_ch_low=0, self_second_ch=0, self_second_ch_hi=0, self_second_ch_low=0;
	unsigned char neighbor_second_ch=0, neighbor_second_ch_hi=0, neighbor_second_ch_low=0;	
	unsigned char self_primary_intf=0, self_second_intf=0;
	unsigned char neighbor_primary_intf=0, neighbor_second_intf=0;	
#endif

#ifdef BSS_MONITOR_SUPPORT
//	collect_monitor_info(priv, pfrinfo);
#endif

#ifdef RTK_MULTI_AP
	unsigned char *pframe2;
	pframe2 = get_pframe(pfrinfo);
	if(priv->multiap_unassocStaEntryOccupied)
		update_unassoc_MAC_RSSI_Entry(priv, GetAddr2Ptr(pframe2), pfrinfo->rf_info.rssi, 0, priv->multiap_unassoc_sta);
#endif

	if (beacon_sanity(get_pframe(pfrinfo), pfrinfo->pktlen) == FALSE)
		return FAIL;

    if (OPMODE & WIFI_SITE_MONITOR)
    {
        #ifdef CONFIG_RTK_MESH
        if(pfrinfo->is_11s && priv->auto_channel) {
            return OnBeacon_MP(priv, pfrinfo);
        }
        #endif


        #ifdef DOT11K
        if(priv->ss_req_ongoing == SSFROM_11K_BEACONREQ)
        {
            rm_collect_bss_info(priv, pfrinfo);
        }
        else
        #endif
            collect_bss_info(priv, pfrinfo);
        return SUCCESS;
    }

#ifdef AP_NEIGHBOR_INFO
	if(IS_ROOT_INTERFACE(priv) && (OPMODE & WIFI_AP_STATE) && priv->pmib->miscEntry.ap_neighbor_info_enable)
		ap_neighbor_add(priv, pfrinfo);	
#endif

#ifdef CONFIG_RTK_MESH
	if(pfrinfo->is_11s) {
#ifdef CONFIG_RTK_WPS_MESH
		if (1 == GET_MIB(priv)->dot1180211sInfo.mesh_enable) {
			len = 0;
			p = get_pframe(pfrinfo) + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_;
			for (;;) {
				p = get_ie(p, _VENDOR_SPEC_IE_, &len, pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_ - len);
				if (p) {
					if (!memcmp(p+2, MESH_VENDOR_OUI, 3) && !memcmp(p+5, MESH_TARGET_VAL, 2)) {
						int mac_cipher_len = *(p+7);
						int hw_serial_no_len = *(p+8+mac_cipher_len);
						char hw_serial_no_cipher[65] = {0};
						memcpy(hw_serial_no_cipher, p+8+mac_cipher_len+1, hw_serial_no_len);
						/* Easy way to descrypt a string */
						for(i = 0; i < hw_serial_no_len; i++)
							hw_serial_no_cipher[i] ^= MESH_TARGET_KEY[i%16];

						if(GET_ROOT(priv)->pmib->wscEntry.wsc_meshmode == 0 &&
							((mac_cipher_len == strlen(priv->pmib->wscEntry.wsc_mac_cipher) 
							&& !memcmp(p+8, priv->pmib->wscEntry.wsc_mac_cipher, mac_cipher_len))
							|| (hw_serial_no_len == strlen(priv->pmib->miscEntry.hw_serial_no)
							&& !memcmp(hw_serial_no_cipher, priv->pmib->miscEntry.hw_serial_no, hw_serial_no_len))
							)
						) {
							if(priv->mesh_target_block == 0) {
								printk("MESH_TARGET_VAL Content Match!\n");
								priv->mesh_target_block = 30;
#ifdef __LINUX_2_6_27__
								kill_pid(priv->_wscd_pid, SIGUSR2, 1);
#else
								kill_proc(priv->pmib->wscEntry.wscd_pid, SIGUSR2, 1);
#endif
								break;
							}
						}
					}
					if(priv->ss_serial_timer && !memcmp(p+2, MESH_VENDOR_OUI, 3) && !memcmp(p+5, MESH_SERIAL_VAL, 2)) {
						/* refer to update_beacon() */
						int find = 0;
						unsigned char hw_serial_mac[MACADDRLEN] = {0};
						int hw_serial_no_len = *(p+1)-5-MACADDRLEN;
						char hw_serial_no_cipher[65] = {0};
						memcpy(hw_serial_mac, p+7, MACADDRLEN);
						memcpy(hw_serial_no_cipher, p+7+MACADDRLEN, hw_serial_no_len);
						/* Easy way to descrypt a string */
						for(i = 0; i < hw_serial_no_len; i++)
							hw_serial_no_cipher[i] ^= MESH_SERIAL_KEY[i%16];

						for(i = 0; i < priv->ss_serial_cnt; i++) {
							if(!memcmp(hw_serial_mac, priv->ss_serial_mac[i], MACADDRLEN)
								&& hw_serial_no_len == strlen(priv->ss_serial_no[i])
								&& !memcmp(hw_serial_no_cipher, priv->ss_serial_no[i], hw_serial_no_len)) {
								find = 1;
								break;
							}
						}
						if(!find && priv->ss_serial_cnt < 16) {
							memcpy(priv->ss_serial_mac[priv->ss_serial_cnt], hw_serial_mac, MACADDRLEN);
							memcpy(priv->ss_serial_no[priv->ss_serial_cnt], hw_serial_no_cipher, hw_serial_no_len);
							priv->ss_serial_cnt++;
						}
					}
				}
				else {
					break;
				}
				p = p + len + 2;
			}
		}
#endif
        return OnBeacon_MP(priv, pfrinfo);
    }
#endif

    pframe = get_pframe(pfrinfo);
	if(priv->pmib->dot11StationConfigEntry.unassoc_sta_scan_ongoing)
		collect_bss_info(priv, pfrinfo);
		

    p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, _DSSET_IE_, &len,
        pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);
    if (p != NULL)
    {
        channel = *(p+2);
#ifdef RA_OFFSET_TRAINING
        acquire_ch = 1;
#endif		
    }
    else
        channel = priv->pmib->dot11RFEntry.dot11channel;

    // If used as AP in G mode, need monitor other 11B AP beacon to enable
    // protection mechanism
#ifdef WDS
    // if WDS is used, need monitor other WDS AP beacon to decide tx rate
    if (priv->pmib->dot11WdsInfo.wdsEnabled ||
        ((OPMODE & WIFI_AP_STATE) && (priv->pmib->dot11BssType.net_work_type & (WIRELESS_11G|WIRELESS_11A)) &&
        (channel == priv->pmib->dot11RFEntry.dot11channel)))
#else
    if ((OPMODE & WIFI_AP_STATE) &&
        (priv->pmib->dot11BssType.net_work_type & (WIRELESS_11G|WIRELESS_11A)) &&
        (channel == priv->pmib->dot11RFEntry.dot11channel))
#endif
    {
        // look for ERP rate. if no ERP rate existed, thought it is a legacy AP
        unsigned char supportedRates[32];
        int supplen=0, legacy=1;

        p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_,
            _SUPPORTEDRATES_IE_, &len,
            pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);
        if (p) {
            if (len>8)
                len=8;
            memcpy(&supportedRates[supplen], p+2, len);
            supplen += len;
        }

        p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_,
                _EXT_SUPPORTEDRATES_IE_, &len,
                pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);
        if (p) {
            if (len > sizeof(supportedRates)-supplen)
                len = sizeof(supportedRates)-supplen;
            memcpy(&supportedRates[supplen], p+2, len);
            supplen += len;
        }

#if defined(RTK_MULTI_AP) && defined(RTK_MULTI_AP_R1_DFS) && (defined(DFS) || defined(RTK_AC_SUPPORT))
		if (!GET_ROOT(priv)->pmib->dot11DFSEntry.DFS_detected) {
			// Realtek proprietary IE
			unsigned char is_rtk_multiap = 0;
			p = pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_; len = 0;
			for (;;)
			{
				p = get_ie(p, _RSN_IE_1_, &len,
				pfrinfo->pktlen - (p - pframe));
				if (p != NULL) {
					if (!memcmp(p+2, Realtek_OUI, 3) && *(p+2+3) == 5) { /*found realtek out and type == 5*/
						is_rtk_multiap = 1;
						break;
					}
				}
				else
					break;
				p = p + len + 2;
			}
			static char* tmp_name = "wlan0";
			if (is_rtk_multiap && !memcmp(priv->dev->name, tmp_name, 5)) {
				if (GET_ROOT(priv)->pmib->multi_ap.multiap_dfs_debug_print) {
					//----TESTING CODE-------
					static unsigned char test_addr[60] = {0};
					static unsigned char test_addr_nr  = 0, l;
					static unsigned int test_counter = 0;
					for (l = 0; l < test_addr_nr; l++) {
						if (!memcmp(&test_addr[l * 6], GetAddr2Ptr(pframe), 6) ) {
							break;
						}
					}
					if (l == test_addr_nr) {
						memcpy(&test_addr[test_addr_nr * 6], GetAddr2Ptr(pframe), 6);
						test_addr_nr++;
					}
					if (test_counter >= 80) {
						panic_printk("========DFS DEBUG - Receiving beacon from======\n");
						for (l = 0; l < test_addr_nr; l++) {
							panic_printk("%02x:%02x:%02x:%02x:%02x:%02x\n", test_addr[l * 6 + 0], test_addr[l * 6 + 1], test_addr[l * 6 + 2], test_addr[l * 6 + 3], test_addr[l * 6 + 4], test_addr[l * 6 + 5]);
						}
						panic_printk("===============================================\n");
						test_counter = 0;
						test_addr_nr = 0;
						memset(test_addr, 0, 60);
					}
					test_counter++;
					//-----------------------
				}
				p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, _CSA_IE_, &len,
					pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);
				if (p != NULL){
					//if it is currently on dfs channel
					if ((GET_ROOT(priv)->pmib->dot11RFEntry.dot11channel >= 52 && GET_ROOT(priv)->pmib->dot11RFEntry.dot11channel <= 64) 
					|| (GET_ROOT(priv)->pmib->dot11RFEntry.dot11channel >= 100 && GET_ROOT(priv)->pmib->dot11RFEntry.dot11channel <= 144)) {
						//if it contains rtk multiap ie and csa ie
						GET_ROOT(priv)->pmib->dot11DFSEntry.DFS_detected = 1;
						GET_ROOT(priv)->pshare->dfsSwitchChannel = (unsigned int)*(p+3);
						GET_ROOT(priv)->pshare->dfsSwitchChCountDown =(unsigned int)*(p+4);
						GET_ROOT(priv)->pmib->multi_ap.multiap_csa_heard = 1;
						printk("[MULTI_AP] CSA Detected on %s - mode=%d, channel=%d, countdown=%d\n", priv->dev->name, *(p+2), priv->pshare->dfsSwitchChannel, priv->pshare->dfsSwitchChCountDown);
					}
				}
			}

		}
#endif

#ifdef WDS
        if (priv->pmib->dot11WdsInfo.wdsEnabled) {
            struct stat_info *pstat = get_stainfo(priv, GetAddr2Ptr(pframe));
            if (pstat && !(pstat->state & WIFI_WDS_RX_BEACON)) {
                get_matched_rate(priv, supportedRates, &supplen, 0, sizeof(supportedRates));
                update_support_rate(pstat, supportedRates, supplen);
                if (supplen == 0)
                    pstat->current_tx_rate = 0;
                else {
                    if (priv->pmib->dot11WdsInfo.entry[pstat->wds_idx].txRate == 0) {
                        pstat->current_tx_rate = find_rate(priv, pstat, 1, 0);
                        //pstat->upper_tx_rate = 0;	// unused
                    }
                }

                // Customer proprietary IE
                if (priv->pmib->miscEntry.private_ie_len) {
                    p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_,
                            priv->pmib->miscEntry.private_ie[0], &len,
                            pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);
                    if ((p) && (len+2 <= sizeof(pstat->private_ie))) {
                        memcpy(pstat->private_ie, p, len + 2);
                        pstat->private_ie_len = len + 2;
                    }
                }

                // Realtek proprietary IE
                pstat->is_realtek_sta = FALSE;				
                p = pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_; len = 0;
                for (;;)
                {
                    p = get_ie(p, _RSN_IE_1_, &len,
                    pfrinfo->pktlen - (p - pframe));
                    if (p != NULL) {
                        if (!memcmp(p+2, Realtek_OUI, 3) && *(p+2+3) == 2) { /*found realtek out and type == 2*/
                            pstat->is_realtek_sta = TRUE;
                            break;
                        }
                    }
                    else
                        break;
                    p = p + len + 2;
                }

#ifdef WIFI_WMM
                if (QOS_ENABLE) {
                    p = pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_;
                    for (;;) {
                        p = get_ie(p, _RSN_IE_1_, &len,
                        pfrinfo->pktlen - (p - pframe));
                        if (p != NULL) {
                            if (!memcmp(p+2, WMM_PARA_IE, 6)) {
                                pstat->QosEnabled = 1;
                                break;
                            }
                        }
                        else {
                            pstat->QosEnabled = 0;
                            break;
                        }
                        p = p + len + 2;
                    }
                }
#endif
                if (priv->pmib->dot11BssType.net_work_type & WIRELESS_11N) {
                    p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, _HT_CAP_, &len,
                            pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);
                    if ((p !=  NULL) && (len <= sizeof(struct ht_cap_elmt))) {
                        pstat->ht_cap_len = len;
                        memcpy((unsigned char *)&pstat->ht_cap_buf, p+2, len);
                        if (cpu_to_le16(pstat->ht_cap_buf.ht_cap_info) & _HTCAP_AMSDU_LEN_8K_) {
                            pstat->is_8k_amsdu = 1;
				if (AMPDU_ENABLE && (AMSDU_ENABLE >= 2)) {
					pstat->amsdu_level = 4095 - sizeof(struct wlan_hdr);
				} else {
					pstat->amsdu_level = 7935 - sizeof(struct wlan_hdr);
				}
                        }
                        else {
                            pstat->is_8k_amsdu = 0;
                            pstat->amsdu_level = 3839 - sizeof(struct wlan_hdr);
                        }
                    }
                    else
                        pstat->ht_cap_len = 0;
                }

                if (pstat->ht_cap_buf.ht_cap_info & cpu_to_le16(_HTCAP_SUPPORT_CH_WDTH_))
                    pstat->tx_bw = CHANNEL_WIDTH_40;
				else
					pstat->tx_bw = CHANNEL_WIDTH_20;

				/*-----------------get VHT info------------------*/				
#if defined(RTK_AC_SUPPORT) || defined(RTK_AC_TX_SUPPORT)		//WDS-VHT support
                if ((priv->pmib->dot11BssType.net_work_type & WIRELESS_11AC) || priv->pshare->phw->is_AC_TX_support)
                {
                    p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, EID_VHTCapability, &len,
                            pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);

                    if ((p !=  NULL) && (len <= sizeof(struct vht_cap_elmt))) {
                        pstat->vht_cap_len = len;
                        memcpy((unsigned char *)&pstat->vht_cap_buf, p+2, len);
                        //WDEBUG("vht_cap len = %d \n",len);		
                        //WDEBUG("vht_cap vht_cap_info:%04X \n",pstat->vht_cap_buf.vht_cap_info);	
                        //WDEBUG("vht_cap vht_support_mcs[0]=[%04X] ; vht_support_mcs[1]=[%04X] \n", pstat->vht_cap_buf.vht_support_mcs[0],pstat->vht_cap_buf.vht_support_mcs[1]);

                    }

                    p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, EID_VHTOperation, &len,
                            pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);

                    if ((p !=  NULL) && (len <= sizeof(struct vht_oper_elmt))) {
                        pstat->vht_oper_len = len;
                        memcpy((unsigned char *)&pstat->vht_oper_buf, p+2, len);
                        //WDEBUG("vht_oper len = %d \n",len);
                        //WDEBUG("vht_oper: 0[%02x],1[%02x],2[%02x] \n",pstat->vht_oper_buf.vht_oper_info[0],pstat->vht_oper_buf.vht_oper_info[1],pstat->vht_oper_buf.vht_oper_info[2]);						
                        //WDEBUG("vht_oper [%02X]\n",pstat->vht_oper_buf.vht_basic_msc);

                    }

                    if(pstat->vht_cap_len){
                        switch(cpu_to_le32(pstat->vht_cap_buf.vht_cap_info) & 0x3) {
                            default:				
                            case 0:	
                                pstat->is_8k_amsdu = 0;
                                pstat->amsdu_level = 3895 - sizeof(struct wlan_hdr);
                                break;
                            case 1:
                                pstat->is_8k_amsdu = 1;
                                pstat->amsdu_level = 7991 - sizeof(struct wlan_hdr);
                                break;
                            case 2:	
                                pstat->is_8k_amsdu = 1;
                                pstat->amsdu_level = 11454 - sizeof(struct wlan_hdr);	
                                break;
                        }

                        if ((priv->vht_oper_buf.vht_oper_info[0] == 1) && (pstat->vht_oper_buf.vht_oper_info[0] == 1)) {
                            pstat->tx_bw = CHANNEL_WIDTH_80;
                            priv->pshare->is_40m_bw	= CHANNEL_WIDTH_80;	
                            //WDEBUG("pstat->tx_bw=80M\n");
                        }

                    }

                    p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, EID_VHTOperatingMode, &len,
                            pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);
                    if ((p !=  NULL) && (len == 1)) {
                        // check self capability....					
                        if((p[2] &3) <= priv->pmib->dot11nConfigEntry.dot11nUse40M)
                            pstat->tx_bw = p[2] &3;
                        pstat->nss = ((p[2]>>4)&0x7)+1;											
                        //WDEBUG("receive opering mode data = %02X\n" ,p[2]);
                    }

#if defined(CONFIG_RTL_8812_SUPPORT) || defined(CONFIG_RTL_8723B_SUPPORT)
                    if(GET_CHIP_VER(priv)== VERSION_8812E || GET_CHIP_VER(priv)== VERSION_8723B){

                        //WDEBUG("UpdateHalRAMask8812 \n");
                        UpdateHalRAMask8812(priv, pstat, 3);
                    }
#endif
#ifdef  CONFIG_WLAN_HAL
                    if (IS_HAL_CHIP(priv)){
                        init_rainfo(priv, pstat);
                    }
#endif

                }
#endif	
                /*-----------------get VHT info------------------*/								

                assign_tx_rate(priv, pstat, pfrinfo);
                assign_aggre_mthod(priv, pstat);
                assign_aggre_size(priv, pstat);
                pstat->state |= WIFI_WDS_RX_BEACON;
            }

            if (pstat && pstat->state & WIFI_WDS) {
                pstat->beacon_num++;
                if (!pstat->wds_probe_done){
                    pstat->wds_probe_done = 1;
                    collect_bss_info(priv, pfrinfo);
#ifdef CONFIG_WLAN_HAL					
                    if(IS_HAL_CHIP(priv)){
                        GET_HAL_INTERFACE(priv)->UpdateHalMSRRPTHandler(priv, pstat, INCREASE);
                        // Have to inform firmware that wds is connectted, so RA can operate correctly			
                    }
#endif
#if defined(CONFIG_RTL_8812_SUPPORT) || defined(CONFIG_RTL_8723B_SUPPORT)
                    if(GET_CHIP_VER(priv)== VERSION_8812E || GET_CHIP_VER(priv)== VERSION_8723B){
                        UpdateHalMSRRPT8812(priv, pstat, INCREASE);
                    }
#endif
                    pstat->txpdrop_flag = 0;

#ifdef CONFIG_RTL_OFFLOAD_DRIVER
                    dc_sta_add(priv, pstat);
#endif

                    assign_aggre_mthod(priv, pstat);
                    assign_aggre_size(priv, pstat);					
                    //WDEBUG("\n=>wds_probe_done=1\n\n");					
                }
            }
        }
#endif

        for (i=0; i<supplen; i++) {
            if (!is_CCK_rate(supportedRates[i]&0x7f)) {
                legacy = 0;
                break;
            }
        }

        // look for ERP IE and check non ERP present
        if (legacy == 0) {
            p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, _ERPINFO_IE_,
                    &len, pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);
            if (p && (*(p+2) & BIT(0)))
                legacy = 1;
        }

        if (legacy) {
            if (!priv->pmib->dot11StationConfigEntry.olbcDetectDisabled &&
                    priv->pmib->dot11ErpInfo.olbcDetected==0) {
                priv->pmib->dot11ErpInfo.olbcDetected = 1;
                check_protection_shortslot(priv);
                DEBUG_INFO("OLBC detected\n");
            }
            if (priv->pmib->dot11ErpInfo.olbcDetected)
                priv->pmib->dot11ErpInfo.olbcExpired = DEFAULT_OLBC_EXPIRE;
        }
    }

    if ((OPMODE & WIFI_AP_STATE) &&
            (priv->pmib->dot11BssType.net_work_type & WIRELESS_11N) 
            //		&& (channel == priv->pmib->dot11RFEntry.dot11channel)
    ) 
    {
        if (!priv->pmib->dot11StationConfigEntry.protectionDisabled &&
        !priv->pmib->dot11StationConfigEntry.olbcDetectDisabled) {
            p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, _HT_CAP_,
                    &len, pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);
            if (p == NULL)
                priv->ht_legacy_obss_to = 60;	
        }

        if (!priv->pmib->dot11StationConfigEntry.protectionDisabled &&
            !priv->pmib->dot11StationConfigEntry.nmlscDetectDisabled) {

            p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, _HT_IE_, &len,
                    pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);
            if (p !=  NULL) {
                struct ht_info_elmt *ht_info=(struct ht_info_elmt *)(p+2);
                if (len) {
                    unsigned int prot_mode =  (cpu_to_le16(ht_info->info1) & 0x03);
                    if (prot_mode == _HTIE_OP_MODE3_)
                        priv->ht_nomember_legacy_sta_to= 60;	
                }
            }		
        }
    }

#ifdef WIFI_11N_2040_COEXIST
    if (priv->pmib->dot11nConfigEntry.dot11nCoexist && (OPMODE & WIFI_AP_STATE) &&
            (priv->pmib->dot11BssType.net_work_type & (WIRELESS_11N|WIRELESS_11G)) && 
            priv->pshare->is_40m_bw) {
        p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, _HT_CAP_,
            &len, pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);
        if ((p == NULL) && bg_ap_rssi_chk(priv, pfrinfo, channel)) {

            if (channel && (priv->pmib->dot11nConfigEntry.dot11nCoexist_ch_chk ?
                (channel != priv->pmib->dot11RFEntry.dot11channel) :1))
            {			
                if(!priv->bg_ap_timeout) {
                    priv->bg_ap_timeout = 60;
#if defined(CONFIG_RTL_8812_SUPPORT) || defined(CONFIG_WLAN_HAL) || defined(CONFIG_RTL_8723B_SUPPORT) 				
                    update_RAMask_to_FW(priv, 1);
#endif					
                    SetTxPowerLevel(priv, channel);
#ifdef CONFIG_RTL_OFFLOAD_DRIVER
                    dc_if_update(priv, 1);
#endif
                }
                //priv->bg_ap_timeout = 60;
            }
        }
    }
#endif


#ifdef DOT11K
    if(priv->pmib->dot11StationConfigEntry.dot11RadioMeasurementActivated &&
        priv->pmib->dot11StationConfigEntry.dot11RMNeighborReportActivated) {
        rm_construct_neighbor_report(priv, pfrinfo, channel);
    }
#endif

#ifdef COCHANNEL_RTS
	if ((OPMODE & WIFI_AP_STATE) && (channel == priv->pmib->dot11RFEntry.dot11channel))
	{
#ifdef CONFIG_RTL_OFFLOAD_DRIVER
        if (priv->cochannel_to == 0)
            dc_if_update(priv, 1);
#endif
		priv->cochannel_to = 5;
	}
#endif

#ifdef RA_OFFSET_TRAINING
	if (GET_CHIP_VER(priv) == VERSION_8192F)
	{
		if (priv->pmib->miscEntry.ra_training)
		{
			if ((acquire_ch) && ((priv->pshare->rssi_min != 0xff) && (priv->pshare->rssi_min > priv->pmib->miscEntry.ra_rssi_th))) 
			{				
				p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, _HT_IE_, &len,
					pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);
	
				if (p == NULL)	return SUCCESS;
				ht_info_element1 = *(p+3);
				neighbor_second_ch_offset = ht_info_element1 & 0x03;
				neighbor_ch_width = (ht_info_element1 & 0x04)>>2;		
	
				self_primary_ch_hi = ((priv->pmib->dot11RFEntry.dot11channel+2)>13)?13:(priv->pmib->dot11RFEntry.dot11channel+2);
				self_primary_ch_low = ((priv->pmib->dot11RFEntry.dot11channel-2)<1)?1:(priv->pmib->dot11RFEntry.dot11channel-2);
				if ((channel >= self_primary_ch_low) && (channel <= self_primary_ch_hi))
					self_primary_intf = 1;
	
				if (priv->pshare->CurrentChannelBW == CHANNEL_WIDTH_40)
				{
					if (priv->pshare->offset_2nd_chan == HT_2NDCH_OFFSET_ABOVE)
						self_second_ch = ((priv->pmib->dot11RFEntry.dot11channel+4)>13)?0:priv->pmib->dot11RFEntry.dot11channel+4;
					else
						self_second_ch = ((priv->pmib->dot11RFEntry.dot11channel-4)<1)?0:priv->pmib->dot11RFEntry.dot11channel-4;
	
					if (self_second_ch)
					{
						self_second_ch_hi = ((self_second_ch+2)>13)?13:(self_second_ch+2);
						self_second_ch_low = ((self_second_ch-2)<1)?1:(self_second_ch-2);		
						if ((channel >= self_second_ch_low) && (channel <= self_second_ch_hi))
							self_second_intf = 1;							
					}	
				}
	
				if (neighbor_ch_width)
				{
					if (neighbor_second_ch_offset == _HTIE_2NDCH_OFFSET_AB_)
						neighbor_second_ch = ((channel+4)>13)?0:channel+4;
					else
						neighbor_second_ch = ((channel-4)<1)?0:channel-4;
						
					if (neighbor_second_ch)
					{
						neighbor_second_ch_hi = ((neighbor_second_ch+2)>13)?13:(neighbor_second_ch+2);
						neighbor_second_ch_low = ((neighbor_second_ch-2)<1)?1:(neighbor_second_ch-2);		
						if ((priv->pmib->dot11RFEntry.dot11channel >= neighbor_second_ch_low) && (priv->pmib->dot11RFEntry.dot11channel <= neighbor_second_ch_hi))
							neighbor_primary_intf = 1;	
	
						if (self_second_ch)
						{
							if ((self_second_ch >= neighbor_second_ch_low) && (self_second_ch <= neighbor_second_ch_hi))
								neighbor_second_intf = 1;	
						}
					}
				}
	
				//printk("%s: adj_intf(%d) RSSI(%d) DUT_BW(%d) DUT_CH(%d) NBOR_CH(%d) NBOR_OFFSET(%d) NBOR_WIDTH(%d) Self(%d,%d), NBOR(%d,%d)\n", __FUNCTION__, priv->pshare->adjacent_intf, priv->pshare->rssi_min, priv->pshare->CurrentChannelBW, priv->pmib->dot11RFEntry.dot11channel, channel, neighbor_second_ch_offset, neighbor_ch_width, self_primary_intf, self_second_intf, neighbor_primary_intf, neighbor_second_intf);				
				priv->pshare->adjacent_intf |= self_primary_intf | self_second_intf | neighbor_primary_intf | neighbor_second_intf; 			
			}
		}
	}
#endif	

#ifdef CTC_AP_COEXIST
	if ((GET_CHIP_VER(priv) == VERSION_8192F) || (GET_CHIP_VER(priv) == VERSION_8812F)) {
		if(priv->pshare->rf_ft_var.ap_coexist_enable) {
			if (channel == priv->pmib->dot11RFEntry.dot11channel) {
				p = pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_; len = 0;
				for (;;)
				{
					p = get_ie(p, _RSN_IE_1_, &len,
					pfrinfo->pktlen - (p - pframe));
					if (p != NULL) {
						if (!memcmp(p+2, Realtek_OUI, 3) && *(p+2+3) == 2) { /*found realtek out and type == 2*/
							if ((GET_CHIP_VER(priv) == VERSION_8192F) && (pfrinfo->rf_info.rssi > 50)) {
								priv->pshare->rtk_ap_detected_to = 30;
							}

							if ((GET_CHIP_VER(priv) == VERSION_8812F) && (priv->pshare->CurrentChannelBW == CHANNEL_WIDTH_40) && (pfrinfo->rf_info.rssi > 50)) {
								p = get_ie(pframe + WLAN_HDR_A3_LEN + _BEACON_IE_OFFSET_, EID_VHTOperation, &len,
								    pfrinfo->pktlen - WLAN_HDR_A3_LEN - _BEACON_IE_OFFSET_);

								if ((p !=  NULL) && (len <= sizeof(struct vht_oper_elmt))) {
									struct vht_oper_elmt vht_oper;
									memcpy((unsigned char *)&vht_oper, p+2, len);
									if (vht_oper.vht_oper_info[0] == 1) { /*found realtek 5G  BW80 AP*/
										priv->pshare->rtk_ap_detected_to = 30;
									}
								}
							}

							break;
						}
					}
					else
						break;
					p = p + len + 2;
				}
			}
		}
	}
#endif

	return SUCCESS;
}


unsigned int OnDisassoc(struct rtl8192cd_priv *priv, struct rx_frinfo *pfrinfo)
{
	unsigned char *pframe;
	struct  stat_info   *pstat;
	unsigned char *sa;
	unsigned short reason;
	DOT11_DISASSOCIATION_IND Disassociation_Ind;
#ifndef SMP_SYNC
	unsigned long flags;
#endif

	pframe = get_pframe(pfrinfo);
	sa = GetAddr2Ptr(pframe);
	pstat = get_stainfo(priv, sa);

	if (pstat == NULL)
		return 0;

	// Ignore disassoc request if we have received deauth from the same STA
#ifdef WDS
	if (!(pstat->state & WIFI_DELETE_STATE) && ((pstat->state & ~(WIFI_WDS)) != 0))
#else
	if (!(pstat->state & WIFI_DELETE_STATE) && (pstat->state != 0))
#endif
	{
		delsta_list_add(priv, pstat);
		pstat->state |= WIFI_DELETE_STATE;
		pstat->expire_to = DELSTATIME;
	} else {
		return 0;
	}

#ifdef CTC_WIFI_DIAG
	ctcwifi_diag_log(priv, pstat->cmn_info.mac_addr, 0, "Disassociation", (pframe+WLAN_HDR_A3_LEN), (pfrinfo->pktlen-WLAN_HDR_A3_LEN));
#endif

#ifdef CONFIG_POWER_SAVE
	priv->pshare->xfer_seq++;
#endif

#ifdef CONFIG_IEEE80211W
	if(pstat->isPMF) {
		pstat->isPMF = 0; // transmit unprotected mgmt frame
	}
#endif

#ifdef CONFIG_IEEE80211V
	if(WNM_ENABLE) {
		reset_staBssTransStatus(pstat);
	}
#endif

#ifdef RTK_WOW
	if (pstat->is_rtk_wow_sta)
		return 0;
#endif

#ifdef P2P_SUPPORT
    P2P_DEBUG("	............on DisAssoc\n");
    MAC_PRINT(pstat->cmn_info.mac_addr);
    /*cfg p2p cfg p2p*/	
    if((rtk_p2p_is_enabled(priv) == PROPERTY_P2P) && (rtk_p2p_chk_role(priv,P2P_TMP_GO))){
        if(pstat->is_p2p_client){
            p2p_client_remove(priv,pstat);
        }
    }
#endif

	reason = cpu_to_le16(*(unsigned short *)((unsigned long)pframe + WLAN_HDR_A3_LEN ));
	DEBUG_INFO("receiving disassoc from station %pm reason %d\n",
		pstat->cmn_info.mac_addr, reason);

#ifdef CTC_WIFI_DIAG
	ctcwifi_assoc_err(priv, pstat->cmn_info.mac_addr, "De-authed [receive disassoc, reason %d]\n", reason);
#endif
#ifdef STA_ASSOC_STATISTIC
	add_sta_assoc_status(priv, sa, pfrinfo->rf_info.rssi, reason | 0xd00);
#endif
#ifdef MULTI_MAC_CLONE
	__del_mclone_addr(priv, pstat->cmn_info.mac_addr);//this function only AP in.
#endif

	SAVE_INT_AND_CLI(flags);
#ifdef ADDRESS_CAM
    if (IS_SUPPORT_ADDR_CAM(priv))
        GET_HAL_INTERFACE(priv)->ClearADDRCAMHandler(priv,pstat);
#endif

	if (asoc_list_del(priv, pstat))
	{
		if (pstat->expire_to > 0)
		{
			cnt_assoc_num(priv, pstat, DECREASE, (char *)__FUNCTION__);
			check_sta_characteristic(priv, pstat, DECREASE);
		}
	}

	// Need change state back to autehnticated
	if (IEEE8021X_FUN)
	{
#if !defined(WITHOUT_ENQUEUE) && !defined(RTK_NL80211)
		memcpy((void *)Disassociation_Ind.MACAddr, (void *)sa, MACADDRLEN);
		Disassociation_Ind.EventId = DOT11_EVENT_DISASSOCIATION_IND;
		Disassociation_Ind.IsMoreEvent = 0;
		Disassociation_Ind.Reason = reason;
		Disassociation_Ind.tx_packets = pstat->tx_pkts;
		Disassociation_Ind.rx_packets = pstat->rx_pkts;
		Disassociation_Ind.tx_bytes   = pstat->tx_bytes;
		Disassociation_Ind.rx_bytes   = pstat->rx_bytes;
		DOT11_EnQueue((unsigned long)priv, priv->pevent_queue, (UINT8 *)&Disassociation_Ind,
					sizeof(DOT11_DISASSOCIATION_IND));
#endif
	}

#ifdef RTK_MULTI_AP
	client_leave_notify(BSSID, sa);
#if (EASYMESH_VERSION >= MULTI_AP_VERSION(2,0,0))
	rtk_multi_ap_trigger_disassoc_stats_message(pstat, reason);
#endif
#endif
#ifdef CONFIG_RTK_WLAN_MANAGER
	rtk_wlan_manager_nl_send_del_sta_msg(priv, pstat->cmn_info.mac_addr);
#endif

	// STA fallbacks to AUTHENTICATED state from ASSOCIATED state but is still
	// connected. Hence, reuse the same stat_info object.
	release_stainfo(priv, pstat);
	init_stainfo(priv, pstat);

	// Since STA is still connected, do not set WIFI_DELETE_STATE to pstat->state.
	// This prevent the driver from calling free_stainfo() on this object when
	// hostapd calls del_station() via cfg80211 API.
	pstat->state |= WIFI_AUTH_SUCCESS;
	pstat->expire_to = priv->assoc_to;
	auth_list_add(priv, pstat);

	RESTORE_INT(flags);

	if (IEEE8021X_FUN)
	{
#if defined(INCLUDE_WPA_PSK) || defined(WIFI_HAPD) || defined(RTK_NL80211)
		psk_indicate_evt(priv, DOT11_EVENT_DISASSOCIATION_IND, sa, NULL, 0);
#endif
	}

#if defined(__ECOS) && defined(CONFIG_SDIO_HCI)
	if (priv->sta_status_cb_func)
		priv->sta_status_cb_func("wlan0", sa, WIFI_STA_STATUS_DISASSOCIATED);
#else
	LOG_MSG("A wireless client is disassociated - %02X:%02X:%02X:%02X:%02X:%02X\n",
		*sa, *(sa+1), *(sa+2), *(sa+3), *(sa+4), *(sa+5));

#endif
#ifdef RTK_NL80211
	// Notify hostapd to delete its internal record of this STA.
	event_indicate_cfg80211(priv, sa, CFG80211_DEL_STA, NULL);
#endif
#ifdef WIFI_HAPD
	event_indicate_hapd(priv, sa, HAPD_EXIRED, NULL);
#ifdef HAPD_DRV_PSK_WPS
	event_indicate(priv, sa, 2);
#endif
#else
	event_indicate(priv, sa, 2);
#endif
#ifdef RTK_WLAN_EVENT_INDICATE
	rtk_wlan_event_indicate(priv->dev->name, WIFI_PEER_DISCONNECT, pstat->cmn_info.mac_addr, reason);
#endif
#ifdef AUTH_SAE
	log("delete_peer [%pm]", sa);
	delete_peer(priv, sa);
#endif
	return SUCCESS;
}

#ifdef __OSK__
// 20090511 according TR098's MAC address control capability, we implement an new access control hook here
int (*lanMacAcWlanHook)(unsigned char*, struct net_device *)=NULL;
#endif

unsigned int OnAuth(struct rtl8192cd_priv *priv, struct rx_frinfo *pfrinfo)
{
	unsigned int		my_auth_type,peer_seq, len;
#if 1/*!defined(SMP_SYNC) || (defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI))    */
	unsigned long		flags=0;
#endif
	struct list_head	*phead, *plist;
	struct wlan_acl_node *paclnode;
	unsigned int		acl_mode;

	struct wifi_mib		*pmib;
	struct stat_info	*pstat=NULL, *pstat_tmp=NULL;
	unsigned char		*pframe, *sa, *p;
	unsigned int		res=FAIL;
	UINT16				peer_auth_type;
	int					status, alloc_pstat=0;
	struct ac_log_info	*log_info;
#ifdef STA_CONTROL
	unsigned char		req_status;
#endif
	struct aid_obj *aidobj;
	int j;

	pmib = GET_MIB(priv);

#if defined(CONFIG_RTK_MESH) && defined(MESH_BOOTSEQ_AUTH)
	UINT8	isMeshMP = FALSE, prev