/******************************************************************************
 *
 * Copyright(c) 2007 - 2017 Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 *****************************************************************************/

#include "mp_precomp.h"
#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
#if RT_PLATFORM == PLATFORM_MACOSX
#include "phydm_precomp.h"
#else
#include "../phydm_precomp.h"
#endif
#else
#include "../../phydm_precomp.h"
#endif

#if (RTL8197G_SUPPORT == 1)

#if 1
u32 array_mp_8197g_cal_init[] = {
	0x1b00, 0x00000008,
	0x1b00, 0x00A70008,
	0x1b00, 0x00150008,
	0x1b00, 0x00000008,
	0x1b04, 0xE0462996,
	0x1b08, 0x00000080,
	0x1b0c, 0x00000000,
	0x1b10, 0x00010C00,
	0x1b14, 0x00000000,
	0x1b18, 0x00292903,
	0x1b1c, 0xA218FC32,
	0x1b20, 0x03040008,
	0x1b24, 0x00060008,
	0x1b28, 0x00060300,
	0x1b2C, 0x00180018,
	0x1b30, 0x20000000,
	0x1b34, 0x00000800,
	0x1b38, 0x20000000,
	0x1b3C, 0x20000000,
	0x1b8c, 0xFCFF4c20,
	0x1b90, 0x0105f018,
	0x1b94, 0xf76d9f84,
	0x1bc8, 0x000c5599,
	0x1bcc, 0x11160200,
	0x1bf8, 0x000000c6,
	0x1be0, 0x20000000,
	0x1bc4, 0x001F001F,
	0x1bb8, 0x00000001,
	0x1bb8, 0x00000000,
	0x1bbc, 0x0000563F,
	0x1b98, 0x41382e21,
	0x1b9c, 0x5b554f48,
	0x1ba0, 0x6f6b6661,
	0x1ba4, 0x817d7874,
	0x1ba8, 0x908c8884,
	0x1bac, 0x9d9a9793,
	0x1bb0, 0xaaa7a4a1,
	0x1bb4, 0xb6b3b0ad,
	0x1b40, 0x02ce03e9,
	0x1b44, 0x01fd0249,
	0x1b48, 0x01a101c9,
	0x1b4c, 0x016a0181,
	0x1b50, 0x01430155,
	0x1b54, 0x01270135,
	0x1b58, 0x0112011c,
	0x1b5c, 0x01000108,
	0x1b60, 0x00f100f8,
	0x1b64, 0x00e500eb,
	0x1b68, 0x00db00e0,
	0x1b6c, 0x00d100d5,
	0x1b70, 0x00c900cd,
	0x1b74, 0x00c200c5,
	0x1b78, 0x00bb00be,
	0x1b7c, 0x00b500b8,
	0x1bdc, 0x40F1FF81,
	0x1bdc, 0x40D6E383,
	0x1bdc, 0x40BFCA85,
	0x1bdc, 0x40AAB487,
	0x1bdc, 0x4098A189,
	0x1bdc, 0x40878F8B,
	0x1bdc, 0x4079808D,
	0x1bdc, 0x406B728F,
	0x1bdc, 0x40606591,
	0x1bdc, 0x40555A93,
	0x1bdc, 0x404C5195,
	0x1bdc, 0x40444897,
	0x1bdc, 0x403C4099,
	0x1bdc, 0x4036399B,
	0x1bdc, 0x4030339D,
	0x1bdc, 0x402B2D9F,
	0x1bdc, 0x402628A1,
	0x1bdc, 0x402224A3,
	0x1bdc, 0x401E20A5,
	0x1bdc, 0x401B1DA7,
	0x1bdc, 0x401819A9,
	0x1bdc, 0x401517AB,
	0x1bdc, 0x401314AD,
	0x1bdc, 0x401112AF,
	0x1bdc, 0x400F10B1,
	0x1bdc, 0x400E0EB3,
	0x1bdc, 0x400C0DB5,
	0x1bdc, 0x400B0BB7,
	0x1bdc, 0x400A0AB9,
	0x1bdc, 0x400909BB,
	0x1bdc, 0x400808BD,
	0x1bdc, 0x400707BF,
	0x1bdc, 0x400606C1,
	0x1bdc, 0x400506C3,
	0x1bdc, 0x400505C5,
	0x1bdc, 0x400405C7,
	0x1bdc, 0x400404C9,
	0x1bdc, 0x400304CB,
	0x1bdc, 0x400303CD,
	0x1bdc, 0x400303CF,
	0x1bdc, 0x400203D1,
	0x1bdc, 0x400202D3,
	0x1bdc, 0x400202D5,
	0x1bdc, 0x400202D7,
	0x1bdc, 0x400202D9,
	0x1bdc, 0x400101DB,
	0x1bdc, 0x400101DD,
	0x1bdc, 0x400101DF,
	0x1bdc, 0x400101E1,
	0x1bdc, 0x400101E3,
	0x1bdc, 0x400101E5,
	0x1bdc, 0x400101E7,
	0x1bdc, 0x400101E9,
	0x1bdc, 0x400101EB,
	0x1bdc, 0x400101ED,
	0x1bdc, 0x400101EF,
	0x1bdc, 0x400101F1,
	0x1bdc, 0x400101F3,
	0x1bdc, 0x400101F5,
	0x1bdc, 0x400101F7,
	0x1bdc, 0x400101F9,
	0x1bdc, 0x400101FB,
	0x1bdc, 0x400101FD,
	0x1bdc, 0x400101FF,
	0x1bdc, 0xd0000001,
	0x1bdc, 0xd0000003,
	0x1bdc, 0xd0000005,
	0x1bdc, 0xd0000007,
	0x1bdc, 0xd0000009,
	0x1bdc, 0xd000000b,
	0x1bdc, 0xd000000d,
	0x1bdc, 0xd000000f,
	0x1bdc, 0xd0000011,
	0x1bdc, 0xd0000013,
	0x1bdc, 0xd0000015,
	0x1bdc, 0xd0000017,
	0x1bdc, 0xd0000019,
	0x1bdc, 0xd000001b,
	0x1bdc, 0xd000001d,
	0x1bdc, 0xd000001f,
	0x1bdc, 0x90000081,
	0x1bdc, 0x90000083,
	0x1bdc, 0x90000085,
	0x1bdc, 0x90000087,
	0x1bdc, 0x90000089,
	0x1bdc, 0x9000008b,
	0x1bdc, 0x9000008d,
	0x1bdc, 0x9000008f,
	0x1bdc, 0x90000091,
	0x1bdc, 0x90000093,
	0x1bdc, 0x90000095,
	0x1bdc, 0x90000097,
	0x1bdc, 0x90000099,
	0x1bdc, 0x9000009b,
	0x1bdc, 0x9000009d,
	0x1bdc, 0x9000009f,
	0x1bdc, 0x00000000,
	0x1b00, 0x0000000A,
	0x1b00, 0x00A7000A,
	0x1b00, 0x0015000A,
	0x1b00, 0x0000000A,
	0x1b04, 0xE0462996,
	0x1b08, 0x00000080,
	0x1b0c, 0x00000000,
	0x1b10, 0x00010C00,
	0x1b14, 0x00000000,
	0x1b18, 0x00292903,
	0x1b1c, 0xA218FC32,
	0x1b20, 0x03040008,
	0x1b24, 0x00060008,
	0x1b28, 0x00060300,
	0x1b2C, 0x00180018,
	0x1b30, 0x20000000,
	0x1b34, 0x00000800,
	0x1b38, 0x20000000,
	0x1b3C, 0x20000000,
	0x1b8c, 0xFCFF4c20,
	0x1bcc, 0x11160200,
	0x1bc4, 0x001F001F,
	0x1bb8, 0x00000001,
	0x1bb8, 0x00000000,
	0x1bbc, 0x0000563F,
	0x1bdc, 0x40F1FF81,
	0x1bdc, 0x40D6E383,
	0x1bdc, 0x40BFCA85,
	0x1bdc, 0x40AAB487,
	0x1bdc, 0x4098A189,
	0x1bdc, 0x40878F8B,
	0x1bdc, 0x4079808D,
	0x1bdc, 0x406B728F,
	0x1bdc, 0x40606591,
	0x1bdc, 0x40555A93,
	0x1bdc, 0x404C5195,
	0x1bdc, 0x40444897,
	0x1bdc, 0x403C4099,
	0x1bdc, 0x4036399B,
	0x1bdc, 0x4030339D,
	0x1bdc, 0x402B2D9F,
	0x1bdc, 0x402628A1,
	0x1bdc, 0x402224A3,
	0x1bdc, 0x401E20A5,
	0x1bdc, 0x401B1DA7,
	0x1bdc, 0x401819A9,
	0x1bdc, 0x401517AB,
	0x1bdc, 0x401314AD,
	0x1bdc, 0x401112AF,
	0x1bdc, 0x400F10B1,
	0x1bdc, 0x400E0EB3,
	0x1bdc, 0x400C0DB5,
	0x1bdc, 0x400B0BB7,
	0x1bdc, 0x400A0AB9,
	0x1bdc, 0x400909BB,
	0x1bdc, 0x400808BD,
	0x1bdc, 0x400707BF,
	0x1bdc, 0x400606C1,
	0x1bdc, 0x400506C3,
	0x1bdc, 0x400505C5,
	0x1bdc, 0x400405C7,
	0x1bdc, 0x400404C9,
	0x1bdc, 0x400304CB,
	0x1bdc, 0x400303CD,
	0x1bdc, 0x400303CF,
	0x1bdc, 0x400203D1,
	0x1bdc, 0x400202D3,
	0x1bdc, 0x400202D5,
	0x1bdc, 0x400202D7,
	0x1bdc, 0x400202D9,
	0x1bdc, 0x400101DB,
	0x1bdc, 0x400101DD,
	0x1bdc, 0x400101DF,
	0x1bdc, 0x400101E1,
	0x1bdc, 0x400101E3,
	0x1bdc, 0x400101E5,
	0x1bdc, 0x400101E7,
	0x1bdc, 0x400101E9,
	0x1bdc, 0x400101EB,
	0x1bdc, 0x400101ED,
	0x1bdc, 0x400101EF,
	0x1bdc, 0x400101F1,
	0x1bdc, 0x400101F3,
	0x1bdc, 0x400101F5,
	0x1bdc, 0x400101F7,
	0x1bdc, 0x400101F9,
	0x1bdc, 0x400101FB,
	0x1bdc, 0x400101FD,
	0x1bdc, 0x400101FF,
	0x1bdc, 0xd0000001,
	0x1bdc, 0xd0000003,
	0x1bdc, 0xd0000005,
	0x1bdc, 0xd0000007,
	0x1bdc, 0xd0000009,
	0x1bdc, 0xd000000b,
	0x1bdc, 0xd000000d,
	0x1bdc, 0xd000000f,
	0x1bdc, 0xd0000011,
	0x1bdc, 0xd0000013,
	0x1bdc, 0xd0000015,
	0x1bdc, 0xd0000017,
	0x1bdc, 0xd0000019,
	0x1bdc, 0xd000001b,
	0x1bdc, 0xd000001d,
	0x1bdc, 0xd000001f,
	0x1bdc, 0x90000081,
	0x1bdc, 0x90000083,
	0x1bdc, 0x90000085,
	0x1bdc, 0x90000087,
	0x1bdc, 0x90000089,
	0x1bdc, 0x9000008b,
	0x1bdc, 0x9000008d,
	0x1bdc, 0x9000008f,
	0x1bdc, 0x90000091,
	0x1bdc, 0x90000093,
	0x1bdc, 0x90000095,
	0x1bdc, 0x90000097,
	0x1bdc, 0x90000099,
	0x1bdc, 0x9000009b,
	0x1bdc, 0x9000009d,
	0x1bdc, 0x9000009f,
	0x1bdc, 0x00000000,
};
#endif

void odm_read_and_config_mp_8197g_cal_init(void *dm_void)
{
#if 1
	struct dm_struct *dm = (struct dm_struct *)dm_void;
	struct dm_dpk_info *dpk_info = &dm->dpk_info;

	u32	i = 0;
	u32	array_len = sizeof(array_mp_8197g_cal_init)/sizeof(u32);
	u32	*array = array_mp_8197g_cal_init;
	u32	v1 = 0, v2 = 0;

	odm_set_bb_reg(dm, R_0x1cd0, BIT(28), 0x1);// r_iqk_dpk_clock_src
	odm_set_bb_reg(dm, R_0x1cd0, BIT(29), 0x1);// r_iqk_dpk_reset_src
	odm_set_bb_reg(dm, R_0x1cd0, BIT(30), 0x1);// r_en_IOQ_iqk_dpk
	odm_set_bb_reg(dm, R_0x1cd0, BIT(31), 0x0);// r_tst_iqk2set_src

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];
		odm_config_bb_phy_8197g(dm, v1, MASKDWORD, v2);		
		RF_DBG(dm, DBG_RF_IQK, "v1 = 0x%x, v2 = 0x%x \n",v1,v2);
		i = i + 2;
	}

	dpk_info->is_dpk_enable = 1;
	dpk_info->is_dpk_by_channel = 1;
#endif
}

#endif
