/******************************************************************************
 *
 * Copyright(c) 2007 - 2017 Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 *****************************************************************************/

#include "mp_precomp.h"
#if (DM_ODM_SUPPORT_TYPE == 0x08)
#if RT_PLATFORM == PLATFORM_MACOSX
#include "phydm_precomp.h"
#else
#include "../phydm_precomp.h"
#endif
#else
#include "../../phydm_precomp.h"
#endif

#if (RTL8723F_SUPPORT == 1)

u32 array_mp_8723f_cal_init[] = {
	0x1cd0, 0x7f000000,
	0x1b80, 0x00000004, /*enable access page 1b register*/
	0x1b00, 0x00000008,
	0x1b08, 0x00000080, //00
	/*NBIQK PHY SETTING*/
	0x1b04, 0xF0862966,
	0x1b0c, 0x78000000,
	0x1b10, 0x88013100,
	0x1b14, 0x00010100,
	0x1b18, 0x10010100,
	0x1b1c, 0xA2103C00,
	0x1b20, 0x000403E0, //0x030403E0
	0x1b24, 0x00072160,
	0x1b28, 0x00180e00,
	0x1b30, 0x0000ff09,
	0x1b34, 0x56440834,
	0x1b38, 0x20000003,
	0x1b3c, 0x20000000,
	0x1b38, 0x20000001,
	0x1b3c, 0x20000000,
	0x1b34, 0x5644081c,
	0x1b38, 0x20000003,
	0x1b3c, 0x20000000,
	0x1b38, 0x20000001,
	0x1b3c, 0x20000000,
	0x1bc0, 0x0010001F,
	0x1be4, 0xf0000003,
	0x1bd0, 0x80006143,
	0x1bd0, 0x00006143,
	0x1bc0, 0x0010201f,
	0x1bd0, 0x80008585,
	0x1bd0, 0x00008585,
	0x1bb8, 0x00000000,
	/*DPK PHY setting 0623*/
	0x1b8c, 0xfcff4c00, /*gainloss + lut table sel off*/
	0x1b90, 0x0105f018,
	0x1b94, 0xf76d9f84,
	0x1bc8, 0x000c5599,
	0x1bcc, 0x11160300, /*[11:6]LMS thr 0x8->0xc */
	0x1bd8, 0x00000000, /*RXSRAM control*/
	0x1bf8, 0x00000080, /*auto cal mean_phase_val*/
	0x1be0, 0x20000000, /*bypass RX DC_i/q*/
	/*set pwsf_k table*/
	0x1bc4, 0x00190019,
	0x1bb8, 0x00000001,
	0x1bb8, 0x00000000,
	0x1bbc, 0x00097e5f, /*TXAGC_boundary: ant1: 1F; 12;ant0: 1F ; 12;*/
	/*tx_amp*/
	0x1b98, 0x41382e21,
	0x1b9c, 0x5b554f48,
	0x1ba0, 0x6f6b6661,
	0x1ba4, 0x817d7874,
	0x1ba8, 0x908c8884,
	0x1bac, 0x9d9a9793,
	0x1bb0, 0xaaa7a4a1,
	0x1bb4, 0xb6b3b0ad,
	/*tx_inverse*/
	0x1b40, 0x02ce03e9,
	0x1b44, 0x01fd0249,
	0x1b48, 0x01a101c9,
	0x1b4c, 0x016a0181,
	0x1b50, 0x01430155,
	0x1b54, 0x01270135,
	0x1b58, 0x0112011c,
	0x1b5c, 0x01000108,
	0x1b60, 0x00f100f8,
	0x1b64, 0x00e500eb,
	0x1b68, 0x00db00e0,
	0x1b6c, 0x00d100d5,
	0x1b70, 0x00c900cd,
	0x1b74, 0x00c200c5,
	0x1b78, 0x00bb00be,
	0x1b7c, 0x00b500b8,
	/*PWSF_SRAM_write 0.125dB*/
	0x1bdc, 0x00000000,
	0x1bdc, 0x40070181,
	0x1bdc, 0x40070783,
	0x1bdc, 0x40080785,
	0x1bdc, 0x40080887,
	0x1bdc, 0x40090889,
	0x1bdc, 0x4009098B,
	0x1bdc, 0x400A098D,
	0x1bdc, 0x400A0A8F,
	0x1bdc, 0x400B0A91,
	0x1bdc, 0x400B0B93,
	0x1bdc, 0x400C0C95,
	0x1bdc, 0x400D0C97,
	0x1bdc, 0x400E0D99,
	0x1bdc, 0x400E0E9B,
	0x1bdc, 0x400F0F9D,
	0x1bdc, 0x4010109F,
	0x1bdc, 0x401111A1,
	0x1bdc, 0x401212A3,
	0x1bdc, 0x401313A5,
	0x1bdc, 0x401414A7,
	0x1bdc, 0x401515A9,
	0x1bdc, 0x401716AB,
	0x1bdc, 0x401817AD,
	0x1bdc, 0x401919AF,
	0x1bdc, 0x401B1AB1,
	0x1bdc, 0x401D1CB3,
	0x1bdc, 0x401E1DB5,
	0x1bdc, 0x40201FB7,
	0x1bdc, 0x402221B9,
	0x1bdc, 0x402423BB,
	0x1bdc, 0x402625BD,
	0x1bdc, 0x402827BF,
	0x1bdc, 0x402B2AC1,
	0x1bdc, 0x402D2CC3,
	0x1bdc, 0x40302FC5,
	0x1bdc, 0x403331C7,
	0x1bdc, 0x403634C9,
	0x1bdc, 0x403937CB,
	0x1bdc, 0x403C3BCD,
	0x1bdc, 0x40403ECF,
	0x1bdc, 0x404442D1,
	0x1bdc, 0x404846D3,
	0x1bdc, 0x404C4AD5,
	0x1bdc, 0x40514ED7,
	0x1bdc, 0x405553D9,
	0x1bdc, 0x405A58DB,
	0x1bdc, 0x40605DDD,
	0x1bdc, 0x406563DF,
	0x1bdc, 0x406B68E1,
	0x1bdc, 0x40726FE3,
	0x1bdc, 0x407975E5,
	0x1bdc, 0x40807CE7,
	0x1bdc, 0x408783E9,
	0x1bdc, 0x408F8BEB,
	0x1bdc, 0x409893ED,
	0x1bdc, 0x40A19CEF,
	0x1bdc, 0x40AAA5F1,
	0x1bdc, 0x40B4AFF3,
	0x1bdc, 0x40BFBAF5,
	0x1bdc, 0x40CAC5F7,
	0x1bdc, 0x40D6D0F9,
	0x1bdc, 0x40E3DDFB,
	0x1bdc, 0x40F1EAFD,
	0x1bdc, 0x40FFF8FF,
	0x1bdc, 0x00000000,
	/*clear even*/
	0x1bdc, 0xd0000001,
	0x1bdc, 0xd0000003,
	0x1bdc, 0xd0000005,
	0x1bdc, 0xd0000007,
	0x1bdc, 0xd0000009,
	0x1bdc, 0xd000000b,
	0x1bdc, 0xd000000d,
	0x1bdc, 0xd000000f,
	0x1bdc, 0xd0000011,
	0x1bdc, 0xd0000013,
	0x1bdc, 0xd0000015,
	0x1bdc, 0xd0000017,
	0x1bdc, 0xd0000019,
	0x1bdc, 0xd000001b,
	0x1bdc, 0xd000001d,
	0x1bdc, 0xd000001f,
	0x1bdc, 0xd0000021,
	0x1bdc, 0xd0000023,
	0x1bdc, 0xd0000025,
	0x1bdc, 0xd0000027,
	0x1bdc, 0xd0000029,
	0x1bdc, 0xd000002b,
	0x1bdc, 0xd000002d,
	0x1bdc, 0xd000002f,
	0x1bdc, 0xd0000031,
	0x1bdc, 0xd0000033,
	0x1bdc, 0xd0000035,
	0x1bdc, 0xd0000037,
	0x1bdc, 0xd0000039,
	0x1bdc, 0xd000003b,
	0x1bdc, 0xd000003d,
	0x1bdc, 0xd000003f,
	/*clear odd*/
	0x1bdc, 0x90000081,
	0x1bdc, 0x90000083,
	0x1bdc, 0x90000085,
	0x1bdc, 0x90000087,
	0x1bdc, 0x90000089,
	0x1bdc, 0x9000008b,
	0x1bdc, 0x9000008d,
	0x1bdc, 0x9000008f,
	0x1bdc, 0x90000091,
	0x1bdc, 0x90000093,
	0x1bdc, 0x90000095,
	0x1bdc, 0x90000097,
	0x1bdc, 0x90000099,
	0x1bdc, 0x9000009b,
	0x1bdc, 0x9000009d,
	0x1bdc, 0x9000009f,
	0x1bdc, 0x900000a1,
	0x1bdc, 0x900000a3,
	0x1bdc, 0x900000a5,
	0x1bdc, 0x900000a7,
	0x1bdc, 0x900000a9,
	0x1bdc, 0x900000ab,
	0x1bdc, 0x900000ad,
	0x1bdc, 0x900000af,
	0x1bdc, 0x900000b1,
	0x1bdc, 0x900000b3,
	0x1bdc, 0x900000b5,
	0x1bdc, 0x900000b7,
	0x1bdc, 0x900000b9,
	0x1bdc, 0x900000bb,
	0x1bdc, 0x900000bd,
	0x1bdc, 0x900000bf,
	0x1bdc, 0x00000000,
	/*NCTL setting 20201021*/
	0x1b00, 0x00000008,
	0x1b80, 0x00000007,
	0x1b80, 0x090a0005,
	0x1b80, 0x090a0007,
	0x1b80, 0x0ffe0015,
	0x1b80, 0x0ffe0017,
	0x1b80, 0x00220025,
	0x1b80, 0x00220027,
	0x1b80, 0x00040035,
	0x1b80, 0x00040037,
	0x1b80, 0x05c00045,
	0x1b80, 0x05c00047,
	0x1b80, 0x00020055,
	0x1b80, 0x00020057,
	0x1b80, 0x00040065,
	0x1b80, 0x00040067,
	0x1b80, 0x73000075,
	0x1b80, 0x73000077,
	0x1b80, 0x00080085,
	0x1b80, 0x00080087,
	0x1b80, 0x80000095,
	0x1b80, 0x80000097,
	0x1b80, 0x090800a5,
	0x1b80, 0x090800a7,
	0x1b80, 0x0f0200b5,
	0x1b80, 0x0f0200b7,
	0x1b80, 0x002200c5,
	0x1b80, 0x002200c7,
	0x1b80, 0x000400d5,
	0x1b80, 0x000400d7,
	0x1b80, 0x05c000e5,
	0x1b80, 0x05c000e7,
	0x1b80, 0x000200f5,
	0x1b80, 0x000200f7,
	0x1b80, 0x00040105,
	0x1b80, 0x00040107,
	0x1b80, 0x73010115,
	0x1b80, 0x73010117,
	0x1b80, 0x00040125,
	0x1b80, 0x00040127,
	0x1b80, 0x4a000135,
	0x1b80, 0x4a000137,
	0x1b80, 0x4b040145,
	0x1b80, 0x4b040147,
	0x1b80, 0x86040155,
	0x1b80, 0x86040157,
	0x1b80, 0x40090165,
	0x1b80, 0x40090167,
	0x1b80, 0x78010175,
	0x1b80, 0x78010177,
	0x1b80, 0xe0240185,
	0x1b80, 0xe0240187,
	0x1b80, 0x4b050195,
	0x1b80, 0x4b050197,
	0x1b80, 0x870401a5,
	0x1b80, 0x870401a7,
	0x1b80, 0x400b01b5,
	0x1b80, 0x400b01b7,
	0x1b80, 0x780301c5,
	0x1b80, 0x780301c7,
	0x1b80, 0xe02401d5,
	0x1b80, 0xe02401d7,
	0x1b80, 0x4b0001e5,
	0x1b80, 0x4b0001e7,
	0x1b80, 0x000701f5,
	0x1b80, 0x000701f7,
	0x1b80, 0x4c000205,
	0x1b80, 0x4c000207,
	0x1b80, 0x00040215,
	0x1b80, 0x00040217,
	0x1b80, 0x50550225,
	0x1b80, 0x50550227,
	0x1b80, 0x30000235,
	0x1b80, 0x30000237,
	0x1b80, 0xa5090245,
	0x1b80, 0xa5090247,
	0x1b80, 0xe1d10255,
	0x1b80, 0xe1d10257,
	0x1b80, 0xf00c0265,
	0x1b80, 0xf00c0267,
	0x1b80, 0xf10c0275,
	0x1b80, 0xf10c0277,
	0x1b80, 0xf20c0285,
	0x1b80, 0xf20c0287,
	0x1b80, 0xf30c0295,
	0x1b80, 0xf30c0297,
	0x1b80, 0xf40c02a5,
	0x1b80, 0xf40c02a7,
	0x1b80, 0xf50c02b5,
	0x1b80, 0xf50c02b7,
	0x1b80, 0xf60c02c5,
	0x1b80, 0xf60c02c7,
	0x1b80, 0xf10c02d5,
	0x1b80, 0xf10c02d7,
	0x1b80, 0xf20c02e5,
	0x1b80, 0xf20c02e7,
	0x1b80, 0xf30c02f5,
	0x1b80, 0xf30c02f7,
	0x1b80, 0xf40c0305,
	0x1b80, 0xf40c0307,
	0x1b80, 0x00010315,
	0x1b80, 0x00010317,
	0x1b80, 0x303d0325,
	0x1b80, 0x303d0327,
	0x1b80, 0x306b0335,
	0x1b80, 0x306b0337,
	0x1b80, 0x30830345,
	0x1b80, 0x30830347,
	0x1b80, 0x30860355,
	0x1b80, 0x30860357,
	0x1b80, 0x308b0365,
	0x1b80, 0x308b0367,
	0x1b80, 0x308d0375,
	0x1b80, 0x308d0377,
	0x1b80, 0x30b60385,
	0x1b80, 0x30b60387,
	0x1b80, 0x30b90395,
	0x1b80, 0x30b90397,
	0x1b80, 0x30c803a5,
	0x1b80, 0x30c803a7,
	0x1b80, 0x30d203b5,
	0x1b80, 0x30d203b7,
	0x1b80, 0x30eb03c5,
	0x1b80, 0x30eb03c7,
	0x1b80, 0x7f2003d5,
	0x1b80, 0x7f2003d7,
	0x1b80, 0x7e0003e5,
	0x1b80, 0x7e0003e7,
	0x1b80, 0x7d0003f5,
	0x1b80, 0x7d0003f7,
	0x1b80, 0x5b100405,
	0x1b80, 0x5b100407,
	0x1b80, 0x4d040415,
	0x1b80, 0x4d040417,
	0x1b80, 0x20980425,
	0x1b80, 0x20980427,
	0x1b80, 0x02000435,
	0x1b80, 0x02000437,
	0x1b80, 0xe1b00445,
	0x1b80, 0xe1b00447,
	0x1b80, 0xe1c80455,
	0x1b80, 0xe1c80457,
	0x1b80, 0x20800465,
	0x1b80, 0x20800467,
	0x1b80, 0x00000475,
	0x1b80, 0x00000477,
	0x1b80, 0xe1b00485,
	0x1b80, 0xe1b00487,
	0x1b80, 0xe1c80495,
	0x1b80, 0xe1c80497,
	0x1b80, 0x4d0804a5,
	0x1b80, 0x4d0804a7,
	0x1b80, 0x550704b5,
	0x1b80, 0x550704b7,
	0x1b80, 0xe10304c5,
	0x1b80, 0xe10304c7,
	0x1b80, 0x4d0404d5,
	0x1b80, 0x4d0404d7,
	0x1b80, 0x208804e5,
	0x1b80, 0x208804e7,
	0x1b80, 0x020004f5,
	0x1b80, 0x020004f7,
	0x1b80, 0xe1b00505,
	0x1b80, 0xe1b00507,
	0x1b80, 0xe1c80515,
	0x1b80, 0xe1c80517,
	0x1b80, 0x4d080525,
	0x1b80, 0x4d080527,
	0x1b80, 0x55170535,
	0x1b80, 0x55170537,
	0x1b80, 0xe1030545,
	0x1b80, 0xe1030547,
	0x1b80, 0x4f020555,
	0x1b80, 0x4f020557,
	0x1b80, 0x4e000565,
	0x1b80, 0x4e000567,
	0x1b80, 0x53020575,
	0x1b80, 0x53020577,
	0x1b80, 0x52010585,
	0x1b80, 0x52010587,
	0x1b80, 0xe1090595,
	0x1b80, 0xe1090597,
	0x1b80, 0x750805a5,
	0x1b80, 0x750805a7,
	0x1b80, 0x730105b5,
	0x1b80, 0x730105b7,
	0x1b80, 0x4d0805c5,
	0x1b80, 0x4d0805c7,
	0x1b80, 0x571005d5,
	0x1b80, 0x571005d7,
	0x1b80, 0x571005e5,
	0x1b80, 0x571005e7,
	0x1b80, 0x571005f5,
	0x1b80, 0x571005f7,
	0x1b80, 0x57000605,
	0x1b80, 0x57000607,
	0x1b80, 0xe1b00615,
	0x1b80, 0xe1b00617,
	0x1b80, 0xe1c80625,
	0x1b80, 0xe1c80627,
	0x1b80, 0x75eb0635,
	0x1b80, 0x75eb0637,
	0x1b80, 0x4d040645,
	0x1b80, 0x4d040647,
	0x1b80, 0x2eb00655,
	0x1b80, 0x2eb00657,
	0x1b80, 0x00000665,
	0x1b80, 0x00000667,
	0x1b80, 0xe1b00675,
	0x1b80, 0xe1b00677,
	0x1b80, 0xe1c80685,
	0x1b80, 0xe1c80687,
	0x1b80, 0x4d080695,
	0x1b80, 0x4d080697,
	0x1b80, 0x000106a5,
	0x1b80, 0x000106a7,
	0x1b80, 0x5b1006b5,
	0x1b80, 0x5b1006b7,
	0x1b80, 0x4d0406c5,
	0x1b80, 0x4d0406c7,
	0x1b80, 0x209006d5,
	0x1b80, 0x209006d7,
	0x1b80, 0x000006e5,
	0x1b80, 0x000006e7,
	0x1b80, 0xe1b006f5,
	0x1b80, 0xe1b006f7,
	0x1b80, 0xe1c80705,
	0x1b80, 0xe1c80707,
	0x1b80, 0x4d080715,
	0x1b80, 0x4d080717,
	0x1b80, 0x55070725,
	0x1b80, 0x55070727,
	0x1b80, 0xe1030735,
	0x1b80, 0xe1030737,
	0x1b80, 0x4d040745,
	0x1b80, 0x4d040747,
	0x1b80, 0x20980755,
	0x1b80, 0x20980757,
	0x1b80, 0x02000765,
	0x1b80, 0x02000767,
	0x1b80, 0xe1b00775,
	0x1b80, 0xe1b00777,
	0x1b80, 0xe1c80785,
	0x1b80, 0xe1c80787,
	0x1b80, 0x4d080795,
	0x1b80, 0x4d080797,
	0x1b80, 0x551707a5,
	0x1b80, 0x551707a7,
	0x1b80, 0xe10307b5,
	0x1b80, 0xe10307b7,
	0x1b80, 0x4f0207c5,
	0x1b80, 0x4f0207c7,
	0x1b80, 0x4e0007d5,
	0x1b80, 0x4e0007d7,
	0x1b80, 0x530207e5,
	0x1b80, 0x530207e7,
	0x1b80, 0x520107f5,
	0x1b80, 0x520107f7,
	0x1b80, 0xe1090805,
	0x1b80, 0xe1090807,
	0x1b80, 0x75090815,
	0x1b80, 0x75090817,
	0x1b80, 0x305b0825,
	0x1b80, 0x305b0827,
	0x1b80, 0xe1130835,
	0x1b80, 0xe1130837,
	0x1b80, 0x63000845,
	0x1b80, 0x63000847,
	0x1b80, 0x00010855,
	0x1b80, 0x00010857,
	0x1b80, 0x5b300865,
	0x1b80, 0x5b300867,
	0x1b80, 0x55000875,
	0x1b80, 0x55000877,
	0x1b80, 0x4d000885,
	0x1b80, 0x4d000887,
	0x1b80, 0xe1030895,
	0x1b80, 0xe1030897,
	0x1b80, 0x000108a5,
	0x1b80, 0x000108a7,
	0x1b80, 0xe18908b5,
	0x1b80, 0xe18908b7,
	0x1b80, 0x000108c5,
	0x1b80, 0x000108c7,
	0x1b80, 0x000708d5,
	0x1b80, 0x000708d7,
	0x1b80, 0x745c08e5,
	0x1b80, 0x745c08e7,
	0x1b80, 0x722008f5,
	0x1b80, 0x722008f7,
	0x1b80, 0x72000905,
	0x1b80, 0x72000907,
	0x1b80, 0x00040915,
	0x1b80, 0x00040917,
	0x1b80, 0x55010925,
	0x1b80, 0x55010927,
	0x1b80, 0x5b400935,
	0x1b80, 0x5b400937,
	0x1b80, 0x5c310945,
	0x1b80, 0x5c310947,
	0x1b80, 0x5fa20955,
	0x1b80, 0x5fa20957,
	0x1b80, 0x66050965,
	0x1b80, 0x66050967,
	0x1b80, 0x08010975,
	0x1b80, 0x08010977,
	0x1b80, 0x09000985,
	0x1b80, 0x09000987,
	0x1b80, 0x0a010995,
	0x1b80, 0x0a010997,
	0x1b80, 0x0b4009a5,
	0x1b80, 0x0b4009a7,
	0x1b80, 0x0d0009b5,
	0x1b80, 0x0d0009b7,
	0x1b80, 0x0c0109c5,
	0x1b80, 0x0c0109c7,
	0x1b80, 0x002a09d5,
	0x1b80, 0x002a09d7,
	0x1b80, 0x000409e5,
	0x1b80, 0x000409e7,
	0x1b80, 0x7f2009f5,
	0x1b80, 0x7f2009f7,
	0x1b80, 0x00070a05,
	0x1b80, 0x00070a07,
	0x1b80, 0x05720a15,
	0x1b80, 0x05720a17,
	0x1b80, 0x05330a25,
	0x1b80, 0x05330a27,
	0x1b80, 0x96040a35,
	0x1b80, 0x96040a37,
	0x1b80, 0xe1a60a45,
	0x1b80, 0xe1a60a47,
	0x1b80, 0x00040a55,
	0x1b80, 0x00040a57,
	0x1b80, 0xe1030a65,
	0x1b80, 0xe1030a67,
	0x1b80, 0x7f210a75,
	0x1b80, 0x7f210a77,
	0x1b80, 0x00070a85,
	0x1b80, 0x00070a87,
	0x1b80, 0x06320a95,
	0x1b80, 0x06320a97,
	0x1b80, 0x07330aa5,
	0x1b80, 0x07330aa7,
	0x1b80, 0x96060ab5,
	0x1b80, 0x96060ab7,
	0x1b80, 0xe1a60ac5,
	0x1b80, 0xe1a60ac7,
	0x1b80, 0x00040ad5,
	0x1b80, 0x00040ad7,
	0x1b80, 0xe1030ae5,
	0x1b80, 0xe1030ae7,
	0x1b80, 0x00070af5,
	0x1b80, 0x00070af7,
	0x1b80, 0xe19e0b05,
	0x1b80, 0xe19e0b07,
	0x1b80, 0x00020b15,
	0x1b80, 0x00020b17,
	0x1b80, 0xe1a20b25,
	0x1b80, 0xe1a20b27,
	0x1b80, 0x00040b35,
	0x1b80, 0x00040b37,
	0x1b80, 0x5f820b45,
	0x1b80, 0x5f820b47,
	0x1b80, 0x00010b55,
	0x1b80, 0x00010b57,
	0x1b80, 0x00070b65,
	0x1b80, 0x00070b67,
	0x1b80, 0x745e0b75,
	0x1b80, 0x745e0b77,
	0x1b80, 0x308f0b85,
	0x1b80, 0x308f0b87,
	0x1b80, 0x00040b95,
	0x1b80, 0x00040b97,
	0x1b80, 0x63000ba5,
	0x1b80, 0x63000ba7,
	0x1b80, 0x00070bb5,
	0x1b80, 0x00070bb7,
	0x1b80, 0x4e160bc5,
	0x1b80, 0x4e160bc7,
	0x1b80, 0x4f110bd5,
	0x1b80, 0x4f110bd7,
	0x1b80, 0x00060be5,
	0x1b80, 0x00060be7,
	0x1b80, 0x57f70bf5,
	0x1b80, 0x57f70bf7,
	0x1b80, 0x4b000c05,
	0x1b80, 0x4b000c07,
	0x1b80, 0x4b010c15,
	0x1b80, 0x4b010c17,
	0x1b80, 0x4b000c25,
	0x1b80, 0x4b000c27,
	0x1b80, 0x00040c35,
	0x1b80, 0x00040c37,
	0x1b80, 0x93000c45,
	0x1b80, 0x93000c47,
	0x1b80, 0xb0300c55,
	0x1b80, 0xb0300c57,
	0x1b80, 0x30c80c65,
	0x1b80, 0x30c80c67,
	0x1b80, 0x00010c75,
	0x1b80, 0x00010c77,
	0x1b80, 0x00070c85,
	0x1b80, 0x00070c87,
	0x1b80, 0x4e160c95,
	0x1b80, 0x4e160c97,
	0x1b80, 0x4f110ca5,
	0x1b80, 0x4f110ca7,
	0x1b80, 0x00060cb5,
	0x1b80, 0x00060cb7,
	0x1b80, 0x44000cc5,
	0x1b80, 0x44000cc7,
	0x1b80, 0x44800cd5,
	0x1b80, 0x44800cd7,
	0x1b80, 0x44000ce5,
	0x1b80, 0x44000ce7,
	0x1b80, 0x00040cf5,
	0x1b80, 0x00040cf7,
	0x1b80, 0x8d000d05,
	0x1b80, 0x8d000d07,
	0x1b80, 0x00010d15,
	0x1b80, 0x00010d17,
	0x1b80, 0x00060d25,
	0x1b80, 0x00060d27,
	0x1b80, 0x50b80d35,
	0x1b80, 0x50b80d37,
	0x1b80, 0x51e00d45,
	0x1b80, 0x51e00d47,
	0x1b80, 0x520d0d55,
	0x1b80, 0x520d0d57,
	0x1b80, 0x53020d65,
	0x1b80, 0x53020d67,
	0x1b80, 0x57f70d75,
	0x1b80, 0x57f70d77,
	0x1b80, 0x00070d85,
	0x1b80, 0x00070d87,
	0x1b80, 0x7b000d95,
	0x1b80, 0x7b000d97,
	0x1b80, 0x4a000da5,
	0x1b80, 0x4a000da7,
	0x1b80, 0x4c3f0db5,
	0x1b80, 0x4c3f0db7,
	0x1b80, 0x4e840dc5,
	0x1b80, 0x4e840dc7,
	0x1b80, 0x4f030dd5,
	0x1b80, 0x4f030dd7,
	0x1b80, 0x00040de5,
	0x1b80, 0x00040de7,
	0x1b80, 0x63010df5,
	0x1b80, 0x63010df7,
	0x1b80, 0x74000e05,
	0x1b80, 0x74000e07,
	0x1b80, 0x74020e15,
	0x1b80, 0x74020e17,
	0x1b80, 0x74000e25,
	0x1b80, 0x74000e27,
	0x1b80, 0x8b000e35,
	0x1b80, 0x8b000e37,
	0x1b80, 0xab000e45,
	0x1b80, 0xab000e47,
	0x1b80, 0xaa100e55,
	0x1b80, 0xaa100e57,
	0x1b80, 0x00070e65,
	0x1b80, 0x00070e67,
	0x1b80, 0x4c000e75,
	0x1b80, 0x4c000e77,
	0x1b80, 0x00040e85,
	0x1b80, 0x00040e87,
	0x1b80, 0x63000e95,
	0x1b80, 0x63000e97,
	0x1b80, 0x00010ea5,
	0x1b80, 0x00010ea7,
	0x1b80, 0x00060eb5,
	0x1b80, 0x00060eb7,
	0x1b80, 0x57770ec5,
	0x1b80, 0x57770ec7,
	0x1b80, 0x50180ed5,
	0x1b80, 0x50180ed7,
	0x1b80, 0x00070ee5,
	0x1b80, 0x00070ee7,
	0x1b80, 0x4b000ef5,
	0x1b80, 0x4b000ef7,
	0x1b80, 0x4e020f05,
	0x1b80, 0x4e020f07,
	0x1b80, 0x4f110f15,
	0x1b80, 0x4f110f17,
	0x1b80, 0x00040f25,
	0x1b80, 0x00040f27,
	0x1b80, 0x63050f35,
	0x1b80, 0x63050f37,
	0x1b80, 0x00010f45,
	0x1b80, 0x00010f47,
	0x1b80, 0x301f0f55,
	0x1b80, 0x301f0f57,
	0x1b80, 0x00010f65,
	0x1b80, 0x00010f67,
	0x1b80, 0x7b240f75,
	0x1b80, 0x7b240f77,
	0x1b80, 0x7a400f85,
	0x1b80, 0x7a400f87,
	0x1b80, 0x79000f95,
	0x1b80, 0x79000f97,
	0x1b80, 0x55030fa5,
	0x1b80, 0x55030fa7,
	0x1b80, 0x31030fb5,
	0x1b80, 0x31030fb7,
	0x1b80, 0x7b1c0fc5,
	0x1b80, 0x7b1c0fc7,
	0x1b80, 0x7a400fd5,
	0x1b80, 0x7a400fd7,
	0x1b80, 0x55130fe5,
	0x1b80, 0x55130fe7,
	0x1b80, 0x31030ff5,
	0x1b80, 0x31030ff7,
	0x1b80, 0x7b201005,
	0x1b80, 0x7b201007,
	0x1b80, 0x7a001015,
	0x1b80, 0x7a001017,
	0x1b80, 0x55231025,
	0x1b80, 0x55231027,
	0x1b80, 0x74011035,
	0x1b80, 0x74011037,
	0x1b80, 0x74011045,
	0x1b80, 0x74011047,
	0x1b80, 0x74011055,
	0x1b80, 0x74011057,
	0x1b80, 0x74001065,
	0x1b80, 0x74001067,
	0x1b80, 0x8e001075,
	0x1b80, 0x8e001077,
	0x1b80, 0x00011085,
	0x1b80, 0x00011087,
	0x1b80, 0x57021095,
	0x1b80, 0x57021097,
	0x1b80, 0x570210a5,
	0x1b80, 0x570210a7,
	0x1b80, 0x570210b5,
	0x1b80, 0x570210b7,
	0x1b80, 0x570010c5,
	0x1b80, 0x570010c7,
	0x1b80, 0x970010d5,
	0x1b80, 0x970010d7,
	0x1b80, 0x000110e5,
	0x1b80, 0x000110e7,
	0x1b80, 0x561110f5,
	0x1b80, 0x561110f7,
	0x1b80, 0x56011105,
	0x1b80, 0x56011107,
	0x1b80, 0x8c001115,
	0x1b80, 0x8c001117,
	0x1b80, 0x00011125,
	0x1b80, 0x00011127,
	0x1b80, 0x7f201135,
	0x1b80, 0x7f201137,
	0x1b80, 0x7e001145,
	0x1b80, 0x7e001147,
	0x1b80, 0x7d001155,
	0x1b80, 0x7d001157,
	0x1b80, 0x4f781165,
	0x1b80, 0x4f781167,
	0x1b80, 0x4e001175,
	0x1b80, 0x4e001177,
	0x1b80, 0x53881185,
	0x1b80, 0x53881187,
	0x1b80, 0x52011195,
	0x1b80, 0x52011197,
	0x1b80, 0x5b2011a5,
	0x1b80, 0x5b2011a7,
	0x1b80, 0xe16911b5,
	0x1b80, 0xe16911b7,
	0x1b80, 0xe16011c5,
	0x1b80, 0xe16011c7,
	0x1b80, 0xe16911d5,
	0x1b80, 0xe16911d7,
	0x1b80, 0xe16311e5,
	0x1b80, 0xe16311e7,
	0x1b80, 0x5c0111f5,
	0x1b80, 0x5c0111f7,
	0x1b80, 0xe1661205,
	0x1b80, 0xe1661207,
	0x1b80, 0x54a21215,
	0x1b80, 0x54a21217,
	0x1b80, 0x5c021225,
	0x1b80, 0x5c021227,
	0x1b80, 0xe1691235,
	0x1b80, 0xe1691237,
	0x1b80, 0xe1601245,
	0x1b80, 0xe1601247,
	0x1b80, 0xe1691255,
	0x1b80, 0xe1691257,
	0x1b80, 0xe1631265,
	0x1b80, 0xe1631267,
	0x1b80, 0x5c011275,
	0x1b80, 0x5c011277,
	0x1b80, 0xe1661285,
	0x1b80, 0xe1661287,
	0x1b80, 0x54a61295,
	0x1b80, 0x54a61297,
	0x1b80, 0x54c212a5,
	0x1b80, 0x54c212a7,
	0x1b80, 0x54a312b5,
	0x1b80, 0x54a312b7,
	0x1b80, 0x54c612c5,
	0x1b80, 0x54c612c7,
	0x1b80, 0x54a412d5,
	0x1b80, 0x54a412d7,
	0x1b80, 0xe16612e5,
	0x1b80, 0xe16612e7,
	0x1b80, 0x54a012f5,
	0x1b80, 0x54a012f7,
	0x1b80, 0x5c021305,
	0x1b80, 0x5c021307,
	0x1b80, 0xe1691315,
	0x1b80, 0xe1691317,
	0x1b80, 0xe1601325,
	0x1b80, 0xe1601327,
	0x1b80, 0xe1691335,
	0x1b80, 0xe1691337,
	0x1b80, 0xe1631345,
	0x1b80, 0xe1631347,
	0x1b80, 0x5c011355,
	0x1b80, 0x5c011357,
	0x1b80, 0xe1661365,
	0x1b80, 0xe1661367,
	0x1b80, 0x54a21375,
	0x1b80, 0x54a21377,
	0x1b80, 0x5c021385,
	0x1b80, 0x5c021387,
	0x1b80, 0xe1691395,
	0x1b80, 0xe1691397,
	0x1b80, 0xe16013a5,
	0x1b80, 0xe16013a7,
	0x1b80, 0xe16913b5,
	0x1b80, 0xe16913b7,
	0x1b80, 0xe16313c5,
	0x1b80, 0xe16313c7,
	0x1b80, 0x5c0113d5,
	0x1b80, 0x5c0113d7,
	0x1b80, 0xe16613e5,
	0x1b80, 0xe16613e7,
	0x1b80, 0x54a613f5,
	0x1b80, 0x54a613f7,
	0x1b80, 0x54c21405,
	0x1b80, 0x54c21407,
	0x1b80, 0x54a31415,
	0x1b80, 0x54a31417,
	0x1b80, 0x54c61425,
	0x1b80, 0x54c61427,
	0x1b80, 0x54a41435,
	0x1b80, 0x54a41437,
	0x1b80, 0xe1661445,
	0x1b80, 0xe1661447,
	0x1b80, 0x54a11455,
	0x1b80, 0x54a11457,
	0x1b80, 0x5c021465,
	0x1b80, 0x5c021467,
	0x1b80, 0xe1691475,
	0x1b80, 0xe1691477,
	0x1b80, 0xe1601485,
	0x1b80, 0xe1601487,
	0x1b80, 0xe1691495,
	0x1b80, 0xe1691497,
	0x1b80, 0xe16314a5,
	0x1b80, 0xe16314a7,
	0x1b80, 0x5c0114b5,
	0x1b80, 0x5c0114b7,
	0x1b80, 0xe16614c5,
	0x1b80, 0xe16614c7,
	0x1b80, 0x54a214d5,
	0x1b80, 0x54a214d7,
	0x1b80, 0x5c0214e5,
	0x1b80, 0x5c0214e7,
	0x1b80, 0xe16914f5,
	0x1b80, 0xe16914f7,
	0x1b80, 0xe1601505,
	0x1b80, 0xe1601507,
	0x1b80, 0xe1691515,
	0x1b80, 0xe1691517,
	0x1b80, 0xe1631525,
	0x1b80, 0xe1631527,
	0x1b80, 0x5c011535,
	0x1b80, 0x5c011537,
	0x1b80, 0xe1661545,
	0x1b80, 0xe1661547,
	0x1b80, 0x54a61555,
	0x1b80, 0x54a61557,
	0x1b80, 0x54c21565,
	0x1b80, 0x54c21567,
	0x1b80, 0x54a31575,
	0x1b80, 0x54a31577,
	0x1b80, 0x54c61585,
	0x1b80, 0x54c61587,
	0x1b80, 0x54a41595,
	0x1b80, 0x54a41597,
	0x1b80, 0xe16615a5,
	0x1b80, 0xe16615a7,
	0x1b80, 0x54a215b5,
	0x1b80, 0x54a215b7,
	0x1b80, 0x5c0215c5,
	0x1b80, 0x5c0215c7,
	0x1b80, 0xe17415d5,
	0x1b80, 0xe17415d7,
	0x1b80, 0xbf2615e5,
	0x1b80, 0xbf2615e7,
	0x1b80, 0x301f15f5,
	0x1b80, 0x301f15f7,
	0x1b80, 0x54831605,
	0x1b80, 0x54831607,
	0x1b80, 0x54001615,
	0x1b80, 0x54001617,
	0x1b80, 0x00011625,
	0x1b80, 0x00011627,
	0x1b80, 0x54841635,
	0x1b80, 0x54841637,
	0x1b80, 0x54001645,
	0x1b80, 0x54001647,
	0x1b80, 0x00011655,
	0x1b80, 0x00011657,
	0x1b80, 0xe1c51665,
	0x1b80, 0xe1c51667,
	0x1b80, 0x54c51675,
	0x1b80, 0x54c51677,
	0x1b80, 0x00011685,
	0x1b80, 0x00011687,
	0x1b80, 0xe0f71695,
	0x1b80, 0xe0f71697,
	0x1b80, 0xe0fc16a5,
	0x1b80, 0xe0fc16a7,
	0x1b80, 0xe10016b5,
	0x1b80, 0xe10016b7,
	0x1b80, 0xe10916c5,
	0x1b80, 0xe10916c7,
	0x1b80, 0xe1b416d5,
	0x1b80, 0xe1b416d7,
	0x1b80, 0x552316e5,
	0x1b80, 0x552316e7,
	0x1b80, 0xe10316f5,
	0x1b80, 0xe10316f7,
	0x1b80, 0x55251705,
	0x1b80, 0x55251707,
	0x1b80, 0xe1091715,
	0x1b80, 0xe1091717,
	0x1b80, 0xe1b41725,
	0x1b80, 0xe1b41727,
	0x1b80, 0x00011735,
	0x1b80, 0x00011737,
	0x1b80, 0x54a71745,
	0x1b80, 0x54a71747,
	0x1b80, 0x54c01755,
	0x1b80, 0x54c01757,
	0x1b80, 0x54a31765,
	0x1b80, 0x54a31767,
	0x1b80, 0x54c11775,
	0x1b80, 0x54c11777,
	0x1b80, 0x54a41785,
	0x1b80, 0x54a41787,
	0x1b80, 0x4c181795,
	0x1b80, 0x4c181797,
	0x1b80, 0xbf0717a5,
	0x1b80, 0xbf0717a7,
	0x1b80, 0x54c217b5,
	0x1b80, 0x54c217b7,
	0x1b80, 0x54a417c5,
	0x1b80, 0x54a417c7,
	0x1b80, 0xbf0417d5,
	0x1b80, 0xbf0417d7,
	0x1b80, 0x54c117e5,
	0x1b80, 0x54c117e7,
	0x1b80, 0x54a317f5,
	0x1b80, 0x54a317f7,
	0x1b80, 0xbf011805,
	0x1b80, 0xbf011807,
	0x1b80, 0xe1c51815,
	0x1b80, 0xe1c51817,
	0x1b80, 0x54c71825,
	0x1b80, 0x54c71827,
	0x1b80, 0x00011835,
	0x1b80, 0x00011837,
	0x1b80, 0x54a71845,
	0x1b80, 0x54a71847,
	0x1b80, 0x54e51855,
	0x1b80, 0x54e51857,
	0x1b80, 0x050a1865,
	0x1b80, 0x050a1867,
	0x1b80, 0x54c71875,
	0x1b80, 0x54c71877,
	0x1b80, 0x00011885,
	0x1b80, 0x00011887,
	0x1b80, 0x5b401895,
	0x1b80, 0x5b401897,
	0x1b80, 0x738118a5,
	0x1b80, 0x738118a7,
	0x1b80, 0x7f2018b5,
	0x1b80, 0x7f2018b7,
	0x1b80, 0x7e0018c5,
	0x1b80, 0x7e0018c7,
	0x1b80, 0x7d0018d5,
	0x1b80, 0x7d0018d7,
	0x1b80, 0x5b4018e5,
	0x1b80, 0x5b4018e7,
	0x1b80, 0x550118f5,
	0x1b80, 0x550118f7,
	0x1b80, 0x5c011905,
	0x1b80, 0x5c011907,
	0x1b80, 0xe10f1915,
	0x1b80, 0xe10f1917,
	0x1b80, 0x54801925,
	0x1b80, 0x54801927,
	0x1b80, 0x54001935,
	0x1b80, 0x54001937,
	0x1b80, 0x54811945,
	0x1b80, 0x54811947,
	0x1b80, 0x54001955,
	0x1b80, 0x54001957,
	0x1b80, 0x54821965,
	0x1b80, 0x54821967,
	0x1b80, 0x54001975,
	0x1b80, 0x54001977,
	0x1b80, 0x54851985,
	0x1b80, 0x54851987,
	0x1b80, 0x54001995,
	0x1b80, 0x54001997,
	0x1b80, 0x730119a5,
	0x1b80, 0x730119a7,
	0x1b80, 0xe17419b5,
	0x1b80, 0xe17419b7,
	0x1b80, 0xbfe819c5,
	0x1b80, 0xbfe819c7,
	0x1b80, 0x301f19d5,
	0x1b80, 0x301f19d7,
	0x1b80, 0x728019e5,
	0x1b80, 0x728019e7,
	0x1b80, 0x720019f5,
	0x1b80, 0x720019f7,
	0x1b80, 0x92001a05,
	0x1b80, 0x92001a07,
	0x1b80, 0x00011a15,
	0x1b80, 0x00011a17,
	0x1b80, 0x73891a25,
	0x1b80, 0x73891a27,
	0x1b80, 0x73091a35,
	0x1b80, 0x73091a37,
	0x1b80, 0x91001a45,
	0x1b80, 0x91001a47,
	0x1b80, 0x00011a55,
	0x1b80, 0x00011a57,
	0x1b80, 0x00071a65,
	0x1b80, 0x00071a67,
	0x1b80, 0x75801a75,
	0x1b80, 0x75801a77,
	0x1b80, 0x00041a85,
	0x1b80, 0x00041a87,
	0x1b80, 0x4d081a95,
	0x1b80, 0x4d081a97,
	0x1b80, 0x57101aa5,
	0x1b80, 0x57101aa7,
	0x1b80, 0x57001ab5,
	0x1b80, 0x57001ab7,
	0x1b80, 0x4d001ac5,
	0x1b80, 0x4d001ac7,
	0x1b80, 0x00071ad5,
	0x1b80, 0x00071ad7,
	0x1b80, 0x75001ae5,
	0x1b80, 0x75001ae7,
	0x1b80, 0x00011af5,
	0x1b80, 0x00011af7,
	0x1b80, 0x002f1b05,
	0x1b80, 0x002f1b07,
	0x1b80, 0x00001b15,
	0x1b80, 0x00001b17,
	0x1b80, 0x00021b25,
	0x1b80, 0x00021b27,
	0x1b80, 0x00011b35,
	0x1b80, 0x00011b37,
	0x1b80, 0x54871b45,
	0x1b80, 0x54871b47,
	0x1b80, 0x54001b55,
	0x1b80, 0x54001b57,
	0x1b80, 0x5c011b65,
	0x1b80, 0x5c011b67,
	0x1b80, 0x54c71b75,
	0x1b80, 0x54c71b77,
	0x1b80, 0x54001b85,
	0x1b80, 0x54001b87,
	0x1b80, 0x5c021b95,
	0x1b80, 0x5c021b97,
	0x1b80, 0x00011ba5,
	0x1b80, 0x00011ba7,
	0x1b80, 0x5c011bb5,
	0x1b80, 0x5c011bb7,
	0x1b80, 0x07141bc5,
	0x1b80, 0x07141bc7,
	0x1b80, 0x54001bd5,
	0x1b80, 0x54001bd7,
	0x1b80, 0x5c021be5,
	0x1b80, 0x5c021be7,
	0x1b80, 0x00011bf5,
	0x1b80, 0x00011bf7,
	0x1b80, 0x5c021c05,
	0x1b80, 0x5c021c07,
	0x1b80, 0x07141c15,
	0x1b80, 0x07141c17,
	0x1b80, 0x54001c25,
	0x1b80, 0x54001c27,
	0x1b80, 0x5c011c35,
	0x1b80, 0x5c011c37,
	0x1b80, 0x00011c45,
	0x1b80, 0x00011c47,
	0x1b80, 0x4c981c55,
	0x1b80, 0x4c981c57,
	0x1b80, 0x4c181c65,
	0x1b80, 0x4c181c67,
	0x1b80, 0x00011c75,
	0x1b80, 0x00011c77,
	0x1b80, 0x00001c85,
	0x1b80, 0x00001c87,
	0x1b80, 0x00001c95,
	0x1b80, 0x00001c97,
	0x1b80, 0x00001ca5,
	0x1b80, 0x00001ca7,
	0x1b80, 0x00001cb5,
	0x1b80, 0x00001cb7,
	0x1b80, 0x00001cc5,
	0x1b80, 0x00001cc7,
	0x1b80, 0x00001cd5,
	0x1b80, 0x00001cd7,
	0x1b80, 0x00001ce5,
	0x1b80, 0x00001ce7,
	0x1b80, 0x00001cf5,
	0x1b80, 0x00001cf7,
	0x1b80, 0x00011d05,
	0x1b80, 0x00011d07,
	0x1b80, 0x00041d15,
	0x1b80, 0x00041d17,
	0x1b80, 0x5c021d25,
	0x1b80, 0x5c021d27,
	0x1b80, 0x62041d35,
	0x1b80, 0x62041d37,
	0x1b80, 0x4d081d45,
	0x1b80, 0x4d081d47,
	0x1b80, 0x09011d55,
	0x1b80, 0x09011d57,
	0x1b80, 0x0c011d65,
	0x1b80, 0x0c011d67,
	0x1b80, 0x0ba61d75,
	0x1b80, 0x0ba61d77,
	0x1b80, 0x00011d85,
	0x1b80, 0x00011d87,
	0x1b80, 0x00000006,
	0x1b80, 0x00000002,
};

void odm_read_and_config_mp_8723f_cal_init(void *dm_void)
{
	struct dm_struct *dm = (struct dm_struct *)dm_void;
	struct dm_dpk_info *dpk_info = &dm->dpk_info;

	u32	i = 0;
	u32	array_len = sizeof(array_mp_8723f_cal_init) / sizeof(u32);
	u32	*array = array_mp_8723f_cal_init;
	u32	v1 = 0, v2 = 0;

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];
		odm_config_bb_phy_8723f(dm, v1, MASKDWORD, v2);
		RF_DBG(dm, DBG_RF_INIT, "v1 = 0x%x, v2 = 0x%x\n", v1, v2);
		i = i + 2;
	}

	dpk_info->is_dpk_pwr_on = 1;
	dpk_info->is_dpk_enable = 1;
	dpk_info->is_dpk_by_channel = 1;
}

#endif
