/******************************************************************************
 *
 * Copyright(c) 2007 - 2017 Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * The full GNU General Public License is included in this distribution in the
 * file called LICENSE.
 *
 * Contact Information:
 * wlanfae <wlanfae@realtek.com>
 * Realtek Corporation, No. 2, Innovation Road II, Hsinchu Science Park,
 * Hsinchu 300, Taiwan.
 *
 * Larry Finger <Larry.Finger@lwfinger.net>
 *
 *****************************************************************************/

/*Image2HeaderVersion: R3 1.5.5*/
#include "mp_precomp.h"

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
#if RT_PLATFORM == PLATFORM_MACOSX
#include "phydm_precomp.h"
#else
#include "../phydm_precomp.h"
#endif
#else
#include "../../phydm_precomp.h"
#endif

#define D_S_SIZE DELTA_SWINGIDX_SIZE
#define D_ST_SIZE DELTA_SWINTSSI_SIZE

#if (RTL8814C_SUPPORT == 1)
static boolean
check_positive(struct dm_struct *dm,
	       const u32	condition1,
	       const u32	condition2,
	       const u32	condition3,
	       const u32	condition4
)
{
	u32	cond1 = condition1, cond2 = condition2,
		cond3 = condition3, cond4 = condition4;

	u8	cut_version_for_para =
		(dm->cut_version ==  ODM_CUT_A) ? 15 : dm->cut_version;

	u8	pkg_type_for_para =
		(dm->package_type == 0) ? 15 : dm->package_type;

	u32	driver1 = cut_version_for_para << 24 |
			(dm->support_interface & 0xF0) << 16 |
			dm->support_platform << 16 |
			pkg_type_for_para << 12 |
			(dm->support_interface & 0x0F) << 8  |
			dm->rfe_type;

	u32	driver2 = (dm->type_glna & 0xFF) <<  0 |
			(dm->type_gpa & 0xFF)  <<  8 |
			(dm->type_alna & 0xFF) << 16 |
			(dm->type_apa & 0xFF)  << 24;

	u32	driver3 = 0;

	u32	driver4 = (dm->type_glna & 0xFF00) >>  8 |
			(dm->type_gpa & 0xFF00) |
			(dm->type_alna & 0xFF00) << 8 |
			(dm->type_apa & 0xFF00)  << 16;

	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "===> %s (cond1, cond2, cond3, cond4) = (0x%X 0x%X 0x%X 0x%X)\n",
		  __func__, cond1, cond2, cond3, cond4);
	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "===> %s (driver1, driver2, driver3, driver4) = (0x%X 0x%X 0x%X 0x%X)\n",
		  __func__, driver1, driver2, driver3, driver4);

	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "	(Platform, Interface) = (0x%X, 0x%X)\n",
		  dm->support_platform, dm->support_interface);
	PHYDM_DBG(dm, ODM_COMP_INIT, "	(RFE, Package) = (0x%X, 0x%X)\n",
		  dm->rfe_type, dm->package_type);

	/*============== value Defined Check ===============*/
	/*cut version [27:24] need to do value check*/
	if (((cond1 & 0x0F000000) != 0) &&
	    ((cond1 & 0x0F000000) != (driver1 & 0x0F000000)))
		return false;

	/*pkg type [15:12] need to do value check*/
	if (((cond1 & 0x0000F000) != 0) &&
	    ((cond1 & 0x0000F000) != (driver1 & 0x0000F000)))
		return false;

	/*interface [11:8] need to do value check*/
	if (((cond1 & 0x00000F00) != 0) &&
	    ((cond1 & 0x00000F00) != (driver1 & 0x00000F00)))
		return false;
	/*=============== Bit Defined Check ================*/
	/* We don't care [31:28] */

	cond1 &= 0x000000FF;
	driver1 &= 0x000000FF;

	if (cond1 == driver1)
		return true;
	else
		return false;
}


/******************************************************************************
 *                           radioa.TXT
 ******************************************************************************/

const u32 array_mp_8814c_radioa[] = {
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0008D9C0,
	0xA0000000,	0x00000000,
		0x058, 0x00082700,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x0DD, 0x00000010,
	0xA0000000,	0x00000000,
		0x000, 0x00030000,
		0x0DD, 0x00000010,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000001,
		0x03E, 0x00000244,
		0x03F, 0x000000F7,
		0x033, 0x00000002,
		0x03E, 0x000003FC,
		0x03F, 0x000000F7,
		0x033, 0x00000003,
		0x03E, 0x00000245,
		0x03F, 0x000AFCF7,
		0x033, 0x00000004,
		0x03E, 0x000003F6,
		0x03F, 0x0000F9F7,
		0x033, 0x00000007,
		0x03E, 0x000003FD,
		0x03F, 0x000EFCF7,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000001,
		0x03E, 0x00000244,
		0x03F, 0x000000F7,
		0x033, 0x00000002,
		0x03E, 0x000003FC,
		0x03F, 0x000000F7,
		0x033, 0x00000003,
		0x03E, 0x00000245,
		0x03F, 0x000AFCF7,
		0x033, 0x00000004,
		0x03E, 0x000003F6,
		0x03F, 0x0000F9F7,
		0x033, 0x00000007,
		0x03E, 0x000003FD,
		0x03F, 0x000EFCF7,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x09E, 0x000F8009,
	0xA0000000,	0x00000000,
		0x09E, 0x000F8009,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0xA0000000,	0x00000000,
		0x018, 0x00013124,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00000006,
	0xA0000000,	0x00000000,
		0x018, 0x00000006,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x0005512D,
		0x080, 0x000CE800,
	0xA0000000,	0x00000000,
		0x087, 0x0005512D,
		0x080, 0x000CE800,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x082, 0x00003300,
	0xA0000000,	0x00000000,
		0x082, 0x00003300,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0C0, 0x0007FC00,
	0xA0000000,	0x00000000,
		0x0C0, 0x0007FC00,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x01A, 0x00040004,
	0xA0000000,	0x00000000,
		0x01A, 0x00040004,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0000D3A5,
	0xA0000000,	0x00000000,
		0x061, 0x0000D3A5,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00010000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00010000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000F04,
		0x033, 0x00000021,
		0x03F, 0x00000F64,
		0x033, 0x00000022,
		0x03F, 0x00002E04,
		0x033, 0x00000023,
		0x03F, 0x00004E85,
		0x033, 0x00000024,
		0x03F, 0x00004E88,
		0x033, 0x00000025,
		0x03F, 0x00006F05,
		0x033, 0x00000026,
		0x03F, 0x00006FE7,
		0x033, 0x00000027,
		0x03F, 0x00006FEA,
		0x033, 0x00000028,
		0x03F, 0x00006FED,
		0x033, 0x00000029,
		0x03F, 0x00006FF0,
		0x033, 0x0000002A,
		0x03F, 0x00006FF3,
	0xA0000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000F04,
		0x033, 0x00000021,
		0x03F, 0x00000F64,
		0x033, 0x00000022,
		0x03F, 0x00002E04,
		0x033, 0x00000023,
		0x03F, 0x00004E85,
		0x033, 0x00000024,
		0x03F, 0x00004E88,
		0x033, 0x00000025,
		0x03F, 0x00006F05,
		0x033, 0x00000026,
		0x03F, 0x00006FE7,
		0x033, 0x00000027,
		0x03F, 0x00006FEA,
		0x033, 0x00000028,
		0x03F, 0x00006FED,
		0x033, 0x00000029,
		0x03F, 0x00006FF0,
		0x033, 0x0000002A,
		0x03F, 0x00006FF3,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000E64,
		0x033, 0x00000061,
		0x03F, 0x00000E85,
		0x033, 0x00000062,
		0x03F, 0x00000EE4,
		0x033, 0x00000063,
		0x03F, 0x00000EE7,
		0x033, 0x00000064,
		0x03F, 0x00000EEA,
		0x033, 0x00000065,
		0x03F, 0x00004E65,
		0x033, 0x00000066,
		0x03F, 0x00002EA7,
		0x033, 0x00000067,
		0x03F, 0x00002EAA,
		0x033, 0x00000068,
		0x03F, 0x00002EAD,
		0x033, 0x00000069,
		0x03F, 0x00002EB0,
		0x033, 0x0000006A,
		0x03F, 0x00002EB3,
	0xA0000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000E64,
		0x033, 0x00000061,
		0x03F, 0x00000E85,
		0x033, 0x00000062,
		0x03F, 0x00000EE4,
		0x033, 0x00000063,
		0x03F, 0x00000EE7,
		0x033, 0x00000064,
		0x03F, 0x00000EEA,
		0x033, 0x00000065,
		0x03F, 0x00004E65,
		0x033, 0x00000066,
		0x03F, 0x00002EA7,
		0x033, 0x00000067,
		0x03F, 0x00002EAA,
		0x033, 0x00000068,
		0x03F, 0x00002EAD,
		0x033, 0x00000069,
		0x03F, 0x00002EB0,
		0x033, 0x0000006A,
		0x03F, 0x00002EB3,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000203,
		0x033, 0x00000201,
		0x03F, 0x00000206,
		0x033, 0x00000202,
		0x03F, 0x00000209,
		0x033, 0x00000203,
		0x03F, 0x00000226,
		0x033, 0x00000204,
		0x03F, 0x00000229,
		0x033, 0x00000205,
		0x03F, 0x00000266,
		0x033, 0x00000206,
		0x03F, 0x00000269,
		0x033, 0x00000207,
		0x03F, 0x0000026C,
		0x033, 0x00000208,
		0x03F, 0x00000469,
		0x033, 0x00000209,
		0x03F, 0x0000046C,
		0x033, 0x0000020A,
		0x03F, 0x0000046C,
	0xA0000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000445,
		0x033, 0x00000201,
		0x03F, 0x00000448,
		0x033, 0x00000202,
		0x03F, 0x00000468,
		0x033, 0x00000203,
		0x03F, 0x00000668,
		0x033, 0x00000204,
		0x03F, 0x00000E67,
		0x033, 0x00000205,
		0x03F, 0x00000EA6,
		0x033, 0x00000206,
		0x03F, 0x00000EE7,
		0x033, 0x00000207,
		0x03F, 0x00000EEA,
		0x033, 0x00000208,
		0x03F, 0x00000EED,
		0x033, 0x00000209,
		0x03F, 0x00000EF0,
		0x033, 0x0000020A,
		0x03F, 0x00000EF3,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000203,
		0x033, 0x00000281,
		0x03F, 0x00000206,
		0x033, 0x00000282,
		0x03F, 0x00000209,
		0x033, 0x00000283,
		0x03F, 0x00000226,
		0x033, 0x00000284,
		0x03F, 0x00000229,
		0x033, 0x00000285,
		0x03F, 0x00000266,
		0x033, 0x00000286,
		0x03F, 0x00000269,
		0x033, 0x00000287,
		0x03F, 0x0000026C,
		0x033, 0x00000288,
		0x03F, 0x00000469,
		0x033, 0x00000289,
		0x03F, 0x0000046C,
		0x033, 0x0000028A,
		0x03F, 0x0000046C,
	0xA0000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000445,
		0x033, 0x00000281,
		0x03F, 0x00000465,
		0x033, 0x00000282,
		0x03F, 0x00000468,
		0x033, 0x00000283,
		0x03F, 0x00000668,
		0x033, 0x00000284,
		0x03F, 0x00000E67,
		0x033, 0x00000285,
		0x03F, 0x00000EA6,
		0x033, 0x00000286,
		0x03F, 0x00000EE7,
		0x033, 0x00000287,
		0x03F, 0x00000EEA,
		0x033, 0x00000288,
		0x03F, 0x00000EED,
		0x033, 0x00000289,
		0x03F, 0x00000EF0,
		0x033, 0x0000028A,
		0x03F, 0x00000EF3,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000203,
		0x033, 0x00000301,
		0x03F, 0x00000206,
		0x033, 0x00000302,
		0x03F, 0x00000209,
		0x033, 0x00000303,
		0x03F, 0x00000226,
		0x033, 0x00000304,
		0x03F, 0x00000229,
		0x033, 0x00000305,
		0x03F, 0x00000266,
		0x033, 0x00000306,
		0x03F, 0x00000269,
		0x033, 0x00000307,
		0x03F, 0x0000026C,
		0x033, 0x00000308,
		0x03F, 0x00000469,
		0x033, 0x00000309,
		0x03F, 0x0000046C,
		0x033, 0x0000030A,
		0x03F, 0x0000046C,
	0xA0000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000445,
		0x033, 0x00000301,
		0x03F, 0x00000465,
		0x033, 0x00000302,
		0x03F, 0x00000468,
		0x033, 0x00000303,
		0x03F, 0x00000668,
		0x033, 0x00000304,
		0x03F, 0x00000E67,
		0x033, 0x00000305,
		0x03F, 0x00000EA6,
		0x033, 0x00000306,
		0x03F, 0x00000EE7,
		0x033, 0x00000307,
		0x03F, 0x00000EEA,
		0x033, 0x00000308,
		0x03F, 0x00000EED,
		0x033, 0x00000309,
		0x03F, 0x00000EF0,
		0x033, 0x0000030A,
		0x03F, 0x00000EF3,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00040000,
		0x033, 0x00000001,
		0x03F, 0x000C0001,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00040000,
		0x033, 0x00000001,
		0x03F, 0x000C0001,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x030, 0x00000000,
		0x03F, 0x000150F7,
		0x030, 0x00010000,
		0x03F, 0x000150F7,
		0x030, 0x00020000,
		0x03F, 0x000150F7,
		0x030, 0x00030000,
		0x03F, 0x000150F7,
		0x030, 0x00040000,
		0x03F, 0x000150F7,
		0x030, 0x00050000,
		0x03F, 0x000150F7,
		0x030, 0x00060000,
		0x03F, 0x000150F7,
		0x030, 0x00070000,
		0x03F, 0x000150F7,
		0x030, 0x00080000,
		0x03F, 0x000150F7,
		0x030, 0x00090000,
		0x03F, 0x000150F7,
		0x030, 0x000A0000,
		0x03F, 0x000150F7,
		0x030, 0x000B0000,
		0x03F, 0x000150F7,
		0x030, 0x000C0000,
		0x03F, 0x000150F7,
		0x030, 0x000D0000,
		0x03F, 0x000150F7,
		0x030, 0x000E0000,
		0x03F, 0x000150F7,
		0x030, 0x000F0000,
		0x03F, 0x000150F7,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000400,
		0x030, 0x00000000,
		0x03F, 0x000150F7,
		0x030, 0x00010000,
		0x03F, 0x000150F7,
		0x030, 0x00020000,
		0x03F, 0x000150F7,
		0x030, 0x00030000,
		0x03F, 0x000150F7,
		0x030, 0x00040000,
		0x03F, 0x000150F7,
		0x030, 0x00050000,
		0x03F, 0x000150F7,
		0x030, 0x00060000,
		0x03F, 0x000150F7,
		0x030, 0x00070000,
		0x03F, 0x000150F7,
		0x030, 0x00080000,
		0x03F, 0x000150F7,
		0x030, 0x00090000,
		0x03F, 0x000150F7,
		0x030, 0x000A0000,
		0x03F, 0x000150F7,
		0x030, 0x000B0000,
		0x03F, 0x000150F7,
		0x030, 0x000C0000,
		0x03F, 0x000150F7,
		0x030, 0x000D0000,
		0x03F, 0x000150F7,
		0x030, 0x000E0000,
		0x03F, 0x000150F7,
		0x030, 0x000F0000,
		0x03F, 0x000150F7,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000001,
		0x03F, 0x000150F7,
		0x033, 0x0000000B,
		0x03F, 0x000150F7,
		0x033, 0x00000023,
		0x03F, 0x000150F7,
		0x033, 0x00000029,
		0x03F, 0x000150F7,
		0x033, 0x0000002A,
		0x03F, 0x000150F7,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000001,
		0x03F, 0x000150F7,
		0x033, 0x0000000B,
		0x03F, 0x000150F7,
		0x033, 0x00000023,
		0x03F, 0x000150F7,
		0x033, 0x00000029,
		0x03F, 0x000150F7,
		0x033, 0x0000002A,
		0x03F, 0x000150F7,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x000000A3,
		0x030, 0x000010A3,
		0x030, 0x000020A3,
		0x030, 0x000030A3,
		0x030, 0x000040D3,
		0x030, 0x000050D3,
		0x030, 0x000060D3,
		0x030, 0x000070D3,
		0x030, 0x000080B3,
		0x030, 0x000090B3,
		0x030, 0x0000A0B3,
		0x030, 0x0000B0B3,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x000002A3,
		0x030, 0x000012A3,
		0x030, 0x000022A3,
		0x030, 0x000032A3,
		0x030, 0x000042A3,
		0x030, 0x000052A3,
		0x030, 0x000062A3,
		0x030, 0x000072A3,
		0x030, 0x000083B3,
		0x030, 0x000093B3,
		0x030, 0x0000A3B3,
		0x030, 0x0000B3B3,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000400,
		0x030, 0x000000BA,
		0x030, 0x000010BA,
		0x030, 0x000020BA,
		0x030, 0x000030BA,
		0x030, 0x000040BA,
		0x030, 0x000050BA,
		0x030, 0x000060BA,
		0x030, 0x000070BA,
		0x030, 0x000080BA,
		0x030, 0x000090BA,
		0x030, 0x0000A0BA,
		0x030, 0x0000B0BA,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000400,
		0x030, 0x000000BA,
		0x030, 0x000010BA,
		0x030, 0x000020BA,
		0x030, 0x000030BA,
		0x030, 0x000040BA,
		0x030, 0x000050BA,
		0x030, 0x000060BA,
		0x030, 0x000070BA,
		0x030, 0x000080BA,
		0x030, 0x000090BA,
		0x030, 0x0000A0BA,
		0x030, 0x0000B0BA,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x000000A3,
		0x030, 0x000010A3,
		0x030, 0x000020A3,
		0x030, 0x000030A3,
		0x030, 0x000040A3,
		0x030, 0x000050A3,
		0x030, 0x000060D3,
		0x030, 0x000070D3,
		0x030, 0x000080D3,
		0x030, 0x000090D3,
		0x030, 0x0000A0D3,
		0x030, 0x0000B0D3,
		0x030, 0x0000C0B3,
		0x030, 0x0000D0B3,
		0x030, 0x0000E0B3,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x000002A3,
		0x030, 0x000012A3,
		0x030, 0x000022A3,
		0x030, 0x000032A3,
		0x030, 0x000042A3,
		0x030, 0x000052A3,
		0x030, 0x000062A3,
		0x030, 0x000072A3,
		0x030, 0x000082A3,
		0x030, 0x000092A3,
		0x030, 0x0000A2A3,
		0x030, 0x0000B2A3,
		0x030, 0x0000C3B3,
		0x030, 0x0000D3B3,
		0x030, 0x0000E3B3,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000800,
		0x030, 0x000000BA,
		0x030, 0x000010BA,
		0x030, 0x000020BA,
		0x030, 0x000030BA,
		0x030, 0x000040BA,
		0x030, 0x000050BA,
		0x030, 0x000060BA,
		0x030, 0x000070BA,
		0x030, 0x000080BA,
		0x030, 0x000090BA,
		0x030, 0x0000A0BA,
		0x030, 0x0000B0BA,
		0x030, 0x0000C0BA,
		0x030, 0x0000D0BA,
		0x030, 0x0000E0BA,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000800,
		0x030, 0x000000BA,
		0x030, 0x000010BA,
		0x030, 0x000020BA,
		0x030, 0x000030BA,
		0x030, 0x000040BA,
		0x030, 0x000050BA,
		0x030, 0x000060BA,
		0x030, 0x000070BA,
		0x030, 0x000080BA,
		0x030, 0x000090BA,
		0x030, 0x0000A0BA,
		0x030, 0x0000B0BA,
		0x030, 0x0000C0BA,
		0x030, 0x0000D0BA,
		0x030, 0x0000E0BA,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00001000,
		0x030, 0x000009B9,
		0x030, 0x00001555,
		0x030, 0x00002231,
		0x030, 0x00003462,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x030, 0x0000700F,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00001000,
		0x030, 0x000009B9,
		0x030, 0x00001555,
		0x030, 0x00002231,
		0x030, 0x00003462,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x030, 0x0000700F,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x0004026A,
		0x064, 0x00063000,
	0xA0000000,	0x00000000,
		0x063, 0x0004026A,
		0x064, 0x00063000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000D8DEF,
		0x08E, 0x000A6560,
		0x08B, 0x00003060,
		0x0EF, 0x00020000,
	0xA0000000,	0x00000000,
		0x08A, 0x00008DF7,
		0x08E, 0x000A6560,
		0x08B, 0x00003060,
		0x0EF, 0x00020000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008400,
		0x03F, 0x00027983,
		0x033, 0x00000006,
		0x03E, 0x00008402,
		0x03F, 0x00027983,
		0x033, 0x00000005,
		0x03E, 0x00008406,
		0x03F, 0x00027983,
		0x033, 0x00000004,
		0x03E, 0x00008407,
		0x03F, 0x00057983,
		0x033, 0x00000003,
		0x03E, 0x00008427,
		0x03F, 0x00077983,
		0x033, 0x00000002,
		0x03E, 0x00008460,
		0x03F, 0x00017983,
		0x033, 0x00000001,
		0x03E, 0x000084A0,
		0x03F, 0x00017983,
		0x033, 0x00000000,
		0x03E, 0x00008522,
		0x03F, 0x00007983,
	0xA0000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008400,
		0x03F, 0x00007983,
		0x033, 0x00000006,
		0x03E, 0x00008402,
		0x03F, 0x00007983,
		0x033, 0x00000005,
		0x03E, 0x00008406,
		0x03F, 0x00007983,
		0x033, 0x00000004,
		0x03E, 0x00008407,
		0x03F, 0x00027983,
		0x033, 0x00000003,
		0x03E, 0x00008427,
		0x03F, 0x00057983,
		0x033, 0x00000002,
		0x03E, 0x00008460,
		0x03F, 0x00007983,
		0x033, 0x00000001,
		0x03E, 0x000084A0,
		0x03F, 0x00007983,
		0x033, 0x00000000,
		0x03E, 0x00008522,
		0x03F, 0x00007983,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008400,
		0x03F, 0x00017983,
		0x033, 0x0000000E,
		0x03E, 0x00008402,
		0x03F, 0x00017983,
		0x033, 0x0000000D,
		0x03E, 0x00008406,
		0x03F, 0x00027983,
		0x033, 0x0000000C,
		0x03E, 0x00008407,
		0x03F, 0x00057983,
		0x033, 0x0000000B,
		0x03E, 0x00008427,
		0x03F, 0x00077983,
		0x033, 0x0000000A,
		0x03E, 0x00008460,
		0x03F, 0x00017983,
		0x033, 0x00000009,
		0x03E, 0x000084A0,
		0x03F, 0x00017983,
		0x033, 0x00000008,
		0x03E, 0x00008522,
		0x03F, 0x00007983,
	0xA0000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008400,
		0x03F, 0x00007983,
		0x033, 0x0000000E,
		0x03E, 0x00008402,
		0x03F, 0x00007983,
		0x033, 0x0000000D,
		0x03E, 0x00008406,
		0x03F, 0x00007983,
		0x033, 0x0000000C,
		0x03E, 0x00008407,
		0x03F, 0x00027983,
		0x033, 0x0000000B,
		0x03E, 0x00008427,
		0x03F, 0x00057983,
		0x033, 0x0000000A,
		0x03E, 0x00008460,
		0x03F, 0x00007983,
		0x033, 0x00000009,
		0x03E, 0x000084A0,
		0x03F, 0x00007983,
		0x033, 0x00000008,
		0x03E, 0x00008522,
		0x03F, 0x00007983,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008400,
		0x03F, 0x00017983,
		0x033, 0x00000016,
		0x03E, 0x00008401,
		0x03F, 0x00017983,
		0x033, 0x00000015,
		0x03E, 0x00008406,
		0x03F, 0x00027983,
		0x033, 0x00000014,
		0x03E, 0x00008407,
		0x03F, 0x00057983,
		0x033, 0x00000013,
		0x03E, 0x00008427,
		0x03F, 0x00077983,
		0x033, 0x00000012,
		0x03E, 0x00008460,
		0x03F, 0x00017983,
		0x033, 0x00000011,
		0x03E, 0x000084A0,
		0x03F, 0x00017983,
		0x033, 0x00000010,
		0x03E, 0x00008522,
		0x03F, 0x00007983,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008400,
		0x03F, 0x00007983,
		0x033, 0x00000016,
		0x03E, 0x00008401,
		0x03F, 0x00007983,
		0x033, 0x00000015,
		0x03E, 0x00008406,
		0x03F, 0x00007983,
		0x033, 0x00000014,
		0x03E, 0x00008407,
		0x03F, 0x00027983,
		0x033, 0x00000013,
		0x03E, 0x00008427,
		0x03F, 0x00057983,
		0x033, 0x00000012,
		0x03E, 0x00008460,
		0x03F, 0x00007983,
		0x033, 0x00000011,
		0x03E, 0x000084A0,
		0x03F, 0x00007983,
		0x033, 0x00000010,
		0x03E, 0x00008522,
		0x03F, 0x00007983,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x00000008,
		0x033, 0x00000001,
		0x03F, 0x00000004,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x00000008,
		0x033, 0x00000001,
		0x03F, 0x00000004,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x00000000,
		0x03F, 0x000C0000,
		0x033, 0x00000001,
		0x03F, 0x000C0000,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x00000000,
		0x03F, 0x000C0000,
		0x033, 0x00000001,
		0x03F, 0x000C0000,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0xA0000000,	0x00000000,
		0x018, 0x00013124,
	0xB0000000,	0x00000000,
		0x0FE, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x01B, 0x00000240,
	0xA0000000,	0x00000000,
		0x01B, 0x00000240,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x00000010,
		0x03F, 0x00000861,
		0x033, 0x00000011,
		0x03F, 0x00000AAA,
		0x033, 0x00000012,
		0x03F, 0x00000BEF,
		0x033, 0x00000013,
		0x03F, 0x00000D34,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x00000010,
		0x03F, 0x00000861,
		0x033, 0x00000011,
		0x03F, 0x00000AAA,
		0x033, 0x00000012,
		0x03F, 0x00000BEF,
		0x033, 0x00000013,
		0x03F, 0x00000D34,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0DE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0DE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x057, 0x0004B5AA,
	0xA0000000,	0x00000000,
		0x057, 0x0004B5AA,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000010,
		0x008, 0x00078200,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000010,
		0x008, 0x00078200,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x05B, 0x000E801E,
	0xA0000000,	0x00000000,
		0x05B, 0x000E801E,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x018, 0x00010D24,
		0x08F, 0x00000AAC,
		0x069, 0x0000003F,
		0x067, 0x00084200,
		0x067, 0x00084201,
	0xA0000000,	0x00000000,
		0x000, 0x00030000,
		0x018, 0x00000C03,
		0x08F, 0x00000AAC,
		0x069, 0x0000003F,
		0x067, 0x00084200,
		0x067, 0x00084201,
	0xB0000000,	0x00000000,
		0xFFE, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x00084200,
		0x0DF, 0x00002000,
		0x082, 0x00003364,
		0x068, 0x00084210,
	0xA0000000,	0x00000000,
		0x067, 0x00084200,
		0x0DF, 0x00002000,
		0x082, 0x00003364,
		0x068, 0x00084210,
	0xB0000000,	0x00000000,
		0xFFE, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x082, 0x00003354,
		0x068, 0x00084210,
	0xA0000000,	0x00000000,
		0x068, 0x00084200,
		0x082, 0x00003354,
		0x068, 0x00084210,
	0xB0000000,	0x00000000,
		0xFFE, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x0DF, 0x00000000,
	0xA0000000,	0x00000000,
		0x068, 0x00084200,
		0x0DF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x06F, 0x00014311,
		0x06E, 0x00000291,
	0xA0000000,	0x00000000,
		0x06F, 0x00014311,
		0x06E, 0x00000311,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0xFFFF, 0x0000FFFF,
	0xA0000000,	0x00000000,
		0xFFFF, 0x0000FFFF,
	0xB0000000,	0x00000000,

};

void
odm_read_and_config_mp_8814c_radioa(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len =
			sizeof(array_mp_8814c_radioa) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8814c_radioa;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_rf_radio_a_8814c(dm, v1, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8814c_radioa(void)
{
		return 13;
}

/******************************************************************************
 *                           radiob.TXT
 ******************************************************************************/

const u32 array_mp_8814c_radiob[] = {
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0008D9C0,
	0xA0000000,	0x00000000,
		0x058, 0x0007A000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x0DD, 0x00000010,
	0xA0000000,	0x00000000,
		0x000, 0x00030000,
		0x0DD, 0x00000010,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000001,
		0x03E, 0x00000244,
		0x03F, 0x000000F7,
		0x033, 0x00000002,
		0x03E, 0x000003FC,
		0x03F, 0x000000F7,
		0x033, 0x00000003,
		0x03E, 0x00000245,
		0x03F, 0x000AFCF7,
		0x033, 0x00000004,
		0x03E, 0x000003F6,
		0x03F, 0x0000F9F7,
		0x033, 0x00000007,
		0x03E, 0x000003FD,
		0x03F, 0x000EFCF7,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000001,
		0x03E, 0x00000244,
		0x03F, 0x000000F7,
		0x033, 0x00000002,
		0x03E, 0x000003FC,
		0x03F, 0x000000F7,
		0x033, 0x00000003,
		0x03E, 0x00000245,
		0x03F, 0x000AFCF7,
		0x033, 0x00000004,
		0x03E, 0x000003F6,
		0x03F, 0x0000F9F7,
		0x033, 0x00000007,
		0x03E, 0x000003FD,
		0x03F, 0x000EFCF7,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x09E, 0x000F8009,
	0xA0000000,	0x00000000,
		0x09E, 0x000F8009,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0xA0000000,	0x00000000,
		0x018, 0x00013124,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00000006,
	0xA0000000,	0x00000000,
		0x018, 0x00000006,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x0005512D,
		0x080, 0x000CE800,
	0xA0000000,	0x00000000,
		0x087, 0x0005512D,
		0x080, 0x000CE800,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x082, 0x00003300,
	0xA0000000,	0x00000000,
		0x082, 0x00003300,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0C0, 0x0007FC00,
	0xA0000000,	0x00000000,
		0x0C0, 0x0007FC00,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x01A, 0x00040004,
	0xA0000000,	0x00000000,
		0x01A, 0x00040004,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0000D3A5,
	0xA0000000,	0x00000000,
		0x061, 0x0000D3A5,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00010000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00010000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000F04,
		0x033, 0x00000021,
		0x03F, 0x00000F64,
		0x033, 0x00000022,
		0x03F, 0x00002E04,
		0x033, 0x00000023,
		0x03F, 0x00004E85,
		0x033, 0x00000024,
		0x03F, 0x00004E88,
		0x033, 0x00000025,
		0x03F, 0x00006F05,
		0x033, 0x00000026,
		0x03F, 0x00006FE7,
		0x033, 0x00000027,
		0x03F, 0x00006FEA,
		0x033, 0x00000028,
		0x03F, 0x00006FED,
		0x033, 0x00000029,
		0x03F, 0x00006FF0,
		0x033, 0x0000002A,
		0x03F, 0x00006FF3,
	0xA0000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000F04,
		0x033, 0x00000021,
		0x03F, 0x00000F64,
		0x033, 0x00000022,
		0x03F, 0x00002E04,
		0x033, 0x00000023,
		0x03F, 0x00004E85,
		0x033, 0x00000024,
		0x03F, 0x00004E88,
		0x033, 0x00000025,
		0x03F, 0x00006F05,
		0x033, 0x00000026,
		0x03F, 0x00006FE7,
		0x033, 0x00000027,
		0x03F, 0x00006FEA,
		0x033, 0x00000028,
		0x03F, 0x00006FED,
		0x033, 0x00000029,
		0x03F, 0x00006FF0,
		0x033, 0x0000002A,
		0x03F, 0x00006FF3,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000E64,
		0x033, 0x00000061,
		0x03F, 0x00000E85,
		0x033, 0x00000062,
		0x03F, 0x00000EE4,
		0x033, 0x00000063,
		0x03F, 0x00000EE7,
		0x033, 0x00000064,
		0x03F, 0x00000EEA,
		0x033, 0x00000065,
		0x03F, 0x00004E65,
		0x033, 0x00000066,
		0x03F, 0x00002EA7,
		0x033, 0x00000067,
		0x03F, 0x00002EAA,
		0x033, 0x00000068,
		0x03F, 0x00002EAD,
		0x033, 0x00000069,
		0x03F, 0x00002EB0,
		0x033, 0x0000006A,
		0x03F, 0x00002EB3,
	0xA0000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000E64,
		0x033, 0x00000061,
		0x03F, 0x00000E85,
		0x033, 0x00000062,
		0x03F, 0x00000EE4,
		0x033, 0x00000063,
		0x03F, 0x00000EE7,
		0x033, 0x00000064,
		0x03F, 0x00000EEA,
		0x033, 0x00000065,
		0x03F, 0x00004E65,
		0x033, 0x00000066,
		0x03F, 0x00002EA7,
		0x033, 0x00000067,
		0x03F, 0x00002EAA,
		0x033, 0x00000068,
		0x03F, 0x00002EAD,
		0x033, 0x00000069,
		0x03F, 0x00002EB0,
		0x033, 0x0000006A,
		0x03F, 0x00002EB3,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000205,
		0x033, 0x00000201,
		0x03F, 0x00000222,
		0x033, 0x00000202,
		0x03F, 0x00000225,
		0x033, 0x00000203,
		0x03F, 0x00000228,
		0x033, 0x00000204,
		0x03F, 0x0000022B,
		0x033, 0x00000205,
		0x03F, 0x00000428,
		0x033, 0x00000206,
		0x03F, 0x00000628,
		0x033, 0x00000207,
		0x03F, 0x0000062B,
		0x033, 0x00000208,
		0x03F, 0x0000062E,
		0x033, 0x00000209,
		0x03F, 0x0000066B,
		0x033, 0x0000020A,
		0x03F, 0x0000066E,
	0xA0000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000444,
		0x033, 0x00000201,
		0x03F, 0x00000447,
		0x033, 0x00000202,
		0x03F, 0x00000647,
		0x033, 0x00000203,
		0x03F, 0x00000E46,
		0x033, 0x00000204,
		0x03F, 0x00000E66,
		0x033, 0x00000205,
		0x03F, 0x00000EC4,
		0x033, 0x00000206,
		0x03F, 0x00000EE6,
		0x033, 0x00000207,
		0x03F, 0x00000EE9,
		0x033, 0x00000208,
		0x03F, 0x00000EEC,
		0x033, 0x00000209,
		0x03F, 0x00000EEF,
		0x033, 0x0000020A,
		0x03F, 0x00000EF2,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000205,
		0x033, 0x00000281,
		0x03F, 0x00000222,
		0x033, 0x00000282,
		0x03F, 0x00000225,
		0x033, 0x00000283,
		0x03F, 0x00000228,
		0x033, 0x00000284,
		0x03F, 0x0000022B,
		0x033, 0x00000285,
		0x03F, 0x00000428,
		0x033, 0x00000286,
		0x03F, 0x00000628,
		0x033, 0x00000287,
		0x03F, 0x0000062B,
		0x033, 0x00000288,
		0x03F, 0x0000062E,
		0x033, 0x00000289,
		0x03F, 0x0000066B,
		0x033, 0x0000028A,
		0x03F, 0x0000066E,
	0xA0000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000445,
		0x033, 0x00000281,
		0x03F, 0x00000448,
		0x033, 0x00000282,
		0x03F, 0x00000648,
		0x033, 0x00000283,
		0x03F, 0x00000E47,
		0x033, 0x00000284,
		0x03F, 0x00000E67,
		0x033, 0x00000285,
		0x03F, 0x00000EC5,
		0x033, 0x00000286,
		0x03F, 0x00000EE7,
		0x033, 0x00000287,
		0x03F, 0x00000EEA,
		0x033, 0x00000288,
		0x03F, 0x00000EED,
		0x033, 0x00000289,
		0x03F, 0x00000EF0,
		0x033, 0x0000028A,
		0x03F, 0x00000EF3,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000205,
		0x033, 0x00000301,
		0x03F, 0x00000222,
		0x033, 0x00000302,
		0x03F, 0x00000225,
		0x033, 0x00000303,
		0x03F, 0x00000228,
		0x033, 0x00000304,
		0x03F, 0x0000022B,
		0x033, 0x00000305,
		0x03F, 0x00000428,
		0x033, 0x00000306,
		0x03F, 0x00000628,
		0x033, 0x00000307,
		0x03F, 0x0000062B,
		0x033, 0x00000308,
		0x03F, 0x0000062E,
		0x033, 0x00000309,
		0x03F, 0x0000066B,
		0x033, 0x0000030A,
		0x03F, 0x0000066E,
	0xA0000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000445,
		0x033, 0x00000301,
		0x03F, 0x00000448,
		0x033, 0x00000302,
		0x03F, 0x00000648,
		0x033, 0x00000303,
		0x03F, 0x00000E47,
		0x033, 0x00000304,
		0x03F, 0x00000E67,
		0x033, 0x00000305,
		0x03F, 0x00000EC5,
		0x033, 0x00000306,
		0x03F, 0x00000EE7,
		0x033, 0x00000307,
		0x03F, 0x00000EEA,
		0x033, 0x00000308,
		0x03F, 0x00000EED,
		0x033, 0x00000309,
		0x03F, 0x00000EF0,
		0x033, 0x0000030A,
		0x03F, 0x00000EF3,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00040000,
		0x033, 0x00000001,
		0x03F, 0x000C0001,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00040000,
		0x033, 0x00000001,
		0x03F, 0x000C0001,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x030, 0x00000000,
		0x03F, 0x000150F7,
		0x030, 0x00010000,
		0x03F, 0x000150F7,
		0x030, 0x00020000,
		0x03F, 0x000150F7,
		0x030, 0x00030000,
		0x03F, 0x000150F7,
		0x030, 0x00040000,
		0x03F, 0x000150F7,
		0x030, 0x00050000,
		0x03F, 0x000150F7,
		0x030, 0x00060000,
		0x03F, 0x000150F7,
		0x030, 0x00070000,
		0x03F, 0x000150F7,
		0x030, 0x00080000,
		0x03F, 0x000150F7,
		0x030, 0x00090000,
		0x03F, 0x000150F7,
		0x030, 0x000A0000,
		0x03F, 0x000150F7,
		0x030, 0x000B0000,
		0x03F, 0x000150F7,
		0x030, 0x000C0000,
		0x03F, 0x000150F7,
		0x030, 0x000D0000,
		0x03F, 0x000150F7,
		0x030, 0x000E0000,
		0x03F, 0x000150F7,
		0x030, 0x000F0000,
		0x03F, 0x000150F7,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000400,
		0x030, 0x00000000,
		0x03F, 0x000150F7,
		0x030, 0x00010000,
		0x03F, 0x000150F7,
		0x030, 0x00020000,
		0x03F, 0x000150F7,
		0x030, 0x00030000,
		0x03F, 0x000150F7,
		0x030, 0x00040000,
		0x03F, 0x000150F7,
		0x030, 0x00050000,
		0x03F, 0x000150F7,
		0x030, 0x00060000,
		0x03F, 0x000150F7,
		0x030, 0x00070000,
		0x03F, 0x000150F7,
		0x030, 0x00080000,
		0x03F, 0x000150F7,
		0x030, 0x00090000,
		0x03F, 0x000150F7,
		0x030, 0x000A0000,
		0x03F, 0x000150F7,
		0x030, 0x000B0000,
		0x03F, 0x000150F7,
		0x030, 0x000C0000,
		0x03F, 0x000150F7,
		0x030, 0x000D0000,
		0x03F, 0x000150F7,
		0x030, 0x000E0000,
		0x03F, 0x000150F7,
		0x030, 0x000F0000,
		0x03F, 0x000150F7,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000001,
		0x03F, 0x000150F7,
		0x033, 0x0000000B,
		0x03F, 0x000150F7,
		0x033, 0x00000023,
		0x03F, 0x000150F7,
		0x033, 0x00000029,
		0x03F, 0x000150F7,
		0x033, 0x0000002A,
		0x03F, 0x000150F7,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000001,
		0x03F, 0x000150F7,
		0x033, 0x0000000B,
		0x03F, 0x000150F7,
		0x033, 0x00000023,
		0x03F, 0x000150F7,
		0x033, 0x00000029,
		0x03F, 0x000150F7,
		0x033, 0x0000002A,
		0x03F, 0x000150F7,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x00000053,
		0x030, 0x00001053,
		0x030, 0x00002053,
		0x030, 0x00003053,
		0x030, 0x00004023,
		0x030, 0x00005023,
		0x030, 0x00006023,
		0x030, 0x00007023,
		0x030, 0x00008023,
		0x030, 0x00009023,
		0x030, 0x0000A023,
		0x030, 0x0000B023,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x00000253,
		0x030, 0x00001253,
		0x030, 0x00002253,
		0x030, 0x00003253,
		0x030, 0x00004473,
		0x030, 0x00005473,
		0x030, 0x00006473,
		0x030, 0x00007473,
		0x030, 0x00008483,
		0x030, 0x00009483,
		0x030, 0x0000A483,
		0x030, 0x0000B483,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000400,
		0x030, 0x000000BA,
		0x030, 0x000010BA,
		0x030, 0x000020BA,
		0x030, 0x000030BA,
		0x030, 0x000040BA,
		0x030, 0x000050BA,
		0x030, 0x000060BA,
		0x030, 0x000070BA,
		0x030, 0x000080BA,
		0x030, 0x000090BA,
		0x030, 0x0000A0BA,
		0x030, 0x0000B0BA,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000400,
		0x030, 0x000000BA,
		0x030, 0x000010BA,
		0x030, 0x000020BA,
		0x030, 0x000030BA,
		0x030, 0x000040BA,
		0x030, 0x000050BA,
		0x030, 0x000060BA,
		0x030, 0x000070BA,
		0x030, 0x000080BA,
		0x030, 0x000090BA,
		0x030, 0x0000A0BA,
		0x030, 0x0000B0BA,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x00000053,
		0x030, 0x00001053,
		0x030, 0x00002053,
		0x030, 0x00003053,
		0x030, 0x00004053,
		0x030, 0x00005053,
		0x030, 0x00006023,
		0x030, 0x00007023,
		0x030, 0x00008023,
		0x030, 0x00009023,
		0x030, 0x0000A023,
		0x030, 0x0000B023,
		0x030, 0x0000C023,
		0x030, 0x0000D023,
		0x030, 0x0000E023,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x00000253,
		0x030, 0x00001253,
		0x030, 0x00002253,
		0x030, 0x00003253,
		0x030, 0x00004253,
		0x030, 0x00005253,
		0x030, 0x00006473,
		0x030, 0x00007473,
		0x030, 0x00008473,
		0x030, 0x00009473,
		0x030, 0x0000A473,
		0x030, 0x0000B483,
		0x030, 0x0000C483,
		0x030, 0x0000D483,
		0x030, 0x0000E483,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000800,
		0x030, 0x000000BA,
		0x030, 0x000010BA,
		0x030, 0x000020BA,
		0x030, 0x000030BA,
		0x030, 0x000040BA,
		0x030, 0x000050BA,
		0x030, 0x000060BA,
		0x030, 0x000070BA,
		0x030, 0x000080BA,
		0x030, 0x000090BA,
		0x030, 0x0000A0BA,
		0x030, 0x0000B0BA,
		0x030, 0x0000C0BA,
		0x030, 0x0000D0BA,
		0x030, 0x0000E0BA,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000800,
		0x030, 0x000000BA,
		0x030, 0x000010BA,
		0x030, 0x000020BA,
		0x030, 0x000030BA,
		0x030, 0x000040BA,
		0x030, 0x000050BA,
		0x030, 0x000060BA,
		0x030, 0x000070BA,
		0x030, 0x000080BA,
		0x030, 0x000090BA,
		0x030, 0x0000A0BA,
		0x030, 0x0000B0BA,
		0x030, 0x0000C0BA,
		0x030, 0x0000D0BA,
		0x030, 0x0000E0BA,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00001000,
		0x030, 0x000009BD,
		0x030, 0x00001557,
		0x030, 0x00002230,
		0x030, 0x00003351,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x030, 0x00007000,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00001000,
		0x030, 0x000009BD,
		0x030, 0x00001557,
		0x030, 0x00002230,
		0x030, 0x00003351,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x030, 0x00007000,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x0004026A,
		0x064, 0x00063000,
	0xA0000000,	0x00000000,
		0x063, 0x0004026A,
		0x064, 0x00063000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000D8DEF,
		0x08E, 0x000A6560,
		0x08B, 0x00003060,
	0xA0000000,	0x00000000,
		0x08A, 0x00008DF7,
		0x08E, 0x000A6560,
		0x08B, 0x00003060,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00020000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008400,
		0x03F, 0x00007983,
		0x033, 0x00000006,
		0x03E, 0x00008402,
		0x03F, 0x00007983,
		0x033, 0x00000005,
		0x03E, 0x00008406,
		0x03F, 0x00007983,
		0x033, 0x00000004,
		0x03E, 0x00008407,
		0x03F, 0x00027983,
		0x033, 0x00000003,
		0x03E, 0x00008427,
		0x03F, 0x00057983,
		0x033, 0x00000002,
		0x03E, 0x00008460,
		0x03F, 0x00007983,
		0x033, 0x00000001,
		0x03E, 0x000084A0,
		0x03F, 0x00007983,
		0x033, 0x00000000,
		0x03E, 0x00008522,
		0x03F, 0x00007983,
	0xA0000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008400,
		0x03F, 0x00007983,
		0x033, 0x00000006,
		0x03E, 0x00008402,
		0x03F, 0x00007983,
		0x033, 0x00000005,
		0x03E, 0x00008406,
		0x03F, 0x00007983,
		0x033, 0x00000004,
		0x03E, 0x00008407,
		0x03F, 0x00027983,
		0x033, 0x00000003,
		0x03E, 0x00008427,
		0x03F, 0x00057983,
		0x033, 0x00000002,
		0x03E, 0x00008460,
		0x03F, 0x00007983,
		0x033, 0x00000001,
		0x03E, 0x000084A0,
		0x03F, 0x00007983,
		0x033, 0x00000000,
		0x03E, 0x00008522,
		0x03F, 0x00007983,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008400,
		0x03F, 0x00007983,
		0x033, 0x0000000E,
		0x03E, 0x00008402,
		0x03F, 0x00007983,
		0x033, 0x0000000D,
		0x03E, 0x00008406,
		0x03F, 0x00007983,
		0x033, 0x0000000C,
		0x03E, 0x00008407,
		0x03F, 0x00027983,
		0x033, 0x0000000B,
		0x03E, 0x00008427,
		0x03F, 0x00057983,
		0x033, 0x0000000A,
		0x03E, 0x00008460,
		0x03F, 0x00007983,
		0x033, 0x00000009,
		0x03E, 0x000084A0,
		0x03F, 0x00007983,
		0x033, 0x00000008,
		0x03E, 0x00008522,
		0x03F, 0x00007983,
	0xA0000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008400,
		0x03F, 0x00007983,
		0x033, 0x0000000E,
		0x03E, 0x00008402,
		0x03F, 0x00007983,
		0x033, 0x0000000D,
		0x03E, 0x00008406,
		0x03F, 0x00007983,
		0x033, 0x0000000C,
		0x03E, 0x00008407,
		0x03F, 0x00027983,
		0x033, 0x0000000B,
		0x03E, 0x00008427,
		0x03F, 0x00057983,
		0x033, 0x0000000A,
		0x03E, 0x00008460,
		0x03F, 0x00007983,
		0x033, 0x00000009,
		0x03E, 0x000084A0,
		0x03F, 0x00007983,
		0x033, 0x00000008,
		0x03E, 0x00008522,
		0x03F, 0x00007983,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008400,
		0x03F, 0x00007983,
		0x033, 0x00000016,
		0x03E, 0x00008401,
		0x03F, 0x00007983,
		0x033, 0x00000015,
		0x03E, 0x00008406,
		0x03F, 0x00007983,
		0x033, 0x00000014,
		0x03E, 0x00008407,
		0x03F, 0x00027983,
		0x033, 0x00000013,
		0x03E, 0x00008427,
		0x03F, 0x00057983,
		0x033, 0x00000012,
		0x03E, 0x00008460,
		0x03F, 0x00007983,
		0x033, 0x00000011,
		0x03E, 0x000084A0,
		0x03F, 0x00007983,
		0x033, 0x00000010,
		0x03E, 0x00008522,
		0x03F, 0x00007983,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008400,
		0x03F, 0x00007983,
		0x033, 0x00000016,
		0x03E, 0x00008401,
		0x03F, 0x00007983,
		0x033, 0x00000015,
		0x03E, 0x00008406,
		0x03F, 0x00007983,
		0x033, 0x00000014,
		0x03E, 0x00008407,
		0x03F, 0x00027983,
		0x033, 0x00000013,
		0x03E, 0x00008427,
		0x03F, 0x00057983,
		0x033, 0x00000012,
		0x03E, 0x00008460,
		0x03F, 0x00007983,
		0x033, 0x00000011,
		0x03E, 0x000084A0,
		0x03F, 0x00007983,
		0x033, 0x00000010,
		0x03E, 0x00008522,
		0x03F, 0x00007983,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x00000008,
		0x033, 0x00000001,
		0x03F, 0x00000004,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x00000008,
		0x033, 0x00000001,
		0x03F, 0x00000004,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x00000000,
		0x03F, 0x000C0000,
		0x033, 0x00000001,
		0x03F, 0x000C0000,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x00000000,
		0x03F, 0x000C0000,
		0x033, 0x00000001,
		0x03F, 0x000C0000,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0xA0000000,	0x00000000,
		0x018, 0x00013124,
	0xB0000000,	0x00000000,
		0x0FE, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x01B, 0x00000240,
	0xA0000000,	0x00000000,
		0x01B, 0x00000240,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x00000010,
		0x03F, 0x00000104,
		0x033, 0x00000011,
		0x03F, 0x00000965,
		0x033, 0x00000012,
		0x03F, 0x00000A28,
		0x033, 0x00000013,
		0x03F, 0x00000B2C,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x00000010,
		0x03F, 0x00000104,
		0x033, 0x00000011,
		0x03F, 0x00000965,
		0x033, 0x00000012,
		0x03F, 0x00000A28,
		0x033, 0x00000013,
		0x03F, 0x00000B2C,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0DE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0DE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x057, 0x0004B5AA,
	0xA0000000,	0x00000000,
		0x057, 0x0004B5AA,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000010,
		0x008, 0x00078200,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000010,
		0x008, 0x00078200,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x018, 0x00010D24,
		0x08F, 0x00000AAC,
		0x069, 0x0000003F,
		0x067, 0x00084200,
		0x067, 0x00084201,
	0xA0000000,	0x00000000,
		0x000, 0x00030000,
		0x018, 0x00000C03,
		0x08F, 0x00000AAC,
		0x069, 0x0000003F,
		0x067, 0x00084200,
		0x067, 0x00084201,
	0xB0000000,	0x00000000,
		0xFFE, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x00084200,
		0x0DF, 0x00002000,
		0x082, 0x00003364,
		0x068, 0x00084210,
	0xA0000000,	0x00000000,
		0x067, 0x00084200,
		0x0DF, 0x00002000,
		0x082, 0x00003364,
		0x068, 0x00084210,
	0xB0000000,	0x00000000,
		0xFFE, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x082, 0x00003354,
		0x068, 0x00084210,
	0xA0000000,	0x00000000,
		0x068, 0x00084200,
		0x082, 0x00003354,
		0x068, 0x00084210,
	0xB0000000,	0x00000000,
		0xFFE, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x0DF, 0x00000000,
	0xA0000000,	0x00000000,
		0x068, 0x00084200,
		0x0DF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x06F, 0x00014311,
		0x06E, 0x00000211,
	0xA0000000,	0x00000000,
		0x06F, 0x00014311,
		0x06E, 0x00000311,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0xFFFF, 0x0000FFFF,
	0xA0000000,	0x00000000,
		0xFFFF, 0x0000FFFF,
	0xB0000000,	0x00000000,

};

void
odm_read_and_config_mp_8814c_radiob(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len =
			sizeof(array_mp_8814c_radiob) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8814c_radiob;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_rf_radio_b_8814c(dm, v1, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8814c_radiob(void)
{
		return 13;
}

/******************************************************************************
 *                           radioc.TXT
 ******************************************************************************/

const u32 array_mp_8814c_radioc[] = {
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0008D9C0,
	0xA0000000,	0x00000000,
		0x058, 0x00071C00,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x0DD, 0x00000010,
	0xA0000000,	0x00000000,
		0x000, 0x00030000,
		0x0DD, 0x00000010,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000001,
		0x03E, 0x00000244,
		0x03F, 0x000000F7,
		0x033, 0x00000002,
		0x03E, 0x000003FC,
		0x03F, 0x000000F7,
		0x033, 0x00000003,
		0x03E, 0x00000245,
		0x03F, 0x000AFCF7,
		0x033, 0x00000004,
		0x03E, 0x000003F6,
		0x03F, 0x0000F9F7,
		0x033, 0x00000007,
		0x03E, 0x000003FD,
		0x03F, 0x000EFCF7,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000001,
		0x03E, 0x00000244,
		0x03F, 0x000000F7,
		0x033, 0x00000002,
		0x03E, 0x000003FC,
		0x03F, 0x000000F7,
		0x033, 0x00000003,
		0x03E, 0x00000245,
		0x03F, 0x000AFCF7,
		0x033, 0x00000004,
		0x03E, 0x000003F6,
		0x03F, 0x0000F9F7,
		0x033, 0x00000007,
		0x03E, 0x000003FD,
		0x03F, 0x000EFCF7,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x09E, 0x000F8009,
	0xA0000000,	0x00000000,
		0x09E, 0x000F8009,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0xA0000000,	0x00000000,
		0x018, 0x00013124,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00000006,
	0xA0000000,	0x00000000,
		0x018, 0x00000006,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x0005512D,
		0x080, 0x000CE800,
	0xA0000000,	0x00000000,
		0x087, 0x0005512D,
		0x080, 0x000CE800,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x082, 0x00003300,
	0xA0000000,	0x00000000,
		0x082, 0x00003300,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0C0, 0x0007FC00,
	0xA0000000,	0x00000000,
		0x0C0, 0x0007FC00,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x01A, 0x00040004,
	0xA0000000,	0x00000000,
		0x01A, 0x00040004,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0000D3A5,
	0xA0000000,	0x00000000,
		0x061, 0x0000D3A5,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00010000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00010000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000F04,
		0x033, 0x00000021,
		0x03F, 0x00000F64,
		0x033, 0x00000022,
		0x03F, 0x00002E04,
		0x033, 0x00000023,
		0x03F, 0x00004E85,
		0x033, 0x00000024,
		0x03F, 0x00004E88,
		0x033, 0x00000025,
		0x03F, 0x00006F05,
		0x033, 0x00000026,
		0x03F, 0x00006FE7,
		0x033, 0x00000027,
		0x03F, 0x00006FEA,
		0x033, 0x00000028,
		0x03F, 0x00006FED,
		0x033, 0x00000029,
		0x03F, 0x00006FF0,
		0x033, 0x0000002A,
		0x03F, 0x00006FF3,
	0xA0000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000F04,
		0x033, 0x00000021,
		0x03F, 0x00000F64,
		0x033, 0x00000022,
		0x03F, 0x00002E04,
		0x033, 0x00000023,
		0x03F, 0x00004E85,
		0x033, 0x00000024,
		0x03F, 0x00004E88,
		0x033, 0x00000025,
		0x03F, 0x00006F05,
		0x033, 0x00000026,
		0x03F, 0x00006FE7,
		0x033, 0x00000027,
		0x03F, 0x00006FEA,
		0x033, 0x00000028,
		0x03F, 0x00006FED,
		0x033, 0x00000029,
		0x03F, 0x00006FF0,
		0x033, 0x0000002A,
		0x03F, 0x00006FF3,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000E64,
		0x033, 0x00000061,
		0x03F, 0x00000E85,
		0x033, 0x00000062,
		0x03F, 0x00000EE4,
		0x033, 0x00000063,
		0x03F, 0x00000EE7,
		0x033, 0x00000064,
		0x03F, 0x00000EEA,
		0x033, 0x00000065,
		0x03F, 0x00004E65,
		0x033, 0x00000066,
		0x03F, 0x00002EA7,
		0x033, 0x00000067,
		0x03F, 0x00002EAA,
		0x033, 0x00000068,
		0x03F, 0x00002EAD,
		0x033, 0x00000069,
		0x03F, 0x00002EB0,
		0x033, 0x0000006A,
		0x03F, 0x00002EB3,
	0xA0000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000E64,
		0x033, 0x00000061,
		0x03F, 0x00000E85,
		0x033, 0x00000062,
		0x03F, 0x00000EE4,
		0x033, 0x00000063,
		0x03F, 0x00000EE7,
		0x033, 0x00000064,
		0x03F, 0x00000EEA,
		0x033, 0x00000065,
		0x03F, 0x00004E65,
		0x033, 0x00000066,
		0x03F, 0x00002EA7,
		0x033, 0x00000067,
		0x03F, 0x00002EAA,
		0x033, 0x00000068,
		0x03F, 0x00002EAD,
		0x033, 0x00000069,
		0x03F, 0x00002EB0,
		0x033, 0x0000006A,
		0x03F, 0x00002EB3,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000203,
		0x033, 0x00000201,
		0x03F, 0x00000206,
		0x033, 0x00000202,
		0x03F, 0x00000209,
		0x033, 0x00000203,
		0x03F, 0x00000226,
		0x033, 0x00000204,
		0x03F, 0x00000229,
		0x033, 0x00000205,
		0x03F, 0x00000266,
		0x033, 0x00000206,
		0x03F, 0x00000269,
		0x033, 0x00000207,
		0x03F, 0x0000026C,
		0x033, 0x00000208,
		0x03F, 0x00000469,
		0x033, 0x00000209,
		0x03F, 0x0000046C,
		0x033, 0x0000020A,
		0x03F, 0x0000046C,
	0xA0000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000445,
		0x033, 0x00000201,
		0x03F, 0x00000448,
		0x033, 0x00000202,
		0x03F, 0x00000468,
		0x033, 0x00000203,
		0x03F, 0x00000668,
		0x033, 0x00000204,
		0x03F, 0x00000E67,
		0x033, 0x00000205,
		0x03F, 0x00000EA6,
		0x033, 0x00000206,
		0x03F, 0x00000EE7,
		0x033, 0x00000207,
		0x03F, 0x00000EEA,
		0x033, 0x00000208,
		0x03F, 0x00000EED,
		0x033, 0x00000209,
		0x03F, 0x00000EF0,
		0x033, 0x0000020A,
		0x03F, 0x00000EF3,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000203,
		0x033, 0x00000281,
		0x03F, 0x00000206,
		0x033, 0x00000282,
		0x03F, 0x00000209,
		0x033, 0x00000283,
		0x03F, 0x00000226,
		0x033, 0x00000284,
		0x03F, 0x00000229,
		0x033, 0x00000285,
		0x03F, 0x00000266,
		0x033, 0x00000286,
		0x03F, 0x00000269,
		0x033, 0x00000287,
		0x03F, 0x0000026C,
		0x033, 0x00000288,
		0x03F, 0x00000469,
		0x033, 0x00000289,
		0x03F, 0x0000046C,
		0x033, 0x0000028A,
		0x03F, 0x0000046C,
	0xA0000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000445,
		0x033, 0x00000281,
		0x03F, 0x00000465,
		0x033, 0x00000282,
		0x03F, 0x00000468,
		0x033, 0x00000283,
		0x03F, 0x00000668,
		0x033, 0x00000284,
		0x03F, 0x00000E67,
		0x033, 0x00000285,
		0x03F, 0x00000EA6,
		0x033, 0x00000286,
		0x03F, 0x00000EE7,
		0x033, 0x00000287,
		0x03F, 0x00000EEA,
		0x033, 0x00000288,
		0x03F, 0x00000EED,
		0x033, 0x00000289,
		0x03F, 0x00000EF0,
		0x033, 0x0000028A,
		0x03F, 0x00000EF3,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000203,
		0x033, 0x00000301,
		0x03F, 0x00000206,
		0x033, 0x00000302,
		0x03F, 0x00000209,
		0x033, 0x00000303,
		0x03F, 0x00000226,
		0x033, 0x00000304,
		0x03F, 0x00000229,
		0x033, 0x00000305,
		0x03F, 0x00000266,
		0x033, 0x00000306,
		0x03F, 0x00000269,
		0x033, 0x00000307,
		0x03F, 0x0000026C,
		0x033, 0x00000308,
		0x03F, 0x00000469,
		0x033, 0x00000309,
		0x03F, 0x0000046C,
		0x033, 0x0000030A,
		0x03F, 0x0000046C,
	0xA0000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000445,
		0x033, 0x00000301,
		0x03F, 0x00000465,
		0x033, 0x00000302,
		0x03F, 0x00000468,
		0x033, 0x00000303,
		0x03F, 0x00000668,
		0x033, 0x00000304,
		0x03F, 0x00000E67,
		0x033, 0x00000305,
		0x03F, 0x00000EA6,
		0x033, 0x00000306,
		0x03F, 0x00000EE7,
		0x033, 0x00000307,
		0x03F, 0x00000EEA,
		0x033, 0x00000308,
		0x03F, 0x00000EED,
		0x033, 0x00000309,
		0x03F, 0x00000EF0,
		0x033, 0x0000030A,
		0x03F, 0x00000EF3,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00040000,
		0x033, 0x00000001,
		0x03F, 0x000C0001,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00040000,
		0x033, 0x00000001,
		0x03F, 0x000C0001,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x030, 0x00000000,
		0x03F, 0x000150F7,
		0x030, 0x00010000,
		0x03F, 0x000150F7,
		0x030, 0x00020000,
		0x03F, 0x000150F7,
		0x030, 0x00030000,
		0x03F, 0x000150F7,
		0x030, 0x00040000,
		0x03F, 0x000150F7,
		0x030, 0x00050000,
		0x03F, 0x000150F7,
		0x030, 0x00060000,
		0x03F, 0x000150F7,
		0x030, 0x00070000,
		0x03F, 0x000150F7,
		0x030, 0x00080000,
		0x03F, 0x000150F7,
		0x030, 0x00090000,
		0x03F, 0x000150F7,
		0x030, 0x000A0000,
		0x03F, 0x000150F7,
		0x030, 0x000B0000,
		0x03F, 0x000150F7,
		0x030, 0x000C0000,
		0x03F, 0x000150F7,
		0x030, 0x000D0000,
		0x03F, 0x000150F7,
		0x030, 0x000E0000,
		0x03F, 0x000150F7,
		0x030, 0x000F0000,
		0x03F, 0x000150F7,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000400,
		0x030, 0x00000000,
		0x03F, 0x000150F7,
		0x030, 0x00010000,
		0x03F, 0x000150F7,
		0x030, 0x00020000,
		0x03F, 0x000150F7,
		0x030, 0x00030000,
		0x03F, 0x000150F7,
		0x030, 0x00040000,
		0x03F, 0x000150F7,
		0x030, 0x00050000,
		0x03F, 0x000150F7,
		0x030, 0x00060000,
		0x03F, 0x000150F7,
		0x030, 0x00070000,
		0x03F, 0x000150F7,
		0x030, 0x00080000,
		0x03F, 0x000150F7,
		0x030, 0x00090000,
		0x03F, 0x000150F7,
		0x030, 0x000A0000,
		0x03F, 0x000150F7,
		0x030, 0x000B0000,
		0x03F, 0x000150F7,
		0x030, 0x000C0000,
		0x03F, 0x000150F7,
		0x030, 0x000D0000,
		0x03F, 0x000150F7,
		0x030, 0x000E0000,
		0x03F, 0x000150F7,
		0x030, 0x000F0000,
		0x03F, 0x000150F7,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000001,
		0x03F, 0x000150F7,
		0x033, 0x0000000B,
		0x03F, 0x000150F7,
		0x033, 0x00000023,
		0x03F, 0x000150F7,
		0x033, 0x00000029,
		0x03F, 0x000150F7,
		0x033, 0x0000002A,
		0x03F, 0x000150F7,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000001,
		0x03F, 0x000150F7,
		0x033, 0x0000000B,
		0x03F, 0x000150F7,
		0x033, 0x00000023,
		0x03F, 0x000150F7,
		0x033, 0x00000029,
		0x03F, 0x000150F7,
		0x033, 0x0000002A,
		0x03F, 0x000150F7,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x000000A3,
		0x030, 0x000010A3,
		0x030, 0x000020A3,
		0x030, 0x000030A3,
		0x030, 0x000040D3,
		0x030, 0x000050D3,
		0x030, 0x000060D3,
		0x030, 0x000070D3,
		0x030, 0x000080B3,
		0x030, 0x000090B3,
		0x030, 0x0000A0B3,
		0x030, 0x0000B0B3,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x000002A3,
		0x030, 0x000012A3,
		0x030, 0x000022A3,
		0x030, 0x000032A3,
		0x030, 0x000042A3,
		0x030, 0x000052A3,
		0x030, 0x000062A3,
		0x030, 0x000072A3,
		0x030, 0x000083B3,
		0x030, 0x000093B3,
		0x030, 0x0000A3B3,
		0x030, 0x0000B3B3,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000400,
		0x030, 0x000000BA,
		0x030, 0x000010BA,
		0x030, 0x000020BA,
		0x030, 0x000030BA,
		0x030, 0x000040BA,
		0x030, 0x000050BA,
		0x030, 0x000060BA,
		0x030, 0x000070BA,
		0x030, 0x000080BA,
		0x030, 0x000090BA,
		0x030, 0x0000A0BA,
		0x030, 0x0000B0BA,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000400,
		0x030, 0x000000BA,
		0x030, 0x000010BA,
		0x030, 0x000020BA,
		0x030, 0x000030BA,
		0x030, 0x000040BA,
		0x030, 0x000050BA,
		0x030, 0x000060BA,
		0x030, 0x000070BA,
		0x030, 0x000080BA,
		0x030, 0x000090BA,
		0x030, 0x0000A0BA,
		0x030, 0x0000B0BA,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x000000A3,
		0x030, 0x000010A3,
		0x030, 0x000020A3,
		0x030, 0x000030A3,
		0x030, 0x000040A3,
		0x030, 0x000050A3,
		0x030, 0x000060D3,
		0x030, 0x000070D3,
		0x030, 0x000080D3,
		0x030, 0x000090D3,
		0x030, 0x0000A0D3,
		0x030, 0x0000B0D3,
		0x030, 0x0000C0B3,
		0x030, 0x0000D0B3,
		0x030, 0x0000E0B3,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x000002A3,
		0x030, 0x000012A3,
		0x030, 0x000022A3,
		0x030, 0x000032A3,
		0x030, 0x000042A3,
		0x030, 0x000052A3,
		0x030, 0x000062A3,
		0x030, 0x000072A3,
		0x030, 0x000082A3,
		0x030, 0x000092A3,
		0x030, 0x0000A2A3,
		0x030, 0x0000B2A3,
		0x030, 0x0000C3B3,
		0x030, 0x0000D3B3,
		0x030, 0x0000E3B3,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000800,
		0x030, 0x000000BA,
		0x030, 0x000010BA,
		0x030, 0x000020BA,
		0x030, 0x000030BA,
		0x030, 0x000040BA,
		0x030, 0x000050BA,
		0x030, 0x000060BA,
		0x030, 0x000070BA,
		0x030, 0x000080BA,
		0x030, 0x000090BA,
		0x030, 0x0000A0BA,
		0x030, 0x0000B0BA,
		0x030, 0x0000C0BA,
		0x030, 0x0000D0BA,
		0x030, 0x0000E0BA,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000800,
		0x030, 0x000000BA,
		0x030, 0x000010BA,
		0x030, 0x000020BA,
		0x030, 0x000030BA,
		0x030, 0x000040BA,
		0x030, 0x000050BA,
		0x030, 0x000060BA,
		0x030, 0x000070BA,
		0x030, 0x000080BA,
		0x030, 0x000090BA,
		0x030, 0x0000A0BA,
		0x030, 0x0000B0BA,
		0x030, 0x0000C0BA,
		0x030, 0x0000D0BA,
		0x030, 0x0000E0BA,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00001000,
		0x030, 0x000009B9,
		0x030, 0x00001555,
		0x030, 0x00002231,
		0x030, 0x00003462,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x030, 0x0000700F,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00001000,
		0x030, 0x000009B9,
		0x030, 0x00001555,
		0x030, 0x00002231,
		0x030, 0x00003462,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x030, 0x0000700F,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x0004026A,
		0x064, 0x00063000,
	0xA0000000,	0x00000000,
		0x063, 0x0004026A,
		0x064, 0x00063000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000D8DEF,
		0x08E, 0x000A6560,
		0x08B, 0x00003060,
	0xA0000000,	0x00000000,
		0x08A, 0x00008DF7,
		0x08E, 0x000A6560,
		0x08B, 0x00003060,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00020000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008400,
		0x03F, 0x00007983,
		0x033, 0x00000006,
		0x03E, 0x00008402,
		0x03F, 0x00007983,
		0x033, 0x00000005,
		0x03E, 0x00008406,
		0x03F, 0x00007983,
		0x033, 0x00000004,
		0x03E, 0x00008407,
		0x03F, 0x00027983,
		0x033, 0x00000003,
		0x03E, 0x00008427,
		0x03F, 0x00057983,
		0x033, 0x00000002,
		0x03E, 0x00008460,
		0x03F, 0x00007983,
		0x033, 0x00000001,
		0x03E, 0x000084A0,
		0x03F, 0x00007983,
		0x033, 0x00000000,
		0x03E, 0x00008522,
		0x03F, 0x00007983,
	0xA0000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008400,
		0x03F, 0x00007983,
		0x033, 0x00000006,
		0x03E, 0x00008402,
		0x03F, 0x00007983,
		0x033, 0x00000005,
		0x03E, 0x00008406,
		0x03F, 0x00007983,
		0x033, 0x00000004,
		0x03E, 0x00008407,
		0x03F, 0x00027983,
		0x033, 0x00000003,
		0x03E, 0x00008427,
		0x03F, 0x00057983,
		0x033, 0x00000002,
		0x03E, 0x00008460,
		0x03F, 0x00007983,
		0x033, 0x00000001,
		0x03E, 0x000084A0,
		0x03F, 0x00007983,
		0x033, 0x00000000,
		0x03E, 0x00008522,
		0x03F, 0x00007983,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008400,
		0x03F, 0x00007983,
		0x033, 0x0000000E,
		0x03E, 0x00008402,
		0x03F, 0x00007983,
		0x033, 0x0000000D,
		0x03E, 0x00008406,
		0x03F, 0x00007983,
		0x033, 0x0000000C,
		0x03E, 0x00008407,
		0x03F, 0x00027983,
		0x033, 0x0000000B,
		0x03E, 0x00008427,
		0x03F, 0x00057983,
		0x033, 0x0000000A,
		0x03E, 0x00008460,
		0x03F, 0x00007983,
		0x033, 0x00000009,
		0x03E, 0x000084A0,
		0x03F, 0x00007983,
		0x033, 0x00000008,
		0x03E, 0x00008522,
		0x03F, 0x00007983,
	0xA0000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008400,
		0x03F, 0x00007983,
		0x033, 0x0000000E,
		0x03E, 0x00008402,
		0x03F, 0x00007983,
		0x033, 0x0000000D,
		0x03E, 0x00008406,
		0x03F, 0x00007983,
		0x033, 0x0000000C,
		0x03E, 0x00008407,
		0x03F, 0x00027983,
		0x033, 0x0000000B,
		0x03E, 0x00008427,
		0x03F, 0x00057983,
		0x033, 0x0000000A,
		0x03E, 0x00008460,
		0x03F, 0x00007983,
		0x033, 0x00000009,
		0x03E, 0x000084A0,
		0x03F, 0x00007983,
		0x033, 0x00000008,
		0x03E, 0x00008522,
		0x03F, 0x00007983,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008400,
		0x03F, 0x00007983,
		0x033, 0x00000016,
		0x03E, 0x00008401,
		0x03F, 0x00007983,
		0x033, 0x00000015,
		0x03E, 0x00008406,
		0x03F, 0x00007983,
		0x033, 0x00000014,
		0x03E, 0x00008407,
		0x03F, 0x00027983,
		0x033, 0x00000013,
		0x03E, 0x00008427,
		0x03F, 0x00057983,
		0x033, 0x00000012,
		0x03E, 0x00008460,
		0x03F, 0x00007983,
		0x033, 0x00000011,
		0x03E, 0x000084A0,
		0x03F, 0x00007983,
		0x033, 0x00000010,
		0x03E, 0x00008522,
		0x03F, 0x00007983,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008400,
		0x03F, 0x00007983,
		0x033, 0x00000016,
		0x03E, 0x00008401,
		0x03F, 0x00007983,
		0x033, 0x00000015,
		0x03E, 0x00008406,
		0x03F, 0x00007983,
		0x033, 0x00000014,
		0x03E, 0x00008407,
		0x03F, 0x00027983,
		0x033, 0x00000013,
		0x03E, 0x00008427,
		0x03F, 0x00057983,
		0x033, 0x00000012,
		0x03E, 0x00008460,
		0x03F, 0x00007983,
		0x033, 0x00000011,
		0x03E, 0x000084A0,
		0x03F, 0x00007983,
		0x033, 0x00000010,
		0x03E, 0x00008522,
		0x03F, 0x00007983,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x00000008,
		0x033, 0x00000001,
		0x03F, 0x00000004,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x00000008,
		0x033, 0x00000001,
		0x03F, 0x00000004,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x00000000,
		0x03F, 0x000C0000,
		0x033, 0x00000001,
		0x03F, 0x000C0000,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x00000000,
		0x03F, 0x000C0000,
		0x033, 0x00000001,
		0x03F, 0x000C0000,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0xA0000000,	0x00000000,
		0x018, 0x00013124,
	0xB0000000,	0x00000000,
		0x0FE, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x01B, 0x00000240,
	0xA0000000,	0x00000000,
		0x01B, 0x00000240,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x00000010,
		0x03F, 0x00000041,
		0x033, 0x00000011,
		0x03F, 0x00000AEB,
		0x033, 0x00000012,
		0x03F, 0x00000B6D,
		0x033, 0x00000013,
		0x03F, 0x00000CB0,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x00000010,
		0x03F, 0x00000041,
		0x033, 0x00000011,
		0x03F, 0x00000AEB,
		0x033, 0x00000012,
		0x03F, 0x00000B6D,
		0x033, 0x00000013,
		0x03F, 0x00000CB0,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0DE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0DE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x057, 0x0004B5AA,
	0xA0000000,	0x00000000,
		0x057, 0x0004B5AA,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000010,
		0x008, 0x00078200,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000010,
		0x008, 0x00078200,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x018, 0x00010D24,
		0x08F, 0x00000AAC,
		0x069, 0x0000003F,
		0x067, 0x00084200,
		0x067, 0x00084201,
	0xA0000000,	0x00000000,
		0x000, 0x00030000,
		0x018, 0x00000C03,
		0x08F, 0x00000AAC,
		0x069, 0x0000003F,
		0x067, 0x00084200,
		0x067, 0x00084201,
	0xB0000000,	0x00000000,
		0xFFE, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x00084200,
		0x0DF, 0x00002000,
		0x082, 0x00003364,
		0x068, 0x00084210,
	0xA0000000,	0x00000000,
		0x067, 0x00084200,
		0x0DF, 0x00002000,
		0x082, 0x00003364,
		0x068, 0x00084210,
	0xB0000000,	0x00000000,
		0xFFE, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x082, 0x00003354,
		0x068, 0x00084210,
	0xA0000000,	0x00000000,
		0x068, 0x00084200,
		0x082, 0x00003354,
		0x068, 0x00084210,
	0xB0000000,	0x00000000,
		0xFFE, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x0DF, 0x00000000,
	0xA0000000,	0x00000000,
		0x068, 0x00084200,
		0x0DF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x06F, 0x00014311,
		0x06E, 0x00000231,
	0xA0000000,	0x00000000,
		0x06F, 0x00014311,
		0x06E, 0x00000311,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0xFFFF, 0x0000FFFF,
	0xA0000000,	0x00000000,
		0xFFFF, 0x0000FFFF,
	0xB0000000,	0x00000000,

};

void
odm_read_and_config_mp_8814c_radioc(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len =
			sizeof(array_mp_8814c_radioc) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8814c_radioc;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_rf_radio_c_8814c(dm, v1, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8814c_radioc(void)
{
		return 13;
}

/******************************************************************************
 *                           radiod.TXT
 ******************************************************************************/

const u32 array_mp_8814c_radiod[] = {
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x058, 0x0008D9C0,
	0xA0000000,	0x00000000,
		0x058, 0x0006E100,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x0DD, 0x00000010,
	0xA0000000,	0x00000000,
		0x000, 0x00030000,
		0x0DD, 0x00000010,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000001,
		0x03E, 0x00000244,
		0x03F, 0x000000F7,
		0x033, 0x00000002,
		0x03E, 0x000003FC,
		0x03F, 0x000000F7,
		0x033, 0x00000003,
		0x03E, 0x00000245,
		0x03F, 0x000AFCF7,
		0x033, 0x00000004,
		0x03E, 0x000003F6,
		0x03F, 0x0000F9F7,
		0x033, 0x00000007,
		0x03E, 0x000003FD,
		0x03F, 0x000EFCF7,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000001,
		0x03E, 0x00000244,
		0x03F, 0x000000F7,
		0x033, 0x00000002,
		0x03E, 0x000003FC,
		0x03F, 0x000000F7,
		0x033, 0x00000003,
		0x03E, 0x00000245,
		0x03F, 0x000AFCF7,
		0x033, 0x00000004,
		0x03E, 0x000003F6,
		0x03F, 0x0000F9F7,
		0x033, 0x00000007,
		0x03E, 0x000003FD,
		0x03F, 0x000EFCF7,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x09E, 0x000F8009,
	0xA0000000,	0x00000000,
		0x09E, 0x000F8009,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0xA0000000,	0x00000000,
		0x018, 0x00013124,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00000006,
	0xA0000000,	0x00000000,
		0x018, 0x00000006,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x087, 0x0005512D,
		0x080, 0x000CE800,
	0xA0000000,	0x00000000,
		0x087, 0x0005512D,
		0x080, 0x000CE800,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x082, 0x00003300,
	0xA0000000,	0x00000000,
		0x082, 0x00003300,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0C0, 0x0007FC00,
	0xA0000000,	0x00000000,
		0x0C0, 0x0007FC00,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x01A, 0x00040004,
	0xA0000000,	0x00000000,
		0x01A, 0x00040004,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0000D3A5,
	0xA0000000,	0x00000000,
		0x061, 0x0000D3A5,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00010000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00010000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000F04,
		0x033, 0x00000021,
		0x03F, 0x00000F64,
		0x033, 0x00000022,
		0x03F, 0x00002E04,
		0x033, 0x00000023,
		0x03F, 0x00004E85,
		0x033, 0x00000024,
		0x03F, 0x00004E88,
		0x033, 0x00000025,
		0x03F, 0x00006F05,
		0x033, 0x00000026,
		0x03F, 0x00006FE7,
		0x033, 0x00000027,
		0x03F, 0x00006FEA,
		0x033, 0x00000028,
		0x03F, 0x00006FED,
		0x033, 0x00000029,
		0x03F, 0x00006FF0,
		0x033, 0x0000002A,
		0x03F, 0x00006FF3,
	0xA0000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000F04,
		0x033, 0x00000021,
		0x03F, 0x00000F64,
		0x033, 0x00000022,
		0x03F, 0x00002E04,
		0x033, 0x00000023,
		0x03F, 0x00004E85,
		0x033, 0x00000024,
		0x03F, 0x00004E88,
		0x033, 0x00000025,
		0x03F, 0x00006F05,
		0x033, 0x00000026,
		0x03F, 0x00006FE7,
		0x033, 0x00000027,
		0x03F, 0x00006FEA,
		0x033, 0x00000028,
		0x03F, 0x00006FED,
		0x033, 0x00000029,
		0x03F, 0x00006FF0,
		0x033, 0x0000002A,
		0x03F, 0x00006FF3,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000E64,
		0x033, 0x00000061,
		0x03F, 0x00000E85,
		0x033, 0x00000062,
		0x03F, 0x00000EE4,
		0x033, 0x00000063,
		0x03F, 0x00000EE7,
		0x033, 0x00000064,
		0x03F, 0x00000EEA,
		0x033, 0x00000065,
		0x03F, 0x00004E65,
		0x033, 0x00000066,
		0x03F, 0x00002EA7,
		0x033, 0x00000067,
		0x03F, 0x00002EAA,
		0x033, 0x00000068,
		0x03F, 0x00002EAD,
		0x033, 0x00000069,
		0x03F, 0x00002EB0,
		0x033, 0x0000006A,
		0x03F, 0x00002EB3,
	0xA0000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000E64,
		0x033, 0x00000061,
		0x03F, 0x00000E85,
		0x033, 0x00000062,
		0x03F, 0x00000EE4,
		0x033, 0x00000063,
		0x03F, 0x00000EE7,
		0x033, 0x00000064,
		0x03F, 0x00000EEA,
		0x033, 0x00000065,
		0x03F, 0x00004E65,
		0x033, 0x00000066,
		0x03F, 0x00002EA7,
		0x033, 0x00000067,
		0x03F, 0x00002EAA,
		0x033, 0x00000068,
		0x03F, 0x00002EAD,
		0x033, 0x00000069,
		0x03F, 0x00002EB0,
		0x033, 0x0000006A,
		0x03F, 0x00002EB3,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000205,
		0x033, 0x00000201,
		0x03F, 0x00000222,
		0x033, 0x00000202,
		0x03F, 0x00000225,
		0x033, 0x00000203,
		0x03F, 0x00000228,
		0x033, 0x00000204,
		0x03F, 0x0000022B,
		0x033, 0x00000205,
		0x03F, 0x00000428,
		0x033, 0x00000206,
		0x03F, 0x00000628,
		0x033, 0x00000207,
		0x03F, 0x0000062B,
		0x033, 0x00000208,
		0x03F, 0x00000668,
		0x033, 0x00000209,
		0x03F, 0x0000066B,
		0x033, 0x0000020A,
		0x03F, 0x0000066E,
	0xA0000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000444,
		0x033, 0x00000201,
		0x03F, 0x00000447,
		0x033, 0x00000202,
		0x03F, 0x00000647,
		0x033, 0x00000203,
		0x03F, 0x00000E46,
		0x033, 0x00000204,
		0x03F, 0x00000E66,
		0x033, 0x00000205,
		0x03F, 0x00000EC4,
		0x033, 0x00000206,
		0x03F, 0x00000EE6,
		0x033, 0x00000207,
		0x03F, 0x00000EE9,
		0x033, 0x00000208,
		0x03F, 0x00000EEC,
		0x033, 0x00000209,
		0x03F, 0x00000EEF,
		0x033, 0x0000020A,
		0x03F, 0x00000EF2,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000205,
		0x033, 0x00000281,
		0x03F, 0x00000222,
		0x033, 0x00000282,
		0x03F, 0x00000225,
		0x033, 0x00000283,
		0x03F, 0x00000228,
		0x033, 0x00000284,
		0x03F, 0x0000022B,
		0x033, 0x00000285,
		0x03F, 0x00000428,
		0x033, 0x00000286,
		0x03F, 0x00000628,
		0x033, 0x00000287,
		0x03F, 0x0000062B,
		0x033, 0x00000288,
		0x03F, 0x0000064B,
		0x033, 0x00000289,
		0x03F, 0x0000066B,
		0x033, 0x0000028A,
		0x03F, 0x0000066E,
	0xA0000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000445,
		0x033, 0x00000281,
		0x03F, 0x00000448,
		0x033, 0x00000282,
		0x03F, 0x00000648,
		0x033, 0x00000283,
		0x03F, 0x00000E47,
		0x033, 0x00000284,
		0x03F, 0x00000E67,
		0x033, 0x00000285,
		0x03F, 0x00000EC5,
		0x033, 0x00000286,
		0x03F, 0x00000EE7,
		0x033, 0x00000287,
		0x03F, 0x00000EEA,
		0x033, 0x00000288,
		0x03F, 0x00000EED,
		0x033, 0x00000289,
		0x03F, 0x00000EF0,
		0x033, 0x0000028A,
		0x03F, 0x00000EF3,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000205,
		0x033, 0x00000301,
		0x03F, 0x00000222,
		0x033, 0x00000302,
		0x03F, 0x00000225,
		0x033, 0x00000303,
		0x03F, 0x00000228,
		0x033, 0x00000304,
		0x03F, 0x0000022B,
		0x033, 0x00000305,
		0x03F, 0x00000428,
		0x033, 0x00000306,
		0x03F, 0x0000042B,
		0x033, 0x00000307,
		0x03F, 0x0000062B,
		0x033, 0x00000308,
		0x03F, 0x00000668,
		0x033, 0x00000309,
		0x03F, 0x0000066B,
		0x033, 0x0000030A,
		0x03F, 0x0000066E,
	0xA0000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000445,
		0x033, 0x00000301,
		0x03F, 0x00000448,
		0x033, 0x00000302,
		0x03F, 0x00000648,
		0x033, 0x00000303,
		0x03F, 0x00000E47,
		0x033, 0x00000304,
		0x03F, 0x00000E67,
		0x033, 0x00000305,
		0x03F, 0x00000EC5,
		0x033, 0x00000306,
		0x03F, 0x00000EE7,
		0x033, 0x00000307,
		0x03F, 0x00000EEA,
		0x033, 0x00000308,
		0x03F, 0x00000EED,
		0x033, 0x00000309,
		0x03F, 0x00000EF0,
		0x033, 0x0000030A,
		0x03F, 0x00000EF3,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00040000,
		0x033, 0x00000001,
		0x03F, 0x000C0001,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00040000,
		0x033, 0x00000001,
		0x03F, 0x000C0001,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x030, 0x00000000,
		0x03F, 0x000150F7,
		0x030, 0x00010000,
		0x03F, 0x000150F7,
		0x030, 0x00020000,
		0x03F, 0x000150F7,
		0x030, 0x00030000,
		0x03F, 0x000150F7,
		0x030, 0x00040000,
		0x03F, 0x000150F7,
		0x030, 0x00050000,
		0x03F, 0x000150F7,
		0x030, 0x00060000,
		0x03F, 0x000150F7,
		0x030, 0x00070000,
		0x03F, 0x000150F7,
		0x030, 0x00080000,
		0x03F, 0x000150F7,
		0x030, 0x00090000,
		0x03F, 0x000150F7,
		0x030, 0x000A0000,
		0x03F, 0x000150F7,
		0x030, 0x000B0000,
		0x03F, 0x000150F7,
		0x030, 0x000C0000,
		0x03F, 0x000150F7,
		0x030, 0x000D0000,
		0x03F, 0x000150F7,
		0x030, 0x000E0000,
		0x03F, 0x000150F7,
		0x030, 0x000F0000,
		0x03F, 0x000150F7,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000400,
		0x030, 0x00000000,
		0x03F, 0x000150F7,
		0x030, 0x00010000,
		0x03F, 0x000150F7,
		0x030, 0x00020000,
		0x03F, 0x000150F7,
		0x030, 0x00030000,
		0x03F, 0x000150F7,
		0x030, 0x00040000,
		0x03F, 0x000150F7,
		0x030, 0x00050000,
		0x03F, 0x000150F7,
		0x030, 0x00060000,
		0x03F, 0x000150F7,
		0x030, 0x00070000,
		0x03F, 0x000150F7,
		0x030, 0x00080000,
		0x03F, 0x000150F7,
		0x030, 0x00090000,
		0x03F, 0x000150F7,
		0x030, 0x000A0000,
		0x03F, 0x000150F7,
		0x030, 0x000B0000,
		0x03F, 0x000150F7,
		0x030, 0x000C0000,
		0x03F, 0x000150F7,
		0x030, 0x000D0000,
		0x03F, 0x000150F7,
		0x030, 0x000E0000,
		0x03F, 0x000150F7,
		0x030, 0x000F0000,
		0x03F, 0x000150F7,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000001,
		0x03F, 0x000150F7,
		0x033, 0x0000000B,
		0x03F, 0x000150F7,
		0x033, 0x00000023,
		0x03F, 0x000150F7,
		0x033, 0x00000029,
		0x03F, 0x000150F7,
		0x033, 0x0000002A,
		0x03F, 0x000150F7,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000001,
		0x03F, 0x000150F7,
		0x033, 0x0000000B,
		0x03F, 0x000150F7,
		0x033, 0x00000023,
		0x03F, 0x000150F7,
		0x033, 0x00000029,
		0x03F, 0x000150F7,
		0x033, 0x0000002A,
		0x03F, 0x000150F7,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x00000053,
		0x030, 0x00001053,
		0x030, 0x00002053,
		0x030, 0x00003053,
		0x030, 0x00004023,
		0x030, 0x00005023,
		0x030, 0x00006023,
		0x030, 0x00007023,
		0x030, 0x00008023,
		0x030, 0x00009023,
		0x030, 0x0000A023,
		0x030, 0x0000B023,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000100,
		0x030, 0x00000253,
		0x030, 0x00001253,
		0x030, 0x00002253,
		0x030, 0x00003253,
		0x030, 0x00004473,
		0x030, 0x00005473,
		0x030, 0x00006473,
		0x030, 0x00007473,
		0x030, 0x00008483,
		0x030, 0x00009483,
		0x030, 0x0000A483,
		0x030, 0x0000B483,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000400,
		0x030, 0x000000BA,
		0x030, 0x000010BA,
		0x030, 0x000020BA,
		0x030, 0x000030BA,
		0x030, 0x000040BA,
		0x030, 0x000050BA,
		0x030, 0x000060BA,
		0x030, 0x000070BA,
		0x030, 0x000080BA,
		0x030, 0x000090BA,
		0x030, 0x0000A0BA,
		0x030, 0x0000B0BA,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000400,
		0x030, 0x000000BA,
		0x030, 0x000010BA,
		0x030, 0x000020BA,
		0x030, 0x000030BA,
		0x030, 0x000040BA,
		0x030, 0x000050BA,
		0x030, 0x000060BA,
		0x030, 0x000070BA,
		0x030, 0x000080BA,
		0x030, 0x000090BA,
		0x030, 0x0000A0BA,
		0x030, 0x0000B0BA,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x00000053,
		0x030, 0x00001053,
		0x030, 0x00002053,
		0x030, 0x00003053,
		0x030, 0x00004053,
		0x030, 0x00005053,
		0x030, 0x00006023,
		0x030, 0x00007023,
		0x030, 0x00008023,
		0x030, 0x00009023,
		0x030, 0x0000A023,
		0x030, 0x0000B023,
		0x030, 0x0000C023,
		0x030, 0x0000D023,
		0x030, 0x0000E023,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000200,
		0x030, 0x00000253,
		0x030, 0x00001253,
		0x030, 0x00002253,
		0x030, 0x00003253,
		0x030, 0x00004253,
		0x030, 0x00005253,
		0x030, 0x00006473,
		0x030, 0x00007473,
		0x030, 0x00008473,
		0x030, 0x00009473,
		0x030, 0x0000A473,
		0x030, 0x0000B483,
		0x030, 0x0000C483,
		0x030, 0x0000D483,
		0x030, 0x0000E483,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000800,
		0x030, 0x000000BA,
		0x030, 0x000010BA,
		0x030, 0x000020BA,
		0x030, 0x000030BA,
		0x030, 0x000040BA,
		0x030, 0x000050BA,
		0x030, 0x000060BA,
		0x030, 0x000070BA,
		0x030, 0x000080BA,
		0x030, 0x000090BA,
		0x030, 0x0000A0BA,
		0x030, 0x0000B0BA,
		0x030, 0x0000C0BA,
		0x030, 0x0000D0BA,
		0x030, 0x0000E0BA,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000800,
		0x030, 0x000000BA,
		0x030, 0x000010BA,
		0x030, 0x000020BA,
		0x030, 0x000030BA,
		0x030, 0x000040BA,
		0x030, 0x000050BA,
		0x030, 0x000060BA,
		0x030, 0x000070BA,
		0x030, 0x000080BA,
		0x030, 0x000090BA,
		0x030, 0x0000A0BA,
		0x030, 0x0000B0BA,
		0x030, 0x0000C0BA,
		0x030, 0x0000D0BA,
		0x030, 0x0000E0BA,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00001000,
		0x030, 0x000009BD,
		0x030, 0x00001557,
		0x030, 0x00002230,
		0x030, 0x00003351,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x030, 0x00007000,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00001000,
		0x030, 0x000009BD,
		0x030, 0x00001557,
		0x030, 0x00002230,
		0x030, 0x00003351,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x030, 0x00007000,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x0004026A,
		0x064, 0x00063000,
	0xA0000000,	0x00000000,
		0x063, 0x0004026A,
		0x064, 0x00063000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x08A, 0x000D8DEF,
		0x08E, 0x000A6560,
		0x08B, 0x00003060,
	0xA0000000,	0x00000000,
		0x08A, 0x00008DF7,
		0x08E, 0x000A6560,
		0x08B, 0x00003060,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00020000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008400,
		0x03F, 0x00007983,
		0x033, 0x00000006,
		0x03E, 0x00008402,
		0x03F, 0x00007983,
		0x033, 0x00000005,
		0x03E, 0x00008406,
		0x03F, 0x00007983,
		0x033, 0x00000004,
		0x03E, 0x00008407,
		0x03F, 0x00027983,
		0x033, 0x00000003,
		0x03E, 0x00008427,
		0x03F, 0x00057983,
		0x033, 0x00000002,
		0x03E, 0x00008460,
		0x03F, 0x00007983,
		0x033, 0x00000001,
		0x03E, 0x000084A0,
		0x03F, 0x00007983,
		0x033, 0x00000000,
		0x03E, 0x00008522,
		0x03F, 0x00007983,
	0xA0000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00008400,
		0x03F, 0x00007983,
		0x033, 0x00000006,
		0x03E, 0x00008402,
		0x03F, 0x00007983,
		0x033, 0x00000005,
		0x03E, 0x00008406,
		0x03F, 0x00007983,
		0x033, 0x00000004,
		0x03E, 0x00008407,
		0x03F, 0x00027983,
		0x033, 0x00000003,
		0x03E, 0x00008427,
		0x03F, 0x00057983,
		0x033, 0x00000002,
		0x03E, 0x00008460,
		0x03F, 0x00007983,
		0x033, 0x00000001,
		0x03E, 0x000084A0,
		0x03F, 0x00007983,
		0x033, 0x00000000,
		0x03E, 0x00008522,
		0x03F, 0x00007983,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008400,
		0x03F, 0x00007983,
		0x033, 0x0000000E,
		0x03E, 0x00008402,
		0x03F, 0x00007983,
		0x033, 0x0000000D,
		0x03E, 0x00008406,
		0x03F, 0x00007983,
		0x033, 0x0000000C,
		0x03E, 0x00008407,
		0x03F, 0x00027983,
		0x033, 0x0000000B,
		0x03E, 0x00008427,
		0x03F, 0x00057983,
		0x033, 0x0000000A,
		0x03E, 0x00008460,
		0x03F, 0x00007983,
		0x033, 0x00000009,
		0x03E, 0x000084A0,
		0x03F, 0x00007983,
		0x033, 0x00000008,
		0x03E, 0x00008522,
		0x03F, 0x00007983,
	0xA0000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00008400,
		0x03F, 0x00007983,
		0x033, 0x0000000E,
		0x03E, 0x00008402,
		0x03F, 0x00007983,
		0x033, 0x0000000D,
		0x03E, 0x00008406,
		0x03F, 0x00007983,
		0x033, 0x0000000C,
		0x03E, 0x00008407,
		0x03F, 0x00027983,
		0x033, 0x0000000B,
		0x03E, 0x00008427,
		0x03F, 0x00057983,
		0x033, 0x0000000A,
		0x03E, 0x00008460,
		0x03F, 0x00007983,
		0x033, 0x00000009,
		0x03E, 0x000084A0,
		0x03F, 0x00007983,
		0x033, 0x00000008,
		0x03E, 0x00008522,
		0x03F, 0x00007983,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008400,
		0x03F, 0x00007983,
		0x033, 0x00000016,
		0x03E, 0x00008401,
		0x03F, 0x00007983,
		0x033, 0x00000015,
		0x03E, 0x00008406,
		0x03F, 0x00007983,
		0x033, 0x00000014,
		0x03E, 0x00008407,
		0x03F, 0x00027983,
		0x033, 0x00000013,
		0x03E, 0x00008427,
		0x03F, 0x00057983,
		0x033, 0x00000012,
		0x03E, 0x00008460,
		0x03F, 0x00007983,
		0x033, 0x00000011,
		0x03E, 0x000084A0,
		0x03F, 0x00007983,
		0x033, 0x00000010,
		0x03E, 0x00008522,
		0x03F, 0x00007983,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00008400,
		0x03F, 0x00007983,
		0x033, 0x00000016,
		0x03E, 0x00008401,
		0x03F, 0x00007983,
		0x033, 0x00000015,
		0x03E, 0x00008406,
		0x03F, 0x00007983,
		0x033, 0x00000014,
		0x03E, 0x00008407,
		0x03F, 0x00027983,
		0x033, 0x00000013,
		0x03E, 0x00008427,
		0x03F, 0x00057983,
		0x033, 0x00000012,
		0x03E, 0x00008460,
		0x03F, 0x00007983,
		0x033, 0x00000011,
		0x03E, 0x000084A0,
		0x03F, 0x00007983,
		0x033, 0x00000010,
		0x03E, 0x00008522,
		0x03F, 0x00007983,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x00000008,
		0x033, 0x00000001,
		0x03F, 0x00000004,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x00000008,
		0x033, 0x00000001,
		0x03F, 0x00000004,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x00000000,
		0x03F, 0x000C0000,
		0x033, 0x00000001,
		0x03F, 0x000C0000,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x00000000,
		0x03F, 0x000C0000,
		0x033, 0x00000001,
		0x03F, 0x000C0000,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0xA0000000,	0x00000000,
		0x018, 0x00013124,
	0xB0000000,	0x00000000,
		0x0FE, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x01B, 0x00000240,
	0xA0000000,	0x00000000,
		0x01B, 0x00000240,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x00000010,
		0x03F, 0x00000041,
		0x033, 0x00000011,
		0x03F, 0x000009A6,
		0x033, 0x00000012,
		0x03F, 0x00000AAA,
		0x033, 0x00000013,
		0x03F, 0x00000B6D,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x00000010,
		0x03F, 0x00000041,
		0x033, 0x00000011,
		0x03F, 0x000009A6,
		0x033, 0x00000012,
		0x03F, 0x00000AAA,
		0x033, 0x00000013,
		0x03F, 0x00000B6D,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0DE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0DE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x057, 0x0004B5AA,
	0xA0000000,	0x00000000,
		0x057, 0x0004B5AA,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000010,
		0x008, 0x00078200,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000010,
		0x008, 0x00078200,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x018, 0x00010D24,
		0x08F, 0x00000AAC,
		0x069, 0x0000003F,
		0x067, 0x00084200,
		0x067, 0x00084201,
	0xA0000000,	0x00000000,
		0x000, 0x00030000,
		0x018, 0x00000C03,
		0x08F, 0x00000AAC,
		0x069, 0x0000003F,
		0x067, 0x00084200,
		0x067, 0x00084201,
	0xB0000000,	0x00000000,
		0xFFE, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x067, 0x00084200,
		0x0DF, 0x00002000,
		0x082, 0x00003364,
		0x068, 0x00084210,
	0xA0000000,	0x00000000,
		0x067, 0x00084200,
		0x0DF, 0x00002000,
		0x082, 0x00003364,
		0x068, 0x00084210,
	0xB0000000,	0x00000000,
		0xFFE, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x082, 0x00003354,
		0x068, 0x00084210,
	0xA0000000,	0x00000000,
		0x068, 0x00084200,
		0x082, 0x00003354,
		0x068, 0x00084210,
	0xB0000000,	0x00000000,
		0xFFE, 0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x068, 0x00084200,
		0x0DF, 0x00000000,
	0xA0000000,	0x00000000,
		0x068, 0x00084200,
		0x0DF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0x06F, 0x00014311,
		0x06E, 0x00000211,
	0xA0000000,	0x00000000,
		0x06F, 0x00014311,
		0x06E, 0x00000311,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000000,	0x40000000,	0x00000000,
		0xFFFF, 0x0000FFFF,
	0xA0000000,	0x00000000,
		0xFFFF, 0x0000FFFF,
	0xB0000000,	0x00000000,

};

void
odm_read_and_config_mp_8814c_radiod(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len =
			sizeof(array_mp_8814c_radiod) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8814c_radiod;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_rf_radio_d_8814c(dm, v1, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8814c_radiod(void)
{
		return 13;
}

/******************************************************************************
 *                           radiosyn0.TXT
 ******************************************************************************/

const u32 array_mp_8814c_radiosyn0[] = {
		0x000, 0x00020000,
		0x018, 0x00013124,
		0x00C, 0x00006318,
		0x004, 0x000BD402,
		0x00F, 0x00000020,
		0x009, 0x0001C180,
		0x027, 0x00038418,
		0x00E, 0x00000004,
		0x033, 0x00000000,
		0x03F, 0x00000066,
		0x033, 0x00000001,
		0x03F, 0x0000006A,
		0x00E, 0x00000000,
		0x00E, 0x00000001,
		0x033, 0x00000000,
		0x03F, 0x000002C9,
		0x033, 0x00000001,
		0x03F, 0x000002C9,
		0x033, 0x00000002,
		0x03F, 0x000002A9,
		0x033, 0x00000003,
		0x03F, 0x000002A9,
		0x033, 0x00000004,
		0x03F, 0x00000289,
		0x033, 0x00000005,
		0x03F, 0x00000289,
		0x033, 0x00000006,
		0x03F, 0x000002E9,
		0x033, 0x00000007,
		0x03F, 0x00000883,
		0x00E, 0x00000000,
		0x00E, 0x00000040,
		0x033, 0x00000000,
		0x03F, 0x00000012,
		0x033, 0x00000001,
		0x03F, 0x00000052,
		0x033, 0x00000002,
		0x03F, 0x00000012,
		0x033, 0x00000002,
		0x03F, 0x00000012,
		0x033, 0x00000004,
		0x03F, 0x00000052,
		0x033, 0x00000005,
		0x03F, 0x00000052,
		0x033, 0x00000006,
		0x03F, 0x00000052,
		0x033, 0x00000007,
		0x03F, 0x00000052,
		0x00E, 0x00000000,
		0x00E, 0x00000008,
		0x033, 0x00000000,
		0x03E, 0x0000001F,
		0x03F, 0x00012FC8,
		0x00E, 0x00000000,
		0x000, 0x00020000,
		0x018, 0x0001B126,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0x018, 0x00013124,
		0x00E, 0x00000200,
		0x033, 0x00000000,
		0x03F, 0x0000043B,
		0x00E, 0x00000000,
		0x021, 0x00021665,
		0xFFFF, 0x0000FFFF,

};

void
odm_read_and_config_mp_8814c_radiosyn0(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len =
			sizeof(array_mp_8814c_radiosyn0) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8814c_radiosyn0;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_rf_radio_syn0_8814c(dm, v1, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8814c_radiosyn0(void)
{
		return 13;
}

/******************************************************************************
 *                           radiosyn1.TXT
 ******************************************************************************/

const u32 array_mp_8814c_radiosyn1[] = {
		0x018, 0x00013124,
		0x000, 0x00020000,
		0x018, 0x00013124,
		0x00C, 0x0000631A,
		0x004, 0x000BD402,
		0x00F, 0x00000020,
		0x009, 0x0001C180,
		0x027, 0x00038418,
		0x00E, 0x00000004,
		0x033, 0x00000000,
		0x03F, 0x00000032,
		0x033, 0x00000001,
		0x03F, 0x00000052,
		0x00E, 0x00000000,
		0x00E, 0x00000001,
		0x033, 0x00000000,
		0x03F, 0x000002C9,
		0x033, 0x00000001,
		0x03F, 0x000002C9,
		0x033, 0x00000002,
		0x03F, 0x000002A9,
		0x033, 0x00000003,
		0x03F, 0x000002A9,
		0x033, 0x00000004,
		0x03F, 0x00000289,
		0x033, 0x00000005,
		0x03F, 0x00000289,
		0x033, 0x00000006,
		0x03F, 0x000002E9,
		0x033, 0x00000007,
		0x03F, 0x00000883,
		0x00E, 0x00000000,
		0x00E, 0x00000040,
		0x033, 0x00000000,
		0x03F, 0x00000012,
		0x033, 0x00000001,
		0x03F, 0x00000052,
		0x033, 0x00000002,
		0x03F, 0x00000012,
		0x033, 0x00000002,
		0x03F, 0x00000012,
		0x033, 0x00000004,
		0x03F, 0x00000052,
		0x033, 0x00000005,
		0x03F, 0x00000052,
		0x033, 0x00000006,
		0x03F, 0x00000052,
		0x033, 0x00000007,
		0x03F, 0x00000052,
		0x00E, 0x00000000,
		0x00E, 0x00000008,
		0x033, 0x00000000,
		0x03E, 0x0000001F,
		0x03F, 0x00012FC8,
		0x00E, 0x00000000,
		0x000, 0x00020000,
		0x018, 0x0001B126,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0x018, 0x00013124,
		0x00E, 0x00000200,
		0x033, 0x00000000,
		0x03F, 0x0000043B,
		0x00E, 0x00000000,
		0x021, 0x00021665,
		0xFFFF, 0x0000FFFF,

};

void
odm_read_and_config_mp_8814c_radiosyn1(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len =
			sizeof(array_mp_8814c_radiosyn1) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8814c_radiosyn1;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_rf_radio_syn1_8814c(dm, v1, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8814c_radiosyn1(void)
{
		return 13;
}

/******************************************************************************
 *                           txpowertrack.TXT
 ******************************************************************************/

#ifdef CONFIG_8814C
const u8 delta_swingidx_mp_5gd_n_txpwrtrk_8814c[][D_S_SIZE] = {
	{0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 7, 7, 8, 9, 9, 10, 11,
	 11, 12, 13, 13, 14, 15, 15, 16, 17, 17, 18, 19, 19},
	{0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 7, 8, 9, 9, 10, 10,
	 11, 12, 12, 13, 13, 14, 15, 15, 16, 17, 17, 18},
	{0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 17, 18, 19},
};

const u8 delta_swingidx_mp_5gd_p_txpwrtrk_8814c[][D_S_SIZE] = {
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
	 17, 18, 19, 20, 21, 22, 23, 24, 25, 25, 25, 25, 25},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
	 17, 17, 18, 19, 20, 21, 22, 23, 24, 25, 25, 25, 25},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
	 17, 17, 18, 19, 20, 21, 22, 23, 24, 25, 25, 25, 25},
};

const u8 delta_swingidx_mp_5gc_n_txpwrtrk_8814c[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 10, 10,
	 11, 12, 13, 14, 15, 15, 15, 15, 16, 16, 17, 18},
	{0, 1, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10, 11,
	 12, 12, 13, 14, 15, 15, 16, 17, 17, 18, 19, 19, 20},
	{0, 1, 1, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 11, 11,
	 12, 13, 13, 14, 14, 15, 16, 17, 18, 18, 19, 20, 20},
};

const u8 delta_swingidx_mp_5gc_p_txpwrtrk_8814c[][D_S_SIZE] = {
	{0, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
	 16, 16, 17, 18, 19, 20, 21, 21, 22, 23, 24, 25, 25},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
	 17, 17, 18, 19, 20, 21, 22, 23, 24, 24, 25, 25, 25},
	{0, 1, 2, 3, 4, 5, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
	 16, 16, 17, 18, 19, 20, 21, 22, 23, 23, 24, 25, 25},
};

const u8 delta_swingidx_mp_5gb_n_txpwrtrk_8814c[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17, 17},
	{0, 1, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10, 11,
	 12, 12, 13, 14, 15, 15, 16, 17, 17, 18, 19, 19, 20},
	{0, 1, 1, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 11, 11,
	 12, 13, 13, 14, 14, 15, 16, 17, 18, 18, 19, 20, 20},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_8814c[][D_S_SIZE] = {
	{0, 1, 2, 3, 3, 4, 5, 6, 7, 8, 8, 9, 10, 11, 12, 13, 14,
	 15, 15, 16, 17, 18, 18, 19, 20, 21, 22, 23, 23, 24},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
	 17, 18, 18, 19, 20, 21, 22, 23, 24, 25, 25, 25, 25},
	{0, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
	 16, 16, 17, 18, 19, 20, 20, 21, 22, 23, 24, 25, 25},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_8814c[][D_S_SIZE] = {
	{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8,
	 8, 9, 9, 10, 11, 11, 11, 11, 12, 12, 13, 13, 14},
	{0, 1, 1, 2, 3, 4, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 11,
	 12, 13, 14, 14, 15, 16, 16, 17, 18, 19, 19, 20, 21},
	{0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 17, 18, 19},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_8814c[][D_S_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 6, 7, 7, 8, 9, 10, 11, 12, 12, 13,
	 14, 15, 16, 16, 17, 18, 19, 20, 21, 21, 22, 23, 24},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
	 17, 18, 19, 20, 21, 22, 23, 23, 24, 25, 25, 25, 25},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
	 17, 17, 18, 19, 20, 21, 22, 23, 24, 25, 25, 25, 25},
};

const u8 delta_swingidx_mp_2gd_n_txpwrtrk_8814c[]    = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2gd_p_txpwrtrk_8814c[]    = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2gc_n_txpwrtrk_8814c[]    = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2gc_p_txpwrtrk_8814c[]    = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2gb_n_txpwrtrk_8814c[]    = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_8814c[]    = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_8814c[]    = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_8814c[]    = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_d_n_txpwrtrk_8814c[] = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_d_p_txpwrtrk_8814c[] = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_c_n_txpwrtrk_8814c[] = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_c_p_txpwrtrk_8814c[] = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_8814c[] = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_8814c[] = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_8814c[] = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_8814c[] = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
#endif

void
odm_read_and_config_mp_8814c_txpowertrack(struct dm_struct *dm)
{
#ifdef CONFIG_8814C

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8814c\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gc_p,
		(void *)delta_swingidx_mp_2gc_p_txpwrtrk_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gc_n,
		(void *)delta_swingidx_mp_2gc_n_txpwrtrk_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gd_p,
		(void *)delta_swingidx_mp_2gd_p_txpwrtrk_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gd_n,
		(void *)delta_swingidx_mp_2gd_n_txpwrtrk_8814c,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_c_p,
		(void *)delta_swingidx_mp_2g_cck_c_p_txpwrtrk_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_c_n,
		(void *)delta_swingidx_mp_2g_cck_c_n_txpwrtrk_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_d_p,
		(void *)delta_swingidx_mp_2g_cck_d_p_txpwrtrk_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_d_n,
		(void *)delta_swingidx_mp_2g_cck_d_n_txpwrtrk_8814c,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gc_p,
		(void *)delta_swingidx_mp_5gc_p_txpwrtrk_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gc_n,
		(void *)delta_swingidx_mp_5gc_n_txpwrtrk_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gd_p,
		(void *)delta_swingidx_mp_5gd_p_txpwrtrk_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gd_n,
		(void *)delta_swingidx_mp_5gd_n_txpwrtrk_8814c,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type0.TXT
 ******************************************************************************/

#ifdef CONFIG_8814C_TYPE0
const u8 delta_swingidx_mp_5gd_n_txpwrtrk_type0_8814c[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
};

const u8 delta_swingidx_mp_5gd_p_txpwrtrk_type0_8814c[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
};

const u8 delta_swingidx_mp_5gc_n_txpwrtrk_type0_8814c[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
};

const u8 delta_swingidx_mp_5gc_p_txpwrtrk_type0_8814c[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
};

const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type0_8814c[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type0_8814c[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type0_8814c[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type0_8814c[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
};

const u8 delta_swingidx_mp_2gd_n_txpwrtrk_type0_8814c[]    = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2gd_p_txpwrtrk_type0_8814c[]    = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2gc_n_txpwrtrk_type0_8814c[]    = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2gc_p_txpwrtrk_type0_8814c[]    = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type0_8814c[]    = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type0_8814c[]    = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type0_8814c[]    = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type0_8814c[]    = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2g_cck_d_n_txpwrtrk_type0_8814c[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2g_cck_d_p_txpwrtrk_type0_8814c[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2g_cck_c_n_txpwrtrk_type0_8814c[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2g_cck_c_p_txpwrtrk_type0_8814c[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type0_8814c[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type0_8814c[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type0_8814c[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type0_8814c[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
#endif

void
odm_read_and_config_mp_8814c_txpowertrack_type0(struct dm_struct *dm)
{
#ifdef CONFIG_8814C_TYPE0

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8814c\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type0_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type0_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type0_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type0_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gc_p,
		(void *)delta_swingidx_mp_2gc_p_txpwrtrk_type0_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gc_n,
		(void *)delta_swingidx_mp_2gc_n_txpwrtrk_type0_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gd_p,
		(void *)delta_swingidx_mp_2gd_p_txpwrtrk_type0_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gd_n,
		(void *)delta_swingidx_mp_2gd_n_txpwrtrk_type0_8814c,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type0_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type0_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type0_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type0_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_c_p,
		(void *)delta_swingidx_mp_2g_cck_c_p_txpwrtrk_type0_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_c_n,
		(void *)delta_swingidx_mp_2g_cck_c_n_txpwrtrk_type0_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_d_p,
		(void *)delta_swingidx_mp_2g_cck_d_p_txpwrtrk_type0_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_d_n,
		(void *)delta_swingidx_mp_2g_cck_d_n_txpwrtrk_type0_8814c,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type0_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type0_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type0_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type0_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gc_p,
		(void *)delta_swingidx_mp_5gc_p_txpwrtrk_type0_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gc_n,
		(void *)delta_swingidx_mp_5gc_n_txpwrtrk_type0_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gd_p,
		(void *)delta_swingidx_mp_5gd_p_txpwrtrk_type0_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gd_n,
		(void *)delta_swingidx_mp_5gd_n_txpwrtrk_type0_8814c,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type1.TXT
 ******************************************************************************/

#ifdef CONFIG_8814C_TYPE1
const u8 delta_swingidx_mp_5gd_n_txpwrtrk_type1_8814c[][D_S_SIZE] = {
	{1, 3, 5, 5, 6, 7, 9, 11, 12, 13, 15, 15, 16, 18, 19, 20,
	 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20},
	{1, 3, 5, 6, 6, 8, 9, 11, 12, 13, 15, 16, 17, 18, 20, 20,
	 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20},
	{1, 3, 5, 7, 8, 10, 11, 12, 13, 14, 15, 16, 17, 19, 20, 21,
	 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21},
};

const u8 delta_swingidx_mp_5gd_p_txpwrtrk_type1_8814c[][D_S_SIZE] = {
	{1, 2, 3, 5, 6, 7, 8, 10, 12, 14, 16, 17, 19, 20, 22, 24,
	 25, 27, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29},
	{1, 2, 3, 5, 6, 7, 8, 11, 12, 14, 16, 18, 20, 21, 23, 24,
	 26, 28, 29, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31},
	{1, 2, 3, 5, 6, 7, 9, 11, 12, 14, 17, 18, 20, 21, 23, 24,
	 26, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29},
};

const u8 delta_swingidx_mp_5gc_n_txpwrtrk_type1_8814c[][D_S_SIZE] = {
	{1, 3, 5, 5, 6, 7, 9, 11, 12, 13, 15, 15, 16, 18, 18, 19,
	 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19},
	{1, 2, 4, 5, 7, 9, 10, 11, 11, 12, 14, 15, 16, 17, 18, 19,
	 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19},
	{1, 3, 5, 7, 8, 10, 11, 12, 12, 13, 15, 16, 17, 18, 20, 21,
	 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21},
};

const u8 delta_swingidx_mp_5gc_p_txpwrtrk_type1_8814c[][D_S_SIZE] = {
	{1, 2, 3, 5, 6, 7, 9, 10, 12, 14, 16, 17, 19, 20, 22, 23,
	 25, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29},
	{1, 2, 3, 5, 6, 7, 9, 11, 12, 14, 16, 17, 19, 20, 22, 23,
	 24, 27, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29},
	{1, 2, 3, 6, 7, 8, 9, 11, 12, 14, 17, 18, 20, 21, 23, 24,
	 26, 29, 31, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32},
};

const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type1_8814c[][D_S_SIZE] = {
	{1, 3, 4, 6, 8, 9, 10, 12, 12, 13, 15, 15, 16, 18, 19, 20,
	 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20},
	{1, 2, 4, 5, 7, 9, 10, 11, 11, 12, 14, 15, 16, 17, 18, 19,
	 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19},
	{1, 3, 5, 7, 8, 10, 11, 12, 12, 13, 15, 16, 17, 18, 20, 21,
	 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type1_8814c[][D_S_SIZE] = {
	{1, 2, 3, 4, 5, 6, 8, 10, 11, 13, 15, 16, 18, 20, 22, 23,
	 24, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28},
	{1, 2, 3, 4, 5, 7, 9, 11, 12, 14, 15, 16, 19, 21, 22, 23,
	 25, 27, 28, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30},
	{1, 2, 3, 4, 5, 7, 9, 11, 12, 14, 15, 16, 19, 21, 23, 24,
	 26, 27, 28, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type1_8814c[][D_S_SIZE] = {
	{1, 4, 5, 5, 7, 9, 10, 11, 11, 12, 14, 14, 15, 17, 19, 19,
	 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19},
	{1, 3, 4, 5, 6, 8, 9, 10, 12, 12, 13, 14, 15, 16, 18, 18,
	 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18},
	{1, 4, 5, 6, 7, 9, 10, 11, 13, 14, 15, 16, 17, 18, 20, 20,
	 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type1_8814c[][D_S_SIZE] = {
	{1, 2, 3, 4, 5, 6, 8, 10, 11, 13, 14, 15, 18, 19, 21, 22,
	 24, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27},
	{1, 2, 3, 4, 5, 6, 8, 10, 11, 13, 14, 15, 18, 19, 21, 22,
	 24, 25, 26, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28},
	{1, 2, 3, 4, 5, 7, 9, 11, 12, 14, 15, 16, 19, 21, 23, 24,
	 25, 26, 28, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31},
};

const u8 delta_swingidx_mp_2gd_n_txpwrtrk_type1_8814c[]    = {
	0, 1, 2, 4, 4, 5, 5, 6, 8, 9, 9, 10, 10, 11, 13, 14,
	 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15};
const u8 delta_swingidx_mp_2gd_p_txpwrtrk_type1_8814c[]    = {
	0, 0, 1, 2, 4, 4, 5, 7, 8, 9, 9, 10, 11, 12, 13, 14,
	 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2gc_n_txpwrtrk_type1_8814c[]    = {
	0, 1, 2, 3, 3, 4, 5, 6, 7, 8, 8, 9, 10, 11, 12, 13, 13,
	 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14};
const u8 delta_swingidx_mp_2gc_p_txpwrtrk_type1_8814c[]    = {
	0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 11, 12, 13,
	 14, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type1_8814c[]    = {
	0, 1, 2, 3, 4, 5, 5, 6, 7, 7, 8, 9, 11, 11, 12, 14, 14,
	 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type1_8814c[]    = {
	0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 11, 12, 13,
	 15, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type1_8814c[]    = {
	0, 1, 2, 3, 4, 5, 5, 6, 8, 8, 9, 10, 11, 12, 13, 14,
	 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type1_8814c[]    = {
	0, 1, 2, 2, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13, 14,
	 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2g_cck_d_n_txpwrtrk_type1_8814c[] = {
	0, 1, 2, 3, 4, 5, 6, 6, 7, 8, 8, 9, 10, 11, 11, 11, 12,
	 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
const u8 delta_swingidx_mp_2g_cck_d_p_txpwrtrk_type1_8814c[] = {
	1, 2, 3, 3, 4, 5, 6, 7, 9, 9, 10, 11, 12, 13, 14, 15,
	 16, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_c_n_txpwrtrk_type1_8814c[] = {
	0, 1, 2, 3, 4, 5, 6, 7, 7, 8, 9, 9, 10, 11, 11, 12, 12,
	 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13};
const u8 delta_swingidx_mp_2g_cck_c_p_txpwrtrk_type1_8814c[] = {
	1, 2, 3, 3, 4, 6, 6, 7, 9, 9, 10, 11, 12, 12, 13, 14,
	 15, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type1_8814c[] = {
	0, 1, 2, 3, 4, 5, 6, 6, 7, 8, 9, 10, 10, 11, 11, 12,
	 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type1_8814c[] = {
	1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 11, 12, 13, 14, 16,
	 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type1_8814c[] = {
	0, 1, 2, 3, 3, 4, 6, 6, 7, 8, 8, 9, 10, 10, 10, 12, 13,
	 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type1_8814c[] = {
	1, 3, 3, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 14, 15, 16,
	 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
#endif

void
odm_read_and_config_mp_8814c_txpowertrack_type1(struct dm_struct *dm)
{
#ifdef CONFIG_8814C_TYPE1

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8814c\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type1_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type1_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type1_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type1_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gc_p,
		(void *)delta_swingidx_mp_2gc_p_txpwrtrk_type1_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gc_n,
		(void *)delta_swingidx_mp_2gc_n_txpwrtrk_type1_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gd_p,
		(void *)delta_swingidx_mp_2gd_p_txpwrtrk_type1_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gd_n,
		(void *)delta_swingidx_mp_2gd_n_txpwrtrk_type1_8814c,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type1_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type1_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type1_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type1_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_c_p,
		(void *)delta_swingidx_mp_2g_cck_c_p_txpwrtrk_type1_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_c_n,
		(void *)delta_swingidx_mp_2g_cck_c_n_txpwrtrk_type1_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_d_p,
		(void *)delta_swingidx_mp_2g_cck_d_p_txpwrtrk_type1_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_d_n,
		(void *)delta_swingidx_mp_2g_cck_d_n_txpwrtrk_type1_8814c,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type1_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type1_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type1_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type1_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gc_p,
		(void *)delta_swingidx_mp_5gc_p_txpwrtrk_type1_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gc_n,
		(void *)delta_swingidx_mp_5gc_n_txpwrtrk_type1_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gd_p,
		(void *)delta_swingidx_mp_5gd_p_txpwrtrk_type1_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gd_n,
		(void *)delta_swingidx_mp_5gd_n_txpwrtrk_type1_8814c,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type2.TXT
 ******************************************************************************/

#ifdef CONFIG_8814C_TYPE2
const u8 delta_swingidx_mp_5gd_n_txpwrtrk_type2_8814c[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
};

const u8 delta_swingidx_mp_5gd_p_txpwrtrk_type2_8814c[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
};

const u8 delta_swingidx_mp_5gc_n_txpwrtrk_type2_8814c[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
};

const u8 delta_swingidx_mp_5gc_p_txpwrtrk_type2_8814c[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
};

const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type2_8814c[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type2_8814c[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type2_8814c[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type2_8814c[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
};

const u8 delta_swingidx_mp_2gd_n_txpwrtrk_type2_8814c[]    = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2gd_p_txpwrtrk_type2_8814c[]    = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2gc_n_txpwrtrk_type2_8814c[]    = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2gc_p_txpwrtrk_type2_8814c[]    = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type2_8814c[]    = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type2_8814c[]    = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type2_8814c[]    = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type2_8814c[]    = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2g_cck_d_n_txpwrtrk_type2_8814c[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2g_cck_d_p_txpwrtrk_type2_8814c[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2g_cck_c_n_txpwrtrk_type2_8814c[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2g_cck_c_p_txpwrtrk_type2_8814c[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type2_8814c[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type2_8814c[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type2_8814c[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type2_8814c[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
#endif

void
odm_read_and_config_mp_8814c_txpowertrack_type2(struct dm_struct *dm)
{
#ifdef CONFIG_8814C_TYPE2

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8814c\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type2_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type2_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type2_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type2_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gc_p,
		(void *)delta_swingidx_mp_2gc_p_txpwrtrk_type2_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gc_n,
		(void *)delta_swingidx_mp_2gc_n_txpwrtrk_type2_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gd_p,
		(void *)delta_swingidx_mp_2gd_p_txpwrtrk_type2_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gd_n,
		(void *)delta_swingidx_mp_2gd_n_txpwrtrk_type2_8814c,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type2_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type2_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type2_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type2_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_c_p,
		(void *)delta_swingidx_mp_2g_cck_c_p_txpwrtrk_type2_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_c_n,
		(void *)delta_swingidx_mp_2g_cck_c_n_txpwrtrk_type2_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_d_p,
		(void *)delta_swingidx_mp_2g_cck_d_p_txpwrtrk_type2_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_d_n,
		(void *)delta_swingidx_mp_2g_cck_d_n_txpwrtrk_type2_8814c,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type2_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type2_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type2_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type2_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gc_p,
		(void *)delta_swingidx_mp_5gc_p_txpwrtrk_type2_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gc_n,
		(void *)delta_swingidx_mp_5gc_n_txpwrtrk_type2_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gd_p,
		(void *)delta_swingidx_mp_5gd_p_txpwrtrk_type2_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gd_n,
		(void *)delta_swingidx_mp_5gd_n_txpwrtrk_type2_8814c,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type3.TXT
 ******************************************************************************/

#ifdef CONFIG_8814C_TYPE3
const u8 delta_swingidx_mp_5gd_n_txpwrtrk_type3_8814c[][D_S_SIZE] = {
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
};

const u8 delta_swingidx_mp_5gd_p_txpwrtrk_type3_8814c[][D_S_SIZE] = {
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
};

const u8 delta_swingidx_mp_5gc_n_txpwrtrk_type3_8814c[][D_S_SIZE] = {
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
};

const u8 delta_swingidx_mp_5gc_p_txpwrtrk_type3_8814c[][D_S_SIZE] = {
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
};

const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type3_8814c[][D_S_SIZE] = {
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type3_8814c[][D_S_SIZE] = {
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type3_8814c[][D_S_SIZE] = {
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type3_8814c[][D_S_SIZE] = {
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
};

const u8 delta_swingidx_mp_2gd_n_txpwrtrk_type3_8814c[]    = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2gd_p_txpwrtrk_type3_8814c[]    = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2gc_n_txpwrtrk_type3_8814c[]    = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2gc_p_txpwrtrk_type3_8814c[]    = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type3_8814c[]    = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type3_8814c[]    = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type3_8814c[]    = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type3_8814c[]    = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_d_n_txpwrtrk_type3_8814c[] = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_d_p_txpwrtrk_type3_8814c[] = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_c_n_txpwrtrk_type3_8814c[] = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_c_p_txpwrtrk_type3_8814c[] = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type3_8814c[] = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type3_8814c[] = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type3_8814c[] = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type3_8814c[] = {
	0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10,
	 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 18, 18, 18};
#endif

void
odm_read_and_config_mp_8814c_txpowertrack_type3(struct dm_struct *dm)
{
#ifdef CONFIG_8814C_TYPE3

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8814c\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type3_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type3_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type3_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type3_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gc_p,
		(void *)delta_swingidx_mp_2gc_p_txpwrtrk_type3_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gc_n,
		(void *)delta_swingidx_mp_2gc_n_txpwrtrk_type3_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gd_p,
		(void *)delta_swingidx_mp_2gd_p_txpwrtrk_type3_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gd_n,
		(void *)delta_swingidx_mp_2gd_n_txpwrtrk_type3_8814c,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type3_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type3_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type3_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type3_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_c_p,
		(void *)delta_swingidx_mp_2g_cck_c_p_txpwrtrk_type3_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_c_n,
		(void *)delta_swingidx_mp_2g_cck_c_n_txpwrtrk_type3_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_d_p,
		(void *)delta_swingidx_mp_2g_cck_d_p_txpwrtrk_type3_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_d_n,
		(void *)delta_swingidx_mp_2g_cck_d_n_txpwrtrk_type3_8814c,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type3_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type3_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type3_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type3_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gc_p,
		(void *)delta_swingidx_mp_5gc_p_txpwrtrk_type3_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gc_n,
		(void *)delta_swingidx_mp_5gc_n_txpwrtrk_type3_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gd_p,
		(void *)delta_swingidx_mp_5gd_p_txpwrtrk_type3_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gd_n,
		(void *)delta_swingidx_mp_5gd_n_txpwrtrk_type3_8814c,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type4.TXT
 ******************************************************************************/

#ifdef CONFIG_8814C_TYPE4
const u8 delta_swingidx_mp_5gd_n_txpwrtrk_type4_8814c[][D_S_SIZE] = {
	{1, 3, 5, 5, 6, 7, 9, 11, 12, 13, 15, 15, 16, 18, 19, 20,
	 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20},
	{1, 3, 5, 6, 6, 8, 9, 11, 12, 13, 15, 16, 17, 18, 20, 20,
	 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20},
	{1, 3, 5, 7, 8, 10, 11, 12, 13, 14, 15, 16, 17, 19, 20, 21,
	 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21},
};

const u8 delta_swingidx_mp_5gd_p_txpwrtrk_type4_8814c[][D_S_SIZE] = {
	{1, 2, 3, 5, 6, 7, 8, 10, 12, 14, 16, 17, 19, 20, 22, 24,
	 25, 27, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29},
	{1, 2, 3, 5, 6, 7, 8, 11, 12, 14, 16, 18, 20, 21, 23, 24,
	 26, 28, 29, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31},
	{1, 2, 3, 5, 6, 7, 9, 11, 12, 14, 17, 18, 20, 21, 23, 24,
	 26, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29},
};

const u8 delta_swingidx_mp_5gc_n_txpwrtrk_type4_8814c[][D_S_SIZE] = {
	{1, 3, 5, 5, 6, 7, 9, 11, 12, 13, 15, 15, 16, 18, 18, 19,
	 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19},
	{1, 2, 4, 5, 7, 9, 10, 11, 11, 12, 14, 15, 16, 17, 18, 19,
	 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19},
	{1, 3, 5, 7, 8, 10, 11, 12, 12, 13, 15, 16, 17, 18, 20, 21,
	 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21},
};

const u8 delta_swingidx_mp_5gc_p_txpwrtrk_type4_8814c[][D_S_SIZE] = {
	{1, 2, 3, 5, 6, 7, 9, 10, 12, 14, 16, 17, 19, 20, 22, 23,
	 25, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29},
	{1, 2, 3, 5, 6, 7, 9, 11, 12, 14, 16, 17, 19, 20, 22, 23,
	 24, 27, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29},
	{1, 2, 3, 6, 7, 8, 9, 11, 12, 14, 17, 18, 20, 21, 23, 24,
	 26, 29, 31, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32},
};

const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type4_8814c[][D_S_SIZE] = {
	{1, 3, 4, 6, 8, 9, 10, 12, 12, 13, 15, 15, 16, 18, 19, 20,
	 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20},
	{1, 2, 4, 5, 7, 9, 10, 11, 11, 12, 14, 15, 16, 17, 18, 19,
	 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19},
	{1, 3, 5, 7, 8, 10, 11, 12, 12, 13, 15, 16, 17, 18, 20, 21,
	 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type4_8814c[][D_S_SIZE] = {
	{1, 2, 3, 4, 5, 6, 8, 10, 11, 13, 15, 16, 18, 20, 22, 23,
	 24, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28},
	{1, 2, 3, 4, 5, 7, 9, 11, 12, 14, 15, 16, 19, 21, 22, 23,
	 25, 27, 28, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30},
	{1, 2, 3, 4, 5, 7, 9, 11, 12, 14, 15, 16, 19, 21, 23, 24,
	 26, 27, 28, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type4_8814c[][D_S_SIZE] = {
	{1, 4, 5, 5, 7, 9, 10, 11, 11, 12, 14, 14, 15, 17, 19, 19,
	 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19},
	{1, 3, 4, 5, 6, 8, 9, 10, 12, 12, 13, 14, 15, 16, 18, 18,
	 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18},
	{1, 4, 5, 6, 7, 9, 10, 11, 13, 14, 15, 16, 17, 18, 20, 20,
	 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type4_8814c[][D_S_SIZE] = {
	{1, 2, 3, 4, 5, 6, 8, 10, 11, 13, 14, 15, 18, 19, 21, 22,
	 24, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27},
	{1, 2, 3, 4, 5, 6, 8, 10, 11, 13, 14, 15, 18, 19, 21, 22,
	 24, 25, 26, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28},
	{1, 2, 3, 4, 5, 7, 9, 11, 12, 14, 15, 16, 19, 21, 23, 24,
	 25, 26, 28, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31},
};

const u8 delta_swingidx_mp_2gd_n_txpwrtrk_type4_8814c[]    = {
	0, 1, 2, 4, 4, 5, 5, 6, 8, 9, 9, 10, 10, 11, 13, 14,
	 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15};
const u8 delta_swingidx_mp_2gd_p_txpwrtrk_type4_8814c[]    = {
	0, 0, 1, 2, 4, 4, 5, 7, 8, 9, 9, 10, 11, 12, 13, 14,
	 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2gc_n_txpwrtrk_type4_8814c[]    = {
	0, 1, 2, 3, 3, 4, 5, 6, 7, 8, 8, 9, 10, 11, 12, 13, 13,
	 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14};
const u8 delta_swingidx_mp_2gc_p_txpwrtrk_type4_8814c[]    = {
	0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 11, 12, 13,
	 14, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type4_8814c[]    = {
	0, 1, 2, 3, 4, 5, 5, 6, 7, 7, 8, 9, 11, 11, 12, 14, 14,
	 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type4_8814c[]    = {
	0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 11, 12, 13,
	 15, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type4_8814c[]    = {
	0, 1, 2, 3, 4, 5, 5, 6, 8, 8, 9, 10, 11, 12, 13, 14,
	 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type4_8814c[]    = {
	0, 1, 2, 2, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13, 14,
	 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2g_cck_d_n_txpwrtrk_type4_8814c[] = {
	0, 1, 2, 3, 4, 5, 6, 6, 7, 8, 8, 9, 10, 11, 11, 11, 12,
	 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
const u8 delta_swingidx_mp_2g_cck_d_p_txpwrtrk_type4_8814c[] = {
	1, 2, 3, 3, 4, 5, 6, 7, 9, 9, 10, 11, 12, 13, 14, 15,
	 16, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_c_n_txpwrtrk_type4_8814c[] = {
	0, 1, 2, 3, 4, 5, 6, 7, 7, 8, 9, 9, 10, 11, 11, 12, 12,
	 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13};
const u8 delta_swingidx_mp_2g_cck_c_p_txpwrtrk_type4_8814c[] = {
	1, 2, 3, 3, 4, 6, 6, 7, 9, 9, 10, 11, 12, 12, 13, 14,
	 15, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type4_8814c[] = {
	0, 1, 2, 3, 4, 5, 6, 6, 7, 8, 9, 10, 10, 11, 11, 12,
	 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type4_8814c[] = {
	1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 11, 12, 13, 14, 16,
	 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type4_8814c[] = {
	0, 1, 2, 3, 3, 4, 6, 6, 7, 8, 8, 9, 10, 10, 10, 12, 13,
	 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type4_8814c[] = {
	1, 3, 3, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 14, 15, 16,
	 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
#endif

void
odm_read_and_config_mp_8814c_txpowertrack_type4(struct dm_struct *dm)
{
#ifdef CONFIG_8814C_TYPE4

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8814c\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type4_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type4_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type4_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type4_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gc_p,
		(void *)delta_swingidx_mp_2gc_p_txpwrtrk_type4_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gc_n,
		(void *)delta_swingidx_mp_2gc_n_txpwrtrk_type4_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gd_p,
		(void *)delta_swingidx_mp_2gd_p_txpwrtrk_type4_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gd_n,
		(void *)delta_swingidx_mp_2gd_n_txpwrtrk_type4_8814c,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type4_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type4_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type4_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type4_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_c_p,
		(void *)delta_swingidx_mp_2g_cck_c_p_txpwrtrk_type4_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_c_n,
		(void *)delta_swingidx_mp_2g_cck_c_n_txpwrtrk_type4_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_d_p,
		(void *)delta_swingidx_mp_2g_cck_d_p_txpwrtrk_type4_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_d_n,
		(void *)delta_swingidx_mp_2g_cck_d_n_txpwrtrk_type4_8814c,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type4_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type4_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type4_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type4_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gc_p,
		(void *)delta_swingidx_mp_5gc_p_txpwrtrk_type4_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gc_n,
		(void *)delta_swingidx_mp_5gc_n_txpwrtrk_type4_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gd_p,
		(void *)delta_swingidx_mp_5gd_p_txpwrtrk_type4_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gd_n,
		(void *)delta_swingidx_mp_5gd_n_txpwrtrk_type4_8814c,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type5.TXT
 ******************************************************************************/

#ifdef CONFIG_8814C_TYPE5
const u8 delta_swingidx_mp_5gd_n_txpwrtrk_type5_8814c[][D_S_SIZE] = {
	{1, 3, 5, 5, 6, 7, 9, 11, 12, 13, 15, 15, 16, 18, 19, 20,
	 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20},
	{1, 3, 5, 6, 6, 8, 9, 11, 12, 13, 15, 16, 17, 18, 20, 20,
	 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20},
	{1, 3, 5, 7, 8, 10, 11, 12, 13, 14, 15, 16, 17, 19, 20, 21,
	 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21},
};

const u8 delta_swingidx_mp_5gd_p_txpwrtrk_type5_8814c[][D_S_SIZE] = {
	{1, 2, 3, 5, 6, 7, 8, 10, 12, 14, 16, 17, 19, 20, 22, 24,
	 25, 27, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29},
	{1, 2, 3, 5, 6, 7, 8, 11, 12, 14, 16, 18, 20, 21, 23, 24,
	 26, 28, 29, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31},
	{1, 2, 3, 5, 6, 7, 9, 11, 12, 14, 17, 18, 20, 21, 23, 24,
	 26, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29},
};

const u8 delta_swingidx_mp_5gc_n_txpwrtrk_type5_8814c[][D_S_SIZE] = {
	{1, 3, 5, 5, 6, 7, 9, 11, 12, 13, 15, 15, 16, 18, 18, 19,
	 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19},
	{1, 2, 4, 5, 7, 9, 10, 11, 11, 12, 14, 15, 16, 17, 18, 19,
	 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19},
	{1, 3, 5, 7, 8, 10, 11, 12, 12, 13, 15, 16, 17, 18, 20, 21,
	 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21},
};

const u8 delta_swingidx_mp_5gc_p_txpwrtrk_type5_8814c[][D_S_SIZE] = {
	{1, 2, 3, 5, 6, 7, 9, 10, 12, 14, 16, 17, 19, 20, 22, 23,
	 25, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29},
	{1, 2, 3, 5, 6, 7, 9, 11, 12, 14, 16, 17, 19, 20, 22, 23,
	 24, 27, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29},
	{1, 2, 3, 6, 7, 8, 9, 11, 12, 14, 17, 18, 20, 21, 23, 24,
	 26, 29, 31, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32},
};

const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type5_8814c[][D_S_SIZE] = {
	{1, 3, 4, 6, 8, 9, 10, 12, 12, 13, 15, 15, 16, 18, 19, 20,
	 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20},
	{1, 2, 4, 5, 7, 9, 10, 11, 11, 12, 14, 15, 16, 17, 18, 19,
	 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19},
	{1, 3, 5, 7, 8, 10, 11, 12, 12, 13, 15, 16, 17, 18, 20, 21,
	 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type5_8814c[][D_S_SIZE] = {
	{1, 2, 3, 4, 5, 6, 8, 10, 11, 13, 15, 16, 18, 20, 22, 23,
	 24, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28},
	{1, 2, 3, 4, 5, 7, 9, 11, 12, 14, 15, 16, 19, 21, 22, 23,
	 25, 27, 28, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30},
	{1, 2, 3, 4, 5, 7, 9, 11, 12, 14, 15, 16, 19, 21, 23, 24,
	 26, 27, 28, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type5_8814c[][D_S_SIZE] = {
	{1, 4, 5, 5, 7, 9, 10, 11, 11, 12, 14, 14, 15, 17, 19, 19,
	 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19},
	{1, 3, 4, 5, 6, 8, 9, 10, 12, 12, 13, 14, 15, 16, 18, 18,
	 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18},
	{1, 4, 5, 6, 7, 9, 10, 11, 13, 14, 15, 16, 17, 18, 20, 20,
	 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type5_8814c[][D_S_SIZE] = {
	{1, 2, 3, 4, 5, 6, 8, 10, 11, 13, 14, 15, 18, 19, 21, 22,
	 24, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27},
	{1, 2, 3, 4, 5, 6, 8, 10, 11, 13, 14, 15, 18, 19, 21, 22,
	 24, 25, 26, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28},
	{1, 2, 3, 4, 5, 7, 9, 11, 12, 14, 15, 16, 19, 21, 23, 24,
	 25, 26, 28, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31},
};

const u8 delta_swingidx_mp_2gd_n_txpwrtrk_type5_8814c[]    = {
	0, 1, 2, 4, 4, 5, 5, 6, 8, 9, 9, 10, 10, 11, 13, 14,
	 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15};
const u8 delta_swingidx_mp_2gd_p_txpwrtrk_type5_8814c[]    = {
	0, 0, 1, 2, 4, 4, 5, 7, 8, 9, 9, 10, 11, 12, 13, 14,
	 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2gc_n_txpwrtrk_type5_8814c[]    = {
	0, 1, 2, 3, 3, 4, 5, 6, 7, 8, 8, 9, 10, 11, 12, 13, 13,
	 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14};
const u8 delta_swingidx_mp_2gc_p_txpwrtrk_type5_8814c[]    = {
	0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 11, 12, 13,
	 14, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type5_8814c[]    = {
	0, 1, 2, 3, 4, 5, 5, 6, 7, 7, 8, 9, 11, 11, 12, 14, 14,
	 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type5_8814c[]    = {
	0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 11, 12, 13,
	 15, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type5_8814c[]    = {
	0, 1, 2, 3, 4, 5, 5, 6, 8, 8, 9, 10, 11, 12, 13, 14,
	 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type5_8814c[]    = {
	0, 1, 2, 2, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13, 14,
	 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2g_cck_d_n_txpwrtrk_type5_8814c[] = {
	0, 1, 2, 3, 4, 5, 6, 6, 7, 8, 8, 9, 10, 11, 11, 11, 12,
	 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
const u8 delta_swingidx_mp_2g_cck_d_p_txpwrtrk_type5_8814c[] = {
	1, 2, 3, 3, 4, 5, 6, 7, 9, 9, 10, 11, 12, 13, 14, 15,
	 16, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_c_n_txpwrtrk_type5_8814c[] = {
	0, 1, 2, 3, 4, 5, 6, 7, 7, 8, 9, 9, 10, 11, 11, 12, 12,
	 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13};
const u8 delta_swingidx_mp_2g_cck_c_p_txpwrtrk_type5_8814c[] = {
	1, 2, 3, 3, 4, 6, 6, 7, 9, 9, 10, 11, 12, 12, 13, 14,
	 15, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type5_8814c[] = {
	0, 1, 2, 3, 4, 5, 6, 6, 7, 8, 9, 10, 10, 11, 11, 12,
	 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type5_8814c[] = {
	1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 11, 12, 13, 14, 16,
	 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type5_8814c[] = {
	0, 1, 2, 3, 3, 4, 6, 6, 7, 8, 8, 9, 10, 10, 10, 12, 13,
	 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type5_8814c[] = {
	1, 3, 3, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 14, 15, 16,
	 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
#endif

void
odm_read_and_config_mp_8814c_txpowertrack_type5(struct dm_struct *dm)
{
#ifdef CONFIG_8814C_TYPE5

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8814c\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type5_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type5_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type5_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type5_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gc_p,
		(void *)delta_swingidx_mp_2gc_p_txpwrtrk_type5_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gc_n,
		(void *)delta_swingidx_mp_2gc_n_txpwrtrk_type5_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gd_p,
		(void *)delta_swingidx_mp_2gd_p_txpwrtrk_type5_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gd_n,
		(void *)delta_swingidx_mp_2gd_n_txpwrtrk_type5_8814c,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type5_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type5_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type5_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type5_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_c_p,
		(void *)delta_swingidx_mp_2g_cck_c_p_txpwrtrk_type5_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_c_n,
		(void *)delta_swingidx_mp_2g_cck_c_n_txpwrtrk_type5_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_d_p,
		(void *)delta_swingidx_mp_2g_cck_d_p_txpwrtrk_type5_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_d_n,
		(void *)delta_swingidx_mp_2g_cck_d_n_txpwrtrk_type5_8814c,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type5_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type5_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type5_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type5_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gc_p,
		(void *)delta_swingidx_mp_5gc_p_txpwrtrk_type5_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gc_n,
		(void *)delta_swingidx_mp_5gc_n_txpwrtrk_type5_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gd_p,
		(void *)delta_swingidx_mp_5gd_p_txpwrtrk_type5_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gd_n,
		(void *)delta_swingidx_mp_5gd_n_txpwrtrk_type5_8814c,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type6.TXT
 ******************************************************************************/

#ifdef CONFIG_8814C_TYPE6
const u8 delta_swingidx_mp_5gd_n_txpwrtrk_type6_8814c[][D_S_SIZE] = {
	{1, 3, 5, 5, 6, 7, 9, 11, 12, 13, 15, 15, 16, 18, 19, 20,
	 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20},
	{1, 3, 5, 6, 6, 8, 9, 11, 12, 13, 15, 16, 17, 18, 20, 20,
	 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20},
	{1, 3, 5, 7, 8, 10, 11, 12, 13, 14, 15, 16, 17, 19, 20, 21,
	 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21},
};

const u8 delta_swingidx_mp_5gd_p_txpwrtrk_type6_8814c[][D_S_SIZE] = {
	{1, 2, 3, 5, 6, 7, 8, 10, 12, 14, 16, 17, 19, 20, 22, 24,
	 25, 27, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29},
	{1, 2, 3, 5, 6, 7, 8, 11, 12, 14, 16, 18, 20, 21, 23, 24,
	 26, 28, 29, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31},
	{1, 2, 3, 5, 6, 7, 9, 11, 12, 14, 17, 18, 20, 21, 23, 24,
	 26, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29},
};

const u8 delta_swingidx_mp_5gc_n_txpwrtrk_type6_8814c[][D_S_SIZE] = {
	{1, 3, 5, 5, 6, 7, 9, 11, 12, 13, 15, 15, 16, 18, 18, 19,
	 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19},
	{1, 2, 4, 5, 7, 9, 10, 11, 11, 12, 14, 15, 16, 17, 18, 19,
	 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19},
	{1, 3, 5, 7, 8, 10, 11, 12, 12, 13, 15, 16, 17, 18, 20, 21,
	 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21},
};

const u8 delta_swingidx_mp_5gc_p_txpwrtrk_type6_8814c[][D_S_SIZE] = {
	{1, 2, 3, 5, 6, 7, 9, 10, 12, 14, 16, 17, 19, 20, 22, 23,
	 25, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29},
	{1, 2, 3, 5, 6, 7, 9, 11, 12, 14, 16, 17, 19, 20, 22, 23,
	 24, 27, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29},
	{1, 2, 3, 6, 7, 8, 9, 11, 12, 14, 17, 18, 20, 21, 23, 24,
	 26, 29, 31, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32},
};

const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type6_8814c[][D_S_SIZE] = {
	{1, 3, 4, 6, 8, 9, 10, 12, 12, 13, 15, 15, 16, 18, 19, 20,
	 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20},
	{1, 2, 4, 5, 7, 9, 10, 11, 11, 12, 14, 15, 16, 17, 18, 19,
	 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19},
	{1, 3, 5, 7, 8, 10, 11, 12, 12, 13, 15, 16, 17, 18, 20, 21,
	 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type6_8814c[][D_S_SIZE] = {
	{1, 2, 3, 4, 5, 6, 8, 10, 11, 13, 15, 16, 18, 20, 22, 23,
	 24, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28},
	{1, 2, 3, 4, 5, 7, 9, 11, 12, 14, 15, 16, 19, 21, 22, 23,
	 25, 27, 28, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30},
	{1, 2, 3, 4, 5, 7, 9, 11, 12, 14, 15, 16, 19, 21, 23, 24,
	 26, 27, 28, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type6_8814c[][D_S_SIZE] = {
	{1, 4, 5, 5, 7, 9, 10, 11, 11, 12, 14, 14, 15, 17, 19, 19,
	 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19},
	{1, 3, 4, 5, 6, 8, 9, 10, 12, 12, 13, 14, 15, 16, 18, 18,
	 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18},
	{1, 4, 5, 6, 7, 9, 10, 11, 13, 14, 15, 16, 17, 18, 20, 20,
	 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type6_8814c[][D_S_SIZE] = {
	{1, 2, 3, 4, 5, 6, 8, 10, 11, 13, 14, 15, 18, 19, 21, 22,
	 24, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27},
	{1, 2, 3, 4, 5, 6, 8, 10, 11, 13, 14, 15, 18, 19, 21, 22,
	 24, 25, 26, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28},
	{1, 2, 3, 4, 5, 7, 9, 11, 12, 14, 15, 16, 19, 21, 23, 24,
	 25, 26, 28, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31},
};

const u8 delta_swingidx_mp_2gd_n_txpwrtrk_type6_8814c[]    = {
	0, 1, 2, 4, 4, 5, 5, 6, 8, 9, 9, 10, 10, 11, 13, 14,
	 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15};
const u8 delta_swingidx_mp_2gd_p_txpwrtrk_type6_8814c[]    = {
	0, 0, 1, 2, 4, 4, 5, 7, 8, 9, 9, 10, 11, 12, 13, 14,
	 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2gc_n_txpwrtrk_type6_8814c[]    = {
	0, 1, 2, 3, 3, 4, 5, 6, 7, 8, 8, 9, 10, 11, 12, 13, 13,
	 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14};
const u8 delta_swingidx_mp_2gc_p_txpwrtrk_type6_8814c[]    = {
	0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 11, 12, 13,
	 14, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type6_8814c[]    = {
	0, 1, 2, 3, 4, 5, 5, 6, 7, 7, 8, 9, 11, 11, 12, 14, 14,
	 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type6_8814c[]    = {
	0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 11, 12, 13,
	 15, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type6_8814c[]    = {
	0, 1, 2, 3, 4, 5, 5, 6, 8, 8, 9, 10, 11, 12, 13, 14,
	 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type6_8814c[]    = {
	0, 1, 2, 2, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13, 14,
	 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2g_cck_d_n_txpwrtrk_type6_8814c[] = {
	0, 1, 2, 3, 4, 5, 6, 6, 7, 8, 8, 9, 10, 11, 11, 11, 12,
	 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
const u8 delta_swingidx_mp_2g_cck_d_p_txpwrtrk_type6_8814c[] = {
	1, 2, 3, 3, 4, 5, 6, 7, 9, 9, 10, 11, 12, 13, 14, 15,
	 16, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_c_n_txpwrtrk_type6_8814c[] = {
	0, 1, 2, 3, 4, 5, 6, 7, 7, 8, 9, 9, 10, 11, 11, 12, 12,
	 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13};
const u8 delta_swingidx_mp_2g_cck_c_p_txpwrtrk_type6_8814c[] = {
	1, 2, 3, 3, 4, 6, 6, 7, 9, 9, 10, 11, 12, 12, 13, 14,
	 15, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type6_8814c[] = {
	0, 1, 2, 3, 4, 5, 6, 6, 7, 8, 9, 10, 10, 11, 11, 12,
	 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type6_8814c[] = {
	1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 11, 12, 13, 14, 16,
	 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type6_8814c[] = {
	0, 1, 2, 3, 3, 4, 6, 6, 7, 8, 8, 9, 10, 10, 10, 12, 13,
	 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type6_8814c[] = {
	1, 3, 3, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 14, 15, 16,
	 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
#endif

void
odm_read_and_config_mp_8814c_txpowertrack_type6(struct dm_struct *dm)
{
#ifdef CONFIG_8814C_TYPE6

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8814c\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type6_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type6_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type6_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type6_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gc_p,
		(void *)delta_swingidx_mp_2gc_p_txpwrtrk_type6_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gc_n,
		(void *)delta_swingidx_mp_2gc_n_txpwrtrk_type6_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gd_p,
		(void *)delta_swingidx_mp_2gd_p_txpwrtrk_type6_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gd_n,
		(void *)delta_swingidx_mp_2gd_n_txpwrtrk_type6_8814c,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type6_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type6_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type6_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type6_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_c_p,
		(void *)delta_swingidx_mp_2g_cck_c_p_txpwrtrk_type6_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_c_n,
		(void *)delta_swingidx_mp_2g_cck_c_n_txpwrtrk_type6_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_d_p,
		(void *)delta_swingidx_mp_2g_cck_d_p_txpwrtrk_type6_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_d_n,
		(void *)delta_swingidx_mp_2g_cck_d_n_txpwrtrk_type6_8814c,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type6_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type6_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type6_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type6_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gc_p,
		(void *)delta_swingidx_mp_5gc_p_txpwrtrk_type6_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gc_n,
		(void *)delta_swingidx_mp_5gc_n_txpwrtrk_type6_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gd_p,
		(void *)delta_swingidx_mp_5gd_p_txpwrtrk_type6_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gd_n,
		(void *)delta_swingidx_mp_5gd_n_txpwrtrk_type6_8814c,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type8.TXT
 ******************************************************************************/

#ifdef CONFIG_8814C_TYPE8
const u8 delta_swingidx_mp_5gd_n_txpwrtrk_type8_8814c[][D_S_SIZE] = {
	{0, 2, 3, 4, 5, 5, 6, 6, 7, 10, 10, 10, 11, 11, 12, 13,
	 14, 15, 15, 15, 16, 16, 17, 17, 18, 18, 19, 19, 19},
	{0, 1, 1, 2, 2, 3, 6, 6, 7, 7, 8, 8, 10, 10, 12, 12, 12,
	 13, 13, 13, 15, 16, 16, 16, 17, 17, 17, 18, 18},
	{0, 1, 1, 1, 3, 5, 5, 5, 6, 7, 8, 9, 10, 10, 11, 11, 11,
	 12, 12, 15, 15, 16, 16, 17, 17, 18, 18, 19, 19},
};

const u8 delta_swingidx_mp_5gd_p_txpwrtrk_type8_8814c[][D_S_SIZE] = {
	{0, 1, 2, 3, 3, 4, 5, 7, 8, 8, 8, 11, 12, 13, 13, 13,
	 14, 15, 16, 18, 18, 19, 19, 19, 20, 20, 20, 21, 21},
	{0, 2, 4, 5, 6, 6, 7, 8, 10, 10, 11, 12, 13, 15, 15, 16,
	 16, 17, 18, 19, 20, 21, 21, 22, 22, 22, 22, 22, 22},
	{0, 1, 2, 4, 5, 6, 6, 7, 8, 10, 11, 12, 12, 13, 13, 14,
	 15, 15, 16, 16, 18, 20, 21, 22, 22, 22, 23, 23, 23},
};

const u8 delta_swingidx_mp_5gc_n_txpwrtrk_type8_8814c[][D_S_SIZE] = {
	{0, 2, 3, 4, 4, 4, 5, 6, 8, 9, 9, 9, 10, 10, 11, 12, 13,
	 13, 14, 14, 15, 15, 16, 16, 17, 17, 18, 18, 18},
	{0, 2, 3, 4, 4, 5, 6, 7, 8, 9, 10, 10, 11, 13, 14, 14,
	 14, 14, 17, 18, 19, 19, 19, 20, 20, 21, 21, 22, 22},
	{0, 1, 1, 2, 2, 3, 5, 5, 6, 7, 7, 8, 11, 11, 12, 12, 13,
	 15, 15, 16, 16, 17, 17, 17, 18, 18, 18, 19, 19},
};

const u8 delta_swingidx_mp_5gc_p_txpwrtrk_type8_8814c[][D_S_SIZE] = {
	{0, 1, 3, 3, 5, 6, 6, 7, 8, 8, 8, 11, 12, 13, 13, 13,
	 14, 15, 15, 18, 18, 19, 19, 19, 20, 20, 20, 21, 21},
	{0, 1, 3, 5, 6, 7, 7, 8, 9, 9, 12, 13, 13, 13, 14, 14,
	 15, 16, 17, 18, 19, 19, 20, 20, 21, 21, 22, 22, 22},
	{0, 1, 2, 3, 3, 3, 5, 7, 8, 8, 8, 10, 11, 13, 13, 14,
	 14, 16, 17, 18, 19, 19, 20, 20, 20, 21, 21, 21, 22},
};

const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type8_8814c[][D_S_SIZE] = {
	{0, 1, 1, 1, 3, 5, 6, 6, 6, 7, 8, 9, 10, 10, 11, 11, 12,
	 15, 15, 15, 16, 16, 17, 17, 18, 18, 19, 19, 19},
	{0, 2, 3, 4, 4, 5, 6, 7, 8, 9, 10, 10, 11, 13, 14, 14,
	 14, 14, 17, 18, 19, 19, 19, 20, 20, 21, 21, 22, 22},
	{0, 1, 1, 2, 2, 3, 5, 5, 6, 7, 7, 8, 11, 11, 12, 12, 13,
	 15, 15, 16, 16, 17, 17, 17, 18, 18, 18, 19, 19},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type8_8814c[][D_S_SIZE] = {
	{0, 1, 2, 3, 4, 6, 6, 7, 8, 8, 9, 12, 12, 13, 13, 14,
	 16, 16, 16, 17, 18, 19, 21, 21, 21, 22, 22, 22, 22},
	{0, 1, 2, 3, 3, 4, 5, 7, 8, 8, 9, 9, 11, 13, 13, 13, 14,
	 15, 16, 17, 18, 18, 19, 19, 19, 20, 20, 21, 21},
	{0, 1, 3, 4, 5, 6, 6, 7, 10, 10, 11, 12, 12, 13, 14, 15,
	 15, 16, 16, 17, 19, 20, 22, 22, 22, 23, 23, 23, 24},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type8_8814c[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 2, 5, 5, 6, 7, 8, 8, 9, 9, 10, 10, 11,
	 12, 12, 13, 13, 13, 14, 14, 15, 15, 16, 16, 17},
	{0, 1, 1, 2, 2, 5, 5, 6, 6, 9, 10, 10, 11, 11, 11, 13,
	 14, 14, 15, 15, 16, 16, 17, 17, 18, 18, 19, 19, 19},
	{0, 1, 2, 4, 4, 5, 6, 6, 7, 9, 10, 10, 11, 12, 13, 14,
	 15, 16, 18, 18, 19, 19, 19, 20, 20, 20, 21, 21, 21},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type8_8814c[][D_S_SIZE] = {
	{0, 3, 5, 5, 6, 6, 7, 7, 10, 10, 11, 11, 12, 12, 12, 14,
	 15, 15, 15, 16, 17, 18, 20, 21, 21, 22, 22, 22, 22},
	{0, 1, 2, 3, 5, 6, 6, 7, 8, 8, 8, 11, 11, 12, 12, 13,
	 14, 14, 15, 16, 17, 17, 18, 18, 18, 19, 19, 20, 20},
	{0, 1, 2, 3, 5, 6, 6, 7, 8, 8, 9, 11, 11, 12, 13, 14,
	 15, 15, 16, 18, 19, 20, 20, 20, 21, 21, 21, 22, 22},
};

const u8 delta_swingidx_mp_2gd_n_txpwrtrk_type8_8814c[]    = {
	0, 1, 2, 4, 4, 5, 5, 6, 8, 9, 9, 10, 10, 11, 13, 14,
	 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15};
const u8 delta_swingidx_mp_2gd_p_txpwrtrk_type8_8814c[]    = {
	0, 0, 1, 2, 4, 4, 5, 7, 8, 9, 9, 10, 11, 12, 13, 14,
	 16, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2gc_n_txpwrtrk_type8_8814c[]    = {
	0, 1, 2, 3, 3, 4, 5, 6, 7, 8, 8, 9, 10, 11, 12, 13, 13,
	 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14};
const u8 delta_swingidx_mp_2gc_p_txpwrtrk_type8_8814c[]    = {
	0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 11, 12, 13,
	 14, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type8_8814c[]    = {
	0, 1, 2, 3, 4, 5, 5, 6, 7, 7, 8, 9, 11, 11, 12, 14, 14,
	 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type8_8814c[]    = {
	0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 11, 12, 13,
	 15, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type8_8814c[]    = {
	0, 1, 2, 3, 4, 5, 5, 6, 8, 8, 9, 10, 11, 12, 13, 14,
	 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type8_8814c[]    = {
	0, 1, 2, 2, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13, 14,
	 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2g_cck_d_n_txpwrtrk_type8_8814c[] = {
	0, 1, 2, 3, 4, 5, 6, 6, 7, 8, 8, 9, 10, 11, 11, 11, 12,
	 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
const u8 delta_swingidx_mp_2g_cck_d_p_txpwrtrk_type8_8814c[] = {
	1, 2, 3, 3, 4, 5, 6, 7, 9, 9, 10, 11, 12, 13, 14, 15,
	 16, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_c_n_txpwrtrk_type8_8814c[] = {
	0, 1, 2, 3, 4, 5, 6, 7, 7, 8, 9, 9, 10, 11, 11, 12, 12,
	 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13};
const u8 delta_swingidx_mp_2g_cck_c_p_txpwrtrk_type8_8814c[] = {
	1, 2, 3, 3, 4, 6, 6, 7, 9, 9, 10, 11, 12, 12, 13, 14,
	 15, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type8_8814c[] = {
	0, 1, 2, 3, 4, 5, 6, 6, 7, 8, 9, 10, 10, 11, 11, 12,
	 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type8_8814c[] = {
	1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 11, 12, 13, 14, 16,
	 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type8_8814c[] = {
	0, 1, 2, 3, 3, 4, 6, 6, 7, 8, 8, 9, 10, 10, 10, 12, 13,
	 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type8_8814c[] = {
	1, 3, 3, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 14, 15, 16,
	 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
#endif

void
odm_read_and_config_mp_8814c_txpowertrack_type8(struct dm_struct *dm)
{
#ifdef CONFIG_8814C_TYPE8

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8814c\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type8_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type8_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type8_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type8_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gc_p,
		(void *)delta_swingidx_mp_2gc_p_txpwrtrk_type8_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gc_n,
		(void *)delta_swingidx_mp_2gc_n_txpwrtrk_type8_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gd_p,
		(void *)delta_swingidx_mp_2gd_p_txpwrtrk_type8_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gd_n,
		(void *)delta_swingidx_mp_2gd_n_txpwrtrk_type8_8814c,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type8_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type8_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type8_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type8_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_c_p,
		(void *)delta_swingidx_mp_2g_cck_c_p_txpwrtrk_type8_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_c_n,
		(void *)delta_swingidx_mp_2g_cck_c_n_txpwrtrk_type8_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_d_p,
		(void *)delta_swingidx_mp_2g_cck_d_p_txpwrtrk_type8_8814c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_d_n,
		(void *)delta_swingidx_mp_2g_cck_d_n_txpwrtrk_type8_8814c,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type8_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type8_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type8_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type8_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gc_p,
		(void *)delta_swingidx_mp_5gc_p_txpwrtrk_type8_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gc_n,
		(void *)delta_swingidx_mp_5gc_n_txpwrtrk_type8_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gd_p,
		(void *)delta_swingidx_mp_5gd_p_txpwrtrk_type8_8814c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gd_n,
		(void *)delta_swingidx_mp_5gd_n_txpwrtrk_type8_8814c,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpwr_lmt.TXT
 ******************************************************************************/

#ifdef CONFIG_8814C
const char *array_mp_8814c_txpwr_lmt[] = {
	"FCC", "2.4G", "20M", "CCK", "1T", "01", "40",
	"ETSI", "2.4G", "20M", "CCK", "1T", "01", "32",
	"MKK", "2.4G", "20M", "CCK", "1T", "01", "36",
	"FCC", "2.4G", "20M", "CCK", "1T", "02", "40",
	"ETSI", "2.4G", "20M", "CCK", "1T", "02", "32",
	"MKK", "2.4G", "20M", "CCK", "1T", "02", "36",
	"FCC", "2.4G", "20M", "CCK", "1T", "03", "40",
	"ETSI", "2.4G", "20M", "CCK", "1T", "03", "32",
	"MKK", "2.4G", "20M", "CCK", "1T", "03", "36",
	"FCC", "2.4G", "20M", "CCK", "1T", "04", "40",
	"ETSI", "2.4G", "20M", "CCK", "1T", "04", "32",
	"MKK", "2.4G", "20M", "CCK", "1T", "04", "36",
	"FCC", "2.4G", "20M", "CCK", "1T", "05", "40",
	"ETSI", "2.4G", "20M", "CCK", "1T", "05", "32",
	"MKK", "2.4G", "20M", "CCK", "1T", "05", "36",
	"FCC", "2.4G", "20M", "CCK", "1T", "06", "40",
	"ETSI", "2.4G", "20M", "CCK", "1T", "06", "32",
	"MKK", "2.4G", "20M", "CCK", "1T", "06", "36",
	"FCC", "2.4G", "20M", "CCK", "1T", "07", "40",
	"ETSI", "2.4G", "20M", "CCK", "1T", "07", "32",
	"MKK", "2.4G", "20M", "CCK", "1T", "07", "36",
	"FCC", "2.4G", "20M", "CCK", "1T", "08", "40",
	"ETSI", "2.4G", "20M", "CCK", "1T", "08", "32",
	"MKK", "2.4G", "20M", "CCK", "1T", "08", "36",
	"FCC", "2.4G", "20M", "CCK", "1T", "09", "40",
	"ETSI", "2.4G", "20M", "CCK", "1T", "09", "32",
	"MKK", "2.4G", "20M", "CCK", "1T", "09", "36",
	"FCC", "2.4G", "20M", "CCK", "1T", "10", "40",
	"ETSI", "2.4G", "20M", "CCK", "1T", "10", "32",
	"MKK", "2.4G", "20M", "CCK", "1T", "10", "36",
	"FCC", "2.4G", "20M", "CCK", "1T", "11", "40",
	"ETSI", "2.4G", "20M", "CCK", "1T", "11", "32",
	"MKK", "2.4G", "20M", "CCK", "1T", "11", "36",
	"FCC", "2.4G", "20M", "CCK", "1T", "12", "26",
	"ETSI", "2.4G", "20M", "CCK", "1T", "12", "32",
	"MKK", "2.4G", "20M", "CCK", "1T", "12", "36",
	"FCC", "2.4G", "20M", "CCK", "1T", "13", "18",
	"ETSI", "2.4G", "20M", "CCK", "1T", "13", "32",
	"MKK", "2.4G", "20M", "CCK", "1T", "13", "36",
	"FCC", "2.4G", "20M", "CCK", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "CCK", "1T", "14", "63",
	"MKK", "2.4G", "20M", "CCK", "1T", "14", "36",
	"FCC", "2.4G", "20M", "CCK", "2T", "01", "34",
	"ETSI", "2.4G", "20M", "CCK", "2T", "01", "26",
	"MKK", "2.4G", "20M", "CCK", "2T", "01", "30",
	"FCC", "2.4G", "20M", "CCK", "2T", "02", "34",
	"ETSI", "2.4G", "20M", "CCK", "2T", "02", "26",
	"MKK", "2.4G", "20M", "CCK", "2T", "02", "30",
	"FCC", "2.4G", "20M", "CCK", "2T", "03", "34",
	"ETSI", "2.4G", "20M", "CCK", "2T", "03", "26",
	"MKK", "2.4G", "20M", "CCK", "2T", "03", "30",
	"FCC", "2.4G", "20M", "CCK", "2T", "04", "34",
	"ETSI", "2.4G", "20M", "CCK", "2T", "04", "26",
	"MKK", "2.4G", "20M", "CCK", "2T", "04", "30",
	"FCC", "2.4G", "20M", "CCK", "2T", "05", "34",
	"ETSI", "2.4G", "20M", "CCK", "2T", "05", "26",
	"MKK", "2.4G", "20M", "CCK", "2T", "05", "30",
	"FCC", "2.4G", "20M", "CCK", "2T", "06", "34",
	"ETSI", "2.4G", "20M", "CCK", "2T", "06", "26",
	"MKK", "2.4G", "20M", "CCK", "2T", "06", "30",
	"FCC", "2.4G", "20M", "CCK", "2T", "07", "34",
	"ETSI", "2.4G", "20M", "CCK", "2T", "07", "26",
	"MKK", "2.4G", "20M", "CCK", "2T", "07", "30",
	"FCC", "2.4G", "20M", "CCK", "2T", "08", "34",
	"ETSI", "2.4G", "20M", "CCK", "2T", "08", "26",
	"MKK", "2.4G", "20M", "CCK", "2T", "08", "30",
	"FCC", "2.4G", "20M", "CCK", "2T", "09", "34",
	"ETSI", "2.4G", "20M", "CCK", "2T", "09", "26",
	"MKK", "2.4G", "20M", "CCK", "2T", "09", "30",
	"FCC", "2.4G", "20M", "CCK", "2T", "10", "34",
	"ETSI", "2.4G", "20M", "CCK", "2T", "10", "26",
	"MKK", "2.4G", "20M", "CCK", "2T", "10", "30",
	"FCC", "2.4G", "20M", "CCK", "2T", "11", "34",
	"ETSI", "2.4G", "20M", "CCK", "2T", "11", "26",
	"MKK", "2.4G", "20M", "CCK", "2T", "11", "30",
	"FCC", "2.4G", "20M", "CCK", "2T", "12", "26",
	"ETSI", "2.4G", "20M", "CCK", "2T", "12", "26",
	"MKK", "2.4G", "20M", "CCK", "2T", "12", "30",
	"FCC", "2.4G", "20M", "CCK", "2T", "13", "18",
	"ETSI", "2.4G", "20M", "CCK", "2T", "13", "26",
	"MKK", "2.4G", "20M", "CCK", "2T", "13", "30",
	"FCC", "2.4G", "20M", "CCK", "2T", "14", "63",
	"ETSI", "2.4G", "20M", "CCK", "2T", "14", "63",
	"MKK", "2.4G", "20M", "CCK", "2T", "14", "30",
	"FCC", "2.4G", "20M", "CCK", "3T", "01", "30",
	"ETSI", "2.4G", "20M", "CCK", "3T", "01", "22",
	"MKK", "2.4G", "20M", "CCK", "3T", "01", "26",
	"FCC", "2.4G", "20M", "CCK", "3T", "02", "30",
	"ETSI", "2.4G", "20M", "CCK", "3T", "02", "22",
	"MKK", "2.4G", "20M", "CCK", "3T", "02", "26",
	"FCC", "2.4G", "20M", "CCK", "3T", "03", "30",
	"ETSI", "2.4G", "20M", "CCK", "3T", "03", "22",
	"MKK", "2.4G", "20M", "CCK", "3T", "03", "26",
	"FCC", "2.4G", "20M", "CCK", "3T", "04", "30",
	"ETSI", "2.4G", "20M", "CCK", "3T", "04", "22",
	"MKK", "2.4G", "20M", "CCK", "3T", "04", "26",
	"FCC", "2.4G", "20M", "CCK", "3T", "05", "30",
	"ETSI", "2.4G", "20M", "CCK", "3T", "05", "22",
	"MKK", "2.4G", "20M", "CCK", "3T", "05", "26",
	"FCC", "2.4G", "20M", "CCK", "3T", "06", "30",
	"ETSI", "2.4G", "20M", "CCK", "3T", "06", "22",
	"MKK", "2.4G", "20M", "CCK", "3T", "06", "26",
	"FCC", "2.4G", "20M", "CCK", "3T", "07", "30",
	"ETSI", "2.4G", "20M", "CCK", "3T", "07", "22",
	"MKK", "2.4G", "20M", "CCK", "3T", "07", "26",
	"FCC", "2.4G", "20M", "CCK", "3T", "08", "30",
	"ETSI", "2.4G", "20M", "CCK", "3T", "08", "22",
	"MKK", "2.4G", "20M", "CCK", "3T", "08", "26",
	"FCC", "2.4G", "20M", "CCK", "3T", "09", "30",
	"ETSI", "2.4G", "20M", "CCK", "3T", "09", "22",
	"MKK", "2.4G", "20M", "CCK", "3T", "09", "26",
	"FCC", "2.4G", "20M", "CCK", "3T", "10", "30",
	"ETSI", "2.4G", "20M", "CCK", "3T", "10", "22",
	"MKK", "2.4G", "20M", "CCK", "3T", "10", "26",
	"FCC", "2.4G", "20M", "CCK", "3T", "11", "30",
	"ETSI", "2.4G", "20M", "CCK", "3T", "11", "22",
	"MKK", "2.4G", "20M", "CCK", "3T", "11", "26",
	"FCC", "2.4G", "20M", "CCK", "3T", "12", "26",
	"ETSI", "2.4G", "20M", "CCK", "3T", "12", "22",
	"MKK", "2.4G", "20M", "CCK", "3T", "12", "26",
	"FCC", "2.4G", "20M", "CCK", "3T", "13", "18",
	"ETSI", "2.4G", "20M", "CCK", "3T", "13", "22",
	"MKK", "2.4G", "20M", "CCK", "3T", "13", "26",
	"FCC", "2.4G", "20M", "CCK", "3T", "14", "63",
	"ETSI", "2.4G", "20M", "CCK", "3T", "14", "63",
	"MKK", "2.4G", "20M", "CCK", "3T", "14", "26",
	"FCC", "2.4G", "20M", "CCK", "4T", "01", "28",
	"ETSI", "2.4G", "20M", "CCK", "4T", "01", "20",
	"MKK", "2.4G", "20M", "CCK", "4T", "01", "24",
	"FCC", "2.4G", "20M", "CCK", "4T", "02", "28",
	"ETSI", "2.4G", "20M", "CCK", "4T", "02", "20",
	"MKK", "2.4G", "20M", "CCK", "4T", "02", "24",
	"FCC", "2.4G", "20M", "CCK", "4T", "03", "28",
	"ETSI", "2.4G", "20M", "CCK", "4T", "03", "20",
	"MKK", "2.4G", "20M", "CCK", "4T", "03", "24",
	"FCC", "2.4G", "20M", "CCK", "4T", "04", "28",
	"ETSI", "2.4G", "20M", "CCK", "4T", "04", "20",
	"MKK", "2.4G", "20M", "CCK", "4T", "04", "24",
	"FCC", "2.4G", "20M", "CCK", "4T", "05", "28",
	"ETSI", "2.4G", "20M", "CCK", "4T", "05", "20",
	"MKK", "2.4G", "20M", "CCK", "4T", "05", "24",
	"FCC", "2.4G", "20M", "CCK", "4T", "06", "28",
	"ETSI", "2.4G", "20M", "CCK", "4T", "06", "20",
	"MKK", "2.4G", "20M", "CCK", "4T", "06", "24",
	"FCC", "2.4G", "20M", "CCK", "4T", "07", "28",
	"ETSI", "2.4G", "20M", "CCK", "4T", "07", "20",
	"MKK", "2.4G", "20M", "CCK", "4T", "07", "24",
	"FCC", "2.4G", "20M", "CCK", "4T", "08", "28",
	"ETSI", "2.4G", "20M", "CCK", "4T", "08", "20",
	"MKK", "2.4G", "20M", "CCK", "4T", "08", "24",
	"FCC", "2.4G", "20M", "CCK", "4T", "09", "28",
	"ETSI", "2.4G", "20M", "CCK", "4T", "09", "20",
	"MKK", "2.4G", "20M", "CCK", "4T", "09", "24",
	"FCC", "2.4G", "20M", "CCK", "4T", "10", "28",
	"ETSI", "2.4G", "20M", "CCK", "4T", "10", "20",
	"MKK", "2.4G", "20M", "CCK", "4T", "10", "24",
	"FCC", "2.4G", "20M", "CCK", "4T", "11", "28",
	"ETSI", "2.4G", "20M", "CCK", "4T", "11", "20",
	"MKK", "2.4G", "20M", "CCK", "4T", "11", "24",
	"FCC", "2.4G", "20M", "CCK", "4T", "12", "26",
	"ETSI", "2.4G", "20M", "CCK", "4T", "12", "20",
	"MKK", "2.4G", "20M", "CCK", "4T", "12", "24",
	"FCC", "2.4G", "20M", "CCK", "4T", "13", "18",
	"ETSI", "2.4G", "20M", "CCK", "4T", "13", "20",
	"MKK", "2.4G", "20M", "CCK", "4T", "13", "24",
	"FCC", "2.4G", "20M", "CCK", "4T", "14", "63",
	"ETSI", "2.4G", "20M", "CCK", "4T", "14", "63",
	"MKK", "2.4G", "20M", "CCK", "4T", "14", "24",
	"FCC", "2.4G", "20M", "OFDM", "1T", "01", "28",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "01", "32",
	"MKK", "2.4G", "20M", "OFDM", "1T", "01", "36",
	"FCC", "2.4G", "20M", "OFDM", "1T", "02", "40",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "02", "32",
	"MKK", "2.4G", "20M", "OFDM", "1T", "02", "36",
	"FCC", "2.4G", "20M", "OFDM", "1T", "03", "40",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "03", "32",
	"MKK", "2.4G", "20M", "OFDM", "1T", "03", "36",
	"FCC", "2.4G", "20M", "OFDM", "1T", "04", "40",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "04", "32",
	"MKK", "2.4G", "20M", "OFDM", "1T", "04", "36",
	"FCC", "2.4G", "20M", "OFDM", "1T", "05", "40",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "05", "32",
	"MKK", "2.4G", "20M", "OFDM", "1T", "05", "36",
	"FCC", "2.4G", "20M", "OFDM", "1T", "06", "40",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "06", "32",
	"MKK", "2.4G", "20M", "OFDM", "1T", "06", "36",
	"FCC", "2.4G", "20M", "OFDM", "1T", "07", "40",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "07", "32",
	"MKK", "2.4G", "20M", "OFDM", "1T", "07", "36",
	"FCC", "2.4G", "20M", "OFDM", "1T", "08", "40",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "08", "32",
	"MKK", "2.4G", "20M", "OFDM", "1T", "08", "36",
	"FCC", "2.4G", "20M", "OFDM", "1T", "09", "40",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "09", "32",
	"MKK", "2.4G", "20M", "OFDM", "1T", "09", "36",
	"FCC", "2.4G", "20M", "OFDM", "1T", "10", "40",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "10", "32",
	"MKK", "2.4G", "20M", "OFDM", "1T", "10", "36",
	"FCC", "2.4G", "20M", "OFDM", "1T", "11", "26",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "11", "32",
	"MKK", "2.4G", "20M", "OFDM", "1T", "11", "36",
	"FCC", "2.4G", "20M", "OFDM", "1T", "12", "20",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "12", "32",
	"MKK", "2.4G", "20M", "OFDM", "1T", "12", "36",
	"FCC", "2.4G", "20M", "OFDM", "1T", "13", "14",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "13", "32",
	"MKK", "2.4G", "20M", "OFDM", "1T", "13", "36",
	"FCC", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"MKK", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"FCC", "2.4G", "20M", "OFDM", "2T", "01", "28",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "01", "26",
	"MKK", "2.4G", "20M", "OFDM", "2T", "01", "30",
	"FCC", "2.4G", "20M", "OFDM", "2T", "02", "34",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "02", "26",
	"MKK", "2.4G", "20M", "OFDM", "2T", "02", "30",
	"FCC", "2.4G", "20M", "OFDM", "2T", "03", "34",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "03", "26",
	"MKK", "2.4G", "20M", "OFDM", "2T", "03", "30",
	"FCC", "2.4G", "20M", "OFDM", "2T", "04", "34",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "04", "26",
	"MKK", "2.4G", "20M", "OFDM", "2T", "04", "30",
	"FCC", "2.4G", "20M", "OFDM", "2T", "05", "34",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "05", "26",
	"MKK", "2.4G", "20M", "OFDM", "2T", "05", "30",
	"FCC", "2.4G", "20M", "OFDM", "2T", "06", "34",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "06", "26",
	"MKK", "2.4G", "20M", "OFDM", "2T", "06", "30",
	"FCC", "2.4G", "20M", "OFDM", "2T", "07", "34",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "07", "26",
	"MKK", "2.4G", "20M", "OFDM", "2T", "07", "30",
	"FCC", "2.4G", "20M", "OFDM", "2T", "08", "34",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "08", "26",
	"MKK", "2.4G", "20M", "OFDM", "2T", "08", "30",
	"FCC", "2.4G", "20M", "OFDM", "2T", "09", "34",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "09", "26",
	"MKK", "2.4G", "20M", "OFDM", "2T", "09", "30",
	"FCC", "2.4G", "20M", "OFDM", "2T", "10", "34",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "10", "26",
	"MKK", "2.4G", "20M", "OFDM", "2T", "10", "30",
	"FCC", "2.4G", "20M", "OFDM", "2T", "11", "26",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "11", "26",
	"MKK", "2.4G", "20M", "OFDM", "2T", "11", "30",
	"FCC", "2.4G", "20M", "OFDM", "2T", "12", "20",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "12", "26",
	"MKK", "2.4G", "20M", "OFDM", "2T", "12", "30",
	"FCC", "2.4G", "20M", "OFDM", "2T", "13", "14",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "13", "26",
	"MKK", "2.4G", "20M", "OFDM", "2T", "13", "30",
	"FCC", "2.4G", "20M", "OFDM", "2T", "14", "63",
	"ETSI", "2.4G", "20M", "OFDM", "2T", "14", "63",
	"MKK", "2.4G", "20M", "OFDM", "2T", "14", "63",
	"FCC", "2.4G", "20M", "OFDM", "3T", "01", "28",
	"ETSI", "2.4G", "20M", "OFDM", "3T", "01", "22",
	"MKK", "2.4G", "20M", "OFDM", "3T", "01", "26",
	"FCC", "2.4G", "20M", "OFDM", "3T", "02", "30",
	"ETSI", "2.4G", "20M", "OFDM", "3T", "02", "22",
	"MKK", "2.4G", "20M", "OFDM", "3T", "02", "26",
	"FCC", "2.4G", "20M", "OFDM", "3T", "03", "30",
	"ETSI", "2.4G", "20M", "OFDM", "3T", "03", "22",
	"MKK", "2.4G", "20M", "OFDM", "3T", "03", "26",
	"FCC", "2.4G", "20M", "OFDM", "3T", "04", "30",
	"ETSI", "2.4G", "20M", "OFDM", "3T", "04", "22",
	"MKK", "2.4G", "20M", "OFDM", "3T", "04", "26",
	"FCC", "2.4G", "20M", "OFDM", "3T", "05", "30",
	"ETSI", "2.4G", "20M", "OFDM", "3T", "05", "22",
	"MKK", "2.4G", "20M", "OFDM", "3T", "05", "26",
	"FCC", "2.4G", "20M", "OFDM", "3T", "06", "30",
	"ETSI", "2.4G", "20M", "OFDM", "3T", "06", "22",
	"MKK", "2.4G", "20M", "OFDM", "3T", "06", "26",
	"FCC", "2.4G", "20M", "OFDM", "3T", "07", "30",
	"ETSI", "2.4G", "20M", "OFDM", "3T", "07", "22",
	"MKK", "2.4G", "20M", "OFDM", "3T", "07", "26",
	"FCC", "2.4G", "20M", "OFDM", "3T", "08", "30",
	"ETSI", "2.4G", "20M", "OFDM", "3T", "08", "22",
	"MKK", "2.4G", "20M", "OFDM", "3T", "08", "26",
	"FCC", "2.4G", "20M", "OFDM", "3T", "09", "30",
	"ETSI", "2.4G", "20M", "OFDM", "3T", "09", "22",
	"MKK", "2.4G", "20M", "OFDM", "3T", "09", "26",
	"FCC", "2.4G", "20M", "OFDM", "3T", "10", "30",
	"ETSI", "2.4G", "20M", "OFDM", "3T", "10", "22",
	"MKK", "2.4G", "20M", "OFDM", "3T", "10", "26",
	"FCC", "2.4G", "20M", "OFDM", "3T", "11", "26",
	"ETSI", "2.4G", "20M", "OFDM", "3T", "11", "22",
	"MKK", "2.4G", "20M", "OFDM", "3T", "11", "26",
	"FCC", "2.4G", "20M", "OFDM", "3T", "12", "20",
	"ETSI", "2.4G", "20M", "OFDM", "3T", "12", "22",
	"MKK", "2.4G", "20M", "OFDM", "3T", "12", "26",
	"FCC", "2.4G", "20M", "OFDM", "3T", "13", "14",
	"ETSI", "2.4G", "20M", "OFDM", "3T", "13", "22",
	"MKK", "2.4G", "20M", "OFDM", "3T", "13", "26",
	"FCC", "2.4G", "20M", "OFDM", "3T", "14", "63",
	"ETSI", "2.4G", "20M", "OFDM", "3T", "14", "63",
	"MKK", "2.4G", "20M", "OFDM", "3T", "14", "63",
	"FCC", "2.4G", "20M", "OFDM", "4T", "01", "28",
	"ETSI", "2.4G", "20M", "OFDM", "4T", "01", "20",
	"MKK", "2.4G", "20M", "OFDM", "4T", "01", "24",
	"FCC", "2.4G", "20M", "OFDM", "4T", "02", "28",
	"ETSI", "2.4G", "20M", "OFDM", "4T", "02", "20",
	"MKK", "2.4G", "20M", "OFDM", "4T", "02", "24",
	"FCC", "2.4G", "20M", "OFDM", "4T", "03", "28",
	"ETSI", "2.4G", "20M", "OFDM", "4T", "03", "20",
	"MKK", "2.4G", "20M", "OFDM", "4T", "03", "24",
	"FCC", "2.4G", "20M", "OFDM", "4T", "04", "28",
	"ETSI", "2.4G", "20M", "OFDM", "4T", "04", "20",
	"MKK", "2.4G", "20M", "OFDM", "4T", "04", "24",
	"FCC", "2.4G", "20M", "OFDM", "4T", "05", "28",
	"ETSI", "2.4G", "20M", "OFDM", "4T", "05", "20",
	"MKK", "2.4G", "20M", "OFDM", "4T", "05", "24",
	"FCC", "2.4G", "20M", "OFDM", "4T", "06", "28",
	"ETSI", "2.4G", "20M", "OFDM", "4T", "06", "20",
	"MKK", "2.4G", "20M", "OFDM", "4T", "06", "24",
	"FCC", "2.4G", "20M", "OFDM", "4T", "07", "28",
	"ETSI", "2.4G", "20M", "OFDM", "4T", "07", "20",
	"MKK", "2.4G", "20M", "OFDM", "4T", "07", "24",
	"FCC", "2.4G", "20M", "OFDM", "4T", "08", "28",
	"ETSI", "2.4G", "20M", "OFDM", "4T", "08", "20",
	"MKK", "2.4G", "20M", "OFDM", "4T", "08", "24",
	"FCC", "2.4G", "20M", "OFDM", "4T", "09", "28",
	"ETSI", "2.4G", "20M", "OFDM", "4T", "09", "20",
	"MKK", "2.4G", "20M", "OFDM", "4T", "09", "24",
	"FCC", "2.4G", "20M", "OFDM", "4T", "10", "28",
	"ETSI", "2.4G", "20M", "OFDM", "4T", "10", "20",
	"MKK", "2.4G", "20M", "OFDM", "4T", "10", "24",
	"FCC", "2.4G", "20M", "OFDM", "4T", "11", "26",
	"ETSI", "2.4G", "20M", "OFDM", "4T", "11", "20",
	"MKK", "2.4G", "20M", "OFDM", "4T", "11", "24",
	"FCC", "2.4G", "20M", "OFDM", "4T", "12", "20",
	"ETSI", "2.4G", "20M", "OFDM", "4T", "12", "20",
	"MKK", "2.4G", "20M", "OFDM", "4T", "12", "24",
	"FCC", "2.4G", "20M", "OFDM", "4T", "13", "14",
	"ETSI", "2.4G", "20M", "OFDM", "4T", "13", "20",
	"MKK", "2.4G", "20M", "OFDM", "4T", "13", "24",
	"FCC", "2.4G", "20M", "OFDM", "4T", "14", "63",
	"ETSI", "2.4G", "20M", "OFDM", "4T", "14", "63",
	"MKK", "2.4G", "20M", "OFDM", "4T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "1T", "01", "30",
	"ETSI", "2.4G", "20M", "HT", "1T", "01", "32",
	"MKK", "2.4G", "20M", "HT", "1T", "01", "36",
	"FCC", "2.4G", "20M", "HT", "1T", "02", "40",
	"ETSI", "2.4G", "20M", "HT", "1T", "02", "32",
	"MKK", "2.4G", "20M", "HT", "1T", "02", "36",
	"FCC", "2.4G", "20M", "HT", "1T", "03", "40",
	"ETSI", "2.4G", "20M", "HT", "1T", "03", "32",
	"MKK", "2.4G", "20M", "HT", "1T", "03", "36",
	"FCC", "2.4G", "20M", "HT", "1T", "04", "40",
	"ETSI", "2.4G", "20M", "HT", "1T", "04", "32",
	"MKK", "2.4G", "20M", "HT", "1T", "04", "36",
	"FCC", "2.4G", "20M", "HT", "1T", "05", "40",
	"ETSI", "2.4G", "20M", "HT", "1T", "05", "32",
	"MKK", "2.4G", "20M", "HT", "1T", "05", "36",
	"FCC", "2.4G", "20M", "HT", "1T", "06", "40",
	"ETSI", "2.4G", "20M", "HT", "1T", "06", "32",
	"MKK", "2.4G", "20M", "HT", "1T", "06", "36",
	"FCC", "2.4G", "20M", "HT", "1T", "07", "40",
	"ETSI", "2.4G", "20M", "HT", "1T", "07", "32",
	"MKK", "2.4G", "20M", "HT", "1T", "07", "36",
	"FCC", "2.4G", "20M", "HT", "1T", "08", "40",
	"ETSI", "2.4G", "20M", "HT", "1T", "08", "32",
	"MKK", "2.4G", "20M", "HT", "1T", "08", "36",
	"FCC", "2.4G", "20M", "HT", "1T", "09", "40",
	"ETSI", "2.4G", "20M", "HT", "1T", "09", "32",
	"MKK", "2.4G", "20M", "HT", "1T", "09", "36",
	"FCC", "2.4G", "20M", "HT", "1T", "10", "40",
	"ETSI", "2.4G", "20M", "HT", "1T", "10", "32",
	"MKK", "2.4G", "20M", "HT", "1T", "10", "36",
	"FCC", "2.4G", "20M", "HT", "1T", "11", "30",
	"ETSI", "2.4G", "20M", "HT", "1T", "11", "32",
	"MKK", "2.4G", "20M", "HT", "1T", "11", "36",
	"FCC", "2.4G", "20M", "HT", "1T", "12", "63",
	"ETSI", "2.4G", "20M", "HT", "1T", "12", "32",
	"MKK", "2.4G", "20M", "HT", "1T", "12", "36",
	"FCC", "2.4G", "20M", "HT", "1T", "13", "63",
	"ETSI", "2.4G", "20M", "HT", "1T", "13", "32",
	"MKK", "2.4G", "20M", "HT", "1T", "13", "36",
	"FCC", "2.4G", "20M", "HT", "1T", "14", "63",
	"ETSI", "2.4G", "20M", "HT", "1T", "14", "63",
	"MKK", "2.4G", "20M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "2T", "01", "28",
	"ETSI", "2.4G", "20M", "HT", "2T", "01", "26",
	"MKK", "2.4G", "20M", "HT", "2T", "01", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "02", "34",
	"ETSI", "2.4G", "20M", "HT", "2T", "02", "26",
	"MKK", "2.4G", "20M", "HT", "2T", "02", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "03", "34",
	"ETSI", "2.4G", "20M", "HT", "2T", "03", "26",
	"MKK", "2.4G", "20M", "HT", "2T", "03", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "04", "34",
	"ETSI", "2.4G", "20M", "HT", "2T", "04", "26",
	"MKK", "2.4G", "20M", "HT", "2T", "04", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "05", "34",
	"ETSI", "2.4G", "20M", "HT", "2T", "05", "26",
	"MKK", "2.4G", "20M", "HT", "2T", "05", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "06", "34",
	"ETSI", "2.4G", "20M", "HT", "2T", "06", "26",
	"MKK", "2.4G", "20M", "HT", "2T", "06", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "07", "34",
	"ETSI", "2.4G", "20M", "HT", "2T", "07", "26",
	"MKK", "2.4G", "20M", "HT", "2T", "07", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "08", "34",
	"ETSI", "2.4G", "20M", "HT", "2T", "08", "26",
	"MKK", "2.4G", "20M", "HT", "2T", "08", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "09", "34",
	"ETSI", "2.4G", "20M", "HT", "2T", "09", "26",
	"MKK", "2.4G", "20M", "HT", "2T", "09", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "10", "34",
	"ETSI", "2.4G", "20M", "HT", "2T", "10", "26",
	"MKK", "2.4G", "20M", "HT", "2T", "10", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "11", "24",
	"ETSI", "2.4G", "20M", "HT", "2T", "11", "26",
	"MKK", "2.4G", "20M", "HT", "2T", "11", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "12", "63",
	"ETSI", "2.4G", "20M", "HT", "2T", "12", "26",
	"MKK", "2.4G", "20M", "HT", "2T", "12", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "13", "63",
	"ETSI", "2.4G", "20M", "HT", "2T", "13", "26",
	"MKK", "2.4G", "20M", "HT", "2T", "13", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "14", "63",
	"ETSI", "2.4G", "20M", "HT", "2T", "14", "63",
	"MKK", "2.4G", "20M", "HT", "2T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "3T", "01", "28",
	"ETSI", "2.4G", "20M", "HT", "3T", "01", "22",
	"MKK", "2.4G", "20M", "HT", "3T", "01", "26",
	"FCC", "2.4G", "20M", "HT", "3T", "02", "30",
	"ETSI", "2.4G", "20M", "HT", "3T", "02", "22",
	"MKK", "2.4G", "20M", "HT", "3T", "02", "26",
	"FCC", "2.4G", "20M", "HT", "3T", "03", "30",
	"ETSI", "2.4G", "20M", "HT", "3T", "03", "22",
	"MKK", "2.4G", "20M", "HT", "3T", "03", "26",
	"FCC", "2.4G", "20M", "HT", "3T", "04", "30",
	"ETSI", "2.4G", "20M", "HT", "3T", "04", "22",
	"MKK", "2.4G", "20M", "HT", "3T", "04", "26",
	"FCC", "2.4G", "20M", "HT", "3T", "05", "30",
	"ETSI", "2.4G", "20M", "HT", "3T", "05", "22",
	"MKK", "2.4G", "20M", "HT", "3T", "05", "26",
	"FCC", "2.4G", "20M", "HT", "3T", "06", "30",
	"ETSI", "2.4G", "20M", "HT", "3T", "06", "22",
	"MKK", "2.4G", "20M", "HT", "3T", "06", "26",
	"FCC", "2.4G", "20M", "HT", "3T", "07", "30",
	"ETSI", "2.4G", "20M", "HT", "3T", "07", "22",
	"MKK", "2.4G", "20M", "HT", "3T", "07", "26",
	"FCC", "2.4G", "20M", "HT", "3T", "08", "30",
	"ETSI", "2.4G", "20M", "HT", "3T", "08", "22",
	"MKK", "2.4G", "20M", "HT", "3T", "08", "26",
	"FCC", "2.4G", "20M", "HT", "3T", "09", "30",
	"ETSI", "2.4G", "20M", "HT", "3T", "09", "22",
	"MKK", "2.4G", "20M", "HT", "3T", "09", "26",
	"FCC", "2.4G", "20M", "HT", "3T", "10", "30",
	"ETSI", "2.4G", "20M", "HT", "3T", "10", "22",
	"MKK", "2.4G", "20M", "HT", "3T", "10", "26",
	"FCC", "2.4G", "20M", "HT", "3T", "11", "24",
	"ETSI", "2.4G", "20M", "HT", "3T", "11", "22",
	"MKK", "2.4G", "20M", "HT", "3T", "11", "26",
	"FCC", "2.4G", "20M", "HT", "3T", "12", "63",
	"ETSI", "2.4G", "20M", "HT", "3T", "12", "22",
	"MKK", "2.4G", "20M", "HT", "3T", "12", "26",
	"FCC", "2.4G", "20M", "HT", "3T", "13", "63",
	"ETSI", "2.4G", "20M", "HT", "3T", "13", "22",
	"MKK", "2.4G", "20M", "HT", "3T", "13", "26",
	"FCC", "2.4G", "20M", "HT", "3T", "14", "63",
	"ETSI", "2.4G", "20M", "HT", "3T", "14", "63",
	"MKK", "2.4G", "20M", "HT", "3T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "4T", "01", "28",
	"ETSI", "2.4G", "20M", "HT", "4T", "01", "20",
	"MKK", "2.4G", "20M", "HT", "4T", "01", "24",
	"FCC", "2.4G", "20M", "HT", "4T", "02", "28",
	"ETSI", "2.4G", "20M", "HT", "4T", "02", "20",
	"MKK", "2.4G", "20M", "HT", "4T", "02", "24",
	"FCC", "2.4G", "20M", "HT", "4T", "03", "28",
	"ETSI", "2.4G", "20M", "HT", "4T", "03", "20",
	"MKK", "2.4G", "20M", "HT", "4T", "03", "24",
	"FCC", "2.4G", "20M", "HT", "4T", "04", "28",
	"ETSI", "2.4G", "20M", "HT", "4T", "04", "20",
	"MKK", "2.4G", "20M", "HT", "4T", "04", "24",
	"FCC", "2.4G", "20M", "HT", "4T", "05", "28",
	"ETSI", "2.4G", "20M", "HT", "4T", "05", "20",
	"MKK", "2.4G", "20M", "HT", "4T", "05", "24",
	"FCC", "2.4G", "20M", "HT", "4T", "06", "28",
	"ETSI", "2.4G", "20M", "HT", "4T", "06", "20",
	"MKK", "2.4G", "20M", "HT", "4T", "06", "24",
	"FCC", "2.4G", "20M", "HT", "4T", "07", "28",
	"ETSI", "2.4G", "20M", "HT", "4T", "07", "20",
	"MKK", "2.4G", "20M", "HT", "4T", "07", "24",
	"FCC", "2.4G", "20M", "HT", "4T", "08", "28",
	"ETSI", "2.4G", "20M", "HT", "4T", "08", "20",
	"MKK", "2.4G", "20M", "HT", "4T", "08", "24",
	"FCC", "2.4G", "20M", "HT", "4T", "09", "28",
	"ETSI", "2.4G", "20M", "HT", "4T", "09", "20",
	"MKK", "2.4G", "20M", "HT", "4T", "09", "24",
	"FCC", "2.4G", "20M", "HT", "4T", "10", "28",
	"ETSI", "2.4G", "20M", "HT", "4T", "10", "20",
	"MKK", "2.4G", "20M", "HT", "4T", "10", "24",
	"FCC", "2.4G", "20M", "HT", "4T", "11", "24",
	"ETSI", "2.4G", "20M", "HT", "4T", "11", "20",
	"MKK", "2.4G", "20M", "HT", "4T", "11", "24",
	"FCC", "2.4G", "20M", "HT", "4T", "12", "63",
	"ETSI", "2.4G", "20M", "HT", "4T", "12", "20",
	"MKK", "2.4G", "20M", "HT", "4T", "12", "24",
	"FCC", "2.4G", "20M", "HT", "4T", "13", "63",
	"ETSI", "2.4G", "20M", "HT", "4T", "13", "20",
	"MKK", "2.4G", "20M", "HT", "4T", "13", "24",
	"FCC", "2.4G", "20M", "HT", "4T", "14", "63",
	"ETSI", "2.4G", "20M", "HT", "4T", "14", "63",
	"MKK", "2.4G", "20M", "HT", "4T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "01", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "01", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "02", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "02", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "03", "30",
	"ETSI", "2.4G", "40M", "HT", "1T", "03", "32",
	"MKK", "2.4G", "40M", "HT", "1T", "03", "36",
	"FCC", "2.4G", "40M", "HT", "1T", "04", "34",
	"ETSI", "2.4G", "40M", "HT", "1T", "04", "32",
	"MKK", "2.4G", "40M", "HT", "1T", "04", "36",
	"FCC", "2.4G", "40M", "HT", "1T", "05", "34",
	"ETSI", "2.4G", "40M", "HT", "1T", "05", "32",
	"MKK", "2.4G", "40M", "HT", "1T", "05", "36",
	"FCC", "2.4G", "40M", "HT", "1T", "06", "34",
	"ETSI", "2.4G", "40M", "HT", "1T", "06", "32",
	"MKK", "2.4G", "40M", "HT", "1T", "06", "36",
	"FCC", "2.4G", "40M", "HT", "1T", "07", "34",
	"ETSI", "2.4G", "40M", "HT", "1T", "07", "32",
	"MKK", "2.4G", "40M", "HT", "1T", "07", "36",
	"FCC", "2.4G", "40M", "HT", "1T", "08", "34",
	"ETSI", "2.4G", "40M", "HT", "1T", "08", "32",
	"MKK", "2.4G", "40M", "HT", "1T", "08", "36",
	"FCC", "2.4G", "40M", "HT", "1T", "09", "30",
	"ETSI", "2.4G", "40M", "HT", "1T", "09", "32",
	"MKK", "2.4G", "40M", "HT", "1T", "09", "36",
	"FCC", "2.4G", "40M", "HT", "1T", "10", "22",
	"ETSI", "2.4G", "40M", "HT", "1T", "10", "32",
	"MKK", "2.4G", "40M", "HT", "1T", "10", "36",
	"FCC", "2.4G", "40M", "HT", "1T", "11", "16",
	"ETSI", "2.4G", "40M", "HT", "1T", "11", "32",
	"MKK", "2.4G", "40M", "HT", "1T", "11", "36",
	"FCC", "2.4G", "40M", "HT", "1T", "12", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "12", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "12", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "13", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "13", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "13", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "14", "63",
	"ETSI", "2.4G", "40M", "HT", "1T", "14", "63",
	"MKK", "2.4G", "40M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "01", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "01", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "02", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "02", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "03", "26",
	"ETSI", "2.4G", "40M", "HT", "2T", "03", "26",
	"MKK", "2.4G", "40M", "HT", "2T", "03", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "04", "28",
	"ETSI", "2.4G", "40M", "HT", "2T", "04", "26",
	"MKK", "2.4G", "40M", "HT", "2T", "04", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "05", "28",
	"ETSI", "2.4G", "40M", "HT", "2T", "05", "26",
	"MKK", "2.4G", "40M", "HT", "2T", "05", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "06", "28",
	"ETSI", "2.4G", "40M", "HT", "2T", "06", "26",
	"MKK", "2.4G", "40M", "HT", "2T", "06", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "07", "28",
	"ETSI", "2.4G", "40M", "HT", "2T", "07", "26",
	"MKK", "2.4G", "40M", "HT", "2T", "07", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "08", "28",
	"ETSI", "2.4G", "40M", "HT", "2T", "08", "26",
	"MKK", "2.4G", "40M", "HT", "2T", "08", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "09", "24",
	"ETSI", "2.4G", "40M", "HT", "2T", "09", "26",
	"MKK", "2.4G", "40M", "HT", "2T", "09", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "10", "22",
	"ETSI", "2.4G", "40M", "HT", "2T", "10", "26",
	"MKK", "2.4G", "40M", "HT", "2T", "10", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "11", "16",
	"ETSI", "2.4G", "40M", "HT", "2T", "11", "26",
	"MKK", "2.4G", "40M", "HT", "2T", "11", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "12", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "12", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "12", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "13", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "13", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "13", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "14", "63",
	"ETSI", "2.4G", "40M", "HT", "2T", "14", "63",
	"MKK", "2.4G", "40M", "HT", "2T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "3T", "01", "63",
	"ETSI", "2.4G", "40M", "HT", "3T", "01", "63",
	"MKK", "2.4G", "40M", "HT", "3T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "3T", "02", "63",
	"ETSI", "2.4G", "40M", "HT", "3T", "02", "63",
	"MKK", "2.4G", "40M", "HT", "3T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "3T", "03", "26",
	"ETSI", "2.4G", "40M", "HT", "3T", "03", "22",
	"MKK", "2.4G", "40M", "HT", "3T", "03", "26",
	"FCC", "2.4G", "40M", "HT", "3T", "04", "28",
	"ETSI", "2.4G", "40M", "HT", "3T", "04", "22",
	"MKK", "2.4G", "40M", "HT", "3T", "04", "26",
	"FCC", "2.4G", "40M", "HT", "3T", "05", "28",
	"ETSI", "2.4G", "40M", "HT", "3T", "05", "22",
	"MKK", "2.4G", "40M", "HT", "3T", "05", "26",
	"FCC", "2.4G", "40M", "HT", "3T", "06", "28",
	"ETSI", "2.4G", "40M", "HT", "3T", "06", "22",
	"MKK", "2.4G", "40M", "HT", "3T", "06", "26",
	"FCC", "2.4G", "40M", "HT", "3T", "07", "28",
	"ETSI", "2.4G", "40M", "HT", "3T", "07", "22",
	"MKK", "2.4G", "40M", "HT", "3T", "07", "26",
	"FCC", "2.4G", "40M", "HT", "3T", "08", "28",
	"ETSI", "2.4G", "40M", "HT", "3T", "08", "22",
	"MKK", "2.4G", "40M", "HT", "3T", "08", "26",
	"FCC", "2.4G", "40M", "HT", "3T", "09", "24",
	"ETSI", "2.4G", "40M", "HT", "3T", "09", "22",
	"MKK", "2.4G", "40M", "HT", "3T", "09", "26",
	"FCC", "2.4G", "40M", "HT", "3T", "10", "22",
	"ETSI", "2.4G", "40M", "HT", "3T", "10", "22",
	"MKK", "2.4G", "40M", "HT", "3T", "10", "26",
	"FCC", "2.4G", "40M", "HT", "3T", "11", "16",
	"ETSI", "2.4G", "40M", "HT", "3T", "11", "22",
	"MKK", "2.4G", "40M", "HT", "3T", "11", "26",
	"FCC", "2.4G", "40M", "HT", "3T", "12", "63",
	"ETSI", "2.4G", "40M", "HT", "3T", "12", "63",
	"MKK", "2.4G", "40M", "HT", "3T", "12", "63",
	"FCC", "2.4G", "40M", "HT", "3T", "13", "63",
	"ETSI", "2.4G", "40M", "HT", "3T", "13", "63",
	"MKK", "2.4G", "40M", "HT", "3T", "13", "63",
	"FCC", "2.4G", "40M", "HT", "3T", "14", "63",
	"ETSI", "2.4G", "40M", "HT", "3T", "14", "63",
	"MKK", "2.4G", "40M", "HT", "3T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "4T", "01", "63",
	"ETSI", "2.4G", "40M", "HT", "4T", "01", "63",
	"MKK", "2.4G", "40M", "HT", "4T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "4T", "02", "63",
	"ETSI", "2.4G", "40M", "HT", "4T", "02", "63",
	"MKK", "2.4G", "40M", "HT", "4T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "4T", "03", "26",
	"ETSI", "2.4G", "40M", "HT", "4T", "03", "20",
	"MKK", "2.4G", "40M", "HT", "4T", "03", "24",
	"FCC", "2.4G", "40M", "HT", "4T", "04", "28",
	"ETSI", "2.4G", "40M", "HT", "4T", "04", "20",
	"MKK", "2.4G", "40M", "HT", "4T", "04", "24",
	"FCC", "2.4G", "40M", "HT", "4T", "05", "28",
	"ETSI", "2.4G", "40M", "HT", "4T", "05", "20",
	"MKK", "2.4G", "40M", "HT", "4T", "05", "24",
	"FCC", "2.4G", "40M", "HT", "4T", "06", "28",
	"ETSI", "2.4G", "40M", "HT", "4T", "06", "20",
	"MKK", "2.4G", "40M", "HT", "4T", "06", "24",
	"FCC", "2.4G", "40M", "HT", "4T", "07", "28",
	"ETSI", "2.4G", "40M", "HT", "4T", "07", "20",
	"MKK", "2.4G", "40M", "HT", "4T", "07", "24",
	"FCC", "2.4G", "40M", "HT", "4T", "08", "28",
	"ETSI", "2.4G", "40M", "HT", "4T", "08", "20",
	"MKK", "2.4G", "40M", "HT", "4T", "08", "24",
	"FCC", "2.4G", "40M", "HT", "4T", "09", "24",
	"ETSI", "2.4G", "40M", "HT", "4T", "09", "20",
	"MKK", "2.4G", "40M", "HT", "4T", "09", "24",
	"FCC", "2.4G", "40M", "HT", "4T", "10", "22",
	"ETSI", "2.4G", "40M", "HT", "4T", "10", "20",
	"MKK", "2.4G", "40M", "HT", "4T", "10", "24",
	"FCC", "2.4G", "40M", "HT", "4T", "11", "16",
	"ETSI", "2.4G", "40M", "HT", "4T", "11", "20",
	"MKK", "2.4G", "40M", "HT", "4T", "11", "24",
	"FCC", "2.4G", "40M", "HT", "4T", "12", "63",
	"ETSI", "2.4G", "40M", "HT", "4T", "12", "63",
	"MKK", "2.4G", "40M", "HT", "4T", "12", "63",
	"FCC", "2.4G", "40M", "HT", "4T", "13", "63",
	"ETSI", "2.4G", "40M", "HT", "4T", "13", "63",
	"MKK", "2.4G", "40M", "HT", "4T", "13", "63",
	"FCC", "2.4G", "40M", "HT", "4T", "14", "63",
	"ETSI", "2.4G", "40M", "HT", "4T", "14", "63",
	"MKK", "2.4G", "40M", "HT", "4T", "14", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "36", "36",
	"ETSI", "5G", "20M", "OFDM", "1T", "36", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "36", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "40", "40",
	"ETSI", "5G", "20M", "OFDM", "1T", "40", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "40", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "44", "40",
	"ETSI", "5G", "20M", "OFDM", "1T", "44", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "44", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "48", "40",
	"ETSI", "5G", "20M", "OFDM", "1T", "48", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "48", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "52", "40",
	"ETSI", "5G", "20M", "OFDM", "1T", "52", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "52", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "56", "40",
	"ETSI", "5G", "20M", "OFDM", "1T", "56", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "56", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "60", "40",
	"ETSI", "5G", "20M", "OFDM", "1T", "60", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "60", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "64", "36",
	"ETSI", "5G", "20M", "OFDM", "1T", "64", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "64", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "100", "32",
	"ETSI", "5G", "20M", "OFDM", "1T", "100", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "100", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "104", "40",
	"ETSI", "5G", "20M", "OFDM", "1T", "104", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "104", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "108", "40",
	"ETSI", "5G", "20M", "OFDM", "1T", "108", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "108", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "112", "40",
	"ETSI", "5G", "20M", "OFDM", "1T", "112", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "112", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "116", "40",
	"ETSI", "5G", "20M", "OFDM", "1T", "116", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "116", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "120", "40",
	"ETSI", "5G", "20M", "OFDM", "1T", "120", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "120", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "124", "40",
	"ETSI", "5G", "20M", "OFDM", "1T", "124", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "124", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "128", "40",
	"ETSI", "5G", "20M", "OFDM", "1T", "128", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "128", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "132", "40",
	"ETSI", "5G", "20M", "OFDM", "1T", "132", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "132", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "136", "40",
	"ETSI", "5G", "20M", "OFDM", "1T", "136", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "136", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "140", "38",
	"ETSI", "5G", "20M", "OFDM", "1T", "140", "32",
	"MKK", "5G", "20M", "OFDM", "1T", "140", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "144", "40",
	"ETSI", "5G", "20M", "OFDM", "1T", "144", "63",
	"MKK", "5G", "20M", "OFDM", "1T", "144", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "149", "40",
	"ETSI", "5G", "20M", "OFDM", "1T", "149", "-63",
	"MKK", "5G", "20M", "OFDM", "1T", "149", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "153", "40",
	"ETSI", "5G", "20M", "OFDM", "1T", "153", "-63",
	"MKK", "5G", "20M", "OFDM", "1T", "153", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "157", "40",
	"ETSI", "5G", "20M", "OFDM", "1T", "157", "-63",
	"MKK", "5G", "20M", "OFDM", "1T", "157", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "161", "40",
	"ETSI", "5G", "20M", "OFDM", "1T", "161", "-63",
	"MKK", "5G", "20M", "OFDM", "1T", "161", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "165", "40",
	"ETSI", "5G", "20M", "OFDM", "1T", "165", "-63",
	"MKK", "5G", "20M", "OFDM", "1T", "165", "63",
	"FCC", "5G", "20M", "OFDM", "2T", "36", "34",
	"ETSI", "5G", "20M", "OFDM", "2T", "36", "26",
	"MKK", "5G", "20M", "OFDM", "2T", "36", "26",
	"FCC", "5G", "20M", "OFDM", "2T", "40", "34",
	"ETSI", "5G", "20M", "OFDM", "2T", "40", "26",
	"MKK", "5G", "20M", "OFDM", "2T", "40", "26",
	"FCC", "5G", "20M", "OFDM", "2T", "44", "34",
	"ETSI", "5G", "20M", "OFDM", "2T", "44", "26",
	"MKK", "5G", "20M", "OFDM", "2T", "44", "26",
	"FCC", "5G", "20M", "OFDM", "2T", "48", "34",
	"ETSI", "5G", "20M", "OFDM", "2T", "48", "26",
	"MKK", "5G", "20M", "OFDM", "2T", "48", "26",
	"FCC", "5G", "20M", "OFDM", "2T", "52", "34",
	"ETSI", "5G", "20M", "OFDM", "2T", "52", "26",
	"MKK", "5G", "20M", "OFDM", "2T", "52", "26",
	"FCC", "5G", "20M", "OFDM", "2T", "56", "34",
	"ETSI", "5G", "20M", "OFDM", "2T", "56", "26",
	"MKK", "5G", "20M", "OFDM", "2T", "56", "26",
	"FCC", "5G", "20M", "OFDM", "2T", "60", "34",
	"ETSI", "5G", "20M", "OFDM", "2T", "60", "26",
	"MKK", "5G", "20M", "OFDM", "2T", "60", "26",
	"FCC", "5G", "20M", "OFDM", "2T", "64", "34",
	"ETSI", "5G", "20M", "OFDM", "2T", "64", "26",
	"MKK", "5G", "20M", "OFDM", "2T", "64", "26",
	"FCC", "5G", "20M", "OFDM", "2T", "100", "32",
	"ETSI", "5G", "20M", "OFDM", "2T", "100", "26",
	"MKK", "5G", "20M", "OFDM", "2T", "100", "34",
	"FCC", "5G", "20M", "OFDM", "2T", "104", "34",
	"ETSI", "5G", "20M", "OFDM", "2T", "104", "26",
	"MKK", "5G", "20M", "OFDM", "2T", "104", "34",
	"FCC", "5G", "20M", "OFDM", "2T", "108", "34",
	"ETSI", "5G", "20M", "OFDM", "2T", "108", "26",
	"MKK", "5G", "20M", "OFDM", "2T", "108", "34",
	"FCC", "5G", "20M", "OFDM", "2T", "112", "34",
	"ETSI", "5G", "20M", "OFDM", "2T", "112", "26",
	"MKK", "5G", "20M", "OFDM", "2T", "112", "34",
	"FCC", "5G", "20M", "OFDM", "2T", "116", "34",
	"ETSI", "5G", "20M", "OFDM", "2T", "116", "26",
	"MKK", "5G", "20M", "OFDM", "2T", "116", "34",
	"FCC", "5G", "20M", "OFDM", "2T", "120", "34",
	"ETSI", "5G", "20M", "OFDM", "2T", "120", "26",
	"MKK", "5G", "20M", "OFDM", "2T", "120", "34",
	"FCC", "5G", "20M", "OFDM", "2T", "124", "34",
	"ETSI", "5G", "20M", "OFDM", "2T", "124", "26",
	"MKK", "5G", "20M", "OFDM", "2T", "124", "34",
	"FCC", "5G", "20M", "OFDM", "2T", "128", "34",
	"ETSI", "5G", "20M", "OFDM", "2T", "128", "26",
	"MKK", "5G", "20M", "OFDM", "2T", "128", "34",
	"FCC", "5G", "20M", "OFDM", "2T", "132", "34",
	"ETSI", "5G", "20M", "OFDM", "2T", "132", "26",
	"MKK", "5G", "20M", "OFDM", "2T", "132", "34",
	"FCC", "5G", "20M", "OFDM", "2T", "136", "34",
	"ETSI", "5G", "20M", "OFDM", "2T", "136", "26",
	"MKK", "5G", "20M", "OFDM", "2T", "136", "34",
	"FCC", "5G", "20M", "OFDM", "2T", "140", "34",
	"ETSI", "5G", "20M", "OFDM", "2T", "140", "26",
	"MKK", "5G", "20M", "OFDM", "2T", "140", "34",
	"FCC", "5G", "20M", "OFDM", "2T", "144", "34",
	"ETSI", "5G", "20M", "OFDM", "2T", "144", "63",
	"MKK", "5G", "20M", "OFDM", "2T", "144", "63",
	"FCC", "5G", "20M", "OFDM", "2T", "149", "34",
	"ETSI", "5G", "20M", "OFDM", "2T", "149", "-63",
	"MKK", "5G", "20M", "OFDM", "2T", "149", "63",
	"FCC", "5G", "20M", "OFDM", "2T", "153", "34",
	"ETSI", "5G", "20M", "OFDM", "2T", "153", "-63",
	"MKK", "5G", "20M", "OFDM", "2T", "153", "63",
	"FCC", "5G", "20M", "OFDM", "2T", "157", "34",
	"ETSI", "5G", "20M", "OFDM", "2T", "157", "-63",
	"MKK", "5G", "20M", "OFDM", "2T", "157", "63",
	"FCC", "5G", "20M", "OFDM", "2T", "161", "34",
	"ETSI", "5G", "20M", "OFDM", "2T", "161", "-63",
	"MKK", "5G", "20M", "OFDM", "2T", "161", "63",
	"FCC", "5G", "20M", "OFDM", "2T", "165", "34",
	"ETSI", "5G", "20M", "OFDM", "2T", "165", "-63",
	"MKK", "5G", "20M", "OFDM", "2T", "165", "63",
	"FCC", "5G", "20M", "OFDM", "3T", "36", "30",
	"ETSI", "5G", "20M", "OFDM", "3T", "36", "22",
	"MKK", "5G", "20M", "OFDM", "3T", "36", "22",
	"FCC", "5G", "20M", "OFDM", "3T", "40", "30",
	"ETSI", "5G", "20M", "OFDM", "3T", "40", "22",
	"MKK", "5G", "20M", "OFDM", "3T", "40", "22",
	"FCC", "5G", "20M", "OFDM", "3T", "44", "30",
	"ETSI", "5G", "20M", "OFDM", "3T", "44", "22",
	"MKK", "5G", "20M", "OFDM", "3T", "44", "22",
	"FCC", "5G", "20M", "OFDM", "3T", "48", "30",
	"ETSI", "5G", "20M", "OFDM", "3T", "48", "22",
	"MKK", "5G", "20M", "OFDM", "3T", "48", "22",
	"FCC", "5G", "20M", "OFDM", "3T", "52", "30",
	"ETSI", "5G", "20M", "OFDM", "3T", "52", "22",
	"MKK", "5G", "20M", "OFDM", "3T", "52", "22",
	"FCC", "5G", "20M", "OFDM", "3T", "56", "30",
	"ETSI", "5G", "20M", "OFDM", "3T", "56", "22",
	"MKK", "5G", "20M", "OFDM", "3T", "56", "22",
	"FCC", "5G", "20M", "OFDM", "3T", "60", "30",
	"ETSI", "5G", "20M", "OFDM", "3T", "60", "22",
	"MKK", "5G", "20M", "OFDM", "3T", "60", "22",
	"FCC", "5G", "20M", "OFDM", "3T", "64", "30",
	"ETSI", "5G", "20M", "OFDM", "3T", "64", "22",
	"MKK", "5G", "20M", "OFDM", "3T", "64", "22",
	"FCC", "5G", "20M", "OFDM", "3T", "100", "30",
	"ETSI", "5G", "20M", "OFDM", "3T", "100", "22",
	"MKK", "5G", "20M", "OFDM", "3T", "100", "30",
	"FCC", "5G", "20M", "OFDM", "3T", "104", "30",
	"ETSI", "5G", "20M", "OFDM", "3T", "104", "22",
	"MKK", "5G", "20M", "OFDM", "3T", "104", "30",
	"FCC", "5G", "20M", "OFDM", "3T", "108", "30",
	"ETSI", "5G", "20M", "OFDM", "3T", "108", "22",
	"MKK", "5G", "20M", "OFDM", "3T", "108", "30",
	"FCC", "5G", "20M", "OFDM", "3T", "112", "30",
	"ETSI", "5G", "20M", "OFDM", "3T", "112", "22",
	"MKK", "5G", "20M", "OFDM", "3T", "112", "30",
	"FCC", "5G", "20M", "OFDM", "3T", "116", "30",
	"ETSI", "5G", "20M", "OFDM", "3T", "116", "22",
	"MKK", "5G", "20M", "OFDM", "3T", "116", "30",
	"FCC", "5G", "20M", "OFDM", "3T", "120", "30",
	"ETSI", "5G", "20M", "OFDM", "3T", "120", "22",
	"MKK", "5G", "20M", "OFDM", "3T", "120", "30",
	"FCC", "5G", "20M", "OFDM", "3T", "124", "30",
	"ETSI", "5G", "20M", "OFDM", "3T", "124", "22",
	"MKK", "5G", "20M", "OFDM", "3T", "124", "30",
	"FCC", "5G", "20M", "OFDM", "3T", "128", "30",
	"ETSI", "5G", "20M", "OFDM", "3T", "128", "22",
	"MKK", "5G", "20M", "OFDM", "3T", "128", "30",
	"FCC", "5G", "20M", "OFDM", "3T", "132", "30",
	"ETSI", "5G", "20M", "OFDM", "3T", "132", "22",
	"MKK", "5G", "20M", "OFDM", "3T", "132", "30",
	"FCC", "5G", "20M", "OFDM", "3T", "136", "30",
	"ETSI", "5G", "20M", "OFDM", "3T", "136", "22",
	"MKK", "5G", "20M", "OFDM", "3T", "136", "30",
	"FCC", "5G", "20M", "OFDM", "3T", "140", "30",
	"ETSI", "5G", "20M", "OFDM", "3T", "140", "22",
	"MKK", "5G", "20M", "OFDM", "3T", "140", "30",
	"FCC", "5G", "20M", "OFDM", "3T", "144", "30",
	"ETSI", "5G", "20M", "OFDM", "3T", "144", "63",
	"MKK", "5G", "20M", "OFDM", "3T", "144", "63",
	"FCC", "5G", "20M", "OFDM", "3T", "149", "30",
	"ETSI", "5G", "20M", "OFDM", "3T", "149", "-63",
	"MKK", "5G", "20M", "OFDM", "3T", "149", "63",
	"FCC", "5G", "20M", "OFDM", "3T", "153", "30",
	"ETSI", "5G", "20M", "OFDM", "3T", "153", "-63",
	"MKK", "5G", "20M", "OFDM", "3T", "153", "63",
	"FCC", "5G", "20M", "OFDM", "3T", "157", "30",
	"ETSI", "5G", "20M", "OFDM", "3T", "157", "-63",
	"MKK", "5G", "20M", "OFDM", "3T", "157", "63",
	"FCC", "5G", "20M", "OFDM", "3T", "161", "30",
	"ETSI", "5G", "20M", "OFDM", "3T", "161", "-63",
	"MKK", "5G", "20M", "OFDM", "3T", "161", "63",
	"FCC", "5G", "20M", "OFDM", "3T", "165", "30",
	"ETSI", "5G", "20M", "OFDM", "3T", "165", "-63",
	"MKK", "5G", "20M", "OFDM", "3T", "165", "63",
	"FCC", "5G", "20M", "OFDM", "4T", "36", "28",
	"ETSI", "5G", "20M", "OFDM", "4T", "36", "20",
	"MKK", "5G", "20M", "OFDM", "4T", "36", "20",
	"FCC", "5G", "20M", "OFDM", "4T", "40", "28",
	"ETSI", "5G", "20M", "OFDM", "4T", "40", "20",
	"MKK", "5G", "20M", "OFDM", "4T", "40", "20",
	"FCC", "5G", "20M", "OFDM", "4T", "44", "28",
	"ETSI", "5G", "20M", "OFDM", "4T", "44", "20",
	"MKK", "5G", "20M", "OFDM", "4T", "44", "20",
	"FCC", "5G", "20M", "OFDM", "4T", "48", "28",
	"ETSI", "5G", "20M", "OFDM", "4T", "48", "20",
	"MKK", "5G", "20M", "OFDM", "4T", "48", "20",
	"FCC", "5G", "20M", "OFDM", "4T", "52", "28",
	"ETSI", "5G", "20M", "OFDM", "4T", "52", "20",
	"MKK", "5G", "20M", "OFDM", "4T", "52", "20",
	"FCC", "5G", "20M", "OFDM", "4T", "56", "28",
	"ETSI", "5G", "20M", "OFDM", "4T", "56", "20",
	"MKK", "5G", "20M", "OFDM", "4T", "56", "20",
	"FCC", "5G", "20M", "OFDM", "4T", "60", "28",
	"ETSI", "5G", "20M", "OFDM", "4T", "60", "20",
	"MKK", "5G", "20M", "OFDM", "4T", "60", "20",
	"FCC", "5G", "20M", "OFDM", "4T", "64", "28",
	"ETSI", "5G", "20M", "OFDM", "4T", "64", "20",
	"MKK", "5G", "20M", "OFDM", "4T", "64", "20",
	"FCC", "5G", "20M", "OFDM", "4T", "100", "28",
	"ETSI", "5G", "20M", "OFDM", "4T", "100", "20",
	"MKK", "5G", "20M", "OFDM", "4T", "100", "28",
	"FCC", "5G", "20M", "OFDM", "4T", "104", "28",
	"ETSI", "5G", "20M", "OFDM", "4T", "104", "20",
	"MKK", "5G", "20M", "OFDM", "4T", "104", "28",
	"FCC", "5G", "20M", "OFDM", "4T", "108", "28",
	"ETSI", "5G", "20M", "OFDM", "4T", "108", "20",
	"MKK", "5G", "20M", "OFDM", "4T", "108", "28",
	"FCC", "5G", "20M", "OFDM", "4T", "112", "28",
	"ETSI", "5G", "20M", "OFDM", "4T", "112", "20",
	"MKK", "5G", "20M", "OFDM", "4T", "112", "28",
	"FCC", "5G", "20M", "OFDM", "4T", "116", "28",
	"ETSI", "5G", "20M", "OFDM", "4T", "116", "20",
	"MKK", "5G", "20M", "OFDM", "4T", "116", "28",
	"FCC", "5G", "20M", "OFDM", "4T", "120", "28",
	"ETSI", "5G", "20M", "OFDM", "4T", "120", "20",
	"MKK", "5G", "20M", "OFDM", "4T", "120", "28",
	"FCC", "5G", "20M", "OFDM", "4T", "124", "28",
	"ETSI", "5G", "20M", "OFDM", "4T", "124", "20",
	"MKK", "5G", "20M", "OFDM", "4T", "124", "28",
	"FCC", "5G", "20M", "OFDM", "4T", "128", "28",
	"ETSI", "5G", "20M", "OFDM", "4T", "128", "20",
	"MKK", "5G", "20M", "OFDM", "4T", "128", "28",
	"FCC", "5G", "20M", "OFDM", "4T", "132", "28",
	"ETSI", "5G", "20M", "OFDM", "4T", "132", "20",
	"MKK", "5G", "20M", "OFDM", "4T", "132", "28",
	"FCC", "5G", "20M", "OFDM", "4T", "136", "28",
	"ETSI", "5G", "20M", "OFDM", "4T", "136", "20",
	"MKK", "5G", "20M", "OFDM", "4T", "136", "28",
	"FCC", "5G", "20M", "OFDM", "4T", "140", "28",
	"ETSI", "5G", "20M", "OFDM", "4T", "140", "20",
	"MKK", "5G", "20M", "OFDM", "4T", "140", "28",
	"FCC", "5G", "20M", "OFDM", "4T", "144", "28",
	"ETSI", "5G", "20M", "OFDM", "4T", "144", "63",
	"MKK", "5G", "20M", "OFDM", "4T", "144", "63",
	"FCC", "5G", "20M", "OFDM", "4T", "149", "28",
	"ETSI", "5G", "20M", "OFDM", "4T", "149", "-63",
	"MKK", "5G", "20M", "OFDM", "4T", "149", "63",
	"FCC", "5G", "20M", "OFDM", "4T", "153", "28",
	"ETSI", "5G", "20M", "OFDM", "4T", "153", "-63",
	"MKK", "5G", "20M", "OFDM", "4T", "153", "63",
	"FCC", "5G", "20M", "OFDM", "4T", "157", "28",
	"ETSI", "5G", "20M", "OFDM", "4T", "157", "-63",
	"MKK", "5G", "20M", "OFDM", "4T", "157", "63",
	"FCC", "5G", "20M", "OFDM", "4T", "161", "28",
	"ETSI", "5G", "20M", "OFDM", "4T", "161", "-63",
	"MKK", "5G", "20M", "OFDM", "4T", "161", "63",
	"FCC", "5G", "20M", "OFDM", "4T", "165", "28",
	"ETSI", "5G", "20M", "OFDM", "4T", "165", "-63",
	"MKK", "5G", "20M", "OFDM", "4T", "165", "63",
	"FCC", "5G", "20M", "HT", "1T", "36", "36",
	"ETSI", "5G", "20M", "HT", "1T", "36", "32",
	"MKK", "5G", "20M", "HT", "1T", "36", "32",
	"FCC", "5G", "20M", "HT", "1T", "40", "40",
	"ETSI", "5G", "20M", "HT", "1T", "40", "32",
	"MKK", "5G", "20M", "HT", "1T", "40", "32",
	"FCC", "5G", "20M", "HT", "1T", "44", "40",
	"ETSI", "5G", "20M", "HT", "1T", "44", "32",
	"MKK", "5G", "20M", "HT", "1T", "44", "32",
	"FCC", "5G", "20M", "HT", "1T", "48", "40",
	"ETSI", "5G", "20M", "HT", "1T", "48", "32",
	"MKK", "5G", "20M", "HT", "1T", "48", "32",
	"FCC", "5G", "20M", "HT", "1T", "52", "40",
	"ETSI", "5G", "20M", "HT", "1T", "52", "32",
	"MKK", "5G", "20M", "HT", "1T", "52", "32",
	"FCC", "5G", "20M", "HT", "1T", "56", "40",
	"ETSI", "5G", "20M", "HT", "1T", "56", "32",
	"MKK", "5G", "20M", "HT", "1T", "56", "32",
	"FCC", "5G", "20M", "HT", "1T", "60", "40",
	"ETSI", "5G", "20M", "HT", "1T", "60", "32",
	"MKK", "5G", "20M", "HT", "1T", "60", "32",
	"FCC", "5G", "20M", "HT", "1T", "64", "36",
	"ETSI", "5G", "20M", "HT", "1T", "64", "32",
	"MKK", "5G", "20M", "HT", "1T", "64", "32",
	"FCC", "5G", "20M", "HT", "1T", "100", "32",
	"ETSI", "5G", "20M", "HT", "1T", "100", "32",
	"MKK", "5G", "20M", "HT", "1T", "100", "40",
	"FCC", "5G", "20M", "HT", "1T", "104", "40",
	"ETSI", "5G", "20M", "HT", "1T", "104", "32",
	"MKK", "5G", "20M", "HT", "1T", "104", "40",
	"FCC", "5G", "20M", "HT", "1T", "108", "40",
	"ETSI", "5G", "20M", "HT", "1T", "108", "32",
	"MKK", "5G", "20M", "HT", "1T", "108", "40",
	"FCC", "5G", "20M", "HT", "1T", "112", "40",
	"ETSI", "5G", "20M", "HT", "1T", "112", "32",
	"MKK", "5G", "20M", "HT", "1T", "112", "40",
	"FCC", "5G", "20M", "HT", "1T", "116", "40",
	"ETSI", "5G", "20M", "HT", "1T", "116", "32",
	"MKK", "5G", "20M", "HT", "1T", "116", "40",
	"FCC", "5G", "20M", "HT", "1T", "120", "40",
	"ETSI", "5G", "20M", "HT", "1T", "120", "32",
	"MKK", "5G", "20M", "HT", "1T", "120", "40",
	"FCC", "5G", "20M", "HT", "1T", "124", "40",
	"ETSI", "5G", "20M", "HT", "1T", "124", "32",
	"MKK", "5G", "20M", "HT", "1T", "124", "40",
	"FCC", "5G", "20M", "HT", "1T", "128", "40",
	"ETSI", "5G", "20M", "HT", "1T", "128", "32",
	"MKK", "5G", "20M", "HT", "1T", "128", "40",
	"FCC", "5G", "20M", "HT", "1T", "132", "40",
	"ETSI", "5G", "20M", "HT", "1T", "132", "32",
	"MKK", "5G", "20M", "HT", "1T", "132", "40",
	"FCC", "5G", "20M", "HT", "1T", "136", "40",
	"ETSI", "5G", "20M", "HT", "1T", "136", "32",
	"MKK", "5G", "20M", "HT", "1T", "136", "40",
	"FCC", "5G", "20M", "HT", "1T", "140", "38",
	"ETSI", "5G", "20M", "HT", "1T", "140", "32",
	"MKK", "5G", "20M", "HT", "1T", "140", "40",
	"FCC", "5G", "20M", "HT", "1T", "144", "40",
	"ETSI", "5G", "20M", "HT", "1T", "144", "63",
	"MKK", "5G", "20M", "HT", "1T", "144", "40",
	"FCC", "5G", "20M", "HT", "1T", "149", "40",
	"ETSI", "5G", "20M", "HT", "1T", "149", "-63",
	"MKK", "5G", "20M", "HT", "1T", "149", "63",
	"FCC", "5G", "20M", "HT", "1T", "153", "40",
	"ETSI", "5G", "20M", "HT", "1T", "153", "-63",
	"MKK", "5G", "20M", "HT", "1T", "153", "63",
	"FCC", "5G", "20M", "HT", "1T", "157", "40",
	"ETSI", "5G", "20M", "HT", "1T", "157", "-63",
	"MKK", "5G", "20M", "HT", "1T", "157", "63",
	"FCC", "5G", "20M", "HT", "1T", "161", "40",
	"ETSI", "5G", "20M", "HT", "1T", "161", "-63",
	"MKK", "5G", "20M", "HT", "1T", "161", "63",
	"FCC", "5G", "20M", "HT", "1T", "165", "40",
	"ETSI", "5G", "20M", "HT", "1T", "165", "-63",
	"MKK", "5G", "20M", "HT", "1T", "165", "63",
	"FCC", "5G", "20M", "HT", "2T", "36", "34",
	"ETSI", "5G", "20M", "HT", "2T", "36", "26",
	"MKK", "5G", "20M", "HT", "2T", "36", "26",
	"FCC", "5G", "20M", "HT", "2T", "40", "34",
	"ETSI", "5G", "20M", "HT", "2T", "40", "26",
	"MKK", "5G", "20M", "HT", "2T", "40", "26",
	"FCC", "5G", "20M", "HT", "2T", "44", "34",
	"ETSI", "5G", "20M", "HT", "2T", "44", "26",
	"MKK", "5G", "20M", "HT", "2T", "44", "26",
	"FCC", "5G", "20M", "HT", "2T", "48", "34",
	"ETSI", "5G", "20M", "HT", "2T", "48", "26",
	"MKK", "5G", "20M", "HT", "2T", "48", "26",
	"FCC", "5G", "20M", "HT", "2T", "52", "34",
	"ETSI", "5G", "20M", "HT", "2T", "52", "26",
	"MKK", "5G", "20M", "HT", "2T", "52", "26",
	"FCC", "5G", "20M", "HT", "2T", "56", "34",
	"ETSI", "5G", "20M", "HT", "2T", "56", "26",
	"MKK", "5G", "20M", "HT", "2T", "56", "26",
	"FCC", "5G", "20M", "HT", "2T", "60", "34",
	"ETSI", "5G", "20M", "HT", "2T", "60", "26",
	"MKK", "5G", "20M", "HT", "2T", "60", "26",
	"FCC", "5G", "20M", "HT", "2T", "64", "32",
	"ETSI", "5G", "20M", "HT", "2T", "64", "26",
	"MKK", "5G", "20M", "HT", "2T", "64", "26",
	"FCC", "5G", "20M", "HT", "2T", "100", "32",
	"ETSI", "5G", "20M", "HT", "2T", "100", "26",
	"MKK", "5G", "20M", "HT", "2T", "100", "34",
	"FCC", "5G", "20M", "HT", "2T", "104", "34",
	"ETSI", "5G", "20M", "HT", "2T", "104", "26",
	"MKK", "5G", "20M", "HT", "2T", "104", "34",
	"FCC", "5G", "20M", "HT", "2T", "108", "34",
	"ETSI", "5G", "20M", "HT", "2T", "108", "26",
	"MKK", "5G", "20M", "HT", "2T", "108", "34",
	"FCC", "5G", "20M", "HT", "2T", "112", "34",
	"ETSI", "5G", "20M", "HT", "2T", "112", "26",
	"MKK", "5G", "20M", "HT", "2T", "112", "34",
	"FCC", "5G", "20M", "HT", "2T", "116", "34",
	"ETSI", "5G", "20M", "HT", "2T", "116", "26",
	"MKK", "5G", "20M", "HT", "2T", "116", "34",
	"FCC", "5G", "20M", "HT", "2T", "120", "34",
	"ETSI", "5G", "20M", "HT", "2T", "120", "26",
	"MKK", "5G", "20M", "HT", "2T", "120", "34",
	"FCC", "5G", "20M", "HT", "2T", "124", "34",
	"ETSI", "5G", "20M", "HT", "2T", "124", "26",
	"MKK", "5G", "20M", "HT", "2T", "124", "34",
	"FCC", "5G", "20M", "HT", "2T", "128", "34",
	"ETSI", "5G", "20M", "HT", "2T", "128", "26",
	"MKK", "5G", "20M", "HT", "2T", "128", "34",
	"FCC", "5G", "20M", "HT", "2T", "132", "34",
	"ETSI", "5G", "20M", "HT", "2T", "132", "26",
	"MKK", "5G", "20M", "HT", "2T", "132", "34",
	"FCC", "5G", "20M", "HT", "2T", "136", "34",
	"ETSI", "5G", "20M", "HT", "2T", "136", "26",
	"MKK", "5G", "20M", "HT", "2T", "136", "34",
	"FCC", "5G", "20M", "HT", "2T", "140", "34",
	"ETSI", "5G", "20M", "HT", "2T", "140", "26",
	"MKK", "5G", "20M", "HT", "2T", "140", "34",
	"FCC", "5G", "20M", "HT", "2T", "144", "34",
	"ETSI", "5G", "20M", "HT", "2T", "144", "63",
	"MKK", "5G", "20M", "HT", "2T", "144", "63",
	"FCC", "5G", "20M", "HT", "2T", "149", "34",
	"ETSI", "5G", "20M", "HT", "2T", "149", "-63",
	"MKK", "5G", "20M", "HT", "2T", "149", "63",
	"FCC", "5G", "20M", "HT", "2T", "153", "34",
	"ETSI", "5G", "20M", "HT", "2T", "153", "-63",
	"MKK", "5G", "20M", "HT", "2T", "153", "63",
	"FCC", "5G", "20M", "HT", "2T", "157", "34",
	"ETSI", "5G", "20M", "HT", "2T", "157", "-63",
	"MKK", "5G", "20M", "HT", "2T", "157", "63",
	"FCC", "5G", "20M", "HT", "2T", "161", "34",
	"ETSI", "5G", "20M", "HT", "2T", "161", "-63",
	"MKK", "5G", "20M", "HT", "2T", "161", "63",
	"FCC", "5G", "20M", "HT", "2T", "165", "34",
	"ETSI", "5G", "20M", "HT", "2T", "165", "-63",
	"MKK", "5G", "20M", "HT", "2T", "165", "63",
	"FCC", "5G", "20M", "HT", "3T", "36", "30",
	"ETSI", "5G", "20M", "HT", "3T", "36", "22",
	"MKK", "5G", "20M", "HT", "3T", "36", "22",
	"FCC", "5G", "20M", "HT", "3T", "40", "30",
	"ETSI", "5G", "20M", "HT", "3T", "40", "22",
	"MKK", "5G", "20M", "HT", "3T", "40", "22",
	"FCC", "5G", "20M", "HT", "3T", "44", "30",
	"ETSI", "5G", "20M", "HT", "3T", "44", "22",
	"MKK", "5G", "20M", "HT", "3T", "44", "22",
	"FCC", "5G", "20M", "HT", "3T", "48", "30",
	"ETSI", "5G", "20M", "HT", "3T", "48", "22",
	"MKK", "5G", "20M", "HT", "3T", "48", "22",
	"FCC", "5G", "20M", "HT", "3T", "52", "30",
	"ETSI", "5G", "20M", "HT", "3T", "52", "22",
	"MKK", "5G", "20M", "HT", "3T", "52", "22",
	"FCC", "5G", "20M", "HT", "3T", "56", "30",
	"ETSI", "5G", "20M", "HT", "3T", "56", "22",
	"MKK", "5G", "20M", "HT", "3T", "56", "22",
	"FCC", "5G", "20M", "HT", "3T", "60", "30",
	"ETSI", "5G", "20M", "HT", "3T", "60", "22",
	"MKK", "5G", "20M", "HT", "3T", "60", "22",
	"FCC", "5G", "20M", "HT", "3T", "64", "30",
	"ETSI", "5G", "20M", "HT", "3T", "64", "22",
	"MKK", "5G", "20M", "HT", "3T", "64", "22",
	"FCC", "5G", "20M", "HT", "3T", "100", "30",
	"ETSI", "5G", "20M", "HT", "3T", "100", "22",
	"MKK", "5G", "20M", "HT", "3T", "100", "30",
	"FCC", "5G", "20M", "HT", "3T", "104", "30",
	"ETSI", "5G", "20M", "HT", "3T", "104", "22",
	"MKK", "5G", "20M", "HT", "3T", "104", "30",
	"FCC", "5G", "20M", "HT", "3T", "108", "30",
	"ETSI", "5G", "20M", "HT", "3T", "108", "22",
	"MKK", "5G", "20M", "HT", "3T", "108", "30",
	"FCC", "5G", "20M", "HT", "3T", "112", "30",
	"ETSI", "5G", "20M", "HT", "3T", "112", "22",
	"MKK", "5G", "20M", "HT", "3T", "112", "30",
	"FCC", "5G", "20M", "HT", "3T", "116", "30",
	"ETSI", "5G", "20M", "HT", "3T", "116", "22",
	"MKK", "5G", "20M", "HT", "3T", "116", "30",
	"FCC", "5G", "20M", "HT", "3T", "120", "30",
	"ETSI", "5G", "20M", "HT", "3T", "120", "22",
	"MKK", "5G", "20M", "HT", "3T", "120", "30",
	"FCC", "5G", "20M", "HT", "3T", "124", "30",
	"ETSI", "5G", "20M", "HT", "3T", "124", "22",
	"MKK", "5G", "20M", "HT", "3T", "124", "30",
	"FCC", "5G", "20M", "HT", "3T", "128", "30",
	"ETSI", "5G", "20M", "HT", "3T", "128", "22",
	"MKK", "5G", "20M", "HT", "3T", "128", "30",
	"FCC", "5G", "20M", "HT", "3T", "132", "30",
	"ETSI", "5G", "20M", "HT", "3T", "132", "22",
	"MKK", "5G", "20M", "HT", "3T", "132", "30",
	"FCC", "5G", "20M", "HT", "3T", "136", "30",
	"ETSI", "5G", "20M", "HT", "3T", "136", "22",
	"MKK", "5G", "20M", "HT", "3T", "136", "30",
	"FCC", "5G", "20M", "HT", "3T", "140", "30",
	"ETSI", "5G", "20M", "HT", "3T", "140", "22",
	"MKK", "5G", "20M", "HT", "3T", "140", "30",
	"FCC", "5G", "20M", "HT", "3T", "144", "30",
	"ETSI", "5G", "20M", "HT", "3T", "144", "63",
	"MKK", "5G", "20M", "HT", "3T", "144", "63",
	"FCC", "5G", "20M", "HT", "3T", "149", "30",
	"ETSI", "5G", "20M", "HT", "3T", "149", "-63",
	"MKK", "5G", "20M", "HT", "3T", "149", "63",
	"FCC", "5G", "20M", "HT", "3T", "153", "30",
	"ETSI", "5G", "20M", "HT", "3T", "153", "-63",
	"MKK", "5G", "20M", "HT", "3T", "153", "63",
	"FCC", "5G", "20M", "HT", "3T", "157", "30",
	"ETSI", "5G", "20M", "HT", "3T", "157", "-63",
	"MKK", "5G", "20M", "HT", "3T", "157", "63",
	"FCC", "5G", "20M", "HT", "3T", "161", "30",
	"ETSI", "5G", "20M", "HT", "3T", "161", "-63",
	"MKK", "5G", "20M", "HT", "3T", "161", "63",
	"FCC", "5G", "20M", "HT", "3T", "165", "30",
	"ETSI", "5G", "20M", "HT", "3T", "165", "-63",
	"MKK", "5G", "20M", "HT", "3T", "165", "63",
	"FCC", "5G", "20M", "HT", "4T", "36", "28",
	"ETSI", "5G", "20M", "HT", "4T", "36", "20",
	"MKK", "5G", "20M", "HT", "4T", "36", "20",
	"FCC", "5G", "20M", "HT", "4T", "40", "28",
	"ETSI", "5G", "20M", "HT", "4T", "40", "20",
	"MKK", "5G", "20M", "HT", "4T", "40", "20",
	"FCC", "5G", "20M", "HT", "4T", "44", "28",
	"ETSI", "5G", "20M", "HT", "4T", "44", "20",
	"MKK", "5G", "20M", "HT", "4T", "44", "20",
	"FCC", "5G", "20M", "HT", "4T", "48", "28",
	"ETSI", "5G", "20M", "HT", "4T", "48", "20",
	"MKK", "5G", "20M", "HT", "4T", "48", "20",
	"FCC", "5G", "20M", "HT", "4T", "52", "28",
	"ETSI", "5G", "20M", "HT", "4T", "52", "20",
	"MKK", "5G", "20M", "HT", "4T", "52", "20",
	"FCC", "5G", "20M", "HT", "4T", "56", "28",
	"ETSI", "5G", "20M", "HT", "4T", "56", "20",
	"MKK", "5G", "20M", "HT", "4T", "56", "20",
	"FCC", "5G", "20M", "HT", "4T", "60", "28",
	"ETSI", "5G", "20M", "HT", "4T", "60", "20",
	"MKK", "5G", "20M", "HT", "4T", "60", "20",
	"FCC", "5G", "20M", "HT", "4T", "64", "28",
	"ETSI", "5G", "20M", "HT", "4T", "64", "20",
	"MKK", "5G", "20M", "HT", "4T", "64", "20",
	"FCC", "5G", "20M", "HT", "4T", "100", "28",
	"ETSI", "5G", "20M", "HT", "4T", "100", "20",
	"MKK", "5G", "20M", "HT", "4T", "100", "28",
	"FCC", "5G", "20M", "HT", "4T", "104", "28",
	"ETSI", "5G", "20M", "HT", "4T", "104", "20",
	"MKK", "5G", "20M", "HT", "4T", "104", "28",
	"FCC", "5G", "20M", "HT", "4T", "108", "28",
	"ETSI", "5G", "20M", "HT", "4T", "108", "20",
	"MKK", "5G", "20M", "HT", "4T", "108", "28",
	"FCC", "5G", "20M", "HT", "4T", "112", "28",
	"ETSI", "5G", "20M", "HT", "4T", "112", "20",
	"MKK", "5G", "20M", "HT", "4T", "112", "28",
	"FCC", "5G", "20M", "HT", "4T", "116", "28",
	"ETSI", "5G", "20M", "HT", "4T", "116", "20",
	"MKK", "5G", "20M", "HT", "4T", "116", "28",
	"FCC", "5G", "20M", "HT", "4T", "120", "28",
	"ETSI", "5G", "20M", "HT", "4T", "120", "20",
	"MKK", "5G", "20M", "HT", "4T", "120", "28",
	"FCC", "5G", "20M", "HT", "4T", "124", "28",
	"ETSI", "5G", "20M", "HT", "4T", "124", "20",
	"MKK", "5G", "20M", "HT", "4T", "124", "28",
	"FCC", "5G", "20M", "HT", "4T", "128", "28",
	"ETSI", "5G", "20M", "HT", "4T", "128", "20",
	"MKK", "5G", "20M", "HT", "4T", "128", "28",
	"FCC", "5G", "20M", "HT", "4T", "132", "28",
	"ETSI", "5G", "20M", "HT", "4T", "132", "20",
	"MKK", "5G", "20M", "HT", "4T", "132", "28",
	"FCC", "5G", "20M", "HT", "4T", "136", "28",
	"ETSI", "5G", "20M", "HT", "4T", "136", "20",
	"MKK", "5G", "20M", "HT", "4T", "136", "28",
	"FCC", "5G", "20M", "HT", "4T", "140", "28",
	"ETSI", "5G", "20M", "HT", "4T", "140", "20",
	"MKK", "5G", "20M", "HT", "4T", "140", "28",
	"FCC", "5G", "20M", "HT", "4T", "144", "28",
	"ETSI", "5G", "20M", "HT", "4T", "144", "63",
	"MKK", "5G", "20M", "HT", "4T", "144", "63",
	"FCC", "5G", "20M", "HT", "4T", "149", "28",
	"ETSI", "5G", "20M", "HT", "4T", "149", "-63",
	"MKK", "5G", "20M", "HT", "4T", "149", "63",
	"FCC", "5G", "20M", "HT", "4T", "153", "28",
	"ETSI", "5G", "20M", "HT", "4T", "153", "-63",
	"MKK", "5G", "20M", "HT", "4T", "153", "63",
	"FCC", "5G", "20M", "HT", "4T", "157", "28",
	"ETSI", "5G", "20M", "HT", "4T", "157", "-63",
	"MKK", "5G", "20M", "HT", "4T", "157", "63",
	"FCC", "5G", "20M", "HT", "4T", "161", "28",
	"ETSI", "5G", "20M", "HT", "4T", "161", "-63",
	"MKK", "5G", "20M", "HT", "4T", "161", "63",
	"FCC", "5G", "20M", "HT", "4T", "165", "28",
	"ETSI", "5G", "20M", "HT", "4T", "165", "-63",
	"MKK", "5G", "20M", "HT", "4T", "165", "63",
	"FCC", "5G", "40M", "HT", "1T", "38", "32",
	"ETSI", "5G", "40M", "HT", "1T", "38", "32",
	"MKK", "5G", "40M", "HT", "1T", "38", "32",
	"FCC", "5G", "40M", "HT", "1T", "46", "40",
	"ETSI", "5G", "40M", "HT", "1T", "46", "32",
	"MKK", "5G", "40M", "HT", "1T", "46", "32",
	"FCC", "5G", "40M", "HT", "1T", "54", "40",
	"ETSI", "5G", "40M", "HT", "1T", "54", "32",
	"MKK", "5G", "40M", "HT", "1T", "54", "32",
	"FCC", "5G", "40M", "HT", "1T", "62", "32",
	"ETSI", "5G", "40M", "HT", "1T", "62", "32",
	"MKK", "5G", "40M", "HT", "1T", "62", "32",
	"FCC", "5G", "40M", "HT", "1T", "102", "30",
	"ETSI", "5G", "40M", "HT", "1T", "102", "32",
	"MKK", "5G", "40M", "HT", "1T", "102", "40",
	"FCC", "5G", "40M", "HT", "1T", "110", "40",
	"ETSI", "5G", "40M", "HT", "1T", "110", "32",
	"MKK", "5G", "40M", "HT", "1T", "110", "40",
	"FCC", "5G", "40M", "HT", "1T", "118", "40",
	"ETSI", "5G", "40M", "HT", "1T", "118", "32",
	"MKK", "5G", "40M", "HT", "1T", "118", "40",
	"FCC", "5G", "40M", "HT", "1T", "126", "40",
	"ETSI", "5G", "40M", "HT", "1T", "126", "32",
	"MKK", "5G", "40M", "HT", "1T", "126", "40",
	"FCC", "5G", "40M", "HT", "1T", "134", "34",
	"ETSI", "5G", "40M", "HT", "1T", "134", "32",
	"MKK", "5G", "40M", "HT", "1T", "134", "40",
	"FCC", "5G", "40M", "HT", "1T", "142", "34",
	"ETSI", "5G", "40M", "HT", "1T", "142", "63",
	"MKK", "5G", "40M", "HT", "1T", "142", "63",
	"FCC", "5G", "40M", "HT", "1T", "151", "40",
	"ETSI", "5G", "40M", "HT", "1T", "151", "-63",
	"MKK", "5G", "40M", "HT", "1T", "151", "63",
	"FCC", "5G", "40M", "HT", "1T", "159", "40",
	"ETSI", "5G", "40M", "HT", "1T", "159", "-63",
	"MKK", "5G", "40M", "HT", "1T", "159", "63",
	"FCC", "5G", "40M", "HT", "2T", "38", "28",
	"ETSI", "5G", "40M", "HT", "2T", "38", "26",
	"MKK", "5G", "40M", "HT", "2T", "38", "26",
	"FCC", "5G", "40M", "HT", "2T", "46", "34",
	"ETSI", "5G", "40M", "HT", "2T", "46", "26",
	"MKK", "5G", "40M", "HT", "2T", "46", "26",
	"FCC", "5G", "40M", "HT", "2T", "54", "34",
	"ETSI", "5G", "40M", "HT", "2T", "54", "26",
	"MKK", "5G", "40M", "HT", "2T", "54", "26",
	"FCC", "5G", "40M", "HT", "2T", "62", "30",
	"ETSI", "5G", "40M", "HT", "2T", "62", "26",
	"MKK", "5G", "40M", "HT", "2T", "62", "26",
	"FCC", "5G", "40M", "HT", "2T", "102", "30",
	"ETSI", "5G", "40M", "HT", "2T", "102", "26",
	"MKK", "5G", "40M", "HT", "2T", "102", "34",
	"FCC", "5G", "40M", "HT", "2T", "110", "34",
	"ETSI", "5G", "40M", "HT", "2T", "110", "26",
	"MKK", "5G", "40M", "HT", "2T", "110", "34",
	"FCC", "5G", "40M", "HT", "2T", "118", "34",
	"ETSI", "5G", "40M", "HT", "2T", "118", "26",
	"MKK", "5G", "40M", "HT", "2T", "118", "34",
	"FCC", "5G", "40M", "HT", "2T", "126", "34",
	"ETSI", "5G", "40M", "HT", "2T", "126", "26",
	"MKK", "5G", "40M", "HT", "2T", "126", "34",
	"FCC", "5G", "40M", "HT", "2T", "134", "32",
	"ETSI", "5G", "40M", "HT", "2T", "134", "26",
	"MKK", "5G", "40M", "HT", "2T", "134", "34",
	"FCC", "5G", "40M", "HT", "2T", "142", "32",
	"ETSI", "5G", "40M", "HT", "2T", "142", "63",
	"MKK", "5G", "40M", "HT", "2T", "142", "63",
	"FCC", "5G", "40M", "HT", "2T", "151", "34",
	"ETSI", "5G", "40M", "HT", "2T", "151", "-63",
	"MKK", "5G", "40M", "HT", "2T", "151", "63",
	"FCC", "5G", "40M", "HT", "2T", "159", "34",
	"ETSI", "5G", "40M", "HT", "2T", "159", "-63",
	"MKK", "5G", "40M", "HT", "2T", "159", "63",
	"FCC", "5G", "40M", "HT", "3T", "38", "28",
	"ETSI", "5G", "40M", "HT", "3T", "38", "22",
	"MKK", "5G", "40M", "HT", "3T", "38", "22",
	"FCC", "5G", "40M", "HT", "3T", "46", "30",
	"ETSI", "5G", "40M", "HT", "3T", "46", "22",
	"MKK", "5G", "40M", "HT", "3T", "46", "22",
	"FCC", "5G", "40M", "HT", "3T", "54", "30",
	"ETSI", "5G", "40M", "HT", "3T", "54", "22",
	"MKK", "5G", "40M", "HT", "3T", "54", "22",
	"FCC", "5G", "40M", "HT", "3T", "62", "30",
	"ETSI", "5G", "40M", "HT", "3T", "62", "22",
	"MKK", "5G", "40M", "HT", "3T", "62", "22",
	"FCC", "5G", "40M", "HT", "3T", "102", "30",
	"ETSI", "5G", "40M", "HT", "3T", "102", "22",
	"MKK", "5G", "40M", "HT", "3T", "102", "30",
	"FCC", "5G", "40M", "HT", "3T", "110", "30",
	"ETSI", "5G", "40M", "HT", "3T", "110", "22",
	"MKK", "5G", "40M", "HT", "3T", "110", "30",
	"FCC", "5G", "40M", "HT", "3T", "118", "30",
	"ETSI", "5G", "40M", "HT", "3T", "118", "22",
	"MKK", "5G", "40M", "HT", "3T", "118", "30",
	"FCC", "5G", "40M", "HT", "3T", "126", "30",
	"ETSI", "5G", "40M", "HT", "3T", "126", "22",
	"MKK", "5G", "40M", "HT", "3T", "126", "30",
	"FCC", "5G", "40M", "HT", "3T", "134", "30",
	"ETSI", "5G", "40M", "HT", "3T", "134", "22",
	"MKK", "5G", "40M", "HT", "3T", "134", "30",
	"FCC", "5G", "40M", "HT", "3T", "142", "30",
	"ETSI", "5G", "40M", "HT", "3T", "142", "63",
	"MKK", "5G", "40M", "HT", "3T", "142", "63",
	"FCC", "5G", "40M", "HT", "3T", "151", "30",
	"ETSI", "5G", "40M", "HT", "3T", "151", "-63",
	"MKK", "5G", "40M", "HT", "3T", "151", "63",
	"FCC", "5G", "40M", "HT", "3T", "159", "30",
	"ETSI", "5G", "40M", "HT", "3T", "159", "-63",
	"MKK", "5G", "40M", "HT", "3T", "159", "63",
	"FCC", "5G", "40M", "HT", "4T", "38", "28",
	"ETSI", "5G", "40M", "HT", "4T", "38", "20",
	"MKK", "5G", "40M", "HT", "4T", "38", "20",
	"FCC", "5G", "40M", "HT", "4T", "46", "28",
	"ETSI", "5G", "40M", "HT", "4T", "46", "20",
	"MKK", "5G", "40M", "HT", "4T", "46", "20",
	"FCC", "5G", "40M", "HT", "4T", "54", "28",
	"ETSI", "5G", "40M", "HT", "4T", "54", "20",
	"MKK", "5G", "40M", "HT", "4T", "54", "20",
	"FCC", "5G", "40M", "HT", "4T", "62", "28",
	"ETSI", "5G", "40M", "HT", "4T", "62", "20",
	"MKK", "5G", "40M", "HT", "4T", "62", "20",
	"FCC", "5G", "40M", "HT", "4T", "102", "28",
	"ETSI", "5G", "40M", "HT", "4T", "102", "20",
	"MKK", "5G", "40M", "HT", "4T", "102", "28",
	"FCC", "5G", "40M", "HT", "4T", "110", "28",
	"ETSI", "5G", "40M", "HT", "4T", "110", "20",
	"MKK", "5G", "40M", "HT", "4T", "110", "28",
	"FCC", "5G", "40M", "HT", "4T", "118", "28",
	"ETSI", "5G", "40M", "HT", "4T", "118", "20",
	"MKK", "5G", "40M", "HT", "4T", "118", "28",
	"FCC", "5G", "40M", "HT", "4T", "126", "28",
	"ETSI", "5G", "40M", "HT", "4T", "126", "20",
	"MKK", "5G", "40M", "HT", "4T", "126", "28",
	"FCC", "5G", "40M", "HT", "4T", "134", "28",
	"ETSI", "5G", "40M", "HT", "4T", "134", "20",
	"MKK", "5G", "40M", "HT", "4T", "134", "28",
	"FCC", "5G", "40M", "HT", "4T", "142", "28",
	"ETSI", "5G", "40M", "HT", "4T", "142", "63",
	"MKK", "5G", "40M", "HT", "4T", "142", "63",
	"FCC", "5G", "40M", "HT", "4T", "151", "28",
	"ETSI", "5G", "40M", "HT", "4T", "151", "-63",
	"MKK", "5G", "40M", "HT", "4T", "151", "63",
	"FCC", "5G", "40M", "HT", "4T", "159", "28",
	"ETSI", "5G", "40M", "HT", "4T", "159", "-63",
	"MKK", "5G", "40M", "HT", "4T", "159", "63",
	"FCC", "5G", "80M", "VHT", "1T", "42", "30",
	"ETSI", "5G", "80M", "VHT", "1T", "42", "32",
	"MKK", "5G", "80M", "VHT", "1T", "42", "32",
	"FCC", "5G", "80M", "VHT", "1T", "58", "28",
	"ETSI", "5G", "80M", "VHT", "1T", "58", "32",
	"MKK", "5G", "80M", "VHT", "1T", "58", "32",
	"FCC", "5G", "80M", "VHT", "1T", "106", "28",
	"ETSI", "5G", "80M", "VHT", "1T", "106", "32",
	"MKK", "5G", "80M", "VHT", "1T", "106", "40",
	"FCC", "5G", "80M", "VHT", "1T", "122", "40",
	"ETSI", "5G", "80M", "VHT", "1T", "122", "32",
	"MKK", "5G", "80M", "VHT", "1T", "122", "40",
	"FCC", "5G", "80M", "VHT", "1T", "138", "40",
	"ETSI", "5G", "80M", "VHT", "1T", "138", "63",
	"MKK", "5G", "80M", "VHT", "1T", "138", "63",
	"FCC", "5G", "80M", "VHT", "1T", "155", "40",
	"ETSI", "5G", "80M", "VHT", "1T", "155", "-63",
	"MKK", "5G", "80M", "VHT", "1T", "155", "63",
	"FCC", "5G", "80M", "VHT", "2T", "42", "26",
	"ETSI", "5G", "80M", "VHT", "2T", "42", "26",
	"MKK", "5G", "80M", "VHT", "2T", "42", "26",
	"FCC", "5G", "80M", "VHT", "2T", "58", "26",
	"ETSI", "5G", "80M", "VHT", "2T", "58", "26",
	"MKK", "5G", "80M", "VHT", "2T", "58", "26",
	"FCC", "5G", "80M", "VHT", "2T", "106", "26",
	"ETSI", "5G", "80M", "VHT", "2T", "106", "26",
	"MKK", "5G", "80M", "VHT", "2T", "106", "34",
	"FCC", "5G", "80M", "VHT", "2T", "122", "34",
	"ETSI", "5G", "80M", "VHT", "2T", "122", "26",
	"MKK", "5G", "80M", "VHT", "2T", "122", "34",
	"FCC", "5G", "80M", "VHT", "2T", "138", "34",
	"ETSI", "5G", "80M", "VHT", "2T", "138", "63",
	"MKK", "5G", "80M", "VHT", "2T", "138", "63",
	"FCC", "5G", "80M", "VHT", "2T", "155", "34",
	"ETSI", "5G", "80M", "VHT", "2T", "155", "-63",
	"MKK", "5G", "80M", "VHT", "2T", "155", "63",
	"FCC", "5G", "80M", "VHT", "3T", "42", "26",
	"ETSI", "5G", "80M", "VHT", "3T", "42", "22",
	"MKK", "5G", "80M", "VHT", "3T", "42", "22",
	"FCC", "5G", "80M", "VHT", "3T", "58", "26",
	"ETSI", "5G", "80M", "VHT", "3T", "58", "22",
	"MKK", "5G", "80M", "VHT", "3T", "58", "22",
	"FCC", "5G", "80M", "VHT", "3T", "106", "26",
	"ETSI", "5G", "80M", "VHT", "3T", "106", "22",
	"MKK", "5G", "80M", "VHT", "3T", "106", "30",
	"FCC", "5G", "80M", "VHT", "3T", "122", "30",
	"ETSI", "5G", "80M", "VHT", "3T", "122", "22",
	"MKK", "5G", "80M", "VHT", "3T", "122", "30",
	"FCC", "5G", "80M", "VHT", "3T", "138", "30",
	"ETSI", "5G", "80M", "VHT", "3T", "138", "63",
	"MKK", "5G", "80M", "VHT", "3T", "138", "63",
	"FCC", "5G", "80M", "VHT", "3T", "155", "30",
	"ETSI", "5G", "80M", "VHT", "3T", "155", "-63",
	"MKK", "5G", "80M", "VHT", "3T", "155", "63",
	"FCC", "5G", "80M", "VHT", "4T", "42", "26",
	"ETSI", "5G", "80M", "VHT", "4T", "42", "20",
	"MKK", "5G", "80M", "VHT", "4T", "42", "20",
	"FCC", "5G", "80M", "VHT", "4T", "58", "26",
	"ETSI", "5G", "80M", "VHT", "4T", "58", "20",
	"MKK", "5G", "80M", "VHT", "4T", "58", "20",
	"FCC", "5G", "80M", "VHT", "4T", "106", "26",
	"ETSI", "5G", "80M", "VHT", "4T", "106", "20",
	"MKK", "5G", "80M", "VHT", "4T", "106", "28",
	"FCC", "5G", "80M", "VHT", "4T", "122", "28",
	"ETSI", "5G", "80M", "VHT", "4T", "122", "20",
	"MKK", "5G", "80M", "VHT", "4T", "122", "28",
	"FCC", "5G", "80M", "VHT", "4T", "138", "28",
	"ETSI", "5G", "80M", "VHT", "4T", "138", "63",
	"MKK", "5G", "80M", "VHT", "4T", "138", "63",
	"FCC", "5G", "80M", "VHT", "4T", "155", "28",
	"ETSI", "5G", "80M", "VHT", "4T", "155", "-63",
	"MKK", "5G", "80M", "VHT", "4T", "155", "63"
};
#endif

void
odm_read_and_config_mp_8814c_txpwr_lmt(struct dm_struct *dm)
{
#ifdef CONFIG_8814C

	u32	i = 0;
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
	u32	array_len =
			sizeof(array_mp_8814c_txpwr_lmt) / sizeof(u8);
	u8	*array = (u8 *)array_mp_8814c_txpwr_lmt;
#else
	u32	array_len =
			sizeof(array_mp_8814c_txpwr_lmt) / sizeof(u8 *);
	u8	**array = (u8 **)array_mp_8814c_txpwr_lmt;
#endif

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrLmt, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrLmt = array_len / 7;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	for (i = 0; i < array_len; i += 7) {
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
		u8	regulation = array[i];
		u8	band = array[i + 1];
		u8	bandwidth = array[i + 2];
		u8	rate = array[i + 3];
		u8	rf_path = array[i + 4];
		u8	chnl = array[i + 5];
		u8	val = array[i + 6];
#else
		u8	*regulation = array[i];
		u8	*band = array[i + 1];
		u8	*bandwidth = array[i + 2];
		u8	*rate = array[i + 3];
		u8	*rf_path = array[i + 4];
		u8	*chnl = array[i + 5];
		u8	*val = array[i + 6];
#endif

		odm_config_bb_txpwr_lmt_8814c(dm, regulation, band, bandwidth,
					      rate, rf_path, chnl, val);
#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
		rsprintf((char *)hal_data->BufOfLinesPwrLmt[i / 7], 100, "\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\",",
			 regulation, band, bandwidth, rate, rf_path, chnl, val);
#endif
	}

#endif
}

#endif /* end of HWIMG_SUPPORT*/

