/******************************************************************************
 *
 * Copyright(c) 2007 - 2017 Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * The full GNU General Public License is included in this distribution in the
 * file called LICENSE.
 *
 * Contact Information:
 * wlanfae <wlanfae@realtek.com>
 * Realtek Corporation, No. 2, Innovation Road II, Hsinchu Science Park,
 * Hsinchu 300, Taiwan.
 *
 * Larry Finger <Larry.Finger@lwfinger.net>
 *
 *****************************************************************************/

/*Image2HeaderVersion: R3 1.5.5*/
#include "mp_precomp.h"
#include "../phydm_precomp.h"

#if (RTL8197G_SUPPORT == 1)
static boolean
check_positive(struct dm_struct *dm,
	       const u32	condition1,
	       const u32	condition2,
	       const u32	condition3,
	       const u32	condition4
)
{
	u32	cond1 = condition1, cond2 = condition2,
		cond3 = condition3, cond4 = condition4;

	u8	cut_version_for_para =
		(dm->cut_version ==  ODM_CUT_A) ? 15 : dm->cut_version;

	u8	pkg_type_for_para =
		(dm->package_type == 0) ? 15 : dm->package_type;

	u32	driver1 = cut_version_for_para << 24 |
			(dm->support_interface & 0xF0) << 16 |
			dm->support_platform << 16 |
			pkg_type_for_para << 12 |
			(dm->support_interface & 0x0F) << 8  |
			dm->rfe_type;

	u32	driver2 = (dm->type_glna & 0xFF) <<  0 |
			(dm->type_gpa & 0xFF)  <<  8 |
			(dm->type_alna & 0xFF) << 16 |
			(dm->type_apa & 0xFF)  << 24;

	u32	driver3 = 0;

	u32	driver4 = (dm->type_glna & 0xFF00) >>  8 |
			(dm->type_gpa & 0xFF00) |
			(dm->type_alna & 0xFF00) << 8 |
			(dm->type_apa & 0xFF00)  << 16;

	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "===> %s (cond1, cond2, cond3, cond4) = (0x%X 0x%X 0x%X 0x%X)\n",
		  __func__, cond1, cond2, cond3, cond4);
	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "===> %s (driver1, driver2, driver3, driver4) = (0x%X 0x%X 0x%X 0x%X)\n",
		  __func__, driver1, driver2, driver3, driver4);

	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "	(Platform, Interface) = (0x%X, 0x%X)\n",
		  dm->support_platform, dm->support_interface);
	PHYDM_DBG(dm, ODM_COMP_INIT, "	(RFE, Package) = (0x%X, 0x%X)\n",
		  dm->rfe_type, dm->package_type);

	/*============== value Defined Check ===============*/
	/*cut version [27:24] need to do value check*/
	if (((cond1 & 0x0F000000) != 0) &&
	    ((cond1 & 0x0F000000) != (driver1 & 0x0F000000)))
		return false;

	/*pkg type [15:12] need to do value check*/
	if (((cond1 & 0x0000F000) != 0) &&
	    ((cond1 & 0x0000F000) != (driver1 & 0x0000F000)))
		return false;

	/*interface [11:8] need to do value check*/
	if (((cond1 & 0x00000F00) != 0) &&
	    ((cond1 & 0x00000F00) != (driver1 & 0x00000F00)))
		return false;
	/*=============== Bit Defined Check ================*/
	/* We don't care [31:28] */

	cond1 &= 0x000000FF;
	driver1 &= 0x000000FF;

	if (cond1 == driver1)
		return true;
	else
		return false;
}


/******************************************************************************
 *                           agc_tab.TXT
 ******************************************************************************/

const u32 array_mp_8197g_agc_tab[] = {
	0x81000000,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x300000FF,
		0x1D90, 0x300100FF,
		0x1D90, 0x300200FF,
		0x1D90, 0x300300FF,
		0x1D90, 0x300400FF,
		0x1D90, 0x300500FF,
		0x1D90, 0x300600FF,
		0x1D90, 0x300700FF,
		0x1D90, 0x300800FE,
		0x1D90, 0x300900FD,
		0x1D90, 0x300A00FC,
		0x1D90, 0x300B00FB,
		0x1D90, 0x300C00FA,
		0x1D90, 0x300D00F9,
		0x1D90, 0x300E00F8,
		0x1D90, 0x300F00F7,
		0x1D90, 0x301000F6,
		0x1D90, 0x301100F5,
		0x1D90, 0x301200F4,
		0x1D90, 0x301300F3,
		0x1D90, 0x301400F2,
		0x1D90, 0x301500F1,
		0x1D90, 0x301600F0,
		0x1D90, 0x301700EF,
		0x1D90, 0x301800EE,
		0x1D90, 0x301900ED,
		0x1D90, 0x301A00EC,
		0x1D90, 0x301B00EB,
		0x1D90, 0x301C00EA,
		0x1D90, 0x301D00E9,
		0x1D90, 0x301E00E8,
		0x1D90, 0x301F00E7,
		0x1D90, 0x302000E6,
		0x1D90, 0x302100E5,
		0x1D90, 0x302200E4,
		0x1D90, 0x302300E3,
		0x1D90, 0x302400E2,
		0x1D90, 0x302500E1,
		0x1D90, 0x302600E0,
		0x1D90, 0x302700A3,
		0x1D90, 0x302800A2,
		0x1D90, 0x302900A1,
		0x1D90, 0x302A00A0,
		0x1D90, 0x302B0082,
		0x1D90, 0x302C0081,
		0x1D90, 0x302D0080,
		0x1D90, 0x302E0062,
		0x1D90, 0x302F0061,
		0x1D90, 0x30300060,
		0x1D90, 0x30310043,
		0x1D90, 0x30320042,
		0x1D90, 0x30330041,
		0x1D90, 0x30340040,
		0x1D90, 0x30350024,
		0x1D90, 0x30360023,
		0x1D90, 0x30370022,
		0x1D90, 0x30380021,
		0x1D90, 0x30390004,
		0x1D90, 0x303A0003,
		0x1D90, 0x303B0002,
		0x1D90, 0x303C0001,
		0x1D90, 0x303D0000,
		0x1D90, 0x303E0000,
		0x1D90, 0x303F0000,
	0x91000001,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x300000BF,
		0x1D90, 0x300100BF,
		0x1D90, 0x300200BF,
		0x1D90, 0x300300BF,
		0x1D90, 0x300400BF,
		0x1D90, 0x300500BF,
		0x1D90, 0x300600BF,
		0x1D90, 0x300700BE,
		0x1D90, 0x300800BD,
		0x1D90, 0x300900BC,
		0x1D90, 0x300A00BB,
		0x1D90, 0x300B00BA,
		0x1D90, 0x300C00B9,
		0x1D90, 0x300D00B8,
		0x1D90, 0x300E00B7,
		0x1D90, 0x300F00B6,
		0x1D90, 0x301000B5,
		0x1D90, 0x301100B4,
		0x1D90, 0x301200B3,
		0x1D90, 0x301300B2,
		0x1D90, 0x301400B1,
		0x1D90, 0x301500B0,
		0x1D90, 0x301600AF,
		0x1D90, 0x301700AE,
		0x1D90, 0x301800AD,
		0x1D90, 0x301900AC,
		0x1D90, 0x301A00AB,
		0x1D90, 0x301B00AA,
		0x1D90, 0x301C00A9,
		0x1D90, 0x301D00A8,
		0x1D90, 0x301E00A7,
		0x1D90, 0x301F00A6,
		0x1D90, 0x302000A5,
		0x1D90, 0x302100A4,
		0x1D90, 0x302200A3,
		0x1D90, 0x302300A2,
		0x1D90, 0x302400A1,
		0x1D90, 0x302500A0,
		0x1D90, 0x30260082,
		0x1D90, 0x30270081,
		0x1D90, 0x30280080,
		0x1D90, 0x30290062,
		0x1D90, 0x302A0061,
		0x1D90, 0x302B0060,
		0x1D90, 0x302C0043,
		0x1D90, 0x302D0042,
		0x1D90, 0x302E0041,
		0x1D90, 0x302F0040,
		0x1D90, 0x30300024,
		0x1D90, 0x30310023,
		0x1D90, 0x30320022,
		0x1D90, 0x30330021,
		0x1D90, 0x30340004,
		0x1D90, 0x30350003,
		0x1D90, 0x30360002,
		0x1D90, 0x30370001,
		0x1D90, 0x30380000,
		0x1D90, 0x30390000,
		0x1D90, 0x303A0000,
		0x1D90, 0x303B0000,
		0x1D90, 0x303C0000,
		0x1D90, 0x303D0000,
		0x1D90, 0x303E0000,
		0x1D90, 0x303F0000,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x300000FF,
		0x1D90, 0x300100FF,
		0x1D90, 0x300200FF,
		0x1D90, 0x300300FF,
		0x1D90, 0x300400FF,
		0x1D90, 0x300500FF,
		0x1D90, 0x300600FF,
		0x1D90, 0x300700FF,
		0x1D90, 0x300800FE,
		0x1D90, 0x300900FD,
		0x1D90, 0x300A00FC,
		0x1D90, 0x300B00FB,
		0x1D90, 0x300C00FA,
		0x1D90, 0x300D00F9,
		0x1D90, 0x300E00F8,
		0x1D90, 0x300F00F7,
		0x1D90, 0x301000F6,
		0x1D90, 0x301100F5,
		0x1D90, 0x301200F4,
		0x1D90, 0x301300F3,
		0x1D90, 0x301400F2,
		0x1D90, 0x301500F1,
		0x1D90, 0x301600F0,
		0x1D90, 0x301700EF,
		0x1D90, 0x301800EE,
		0x1D90, 0x301900ED,
		0x1D90, 0x301A00EC,
		0x1D90, 0x301B00EB,
		0x1D90, 0x301C00EA,
		0x1D90, 0x301D00E9,
		0x1D90, 0x301E00E8,
		0x1D90, 0x301F00E7,
		0x1D90, 0x302000E6,
		0x1D90, 0x302100E5,
		0x1D90, 0x302200E4,
		0x1D90, 0x302300E3,
		0x1D90, 0x302400E2,
		0x1D90, 0x302500E1,
		0x1D90, 0x302600E0,
		0x1D90, 0x302700A3,
		0x1D90, 0x302800A2,
		0x1D90, 0x302900A1,
		0x1D90, 0x302A00A0,
		0x1D90, 0x302B0082,
		0x1D90, 0x302C0081,
		0x1D90, 0x302D0080,
		0x1D90, 0x302E0062,
		0x1D90, 0x302F0061,
		0x1D90, 0x30300060,
		0x1D90, 0x30310043,
		0x1D90, 0x30320042,
		0x1D90, 0x30330041,
		0x1D90, 0x30340040,
		0x1D90, 0x30350024,
		0x1D90, 0x30360023,
		0x1D90, 0x30370022,
		0x1D90, 0x30380021,
		0x1D90, 0x30390004,
		0x1D90, 0x303A0003,
		0x1D90, 0x303B0002,
		0x1D90, 0x303C0001,
		0x1D90, 0x303D0000,
		0x1D90, 0x303E0000,
		0x1D90, 0x303F0000,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x300000FF,
		0x1D90, 0x300100FF,
		0x1D90, 0x300200FF,
		0x1D90, 0x300300FF,
		0x1D90, 0x300400FF,
		0x1D90, 0x300500FF,
		0x1D90, 0x300600FF,
		0x1D90, 0x300700FF,
		0x1D90, 0x300800FF,
		0x1D90, 0x300900FF,
		0x1D90, 0x300A00FE,
		0x1D90, 0x300B00FD,
		0x1D90, 0x300C00FC,
		0x1D90, 0x300D00FB,
		0x1D90, 0x300E00FA,
		0x1D90, 0x300F00F9,
		0x1D90, 0x301000F8,
		0x1D90, 0x301100F7,
		0x1D90, 0x301200F6,
		0x1D90, 0x301300F5,
		0x1D90, 0x301400F4,
		0x1D90, 0x301500F3,
		0x1D90, 0x301600F2,
		0x1D90, 0x301700F1,
		0x1D90, 0x301800F0,
		0x1D90, 0x301900EF,
		0x1D90, 0x301A00EE,
		0x1D90, 0x301B00ED,
		0x1D90, 0x301C00EC,
		0x1D90, 0x301D00EB,
		0x1D90, 0x301E00EA,
		0x1D90, 0x301F00E9,
		0x1D90, 0x302000E8,
		0x1D90, 0x302100E7,
		0x1D90, 0x302200E6,
		0x1D90, 0x302300E5,
		0x1D90, 0x302400E4,
		0x1D90, 0x302500E3,
		0x1D90, 0x302600E2,
		0x1D90, 0x302700E1,
		0x1D90, 0x302800E0,
		0x1D90, 0x302900A3,
		0x1D90, 0x302A00A2,
		0x1D90, 0x302B00A1,
		0x1D90, 0x302C00A0,
		0x1D90, 0x302D0082,
		0x1D90, 0x302E0081,
		0x1D90, 0x302F0080,
		0x1D90, 0x30300062,
		0x1D90, 0x30310061,
		0x1D90, 0x30320060,
		0x1D90, 0x30330043,
		0x1D90, 0x30340042,
		0x1D90, 0x30350041,
		0x1D90, 0x30360040,
		0x1D90, 0x30370024,
		0x1D90, 0x30380023,
		0x1D90, 0x30390022,
		0x1D90, 0x303A0021,
		0x1D90, 0x303B0004,
		0x1D90, 0x303C0003,
		0x1D90, 0x303D0002,
		0x1D90, 0x303E0001,
		0x1D90, 0x303F0000,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x300000BF,
		0x1D90, 0x300100BF,
		0x1D90, 0x300200BF,
		0x1D90, 0x300300BF,
		0x1D90, 0x300400BF,
		0x1D90, 0x300500BF,
		0x1D90, 0x300600BF,
		0x1D90, 0x300700BE,
		0x1D90, 0x300800BD,
		0x1D90, 0x300900BC,
		0x1D90, 0x300A00BB,
		0x1D90, 0x300B00BA,
		0x1D90, 0x300C00B9,
		0x1D90, 0x300D00B8,
		0x1D90, 0x300E00B7,
		0x1D90, 0x300F00B6,
		0x1D90, 0x301000B5,
		0x1D90, 0x301100B4,
		0x1D90, 0x301200B3,
		0x1D90, 0x301300B2,
		0x1D90, 0x301400B1,
		0x1D90, 0x301500B0,
		0x1D90, 0x301600AF,
		0x1D90, 0x301700AE,
		0x1D90, 0x301800AD,
		0x1D90, 0x301900AC,
		0x1D90, 0x301A00AB,
		0x1D90, 0x301B00AA,
		0x1D90, 0x301C00A9,
		0x1D90, 0x301D00A8,
		0x1D90, 0x301E00A7,
		0x1D90, 0x301F00A6,
		0x1D90, 0x302000A5,
		0x1D90, 0x302100A4,
		0x1D90, 0x302200A3,
		0x1D90, 0x302300A2,
		0x1D90, 0x302400A1,
		0x1D90, 0x302500A0,
		0x1D90, 0x30260082,
		0x1D90, 0x30270081,
		0x1D90, 0x30280080,
		0x1D90, 0x30290062,
		0x1D90, 0x302A0061,
		0x1D90, 0x302B0060,
		0x1D90, 0x302C0043,
		0x1D90, 0x302D0042,
		0x1D90, 0x302E0041,
		0x1D90, 0x302F0040,
		0x1D90, 0x30300024,
		0x1D90, 0x30310023,
		0x1D90, 0x30320022,
		0x1D90, 0x30330021,
		0x1D90, 0x30340004,
		0x1D90, 0x30350003,
		0x1D90, 0x30360002,
		0x1D90, 0x30370001,
		0x1D90, 0x30380000,
		0x1D90, 0x30390000,
		0x1D90, 0x303A0000,
		0x1D90, 0x303B0000,
		0x1D90, 0x303C0000,
		0x1D90, 0x303D0000,
		0x1D90, 0x303E0000,
		0x1D90, 0x303F0000,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x300000BF,
		0x1D90, 0x300100BF,
		0x1D90, 0x300200BF,
		0x1D90, 0x300300BF,
		0x1D90, 0x300400BF,
		0x1D90, 0x300500BF,
		0x1D90, 0x300600BF,
		0x1D90, 0x300700BE,
		0x1D90, 0x300800BD,
		0x1D90, 0x300900BC,
		0x1D90, 0x300A00BB,
		0x1D90, 0x300B00BA,
		0x1D90, 0x300C00B9,
		0x1D90, 0x300D00B8,
		0x1D90, 0x300E00B7,
		0x1D90, 0x300F00B6,
		0x1D90, 0x301000B5,
		0x1D90, 0x301100B4,
		0x1D90, 0x301200B3,
		0x1D90, 0x301300B2,
		0x1D90, 0x301400B1,
		0x1D90, 0x301500B0,
		0x1D90, 0x301600AF,
		0x1D90, 0x301700AE,
		0x1D90, 0x301800AD,
		0x1D90, 0x301900AC,
		0x1D90, 0x301A00AB,
		0x1D90, 0x301B00AA,
		0x1D90, 0x301C00A9,
		0x1D90, 0x301D00A8,
		0x1D90, 0x301E00A7,
		0x1D90, 0x301F00A6,
		0x1D90, 0x302000A5,
		0x1D90, 0x302100A4,
		0x1D90, 0x302200A3,
		0x1D90, 0x302300A2,
		0x1D90, 0x302400A1,
		0x1D90, 0x302500A0,
		0x1D90, 0x30260082,
		0x1D90, 0x30270081,
		0x1D90, 0x30280080,
		0x1D90, 0x30290062,
		0x1D90, 0x302A0061,
		0x1D90, 0x302B0060,
		0x1D90, 0x302C0043,
		0x1D90, 0x302D0042,
		0x1D90, 0x302E0041,
		0x1D90, 0x302F0040,
		0x1D90, 0x30300024,
		0x1D90, 0x30310023,
		0x1D90, 0x30320022,
		0x1D90, 0x30330021,
		0x1D90, 0x30340004,
		0x1D90, 0x30350003,
		0x1D90, 0x30360002,
		0x1D90, 0x30370001,
		0x1D90, 0x30380000,
		0x1D90, 0x30390000,
		0x1D90, 0x303A0000,
		0x1D90, 0x303B0000,
		0x1D90, 0x303C0000,
		0x1D90, 0x303D0000,
		0x1D90, 0x303E0000,
		0x1D90, 0x303F0000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x300000BF,
		0x1D90, 0x300100BF,
		0x1D90, 0x300200BF,
		0x1D90, 0x300300BF,
		0x1D90, 0x300400BF,
		0x1D90, 0x300500BF,
		0x1D90, 0x300600BF,
		0x1D90, 0x300700BE,
		0x1D90, 0x300800BD,
		0x1D90, 0x300900BC,
		0x1D90, 0x300A00BB,
		0x1D90, 0x300B00BA,
		0x1D90, 0x300C00B9,
		0x1D90, 0x300D00B8,
		0x1D90, 0x300E00B7,
		0x1D90, 0x300F00B6,
		0x1D90, 0x301000B5,
		0x1D90, 0x301100B4,
		0x1D90, 0x301200B3,
		0x1D90, 0x301300B2,
		0x1D90, 0x301400B1,
		0x1D90, 0x301500B0,
		0x1D90, 0x301600AF,
		0x1D90, 0x301700AE,
		0x1D90, 0x301800AD,
		0x1D90, 0x301900AC,
		0x1D90, 0x301A00AB,
		0x1D90, 0x301B00AA,
		0x1D90, 0x301C00A9,
		0x1D90, 0x301D00A8,
		0x1D90, 0x301E00A7,
		0x1D90, 0x301F00A6,
		0x1D90, 0x302000A5,
		0x1D90, 0x302100A4,
		0x1D90, 0x302200A3,
		0x1D90, 0x302300A2,
		0x1D90, 0x302400A1,
		0x1D90, 0x302500A0,
		0x1D90, 0x30260082,
		0x1D90, 0x30270081,
		0x1D90, 0x30280080,
		0x1D90, 0x30290062,
		0x1D90, 0x302A0061,
		0x1D90, 0x302B0060,
		0x1D90, 0x302C0043,
		0x1D90, 0x302D0042,
		0x1D90, 0x302E0041,
		0x1D90, 0x302F0040,
		0x1D90, 0x30300024,
		0x1D90, 0x30310023,
		0x1D90, 0x30320022,
		0x1D90, 0x30330021,
		0x1D90, 0x30340004,
		0x1D90, 0x30350003,
		0x1D90, 0x30360002,
		0x1D90, 0x30370001,
		0x1D90, 0x30380000,
		0x1D90, 0x30390000,
		0x1D90, 0x303A0000,
		0x1D90, 0x303B0000,
		0x1D90, 0x303C0000,
		0x1D90, 0x303D0000,
		0x1D90, 0x303E0000,
		0x1D90, 0x303F0000,
	0xA0000000,	0x00000000,
		0x1D90, 0x300000FF,
		0x1D90, 0x300100FF,
		0x1D90, 0x300200FF,
		0x1D90, 0x300300FF,
		0x1D90, 0x300400FF,
		0x1D90, 0x300500FF,
		0x1D90, 0x300600FF,
		0x1D90, 0x300700FF,
		0x1D90, 0x300800FE,
		0x1D90, 0x300900FD,
		0x1D90, 0x300A00FC,
		0x1D90, 0x300B00FB,
		0x1D90, 0x300C00FA,
		0x1D90, 0x300D00F9,
		0x1D90, 0x300E00F8,
		0x1D90, 0x300F00F7,
		0x1D90, 0x301000F6,
		0x1D90, 0x301100F5,
		0x1D90, 0x301200F4,
		0x1D90, 0x301300F3,
		0x1D90, 0x301400F2,
		0x1D90, 0x301500F1,
		0x1D90, 0x301600F0,
		0x1D90, 0x301700EF,
		0x1D90, 0x301800EE,
		0x1D90, 0x301900ED,
		0x1D90, 0x301A00EC,
		0x1D90, 0x301B00EB,
		0x1D90, 0x301C00EA,
		0x1D90, 0x301D00E9,
		0x1D90, 0x301E00E8,
		0x1D90, 0x301F00E7,
		0x1D90, 0x302000E6,
		0x1D90, 0x302100E5,
		0x1D90, 0x302200E4,
		0x1D90, 0x302300E3,
		0x1D90, 0x302400E2,
		0x1D90, 0x302500E1,
		0x1D90, 0x302600E0,
		0x1D90, 0x302700A3,
		0x1D90, 0x302800A2,
		0x1D90, 0x302900A1,
		0x1D90, 0x302A00A0,
		0x1D90, 0x302B0082,
		0x1D90, 0x302C0081,
		0x1D90, 0x302D0080,
		0x1D90, 0x302E0062,
		0x1D90, 0x302F0061,
		0x1D90, 0x30300060,
		0x1D90, 0x30310043,
		0x1D90, 0x30320042,
		0x1D90, 0x30330041,
		0x1D90, 0x30340040,
		0x1D90, 0x30350024,
		0x1D90, 0x30360023,
		0x1D90, 0x30370022,
		0x1D90, 0x30380021,
		0x1D90, 0x30390004,
		0x1D90, 0x303A0003,
		0x1D90, 0x303B0002,
		0x1D90, 0x303C0001,
		0x1D90, 0x303D0000,
		0x1D90, 0x303E0000,
		0x1D90, 0x303F0000,
	0xB0000000,	0x00000000,
	0x81000000,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x304000FF,
		0x1D90, 0x304100FF,
		0x1D90, 0x304200FE,
		0x1D90, 0x304300FD,
		0x1D90, 0x304400FC,
		0x1D90, 0x304500FB,
		0x1D90, 0x304600FA,
		0x1D90, 0x304700F9,
		0x1D90, 0x304800F8,
		0x1D90, 0x304900F7,
		0x1D90, 0x304A00F6,
		0x1D90, 0x304B00F5,
		0x1D90, 0x304C00F4,
		0x1D90, 0x304D00F3,
		0x1D90, 0x304E00F2,
		0x1D90, 0x304F00F1,
		0x1D90, 0x305000F0,
		0x1D90, 0x305100EF,
		0x1D90, 0x305200EE,
		0x1D90, 0x305300ED,
		0x1D90, 0x305400EC,
		0x1D90, 0x305500EB,
		0x1D90, 0x305600EA,
		0x1D90, 0x305700E9,
		0x1D90, 0x305800E8,
		0x1D90, 0x305900E7,
		0x1D90, 0x305A00E6,
		0x1D90, 0x305B00E5,
		0x1D90, 0x305C00E4,
		0x1D90, 0x305D00E3,
		0x1D90, 0x305E00E2,
		0x1D90, 0x305F00E1,
		0x1D90, 0x306000E0,
		0x1D90, 0x306100A3,
		0x1D90, 0x306200A2,
		0x1D90, 0x306300A1,
		0x1D90, 0x306400A0,
		0x1D90, 0x30650082,
		0x1D90, 0x30660081,
		0x1D90, 0x30670080,
		0x1D90, 0x30680062,
		0x1D90, 0x30690061,
		0x1D90, 0x306A0060,
		0x1D90, 0x306B0043,
		0x1D90, 0x306C0042,
		0x1D90, 0x306D0041,
		0x1D90, 0x306E0040,
		0x1D90, 0x306F0024,
		0x1D90, 0x30700023,
		0x1D90, 0x30710022,
		0x1D90, 0x30720021,
		0x1D90, 0x30730004,
		0x1D90, 0x30740003,
		0x1D90, 0x30750002,
		0x1D90, 0x30760001,
		0x1D90, 0x30770000,
		0x1D90, 0x30780000,
		0x1D90, 0x30790000,
		0x1D90, 0x307A0000,
		0x1D90, 0x307B0000,
		0x1D90, 0x307C0000,
		0x1D90, 0x307D0000,
		0x1D90, 0x307E0000,
		0x1D90, 0x307F0000,
	0x91000001,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x304000FF,
		0x1D90, 0x304100FF,
		0x1D90, 0x304200FE,
		0x1D90, 0x304300FD,
		0x1D90, 0x304400FC,
		0x1D90, 0x304500FB,
		0x1D90, 0x304600FA,
		0x1D90, 0x304700F9,
		0x1D90, 0x304800F8,
		0x1D90, 0x304900F7,
		0x1D90, 0x304A00F6,
		0x1D90, 0x304B00F5,
		0x1D90, 0x304C00F4,
		0x1D90, 0x304D00F3,
		0x1D90, 0x304E00F2,
		0x1D90, 0x304F00F1,
		0x1D90, 0x305000F0,
		0x1D90, 0x305100EF,
		0x1D90, 0x305200EE,
		0x1D90, 0x305300ED,
		0x1D90, 0x305400EC,
		0x1D90, 0x305500EB,
		0x1D90, 0x305600EA,
		0x1D90, 0x305700E9,
		0x1D90, 0x305800E8,
		0x1D90, 0x305900E7,
		0x1D90, 0x305A00E6,
		0x1D90, 0x305B00E5,
		0x1D90, 0x305C00E4,
		0x1D90, 0x305D00E3,
		0x1D90, 0x305E00E2,
		0x1D90, 0x305F00E1,
		0x1D90, 0x306000E0,
		0x1D90, 0x306100A3,
		0x1D90, 0x306200A2,
		0x1D90, 0x306300A1,
		0x1D90, 0x306400A0,
		0x1D90, 0x30650082,
		0x1D90, 0x30660081,
		0x1D90, 0x30670080,
		0x1D90, 0x30680062,
		0x1D90, 0x30690061,
		0x1D90, 0x306A0060,
		0x1D90, 0x306B0043,
		0x1D90, 0x306C0042,
		0x1D90, 0x306D0041,
		0x1D90, 0x306E0040,
		0x1D90, 0x306F0024,
		0x1D90, 0x30700023,
		0x1D90, 0x30710022,
		0x1D90, 0x30720021,
		0x1D90, 0x30730004,
		0x1D90, 0x30740003,
		0x1D90, 0x30750002,
		0x1D90, 0x30760001,
		0x1D90, 0x30770000,
		0x1D90, 0x30780000,
		0x1D90, 0x30790000,
		0x1D90, 0x307A0000,
		0x1D90, 0x307B0000,
		0x1D90, 0x307C0000,
		0x1D90, 0x307D0000,
		0x1D90, 0x307E0000,
		0x1D90, 0x307F0000,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x304000FF,
		0x1D90, 0x304100FF,
		0x1D90, 0x304200FE,
		0x1D90, 0x304300FD,
		0x1D90, 0x304400FC,
		0x1D90, 0x304500FB,
		0x1D90, 0x304600FA,
		0x1D90, 0x304700F9,
		0x1D90, 0x304800F8,
		0x1D90, 0x304900F7,
		0x1D90, 0x304A00F6,
		0x1D90, 0x304B00F5,
		0x1D90, 0x304C00F4,
		0x1D90, 0x304D00F3,
		0x1D90, 0x304E00F2,
		0x1D90, 0x304F00F1,
		0x1D90, 0x305000F0,
		0x1D90, 0x305100EF,
		0x1D90, 0x305200EE,
		0x1D90, 0x305300ED,
		0x1D90, 0x305400EC,
		0x1D90, 0x305500EB,
		0x1D90, 0x305600EA,
		0x1D90, 0x305700E9,
		0x1D90, 0x305800E8,
		0x1D90, 0x305900E7,
		0x1D90, 0x305A00E6,
		0x1D90, 0x305B00E5,
		0x1D90, 0x305C00E4,
		0x1D90, 0x305D00E3,
		0x1D90, 0x305E00E2,
		0x1D90, 0x305F00E1,
		0x1D90, 0x306000E0,
		0x1D90, 0x306100A3,
		0x1D90, 0x306200A2,
		0x1D90, 0x306300A1,
		0x1D90, 0x306400A0,
		0x1D90, 0x30650082,
		0x1D90, 0x30660081,
		0x1D90, 0x30670080,
		0x1D90, 0x30680062,
		0x1D90, 0x30690061,
		0x1D90, 0x306A0060,
		0x1D90, 0x306B0043,
		0x1D90, 0x306C0042,
		0x1D90, 0x306D0041,
		0x1D90, 0x306E0040,
		0x1D90, 0x306F0024,
		0x1D90, 0x30700023,
		0x1D90, 0x30710022,
		0x1D90, 0x30720021,
		0x1D90, 0x30730004,
		0x1D90, 0x30740003,
		0x1D90, 0x30750002,
		0x1D90, 0x30760001,
		0x1D90, 0x30770000,
		0x1D90, 0x30780000,
		0x1D90, 0x30790000,
		0x1D90, 0x307A0000,
		0x1D90, 0x307B0000,
		0x1D90, 0x307C0000,
		0x1D90, 0x307D0000,
		0x1D90, 0x307E0000,
		0x1D90, 0x307F0000,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x304000FF,
		0x1D90, 0x304100FF,
		0x1D90, 0x304200FE,
		0x1D90, 0x304300FD,
		0x1D90, 0x304400FC,
		0x1D90, 0x304500FB,
		0x1D90, 0x304600FA,
		0x1D90, 0x304700F9,
		0x1D90, 0x304800F8,
		0x1D90, 0x304900F7,
		0x1D90, 0x304A00F6,
		0x1D90, 0x304B00F5,
		0x1D90, 0x304C00F4,
		0x1D90, 0x304D00F3,
		0x1D90, 0x304E00F2,
		0x1D90, 0x304F00F1,
		0x1D90, 0x305000F0,
		0x1D90, 0x305100EF,
		0x1D90, 0x305200EE,
		0x1D90, 0x305300ED,
		0x1D90, 0x305400EC,
		0x1D90, 0x305500EB,
		0x1D90, 0x305600EA,
		0x1D90, 0x305700E9,
		0x1D90, 0x305800E8,
		0x1D90, 0x305900E7,
		0x1D90, 0x305A00E6,
		0x1D90, 0x305B00E5,
		0x1D90, 0x305C00E4,
		0x1D90, 0x305D00E3,
		0x1D90, 0x305E00E2,
		0x1D90, 0x305F00E1,
		0x1D90, 0x306000E0,
		0x1D90, 0x306100A3,
		0x1D90, 0x306200A2,
		0x1D90, 0x306300A1,
		0x1D90, 0x306400A0,
		0x1D90, 0x30650082,
		0x1D90, 0x30660081,
		0x1D90, 0x30670080,
		0x1D90, 0x30680062,
		0x1D90, 0x30690061,
		0x1D90, 0x306A0060,
		0x1D90, 0x306B0043,
		0x1D90, 0x306C0042,
		0x1D90, 0x306D0041,
		0x1D90, 0x306E0040,
		0x1D90, 0x306F0024,
		0x1D90, 0x30700023,
		0x1D90, 0x30710022,
		0x1D90, 0x30720021,
		0x1D90, 0x30730004,
		0x1D90, 0x30740003,
		0x1D90, 0x30750002,
		0x1D90, 0x30760001,
		0x1D90, 0x30770000,
		0x1D90, 0x30780000,
		0x1D90, 0x30790000,
		0x1D90, 0x307A0000,
		0x1D90, 0x307B0000,
		0x1D90, 0x307C0000,
		0x1D90, 0x307D0000,
		0x1D90, 0x307E0000,
		0x1D90, 0x307F0000,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x304000FF,
		0x1D90, 0x304100FF,
		0x1D90, 0x304200FE,
		0x1D90, 0x304300FD,
		0x1D90, 0x304400FC,
		0x1D90, 0x304500FB,
		0x1D90, 0x304600FA,
		0x1D90, 0x304700F9,
		0x1D90, 0x304800F8,
		0x1D90, 0x304900F7,
		0x1D90, 0x304A00F6,
		0x1D90, 0x304B00F5,
		0x1D90, 0x304C00F4,
		0x1D90, 0x304D00F3,
		0x1D90, 0x304E00F2,
		0x1D90, 0x304F00F1,
		0x1D90, 0x305000F0,
		0x1D90, 0x305100EF,
		0x1D90, 0x305200EE,
		0x1D90, 0x305300ED,
		0x1D90, 0x305400EC,
		0x1D90, 0x305500EB,
		0x1D90, 0x305600EA,
		0x1D90, 0x305700E9,
		0x1D90, 0x305800E8,
		0x1D90, 0x305900E7,
		0x1D90, 0x305A00E6,
		0x1D90, 0x305B00E5,
		0x1D90, 0x305C00E4,
		0x1D90, 0x305D00E3,
		0x1D90, 0x305E00E2,
		0x1D90, 0x305F00E1,
		0x1D90, 0x306000E0,
		0x1D90, 0x306100A3,
		0x1D90, 0x306200A2,
		0x1D90, 0x306300A1,
		0x1D90, 0x306400A0,
		0x1D90, 0x30650082,
		0x1D90, 0x30660081,
		0x1D90, 0x30670080,
		0x1D90, 0x30680062,
		0x1D90, 0x30690061,
		0x1D90, 0x306A0060,
		0x1D90, 0x306B0043,
		0x1D90, 0x306C0042,
		0x1D90, 0x306D0041,
		0x1D90, 0x306E0040,
		0x1D90, 0x306F0024,
		0x1D90, 0x30700023,
		0x1D90, 0x30710022,
		0x1D90, 0x30720021,
		0x1D90, 0x30730004,
		0x1D90, 0x30740003,
		0x1D90, 0x30750002,
		0x1D90, 0x30760001,
		0x1D90, 0x30770000,
		0x1D90, 0x30780000,
		0x1D90, 0x30790000,
		0x1D90, 0x307A0000,
		0x1D90, 0x307B0000,
		0x1D90, 0x307C0000,
		0x1D90, 0x307D0000,
		0x1D90, 0x307E0000,
		0x1D90, 0x307F0000,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x304000FF,
		0x1D90, 0x304100FF,
		0x1D90, 0x304200FE,
		0x1D90, 0x304300FD,
		0x1D90, 0x304400FC,
		0x1D90, 0x304500FB,
		0x1D90, 0x304600FA,
		0x1D90, 0x304700F9,
		0x1D90, 0x304800F8,
		0x1D90, 0x304900F7,
		0x1D90, 0x304A00F6,
		0x1D90, 0x304B00F5,
		0x1D90, 0x304C00F4,
		0x1D90, 0x304D00F3,
		0x1D90, 0x304E00F2,
		0x1D90, 0x304F00F1,
		0x1D90, 0x305000F0,
		0x1D90, 0x305100EF,
		0x1D90, 0x305200EE,
		0x1D90, 0x305300ED,
		0x1D90, 0x305400EC,
		0x1D90, 0x305500EB,
		0x1D90, 0x305600EA,
		0x1D90, 0x305700E9,
		0x1D90, 0x305800E8,
		0x1D90, 0x305900E7,
		0x1D90, 0x305A00E6,
		0x1D90, 0x305B00E5,
		0x1D90, 0x305C00E4,
		0x1D90, 0x305D00E3,
		0x1D90, 0x305E00E2,
		0x1D90, 0x305F00E1,
		0x1D90, 0x306000E0,
		0x1D90, 0x306100A3,
		0x1D90, 0x306200A2,
		0x1D90, 0x306300A1,
		0x1D90, 0x306400A0,
		0x1D90, 0x30650082,
		0x1D90, 0x30660081,
		0x1D90, 0x30670080,
		0x1D90, 0x30680062,
		0x1D90, 0x30690061,
		0x1D90, 0x306A0060,
		0x1D90, 0x306B0043,
		0x1D90, 0x306C0042,
		0x1D90, 0x306D0041,
		0x1D90, 0x306E0040,
		0x1D90, 0x306F0024,
		0x1D90, 0x30700023,
		0x1D90, 0x30710022,
		0x1D90, 0x30720021,
		0x1D90, 0x30730004,
		0x1D90, 0x30740003,
		0x1D90, 0x30750002,
		0x1D90, 0x30760001,
		0x1D90, 0x30770000,
		0x1D90, 0x30780000,
		0x1D90, 0x30790000,
		0x1D90, 0x307A0000,
		0x1D90, 0x307B0000,
		0x1D90, 0x307C0000,
		0x1D90, 0x307D0000,
		0x1D90, 0x307E0000,
		0x1D90, 0x307F0000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x304000FF,
		0x1D90, 0x304100FF,
		0x1D90, 0x304200FE,
		0x1D90, 0x304300FD,
		0x1D90, 0x304400FC,
		0x1D90, 0x304500FB,
		0x1D90, 0x304600FA,
		0x1D90, 0x304700F9,
		0x1D90, 0x304800F8,
		0x1D90, 0x304900F7,
		0x1D90, 0x304A00F6,
		0x1D90, 0x304B00F5,
		0x1D90, 0x304C00F4,
		0x1D90, 0x304D00F3,
		0x1D90, 0x304E00F2,
		0x1D90, 0x304F00F1,
		0x1D90, 0x305000F0,
		0x1D90, 0x305100EF,
		0x1D90, 0x305200EE,
		0x1D90, 0x305300ED,
		0x1D90, 0x305400EC,
		0x1D90, 0x305500EB,
		0x1D90, 0x305600EA,
		0x1D90, 0x305700E9,
		0x1D90, 0x305800E8,
		0x1D90, 0x305900E7,
		0x1D90, 0x305A00E6,
		0x1D90, 0x305B00E5,
		0x1D90, 0x305C00E4,
		0x1D90, 0x305D00E3,
		0x1D90, 0x305E00E2,
		0x1D90, 0x305F00E1,
		0x1D90, 0x306000E0,
		0x1D90, 0x306100A3,
		0x1D90, 0x306200A2,
		0x1D90, 0x306300A1,
		0x1D90, 0x306400A0,
		0x1D90, 0x30650082,
		0x1D90, 0x30660081,
		0x1D90, 0x30670080,
		0x1D90, 0x30680062,
		0x1D90, 0x30690061,
		0x1D90, 0x306A0060,
		0x1D90, 0x306B0043,
		0x1D90, 0x306C0042,
		0x1D90, 0x306D0041,
		0x1D90, 0x306E0040,
		0x1D90, 0x306F0024,
		0x1D90, 0x30700023,
		0x1D90, 0x30710022,
		0x1D90, 0x30720021,
		0x1D90, 0x30730004,
		0x1D90, 0x30740003,
		0x1D90, 0x30750002,
		0x1D90, 0x30760001,
		0x1D90, 0x30770000,
		0x1D90, 0x30780000,
		0x1D90, 0x30790000,
		0x1D90, 0x307A0000,
		0x1D90, 0x307B0000,
		0x1D90, 0x307C0000,
		0x1D90, 0x307D0000,
		0x1D90, 0x307E0000,
		0x1D90, 0x307F0000,
	0xA0000000,	0x00000000,
		0x1D90, 0x304000FF,
		0x1D90, 0x304100FF,
		0x1D90, 0x304200FE,
		0x1D90, 0x304300FD,
		0x1D90, 0x304400FC,
		0x1D90, 0x304500FB,
		0x1D90, 0x304600FA,
		0x1D90, 0x304700F9,
		0x1D90, 0x304800F8,
		0x1D90, 0x304900F7,
		0x1D90, 0x304A00F6,
		0x1D90, 0x304B00F5,
		0x1D90, 0x304C00F4,
		0x1D90, 0x304D00F3,
		0x1D90, 0x304E00F2,
		0x1D90, 0x304F00F1,
		0x1D90, 0x305000F0,
		0x1D90, 0x305100EF,
		0x1D90, 0x305200EE,
		0x1D90, 0x305300ED,
		0x1D90, 0x305400EC,
		0x1D90, 0x305500EB,
		0x1D90, 0x305600EA,
		0x1D90, 0x305700E9,
		0x1D90, 0x305800E8,
		0x1D90, 0x305900E7,
		0x1D90, 0x305A00E6,
		0x1D90, 0x305B00E5,
		0x1D90, 0x305C00E4,
		0x1D90, 0x305D00E3,
		0x1D90, 0x305E00E2,
		0x1D90, 0x305F00E1,
		0x1D90, 0x306000E0,
		0x1D90, 0x306100A3,
		0x1D90, 0x306200A2,
		0x1D90, 0x306300A1,
		0x1D90, 0x306400A0,
		0x1D90, 0x30650082,
		0x1D90, 0x30660081,
		0x1D90, 0x30670080,
		0x1D90, 0x30680062,
		0x1D90, 0x30690061,
		0x1D90, 0x306A0060,
		0x1D90, 0x306B0043,
		0x1D90, 0x306C0042,
		0x1D90, 0x306D0041,
		0x1D90, 0x306E0040,
		0x1D90, 0x306F0024,
		0x1D90, 0x30700023,
		0x1D90, 0x30710022,
		0x1D90, 0x30720021,
		0x1D90, 0x30730004,
		0x1D90, 0x30740003,
		0x1D90, 0x30750002,
		0x1D90, 0x30760001,
		0x1D90, 0x30770000,
		0x1D90, 0x30780000,
		0x1D90, 0x30790000,
		0x1D90, 0x307A0000,
		0x1D90, 0x307B0000,
		0x1D90, 0x307C0000,
		0x1D90, 0x307D0000,
		0x1D90, 0x307E0000,
		0x1D90, 0x307F0000,
	0xB0000000,	0x00000000,
	0x81000000,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x308000FF,
		0x1D90, 0x308100FF,
		0x1D90, 0x308200FE,
		0x1D90, 0x308300FD,
		0x1D90, 0x308400FC,
		0x1D90, 0x308500FB,
		0x1D90, 0x308600FA,
		0x1D90, 0x308700F9,
		0x1D90, 0x308800F8,
		0x1D90, 0x308900F7,
		0x1D90, 0x308A00F6,
		0x1D90, 0x308B00F5,
		0x1D90, 0x308C00F4,
		0x1D90, 0x308D00F3,
		0x1D90, 0x308E00F2,
		0x1D90, 0x308F00F1,
		0x1D90, 0x309000F0,
		0x1D90, 0x309100EF,
		0x1D90, 0x309200EE,
		0x1D90, 0x309300ED,
		0x1D90, 0x309400EC,
		0x1D90, 0x309500EB,
		0x1D90, 0x309600EA,
		0x1D90, 0x309700E9,
		0x1D90, 0x309800E8,
		0x1D90, 0x309900E7,
		0x1D90, 0x309A00E6,
		0x1D90, 0x309B00E5,
		0x1D90, 0x309C00E4,
		0x1D90, 0x309D00E3,
		0x1D90, 0x309E00E2,
		0x1D90, 0x309F00E1,
		0x1D90, 0x30A000E0,
		0x1D90, 0x30A100A3,
		0x1D90, 0x30A200A2,
		0x1D90, 0x30A300A1,
		0x1D90, 0x30A400A0,
		0x1D90, 0x30A50082,
		0x1D90, 0x30A60081,
		0x1D90, 0x30A70080,
		0x1D90, 0x30A80062,
		0x1D90, 0x30A90061,
		0x1D90, 0x30AA0060,
		0x1D90, 0x30AB0043,
		0x1D90, 0x30AC0042,
		0x1D90, 0x30AD0041,
		0x1D90, 0x30AE0040,
		0x1D90, 0x30AF0024,
		0x1D90, 0x30B00023,
		0x1D90, 0x30B10022,
		0x1D90, 0x30B20021,
		0x1D90, 0x30B30004,
		0x1D90, 0x30B40003,
		0x1D90, 0x30B50002,
		0x1D90, 0x30B60001,
		0x1D90, 0x30B70000,
		0x1D90, 0x30B80000,
		0x1D90, 0x30B90000,
		0x1D90, 0x30BA0000,
		0x1D90, 0x30BB0000,
		0x1D90, 0x30BC0000,
		0x1D90, 0x30BD0000,
		0x1D90, 0x30BE0000,
		0x1D90, 0x30BF0000,
	0x91000001,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x308000FF,
		0x1D90, 0x308100FF,
		0x1D90, 0x308200FE,
		0x1D90, 0x308300FD,
		0x1D90, 0x308400FC,
		0x1D90, 0x308500FB,
		0x1D90, 0x308600FA,
		0x1D90, 0x308700F9,
		0x1D90, 0x308800F8,
		0x1D90, 0x308900F7,
		0x1D90, 0x308A00F6,
		0x1D90, 0x308B00F5,
		0x1D90, 0x308C00F4,
		0x1D90, 0x308D00F3,
		0x1D90, 0x308E00F2,
		0x1D90, 0x308F00F1,
		0x1D90, 0x309000F0,
		0x1D90, 0x309100EF,
		0x1D90, 0x309200EE,
		0x1D90, 0x309300ED,
		0x1D90, 0x309400EC,
		0x1D90, 0x309500EB,
		0x1D90, 0x309600EA,
		0x1D90, 0x309700E9,
		0x1D90, 0x309800E8,
		0x1D90, 0x309900E7,
		0x1D90, 0x309A00E6,
		0x1D90, 0x309B00E5,
		0x1D90, 0x309C00E4,
		0x1D90, 0x309D00E3,
		0x1D90, 0x309E00E2,
		0x1D90, 0x309F00E1,
		0x1D90, 0x30A000E0,
		0x1D90, 0x30A100A3,
		0x1D90, 0x30A200A2,
		0x1D90, 0x30A300A1,
		0x1D90, 0x30A400A0,
		0x1D90, 0x30A50082,
		0x1D90, 0x30A60081,
		0x1D90, 0x30A70080,
		0x1D90, 0x30A80062,
		0x1D90, 0x30A90061,
		0x1D90, 0x30AA0060,
		0x1D90, 0x30AB0043,
		0x1D90, 0x30AC0042,
		0x1D90, 0x30AD0041,
		0x1D90, 0x30AE0040,
		0x1D90, 0x30AF0024,
		0x1D90, 0x30B00023,
		0x1D90, 0x30B10022,
		0x1D90, 0x30B20021,
		0x1D90, 0x30B30004,
		0x1D90, 0x30B40003,
		0x1D90, 0x30B50002,
		0x1D90, 0x30B60001,
		0x1D90, 0x30B70000,
		0x1D90, 0x30B80000,
		0x1D90, 0x30B90000,
		0x1D90, 0x30BA0000,
		0x1D90, 0x30BB0000,
		0x1D90, 0x30BC0000,
		0x1D90, 0x30BD0000,
		0x1D90, 0x30BE0000,
		0x1D90, 0x30BF0000,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x308000FF,
		0x1D90, 0x308100FF,
		0x1D90, 0x308200FE,
		0x1D90, 0x308300FD,
		0x1D90, 0x308400FC,
		0x1D90, 0x308500FB,
		0x1D90, 0x308600FA,
		0x1D90, 0x308700F9,
		0x1D90, 0x308800F8,
		0x1D90, 0x308900F7,
		0x1D90, 0x308A00F6,
		0x1D90, 0x308B00F5,
		0x1D90, 0x308C00F4,
		0x1D90, 0x308D00F3,
		0x1D90, 0x308E00F2,
		0x1D90, 0x308F00F1,
		0x1D90, 0x309000F0,
		0x1D90, 0x309100EF,
		0x1D90, 0x309200EE,
		0x1D90, 0x309300ED,
		0x1D90, 0x309400EC,
		0x1D90, 0x309500EB,
		0x1D90, 0x309600EA,
		0x1D90, 0x309700E9,
		0x1D90, 0x309800E8,
		0x1D90, 0x309900E7,
		0x1D90, 0x309A00E6,
		0x1D90, 0x309B00E5,
		0x1D90, 0x309C00E4,
		0x1D90, 0x309D00E3,
		0x1D90, 0x309E00E2,
		0x1D90, 0x309F00E1,
		0x1D90, 0x30A000E0,
		0x1D90, 0x30A100A3,
		0x1D90, 0x30A200A2,
		0x1D90, 0x30A300A1,
		0x1D90, 0x30A400A0,
		0x1D90, 0x30A50082,
		0x1D90, 0x30A60081,
		0x1D90, 0x30A70080,
		0x1D90, 0x30A80062,
		0x1D90, 0x30A90061,
		0x1D90, 0x30AA0060,
		0x1D90, 0x30AB0043,
		0x1D90, 0x30AC0042,
		0x1D90, 0x30AD0041,
		0x1D90, 0x30AE0040,
		0x1D90, 0x30AF0024,
		0x1D90, 0x30B00023,
		0x1D90, 0x30B10022,
		0x1D90, 0x30B20021,
		0x1D90, 0x30B30004,
		0x1D90, 0x30B40003,
		0x1D90, 0x30B50002,
		0x1D90, 0x30B60001,
		0x1D90, 0x30B70000,
		0x1D90, 0x30B80000,
		0x1D90, 0x30B90000,
		0x1D90, 0x30BA0000,
		0x1D90, 0x30BB0000,
		0x1D90, 0x30BC0000,
		0x1D90, 0x30BD0000,
		0x1D90, 0x30BE0000,
		0x1D90, 0x30BF0000,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x308000FF,
		0x1D90, 0x308100FF,
		0x1D90, 0x308200FE,
		0x1D90, 0x308300FD,
		0x1D90, 0x308400FC,
		0x1D90, 0x308500FB,
		0x1D90, 0x308600FA,
		0x1D90, 0x308700F9,
		0x1D90, 0x308800F8,
		0x1D90, 0x308900F7,
		0x1D90, 0x308A00F6,
		0x1D90, 0x308B00F5,
		0x1D90, 0x308C00F4,
		0x1D90, 0x308D00F3,
		0x1D90, 0x308E00F2,
		0x1D90, 0x308F00F1,
		0x1D90, 0x309000F0,
		0x1D90, 0x309100EF,
		0x1D90, 0x309200EE,
		0x1D90, 0x309300ED,
		0x1D90, 0x309400EC,
		0x1D90, 0x309500EB,
		0x1D90, 0x309600EA,
		0x1D90, 0x309700E9,
		0x1D90, 0x309800E8,
		0x1D90, 0x309900E7,
		0x1D90, 0x309A00E6,
		0x1D90, 0x309B00E5,
		0x1D90, 0x309C00E4,
		0x1D90, 0x309D00E3,
		0x1D90, 0x309E00E2,
		0x1D90, 0x309F00E1,
		0x1D90, 0x30A000E0,
		0x1D90, 0x30A100A3,
		0x1D90, 0x30A200A2,
		0x1D90, 0x30A300A1,
		0x1D90, 0x30A400A0,
		0x1D90, 0x30A50082,
		0x1D90, 0x30A60081,
		0x1D90, 0x30A70080,
		0x1D90, 0x30A80062,
		0x1D90, 0x30A90061,
		0x1D90, 0x30AA0060,
		0x1D90, 0x30AB0043,
		0x1D90, 0x30AC0042,
		0x1D90, 0x30AD0041,
		0x1D90, 0x30AE0040,
		0x1D90, 0x30AF0024,
		0x1D90, 0x30B00023,
		0x1D90, 0x30B10022,
		0x1D90, 0x30B20021,
		0x1D90, 0x30B30004,
		0x1D90, 0x30B40003,
		0x1D90, 0x30B50002,
		0x1D90, 0x30B60001,
		0x1D90, 0x30B70000,
		0x1D90, 0x30B80000,
		0x1D90, 0x30B90000,
		0x1D90, 0x30BA0000,
		0x1D90, 0x30BB0000,
		0x1D90, 0x30BC0000,
		0x1D90, 0x30BD0000,
		0x1D90, 0x30BE0000,
		0x1D90, 0x30BF0000,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x308000FF,
		0x1D90, 0x308100FF,
		0x1D90, 0x308200FE,
		0x1D90, 0x308300FD,
		0x1D90, 0x308400FC,
		0x1D90, 0x308500FB,
		0x1D90, 0x308600FA,
		0x1D90, 0x308700F9,
		0x1D90, 0x308800F8,
		0x1D90, 0x308900F7,
		0x1D90, 0x308A00F6,
		0x1D90, 0x308B00F5,
		0x1D90, 0x308C00F4,
		0x1D90, 0x308D00F3,
		0x1D90, 0x308E00F2,
		0x1D90, 0x308F00F1,
		0x1D90, 0x309000F0,
		0x1D90, 0x309100EF,
		0x1D90, 0x309200EE,
		0x1D90, 0x309300ED,
		0x1D90, 0x309400EC,
		0x1D90, 0x309500EB,
		0x1D90, 0x309600EA,
		0x1D90, 0x309700E9,
		0x1D90, 0x309800E8,
		0x1D90, 0x309900E7,
		0x1D90, 0x309A00E6,
		0x1D90, 0x309B00E5,
		0x1D90, 0x309C00E4,
		0x1D90, 0x309D00E3,
		0x1D90, 0x309E00E2,
		0x1D90, 0x309F00E1,
		0x1D90, 0x30A000E0,
		0x1D90, 0x30A100A3,
		0x1D90, 0x30A200A2,
		0x1D90, 0x30A300A1,
		0x1D90, 0x30A400A0,
		0x1D90, 0x30A50082,
		0x1D90, 0x30A60081,
		0x1D90, 0x30A70080,
		0x1D90, 0x30A80062,
		0x1D90, 0x30A90061,
		0x1D90, 0x30AA0060,
		0x1D90, 0x30AB0043,
		0x1D90, 0x30AC0042,
		0x1D90, 0x30AD0041,
		0x1D90, 0x30AE0040,
		0x1D90, 0x30AF0024,
		0x1D90, 0x30B00023,
		0x1D90, 0x30B10022,
		0x1D90, 0x30B20021,
		0x1D90, 0x30B30004,
		0x1D90, 0x30B40003,
		0x1D90, 0x30B50002,
		0x1D90, 0x30B60001,
		0x1D90, 0x30B70000,
		0x1D90, 0x30B80000,
		0x1D90, 0x30B90000,
		0x1D90, 0x30BA0000,
		0x1D90, 0x30BB0000,
		0x1D90, 0x30BC0000,
		0x1D90, 0x30BD0000,
		0x1D90, 0x30BE0000,
		0x1D90, 0x30BF0000,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x308000FF,
		0x1D90, 0x308100FF,
		0x1D90, 0x308200FE,
		0x1D90, 0x308300FD,
		0x1D90, 0x308400FC,
		0x1D90, 0x308500FB,
		0x1D90, 0x308600FA,
		0x1D90, 0x308700F9,
		0x1D90, 0x308800F8,
		0x1D90, 0x308900F7,
		0x1D90, 0x308A00F6,
		0x1D90, 0x308B00F5,
		0x1D90, 0x308C00F4,
		0x1D90, 0x308D00F3,
		0x1D90, 0x308E00F2,
		0x1D90, 0x308F00F1,
		0x1D90, 0x309000F0,
		0x1D90, 0x309100EF,
		0x1D90, 0x309200EE,
		0x1D90, 0x309300ED,
		0x1D90, 0x309400EC,
		0x1D90, 0x309500EB,
		0x1D90, 0x309600EA,
		0x1D90, 0x309700E9,
		0x1D90, 0x309800E8,
		0x1D90, 0x309900E7,
		0x1D90, 0x309A00E6,
		0x1D90, 0x309B00E5,
		0x1D90, 0x309C00E4,
		0x1D90, 0x309D00E3,
		0x1D90, 0x309E00E2,
		0x1D90, 0x309F00E1,
		0x1D90, 0x30A000E0,
		0x1D90, 0x30A100A3,
		0x1D90, 0x30A200A2,
		0x1D90, 0x30A300A1,
		0x1D90, 0x30A400A0,
		0x1D90, 0x30A50082,
		0x1D90, 0x30A60081,
		0x1D90, 0x30A70080,
		0x1D90, 0x30A80062,
		0x1D90, 0x30A90061,
		0x1D90, 0x30AA0060,
		0x1D90, 0x30AB0043,
		0x1D90, 0x30AC0042,
		0x1D90, 0x30AD0041,
		0x1D90, 0x30AE0040,
		0x1D90, 0x30AF0024,
		0x1D90, 0x30B00023,
		0x1D90, 0x30B10022,
		0x1D90, 0x30B20021,
		0x1D90, 0x30B30004,
		0x1D90, 0x30B40003,
		0x1D90, 0x30B50002,
		0x1D90, 0x30B60001,
		0x1D90, 0x30B70000,
		0x1D90, 0x30B80000,
		0x1D90, 0x30B90000,
		0x1D90, 0x30BA0000,
		0x1D90, 0x30BB0000,
		0x1D90, 0x30BC0000,
		0x1D90, 0x30BD0000,
		0x1D90, 0x30BE0000,
		0x1D90, 0x30BF0000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x308000FF,
		0x1D90, 0x308100FF,
		0x1D90, 0x308200FE,
		0x1D90, 0x308300FD,
		0x1D90, 0x308400FC,
		0x1D90, 0x308500FB,
		0x1D90, 0x308600FA,
		0x1D90, 0x308700F9,
		0x1D90, 0x308800F8,
		0x1D90, 0x308900F7,
		0x1D90, 0x308A00F6,
		0x1D90, 0x308B00F5,
		0x1D90, 0x308C00F4,
		0x1D90, 0x308D00F3,
		0x1D90, 0x308E00F2,
		0x1D90, 0x308F00F1,
		0x1D90, 0x309000F0,
		0x1D90, 0x309100EF,
		0x1D90, 0x309200EE,
		0x1D90, 0x309300ED,
		0x1D90, 0x309400EC,
		0x1D90, 0x309500EB,
		0x1D90, 0x309600EA,
		0x1D90, 0x309700E9,
		0x1D90, 0x309800E8,
		0x1D90, 0x309900E7,
		0x1D90, 0x309A00E6,
		0x1D90, 0x309B00E5,
		0x1D90, 0x309C00E4,
		0x1D90, 0x309D00E3,
		0x1D90, 0x309E00E2,
		0x1D90, 0x309F00E1,
		0x1D90, 0x30A000E0,
		0x1D90, 0x30A100A3,
		0x1D90, 0x30A200A2,
		0x1D90, 0x30A300A1,
		0x1D90, 0x30A400A0,
		0x1D90, 0x30A50082,
		0x1D90, 0x30A60081,
		0x1D90, 0x30A70080,
		0x1D90, 0x30A80062,
		0x1D90, 0x30A90061,
		0x1D90, 0x30AA0060,
		0x1D90, 0x30AB0043,
		0x1D90, 0x30AC0042,
		0x1D90, 0x30AD0041,
		0x1D90, 0x30AE0040,
		0x1D90, 0x30AF0024,
		0x1D90, 0x30B00023,
		0x1D90, 0x30B10022,
		0x1D90, 0x30B20021,
		0x1D90, 0x30B30004,
		0x1D90, 0x30B40003,
		0x1D90, 0x30B50002,
		0x1D90, 0x30B60001,
		0x1D90, 0x30B70000,
		0x1D90, 0x30B80000,
		0x1D90, 0x30B90000,
		0x1D90, 0x30BA0000,
		0x1D90, 0x30BB0000,
		0x1D90, 0x30BC0000,
		0x1D90, 0x30BD0000,
		0x1D90, 0x30BE0000,
		0x1D90, 0x30BF0000,
	0xA0000000,	0x00000000,
		0x1D90, 0x308000FF,
		0x1D90, 0x308100FF,
		0x1D90, 0x308200FE,
		0x1D90, 0x308300FD,
		0x1D90, 0x308400FC,
		0x1D90, 0x308500FB,
		0x1D90, 0x308600FA,
		0x1D90, 0x308700F9,
		0x1D90, 0x308800F8,
		0x1D90, 0x308900F7,
		0x1D90, 0x308A00F6,
		0x1D90, 0x308B00F5,
		0x1D90, 0x308C00F4,
		0x1D90, 0x308D00F3,
		0x1D90, 0x308E00F2,
		0x1D90, 0x308F00F1,
		0x1D90, 0x309000F0,
		0x1D90, 0x309100EF,
		0x1D90, 0x309200EE,
		0x1D90, 0x309300ED,
		0x1D90, 0x309400EC,
		0x1D90, 0x309500EB,
		0x1D90, 0x309600EA,
		0x1D90, 0x309700E9,
		0x1D90, 0x309800E8,
		0x1D90, 0x309900E7,
		0x1D90, 0x309A00E6,
		0x1D90, 0x309B00E5,
		0x1D90, 0x309C00E4,
		0x1D90, 0x309D00E3,
		0x1D90, 0x309E00E2,
		0x1D90, 0x309F00E1,
		0x1D90, 0x30A000E0,
		0x1D90, 0x30A100A3,
		0x1D90, 0x30A200A2,
		0x1D90, 0x30A300A1,
		0x1D90, 0x30A400A0,
		0x1D90, 0x30A50082,
		0x1D90, 0x30A60081,
		0x1D90, 0x30A70080,
		0x1D90, 0x30A80062,
		0x1D90, 0x30A90061,
		0x1D90, 0x30AA0060,
		0x1D90, 0x30AB0043,
		0x1D90, 0x30AC0042,
		0x1D90, 0x30AD0041,
		0x1D90, 0x30AE0040,
		0x1D90, 0x30AF0024,
		0x1D90, 0x30B00023,
		0x1D90, 0x30B10022,
		0x1D90, 0x30B20021,
		0x1D90, 0x30B30004,
		0x1D90, 0x30B40003,
		0x1D90, 0x30B50002,
		0x1D90, 0x30B60001,
		0x1D90, 0x30B70000,
		0x1D90, 0x30B80000,
		0x1D90, 0x30B90000,
		0x1D90, 0x30BA0000,
		0x1D90, 0x30BB0000,
		0x1D90, 0x30BC0000,
		0x1D90, 0x30BD0000,
		0x1D90, 0x30BE0000,
		0x1D90, 0x30BF0000,
	0xB0000000,	0x00000000,
	0x81000000,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x30C000FF,
		0x1D90, 0x30C100FF,
		0x1D90, 0x30C200FF,
		0x1D90, 0x30C300FF,
		0x1D90, 0x30C400FE,
		0x1D90, 0x30C500FD,
		0x1D90, 0x30C600FC,
		0x1D90, 0x30C700FB,
		0x1D90, 0x30C800FA,
		0x1D90, 0x30C900F9,
		0x1D90, 0x30CA00F8,
		0x1D90, 0x30CB00F7,
		0x1D90, 0x30CC00F6,
		0x1D90, 0x30CD00F5,
		0x1D90, 0x30CE00F4,
		0x1D90, 0x30CF00F3,
		0x1D90, 0x30D000F2,
		0x1D90, 0x30D100F1,
		0x1D90, 0x30D200F0,
		0x1D90, 0x30D300EF,
		0x1D90, 0x30D400EE,
		0x1D90, 0x30D500ED,
		0x1D90, 0x30D600EC,
		0x1D90, 0x30D700EB,
		0x1D90, 0x30D800EA,
		0x1D90, 0x30D900E9,
		0x1D90, 0x30DA00E8,
		0x1D90, 0x30DB00E7,
		0x1D90, 0x30DC00E6,
		0x1D90, 0x30DD00E5,
		0x1D90, 0x30DE00E4,
		0x1D90, 0x30DF00E3,
		0x1D90, 0x30E000E2,
		0x1D90, 0x30E100E1,
		0x1D90, 0x30E200E0,
		0x1D90, 0x30E300A3,
		0x1D90, 0x30E400A2,
		0x1D90, 0x30E500A1,
		0x1D90, 0x30E600A0,
		0x1D90, 0x30E70082,
		0x1D90, 0x30E80081,
		0x1D90, 0x30E90080,
		0x1D90, 0x30EA0062,
		0x1D90, 0x30EB0061,
		0x1D90, 0x30EC0060,
		0x1D90, 0x30ED0043,
		0x1D90, 0x30EE0042,
		0x1D90, 0x30EF0041,
		0x1D90, 0x30F00040,
		0x1D90, 0x30F10024,
		0x1D90, 0x30F20023,
		0x1D90, 0x30F30022,
		0x1D90, 0x30F40021,
		0x1D90, 0x30F50004,
		0x1D90, 0x30F60003,
		0x1D90, 0x30F70002,
		0x1D90, 0x30F80001,
		0x1D90, 0x30F90000,
		0x1D90, 0x30FA0000,
		0x1D90, 0x30FB0000,
		0x1D90, 0x30FC0000,
		0x1D90, 0x30FD0000,
		0x1D90, 0x30FE0000,
		0x1D90, 0x30FF0000,
	0x91000001,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x30C000FB,
		0x1D90, 0x30C100FA,
		0x1D90, 0x30C200F9,
		0x1D90, 0x30C300F8,
		0x1D90, 0x30C400F7,
		0x1D90, 0x30C500F6,
		0x1D90, 0x30C600F5,
		0x1D90, 0x30C700F4,
		0x1D90, 0x30C800F3,
		0x1D90, 0x30C900F2,
		0x1D90, 0x30CA00F1,
		0x1D90, 0x30CB00F0,
		0x1D90, 0x30CC00EF,
		0x1D90, 0x30CD00EE,
		0x1D90, 0x30CE00ED,
		0x1D90, 0x30CF00EC,
		0x1D90, 0x30D000B0,
		0x1D90, 0x30D100EA,
		0x1D90, 0x30D200E9,
		0x1D90, 0x30D300E8,
		0x1D90, 0x30D400E7,
		0x1D90, 0x30D500E6,
		0x1D90, 0x30D600E5,
		0x1D90, 0x30D700E4,
		0x1D90, 0x30D800E3,
		0x1D90, 0x30D900E2,
		0x1D90, 0x30DA00E1,
		0x1D90, 0x30DB00E0,
		0x1D90, 0x30DC00A3,
		0x1D90, 0x30DD00A2,
		0x1D90, 0x30DE00A1,
		0x1D90, 0x30DF00A0,
		0x1D90, 0x30E00082,
		0x1D90, 0x30E10081,
		0x1D90, 0x30E20080,
		0x1D90, 0x30E30062,
		0x1D90, 0x30E40061,
		0x1D90, 0x30E50060,
		0x1D90, 0x30E60043,
		0x1D90, 0x30E70042,
		0x1D90, 0x30E80041,
		0x1D90, 0x30E90040,
		0x1D90, 0x30EA0024,
		0x1D90, 0x30EB0023,
		0x1D90, 0x30EC0022,
		0x1D90, 0x30ED0021,
		0x1D90, 0x30EE0004,
		0x1D90, 0x30EF0003,
		0x1D90, 0x30F00002,
		0x1D90, 0x30F10001,
		0x1D90, 0x30F20000,
		0x1D90, 0x30F30000,
		0x1D90, 0x30F40000,
		0x1D90, 0x30F50000,
		0x1D90, 0x30F60000,
		0x1D90, 0x30F70000,
		0x1D90, 0x30F80000,
		0x1D90, 0x30F90000,
		0x1D90, 0x30FA0000,
		0x1D90, 0x30FB0000,
		0x1D90, 0x30FC0000,
		0x1D90, 0x30FD0000,
		0x1D90, 0x30FE0000,
		0x1D90, 0x30FF0000,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x30C000FF,
		0x1D90, 0x30C100FF,
		0x1D90, 0x30C200FF,
		0x1D90, 0x30C300FF,
		0x1D90, 0x30C400FE,
		0x1D90, 0x30C500FD,
		0x1D90, 0x30C600FC,
		0x1D90, 0x30C700FB,
		0x1D90, 0x30C800FA,
		0x1D90, 0x30C900F9,
		0x1D90, 0x30CA00F8,
		0x1D90, 0x30CB00F7,
		0x1D90, 0x30CC00F6,
		0x1D90, 0x30CD00F5,
		0x1D90, 0x30CE00F4,
		0x1D90, 0x30CF00F3,
		0x1D90, 0x30D000F2,
		0x1D90, 0x30D100F1,
		0x1D90, 0x30D200F0,
		0x1D90, 0x30D300EF,
		0x1D90, 0x30D400EE,
		0x1D90, 0x30D500ED,
		0x1D90, 0x30D600EC,
		0x1D90, 0x30D700EB,
		0x1D90, 0x30D800EA,
		0x1D90, 0x30D900E9,
		0x1D90, 0x30DA00E8,
		0x1D90, 0x30DB00E7,
		0x1D90, 0x30DC00E6,
		0x1D90, 0x30DD00E5,
		0x1D90, 0x30DE00E4,
		0x1D90, 0x30DF00E3,
		0x1D90, 0x30E000E2,
		0x1D90, 0x30E100E1,
		0x1D90, 0x30E200E0,
		0x1D90, 0x30E300A3,
		0x1D90, 0x30E400A2,
		0x1D90, 0x30E500A1,
		0x1D90, 0x30E600A0,
		0x1D90, 0x30E70082,
		0x1D90, 0x30E80081,
		0x1D90, 0x30E90080,
		0x1D90, 0x30EA0062,
		0x1D90, 0x30EB0061,
		0x1D90, 0x30EC0060,
		0x1D90, 0x30ED0043,
		0x1D90, 0x30EE0042,
		0x1D90, 0x30EF0041,
		0x1D90, 0x30F00040,
		0x1D90, 0x30F10024,
		0x1D90, 0x30F20023,
		0x1D90, 0x30F30022,
		0x1D90, 0x30F40021,
		0x1D90, 0x30F50004,
		0x1D90, 0x30F60003,
		0x1D90, 0x30F70002,
		0x1D90, 0x30F80001,
		0x1D90, 0x30F90000,
		0x1D90, 0x30FA0000,
		0x1D90, 0x30FB0000,
		0x1D90, 0x30FC0000,
		0x1D90, 0x30FD0000,
		0x1D90, 0x30FE0000,
		0x1D90, 0x30FF0000,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x30C000FF,
		0x1D90, 0x30C100FF,
		0x1D90, 0x30C200FF,
		0x1D90, 0x30C300FF,
		0x1D90, 0x30C400FE,
		0x1D90, 0x30C500FD,
		0x1D90, 0x30C600FC,
		0x1D90, 0x30C700FB,
		0x1D90, 0x30C800FA,
		0x1D90, 0x30C900F9,
		0x1D90, 0x30CA00F8,
		0x1D90, 0x30CB00F7,
		0x1D90, 0x30CC00F6,
		0x1D90, 0x30CD00F5,
		0x1D90, 0x30CE00F4,
		0x1D90, 0x30CF00F3,
		0x1D90, 0x30D000F2,
		0x1D90, 0x30D100F1,
		0x1D90, 0x30D200F0,
		0x1D90, 0x30D300EF,
		0x1D90, 0x30D400EE,
		0x1D90, 0x30D500ED,
		0x1D90, 0x30D600EC,
		0x1D90, 0x30D700EB,
		0x1D90, 0x30D800EA,
		0x1D90, 0x30D900E9,
		0x1D90, 0x30DA00E8,
		0x1D90, 0x30DB00E7,
		0x1D90, 0x30DC00E6,
		0x1D90, 0x30DD00E5,
		0x1D90, 0x30DE00E4,
		0x1D90, 0x30DF00E3,
		0x1D90, 0x30E000E2,
		0x1D90, 0x30E100E1,
		0x1D90, 0x30E200E0,
		0x1D90, 0x30E300A3,
		0x1D90, 0x30E400A2,
		0x1D90, 0x30E500A1,
		0x1D90, 0x30E600A0,
		0x1D90, 0x30E70082,
		0x1D90, 0x30E80081,
		0x1D90, 0x30E90080,
		0x1D90, 0x30EA0062,
		0x1D90, 0x30EB0061,
		0x1D90, 0x30EC0060,
		0x1D90, 0x30ED0043,
		0x1D90, 0x30EE0042,
		0x1D90, 0x30EF0041,
		0x1D90, 0x30F00040,
		0x1D90, 0x30F10024,
		0x1D90, 0x30F20023,
		0x1D90, 0x30F30022,
		0x1D90, 0x30F40021,
		0x1D90, 0x30F50004,
		0x1D90, 0x30F60003,
		0x1D90, 0x30F70002,
		0x1D90, 0x30F80001,
		0x1D90, 0x30F90000,
		0x1D90, 0x30FA0000,
		0x1D90, 0x30FB0000,
		0x1D90, 0x30FC0000,
		0x1D90, 0x30FD0000,
		0x1D90, 0x30FE0000,
		0x1D90, 0x30FF0000,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x30C000FB,
		0x1D90, 0x30C100FA,
		0x1D90, 0x30C200F9,
		0x1D90, 0x30C300F8,
		0x1D90, 0x30C400F7,
		0x1D90, 0x30C500F6,
		0x1D90, 0x30C600F5,
		0x1D90, 0x30C700F4,
		0x1D90, 0x30C800F3,
		0x1D90, 0x30C900F2,
		0x1D90, 0x30CA00F1,
		0x1D90, 0x30CB00F0,
		0x1D90, 0x30CC00EF,
		0x1D90, 0x30CD00EE,
		0x1D90, 0x30CE00ED,
		0x1D90, 0x30CF00EC,
		0x1D90, 0x30D000B0,
		0x1D90, 0x30D100EA,
		0x1D90, 0x30D200E9,
		0x1D90, 0x30D300E8,
		0x1D90, 0x30D400E7,
		0x1D90, 0x30D500E6,
		0x1D90, 0x30D600E5,
		0x1D90, 0x30D700E4,
		0x1D90, 0x30D800E3,
		0x1D90, 0x30D900E2,
		0x1D90, 0x30DA00E1,
		0x1D90, 0x30DB00E0,
		0x1D90, 0x30DC00A3,
		0x1D90, 0x30DD00A2,
		0x1D90, 0x30DE00A1,
		0x1D90, 0x30DF00A0,
		0x1D90, 0x30E00082,
		0x1D90, 0x30E10081,
		0x1D90, 0x30E20080,
		0x1D90, 0x30E30062,
		0x1D90, 0x30E40061,
		0x1D90, 0x30E50060,
		0x1D90, 0x30E60043,
		0x1D90, 0x30E70042,
		0x1D90, 0x30E80041,
		0x1D90, 0x30E90040,
		0x1D90, 0x30EA0024,
		0x1D90, 0x30EB0023,
		0x1D90, 0x30EC0022,
		0x1D90, 0x30ED0021,
		0x1D90, 0x30EE0004,
		0x1D90, 0x30EF0003,
		0x1D90, 0x30F00002,
		0x1D90, 0x30F10001,
		0x1D90, 0x30F20000,
		0x1D90, 0x30F30000,
		0x1D90, 0x30F40000,
		0x1D90, 0x30F50000,
		0x1D90, 0x30F60000,
		0x1D90, 0x30F70000,
		0x1D90, 0x30F80000,
		0x1D90, 0x30F90000,
		0x1D90, 0x30FA0000,
		0x1D90, 0x30FB0000,
		0x1D90, 0x30FC0000,
		0x1D90, 0x30FD0000,
		0x1D90, 0x30FE0000,
		0x1D90, 0x30FF0000,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x30C000FB,
		0x1D90, 0x30C100FA,
		0x1D90, 0x30C200F9,
		0x1D90, 0x30C300F8,
		0x1D90, 0x30C400F7,
		0x1D90, 0x30C500F6,
		0x1D90, 0x30C600F5,
		0x1D90, 0x30C700F4,
		0x1D90, 0x30C800F3,
		0x1D90, 0x30C900F2,
		0x1D90, 0x30CA00F1,
		0x1D90, 0x30CB00F0,
		0x1D90, 0x30CC00EF,
		0x1D90, 0x30CD00EE,
		0x1D90, 0x30CE00ED,
		0x1D90, 0x30CF00EC,
		0x1D90, 0x30D000B0,
		0x1D90, 0x30D100EA,
		0x1D90, 0x30D200E9,
		0x1D90, 0x30D300E8,
		0x1D90, 0x30D400E7,
		0x1D90, 0x30D500E6,
		0x1D90, 0x30D600E5,
		0x1D90, 0x30D700E4,
		0x1D90, 0x30D800E3,
		0x1D90, 0x30D900E2,
		0x1D90, 0x30DA00E1,
		0x1D90, 0x30DB00E0,
		0x1D90, 0x30DC00A3,
		0x1D90, 0x30DD00A2,
		0x1D90, 0x30DE00A1,
		0x1D90, 0x30DF00A0,
		0x1D90, 0x30E00082,
		0x1D90, 0x30E10081,
		0x1D90, 0x30E20080,
		0x1D90, 0x30E30062,
		0x1D90, 0x30E40061,
		0x1D90, 0x30E50060,
		0x1D90, 0x30E60043,
		0x1D90, 0x30E70042,
		0x1D90, 0x30E80041,
		0x1D90, 0x30E90040,
		0x1D90, 0x30EA0024,
		0x1D90, 0x30EB0023,
		0x1D90, 0x30EC0022,
		0x1D90, 0x30ED0021,
		0x1D90, 0x30EE0004,
		0x1D90, 0x30EF0003,
		0x1D90, 0x30F00002,
		0x1D90, 0x30F10001,
		0x1D90, 0x30F20000,
		0x1D90, 0x30F30000,
		0x1D90, 0x30F40000,
		0x1D90, 0x30F50000,
		0x1D90, 0x30F60000,
		0x1D90, 0x30F70000,
		0x1D90, 0x30F80000,
		0x1D90, 0x30F90000,
		0x1D90, 0x30FA0000,
		0x1D90, 0x30FB0000,
		0x1D90, 0x30FC0000,
		0x1D90, 0x30FD0000,
		0x1D90, 0x30FE0000,
		0x1D90, 0x30FF0000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x30C000FB,
		0x1D90, 0x30C100FA,
		0x1D90, 0x30C200F9,
		0x1D90, 0x30C300F8,
		0x1D90, 0x30C400F7,
		0x1D90, 0x30C500F6,
		0x1D90, 0x30C600F5,
		0x1D90, 0x30C700F4,
		0x1D90, 0x30C800F3,
		0x1D90, 0x30C900F2,
		0x1D90, 0x30CA00F1,
		0x1D90, 0x30CB00F0,
		0x1D90, 0x30CC00EF,
		0x1D90, 0x30CD00EE,
		0x1D90, 0x30CE00ED,
		0x1D90, 0x30CF00EC,
		0x1D90, 0x30D000B0,
		0x1D90, 0x30D100EA,
		0x1D90, 0x30D200E9,
		0x1D90, 0x30D300E8,
		0x1D90, 0x30D400E7,
		0x1D90, 0x30D500E6,
		0x1D90, 0x30D600E5,
		0x1D90, 0x30D700E4,
		0x1D90, 0x30D800E3,
		0x1D90, 0x30D900E2,
		0x1D90, 0x30DA00E1,
		0x1D90, 0x30DB00E0,
		0x1D90, 0x30DC00A3,
		0x1D90, 0x30DD00A2,
		0x1D90, 0x30DE00A1,
		0x1D90, 0x30DF00A0,
		0x1D90, 0x30E00082,
		0x1D90, 0x30E10081,
		0x1D90, 0x30E20080,
		0x1D90, 0x30E30062,
		0x1D90, 0x30E40061,
		0x1D90, 0x30E50060,
		0x1D90, 0x30E60043,
		0x1D90, 0x30E70042,
		0x1D90, 0x30E80041,
		0x1D90, 0x30E90040,
		0x1D90, 0x30EA0024,
		0x1D90, 0x30EB0023,
		0x1D90, 0x30EC0022,
		0x1D90, 0x30ED0021,
		0x1D90, 0x30EE0004,
		0x1D90, 0x30EF0003,
		0x1D90, 0x30F00002,
		0x1D90, 0x30F10001,
		0x1D90, 0x30F20000,
		0x1D90, 0x30F30000,
		0x1D90, 0x30F40000,
		0x1D90, 0x30F50000,
		0x1D90, 0x30F60000,
		0x1D90, 0x30F70000,
		0x1D90, 0x30F80000,
		0x1D90, 0x30F90000,
		0x1D90, 0x30FA0000,
		0x1D90, 0x30FB0000,
		0x1D90, 0x30FC0000,
		0x1D90, 0x30FD0000,
		0x1D90, 0x30FE0000,
		0x1D90, 0x30FF0000,
	0xA0000000,	0x00000000,
		0x1D90, 0x30C000FF,
		0x1D90, 0x30C100FF,
		0x1D90, 0x30C200FF,
		0x1D90, 0x30C300FF,
		0x1D90, 0x30C400FE,
		0x1D90, 0x30C500FD,
		0x1D90, 0x30C600FC,
		0x1D90, 0x30C700FB,
		0x1D90, 0x30C800FA,
		0x1D90, 0x30C900F9,
		0x1D90, 0x30CA00F8,
		0x1D90, 0x30CB00F7,
		0x1D90, 0x30CC00F6,
		0x1D90, 0x30CD00F5,
		0x1D90, 0x30CE00F4,
		0x1D90, 0x30CF00F3,
		0x1D90, 0x30D000F2,
		0x1D90, 0x30D100F1,
		0x1D90, 0x30D200F0,
		0x1D90, 0x30D300EF,
		0x1D90, 0x30D400EE,
		0x1D90, 0x30D500ED,
		0x1D90, 0x30D600EC,
		0x1D90, 0x30D700EB,
		0x1D90, 0x30D800EA,
		0x1D90, 0x30D900E9,
		0x1D90, 0x30DA00E8,
		0x1D90, 0x30DB00E7,
		0x1D90, 0x30DC00E6,
		0x1D90, 0x30DD00E5,
		0x1D90, 0x30DE00E4,
		0x1D90, 0x30DF00E3,
		0x1D90, 0x30E000E2,
		0x1D90, 0x30E100E1,
		0x1D90, 0x30E200E0,
		0x1D90, 0x30E300A3,
		0x1D90, 0x30E400A2,
		0x1D90, 0x30E500A1,
		0x1D90, 0x30E600A0,
		0x1D90, 0x30E70082,
		0x1D90, 0x30E80081,
		0x1D90, 0x30E90080,
		0x1D90, 0x30EA0062,
		0x1D90, 0x30EB0061,
		0x1D90, 0x30EC0060,
		0x1D90, 0x30ED0043,
		0x1D90, 0x30EE0042,
		0x1D90, 0x30EF0041,
		0x1D90, 0x30F00040,
		0x1D90, 0x30F10024,
		0x1D90, 0x30F20023,
		0x1D90, 0x30F30022,
		0x1D90, 0x30F40021,
		0x1D90, 0x30F50004,
		0x1D90, 0x30F60003,
		0x1D90, 0x30F70002,
		0x1D90, 0x30F80001,
		0x1D90, 0x30F90000,
		0x1D90, 0x30FA0000,
		0x1D90, 0x30FB0000,
		0x1D90, 0x30FC0000,
		0x1D90, 0x30FD0000,
		0x1D90, 0x30FE0000,
		0x1D90, 0x30FF0000,
	0xB0000000,	0x00000000,
	0x81000000,	0x00000000,	0x40000000,	0x00000000,
		0x1D70, 0x22222222,
		0x1D70, 0x20202020,
	0x91000001,	0x00000000,	0x40000000,	0x00000000,
		0x1D70, 0x22222222,
		0x1D70, 0x20202020,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x1D70, 0x22222222,
		0x1D70, 0x20202020,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x1D70, 0x22222222,
		0x1D70, 0x20202020,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x1D70, 0x22222222,
		0x1D70, 0x20202020,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x1D70, 0x22222222,
		0x1D70, 0x20202020,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x1D70, 0x22222222,
		0x1D70, 0x20202020,
	0xA0000000,	0x00000000,
		0x1D70, 0x22222222,
		0x1D70, 0x20202020,
	0xB0000000,	0x00000000,

};

void
odm_read_and_config_mp_8197g_agc_tab(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len =
			sizeof(array_mp_8197g_agc_tab) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8197g_agc_tab;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_bb_agc_8197g(dm, v1, MASKDWORD, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8197g_agc_tab(void)
{
		return 18;
}

/******************************************************************************
 *                           phy_reg.TXT
 ******************************************************************************/

const u32 array_mp_8197g_phy_reg[] = {
		0x1D0C, 0x00410000,
		0x1C3C, 0x01038040,
		0x1C90, 0x00E49708,
		0x800, 0x00000000,
		0x804, 0xD6300000,
		0x808, 0x60156024,
		0x80C, 0x00000000,
		0x810, 0x10B019B0,
		0x814, 0x00004000,
		0x818, 0x630056F1,
		0x81C, 0x86050000,
		0x820, 0x11111133,
		0x824, 0xC3C3CCC4,
		0x828, 0x30FB186C,
		0x82C, 0x175175DA,
		0x830, 0x17511459,
		0x834, 0x776995D7,
		0x838, 0x74777A7D,
		0x83C, 0xF9AA9982,
		0x840, 0x89AA9ABB,
		0x844, 0x0DEEDDC1,
		0x848, 0xCDEEDEFF,
		0x84C, 0xFFFF5555,
		0x850, 0x6F7A727D,
		0x854, 0x6C776F7A,
		0x858, 0x6F7A6C77,
		0x85C, 0x69746974,
		0x860, 0x6F7A6C77,
		0x864, 0x6C776C77,
		0x868, 0x727D6F7A,
		0x86C, 0x69D7B196,
		0x870, 0x1A6D769B,
		0x874, 0x5582391D,
		0x878, 0x00C025BD,
		0x87C, 0x4140557D,
		0x880, 0x9A1D9D47,
		0x884, 0x1DE7134F,
		0x888, 0x2857A857,
		0x88C, 0x520E1A24,
		0x890, 0x8F628C34,
		0x894, 0x72745F43,
		0x898, 0x03F02F0D,
		0x89C, 0x5DB6886F,
		0x8A0, 0x97D4309F,
		0x8A4, 0x09412495,
		0x8A8, 0x222222A9,
		0x8AC, 0x89628C44,
		0x8B0, 0x72745F43,
		0x8B4, 0x03F02F0D,
		0x8B8, 0x55B6886F,
		0x8BC, 0x07D0309F,
		0x8C0, 0x70404023,
		0x8C4, 0x00440001,
		0x8C8, 0x7A7A2E26,
		0x8CC, 0x25297777,
		0x8D0, 0x6CEB6DCE,
		0x8D4, 0x0005A632,
		0x8D8, 0x00000000,
		0x8DC, 0x00000000,
		0x8E0, 0x00000000,
		0x8E4, 0x00000000,
		0x8E8, 0x00000000,
		0x8EC, 0x00000000,
		0x8F0, 0x00672885,
		0x8F4, 0x3C7C679C,
		0x8F8, 0x25239843,
		0x900, 0x00000000,
		0x904, 0x00000000,
		0x908, 0x000008CB,
		0x90C, 0x00000000,
		0x910, 0x00000000,
		0x914, 0x20000000,
		0x918, 0x20000000,
		0x91C, 0x20000000,
		0x920, 0x20000000,
		0x924, 0x00000000,
		0x928, 0x0000003A,
		0x92C, 0x0000003A,
		0x930, 0x0000003A,
		0x934, 0x0000003A,
		0x938, 0x0000000F,
		0x93C, 0x00000000,
		0x940, 0x4E1F3E81,
		0x944, 0x4E1F3E81,
		0x948, 0x4E1F3E81,
		0x94C, 0x4E1F3E81,
		0x950, 0x03020100,
		0x954, 0x07060504,
		0x958, 0x0B0A0908,
		0x95C, 0x0F0E0D0C,
		0x960, 0x13121110,
		0x964, 0x17161514,
		0x968, 0x03020100,
		0x96C, 0x07060504,
		0x970, 0x0B0A0908,
		0x974, 0x0F0E0D0C,
		0x978, 0x13121110,
		0x97C, 0x17161514,
		0x980, 0x03020100,
		0x984, 0x07060504,
		0x988, 0x0B0A0908,
		0x98C, 0x0F0E0D0C,
		0x990, 0x13121110,
		0x994, 0x17161514,
		0x998, 0x03020100,
		0x99C, 0x07060504,
		0x9A0, 0x0B0A0908,
		0x9A4, 0x0F0E0D0C,
		0x9A8, 0x13121110,
		0x9AC, 0x17161514,
		0x9B0, 0x00002200,
		0x9B4, 0xDB691B00,
		0x9B8, 0x00400064,
		0x9BC, 0x00000000,
		0x9C0, 0x01010101,
		0x9C4, 0x00640064,
		0x9C8, 0x00640064,
		0x9CC, 0x00007777,
		0x9D0, 0x00000000,
		0x9D4, 0x00000000,
		0x9D8, 0x00000000,
		0x9DC, 0x00000000,
		0x9E0, 0x00000000,
		0x9E4, 0x00000000,
		0x9E8, 0x00000000,
		0x9EC, 0x00000000,
		0x9F0, 0x10002CCC,
		0x9F4, 0x00000000,
		0x9F8, 0x00000000,
		0xA00, 0x02001208,
		0xA04, 0x00000000,
		0xA08, 0x00000000,
		0xA0C, 0x00000000,
		0xA10, 0x00000000,
		0xA14, 0x00000000,
		0xA18, 0x00000000,
		0xA1C, 0x00000000,
		0xA20, 0xEB31B333,
		0xA24, 0x00275485,
		0xA28, 0x00166366,
		0xA2C, 0x00275485,
		0xA30, 0x00166366,
		0xA34, 0x00275485,
		0xA38, 0x00200400,
		0xA3C, 0x00200400,
		0xA40, 0xB35DC1B9,
		0xA44, 0x3033BE95,
		0xA48, 0x2A521254,
		0xA4C, 0x52533335,
		0xA50, 0x605BE083,
		0xA54, 0x50000968,
		0xA58, 0x00020000,
		0xA5C, 0x01000000,
		0xA60, 0x02000000,
		0xA64, 0x03000000,
		0xA68, 0x00020000,
		0xA6C, 0x00000000,
		0xA70, 0x00101010,
		0xA74, 0x00000000,
		0xA78, 0x00000000,
		0xA7C, 0x00000000,
		0xA80, 0x00000000,
		0xA84, 0x00000000,
		0xA88, 0x00000000,
		0xA8C, 0x00000000,
		0xA90, 0x00000000,
		0xA94, 0x00000000,
		0xA98, 0x00000000,
		0xA9C, 0x00000000,
		0xAA0, 0x00000000,
		0xAA4, 0x00000000,
		0xAA8, 0x00000000,
		0xAAC, 0x00000000,
		0xAB0, 0x00000000,
		0xAB4, 0x00000000,
		0xAB8, 0x00000000,
		0xABC, 0x00000000,
		0xAC0, 0x00000000,
		0xAC4, 0x00000000,
		0xAC8, 0x00000000,
		0xACC, 0x00000000,
		0xAD0, 0x00000000,
		0xAD4, 0x00000000,
		0xAD8, 0x00000000,
		0xADC, 0x00000000,
		0xAE0, 0x00000000,
		0xAE4, 0x00000000,
		0xAE8, 0x00000000,
		0xAEC, 0x00000000,
		0xAF0, 0x00000000,
		0xAF4, 0x00000000,
		0xAF8, 0x00000000,
		0xB00, 0x00000000,
		0xB04, 0x00000000,
		0xB08, 0x00000000,
		0xB0C, 0x00000000,
		0xB10, 0x00000000,
		0xB14, 0x00000000,
		0xB18, 0x00000000,
		0xB1C, 0x00000000,
		0xB20, 0x00000000,
		0xB24, 0x00000000,
		0xB28, 0x00000000,
		0xB2C, 0x00000000,
		0xB30, 0x00000000,
		0xB34, 0x00000000,
		0xB38, 0x00000000,
		0xB3C, 0x00000000,
		0xB40, 0x00000000,
		0xB44, 0x00000000,
		0xB48, 0x00000000,
		0xB4C, 0x00000000,
		0xB50, 0x00000000,
		0xB54, 0x00000000,
		0xB58, 0x00000000,
		0xB5C, 0x00000000,
		0xB60, 0x00000000,
		0xB64, 0x00000000,
		0xB68, 0x00000000,
		0xB6C, 0x00000000,
		0xB70, 0x00000000,
		0xB74, 0x00000000,
		0xB78, 0x00000000,
		0xB7C, 0x00000000,
		0xB80, 0x00000000,
		0xB84, 0x00000000,
		0xB88, 0x00000000,
		0xB8C, 0x00000000,
		0xB90, 0x00000000,
		0xB94, 0x00000000,
		0xB98, 0x00000000,
		0xB9C, 0x00000000,
		0xBA0, 0x00000000,
		0xBA4, 0x00000000,
		0xBA8, 0x00000000,
		0xBAC, 0x00000000,
		0xBB0, 0x00000000,
		0xBB4, 0x00000000,
		0xBB8, 0x00000000,
		0xBBC, 0x00000000,
		0xBC0, 0x00000000,
		0xBC4, 0x00000000,
		0xBC8, 0x00000000,
		0xBCC, 0x00000000,
		0xBD0, 0x00000000,
		0xBD4, 0x00000000,
		0xBD8, 0x00000000,
		0xBDC, 0x00000000,
		0xBE0, 0x00000000,
		0xBE4, 0x00000000,
		0xBE8, 0x00000000,
		0xBEC, 0x00000000,
		0xBF0, 0x00000000,
		0xBF4, 0x00000000,
		0xBF8, 0x00000000,
		0xC00, 0x1D8BA0D6,
		0xC04, 0x00000001,
		0xC08, 0x00000000,
		0xC0C, 0x02F1D8B7,
		0xC10, 0x000000B0,
		0xC14, 0x0000D890,
		0xC18, 0x00087672,
		0xC1C, 0x15260000,
		0xC20, 0x00000000,
	0x81000000,	0x00000000,	0x40000000,	0x00000000,
		0xC24, 0x406000FF,
	0x91000001,	0x00000000,	0x40000000,	0x00000000,
		0xC24, 0x406000FF,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0xC24, 0x406000FF,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0xC24, 0x406000FF,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0xC24, 0x406000FF,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0xC24, 0x406000FF,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0xC24, 0x406000FF,
	0xA0000000,	0x00000000,
		0xC24, 0x40600000,
	0xB0000000,	0x00000000,
		0xC28, 0x06400F76,
		0xC2C, 0xE314A0E1,
		0xC30, 0x140C9494,
		0xC34, 0x00A04946,
		0xC38, 0x011D4820,
		0xC3C, 0x168DB61B,
		0xC40, 0x009C50F8,
		0xC44, 0x2013BAD1,
		0xC48, 0xFFFFF7CC,
		0xC4C, 0xA000FFFF,
		0xC50, 0x20D0F800,
		0xC54, 0x941A0200,
		0xC58, 0x18380111,
		0xC5C, 0x006E01B8,
		0xC60, 0x2CA5555B,
		0xC64, 0x0210005F,
		0xC68, 0x039A5300,
		0xC6C, 0x0265C2BA,
		0xC70, 0x000CEB21,
		0xC74, 0x0E149CA1,
		0xC78, 0x1AB4956B,
		0xC7C, 0x00000ABF,
		0xC80, 0xC02A8799,
		0xC84, 0x06C636C6,
		0xC88, 0x08090202,
		0xC8C, 0x00204048,
		0xC90, 0x00F85F85,
		0xC94, 0x00000F85,
		0xC98, 0x58385858,
		0xC9C, 0x18382838,
		0xCA0, 0x00002838,
		0xCA4, 0x3A253A3A,
		0xCA8, 0x10251A25,
		0xCAC, 0x00001025,
		0xCB0, 0x3A133A3A,
		0xCB4, 0x08130D13,
		0xCB8, 0x00000813,
		0xCBC, 0x001F1066,
		0xCC0, 0x88A00400,
		0xCC4, 0x00200400,
		0xCC8, 0x0B200400,
		0xCCC, 0x00600400,
		0xCD0, 0x00000092,
		0xCD4, 0x22220000,
		0xCD8, 0x22222222,
		0xCDC, 0x22222222,
		0xCE0, 0x22222222,
		0xCE4, 0x22222222,
		0xCE8, 0xFFFF2222,
		0xCEC, 0xFFFFFFFF,
		0xCF0, 0xFFFFFFFF,
		0xCF4, 0xDFFFFFBF,
		0xCF8, 0xFFFFFFFD,
		0xCFC, 0xFFFFFFFF,
		0xD00, 0x1083A10A,
		0xD04, 0x0EC42948,
		0xD08, 0x10852108,
		0xD0C, 0x0CC41D08,
		0xD10, 0x108620EC,
		0xD14, 0x0CA42108,
		0xD18, 0x107620E8,
		0xD1C, 0x0E742108,
		0xD20, 0x0E8618C8,
		0xD24, 0x00000108,
		0xD28, 0x288C224C,
		0xD2C, 0x11C6320C,
		0xD30, 0x30CEBD98,
		0xD34, 0x10C31908,
		0xD38, 0x310A318C,
		0xD3C, 0x18C41D08,
		0xD40, 0x28CC4190,
		0xD44, 0x19062108,
		0xD48, 0x294A5A17,
		0xD4C, 0x00000108,
		0xD50, 0x10A3A908,
		0xD54, 0x10842148,
		0xD58, 0x14C5314A,
		0xD5C, 0x1086258C,
		0xD60, 0x10A42948,
		0xD64, 0x10842108,
		0xD68, 0x08C42108,
		0xD6C, 0x10842148,
		0xD70, 0x08822084,
		0xD74, 0x10841D04,
		0xD78, 0x08421088,
		0xD7C, 0x1083A104,
		0xD80, 0x10842108,
		0xD84, 0x1085294A,
		0xD88, 0x08822104,
		0xD8C, 0x10852948,
		0xD90, 0x08421084,
		0xD94, 0x10852104,
		0xD98, 0x08421084,
		0xD9C, 0x10863184,
		0xDA0, 0x1083B10A,
		0xDA4, 0x10842148,
		0xDA8, 0x1984718C,
		0xDAC, 0x108C33AF,
		0xDB0, 0x00000000,
		0xDB4, 0x00000000,
		0xDB8, 0x00000000,
		0xDBC, 0x00000000,
		0xDC0, 0x00000000,
		0xDC4, 0x00000000,
		0xDC8, 0x00000000,
		0xDCC, 0x00000000,
		0xDD0, 0x00000000,
		0xDD4, 0x00000000,
		0xDD8, 0x00000000,
		0xDDC, 0x00000000,
		0xDE0, 0x00000000,
		0xDE4, 0x00000000,
		0xDE8, 0x00000000,
		0xDEC, 0x00000000,
		0xDF0, 0x00000000,
		0xDF4, 0x00000000,
		0xDF8, 0x00000000,
		0x1800, 0x00033312,
		0x1804, 0x40033312,
		0x180C, 0x97F43860,
		0x1810, 0xB3001402,
		0x1814, 0x46000141,
		0x1818, 0x00000A95,
		0x181C, 0x00000000,
		0x1820, 0x02D508CC,
		0x1824, 0x506AA5B4,
		0x1828, 0x000004FD,
		0x182C, 0x00000000,
		0x1834, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x1838, 0x21000C00,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x1838, 0x21000C00,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x1838, 0x21000C00,
	0xA0000000,	0x00000000,
		0x1838, 0x20000000,
	0xB0000000,	0x00000000,
	0x81000005,	0x00000000,	0x40000000,	0x00000000,
		0x183C, 0x00000100,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x183C, 0x00000100,
	0xA0000000,	0x00000000,
		0x183C, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x1840, 0x00020000,
		0x1844, 0x00000004,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x1840, 0x00020000,
		0x1844, 0x00000004,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x1840, 0x00020000,
		0x1844, 0x00000004,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x1840, 0x00020000,
		0x1844, 0x00000004,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x1840, 0x00020000,
		0x1844, 0x00000004,
	0xA0000000,	0x00000000,
		0x1840, 0x00000000,
		0x1844, 0x00000000,
	0xB0000000,	0x00000000,
		0x1848, 0x00000000,
		0x184C, 0x00000000,
		0x1850, 0x00000000,
		0x1854, 0x00000000,
		0x1858, 0x00000000,
		0x185C, 0x00000000,
		0x1860, 0xF0040FF8,
		0x1864, 0x7F000000,
		0x1868, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x186C, 0x2000FF02,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x186C, 0x2000FF00,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x186C, 0x2000FF00,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x186C, 0x2000FF02,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x186C, 0x2000FF02,
	0xA0000000,	0x00000000,
		0x186C, 0x0000FF00,
	0xB0000000,	0x00000000,
		0x1870, 0x00000000,
		0x1874, 0x00000000,
		0x1878, 0x00000000,
		0x187C, 0x00000000,
		0x1880, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x1884, 0x02F00000,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x1884, 0x02F00000,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x1884, 0x02F00000,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x1884, 0x02F00000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x1884, 0x02F00000,
	0xA0000000,	0x00000000,
		0x1884, 0x02B00000,
	0xB0000000,	0x00000000,
		0x1888, 0x00000000,
		0x188C, 0x00000000,
		0x1890, 0x00000000,
		0x1894, 0x00000000,
		0x1898, 0x00000000,
		0x18A0, 0x00510000,
		0x18A4, 0x10141F7F,
		0x18A8, 0x0A02C99A,
		0x18AC, 0x00004200,
		0x18B0, 0x0809FB08,
		0x18B0, 0x0809FB09,
		0x18B4, 0x00000000,
		0x18B8, 0x00000000,
		0x18BC, 0x00C3FF80,
		0x18C0, 0x0002D100,
		0x18C4, 0x00000004,
		0x18C8, 0x001FFFE0,
		0x18CC, 0x0809FB08,
		0x18CC, 0x0809FB09,
		0x18D0, 0x00000000,
		0x18D4, 0x00000000,
		0x18D8, 0x00C3FF80,
		0x18DC, 0x0002D100,
		0x18E0, 0x00000004,
		0x18E4, 0x001FFFE0,
		0x18E8, 0x00800000,
		0x18EC, 0x1EC08000,
		0x18F0, 0x7F000064,
		0x18F4, 0x1F7DE75C,
		0x18F8, 0x7F7F7F7F,
		0x18FC, 0x7F7F7F7F,
		0x1900, 0xA7A7A8A8,
		0x1904, 0x95959595,
	0x81000000,	0x00000000,	0x40000000,	0x00000000,
		0x1908, 0x00777777,
	0x91000001,	0x00000000,	0x40000000,	0x00000000,
		0x1908, 0x00777777,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x1908, 0x00777777,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x1908, 0x00777777,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x1908, 0x00777777,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x1908, 0x00777777,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x1908, 0x00777777,
	0xA0000000,	0x00000000,
		0x1908, 0x00777767,
	0xB0000000,	0x00000000,
		0x190C, 0x77776666,
		0x1910, 0x00033333,
		0x1914, 0xAAAC875A,
		0x1918, 0x2AA2A8A2,
		0x191C, 0x2AAAA8A2,
		0x1920, 0x00878766,
		0x1924, 0x000C4924,
		0x1928, 0x1669B6C0,
		0x192C, 0x00406D90,
		0x1930, 0xB85C0492,
		0x1934, 0x00B4A298,
		0x1938, 0x00030151,
		0x193C, 0x0058C618,
		0x1940, 0x41000000,
		0x1944, 0x00000BCB,
		0x1948, 0xAAAAAAAA,
		0x194C, 0x00B99999,
		0x1950, 0x88886665,
		0x1954, 0x00000000,
		0x1958, 0x00000618,
		0x195C, 0x00000000,
		0x1960, 0x00000000,
		0x1964, 0x00000000,
		0x1968, 0x00000000,
		0x196C, 0x00000000,
		0x1970, 0x00000000,
		0x1974, 0x00000000,
		0x1978, 0x00000000,
		0x197C, 0x00000000,
		0x1980, 0x00000000,
		0x1984, 0x00000000,
		0x1988, 0x00000000,
		0x198C, 0x00000000,
		0x1990, 0x00000000,
		0x1994, 0x00000000,
		0x1998, 0x00000000,
		0x199C, 0x00000000,
		0x19A0, 0x00000000,
		0x19A4, 0x00000000,
		0x19A8, 0x00000000,
		0x19AC, 0x00000000,
		0x19B0, 0x00000000,
		0x19B4, 0x00000000,
		0x19B8, 0x00000000,
		0x19BC, 0x00000000,
		0x19C0, 0x00000000,
		0x19C4, 0x00000000,
		0x19C8, 0x00000000,
		0x19CC, 0x00000000,
		0x19D0, 0x00000000,
		0x19D4, 0x00000000,
		0x19D8, 0x00000000,
		0x19DC, 0x00000000,
		0x19E0, 0x00000000,
		0x19E4, 0x00000000,
		0x19E8, 0x00000000,
		0x19EC, 0x00000000,
		0x19F0, 0x00000000,
		0x19F4, 0x00000000,
		0x19F8, 0x00000000,
		0x1C00, 0x00000000,
		0x1C04, 0x00000000,
		0x1C08, 0x00000000,
		0x1C0C, 0x00000000,
		0x1C10, 0x00000000,
		0x1C14, 0x00000000,
		0x1C18, 0x00000000,
		0x1C1C, 0x00000000,
		0x1C20, 0x03C23F20,
		0x1C24, 0xF101F002,
		0x1C28, 0x0FFE0010,
		0x1C2C, 0x453090FF,
		0x1C30, 0xFE0090FE,
		0x1C34, 0xE4E42000,
		0x1C38, 0xFFA1005E,
		0x1C40, 0x8F588837,
	0x81000000,	0x00000000,	0x40000000,	0x00000000,
		0x1C44, 0x04400700,
	0x91000001,	0x00000000,	0x40000000,	0x00000000,
		0x1C44, 0x04400700,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x1C44, 0x04400700,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x1C44, 0x04400700,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x1C44, 0x04400700,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x1C44, 0x04400700,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x1C44, 0x04400700,
	0xA0000000,	0x00000000,
		0x1C44, 0x04400300,
	0xB0000000,	0x00000000,
		0x1C48, 0x00000002,
		0x1C4C, 0x00000200,
		0x1C50, 0x8E588837,
		0x1C54, 0x04400300,
		0x1C58, 0x00000000,
		0x1C5C, 0xFFFFFFFF,
		0x1C60, 0x0F030032,
		0x1C64, 0x760F0000,
		0x1C68, 0xC07F0000,
		0x1C6C, 0x00010000,
		0x1C70, 0x00037FFE,
		0x1C74, 0x00000000,
		0x1C78, 0x00020000,
		0x1C7C, 0x00300000,
		0x1C80, 0x0E38E000,
		0x1C84, 0x245140D4,
		0x1C88, 0xC8400483,
		0x1C8C, 0x40005A20,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x1C94, 0x00000333,
		0x1C98, 0x00040005,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x1C94, 0x00000333,
		0x1C98, 0x00040005,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x1C94, 0x00000333,
		0x1C98, 0x00040005,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x1C94, 0x00000333,
		0x1C98, 0x00040005,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x1C94, 0x00000333,
		0x1C98, 0x00040005,
	0xA0000000,	0x00000000,
		0x1C94, 0x00000000,
		0x1C98, 0x00000000,
	0xB0000000,	0x00000000,
		0x1C9C, 0x00000000,
		0x1CA0, 0x00000000,
		0x1CA4, 0x20000000,
		0x1CA8, 0x0E000000,
		0x1CAC, 0xE424A2CC,
		0x1CB0, 0x00000000,
		0x1CB4, 0x00000000,
		0x1CB8, 0x24800000,
		0x1CBC, 0x60004800,
		0x1CC0, 0x24800000,
		0x1CC4, 0x60004800,
		0x1CC8, 0xF0444900,
		0x1CCC, 0x030300F1,
		0x1CD0, 0x0F000000,
		0x1CD4, 0x02024B00,
		0x1CD8, 0x04000000,
		0x1CDC, 0x10000000,
		0x1CE0, 0x60000000,
		0x1CE4, 0x00000000,
		0x1CE8, 0xC0000000,
		0x1CEC, 0x00000000,
		0x1CF0, 0x00000000,
		0x1CF4, 0xE4000000,
		0x1CF8, 0x00000000,
		0x1D00, 0x00000000,
		0x1D04, 0x08A3C000,
		0x1D08, 0xA0000000,
		0x1D10, 0x08B5BBBB,
		0x1D14, 0x77777777,
		0x1D18, 0x99999999,
		0x1D1C, 0x99999999,
		0x1D20, 0x000081E0,
		0x1D24, 0x00000000,
		0x1D28, 0x00000000,
		0x1D2C, 0xC0000000,
		0x1D30, 0x50249400,
		0x1D34, 0x00000000,
		0x1D38, 0x00000000,
		0x1D3C, 0xF8000000,
		0x1D40, 0x00000000,
		0x1D44, 0x74740000,
		0x1D48, 0x14147474,
		0x1D4C, 0x00FFFF14,
		0x1D50, 0x00000000,
		0x1D54, 0x03A00000,
		0x1D58, 0x80800000,
		0x1D5C, 0x00000000,
		0x1D60, 0x00000000,
		0x1D64, 0x88000000,
		0x1D68, 0x00000000,
		0x1D6C, 0x666D8001,
		0x1D70, 0x20202020,
		0x1D74, 0x4E4E4E4E,
		0x1D78, 0x18189818,
		0x1D7C, 0x0005A000,
		0x1D80, 0x00080000,
		0x1D84, 0x00080000,
		0x1D88, 0x000000EF,
		0x1D8C, 0x0C0C0C0C,
		0x1D90, 0x103F003F,
		0x1D94, 0x00000000,
		0x1D98, 0x37001400,
		0x1D9C, 0x00000000,
		0x1DA0, 0x00000000,
		0x1DA4, 0x80000000,
		0x1DA8, 0x00000000,
		0x1DAC, 0x00000000,
		0x1DB0, 0x00000000,
		0x1DB4, 0x00000000,
		0x1DB8, 0x00000000,
		0x1DBC, 0x00000000,
		0x1DC0, 0x00000000,
		0x1DC4, 0x00000000,
		0x1DC8, 0x00000000,
		0x1DCC, 0x00000000,
		0x1DD0, 0x00000000,
		0x1DD4, 0x00000000,
		0x1DD8, 0x00000000,
		0x1DDC, 0x1FDF0000,
		0x1DE0, 0x01010000,
		0x1DE4, 0x45210123,
		0x1DE8, 0xFFFF4848,
		0x1DEC, 0x00000000,
		0x1DF0, 0x00000000,
		0x1DF4, 0x80000000,
		0x1DF8, 0x00000000,
	0x81000000,	0x00000000,	0x40000000,	0x00000000,
		0x1DFC, 0x80000000,
	0x91000001,	0x00000000,	0x40000000,	0x00000000,
		0x1DFC, 0x80000000,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x1DFC, 0x80000000,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x1DFC, 0x80000000,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x1DFC, 0x80000000,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x1DFC, 0x80000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x1DFC, 0x80000000,
	0xA0000000,	0x00000000,
		0x1DFC, 0x00000000,
	0xB0000000,	0x00000000,
		0x1E00, 0x00000000,
		0x1E04, 0x00000000,
		0x1E08, 0x00000000,
		0x1E0C, 0x00000000,
		0x1E10, 0x00000000,
		0x1E14, 0x00000000,
		0x1E18, 0x00000000,
		0x1E1C, 0x84008000,
		0x1E20, 0x00000000,
		0x1E24, 0x80003000,
		0x1E28, 0x000CCEC3,
		0x1E2C, 0xE4E40404,
		0x1E30, 0xE4E4E4E4,
		0x1E34, 0xF3001234,
		0x1E38, 0x00000000,
		0x1E3C, 0x00000000,
		0x1E40, 0x00000000,
		0x1E44, 0x00000000,
		0x1E48, 0x00000000,
		0x1E4C, 0x00000000,
		0x1E50, 0x00000000,
		0x1E54, 0x00000000,
		0x1E58, 0x00000000,
		0x1E5C, 0xC1000000,
		0x1E60, 0x00000000,
		0x1E64, 0xF3A00001,
		0x1E68, 0x0028846E,
		0x1E6C, 0x002F4906,
		0x1E70, 0x00001000,
		0x1E74, 0x00000000,
		0x1E78, 0x00000000,
		0x1E7C, 0x00000000,
		0x1E80, 0x00000000,
		0x1E84, 0x00000000,
		0x1E84, 0x40000000,
		0x1E84, 0x41000000,
		0x1E84, 0x42000000,
		0x1E84, 0x43000000,
		0x1E84, 0x44000000,
		0x1E84, 0x45000000,
		0x1E84, 0x46000000,
		0x1E84, 0x47000000,
		0x1E84, 0x48000000,
		0x1E84, 0x49000000,
		0x1E84, 0x4A000000,
		0x1E84, 0x4B000000,
		0x1E84, 0x4C000000,
		0x1E84, 0x4D000000,
		0x1E84, 0x4E000000,
		0x1E84, 0x4F000000,
		0x1E84, 0x50000000,
		0x1E84, 0x51000000,
		0x1E84, 0x52000000,
		0x1E84, 0x53000000,
		0x1E84, 0x54000000,
		0x1E84, 0x55000000,
		0x1E84, 0x56000000,
		0x1E84, 0x57000000,
		0x1E84, 0x58000000,
		0x1E84, 0x59000000,
		0x1E84, 0x5A000000,
		0x1E84, 0x5B000000,
		0x1E84, 0x5C000000,
		0x1E84, 0x5D000000,
		0x1E84, 0x5E000000,
		0x1E84, 0x5F000000,
		0x1E84, 0x60000000,
		0x1E84, 0x61000000,
		0x1E84, 0x62000000,
		0x1E84, 0x63000000,
		0x1E84, 0x64000000,
		0x1E84, 0x65000000,
		0x1E84, 0x66000000,
		0x1E84, 0x67000000,
		0x1E84, 0x68000000,
		0x1E84, 0x69000000,
		0x1E84, 0x6A000000,
		0x1E84, 0x6B000000,
		0x1E84, 0x6C000000,
		0x1E84, 0x6D000000,
		0x1E84, 0x6E000000,
		0x1E84, 0x6F000000,
		0x1E84, 0x70000000,
		0x1E84, 0x71000000,
		0x1E84, 0x72000000,
		0x1E84, 0x73000000,
		0x1E84, 0x74000000,
		0x1E84, 0x75000000,
		0x1E84, 0x76000000,
		0x1E84, 0x77000000,
		0x1E84, 0x78000000,
		0x1E84, 0x79000000,
		0x1E84, 0x7A000000,
		0x1E84, 0x7B000000,
		0x1E84, 0x7C000000,
		0x1E84, 0x7D000000,
		0x1E84, 0x7E000000,
		0x1E84, 0x7F000000,
		0x1E84, 0x80000000,
		0x1E84, 0x00000000,
		0x1E88, 0x0200FC1C,
		0x1E8C, 0x00000000,
		0x1E90, 0x00000000,
		0x1E94, 0x04000000,
		0x1E98, 0x00000000,
		0x1E9C, 0x00000000,
		0x1EA0, 0x00000000,
	0x81000000,	0x00000000,	0x40000000,	0x00000000,
		0x1EA4, 0x04000000,
	0x91000001,	0x00000000,	0x40000000,	0x00000000,
		0x1EA4, 0x04000000,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x1EA4, 0x04000000,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x1EA4, 0x04000000,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x1EA4, 0x04000000,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x1EA4, 0x04000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x1EA4, 0x04000000,
	0xA0000000,	0x00000000,
		0x1EA4, 0x00000000,
	0xB0000000,	0x00000000,
		0x1EA8, 0xAA464646,
		0x1EAC, 0x01800030,
		0x1EB0, 0x0000300E,
		0x1EB4, 0xB1800002,
		0x1EB8, 0x00000000,
		0x1EBC, 0x00000000,
		0x1EC0, 0x00000000,
		0x1EC4, 0x00000000,
		0x1EC8, 0x00000000,
		0x1ECC, 0x00000000,
		0x1ED0, 0x00000000,
		0x1ED4, 0x8000000A,
		0x1ED8, 0x800B03E8,
		0x1EDC, 0x83E90FFF,
		0x1EE0, 0x8000FFFF,
		0x1EE4, 0x70000000,
		0x1EE8, 0x00000000,
		0x1EEC, 0x0280A933,
		0x1EF0, 0x00000A80,
		0x1EF4, 0x00001266,
		0x1EF8, 0x01000100,
		0x3A00, 0x0004080C,
		0x3A04, 0x1C202428,
		0x3A08, 0x0C101418,
		0x3A0C, 0x181C2024,
		0x3A10, 0x080C1014,
		0x3A14, 0x181C2024,
		0x3A18, 0x080C1014,
		0x3A1C, 0x00000000,
		0x3A20, 0x00000000,
		0x3A24, 0x00000000,
		0x3A28, 0x00000000,
		0x3A2C, 0x181C2024,
		0x3A30, 0x080C1014,
		0x3A34, 0x20240004,
		0x3A38, 0x1014181C,
		0x3A3C, 0x0004080C,
		0x3A40, 0x00000000,
		0x3A44, 0x00000000,
		0x3A48, 0x00000000,
		0x3A4C, 0x00000000,
		0x3A50, 0x00000000,
		0x3A54, 0x00000000,
		0x3A58, 0x00000000,
		0x3A5C, 0x00000000,
		0x3A60, 0x00000000,
		0x3A64, 0x00000000,
		0x3A68, 0x00000000,
		0x3A6C, 0x00000000,
		0x3A70, 0x00000000,
		0x3A74, 0x00000000,
		0x3A78, 0x00000000,
		0x3A7C, 0x00000000,
		0x3A80, 0x00000000,
		0x3A84, 0x00000000,
		0x3A88, 0x00000000,
		0x3A8C, 0x00000000,
		0x3A90, 0x00000000,
		0x3A94, 0x00000000,
		0x3A98, 0x00000000,
		0x3A9C, 0x00000000,
		0x3AA0, 0x00000000,
		0x3AA4, 0x00000000,
		0x3AA8, 0x00000000,
		0x3AAC, 0x00000000,
		0x3AB0, 0x00000000,
		0x3AB4, 0x00000000,
		0x3AB8, 0x00000000,
		0x3ABC, 0x00000000,
		0x3AC0, 0x00000000,
		0x3AC4, 0x00000000,
		0x3AC8, 0x00000000,
		0x3ACC, 0x00000000,
		0x3AD0, 0x00000000,
		0x3AD4, 0x00000000,
		0x3AD8, 0x00000000,
		0x3ADC, 0x00000000,
		0x3AE0, 0x00000000,
		0x3AE4, 0x00000000,
		0x3AE8, 0x00000000,
		0x3AEC, 0x00000000,
		0x3AF0, 0x00000000,
		0x3AF4, 0x00000000,
		0x3AF8, 0x00000000,
		0x4000, 0xA6A6A6A6,
		0x4004, 0x95959595,
	0x81000000,	0x00000000,	0x40000000,	0x00000000,
		0x4008, 0x00777776,
	0x91000001,	0x00000000,	0x40000000,	0x00000000,
		0x4008, 0x00777776,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x4008, 0x00777776,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x4008, 0x00777776,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x4008, 0x00777776,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x4008, 0x00777776,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x4008, 0x00777776,
	0xA0000000,	0x00000000,
		0x4008, 0x00777777,
	0xB0000000,	0x00000000,
		0x400C, 0x77776666,
		0x4010, 0x00033333,
		0x4014, 0xAAAC875A,
		0x4018, 0x2AA2A8A2,
		0x401C, 0x2AAAA8A2,
		0x4020, 0x00878766,
		0x4024, 0x000E4924,
		0x4028, 0x166DB6C0,
		0x402C, 0x00407190,
		0x4030, 0xB85C0492,
		0x4034, 0x00B4A298,
		0x4038, 0x00030151,
		0x403C, 0x0058C618,
		0x4040, 0x41000000,
		0x4044, 0x00000BCB,
		0x4048, 0xAAAAAAAA,
		0x404C, 0x00B98989,
		0x4050, 0x88886665,
		0x4054, 0x08888888,
		0x4058, 0x00000618,
		0x405C, 0x00000000,
		0x4060, 0x00000000,
		0x4064, 0x00000000,
		0x4068, 0x00000000,
		0x406C, 0x00000000,
		0x4070, 0x00000000,
		0x4074, 0x00000000,
		0x4078, 0x00000000,
		0x407C, 0x00000000,
		0x4080, 0x00000000,
		0x4084, 0x00000000,
		0x4088, 0x00000000,
		0x408C, 0x00000000,
		0x4090, 0x00000000,
		0x4094, 0x00000000,
		0x4098, 0x00000000,
		0x409C, 0x00000000,
		0x40A0, 0x00000000,
		0x40A4, 0x00000000,
		0x40A8, 0x00000000,
		0x40AC, 0x00000000,
		0x40B0, 0x00000000,
		0x40B4, 0x00000000,
		0x40B8, 0x00000000,
		0x40BC, 0x00000000,
		0x40C0, 0x00000000,
		0x40C4, 0x00000000,
		0x40C8, 0x00000000,
		0x40CC, 0x00000000,
		0x40D0, 0x00000000,
		0x40D4, 0x00000000,
		0x40D8, 0x00000000,
		0x40DC, 0x00000000,
		0x40E0, 0x00000000,
		0x40E4, 0x00000000,
		0x40E8, 0x00000000,
		0x40EC, 0x00000000,
		0x40F0, 0x00000000,
		0x40F4, 0x00000000,
		0x40F8, 0x00000000,
		0x4100, 0x00033312,
		0x4104, 0x40033312,
		0x410C, 0x97F43860,
		0x4110, 0xB3001402,
		0x4114, 0x46000141,
		0x4118, 0x00000A95,
		0x411C, 0x00000000,
		0x4120, 0x02D508CC,
		0x4124, 0x506AA5B4,
		0x4128, 0x000004FD,
		0x412C, 0x00000000,
		0x4134, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x4138, 0x21000C00,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x4138, 0x21000C00,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x4138, 0x21000C00,
	0xA0000000,	0x00000000,
		0x4138, 0x20000000,
	0xB0000000,	0x00000000,
	0x81000005,	0x00000000,	0x40000000,	0x00000000,
		0x413C, 0x00000002,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x413C, 0x00000002,
	0xA0000000,	0x00000000,
		0x413C, 0x00000000,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x4140, 0x00000040,
		0x4144, 0x00000020,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x4140, 0x00000040,
		0x4144, 0x00000020,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x4140, 0x00000040,
		0x4144, 0x00000020,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x4140, 0x00000040,
		0x4144, 0x00000020,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x4140, 0x00000040,
		0x4144, 0x00000020,
	0xA0000000,	0x00000000,
		0x4140, 0x00000000,
		0x4144, 0x00000000,
	0xB0000000,	0x00000000,
		0x4148, 0x00000000,
		0x414C, 0x00000000,
		0x4150, 0x00000000,
		0x4154, 0x00000000,
		0x4158, 0x00000000,
		0x415C, 0x00000000,
		0x4160, 0xF0040FF8,
		0x4164, 0x7F000000,
		0x4168, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x416C, 0x20008002,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x416C, 0x20008000,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x416C, 0x20008000,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x416C, 0x20008002,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x416C, 0x20008002,
	0xA0000000,	0x00000000,
		0x416C, 0x00008000,
	0xB0000000,	0x00000000,
		0x4170, 0x00000000,
		0x4174, 0x00000000,
		0x4178, 0x00000000,
		0x417C, 0x00000000,
		0x4180, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x4184, 0x02F00000,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x4184, 0x02F00000,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x4184, 0x02F00000,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x4184, 0x02F00000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x4184, 0x02F00000,
	0xA0000000,	0x00000000,
		0x4184, 0x02B00000,
	0xB0000000,	0x00000000,
		0x4188, 0x00000000,
		0x418C, 0x00000000,
		0x4190, 0x00000000,
		0x4194, 0x00000000,
		0x4198, 0x00000000,
		0x41A0, 0x00510000,
		0x41A4, 0x10141F7F,
		0x41A8, 0x1402C99A,
		0x41AC, 0x00004200,
		0x41B0, 0x0809FB08,
		0x41B0, 0x0809FB09,
		0x41B4, 0x00000000,
		0x41B8, 0x00000000,
		0x41BC, 0x00C3FF80,
		0x41C0, 0x0002D100,
		0x41C4, 0x00000004,
		0x41C8, 0x001FFFE0,
		0x41CC, 0x0809FB08,
		0x41CC, 0x0809FB09,
		0x41D0, 0x00000000,
		0x41D4, 0x00000000,
		0x41D8, 0x00C3FF80,
		0x41DC, 0x0002D100,
		0x41E0, 0x00000004,
		0x41E4, 0x001FFFE0,
		0x41E8, 0x00000200,
		0x41EC, 0x1E008000,
		0x41F0, 0x7F000064,
		0x41F4, 0x1F7DE75C,
		0x41F8, 0x7F7F7F7F,
		0x41FC, 0x7F7F7F7F,
		0x1830, 0x700B8041,
		0x1830, 0x700B8041,
		0x1830, 0x701F0044,
		0x1830, 0x702F0044,
		0x1830, 0x703F0044,
		0x1830, 0x704F0044,
		0x1830, 0x705B8041,
		0x1830, 0x706F0044,
		0x1830, 0x707B8041,
		0x1830, 0x708B8041,
		0x1830, 0x709B8041,
		0x1830, 0x70AB8041,
		0x1830, 0x70BB8041,
		0x1830, 0x70CB8041,
		0x1830, 0x70DB8041,
		0x1830, 0x70EB8041,
		0x1830, 0x70FB8041,
		0x1830, 0x70FB8041,
		0x4130, 0x700B0041,
		0x4130, 0x700B8041,
		0x4130, 0x701F0044,
		0x4130, 0x702F0044,
		0x4130, 0x703F0044,
		0x4130, 0x704F0044,
		0x4130, 0x705B8041,
		0x4130, 0x706F0044,
		0x4130, 0x707B8041,
		0x4130, 0x708B8041,
		0x4130, 0x709B8041,
		0x4130, 0x70AB8041,
		0x4130, 0x70BB8041,
		0x4130, 0x70CB8041,
		0x4130, 0x70DB8041,
		0x4130, 0x70EB8041,
		0x4130, 0x70FB8041,
		0x4130, 0x70FB8041,
		0x1A00, 0x00D047C8,
		0x1A04, 0xC0000008,
		0x1A08, 0x88838300,
		0x1A0C, 0x2E20100F,
		0x1A10, 0x9500BB78,
		0x1A14, 0x11144028,
		0x1A18, 0x00881117,
		0x1A1C, 0x89140F00,
		0x1A20, 0x52840000,
		0x1A24, 0x3E18FEC8,
		0x1A28, 0x00150A88,
		0x1A2C, 0x12988000,
		0x1A30, 0x10114007,
		0x1A34, 0x1011C007,
		0x1A38, 0x00000000,
		0x1A3C, 0x00000000,
		0x1A40, 0x00000000,
		0x1A44, 0x00000000,
		0x1A48, 0x000C0000,
		0x1A4C, 0xB00000C0,
		0x1A50, 0x22040700,
		0x1A54, 0x09003000,
		0x1A58, 0x00000881,
		0x1A5C, 0x00000128,
		0x1A60, 0x85830000,
		0x1A64, 0x00000128,
		0x1A68, 0x00222211,
		0x1A6C, 0x00000000,
		0x1A70, 0x00008000,
		0x1A74, 0x00000948,
	0x81000000,	0x00000000,	0x40000000,	0x00000000,
		0x1A78, 0x000089F4,
	0x91000001,	0x00000000,	0x40000000,	0x00000000,
		0x1A78, 0x000089F4,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x1A78, 0x000089F4,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x1A78, 0x000089F4,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x1A78, 0x000089F4,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x1A78, 0x000089F4,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x1A78, 0x000089F4,
	0xA0000000,	0x00000000,
		0x1A78, 0x000089F0,
	0xB0000000,	0x00000000,
		0x1A7C, 0x225B0606,
		0x1A80, 0x208A7532,
		0x1A84, 0x85200200,
		0x1A88, 0xE4DC0000,
		0x1A8C, 0x00000000,
		0x1A90, 0x00000000,
		0x1A94, 0x00000000,
		0x1A98, 0xACC4C040,
		0x1A9C, 0x0016C8B2,
		0x1AA0, 0x00FAF0DE,
		0x1AA4, 0x00020000,
		0x1AA8, 0xEA0F0044,
		0x1AAC, 0x00122344,
		0x1AB0, 0x0FFFFFFF,
		0x1AB4, 0x0F201402,
		0x1AB8, 0x00000000,
		0x1ABC, 0xC2018080,
		0x1AC0, 0x54D0A742,
		0x1AC4, 0x00000000,
		0x1AC8, 0x00000807,
		0x1ACC, 0x00000707,
		0x1AD0, 0xA13529EF,
		0x1AD4, 0x4C9D8452,
		0x1AD8, 0xE4024024,
		0x1ADC, 0x000DB000,
		0x1AE0, 0x00600391,
		0x1AE4, 0x08000080,
		0x1AE8, 0x00000002,
		0x1AEC, 0x00000000,
		0x1AF0, 0x00000000,
		0x1AF4, 0x00000000,
		0x1AF8, 0x00000000,
		0x1AFC, 0x00000000,
		0x1D0C, 0x00400000,
		0x1D0C, 0x00410000,
		0x1EE8, 0x00000003,
		0xC0C, 0x02F1D8BF,
		0x1D94, 0x40000000,
		0x1D94, 0x40010000,
		0x1D94, 0x40020000,
		0x1D94, 0x40030000,
		0x1D94, 0x40040000,
		0x1D94, 0x40050000,
		0x1D94, 0x40060000,
		0x1D94, 0x40070000,
		0x1D94, 0x40080000,
		0x1D94, 0x40090000,
		0x1D94, 0x400A0000,
		0x1D94, 0x400B0000,
		0x1D94, 0x400C0000,
		0x1D94, 0x400D0000,
		0x1D94, 0x400E0000,
		0x1D94, 0x400F0000,
		0x1D94, 0x40100000,
		0x1D94, 0x40110000,
		0x1D94, 0x40120000,
		0x1D94, 0x40130000,
		0x1D94, 0x40140000,
		0x1D94, 0x40150000,
		0x1D94, 0x40160000,
		0x1D94, 0x40170000,
		0x1D94, 0x40180000,
		0x1D94, 0x40190000,
		0x1D94, 0x401A0000,
		0x1D94, 0x401B0000,
		0x1D94, 0x401C0000,
		0x1D94, 0x401D0000,
		0x1D94, 0x401E0000,
		0x1D94, 0x401F0000,
		0x1D94, 0x40200000,
		0x1D94, 0x40210000,
		0x1D94, 0x40220000,
		0x1D94, 0x40230000,
		0x1D94, 0x40240000,
		0x1D94, 0x40250000,
		0x1D94, 0x40260000,
		0x1D94, 0x40270000,
		0x1D94, 0x40280000,
		0x1D94, 0x40290000,
		0x1D94, 0x402A0000,
		0x1D94, 0x402B0000,
		0x1D94, 0x402C0000,
		0x1D94, 0x402D0000,
		0x1D94, 0x402E0000,
		0x1D94, 0x402F0000,
		0x1D94, 0x40300000,
		0x1D94, 0x40310000,
		0x1D94, 0x40320000,
		0x1D94, 0x40330000,
		0x1D94, 0x40340000,
		0x1D94, 0x40350000,
		0x1D94, 0x40360000,
		0x1D94, 0x40370000,
		0x1D94, 0x40380000,
		0x1D94, 0x40390000,
		0x1D94, 0x403A0000,
		0x1D94, 0x403B0000,
		0x1D94, 0x403C0000,
		0x1D94, 0x403D0000,
		0x1D94, 0x403E0000,
		0x1D94, 0x403F0000,
		0x1D94, 0x40400000,
		0x1D94, 0x40410000,
		0x1D94, 0x40420000,
		0x1D94, 0x40430000,
		0x1D94, 0x40440000,
		0x1D94, 0x40450000,
		0x1D94, 0x40460000,
		0x1D94, 0x40470000,
		0x1D94, 0x40480000,
		0x1D94, 0x40490000,
		0x1D94, 0x404A0000,
		0x1D94, 0x404B0000,
		0x1D94, 0x404C0000,
		0x1D94, 0x404D0000,
		0x1D94, 0x404E0000,
		0x1D94, 0x404F0000,
		0x1D94, 0x40500000,
		0x1D94, 0x40510000,
		0x1D94, 0x40520000,
		0x1D94, 0x40530000,
		0x1D94, 0x40540000,
		0x1D94, 0x40550000,
		0x1D94, 0x40560000,
		0x1D94, 0x40570000,
		0x1D94, 0x40580000,
		0x1D94, 0x40590000,
		0x1D94, 0x405A0000,
		0x1D94, 0x405B0000,
		0x1D94, 0x405C0000,
		0x1D94, 0x405D0000,
		0x1D94, 0x405E0000,
		0x1D94, 0x405F0000,
		0x1D94, 0x40600000,
		0x1D94, 0x40610000,
		0x1D94, 0x40620000,
		0x1D94, 0x40630000,
		0x1D94, 0x40640000,
		0x1D94, 0x40650000,
		0x1D94, 0x40660000,
		0x1D94, 0x40670000,
		0x1D94, 0x40680000,
		0x1D94, 0x40690000,
		0x1D94, 0x406A0000,
		0x1D94, 0x406B0000,
		0x1D94, 0x406C0000,
		0x1D94, 0x406D0000,
		0x1D94, 0x406E0000,
		0x1D94, 0x406F0000,
		0x1D94, 0x40700000,
		0x1D94, 0x40710000,
		0x1D94, 0x40720000,
		0x1D94, 0x40730000,
		0x1D94, 0x40740000,
		0x1D94, 0x40750000,
		0x1D94, 0x40760000,
		0x1D94, 0x40770000,
		0x1D94, 0x40780000,
		0x1D94, 0x40790000,
		0x1D94, 0x407A0000,
		0x1D94, 0x407B0000,
		0x1D94, 0x407C0000,
		0x1D94, 0x407D0000,
		0x1D94, 0x407E0000,
		0x1D94, 0x407F0000,
		0x1D94, 0x40800000,
		0x1D94, 0x40810000,
		0x1D94, 0x40820000,
		0x1D94, 0x40830000,
		0x1D94, 0x40840000,
		0x1D94, 0x40850000,
		0x1D94, 0x40860000,
		0x1D94, 0x40870000,
		0x1D94, 0x40880000,
		0x1D94, 0x40890000,
		0x1D94, 0x408A0000,
		0x1D94, 0x408B0000,
		0x1D94, 0x408C0000,
		0x1D94, 0x408D0000,
		0x1D94, 0x408E0000,
		0x1D94, 0x408F0000,
		0x1D94, 0x40900000,
		0x1D94, 0x40910000,
		0x1D94, 0x40920000,
		0x1D94, 0x40930000,
		0x1D94, 0x40940000,
		0x1D94, 0x40950000,
		0x1D94, 0x40960000,
		0x1D94, 0x40970000,
		0x1D94, 0x40980000,
		0x1D94, 0x40990000,
		0x1D94, 0x409A0000,
		0x1D94, 0x409B0000,
		0x1D94, 0x409C0000,
		0x1D94, 0x409D0000,
		0x1D94, 0x409E0000,
		0x1D94, 0x409F0000,
		0x1D94, 0x40A00000,
		0x1D94, 0x40A10000,
		0x1D94, 0x40A20000,
		0x1D94, 0x40A30000,
		0x1D94, 0x40A40000,
		0x1D94, 0x40A50000,
		0x1D94, 0x40A60000,
		0x1D94, 0x40A70000,
		0x1D94, 0x40A80000,
		0x1D94, 0x40A90000,
		0x1D94, 0x40AA0000,
		0x1D94, 0x40AB0000,
		0x1D94, 0x40AC0000,
		0x1D94, 0x40AD0000,
		0x1D94, 0x40AE0000,
		0x1D94, 0x40AF0000,
		0x1D94, 0x40B00000,
		0x1D94, 0x40B10000,
		0x1D94, 0x40B20000,
		0x1D94, 0x40B30000,
		0x1D94, 0x40B40000,
		0x1D94, 0x40B50000,
		0x1D94, 0x40B60000,
		0x1D94, 0x40B70000,
		0x1D94, 0x40B80000,
		0x1D94, 0x40B90000,
		0x1D94, 0x40BA0000,
		0x1D94, 0x40BB0000,
		0x1D94, 0x40BC0000,
		0x1D94, 0x40BD0000,
		0x1D94, 0x40BE0000,
		0x1D94, 0x40BF0000,
		0x1D94, 0x40C00000,
		0x1D94, 0x40C10000,
		0x1D94, 0x40C20000,
		0x1D94, 0x40C30000,
		0x1D94, 0x40C40000,
		0x1D94, 0x40C50000,
		0x1D94, 0x40C60000,
		0x1D94, 0x40C70000,
		0x1D94, 0x40C80000,
		0x1D94, 0x40C90000,
		0x1D94, 0x40CA0000,
		0x1D94, 0x40CB0000,
		0x1D94, 0x40CC0000,
		0x1D94, 0x40CD0000,
		0x1D94, 0x40CE0000,
		0x1D94, 0x40CF0000,
		0x1D94, 0x40D00000,
		0x1D94, 0x40D10000,
		0x1D94, 0x40D20000,
		0x1D94, 0x40D30000,
		0x1D94, 0x40D40000,
		0x1D94, 0x40D50000,
		0x1D94, 0x40D60000,
		0x1D94, 0x40D70000,
		0x1D94, 0x40D80000,
		0x1D94, 0x40D90000,
		0x1D94, 0x40DA0000,
		0x1D94, 0x40DB0000,
		0x1D94, 0x40DC0000,
		0x1D94, 0x40DD0000,
		0x1D94, 0x40DE0000,
		0x1D94, 0x40DF0000,
		0x1D94, 0x40E00000,
		0x1D94, 0x40E10000,
		0x1D94, 0x40E20000,
		0x1D94, 0x40E30000,
		0x1D94, 0x40E40000,
		0x1D94, 0x40E50000,
		0x1D94, 0x40E60000,
		0x1D94, 0x40E70000,
		0x1D94, 0x40E80000,
		0x1D94, 0x40E90000,
		0x1D94, 0x40EA0000,
		0x1D94, 0x40EB0000,
		0x1D94, 0x40EC0000,
		0x1D94, 0x40ED0000,
		0x1D94, 0x40EE0000,
		0x1D94, 0x40EF0000,
		0x1D94, 0x40F00000,
		0x1D94, 0x40F10000,
		0x1D94, 0x40F20000,
		0x1D94, 0x40F30000,
		0x1D94, 0x40F40000,
		0x1D94, 0x40F50000,
		0x1D94, 0x40F60000,
		0x1D94, 0x40F70000,
		0x1D94, 0x40F80000,
		0x1D94, 0x40F90000,
		0x1D94, 0x40FA0000,
		0x1D94, 0x40FB0000,
		0x1D94, 0x40FC0000,
		0x1D94, 0x40FD0000,
		0x1D94, 0x40FE0000,
		0x1D94, 0x40FF0000,
		0xC0C, 0x02F1D8B7,
		0x1EE8, 0x00000000,

};

void
odm_read_and_config_mp_8197g_phy_reg(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len =
			sizeof(array_mp_8197g_phy_reg) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8197g_phy_reg;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_bb_phy_8197g(dm, v1, MASKDWORD, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8197g_phy_reg(void)
{
		return 18;
}

/******************************************************************************
 *                           phy_reg_pg.TXT
 ******************************************************************************/

#ifdef CONFIG_8197G
const u32 array_mp_8197g_phy_reg_pg[] = {
	0, 0, 0, 0x00003a00, 0xffffffff, 0x46464646,
	0, 0, 0, 0x00003a04, 0xffffffff, 0x44464646,
	0, 0, 0, 0x00003a08, 0xffffffff, 0x40424244,
	0, 0, 0, 0x00003a0c, 0xffffffff, 0x42444446,
	0, 0, 0, 0x00003a10, 0xffffffff, 0x38404042,
	0, 0, 1, 0x00003a14, 0xffffffff, 0x42444446,
	0, 0, 1, 0x00003a18, 0xffffffff, 0x38404042,
	0, 0, 2, 0x00003a1c, 0xffffffff, 0x38383838,
	0, 0, 2, 0x00003a20, 0xffffffff, 0x38383838,
	0, 0, 3, 0x00003a24, 0xffffffff, 0x38383838,
	0, 0, 3, 0x00003a28, 0xffffffff, 0x38383838,
	0, 0, 0, 0x00003a2c, 0xffffffff, 0x38383838,
	0, 0, 0, 0x00003a30, 0xffffffff, 0x38383838,
	0, 0, 0, 0x00003a34, 0xffffffff, 0x38383838,
	0, 0, 1, 0x00003a38, 0xffffffff, 0x38383838,
	0, 0, 1, 0x00003a3c, 0xffffffff, 0x38383838,
	0, 0, 2, 0x00003a40, 0xffffffff, 0x38383838,
	0, 0, 2, 0x00003a44, 0xffffffff, 0x38383838,
	0, 0, 2, 0x00003a48, 0xffffffff, 0x38383838,
	0, 0, 3, 0x00003a4c, 0xffffffff, 0x38383838,
	0, 0, 3, 0x00003a50, 0xffffffff, 0x38383838
};

#endif

void
odm_read_and_config_mp_8197g_phy_reg_pg(struct dm_struct *dm)
{
#ifdef CONFIG_8197G

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8197g_phy_reg_pg) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8197g_phy_reg_pg;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8197g(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_8197gmp_type0.TXT
 ******************************************************************************/

#ifdef CONFIG_8197G_8197GMP_TYPE0
const u32 array_mp_8197g_phy_reg_pg_8197gmp_type0[] = {
	0, 0, 0, 0x00003a00, 0xffffffff, 0x46464646,
	0, 0, 0, 0x00003a04, 0xffffffff, 0x44464646,
	0, 0, 0, 0x00003a08, 0xffffffff, 0x40424244,
	0, 0, 0, 0x00003a0c, 0xffffffff, 0x42444446,
	0, 0, 0, 0x00003a10, 0xffffffff, 0x38404042,
	0, 0, 1, 0x00003a14, 0xffffffff, 0x42444446,
	0, 0, 1, 0x00003a18, 0xffffffff, 0x38404042,
	0, 0, 2, 0x00003a1c, 0xffffffff, 0x38383838,
	0, 0, 2, 0x00003a20, 0xffffffff, 0x38383838,
	0, 0, 3, 0x00003a24, 0xffffffff, 0x38383838,
	0, 0, 3, 0x00003a28, 0xffffffff, 0x38383838,
	0, 0, 0, 0x00003a2c, 0xffffffff, 0x38383838,
	0, 0, 0, 0x00003a30, 0xffffffff, 0x38383838,
	0, 0, 0, 0x00003a34, 0xffffffff, 0x38383838,
	0, 0, 1, 0x00003a38, 0xffffffff, 0x38383838,
	0, 0, 1, 0x00003a3c, 0xffffffff, 0x38383838,
	0, 0, 2, 0x00003a40, 0xffffffff, 0x38383838,
	0, 0, 2, 0x00003a44, 0xffffffff, 0x38383838,
	0, 0, 2, 0x00003a48, 0xffffffff, 0x38383838,
	0, 0, 3, 0x00003a4c, 0xffffffff, 0x38383838,
	0, 0, 3, 0x00003a50, 0xffffffff, 0x38383838
};

#endif

void
odm_read_and_config_mp_8197g_phy_reg_pg_8197gmp_type0(struct dm_struct *dm)
{
#ifdef CONFIG_8197G_8197GMP_TYPE0

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8197g_phy_reg_pg_8197gmp_type0) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8197g_phy_reg_pg_8197gmp_type0;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8197g(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_8197gmp_type1.TXT
 ******************************************************************************/

#ifdef CONFIG_8197G_8197GMP_TYPE1
const u32 array_mp_8197g_phy_reg_pg_8197gmp_type1[] = {
	0, 0, 0, 0x00003a00, 0xffffffff, 0x46464646,
	0, 0, 0, 0x00003a04, 0xffffffff, 0x44464646,
	0, 0, 0, 0x00003a08, 0xffffffff, 0x40424244,
	0, 0, 0, 0x00003a0c, 0xffffffff, 0x42444446,
	0, 0, 0, 0x00003a10, 0xffffffff, 0x38404042,
	0, 0, 1, 0x00003a14, 0xffffffff, 0x42444446,
	0, 0, 1, 0x00003a18, 0xffffffff, 0x38404042,
	0, 0, 2, 0x00003a1c, 0xffffffff, 0x38383838,
	0, 0, 2, 0x00003a20, 0xffffffff, 0x38383838,
	0, 0, 3, 0x00003a24, 0xffffffff, 0x38383838,
	0, 0, 3, 0x00003a28, 0xffffffff, 0x38383838,
	0, 0, 0, 0x00003a2c, 0xffffffff, 0x38383838,
	0, 0, 0, 0x00003a30, 0xffffffff, 0x38383838,
	0, 0, 0, 0x00003a34, 0xffffffff, 0x38383838,
	0, 0, 1, 0x00003a38, 0xffffffff, 0x38383838,
	0, 0, 1, 0x00003a3c, 0xffffffff, 0x38383838,
	0, 0, 2, 0x00003a40, 0xffffffff, 0x38383838,
	0, 0, 2, 0x00003a44, 0xffffffff, 0x38383838,
	0, 0, 2, 0x00003a48, 0xffffffff, 0x38383838,
	0, 0, 3, 0x00003a4c, 0xffffffff, 0x38383838,
	0, 0, 3, 0x00003a50, 0xffffffff, 0x38383838
};

#endif

void
odm_read_and_config_mp_8197g_phy_reg_pg_8197gmp_type1(struct dm_struct *dm)
{
#ifdef CONFIG_8197G_8197GMP_TYPE1

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8197g_phy_reg_pg_8197gmp_type1) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8197g_phy_reg_pg_8197gmp_type1;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8197g(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_8197gmp_type2.TXT
 ******************************************************************************/

#ifdef CONFIG_8197G_8197GMP_TYPE2
const u32 array_mp_8197g_phy_reg_pg_8197gmp_type2[] = {
	0, 0, 0, 0x00003a00, 0xffffffff, 0x46464646,
	0, 0, 0, 0x00003a04, 0xffffffff, 0x44464646,
	0, 0, 0, 0x00003a08, 0xffffffff, 0x40424244,
	0, 0, 0, 0x00003a0c, 0xffffffff, 0x42444446,
	0, 0, 0, 0x00003a10, 0xffffffff, 0x38404042,
	0, 0, 1, 0x00003a14, 0xffffffff, 0x42444446,
	0, 0, 1, 0x00003a18, 0xffffffff, 0x38404042,
	0, 0, 2, 0x00003a1c, 0xffffffff, 0x38383838,
	0, 0, 2, 0x00003a20, 0xffffffff, 0x38383838,
	0, 0, 3, 0x00003a24, 0xffffffff, 0x38383838,
	0, 0, 3, 0x00003a28, 0xffffffff, 0x38383838,
	0, 0, 0, 0x00003a2c, 0xffffffff, 0x38383838,
	0, 0, 0, 0x00003a30, 0xffffffff, 0x38383838,
	0, 0, 0, 0x00003a34, 0xffffffff, 0x38383838,
	0, 0, 1, 0x00003a38, 0xffffffff, 0x38383838,
	0, 0, 1, 0x00003a3c, 0xffffffff, 0x38383838,
	0, 0, 2, 0x00003a40, 0xffffffff, 0x38383838,
	0, 0, 2, 0x00003a44, 0xffffffff, 0x38383838,
	0, 0, 2, 0x00003a48, 0xffffffff, 0x38383838,
	0, 0, 3, 0x00003a4c, 0xffffffff, 0x38383838,
	0, 0, 3, 0x00003a50, 0xffffffff, 0x38383838
};

#endif

void
odm_read_and_config_mp_8197g_phy_reg_pg_8197gmp_type2(struct dm_struct *dm)
{
#ifdef CONFIG_8197G_8197GMP_TYPE2

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8197g_phy_reg_pg_8197gmp_type2) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8197g_phy_reg_pg_8197gmp_type2;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8197g(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_8197gmp_type3.TXT
 ******************************************************************************/

#ifdef CONFIG_8197G_8197GMP_TYPE3
const u32 array_mp_8197g_phy_reg_pg_8197gmp_type3[] = {
	0, 0, 0, 0x00003a00, 0xffffffff, 0x46464646,
	0, 0, 0, 0x00003a04, 0xffffffff, 0x44464646,
	0, 0, 0, 0x00003a08, 0xffffffff, 0x40424244,
	0, 0, 0, 0x00003a0c, 0xffffffff, 0x42444446,
	0, 0, 0, 0x00003a10, 0xffffffff, 0x38404042,
	0, 0, 1, 0x00003a14, 0xffffffff, 0x42444446,
	0, 0, 1, 0x00003a18, 0xffffffff, 0x38404042,
	0, 0, 2, 0x00003a1c, 0xffffffff, 0x38383838,
	0, 0, 2, 0x00003a20, 0xffffffff, 0x38383838,
	0, 0, 3, 0x00003a24, 0xffffffff, 0x38383838,
	0, 0, 3, 0x00003a28, 0xffffffff, 0x38383838,
	0, 0, 0, 0x00003a2c, 0xffffffff, 0x38383838,
	0, 0, 0, 0x00003a30, 0xffffffff, 0x38383838,
	0, 0, 0, 0x00003a34, 0xffffffff, 0x38383838,
	0, 0, 1, 0x00003a38, 0xffffffff, 0x38383838,
	0, 0, 1, 0x00003a3c, 0xffffffff, 0x38383838,
	0, 0, 2, 0x00003a40, 0xffffffff, 0x38383838,
	0, 0, 2, 0x00003a44, 0xffffffff, 0x38383838,
	0, 0, 2, 0x00003a48, 0xffffffff, 0x38383838,
	0, 0, 3, 0x00003a4c, 0xffffffff, 0x38383838,
	0, 0, 3, 0x00003a50, 0xffffffff, 0x38383838
};

#endif

void
odm_read_and_config_mp_8197g_phy_reg_pg_8197gmp_type3(struct dm_struct *dm)
{
#ifdef CONFIG_8197G_8197GMP_TYPE3

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8197g_phy_reg_pg_8197gmp_type3) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8197g_phy_reg_pg_8197gmp_type3;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8197g(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_8197gmp_type4.TXT
 ******************************************************************************/

#ifdef CONFIG_8197G_8197GMP_TYPE4
const u32 array_mp_8197g_phy_reg_pg_8197gmp_type4[] = {
	0, 0, 0, 0x00003a00, 0xffffffff, 0x46464646,
	0, 0, 0, 0x00003a04, 0xffffffff, 0x44464646,
	0, 0, 0, 0x00003a08, 0xffffffff, 0x40424244,
	0, 0, 0, 0x00003a0c, 0xffffffff, 0x42444446,
	0, 0, 0, 0x00003a10, 0xffffffff, 0x38404042,
	0, 0, 1, 0x00003a14, 0xffffffff, 0x42444446,
	0, 0, 1, 0x00003a18, 0xffffffff, 0x38404042,
	0, 0, 2, 0x00003a1c, 0xffffffff, 0x38383838,
	0, 0, 2, 0x00003a20, 0xffffffff, 0x38383838,
	0, 0, 3, 0x00003a24, 0xffffffff, 0x38383838,
	0, 0, 3, 0x00003a28, 0xffffffff, 0x38383838,
	0, 0, 0, 0x00003a2c, 0xffffffff, 0x38383838,
	0, 0, 0, 0x00003a30, 0xffffffff, 0x38383838,
	0, 0, 0, 0x00003a34, 0xffffffff, 0x38383838,
	0, 0, 1, 0x00003a38, 0xffffffff, 0x38383838,
	0, 0, 1, 0x00003a3c, 0xffffffff, 0x38383838,
	0, 0, 2, 0x00003a40, 0xffffffff, 0x38383838,
	0, 0, 2, 0x00003a44, 0xffffffff, 0x38383838,
	0, 0, 2, 0x00003a48, 0xffffffff, 0x38383838,
	0, 0, 3, 0x00003a4c, 0xffffffff, 0x38383838,
	0, 0, 3, 0x00003a50, 0xffffffff, 0x38383838
};

#endif

void
odm_read_and_config_mp_8197g_phy_reg_pg_8197gmp_type4(struct dm_struct *dm)
{
#ifdef CONFIG_8197G_8197GMP_TYPE4

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8197g_phy_reg_pg_8197gmp_type4) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8197g_phy_reg_pg_8197gmp_type4;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8197g(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_8197gmp_type5.TXT
 ******************************************************************************/

#ifdef CONFIG_8197G_8197GMP_TYPE5
const u32 array_mp_8197g_phy_reg_pg_8197gmp_type5[] = {
	0, 0, 0, 0x00003a00, 0xffffffff, 0x46464646,
	0, 0, 0, 0x00003a04, 0xffffffff, 0x44464646,
	0, 0, 0, 0x00003a08, 0xffffffff, 0x40424244,
	0, 0, 0, 0x00003a0c, 0xffffffff, 0x42444446,
	0, 0, 0, 0x00003a10, 0xffffffff, 0x38404042,
	0, 0, 1, 0x00003a14, 0xffffffff, 0x42444446,
	0, 0, 1, 0x00003a18, 0xffffffff, 0x38404042,
	0, 0, 2, 0x00003a1c, 0xffffffff, 0x38383838,
	0, 0, 2, 0x00003a20, 0xffffffff, 0x38383838,
	0, 0, 3, 0x00003a24, 0xffffffff, 0x38383838,
	0, 0, 3, 0x00003a28, 0xffffffff, 0x38383838,
	0, 0, 0, 0x00003a2c, 0xffffffff, 0x38383838,
	0, 0, 0, 0x00003a30, 0xffffffff, 0x38383838,
	0, 0, 0, 0x00003a34, 0xffffffff, 0x38383838,
	0, 0, 1, 0x00003a38, 0xffffffff, 0x38383838,
	0, 0, 1, 0x00003a3c, 0xffffffff, 0x38383838,
	0, 0, 2, 0x00003a40, 0xffffffff, 0x38383838,
	0, 0, 2, 0x00003a44, 0xffffffff, 0x38383838,
	0, 0, 2, 0x00003a48, 0xffffffff, 0x38383838,
	0, 0, 3, 0x00003a4c, 0xffffffff, 0x38383838,
	0, 0, 3, 0x00003a50, 0xffffffff, 0x38383838
};

#endif

void
odm_read_and_config_mp_8197g_phy_reg_pg_8197gmp_type5(struct dm_struct *dm)
{
#ifdef CONFIG_8197G_8197GMP_TYPE5

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8197g_phy_reg_pg_8197gmp_type5) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8197g_phy_reg_pg_8197gmp_type5;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8197g(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_8197gmp_type6.TXT
 ******************************************************************************/

#ifdef CONFIG_8197G_8197GMP_TYPE6
const u32 array_mp_8197g_phy_reg_pg_8197gmp_type6[] = {
	0, 0, 0, 0x00003a00, 0xffffffff, 0x46464646,
	0, 0, 0, 0x00003a04, 0xffffffff, 0x44464646,
	0, 0, 0, 0x00003a08, 0xffffffff, 0x40424244,
	0, 0, 0, 0x00003a0c, 0xffffffff, 0x42444446,
	0, 0, 0, 0x00003a10, 0xffffffff, 0x38404042,
	0, 0, 1, 0x00003a14, 0xffffffff, 0x42444446,
	0, 0, 1, 0x00003a18, 0xffffffff, 0x38404042,
	0, 0, 2, 0x00003a1c, 0xffffffff, 0x38383838,
	0, 0, 2, 0x00003a20, 0xffffffff, 0x38383838,
	0, 0, 3, 0x00003a24, 0xffffffff, 0x38383838,
	0, 0, 3, 0x00003a28, 0xffffffff, 0x38383838,
	0, 0, 0, 0x00003a2c, 0xffffffff, 0x38383838,
	0, 0, 0, 0x00003a30, 0xffffffff, 0x38383838,
	0, 0, 0, 0x00003a34, 0xffffffff, 0x38383838,
	0, 0, 1, 0x00003a38, 0xffffffff, 0x38383838,
	0, 0, 1, 0x00003a3c, 0xffffffff, 0x38383838,
	0, 0, 2, 0x00003a40, 0xffffffff, 0x38383838,
	0, 0, 2, 0x00003a44, 0xffffffff, 0x38383838,
	0, 0, 2, 0x00003a48, 0xffffffff, 0x38383838,
	0, 0, 3, 0x00003a4c, 0xffffffff, 0x38383838,
	0, 0, 3, 0x00003a50, 0xffffffff, 0x38383838
};

#endif

void
odm_read_and_config_mp_8197g_phy_reg_pg_8197gmp_type6(struct dm_struct *dm)
{
#ifdef CONFIG_8197G_8197GMP_TYPE6

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8197g_phy_reg_pg_8197gmp_type6) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8197g_phy_reg_pg_8197gmp_type6;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8197g(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

#endif /* end of HWIMG_SUPPORT*/

