/******************************************************************************
 *
 * Copyright(c) 2007 - 2017 Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * The full GNU General Public License is included in this distribution in the
 * file called LICENSE.
 *
 * Contact Information:
 * wlanfae <wlanfae@realtek.com>
 * Realtek Corporation, No. 2, Innovation Road II, Hsinchu Science Park,
 * Hsinchu 300, Taiwan.
 *
 * Larry Finger <Larry.Finger@lwfinger.net>
 *
 *****************************************************************************/

/*Image2HeaderVersion: R3 1.5.11*/
#include "mp_precomp.h"
#include "../phydm_precomp.h"

#if (RTL8723F_SUPPORT == 1)
static boolean
check_positive(struct dm_struct *dm,
	       const u32	condition1,
	       const u32	condition2,
	       const u32	condition3,
	       const u32	condition4
)
{
	u32	cond1 = condition1, cond2 = condition2,
		cond3 = condition3, cond4 = condition4;

	u8	cut_version_for_para =
		(dm->cut_version ==  ODM_CUT_A) ? 15 : dm->cut_version;

	u8	pkg_type_for_para =
		(dm->package_type == 0) ? 15 : dm->package_type;

	u32	driver1 = cut_version_for_para << 24 |
			(dm->support_interface & 0xF0) << 16 |
			dm->support_platform << 16 |
			pkg_type_for_para << 12 |
			(dm->support_interface & 0x0F) << 8  |
			dm->rfe_type;

	u32	driver2 = (dm->type_glna & 0xFF) <<  0 |
			(dm->type_gpa & 0xFF)  <<  8 |
			(dm->type_alna & 0xFF) << 16 |
			(dm->type_apa & 0xFF)  << 24;

	u32	driver3 = 0;

	u32	driver4 = (dm->type_glna & 0xFF00) >>  8 |
			(dm->type_gpa & 0xFF00) |
			(dm->type_alna & 0xFF00) << 8 |
			(dm->type_apa & 0xFF00)  << 16;

	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "===> %s (cond1, cond2, cond3, cond4) = (0x%X 0x%X 0x%X 0x%X)\n",
		  __func__, cond1, cond2, cond3, cond4);
	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "===> %s (driver1, driver2, driver3, driver4) = (0x%X 0x%X 0x%X 0x%X)\n",
		  __func__, driver1, driver2, driver3, driver4);

	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "	(Platform, Interface) = (0x%X, 0x%X)\n",
		  dm->support_platform, dm->support_interface);
	PHYDM_DBG(dm, ODM_COMP_INIT, "	(RFE, Package) = (0x%X, 0x%X)\n",
		  dm->rfe_type, dm->package_type);

	/*============== value Defined Check ===============*/
	/*cut version [27:24] need to do value check*/
	if (((cond1 & 0x0F000000) != 0) &&
	    ((cond1 & 0x0F000000) != (driver1 & 0x0F000000)))
		return false;

	/*pkg type [15:12] need to do value check*/
	if (((cond1 & 0x0000F000) != 0) &&
	    ((cond1 & 0x0000F000) != (driver1 & 0x0000F000)))
		return false;

	/*interface [11:8] need to do value check*/
	if (((cond1 & 0x00000F00) != 0) &&
	    ((cond1 & 0x00000F00) != (driver1 & 0x00000F00)))
		return false;
	/*=============== Bit Defined Check ================*/
	/* We don't care [31:28] */

	cond1 &= 0x000000FF;
	driver1 &= 0x000000FF;

	if (cond1 == driver1)
		return true;
	else
		return false;
}


/******************************************************************************
 *                           agc_tab.TXT
 ******************************************************************************/

const u32 array_mp_8723f_agc_tab[] = {
		0x1D90, 0x300000FF,
		0x1D90, 0x300100FF,
		0x1D90, 0x300200FF,
		0x1D90, 0x300300FF,
		0x1D90, 0x300400FF,
		0x1D90, 0x300500FE,
		0x1D90, 0x300600FD,
		0x1D90, 0x300700FC,
		0x1D90, 0x300800FB,
		0x1D90, 0x300900FA,
		0x1D90, 0x300A00F9,
		0x1D90, 0x300B00F8,
		0x1D90, 0x300C00F7,
		0x1D90, 0x300D00F6,
		0x1D90, 0x300E00F5,
		0x1D90, 0x300F00F4,
		0x1D90, 0x301000F3,
		0x1D90, 0x301100F2,
		0x1D90, 0x301200F1,
		0x1D90, 0x301300F0,
		0x1D90, 0x301400E9,
		0x1D90, 0x301500E8,
		0x1D90, 0x301600E7,
		0x1D90, 0x301700E6,
		0x1D90, 0x301800E5,
		0x1D90, 0x301900E4,
		0x1D90, 0x301A00E3,
		0x1D90, 0x301B00C5,
		0x1D90, 0x301C00C4,
		0x1D90, 0x301D00C3,
		0x1D90, 0x301E00C2,
		0x1D90, 0x301F00C1,
		0x1D90, 0x302000C0,
		0x1D90, 0x302100A4,
		0x1D90, 0x302200A3,
		0x1D90, 0x302300A2,
		0x1D90, 0x302400A1,
		0x1D90, 0x302500A0,
		0x1D90, 0x30260083,
		0x1D90, 0x30270082,
		0x1D90, 0x30280081,
		0x1D90, 0x30290080,
		0x1D90, 0x302A0064,
		0x1D90, 0x302B0063,
		0x1D90, 0x302C0062,
		0x1D90, 0x302D0061,
		0x1D90, 0x302E0060,
		0x1D90, 0x302F0042,
		0x1D90, 0x30300041,
		0x1D90, 0x30310040,
		0x1D90, 0x30320022,
		0x1D90, 0x30330021,
		0x1D90, 0x30340020,
		0x1D90, 0x30350002,
		0x1D90, 0x30360001,
		0x1D90, 0x30370000,
		0x1D90, 0x30380000,
		0x1D90, 0x30390000,
		0x1D90, 0x303A0000,
		0x1D90, 0x303B0000,
		0x1D90, 0x303C0000,
		0x1D90, 0x303D0000,
		0x1D90, 0x303E0000,
		0x1D90, 0x303F0000,
		0x1D90, 0x304000FF,
		0x1D90, 0x304100FF,
		0x1D90, 0x304200FF,
		0x1D90, 0x304300FF,
		0x1D90, 0x304400FF,
		0x1D90, 0x304500FE,
		0x1D90, 0x304600FD,
		0x1D90, 0x304700FC,
		0x1D90, 0x304800FB,
		0x1D90, 0x304900FA,
		0x1D90, 0x304A00F9,
		0x1D90, 0x304B00F8,
		0x1D90, 0x304C00F7,
		0x1D90, 0x304D00F6,
		0x1D90, 0x304E00F5,
		0x1D90, 0x304F00F4,
		0x1D90, 0x305000F3,
		0x1D90, 0x305100F2,
		0x1D90, 0x305200F1,
		0x1D90, 0x305300F0,
		0x1D90, 0x305400E9,
		0x1D90, 0x305500E8,
		0x1D90, 0x305600E7,
		0x1D90, 0x305700E6,
		0x1D90, 0x305800E5,
		0x1D90, 0x305900E4,
		0x1D90, 0x305A00E3,
		0x1D90, 0x305B00C9,
		0x1D90, 0x305C00C8,
		0x1D90, 0x305D00C7,
		0x1D90, 0x305E00C6,
		0x1D90, 0x305F00C5,
		0x1D90, 0x306000C4,
		0x1D90, 0x306100A6,
		0x1D90, 0x306200A5,
		0x1D90, 0x306300A4,
		0x1D90, 0x306400A3,
		0x1D90, 0x306500A2,
		0x1D90, 0x306600A1,
		0x1D90, 0x306700A0,
		0x1D90, 0x30680067,
		0x1D90, 0x30690066,
		0x1D90, 0x306A0065,
		0x1D90, 0x306B0064,
		0x1D90, 0x306C0063,
		0x1D90, 0x306D0062,
		0x1D90, 0x306E0061,
		0x1D90, 0x306F0060,
		0x1D90, 0x30700043,
		0x1D90, 0x30710042,
		0x1D90, 0x30720041,
		0x1D90, 0x30730040,
		0x1D90, 0x30740006,
		0x1D90, 0x30750005,
		0x1D90, 0x30760004,
		0x1D90, 0x30770003,
		0x1D90, 0x30780002,
		0x1D90, 0x30790001,
		0x1D90, 0x307A0000,
		0x1D90, 0x307B0000,
		0x1D90, 0x307C0000,
		0x1D90, 0x307D0000,
		0x1D90, 0x307E0000,
		0x1D90, 0x307F0000,
		0x1D90, 0x308000FF,
		0x1D90, 0x308100FF,
		0x1D90, 0x308200FF,
		0x1D90, 0x308300FF,
		0x1D90, 0x308400FE,
		0x1D90, 0x308500FD,
		0x1D90, 0x308600FC,
		0x1D90, 0x308700FB,
		0x1D90, 0x308800FA,
		0x1D90, 0x308900F9,
		0x1D90, 0x308A00F8,
		0x1D90, 0x308B00F7,
		0x1D90, 0x308C00F6,
		0x1D90, 0x308D00F5,
		0x1D90, 0x308E00F4,
		0x1D90, 0x308F00F3,
		0x1D90, 0x309000F2,
		0x1D90, 0x309100F1,
		0x1D90, 0x309200F0,
		0x1D90, 0x309300E9,
		0x1D90, 0x309400E8,
		0x1D90, 0x309500E7,
		0x1D90, 0x309600E6,
		0x1D90, 0x309700E5,
		0x1D90, 0x309800E4,
		0x1D90, 0x309900E3,
		0x1D90, 0x309A00C9,
		0x1D90, 0x309B00C8,
		0x1D90, 0x309C00C7,
		0x1D90, 0x309D00C6,
		0x1D90, 0x309E00C5,
		0x1D90, 0x309F00C4,
		0x1D90, 0x30A000C3,
		0x1D90, 0x30A100C2,
		0x1D90, 0x30A200C1,
		0x1D90, 0x30A300C0,
		0x1D90, 0x30A40087,
		0x1D90, 0x30A50086,
		0x1D90, 0x30A60085,
		0x1D90, 0x30A70068,
		0x1D90, 0x30A80067,
		0x1D90, 0x30A90066,
		0x1D90, 0x30AA0065,
		0x1D90, 0x30AB0064,
		0x1D90, 0x30AC0063,
		0x1D90, 0x30AD0062,
		0x1D90, 0x30AE0061,
		0x1D90, 0x30AF0060,
		0x1D90, 0x30B00043,
		0x1D90, 0x30B10042,
		0x1D90, 0x30B20041,
		0x1D90, 0x30B30040,
		0x1D90, 0x30B40024,
		0x1D90, 0x30B50023,
		0x1D90, 0x30B60022,
		0x1D90, 0x30B70021,
		0x1D90, 0x30B80020,
		0x1D90, 0x30B90020,
		0x1D90, 0x30BA0020,
		0x1D90, 0x30BB0020,
		0x1D90, 0x30BC0020,
		0x1D90, 0x30BD0020,
		0x1D90, 0x30BE0020,
		0x1D90, 0x30BF0020,
		0x1D90, 0x30C000FF,
		0x1D90, 0x30C100FF,
		0x1D90, 0x30C200FF,
		0x1D90, 0x30C300FF,
		0x1D90, 0x30C400FE,
		0x1D90, 0x30C500FD,
		0x1D90, 0x30C600FC,
		0x1D90, 0x30C700FB,
		0x1D90, 0x30C800FA,
		0x1D90, 0x30C900F9,
		0x1D90, 0x30CA00F8,
		0x1D90, 0x30CB00F7,
		0x1D90, 0x30CC00F6,
		0x1D90, 0x30CD00F5,
		0x1D90, 0x30CE00F4,
		0x1D90, 0x30CF00F3,
		0x1D90, 0x30D000F2,
		0x1D90, 0x30D100F1,
		0x1D90, 0x30D200F0,
		0x1D90, 0x30D300E9,
		0x1D90, 0x30D400E8,
		0x1D90, 0x30D500E7,
		0x1D90, 0x30D600E6,
		0x1D90, 0x30D700E5,
		0x1D90, 0x30D800E4,
		0x1D90, 0x30D900E3,
		0x1D90, 0x30DA00E2,
		0x1D90, 0x30DB00E1,
		0x1D90, 0x30DC00E0,
		0x1D90, 0x30DD00C7,
		0x1D90, 0x30DE00C6,
		0x1D90, 0x30DF00C5,
		0x1D90, 0x30E000C4,
		0x1D90, 0x30E100C3,
		0x1D90, 0x30E20089,
		0x1D90, 0x30E30088,
		0x1D90, 0x30E40087,
		0x1D90, 0x30E50086,
		0x1D90, 0x30E60085,
		0x1D90, 0x30E70084,
		0x1D90, 0x30E80083,
		0x1D90, 0x30E90066,
		0x1D90, 0x30EA0065,
		0x1D90, 0x30EB0064,
		0x1D90, 0x30EC0063,
		0x1D90, 0x30ED0046,
		0x1D90, 0x30EE0045,
		0x1D90, 0x30EF0044,
		0x1D90, 0x30F00043,
		0x1D90, 0x30F10042,
		0x1D90, 0x30F20041,
		0x1D90, 0x30F30040,
		0x1D90, 0x30F40024,
		0x1D90, 0x30F50023,
		0x1D90, 0x30F60022,
		0x1D90, 0x30F70021,
		0x1D90, 0x30F80020,
		0x1D90, 0x30F90020,
		0x1D90, 0x30FA0020,
		0x1D90, 0x30FB0020,
		0x1D90, 0x30FC0020,
		0x1D90, 0x30FD0020,
		0x1D90, 0x30FE0020,
		0x1D90, 0x30FF0020,
		0x1D90, 0x310000FF,
		0x1D90, 0x310100FF,
		0x1D90, 0x310200FF,
		0x1D90, 0x310300FF,
		0x1D90, 0x310400FE,
		0x1D90, 0x310500FD,
		0x1D90, 0x310600FC,
		0x1D90, 0x310700FB,
		0x1D90, 0x310800FA,
		0x1D90, 0x310900F9,
		0x1D90, 0x310A00F8,
		0x1D90, 0x310B00F7,
		0x1D90, 0x310C00F6,
		0x1D90, 0x310D00F5,
		0x1D90, 0x310E00F4,
		0x1D90, 0x310F00F3,
		0x1D90, 0x311000F2,
		0x1D90, 0x311100F1,
		0x1D90, 0x311200F0,
		0x1D90, 0x311300E9,
		0x1D90, 0x311400E8,
		0x1D90, 0x311500E7,
		0x1D90, 0x311600E6,
		0x1D90, 0x311700E5,
		0x1D90, 0x311800E4,
		0x1D90, 0x311900E3,
		0x1D90, 0x311A00C5,
		0x1D90, 0x311B00C4,
		0x1D90, 0x311C00C3,
		0x1D90, 0x311D00C2,
		0x1D90, 0x311E00C1,
		0x1D90, 0x311F00C0,
		0x1D90, 0x312000A4,
		0x1D90, 0x312100A3,
		0x1D90, 0x312200A2,
		0x1D90, 0x312300A1,
		0x1D90, 0x31240083,
		0x1D90, 0x31250082,
		0x1D90, 0x31260081,
		0x1D90, 0x31270080,
		0x1D90, 0x31280065,
		0x1D90, 0x31290064,
		0x1D90, 0x312A0063,
		0x1D90, 0x312B0062,
		0x1D90, 0x312C0061,
		0x1D90, 0x312D0060,
		0x1D90, 0x312E0043,
		0x1D90, 0x312F0042,
		0x1D90, 0x31300041,
		0x1D90, 0x31310040,
		0x1D90, 0x31320022,
		0x1D90, 0x31330021,
		0x1D90, 0x31340020,
		0x1D90, 0x31350002,
		0x1D90, 0x31360001,
		0x1D90, 0x31370000,
		0x1D90, 0x31380000,
		0x1D90, 0x31390000,
		0x1D90, 0x313A0000,
		0x1D90, 0x313B0000,
		0x1D90, 0x313C0000,
		0x1D90, 0x313D0000,
		0x1D90, 0x313E0000,
		0x1D90, 0x313F0000,
		0x1D90, 0x314000FF,
		0x1D90, 0x314100FF,
		0x1D90, 0x314200FF,
		0x1D90, 0x314300FF,
		0x1D90, 0x314400FF,
		0x1D90, 0x314500FE,
		0x1D90, 0x314600FD,
		0x1D90, 0x314700FC,
		0x1D90, 0x314800FB,
		0x1D90, 0x314900FA,
		0x1D90, 0x314A00F9,
		0x1D90, 0x314B00F8,
		0x1D90, 0x314C00F7,
		0x1D90, 0x314D00F6,
		0x1D90, 0x314E00F5,
		0x1D90, 0x314F00D7,
		0x1D90, 0x315000D6,
		0x1D90, 0x315100D5,
		0x1D90, 0x315200B9,
		0x1D90, 0x315300B8,
		0x1D90, 0x315400B7,
		0x1D90, 0x315500B6,
		0x1D90, 0x315600B5,
		0x1D90, 0x315700B4,
		0x1D90, 0x315800B3,
		0x1D90, 0x315900B2,
		0x1D90, 0x315A00B1,
		0x1D90, 0x315B00B0,
		0x1D90, 0x315C00A9,
		0x1D90, 0x315D00A8,
		0x1D90, 0x315E00A7,
		0x1D90, 0x315F00A6,
		0x1D90, 0x316000A5,
		0x1D90, 0x316100A4,
		0x1D90, 0x316200A3,
		0x1D90, 0x316300A2,
		0x1D90, 0x316400A1,
		0x1D90, 0x316500A0,
		0x1D90, 0x31660083,
		0x1D90, 0x31670082,
		0x1D90, 0x31680081,
		0x1D90, 0x31690080,
		0x1D90, 0x316A0064,
		0x1D90, 0x316B0063,
		0x1D90, 0x316C0062,
		0x1D90, 0x316D0061,
		0x1D90, 0x316E0060,
		0x1D90, 0x316F0042,
		0x1D90, 0x31700041,
		0x1D90, 0x31710040,
		0x1D90, 0x31720022,
		0x1D90, 0x31730021,
		0x1D90, 0x31740020,
		0x1D90, 0x31750002,
		0x1D90, 0x31760001,
		0x1D90, 0x31770000,
		0x1D90, 0x31780000,
		0x1D90, 0x31790000,
		0x1D90, 0x317A0000,
		0x1D90, 0x317B0000,
		0x1D90, 0x317C0000,
		0x1D90, 0x317D0000,
		0x1D90, 0x317E0000,
		0x1D90, 0x317F0000,
		0x1D90, 0x318000FF,
		0x1D90, 0x318100FF,
		0x1D90, 0x318200FF,
		0x1D90, 0x318300FF,
		0x1D90, 0x318400FF,
		0x1D90, 0x318500FE,
		0x1D90, 0x318600FD,
		0x1D90, 0x318700FC,
		0x1D90, 0x318800FB,
		0x1D90, 0x318900FA,
		0x1D90, 0x318A00F9,
		0x1D90, 0x318B00F8,
		0x1D90, 0x318C00F7,
		0x1D90, 0x318D00F6,
		0x1D90, 0x318E00F5,
		0x1D90, 0x318F00F4,
		0x1D90, 0x319000F3,
		0x1D90, 0x319100F2,
		0x1D90, 0x319200F1,
		0x1D90, 0x319300F0,
		0x1D90, 0x319400E9,
		0x1D90, 0x319500E8,
		0x1D90, 0x319600E7,
		0x1D90, 0x319700E6,
		0x1D90, 0x319800E5,
		0x1D90, 0x319900E4,
		0x1D90, 0x319A00E3,
		0x1D90, 0x319B00C5,
		0x1D90, 0x319C00C4,
		0x1D90, 0x319D00C3,
		0x1D90, 0x319E00C2,
		0x1D90, 0x319F00C1,
		0x1D90, 0x31A000C0,
		0x1D90, 0x31A100A4,
		0x1D90, 0x31A200A3,
		0x1D90, 0x31A300A2,
		0x1D90, 0x31A400A1,
		0x1D90, 0x31A500A0,
		0x1D90, 0x31A60083,
		0x1D90, 0x31A70082,
		0x1D90, 0x31A80081,
		0x1D90, 0x31A90080,
		0x1D90, 0x31AA0066,
		0x1D90, 0x31AB0065,
		0x1D90, 0x31AC0064,
		0x1D90, 0x31AD0063,
		0x1D90, 0x31AE0062,
		0x1D90, 0x31AF0061,
		0x1D90, 0x31B00060,
		0x1D90, 0x31B10042,
		0x1D90, 0x31B20041,
		0x1D90, 0x31B30040,
		0x1D90, 0x31B40006,
		0x1D90, 0x31B50005,
		0x1D90, 0x31B60004,
		0x1D90, 0x31B70003,
		0x1D90, 0x31B80002,
		0x1D90, 0x31B90001,
		0x1D90, 0x31BA0000,
		0x1D90, 0x31BB0000,
		0x1D90, 0x31BC0000,
		0x1D90, 0x31BD0000,
		0x1D90, 0x31BE0000,
		0x1D90, 0x31BF0000,
		0x1D90, 0x31C000FF,
		0x1D90, 0x31C100FF,
		0x1D90, 0x31C200FF,
		0x1D90, 0x31C300FF,
		0x1D90, 0x31C400FF,
		0x1D90, 0x31C500FE,
		0x1D90, 0x31C600FD,
		0x1D90, 0x31C700FC,
		0x1D90, 0x31C800FB,
		0x1D90, 0x31C900FA,
		0x1D90, 0x31CA00F9,
		0x1D90, 0x31CB00F8,
		0x1D90, 0x31CC00F7,
		0x1D90, 0x31CD00F6,
		0x1D90, 0x31CE00F5,
		0x1D90, 0x31CF00F4,
		0x1D90, 0x31D000F3,
		0x1D90, 0x31D100F2,
		0x1D90, 0x31D200F1,
		0x1D90, 0x31D300F0,
		0x1D90, 0x31D400E9,
		0x1D90, 0x31D500E8,
		0x1D90, 0x31D600E7,
		0x1D90, 0x31D700E6,
		0x1D90, 0x31D800E5,
		0x1D90, 0x31D900E4,
		0x1D90, 0x31DA00E3,
		0x1D90, 0x31DB00C5,
		0x1D90, 0x31DC00C4,
		0x1D90, 0x31DD00C3,
		0x1D90, 0x31DE00C2,
		0x1D90, 0x31DF00C1,
		0x1D90, 0x31E000C0,
		0x1D90, 0x31E100A4,
		0x1D90, 0x31E200A3,
		0x1D90, 0x31E300A2,
		0x1D90, 0x31E400A1,
		0x1D90, 0x31E500A0,
		0x1D90, 0x31E60083,
		0x1D90, 0x31E70082,
		0x1D90, 0x31E80081,
		0x1D90, 0x31E90080,
		0x1D90, 0x31EA0064,
		0x1D90, 0x31EB0063,
		0x1D90, 0x31EC0062,
		0x1D90, 0x31ED0061,
		0x1D90, 0x31EE0060,
		0x1D90, 0x31EF0042,
		0x1D90, 0x31F00041,
		0x1D90, 0x31F10040,
		0x1D90, 0x31F20022,
		0x1D90, 0x31F30021,
		0x1D90, 0x31F40020,
		0x1D90, 0x31F50002,
		0x1D90, 0x31F60001,
		0x1D90, 0x31F70000,
		0x1D90, 0x31F80000,
		0x1D90, 0x31F90000,
		0x1D90, 0x31FA0000,
		0x1D90, 0x31FB0000,
		0x1D90, 0x31FC0000,
		0x1D90, 0x31FD0000,
		0x1D90, 0x31FE0000,
		0x1D90, 0x31FF0000,
		0x1D90, 0x320000FF,
		0x1D90, 0x320100FF,
		0x1D90, 0x320200FF,
		0x1D90, 0x320300FF,
		0x1D90, 0x320400FF,
		0x1D90, 0x320500FE,
		0x1D90, 0x320600FD,
		0x1D90, 0x320700FC,
		0x1D90, 0x320800FB,
		0x1D90, 0x320900FA,
		0x1D90, 0x320A00F9,
		0x1D90, 0x320B00F8,
		0x1D90, 0x320C00F7,
		0x1D90, 0x320D00F6,
		0x1D90, 0x320E00F5,
		0x1D90, 0x320F00F4,
		0x1D90, 0x321000F3,
		0x1D90, 0x321100F2,
		0x1D90, 0x321200F1,
		0x1D90, 0x321300F0,
		0x1D90, 0x321400E9,
		0x1D90, 0x321500E8,
		0x1D90, 0x321600E7,
		0x1D90, 0x321700E6,
		0x1D90, 0x321800E5,
		0x1D90, 0x321900E4,
		0x1D90, 0x321A00E3,
		0x1D90, 0x321B00C5,
		0x1D90, 0x321C00C4,
		0x1D90, 0x321D00C3,
		0x1D90, 0x321E00C2,
		0x1D90, 0x321F00C1,
		0x1D90, 0x322000C0,
		0x1D90, 0x322100A4,
		0x1D90, 0x322200A3,
		0x1D90, 0x322300A2,
		0x1D90, 0x322400A1,
		0x1D90, 0x322500A0,
		0x1D90, 0x32260083,
		0x1D90, 0x32270082,
		0x1D90, 0x32280081,
		0x1D90, 0x32290080,
		0x1D90, 0x322A0064,
		0x1D90, 0x322B0063,
		0x1D90, 0x322C0062,
		0x1D90, 0x322D0061,
		0x1D90, 0x322E0060,
		0x1D90, 0x322F0042,
		0x1D90, 0x32300041,
		0x1D90, 0x32310040,
		0x1D90, 0x32320022,
		0x1D90, 0x32330021,
		0x1D90, 0x32340020,
		0x1D90, 0x32350002,
		0x1D90, 0x32360001,
		0x1D90, 0x32370000,
		0x1D90, 0x32380000,
		0x1D90, 0x32390000,
		0x1D90, 0x323A0000,
		0x1D90, 0x323B0000,
		0x1D90, 0x323C0000,
		0x1D90, 0x323D0000,
		0x1D90, 0x323E0000,
		0x1D90, 0x323F0000,
		0x1D90, 0x324000DA,
		0x1D90, 0x324100DA,
		0x1D90, 0x324200DA,
		0x1D90, 0x324300DA,
		0x1D90, 0x324400DA,
		0x1D90, 0x324500DA,
		0x1D90, 0x324600DA,
		0x1D90, 0x324700DA,
		0x1D90, 0x324800DA,
		0x1D90, 0x324900DA,
		0x1D90, 0x324A00DA,
		0x1D90, 0x324B00DA,
		0x1D90, 0x324C00D9,
		0x1D90, 0x324D00D8,
		0x1D90, 0x324E00D7,
		0x1D90, 0x324F00D6,
		0x1D90, 0x325000D5,
		0x1D90, 0x325100D4,
		0x1D90, 0x325200D3,
		0x1D90, 0x325300D2,
		0x1D90, 0x325400D1,
		0x1D90, 0x325500D0,
		0x1D90, 0x325600C9,
		0x1D90, 0x325700C8,
		0x1D90, 0x325800C7,
		0x1D90, 0x325900C6,
		0x1D90, 0x325A00C5,
		0x1D90, 0x325B00C4,
		0x1D90, 0x325C00C3,
		0x1D90, 0x325D00C2,
		0x1D90, 0x325E00C1,
		0x1D90, 0x325F00C0,
		0x1D90, 0x326000A4,
		0x1D90, 0x326100A3,
		0x1D90, 0x326200A2,
		0x1D90, 0x326300A1,
		0x1D90, 0x32640083,
		0x1D90, 0x32650082,
		0x1D90, 0x32660081,
		0x1D90, 0x32670080,
		0x1D90, 0x32680065,
		0x1D90, 0x32690064,
		0x1D90, 0x326A0063,
		0x1D90, 0x326B0062,
		0x1D90, 0x326C0061,
		0x1D90, 0x326D0060,
		0x1D90, 0x326E0043,
		0x1D90, 0x326F0042,
		0x1D90, 0x32700041,
		0x1D90, 0x32710040,
		0x1D90, 0x32720022,
		0x1D90, 0x32730021,
		0x1D90, 0x32740020,
		0x1D90, 0x32750002,
		0x1D90, 0x32760001,
		0x1D90, 0x32770000,
		0x1D90, 0x32780000,
		0x1D90, 0x32790000,
		0x1D90, 0x327A0000,
		0x1D90, 0x327B0000,
		0x1D90, 0x327C0000,
		0x1D90, 0x327D0000,
		0x1D90, 0x327E0000,
		0x1D90, 0x327F0000,
		0x1D90, 0x328000BA,
		0x1D90, 0x328100BA,
		0x1D90, 0x328200BA,
		0x1D90, 0x328300BA,
		0x1D90, 0x328400BA,
		0x1D90, 0x328500BA,
		0x1D90, 0x328600BA,
		0x1D90, 0x328700BA,
		0x1D90, 0x328800BA,
		0x1D90, 0x328900BA,
		0x1D90, 0x328A00BA,
		0x1D90, 0x328B00BA,
		0x1D90, 0x328C00BA,
		0x1D90, 0x328D00BA,
		0x1D90, 0x328E00BA,
		0x1D90, 0x328F00BA,
		0x1D90, 0x329000BA,
		0x1D90, 0x329100B9,
		0x1D90, 0x329200B8,
		0x1D90, 0x329300B7,
		0x1D90, 0x329400B6,
		0x1D90, 0x329500B5,
		0x1D90, 0x329600B4,
		0x1D90, 0x329700B3,
		0x1D90, 0x329800B2,
		0x1D90, 0x329900B1,
		0x1D90, 0x329A00B0,
		0x1D90, 0x329B00A9,
		0x1D90, 0x329C00A8,
		0x1D90, 0x329D00A7,
		0x1D90, 0x329E00A6,
		0x1D90, 0x329F00A5,
		0x1D90, 0x32A00087,
		0x1D90, 0x32A10086,
		0x1D90, 0x32A20085,
		0x1D90, 0x32A30084,
		0x1D90, 0x32A40083,
		0x1D90, 0x32A50082,
		0x1D90, 0x32A60081,
		0x1D90, 0x32A70080,
		0x1D90, 0x32A80065,
		0x1D90, 0x32A90064,
		0x1D90, 0x32AA0063,
		0x1D90, 0x32AB0062,
		0x1D90, 0x32AC0061,
		0x1D90, 0x32AD0060,
		0x1D90, 0x32AE0043,
		0x1D90, 0x32AF0042,
		0x1D90, 0x32B00041,
		0x1D90, 0x32B10040,
		0x1D90, 0x32B20022,
		0x1D90, 0x32B30021,
		0x1D90, 0x32B40020,
		0x1D90, 0x32B50002,
		0x1D90, 0x32B60001,
		0x1D90, 0x32B70000,
		0x1D90, 0x32B80000,
		0x1D90, 0x32B90000,
		0x1D90, 0x32BA0000,
		0x1D90, 0x32BB0000,
		0x1D90, 0x32BC0000,
		0x1D90, 0x32BD0000,
		0x1D90, 0x32BE0000,
		0x1D90, 0x32BF0000,
		0x1D90, 0x32C000BA,
		0x1D90, 0x32C100BA,
		0x1D90, 0x32C200BA,
		0x1D90, 0x32C300BA,
		0x1D90, 0x32C400BA,
		0x1D90, 0x32C500BA,
		0x1D90, 0x32C600BA,
		0x1D90, 0x32C700BA,
		0x1D90, 0x32C800BA,
		0x1D90, 0x32C900BA,
		0x1D90, 0x32CA00BA,
		0x1D90, 0x32CB00BA,
		0x1D90, 0x32CC00BA,
		0x1D90, 0x32CD00BA,
		0x1D90, 0x32CE00BA,
		0x1D90, 0x32CF00BA,
		0x1D90, 0x32D000BA,
		0x1D90, 0x32D1009A,
		0x1D90, 0x32D2009A,
		0x1D90, 0x32D3009A,
		0x1D90, 0x32D40099,
		0x1D90, 0x32D50098,
		0x1D90, 0x32D60097,
		0x1D90, 0x32D70096,
		0x1D90, 0x32D80095,
		0x1D90, 0x32D90094,
		0x1D90, 0x32DA0093,
		0x1D90, 0x32DB0092,
		0x1D90, 0x32DC0091,
		0x1D90, 0x32DD0090,
		0x1D90, 0x32DE0089,
		0x1D90, 0x32DF0088,
		0x1D90, 0x32E00087,
		0x1D90, 0x32E10086,
		0x1D90, 0x32E20085,
		0x1D90, 0x32E30084,
		0x1D90, 0x32E40083,
		0x1D90, 0x32E50082,
		0x1D90, 0x32E60081,
		0x1D90, 0x32E70080,
		0x1D90, 0x32E80065,
		0x1D90, 0x32E90064,
		0x1D90, 0x32EA0063,
		0x1D90, 0x32EB0062,
		0x1D90, 0x32EC0061,
		0x1D90, 0x32ED0060,
		0x1D90, 0x32EE0043,
		0x1D90, 0x32EF0042,
		0x1D90, 0x32F00041,
		0x1D90, 0x32F10040,
		0x1D90, 0x32F20022,
		0x1D90, 0x32F30021,
		0x1D90, 0x32F40020,
		0x1D90, 0x32F50002,
		0x1D90, 0x32F60001,
		0x1D90, 0x32F70000,
		0x1D90, 0x32F80000,
		0x1D90, 0x32F90000,
		0x1D90, 0x32FA0000,
		0x1D90, 0x32FB0000,
		0x1D90, 0x32FC0000,
		0x1D90, 0x32FD0000,
		0x1D90, 0x32FE0000,
		0x1D90, 0x32FF0000,
		0x1D90, 0x330000FF,
		0x1D90, 0x330100FF,
		0x1D90, 0x330200FF,
		0x1D90, 0x330300FF,
		0x1D90, 0x330400FF,
		0x1D90, 0x330500FE,
		0x1D90, 0x330600FD,
		0x1D90, 0x330700FC,
		0x1D90, 0x330800FB,
		0x1D90, 0x330900FA,
		0x1D90, 0x330A00F9,
		0x1D90, 0x330B00F8,
		0x1D90, 0x330C00F7,
		0x1D90, 0x330D00F6,
		0x1D90, 0x330E00F5,
		0x1D90, 0x330F00F4,
		0x1D90, 0x331000F3,
		0x1D90, 0x331100F2,
		0x1D90, 0x331200F1,
		0x1D90, 0x331300F0,
		0x1D90, 0x331400E9,
		0x1D90, 0x331500E8,
		0x1D90, 0x331600E7,
		0x1D90, 0x331700E6,
		0x1D90, 0x331800E5,
		0x1D90, 0x331900E4,
		0x1D90, 0x331A00E3,
		0x1D90, 0x331B00C5,
		0x1D90, 0x331C00C4,
		0x1D90, 0x331D00C3,
		0x1D90, 0x331E00C2,
		0x1D90, 0x331F00C1,
		0x1D90, 0x332000C0,
		0x1D90, 0x332100A4,
		0x1D90, 0x332200A3,
		0x1D90, 0x332300A2,
		0x1D90, 0x332400A1,
		0x1D90, 0x332500A0,
		0x1D90, 0x33260083,
		0x1D90, 0x33270082,
		0x1D90, 0x33280081,
		0x1D90, 0x33290080,
		0x1D90, 0x332A0064,
		0x1D90, 0x332B0063,
		0x1D90, 0x332C0062,
		0x1D90, 0x332D0061,
		0x1D90, 0x332E0060,
		0x1D90, 0x332F0042,
		0x1D90, 0x33300041,
		0x1D90, 0x33310040,
		0x1D90, 0x33320022,
		0x1D90, 0x33330021,
		0x1D90, 0x33340020,
		0x1D90, 0x33350002,
		0x1D90, 0x33360001,
		0x1D90, 0x33370000,
		0x1D90, 0x33380000,
		0x1D90, 0x33390000,
		0x1D90, 0x333A0000,
		0x1D90, 0x333B0000,
		0x1D90, 0x333C0000,
		0x1D90, 0x333D0000,
		0x1D90, 0x333E0000,
		0x1D90, 0x333F0000,
		0x1D70, 0x22222222,
		0x1D70, 0x20202020,

};

void
odm_read_and_config_mp_8723f_agc_tab(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len =
			sizeof(array_mp_8723f_agc_tab) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8723f_agc_tab;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_bb_agc_8723f(dm, v1, MASKDWORD, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8723f_agc_tab(void)
{
		return 24;
}

/******************************************************************************
 *                           phy_reg.TXT
 ******************************************************************************/

const u32 array_mp_8723f_phy_reg[] = {
		0x1D0C, 0x00410000,
		0x1C3C, 0x01038040,
		0x1C90, 0x00E49708,
		0x800, 0x00000000,
		0x804, 0xD6300000,
		0x808, 0x60156024,
		0x80C, 0x00000000,
		0x810, 0x10B019B0,
		0x814, 0x00004000,
		0x818, 0x630056F1,
		0x81C, 0x86050000,
		0x820, 0x11111111,
		0x824, 0xC1C1CCC4,
		0x828, 0x30FB1C04,
		0x82C, 0x1751654A,
		0x830, 0x17511459,
		0x834, 0x776995D7,
		0x838, 0x74777A7D,
		0x83C, 0xF9AA9982,
		0x840, 0x89AA9ABB,
		0x844, 0x0DEEDDC1,
		0x848, 0xCDEEDEFF,
		0x84C, 0xFFFF5555,
		0x850, 0x6F7A727D,
		0x854, 0x6C776F7A,
		0x858, 0x6F7A6C77,
		0x85C, 0x69746974,
		0x860, 0x6F7A6C77,
		0x864, 0x6C776C77,
		0x868, 0x727D6F7A,
		0x86C, 0x69D7B196,
		0x870, 0x1A6D769B,
		0x874, 0x5582391D,
		0x878, 0x00C025BD,
		0x87C, 0x4140557D,
		0x880, 0x9A1D9D47,
		0x884, 0x1DE7134F,
		0x888, 0x2857A857,
		0x88C, 0x502E1A44,
		0x890, 0x8F628C34,
		0x894, 0x72745F49,
		0x898, 0x03F02F0D,
		0x89C, 0x5DB6886E,
		0x8A0, 0x97D4309F,
		0x8A4, 0x09412495,
		0x8A8, 0x222222A9,
		0x8AC, 0x00000000,
		0x8B0, 0x00000000,
		0x8B4, 0x00000000,
		0x8B8, 0x00000000,
		0x8BC, 0x00000000,
		0x8C0, 0x70404023,
		0x8C4, 0x00440001,
		0x8C8, 0x7A7A2E26,
		0x8CC, 0x25297777,
		0x8D0, 0x6CEB6DCE,
		0x8D4, 0x0005A632,
		0x8D8, 0x00000000,
		0x8DC, 0x00000000,
		0x8E0, 0x00000000,
		0x8E4, 0x00000000,
		0x8E8, 0x00000000,
		0x8EC, 0x00000000,
		0x8F0, 0x00672895,
		0x8F4, 0x3C7CE79C,
		0x8F8, 0x25239843,
		0x900, 0x00000000,
		0x904, 0x00000000,
		0x908, 0x000008CB,
		0x90C, 0x00000000,
		0x910, 0x00000000,
		0x914, 0x20000000,
		0x918, 0x20000000,
		0x91C, 0x20000000,
		0x920, 0x20000000,
		0x924, 0x00000000,
		0x928, 0x0000003A,
		0x92C, 0x0000003A,
		0x930, 0x0000003A,
		0x934, 0x0000003A,
		0x938, 0x0000000F,
		0x93C, 0x00000000,
		0x940, 0x4E1F3E81,
		0x944, 0x4E1F3E81,
		0x948, 0x4E1F3E81,
		0x94C, 0x4E1F3E81,
		0x950, 0x03020100,
		0x954, 0x07060504,
		0x958, 0x0B0A0908,
		0x95C, 0x0F0E0D0C,
		0x960, 0x13121110,
		0x964, 0x17161514,
		0x968, 0x03020100,
		0x96C, 0x07060504,
		0x970, 0x0B0A0908,
		0x974, 0x0F0E0D0C,
		0x978, 0x13121110,
		0x97C, 0x17161514,
		0x980, 0x03020100,
		0x984, 0x07060504,
		0x988, 0x0B0A0908,
		0x98C, 0x0F0E0D0C,
		0x990, 0x13121110,
		0x994, 0x17161514,
		0x998, 0x03020100,
		0x99C, 0x07060504,
		0x9A0, 0x0B0A0908,
		0x9A4, 0x0F0E0D0C,
		0x9A8, 0x13121110,
		0x9AC, 0x17161514,
		0x9B0, 0x00002200,
		0x9B4, 0xDB691B00,
		0x9B8, 0x00400064,
		0x9BC, 0x00000000,
		0x9C0, 0x01010101,
		0x9C4, 0x00640064,
		0x9C8, 0x00640064,
		0x9CC, 0x00007777,
		0x9D0, 0x00000000,
		0x9D4, 0x00000000,
		0x9D8, 0x00000000,
		0x9DC, 0x00000000,
		0x9E0, 0x00000000,
		0x9E4, 0x00000000,
		0x9E8, 0x00000000,
		0x9EC, 0x00000000,
		0x9F0, 0x0000CCCC,
		0x9F4, 0x00000000,
		0x9F8, 0x00000000,
		0xA00, 0x02001208,
		0xA04, 0x00000000,
		0xA08, 0x00000000,
		0xA0C, 0x00000000,
		0xA10, 0x00000000,
		0xA14, 0x00000000,
		0xA18, 0x00000000,
		0xA1C, 0x00000000,
		0xA20, 0xEB31B333,
		0xA24, 0x00275485,
		0xA28, 0x00166366,
		0xA2C, 0x00275485,
		0xA30, 0x00166366,
		0xA34, 0x00275485,
		0xA38, 0x00200400,
		0xA3C, 0x00200400,
		0xA40, 0xB35DC1B9,
		0xA44, 0x3033BE95,
		0xA48, 0x2A521254,
		0xA4C, 0x52533335,
		0xA50, 0x605BE083,
		0xA54, 0x50000968,
		0xA58, 0x00020000,
		0xA5C, 0x01000000,
		0xA60, 0x02000000,
		0xA64, 0x03000000,
		0xA68, 0x00000000,
		0xA6C, 0x00000000,
		0xA70, 0x00000000,
		0xA74, 0x00000000,
		0xA78, 0x00000000,
		0xA7C, 0x00000000,
		0xA80, 0x00000000,
		0xA84, 0x00000000,
		0xA88, 0x00000000,
		0xA8C, 0x00000000,
		0xA90, 0x00000000,
		0xA94, 0x00000000,
		0xA98, 0x00000000,
		0xA9C, 0x00000000,
		0xAA0, 0x00000000,
		0xAA4, 0x00000000,
		0xAA8, 0x00000000,
		0xAAC, 0x00000000,
		0xAB0, 0x00000000,
		0xAB4, 0x00000000,
		0xAB8, 0x00000000,
		0xABC, 0x00000000,
		0xAC0, 0x00000000,
		0xAC4, 0x00000000,
		0xAC8, 0x00000000,
		0xACC, 0x00000000,
		0xAD0, 0x00000000,
		0xAD4, 0x00000000,
		0xAD8, 0x00000000,
		0xADC, 0x00000000,
		0xAE0, 0x00000000,
		0xAE4, 0x00000000,
		0xAE8, 0x00000000,
		0xAEC, 0x00000000,
		0xAF0, 0x00000000,
		0xAF4, 0x00000000,
		0xAF8, 0x00000000,
		0xB00, 0x00000000,
		0xB04, 0x00000000,
		0xB08, 0x00000000,
		0xB0C, 0x00000000,
		0xB10, 0x00000000,
		0xB14, 0x00000000,
		0xB18, 0x00000000,
		0xB1C, 0x00000000,
		0xB20, 0x00000000,
		0xB24, 0x00000000,
		0xB28, 0x00000000,
		0xB2C, 0x00000000,
		0xB30, 0x00000000,
		0xB34, 0x00000000,
		0xB38, 0x00000000,
		0xB3C, 0x00000000,
		0xB40, 0x00000000,
		0xB44, 0x00000000,
		0xB48, 0x00000000,
		0xB4C, 0x00000000,
		0xB50, 0x00000000,
		0xB54, 0x00000000,
		0xB58, 0x00000000,
		0xB5C, 0x00000000,
		0xB60, 0x00000000,
		0xB64, 0x00000000,
		0xB68, 0x00000000,
		0xB6C, 0x00000000,
		0xB70, 0x00000000,
		0xB74, 0x00000000,
		0xB78, 0x00000000,
		0xB7C, 0x00000000,
		0xB80, 0x00000000,
		0xB84, 0x00000000,
		0xB88, 0x00000000,
		0xB8C, 0x00000000,
		0xB90, 0x00000000,
		0xB94, 0x00000000,
		0xB98, 0x00000000,
		0xB9C, 0x00000000,
		0xBA0, 0x00000000,
		0xBA4, 0x00000000,
		0xBA8, 0x00000000,
		0xBAC, 0x00000000,
		0xBB0, 0x00000000,
		0xBB4, 0x00000000,
		0xBB8, 0x00000000,
		0xBBC, 0x00000000,
		0xBC0, 0x00000000,
		0xBC4, 0x00000000,
		0xBC8, 0x00000000,
		0xBCC, 0x00000000,
		0xBD0, 0x00000000,
		0xBD4, 0x00000000,
		0xBD8, 0x00000000,
		0xBDC, 0x00000000,
		0xBE0, 0x00000000,
		0xBE4, 0x00000000,
		0xBE8, 0x00000000,
		0xBEC, 0x00000000,
		0xBF0, 0x00000000,
		0xBF4, 0x00000000,
		0xBF8, 0x00000000,
		0xC00, 0x1C8BA0D6,
		0xC04, 0x00000009,
		0xC08, 0x00000000,
		0xC0C, 0x02F1D8B7,
		0xC10, 0x000000B0,
		0xC14, 0x0000D890,
		0xC18, 0x00087672,
		0xC1C, 0x15260000,
		0xC20, 0x00000000,
		0xC24, 0x406000FF,
		0xC28, 0x06400F76,
		0xC2C, 0xE31480E1,
		0xC30, 0x140C99AA,
		0xC34, 0x00A04946,
		0xC38, 0x001D4820,
		0xC3C, 0x168DB61B,
		0xC40, 0x009C50F8,
		0xC44, 0x2011BAD1,
		0xC48, 0xFFFFF7CC,
		0xC4C, 0xA000FFFF,
		0xC50, 0x20D0F800,
		0xC54, 0x940A0200,
		0xC58, 0x18380111,
		0xC5C, 0x006E01B8,
		0xC60, 0x2CA5555B,
		0xC64, 0x0210005F,
		0xC68, 0x039A5300,
		0xC6C, 0x0265C2BA,
		0xC70, 0x000CEB21,
		0xC74, 0x0E149CA1,
		0xC78, 0x1AB4956B,
		0xC7C, 0x00000ABF,
		0xC80, 0xC02A8799,
		0xC84, 0x00063006,
		0xC88, 0x08090202,
		0xC8C, 0x00204048,
		0xC90, 0x00F85F85,
		0xC94, 0x00000F85,
		0xC98, 0x58385858,
		0xC9C, 0x18382838,
		0xCA0, 0x00002838,
		0xCA4, 0x3A253A3A,
		0xCA8, 0x10251A25,
		0xCAC, 0x00001025,
		0xCB0, 0x3A133A3A,
		0xCB4, 0x08130D13,
		0xCB8, 0x00000813,
		0xCBC, 0x001F1066,
		0xCC0, 0x88A00400,
		0xCC4, 0x00200400,
		0xCC8, 0x0B200400,
		0xCCC, 0x00600400,
		0xCD0, 0x00000092,
		0xCD4, 0x22220000,
		0xCD8, 0x22222222,
		0xCDC, 0x22222222,
		0xCE0, 0x22222222,
		0xCE4, 0x22222222,
		0xCE8, 0xFFFF2222,
		0xCEC, 0xFFFFFFFF,
		0xCF0, 0xFFFFFFFF,
		0xCF4, 0xDFFFFFBF,
		0xCF8, 0xFFFFFFFD,
		0xCFC, 0xFFFFFFFF,
		0xD00, 0x1083A10A,
		0xD04, 0x0EC42948,
		0xD08, 0x10852108,
		0xD0C, 0x0CC41D08,
		0xD10, 0x108620EC,
		0xD14, 0x0CA42108,
		0xD18, 0x107620E8,
		0xD1C, 0x0E742108,
		0xD20, 0x0E8618C8,
		0xD24, 0x00000108,
		0xD28, 0x288C224C,
		0xD2C, 0x11C6320C,
		0xD30, 0x30CEBD98,
		0xD34, 0x10C31908,
		0xD38, 0x310A318C,
		0xD3C, 0x18C41D08,
		0xD40, 0x28CC4190,
		0xD44, 0x19062108,
		0xD48, 0x294A5A17,
		0xD4C, 0x00000108,
		0xD50, 0x10A3A908,
		0xD54, 0x10842148,
		0xD58, 0x14C5314A,
		0xD5C, 0x1086258C,
		0xD60, 0x10A42948,
		0xD64, 0x10842108,
		0xD68, 0x08C42108,
		0xD6C, 0x10842148,
		0xD70, 0x08822084,
		0xD74, 0x10841D04,
		0xD78, 0x08421088,
		0xD7C, 0x1083A104,
		0xD80, 0x10842108,
		0xD84, 0x1085294A,
		0xD88, 0x08822104,
		0xD8C, 0x10852948,
		0xD90, 0x08421084,
		0xD94, 0x10852104,
		0xD98, 0x08421084,
		0xD9C, 0x10863184,
		0xDA0, 0x1083B10A,
		0xDA4, 0x10842148,
		0xDA8, 0x1984718C,
		0xDAC, 0x108C33AF,
		0xDB0, 0x33221100,
		0xDB4, 0x00000000,
		0xDB8, 0x00000000,
		0xDBC, 0x00000000,
		0xDC0, 0x00000000,
		0xDC4, 0x00000000,
		0xDC8, 0x00000000,
		0xDCC, 0x00000000,
		0xDD0, 0x00000000,
		0xDD4, 0x00000000,
		0xDD8, 0x00000000,
		0xDDC, 0x00000000,
		0xDE0, 0x00000000,
		0xDE4, 0x00000000,
		0xDE8, 0x00000000,
		0xDEC, 0x00000000,
		0xDF0, 0x00000000,
		0xDF4, 0x00000000,
		0xDF8, 0x00000000,
		0x1800, 0x00033312,
		0x1804, 0x40033312,
		0x180C, 0x17F43860,
		0x1810, 0xB3000202,
		0x1814, 0x06000141,
		0x1818, 0x00000280,
		0x181C, 0x00000000,
		0x1820, 0xB3000202,
		0x1824, 0x06000141,
		0x1828, 0x00000280,
		0x182C, 0x00000000,
		0x1834, 0x00000000,
		0x1838, 0x20000000,
		0x183C, 0x00000000,
		0x1840, 0x00000000,
		0x1844, 0x00000000,
		0x1848, 0x00000000,
		0x184C, 0x00000000,
		0x1850, 0x00000000,
		0x1854, 0x00000000,
		0x1858, 0x00000000,
		0x185C, 0x00000000,
		0x1860, 0xF0040FF8,
		0x1864, 0x7F000000,
		0x1868, 0x00000000,
		0x186C, 0x0000FF00,
		0x1870, 0x00000000,
		0x1874, 0x00000000,
		0x1878, 0x00000000,
		0x187C, 0x00000000,
		0x1880, 0x00000000,
		0x1884, 0x00000000,
		0x1888, 0x00000000,
		0x188C, 0x00000000,
		0x1890, 0x00000000,
		0x1894, 0x00000000,
		0x1898, 0x00000000,
		0x18A0, 0x00510000,
		0x18A4, 0x10141F7F,
		0x18A8, 0x0A02C99A,
		0x18AC, 0x00064A00,
		0x18B0, 0x03000F09,
		0x18B0, 0x0809FB09,
		0x18B4, 0x00000000,
		0x18B8, 0x00000000,
		0x18BC, 0xC100FFC0,
		0x18C0, 0x000001FF,
		0x18C4, 0x00000004,
		0x18C8, 0x00007FE0,
		0x18CC, 0x03000F09,
		0x18CC, 0x0809FB09,
		0x18D0, 0x00000000,
		0x18D4, 0x00000000,
		0x18D8, 0xC100FFC0,
		0x18DC, 0x000001FF,
		0x18E0, 0x00000004,
		0x18E4, 0x00007FE0,
		0x18E8, 0x00800000,
		0x18EC, 0x1EC08000,
		0x18F0, 0x00000000,
		0x18F4, 0x1F7DE75C,
		0x18F8, 0x7F7F7F7F,
		0x18FC, 0x7F7F7F7F,
		0x1900, 0xA7A7A8A6,
		0x1904, 0x95959595,
		0x1908, 0x0077779A,
		0x190C, 0x77776666,
		0x1910, 0x00033333,
		0x1914, 0xAAAC875A,
		0x1918, 0x2AA2A8A2,
		0x191C, 0x2AAAA8A2,
		0x1920, 0x00878766,
		0x1924, 0x000E4924,
		0x1928, 0x1669B6C0,
		0x192C, 0x00007192,
		0x1930, 0xB85C0492,
		0x1934, 0x02B4A298,
		0x1938, 0x00030151,
		0x193C, 0x0030C618,
		0x1940, 0x41000000,
		0x1944, 0x01100BD8,
		0x1948, 0x44444444,
		0x194C, 0x00B99999,
		0x1950, 0x88886668,
		0x1954, 0x00000000,
		0x1958, 0x00000618,
		0x195C, 0x00000800,
		0x1960, 0x44444444,
		0x1964, 0x2022653A,
		0x1968, 0x36637571,
		0x196C, 0xC100A294,
		0x1970, 0x00000000,
		0x1974, 0x00000000,
		0x1978, 0x00000000,
		0x197C, 0x00000000,
		0x1980, 0x00000000,
		0x1984, 0x00000000,
		0x1988, 0x00000000,
		0x198C, 0x00000000,
		0x1990, 0x00000000,
		0x1994, 0x00000000,
		0x1998, 0x00000000,
		0x199C, 0x00000000,
		0x19A0, 0x00000000,
		0x19A4, 0x00000000,
		0x19A8, 0x00000000,
		0x19AC, 0x00000000,
		0x19B0, 0x00000000,
		0x19B4, 0x00000000,
		0x19B8, 0x00000000,
		0x19BC, 0x00000000,
		0x19C0, 0x00000000,
		0x19C4, 0x00000000,
		0x19C8, 0x00000000,
		0x19CC, 0x00000000,
		0x19D0, 0x00000000,
		0x19D4, 0x00000000,
		0x19D8, 0x00000000,
		0x19DC, 0x00000000,
		0x19E0, 0x00000000,
		0x19E4, 0x00000000,
		0x19E8, 0x00000000,
		0x19EC, 0x00000000,
		0x19F0, 0x00000000,
		0x19F4, 0x00000000,
		0x19F8, 0x00000000,
		0x1C00, 0x00000000,
		0x1C04, 0x00000000,
		0x1C08, 0x00000000,
		0x1C0C, 0x00000000,
		0x1C10, 0x00000000,
		0x1C14, 0x00000000,
		0x1C18, 0x00000000,
		0x1C1C, 0x00000000,
		0x1C20, 0x03C23F20,
		0x1C24, 0xF101F002,
		0x1C28, 0x0FFE0010,
		0x1C2C, 0x453090FF,
		0x1C30, 0xFE0090FE,
		0x1C34, 0xE4E42000,
		0x1C38, 0xFFA1005E,
		0x1C40, 0x8F588937,
		0x1C44, 0x04400740,
		0x1C48, 0x00000002,
		0x1C4C, 0x00000200,
		0x1C50, 0x8E588837,
		0x1C54, 0x04400300,
		0x1C58, 0x00000000,
		0x1C5C, 0xFFFFFFFF,
		0x1C60, 0x0F030032,
		0x1C64, 0x760F0008,
		0x1C68, 0xC07F0000,
		0x1C6C, 0x00010000,
		0x1C70, 0x00037FFE,
		0x1C74, 0x00000000,
		0x1C78, 0x00020000,
		0x1C7C, 0x00700000,
		0x1C80, 0x0E38E000,
		0x1C84, 0x245140D4,
		0x1C88, 0xC8400483,
		0x1C8C, 0x40005A20,
		0x1C94, 0x00000000,
		0x1C98, 0x00000000,
		0x1C9C, 0x00000000,
		0x1CA0, 0x00000000,
		0x1CA4, 0x20000000,
		0x1CA8, 0x0E000000,
		0x1CAC, 0xE424A2CC,
		0x1CB0, 0x00000000,
		0x1CB4, 0x00000000,
		0x1CB8, 0x24800000,
		0x1CBC, 0x60004800,
		0x1CC0, 0x24800000,
		0x1CC4, 0x60004800,
		0x1CC8, 0xE0444900,
		0x1CCC, 0x030300F1,
		0x1CD0, 0x0F000000,
		0x1CD4, 0x02024B80,
		0x1CD8, 0x04000000,
		0x1CDC, 0x10000000,
		0x1CE0, 0x60000000,
		0x1CE4, 0x00000000,
		0x1CE8, 0xE8000000,
		0x1CEC, 0x00000000,
		0x1CF0, 0x00000000,
		0x1CF4, 0xE4000000,
		0x1CF8, 0x00000000,
		0x1D00, 0x00000000,
		0x1D04, 0x08A3C000,
		0x1D08, 0xA0000000,
		0x1D10, 0x08B5BBBB,
		0x1D14, 0x77777777,
		0x1D18, 0x99999999,
		0x1D1C, 0x99999999,
		0x1D20, 0x000081E0,
		0x1D24, 0x00000000,
		0x1D28, 0x00000000,
		0x1D2C, 0xC0000000,
		0x1D30, 0x52049400,
		0x1D34, 0x00000000,
		0x1D38, 0x00000000,
		0x1D3C, 0xF8000000,
		0x1D40, 0x00000000,
		0x1D44, 0x74740000,
		0x1D48, 0x14147474,
		0x1D4C, 0x00FFFF14,
		0x1D50, 0x00000000,
		0x1D54, 0x03A00000,
		0x1D58, 0x80800000,
		0x1D5C, 0x00000000,
		0x1D60, 0x00000000,
		0x1D64, 0x88000000,
		0x1D68, 0x00000000,
		0x1D6C, 0x666D8001,
		0x1D70, 0xA02020A0,
		0x1D74, 0x4E4E4E4E,
		0x1D78, 0x18189818,
		0x1D7C, 0x0005A000,
		0x1D80, 0x00080000,
		0x1D84, 0x00080000,
		0x1D88, 0x000000EF,
		0x1D8C, 0x0C0C0C0C,
		0x1D90, 0x00000000,
		0x1D94, 0x00000000,
		0x1D98, 0x37001400,
		0x1D9C, 0x00000000,
		0x1DA0, 0x00000000,
		0x1DA4, 0x80000000,
		0x1DA8, 0x00000000,
		0x1DAC, 0x00000000,
		0x1DB0, 0x00000000,
		0x1DB4, 0x00000000,
		0x1DB8, 0x00000000,
		0x1DBC, 0x00000000,
		0x1DC0, 0x00000000,
		0x1DC4, 0x00000000,
		0x1DC8, 0x00000000,
		0x1DCC, 0x00000000,
		0x1DD0, 0x00000000,
		0x1DD4, 0x00000000,
		0x1DD8, 0x00000000,
		0x1DDC, 0x1FDF0000,
		0x1DE0, 0x01010000,
		0x1DE4, 0x45210123,
		0x1DE8, 0xFFFF4848,
		0x1DEC, 0x00000000,
		0x1DF0, 0x00000000,
		0x1DF4, 0x80000000,
		0x1DF8, 0x00000000,
		0x1DFC, 0x00000000,
		0x1E00, 0x00000000,
		0x1E04, 0x00000000,
		0x1E08, 0x00000000,
		0x1E0C, 0x00000000,
		0x1E10, 0x00000000,
		0x1E14, 0x00000000,
		0x1E18, 0x00000000,
		0x1E1C, 0x84008000,
		0x1E20, 0x00000000,
		0x1E24, 0x80003000,
		0x1E28, 0x000CCEC3,
		0x1E2C, 0xE4E4E4E4,
		0x1E30, 0xE4E4E4E4,
		0x1E34, 0xF3001234,
		0x1E38, 0x00000000,
		0x1E3C, 0x00000000,
		0x1E40, 0x00000000,
		0x1E44, 0x00000000,
		0x1E48, 0x00000000,
		0x1E4C, 0x00000000,
		0x1E50, 0x00000000,
		0x1E54, 0x00000000,
		0x1E58, 0x00000000,
		0x1E5C, 0xC1000000,
		0x1E60, 0x00000000,
		0x1E64, 0xF3A00001,
		0x1E68, 0x0028846E,
		0x1E6C, 0x002F4906,
		0x1E70, 0x00001000,
		0x1E74, 0x00000000,
		0x1E78, 0x00000000,
		0x1E7C, 0x00000000,
		0x1E80, 0x00000000,
		0x1E84, 0x00000000,
		0x1E84, 0x40000000,
		0x1E84, 0x41000000,
		0x1E84, 0x42000000,
		0x1E84, 0x43000000,
		0x1E84, 0x44000000,
		0x1E84, 0x45000000,
		0x1E84, 0x46000000,
		0x1E84, 0x47000000,
		0x1E84, 0x48000000,
		0x1E84, 0x49000000,
		0x1E84, 0x4A000000,
		0x1E84, 0x4B000000,
		0x1E84, 0x4C000000,
		0x1E84, 0x4D000000,
		0x1E84, 0x4E000000,
		0x1E84, 0x4F000000,
		0x1E84, 0x50000000,
		0x1E84, 0x51000000,
		0x1E84, 0x52000000,
		0x1E84, 0x53000000,
		0x1E84, 0x54000000,
		0x1E84, 0x55000000,
		0x1E84, 0x56000000,
		0x1E84, 0x57000000,
		0x1E84, 0x58000000,
		0x1E84, 0x59000000,
		0x1E84, 0x5A000000,
		0x1E84, 0x5B000000,
		0x1E84, 0x5C000000,
		0x1E84, 0x5D000000,
		0x1E84, 0x5E000000,
		0x1E84, 0x5F000000,
		0x1E84, 0x60000000,
		0x1E84, 0x61000000,
		0x1E84, 0x62000000,
		0x1E84, 0x63000000,
		0x1E84, 0x64000000,
		0x1E84, 0x65000000,
		0x1E84, 0x66000000,
		0x1E84, 0x67000000,
		0x1E84, 0x68000000,
		0x1E84, 0x69000000,
		0x1E84, 0x6A000000,
		0x1E84, 0x6B000000,
		0x1E84, 0x6C000000,
		0x1E84, 0x6D000000,
		0x1E84, 0x6E000000,
		0x1E84, 0x6F000000,
		0x1E84, 0x70000000,
		0x1E84, 0x71000000,
		0x1E84, 0x72000000,
		0x1E84, 0x73000000,
		0x1E84, 0x74000000,
		0x1E84, 0x75000000,
		0x1E84, 0x76000000,
		0x1E84, 0x77000000,
		0x1E84, 0x78000000,
		0x1E84, 0x79000000,
		0x1E84, 0x7A000000,
		0x1E84, 0x7B000000,
		0x1E84, 0x7C000000,
		0x1E84, 0x7D000000,
		0x1E84, 0x7E000000,
		0x1E84, 0x7F000000,
		0x1E84, 0x80000000,
		0x1E84, 0x00000000,
		0x1E88, 0x0200FC1C,
		0x1E8C, 0x00000000,
		0x1E90, 0x00000000,
		0x1E94, 0x04000000,
		0x1E98, 0x00000000,
		0x1E9C, 0x00000000,
		0x1EA0, 0x08000000,
		0x1EA4, 0x00000000,
		0x1EA8, 0xAA464646,
		0x1EAC, 0x01800030,
		0x1EB0, 0x0000300E,
		0x1EB4, 0xB1800002,
		0x1EB8, 0x00000000,
		0x1EBC, 0x00000000,
		0x1EC0, 0x00000000,
		0x1EC4, 0x00000000,
		0x1EC8, 0x00000000,
		0x1ECC, 0x00000000,
		0x1ED0, 0x00000000,
		0x1ED4, 0x8000000A,
		0x1ED8, 0x800B03E8,
		0x1EDC, 0x83E90FFF,
		0x1EE0, 0x8000FFFF,
		0x1EE4, 0x70000000,
		0x1EE8, 0x00000000,
		0x1EEC, 0x0280A933,
		0x1EF0, 0x00000A80,
		0x1EF4, 0x00001266,
		0x1EF8, 0x01000100,
		0x3A00, 0x00000000,
		0x3A04, 0x00000000,
		0x3A08, 0x00000000,
		0x3A0C, 0x00000000,
		0x3A10, 0x13121110,
		0x3A14, 0x00000000,
		0x3A18, 0x00000000,
		0x3A1C, 0x00000000,
		0x3A20, 0x00000000,
		0x3A24, 0x00018000,
		0x3A28, 0x00000000,
		0x3A2C, 0x00000000,
		0x3A30, 0x00000000,
		0x3A34, 0x00000000,
		0x3A38, 0x00000000,
		0x3A3C, 0x00000000,
		0x3A40, 0x00000040,
		0x3A44, 0x00000000,
		0x3A48, 0x00000000,
		0x3A4C, 0x00000000,
		0x3A50, 0x00000000,
		0x3A54, 0x00000000,
		0x3A58, 0x00000000,
		0x3A5C, 0x00000000,
		0x3A60, 0x00000000,
		0x3A64, 0x00000000,
		0x3A68, 0x00000000,
		0x3A6C, 0x00000000,
		0x3A70, 0x00000000,
		0x3A74, 0x00000000,
		0x3A78, 0x00000000,
		0x3A7C, 0x00000000,
		0x3A80, 0x00000000,
		0x3A84, 0x00000000,
		0x3A88, 0x00000000,
		0x3A8C, 0x00000000,
		0x3A90, 0x00000000,
		0x3A94, 0x00000000,
		0x3A98, 0x00000000,
		0x3A9C, 0x00000000,
		0x3AA0, 0x00000000,
		0x3AA4, 0x00000000,
		0x3AA8, 0x00000000,
		0x3AAC, 0x00000000,
		0x3AB0, 0x00000000,
		0x3AB4, 0x00000000,
		0x3AB8, 0x00000000,
		0x3ABC, 0x00000000,
		0x3AC0, 0x00000000,
		0x3AC4, 0x00000000,
		0x3AC8, 0x00000000,
		0x3ACC, 0x00000000,
		0x3AD0, 0x00000000,
		0x3AD4, 0x00000000,
		0x3AD8, 0x00000000,
		0x3ADC, 0x00000000,
		0x3AE0, 0x00000000,
		0x3AE4, 0x00000000,
		0x3AE8, 0x00000000,
		0x3AEC, 0x00000000,
		0x3AF0, 0x00000000,
		0x3AF4, 0x00000000,
		0x3AF8, 0x00000000,
		0x3AFC, 0x00000000,
		0x4300, 0x4400FF00,
		0x4304, 0x00008080,
		0x4308, 0x40404040,
		0x430C, 0x0A3F3F3F,
		0x4310, 0x003F3F3F,
		0x4314, 0x007FF000,
		0x4318, 0x0000807F,
		0x431C, 0x0076280A,
		0x4320, 0x02880100,
		0x4324, 0x807F807F,
		0x4328, 0x42280200,
		0x432C, 0x1000FF50,
		0x4330, 0x00000800,
		0x4334, 0x00000000,
		0x4338, 0x00000800,
		0x433C, 0x00000000,
		0x4340, 0x00000800,
		0x4344, 0x00000000,
		0x4348, 0x00000800,
		0x434C, 0x00000000,
		0x4350, 0x00000000,
		0x4354, 0x00000000,
		0x4358, 0x00000000,
		0x435C, 0x00000000,
		0x4360, 0x01F1F1F0,
		0x4364, 0x00000000,
		0x4368, 0x00000000,
		0x436C, 0x00000000,
		0x4370, 0x001F1F1F,
		0x4374, 0x00000000,
		0x4378, 0x00000000,
		0x437C, 0x00000000,
		0x4380, 0x00000002,
		0x4384, 0x100000FF,
		0x4388, 0x00000000,
		0x438C, 0x80804040,
		0x4390, 0x80804040,
		0x4394, 0x80804040,
		0x4398, 0x80804040,
		0x439C, 0x00080801,
		0x43A0, 0x00000000,
		0x43A4, 0x00010000,
		0x43A8, 0x7747FD00,
		0x43AC, 0x00004040,
		0x43B0, 0x00000000,
		0x43B4, 0x00000000,
		0x43B8, 0x00000000,
		0x43BC, 0x00000000,
		0x43C0, 0x00000000,
		0x43C4, 0x00000000,
		0x43C8, 0x00000000,
		0x43CC, 0x00000000,
		0x43D0, 0x00000000,
		0x43D4, 0x00000000,
		0x43D8, 0x00000000,
		0x43DC, 0x00000000,
		0x43E0, 0x00000000,
		0x43E4, 0x00000000,
		0x43E8, 0x00000000,
		0x43EC, 0x00000000,
		0x43F0, 0x00000000,
		0x43F4, 0x00000000,
		0x43F8, 0x00000000,
		0x43FC, 0x00000000,
		0x1830, 0x700B8041,
		0x1830, 0x700B8041,
		0x1830, 0x701F0041,
		0x1830, 0x702F0041,
		0x1830, 0x703F0041,
		0x1830, 0x704F0041,
		0x1830, 0x705B8041,
		0x1830, 0x706F0041,
		0x1830, 0x707B8041,
		0x1830, 0x708B8041,
		0x1830, 0x709B8041,
		0x1830, 0x70AB8041,
		0x1830, 0x70BB8041,
		0x1830, 0x70CB8041,
		0x1830, 0x70DB8041,
		0x1830, 0x70EB8041,
		0x1830, 0x70FB8041,
		0x1830, 0x70FB8041,
		0x1A00, 0x027847CF,
		0x1A04, 0x3357A6B1,
		0x1A08, 0x1F2AF412,
		0x1A0C, 0x0009717D,
		0x1A10, 0x00FB9003,
		0x1A14, 0x00FB1FA5,
		0x1A18, 0x00FE2FCA,
		0x1A1C, 0x00FFCFF3,
		0x1A20, 0x3005298E,
		0x1A24, 0x92552970,
		0x1A28, 0x0E06318A,
		0x1A2C, 0x41E6318A,
		0x1A30, 0x65039CE7,
		0x1A34, 0x20A39CE7,
		0x1A38, 0x27E29E20,
		0x1A3C, 0x9A465554,
		0x1A40, 0x092492FD,
		0x1A44, 0x24003F81,
		0x1A48, 0x900983FF,
		0x1A4C, 0x78F05327,
		0x1A50, 0x0F0A1111,
		0x1A54, 0xEA30D90F,
		0x1A5C, 0x00000000,
		0x1A58, 0x01C00000,
		0x1A60, 0x0001FFFF,
		0x1A64, 0x3F800580,
		0x1A68, 0xAE185340,
		0x1A6C, 0xE1A480A3,
		0x1A70, 0x00000010,
		0x1A74, 0x00000000,
		0x1A78, 0x00000000,
		0x1A7C, 0x00000000,
		0x1A80, 0x00000000,
		0x1A84, 0x00000000,
		0x1A88, 0x00000000,
		0x1A8C, 0x00000000,
		0x1A90, 0x00000000,
		0x1A94, 0x00000000,
		0x1A98, 0x00000000,
		0x1A9C, 0x00000000,
		0x1AA0, 0x00000000,
		0x1AA4, 0x00000000,
		0x1AA8, 0x00000000,
		0x1AAC, 0x00000000,
		0x1AB0, 0x00000000,
		0x1AB4, 0x00000000,
		0x1AB8, 0x00000000,
		0x1ABC, 0x00000000,
		0x1AC0, 0x00000000,
		0x1AC4, 0x00000000,
		0x1AC8, 0x00000000,
		0x1ACC, 0x00000000,
		0x1AD0, 0x00000000,
		0x1AD4, 0x00000000,
		0x1AD8, 0x00000000,
		0x1ADC, 0x00000000,
		0x1AE0, 0x00000000,
		0x1AE4, 0x00000000,
		0x1AE8, 0x00000000,
		0x1AEC, 0x00000000,
		0x1AF0, 0x00000000,
		0x1AF4, 0x00000000,
		0x1AF8, 0x00000000,
		0x1AFC, 0x00000000,
		0x2A00, 0x04001418,
		0x2A04, 0x00010000,
		0x2A08, 0x0C700022,
		0x2A0C, 0x03020100,
		0x2A10, 0x07060504,
		0x2A14, 0x0B0A0908,
		0x2A18, 0x0F0E0D0C,
		0x2A1C, 0x13121110,
		0x2A20, 0x17161514,
		0x2A24, 0x00000000,
		0x2A28, 0x0005298F,
		0x2A2C, 0x0005296E,
		0x2A30, 0x0FF8A057,
		0x2A34, 0x00600000,
		0x2A38, 0x09CE0000,
		0x2A3C, 0x00027C00,
		0x2A40, 0x00002902,
		0x2A44, 0x80200311,
		0x2A48, 0x00040FFE,
		0x2A4C, 0x03C00000,
		0x2A50, 0x00C80064,
		0x2A54, 0x0190012C,
		0x2A58, 0x001917DE,
		0x1D0C, 0x00400000,
		0x1D0C, 0x00410000,

};

void
odm_read_and_config_mp_8723f_phy_reg(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len =
			sizeof(array_mp_8723f_phy_reg) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8723f_phy_reg;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_bb_phy_8723f(dm, v1, MASKDWORD, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8723f_phy_reg(void)
{
		return 24;
}

/******************************************************************************
 *                           phy_reg_pg.TXT
 ******************************************************************************/

#ifdef CONFIG_8723F
const u32 array_mp_8723f_phy_reg_pg[] = {
	0, 0, 0, 0x00000c20, 0xffffffff, 0x54545454,
	0, 0, 0, 0x00000c24, 0xffffffff, 0x50505454,
	0, 0, 0, 0x00000c28, 0xffffffff, 0x4c4c4c50,
	0, 0, 0, 0x00000c2c, 0xffffffff, 0x4c4c5050,
	0, 0, 0, 0x00000c30, 0xffffffff, 0x4848484c,
	0, 1, 0, 0x00000e20, 0xffffffff, 0x54545454,
	0, 1, 0, 0x00000e24, 0xffffffff, 0x50505454,
	0, 1, 0, 0x00000e28, 0xffffffff, 0x4c4c4c50,
	0, 1, 0, 0x00000e2c, 0xffffffff, 0x4c4c5050,
	0, 1, 0, 0x00000e30, 0xffffffff, 0x4848484c,
	1, 0, 0, 0x00000c24, 0xffffffff, 0x48484c4c,
	1, 0, 0, 0x00000c28, 0xffffffff, 0x44444448,
	1, 0, 0, 0x00000c2c, 0xffffffff, 0x44444848,
	1, 0, 0, 0x00000c30, 0xffffffff, 0x40404044
};

#endif

void
odm_read_and_config_mp_8723f_phy_reg_pg(struct dm_struct *dm)
{
#ifdef CONFIG_8723F

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8723f_phy_reg_pg) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8723f_phy_reg_pg;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 2;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8723f(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

#endif /* end of HWIMG_SUPPORT*/

