/******************************************************************************
 *
 * Copyright(c) 2007 - 2017 Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * The full GNU General Public License is included in this distribution in the
 * file called LICENSE.
 *
 * Contact Information:
 * wlanfae <wlanfae@realtek.com>
 * Realtek Corporation, No. 2, Innovation Road II, Hsinchu Science Park,
 * Hsinchu 300, Taiwan.
 *
 * Larry Finger <Larry.Finger@lwfinger.net>
 *
 *****************************************************************************/

#include "mp_precomp.h"
#include "../phydm_precomp.h"

#if (RTL8814B_SUPPORT == 1)
static boolean
check_positive(struct dm_struct *dm,
	       const u32	condition1,
	       const u32	condition2,
	       const u32	condition3,
	       const u32	condition4
)
{
	u32	cond1 = condition1, cond2 = condition2,
		cond3 = condition3, cond4 = condition4;

	u8	cut_version_for_para =
		(dm->cut_version ==  ODM_CUT_A) ? 15 : dm->cut_version;

	u8	pkg_type_for_para =
		(dm->package_type == 0) ? 15 : dm->package_type;

	u32	driver1 = cut_version_for_para << 24 |
			(dm->support_interface & 0xF0) << 16 |
			dm->support_platform << 16 |
			pkg_type_for_para << 12 |
			(dm->support_interface & 0x0F) << 8  |
			dm->rfe_type;

	u32	driver2 = (dm->type_glna & 0xFF) <<  0 |
			(dm->type_gpa & 0xFF)  <<  8 |
			(dm->type_alna & 0xFF) << 16 |
			(dm->type_apa & 0xFF)  << 24;

	u32	driver3 = 0;

	u32	driver4 = (dm->type_glna & 0xFF00) >>  8 |
			(dm->type_gpa & 0xFF00) |
			(dm->type_alna & 0xFF00) << 8 |
			(dm->type_apa & 0xFF00)  << 16;

	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "===> %s (cond1, cond2, cond3, cond4) = (0x%X 0x%X 0x%X 0x%X)\n",
		  __func__, cond1, cond2, cond3, cond4);
	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "===> %s (driver1, driver2, driver3, driver4) = (0x%X 0x%X 0x%X 0x%X)\n",
		  __func__, driver1, driver2, driver3, driver4);

	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "	(Platform, Interface) = (0x%X, 0x%X)\n",
		  dm->support_platform, dm->support_interface);
	PHYDM_DBG(dm, ODM_COMP_INIT, "	(RFE, Package) = (0x%X, 0x%X)\n",
		  dm->rfe_type, dm->package_type);

	/*============== value Defined Check ===============*/
	/*cut version [27:24] need to do value check*/
	if (((cond1 & 0x0F000000) != 0) &&
	    ((cond1 & 0x0F000000) != (driver1 & 0x0F000000)))
		return false;

	/*pkg type [15:12] need to do value check*/
	if (((cond1 & 0x0000F000) != 0) &&
	    ((cond1 & 0x0000F000) != (driver1 & 0x0000F000)))
		return false;

	/*interface [11:8] need to do value check*/
	if (((cond1 & 0x00000F00) != 0) &&
	    ((cond1 & 0x00000F00) != (driver1 & 0x00000F00)))
		return false;
	/*=============== Bit Defined Check ================*/
	/* We don't care [31:28] */

	cond1 &= 0x000000FF;
	driver1 &= 0x000000FF;

	if (cond1 == driver1)
		return true;
	else
		return false;
}


/******************************************************************************
 *                           extra_agc_tab
 ******************************************************************************/

const u32 array_8814b_cutc_rfe0_tab67_2g[] = {
		0x1D90, 0x3180007f,
		0x1D90, 0x3181007f,
		0x1D90, 0x3182007f,
		0x1D90, 0x3183007f,
		0x1D90, 0x3184007f,
		0x1D90, 0x3185007f,
		0x1D90, 0x3186007f,
		0x1D90, 0x3187007f,
		0x1D90, 0x3188007f,
		0x1D90, 0x3189007f,
		0x1D90, 0x318a007f,
		0x1D90, 0x318b007f,
		0x1D90, 0x318c007f,
		0x1D90, 0x318d007f,
		0x1D90, 0x318e007f,
		0x1D90, 0x318f007f,
		0x1D90, 0x3190007f,
		0x1D90, 0x3191007f,
		0x1D90, 0x3192007f,
		0x1D90, 0x3193007f,
		0x1D90, 0x3194007f,
		0x1D90, 0x3195007e,
		0x1D90, 0x3196007d,
		0x1D90, 0x3197007c,
		0x1D90, 0x3198007b,
		0x1D90, 0x3199007a,
		0x1D90, 0x319a0079,
		0x1D90, 0x319b0078,
		0x1D90, 0x319c0077,
		0x1D90, 0x319d0076,
		0x1D90, 0x319e0075,
		0x1D90, 0x319f0074,
		0x1D90, 0x31a00073,
		0x1D90, 0x31a10072,
		0x1D90, 0x31a20071,
		0x1D90, 0x31a30070,
		0x1D90, 0x31a4006f,
		0x1D90, 0x31a5006e,
		0x1D90, 0x31a6006d,
		0x1D90, 0x31a7006c,
		0x1D90, 0x31a8006b,
		0x1D90, 0x31a9006a,
		0x1D90, 0x31aa0069,
		0x1D90, 0x31ab0068,
		0x1D90, 0x31ac0067,
		0x1D90, 0x31ad0066,
		0x1D90, 0x31ae0065,
		0x1D90, 0x31af0064,
		0x1D90, 0x31b00063,
		0x1D90, 0x31b10062,
		0x1D90, 0x31b20045,
		0x1D90, 0x31b30044,
		0x1D90, 0x31b40043,
		0x1D90, 0x31b50042,
		0x1D90, 0x31b60041,
		0x1D90, 0x31b70024,
		0x1D90, 0x31b80023,
		0x1D90, 0x31b90006,
		0x1D90, 0x31ba0021,
		0x1D90, 0x31bb0004,
		0x1D90, 0x31bc0003,
		0x1D90, 0x31bd0002,
		0x1D90, 0x31be0001,
		0x1D90, 0x31bf0000,
		0x1D90, 0x31c0007f,
		0x1D90, 0x31c1007f,
		0x1D90, 0x31c2007f,
		0x1D90, 0x31c3007f,
		0x1D90, 0x31c4007f,
		0x1D90, 0x31c5007f,
		0x1D90, 0x31c6007f,
		0x1D90, 0x31c7007f,
		0x1D90, 0x31c8007f,
		0x1D90, 0x31c9007f,
		0x1D90, 0x31ca007f,
		0x1D90, 0x31cb007f,
		0x1D90, 0x31cc007f,
		0x1D90, 0x31cd007f,
		0x1D90, 0x31ce007f,
		0x1D90, 0x31cf007f,
		0x1D90, 0x31d0007f,
		0x1D90, 0x31d1007f,
		0x1D90, 0x31d2007f,
		0x1D90, 0x31d3007f,
		0x1D90, 0x31d4007f,
		0x1D90, 0x31d5007e,
		0x1D90, 0x31d6007d,
		0x1D90, 0x31d7007c,
		0x1D90, 0x31d8007b,
		0x1D90, 0x31d9007a,
		0x1D90, 0x31da0079,
		0x1D90, 0x31db0078,
		0x1D90, 0x31dc0077,
		0x1D90, 0x31dd0076,
		0x1D90, 0x31de0075,
		0x1D90, 0x31df0074,
		0x1D90, 0x31e00073,
		0x1D90, 0x31e10072,
		0x1D90, 0x31e20071,
		0x1D90, 0x31e30070,
		0x1D90, 0x31e4006f,
		0x1D90, 0x31e5006e,
		0x1D90, 0x31e6006d,
		0x1D90, 0x31e7006c,
		0x1D90, 0x31e8006b,
		0x1D90, 0x31e9006a,
		0x1D90, 0x31ea0069,
		0x1D90, 0x31eb0068,
		0x1D90, 0x31ec0067,
		0x1D90, 0x31ed0066,
		0x1D90, 0x31ee0065,
		0x1D90, 0x31ef0064,
		0x1D90, 0x31f00063,
		0x1D90, 0x31f10062,
		0x1D90, 0x31f20045,
		0x1D90, 0x31f30044,
		0x1D90, 0x31f40043,
		0x1D90, 0x31f50042,
		0x1D90, 0x31f60041,
		0x1D90, 0x31f70024,
		0x1D90, 0x31f80023,
		0x1D90, 0x31f90006,
		0x1D90, 0x31fa0021,
		0x1D90, 0x31fb0004,
		0x1D90, 0x31fc0003,
		0x1D90, 0x31fd0002,
		0x1D90, 0x31fe0001,
		0x1D90, 0x31ff0000,
};

const u32 array_8814b_cutc_rfe0_tab67_5gl[] = {
		0x1D90, 0x3180007f,
		0x1D90, 0x3181007f,
		0x1D90, 0x3182007f,
		0x1D90, 0x3183007f,
		0x1D90, 0x3184007f,
		0x1D90, 0x3185007f,
		0x1D90, 0x3186007f,
		0x1D90, 0x3187007f,
		0x1D90, 0x3188007f,
		0x1D90, 0x3189007f,
		0x1D90, 0x318a007f,
		0x1D90, 0x318b007f,
		0x1D90, 0x318c007f,
		0x1D90, 0x318d007f,
		0x1D90, 0x318e007f,
		0x1D90, 0x318f007e,
		0x1D90, 0x3190007d,
		0x1D90, 0x3191007c,
		0x1D90, 0x3192007b,
		0x1D90, 0x3193007a,
		0x1D90, 0x31940079,
		0x1D90, 0x31950078,
		0x1D90, 0x31960077,
		0x1D90, 0x31970076,
		0x1D90, 0x31980075,
		0x1D90, 0x31990074,
		0x1D90, 0x319a0073,
		0x1D90, 0x319b0072,
		0x1D90, 0x319c0071,
		0x1D90, 0x319d0070,
		0x1D90, 0x319e006f,
		0x1D90, 0x319f006e,
		0x1D90, 0x31a0006d,
		0x1D90, 0x31a1006c,
		0x1D90, 0x31a2006b,
		0x1D90, 0x31a3006a,
		0x1D90, 0x31a40069,
		0x1D90, 0x31a50068,
		0x1D90, 0x31a60067,
		0x1D90, 0x31a70066,
		0x1D90, 0x31a80065,
		0x1D90, 0x31a90064,
		0x1D90, 0x31aa0063,
		0x1D90, 0x31ab0062,
		0x1D90, 0x31ac0061,
		0x1D90, 0x31ad0045,
		0x1D90, 0x31ae0044,
		0x1D90, 0x31af0043,
		0x1D90, 0x31b00042,
		0x1D90, 0x31b10025,
		0x1D90, 0x31b20024,
		0x1D90, 0x31b30023,
		0x1D90, 0x31b40022,
		0x1D90, 0x31b50005,
		0x1D90, 0x31b60004,
		0x1D90, 0x31b70003,
		0x1D90, 0x31b80002,
		0x1D90, 0x31b90001,
		0x1D90, 0x31ba0000,
		0x1D90, 0x31bb0000,
		0x1D90, 0x31bc0000,
		0x1D90, 0x31bd0000,
		0x1D90, 0x31be0000,
		0x1D90, 0x31bf0000,
		0x1D90, 0x31c0007f,
		0x1D90, 0x31c1007f,
		0x1D90, 0x31c2007f,
		0x1D90, 0x31c3007f,
		0x1D90, 0x31c4007f,
		0x1D90, 0x31c5007f,
		0x1D90, 0x31c6007f,
		0x1D90, 0x31c7007f,
		0x1D90, 0x31c8007f,
		0x1D90, 0x31c9007f,
		0x1D90, 0x31ca007f,
		0x1D90, 0x31cb007f,
		0x1D90, 0x31cc007f,
		0x1D90, 0x31cd007f,
		0x1D90, 0x31ce007f,
		0x1D90, 0x31cf007e,
		0x1D90, 0x31d0007d,
		0x1D90, 0x31d1007c,
		0x1D90, 0x31d2007b,
		0x1D90, 0x31d3007a,
		0x1D90, 0x31d40079,
		0x1D90, 0x31d50078,
		0x1D90, 0x31d60077,
		0x1D90, 0x31d70076,
		0x1D90, 0x31d80075,
		0x1D90, 0x31d90074,
		0x1D90, 0x31da0073,
		0x1D90, 0x31db0072,
		0x1D90, 0x31dc0071,
		0x1D90, 0x31dd0070,
		0x1D90, 0x31de006f,
		0x1D90, 0x31df006e,
		0x1D90, 0x31e0006d,
		0x1D90, 0x31e1006c,
		0x1D90, 0x31e2006b,
		0x1D90, 0x31e3006a,
		0x1D90, 0x31e40069,
		0x1D90, 0x31e50068,
		0x1D90, 0x31e60067,
		0x1D90, 0x31e70066,
		0x1D90, 0x31e80065,
		0x1D90, 0x31e90064,
		0x1D90, 0x31ea0063,
		0x1D90, 0x31eb0062,
		0x1D90, 0x31ec0061,
		0x1D90, 0x31ed0045,
		0x1D90, 0x31ee0044,
		0x1D90, 0x31ef0043,
		0x1D90, 0x31f00042,
		0x1D90, 0x31f10025,
		0x1D90, 0x31f20024,
		0x1D90, 0x31f30023,
		0x1D90, 0x31f40022,
		0x1D90, 0x31f50005,
		0x1D90, 0x31f60004,
		0x1D90, 0x31f70003,
		0x1D90, 0x31f80002,
		0x1D90, 0x31f90001,
		0x1D90, 0x31fa0000,
		0x1D90, 0x31fb0000,
		0x1D90, 0x31fc0000,
		0x1D90, 0x31fd0000,
		0x1D90, 0x31fe0000,
		0x1D90, 0x31ff0000,
};

const u32 array_8814b_cutc_rfe0_tab67_5gm[] = {
		0x1D90, 0x3180007f,
		0x1D90, 0x3181007f,
		0x1D90, 0x3182007f,
		0x1D90, 0x3183007f,
		0x1D90, 0x3184007f,
		0x1D90, 0x3185007f,
		0x1D90, 0x3186007f,
		0x1D90, 0x3187007f,
		0x1D90, 0x3188007f,
		0x1D90, 0x3189007f,
		0x1D90, 0x318a007f,
		0x1D90, 0x318b007f,
		0x1D90, 0x318c007f,
		0x1D90, 0x318d007f,
		0x1D90, 0x318e007e,
		0x1D90, 0x318f007d,
		0x1D90, 0x3190007c,
		0x1D90, 0x3191007b,
		0x1D90, 0x3192007a,
		0x1D90, 0x31930079,
		0x1D90, 0x31940078,
		0x1D90, 0x31950077,
		0x1D90, 0x31960076,
		0x1D90, 0x31970075,
		0x1D90, 0x31980074,
		0x1D90, 0x31990073,
		0x1D90, 0x319a0072,
		0x1D90, 0x319b0071,
		0x1D90, 0x319c0070,
		0x1D90, 0x319d006f,
		0x1D90, 0x319e006e,
		0x1D90, 0x319f006d,
		0x1D90, 0x31a0006c,
		0x1D90, 0x31a1006b,
		0x1D90, 0x31a2006a,
		0x1D90, 0x31a30069,
		0x1D90, 0x31a40068,
		0x1D90, 0x31a50067,
		0x1D90, 0x31a60066,
		0x1D90, 0x31a70065,
		0x1D90, 0x31a80064,
		0x1D90, 0x31a90063,
		0x1D90, 0x31aa0062,
		0x1D90, 0x31ab0061,
		0x1D90, 0x31ac0045,
		0x1D90, 0x31ad0044,
		0x1D90, 0x31ae0043,
		0x1D90, 0x31af0042,
		0x1D90, 0x31b00025,
		0x1D90, 0x31b10024,
		0x1D90, 0x31b20023,
		0x1D90, 0x31b30022,
		0x1D90, 0x31b40021,
		0x1D90, 0x31b50004,
		0x1D90, 0x31b60003,
		0x1D90, 0x31b70002,
		0x1D90, 0x31b80001,
		0x1D90, 0x31b90000,
		0x1D90, 0x31ba0000,
		0x1D90, 0x31bb0000,
		0x1D90, 0x31bc0000,
		0x1D90, 0x31bd0000,
		0x1D90, 0x31be0000,
		0x1D90, 0x31bf0000,
		0x1D90, 0x31c0007f,
		0x1D90, 0x31c1007f,
		0x1D90, 0x31c2007f,
		0x1D90, 0x31c3007f,
		0x1D90, 0x31c4007f,
		0x1D90, 0x31c5007f,
		0x1D90, 0x31c6007f,
		0x1D90, 0x31c7007f,
		0x1D90, 0x31c8007f,
		0x1D90, 0x31c9007f,
		0x1D90, 0x31ca007f,
		0x1D90, 0x31cb007f,
		0x1D90, 0x31cc007f,
		0x1D90, 0x31cd007f,
		0x1D90, 0x31ce007e,
		0x1D90, 0x31cf007d,
		0x1D90, 0x31d0007c,
		0x1D90, 0x31d1007b,
		0x1D90, 0x31d2007a,
		0x1D90, 0x31d30079,
		0x1D90, 0x31d40078,
		0x1D90, 0x31d50077,
		0x1D90, 0x31d60076,
		0x1D90, 0x31d70075,
		0x1D90, 0x31d80074,
		0x1D90, 0x31d90073,
		0x1D90, 0x31da0072,
		0x1D90, 0x31db0071,
		0x1D90, 0x31dc0070,
		0x1D90, 0x31dd006f,
		0x1D90, 0x31de006e,
		0x1D90, 0x31df006d,
		0x1D90, 0x31e0006c,
		0x1D90, 0x31e1006b,
		0x1D90, 0x31e2006a,
		0x1D90, 0x31e30069,
		0x1D90, 0x31e40068,
		0x1D90, 0x31e50067,
		0x1D90, 0x31e60066,
		0x1D90, 0x31e70065,
		0x1D90, 0x31e80064,
		0x1D90, 0x31e90063,
		0x1D90, 0x31ea0062,
		0x1D90, 0x31eb0061,
		0x1D90, 0x31ec0045,
		0x1D90, 0x31ed0044,
		0x1D90, 0x31ee0043,
		0x1D90, 0x31ef0042,
		0x1D90, 0x31f00025,
		0x1D90, 0x31f10024,
		0x1D90, 0x31f20023,
		0x1D90, 0x31f30022,
		0x1D90, 0x31f40021,
		0x1D90, 0x31f50004,
		0x1D90, 0x31f60003,
		0x1D90, 0x31f70002,
		0x1D90, 0x31f80001,
		0x1D90, 0x31f90000,
		0x1D90, 0x31fa0000,
		0x1D90, 0x31fb0000,
		0x1D90, 0x31fc0000,
		0x1D90, 0x31fd0000,
		0x1D90, 0x31fe0000,
		0x1D90, 0x31ff0000,
};

const u32 array_8814b_cutc_rfe0_tab67_5gh[] = {
		0x1D90, 0x3180007f,
		0x1D90, 0x3181007f,
		0x1D90, 0x3182007f,
		0x1D90, 0x3183007f,
		0x1D90, 0x3184007f,
		0x1D90, 0x3185007f,
		0x1D90, 0x3186007f,
		0x1D90, 0x3187007f,
		0x1D90, 0x3188007f,
		0x1D90, 0x3189007f,
		0x1D90, 0x318a007f,
		0x1D90, 0x318b007f,
		0x1D90, 0x318c007f,
		0x1D90, 0x318d007f,
		0x1D90, 0x318e007e,
		0x1D90, 0x318f007d,
		0x1D90, 0x3190007c,
		0x1D90, 0x3191007b,
		0x1D90, 0x3192007a,
		0x1D90, 0x31930079,
		0x1D90, 0x31940078,
		0x1D90, 0x31950077,
		0x1D90, 0x31960076,
		0x1D90, 0x31970075,
		0x1D90, 0x31980074,
		0x1D90, 0x31990073,
		0x1D90, 0x319a0072,
		0x1D90, 0x319b0071,
		0x1D90, 0x319c0070,
		0x1D90, 0x319d006f,
		0x1D90, 0x319e006e,
		0x1D90, 0x319f006d,
		0x1D90, 0x31a0006c,
		0x1D90, 0x31a1006b,
		0x1D90, 0x31a2006a,
		0x1D90, 0x31a30069,
		0x1D90, 0x31a40068,
		0x1D90, 0x31a50067,
		0x1D90, 0x31a60066,
		0x1D90, 0x31a70065,
		0x1D90, 0x31a80064,
		0x1D90, 0x31a90063,
		0x1D90, 0x31aa0062,
		0x1D90, 0x31ab0061,
		0x1D90, 0x31ac0045,
		0x1D90, 0x31ad0044,
		0x1D90, 0x31ae0043,
		0x1D90, 0x31af0025,
		0x1D90, 0x31b00024,
		0x1D90, 0x31b10023,
		0x1D90, 0x31b20022,
		0x1D90, 0x31b30021,
		0x1D90, 0x31b40004,
		0x1D90, 0x31b50003,
		0x1D90, 0x31b60002,
		0x1D90, 0x31b70001,
		0x1D90, 0x31b80000,
		0x1D90, 0x31b90000,
		0x1D90, 0x31ba0000,
		0x1D90, 0x31bb0000,
		0x1D90, 0x31bc0000,
		0x1D90, 0x31bd0000,
		0x1D90, 0x31be0000,
		0x1D90, 0x31bf0000,
		0x1D90, 0x31c0007f,
		0x1D90, 0x31c1007f,
		0x1D90, 0x31c2007f,
		0x1D90, 0x31c3007f,
		0x1D90, 0x31c4007f,
		0x1D90, 0x31c5007f,
		0x1D90, 0x31c6007f,
		0x1D90, 0x31c7007f,
		0x1D90, 0x31c8007f,
		0x1D90, 0x31c9007f,
		0x1D90, 0x31ca007f,
		0x1D90, 0x31cb007f,
		0x1D90, 0x31cc007f,
		0x1D90, 0x31cd007f,
		0x1D90, 0x31ce007e,
		0x1D90, 0x31cf007d,
		0x1D90, 0x31d0007c,
		0x1D90, 0x31d1007b,
		0x1D90, 0x31d2007a,
		0x1D90, 0x31d30079,
		0x1D90, 0x31d40078,
		0x1D90, 0x31d50077,
		0x1D90, 0x31d60076,
		0x1D90, 0x31d70075,
		0x1D90, 0x31d80074,
		0x1D90, 0x31d90073,
		0x1D90, 0x31da0072,
		0x1D90, 0x31db0071,
		0x1D90, 0x31dc0070,
		0x1D90, 0x31dd006f,
		0x1D90, 0x31de006e,
		0x1D90, 0x31df006d,
		0x1D90, 0x31e0006c,
		0x1D90, 0x31e1006b,
		0x1D90, 0x31e2006a,
		0x1D90, 0x31e30069,
		0x1D90, 0x31e40068,
		0x1D90, 0x31e50067,
		0x1D90, 0x31e60066,
		0x1D90, 0x31e70065,
		0x1D90, 0x31e80064,
		0x1D90, 0x31e90063,
		0x1D90, 0x31ea0062,
		0x1D90, 0x31eb0061,
		0x1D90, 0x31ec0045,
		0x1D90, 0x31ed0044,
		0x1D90, 0x31ee0043,
		0x1D90, 0x31ef0025,
		0x1D90, 0x31f00024,
		0x1D90, 0x31f10023,
		0x1D90, 0x31f20022,
		0x1D90, 0x31f30021,
		0x1D90, 0x31f40004,
		0x1D90, 0x31f50003,
		0x1D90, 0x31f60002,
		0x1D90, 0x31f70001,
		0x1D90, 0x31f80000,
		0x1D90, 0x31f90000,
		0x1D90, 0x31fa0000,
		0x1D90, 0x31fb0000,
		0x1D90, 0x31fc0000,
		0x1D90, 0x31fd0000,
		0x1D90, 0x31fe0000,
		0x1D90, 0x31ff0000,
};

const u32 array_8814b_cutc_rfe1_tab67_2g[] = {
		0x1D70, 0x22222222,
		0x1D70, 0x20202020,
};

const u32 array_8814b_cutc_rfe1_tab67_5gl[] = {
		0x1D90, 0x3180005f,
		0x1D90, 0x3181005f,
		0x1D90, 0x3182005f,
		0x1D90, 0x3183005f,
		0x1D90, 0x3184005f,
		0x1D90, 0x3185005f,
		0x1D90, 0x3186005f,
		0x1D90, 0x3187005f,
		0x1D90, 0x3188005f,
		0x1D90, 0x3189005f,
		0x1D90, 0x318a005f,
		0x1D90, 0x318b005f,
		0x1D90, 0x318c005f,
		0x1D90, 0x318d005e,
		0x1D90, 0x318e005d,
		0x1D90, 0x318f005c,
		0x1D90, 0x3190005b,
		0x1D90, 0x3191005a,
		0x1D90, 0x31920059,
		0x1D90, 0x31930058,
		0x1D90, 0x31940057,
		0x1D90, 0x31950056,
		0x1D90, 0x31960055,
		0x1D90, 0x31970054,
		0x1D90, 0x31980053,
		0x1D90, 0x31990052,
		0x1D90, 0x319a0051,
		0x1D90, 0x319b0050,
		0x1D90, 0x319c004f,
		0x1D90, 0x319d004e,
		0x1D90, 0x319e004d,
		0x1D90, 0x319f004c,
		0x1D90, 0x31a0004b,
		0x1D90, 0x31a1004a,
		0x1D90, 0x31a20049,
		0x1D90, 0x31a30048,
		0x1D90, 0x31a40047,
		0x1D90, 0x31a50046,
		0x1D90, 0x31a60045,
		0x1D90, 0x31a70044,
		0x1D90, 0x31a80043,
		0x1D90, 0x31a90042,
		0x1D90, 0x31aa0024,
		0x1D90, 0x31ab0023,
		0x1D90, 0x31ac0022,
		0x1D90, 0x31ad0021,
		0x1D90, 0x31ae0047,
		0x1D90, 0x31af0046,
		0x1D90, 0x31b00045,
		0x1D90, 0x31b10044,
		0x1D90, 0x31b20043,
		0x1D90, 0x31b30026,
		0x1D90, 0x31b40025,
		0x1D90, 0x31b50024,
		0x1D90, 0x31b60023,
		0x1D90, 0x31b70022,
		0x1D90, 0x31b80021,
		0x1D90, 0x31b90020,
		0x1D90, 0x31ba0020,
		0x1D90, 0x31bb0020,
		0x1D90, 0x31bc0020,
		0x1D90, 0x31bd0020,
		0x1D90, 0x31be0020,
		0x1D90, 0x31bf0020,
		0x1D90, 0x31c0005f,
		0x1D90, 0x31c1005f,
		0x1D90, 0x31c2005f,
		0x1D90, 0x31c3005f,
		0x1D90, 0x31c4005f,
		0x1D90, 0x31c5005f,
		0x1D90, 0x31c6005f,
		0x1D90, 0x31c7005f,
		0x1D90, 0x31c8005f,
		0x1D90, 0x31c9005f,
		0x1D90, 0x31ca005f,
		0x1D90, 0x31cb005f,
		0x1D90, 0x31cc005f,
		0x1D90, 0x31cd005e,
		0x1D90, 0x31ce005d,
		0x1D90, 0x31cf005c,
		0x1D90, 0x31d0005b,
		0x1D90, 0x31d1005a,
		0x1D90, 0x31d20059,
		0x1D90, 0x31d30058,
		0x1D90, 0x31d40057,
		0x1D90, 0x31d50056,
		0x1D90, 0x31d60055,
		0x1D90, 0x31d70054,
		0x1D90, 0x31d80053,
		0x1D90, 0x31d90052,
		0x1D90, 0x31da0051,
		0x1D90, 0x31db0050,
		0x1D90, 0x31dc004f,
		0x1D90, 0x31dd004e,
		0x1D90, 0x31de004d,
		0x1D90, 0x31df004c,
		0x1D90, 0x31e0004b,
		0x1D90, 0x31e1004a,
		0x1D90, 0x31e20049,
		0x1D90, 0x31e30048,
		0x1D90, 0x31e40047,
		0x1D90, 0x31e50046,
		0x1D90, 0x31e60045,
		0x1D90, 0x31e70044,
		0x1D90, 0x31e80043,
		0x1D90, 0x31e90042,
		0x1D90, 0x31ea0024,
		0x1D90, 0x31eb0023,
		0x1D90, 0x31ec0022,
		0x1D90, 0x31ed0021,
		0x1D90, 0x31ee0047,
		0x1D90, 0x31ef0046,
		0x1D90, 0x31f00045,
		0x1D90, 0x31f10044,
		0x1D90, 0x31f20043,
		0x1D90, 0x31f30026,
		0x1D90, 0x31f40025,
		0x1D90, 0x31f50024,
		0x1D90, 0x31f60023,
		0x1D90, 0x31f70022,
		0x1D90, 0x31f80021,
		0x1D90, 0x31f90020,
		0x1D90, 0x31fa0020,
		0x1D90, 0x31fb0020,
		0x1D90, 0x31fc0020,
		0x1D90, 0x31fd0020,
		0x1D90, 0x31fe0020,
		0x1D90, 0x31ff0020,
};

const u32 array_8814b_cutc_rfe1_tab67_5gm[] = {
		0x1D90, 0x3180005f,
		0x1D90, 0x3181005f,
		0x1D90, 0x3182005f,
		0x1D90, 0x3183005f,
		0x1D90, 0x3184005f,
		0x1D90, 0x3185005f,
		0x1D90, 0x3186005f,
		0x1D90, 0x3187005f,
		0x1D90, 0x3188005f,
		0x1D90, 0x3189005f,
		0x1D90, 0x318a005f,
		0x1D90, 0x318b005f,
		0x1D90, 0x318c005e,
		0x1D90, 0x318d005d,
		0x1D90, 0x318e005c,
		0x1D90, 0x318f005b,
		0x1D90, 0x3190005a,
		0x1D90, 0x31910059,
		0x1D90, 0x31920058,
		0x1D90, 0x31930057,
		0x1D90, 0x31940056,
		0x1D90, 0x31950055,
		0x1D90, 0x31960054,
		0x1D90, 0x31970053,
		0x1D90, 0x31980052,
		0x1D90, 0x31990051,
		0x1D90, 0x319a0050,
		0x1D90, 0x319b004f,
		0x1D90, 0x319c004e,
		0x1D90, 0x319d004d,
		0x1D90, 0x319e004c,
		0x1D90, 0x319f004b,
		0x1D90, 0x31a0004a,
		0x1D90, 0x31a10049,
		0x1D90, 0x31a20048,
		0x1D90, 0x31a30047,
		0x1D90, 0x31a40046,
		0x1D90, 0x31a50045,
		0x1D90, 0x31a60044,
		0x1D90, 0x31a70043,
		0x1D90, 0x31a80042,
		0x1D90, 0x31a90041,
		0x1D90, 0x31aa0024,
		0x1D90, 0x31ab0023,
		0x1D90, 0x31ac0022,
		0x1D90, 0x31ad0021,
		0x1D90, 0x31ae0046,
		0x1D90, 0x31af0045,
		0x1D90, 0x31b00044,
		0x1D90, 0x31b10043,
		0x1D90, 0x31b20042,
		0x1D90, 0x31b30041,
		0x1D90, 0x31b40040,
		0x1D90, 0x31b50024,
		0x1D90, 0x31b60023,
		0x1D90, 0x31b70022,
		0x1D90, 0x31b80021,
		0x1D90, 0x31b90020,
		0x1D90, 0x31ba0020,
		0x1D90, 0x31bb0020,
		0x1D90, 0x31bc0020,
		0x1D90, 0x31bd0020,
		0x1D90, 0x31be0020,
		0x1D90, 0x31bf0020,
		0x1D90, 0x31c0005f,
		0x1D90, 0x31c1005f,
		0x1D90, 0x31c2005f,
		0x1D90, 0x31c3005f,
		0x1D90, 0x31c4005f,
		0x1D90, 0x31c5005f,
		0x1D90, 0x31c6005f,
		0x1D90, 0x31c7005f,
		0x1D90, 0x31c8005f,
		0x1D90, 0x31c9005f,
		0x1D90, 0x31ca005f,
		0x1D90, 0x31cb005f,
		0x1D90, 0x31cc005e,
		0x1D90, 0x31cd005d,
		0x1D90, 0x31ce005c,
		0x1D90, 0x31cf005b,
		0x1D90, 0x31d0005a,
		0x1D90, 0x31d10059,
		0x1D90, 0x31d20058,
		0x1D90, 0x31d30057,
		0x1D90, 0x31d40056,
		0x1D90, 0x31d50055,
		0x1D90, 0x31d60054,
		0x1D90, 0x31d70053,
		0x1D90, 0x31d80052,
		0x1D90, 0x31d90051,
		0x1D90, 0x31da0050,
		0x1D90, 0x31db004f,
		0x1D90, 0x31dc004e,
		0x1D90, 0x31dd004d,
		0x1D90, 0x31de004c,
		0x1D90, 0x31df004b,
		0x1D90, 0x31e0004a,
		0x1D90, 0x31e10049,
		0x1D90, 0x31e20048,
		0x1D90, 0x31e30047,
		0x1D90, 0x31e40046,
		0x1D90, 0x31e50045,
		0x1D90, 0x31e60044,
		0x1D90, 0x31e70043,
		0x1D90, 0x31e80042,
		0x1D90, 0x31e90041,
		0x1D90, 0x31ea0024,
		0x1D90, 0x31eb0023,
		0x1D90, 0x31ec0022,
		0x1D90, 0x31ed0021,
		0x1D90, 0x31ee0046,
		0x1D90, 0x31ef0045,
		0x1D90, 0x31f00044,
		0x1D90, 0x31f10043,
		0x1D90, 0x31f20042,
		0x1D90, 0x31f30041,
		0x1D90, 0x31f40040,
		0x1D90, 0x31f50024,
		0x1D90, 0x31f60023,
		0x1D90, 0x31f70022,
		0x1D90, 0x31f80021,
		0x1D90, 0x31f90020,
		0x1D90, 0x31fa0020,
		0x1D90, 0x31fb0020,
		0x1D90, 0x31fc0020,
		0x1D90, 0x31fd0020,
		0x1D90, 0x31fe0020,
		0x1D90, 0x31ff0020,
};

const u32 array_8814b_cutc_rfe1_tab67_5gh[] = {
		0x1D90, 0x3180005f,
		0x1D90, 0x3181005f,
		0x1D90, 0x3182005f,
		0x1D90, 0x3183005f,
		0x1D90, 0x3184005f,
		0x1D90, 0x3185005f,
		0x1D90, 0x3186005f,
		0x1D90, 0x3187005f,
		0x1D90, 0x3188005f,
		0x1D90, 0x3189005f,
		0x1D90, 0x318a005f,
		0x1D90, 0x318b005f,
		0x1D90, 0x318c005e,
		0x1D90, 0x318d005d,
		0x1D90, 0x318e005c,
		0x1D90, 0x318f005b,
		0x1D90, 0x3190005a,
		0x1D90, 0x31910059,
		0x1D90, 0x31920058,
		0x1D90, 0x31930057,
		0x1D90, 0x31940056,
		0x1D90, 0x31950055,
		0x1D90, 0x31960054,
		0x1D90, 0x31970053,
		0x1D90, 0x31980052,
		0x1D90, 0x31990051,
		0x1D90, 0x319a0050,
		0x1D90, 0x319b004f,
		0x1D90, 0x319c004e,
		0x1D90, 0x319d004d,
		0x1D90, 0x319e004c,
		0x1D90, 0x319f004b,
		0x1D90, 0x31a0004a,
		0x1D90, 0x31a10049,
		0x1D90, 0x31a20048,
		0x1D90, 0x31a30047,
		0x1D90, 0x31a40046,
		0x1D90, 0x31a50045,
		0x1D90, 0x31a60044,
		0x1D90, 0x31a70043,
		0x1D90, 0x31a80042,
		0x1D90, 0x31a90041,
		0x1D90, 0x31aa0025,
		0x1D90, 0x31ab0024,
		0x1D90, 0x31ac0023,
		0x1D90, 0x31ad0022,
		0x1D90, 0x31ae0046,
		0x1D90, 0x31af0045,
		0x1D90, 0x31b00044,
		0x1D90, 0x31b10043,
		0x1D90, 0x31b20026,
		0x1D90, 0x31b30025,
		0x1D90, 0x31b40024,
		0x1D90, 0x31b50023,
		0x1D90, 0x31b60022,
		0x1D90, 0x31b70021,
		0x1D90, 0x31b80020,
		0x1D90, 0x31b90020,
		0x1D90, 0x31ba0020,
		0x1D90, 0x31bb0020,
		0x1D90, 0x31bc0020,
		0x1D90, 0x31bd0020,
		0x1D90, 0x31be0020,
		0x1D90, 0x31bf0020,
		0x1D90, 0x31c0005f,
		0x1D90, 0x31c1005f,
		0x1D90, 0x31c2005f,
		0x1D90, 0x31c3005f,
		0x1D90, 0x31c4005f,
		0x1D90, 0x31c5005f,
		0x1D90, 0x31c6005f,
		0x1D90, 0x31c7005f,
		0x1D90, 0x31c8005f,
		0x1D90, 0x31c9005f,
		0x1D90, 0x31ca005f,
		0x1D90, 0x31cb005f,
		0x1D90, 0x31cc005e,
		0x1D90, 0x31cd005d,
		0x1D90, 0x31ce005c,
		0x1D90, 0x31cf005b,
		0x1D90, 0x31d0005a,
		0x1D90, 0x31d10059,
		0x1D90, 0x31d20058,
		0x1D90, 0x31d30057,
		0x1D90, 0x31d40056,
		0x1D90, 0x31d50055,
		0x1D90, 0x31d60054,
		0x1D90, 0x31d70053,
		0x1D90, 0x31d80052,
		0x1D90, 0x31d90051,
		0x1D90, 0x31da0050,
		0x1D90, 0x31db004f,
		0x1D90, 0x31dc004e,
		0x1D90, 0x31dd004d,
		0x1D90, 0x31de004c,
		0x1D90, 0x31df004b,
		0x1D90, 0x31e0004a,
		0x1D90, 0x31e10049,
		0x1D90, 0x31e20048,
		0x1D90, 0x31e30047,
		0x1D90, 0x31e40046,
		0x1D90, 0x31e50045,
		0x1D90, 0x31e60044,
		0x1D90, 0x31e70043,
		0x1D90, 0x31e80042,
		0x1D90, 0x31e90041,
		0x1D90, 0x31ea0025,
		0x1D90, 0x31eb0024,
		0x1D90, 0x31ec0023,
		0x1D90, 0x31ed0022,
		0x1D90, 0x31ee0046,
		0x1D90, 0x31ef0045,
		0x1D90, 0x31f00044,
		0x1D90, 0x31f10043,
		0x1D90, 0x31f20026,
		0x1D90, 0x31f30025,
		0x1D90, 0x31f40024,
		0x1D90, 0x31f50023,
		0x1D90, 0x31f60022,
		0x1D90, 0x31f70021,
		0x1D90, 0x31f80020,
		0x1D90, 0x31f90020,
		0x1D90, 0x31fa0020,
		0x1D90, 0x31fb0020,
		0x1D90, 0x31fc0020,
		0x1D90, 0x31fd0020,
		0x1D90, 0x31fe0020,
		0x1D90, 0x31ff0020,
};

void
odm_config_mp_8814b_extra_agc_tab(struct dm_struct *dm, enum odm_rf_band band)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len = 0;	
	u32	*array = NULL;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	if (dm->rfe_type == 1) {
		switch (band) {
		case ODM_RF_BAND_2G:
			array_len = sizeof(AGC_TAB_8814B(_cutc, _rfe1, _tab67, _2g)) /
					   sizeof(u32);
			array = (u32 *)AGC_TAB_8814B(_cutc, _rfe1, _tab67, _2g);
			break;
		case ODM_RF_BAND_5G_LOW:
			array_len = sizeof(AGC_TAB_8814B(_cutc, _rfe1, _tab67, _5gl)) /
					   sizeof(u32);
			array = (u32 *)AGC_TAB_8814B(_cutc, _rfe1, _tab67, _5gl);
			break;
		case ODM_RF_BAND_5G_MID:
			array_len = sizeof(AGC_TAB_8814B(_cutc, _rfe1, _tab67, _5gm)) /
					   sizeof(u32);
			array = (u32 *)AGC_TAB_8814B(_cutc, _rfe1, _tab67, _5gm);
			break;
		case ODM_RF_BAND_5G_HIGH:
			array_len = sizeof(AGC_TAB_8814B(_cutc, _rfe1, _tab67, _5gh)) /
					   sizeof(u32);
			array = (u32 *)AGC_TAB_8814B(_cutc, _rfe1, _tab67, _5gh);
			break;
		default:
			return;
		}
	} else {
		switch (band) {
		case ODM_RF_BAND_2G:
			array_len = sizeof(AGC_TAB_8814B(_cutc, _rfe0, _tab67, _2g)) /
					   sizeof(u32);
			array = (u32 *)AGC_TAB_8814B(_cutc, _rfe0, _tab67, _2g);
			break;
		case ODM_RF_BAND_5G_LOW:
			array_len = sizeof(AGC_TAB_8814B(_cutc, _rfe0, _tab67, _5gl)) /
					   sizeof(u32);
			array = (u32 *)AGC_TAB_8814B(_cutc, _rfe0, _tab67, _5gl);
			break;
		case ODM_RF_BAND_5G_MID:
			array_len = sizeof(AGC_TAB_8814B(_cutc, _rfe0, _tab67, _5gm)) /
					   sizeof(u32);
			array = (u32 *)AGC_TAB_8814B(_cutc, _rfe0, _tab67, _5gm);
			break;
		case ODM_RF_BAND_5G_HIGH:
			array_len = sizeof(AGC_TAB_8814B(_cutc, _rfe0, _tab67, _5gh)) /
					   sizeof(u32);
			array = (u32 *)AGC_TAB_8814B(_cutc, _rfe0, _tab67, _5gh);
			break;
		default:
			return;
		}
	}

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_bb_agc_8814b(dm, v1, MASKDWORD, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8814b_extra_agc_tab(void)
{
		return 1;
}

#endif /* end of EXTRA_AGC_SUPPORT*/

