#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/skbuff.h>
#include <net/rtl/rtw_band_dev.h>

struct band_devinfo band_devInfo;
int (*band_get_dev_status_2G)(struct net_device *dev, struct band_dev_status *dev_status) = NULL;
int (*band_get_dev_status_5G)(struct net_device *dev, struct band_dev_status *dev_status) = NULL;

int band_dev_register(struct net_device *dev, int band)
{
	if(!dev || ((band != DEV_BAND_2G) && (band != DEV_BAND_5G)))
		return -1;

	if(band == DEV_BAND_2G)
	{
		band_devInfo.dev_2G = dev;
	}
	else if(band == DEV_BAND_5G)
	{
		band_devInfo.dev_5G = dev;
	}

	return 0;
}

int band_dev_unregister(struct net_device *dev, int band)
{
	if(!dev || ((band != DEV_BAND_2G) && (band != DEV_BAND_5G)))
		return -1;

	if(band == DEV_BAND_2G)
	{
		band_devInfo.dev_2G = NULL;
	}
	else if(band == DEV_BAND_5G)
	{
		band_devInfo.dev_5G = NULL;
	}

	return 0;
}

int band_check_exist(int band)
{
	int band_exist = 0;

	if((band != DEV_BAND_2G) && (band != DEV_BAND_5G))
		return 0;

	if(band == DEV_BAND_2G)
	{
		if(band_devInfo.dev_5G  && band_get_dev_status_5G)
			band_exist = 1;
	}
	else if(band == DEV_BAND_5G)
	{
		if(band_devInfo.dev_2G && band_get_dev_status_2G)
			band_exist = 1;
	}

	return band_exist;
}

int band_check_ssid_same(int band)
{
	int ret = -1;
	int band_ssid_same = 0;
	struct band_dev_status dev_5G_status, dev_2G_status;

	if((band != DEV_BAND_2G) && (band != DEV_BAND_5G))
		return 0;

	if(band_devInfo.dev_2G && band_devInfo.dev_5G)
	{
		if(band_get_dev_status_5G && band_get_dev_status_2G)
		{
			if(band_get_dev_status_5G(band_devInfo.dev_5G, &dev_5G_status) == 0 &&
				band_get_dev_status_2G(band_devInfo.dev_2G, &dev_2G_status) == 0)
			{
				if(dev_5G_status.ssid && dev_2G_status.ssid)
				{
					if(strlen(dev_5G_status.ssid) == strlen(dev_2G_status.ssid))
					{
						if(strcmp(dev_5G_status.ssid, dev_2G_status.ssid) == 0)
							band_ssid_same = 1;
					}
				}
			}
		}
	}

	return band_ssid_same;
}

int band_check_prefer(int band)
{
	struct band_dev_status dev_status;
	int ret = -1;
	int band_prefer = 0;

	if((band != DEV_BAND_2G) && (band != DEV_BAND_5G))
		return 0;

	if(band == DEV_BAND_2G)
	{
		if(band_devInfo.dev_5G && band_get_dev_status_5G)
			ret = band_get_dev_status_5G(band_devInfo.dev_5G, &dev_status);
	}
	if(band == DEV_BAND_5G)
	{
		if(band_devInfo.dev_2G && band_get_dev_status_2G)
			ret = band_get_dev_status_2G(band_devInfo.dev_2G, &dev_status);
	}

	if(ret == 0)
	{
		if(dev_status.band_prefer)
			band_prefer = 1;
	}

	return band_prefer;
}

int band_check_assoc(int band)
{
	struct band_dev_status dev_status;
	int ret = -1;
	int band_assoc = 0;

	if((band != DEV_BAND_2G) && (band != DEV_BAND_5G))
		return 0;

	if(band == DEV_BAND_2G)
	{
		if(band_devInfo.dev_5G && band_get_dev_status_5G)
			ret = band_get_dev_status_5G(band_devInfo.dev_5G, &dev_status);
	}
	if(band == DEV_BAND_5G)
	{
		if(band_devInfo.dev_2G && band_get_dev_status_2G)
			ret = band_get_dev_status_2G(band_devInfo.dev_2G, &dev_status);
	}

	if(ret == 0)
	{
		if(dev_status.band_assoc)
			band_assoc = 1;
	}

	return band_assoc;
}

EXPORT_SYMBOL(band_get_dev_status_2G);
EXPORT_SYMBOL(band_get_dev_status_5G);
EXPORT_SYMBOL(band_dev_register);
EXPORT_SYMBOL(band_dev_unregister);
EXPORT_SYMBOL(band_check_exist);
EXPORT_SYMBOL(band_check_ssid_same);
EXPORT_SYMBOL(band_check_prefer);
EXPORT_SYMBOL(band_check_assoc);

