#include "rtl8198d_pseudo_trx.h"

#if defined(CONFIG_RTK_L34_FLEETCONNTRACK_ENABLE)
extern int rtk_fc_l2_wlandev_get(unsigned char *mac, struct net_device **wlandev);
#endif

//#if !defined(CONFIG_HWNAT_FLEETCONNTRACK) && !defined(CONFIG_RTL_8198D_TAROKO)
void rtl8198d_wfo_pseudo_wlan_register(struct net_device *dev)
{
	unsigned int i;
	for(i = 0U; i < wfo_wlanmap_size; i++) {
		if((!strncmp(wfo_wlanmap[i].ifname, dev->name, (u32)IFNAMSIZ))) {
			wfo_wlanmap[i].dev_instant = dev;
			return;
		}
	}

	printk("Fail to register dev %s to wfo pseudo wlan table\n", dev->name);
}

void rtl8198d_wfo_pseudo_wlan_unregister(struct net_device *dev)
{
	unsigned int i;
	for(i = 0U; i < wfo_wlanmap_size; i++) {
		if((!strncmp(wfo_wlanmap[i].ifname, dev->name, (u32)IFNAMSIZ))) {
			wfo_wlanmap[i].dev_instant = NULL;
			return;
		}
	}

	printk("Fail to unregister dev %s to wfo pseudo wlan table\n", dev->name);
}

int rtl8198d_wfo_pseudo_wlan_rx(struct sk_buff *skb, struct rx_info *pOriRxInfo)
{
	unsigned int i;
	unsigned int ext_port_id = pOriRxInfo->opts3.bit1.extspa;
	for(i = 0U; i < wfo_wlanmap_size; i++) {
		if(wfo_wlanmap[i].type == TYPE_1_TO_1 && wfo_wlanmap[i].dev_instant && wfo_wlanmap[i].portmap.macExtPortIdx == ext_port_id) {
			skb->dev = wfo_wlanmap[i].dev_instant;
			//skb->protocol = eth_type_trans(skb, skb->dev);
			//netif_rx(skb);
			return RE8670_RX_STOP_SKBNOFREE;
		}
	}

#if defined(CONFIG_RTK_L34_FLEETCONNTRACK_ENABLE)
	{
		// check lut tbl for N-to-1 dev
		struct net_device *wlandev = NULL;
		if (rtk_fc_l2_wlandev_get((skb->data + ETH_ALEN), &wlandev) == 0) {	// sa
			skb->dev = wlandev;
			//skb->protocol = eth_type_trans(skb, skb->dev);
			//netif_rx(skb);
			return RE8670_RX_STOP_SKBNOFREE;
		}
	}
#endif

	//printk("[%s %d] Cannot find corresponding WFO wlan device!\n", __func__, __LINE__);
	return RE8670_RX_CONTINUE;
}
//#endif /* CONFIG_HWNAT_FLEETCONNTRACK */

int rtl8198d_wfo_pseudo_wlan_tx(struct sk_buff *skb, struct net_device *dev)
{
	int ret=0;
	struct tx_info *ptxInfo, txInfo;
	short macportid, macextportid;

	rtl8198d_wfo_wlandev2portidx(dev, &macportid, &macextportid);

	//do nic tx
	ptxInfo = &txInfo;
	memset(ptxInfo, 0, sizeof(struct tx_info));

	GMAC_TXINFO_EOR(ptxInfo)			= 0U;
	GMAC_TXINFO_FS(ptxInfo) 			= 1U;
	GMAC_TXINFO_LS(ptxInfo) 			= 1U;
	if(skb->ip_summed != CHECKSUM_NONE) {
		// CHECKSUM_NONE/Tx: The skb was already checksummed by the protocol, or a checksum is not required.
		GMAC_TXINFO_IPCS(ptxInfo)			= 1U;
		GMAC_TXINFO_L4CS(ptxInfo)			= 1U;
	}
	GMAC_TXINFO_CRC(ptxInfo)			= 1U;
	GMAC_TXINFO_DATA_LENGTH(ptxInfo)	= skb->len;
	GMAC_TXINFO_CPUTAG(ptxInfo) 		= 1U;
		
	GMAC_TXINFO_STAG_AWARE(ptxInfo)	= 1U;
	GMAC_TXINFO_SVLAN_CFI(ptxInfo)		= 0U;
	GMAC_TXINFO_CVLAN_CFI(ptxInfo)		= 0U;
	GMAC_TXINFO_TX_PMASK(ptxInfo)      = (u32)(1<<RTK_WFO_MAC_PORT);

	GMAC_TXINFO_ASPRI(ptxInfo)		= 1U;
	GMAC_TXINFO_KEEP(ptxInfo)		= 0U;
	GMAC_TXINFO_DISLRN(ptxInfo) 		= 1U;
	GMAC_TXINFO_L34_KEEP(ptxInfo)		= 1U;
	GMAC_TXINFO_GMAC_ID(ptxInfo)		    = 0U;
#ifdef CONFIG_RTK_WFO_GMAC2_SHARING
	GMAC_TXINFO_TX_DST_STREAM_ID(ptxInfo) = ((u32)1U << (u32)macextportid);
	GMAC_TXINFO_EXTSPA(ptxInfo) 			= wlan_if_idx + 1U;
#else
	GMAC_TXINFO_EXTSPA(ptxInfo) 			= (u32)macextportid;
#endif

	GMAC_TXINFO_TX_PPPOE_ACTION(ptxInfo)    = 0U;
	GMAC_TXINFO_TX_PPPOE_IDX(ptxInfo)	= 0U;

	ret = re8686_send_with_txInfo(skb, ptxInfo, 0);

	return ret;
}

unsigned char *rtl8198d_wfo_wlandevname(unsigned int vap_idx)
{
	if (vap_idx < wfo_wlanmap_size)
		return wfo_wlanmap[vap_idx].ifname;

	return NULL;
}

unsigned int rtl8198d_wfo_wlandev_idx(unsigned char *name, unsigned int *vap_idx)
{
	unsigned int i = 0U;

	for (i = 0U; i < wfo_wlanmap_size; i++) {
		if (strncmp(name, wfo_wlanmap[i].ifname, (u32)IFNAMSIZ)==0) {
			*vap_idx = i;
			return 1U;
		}
	}
	return 0U;
}

