#ifndef	__RTL8198D_PSEUDO_TRX_H__
#define	__RTL8198D_PSEUDO_TRX_H__

#if defined(CONFIG_RTL8686NIC) && !defined(CONFIG_RTL_8198D_TAROKO)
#include <re8686_rtl9607c.h>
#endif

#include <linux/if.h>
#include <linux/netdevice.h>
#include <linux/skbuff.h>
#include <linux/etherdevice.h>

/*
 * WFO parameter definition
 */
#define RTK_WFO_MAC_PORT 7

#if defined(CONFIG_RTK_WFO) && ((defined(CONFIG_FC_WIFI_TX_GMAC_TRUNKING_SUPPORT) && !defined(CONFIG_FC_WIFI_TX_ONLY_2_GMAC_TRUNKING)) || defined(CONFIG_FC_WIFI_RX_GMAC_TRUNKING_SUPPORT))
#define CONFIG_RTK_WFO_GMAC2_SHARING     1
#endif

typedef struct rtk_wfo_pmap_s
{
	unsigned int macPortIdx;
	unsigned int macExtPortIdx;
}rtk_wfo_pmap_t;

typedef struct rtk_wfo_pseudo_wlan_map_s
{
	unsigned char ifname[IFNAMSIZ];
	rtk_wfo_pmap_t portmap;
	struct net_device *dev_instant;
	unsigned char type;
}rtk_wfo_pseudo_wlan_map_t;

typedef enum rtk_wfo_mac_ext_port_idx_e
{
	RTK_WFO_MAC_EXT_NONE=0,
	RTK_WFO_MAC_EXT_CPU=0,
	RTK_WFO_MAC_EXT_PORT0=1,
	RTK_WFO_MAC_EXT_PORT1=2,
	RTK_WFO_MAC_EXT_PORT2=3,
	RTK_WFO_MAC_EXT_PORT3=4,
	RTK_WFO_MAC_EXT_PORT4=5,
	RTK_WFO_MAC_EXT_PORT5=6,
	RTK_WFO_MAC_EXT_VXD,
	RTK_WFO_MAC_EXT_PORT_MAX
} rtk_wfo_mac_ext_port_idx_t;

#define TYPE_1_TO_1		1
#define TYPE_N_TO_1		2

#define TYPE_ROOT		TYPE_1_TO_1
#define TYPE_VXD		TYPE_1_TO_1

// see rtk_fc_mgr.c
#ifdef CONFIG_RTK_WFO_GMAC2_SHARING
#define WLAN_ROOT_EP	RTK_WFO_MAC_EXT_PORT1
#define WLAN_VAP0_EP	RTK_WFO_MAC_EXT_PORT5
#define WLAN_VAP1_EP	RTK_WFO_MAC_EXT_PORT5
#define WLAN_VAP2_EP	RTK_WFO_MAC_EXT_PORT5
#define WLAN_VAP3_EP	RTK_WFO_MAC_EXT_PORT5
#define WLAN_VAP4_EP	RTK_WFO_MAC_EXT_PORT5
#define WLAN_VAP5_EP	RTK_WFO_MAC_EXT_PORT5
#define WLAN_VAP6_EP	RTK_WFO_MAC_EXT_PORT5

#define TYPE_VAP0		TYPE_N_TO_1
#define TYPE_VAP1		TYPE_N_TO_1
#define TYPE_VAP2		TYPE_N_TO_1
#define TYPE_VAP3		TYPE_N_TO_1
#define TYPE_VAP4		TYPE_N_TO_1
#define TYPE_VAP5		TYPE_N_TO_1
#define TYPE_VAP6		TYPE_N_TO_1
#else
#define WLAN_ROOT_EP	RTK_WFO_MAC_EXT_PORT0
#define WLAN_VAP0_EP	RTK_WFO_MAC_EXT_PORT1
#define WLAN_VAP1_EP	RTK_WFO_MAC_EXT_PORT2
#define WLAN_VAP2_EP	RTK_WFO_MAC_EXT_PORT5
#define WLAN_VAP3_EP	RTK_WFO_MAC_EXT_PORT4
#define WLAN_VAP4_EP	RTK_WFO_MAC_EXT_PORT5
#define WLAN_VAP5_EP	RTK_WFO_MAC_EXT_PORT5
#define WLAN_VAP6_EP	RTK_WFO_MAC_EXT_PORT5

#define TYPE_VAP0		TYPE_1_TO_1
#define TYPE_VAP1		TYPE_1_TO_1
#if defined(CONFIG_WLAN_MBSSID_NUM) && (CONFIG_WLAN_MBSSID_NUM==7)
#define TYPE_VAP2		TYPE_N_TO_1
#else
#define TYPE_VAP2		TYPE_1_TO_1
#endif
#define TYPE_VAP3		TYPE_1_TO_1
#define TYPE_VAP4		TYPE_N_TO_1
#define TYPE_VAP5		TYPE_N_TO_1
#define TYPE_VAP6		TYPE_N_TO_1
#endif
#define WLAN_VXD_EP		RTK_WFO_MAC_EXT_PORT3


#if defined(CONFIG_WFO_OFFLOAD_2G)
 #if defined(CONFIG_2G_ON_WLAN0)
	 #define WLAN_PREFIX	CONFIG_WFO_VIRT_DEVNAME"0"
 #else
	 #define WLAN_PREFIX	CONFIG_WFO_VIRT_DEVNAME"1"
 #endif
#elif defined(CONFIG_WFO_OFFLOAD_5G)
 #if defined(CONFIG_2G_ON_WLAN0)
	 #define WLAN_PREFIX	CONFIG_WFO_VIRT_DEVNAME"1"
 #else
	#define WLAN_PREFIX	CONFIG_WFO_VIRT_DEVNAME"0"
	#endif
#else
	#error "undefined interface!!"
#endif

#if 1
#define WFO_VIRT_ROOT	WLAN_PREFIX
#define WFO_VIRT_VAP0	WLAN_PREFIX"-vap0"
#define WFO_VIRT_VAP1	WLAN_PREFIX"-vap1"
#define WFO_VIRT_VAP2	WLAN_PREFIX"-vap2"
#define WFO_VIRT_VAP3	WLAN_PREFIX"-vap3"
#define WFO_VIRT_VAP4	WLAN_PREFIX"-vap4"
#define WFO_VIRT_VAP5	WLAN_PREFIX"-vap5"
#define WFO_VIRT_VAP6	WLAN_PREFIX"-vap6"
#define WFO_VIRT_VXD	WLAN_PREFIX"-vxd"
#else
#define WFO_VIRT_ROOT	WLAN_PREFIX
#define WFO_VIRT_VAP0	WLAN_PREFIX".1"
#define WFO_VIRT_VAP1	WLAN_PREFIX".3"
#define WFO_VIRT_VAP2	WLAN_PREFIX".4"
#define WFO_VIRT_VAP3	WLAN_PREFIX".5"
#define WFO_VIRT_VAP4	WLAN_PREFIX".6"
#define WFO_VIRT_VAP5	WLAN_PREFIX".7"
#define WFO_VIRT_VAP6	WLAN_PREFIX".8"
#define WFO_VIRT_VXD	WLAN_PREFIX".2"
#endif

/*
 * WFO WLAN Device mapping table
 */
static rtk_wfo_pseudo_wlan_map_t wfo_wlanmap[] =
{
	// #DEV NAME	#CPU PORT ID	#CPU PORT EXT		#ndev	#type
	{WFO_VIRT_ROOT, {RTK_WFO_MAC_PORT, WLAN_ROOT_EP},	NULL,	TYPE_ROOT},
	{WFO_VIRT_VAP0, {RTK_WFO_MAC_PORT, WLAN_VAP0_EP},	NULL, 	TYPE_VAP0},
	{WFO_VIRT_VAP1, {RTK_WFO_MAC_PORT, WLAN_VAP1_EP},	NULL, 	TYPE_VAP1},
	{WFO_VIRT_VAP2, {RTK_WFO_MAC_PORT, WLAN_VAP2_EP},	NULL, 	TYPE_VAP2},
	{WFO_VIRT_VAP3,	{RTK_WFO_MAC_PORT, WLAN_VAP3_EP},	NULL, 	TYPE_VAP3},
	{WFO_VIRT_VAP4,	{RTK_WFO_MAC_PORT, WLAN_VAP4_EP},	NULL, 	TYPE_VAP4},
#if (CONFIG_LIMITED_VAP_NUM > 5)
	{WFO_VIRT_VAP5,	{RTK_WFO_MAC_PORT, WLAN_VAP5_EP},	NULL, 	TYPE_VAP5},
#endif /* CONFIG_LIMITED_VAP_NUM > 5 */
#if (CONFIG_LIMITED_VAP_NUM > 6)
	{WFO_VIRT_VAP6,	{RTK_WFO_MAC_PORT, WLAN_VAP6_EP},	NULL, 	TYPE_VAP6},
#endif /* CONFIG_LIMITED_VAP_NUM > 6 */
#ifdef CONFIG_RTW_REPEATER_MODE_SUPPORT
	{WFO_VIRT_VXD,	{RTK_WFO_MAC_PORT, WLAN_VXD_EP},	NULL, 	TYPE_VXD},
#endif /* CONFIG_RTW_REPEATER_MODE_SUPPORT */
};

static const size_t wfo_wlanmap_size = sizeof(wfo_wlanmap) / sizeof(rtk_wfo_pseudo_wlan_map_t);

unsigned int wlan_if_idx;

static inline int rtl8198d_wfo_wlandev2portidx(struct net_device *dev,
		short *port_idx, short *ext_port_idx)
{
	unsigned int i;

	if (dev == NULL || port_idx == NULL || ext_port_idx == NULL) {
		printk("%s: input parameter error\n", __func__);
		return -1;
	}

	for(i = 0U; i < wfo_wlanmap_size; i++) {
		if((!strncmp(wfo_wlanmap[i].ifname, dev->name, (u32)IFNAMSIZ))) {
			*port_idx = (s16)wfo_wlanmap[i].portmap.macPortIdx;
			*ext_port_idx = (s16)wfo_wlanmap[i].portmap.macExtPortIdx;

			wlan_if_idx = i;
			return 0;
		}
	}

	return -1;
}

#endif /* __RTL8198D_PSEUDO_TRX_H__ */
