#include "wfo_pseudo_trx.h"
#ifdef CONFIG_RTK_SOC_RTL8198D
#include "rtl8198d/rtl8198d_pseudo_trx.c"
#endif

#ifdef CONFIG_RTW_A4_STA
int rtk_wfo_pseudo_wlan_tx(struct sk_buff *skb, struct net_device *dev);
extern int check_srcmac_in_fdb_for_ax_driver(struct net_device *dev, const unsigned char *addr);

__inline static int IS_MCAST(const u8 *da)
{
	if ((*da) & 0x01)
		return 1;
	else
		return 0;
}

int wfo_check_srcmac_for_ax_driver(struct sk_buff *skb)
{
	if (skb && skb->dev) {
		if (skb->dev->netdev_ops->ndo_start_xmit == rtk_wfo_pseudo_wlan_tx) {
			struct wireless_dev *wdev = ndev_to_wdev(skb->dev);

			if (wdev->iftype == (u32)NL80211_IFTYPE_STATION) {
				struct ethhdr *ehdr = (struct ethhdr *)skb->data;

				if ((IS_MCAST(ehdr->h_dest)) &&
					(check_srcmac_in_fdb_for_ax_driver(skb->dev, ehdr->h_source))) {
					kfree_skb(skb);
					return 1;
				}
			}
		}
	}
	return 0;
}

void reg_check_srcmac_for_ax_driver(void)
{
	extern int (*__wfo_check_srcmac_for_ax_driver)(struct sk_buff *skb);
	__wfo_check_srcmac_for_ax_driver = wfo_check_srcmac_for_ax_driver;
}
#endif /* CONFIG_RTW_A4_STA */


//#ifndef CONFIG_HWNAT_FLEETCONNTRACK
// ignore list of net_dev
static int rtk_wfo_pseudo_netif_ignore(char *devName, unsigned long event)
{
	if(strncmp(devName, WFO_WLAN_DEVNAME_PREFIX, strlen(WFO_WLAN_DEVNAME_PREFIX)) == 0)
		return FALSE;

	return TRUE;
}

void rtk_wfo_pseudo_wlan_register(struct net_device *dev)
{
#ifdef CONFIG_RTK_SOC_RTL8198D
	rtl8198d_wfo_pseudo_wlan_register(dev);
#endif
}

void rtk_wfo_pseudo_wlan_unregister(struct net_device *dev)
{
#ifdef CONFIG_RTK_SOC_RTL8198D
	rtl8198d_wfo_pseudo_wlan_unregister(dev);
#endif
}

int rtk_wfo_pseudo_eventHandler_netDev(void *ptr, unsigned long event)
{
	struct net_device *dev = NULL;

	dev = netdev_notifier_info_to_dev(ptr);
	if(rtk_wfo_pseudo_netif_ignore(dev->name,event)) 
		return WFO_PSEUDO_RET_OK;

	switch (event) {
		case NETDEV_REGISTER:
			if (strncmp(WFO_WLAN_DEVNAME_PREFIX, dev->name, strlen(WFO_WLAN_DEVNAME_PREFIX)) == 0) {
				rtk_wfo_pseudo_wlan_register(dev);
			}  
			break;
		case NETDEV_UNREGISTER:
			if (strncmp(WFO_WLAN_DEVNAME_PREFIX, dev->name, strlen(WFO_WLAN_DEVNAME_PREFIX)) == 0) {
				rtk_wfo_pseudo_wlan_unregister(dev);
			}  
			break;
		default:
			return WFO_PSEUDO_RET_OK;
	}

	return WFO_PSEUDO_RET_OK;
}

int rtk_wfo_pseudo_netif_netdev_event(struct notifier_block *this, unsigned long event, void *ptr)
{
	rtk_wfo_pseudo_eventHandler_netDev(ptr, event);

	return NOTIFY_DONE;
}

static struct notifier_block rtk_wfo_pseudo_netif_netdev_notifier = {
	.notifier_call = rtk_wfo_pseudo_netif_netdev_event,
};

int rtk_wfo_pseudo_wlan_rx(struct re_private *cp, struct sk_buff *skb, struct rx_info *pOriRxInfo)
{
	int ret = 0;

#ifdef CONFIG_RTK_SOC_RTL8198D
	ret = rtl8198d_wfo_pseudo_wlan_rx(skb, pOriRxInfo);
#endif

	if (ret == RE8670_RX_STOP_SKBNOFREE) {
#ifdef CONFIG_RTL_ETH_RECYCLED_SKB
		if(skb->recyclable) {
			extern struct sk_buff *recycle_skb_swap(struct sk_buff *skb);
			skb = recycle_skb_swap(skb);
			if (skb == NULL)
				return NET_RX_DROP;
		}
#endif
		skb->protocol = eth_type_trans(skb, skb->dev);

#ifdef CONFIG_RTW_A4_STA
		if (wfo_check_srcmac_for_ax_driver(skb)==0)
			netif_rx(skb);
#else /* !CONFIG_RTW_A4_STA */
		netif_rx(skb);
#endif /* CONFIG_RTW_A4_STA */
	}

	return ret;
}

static int rtk_wfo_pseudo_wifi_rxhook_init(void)
{
	/*register pseudo wifi rx to NIC rx handler*/
	if(drv_nic_register_rxhook((1<<RTK_WFO_MAC_PORT), WFO_WIFIRX_PRI, rtk_wfo_pseudo_wlan_rx) < 0) {
		//printk("WFO pseudo driver rx was fail to reigster nic Rx funciton!\n");
	} 
	
	return 0;
}

void rtk_wfo_pseudo_wlan_init(void)
{
	rtk_wfo_pseudo_wifi_rxhook_init();
	register_netdevice_notifier(&rtk_wfo_pseudo_netif_netdev_notifier);
}
//#endif /* CONFIG_HWNAT_FLEETCONNTRACK */

int rtk_wfo_pseudo_wlan_tx(struct sk_buff *skb, struct net_device *dev)
{
	int ret=0;
#ifdef CONFIG_RTK_SOC_RTL8198D
	if (PE_STATUS->enable_pe_rx == 0) {
		dev_kfree_skb_any(skb);
		return 0;
	}
	ret = rtl8198d_wfo_pseudo_wlan_tx(skb, dev);
#endif

	return 0;
}

