#if (WFO_CFG_DBG_TRACE_OPS==1)
void dbg_trace_ops(void)
{
	int i = 0;

	for (i=0; i<WFO_CMD_MAX; i++) {
		wfo_trace[TRACE_SENDER][i] =
			wfo_trace[TRACE_RECEIVER][i] =
			wfo_trace[TRACE_WRAPPER][i] = 0;
	}

	#if 0
	wfo_trace[TRACE_WRAPPER][WFO_CMD(add_virtual_intf)] = 1;
	wfo_trace[TRACE_WRAPPER][WFO_CMD(del_virtual_intf)] = 1;

	wfo_trace[TRACE_WRAPPER][WFO_CMD(change_beacon)] = 1;
	wfo_trace[TRACE_WRAPPER][WFO_CMD(change_bss)] = 1;
	wfo_trace[TRACE_WRAPPER][WFO_CMD(change_station)] = 1;
	wfo_trace[TRACE_WRAPPER][WFO_CMD(start_ap)] = 1;
	wfo_trace[TRACE_WRAPPER][WFO_CMD(add_key)] = 1;
	wfo_trace[TRACE_WRAPPER][WFO_CMD(add_station)] = 1;
	#endif

	for (i=0; i<WFO_CMD_MAX; i++) {
		wfo_trace[TRACE_SENDER][i] =
			wfo_trace[TRACE_RECEIVER][i] =
			wfo_trace[TRACE_WRAPPER][i];
	}

	return;
}
#endif /* WFO_CFG_DBG_TRACE_OPS */

void wfo_hexdump(const void* data, size_t size)
{
	size_t i;

	printk("===========================================\n");
	printk("<caller: %pf>\n\n", __builtin_return_address(0U));
	for (i=0U; i<size; ++i) {
		printk("%02X ", ((unsigned char*)data)[i]);
		if ((i+1U)%16U == 0U)
			printk("\n");
		else if ((i+1U)%8U == 0U)
			printk("    ");
	}
	if (i!=16U) printk("\n");
	printk("===========================================\n\n");
}

void show_wfo_cfg_size(void)
{
	unsigned int i = 0U;

	printk("\t%8d(%s)\n\n", sizeof(struct wfo_cfg80211_s), "wfo_cfg80211_s");
	for (i=1U; i<WFO_CMD(max); i++)
		printk("\t%8d(%s)\n", wfo_struct_size[i], wfo_cmd_str[i]);
}

void show_wfo_trace_count(void)
{
	unsigned int i = 0U;

#if defined(CPTCFG_WFO_VIRT_SAME_CPU)
	for (i=1U; i<WFO_CMD(max); i++) {
		printk("%s(%s):\n\t"
			"send:%d (in:%u/out:%u)\n\t"
			"recv:%d (in:%u/out:%u)\n",
			wfo_cmd_str[i], (i>=WFO_CMD(cfg80211_new_sta))?"radio":"virt",
			wfo_trace_cnt[SENDER_IN][i] - wfo_trace_cnt[SENDER_OUT][i],
			wfo_trace_cnt[SENDER_IN][i], wfo_trace_cnt[SENDER_OUT][i],
			wfo_trace_cnt[RECEIVER_IN][i] - wfo_trace_cnt[RECEIVER_OUT][i],
			wfo_trace_cnt[RECEIVER_IN][i], wfo_trace_cnt[RECEIVER_OUT][i]);
	}
#elif defined(__ECOS)
	/* Ecos: virt_revc & radio_send */
	for (i=1U; i<WFO_CMD(max); i++) {
		printk("%s:\n\t", wfo_cmd_str[i]);
		if (i < WFO_CMD(cfg80211_new_sta))
			printk("recv:%d (in:%u/out:%u)%s\n",
				wfo_trace_cnt[RECEIVER_IN][i] - wfo_trace_cnt[RECEIVER_OUT][i],
				wfo_trace_cnt[RECEIVER_IN][i], wfo_trace_cnt[RECEIVER_OUT][i],
				(wfo_trace_cnt[RECEIVER_IN][i] - wfo_trace_cnt[RECEIVER_OUT][i])?" has pending":"");
		else
			printk("send:%d (in:%u/out:%u)%s\n",
				wfo_trace_cnt[SENDER_IN][i] - wfo_trace_cnt[SENDER_OUT][i],
				wfo_trace_cnt[SENDER_IN][i], wfo_trace_cnt[SENDER_OUT][i],
				(wfo_trace_cnt[SENDER_IN][i] - wfo_trace_cnt[SENDER_OUT][i])?" has pending":"");
	}
#else
	/* Linux: virt_send & radio_revc */
	for (i=1U; i<WFO_CMD(max); i++) {
		printk("%s:\n\t", wfo_cmd_str[i]);
		if (i < WFO_CMD(cfg80211_new_sta))
			printk("send:%d (in:%u/out:%u)\n",
				wfo_trace_cnt[SENDER_IN][i] - wfo_trace_cnt[SENDER_OUT][i],
				wfo_trace_cnt[SENDER_IN][i], wfo_trace_cnt[SENDER_OUT][i]);
		else
			printk("recv:%d (in:%u/out:%u)\n",
				wfo_trace_cnt[RECEIVER_IN][i] - wfo_trace_cnt[RECEIVER_OUT][i],
				wfo_trace_cnt[RECEIVER_IN][i], wfo_trace_cnt[RECEIVER_OUT][i]);
	}
#endif
}
EXPORT_SYMBOL(show_wfo_trace_count);

