#ifndef __WFO_CMD_DEBUG_H__
#define __WFO_CMD_DEBUG_H__

#if defined(CPTCFG_WFO_VIRT_SAME_CPU)
#define WFO_CFG_DBG_TRACE_OPS 1
#define WFO_DBG_TX 0
#define WFO_DBG_RX 0
#else /* !CPTCFG_WFO_VIRT_SAME_CPU */
#define WFO_CFG_DBG_TRACE_OPS 0
#define WFO_DBG_TX 0
#define WFO_DBG_RX 0
#endif /* CPTCFG_WFO_VIRT_SAME_CPU */

#if defined(CONFIG_SMP)
#define WFO_CFG_SMP 1
#else
#define WFO_CFG_SMP 0
#endif /* CONFIG_SMP */

#define CFG_IS_BUSY (0x987)

void wfo_hexdump(const void* data, size_t size);

//==============================================================================
#if (WFO_CFG_DBG_TRACE_OPS==1)
extern struct cfg80211_ops wrapper_cfg80211_ops;
void dbg_trace_ops(void);

#define WFO_CFG_OPS_TRACE(DIR, CMD) \
	do { \
		if (wfo_trace[TRACE_WRAPPER][CMD]) \
			printk("%s[%s:%d], %s\n", \
			(DIR==TRACE_IN)?"######## ":"<== ", \
			__func__, __LINE__, (DIR==TRACE_IN)?"in":"out"); \
	} while(0);


#define WFO_WRAPPER_OPS_TRACE(DIR, CMD) \
	do { \
		if (wfo_trace[TRACE_WRAPPER][CMD]) \
			printk("%s[%s:%d], %s\n", \
			(DIR==TRACE_IN)?"######## ":"<== ", \
			__func__, __LINE__, (DIR==TRACE_IN)?"in":"out"); \
	} while(0);


#define WFO_SENDER_TRACE(DIR, CMD) \
	do { \
		if (DIR==TRACE_IN) wfo_trace_cnt[SENDER_IN][CMD] += 1U; \
		else wfo_trace_cnt[SENDER_OUT][CMD] += 1U; \
		if (wfo_trace[TRACE_SENDER][CMD]) \
			printk("%s[%s:%d], %s\n", \
			(DIR==TRACE_IN)?"\n\n=>>> ":"<<<= ", \
			__func__, __LINE__, (DIR==TRACE_IN)?"in":"out\n"); \
	} while(0);


#define WFO_RECEIVER_TRACE(DIR, CMD) \
	do { \
		if (DIR==TRACE_IN) wfo_trace_cnt[RECEIVER_IN][CMD] += 1U; \
		else wfo_trace_cnt[RECEIVER_OUT][CMD] += 1U; \
		if (wfo_trace[TRACE_RECEIVER][CMD]) \
		printk("%s[%s:%d], %s\n", \
		(DIR==TRACE_IN)?"=>>> ":"<<<= ", \
		__func__, __LINE__, (DIR==TRACE_IN)?"in":"out"); \
	} while(0);

#else /* !WFO_CFG_DBG_TRACE_OPS */
#define WFO_CFG_OPS_TRACE(DIR, CMD) do {}while(0)
#define WFO_WRAPPER_OPS_TRACE(DIR, CMD) do {}while(0)

#define WFO_SENDER_TRACE(DIR, CMD) \
		do { \
			if (DIR==TRACE_IN) wfo_trace_cnt[SENDER_IN][CMD] += 1U; \
			else wfo_trace_cnt[SENDER_OUT][CMD] += 1U; \
		} while(0);

#define WFO_RECEIVER_TRACE(DIR, CMD) \
		do { \
			if (DIR==TRACE_IN) wfo_trace_cnt[RECEIVER_IN][CMD] += 1U; \
			else wfo_trace_cnt[RECEIVER_OUT][CMD] += 1U; \
		} while(0);

#endif /* WFO_CFG_DBG_TRACE_OPS */

#define WFO_WRAPPER_OPS_TRACE_IN(CMD) \
	WFO_WRAPPER_OPS_TRACE((u32)TRACE_IN, (u32)CMD)

#define WFO_WRAPPER_OPS_TRACE_OUT(CMD) \
	WFO_WRAPPER_OPS_TRACE((u32)TRACE_OUT, (u32)CMD)

#define WFO_SENDER_TRACE_IN(CMD) \
	WFO_SENDER_TRACE((u32)TRACE_IN, (u32)CMD)

#if defined(PLATFORM_ECOS)
#if 1
#define WFO_SENDER_TRACE_OUT(CMD) \
	do { \
		WFO_SENDER_TRACE((u32)TRACE_OUT, (u32)CMD); \
		if (cfg->cmd != WFO_CMD(pass_log)) \
			wfo_cfg80211_unlock((struct net_device *)cfg->ndev); \
	} while (0);
#else
#define WFO_SENDER_TRACE_OUT(CMD) \
		WFO_SENDER_TRACE((u32)TRACE_OUT, (u32)CMD)
#endif
#else /* !PLATFORM_ECOS */
#if (WFO_CFG_SMP==1)
#define WFO_SENDER_TRACE_OUT(CMD) \
	do { \
		WFO_SENDER_TRACE((u32)TRACE_OUT, (u32)CMD); \
		atomic_set(&cfg->busy, 0); \
	} while (0);
#else /* WFO_CFG_SMP!=1  */
#define WFO_SENDER_TRACE_OUT(CMD) \
	WFO_SENDER_TRACE((u32)TRACE_OUT, (u32)CMD)
#endif /* WFO_CFG_SMP==1 */
#endif /* PLATFORM_ECOS */

#define WFO_RECEIVER_TRACE_IN(CMD) \
	WFO_RECEIVER_TRACE((u32)TRACE_IN, (u32)CMD)

#define WFO_RECEIVER_TRACE_OUT(CMD) \
	WFO_RECEIVER_TRACE((u32)TRACE_OUT, (u32)CMD)


//==============================================================================
#if 1
#define WFO_PRINT(fmt, args...) \
	do { \
		printk("<WFO> %s: "fmt, __func__, ## args); \
	} while(0)
#else
#define WFO_PRINT(fmt, args...) \
	do {} while(0)
#endif


#if 0
#define WFO_DBGP(fmt, args...) \
	do { \
		printk("==> [%s:%d] "fmt, __func__, __LINE__, ## args); \
	} while(0)
#else
#define WFO_DBGP(fmt, args...) \
	do {} while(0)
#endif

#define WFO_WARN(fmt, args...) \
	do { \
		printk("\n\n\n\n\n\n<WFO> %s: "fmt"\n\n\n\n\n\n", __func__, ## args); \
	} while(0)

//==============================================================================

#define WFO_DBG_IOCTL 0
#if (WFO_DBG_IOCTL==1)
#define WFO_DBGP_IOCTL(fmt, args...) \
	do { \
		printk("==> [%s:%d] "fmt, __func__, __LINE__, ## args); \
	} while(0)
#else
#define WFO_DBGP_IOCTL(fmt, args...) \
	do {} while(0)
#endif

#define WFO_DBG_CLIENT 0
#if (WFO_DBG_CLIENT==1)
#define WFO_DBGP_CLIENT(fmt, args...) \
	do { \
		printk("==> [%s:%d] "fmt, __func__, __LINE__, ## args); \
	} while(0)
#else
#define WFO_DBGP_CLIENT(fmt, args...) \
	do {} while(0)
#endif

#define WFO_DBG_DEV_FLAGS 0


//==============================================================================
#define WFO_CHECK_STRUCT_SZ
#define WFO_GETMIB_IN_SHM

#define WFO_SYNC_STA_STATUS
#define WFO_SYNC_STA_STATUS_TEST 0

#define WFO_ASYNC_INFORM_BSS
#define USE_GLOBAL_CFG
//==============================================================================

#endif /* __WFO_CMD_DEBUG_H__ */
