#ifndef __WFO_CMD_RADIO_H__
#define __WFO_CMD_RADIO_H__

#include "wfo_cmd_debug.h"

//==============================================================================
//	function prototype
//==============================================================================
struct ieee80211_channel *wfo_ieee80211_get_channel(struct wiphy *wiphy, int freq);

int wfo_ieee80211_frequency_to_channel(int freq);

void wfo_radio_cmd_sender_cfg80211_new_sta(struct net_device *ndev,
		const u8 *mac_addr,
		struct station_info *sinfo,
		gfp_t gfp);

void wfo_radio_cmd_sender_cfg80211_del_sta(struct net_device *radio_ndev,
		const u8 *mac_addr,
		gfp_t gfp);

void wfo_radio_cmd_sender_cfg80211_scan_done(
		struct cfg80211_scan_request *request,
		struct cfg80211_scan_info *info);

struct cfg80211_bss *wfo_radio_cmd_sender_cfg80211_inform_bss_frame(struct wiphy *wiphy,
		struct ieee80211_channel *rx_channel,
		struct ieee80211_mgmt *mgmt, size_t len,
		s32 signal, gfp_t gfp, u32 freq);

void wfo_radio_cmd_sender_cfg80211_put_bss(struct wiphy *wiphy, struct cfg80211_bss *bss);

void wfo_radio_cmd_sender_cfg80211_ch_switch_started_notify(struct net_device *dev,
		struct cfg80211_chan_def *chandef,
		u8 count);

void wfo_radio_cmd_sender_cfg80211_connect_result(struct net_device *ndev,
		const u8 *bssid,
		const u8 *req_ie, size_t req_ie_len,
		const u8 *resp_ie, size_t resp_ie_len,
		u16 status, gfp_t gfp);

struct cfg80211_bss *wfo_radio_cmd_sender_cfg80211_get_bss(struct wiphy *wiphy,
		struct ieee80211_channel *channel,
		const u8 *bssid,
		const u8 *ssid, size_t ssid_len,
		enum ieee80211_bss_type bss_type,
		enum ieee80211_privacy privacy);

///-------------------------------
int wfo_radio_cmd_sender_cfg80211_vendor_cmd_reply(struct sk_buff *skb);

void wfo_radio_cmd_sender_cfg80211_ibss_joined(struct net_device *dev, const u8 *bssid,
		struct ieee80211_channel *channel, gfp_t gfp);

void wfo_radio_cmd_sender_cfg80211_ch_switch_notify(struct net_device *dev,
		struct cfg80211_chan_def *chandef);

void wfo_radio_cmd_sender_cfg80211_ready_on_channel(struct wireless_dev *wdev, u64 cookie,
		struct ieee80211_channel *chan,
		unsigned int duration, gfp_t gfp);

struct sk_buff *wfo_radio_cmd_sender_cfg80211_vendor_cmd_alloc_reply_skb(struct wiphy *wiphy,
		int approxlen);

void wfo_radio_cmd_sender_cfg80211_roamed(struct net_device *dev, struct cfg80211_roam_info *info,
		gfp_t gfp);

void wfo_radio_cmd_sender_cfg80211_mgmt_tx_status(struct wireless_dev *wdev, u64 cookie,
		const u8 *buf, size_t len, bool ack, gfp_t gfp);

bool wfo_radio_cmd_sender_cfg80211_rx_mgmt(struct wireless_dev *wdev, int freq, int sig_dbm,
		const u8 *buf, size_t len, u32 flags);

void wfo_radio_cmd_sender_cfg80211_rx_unprot_mlme_mgmt(struct net_device *dev, const u8 *buf, size_t len);

int wfo_radio_cmd_sender_cfg80211_external_auth_request(struct net_device *dev,
		struct cfg80211_external_auth_params *params, gfp_t gfp);

void wfo_radio_cmd_sender_cfg80211_remain_on_channel_expired(struct wireless_dev *wdev,
		u64 cookie,
		struct ieee80211_channel *chan,
		gfp_t gfp);

void wfo_radio_cmd_sender_cfg80211_unlink_bss(struct wiphy *wiphy, struct cfg80211_bss *bss);

void wfo_radio_cmd_sender_cfg80211_disconnected(struct net_device *ndev, u16 reason,
		const u8 *ie, size_t ie_len,
		bool locally_generated, gfp_t gfp);

void wfo_radio_cmd_sender_cfg80211_vendor_event(struct sk_buff *skb, gfp_t gfp);

void wfo_radio_cmd_sender_cfg80211_michael_mic_failure(struct net_device *dev, const u8 *addr,
		enum nl80211_key_type key_type, int key_id,
		const u8 *tsc, gfp_t gfp);

struct sk_buff *wfo_radio_cmd_sender_cfg80211_vendor_event_alloc(struct wiphy *wiphy,
		struct wireless_dev *wdev, int approxlen, int event_idx, gfp_t gfp);

void wfo_radio_cmd_sender_cfg80211_connect_done(struct net_device *dev,
		struct cfg80211_connect_resp_params *params,
		gfp_t gfp);

void wfo_radio_cmd_sender_netlink_send_msg(struct net_device *ndev, void *msg, u32 msg_len);

#if defined(CONFIG_RTK_WLAN_EVENT_INDICATE)
void wfo_radio_cmd_sender_rtk_eventd_netlink_send(int rtk_eventd_pid, struct sock *nl_eventd_sk, int eventID, char *ifname, char *data, int data_len);
#endif

int wfo_radio_cmd_sender_regulatory_hint(struct wiphy *wiphy,
		const char *alpha2);

void wfo_radio_cmd_sender_wireless_send_event(struct net_device *netdev,
			 unsigned int		cmd,
			 union iwreq_data *	wrqu,
			 const char *		extra);


//==============================================================================
//	radio cmd
//==============================================================================
#if defined(WFO_RADIO_SENDER)
#if !defined(CONFIG_RTK_WFO_NO_VIRT)
#define cfg80211_new_sta(dev, mac_addr, sinfo, gfp) \
		wfo_radio_cmd_sender_cfg80211_new_sta(dev, mac_addr, sinfo, gfp)

#define cfg80211_del_sta(dev, mac_addr, gfp) \
		wfo_radio_cmd_sender_cfg80211_del_sta(dev, mac_addr, gfp)

#define cfg80211_scan_done(request, info) \
		wfo_radio_cmd_sender_cfg80211_scan_done(request, info)

#define cfg80211_inform_bss_frame(wiphy, rx_channel, mgmt, len, signal, gfp, freq) \
		wfo_radio_cmd_sender_cfg80211_inform_bss_frame(wiphy, rx_channel, mgmt, len, signal, gfp, freq)

#define cfg80211_ch_switch_started_notify(dev, chandef, count) \
		wfo_radio_cmd_sender_cfg80211_ch_switch_started_notify(dev, chandef, count)

#ifdef rtw_cfg80211_connect_result
#undef rtw_cfg80211_connect_result
#define rtw_cfg80211_connect_result(wdev, bssid, req_ie, req_ie_len, \
	resp_ie, resp_ie_len, status, gfp) \
	wfo_radio_cmd_sender_cfg80211_connect_result(wdev_to_ndev(wdev), bssid, req_ie, req_ie_len, \
	resp_ie, resp_ie_len, status, gfp)
#endif /* rtw_cfg80211_connect_result */

#define cfg80211_get_bss(wiphy, channel, bssid, ssid, ssid_len, \
			bss_type, privacy) \
		wfo_radio_cmd_sender_cfg80211_get_bss(wiphy, channel, bssid, ssid, ssid_len, \
			bss_type, privacy)

#define cfg80211_put_bss(wiphy, pub) \
		wfo_radio_cmd_sender_cfg80211_put_bss(wiphy, pub)

#define cfg80211_rx_mgmt(wdev , freq , sig_dbm , buf , len , gfp) \
		wfo_radio_cmd_sender_cfg80211_rx_mgmt(wdev , freq , sig_dbm , buf , len , gfp)

#define cfg80211_rx_unprot_mlme_mgmt(dev, buf, len) \
		wfo_radio_cmd_sender_cfg80211_rx_unprot_mlme_mgmt(dev, buf, len)

#define cfg80211_external_auth_request(dev, params, gfp) \
		wfo_radio_cmd_sender_cfg80211_external_auth_request(dev, params, gfp)

#define cfg80211_disconnected(ndev, reason, ie, ie_len, \
			locally_generated, gfp) \
		wfo_radio_cmd_sender_cfg80211_disconnected(ndev, reason, ie, ie_len, \
			locally_generated, gfp)

#define ieee80211_get_channel(wiphy, freq) \
		wfo_ieee80211_get_channel(wiphy, freq)

#define ieee80211_frequency_to_channel(freq) \
		wfo_ieee80211_frequency_to_channel(freq)

#endif /* !CONFIG_RTK_WFO_NO_VIRT */

#define cfg80211_vendor_cmd_reply(skb) \
		wfo_radio_cmd_sender_cfg80211_vendor_cmd_reply(skb)

#define cfg80211_ibss_joined(dev, bssid, channel, gfp) \
		wfo_radio_cmd_sender_cfg80211_ibss_joined(dev, bssid, channel, gfp)

#define cfg80211_ch_switch_notify(dev, chandef) \
		wfo_radio_cmd_sender_cfg80211_ch_switch_notify(dev, chandef)

#define cfg80211_ready_on_channel(wdev, cookie, chan, duration, gfp) \
		wfo_radio_cmd_sender_cfg80211_ready_on_channel(wdev, cookie, chan, duration, gfp)

#define cfg80211_vendor_cmd_alloc_reply_skb(wiphy, approxlen) \
		wfo_radio_cmd_sender_cfg80211_vendor_cmd_alloc_reply_skb(wiphy, approxlen)

#define cfg80211_roamed(dev, info, gfp) \
		wfo_radio_cmd_sender_cfg80211_roamed(dev, info, gfp)

#define cfg80211_mgmt_tx_status(wdev, cookie, buf, len, ack, gfp) \
		wfo_radio_cmd_sender_cfg80211_mgmt_tx_status(wdev, cookie, buf, len, ack, gfp)

#define cfg80211_remain_on_channel_expired(wdev, cookie, chan, gfp) \
		wfo_radio_cmd_sender_cfg80211_remain_on_channel_expired(wdev, cookie, chan, gfp)

#define cfg80211_unlink_bss(wiphy, pub) \
		wfo_radio_cmd_sender_cfg80211_unlink_bss(wiphy, pub)

#define cfg80211_vendor_event(skb, gfp) \
		wfo_radio_cmd_sender_cfg80211_vendor_event(skb, gfp)

#define cfg80211_michael_mic_failure(dev, addr, key_type, key_id, tsc, gfp) \
		wfo_radio_cmd_sender_cfg80211_michael_mic_failure(dev, addr, key_type, key_id, tsc, gfp)

#define cfg80211_vendor_event_alloc(wiphy, wdev, approxlen, event_idx, gfp) \
		wfo_radio_cmd_sender_cfg80211_vendor_event_alloc(wiphy, wdev, approxlen, event_idx, gfp)

#define cfg80211_connect_done(dev, params, gfp) \
		wfo_radio_cmd_sender_cfg80211_connect_done(dev, params, gfp)

#define regulatory_hint(wiphy, alpha2) \
		wfo_radio_cmd_sender_regulatory_hint(wiphy, alpha2)

#if defined(CONFIG_RTK_WLAN_EVENT_INDICATE)
#define rtk_eventd_netlink_send(rtk_eventd_pid, nl_eventd_sk, event, ifname, data, data_len) \
	wfo_radio_cmd_sender_rtk_eventd_netlink_send(rtk_eventd_pid, nl_eventd_sk, event, ifname, data, data_len)
#endif /* CONFIG_RTK_WLAN_EVENT_INDICATE */

#if defined(CONFIG_RTW_80211R)
#define cfg80211_ft_event(netdev, ft_event) \
	wfo_radio_cmd_sender_cfg80211_ft_event(netdev, ft_event)
#endif /* CONFIG_RTW_80211R */

#define wireless_send_event(dev, cmd, wrqu, extra) \
	wfo_radio_cmd_sender_wireless_send_event(dev, cmd, wrqu, extra)

#define notify_fc(dev, mac_addr, flag) \
	wfo_radio_cmd_sender_mac_to_fc(dev, mac_addr, flag)

#endif /* WFO_RADIO_SENDER */


#if defined(WFO_RADIO_SENDER)
#if defined(CPTCFG_WFO_VIRT_SAME_CPU)
long _wfo_copy_from_user(void *to,
		const void __user * from, unsigned long n);
long _wfo_copy_to_user(void __user *to,
		const void *from, unsigned long n);

static inline long wfo_copy_from_user(void *to,
		const void __user * from, unsigned long n)
{
	return _wfo_copy_from_user(to, from, n);
}

static inline long wfo_copy_to_user(void __user *to,
		const void *from, unsigned long n)
{
	return _wfo_copy_to_user(to, from, n);
}

#ifdef copy_from_user
#undef copy_from_user
#endif
#define copy_from_user(to, from, n) wfo_copy_from_user(to, from, n)

#ifdef copy_to_user
#undef copy_to_user
#endif
#define copy_to_user(to, from, n)   wfo_copy_to_user(to, from, n)

#endif /* CPTCFG_WFO_VIRT_SAME_CPU */
#endif /* WFO_RADIO_SENDER */


#endif /* __WFO_CMD_RADIO_H__ */
