//==============================================================================
//  global variable
//==============================================================================
#ifdef ETH_ALEN
#undef ETH_ALEN
#define ETH_ALEN ((u32)(6))
#endif /* ETH_ALEN */

static unsigned short wfo_virt_cmd_ipc_type[WFO_CMD_MAX] = {0};
DEFINE_MUTEX(ioctl_mutex);

#define WFO_DEF(arg) cmd_str(arg)
static const char wfo_cmd_str[WFO_CMD_MAX+1][64] = {
	WFO_CFG80211_CMD,
};
#undef WFO_DEF

#define WFO_DEF(arg) sizeof(struct wfo_##arg)
static unsigned int wfo_struct_size[WFO_CMD_MAX+1] = {
	WFO_CFG80211_CMD,
};
#undef WFO_DEF

static const char wfo_struct_str[WFO_STRUCT_TYPE(max)][32] = {
	cmd_str(cfg80211_pmksa),
	cmd_str(cfg80211_chan_def),
	cmd_str(cfg80211_beacon_data),
	cmd_str(station_parameters),
	cmd_str(key_params)
};

#if (WFO_CFG_DBG_TRACE_OPS==1)
unsigned char wfo_trace[TRACE_MAX][WFO_CMD_MAX];
#endif /* WFO_CFG_DBG_TRACE_OPS */

unsigned int wfo_trace_cnt[TRACE_CNT_MAX][WFO_CMD_MAX];

#if defined(WFO_VIRT_SENDER)
struct dev_map_tbl_s virt_map_tbl[CONFIG_IFACE_NUMBER] = { };
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
struct dev_map_tbl_s radio_map_tbl[CONFIG_IFACE_NUMBER] = { };

struct dev_map_tbl_s *get_radio_map(int idx)
{
	return &radio_map_tbl[idx];
}

void update_radio_map(struct net_device *ndev, int idx)
{
	_adapter *adapter = (_adapter *)rtw_netdev_priv(ndev);

	radio_map_tbl[idx].ndev =  ndev;
	radio_map_tbl[idx].wiphy = adapter_to_wiphy(adapter);
	radio_map_tbl[idx].adapter = (void *)adapter;

	adapter->wfo_mapid = idx;
}
#endif /* WFO_VIRT_RECEIVER */

//==============================================================================
//  for ipc
//==============================================================================
#if defined(USE_RTK_TAROKO_IPC)
#include "wfo_ipc.c"
#else /* !USE_RTK_TAROKO_IPC */
#include "wfo_ipc_fake.c"
#endif /* USE_RTK_TAROKO_IPC */

#if defined(CONFIG_RTK_WFO_NO_VIRT)
wfo_cfg80211_t g_cfg;

#if defined(USE_RTK_TAROKO_IPC)
#error "USE_RTK_TAROKO_IPC is defined!!"
#endif
#endif /* CONFIG_RTK_WFO_NO_VIRT */

#if defined(WFO_VIRT_SENDER)

#if defined(USE_GLOBAL_CFG)
#define MAX_CFG_NUM (CONFIG_IFACE_NUMBER*NR_CPUS)
static wfo_cfg80211_t g_cfg[MAX_CFG_NUM];
#endif /* USE_GLOBAL_CFG */

#define CFG_LOCK_IRQSAVE(lock, flags) spin_lock_irqsave(lock, flags)
#define CFG_UNLOCK_IRQRESTORE(lock, flags) spin_unlock_irqrestore(lock, flags)

inline void wfo_cfg_reset(void)
{
#if defined(USE_GLOBAL_CFG)
	int i;
	wfo_cfg80211_t *cfg = NULL;
	for (i=0; i<MAX_CFG_NUM; i++) {
		cfg = &g_cfg[i];
		atomic_set(&cfg->busy, 0);
	}
#endif /* USE_GLOBAL_CFG */
}

inline wfo_cfg80211_t *__get_free_cfg(struct net_device *ndev, u32 cmd, u32 cpu_id)
{
#if defined(USE_GLOBAL_CFG)
	int i = 0;
	wfo_cfg80211_t *cfg = NULL;

	for (i=0; i <MAX_CFG_NUM; i++) {
		cfg = &g_cfg[i];
		if (atomic_read(&cfg->busy) != CFG_IS_BUSY) {
			atomic_set(&cfg->busy, CFG_IS_BUSY);
			//cfg->cfg_idx = i;
			//WFO_PRINT("use g_cfg[%d]: cpu_id[%u], cmd[%d][%s], dev[%s]\n", i, cpu_id, cmd, wfo_cmd_str[cmd], ndev->name);
			return cfg;
		}
	}
	return NULL;
#else /* !USE_GLOBAL_CFG */
	wfo_cfg80211_t *cfg = NULL;
	struct wfo_ndev_priv *ndev_priv = NULL;

  #if (WFO_CFG_SMP==1)
	ndev_priv =(struct wfo_ndev_priv *)netdev_priv(ndev);
	cfg = &ndev_priv->cfg[cpu_id];

	if (atomic_read(&cfg->busy) == CFG_IS_BUSY) {
		WFO_PRINT("cpu[%d], cfg_idx[%d] is busy! using by: dev[%s] cmd[%d][%s] cnt[%xx%x]!!\n",
			cpu_id,
			cfg->cfg_idx,
			cfg->dev_name,
			cfg->cmd, wfo_cmd_str[cfg->cmd],
			(cfg->cmd<WFO_VIRT_CMD_MAX)?0:1,
			(cfg->cmd<WFO_VIRT_CMD_MAX)?cfg->linux_cnt:cfg->ecos_cnt);
		return NULL;
	} else {
		atomic_set(&cfg->busy, CFG_IS_BUSY);
		//cfg->cfg_idx = cpu_id;
	}
  #else /* WFO_CFG_SMP!=1 */
	ndev_priv =(struct wfo_ndev_priv *)netdev_priv(ndev);
	cfg = &ndev_priv->cfg;
  #endif /* (WFO_CFG_SMP==1) */

	return cfg;
#endif /* USE_GLOBAL_CFG */
}

inline wfo_cfg80211_t *__get_cfg_addr(struct net_device *ndev,
		unsigned int side,
		unsigned int cmd)
{
	struct wfo_ndev_priv *ndev_priv = NULL;
	wfo_cfg80211_t *cfg = NULL;
	unsigned char iface_id = 0x00U;
	char *dev_name = NULL;

#if !defined(CONFIG_RTK_WFO_NO_VIRT)
	static DEFINE_SPINLOCK(lock);
	unsigned long		flags;

	if (ndev) {
		CFG_LOCK_IRQSAVE(&lock, flags);
		ndev_priv =(struct wfo_ndev_priv *)netdev_priv(ndev);
		iface_id = ndev_priv->iface_id;
		dev_name = ndev_priv->radio_name;

		cfg = __get_free_cfg(ndev, cmd, smp_processor_id());
		CFG_UNLOCK_IRQRESTORE(&lock, flags);
	}
#else /* CONFIG_RTK_WFO_NO_VIRT */
	if (ndev) {
		struct wireless_dev *wdev = NULL;
		struct wiphy *wiphy = NULL;
		_adapter *padapter = NULL;

		wdev = ndev_to_wdev(ndev);
		if (wdev) {
			wiphy = wdev_to_wiphy(wdev);
			if (wiphy) {
				padapter = wiphy_to_adapter(wiphy);
					if (padapter) {
						cfg = &padapter->cfg;
						iface_id = padapter->iface_id;
						dev_name = ndev->name;
					}
			}
		}
	} else {
		if (cmd == WFO_CMD(add_virtual_intf)) {
			cfg = &g_cfg;
			iface_id = 1; /* only support 1 VAP */
			dev_name = WLAN_IFACE_NAME"1-vap0";
		}
	}
#endif /* CONFIG_RTK_WFO_NO_VIRT */

	if (cfg) {
		memset((void *)cfg->reset_ptr, 0, sizeof(wfo_cfg80211_t)-((u32)cfg->reset_ptr - (u32)cfg));

		cfg->dev_idx = iface_id;
		cfg->side = (u16)side;
		cfg->cmd = cmd;
		cfg->is_sync = wfo_virt_cmd_ipc_type[cfg->cmd];
		strncpy(cfg->dev_name, dev_name, strlen(dev_name));
	} else {
		WFO_PRINT("no cfg for cmd[%d:%s], ndev=%p, ndev_priv=%p\n",
			cmd, wfo_cmd_str[cmd], ndev, ndev_priv);
	}

	return cfg;
}

#define get_cfg_addr(ndev, side, cmd) \
	__get_cfg_addr(ndev, (u32)side, (u32)cmd)

#endif /* WFO_VIRT_SENDER */

void wfo_show_cmd_name(unsigned int cmd, char *buf)
{
	strncpy(buf, wfo_cmd_str[cmd], 63U);
}

static void register_wfo_ipc_show_cmd_name(void)
{
	extern void (*wfo_ipc_show_cmd_name)(unsigned int cmd, char *buf);
	wfo_ipc_show_cmd_name = wfo_show_cmd_name;
}

//==============================================================================
//  ndev ops
//==============================================================================
#if defined(WFO_CMD_VIRT_NDEV_OPS)
//----------------------------------------------------------------------------
//.ndo_set_mac_address	= wfo_virt_set_address,
//rtw_net_set_mac_address

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_ndo_set_mac_address(
		struct net_device *virt_ndev,
		struct sockaddr *sa)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev,
							RUN_REMOTELY, WFO_CMD(ndo_set_mac_address));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(ndo_set_mac_address));

	memcpy(&cfg->ndev_ops.sa, sa, sizeof(struct sockaddr));

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

#if defined(WKARD_98D)
	virt_ndev->priv_flags &= (u32)~IFF_DONT_BRIDGE;
#endif /* WKARD_98D */

	WFO_SENDER_TRACE_OUT(WFO_CMD(ndo_set_mac_address));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_ndo_set_mac_address(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0, i;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(ndo_set_mac_address));

#if defined( __ECOS) && defined(CYGPKG_NET)
	//set_mac_address(radio_ndev->name, ((struct sockaddr *)(&cfg->ndev_ops.sa))->sa_data);
#endif
	radio_ndev->netdev_ops->ndo_set_mac_address(radio_ndev, &cfg->ndev_ops.sa);
	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(ndo_set_mac_address));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */


//----------------------------------------------------------------------------
//.ndo_get_stats		= wfo_virt_get_stats,
//rtw_net_get_stats

#if !defined(RTK_SHM_DRAM)
#if defined(WFO_VIRT_SENDER)
static struct net_device_stats *wfo_virt_cmd_sender_ndo_get_stats(
		struct net_device *virt_ndev)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev,
							RUN_REMOTELY, WFO_CMD(ndo_get_stats));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(ndo_get_stats));

	//wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

	WFO_SENDER_TRACE_OUT(WFO_CMD(ndo_get_stats));
	return &cfg->ndev_ops.stats;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_ndo_get_stats(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	struct net_device_stats *stats = NULL;
	int ret = 0;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(ndo_get_stats));

	stats = radio_ndev->netdev_ops->ndo_get_stats(radio_ndev);
	if (stats) /* copy state */
		memcpy(&cfg->ndev_ops.stats, stats, sizeof(struct net_device_stats));

	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(ndo_get_stats));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */
#endif /* !RTK_SHM_DRAM */

//----------------------------------------------------------------------------
//.ndo_open			= wfo_virt_open,
//netdev_open

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_ndo_open(
		struct net_device *virt_ndev)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev,
							RUN_REMOTELY, WFO_CMD(ndo_open));

#if defined(CPTCFG_WFO_VIRT_SAME_CPU)
	struct wfo_ndev_priv *ndev_priv =(struct wfo_ndev_priv *)netdev_priv(virt_ndev);
	ndev_priv->radio_ndev = NULL;
#endif

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(ndo_open));

#if 1//def CONFIG_BR_EXT
	{
		struct net_device *br_ndev = wfo_dev_get_by_name(&init_net, CONFIG_BR_EXT_BRNAME);
		if (br_ndev)
			memcpy(&cfg->ndev_ops.br_mac, br_ndev->dev_addr, ETH_ALEN);
		else
			WFO_PRINT("can't get bridge dev(%s) by name!!\n", CONFIG_BR_EXT_BRNAME);
	}
#endif /* CONFIG_BR_EXT */

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

	/*reference G6 driver os_dep/linux/os_intfs.c _netdev_open()*/
	/* move to wfo_virt_iface_alloc_etherdev() */
	/*if (ret == 0) {
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(5, 10, 0))
		virt_ndev->rtk_priv_flags |= (u32)RTK_IFF_DOMAIN_WLAN;
#else
		virt_ndev->priv_flags |= (u32)IFF_DOMAIN_WLAN;
#endif
	}*/

	WFO_SENDER_TRACE_OUT(WFO_CMD(ndo_open));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_ndo_open(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(ndo_open));

#ifdef __ECOS
	#if 1//def CONFIG_BR_EXT
	{
		_adapter *padapter = (_adapter *)rtw_netdev_priv(radio_ndev);
		struct dev_map_tbl_s *map = get_radio_map(padapter->wfo_mapid);

		memcpy(map->br_mac, &cfg->ndev_ops.br_mac, ETH_ALEN);
		radio_ndev->rx_handler_data = (void *)(&map->br_mac);
	}
	#endif /* CONFIG_BR_EXT */

	if (radio_ndev->flags & IFF_UP) {
		WFO_PRINT("netdevice %s is already up\n", radio_ndev->name);
	} else {
		//interface_up(radio_ndev->name);
		ret = radio_ndev->netdev_ops->ndo_open(radio_ndev);
		radio_ndev->flags |= IFF_UP;
	}

#else /* !__ECOS */
	ret = radio_ndev->netdev_ops->ndo_open(radio_ndev);
#endif /* __ECOS */
	cfg->ret_val = ret;

#if defined(CPTCFG_WFO_VIRT_SAME_CPU)
	dev_change_flags(radio_ndev, radio_ndev->flags|IFF_UP|IFF_RUNNING);
#endif /* CPTCFG_WFO_VIRT_SAME_CPU */

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(ndo_open));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */

//----------------------------------------------------------------------------
//.ndo_stop			= wfo_virt_close,
//netdev_close

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_ndo_stop(
		struct net_device *virt_ndev)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(ndo_stop));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(ndo_stop));

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;
	virt_ndev->flags &= (u32)~IFF_UP;

	WFO_SENDER_TRACE_OUT(WFO_CMD(ndo_stop));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_ndo_stop(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(ndo_stop));

#ifdef __ECOS
	if (radio_ndev->flags & IFF_UP) {
		//interface_down(radio_ndev->name);
		ret = radio_ndev->netdev_ops->ndo_stop(radio_ndev);
		radio_ndev->flags &= ~IFF_UP;
	} else
		WFO_PRINT("netdevice %s is already down\n", radio_ndev->name);


#else /* !__ECOS */
	ret = radio_ndev->netdev_ops->ndo_stop(radio_ndev);
#endif /* __ECOS */
	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(ndo_stop));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */


//----------------------------------------------------------------------------
//.ndo_do_ioctl		= wfo_virt_ioctl,
//rtw_ioctl_private & rtw_ioctl_wext_private

#if defined(WFO_VIRT_SENDER)

#if defined(WFO_GETMIB_IN_SHM)
/*get mib value update by eCos update_wfo_mib() */
static int __do_ioctl(struct net_device *virt_ndev,
				char *pstr,
				int cmd, unsigned char dir, u16 subcmd, struct iwreq *wrq)
{
#define EXTRA_MAX_LEN (32*1024) /* copy from g6_wifi_driver/os_dep/linux/ioctl_linux_ap.c */
#define RTL8192CD_IOCTL_GET_MIB 0x89F2

extern int rtw_mib_get(struct net_device *dev, struct iw_request_info *info, union iwreq_data *wrqu, char *extra, unsigned char flag);
extern struct wfo_iwpriv_arg *wfo_get_tbl_entry(char *pstr);

	int ret = -EINVAL;

	if (subcmd==RTL8192CD_IOCTL_GET_MIB &&
		wfo_get_tbl_entry(pstr)) {
		u8 *extra = NULL;
		u16 extra_len = 0x0000U;

		if(wrq->u.data.length > EXTRA_MAX_LEN)
			extra_len = wrq->u.data.length;
		else
			extra_len = (u16)EXTRA_MAX_LEN;

		extra = vmalloc((u32)extra_len);

		ret = rtw_mib_get(virt_ndev, NULL, &wrq->u, extra, 0x00U);

		if (wrq->u.data.length > extra_len) {
			printk("WARNING: %s(%d) IOCTL_FLAG: %d data len(%d) larger than extra_len(%d)!\n",
				__FUNCTION__, __LINE__, subcmd, wrq->u.data.length, extra_len);
			goto fail;
		}

		if (copy_to_user(wrq->u.data.pointer, extra, (unsigned long)wrq->u.data.length))
			ret = -EFAULT;

fail:
		if (extra)
			vfree(extra);
	}

	return ret;
}
#endif /* WFO_GETMIB_IN_SHM */

static int wfo_virt_cmd_sender_ndo_do_ioctl(struct net_device *virt_ndev,
		struct ifreq *ifr, int cmd, unsigned char dir, u16 subcmd)
{
#define CHECK_DRAM_MULTIACCESS 0
#if (CHECK_DRAM_MULTIACCESS==1)
	static atomic_t dram_busy = ATOMIC_INIT(0);
#endif /* CHECK_DRAM_MULTIACCESS */
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(ndo_do_ioctl));
	struct iwreq *wrq = (struct iwreq *)ifr;
	void *user_pointer;
	wfo_dram_t *dram = RTK_SHM_DRAM;
	char *ptr = (char *)&dram->md.cfg.ndo_do_ioctl.ioctl_data;

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(ndo_do_ioctl));

#if (CHECK_DRAM_MULTIACCESS==1)
	if (atomic_read(&dram_busy)) {
		WFO_PRINT("cpu[%d], RTK_SHM_DRAM busy! using by cpu[%d]!!",
			smp_processor_id(), atomic_read(&dram_busy));
		goto fail_exit2;
	} else {
		atomic_set(&dram_busy, smp_processor_id());
	}
#endif /* CHECK_DRAM_MULTIACCESS */

	mutex_lock(&ioctl_mutex);

	cfg->ioctl.cmd = cmd;

	if (cmd == SIOCDEVPRIVATEAXEXT) {
		if (wrq->u.data.length <= MAX_IOCTL_DATA_SIZE)
			cfg->ioctl.wrq.u.data.length = wrq->u.data.length;
		else {
			WFO_PRINT("wfo_ipc_sender: [Before send] SIOCDEVPRIVATEAXEXT "
				"ioctl data length %d is larger MAX_IOCTL_DATA_SIZE %d\n",
				wrq->u.data.length, MAX_IOCTL_DATA_SIZE);
			cfg->ioctl.wrq.u.data.length = (u16)MAX_IOCTL_DATA_SIZE;
		}
		cfg->ioctl.wrq.u.data.flags  = wrq->u.data.flags;

		if (dir & (1<<WFO_IOCTL_SET)) {
			if (copy_from_user(ptr, (void *)wrq->u.data.pointer,
					(unsigned long)cfg->ioctl.wrq.u.data.length)) {
				ret = -EFAULT;
				WFO_DBGP_IOCTL("case SIOCDEVPRIVATEAXEXT: copy_from_user fail!\n");
				goto fail_exit;
			}
		}

		if ((dir & (1<<WFO_IOCTL_GET)) ||
			(dir & (1<<WFO_IOCTL_SET))) {
		#if defined(WFO_GETMIB_IN_SHM)
			ret = __do_ioctl(virt_ndev, ptr, cmd, dir, subcmd, wrq);
			if (ret) {
				wfo_virt_cmd_sender(cfg);
				ret = cfg->ret_val;
			} else {
				dir = 0U; /* already copy to user */
			}
		#else /* !WFO_GETMIB_IN_SHM */
			wfo_virt_cmd_sender(cfg);
			ret = cfg->ret_val;
		#endif /* WFO_GETMIB_IN_SHM */
		}

		if (dir & (1<<WFO_IOCTL_GET)) {
			if (cfg->ioctl.wrq.u.data.length <= MAX_IOCTL_DATA_SIZE)
				wrq->u.data.length = cfg->ioctl.wrq.u.data.length;
			else {
				WFO_PRINT("wfo_ipc_sender: [After send] SIOCDEVPRIVATEAXEXT "
					"ioctl data length %d is larger MAX_IOCTL_DATA_SIZE %d\n",
					cfg->ioctl.wrq.u.data.length, MAX_IOCTL_DATA_SIZE);
				wrq->u.data.length = (u16)MAX_IOCTL_DATA_SIZE;
			}
			if (copy_to_user((void *)wrq->u.data.pointer,
					ptr, (unsigned long)wrq->u.data.length)) {
				ret = -EFAULT;
				WFO_DBGP_IOCTL("case SIOCDEVPRIVATEAXEXT: copy_to_user fail!\n");
				goto fail_exit;
			}
		}
	}
	else if (cmd == SIOCDEVPRIVATE) {
		memcpy(&cfg->ioctl.iwp, ifr->ifr_ifru.ifru_data, sizeof(struct iw_point));
		user_pointer = cfg->ioctl.iwp.pointer;

		if (cfg->ioctl.iwp.length > MAX_IOCTL_DATA_SIZE) {
			WFO_PRINT("wfo_ipc_sender: [Before send] SIOCDEVPRIVATE "
				"ioctl data length %d is larger MAX_IOCTL_DATA_SIZE %d\n",
				cfg->ioctl.iwp.length, MAX_IOCTL_DATA_SIZE);
			cfg->ioctl.iwp.length = (u16)MAX_IOCTL_DATA_SIZE;
		}

		if (copy_from_user(ptr, (void *)cfg->ioctl.iwp.pointer,
				(unsigned long)cfg->ioctl.iwp.length)) {
			ret = -EFAULT;
			WFO_DBGP_IOCTL("case SIOCDEVPRIVATE: copy_from_user fail!\n");
			goto fail_exit;
		}

		wfo_virt_cmd_sender(cfg);
		ret = cfg->ret_val;

		if (cfg->ioctl.iwp.length > MAX_IOCTL_DATA_SIZE) {
			WFO_PRINT("wfo_ipc_sender: [After send] SIOCDEVPRIVATE "
				"ioctl data length %d is larger MAX_IOCTL_DATA_SIZE %d\n",
				cfg->ioctl.iwp.length, MAX_IOCTL_DATA_SIZE);
			cfg->ioctl.iwp.length = (u16)MAX_IOCTL_DATA_SIZE;
		}

		if (copy_to_user((void *)user_pointer, ptr,
				(unsigned long)cfg->ioctl.iwp.length)) {
			ret = -EFAULT;
			WFO_DBGP_IOCTL("case SIOCDEVPRIVATE: copy_to_user fail!\n");
			goto fail_exit;
		}
		cfg->ioctl.iwp.pointer = user_pointer;
		memcpy(ifr->ifr_ifru.ifru_data, &cfg->ioctl.iwp, sizeof(struct iw_point));
	}

fail_exit:
	memset(ptr, 0, (u32)MAX_IOCTL_DATA_SIZE);
	mutex_unlock(&ioctl_mutex);
#if (CHECK_DRAM_MULTIACCESS==1)
	atomic_set(&dram_busy, 0);
fail_exit2:
#endif /* CHECK_DRAM_MULTIACCESS */
	WFO_SENDER_TRACE_OUT(WFO_CMD(ndo_do_ioctl));
	WFO_DBGP_IOCTL("ret=%d\n", ret);
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_ndo_do_ioctl(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;
	struct iwreq *wrq = NULL;
	struct ifreq *rq = NULL;
	wfo_dram_t *dram = RTK_SHM_DRAM;
	char *ptr = &dram->md.cfg.ndo_do_ioctl.ioctl_data;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(ndo_do_ioctl));

	if (cfg->ioctl.cmd == SIOCDEVPRIVATEAXEXT) {
		sprintf(cfg->ioctl.wrq.ifr_ifrn.ifrn_name, radio_ndev->name);

		wrq = &cfg->ioctl.wrq;
		wrq->u.data.pointer = ptr;

		ret = radio_ndev->netdev_ops->ndo_do_ioctl(
			radio_ndev, (struct ifreq *)&cfg->ioctl.wrq, cfg->ioctl.cmd);
	}
	else if (cfg->ioctl.cmd == SIOCDEVPRIVATE) {
		sprintf(cfg->ioctl.rq.ifr_ifrn.ifrn_name, radio_ndev->name);

		rq =  &cfg->ioctl.rq;
		rq->ifr_ifru.ifru_data = &cfg->ioctl.iwp;
		cfg->ioctl.iwp.pointer = ptr;

		ret = radio_ndev->netdev_ops->ndo_do_ioctl(
			radio_ndev, (struct ifreq *)&cfg->ioctl.rq, cfg->ioctl.cmd);
	}

	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(ndo_do_ioctl));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */

//----------------------------------------------------------------------------
// wireless_handler: wfo_priv_handler

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_iwpriv(struct net_device *virt_ndev,
		struct iw_request_info *info,
		union iwreq_data *wdata, char *extra)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(iwpriv));
	struct iw_point *p = (struct iw_point*)wdata;

	extern int get_priv_descr_and_size(struct net_device *dev, unsigned int cmd,
					   const struct iw_priv_args **descrp);
	extern int adjust_priv_size(__u16 args, struct iw_point *iwp);
	const struct iw_priv_args *descr;
	u32 extra_size = (u32)get_priv_descr_and_size(virt_ndev, (u32)info->cmd, &descr);
	u32 no_extra = 0;

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(iwpriv));

	memcpy(&cfg->iwpriv.info, info, sizeof(struct iw_request_info));
	memcpy(&cfg->iwpriv.wdata, wdata, sizeof(union iwreq_data));
	if (extra_size == 0) {
		no_extra = 1;
		extra_size = sizeof(union iwreq_data);
	}

	cfg->iwpriv.extra_size = extra_size;
	cfg->iwpriv.no_extra = no_extra;

	if (no_extra) {
		memcpy(cfg->iwpriv.data, extra, extra_size);
	} else if (IW_IS_SET(info->cmd)) {
		if (p->pointer && extra_size < MAX_IWPRIV_BUFLEN) {
			memcpy(cfg->iwpriv.data, p->pointer, extra_size);
		} else {
			ret = -ENOMEM;
			goto exit;
		}
 	} else {
		if (p->pointer && p->length < MAX_IWPRIV_BUFLEN) {
			memcpy(cfg->iwpriv.data, p->pointer, (u32)p->length);
		} else {
			ret = -ENOMEM;
			goto exit;
		}
	}

	/* This cmd is for dumping the whole mac memory. It takes a long time, just using ASYNC IPC.*/
	if (!strcmp(extra, "debug,shbuf"))
		cfg->is_sync = (u16)ASYNC;

	wfo_virt_cmd_sender(cfg);

	if (!strcmp(extra, "debug,shbuf"))
		cfg->ret_val = 0;

	ret = cfg->ret_val;

	wdata->data.length =cfg->iwpriv.wdata.data.length;
	wdata->data.flags =cfg->iwpriv.wdata.data.flags;

	if (!ret && IW_IS_GET(info->cmd)) {
		if (!no_extra && !(descr->get_args & IW_PRIV_SIZE_FIXED))
			extra_size = (u32)adjust_priv_size(descr->get_args, p);

		memcpy(extra, cfg->iwpriv.data, extra_size);
	}

exit:
	if (ret == -ENOMEM) {
		WFO_WARN("fail!! (p=%p, p->pointer=%p, p->length=%u, extra_size=%u, no_extra=%u)\n",
			p, p->pointer, p->length, extra_size, no_extra);
	}
	WFO_SENDER_TRACE_OUT(WFO_CMD(iwpriv));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_iwpriv(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	extern iw_handler rtw_private_handler[];

	int ret = 0;
	struct iw_request_info *info = &cfg->iwpriv.info;
	union iwreq_data *wdata = &cfg->iwpriv.wdata;
	unsigned int index = info->cmd - SIOCIWFIRSTPRIV;
	struct iw_point *p = (struct iw_point*)wdata;
#if (WFO_SHRINK_CFG_SIZE==1)
	unsigned char extra[MAX_IWPRIV_BUFLEN];
#endif /* WFO_SHRINK_CFG_SIZE */

	WFO_RECEIVER_TRACE_IN(WFO_CMD(iwpriv));

	p->pointer = &cfg->iwpriv.data;
	if (IW_IS_SET(info->cmd) || cfg->iwpriv.no_extra) {
		if (cfg->iwpriv.extra_size < MAX_IWPRIV_BUFLEN) {
		#if (WFO_SHRINK_CFG_SIZE==1)
			memcpy(&extra, &cfg->iwpriv.data, cfg->iwpriv.extra_size);
		#else /* !WFO_SHRINK_CFG_SIZE */
			memcpy(&cfg->iwpriv.extra, &cfg->iwpriv.data, cfg->iwpriv.extra_size);
		#endif /* WFO_SHRINK_CFG_SIZE */
		} else {
			ret = -ENOMEM;
			goto exit;
		}
	}

	if (rtw_private_handler[index]) {
	#if !defined(CPTCFG_WFO_VIRT_SAME_CPU)
		if(log_cfg.pass_log.printk_format == 0) {
			log_cfg.side = RUN_REMOTELY;
			log_cfg.cmd = WFO_CMD(pass_log);
			log_cfg.pass_log.printk_format = 1;
		}

		if (radio_ndev) {
			_adapter *padapter = (_adapter *)rtw_netdev_priv(radio_ndev);
			log_cfg.dev_idx = padapter->wfo_mapid;
			memcpy(log_cfg.dev_name, radio_ndev->name, strlen(radio_ndev->name));
		}
	#endif /* !CPTCFG_WFO_VIRT_SAME_CPU */

	#if (WFO_SHRINK_CFG_SIZE==1)
		ret = (*rtw_private_handler[index])(radio_ndev, info, wdata, (char *)&extra);
	#else /* !WFO_SHRINK_CFG_SIZE */
		ret = (*rtw_private_handler[index])(radio_ndev, info, wdata, (char *)&cfg->iwpriv.extra);
	#endif /* WFO_SHRINK_CFG_SIZE */
		cfg->ret_val = ret;

		if (!ret && IW_IS_GET(info->cmd)) {
			if (cfg->iwpriv.extra_size < MAX_IWPRIV_BUFLEN) {
			#if (WFO_SHRINK_CFG_SIZE==1)
				memcpy(&cfg->iwpriv.data, &extra, cfg->iwpriv.extra_size);
			#else /* !WFO_SHRINK_CFG_SIZE */
				memcpy(&cfg->iwpriv.data, &cfg->iwpriv.extra, cfg->iwpriv.extra_size);
			#endif /* WFO_SHRINK_CFG_SIZE */
			} else {
				ret = -ENOMEM;
				goto exit;
			}
		}
	}

exit:
	WFO_RECEIVER_TRACE_OUT(WFO_CMD(iwpriv));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */


//----------------------------------------------------------------------------
// wireless_handler: wfo_std_handler
// struct iw_handler_def rtw_handlers_def

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_std_handler(struct net_device *virt_ndev,
		struct iw_request_info *info,
		union iwreq_data *wdata, char *extra)
{
	extern const struct iw_ioctl_description standard_ioctl[]; /* from net/wireless/wext-core.c */

	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(std_handler));
	const struct iw_ioctl_description *descr = NULL;
	unsigned int extra_size = 0U;

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(std_handler));

	descr = &(standard_ioctl[IW_IOCTL_IDX(info->cmd)]);
	cfg->std_handler.descr_header_type = descr->header_type;
	if (descr->header_type != IW_HEADER_TYPE_POINT) {
		memcpy(&cfg->std_handler.info, info, sizeof(struct iw_request_info));
		memcpy(&cfg->std_handler.wdata, wdata, sizeof(union iwreq_data));

		wfo_virt_cmd_sender(cfg);

		memcpy(info, &cfg->std_handler.info, sizeof(struct iw_request_info));
		memcpy(wdata, &cfg->std_handler.wdata, sizeof(union iwreq_data));

		ret = cfg->ret_val;
	} else {
		extra_size = (u32)descr->max_tokens * (u32)descr->token_size;

		if (!IW_IS_SET(info->cmd)) {
			if ((descr->flags & (u32)IW_DESCR_FLAG_NOMAX) &&
				(((struct iw_point *)wdata)->length > descr->max_tokens)) {
					extra_size = (u32)(((struct iw_point *)wdata)->length) * (u32)descr->token_size;
			}
		}

		if (extra_size < MAX_IWPRIV_BUFLEN) {
			memcpy(cfg->std_handler.extra, extra, extra_size);
		} else {
			WFO_PRINT("extra_size > MAX_IWPRIV_BUFLEN!\n");
			ret = -ENOMEM;
			goto exit;
		}

		memcpy(&cfg->std_handler.info, info, sizeof(struct iw_request_info));
		memcpy(&cfg->std_handler.wdata, wdata, sizeof(union iwreq_data));

		wfo_virt_cmd_sender(cfg);

		memcpy(info, &cfg->std_handler.info, sizeof(struct iw_request_info));
		memcpy(wdata, &cfg->std_handler.wdata, sizeof(union iwreq_data));
		memcpy(extra, cfg->std_handler.extra, extra_size);

		ret = cfg->ret_val;

	}

exit:
	WFO_SENDER_TRACE_OUT(WFO_CMD(std_handler));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_std_handler(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;
	iw_handler handler = NULL;
	struct iw_request_info *info = &cfg->std_handler.info;
	union iwreq_data *wdata = &cfg->std_handler.wdata;
	unsigned int index = info->cmd - SIOCIWFIRST;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(std_handler));

	if (info->cmd >= SIOCIWFIRST && info->cmd <= SIOCIWLAST)
		handler = radio_ndev->wireless_handlers->standard[index];
	if (handler) {
		if ( cfg->std_handler.descr_header_type != IW_HEADER_TYPE_POINT)
			ret = handler(radio_ndev, info, wdata, NULL);
		else
			ret = handler(radio_ndev, info, wdata, cfg->std_handler.extra);
	}

	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(std_handler));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */
#endif /* WFO_CMD_VIRT_NDEV_OPS */


//==============================================================================
//  other
//==============================================================================
#if !defined(CONFIG_RTK_WFO_NO_VIRT)

//----------------------------------------------------------------------------
// sync band cap for ecos g6

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_band_cap(struct wiphy *wiphy,
		struct net_device *virt_ndev)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(band_cap));
	struct wfo_wiphy_data *wiphy_data = wiphy_priv(wiphy);
	struct ieee80211_supported_band *band = NULL;

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(band_cap));

	cfg->band_cap.index = wiphy_data->idx;

	if (wiphy_data->band == NL80211_BAND_2GHZ)
		cfg->band_cap.band_type = wiphy_data->band;
#if CONFIG_IEEE80211_BAND_5GHZ
	if (wiphy_data->band == NL80211_BAND_5GHZ)
		cfg->band_cap.band_type = wiphy_data->band;
#endif

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

	if (wiphy_data->band == NL80211_BAND_2GHZ)
		band = wiphy->bands[NL80211_BAND_2GHZ];
#if CONFIG_IEEE80211_BAND_5GHZ
	if (wiphy_data->band == NL80211_BAND_5GHZ)
		band = wiphy->bands[NL80211_BAND_5GHZ];
#endif

	if (band) {
		memcpy(&band->ht_cap, &cfg->band_cap.band.source.ht_cap,
			sizeof(struct ieee80211_sta_ht_cap));

		band->n_iftype_data =
			cfg->band_cap.band.source.n_iftype_data;

		memcpy((void *)band->iftype_data, &cfg->band_cap.band.iftype_data,
			sizeof(struct ieee80211_sband_iftype_data)*WFO_IFTYPE_DATA_NUM);

		memcpy(band->channels, cfg->band_cap.band.channels,
			sizeof(struct ieee80211_channel)*(u32)band->n_channels);

		memcpy(band->bitrates, cfg->band_cap.band.bitrates,
			sizeof(struct ieee80211_rate)*(u32)band->n_bitrates);
	}

	WFO_SENDER_TRACE_OUT(WFO_CMD(band_cap));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_band_cap(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;
	_adapter *padapter = wiphy_to_adapter(wiphy);
	struct ieee80211_supported_band *band = NULL;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(band_cap));

	if (cfg->band_cap.band_type == NL80211_BAND_2GHZ)
		band = wiphy->bands[NL80211_BAND_2GHZ];
#if CONFIG_IEEE80211_BAND_5GHZ
	if (cfg->band_cap.band_type == NL80211_BAND_5GHZ)
		band = wiphy->bands[NL80211_BAND_5GHZ];
#endif

	if (band) {
		memset(&cfg->band_cap.band, 0,
			sizeof(struct __wfo_ieee80211_supported_band2));

		memcpy(&cfg->band_cap.band.source, band,
			sizeof(struct ieee80211_supported_band));

		if (band->channels)
			memcpy(&cfg->band_cap.band.channels , band->channels,
				sizeof(struct ieee80211_channel)*band->n_channels);
		if (band->bitrates)
			memcpy(&cfg->band_cap.band.bitrates , band->bitrates,
				sizeof(struct ieee80211_rate)*band->n_bitrates);
		if (band->iftype_data)
			memcpy(&cfg->band_cap.band.iftype_data , band->iftype_data,
				sizeof(struct ieee80211_sband_iftype_data)*WFO_IFTYPE_DATA_NUM);
	}

	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(band_cap));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */

#if !defined(CPTCFG_WFO_VIRT_SAME_CPU)
//----------------------------------------------------------------------------
// for proc support

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_proc_file(wfo_cfg80211_t *cfg)
{
	int ret = 0;

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(proc_file));

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

	WFO_SENDER_TRACE_OUT(WFO_CMD(proc_file));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
inline wfo_cfg80211_t *get_ra_cfg_addr(struct net_device *, unsigned int, unsigned int);
u32 wfo_radio_cmd_sender_pass_log(wfo_cfg80211_t *);
wfo_cfg80211_t *proc_cfg = NULL;
wfo_cfg80211_t log_cfg = {{0}};

static int wfo_virt_cmd_receiver_proc_file(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;
	struct cfg80211_external_auth_params *params = NULL;
	extern void rtw_wfo_proc_dispatch(int argc, char *argv[]);
	int pointer = 0;
	int argc = 0;
	char *argv[15];

	proc_cfg = get_ra_cfg_addr(radio_ndev, RUN_REMOTELY, WFO_CMD(pass_log));

	if (proc_cfg == NULL)
		goto exit;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(proc_file));

	while(cfg->proc_file.str[pointer] != '\0') {
		if(cfg->proc_file.str[pointer] == ' ') {
			cfg->proc_file.str[pointer++] = '\0';
			if (argc == 0) {
				argv[argc++] = (unsigned char *)&cfg->proc_file.str[0];
			}

			if (argc >= 15)
				break;

			argv[argc++] = (unsigned char *)&cfg->proc_file.str[pointer];
		}
		else
			pointer++;
	}

	proc_cfg->pass_log.write_offset = 0;
	rtw_wfo_proc_dispatch(argc, argv);

	proc_cfg->pass_log.ipc_type = 1;
	wfo_radio_cmd_sender_pass_log(proc_cfg);

	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(proc_file));
	wfo_cfg80211_unlock(radio_ndev);/* unlock pass_log
		This is a specific case, pass_log is used in virt cmd receiver,
		lock/unlock pass_log is implemented in place where use it.

		In general radio cmd is lock at sender beginning (get_ra_cfg_addr),
		and unlock(WFO_SENDER_TRACE_OUT) at end of sender function.
	*/

exit:
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */

//----------------------------------------------------------------------------
// for unregister net_device

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_unregister_ndev(struct net_device *virt_ndev)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(unregister_ndev));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(unregister_ndev));

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

	WFO_SENDER_TRACE_OUT(WFO_CMD(unregister_ndev));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_unregister_ndev(struct wiphy *wiphy,
                struct net_device *radio_ndev,
                wfo_cfg80211_t *cfg)
{
	int ret = 0;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(unregister_ndev));

	/* reset cached device table */
	memset(&radio_map_tbl[cfg->dev_idx], 0, sizeof(struct dev_map_tbl_s));

	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(unregister_ndev));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */
#endif /* !CPTCFG_WFO_VIRT_SAME_CPU */

//----------------------------------------------------------------------------
// for rtw_get_wireless_stats

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_get_wireless_stats(struct net_device *virt_ndev)
{
	int ret = 0;
	struct wfo_ndev_priv *ndev_priv = (struct wfo_ndev_priv *)netdev_priv(virt_ndev);
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(get_wireless_stats));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(get_wireless_stats));

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

	memcpy(&ndev_priv->iwstats, &cfg->get_wireless_stats.iwstats, sizeof(struct iw_statistics));

	WFO_SENDER_TRACE_OUT(WFO_CMD(get_wireless_stats));

	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_get_wireless_stats(struct wiphy *wiphy,
                struct net_device *radio_ndev,
                wfo_cfg80211_t *cfg)
{
	int ret = 0;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(unregister_ndev));

	memcpy(&cfg->get_wireless_stats.iwstats, (void *)radio_ndev->wireless_handlers->get_wireless_stats(radio_ndev), sizeof(struct iw_statistics));

	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(unregister_ndev));

	return ret;
}
#endif /* WFO_VIRT_RECEIVER */

//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
// for rtw_netlink_recv_msg

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_netlink_recv_msg(struct sk_buff *skb)
{
	int ret = 0;
	struct net_device *virt_ndev = wfo_dev_get_by_name(&init_net, WLAN_WFOVIRT);

	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(netlink_recv_msg));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(netlink_recv_msg));

	memcpy(&cfg->netlink_recv_msg.nlhdr, (void *)skb->data , ((struct nlmsghdr *)skb->data)->nlmsg_len);

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;	// Don't care the return value

	WFO_SENDER_TRACE_OUT(WFO_CMD(netlink_recv_msg));

	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_netlink_recv_msg(struct wiphy *wiphy,
                struct net_device *radio_ndev,
                wfo_cfg80211_t *cfg)
{
	int ret = 0;
	extern void rtw_netlink_recv_msg(struct sk_buff *skb);

	struct sk_buff skb = {0};

	WFO_RECEIVER_TRACE_IN(WFO_CMD(netlink_recv_msg));

	skb.data = (void *)(&cfg->netlink_recv_msg.nlhdr);

#ifdef CONFIG_WLAN_MANAGER
	rtw_netlink_recv_msg(&skb);
#endif

	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(netlink_recv_msg));

	return ret;
}
#endif /* WFO_VIRT_RECEIVER */

//----------------------------------------------------------------------------

#endif /* CONFIG_RTK_WFO_NO_VIRT */

//----------------------------------------------------------------------------
// for reg_notifier

#if defined(WFO_VIRT_SENDER)
static void wfo_virt_cmd_sender_reg_notifier(struct wiphy *wiphy,
			struct regulatory_request *request)
{
	struct net_device *virt_ndev = wfo_dev_get_by_name(&init_net, WLAN_WFOVIRT);
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(reg_notifier));

	if (cfg == NULL)
		return;

	WFO_SENDER_TRACE_IN(WFO_CMD(reg_notifier));

	memcpy(&cfg->reg_notifier.request, (void *)request,
		sizeof(struct regulatory_request));

	wfo_virt_cmd_sender(cfg);

	WFO_SENDER_TRACE_OUT(WFO_CMD(reg_notifier));

	if (wiphy->regulatory_flags & (u32)REGULATORY_WIPHY_SELF_MANAGED)
		wfo_virt_cmd_sender_band_cap(wiphy, wiphy_to_ndev(wiphy));
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_reg_notifier(struct wiphy *wiphy,
                struct net_device *radio_ndev,
                wfo_cfg80211_t *cfg)
{
	int ret = 0;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(reg_notifier));

	wiphy->reg_notifier(wiphy,
		(struct regulatory_request *)&cfg->reg_notifier.request);

	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(reg_notifier));

	return ret;
}
#endif /* WFO_VIRT_RECEIVER */


//----------------------------------------------------------------------------
// for sync sta status

#if defined(WFO_SYNC_STA_STATUS)
#if defined(WFO_VIRT_SENDER)
#include <linux/io.h>

static void wfo_virt_cmd_sender_sync_sta_status(struct wfo_sta_st_s *sta_st, u32 sta_st_sz)
{
	struct net_device *virt_ndev = wfo_dev_get_by_name(&init_net, WLAN_WFOVIRT);
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(sync_sta_status));

	if (cfg == NULL)
		return;

	WFO_SENDER_TRACE_IN(WFO_CMD(sync_sta_status));

#if 1//(WFO_SHRINK_CFG_SIZE==1)
	if (sta_st) {
		wfo_dram_t *dram = RTK_SHM_DRAM;
		memset_io(&dram->md.cfg.sync_sta_status.sta_st, 0, sizeof(dram->md.cfg.sync_sta_status.sta_st));
	}

	wfo_virt_cmd_sender(cfg);

	if (sta_st) {
		wfo_dram_t *dram = RTK_SHM_DRAM;
		if (sta_st_sz != sizeof(dram->md.cfg.sync_sta_status.sta_st)) {
			printk("%s(): sta_st_sz=%d != sizeof(cfg->sync_sta_status.sta_st)=%d\n",
				__func__, sta_st_sz, sizeof(dram->md.cfg.sync_sta_status.sta_st));
			sta_st_sz = MIN(sta_st_sz, sizeof(dram->md.cfg.sync_sta_status.sta_st));
		}
		memcpy_fromio(sta_st, &dram->md.cfg.sync_sta_status.sta_st, sta_st_sz);
	}
#else /* !WFO_SHRINK_CFG_SIZE */
	wfo_virt_cmd_sender(cfg);

	if (sta_st) {
		if (sta_st_sz != sizeof(cfg->sync_sta_status.sta_st)) {
			printk("%s(): sta_st_sz=%d != sizeof(cfg->sync_sta_status.sta_st)=%d\n",
				__func__, sta_st_sz, sizeof(cfg->sync_sta_status.sta_st));
			sta_st_sz = MIN(sta_st_sz, sizeof(cfg->sync_sta_status.sta_st));
		}
		memcpy(sta_st, &cfg->sync_sta_status.sta_st, sta_st_sz);
	}
#endif /* WFO_SHRINK_CFG_SIZE */

	WFO_SENDER_TRACE_OUT(WFO_CMD(sync_sta_status));

	return;
}

#if (WFO_SYNC_STA_STATUS_TEST==1) //test code
void test_sync_sta_status(char *proc_name)
{
#define STA_INFO_STR "sta_info"
	u32 i, j, sta_st_sz;
	struct wfo_sta_st_s *sta_st = NULL, *p, *p2;
	u8 mac_addr[WFO_MAC_ALEN] = {0};

	if (strncmp(proc_name, STA_INFO_STR, strlen(STA_INFO_STR))!=0) {
		printk("%s(): proc_name=%s not handle!!\n", __func__, proc_name);
		return;
	}

	sta_st_sz = sizeof(struct wfo_sta_st_s)*WFO_IFACE_NUM*WFO_STA_NUM;
	sta_st = kmalloc(sta_st_sz, GFP_ATOMIC);
	if (sta_st) {
		memset(sta_st, 0, sta_st_sz);
	} else {
		printk("%s(): alloc fail!!\n", __func__);
		return;
	}

	wfo_virt_cmd_sender_sync_sta_status(sta_st, sta_st_sz);

	printk("\n\n");
	for (i=0; i<WFO_IFACE_NUM; i++) {
		p = (sta_st + i*WFO_STA_NUM);
		for (j=0; j<WFO_STA_NUM; j++) {
			p2 = (p+j);
			if (memcmp(p2->mac_addr, mac_addr, WFO_MAC_ALEN)!=0) {
				printk("iface(%01d), sta(%02d):\n", i, j);
				printk("\t" "mac: "MAC_FMT"\n", MAC_ARG(p2->mac_addr));
				printk("\t" "tx_bytes: %20llu, tx_pkts: %20llu\n", p2->tx_bytes, p2->tx_pkts);
				printk("\t" "rx_bytes: %20llu, rx_pkts: %20llu\n", p2->rx_bytes, p2->rx_pkts);
			}
		}
	}
	printk("\n\n");

	kfree(sta_st);
}
#endif /* WFO_SYNC_STA_STATUS_TEST */
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_sync_sta_status(struct wiphy *wiphy,
                struct net_device *radio_ndev,
                wfo_cfg80211_t *cfg)
{
	int ret = 0, i = 0;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(sync_sta_status));

	for (i=0; i<WFO_IFACE_NUM; i++) {
		struct dev_map_tbl_s *map = get_radio_map(i);
		_adapter *adapter = (_adapter *)(map->adapter);
		if (adapter && adapter->netif_up && map->ndev) {
			extern void wfo_sync_sta_st(struct net_device *dev, struct wfo_sta_st_s *sta_st);
		#if 1//(WFO_SHRINK_CFG_SIZE==1)
			wfo_dram_t *dram = RTK_SHM_DRAM;
			struct wfo_sta_st_s *sta_st = &dram->md.cfg.sync_sta_status.sta_st[i];
		#else /* !WFO_SHRINK_CFG_SIZE */
			struct wfo_sta_st_s *sta_st = &cfg->sync_sta_status.sta_st[i];
		#endif /* WFO_SHRINK_CFG_SIZE */
			wfo_sync_sta_st(map->ndev, sta_st);
		}
	}

	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(sync_sta_status));

	return ret;
}
#endif /* WFO_VIRT_RECEIVER */
#endif /* WFO_SYNC_STA_STATUS */


//----------------------------------------------------------------------------
// for new_virt_cmd_xxx

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_new_virt_cmd_xxx(struct wfo_sta_st_s *sta_st, u32 sta_st_sz)
{
	int ret = 0;
	struct net_device *virt_ndev = wfo_dev_get_by_name(&init_net, WLAN_WFOVIRT);
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(new_virt_cmd_xxx));


	if (cfg == NULL)
		goto exit;

	WFO_SENDER_TRACE_IN(WFO_CMD(new_virt_cmd_xxx));

	//todo, copy parameter to cfg

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

	//todo, copy parameter in cfg for caller (if need)

	WFO_SENDER_TRACE_OUT(WFO_CMD(new_virt_cmd_xxx));

exit:
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_new_virt_cmd_xxx(struct wiphy *wiphy,
                struct net_device *radio_ndev,
                wfo_cfg80211_t *cfg)
{
	int ret = 0, i = 0;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(new_virt_cmd_xxx));

	//todo, copy parameter for cfg, and call related function
	//ret = xxxx(....);

	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(new_virt_cmd_xxx));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */


//==============================================================================
//  cfg ops
//==============================================================================
#if defined(WFO_CMD_VIRT_CFG_OPS)
//----------------------------------------------------------------------------
//rdev_change_virtual_intf
//.change_virtual_intf = cfg80211_rtw_change_iface,
#define COPY_BAND_CAP 0 /* move to wfo_virt_iface_post_init_cfg80211 */

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_change_virtual_intf(struct wiphy *wiphy,
		struct net_device *virt_ndev,
		enum nl80211_iftype type,
		struct vif_params *params)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(change_virtual_intf));
#if (COPY_BAND_CAP == 1)
	struct wfo_wiphy_data *wiphy_data = wiphy_priv(wiphy);
	struct ieee80211_supported_band *band = NULL;
#endif

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(change_virtual_intf));

	cfg->change_virtual_intf.type = type;

	if (params) {
		cfg->change_virtual_intf.mflags |= (1<<WFO_CHANGE_VIRTUAL_INTF_HAS_PARAMS);
		memcpy(&cfg->change_virtual_intf.data.source, params, sizeof(struct vif_params));
		if (params->vht_mumimo_groups) {
			cfg->change_virtual_intf.mflags |= (1<<WFO_CHANGE_VIRTUAL_INTF_HAS_VHT_MUMIMO_GROUPS);
			memcpy(cfg->change_virtual_intf.data.vht_mumimo_groups,
					params->vht_mumimo_groups, (u32)VHT_MUMIMO_GROUPS_DATA_LEN);
		}
		if (params->vht_mumimo_follow_addr) {
			cfg->change_virtual_intf.mflags |= (1<<WFO_CHANGE_VIRTUAL_INTF_HAS_VHT_MUMIMO_FOLLOW_ADDR);
			memcpy(cfg->change_virtual_intf.data.vht_mumimo_follow_addr,
					params->vht_mumimo_follow_addr, ETH_ALEN);
		}
	}

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

	/* set iftype to host virtul wifi interface */
	if (virt_ndev) {
		virt_ndev->ieee80211_ptr->iftype = type;
	#ifdef CPTCFG_WFO_VIRT_SAME_CPU
		virt_ndev->priv_flags &= ~(IFF_DONT_BRIDGE);
	#endif
	}

#if (COPY_BAND_CAP == 1) /* copy band cap from radio */
	if (wiphy_data->band == NL80211_BAND_2GHZ) {
		band = wiphy->bands[NL80211_BAND_2GHZ];
	}
#if CONFIG_IEEE80211_BAND_5GHZ
	if (wiphy_data->band == NL80211_BAND_5GHZ) {
		band = wiphy->bands[NL80211_BAND_5GHZ];
	}
#endif

	if (band) {
		memcpy(&band->ht_cap, &cfg->change_virtual_intf.band.source.ht_cap,
			sizeof(struct ieee80211_sta_ht_cap));

		band->n_iftype_data =
			cfg->change_virtual_intf.band.source.n_iftype_data;

		memcpy(band->iftype_data, &cfg->change_virtual_intf.band.iftype_data,
			sizeof(struct ieee80211_sband_iftype_data));
	}
#endif /* COPY_BAND_CAP */

	WFO_SENDER_TRACE_OUT(WFO_CMD(change_virtual_intf));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_change_virtual_intf(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;
	_adapter *padapter = wiphy_to_adapter(wiphy);
	struct ieee80211_supported_band *band = NULL;
	struct vif_params *params = NULL;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(change_virtual_intf));

	if (cfg->change_virtual_intf.mflags & (1<<WFO_CHANGE_VIRTUAL_INTF_HAS_PARAMS)) {
		params = &cfg->change_virtual_intf.data.source;

		if (cfg->change_virtual_intf.mflags & (1<<WFO_CHANGE_VIRTUAL_INTF_HAS_VHT_MUMIMO_GROUPS)) {
			params->vht_mumimo_groups = cfg->change_virtual_intf.data.vht_mumimo_groups;
		}
		if (cfg->change_virtual_intf.mflags & (1<<WFO_CHANGE_VIRTUAL_INTF_HAS_VHT_MUMIMO_FOLLOW_ADDR)) {
			params->vht_mumimo_follow_addr = cfg->change_virtual_intf.data.vht_mumimo_follow_addr;
		}
	}

	ret = wfo_cfg_ops(wiphy)->change_virtual_intf(wiphy, radio_ndev,
				cfg->change_virtual_intf.type, params);
	cfg->ret_val = ret;

#if 1 /* copy from cfg80211_change_iface,
			code executre after rdev_change_virtual_intf */
	if (!ret) {
		radio_ndev->priv_flags &= ~IFF_DONT_BRIDGE;

		switch (cfg->change_virtual_intf.type) {
		case NL80211_IFTYPE_STATION:
			if (radio_ndev->ieee80211_ptr->use_4addr)
				break;
			/* fall through */
		case NL80211_IFTYPE_OCB:
		case NL80211_IFTYPE_P2P_CLIENT:
		case NL80211_IFTYPE_ADHOC:
			radio_ndev->priv_flags |= IFF_DONT_BRIDGE;
			break;
		case NL80211_IFTYPE_P2P_GO:
		case NL80211_IFTYPE_AP:
		case NL80211_IFTYPE_AP_VLAN:
		case NL80211_IFTYPE_WDS:
		case NL80211_IFTYPE_MESH_POINT:
			/* bridging OK */
			break;
		case NL80211_IFTYPE_MONITOR:
			/* monitor can't bridge anyway */
			break;
		case NL80211_IFTYPE_UNSPECIFIED:
		case NUM_NL80211_IFTYPES:
			/* not happening */
			break;
		case NL80211_IFTYPE_P2P_DEVICE:
		case NL80211_IFTYPE_NAN:
			WARN_ON(1);
			break;
		}
	}
/*
	if (!err && ntype != otype && netif_running(dev)) {
		cfg80211_update_iface_num(rdev, ntype, 1);
		cfg80211_update_iface_num(rdev, otype, -1);
	}
*/
#endif

#if (COPY_BAND_CAP == 1) /* copy band cap to IPC*/
	if (is_supported_24g(padapter->registrypriv.band_type)) {
		band = wiphy->bands[NL80211_BAND_2GHZ];
	}
#if CONFIG_IEEE80211_BAND_5GHZ
	if (is_supported_5g(padapter->registrypriv.band_type)) {
		band = wiphy->bands[NL80211_BAND_5GHZ];
	}
#endif

	if (band) {
		memset(&cfg->change_virtual_intf.band, 0,
			sizeof(struct __wfo_ieee80211_supported_band));

		memcpy(&cfg->change_virtual_intf.band.source, band,
			sizeof(struct ieee80211_supported_band));

		if (band->channels)
			memcpy(&cfg->change_virtual_intf.band.channels , band->channels,
				sizeof(struct ieee80211_channel));
		if (band->bitrates)
			memcpy(&cfg->change_virtual_intf.band.bitrates , band->bitrates,
				sizeof(struct ieee80211_rate));
		if (band->iftype_data)
			memcpy(&cfg->change_virtual_intf.band.iftype_data , band->iftype_data,
				sizeof(struct ieee80211_sband_iftype_data));
	}
#endif /* COPY_BAND_CAP */

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(change_virtual_intf));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */


//----------------------------------------------------------------------------
//rdev_add_key
//.add_key = cfg80211_rtw_add_key,

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_add_key(struct wiphy *wiphy,
		struct net_device *virt_ndev,
		u8 key_index,
		bool pairwise,
		const u8 *mac_addr,
		struct key_params *params)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(add_key));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(add_key));

	cfg->add_key.key_index = key_index;
	cfg->add_key.pairwise = pairwise;

	if (mac_addr) {
		cfg->add_key.mflags |= (1<<WFO_ADD_KEY_HAS_MAC_ADDR);
		memcpy(&cfg->add_key.mac_addr, mac_addr, ETH_ALEN);
	}

	if (params) {
		cfg->add_key.mflags |= (1<<WFO_ADD_KEY_HAS_PARAMS);
		wfo_copy_struct_data(wfo_ipc_sender,
			WFO_STRUCT_TYPE(key_params),
			&cfg->add_key.data.source,
			params);
	}

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

    WFO_SENDER_TRACE_OUT(WFO_CMD(add_key));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_add_key(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;
	u8 *mac_addr = NULL;
	struct key_params *params = NULL;;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(add_key));

	if (cfg->add_key.mflags & (1<<WFO_ADD_KEY_HAS_MAC_ADDR))
		mac_addr = cfg->add_key.mac_addr;

	if (cfg->add_key.mflags & (1<<WFO_ADD_KEY_HAS_PARAMS)) {
		params = &cfg->add_key.data.source;
		params->key = cfg->add_key.data.key;
		params->seq = cfg->add_key.data.seq;
	/*
		wfo_copy_struct_data(wfo_ipc_receiver,
			WFO_STRUCT_TYPE(key_params),
			params,
			&cfg->add_key.data.source);
	*/
	}

	ret = wfo_cfg_ops(wiphy)->add_key(wiphy, radio_ndev, cfg->add_key.key_index,
				cfg->add_key.pairwise, mac_addr, params);
	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(add_key));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */


//----------------------------------------------------------------------------
//rdev_get_key
//.get_key = cfg80211_rtw_get_key,

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_get_key(struct wiphy *wiphy,
		struct net_device *virt_ndev,
		u8 keyid,
		bool pairwise,
		const u8 *mac_addr,
		void *cookie,
		void (*callback)(void *cookie, struct key_params *))
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(get_key));
	struct key_params *params = NULL;

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(get_key));

	cfg->get_key.keyid = keyid;
	cfg->get_key.pairwise = pairwise;

	if (mac_addr) {
		cfg->get_key.mflags |= (1<<WFO_GET_KEY_HAS_MAC_ADDR);
		memcpy(&cfg->get_key.mac_addr, mac_addr, ETH_ALEN);
	}

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

	params = &cfg->get_key.data.source;
	if (params->key)
		params->key = cfg->get_key.data.key;
	if (params->seq)
		params->seq = cfg->get_key.data.seq;

	if (callback) { /* get_key_callback */
		callback(cookie, params);
	}

    WFO_SENDER_TRACE_OUT(WFO_CMD(get_key));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_get_key(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;
	u8 *mac = NULL;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(get_key));

	if (cfg->get_key.mflags & (1<<WFO_GET_KEY_HAS_MAC_ADDR))
		mac = cfg->get_key.mac_addr;

	/* pass cfg->get_key.data to copy struct key_params */
	ret = wfo_cfg_ops(wiphy)->get_key(wiphy, radio_ndev,
			cfg->get_key.keyid, cfg->get_key.pairwise,
			mac, (void *)&cfg->get_key.data, NULL);
	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(get_key));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */

//----------------------------------------------------------------------------
//rdev_del_key
//.del_key = cfg80211_rtw_del_key,

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_del_key(struct wiphy *wiphy,
		struct net_device *virt_ndev,
		u8 key_index,
		bool pairwise,
		const u8 *mac_addr)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(del_key));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(del_key));

	cfg->del_key.key_index = key_index;
	cfg->del_key.pairwise = pairwise;
	if (mac_addr) {
		cfg->del_key.mflags |= WFO_DEL_KEY_HAS_MAC_ADDR;
		memcpy(&cfg->del_key.mac_addr, mac_addr, ETH_ALEN);
	}

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

    WFO_SENDER_TRACE_OUT(WFO_CMD(del_key));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_del_key(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;
	u8 *mac = NULL;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(del_key));

	if (cfg->del_key.mflags & (1<<WFO_DEL_KEY_HAS_MAC_ADDR))
		mac = cfg->del_key.mac_addr;

	ret = wfo_cfg_ops(wiphy)->del_key(wiphy, radio_ndev,
				cfg->del_key.key_index,
				cfg->del_key.pairwise, mac);
	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(del_key));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */


//----------------------------------------------------------------------------
//rdev_set_default_key
//.set_default_key = cfg80211_rtw_set_default_key,

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_set_default_key(struct wiphy *wiphy,
		struct net_device *virt_ndev,
		u8 key_index
		, bool unicast,
		bool multicast)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(set_default_key));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(set_default_key));

	cfg->set_default_key.key_index = key_index;
	cfg->set_default_key.unicast = unicast;
	cfg->set_default_key.multicast = multicast;

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

    WFO_SENDER_TRACE_OUT(WFO_CMD(set_default_key));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_set_default_key(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(set_default_key));

	ret = wfo_cfg_ops(wiphy)->set_default_key(wiphy, radio_ndev,
				cfg->set_default_key.key_index,
				cfg->set_default_key.unicast,
				cfg->set_default_key.multicast);
	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(set_default_key));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */


//----------------------------------------------------------------------------
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 30))
//rdev_set_default_mgmt_key
//.set_default_mgmt_key = cfg80211_rtw_set_default_mgmt_key,

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_set_default_mgmt_key(struct wiphy *wiphy,
		struct net_device *virt_ndev,
		u8 key_index)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(set_default_mgmt_key));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(set_default_mgmt_key));

	cfg->set_default_mgmt_key.key_index = key_index;

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

    WFO_SENDER_TRACE_OUT(WFO_CMD(set_default_mgmt_key));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_set_default_mgmt_key(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(set_default_mgmt_key));

	ret = wfo_cfg_ops(wiphy)->set_default_mgmt_key(wiphy, radio_ndev,
			cfg->set_default_mgmt_key.key_index);
	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(set_default_mgmt_key));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */
#endif

//----------------------------------------------------------------------------
//rdev_get_station
//.get_station = cfg80211_rtw_get_station,

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_get_station(struct wiphy *wiphy,
		struct net_device *virt_ndev,
		const u8 *mac,
		struct station_info *sinfo)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(get_station));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(get_station));

	if (mac) {
		cfg->get_station.mflags |= (1<<WFO_GET_STATION_HAS_MAC);
		memcpy(&cfg->get_station.mac, mac, ETH_ALEN);
	}

	if (sinfo) {
		cfg->get_station.mflags |= (1<<WFO_GET_STATION_HAS_SINFO);

#if 0
		memcpy(&cfg->get_station.data.source,
			sinfo, sizeof(struct station_info));

		if (sinfo->assoc_req_ies)
			memcpy(&cfg->get_station.data.assoc_req_ies,
				sinfo->assoc_req_ies,
				MIN(sinfo->assoc_req_ies_len, IEEE80211_MAX_DATA_LEN));

		if (sinfo->pertid)
			memcpy(&cfg->get_station.data.pertid, sinfo->pertid,
				sizeof(struct cfg80211_tid_stats));
#endif
	}

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

	if (ret == 0 && sinfo) {
		/* copy val to sinfo */
		memcpy(sinfo,
			&cfg->get_station.data.source,
			sizeof(struct station_info));

		if (sinfo->assoc_req_ies)
			memcpy(sinfo->assoc_req_ies,
				&cfg->get_station.data.assoc_req_ies,
				MIN(sinfo->assoc_req_ies_len, IEEE80211_MAX_DATA_LEN));

		if (sinfo->pertid)
			memcpy(sinfo->pertid, &cfg->get_station.data.pertid,
				sizeof(struct cfg80211_tid_stats));
	}

    WFO_SENDER_TRACE_OUT(WFO_CMD(get_station));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_get_station(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;
	struct station_info *sinfo = NULL;
	u8 *mac = NULL;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(get_station));

	if (cfg->get_station.mflags & (1<<WFO_GET_STATION_HAS_SINFO)) {
		sinfo = &cfg->get_station.data.source;

		sinfo->assoc_req_ies = sinfo->assoc_req_ies_len?
			cfg->get_station.data.assoc_req_ies:NULL;

		sinfo->pertid = sinfo->pertid?
			&cfg->get_station.data.pertid:NULL;
	}

	if (cfg->get_station.mflags & (1<<WFO_GET_STATION_HAS_MAC))
		mac = cfg->get_station.mac;

	ret = wfo_cfg_ops(wiphy)->get_station(wiphy, radio_ndev, mac, sinfo);
	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(get_station));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */

//----------------------------------------------------------------------------
//rdev_scan
//.scan = cfg80211_rtw_scan,

#if defined(WFO_VIRT_SENDER)
static void __sender_scan_no_6ghz(struct wiphy *wiphy,
		struct wfo_ndev_priv * ndev_priv,
		struct cfg80211_scan_request *request,
		wfo_cfg80211_t *cfg)
{
	unsigned int i, len = 0U;

	/* for wfo_radio_cmd_receiver_cfg80211_scan_done*/
	ndev_priv->scan_req = request;

	cfg->scan.mflags |= (1<<WFO_SCAN_HAS_REQUEST);

	/* copy request with *channel/ssids/ie */
	len = sizeof(*request) +
		sizeof(*request->ssids) * (u32)request->n_ssids +
		sizeof(*request->channels) * request->n_channels +
		request->ie_len;

#if (WFO_SHRINK_CFG_SIZE==1)
{
	wfo_dram_t *dram = RTK_SHM_DRAM;
	memcpy(&dram->md.cfg.scan.data.source, request, len);

	if (request->n_ssids) {
		for (i=0U;i<(u32)request->n_ssids;i++) {
			memcpy(&dram->md.cfg.scan.data.ssids[i], &request->ssids[i],
				sizeof(struct cfg80211_ssid));
		}
	}

	if (request->ie_len) {
		memcpy(dram->md.cfg.scan.data.ie, request->ie,
			MIN(request->ie_len, (u32)IEEE80211_MAX_DATA_LEN));
	}

	/* copy channel data */
	for (i=0U; i<(u32)request->n_channels; i++) {
		memcpy(&dram->md.cfg.scan.data.channels_data[i], request->channels[i],
			sizeof(struct ieee80211_channel));
	}

}
#else /* !WFO_SHRINK_CFG_SIZE */
	memcpy(&cfg->scan.data.source, request, len);

	if (request->n_ssids) {
		for (i=0U;i<(u32)request->n_ssids;i++) {
			memcpy(&cfg->scan.data.ssids[i] , &request->ssids[i],
				sizeof(struct cfg80211_ssid));
		}
	}

	if (request->ie_len) {
		memcpy(cfg->scan.data.ie, request->ie,
			MIN(request->ie_len, (u32)IEEE80211_MAX_DATA_LEN));
	}

	/* copy channel data */
	for (i=0U; i<(u32)request->n_channels; i++) {
		memcpy(&cfg->scan.data.channels_data[i], request->channels[i],
			sizeof(struct ieee80211_channel));
	}
#endif /* WFO_SHRINK_CFG_SIZE */
}

#ifdef WFO_K510
static void __sender_scan_part_6ghz(struct wiphy *wiphy,
		struct wfo_ndev_priv * ndev_priv,
		struct cfg80211_scan_request *request,
		wfo_cfg80211_t *cfg)
{
	__sender_scan_no_6ghz(wiphy, ndev_priv, request, cfg);

	/* for wfo_radio_cmd_receiver_cfg80211_scan_done*/
	ndev_priv->int_scan_req = ndev_priv->scan_req = request;
}

#include "../../../../net/wireless/core.h"
static void __sender_scan_6ghz(struct wiphy *wiphy,
		struct wfo_ndev_priv * ndev_priv,
		struct cfg80211_scan_request *request,
		wfo_cfg80211_t *cfg)
{
	//int n_channels;
	//struct cfg80211_registered_device *rdev = wiphy_to_rdev(wiphy);

	WFO_WARN("not support!!\n");

	//n_channels = rdev->wiphy.bands[NL80211_BAND_6GHZ]->n_channels;

	/* for wfo_radio_cmd_receiver_cfg80211_scan_done*/
	ndev_priv->int_scan_req = ndev_priv->scan_req = request;
}
#endif /* WFO_K510 */

static int wfo_virt_cmd_sender_scan(struct wiphy *wiphy
		, struct cfg80211_scan_request *request)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = NULL;
	unsigned int i, n_channels = 0U;
	wfo_dram_t *dram = RTK_SHM_DRAM;

	if (dram->is_scanning) {
		return 0;
	} else {
		dram->is_scanning = 1U;
	}

	if (!request) {
		printk("%s(): request=%p\n", __func__, request);
		return 0;
	}

	cfg = get_cfg_addr(wdev_to_ndev(request->wdev), RUN_REMOTELY, WFO_CMD(scan));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(scan));

	//if (request)
	{
		struct wfo_ndev_priv *ndev_priv =
			(struct wfo_ndev_priv *)netdev_priv(wdev_to_ndev(request->wdev));

	#ifdef WFO_K510
		if (!(wiphy->flags & (u32)WIPHY_FLAG_SPLIT_SCAN_6GHZ)) {
			cfg->scan.cond = SCAN_NO_6GHZ;
		} else {
			for (i = 0U; i < request->n_channels; i++) {
				if (request->channels[i]->band != (u32)NL80211_BAND_6GHZ)
					n_channels++;
			}

			if (!n_channels) {
				cfg->scan.cond = SCAN_6GHZ;
			} else {
				cfg->scan.cond = SCAN_PART_6GHZ;
			}
		}

		switch(cfg->scan.cond) {
		case SCAN_NO_6GHZ:
			__sender_scan_no_6ghz(wiphy, ndev_priv, request, cfg);
			break;
		case SCAN_PART_6GHZ:
			__sender_scan_part_6ghz(wiphy, ndev_priv, request, cfg);
			break;
		case SCAN_6GHZ:
			__sender_scan_6ghz(wiphy, ndev_priv, request, cfg);
			break;
		default:
			WFO_WARN("not support!!\n");
			break;
		}
	#else /* !WFO_K510 */
		__sender_scan_no_6ghz(wiphy, ndev_priv, request, cfg);
	#endif /* WFO_K510 */
	}

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

	WFO_SENDER_TRACE_OUT(WFO_CMD(scan));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static void __receiver_scan_no_6ghz(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		struct cfg80211_scan_request *request,
		struct __wfo_cfg80211_scan_request *req,
		wfo_cfg80211_t *cfg)
{
	int i, len = 0;
#if (WFO_SHRINK_CFG_SIZE==1)
	wfo_dram_t *dram = RTK_SHM_DRAM;

	memcpy(request, &dram->md.cfg.scan.data.source,
		sizeof(struct cfg80211_scan_request));

	len = sizeof(*request) +
		sizeof(*request->ssids) * request->n_ssids +
		sizeof(*request->channels) * request->n_channels +
		request->ie_len;

	memcpy(req, &dram->md.cfg.scan.data,
		sizeof(struct __wfo_cfg80211_scan_request));

	if (request->n_ssids)
		request->ssids = (void *)&dram->md.cfg.scan.data.ssids[0];

	if (request->ie_len)
		request->ie = dram->md.cfg.scan.data.ie;

	for (i=0; i<request->n_channels; i++) {
		request->channels[i] = &dram->md.cfg.scan.data.channels_data[i];
	}
#else /* !WFO_SHRINK_CFG_SIZE */
	memcpy(request, &cfg->scan.data.source,
		sizeof(struct cfg80211_scan_request));

	len = sizeof(*request) +
		sizeof(*request->ssids) * request->n_ssids +
		sizeof(*request->channels) * request->n_channels +
		request->ie_len;

	memcpy(req, &cfg->scan.data,
		sizeof(struct __wfo_cfg80211_scan_request));

	if (request->n_ssids)
		request->ssids = (void *)&cfg->scan.data.ssids[0];

	if (request->ie_len)
		request->ie = cfg->scan.data.ie;

	for (i=0; i<request->n_channels; i++) {
		request->channels[i] = &cfg->scan.data.channels_data[i];
	}
#endif /* WFO_SHRINK_CFG_SIZE */
	request->wdev = ndev_to_wdev(radio_ndev);
	request->wiphy = wiphy;
}

#ifdef WFO_K510
static void __receiver_scan_part_6ghz(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		struct cfg80211_scan_request *request,
		struct __wfo_cfg80211_scan_request *req,
		wfo_cfg80211_t *cfg)
{
	WFO_WARN("not support!!\n");
}

static void __receiver_scan_6ghz(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		struct cfg80211_scan_request *request,
		struct __wfo_cfg80211_scan_request *req,
		wfo_cfg80211_t *cfg)
{
	WFO_WARN("not support!!\n");
}
#endif /* WFO_K510 */

static int wfo_virt_cmd_receiver_scan(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;
	struct __wfo_cfg80211_scan_request _req, *req = &_req;
	struct cfg80211_scan_request *request = (struct cfg80211_scan_request *)req;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(scan));
	memset(req, 0, sizeof(struct __wfo_cfg80211_scan_request));

	if (cfg->scan.mflags & (1<<WFO_SCAN_HAS_REQUEST)) {
	#ifdef WFO_K510
		switch(cfg->scan.cond) {
		case SCAN_NO_6GHZ:
			__receiver_scan_no_6ghz(wiphy, radio_ndev, request, req, cfg);
			break;
		case SCAN_PART_6GHZ:
			__receiver_scan_part_6ghz(wiphy, radio_ndev, request, req, cfg);
			break;
		case SCAN_6GHZ:
			__receiver_scan_6ghz(wiphy, radio_ndev, request, req, cfg);
			break;
		default:
			WFO_WARN("not support!!\n");
			break;
		}
	#else /* !WFO_K510 */
		__receiver_scan_no_6ghz(wiphy, radio_ndev, request, req, cfg);
	#endif /* WFO_K510 */
	} else {
		request = NULL;
	}

	ret = wfo_cfg_ops(wiphy)->scan(wiphy, request);
	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(scan));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */


//----------------------------------------------------------------------------
//rdev_set_wiphy_params
//.set_wiphy_params = cfg80211_rtw_set_wiphy_params,

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_set_wiphy_params(struct wiphy *wiphy,
		u32 changed)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(wiphy_to_ndev(wiphy), RUN_LOCALLY, WFO_CMD(set_wiphy_params));
	/* cfg80211_rtw_set_wiphy_params do nothing, run on host */

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(set_wiphy_params));

	RTW_INFO("%s\n", __func__);

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

    WFO_SENDER_TRACE_OUT(WFO_CMD(set_wiphy_params));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_set_wiphy_params(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(set_wiphy_params));

#if 0 /*cfg80211_rtw_set_wiphy_params do nothing, run on host */
	ret = wfo_cfg_ops(wiphy)->set_wiphy_params(wiphy, cfg->set_wiphy_params.changed);
	cfg->ret_val = ret;
#else
	cfg->ret_val = ret;
#endif

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(set_wiphy_params));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */


//----------------------------------------------------------------------------
//rdev_connect
//.connect = cfg80211_rtw_connect,

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_connect(struct wiphy *wiphy,
		struct net_device *virt_ndev,
		struct cfg80211_connect_params *sme)
{
	int ret = 0, i = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY,  WFO_CMD(connect));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(connect));

	if (sme) {
		cfg->connect.mflags |= (1<<WFO_CONNECT_HAS_SME);

		memcpy(&cfg->connect.data.source, sme,
			sizeof(struct cfg80211_connect_params));

		if (sme->channel)
			memcpy(&cfg->connect.data.channel, sme->channel,
				sizeof(struct ieee80211_channel));

		if (sme->channel_hint)
			memcpy(&cfg->connect.data.channel_hint, sme->channel_hint,
				sizeof(struct ieee80211_channel));

		if (sme->bssid)
			memcpy(&cfg->connect.data.bssid, sme->bssid, ETH_ALEN);
		if (sme->bssid_hint)
			memcpy(&cfg->connect.data.bssid_hint, sme->bssid_hint, ETH_ALEN);
		if (sme->ssid)
			memcpy(&cfg->connect.data.ssid, sme->ssid,
				MIN(sme->ssid_len, IEEE80211_MAX_SSID_LEN));
		if (sme->ie)
			memcpy(&cfg->connect.data.ie, sme->ie,
				MIN(sme->ie_len, IEEE80211_MAX_DATA_LEN));

		/* struct cfg80211_crypto_settings crypto */
		if (sme->crypto.wep_keys) {
			memcpy(cfg->connect.data.crypto.wep_keys,
			       sme->crypto.wep_keys,
			       sizeof(cfg->connect.data.crypto.wep_keys));
			for (i = 0; i < CFG80211_MAX_WEP_KEYS; i++) {
				if (sme->crypto.wep_keys[i].key)
					memcpy(cfg->connect.data.crypto.key[i],
					       sme->crypto.wep_keys[i].key,
					       MIN(sme->crypto.wep_keys[i].key_len, WLAN_KEY_LEN_WEP104));
				/* seq is not used for WEP */
				WARN_ON(sme->crypto.wep_keys[i].seq);
			}
		}

		if (sme->crypto.psk)
			memcpy(cfg->connect.data.crypto.psk, sme->crypto.psk, (u32)WLAN_PMK_LEN);

#ifdef WFO_K510
		if (sme->crypto.sae_pwd)
			memcpy(cfg->connect.data.crypto.sae_pwd, sme->crypto.sae_pwd, MIN(sme->crypto.sae_pwd_len, SAE_PASSWORD_MAX_LEN));
#endif /* WFO_K510 */

		if (sme->key_len)
			memcpy(&cfg->connect.data.key, sme->key,
				MIN(sme->key_len, WLAN_MAX_KEY_LEN));

		if (sme->prev_bssid)
			memcpy(&cfg->connect.data.prev_bssid, sme->prev_bssid, ETH_ALEN);

		if (sme->fils_erp_username)
			memcpy(&cfg->connect.data.fils_erp_username,
				sme->fils_erp_username,
				MIN(sme->fils_erp_username_len, FILS_ERP_MAX_USERNAME_LEN));

		if (sme->fils_erp_realm)
			memcpy(&cfg->connect.data.fils_erp_realm, sme->fils_erp_realm,
				MIN(sme->fils_erp_realm_len, FILS_ERP_MAX_REALM_LEN));

		if (sme->fils_erp_rrk)
			memcpy(&cfg->connect.data.fils_erp_rrk,
				sme->fils_erp_rrk, MIN(sme->fils_erp_rrk_len, FILS_ERP_MAX_RRK_LEN));
	}

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;
	if(ret == 0 && (virt_ndev->operstate != IF_OPER_UP))
	{
		netif_carrier_on(virt_ndev);
	}
    WFO_SENDER_TRACE_OUT(WFO_CMD(connect));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_connect(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0, i = 0;
	struct cfg80211_connect_params _sme, *sme = &_sme;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(connect));

	if (cfg->connect.mflags & (1<<WFO_CONNECT_HAS_SME)) {
		memset(sme, 0, sizeof(struct cfg80211_connect_params));

		memcpy(sme, &cfg->connect.data.source,
			sizeof(struct cfg80211_connect_params));

		sme->channel = sme->channel?&cfg->connect.data.channel:NULL;
		sme->channel_hint = sme->channel_hint?
			&cfg->connect.data.channel_hint:NULL;

		sme->bssid = sme->bssid?cfg->connect.data.bssid:NULL;

		sme->bssid_hint = sme->bssid_hint?cfg->connect.data.bssid_hint:NULL;

		sme->ssid = sme->ssid?cfg->connect.data.ssid:NULL;
		sme->ie = sme->ie?cfg->connect.data.ie:NULL;

		/* struct cfg80211_crypto_settings crypto */
		if (sme->crypto.wep_keys) {
			sme->crypto.wep_keys = cfg->connect.data.crypto.wep_keys;
			for (i = 0; i < CFG80211_MAX_WEP_KEYS; i++) {
				if (sme->crypto.wep_keys[i].key)
					sme->crypto.wep_keys[i].key = cfg->connect.data.crypto.key[i];
				/* seq is not used for WEP */
				WARN_ON(sme->crypto.wep_keys[i].seq);
			}
		}

		sme->crypto.psk = sme->crypto.psk?cfg->connect.data.crypto.psk:NULL;
	#ifdef WFO_K510
		sme->crypto.sae_pwd = sme->crypto.sae_pwd?cfg->connect.data.crypto.sae_pwd:NULL;
	#endif /* WFO_K510 */

		sme->key = sme->key?cfg->connect.data.key:NULL;
		sme->prev_bssid = sme->prev_bssid?cfg->connect.data.prev_bssid:NULL;

		sme->fils_erp_username = sme->fils_erp_username?
			cfg->connect.data.fils_erp_username:NULL;
		sme->fils_erp_realm = sme->fils_erp_realm?
			cfg->connect.data.fils_erp_realm:NULL;
		sme->fils_erp_rrk = sme->fils_erp_rrk?
			cfg->connect.data.fils_erp_rrk:NULL;
	} else {
		sme = NULL;
	}

	ret = wfo_cfg_ops(wiphy)->connect(wiphy, radio_ndev, sme);
	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(connect));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */


//----------------------------------------------------------------------------
//rdev_disconnect
//.disconnect = cfg80211_rtw_disconnect,

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_disconnect(struct wiphy *wiphy,
		struct net_device *virt_ndev,
		u16 reason_code)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(disconnect));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(disconnect));

	cfg->disconnect.reason_code = reason_code;

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

    WFO_SENDER_TRACE_OUT(WFO_CMD(disconnect));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_disconnect(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(disconnect));

	ret = wfo_cfg_ops(wiphy)->disconnect(wiphy, radio_ndev, cfg->disconnect.reason_code);
	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(disconnect));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */


//----------------------------------------------------------------------------
//rdev_join_ibss
//.join_ibss = cfg80211_rtw_join_ibss,

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_join_ibss(struct wiphy *wiphy,
		struct net_device *virt_ndev,
		struct cfg80211_ibss_params *params)
{
	int ret = 0, i = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(join_ibss));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(join_ibss));

	if (params) {
		cfg->join_ibss.mflags |= (1<<WFO_JOIN_IBSS_HAS_PARAMS);

		memcpy(&cfg->join_ibss.data.source, params,
			sizeof(struct cfg80211_ibss_params));

		if (params->ssid)
			memcpy(&cfg->join_ibss.data.ssid, params->ssid,
				MIN(params->ssid_len, IEEE80211_MAX_SSID_LEN));

		if (params->bssid)
			memcpy(&cfg->join_ibss.data.bssid, params->bssid, ETH_ALEN);

		wfo_copy_struct_data(wfo_ipc_sender,
			WFO_STRUCT_TYPE(cfg80211_chan_def),
			&cfg->join_ibss.data.chandef.source,
			&params->chandef);

		if (params->ie)
			memcpy(&cfg->join_ibss.data.ie, params->ie,
				MIN(params->ie_len, 0xFF)); /* max value of params->ie_len is 0xFF */

		if (params->wep_keys) {
			memcpy(cfg->join_ibss.data.wep_keys, params->wep_keys,
			       sizeof(cfg->join_ibss.data.wep_keys));
			for (i = 0; i < CFG80211_MAX_WEP_KEYS; i++) {
				if (params->wep_keys[i].key)
					memcpy(cfg->join_ibss.data.key[i],
					       params->wep_keys[i].key,
					       MIN(params->wep_keys[i].key_len, WLAN_KEY_LEN_WEP104));
				/* seq is not used for WEP */
				WARN_ON(params->wep_keys[i].seq);
			}
		}
	}

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

    WFO_SENDER_TRACE_OUT(WFO_CMD(join_ibss));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_join_ibss(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0, i = 0;
	struct cfg80211_ibss_params _params, *params = &_params;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(join_ibss));

	if (cfg->join_ibss.mflags & (1<<WFO_JOIN_IBSS_HAS_PARAMS)) {
		memset(params, 0, sizeof(struct cfg80211_ibss_params));

		memcpy(params, &cfg->join_ibss.data.source,
			sizeof(struct cfg80211_ibss_params));

		params->ssid = params->ssid_len?cfg->join_ibss.data.ssid:NULL;
		params->bssid = params->bssid?cfg->join_ibss.data.bssid:NULL;

		wfo_copy_struct_data(wfo_ipc_receiver,
			WFO_STRUCT_TYPE(cfg80211_chan_def),
			&params->chandef,
			&cfg->join_ibss.data.chandef.source);
		(&params->chandef)->chan =
			ieee80211_get_channel(wiphy, (&params->chandef)->chan->center_freq);

		params->ie = params->ie_len?cfg->join_ibss.data.ie:NULL;

		if (params->wep_keys) {
			params->wep_keys = cfg->join_ibss.data.wep_keys;
			for (i = 0; i < CFG80211_MAX_WEP_KEYS; i++) {
				if (params->wep_keys[i].key)
					params->wep_keys[i].key = cfg->join_ibss.data.key[i];
				/* seq is not used for WEP */
				WARN_ON(params->wep_keys[i].seq);
			}
		}
	} else {
		params = NULL;
	}

	ret = wfo_cfg_ops(wiphy)->join_ibss(wiphy, radio_ndev, params);
	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(join_ibss));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */

//----------------------------------------------------------------------------
//rdev_leave_ibss
//.leave_ibss = cfg80211_rtw_leave_ibss,

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_leave_ibss(struct wiphy *wiphy,
		struct net_device *virt_ndev)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(leave_ibss));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(leave_ibss));

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

    WFO_SENDER_TRACE_OUT(WFO_CMD(leave_ibss));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_leave_ibss(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(leave_ibss));

	ret = wfo_cfg_ops(wiphy)->leave_ibss(wiphy, radio_ndev);
	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(leave_ibss));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */

//----------------------------------------------------------------------------
//rdev_set_tx_power
//.set_tx_power = cfg80211_rtw_set_txpower,

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_set_tx_power(struct wiphy *wiphy,
		struct wireless_dev *wdev,
		enum nl80211_tx_power_setting type,
		int mbm)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(wdev_to_ndev(wdev), RUN_REMOTELY, WFO_CMD(set_tx_power));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(set_tx_power));

	cfg->set_tx_power.type = type;
	cfg->set_tx_power.mbm = mbm;

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

    WFO_SENDER_TRACE_OUT(WFO_CMD(set_tx_power));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_set_tx_power(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;
	struct wireless_dev *wdev = ndev_to_wdev(radio_ndev);

	WFO_RECEIVER_TRACE_IN(WFO_CMD(set_tx_power));

	ret = wfo_cfg_ops(wiphy)->set_tx_power(wiphy, wdev,
			cfg->set_tx_power.type, cfg->set_tx_power.mbm);
	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(set_tx_power));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */

//----------------------------------------------------------------------------
//rdev_get_tx_power
//.get_tx_power = cfg80211_rtw_get_txpower,

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_get_tx_power(struct wiphy *wiphy,
		struct wireless_dev *wdev,
		int *dbm)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(wdev_to_ndev(wdev), RUN_LOCALLY, WFO_CMD(get_tx_power));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(get_tx_power));

#if 1 /* dbm is fixed value in cfg80211_rtw_get_txpower() */
	*dbm = (12);
#else
	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;
#endif

    WFO_SENDER_TRACE_OUT(WFO_CMD(get_tx_power));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_get_tx_power(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;
	struct wireless_dev *wdev = ndev_to_wdev(radio_ndev);
	int dbm;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(get_tx_power));

	ret = wfo_cfg_ops(wiphy)->get_tx_power(wiphy, wdev, &cfg->get_tx_power.dbm);
	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(get_tx_power));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */


//----------------------------------------------------------------------------
//rdev_set_power_mgmt
//.set_power_mgmt = cfg80211_rtw_set_power_mgmt,

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_set_power_mgmt(struct wiphy *wiphy,
	   struct net_device *virt_ndev,
	   bool enabled,
	   int timeout)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(set_power_mgmt));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(set_power_mgmt));

	cfg->set_power_mgmt.enabled = enabled;
	cfg->set_power_mgmt.timeout = timeout;

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

    WFO_SENDER_TRACE_OUT(WFO_CMD(set_power_mgmt));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_set_power_mgmt(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(set_power_mgmt));

	ret = wfo_cfg_ops(wiphy)->set_power_mgmt(wiphy, radio_ndev,
			cfg->set_power_mgmt.enabled, cfg->set_power_mgmt.timeout);
	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(set_power_mgmt));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */

//----------------------------------------------------------------------------
//rdev_set_pmksa
//.set_pmksa = cfg80211_rtw_set_pmksa,

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_set_pmksa(struct wiphy *wiphy,
		struct net_device *virt_ndev,
		struct cfg80211_pmksa *pmksa)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(set_pmksa));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(set_pmksa));

	if (pmksa) {
		cfg->set_pmksa.mflags |= (1<<WFO_SET_PMKSA_HAS_PMKSA);
		wfo_copy_struct_data(wfo_ipc_sender,
			WFO_STRUCT_TYPE(cfg80211_pmksa),
			&cfg->set_pmksa.data.source,
			pmksa);
	}

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

    WFO_SENDER_TRACE_OUT(WFO_CMD(set_pmksa));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_set_pmksa(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;
	struct cfg80211_pmksa _pmksa, *pmksa = &_pmksa;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(set_pmksa));

	if (cfg->set_pmksa.mflags & (1<<WFO_SET_PMKSA_HAS_PMKSA)) {
		memset(pmksa, 0, sizeof(struct cfg80211_pmksa));
		wfo_copy_struct_data(wfo_ipc_receiver,
			WFO_STRUCT_TYPE(cfg80211_pmksa),
			pmksa,
			&cfg->set_pmksa.data.source);
	} else {
		pmksa = NULL;
	}

	ret = wfo_cfg_ops(wiphy)->set_pmksa(wiphy, radio_ndev, pmksa);
	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(set_pmksa));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */

//----------------------------------------------------------------------------
//rdev_del_pmksa
//.del_pmksa = cfg80211_rtw_del_pmksa,

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_del_pmksa(struct wiphy *wiphy,
		struct net_device *virt_ndev,
		struct cfg80211_pmksa *pmksa)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY,  WFO_CMD(del_pmksa));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(del_pmksa));

	if (pmksa) {
		cfg->del_pmksa.mflags |= (1<<WFO_DEL_PMKSA_HAS_PMKSA);
		wfo_copy_struct_data(wfo_ipc_sender,
			WFO_STRUCT_TYPE(cfg80211_pmksa),
			&cfg->del_pmksa.data,
			pmksa);
	}

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

    WFO_SENDER_TRACE_OUT(WFO_CMD(del_pmksa));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_del_pmksa(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;
	struct cfg80211_pmksa _pmksa, *pmksa = &_pmksa;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(del_pmksa));

	if (cfg->del_pmksa.mflags & (1<<WFO_DEL_PMKSA_HAS_PMKSA)) {
		memset(pmksa, 0, sizeof(struct cfg80211_pmksa));
		wfo_copy_struct_data(wfo_ipc_receiver,
			WFO_STRUCT_TYPE(cfg80211_pmksa),
			pmksa,
			&cfg->del_pmksa.data);
	} else {
		pmksa = NULL;
	}

	ret = wfo_cfg_ops(wiphy)->del_pmksa(wiphy, radio_ndev, pmksa);
	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(del_pmksa));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */

//----------------------------------------------------------------------------
//rdev_flush_pmksa
//.flush_pmksa = cfg80211_rtw_flush_pmksa,

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_flush_pmksa(struct wiphy *wiphy,
		struct net_device *virt_ndev)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(flush_pmksa));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(flush_pmksa));

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

    WFO_SENDER_TRACE_OUT(WFO_CMD(flush_pmksa));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_flush_pmksa(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(flush_pmksa));

	ret = wfo_cfg_ops(wiphy)->flush_pmksa(wiphy, radio_ndev);
	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(flush_pmksa));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */

#ifdef CONFIG_AP_MODE
//----------------------------------------------------------------------------
//rdev_add_virtual_intf
//.add_virtual_intf = cfg80211_rtw_add_virtual_intf,

#if defined(WFO_VIRT_SENDER)
static struct wireless_dev *wfo_virt_cmd_sender_add_virtual_intf(
		struct wiphy *wiphy,
		const char *name,
		unsigned char name_assign_type,
		enum nl80211_iftype type,
		struct vif_params *params)
{
	int ret = 0, err = -ENODEV;
	struct wireless_dev *wdev = NULL;
	struct net_device *virt_ndev = NULL;
	wfo_cfg80211_t *cfg = NULL;
	struct wfo_wiphy_data *wiphy_data = wiphy_priv(wiphy);
	unsigned int idx = 0U, wiphy_name_len = 0U;
	extern int get_pe_reset_intf_status(int idx);
	extern int set_pe_reset_intf_status(int idx, int value);

	if (!name)
		goto out;

	wiphy_name_len = strlen(wiphy_data->dev_name);

	if (strncasecmp(name, wiphy_data->dev_name, wiphy_name_len)==0) {
		if (rtl8198d_wfo_wlandev_idx(name, &idx) == 0U)
			goto out;
	} else {
		goto out;
	}

	if (idx) {
#if defined(CONFIG_RTW_PERSIST_IF) || defined(CPTCFG_RTW_PERSIST_IF)
		/* If the creating interface exists already, return it instead of return failure */
		virt_ndev = wfo_dev_get_by_name(&init_net, name);
		/* check PE is reseting or not */
		if (get_pe_reset_intf_status((s32)idx) == 0) {
			if(virt_ndev)
			{
				RTW_INFO("Finding existing ndev of name \"%s\"...\n", name);
				if(!(virt_ndev->flags & (u32)IFF_UP))
				{
					wfo_virt_cmd_sender_change_virtual_intf(wiphy, virt_ndev, type, NULL);
					/* Clear IFF_DONT_BRIDGE to allow interface added to bridge */
					if (type == (u32)NL80211_IFTYPE_AP) {
						virt_ndev->priv_flags &= ~((u32)IFF_DONT_BRIDGE);
					}
				}

				wdev = virt_ndev->ieee80211_ptr;
				err = 0;
				goto out;
			}
			else
#endif
			{
				RTW_INFO("Creating new interface \"%s\"...\n", name);
				virt_ndev = wfo_virt_iface_alloc_etherdev();
				wfo_virt_iface_register_netdev(virt_ndev, wiphy, NL80211_IFTYPE_STATION, idx);
			}
#if defined(CONFIG_RTW_PERSIST_IF) || defined(CPTCFG_RTW_PERSIST_IF)
		}
		else {
			RTW_INFO("PE recover: Creating new interface \"%s\" for PE...\n", name);
			if (!virt_ndev)
				goto out;
			set_pe_reset_intf_status((s32)idx, 0);
		}
#endif
	}

	if (virt_ndev)
		wdev = virt_ndev->ieee80211_ptr;

	cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(add_virtual_intf));

	if (cfg == NULL)
		goto out;

	memcpy(cfg->add_virtual_intf.name, cfg->dev_name,
			MIN(strlen(cfg->dev_name), IFNAMSIZ));

	WFO_SENDER_TRACE_IN(WFO_CMD(add_virtual_intf));

	cfg->add_virtual_intf.name_assign_type = name_assign_type;
	cfg->add_virtual_intf.type = type;

	if (params) {
		/* struct vif_params *params, not use */
	}

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

#if defined(WFO_GETMIB_IN_SHM)
	{
		struct wfo_ndev_priv *ndev_priv = (struct wfo_ndev_priv *)netdev_priv(virt_ndev);
		ndev_priv->wfo_mib_idx = cfg->add_virtual_intf.wfo_mib_idx;
	}
#endif /* WFO_GETMIB_IN_SHM */

#ifdef CONFIG_RTK_WFO_NO_VIRT
	if (ret == 0) {
		wdev = cfg->add_virtual_intf.wdev;
		wdev->iftype = type;
	}
#else /* !CONFIG_RTK_WFO_NO_VIRT */
	if (wdev && ret == 0) {
		wdev->iftype = type;
		virt_ndev->priv_flags &= ~((u32)IFF_DONT_BRIDGE);
		rtw_virt_adapter_proc_init(virt_ndev);

	#if (WFO_DBG_DEV_FLAGS==1)
		if (virt_ndev->flags != cfg->add_virtual_intf.ndev_flags ||
			virt_ndev->priv_flags!= cfg->add_virtual_intf.ndev_priv_flags) {
			printk("==> [%s:%d], virto: flags=0x%x, priv_flags=0x%x, dev=%s\n", 
				__func__, __LINE__, virt_ndev->flags, virt_ndev->priv_flags, virt_ndev);
			printk("==> [%s:%d], radio: flags=0x%x, priv_flags=0x%x\n", \
				__func__, __LINE__, cfg->add_virtual_intf.ndev_flags, cfg->add_virtual_intf.ndev_priv_flags);
		}
	#endif /* WFO_DBG_DEV_FLAGS */
	}
#endif /* CONFIG_RTK_WFO_NO_VIRT */

	 err = 0;

exit:
    WFO_SENDER_TRACE_OUT(WFO_CMD(add_virtual_intf));
out:
	if (err)
		return -ENODEV;

	return wdev;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_add_virtual_intf(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;
	struct wireless_dev *wdev = NULL;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(add_virtual_intf));

	wdev = wfo_cfg_ops(wiphy)->add_virtual_intf(wiphy, cfg->add_virtual_intf.name,
				cfg->add_virtual_intf.name_assign_type,
				cfg->add_virtual_intf.type, NULL);
	cfg->ret_val = ret;

#ifdef CONFIG_RTK_WFO_NO_VIRT
	cfg->add_virtual_intf.wdev = wdev;
#endif /* CONFIG_RTK_WFO_NO_VIRT */

#ifdef __ECOS
	if (wdev) {
	#ifdef CYGPKG_NET
		extern void rtk_g6_wlan_vap_init(unsigned int dev_idx);
		rtk_g6_wlan_vap_init(cfg->dev_idx);
	#endif
		update_radio_map(wdev->netdev, cfg->dev_idx);

	#if (WFO_DBG_DEV_FLAGS==1)
		if (!radio_ndev) {
			radio_ndev = wdev->netdev;
		}
		cfg->add_virtual_intf.ndev_flags = radio_ndev->flags;
		cfg->add_virtual_intf.ndev_priv_flags = radio_ndev->priv_flags;
	#endif /* WFO_DBG_DEV_FLAGS */
	}
#endif /* __ECOS */

#if defined(WFO_GETMIB_IN_SHM)
	{
		_adapter *adapter = (_adapter *)rtw_netdev_priv(wdev->netdev);
		cfg->add_virtual_intf.wfo_mib_idx = adapter->iface_id;
	}
#endif /* WFO_GETMIB_IN_SHM */

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(add_virtual_intf));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */

//----------------------------------------------------------------------------
//rdev_del_virtual_intf
//.del_virtual_intf = cfg80211_rtw_del_virtual_intf,

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_del_virtual_intf(struct wiphy *wiphy,
		struct wireless_dev *wdev)
{
	int ret = 0;
	struct net_device *virt_ndev = wdev_to_ndev(wdev);
	struct wfo_ndev_priv *ndev_priv = (struct wfo_ndev_priv *)netdev_priv(virt_ndev);
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(del_virtual_intf));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(del_virtual_intf));

	wfo_virt_cmd_sender(cfg);

	ret = cfg->ret_val;

	/* ecos delete virtual interface successfully, or virtual interface net device doesn't exist in ecos*/
	if (ret == 0 || ret == -1) {
		/* reset cached device table */
		virt_map_tbl[cfg->dev_idx].ndev  = NULL;


#if defined(CONFIG_RTW_PERSIST_IF) || defined(CPTCFG_RTW_PERSIST_IF)
        /* Unregister all net devices when primary is being closed */
        if (ndev_priv->iface_id == 0) {
			RTW_INFO("%s %s: unregister primary ndev(s)\n", __FUNCTION__, virt_ndev->name);
#if !defined(CPTCFG_WFO_VIRT_SAME_CPU)
			rtw_virt_adapter_proc_deinit(virt_ndev);
#endif
			wfo_virt_iface_unregister_netdev(virt_ndev);
        } else {
			RTW_INFO("%s %s: Skip unregister ndev of non-primary ndev\n",
			          __FUNCTION__, virt_ndev->name);
			if (virt_ndev->flags & (u32)IFF_UP) {
					wfo_virt_cmd_sender_ndo_stop(virt_ndev);
			}
			wdev->beacon_interval = 0;
        }
#else

#if !defined(CPTCFG_WFO_VIRT_SAME_CPU)
		rtw_virt_adapter_proc_deinit(virt_ndev);
#endif
		wfo_virt_iface_unregister_netdev(virt_ndev);
#endif /* CONFIG_RTW_PERSIST_IF */

	}

	WFO_SENDER_TRACE_OUT(WFO_CMD(del_virtual_intf));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_del_virtual_intf(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;
	struct wireless_dev *wdev = ndev_to_wdev(radio_ndev);

	WFO_RECEIVER_TRACE_IN(WFO_CMD(del_virtual_intf));

	/* reset cached device table */
	//memset(&radio_map_tbl[cfg->dev_idx], 0, sizeof(struct dev_map_tbl_s));

	ret = wfo_cfg_ops(wiphy)->del_virtual_intf(wiphy, wdev);
#if defined( __ECOS) && defined(CYGPKG_NET)
	/* Delete VAP network interface in eCos */
	rtk_g6_wlan_vap_deinit(cfg->dev_idx);
#endif
	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(del_virtual_intf));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */

#if (LINUX_VERSION_CODE < KERNEL_VERSION(3, 4, 0)) && !defined(COMPAT_KERNEL_RELEASE)
#else

#if defined(WFO_VIRT_SENDER)
typedef void (*fptr)(void);

static struct cfg80211_ops *get_cfg80211_ops(char *devname)
{
	struct net_device *ndev = wfo_dev_get_by_name(&init_net, devname);
	struct cfg80211_registered_device *rdev = NULL;
	struct wiphy *wiphy = NULL;
	struct cfg80211_ops *ops = NULL;

	if (ndev)
		wiphy = ndev_to_wdev(ndev)->wiphy;
	if (wiphy)
		rdev = container_of(wiphy, struct cfg80211_registered_device, wiphy);
	if (rdev)
		ops = rdev->ops;
	return ops;
}

static s8 check_cfg80211_ops_entry(void)
{
	struct cfg80211_ops *ops_wfo = NULL;
	struct cfg80211_ops *ops_g6 = NULL;
	fptr *func1= NULL, *func2= NULL;
	u32 i = 0U;
	s8 ret = 0;

	ops_wfo = get_cfg80211_ops(WLAN_WFOVIRT);
	ops_g6 = get_cfg80211_ops(WLAN_G6);
	if (ops_wfo && ops_g6) {
		for (i=0U; i<sizeof(struct cfg80211_ops)/sizeof(void*); i++) {
			func1 = (fptr*)((u32)(ops_wfo) + i*sizeof(void*));
			func2 = (fptr*)((u32)(ops_g6)  + i*sizeof(void*));

			//printk("%s(): i=%d, *func(%p)(%p)\n", __func__, i, *func1, *func2);
			if ((*func1==0 && *func2) ||
				(*func1 && *func2==0)) {
				printk("\n\n\n\n\n\n\n\n"
					"FAIL!! %s(): please check struct cfg80211_ops offset(%u), *func(%p)(%p)!!\n"
					"\n\n\n\n\n\n\n\n",
					__func__, i*sizeof(void*), *func1, *func2);
				ret = 1;
			}
		}
	}

	return ret;
}

static s8 check_wfo_mib_size(void)
{
extern u32 get_sizeof_wfo_mib_t(void);
	u32 size1 = get_sizeof_wfo_mib_t();
	u32 size2 = sizeof(struct __wfo_mib);
	s8 ret = 0;

	if (size1 > size2) {
		printk("\n\n\n\n\n\n\n\n"
			"FAIL!! %s(): please check!! sizeof(wfo_mib_t)=%u > sizeof(struct __wfo_mib)=%u!!\n"
			"\n\n\n\n\n\n\n\n",
			__func__, size1, size2);
		ret = 1;
	}
	return ret;
}
#endif /* WFO_VIRT_SENDER */

//----------------------------------------------------------------------------
//rdev_start_ap
//.start_ap = cfg80211_rtw_start_ap,

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_start_ap(struct wiphy *wiphy,
		struct net_device *virt_ndev,
		struct cfg80211_ap_settings *settings)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(start_ap));

#if defined(WFO_CHECK_STRUCT_SZ)
	static int need_check = 1;
#endif /* WFO_CHECK_STRUCT_SZ */

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(start_ap));

	memcpy(&cfg->start_ap.data.source, settings,
		sizeof(struct cfg80211_ap_settings));

	wfo_copy_struct_data(wfo_ipc_sender,
		WFO_STRUCT_TYPE(cfg80211_chan_def),
		&cfg->start_ap.data.chandef.source,
		&settings->chandef);

#if (WFO_SHRINK_CFG_SIZE==1)
{
	wfo_dram_t *dram = RTK_SHM_DRAM;
	wfo_copy_struct_data(wfo_ipc_sender,
		WFO_STRUCT_TYPE(cfg80211_beacon_data),
		&dram->md.cfg.start_ap.beacon.source,
		&settings->beacon);
}
#else /* !WFO_SHRINK_CFG_SIZE */
	wfo_copy_struct_data(wfo_ipc_sender,
		WFO_STRUCT_TYPE(cfg80211_beacon_data),
		&cfg->start_ap.data.beacon.source,
		&settings->beacon);
#endif /* WFO_SHRINK_CFG_SIZE */

	if (settings->ssid) {
		memcpy(&cfg->start_ap.data.ssid, settings->ssid,
			MIN(settings->ssid_len, IEEE80211_MAX_SSID_LEN));
	}

	/* crypto */
	WARN_ON(settings->crypto.wep_keys); /* not used in start_ap */
	if (settings->crypto.psk)
		memcpy(&cfg->start_ap.data.crypto.psk, settings->crypto.psk, (u32)WLAN_PMK_LEN);
#ifdef WFO_K510
	if (settings->crypto.sae_pwd)
		memcpy(&cfg->start_ap.data.crypto.sae_pwd, settings->crypto.sae_pwd, MIN(settings->crypto.sae_pwd_len, SAE_PASSWORD_MAX_LEN));
#endif /* WFO_K510 */

	/* acl */
	if (settings->acl) {
		memcpy(&cfg->start_ap.data.acl.source, settings->acl,
			sizeof(struct cfg80211_acl_data)+(u32)settings->acl->n_acl_entries*ETH_ALEN);
	}

	if (settings->ht_cap) {
		memcpy(&cfg->start_ap.data.ht_cap, settings->ht_cap,
			sizeof(struct ieee80211_ht_cap));
	}
	if (settings->vht_cap) {
		memcpy(&cfg->start_ap.data.vht_cap, settings->vht_cap,
			sizeof(struct ieee80211_vht_cap));
	}
	if (settings->he_cap) {
		memcpy(&cfg->start_ap.data.he_cap, settings->he_cap,
			sizeof(struct ieee80211_he_cap_elem));
	}

#ifdef WFO_K510
{
	wfo_dram_t *dram = RTK_SHM_DRAM;
	if (settings->vht_cap) {
		memcpy(&cfg->start_ap.data.he_oper, settings->he_oper,
			sizeof(struct ieee80211_he_operation));
		#if 0 //not use?
		memcpy(&cfg->start_ap.data.optional, settings->he_oper.optional, 8);
		#endif
	}
	if (settings->fils_discovery.tmpl_len) {
		memcpy(&dram->md.cfg.start_ap.fils_discovery, settings->fils_discovery.tmpl,
			MIN(settings->fils_discovery.tmpl_len, IEEE80211_MAX_DATA_LEN));
	}
	if (settings->unsol_bcast_probe_resp.tmpl_len) {
		memcpy(&dram->md.cfg.start_ap.unsol_bcast_probe_resp, settings->unsol_bcast_probe_resp.tmpl,
			MIN(settings->unsol_bcast_probe_resp.tmpl_len, IEEE80211_MAX_DATA_LEN));
	}
}
#endif /* WFO_K510 */

#if defined(WFO_CHECK_STRUCT_SZ)
	if (need_check) {
		need_check = 0;
		cfg->start_ap.check_sz = 1;
		if (check_cfg80211_ops_entry() || check_wfo_mib_size()) {
			//ret = -ENOTSUPP;
			//goto exit;
			cfg->start_ap.check_sz = 0x57;
		}
		wfo_get_struct_size(&cfg->start_ap.linux_sz);
	}
#endif /* WFO_CHECK_STRUCT_SZ */

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;
	if(ret == 0 && (virt_ndev->operstate != IF_OPER_UP))
	{
		netif_carrier_on(virt_ndev);
	}

exit:
    WFO_SENDER_TRACE_OUT(WFO_CMD(start_ap));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_start_ap(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;
	struct cfg80211_ap_settings _settings, *settings = &_settings;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(start_ap));
	memset(settings, 0, sizeof(struct cfg80211_ap_settings));

#if defined(WFO_CHECK_STRUCT_SZ)
	if (cfg->start_ap.check_sz) {
		struct wfo_struct_sz *linux_sz = &cfg->start_ap.linux_sz;
		struct wfo_struct_sz *ecos_sz = &cfg->start_ap.ecos_sz;
		wfo_get_struct_size(ecos_sz);
		if (memcmp(linux_sz, ecos_sz, sizeof(struct wfo_struct_sz))!=0) {
			printk("\n\n\n\n" "FAIL!! (%s) please check structure size on eCos/Linux!!\n", __func__);
			wfo_show_struct_size(linux_sz, ecos_sz);
			ret = -ENOTSUPP;
			//goto exit;
		}
		{
			extern int mpool_entry_num_check(void);
			if (mpool_entry_num_check()) {
				ret = -ENOTSUPP;
				//goto exit;
			}
		}
	}

	if (ret == -ENOTSUPP || cfg->start_ap.check_sz>1) {
		ret = cfg->ret_val = -ENOTSUPP;
		goto busy_wait;
	}
#endif /* WFO_CHECK_STRUCT_SZ */

	memcpy(settings, &cfg->start_ap.data.source,
		sizeof(struct cfg80211_ap_settings));

	wfo_copy_struct_data(wfo_ipc_receiver,
		WFO_STRUCT_TYPE(cfg80211_chan_def),
		&settings->chandef,
		&cfg->start_ap.data.chandef.source);
	(&settings->chandef)->chan =
		ieee80211_get_channel(wiphy, (&settings->chandef)->chan->center_freq);

#if (WFO_SHRINK_CFG_SIZE==1)
{
	wfo_dram_t *dram = RTK_SHM_DRAM;
	wfo_copy_struct_data(wfo_ipc_receiver,
		WFO_STRUCT_TYPE(cfg80211_beacon_data),
		&settings->beacon,
		&dram->md.cfg.start_ap.beacon.source);
}
#else /* !WFO_SHRINK_CFG_SIZE */
	wfo_copy_struct_data(wfo_ipc_receiver,
		WFO_STRUCT_TYPE(cfg80211_beacon_data),
		&settings->beacon,
		&cfg->start_ap.data.beacon.source);
#endif /* WFO_SHRINK_CFG_SIZE */

	settings->ssid = settings->ssid_len?cfg->start_ap.data.ssid:NULL;

	/* crypto */
	WARN_ON(settings->crypto.wep_keys); /* not used in start_ap */
	if (settings->crypto.psk)
		settings->crypto.psk = cfg->start_ap.data.crypto.psk;
#ifdef WFO_K510
	if (settings->crypto.sae_pwd)
		settings->crypto.sae_pwd = cfg->start_ap.data.crypto.sae_pwd;
#endif /* WFO_K510 */

	/* acl */
	if (cfg->start_ap.data.acl.source.n_acl_entries) {
		memcpy((void *)settings->acl, (void *)&cfg->start_ap.data.acl.source,
			sizeof(struct cfg80211_acl_data)+settings->acl->n_acl_entries*ETH_ALEN);
	}

	settings->ht_cap  = &cfg->start_ap.data.ht_cap;
	settings->vht_cap = &cfg->start_ap.data.vht_cap;
	settings->he_cap  = &cfg->start_ap.data.he_cap;

#ifdef WFO_K510
{
	wfo_dram_t *dram = RTK_SHM_DRAM;
	settings->he_oper = &cfg->start_ap.data.he_oper;
	#if 0 //not use?
	settings->he_oper.optional = &cfg->start_ap.data.optional;
	#endif
	settings->fils_discovery.tmpl =
		settings->fils_discovery.tmpl_len?dram->md.cfg.start_ap.fils_discovery:NULL;
	settings->unsol_bcast_probe_resp.tmpl =
		settings->unsol_bcast_probe_resp.tmpl_len?dram->md.cfg.start_ap.unsol_bcast_probe_resp:NULL;
}
#endif /* WFO_K510 */

	ret = wfo_cfg_ops(wiphy)->start_ap(wiphy, radio_ndev, settings);
	cfg->ret_val = ret;

#if 1 /* copy from nl80211_start_ap,
			code execute after rdev_start_ap */
	if (!ret) {
		struct wireless_dev *wdev = ndev_to_wdev(radio_ndev);

		wdev->preset_chandef = _settings.chandef;
		wdev->beacon_interval = _settings.beacon_interval;
		wdev->chandef = _settings.chandef;
		wdev->ssid_len = _settings.ssid_len;
		memcpy(wdev->ssid, _settings.ssid, wdev->ssid_len);

		/*
		if (info->attrs[NL80211_ATTR_SOCKET_OWNER]) {
			wdev->conn_owner_nlportid = genl_info_snd_portid(info);
		}
		*/
	}
#endif

#if defined(CPTCFG_WFO_VIRT_SAME_CPU)
	dev_change_flags(radio_ndev, radio_ndev->flags|IFF_UP|IFF_RUNNING);
#endif /* CPTCFG_WFO_VIRT_SAME_CPU */

#if defined(WFO_CHECK_STRUCT_SZ)
exit:
#endif /* WFO_CHECK_STRUCT_SZ */

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(start_ap));
	return ret;

busy_wait:
	printk("\n\n\n\n");
	printk("%s(): Please check FAIL message above!!!!!!!!\n", __func__);
	printk("%s(): Please check FAIL message above!!!!!!!!\n", __func__);
	printk("%s(): Please check FAIL message above!!!!!!!!\n", __func__);
	printk("\n\n");

	do {
		/* busy wait!!! */
	} while(1);
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */

//----------------------------------------------------------------------------
//rdev_change_beacon
//.change_beacon = cfg80211_rtw_change_beacon,

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_change_beacon(struct wiphy *wiphy,
		struct net_device *virt_ndev,
		struct cfg80211_beacon_data *info)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(change_beacon));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(change_beacon));

	if (info) {
		cfg->change_beacon.mflags |= (1<<WFO_CHANGE_BEACON_HAS_INFO);
	#if (WFO_SHRINK_CFG_SIZE==1)
	{
		wfo_dram_t *dram = RTK_SHM_DRAM;
		wfo_copy_struct_data(wfo_ipc_sender,
			WFO_STRUCT_TYPE(cfg80211_beacon_data),
			&dram->md.cfg.change_beacon.beacon,
			info);
	}
	#else /* !WFO_SHRINK_CFG_SIZE */
		wfo_copy_struct_data(wfo_ipc_sender,
			WFO_STRUCT_TYPE(cfg80211_beacon_data),
			&cfg->change_beacon.beacon,
			info);
	#endif /* WFO_SHRINK_CFG_SIZE */
	}

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

    WFO_SENDER_TRACE_OUT(WFO_CMD(change_beacon));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_change_beacon(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;
	struct cfg80211_beacon_data _info, *info = &_info;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(change_beacon));

	if (cfg->change_beacon.mflags & (1<<WFO_CHANGE_BEACON_HAS_INFO)) {
		memset(info, 0, sizeof(struct cfg80211_beacon_data));
	#if (WFO_SHRINK_CFG_SIZE==1)
	{
		wfo_dram_t *dram = RTK_SHM_DRAM;
		wfo_copy_struct_data(wfo_ipc_receiver,
			WFO_STRUCT_TYPE(cfg80211_beacon_data),
			info,
			&dram->md.cfg.change_beacon.beacon);
	}
	#else /* !WFO_SHRINK_CFG_SIZE */
		wfo_copy_struct_data(wfo_ipc_receiver,
			WFO_STRUCT_TYPE(cfg80211_beacon_data),
			info,
			&cfg->change_beacon.beacon);
	#endif /* WFO_SHRINK_CFG_SIZE */
	} else {
		info = NULL;
	}

	ret = wfo_cfg_ops(wiphy)->change_beacon(wiphy, radio_ndev, info);
	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(change_beacon));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */

//----------------------------------------------------------------------------
//rdev_stop_ap
//.stop_ap = cfg80211_rtw_stop_ap,

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_stop_ap(struct wiphy *wiphy,
		struct net_device *virt_ndev)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(stop_ap));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(stop_ap));

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;
	if(ret == 0)
	{
		netif_carrier_off(virt_ndev);
	}

    WFO_SENDER_TRACE_OUT(WFO_CMD(stop_ap));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_stop_ap(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(stop_ap));

	ret = wfo_cfg_ops(wiphy)->stop_ap(wiphy, radio_ndev);
	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(stop_ap));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */

#endif

#if CONFIG_RTW_MACADDR_ACL && (LINUX_VERSION_CODE >= KERNEL_VERSION(3, 9, 0))
//----------------------------------------------------------------------------
//rdev_set_mac_acl
//.set_mac_acl = cfg80211_rtw_set_mac_acl,

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_set_mac_acl(struct wiphy *wiphy,
		struct net_device *virt_ndev,
		const struct cfg80211_acl_data *params)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(set_mac_acl));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(set_mac_acl));

	if (params) {
		u32 len = (u32)params->n_acl_entries*ETH_ALEN;

		cfg->set_mac_acl.mflags |= (1<<WFO_SET_MAC_ACL_HAS_PARAMS);

		memcpy(&cfg->set_mac_acl.data.source, params,
			sizeof(struct cfg80211_acl_data));
		memcpy(&cfg->set_mac_acl.data.mac_addrs, params->mac_addrs,
			MIN(len, NUM_ACL*ETH_ALEN));
	}

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

    WFO_SENDER_TRACE_OUT(WFO_CMD(set_mac_acl));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_set_mac_acl(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;
	struct cfg80211_acl_data *params = NULL;
	WFO_RECEIVER_TRACE_IN(WFO_CMD(set_mac_acl));

	if (cfg->set_mac_acl.mflags & (1<<WFO_SET_MAC_ACL_HAS_PARAMS))
		params = &cfg->set_mac_acl.data.source;

	ret = wfo_cfg_ops(wiphy)->set_mac_acl(wiphy, radio_ndev, params);
	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(set_mac_acl));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */
#endif

//----------------------------------------------------------------------------
//rdev_add_station
//.add_station = cfg80211_rtw_add_station,

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_add_station(struct wiphy *wiphy,
	struct net_device *virt_ndev,
	const u8 *mac,
	struct station_parameters *params)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(add_station));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(set_mac_acl));

	if (params) {
		cfg->add_station.mflags |= (1<<WFO_ADD_STATION_HAS_PARAMS);

		wfo_copy_struct_data(wfo_ipc_sender,
			WFO_STRUCT_TYPE(station_parameters),
			&cfg->add_station.data.source,
			params);
	}

	if (mac) {
		cfg->add_station.mflags |= (1<<WFO_ADD_STATION_HAS_MAC);
		memcpy(&cfg->add_station.mac, mac, ETH_ALEN);
	}

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

    WFO_SENDER_TRACE_OUT(WFO_CMD(add_station));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_add_station(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;
	struct station_parameters _params, *params = &_params;
	u8 *mac = NULL;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(add_station));

	if (cfg->add_station.mflags & (1<<WFO_ADD_STATION_HAS_PARAMS)) {
		memset(params, 0, sizeof(struct station_parameters));
		wfo_copy_struct_data(wfo_ipc_receiver,
			WFO_STRUCT_TYPE(station_parameters),
			params,
			&cfg->add_station.data.source);
	} else {
		params = NULL;
	}

	if (cfg->add_station.mflags & (1<<WFO_ADD_STATION_HAS_MAC))
		mac = cfg->add_station.mac;

	ret = wfo_cfg_ops(wiphy)->add_station(wiphy, radio_ndev, mac, params);
	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(add_station));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */

//----------------------------------------------------------------------------
//rdev_del_station
//.del_station = cfg80211_rtw_del_station,

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_del_station(struct wiphy *wiphy,
		struct net_device *virt_ndev,
		struct station_del_parameters *params
)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(del_station));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(del_station));

	if (params) {
		cfg->del_station.mflags |= (1<<WFO_DEL_STATION_HAS_PARAMS);

		memcpy(&cfg->del_station.data.source, params,
			sizeof(struct station_del_parameters));

		if (params->mac) {
			cfg->del_station.mflags |= (1<<WFO_DEL_STATION_HAS_MAC);
			memcpy(&cfg->del_station.data.mac, params->mac, ETH_ALEN);
		}
	}

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

    WFO_SENDER_TRACE_OUT(WFO_CMD(del_station));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_del_station(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;
	struct station_del_parameters *params = NULL;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(del_station));

	if (cfg->del_station.mflags & (1<<WFO_DEL_STATION_HAS_PARAMS)) {
		params = &cfg->del_station.data.source;

		if (cfg->del_station.mflags & (1<<WFO_DEL_STATION_HAS_MAC))
			params->mac = cfg->del_station.data.mac;
	}

	ret = wfo_cfg_ops(wiphy)->del_station(wiphy, radio_ndev, params);
	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(del_station));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */


//----------------------------------------------------------------------------
//rdev_change_station
//.change_station = cfg80211_rtw_change_station,

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_change_station(struct wiphy *wiphy,
	struct net_device *virt_ndev,
	const u8 *mac,
	struct station_parameters *params)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(change_station));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(change_station));

	if (params) {
		cfg->change_station.mflags |= (1<<WFO_CHANGE_STATION_HAS_PARAMS);

		wfo_copy_struct_data(wfo_ipc_sender,
			WFO_STRUCT_TYPE(station_parameters),
			&cfg->change_station.data.source,
			params);
	}

	if (mac) {
		cfg->change_station.mflags |= (1<<WFO_CHANGE_STATION_HAS_MAC);
		memcpy(&cfg->change_station.mac, mac, ETH_ALEN);
	}

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

    WFO_SENDER_TRACE_OUT(WFO_CMD(change_station));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_change_station(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;
	struct station_parameters _params, *params = &_params;
	u8 *mac = NULL;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(change_station));

	if (cfg->change_station.mflags & (1<<WFO_CHANGE_STATION_HAS_PARAMS)) {
		memset(params, 0, sizeof(struct station_parameters));

		wfo_copy_struct_data(wfo_ipc_receiver,
			WFO_STRUCT_TYPE(station_parameters),
			params,
			&cfg->change_station.data.source);
	} else {
		params = NULL;
	}

	if (cfg->change_station.mflags & (1<<WFO_CHANGE_STATION_HAS_MAC))
		mac = cfg->change_station.mac;

	ret = wfo_cfg_ops(wiphy)->change_station(wiphy, radio_ndev, mac, params);
	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(change_station));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */

//----------------------------------------------------------------------------
//rdev_dump_station
//.dump_station = cfg80211_rtw_dump_station,

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_dump_station(struct wiphy *wiphy,
		struct net_device *virt_ndev,
		int idx,
		u8 *mac,
		struct station_info *sinfo)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(dump_station));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(dump_station));

	cfg->dump_station.idx = idx;
	if (mac) {
		cfg->dump_station.mflags |= (1<<WFO_DUMP_STATION_HAS_MAC);
		memcpy(&cfg->dump_station.mac, mac, ETH_ALEN);
	}

	if (sinfo) {
		cfg->dump_station.mflags |= (1<<WFO_DUMP_STATION_HAS_SINFO);

		memcpy(&cfg->dump_station.sinfo.source, sinfo,
			sizeof(struct station_info));

		if (sinfo->assoc_req_ies)
			memcpy(&cfg->dump_station.sinfo.assoc_req_ies,
				sinfo->assoc_req_ies,
				MIN(sinfo->assoc_req_ies_len, IEEE80211_MAX_DATA_LEN));

		if (sinfo->pertid)
			memcpy(&cfg->dump_station.sinfo.pertid, sinfo->pertid,
				sizeof(struct cfg80211_tid_stats));
	}

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

    WFO_SENDER_TRACE_OUT(WFO_CMD(dump_station));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_dump_station(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;
	struct station_info *sinfo = NULL;
	u8 *mac = NULL;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(dump_station));

	if (cfg->dump_station.mflags & (1<<WFO_DUMP_STATION_HAS_MAC))
		mac = cfg->dump_station.mac;

	if (cfg->dump_station.mflags & (1<<WFO_DUMP_STATION_HAS_SINFO)) {
		sinfo = &cfg->dump_station.sinfo.source;
		sinfo->assoc_req_ies =
			sinfo->assoc_req_ies_len?cfg->dump_station.sinfo.assoc_req_ies:NULL;
		sinfo->pertid =
			sinfo->pertid?&cfg->dump_station.sinfo.pertid:NULL;
	}

	ret = wfo_cfg_ops(wiphy)->dump_station(wiphy, radio_ndev,
				cfg->dump_station.idx, mac, sinfo);
	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(dump_station));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */

//----------------------------------------------------------------------------
//rdev_change_bss
//.change_bss = cfg80211_rtw_change_bss,

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_change_bss(struct wiphy *wiphy,
		struct net_device *virt_ndev,
		struct bss_parameters *params)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(change_bss));

	if (cfg == NULL || params == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(change_bss));

	RTW_INFO(FUNC_NDEV_FMT"\n", FUNC_NDEV_ARG(virt_ndev));
	RTW_INFO("ap_isolate=%d\n", params->ap_isolate);

	memcpy(&cfg->change_bss.params, params, sizeof(struct bss_parameters));

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

    WFO_SENDER_TRACE_OUT(WFO_CMD(change_bss));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_change_bss(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(change_bss));

	ret = wfo_cfg_ops(wiphy)->change_bss(wiphy, radio_ndev, &cfg->change_bss.params);
	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(change_bss));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */


#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 29))
//----------------------------------------------------------------------------
//rdev_set_txq_params
//.set_txq_params = cfg80211_rtw_set_txq_params,

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_set_txq_params(struct wiphy *wiphy
		, struct net_device *virt_ndev
		, struct ieee80211_txq_params *params)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(set_txq_params));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(set_txq_params));

	if (params) {
		cfg->set_txq_params.mflags |= (1<<WFO_SET_TXQ_PARAMS_HAS_PARAMS);
		memcpy(&cfg->set_txq_params.data.source, params,
			sizeof(struct ieee80211_txq_params));
	}

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

    WFO_SENDER_TRACE_OUT(WFO_CMD(set_txq_params));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_set_txq_params(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;
	struct ieee80211_txq_params *params = NULL;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(set_txq_params));

	if (cfg->set_txq_params.mflags & (1<<WFO_SET_TXQ_PARAMS_HAS_PARAMS)) {
		params = &cfg->set_txq_params.data.source;
	}

	ret = wfo_cfg_ops(wiphy)->set_txq_params(wiphy, radio_ndev, params);
	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(set_txq_params));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */

#endif
#endif /* CONFIG_AP_MODE */

//----------------------------------------------------------------------------
//rdev_channel_switch
//.channel_switch = cfg80211_rtw_channel_switch,

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_channel_switch(struct wiphy *wiphy,
		struct net_device *virt_ndev,
		struct cfg80211_csa_settings *params)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(channel_switch));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(channel_switch));

	if (params) {
		memcpy(&cfg->channel_switch.data.source, params,
			sizeof(struct cfg80211_csa_settings));

		wfo_copy_struct_data(wfo_ipc_sender,
			WFO_STRUCT_TYPE(cfg80211_chan_def),
			&cfg->channel_switch.data.chandef.source,
			&params->chandef);

		wfo_copy_struct_data(wfo_ipc_sender,
			WFO_STRUCT_TYPE(cfg80211_beacon_data),
			&cfg->channel_switch.data.beacon_csa.source,
			&params->beacon_csa);
	}

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

    WFO_SENDER_TRACE_OUT(WFO_CMD(channel_switch));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_channel_switch(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;
	struct cfg80211_csa_settings _params, *params = &_params;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(channel_switch));

	memset(params, 0, sizeof(struct cfg80211_csa_settings));

	memcpy(params, &cfg->channel_switch.data.source,
		sizeof(struct cfg80211_csa_settings));

	wfo_copy_struct_data(wfo_ipc_receiver,
		WFO_STRUCT_TYPE(cfg80211_chan_def),
		&params->chandef,
		&cfg->channel_switch.data.chandef.source);
	(&params->chandef)->chan =
		ieee80211_get_channel(wiphy, (&params->chandef)->chan->center_freq);

	wfo_copy_struct_data(wfo_ipc_receiver,
		WFO_STRUCT_TYPE(cfg80211_beacon_data),
		&params->beacon_csa,
		&cfg->channel_switch.data.beacon_csa.source);

	ret = wfo_cfg_ops(wiphy)->channel_switch(wiphy, radio_ndev, params);
	cfg->ret_val = ret;

	if (!ret) {
		struct wireless_dev *wdev = ndev_to_wdev(radio_ndev);

		wdev->preset_chandef = _params.chandef;
		wdev->chandef = _params.chandef;
	}

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(channel_switch));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */

//----------------------------------------------------------------------------
//rdev_probe_client
//.probe_client = cfg80211_rtw_prob_client,

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_probe_client(struct wiphy *wiphy,
	struct net_device *ndev, const u8 *peer, u64 *cookie)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(ndev, RUN_REMOTELY, WFO_CMD(probe_client));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(probe_client));

	if (peer) {
		cfg->probe_client.mflags |= (1<<WFO_PROBE_CLIENT_HAS_PEER);
		memcpy(&cfg->probe_client.peer, peer, ETH_ALEN);
	}

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

	if (cookie)
		memcpy(cookie, &cfg->probe_client.cookie, sizeof(u64));

    WFO_SENDER_TRACE_OUT(WFO_CMD(probe_client));
	return ret;
}
/*
	test command:
	hostapd_cli -i wlan1 poll_sta [MACADDR]
*/
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_probe_client(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;
	u8 *peer = NULL;
	u64 *cookie = NULL;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(probe_client));

	if (cfg->probe_client.mflags & (1<<WFO_PROBE_CLIENT_HAS_PEER))
		peer = cfg->probe_client.peer;
	cookie = &cfg->remain_on_channel.cookie;

	ret = wfo_cfg_ops(wiphy)->probe_client(wiphy, radio_ndev, peer, cookie);
	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(probe_client));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */


#if (LINUX_VERSION_CODE >= KERNEL_VERSION(3, 6, 0))
//----------------------------------------------------------------------------
//rdev_set_monitor_channel
//.set_monitor_channel = cfg80211_rtw_set_monitor_channel,

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_set_monitor_channel(struct wiphy *wiphy
	, struct cfg80211_chan_def *chandef)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(wiphy_to_ndev(wiphy), RUN_REMOTELY, WFO_CMD(set_monitor_channel));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(set_monitor_channel));

	if (chandef) {
		cfg->set_monitor_channel.mflags |=
			(1<<WFO_SET_MONITOR_CHANNEL_HAS_CHANDEF);
		wfo_copy_struct_data(wfo_ipc_sender,
			WFO_STRUCT_TYPE(cfg80211_chan_def),
			&cfg->set_monitor_channel.chandef,
			chandef);
	}

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

    WFO_SENDER_TRACE_OUT(WFO_CMD(set_monitor_channel));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_set_monitor_channel(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;
	struct cfg80211_chan_def _chandef, *chandef = &_chandef;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(set_monitor_channel));

	if (cfg->set_monitor_channel.mflags &
		(1<<WFO_SET_MONITOR_CHANNEL_HAS_CHANDEF)) {
		wfo_copy_struct_data(wfo_ipc_receiver,
			WFO_STRUCT_TYPE(cfg80211_chan_def),
			chandef,
			&cfg->set_monitor_channel.chandef);
		chandef->chan =
			ieee80211_get_channel(wiphy, chandef->chan->center_freq);
	} else {
		chandef = NULL;
	}

	ret = wfo_cfg_ops(wiphy)->set_monitor_channel(wiphy, chandef);
	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(set_monitor_channel));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */
#endif

#if (LINUX_VERSION_CODE >= KERNEL_VERSION(3, 8, 0))
//----------------------------------------------------------------------------
//rdev_get_channel
//.get_channel = cfg80211_rtw_get_channel,

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_get_channel(struct wiphy *wiphy,
		struct wireless_dev *wdev,
		struct cfg80211_chan_def *chandef)
{
	int ret = 0;
	struct net_device *virt_ndev = wdev_to_ndev(wdev);
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(get_channel));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(get_channel));

	/* get report from ops, need to copy chandef */
	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

	if (ret == 0) {
		/* copy val to chandel */
		wfo_copy_struct_data(wfo_ipc_receiver,
			WFO_STRUCT_TYPE(cfg80211_chan_def),
			chandef,
			&cfg->get_channel.data.source);
		chandef->chan =
			ieee80211_get_channel(wiphy, (s32)chandef->chan->center_freq);
	}

	WFO_SENDER_TRACE_OUT(WFO_CMD(get_channel));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_get_channel(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;
	struct cfg80211_chan_def _chandef, *chandef = &_chandef;
	struct wireless_dev *wdev = ndev_to_wdev(radio_ndev);

	WFO_RECEIVER_TRACE_IN(WFO_CMD(get_channel));
	memset(chandef, 0, sizeof(struct cfg80211_chan_def));

	ret = wfo_cfg_ops(wiphy)->get_channel(wiphy, wdev, chandef);

	if (ret == 0) {
		/* copy chandef to cfg */
		wfo_copy_struct_data(wfo_ipc_sender,
			WFO_STRUCT_TYPE(cfg80211_chan_def),
			&cfg->get_channel.data.source,
			chandef);
	}
	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(get_channel));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */
#endif

#ifdef CONFIG_P2P
//----------------------------------------------------------------------------
//rdev_remain_on_channel
//.remain_on_channel = cfg80211_rtw_remain_on_channel,

#if defined(WFO_VIRT_SENDER)
static s32 wfo_virt_cmd_sender_remain_on_channel(struct wiphy *wiphy,
		struct wireless_dev *wdev,
		struct ieee80211_channel *channel,
		unsigned int duration, u64 *cookie)
{
	int ret = 0;
	struct net_device *virt_ndev = wdev_to_ndev(wdev);
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(remain_on_channel));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(remain_on_channel));

	if (channel) {
		cfg->remain_on_channel.mflags |=
			(1<<WFO_REMAIN_ON_CHANNEL_HAS_CHANNEL);
		memcpy(&cfg->remain_on_channel.channel, channel,
			sizeof(struct ieee80211_channel));
	}

	cfg->remain_on_channel.duration = duration;

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

	if (cookie)
		memcpy(cookie, &cfg->remain_on_channel.cookie, sizeof(u64));

    WFO_SENDER_TRACE_OUT(WFO_CMD(remain_on_channel));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_remain_on_channel(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;
	struct ieee80211_channel *channel = NULL;
	u64 *cookie = NULL;
	struct wireless_dev *wdev = ndev_to_wdev(radio_ndev);

	WFO_RECEIVER_TRACE_IN(WFO_CMD(remain_on_channel));

	if (cfg->remain_on_channel.mflags &
		(1<<WFO_REMAIN_ON_CHANNEL_HAS_CHANNEL)) {
		channel = &cfg->remain_on_channel.channel;
	}
	cookie = &cfg->remain_on_channel.cookie;

	ret = wfo_cfg_ops(wiphy)->remain_on_channel(wiphy, wdev, channel,
				cfg->remain_on_channel.duration, cookie);
	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(remain_on_channel));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */

//----------------------------------------------------------------------------
//rdev_cancel_remain_on_channel
//.cancel_remain_on_channel = cfg80211_rtw_cancel_remain_on_channel,

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_cancel_remain_on_channel(struct wiphy *wiphy,
		struct wireless_dev *wdev,
		u64 cookie)
{
	int ret = 0;
	struct net_device *virt_ndev = wdev_to_ndev(wdev);
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(cancel_remain_on_channel));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(cancel_remain_on_channel));

	memcpy(&cfg->cancel_remain_on_channel.cookie, &cookie, sizeof(u64));

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

    WFO_SENDER_TRACE_OUT(WFO_CMD(cancel_remain_on_channel));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_cancel_remain_on_channel(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;
	struct wireless_dev *wdev = ndev_to_wdev(radio_ndev);

	WFO_RECEIVER_TRACE_IN(WFO_CMD(cancel_remain_on_channel));

	ret = wfo_cfg_ops(wiphy)->cancel_remain_on_channel(wiphy, wdev,
				cfg->cancel_remain_on_channel.cookie);
	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(cancel_remain_on_channel));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */

#endif /* CONFIG_P2P */


#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 37)) || defined(COMPAT_KERNEL_RELEASE)
//----------------------------------------------------------------------------
//rdev_mgmt_tx
//.mgmt_tx = cfg80211_rtw_mgmt_tx,

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_mgmt_tx(struct wiphy *wiphy,
		struct wireless_dev *wdev,
		struct cfg80211_mgmt_tx_params *params,
		u64 *cookie)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(wdev_to_ndev(wdev), RUN_REMOTELY, WFO_CMD(mgmt_tx));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(mgmt_tx));

	if (params) {
		memcpy(&cfg->mgmt_tx.data.source, params,
			sizeof(struct cfg80211_mgmt_tx_params));
		memcpy(&cfg->mgmt_tx.data.chan, params->chan,
			sizeof(struct ieee80211_channel));
		memcpy(&cfg->mgmt_tx.data.buf, params->buf,
			MIN(params->len, IEEE80211_MAX_DATA_LEN));

		/* csa_offsets is not used in G6 driver*/
	}

	cfg->mgmt_tx.cookie = *cookie;

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

    WFO_SENDER_TRACE_OUT(WFO_CMD(mgmt_tx));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_mgmt_tx(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;
	struct cfg80211_mgmt_tx_params *params = NULL;
	struct wireless_dev *wdev = ndev_to_wdev(radio_ndev);
	u64 cookie = cfg->mgmt_tx.cookie;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(mgmt_tx));

	params = &cfg->mgmt_tx.data.source;
	params->chan = &cfg->mgmt_tx.data.chan;
	params->buf = cfg->mgmt_tx.data.buf;
	params->csa_offsets = NULL;

	ret = wfo_cfg_ops(wiphy)->mgmt_tx(wiphy, wdev, params, &cookie);
	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(mgmt_tx));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */

#if (LINUX_VERSION_CODE >= KERNEL_VERSION(5, 8, 0))
//----------------------------------------------------------------------------
//.update_mgmt_frame_registrations = cfg80211_rtw_update_mgmt_frame_registrations,

#if defined(WFO_VIRT_SENDER)
static void wfo_virt_cmd_sender_update_mgmt_frame_registrations(struct wiphy *wiphy,
	struct wireless_dev *wdev,
	struct mgmt_frame_regs *upd)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(wdev_to_ndev(wdev), RUN_REMOTELY, WFO_CMD(update_mgmt_frame_registrations));

	if (cfg == NULL)
		return;

	WFO_SENDER_TRACE_IN(WFO_CMD(update_mgmt_frame_registrations));

	if (upd) {
		cfg->update_mgmt_frame_registrations.mflags |= (1<<WFO_UPDATE_MGMT_FRAME_REGISTRATIONS_HAS_UPD);
		memcpy(&cfg->update_mgmt_frame_registrations.upd, upd, sizeof(struct mgmt_frame_regs));
	}

	wfo_virt_cmd_sender(cfg);

	WFO_SENDER_TRACE_OUT(WFO_CMD(update_mgmt_frame_registrations));
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static void wfo_virt_cmd_receiver_update_mgmt_frame_registrations(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	struct wireless_dev *wdev = ndev_to_wdev(radio_ndev);
	struct mgmt_frame_regs *upd = NULL;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(update_mgmt_frame_registrations));

#if (LINUX_VERSION_CODE >= KERNEL_VERSION(5, 8, 0))
	if (cfg->update_mgmt_frame_registrations.mflags &
		(1<<WFO_UPDATE_MGMT_FRAME_REGISTRATIONS_HAS_UPD)) {
		upd = &cfg->update_mgmt_frame_registrations.upd;
	}

	/* void function */
	wfo_cfg_ops(wiphy)->update_mgmt_frame_registrations(wiphy, wdev, upd);
#endif

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(update_mgmt_frame_registrations));
	return;
}
#endif /* WFO_VIRT_RECEIVER */

#else

//----------------------------------------------------------------------------
//rdev_mgmt_frame_register
//.mgmt_frame_register = cfg80211_rtw_mgmt_frame_register,

#if defined(WFO_VIRT_SENDER)
static void wfo_virt_cmd_sender_mgmt_frame_register(struct wiphy *wiphy,
		struct wireless_dev *wdev,
		u16 frame_type, bool reg)
{
	wfo_cfg80211_t *cfg = get_cfg_addr(wdev_to_ndev(wdev), RUN_REMOTELY, WFO_CMD(mgmt_frame_register));

	if (cfg == NULL)
		return;

	WFO_SENDER_TRACE_IN(WFO_CMD(mgmt_frame_register));

	cfg->mgmt_frame_register.frame_type = frame_type;
	cfg->mgmt_frame_register.reg = reg;

	wfo_virt_cmd_sender(cfg);

    WFO_SENDER_TRACE_OUT(WFO_CMD(mgmt_frame_register));
	return;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_mgmt_frame_register(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;
	struct wireless_dev *wdev = ndev_to_wdev(radio_ndev);

	WFO_RECEIVER_TRACE_IN(WFO_CMD(mgmt_frame_register));

#if (LINUX_VERSION_CODE < KERNEL_VERSION(5, 8, 0))
	/* void function */
	wfo_cfg_ops(wiphy)->mgmt_frame_register(wiphy, wdev ,
		cfg->mgmt_frame_register.frame_type, cfg->mgmt_frame_register.reg);
#endif

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(mgmt_frame_register));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */
#endif
#endif

#if defined(CONFIG_RTW_HOSTAPD_ACS) && (LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 33))
//----------------------------------------------------------------------------
//rdev_dump_survey
//.dump_survey = rtw_hostapd_acs_dump_survey,

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_dump_survey(struct wiphy *wiphy,
		struct net_device *virt_ndev, int idx, struct survey_info *info)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(dump_survey));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(dump_survey));

	memcpy(&cfg->dump_survey.data.source, info,
		sizeof(struct survey_info));
	cfg->dump_survey.idx = idx;

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

#if 1 /* copy from cfg80211_rtw_dump_survey */
	if (ret == 0) {
		memcpy(info, &cfg->dump_survey.data.source,
			sizeof(struct survey_info));
		info->channel = ieee80211_get_channel(wiphy, (s32)cfg->dump_survey.freq);
	}
#endif

    WFO_SENDER_TRACE_OUT(WFO_CMD(dump_survey));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_dump_survey(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;
	struct survey_info *info = NULL;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(dump_survey));

	info = &cfg->dump_survey.data.source;

	ret = wfo_cfg_ops(wiphy)->dump_survey(wiphy, radio_ndev, cfg->dump_survey.idx, info);
	cfg->ret_val = ret;

#if 1 /* copy from cfg80211_rtw_dump_survey */
	if (ret == 0) {
		u16 channel = 0;
		u8 acs_idx;
		_adapter *padapter = (_adapter *)rtw_netdev_priv(radio_ndev);
		struct acs_priv *acs = adapter_to_acs(padapter);
		struct acs_parm *parm = &acs->parm;
		acs_idx = parm->acs_idx[cfg->dump_survey.idx];
		channel = rtw_acs_get_channel_by_idx(padapter, acs_idx);
		cfg->dump_survey.freq = rtw_ch2freq(channel);
	}
#endif

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(dump_survey));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */

#endif


#ifdef CONFIG_RTW_80211R
//----------------------------------------------------------------------------
//rdev_update_ft_ies
//.update_ft_ies = cfg80211_rtw_update_ft_ies,

#if defined(WFO_VIRT_SENDER)
static s32 wfo_virt_cmd_sender_update_ft_ies(struct wiphy *wiphy,
	struct net_device *ndev,
	struct cfg80211_update_ft_ies_params *ftie)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(ndev, RUN_REMOTELY, WFO_CMD(update_ft_ies));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(update_ft_ies));

	if (ftie) {
		struct cfg80211_update_ft_ies_params *ftie2 = &cfg->ft_ies.source;
		memcpy(ftie2, ftie, sizeof(struct cfg80211_update_ft_ies_params));
		if (ftie->ie)
			memcpy(ftie2->ie, ftie->ie, ftie->ie_len);
	}

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

	WFO_SENDER_TRACE_OUT(WFO_CMD(update_ft_ies));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_update_ft_ies(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;
	struct cfg80211_update_ft_ies_params *ftie = &cfg->ft_ies.source;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(update_ft_ies));

	if (ftie->ie_len)
		ftie->ie = &cfg->ft_ies.ie;

	ret = wfo_cfg_ops(wiphy)->update_ft_ies(wiphy, radio_ndev, ftie);
	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(update_ft_ies));
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */
#endif /* CONFIG_RTW_80211R */


#if defined(CPTCFG_VERSION) || (KERNEL_VERSION(4, 17, 0) <= LINUX_VERSION_CODE)
//----------------------------------------------------------------------------
//rdev_external_auth
//.external_auth = cfg80211_rtw_external_auth,

#if defined(WFO_VIRT_SENDER)
static int wfo_virt_cmd_sender_external_auth(struct wiphy *wiphy,
		struct net_device *virt_ndev,
		struct cfg80211_external_auth_params *params)
{
	int ret = 0;
	wfo_cfg80211_t *cfg = get_cfg_addr(virt_ndev, RUN_REMOTELY, WFO_CMD(external_auth));

	if (cfg == NULL)
		return 0;

	WFO_SENDER_TRACE_IN(WFO_CMD(external_auth));

	memcpy(&cfg->external_auth.data.source, params,
		sizeof(struct cfg80211_external_auth_params));
	if (params->pmkid)
		memcpy(&cfg->external_auth.data.pmkid, params->pmkid, (u32)WLAN_PMKID_LEN);

	wfo_virt_cmd_sender(cfg);
	ret = cfg->ret_val;

    WFO_SENDER_TRACE_OUT(WFO_CMD(external_auth));
	return ret;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static int wfo_virt_cmd_receiver_external_auth(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg)
{
	int ret = 0;
	struct cfg80211_external_auth_params *params = NULL;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(external_auth));

	params = &cfg->external_auth.data.source;
	params->pmkid = cfg->external_auth.data.pmkid;

	ret = wfo_cfg_ops(wiphy)->external_auth(wiphy, radio_ndev, params);
	cfg->ret_val = ret;

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(external_auth));

	return ret;
}
#endif /* WFO_VIRT_RECEIVER */
#endif

#ifdef WIFI6_THER_CTRL
#include <ther_ctrl.h>

//----------------------------------------------------------------------------
//wfo_virt_cmd_sender_therctl_ops
//

#if defined(WFO_VIRT_SENDER)
static void wfo_virt_cmd_sender_therctl_ops(struct net_device *dev, unsigned char cmd, void *data)
{
	wfo_cfg80211_t *cfg = get_cfg_addr(dev, RUN_REMOTELY, WFO_CMD(therctl_ops));
	struct ther_info_s *info = (struct ther_info_s *) data;

	if (cfg == NULL)
		return;

	WFO_SENDER_TRACE_IN(WFO_CMD(therctl_ops));

	cfg->thermal_ctrl.cmd = cmd;

	wfo_virt_cmd_sender(cfg);

	if (THERCTL_GETVAL == cmd) {
		info->control.cur_ther = cfg->thermal_ctrl.info.control.cur_ther;
		info->control.ther_dm = cfg->thermal_ctrl.info.control.ther_dm;
		info->control.dbg = cfg->thermal_ctrl.info.control.dbg;
		info->control.tx_tp = cfg->thermal_ctrl.info.control.tx_tp;
		info->control.rx_tp = cfg->thermal_ctrl.info.control.rx_tp;
	}

	WFO_SENDER_TRACE_OUT(WFO_CMD(therctl_ops));
}
#endif /* #if defined(WFO_VIRT_SENDER) */

#if defined(WFO_VIRT_RECEIVER)
static void wfo_virt_cmd_receiver_therctl_ops(struct wiphy *wiphy,
		struct net_device *ndev,
		wfo_cfg80211_t *cfg)
{
	struct ther_info_s *info = &cfg->thermal_ctrl.info;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(therctl_ops));

	sync_mib_wifi6(ndev, info);

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(therctl_ops));
}
#endif /* #if defined(WFO_VIRT_RECEIVER) */


//----------------------------------------------------------------------------
//wfo_virt_cmd_sender_therctl_ops
//

#if defined(WFO_VIRT_SENDER)
static void wfo_virt_cmd_sender_therctl_ops_async(struct net_device *dev, unsigned char cmd, void *data)
{
	wfo_cfg80211_t *cfg = get_cfg_addr(dev, RUN_REMOTELY, WFO_CMD(therctl_ops_async));

	if (cfg == NULL)
		return;

	WFO_SENDER_TRACE_IN(WFO_CMD(therctl_ops_async));

	cfg->thermal_ctrl_async.cmd = cmd;
	
	switch (cmd) {
		case THERCTL_LIMIT_TP:
		case THERCTL_BANDWIDTH:
		case THERCTL_TX_DUTY:
		case THERCTL_POWER:
		case THERCTL_SET_PATH:
		case THERCTL_FUNC_OFF:
			cfg->thermal_ctrl_async.parameter = *(int*)data;
		break;
		default:
			printk("[wfo][%s] wrong ops !\n", __func__);
		break;
	}

	wfo_virt_cmd_sender(cfg);

	WFO_SENDER_TRACE_OUT(WFO_CMD(therctl_ops_async));
}
#endif /* #if defined(WFO_VIRT_SENDER) */

#if defined(WFO_VIRT_RECEIVER)
static void wfo_virt_cmd_receiver_therctl_ops_async(struct wiphy *wiphy,
		struct net_device *ndev,
		wfo_cfg80211_t *cfg)
{
	int parameter = cfg->thermal_ctrl_async.parameter;

	WFO_RECEIVER_TRACE_IN(WFO_CMD(therctl_ops_async));
	
	switch (cfg->thermal_ctrl_async.cmd) {
		case THERCTL_LIMIT_TP:
			set_limit_tp_wifi6(ndev, parameter);
			break;
		case THERCTL_BANDWIDTH:
			set_bandwidth_wifi6(ndev, parameter);
			break;
		case THERCTL_TX_DUTY:
			set_txduty_wifi6(ndev, parameter);
			break;
		case THERCTL_POWER:
			set_power_wifi6(ndev, parameter);
			break;
		case THERCTL_SET_PATH:
			set_path_wifi6(ndev, parameter);
			break;
		case THERCTL_FUNC_OFF:
			set_funcoff_wifi6(ndev, parameter);
			break;
		default:
		break;
	}

	WFO_RECEIVER_TRACE_OUT(WFO_CMD(therctl_ops_async));
}
#endif /* #if defined(WFO_VIRT_RECEIVER) */
#endif /* WIFI6_THER_CTRL */

/* ========================================================================== */
#if defined(WFO_VIRT_SENDER)
void sender_copy_cfg80211_pmksa(
		struct __wfo_cfg80211_pmksa *dst,
		struct cfg80211_pmksa *src)
{
	if (src && dst) {
		memcpy((struct cfg80211_pmksa *)(&dst->source),
			src, sizeof(struct cfg80211_pmksa));

		if (src->bssid)
			memcpy(dst->bssid, src->bssid, ETH_ALEN);

		if (src->pmkid)
			memcpy(dst->pmkid, src->pmkid, (u32)WLAN_PMKID_LEN);

		if (src->pmk)
			memcpy(dst->pmk, src->pmk,
				MIN(src->pmk_len, PMK_MAX_LEN));

		if (src->ssid)
			memcpy(dst->ssid, src->ssid,
				MIN(src->ssid_len, IEEE80211_MAX_SSID_LEN));

		if (src->cache_id)
			memcpy(dst->cache_id, src->cache_id, 2U);
	}
}

static void sender_copy_cfg80211_beacon_data(
		struct __wfo_cfg80211_beacon_data *dst,
		struct cfg80211_beacon_data *src)
{
	if (src && dst) {
		memcpy((struct cfg80211_beacon_data *)(&dst->source), src,
			sizeof(struct cfg80211_beacon_data));

		if (src->head_len)
			memcpy(dst->head, src->head,
				MIN(src->head_len, (u32)IEEE80211_MAX_DATA_LEN));

		if (src->tail_len)
			memcpy(dst->tail, src->tail,
				MIN(src->tail_len, IEEE80211_MAX_DATA_LEN));

		if (src->beacon_ies_len)
			memcpy(dst->beacon_ies, src->beacon_ies,
				MIN(src->beacon_ies_len, IEEE80211_MAX_DATA_LEN));

		if (src->proberesp_ies_len)
			memcpy(dst->proberesp_ies, src->proberesp_ies,
				MIN(src->proberesp_ies_len, IEEE80211_MAX_DATA_LEN));

		if (src->assocresp_ies_len)
			memcpy(dst->assocresp_ies, src->assocresp_ies,
				MIN(src->assocresp_ies_len, IEEE80211_MAX_DATA_LEN));

		if (src->probe_resp_len)
			memcpy(dst->probe_resp, src->probe_resp,
				MIN(src->probe_resp_len, IEEE80211_MAX_DATA_LEN));

		if (src->lci_len)
			memcpy(dst->lci, src->lci,
				MIN(src->lci_len, U8_MAX+1));

		if (src->civicloc_len)
			memcpy(dst->civicloc, src->civicloc,
				MIN(src->civicloc_len, U8_MAX+1));
	}
}

void sender_copy_station_parameters(
		struct __wfo_station_parameters *dst,
		struct station_parameters *src)
{
	if (src && dst) {
		memcpy((struct station_parameters *)(&dst->source), src,
			sizeof(struct station_parameters));

		if (src->supported_rates)
			memcpy(dst->supported_rates, src->supported_rates,
				MIN(src->supported_rates_len, NL80211_MAX_SUPP_RATES));

		if (src->vlan)
			memcpy(dst->vlan, src->vlan->name, strlen(src->vlan->name));

		if (src->ht_capa)
			memcpy(&dst->ht_capa, src->ht_capa, sizeof(struct ieee80211_ht_cap));

		if (src->vht_capa)
			memcpy(&dst->vht_capa, src->vht_capa, sizeof(struct ieee80211_vht_cap));

		if (src->he_capa)
			memcpy(&dst->he_capa, src->he_capa, sizeof(struct ieee80211_he_cap_elem));

	#ifdef WFO_K510
		if (src->he_6ghz_capa)
			memcpy(&dst->he_6ghz_capa, src->he_6ghz_capa, sizeof(struct ieee80211_he_6ghz_capa));
	#endif /* WFO_K510 */

		if (src->ext_capab)
			memcpy(dst->ext_capab, src->ext_capab,
				MIN(src->ext_capab_len, U8_MAX));

		if (src->supported_channels)
			memcpy(dst->supported_channels, src->supported_channels,
				MIN(src->supported_channels_len, U8_MAX));

		if (src->supported_oper_classes)
			memcpy(dst->supported_oper_classes, src->supported_oper_classes,
				MIN(src->supported_oper_classes_len, U8_MAX));
	}
}
#endif /* #if defined(WFO_VIRT_SENDER) */

static void sender_copy_cfg80211_chan_def(
		struct __wfo_cfg80211_chan_def *dst,
		struct cfg80211_chan_def *src)
{
	if (src && dst) {
		memcpy((struct cfg80211_chan_def *)(&dst->source), src,
			sizeof(struct cfg80211_chan_def));

		memcpy((struct ieee80211_channel *)(&dst->chan), src->chan,
			sizeof(struct ieee80211_channel));
	}
}

void sender_copy_key_params(
		struct __wfo_key_params *dst,
		struct key_params *src)
{
	if (src && dst) {
		memcpy((struct key_params *)dst, src, sizeof(struct key_params));

		if (src->key_len)
			memcpy(&dst->key, src->key,
				MIN(src->key_len, WLAN_MAX_KEY_LEN));

		if (src->seq_len)
			memcpy(&dst->seq, src->seq,
				MIN(src->seq_len, IEEE80211_MAX_PN_LEN));
	}
}


#if defined(WFO_VIRT_RECEIVER)
void receiver_copy_cfg80211_pmksa(
		struct cfg80211_pmksa *dst,
		struct __wfo_cfg80211_pmksa *src)
{
	if (src && dst) {
		memcpy(dst, &src->source, sizeof(struct cfg80211_pmksa));

		dst->bssid = dst->bssid?src->bssid:NULL;
		dst->pmkid = dst->pmkid?src->pmkid:NULL;
		dst->pmk = dst->pmk_len?src->pmk:NULL;
		dst->ssid = dst->ssid_len?src->ssid:NULL;
		dst->cache_id = dst->cache_id?src->cache_id:NULL;
	}
}

static void receiver_copy_cfg80211_beacon_data(
		struct cfg80211_beacon_data *dst,
		struct __wfo_cfg80211_beacon_data *src)
{
	if (src && dst) {
		memcpy(dst, &src->source, sizeof(struct cfg80211_beacon_data));

		dst->head = dst->head?src->head:NULL;
		dst->tail = dst->tail?src->tail:NULL;
		dst->beacon_ies = dst->beacon_ies?src->beacon_ies:NULL;
		dst->proberesp_ies = dst->proberesp_ies?src->proberesp_ies:NULL;
		dst->assocresp_ies = dst->assocresp_ies?src->assocresp_ies:NULL;
		dst->probe_resp = dst->probe_resp?src->probe_resp:NULL;
		dst->lci = dst->lci?src->lci:NULL;
		dst->civicloc = dst->civicloc?src->civicloc:NULL;
	}
}

void receiver_copy_station_parameters(
		struct station_parameters *dst,
		struct __wfo_station_parameters *src)
{
	if (src && dst) {
		struct net_device *vlan = wfo_dev_get_by_name(&init_net, src->vlan);

		memcpy(dst, &src->source, sizeof(struct station_parameters));
		dst->supported_rates = src->supported_rates;
		if (vlan)
			dst->vlan = vlan;

		dst->ht_capa = dst->ht_capa?&src->ht_capa:NULL;
		dst->vht_capa = dst->vht_capa?&src->vht_capa:NULL;
		dst->he_capa = dst->he_capa?&src->he_capa:NULL;
	#ifdef WFO_K510
		dst->he_6ghz_capa = dst->he_6ghz_capa?&src->he_6ghz_capa:NULL;
	#endif /* WFO_K510 */

		dst->ext_capab = dst->ext_capab?(u8 *)&src->ext_capab:NULL;
		dst->supported_channels =
			dst->supported_channels?(u8 *)&src->supported_channels:NULL;
		dst->supported_oper_classes =
			dst->supported_oper_classes?(u8 *)&src->supported_oper_classes:NULL;
	}
}
#endif /* #if defined(WFO_VIRT_RECEIVER) */

static void receiver_copy_cfg80211_chan_def(
		struct cfg80211_chan_def *dst,
		struct __wfo_cfg80211_chan_def *src)
{
	if (src && dst) {
		memcpy(dst, &src->source, sizeof(struct cfg80211_chan_def));

		dst->chan = &src->chan;
	}
}

void receiver_copy_key_params(
		struct key_params *dst,
		struct __wfo_key_params *src)
{
	if (src && dst) {
		//memcpy(dst, &src->source, sizeof(struct key_params));
		dst = &src->source;

		dst->key = dst->key_len?src->key:NULL;
		dst->seq = dst->seq_len?src->seq:NULL;
	}
}

void wfo_copy_struct_data(enum wfo_ipc_dir dir,
		enum wfo_struct_type type,
		void *dst,
		void *src)
{
	switch(dir) {

	case wfo_ipc_sender:
		switch(type) {
		#if defined(WFO_VIRT_SENDER)
			case WFO_STRUCT_TYPE(cfg80211_pmksa):
				sender_copy_cfg80211_pmksa( \
					(struct __wfo_cfg80211_pmksa *)dst,
					(struct cfg80211_pmksa *)src);
				break;
			case WFO_STRUCT_TYPE(cfg80211_beacon_data):
				sender_copy_cfg80211_beacon_data( \
					(struct __wfo_cfg80211_beacon_data *)dst,
					(struct cfg80211_beacon_data *)src);
				break;
			case WFO_STRUCT_TYPE(station_parameters):
				sender_copy_station_parameters( \
					(struct __wfo_station_parameters *)dst,
					(struct station_parameters *)src);
				break;
		#endif /* WFO_VIRT_SENDER */
			case WFO_STRUCT_TYPE(cfg80211_chan_def):
				sender_copy_cfg80211_chan_def( \
					(struct __wfo_cfg80211_chan_def *)dst,
					(struct cfg80211_chan_def *)src);
				break;
			case WFO_STRUCT_TYPE(key_params):
				sender_copy_key_params( \
					(struct __wfo_key_params *)dst,
					(struct key_params *)src);
				break;
			default:
				WFO_PRINT("wfo_ipc_sender: unknow struct type: [%d][%s] call by %s\n",
					type, wfo_struct_str[type], (char *)__builtin_return_address(0U));
		}
		break;

	case wfo_ipc_receiver:
		switch(type) {
		#if defined(WFO_VIRT_RECEIVER)
			case WFO_STRUCT_TYPE(cfg80211_pmksa):
				receiver_copy_cfg80211_pmksa( \
					(struct cfg80211_pmksa *)dst,
					(struct __wfo_cfg80211_pmksa *)src);
				break;
			case WFO_STRUCT_TYPE(cfg80211_beacon_data):
				receiver_copy_cfg80211_beacon_data( \
					(struct cfg80211_beacon_data *)dst,
					(struct __wfo_cfg80211_beacon_data *)src);
				break;
			case WFO_STRUCT_TYPE(station_parameters):
				receiver_copy_station_parameters( \
					(struct station_parameters *)dst,
					(struct __wfo_station_parameters *)src);
				break;
		#endif /* WFO_VIRT_RECEIVER */
			case WFO_STRUCT_TYPE(cfg80211_chan_def):
				receiver_copy_cfg80211_chan_def( \
					(struct cfg80211_chan_def *)dst,
					(struct __wfo_cfg80211_chan_def *)src);
				break;
			case WFO_STRUCT_TYPE(key_params):
				receiver_copy_key_params( \
					(struct key_params *)dst,
					(struct __wfo_key_params*)src);
				break;
			default:
				WFO_PRINT("wfo_ipc_receiver: unknow struct type: [%d][%s] call by %s\n",
					type, wfo_struct_str[type], (char *)__builtin_return_address(0U));
		}
		break;

	default:
		WFO_PRINT("unknow dir: [%d] call by %s\n", dir, (char *)__builtin_return_address(0U));
		break;
	}
}

void show_ipc_fail_cmd(wfo_cfg80211_t *cfg, const char *caller)
{
#ifdef CONFIG_SMP
	printk("<WFO> %s dev[%d:%s]: ipc fail cmd[%d:%s]!! cpu[%d]\n",
		caller,	cfg->dev_idx,
		cfg->dev_name?cfg->dev_name:"null",
		cfg->cmd, wfo_cmd_str[cfg->cmd],
		smp_processor_id());
#else /* !CONFIG_SMP */
	printk("<WFO> %s dev[%d:%s]: ipc fail cmd[%d:%s]!!\n",
		caller,	cfg->dev_idx,
		cfg->dev_name?cfg->dev_name:"null",
		cfg->cmd, wfo_cmd_str[cfg->cmd]);
#endif /* CONFIG_SMP */
}

#if defined(WFO_VIRT_RECEIVER)
#define WFO_VIRT_CMD(type) \
	wfo_cmd_##type, wfo_virt_cmd_receiver_##type
#else
#define WFO_VIRT_CMD(type) \
	wfo_cmd_##type, NULL
#endif

static struct wfo_cmd_recv_array_s recv_cmd[WFO_CMD_MAX] = {
	{ 0 , NULL} /* nono */ ,

//----- cfg80211_ops: virt -> radio --------------------------------------------
	{ WFO_VIRT_CMD(change_virtual_intf), SYNC },
	{ WFO_VIRT_CMD(add_key), SYNC },
	{ WFO_VIRT_CMD(get_key), SYNC },
	{ WFO_VIRT_CMD(del_key), SYNC },
	{ WFO_VIRT_CMD(set_default_key), SYNC },
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 30))
	{ WFO_VIRT_CMD(set_default_mgmt_key), SYNC },
#endif
#if defined(CONFIG_GTK_OL) && (LINUX_VERSION_CODE >= KERNEL_VERSION(3, 1, 0))
	{ WFO_VIRT_CMD(set_rekey_data), SYNC },
#endif /*CONFIG_GTK_OL*/
	{ WFO_VIRT_CMD(get_station), SYNC },
	{ WFO_VIRT_CMD(scan), SYNC },
	{ WFO_VIRT_CMD(set_wiphy_params), SYNC },
	{ WFO_VIRT_CMD(connect), SYNC },
	{ WFO_VIRT_CMD(disconnect), SYNC },
	{ WFO_VIRT_CMD(join_ibss), SYNC },
	{ WFO_VIRT_CMD(leave_ibss), SYNC },
	{ WFO_VIRT_CMD(set_tx_power), SYNC },
	{ WFO_VIRT_CMD(get_tx_power), ASYNC },
	{ WFO_VIRT_CMD(set_power_mgmt), SYNC },
	{ WFO_VIRT_CMD(set_pmksa), SYNC },
	{ WFO_VIRT_CMD(del_pmksa), SYNC },
	{ WFO_VIRT_CMD(flush_pmksa), SYNC },

#ifdef CONFIG_AP_MODE
	{ WFO_VIRT_CMD(add_virtual_intf), SYNC },
	{ WFO_VIRT_CMD(del_virtual_intf), SYNC },

#if (LINUX_VERSION_CODE < KERNEL_VERSION(3, 4, 0)) && !defined(COMPAT_KERNEL_RELEASE)
	{ WFO_VIRT_CMD(add_beacon), SYNC },
	{ WFO_VIRT_CMD(set_beacon), SYNC },
	{ WFO_VIRT_CMD(del_beacon), SYNC },
#else
	{ WFO_VIRT_CMD(start_ap), SYNC },
	{ WFO_VIRT_CMD(change_beacon), SYNC },
	{ WFO_VIRT_CMD(stop_ap), SYNC },
#endif

#if CONFIG_RTW_MACADDR_ACL && (LINUX_VERSION_CODE >= KERNEL_VERSION(3, 9, 0))
	{ WFO_VIRT_CMD(set_mac_acl), SYNC },
#endif

	{ WFO_VIRT_CMD(add_station), SYNC },
	{ WFO_VIRT_CMD(del_station), SYNC },
	{ WFO_VIRT_CMD(change_station), SYNC },
	{ WFO_VIRT_CMD(dump_station), SYNC },
	{ WFO_VIRT_CMD(change_bss), SYNC },
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 29))
	{ WFO_VIRT_CMD(set_txq_params), SYNC },
#endif
	{ WFO_VIRT_CMD(channel_switch), SYNC },
#if (LINUX_VERSION_CODE < KERNEL_VERSION(3, 6, 0))
	{ WFO_VIRT_CMD(set_channel), SYNC },
#endif
	/* { WFO_VIRT_CMD(auth), SYNC }, */
	/* { WFO_VIRT_CMD(assoc), SYNC },	 */
#endif /* CONFIG_AP_MODE */

#if defined(CONFIG_RTW_MESH) && (LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 38))
	{ WFO_VIRT_CMD(get_mesh_config), SYNC },
	{ WFO_VIRT_CMD(update_mesh_config), SYNC },
	{ WFO_VIRT_CMD(join_mesh), SYNC },
	{ WFO_VIRT_CMD(leave_mesh), SYNC },
	{ WFO_VIRT_CMD(add_mpath), SYNC },
	{ WFO_VIRT_CMD(del_mpath), SYNC },
	{ WFO_VIRT_CMD(change_mpath), SYNC },
	{ WFO_VIRT_CMD(get_mpath), SYNC },
	{ WFO_VIRT_CMD(dump_mpath), SYNC },
	#if (LINUX_VERSION_CODE >= KERNEL_VERSION(3, 19, 0))
	{ WFO_VIRT_CMD(get_mpp), SYNC },
	{ WFO_VIRT_CMD(dump_mpp), SYNC },
	#endif
#endif
	{ WFO_VIRT_CMD(probe_client), SYNC },

#if (LINUX_VERSION_CODE >= KERNEL_VERSION(3, 6, 0))
	{ WFO_VIRT_CMD(set_monitor_channel), SYNC },
#endif
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(3, 8, 0))
	{ WFO_VIRT_CMD(get_channel), SYNC },
#endif

#ifdef CONFIG_P2P
	{ WFO_VIRT_CMD(remain_on_channel), SYNC },
	{ WFO_VIRT_CMD(cancel_remain_on_channel), SYNC },
	#if defined(RTW_DEDICATED_P2P_DEVICE)
	{ WFO_VIRT_CMD(start_p2p_device), SYNC },
	{ WFO_VIRT_CMD(stop_p2p_device), SYNC },
	#endif
#endif /* CONFIG_P2P */

#ifdef CONFIG_RTW_80211R
	{ WFO_VIRT_CMD(update_ft_ies), SYNC },
#endif /* CONFIG_RTW_80211R */

#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 37)) || defined(COMPAT_KERNEL_RELEASE)
	{ WFO_VIRT_CMD(mgmt_tx), SYNC },
  #if (LINUX_VERSION_CODE >= KERNEL_VERSION(5, 8, 0))
	{ WFO_VIRT_CMD(update_mgmt_frame_registrations), ASYNC },
  #else
	{ WFO_VIRT_CMD(mgmt_frame_register), ASYNC },
  #endif
#elif (LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 34) && LINUX_VERSION_CODE <= KERNEL_VERSION(2, 6, 35))
	{ WFO_VIRT_CMD(action), SYNC },
#endif

#if defined(CONFIG_TDLS) && (LINUX_VERSION_CODE >= KERNEL_VERSION(3, 2, 0))
	{ WFO_VIRT_CMD(tdls_mgmt), SYNC },
	{ WFO_VIRT_CMD(tdls_oper), SYNC },
#endif /* CONFIG_TDLS */

#if defined(CONFIG_PNO_SUPPORT) && (LINUX_VERSION_CODE >= KERNEL_VERSION(3, 0, 0))
	{ WFO_VIRT_CMD(sched_scan_start), SYNC },
	{ WFO_VIRT_CMD(sched_scan_stop), SYNC },
	{ WFO_VIRT_CMD(suspend), SYNC },
	{ WFO_VIRT_CMD(resume), SYNC },
#endif /* CONFIG_PNO_SUPPORT */
#ifdef CONFIG_RFKILL_POLL
	{ WFO_VIRT_CMD(rfkill_poll), SYNC },
#endif
#if defined(CONFIG_RTW_HOSTAPD_ACS) && (LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 33))
	{ WFO_VIRT_CMD(dump_survey), SYNC },
#endif
#if defined(CPTCFG_VERSION) || (KERNEL_VERSION(4, 17, 0) <= LINUX_VERSION_CODE)
	{ WFO_VIRT_CMD(external_auth), SYNC },
#endif
//----- cfg80211_ops: virt -> radio --------------------------------------------



//----- net_device ops ---------------------------------------------------------
	//{ WFO_VIRT_CMD(ndo_start_xmit), SYNC },
	//{ WFO_VIRT_CMD(ndo_validate_addr), SYNC },
	{ WFO_VIRT_CMD(ndo_set_mac_address), SYNC },
	{ WFO_VIRT_CMD(ndo_open), SYNC },
	{ WFO_VIRT_CMD(ndo_stop), SYNC },
#if !defined(RTK_SHM_DRAM)
	{ WFO_VIRT_CMD(ndo_get_stats), SYNC },
#endif
	{ WFO_VIRT_CMD(ndo_do_ioctl), SYNC },
//----- net_device ops ---------------------------------------------------------



//----- other ------------------------------------------------------------------
	{ WFO_VIRT_CMD(iwpriv), SYNC },
	{ WFO_VIRT_CMD(std_handler), SYNC },
#ifndef CONFIG_RTK_WFO_NO_VIRT
	{ WFO_VIRT_CMD(band_cap), SYNC },
#endif /* CONFIG_RTK_WFO_NO_VIRT */
#ifndef CPTCFG_WFO_VIRT_SAME_CPU
	{ WFO_VIRT_CMD(proc_file), SYNC },
	{ WFO_VIRT_CMD(unregister_ndev), SYNC },
	{ WFO_VIRT_CMD(get_wireless_stats), SYNC },
#endif /* CPTCFG_WFO_VIRT_SAME_CPU */
	{ WFO_VIRT_CMD(netlink_recv_msg), ASYNC },
	{ WFO_VIRT_CMD(reg_notifier), SYNC },
#if defined(WFO_SYNC_STA_STATUS)
	{ WFO_VIRT_CMD(sync_sta_status), SYNC },
#endif /* WFO_SYNC_STA_STATUS */
#ifdef WIFI6_THER_CTRL
	{ WFO_VIRT_CMD(therctl_ops), SYNC },
	{ WFO_VIRT_CMD(therctl_ops_async), ASYNC },
#endif /* WIFI6_THER_CTRL */
	{ WFO_VIRT_CMD(new_virt_cmd_xxx), SYNC },
//----- other ------------------------------------------------------------------
};

#if defined(WFO_VIRT_SENDER)
void init_wfo_virt_cmd_sender_sync_type(void)
{
	int i = 0, j = 0;

	for (i=1;i<WFO_CMD_MAX;i++) {
		for (j=0;j<WFO_CMD_MAX;j++) {
			if ((u32)i == recv_cmd[j].cmd) {
				wfo_virt_cmd_ipc_type[i] = recv_cmd[j].sync;
				break;
			}
		}
	}
	wfo_cfg_reset();
}

void wfo_virt_cmd_sender(wfo_cfg80211_t *cfg)
{
	extern int get_pe_reset_intf_status(int idx);
	int ret = 0;
	cfg->ret_val = -1;

	if(PE_STATUS->heartbeat == 0U ||
		PE_STATUS->ipc_recover ||
		get_pe_reset_intf_status(cfg->dev_idx)) {
		cfg->ret_val = 0;
		return;
	}

#if (WFO_CFG_DBG_TRACE_OPS==1)
	if (wfo_trace[TRACE_SENDER][cfg->cmd]) {
		WFO_PRINT("on %s, cmd[%d:%s] -> %s\n",
			cmd_run_mode[cfg->side],
			cfg->cmd, wfo_cmd_str[cfg->cmd],
			cfg->dev_name);
	}
#endif /* WFO_CFG_DBG_TRACE_OPS */

	if (cfg->side == RUN_REMOTELY) {
		//ret = wfo_virt_cmd_ipc_sender((void *)cfg, sizeof(wfo_cfg80211_t), wfo_virt_cmd_ipc_type[cfg->cmd]);
		ret = wfo_virt_cmd_ipc_sender((void *)cfg, (u16)sizeof(wfo_cfg80211_t), cfg->is_sync);
	} else {
		cfg->ret_val = 0;
	}

	if (ret) {
		show_ipc_fail_cmd(cfg, "virt");
	}

	return;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)

static int (*wfo_virt_cmd_receiver_fp[WFO_CMD_MAX])(struct wiphy *wiphy,
		struct net_device *radio_ndev,
		wfo_cfg80211_t *cfg) = { NULL };

void init_wfo_virt_cmd_receiver_fp(void)
{
	int i = 0, j = 0;

	for (i=1;i<WFO_CMD_MAX;i++) {
		for (j=0;j<WFO_CMD_MAX;j++) {
			if (i == recv_cmd[j].cmd) {
				wfo_virt_cmd_receiver_fp[i] = recv_cmd[j].cmd_fp;
				break;
			}
		}
	}

	register_wfo_ipc_show_cmd_name();
}

void wfo_virt_cmd_receiver(wfo_cfg80211_t *cfg)
{
	struct net_device *radio_ndev = NULL;
	struct wireless_dev *radio_wdev = NULL;
	struct wiphy *radio_wiphy = NULL;
	unsigned char do_ipc = 0;

	if (cfg->cmd == WFO_CMD(add_virtual_intf)) {
		do_ipc = 1;
		radio_wiphy = radio_map_tbl[0].wiphy;
		WFO_PRINT("add_virtual_intf: dev[%s]\n", cfg->dev_name);
		goto no_dev;
	}

	if (radio_map_tbl[cfg->dev_idx].ndev) {
		radio_ndev = radio_map_tbl[cfg->dev_idx].ndev;
		radio_wiphy = radio_map_tbl[0].wiphy;
	} else {
		radio_ndev = wfo_dev_get_by_name(&init_net, cfg->dev_name);

		if (radio_ndev) {
			radio_wdev = ndev_to_wdev(radio_ndev);
			if (radio_wdev)
				radio_wiphy = wdev_to_wiphy(radio_wdev);

			if (radio_wiphy) {
				update_radio_map(radio_ndev, cfg->dev_idx);
			}
		}
	}

#if (WFO_CFG_DBG_TRACE_OPS==1)
	if (radio_ndev) {
		if ((wfo_trace[TRACE_RECEIVER][cfg->cmd])) {
			WFO_PRINT("on %s, cmd[%d:%s] -> %s\n",
				cmd_run_mode[cfg->side],
				cfg->cmd, wfo_cmd_str[cfg->cmd],
				cfg->dev_name);
		}
	} else {
		WFO_PRINT("can't get dev[%s]!! cmd[%d:%s]\n", cfg->dev_name,
			cfg->cmd, wfo_cmd_str[cfg->cmd]);
	}
#endif /* WFO_CFG_DBG_TRACE_OPS */

	if (radio_ndev) {
		do_ipc = 1;
	}

no_dev:
	if (do_ipc && wfo_virt_cmd_receiver_fp[cfg->cmd]) {
		(*wfo_virt_cmd_receiver_fp[cfg->cmd])(radio_wiphy, radio_ndev, cfg);
	} else {
		if (cfg->cmd != WFO_CMD(get_channel))
		WFO_PRINT("cmd[%d:%s] function pointer is %p! radio_wiphy=%p, radio_ndev=%p(%s)\n",
			cfg->cmd, wfo_cmd_str[cfg->cmd], wfo_virt_cmd_receiver_fp[cfg->cmd], radio_wiphy, radio_ndev, cfg->dev_name);
		cfg->ret_val = -5987;
	}

	return;
}

#if defined(WFO_GETMIB_IN_SHM)
#include <linux/timer.h>
struct timer_list synmib_timer;

void init_sync_mib_timer_fn(void)
{
	int i = 0;

	for (i=0; i<CONFIG_IFACE_NUMBER; i++) {
		struct dev_map_tbl_s *map = get_radio_map(i);
		_adapter *adapter = (_adapter *)(map->adapter);

		if (adapter)
			update_wfo_mib(adapter);
	}
	mod_timer(&synmib_timer, jiffies + synmib_timer.data);
}

void init_sync_mib_timer(int timeout)
{
	init_timer(&synmib_timer);
	synmib_timer.function = init_sync_mib_timer_fn;
	synmib_timer.data = (unsigned long)timeout;
	mod_timer(&synmib_timer, jiffies + timeout);
}
#endif /* WFO_GETMIB_IN_SHM */
#endif /* WFO_VIRT_RECEIVER */


/* ================================================================================ */
#if defined(WFO_VIRT_SENDER)
static struct cfg80211_ops wfo_virt_cfg80211_ops = {
	.change_virtual_intf = wfo_virt_cmd_sender_change_virtual_intf,
	.add_key = wfo_virt_cmd_sender_add_key,
	.get_key = wfo_virt_cmd_sender_get_key,
	.del_key = wfo_virt_cmd_sender_del_key,
	.set_default_key = wfo_virt_cmd_sender_set_default_key,
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 30))
	.set_default_mgmt_key = wfo_virt_cmd_sender_set_default_mgmt_key,
#endif
#if defined(CONFIG_GTK_OL) && (LINUX_VERSION_CODE >= KERNEL_VERSION(3, 1, 0))
	.set_rekey_data = wfo_virt_cmd_sender_set_rekey_data, //cfg80211_rtw_set_rekey_data,
#endif /*CONFIG_GTK_OL*/
	.get_station = wfo_virt_cmd_sender_get_station,
	.scan = wfo_virt_cmd_sender_scan,
	.set_wiphy_params = wfo_virt_cmd_sender_set_wiphy_params,
	.connect = wfo_virt_cmd_sender_connect,
	.disconnect = wfo_virt_cmd_sender_disconnect,
	.join_ibss = wfo_virt_cmd_sender_join_ibss,
	.leave_ibss = wfo_virt_cmd_sender_leave_ibss,
	.set_tx_power = wfo_virt_cmd_sender_set_tx_power,
	.get_tx_power =  wfo_virt_cmd_sender_get_tx_power,
	.set_power_mgmt = wfo_virt_cmd_sender_set_power_mgmt,
	.set_pmksa = wfo_virt_cmd_sender_set_pmksa,
	.del_pmksa = wfo_virt_cmd_sender_del_pmksa,
	.flush_pmksa = wfo_virt_cmd_sender_flush_pmksa,

#ifdef CONFIG_AP_MODE
	.add_virtual_intf = wfo_virt_cmd_sender_add_virtual_intf,
	.del_virtual_intf = wfo_virt_cmd_sender_del_virtual_intf,

#if (LINUX_VERSION_CODE < KERNEL_VERSION(3, 4, 0)) && !defined(COMPAT_KERNEL_RELEASE)
	.add_beacon = wfo_virt_cmd_sender_add_beacon, //cfg80211_rtw_add_beacon,
	.set_beacon = wfo_virt_cmd_sender_set_beacon, //cfg80211_rtw_set_beacon,
	.del_beacon = wfo_virt_cmd_sender_del_beacon, //cfg80211_rtw_del_beacon,
#else
	.start_ap = wfo_virt_cmd_sender_start_ap,
	.change_beacon = wfo_virt_cmd_sender_change_beacon,
	.stop_ap = wfo_virt_cmd_sender_stop_ap,
#endif

#if CONFIG_RTW_MACADDR_ACL && (LINUX_VERSION_CODE >= KERNEL_VERSION(3, 9, 0))
	.set_mac_acl = wfo_virt_cmd_sender_set_mac_acl,
#endif

	.add_station = wfo_virt_cmd_sender_add_station,
	.del_station = wfo_virt_cmd_sender_del_station,
	.change_station = wfo_virt_cmd_sender_change_station,
	.dump_station = wfo_virt_cmd_sender_dump_station,
	.change_bss = wfo_virt_cmd_sender_change_bss,
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 29))
	.set_txq_params = wfo_virt_cmd_sender_set_txq_params,
#endif
#if (LINUX_VERSION_CODE < KERNEL_VERSION(3, 6, 0))
	.set_channel = wfo_virt_cmd_sender_set_channel, //cfg80211_rtw_set_channel,
#endif
	/* .auth = cfg80211_rtw_auth, */
	/* .assoc = cfg80211_rtw_assoc,	 */
	.channel_switch = wfo_virt_cmd_sender_channel_switch,
#endif /* CONFIG_AP_MODE */

#if defined(CONFIG_RTW_MESH) && (LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 38))
	.get_mesh_config = wfo_virt_cmd_sender_get_mesh_config, //cfg80211_rtw_get_mesh_config,
	.update_mesh_config = wfo_virt_cmd_sender_update_mesh_config, //cfg80211_rtw_update_mesh_config,
	.join_mesh = wfo_virt_cmd_sender_join_mesh, //cfg80211_rtw_join_mesh,
	.leave_mesh = wfo_virt_cmd_sender_leave_mesh, //cfg80211_rtw_leave_mesh,
	.add_mpath = wfo_virt_cmd_sender_add_mpath, //cfg80211_rtw_add_mpath,
	.del_mpath = wfo_virt_cmd_sender_del_mpath, //cfg80211_rtw_del_mpath,
	.change_mpath = wfo_virt_cmd_sender_change_mpath, //cfg80211_rtw_change_mpath,
	.get_mpath = wfo_virt_cmd_sender_get_mpath, //cfg80211_rtw_get_mpath,
	.dump_mpath = wfo_virt_cmd_sender_dump_mpath, //cfg80211_rtw_dump_mpath,
	#if (LINUX_VERSION_CODE >= KERNEL_VERSION(3, 19, 0))
	.get_mpp = wfo_virt_cmd_sender_get_mpp, //cfg80211_rtw_get_mpp,
	.dump_mpp = wfo_virt_cmd_sender_dump_mpp, //cfg80211_rtw_dump_mpp,
	#endif
#endif
	.probe_client = wfo_virt_cmd_sender_probe_client,

#if (LINUX_VERSION_CODE >= KERNEL_VERSION(3, 6, 0))
	.set_monitor_channel = wfo_virt_cmd_sender_set_monitor_channel,
#endif
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(3, 8, 0))
	.get_channel = wfo_virt_cmd_sender_get_channel,
#endif

#ifdef CONFIG_P2P
	.remain_on_channel = wfo_virt_cmd_sender_remain_on_channel,
	.cancel_remain_on_channel = wfo_virt_cmd_sender_cancel_remain_on_channel,
	#if defined(RTW_DEDICATED_P2P_DEVICE)
	.start_p2p_device = wfo_virt_cmd_sender_cfg80211_rtw_start_p2p_device, //cfg80211_rtw_start_p2p_device,
	.stop_p2p_device = wfo_virt_cmd_sender_cfg80211_rtw_stop_p2p_device, //cfg80211_rtw_stop_p2p_device,
	#endif
#endif /* CONFIG_P2P */

#ifdef CONFIG_RTW_80211R
	.update_ft_ies = wfo_virt_cmd_sender_update_ft_ies,
#endif

#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 37)) || defined(COMPAT_KERNEL_RELEASE)
	.mgmt_tx = wfo_virt_cmd_sender_mgmt_tx,
	#if (LINUX_VERSION_CODE >= KERNEL_VERSION(5, 8, 0))
	.update_mgmt_frame_registrations = wfo_virt_cmd_sender_update_mgmt_frame_registrations,
	#else
	.mgmt_frame_register = wfo_virt_cmd_sender_mgmt_frame_register,
	#endif
#elif (LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 34) && LINUX_VERSION_CODE <= KERNEL_VERSION(2, 6, 35))
	.action = wfo_virt_cmd_sender_cfg80211_rtw_mgmt_tx, //cfg80211_rtw_mgmt_tx,
#endif

#if defined(CONFIG_TDLS) && (LINUX_VERSION_CODE >= KERNEL_VERSION(3, 2, 0))
	.tdls_mgmt = wfo_virt_cmd_sender_cfg80211_rtw_tdls_mgmt, //cfg80211_rtw_tdls_mgmt,
	.tdls_oper = wfo_virt_cmd_sender_cfg80211_rtw_tdls_oper, //cfg80211_rtw_tdls_oper,
#endif /* CONFIG_TDLS */

#if defined(CONFIG_PNO_SUPPORT) && (LINUX_VERSION_CODE >= KERNEL_VERSION(3, 0, 0))
	.sched_scan_start = wfo_virt_cmd_sender_cfg80211_rtw_sched_scan_start, //cfg80211_rtw_sched_scan_start,
	.sched_scan_stop = wfo_virt_cmd_sender_cfg80211_rtw_sched_scan_stop, //cfg80211_rtw_sched_scan_stop,
	.suspend = wfo_virt_cmd_sender_cfg80211_rtw_suspend, //cfg80211_rtw_suspend,
	.resume = wfo_virt_cmd_sender_cfg80211_rtw_resume, //cfg80211_rtw_resume,
#endif /* CONFIG_PNO_SUPPORT */
#ifdef CONFIG_RFKILL_POLL
	.rfkill_poll = wfo_virt_cmd_sender_rfkill_poll, //cfg80211_rtw_rfkill_poll,
#endif
#if defined(CONFIG_RTW_HOSTAPD_ACS) && (LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 33))
	.dump_survey = wfo_virt_cmd_sender_dump_survey,
#endif
#if defined(CPTCFG_VERSION) || (KERNEL_VERSION(4, 17, 0) <= LINUX_VERSION_CODE)
	.external_auth = wfo_virt_cmd_sender_external_auth,
#endif
};
#endif /* WFO_VIRT_SENDER */
#endif /* WFO_CMD_VIRT_CFG_OPS */


//==============================================================================
//  init virt
//==============================================================================
#if defined(WFO_VIRT_RECEIVER)
void set_cfg80211_ops(struct rtw_wiphy_data *wiphy_data)
{
	wiphy_data->cfg_ops = &rtw_cfg80211_ops;
}

void init_wfo_cmd_virt_receiver(struct wiphy *wiphy)
{
	set_cfg80211_ops(rtw_wiphy_priv(wiphy));

	init_wfo_virt_cmd_receiver_fp();
	register_wfo_virt_ipc_cb();

	/* ECOS(radio sender) init IPC command sync type*/
	init_wfo_radio_cmd_sender_sync_type();

#if defined(WFO_GETMIB_IN_SHM)
	init_sync_mib_timer(HZ);
#endif /* WFO_GETMIB_IN_SHM */

#if (WFO_CFG_DBG_TRACE_OPS==1)
	dbg_trace_ops();
#endif /* WFO_CFG_DBG_TRACE_OPS */
}
#endif /* WFO_VIRT_RECEIVER */

#include "wfo_cmd_radio.c"
#include "wfo_cmd_debug.c"

inline u8 wfo_get_ndev_id(u8 id)
{
#if defined(CPTCFG_2G_ON_WLAN0)
	return id?0U:1U;
#else
	return id;
#endif
}

#if defined(WFO_VIRT_RECEIVER)
struct net_device *wfo_rx_ndev(struct net_device *ndev)
{
	struct net_device *virt_ndev = NULL;

#if (WFO_DBG_RX==1)
	WFO_PRINT("ndev=%p/[%s]\n",
		ndev, ndev?ndev->name:"null");
#endif

#if defined(CPTCFG_WFO_VIRT_SAME_CPU)
	if (strstr(ndev->name, WFO_IFACE_POSTFIX)) {
		char dev_name[IFNAMSIZ];

		if (virt_ndev == NULL) {
			snprintf(dev_name, 1+strlen(ndev->name)-strlen(WFO_IFACE_POSTFIX),
				"%s", ndev->name);

			virt_ndev = wfo_dev_get_by_name(&init_net, dev_name);
		}
	} else {
		virt_ndev = ndev;
	}
#else
	virt_ndev = ndev;
#endif /* CPTCFG_WFO_VIRT_SAME_CPU */

#if (WFO_DBG_RX==1)
	WFO_PRINT("virt_ndev=%p/[%s]\n",
		virt_ndev, virt_ndev?virt_ndev->name:"null");
#endif

	return virt_ndev;
}

void sync_tx_stats(int dev_id, struct xmit_priv *pxmitpriv)
{
	wfo_dram_t *dram = RTK_SHM_DRAM;
	dram->md.dev_st[dev_id].tx_bytes = pxmitpriv->tx_bytes;
	dram->md.dev_st[dev_id].tx_packets = pxmitpriv->tx_pkts;
	dram->md.dev_st[dev_id].tx_dropped = pxmitpriv->tx_drop;
}

void sync_rx_stats(int dev_id, struct recv_priv *precvpriv)
{
	wfo_dram_t *dram = RTK_SHM_DRAM;
	dram->md.dev_st[dev_id].rx_bytes = precvpriv->rx_bytes;
	dram->md.dev_st[dev_id].rx_packets = precvpriv->rx_pkts;
	dram->md.dev_st[dev_id].rx_dropped = precvpriv->rx_drop;
}

void wfo_set_devname(_adapter *adapter, struct registry_priv *regsty)
{
	char *postfix = "";
#ifdef CONFIG_RTW_MULTI_DEV_MULTI_BAND
	u8 dev_id = adapter->dvobj->dev_id;
#else
	u8 dev_id = adapter->dev_id;
#endif

	dev_id = wfo_get_ndev_id(dev_id);
	if (dev_id == WFO_SKIP_PCIE_SLOT) {
		postfix = WFO_IFACE_POSTFIX;
	}

	if (dev_id == IFACE_ID0) {
		sprintf(regsty->ifname, "%s%d%s", WLAN_IFACE_NAME, dev_id, postfix);
	}
	else if (dev_id == IFACE_ID1) {
		sprintf(regsty->if2name, "%s%d%s", WLAN_IFACE_NAME, dev_id, postfix);
	}
}

int wfo_check_offload(_adapter *padapter)
{
	int ret = 0;
#ifdef CONFIG_RTW_MULTI_DEV_MULTI_BAND
	u8 dev_id = padapter->dvobj->dev_id;
#else
	u8 dev_id = padapter->dev_id;
#endif

	if (dev_id == WFO_SKIP_PCIE_SLOT) {
		ret = 1;
	}
	return ret;
}
#endif /* WFO_VIRT_RECEIVER */

struct net_device *wfo_dev_get_by_name(struct net *net, const char *name)
{
	struct net_device *dev;

#ifndef __ECOS
	rcu_read_lock();
	dev = dev_get_by_name_rcu(net, name);
	rcu_read_unlock();
#else
	dev = dev_get_by_name(net, name);
#endif

	return dev;
}

#if defined(WFO_VIRT_RECEIVER) && \
	!defined(USE_RTK_TAROKO_IPC)
void (*wfo_virt_cmd_ipc_receiver)(wfo_cfg80211_t *cfg) = NULL;
EXPORT_SYMBOL(wfo_virt_cmd_ipc_receiver);

void (*wfo_radio_cmd_ipc_receiver)(wfo_cfg80211_t *cfg) = NULL;
EXPORT_SYMBOL(wfo_radio_cmd_ipc_receiver);
#endif /* WFO_VIRT_RECEIVER && !USE_RTK_TAROKO_IPC */

