#ifndef __WFO_CMD_VIRT_H__
#define __WFO_CMD_VIRT_H__

//==============================================================================
#if !defined(CPTCFG_BACKPORTED_WIRELESS)
#if defined(CONFIG_WFO_VIRT_SAME_CPU)
#define CPTCFG_WFO_VIRT_SAME_CPU
#endif

#if defined(CONFIG_2G_ON_WLAN0)
#define CPTCFG_2G_ON_WLAN0
#endif

#if defined(CONFIG_WFO_OFFLOAD_2G)
#define CPTCFG_WFO_OFFLOAD_2G
#endif

#if defined(CONFIG_WFO_OFFLOAD_5G)
#define CPTCFG_WFO_OFFLOAD_5G
#endif

#if	defined(CONFIG_WFO_VIRT_MODULE)
#ifndef CPTCFG_WFO_VIRT_MODULE
#define CPTCFG_WFO_VIRT_MODULE
#endif /* !CPTCFG_WFO_VIRT_MODULE */
#endif /* CONFIG_WFO_VIRT_MODULE */
#endif /* !CPTCFG_BACKPORTED_WIRELESS */

//==============================================================================
#define SIOCDEVPRIVATEAXEXT 0x89f2 /* copy from user/boa/src/LINUX/subr_wlan_wifi6.c */

#define WLAN_ROOT_IFACE_NUM 2
#define WLAN_IFACE_NUM (WLAN_ROOT_IFACE_NUM)

#define WLAN_IFACE_NAME CONFIG_WFO_VIRT_DEVNAME //"wlan"

#if defined(CPTCFG_WFO_OFFLOAD_2G)
 #if defined(CPTCFG_2G_ON_WLAN0)
 #define WLAN_G6		WLAN_IFACE_NAME"1"
 #define WLAN_WFOVIRT	WLAN_IFACE_NAME"0"
 #else
 #define WLAN_G6		WLAN_IFACE_NAME"0"
 #define WLAN_WFOVIRT	WLAN_IFACE_NAME"1"
 #endif
#elif defined(CPTCFG_WFO_OFFLOAD_5G)
 #if defined(CPTCFG_2G_ON_WLAN0)
 #define WLAN_G6		WLAN_IFACE_NAME"0"
 #define WLAN_WFOVIRT	WLAN_IFACE_NAME"1"
 #else
 #define WLAN_G6		WLAN_IFACE_NAME"1"
 #define WLAN_WFOVIRT	WLAN_IFACE_NAME"0"
 #endif
#else
	#error "undefined interface!!"
#endif

struct dev_map_tbl_s {
	struct net_device *ndev;
	struct wiphy *wiphy;

	void *adapter;
	unsigned char br_mac[ETH_ALEN];
};

#ifndef __ECOS
#include <net/mac80211.h> /* for IEEE80211_MAX_PN_LEN */
#else
#define IEEE80211_MAX_PN_LEN	16
#endif
#if defined(CONFIG_WIRELESS_EXT)
#include <net/iw_handler.h>
#endif
#include "./wfo_cmd_debug.h"

#include <soc/realtek/rtk_shm.h>

//==============================================================================
#if defined(CPTCFG_WFO_VIRT_MODULE)
    /*
    +-------------+----------------------+----------------------+
    | 2G_ON_WLAN0 |    OFFLOAD_2G        |    OFFLOAD_5G        |
    +-------------+----------------------+----------------------+
    |    N        | pcie-0,5g,wlan0,g6   | pcie-0,5g,wlan0,virt |
    |             | pcie-1,2g,wlan1,virt | pcie-1,2g,wlan1,g6   |
    +-------------+----------------------+----------------------+
    |    Y        | pcie-0,5g,wlan1,g6   | pcie-0,5g,wlan1,virt |
    |             | pcie-1,2g,wlan0,virt | pcie-1,2g,wlan0,g6   |
    +-------------+----------------------+----------------------+
    */

#if defined(CPTCFG_WFO_OFFLOAD_2G)
  #define WFO_SKIP_PCIE_SLOT 1
#elif defined(CPTCFG_WFO_OFFLOAD_5G)
  #define WFO_SKIP_PCIE_SLOT 0
#endif

#endif /* CPTCFG_WFO_VIRT_MODULE */

//==============================================================================
#define WFO_CMD_VIRT_CFG_OPS
#define WFO_CMD_VIRT_NDEV_OPS

#if defined(CONFIG_RTK_WFOAX)
#define USE_WFO_NIC
#endif /* CONFIG_RTK_WFOAX */

#if !defined(CPTCFG_WFO_VIRT_SAME_CPU)
#if defined(CONFIG_RTK_TAROKO_IPC) && defined(CPTCFG_WFO_VIRT_MODULE)
#define USE_RTK_TAROKO_IPC
#endif /* CONFIG_RTK_TAROKO_IPC & CPTCFG_WFO_VIRT_MODULE */
#endif /* !CPTCFG_WFO_VIRT_SAME_CPU */

#ifdef WIFI6_THER_CTRL
#include <ther_ctrl.h>
#endif

//==============================================================================
#define _WFO_CMD(type) \
	wfo_cmd_##type

#define WFO_CMD(type) \
	((u32)(_WFO_CMD(type)))

#define cmd_str(arg) #arg

#define WFO_CFG80211_CMD                			\
	WFO_DEF(none),									\
													\
	/* cfg80211_ops: virt -> radio */				\
	WFO_DEF(change_virtual_intf),					\
	WFO_DEF(add_key),								\
	WFO_DEF(get_key),								\
	WFO_DEF(del_key),								\
	WFO_DEF(set_default_key),						\
	WFO_DEF(set_default_mgmt_key),					\
	WFO_DEF(get_station),							\
	WFO_DEF(scan),									\
	WFO_DEF(set_wiphy_params),						\
	WFO_DEF(connect),								\
	WFO_DEF(disconnect),							\
	WFO_DEF(join_ibss), 							\
	WFO_DEF(leave_ibss),							\
	WFO_DEF(set_tx_power),							\
	WFO_DEF(get_tx_power),							\
	WFO_DEF(set_power_mgmt),						\
	WFO_DEF(set_pmksa), 							\
	WFO_DEF(del_pmksa), 							\
	WFO_DEF(flush_pmksa),							\
	WFO_DEF(add_virtual_intf),						\
	WFO_DEF(del_virtual_intf),						\
	WFO_DEF(start_ap),								\
	WFO_DEF(change_beacon), 						\
	WFO_DEF(stop_ap),								\
	WFO_DEF(set_mac_acl),							\
	WFO_DEF(add_station),							\
	WFO_DEF(del_station),							\
	WFO_DEF(change_station),						\
	WFO_DEF(dump_station),							\
	WFO_DEF(change_bss),							\
	WFO_DEF(set_txq_params),						\
	WFO_DEF(channel_switch), 						\
	WFO_DEF(probe_client),							\
	WFO_DEF(set_monitor_channel),					\
	WFO_DEF(get_channel),							\
	WFO_DEF(remain_on_channel), 					\
	WFO_DEF(cancel_remain_on_channel),				\
	WFO_DEF(update_ft_ies),							\
	WFO_DEF(mgmt_tx),								\
	WFO_DEF(update_mgmt_frame_registrations),		\
	WFO_DEF(mgmt_frame_register),					\
	WFO_DEF(tdls_mgmt),								\
	WFO_DEF(tdls_oper),								\
	WFO_DEF(sched_scan_start),						\
	WFO_DEF(sched_scan_stop),						\
	WFO_DEF(suspend),								\
	WFO_DEF(resume),								\
	WFO_DEF(rfkill_poll),							\
	WFO_DEF(dump_survey), 							\
	WFO_DEF(external_auth), 						\
													\
	/* net_device ops */							\
	WFO_DEF(ndo_start_xmit),						\
	WFO_DEF(ndo_validate_addr), 					\
	WFO_DEF(ndo_set_mac_address),					\
	WFO_DEF(ndo_open),								\
	WFO_DEF(ndo_stop),								\
	WFO_DEF(ndo_get_stats), 						\
	WFO_DEF(ndo_do_ioctl),							\
	WFO_DEF(iwpriv),								\
	WFO_DEF(std_handler),							\
													\
	/* other: virt -> radio */						\
	WFO_DEF(band_cap),		 						\
	WFO_DEF(proc_file),								\
	WFO_DEF(unregister_ndev),						\
	WFO_DEF(get_wireless_stats),					\
	WFO_DEF(netlink_recv_msg),						\
	WFO_DEF(reg_notifier),							\
	WFO_DEF(sync_sta_status),						\
	WFO_DEF(therctl_ops),							\
	WFO_DEF(therctl_ops_async),						\
	WFO_DEF(new_virt_cmd_xxx),						\
													\
	/* nl80211: radio -> virt */					\
	WFO_DEF(cfg80211_new_sta),						\
	WFO_DEF(cfg80211_del_sta),						\
	WFO_DEF(cfg80211_scan_done),					\
	WFO_DEF(cfg80211_vendor_cmd_reply),				\
	WFO_DEF(cfg80211_ibss_joined),					\
	WFO_DEF(cfg80211_ch_switch_notify),				\
	WFO_DEF(cfg80211_ready_on_channel),				\
	WFO_DEF(cfg80211_inform_bss_frame),				\
	WFO_DEF(cfg80211_vendor_cmd_alloc_reply_skb),	\
	WFO_DEF(cfg80211_roamed),						\
	WFO_DEF(cfg80211_mgmt_tx_status),				\
	WFO_DEF(cfg80211_rx_mgmt),						\
	WFO_DEF(cfg80211_rx_unprot_mlme_mgmt),			\
	WFO_DEF(cfg80211_remain_on_channel_expired),	\
	WFO_DEF(cfg80211_put_bss),						\
	WFO_DEF(cfg80211_unlink_bss),					\
	WFO_DEF(cfg80211_disconnected),					\
	WFO_DEF(cfg80211_vendor_event),					\
	WFO_DEF(cfg80211_michael_mic_failure),			\
	WFO_DEF(cfg80211_connect_result),				\
	WFO_DEF(cfg80211_get_bss),						\
	WFO_DEF(cfg80211_ch_switch_started_notify),		\
	WFO_DEF(cfg80211_vendor_event_alloc),			\
	WFO_DEF(cfg80211_external_auth_request),		\
	WFO_DEF(cfg80211_connect_done),					\
	WFO_DEF(cfg80211_ft_event),						\
													\
	/* other: radio -> virt */						\
	WFO_DEF(open_file),								\
	WFO_DEF(is_file_readable),						\
	WFO_DEF(pass_log),								\
	WFO_DEF(check_srcmac_in_fdb_for_ax_driver),		\
	WFO_DEF(rtk_eventd_netlink_send),				\
	WFO_DEF(netlink_send_msg),						\
	WFO_DEF(core_map_nl_event_send_fragment),		\
	WFO_DEF(regulatory_hint),						\
	WFO_DEF(wireless_send_event),					\
	WFO_DEF(mac_to_fc),								\
	WFO_DEF(new_radio_cmd_xxx),						\
													\
	/* max */										\
	WFO_DEF(max)


#define WFO_DEF(type) _WFO_CMD(type)
enum wfo_cfg80211_cmd {
	WFO_CFG80211_CMD,
};
#undef WFO_DEF

#define WFO_CMD_MAX wfo_cmd_max

#ifndef MIN
#define MIN(x, y) (((u32)(x) <= (u32)(y)) ? (u32)(x) : (u32)(y))
#endif

//==============================================================================
#if defined(CPTCFG_WFO_VIRT_MODULE) && defined(WFO_VIRT_SENDER)
#if 1
#define RTW_INFO(fmt, args...) \
	do { \
		printk(fmt, ## args); \
	} while(0)
#else
#define RTW_INFO(fmt, args...) \
	do {} while(0)
#endif
#define RTW_ERR(x, ...) do {} while (0)

#define wdev_to_ndev(w) ((w)->netdev)
#define wdev_to_wiphy(w) ((w)->wiphy)
#define ndev_to_wdev(n) ((n)->ieee80211_ptr)

#define MAC_FMT "%02x:%02x:%02x:%02x:%02x:%02x"
#define MAC_ARG(x) ((u8 *)(x))[0], ((u8 *)(x))[1], ((u8 *)(x))[2], \
			((u8 *)(x))[3], ((u8 *)(x))[4], ((u8 *)(x))[5]

#define wiphy_to_ndev(wiphy) (((struct wfo_wiphy_data *)wiphy_priv(wiphy))->ndev)

#define RTL_IOCTL_WPA_SUPPLICANT	(SIOCIWFIRSTPRIV+30)
#ifdef CONFIG_AP_MODE
#define RTL_IOCTL_HOSTAPD (SIOCIWFIRSTPRIV + 28)
#endif

#else /* !(CPTCFG_WFO_VIRT_MODULE && WFO_VIRT_SENDER) */
#ifndef wiphy_to_ndev
#define wiphy_to_ndev(wiphy) (((_adapter *)wiphy_to_adapter(wiphy))->rtw_wdev->netdev)
#endif
#define wfo_cfg_ops(wiphy) (((struct rtw_wiphy_data *)wiphy_priv(wiphy))->cfg_ops)
#endif /* CPTCFG_WFO_VIRT_MODULE && WFO_VIRT_SENDER */


#ifndef RTW_SSID_SCAN_AMOUNT
#define RTW_SSID_SCAN_AMOUNT 9 /* for WEXT_CSCAN_AMOUNT 9 */
#endif
#ifndef RTW_CHANNEL_SCAN_AMOUNT
#define RTW_CHANNEL_SCAN_AMOUNT (14+37)
#endif
#ifndef NUM_ACL
#define NUM_ACL 100 /* refer g6_wifi_driver/include/sta_info.h*/
#endif

enum wfo_cmd_run_mode {
	RUN_LOCALLY,
	RUN_REMOTELY,
	RUN_MODE_MAX
};

#define WFO_STRUCT_TYPE(type) \
	wfo_struct_##type

enum wfo_ipc_dir {
	wfo_ipc_sender,
	wfo_ipc_receiver,
};

enum wfo_struct_type {
	WFO_STRUCT_TYPE(cfg80211_pmksa),
	WFO_STRUCT_TYPE(cfg80211_chan_def),
	WFO_STRUCT_TYPE(cfg80211_beacon_data),
	WFO_STRUCT_TYPE(station_parameters),
	WFO_STRUCT_TYPE(key_params),
	WFO_STRUCT_TYPE(max),
};

enum wfo_trace_item {
	TRACE_WRAPPER,
	TRACE_SENDER,
	TRACE_RECEIVER,
	TRACE_MAX,
};

enum wfo_trace_dir {
	TRACE_IN,
	TRACE_OUT,
};

enum wfo_trace_cnt_type {
	SENDER_IN,
	SENDER_OUT,
	RECEIVER_IN,
	RECEIVER_OUT,
	TRACE_CNT_MAX,
};

static const char cmd_run_mode[RUN_MODE_MAX][16] = {
	"local",
	"remote"
};

#if defined(CPTCFG_WFO_VIRT_SAME_CPU)
#define WFO_IFACE_POSTFIX "rf"
#else /* !CPTCFG_WFO_VIRT_SAME_CPU */
#define WFO_IFACE_POSTFIX ""
#endif /* CPTCFG_WFO_VIRT_SAME_CPU */

enum{
	WFO_IOCTL_SET = 0, /* copy form user */
	WFO_IOCTL_GET = 1, /* copy to user */
	WFO_IOCTL_BIDIR = 2, /* bi-dir */
};

//==============================================================================

#if defined(WFO_CMD_VIRT_CFG_OPS) || defined(WFO_CMD_VIRT_NDEV_OPS)
struct __wfo_station_info {
	struct station_info source;

	u8 assoc_req_ies[IEEE80211_MAX_DATA_LEN];
	struct cfg80211_tid_stats pertid;
};


struct __wfo_key_params {
	struct key_params source;

	u8 key[WLAN_MAX_KEY_LEN];
	u8 seq[IEEE80211_MAX_PN_LEN];
};


struct __wfo_cfg80211_crypto_settings {
	/* from struct cfg80211_cached_keys */
	struct key_params wep_keys[CFG80211_MAX_WEP_KEYS];
	u8 key[CFG80211_MAX_WEP_KEYS][WLAN_KEY_LEN_WEP104];

	u8 psk[PMK_MAX_LEN];

#ifdef WFO_K510
	u8 sae_pwd[SAE_PASSWORD_MAX_LEN];
#endif /* WFO_K510 */
};


struct __wfo_cfg80211_connect_params {
	struct cfg80211_connect_params source;

	struct ieee80211_channel channel;
	struct ieee80211_channel channel_hint;
	u8 bssid[ETH_ALEN];
	u8 bssid_hint[ETH_ALEN];
	u8 ssid[IEEE80211_MAX_SSID_LEN];
	u8 ie[IEEE80211_MAX_DATA_LEN];
	struct __wfo_cfg80211_crypto_settings crypto;
	u8 key[WLAN_MAX_KEY_LEN];
	u8 prev_bssid[ETH_ALEN];
	u8 fils_erp_username[FILS_ERP_MAX_USERNAME_LEN];
	u8 fils_erp_realm[FILS_ERP_MAX_REALM_LEN];
	u8 fils_erp_rrk[FILS_ERP_MAX_RRK_LEN];
};


struct __wfo_cfg80211_chan_def {
	struct cfg80211_chan_def source;

	struct ieee80211_channel chan;
};


struct __wfo_cfg80211_ibss_params {
	struct cfg80211_ibss_params source;

	u8 ssid[IEEE80211_MAX_SSID_LEN];
	u8 bssid[ETH_ALEN];
	struct __wfo_cfg80211_chan_def chandef;
	u8 ie[IEEE80211_MAX_DATA_LEN];

	/* from struct cfg80211_cached_keys */
	struct key_params wep_keys[CFG80211_MAX_WEP_KEYS];
	u8 key[CFG80211_MAX_WEP_KEYS][WLAN_KEY_LEN_WEP104];
};


struct __wfo_vif_params {
	struct vif_params source;

	u8 vht_mumimo_groups[VHT_MUMIMO_GROUPS_DATA_LEN];
	u8 vht_mumimo_follow_addr[ETH_ALEN];
};


struct __wfo_cfg80211_pmksa {
	struct cfg80211_pmksa source;

	u8 bssid[ETH_ALEN];
	u8 pmkid[WLAN_PMKID_LEN];
	u8 pmk[PMK_MAX_LEN];
	u8 ssid[IEEE80211_MAX_SSID_LEN];
	u8 cache_id[2];
};


struct __wfo_cfg80211_acl_data {
	struct cfg80211_acl_data source;
	struct mac_address mac_addrs[NUM_ACL];
};


struct __wfo_cfg80211_ap_settings {
	struct cfg80211_ap_settings source;

	struct __wfo_cfg80211_chan_def chandef;
#if (WFO_SHRINK_CFG_SIZE==1)
	/* move to struct wfo_cfg80211_extra_param */
#else /* !WFO_SHRINK_CFG_SIZE */
	struct __wfo_cfg80211_beacon_data beacon;
#endif /* WFO_SHRINK_CFG_SIZE */
	u8 ssid[IEEE80211_MAX_SSID_LEN];
	struct __wfo_cfg80211_crypto_settings crypto;
	struct __wfo_cfg80211_acl_data acl;

	struct ieee80211_ht_cap ht_cap;
	struct ieee80211_vht_cap vht_cap;
	struct ieee80211_he_cap_elem he_cap;
#ifdef WFO_K510
	struct ieee80211_he_operation he_oper;
	u8 optional[8];
	#if 0 /* move to rtk_shm.h, struct middleware */
	u8 fils_discovery[IEEE80211_MAX_DATA_LEN];
	u8 unsol_bcast_probe_resp[IEEE80211_MAX_DATA_LEN];
	#endif
#endif /* WFO_K510 */
};


struct __wfo_station_parameters {
	struct station_parameters source;

	u8 supported_rates[NL80211_MAX_SUPP_RATES];
	char vlan[IFNAMSIZ];//struct net_device *vlan;

	struct ieee80211_ht_cap ht_capa;
	struct ieee80211_vht_cap vht_capa;
	struct ieee80211_he_cap_elem he_capa;
#ifdef WFO_K510
	struct ieee80211_he_6ghz_capa he_6ghz_capa;
#endif /* WFO_K510 */

	u8 ext_capab[U8_MAX+1];
	u8 supported_channels[U8_MAX+1];
	u8 supported_oper_classes[U8_MAX+1];
};


struct __wfo_station_del_parameters {
	struct station_del_parameters source;
	u8 mac[ETH_ALEN];
};


struct __wfo_ieee80211_txq_params {
	struct ieee80211_txq_params source;
};

struct __wfo_cfg80211_csa_settings{
	struct cfg80211_csa_settings source;

	struct __wfo_cfg80211_chan_def chandef;
	struct __wfo_cfg80211_beacon_data beacon_csa;
};

struct __wfo_cfg80211_mgmt_tx_params {
	struct cfg80211_mgmt_tx_params source;

	struct ieee80211_channel chan;
	u8 buf[IEEE80211_MAX_DATA_LEN];
#if 0 /* not use in G6 */
	u16 csa_offsets[U16_MAX+1];
#endif
};


struct __wfo_cfg80211_external_auth_params {
	struct cfg80211_external_auth_params source;
	u8 pmkid[WLAN_PMKID_LEN];
};


struct __wfo_ieee80211_supported_band {
	struct ieee80211_supported_band source;

	struct ieee80211_channel channels;//[MAX_CHANNEL_NUM_5G];
	struct ieee80211_rate bitrates;//[RTW_G_RATES_NUM];
	struct ieee80211_sband_iftype_data iftype_data;
};


struct __wfo_survey_info {
	struct survey_info source;
	struct ieee80211_channel channel;
};


struct wfo_change_virtual_intf {
	enum nl80211_iftype type;
#if (LINUX_VERSION_CODE < KERNEL_VERSION(4, 12, 0))
	u32 *flags;
#endif

	struct __wfo_vif_params data;

	/* for copy band */
	struct __wfo_ieee80211_supported_band band;

#define WFO_CHANGE_VIRTUAL_INTF_HAS_PARAMS 0
#define WFO_CHANGE_VIRTUAL_INTF_HAS_VHT_MUMIMO_GROUPS 1
#define WFO_CHANGE_VIRTUAL_INTF_HAS_VHT_MUMIMO_FOLLOW_ADDR 2

	u8 mflags;
};


struct wfo_add_key {
	u8 key_index;
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 37)) || defined(COMPAT_KERNEL_RELEASE)
	bool pairwise;
#endif
	u8 mac_addr[ETH_ALEN];
	struct __wfo_key_params data;

#define WFO_ADD_KEY_HAS_MAC_ADDR 0
#define WFO_ADD_KEY_HAS_PARAMS 1
	u8 mflags;
};


struct wfo_get_key {
	u8 keyid;
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 37)) || defined(COMPAT_KERNEL_RELEASE)
	bool pairwise;
#endif
	u8 mac_addr[ETH_ALEN];
	struct __wfo_key_params data;

	//void *cookie;
	//void (*callback)(void *cookie, struct key_params *);

#define WFO_GET_KEY_HAS_MAC_ADDR 0
#define WFO_GET_KEY_HAS_PARAMS 1
	u8 mflags;
};


struct wfo_del_key {
	u8 key_index;
	bool pairwise;
	u8 mac_addr[ETH_ALEN];

#define WFO_DEL_KEY_HAS_MAC_ADDR 0
	u8 mflags;
};


struct wfo_set_default_key {
	u8 key_index;
	#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 38)) || defined(COMPAT_KERNEL_RELEASE)
	bool unicast;
	bool multicast;
	#endif
};


struct wfo_set_default_mgmt_key {
	u8 key_index;
};


struct wfo_get_station {
	u8 mac[ETH_ALEN];

	struct __wfo_station_info data;

#define WFO_GET_STATION_HAS_MAC 0
#define WFO_GET_STATION_HAS_SINFO 1
	u8 mflags;
};


struct wfo_scan {
#if (WFO_SHRINK_CFG_SIZE==1)
	/* move to struct wfo_cfg80211_extra_param */
#else /* !WFO_SHRINK_CFG_SIZE */
	struct __wfo_cfg80211_scan_request data;
#endif /* WFO_SHRINK_CFG_SIZE */
	struct cfg80211_scan_info info;
#ifdef WFO_K510
	int cond;
#endif /* WFO_K510 */

#define WFO_SCAN_HAS_REQUEST 0
#define WFO_SCAN_HAS_INFO 1
	u8 mflags;
};


struct wfo_set_wiphy_params {
	u32 changed;
};


struct wfo_connect {
	struct __wfo_cfg80211_connect_params data;

#define WFO_CONNECT_HAS_SME 0
	u8 mflags;
};


struct wfo_disconnect {
	u16 reason_code;
};


struct wfo_join_ibss {
	struct __wfo_cfg80211_ibss_params data;

#define WFO_JOIN_IBSS_HAS_PARAMS 0
	u8 mflags;
};


struct wfo_set_tx_power {
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 36)) || defined(COMPAT_KERNEL_RELEASE)
	enum nl80211_tx_power_setting type;
	int mbm;
#else
	enum tx_power_setting type;
	int dbm;
#endif
};


struct wfo_get_tx_power {
	int dbm;
};


struct wfo_set_power_mgmt {
	bool enabled;
	int timeout;
};


struct wfo_set_pmksa {
	struct __wfo_cfg80211_pmksa data;

#define WFO_SET_PMKSA_HAS_PMKSA 0
	u8 mflags;
};


struct wfo_del_pmksa {
	struct __wfo_cfg80211_pmksa data;

#define WFO_DEL_PMKSA_HAS_PMKSA 0
	u8 mflags;
};


struct wfo_flush_pmksa {
};


struct wfo_struct_sz {
	/* g6 related */
	unsigned int _adapter;
	unsigned int mlme_priv;
	unsigned int security_priv;
	unsigned int registry_priv;
	unsigned int mib_table_size;
	unsigned int mp_priv;
	unsigned int MPT_CONTEXT;

	/* wfo related */
	unsigned int wfo_cfg80211_t;
	unsigned int wfo_mib_t;

	/* os related */
	unsigned int _timer;
	unsigned int timer_list;
	unsigned int sk_buff_head;
	unsigned int spinlock_t;
	unsigned int _mutex;
	unsigned int _lock;
	unsigned int _list;
	unsigned int atomic_t;
	unsigned int _workitem;
	unsigned int _tasklet;
	unsigned int _queue;
	unsigned int _completion;
	unsigned int _sema;
};


struct wfo_add_virtual_intf {
	char name[IFNAMSIZ];
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(4, 1, 0))
	unsigned char name_assign_type;
#endif
	enum nl80211_iftype type;
#if (LINUX_VERSION_CODE < KERNEL_VERSION(4, 12, 0))
	u32 *flags;
#endif

#if (WFO_DBG_DEV_FLAGS==1)
	unsigned short		ndev_flags;
	unsigned int		ndev_priv_flags;
#endif /* WFO_DBG_DEV_FLAGS */

	struct __wfo_vif_params data;

#ifdef CONFIG_RTK_WFO_NO_VIRT
	struct wireless_dev *wdev;
#endif /* CONFIG_RTK_WFO_NO_VIRT */

	unsigned char wfo_mib_idx;
};


struct wfo_del_virtual_intf {
};


struct wfo_start_ap {
	struct __wfo_cfg80211_ap_settings data;

#if defined(WFO_CHECK_STRUCT_SZ)
	char check_sz;
	struct wfo_struct_sz linux_sz;
	struct wfo_struct_sz ecos_sz;
#endif /* WFO_CHECK_STRUCT_SZ */
};


struct wfo_change_beacon{
#if (WFO_SHRINK_CFG_SIZE==1)
	/* move to struct wfo_cfg80211_extra_param */
#else /* !WFO_SHRINK_CFG_SIZE */
	struct __wfo_cfg80211_beacon_data beacon;
#endif /* WFO_SHRINK_CFG_SIZE */

#define WFO_CHANGE_BEACON_HAS_INFO 0
	u8 mflags;
};


struct wfo_stop_ap {
};


struct wfo_set_mac_acl {
	struct __wfo_cfg80211_acl_data data;

#define WFO_SET_MAC_ACL_HAS_PARAMS 0
	u8 mflags;
};


struct wfo_add_station {
	struct __wfo_station_parameters data;
	u8 mac[ETH_ALEN];

#define WFO_ADD_STATION_HAS_PARAMS 0
#define WFO_ADD_STATION_HAS_MAC 1
	u8 mflags;
};


struct wfo_del_station {
	struct __wfo_station_del_parameters data;

#define WFO_DEL_STATION_HAS_PARAMS 0
#define WFO_DEL_STATION_HAS_MAC 1
	u8 mflags;
};


struct wfo_change_station {
	struct __wfo_station_parameters data;
	u8 mac[ETH_ALEN];

#define WFO_CHANGE_STATION_HAS_PARAMS 0
#define WFO_CHANGE_STATION_HAS_MAC 1
	u8 mflags;
};


struct wfo_dump_station {
	int idx;
	u8 mac[ETH_ALEN];

	struct __wfo_station_info sinfo;

#define WFO_DUMP_STATION_HAS_MAC 0
#define WFO_DUMP_STATION_HAS_SINFO 1
	u8 mflags;
};


struct wfo_change_bss {
	struct bss_parameters params;
};


struct wfo_set_txq_params {
	struct __wfo_ieee80211_txq_params data;

#define WFO_SET_TXQ_PARAMS_HAS_PARAMS 0
	u8 mflags;
};

struct wfo_channel_switch{
	struct __wfo_cfg80211_csa_settings data;
};

struct wfo_set_monitor_channel {
	struct cfg80211_chan_def chandef;

#define WFO_SET_MONITOR_CHANNEL_HAS_CHANDEF 0
	u8 mflags;
};

struct wfo_probe_client {
	u8 peer[ETH_ALEN];
	u64 cookie;

#define WFO_PROBE_CLIENT_HAS_PEER 0
	u8 mflags;
};

struct wfo_get_channel {
	struct __wfo_cfg80211_chan_def data;
};


struct wfo_remain_on_channel {
	struct ieee80211_channel channel;
	unsigned int duration;
	u64 cookie;

#define WFO_REMAIN_ON_CHANNEL_HAS_CHANNEL 0
	u8 mflags;
};


struct wfo_cancel_remain_on_channel {
	u64 cookie;
};


struct wfo_mgmt_tx {
	struct __wfo_cfg80211_mgmt_tx_params data;
	u64 cookie;
};

#if (LINUX_VERSION_CODE < KERNEL_VERSION(5, 8, 0))
struct mgmt_frame_regs {
	u32 global_stypes, interface_stypes;
	u32 global_mcast_stypes, interface_mcast_stypes;
};
#endif

struct wfo_update_mgmt_frame_registrations {
	struct mgmt_frame_regs upd;

#define WFO_UPDATE_MGMT_FRAME_REGISTRATIONS_HAS_UPD 0
#define WFO_DUMP_STATION_HAS_SINFO 1
		u8 mflags;
};


struct wfo_mgmt_frame_register {
	u16 frame_type;
	bool reg;
};


struct wfo_dump_survey {
	struct __wfo_survey_info data;
	int idx;
	u32 freq;
};


struct wfo_external_auth {
	struct __wfo_cfg80211_external_auth_params data;
};

struct wfo_leave_ibss {};

struct wfo_update_ft_ies {
	struct cfg80211_update_ft_ies_params source;
	u8 ie[IEEE80211_MAX_DATA_LEN];
};

struct wfo_tdls_mgmt {};
struct wfo_tdls_oper {};
struct wfo_sched_scan_start {};
struct wfo_sched_scan_stop {};
struct wfo_suspend {};
struct wfo_resume {};
struct wfo_rfkill_poll {};

//------------------------------------------------------------------------------
struct wfo_cfg80211_new_sta {
	u8 mac_addr[ETH_ALEN];
	struct __wfo_station_info sinfo;
	gfp_t gfp;

#define WFO_CFG80211_NEW_STA_HAS_MAC 0
#define WFO_CFG80211_NEW_STA_HAS_SINFO 1
	u8 mflags;
};


struct wfo_cfg80211_del_sta {
	u8 mac_addr[ETH_ALEN];
	gfp_t gfp;

#define WFO_CFG80211_DEL_STA_HAS_MAC 0
	u8 mflags;
};

#define MAX_BSSINFO_LEN 1000 /* copy from g6_wifi_driver/os_dep/linux/ioctl_cfg80211.c*/
struct wfo_cfg80211_inform_bss_frame {
	size_t len;
	s32 signal;
	gfp_t gfp;
	u32 freq;

	union {
		struct ieee80211_mgmt mgmt;
		u8 buf[MAX_BSSINFO_LEN];
	};
};


struct wfo_cfg80211_put_bss {
	struct cfg80211_bss *bss;
};


struct wfo_cfg80211_ch_switch_started_notify {
	struct __wfo_cfg80211_chan_def data;
	u8 count;
};


struct wfo_cfg80211_connect_result {
	u8 bssid[ETH_ALEN];
	u8 req_ie[IEEE80211_MAX_DATA_LEN];
	size_t req_ie_len;
	u8 resp_ie[IEEE80211_MAX_DATA_LEN];
	size_t resp_ie_len;
	u16 status;
	gfp_t gfp;

#define WFO_CFG80211_CONNECT_RESULT_HAS_BSSID 0
#define WFO_CFG80211_CONNECT_RESULT_HAS_REQ_IE 1
#define WFO_CFG80211_CONNECT_RESULT_HAS_RESP_IE 2

	u8 mflags;
};


struct wfo_cfg80211_get_bss {
#if 1 /* pass freq to linux side and search related channel */
	u32 freq;
#else
	struct ieee80211_channel channel;
#endif
	u8 bssid[ETH_ALEN];
	u8 ssid[IEEE80211_MAX_SSID_LEN];
	size_t ssid_len;
	enum ieee80211_bss_type bss_type;
	enum ieee80211_privacy privacy;
};

#if (WFO_SHRINK_CFG_SIZE==1)
#define RX_MGMT_MAX_LEN (147*32)
#else /* !WFO_SHRINK_CFG_SIZE */
#define RX_MGMT_MAX_LEN (8192)
#endif /* WFO_SHRINK_CFG_SIZE */
struct wfo_cfg80211_rx_mgmt {
	int freq;
	int sig_dbm;
	u8 buf[RX_MGMT_MAX_LEN];
	size_t len;
	u32 flags;
};

struct wfo_cfg80211_rx_unprot_mlme_mgmt {
	u8 buf[RX_MGMT_MAX_LEN];
	size_t len;
};

struct wfo_cfg80211_external_auth_request {
	struct cfg80211_external_auth_params params;
	gfp_t gfp;
};


struct wfo_cfg80211_disconnected {
	u16 reason;
	u8 ie[IEEE80211_MAX_DATA_LEN];
	size_t ie_len;
	bool locally_generated;
	gfp_t gfp;
};


struct wfo_cfg80211_scan_done {};
struct wfo_cfg80211_vendor_cmd_reply {};
struct wfo_cfg80211_ibss_joined {};

struct wfo_cfg80211_ch_switch_notify {
	struct __wfo_cfg80211_chan_def data;
};

struct wfo_cfg80211_ready_on_channel {};
struct wfo_cfg80211_vendor_cmd_alloc_reply_skb {};
struct wfo_cfg80211_roamed {};
struct wfo_cfg80211_mgmt_tx_status {
	u64 cookie;
	size_t len;
	bool ack;
	gfp_t gfp;
	u8 buf[IEEE80211_MAX_DATA_LEN];
};
struct wfo_cfg80211_remain_on_channel_expired {};

struct wfo_cfg80211_unlink_bss {
	struct cfg80211_bss *bss;
};

struct wfo_cfg80211_vendor_event {};
struct wfo_cfg80211_michael_mic_failure {};
struct wfo_cfg80211_vendor_event_alloc {};
struct wfo_cfg80211_connect_done {};

struct wfo_cfg80211_ft_event {
	struct cfg80211_ft_event_params source;

	u8 ies[IEEE80211_MAX_DATA_LEN];
	u8 target_ap[ETH_ALEN];
	u8 ric_ies[IEEE80211_MAX_DATA_LEN];
};


//------------------------------------------------------------------------------
struct wfo_net_device_ops {
	union {
		struct sockaddr sa;
		unsigned char br_mac[ETH_ALEN];
		char sz[32]; /* for eCos compatible */
	};
	struct net_device_stats	stats;
};


#define MAX_IOCTL_BUFLEN (15*1024)
struct wfo_ndo_do_ioctl {
	int cmd;
	union {
		struct iwreq wrq;
		struct ifreq rq;
		char sz[48]; /* for eCos compatible */
	};
	unsigned short subcmd;
	unsigned short subcmd_len;
	struct iw_point iwp;
#if (WFO_SHRINK_CFG_SIZE==1)
	/* move to struct wfo_cfg80211_extra_param */
#else /* !WFO_SHRINK_CFG_SIZE */
	unsigned char data[MAX_IOCTL_BUFLEN];
#endif /* WFO_SHRINK_CFG_SIZE */
};

struct wfo_ndo_start_xmit {};
struct wfo_ndo_validate_addr {};
struct wfo_ndo_set_mac_address {};
struct wfo_ndo_open {};
struct wfo_ndo_stop {};
struct wfo_ndo_get_stats {};

#define MAX_IWPRIV_BUFLEN ((u32)4096)
struct wfo_iwpriv {
	struct iw_request_info info;
	union {
		union iwreq_data wdata;
		char sz[32]; /* for eCos compatible */
	};
	unsigned char data[MAX_IWPRIV_BUFLEN];
#if (WFO_SHRINK_CFG_SIZE==1)
	/* use local variable */
#else /* !WFO_SHRINK_CFG_SIZE */
	unsigned char extra[MAX_IWPRIV_BUFLEN];
#endif /* WFO_SHRINK_CFG_SIZE */
	u32 extra_size;
	u32 no_extra;
};

struct wfo_std_handler {
	struct iw_request_info info;
	union {
		union iwreq_data wdata;
		char sz[32]; /* for eCos compatible */
	};
#if (WFO_SHRINK_CFG_SIZE==1)
	/* not use */
#else /* !WFO_SHRINK_CFG_SIZE */
	unsigned char data[MAX_IWPRIV_BUFLEN];
#endif /* WFO_SHRINK_CFG_SIZE */
	unsigned char extra[MAX_IWPRIV_BUFLEN];
	int extra_size;
	int descr_header_type;
};


#ifndef MAX_CHANNEL_NUM_2G
#define CENTER_CH_2G_NUM		14
#define CENTER_CH_5G_20M_NUM	28	/* 20M center channels */

#define	MAX_CHANNEL_NUM_2G	CENTER_CH_2G_NUM
#define	MAX_CHANNEL_NUM_5G	CENTER_CH_5G_20M_NUM
#endif
#ifndef RTW_G_RATES_NUM
#define RTW_G_RATES_NUM	12
#endif

#define IW_HEADER_TYPE_POINT 8 //in linux-4.4.x/include/net/iw_handler.h
#define WFO_IFTYPE_DATA_NUM 2
struct __wfo_ieee80211_supported_band2 {
	struct ieee80211_supported_band source;

	struct ieee80211_channel channels[MAX_CHANNEL_NUM_5G];
	struct ieee80211_rate bitrates[RTW_G_RATES_NUM];
	struct ieee80211_sband_iftype_data iftype_data[WFO_IFTYPE_DATA_NUM];
};


struct wfo_band_cap {
	int band_type;
	unsigned char index;
	struct __wfo_ieee80211_supported_band2 band;
};

#if 1 /* copy from g6_wifi_driver/phl/hal_g6/hal_config.h */
#define MAX_PATH_LEN			256
#endif
struct wfo_open_file {
	char str[MAX_PATH_LEN];
	u32 size;
};

struct wfo_is_file_readable {
	char str[MAX_PATH_LEN];
};

struct wfo_check_srcmac_in_fdb_for_ax_driver {
	char addr[ETH_ALEN];
};

#define MAX_PAYLOAD 2048
struct wfo_rtk_eventd_netlink_send {
	int eventID;
	char ifname[IFNAMSIZ];
	char data[MAX_PAYLOAD];
	int data_len;
};

#define NL_MAX_MSG_SIZE                768 /* copy from g6_wifi_driver\include\rtw_wlan_manager.h */
struct wfo_netlink_send_msg {
	/*sizeof(struct nl_message) = NL_MAX_MSG_SIZE + 8  see g6_wifi_driver\include\rtw_wlan_manager.h*/
	char msg[NL_MAX_MSG_SIZE + 8];
	u32 msg_len;
};

#define MAP_MAX_PAYLOAD_SZ     2048 /* copy from g6_wifi_driver\include\rtk_multi_ap.h */
struct wfo_core_map_nl_event_send_fragment {
	char data[MAP_MAX_PAYLOAD_SZ];
	u32 msg_len;
};

struct wfo_proc_file {
	char str[MAX_PATH_LEN];
	int printk_format;
};

struct wfo_unregister_ndev {
};

struct wfo_get_wireless_stats {
	struct iw_statistics iwstats;
};

struct wfo_netlink_recv_msg {
	struct nlmsghdr nlhdr;
	/*sizeof(struct nl_message) = NL_MAX_MSG_SIZE + 8  see g6_wifi_driver\include\rtw_wlan_manager.h*/
	char msg[NL_MAX_MSG_SIZE + 8];
};


//#define MAC_ALEN 6
	/* copy from g6_wifi_driver/phl/phl_types.h*/

#if 0 /* move to wfo_virt_ext.h */
#ifndef CONFIG_LIMITED_STA_NUM
#define MACID_NUM_SW_LIMIT 64
#else
#define MACID_NUM_SW_LIMIT (CONFIG_LIMITED_STA_NUM+CONFIG_LIMITED_AP_NUM+1)
#endif
	/* copy from g6_wifi_driver/include/drv_conf.h */
#define NUM_STA MACID_NUM_SW_LIMIT
	/*copy from g6_wifi_driver/include/sta_info.h */

#define WFO_MAC_ALEN	6	//MAC_ALEN
#define WFO_IFACE_NUM	(CONFIG_IFACE_NUMBER)
#define WFO_STA_NUM		(NUM_STA)
#endif

struct wfo_sta_ptr_s
{
	struct wfo_sta_st_s *st;
	struct net_device *dev;
};

struct wfo_sync_sta_status {
#if 1//(WFO_SHRINK_CFG_SIZE==1)
	/* move to struct wfo_cfg80211_extra_param */
#else /* !WFO_SHRINK_CFG_SIZE */
	struct wfo_sta_st_s sta_st[WFO_IFACE_NUM][WFO_STA_NUM];
#endif /* WFO_SHRINK_CFG_SIZE */
};

struct wfo_new_virt_cmd_xxx {
	//todo
};

struct wfo_reg_notifier {
	struct regulatory_request request;
};

struct wfo_regulatory_hint {
	char alpha2[3];
};

#if (WFO_SHRINK_CFG_SIZE==1)
#define MAX_EXTRA_LEN		(147*32)
#else /* !WFO_SHRINK_CFG_SIZE */
#define MAX_EXTRA_LEN		(15*1024)
#endif /* WFO_SHRINK_CFG_SIZE */
struct wfo_wireless_send_event {
	unsigned int cmd;
	union iwreq_data wrqu;
	char extra[MAX_EXTRA_LEN];

#define WFO_WIRELESS_SEND_EVENT_HAS_WRQU 0
#define WFO_WIRELESS_SEND_EVENT_HAS_EXTRA 1
	u8 mflags;
};

struct wfo_mac_to_fc {
	u8 mac_addr[ETH_ALEN];
	u8 flag;

#define WFO_MAC_TO_FC_HAS_MAC 0
	u8 mflags;
};

#ifdef WIFI6_THER_CTRL
struct wfo_therctl_ops {
	struct ther_info_s info;
	u8 cmd;
};
#else /* WIFI6_THER_CTRL */
struct wfo_therctl_ops {
	int parameter;
	u8 cmd;
};
#endif /* WIFI6_THER_CTRL */
struct wfo_therctl_ops_async {
	int parameter;
	u8 cmd;
};

struct wfo_new_radio_cmd_xxx {
	//todo
};

#if (WFO_SHRINK_CFG_SIZE==1)
#define MAX_PROC_LOG_LEN		(147*32)
#else /* !WFO_SHRINK_CFG_SIZE */
#define MAX_PROC_LOG_LEN		(15*1024)
#endif /* WFO_SHRINK_CFG_SIZE */
struct wfo_pass_log {
	char str[MAX_PROC_LOG_LEN];
	int write_offset;
	int enable_linux_output;//enable linux output
	int printk_format;//output format
	int rssi_enable;
	int log_level_enable;
	int ipc_type; // 0:ASYNC / 1:SYNC
};

typedef struct wfo_cfg80211_s
{
#if defined(PLATFORM_ECOS)
	void *ndev;
#else /* !PLATFORM_ECOS */
	atomic_t busy;
#endif /* PLATFORM_ECOS */

//-- reset below before use ----------------------------------------------------
	unsigned char reset_ptr[0];

	char dev_name[IFNAMSIZ];
	unsigned int dev_idx;
	unsigned short side;
	unsigned short is_sync;
	unsigned int cmd;
	int ret_val;

 	union {
		/* cfg80211_ops  */
		struct wfo_change_virtual_intf change_virtual_intf;
		struct wfo_add_key add_key;
		struct wfo_get_key get_key;
		struct wfo_del_key del_key;
		struct wfo_set_default_key set_default_key;
		struct wfo_set_default_mgmt_key set_default_mgmt_key;
		struct wfo_get_station get_station;
		struct wfo_scan scan;
		struct wfo_set_wiphy_params set_wiphy_params;
		struct wfo_connect connect;
		struct wfo_disconnect disconnect;
		struct wfo_join_ibss join_ibss;
		struct wfo_set_tx_power set_tx_power;
		struct wfo_get_tx_power get_tx_power;
		struct wfo_set_power_mgmt set_power_mgmt;
		struct wfo_set_pmksa set_pmksa;
		struct wfo_del_pmksa del_pmksa;
		struct wfo_flush_pmksa flush_pmksa;
		struct wfo_add_virtual_intf add_virtual_intf;
		struct wfo_del_virtual_intf del_virtual_intf;
		struct wfo_start_ap start_ap;
		struct wfo_change_beacon change_beacon;
		struct wfo_stop_ap stop_ap;
		struct wfo_set_mac_acl set_mac_acl;
		struct wfo_add_station add_station;
		struct wfo_del_station del_station;
		struct wfo_change_station change_station;
		struct wfo_dump_station dump_station;
		struct wfo_change_bss change_bss;
		struct wfo_set_txq_params set_txq_params;
		struct wfo_channel_switch channel_switch;
		struct wfo_probe_client probe_client;
		struct wfo_set_monitor_channel set_monitor_channel;
		struct wfo_get_channel get_channel;
		struct wfo_remain_on_channel remain_on_channel;
		struct wfo_cancel_remain_on_channel cancel_remain_on_channel;
		struct wfo_mgmt_tx mgmt_tx;
		struct wfo_update_mgmt_frame_registrations update_mgmt_frame_registrations;
		struct wfo_mgmt_frame_register mgmt_frame_register;
		struct wfo_dump_survey dump_survey;
		struct wfo_external_auth external_auth;
		struct wfo_update_ft_ies ft_ies;

		/* not cfg ops */
		struct wfo_net_device_ops ndev_ops;
		struct wfo_ndo_do_ioctl ioctl;
		struct wfo_iwpriv iwpriv;
		struct wfo_std_handler std_handler;
		struct wfo_band_cap band_cap;
		struct wfo_proc_file proc_file;
		struct wfo_unregister_ndev unregister_ndev;
		struct wfo_get_wireless_stats get_wireless_stats;
		struct wfo_netlink_recv_msg netlink_recv_msg;
		struct wfo_reg_notifier reg_notifier;
		struct wfo_sync_sta_status sync_sta_status;
		struct wfo_therctl_ops thermal_ctrl;
		struct wfo_therctl_ops_async thermal_ctrl_async;
		struct wfo_new_virt_cmd_xxx new_virt_cmd_xxx; /* add new virt cmd before this line */

		/* g6 -> nl80211 */
		struct wfo_cfg80211_new_sta cfg80211_new_sta;
		struct wfo_cfg80211_del_sta cfg80211_del_sta;
		struct wfo_cfg80211_scan_done cfg80211_scan_done;
		struct wfo_cfg80211_inform_bss_frame cfg80211_inform_bss_frame;
		struct wfo_cfg80211_put_bss cfg80211_put_bss;
		struct wfo_cfg80211_ch_switch_started_notify cfg80211_ch_switch_started_notify;
		struct wfo_cfg80211_get_bss cfg80211_get_bss;
		struct wfo_cfg80211_connect_result cfg80211_connect_result;
		struct wfo_cfg80211_vendor_cmd_reply cfg80211_vendor_cmd_reply;
		struct wfo_cfg80211_ibss_joined cfg80211_ibss_joined;
		struct wfo_cfg80211_ch_switch_notify cfg80211_ch_switch_notify;
		struct wfo_cfg80211_ready_on_channel cfg80211_ready_on_channel;
		struct wfo_cfg80211_vendor_cmd_alloc_reply_skb cfg80211_vendor_cmd_alloc_reply_skb;
		struct wfo_cfg80211_roamed cfg80211_roamed;
		struct wfo_cfg80211_mgmt_tx_status cfg80211_mgmt_tx_status;
		struct wfo_cfg80211_rx_mgmt cfg80211_rx_mgmt;
		struct wfo_cfg80211_rx_unprot_mlme_mgmt cfg80211_rx_unprot_mlme_mgmt;
		struct wfo_cfg80211_external_auth_request cfg80211_external_auth_request;
		struct wfo_cfg80211_remain_on_channel_expired cfg80211_remain_on_channel_expired;
		struct wfo_cfg80211_unlink_bss cfg80211_unlink_bss;
		struct wfo_cfg80211_disconnected cfg80211_disconnected;
		struct wfo_cfg80211_vendor_event cfg80211_vendor_event;
		struct wfo_cfg80211_michael_mic_failure cfg80211_michael_mic_failure;
		struct wfo_cfg80211_vendor_event_alloc cfg80211_vendor_event_alloc;
		struct wfo_cfg80211_connect_done cfg80211_connect_done;
		struct wfo_cfg80211_ft_event ft_event;

		/* radio other */
		struct wfo_open_file open_file;
		struct wfo_is_file_readable is_file_readable;
		struct wfo_pass_log pass_log;
		struct wfo_check_srcmac_in_fdb_for_ax_driver check_srcmac_in_fdb_for_ax_driver;
		struct wfo_rtk_eventd_netlink_send rtk_eventd_netlink_send;
		struct wfo_netlink_send_msg netlink_send_msg;
		struct wfo_core_map_nl_event_send_fragment core_map_nl_event_send_fragment;
		struct wfo_regulatory_hint regulatory_hint;
		struct wfo_wireless_send_event wireless_send_event;
		struct wfo_mac_to_fc mac_to_fc;
		struct wfo_new_radio_cmd_xxx new_radio_cmd_xxx;
	};
} __attribute__((packed)) wfo_cfg80211_t;

void wfo_copy_struct_data(enum wfo_ipc_dir dir,
	enum wfo_struct_type type, void *dst, void *src);

struct wfo_none {};
struct wfo_max {};

#endif /* WFO_CMD_VIRT_CFG_OPS || WFO_CMD_VIRT_NDEV_OPS */

typedef struct {
	u32 sig;
	u32 sig2;
	void *padapter;
	struct net_device *pnetdev;

	void *mlmepriv;
	void *securitypriv;
	void *registrypriv;
	u8 multi_ap_mode;
} wfo_adapter_t;

#if defined(WFO_VIRT_SENDER) || defined(WFO_RADIO_RECEIVER)
/* Linux Side */
struct wfo_ndev_priv {
	unsigned char wfo_mib_idx;
	wfo_adapter_t wfo_adapter;

	struct net_device *ndev;
	struct wireless_dev wdev;
#if !defined(USE_GLOBAL_CFG)
#if (WFO_CFG_SMP==1)
	wfo_cfg80211_t cfg[NR_CPUS];
#else /* WFO_CFG_SMP!=1 */
	wfo_cfg80211_t cfg;
#endif /* WFO_CFG_SMP */
#endif /* USE_GLOBAL_CFG */
	struct cfg80211_scan_request *scan_req;
#ifdef WFO_K510
	struct cfg80211_scan_request *int_scan_req;
#endif /* WFO_K510 */
	unsigned char iface_id;
	unsigned char radio_name[IFNAMSIZ];

	/* reset when open */
#if defined(CPTCFG_WFO_VIRT_SAME_CPU)
	struct net_device *radio_ndev;
#endif /* CPTCFG_WFO_VIRT_SAME_CPU */
	struct proc_dir_entry *dir_dev;
	struct proc_dir_entry *dir_odm;
#ifdef CONFIG_MCC_MODE
	struct proc_dir_entry *dir_mcc;
#endif
	struct iw_statistics iwstats;
};
#endif /* WFO_VIRT_SENDER | WFO_RADIO_RECEIVER */

#if defined(WFO_VIRT_RECEIVER)
/* Ecos Side */
void sync_tx_stats(int dev_id, struct xmit_priv *pxmitpriv);
void sync_rx_stats(int dev_id, struct recv_priv *precvpriv);
void wfo_set_devname(_adapter *adapter, struct registry_priv *regsty);
int wfo_check_offload(_adapter *padapter);

struct net_device *wfo_rx_ndev(struct net_device *ndev);
struct dev_map_tbl_s* get_radio_map(int idx);
void update_radio_map(struct net_device *ndev, int idx);

#if !defined(CPTCFG_WFO_VIRT_SAME_CPU)
extern wfo_cfg80211_t *proc_cfg;
extern wfo_cfg80211_t log_cfg;
#endif /* !CPTCFG_WFO_VIRT_SAME_CPU */

#ifdef __ECOS
extern int set_mac_address(const char *interface, char *mac_address);
extern int interface_up(const char *intf);
extern int interface_down(const char *intf);
#endif /* __ECOS */
#endif /* WFO_VIRT_RECEIVER */


#if defined(WFO_VIRT_SENDER)
extern struct proc_dir_entry *rtw_virt_adapter_proc_init(struct net_device *dev);
extern void rtw_virt_adapter_proc_deinit(struct net_device *dev);
#endif /* WFO_VIRT_SENDER */

struct wfo_cmd_recv_array_s {
	unsigned int cmd;
	int (*cmd_fp)(struct wiphy *wiphy,
		struct net_device *ndev,
		wfo_cfg80211_t *cfg);
	unsigned short sync;
};

u8 wfo_get_ndev_id(u8 id);
char *get_cmd_str(u16 subcmd);
struct net_device *wfo_dev_get_by_name(struct net *net, const char *name);
void show_wfo_cfg_size(void);

extern void wfo_get_struct_size(struct wfo_struct_sz *sz);
extern void wfo_show_struct_size(struct wfo_struct_sz *linux_sz,
				struct wfo_struct_sz *ecos_sz);

struct wfo_iwpriv_arg {
	char name[32];		/* mib name */
	int stype;			/* structure type */
};

struct __wfo_ndev_priv {
	unsigned char wfo_mib_idx;
	wfo_adapter_t wfo_adapter;
};

#define WFO_IWPRIV(type) \
	wfo_iwpriv_##type

enum wfo_iwpriv_stype {
	WFO_IWPRIV(registrypriv),
	WFO_IWPRIV(mlmepriv),
	WFO_IWPRIV(securitypriv),
};

#endif /* __WFO_CMD_VIRT_H__ */
