unsigned char is_g6_ndev(struct net_device *dev)
{
	if (dev &&
		dev->netdev_ops &&
		dev->netdev_ops->ndo_do_ioctl &&
		dev->netdev_ops->ndo_do_ioctl == rtw_ioctl)
		return 1;

	return 0;
}

unsigned char is_g6_adapter(_adapter *padapter)
{
	unsigned char ret = 0;
	struct net_device *dev = NULL;

	if (padapter && padapter->pnetdev) {
		ret = is_g6_ndev(padapter->pnetdev);
	}
	return ret;
}

#ifdef WFO_VIRT_RECEIVER
void alloc_wfo_mib(_adapter *padapter)
{
	wfo_dram_t *wfo_dram = RTK_SHM_DRAM;
	wfo_mib_t *wfo_mib = NULL;

	if (sizeof(wfo_mib_t) < MIB_BUF_SIZE) {
		wfo_mib = (wfo_mib_t *)((struct __wfo_mib *)
					(wfo_dram->md.mib)+padapter->iface_id);
		memset(wfo_mib, 0, sizeof(wfo_mib_t));

		padapter->wfo = wfo_mib;
	} else {
		printk("==> [%s:%d], sizeof(wfo_mib_t)=%d > MIB_BUF_SIZE=%d!!\n",
			__func__, __LINE__, sizeof(wfo_mib_t), MIB_BUF_SIZE);
		/* please change MIB_BUF_SIZE in linux-4.4.x/include/soc/realtek/rtk_shm.h */
	}
}

void update_wfo_mib(_adapter *padapter)
{
#if defined(CONFIG_RTW_PERSIST_IF) || defined(CPTCFG_RTW_PERSIST_IF)
	if (padapter->wfo) {
#else
	if (padapter->netif_up && padapter->wfo) {
#endif
		wfo_mib_t *mib = padapter->wfo;
#ifdef CONFIG_RTW_MULTI_AP
		mib->multi_ap_mode = padapter->multi_ap_mode;
#endif
		memcpy(&mib->mlmepriv, &padapter->mlmepriv, sizeof(struct mlme_priv));
		memcpy(&mib->securitypriv, &padapter->securitypriv, sizeof(struct security_priv));
		memcpy(&mib->registrypriv, &padapter->registrypriv, sizeof(struct registry_priv));

		WFO_DBGP("dev=%s\n", padapter->rtw_wdev->netdev->name);

	#if 0
		printk("==> [%s:%d], iface_id=%d, wfo=%p, wfo_mapid=%d\n",
			__func__, __LINE__, padapter->iface_id, padapter->wfo, padapter->wfo_mapid);
	#endif
	}
}
#endif /* WFO_VIRT_RECEIVER */

void wfo_get_struct_size(struct wfo_struct_sz *sz)
{
	extern unsigned int mib_table_size(void);

	/* g6 related */
	sz->_adapter = sizeof(_adapter);
	sz->mlme_priv = sizeof(struct mlme_priv);
	sz->security_priv = sizeof(struct security_priv);
	sz->registry_priv = sizeof(struct registry_priv);
	sz->mib_table_size = mib_table_size();
	sz->mp_priv = sizeof(struct mp_priv);
	sz->MPT_CONTEXT = sizeof(MPT_CONTEXT);

	/* wfo related */
	sz->wfo_cfg80211_t = sizeof(wfo_cfg80211_t);
	sz->wfo_mib_t = sizeof(wfo_mib_t);

	/* os related */
	sz->_timer = sizeof(_timer);
	sz->timer_list = sizeof(struct timer_list);
	sz->sk_buff_head = sizeof(struct sk_buff_head);
	sz->spinlock_t = sizeof(spinlock_t);
	sz->_mutex = sizeof(_mutex);
	sz->_lock = sizeof(_lock);
	sz->_list = sizeof(_list);
	sz->atomic_t = sizeof(atomic_t);
	sz->_workitem = sizeof(_workitem);
	sz->_tasklet = sizeof(_tasklet);
	sz->_queue = sizeof(_queue);
	sz->_completion = sizeof(_completion);
	sz->_sema = sizeof(_sema);
}
EXPORT_SYMBOL(wfo_get_struct_size);

void wfo_show_struct_size(struct wfo_struct_sz *linux_sz,
		struct wfo_struct_sz *ecos_sz)
{
#define SHOW_STRUCT_SZ(X) \
	do { \
		printk("\t" "linux=%08u %s ecos=%08u, %s\n", \
			linux_sz->X, (((linux_sz->X) == (ecos_sz->X))?"==":"!=") ,ecos_sz->X, #X); \
	}while(0)

	printk("%s:\n", __func__);

	/* g6 related */
	SHOW_STRUCT_SZ(_adapter);
	SHOW_STRUCT_SZ(mlme_priv);
	SHOW_STRUCT_SZ(security_priv);
	SHOW_STRUCT_SZ(registry_priv);
	SHOW_STRUCT_SZ(mib_table_size);
	SHOW_STRUCT_SZ(mp_priv);
	SHOW_STRUCT_SZ(MPT_CONTEXT);

	/* wfo related */
	SHOW_STRUCT_SZ(wfo_cfg80211_t);
	SHOW_STRUCT_SZ(wfo_mib_t);

	/* os related */
	SHOW_STRUCT_SZ(_timer);
	SHOW_STRUCT_SZ(timer_list);
	SHOW_STRUCT_SZ(sk_buff_head);
	SHOW_STRUCT_SZ(spinlock_t);
	SHOW_STRUCT_SZ(_mutex);
	SHOW_STRUCT_SZ(_lock);
	SHOW_STRUCT_SZ(_list);
	SHOW_STRUCT_SZ(atomic_t);
	SHOW_STRUCT_SZ(_workitem);
	SHOW_STRUCT_SZ(_tasklet);
	SHOW_STRUCT_SZ(_queue);
	SHOW_STRUCT_SZ(_completion);
	SHOW_STRUCT_SZ(_sema);
	printk("\n\n");
}
EXPORT_SYMBOL(wfo_show_struct_size);

u32 get_sizeof_wfo_mib_t(void)
{
	return sizeof(wfo_mib_t);
}
EXPORT_SYMBOL(get_sizeof_wfo_mib_t);

#if 1 /* copy from g6_wifi_driver/core/rtw_mib.c */
typedef enum {
	BYTE_T,
	INT_T,
	STRING_T,
	SHORT_T
} TYPE_T;

struct iwpriv_arg {
	char name[32];		/* mib name */
	TYPE_T type;		/* Type and number of args */
	int offset_prev;	/* pram offset in driver previous */
	int offset_mib; 	/* mib offset in struct wifi_mib_priv */
	int len;			/* mib byte len */
	int Default;		/* mib default value */
	void (*fun)(_adapter *, char *, u32);	/* call back function */
};
#endif

#if !defined(__ECOS) && defined(CPTCFG_WFO_VIRT_MODULE)
static struct wfo_iwpriv_arg wfo_mib_table[] = {
	{"multiap_bss_type", WFO_IWPRIV(registrypriv)},
	{"func_off",	WFO_IWPRIV(registrypriv)},
	{"band",		WFO_IWPRIV(registrypriv)},
	{"opmode",		WFO_IWPRIV(mlmepriv)},
	{"ssid",		WFO_IWPRIV(mlmepriv)},
	{"authtype",	WFO_IWPRIV(securitypriv)},
	{"encmode",		WFO_IWPRIV(securitypriv)},
};

struct wfo_iwpriv_arg *wfo_get_tbl_entry(char *pstr)
{
	int i=0;
	int arg_num = sizeof(wfo_mib_table)/sizeof(struct wfo_iwpriv_arg);
	volatile char name[128];

	if (pstr[0]=='\0')
		WFO_WARN("mibname is NULL\n");

	while (*pstr && *pstr != '=') {
		if (i >= sizeof(name)-1)
			return NULL;
		name[i++] = *pstr++;
	}
	name[i] = '\0';

	for (i=0; i<arg_num; i++) {
		if (!strcmp((char *)name, wfo_mib_table[i].name)) {
			return &wfo_mib_table[i];
		}
	}

	return NULL;
}
EXPORT_SYMBOL(wfo_get_tbl_entry);

_adapter *wfo_get_mib_offset(struct net_device *dev, char *mibname, void *_entry)
{
	wfo_adapter_t *wfo_padapter = NULL;
	_adapter *padapter = NULL;
	wfo_dram_t *wfo_dram = RTK_SHM_DRAM;
	wfo_mib_t *wfo_mib = NULL;
	int is_virt = 0;
	unsigned char *offset = 0;
	struct iwpriv_arg *entry = (struct iwpriv_arg *)_entry;

	if (dev->netdev_ops &&
		dev->netdev_ops->ndo_do_ioctl &&
		dev->netdev_ops->ndo_do_ioctl == rtw_ioctl) {
		return (_adapter *)rtw_netdev_priv(dev);
	}
	else {
		struct wfo_iwpriv_arg *wentry = NULL;
		struct __wfo_ndev_priv *ndev_priv = (struct __wfo_ndev_priv *)netdev_priv(dev);
		int idx = ndev_priv->wfo_mib_idx;

		WFO_DBGP("mibname=%s, dev=%s, idx=%d\n",
			mibname, dev->name,
			ndev_priv->wfo_mib_idx);

		wfo_padapter = (wfo_adapter_t *)&ndev_priv->wfo_adapter;

		wentry = wfo_get_tbl_entry((char *)mibname);
		if (wentry == NULL) {
			WFO_PRINT("invalid mibname [%s] !\n", mibname);
			return NULL;
		}

		wfo_mib = (wfo_mib_t *)((struct __wfo_mib *)
					(wfo_dram->md.mib)+idx);

		switch(wentry->stype) {
		case WFO_IWPRIV(registrypriv):
			padapter = container_of(&wfo_mib->registrypriv, _adapter, registrypriv);
			break;
		case WFO_IWPRIV(mlmepriv):
			padapter = container_of(&wfo_mib->mlmepriv, _adapter, mlmepriv);
			break;
		case WFO_IWPRIV(securitypriv):
			padapter = container_of(&wfo_mib->securitypriv, _adapter, securitypriv);
			break;
		default:
			WFO_PRINT("unknown stype\n");
			return NULL;
		};

#if 0
		if(entry->offset_prev)
			offset = (unsigned char *)padapter + entry->offset_prev;
		else if(entry->offset_mib)
			offset = (unsigned char *)padapter + entry->offset_mib;
		else
			WFO_PRINT("unknown offset\n");

		WFO_DBGP("padapter=%p, offset=%p, wfo_mib=%p\n",
				padapter, offset, wfo_mib);
#endif

		wfo_padapter->pnetdev = dev;
		wfo_padapter->multi_ap_mode = wfo_mib->multi_ap_mode;
		wfo_padapter->registrypriv = (void *)&wfo_mib->registrypriv;
		wfo_padapter->mlmepriv = (void *)&wfo_mib->mlmepriv;
		wfo_padapter->securitypriv = (void *)&wfo_mib->securitypriv;
		wfo_padapter->padapter = (void *)padapter;
		set_wfo_adapter_sig(wfo_padapter);

		return (_adapter *)wfo_padapter;
	}
}
#endif /* !__ECOS & CPTCFG_WFO_VIRT_MODULE */

#if defined(CPTCFG_WFO_VIRT_MODULE)
void rtw_mib_get_show(struct iwpriv_arg *entry, unsigned char flag,
		unsigned char *tmpbuf2, char *extra)
{
	printk("==> [%s:%d], name[%s] type[%d], flag[%d]\n",
		__func__, __LINE__, entry->name, entry->type, flag);

	switch (entry->type)
	{
		case BYTE_T:
			printk("byte data: %d\n", *((unsigned char *)tmpbuf2));
			break;
		case INT_T:
			printk("int data: %d\n", *((int *)tmpbuf2));
			break;
		case STRING_T:
			printk("string data: %s\n", extra);
			break;
		case SHORT_T:
			printk("short data: %d\n", *((u16 *)tmpbuf2));
			break;
	}
}
#endif /* CPTCFG_WFO_VIRT_MODULE */

#if defined(PLATFORM_ECOS)
int regulatory_set_wiphy_regd_sync_rtnl(struct wiphy *wiphy,
					struct ieee80211_regdomain *rd)
{
	return 0;
}
void rtnl_lock(void) {}
void rtnl_unlock(void) {}

u32 get_trx_tp(void)
{
	u32 i=0, trx_tp = 0;

	for (i=0; i<WFO_IFACE_NUM; i++) {
		struct dev_map_tbl_s *map = get_radio_map(i);
		_adapter *adapter = (_adapter *)(map->adapter);
		if (adapter && adapter->netif_up) {
			trx_tp += (adapter->tp_total_trx >> 10);
		}
	}
	return trx_tp;//Mbps
}
#endif /* PLATFORM_ECOS */


#if defined(PLATFORM_ECOS)
#include <phl/phl_headers.h>
#include <phl/hal_g6/hal_headers.h>
#include <phl/hal_g6/rtl8192xb/rtl8192xb_hal.h>
#include <phl/hal_g6/rtl8192xb/pci/hal_trx_8192xbe.h>

#include <g6_ecos_check_define.h>
#endif /* PLATFORM_ECOS */

