#include <linux/module.h>
#ifndef __ECOS
#include <soc/realtek/rtk_ipc.h>
#else
#include <rtk_ipc.h>
#endif
#include "wfo_ipc.h"

//==============================================================================
//  IPC for virt
//==============================================================================
#if defined(WFO_VIRT_SENDER)
int wfo_virt_cmd_ipc_sender(void* data, unsigned short size, unsigned short type)
{
	unsigned int result = 0U;
	rtk_ipc_pkt_t cmd;

	memset(&cmd, 0, sizeof(rtk_ipc_pkt_t));

	cmd.dst_cpu_id = VIRT_CPU_ID;
	cmd.session_id = VIRT_IPC_SESSION;
	cmd.msg_no = (u16)WFO_VIRT_IPC_CMD;
	cmd.priority = IPC_PRIO_HIGH ;
	cmd.msg_data = data;
	cmd.msg_size = size;

	if (type == SYNC)
		result = rtk_ipc_msg_sync_send(&cmd, data, &size);
	else if (type == ASYNC)
		result = rtk_ipc_msg_async_send(&cmd);
	else
		WFO_PRINT("Failed. ipc_sender must select SYNC or ASYNC\n");

	if (result != IPC_OK)
		WFO_PRINT("Failed. err = %d\n", result);

	if (size != sizeof(wfo_cfg80211_t)) {
		WFO_PRINT("ack's msg_size=%d and sizeof(wfo_cfg80211_t)=%d were mismatched!!\n",
					size, sizeof(wfo_cfg80211_t));
		show_wfo_cfg_size();
	}

	return (int)result;
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
int wfo_virt_cmd_ipc_receiver_cb(rtk_ipc_addr_t peer,
		uint16_t msg_no,
		uint16_t trans_id,
		const void *msg_data,
		uint16_t* msg_size)
{
	wfo_virt_cmd_receiver((wfo_cfg80211_t *)msg_data);

	if (*msg_size != sizeof(wfo_cfg80211_t)) {
		WFO_PRINT("msg_size=%d and sizeof(wfo_cfg80211_t)=%d were mismatched!!\n",
					*msg_size, sizeof(wfo_cfg80211_t));
		*msg_size = sizeof(wfo_cfg80211_t);
		show_wfo_cfg_size();
	}
	return 0;
}

rtk_ipc_msg_handle_t wfo_virt_ipc[] = {
	{.msg_no = WFO_VIRT_IPC_CMD, .proc = wfo_virt_cmd_ipc_receiver_cb },
};

static void register_wfo_virt_ipc_cb(void)
{
	int rc = 0;

	rc = rtk_ipc_msg_handle_register(VIRT_IPC_SESSION,
		wfo_virt_ipc, sizeof(wfo_virt_ipc)/sizeof(rtk_ipc_msg_handle_t));

	if (rc != IPC_OK) {
		WFO_PRINT("Register IPC Failed :%d\n", rc);
	} else {
		WFO_PRINT("Register OK!\n");
	}
}
#endif /* WFO_VIRT_RECEIVER */


//==============================================================================
//  IPC for radio
//==============================================================================
#if defined(WFO_RADIO_SENDER)
int wfo_radio_cmd_ipc_sender(void* data, unsigned short size, unsigned short type)
{
	unsigned int result = 0U;
	rtk_ipc_pkt_t cmd;

	memset(&cmd, 0, sizeof(rtk_ipc_pkt_t));

	cmd.dst_cpu_id = RADIO_CPU_ID;
	cmd.session_id = RADIO_IPC_SESSION;
	cmd.msg_no = WFO_RADIO_IPC_CMD;
	cmd.priority = IPC_PRIO_HIGH ;
	cmd.msg_data = data;
	cmd.msg_size = size;

	if (type == SYNC)
		result = rtk_ipc_msg_sync_send(&cmd, data, &size);
	else if (type == ASYNC)
		result = rtk_ipc_msg_async_send(&cmd);
	else
		WFO_PRINT("Failed. ipc_sender must select SYNC or ASYNC\n");

	if (result != IPC_OK)
		WFO_PRINT("Failed. err = %d\n", result);

	return (int)result;
}
#endif /* WFO_RADIO_SENDER */

#if defined(WFO_RADIO_RECEIVER)
int wfo_radio_cmd_ipc_receiver_cb(rtk_ipc_addr_t peer,
		uint16_t msg_no,
		uint16_t trans_id,
		const void *msg_data,
		uint16_t* msg_size)
{
	wfo_radio_cmd_receiver((wfo_cfg80211_t *)msg_data);
	return 0;
}

rtk_ipc_msg_handle_t wfo_radio_ipc[] = {
	{.msg_no = WFO_RADIO_IPC_CMD, .proc = wfo_radio_cmd_ipc_receiver_cb },
};

static void register_wfo_radio_ipc_cb(void)
{
	unsigned int rc = 0U;

	rc = rtk_ipc_msg_handle_register(RADIO_IPC_SESSION,
		wfo_radio_ipc, (u16)(sizeof(wfo_radio_ipc)/sizeof(rtk_ipc_msg_handle_t)));

	if (rc != IPC_OK) {
		WFO_PRINT("Register IPC Failed :%d\n", rc);
	} else {
		WFO_PRINT("Register OK!\n");
	}
}
#endif /* WFO_RADIO_RECEIVER */

