#ifndef __WFO_IPC_H__
#define __WFO_IPC_H__

typedef enum {
	WFO_VIRT_IPC_CMD = 1,
	WFO_RADIO_IPC_CMD,
} wfo_ipc_command_t;

typedef enum {
        SYNC = 1,
        ASYNC,
} wfo_ipc_sync_async_t;

#if defined(WFO_VIRT_SENDER) || defined(WFO_VIRT_RECEIVER)
#if defined(CPTCFG_WFO_VIRT_SAME_CPU)
	#define VIRT_IPC_SESSION IPC_SESSION_WFO
	#define VIRT_CPU_ID CPU_MAIN
#else
	#define VIRT_IPC_SESSION IPC_SESSION_WFO
	#define VIRT_CPU_ID IPC_CPU_PE0
#endif
#endif

#if defined(WFO_RADIO_SENDER) || defined(WFO_RADIO_RECEIVER)
#if defined(CPTCFG_WFO_VIRT_SAME_CPU)
	#define RADIO_IPC_SESSION IPC_SESSION_VPN
	#define RADIO_CPU_ID CPU_MAIN
#else
	#define RADIO_IPC_SESSION IPC_SESSION_WFO
	#define RADIO_CPU_ID CPU_MAIN
#endif
#endif


#if defined(WFO_VIRT_SENDER)
void wfo_virt_cmd_sender(wfo_cfg80211_t *cfg);
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
void wfo_virt_cmd_receiver(wfo_cfg80211_t *cfg);
#endif /* WFO_VIRT_RECEIVER */

#if defined(WFO_RADIO_SENDER)
void wfo_radio_cmd_sender(wfo_cfg80211_t *cfg);
#endif /* #if defined(WFO_RADIO_SENDER) */

#if defined(WFO_RADIO_RECEIVER)
void wfo_radio_cmd_receiver(wfo_cfg80211_t *cfg);
#endif /* WFO_RADIO_RECEIVER */


#if !defined(USE_RTK_TAROKO_IPC)
extern void (*wfo_virt_cmd_ipc_receiver)(wfo_cfg80211_t *cfg);
extern void (*wfo_radio_cmd_ipc_receiver)(wfo_cfg80211_t *cfg);
#endif /* !USE_RTK_TAROKO_IPC */

#endif /* __WFO_IPC_H__ */
