#include <linux/module.h>
#include "wfo_ipc.h"

//==============================================================================
//  IPC for virt
//==============================================================================
#if defined(WFO_VIRT_SENDER)
int wfo_virt_cmd_ipc_sender(void* data, unsigned short size, unsigned short type)
{
	if (wfo_virt_cmd_ipc_receiver) {
		wfo_virt_cmd_ipc_receiver(data);
		return 0;
	}
	else {
		WFO_PRINT("wfo_virt_cmd_ipc_receiver is NULL!\n");
		return -1;
	}
}
#endif /* WFO_VIRT_SENDER */

#if defined(WFO_VIRT_RECEIVER)
static void register_wfo_virt_ipc_cb(void)
{
	wfo_virt_cmd_ipc_receiver = wfo_virt_cmd_receiver;
}
#endif /* WFO_VIRT_RECEIVER */


//==============================================================================
//  IPC for radio
//==============================================================================
#if defined(WFO_RADIO_SENDER)
int wfo_radio_cmd_ipc_sender(void* data, unsigned short size, unsigned short type)
{
	if (wfo_radio_cmd_ipc_receiver) {
		wfo_radio_cmd_ipc_receiver(data);
		return 0;
	}
	else {
		WFO_PRINT("wfo_radio_cmd_ipc_receiver is NULL!\n");
		return -1;
	}
}
#endif /* WFO_RADIO_SENDER */

#if defined(WFO_RADIO_RECEIVER)
static void register_wfo_radio_ipc_cb(void)
{
	wfo_radio_cmd_ipc_receiver = wfo_radio_cmd_receiver;
}
#endif /* WFO_RADIO_RECEIVER */

