#if !defined(CPTCFG_WFO_VIRT_SAME_CPU)
//==============================================================================
//  wlan_proc
//==============================================================================
struct seq_file *seq_file_ptr;

#define rtw_virt_proc_hdl(_name) \
	{ .name = _name}

#if (LINUX_VERSION_CODE >= KERNEL_VERSION(5, 6, 0))
#define rtw_proc_ops proc_ops
#else
#define rtw_proc_ops file_operations
#endif

struct rtw_virt_proc_hdl {
	char *name;
};

struct rtw_proc_hdl {
	char *name;
	u8 type;
	union {
		int (*show)(struct seq_file *, void *);
		struct seq_operations *seq_op;
		struct {
			int (*show)(struct seq_file *, void *);
			size_t size;
		} sz;
	} u;
	ssize_t (*write)(struct file *file, const char __user *buffer, size_t count, loff_t *pos, void *data);
};

static int pass_log_shm(struct seq_file *m, void *v, struct net_device *dev, char *hdl_name)
{
	wfo_cfg80211_t *cfg = NULL;

	cfg = get_cfg_addr(dev, RUN_REMOTELY, WFO_CMD(proc_file));
	if (cfg==NULL)
		return -ENOMEM;

	snprintf(cfg->proc_file.str,
		strlen(dev->name)+strlen(hdl_name)+2,
		"%s %s", dev->name, hdl_name);
	seq_file_ptr = m;
	wfo_virt_cmd_sender_proc_file(cfg);

	return 0;
}

extern const struct rtw_proc_hdl adapter_proc_hdls[];
extern const int adapter_proc_hdls_num;

extern const struct rtw_proc_hdl odm_proc_hdls[];
extern const int odm_proc_hdls_num;

inline struct proc_dir_entry *rtw_proc_create_dir(const char *name, struct proc_dir_entry *parent, void *data)
{
	struct proc_dir_entry *entry;

#if (LINUX_VERSION_CODE >= KERNEL_VERSION(3, 10, 0))
	entry = proc_mkdir_data(name, (u16)S_IRUGO | (u16)S_IXUGO, parent, data);
#else
	/* entry = proc_mkdir_mode(name, (u16)S_IRUGO | (u16)S_IXUGO, parent); */
	entry = proc_mkdir(name, parent);
	if (entry)
		entry->data = data;
#endif

	return entry;
}

inline struct proc_dir_entry *rtw_proc_create_entry(const char *name, struct proc_dir_entry *parent,
	const struct rtw_proc_ops *fops, void * data)
{
	struct proc_dir_entry *entry;

#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 26))
	entry = proc_create_data(name,  (u16)S_IFREG | (u16)S_IRUGO | (u16)S_IWUGO, parent, fops, data);
#else
	entry = create_proc_entry(name, (u16)S_IFREG | (u16)S_IRUGO | (u16)S_IWUGO, parent);
	if (entry) {
		entry->data = data;
		entry->proc_fops = fops;
	}
#endif

	return entry;
}

#ifdef CONFIG_MCC_MODE
const struct rtw_virt_proc_hdl mcc_proc_hdls[] = {
	rtw_virt_proc_hdl("mcc_info"),
	rtw_virt_proc_hdl("mcc_enable"),
	rtw_virt_proc_hdl("mcc_duration"),
	#ifdef CONFIG_MCC_PHYDM_OFFLOAD
	rtw_virt_proc_hdl("mcc_phydm_offload"),
	#endif
	rtw_virt_proc_hdl("mcc_single_tx_criteria"),
	rtw_virt_proc_hdl("mcc_ap_bw20_target_tp"),
	rtw_virt_proc_hdl("mcc_ap_bw40_target_tp"),
	rtw_virt_proc_hdl("mcc_ap_bw80_target_tp"),
	rtw_virt_proc_hdl("mcc_sta_bw20_target_tp"),
	rtw_virt_proc_hdl("mcc_sta_bw40_target_tp"),
	rtw_virt_proc_hdl("mcc_sta_bw80_target_tp"),
	rtw_virt_proc_hdl("mcc_policy_table"),
};

const int mcc_proc_hdls_num = sizeof(mcc_proc_hdls) / sizeof(struct rtw_virt_proc_hdl);

static int pass_mcc_log_shm(struct seq_file *m, void *v)
{
	struct inode *inode = (struct inode *)m->private;
	ssize_t index = (ssize_t)PDE_DATA(inode);
	const struct rtw_virt_proc_hdl *hdl = (struct rtw_virt_proc_hdl *)(mcc_proc_hdls + index);
	struct net_device *dev = (struct net_device *)proc_get_parent_data(inode);

	return pass_log_shm(m, v, dev, hdl->name);
}

static int rtw_virt_mcc_proc_open(struct inode *inode, struct file *file)
{
	int (*show)(struct seq_file *, void *) = pass_mcc_log_shm;

	return single_open_size(file, show, inode, (u32)MAX_PROC_LOG_LEN);
}

static ssize_t rtw_virt_mcc_proc_write(struct file *file, const char __user *buffer, size_t count, loff_t *pos)
{
	ssize_t index = (ssize_t)PDE_DATA(file_inode(file));
	const struct rtw_virt_proc_hdl *hdl = (struct rtw_virt_proc_hdl *)(mcc_proc_hdls + index);
	struct net_device *dev = proc_get_parent_data(file_inode(file));
	wfo_cfg80211_t *cfg = NULL;
	char tmp[100] = {0};

	if (!(mcc_proc_hdls + index)->write) {
		return -EROFS;
	}

	if (buffer && !copy_from_user(tmp, buffer, count)) {
		cfg = get_cfg_addr(dev, RUN_REMOTELY, WFO_CMD(proc_file));
		if (cfg == NULL)
			return -EFAULT;
		sprintf(cfg->proc_file.str, "%s %s %s", dev->name, hdl->name, tmp);

		wfo_virt_cmd_sender_proc_file(cfg);

	}
	else
		return -EFAULT;

	return count;
}

static const struct rtw_proc_ops rtw_virt_mcc_proc_fops = {
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(5, 6, 0))
	.proc_open = rtw_virt_mcc_proc_open,
	.proc_read = seq_read,
	.proc_lseek = seq_lseek,
	.proc_release = single_release,
	.proc_write = rtw_virt_mcc_proc_write,
#else
	.owner = THIS_MODULE,
	.open = rtw_virt_mcc_proc_open,
	.read = seq_read,
	.llseek = seq_lseek,
	.release = single_release,
	.write = rtw_virt_mcc_proc_write,
#endif
};

struct proc_dir_entry *rtw_virt_mcc_proc_init(struct net_device *dev)
{
	struct proc_dir_entry *dir_mcc = NULL;
	struct proc_dir_entry *entry = NULL;
	struct wfo_ndev_priv *ndev_priv = (struct wfo_ndev_priv *)netdev_priv(dev);
	ssize_t i;

	dir_mcc = rtw_proc_create_dir("mcc", ndev_priv->dir_dev, dev);
	if (dir_mcc == NULL) {
		goto exit;
	}

	ndev_priv->dir_mcc = dir_mcc;

	for (i = 0; i < mcc_proc_hdls_num; i++) {
		entry = rtw_proc_create_entry(mcc_proc_hdls[i].name, dir_mcc, &rtw_virt_mcc_proc_fops, (void *)i);

		if (!entry) {
			goto exit;
		}
	}

exit:
	return dir_mcc;
}

void rtw_virt_mcc_proc_deinit(struct wfo_ndev_priv *ndev_priv)
{
	struct proc_dir_entry *dir_mcc = NULL;
	int i;

	dir_mcc = ndev_priv->dir_mcc;

	if (dir_mcc == NULL) {
		return;
	}

	for (i = 0; i < mcc_proc_hdls_num; i++)
		remove_proc_entry(mcc_proc_hdls[i].name, dir_mcc);

	remove_proc_entry("mcc", ndev_priv->dir_dev);

	ndev_priv->dir_mcc = NULL;
}
#endif

static int pass_odm_log_shm(struct seq_file *m, void *v)
{
	struct inode *inode = (struct inode *)m->private;
	ssize_t index = (ssize_t)PDE_DATA(inode);
	const struct rtw_virt_proc_hdl *hdl = (struct rtw_virt_proc_hdl *)(odm_proc_hdls + index);
	struct net_device *dev = (struct net_device *)proc_get_parent_data(inode);

	return pass_log_shm(m, v, dev, hdl->name);
}

static int rtw_virt_odm_proc_open(struct inode *inode, struct file *file)
{
	int (*show)(struct seq_file *, void *) = pass_odm_log_shm;

	return single_open_size(file, show, inode, (u32)MAX_PROC_LOG_LEN);
}

static ssize_t rtw_virt_odm_proc_write(struct file *file, const char __user *buffer, size_t count, loff_t *pos)
{
	ssize_t index = (ssize_t)PDE_DATA(file_inode(file));
	const struct rtw_virt_proc_hdl *hdl = (struct rtw_virt_proc_hdl *)(odm_proc_hdls + index);
	struct net_device *dev = proc_get_parent_data(file_inode(file));
	wfo_cfg80211_t *cfg = NULL;
	char tmp[100] = {0};

	if (count >= sizeof(tmp)) {
		return -EFAULT;
	}

	if (!(odm_proc_hdls + index)->write) {
		return -EROFS;
	}

	if (buffer && !copy_from_user(tmp, buffer, count)) {
		cfg = get_cfg_addr(dev, RUN_REMOTELY, WFO_CMD(proc_file));
		if (cfg == NULL)
			return -EFAULT;
		sprintf(cfg->proc_file.str, "%s %s %s", dev->name, hdl->name, tmp);

		wfo_virt_cmd_sender_proc_file(cfg);

	}
	else
		return -EFAULT;

	return (ssize_t)count;
}

static const struct rtw_proc_ops rtw_virt_odm_proc_fops = {
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(5, 6, 0))
	.proc_open = rtw_virt_odm_proc_open,
	.proc_read = seq_read,
	.proc_lseek = seq_lseek,
	.proc_release = single_release,
	.proc_write = rtw_virt_odm_proc_write,
#else
	.owner = THIS_MODULE,
	.open = rtw_virt_odm_proc_open,
	.read = seq_read,
	.llseek = seq_lseek,
	.release = single_release,
	.write = rtw_virt_odm_proc_write,
#endif
};

struct proc_dir_entry *rtw_virt_odm_proc_init(struct net_device *dev)
{
	struct proc_dir_entry *dir_odm = NULL;
	struct proc_dir_entry *entry = NULL;
	struct wfo_ndev_priv *ndev_priv = (struct wfo_ndev_priv *)netdev_priv(dev);
	ssize_t i;

	dir_odm = rtw_proc_create_dir("odm", ndev_priv->dir_dev, dev);
	if (dir_odm == NULL) {
		goto exit;
	}

	ndev_priv->dir_odm = dir_odm;

	for (i = 0; i < odm_proc_hdls_num; i++) {
		entry = rtw_proc_create_entry(odm_proc_hdls[i].name, dir_odm, &rtw_virt_odm_proc_fops, (void *)i);

		if (!entry) {
			goto exit;
		}
	}

exit:
	return dir_odm;
}

void rtw_virt_odm_proc_deinit(struct wfo_ndev_priv *ndev_priv)
{
	struct proc_dir_entry *dir_odm = NULL;
	int i;

	dir_odm = ndev_priv->dir_odm;

	if (dir_odm == NULL) {
		return;
	}

	for (i = 0; i < odm_proc_hdls_num; i++)
		remove_proc_entry(odm_proc_hdls[i].name, dir_odm);

	remove_proc_entry("odm", ndev_priv->dir_dev);

	ndev_priv->dir_odm = NULL;

	/*if (phydm_msg) {
		rtw_mfree(phydm_msg, PHYDM_MSG_LEN);
		phydm_msg = NULL;
	}*/
}

static int pass_virt_log_shm(struct seq_file *m, void *v)
{
	struct inode *inode = (struct inode *)m->private;
	ssize_t index = (ssize_t)PDE_DATA(inode);
	const struct rtw_virt_proc_hdl *hdl = (struct rtw_virt_proc_hdl *)(adapter_proc_hdls + index);
	struct net_device *dev = (struct net_device *)proc_get_parent_data(inode);

	return pass_log_shm(m, v, dev, hdl->name);
}

static int rtw_virt_proc_open(struct inode *inode, struct file *file)
{
	int (*show)(struct seq_file *, void *) = pass_virt_log_shm;

	return single_open_size(file, show, inode, (u32)MAX_PROC_LOG_LEN);
}

static ssize_t rtw_virt_proc_write(struct file *file, const char __user *buffer, size_t count, loff_t *pos)
{
	ssize_t index = (ssize_t)PDE_DATA(file_inode(file));
	const struct rtw_virt_proc_hdl *hdl = (struct rtw_virt_proc_hdl *)(adapter_proc_hdls + index);
	struct net_device *dev = proc_get_parent_data(file_inode(file));
	wfo_cfg80211_t *cfg = NULL;
	char tmp[100] = {0};

	if (count >= sizeof(tmp)) {
		return -EFAULT;
	}

	if (!(adapter_proc_hdls + index)->write) {
		return -EROFS;
	}

	if (buffer && !copy_from_user(tmp, buffer, count)) {
		cfg = get_cfg_addr(dev, RUN_REMOTELY, WFO_CMD(proc_file));
		if (cfg == NULL)
			return -EFAULT;
		sprintf(cfg->proc_file.str, "%s %s %s", dev->name, hdl->name, tmp);

		wfo_virt_cmd_sender_proc_file(cfg);

	}
	else
		return -EFAULT;

	return (ssize_t)count;
}

static const struct rtw_proc_ops rtw_virt_proc_fops = {
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(5, 6, 0))
	.proc_open = rtw_virt_proc_open,
	.proc_read = seq_read,
	.proc_lseek = seq_lseek,
	.proc_release = single_release,
	.proc_write = rtw_virt_proc_write,
#else
	.owner = THIS_MODULE,
	.open = rtw_virt_proc_open,
	.read = seq_read,
	.llseek = seq_lseek,
	.release = single_release,
	.write = rtw_virt_proc_write,
#endif
};

extern struct proc_dir_entry *get_rtw_drv_proc(void);
struct proc_dir_entry *rtw_virt_adapter_proc_init(struct net_device *dev)
{
	struct proc_dir_entry *drv_proc = get_rtw_drv_proc();
	struct proc_dir_entry *dir_dev = NULL;
	struct proc_dir_entry *entry = NULL;
	struct wfo_ndev_priv *ndev_priv = (struct wfo_ndev_priv *)netdev_priv(dev);
	ssize_t i;

	if (ndev_priv->dir_dev) {
		dir_dev = ndev_priv->dir_dev;
		goto exit;
	}

	dir_dev = rtw_proc_create_dir(dev->name, drv_proc, dev);
	if (dir_dev == NULL) {
		goto exit;
	}

	ndev_priv->dir_dev = dir_dev;

	for (i = 0; i < adapter_proc_hdls_num; i++) {
		entry = rtw_proc_create_entry(adapter_proc_hdls[i].name, dir_dev, &rtw_virt_proc_fops, (void *)i);

		if (!entry) {
			goto exit;
		}
	}

	rtw_virt_odm_proc_init(dev);

#ifdef CONFIG_MCC_MODE
	rtw_virt_mcc_proc_init(dev);
#endif /* CONFIG_MCC_MODE */

exit:
	return dir_dev;
}

void rtw_virt_adapter_proc_deinit(struct net_device *dev)
{
	struct proc_dir_entry *drv_proc = get_rtw_drv_proc();
	struct proc_dir_entry *dir_dev = NULL;
	struct wfo_ndev_priv *ndev_priv = (struct wfo_ndev_priv *)netdev_priv(dev);
	int i;

	dir_dev = ndev_priv->dir_dev;

	if (dir_dev == NULL) {
		return;
	}

	for (i = 0; i < adapter_proc_hdls_num; i++)
		remove_proc_entry(adapter_proc_hdls[i].name, dir_dev);

	rtw_virt_odm_proc_deinit(ndev_priv);

#ifdef CONFIG_MCC_MODE
	rtw_virt_mcc_proc_deinit(ndev_priv);
#endif /* CONFIG_MCC_MODE */

	remove_proc_entry(dev->name, drv_proc);

	ndev_priv->dir_dev = NULL;
}
#else
inline struct proc_dir_entry *rtw_proc_create_dir(const char *name, struct proc_dir_entry *parent, void *data)
{
	struct proc_dir_entry *entry;

#if (LINUX_VERSION_CODE >= KERNEL_VERSION(3, 10, 0))
	entry = proc_mkdir_data(name, S_IRUGO | S_IXUGO, parent, data);
#else
	/* entry = proc_mkdir_mode(name, S_IRUGO|S_IXUGO, parent); */
	entry = proc_mkdir(name, parent);
	if (entry)
		entry->data = data;
#endif

	return entry;
}

extern struct proc_dir_entry *get_rtw_drv_proc(void);
struct proc_dir_entry *rtw_virt_adapter_proc_init(struct net_device *dev)
{
	struct proc_dir_entry *drv_proc = get_rtw_drv_proc();
	struct proc_dir_entry *dir_dev = NULL;
	struct proc_dir_entry *entry = NULL;
	struct wfo_ndev_priv *ndev_priv = (struct wfo_ndev_priv *)netdev_priv(dev);
	ssize_t i;

	if (ndev_priv->dir_dev) {
		dir_dev = ndev_priv->dir_dev;
		goto exit;
	}

	dir_dev = rtw_proc_create_dir(dev->name, drv_proc, dev);
	if (dir_dev == NULL) {
		goto exit;
	}

exit:
	return dir_dev;
}
#endif /* !CPTCFG_WFO_VIRT_SAME_CPU */
