#ifndef __WFO_VIRT_EXT_H__
#define __WFO_VIRT_EXT_H__

//------------------------------------------------------------------------------
#define WFO_SHRINK_CFG_SIZE	0

//------------------------------------------------------------------------------
#define MD_SZ (32*1024)
#define MAX_IOCTL_DATA_SIZE (MD_SZ)

#define MIB_BUF_SIZE (32*1024)

//------------------------------------------------------------------------------
#include <net/cfg80211.h>

#if (LINUX_VERSION_CODE >= KERNEL_VERSION(5, 8, 0))
#ifndef WFO_K510
#define WFO_K510
#endif /* WFO_K510 */
enum {
	SCAN_NO_6GHZ = 0,
	SCAN_6GHZ = 1,
	SCAN_PART_6GHZ = 2,
};
#endif /* (LINUX_VERSION_CODE >= KERNEL_VERSION(5, 8, 0)) */

#define IEEE80211_MAX_DATA_LEN 2304 /* copy from linux/ieee80211.h */

struct __wfo_cfg80211_beacon_data {
	struct cfg80211_beacon_data source;

	u8 head[IEEE80211_MAX_DATA_LEN];
	u8 tail[IEEE80211_MAX_DATA_LEN];
	u8 beacon_ies[IEEE80211_MAX_DATA_LEN];
	u8 proberesp_ies[IEEE80211_MAX_DATA_LEN];
	u8 assocresp_ies[IEEE80211_MAX_DATA_LEN];
	u8 probe_resp[IEEE80211_MAX_DATA_LEN];
	u8 lci[U8_MAX+1];
	u8 civicloc[U8_MAX+1];
};

struct wfo_sta_st_s
{
	u64 rx_pkts;
	u64 rx_bytes;
	u64 tx_pkts;
	u64 tx_bytes;

	u8 mac_addr[ETH_ALEN];
}  __attribute__((packed));

#ifndef RTW_SSID_SCAN_AMOUNT
#define RTW_SSID_SCAN_AMOUNT 9 /* for WEXT_CSCAN_AMOUNT 9 */
#endif
#ifndef RTW_CHANNEL_SCAN_AMOUNT
#define RTW_CHANNEL_SCAN_AMOUNT (14+37)
#endif
#ifndef NUM_ACL
#define NUM_ACL 100 /* refer g6_wifi_driver/include/sta_info.h*/
#endif

struct __wfo_cfg80211_scan_request {
	struct cfg80211_scan_request source;

	/* keep last */
	struct ieee80211_channel *channels[RTW_CHANNEL_SCAN_AMOUNT];
	struct cfg80211_ssid ssids[RTW_SSID_SCAN_AMOUNT];
	u8 ie[IEEE80211_MAX_DATA_LEN];

	/* for copy channel data */
	struct ieee80211_channel channels_data[RTW_CHANNEL_SCAN_AMOUNT];

#ifdef WFO_K510
	struct cfg80211_scan_6ghz_params scan_6ghz_params[RTW_CHANNEL_SCAN_AMOUNT];
#endif /* WFO_K510 */
};

//------------------------------------------------------------------------------
struct __wfo_mib {
	char sz[MIB_BUF_SIZE];
};

struct start_ap_extra_param {
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(5, 8, 0))
	u8 fils_discovery[IEEE80211_MAX_DATA_LEN];
	u8 unsol_bcast_probe_resp[IEEE80211_MAX_DATA_LEN];
#endif
#if (WFO_SHRINK_CFG_SIZE==1)
	struct __wfo_cfg80211_beacon_data beacon;
#endif /* WFO_SHRINK_CFG_SIZE */
};

struct ndo_do_ioctl_extra_param {
	u8 ioctl_data[MAX_IOCTL_DATA_SIZE];
};

struct open_file_extra_param {
	char sz[MD_SZ];
};

#ifdef CONFIG_RTW_CLIENT_MODE_SUPPORT
#define CONFIG_CLIENT_NUMBER		(2)
#else
#define CONFIG_CLIENT_NUMBER		(1)
#endif
	/* copy from g6_wifi_driver/platform/mips_98d/rtw_pltfm_postconf.h */

//refer g6_wifi_driver/include/drv_conf.h
#define CONFIG_CSA_IE
#ifdef CONFIG_CSA_IE
#define CONFIG_ECSA_IE
#endif

#ifndef CONFIG_LIMITED_STA_NUM
#define MACID_NUM_SW_LIMIT 64
#else
#define MACID_NUM_SW_LIMIT (CONFIG_LIMITED_STA_NUM+CONFIG_LIMITED_AP_NUM+1)
#endif
	/* copy from g6_wifi_driver/include/drv_conf.h */

#define NUM_STA MACID_NUM_SW_LIMIT
	/*copy from g6_wifi_driver/include/sta_info.h */

#define WFO_MAC_ALEN	6	//MAC_ALEN
#define WFO_IFACE_NUM	(CONFIG_LIMITED_AP_NUM + CONFIG_CLIENT_NUMBER - 1)
#define WFO_STA_NUM		(NUM_STA)

struct sync_sta_status_extra_param {
	struct wfo_sta_st_s sta_st[WFO_IFACE_NUM][WFO_STA_NUM];
};

#if (WFO_SHRINK_CFG_SIZE==1)
struct scan_extra_param {
	struct __wfo_cfg80211_scan_request data;
};

struct change_beacon_extra_param {
	struct __wfo_cfg80211_beacon_data beacon;
};
#endif /* WFO_SHRINK_CFG_SIZE */

struct wfo_cfg80211_extra_param {
	union {
		struct start_ap_extra_param start_ap;
		struct ndo_do_ioctl_extra_param ndo_do_ioctl;
		struct open_file_extra_param open_file;
		struct sync_sta_status_extra_param sync_sta_status;

	#if (WFO_SHRINK_CFG_SIZE==1)
		struct scan_extra_param scan;
		struct change_beacon_extra_param change_beacon;
	#endif /* WFO_SHRINK_CFG_SIZE */
	};
};

//------------------------------------------------------------------------------
struct middleware {
	struct wfo_cfg80211_extra_param cfg;
	struct net_device_stats	dev_st[WFO_IFACE_NUM];
	unsigned char ptr[0] __attribute((aligned(SMP_CACHE_BYTES)));
	struct __wfo_mib mib[WFO_IFACE_NUM];
};

#endif /* __WFO_VIRT_EXT_H__ */
