#ifndef	__WFO_VIRT_H__
#define	__WFO_VIRT_H__

//==============================================================================
#if !defined(CPTCFG_BACKPORTED_WIRELESS)
#define IFF_DOMAIN_WLAN RTK_IFF_DOMAIN_WLAN
#endif /* !CPTCFG_BACKPORTED_WIRELESS */

//==============================================================================
#include <linux/proc_fs.h>
#include <linux/nl80211.h>
#include <net/cfg80211.h>
#include <net/rtnetlink.h>
#include <uapi/linux/wireless.h>

//==============================================================================
//  radio config
//==============================================================================
#define CONFIG_RTW_MACADDR_ACL 1
#define CONFIG_AP_MODE
//#define CONFIG_P2P
#define CONFIG_IEEE80211_BAND_5GHZ 1
#define CONFIG_80211AX_HE
#define CONFIG_80211N_HT
#define CONFIG_80211AC_VHT
#define CONFIG_IEEE80211W
//#define CONFIG_IFACE_NUMBER 1

#ifndef CONFIG_RTW_80211K
#define CONFIG_RTW_80211K
#endif
#define CONFIG_RTW_WNM
#define CONFIG_APPEND_VENDOR_IE_ENABLE
#define RTW_PHL_TX
#define RTW_PHL_RX
#ifndef CONFIG_PHL_TEST_SUITE
#define CONFIG_PHL_TEST_SUITE
#endif
#define CONFIG_RTW_AP_EXT_SUPPORT
#define CONFIG_RTW_ACS
#define CONFIG_RTW_DACS
#define CONFIG_SCAN_BACKOP
#define CONFIG_PCI_HCI
#define CONFIG_RTW_2G_40M_COEX
#define CONFIG_DFS_MASTER
#define CONFIG_DBG_AX_CAM
#define CONFIG_LAYER2_ROAMING
#define RTW_BUSY_DENY_SCAN
#define CONFIG_TX_AMSDU
#define CONFIG_TXPWR_LIMIT 1
#define CONFIG_DBG_COUNTER

#ifdef CONFIG_RTW_AP_EXT_SUPPORT /* copy from g6_wifi_driver/include/rtw_ioctl_ap.h */
#define BEACON_VS_IE
#define MACADDRLEN		6

#define DRV_VERSION_H	2
#define DRV_VERSION_L	6
#define DRV_VERSION_SUBL	35
#endif /* CONFIG_RTW_AP_EXT_SUPPORT */

#define CONFIG_RTW_SUPPORT_MBSSID_VAP
#define CONFIG_RTW_HOSTAPD_ACS

#if defined(CPTCFG_BACKPORTED_WIRELESS)
#include <backport/autoconf.h> /* CONFIG_RTW_REPEATER_MODE_SUPPORT */
#endif

#if defined(CONFIG_RTW_SUPPORT_MBSSID_VAP)
#include <platform/mips_98d/rtw_pltfm_preconf.h>
#include <platform/mips_98d/rtw_pltfm_postconf.h>
#else /* !CONFIG_RTW_SUPPORT_MBSSID_VAP */
#define CONFIG_LIMITED_AP_NUM (1)
#endif /* CONFIG_RTW_SUPPORT_MBSSID_VAP */

#define WKARD_98D

#define FUNC_NDEV_FMT "%s(%s)"
#define FUNC_NDEV_ARG(ndev) __func__, ndev->name

#define rtw_zmalloc(sz, mode) kzalloc(sz, mode)
#define _rtw_memcpy(dst, src, sz) memcpy(dst, src, sz)

#if defined(CONFIG_WIRELESS_EXT)
#include <net/iw_handler.h>
#endif /* CONFIG_WIRELESS_EXT */


//==============================================================================
//  module parameter
//==============================================================================
#define MODULE_NAME 	"wfo_virt"
#define DRV_VERSION 	"0.1.0"


//==============================================================================
//  wfo virt priv data
//==============================================================================
struct wfo_wiphy_data {
	struct wiphy *wiphy;
	struct net_device *ndev;

	unsigned char band;
	unsigned char idx;
	unsigned char dev_name[IFNAMSIZ];
	unsigned char mac_addr[ETH_ALEN];
};
#if 0
struct wfo_ndev_priv {
	struct net_device *ndev;
	struct wireless_dev wdev;
	wfo_cfg80211_t cfg;
	struct cfg80211_scan_request *scan_req;

	unsigned char iface_id;

	unsigned char radio_name[IFNAMSIZ];
};
#endif
#if 0
typedef struct wfo_virt_dev_config_s
{
	unsigned char ifname[IFNAMSIZ];
	char is_root;
	char create_proc;
	struct net_device *dev;
	unsigned char dev_addr[MAX_ADDR_LEN];
	struct proc_dir_entry *proc_dir;
	unsigned int ipaddr;
	char iface_idx;
} wfo_virt_dev_config_t;
#endif
//----------------------------------------------------------------------------
#if 0
typedef struct proc_priv_s
{
	struct net_device *dev;
	char *cmd;
} proc_priv_t;

typedef struct wfo_virt_proc_table_s
{
	char *cmd;
	char root_only;
	struct file_operations fops;
	struct proc_dir_entry *entry;
	proc_priv_t priv;
} wfo_virt_proc_table_t;
#endif
//----------------------------------------------------------------------------

#if defined(WFO_RADIO_RECEIVER)
extern struct seq_file *seq_file_ptr;
#endif /* WFO_RADIO_RECEIVER */

struct net_device *wfo_virt_iface_alloc_etherdev(void);
int wfo_virt_iface_register_netdev(struct net_device *ndev,
		struct wiphy *wiphy,
		enum nl80211_iftype type,
		unsigned int vap_idx);
void wfo_virt_iface_unregister_netdev(struct net_device *ndev);

#if defined(WFO_RADIO_SENDER)
void init_wfo_radio_cmd_sender_sync_type(void);
#endif

#if defined(WFO_VIRT_SENDER)
void init_wfo_virt_cmd_sender_sync_type(void);
unsigned char *rtl8198d_wfo_wlandevname(unsigned int vap_idx);
unsigned int rtl8198d_wfo_wlandev_idx(unsigned char *name, unsigned int *vap_idx);
#endif

#endif /* __WFO_VIRT_H__ */
