#ifdef CONFIG_WNIC_RECYCLED_SKB

#include "recycle_conf.h"
#include "recycle_skb.h"

#ifdef PROC_FNAME
#undef PROC_FNAME
#endif
#define PROC_FNAME		"wnic_recycle_skb"
#define WNIC_POOL_NUM 		(1 << WNIC_POOL_NUM_SHIFT_BITS)

#if defined(WNIC_RING_BUFFER_RECYCLE_SKB)
static __cacheline_aligned_in_smp struct wnic_ring_buffer_recycle_t wrbr[WNIC_POOL_NUM];
#endif
#if defined(WNIC_DOUBLE_LINK_LIST_RECYCLE_SKB) || defined(WNIC_SINGLE_LINK_LIST_RECYCLE_SKB)
static __cacheline_aligned_in_smp struct sk_buff_head wnic_recycle_skb_queue[WNIC_POOL_NUM];
#endif
#if defined(WNIC_STRAIGHT_ARRAY_RECYCLE_SKB)
static __cacheline_aligned_in_smp struct wnic_straight_recycle_t wsra[WNIC_POOL_NUM];
#endif
#if defined(WNIC_LL_LINK_LIST_RECYCLE_SKB)
static __cacheline_aligned_in_smp spinlock_t wnic_llll_read_lock[WNIC_POOL_NUM];
static __cacheline_aligned_in_smp struct llist_head wnic_llll_skb_head[WNIC_POOL_NUM];
static __cacheline_aligned_in_smp atomic_t wnic_llll_num[WNIC_POOL_NUM];
static __cacheline_aligned_in_smp atomic_t wnic_llll_nomem[WNIC_POOL_NUM];
#endif

static unsigned int wnic_skb_total_num[WNIC_POOL_NUM] = {0};
static unsigned int wnic_skb_free_num[WNIC_POOL_NUM] = {0};
static unsigned int wnic_skb_max_size[WNIC_POOL_NUM] = {0};
//static unsigned int wnic_switch_off_recycle_skb[WNIC_POOL_NUM]={WNIC_RECYCLE_SWITCH_ON};
static unsigned int wnic_pool[WNIC_POOL_NUM] = {0};

#if defined(WNIC_RING_BUFFER_RECYCLE_SKB)
unsigned int wnic_free_eth_skb_num(void)
{
	if(wrbr.state==RTL_RING_BUF_RECYCLE_FULL)return wrbr.ring_size_mask+1;
	else if(wrbr.state==RTL_RING_BUF_RECYCLE_EMPTY)return 0;
	else{
		if(wrbr.wr_idx>wrbr.rd_idx)return wrbr.wr_idx-wrbr.rd_idx;
		else return wrbr.ring_size_mask+1-wrbr.rd_idx+wrbr.wr_idx;
	}
}

unsigned int wnic_alloc_eth_skb_num()
{
	if(wrbr.state==RTL_RING_BUF_RECYCLE_FULL)return 0;
	else if(wrbr.state==RTL_RING_BUF_RECYCLE_EMPTY)return wrbr.ring_size_mask+1;
	else{
		if(wrbr.wr_idx>wrbr.rd_idx)return wrbr.ring_size_mask+1-wrbr.wr_idx+wrbr.rd_idx;
		else return wrbr.rd_idx-wrbr.wr_idx;
	}
}

__always_inline
void wnic_skb_queue_head(struct sk_buff *newsk)
{
	WNIC_RECYCLE_SPINLOCK(&wrbr.lock);
	//printk("[ENQ]wrbr.wr_idx=%d, rd_idx=%d, state=%d\n",wrbr.wr_idx,wrbr.rd_idx,wrbr.state);
	if(likely(wrbr.state!=RTL_RING_BUF_RECYCLE_FULL)){
		wrbr.ring_buffer_recycle_array[wrbr.wr_idx]=newsk;
		wrbr.wr_idx = (wrbr.wr_idx+1)&wrbr.ring_size_mask;		
		smp_mb();
		if(unlikely(wrbr.wr_idx==wrbr.rd_idx))wrbr.state=RTL_RING_BUF_RECYCLE_FULL;
		else wrbr.state=RTL_RING_BUF_RECYCLE_NORMAL;
		//printk("update wr_idx to %d!! state become to %d\n",wrbr.wr_idx,wrbr.state);
	}else{
		printk("abnormal!! free the skb as dynamically one..\n");
		newsk->recyclable=0;
		dev_kfree_skb_any(newsk);
	}
	WNIC_RECYCLE_SPINUNLOCK(&wrbr.lock);
}

__always_inline
struct sk_buff *wnic_skb_dequeue(void)
{
	struct sk_buff *skb=NULL;
	WNIC_RECYCLE_SPINLOCK(&wrbr.lock);
	//printk("[DEQ]wrbr.wr_idx=%d, rd_idx=%d, state=%d\n",wrbr.wr_idx,wrbr.rd_idx,wrbr.state);
	if(likely(wrbr.state!=RTL_RING_BUF_RECYCLE_EMPTY)){
		skb=wrbr.ring_buffer_recycle_array[wrbr.rd_idx];
		wrbr.rd_idx = (wrbr.rd_idx+1)&wrbr.ring_size_mask;
		smp_mb();
		if(unlikely(wrbr.wr_idx==wrbr.rd_idx))wrbr.state=RTL_RING_BUF_RECYCLE_EMPTY;
		else wrbr.state=RTL_RING_BUF_RECYCLE_NORMAL;
		//printk("update rd_idx to %d!! state become to %d\n",wrbr.rd_idx,wrbr.state);
	}
	WNIC_RECYCLE_SPINUNLOCK(&wrbr.lock);
	return skb;
}
#endif
#if defined(WNIC_DOUBLE_LINK_LIST_RECYCLE_SKB)
unsigned int wnic_free_eth_skb_num(void)
{
	return wnic_recycle_skb_queue.qlen;
}

unsigned int wnic_alloc_eth_skb_num(void)
{
	return wnic_skb_free_num - wnic_recycle_skb_queue.qlen;
}

__always_inline
void wnic_skb_queue_head(struct sk_buff *newsk)
{
	WNIC_RECYCLE_SPINLOCK(&wnic_recycle_skb_queue.lock);
	__skb_queue_head(&wnic_recycle_skb_queue, newsk);
	WNIC_RECYCLE_SPINUNLOCK(&wnic_recycle_skb_queue.lock);
}

__always_inline
struct sk_buff *wnic_skb_dequeue(void)
{
	struct sk_buff *skb=NULL;
	WNIC_RECYCLE_SPINLOCK(&wnic_recycle_skb_queue.lock);
	skb=__skb_dequeue(&wnic_recycle_skb_queue);
	WNIC_RECYCLE_SPINUNLOCK(&wnic_recycle_skb_queue.lock);
	return skb;
}
#endif
#if defined(WNIC_SINGLE_LINK_LIST_RECYCLE_SKB)
unsigned int wnic_free_eth_skb_num(void)
{
	return wnic_recycle_skb_queue.qlen;
}

unsigned int wnic_alloc_eth_skb_num(void)
{
	return wnic_skb_free_num - wnic_recycle_skb_queue.qlen;
}

__always_inline
void wnic_skb_queue_head(struct sk_buff *newsk)
{
	WNIC_RECYCLE_SPINLOCK(&wnic_recycle_skb_queue.lock);
	newsk->next = wnic_recycle_skb_queue.next;
	newsk->prev = (struct sk_buff *)&wnic_recycle_skb_queue;
	wnic_recycle_skb_queue.next = newsk;
	wnic_recycle_skb_queue.qlen++;
	WNIC_RECYCLE_SPINUNLOCK(&wnic_recycle_skb_queue.lock);
}

__always_inline
void __recycle_skb_peek(struct sk_buff *skb, struct sk_buff_head *list)
{
	struct sk_buff *next,*prev;
	list->qlen--;
	next=skb->next;
	prev=skb->prev;
	next->prev=prev;
	prev->next=next;
}

__always_inline
struct sk_buff *wnic_skb_dequeue(void)
{
	struct sk_buff *skb=NULL;
	WNIC_RECYCLE_SPINLOCK(&wnic_recycle_skb_queue.lock);
	skb = wnic_recycle_skb_queue.next;
	if(likely(skb!=(struct sk_buff *)&wnic_recycle_skb_queue))
		__recycle_skb_peek(skb, &wnic_recycle_skb_queue);
	else
		skb = NULL;
	WNIC_RECYCLE_SPINUNLOCK(&wnic_recycle_skb_queue.lock);
	return skb;
}
#endif
#if defined(WNIC_STRAIGHT_ARRAY_RECYCLE_SKB)
unsigned int wnic_free_eth_skb_num(void)
{
	return wsra.idx;
}

unsigned int wnic_alloc_eth_skb_num(void)
{
	return wnic_skb_free_num - wsra.idx;
}

__always_inline
void wnic_skb_queue_head(struct sk_buff *newsk)
{
	WNIC_RECYCLE_SPINLOCK(&wsra.lock);
	wsra.array[wsra.idx]=newsk;
	wsra.idx++;
	WNIC_RECYCLE_SPINUNLOCK(&wsra.lock);
}

__always_inline
struct sk_buff *wnic_skb_dequeue(void)
{
	struct sk_buff *skb=NULL;
	WNIC_RECYCLE_SPINLOCK(&wsra.lock);
	if(likely(wsra.idx)){
		wsra.idx--;
		skb=wsra.array[wsra.idx];
	}
	WNIC_RECYCLE_SPINUNLOCK(&wsra.lock);
	return skb;
}
#endif
#if defined(WNIC_LL_LINK_LIST_RECYCLE_SKB)
unsigned int wnic_free_eth_skb_num(int pool)
{
	return atomic_read(&wnic_llll_num[pool]);
}

unsigned int wnic_alloc_eth_skb_num(int pool)
{
	return wnic_skb_free_num[pool] - atomic_read(&wnic_llll_num[pool]);
}

__always_inline
void wnic_skb_queue_head(struct sk_buff *newsk, int pool)
{
	llist_add(&newsk->recy_llnode, &wnic_llll_skb_head[pool]);
	atomic_inc(&wnic_llll_num[pool]);
}

__always_inline
struct sk_buff *wnic_skb_dequeue(int pool)
{
	struct llist_node *llll_node;
	struct sk_buff *skb;
	struct spinlock_t *l = &wnic_llll_read_lock[pool];

	WNIC_RECYCLE_SPINLOCK(l);
	llll_node = llist_del_first(&wnic_llll_skb_head[pool]);
	WNIC_RECYCLE_SPINUNLOCK(l);
	if (llll_node == NULL){
		atomic_inc(&wnic_llll_nomem[pool]);
		return NULL;
	}
	skb = llist_entry(llll_node, struct sk_buff, recy_llnode);
	atomic_dec(&wnic_llll_num[pool]);
	return skb;
}
#endif /* WNIC_LL_LINK_LIST_RECYCLE_SKB */


__always_inline
void __init_skb_recy_wnic(struct sk_buff *skb)
{
	skb->data = skb->head+WNIC_RESERVED_HEADER_SIZE;		//reserve header room
	skb_reset_tail_pointer(skb);

	//skb->prepared_recycle=0;

	//skb->mark=0;	//clear in case residual streamID cause disconnect
#ifdef CONFIG_RTK_SKB_MARK2
	//skb->mark2=0;	//clear in case residual streamID cause disconnect
#endif
}

#ifdef WNIC_RECYCLE_SKB_PROC
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
extern struct proc_dir_entry *realtek_proc;
struct proc_dir_entry *wnic_recycle_pe=NULL;

static int wnic_recycleskb_read(struct seq_file *seq, void *v)
{
	int i;
#if	defined(WNIC_RING_BUFFER_RECYCLE_SKB)
	seq_printf(seq, "\nWNIC Recycle SKB: ring-buffer");
#endif
#if	defined(WNIC_DOUBLE_LINK_LIST_RECYCLE_SKB)
	seq_printf(seq, "\nWNIC Recycle SKB: double-link-list");
#endif
#if	defined(WNIC_SINGLE_LINK_LIST_RECYCLE_SKB)
	seq_printf(seq, "\nWNIC Recycle SKB: single-link-list");
#endif
#if defined(WNIC_STRAIGHT_ARRAY_RECYCLE_SKB)
	seq_printf(seq, "\nWNIC Recycle SKB: straight-array");
#endif
#if defined(WNIC_LL_LINK_LIST_RECYCLE_SKB)
	seq_printf(seq, "\nWNIC Recycle SKB: lock_less-link-list");
#endif
	for (i = 1; i < WNIC_POOL_NUM; i++) {
		seq_printf(seq, "\npool[%d] = %u", i, wnic_pool[i]);
		seq_printf(seq, "\n\twnic_skb_total_num = %u wnic_skb_free_num = %u, wnic_skb_max_size = %u",
		           wnic_skb_total_num[i], wnic_skb_free_num[i], wnic_skb_max_size[i]);
		seq_printf(seq, "\n\trecycle_skb_free_num:\t\t%10d", wnic_free_eth_skb_num(i));
		seq_printf(seq, "\n\trecycle_skb_alloc_num:\t\t%10d", wnic_alloc_eth_skb_num(i));
		seq_printf(seq, "\n\trecycle_no_mem:      \t\t%10d\n",atomic_read(&wnic_llll_nomem[i]));atomic_set(&wnic_llll_nomem[i],0);
	}
	//seq_printf(seq, "\ntop_recycle_skb_alloc_num:\t\t%10d/%d", (wnic_skb_free_num-lowest_wnic_skb_free_num), wnic_skb_free_num);
	//lowest_wnic_skb_free_num=wnic_skb_free_num;
	seq_printf(seq, "\nUsage:\n");
	//seq_printf(seq, "echo on > /proc/realtek/wnic_recycle_skb\n - Switch on recycle skb mechanism.\n");
	//seq_printf(seq, "echo off > /proc/realtek/wnic_recycle_skb\n - Switch off recycle skb mechanism.\n");
#if defined(WNIC_DOUBLE_LINK_LIST_RECYCLE_SKB) \
	|| defined(WNIC_SINGLE_LINK_LIST_RECYCLE_SKB) \
	|| defined(WNIC_LL_LINK_LIST_RECYCLE_SKB)
	seq_printf(seq,
	           "echo inc <pool> <count> > /proc/realtek/wnic_recycle_skb\n"
	           " - Increase free skb number of pool, if new skb is available.\n\n");
	seq_printf(seq,
	           "echo dec <pool> <count> > /proc/realtek/wnic_recycle_skb\n"
	           " - Decrease free skb number of pool, if free skb enough.\n");
#endif
	return 0;
}

static int wnic_recycleskb_write(struct file *filp, const char *buf, size_t count, loff_t *offp)
{
	int i,operator=0,pool;
	unsigned int original_state;
	unsigned long operand=0,flags;
	char tmpbuf[64];
	char *strptr;
	char *tokptr;
	struct sk_buff *skb;

	//echo inc 0 100 > /proc/recycle_skb
	//echo dec 0 100 > /proc/recycle_skb
	//echo off 0 > /proc/recycle_skb
	//echo on 0 > /proc/recycle_skb

	//printk("in_irq=%d in_softirq=%d in_interrupt=%d in_serving_softirq=%d in_nmi=%d in_task=%d\n",
	//			in_irq(),in_softirq(),in_interrupt(),in_serving_softirq(),in_nmi(),in_task());

	if (buf && !copy_from_user(tmpbuf, buf, count)) {
		tmpbuf[count-1] = '\0';
		strptr=tmpbuf;
		tokptr = strsep(&strptr," ");
		if (tokptr == NULL) {
			goto errout;
		}
		/*else if(strcasecmp(tokptr,"on")==0){
			tokptr = strsep(&strptr," ");
			if (tokptr==NULL){
				goto errout;
			}

			if(kstrtoul(tokptr, 0, &pool))
				goto errout;

			original_state=wnic_switch_off_recycle_skb[pool];

			if(original_state==WNIC_RECYCLE_SWITCH_OFF){
				local_irq_save(flags);
				for(i=0;i<wnic_skb_total_num[pool];i++){
					skb=dev_alloc_skb(wnic_skb_max_size[pool]+WNIC_RESERVED_HEADER_SIZE);
					if(skb){
						__init_skb_recy_wnic(skb);
						skb->wnic_recyclable=pool;
						wnic_skb_queue_head(skb, pool);
					}
				}
				wnic_skb_free_num[pool]=wnic_skb_total_num[pool];
				wnic_switch_off_recycle_skb[pool]=WNIC_RECYCLE_SWITCH_ON;
				local_irq_restore(flags);
			}
			printk("switch on!\n");
			return count;
		}else if(strcasecmp(tokptr,"off")==0){
			tokptr = strsep(&strptr," ");
			if (tokptr==NULL){
				goto errout;
			}

			if(kstrtoul(tokptr, 0, &pool))
				goto errout;

			original_state=wnic_switch_off_recycle_skb[pool];

			if(original_state==WNIC_RECYCLE_SWITCH_ON){
				wnic_switch_off_recycle_skb[pool]=WNIC_RECYCLE_SWITCH_OFF;
				//drain all free skb
				local_irq_save(flags);
				while(wnic_free_eth_skb_num(pool)){
					skb=wnic_skb_dequeue(pool);
					if(skb){
						skb->wnic_recyclable=0;
						dev_kfree_skb_any(skb);
					}
				}
				local_irq_restore(flags);
			}
			printk("switch off!\n");
			return count;
		}*/
#if defined(WNIC_DOUBLE_LINK_LIST_RECYCLE_SKB) \
	|| defined(WNIC_SINGLE_LINK_LIST_RECYCLE_SKB) \
	|| defined(WNIC_LL_LINK_LIST_RECYCLE_SKB)
		/*else if(wnic_switch_off_recycle_skb==WNIC_RECYCLE_SWITCH_OFF){
			//when switch off should not operate free skb number.
			return count;
		}*/else if (strcasecmp(tokptr, "inc") == 0) {
			operator=1;
		} else if (strcasecmp(tokptr, "dec") == 0) {
			operator=-1;
		} else
			goto errout;

		tokptr = strsep(&strptr, " ");
		if (tokptr == NULL) {
			goto errout;
		}

		if (kstrtoul(tokptr, 0, &pool))
			goto errout;

		tokptr = strsep(&strptr, " ");
		if (tokptr == NULL) {
			goto errout;
		}

		if (kstrtoul(tokptr, 0, &operand))
			goto errout;

		//printk("operand=%d operator=%d delta=%d\n",operand,operator,operand*operator);
		local_irq_save(flags);
		if (operator < 0 && operand > wnic_free_eth_skb_num(pool)) {
			local_irq_restore(flags);
			printk("dec over free skb num (%lu)\n",operand);
			goto errout;
		}

		if (operator > 0) {
			for (i = 0; i < operand; i++) {
				skb = dev_alloc_skb(wnic_skb_max_size[pool] + WNIC_RESERVED_HEADER_SIZE);
				if (skb == NULL)
					break;
				__init_skb_recy_wnic(skb);
				skb->wnic_recyclable=pool;
				wnic_skb_queue_head(skb,pool);
				wnic_skb_free_num[pool]++;
			}
		} else {
			for (i = 0; i < operand; i++) {
				skb = wnic_skb_dequeue(pool);
				if (skb == NULL)
					break;
				skb->wnic_recyclable = 0;
				dev_kfree_skb_any(skb);
				wnic_skb_free_num[pool]--;
			}
		}
		local_irq_restore(flags);
		printk("recycle_skb_free_num[%d]:%d\n", pool, wnic_free_eth_skb_num(pool));
#endif
	}
errout:
	return count;
}

static int wnic_recycleskb_open(struct inode *inode, struct file *file)
{
	return single_open(file, wnic_recycleskb_read, inode->i_private);
}

#if LINUX_VERSION_CODE >= KERNEL_VERSION(5,6,0)
static const struct proc_ops wnic_recycleskb_ops = {
	.proc_open           = wnic_recycleskb_open,
	.proc_write          = wnic_recycleskb_write,
	.proc_read           = seq_read,
	.proc_lseek          = seq_lseek,
	.proc_release        = single_release,
};
#else
static const struct file_operations wnic_recycleskb_ops = {
	.owner          = THIS_MODULE,
	.open           = wnic_recycleskb_open,
	.write          = wnic_recycleskb_write,
	.read           = seq_read,
	.llseek         = seq_lseek,
	.release        = single_release,
};
#endif

#endif //WNIC_RECYCLE_SKB_PROC

int init_recycle_wnic_skb_buf(unsigned int ring_size, unsigned int max_size)
{
	int i, alloc_num = 0, pool = -1;
	int first_invalid = -1;
	struct sk_buff *skb;
	int pool_num = ARRAY_SIZE(wnic_pool);

	for (i = 1; i < pool_num; i++) {
		if (wnic_pool[i] == 0) {
			if (first_invalid < 0)
				first_invalid = i;
			continue;
		}/* else if (wnic_skb_max_size[i] == max_size) {
			pool = i;
			break;
		} */
	}
	if (pool < 0) {
		if (first_invalid < 0) {
			printk(KERN_WARNING "Out of wnic_skb_buf for size %uB.\n", max_size);
			WARN_ON(1);
			return (-1);
		}
		pool = first_invalid;
	} else {
		printk(KERN_WARNING "Re-init wnic_skb_buf of size %uB\n", max_size);
	}

	//memset(recycle_skb_buf, '\0', sizeof(struct recycle_skb_buf)*MAX_ETH_SKB_NUM);
	wnic_skb_free_num[pool] += ring_size;
	wnic_skb_total_num[pool] += ring_size;		//keep original total number

#if defined(WNIC_RING_BUFFER_RECYCLE_SKB)
	wrbr.rd_idx = 0;
	wrbr.wr_idx = 0;
	wrbr.state = WNIC_RING_BUF_RECYCLE_EMPTY;
	spin_lock_init(&wrbr.lock);

	for (i = 0; (0x1<<i) < wnic_skb_free_num[pool]; i++) ;
	if (i >= 32) {
		printk("pool is oversized...failed!\n");
		return pool;
	}

	wnic_skb_free_num = (0x1 << i);
	wrbr.ring_size_mask = wnic_skb_free_num - 1;

	wrbr.ring_buffer_recycle_array = (struct sk_buff *)kmalloc(wnic_skb_free_num*sizeof(struct sk_buff *),GFP_ATOMIC);
	if(!wrbr.ring_buffer_recycle_array){
		printk("ring buffer recycle array allocate failed!\n");
		return pool;
	}
#endif /* WNIC_RING_BUFFER_RECYCLE_SKB */
#if defined(WNIC_DOUBLE_LINK_LIST_RECYCLE_SKB) || defined(WNIC_SINGLE_LINK_LIST_RECYCLE_SKB)
	skb_queue_head_init(&wnic_recycle_skb_queue);
#endif /* WNIC_DOUBLE_LINK_LIST_RECYCLE_SKB || WNIC_SINGLE_LINK_LIST_RECYCLE_SKB */
#if defined(WNIC_STRAIGHT_ARRAY_RECYCLE_SKB)
	wsra.idx=0;
	spin_lock_init(&wsra.lock);

	wsra.array = (struct sk_buff *)kmalloc(wnic_skb_free_num*sizeof(struct sk_buff *),GFP_ATOMIC);
	if(!wsra.array){
		printk("straight recycle array allocate failed!\n");
		return pool;
	}
#endif /* WNIC_STRAIGHT_ARRAY_RECYCLE_SKB */
#if defined(WNIC_LL_LINK_LIST_RECYCLE_SKB)
	init_llist_head(&wnic_llll_skb_head[pool]);
	spin_lock_init(&wnic_llll_read_lock[pool]);
	atomic_set(&wnic_llll_num[pool], 0);
	atomic_set(&wnic_llll_nomem[pool], 0);
#endif /* WNIC_LL_LINK_LIST_RECYCLE_SKB */
	
	wnic_skb_max_size[pool] = max_size;
	wnic_pool[pool] = 1;
	#if 0
	printk("%s P(%u) wnic_skb_free_num = %u, wnic_skb_max_size = %u\n",
	       __FUNCTION__, pool, wnic_skb_free_num[pool], wnic_skb_max_size[pool]);
	#endif
	//skb_queue_head_init(&wnic_recycle_skb_queue);
	//skb_queue_head_init(&recycle_critical_skb_queue);

	for (i = 0; i < ring_size; i++) {
		skb = dev_alloc_skb(max_size + WNIC_RESERVED_HEADER_SIZE);
		if (skb) {
			__init_skb_recy_wnic(skb);
			skb->wnic_recyclable = pool;
			wnic_skb_queue_head(skb, pool);
			++alloc_num;
		} else {
			// printk("ERROR!! no skb is allocated!!!!!!!!!\n\n\n\n\n\n\n\n\n");
		}
	}//printk("\n\n\n\n\n\nwnic_recycle_skb_queue.len is %d\n\n\n\n",wnic_recycle_skb_queue.qlen);

	WARN_ON(alloc_num != ring_size);

#ifdef WNIC_RECYCLE_SKB_PROC
	if (!wnic_recycle_pe) {
	    	wnic_recycle_pe = proc_create_data(PROC_FNAME,
	    					   S_IRUSR | S_IWUSR | S_IRGRP
	    					   | S_IROTH, realtek_proc,
	    					   &wnic_recycleskb_ops, NULL);
		if (!wnic_recycle_pe)
	   	 	printk(KERN_ERR "Failed to create proc entry for "PROC_FNAME"\n");
    }
	/*proc_recycle_skb = proc_create_data("recycle_skb", 0644, NULL, &rtl_recycleskb_ops, NULL);
	if(proc_recycle_skb == NULL) {
		printk("can't create proc entry for recycle_skb\n");
	}*/
#endif

	//wnic_switch_off_recycle_skb[pool]=WNIC_RECYCLE_SWITCH_ON;

	return pool;
}
EXPORT_SYMBOL(init_recycle_wnic_skb_buf);

void deinit_recycle_wnic_skb_buf(int pool)
{
	int i;
	struct sk_buff *skb;

	//wnic_switch_off_recycle_skb[pool]=WNIC_RECYCLE_SWITCH_OFF;
	
	while (wnic_free_eth_skb_num(pool)) {
		skb = wnic_skb_dequeue(pool);
		if (skb) {
			skb->wnic_recyclable = 0;
			dev_kfree_skb_any(skb);
		}
	}

	wnic_skb_total_num[pool] = 0;
	wnic_skb_free_num[pool] = 0;
	wnic_skb_max_size[pool] = 0;

#if defined(WNIC_RING_BUFFER_RECYCLE_SKB)
	if (wrbr[pool].ring_buffer_recycle_array)
		kfree(wrbr[pool].ring_buffer_recycle_array);
#endif
#if defined(WNIC_STRAIGHT_ARRAY_RECYCLE_SKB)
	if (wsra[pool].array)
		kfree(wsra[pool].array);
#endif

	wnic_pool[pool] = 0;

#ifdef WNIC_RECYCLE_SKB_PROC
	if (wnic_recycle_pe){
		for (i = ARRAY_SIZE(wnic_pool) - 1; i >= 1; i--) {
			if (wnic_pool[i] > 0)
				break;
		}
		if (i <= 0)
			proc_remove(wnic_recycle_pe);
		wnic_recycle_pe = NULL;
	}
#endif /* WNIC_RECYCLE_SKB_PROC */
}
EXPORT_SYMBOL(deinit_recycle_wnic_skb_buf);

void wnic_recycle_skb_clean(struct sk_buff *skb)
{
	struct skb_shared_info *shinfo;
	bool pfmemalloc;
	sk_buff_data_t		end;
	unsigned char		*head;
	unsigned int		truesize;
	unsigned char		recyclable;
	//unsigned char		prepared_recycle;	

	//keep these fields before clean
	pfmemalloc=skb->pfmemalloc;
	head=skb->head;
	end=skb->end;
	truesize=skb->truesize;
	recyclable=skb->wnic_recyclable;
	//prepared_recycle=skb->prepared_recycle;

	memset(skb, 0, offsetof(struct sk_buff, tail));
#if 1 //clear RTK private header
	memset(&skb->__private_header_start, 0, offsetof(struct sk_buff, __private_header_end) -
											offsetof(struct sk_buff, __private_header_start));
#endif
	/* Account for allocated memory : skb + skb->head */
	skb->truesize=truesize;
	atomic_set(&skb->users, 1);
	skb->head=head;
	skb->end=end;
	skb->pfmemalloc = pfmemalloc;
	skb->mac_header = (typeof(skb->mac_header))~0U;
	skb->transport_header = (typeof(skb->transport_header))~0U;
	skb->wnic_recyclable=recyclable;
	//skb->prepared_recycle=prepared_recycle;

	/* make sure we initialize shinfo sequentially */
	shinfo = skb_shinfo(skb);
	memset(shinfo, 0, offsetof(struct skb_shared_info, dataref));
	atomic_set(&shinfo->dataref, 1);
#if LINUX_VERSION_CODE < KERNEL_VERSION(5,6,0)
	kmemcheck_annotate_variable(shinfo->destructor_arg);
#endif
}
EXPORT_SYMBOL(wnic_recycle_skb_clean);

int recycle_wnic_buf(struct sk_buff *skb)
{
	__u8 pool = skb->wnic_recyclable;

	if(likely((pool>0) /*&& (wnic_switch_off_recycle_skb[pool]==WNIC_RECYCLE_SWITCH_ON)*/)){//printk("%s %d pool=%d\n",__FUNCTION__,__LINE__,pool);dump_stack();
		//clean cloned skb
		if(skb->cloned)wnic_recycle_skb_clean(skb);

		wnic_skb_queue_head(skb, pool);//if(atomic_read(&wnic_llll_num[pool])>wnic_skb_free_num[pool])dump_stack();
		return 1;
	}
	return 0;
}
EXPORT_SYMBOL(recycle_wnic_buf);

struct sk_buff *dev_alloc_skb_recy_wnic(unsigned int size, int pool)
{
	/* first argument is not used */
	if (unlikely(size > wnic_skb_max_size[pool] /*|| wnic_switch_off_recycle_skb[pool]*/)) {
		return NULL;
	} else {//printk("%s %d \n",__FUNCTION__,__LINE__);
		//dequeue one skb or null if empty
		//struct skb_shared_info *shinfo;// = skb_shinfo(skb);if(skb->head==NULL)printk("skb->head is NULL!!!skb->data=%p\n",skb->data);if(shinfo==NULL)printk("%s %d shinfo is null!\n",__FUNCTION__,__LINE__);
		//unsigned int skb_size;
		struct sk_buff *skb=wnic_skb_dequeue(pool);
		//for wifi, _os_pkt_buf_alloc_rx will always reset data and tail before use.
		if(likely(skb)){//printk("%s %d \n",__FUNCTION__,__LINE__);
			__init_skb_recy_wnic(skb);
			//shinfo=skb_shinfo(skb);
			//atomic_set(&shinfo->dataref, 1);

			//wnic_skb_free_num--;
			//eth_skb_alloc_num++;
			//if(wnic_free_eth_skb_num() < lowest_wnic_skb_free_num)
				//lowest_wnic_skb_free_num = wnic_free_eth_skb_num();
		}//if(skb==NULL)printk("%s %d skb=NULL!!!!\n",__FUNCTION__,__LINE__);
		return skb;
	}
}
EXPORT_SYMBOL(dev_alloc_skb_recy_wnic);

void inline __wnic_recycle_skb_copy(struct sk_buff *skb, struct sk_buff *new_skb)
{
	unsigned char *head/*,*data*/;//printk("%s %d recyclable swap!!qlen=%d,skb=%p,new_skb=%p\n",__FUNCTION__,__LINE__,skb_queue_len(&wnic_recycle_skb_queue),skb,new_skb);
	sk_buff_data_t end/*,tail*/;
	unsigned int truesize;
	bool pfmemalloc;
#if defined(CONFIG_RTK_L34_FLEETCONNTRACK_ENABLE)
	if(skb->fcIngressData.doLearning)
		memcpy(&new_skb->fcIngressData, &skb->fcIngressData, sizeof(rtk_fc_ingress_data_t));
#endif
	//printk("skb->truesize is %d, new_skb->truesize is %d\n",skb->truesize,new_skb->truesize);
	head=new_skb->head;
	end=new_skb->end;
	truesize=new_skb->truesize;
	pfmemalloc=new_skb->pfmemalloc;
	
	new_skb->head=skb->head;
	new_skb->data=skb->data;
	new_skb->tail=skb->tail;
	new_skb->end=skb->end;
	new_skb->truesize=skb->truesize;
	new_skb->pfmemalloc=skb->pfmemalloc;
	new_skb->len=skb->len;
	new_skb->dev=skb->dev;
#ifdef CONFIG_RTK_CONTROL_PACKET_PROTECTION
	new_skb->priority=skb->priority;
#endif
	new_skb->mark=skb->mark;
#ifdef CONFIG_RTK_SKB_MARK2
	new_skb->mark2=skb->mark2;
#endif
#ifdef CONFIG_RTL8192CD
	new_skb->cb[0]=skb->cb[0];
#endif

	skb->head=head;
	skb->end=end;
	skb->truesize=truesize;
	skb->pfmemalloc=pfmemalloc;
	skb->data_len=0;		//for jumbo packet should clear it here
}

extern long si_mem_available(void);
extern int min_free_kbytes;
#define K(x) ((x) << (PAGE_SHIFT - 10))
static struct sk_buff * wnic_alloc_skb_limit(unsigned int size){
        unsigned long free_page;
        free_page = si_mem_available();
        if (K(free_page) < min_free_kbytes)     {
                printk_ratelimited("[%s %d] %lu, %d\n", __func__, __LINE__, K(free_page), min_free_kbytes);
                return NULL;
        }
        return dev_alloc_skb(size);
}

struct sk_buff *wnic_recycle_skb_swap(struct sk_buff *skb)
{
	//allocate new skb, swap skb, enqueue old_skb back to queue, continue to protocol stack
	struct sk_buff *new_skb=NULL;
	int pool=skb->wnic_recyclable;

	//check for jumbo packet
	if(skb_shinfo(skb)->frag_list){//printk("%s has frag_list!%p\n",__FUNCTION__,skb_shinfo(skb)->frag_list);
		struct sk_buff *segs=skb_shinfo(skb)->frag_list;
		new_skb=wnic_alloc_skb_limit(wnic_skb_max_size[pool]+WNIC_RESERVED_HEADER_SIZE);
		if(new_skb){//printk("%s has new_skb!\n",__FUNCTION__);
			struct sk_buff *frag_skb=wnic_alloc_skb_limit(wnic_skb_max_size[pool]+WNIC_RESERVED_HEADER_SIZE);
			if(frag_skb){//printk("%s has frag_skb!\n",__FUNCTION__);
				struct sk_buff *tmp_skb=skb_shinfo(skb)->frag_list->next;
				if(tmp_skb){//printk("%s has tmp_skb!\n",__FUNCTION__);
					//loop for next
					struct sk_buff *swap_skb=wnic_alloc_skb_limit(wnic_skb_max_size[pool]+WNIC_RESERVED_HEADER_SIZE);
					if(swap_skb){//printk("%s has swap_skb!\n",__FUNCTION__);
						struct sk_buff *next_skb=tmp_skb->next;
						frag_skb->next=swap_skb;
						while(next_skb){//printk("%s has next_skb!\n",__FUNCTION__);
							struct sk_buff *next=next_skb->next;
							struct sk_buff *alloc=NULL;
							alloc=wnic_alloc_skb_limit(wnic_skb_max_size[pool]+WNIC_RESERVED_HEADER_SIZE);
							if(alloc){//printk("%s has alloc!\n",__FUNCTION__);
								swap_skb->next=alloc;
								swap_skb=alloc;
							}else{
								swap_skb=NULL;
								break;
							}
							next_skb=next;
						}
						if(swap_skb){
							//copy new_skb,frag_skb and all next_skb
							swap_skb=frag_skb->next;//printk("%s %d swap_skb=%p\n",__FUNCTION__,__LINE__,swap_skb);
							next_skb=skb_shinfo(skb)->frag_list->next;//printk("%s %d next_skb=%p\n",__FUNCTION__,__LINE__,next_skb);
							while(swap_skb){
								struct sk_buff *swap_next=swap_skb->next;//printk("%s %d swap_next=%p\n",__FUNCTION__,__LINE__,swap_next);
								struct sk_buff *next_skb_next=next_skb->next;//printk("%s %d next_skb_next=%p\n",__FUNCTION__,__LINE__,next_skb_next);
								__wnic_recycle_skb_copy(next_skb, swap_skb);
								swap_skb=swap_next;
								next_skb=next_skb_next;
							}
							//printk("%s %d skb_shinfo(skb)->frag_list=%p, frag_skb=%p\n",__FUNCTION__,__LINE__,skb_shinfo(skb)->frag_list,frag_skb);
							new_skb->data_len=skb->data_len;
							__wnic_recycle_skb_copy(skb, new_skb);//printk("%s %d\n",__FUNCTION__,__LINE__);
							__wnic_recycle_skb_copy(skb_shinfo(new_skb)->frag_list, frag_skb);//printk("%s %d skb_shinfo(skb)->frag_list=%p, frag_skb=%p\n",__FUNCTION__,__LINE__,skb_shinfo(skb)->frag_list,frag_skb);
							skb_shinfo(skb)->frag_list=skb_shinfo(new_skb)->frag_list;//printk("%s %d\n",__FUNCTION__,__LINE__);
							skb_shinfo(new_skb)->frag_list=frag_skb;//printk("%s %d\n",__FUNCTION__,__LINE__);
						}else{
							//no memory for swap
							//printk("%s %d alloc fail!!! free all!!\n",__FUNCTION__,__LINE__);
							swap_skb=frag_skb->next;
							while(swap_skb){
								struct sk_buff *next=swap_skb->next;
								dev_kfree_skb_any(swap_skb);//printk("free swap_skb!!\n");
								swap_skb=next;
							}
							dev_kfree_skb_any(frag_skb);//printk("free frag_skb!\n");
							dev_kfree_skb_any(new_skb);//printk("free new_skb!\n");
							new_skb=NULL;
						}
					}else{
						//no memory for swap
						dev_kfree_skb_any(frag_skb);
						dev_kfree_skb_any(new_skb);
						new_skb=NULL;
					}
				}else{//printk("%s has NO tmp_skb!\n",__FUNCTION__);
					//copy new_skb and frag_skb
					new_skb->data_len=skb->data_len;
					__wnic_recycle_skb_copy(skb, new_skb);//printk("%s %d skb->data_len=%d new_skb->data_len=%d\n",__FUNCTION__,__LINE__,skb->data_len,new_skb->data_len);
					__wnic_recycle_skb_copy(skb_shinfo(new_skb)->frag_list, frag_skb);//printk("%s %d skb_shinfo(skb)->frag_list=%p, frag_skb=%p\n",__FUNCTION__,__LINE__,skb_shinfo(skb)->frag_list,frag_skb);
					skb_shinfo(skb)->frag_list=skb_shinfo(new_skb)->frag_list;//printk("%s %d skb_shinfo(skb)->frag_list=%p\n",__FUNCTION__,__LINE__,skb_shinfo(skb)->frag_list);
					skb_shinfo(new_skb)->frag_list=frag_skb;//printk("%s %d skb_shinfo(new_skb)->frag_list=%p\n",__FUNCTION__,__LINE__,skb_shinfo(new_skb)->frag_list);
				}
			}else{
				//no memory for frag_skb
				dev_kfree_skb_any(new_skb);
				new_skb=NULL;
			}
		}
		//free old skb
		while (segs) {
			struct sk_buff *next = segs->next;
			dev_kfree_skb_any(segs);
			segs = next;
		}
		skb_shinfo(skb)->frag_list=NULL;		
	}else{
		new_skb=wnic_alloc_skb_limit(wnic_skb_max_size[pool]+WNIC_RESERVED_HEADER_SIZE);
		if(new_skb){//struct skb_shared_info *shinfo = skb_shinfo(new_skb);//printk("%s %d shinfo->nr_frags=%d skb->recyclable=%d shinfo->frag_list=%p\n",__FUNCTION__,__LINE__,shinfo->nr_frags,new_skb->recyclable,shinfo->frag_list);
			__wnic_recycle_skb_copy(skb, new_skb);
		}
	}
	dev_kfree_skb_any(skb);
	//printk("%s %d after recyclable swap!!qlen=%d\n",__FUNCTION__,__LINE__,skb_queue_len(&wnic_recycle_skb_queue));
	/*if(new_skb){
		struct sk_buff *skbinlist;
		//printk("has new_skb!!!!\n");
		//printk(KERN_INFO "==> Dump SKB (after pull 14 bytes), new_skb->len %u, new_skb->data_len %u\n", new_skb->len, new_skb->data_len);
		print_hex_dump(KERN_INFO, "", DUMP_PREFIX_ADDRESS, 16, 1, new_skb->data, new_skb->len - new_skb->data_len, true);

		if (skb_shinfo(new_skb)->frag_list) {
			for (skbinlist = skb_shinfo(new_skb)->frag_list; skbinlist; skbinlist = skbinlist->next) {
				//printk(KERN_INFO "==> Dump SKB in frag_list, new_skb->len (dump_len) %u\n", skbinlist->len);
				print_hex_dump(KERN_INFO, "", DUMP_PREFIX_ADDRESS, 16, 1, skbinlist->data, skbinlist->len, true);
			}
		}
	}*/
	return new_skb;
}
EXPORT_SYMBOL(wnic_recycle_skb_swap);

#endif // CONFIG_WNIC_RECYCLED_SKB
