#ifndef _WNIC_RECYCLESKB_H_
#define _WNIC_RECYCLESKB_H_

#include <linux/skbuff.h>
#include <linux/interrupt.h>
#include <linux/ptool.h>		//performance
#include <linux/kernel.h>		//dump_stack
#include <linux/mm.h>			//get total memory size
#include <linux/netdevice.h>	//dev_kfree

#define WNIC_RECYCLE_SKB_PROC	1

enum {
	WNIC_RECYCLE_SWITCH_ON=0x0,
	WNIC_RECYCLE_SWITCH_OFF=0x1,
};

#define WNIC_RESERVED_HEADER_SIZE 0//128

#if defined(WNIC_RING_BUFFER_RECYCLE_SKB)
enum {
	WNIC_RING_BUF_RECYCLE_NORMAL=0x0,
	WNIC_RING_BUF_RECYCLE_EMPTY,
	WNIC_RING_BUF_RECYCLE_FULL,
};

struct wnic_ring_buffer_recycle_t
{
	unsigned int rd_idx;
	unsigned int wr_idx;
	unsigned int state;	//0: normal, 1:empty, 2:full
	unsigned int ring_size_mask;

	struct sk_buff **ring_buffer_recycle_array;
	spinlock_t	lock;
};
#endif
#if defined(WNIC_STRAIGHT_ARRAY_RECYCLE_SKB)
struct wnic_straight_recycle_t
{
	unsigned int idx;
	struct sk_buff **array;
	spinlock_t	lock;
};
#endif

#if defined(CONFIG_PREEMPT)
#define WNIC_RECYCLE_SPINLOCK(x) spin_lock_bh(x)
#define WNIC_RECYCLE_SPINUNLOCK(x) spin_unlock_bh(x)
#else
#define WNIC_RECYCLE_SPINLOCK(x) spin_lock(x)
#define WNIC_RECYCLE_SPINUNLOCK(x) spin_unlock(x)
#endif

int init_recycle_wnic_skb_buf(unsigned int ring_size, unsigned int max_size);
void deinit_recycle_wnic_skb_buf(int pool);
struct sk_buff *dev_alloc_skb_recy_wnic(unsigned int size, int pool);
struct sk_buff *wnic_recycle_skb_swap(struct sk_buff *skb);
unsigned int wnic_free_eth_skb_num(int pool);
unsigned int wnic_alloc_eth_skb_num(int pool);

#endif /*_WNIC_RECYCLESKB_H_*/
