#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/kthread.h>
#include <linux/sched.h>
#include <linux/init.h>
#include <linux/fs.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/time.h>
#include <linux/arm-smccc.h>
#include <soc/cortina/cortina-smc.h>
#define DEBUG 0
static unsigned int kick_time = 5;
static struct task_struct *pTask;


static int kick_rtk_job(void){
	struct arm_smccc_res res;
	unsigned thermal_init = 0;
	int ret = 0;

#if defined(CONFIG_CA8277_THERMAL) || defined(CONFIG_CA8271_THERMAL)
		thermal_init = 1;
#else
		thermal_init = 0;
#endif

	arm_smccc_smc(RTK_SVC_DDR_TREF_TUNING, thermal_init, 0, 0, 0, 0, 0, 0, &res);
	ret = (int) res.a0;
#if DEBUG
	printk("[%s %d]res.a0= %d\n", __func__, __LINE__,  ret);
#endif
	return ret;
}

static int job_routine_thread(void *data)
{
    while(!kthread_should_stop())
    {
        set_current_state(TASK_INTERRUPTIBLE);
        schedule_timeout(kick_time * HZ);
		if(kick_rtk_job() == -1){
			printk("rtk_tref_tuning: BL31 not implement DDR_TREF_TUNING\n");
			do_exit(0);
		}
    }

	return 0;
}

static void kthread_job(void){
	if( pTask == NULL){
		pTask = kthread_create(job_routine_thread, NULL, "rtk_tref_tuning");
		if(IS_ERR(pTask))
		{
			printk("[Kthread : rtk_tref] init failed %ld!\n", PTR_ERR(pTask));
		}else{
			wake_up_process(pTask);
			printk("[Kthread : rtk_tref] init complete!\n");
		}
	}
}


int __init rtk_tref_init(void)
{
	kthread_job();

	return 0;
}

void __exit rtk_tref_exit(void)
{
	kthread_stop(pTask);
}


MODULE_LICENSE("GPL");
MODULE_DESCRIPTION("RealTek DDR tref tuning module");
MODULE_AUTHOR("Alan <alan.chao@realtek.com>");
module_init(rtk_tref_init);
module_exit(rtk_tref_exit);