#include <linux/ip.h>
#include <linux/ipv6.h>
#include <linux/skbuff.h>
#include <linux/if_vlan.h>

#define ETH_TYPE_LEN (2)
#define PPP_SESSION_LEN (6)
#define IPV6_HOP_BY_HOP_OPTION (0)
#define PPP_IPV4_PROTOCOL (0x0021)
#define PPP_IPV6_PROTOCOL (0x0057)

static u16 get_eth_type(struct sk_buff *pskb);

static u16 get_ppp_proto(struct sk_buff *pskb);

static struct iphdr* get_ipv4_header(struct sk_buff *pskb);

static struct ipv6hdr* get_ipv6_header(struct sk_buff *pskb);

static u8 get_ip_proto(struct sk_buff *pskb, u8 is_ipv4);

static int is_transportable_eth_type(u16 eth_type);

static int is_transpaortble_ip_proto(u8 ip_proto, u8 is_ipv4);

int is_transportable_pkt(struct sk_buff *pskb);
