#ifndef _RTW_BAND_DEV_H_
#define _RTW_BAND_DEV_H_

#define DEV_BAND_2G 0
#define DEV_BAND_5G 1
#define WAIT_TIME 20
#define SECOND_WAIT_TIME 35

struct band_devinfo {
	struct net_device 	*dev_2G;
	struct net_device 	*dev_5G;
};

struct band_dev_status {
	unsigned char		*ssid;
	unsigned char		band_prefer;
	unsigned char		band_assoc;
};

int band_dev_register(struct net_device *dev, int band);
int band_dev_unregister(struct net_device *dev, int band);
int band_check_exist(int band);
int band_check_ssid_same(int band);
int band_check_prefer(int band);
int band_check_assoc(int band);

#endif
