/*
 * REGISTERS.h
 *
 * THIS FILE WAS AUTOMATICALLY GENERATED BY /auto/project/bin/rdb2tt.pl
 * -config ./reg_generator/rdb2h.yml -db ./reg.db
 *
 */
#ifndef _CA8279_NE_REGISTERS_H_
#define _CA8279_NE_REGISTERS_H_

#include "ca_types.h"

/******************************************************************
 *
 * Each register in the map is defined as a struct with bitfields.
 *
 ******************************************************************/

/*
 * ROMOTP
 */
        
#define  SATURN_OTP_CTL                                  0x42000800
#define  SATURN_OTP_CTL_dft                              0x00001000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 12 ;
    ca_uint32_t RESETB               :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t PWR                  :  1 ; /* bits 16:16 */
    ca_uint32_t AXIPREVENT           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd3               :  6 ;
    ca_uint32_t SPACE                :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd4               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_OTP_CTL_t;

#define      SATURN_SPACE_DEFAULT                                 0x0
#define      SATURN_SPACE_TDECBIST                                0x8
#define      SATURN_SPACE_WRTSBIST                                0xa
#define      SATURN_SPACE_LOCK                                    0xb
#define      SATURN_SPACE_RGSTR                                   0xd
#define      SATURN_SPACE_BLNKBISR                                0xe

#define  SATURN_OTP_STATUS                               0x42000804
#define  SATURN_OTP_STATUS_dft                           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t RDOPEN_STATE         :  1 ; /* bits 0:0 */
    ca_uint32_t WROPEN_STATE         :  1 ; /* bits 1:1 */
    ca_uint32_t LOCK                 :  1 ; /* bits 2:2 */
    ca_uint32_t SRESP                :  2 ; /* bits 4:3 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t SDATA                :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd2               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_OTP_STATUS_t;


#define  SATURN_OTP_PROT                                 0x42000808
#define  SATURN_OTP_PROT_dft                             0x008b0000

typedef volatile union {
  struct {
    ca_uint32_t START                : 11 ; /* bits 10:0 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t END                  : 11 ; /* bits 26:16 */
    ca_uint32_t rsrvd2               :  5 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_OTP_PROT_t;


#define  SATURN_OTP_PROTEN                               0x4200080c
#define  SATURN_OTP_PROTEN_dft                           0x00000003

typedef volatile union {
  struct {
    ca_uint32_t EN                   :  1 ; /* bits 0:0 */
    ca_uint32_t PROG                 :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_OTP_PROTEN_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* ROMOTP */
typedef struct {
  SATURN_OTP_CTL_t                                CTL;                           /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_OTP_STATUS_t                             STATUS;                        /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_OTP_PROT_t                               PROT;                          /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_OTP_PROTEN_t                             PROTEN;                        /* addr: 0x0000000c */
} SATURN_ROMOTP_t;


/*
 * APB2
 */
  
/*
 * GLB
 */
        
#define  SATURN_GLOBAL_JTAG_ID                           0x44100000
#define  SATURN_GLOBAL_JTAG_ID_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t jtag_id              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_JTAG_ID_t;


#define  SATURN_GLOBAL_EPON_CNTL                         0x44100004
#define  SATURN_GLOBAL_EPON_CNTL_dft                     0x00030000

typedef volatile union {
  struct {
    ca_uint32_t epon_rst_n           :  1 ; /* bits 0:0 */
    ca_uint32_t onumpcp_rst_n        :  1 ; /* bits 1:1 */
    ca_uint32_t onugepn_rst_n        :  1 ; /* bits 2:2 */
    ca_uint32_t xgepn_rst_n          :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t rx_coresec_10_rst_n  :  1 ; /* bits 5:5 */
    ca_uint32_t tx_coresec_10_rst_n  :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t gepn_rx_rst_n        :  1 ; /* bits 8:8 */
    ca_uint32_t gepn_tx_rst_n        :  1 ; /* bits 9:9 */
    ca_uint32_t xgepn_rx_rst_n       :  1 ; /* bits 10:10 */
    ca_uint32_t xgepn_tx_rst_n       :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd3               :  4 ;
    ca_uint32_t epon_onu_mode        :  2 ; /* bits 17:16 */
    ca_uint32_t epon_ethernet_mode   :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd4               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_EPON_CNTL_t;


#define  SATURN_GLOBAL_EPON_STATUS                       0x44100008
#define  SATURN_GLOBAL_EPON_STATUS_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t xgepon_linkok        :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_EPON_STATUS_t;


#define  SATURN_GLOBAL_GPON_CNTL                         0x4410000c
#define  SATURN_GLOBAL_GPON_CNTL_dft                     0x00000300

typedef volatile union {
  struct {
    ca_uint32_t ani_rst_n            :  1 ; /* bits 0:0 */
    ca_uint32_t gpon_rst_n           :  1 ; /* bits 1:1 */
    ca_uint32_t xgpn_rst_n           :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t us10g_mode           :  1 ; /* bits 8:8 */
    ca_uint32_t nxgs_mode            :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd2               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_GPON_CNTL_t;


#define  SATURN_GLOBAL_OPT_MODULE_CNTL                   0x44100010
#define  SATURN_GLOBAL_OPT_MODULE_CNTL_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t opt_tx_power_down    :  1 ; /* bits 0:0 */
    ca_uint32_t en_lao_det           :  1 ; /* bits 1:1 */
    ca_uint32_t hw_lao_enable        :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_OPT_MODULE_CNTL_t;


#define  SATURN_GLOBAL_OPT_MODULE_LAO_CNTL               0x44100014
#define  SATURN_GLOBAL_OPT_MODULE_LAO_CNTL_dft           0x00ff00ff

typedef volatile union {
  struct {
    ca_uint32_t lao_accu_one         : 16 ; /* bits 15:0 */
    ca_uint32_t lao_accu_zero        : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_OPT_MODULE_LAO_CNTL_t;


#define  SATURN_GLOBAL_OPT_INTERRUPT                     0x44100018
#define  SATURN_GLOBAL_OPT_INTERRUPT_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_los               :  1 ; /* bits 0:0 */
    ca_uint32_t tx_fault             :  1 ; /* bits 1:1 */
    ca_uint32_t mod_abs              :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t lao_stuck_at_one_int :  1 ; /* bits 8:8 */
    ca_uint32_t lao_stuck_at_zero_int :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd2               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_OPT_INTERRUPT_t;


#define  SATURN_GLOBAL_OPT_INTENABLE                     0x4410001c
#define  SATURN_GLOBAL_OPT_INTENABLE_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_losE              :  1 ; /* bits 0:0 */
    ca_uint32_t tx_faultE            :  1 ; /* bits 1:1 */
    ca_uint32_t mod_absE             :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t lao_stuck_at_one_intE :  1 ; /* bits 8:8 */
    ca_uint32_t lao_stuck_at_zero_intE :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd2               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_OPT_INTENABLE_t;


#define  SATURN_GLOBAL_OPT_MODULE_STATUS                 0x44100020
#define  SATURN_GLOBAL_OPT_MODULE_STATUS_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t opt_tx_fault         :  1 ; /* bits 0:0 */
    ca_uint32_t opt_tx_sd            :  1 ; /* bits 1:1 */
    ca_uint32_t opt_mod_abs          :  1 ; /* bits 2:2 */
    ca_uint32_t opt_rx_los           :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_OPT_MODULE_STATUS_t;


#define  SATURN_GLOBAL_PON_CNTL                          0x44100024
#define  SATURN_GLOBAL_PON_CNTL_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t epon_mode            :  1 ; /* bits 0:0 */
    ca_uint32_t pon_serdes_rst_n     :  1 ; /* bits 1:1 */
    ca_uint32_t psds_reg_rst_n       :  1 ; /* bits 2:2 */
    ca_uint32_t ptp_rst_n            :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t puc_reset            :  1 ; /* bits 8:8 */
    ca_uint32_t pdc_reset            :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd2               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_PON_CNTL_t;


#define  SATURN_GLOBAL_BLOCK_RESET                       0x44100028
#define  SATURN_GLOBAL_BLOCK_RESET_dft                   0x4f29003f

typedef volatile union {
  struct {
    ca_uint32_t reset_ni             :  1 ; /* bits 0:0 */
    ca_uint32_t reset_l2fe           :  1 ; /* bits 1:1 */
    ca_uint32_t reset_l2tm           :  1 ; /* bits 2:2 */
    ca_uint32_t reset_l3fe           :  1 ; /* bits 3:3 */
    ca_uint32_t reset_sdram          :  1 ; /* bits 4:4 */
    ca_uint32_t reset_tqm            :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t reset_flash          :  1 ; /* bits 14:14 */
    ca_uint32_t reset_per            :  1 ; /* bits 15:15 */
    ca_uint32_t reset_dma            :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t reset_cpu_ap         :  1 ; /* bits 18:18 */
    ca_uint32_t reset_cpu_dsp        :  1 ; /* bits 19:19 */
    ca_uint32_t reset_rcpu0          :  1 ; /* bits 20:20 */
    ca_uint32_t reset_rcpu1          :  1 ; /* bits 21:21 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t reset_taroko0_atu    :  1 ; /* bits 23:23 */
    ca_uint32_t reset_taroko1_atu    :  1 ; /* bits 24:24 */
    ca_uint32_t reset_ldma           :  1 ; /* bits 25:25 */
    ca_uint32_t reset_fbm            :  1 ; /* bits 26:26 */
    ca_uint32_t reset_eaxi           :  1 ; /* bits 27:27 */
    ca_uint32_t reset_sd             :  1 ; /* bits 28:28 */
    ca_uint32_t reset_otprom         :  1 ; /* bits 29:29 */
    ca_uint32_t reset_iic_slv        :  1 ; /* bits 30:30 */
    ca_uint32_t rsrvd4               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_BLOCK_RESET_t;


#define  SATURN_GLOBAL_GPHY_STATUS                       0x4410002c
#define  SATURN_GLOBAL_GPHY_STATUS_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t anaprob              :  1 ; /* bits 0:0 */
    ca_uint32_t prob_av_cen_l        :  1 ; /* bits 1:1 */
    ca_uint32_t prob_dv_cen_l        :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_GPHY_STATUS_t;


#define  SATURN_GLOBAL_FABRIC_RESET                      0x44100030
#define  SATURN_GLOBAL_FABRIC_RESET_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t reset_capsram        :  1 ; /* bits 1:1 */
    ca_uint32_t reset_capsramreg     :  1 ; /* bits 2:2 */
    ca_uint32_t reset_cpu_sw         :  1 ; /* bits 3:3 */
    ca_uint32_t reset_ne_sw          :  1 ; /* bits 4:4 */
    ca_uint32_t reset_io_sw          :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd2               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_FABRIC_RESET_t;


#define  SATURN_GLOBAL_STRAP                             0x44100034
#define  SATURN_GLOBAL_STRAP_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t debug_mode           :  1 ; /* bits 0:0 */
    ca_uint32_t speed                :  2 ; /* bits 2:1 */
    ca_uint32_t dsp_avail            :  1 ; /* bits 3:3 */
    ca_uint32_t chip_type            :  2 ; /* bits 5:4 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t sd_emmc_avail        :  1 ; /* bits 7:7 */
    ca_uint32_t flashSize            :  2 ; /* bits 9:8 */
    ca_uint32_t flashWidth           :  1 ; /* bits 10:10 */
    ca_uint32_t flashPin             :  1 ; /* bits 11:11 */
    ca_uint32_t flashType            :  3 ; /* bits 14:12 */
    ca_uint32_t uart_message         :  1 ; /* bits 15:15 */
    ca_uint32_t sd                   :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd2               :  5 ;
    ca_uint32_t misc_mode            :  8 ; /* bits 29:22 */
    ca_uint32_t jtag_osc_2           :  1 ; /* bits 30:30 */
    ca_uint32_t jtag_osc_3           :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_STRAP_t;


#define  SATURN_GLOBAL_STRAP_OVERRIDE                    0x44100038
#define  SATURN_GLOBAL_STRAP_OVERRIDE_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t speed                :  2 ; /* bits 2:1 */
    ca_uint32_t dsp_avail            :  1 ; /* bits 3:3 */
    ca_uint32_t chip_type            :  2 ; /* bits 5:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t sd_emmc_avail        :  1 ; /* bits 7:7 */
    ca_uint32_t flashSize            :  2 ; /* bits 9:8 */
    ca_uint32_t flashWidth           :  1 ; /* bits 10:10 */
    ca_uint32_t flashPin             :  1 ; /* bits 11:11 */
    ca_uint32_t flashType            :  3 ; /* bits 14:12 */
    ca_uint32_t uart_message         :  1 ; /* bits 15:15 */
    ca_uint32_t sd                   :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd3               :  5 ;
    ca_uint32_t misc_mode            :  8 ; /* bits 29:22 */
    ca_uint32_t rsrvd4               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_STRAP_OVERRIDE_t;


#define  SATURN_GLOBAL_STRAP_OVERRIDE_VALUE              0x4410003c
#define  SATURN_GLOBAL_STRAP_OVERRIDE_VALUE_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t speed                :  2 ; /* bits 2:1 */
    ca_uint32_t dsp_avail            :  1 ; /* bits 3:3 */
    ca_uint32_t chip_type            :  2 ; /* bits 5:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t sd_emmc_avail        :  1 ; /* bits 7:7 */
    ca_uint32_t flashSize            :  2 ; /* bits 9:8 */
    ca_uint32_t flashWidth           :  1 ; /* bits 10:10 */
    ca_uint32_t flashPin             :  1 ; /* bits 11:11 */
    ca_uint32_t flashType            :  3 ; /* bits 14:12 */
    ca_uint32_t uart_message         :  1 ; /* bits 15:15 */
    ca_uint32_t sd                   :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd3               :  5 ;
    ca_uint32_t misc_mode            :  8 ; /* bits 29:22 */
    ca_uint32_t rsrvd4               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_STRAP_OVERRIDE_VALUE_t;


#define  SATURN_GLOBAL_BIST_RESULT                       0x44100040
#define  SATURN_GLOBAL_BIST_RESULT_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bist_complete_capsram :  1 ; /* bits 0:0 */
    ca_uint32_t bist_complete_l3qm2  :  1 ; /* bits 1:1 */
    ca_uint32_t bist_complete_l3qm1  :  1 ; /* bits 2:2 */
    ca_uint32_t bist_complete_l2tm2  :  1 ; /* bits 3:3 */
    ca_uint32_t bist_complete_l2tm1  :  1 ; /* bits 4:4 */
    ca_uint32_t bist_complete_taroko_im0 :  1 ; /* bits 5:5 */
    ca_uint32_t bist_complete_taroko_dm0 :  1 ; /* bits 6:6 */
    ca_uint32_t bist_complete_taroko_im1 :  1 ; /* bits 7:7 */
    ca_uint32_t bist_complete_taroko_dm1 :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t capsram              : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_BIST_RESULT_t;


#define  SATURN_GLOBAL_BIST_DATA                         0x44100044
#define  SATURN_GLOBAL_BIST_DATA_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t capsram              :  3 ; /* bits 10:8 */
    ca_uint32_t l3qm2                :  5 ; /* bits 15:11 */
    ca_uint32_t l3qm1                :  5 ; /* bits 20:16 */
    ca_uint32_t l2tm2                :  5 ; /* bits 25:21 */
    ca_uint32_t l2tm1                :  5 ; /* bits 30:26 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_BIST_DATA_t;


#define  SATURN_GLOBAL_GLOBAL_CONFIG                     0x44100048
#define  SATURN_GLOBAL_GLOBAL_CONFIG_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t wd_reset_subsys_enable :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t wd_reset_all_blocks  :  1 ; /* bits 6:6 */
    ca_uint32_t wd_reset_remap       :  1 ; /* bits 7:7 */
    ca_uint32_t wd_reset_ext_reset   :  1 ; /* bits 8:8 */
    ca_uint32_t ext_reset            :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd3               :  6 ;
    ca_uint32_t gpon_pd              :  1 ; /* bits 16:16 */
    ca_uint32_t epon_pd              :  1 ; /* bits 17:17 */
    ca_uint32_t l3fe_pd              :  1 ; /* bits 18:18 */
    ca_uint32_t per_pd               :  1 ; /* bits 19:19 */
    ca_uint32_t flash_pd             :  1 ; /* bits 20:20 */
    ca_uint32_t sd_pd                :  1 ; /* bits 21:21 */
    ca_uint32_t iosw_pd              :  1 ; /* bits 22:22 */
    ca_uint32_t rsrvd4               :  9 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_GLOBAL_CONFIG_t;


#define  SATURN_GLOBAL_PHY_CONTROL                       0x4410004c
#define  SATURN_GLOBAL_PHY_CONTROL_dft                   0x00000001

typedef volatile union {
  struct {
    ca_uint32_t cfg_xfi0_10g         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 27 ;
    ca_uint32_t s0_p_mdio_enable_reg :  1 ; /* bits 28:28 */
    ca_uint32_t rsrvd2               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_PHY_CONTROL_t;


#define  SATURN_GLOBAL_PIN_MUX                           0x44100050
#define  SATURN_GLOBAL_PIN_MUX_dft                       0x02080004

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t flash_mux_sel        :  1 ; /* bits 2:2 */
    ca_uint32_t iomux_uart_1_enable  :  1 ; /* bits 3:3 */
    ca_uint32_t iomux_led_enable     :  1 ; /* bits 4:4 */
    ca_uint32_t iomux_pwm_enable     :  1 ; /* bits 5:5 */
    ca_uint32_t iomux_spi_cs1_en     :  1 ; /* bits 6:6 */
    ca_uint32_t iomux_uart_0_hwfc_enable :  1 ; /* bits 7:7 */
    ca_uint32_t iomux_rtk_biws_enable :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t iomux_sd_volt_reg    :  1 ; /* bits 11:11 */
    ca_uint32_t iomux_g3_comm        :  1 ; /* bits 12:12 */
    ca_uint32_t iomux_sd_mmc_resetn  :  1 ; /* bits 13:13 */
    ca_uint32_t iomux_optical_pwdn_enable :  1 ; /* bits 14:14 */
    ca_uint32_t iomux_frac_clk_en_extsclk :  1 ; /* bits 15:15 */
    ca_uint32_t iomux_frac_clk_en_extclk :  1 ; /* bits 16:16 */
    ca_uint32_t iomux_tdm_wan_clk    :  1 ; /* bits 17:17 */
    ca_uint32_t iomux_tdm_wan_clk_sel :  1 ; /* bits 18:18 */
    ca_uint32_t iomux_eaxi_enable    :  1 ; /* bits 19:19 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t iomux_use_cspi       :  1 ; /* bits 21:21 */
    ca_uint32_t iomux_sflash_cs1_en  :  1 ; /* bits 22:22 */
    ca_uint32_t iomux_intout_enable  :  1 ; /* bits 23:23 */
    ca_uint32_t iomux_sflash4_enable :  1 ; /* bits 24:24 */
    ca_uint32_t iomux_pado_spare_1   :  1 ; /* bits 25:25 */
    ca_uint32_t iomux_pade_spare_1   :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd4               :  4 ;
    ca_uint32_t fmro_enable          :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_PIN_MUX_t;


#define  SATURN_GLOBAL_IO_DRIVE_CONTROL                  0x44100054
#define  SATURN_GLOBAL_IO_DRIVE_CONTROL_dft              0x00330000

typedef volatile union {
  struct {
    ca_uint32_t gmac_dp              :  3 ; /* bits 2:0 */
    ca_uint32_t gmac_dn              :  3 ; /* bits 5:3 */
    ca_uint32_t gmac_mode            :  2 ; /* bits 7:6 */
    ca_uint32_t gmac_ds              :  1 ; /* bits 8:8 */
    ca_uint32_t flash_ds             :  1 ; /* bits 9:9 */
    ca_uint32_t nu_ds                :  1 ; /* bits 10:10 */
    ca_uint32_t ssp_ds               :  1 ; /* bits 11:11 */
    ca_uint32_t spi_ds               :  1 ; /* bits 12:12 */
    ca_uint32_t gpio_ds              :  1 ; /* bits 13:13 */
    ca_uint32_t misc_ds              :  1 ; /* bits 14:14 */
    ca_uint32_t eaxi_ds              :  1 ; /* bits 15:15 */
    ca_uint32_t sd_ds                :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_IO_DRIVE_CONTROL_t;


#define  SATURN_GLOBAL_GPIO_MUX_0                        0x44100058
#define  SATURN_GLOBAL_GPIO_MUX_0_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gpio0en              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_GPIO_MUX_0_t;


#define  SATURN_GLOBAL_GPIO_MUX_1                        0x4410005c
#define  SATURN_GLOBAL_GPIO_MUX_1_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gpio1en              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_GPIO_MUX_1_t;


#define  SATURN_GLOBAL_GPIO_MUX_2                        0x44100060
#define  SATURN_GLOBAL_GPIO_MUX_2_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gpio2en              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_GPIO_MUX_2_t;


#define  SATURN_GLOBAL_GPIO_MUX_3                        0x44100064
#define  SATURN_GLOBAL_GPIO_MUX_3_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gpio3en              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_GPIO_MUX_3_t;


#define  SATURN_GLOBAL_GIGE_PHY                          0x44100068
#define  SATURN_GLOBAL_GIGE_PHY_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gphy_phyrst_cen_b    :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_GIGE_PHY_t;


#define  SATURN_GLOBAL_TAROKO_STATE                      0x4410006c
#define  SATURN_GLOBAL_TAROKO_STATE_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cpu_ap_debug_mode    :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t cpu_ap_power_down_out :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd2               :  5 ;
    ca_uint32_t cpu_dsp_debug_mode   :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t cpu_dsp_power_down_out :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd4               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_TAROKO_STATE_t;


#define  SATURN_GLOBAL_SYSTEM_INTERRUPT_0                0x44100070
#define  SATURN_GLOBAL_SYSTEM_INTERRUPT_0_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t misc_intr_i          :  1 ; /* bits 0:0 */
    ca_uint32_t ddr_ctrl_i           :  1 ; /* bits 1:1 */
    ca_uint32_t flash_irqReqi        :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t PER_UART0_INTi       :  1 ; /* bits 4:4 */
    ca_uint32_t PER_UART1_INTi       :  1 ; /* bits 5:5 */
    ca_uint32_t gphy_mac_inti        :  1 ; /* bits 6:6 */
    ca_uint32_t psds_prbs_inti       :  1 ; /* bits 7:7 */
    ca_uint32_t cpu_ap_clkchange_complete_int :  1 ; /* bits 8:8 */
    ca_uint32_t cpu_dsp_clkchange_complete_int :  1 ; /* bits 9:9 */
    ca_uint32_t cpu_ap_clkchange_failed_int :  1 ; /* bits 10:10 */
    ca_uint32_t cpu_dsp_clkchange_failed_int :  1 ; /* bits 11:11 */
    ca_uint32_t software_int         :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd2               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_SYSTEM_INTERRUPT_0_t;


#define  SATURN_GLOBAL_SYSTEM_INTENABLE_0                0x44100074
#define  SATURN_GLOBAL_SYSTEM_INTENABLE_0_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t misc_intr_e          :  1 ; /* bits 0:0 */
    ca_uint32_t ddr_ctrl_e           :  1 ; /* bits 1:1 */
    ca_uint32_t flash_irqReqe        :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t PER_UART0_INTe       :  1 ; /* bits 4:4 */
    ca_uint32_t PER_UART1_INTe       :  1 ; /* bits 5:5 */
    ca_uint32_t gphy_mac_inte        :  1 ; /* bits 6:6 */
    ca_uint32_t psds_prbs_inte       :  1 ; /* bits 7:7 */
    ca_uint32_t cpu_ap_clkchange_complete_inte :  1 ; /* bits 8:8 */
    ca_uint32_t cpu_dsp_clkchange_complete_inte :  1 ; /* bits 9:9 */
    ca_uint32_t cpu_ap_clkchange_failed_inte :  1 ; /* bits 10:10 */
    ca_uint32_t cpu_dsp_clkchange_failed_inte :  1 ; /* bits 11:11 */
    ca_uint32_t software_inte        :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd2               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_SYSTEM_INTENABLE_0_t;


#define  SATURN_GLOBAL_SW_INTERRUPT_0                    0x44100078
#define  SATURN_GLOBAL_SW_INTERRUPT_0_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sw_int               :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_SW_INTERRUPT_0_t;


#define  SATURN_GLOBAL_CPU_IPC_SOFT_INTERRUPT_0          0x4410007c
#define  SATURN_GLOBAL_CPU_IPC_SOFT_INTERRUPT_0_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t IRQ_soft0iSeti       :  1 ; /* bits 0:0 */
    ca_uint32_t IRQ_soft1iSeti       :  1 ; /* bits 1:1 */
    ca_uint32_t ipc_int_pe0i         :  1 ; /* bits 2:2 */
    ca_uint32_t ipc_int_pe1i         :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_CPU_IPC_SOFT_INTERRUPT_0_t;


#define  SATURN_GLOBAL_CPU_IPC_SOFT_INTENABLE_0          0x44100080
#define  SATURN_GLOBAL_CPU_IPC_SOFT_INTENABLE_0_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t IRQ_soft0iSete       :  1 ; /* bits 0:0 */
    ca_uint32_t IRQ_soft1iSete       :  1 ; /* bits 1:1 */
    ca_uint32_t ipc_int_pe0e         :  1 ; /* bits 2:2 */
    ca_uint32_t ipc_int_pe1e         :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_CPU_IPC_SOFT_INTENABLE_0_t;


#define  SATURN_GLOBAL_CPU_LSOSSPFBM_INTERRUPT_0         0x44100084
#define  SATURN_GLOBAL_CPU_LSOSSPFBM_INTERRUPT_0_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t DMA_LSO_INTERRUPTi   :  8 ; /* bits 7:0 */
    ca_uint32_t DMA_SSP_INTERRUPTi   :  8 ; /* bits 15:8 */
    ca_uint32_t FBM_IRQi             :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_CPU_LSOSSPFBM_INTERRUPT_0_t;


#define  SATURN_GLOBAL_CPU_LSOSSPFBM_INTENABLE0          0x44100088
#define  SATURN_GLOBAL_CPU_LSOSSPFBM_INTENABLE0_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t DMA_LSO_INTERRUPTe   :  8 ; /* bits 7:0 */
    ca_uint32_t DMA_SSP_INTERRUPTe   :  8 ; /* bits 15:8 */
    ca_uint32_t FBM_IRQe             :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_CPU_LSOSSPFBM_INTENABLE0_t;


#define  SATURN_GLOBAL_LDMA_INTERRUPT_0                  0x4410008c
#define  SATURN_GLOBAL_LDMA_INTERRUPT_0_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ldma_irqi            :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_LDMA_INTERRUPT_0_t;


#define  SATURN_GLOBAL_LDMA_INTENABLE0                   0x44100090
#define  SATURN_GLOBAL_LDMA_INTENABLE0_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ldma_irqe            :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_LDMA_INTENABLE0_t;


#define  SATURN_GLOBAL_CPU_QM_INTERRUPT_0                0x44100094
#define  SATURN_GLOBAL_CPU_QM_INTERRUPT_0_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t CPU_EPP_FIFO_0i      :  1 ; /* bits 8:8 */
    ca_uint32_t CPU_EPP_FIFO_1i      :  1 ; /* bits 9:9 */
    ca_uint32_t CPU_EPP_FIFO_2i      :  1 ; /* bits 10:10 */
    ca_uint32_t CPU_EPP_FIFO_3i      :  1 ; /* bits 11:11 */
    ca_uint32_t CPU_EPP_FIFO_4i      :  1 ; /* bits 12:12 */
    ca_uint32_t CPU_EPP_FIFO_5i      :  1 ; /* bits 13:13 */
    ca_uint32_t CPU_EPP_FIFO_6i      :  1 ; /* bits 14:14 */
    ca_uint32_t CPU_EPP_FIFO_7i      :  1 ; /* bits 15:15 */
    ca_uint32_t CPU_REFILL_REQ_0i    :  1 ; /* bits 16:16 */
    ca_uint32_t CPU_REFILL_REQ_1i    :  1 ; /* bits 17:17 */
    ca_uint32_t CPU_REFILL_REQ_2i    :  1 ; /* bits 18:18 */
    ca_uint32_t CPU_REFILL_REQ_3i    :  1 ; /* bits 19:19 */
    ca_uint32_t CPU_REFILL_REQ_4i    :  1 ; /* bits 20:20 */
    ca_uint32_t CPU_REFILL_REQ_5i    :  1 ; /* bits 21:21 */
    ca_uint32_t CPU_REFILL_REQ_6i    :  1 ; /* bits 22:22 */
    ca_uint32_t CPU_REFILL_REQ_7i    :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd2               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_CPU_QM_INTERRUPT_0_t;


#define  SATURN_GLOBAL_CPU_QM_INTENABLE_0                0x44100098
#define  SATURN_GLOBAL_CPU_QM_INTENABLE_0_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t CPU_EPP_FIFO_0e      :  1 ; /* bits 8:8 */
    ca_uint32_t CPU_EPP_FIFO_1e      :  1 ; /* bits 9:9 */
    ca_uint32_t CPU_EPP_FIFO_2e      :  1 ; /* bits 10:10 */
    ca_uint32_t CPU_EPP_FIFO_3e      :  1 ; /* bits 11:11 */
    ca_uint32_t CPU_EPP_FIFO_4e      :  1 ; /* bits 12:12 */
    ca_uint32_t CPU_EPP_FIFO_5e      :  1 ; /* bits 13:13 */
    ca_uint32_t CPU_EPP_FIFO_6e      :  1 ; /* bits 14:14 */
    ca_uint32_t CPU_EPP_FIFO_7e      :  1 ; /* bits 15:15 */
    ca_uint32_t CPU_REFILL_REQ_0e    :  1 ; /* bits 16:16 */
    ca_uint32_t CPU_REFILL_REQ_1e    :  1 ; /* bits 17:17 */
    ca_uint32_t CPU_REFILL_REQ_2e    :  1 ; /* bits 18:18 */
    ca_uint32_t CPU_REFILL_REQ_3e    :  1 ; /* bits 19:19 */
    ca_uint32_t CPU_REFILL_REQ_4e    :  1 ; /* bits 20:20 */
    ca_uint32_t CPU_REFILL_REQ_5e    :  1 ; /* bits 21:21 */
    ca_uint32_t CPU_REFILL_REQ_6e    :  1 ; /* bits 22:22 */
    ca_uint32_t CPU_REFILL_REQ_7e    :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd2               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_CPU_QM_INTENABLE_0_t;


#define  SATURN_GLOBAL_NETWORK_ENGINE_INTERRUPT_0        0x4410009c
#define  SATURN_GLOBAL_NETWORK_ENGINE_INTERRUPT_0_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t NIi                  :  1 ; /* bits 0:0 */
    ca_uint32_t L2FEi                :  1 ; /* bits 1:1 */
    ca_uint32_t L2TMi                :  1 ; /* bits 2:2 */
    ca_uint32_t L3TEi                :  1 ; /* bits 3:3 */
    ca_uint32_t TQMi                 :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t WOL_inti             :  1 ; /* bits 7:7 */
    ca_uint32_t XFI0_inti            :  1 ; /* bits 8:8 */
    ca_uint32_t XFI1_inti            :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd2               :  6 ;
    ca_uint32_t PTPi                 :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd3               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_NETWORK_ENGINE_INTERRUPT_0_t;


#define  SATURN_GLOBAL_NETWORK_ENGINE_INTENABLE_0        0x441000a0
#define  SATURN_GLOBAL_NETWORK_ENGINE_INTENABLE_0_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t NIe                  :  1 ; /* bits 0:0 */
    ca_uint32_t L2FEe                :  1 ; /* bits 1:1 */
    ca_uint32_t L2TMe                :  1 ; /* bits 2:2 */
    ca_uint32_t L3TEe                :  1 ; /* bits 3:3 */
    ca_uint32_t TQMe                 :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t WOL_inte             :  1 ; /* bits 7:7 */
    ca_uint32_t XFI0_inte            :  1 ; /* bits 8:8 */
    ca_uint32_t XFI1_inte            :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd2               :  6 ;
    ca_uint32_t PTPe                 :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd3               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_NETWORK_ENGINE_INTENABLE_0_t;


#define  SATURN_GLOBAL_SYSTEM_INTERRUPT_1                0x441000a4
#define  SATURN_GLOBAL_SYSTEM_INTERRUPT_1_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t misc_intr_i          :  1 ; /* bits 0:0 */
    ca_uint32_t ddr_ctrl_i           :  1 ; /* bits 1:1 */
    ca_uint32_t flash_irqReqi        :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t PER_UART0_INTi       :  1 ; /* bits 4:4 */
    ca_uint32_t PER_UART1_INTi       :  1 ; /* bits 5:5 */
    ca_uint32_t gphy_mac_inti        :  1 ; /* bits 6:6 */
    ca_uint32_t psds_prbs_inti       :  1 ; /* bits 7:7 */
    ca_uint32_t cpu_ap_clkchange_complete_int :  1 ; /* bits 8:8 */
    ca_uint32_t cpu_dsp_clkchange_complete_int :  1 ; /* bits 9:9 */
    ca_uint32_t cpu_ap_clkchange_failed_int :  1 ; /* bits 10:10 */
    ca_uint32_t cpu_dsp_clkchange_failed_int :  1 ; /* bits 11:11 */
    ca_uint32_t software_int         :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd2               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_SYSTEM_INTERRUPT_1_t;


#define  SATURN_GLOBAL_SYSTEM_INTENABLE_1                0x441000a8
#define  SATURN_GLOBAL_SYSTEM_INTENABLE_1_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t misc_intr_e          :  1 ; /* bits 0:0 */
    ca_uint32_t ddr_ctrl_e           :  1 ; /* bits 1:1 */
    ca_uint32_t flash_irqReqe        :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t PER_UART0_INTe       :  1 ; /* bits 4:4 */
    ca_uint32_t PER_UART1_INTe       :  1 ; /* bits 5:5 */
    ca_uint32_t gphy_mac_inte        :  1 ; /* bits 6:6 */
    ca_uint32_t psds_prbs_inte       :  1 ; /* bits 7:7 */
    ca_uint32_t cpu_ap_clkchange_complete_inte :  1 ; /* bits 8:8 */
    ca_uint32_t cpu_dsp_clkchange_complete_inte :  1 ; /* bits 9:9 */
    ca_uint32_t cpu_ap_clkchange_failed_inte :  1 ; /* bits 10:10 */
    ca_uint32_t cpu_dsp_clkchange_failed_inte :  1 ; /* bits 11:11 */
    ca_uint32_t software_inte        :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd2               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_SYSTEM_INTENABLE_1_t;


#define  SATURN_GLOBAL_SW_INTERRUPT_1                    0x441000ac
#define  SATURN_GLOBAL_SW_INTERRUPT_1_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sw_int               :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_SW_INTERRUPT_1_t;


#define  SATURN_GLOBAL_CPU_IPC_SOFT_INTERRUPT_1          0x441000b0
#define  SATURN_GLOBAL_CPU_IPC_SOFT_INTERRUPT_1_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t IRQ_soft0iSeti       :  1 ; /* bits 0:0 */
    ca_uint32_t IRQ_soft1iSeti       :  1 ; /* bits 1:1 */
    ca_uint32_t ipc_int_pe0i         :  1 ; /* bits 2:2 */
    ca_uint32_t ipc_int_pe1i         :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_CPU_IPC_SOFT_INTERRUPT_1_t;


#define  SATURN_GLOBAL_CPU_IPC_SOFT_INTENABLE_1          0x441000b4
#define  SATURN_GLOBAL_CPU_IPC_SOFT_INTENABLE_1_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t IRQ_soft0iSete       :  1 ; /* bits 0:0 */
    ca_uint32_t IRQ_soft1iSete       :  1 ; /* bits 1:1 */
    ca_uint32_t ipc_int_pe0e         :  1 ; /* bits 2:2 */
    ca_uint32_t ipc_int_pe1e         :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_CPU_IPC_SOFT_INTENABLE_1_t;


#define  SATURN_GLOBAL_CPU_LSOSSPFBM_INTERRUPT_1         0x441000b8
#define  SATURN_GLOBAL_CPU_LSOSSPFBM_INTERRUPT_1_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t DMA_LSO_INTERRUPTi   :  8 ; /* bits 7:0 */
    ca_uint32_t DMA_SSP_INTERRUPTi   :  8 ; /* bits 15:8 */
    ca_uint32_t FBM_IRQi             :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_CPU_LSOSSPFBM_INTERRUPT_1_t;


#define  SATURN_GLOBAL_CPU_LSOSSPFBM_INTENABLE1          0x441000bc
#define  SATURN_GLOBAL_CPU_LSOSSPFBM_INTENABLE1_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t DMA_LSO_INTERRUPTe   :  8 ; /* bits 7:0 */
    ca_uint32_t DMA_SSP_INTERRUPTe   :  8 ; /* bits 15:8 */
    ca_uint32_t FBM_IRQe             :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_CPU_LSOSSPFBM_INTENABLE1_t;


#define  SATURN_GLOBAL_LDMA_INTERRUPT_1                  0x441000c0
#define  SATURN_GLOBAL_LDMA_INTERRUPT_1_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ldma_irqi            :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_LDMA_INTERRUPT_1_t;


#define  SATURN_GLOBAL_LDMA_INTENABLE1                   0x441000c4
#define  SATURN_GLOBAL_LDMA_INTENABLE1_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ldma_irqe            :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_LDMA_INTENABLE1_t;


#define  SATURN_GLOBAL_CPU_QM_INTERRUPT_1                0x441000c8
#define  SATURN_GLOBAL_CPU_QM_INTERRUPT_1_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t CPU_EPP_FIFO_0i      :  1 ; /* bits 8:8 */
    ca_uint32_t CPU_EPP_FIFO_1i      :  1 ; /* bits 9:9 */
    ca_uint32_t CPU_EPP_FIFO_2i      :  1 ; /* bits 10:10 */
    ca_uint32_t CPU_EPP_FIFO_3i      :  1 ; /* bits 11:11 */
    ca_uint32_t CPU_EPP_FIFO_4i      :  1 ; /* bits 12:12 */
    ca_uint32_t CPU_EPP_FIFO_5i      :  1 ; /* bits 13:13 */
    ca_uint32_t CPU_EPP_FIFO_6i      :  1 ; /* bits 14:14 */
    ca_uint32_t CPU_EPP_FIFO_7i      :  1 ; /* bits 15:15 */
    ca_uint32_t CPU_REFILL_REQ_0i    :  1 ; /* bits 16:16 */
    ca_uint32_t CPU_REFILL_REQ_1i    :  1 ; /* bits 17:17 */
    ca_uint32_t CPU_REFILL_REQ_2i    :  1 ; /* bits 18:18 */
    ca_uint32_t CPU_REFILL_REQ_3i    :  1 ; /* bits 19:19 */
    ca_uint32_t CPU_REFILL_REQ_4i    :  1 ; /* bits 20:20 */
    ca_uint32_t CPU_REFILL_REQ_5i    :  1 ; /* bits 21:21 */
    ca_uint32_t CPU_REFILL_REQ_6i    :  1 ; /* bits 22:22 */
    ca_uint32_t CPU_REFILL_REQ_7i    :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd2               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_CPU_QM_INTERRUPT_1_t;


#define  SATURN_GLOBAL_CPU_QM_INTENABLE_1                0x441000cc
#define  SATURN_GLOBAL_CPU_QM_INTENABLE_1_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t CPU_EPP_FIFO_0e      :  1 ; /* bits 8:8 */
    ca_uint32_t CPU_EPP_FIFO_1e      :  1 ; /* bits 9:9 */
    ca_uint32_t CPU_EPP_FIFO_2e      :  1 ; /* bits 10:10 */
    ca_uint32_t CPU_EPP_FIFO_3e      :  1 ; /* bits 11:11 */
    ca_uint32_t CPU_EPP_FIFO_4e      :  1 ; /* bits 12:12 */
    ca_uint32_t CPU_EPP_FIFO_5e      :  1 ; /* bits 13:13 */
    ca_uint32_t CPU_EPP_FIFO_6e      :  1 ; /* bits 14:14 */
    ca_uint32_t CPU_EPP_FIFO_7e      :  1 ; /* bits 15:15 */
    ca_uint32_t CPU_REFILL_REQ_0e    :  1 ; /* bits 16:16 */
    ca_uint32_t CPU_REFILL_REQ_1e    :  1 ; /* bits 17:17 */
    ca_uint32_t CPU_REFILL_REQ_2e    :  1 ; /* bits 18:18 */
    ca_uint32_t CPU_REFILL_REQ_3e    :  1 ; /* bits 19:19 */
    ca_uint32_t CPU_REFILL_REQ_4e    :  1 ; /* bits 20:20 */
    ca_uint32_t CPU_REFILL_REQ_5e    :  1 ; /* bits 21:21 */
    ca_uint32_t CPU_REFILL_REQ_6e    :  1 ; /* bits 22:22 */
    ca_uint32_t CPU_REFILL_REQ_7e    :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd2               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_CPU_QM_INTENABLE_1_t;


#define  SATURN_GLOBAL_NETWORK_ENGINE_INTERRUPT_1        0x441000d0
#define  SATURN_GLOBAL_NETWORK_ENGINE_INTERRUPT_1_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t NIi                  :  1 ; /* bits 0:0 */
    ca_uint32_t L2FEi                :  1 ; /* bits 1:1 */
    ca_uint32_t L2TMi                :  1 ; /* bits 2:2 */
    ca_uint32_t L3TEi                :  1 ; /* bits 3:3 */
    ca_uint32_t TQMi                 :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t WOL_inti             :  1 ; /* bits 7:7 */
    ca_uint32_t XFI0_inti            :  1 ; /* bits 8:8 */
    ca_uint32_t XFI1_inti            :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd2               :  6 ;
    ca_uint32_t PTPi                 :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd3               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_NETWORK_ENGINE_INTERRUPT_1_t;


#define  SATURN_GLOBAL_NETWORK_ENGINE_INTENABLE_1        0x441000d4
#define  SATURN_GLOBAL_NETWORK_ENGINE_INTENABLE_1_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t NIe                  :  1 ; /* bits 0:0 */
    ca_uint32_t L2FEe                :  1 ; /* bits 1:1 */
    ca_uint32_t L2TMe                :  1 ; /* bits 2:2 */
    ca_uint32_t L3TEe                :  1 ; /* bits 3:3 */
    ca_uint32_t TQMe                 :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t WOL_inte             :  1 ; /* bits 7:7 */
    ca_uint32_t XFI0_inte            :  1 ; /* bits 8:8 */
    ca_uint32_t XFI1_inte            :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd2               :  6 ;
    ca_uint32_t PTPe                 :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd3               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_NETWORK_ENGINE_INTENABLE_1_t;


#define  SATURN_GLOBAL_TAROKO_INT                        0x441000d8
#define  SATURN_GLOBAL_TAROKO_INT_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t taroko0_intreq       : 14 ; /* bits 13:0 */
    ca_uint32_t sw_ext_int0          :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t taroko1_intreq       : 14 ; /* bits 29:16 */
    ca_uint32_t sw_ext_int1          :  1 ; /* bits 30:30 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_TAROKO_INT_t;


#define  SATURN_GLOBAL_TAROKO_INTENABLE                  0x441000dc
#define  SATURN_GLOBAL_TAROKO_INTENABLE_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t taroko0_inte         : 14 ; /* bits 13:0 */
    ca_uint32_t sw_ext_int0e         :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t taroko1_inte         : 14 ; /* bits 29:16 */
    ca_uint32_t sw_ext_int1e         :  1 ; /* bits 30:30 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_TAROKO_INTENABLE_t;


#define  SATURN_GLOBAL_MISC_INTERRUPT                    0x441000e0
#define  SATURN_GLOBAL_MISC_INTERRUPT_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t CPLL_LOCKi           :  1 ; /* bits 0:0 */
    ca_uint32_t sd_intri             :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_MISC_INTERRUPT_t;


#define  SATURN_GLOBAL_MISC_INTENABLE                    0x441000e4
#define  SATURN_GLOBAL_MISC_INTENABLE_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t CPLL_LOCKe           :  1 ; /* bits 0:0 */
    ca_uint32_t sd_intre             :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_MISC_INTENABLE_t;


#define  SATURN_GLOBAL_WOL_INTERRUPT                     0x441000e8
#define  SATURN_GLOBAL_WOL_INTERRUPT_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t PORT3_WOLi           :  1 ; /* bits 3:3 */
    ca_uint32_t PORT4_WOLi           :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd2               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_WOL_INTERRUPT_t;


#define  SATURN_GLOBAL_WOL_INTENABLE                     0x441000ec
#define  SATURN_GLOBAL_WOL_INTENABLE_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t PORT3_WOLe           :  1 ; /* bits 3:3 */
    ca_uint32_t PORT4_WOLe           :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd2               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_WOL_INTENABLE_t;


#define  SATURN_GLOBAL_NETWORK_ENGINE_STATUS             0x441000f0
#define  SATURN_GLOBAL_NETWORK_ENGINE_STATUS_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t l2fe_init_done       :  1 ; /* bits 0:0 */
    ca_uint32_t l2tm_init_done       :  1 ; /* bits 1:1 */
    ca_uint32_t tqm_init_done        :  1 ; /* bits 2:2 */
    ca_uint32_t tqm_glb_idle         :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_NETWORK_ENGINE_STATUS_t;


#define  SATURN_GLOBAL_JTAG_TAP_CONTROL                  0x441000f4
#define  SATURN_GLOBAL_JTAG_TAP_CONTROL_dft              0x00000002

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t enable_taroko_0      :  1 ; /* bits 1:1 */
    ca_uint32_t enable_taroko_1      :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd2               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_JTAG_TAP_CONTROL_t;


#define  SATURN_GLOBAL_SOFTWARE                          0x441000f8
#define  SATURN_GLOBAL_SOFTWARE_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_SOFTWARE_t;


#define  SATURN_GLOBAL_SOFTWARE2                         0x441000fc
#define  SATURN_GLOBAL_SOFTWARE2_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_SOFTWARE2_t;


#define  SATURN_GLOBAL_SCRATCH                           0x44100100
#define  SATURN_GLOBAL_SCRATCH_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t scratch              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_SCRATCH_t;


#define  SATURN_GLOBAL_FMRO                              0x44100104
#define  SATURN_GLOBAL_FMRO_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t fmro_sel             : 16 ; /* bits 15:0 */
    ca_uint32_t clk_sel              :  6 ; /* bits 21:16 */
    ca_uint32_t blk_sel              :  6 ; /* bits 27:22 */
    ca_uint32_t rsrvd1               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_FMRO_t;


#define  SATURN_GLOBAL_SPEED_OVERRIDE                    0x44100108
#define  SATURN_GLOBAL_SPEED_OVERRIDE_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t speed                :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t ov_enable            : 29 ; /* bits 31:3 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_SPEED_OVERRIDE_t;


#define  SATURN_GLOBAL_SD_DLL_CTRL                       0x4410010c
#define  SATURN_GLOBAL_SD_DLL_CTRL_dft                   0x00140000

typedef volatile union {
  struct {
    ca_uint32_t sd_clk_sel           :  2 ; /* bits 1:0 */
    ca_uint32_t sd_dll_reset         :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t sd_dll_shiftClk0_phaseSel :  4 ; /* bits 7:4 */
    ca_uint32_t sd_dll_shiftClk1_phaseSel :  4 ; /* bits 11:8 */
    ca_uint32_t sd_dll_shiftClk0_bypass :  1 ; /* bits 12:12 */
    ca_uint32_t sd_dll_shiftClk1_bypass :  1 ; /* bits 13:13 */
    ca_uint32_t sd_phase_reset_override :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t sd_drv_phase         :  6 ; /* bits 21:16 */
    ca_uint32_t rsrvd3               :  2 ;
    ca_uint32_t sd_sample_phase      :  7 ; /* bits 30:24 */
    ca_uint32_t rsrvd4               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_SD_DLL_CTRL_t;


#define  SATURN_GLOBAL_SD_DLL_STATUS                     0x44100110
#define  SATURN_GLOBAL_SD_DLL_STATUS_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sd_dll_state         :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t sd_dll_tapNum        :  9 ; /* bits 12:4 */
    ca_uint32_t rsrvd2               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_SD_DLL_STATUS_t;


#define  SATURN_GLOBAL_LED_CONTROL                       0x44100114
#define  SATURN_GLOBAL_LED_CONTROL_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t blink_rate_1         :  8 ; /* bits 7:0 */
    ca_uint32_t blink_rate_2         :  8 ; /* bits 15:8 */
    ca_uint32_t led_test             :  1 ; /* bits 16:16 */
    ca_uint32_t led_clk_polarity     :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 12 ;
    ca_uint32_t led_test_activity    :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_LED_CONTROL_t;


#define  SATURN_GLOBAL_LED_CONFIG_0                      0x44100118
#define  SATURN_GLOBAL_LED_CONFIG_0_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t led_event_on         :  3 ; /* bits 2:0 */
    ca_uint32_t led_event_blink      :  3 ; /* bits 5:3 */
    ca_uint32_t led_event_off        :  3 ; /* bits 8:6 */
    ca_uint32_t led_off_on           :  2 ; /* bits 10:9 */
    ca_uint32_t led_port             :  3 ; /* bits 13:11 */
    ca_uint32_t led_off_val          :  1 ; /* bits 14:14 */
    ca_uint32_t led_sw_event         :  1 ; /* bits 15:15 */
    ca_uint32_t led_blink_sel        :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_LED_CONFIG_0_t;


#define  SATURN_GLOBAL_LED_CONFIG_1                      0x4410011c
#define  SATURN_GLOBAL_LED_CONFIG_1_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t led_event_on         :  3 ; /* bits 2:0 */
    ca_uint32_t led_event_blink      :  3 ; /* bits 5:3 */
    ca_uint32_t led_event_off        :  3 ; /* bits 8:6 */
    ca_uint32_t led_off_on           :  2 ; /* bits 10:9 */
    ca_uint32_t led_port             :  3 ; /* bits 13:11 */
    ca_uint32_t led_off_val          :  1 ; /* bits 14:14 */
    ca_uint32_t led_sw_event         :  1 ; /* bits 15:15 */
    ca_uint32_t led_blink_sel        :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_LED_CONFIG_1_t;


#define  SATURN_GLOBAL_LED_CONFIG_2                      0x44100120
#define  SATURN_GLOBAL_LED_CONFIG_2_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t led_event_on         :  3 ; /* bits 2:0 */
    ca_uint32_t led_event_blink      :  3 ; /* bits 5:3 */
    ca_uint32_t led_event_off        :  3 ; /* bits 8:6 */
    ca_uint32_t led_off_on           :  2 ; /* bits 10:9 */
    ca_uint32_t led_port             :  3 ; /* bits 13:11 */
    ca_uint32_t led_off_val          :  1 ; /* bits 14:14 */
    ca_uint32_t led_sw_event         :  1 ; /* bits 15:15 */
    ca_uint32_t led_blink_sel        :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_LED_CONFIG_2_t;


#define  SATURN_GLOBAL_LED_CONFIG_3                      0x44100124
#define  SATURN_GLOBAL_LED_CONFIG_3_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t led_event_on         :  3 ; /* bits 2:0 */
    ca_uint32_t led_event_blink      :  3 ; /* bits 5:3 */
    ca_uint32_t led_event_off        :  3 ; /* bits 8:6 */
    ca_uint32_t led_off_on           :  2 ; /* bits 10:9 */
    ca_uint32_t led_port             :  3 ; /* bits 13:11 */
    ca_uint32_t led_off_val          :  1 ; /* bits 14:14 */
    ca_uint32_t led_sw_event         :  1 ; /* bits 15:15 */
    ca_uint32_t led_blink_sel        :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_LED_CONFIG_3_t;


#define  SATURN_GLOBAL_LED_CONFIG_4                      0x44100128
#define  SATURN_GLOBAL_LED_CONFIG_4_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t led_event_on         :  3 ; /* bits 2:0 */
    ca_uint32_t led_event_blink      :  3 ; /* bits 5:3 */
    ca_uint32_t led_event_off        :  3 ; /* bits 8:6 */
    ca_uint32_t led_off_on           :  2 ; /* bits 10:9 */
    ca_uint32_t led_port             :  3 ; /* bits 13:11 */
    ca_uint32_t led_off_val          :  1 ; /* bits 14:14 */
    ca_uint32_t led_sw_event         :  1 ; /* bits 15:15 */
    ca_uint32_t led_blink_sel        :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_LED_CONFIG_4_t;


#define  SATURN_GLOBAL_LED_CONFIG_5                      0x4410012c
#define  SATURN_GLOBAL_LED_CONFIG_5_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t led_event_on         :  3 ; /* bits 2:0 */
    ca_uint32_t led_event_blink      :  3 ; /* bits 5:3 */
    ca_uint32_t led_event_off        :  3 ; /* bits 8:6 */
    ca_uint32_t led_off_on           :  2 ; /* bits 10:9 */
    ca_uint32_t led_port             :  3 ; /* bits 13:11 */
    ca_uint32_t led_off_val          :  1 ; /* bits 14:14 */
    ca_uint32_t led_sw_event         :  1 ; /* bits 15:15 */
    ca_uint32_t led_blink_sel        :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_LED_CONFIG_5_t;


#define  SATURN_GLOBAL_LED_CONFIG_6                      0x44100130
#define  SATURN_GLOBAL_LED_CONFIG_6_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t led_event_on         :  3 ; /* bits 2:0 */
    ca_uint32_t led_event_blink      :  3 ; /* bits 5:3 */
    ca_uint32_t led_event_off        :  3 ; /* bits 8:6 */
    ca_uint32_t led_off_on           :  2 ; /* bits 10:9 */
    ca_uint32_t led_port             :  3 ; /* bits 13:11 */
    ca_uint32_t led_off_val          :  1 ; /* bits 14:14 */
    ca_uint32_t led_sw_event         :  1 ; /* bits 15:15 */
    ca_uint32_t led_blink_sel        :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_LED_CONFIG_6_t;


#define  SATURN_GLOBAL_LED_CONFIG_7                      0x44100134
#define  SATURN_GLOBAL_LED_CONFIG_7_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t led_event_on         :  3 ; /* bits 2:0 */
    ca_uint32_t led_event_blink      :  3 ; /* bits 5:3 */
    ca_uint32_t led_event_off        :  3 ; /* bits 8:6 */
    ca_uint32_t led_off_on           :  2 ; /* bits 10:9 */
    ca_uint32_t led_port             :  3 ; /* bits 13:11 */
    ca_uint32_t led_off_val          :  1 ; /* bits 14:14 */
    ca_uint32_t led_sw_event         :  1 ; /* bits 15:15 */
    ca_uint32_t led_blink_sel        :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_LED_CONFIG_7_t;


#define  SATURN_GLOBAL_LED_CONFIG_8                      0x44100138
#define  SATURN_GLOBAL_LED_CONFIG_8_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t led_event_on         :  3 ; /* bits 2:0 */
    ca_uint32_t led_event_blink      :  3 ; /* bits 5:3 */
    ca_uint32_t led_event_off        :  3 ; /* bits 8:6 */
    ca_uint32_t led_off_on           :  2 ; /* bits 10:9 */
    ca_uint32_t led_port             :  3 ; /* bits 13:11 */
    ca_uint32_t led_off_val          :  1 ; /* bits 14:14 */
    ca_uint32_t led_sw_event         :  1 ; /* bits 15:15 */
    ca_uint32_t led_blink_sel        :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_LED_CONFIG_8_t;


#define  SATURN_GLOBAL_LED_CONFIG_9                      0x4410013c
#define  SATURN_GLOBAL_LED_CONFIG_9_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t led_event_on         :  3 ; /* bits 2:0 */
    ca_uint32_t led_event_blink      :  3 ; /* bits 5:3 */
    ca_uint32_t led_event_off        :  3 ; /* bits 8:6 */
    ca_uint32_t led_off_on           :  2 ; /* bits 10:9 */
    ca_uint32_t led_port             :  3 ; /* bits 13:11 */
    ca_uint32_t led_off_val          :  1 ; /* bits 14:14 */
    ca_uint32_t led_sw_event         :  1 ; /* bits 15:15 */
    ca_uint32_t led_blink_sel        :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_LED_CONFIG_9_t;


#define  SATURN_GLOBAL_LED_CONFIG_10                     0x44100140
#define  SATURN_GLOBAL_LED_CONFIG_10_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t led_event_on         :  3 ; /* bits 2:0 */
    ca_uint32_t led_event_blink      :  3 ; /* bits 5:3 */
    ca_uint32_t led_event_off        :  3 ; /* bits 8:6 */
    ca_uint32_t led_off_on           :  2 ; /* bits 10:9 */
    ca_uint32_t led_port             :  3 ; /* bits 13:11 */
    ca_uint32_t led_off_val          :  1 ; /* bits 14:14 */
    ca_uint32_t led_sw_event         :  1 ; /* bits 15:15 */
    ca_uint32_t led_blink_sel        :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_LED_CONFIG_10_t;


#define  SATURN_GLOBAL_LED_CONFIG_11                     0x44100144
#define  SATURN_GLOBAL_LED_CONFIG_11_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t led_event_on         :  3 ; /* bits 2:0 */
    ca_uint32_t led_event_blink      :  3 ; /* bits 5:3 */
    ca_uint32_t led_event_off        :  3 ; /* bits 8:6 */
    ca_uint32_t led_off_on           :  2 ; /* bits 10:9 */
    ca_uint32_t led_port             :  3 ; /* bits 13:11 */
    ca_uint32_t led_off_val          :  1 ; /* bits 14:14 */
    ca_uint32_t led_sw_event         :  1 ; /* bits 15:15 */
    ca_uint32_t led_blink_sel        :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_LED_CONFIG_11_t;


#define  SATURN_GLOBAL_LED_CONFIG_12                     0x44100148
#define  SATURN_GLOBAL_LED_CONFIG_12_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t led_event_on         :  3 ; /* bits 2:0 */
    ca_uint32_t led_event_blink      :  3 ; /* bits 5:3 */
    ca_uint32_t led_event_off        :  3 ; /* bits 8:6 */
    ca_uint32_t led_off_on           :  2 ; /* bits 10:9 */
    ca_uint32_t led_port             :  3 ; /* bits 13:11 */
    ca_uint32_t led_off_val          :  1 ; /* bits 14:14 */
    ca_uint32_t led_sw_event         :  1 ; /* bits 15:15 */
    ca_uint32_t led_blink_sel        :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_LED_CONFIG_12_t;


#define  SATURN_GLOBAL_LED_CONFIG_13                     0x4410014c
#define  SATURN_GLOBAL_LED_CONFIG_13_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t led_event_on         :  3 ; /* bits 2:0 */
    ca_uint32_t led_event_blink      :  3 ; /* bits 5:3 */
    ca_uint32_t led_event_off        :  3 ; /* bits 8:6 */
    ca_uint32_t led_off_on           :  2 ; /* bits 10:9 */
    ca_uint32_t led_port             :  3 ; /* bits 13:11 */
    ca_uint32_t led_off_val          :  1 ; /* bits 14:14 */
    ca_uint32_t led_sw_event         :  1 ; /* bits 15:15 */
    ca_uint32_t led_blink_sel        :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_LED_CONFIG_13_t;


#define  SATURN_GLOBAL_LED_CONFIG_14                     0x44100150
#define  SATURN_GLOBAL_LED_CONFIG_14_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t led_event_on         :  3 ; /* bits 2:0 */
    ca_uint32_t led_event_blink      :  3 ; /* bits 5:3 */
    ca_uint32_t led_event_off        :  3 ; /* bits 8:6 */
    ca_uint32_t led_off_on           :  2 ; /* bits 10:9 */
    ca_uint32_t led_port             :  3 ; /* bits 13:11 */
    ca_uint32_t led_off_val          :  1 ; /* bits 14:14 */
    ca_uint32_t led_sw_event         :  1 ; /* bits 15:15 */
    ca_uint32_t led_blink_sel        :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_LED_CONFIG_14_t;


#define  SATURN_GLOBAL_LED_CONFIG_15                     0x44100154
#define  SATURN_GLOBAL_LED_CONFIG_15_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t led_event_on         :  3 ; /* bits 2:0 */
    ca_uint32_t led_event_blink      :  3 ; /* bits 5:3 */
    ca_uint32_t led_event_off        :  3 ; /* bits 8:6 */
    ca_uint32_t led_off_on           :  2 ; /* bits 10:9 */
    ca_uint32_t led_port             :  3 ; /* bits 13:11 */
    ca_uint32_t led_off_val          :  1 ; /* bits 14:14 */
    ca_uint32_t led_sw_event         :  1 ; /* bits 15:15 */
    ca_uint32_t led_blink_sel        :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_LED_CONFIG_15_t;


#define  SATURN_GLOBAL_SECURITY_OVERRIDE                 0x44100158
#define  SATURN_GLOBAL_SECURITY_OVERRIDE_dft             0x00f80000

typedef volatile union {
  struct {
    ca_uint32_t secure_override_ne   :  1 ; /* bits 0:0 */
    ca_uint32_t secure_override_per  :  1 ; /* bits 1:1 */
    ca_uint32_t secure_override_fbm  :  1 ; /* bits 2:2 */
    ca_uint32_t secure_override_dma  :  1 ; /* bits 3:3 */
    ca_uint32_t secure_override_ldma :  1 ; /* bits 4:4 */
    ca_uint32_t secure_override_flash :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t secure_override_capsram :  1 ; /* bits 10:10 */
    ca_uint32_t secure_override_ddr  :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t secure_override_xfi  :  1 ; /* bits 14:14 */
    ca_uint32_t secure_override_otprom :  1 ; /* bits 15:15 */
    ca_uint32_t secure_override_atu0 :  1 ; /* bits 16:16 */
    ca_uint32_t secure_override_atu1 :  1 ; /* bits 17:17 */
    ca_uint32_t otp_lock_prot_fields :  1 ; /* bits 18:18 */
    ca_uint32_t secure_override_global :  1 ; /* bits 19:19 */
    ca_uint32_t secure_override_eaxi :  1 ; /* bits 20:20 */
    ca_uint32_t secure_override_eaxiatu :  1 ; /* bits 21:21 */
    ca_uint32_t secure_override_pon  :  1 ; /* bits 22:22 */
    ca_uint32_t secure_override_clkgen :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd3               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_SECURITY_OVERRIDE_t;


#define  SATURN_GLOBAL_MASTER_OVERRIDE_SECURITY          0x4410015c
#define  SATURN_GLOBAL_MASTER_OVERRIDE_SECURITY_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t master_secure_override_ne :  1 ; /* bits 0:0 */
    ca_uint32_t master_secure_override_dma :  1 ; /* bits 1:1 */
    ca_uint32_t master_secure_override_ldma :  1 ; /* bits 2:2 */
    ca_uint32_t master_secure_override_fbm :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_MASTER_OVERRIDE_SECURITY_t;


#define  SATURN_GLOBAL_PE_ISO_MODE                       0x44100160
#define  SATURN_GLOBAL_PE_ISO_MODE_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pe_iso_mode          :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_PE_ISO_MODE_t;


#define  SATURN_GLOBAL_ROMOTP_SLV_ID                     0x44100164
#define  SATURN_GLOBAL_ROMOTP_SLV_ID_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t reg_id_entry0        :  6 ; /* bits 5:0 */
    ca_uint32_t reg_id_entry1        :  6 ; /* bits 11:6 */
    ca_uint32_t reg_id_entry2        :  6 ; /* bits 17:12 */
    ca_uint32_t reg_id_entry3        :  6 ; /* bits 23:18 */
    ca_uint32_t reg_id_en0           :  1 ; /* bits 24:24 */
    ca_uint32_t reg_id_en1           :  1 ; /* bits 25:25 */
    ca_uint32_t reg_id_en2           :  1 ; /* bits 26:26 */
    ca_uint32_t reg_id_en3           :  1 ; /* bits 27:27 */
    ca_uint32_t reg_enabled          :  1 ; /* bits 28:28 */
    ca_uint32_t rom_enabled          :  1 ; /* bits 29:29 */
    ca_uint32_t rsrvd1               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_ROMOTP_SLV_ID_t;


#define  SATURN_GLOBAL_ROMOTP_SLV_ID_MASK                0x44100168
#define  SATURN_GLOBAL_ROMOTP_SLV_ID_MASK_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t reg_id_entry_mask0   :  6 ; /* bits 5:0 */
    ca_uint32_t reg_id_entry_mask1   :  6 ; /* bits 11:6 */
    ca_uint32_t reg_id_entry_mask2   :  6 ; /* bits 17:12 */
    ca_uint32_t reg_id_entry_mask3   :  6 ; /* bits 23:18 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_ROMOTP_SLV_ID_MASK_t;


#define  SATURN_GLOBAL_BOOT_VEC_0                        0x4410016c
#define  SATURN_GLOBAL_BOOT_VEC_0_dft                    0x17ff4000

typedef volatile union {
  struct {
    ca_uint32_t global_boot_0        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_BOOT_VEC_0_t;


#define  SATURN_GLOBAL_BOOT_VEC_4                        0x44100170
#define  SATURN_GLOBAL_BOOT_VEC_4_dft                    0xd503201f

typedef volatile union {
  struct {
    ca_uint32_t global_boot_4        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_BOOT_VEC_4_t;


#define  SATURN_GLOBAL_BOOT_VEC_8                        0x44100174
#define  SATURN_GLOBAL_BOOT_VEC_8_dft                    0xd503201f

typedef volatile union {
  struct {
    ca_uint32_t global_boot_8        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_BOOT_VEC_8_t;


#define  SATURN_GLOBAL_BOOT_VEC_C                        0x44100178
#define  SATURN_GLOBAL_BOOT_VEC_C_dft                    0xd503201f

typedef volatile union {
  struct {
    ca_uint32_t global_boot_c        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_BOOT_VEC_C_t;


#define  SATURN_GLOBAL_TMS_REG_A                         0x4410017c
#define  SATURN_GLOBAL_TMS_REG_A_dft                     0x086d6b85

typedef volatile union {
  struct {
    ca_uint32_t reg_a                : 29 ; /* bits 28:0 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_TMS_REG_A_t;


#define  SATURN_GLOBAL_TMS_REG_B                         0x44100180
#define  SATURN_GLOBAL_TMS_REG_B_dft                     0x0036f2cd

typedef volatile union {
  struct {
    ca_uint32_t reg_b                : 22 ; /* bits 21:0 */
    ca_uint32_t rsrvd1               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_TMS_REG_B_t;


#define  SATURN_GLOBAL_TMS_REG_C                         0x44100184
#define  SATURN_GLOBAL_TMS_REG_C_dft                     0x0101010c

typedef volatile union {
  struct {
    ca_uint32_t rstb                 :  1 ; /* bits 0:0 */
    ca_uint32_t adccksel             :  1 ; /* bits 1:1 */
    ca_uint32_t biasdem_en           :  1 ; /* bits 2:2 */
    ca_uint32_t ppow                 :  1 ; /* bits 3:3 */
    ca_uint32_t chopen               :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t hold_dly             :  2 ; /* bits 9:8 */
    ca_uint32_t hold_en              :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd2               :  5 ;
    ca_uint32_t osr                  :  3 ; /* bits 18:16 */
    ca_uint32_t rsrvd3               :  5 ;
    ca_uint32_t chopfreqsel          :  4 ; /* bits 27:24 */
    ca_uint32_t rsrvd4               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_TMS_REG_C_t;


#define  SATURN_GLOBAL_TMS_TEMP_DATA                     0x44100188
#define  SATURN_GLOBAL_TMS_TEMP_DATA_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tm_out               : 19 ; /* bits 18:0 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_TMS_TEMP_DATA_t;


#define  SATURN_GLOBAL_TMS_ADC_DATA                      0x4410018c
#define  SATURN_GLOBAL_TMS_ADC_DATA_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t adc_out              : 22 ; /* bits 21:0 */
    ca_uint32_t rsrvd1               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_TMS_ADC_DATA_t;


#define  SATURN_GLOBAL_FUSE_CONTROL                      0x44100190
#define  SATURN_GLOBAL_FUSE_CONTROL_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t fuse_group_number    :  5 ; /* bits 4:0 */
    ca_uint32_t fuse_number          :  5 ; /* bits 9:5 */
    ca_uint32_t fuse_mr              :  1 ; /* bits 10:10 */
    ca_uint32_t fuse_do_program      :  1 ; /* bits 11:11 */
    ca_uint32_t fuse_do_read         :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd1               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_FUSE_CONTROL_t;


#define  SATURN_GLOBAL_FUSE_RESULT                       0x44100194
#define  SATURN_GLOBAL_FUSE_RESULT_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t fuse_done            :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_FUSE_RESULT_t;


#define  SATURN_GLOBAL_FUSE_VALUE                        0x44100198
#define  SATURN_GLOBAL_FUSE_VALUE_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t fuse_value           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_FUSE_VALUE_t;


#define  SATURN_GLOBAL_FUSE_PGM_TIMING                   0x4410019c
#define  SATURN_GLOBAL_FUSE_PGM_TIMING_dft               0x0aa65889

typedef volatile union {
  struct {
    ca_uint32_t fuse_COUNT_THP_CS    :  3 ; /* bits 2:0 */
    ca_uint32_t fuse_COUNT_THP_PD_PS :  3 ; /* bits 5:3 */
    ca_uint32_t fuse_COUNT_THP_PS    :  3 ; /* bits 8:6 */
    ca_uint32_t fuse_COUNT_TPGM      :  9 ; /* bits 17:9 */
    ca_uint32_t fuse_COUNT_TSUP_CS   :  3 ; /* bits 20:18 */
    ca_uint32_t fuse_COUNT_TSUP_PD_PS :  5 ; /* bits 25:21 */
    ca_uint32_t fuse_COUNT_TSUP_PS_CS :  3 ; /* bits 28:26 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_FUSE_PGM_TIMING_t;


#define  SATURN_GLOBAL_FUSE_READ_TIMING                  0x441001a0
#define  SATURN_GLOBAL_FUSE_READ_TIMING_dft              0x002a4cd1

typedef volatile union {
  struct {
    ca_uint32_t fuse_COUNT_THR_CS    :  3 ; /* bits 2:0 */
    ca_uint32_t fuse_COUNT_THR_PS_CS :  3 ; /* bits 5:3 */
    ca_uint32_t fuse_COUNT_TRD       :  4 ; /* bits 9:6 */
    ca_uint32_t fuse_COUNT_TSQ       :  4 ; /* bits 13:10 */
    ca_uint32_t fuse_COUNT_TSUR_CS   :  3 ; /* bits 16:14 */
    ca_uint32_t fuse_COUNT_TSUR_PD   :  5 ; /* bits 21:17 */
    ca_uint32_t rsrvd1               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_FUSE_READ_TIMING_t;


#define  SATURN_GLOBAL_SATURN_COMM                       0x441001a4
#define  SATURN_GLOBAL_SATURN_COMM_dft                   0x00000007

typedef volatile union {
  struct {
    ca_uint32_t reset_g3_com         :  1 ; /* bits 0:0 */
    ca_uint32_t g3_send_training     :  1 ; /* bits 1:1 */
    ca_uint32_t g3_get_trained       :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_SATURN_COMM_t;


#define  SATURN_GLOBAL_DSS_0_CNTL                        0x441001a8
#define  SATURN_GLOBAL_DSS_0_CNTL_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dss_rst_n            :  1 ; /* bits 0:0 */
    ca_uint32_t ro_sel               :  3 ; /* bits 3:1 */
    ca_uint32_t wire_sel             :  1 ; /* bits 4:4 */
    ca_uint32_t data_in              : 20 ; /* bits 24:5 */
    ca_uint32_t speed_en             :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_DSS_0_CNTL_t;


#define  SATURN_GLOBAL_DSS_0_STATUS                      0x441001ac
#define  SATURN_GLOBAL_DSS_0_STATUS_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ready                :  1 ; /* bits 0:0 */
    ca_uint32_t count_out            : 20 ; /* bits 20:1 */
    ca_uint32_t wsort_go             :  1 ; /* bits 21:21 */
    ca_uint32_t rsrvd1               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_DSS_0_STATUS_t;


#define  SATURN_GLOBAL_DEVICE_ASSIGN_ID1                 0x441001b0
#define  SATURN_GLOBAL_DEVICE_ASSIGN_ID1_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t device_id1           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_DEVICE_ASSIGN_ID1_t;


#define  SATURN_GLOBAL_DEVICE_ASSIGN_ID0                 0x441001b4
#define  SATURN_GLOBAL_DEVICE_ASSIGN_ID0_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t device_id0           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_DEVICE_ASSIGN_ID0_t;


#define  SATURN_GLOBAL_TAROKO_BIST_RESULT                0x441001b8
#define  SATURN_GLOBAL_TAROKO_BIST_RESULT_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t result               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_TAROKO_BIST_RESULT_t;


#define  SATURN_GLOBAL_SOFTWARE3                         0x441001bc
#define  SATURN_GLOBAL_SOFTWARE3_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_SOFTWARE3_t;


#define  SATURN_GLOBAL_SOFTWARE4                         0x441001c0
#define  SATURN_GLOBAL_SOFTWARE4_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_SOFTWARE4_t;


#define  SATURN_GLOBAL_SW_INTERRUPT_EXT_0                0x441001c4
#define  SATURN_GLOBAL_SW_INTERRUPT_EXT_0_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sw_int               :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_SW_INTERRUPT_EXT_0_t;


#define  SATURN_GLOBAL_SW_INTERRUPT_EXT_1                0x441001c8
#define  SATURN_GLOBAL_SW_INTERRUPT_EXT_1_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sw_int               :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_GLOBAL_SW_INTERRUPT_EXT_1_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* GLB */
typedef struct {
  SATURN_GLOBAL_JTAG_ID_t                         JTAG_ID;                       /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_GLOBAL_EPON_CNTL_t                       EPON_CNTL;                     /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_GLOBAL_EPON_STATUS_t                     EPON_STATUS;                   /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_GLOBAL_GPON_CNTL_t                       GPON_CNTL;                     /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_GLOBAL_OPT_MODULE_CNTL_t                 OPT_MODULE_CNTL;               /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_GLOBAL_OPT_MODULE_LAO_CNTL_t             OPT_MODULE_LAO_CNTL;           /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_GLOBAL_OPT_INTERRUPT_t                   OPT_INTERRUPT;                 /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  SATURN_GLOBAL_OPT_INTENABLE_t                   OPT_INTENABLE;                 /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  SATURN_GLOBAL_OPT_MODULE_STATUS_t               OPT_MODULE_STATUS;             /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  SATURN_GLOBAL_PON_CNTL_t                        PON_CNTL;                      /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  SATURN_GLOBAL_BLOCK_RESET_t                     BLOCK_RESET;                   /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  SATURN_GLOBAL_GPHY_STATUS_t                     GPHY_STATUS;                   /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  SATURN_GLOBAL_FABRIC_RESET_t                    FABRIC_RESET;                  /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  SATURN_GLOBAL_STRAP_t                           STRAP;                         /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  SATURN_GLOBAL_STRAP_OVERRIDE_t                  STRAP_OVERRIDE;                /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  SATURN_GLOBAL_STRAP_OVERRIDE_VALUE_t            STRAP_OVERRIDE_VALUE;          /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  SATURN_GLOBAL_BIST_RESULT_t                     BIST_RESULT;                   /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  SATURN_GLOBAL_BIST_DATA_t                       BIST_DATA;                     /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  SATURN_GLOBAL_GLOBAL_CONFIG_t                   GLOBAL_CONFIG;                 /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  SATURN_GLOBAL_PHY_CONTROL_t                     PHY_CONTROL;                   /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  SATURN_GLOBAL_PIN_MUX_t                         PIN_MUX;                       /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  SATURN_GLOBAL_IO_DRIVE_CONTROL_t                IO_DRIVE_CONTROL;              /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  SATURN_GLOBAL_GPIO_MUX_0_t                      GPIO_MUX_0;                    /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  SATURN_GLOBAL_GPIO_MUX_1_t                      GPIO_MUX_1;                    /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  SATURN_GLOBAL_GPIO_MUX_2_t                      GPIO_MUX_2;                    /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  SATURN_GLOBAL_GPIO_MUX_3_t                      GPIO_MUX_3;                    /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  SATURN_GLOBAL_GIGE_PHY_t                        GIGE_PHY;                      /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  SATURN_GLOBAL_TAROKO_STATE_t                    TAROKO_STATE;                  /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  SATURN_GLOBAL_SYSTEM_INTERRUPT_0_t              SYSTEM_INTERRUPT_0;            /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  SATURN_GLOBAL_SYSTEM_INTENABLE_0_t              SYSTEM_INTENABLE_0;            /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  SATURN_GLOBAL_SW_INTERRUPT_0_t                  SW_INTERRUPT_0;                /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  SATURN_GLOBAL_CPU_IPC_SOFT_INTERRUPT_0_t        CPU_IPC_SOFT_INTERRUPT_0;      /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  SATURN_GLOBAL_CPU_IPC_SOFT_INTENABLE_0_t        CPU_IPC_SOFT_INTENABLE_0;      /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  SATURN_GLOBAL_CPU_LSOSSPFBM_INTERRUPT_0_t       CPU_LSOSSPFBM_INTERRUPT_0;     /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  SATURN_GLOBAL_CPU_LSOSSPFBM_INTENABLE0_t        CPU_LSOSSPFBM_INTENABLE0;      /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  SATURN_GLOBAL_LDMA_INTERRUPT_0_t                LDMA_INTERRUPT_0;              /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  SATURN_GLOBAL_LDMA_INTENABLE0_t                 LDMA_INTENABLE0;               /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  SATURN_GLOBAL_CPU_QM_INTERRUPT_0_t              CPU_QM_INTERRUPT_0;            /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  SATURN_GLOBAL_CPU_QM_INTENABLE_0_t              CPU_QM_INTENABLE_0;            /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];                   
  SATURN_GLOBAL_NETWORK_ENGINE_INTERRUPT_0_t      NETWORK_ENGINE_INTERRUPT_0;    /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];                   
  SATURN_GLOBAL_NETWORK_ENGINE_INTENABLE_0_t      NETWORK_ENGINE_INTENABLE_0;    /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];                   
  SATURN_GLOBAL_SYSTEM_INTERRUPT_1_t              SYSTEM_INTERRUPT_1;            /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];                   
  SATURN_GLOBAL_SYSTEM_INTENABLE_1_t              SYSTEM_INTENABLE_1;            /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];                   
  SATURN_GLOBAL_SW_INTERRUPT_1_t                  SW_INTERRUPT_1;                /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd44[3];                   
  SATURN_GLOBAL_CPU_IPC_SOFT_INTERRUPT_1_t        CPU_IPC_SOFT_INTERRUPT_1;      /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd45[3];                   
  SATURN_GLOBAL_CPU_IPC_SOFT_INTENABLE_1_t        CPU_IPC_SOFT_INTENABLE_1;      /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd46[3];                   
  SATURN_GLOBAL_CPU_LSOSSPFBM_INTERRUPT_1_t       CPU_LSOSSPFBM_INTERRUPT_1;     /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd47[3];                   
  SATURN_GLOBAL_CPU_LSOSSPFBM_INTENABLE1_t        CPU_LSOSSPFBM_INTENABLE1;      /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd48[3];                   
  SATURN_GLOBAL_LDMA_INTERRUPT_1_t                LDMA_INTERRUPT_1;              /* addr: 0x000000c0 */
  ca_uint32_t                              rsrvd49[3];                   
  SATURN_GLOBAL_LDMA_INTENABLE1_t                 LDMA_INTENABLE1;               /* addr: 0x000000c4 */
  ca_uint32_t                              rsrvd50[3];                   
  SATURN_GLOBAL_CPU_QM_INTERRUPT_1_t              CPU_QM_INTERRUPT_1;            /* addr: 0x000000c8 */
  ca_uint32_t                              rsrvd51[3];                   
  SATURN_GLOBAL_CPU_QM_INTENABLE_1_t              CPU_QM_INTENABLE_1;            /* addr: 0x000000cc */
  ca_uint32_t                              rsrvd52[3];                   
  SATURN_GLOBAL_NETWORK_ENGINE_INTERRUPT_1_t      NETWORK_ENGINE_INTERRUPT_1;    /* addr: 0x000000d0 */
  ca_uint32_t                              rsrvd53[3];                   
  SATURN_GLOBAL_NETWORK_ENGINE_INTENABLE_1_t      NETWORK_ENGINE_INTENABLE_1;    /* addr: 0x000000d4 */
  ca_uint32_t                              rsrvd54[3];                   
  SATURN_GLOBAL_TAROKO_INT_t                      TAROKO_INT;                    /* addr: 0x000000d8 */
  ca_uint32_t                              rsrvd55[3];                   
  SATURN_GLOBAL_TAROKO_INTENABLE_t                TAROKO_INTENABLE;              /* addr: 0x000000dc */
  ca_uint32_t                              rsrvd56[3];                   
  SATURN_GLOBAL_MISC_INTERRUPT_t                  MISC_INTERRUPT;                /* addr: 0x000000e0 */
  ca_uint32_t                              rsrvd57[3];                   
  SATURN_GLOBAL_MISC_INTENABLE_t                  MISC_INTENABLE;                /* addr: 0x000000e4 */
  ca_uint32_t                              rsrvd58[3];                   
  SATURN_GLOBAL_WOL_INTERRUPT_t                   WOL_INTERRUPT;                 /* addr: 0x000000e8 */
  ca_uint32_t                              rsrvd59[3];                   
  SATURN_GLOBAL_WOL_INTENABLE_t                   WOL_INTENABLE;                 /* addr: 0x000000ec */
  ca_uint32_t                              rsrvd60[3];                   
  SATURN_GLOBAL_NETWORK_ENGINE_STATUS_t           NETWORK_ENGINE_STATUS;         /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd61[3];                   
  SATURN_GLOBAL_JTAG_TAP_CONTROL_t                JTAG_TAP_CONTROL;              /* addr: 0x000000f4 */
  ca_uint32_t                              rsrvd62[3];                   
  SATURN_GLOBAL_SOFTWARE_t                        SOFTWARE;                      /* addr: 0x000000f8 */
  ca_uint32_t                              rsrvd63[3];                   
  SATURN_GLOBAL_SOFTWARE2_t                       SOFTWARE2;                     /* addr: 0x000000fc */
  ca_uint32_t                              rsrvd64[3];                   
  SATURN_GLOBAL_SCRATCH_t                         SCRATCH;                       /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd65[3];                   
  SATURN_GLOBAL_FMRO_t                            FMRO;                          /* addr: 0x00000104 */
  ca_uint32_t                              rsrvd66[3];                   
  SATURN_GLOBAL_SPEED_OVERRIDE_t                  SPEED_OVERRIDE;                /* addr: 0x00000108 */
  ca_uint32_t                              rsrvd67[3];                   
  SATURN_GLOBAL_SD_DLL_CTRL_t                     SD_DLL_CTRL;                   /* addr: 0x0000010c */
  ca_uint32_t                              rsrvd68[3];                   
  SATURN_GLOBAL_SD_DLL_STATUS_t                   SD_DLL_STATUS;                 /* addr: 0x00000110 */
  ca_uint32_t                              rsrvd69[3];                   
  SATURN_GLOBAL_LED_CONTROL_t                     LED_CONTROL;                   /* addr: 0x00000114 */
  ca_uint32_t                              rsrvd70[3];                   
  SATURN_GLOBAL_LED_CONFIG_0_t                    LED_CONFIG_0;                  /* addr: 0x00000118 */
  ca_uint32_t                              rsrvd71[3];                   
  SATURN_GLOBAL_LED_CONFIG_1_t                    LED_CONFIG_1;                  /* addr: 0x0000011c */
  ca_uint32_t                              rsrvd72[3];                   
  SATURN_GLOBAL_LED_CONFIG_2_t                    LED_CONFIG_2;                  /* addr: 0x00000120 */
  ca_uint32_t                              rsrvd73[3];                   
  SATURN_GLOBAL_LED_CONFIG_3_t                    LED_CONFIG_3;                  /* addr: 0x00000124 */
  ca_uint32_t                              rsrvd74[3];                   
  SATURN_GLOBAL_LED_CONFIG_4_t                    LED_CONFIG_4;                  /* addr: 0x00000128 */
  ca_uint32_t                              rsrvd75[3];                   
  SATURN_GLOBAL_LED_CONFIG_5_t                    LED_CONFIG_5;                  /* addr: 0x0000012c */
  ca_uint32_t                              rsrvd76[3];                   
  SATURN_GLOBAL_LED_CONFIG_6_t                    LED_CONFIG_6;                  /* addr: 0x00000130 */
  ca_uint32_t                              rsrvd77[3];                   
  SATURN_GLOBAL_LED_CONFIG_7_t                    LED_CONFIG_7;                  /* addr: 0x00000134 */
  ca_uint32_t                              rsrvd78[3];                   
  SATURN_GLOBAL_LED_CONFIG_8_t                    LED_CONFIG_8;                  /* addr: 0x00000138 */
  ca_uint32_t                              rsrvd79[3];                   
  SATURN_GLOBAL_LED_CONFIG_9_t                    LED_CONFIG_9;                  /* addr: 0x0000013c */
  ca_uint32_t                              rsrvd80[3];                   
  SATURN_GLOBAL_LED_CONFIG_10_t                   LED_CONFIG_10;                 /* addr: 0x00000140 */
  ca_uint32_t                              rsrvd81[3];                   
  SATURN_GLOBAL_LED_CONFIG_11_t                   LED_CONFIG_11;                 /* addr: 0x00000144 */
  ca_uint32_t                              rsrvd82[3];                   
  SATURN_GLOBAL_LED_CONFIG_12_t                   LED_CONFIG_12;                 /* addr: 0x00000148 */
  ca_uint32_t                              rsrvd83[3];                   
  SATURN_GLOBAL_LED_CONFIG_13_t                   LED_CONFIG_13;                 /* addr: 0x0000014c */
  ca_uint32_t                              rsrvd84[3];                   
  SATURN_GLOBAL_LED_CONFIG_14_t                   LED_CONFIG_14;                 /* addr: 0x00000150 */
  ca_uint32_t                              rsrvd85[3];                   
  SATURN_GLOBAL_LED_CONFIG_15_t                   LED_CONFIG_15;                 /* addr: 0x00000154 */
  ca_uint32_t                              rsrvd86[3];                   
  SATURN_GLOBAL_SECURITY_OVERRIDE_t               SECURITY_OVERRIDE;             /* addr: 0x00000158 */
  ca_uint32_t                              rsrvd87[3];                   
  SATURN_GLOBAL_MASTER_OVERRIDE_SECURITY_t        MASTER_OVERRIDE_SECURITY;      /* addr: 0x0000015c */
  ca_uint32_t                              rsrvd88[3];                   
  SATURN_GLOBAL_PE_ISO_MODE_t                     PE_ISO_MODE;                   /* addr: 0x00000160 */
  ca_uint32_t                              rsrvd89[3];                   
  SATURN_GLOBAL_ROMOTP_SLV_ID_t                   ROMOTP_SLV_ID;                 /* addr: 0x00000164 */
  ca_uint32_t                              rsrvd90[3];                   
  SATURN_GLOBAL_ROMOTP_SLV_ID_MASK_t              ROMOTP_SLV_ID_MASK;            /* addr: 0x00000168 */
  ca_uint32_t                              rsrvd91[3];                   
  SATURN_GLOBAL_BOOT_VEC_0_t                      BOOT_VEC_0;                    /* addr: 0x0000016c */
  ca_uint32_t                              rsrvd92[3];                   
  SATURN_GLOBAL_BOOT_VEC_4_t                      BOOT_VEC_4;                    /* addr: 0x00000170 */
  ca_uint32_t                              rsrvd93[3];                   
  SATURN_GLOBAL_BOOT_VEC_8_t                      BOOT_VEC_8;                    /* addr: 0x00000174 */
  ca_uint32_t                              rsrvd94[3];                   
  SATURN_GLOBAL_BOOT_VEC_C_t                      BOOT_VEC_C;                    /* addr: 0x00000178 */
  ca_uint32_t                              rsrvd95[3];                   
  SATURN_GLOBAL_TMS_REG_A_t                       TMS_REG_A;                     /* addr: 0x0000017c */
  ca_uint32_t                              rsrvd96[3];                   
  SATURN_GLOBAL_TMS_REG_B_t                       TMS_REG_B;                     /* addr: 0x00000180 */
  ca_uint32_t                              rsrvd97[3];                   
  SATURN_GLOBAL_TMS_REG_C_t                       TMS_REG_C;                     /* addr: 0x00000184 */
  ca_uint32_t                              rsrvd98[3];                   
  SATURN_GLOBAL_TMS_TEMP_DATA_t                   TMS_TEMP_DATA;                 /* addr: 0x00000188 */
  ca_uint32_t                              rsrvd99[3];                   
  SATURN_GLOBAL_TMS_ADC_DATA_t                    TMS_ADC_DATA;                  /* addr: 0x0000018c */
  ca_uint32_t                              rsrvd100[3];                  
  SATURN_GLOBAL_FUSE_CONTROL_t                    FUSE_CONTROL;                  /* addr: 0x00000190 */
  ca_uint32_t                              rsrvd101[3];                  
  SATURN_GLOBAL_FUSE_RESULT_t                     FUSE_RESULT;                   /* addr: 0x00000194 */
  ca_uint32_t                              rsrvd102[3];                  
  SATURN_GLOBAL_FUSE_VALUE_t                      FUSE_VALUE;                    /* addr: 0x00000198 */
  ca_uint32_t                              rsrvd103[3];                  
  SATURN_GLOBAL_FUSE_PGM_TIMING_t                 FUSE_PGM_TIMING;               /* addr: 0x0000019c */
  ca_uint32_t                              rsrvd104[3];                  
  SATURN_GLOBAL_FUSE_READ_TIMING_t                FUSE_READ_TIMING;              /* addr: 0x000001a0 */
  ca_uint32_t                              rsrvd105[3];                  
  SATURN_GLOBAL_SATURN_COMM_t                     SATURN_COMM;                   /* addr: 0x000001a4 */
  ca_uint32_t                              rsrvd106[3];                  
  SATURN_GLOBAL_DSS_0_CNTL_t                      DSS_0_CNTL;                    /* addr: 0x000001a8 */
  ca_uint32_t                              rsrvd107[3];                  
  SATURN_GLOBAL_DSS_0_STATUS_t                    DSS_0_STATUS;                  /* addr: 0x000001ac */
  ca_uint32_t                              rsrvd108[3];                  
  SATURN_GLOBAL_DEVICE_ASSIGN_ID1_t               DEVICE_ASSIGN_ID1;             /* addr: 0x000001b0 */
  ca_uint32_t                              rsrvd109[3];                  
  SATURN_GLOBAL_DEVICE_ASSIGN_ID0_t               DEVICE_ASSIGN_ID0;             /* addr: 0x000001b4 */
  ca_uint32_t                              rsrvd110[3];                  
  SATURN_GLOBAL_TAROKO_BIST_RESULT_t              TAROKO_BIST_RESULT;            /* addr: 0x000001b8 */
  ca_uint32_t                              rsrvd111[3];                  
  SATURN_GLOBAL_SOFTWARE3_t                       SOFTWARE3;                     /* addr: 0x000001bc */
  ca_uint32_t                              rsrvd112[3];                  
  SATURN_GLOBAL_SOFTWARE4_t                       SOFTWARE4;                     /* addr: 0x000001c0 */
  ca_uint32_t                              rsrvd113[3];                  
  SATURN_GLOBAL_SW_INTERRUPT_EXT_0_t              SW_INTERRUPT_EXT_0;            /* addr: 0x000001c4 */
  ca_uint32_t                              rsrvd114[3];                  
  SATURN_GLOBAL_SW_INTERRUPT_EXT_1_t              SW_INTERRUPT_EXT_1;            /* addr: 0x000001c8 */
} SATURN_APB2_GLB_t;


/*
 * PE_TAROKO_ATU
 */
  
/*
 * TAROKO0_ATU
 */
        
#define  SATURN_PE_TAROKO_ATU_TAROKO0_ATU_CTL            0x44101100
#define  SATURN_PE_TAROKO_ATU_TAROKO0_ATU_CTL_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t enable               :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 16 ;
    ca_uint32_t idx                  :  6 ; /* bits 29:24 */
    ca_uint32_t r                    :  1 ; /* bits 30:30 */
    ca_uint32_t w                    :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PE_TAROKO_ATU_TAROKO0_ATU_CTL_t;


#define  SATURN_PE_TAROKO_ATU_TAROKO0_ATU_DATA0          0x44101104
#define  SATURN_PE_TAROKO_ATU_TAROKO0_ATU_DATA0_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr_input_comp      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PE_TAROKO_ATU_TAROKO0_ATU_DATA0_t;


#define  SATURN_PE_TAROKO_ATU_TAROKO0_ATU_DATA1          0x44101108
#define  SATURN_PE_TAROKO_ATU_TAROKO0_ATU_DATA1_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr_input_mask      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PE_TAROKO_ATU_TAROKO0_ATU_DATA1_t;


#define  SATURN_PE_TAROKO_ATU_TAROKO0_ATU_DATA2          0x4410110c
#define  SATURN_PE_TAROKO_ATU_TAROKO0_ATU_DATA2_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr_output_value    : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PE_TAROKO_ATU_TAROKO0_ATU_DATA2_t;


#define  SATURN_PE_TAROKO_ATU_TAROKO0_ATU_DATA3          0x44101110
#define  SATURN_PE_TAROKO_ATU_TAROKO0_ATU_DATA3_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t arprot               :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t awprot               :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t arqos                :  4 ; /* bits 11:8 */
    ca_uint32_t awqos                :  4 ; /* bits 15:12 */
    ca_uint32_t arcache              :  4 ; /* bits 19:16 */
    ca_uint32_t awcache              :  4 ; /* bits 23:20 */
    ca_uint32_t user_en              :  1 ; /* bits 24:24 */
    ca_uint32_t prot_en              :  1 ; /* bits 25:25 */
    ca_uint32_t cache_en             :  1 ; /* bits 26:26 */
    ca_uint32_t qos_en               :  1 ; /* bits 27:27 */
    ca_uint32_t rsrvd3               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PE_TAROKO_ATU_TAROKO0_ATU_DATA3_t;


#define  SATURN_PE_TAROKO_ATU_TAROKO0_ATU_DATA4          0x44101114
#define  SATURN_PE_TAROKO_ATU_TAROKO0_ATU_DATA4_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t aruser               : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PE_TAROKO_ATU_TAROKO0_ATU_DATA4_t;


#define  SATURN_PE_TAROKO_ATU_TAROKO0_ATU_DATA5          0x44101118
#define  SATURN_PE_TAROKO_ATU_TAROKO0_ATU_DATA5_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t awuser               : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PE_TAROKO_ATU_TAROKO0_ATU_DATA5_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* TAROKO0_ATU */
typedef struct {
  SATURN_PE_TAROKO_ATU_TAROKO0_ATU_CTL_t          CTL;                           /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_PE_TAROKO_ATU_TAROKO0_ATU_DATA0_t        DATA0;                         /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_PE_TAROKO_ATU_TAROKO0_ATU_DATA1_t        DATA1;                         /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_PE_TAROKO_ATU_TAROKO0_ATU_DATA2_t        DATA2;                         /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_PE_TAROKO_ATU_TAROKO0_ATU_DATA3_t        DATA3;                         /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_PE_TAROKO_ATU_TAROKO0_ATU_DATA4_t        DATA4;                         /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_PE_TAROKO_ATU_TAROKO0_ATU_DATA5_t        DATA5;                         /* addr: 0x00000018 */
} SATURN_APB2_PE_TAROKO_ATU_TAROKO0_ATU_t;


/*
 * TAROKO1_ATU
 */
        
#define  SATURN_PE_TAROKO_ATU_TAROKO1_ATU_CTL            0x44101200
#define  SATURN_PE_TAROKO_ATU_TAROKO1_ATU_CTL_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t enable               :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 16 ;
    ca_uint32_t idx                  :  6 ; /* bits 29:24 */
    ca_uint32_t r                    :  1 ; /* bits 30:30 */
    ca_uint32_t w                    :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PE_TAROKO_ATU_TAROKO1_ATU_CTL_t;


#define  SATURN_PE_TAROKO_ATU_TAROKO1_ATU_DATA0          0x44101204
#define  SATURN_PE_TAROKO_ATU_TAROKO1_ATU_DATA0_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr_input_comp      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PE_TAROKO_ATU_TAROKO1_ATU_DATA0_t;


#define  SATURN_PE_TAROKO_ATU_TAROKO1_ATU_DATA1          0x44101208
#define  SATURN_PE_TAROKO_ATU_TAROKO1_ATU_DATA1_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr_input_mask      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PE_TAROKO_ATU_TAROKO1_ATU_DATA1_t;


#define  SATURN_PE_TAROKO_ATU_TAROKO1_ATU_DATA2          0x4410120c
#define  SATURN_PE_TAROKO_ATU_TAROKO1_ATU_DATA2_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr_output_value    : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PE_TAROKO_ATU_TAROKO1_ATU_DATA2_t;


#define  SATURN_PE_TAROKO_ATU_TAROKO1_ATU_DATA3          0x44101210
#define  SATURN_PE_TAROKO_ATU_TAROKO1_ATU_DATA3_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t arprot               :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t awprot               :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t arqos                :  4 ; /* bits 11:8 */
    ca_uint32_t awqos                :  4 ; /* bits 15:12 */
    ca_uint32_t arcache              :  4 ; /* bits 19:16 */
    ca_uint32_t awcache              :  4 ; /* bits 23:20 */
    ca_uint32_t user_en              :  1 ; /* bits 24:24 */
    ca_uint32_t prot_en              :  1 ; /* bits 25:25 */
    ca_uint32_t cache_en             :  1 ; /* bits 26:26 */
    ca_uint32_t qos_en               :  1 ; /* bits 27:27 */
    ca_uint32_t rsrvd3               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PE_TAROKO_ATU_TAROKO1_ATU_DATA3_t;


#define  SATURN_PE_TAROKO_ATU_TAROKO1_ATU_DATA4          0x44101214
#define  SATURN_PE_TAROKO_ATU_TAROKO1_ATU_DATA4_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t aruser               : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PE_TAROKO_ATU_TAROKO1_ATU_DATA4_t;


#define  SATURN_PE_TAROKO_ATU_TAROKO1_ATU_DATA5          0x44101218
#define  SATURN_PE_TAROKO_ATU_TAROKO1_ATU_DATA5_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t awuser               : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PE_TAROKO_ATU_TAROKO1_ATU_DATA5_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* TAROKO1_ATU */
typedef struct {
  SATURN_PE_TAROKO_ATU_TAROKO1_ATU_CTL_t          CTL;                           /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_PE_TAROKO_ATU_TAROKO1_ATU_DATA0_t        DATA0;                         /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_PE_TAROKO_ATU_TAROKO1_ATU_DATA1_t        DATA1;                         /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_PE_TAROKO_ATU_TAROKO1_ATU_DATA2_t        DATA2;                         /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_PE_TAROKO_ATU_TAROKO1_ATU_DATA3_t        DATA3;                         /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_PE_TAROKO_ATU_TAROKO1_ATU_DATA4_t        DATA4;                         /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_PE_TAROKO_ATU_TAROKO1_ATU_DATA5_t        DATA5;                         /* addr: 0x00000018 */
} SATURN_APB2_PE_TAROKO_ATU_TAROKO1_ATU_t;

    
  
        
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PE_TAROKO_ATU */

typedef struct {
  ca_uint32_t                              rsrvd1[256];                  
  SATURN_APB2_PE_TAROKO_ATU_TAROKO0_ATU_t         TAROKO0_ATU;                   /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd2[243];                  
  SATURN_APB2_PE_TAROKO_ATU_TAROKO1_ATU_t         TAROKO1_ATU;                   /* addr: 0x00000200 */
} SATURN_APB2_PE_TAROKO_ATU_t;


/*
 * CAPSRAM
 */
        
#define  SATURN_CAPSRAM_TZCONTROL                        0x44102000
#define  SATURN_CAPSRAM_TZCONTROL_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t SEGSECURE            : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_CAPSRAM_TZCONTROL_t;


#define  SATURN_CAPSRAM_INIT                             0x44102004
#define  SATURN_CAPSRAM_INIT_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t INIT                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_CAPSRAM_INIT_t;


#define  SATURN_CAPSRAM_INITRANGE                        0x44102008
#define  SATURN_CAPSRAM_INITRANGE_dft                    0x1fff0000

typedef volatile union {
  struct {
    ca_uint32_t MIN                  : 13 ; /* bits 12:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t MAX                  : 13 ; /* bits 28:16 */
    ca_uint32_t rsrvd2               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_CAPSRAM_INITRANGE_t;


#define  SATURN_CAPSRAM_SRAMBAD0                         0x4410200c
#define  SATURN_CAPSRAM_SRAMBAD0_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ADDR                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_CAPSRAM_SRAMBAD0_t;


#define  SATURN_CAPSRAM_SRAMBAD1                         0x44102010
#define  SATURN_CAPSRAM_SRAMBAD1_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t BURST                :  2 ; /* bits 1:0 */
    ca_uint32_t SIZE                 :  3 ; /* bits 4:2 */
    ca_uint32_t PROT                 :  3 ; /* bits 7:5 */
    ca_uint32_t LEN                  :  4 ; /* bits 11:8 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t ID                   : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_CAPSRAM_SRAMBAD1_t;


#define  SATURN_CAPSRAM_SRAMBAD2                         0x44102014
#define  SATURN_CAPSRAM_SRAMBAD2_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t VALID                :  1 ; /* bits 0:0 */
    ca_uint32_t INST                 :  3 ; /* bits 3:1 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t VEC                  :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd2               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_CAPSRAM_SRAMBAD2_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* CAPSRAM */
typedef struct {
  SATURN_CAPSRAM_TZCONTROL_t                      TZCONTROL;                     /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_CAPSRAM_INIT_t                           INIT;                          /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_CAPSRAM_INITRANGE_t                      INITRANGE;                     /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_CAPSRAM_SRAMBAD0_t                       SRAMBAD0;                      /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_CAPSRAM_SRAMBAD1_t                       SRAMBAD1;                      /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_CAPSRAM_SRAMBAD2_t                       SRAMBAD2;                      /* addr: 0x00000014 */
} SATURN_APB2_CAPSRAM_t;


/*
 * LDMA
 */
  
/*
 * LDMA_GLB
 */
        
#define  SATURN_LDMA_LDMA_GLB_LDMA_CONTROL               0x44103000
#define  SATURN_LDMA_LDMA_GLB_LDMA_CONTROL_dft           0x00000080

typedef volatile union {
  struct {
    ca_uint32_t awuser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t ace_cmd              :  1 ; /* bits 3:3 */
    ca_uint32_t aruser_idx           :  3 ; /* bits 6:4 */
    ca_uint32_t bkt_sel              :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t lpae_en              :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_LDMA_CONTROL_t;


#define  SATURN_LDMA_LDMA_GLB_LDMA_RATE_LIMITER          0x44103004
#define  SATURN_LDMA_LDMA_GLB_LDMA_RATE_LIMITER_dft      0x00800400

typedef volatile union {
  struct {
    ca_uint32_t period               : 16 ; /* bits 15:0 */
    ca_uint32_t credit               : 12 ; /* bits 27:16 */
    ca_uint32_t rsrvd1               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_LDMA_RATE_LIMITER_t;


#define  SATURN_LDMA_LDMA_GLB_LDMA_RATE_LIMITER_UB       0x44103008
#define  SATURN_LDMA_LDMA_GLB_LDMA_RATE_LIMITER_UB_dft   0x00000fff

typedef volatile union {
  struct {
    ca_uint32_t upperbound           : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_LDMA_RATE_LIMITER_UB_t;


#define  SATURN_LDMA_LDMA_GLB_LDMA_BKT0_DWRR             0x4410300c
#define  SATURN_LDMA_LDMA_GLB_LDMA_BKT0_DWRR_dft         0x7fff1000

typedef volatile union {
  struct {
    ca_uint32_t quantum_size         : 16 ; /* bits 15:0 */
    ca_uint32_t dc_upperbound        : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd1               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_LDMA_BKT0_DWRR_t;


#define  SATURN_LDMA_LDMA_GLB_LDMA_BKT1_DWRR             0x44103010
#define  SATURN_LDMA_LDMA_GLB_LDMA_BKT1_DWRR_dft         0x7fff1000

typedef volatile union {
  struct {
    ca_uint32_t quantum_size         : 16 ; /* bits 15:0 */
    ca_uint32_t dc_upperbound        : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd1               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_LDMA_BKT1_DWRR_t;


#define  SATURN_LDMA_LDMA_GLB_MEM_START_ADDR_SEG_0       0x44103014
#define  SATURN_LDMA_LDMA_GLB_MEM_START_ADDR_SEG_0_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t aruser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t bkt_sel              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_start_addr       : 20 ; /* bits 23:4 */
    ca_uint32_t seg_start_addr_lpae  :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_MEM_START_ADDR_SEG_0_t;


#define  SATURN_LDMA_LDMA_GLB_MEM_END_ADDR_SEG_0         0x44103018
#define  SATURN_LDMA_LDMA_GLB_MEM_END_ADDR_SEG_0_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t awuser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t ace_cmd              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_end_addr         : 20 ; /* bits 23:4 */
    ca_uint32_t seg_end_addr_lpae    :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_MEM_END_ADDR_SEG_0_t;


#define  SATURN_LDMA_LDMA_GLB_MEM_START_ADDR_SEG_1       0x4410301c
#define  SATURN_LDMA_LDMA_GLB_MEM_START_ADDR_SEG_1_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t aruser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t bkt_sel              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_start_addr       : 20 ; /* bits 23:4 */
    ca_uint32_t seg_start_addr_lpae  :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_MEM_START_ADDR_SEG_1_t;


#define  SATURN_LDMA_LDMA_GLB_MEM_END_ADDR_SEG_1         0x44103020
#define  SATURN_LDMA_LDMA_GLB_MEM_END_ADDR_SEG_1_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t awuser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t ace_cmd              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_end_addr         : 20 ; /* bits 23:4 */
    ca_uint32_t seg_end_addr_lpae    :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_MEM_END_ADDR_SEG_1_t;


#define  SATURN_LDMA_LDMA_GLB_MEM_START_ADDR_SEG_2       0x44103024
#define  SATURN_LDMA_LDMA_GLB_MEM_START_ADDR_SEG_2_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t aruser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t bkt_sel              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_start_addr       : 20 ; /* bits 23:4 */
    ca_uint32_t seg_start_addr_lpae  :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_MEM_START_ADDR_SEG_2_t;


#define  SATURN_LDMA_LDMA_GLB_MEM_END_ADDR_SEG_2         0x44103028
#define  SATURN_LDMA_LDMA_GLB_MEM_END_ADDR_SEG_2_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t awuser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t ace_cmd              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_end_addr         : 20 ; /* bits 23:4 */
    ca_uint32_t seg_end_addr_lpae    :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_MEM_END_ADDR_SEG_2_t;


#define  SATURN_LDMA_LDMA_GLB_MEM_START_ADDR_SEG_3       0x4410302c
#define  SATURN_LDMA_LDMA_GLB_MEM_START_ADDR_SEG_3_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t aruser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t bkt_sel              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_start_addr       : 20 ; /* bits 23:4 */
    ca_uint32_t seg_start_addr_lpae  :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_MEM_START_ADDR_SEG_3_t;


#define  SATURN_LDMA_LDMA_GLB_MEM_END_ADDR_SEG_3         0x44103030
#define  SATURN_LDMA_LDMA_GLB_MEM_END_ADDR_SEG_3_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t awuser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t ace_cmd              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_end_addr         : 20 ; /* bits 23:4 */
    ca_uint32_t seg_end_addr_lpae    :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_MEM_END_ADDR_SEG_3_t;


#define  SATURN_LDMA_LDMA_GLB_MEM_START_ADDR_SEG_4       0x44103034
#define  SATURN_LDMA_LDMA_GLB_MEM_START_ADDR_SEG_4_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t aruser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t bkt_sel              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_start_addr       : 20 ; /* bits 23:4 */
    ca_uint32_t seg_start_addr_lpae  :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_MEM_START_ADDR_SEG_4_t;


#define  SATURN_LDMA_LDMA_GLB_MEM_END_ADDR_SEG_4         0x44103038
#define  SATURN_LDMA_LDMA_GLB_MEM_END_ADDR_SEG_4_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t awuser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t ace_cmd              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_end_addr         : 20 ; /* bits 23:4 */
    ca_uint32_t seg_end_addr_lpae    :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_MEM_END_ADDR_SEG_4_t;


#define  SATURN_LDMA_LDMA_GLB_MEM_START_ADDR_SEG_5       0x4410303c
#define  SATURN_LDMA_LDMA_GLB_MEM_START_ADDR_SEG_5_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t aruser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t bkt_sel              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_start_addr       : 20 ; /* bits 23:4 */
    ca_uint32_t seg_start_addr_lpae  :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_MEM_START_ADDR_SEG_5_t;


#define  SATURN_LDMA_LDMA_GLB_MEM_END_ADDR_SEG_5         0x44103040
#define  SATURN_LDMA_LDMA_GLB_MEM_END_ADDR_SEG_5_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t awuser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t ace_cmd              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_end_addr         : 20 ; /* bits 23:4 */
    ca_uint32_t seg_end_addr_lpae    :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_MEM_END_ADDR_SEG_5_t;


#define  SATURN_LDMA_LDMA_GLB_MEM_START_ADDR_SEG_6       0x44103044
#define  SATURN_LDMA_LDMA_GLB_MEM_START_ADDR_SEG_6_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t aruser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t bkt_sel              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_start_addr       : 20 ; /* bits 23:4 */
    ca_uint32_t seg_start_addr_lpae  :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_MEM_START_ADDR_SEG_6_t;


#define  SATURN_LDMA_LDMA_GLB_MEM_END_ADDR_SEG_6         0x44103048
#define  SATURN_LDMA_LDMA_GLB_MEM_END_ADDR_SEG_6_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t awuser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t ace_cmd              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_end_addr         : 20 ; /* bits 23:4 */
    ca_uint32_t seg_end_addr_lpae    :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_MEM_END_ADDR_SEG_6_t;


#define  SATURN_LDMA_LDMA_GLB_MEM_START_ADDR_SEG_7       0x4410304c
#define  SATURN_LDMA_LDMA_GLB_MEM_START_ADDR_SEG_7_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t aruser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t bkt_sel              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_start_addr       : 20 ; /* bits 23:4 */
    ca_uint32_t seg_start_addr_lpae  :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_MEM_START_ADDR_SEG_7_t;


#define  SATURN_LDMA_LDMA_GLB_MEM_END_ADDR_SEG_7         0x44103050
#define  SATURN_LDMA_LDMA_GLB_MEM_END_ADDR_SEG_7_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t awuser_idx           :  3 ; /* bits 2:0 */
    ca_uint32_t ace_cmd              :  1 ; /* bits 3:3 */
    ca_uint32_t seg_end_addr         : 20 ; /* bits 23:4 */
    ca_uint32_t seg_end_addr_lpae    :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_MEM_END_ADDR_SEG_7_t;


#define  SATURN_LDMA_LDMA_GLB_AXPATTEN_0                 0x44103054
#define  SATURN_LDMA_LDMA_GLB_AXPATTEN_0_dft             0x00800000

typedef volatile union {
  struct {
    ca_uint32_t ax_user              : 14 ; /* bits 13:0 */
    ca_uint32_t ax_cache             :  4 ; /* bits 17:14 */
    ca_uint32_t ax_qos               :  4 ; /* bits 21:18 */
    ca_uint32_t ax_prot              :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_AXPATTEN_0_t;


#define  SATURN_LDMA_LDMA_GLB_AXPATTEN_1                 0x44103058
#define  SATURN_LDMA_LDMA_GLB_AXPATTEN_1_dft             0x00800000

typedef volatile union {
  struct {
    ca_uint32_t ax_user              : 14 ; /* bits 13:0 */
    ca_uint32_t ax_cache             :  4 ; /* bits 17:14 */
    ca_uint32_t ax_qos               :  4 ; /* bits 21:18 */
    ca_uint32_t ax_prot              :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_AXPATTEN_1_t;


#define  SATURN_LDMA_LDMA_GLB_AXPATTEN_2                 0x4410305c
#define  SATURN_LDMA_LDMA_GLB_AXPATTEN_2_dft             0x00800000

typedef volatile union {
  struct {
    ca_uint32_t ax_user              : 14 ; /* bits 13:0 */
    ca_uint32_t ax_cache             :  4 ; /* bits 17:14 */
    ca_uint32_t ax_qos               :  4 ; /* bits 21:18 */
    ca_uint32_t ax_prot              :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_AXPATTEN_2_t;


#define  SATURN_LDMA_LDMA_GLB_AXPATTEN_3                 0x44103060
#define  SATURN_LDMA_LDMA_GLB_AXPATTEN_3_dft             0x00800000

typedef volatile union {
  struct {
    ca_uint32_t ax_user              : 14 ; /* bits 13:0 */
    ca_uint32_t ax_cache             :  4 ; /* bits 17:14 */
    ca_uint32_t ax_qos               :  4 ; /* bits 21:18 */
    ca_uint32_t ax_prot              :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_AXPATTEN_3_t;


#define  SATURN_LDMA_LDMA_GLB_AXPATTEN_4                 0x44103064
#define  SATURN_LDMA_LDMA_GLB_AXPATTEN_4_dft             0x00800000

typedef volatile union {
  struct {
    ca_uint32_t ax_user              : 14 ; /* bits 13:0 */
    ca_uint32_t ax_cache             :  4 ; /* bits 17:14 */
    ca_uint32_t ax_qos               :  4 ; /* bits 21:18 */
    ca_uint32_t ax_prot              :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_AXPATTEN_4_t;


#define  SATURN_LDMA_LDMA_GLB_AXPATTEN_5                 0x44103068
#define  SATURN_LDMA_LDMA_GLB_AXPATTEN_5_dft             0x00800000

typedef volatile union {
  struct {
    ca_uint32_t ax_user              : 14 ; /* bits 13:0 */
    ca_uint32_t ax_cache             :  4 ; /* bits 17:14 */
    ca_uint32_t ax_qos               :  4 ; /* bits 21:18 */
    ca_uint32_t ax_prot              :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_AXPATTEN_5_t;


#define  SATURN_LDMA_LDMA_GLB_AXPATTEN_6                 0x4410306c
#define  SATURN_LDMA_LDMA_GLB_AXPATTEN_6_dft             0x00800000

typedef volatile union {
  struct {
    ca_uint32_t ax_user              : 14 ; /* bits 13:0 */
    ca_uint32_t ax_cache             :  4 ; /* bits 17:14 */
    ca_uint32_t ax_qos               :  4 ; /* bits 21:18 */
    ca_uint32_t ax_prot              :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_AXPATTEN_6_t;


#define  SATURN_LDMA_LDMA_GLB_AXPATTEN_7                 0x44103070
#define  SATURN_LDMA_LDMA_GLB_AXPATTEN_7_dft             0x00800000

typedef volatile union {
  struct {
    ca_uint32_t ax_user              : 14 ; /* bits 13:0 */
    ca_uint32_t ax_cache             :  4 ; /* bits 17:14 */
    ca_uint32_t ax_qos               :  4 ; /* bits 21:18 */
    ca_uint32_t ax_prot              :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_AXPATTEN_7_t;


#define  SATURN_LDMA_LDMA_GLB_QUEUE_ASSIGN_REGISTER      0x44103074
#define  SATURN_LDMA_LDMA_GLB_QUEUE_ASSIGN_REGISTER_dft  0x0000ff00

typedef volatile union {
  struct {
    ca_uint32_t q0_sel               :  1 ; /* bits 0:0 */
    ca_uint32_t q1_sel               :  1 ; /* bits 1:1 */
    ca_uint32_t q2_sel               :  1 ; /* bits 2:2 */
    ca_uint32_t q3_sel               :  1 ; /* bits 3:3 */
    ca_uint32_t q4_sel               :  1 ; /* bits 4:4 */
    ca_uint32_t q5_sel               :  1 ; /* bits 5:5 */
    ca_uint32_t q6_sel               :  1 ; /* bits 6:6 */
    ca_uint32_t q7_sel               :  1 ; /* bits 7:7 */
    ca_uint32_t q8_sel               :  1 ; /* bits 8:8 */
    ca_uint32_t q9_sel               :  1 ; /* bits 9:9 */
    ca_uint32_t q10_sel              :  1 ; /* bits 10:10 */
    ca_uint32_t q11_sel              :  1 ; /* bits 11:11 */
    ca_uint32_t q12_sel              :  1 ; /* bits 12:12 */
    ca_uint32_t q13_sel              :  1 ; /* bits 13:13 */
    ca_uint32_t q14_sel              :  1 ; /* bits 14:14 */
    ca_uint32_t q15_sel              :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_QUEUE_ASSIGN_REGISTER_t;


#define  SATURN_LDMA_LDMA_GLB_FAST_Q_ASSIGN_REGISTER     0x44103078
#define  SATURN_LDMA_LDMA_GLB_FAST_Q_ASSIGN_REGISTER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t PE0_QA               :  4 ; /* bits 3:0 */
    ca_uint32_t PE0_QA_en            :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t PE0_QB               :  4 ; /* bits 11:8 */
    ca_uint32_t PE0_QB_en            :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t PE1_QA               :  4 ; /* bits 19:16 */
    ca_uint32_t PE1_QA_en            :  1 ; /* bits 20:20 */
    ca_uint32_t rsrvd3               :  3 ;
    ca_uint32_t PE1_QB               :  4 ; /* bits 27:24 */
    ca_uint32_t PE1_QB_en            :  1 ; /* bits 28:28 */
    ca_uint32_t rsrvd4               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_FAST_Q_ASSIGN_REGISTER_t;


#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE0_DEFICIT_COUNTER_REGISTER 0x4410307c
#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE0_DEFICIT_COUNTER_REGISTER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE0_DEFICIT_COUNTER_REGISTER_t;


#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE1_DEFICIT_COUNTER_REGISTER 0x44103080
#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE1_DEFICIT_COUNTER_REGISTER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE1_DEFICIT_COUNTER_REGISTER_t;


#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE2_DEFICIT_COUNTER_REGISTER 0x44103084
#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE2_DEFICIT_COUNTER_REGISTER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE2_DEFICIT_COUNTER_REGISTER_t;


#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE3_DEFICIT_COUNTER_REGISTER 0x44103088
#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE3_DEFICIT_COUNTER_REGISTER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE3_DEFICIT_COUNTER_REGISTER_t;


#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE4_DEFICIT_COUNTER_REGISTER 0x4410308c
#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE4_DEFICIT_COUNTER_REGISTER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE4_DEFICIT_COUNTER_REGISTER_t;


#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE5_DEFICIT_COUNTER_REGISTER 0x44103090
#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE5_DEFICIT_COUNTER_REGISTER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE5_DEFICIT_COUNTER_REGISTER_t;


#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE6_DEFICIT_COUNTER_REGISTER 0x44103094
#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE6_DEFICIT_COUNTER_REGISTER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE6_DEFICIT_COUNTER_REGISTER_t;


#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE7_DEFICIT_COUNTER_REGISTER 0x44103098
#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE7_DEFICIT_COUNTER_REGISTER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE7_DEFICIT_COUNTER_REGISTER_t;


#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE8_DEFICIT_COUNTER_REGISTER 0x4410309c
#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE8_DEFICIT_COUNTER_REGISTER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE8_DEFICIT_COUNTER_REGISTER_t;


#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE9_DEFICIT_COUNTER_REGISTER 0x441030a0
#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE9_DEFICIT_COUNTER_REGISTER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE9_DEFICIT_COUNTER_REGISTER_t;


#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE10_DEFICIT_COUNTER_REGISTER 0x441030a4
#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE10_DEFICIT_COUNTER_REGISTER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE10_DEFICIT_COUNTER_REGISTER_t;


#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE11_DEFICIT_COUNTER_REGISTER 0x441030a8
#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE11_DEFICIT_COUNTER_REGISTER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE11_DEFICIT_COUNTER_REGISTER_t;


#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE12_DEFICIT_COUNTER_REGISTER 0x441030ac
#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE12_DEFICIT_COUNTER_REGISTER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE12_DEFICIT_COUNTER_REGISTER_t;


#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE13_DEFICIT_COUNTER_REGISTER 0x441030b0
#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE13_DEFICIT_COUNTER_REGISTER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE13_DEFICIT_COUNTER_REGISTER_t;


#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE14_DEFICIT_COUNTER_REGISTER 0x441030b4
#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE14_DEFICIT_COUNTER_REGISTER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE14_DEFICIT_COUNTER_REGISTER_t;


#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE15_DEFICIT_COUNTER_REGISTER 0x441030b8
#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE15_DEFICIT_COUNTER_REGISTER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE15_DEFICIT_COUNTER_REGISTER_t;


#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE0_DEFICIT_COUNTER_REGISTER 0x441030bc
#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE0_DEFICIT_COUNTER_REGISTER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE0_DEFICIT_COUNTER_REGISTER_t;


#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE1_DEFICIT_COUNTER_REGISTER 0x441030c0
#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE1_DEFICIT_COUNTER_REGISTER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE1_DEFICIT_COUNTER_REGISTER_t;


#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE2_DEFICIT_COUNTER_REGISTER 0x441030c4
#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE2_DEFICIT_COUNTER_REGISTER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE2_DEFICIT_COUNTER_REGISTER_t;


#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE3_DEFICIT_COUNTER_REGISTER 0x441030c8
#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE3_DEFICIT_COUNTER_REGISTER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE3_DEFICIT_COUNTER_REGISTER_t;


#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE4_DEFICIT_COUNTER_REGISTER 0x441030cc
#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE4_DEFICIT_COUNTER_REGISTER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE4_DEFICIT_COUNTER_REGISTER_t;


#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE5_DEFICIT_COUNTER_REGISTER 0x441030d0
#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE5_DEFICIT_COUNTER_REGISTER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE5_DEFICIT_COUNTER_REGISTER_t;


#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE6_DEFICIT_COUNTER_REGISTER 0x441030d4
#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE6_DEFICIT_COUNTER_REGISTER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE6_DEFICIT_COUNTER_REGISTER_t;


#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE7_DEFICIT_COUNTER_REGISTER 0x441030d8
#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE7_DEFICIT_COUNTER_REGISTER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE7_DEFICIT_COUNTER_REGISTER_t;


#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE8_DEFICIT_COUNTER_REGISTER 0x441030dc
#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE8_DEFICIT_COUNTER_REGISTER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE8_DEFICIT_COUNTER_REGISTER_t;


#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE9_DEFICIT_COUNTER_REGISTER 0x441030e0
#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE9_DEFICIT_COUNTER_REGISTER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE9_DEFICIT_COUNTER_REGISTER_t;


#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE10_DEFICIT_COUNTER_REGISTER 0x441030e4
#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE10_DEFICIT_COUNTER_REGISTER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE10_DEFICIT_COUNTER_REGISTER_t;


#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE11_DEFICIT_COUNTER_REGISTER 0x441030e8
#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE11_DEFICIT_COUNTER_REGISTER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE11_DEFICIT_COUNTER_REGISTER_t;


#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE12_DEFICIT_COUNTER_REGISTER 0x441030ec
#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE12_DEFICIT_COUNTER_REGISTER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE12_DEFICIT_COUNTER_REGISTER_t;


#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE13_DEFICIT_COUNTER_REGISTER 0x441030f0
#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE13_DEFICIT_COUNTER_REGISTER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE13_DEFICIT_COUNTER_REGISTER_t;


#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE14_DEFICIT_COUNTER_REGISTER 0x441030f4
#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE14_DEFICIT_COUNTER_REGISTER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE14_DEFICIT_COUNTER_REGISTER_t;


#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE15_DEFICIT_COUNTER_REGISTER 0x441030f8
#define  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE15_DEFICIT_COUNTER_REGISTER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE15_DEFICIT_COUNTER_REGISTER_t;


#define  SATURN_LDMA_LDMA_GLB_DBG_2NDLEVEL_BUCKET0_DEFICIT_COUNTER_REGISTER 0x441030fc
#define  SATURN_LDMA_LDMA_GLB_DBG_2NDLEVEL_BUCKET0_DEFICIT_COUNTER_REGISTER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_DBG_2NDLEVEL_BUCKET0_DEFICIT_COUNTER_REGISTER_t;


#define  SATURN_LDMA_LDMA_GLB_DBG_2NDLEVEL_BUCKET1_DEFICIT_COUNTER_REGISTER 0x44103100
#define  SATURN_LDMA_LDMA_GLB_DBG_2NDLEVEL_BUCKET1_DEFICIT_COUNTER_REGISTER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wch_dc               : 16 ; /* bits 15:0 */
    ca_uint32_t rch_dc               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_GLB_DBG_2NDLEVEL_BUCKET1_DEFICIT_COUNTER_REGISTER_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* LDMA_GLB */
typedef struct {
  SATURN_LDMA_LDMA_GLB_LDMA_CONTROL_t             LDMA_CONTROL;                  /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_LDMA_LDMA_GLB_LDMA_RATE_LIMITER_t        LDMA_RATE_LIMITER;             /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_LDMA_LDMA_GLB_LDMA_RATE_LIMITER_UB_t     LDMA_RATE_LIMITER_UB;          /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_LDMA_LDMA_GLB_LDMA_BKT0_DWRR_t           LDMA_BKT0_DWRR;                /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_LDMA_LDMA_GLB_LDMA_BKT1_DWRR_t           LDMA_BKT1_DWRR;                /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_LDMA_LDMA_GLB_MEM_START_ADDR_SEG_0_t     MEM_START_ADDR_SEG_0;          /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_LDMA_LDMA_GLB_MEM_END_ADDR_SEG_0_t       MEM_END_ADDR_SEG_0;            /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  SATURN_LDMA_LDMA_GLB_MEM_START_ADDR_SEG_1_t     MEM_START_ADDR_SEG_1;          /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  SATURN_LDMA_LDMA_GLB_MEM_END_ADDR_SEG_1_t       MEM_END_ADDR_SEG_1;            /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  SATURN_LDMA_LDMA_GLB_MEM_START_ADDR_SEG_2_t     MEM_START_ADDR_SEG_2;          /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  SATURN_LDMA_LDMA_GLB_MEM_END_ADDR_SEG_2_t       MEM_END_ADDR_SEG_2;            /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  SATURN_LDMA_LDMA_GLB_MEM_START_ADDR_SEG_3_t     MEM_START_ADDR_SEG_3;          /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  SATURN_LDMA_LDMA_GLB_MEM_END_ADDR_SEG_3_t       MEM_END_ADDR_SEG_3;            /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  SATURN_LDMA_LDMA_GLB_MEM_START_ADDR_SEG_4_t     MEM_START_ADDR_SEG_4;          /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  SATURN_LDMA_LDMA_GLB_MEM_END_ADDR_SEG_4_t       MEM_END_ADDR_SEG_4;            /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  SATURN_LDMA_LDMA_GLB_MEM_START_ADDR_SEG_5_t     MEM_START_ADDR_SEG_5;          /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  SATURN_LDMA_LDMA_GLB_MEM_END_ADDR_SEG_5_t       MEM_END_ADDR_SEG_5;            /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  SATURN_LDMA_LDMA_GLB_MEM_START_ADDR_SEG_6_t     MEM_START_ADDR_SEG_6;          /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  SATURN_LDMA_LDMA_GLB_MEM_END_ADDR_SEG_6_t       MEM_END_ADDR_SEG_6;            /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  SATURN_LDMA_LDMA_GLB_MEM_START_ADDR_SEG_7_t     MEM_START_ADDR_SEG_7;          /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  SATURN_LDMA_LDMA_GLB_MEM_END_ADDR_SEG_7_t       MEM_END_ADDR_SEG_7;            /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  SATURN_LDMA_LDMA_GLB_AXPATTEN_0_t               AXPATTEN_0;                    /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  SATURN_LDMA_LDMA_GLB_AXPATTEN_1_t               AXPATTEN_1;                    /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  SATURN_LDMA_LDMA_GLB_AXPATTEN_2_t               AXPATTEN_2;                    /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  SATURN_LDMA_LDMA_GLB_AXPATTEN_3_t               AXPATTEN_3;                    /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  SATURN_LDMA_LDMA_GLB_AXPATTEN_4_t               AXPATTEN_4;                    /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  SATURN_LDMA_LDMA_GLB_AXPATTEN_5_t               AXPATTEN_5;                    /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  SATURN_LDMA_LDMA_GLB_AXPATTEN_6_t               AXPATTEN_6;                    /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  SATURN_LDMA_LDMA_GLB_AXPATTEN_7_t               AXPATTEN_7;                    /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  SATURN_LDMA_LDMA_GLB_QUEUE_ASSIGN_REGISTER_t    QUEUE_ASSIGN_REGISTER;         /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  SATURN_LDMA_LDMA_GLB_FAST_Q_ASSIGN_REGISTER_t   FAST_Q_ASSIGN_REGISTER;        /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE0_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET0_QUEUE0_DEFICIT_COUNTER_REGISTER; /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE1_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET0_QUEUE1_DEFICIT_COUNTER_REGISTER; /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE2_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET0_QUEUE2_DEFICIT_COUNTER_REGISTER; /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE3_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET0_QUEUE3_DEFICIT_COUNTER_REGISTER; /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE4_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET0_QUEUE4_DEFICIT_COUNTER_REGISTER; /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE5_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET0_QUEUE5_DEFICIT_COUNTER_REGISTER; /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE6_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET0_QUEUE6_DEFICIT_COUNTER_REGISTER; /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE7_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET0_QUEUE7_DEFICIT_COUNTER_REGISTER; /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];                   
  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE8_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET0_QUEUE8_DEFICIT_COUNTER_REGISTER; /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];                   
  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE9_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET0_QUEUE9_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];                   
  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE10_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET0_QUEUE10_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];                   
  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE11_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET0_QUEUE11_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];                   
  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE12_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET0_QUEUE12_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd44[3];                   
  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE13_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET0_QUEUE13_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd45[3];                   
  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE14_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET0_QUEUE14_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd46[3];                   
  SATURN_LDMA_LDMA_GLB_DBG_BUCKET0_QUEUE15_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET0_QUEUE15_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd47[3];                   
  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE0_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET1_QUEUE0_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd48[3];                   
  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE1_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET1_QUEUE1_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000c0 */
  ca_uint32_t                              rsrvd49[3];                   
  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE2_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET1_QUEUE2_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000c4 */
  ca_uint32_t                              rsrvd50[3];                   
  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE3_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET1_QUEUE3_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000c8 */
  ca_uint32_t                              rsrvd51[3];                   
  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE4_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET1_QUEUE4_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000cc */
  ca_uint32_t                              rsrvd52[3];                   
  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE5_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET1_QUEUE5_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000d0 */
  ca_uint32_t                              rsrvd53[3];                   
  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE6_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET1_QUEUE6_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000d4 */
  ca_uint32_t                              rsrvd54[3];                   
  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE7_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET1_QUEUE7_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000d8 */
  ca_uint32_t                              rsrvd55[3];                   
  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE8_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET1_QUEUE8_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000dc */
  ca_uint32_t                              rsrvd56[3];                   
  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE9_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET1_QUEUE9_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000e0 */
  ca_uint32_t                              rsrvd57[3];                   
  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE10_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET1_QUEUE10_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000e4 */
  ca_uint32_t                              rsrvd58[3];                   
  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE11_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET1_QUEUE11_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000e8 */
  ca_uint32_t                              rsrvd59[3];                   
  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE12_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET1_QUEUE12_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000ec */
  ca_uint32_t                              rsrvd60[3];                   
  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE13_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET1_QUEUE13_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd61[3];                   
  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE14_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET1_QUEUE14_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000f4 */
  ca_uint32_t                              rsrvd62[3];                   
  SATURN_LDMA_LDMA_GLB_DBG_BUCKET1_QUEUE15_DEFICIT_COUNTER_REGISTER_t DBG_BUCKET1_QUEUE15_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000f8 */
  ca_uint32_t                              rsrvd63[3];                   
  SATURN_LDMA_LDMA_GLB_DBG_2NDLEVEL_BUCKET0_DEFICIT_COUNTER_REGISTER_t DBG_2NDLEVEL_BUCKET0_DEFICIT_COUNTER_REGISTER; /* addr: 0x000000fc */
  ca_uint32_t                              rsrvd64[3];                   
  SATURN_LDMA_LDMA_GLB_DBG_2NDLEVEL_BUCKET1_DEFICIT_COUNTER_REGISTER_t DBG_2NDLEVEL_BUCKET1_DEFICIT_COUNTER_REGISTER; /* addr: 0x00000100 */
} SATURN_APB2_LDMA_LDMA_GLB_t;


/*
 * AXIM2
 */
        
#define  SATURN_LDMA_AXIM2_CONFIG                        0x441031a0
#define  SATURN_LDMA_AXIM2_CONFIG_dft                    0x00000200

typedef volatile union {
  struct {
    ca_uint32_t axi_write_outtrans_num :  4 ; /* bits 3:0 */
    ca_uint32_t axi_read_outtrans_num :  4 ; /* bits 7:4 */
    ca_uint32_t axi_xbus_len         :  3 ; /* bits 10:8 */
    ca_uint32_t write_cacheline_trans_en :  1 ; /* bits 11:11 */
    ca_uint32_t write_cacheline_trans_size :  1 ; /* bits 12:12 */
    ca_uint32_t read_cacheline_trans_en :  1 ; /* bits 13:13 */
    ca_uint32_t read_cacheline_trans_size :  1 ; /* bits 14:14 */
    ca_uint32_t arcache_eos_en       :  1 ; /* bits 15:15 */
    ca_uint32_t awcache_eos_en       :  1 ; /* bits 16:16 */
    ca_uint32_t reserved             : 15 ; /* bits 31:17 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_AXIM2_CONFIG_t;


#define  SATURN_LDMA_AXIM2_TIMEOUT_THRESHOLD             0x441031a4
#define  SATURN_LDMA_AXIM2_TIMEOUT_THRESHOLD_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t read_channel_threshold :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t write_channel_threshold :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd2               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_AXIM2_TIMEOUT_THRESHOLD_t;


#define  SATURN_LDMA_AXIM2_INTERRUPT_STATUS              0x441031a8
#define  SATURN_LDMA_AXIM2_INTERRUPT_STATUS_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t read_trans_resp_timeout_int :  1 ; /* bits 0:0 */
    ca_uint32_t read_trans_resp_err_int :  1 ; /* bits 1:1 */
    ca_uint32_t write_trans_resp_timeout_int :  1 ; /* bits 2:2 */
    ca_uint32_t write_trans_resp_err_int :  1 ; /* bits 3:3 */
    ca_uint32_t read_trans_resp_ace_err_int :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_AXIM2_INTERRUPT_STATUS_t;


#define  SATURN_LDMA_AXIM2_INTERRUPT_ENABLE              0x441031ac
#define  SATURN_LDMA_AXIM2_INTERRUPT_ENABLE_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t read_trans_resp_timeout_int_en :  1 ; /* bits 0:0 */
    ca_uint32_t read_trans_resp_err_int_en :  1 ; /* bits 1:1 */
    ca_uint32_t write_trans_resp_timeout_int_en :  1 ; /* bits 2:2 */
    ca_uint32_t write_trans_resp_err_int_en :  1 ; /* bits 3:3 */
    ca_uint32_t read_trans_resp_ace_err_int_en :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_AXIM2_INTERRUPT_ENABLE_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* AXIM2 */
typedef struct {
  SATURN_LDMA_AXIM2_CONFIG_t                      CONFIG;                        /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_LDMA_AXIM2_TIMEOUT_THRESHOLD_t           TIMEOUT_THRESHOLD;             /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_LDMA_AXIM2_INTERRUPT_STATUS_t            INTERRUPT_STATUS;              /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_LDMA_AXIM2_INTERRUPT_ENABLE_t            INTERRUPT_ENABLE;              /* addr: 0x0000000c */
} SATURN_APB2_LDMA_AXIM2_t;


/*
 * LDMA_QUEUE[0..15]
 */
        
#define  SATURN_LDMA_LDMA_QUEUE_DESCRIPTOR_ACCESS        0x44103200
#define  SATURN_LDMA_LDMA_QUEUE_DESCRIPTOR_ACCESS_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t desc_idx             :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t debug_mode           :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd2               : 21 ;
    ca_uint32_t wrd_n                :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_QUEUE_DESCRIPTOR_ACCESS_t;


#define  SATURN_LDMA_LDMA_QUEUE_DESCRIPTOR_DATA2         0x44103204
#define  SATURN_LDMA_LDMA_QUEUE_DESCRIPTOR_DATA2_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t length               : 12 ; /* bits 11:0 */
    ca_uint32_t rd_cmd_only          :  1 ; /* bits 12:12 */
    ca_uint32_t rd_trn_only          :  1 ; /* bits 13:13 */
    ca_uint32_t wr_zero_trn          :  1 ; /* bits 14:14 */
    ca_uint32_t ioc                  :  1 ; /* bits 15:15 */
    ca_uint32_t dst_addr_lpae        :  8 ; /* bits 23:16 */
    ca_uint32_t src_addr_lpae        :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_QUEUE_DESCRIPTOR_DATA2_t;


#define  SATURN_LDMA_LDMA_QUEUE_DESCRIPTOR_DATA1         0x44103208
#define  SATURN_LDMA_LDMA_QUEUE_DESCRIPTOR_DATA1_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dst_addr             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_QUEUE_DESCRIPTOR_DATA1_t;


#define  SATURN_LDMA_LDMA_QUEUE_DESCRIPTOR_DATA0         0x4410320c
#define  SATURN_LDMA_LDMA_QUEUE_DESCRIPTOR_DATA0_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t src_addr             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_QUEUE_DESCRIPTOR_DATA0_t;


#define  SATURN_LDMA_LDMA_QUEUE_CONTROL_REGISTER         0x44103210
#define  SATURN_LDMA_LDMA_QUEUE_CONTROL_REGISTER_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t clsc_timer           : 16 ; /* bits 15:0 */
    ca_uint32_t clsc_threshold       :  4 ; /* bits 19:16 */
    ca_uint32_t wr_threshold         :  4 ; /* bits 23:20 */
    ca_uint32_t wch_axi_error        :  1 ; /* bits 24:24 */
    ca_uint32_t rch_axi_error        :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t reset                :  1 ; /* bits 28:28 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t en                   :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_QUEUE_CONTROL_REGISTER_t;


#define  SATURN_LDMA_LDMA_QUEUE_DWRR_REGISTER            0x44103214
#define  SATURN_LDMA_LDMA_QUEUE_DWRR_REGISTER_dft        0x7fff1000

typedef volatile union {
  struct {
    ca_uint32_t quantum_size         : 16 ; /* bits 15:0 */
    ca_uint32_t dc_upperbound        : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd1               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_QUEUE_DWRR_REGISTER_t;


#define  SATURN_LDMA_LDMA_QUEUE_INTERRUPT_ENABLE         0x44103218
#define  SATURN_LDMA_LDMA_QUEUE_INTERRUPT_ENABLE_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dd_en                :  1 ; /* bits 0:0 */
    ca_uint32_t fov_en               :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_QUEUE_INTERRUPT_ENABLE_t;


#define  SATURN_LDMA_LDMA_QUEUE_INTERRUPT_STATUS         0x4410321c
#define  SATURN_LDMA_LDMA_QUEUE_INTERRUPT_STATUS_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t descriptor_done      :  1 ; /* bits 0:0 */
    ca_uint32_t fifo_overflow        :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_QUEUE_INTERRUPT_STATUS_t;


#define  SATURN_LDMA_LDMA_QUEUE_POINTER_REGISTER         0x44103220
#define  SATURN_LDMA_LDMA_QUEUE_POINTER_REGISTER_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wr_ptr               :  4 ; /* bits 3:0 */
    ca_uint32_t rd_trans_rdptr       :  4 ; /* bits 7:4 */
    ca_uint32_t rd_trans_wrptr       :  4 ; /* bits 11:8 */
    ca_uint32_t wr_trans_rdptr       :  4 ; /* bits 15:12 */
    ca_uint32_t rd_ptr               :  4 ; /* bits 19:16 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t desc_depth           :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd2               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_QUEUE_POINTER_REGISTER_t;

    
#define  SATURN_APB2_LDMA_LDMA_QUEUE_STRIDE              64
#define  SATURN_APB2_LDMA_LDMA_QUEUE_COUNT               16
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* LDMA_QUEUE */
typedef struct {
  SATURN_LDMA_LDMA_QUEUE_DESCRIPTOR_ACCESS_t      DESCRIPTOR_ACCESS;             /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_LDMA_LDMA_QUEUE_DESCRIPTOR_DATA2_t       DESCRIPTOR_DATA2;              /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_LDMA_LDMA_QUEUE_DESCRIPTOR_DATA1_t       DESCRIPTOR_DATA1;              /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_LDMA_LDMA_QUEUE_DESCRIPTOR_DATA0_t       DESCRIPTOR_DATA0;              /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_LDMA_LDMA_QUEUE_CONTROL_REGISTER_t       CONTROL_REGISTER;              /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_LDMA_LDMA_QUEUE_DWRR_REGISTER_t          DWRR_REGISTER;                 /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_LDMA_LDMA_QUEUE_INTERRUPT_ENABLE_t       INTERRUPT_ENABLE;              /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  SATURN_LDMA_LDMA_QUEUE_INTERRUPT_STATUS_t       INTERRUPT_STATUS;              /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  SATURN_LDMA_LDMA_QUEUE_POINTER_REGISTER_t       POINTER_REGISTER;              /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[31];                   
} SATURN_APB2_LDMA_LDMA_QUEUE_t;


/*
 * LDMA_INTERRUPT_MUX
 */
        
#define  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ0_ENABLE      0x44103600
#define  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ0_ENABLE_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ0_ENABLE_t;


#define  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ0_STATUS      0x44103604
#define  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ0_STATUS_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ0_STATUS_t;


#define  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ1_ENABLE      0x44103608
#define  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ1_ENABLE_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ1_ENABLE_t;


#define  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ1_STATUS      0x4410360c
#define  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ1_STATUS_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ1_STATUS_t;


#define  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ2_ENABLE      0x44103610
#define  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ2_ENABLE_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ2_ENABLE_t;


#define  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ2_STATUS      0x44103614
#define  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ2_STATUS_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ2_STATUS_t;


#define  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ3_ENABLE      0x44103618
#define  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ3_ENABLE_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ3_ENABLE_t;


#define  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ3_STATUS      0x4410361c
#define  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ3_STATUS_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ3_STATUS_t;


#define  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ4_ENABLE      0x44103620
#define  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ4_ENABLE_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ4_ENABLE_t;


#define  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ4_STATUS      0x44103624
#define  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ4_STATUS_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ4_STATUS_t;


#define  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ5_ENABLE      0x44103628
#define  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ5_ENABLE_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ5_ENABLE_t;


#define  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ5_STATUS      0x4410362c
#define  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ5_STATUS_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ5_STATUS_t;


#define  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ6_ENABLE      0x44103630
#define  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ6_ENABLE_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ6_ENABLE_t;


#define  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ6_STATUS      0x44103634
#define  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ6_STATUS_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ6_STATUS_t;


#define  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ7_ENABLE      0x44103638
#define  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ7_ENABLE_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ7_ENABLE_t;


#define  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ7_STATUS      0x4410363c
#define  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ7_STATUS_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ7_STATUS_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* LDMA_INTERRUPT_MUX */
typedef struct {
  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ0_ENABLE_t    IRQ0_ENABLE;                   /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ0_STATUS_t    IRQ0_STATUS;                   /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ1_ENABLE_t    IRQ1_ENABLE;                   /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ1_STATUS_t    IRQ1_STATUS;                   /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ2_ENABLE_t    IRQ2_ENABLE;                   /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ2_STATUS_t    IRQ2_STATUS;                   /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ3_ENABLE_t    IRQ3_ENABLE;                   /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ3_STATUS_t    IRQ3_STATUS;                   /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ4_ENABLE_t    IRQ4_ENABLE;                   /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ4_STATUS_t    IRQ4_STATUS;                   /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ5_ENABLE_t    IRQ5_ENABLE;                   /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ5_STATUS_t    IRQ5_STATUS;                   /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ6_ENABLE_t    IRQ6_ENABLE;                   /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ6_STATUS_t    IRQ6_STATUS;                   /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ7_ENABLE_t    IRQ7_ENABLE;                   /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  SATURN_LDMA_LDMA_INTERRUPT_MUX_IRQ7_STATUS_t    IRQ7_STATUS;                   /* addr: 0x0000003c */
} SATURN_APB2_LDMA_LDMA_INTERRUPT_MUX_t;

    
  
        
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* LDMA */

typedef struct {
  SATURN_APB2_LDMA_LDMA_GLB_t                     LDMA_GLB;                      /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[287];                  
  SATURN_APB2_LDMA_AXIM2_t                        AXIM2;                         /* addr: 0x000001a0 */
  ca_uint32_t                              rsrvd2[89];                   
  SATURN_APB2_LDMA_LDMA_QUEUE_t                   LDMA_QUEUE[16];                /* addr: 0x00000200 */
  SATURN_APB2_LDMA_LDMA_INTERRUPT_MUX_t           LDMA_INTERRUPT_MUX;            /* addr: 0x00000600 */
} SATURN_APB2_LDMA_t;


/*
 * LDMA_RCPU
 */
  
/*
 * LDMA_QUEUE[0..15]
 */
        
#define  SATURN_LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_ACCESS   0x44104200
#define  SATURN_LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t desc_idx             :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t debug_mode           :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd2               : 21 ;
    ca_uint32_t wrd_n                :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_ACCESS_t;


#define  SATURN_LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA2    0x44104204
#define  SATURN_LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA2_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t length               : 12 ; /* bits 11:0 */
    ca_uint32_t rd_cmd_only          :  1 ; /* bits 12:12 */
    ca_uint32_t rd_trn_only          :  1 ; /* bits 13:13 */
    ca_uint32_t wr_zero_trn          :  1 ; /* bits 14:14 */
    ca_uint32_t ioc                  :  1 ; /* bits 15:15 */
    ca_uint32_t dst_addr_lpae        :  8 ; /* bits 23:16 */
    ca_uint32_t src_addr_lpae        :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA2_t;


#define  SATURN_LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA1    0x44104208
#define  SATURN_LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dst_addr             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA1_t;


#define  SATURN_LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA0    0x4410420c
#define  SATURN_LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t src_addr             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA0_t;


#define  SATURN_LDMA_RCPU_LDMA_QUEUE_CONTROL_REGISTER    0x44104210
#define  SATURN_LDMA_RCPU_LDMA_QUEUE_CONTROL_REGISTER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t clsc_timer           : 16 ; /* bits 15:0 */
    ca_uint32_t clsc_threshold       :  4 ; /* bits 19:16 */
    ca_uint32_t wr_threshold         :  4 ; /* bits 23:20 */
    ca_uint32_t wch_axi_error        :  1 ; /* bits 24:24 */
    ca_uint32_t rch_axi_error        :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t reset                :  1 ; /* bits 28:28 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t en                   :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_RCPU_LDMA_QUEUE_CONTROL_REGISTER_t;


#define  SATURN_LDMA_RCPU_LDMA_QUEUE_DWRR_REGISTER       0x44104214
#define  SATURN_LDMA_RCPU_LDMA_QUEUE_DWRR_REGISTER_dft   0x7fff1000

typedef volatile union {
  struct {
    ca_uint32_t quantum_size         : 16 ; /* bits 15:0 */
    ca_uint32_t dc_upperbound        : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd1               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_RCPU_LDMA_QUEUE_DWRR_REGISTER_t;


#define  SATURN_LDMA_RCPU_LDMA_QUEUE_INTERRUPT_ENABLE    0x44104218
#define  SATURN_LDMA_RCPU_LDMA_QUEUE_INTERRUPT_ENABLE_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dd_en                :  1 ; /* bits 0:0 */
    ca_uint32_t fov_en               :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_RCPU_LDMA_QUEUE_INTERRUPT_ENABLE_t;


#define  SATURN_LDMA_RCPU_LDMA_QUEUE_INTERRUPT_STATUS    0x4410421c
#define  SATURN_LDMA_RCPU_LDMA_QUEUE_INTERRUPT_STATUS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t descriptor_done      :  1 ; /* bits 0:0 */
    ca_uint32_t fifo_overflow        :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_RCPU_LDMA_QUEUE_INTERRUPT_STATUS_t;


#define  SATURN_LDMA_RCPU_LDMA_QUEUE_POINTER_REGISTER    0x44104220
#define  SATURN_LDMA_RCPU_LDMA_QUEUE_POINTER_REGISTER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wr_ptr               :  4 ; /* bits 3:0 */
    ca_uint32_t rd_trans_rdptr       :  4 ; /* bits 7:4 */
    ca_uint32_t rd_trans_wrptr       :  4 ; /* bits 11:8 */
    ca_uint32_t wr_trans_rdptr       :  4 ; /* bits 15:12 */
    ca_uint32_t rd_ptr               :  4 ; /* bits 19:16 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t desc_depth           :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd2               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_RCPU_LDMA_QUEUE_POINTER_REGISTER_t;

    
#define  SATURN_APB2_LDMA_RCPU_LDMA_QUEUE_STRIDE         64
#define  SATURN_APB2_LDMA_RCPU_LDMA_QUEUE_COUNT          16
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* LDMA_QUEUE */
typedef struct {
  SATURN_LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_ACCESS_t DESCRIPTOR_ACCESS;             /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA2_t  DESCRIPTOR_DATA2;              /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA1_t  DESCRIPTOR_DATA1;              /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_LDMA_RCPU_LDMA_QUEUE_DESCRIPTOR_DATA0_t  DESCRIPTOR_DATA0;              /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_LDMA_RCPU_LDMA_QUEUE_CONTROL_REGISTER_t  CONTROL_REGISTER;              /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_LDMA_RCPU_LDMA_QUEUE_DWRR_REGISTER_t     DWRR_REGISTER;                 /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_LDMA_RCPU_LDMA_QUEUE_INTERRUPT_ENABLE_t  INTERRUPT_ENABLE;              /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  SATURN_LDMA_RCPU_LDMA_QUEUE_INTERRUPT_STATUS_t  INTERRUPT_STATUS;              /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  SATURN_LDMA_RCPU_LDMA_QUEUE_POINTER_REGISTER_t  POINTER_REGISTER;              /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[31];                   
} SATURN_APB2_LDMA_RCPU_LDMA_QUEUE_t;


/*
 * LDMA_INTERRUPT_MUX
 */
        
#define  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ0_ENABLE 0x44104600
#define  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ0_ENABLE_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ0_ENABLE_t;


#define  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ0_STATUS 0x44104604
#define  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ0_STATUS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ0_STATUS_t;


#define  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ1_ENABLE 0x44104608
#define  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ1_ENABLE_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ1_ENABLE_t;


#define  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ1_STATUS 0x4410460c
#define  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ1_STATUS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ1_STATUS_t;


#define  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ2_ENABLE 0x44104610
#define  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ2_ENABLE_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ2_ENABLE_t;


#define  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ2_STATUS 0x44104614
#define  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ2_STATUS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ2_STATUS_t;


#define  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ3_ENABLE 0x44104618
#define  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ3_ENABLE_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ3_ENABLE_t;


#define  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ3_STATUS 0x4410461c
#define  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ3_STATUS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ3_STATUS_t;


#define  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ4_ENABLE 0x44104620
#define  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ4_ENABLE_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ4_ENABLE_t;


#define  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ4_STATUS 0x44104624
#define  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ4_STATUS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ4_STATUS_t;


#define  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ5_ENABLE 0x44104628
#define  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ5_ENABLE_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ5_ENABLE_t;


#define  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ5_STATUS 0x4410462c
#define  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ5_STATUS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ5_STATUS_t;


#define  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ6_ENABLE 0x44104630
#define  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ6_ENABLE_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ6_ENABLE_t;


#define  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ6_STATUS 0x44104634
#define  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ6_STATUS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ6_STATUS_t;


#define  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ7_ENABLE 0x44104638
#define  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ7_ENABLE_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Q0_en                :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_en                :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_en                :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_en                :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_en                :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_en                :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_en                :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_en                :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_en                :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_en                :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_en               :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_en               :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_en               :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_en               :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_en               :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_en               :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_en    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ7_ENABLE_t;


#define  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ7_STATUS 0x4410463c
#define  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ7_STATUS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Q0_status            :  1 ; /* bits 0:0 */
    ca_uint32_t Q1_status            :  1 ; /* bits 1:1 */
    ca_uint32_t Q2_status            :  1 ; /* bits 2:2 */
    ca_uint32_t Q3_status            :  1 ; /* bits 3:3 */
    ca_uint32_t Q4_status            :  1 ; /* bits 4:4 */
    ca_uint32_t Q5_status            :  1 ; /* bits 5:5 */
    ca_uint32_t Q6_status            :  1 ; /* bits 6:6 */
    ca_uint32_t Q7_status            :  1 ; /* bits 7:7 */
    ca_uint32_t Q8_status            :  1 ; /* bits 8:8 */
    ca_uint32_t Q9_status            :  1 ; /* bits 9:9 */
    ca_uint32_t Q10_status           :  1 ; /* bits 10:10 */
    ca_uint32_t Q11_status           :  1 ; /* bits 11:11 */
    ca_uint32_t Q12_status           :  1 ; /* bits 12:12 */
    ca_uint32_t Q13_status           :  1 ; /* bits 13:13 */
    ca_uint32_t Q14_status           :  1 ; /* bits 14:14 */
    ca_uint32_t Q15_status           :  1 ; /* bits 15:15 */
    ca_uint32_t axi_master_irq_status :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ7_STATUS_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* LDMA_INTERRUPT_MUX */
typedef struct {
  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ0_ENABLE_t IRQ0_ENABLE;                   /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ0_STATUS_t IRQ0_STATUS;                   /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ1_ENABLE_t IRQ1_ENABLE;                   /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ1_STATUS_t IRQ1_STATUS;                   /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ2_ENABLE_t IRQ2_ENABLE;                   /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ2_STATUS_t IRQ2_STATUS;                   /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ3_ENABLE_t IRQ3_ENABLE;                   /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ3_STATUS_t IRQ3_STATUS;                   /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ4_ENABLE_t IRQ4_ENABLE;                   /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ4_STATUS_t IRQ4_STATUS;                   /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ5_ENABLE_t IRQ5_ENABLE;                   /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ5_STATUS_t IRQ5_STATUS;                   /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ6_ENABLE_t IRQ6_ENABLE;                   /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ6_STATUS_t IRQ6_STATUS;                   /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ7_ENABLE_t IRQ7_ENABLE;                   /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  SATURN_LDMA_RCPU_LDMA_INTERRUPT_MUX_IRQ7_STATUS_t IRQ7_STATUS;                   /* addr: 0x0000003c */
} SATURN_APB2_LDMA_RCPU_LDMA_INTERRUPT_MUX_t;

    
  
        
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* LDMA_RCPU */

typedef struct {
  ca_uint32_t                              rsrvd1[512];                  
  SATURN_APB2_LDMA_RCPU_LDMA_QUEUE_t              LDMA_QUEUE[16];                /* addr: 0x00000200 */
  SATURN_APB2_LDMA_RCPU_LDMA_INTERRUPT_MUX_t      LDMA_INTERRUPT_MUX;            /* addr: 0x00000600 */
} SATURN_APB2_LDMA_RCPU_t;


/*
 * EAXI_WRAPPER
 */
  
/*
 * EAXI_ATU
 */
        
#define  SATURN_EAXI_WRAPPER_EAXI_ATU_CTL                0x44106000
#define  SATURN_EAXI_WRAPPER_EAXI_ATU_CTL_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t enable               :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 16 ;
    ca_uint32_t idx                  :  6 ; /* bits 29:24 */
    ca_uint32_t r                    :  1 ; /* bits 30:30 */
    ca_uint32_t w                    :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_EAXI_WRAPPER_EAXI_ATU_CTL_t;


#define  SATURN_EAXI_WRAPPER_EAXI_ATU_DATA0              0x44106004
#define  SATURN_EAXI_WRAPPER_EAXI_ATU_DATA0_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr_input_comp      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_EAXI_WRAPPER_EAXI_ATU_DATA0_t;


#define  SATURN_EAXI_WRAPPER_EAXI_ATU_DATA1              0x44106008
#define  SATURN_EAXI_WRAPPER_EAXI_ATU_DATA1_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr_input_mask      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_EAXI_WRAPPER_EAXI_ATU_DATA1_t;


#define  SATURN_EAXI_WRAPPER_EAXI_ATU_DATA2              0x4410600c
#define  SATURN_EAXI_WRAPPER_EAXI_ATU_DATA2_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr_output_value    : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_EAXI_WRAPPER_EAXI_ATU_DATA2_t;


#define  SATURN_EAXI_WRAPPER_EAXI_ATU_DATA3              0x44106010
#define  SATURN_EAXI_WRAPPER_EAXI_ATU_DATA3_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t arprot               :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t awprot               :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t arqos                :  4 ; /* bits 11:8 */
    ca_uint32_t awqos                :  4 ; /* bits 15:12 */
    ca_uint32_t arcache              :  4 ; /* bits 19:16 */
    ca_uint32_t awcache              :  4 ; /* bits 23:20 */
    ca_uint32_t user_en              :  1 ; /* bits 24:24 */
    ca_uint32_t prot_en              :  1 ; /* bits 25:25 */
    ca_uint32_t cache_en             :  1 ; /* bits 26:26 */
    ca_uint32_t qos_en               :  1 ; /* bits 27:27 */
    ca_uint32_t rsrvd3               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_EAXI_WRAPPER_EAXI_ATU_DATA3_t;


#define  SATURN_EAXI_WRAPPER_EAXI_ATU_DATA4              0x44106014
#define  SATURN_EAXI_WRAPPER_EAXI_ATU_DATA4_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t aruser               : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_EAXI_WRAPPER_EAXI_ATU_DATA4_t;


#define  SATURN_EAXI_WRAPPER_EAXI_ATU_DATA5              0x44106018
#define  SATURN_EAXI_WRAPPER_EAXI_ATU_DATA5_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t awuser               : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_EAXI_WRAPPER_EAXI_ATU_DATA5_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* EAXI_ATU */
typedef struct {
  SATURN_EAXI_WRAPPER_EAXI_ATU_CTL_t              CTL;                           /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_EAXI_WRAPPER_EAXI_ATU_DATA0_t            DATA0;                         /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_EAXI_WRAPPER_EAXI_ATU_DATA1_t            DATA1;                         /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_EAXI_WRAPPER_EAXI_ATU_DATA2_t            DATA2;                         /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_EAXI_WRAPPER_EAXI_ATU_DATA3_t            DATA3;                         /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_EAXI_WRAPPER_EAXI_ATU_DATA4_t            DATA4;                         /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_EAXI_WRAPPER_EAXI_ATU_DATA5_t            DATA5;                         /* addr: 0x00000018 */
} SATURN_APB2_EAXI_WRAPPER_EAXI_ATU_t;


/*
 * EAXI
 */
  
/*
 * EAXI
 */
        
#define  SATURN_EAXI_WRAPPER_EAXI_EAXI_CTL0              0x44106100
#define  SATURN_EAXI_WRAPPER_EAXI_EAXI_CTL0_dft          0x00000100

typedef volatile union {
  struct {
    ca_uint32_t enable               :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t slavecam             :  1 ; /* bits 8:8 */
    ca_uint32_t slavesingle          :  1 ; /* bits 9:9 */
    ca_uint32_t rxhysdis             :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd2               :  5 ;
    ca_uint32_t rxthresh             :  6 ; /* bits 21:16 */
    ca_uint32_t rsrvd3               :  2 ;
    ca_uint32_t rx2tx                :  1 ; /* bits 24:24 */
    ca_uint32_t rsrvd4               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_EAXI_WRAPPER_EAXI_EAXI_CTL0_t;


#define  SATURN_EAXI_WRAPPER_EAXI_EAXI_CTL1              0x44106104
#define  SATURN_EAXI_WRAPPER_EAXI_EAXI_CTL1_dft          0x03020100

typedef volatile union {
  struct {
    ca_uint32_t id0mux               :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t id1mux               :  4 ; /* bits 11:8 */
    ca_uint32_t rsrvd2               :  4 ;
    ca_uint32_t id2mux               :  4 ; /* bits 19:16 */
    ca_uint32_t rsrvd3               :  4 ;
    ca_uint32_t id3mux               :  4 ; /* bits 27:24 */
    ca_uint32_t rsrvd4               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_EAXI_WRAPPER_EAXI_EAXI_CTL1_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* EAXI */
typedef struct {
  SATURN_EAXI_WRAPPER_EAXI_EAXI_CTL0_t            CTL0;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_EAXI_WRAPPER_EAXI_EAXI_CTL1_t            CTL1;                          /* addr: 0x00000004 */
} SATURN_APB2_EAXI_WRAPPER_EAXI_EAXI_t;


/*
 * EAXI_TX
 */
        
#define  SATURN_EAXI_WRAPPER_EAXI_EAXI_TX_TXCTL          0x44106110
#define  SATURN_EAXI_WRAPPER_EAXI_EAXI_TX_TXCTL_dft      0x01001100

typedef volatile union {
  struct {
    ca_uint32_t txqos                :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t mingap               :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t chmingap             :  3 ; /* bits 14:12 */
    ca_uint32_t rsrvd3               :  9 ;
    ca_uint32_t invert               :  1 ; /* bits 24:24 */
    ca_uint32_t tx2rx                :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd4               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_EAXI_WRAPPER_EAXI_EAXI_TX_TXCTL_t;


#define  SATURN_EAXI_WRAPPER_EAXI_EAXI_TX_REMAP0         0x44106114
#define  SATURN_EAXI_WRAPPER_EAXI_EAXI_TX_REMAP0_STRIDE  4
#define  SATURN_EAXI_WRAPPER_EAXI_EAXI_TX_REMAP0_COUNT   16
#define  SATURN_EAXI_WRAPPER_EAXI_EAXI_TX_REMAP0_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t range                : 16 ; /* bits 15:0 */
    ca_uint32_t value                : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_EAXI_WRAPPER_EAXI_EAXI_TX_REMAP0_t;

                                                                
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* EAXI_TX */
typedef struct {
  SATURN_EAXI_WRAPPER_EAXI_EAXI_TX_TXCTL_t        TXCTL;                         /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_EAXI_WRAPPER_EAXI_EAXI_TX_REMAP0_t       REMAP0;                        /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[28];                   
} SATURN_APB2_EAXI_WRAPPER_EAXI_EAXI_TX_t;

    
  
        
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* EAXI */

typedef struct {
  SATURN_APB2_EAXI_WRAPPER_EAXI_EAXI_t            EAXI;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[13];                   
  SATURN_APB2_EAXI_WRAPPER_EAXI_EAXI_TX_t         EAXI_TX;                       /* addr: 0x00000010 */
} SATURN_APB2_EAXI_WRAPPER_EAXI_t;

    
  
        
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* EAXI_WRAPPER */

typedef struct {
  SATURN_APB2_EAXI_WRAPPER_EAXI_ATU_t             EAXI_ATU;                      /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[243];                  
  SATURN_APB2_EAXI_WRAPPER_EAXI_t                 EAXI;                          /* addr: 0x00000100 */
} SATURN_APB2_EAXI_WRAPPER_t;


/*
 * DDR_CTRL
 */
  
/*
 * PCTLTOP
 */
  
/*
 * DPI
 */
      
  

/*
 * RXI310
 */
      
  

/*
 * PCTL
 */
        
#define  SATURN_DDR_CTRL_PCTL_REVISION                   0x44108700
#define  SATURN_DDR_CTRL_PCTL_REVISION_dft               0x89061205

typedef volatile union {
  struct {
    ca_uint32_t minor                : 16 ; /* bits 15:0 */
    ca_uint32_t major                : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_PCTL_REVISION_t;


#define  SATURN_DDR_CTRL_PCTL_RTK_PHY_INIT_CNTL          0x44108704
#define  SATURN_DDR_CTRL_PCTL_RTK_PHY_INIT_CNTL_dft      0x0000330c

typedef volatile union {
  struct {
    ca_uint32_t sel_ddr4_data_mux    :  1 ; /* bits 0:0 */
    ca_uint32_t PWDPAD15N            :  1 ; /* bits 1:1 */
    ca_uint32_t reg_clken_dcphy      :  1 ; /* bits 2:2 */
    ca_uint32_t reg_clken_pllreg     :  1 ; /* bits 3:3 */
    ca_uint32_t crt_rst_n            :  1 ; /* bits 4:4 */
    ca_uint32_t rxi310_rst_n         :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t dfi_cs_geardown      :  1 ; /* bits 7:7 */
    ca_uint32_t ddr_ref_cmd_rst_n_rx :  1 ; /* bits 8:8 */
    ca_uint32_t ddr_ref_cmd_rst_n_tx :  1 ; /* bits 9:9 */
    ca_uint32_t ddr_reg_bypass_en_rx :  1 ; /* bits 10:10 */
    ca_uint32_t ddr_reg_bypass_en_tx :  1 ; /* bits 11:11 */
    ca_uint32_t ddr_reg_force_rst_n_rx :  1 ; /* bits 12:12 */
    ca_uint32_t ddr_reg_force_rst_n_tx :  1 ; /* bits 13:13 */
    ca_uint32_t ddr_reg_ref_rst_en_rx :  1 ; /* bits 14:14 */
    ca_uint32_t ddr_reg_ref_rst_en_tx :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd2               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_PCTL_RTK_PHY_INIT_CNTL_t;


#define  SATURN_DDR_CTRL_PCTL_RTK_PHY_TEST_CNTL          0x44108708
#define  SATURN_DDR_CTRL_PCTL_RTK_PHY_TEST_CNTL_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dpi_bypass_pll_ref_test_mode :  1 ; /* bits 0:0 */
    ca_uint32_t dpi_bypass_pll_test_mode :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_PCTL_RTK_PHY_TEST_CNTL_t;


#define  SATURN_DDR_CTRL_PCTL_PHY_STAT                   0x4410870c
#define  SATURN_DDR_CTRL_PCTL_PHY_STAT_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pll_stable           :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t flush_all_fifo_n     :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd2               :  5 ;
    ca_uint32_t pctl_cr_dram_dq32    :  1 ; /* bits 8:8 */
    ca_uint32_t pctl_cr_bg2          :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd3               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_PCTL_PHY_STAT_t;


#define  SATURN_DDR_CTRL_PCTL_PCTL_MSG                   0x44108710
#define  SATURN_DDR_CTRL_PCTL_PCTL_MSG_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t msg                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_PCTL_PCTL_MSG_t;


#define  SATURN_DDR_CTRL_PCTL_BSTC_MEM_ACCESS            0x44108714
#define  SATURN_DDR_CTRL_PCTL_BSTC_MEM_ACCESS_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              : 19 ; /* bits 18:0 */
    ca_uint32_t rsrvd1               : 11 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_PCTL_BSTC_MEM_ACCESS_t;


#define  SATURN_DDR_CTRL_PCTL_BSTC_MEM_DATA              0x44108718
#define  SATURN_DDR_CTRL_PCTL_BSTC_MEM_DATA_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bstc_data            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_PCTL_BSTC_MEM_DATA_t;


#define  SATURN_DDR_CTRL_PCTL_INTERRUPT                  0x4410871c
#define  SATURN_DDR_CTRL_PCTL_INTERRUPT_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pctl_INTERRUPT       :  1 ; /* bits 0:0 */
    ca_uint32_t dpi_INTERRUPT        :  4 ; /* bits 4:1 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_PCTL_INTERRUPT_t;


#define  SATURN_DDR_CTRL_PCTL_INTENABLE                  0x44108720
#define  SATURN_DDR_CTRL_PCTL_INTENABLE_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pctl_INTERRUPTE      :  1 ; /* bits 0:0 */
    ca_uint32_t dpi_INTERRUPTE       :  4 ; /* bits 4:1 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_PCTL_INTENABLE_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PCTL */
typedef struct {
  SATURN_DDR_CTRL_PCTL_REVISION_t                 REVISION;                      /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_DDR_CTRL_PCTL_RTK_PHY_INIT_CNTL_t        RTK_PHY_INIT_CNTL;             /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_DDR_CTRL_PCTL_RTK_PHY_TEST_CNTL_t        RTK_PHY_TEST_CNTL;             /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_DDR_CTRL_PCTL_PHY_STAT_t                 PHY_STAT;                      /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_DDR_CTRL_PCTL_PCTL_MSG_t                 PCTL_MSG;                      /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_DDR_CTRL_PCTL_BSTC_MEM_ACCESS_t          BSTC_MEM_ACCESS;               /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_DDR_CTRL_PCTL_BSTC_MEM_DATA_t            BSTC_MEM_DATA;                 /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  SATURN_DDR_CTRL_PCTL_INTERRUPT_t                INTERRUPT;                     /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  SATURN_DDR_CTRL_PCTL_INTENABLE_t                INTENABLE;                     /* addr: 0x00000020 */
} SATURN_APB2_DDR_CTRL_PCTLTOP_PCTL_t;

    
  
        
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PCTLTOP */

typedef struct {
  ca_uint32_t                              rsrvd1[1792];                 
  SATURN_APB2_DDR_CTRL_PCTLTOP_PCTL_t             PCTL;                          /* addr: 0x00000700 */
} SATURN_APB2_DDR_CTRL_PCTLTOP_t;


/*
 * DDR_SCH
 */
        
#define  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION0     0x44108800
#define  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t limit_addr           : 16 ; /* bits 15:0 */
    ca_uint32_t base_addr            : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION0_t;


#define  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION0_EN  0x44108804
#define  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION0_EN_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t write                :  1 ; /* bits 0:0 */
    ca_uint32_t read                 :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION0_EN_t;


#define  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION1     0x44108808
#define  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t limit_addr           : 16 ; /* bits 15:0 */
    ca_uint32_t base_addr            : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION1_t;


#define  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION1_EN  0x4410880c
#define  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION1_EN_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t write                :  1 ; /* bits 0:0 */
    ca_uint32_t read                 :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION1_EN_t;


#define  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION2     0x44108810
#define  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION2_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t limit_addr           : 16 ; /* bits 15:0 */
    ca_uint32_t base_addr            : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION2_t;


#define  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION2_EN  0x44108814
#define  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION2_EN_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t write                :  1 ; /* bits 0:0 */
    ca_uint32_t read                 :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION2_EN_t;


#define  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION3     0x44108818
#define  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION3_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t limit_addr           : 16 ; /* bits 15:0 */
    ca_uint32_t base_addr            : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION3_t;


#define  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION3_EN  0x4410881c
#define  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION3_EN_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t write                :  1 ; /* bits 0:0 */
    ca_uint32_t read                 :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION3_EN_t;


#define  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION4     0x44108820
#define  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION4_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t limit_addr           : 16 ; /* bits 15:0 */
    ca_uint32_t base_addr            : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION4_t;


#define  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION4_EN  0x44108824
#define  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION4_EN_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t write                :  1 ; /* bits 0:0 */
    ca_uint32_t read                 :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION4_EN_t;


#define  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION5     0x44108828
#define  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION5_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t limit_addr           : 16 ; /* bits 15:0 */
    ca_uint32_t base_addr            : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION5_t;


#define  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION5_EN  0x4410882c
#define  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION5_EN_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t write                :  1 ; /* bits 0:0 */
    ca_uint32_t read                 :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION5_EN_t;


#define  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION6     0x44108830
#define  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION6_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t limit_addr           : 16 ; /* bits 15:0 */
    ca_uint32_t base_addr            : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION6_t;


#define  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION6_EN  0x44108834
#define  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION6_EN_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t write                :  1 ; /* bits 0:0 */
    ca_uint32_t read                 :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION6_EN_t;


#define  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION7     0x44108838
#define  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION7_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t limit_addr           : 16 ; /* bits 15:0 */
    ca_uint32_t base_addr            : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION7_t;


#define  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION7_EN  0x4410883c
#define  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION7_EN_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t write                :  1 ; /* bits 0:0 */
    ca_uint32_t read                 :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION7_EN_t;


#define  SATURN_DDR_CTRL_DDR_SCH_DENIED_ACCESS_PORT0     0x44108840
#define  SATURN_DDR_CTRL_DDR_SCH_DENIED_ACCESS_PORT0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t denied_write         :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t denied_read          :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd2               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_DDR_SCH_DENIED_ACCESS_PORT0_t;


#define  SATURN_DDR_CTRL_DDR_SCH_DENIED_ACCESS_ID0       0x44108844
#define  SATURN_DDR_CTRL_DDR_SCH_DENIED_ACCESS_ID0_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t axi_write            : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t axi_read             : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_DDR_SCH_DENIED_ACCESS_ID0_t;


#define  SATURN_DDR_CTRL_DDR_SCH_DENIED_ACCESS_PORT1     0x44108848
#define  SATURN_DDR_CTRL_DDR_SCH_DENIED_ACCESS_PORT1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t denied_write         :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t denied_read          :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd2               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_DDR_SCH_DENIED_ACCESS_PORT1_t;


#define  SATURN_DDR_CTRL_DDR_SCH_DENIED_ACCESS_ID1       0x4410884c
#define  SATURN_DDR_CTRL_DDR_SCH_DENIED_ACCESS_ID1_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t axi_write            : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t axi_read             : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_DDR_SCH_DENIED_ACCESS_ID1_t;


#define  SATURN_DDR_CTRL_DDR_SCH_DENIED_ACCESS_PORT2     0x44108850
#define  SATURN_DDR_CTRL_DDR_SCH_DENIED_ACCESS_PORT2_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t denied_write         :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t denied_read          :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd2               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_DDR_SCH_DENIED_ACCESS_PORT2_t;


#define  SATURN_DDR_CTRL_DDR_SCH_DENIED_ACCESS_ID2       0x44108854
#define  SATURN_DDR_CTRL_DDR_SCH_DENIED_ACCESS_ID2_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t axi_write            : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t axi_read             : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_DDR_SCH_DENIED_ACCESS_ID2_t;


#define  SATURN_DDR_CTRL_DDR_SCH_QOS_REMAP_TABLE         0x44108858
#define  SATURN_DDR_CTRL_DDR_SCH_QOS_REMAP_TABLE_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 13 ;
    ca_uint32_t base_addr            : 19 ; /* bits 31:13 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_DDR_SCH_QOS_REMAP_TABLE_t;


#define  SATURN_DDR_CTRL_DDR_SCH_SCRAMBLE                0x4410885c
#define  SATURN_DDR_CTRL_DDR_SCH_SCRAMBLE_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t seed                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_DDR_SCH_SCRAMBLE_t;


#define  SATURN_DDR_CTRL_DDR_SCH_CTRL1                   0x44108860
#define  SATURN_DDR_CTRL_DDR_SCH_CTRL1_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t clear_denied_wr_p0   :  1 ; /* bits 0:0 */
    ca_uint32_t clear_denied_wr_p1   :  1 ; /* bits 1:1 */
    ca_uint32_t clear_denied_wr_p2   :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t clear_denied_rd_p0   :  1 ; /* bits 4:4 */
    ca_uint32_t clear_denied_rd_p1   :  1 ; /* bits 5:5 */
    ca_uint32_t clear_denied_rd_p2   :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t halt_wr_deq          :  1 ; /* bits 8:8 */
    ca_uint32_t halt_rd_deq          :  1 ; /* bits 9:9 */
    ca_uint32_t wr_to_remap_mem_en   :  1 ; /* bits 10:10 */
    ca_uint32_t qos_remap_en         :  1 ; /* bits 11:11 */
    ca_uint32_t en_wr_scrambler      :  1 ; /* bits 12:12 */
    ca_uint32_t en_rd_scrambler      :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd3               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_DDR_SCH_CTRL1_t;


#define  SATURN_DDR_CTRL_DDR_SCH_CTRL                    0x44108864
#define  SATURN_DDR_CTRL_DDR_SCH_CTRL_dft                0x01b74020

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t col_size             :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t row_size             :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t all_bufferable       :  1 ; /* bits 8:8 */
    ca_uint32_t all_nonbuf           :  1 ; /* bits 9:9 */
    ca_uint32_t dis_rd_deny_err      :  1 ; /* bits 10:10 */
    ca_uint32_t dis_wr_deny_err      :  1 ; /* bits 11:11 */
    ca_uint32_t fair_pri_group       :  1 ; /* bits 12:12 */
    ca_uint32_t qid_use_pri          :  1 ; /* bits 13:13 */
    ca_uint32_t hazard_chk_port      :  1 ; /* bits 14:14 */
    ca_uint32_t disable_hazard_chk   :  1 ; /* bits 15:15 */
    ca_uint32_t swap_bank_bits       :  4 ; /* bits 19:16 */
    ca_uint32_t read_interleave      :  1 ; /* bits 20:20 */
    ca_uint32_t modifiable_buf       :  1 ; /* bits 21:21 */
    ca_uint32_t fpga_mode            :  1 ; /* bits 22:22 */
    ca_uint32_t fpga_dis_cs1         :  1 ; /* bits 23:23 */
    ca_uint32_t pctl_clk_is_sync     :  1 ; /* bits 24:24 */
    ca_uint32_t rsrvd4               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_DDR_SCH_CTRL_t;


#define  SATURN_DDR_CTRL_DDR_SCH_TIMERS                  0x44108868
#define  SATURN_DDR_CTRL_DDR_SCH_TIMERS_dft              0x00300b10

typedef volatile union {
  struct {
    ca_uint32_t page_hit_wait        :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t page_miss_wait       :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t page_starving_wait   :  7 ; /* bits 22:16 */
    ca_uint32_t rsrvd3               :  9 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_DDR_SCH_TIMERS_t;


#define  SATURN_DDR_CTRL_DDR_SCH_GROUPING                0x4410886c
#define  SATURN_DDR_CTRL_DDR_SCH_GROUPING_dft            0x00001414

typedef volatile union {
  struct {
    ca_uint32_t max_rd_req           :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t max_wr_req           :  6 ; /* bits 13:8 */
    ca_uint32_t rsrvd2               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_DDR_SCH_GROUPING_t;


#define  SATURN_DDR_CTRL_DDR_SCH_PORT_MAX_WREQ           0x44108870
#define  SATURN_DDR_CTRL_DDR_SCH_PORT_MAX_WREQ_dft       0x001e1e38

typedef volatile union {
  struct {
    ca_uint32_t p0                   :  8 ; /* bits 7:0 */
    ca_uint32_t p1                   :  8 ; /* bits 15:8 */
    ca_uint32_t p2                   :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_DDR_SCH_PORT_MAX_WREQ_t;


#define  SATURN_DDR_CTRL_DDR_SCH_PORT_MAX_RREQ           0x44108874
#define  SATURN_DDR_CTRL_DDR_SCH_PORT_MAX_RREQ_dft       0x000f0f10

typedef volatile union {
  struct {
    ca_uint32_t p0                   :  8 ; /* bits 7:0 */
    ca_uint32_t p1                   :  8 ; /* bits 15:8 */
    ca_uint32_t p2                   :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_DDR_SCH_PORT_MAX_RREQ_t;


#define  SATURN_DDR_CTRL_DDR_SCH_PORT_MAX_WHEAD          0x44108878
#define  SATURN_DDR_CTRL_DDR_SCH_PORT_MAX_WHEAD_dft      0x00070708

typedef volatile union {
  struct {
    ca_uint32_t p0                   :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t p1                   :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t p2                   :  5 ; /* bits 20:16 */
    ca_uint32_t rsrvd3               : 11 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_DDR_SCH_PORT_MAX_WHEAD_t;


#define  SATURN_DDR_CTRL_DDR_SCH_PORT_MAX_RHEAD          0x4410887c
#define  SATURN_DDR_CTRL_DDR_SCH_PORT_MAX_RHEAD_dft      0x00070708

typedef volatile union {
  struct {
    ca_uint32_t p0                   :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t p1                   :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t p2                   :  5 ; /* bits 20:16 */
    ca_uint32_t rsrvd3               : 11 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_DDR_SCH_PORT_MAX_RHEAD_t;


#define  SATURN_DDR_CTRL_DDR_SCH_INTERRUPT               0x44108880
#define  SATURN_DDR_CTRL_DDR_SCH_INTERRUPT_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t write_denied_p0      :  1 ; /* bits 0:0 */
    ca_uint32_t write_denied_p1      :  1 ; /* bits 1:1 */
    ca_uint32_t write_denied_p2      :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t read_denied_p0       :  1 ; /* bits 4:4 */
    ca_uint32_t read_denied_p1       :  1 ; /* bits 5:5 */
    ca_uint32_t read_denied_p2       :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd2               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_DDR_SCH_INTERRUPT_t;


#define  SATURN_DDR_CTRL_DDR_SCH_INTENABLE               0x44108884
#define  SATURN_DDR_CTRL_DDR_SCH_INTENABLE_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t write_deniedIE_p0    :  1 ; /* bits 0:0 */
    ca_uint32_t write_deniedIE_p1    :  1 ; /* bits 1:1 */
    ca_uint32_t write_deniedIE_p2    :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t read_deniedIE_p0     :  1 ; /* bits 4:4 */
    ca_uint32_t read_deniedIE_p1     :  1 ; /* bits 5:5 */
    ca_uint32_t read_deniedIE_p2     :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd2               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_DDR_SCH_INTENABLE_t;


#define  SATURN_DDR_CTRL_DDR_SCH_FPGA_STATUS             0x44108888
#define  SATURN_DDR_CTRL_DDR_SCH_FPGA_STATUS_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t init_calib_complete  :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_DDR_SCH_FPGA_STATUS_t;


#define  SATURN_DDR_CTRL_DDR_SCH_DEBUG_INFO1             0x4410888c
#define  SATURN_DDR_CTRL_DDR_SCH_DEBUG_INFO1_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rd_arb_req_cntr_p0   :  8 ; /* bits 7:0 */
    ca_uint32_t rd_arb_req_cntr_p1   :  8 ; /* bits 15:8 */
    ca_uint32_t rd_arb_req_cntr_p2   :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_DDR_SCH_DEBUG_INFO1_t;


#define  SATURN_DDR_CTRL_DDR_SCH_DEBUG_INFO2             0x44108890
#define  SATURN_DDR_CTRL_DDR_SCH_DEBUG_INFO2_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wr_arb_req_cntr_p0   :  8 ; /* bits 7:0 */
    ca_uint32_t wr_arb_req_cntr_p1   :  8 ; /* bits 15:8 */
    ca_uint32_t wr_arb_req_cntr_p2   :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_DDR_SCH_DEBUG_INFO2_t;


#define  SATURN_DDR_CTRL_DDR_SCH_DEBUG_INFO3             0x44108894
#define  SATURN_DDR_CTRL_DDR_SCH_DEBUG_INFO3_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t deq_rll_available    :  1 ; /* bits 0:0 */
    ca_uint32_t deq_wll_available    :  1 ; /* bits 1:1 */
    ca_uint32_t deq_rresp_fifo_empty :  1 ; /* bits 2:2 */
    ca_uint32_t return_rd_mem_empty  :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t deq_cmd_fifo_rptr    :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t deq_cmd_fifo_wptr    :  3 ; /* bits 14:12 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t deq_wd_fifo_rptr     :  4 ; /* bits 19:16 */
    ca_uint32_t deq_wd_fifo_wptr     :  4 ; /* bits 23:20 */
    ca_uint32_t rsrvd4               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_DDR_CTRL_DDR_SCH_DEBUG_INFO3_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* DDR_SCH */
typedef struct {
  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION0_t   SECURED_DDR_REGION0;           /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION0_EN_t SECURED_DDR_REGION0_EN;        /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION1_t   SECURED_DDR_REGION1;           /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION1_EN_t SECURED_DDR_REGION1_EN;        /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION2_t   SECURED_DDR_REGION2;           /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION2_EN_t SECURED_DDR_REGION2_EN;        /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION3_t   SECURED_DDR_REGION3;           /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION3_EN_t SECURED_DDR_REGION3_EN;        /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION4_t   SECURED_DDR_REGION4;           /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION4_EN_t SECURED_DDR_REGION4_EN;        /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION5_t   SECURED_DDR_REGION5;           /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION5_EN_t SECURED_DDR_REGION5_EN;        /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION6_t   SECURED_DDR_REGION6;           /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION6_EN_t SECURED_DDR_REGION6_EN;        /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION7_t   SECURED_DDR_REGION7;           /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  SATURN_DDR_CTRL_DDR_SCH_SECURED_DDR_REGION7_EN_t SECURED_DDR_REGION7_EN;        /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  SATURN_DDR_CTRL_DDR_SCH_DENIED_ACCESS_PORT0_t   DENIED_ACCESS_PORT0;           /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  SATURN_DDR_CTRL_DDR_SCH_DENIED_ACCESS_ID0_t     DENIED_ACCESS_ID0;             /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  SATURN_DDR_CTRL_DDR_SCH_DENIED_ACCESS_PORT1_t   DENIED_ACCESS_PORT1;           /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  SATURN_DDR_CTRL_DDR_SCH_DENIED_ACCESS_ID1_t     DENIED_ACCESS_ID1;             /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  SATURN_DDR_CTRL_DDR_SCH_DENIED_ACCESS_PORT2_t   DENIED_ACCESS_PORT2;           /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  SATURN_DDR_CTRL_DDR_SCH_DENIED_ACCESS_ID2_t     DENIED_ACCESS_ID2;             /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  SATURN_DDR_CTRL_DDR_SCH_QOS_REMAP_TABLE_t       QOS_REMAP_TABLE;               /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  SATURN_DDR_CTRL_DDR_SCH_SCRAMBLE_t              SCRAMBLE;                      /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  SATURN_DDR_CTRL_DDR_SCH_CTRL1_t                 CTRL1;                         /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  SATURN_DDR_CTRL_DDR_SCH_CTRL_t                  CTRL;                          /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  SATURN_DDR_CTRL_DDR_SCH_TIMERS_t                TIMERS;                        /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  SATURN_DDR_CTRL_DDR_SCH_GROUPING_t              GROUPING;                      /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  SATURN_DDR_CTRL_DDR_SCH_PORT_MAX_WREQ_t         PORT_MAX_WREQ;                 /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  SATURN_DDR_CTRL_DDR_SCH_PORT_MAX_RREQ_t         PORT_MAX_RREQ;                 /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  SATURN_DDR_CTRL_DDR_SCH_PORT_MAX_WHEAD_t        PORT_MAX_WHEAD;                /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  SATURN_DDR_CTRL_DDR_SCH_PORT_MAX_RHEAD_t        PORT_MAX_RHEAD;                /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  SATURN_DDR_CTRL_DDR_SCH_INTERRUPT_t             INTERRUPT;                     /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  SATURN_DDR_CTRL_DDR_SCH_INTENABLE_t             INTENABLE;                     /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  SATURN_DDR_CTRL_DDR_SCH_FPGA_STATUS_t           FPGA_STATUS;                   /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  SATURN_DDR_CTRL_DDR_SCH_DEBUG_INFO1_t           DEBUG_INFO1;                   /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  SATURN_DDR_CTRL_DDR_SCH_DEBUG_INFO2_t           DEBUG_INFO2;                   /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  SATURN_DDR_CTRL_DDR_SCH_DEBUG_INFO3_t           DEBUG_INFO3;                   /* addr: 0x00000094 */
} SATURN_APB2_DDR_CTRL_DDR_SCH_t;

    
  
        
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* DDR_CTRL */

typedef struct {
  SATURN_APB2_DDR_CTRL_PCTLTOP_t                  PCTLTOP;                       /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[239];                  
  SATURN_APB2_DDR_CTRL_DDR_SCH_t                  DDR_SCH;                       /* addr: 0x00000800 */
} SATURN_APB2_DDR_CTRL_t;


/*
 * CLKGEN
 */
        
#define  SATURN_CLKGEN_CLKGEN_CONFIG                     0x44109000
#define  SATURN_CLKGEN_CLKGEN_CONFIG_dft                 0x01000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 10 ;
    ca_uint32_t use_gphy_clk         :  1 ; /* bits 10:10 */
    ca_uint32_t ext_eth_refclk       :  1 ; /* bits 11:11 */
    ca_uint32_t refclk_sel           :  2 ; /* bits 13:12 */
    ca_uint32_t sel_mck_out          :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd2               :  9 ;
    ca_uint32_t ptp_timer_reset      :  1 ; /* bits 24:24 */
    ca_uint32_t cpu_ap_pd            :  1 ; /* bits 25:25 */
    ca_uint32_t cpu_dsp_pd           :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd3               :  5 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_CLKGEN_CLKGEN_CONFIG_t;


#define  SATURN_CLKGEN_PSDS_INIT_CNTL                    0x44109004
#define  SATURN_CLKGEN_PSDS_INIT_CNTL_dft                0x00000001

typedef volatile union {
  struct {
    ca_uint32_t REG_BG_LC_SEL        :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t ben_oen              :  1 ; /* bits 4:4 */
    ca_uint32_t POW_PCIX             :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t PRSTB_H              :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd3               :  5 ;
    ca_uint32_t PWDPAD_33            :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd4               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_CLKGEN_PSDS_INIT_CNTL_t;


#define  SATURN_CLKGEN_CPLL0                             0x44109008
#define  SATURN_CLKGEN_CPLL0_dft                         0x0000039d

typedef volatile union {
  struct {
    ca_uint32_t SCPU_DIV_DIVN        :  8 ; /* bits 7:0 */
    ca_uint32_t SCPU_POW             :  1 ; /* bits 8:8 */
    ca_uint32_t SCPU_RSTB            :  1 ; /* bits 9:9 */
    ca_uint32_t DIV_PREDIV_SEL       :  2 ; /* bits 11:10 */
    ca_uint32_t DIV_PREDIV_BPS       :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd1               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_CLKGEN_CPLL0_t;


#define  SATURN_CLKGEN_CPLL1                             0x4410900c
#define  SATURN_CLKGEN_CPLL1_dft                         0x000d425f

typedef volatile union {
  struct {
    ca_uint32_t ICP                  :  3 ; /* bits 2:0 */
    ca_uint32_t LPF_CS               :  2 ; /* bits 4:3 */
    ca_uint32_t LPF_RS               :  3 ; /* bits 7:5 */
    ca_uint32_t SCPU_DBUG_EN         :  1 ; /* bits 8:8 */
    ca_uint32_t SEL_CCO              :  1 ; /* bits 9:9 */
    ca_uint32_t WD_RST               :  1 ; /* bits 10:10 */
    ca_uint32_t WD_SET               :  1 ; /* bits 11:11 */
    ca_uint32_t OEB                  :  1 ; /* bits 12:12 */
    ca_uint32_t TESTSEL              :  1 ; /* bits 13:13 */
    ca_uint32_t LDO10V_SEL           :  2 ; /* bits 15:14 */
    ca_uint32_t LDO18V_SEL           :  2 ; /* bits 17:16 */
    ca_uint32_t LOOP_PI_ISEL         :  2 ; /* bits 19:18 */
    ca_uint32_t LOOP_PI_SEL          :  5 ; /* bits 24:20 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_CLKGEN_CPLL1_t;


#define  SATURN_CLKGEN_CPLLDIV                           0x44109010
#define  SATURN_CLKGEN_CPLLDIV_dft                       0x08060000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 16 ;
    ca_uint32_t core_clk_divsel      :  7 ; /* bits 22:16 */
    ca_uint32_t core_clk_div_override :  1 ; /* bits 23:23 */
    ca_uint32_t proc_clk_divsel      :  7 ; /* bits 30:24 */
    ca_uint32_t proc_clk_div_override :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_CLKGEN_CPLLDIV_t;


#define  SATURN_CLKGEN_CPLLDIV2                          0x44109014
#define  SATURN_CLKGEN_CPLLDIV2_dft                      0x0a140800

typedef volatile union {
  struct {
    ca_uint32_t cpll_mode_override   :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t eth_ref_2_clk_divsel :  6 ; /* bits 13:8 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t eth_ref_2_clk_div_override :  1 ; /* bits 15:15 */
    ca_uint32_t eaxi_divsel          :  7 ; /* bits 22:16 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t io_clk_divsel        :  7 ; /* bits 30:24 */
    ca_uint32_t io_clk_div_override  :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_CLKGEN_CPLLDIV2_t;


#define  SATURN_CLKGEN_CPLL_STATE                        0x44109018
#define  SATURN_CLKGEN_CPLL_STATE_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cpll_lock            :  1 ; /* bits 0:0 */
    ca_uint32_t cpll_switch_state    :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_CLKGEN_CPLL_STATE_t;


#define  SATURN_CLKGEN_PTP_CFG                           0x4410901c
#define  SATURN_CLKGEN_PTP_CFG_dft                       0x80000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 31 ;
    ca_uint32_t div_8                :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_CLKGEN_PTP_CFG_t;


#define  SATURN_CLKGEN_PTP_PHASE_VAL                     0x44109020
#define  SATURN_CLKGEN_PTP_PHASE_VAL_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_CLKGEN_PTP_PHASE_VAL_t;


#define  SATURN_CLKGEN_PTP_PERIOD_ERR                    0x44109024
#define  SATURN_CLKGEN_PTP_PERIOD_ERR_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_CLKGEN_PTP_PERIOD_ERR_t;


#define  SATURN_CLKGEN_TAROKO_AP_FREQ_CONF               0x44109028
#define  SATURN_CLKGEN_TAROKO_AP_FREQ_CONF_dft           0x00ff0205

typedef volatile union {
  struct {
    ca_uint32_t cpu_ap_new_divsel    :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t cpu_ap_divsel        :  7 ; /* bits 14:8 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t cpu_ap_taroko_timeout :  8 ; /* bits 23:16 */
    ca_uint32_t cpu_ap_bypass_sleep_chk :  1 ; /* bits 24:24 */
    ca_uint32_t rsrvd3               :  5 ;
    ca_uint32_t cpu_ap_speed_change_enable :  1 ; /* bits 30:30 */
    ca_uint32_t cpu_ap_div_override  :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_CLKGEN_TAROKO_AP_FREQ_CONF_t;


#define  SATURN_CLKGEN_TAROKO_AP_FREQ_CHG_START          0x4410902c
#define  SATURN_CLKGEN_TAROKO_AP_FREQ_CHG_START_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cpu_ap_start         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_CLKGEN_TAROKO_AP_FREQ_CHG_START_t;


#define  SATURN_CLKGEN_TAROKO_AP_FREQ_STATUS             0x44109030
#define  SATURN_CLKGEN_TAROKO_AP_FREQ_STATUS_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t curr_cpu_ap_divsel   :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t cpu_ap_current_state :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd2               :  5 ;
    ca_uint32_t cpu_ap_sl_sleepsys_r :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd3               : 14 ;
    ca_uint32_t cpu_ap_busy          :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_CLKGEN_TAROKO_AP_FREQ_STATUS_t;


#define  SATURN_CLKGEN_TAROKO_DSP_FREQ_CONF              0x44109034
#define  SATURN_CLKGEN_TAROKO_DSP_FREQ_CONF_dft          0x00ff0205

typedef volatile union {
  struct {
    ca_uint32_t cpu_dsp_new_divsel   :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t cpu_dsp_divsel       :  7 ; /* bits 14:8 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t cpu_dsp_taroko_timeout :  8 ; /* bits 23:16 */
    ca_uint32_t cpu_dsp_bypass_sleep_chk :  1 ; /* bits 24:24 */
    ca_uint32_t rsrvd3               :  5 ;
    ca_uint32_t cpu_dsp_speed_change_enable :  1 ; /* bits 30:30 */
    ca_uint32_t cpu_dsp_div_override :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_CLKGEN_TAROKO_DSP_FREQ_CONF_t;


#define  SATURN_CLKGEN_TAROKO_DSP_FREQ_CHG_START         0x44109038
#define  SATURN_CLKGEN_TAROKO_DSP_FREQ_CHG_START_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cpu_dsp_start        :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_CLKGEN_TAROKO_DSP_FREQ_CHG_START_t;


#define  SATURN_CLKGEN_TAROKO_DSP_FREQ_STATUS            0x4410903c
#define  SATURN_CLKGEN_TAROKO_DSP_FREQ_STATUS_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t curr_cpu_dsp_divsel  :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t cpu_dsp_current_state :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd2               :  5 ;
    ca_uint32_t cpu_dsp_sl_sleepsys_r :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd3               : 14 ;
    ca_uint32_t cpu_dsp_busy         :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_CLKGEN_TAROKO_DSP_FREQ_STATUS_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* CLKGEN */
typedef struct {
  SATURN_CLKGEN_CLKGEN_CONFIG_t                   CLKGEN_CONFIG;                 /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_CLKGEN_PSDS_INIT_CNTL_t                  PSDS_INIT_CNTL;                /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_CLKGEN_CPLL0_t                           CPLL0;                         /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_CLKGEN_CPLL1_t                           CPLL1;                         /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_CLKGEN_CPLLDIV_t                         CPLLDIV;                       /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_CLKGEN_CPLLDIV2_t                        CPLLDIV2;                      /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_CLKGEN_CPLL_STATE_t                      CPLL_STATE;                    /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  SATURN_CLKGEN_PTP_CFG_t                         PTP_CFG;                       /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  SATURN_CLKGEN_PTP_PHASE_VAL_t                   PTP_PHASE_VAL;                 /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  SATURN_CLKGEN_PTP_PERIOD_ERR_t                  PTP_PERIOD_ERR;                /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  SATURN_CLKGEN_TAROKO_AP_FREQ_CONF_t             TAROKO_AP_FREQ_CONF;           /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  SATURN_CLKGEN_TAROKO_AP_FREQ_CHG_START_t        TAROKO_AP_FREQ_CHG_START;      /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  SATURN_CLKGEN_TAROKO_AP_FREQ_STATUS_t           TAROKO_AP_FREQ_STATUS;         /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  SATURN_CLKGEN_TAROKO_DSP_FREQ_CONF_t            TAROKO_DSP_FREQ_CONF;          /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  SATURN_CLKGEN_TAROKO_DSP_FREQ_CHG_START_t       TAROKO_DSP_FREQ_CHG_START;     /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  SATURN_CLKGEN_TAROKO_DSP_FREQ_STATUS_t          TAROKO_DSP_FREQ_STATUS;        /* addr: 0x0000003c */
} SATURN_APB2_CLKGEN_t;

    
  
        
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* APB2 */

typedef struct {
  SATURN_APB2_GLB_t                               GLB;                           /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3867];                 
  SATURN_APB2_PE_TAROKO_ATU_t                     PE_TAROKO_ATU;                 /* addr: 0x00001000 */
  ca_uint32_t                              rsrvd2[3571];                 
  SATURN_APB2_CAPSRAM_t                           CAPSRAM;                       /* addr: 0x00002000 */
  ca_uint32_t                              rsrvd3[4085];                 
  SATURN_APB2_LDMA_t                              LDMA;                          /* addr: 0x00003000 */
  ca_uint32_t                              rsrvd4[2529];                 
  SATURN_APB2_LDMA_RCPU_t                         LDMA_RCPU;                     /* addr: 0x00004000 */
  ca_uint32_t                              rsrvd5[6625];                 
  SATURN_APB2_EAXI_WRAPPER_t                      EAXI_WRAPPER;                  /* addr: 0x00006000 */
  ca_uint32_t                              rsrvd6[7887];                 
  SATURN_APB2_DDR_CTRL_t                          DDR_CTRL;                      /* addr: 0x00008000 */
  ca_uint32_t                              rsrvd7[1973];                 
  SATURN_APB2_CLKGEN_t                            CLKGEN;                        /* addr: 0x00009000 */
} SATURN_APB2_t;


/*
 * APB3
 */
  
/*
 * FLASH
 */
        
#define  SATURN_FLASH_ID                                 0x52223000
#define  SATURN_FLASH_ID_dft                             0x00000101

typedef volatile union {
  struct {
    ca_uint32_t flashRevID           :  8 ; /* bits 7:0 */
    ca_uint32_t flashDevID           : 24 ; /* bits 31:8 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_FLASH_ID_t;


#define  SATURN_FLASH_TIMEOUT                            0x52223004
#define  SATURN_FLASH_TIMEOUT_dft                        0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t timeout_load         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_FLASH_TIMEOUT_t;


#define  SATURN_FLASH_STATUS                             0x52223008
#define  SATURN_FLASH_STATUS_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sState               :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_FLASH_STATUS_t;


#define  SATURN_FLASH_TYPE                               0x5222300c
#define  SATURN_FLASH_TYPE_dft                           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  9 ;
    ca_uint32_t flashSize            :  2 ; /* bits 10:9 */
    ca_uint32_t flashWidth           :  1 ; /* bits 11:11 */
    ca_uint32_t flashType            :  3 ; /* bits 14:12 */
    ca_uint32_t flashPin             :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd2               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_FLASH_TYPE_t;


#define  SATURN_FLASH_FLASH_ACCESS_START                 0x52223010
#define  SATURN_FLASH_FLASH_ACCESS_START_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t sflashRegReq         :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t sflashFifoReq        :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd3               :  5 ;
    ca_uint32_t sflashRegCmd         :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd4               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_FLASH_FLASH_ACCESS_START_t;


#define  SATURN_FLASH_FLASH_INTERRUPT                    0x52223014
#define  SATURN_FLASH_FLASH_INTERRUPT_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t regIrq               :  1 ; /* bits 0:0 */
    ca_uint32_t fifoIrq              :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_FLASH_FLASH_INTERRUPT_t;


#define  SATURN_FLASH_FLASH_MASK                         0x52223018
#define  SATURN_FLASH_FLASH_MASK_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t flashRegIrqMask      :  1 ; /* bits 0:0 */
    ca_uint32_t fifoIrqMask          :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_FLASH_FLASH_MASK_t;


#define  SATURN_FLASH_FIFO_CONTROL                       0x5222301c
#define  SATURN_FLASH_FIFO_CONTROL_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t fifoCmd              :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t fifoDbgSel           :  4 ; /* bits 7:4 */
    ca_uint32_t fifoClear            :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd2               : 15 ;
    ca_uint32_t fifoRDTH             :  2 ; /* bits 25:24 */
    ca_uint32_t fifoWRTH             :  2 ; /* bits 27:26 */
    ca_uint32_t rsrvd3               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_FLASH_FIFO_CONTROL_t;


#define  SATURN_FLASH_FIFO_STATUS                        0x52223020
#define  SATURN_FLASH_FIFO_STATUS_dft                    0x00000004

typedef volatile union {
  struct {
    ca_uint32_t f_state              :  2 ; /* bits 1:0 */
    ca_uint32_t f_empty              :  1 ; /* bits 2:2 */
    ca_uint32_t f_full               :  1 ; /* bits 3:3 */
    ca_uint32_t f_ptr_rd             :  5 ; /* bits 8:4 */
    ca_uint32_t f_ptr_wr             :  5 ; /* bits 13:9 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t f_addr_count         :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd2               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_FLASH_FIFO_STATUS_t;


#define  SATURN_FLASH_FIFO_ADDRESS                       0x52223024
#define  SATURN_FLASH_FIFO_ADDRESS_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t f_AXADDR             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_FLASH_FIFO_ADDRESS_t;


#define  SATURN_FLASH_FIFO_MATCH_ADDRESS                 0x52223028
#define  SATURN_FLASH_FIFO_MATCH_ADDRESS_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t f_AXADDR_compare     : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_FLASH_FIFO_MATCH_ADDRESS_t;


#define  SATURN_FLASH_FIFO_DATA                          0x5222302c
#define  SATURN_FLASH_FIFO_DATA_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t f_ebuf_mem1          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_FLASH_FIFO_DATA_t;


#define  SATURN_FLASH_SF_ACCESS                          0x52223030
#define  SATURN_FLASH_SF_ACCESS_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sflashOpCode         :  8 ; /* bits 7:0 */
    ca_uint32_t sflashAcCode         :  4 ; /* bits 11:8 */
    ca_uint32_t sflashForceTerm      :  1 ; /* bits 12:12 */
    ca_uint32_t sflashForceBurst     :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t sflashCnMode         :  1 ; /* bits 15:15 */
    ca_uint32_t sflashCeAlt          :  1 ; /* bits 16:16 */
    ca_uint32_t sflashHSRd           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd2               :  6 ;
    ca_uint32_t sflashMData          :  1 ; /* bits 24:24 */
    ca_uint32_t sflashMAddr          :  1 ; /* bits 25:25 */
    ca_uint32_t sflashMCmd           :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t sflashDDR            :  2 ; /* bits 29:28 */
    ca_uint32_t sflashMIO            :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_FLASH_SF_ACCESS_t;


#define  SATURN_FLASH_SF_EXT_ACCESS                      0x52223034
#define  SATURN_FLASH_SF_EXT_ACCESS_dft                  0x3fffff00

typedef volatile union {
  struct {
    ca_uint32_t sflashOpCode         :  8 ; /* bits 7:0 */
    ca_uint32_t sflashDataCount      : 13 ; /* bits 20:8 */
    ca_uint32_t sflashAddrCount      :  3 ; /* bits 23:21 */
    ca_uint32_t sflashDummyCount     :  6 ; /* bits 29:24 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t sflashDirRdCmdEn     :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_FLASH_SF_EXT_ACCESS_t;


#define  SATURN_FLASH_SF_ADDRESS                         0x52223038
#define  SATURN_FLASH_SF_ADDRESS_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sflashRegAddr        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_FLASH_SF_ADDRESS_t;


#define  SATURN_FLASH_SF_DATA                            0x5222303c
#define  SATURN_FLASH_SF_DATA_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sflashRegWData       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_FLASH_SF_DATA_t;


#define  SATURN_FLASH_SF_TIMING                          0x52223040
#define  SATURN_FLASH_SF_TIMING_dft                      0x00373737

typedef volatile union {
  struct {
    ca_uint32_t sflashIdleTime       :  8 ; /* bits 7:0 */
    ca_uint32_t sflashHoldTime       :  8 ; /* bits 15:8 */
    ca_uint32_t sflashSetupTime      :  8 ; /* bits 23:16 */
    ca_uint32_t sflashClkWidth       :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd1               :  5 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_FLASH_SF_TIMING_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* FLASH */
typedef struct {
  SATURN_FLASH_ID_t                               ID;                            /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_FLASH_TIMEOUT_t                          TIMEOUT;                       /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_FLASH_STATUS_t                           STATUS;                        /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_FLASH_TYPE_t                             TYPE;                          /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_FLASH_FLASH_ACCESS_START_t               FLASH_ACCESS_START;            /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_FLASH_FLASH_INTERRUPT_t                  FLASH_INTERRUPT;               /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_FLASH_FLASH_MASK_t                       FLASH_MASK;                    /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  SATURN_FLASH_FIFO_CONTROL_t                     FIFO_CONTROL;                  /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  SATURN_FLASH_FIFO_STATUS_t                      FIFO_STATUS;                   /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  SATURN_FLASH_FIFO_ADDRESS_t                     FIFO_ADDRESS;                  /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  SATURN_FLASH_FIFO_MATCH_ADDRESS_t               FIFO_MATCH_ADDRESS;            /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  SATURN_FLASH_FIFO_DATA_t                        FIFO_DATA;                     /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  SATURN_FLASH_SF_ACCESS_t                        SF_ACCESS;                     /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  SATURN_FLASH_SF_EXT_ACCESS_t                    SF_EXT_ACCESS;                 /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  SATURN_FLASH_SF_ADDRESS_t                       SF_ADDRESS;                    /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  SATURN_FLASH_SF_DATA_t                          SF_DATA;                       /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  SATURN_FLASH_SF_TIMING_t                        SF_TIMING;                     /* addr: 0x00000040 */
} SATURN_APB3_FLASH_t;


/*
 * PER
 */
        
#define  SATURN_PER_SOFT_RESET                           0x52224000
#define  SATURN_PER_SOFT_RESET_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t soft_reset           :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SOFT_RESET_t;


#define  SATURN_PER_PERIPHERAL_INTERRUPT_0               0x52224004
#define  SATURN_PER_PERIPHERAL_INTERRUPT_0_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t soft0i               :  1 ; /* bits 0:0 */
    ca_uint32_t soft1i               :  1 ; /* bits 1:1 */
    ca_uint32_t tmr1i                :  1 ; /* bits 2:2 */
    ca_uint32_t tmr2i                :  1 ; /* bits 3:3 */
    ca_uint32_t wdti                 :  1 ; /* bits 4:4 */
    ca_uint32_t spii                 :  1 ; /* bits 5:5 */
    ca_uint32_t gpio0i               :  1 ; /* bits 6:6 */
    ca_uint32_t gpio1i               :  1 ; /* bits 7:7 */
    ca_uint32_t gpio2i               :  1 ; /* bits 8:8 */
    ca_uint32_t gpio3i               :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t biwi                 :  1 ; /* bits 11:11 */
    ca_uint32_t mdioi                :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t cspii                :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd3               :  4 ;
    ca_uint32_t taroko_timer0i       :  1 ; /* bits 20:20 */
    ca_uint32_t taroko_timer1i       :  1 ; /* bits 21:21 */
    ca_uint32_t rsrvd4               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_PERIPHERAL_INTERRUPT_0_t;


#define  SATURN_PER_PERIPHERAL_INTENABLE_0               0x52224008
#define  SATURN_PER_PERIPHERAL_INTENABLE_0_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t soft0e               :  1 ; /* bits 0:0 */
    ca_uint32_t soft1e               :  1 ; /* bits 1:1 */
    ca_uint32_t tmr1e                :  1 ; /* bits 2:2 */
    ca_uint32_t tmr2e                :  1 ; /* bits 3:3 */
    ca_uint32_t wdte                 :  1 ; /* bits 4:4 */
    ca_uint32_t spie                 :  1 ; /* bits 5:5 */
    ca_uint32_t gpio0e               :  1 ; /* bits 6:6 */
    ca_uint32_t gpio1e               :  1 ; /* bits 7:7 */
    ca_uint32_t gpio2e               :  1 ; /* bits 8:8 */
    ca_uint32_t gpio3e               :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t biwe                 :  1 ; /* bits 11:11 */
    ca_uint32_t mdioe                :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t cspie                :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd3               :  4 ;
    ca_uint32_t taroko_timer0e       :  1 ; /* bits 20:20 */
    ca_uint32_t taroko_timer1e       :  1 ; /* bits 21:21 */
    ca_uint32_t rsrvd4               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_PERIPHERAL_INTENABLE_0_t;


#define  SATURN_PER_PERIPHERAL_INTERRUPT_1               0x5222400c
#define  SATURN_PER_PERIPHERAL_INTERRUPT_1_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t soft0i               :  1 ; /* bits 0:0 */
    ca_uint32_t soft1i               :  1 ; /* bits 1:1 */
    ca_uint32_t tmr1i                :  1 ; /* bits 2:2 */
    ca_uint32_t tmr2i                :  1 ; /* bits 3:3 */
    ca_uint32_t wdti                 :  1 ; /* bits 4:4 */
    ca_uint32_t spii                 :  1 ; /* bits 5:5 */
    ca_uint32_t gpio0i               :  1 ; /* bits 6:6 */
    ca_uint32_t gpio1i               :  1 ; /* bits 7:7 */
    ca_uint32_t gpio2i               :  1 ; /* bits 8:8 */
    ca_uint32_t gpio3i               :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t biwi                 :  1 ; /* bits 11:11 */
    ca_uint32_t mdioi                :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t cspii                :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd3               :  4 ;
    ca_uint32_t taroko_timer0i       :  1 ; /* bits 20:20 */
    ca_uint32_t taroko_timer1i       :  1 ; /* bits 21:21 */
    ca_uint32_t rsrvd4               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_PERIPHERAL_INTERRUPT_1_t;


#define  SATURN_PER_PERIPHERAL_INTENABLE_1               0x52224010
#define  SATURN_PER_PERIPHERAL_INTENABLE_1_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t soft0e               :  1 ; /* bits 0:0 */
    ca_uint32_t soft1e               :  1 ; /* bits 1:1 */
    ca_uint32_t tmr1e                :  1 ; /* bits 2:2 */
    ca_uint32_t tmr2e                :  1 ; /* bits 3:3 */
    ca_uint32_t wdte                 :  1 ; /* bits 4:4 */
    ca_uint32_t spie                 :  1 ; /* bits 5:5 */
    ca_uint32_t gpio0e               :  1 ; /* bits 6:6 */
    ca_uint32_t gpio1e               :  1 ; /* bits 7:7 */
    ca_uint32_t gpio2e               :  1 ; /* bits 8:8 */
    ca_uint32_t gpio3e               :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t biwe                 :  1 ; /* bits 11:11 */
    ca_uint32_t mdioe                :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t cspie                :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd3               :  4 ;
    ca_uint32_t taroko_timer0e       :  1 ; /* bits 20:20 */
    ca_uint32_t taroko_timer1e       :  1 ; /* bits 21:21 */
    ca_uint32_t rsrvd4               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_PERIPHERAL_INTENABLE_1_t;


#define  SATURN_PER_IRQ_SOFT1                            0x52224014
#define  SATURN_PER_IRQ_SOFT1_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t softiSet             :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_IRQ_SOFT1_t;


#define  SATURN_PER_IRQ_SOFT0                            0x52224018
#define  SATURN_PER_IRQ_SOFT0_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t softiSet             :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_IRQ_SOFT0_t;


#define  SATURN_PER_WDT_CTRL                             0x5222401c
#define  SATURN_PER_WDT_CTRL_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wdten                :  1 ; /* bits 0:0 */
    ca_uint32_t rsten                :  1 ; /* bits 1:1 */
    ca_uint32_t clksel               :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_WDT_CTRL_t;

#define      SATURN_clksel_perdiv                                 0x0
#define      SATURN_clksel_peronly                                0x1
#define      SATURN_rsten_DIS                                     0x0
#define      SATURN_rsten_ena                                     0x1
#define      SATURN_wdten_DIS                                     0x0
#define      SATURN_wdten_ENA                                     0x1

#define  SATURN_PER_WDT_PS                               0x52224020
#define  SATURN_PER_WDT_PS_dft                           0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t wdtps                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_WDT_PS_t;


#define  SATURN_PER_WDT_DIV                              0x52224024
#define  SATURN_PER_WDT_DIV_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t div_load             : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_WDT_DIV_t;


#define  SATURN_PER_WDT_LD                               0x52224028
#define  SATURN_PER_WDT_LD_dft                           0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t wdtld                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_WDT_LD_t;


#define  SATURN_PER_WDT_LOADE                            0x5222402c
#define  SATURN_PER_WDT_LOADE_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t update_wdt           :  1 ; /* bits 0:0 */
    ca_uint32_t update_pre           :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_WDT_LOADE_t;


#define  SATURN_PER_WDT_CNT                              0x52224030
#define  SATURN_PER_WDT_CNT_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wdtcount             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_WDT_CNT_t;


#define  SATURN_PER_WDT_IE_0                             0x52224034
#define  SATURN_PER_WDT_IE_0_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wdte                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_WDT_IE_0_t;


#define  SATURN_PER_WDT_INT_0                            0x52224038
#define  SATURN_PER_WDT_INT_0_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wdti                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_WDT_INT_0_t;


#define  SATURN_PER_WDT_STAT_0                           0x5222403c
#define  SATURN_PER_WDT_STAT_0_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wdts                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_WDT_STAT_0_t;


#define  SATURN_PER_WDT_IE_1                             0x52224040
#define  SATURN_PER_WDT_IE_1_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wdte                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_WDT_IE_1_t;


#define  SATURN_PER_WDT_INT_1                            0x52224044
#define  SATURN_PER_WDT_INT_1_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wdti                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_WDT_INT_1_t;


#define  SATURN_PER_WDT_STAT_1                           0x52224048
#define  SATURN_PER_WDT_STAT_1_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wdts                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_WDT_STAT_1_t;


#define  SATURN_PER_WDT_TST                              0x5222404c
#define  SATURN_PER_WDT_TST_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t testmode             :  1 ; /* bits 0:0 */
    ca_uint32_t testclken            :  1 ; /* bits 1:1 */
    ca_uint32_t testreset            :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_WDT_TST_t;


#define  SATURN_PER_TMR_LD1                              0x52224050
#define  SATURN_PER_TMR_LD1_dft                          0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t load1                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_TMR_LD1_t;


#define  SATURN_PER_TMR_CTRL1                            0x52224054
#define  SATURN_PER_TMR_CTRL1_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t clksel1              :  2 ; /* bits 3:2 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t rlmode1              :  1 ; /* bits 6:6 */
    ca_uint32_t timen1               :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd3               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_TMR_CTRL1_t;

#define      SATURN_timen1_DIS                                    0x0
#define      SATURN_timen1_ENA                                    0x1
#define      SATURN_rlmode1_ROLL                                  0x0
#define      SATURN_rlmode1_LOAD                                  0x1
#define      SATURN_clksel1_direct                                0x0
#define      SATURN_clksel1_dv64                                  0x1
#define      SATURN_clksel1_dv1024                                0x2
#define      SATURN_clksel1_dv4096                                0x3

#define  SATURN_PER_TMR_CNT1                             0x52224058
#define  SATURN_PER_TMR_CNT1_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t count1               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_TMR_CNT1_t;


#define  SATURN_PER_TMR_IE1_0                            0x5222405c
#define  SATURN_PER_TMR_IE1_0_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tmr1e                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_TMR_IE1_0_t;


#define  SATURN_PER_TMR_IE1_1                            0x52224060
#define  SATURN_PER_TMR_IE1_1_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tmr1e                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_TMR_IE1_1_t;


#define  SATURN_PER_TMR_INT1_0                           0x52224064
#define  SATURN_PER_TMR_INT1_0_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tmr1i                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_TMR_INT1_0_t;


#define  SATURN_PER_TMR_INT1_1                           0x52224068
#define  SATURN_PER_TMR_INT1_1_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tmr1i                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_TMR_INT1_1_t;


#define  SATURN_PER_TMR_STAT1                            0x5222406c
#define  SATURN_PER_TMR_STAT1_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tmr1s                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_TMR_STAT1_t;


#define  SATURN_PER_TMR_LD2                              0x52224070
#define  SATURN_PER_TMR_LD2_dft                          0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t load2                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_TMR_LD2_t;


#define  SATURN_PER_TMR_CTRL2                            0x52224074
#define  SATURN_PER_TMR_CTRL2_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t clksel2              :  2 ; /* bits 3:2 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t rlmode2              :  1 ; /* bits 6:6 */
    ca_uint32_t timen2               :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd3               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_TMR_CTRL2_t;

#define      SATURN_timen2_DIS                                    0x0
#define      SATURN_timen2_ENA                                    0x1
#define      SATURN_rlmode2_ROLL                                  0x0
#define      SATURN_rlmode2_LOAD                                  0x1
#define      SATURN_clksel2_direct                                0x0
#define      SATURN_clksel2_dv64                                  0x1
#define      SATURN_clksel2_dv1024                                0x2
#define      SATURN_clksel2_dv4096                                0x3

#define  SATURN_PER_TMR_CNT2                             0x52224078
#define  SATURN_PER_TMR_CNT2_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t count2               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_TMR_CNT2_t;


#define  SATURN_PER_TMR_IE2_0                            0x5222407c
#define  SATURN_PER_TMR_IE2_0_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tmr1e                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_TMR_IE2_0_t;


#define  SATURN_PER_TMR_IE2_1                            0x52224080
#define  SATURN_PER_TMR_IE2_1_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tmr1e                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_TMR_IE2_1_t;


#define  SATURN_PER_TMR_INT2_0                           0x52224084
#define  SATURN_PER_TMR_INT2_0_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tmr1i                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_TMR_INT2_0_t;


#define  SATURN_PER_TMR_INT2_1                           0x52224088
#define  SATURN_PER_TMR_INT2_1_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tmr1i                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_TMR_INT2_1_t;


#define  SATURN_PER_TMR_STAT2                            0x5222408c
#define  SATURN_PER_TMR_STAT2_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tmr2s                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_TMR_STAT2_t;


#define  SATURN_PER_TMR_LOADE                            0x52224090
#define  SATURN_PER_TMR_LOADE_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t update_tmr1          :  1 ; /* bits 1:1 */
    ca_uint32_t update_tmr2          :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd2               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_TMR_LOADE_t;


#define  SATURN_PER_TMR_TST                              0x52224094
#define  SATURN_PER_TMR_TST_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t testclksel           :  1 ; /* bits 0:0 */
    ca_uint32_t test1                :  1 ; /* bits 1:1 */
    ca_uint32_t test2                :  1 ; /* bits 2:2 */
    ca_uint32_t pps_timer1_en        :  1 ; /* bits 3:3 */
    ca_uint32_t pps_timer2_en        :  1 ; /* bits 4:4 */
    ca_uint32_t pps_from_timer       :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_TMR_TST_t;


#define  SATURN_PER_SPI_CLK                              0x52224098
#define  SATURN_PER_SPI_CLK_dft                          0x00000002

typedef volatile union {
  struct {
    ca_uint32_t counter_load         : 16 ; /* bits 15:0 */
    ca_uint32_t ssp_igap             :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SPI_CLK_t;


#define  SATURN_PER_SPI_CFG                              0x5222409c
#define  SATURN_PER_SPI_CFG_dft                          0x3f090000

typedef volatile union {
  struct {
    ca_uint32_t command_cyc          :  1 ; /* bits 0:0 */
    ca_uint32_t read_write           :  1 ; /* bits 1:1 */
    ca_uint32_t micro_wire_cs_sel    :  5 ; /* bits 6:2 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t sel_ssp_cs           :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t ssp_cmd_cnt          :  7 ; /* bits 22:16 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t pre_ssp_dat_cnt      :  6 ; /* bits 29:24 */
    ca_uint32_t sspcs_en3_gpio       :  1 ; /* bits 30:30 */
    ca_uint32_t sspcs_en4_gpio       :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SPI_CFG_t;

#define      SATURN_micro_wire_cs_sel_SPI                         0x0
#define      SATURN_micro_wire_cs_sel_MWR                         0x1
#define      SATURN_read_write_WR                                 0x0
#define      SATURN_read_write_RD                                 0x1
#define      SATURN_command_cyc_NORM                              0x0
#define      SATURN_command_cyc_CONLY                             0x1

#define  SATURN_PER_SPI_MODE                             0x522240a0
#define  SATURN_PER_SPI_MODE_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cfg                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SPI_MODE_t;


#define  SATURN_PER_SPI_CTRL                             0x522240a4
#define  SATURN_PER_SPI_CTRL_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sspdone              :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  6 ;
    ca_uint32_t sspstart             :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd2               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SPI_CTRL_t;


#define  SATURN_PER_SPI_CA0                              0x522240a8
#define  SATURN_PER_SPI_CA0_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ssp_cmd_addr0        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SPI_CA0_t;


#define  SATURN_PER_SPI_CA1                              0x522240ac
#define  SATURN_PER_SPI_CA1_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ssp_cmd_addr1        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SPI_CA1_t;


#define  SATURN_PER_SPI_CA2                              0x522240b0
#define  SATURN_PER_SPI_CA2_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ssp_cmd_addr2        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SPI_CA2_t;


#define  SATURN_PER_SPI_WDAT1                            0x522240b4
#define  SATURN_PER_SPI_WDAT1_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ssp_wdata1           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SPI_WDAT1_t;


#define  SATURN_PER_SPI_WDAT0                            0x522240b8
#define  SATURN_PER_SPI_WDAT0_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ssp_wdata0           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SPI_WDAT0_t;


#define  SATURN_PER_SPI_RDAT1                            0x522240bc
#define  SATURN_PER_SPI_RDAT1_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ssp_rdata1           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SPI_RDAT1_t;


#define  SATURN_PER_SPI_RDAT0                            0x522240c0
#define  SATURN_PER_SPI_RDAT0_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ssp_rdata0           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SPI_RDAT0_t;


#define  SATURN_PER_SPI_IE_0                             0x522240c4
#define  SATURN_PER_SPI_IE_0_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t spie                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SPI_IE_0_t;


#define  SATURN_PER_SPI_INT_0                            0x522240c8
#define  SATURN_PER_SPI_INT_0_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sspi                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SPI_INT_0_t;


#define  SATURN_PER_SPI_IE_1                             0x522240cc
#define  SATURN_PER_SPI_IE_1_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t spie                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SPI_IE_1_t;


#define  SATURN_PER_SPI_INT_1                            0x522240d0
#define  SATURN_PER_SPI_INT_1_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sspi                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SPI_INT_1_t;


#define  SATURN_PER_SPI_STAT                             0x522240d4
#define  SATURN_PER_SPI_STAT_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ssps                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SPI_STAT_t;


#define  SATURN_PER_MDIO_CFG                             0x522240d8
#define  SATURN_PER_MDIO_CFG_dft                         0x10000001

typedef volatile union {
  struct {
    ca_uint32_t mdio_manual          :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 15 ;
    ca_uint32_t mdio_pre_scale       : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_MDIO_CFG_t;

#define      SATURN_mdio_manual_AUTO                              0x0
#define      SATURN_mdio_manual_MAN                               0x1

#define  SATURN_PER_MDIO_ADDR                            0x522240dc
#define  SATURN_PER_MDIO_ADDR_dft                        0x00080000

typedef volatile union {
  struct {
    ca_uint32_t mdio_addr            :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t mdio_offset          :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t mdio_rd_wr           :  1 ; /* bits 15:15 */
    ca_uint32_t mdio_st              :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t mdio_op              :  2 ; /* bits 19:18 */
    ca_uint32_t rsrvd4               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_MDIO_ADDR_t;

#define      SATURN_mdio_op_ADDR_WR                               0x0
#define      SATURN_mdio_op_WR                                    0x1
#define      SATURN_mdio_op_RD_INC                                0x2
#define      SATURN_mdio_op_RD                                    0x3
#define      SATURN_mdio_st_Direct                                0x0
#define      SATURN_mdio_st_Indirect                              0x1
#define      SATURN_mdio_rd_wr_WR                                 0x0
#define      SATURN_mdio_rd_wr_RD                                 0x1
#define      SATURN_mdio_addr_NORM                                0x0
#define      SATURN_mdio_addr_CONLY                               0x1

#define  SATURN_PER_MDIO_WRDATA                          0x522240e0
#define  SATURN_PER_MDIO_WRDATA_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mdio_wrdata          : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_MDIO_WRDATA_t;


#define  SATURN_PER_MDIO_RDDATA                          0x522240e4
#define  SATURN_PER_MDIO_RDDATA_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mdio_rddata          : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_MDIO_RDDATA_t;


#define  SATURN_PER_MDIO_CTRL                            0x522240e8
#define  SATURN_PER_MDIO_CTRL_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mdiodone             :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  6 ;
    ca_uint32_t mdiostart            :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd2               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_MDIO_CTRL_t;


#define  SATURN_PER_MDIO_AUTO_CFG                        0x522240ec
#define  SATURN_PER_MDIO_AUTO_CFG_dft                    0x00001f00

typedef volatile union {
  struct {
    ca_uint32_t auto_mdio_phy_start_idx :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t auto_mdio_phy_end_idx :  6 ; /* bits 13:8 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t auto_mdio_gpio       :  1 ; /* bits 15:15 */
    ca_uint32_t auto_mdio_reg_to_read :  5 ; /* bits 20:16 */
    ca_uint32_t rsrvd3               : 11 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_MDIO_AUTO_CFG_t;

#define      SATURN_auto_mdio_gpio_32                             0x0
#define      SATURN_auto_mdio_gpio_64                             0x1

#define  SATURN_PER_MDIO_AUTO_INTV                       0x522240f0
#define  SATURN_PER_MDIO_AUTO_INTV_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t poll_wait_cycles     : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_MDIO_AUTO_INTV_t;


#define  SATURN_PER_MDIO_AUTO_RM                         0x522240f4
#define  SATURN_PER_MDIO_AUTO_RM_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t auto_mdio_bit_invert : 16 ; /* bits 15:0 */
    ca_uint32_t auto_mdio_bit_mask   : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_MDIO_AUTO_RM_t;

#define      SATURN_auto_mdio_bit_mask_UNMASKED                   0x0
#define      SATURN_auto_mdio_bit_mask_MASKED                     0x1
#define      SATURN_auto_mdio_bit_invert_NONINV                   0x0
#define      SATURN_auto_mdio_bit_invert_INV                      0x1

#define  SATURN_PER_MDIO_AUTO_AADDR                      0x522240f8
#define  SATURN_PER_MDIO_AUTO_AADDR_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t auto_mdio_phy_alert_addr :  5 ; /* bits 4:0 */
    ca_uint32_t auto_mdio_phy_alert_range :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               : 10 ;
    ca_uint32_t auto_mdio_rddata     : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_MDIO_AUTO_AADDR_t;

#define      SATURN_auto_mdio_phy_alert_range_low                 0x0
#define      SATURN_auto_mdio_phy_alert_range_hi                  0x1

#define  SATURN_PER_MDIO_ENTAB0                          0x522240fc
#define  SATURN_PER_MDIO_ENTAB0_dft                      0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t slot_enable0         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_MDIO_ENTAB0_t;


#define  SATURN_PER_MDIO_ENTAB1                          0x52224100
#define  SATURN_PER_MDIO_ENTAB1_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t slot_enable1         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_MDIO_ENTAB1_t;


#define  SATURN_PER_MDIO_ITAB0                           0x52224104
#define  SATURN_PER_MDIO_ITAB0_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t i                    : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_MDIO_ITAB0_t;


#define  SATURN_PER_MDIO_ITAB1                           0x52224108
#define  SATURN_PER_MDIO_ITAB1_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t i                    : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_MDIO_ITAB1_t;


#define  SATURN_PER_MDIO_IE_0                            0x5222410c
#define  SATURN_PER_MDIO_IE_0_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mdioe                :  1 ; /* bits 0:0 */
    ca_uint32_t autopolle            :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_MDIO_IE_0_t;


#define  SATURN_PER_MDIO_INT_0                           0x52224110
#define  SATURN_PER_MDIO_INT_0_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mdioi                :  1 ; /* bits 0:0 */
    ca_uint32_t autopolli            :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_MDIO_INT_0_t;


#define  SATURN_PER_MDIO_IE_1                            0x52224114
#define  SATURN_PER_MDIO_IE_1_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mdioe                :  1 ; /* bits 0:0 */
    ca_uint32_t autopolle            :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_MDIO_IE_1_t;


#define  SATURN_PER_MDIO_INT_1                           0x52224118
#define  SATURN_PER_MDIO_INT_1_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mdioi                :  1 ; /* bits 0:0 */
    ca_uint32_t autopolli            :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_MDIO_INT_1_t;


#define  SATURN_PER_MDIO_STAT                            0x5222411c
#define  SATURN_PER_MDIO_STAT_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mdios                :  1 ; /* bits 0:0 */
    ca_uint32_t autopolls            :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_MDIO_STAT_t;


#define  SATURN_PER_BIW_CFG                              0x52224120
#define  SATURN_PER_BIW_CFG_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t core_en              :  1 ; /* bits 0:0 */
    ca_uint32_t biw_soft_reset       :  1 ; /* bits 1:1 */
    ca_uint32_t busywait_en          :  1 ; /* bits 2:2 */
    ca_uint32_t stretch_en           :  1 ; /* bits 3:3 */
    ca_uint32_t arb_en               :  1 ; /* bits 4:4 */
    ca_uint32_t clksync_en           :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t spike_cnt            :  4 ; /* bits 11:8 */
    ca_uint32_t rsrvd2               :  4 ;
    ca_uint32_t prer                 : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_BIW_CFG_t;

#define      SATURN_core_en_DIS                                   0x0
#define      SATURN_core_en_ENA                                   0x1

#define  SATURN_PER_BIW_CTRL                             0x52224124
#define  SATURN_PER_BIW_CTRL_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t biwdone              :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t ack_in               :  1 ; /* bits 3:3 */
    ca_uint32_t write                :  1 ; /* bits 4:4 */
    ca_uint32_t read                 :  1 ; /* bits 5:5 */
    ca_uint32_t stop                 :  1 ; /* bits 6:6 */
    ca_uint32_t start                :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd2               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_BIW_CTRL_t;


#define  SATURN_PER_BIW_TXR                              0x52224128
#define  SATURN_PER_BIW_TXR_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t txr                  :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_BIW_TXR_t;


#define  SATURN_PER_BIW_RXR                              0x5222412c
#define  SATURN_PER_BIW_RXR_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rxr                  :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_BIW_RXR_t;


#define  SATURN_PER_BIW_ACK                              0x52224130
#define  SATURN_PER_BIW_ACK_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t al                   :  1 ; /* bits 0:0 */
    ca_uint32_t biw_busy             :  1 ; /* bits 1:1 */
    ca_uint32_t ack_out              :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_BIW_ACK_t;

#define      SATURN_biw_busy_FREE                                 0x0
#define      SATURN_biw_busy_BUSY                                 0x1
#define      SATURN_al_OK                                         0x0
#define      SATURN_al_LOST                                       0x1

#define  SATURN_PER_BIW_IE_0                             0x52224134
#define  SATURN_PER_BIW_IE_0_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t biwe                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_BIW_IE_0_t;


#define  SATURN_PER_BIW_INT_0                            0x52224138
#define  SATURN_PER_BIW_INT_0_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t biwi                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_BIW_INT_0_t;


#define  SATURN_PER_BIW_IE_1                             0x5222413c
#define  SATURN_PER_BIW_IE_1_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t biwe                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_BIW_IE_1_t;


#define  SATURN_PER_BIW_INT_1                            0x52224140
#define  SATURN_PER_BIW_INT_1_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t biwi                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_BIW_INT_1_t;


#define  SATURN_PER_BIW_STAT                             0x52224144
#define  SATURN_PER_BIW_STAT_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t biws                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_BIW_STAT_t;


#define  SATURN_PER_UART0_CFG                            0x52224148
#define  SATURN_PER_UART0_CFG_dft                        0x00000003

typedef volatile union {
  struct {
    ca_uint32_t char_cnt             :  2 ; /* bits 1:0 */
    ca_uint32_t uart_stop_2bit       :  1 ; /* bits 2:2 */
    ca_uint32_t even_parity_sel      :  1 ; /* bits 3:3 */
    ca_uint32_t uart_parity_en       :  1 ; /* bits 4:4 */
    ca_uint32_t tx_sm_enable         :  1 ; /* bits 5:5 */
    ca_uint32_t rx_sm_enable         :  1 ; /* bits 6:6 */
    ca_uint32_t uart_en              :  1 ; /* bits 7:7 */
    ca_uint32_t baud_count           : 24 ; /* bits 31:8 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART0_CFG_t;

#define      SATURN_uart_en_DIS                                   0x0
#define      SATURN_uart_en_ENA                                   0x1
#define      SATURN_rx_sm_enable_DIS                              0x0
#define      SATURN_rx_sm_enable_ENA                              0x1
#define      SATURN_tx_sm_enable_DIS                              0x0
#define      SATURN_tx_sm_enable_ENA                              0x1
#define      SATURN_uart_parity_en_DIS                            0x0
#define      SATURN_uart_parity_en_ENA                            0x1
#define      SATURN_even_parity_sel_ODD                           0x0
#define      SATURN_even_parity_sel_EvEN                          0x1
#define      SATURN_uart_stop_2bit_1                              0x0
#define      SATURN_uart_stop_2bit_2                              0x1
#define      SATURN_char_cnt_5                                    0x0
#define      SATURN_char_cnt_6                                    0x1
#define      SATURN_char_cnt_7                                    0x2
#define      SATURN_char_cnt_8                                    0x3

#define  SATURN_PER_UART0_FC                             0x5222414c
#define  SATURN_PER_UART0_FC_dft                         0x00000588

typedef volatile union {
  struct {
    ca_uint32_t rx_wm                :  6 ; /* bits 5:0 */
    ca_uint32_t inv_cts              :  1 ; /* bits 6:6 */
    ca_uint32_t no_cts               :  1 ; /* bits 7:7 */
    ca_uint32_t cts_reg              :  1 ; /* bits 8:8 */
    ca_uint32_t inv_rts              :  1 ; /* bits 9:9 */
    ca_uint32_t no_rts               :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd1               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART0_FC_t;

#define      SATURN_no_rts_ENA                                    0x0
#define      SATURN_no_rts_DIS                                    0x1
#define      SATURN_inv_rts_POS                                   0x0
#define      SATURN_inv_rts_NEG                                   0x1
#define      SATURN_no_cts_ENA                                    0x0
#define      SATURN_no_cts_DIS                                    0x1
#define      SATURN_inv_cts_POS                                   0x0
#define      SATURN_inv_cts_NEG                                   0x1

#define  SATURN_PER_UART0_RX_SAMPLE                      0x52224150
#define  SATURN_PER_UART0_RX_SAMPLE_dft                  0x0000000f

typedef volatile union {
  struct {
    ca_uint32_t rx_center            : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART0_RX_SAMPLE_t;


#define  SATURN_PER_UART0_TUN                            0x52224154
#define  SATURN_PER_UART0_TUN_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_fine_tune_ctl     :  8 ; /* bits 7:0 */
    ca_uint32_t rx_tune_add          :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t tx_fine_tune_ctl     :  8 ; /* bits 23:16 */
    ca_uint32_t tx_tune_add          :  1 ; /* bits 24:24 */
    ca_uint32_t rsrvd2               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART0_TUN_t;

#define      SATURN_tx_tune_add_FASTER                            0x0
#define      SATURN_tx_tune_add_SLOWER                            0x1
#define      SATURN_rx_tune_add_FASTER                            0x0
#define      SATURN_rx_tune_add_SLOWER                            0x1

#define  SATURN_PER_UART0_TXDAT                          0x52224158
#define  SATURN_PER_UART0_TXDAT_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_data              :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART0_TXDAT_t;


#define  SATURN_PER_UART0_RXDAT                          0x5222415c
#define  SATURN_PER_UART0_RXDAT_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_data_lat          :  8 ; /* bits 7:0 */
    ca_uint32_t rx_data_vld          :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART0_RXDAT_t;


#define  SATURN_PER_UART0_INFO                           0x52224160
#define  SATURN_PER_UART0_INFO_dft                       0x0000000a

typedef volatile union {
  struct {
    ca_uint32_t rx_fifo_full         :  1 ; /* bits 0:0 */
    ca_uint32_t rx_fifo_empty        :  1 ; /* bits 1:1 */
    ca_uint32_t tx_fifo_full         :  1 ; /* bits 2:2 */
    ca_uint32_t tx_fifo_empty        :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART0_INFO_t;


#define  SATURN_PER_UART0_IE_0                           0x52224164
#define  SATURN_PER_UART0_IE_0_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overrune     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_erre         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_erre       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overrune     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underrune    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptye       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptye    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART0_IE_0_t;


#define  SATURN_PER_UART0_IE_1                           0x52224168
#define  SATURN_PER_UART0_IE_1_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overrune     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_erre         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_erre       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overrune     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underrune    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptye       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptye    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART0_IE_1_t;


#define  SATURN_PER_UART0_INT_0                          0x5222416c
#define  SATURN_PER_UART0_INT_0_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overruni     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_erri         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_erri       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overruni     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underruni    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptyi       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptyi    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART0_INT_0_t;


#define  SATURN_PER_UART0_INT_1                          0x52224170
#define  SATURN_PER_UART0_INT_1_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overruni     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_erri         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_erri       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overruni     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underruni    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptyi       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptyi    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART0_INT_1_t;


#define  SATURN_PER_UART0_STAT                           0x52224174
#define  SATURN_PER_UART0_STAT_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overruns     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_errs         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_errs       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overruns     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underruns    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptys       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptys    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART0_STAT_t;


#define  SATURN_PER_UART1_CFG                            0x52224178
#define  SATURN_PER_UART1_CFG_dft                        0x00000003

typedef volatile union {
  struct {
    ca_uint32_t char_cnt             :  2 ; /* bits 1:0 */
    ca_uint32_t uart_stop_2bit       :  1 ; /* bits 2:2 */
    ca_uint32_t even_parity_sel      :  1 ; /* bits 3:3 */
    ca_uint32_t uart_parity_en       :  1 ; /* bits 4:4 */
    ca_uint32_t tx_sm_enable         :  1 ; /* bits 5:5 */
    ca_uint32_t rx_sm_enable         :  1 ; /* bits 6:6 */
    ca_uint32_t uart_en              :  1 ; /* bits 7:7 */
    ca_uint32_t baud_count           : 24 ; /* bits 31:8 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART1_CFG_t;


#define  SATURN_PER_UART1_FC                             0x5222417c
#define  SATURN_PER_UART1_FC_dft                         0x00000588

typedef volatile union {
  struct {
    ca_uint32_t rx_wm                :  6 ; /* bits 5:0 */
    ca_uint32_t inv_cts              :  1 ; /* bits 6:6 */
    ca_uint32_t no_cts               :  1 ; /* bits 7:7 */
    ca_uint32_t cts_reg              :  1 ; /* bits 8:8 */
    ca_uint32_t inv_rts              :  1 ; /* bits 9:9 */
    ca_uint32_t no_rts               :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd1               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART1_FC_t;


#define  SATURN_PER_UART1_RX_SAMPLE                      0x52224180
#define  SATURN_PER_UART1_RX_SAMPLE_dft                  0x0000000f

typedef volatile union {
  struct {
    ca_uint32_t rx_center            : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART1_RX_SAMPLE_t;


#define  SATURN_PER_UART1_TUN                            0x52224184
#define  SATURN_PER_UART1_TUN_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_fine_tune_ctl     :  8 ; /* bits 7:0 */
    ca_uint32_t rx_tune_add          :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t tx_fine_tune_ctl     :  8 ; /* bits 23:16 */
    ca_uint32_t tx_tune_add          :  1 ; /* bits 24:24 */
    ca_uint32_t rsrvd2               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART1_TUN_t;


#define  SATURN_PER_UART1_TXDAT                          0x52224188
#define  SATURN_PER_UART1_TXDAT_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_data              :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART1_TXDAT_t;


#define  SATURN_PER_UART1_RXDAT                          0x5222418c
#define  SATURN_PER_UART1_RXDAT_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_data_lat          :  8 ; /* bits 7:0 */
    ca_uint32_t rx_data_vld          :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART1_RXDAT_t;


#define  SATURN_PER_UART1_INFO                           0x52224190
#define  SATURN_PER_UART1_INFO_dft                       0x0000000a

typedef volatile union {
  struct {
    ca_uint32_t rx_fifo_full         :  1 ; /* bits 0:0 */
    ca_uint32_t rx_fifo_empty        :  1 ; /* bits 1:1 */
    ca_uint32_t tx_fifo_full         :  1 ; /* bits 2:2 */
    ca_uint32_t tx_fifo_empty        :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART1_INFO_t;


#define  SATURN_PER_UART1_IE_0                           0x52224194
#define  SATURN_PER_UART1_IE_0_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overrune     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_erre         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_erre       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overrune     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underrune    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptye       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptye    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART1_IE_0_t;


#define  SATURN_PER_UART1_IE_1                           0x52224198
#define  SATURN_PER_UART1_IE_1_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overrune     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_erre         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_erre       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overrune     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underrune    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptye       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptye    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART1_IE_1_t;


#define  SATURN_PER_UART1_INT_0                          0x5222419c
#define  SATURN_PER_UART1_INT_0_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overruni     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_erri         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_erri       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overruni     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underruni    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptyi       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptyi    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART1_INT_0_t;


#define  SATURN_PER_UART1_INT_1                          0x522241a0
#define  SATURN_PER_UART1_INT_1_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overruni     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_erri         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_erri       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overruni     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underruni    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptyi       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptyi    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART1_INT_1_t;


#define  SATURN_PER_UART1_STAT                           0x522241a4
#define  SATURN_PER_UART1_STAT_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overruns     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_errs         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_errs       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overruns     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underruns    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptys       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptys    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART1_STAT_t;


#define  SATURN_PER_UART2_CFG                            0x522241a8
#define  SATURN_PER_UART2_CFG_dft                        0x00000003

typedef volatile union {
  struct {
    ca_uint32_t char_cnt             :  2 ; /* bits 1:0 */
    ca_uint32_t uart_stop_2bit       :  1 ; /* bits 2:2 */
    ca_uint32_t even_parity_sel      :  1 ; /* bits 3:3 */
    ca_uint32_t uart_parity_en       :  1 ; /* bits 4:4 */
    ca_uint32_t tx_sm_enable         :  1 ; /* bits 5:5 */
    ca_uint32_t rx_sm_enable         :  1 ; /* bits 6:6 */
    ca_uint32_t uart_en              :  1 ; /* bits 7:7 */
    ca_uint32_t baud_count           : 24 ; /* bits 31:8 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART2_CFG_t;


#define  SATURN_PER_UART2_FC                             0x522241ac
#define  SATURN_PER_UART2_FC_dft                         0x00000588

typedef volatile union {
  struct {
    ca_uint32_t rx_wm                :  6 ; /* bits 5:0 */
    ca_uint32_t inv_cts              :  1 ; /* bits 6:6 */
    ca_uint32_t no_cts               :  1 ; /* bits 7:7 */
    ca_uint32_t cts_reg              :  1 ; /* bits 8:8 */
    ca_uint32_t inv_rts              :  1 ; /* bits 9:9 */
    ca_uint32_t no_rts               :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd1               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART2_FC_t;


#define  SATURN_PER_UART2_RX_SAMPLE                      0x522241b0
#define  SATURN_PER_UART2_RX_SAMPLE_dft                  0x0000000f

typedef volatile union {
  struct {
    ca_uint32_t rx_center            : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART2_RX_SAMPLE_t;


#define  SATURN_PER_UART2_TUN                            0x522241b4
#define  SATURN_PER_UART2_TUN_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_fine_tune_ctl     :  8 ; /* bits 7:0 */
    ca_uint32_t rx_tune_add          :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t tx_fine_tune_ctl     :  8 ; /* bits 23:16 */
    ca_uint32_t tx_tune_add          :  1 ; /* bits 24:24 */
    ca_uint32_t rsrvd2               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART2_TUN_t;


#define  SATURN_PER_UART2_TXDAT                          0x522241b8
#define  SATURN_PER_UART2_TXDAT_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_data              :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART2_TXDAT_t;


#define  SATURN_PER_UART2_RXDAT                          0x522241bc
#define  SATURN_PER_UART2_RXDAT_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_data_lat          :  8 ; /* bits 7:0 */
    ca_uint32_t rx_data_vld          :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART2_RXDAT_t;


#define  SATURN_PER_UART2_INFO                           0x522241c0
#define  SATURN_PER_UART2_INFO_dft                       0x0000000a

typedef volatile union {
  struct {
    ca_uint32_t rx_fifo_full         :  1 ; /* bits 0:0 */
    ca_uint32_t rx_fifo_empty        :  1 ; /* bits 1:1 */
    ca_uint32_t tx_fifo_full         :  1 ; /* bits 2:2 */
    ca_uint32_t tx_fifo_empty        :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART2_INFO_t;


#define  SATURN_PER_UART2_IE_0                           0x522241c4
#define  SATURN_PER_UART2_IE_0_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overrune     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_erre         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_erre       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overrune     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underrune    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptye       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptye    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART2_IE_0_t;


#define  SATURN_PER_UART2_IE_1                           0x522241c8
#define  SATURN_PER_UART2_IE_1_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overrune     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_erre         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_erre       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overrune     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underrune    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptye       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptye    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART2_IE_1_t;


#define  SATURN_PER_UART2_INT_0                          0x522241cc
#define  SATURN_PER_UART2_INT_0_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overruni     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_erri         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_erri       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overruni     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underruni    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptyi       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptyi    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART2_INT_0_t;


#define  SATURN_PER_UART2_INT_1                          0x522241d0
#define  SATURN_PER_UART2_INT_1_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overruni     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_erri         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_erri       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overruni     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underruni    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptyi       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptyi    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART2_INT_1_t;


#define  SATURN_PER_UART2_STAT                           0x522241d4
#define  SATURN_PER_UART2_STAT_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overruns     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_errs         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_errs       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overruns     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underruns    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptys       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptys    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART2_STAT_t;


#define  SATURN_PER_UART3_CFG                            0x522241d8
#define  SATURN_PER_UART3_CFG_dft                        0x00000003

typedef volatile union {
  struct {
    ca_uint32_t char_cnt             :  2 ; /* bits 1:0 */
    ca_uint32_t uart_stop_2bit       :  1 ; /* bits 2:2 */
    ca_uint32_t even_parity_sel      :  1 ; /* bits 3:3 */
    ca_uint32_t uart_parity_en       :  1 ; /* bits 4:4 */
    ca_uint32_t tx_sm_enable         :  1 ; /* bits 5:5 */
    ca_uint32_t rx_sm_enable         :  1 ; /* bits 6:6 */
    ca_uint32_t uart_en              :  1 ; /* bits 7:7 */
    ca_uint32_t baud_count           : 24 ; /* bits 31:8 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART3_CFG_t;


#define  SATURN_PER_UART3_FC                             0x522241dc
#define  SATURN_PER_UART3_FC_dft                         0x00000588

typedef volatile union {
  struct {
    ca_uint32_t rx_wm                :  6 ; /* bits 5:0 */
    ca_uint32_t inv_cts              :  1 ; /* bits 6:6 */
    ca_uint32_t no_cts               :  1 ; /* bits 7:7 */
    ca_uint32_t cts_reg              :  1 ; /* bits 8:8 */
    ca_uint32_t inv_rts              :  1 ; /* bits 9:9 */
    ca_uint32_t no_rts               :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd1               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART3_FC_t;


#define  SATURN_PER_UART3_RX_SAMPLE                      0x522241e0
#define  SATURN_PER_UART3_RX_SAMPLE_dft                  0x0000000f

typedef volatile union {
  struct {
    ca_uint32_t rx_center            : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART3_RX_SAMPLE_t;


#define  SATURN_PER_UART3_TUN                            0x522241e4
#define  SATURN_PER_UART3_TUN_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_fine_tune_ctl     :  8 ; /* bits 7:0 */
    ca_uint32_t rx_tune_add          :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t tx_fine_tune_ctl     :  8 ; /* bits 23:16 */
    ca_uint32_t tx_tune_add          :  1 ; /* bits 24:24 */
    ca_uint32_t rsrvd2               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART3_TUN_t;


#define  SATURN_PER_UART3_TXDAT                          0x522241e8
#define  SATURN_PER_UART3_TXDAT_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_data              :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART3_TXDAT_t;


#define  SATURN_PER_UART3_RXDAT                          0x522241ec
#define  SATURN_PER_UART3_RXDAT_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_data_lat          :  8 ; /* bits 7:0 */
    ca_uint32_t rx_data_vld          :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART3_RXDAT_t;


#define  SATURN_PER_UART3_INFO                           0x522241f0
#define  SATURN_PER_UART3_INFO_dft                       0x0000000a

typedef volatile union {
  struct {
    ca_uint32_t rx_fifo_full         :  1 ; /* bits 0:0 */
    ca_uint32_t rx_fifo_empty        :  1 ; /* bits 1:1 */
    ca_uint32_t tx_fifo_full         :  1 ; /* bits 2:2 */
    ca_uint32_t tx_fifo_empty        :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART3_INFO_t;


#define  SATURN_PER_UART3_IE_0                           0x522241f4
#define  SATURN_PER_UART3_IE_0_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overrune     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_erre         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_erre       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overrune     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underrune    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptye       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptye    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART3_IE_0_t;


#define  SATURN_PER_UART3_IE_1                           0x522241f8
#define  SATURN_PER_UART3_IE_1_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overrune     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_erre         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_erre       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overrune     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underrune    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptye       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptye    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART3_IE_1_t;


#define  SATURN_PER_UART3_INT_0                          0x522241fc
#define  SATURN_PER_UART3_INT_0_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overruni     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_erri         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_erri       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overruni     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underruni    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptyi       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptyi    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART3_INT_0_t;


#define  SATURN_PER_UART3_INT_1                          0x52224200
#define  SATURN_PER_UART3_INT_1_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overruni     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_erri         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_erri       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overruni     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underruni    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptyi       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptyi    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART3_INT_1_t;


#define  SATURN_PER_UART3_STAT                           0x52224204
#define  SATURN_PER_UART3_STAT_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overruns     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_errs         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_errs       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overruns     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underruns    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptys       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptys    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_UART3_STAT_t;


#define  SATURN_PER_TOD_CFG                              0x52224208
#define  SATURN_PER_TOD_CFG_dft                          0x00000026

typedef volatile union {
  struct {
    ca_uint32_t tod_counter          :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t tod_en               :  1 ; /* bits 7:7 */
    ca_uint32_t tod_uart             :  2 ; /* bits 9:8 */
    ca_uint32_t rsrvd2               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_TOD_CFG_t;


#define  SATURN_PER_TOD_MEM                              0x52224240
#define  SATURN_PER_TOD_MEM_STRIDE                       4
#define  SATURN_PER_TOD_MEM_COUNT                        16
#define  SATURN_PER_TOD_MEM_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tod_bst_mem          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_TOD_MEM_t;


#define  SATURN_PER_GPIO0_CFG                            0x52224280
#define  SATURN_PER_GPIO0_CFG_dft                        0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t iopmod               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_GPIO0_CFG_t;

#define      SATURN_iopmod_OUT                                    0x0
#define      SATURN_iopmod_IN                                     0x1

#define  SATURN_PER_GPIO0_OUT                            0x52224284
#define  SATURN_PER_GPIO0_OUT_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dataout              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_GPIO0_OUT_t;


#define  SATURN_PER_GPIO0_IN                             0x52224288
#define  SATURN_PER_GPIO0_IN_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t iopdata              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_GPIO0_IN_t;


#define  SATURN_PER_GPIO0_LVL                            0x5222428c
#define  SATURN_PER_GPIO0_LVL_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t level                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_GPIO0_LVL_t;

#define      SATURN_level_LOW                                     0x0
#define      SATURN_level_HIGH                                    0x1

#define  SATURN_PER_GPIO0_EDGE                           0x52224290
#define  SATURN_PER_GPIO0_EDGE_dft                       0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t i_edge               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_GPIO0_EDGE_t;

#define      SATURN_i_edge_LOW                                    0x0
#define      SATURN_i_edge_HIGH                                   0x1

#define  SATURN_PER_GPIO0_BOTHEDGE                       0x52224294
#define  SATURN_PER_GPIO0_BOTHEDGE_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t i_bothedge           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_GPIO0_BOTHEDGE_t;

#define      SATURN_i_bothedge_LOW                                0x0
#define      SATURN_i_bothedge_HIGH                               0x1

#define  SATURN_PER_GPIO0_IE                             0x52224298
#define  SATURN_PER_GPIO0_IE_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gpioe                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_GPIO0_IE_t;


#define  SATURN_PER_GPIO0_INT                            0x5222429c
#define  SATURN_PER_GPIO0_INT_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gpioi                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_GPIO0_INT_t;


#define  SATURN_PER_GPIO0_STAT                           0x522242a0
#define  SATURN_PER_GPIO0_STAT_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gpios                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_GPIO0_STAT_t;


#define  SATURN_PER_GPIO1_CFG                            0x522242a4
#define  SATURN_PER_GPIO1_CFG_dft                        0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t iopmod               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_GPIO1_CFG_t;


#define  SATURN_PER_GPIO1_OUT                            0x522242a8
#define  SATURN_PER_GPIO1_OUT_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dataout              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_GPIO1_OUT_t;


#define  SATURN_PER_GPIO1_IN                             0x522242ac
#define  SATURN_PER_GPIO1_IN_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t iopdata              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_GPIO1_IN_t;


#define  SATURN_PER_GPIO1_LVL                            0x522242b0
#define  SATURN_PER_GPIO1_LVL_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t level                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_GPIO1_LVL_t;


#define  SATURN_PER_GPIO1_EDGE                           0x522242b4
#define  SATURN_PER_GPIO1_EDGE_dft                       0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t i_edge               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_GPIO1_EDGE_t;


#define  SATURN_PER_GPIO1_BOTHEDGE                       0x522242b8
#define  SATURN_PER_GPIO1_BOTHEDGE_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t i_bothedge           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_GPIO1_BOTHEDGE_t;


#define  SATURN_PER_GPIO1_IE                             0x522242bc
#define  SATURN_PER_GPIO1_IE_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gpioe                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_GPIO1_IE_t;


#define  SATURN_PER_GPIO1_INT                            0x522242c0
#define  SATURN_PER_GPIO1_INT_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gpioi                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_GPIO1_INT_t;


#define  SATURN_PER_GPIO1_STAT                           0x522242c4
#define  SATURN_PER_GPIO1_STAT_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gpios                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_GPIO1_STAT_t;


#define  SATURN_PER_GPIO2_CFG                            0x522242c8
#define  SATURN_PER_GPIO2_CFG_dft                        0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t iopmod               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_GPIO2_CFG_t;


#define  SATURN_PER_GPIO2_OUT                            0x522242cc
#define  SATURN_PER_GPIO2_OUT_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dataout              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_GPIO2_OUT_t;


#define  SATURN_PER_GPIO2_IN                             0x522242d0
#define  SATURN_PER_GPIO2_IN_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t iopdata              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_GPIO2_IN_t;


#define  SATURN_PER_GPIO2_LVL                            0x522242d4
#define  SATURN_PER_GPIO2_LVL_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t level                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_GPIO2_LVL_t;


#define  SATURN_PER_GPIO2_EDGE                           0x522242d8
#define  SATURN_PER_GPIO2_EDGE_dft                       0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t i_edge               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_GPIO2_EDGE_t;


#define  SATURN_PER_GPIO2_BOTHEDGE                       0x522242dc
#define  SATURN_PER_GPIO2_BOTHEDGE_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t i_bothedge           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_GPIO2_BOTHEDGE_t;


#define  SATURN_PER_GPIO2_IE                             0x522242e0
#define  SATURN_PER_GPIO2_IE_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gpioe                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_GPIO2_IE_t;


#define  SATURN_PER_GPIO2_INT                            0x522242e4
#define  SATURN_PER_GPIO2_INT_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gpioi                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_GPIO2_INT_t;


#define  SATURN_PER_GPIO2_STAT                           0x522242e8
#define  SATURN_PER_GPIO2_STAT_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gpios                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_GPIO2_STAT_t;


#define  SATURN_PER_GPIO3_CFG                            0x522242ec
#define  SATURN_PER_GPIO3_CFG_dft                        0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t iopmod               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_GPIO3_CFG_t;


#define  SATURN_PER_GPIO3_OUT                            0x522242f0
#define  SATURN_PER_GPIO3_OUT_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dataout              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_GPIO3_OUT_t;


#define  SATURN_PER_GPIO3_IN                             0x522242f4
#define  SATURN_PER_GPIO3_IN_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t iopdata              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_GPIO3_IN_t;


#define  SATURN_PER_GPIO3_LVL                            0x522242f8
#define  SATURN_PER_GPIO3_LVL_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t level                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_GPIO3_LVL_t;


#define  SATURN_PER_GPIO3_EDGE                           0x522242fc
#define  SATURN_PER_GPIO3_EDGE_dft                       0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t i_edge               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_GPIO3_EDGE_t;


#define  SATURN_PER_GPIO3_BOTHEDGE                       0x52224300
#define  SATURN_PER_GPIO3_BOTHEDGE_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t i_bothedge           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_GPIO3_BOTHEDGE_t;


#define  SATURN_PER_GPIO3_IE                             0x52224304
#define  SATURN_PER_GPIO3_IE_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gpioe                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_GPIO3_IE_t;


#define  SATURN_PER_GPIO3_INT                            0x52224308
#define  SATURN_PER_GPIO3_INT_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gpioi                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_GPIO3_INT_t;


#define  SATURN_PER_GPIO3_STAT                           0x5222430c
#define  SATURN_PER_GPIO3_STAT_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gpios                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_GPIO3_STAT_t;


#define  SATURN_PER_SYS_TIMER1                           0x52224310
#define  SATURN_PER_SYS_TIMER1_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gtimer1              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SYS_TIMER1_t;


#define  SATURN_PER_SYS_TIMER0                           0x52224314
#define  SATURN_PER_SYS_TIMER0_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gtimer0              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SYS_TIMER0_t;


#define  SATURN_PER_SYS_TIMER_COMPARATOR_CPU_01          0x52224318
#define  SATURN_PER_SYS_TIMER_COMPARATOR_CPU_01_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t comp1                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SYS_TIMER_COMPARATOR_CPU_01_t;


#define  SATURN_PER_SYS_TIMER_COMPARATOR_CPU_00          0x5222431c
#define  SATURN_PER_SYS_TIMER_COMPARATOR_CPU_00_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t comp0                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SYS_TIMER_COMPARATOR_CPU_00_t;


#define  SATURN_PER_SYS_TIMER_AUTOINC_CPU_01             0x52224320
#define  SATURN_PER_SYS_TIMER_AUTOINC_CPU_01_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t autoinc1             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SYS_TIMER_AUTOINC_CPU_01_t;


#define  SATURN_PER_SYS_TIMER_AUTOINC_CPU_00             0x52224324
#define  SATURN_PER_SYS_TIMER_AUTOINC_CPU_00_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t autoinc0             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SYS_TIMER_AUTOINC_CPU_00_t;


#define  SATURN_PER_SYS_TIMER_CPU_0_INTENABLE            0x52224328
#define  SATURN_PER_SYS_TIMER_CPU_0_INTENABLE_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t systimere            :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SYS_TIMER_CPU_0_INTENABLE_t;


#define  SATURN_PER_SYS_TIMER_CPU_0_INTERRUPT            0x5222432c
#define  SATURN_PER_SYS_TIMER_CPU_0_INTERRUPT_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t systimeri            :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SYS_TIMER_CPU_0_INTERRUPT_t;


#define  SATURN_PER_SYS_TIMER_COMPARATOR_CPU_11          0x52224330
#define  SATURN_PER_SYS_TIMER_COMPARATOR_CPU_11_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t comp1                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SYS_TIMER_COMPARATOR_CPU_11_t;


#define  SATURN_PER_SYS_TIMER_COMPARATOR_CPU_10          0x52224334
#define  SATURN_PER_SYS_TIMER_COMPARATOR_CPU_10_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t comp0                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SYS_TIMER_COMPARATOR_CPU_10_t;


#define  SATURN_PER_SYS_TIMER_AUTOINC_CPU_11             0x52224338
#define  SATURN_PER_SYS_TIMER_AUTOINC_CPU_11_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t autoinc1             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SYS_TIMER_AUTOINC_CPU_11_t;


#define  SATURN_PER_SYS_TIMER_AUTOINC_CPU_10             0x5222433c
#define  SATURN_PER_SYS_TIMER_AUTOINC_CPU_10_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t autoinc0             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SYS_TIMER_AUTOINC_CPU_10_t;


#define  SATURN_PER_SYS_TIMER_CPU_1_INTENABLE            0x52224340
#define  SATURN_PER_SYS_TIMER_CPU_1_INTENABLE_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t systimere            :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SYS_TIMER_CPU_1_INTENABLE_t;


#define  SATURN_PER_SYS_TIMER_CPU_1_INTERRUPT            0x52224344
#define  SATURN_PER_SYS_TIMER_CPU_1_INTERRUPT_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t systimeri            :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SYS_TIMER_CPU_1_INTERRUPT_t;


#define  SATURN_PER_SYS_TIMER_COMPARATOR_CPU_21          0x52224348
#define  SATURN_PER_SYS_TIMER_COMPARATOR_CPU_21_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t comp1                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SYS_TIMER_COMPARATOR_CPU_21_t;


#define  SATURN_PER_SYS_TIMER_COMPARATOR_CPU_20          0x5222434c
#define  SATURN_PER_SYS_TIMER_COMPARATOR_CPU_20_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t comp0                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SYS_TIMER_COMPARATOR_CPU_20_t;


#define  SATURN_PER_SYS_TIMER_AUTOINC_CPU_21             0x52224350
#define  SATURN_PER_SYS_TIMER_AUTOINC_CPU_21_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t autoinc1             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SYS_TIMER_AUTOINC_CPU_21_t;


#define  SATURN_PER_SYS_TIMER_AUTOINC_CPU_20             0x52224354
#define  SATURN_PER_SYS_TIMER_AUTOINC_CPU_20_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t autoinc0             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SYS_TIMER_AUTOINC_CPU_20_t;


#define  SATURN_PER_SYS_TIMER_CPU_2_INTENABLE            0x52224358
#define  SATURN_PER_SYS_TIMER_CPU_2_INTENABLE_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t systimere            :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SYS_TIMER_CPU_2_INTENABLE_t;


#define  SATURN_PER_SYS_TIMER_CPU_2_INTERRUPT            0x5222435c
#define  SATURN_PER_SYS_TIMER_CPU_2_INTERRUPT_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t systimeri            :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SYS_TIMER_CPU_2_INTERRUPT_t;


#define  SATURN_PER_SYS_TIMER_COMPARATOR_CPU_31          0x52224360
#define  SATURN_PER_SYS_TIMER_COMPARATOR_CPU_31_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t comp1                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SYS_TIMER_COMPARATOR_CPU_31_t;


#define  SATURN_PER_SYS_TIMER_COMPARATOR_CPU_30          0x52224364
#define  SATURN_PER_SYS_TIMER_COMPARATOR_CPU_30_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t comp0                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SYS_TIMER_COMPARATOR_CPU_30_t;


#define  SATURN_PER_SYS_TIMER_AUTOINC_CPU_31             0x52224368
#define  SATURN_PER_SYS_TIMER_AUTOINC_CPU_31_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t autoinc1             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SYS_TIMER_AUTOINC_CPU_31_t;


#define  SATURN_PER_SYS_TIMER_AUTOINC_CPU_30             0x5222436c
#define  SATURN_PER_SYS_TIMER_AUTOINC_CPU_30_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t autoinc0             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SYS_TIMER_AUTOINC_CPU_30_t;


#define  SATURN_PER_SYS_TIMER_CPU_3_INTENABLE            0x52224370
#define  SATURN_PER_SYS_TIMER_CPU_3_INTENABLE_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t systimere            :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SYS_TIMER_CPU_3_INTENABLE_t;


#define  SATURN_PER_SYS_TIMER_CPU_3_INTERRUPT            0x52224374
#define  SATURN_PER_SYS_TIMER_CPU_3_INTERRUPT_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t systimeri            :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SYS_TIMER_CPU_3_INTERRUPT_t;


#define  SATURN_PER_PWM_TIMER_PERIOD_0                   0x52224378
#define  SATURN_PER_PWM_TIMER_PERIOD_0_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t period               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_PWM_TIMER_PERIOD_0_t;


#define  SATURN_PER_PWM_TIMER_COMP_0                     0x5222437c
#define  SATURN_PER_PWM_TIMER_COMP_0_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t comp                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_PWM_TIMER_COMP_0_t;


#define  SATURN_PER_PWM_TIMER_PERIOD_1                   0x52224380
#define  SATURN_PER_PWM_TIMER_PERIOD_1_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t period               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_PWM_TIMER_PERIOD_1_t;


#define  SATURN_PER_PWM_TIMER_COMP_1                     0x52224384
#define  SATURN_PER_PWM_TIMER_COMP_1_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t comp                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_PWM_TIMER_COMP_1_t;


#define  SATURN_PER_CSPI_CLK                             0x52224388
#define  SATURN_PER_CSPI_CLK_dft                         0x00000002

typedef volatile union {
  struct {
    ca_uint32_t divisor              : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 14 ;
    ca_uint32_t cpha                 :  1 ; /* bits 30:30 */
    ca_uint32_t cpol                 :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_CSPI_CLK_t;

#define      SATURN_cpol_IDLE0                                    0x0
#define      SATURN_cpol_IDLE1                                    0x1
#define      SATURN_cpha_RXFIRST                                  0x0
#define      SATURN_cpha_TXFIRST                                  0x1

#define  SATURN_PER_CSPI_FMT                             0x5222438c
#define  SATURN_PER_CSPI_FMT_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t highbit              :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t frontporch           :  8 ; /* bits 15:8 */
    ca_uint32_t backporch            :  8 ; /* bits 23:16 */
    ca_uint32_t gap                  :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_CSPI_FMT_t;


#define  SATURN_PER_CSPI_CS                              0x52224390
#define  SATURN_PER_CSPI_CS_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t enable               :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t active_hi            :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               : 18 ;
    ca_uint32_t force                :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_CSPI_CS_t;

#define      SATURN_force_NORM                                    0x0
#define      SATURN_force_FORCE                                   0x1
#define      SATURN_active_hi_ACT_LO                              0x0
#define      SATURN_active_hi_ACT_HI                              0x1
#define      SATURN_enable_DISABLED                               0x0
#define      SATURN_enable_ENABLED                                0x1

#define  SATURN_PER_CSPI_WDATA1                          0x52224394
#define  SATURN_PER_CSPI_WDATA1_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wdata1               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_CSPI_WDATA1_t;


#define  SATURN_PER_CSPI_WDATA0                          0x52224398
#define  SATURN_PER_CSPI_WDATA0_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wdata0               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_CSPI_WDATA0_t;


#define  SATURN_PER_CSPI_RDATA1                          0x5222439c
#define  SATURN_PER_CSPI_RDATA1_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rdata1               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_CSPI_RDATA1_t;


#define  SATURN_PER_CSPI_RDATA0                          0x522243a0
#define  SATURN_PER_CSPI_RDATA0_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rdata0               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_CSPI_RDATA0_t;


#define  SATURN_PER_CSPI_CONTROL                         0x522243a4
#define  SATURN_PER_CSPI_CONTROL_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t start                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_CSPI_CONTROL_t;


#define  SATURN_PER_CSPI_IE_0                            0x522243a8
#define  SATURN_PER_CSPI_IE_0_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cspie                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_CSPI_IE_0_t;


#define  SATURN_PER_CSPI_INT_0                           0x522243ac
#define  SATURN_PER_CSPI_INT_0_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cspii                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_CSPI_INT_0_t;


#define  SATURN_PER_CSPI_IE_1                            0x522243b0
#define  SATURN_PER_CSPI_IE_1_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cspie                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_CSPI_IE_1_t;


#define  SATURN_PER_CSPI_INT_1                           0x522243b4
#define  SATURN_PER_CSPI_INT_1_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cspii                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_CSPI_INT_1_t;


#define  SATURN_PER_CSPI_STAT                            0x522243b8
#define  SATURN_PER_CSPI_STAT_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cspis                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_CSPI_STAT_t;


#define  SATURN_PER_SPARE                                0x522243bc
#define  SATURN_PER_SPARE_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t spare                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_PER_SPARE_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PER */
typedef struct {
  SATURN_PER_SOFT_RESET_t                         SOFT_RESET;                    /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_PER_PERIPHERAL_INTERRUPT_0_t             PERIPHERAL_INTERRUPT_0;        /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_PER_PERIPHERAL_INTENABLE_0_t             PERIPHERAL_INTENABLE_0;        /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_PER_PERIPHERAL_INTERRUPT_1_t             PERIPHERAL_INTERRUPT_1;        /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_PER_PERIPHERAL_INTENABLE_1_t             PERIPHERAL_INTENABLE_1;        /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_PER_IRQ_SOFT1_t                          IRQ_SOFT1;                     /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_PER_IRQ_SOFT0_t                          IRQ_SOFT0;                     /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  SATURN_PER_WDT_CTRL_t                           WDT_CTRL;                      /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  SATURN_PER_WDT_PS_t                             WDT_PS;                        /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  SATURN_PER_WDT_DIV_t                            WDT_DIV;                       /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  SATURN_PER_WDT_LD_t                             WDT_LD;                        /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  SATURN_PER_WDT_LOADE_t                          WDT_LOADE;                     /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  SATURN_PER_WDT_CNT_t                            WDT_CNT;                       /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  SATURN_PER_WDT_IE_0_t                           WDT_IE_0;                      /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  SATURN_PER_WDT_INT_0_t                          WDT_INT_0;                     /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  SATURN_PER_WDT_STAT_0_t                         WDT_STAT_0;                    /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  SATURN_PER_WDT_IE_1_t                           WDT_IE_1;                      /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  SATURN_PER_WDT_INT_1_t                          WDT_INT_1;                     /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  SATURN_PER_WDT_STAT_1_t                         WDT_STAT_1;                    /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  SATURN_PER_WDT_TST_t                            WDT_TST;                       /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  SATURN_PER_TMR_LD1_t                            TMR_LD1;                       /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  SATURN_PER_TMR_CTRL1_t                          TMR_CTRL1;                     /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  SATURN_PER_TMR_CNT1_t                           TMR_CNT1;                      /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  SATURN_PER_TMR_IE1_0_t                          TMR_IE1_0;                     /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  SATURN_PER_TMR_IE1_1_t                          TMR_IE1_1;                     /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  SATURN_PER_TMR_INT1_0_t                         TMR_INT1_0;                    /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  SATURN_PER_TMR_INT1_1_t                         TMR_INT1_1;                    /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  SATURN_PER_TMR_STAT1_t                          TMR_STAT1;                     /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  SATURN_PER_TMR_LD2_t                            TMR_LD2;                       /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  SATURN_PER_TMR_CTRL2_t                          TMR_CTRL2;                     /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  SATURN_PER_TMR_CNT2_t                           TMR_CNT2;                      /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  SATURN_PER_TMR_IE2_0_t                          TMR_IE2_0;                     /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  SATURN_PER_TMR_IE2_1_t                          TMR_IE2_1;                     /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  SATURN_PER_TMR_INT2_0_t                         TMR_INT2_0;                    /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  SATURN_PER_TMR_INT2_1_t                         TMR_INT2_1;                    /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  SATURN_PER_TMR_STAT2_t                          TMR_STAT2;                     /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  SATURN_PER_TMR_LOADE_t                          TMR_LOADE;                     /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  SATURN_PER_TMR_TST_t                            TMR_TST;                       /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  SATURN_PER_SPI_CLK_t                            SPI_CLK;                       /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];                   
  SATURN_PER_SPI_CFG_t                            SPI_CFG;                       /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];                   
  SATURN_PER_SPI_MODE_t                           SPI_MODE;                      /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];                   
  SATURN_PER_SPI_CTRL_t                           SPI_CTRL;                      /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];                   
  SATURN_PER_SPI_CA0_t                            SPI_CA0;                       /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];                   
  SATURN_PER_SPI_CA1_t                            SPI_CA1;                       /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd44[3];                   
  SATURN_PER_SPI_CA2_t                            SPI_CA2;                       /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd45[3];                   
  SATURN_PER_SPI_WDAT1_t                          SPI_WDAT1;                     /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd46[3];                   
  SATURN_PER_SPI_WDAT0_t                          SPI_WDAT0;                     /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd47[3];                   
  SATURN_PER_SPI_RDAT1_t                          SPI_RDAT1;                     /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd48[3];                   
  SATURN_PER_SPI_RDAT0_t                          SPI_RDAT0;                     /* addr: 0x000000c0 */
  ca_uint32_t                              rsrvd49[3];                   
  SATURN_PER_SPI_IE_0_t                           SPI_IE_0;                      /* addr: 0x000000c4 */
  ca_uint32_t                              rsrvd50[3];                   
  SATURN_PER_SPI_INT_0_t                          SPI_INT_0;                     /* addr: 0x000000c8 */
  ca_uint32_t                              rsrvd51[3];                   
  SATURN_PER_SPI_IE_1_t                           SPI_IE_1;                      /* addr: 0x000000cc */
  ca_uint32_t                              rsrvd52[3];                   
  SATURN_PER_SPI_INT_1_t                          SPI_INT_1;                     /* addr: 0x000000d0 */
  ca_uint32_t                              rsrvd53[3];                   
  SATURN_PER_SPI_STAT_t                           SPI_STAT;                      /* addr: 0x000000d4 */
  ca_uint32_t                              rsrvd54[3];                   
  SATURN_PER_MDIO_CFG_t                           MDIO_CFG;                      /* addr: 0x000000d8 */
  ca_uint32_t                              rsrvd55[3];                   
  SATURN_PER_MDIO_ADDR_t                          MDIO_ADDR;                     /* addr: 0x000000dc */
  ca_uint32_t                              rsrvd56[3];                   
  SATURN_PER_MDIO_WRDATA_t                        MDIO_WRDATA;                   /* addr: 0x000000e0 */
  ca_uint32_t                              rsrvd57[3];                   
  SATURN_PER_MDIO_RDDATA_t                        MDIO_RDDATA;                   /* addr: 0x000000e4 */
  ca_uint32_t                              rsrvd58[3];                   
  SATURN_PER_MDIO_CTRL_t                          MDIO_CTRL;                     /* addr: 0x000000e8 */
  ca_uint32_t                              rsrvd59[3];                   
  SATURN_PER_MDIO_AUTO_CFG_t                      MDIO_AUTO_CFG;                 /* addr: 0x000000ec */
  ca_uint32_t                              rsrvd60[3];                   
  SATURN_PER_MDIO_AUTO_INTV_t                     MDIO_AUTO_INTV;                /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd61[3];                   
  SATURN_PER_MDIO_AUTO_RM_t                       MDIO_AUTO_RM;                  /* addr: 0x000000f4 */
  ca_uint32_t                              rsrvd62[3];                   
  SATURN_PER_MDIO_AUTO_AADDR_t                    MDIO_AUTO_AADDR;               /* addr: 0x000000f8 */
  ca_uint32_t                              rsrvd63[3];                   
  SATURN_PER_MDIO_ENTAB0_t                        MDIO_ENTAB0;                   /* addr: 0x000000fc */
  ca_uint32_t                              rsrvd64[3];                   
  SATURN_PER_MDIO_ENTAB1_t                        MDIO_ENTAB1;                   /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd65[3];                   
  SATURN_PER_MDIO_ITAB0_t                         MDIO_ITAB0;                    /* addr: 0x00000104 */
  ca_uint32_t                              rsrvd66[3];                   
  SATURN_PER_MDIO_ITAB1_t                         MDIO_ITAB1;                    /* addr: 0x00000108 */
  ca_uint32_t                              rsrvd67[3];                   
  SATURN_PER_MDIO_IE_0_t                          MDIO_IE_0;                     /* addr: 0x0000010c */
  ca_uint32_t                              rsrvd68[3];                   
  SATURN_PER_MDIO_INT_0_t                         MDIO_INT_0;                    /* addr: 0x00000110 */
  ca_uint32_t                              rsrvd69[3];                   
  SATURN_PER_MDIO_IE_1_t                          MDIO_IE_1;                     /* addr: 0x00000114 */
  ca_uint32_t                              rsrvd70[3];                   
  SATURN_PER_MDIO_INT_1_t                         MDIO_INT_1;                    /* addr: 0x00000118 */
  ca_uint32_t                              rsrvd71[3];                   
  SATURN_PER_MDIO_STAT_t                          MDIO_STAT;                     /* addr: 0x0000011c */
  ca_uint32_t                              rsrvd72[3];                   
  SATURN_PER_BIW_CFG_t                            BIW_CFG;                       /* addr: 0x00000120 */
  ca_uint32_t                              rsrvd73[3];                   
  SATURN_PER_BIW_CTRL_t                           BIW_CTRL;                      /* addr: 0x00000124 */
  ca_uint32_t                              rsrvd74[3];                   
  SATURN_PER_BIW_TXR_t                            BIW_TXR;                       /* addr: 0x00000128 */
  ca_uint32_t                              rsrvd75[3];                   
  SATURN_PER_BIW_RXR_t                            BIW_RXR;                       /* addr: 0x0000012c */
  ca_uint32_t                              rsrvd76[3];                   
  SATURN_PER_BIW_ACK_t                            BIW_ACK;                       /* addr: 0x00000130 */
  ca_uint32_t                              rsrvd77[3];                   
  SATURN_PER_BIW_IE_0_t                           BIW_IE_0;                      /* addr: 0x00000134 */
  ca_uint32_t                              rsrvd78[3];                   
  SATURN_PER_BIW_INT_0_t                          BIW_INT_0;                     /* addr: 0x00000138 */
  ca_uint32_t                              rsrvd79[3];                   
  SATURN_PER_BIW_IE_1_t                           BIW_IE_1;                      /* addr: 0x0000013c */
  ca_uint32_t                              rsrvd80[3];                   
  SATURN_PER_BIW_INT_1_t                          BIW_INT_1;                     /* addr: 0x00000140 */
  ca_uint32_t                              rsrvd81[3];                   
  SATURN_PER_BIW_STAT_t                           BIW_STAT;                      /* addr: 0x00000144 */
  ca_uint32_t                              rsrvd82[3];                   
  SATURN_PER_UART0_CFG_t                          UART0_CFG;                     /* addr: 0x00000148 */
  ca_uint32_t                              rsrvd83[3];                   
  SATURN_PER_UART0_FC_t                           UART0_FC;                      /* addr: 0x0000014c */
  ca_uint32_t                              rsrvd84[3];                   
  SATURN_PER_UART0_RX_SAMPLE_t                    UART0_RX_SAMPLE;               /* addr: 0x00000150 */
  ca_uint32_t                              rsrvd85[3];                   
  SATURN_PER_UART0_TUN_t                          UART0_TUN;                     /* addr: 0x00000154 */
  ca_uint32_t                              rsrvd86[3];                   
  SATURN_PER_UART0_TXDAT_t                        UART0_TXDAT;                   /* addr: 0x00000158 */
  ca_uint32_t                              rsrvd87[3];                   
  SATURN_PER_UART0_RXDAT_t                        UART0_RXDAT;                   /* addr: 0x0000015c */
  ca_uint32_t                              rsrvd88[3];                   
  SATURN_PER_UART0_INFO_t                         UART0_INFO;                    /* addr: 0x00000160 */
  ca_uint32_t                              rsrvd89[3];                   
  SATURN_PER_UART0_IE_0_t                         UART0_IE_0;                    /* addr: 0x00000164 */
  ca_uint32_t                              rsrvd90[3];                   
  SATURN_PER_UART0_IE_1_t                         UART0_IE_1;                    /* addr: 0x00000168 */
  ca_uint32_t                              rsrvd91[3];                   
  SATURN_PER_UART0_INT_0_t                        UART0_INT_0;                   /* addr: 0x0000016c */
  ca_uint32_t                              rsrvd92[3];                   
  SATURN_PER_UART0_INT_1_t                        UART0_INT_1;                   /* addr: 0x00000170 */
  ca_uint32_t                              rsrvd93[3];                   
  SATURN_PER_UART0_STAT_t                         UART0_STAT;                    /* addr: 0x00000174 */
  ca_uint32_t                              rsrvd94[3];                   
  SATURN_PER_UART1_CFG_t                          UART1_CFG;                     /* addr: 0x00000178 */
  ca_uint32_t                              rsrvd95[3];                   
  SATURN_PER_UART1_FC_t                           UART1_FC;                      /* addr: 0x0000017c */
  ca_uint32_t                              rsrvd96[3];                   
  SATURN_PER_UART1_RX_SAMPLE_t                    UART1_RX_SAMPLE;               /* addr: 0x00000180 */
  ca_uint32_t                              rsrvd97[3];                   
  SATURN_PER_UART1_TUN_t                          UART1_TUN;                     /* addr: 0x00000184 */
  ca_uint32_t                              rsrvd98[3];                   
  SATURN_PER_UART1_TXDAT_t                        UART1_TXDAT;                   /* addr: 0x00000188 */
  ca_uint32_t                              rsrvd99[3];                   
  SATURN_PER_UART1_RXDAT_t                        UART1_RXDAT;                   /* addr: 0x0000018c */
  ca_uint32_t                              rsrvd100[3];                  
  SATURN_PER_UART1_INFO_t                         UART1_INFO;                    /* addr: 0x00000190 */
  ca_uint32_t                              rsrvd101[3];                  
  SATURN_PER_UART1_IE_0_t                         UART1_IE_0;                    /* addr: 0x00000194 */
  ca_uint32_t                              rsrvd102[3];                  
  SATURN_PER_UART1_IE_1_t                         UART1_IE_1;                    /* addr: 0x00000198 */
  ca_uint32_t                              rsrvd103[3];                  
  SATURN_PER_UART1_INT_0_t                        UART1_INT_0;                   /* addr: 0x0000019c */
  ca_uint32_t                              rsrvd104[3];                  
  SATURN_PER_UART1_INT_1_t                        UART1_INT_1;                   /* addr: 0x000001a0 */
  ca_uint32_t                              rsrvd105[3];                  
  SATURN_PER_UART1_STAT_t                         UART1_STAT;                    /* addr: 0x000001a4 */
  ca_uint32_t                              rsrvd106[3];                  
  SATURN_PER_UART2_CFG_t                          UART2_CFG;                     /* addr: 0x000001a8 */
  ca_uint32_t                              rsrvd107[3];                  
  SATURN_PER_UART2_FC_t                           UART2_FC;                      /* addr: 0x000001ac */
  ca_uint32_t                              rsrvd108[3];                  
  SATURN_PER_UART2_RX_SAMPLE_t                    UART2_RX_SAMPLE;               /* addr: 0x000001b0 */
  ca_uint32_t                              rsrvd109[3];                  
  SATURN_PER_UART2_TUN_t                          UART2_TUN;                     /* addr: 0x000001b4 */
  ca_uint32_t                              rsrvd110[3];                  
  SATURN_PER_UART2_TXDAT_t                        UART2_TXDAT;                   /* addr: 0x000001b8 */
  ca_uint32_t                              rsrvd111[3];                  
  SATURN_PER_UART2_RXDAT_t                        UART2_RXDAT;                   /* addr: 0x000001bc */
  ca_uint32_t                              rsrvd112[3];                  
  SATURN_PER_UART2_INFO_t                         UART2_INFO;                    /* addr: 0x000001c0 */
  ca_uint32_t                              rsrvd113[3];                  
  SATURN_PER_UART2_IE_0_t                         UART2_IE_0;                    /* addr: 0x000001c4 */
  ca_uint32_t                              rsrvd114[3];                  
  SATURN_PER_UART2_IE_1_t                         UART2_IE_1;                    /* addr: 0x000001c8 */
  ca_uint32_t                              rsrvd115[3];                  
  SATURN_PER_UART2_INT_0_t                        UART2_INT_0;                   /* addr: 0x000001cc */
  ca_uint32_t                              rsrvd116[3];                  
  SATURN_PER_UART2_INT_1_t                        UART2_INT_1;                   /* addr: 0x000001d0 */
  ca_uint32_t                              rsrvd117[3];                  
  SATURN_PER_UART2_STAT_t                         UART2_STAT;                    /* addr: 0x000001d4 */
  ca_uint32_t                              rsrvd118[3];                  
  SATURN_PER_UART3_CFG_t                          UART3_CFG;                     /* addr: 0x000001d8 */
  ca_uint32_t                              rsrvd119[3];                  
  SATURN_PER_UART3_FC_t                           UART3_FC;                      /* addr: 0x000001dc */
  ca_uint32_t                              rsrvd120[3];                  
  SATURN_PER_UART3_RX_SAMPLE_t                    UART3_RX_SAMPLE;               /* addr: 0x000001e0 */
  ca_uint32_t                              rsrvd121[3];                  
  SATURN_PER_UART3_TUN_t                          UART3_TUN;                     /* addr: 0x000001e4 */
  ca_uint32_t                              rsrvd122[3];                  
  SATURN_PER_UART3_TXDAT_t                        UART3_TXDAT;                   /* addr: 0x000001e8 */
  ca_uint32_t                              rsrvd123[3];                  
  SATURN_PER_UART3_RXDAT_t                        UART3_RXDAT;                   /* addr: 0x000001ec */
  ca_uint32_t                              rsrvd124[3];                  
  SATURN_PER_UART3_INFO_t                         UART3_INFO;                    /* addr: 0x000001f0 */
  ca_uint32_t                              rsrvd125[3];                  
  SATURN_PER_UART3_IE_0_t                         UART3_IE_0;                    /* addr: 0x000001f4 */
  ca_uint32_t                              rsrvd126[3];                  
  SATURN_PER_UART3_IE_1_t                         UART3_IE_1;                    /* addr: 0x000001f8 */
  ca_uint32_t                              rsrvd127[3];                  
  SATURN_PER_UART3_INT_0_t                        UART3_INT_0;                   /* addr: 0x000001fc */
  ca_uint32_t                              rsrvd128[3];                  
  SATURN_PER_UART3_INT_1_t                        UART3_INT_1;                   /* addr: 0x00000200 */
  ca_uint32_t                              rsrvd129[3];                  
  SATURN_PER_UART3_STAT_t                         UART3_STAT;                    /* addr: 0x00000204 */
  ca_uint32_t                              rsrvd130[3];                  
  SATURN_PER_TOD_CFG_t                            TOD_CFG;                       /* addr: 0x00000208 */
  ca_uint32_t                              rsrvd131[55];                 
  SATURN_PER_TOD_MEM_t                            TOD_MEM[16];                   /* addr: 0x00000240 */
  ca_uint32_t                              rsrvd132[48];                 
  SATURN_PER_GPIO0_CFG_t                          GPIO0_CFG;                     /* addr: 0x00000280 */
  ca_uint32_t                              rsrvd133[3];                  
  SATURN_PER_GPIO0_OUT_t                          GPIO0_OUT;                     /* addr: 0x00000284 */
  ca_uint32_t                              rsrvd134[3];                  
  SATURN_PER_GPIO0_IN_t                           GPIO0_IN;                      /* addr: 0x00000288 */
  ca_uint32_t                              rsrvd135[3];                  
  SATURN_PER_GPIO0_LVL_t                          GPIO0_LVL;                     /* addr: 0x0000028c */
  ca_uint32_t                              rsrvd136[3];                  
  SATURN_PER_GPIO0_EDGE_t                         GPIO0_EDGE;                    /* addr: 0x00000290 */
  ca_uint32_t                              rsrvd137[3];                  
  SATURN_PER_GPIO0_BOTHEDGE_t                     GPIO0_BOTHEDGE;                /* addr: 0x00000294 */
  ca_uint32_t                              rsrvd138[3];                  
  SATURN_PER_GPIO0_IE_t                           GPIO0_IE;                      /* addr: 0x00000298 */
  ca_uint32_t                              rsrvd139[3];                  
  SATURN_PER_GPIO0_INT_t                          GPIO0_INT;                     /* addr: 0x0000029c */
  ca_uint32_t                              rsrvd140[3];                  
  SATURN_PER_GPIO0_STAT_t                         GPIO0_STAT;                    /* addr: 0x000002a0 */
  ca_uint32_t                              rsrvd141[3];                  
  SATURN_PER_GPIO1_CFG_t                          GPIO1_CFG;                     /* addr: 0x000002a4 */
  ca_uint32_t                              rsrvd142[3];                  
  SATURN_PER_GPIO1_OUT_t                          GPIO1_OUT;                     /* addr: 0x000002a8 */
  ca_uint32_t                              rsrvd143[3];                  
  SATURN_PER_GPIO1_IN_t                           GPIO1_IN;                      /* addr: 0x000002ac */
  ca_uint32_t                              rsrvd144[3];                  
  SATURN_PER_GPIO1_LVL_t                          GPIO1_LVL;                     /* addr: 0x000002b0 */
  ca_uint32_t                              rsrvd145[3];                  
  SATURN_PER_GPIO1_EDGE_t                         GPIO1_EDGE;                    /* addr: 0x000002b4 */
  ca_uint32_t                              rsrvd146[3];                  
  SATURN_PER_GPIO1_BOTHEDGE_t                     GPIO1_BOTHEDGE;                /* addr: 0x000002b8 */
  ca_uint32_t                              rsrvd147[3];                  
  SATURN_PER_GPIO1_IE_t                           GPIO1_IE;                      /* addr: 0x000002bc */
  ca_uint32_t                              rsrvd148[3];                  
  SATURN_PER_GPIO1_INT_t                          GPIO1_INT;                     /* addr: 0x000002c0 */
  ca_uint32_t                              rsrvd149[3];                  
  SATURN_PER_GPIO1_STAT_t                         GPIO1_STAT;                    /* addr: 0x000002c4 */
  ca_uint32_t                              rsrvd150[3];                  
  SATURN_PER_GPIO2_CFG_t                          GPIO2_CFG;                     /* addr: 0x000002c8 */
  ca_uint32_t                              rsrvd151[3];                  
  SATURN_PER_GPIO2_OUT_t                          GPIO2_OUT;                     /* addr: 0x000002cc */
  ca_uint32_t                              rsrvd152[3];                  
  SATURN_PER_GPIO2_IN_t                           GPIO2_IN;                      /* addr: 0x000002d0 */
  ca_uint32_t                              rsrvd153[3];                  
  SATURN_PER_GPIO2_LVL_t                          GPIO2_LVL;                     /* addr: 0x000002d4 */
  ca_uint32_t                              rsrvd154[3];                  
  SATURN_PER_GPIO2_EDGE_t                         GPIO2_EDGE;                    /* addr: 0x000002d8 */
  ca_uint32_t                              rsrvd155[3];                  
  SATURN_PER_GPIO2_BOTHEDGE_t                     GPIO2_BOTHEDGE;                /* addr: 0x000002dc */
  ca_uint32_t                              rsrvd156[3];                  
  SATURN_PER_GPIO2_IE_t                           GPIO2_IE;                      /* addr: 0x000002e0 */
  ca_uint32_t                              rsrvd157[3];                  
  SATURN_PER_GPIO2_INT_t                          GPIO2_INT;                     /* addr: 0x000002e4 */
  ca_uint32_t                              rsrvd158[3];                  
  SATURN_PER_GPIO2_STAT_t                         GPIO2_STAT;                    /* addr: 0x000002e8 */
  ca_uint32_t                              rsrvd159[3];                  
  SATURN_PER_GPIO3_CFG_t                          GPIO3_CFG;                     /* addr: 0x000002ec */
  ca_uint32_t                              rsrvd160[3];                  
  SATURN_PER_GPIO3_OUT_t                          GPIO3_OUT;                     /* addr: 0x000002f0 */
  ca_uint32_t                              rsrvd161[3];                  
  SATURN_PER_GPIO3_IN_t                           GPIO3_IN;                      /* addr: 0x000002f4 */
  ca_uint32_t                              rsrvd162[3];                  
  SATURN_PER_GPIO3_LVL_t                          GPIO3_LVL;                     /* addr: 0x000002f8 */
  ca_uint32_t                              rsrvd163[3];                  
  SATURN_PER_GPIO3_EDGE_t                         GPIO3_EDGE;                    /* addr: 0x000002fc */
  ca_uint32_t                              rsrvd164[3];                  
  SATURN_PER_GPIO3_BOTHEDGE_t                     GPIO3_BOTHEDGE;                /* addr: 0x00000300 */
  ca_uint32_t                              rsrvd165[3];                  
  SATURN_PER_GPIO3_IE_t                           GPIO3_IE;                      /* addr: 0x00000304 */
  ca_uint32_t                              rsrvd166[3];                  
  SATURN_PER_GPIO3_INT_t                          GPIO3_INT;                     /* addr: 0x00000308 */
  ca_uint32_t                              rsrvd167[3];                  
  SATURN_PER_GPIO3_STAT_t                         GPIO3_STAT;                    /* addr: 0x0000030c */
  ca_uint32_t                              rsrvd168[3];                  
  SATURN_PER_SYS_TIMER1_t                         SYS_TIMER1;                    /* addr: 0x00000310 */
  ca_uint32_t                              rsrvd169[3];                  
  SATURN_PER_SYS_TIMER0_t                         SYS_TIMER0;                    /* addr: 0x00000314 */
  ca_uint32_t                              rsrvd170[3];                  
  SATURN_PER_SYS_TIMER_COMPARATOR_CPU_01_t        SYS_TIMER_COMPARATOR_CPU_01;   /* addr: 0x00000318 */
  ca_uint32_t                              rsrvd171[3];                  
  SATURN_PER_SYS_TIMER_COMPARATOR_CPU_00_t        SYS_TIMER_COMPARATOR_CPU_00;   /* addr: 0x0000031c */
  ca_uint32_t                              rsrvd172[3];                  
  SATURN_PER_SYS_TIMER_AUTOINC_CPU_01_t           SYS_TIMER_AUTOINC_CPU_01;      /* addr: 0x00000320 */
  ca_uint32_t                              rsrvd173[3];                  
  SATURN_PER_SYS_TIMER_AUTOINC_CPU_00_t           SYS_TIMER_AUTOINC_CPU_00;      /* addr: 0x00000324 */
  ca_uint32_t                              rsrvd174[3];                  
  SATURN_PER_SYS_TIMER_CPU_0_INTENABLE_t          SYS_TIMER_CPU_0_INTENABLE;     /* addr: 0x00000328 */
  ca_uint32_t                              rsrvd175[3];                  
  SATURN_PER_SYS_TIMER_CPU_0_INTERRUPT_t          SYS_TIMER_CPU_0_INTERRUPT;     /* addr: 0x0000032c */
  ca_uint32_t                              rsrvd176[3];                  
  SATURN_PER_SYS_TIMER_COMPARATOR_CPU_11_t        SYS_TIMER_COMPARATOR_CPU_11;   /* addr: 0x00000330 */
  ca_uint32_t                              rsrvd177[3];                  
  SATURN_PER_SYS_TIMER_COMPARATOR_CPU_10_t        SYS_TIMER_COMPARATOR_CPU_10;   /* addr: 0x00000334 */
  ca_uint32_t                              rsrvd178[3];                  
  SATURN_PER_SYS_TIMER_AUTOINC_CPU_11_t           SYS_TIMER_AUTOINC_CPU_11;      /* addr: 0x00000338 */
  ca_uint32_t                              rsrvd179[3];                  
  SATURN_PER_SYS_TIMER_AUTOINC_CPU_10_t           SYS_TIMER_AUTOINC_CPU_10;      /* addr: 0x0000033c */
  ca_uint32_t                              rsrvd180[3];                  
  SATURN_PER_SYS_TIMER_CPU_1_INTENABLE_t          SYS_TIMER_CPU_1_INTENABLE;     /* addr: 0x00000340 */
  ca_uint32_t                              rsrvd181[3];                  
  SATURN_PER_SYS_TIMER_CPU_1_INTERRUPT_t          SYS_TIMER_CPU_1_INTERRUPT;     /* addr: 0x00000344 */
  ca_uint32_t                              rsrvd182[3];                  
  SATURN_PER_SYS_TIMER_COMPARATOR_CPU_21_t        SYS_TIMER_COMPARATOR_CPU_21;   /* addr: 0x00000348 */
  ca_uint32_t                              rsrvd183[3];                  
  SATURN_PER_SYS_TIMER_COMPARATOR_CPU_20_t        SYS_TIMER_COMPARATOR_CPU_20;   /* addr: 0x0000034c */
  ca_uint32_t                              rsrvd184[3];                  
  SATURN_PER_SYS_TIMER_AUTOINC_CPU_21_t           SYS_TIMER_AUTOINC_CPU_21;      /* addr: 0x00000350 */
  ca_uint32_t                              rsrvd185[3];                  
  SATURN_PER_SYS_TIMER_AUTOINC_CPU_20_t           SYS_TIMER_AUTOINC_CPU_20;      /* addr: 0x00000354 */
  ca_uint32_t                              rsrvd186[3];                  
  SATURN_PER_SYS_TIMER_CPU_2_INTENABLE_t          SYS_TIMER_CPU_2_INTENABLE;     /* addr: 0x00000358 */
  ca_uint32_t                              rsrvd187[3];                  
  SATURN_PER_SYS_TIMER_CPU_2_INTERRUPT_t          SYS_TIMER_CPU_2_INTERRUPT;     /* addr: 0x0000035c */
  ca_uint32_t                              rsrvd188[3];                  
  SATURN_PER_SYS_TIMER_COMPARATOR_CPU_31_t        SYS_TIMER_COMPARATOR_CPU_31;   /* addr: 0x00000360 */
  ca_uint32_t                              rsrvd189[3];                  
  SATURN_PER_SYS_TIMER_COMPARATOR_CPU_30_t        SYS_TIMER_COMPARATOR_CPU_30;   /* addr: 0x00000364 */
  ca_uint32_t                              rsrvd190[3];                  
  SATURN_PER_SYS_TIMER_AUTOINC_CPU_31_t           SYS_TIMER_AUTOINC_CPU_31;      /* addr: 0x00000368 */
  ca_uint32_t                              rsrvd191[3];                  
  SATURN_PER_SYS_TIMER_AUTOINC_CPU_30_t           SYS_TIMER_AUTOINC_CPU_30;      /* addr: 0x0000036c */
  ca_uint32_t                              rsrvd192[3];                  
  SATURN_PER_SYS_TIMER_CPU_3_INTENABLE_t          SYS_TIMER_CPU_3_INTENABLE;     /* addr: 0x00000370 */
  ca_uint32_t                              rsrvd193[3];                  
  SATURN_PER_SYS_TIMER_CPU_3_INTERRUPT_t          SYS_TIMER_CPU_3_INTERRUPT;     /* addr: 0x00000374 */
  ca_uint32_t                              rsrvd194[3];                  
  SATURN_PER_PWM_TIMER_PERIOD_0_t                 PWM_TIMER_PERIOD_0;            /* addr: 0x00000378 */
  ca_uint32_t                              rsrvd195[3];                  
  SATURN_PER_PWM_TIMER_COMP_0_t                   PWM_TIMER_COMP_0;              /* addr: 0x0000037c */
  ca_uint32_t                              rsrvd196[3];                  
  SATURN_PER_PWM_TIMER_PERIOD_1_t                 PWM_TIMER_PERIOD_1;            /* addr: 0x00000380 */
  ca_uint32_t                              rsrvd197[3];                  
  SATURN_PER_PWM_TIMER_COMP_1_t                   PWM_TIMER_COMP_1;              /* addr: 0x00000384 */
  ca_uint32_t                              rsrvd198[3];                  
  SATURN_PER_CSPI_CLK_t                           CSPI_CLK;                      /* addr: 0x00000388 */
  ca_uint32_t                              rsrvd199[3];                  
  SATURN_PER_CSPI_FMT_t                           CSPI_FMT;                      /* addr: 0x0000038c */
  ca_uint32_t                              rsrvd200[3];                  
  SATURN_PER_CSPI_CS_t                            CSPI_CS;                       /* addr: 0x00000390 */
  ca_uint32_t                              rsrvd201[3];                  
  SATURN_PER_CSPI_WDATA1_t                        CSPI_WDATA1;                   /* addr: 0x00000394 */
  ca_uint32_t                              rsrvd202[3];                  
  SATURN_PER_CSPI_WDATA0_t                        CSPI_WDATA0;                   /* addr: 0x00000398 */
  ca_uint32_t                              rsrvd203[3];                  
  SATURN_PER_CSPI_RDATA1_t                        CSPI_RDATA1;                   /* addr: 0x0000039c */
  ca_uint32_t                              rsrvd204[3];                  
  SATURN_PER_CSPI_RDATA0_t                        CSPI_RDATA0;                   /* addr: 0x000003a0 */
  ca_uint32_t                              rsrvd205[3];                  
  SATURN_PER_CSPI_CONTROL_t                       CSPI_CONTROL;                  /* addr: 0x000003a4 */
  ca_uint32_t                              rsrvd206[3];                  
  SATURN_PER_CSPI_IE_0_t                          CSPI_IE_0;                     /* addr: 0x000003a8 */
  ca_uint32_t                              rsrvd207[3];                  
  SATURN_PER_CSPI_INT_0_t                         CSPI_INT_0;                    /* addr: 0x000003ac */
  ca_uint32_t                              rsrvd208[3];                  
  SATURN_PER_CSPI_IE_1_t                          CSPI_IE_1;                     /* addr: 0x000003b0 */
  ca_uint32_t                              rsrvd209[3];                  
  SATURN_PER_CSPI_INT_1_t                         CSPI_INT_1;                    /* addr: 0x000003b4 */
  ca_uint32_t                              rsrvd210[3];                  
  SATURN_PER_CSPI_STAT_t                          CSPI_STAT;                     /* addr: 0x000003b8 */
  ca_uint32_t                              rsrvd211[3];                  
  SATURN_PER_SPARE_t                              SPARE;                         /* addr: 0x000003bc */
} SATURN_APB3_PER_t;


/*
 * IIC_SLV
 */
        
#define  SATURN_IIC_SLV_IIC_SLV_CONFIG                   0x52225000
#define  SATURN_IIC_SLV_IIC_SLV_CONFIG_dft               0x001000c0

typedef volatile union {
  struct {
    ca_uint32_t cfg_iicslv_byte_mode :  2 ; /* bits 1:0 */
    ca_uint32_t cfg_en_i2c_burst_rd  :  1 ; /* bits 2:2 */
    ca_uint32_t cfg_iic_op_drain     :  2 ; /* bits 4:3 */
    ca_uint32_t cfg_iic_endian_mode  :  1 ; /* bits 5:5 */
    ca_uint32_t cfg_standard_iic     :  1 ; /* bits 6:6 */
    ca_uint32_t cfg_acs_en           :  1 ; /* bits 7:7 */
    ca_uint32_t cfg_sda_dly          :  6 ; /* bits 13:8 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t cfg_dev_id           :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd2               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_IIC_SLV_IIC_SLV_CONFIG_t;


#define  SATURN_IIC_SLV_IIC_INT                          0x52225004
#define  SATURN_IIC_SLV_IIC_INT_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t iic_wr_int           :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_IIC_SLV_IIC_INT_t;


#define  SATURN_IIC_SLV_REG_MEM_ACCESS                   0x52225008
#define  SATURN_IIC_SLV_REG_MEM_ACCESS_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ADDR                 :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 21 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_IIC_SLV_REG_MEM_ACCESS_t;


#define  SATURN_IIC_SLV_REG_MEM_DATA                     0x5222500c
#define  SATURN_IIC_SLV_REG_MEM_DATA_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_IIC_SLV_REG_MEM_DATA_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* IIC_SLV */
typedef struct {
  SATURN_IIC_SLV_IIC_SLV_CONFIG_t                 IIC_SLV_CONFIG;                /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_IIC_SLV_IIC_INT_t                        IIC_INT;                       /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_IIC_SLV_REG_MEM_ACCESS_t                 REG_MEM_ACCESS;                /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_IIC_SLV_REG_MEM_DATA_t                   REG_MEM_DATA;                  /* addr: 0x0000000c */
} SATURN_APB3_IIC_SLV_t;

    
  
        
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* APB3 */

typedef struct {
  ca_uint32_t                              rsrvd1[12288];                
  SATURN_APB3_FLASH_t                             FLASH;                         /* addr: 0x00003000 */
  ca_uint32_t                              rsrvd2[4063];                 
  SATURN_APB3_PER_t                               PER;                           /* addr: 0x00004000 */
  ca_uint32_t                              rsrvd3[3617];                 
  SATURN_APB3_IIC_SLV_t                           IIC_SLV;                       /* addr: 0x00005000 */
} SATURN_APB3_t;


/*
 * APB0
 */
  
/*
 * L2FE
 */
  
/*
 * GLB
 */
        
#define  SATURN_L2FE_GLB_VER_CTRL                        0xd0001000
#define  SATURN_L2FE_GLB_VER_CTRL_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rev_id               : 16 ; /* bits 15:0 */
    ca_uint32_t ver_id               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_GLB_VER_CTRL_t;


#define  SATURN_L2FE_GLB_CTRL                            0xd0001004
#define  SATURN_L2FE_GLB_CTRL_dft                        0x00000014

typedef volatile union {
  struct {
    ca_uint32_t soft_reset           :  1 ; /* bits 0:0 */
    ca_uint32_t pipeline_clk_num     :  5 ; /* bits 5:1 */
    ca_uint32_t change_ip_if_pop_en  :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_GLB_CTRL_t;


#define  SATURN_L2FE_GLB_INTERRUPT                       0xd0001008
#define  SATURN_L2FE_GLB_INTERRUPT_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t lf_overflow_intI     :  1 ; /* bits 1:1 */
    ca_uint32_t ple_hd_ff_overflow_intI :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd2               :  5 ;
    ca_uint32_t port_mac_lmt_excd_intI :  1 ; /* bits 8:8 */
    ca_uint32_t l2e_hash_collision_intI :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd3               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_GLB_INTERRUPT_t;


#define  SATURN_L2FE_GLB_INTERRUPTE                      0xd000100c
#define  SATURN_L2FE_GLB_INTERRUPTE_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t lf_overflow_intIE    :  1 ; /* bits 1:1 */
    ca_uint32_t ple_hd_ff_overflow_intIE :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd2               :  5 ;
    ca_uint32_t port_mac_lmt_excd_intIE :  1 ; /* bits 8:8 */
    ca_uint32_t l2e_hash_collision_intIE :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd3               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_GLB_INTERRUPTE_t;


#define  SATURN_L2FE_GLB_STTS                            0xd0001010
#define  SATURN_L2FE_GLB_STTS_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t l2fe_init_done       :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_GLB_STTS_t;


#define  SATURN_L2FE_GLB_L2FE_CFG_SPARE                  0xd0001014
#define  SATURN_L2FE_GLB_L2FE_CFG_SPARE_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bit                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_GLB_L2FE_CFG_SPARE_t;


#define  SATURN_L2FE_GLB_L2FE_STTS_SPARE                 0xd0001018
#define  SATURN_L2FE_GLB_L2FE_STTS_SPARE_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bit                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_GLB_L2FE_STTS_SPARE_t;


#define  SATURN_L2FE_GLB_DEBUG                           0xd000101c
#define  SATURN_L2FE_GLB_DEBUG_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bus_sel              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_GLB_DEBUG_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* GLB */
typedef struct {
  SATURN_L2FE_GLB_VER_CTRL_t                      VER_CTRL;                      /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_L2FE_GLB_CTRL_t                          CTRL;                          /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_L2FE_GLB_INTERRUPT_t                     INTERRUPT;                     /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_L2FE_GLB_INTERRUPTE_t                    INTERRUPTE;                    /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_L2FE_GLB_STTS_t                          STTS;                          /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_L2FE_GLB_L2FE_CFG_SPARE_t                L2FE_CFG_SPARE;                /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_L2FE_GLB_L2FE_STTS_SPARE_t               L2FE_STTS_SPARE;               /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  SATURN_L2FE_GLB_DEBUG_t                         _DEBUG;                        /* addr: 0x0000001c */
} SATURN_APB0_L2FE_GLB_t;


/*
 * PP
 */
        
#define  SATURN_L2FE_PP_PPID_ATTR_CFG                    0xd0001100
#define  SATURN_L2FE_PP_PPID_ATTR_CFG_dft                0x009d0000

typedef volatile union {
  struct {
    ca_uint32_t ppid0                :  2 ; /* bits 1:0 */
    ca_uint32_t ppid1                :  2 ; /* bits 3:2 */
    ca_uint32_t ppid2                :  2 ; /* bits 5:4 */
    ca_uint32_t ppid3                :  2 ; /* bits 7:6 */
    ca_uint32_t ppid4                :  2 ; /* bits 9:8 */
    ca_uint32_t ppid5                :  2 ; /* bits 11:10 */
    ca_uint32_t ppid6                :  2 ; /* bits 13:12 */
    ca_uint32_t ppid7                :  2 ; /* bits 15:14 */
    ca_uint32_t ppid8                :  2 ; /* bits 17:16 */
    ca_uint32_t ppid9                :  2 ; /* bits 19:18 */
    ca_uint32_t ppid10               :  2 ; /* bits 21:20 */
    ca_uint32_t ppid11               :  2 ; /* bits 23:22 */
    ca_uint32_t ppid12               :  2 ; /* bits 25:24 */
    ca_uint32_t ppid13               :  2 ; /* bits 27:26 */
    ca_uint32_t ppid14               :  2 ; /* bits 29:28 */
    ca_uint32_t ppid15               :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_PPID_ATTR_CFG_t;


#define  SATURN_L2FE_PP_DPB_CTRL                         0xd0001104
#define  SATURN_L2FE_PP_DPB_CTRL_dft                     0x00000003

typedef volatile union {
  struct {
    ca_uint32_t ldpid_pattern        :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_DPB_CTRL_t;


#define  SATURN_L2FE_PP_TPID_CMP_S                       0xd0001108
#define  SATURN_L2FE_PP_TPID_CMP_S_dft                   0x00008100

typedef volatile union {
  struct {
    ca_uint32_t tpid                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_TPID_CMP_S_t;


#define  SATURN_L2FE_PP_TPID_CMP_C                       0xd000110c
#define  SATURN_L2FE_PP_TPID_CMP_C_dft                   0x00008100

typedef volatile union {
  struct {
    ca_uint32_t tpid                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_TPID_CMP_C_t;


#define  SATURN_L2FE_PP_TPID_CMP_O                       0xd0001110
#define  SATURN_L2FE_PP_TPID_CMP_O_dft                   0x00008100

typedef volatile union {
  struct {
    ca_uint32_t tpid                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_TPID_CMP_O_t;


#define  SATURN_L2FE_PP_HELLO_PKT_ENABLE_DA_LOW          0xd0001114
#define  SATURN_L2FE_PP_HELLO_PKT_ENABLE_DA_LOW_dft      0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t enable               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_HELLO_PKT_ENABLE_DA_LOW_t;


#define  SATURN_L2FE_PP_HELLO_PKT_ENABLE_DA_HI           0xd0001118
#define  SATURN_L2FE_PP_HELLO_PKT_ENABLE_DA_HI_dft       0x0000ffff

typedef volatile union {
  struct {
    ca_uint32_t enable               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_HELLO_PKT_ENABLE_DA_HI_t;


#define  SATURN_L2FE_PP_HELLO_PKT_DA_LOW                 0xd000111c
#define  SATURN_L2FE_PP_HELLO_PKT_DA_LOW_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_HELLO_PKT_DA_LOW_t;


#define  SATURN_L2FE_PP_HELLO_PKT_DA_HI                  0xd0001120
#define  SATURN_L2FE_PP_HELLO_PKT_DA_HI_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_HELLO_PKT_DA_HI_t;


#define  SATURN_L2FE_PP_SPECIAL_ENABLE_DA_0_LOW          0xd0001124
#define  SATURN_L2FE_PP_SPECIAL_ENABLE_DA_0_LOW_dft      0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t enable               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_SPECIAL_ENABLE_DA_0_LOW_t;


#define  SATURN_L2FE_PP_SPECIAL_ENABLE_DA_0_HI           0xd0001128
#define  SATURN_L2FE_PP_SPECIAL_ENABLE_DA_0_HI_dft       0x0000ffff

typedef volatile union {
  struct {
    ca_uint32_t enable               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_SPECIAL_ENABLE_DA_0_HI_t;


#define  SATURN_L2FE_PP_SPECIAL_DA_0_LOW                 0xd000112c
#define  SATURN_L2FE_PP_SPECIAL_DA_0_LOW_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_SPECIAL_DA_0_LOW_t;


#define  SATURN_L2FE_PP_SPECIAL_DA_0_HI                  0xd0001130
#define  SATURN_L2FE_PP_SPECIAL_DA_0_HI_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_SPECIAL_DA_0_HI_t;


#define  SATURN_L2FE_PP_SPECIAL_EV2PT                    0xd0001134
#define  SATURN_L2FE_PP_SPECIAL_EV2PT_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ev2pt                : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_SPECIAL_EV2PT_t;


#define  SATURN_L2FE_PP_SPECIAL_ENABLE_DA_1_LOW          0xd0001138
#define  SATURN_L2FE_PP_SPECIAL_ENABLE_DA_1_LOW_dft      0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t enable               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_SPECIAL_ENABLE_DA_1_LOW_t;


#define  SATURN_L2FE_PP_SPECIAL_ENABLE_DA_1_HI           0xd000113c
#define  SATURN_L2FE_PP_SPECIAL_ENABLE_DA_1_HI_dft       0x0000ffff

typedef volatile union {
  struct {
    ca_uint32_t enable               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_SPECIAL_ENABLE_DA_1_HI_t;


#define  SATURN_L2FE_PP_SPECIAL_DA_1_LOW                 0xd0001140
#define  SATURN_L2FE_PP_SPECIAL_DA_1_LOW_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_SPECIAL_DA_1_LOW_t;


#define  SATURN_L2FE_PP_SPECIAL_DA_1_HI                  0xd0001144
#define  SATURN_L2FE_PP_SPECIAL_DA_1_HI_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_SPECIAL_DA_1_HI_t;


#define  SATURN_L2FE_PP_SPECIAL_VLAN                     0xd0001148
#define  SATURN_L2FE_PP_SPECIAL_VLAN_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vlan                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_SPECIAL_VLAN_t;


#define  SATURN_L2FE_PP_MY_MAC_LOW                       0xd000114c
#define  SATURN_L2FE_PP_MY_MAC_LOW_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_MY_MAC_LOW_t;


#define  SATURN_L2FE_PP_MY_MAC_HI                        0xd0001150
#define  SATURN_L2FE_PP_MY_MAC_HI_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_MY_MAC_HI_t;


#define  SATURN_L2FE_PP_MY_MAC_ENABLE_LOW                0xd0001154
#define  SATURN_L2FE_PP_MY_MAC_ENABLE_LOW_dft            0x00ffffff

typedef volatile union {
  struct {
    ca_uint32_t enable               : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_MY_MAC_ENABLE_LOW_t;


#define  SATURN_L2FE_PP_MY_MAC_LOW_1                     0xd0001158
#define  SATURN_L2FE_PP_MY_MAC_LOW_1_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_MY_MAC_LOW_1_t;


#define  SATURN_L2FE_PP_MY_MAC_HI_1                      0xd000115c
#define  SATURN_L2FE_PP_MY_MAC_HI_1_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_MY_MAC_HI_1_t;


#define  SATURN_L2FE_PP_MY_MAC_ENABLE_LOW_1              0xd0001160
#define  SATURN_L2FE_PP_MY_MAC_ENABLE_LOW_1_dft          0x00ffffff

typedef volatile union {
  struct {
    ca_uint32_t enable               : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_MY_MAC_ENABLE_LOW_1_t;


#define  SATURN_L2FE_PP_RSV_MAC_MC_LOW                   0xd0001164
#define  SATURN_L2FE_PP_RSV_MAC_MC_LOW_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_RSV_MAC_MC_LOW_t;


#define  SATURN_L2FE_PP_RSV_MAC_MC_HI                    0xd0001168
#define  SATURN_L2FE_PP_RSV_MAC_MC_HI_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_RSV_MAC_MC_HI_t;


#define  SATURN_L2FE_PP_RSV_ENABLE_MC_LOW                0xd000116c
#define  SATURN_L2FE_PP_RSV_ENABLE_MC_LOW_dft            0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t enable               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_RSV_ENABLE_MC_LOW_t;


#define  SATURN_L2FE_PP_RSV_ENABLE_MC_HI                 0xd0001170
#define  SATURN_L2FE_PP_RSV_ENABLE_MC_HI_dft             0x0000ffff

typedef volatile union {
  struct {
    ca_uint32_t enable               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_RSV_ENABLE_MC_HI_t;


#define  SATURN_L2FE_PP_RSV_GROUP_MAC_LOW                0xd0001174
#define  SATURN_L2FE_PP_RSV_GROUP_MAC_LOW_dft            0xc2000000

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_RSV_GROUP_MAC_LOW_t;


#define  SATURN_L2FE_PP_RSV_GROUP_MAC_HI                 0xd0001178
#define  SATURN_L2FE_PP_RSV_GROUP_MAC_HI_dft             0x00000180

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_RSV_GROUP_MAC_HI_t;


#define  SATURN_L2FE_PP_RSV_GROUP_ENABLE_LOW             0xd000117c
#define  SATURN_L2FE_PP_RSV_GROUP_ENABLE_LOW_dft         0xfffffff0

typedef volatile union {
  struct {
    ca_uint32_t enable               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_RSV_GROUP_ENABLE_LOW_t;


#define  SATURN_L2FE_PP_RSV_GROUP_ENABLE_HI              0xd0001180
#define  SATURN_L2FE_PP_RSV_GROUP_ENABLE_HI_dft          0x0000ffff

typedef volatile union {
  struct {
    ca_uint32_t enable               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_RSV_GROUP_ENABLE_HI_t;


#define  SATURN_L2FE_PP_MEF_OAM_MAC_0_LOW                0xd0001184
#define  SATURN_L2FE_PP_MEF_OAM_MAC_0_LOW_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_MEF_OAM_MAC_0_LOW_t;


#define  SATURN_L2FE_PP_MEF_OAM_MAC_0_HI                 0xd0001188
#define  SATURN_L2FE_PP_MEF_OAM_MAC_0_HI_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_MEF_OAM_MAC_0_HI_t;


#define  SATURN_L2FE_PP_MEF_OAM_TYPE_0                   0xd000118c
#define  SATURN_L2FE_PP_MEF_OAM_TYPE_0_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t type                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_MEF_OAM_TYPE_0_t;


#define  SATURN_L2FE_PP_MEF_OAM_MAC_1_LOW                0xd0001190
#define  SATURN_L2FE_PP_MEF_OAM_MAC_1_LOW_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_MEF_OAM_MAC_1_LOW_t;


#define  SATURN_L2FE_PP_MEF_OAM_MAC_1_HI                 0xd0001194
#define  SATURN_L2FE_PP_MEF_OAM_MAC_1_HI_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_MEF_OAM_MAC_1_HI_t;


#define  SATURN_L2FE_PP_MEF_OAM_TYPE_1                   0xd0001198
#define  SATURN_L2FE_PP_MEF_OAM_TYPE_1_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t type                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_MEF_OAM_TYPE_1_t;


#define  SATURN_L2FE_PP_L7_OFFSET                        0xd000119c
#define  SATURN_L2FE_PP_L7_OFFSET_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t offset               :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_L7_OFFSET_t;


#define  SATURN_L2FE_PP_NI_INTF_ERR_STTS_0               0xd00011a0
#define  SATURN_L2FE_PP_NI_INTF_ERR_STTS_0_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sop_eop_mismatch_0   :  1 ; /* bits 0:0 */
    ca_uint32_t sop_eop_mismatch_1   :  1 ; /* bits 1:1 */
    ca_uint32_t sop_eop_mismatch_2   :  1 ; /* bits 2:2 */
    ca_uint32_t sop_eop_mismatch_3   :  1 ; /* bits 3:3 */
    ca_uint32_t sop_eop_mismatch_4   :  1 ; /* bits 4:4 */
    ca_uint32_t sop_eop_mismatch_5   :  1 ; /* bits 5:5 */
    ca_uint32_t sop_eop_mismatch_6   :  1 ; /* bits 6:6 */
    ca_uint32_t sop_eop_mismatch_7   :  1 ; /* bits 7:7 */
    ca_uint32_t sop_eop_mismatch_8   :  1 ; /* bits 8:8 */
    ca_uint32_t sop_eop_mismatch_9   :  1 ; /* bits 9:9 */
    ca_uint32_t sop_eop_mismatch_10  :  1 ; /* bits 10:10 */
    ca_uint32_t sop_eop_mismatch_11  :  1 ; /* bits 11:11 */
    ca_uint32_t sop_eop_mismatch_12  :  1 ; /* bits 12:12 */
    ca_uint32_t sop_eop_mismatch_13  :  1 ; /* bits 13:13 */
    ca_uint32_t sop_eop_mismatch_14  :  1 ; /* bits 14:14 */
    ca_uint32_t sop_eop_mismatch_15  :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_NI_INTF_ERR_STTS_0_t;


#define  SATURN_L2FE_PP_NI_INTF_ERR_STTS_1               0xd00011a4
#define  SATURN_L2FE_PP_NI_INTF_ERR_STTS_1_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t runt_l2_pkt_0        :  1 ; /* bits 0:0 */
    ca_uint32_t runt_l2_pkt_1        :  1 ; /* bits 1:1 */
    ca_uint32_t runt_l2_pkt_2        :  1 ; /* bits 2:2 */
    ca_uint32_t runt_l2_pkt_3        :  1 ; /* bits 3:3 */
    ca_uint32_t runt_l2_pkt_4        :  1 ; /* bits 4:4 */
    ca_uint32_t runt_l2_pkt_5        :  1 ; /* bits 5:5 */
    ca_uint32_t runt_l2_pkt_6        :  1 ; /* bits 6:6 */
    ca_uint32_t runt_l2_pkt_7        :  1 ; /* bits 7:7 */
    ca_uint32_t runt_l2_pkt_8        :  1 ; /* bits 8:8 */
    ca_uint32_t runt_l2_pkt_9        :  1 ; /* bits 9:9 */
    ca_uint32_t runt_l2_pkt_10       :  1 ; /* bits 10:10 */
    ca_uint32_t runt_l2_pkt_11       :  1 ; /* bits 11:11 */
    ca_uint32_t runt_l2_pkt_12       :  1 ; /* bits 12:12 */
    ca_uint32_t runt_l2_pkt_13       :  1 ; /* bits 13:13 */
    ca_uint32_t runt_l2_pkt_14       :  1 ; /* bits 14:14 */
    ca_uint32_t runt_l2_pkt_15       :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_NI_INTF_ERR_STTS_1_t;


#define  SATURN_L2FE_PP_NI_INTF_ERR_STTS_2               0xd00011a8
#define  SATURN_L2FE_PP_NI_INTF_ERR_STTS_2_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sob_eob_mismatch_0   :  1 ; /* bits 0:0 */
    ca_uint32_t sob_eob_mismatch_1   :  1 ; /* bits 1:1 */
    ca_uint32_t sob_eob_mismatch_2   :  1 ; /* bits 2:2 */
    ca_uint32_t sob_eob_mismatch_3   :  1 ; /* bits 3:3 */
    ca_uint32_t sob_eob_mismatch_4   :  1 ; /* bits 4:4 */
    ca_uint32_t sob_eob_mismatch_5   :  1 ; /* bits 5:5 */
    ca_uint32_t sob_eob_mismatch_6   :  1 ; /* bits 6:6 */
    ca_uint32_t sob_eob_mismatch_7   :  1 ; /* bits 7:7 */
    ca_uint32_t sob_eob_mismatch_8   :  1 ; /* bits 8:8 */
    ca_uint32_t sob_eob_mismatch_9   :  1 ; /* bits 9:9 */
    ca_uint32_t sob_eob_mismatch_10  :  1 ; /* bits 10:10 */
    ca_uint32_t sob_eob_mismatch_11  :  1 ; /* bits 11:11 */
    ca_uint32_t sob_eob_mismatch_12  :  1 ; /* bits 12:12 */
    ca_uint32_t sob_eob_mismatch_13  :  1 ; /* bits 13:13 */
    ca_uint32_t sob_eob_mismatch_14  :  1 ; /* bits 14:14 */
    ca_uint32_t sob_eob_mismatch_15  :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_NI_INTF_ERR_STTS_2_t;


#define  SATURN_L2FE_PP_NI_INTF_ERR_STTS_3               0xd00011ac
#define  SATURN_L2FE_PP_NI_INTF_ERR_STTS_3_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sop_2_sop_gap        :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_NI_INTF_ERR_STTS_3_t;


#define  SATURN_L2FE_PP_PINGPONG_STS                     0xd00011b0
#define  SATURN_L2FE_PP_PINGPONG_STS_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ovfl                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_PINGPONG_STS_t;


#define  SATURN_L2FE_PP_NI_INTF_STS                      0xd00011b4
#define  SATURN_L2FE_PP_NI_INTF_STS_dft                  0x00000001

typedef volatile union {
  struct {
    ca_uint32_t rdy                  :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_NI_INTF_STS_t;


#define  SATURN_L2FE_PP_NI_INTF_DROP_CNT                 0xd00011b8
#define  SATURN_L2FE_PP_NI_INTF_DROP_CNT_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t drop                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_NI_INTF_DROP_CNT_t;


#define  SATURN_L2FE_PP_NI_INTF_PKT_CNT                  0xd00011bc
#define  SATURN_L2FE_PP_NI_INTF_PKT_CNT_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t eop                  : 16 ; /* bits 15:0 */
    ca_uint32_t sop                  : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_NI_INTF_PKT_CNT_t;


#define  SATURN_L2FE_PP_HEADER_A_LOW                     0xd00011c0
#define  SATURN_L2FE_PP_HEADER_A_LOW_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_HEADER_A_LOW_t;


#define  SATURN_L2FE_PP_HEADER_A_MID                     0xd00011c4
#define  SATURN_L2FE_PP_HEADER_A_MID_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_HEADER_A_MID_t;


#define  SATURN_L2FE_PP_HEADER_A_HI                      0xd00011c8
#define  SATURN_L2FE_PP_HEADER_A_HI_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_HEADER_A_HI_t;


#define  SATURN_L2FE_PP_PARSER_CTRL                      0xd00011cc
#define  SATURN_L2FE_PP_PARSER_CTRL_dft                  0xa03b0000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 14 ;
    ca_uint32_t use_ip_addr_mc       :  1 ; /* bits 14:14 */
    ca_uint32_t l3fe_to_l2fe_lrn_ctrl :  1 ; /* bits 15:15 */
    ca_uint32_t egr_ptp_pkt_no_drop_set :  1 ; /* bits 16:16 */
    ca_uint32_t ipv4_checksum_check_enable :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t detect_oam_subtype   :  1 ; /* bits 19:19 */
    ca_uint32_t oam_subtype          :  8 ; /* bits 27:20 */
    ca_uint32_t udf0_det_en          :  1 ; /* bits 28:28 */
    ca_uint32_t udf0_det_type_en     :  1 ; /* bits 29:29 */
    ca_uint32_t udf1_det_en          :  1 ; /* bits 30:30 */
    ca_uint32_t udf1_det_vlan_en     :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_PARSER_CTRL_t;


#define  SATURN_L2FE_PP_SPECIAL_PKT                      0xd00011d0
#define  SATURN_L2FE_PP_SPECIAL_PKT_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t type                 :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_SPECIAL_PKT_t;


#define  SATURN_L2FE_PP_DEBUG_BUS                        0xd00011d4
#define  SATURN_L2FE_PP_DEBUG_BUS_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sel                  :  4 ; /* bits 3:0 */
    ca_uint32_t ni2fe_pkt_cnt_wrap_en :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_DEBUG_BUS_t;


#define  SATURN_L2FE_PP_IPPB_ACCESS                      0xd00011d8
#define  SATURN_L2FE_PP_IPPB_ACCESS_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_IPPB_ACCESS_t;


#define  SATURN_L2FE_PP_IPPB_DATA                        0xd00011dc
#define  SATURN_L2FE_PP_IPPB_DATA_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t lspid                :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_IPPB_DATA_t;


#define  SATURN_L2FE_PP_ILPB_ACCESS                      0xd00011e0
#define  SATURN_L2FE_PP_ILPB_ACCESS_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_ILPB_ACCESS_t;


#define  SATURN_L2FE_PP_ILPB_DATA4                       0xd00011e4
#define  SATURN_L2FE_PP_ILPB_DATA4_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ilpb_reserved_1      : 10 ; /* bits 9:0 */
    ca_uint32_t ilpb_wan_ind         :  1 ; /* bits 10:10 */
    ca_uint32_t ilpb_reserved        :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_ILPB_DATA4_t;


#define  SATURN_L2FE_PP_ILPB_DATA3                       0xd00011e8
#define  SATURN_L2FE_PP_ILPB_DATA3_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ilpb_sc_ind          :  1 ; /* bits 0:0 */
    ca_uint32_t ilpb_default_vlanid  : 12 ; /* bits 12:1 */
    ca_uint32_t ilpb_unkwn_pol_idx   :  3 ; /* bits 15:13 */
    ca_uint32_t ilpb_flowid_as_gemid :  1 ; /* bits 16:16 */
    ca_uint32_t ilpb_gemid_dynamic_mode :  1 ; /* bits 17:17 */
    ca_uint32_t ilpb_reserved_1      : 14 ; /* bits 31:18 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_ILPB_DATA3_t;


#define  SATURN_L2FE_PP_ILPB_DATA2                       0xd00011ec
#define  SATURN_L2FE_PP_ILPB_DATA2_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ilpb_other_tpid_match :  4 ; /* bits 3:0 */
    ca_uint32_t ilpb_inner_c_tpid_enable :  1 ; /* bits 4:4 */
    ca_uint32_t ilpb_inner_s_tpid_enable :  1 ; /* bits 5:5 */
    ca_uint32_t ilpb_top_c_tpid_enable :  1 ; /* bits 6:6 */
    ca_uint32_t ilpb_top_s_tpid_enable :  1 ; /* bits 7:7 */
    ca_uint32_t ilpb_c_tpid_match    :  4 ; /* bits 11:8 */
    ca_uint32_t ilpb_s_tpid_match    :  4 ; /* bits 15:12 */
    ca_uint32_t ilpb_drop_doubletagged_packet :  1 ; /* bits 16:16 */
    ca_uint32_t ilpb_drop_prytagged_packet :  1 ; /* bits 17:17 */
    ca_uint32_t ilpb_drop_untagged_packet :  1 ; /* bits 18:18 */
    ca_uint32_t ilpb_drop_ctag_packet :  1 ; /* bits 19:19 */
    ca_uint32_t ilpb_drop_stag_packet :  1 ; /* bits 20:20 */
    ca_uint32_t ilpb_drop_singletagged_packet :  1 ; /* bits 21:21 */
    ca_uint32_t ilpb_default_noninnertag_cmd :  1 ; /* bits 22:22 */
    ca_uint32_t ilpb_inner_vlan_cmd  :  2 ; /* bits 24:23 */
    ca_uint32_t ilpb_inner_vid_sel_bm :  2 ; /* bits 26:25 */
    ca_uint32_t ilpb_default_untag_cmd :  1 ; /* bits 27:27 */
    ca_uint32_t ilpb_default_top_vlan_cmd :  2 ; /* bits 29:28 */
    ca_uint32_t ilpb_vlan_cmd_sel_bm :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_ILPB_DATA2_t;


#define  SATURN_L2FE_PP_ILPB_DATA1                       0xd00011f0
#define  SATURN_L2FE_PP_ILPB_DATA1_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ilpb_802_1p_mark_control_bm :  1 ; /* bits 0:0 */
    ca_uint32_t ilpb_change_1p_if_pop :  1 ; /* bits 1:1 */
    ca_uint32_t ilpb_top_802_1p_mode_sel :  2 ; /* bits 3:2 */
    ca_uint32_t ilpb_flowid_sel_bm   :  3 ; /* bits 6:4 */
    ca_uint32_t ilpb_cls_length      :  6 ; /* bits 12:7 */
    ca_uint32_t ilpb_cls_start       :  8 ; /* bits 20:13 */
    ca_uint32_t ilpb_igr_cls_lookup_en :  1 ; /* bits 21:21 */
    ca_uint32_t ilpb_spcl_pkt_idx    :  4 ; /* bits 25:22 */
    ca_uint32_t ilpb_da_sa_swap_en   :  1 ; /* bits 26:26 */
    ca_uint32_t ilpb_loop_enable     :  1 ; /* bits 27:27 */
    ca_uint32_t ilpb_sa_move_dis_fwd :  1 ; /* bits 28:28 */
    ca_uint32_t ilpb_station_move_en :  1 ; /* bits 29:29 */
    ca_uint32_t ilpb_stp_mode        :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_ILPB_DATA1_t;


#define  SATURN_L2FE_PP_ILPB_DATA0                       0xd00011f4
#define  SATURN_L2FE_PP_ILPB_DATA0_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ilpb_dflt_premark    :  1 ; /* bits 0:0 */
    ca_uint32_t ilpb_color_src_sel   :  2 ; /* bits 2:1 */
    ca_uint32_t ilpb_ing_fltr_ena    :  1 ; /* bits 3:3 */
    ca_uint32_t ilpb_default_cos     :  3 ; /* bits 6:4 */
    ca_uint32_t ilpb_cos_control_bm  :  3 ; /* bits 9:7 */
    ca_uint32_t ilpb_cos_mode_sel    :  3 ; /* bits 12:10 */
    ca_uint32_t ilpb_default_dscp    :  6 ; /* bits 18:13 */
    ca_uint32_t ilpb_dscp_mark_control_bm :  3 ; /* bits 21:19 */
    ca_uint32_t ilpb_dscp_mode_sel   :  2 ; /* bits 23:22 */
    ca_uint32_t ilpb_dscp_markdown_en :  1 ; /* bits 24:24 */
    ca_uint32_t ilpb_default_802_1p  :  3 ; /* bits 27:25 */
    ca_uint32_t ilpb_inner_802_1p_mode_sel :  2 ; /* bits 29:28 */
    ca_uint32_t ilpb_802_1p_mark_control_bm :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_ILPB_DATA0_t;


#define  SATURN_L2FE_PP_DPB_ACCESS                       0xd00011f8
#define  SATURN_L2FE_PP_DPB_ACCESS_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_DPB_ACCESS_t;


#define  SATURN_L2FE_PP_DPB_DATA                         0xd00011fc
#define  SATURN_L2FE_PP_DPB_DATA_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cos                  :  3 ; /* bits 2:0 */
    ca_uint32_t ldpid                :  6 ; /* bits 8:3 */
    ca_uint32_t bypass               :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_DPB_DATA_t;


#define  SATURN_L2FE_PP_HTTP_LINK_0                      0xd0001200
#define  SATURN_L2FE_PP_HTTP_LINK_0_dft                  0x04000000

typedef volatile union {
  struct {
    ca_uint32_t rule_l4_pid          : 16 ; /* bits 15:0 */
    ca_uint32_t rule_l4_pid_sel      :  1 ; /* bits 16:16 */
    ca_uint32_t rule_l4_type         :  2 ; /* bits 18:17 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t rule_lspid           :  6 ; /* bits 25:20 */
    ca_uint32_t rule_lspid_msk       :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd2               :  4 ;
    ca_uint32_t rule_vld             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_HTTP_LINK_0_t;


#define  SATURN_L2FE_PP_HTTP_LINK_1                      0xd0001204
#define  SATURN_L2FE_PP_HTTP_LINK_1_dft                  0x04000000

typedef volatile union {
  struct {
    ca_uint32_t rule_l4_pid          : 16 ; /* bits 15:0 */
    ca_uint32_t rule_l4_pid_sel      :  1 ; /* bits 16:16 */
    ca_uint32_t rule_l4_type         :  2 ; /* bits 18:17 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t rule_lspid           :  6 ; /* bits 25:20 */
    ca_uint32_t rule_lspid_msk       :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd2               :  4 ;
    ca_uint32_t rule_vld             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_HTTP_LINK_1_t;


#define  SATURN_L2FE_PP_HTTP_LINK_2                      0xd0001208
#define  SATURN_L2FE_PP_HTTP_LINK_2_dft                  0x04000000

typedef volatile union {
  struct {
    ca_uint32_t rule_l4_pid          : 16 ; /* bits 15:0 */
    ca_uint32_t rule_l4_pid_sel      :  1 ; /* bits 16:16 */
    ca_uint32_t rule_l4_type         :  2 ; /* bits 18:17 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t rule_lspid           :  6 ; /* bits 25:20 */
    ca_uint32_t rule_lspid_msk       :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd2               :  4 ;
    ca_uint32_t rule_vld             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PP_HTTP_LINK_2_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PP */
typedef struct {
  SATURN_L2FE_PP_PPID_ATTR_CFG_t                  PPID_ATTR_CFG;                 /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_L2FE_PP_DPB_CTRL_t                       DPB_CTRL;                      /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_L2FE_PP_TPID_CMP_S_t                     TPID_CMP_S;                    /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_L2FE_PP_TPID_CMP_C_t                     TPID_CMP_C;                    /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_L2FE_PP_TPID_CMP_O_t                     TPID_CMP_O;                    /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_L2FE_PP_HELLO_PKT_ENABLE_DA_LOW_t        HELLO_PKT_ENABLE_DA_LOW;       /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_L2FE_PP_HELLO_PKT_ENABLE_DA_HI_t         HELLO_PKT_ENABLE_DA_HI;        /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  SATURN_L2FE_PP_HELLO_PKT_DA_LOW_t               HELLO_PKT_DA_LOW;              /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  SATURN_L2FE_PP_HELLO_PKT_DA_HI_t                HELLO_PKT_DA_HI;               /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  SATURN_L2FE_PP_SPECIAL_ENABLE_DA_0_LOW_t        SPECIAL_ENABLE_DA_0_LOW;       /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  SATURN_L2FE_PP_SPECIAL_ENABLE_DA_0_HI_t         SPECIAL_ENABLE_DA_0_HI;        /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  SATURN_L2FE_PP_SPECIAL_DA_0_LOW_t               SPECIAL_DA_0_LOW;              /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  SATURN_L2FE_PP_SPECIAL_DA_0_HI_t                SPECIAL_DA_0_HI;               /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  SATURN_L2FE_PP_SPECIAL_EV2PT_t                  SPECIAL_EV2PT;                 /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  SATURN_L2FE_PP_SPECIAL_ENABLE_DA_1_LOW_t        SPECIAL_ENABLE_DA_1_LOW;       /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  SATURN_L2FE_PP_SPECIAL_ENABLE_DA_1_HI_t         SPECIAL_ENABLE_DA_1_HI;        /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  SATURN_L2FE_PP_SPECIAL_DA_1_LOW_t               SPECIAL_DA_1_LOW;              /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  SATURN_L2FE_PP_SPECIAL_DA_1_HI_t                SPECIAL_DA_1_HI;               /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  SATURN_L2FE_PP_SPECIAL_VLAN_t                   SPECIAL_VLAN;                  /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  SATURN_L2FE_PP_MY_MAC_LOW_t                     MY_MAC_LOW;                    /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  SATURN_L2FE_PP_MY_MAC_HI_t                      MY_MAC_HI;                     /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  SATURN_L2FE_PP_MY_MAC_ENABLE_LOW_t              MY_MAC_ENABLE_LOW;             /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  SATURN_L2FE_PP_MY_MAC_LOW_1_t                   MY_MAC_LOW_1;                  /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  SATURN_L2FE_PP_MY_MAC_HI_1_t                    MY_MAC_HI_1;                   /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  SATURN_L2FE_PP_MY_MAC_ENABLE_LOW_1_t            MY_MAC_ENABLE_LOW_1;           /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  SATURN_L2FE_PP_RSV_MAC_MC_LOW_t                 RSV_MAC_MC_LOW;                /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  SATURN_L2FE_PP_RSV_MAC_MC_HI_t                  RSV_MAC_MC_HI;                 /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  SATURN_L2FE_PP_RSV_ENABLE_MC_LOW_t              RSV_ENABLE_MC_LOW;             /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  SATURN_L2FE_PP_RSV_ENABLE_MC_HI_t               RSV_ENABLE_MC_HI;              /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  SATURN_L2FE_PP_RSV_GROUP_MAC_LOW_t              RSV_GROUP_MAC_LOW;             /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  SATURN_L2FE_PP_RSV_GROUP_MAC_HI_t               RSV_GROUP_MAC_HI;              /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  SATURN_L2FE_PP_RSV_GROUP_ENABLE_LOW_t           RSV_GROUP_ENABLE_LOW;          /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  SATURN_L2FE_PP_RSV_GROUP_ENABLE_HI_t            RSV_GROUP_ENABLE_HI;           /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  SATURN_L2FE_PP_MEF_OAM_MAC_0_LOW_t              MEF_OAM_MAC_0_LOW;             /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  SATURN_L2FE_PP_MEF_OAM_MAC_0_HI_t               MEF_OAM_MAC_0_HI;              /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  SATURN_L2FE_PP_MEF_OAM_TYPE_0_t                 MEF_OAM_TYPE_0;                /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  SATURN_L2FE_PP_MEF_OAM_MAC_1_LOW_t              MEF_OAM_MAC_1_LOW;             /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  SATURN_L2FE_PP_MEF_OAM_MAC_1_HI_t               MEF_OAM_MAC_1_HI;              /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  SATURN_L2FE_PP_MEF_OAM_TYPE_1_t                 MEF_OAM_TYPE_1;                /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];                   
  SATURN_L2FE_PP_L7_OFFSET_t                      L7_OFFSET;                     /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];                   
  SATURN_L2FE_PP_NI_INTF_ERR_STTS_0_t             NI_INTF_ERR_STTS_0;            /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];                   
  SATURN_L2FE_PP_NI_INTF_ERR_STTS_1_t             NI_INTF_ERR_STTS_1;            /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];                   
  SATURN_L2FE_PP_NI_INTF_ERR_STTS_2_t             NI_INTF_ERR_STTS_2;            /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];                   
  SATURN_L2FE_PP_NI_INTF_ERR_STTS_3_t             NI_INTF_ERR_STTS_3;            /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd44[3];                   
  SATURN_L2FE_PP_PINGPONG_STS_t                   PINGPONG_STS;                  /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd45[3];                   
  SATURN_L2FE_PP_NI_INTF_STS_t                    NI_INTF_STS;                   /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd46[3];                   
  SATURN_L2FE_PP_NI_INTF_DROP_CNT_t               NI_INTF_DROP_CNT;              /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd47[3];                   
  SATURN_L2FE_PP_NI_INTF_PKT_CNT_t                NI_INTF_PKT_CNT;               /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd48[3];                   
  SATURN_L2FE_PP_HEADER_A_LOW_t                   HEADER_A_LOW;                  /* addr: 0x000000c0 */
  ca_uint32_t                              rsrvd49[3];                   
  SATURN_L2FE_PP_HEADER_A_MID_t                   HEADER_A_MID;                  /* addr: 0x000000c4 */
  ca_uint32_t                              rsrvd50[3];                   
  SATURN_L2FE_PP_HEADER_A_HI_t                    HEADER_A_HI;                   /* addr: 0x000000c8 */
  ca_uint32_t                              rsrvd51[3];                   
  SATURN_L2FE_PP_PARSER_CTRL_t                    PARSER_CTRL;                   /* addr: 0x000000cc */
  ca_uint32_t                              rsrvd52[3];                   
  SATURN_L2FE_PP_SPECIAL_PKT_t                    SPECIAL_PKT;                   /* addr: 0x000000d0 */
  ca_uint32_t                              rsrvd53[3];                   
  SATURN_L2FE_PP_DEBUG_BUS_t                      DEBUG_BUS;                     /* addr: 0x000000d4 */
  ca_uint32_t                              rsrvd54[3];                   
  SATURN_L2FE_PP_IPPB_ACCESS_t                    IPPB_ACCESS;                   /* addr: 0x000000d8 */
  ca_uint32_t                              rsrvd55[3];                   
  SATURN_L2FE_PP_IPPB_DATA_t                      IPPB_DATA;                     /* addr: 0x000000dc */
  ca_uint32_t                              rsrvd56[3];                   
  SATURN_L2FE_PP_ILPB_ACCESS_t                    ILPB_ACCESS;                   /* addr: 0x000000e0 */
  ca_uint32_t                              rsrvd57[3];                   
  SATURN_L2FE_PP_ILPB_DATA4_t                     ILPB_DATA4;                    /* addr: 0x000000e4 */
  ca_uint32_t                              rsrvd58[3];                   
  SATURN_L2FE_PP_ILPB_DATA3_t                     ILPB_DATA3;                    /* addr: 0x000000e8 */
  ca_uint32_t                              rsrvd59[3];                   
  SATURN_L2FE_PP_ILPB_DATA2_t                     ILPB_DATA2;                    /* addr: 0x000000ec */
  ca_uint32_t                              rsrvd60[3];                   
  SATURN_L2FE_PP_ILPB_DATA1_t                     ILPB_DATA1;                    /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd61[3];                   
  SATURN_L2FE_PP_ILPB_DATA0_t                     ILPB_DATA0;                    /* addr: 0x000000f4 */
  ca_uint32_t                              rsrvd62[3];                   
  SATURN_L2FE_PP_DPB_ACCESS_t                     DPB_ACCESS;                    /* addr: 0x000000f8 */
  ca_uint32_t                              rsrvd63[3];                   
  SATURN_L2FE_PP_DPB_DATA_t                       DPB_DATA;                      /* addr: 0x000000fc */
  ca_uint32_t                              rsrvd64[3];                   
  SATURN_L2FE_PP_HTTP_LINK_0_t                    HTTP_LINK_0;                   /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd65[3];                   
  SATURN_L2FE_PP_HTTP_LINK_1_t                    HTTP_LINK_1;                   /* addr: 0x00000104 */
  ca_uint32_t                              rsrvd66[3];                   
  SATURN_L2FE_PP_HTTP_LINK_2_t                    HTTP_LINK_2;                   /* addr: 0x00000108 */
} SATURN_APB0_L2FE_PP_t;


/*
 * PLA
 */
        
#define  SATURN_L2FE_PLA_DEBUG_BUS                       0xd0001300
#define  SATURN_L2FE_PLA_DEBUG_BUS_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sel                  :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLA_DEBUG_BUS_t;


#define  SATURN_L2FE_PLA_EV2_PT_CNVT_ACCESS              0xd0001304
#define  SATURN_L2FE_PLA_EV2_PT_CNVT_ACCESS_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLA_EV2_PT_CNVT_ACCESS_t;


#define  SATURN_L2FE_PLA_EV2_PT_CNVT_DATA                0xd0001308
#define  SATURN_L2FE_PLA_EV2_PT_CNVT_DATA_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ev2_pt_cnvt_encoded_value :  5 ; /* bits 4:0 */
    ca_uint32_t ev2_pt_cnvt_ethertype : 16 ; /* bits 20:5 */
    ca_uint32_t rsrvd1               : 11 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLA_EV2_PT_CNVT_DATA_t;


#define  SATURN_L2FE_PLA_SPB_ACCESS                      0xd000130c
#define  SATURN_L2FE_PLA_SPB_ACCESS_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLA_SPB_ACCESS_t;


#define  SATURN_L2FE_PLA_SPB_DATA                        0xd0001310
#define  SATURN_L2FE_PLA_SPB_DATA_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t spb_pkt_no_edit      :  1 ; /* bits 0:0 */
    ca_uint32_t spb_keep_ts          :  1 ; /* bits 1:1 */
    ca_uint32_t spb_bypass_sa_lrn_chk :  1 ; /* bits 2:2 */
    ca_uint32_t spb_limit_fwd_permit :  1 ; /* bits 3:3 */
    ca_uint32_t spb_learn_dis        :  1 ; /* bits 4:4 */
    ca_uint32_t spb_dscp_mark_down   :  1 ; /* bits 5:5 */
    ca_uint32_t spb_flowid           : 12 ; /* bits 17:6 */
    ca_uint32_t spb_flow_en          :  1 ; /* bits 18:18 */
    ca_uint32_t spb_rate_limit_bypass :  1 ; /* bits 19:19 */
    ca_uint32_t spb_cos              :  3 ; /* bits 22:20 */
    ca_uint32_t spb_ldpid            :  6 ; /* bits 28:23 */
    ca_uint32_t spb_spcl_fwd         :  1 ; /* bits 29:29 */
    ca_uint32_t spb_pkt_no_drop      :  1 ; /* bits 30:30 */
    ca_uint32_t spb_hash_cllsn_fwd_permit :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLA_SPB_DATA_t;


#define  SATURN_L2FE_PLA_DOT1P_MAP_ACCESS                0xd0001314
#define  SATURN_L2FE_PLA_DOT1P_MAP_ACCESS_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLA_DOT1P_MAP_ACCESS_t;


#define  SATURN_L2FE_PLA_DOT1P_MAP_DATA                  0xd0001318
#define  SATURN_L2FE_PLA_DOT1P_MAP_DATA_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dot1p_map_mapped_premark :  1 ; /* bits 0:0 */
    ca_uint32_t dot1p_map_mapped_cos :  3 ; /* bits 3:1 */
    ca_uint32_t dot1p_map_mapped_1p  :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLA_DOT1P_MAP_DATA_t;


#define  SATURN_L2FE_PLA_DSCP_MAP_ACCESS                 0xd000131c
#define  SATURN_L2FE_PLA_DSCP_MAP_ACCESS_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLA_DSCP_MAP_ACCESS_t;


#define  SATURN_L2FE_PLA_DSCP_MAP_DATA                   0xd0001320
#define  SATURN_L2FE_PLA_DSCP_MAP_DATA_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mapped_premark       :  1 ; /* bits 0:0 */
    ca_uint32_t dscp_map_mapped_cos  :  3 ; /* bits 3:1 */
    ca_uint32_t dscp_map_marked_flag :  1 ; /* bits 4:4 */
    ca_uint32_t dscp_map_mapped_dscp :  6 ; /* bits 10:5 */
    ca_uint32_t rsrvd1               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLA_DSCP_MAP_DATA_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PLA */
typedef struct {
  SATURN_L2FE_PLA_DEBUG_BUS_t                     DEBUG_BUS;                     /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_L2FE_PLA_EV2_PT_CNVT_ACCESS_t            EV2_PT_CNVT_ACCESS;            /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_L2FE_PLA_EV2_PT_CNVT_DATA_t              EV2_PT_CNVT_DATA;              /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_L2FE_PLA_SPB_ACCESS_t                    SPB_ACCESS;                    /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_L2FE_PLA_SPB_DATA_t                      SPB_DATA;                      /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_L2FE_PLA_DOT1P_MAP_ACCESS_t              DOT1P_MAP_ACCESS;              /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_L2FE_PLA_DOT1P_MAP_DATA_t                DOT1P_MAP_DATA;                /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  SATURN_L2FE_PLA_DSCP_MAP_ACCESS_t               DSCP_MAP_ACCESS;               /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  SATURN_L2FE_PLA_DSCP_MAP_DATA_t                 DSCP_MAP_DATA;                 /* addr: 0x00000020 */
} SATURN_APB0_L2FE_PLA_t;


/*
 * PLC
 */
        
#define  SATURN_L2FE_PLC_HASH_CTRL                       0xd0001400
#define  SATURN_L2FE_PLC_HASH_CTRL_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t lan_sa_hashing_vid_sel :  1 ; /* bits 0:0 */
    ca_uint32_t lan_da_hashing_vid_sel :  1 ; /* bits 1:1 */
    ca_uint32_t lan_sa_learning_vid_sel :  1 ; /* bits 2:2 */
    ca_uint32_t wan_sa_hashing_vid_sel :  1 ; /* bits 3:3 */
    ca_uint32_t wan_da_hashing_vid_sel :  1 ; /* bits 4:4 */
    ca_uint32_t wan_sa_learning_vid_sel :  1 ; /* bits 5:5 */
    ca_uint32_t use_dot1p_l2e        :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLC_HASH_CTRL_t;


#define  SATURN_L2FE_PLC_DPID_FWD_CTRL                   0xd0001404
#define  SATURN_L2FE_PLC_DPID_FWD_CTRL_dft               0x00000001

typedef volatile union {
  struct {
    ca_uint32_t vid_fff_fwd          :  1 ; /* bits 0:0 */
    ca_uint32_t unkvlan_fwd          :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLC_DPID_FWD_CTRL_t;


#define  SATURN_L2FE_PLC_LRN_FWD_CTRL_0                  0xd0001408
#define  SATURN_L2FE_PLC_LRN_FWD_CTRL_0_dft              0x02000210

typedef volatile union {
  struct {
    ca_uint32_t l2_mac_sw_lrn_ldpid  :  6 ; /* bits 5:0 */
    ca_uint32_t l2_mac_sw_lrn_cos    :  3 ; /* bits 8:6 */
    ca_uint32_t l2_mac_sw_lrn_keep_old_wan :  1 ; /* bits 9:9 */
    ca_uint32_t l2_mac_sw_lrn_keep_old_lan :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd1               : 14 ;
    ca_uint32_t sa_miss_fwd          :  1 ; /* bits 25:25 */
    ca_uint32_t nonstd_sa_all_zero_fwd :  1 ; /* bits 26:26 */
    ca_uint32_t nonstd_sa_all_one_fwd :  1 ; /* bits 27:27 */
    ca_uint32_t nonstd_sa_b40_is_one_fwd :  1 ; /* bits 28:28 */
    ca_uint32_t sm_static_entry_fwd  :  1 ; /* bits 29:29 */
    ca_uint32_t sm_tmp_entry_fwd     :  1 ; /* bits 30:30 */
    ca_uint32_t sm_sm_entry_fwd      :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLC_LRN_FWD_CTRL_0_t;


#define  SATURN_L2FE_PLC_LRN_FWD_CTRL_1                  0xd000140c
#define  SATURN_L2FE_PLC_LRN_FWD_CTRL_1_dft              0x08100810

typedef volatile union {
  struct {
    ca_uint32_t sa_limit_excd_ldpid  :  6 ; /* bits 5:0 */
    ca_uint32_t sa_limit_excd_cos    :  3 ; /* bits 8:6 */
    ca_uint32_t sa_limit_excd_fwd_ctrl :  2 ; /* bits 10:9 */
    ca_uint32_t sa_limit_excd_keep_old_wan :  1 ; /* bits 11:11 */
    ca_uint32_t sa_limit_excd_keep_old_lan :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t sa_hash_cllsn_ldpid  :  6 ; /* bits 21:16 */
    ca_uint32_t sa_hash_cllsn_cos    :  3 ; /* bits 24:22 */
    ca_uint32_t sa_hash_cllsn_fwd_ctrl :  2 ; /* bits 26:25 */
    ca_uint32_t sa_hash_cllsn_keep_old_wan :  1 ; /* bits 27:27 */
    ca_uint32_t sa_hash_cllsn_keep_old_lan :  1 ; /* bits 28:28 */
    ca_uint32_t swlrn_othr_pkt_fwd   :  1 ; /* bits 29:29 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLC_LRN_FWD_CTRL_1_t;


#define  SATURN_L2FE_PLC_L2_LEARNING_CTRL                0xd0001410
#define  SATURN_L2FE_PLC_L2_LEARNING_CTRL_dft            0x00000046

typedef volatile union {
  struct {
    ca_uint32_t unkvlan_learn        :  1 ; /* bits 0:0 */
    ca_uint32_t unk_ethtype_no_learn :  1 ; /* bits 1:1 */
    ca_uint32_t igr_dropped_pkt_no_learn :  1 ; /* bits 2:2 */
    ca_uint32_t non_std_sa_all_zero_learn :  1 ; /* bits 3:3 */
    ca_uint32_t non_std_sa_all_one_learn :  1 ; /* bits 4:4 */
    ca_uint32_t non_std_sa_b40_is_one_learn :  1 ; /* bits 5:5 */
    ca_uint32_t loop_pkt_no_learn    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLC_L2_LEARNING_CTRL_t;


#define  SATURN_L2FE_PLC_VLAN_MODE_CTRL                  0xd0001414
#define  SATURN_L2FE_PLC_VLAN_MODE_CTRL_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t l2e_glb_vlan_mode    :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLC_VLAN_MODE_CTRL_t;


#define  SATURN_L2FE_PLC_SA_CHK_CTL                      0xd0001418
#define  SATURN_L2FE_PLC_SA_CHK_CTL_dft                  0x00000001

typedef volatile union {
  struct {
    ca_uint32_t skip_sa_chk          :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLC_SA_CHK_CTL_t;


#define  SATURN_L2FE_PLC_DEBUG                           0xd000141c
#define  SATURN_L2FE_PLC_DEBUG_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bus_sel              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLC_DEBUG_t;


#define  SATURN_L2FE_PLC_ELPB_ACCESS                     0xd0001420
#define  SATURN_L2FE_PLC_ELPB_ACCESS_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLC_ELPB_ACCESS_t;


#define  SATURN_L2FE_PLC_ELPB_DATA                       0xd0001424
#define  SATURN_L2FE_PLC_ELPB_DATA_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t elpb_egr_vlan_aware_mode :  1 ; /* bits 0:0 */
    ca_uint32_t elpb_egr_port_stp_status :  1 ; /* bits 1:1 */
    ca_uint32_t elpb_egr_ve_srch_en  :  1 ; /* bits 2:2 */
    ca_uint32_t elpb_egr_dest_wan    :  1 ; /* bits 3:3 */
    ca_uint32_t elpb_egr_cls_length  :  6 ; /* bits 9:4 */
    ca_uint32_t elpb_egr_cls_start   :  8 ; /* bits 17:10 */
    ca_uint32_t elpb_egr_cls_lookup_en :  1 ; /* bits 18:18 */
    ca_uint32_t elpb_egr_cls_flowid_sel :  1 ; /* bits 19:19 */
    ca_uint32_t elpb_egr_cls_cos_sel :  1 ; /* bits 20:20 */
    ca_uint32_t elpb_reserved        :  3 ; /* bits 23:21 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLC_ELPB_DATA_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PLC */
typedef struct {
  SATURN_L2FE_PLC_HASH_CTRL_t                     HASH_CTRL;                     /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_L2FE_PLC_DPID_FWD_CTRL_t                 DPID_FWD_CTRL;                 /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_L2FE_PLC_LRN_FWD_CTRL_0_t                LRN_FWD_CTRL_0;                /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_L2FE_PLC_LRN_FWD_CTRL_1_t                LRN_FWD_CTRL_1;                /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_L2FE_PLC_L2_LEARNING_CTRL_t              L2_LEARNING_CTRL;              /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_L2FE_PLC_VLAN_MODE_CTRL_t                VLAN_MODE_CTRL;                /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_L2FE_PLC_SA_CHK_CTL_t                    SA_CHK_CTL;                    /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  SATURN_L2FE_PLC_DEBUG_t                         _DEBUG;                        /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  SATURN_L2FE_PLC_ELPB_ACCESS_t                   ELPB_ACCESS;                   /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  SATURN_L2FE_PLC_ELPB_DATA_t                     ELPB_DATA;                     /* addr: 0x00000024 */
} SATURN_APB0_L2FE_PLC_t;


/*
 * PLE
 */
        
#define  SATURN_L2FE_PLE_CTL_REG                         0xd0001500
#define  SATURN_L2FE_PLE_CTL_REG_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t txvlan_membshp_chk_en_lan :  1 ; /* bits 0:0 */
    ca_uint32_t txvlan_membshp_chk_en_wan :  1 ; /* bits 1:1 */
    ca_uint32_t cos_l3_only          :  1 ; /* bits 2:2 */
    ca_uint32_t skip_port_lpbk_chk   :  1 ; /* bits 3:3 */
    ca_uint32_t pon_mode             :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLE_CTL_REG_t;


#define  SATURN_L2FE_PLE_DEFAULT_REG                     0xd0001504
#define  SATURN_L2FE_PLE_DEFAULT_REG_dft                 0x001b0000

typedef volatile union {
  struct {
    ca_uint32_t dflt_flow_en         :  1 ; /* bits 0:0 */
    ca_uint32_t dflt_flowid          : 12 ; /* bits 12:1 */
    ca_uint32_t dflt_markdown_en     :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t dflt_mc_pid          :  6 ; /* bits 21:16 */
    ca_uint32_t rsrvd2               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLE_DEFAULT_REG_t;


#define  SATURN_L2FE_PLE_RX_UNKWN_VLAN_DFT               0xd0001508
#define  SATURN_L2FE_PLE_RX_UNKWN_VLAN_DFT_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t memshp_bm            : 16 ; /* bits 15:0 */
    ca_uint32_t vl_grp_id            : 10 ; /* bits 25:16 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLE_RX_UNKWN_VLAN_DFT_t;


#define  SATURN_L2FE_PLE_TX_UNKWN_VLAN_DFT_1             0xd000150c
#define  SATURN_L2FE_PLE_TX_UNKWN_VLAN_DFT_1_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t stp_mode             :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLE_TX_UNKWN_VLAN_DFT_1_t;


#define  SATURN_L2FE_PLE_TX_UNKWN_VLAN_DFT_2             0xd0001510
#define  SATURN_L2FE_PLE_TX_UNKWN_VLAN_DFT_2_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t memshp_bm            : 16 ; /* bits 15:0 */
    ca_uint32_t untag_bm             : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLE_TX_UNKWN_VLAN_DFT_2_t;


#define  SATURN_L2FE_PLE_TRUNK_GRP_CTRL_0                0xd0001514
#define  SATURN_L2FE_PLE_TRUNK_GRP_CTRL_0_dft            0x00000012

typedef volatile union {
  struct {
    ca_uint32_t trunk_hash_field_sel_mac_sa :  1 ; /* bits 0:0 */
    ca_uint32_t trunk_hash_field_sel_mac_da :  1 ; /* bits 1:1 */
    ca_uint32_t trunk_hash_field_sel_tx_top_vid :  1 ; /* bits 2:2 */
    ca_uint32_t trunk_hash_field_sel_ip_sa :  1 ; /* bits 3:3 */
    ca_uint32_t trunk_hash_field_sel_ip_da :  1 ; /* bits 4:4 */
    ca_uint32_t trunk_hash_field_sel_l4_sp :  1 ; /* bits 5:5 */
    ca_uint32_t trunk_hash_field_sel_l4_dp :  1 ; /* bits 6:6 */
    ca_uint32_t trunk_hash_field_sel_cos :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLE_TRUNK_GRP_CTRL_0_t;


#define  SATURN_L2FE_PLE_TRUNK_GRP_0_MEMBER_0            0xd0001518
#define  SATURN_L2FE_PLE_TRUNK_GRP_0_MEMBER_0_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t valid                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLE_TRUNK_GRP_0_MEMBER_0_t;


#define  SATURN_L2FE_PLE_TRUNK_GRP_0_MEMBER_1            0xd000151c
#define  SATURN_L2FE_PLE_TRUNK_GRP_0_MEMBER_1_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t valid                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLE_TRUNK_GRP_0_MEMBER_1_t;


#define  SATURN_L2FE_PLE_TRUNK_GRP_CTRL_1                0xd0001520
#define  SATURN_L2FE_PLE_TRUNK_GRP_CTRL_1_dft            0x00000012

typedef volatile union {
  struct {
    ca_uint32_t trunk_hash_field_sel_mac_sa :  1 ; /* bits 0:0 */
    ca_uint32_t trunk_hash_field_sel_mac_da :  1 ; /* bits 1:1 */
    ca_uint32_t trunk_hash_field_sel_tx_top_vid :  1 ; /* bits 2:2 */
    ca_uint32_t trunk_hash_field_sel_ip_sa :  1 ; /* bits 3:3 */
    ca_uint32_t trunk_hash_field_sel_ip_da :  1 ; /* bits 4:4 */
    ca_uint32_t trunk_hash_field_sel_l4_sp :  1 ; /* bits 5:5 */
    ca_uint32_t trunk_hash_field_sel_l4_dp :  1 ; /* bits 6:6 */
    ca_uint32_t trunk_hash_field_sel_cos :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLE_TRUNK_GRP_CTRL_1_t;


#define  SATURN_L2FE_PLE_TRUNK_GRP_1_MEMBER_0            0xd0001524
#define  SATURN_L2FE_PLE_TRUNK_GRP_1_MEMBER_0_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t valid                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLE_TRUNK_GRP_1_MEMBER_0_t;


#define  SATURN_L2FE_PLE_TRUNK_GRP_1_MEMBER_1            0xd0001528
#define  SATURN_L2FE_PLE_TRUNK_GRP_1_MEMBER_1_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t valid                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLE_TRUNK_GRP_1_MEMBER_1_t;


#define  SATURN_L2FE_PLE_HD_FF_CTL_REG                   0xd000152c
#define  SATURN_L2FE_PLE_HD_FF_CTL_REG_dft               0x00000610

typedef volatile union {
  struct {
    ca_uint32_t low_thr              :  6 ; /* bits 5:0 */
    ca_uint32_t high_thr             :  6 ; /* bits 11:6 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLE_HD_FF_CTL_REG_t;


#define  SATURN_L2FE_PLE_HD_FF_STS_REG                   0xd0001530
#define  SATURN_L2FE_PLE_HD_FF_STS_REG_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t overflow_ind         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLE_HD_FF_STS_REG_t;


#define  SATURN_L2FE_PLE_HD_FF_HDR_CNT                   0xd0001534
#define  SATURN_L2FE_PLE_HD_FF_HDR_CNT_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLE_HD_FF_HDR_CNT_t;


#define  SATURN_L2FE_PLE_DEBUG_BUS                       0xd0001538
#define  SATURN_L2FE_PLE_DEBUG_BUS_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sel                  :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLE_DEBUG_BUS_t;


#define  SATURN_L2FE_PLE_TX_DSCP_MAP_ACCESS              0xd000153c
#define  SATURN_L2FE_PLE_TX_DSCP_MAP_ACCESS_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLE_TX_DSCP_MAP_ACCESS_t;


#define  SATURN_L2FE_PLE_TX_DSCP_MAP_DATA                0xd0001540
#define  SATURN_L2FE_PLE_TX_DSCP_MAP_DATA_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t txdscp_map_mapped_cos :  3 ; /* bits 2:0 */
    ca_uint32_t txdscp_map_mapped_1p :  3 ; /* bits 5:3 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLE_TX_DSCP_MAP_DATA_t;


#define  SATURN_L2FE_PLE_TX_DOT1P_MAP_ACCESS             0xd0001544
#define  SATURN_L2FE_PLE_TX_DOT1P_MAP_ACCESS_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLE_TX_DOT1P_MAP_ACCESS_t;


#define  SATURN_L2FE_PLE_TX_DOT1P_MAP_DATA               0xd0001548
#define  SATURN_L2FE_PLE_TX_DOT1P_MAP_DATA_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t txdot1p_map_mapped_cos :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLE_TX_DOT1P_MAP_DATA_t;


#define  SATURN_L2FE_PLE_DFT_FWD_ACCESS                  0xd000154c
#define  SATURN_L2FE_PLE_DFT_FWD_ACCESS_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLE_DFT_FWD_ACCESS_t;


#define  SATURN_L2FE_PLE_DFT_FWD_DATA                    0xd0001550
#define  SATURN_L2FE_PLE_DFT_FWD_DATA_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dft_fwd_deny         :  1 ; /* bits 0:0 */
    ca_uint32_t dft_fwd_mc_group_id  : 10 ; /* bits 10:1 */
    ca_uint32_t dft_fwd_redir_en     :  1 ; /* bits 11:11 */
    ca_uint32_t dft_fwd_mc_group_id_valid :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd1               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLE_DFT_FWD_DATA_t;


#define  SATURN_L2FE_PLE_MMSHP_CHK_ID_MAP_ACCESS         0xd0001554
#define  SATURN_L2FE_PLE_MMSHP_CHK_ID_MAP_ACCESS_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLE_MMSHP_CHK_ID_MAP_ACCESS_t;


#define  SATURN_L2FE_PLE_MMSHP_CHK_ID_MAP_DATA           0xd0001558
#define  SATURN_L2FE_PLE_MMSHP_CHK_ID_MAP_DATA_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mmshp_chk_id_map_chk_id :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLE_MMSHP_CHK_ID_MAP_DATA_t;


#define  SATURN_L2FE_PLE_PORT_MMSHP_CHK_ACCESS           0xd000155c
#define  SATURN_L2FE_PLE_PORT_MMSHP_CHK_ACCESS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLE_PORT_MMSHP_CHK_ACCESS_t;


#define  SATURN_L2FE_PLE_PORT_MMSHP_CHK_DATA1            0xd0001560
#define  SATURN_L2FE_PLE_PORT_MMSHP_CHK_DATA1_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ldpid_bm             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLE_PORT_MMSHP_CHK_DATA1_t;


#define  SATURN_L2FE_PLE_PORT_MMSHP_CHK_DATA0            0xd0001564
#define  SATURN_L2FE_PLE_PORT_MMSHP_CHK_DATA0_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ldpid_bm             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLE_PORT_MMSHP_CHK_DATA0_t;


#define  SATURN_L2FE_PLE_TRUNK_DEST_MAP_TBL_ACCESS       0xd0001568
#define  SATURN_L2FE_PLE_TRUNK_DEST_MAP_TBL_ACCESS_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLE_TRUNK_DEST_MAP_TBL_ACCESS_t;


#define  SATURN_L2FE_PLE_TRUNK_DEST_MAP_TBL_DATA         0xd000156c
#define  SATURN_L2FE_PLE_TRUNK_DEST_MAP_TBL_DATA_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ldpid                :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PLE_TRUNK_DEST_MAP_TBL_DATA_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PLE */
typedef struct {
  SATURN_L2FE_PLE_CTL_REG_t                       CTL_REG;                       /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_L2FE_PLE_DEFAULT_REG_t                   DEFAULT_REG;                   /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_L2FE_PLE_RX_UNKWN_VLAN_DFT_t             RX_UNKWN_VLAN_DFT;             /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_L2FE_PLE_TX_UNKWN_VLAN_DFT_1_t           TX_UNKWN_VLAN_DFT_1;           /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_L2FE_PLE_TX_UNKWN_VLAN_DFT_2_t           TX_UNKWN_VLAN_DFT_2;           /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_L2FE_PLE_TRUNK_GRP_CTRL_0_t              TRUNK_GRP_CTRL_0;              /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_L2FE_PLE_TRUNK_GRP_0_MEMBER_0_t          TRUNK_GRP_0_MEMBER_0;          /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  SATURN_L2FE_PLE_TRUNK_GRP_0_MEMBER_1_t          TRUNK_GRP_0_MEMBER_1;          /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  SATURN_L2FE_PLE_TRUNK_GRP_CTRL_1_t              TRUNK_GRP_CTRL_1;              /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  SATURN_L2FE_PLE_TRUNK_GRP_1_MEMBER_0_t          TRUNK_GRP_1_MEMBER_0;          /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  SATURN_L2FE_PLE_TRUNK_GRP_1_MEMBER_1_t          TRUNK_GRP_1_MEMBER_1;          /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  SATURN_L2FE_PLE_HD_FF_CTL_REG_t                 HD_FF_CTL_REG;                 /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  SATURN_L2FE_PLE_HD_FF_STS_REG_t                 HD_FF_STS_REG;                 /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  SATURN_L2FE_PLE_HD_FF_HDR_CNT_t                 HD_FF_HDR_CNT;                 /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  SATURN_L2FE_PLE_DEBUG_BUS_t                     DEBUG_BUS;                     /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  SATURN_L2FE_PLE_TX_DSCP_MAP_ACCESS_t            TX_DSCP_MAP_ACCESS;            /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  SATURN_L2FE_PLE_TX_DSCP_MAP_DATA_t              TX_DSCP_MAP_DATA;              /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  SATURN_L2FE_PLE_TX_DOT1P_MAP_ACCESS_t           TX_DOT1P_MAP_ACCESS;           /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  SATURN_L2FE_PLE_TX_DOT1P_MAP_DATA_t             TX_DOT1P_MAP_DATA;             /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  SATURN_L2FE_PLE_DFT_FWD_ACCESS_t                DFT_FWD_ACCESS;                /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  SATURN_L2FE_PLE_DFT_FWD_DATA_t                  DFT_FWD_DATA;                  /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  SATURN_L2FE_PLE_MMSHP_CHK_ID_MAP_ACCESS_t       MMSHP_CHK_ID_MAP_ACCESS;       /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  SATURN_L2FE_PLE_MMSHP_CHK_ID_MAP_DATA_t         MMSHP_CHK_ID_MAP_DATA;         /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  SATURN_L2FE_PLE_PORT_MMSHP_CHK_ACCESS_t         PORT_MMSHP_CHK_ACCESS;         /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  SATURN_L2FE_PLE_PORT_MMSHP_CHK_DATA1_t          PORT_MMSHP_CHK_DATA1;          /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  SATURN_L2FE_PLE_PORT_MMSHP_CHK_DATA0_t          PORT_MMSHP_CHK_DATA0;          /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  SATURN_L2FE_PLE_TRUNK_DEST_MAP_TBL_ACCESS_t     TRUNK_DEST_MAP_TBL_ACCESS;     /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  SATURN_L2FE_PLE_TRUNK_DEST_MAP_TBL_DATA_t       TRUNK_DEST_MAP_TBL_DATA;       /* addr: 0x0000006c */
} SATURN_APB0_L2FE_PLE_t;


/*
 * ARB
 */
        
#define  SATURN_L2FE_ARB_ARB_CTRL                        0xd0001600
#define  SATURN_L2FE_ARB_ARB_CTRL_dft                    0x09c71d80

typedef volatile union {
  struct {
    ca_uint32_t drop_redir_keep_old  :  1 ; /* bits 0:0 */
    ca_uint32_t dbuf_sel             :  1 ; /* bits 1:1 */
    ca_uint32_t ip_ecn_en            :  1 ; /* bits 2:2 */
    ca_uint32_t mc_idx_copy_en       :  1 ; /* bits 3:3 */
    ca_uint32_t dbuf_dpid            :  4 ; /* bits 7:4 */
    ca_uint32_t use_hdr_a_dbuf_en    :  1 ; /* bits 8:8 */
    ca_uint32_t dst_wan_dync_buf_sel :  1 ; /* bits 9:9 */
    ca_uint32_t wan_lpid             :  6 ; /* bits 15:10 */
    ca_uint32_t wan_ext_lpid         :  6 ; /* bits 21:16 */
    ca_uint32_t tm_wan_dpid          :  4 ; /* bits 25:22 */
    ca_uint32_t tqm_port7_empty_wait_cnt_h :  5 ; /* bits 30:26 */
    ca_uint32_t keep_o_lspid_en_for_mc :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_ARB_ARB_CTRL_t;


#define  SATURN_L2FE_ARB_PER_COS_DONT_MARK_CTRL          0xd0001604
#define  SATURN_L2FE_ARB_PER_COS_DONT_MARK_CTRL_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bitmap_dst_lan       :  8 ; /* bits 7:0 */
    ca_uint32_t bitmap_dst_wan       :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_ARB_PER_COS_DONT_MARK_CTRL_t;


#define  SATURN_L2FE_ARB_ARB_DEBUG                       0xd0001608
#define  SATURN_L2FE_ARB_ARB_DEBUG_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sel                  :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_ARB_ARB_DEBUG_t;


#define  SATURN_L2FE_ARB_REDIR_LDPID_CONFIG_TBL_ACCESS   0xd000160c
#define  SATURN_L2FE_ARB_REDIR_LDPID_CONFIG_TBL_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_ARB_REDIR_LDPID_CONFIG_TBL_ACCESS_t;


#define  SATURN_L2FE_ARB_REDIR_LDPID_CONFIG_TBL_DATA     0xd0001610
#define  SATURN_L2FE_ARB_REDIR_LDPID_CONFIG_TBL_DATA_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rdir_cos_vld         :  1 ; /* bits 0:0 */
    ca_uint32_t rdir_cos             :  3 ; /* bits 3:1 */
    ca_uint32_t rdir_ldpid           :  6 ; /* bits 9:4 */
    ca_uint32_t rdir_en              :  1 ; /* bits 10:10 */
    ca_uint32_t rdir_wan_dst         :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_ARB_REDIR_LDPID_CONFIG_TBL_DATA_t;


#define  SATURN_L2FE_ARB_REDIR_DROP_SRC_CONFIG_TBL_ACCESS 0xd0001614
#define  SATURN_L2FE_ARB_REDIR_DROP_SRC_CONFIG_TBL_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_ARB_REDIR_DROP_SRC_CONFIG_TBL_ACCESS_t;


#define  SATURN_L2FE_ARB_REDIR_DROP_SRC_CONFIG_TBL_DATA  0xd0001618
#define  SATURN_L2FE_ARB_REDIR_DROP_SRC_CONFIG_TBL_DATA_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rdir_cos_vld         :  1 ; /* bits 0:0 */
    ca_uint32_t rdir_cos             :  3 ; /* bits 3:1 */
    ca_uint32_t rdir_ldpid           :  6 ; /* bits 9:4 */
    ca_uint32_t rdir_en              :  1 ; /* bits 10:10 */
    ca_uint32_t rdir_wan_dst         :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_ARB_REDIR_DROP_SRC_CONFIG_TBL_DATA_t;


#define  SATURN_L2FE_ARB_NON_KNOWN_POL_MAP_TBL_ACCESS    0xd000161c
#define  SATURN_L2FE_ARB_NON_KNOWN_POL_MAP_TBL_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_ARB_NON_KNOWN_POL_MAP_TBL_ACCESS_t;


#define  SATURN_L2FE_ARB_NON_KNOWN_POL_MAP_TBL_DATA      0xd0001620
#define  SATURN_L2FE_ARB_NON_KNOWN_POL_MAP_TBL_DATA_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t flooding_pol_id      :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_ARB_NON_KNOWN_POL_MAP_TBL_DATA_t;


#define  SATURN_L2FE_ARB_DSCP_TE_MARK_TBL_ACCESS         0xd0001624
#define  SATURN_L2FE_ARB_DSCP_TE_MARK_TBL_ACCESS_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_ARB_DSCP_TE_MARK_TBL_ACCESS_t;


#define  SATURN_L2FE_ARB_DSCP_TE_MARK_TBL_DATA           0xd0001628
#define  SATURN_L2FE_ARB_DSCP_TE_MARK_TBL_DATA_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mark_value           :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_ARB_DSCP_TE_MARK_TBL_DATA_t;


#define  SATURN_L2FE_ARB_MC_FIB_TBL_ACCESS               0xd000162c
#define  SATURN_L2FE_ARB_MC_FIB_TBL_ACCESS_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_ARB_MC_FIB_TBL_ACCESS_t;


#define  SATURN_L2FE_ARB_MC_FIB_TBL_DATA3                0xd0001630
#define  SATURN_L2FE_ARB_MC_FIB_TBL_DATA3_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pol_en               :  1 ; /* bits 0:0 */
    ca_uint32_t cos                  :  3 ; /* bits 3:1 */
    ca_uint32_t ldpid                :  6 ; /* bits 9:4 */
    ca_uint32_t mac_sa_sel           :  1 ; /* bits 10:10 */
    ca_uint32_t mac_sa_cmd           :  1 ; /* bits 11:11 */
    ca_uint32_t permit_spid_en       :  1 ; /* bits 12:12 */
    ca_uint32_t wan_dst              :  1 ; /* bits 13:13 */
    ca_uint32_t cos_cmd              :  1 ; /* bits 14:14 */
    ca_uint32_t keep_o_lspid         :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_ARB_MC_FIB_TBL_DATA3_t;


#define  SATURN_L2FE_ARB_MC_FIB_TBL_DATA2                0xd0001634
#define  SATURN_L2FE_ARB_MC_FIB_TBL_DATA2_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vid                  :  5 ; /* bits 4:0 */
    ca_uint32_t vlan_cmd             :  3 ; /* bits 7:5 */
    ca_uint32_t vlan_fltr_en         :  1 ; /* bits 8:8 */
    ca_uint32_t mcgid                : 10 ; /* bits 18:9 */
    ca_uint32_t mcgid_en             :  1 ; /* bits 19:19 */
    ca_uint32_t pol_id               :  9 ; /* bits 28:20 */
    ca_uint32_t pol_grp_id           :  3 ; /* bits 31:29 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_ARB_MC_FIB_TBL_DATA2_t;


#define  SATURN_L2FE_ARB_MC_FIB_TBL_DATA1                0xd0001638
#define  SATURN_L2FE_ARB_MC_FIB_TBL_DATA1_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac_da               : 16 ; /* bits 15:0 */
    ca_uint32_t mac_cmd              :  1 ; /* bits 16:16 */
    ca_uint32_t dei                  :  1 ; /* bits 17:17 */
    ca_uint32_t dei_cmd              :  1 ; /* bits 18:18 */
    ca_uint32_t dot1p                :  3 ; /* bits 21:19 */
    ca_uint32_t dot1p_cmd            :  2 ; /* bits 23:22 */
    ca_uint32_t sc_ind               :  1 ; /* bits 24:24 */
    ca_uint32_t vid                  :  7 ; /* bits 31:25 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_ARB_MC_FIB_TBL_DATA1_t;


#define  SATURN_L2FE_ARB_MC_FIB_TBL_DATA0                0xd000163c
#define  SATURN_L2FE_ARB_MC_FIB_TBL_DATA0_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac_da               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_ARB_MC_FIB_TBL_DATA0_t;


#define  SATURN_L2FE_ARB_FLOW_DBUF_TBL_ACCESS            0xd0001640
#define  SATURN_L2FE_ARB_FLOW_DBUF_TBL_ACCESS_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_ARB_FLOW_DBUF_TBL_ACCESS_t;


#define  SATURN_L2FE_ARB_FLOW_DBUF_TBL_DATA              0xd0001644
#define  SATURN_L2FE_ARB_FLOW_DBUF_TBL_DATA_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dbuf_flg_0           :  1 ; /* bits 0:0 */
    ca_uint32_t dbuf_flg_1           :  1 ; /* bits 1:1 */
    ca_uint32_t dbuf_flg_2           :  1 ; /* bits 2:2 */
    ca_uint32_t dbuf_flg_3           :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_ARB_FLOW_DBUF_TBL_DATA_t;


#define  SATURN_L2FE_ARB_PORT_DBUF_TBL_ACCESS            0xd0001648
#define  SATURN_L2FE_ARB_PORT_DBUF_TBL_ACCESS_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 27 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_ARB_PORT_DBUF_TBL_ACCESS_t;


#define  SATURN_L2FE_ARB_PORT_DBUF_TBL_DATA              0xd000164c
#define  SATURN_L2FE_ARB_PORT_DBUF_TBL_DATA_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dbuf_flg             :  1 ; /* bits 0:0 */
    ca_uint32_t ldpid_vld            :  1 ; /* bits 1:1 */
    ca_uint32_t ldpid                :  6 ; /* bits 7:2 */
    ca_uint32_t lspid_vld            :  1 ; /* bits 8:8 */
    ca_uint32_t lspid                :  6 ; /* bits 14:9 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_ARB_PORT_DBUF_TBL_DATA_t;


#define  SATURN_L2FE_ARB_PDPID_MAP_TBL_ACCESS            0xd0001650
#define  SATURN_L2FE_ARB_PDPID_MAP_TBL_ACCESS_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_ARB_PDPID_MAP_TBL_ACCESS_t;


#define  SATURN_L2FE_ARB_PDPID_MAP_TBL_DATA              0xd0001654
#define  SATURN_L2FE_ARB_PDPID_MAP_TBL_DATA_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pdpid                :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_ARB_PDPID_MAP_TBL_DATA_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* ARB */
typedef struct {
  SATURN_L2FE_ARB_ARB_CTRL_t                      ARB_CTRL;                      /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_L2FE_ARB_PER_COS_DONT_MARK_CTRL_t        PER_COS_DONT_MARK_CTRL;        /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_L2FE_ARB_ARB_DEBUG_t                     ARB_DEBUG;                     /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_L2FE_ARB_REDIR_LDPID_CONFIG_TBL_ACCESS_t REDIR_LDPID_CONFIG_TBL_ACCESS; /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_L2FE_ARB_REDIR_LDPID_CONFIG_TBL_DATA_t   REDIR_LDPID_CONFIG_TBL_DATA;   /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_L2FE_ARB_REDIR_DROP_SRC_CONFIG_TBL_ACCESS_t REDIR_DROP_SRC_CONFIG_TBL_ACCESS; /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_L2FE_ARB_REDIR_DROP_SRC_CONFIG_TBL_DATA_t REDIR_DROP_SRC_CONFIG_TBL_DATA; /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  SATURN_L2FE_ARB_NON_KNOWN_POL_MAP_TBL_ACCESS_t  NON_KNOWN_POL_MAP_TBL_ACCESS;  /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  SATURN_L2FE_ARB_NON_KNOWN_POL_MAP_TBL_DATA_t    NON_KNOWN_POL_MAP_TBL_DATA;    /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  SATURN_L2FE_ARB_DSCP_TE_MARK_TBL_ACCESS_t       DSCP_TE_MARK_TBL_ACCESS;       /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  SATURN_L2FE_ARB_DSCP_TE_MARK_TBL_DATA_t         DSCP_TE_MARK_TBL_DATA;         /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  SATURN_L2FE_ARB_MC_FIB_TBL_ACCESS_t             MC_FIB_TBL_ACCESS;             /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  SATURN_L2FE_ARB_MC_FIB_TBL_DATA3_t              MC_FIB_TBL_DATA3;              /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  SATURN_L2FE_ARB_MC_FIB_TBL_DATA2_t              MC_FIB_TBL_DATA2;              /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  SATURN_L2FE_ARB_MC_FIB_TBL_DATA1_t              MC_FIB_TBL_DATA1;              /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  SATURN_L2FE_ARB_MC_FIB_TBL_DATA0_t              MC_FIB_TBL_DATA0;              /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  SATURN_L2FE_ARB_FLOW_DBUF_TBL_ACCESS_t          FLOW_DBUF_TBL_ACCESS;          /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  SATURN_L2FE_ARB_FLOW_DBUF_TBL_DATA_t            FLOW_DBUF_TBL_DATA;            /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  SATURN_L2FE_ARB_PORT_DBUF_TBL_ACCESS_t          PORT_DBUF_TBL_ACCESS;          /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  SATURN_L2FE_ARB_PORT_DBUF_TBL_DATA_t            PORT_DBUF_TBL_DATA;            /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  SATURN_L2FE_ARB_PDPID_MAP_TBL_ACCESS_t          PDPID_MAP_TBL_ACCESS;          /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  SATURN_L2FE_ARB_PDPID_MAP_TBL_DATA_t            PDPID_MAP_TBL_DATA;            /* addr: 0x00000054 */
} SATURN_APB0_L2FE_ARB_t;


/*
 * PE
 */
        
#define  SATURN_L2FE_PE_CTRL                             0xd0001700
#define  SATURN_L2FE_PE_CTRL_dft                         0x000000f0

typedef volatile union {
  struct {
    ca_uint32_t l2_padding_dis       :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t wan_top_dei_keep_old :  1 ; /* bits 4:4 */
    ca_uint32_t lan_top_dei_keep_old :  1 ; /* bits 5:5 */
    ca_uint32_t wan_inner_dei_keep_old :  1 ; /* bits 6:6 */
    ca_uint32_t lan_inner_dei_keep_old :  1 ; /* bits 7:7 */
    ca_uint32_t enhance_tpid_mode    :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd2               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PE_CTRL_t;


#define  SATURN_L2FE_PE_CFG_VLAN_TPID_A                  0xd0001704
#define  SATURN_L2FE_PE_CFG_VLAN_TPID_A_dft              0x00008100

typedef volatile union {
  struct {
    ca_uint32_t tpid                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PE_CFG_VLAN_TPID_A_t;


#define  SATURN_L2FE_PE_CFG_VLAN_TPID_B                  0xd0001708
#define  SATURN_L2FE_PE_CFG_VLAN_TPID_B_dft              0x00008100

typedef volatile union {
  struct {
    ca_uint32_t tpid                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PE_CFG_VLAN_TPID_B_t;


#define  SATURN_L2FE_PE_CFG_VLAN_TPID_C                  0xd000170c
#define  SATURN_L2FE_PE_CFG_VLAN_TPID_C_dft              0x00008100

typedef volatile union {
  struct {
    ca_uint32_t tpid                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PE_CFG_VLAN_TPID_C_t;


#define  SATURN_L2FE_PE_CFG_VLAN_TPID_D                  0xd0001710
#define  SATURN_L2FE_PE_CFG_VLAN_TPID_D_dft              0x00008100

typedef volatile union {
  struct {
    ca_uint32_t tpid                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PE_CFG_VLAN_TPID_D_t;


#define  SATURN_L2FE_PE_MY_MAC_LOW_0                     0xd0001714
#define  SATURN_L2FE_PE_MY_MAC_LOW_0_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PE_MY_MAC_LOW_0_t;


#define  SATURN_L2FE_PE_MY_MAC_HIGH_0                    0xd0001718
#define  SATURN_L2FE_PE_MY_MAC_HIGH_0_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PE_MY_MAC_HIGH_0_t;


#define  SATURN_L2FE_PE_MY_MAC_LOW_1                     0xd000171c
#define  SATURN_L2FE_PE_MY_MAC_LOW_1_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PE_MY_MAC_LOW_1_t;


#define  SATURN_L2FE_PE_MY_MAC_HIGH_1                    0xd0001720
#define  SATURN_L2FE_PE_MY_MAC_HIGH_1_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PE_MY_MAC_HIGH_1_t;


#define  SATURN_L2FE_PE_CMD_FF_CTL_REG                   0xd0001724
#define  SATURN_L2FE_PE_CMD_FF_CTL_REG_dft               0x00004343

typedef volatile union {
  struct {
    ca_uint32_t low_thr_mir          :  4 ; /* bits 3:0 */
    ca_uint32_t high_thr_mir         :  4 ; /* bits 7:4 */
    ca_uint32_t low_thr_ppl          :  4 ; /* bits 11:8 */
    ca_uint32_t high_thr_ppl         :  4 ; /* bits 15:12 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PE_CMD_FF_CTL_REG_t;


#define  SATURN_L2FE_PE_CMD_FF_STS_REG                   0xd0001728
#define  SATURN_L2FE_PE_CMD_FF_STS_REG_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t overflow_ind_mir     :  1 ; /* bits 0:0 */
    ca_uint32_t overflow_ind_ppl     :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PE_CMD_FF_STS_REG_t;


#define  SATURN_L2FE_PE_CMD_FF_CMD_CNT                   0xd000172c
#define  SATURN_L2FE_PE_CMD_FF_CMD_CNT_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num_mir              :  4 ; /* bits 3:0 */
    ca_uint32_t num_ppl              :  4 ; /* bits 7:4 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PE_CMD_FF_CMD_CNT_t;


#define  SATURN_L2FE_PE_TM_INTERFACE_PKT_CNT             0xd0001730
#define  SATURN_L2FE_PE_TM_INTERFACE_PKT_CNT_dft         0x80000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PE_TM_INTERFACE_PKT_CNT_t;


#define  SATURN_L2FE_PE_DROP_CNT_TBL_CLR                 0xd0001734
#define  SATURN_L2FE_PE_DROP_CNT_TBL_CLR_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t set                  :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PE_DROP_CNT_TBL_CLR_t;


#define  SATURN_L2FE_PE_HEADER_A_LOW                     0xd0001738
#define  SATURN_L2FE_PE_HEADER_A_LOW_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PE_HEADER_A_LOW_t;


#define  SATURN_L2FE_PE_HEADER_A_MID                     0xd000173c
#define  SATURN_L2FE_PE_HEADER_A_MID_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PE_HEADER_A_MID_t;


#define  SATURN_L2FE_PE_HEADER_A_HI                      0xd0001740
#define  SATURN_L2FE_PE_HEADER_A_HI_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PE_HEADER_A_HI_t;


#define  SATURN_L2FE_PE_DROP_CNT_GEAR_FF_CNT             0xd0001744
#define  SATURN_L2FE_PE_DROP_CNT_GEAR_FF_CNT_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PE_DROP_CNT_GEAR_FF_CNT_t;


#define  SATURN_L2FE_PE_DROP_CNT_GEAR_FF_STS             0xd0001748
#define  SATURN_L2FE_PE_DROP_CNT_GEAR_FF_STS_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ovfl                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PE_DROP_CNT_GEAR_FF_STS_t;


#define  SATURN_L2FE_PE_DEBUG                            0xd000174c
#define  SATURN_L2FE_PE_DEBUG_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bus_sel              :  4 ; /* bits 3:0 */
    ca_uint32_t fe2tm_pkt_cnt_wrap_en :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PE_DEBUG_t;


#define  SATURN_L2FE_PE_DROP_STTS_ACCESS                 0xd0001750
#define  SATURN_L2FE_PE_DROP_STTS_ACCESS_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PE_DROP_STTS_ACCESS_t;


#define  SATURN_L2FE_PE_DROP_STTS_DATA                   0xd0001754
#define  SATURN_L2FE_PE_DROP_STTS_DATA_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PE_DROP_STTS_DATA_t;


#define  SATURN_L2FE_PE_TPID_SEL_CONFIG_TBL_ACCESS       0xd0001758
#define  SATURN_L2FE_PE_TPID_SEL_CONFIG_TBL_ACCESS_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PE_TPID_SEL_CONFIG_TBL_ACCESS_t;


#define  SATURN_L2FE_PE_TPID_SEL_CONFIG_TBL_DATA         0xd000175c
#define  SATURN_L2FE_PE_TPID_SEL_CONFIG_TBL_DATA_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ctag                 :  2 ; /* bits 1:0 */
    ca_uint32_t stag                 :  2 ; /* bits 3:2 */
    ca_uint32_t inner_ctag           :  2 ; /* bits 5:4 */
    ca_uint32_t inner_stag           :  2 ; /* bits 7:6 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_PE_TPID_SEL_CONFIG_TBL_DATA_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PE */
typedef struct {
  SATURN_L2FE_PE_CTRL_t                           CTRL;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_L2FE_PE_CFG_VLAN_TPID_A_t                CFG_VLAN_TPID_A;               /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_L2FE_PE_CFG_VLAN_TPID_B_t                CFG_VLAN_TPID_B;               /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_L2FE_PE_CFG_VLAN_TPID_C_t                CFG_VLAN_TPID_C;               /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_L2FE_PE_CFG_VLAN_TPID_D_t                CFG_VLAN_TPID_D;               /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_L2FE_PE_MY_MAC_LOW_0_t                   MY_MAC_LOW_0;                  /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_L2FE_PE_MY_MAC_HIGH_0_t                  MY_MAC_HIGH_0;                 /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  SATURN_L2FE_PE_MY_MAC_LOW_1_t                   MY_MAC_LOW_1;                  /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  SATURN_L2FE_PE_MY_MAC_HIGH_1_t                  MY_MAC_HIGH_1;                 /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  SATURN_L2FE_PE_CMD_FF_CTL_REG_t                 CMD_FF_CTL_REG;                /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  SATURN_L2FE_PE_CMD_FF_STS_REG_t                 CMD_FF_STS_REG;                /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  SATURN_L2FE_PE_CMD_FF_CMD_CNT_t                 CMD_FF_CMD_CNT;                /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  SATURN_L2FE_PE_TM_INTERFACE_PKT_CNT_t           TM_INTERFACE_PKT_CNT;          /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  SATURN_L2FE_PE_DROP_CNT_TBL_CLR_t               DROP_CNT_TBL_CLR;              /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  SATURN_L2FE_PE_HEADER_A_LOW_t                   HEADER_A_LOW;                  /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  SATURN_L2FE_PE_HEADER_A_MID_t                   HEADER_A_MID;                  /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  SATURN_L2FE_PE_HEADER_A_HI_t                    HEADER_A_HI;                   /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  SATURN_L2FE_PE_DROP_CNT_GEAR_FF_CNT_t           DROP_CNT_GEAR_FF_CNT;          /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  SATURN_L2FE_PE_DROP_CNT_GEAR_FF_STS_t           DROP_CNT_GEAR_FF_STS;          /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  SATURN_L2FE_PE_DEBUG_t                          _DEBUG;                        /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  SATURN_L2FE_PE_DROP_STTS_ACCESS_t               DROP_STTS_ACCESS;              /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  SATURN_L2FE_PE_DROP_STTS_DATA_t                 DROP_STTS_DATA;                /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  SATURN_L2FE_PE_TPID_SEL_CONFIG_TBL_ACCESS_t     TPID_SEL_CONFIG_TBL_ACCESS;    /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  SATURN_L2FE_PE_TPID_SEL_CONFIG_TBL_DATA_t       TPID_SEL_CONFIG_TBL_DATA;      /* addr: 0x0000005c */
} SATURN_APB0_L2FE_PE_t;


/*
 * LF
 */
        
#define  SATURN_L2FE_LF_THRESHOLD                        0xd0001900
#define  SATURN_L2FE_LF_THRESHOLD_dft                    0x0001d8b4

typedef volatile union {
  struct {
    ca_uint32_t low                  :  9 ; /* bits 8:0 */
    ca_uint32_t high                 :  9 ; /* bits 17:9 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_LF_THRESHOLD_t;


#define  SATURN_L2FE_LF_CNT                              0xd0001904
#define  SATURN_L2FE_LF_CNT_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t entry_cnt            :  9 ; /* bits 8:0 */
    ca_uint32_t seg_cnt              :  7 ; /* bits 15:9 */
    ca_uint32_t extra_store_cnt      :  2 ; /* bits 17:16 */
    ca_uint32_t data_ltched          :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_LF_CNT_t;


#define  SATURN_L2FE_LF_STS                              0xd0001908
#define  SATURN_L2FE_LF_STS_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ovfl                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_LF_STS_t;


#define  SATURN_L2FE_LF_DEBUG                            0xd000190c
#define  SATURN_L2FE_LF_DEBUG_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sel                  :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_LF_DEBUG_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* LF */
typedef struct {
  SATURN_L2FE_LF_THRESHOLD_t                      THRESHOLD;                     /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_L2FE_LF_CNT_t                            CNT;                           /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_L2FE_LF_STS_t                            STS;                           /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_L2FE_LF_DEBUG_t                          _DEBUG;                        /* addr: 0x0000000c */
} SATURN_APB0_L2FE_LF_t;


/*
 * VE
 */
        
#define  SATURN_L2FE_VE_DEBUG_BUS                        0xd0001a00
#define  SATURN_L2FE_VE_DEBUG_BUS_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sel                  :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_VE_DEBUG_BUS_t;


#define  SATURN_L2FE_VE_WAN_SVL_IDX_ACCESS               0xd0001a04
#define  SATURN_L2FE_VE_WAN_SVL_IDX_ACCESS_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 18 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_VE_WAN_SVL_IDX_ACCESS_t;


#define  SATURN_L2FE_VE_WAN_SVL_IDX_DATA                 0xd0001a08
#define  SATURN_L2FE_VE_WAN_SVL_IDX_DATA_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wan_svl_idx_entry_vld :  1 ; /* bits 0:0 */
    ca_uint32_t wan_svl_idx_fib_idx  :  7 ; /* bits 7:1 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_VE_WAN_SVL_IDX_DATA_t;


#define  SATURN_L2FE_VE_WAN_SVL_FIB_ACCESS               0xd0001a0c
#define  SATURN_L2FE_VE_WAN_SVL_FIB_ACCESS_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_VE_WAN_SVL_FIB_ACCESS_t;


#define  SATURN_L2FE_VE_WAN_SVL_FIB_DATA3                0xd0001a10
#define  SATURN_L2FE_VE_WAN_SVL_FIB_DATA3_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wan_svl_fib_vid      :  8 ; /* bits 7:0 */
    ca_uint32_t wan_svl_fib_do_inner_vid_lookup :  1 ; /* bits 8:8 */
    ca_uint32_t wan_svl_fib_reserved :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_VE_WAN_SVL_FIB_DATA3_t;


#define  SATURN_L2FE_VE_WAN_SVL_FIB_DATA2                0xd0001a14
#define  SATURN_L2FE_VE_WAN_SVL_FIB_DATA2_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wan_svl_fib_dscp     :  6 ; /* bits 5:0 */
    ca_uint32_t wan_svl_fib_802_1p   :  3 ; /* bits 8:6 */
    ca_uint32_t wan_svl_fib_ldpid_vld :  1 ; /* bits 9:9 */
    ca_uint32_t wan_svl_fib_ldpid    :  6 ; /* bits 15:10 */
    ca_uint32_t wan_svl_fib_mc_vlan_ind :  1 ; /* bits 16:16 */
    ca_uint32_t wan_svl_fib_stp_mode :  2 ; /* bits 18:17 */
    ca_uint32_t wan_svl_fib_inner_cmd_valid :  1 ; /* bits 19:19 */
    ca_uint32_t wan_svl_fib_innervid_usel2 :  1 ; /* bits 20:20 */
    ca_uint32_t wan_svl_fib_inner_vlan_cmd :  2 ; /* bits 22:21 */
    ca_uint32_t wan_svl_fib_top_cmd_valid :  1 ; /* bits 23:23 */
    ca_uint32_t wan_svl_fib_topvid_usel2 :  1 ; /* bits 24:24 */
    ca_uint32_t wan_svl_fib_top_vlan_cmd :  2 ; /* bits 26:25 */
    ca_uint32_t wan_svl_fib_sc_ind   :  1 ; /* bits 27:27 */
    ca_uint32_t wan_svl_fib_vid      :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_VE_WAN_SVL_FIB_DATA2_t;


#define  SATURN_L2FE_VE_WAN_SVL_FIB_DATA1                0xd0001a18
#define  SATURN_L2FE_VE_WAN_SVL_FIB_DATA1_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wan_svl_fib_vl_group_id : 10 ; /* bits 9:0 */
    ca_uint32_t wan_svl_fib_da_sa_swap :  1 ; /* bits 10:10 */
    ca_uint32_t wan_svl_fib_permit   :  1 ; /* bits 11:11 */
    ca_uint32_t wan_svl_fib_markdown_en :  1 ; /* bits 12:12 */
    ca_uint32_t wan_svl_fib_flowid_valid :  1 ; /* bits 13:13 */
    ca_uint32_t wan_svl_fib_flowid   : 12 ; /* bits 25:14 */
    ca_uint32_t wan_svl_fib_cos_valid :  1 ; /* bits 26:26 */
    ca_uint32_t wan_svl_fib_dscp_valid :  1 ; /* bits 27:27 */
    ca_uint32_t wan_svl_fib_802_1p_valid :  1 ; /* bits 28:28 */
    ca_uint32_t wan_svl_fib_cos      :  3 ; /* bits 31:29 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_VE_WAN_SVL_FIB_DATA1_t;


#define  SATURN_L2FE_VE_WAN_SVL_FIB_DATA0                0xd0001a1c
#define  SATURN_L2FE_VE_WAN_SVL_FIB_DATA0_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wan_svl_fib_egress_top_untag_bm : 16 ; /* bits 15:0 */
    ca_uint32_t wan_svl_fib_membership_bm : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_VE_WAN_SVL_FIB_DATA0_t;


#define  SATURN_L2FE_VE_WAN_CVL_IDX_ACCESS               0xd0001a20
#define  SATURN_L2FE_VE_WAN_CVL_IDX_ACCESS_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 18 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_VE_WAN_CVL_IDX_ACCESS_t;


#define  SATURN_L2FE_VE_WAN_CVL_IDX_DATA                 0xd0001a24
#define  SATURN_L2FE_VE_WAN_CVL_IDX_DATA_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wan_cvl_idx_entry_vld :  1 ; /* bits 0:0 */
    ca_uint32_t wan_cvl_idx_fib_idx  :  7 ; /* bits 7:1 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_VE_WAN_CVL_IDX_DATA_t;


#define  SATURN_L2FE_VE_WAN_CVL_FIB_ACCESS               0xd0001a28
#define  SATURN_L2FE_VE_WAN_CVL_FIB_ACCESS_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_VE_WAN_CVL_FIB_ACCESS_t;


#define  SATURN_L2FE_VE_WAN_CVL_FIB_DATA3                0xd0001a2c
#define  SATURN_L2FE_VE_WAN_CVL_FIB_DATA3_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wan_cvl_fib_vid      :  8 ; /* bits 7:0 */
    ca_uint32_t wan_cvl_fib_reserved :  2 ; /* bits 9:8 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_VE_WAN_CVL_FIB_DATA3_t;


#define  SATURN_L2FE_VE_WAN_CVL_FIB_DATA2                0xd0001a30
#define  SATURN_L2FE_VE_WAN_CVL_FIB_DATA2_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wan_cvl_fib_dscp     :  6 ; /* bits 5:0 */
    ca_uint32_t wan_cvl_fib_802_1p   :  3 ; /* bits 8:6 */
    ca_uint32_t wan_cvl_fib_ldpid_vld :  1 ; /* bits 9:9 */
    ca_uint32_t wan_cvl_fib_ldpid    :  6 ; /* bits 15:10 */
    ca_uint32_t wan_cvl_fib_mc_vlan_ind :  1 ; /* bits 16:16 */
    ca_uint32_t wan_cvl_fib_stp_mode :  2 ; /* bits 18:17 */
    ca_uint32_t wan_cvl_fib_inner_cmd_valid :  1 ; /* bits 19:19 */
    ca_uint32_t wan_cvl_fib_innervid_usel2 :  1 ; /* bits 20:20 */
    ca_uint32_t wan_cvl_fib_inner_vlan_cmd :  2 ; /* bits 22:21 */
    ca_uint32_t wan_cvl_fib_top_cmd_valid :  1 ; /* bits 23:23 */
    ca_uint32_t wan_cvl_fib_topvid_usel2 :  1 ; /* bits 24:24 */
    ca_uint32_t wan_cvl_fib_top_vlan_cmd :  2 ; /* bits 26:25 */
    ca_uint32_t wan_cvl_fib_sc_ind   :  1 ; /* bits 27:27 */
    ca_uint32_t wan_cvl_fib_vid      :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_VE_WAN_CVL_FIB_DATA2_t;


#define  SATURN_L2FE_VE_WAN_CVL_FIB_DATA1                0xd0001a34
#define  SATURN_L2FE_VE_WAN_CVL_FIB_DATA1_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wan_cvl_fib_vl_group_id : 10 ; /* bits 9:0 */
    ca_uint32_t wan_cvl_fib_da_sa_swap :  1 ; /* bits 10:10 */
    ca_uint32_t wan_cvl_fib_permit   :  1 ; /* bits 11:11 */
    ca_uint32_t wan_cvl_fib_markdown_en :  1 ; /* bits 12:12 */
    ca_uint32_t wan_cvl_fib_flowid_valid :  1 ; /* bits 13:13 */
    ca_uint32_t wan_cvl_fib_flowid   : 12 ; /* bits 25:14 */
    ca_uint32_t wan_cvl_fib_cos_valid :  1 ; /* bits 26:26 */
    ca_uint32_t wan_cvl_fib_dscp_valid :  1 ; /* bits 27:27 */
    ca_uint32_t wan_cvl_fib_802_1p_valid :  1 ; /* bits 28:28 */
    ca_uint32_t wan_cvl_fib_cos      :  3 ; /* bits 31:29 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_VE_WAN_CVL_FIB_DATA1_t;


#define  SATURN_L2FE_VE_WAN_CVL_FIB_DATA0                0xd0001a38
#define  SATURN_L2FE_VE_WAN_CVL_FIB_DATA0_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wan_cvl_fib_egress_top_untag_bm : 16 ; /* bits 15:0 */
    ca_uint32_t wan_cvl_fib_membership_bm : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_VE_WAN_CVL_FIB_DATA0_t;


#define  SATURN_L2FE_VE_LAN_VL_IDX_ACCESS                0xd0001a3c
#define  SATURN_L2FE_VE_LAN_VL_IDX_ACCESS_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 18 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_VE_LAN_VL_IDX_ACCESS_t;


#define  SATURN_L2FE_VE_LAN_VL_IDX_DATA                  0xd0001a40
#define  SATURN_L2FE_VE_LAN_VL_IDX_DATA_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t lan_vl_idx_entry_vld :  1 ; /* bits 0:0 */
    ca_uint32_t lan_vl_idx_fib_idx   :  7 ; /* bits 7:1 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_VE_LAN_VL_IDX_DATA_t;


#define  SATURN_L2FE_VE_LAN_VL_FIB_ACCESS                0xd0001a44
#define  SATURN_L2FE_VE_LAN_VL_FIB_ACCESS_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_VE_LAN_VL_FIB_ACCESS_t;


#define  SATURN_L2FE_VE_LAN_VL_FIB_DATA3                 0xd0001a48
#define  SATURN_L2FE_VE_LAN_VL_FIB_DATA3_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t lan_vl_fib_vid       :  6 ; /* bits 5:0 */
    ca_uint32_t lan_vl_fib_reserved  :  4 ; /* bits 9:6 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_VE_LAN_VL_FIB_DATA3_t;


#define  SATURN_L2FE_VE_LAN_VL_FIB_DATA2                 0xd0001a4c
#define  SATURN_L2FE_VE_LAN_VL_FIB_DATA2_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t lan_vl_fib_dscp      :  6 ; /* bits 5:0 */
    ca_uint32_t lan_vl_fib_802_1p    :  3 ; /* bits 8:6 */
    ca_uint32_t lan_vl_fib_ldpid_vld :  1 ; /* bits 9:9 */
    ca_uint32_t lan_vl_fib_ldpid     :  6 ; /* bits 15:10 */
    ca_uint32_t lan_vl_fib_mc_vlan_ind :  1 ; /* bits 16:16 */
    ca_uint32_t lan_vl_fib_stp_mode  :  2 ; /* bits 18:17 */
    ca_uint32_t lan_vl_fib_inner_cmd_valid :  1 ; /* bits 19:19 */
    ca_uint32_t lan_vl_fib_inner_vlan_cmd :  2 ; /* bits 21:20 */
    ca_uint32_t lan_vl_fib_top_cmd_valid :  1 ; /* bits 22:22 */
    ca_uint32_t lan_vl_fib_top_vlan_cmd :  2 ; /* bits 24:23 */
    ca_uint32_t lan_vl_fib_sc_ind    :  1 ; /* bits 25:25 */
    ca_uint32_t lan_vl_fib_vid       :  6 ; /* bits 31:26 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_VE_LAN_VL_FIB_DATA2_t;


#define  SATURN_L2FE_VE_LAN_VL_FIB_DATA1                 0xd0001a50
#define  SATURN_L2FE_VE_LAN_VL_FIB_DATA1_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t lan_vl_fib_vl_group_id : 10 ; /* bits 9:0 */
    ca_uint32_t lan_vl_fib_da_sa_swap :  1 ; /* bits 10:10 */
    ca_uint32_t lan_vl_fib_permit    :  1 ; /* bits 11:11 */
    ca_uint32_t lan_vl_fib_markdown_en :  1 ; /* bits 12:12 */
    ca_uint32_t lan_vl_fib_flowid_valid :  1 ; /* bits 13:13 */
    ca_uint32_t lan_vl_fib_flowid    : 12 ; /* bits 25:14 */
    ca_uint32_t lan_vl_fib_cos_valid :  1 ; /* bits 26:26 */
    ca_uint32_t lan_vl_fib_dscp_valid :  1 ; /* bits 27:27 */
    ca_uint32_t lan_vl_fib_802_1p_valid :  1 ; /* bits 28:28 */
    ca_uint32_t lan_vl_fib_cos       :  3 ; /* bits 31:29 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_VE_LAN_VL_FIB_DATA1_t;


#define  SATURN_L2FE_VE_LAN_VL_FIB_DATA0                 0xd0001a54
#define  SATURN_L2FE_VE_LAN_VL_FIB_DATA0_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t lan_vl_fib_egress_top_untag_bm : 16 ; /* bits 15:0 */
    ca_uint32_t lan_vl_fib_membership_bm : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_VE_LAN_VL_FIB_DATA0_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* VE */
typedef struct {
  SATURN_L2FE_VE_DEBUG_BUS_t                      DEBUG_BUS;                     /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_L2FE_VE_WAN_SVL_IDX_ACCESS_t             WAN_SVL_IDX_ACCESS;            /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_L2FE_VE_WAN_SVL_IDX_DATA_t               WAN_SVL_IDX_DATA;              /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_L2FE_VE_WAN_SVL_FIB_ACCESS_t             WAN_SVL_FIB_ACCESS;            /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_L2FE_VE_WAN_SVL_FIB_DATA3_t              WAN_SVL_FIB_DATA3;             /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_L2FE_VE_WAN_SVL_FIB_DATA2_t              WAN_SVL_FIB_DATA2;             /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_L2FE_VE_WAN_SVL_FIB_DATA1_t              WAN_SVL_FIB_DATA1;             /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  SATURN_L2FE_VE_WAN_SVL_FIB_DATA0_t              WAN_SVL_FIB_DATA0;             /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  SATURN_L2FE_VE_WAN_CVL_IDX_ACCESS_t             WAN_CVL_IDX_ACCESS;            /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  SATURN_L2FE_VE_WAN_CVL_IDX_DATA_t               WAN_CVL_IDX_DATA;              /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  SATURN_L2FE_VE_WAN_CVL_FIB_ACCESS_t             WAN_CVL_FIB_ACCESS;            /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  SATURN_L2FE_VE_WAN_CVL_FIB_DATA3_t              WAN_CVL_FIB_DATA3;             /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  SATURN_L2FE_VE_WAN_CVL_FIB_DATA2_t              WAN_CVL_FIB_DATA2;             /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  SATURN_L2FE_VE_WAN_CVL_FIB_DATA1_t              WAN_CVL_FIB_DATA1;             /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  SATURN_L2FE_VE_WAN_CVL_FIB_DATA0_t              WAN_CVL_FIB_DATA0;             /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  SATURN_L2FE_VE_LAN_VL_IDX_ACCESS_t              LAN_VL_IDX_ACCESS;             /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  SATURN_L2FE_VE_LAN_VL_IDX_DATA_t                LAN_VL_IDX_DATA;               /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  SATURN_L2FE_VE_LAN_VL_FIB_ACCESS_t              LAN_VL_FIB_ACCESS;             /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  SATURN_L2FE_VE_LAN_VL_FIB_DATA3_t               LAN_VL_FIB_DATA3;              /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  SATURN_L2FE_VE_LAN_VL_FIB_DATA2_t               LAN_VL_FIB_DATA2;              /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  SATURN_L2FE_VE_LAN_VL_FIB_DATA1_t               LAN_VL_FIB_DATA1;              /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  SATURN_L2FE_VE_LAN_VL_FIB_DATA0_t               LAN_VL_FIB_DATA0;              /* addr: 0x00000054 */
} SATURN_APB0_L2FE_VE_t;


/*
 * CLE
 */
        
#define  SATURN_L2FE_CLE_CTRL                            0xd0001b00
#define  SATURN_L2FE_CLE_CTRL_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t igr_use_frst_hit     :  1 ; /* bits 0:0 */
    ca_uint32_t egr_use_frst_hit     :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_CTRL_t;


#define  SATURN_L2FE_CLE_CONFG_STTS1                     0xd0001b04
#define  SATURN_L2FE_CLE_CONFG_STTS1_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t igr_configured_length_over_size :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_CONFG_STTS1_t;


#define  SATURN_L2FE_CLE_CONFG_STTS2                     0xd0001b08
#define  SATURN_L2FE_CLE_CONFG_STTS2_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t egr_configured_length_over_size :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_CONFG_STTS2_t;


#define  SATURN_L2FE_CLE_DEBUG                           0xd0001b0c
#define  SATURN_L2FE_CLE_DEBUG_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t igr_cls_bus_sel      :  2 ; /* bits 1:0 */
    ca_uint32_t egr_cls_bus_sel      :  2 ; /* bits 3:2 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_DEBUG_t;


#define  SATURN_L2FE_CLE_IGR_KEY_ACCESS                  0xd0001b10
#define  SATURN_L2FE_CLE_IGR_KEY_ACCESS_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_IGR_KEY_ACCESS_t;


#define  SATURN_L2FE_CLE_IGR_KEY_DATA12                  0xd0001b14
#define  SATURN_L2FE_CLE_IGR_KEY_DATA12_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_entry_type    :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_valid         :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_IGR_KEY_DATA12_t;


#define  SATURN_L2FE_CLE_IGR_KEY_DATA11                  0xd0001b18
#define  SATURN_L2FE_CLE_IGR_KEY_DATA11_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_mac_da :  8 ; /* bits 7:0 */
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_ecn_mask :  1 ; /* bits 8:8 */
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_ecn :  2 ; /* bits 10:9 */
    ca_uint32_t cl_key_orhr_ipv4e_reserved : 19 ; /* bits 29:11 */
    ca_uint32_t cl_key_orhr_ipv6_valid :  1 ; /* bits 30:30 */
    ca_uint32_t cl_key_entry_type    :  1 ; /* bits 31:31 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_da : 27 ; /* bits 26:0 */
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_ecn_mask :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_ecn :  2 ; /* bits 29:28 */
    ca_uint32_t cl_key_tre_rule_hinge :  1 ; /* bits 30:30 */
    ca_uint32_t rsrvd1               :  1 ;
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_1_mac_da : 19 ; /* bits 18:0 */
    ca_uint32_t cl_key_tre_l2rl2r_1_reserved :  7 ; /* bits 25:19 */
    ca_uint32_t cl_key_tre_rule_type_1 :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_rule_type_0 :  2 ; /* bits 29:28 */
    ca_uint32_t rsrvd1               :  2 ;
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_1_mac_da : 19 ; /* bits 18:0 */
    ca_uint32_t cl_key_tre_l2rl3r_1_reserved :  7 ; /* bits 25:19 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_1_mac_da : 19 ; /* bits 18:0 */
    ca_uint32_t cl_key_tre_l2rcmr_1_reserved :  7 ; /* bits 25:19 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_da : 17 ; /* bits 16:0 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ecn_mask :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ecn :  2 ; /* bits 19:18 */
    ca_uint32_t cl_key_tre_l3rl2r_1_reserved :  6 ; /* bits 25:20 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_da : 17 ; /* bits 16:0 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ecn_mask :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ecn :  2 ; /* bits 19:18 */
    ca_uint32_t cl_key_tre_l3rl3r_1_reserved :  6 ; /* bits 25:20 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_da : 17 ; /* bits 16:0 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ecn_mask :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ecn :  2 ; /* bits 19:18 */
    ca_uint32_t cl_key_tre_l3rcmr_1_reserved :  6 ; /* bits 25:20 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_1_mac_addr : 17 ; /* bits 16:0 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ecn_mask :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ecn :  2 ; /* bits 19:18 */
    ca_uint32_t cl_key_tre_cmrl2r_1_reserved :  6 ; /* bits 25:20 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_1_mac_addr : 17 ; /* bits 16:0 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ecn_mask :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ecn :  2 ; /* bits 19:18 */
    ca_uint32_t cl_key_tre_cmrl3r_1_reserved :  6 ; /* bits 25:20 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_1_mac_addr : 17 ; /* bits 16:0 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ecn_mask :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ecn :  2 ; /* bits 19:18 */
    ca_uint32_t cl_key_tre_cmrcmr_1_reserved :  6 ; /* bits 25:20 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf10 ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_IGR_KEY_DATA11_t;


#define  SATURN_L2FE_CLE_IGR_KEY_DATA10                  0xd0001b1c
#define  SATURN_L2FE_CLE_IGR_KEY_DATA10_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_mac_da : 32 ; /* bits 31:0 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_da : 32 ; /* bits 31:0 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_1_mac_sa :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l2rl2r_1_mac_da : 29 ; /* bits 31:3 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_1_mac_sa :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l2rl3r_1_mac_da : 29 ; /* bits 31:3 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_1_mac_sa :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l2rcmr_1_mac_da : 29 ; /* bits 31:3 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_sa : 17 ; /* bits 16:0 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_da : 15 ; /* bits 31:17 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_sa : 17 ; /* bits 16:0 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_da : 15 ; /* bits 31:17 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_sa : 17 ; /* bits 16:0 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_da : 15 ; /* bits 31:17 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_addr :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrl2r_1_mac_addr : 31 ; /* bits 31:1 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_addr :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrl3r_1_mac_addr : 31 ; /* bits 31:1 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_addr :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrcmr_1_mac_addr : 31 ; /* bits 31:1 */
  } bf10 ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_IGR_KEY_DATA10_t;


#define  SATURN_L2FE_CLE_IGR_KEY_DATA9                   0xd0001b20
#define  SATURN_L2FE_CLE_IGR_KEY_DATA9_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_mac_sa : 24 ; /* bits 23:0 */
    ca_uint32_t cl_key_orhr_ipv4e_mac_da :  8 ; /* bits 31:24 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_da : 32 ; /* bits 31:0 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_1_mac_sa : 32 ; /* bits 31:0 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_1_mac_sa : 32 ; /* bits 31:0 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_1_mac_sa : 32 ; /* bits 31:0 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_flags :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_fragment :  1 ; /* bits 1:1 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_option :  1 ; /* bits 2:2 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ip_tos :  6 ; /* bits 8:3 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ip_pt :  8 ; /* bits 16:9 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_sa : 15 ; /* bits 31:17 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_flags :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_fragment :  1 ; /* bits 1:1 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_option :  1 ; /* bits 2:2 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ip_tos :  6 ; /* bits 8:3 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ip_pt :  8 ; /* bits 16:9 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_sa : 15 ; /* bits 31:17 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_flags :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_fragment :  1 ; /* bits 1:1 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_option :  1 ; /* bits 2:2 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ip_tos :  6 ; /* bits 8:3 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ip_pt :  8 ; /* bits 16:9 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_sa : 15 ; /* bits 31:17 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_1_ip_pt :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_addr : 31 ; /* bits 31:1 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_1_ip_pt :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_addr : 31 ; /* bits 31:1 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_1_ip_pt :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_addr : 31 ; /* bits 31:1 */
  } bf10 ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_IGR_KEY_DATA9_t;


#define  SATURN_L2FE_CLE_IGR_KEY_DATA8                   0xd0001b24
#define  SATURN_L2FE_CLE_IGR_KEY_DATA8_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_top_vid :  8 ; /* bits 7:0 */
    ca_uint32_t cl_key_orhr_ipv4e_mac_sa : 24 ; /* bits 31:8 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_da : 32 ; /* bits 31:0 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_1_inner_vid :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_l2rl2r_1_top_sc_ind :  1 ; /* bits 6:6 */
    ca_uint32_t cl_key_tre_l2rl2r_1_top_vid : 12 ; /* bits 18:7 */
    ca_uint32_t cl_key_tre_l2rl2r_1_mac_sa : 13 ; /* bits 31:19 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_1_inner_vid :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_l2rl3r_1_top_sc_ind :  1 ; /* bits 6:6 */
    ca_uint32_t cl_key_tre_l2rl3r_1_top_vid : 12 ; /* bits 18:7 */
    ca_uint32_t cl_key_tre_l2rl3r_1_mac_sa : 13 ; /* bits 31:19 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_1_inner_vid :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_l2rcmr_1_top_sc_ind :  1 ; /* bits 6:6 */
    ca_uint32_t cl_key_tre_l2rcmr_1_top_vid : 12 ; /* bits 18:7 */
    ca_uint32_t cl_key_tre_l2rcmr_1_mac_sa : 13 ; /* bits 31:19 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_1_inner_vid : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_l3rl2r_1_top_sc_ind :  1 ; /* bits 12:12 */
    ca_uint32_t cl_key_tre_l3rl2r_1_top_vid : 12 ; /* bits 24:13 */
    ca_uint32_t cl_key_tre_l3rl2r_1_special_pkt_code :  5 ; /* bits 29:25 */
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_flags :  2 ; /* bits 31:30 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_1_inner_vid : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_l3rl3r_1_top_sc_ind :  1 ; /* bits 12:12 */
    ca_uint32_t cl_key_tre_l3rl3r_1_top_vid : 12 ; /* bits 24:13 */
    ca_uint32_t cl_key_tre_l3rl3r_1_special_pkt_code :  5 ; /* bits 29:25 */
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_flags :  2 ; /* bits 31:30 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_1_inner_vid : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_l3rcmr_1_top_sc_ind :  1 ; /* bits 12:12 */
    ca_uint32_t cl_key_tre_l3rcmr_1_top_vid : 12 ; /* bits 24:13 */
    ca_uint32_t cl_key_tre_l3rcmr_1_special_pkt_code :  5 ; /* bits 29:25 */
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_flags :  2 ; /* bits 31:30 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_1_top_vid :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_tre_cmrl2r_1_special_pkt_code :  5 ; /* bits 13:9 */
    ca_uint32_t cl_key_tre_cmrl2r_1_l4_flags :  3 ; /* bits 16:14 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_fragment :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_option :  1 ; /* bits 18:18 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ip_tos :  6 ; /* bits 24:19 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ip_pt :  7 ; /* bits 31:25 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_1_top_vid :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_tre_cmrl3r_1_special_pkt_code :  5 ; /* bits 13:9 */
    ca_uint32_t cl_key_tre_cmrl3r_1_l4_flags :  3 ; /* bits 16:14 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_fragment :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_option :  1 ; /* bits 18:18 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ip_tos :  6 ; /* bits 24:19 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ip_pt :  7 ; /* bits 31:25 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_1_top_vid :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_tre_cmrcmr_1_special_pkt_code :  5 ; /* bits 13:9 */
    ca_uint32_t cl_key_tre_cmrcmr_1_l4_flags :  3 ; /* bits 16:14 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_fragment :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_option :  1 ; /* bits 18:18 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ip_tos :  6 ; /* bits 24:19 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ip_pt :  7 ; /* bits 31:25 */
  } bf10 ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_IGR_KEY_DATA8_t;


#define  SATURN_L2FE_CLE_IGR_KEY_DATA7                   0xd0001b28
#define  SATURN_L2FE_CLE_IGR_KEY_DATA7_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_da :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_orhr_ipv4e_ev2_pt :  5 ; /* bits 5:1 */
    ca_uint32_t cl_key_orhr_ipv4e_tag_num :  2 ; /* bits 7:6 */
    ca_uint32_t cl_key_orhr_ipv4e_inner_802_1p :  3 ; /* bits 10:8 */
    ca_uint32_t cl_key_orhr_ipv4e_top_802_1p :  3 ; /* bits 13:11 */
    ca_uint32_t cl_key_orhr_ipv4e_inner_sc_ind :  1 ; /* bits 14:14 */
    ca_uint32_t cl_key_orhr_ipv4e_inner_vid : 12 ; /* bits 26:15 */
    ca_uint32_t cl_key_orhr_ipv4e_top_sc_ind :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_orhr_ipv4e_top_vid :  4 ; /* bits 31:28 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa : 27 ; /* bits 26:0 */
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_da :  5 ; /* bits 31:27 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_1_l4_dp : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_l2rl2r_1_ev2_pt :  5 ; /* bits 16:12 */
    ca_uint32_t cl_key_tre_l2rl2r_1_tag_num :  2 ; /* bits 18:17 */
    ca_uint32_t cl_key_tre_l2rl2r_1_inner_802_1p :  3 ; /* bits 21:19 */
    ca_uint32_t cl_key_tre_l2rl2r_1_top_802_1p :  3 ; /* bits 24:22 */
    ca_uint32_t cl_key_tre_l2rl2r_1_inner_sc_ind :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_l2rl2r_1_inner_vid :  6 ; /* bits 31:26 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_1_l4_dp : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_l2rl3r_1_ev2_pt :  5 ; /* bits 16:12 */
    ca_uint32_t cl_key_tre_l2rl3r_1_tag_num :  2 ; /* bits 18:17 */
    ca_uint32_t cl_key_tre_l2rl3r_1_inner_802_1p :  3 ; /* bits 21:19 */
    ca_uint32_t cl_key_tre_l2rl3r_1_top_802_1p :  3 ; /* bits 24:22 */
    ca_uint32_t cl_key_tre_l2rl3r_1_inner_sc_ind :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_l2rl3r_1_inner_vid :  6 ; /* bits 31:26 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_1_l4_dp : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_l2rcmr_1_ev2_pt :  5 ; /* bits 16:12 */
    ca_uint32_t cl_key_tre_l2rcmr_1_tag_num :  2 ; /* bits 18:17 */
    ca_uint32_t cl_key_tre_l2rcmr_1_inner_802_1p :  3 ; /* bits 21:19 */
    ca_uint32_t cl_key_tre_l2rcmr_1_top_802_1p :  3 ; /* bits 24:22 */
    ca_uint32_t cl_key_tre_l2rcmr_1_inner_sc_ind :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_l2rcmr_1_inner_vid :  6 ; /* bits 31:26 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_sp :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_dp : 16 ; /* bits 17:2 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ev2_pt :  5 ; /* bits 22:18 */
    ca_uint32_t cl_key_tre_l3rl2r_1_tag_num :  2 ; /* bits 24:23 */
    ca_uint32_t cl_key_tre_l3rl2r_1_inner_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_l3rl2r_1_top_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_l3rl2r_1_inner_sc_ind :  1 ; /* bits 31:31 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_sp :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_dp : 16 ; /* bits 17:2 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ev2_pt :  5 ; /* bits 22:18 */
    ca_uint32_t cl_key_tre_l3rl3r_1_tag_num :  2 ; /* bits 24:23 */
    ca_uint32_t cl_key_tre_l3rl3r_1_inner_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_l3rl3r_1_top_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_l3rl3r_1_inner_sc_ind :  1 ; /* bits 31:31 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_sp :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_dp : 16 ; /* bits 17:2 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ev2_pt :  5 ; /* bits 22:18 */
    ca_uint32_t cl_key_tre_l3rcmr_1_tag_num :  2 ; /* bits 24:23 */
    ca_uint32_t cl_key_tre_l3rcmr_1_inner_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_l3rcmr_1_top_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_l3rcmr_1_inner_sc_ind :  1 ; /* bits 31:31 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_1_l4_sp :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_cmrl2r_1_l4_dp : 16 ; /* bits 17:2 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ev2_pt :  5 ; /* bits 22:18 */
    ca_uint32_t cl_key_tre_cmrl2r_1_tag_num :  2 ; /* bits 24:23 */
    ca_uint32_t cl_key_tre_cmrl2r_1_top_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_cmrl2r_1_top_sc_ind :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_cmrl2r_1_top_vid :  3 ; /* bits 31:29 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_1_l4_sp :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_cmrl3r_1_l4_dp : 16 ; /* bits 17:2 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ev2_pt :  5 ; /* bits 22:18 */
    ca_uint32_t cl_key_tre_cmrl3r_1_tag_num :  2 ; /* bits 24:23 */
    ca_uint32_t cl_key_tre_cmrl3r_1_top_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_cmrl3r_1_top_sc_ind :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_cmrl3r_1_top_vid :  3 ; /* bits 31:29 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_1_l4_sp :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_cmrcmr_1_l4_dp : 16 ; /* bits 17:2 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ev2_pt :  5 ; /* bits 22:18 */
    ca_uint32_t cl_key_tre_cmrcmr_1_tag_num :  2 ; /* bits 24:23 */
    ca_uint32_t cl_key_tre_cmrcmr_1_top_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_cmrcmr_1_top_sc_ind :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_cmrcmr_1_top_vid :  3 ; /* bits 31:29 */
  } bf10 ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_IGR_KEY_DATA7_t;


#define  SATURN_L2FE_CLE_IGR_KEY_DATA6                   0xd0001b2c
#define  SATURN_L2FE_CLE_IGR_KEY_DATA6_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_sa :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_da : 31 ; /* bits 31:1 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa : 32 ; /* bits 31:0 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_1_fields_operator :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l2rl2r_1_mask :  2 ; /* bits 2:1 */
    ca_uint32_t cl_key_tre_l2rl2r_1_l4_ctrl :  3 ; /* bits 5:3 */
    ca_uint32_t cl_key_tre_l2rl2r_1_dot1p_ctrl :  2 ; /* bits 7:6 */
    ca_uint32_t cl_key_tre_l2rl2r_1_vid_ctrl :  2 ; /* bits 9:8 */
    ca_uint32_t cl_key_tre_l2rl2r_1_mac_ctrl :  2 ; /* bits 11:10 */
    ca_uint32_t cl_key_tre_l2rl2r_1_l4_sp : 16 ; /* bits 27:12 */
    ca_uint32_t cl_key_tre_l2rl2r_1_l4_dp :  4 ; /* bits 31:28 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_1_fields_operator :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l2rl3r_1_mask :  2 ; /* bits 2:1 */
    ca_uint32_t cl_key_tre_l2rl3r_1_l4_ctrl :  3 ; /* bits 5:3 */
    ca_uint32_t cl_key_tre_l2rl3r_1_dot1p_ctrl :  2 ; /* bits 7:6 */
    ca_uint32_t cl_key_tre_l2rl3r_1_vid_ctrl :  2 ; /* bits 9:8 */
    ca_uint32_t cl_key_tre_l2rl3r_1_mac_ctrl :  2 ; /* bits 11:10 */
    ca_uint32_t cl_key_tre_l2rl3r_1_l4_sp : 16 ; /* bits 27:12 */
    ca_uint32_t cl_key_tre_l2rl3r_1_l4_dp :  4 ; /* bits 31:28 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_1_fields_operator :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l2rcmr_1_mask :  2 ; /* bits 2:1 */
    ca_uint32_t cl_key_tre_l2rcmr_1_l4_ctrl :  3 ; /* bits 5:3 */
    ca_uint32_t cl_key_tre_l2rcmr_1_dot1p_ctrl :  2 ; /* bits 7:6 */
    ca_uint32_t cl_key_tre_l2rcmr_1_vid_ctrl :  2 ; /* bits 9:8 */
    ca_uint32_t cl_key_tre_l2rcmr_1_mac_ctrl :  2 ; /* bits 11:10 */
    ca_uint32_t cl_key_tre_l2rcmr_1_l4_sp : 16 ; /* bits 27:12 */
    ca_uint32_t cl_key_tre_l2rcmr_1_l4_dp :  4 ; /* bits 31:28 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_1_fields_operator :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l3rl2r_1_mask :  8 ; /* bits 8:1 */
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_ctrl :  3 ; /* bits 11:9 */
    ca_uint32_t cl_key_tre_l3rl2r_1_dot1p_ctrl :  2 ; /* bits 13:12 */
    ca_uint32_t cl_key_tre_l3rl2r_1_vid_ctrl :  2 ; /* bits 15:14 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ip_ctrl :  2 ; /* bits 17:16 */
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_sp : 14 ; /* bits 31:18 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_1_fields_operator :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l3rl3r_1_mask :  8 ; /* bits 8:1 */
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_ctrl :  3 ; /* bits 11:9 */
    ca_uint32_t cl_key_tre_l3rl3r_1_dot1p_ctrl :  2 ; /* bits 13:12 */
    ca_uint32_t cl_key_tre_l3rl3r_1_vid_ctrl :  2 ; /* bits 15:14 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ip_ctrl :  2 ; /* bits 17:16 */
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_sp : 14 ; /* bits 31:18 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_1_fields_operator :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l3rcmr_1_mask :  8 ; /* bits 8:1 */
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_ctrl :  3 ; /* bits 11:9 */
    ca_uint32_t cl_key_tre_l3rcmr_1_dot1p_ctrl :  2 ; /* bits 13:12 */
    ca_uint32_t cl_key_tre_l3rcmr_1_vid_ctrl :  2 ; /* bits 15:14 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ip_ctrl :  2 ; /* bits 17:16 */
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_sp : 14 ; /* bits 31:18 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_1_fields_operator :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrl2r_1_mask : 12 ; /* bits 12:1 */
    ca_uint32_t cl_key_tre_cmrl2r_1_l4_ctrl :  3 ; /* bits 15:13 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_addr_sel :  1 ; /* bits 16:16 */
    ca_uint32_t cl_key_tre_cmrl2r_1_mac_addr_sel :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_cmrl2r_1_l4_sp : 14 ; /* bits 31:18 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_1_fields_operator :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrl3r_1_mask : 12 ; /* bits 12:1 */
    ca_uint32_t cl_key_tre_cmrl3r_1_l4_ctrl :  3 ; /* bits 15:13 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_addr_sel :  1 ; /* bits 16:16 */
    ca_uint32_t cl_key_tre_cmrl3r_1_mac_addr_sel :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_cmrl3r_1_l4_sp : 14 ; /* bits 31:18 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_1_fields_operator :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrcmr_1_mask : 12 ; /* bits 12:1 */
    ca_uint32_t cl_key_tre_cmrcmr_1_l4_ctrl :  3 ; /* bits 15:13 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_addr_sel :  1 ; /* bits 16:16 */
    ca_uint32_t cl_key_tre_cmrcmr_1_mac_addr_sel :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_cmrcmr_1_l4_sp : 14 ; /* bits 31:18 */
  } bf10 ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_IGR_KEY_DATA6_t;


#define  SATURN_L2FE_CLE_IGR_KEY_DATA5                   0xd0001b30
#define  SATURN_L2FE_CLE_IGR_KEY_DATA5_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_ip_pt :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_sa : 31 ; /* bits 31:1 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa : 32 ; /* bits 31:0 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_2_mac_da : 22 ; /* bits 21:0 */
    ca_uint32_t cl_key_tre_l2rl2r_2_reserved :  7 ; /* bits 28:22 */
    ca_uint32_t cl_key_tre_l2rl2r_1_prcd :  3 ; /* bits 31:29 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_da : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ecn_mask :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ecn :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_l2rl3r_2_reserved :  6 ; /* bits 28:23 */
    ca_uint32_t cl_key_tre_l2rl3r_1_prcd :  3 ; /* bits 31:29 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_2_mac_addr : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ecn_mask :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ecn :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_l2rcmr_2_reserved :  6 ; /* bits 28:23 */
    ca_uint32_t cl_key_tre_l2rcmr_1_prcd :  3 ; /* bits 31:29 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_2_mac_da : 22 ; /* bits 21:0 */
    ca_uint32_t cl_key_tre_l3rl2r_2_reserved :  7 ; /* bits 28:22 */
    ca_uint32_t cl_key_tre_l3rl2r_1_prcd :  3 ; /* bits 31:29 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_da : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ecn_mask :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ecn :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_l3rl3r_2_reserved :  6 ; /* bits 28:23 */
    ca_uint32_t cl_key_tre_l3rl3r_1_prcd :  3 ; /* bits 31:29 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_2_mac_addr : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ecn_mask :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ecn :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_l3rcmr_2_reserved :  6 ; /* bits 28:23 */
    ca_uint32_t cl_key_tre_l3rcmr_1_prcd :  3 ; /* bits 31:29 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_2_mac_da : 22 ; /* bits 21:0 */
    ca_uint32_t cl_key_tre_cmrl2r_2_reserved :  7 ; /* bits 28:22 */
    ca_uint32_t cl_key_tre_cmrl2r_1_prcd :  3 ; /* bits 31:29 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_da : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ecn_mask :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ecn :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_cmrl3r_2_reserved :  6 ; /* bits 28:23 */
    ca_uint32_t cl_key_tre_cmrl3r_1_prcd :  3 ; /* bits 31:29 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_2_mac_addr : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ecn_mask :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ecn :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_cmrcmr_2_reserved :  6 ; /* bits 28:23 */
    ca_uint32_t cl_key_tre_cmrcmr_1_prcd :  3 ; /* bits 31:29 */
  } bf10 ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_IGR_KEY_DATA5_t;


#define  SATURN_L2FE_CLE_IGR_KEY_DATA4                   0xd0001b34
#define  SATURN_L2FE_CLE_IGR_KEY_DATA4_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_l4_dp_low :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_dp_high : 16 ; /* bits 16:1 */
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_fragment :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_option :  1 ; /* bits 18:18 */
    ca_uint32_t cl_key_orhr_ipv4e_ip_tos :  6 ; /* bits 24:19 */
    ca_uint32_t cl_key_orhr_ipv4e_ip_pt :  7 ; /* bits 31:25 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa : 32 ; /* bits 31:0 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_2_mac_sa :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_l2rl2r_2_mac_da : 26 ; /* bits 31:6 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_sa : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_da : 12 ; /* bits 31:20 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_addr :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_l2rcmr_2_mac_addr : 28 ; /* bits 31:4 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_2_mac_sa :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_l3rl2r_2_mac_da : 26 ; /* bits 31:6 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_sa : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_da : 12 ; /* bits 31:20 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_addr :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_l3rcmr_2_mac_addr : 28 ; /* bits 31:4 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_2_mac_sa :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_cmrl2r_2_mac_da : 26 ; /* bits 31:6 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_sa : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_da : 12 ; /* bits 31:20 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_addr :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_cmrcmr_2_mac_addr : 28 ; /* bits 31:4 */
  } bf10 ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_IGR_KEY_DATA4_t;


#define  SATURN_L2FE_CLE_IGR_KEY_DATA3                   0xd0001b38
#define  SATURN_L2FE_CLE_IGR_KEY_DATA3_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_l4_sp_low :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_sp_high : 16 ; /* bits 16:1 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_dp_low : 15 ; /* bits 31:17 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ip_tos :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_orhr_ipv6e_ip_pt :  8 ; /* bits 12:5 */
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_mask : 14 ; /* bits 26:13 */
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa :  5 ; /* bits 31:27 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_2_mac_sa : 32 ; /* bits 31:0 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_2_special_pkt_code :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l2rl3r_2_l4_flags :  3 ; /* bits 3:1 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_fragment :  1 ; /* bits 4:4 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_option :  1 ; /* bits 5:5 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ip_tos :  6 ; /* bits 11:6 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ip_pt :  8 ; /* bits 19:12 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_sa : 12 ; /* bits 31:20 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_2_ip_pt :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_addr : 28 ; /* bits 31:4 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_2_mac_sa : 32 ; /* bits 31:0 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_2_special_pkt_code :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l3rl3r_2_l4_flags :  3 ; /* bits 3:1 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_fragment :  1 ; /* bits 4:4 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_option :  1 ; /* bits 5:5 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ip_tos :  6 ; /* bits 11:6 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ip_pt :  8 ; /* bits 19:12 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_sa : 12 ; /* bits 31:20 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_2_ip_pt :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_addr : 28 ; /* bits 31:4 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_2_mac_sa : 32 ; /* bits 31:0 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_2_special_pkt_code :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrl3r_2_l4_flags :  3 ; /* bits 3:1 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_fragment :  1 ; /* bits 4:4 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_option :  1 ; /* bits 5:5 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ip_tos :  6 ; /* bits 11:6 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ip_pt :  8 ; /* bits 19:12 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_sa : 12 ; /* bits 31:20 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_2_ip_pt :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_addr : 28 ; /* bits 31:4 */
  } bf10 ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_IGR_KEY_DATA3_t;


#define  SATURN_L2FE_CLE_IGR_KEY_DATA2                   0xd0001b3c
#define  SATURN_L2FE_CLE_IGR_KEY_DATA2_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_global_key :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_orhr_ipv4e_special_pkt_code :  5 ; /* bits 13:9 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_flags :  3 ; /* bits 16:14 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_sp_low : 15 ; /* bits 31:17 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_l4_dp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_orhr_ipv6e_tag_num :  2 ; /* bits 6:5 */
    ca_uint32_t cl_key_orhr_ipv6e_top_802_1p :  3 ; /* bits 9:7 */
    ca_uint32_t cl_key_orhr_ipv6e_top_sc_ind :  1 ; /* bits 10:10 */
    ca_uint32_t cl_key_orhr_ipv6e_top_vid : 12 ; /* bits 22:11 */
    ca_uint32_t cl_key_orhr_ipv6e_special_pkt_code :  5 ; /* bits 27:23 */
    ca_uint32_t cl_key_orhr_ipv6e_l4_flags :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_orhr_ipv6e_ip_tos :  1 ; /* bits 31:31 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_2_inner_vid :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_tre_l2rl2r_2_top_sc_ind :  1 ; /* bits 9:9 */
    ca_uint32_t cl_key_tre_l2rl2r_2_top_vid : 12 ; /* bits 21:10 */
    ca_uint32_t cl_key_tre_l2rl2r_2_mac_sa : 10 ; /* bits 31:22 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_2_top_802_1p :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l2rl3r_2_inner_sc_ind :  1 ; /* bits 2:2 */
    ca_uint32_t cl_key_tre_l2rl3r_2_inner_vid : 12 ; /* bits 14:3 */
    ca_uint32_t cl_key_tre_l2rl3r_2_top_sc_ind :  1 ; /* bits 15:15 */
    ca_uint32_t cl_key_tre_l2rl3r_2_top_vid : 12 ; /* bits 27:16 */
    ca_uint32_t cl_key_tre_l2rl3r_2_special_pkt_code :  4 ; /* bits 31:28 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_2_top_vid : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_l2rcmr_2_special_pkt_code :  5 ; /* bits 16:12 */
    ca_uint32_t cl_key_tre_l2rcmr_2_l4_flags :  3 ; /* bits 19:17 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_fragment :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_option :  1 ; /* bits 21:21 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ip_tos :  6 ; /* bits 27:22 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ip_pt :  4 ; /* bits 31:28 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_2_inner_vid :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_tre_l3rl2r_2_top_sc_ind :  1 ; /* bits 9:9 */
    ca_uint32_t cl_key_tre_l3rl2r_2_top_vid : 12 ; /* bits 21:10 */
    ca_uint32_t cl_key_tre_l3rl2r_2_mac_sa : 10 ; /* bits 31:22 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_2_top_802_1p :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l3rl3r_2_inner_sc_ind :  1 ; /* bits 2:2 */
    ca_uint32_t cl_key_tre_l3rl3r_2_inner_vid : 12 ; /* bits 14:3 */
    ca_uint32_t cl_key_tre_l3rl3r_2_top_sc_ind :  1 ; /* bits 15:15 */
    ca_uint32_t cl_key_tre_l3rl3r_2_top_vid : 12 ; /* bits 27:16 */
    ca_uint32_t cl_key_tre_l3rl3r_2_special_pkt_code :  4 ; /* bits 31:28 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_2_top_vid : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_l3rcmr_2_special_pkt_code :  5 ; /* bits 16:12 */
    ca_uint32_t cl_key_tre_l3rcmr_2_l4_flags :  3 ; /* bits 19:17 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_fragment :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_option :  1 ; /* bits 21:21 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ip_tos :  6 ; /* bits 27:22 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ip_pt :  4 ; /* bits 31:28 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_2_inner_vid :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_tre_cmrl2r_2_top_sc_ind :  1 ; /* bits 9:9 */
    ca_uint32_t cl_key_tre_cmrl2r_2_top_vid : 12 ; /* bits 21:10 */
    ca_uint32_t cl_key_tre_cmrl2r_2_mac_sa : 10 ; /* bits 31:22 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_2_top_802_1p :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_cmrl3r_2_inner_sc_ind :  1 ; /* bits 2:2 */
    ca_uint32_t cl_key_tre_cmrl3r_2_inner_vid : 12 ; /* bits 14:3 */
    ca_uint32_t cl_key_tre_cmrl3r_2_top_sc_ind :  1 ; /* bits 15:15 */
    ca_uint32_t cl_key_tre_cmrl3r_2_top_vid : 12 ; /* bits 27:16 */
    ca_uint32_t cl_key_tre_cmrl3r_2_special_pkt_code :  4 ; /* bits 31:28 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_2_top_vid : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_cmrcmr_2_special_pkt_code :  5 ; /* bits 16:12 */
    ca_uint32_t cl_key_tre_cmrcmr_2_l4_flags :  3 ; /* bits 19:17 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_fragment :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_option :  1 ; /* bits 21:21 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ip_tos :  6 ; /* bits 27:22 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ip_pt :  4 ; /* bits 31:28 */
  } bf10 ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_IGR_KEY_DATA2_t;


#define  SATURN_L2FE_CLE_IGR_KEY_DATA1                   0xd0001b40
#define  SATURN_L2FE_CLE_IGR_KEY_DATA1_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_ip_ctrl :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_orhr_ipv4e_dot1p_ctrl :  2 ; /* bits 4:3 */
    ca_uint32_t cl_key_orhr_ipv4e_vid_ctrl :  2 ; /* bits 6:5 */
    ca_uint32_t cl_key_orhr_ipv4e_mac_ctrl :  2 ; /* bits 8:7 */
    ca_uint32_t cl_key_orhr_ipv4e_global_key : 23 ; /* bits 31:9 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_flow_label :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_orhr_ipv6e_l4_sp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_orhr_ipv6e_l4_dp : 11 ; /* bits 31:21 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_2_l4_dp : 15 ; /* bits 14:0 */
    ca_uint32_t cl_key_tre_l2rl2r_2_ev2_pt :  5 ; /* bits 19:15 */
    ca_uint32_t cl_key_tre_l2rl2r_2_tag_num :  2 ; /* bits 21:20 */
    ca_uint32_t cl_key_tre_l2rl2r_2_inner_802_1p :  3 ; /* bits 24:22 */
    ca_uint32_t cl_key_tre_l2rl2r_2_top_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_l2rl2r_2_inner_sc_ind :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_l2rl2r_2_inner_vid :  3 ; /* bits 31:29 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_2_l4_sp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_tre_l2rl3r_2_l4_dp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ev2_pt :  5 ; /* bits 25:21 */
    ca_uint32_t cl_key_tre_l2rl3r_2_tag_num :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_l2rl3r_2_inner_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_l2rl3r_2_top_802_1p :  1 ; /* bits 31:31 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_2_l4_sp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_tre_l2rcmr_2_l4_dp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ev2_pt :  5 ; /* bits 25:21 */
    ca_uint32_t cl_key_tre_l2rcmr_2_tag_num :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_l2rcmr_2_top_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_l2rcmr_2_top_sc_ind :  1 ; /* bits 31:31 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_2_l4_dp : 15 ; /* bits 14:0 */
    ca_uint32_t cl_key_tre_l3rl2r_2_ev2_pt :  5 ; /* bits 19:15 */
    ca_uint32_t cl_key_tre_l3rl2r_2_tag_num :  2 ; /* bits 21:20 */
    ca_uint32_t cl_key_tre_l3rl2r_2_inner_802_1p :  3 ; /* bits 24:22 */
    ca_uint32_t cl_key_tre_l3rl2r_2_top_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_l3rl2r_2_inner_sc_ind :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_l3rl2r_2_inner_vid :  3 ; /* bits 31:29 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_2_l4_sp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_tre_l3rl3r_2_l4_dp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ev2_pt :  5 ; /* bits 25:21 */
    ca_uint32_t cl_key_tre_l3rl3r_2_tag_num :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_l3rl3r_2_inner_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_l3rl3r_2_top_802_1p :  1 ; /* bits 31:31 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_2_l4_sp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_tre_l3rcmr_2_l4_dp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ev2_pt :  5 ; /* bits 25:21 */
    ca_uint32_t cl_key_tre_l3rcmr_2_tag_num :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_l3rcmr_2_top_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_l3rcmr_2_top_sc_ind :  1 ; /* bits 31:31 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_2_l4_dp : 15 ; /* bits 14:0 */
    ca_uint32_t cl_key_tre_cmrl2r_2_ev2_pt :  5 ; /* bits 19:15 */
    ca_uint32_t cl_key_tre_cmrl2r_2_tag_num :  2 ; /* bits 21:20 */
    ca_uint32_t cl_key_tre_cmrl2r_2_inner_802_1p :  3 ; /* bits 24:22 */
    ca_uint32_t cl_key_tre_cmrl2r_2_top_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_cmrl2r_2_inner_sc_ind :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_cmrl2r_2_inner_vid :  3 ; /* bits 31:29 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_2_l4_sp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_tre_cmrl3r_2_l4_dp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ev2_pt :  5 ; /* bits 25:21 */
    ca_uint32_t cl_key_tre_cmrl3r_2_tag_num :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_cmrl3r_2_inner_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_cmrl3r_2_top_802_1p :  1 ; /* bits 31:31 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_2_l4_sp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_tre_cmrcmr_2_l4_dp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ev2_pt :  5 ; /* bits 25:21 */
    ca_uint32_t cl_key_tre_cmrcmr_2_tag_num :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_cmrcmr_2_top_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_cmrcmr_2_top_sc_ind :  1 ; /* bits 31:31 */
  } bf10 ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_IGR_KEY_DATA1_t;


#define  SATURN_L2FE_CLE_IGR_KEY_DATA0                   0xd0001b44
#define  SATURN_L2FE_CLE_IGR_KEY_DATA0_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_orhr_ipv4e_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_orhr_ipv4e_mask : 22 ; /* bits 25:4 */
    ca_uint32_t cl_key_orhr_ipv4e_l7_ctrl :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_sp_ctrl :  2 ; /* bits 29:28 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_dp_ctrl :  2 ; /* bits 31:30 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_orhr_ipv6e_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_orhr_ipv6e_mask :  8 ; /* bits 11:4 */
    ca_uint32_t cl_key_orhr_ipv6e_l4_ctrl :  3 ; /* bits 14:12 */
    ca_uint32_t cl_key_orhr_ipv6e_ip_ctrl :  2 ; /* bits 16:15 */
    ca_uint32_t cl_key_orhr_ipv6e_flow_label : 15 ; /* bits 31:17 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l2rl2r_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_l2rl2r_2_mask :  2 ; /* bits 5:4 */
    ca_uint32_t cl_key_tre_l2rl2r_2_l4_ctrl :  3 ; /* bits 8:6 */
    ca_uint32_t cl_key_tre_l2rl2r_2_dot1p_ctrl :  2 ; /* bits 10:9 */
    ca_uint32_t cl_key_tre_l2rl2r_2_vid_ctrl :  2 ; /* bits 12:11 */
    ca_uint32_t cl_key_tre_l2rl2r_2_mac_ctrl :  2 ; /* bits 14:13 */
    ca_uint32_t cl_key_tre_l2rl2r_2_l4_sp : 16 ; /* bits 30:15 */
    ca_uint32_t cl_key_tre_l2rl2r_2_l4_dp :  1 ; /* bits 31:31 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l2rl3r_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_l2rl3r_2_mask :  8 ; /* bits 11:4 */
    ca_uint32_t cl_key_tre_l2rl3r_2_l4_ctrl :  3 ; /* bits 14:12 */
    ca_uint32_t cl_key_tre_l2rl3r_2_dot1p_ctrl :  2 ; /* bits 16:15 */
    ca_uint32_t cl_key_tre_l2rl3r_2_vid_ctrl :  2 ; /* bits 18:17 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ip_ctrl :  2 ; /* bits 20:19 */
    ca_uint32_t cl_key_tre_l2rl3r_2_l4_sp : 11 ; /* bits 31:21 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l2rcmr_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_l2rcmr_2_mask : 12 ; /* bits 15:4 */
    ca_uint32_t cl_key_tre_l2rcmr_2_l4_ctrl :  3 ; /* bits 18:16 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_addr_sel :  1 ; /* bits 19:19 */
    ca_uint32_t cl_key_tre_l2rcmr_2_mac_addr_sel :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l2rcmr_2_l4_sp : 11 ; /* bits 31:21 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l3rl2r_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_l3rl2r_2_mask :  2 ; /* bits 5:4 */
    ca_uint32_t cl_key_tre_l3rl2r_2_l4_ctrl :  3 ; /* bits 8:6 */
    ca_uint32_t cl_key_tre_l3rl2r_2_dot1p_ctrl :  2 ; /* bits 10:9 */
    ca_uint32_t cl_key_tre_l3rl2r_2_vid_ctrl :  2 ; /* bits 12:11 */
    ca_uint32_t cl_key_tre_l3rl2r_2_mac_ctrl :  2 ; /* bits 14:13 */
    ca_uint32_t cl_key_tre_l3rl2r_2_l4_sp : 16 ; /* bits 30:15 */
    ca_uint32_t cl_key_tre_l3rl2r_2_l4_dp :  1 ; /* bits 31:31 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l3rl3r_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_l3rl3r_2_mask :  8 ; /* bits 11:4 */
    ca_uint32_t cl_key_tre_l3rl3r_2_l4_ctrl :  3 ; /* bits 14:12 */
    ca_uint32_t cl_key_tre_l3rl3r_2_dot1p_ctrl :  2 ; /* bits 16:15 */
    ca_uint32_t cl_key_tre_l3rl3r_2_vid_ctrl :  2 ; /* bits 18:17 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ip_ctrl :  2 ; /* bits 20:19 */
    ca_uint32_t cl_key_tre_l3rl3r_2_l4_sp : 11 ; /* bits 31:21 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l3rcmr_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_l3rcmr_2_mask : 12 ; /* bits 15:4 */
    ca_uint32_t cl_key_tre_l3rcmr_2_l4_ctrl :  3 ; /* bits 18:16 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_addr_sel :  1 ; /* bits 19:19 */
    ca_uint32_t cl_key_tre_l3rcmr_2_mac_addr_sel :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l3rcmr_2_l4_sp : 11 ; /* bits 31:21 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_cmrl2r_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_cmrl2r_2_mask :  2 ; /* bits 5:4 */
    ca_uint32_t cl_key_tre_cmrl2r_2_l4_ctrl :  3 ; /* bits 8:6 */
    ca_uint32_t cl_key_tre_cmrl2r_2_dot1p_ctrl :  2 ; /* bits 10:9 */
    ca_uint32_t cl_key_tre_cmrl2r_2_vid_ctrl :  2 ; /* bits 12:11 */
    ca_uint32_t cl_key_tre_cmrl2r_2_mac_ctrl :  2 ; /* bits 14:13 */
    ca_uint32_t cl_key_tre_cmrl2r_2_l4_sp : 16 ; /* bits 30:15 */
    ca_uint32_t cl_key_tre_cmrl2r_2_l4_dp :  1 ; /* bits 31:31 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_cmrl3r_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_cmrl3r_2_mask :  8 ; /* bits 11:4 */
    ca_uint32_t cl_key_tre_cmrl3r_2_l4_ctrl :  3 ; /* bits 14:12 */
    ca_uint32_t cl_key_tre_cmrl3r_2_dot1p_ctrl :  2 ; /* bits 16:15 */
    ca_uint32_t cl_key_tre_cmrl3r_2_vid_ctrl :  2 ; /* bits 18:17 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ip_ctrl :  2 ; /* bits 20:19 */
    ca_uint32_t cl_key_tre_cmrl3r_2_l4_sp : 11 ; /* bits 31:21 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_cmrcmr_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_cmrcmr_2_mask : 12 ; /* bits 15:4 */
    ca_uint32_t cl_key_tre_cmrcmr_2_l4_ctrl :  3 ; /* bits 18:16 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_addr_sel :  1 ; /* bits 19:19 */
    ca_uint32_t cl_key_tre_cmrcmr_2_mac_addr_sel :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_cmrcmr_2_l4_sp : 11 ; /* bits 31:21 */
  } bf10 ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_IGR_KEY_DATA0_t;


#define  SATURN_L2FE_CLE_EGR_KEY_ACCESS                  0xd0001b48
#define  SATURN_L2FE_CLE_EGR_KEY_ACCESS_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_EGR_KEY_ACCESS_t;


#define  SATURN_L2FE_CLE_EGR_KEY_DATA12                  0xd0001b4c
#define  SATURN_L2FE_CLE_EGR_KEY_DATA12_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_entry_type    :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_valid         :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_EGR_KEY_DATA12_t;


#define  SATURN_L2FE_CLE_EGR_KEY_DATA11                  0xd0001b50
#define  SATURN_L2FE_CLE_EGR_KEY_DATA11_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_mac_da :  8 ; /* bits 7:0 */
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_ecn_mask :  1 ; /* bits 8:8 */
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_ecn :  2 ; /* bits 10:9 */
    ca_uint32_t cl_key_orhr_ipv4e_reserved : 19 ; /* bits 29:11 */
    ca_uint32_t cl_key_orhr_ipv6_valid :  1 ; /* bits 30:30 */
    ca_uint32_t cl_key_entry_type    :  1 ; /* bits 31:31 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_da : 27 ; /* bits 26:0 */
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_ecn_mask :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_ecn :  2 ; /* bits 29:28 */
    ca_uint32_t cl_key_tre_rule_hinge :  1 ; /* bits 30:30 */
    ca_uint32_t rsrvd1               :  1 ;
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_1_mac_da : 19 ; /* bits 18:0 */
    ca_uint32_t cl_key_tre_l2rl2r_1_reserved :  7 ; /* bits 25:19 */
    ca_uint32_t cl_key_tre_rule_type_1 :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_rule_type_0 :  2 ; /* bits 29:28 */
    ca_uint32_t rsrvd1               :  2 ;
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_1_mac_da : 19 ; /* bits 18:0 */
    ca_uint32_t cl_key_tre_l2rl3r_1_reserved :  7 ; /* bits 25:19 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_1_mac_da : 19 ; /* bits 18:0 */
    ca_uint32_t cl_key_tre_l2rcmr_1_reserved :  7 ; /* bits 25:19 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_da : 17 ; /* bits 16:0 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ecn_mask :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ecn :  2 ; /* bits 19:18 */
    ca_uint32_t cl_key_tre_l3rl2r_1_reserved :  6 ; /* bits 25:20 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_da : 17 ; /* bits 16:0 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ecn_mask :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ecn :  2 ; /* bits 19:18 */
    ca_uint32_t cl_key_tre_l3rl3r_1_reserved :  6 ; /* bits 25:20 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_da : 17 ; /* bits 16:0 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ecn_mask :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ecn :  2 ; /* bits 19:18 */
    ca_uint32_t cl_key_tre_l3rcmr_1_reserved :  6 ; /* bits 25:20 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_1_mac_addr : 17 ; /* bits 16:0 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ecn_mask :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ecn :  2 ; /* bits 19:18 */
    ca_uint32_t cl_key_tre_cmrl2r_1_reserved :  6 ; /* bits 25:20 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_1_mac_addr : 17 ; /* bits 16:0 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ecn_mask :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ecn :  2 ; /* bits 19:18 */
    ca_uint32_t cl_key_tre_cmrl3r_1_reserved :  6 ; /* bits 25:20 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_1_mac_addr : 17 ; /* bits 16:0 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ecn_mask :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ecn :  2 ; /* bits 19:18 */
    ca_uint32_t cl_key_tre_cmrcmr_1_reserved :  6 ; /* bits 25:20 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf10 ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_EGR_KEY_DATA11_t;


#define  SATURN_L2FE_CLE_EGR_KEY_DATA10                  0xd0001b54
#define  SATURN_L2FE_CLE_EGR_KEY_DATA10_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_mac_da : 32 ; /* bits 31:0 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_da : 32 ; /* bits 31:0 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_1_mac_sa :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l2rl2r_1_mac_da : 29 ; /* bits 31:3 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_1_mac_sa :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l2rl3r_1_mac_da : 29 ; /* bits 31:3 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_1_mac_sa :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l2rcmr_1_mac_da : 29 ; /* bits 31:3 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_sa : 17 ; /* bits 16:0 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_da : 15 ; /* bits 31:17 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_sa : 17 ; /* bits 16:0 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_da : 15 ; /* bits 31:17 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_sa : 17 ; /* bits 16:0 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_da : 15 ; /* bits 31:17 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_addr :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrl2r_1_mac_addr : 31 ; /* bits 31:1 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_addr :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrl3r_1_mac_addr : 31 ; /* bits 31:1 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_addr :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrcmr_1_mac_addr : 31 ; /* bits 31:1 */
  } bf10 ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_EGR_KEY_DATA10_t;


#define  SATURN_L2FE_CLE_EGR_KEY_DATA9                   0xd0001b58
#define  SATURN_L2FE_CLE_EGR_KEY_DATA9_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_mac_sa : 24 ; /* bits 23:0 */
    ca_uint32_t cl_key_orhr_ipv4e_mac_da :  8 ; /* bits 31:24 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_da : 32 ; /* bits 31:0 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_1_mac_sa : 32 ; /* bits 31:0 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_1_mac_sa : 32 ; /* bits 31:0 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_1_mac_sa : 32 ; /* bits 31:0 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_flags :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_fragment :  1 ; /* bits 1:1 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_option :  1 ; /* bits 2:2 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ip_tos :  6 ; /* bits 8:3 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ip_pt :  8 ; /* bits 16:9 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_sa : 15 ; /* bits 31:17 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_flags :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_fragment :  1 ; /* bits 1:1 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_option :  1 ; /* bits 2:2 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ip_tos :  6 ; /* bits 8:3 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ip_pt :  8 ; /* bits 16:9 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_sa : 15 ; /* bits 31:17 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_flags :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_fragment :  1 ; /* bits 1:1 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_option :  1 ; /* bits 2:2 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ip_tos :  6 ; /* bits 8:3 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ip_pt :  8 ; /* bits 16:9 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_sa : 15 ; /* bits 31:17 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_1_ip_pt :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_addr : 31 ; /* bits 31:1 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_1_ip_pt :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_addr : 31 ; /* bits 31:1 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_1_ip_pt :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_addr : 31 ; /* bits 31:1 */
  } bf10 ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_EGR_KEY_DATA9_t;


#define  SATURN_L2FE_CLE_EGR_KEY_DATA8                   0xd0001b5c
#define  SATURN_L2FE_CLE_EGR_KEY_DATA8_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_top_vid :  8 ; /* bits 7:0 */
    ca_uint32_t cl_key_orhr_ipv4e_mac_sa : 24 ; /* bits 31:8 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_da : 32 ; /* bits 31:0 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_1_inner_vid :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_l2rl2r_1_top_sc_ind :  1 ; /* bits 6:6 */
    ca_uint32_t cl_key_tre_l2rl2r_1_top_vid : 12 ; /* bits 18:7 */
    ca_uint32_t cl_key_tre_l2rl2r_1_mac_sa : 13 ; /* bits 31:19 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_1_inner_vid :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_l2rl3r_1_top_sc_ind :  1 ; /* bits 6:6 */
    ca_uint32_t cl_key_tre_l2rl3r_1_top_vid : 12 ; /* bits 18:7 */
    ca_uint32_t cl_key_tre_l2rl3r_1_mac_sa : 13 ; /* bits 31:19 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_1_inner_vid :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_l2rcmr_1_top_sc_ind :  1 ; /* bits 6:6 */
    ca_uint32_t cl_key_tre_l2rcmr_1_top_vid : 12 ; /* bits 18:7 */
    ca_uint32_t cl_key_tre_l2rcmr_1_mac_sa : 13 ; /* bits 31:19 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_1_inner_vid : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_l3rl2r_1_top_sc_ind :  1 ; /* bits 12:12 */
    ca_uint32_t cl_key_tre_l3rl2r_1_top_vid : 12 ; /* bits 24:13 */
    ca_uint32_t cl_key_tre_l3rl2r_1_special_pkt_code :  5 ; /* bits 29:25 */
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_flags :  2 ; /* bits 31:30 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_1_inner_vid : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_l3rl3r_1_top_sc_ind :  1 ; /* bits 12:12 */
    ca_uint32_t cl_key_tre_l3rl3r_1_top_vid : 12 ; /* bits 24:13 */
    ca_uint32_t cl_key_tre_l3rl3r_1_special_pkt_code :  5 ; /* bits 29:25 */
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_flags :  2 ; /* bits 31:30 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_1_inner_vid : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_l3rcmr_1_top_sc_ind :  1 ; /* bits 12:12 */
    ca_uint32_t cl_key_tre_l3rcmr_1_top_vid : 12 ; /* bits 24:13 */
    ca_uint32_t cl_key_tre_l3rcmr_1_special_pkt_code :  5 ; /* bits 29:25 */
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_flags :  2 ; /* bits 31:30 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_1_top_vid :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_tre_cmrl2r_1_special_pkt_code :  5 ; /* bits 13:9 */
    ca_uint32_t cl_key_tre_cmrl2r_1_l4_flags :  3 ; /* bits 16:14 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_fragment :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_option :  1 ; /* bits 18:18 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ip_tos :  6 ; /* bits 24:19 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ip_pt :  7 ; /* bits 31:25 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_1_top_vid :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_tre_cmrl3r_1_special_pkt_code :  5 ; /* bits 13:9 */
    ca_uint32_t cl_key_tre_cmrl3r_1_l4_flags :  3 ; /* bits 16:14 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_fragment :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_option :  1 ; /* bits 18:18 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ip_tos :  6 ; /* bits 24:19 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ip_pt :  7 ; /* bits 31:25 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_1_top_vid :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_tre_cmrcmr_1_special_pkt_code :  5 ; /* bits 13:9 */
    ca_uint32_t cl_key_tre_cmrcmr_1_l4_flags :  3 ; /* bits 16:14 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_fragment :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_option :  1 ; /* bits 18:18 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ip_tos :  6 ; /* bits 24:19 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ip_pt :  7 ; /* bits 31:25 */
  } bf10 ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_EGR_KEY_DATA8_t;


#define  SATURN_L2FE_CLE_EGR_KEY_DATA7                   0xd0001b60
#define  SATURN_L2FE_CLE_EGR_KEY_DATA7_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_da :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_orhr_ipv4e_ev2_pt :  5 ; /* bits 5:1 */
    ca_uint32_t cl_key_orhr_ipv4e_tag_num :  2 ; /* bits 7:6 */
    ca_uint32_t cl_key_orhr_ipv4e_inner_802_1p :  3 ; /* bits 10:8 */
    ca_uint32_t cl_key_orhr_ipv4e_top_802_1p :  3 ; /* bits 13:11 */
    ca_uint32_t cl_key_orhr_ipv4e_inner_sc_ind :  1 ; /* bits 14:14 */
    ca_uint32_t cl_key_orhr_ipv4e_inner_vid : 12 ; /* bits 26:15 */
    ca_uint32_t cl_key_orhr_ipv4e_top_sc_ind :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_orhr_ipv4e_top_vid :  4 ; /* bits 31:28 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa : 27 ; /* bits 26:0 */
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_da :  5 ; /* bits 31:27 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_1_l4_dp : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_l2rl2r_1_ev2_pt :  5 ; /* bits 16:12 */
    ca_uint32_t cl_key_tre_l2rl2r_1_tag_num :  2 ; /* bits 18:17 */
    ca_uint32_t cl_key_tre_l2rl2r_1_inner_802_1p :  3 ; /* bits 21:19 */
    ca_uint32_t cl_key_tre_l2rl2r_1_top_802_1p :  3 ; /* bits 24:22 */
    ca_uint32_t cl_key_tre_l2rl2r_1_inner_sc_ind :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_l2rl2r_1_inner_vid :  6 ; /* bits 31:26 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_1_l4_dp : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_l2rl3r_1_ev2_pt :  5 ; /* bits 16:12 */
    ca_uint32_t cl_key_tre_l2rl3r_1_tag_num :  2 ; /* bits 18:17 */
    ca_uint32_t cl_key_tre_l2rl3r_1_inner_802_1p :  3 ; /* bits 21:19 */
    ca_uint32_t cl_key_tre_l2rl3r_1_top_802_1p :  3 ; /* bits 24:22 */
    ca_uint32_t cl_key_tre_l2rl3r_1_inner_sc_ind :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_l2rl3r_1_inner_vid :  6 ; /* bits 31:26 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_1_l4_dp : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_l2rcmr_1_ev2_pt :  5 ; /* bits 16:12 */
    ca_uint32_t cl_key_tre_l2rcmr_1_tag_num :  2 ; /* bits 18:17 */
    ca_uint32_t cl_key_tre_l2rcmr_1_inner_802_1p :  3 ; /* bits 21:19 */
    ca_uint32_t cl_key_tre_l2rcmr_1_top_802_1p :  3 ; /* bits 24:22 */
    ca_uint32_t cl_key_tre_l2rcmr_1_inner_sc_ind :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_l2rcmr_1_inner_vid :  6 ; /* bits 31:26 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_sp :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_dp : 16 ; /* bits 17:2 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ev2_pt :  5 ; /* bits 22:18 */
    ca_uint32_t cl_key_tre_l3rl2r_1_tag_num :  2 ; /* bits 24:23 */
    ca_uint32_t cl_key_tre_l3rl2r_1_inner_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_l3rl2r_1_top_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_l3rl2r_1_inner_sc_ind :  1 ; /* bits 31:31 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_sp :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_dp : 16 ; /* bits 17:2 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ev2_pt :  5 ; /* bits 22:18 */
    ca_uint32_t cl_key_tre_l3rl3r_1_tag_num :  2 ; /* bits 24:23 */
    ca_uint32_t cl_key_tre_l3rl3r_1_inner_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_l3rl3r_1_top_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_l3rl3r_1_inner_sc_ind :  1 ; /* bits 31:31 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_sp :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_dp : 16 ; /* bits 17:2 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ev2_pt :  5 ; /* bits 22:18 */
    ca_uint32_t cl_key_tre_l3rcmr_1_tag_num :  2 ; /* bits 24:23 */
    ca_uint32_t cl_key_tre_l3rcmr_1_inner_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_l3rcmr_1_top_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_l3rcmr_1_inner_sc_ind :  1 ; /* bits 31:31 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_1_l4_sp :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_cmrl2r_1_l4_dp : 16 ; /* bits 17:2 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ev2_pt :  5 ; /* bits 22:18 */
    ca_uint32_t cl_key_tre_cmrl2r_1_tag_num :  2 ; /* bits 24:23 */
    ca_uint32_t cl_key_tre_cmrl2r_1_top_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_cmrl2r_1_top_sc_ind :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_cmrl2r_1_top_vid :  3 ; /* bits 31:29 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_1_l4_sp :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_cmrl3r_1_l4_dp : 16 ; /* bits 17:2 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ev2_pt :  5 ; /* bits 22:18 */
    ca_uint32_t cl_key_tre_cmrl3r_1_tag_num :  2 ; /* bits 24:23 */
    ca_uint32_t cl_key_tre_cmrl3r_1_top_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_cmrl3r_1_top_sc_ind :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_cmrl3r_1_top_vid :  3 ; /* bits 31:29 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_1_l4_sp :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_cmrcmr_1_l4_dp : 16 ; /* bits 17:2 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ev2_pt :  5 ; /* bits 22:18 */
    ca_uint32_t cl_key_tre_cmrcmr_1_tag_num :  2 ; /* bits 24:23 */
    ca_uint32_t cl_key_tre_cmrcmr_1_top_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_cmrcmr_1_top_sc_ind :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_cmrcmr_1_top_vid :  3 ; /* bits 31:29 */
  } bf10 ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_EGR_KEY_DATA7_t;


#define  SATURN_L2FE_CLE_EGR_KEY_DATA6                   0xd0001b64
#define  SATURN_L2FE_CLE_EGR_KEY_DATA6_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_sa :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_da : 31 ; /* bits 31:1 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa : 32 ; /* bits 31:0 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_1_fields_operator :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l2rl2r_1_mask :  2 ; /* bits 2:1 */
    ca_uint32_t cl_key_tre_l2rl2r_1_l4_ctrl :  3 ; /* bits 5:3 */
    ca_uint32_t cl_key_tre_l2rl2r_1_dot1p_ctrl :  2 ; /* bits 7:6 */
    ca_uint32_t cl_key_tre_l2rl2r_1_vid_ctrl :  2 ; /* bits 9:8 */
    ca_uint32_t cl_key_tre_l2rl2r_1_mac_ctrl :  2 ; /* bits 11:10 */
    ca_uint32_t cl_key_tre_l2rl2r_1_l4_sp : 16 ; /* bits 27:12 */
    ca_uint32_t cl_key_tre_l2rl2r_1_l4_dp :  4 ; /* bits 31:28 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_1_fields_operator :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l2rl3r_1_mask :  2 ; /* bits 2:1 */
    ca_uint32_t cl_key_tre_l2rl3r_1_l4_ctrl :  3 ; /* bits 5:3 */
    ca_uint32_t cl_key_tre_l2rl3r_1_dot1p_ctrl :  2 ; /* bits 7:6 */
    ca_uint32_t cl_key_tre_l2rl3r_1_vid_ctrl :  2 ; /* bits 9:8 */
    ca_uint32_t cl_key_tre_l2rl3r_1_mac_ctrl :  2 ; /* bits 11:10 */
    ca_uint32_t cl_key_tre_l2rl3r_1_l4_sp : 16 ; /* bits 27:12 */
    ca_uint32_t cl_key_tre_l2rl3r_1_l4_dp :  4 ; /* bits 31:28 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_1_fields_operator :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l2rcmr_1_mask :  2 ; /* bits 2:1 */
    ca_uint32_t cl_key_tre_l2rcmr_1_l4_ctrl :  3 ; /* bits 5:3 */
    ca_uint32_t cl_key_tre_l2rcmr_1_dot1p_ctrl :  2 ; /* bits 7:6 */
    ca_uint32_t cl_key_tre_l2rcmr_1_vid_ctrl :  2 ; /* bits 9:8 */
    ca_uint32_t cl_key_tre_l2rcmr_1_mac_ctrl :  2 ; /* bits 11:10 */
    ca_uint32_t cl_key_tre_l2rcmr_1_l4_sp : 16 ; /* bits 27:12 */
    ca_uint32_t cl_key_tre_l2rcmr_1_l4_dp :  4 ; /* bits 31:28 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_1_fields_operator :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l3rl2r_1_mask :  8 ; /* bits 8:1 */
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_ctrl :  3 ; /* bits 11:9 */
    ca_uint32_t cl_key_tre_l3rl2r_1_dot1p_ctrl :  2 ; /* bits 13:12 */
    ca_uint32_t cl_key_tre_l3rl2r_1_vid_ctrl :  2 ; /* bits 15:14 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ip_ctrl :  2 ; /* bits 17:16 */
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_sp : 14 ; /* bits 31:18 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_1_fields_operator :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l3rl3r_1_mask :  8 ; /* bits 8:1 */
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_ctrl :  3 ; /* bits 11:9 */
    ca_uint32_t cl_key_tre_l3rl3r_1_dot1p_ctrl :  2 ; /* bits 13:12 */
    ca_uint32_t cl_key_tre_l3rl3r_1_vid_ctrl :  2 ; /* bits 15:14 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ip_ctrl :  2 ; /* bits 17:16 */
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_sp : 14 ; /* bits 31:18 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_1_fields_operator :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l3rcmr_1_mask :  8 ; /* bits 8:1 */
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_ctrl :  3 ; /* bits 11:9 */
    ca_uint32_t cl_key_tre_l3rcmr_1_dot1p_ctrl :  2 ; /* bits 13:12 */
    ca_uint32_t cl_key_tre_l3rcmr_1_vid_ctrl :  2 ; /* bits 15:14 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ip_ctrl :  2 ; /* bits 17:16 */
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_sp : 14 ; /* bits 31:18 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_1_fields_operator :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrl2r_1_mask : 12 ; /* bits 12:1 */
    ca_uint32_t cl_key_tre_cmrl2r_1_l4_ctrl :  3 ; /* bits 15:13 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_addr_sel :  1 ; /* bits 16:16 */
    ca_uint32_t cl_key_tre_cmrl2r_1_mac_addr_sel :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_cmrl2r_1_l4_sp : 14 ; /* bits 31:18 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_1_fields_operator :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrl3r_1_mask : 12 ; /* bits 12:1 */
    ca_uint32_t cl_key_tre_cmrl3r_1_l4_ctrl :  3 ; /* bits 15:13 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_addr_sel :  1 ; /* bits 16:16 */
    ca_uint32_t cl_key_tre_cmrl3r_1_mac_addr_sel :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_cmrl3r_1_l4_sp : 14 ; /* bits 31:18 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_1_fields_operator :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrcmr_1_mask : 12 ; /* bits 12:1 */
    ca_uint32_t cl_key_tre_cmrcmr_1_l4_ctrl :  3 ; /* bits 15:13 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_addr_sel :  1 ; /* bits 16:16 */
    ca_uint32_t cl_key_tre_cmrcmr_1_mac_addr_sel :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_cmrcmr_1_l4_sp : 14 ; /* bits 31:18 */
  } bf10 ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_EGR_KEY_DATA6_t;


#define  SATURN_L2FE_CLE_EGR_KEY_DATA5                   0xd0001b68
#define  SATURN_L2FE_CLE_EGR_KEY_DATA5_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_ip_pt :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_sa : 31 ; /* bits 31:1 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa : 32 ; /* bits 31:0 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_2_mac_da : 22 ; /* bits 21:0 */
    ca_uint32_t cl_key_tre_l2rl2r_2_reserved :  7 ; /* bits 28:22 */
    ca_uint32_t cl_key_tre_l2rl2r_1_prcd :  3 ; /* bits 31:29 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_da : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ecn_mask :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ecn :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_l2rl3r_2_reserved :  6 ; /* bits 28:23 */
    ca_uint32_t cl_key_tre_l2rl3r_1_prcd :  3 ; /* bits 31:29 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_2_mac_addr : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ecn_mask :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ecn :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_l2rcmr_2_reserved :  6 ; /* bits 28:23 */
    ca_uint32_t cl_key_tre_l2rcmr_1_prcd :  3 ; /* bits 31:29 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_2_mac_da : 22 ; /* bits 21:0 */
    ca_uint32_t cl_key_tre_l3rl2r_2_reserved :  7 ; /* bits 28:22 */
    ca_uint32_t cl_key_tre_l3rl2r_1_prcd :  3 ; /* bits 31:29 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_da : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ecn_mask :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ecn :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_l3rl3r_2_reserved :  6 ; /* bits 28:23 */
    ca_uint32_t cl_key_tre_l3rl3r_1_prcd :  3 ; /* bits 31:29 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_2_mac_addr : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ecn_mask :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ecn :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_l3rcmr_2_reserved :  6 ; /* bits 28:23 */
    ca_uint32_t cl_key_tre_l3rcmr_1_prcd :  3 ; /* bits 31:29 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_2_mac_da : 22 ; /* bits 21:0 */
    ca_uint32_t cl_key_tre_cmrl2r_2_reserved :  7 ; /* bits 28:22 */
    ca_uint32_t cl_key_tre_cmrl2r_1_prcd :  3 ; /* bits 31:29 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_da : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ecn_mask :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ecn :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_cmrl3r_2_reserved :  6 ; /* bits 28:23 */
    ca_uint32_t cl_key_tre_cmrl3r_1_prcd :  3 ; /* bits 31:29 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_2_mac_addr : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ecn_mask :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ecn :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_cmrcmr_2_reserved :  6 ; /* bits 28:23 */
    ca_uint32_t cl_key_tre_cmrcmr_1_prcd :  3 ; /* bits 31:29 */
  } bf10 ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_EGR_KEY_DATA5_t;


#define  SATURN_L2FE_CLE_EGR_KEY_DATA4                   0xd0001b6c
#define  SATURN_L2FE_CLE_EGR_KEY_DATA4_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_l4_dp_low :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_dp_high : 16 ; /* bits 16:1 */
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_fragment :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_option :  1 ; /* bits 18:18 */
    ca_uint32_t cl_key_orhr_ipv4e_ip_tos :  6 ; /* bits 24:19 */
    ca_uint32_t cl_key_orhr_ipv4e_ip_pt :  7 ; /* bits 31:25 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa : 32 ; /* bits 31:0 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_2_mac_sa :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_l2rl2r_2_mac_da : 26 ; /* bits 31:6 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_sa : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_da : 12 ; /* bits 31:20 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_addr :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_l2rcmr_2_mac_addr : 28 ; /* bits 31:4 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_2_mac_sa :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_l3rl2r_2_mac_da : 26 ; /* bits 31:6 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_sa : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_da : 12 ; /* bits 31:20 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_addr :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_l3rcmr_2_mac_addr : 28 ; /* bits 31:4 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_2_mac_sa :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_cmrl2r_2_mac_da : 26 ; /* bits 31:6 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_sa : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_da : 12 ; /* bits 31:20 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_addr :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_cmrcmr_2_mac_addr : 28 ; /* bits 31:4 */
  } bf10 ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_EGR_KEY_DATA4_t;


#define  SATURN_L2FE_CLE_EGR_KEY_DATA3                   0xd0001b70
#define  SATURN_L2FE_CLE_EGR_KEY_DATA3_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_l4_sp_low :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_sp_high : 16 ; /* bits 16:1 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_dp_low : 15 ; /* bits 31:17 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ip_tos :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_orhr_ipv6e_ip_pt :  8 ; /* bits 12:5 */
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_mask : 14 ; /* bits 26:13 */
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa :  5 ; /* bits 31:27 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_2_mac_sa : 32 ; /* bits 31:0 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_2_special_pkt_code :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l2rl3r_2_l4_flags :  3 ; /* bits 3:1 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_fragment :  1 ; /* bits 4:4 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_option :  1 ; /* bits 5:5 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ip_tos :  6 ; /* bits 11:6 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ip_pt :  8 ; /* bits 19:12 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_sa : 12 ; /* bits 31:20 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_2_ip_pt :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_addr : 28 ; /* bits 31:4 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_2_mac_sa : 32 ; /* bits 31:0 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_2_special_pkt_code :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l3rl3r_2_l4_flags :  3 ; /* bits 3:1 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_fragment :  1 ; /* bits 4:4 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_option :  1 ; /* bits 5:5 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ip_tos :  6 ; /* bits 11:6 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ip_pt :  8 ; /* bits 19:12 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_sa : 12 ; /* bits 31:20 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_2_ip_pt :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_addr : 28 ; /* bits 31:4 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_2_mac_sa : 32 ; /* bits 31:0 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_2_special_pkt_code :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrl3r_2_l4_flags :  3 ; /* bits 3:1 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_fragment :  1 ; /* bits 4:4 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_option :  1 ; /* bits 5:5 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ip_tos :  6 ; /* bits 11:6 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ip_pt :  8 ; /* bits 19:12 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_sa : 12 ; /* bits 31:20 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_2_ip_pt :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_addr : 28 ; /* bits 31:4 */
  } bf10 ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_EGR_KEY_DATA3_t;


#define  SATURN_L2FE_CLE_EGR_KEY_DATA2                   0xd0001b74
#define  SATURN_L2FE_CLE_EGR_KEY_DATA2_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_global_key :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_orhr_ipv4e_special_pkt_code :  5 ; /* bits 13:9 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_flags :  3 ; /* bits 16:14 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_sp_low : 15 ; /* bits 31:17 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_l4_dp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_orhr_ipv6e_tag_num :  2 ; /* bits 6:5 */
    ca_uint32_t cl_key_orhr_ipv6e_top_802_1p :  3 ; /* bits 9:7 */
    ca_uint32_t cl_key_orhr_ipv6e_top_sc_ind :  1 ; /* bits 10:10 */
    ca_uint32_t cl_key_orhr_ipv6e_top_vid : 12 ; /* bits 22:11 */
    ca_uint32_t cl_key_orhr_ipv6e_special_pkt_code :  5 ; /* bits 27:23 */
    ca_uint32_t cl_key_orhr_ipv6e_l4_flags :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_orhr_ipv6e_ip_tos :  1 ; /* bits 31:31 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_2_inner_vid :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_tre_l2rl2r_2_top_sc_ind :  1 ; /* bits 9:9 */
    ca_uint32_t cl_key_tre_l2rl2r_2_top_vid : 12 ; /* bits 21:10 */
    ca_uint32_t cl_key_tre_l2rl2r_2_mac_sa : 10 ; /* bits 31:22 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_2_top_802_1p :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l2rl3r_2_inner_sc_ind :  1 ; /* bits 2:2 */
    ca_uint32_t cl_key_tre_l2rl3r_2_inner_vid : 12 ; /* bits 14:3 */
    ca_uint32_t cl_key_tre_l2rl3r_2_top_sc_ind :  1 ; /* bits 15:15 */
    ca_uint32_t cl_key_tre_l2rl3r_2_top_vid : 12 ; /* bits 27:16 */
    ca_uint32_t cl_key_tre_l2rl3r_2_special_pkt_code :  4 ; /* bits 31:28 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_2_top_vid : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_l2rcmr_2_special_pkt_code :  5 ; /* bits 16:12 */
    ca_uint32_t cl_key_tre_l2rcmr_2_l4_flags :  3 ; /* bits 19:17 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_fragment :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_option :  1 ; /* bits 21:21 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ip_tos :  6 ; /* bits 27:22 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ip_pt :  4 ; /* bits 31:28 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_2_inner_vid :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_tre_l3rl2r_2_top_sc_ind :  1 ; /* bits 9:9 */
    ca_uint32_t cl_key_tre_l3rl2r_2_top_vid : 12 ; /* bits 21:10 */
    ca_uint32_t cl_key_tre_l3rl2r_2_mac_sa : 10 ; /* bits 31:22 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_2_top_802_1p :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l3rl3r_2_inner_sc_ind :  1 ; /* bits 2:2 */
    ca_uint32_t cl_key_tre_l3rl3r_2_inner_vid : 12 ; /* bits 14:3 */
    ca_uint32_t cl_key_tre_l3rl3r_2_top_sc_ind :  1 ; /* bits 15:15 */
    ca_uint32_t cl_key_tre_l3rl3r_2_top_vid : 12 ; /* bits 27:16 */
    ca_uint32_t cl_key_tre_l3rl3r_2_special_pkt_code :  4 ; /* bits 31:28 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_2_top_vid : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_l3rcmr_2_special_pkt_code :  5 ; /* bits 16:12 */
    ca_uint32_t cl_key_tre_l3rcmr_2_l4_flags :  3 ; /* bits 19:17 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_fragment :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_option :  1 ; /* bits 21:21 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ip_tos :  6 ; /* bits 27:22 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ip_pt :  4 ; /* bits 31:28 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_2_inner_vid :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_tre_cmrl2r_2_top_sc_ind :  1 ; /* bits 9:9 */
    ca_uint32_t cl_key_tre_cmrl2r_2_top_vid : 12 ; /* bits 21:10 */
    ca_uint32_t cl_key_tre_cmrl2r_2_mac_sa : 10 ; /* bits 31:22 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_2_top_802_1p :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_cmrl3r_2_inner_sc_ind :  1 ; /* bits 2:2 */
    ca_uint32_t cl_key_tre_cmrl3r_2_inner_vid : 12 ; /* bits 14:3 */
    ca_uint32_t cl_key_tre_cmrl3r_2_top_sc_ind :  1 ; /* bits 15:15 */
    ca_uint32_t cl_key_tre_cmrl3r_2_top_vid : 12 ; /* bits 27:16 */
    ca_uint32_t cl_key_tre_cmrl3r_2_special_pkt_code :  4 ; /* bits 31:28 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_2_top_vid : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_cmrcmr_2_special_pkt_code :  5 ; /* bits 16:12 */
    ca_uint32_t cl_key_tre_cmrcmr_2_l4_flags :  3 ; /* bits 19:17 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_fragment :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_option :  1 ; /* bits 21:21 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ip_tos :  6 ; /* bits 27:22 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ip_pt :  4 ; /* bits 31:28 */
  } bf10 ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_EGR_KEY_DATA2_t;


#define  SATURN_L2FE_CLE_EGR_KEY_DATA1                   0xd0001b78
#define  SATURN_L2FE_CLE_EGR_KEY_DATA1_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_ip_ctrl :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_orhr_ipv4e_dot1p_ctrl :  2 ; /* bits 4:3 */
    ca_uint32_t cl_key_orhr_ipv4e_vid_ctrl :  2 ; /* bits 6:5 */
    ca_uint32_t cl_key_orhr_ipv4e_mac_ctrl :  2 ; /* bits 8:7 */
    ca_uint32_t cl_key_orhr_ipv4e_global_key : 23 ; /* bits 31:9 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_flow_label :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_orhr_ipv6e_l4_sp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_orhr_ipv6e_l4_dp : 11 ; /* bits 31:21 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_2_l4_dp : 15 ; /* bits 14:0 */
    ca_uint32_t cl_key_tre_l2rl2r_2_ev2_pt :  5 ; /* bits 19:15 */
    ca_uint32_t cl_key_tre_l2rl2r_2_tag_num :  2 ; /* bits 21:20 */
    ca_uint32_t cl_key_tre_l2rl2r_2_inner_802_1p :  3 ; /* bits 24:22 */
    ca_uint32_t cl_key_tre_l2rl2r_2_top_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_l2rl2r_2_inner_sc_ind :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_l2rl2r_2_inner_vid :  3 ; /* bits 31:29 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_2_l4_sp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_tre_l2rl3r_2_l4_dp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ev2_pt :  5 ; /* bits 25:21 */
    ca_uint32_t cl_key_tre_l2rl3r_2_tag_num :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_l2rl3r_2_inner_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_l2rl3r_2_top_802_1p :  1 ; /* bits 31:31 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_2_l4_sp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_tre_l2rcmr_2_l4_dp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ev2_pt :  5 ; /* bits 25:21 */
    ca_uint32_t cl_key_tre_l2rcmr_2_tag_num :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_l2rcmr_2_top_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_l2rcmr_2_top_sc_ind :  1 ; /* bits 31:31 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_2_l4_dp : 15 ; /* bits 14:0 */
    ca_uint32_t cl_key_tre_l3rl2r_2_ev2_pt :  5 ; /* bits 19:15 */
    ca_uint32_t cl_key_tre_l3rl2r_2_tag_num :  2 ; /* bits 21:20 */
    ca_uint32_t cl_key_tre_l3rl2r_2_inner_802_1p :  3 ; /* bits 24:22 */
    ca_uint32_t cl_key_tre_l3rl2r_2_top_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_l3rl2r_2_inner_sc_ind :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_l3rl2r_2_inner_vid :  3 ; /* bits 31:29 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_2_l4_sp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_tre_l3rl3r_2_l4_dp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ev2_pt :  5 ; /* bits 25:21 */
    ca_uint32_t cl_key_tre_l3rl3r_2_tag_num :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_l3rl3r_2_inner_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_l3rl3r_2_top_802_1p :  1 ; /* bits 31:31 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_2_l4_sp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_tre_l3rcmr_2_l4_dp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ev2_pt :  5 ; /* bits 25:21 */
    ca_uint32_t cl_key_tre_l3rcmr_2_tag_num :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_l3rcmr_2_top_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_l3rcmr_2_top_sc_ind :  1 ; /* bits 31:31 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_2_l4_dp : 15 ; /* bits 14:0 */
    ca_uint32_t cl_key_tre_cmrl2r_2_ev2_pt :  5 ; /* bits 19:15 */
    ca_uint32_t cl_key_tre_cmrl2r_2_tag_num :  2 ; /* bits 21:20 */
    ca_uint32_t cl_key_tre_cmrl2r_2_inner_802_1p :  3 ; /* bits 24:22 */
    ca_uint32_t cl_key_tre_cmrl2r_2_top_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_cmrl2r_2_inner_sc_ind :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_cmrl2r_2_inner_vid :  3 ; /* bits 31:29 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_2_l4_sp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_tre_cmrl3r_2_l4_dp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ev2_pt :  5 ; /* bits 25:21 */
    ca_uint32_t cl_key_tre_cmrl3r_2_tag_num :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_cmrl3r_2_inner_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_cmrl3r_2_top_802_1p :  1 ; /* bits 31:31 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_2_l4_sp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_tre_cmrcmr_2_l4_dp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ev2_pt :  5 ; /* bits 25:21 */
    ca_uint32_t cl_key_tre_cmrcmr_2_tag_num :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_cmrcmr_2_top_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_cmrcmr_2_top_sc_ind :  1 ; /* bits 31:31 */
  } bf10 ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_EGR_KEY_DATA1_t;


#define  SATURN_L2FE_CLE_EGR_KEY_DATA0                   0xd0001b7c
#define  SATURN_L2FE_CLE_EGR_KEY_DATA0_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_orhr_ipv4e_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_orhr_ipv4e_mask : 22 ; /* bits 25:4 */
    ca_uint32_t cl_key_orhr_ipv4e_l7_ctrl :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_sp_ctrl :  2 ; /* bits 29:28 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_dp_ctrl :  2 ; /* bits 31:30 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_orhr_ipv6e_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_orhr_ipv6e_mask :  8 ; /* bits 11:4 */
    ca_uint32_t cl_key_orhr_ipv6e_l4_ctrl :  3 ; /* bits 14:12 */
    ca_uint32_t cl_key_orhr_ipv6e_ip_ctrl :  2 ; /* bits 16:15 */
    ca_uint32_t cl_key_orhr_ipv6e_flow_label : 15 ; /* bits 31:17 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l2rl2r_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_l2rl2r_2_mask :  2 ; /* bits 5:4 */
    ca_uint32_t cl_key_tre_l2rl2r_2_l4_ctrl :  3 ; /* bits 8:6 */
    ca_uint32_t cl_key_tre_l2rl2r_2_dot1p_ctrl :  2 ; /* bits 10:9 */
    ca_uint32_t cl_key_tre_l2rl2r_2_vid_ctrl :  2 ; /* bits 12:11 */
    ca_uint32_t cl_key_tre_l2rl2r_2_mac_ctrl :  2 ; /* bits 14:13 */
    ca_uint32_t cl_key_tre_l2rl2r_2_l4_sp : 16 ; /* bits 30:15 */
    ca_uint32_t cl_key_tre_l2rl2r_2_l4_dp :  1 ; /* bits 31:31 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l2rl3r_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_l2rl3r_2_mask :  8 ; /* bits 11:4 */
    ca_uint32_t cl_key_tre_l2rl3r_2_l4_ctrl :  3 ; /* bits 14:12 */
    ca_uint32_t cl_key_tre_l2rl3r_2_dot1p_ctrl :  2 ; /* bits 16:15 */
    ca_uint32_t cl_key_tre_l2rl3r_2_vid_ctrl :  2 ; /* bits 18:17 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ip_ctrl :  2 ; /* bits 20:19 */
    ca_uint32_t cl_key_tre_l2rl3r_2_l4_sp : 11 ; /* bits 31:21 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l2rcmr_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_l2rcmr_2_mask : 12 ; /* bits 15:4 */
    ca_uint32_t cl_key_tre_l2rcmr_2_l4_ctrl :  3 ; /* bits 18:16 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_addr_sel :  1 ; /* bits 19:19 */
    ca_uint32_t cl_key_tre_l2rcmr_2_mac_addr_sel :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l2rcmr_2_l4_sp : 11 ; /* bits 31:21 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l3rl2r_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_l3rl2r_2_mask :  2 ; /* bits 5:4 */
    ca_uint32_t cl_key_tre_l3rl2r_2_l4_ctrl :  3 ; /* bits 8:6 */
    ca_uint32_t cl_key_tre_l3rl2r_2_dot1p_ctrl :  2 ; /* bits 10:9 */
    ca_uint32_t cl_key_tre_l3rl2r_2_vid_ctrl :  2 ; /* bits 12:11 */
    ca_uint32_t cl_key_tre_l3rl2r_2_mac_ctrl :  2 ; /* bits 14:13 */
    ca_uint32_t cl_key_tre_l3rl2r_2_l4_sp : 16 ; /* bits 30:15 */
    ca_uint32_t cl_key_tre_l3rl2r_2_l4_dp :  1 ; /* bits 31:31 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l3rl3r_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_l3rl3r_2_mask :  8 ; /* bits 11:4 */
    ca_uint32_t cl_key_tre_l3rl3r_2_l4_ctrl :  3 ; /* bits 14:12 */
    ca_uint32_t cl_key_tre_l3rl3r_2_dot1p_ctrl :  2 ; /* bits 16:15 */
    ca_uint32_t cl_key_tre_l3rl3r_2_vid_ctrl :  2 ; /* bits 18:17 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ip_ctrl :  2 ; /* bits 20:19 */
    ca_uint32_t cl_key_tre_l3rl3r_2_l4_sp : 11 ; /* bits 31:21 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l3rcmr_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_l3rcmr_2_mask : 12 ; /* bits 15:4 */
    ca_uint32_t cl_key_tre_l3rcmr_2_l4_ctrl :  3 ; /* bits 18:16 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_addr_sel :  1 ; /* bits 19:19 */
    ca_uint32_t cl_key_tre_l3rcmr_2_mac_addr_sel :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l3rcmr_2_l4_sp : 11 ; /* bits 31:21 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_cmrl2r_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_cmrl2r_2_mask :  2 ; /* bits 5:4 */
    ca_uint32_t cl_key_tre_cmrl2r_2_l4_ctrl :  3 ; /* bits 8:6 */
    ca_uint32_t cl_key_tre_cmrl2r_2_dot1p_ctrl :  2 ; /* bits 10:9 */
    ca_uint32_t cl_key_tre_cmrl2r_2_vid_ctrl :  2 ; /* bits 12:11 */
    ca_uint32_t cl_key_tre_cmrl2r_2_mac_ctrl :  2 ; /* bits 14:13 */
    ca_uint32_t cl_key_tre_cmrl2r_2_l4_sp : 16 ; /* bits 30:15 */
    ca_uint32_t cl_key_tre_cmrl2r_2_l4_dp :  1 ; /* bits 31:31 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_cmrl3r_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_cmrl3r_2_mask :  8 ; /* bits 11:4 */
    ca_uint32_t cl_key_tre_cmrl3r_2_l4_ctrl :  3 ; /* bits 14:12 */
    ca_uint32_t cl_key_tre_cmrl3r_2_dot1p_ctrl :  2 ; /* bits 16:15 */
    ca_uint32_t cl_key_tre_cmrl3r_2_vid_ctrl :  2 ; /* bits 18:17 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ip_ctrl :  2 ; /* bits 20:19 */
    ca_uint32_t cl_key_tre_cmrl3r_2_l4_sp : 11 ; /* bits 31:21 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_cmrcmr_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_cmrcmr_2_mask : 12 ; /* bits 15:4 */
    ca_uint32_t cl_key_tre_cmrcmr_2_l4_ctrl :  3 ; /* bits 18:16 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_addr_sel :  1 ; /* bits 19:19 */
    ca_uint32_t cl_key_tre_cmrcmr_2_mac_addr_sel :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_cmrcmr_2_l4_sp : 11 ; /* bits 31:21 */
  } bf10 ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_EGR_KEY_DATA0_t;


#define  SATURN_L2FE_CLE_IGR_FIB_ACCESS                  0xd0001b80
#define  SATURN_L2FE_CLE_IGR_FIB_ACCESS_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_IGR_FIB_ACCESS_t;


#define  SATURN_L2FE_CLE_IGR_FIB_DATA4                   0xd0001b84
#define  SATURN_L2FE_CLE_IGR_FIB_DATA4_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_fib_xr_inner_vid_0 :  3 ; /* bits 2:0 */
    ca_uint32_t cl_fib_xr_top_cmd_valid_0 :  1 ; /* bits 3:3 */
    ca_uint32_t cl_fib_xr_top_vlan_cmd_0 :  2 ; /* bits 5:4 */
    ca_uint32_t cl_fib_xr_top_sc_ind_0 :  1 ; /* bits 6:6 */
    ca_uint32_t cl_fib_xr_top_vid_0  : 12 ; /* bits 18:7 */
    ca_uint32_t cl_fib_xr_pkt_no_drop_0 :  1 ; /* bits 19:19 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_IGR_FIB_DATA4_t;


#define  SATURN_L2FE_CLE_IGR_FIB_DATA3                   0xd0001b88
#define  SATURN_L2FE_CLE_IGR_FIB_DATA3_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_fib_xr_ldpid_0    :  4 ; /* bits 3:0 */
    ca_uint32_t cl_fib_xr_cos_valid_0 :  1 ; /* bits 4:4 */
    ca_uint32_t cl_fib_xr_dscp_valid_0 :  1 ; /* bits 5:5 */
    ca_uint32_t cl_fib_xr_802_1p_valid_0 :  1 ; /* bits 6:6 */
    ca_uint32_t cl_fib_xr_cos_0      :  3 ; /* bits 9:7 */
    ca_uint32_t cl_fib_xr_dscp_0     :  6 ; /* bits 15:10 */
    ca_uint32_t cl_fib_xr_802_1p_0   :  3 ; /* bits 18:16 */
    ca_uint32_t cl_fib_xr_inner_cmd_valid_0 :  1 ; /* bits 19:19 */
    ca_uint32_t cl_fib_xr_inner_vlan_cmd_0 :  2 ; /* bits 21:20 */
    ca_uint32_t cl_fib_xr_inner_sc_ind_0 :  1 ; /* bits 22:22 */
    ca_uint32_t cl_fib_xr_inner_vid_0 :  9 ; /* bits 31:23 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_IGR_FIB_DATA3_t;


#define  SATURN_L2FE_CLE_IGR_FIB_DATA2                   0xd0001b8c
#define  SATURN_L2FE_CLE_IGR_FIB_DATA2_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_fib_xr_top_vid_1  :  9 ; /* bits 8:0 */
    ca_uint32_t cl_fib_xr_pkt_no_drop_1 :  1 ; /* bits 9:9 */
    ca_uint32_t cl_fib_xr_stp_mode_0 :  2 ; /* bits 11:10 */
    ca_uint32_t cl_fib_xr_permit_valid_0 :  1 ; /* bits 12:12 */
    ca_uint32_t cl_fib_xr_permit_0   :  1 ; /* bits 13:13 */
    ca_uint32_t cl_fib_xr_premarked_0 :  1 ; /* bits 14:14 */
    ca_uint32_t cl_fib_xr_dscp_markdown_0 :  1 ; /* bits 15:15 */
    ca_uint32_t cl_fib_xr_mark_en_0  :  1 ; /* bits 16:16 */
    ca_uint32_t cl_fib_xr_flowid_0   : 12 ; /* bits 28:17 */
    ca_uint32_t cl_fib_xr_dp_valid_0 :  1 ; /* bits 29:29 */
    ca_uint32_t cl_fib_xr_ldpid_0    :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_IGR_FIB_DATA2_t;


#define  SATURN_L2FE_CLE_IGR_FIB_DATA1                   0xd0001b90
#define  SATURN_L2FE_CLE_IGR_FIB_DATA1_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_fib_xr_dscp_1     :  6 ; /* bits 5:0 */
    ca_uint32_t cl_fib_xr_802_1p_1   :  3 ; /* bits 8:6 */
    ca_uint32_t cl_fib_xr_inner_cmd_valid_1 :  1 ; /* bits 9:9 */
    ca_uint32_t cl_fib_xr_inner_vlan_cmd_1 :  2 ; /* bits 11:10 */
    ca_uint32_t cl_fib_xr_inner_sc_ind_1 :  1 ; /* bits 12:12 */
    ca_uint32_t cl_fib_xr_inner_vid_1 : 12 ; /* bits 24:13 */
    ca_uint32_t cl_fib_xr_top_cmd_valid_1 :  1 ; /* bits 25:25 */
    ca_uint32_t cl_fib_xr_top_vlan_cmd_1 :  2 ; /* bits 27:26 */
    ca_uint32_t cl_fib_xr_top_sc_ind_1 :  1 ; /* bits 28:28 */
    ca_uint32_t cl_fib_xr_top_vid_1  :  3 ; /* bits 31:29 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_IGR_FIB_DATA1_t;


#define  SATURN_L2FE_CLE_IGR_FIB_DATA0                   0xd0001b94
#define  SATURN_L2FE_CLE_IGR_FIB_DATA0_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_fib_xr_stp_mode_1 :  2 ; /* bits 1:0 */
    ca_uint32_t cl_fib_xr_permit_valid_1 :  1 ; /* bits 2:2 */
    ca_uint32_t cl_fib_xr_permit_1   :  1 ; /* bits 3:3 */
    ca_uint32_t cl_fib_xr_premarked_1 :  1 ; /* bits 4:4 */
    ca_uint32_t cl_fib_xr_dscp_markdown_1 :  1 ; /* bits 5:5 */
    ca_uint32_t cl_fib_xr_mark_en_1  :  1 ; /* bits 6:6 */
    ca_uint32_t cl_fib_xr_flowid_1   : 12 ; /* bits 18:7 */
    ca_uint32_t cl_fib_xr_dp_valid_1 :  1 ; /* bits 19:19 */
    ca_uint32_t cl_fib_xr_ldpid_1    :  6 ; /* bits 25:20 */
    ca_uint32_t cl_fib_xr_cos_valid_1 :  1 ; /* bits 26:26 */
    ca_uint32_t cl_fib_xr_dscp_valid_1 :  1 ; /* bits 27:27 */
    ca_uint32_t cl_fib_xr_802_1p_valid_1 :  1 ; /* bits 28:28 */
    ca_uint32_t cl_fib_xr_cos_1      :  3 ; /* bits 31:29 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_IGR_FIB_DATA0_t;


#define  SATURN_L2FE_CLE_EGR_FIB_ACCESS                  0xd0001b98
#define  SATURN_L2FE_CLE_EGR_FIB_ACCESS_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_EGR_FIB_ACCESS_t;


#define  SATURN_L2FE_CLE_EGR_FIB_DATA4                   0xd0001b9c
#define  SATURN_L2FE_CLE_EGR_FIB_DATA4_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_fib_xr_inner_vid_0 :  3 ; /* bits 2:0 */
    ca_uint32_t cl_fib_xr_top_cmd_valid_0 :  1 ; /* bits 3:3 */
    ca_uint32_t cl_fib_xr_top_vlan_cmd_0 :  2 ; /* bits 5:4 */
    ca_uint32_t cl_fib_xr_top_sc_ind_0 :  1 ; /* bits 6:6 */
    ca_uint32_t cl_fib_xr_top_vid_0  : 12 ; /* bits 18:7 */
    ca_uint32_t cl_fib_xr_pkt_no_drop_0 :  1 ; /* bits 19:19 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_EGR_FIB_DATA4_t;


#define  SATURN_L2FE_CLE_EGR_FIB_DATA3                   0xd0001ba0
#define  SATURN_L2FE_CLE_EGR_FIB_DATA3_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_fib_xr_ldpid_0    :  4 ; /* bits 3:0 */
    ca_uint32_t cl_fib_xr_cos_valid_0 :  1 ; /* bits 4:4 */
    ca_uint32_t cl_fib_xr_dscp_valid_0 :  1 ; /* bits 5:5 */
    ca_uint32_t cl_fib_xr_802_1p_valid_0 :  1 ; /* bits 6:6 */
    ca_uint32_t cl_fib_xr_cos_0      :  3 ; /* bits 9:7 */
    ca_uint32_t cl_fib_xr_dscp_0     :  6 ; /* bits 15:10 */
    ca_uint32_t cl_fib_xr_802_1p_0   :  3 ; /* bits 18:16 */
    ca_uint32_t cl_fib_xr_inner_cmd_valid_0 :  1 ; /* bits 19:19 */
    ca_uint32_t cl_fib_xr_inner_vlan_cmd_0 :  2 ; /* bits 21:20 */
    ca_uint32_t cl_fib_xr_inner_sc_ind_0 :  1 ; /* bits 22:22 */
    ca_uint32_t cl_fib_xr_inner_vid_0 :  9 ; /* bits 31:23 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_EGR_FIB_DATA3_t;


#define  SATURN_L2FE_CLE_EGR_FIB_DATA2                   0xd0001ba4
#define  SATURN_L2FE_CLE_EGR_FIB_DATA2_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_fib_xr_top_vid_1  :  9 ; /* bits 8:0 */
    ca_uint32_t cl_fib_xr_pkt_no_drop_1 :  1 ; /* bits 9:9 */
    ca_uint32_t cl_fib_xr_stp_mode_0 :  2 ; /* bits 11:10 */
    ca_uint32_t cl_fib_xr_permit_valid_0 :  1 ; /* bits 12:12 */
    ca_uint32_t cl_fib_xr_permit_0   :  1 ; /* bits 13:13 */
    ca_uint32_t cl_fib_xr_premarked_0 :  1 ; /* bits 14:14 */
    ca_uint32_t cl_fib_xr_dscp_markdown_0 :  1 ; /* bits 15:15 */
    ca_uint32_t cl_fib_xr_mark_en_0  :  1 ; /* bits 16:16 */
    ca_uint32_t cl_fib_xr_flowid_0   : 12 ; /* bits 28:17 */
    ca_uint32_t cl_fib_xr_dp_valid_0 :  1 ; /* bits 29:29 */
    ca_uint32_t cl_fib_xr_ldpid_0    :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_EGR_FIB_DATA2_t;


#define  SATURN_L2FE_CLE_EGR_FIB_DATA1                   0xd0001ba8
#define  SATURN_L2FE_CLE_EGR_FIB_DATA1_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_fib_xr_dscp_1     :  6 ; /* bits 5:0 */
    ca_uint32_t cl_fib_xr_802_1p_1   :  3 ; /* bits 8:6 */
    ca_uint32_t cl_fib_xr_inner_cmd_valid_1 :  1 ; /* bits 9:9 */
    ca_uint32_t cl_fib_xr_inner_vlan_cmd_1 :  2 ; /* bits 11:10 */
    ca_uint32_t cl_fib_xr_inner_sc_ind_1 :  1 ; /* bits 12:12 */
    ca_uint32_t cl_fib_xr_inner_vid_1 : 12 ; /* bits 24:13 */
    ca_uint32_t cl_fib_xr_top_cmd_valid_1 :  1 ; /* bits 25:25 */
    ca_uint32_t cl_fib_xr_top_vlan_cmd_1 :  2 ; /* bits 27:26 */
    ca_uint32_t cl_fib_xr_top_sc_ind_1 :  1 ; /* bits 28:28 */
    ca_uint32_t cl_fib_xr_top_vid_1  :  3 ; /* bits 31:29 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_EGR_FIB_DATA1_t;


#define  SATURN_L2FE_CLE_EGR_FIB_DATA0                   0xd0001bac
#define  SATURN_L2FE_CLE_EGR_FIB_DATA0_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_fib_xr_stp_mode_1 :  2 ; /* bits 1:0 */
    ca_uint32_t cl_fib_xr_permit_valid_1 :  1 ; /* bits 2:2 */
    ca_uint32_t cl_fib_xr_permit_1   :  1 ; /* bits 3:3 */
    ca_uint32_t cl_fib_xr_premarked_1 :  1 ; /* bits 4:4 */
    ca_uint32_t cl_fib_xr_dscp_markdown_1 :  1 ; /* bits 5:5 */
    ca_uint32_t cl_fib_xr_mark_en_1  :  1 ; /* bits 6:6 */
    ca_uint32_t cl_fib_xr_flowid_1   : 12 ; /* bits 18:7 */
    ca_uint32_t cl_fib_xr_dp_valid_1 :  1 ; /* bits 19:19 */
    ca_uint32_t cl_fib_xr_ldpid_1    :  6 ; /* bits 25:20 */
    ca_uint32_t cl_fib_xr_cos_valid_1 :  1 ; /* bits 26:26 */
    ca_uint32_t cl_fib_xr_dscp_valid_1 :  1 ; /* bits 27:27 */
    ca_uint32_t cl_fib_xr_802_1p_valid_1 :  1 ; /* bits 28:28 */
    ca_uint32_t cl_fib_xr_cos_1      :  3 ; /* bits 31:29 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_CLE_EGR_FIB_DATA0_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* CLE */
typedef struct {
  SATURN_L2FE_CLE_CTRL_t                          CTRL;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_L2FE_CLE_CONFG_STTS1_t                   CONFG_STTS1;                   /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_L2FE_CLE_CONFG_STTS2_t                   CONFG_STTS2;                   /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_L2FE_CLE_DEBUG_t                         _DEBUG;                        /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_L2FE_CLE_IGR_KEY_ACCESS_t                IGR_KEY_ACCESS;                /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_L2FE_CLE_IGR_KEY_DATA12_t                IGR_KEY_DATA12;                /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_L2FE_CLE_IGR_KEY_DATA11_t                IGR_KEY_DATA11;                /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  SATURN_L2FE_CLE_IGR_KEY_DATA10_t                IGR_KEY_DATA10;                /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  SATURN_L2FE_CLE_IGR_KEY_DATA9_t                 IGR_KEY_DATA9;                 /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  SATURN_L2FE_CLE_IGR_KEY_DATA8_t                 IGR_KEY_DATA8;                 /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  SATURN_L2FE_CLE_IGR_KEY_DATA7_t                 IGR_KEY_DATA7;                 /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  SATURN_L2FE_CLE_IGR_KEY_DATA6_t                 IGR_KEY_DATA6;                 /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  SATURN_L2FE_CLE_IGR_KEY_DATA5_t                 IGR_KEY_DATA5;                 /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  SATURN_L2FE_CLE_IGR_KEY_DATA4_t                 IGR_KEY_DATA4;                 /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  SATURN_L2FE_CLE_IGR_KEY_DATA3_t                 IGR_KEY_DATA3;                 /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  SATURN_L2FE_CLE_IGR_KEY_DATA2_t                 IGR_KEY_DATA2;                 /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  SATURN_L2FE_CLE_IGR_KEY_DATA1_t                 IGR_KEY_DATA1;                 /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  SATURN_L2FE_CLE_IGR_KEY_DATA0_t                 IGR_KEY_DATA0;                 /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  SATURN_L2FE_CLE_EGR_KEY_ACCESS_t                EGR_KEY_ACCESS;                /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  SATURN_L2FE_CLE_EGR_KEY_DATA12_t                EGR_KEY_DATA12;                /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  SATURN_L2FE_CLE_EGR_KEY_DATA11_t                EGR_KEY_DATA11;                /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  SATURN_L2FE_CLE_EGR_KEY_DATA10_t                EGR_KEY_DATA10;                /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  SATURN_L2FE_CLE_EGR_KEY_DATA9_t                 EGR_KEY_DATA9;                 /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  SATURN_L2FE_CLE_EGR_KEY_DATA8_t                 EGR_KEY_DATA8;                 /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  SATURN_L2FE_CLE_EGR_KEY_DATA7_t                 EGR_KEY_DATA7;                 /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  SATURN_L2FE_CLE_EGR_KEY_DATA6_t                 EGR_KEY_DATA6;                 /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  SATURN_L2FE_CLE_EGR_KEY_DATA5_t                 EGR_KEY_DATA5;                 /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  SATURN_L2FE_CLE_EGR_KEY_DATA4_t                 EGR_KEY_DATA4;                 /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  SATURN_L2FE_CLE_EGR_KEY_DATA3_t                 EGR_KEY_DATA3;                 /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  SATURN_L2FE_CLE_EGR_KEY_DATA2_t                 EGR_KEY_DATA2;                 /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  SATURN_L2FE_CLE_EGR_KEY_DATA1_t                 EGR_KEY_DATA1;                 /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  SATURN_L2FE_CLE_EGR_KEY_DATA0_t                 EGR_KEY_DATA0;                 /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  SATURN_L2FE_CLE_IGR_FIB_ACCESS_t                IGR_FIB_ACCESS;                /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  SATURN_L2FE_CLE_IGR_FIB_DATA4_t                 IGR_FIB_DATA4;                 /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  SATURN_L2FE_CLE_IGR_FIB_DATA3_t                 IGR_FIB_DATA3;                 /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  SATURN_L2FE_CLE_IGR_FIB_DATA2_t                 IGR_FIB_DATA2;                 /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  SATURN_L2FE_CLE_IGR_FIB_DATA1_t                 IGR_FIB_DATA1;                 /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  SATURN_L2FE_CLE_IGR_FIB_DATA0_t                 IGR_FIB_DATA0;                 /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  SATURN_L2FE_CLE_EGR_FIB_ACCESS_t                EGR_FIB_ACCESS;                /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];                   
  SATURN_L2FE_CLE_EGR_FIB_DATA4_t                 EGR_FIB_DATA4;                 /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];                   
  SATURN_L2FE_CLE_EGR_FIB_DATA3_t                 EGR_FIB_DATA3;                 /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];                   
  SATURN_L2FE_CLE_EGR_FIB_DATA2_t                 EGR_FIB_DATA2;                 /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];                   
  SATURN_L2FE_CLE_EGR_FIB_DATA1_t                 EGR_FIB_DATA1;                 /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];                   
  SATURN_L2FE_CLE_EGR_FIB_DATA0_t                 EGR_FIB_DATA0;                 /* addr: 0x000000ac */
} SATURN_APB0_L2FE_CLE_t;


/*
 * L2E
 */
        
#define  SATURN_L2FE_L2E_CTRL                            0xd0001c00
#define  SATURN_L2FE_L2E_CTRL_dft                        0x1ca00ff9

typedef volatile union {
  struct {
    ca_uint32_t aging_en             :  1 ; /* bits 0:0 */
    ca_uint32_t tmp_entry_aging_dis  :  1 ; /* bits 1:1 */
    ca_uint32_t aging_mode           :  1 ; /* bits 2:2 */
    ca_uint32_t aging_start_val      :  8 ; /* bits 10:3 */
    ca_uint32_t st_move_en           :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t st_mv_window         :  9 ; /* bits 21:13 */
    ca_uint32_t lrn_dis              :  1 ; /* bits 22:22 */
    ca_uint32_t lrn_mode             :  2 ; /* bits 24:23 */
    ca_uint32_t hash_collision_overwrite :  1 ; /* bits 25:25 */
    ca_uint32_t hashing_mode         :  2 ; /* bits 27:26 */
    ca_uint32_t da_deny_dnt_lrn      :  1 ; /* bits 28:28 */
    ca_uint32_t ovfl_entries_rcyc_en :  1 ; /* bits 29:29 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t cpu_opt_mode         :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_CTRL_t;


#define  SATURN_L2FE_L2E_AGING_CTRL                      0xd0001c04
#define  SATURN_L2FE_L2E_AGING_CTRL_dft                  0x77b0012c

typedef volatile union {
  struct {
    ca_uint32_t aging_out_time       : 19 ; /* bits 18:0 */
    ca_uint32_t cnt_to_1s            : 13 ; /* bits 31:19 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_AGING_CTRL_t;


#define  SATURN_L2FE_L2E_SW_AGING_CPT_ENTRY_3            0xd0001c08
#define  SATURN_L2FE_L2E_SW_AGING_CPT_ENTRY_3_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_SW_AGING_CPT_ENTRY_3_t;


#define  SATURN_L2FE_L2E_SW_AGING_CPT_ENTRY_2            0xd0001c0c
#define  SATURN_L2FE_L2E_SW_AGING_CPT_ENTRY_2_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_SW_AGING_CPT_ENTRY_2_t;


#define  SATURN_L2FE_L2E_SW_AGING_CPT_ENTRY_1            0xd0001c10
#define  SATURN_L2FE_L2E_SW_AGING_CPT_ENTRY_1_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_SW_AGING_CPT_ENTRY_1_t;


#define  SATURN_L2FE_L2E_SW_AGING_CPT_ENTRY_0            0xd0001c14
#define  SATURN_L2FE_L2E_SW_AGING_CPT_ENTRY_0_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_SW_AGING_CPT_ENTRY_0_t;


#define  SATURN_L2FE_L2E_FDB_CPU_CMD_WORD4               0xd0001c18
#define  SATURN_L2FE_L2E_FDB_CPU_CMD_WORD4_dft           0x00007fff

typedef volatile union {
  struct {
    ca_uint32_t word                 : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_FDB_CPU_CMD_WORD4_t;


#define  SATURN_L2FE_L2E_FDB_CPU_CMD_WORD3               0xd0001c1c
#define  SATURN_L2FE_L2E_FDB_CPU_CMD_WORD3_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t word                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_FDB_CPU_CMD_WORD3_t;


#define  SATURN_L2FE_L2E_FDB_CPU_CMD_WORD2               0xd0001c20
#define  SATURN_L2FE_L2E_FDB_CPU_CMD_WORD2_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t word                 : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_FDB_CPU_CMD_WORD2_t;


#define  SATURN_L2FE_L2E_FDB_CPU_CMD_WORD1               0xd0001c24
#define  SATURN_L2FE_L2E_FDB_CPU_CMD_WORD1_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t word                 : 27 ; /* bits 26:0 */
    ca_uint32_t rsrvd1               :  5 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_FDB_CPU_CMD_WORD1_t;


#define  SATURN_L2FE_L2E_FDB_CPU_CMD_WORD0               0xd0001c28
#define  SATURN_L2FE_L2E_FDB_CPU_CMD_WORD0_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t word                 : 27 ; /* bits 26:0 */
    ca_uint32_t rsrvd1               :  5 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_FDB_CPU_CMD_WORD0_t;


#define  SATURN_L2FE_L2E_FDB_CMD_RETURN                  0xd0001c2c
#define  SATURN_L2FE_L2E_FDB_CMD_RETURN_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t status               :  4 ; /* bits 3:0 */
    ca_uint32_t ext_status           : 13 ; /* bits 16:4 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_FDB_CMD_RETURN_t;


#define  SATURN_L2FE_L2E_CNT_CMD_RETURN                  0xd0001c30
#define  SATURN_L2FE_L2E_CNT_CMD_RETURN_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t status               :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_CNT_CMD_RETURN_t;


#define  SATURN_L2FE_L2E_PORT_MAC_CNT_STTS_0             0xd0001c34
#define  SATURN_L2FE_L2E_PORT_MAC_CNT_STTS_0_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t underflow_0          :  1 ; /* bits 0:0 */
    ca_uint32_t underflow_1          :  1 ; /* bits 1:1 */
    ca_uint32_t underflow_2          :  1 ; /* bits 2:2 */
    ca_uint32_t underflow_3          :  1 ; /* bits 3:3 */
    ca_uint32_t underflow_4          :  1 ; /* bits 4:4 */
    ca_uint32_t underflow_5          :  1 ; /* bits 5:5 */
    ca_uint32_t underflow_6          :  1 ; /* bits 6:6 */
    ca_uint32_t underflow_7          :  1 ; /* bits 7:7 */
    ca_uint32_t underflow_8          :  1 ; /* bits 8:8 */
    ca_uint32_t underflow_9          :  1 ; /* bits 9:9 */
    ca_uint32_t underflow_10         :  1 ; /* bits 10:10 */
    ca_uint32_t underflow_11         :  1 ; /* bits 11:11 */
    ca_uint32_t underflow_12         :  1 ; /* bits 12:12 */
    ca_uint32_t underflow_13         :  1 ; /* bits 13:13 */
    ca_uint32_t underflow_14         :  1 ; /* bits 14:14 */
    ca_uint32_t underflow_15         :  1 ; /* bits 15:15 */
    ca_uint32_t underflow_16         :  1 ; /* bits 16:16 */
    ca_uint32_t underflow_17         :  1 ; /* bits 17:17 */
    ca_uint32_t underflow_18         :  1 ; /* bits 18:18 */
    ca_uint32_t underflow_19         :  1 ; /* bits 19:19 */
    ca_uint32_t underflow_20         :  1 ; /* bits 20:20 */
    ca_uint32_t underflow_21         :  1 ; /* bits 21:21 */
    ca_uint32_t underflow_22         :  1 ; /* bits 22:22 */
    ca_uint32_t underflow_23         :  1 ; /* bits 23:23 */
    ca_uint32_t underflow_24         :  1 ; /* bits 24:24 */
    ca_uint32_t underflow_25         :  1 ; /* bits 25:25 */
    ca_uint32_t underflow_26         :  1 ; /* bits 26:26 */
    ca_uint32_t underflow_27         :  1 ; /* bits 27:27 */
    ca_uint32_t underflow_28         :  1 ; /* bits 28:28 */
    ca_uint32_t underflow_29         :  1 ; /* bits 29:29 */
    ca_uint32_t underflow_30         :  1 ; /* bits 30:30 */
    ca_uint32_t underflow_31         :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_PORT_MAC_CNT_STTS_0_t;


#define  SATURN_L2FE_L2E_PORT_MAC_CNT_STTS_1             0xd0001c38
#define  SATURN_L2FE_L2E_PORT_MAC_CNT_STTS_1_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t underflow_0          :  1 ; /* bits 0:0 */
    ca_uint32_t underflow_1          :  1 ; /* bits 1:1 */
    ca_uint32_t underflow_2          :  1 ; /* bits 2:2 */
    ca_uint32_t underflow_3          :  1 ; /* bits 3:3 */
    ca_uint32_t underflow_4          :  1 ; /* bits 4:4 */
    ca_uint32_t underflow_5          :  1 ; /* bits 5:5 */
    ca_uint32_t underflow_6          :  1 ; /* bits 6:6 */
    ca_uint32_t underflow_7          :  1 ; /* bits 7:7 */
    ca_uint32_t underflow_8          :  1 ; /* bits 8:8 */
    ca_uint32_t underflow_9          :  1 ; /* bits 9:9 */
    ca_uint32_t underflow_10         :  1 ; /* bits 10:10 */
    ca_uint32_t underflow_11         :  1 ; /* bits 11:11 */
    ca_uint32_t underflow_12         :  1 ; /* bits 12:12 */
    ca_uint32_t underflow_13         :  1 ; /* bits 13:13 */
    ca_uint32_t underflow_14         :  1 ; /* bits 14:14 */
    ca_uint32_t underflow_15         :  1 ; /* bits 15:15 */
    ca_uint32_t underflow_16         :  1 ; /* bits 16:16 */
    ca_uint32_t underflow_17         :  1 ; /* bits 17:17 */
    ca_uint32_t underflow_18         :  1 ; /* bits 18:18 */
    ca_uint32_t underflow_19         :  1 ; /* bits 19:19 */
    ca_uint32_t underflow_20         :  1 ; /* bits 20:20 */
    ca_uint32_t underflow_21         :  1 ; /* bits 21:21 */
    ca_uint32_t underflow_22         :  1 ; /* bits 22:22 */
    ca_uint32_t underflow_23         :  1 ; /* bits 23:23 */
    ca_uint32_t underflow_24         :  1 ; /* bits 24:24 */
    ca_uint32_t underflow_25         :  1 ; /* bits 25:25 */
    ca_uint32_t underflow_26         :  1 ; /* bits 26:26 */
    ca_uint32_t underflow_27         :  1 ; /* bits 27:27 */
    ca_uint32_t underflow_28         :  1 ; /* bits 28:28 */
    ca_uint32_t underflow_29         :  1 ; /* bits 29:29 */
    ca_uint32_t underflow_30         :  1 ; /* bits 30:30 */
    ca_uint32_t underflow_31         :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_PORT_MAC_CNT_STTS_1_t;


#define  SATURN_L2FE_L2E_PORT_MAC_LMT_CHK_STTS_0         0xd0001c3c
#define  SATURN_L2FE_L2E_PORT_MAC_LMT_CHK_STTS_0_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t excd_0               :  1 ; /* bits 0:0 */
    ca_uint32_t excd_1               :  1 ; /* bits 1:1 */
    ca_uint32_t excd_2               :  1 ; /* bits 2:2 */
    ca_uint32_t excd_3               :  1 ; /* bits 3:3 */
    ca_uint32_t excd_4               :  1 ; /* bits 4:4 */
    ca_uint32_t excd_5               :  1 ; /* bits 5:5 */
    ca_uint32_t excd_6               :  1 ; /* bits 6:6 */
    ca_uint32_t excd_7               :  1 ; /* bits 7:7 */
    ca_uint32_t excd_8               :  1 ; /* bits 8:8 */
    ca_uint32_t excd_9               :  1 ; /* bits 9:9 */
    ca_uint32_t excd_10              :  1 ; /* bits 10:10 */
    ca_uint32_t excd_11              :  1 ; /* bits 11:11 */
    ca_uint32_t excd_12              :  1 ; /* bits 12:12 */
    ca_uint32_t excd_13              :  1 ; /* bits 13:13 */
    ca_uint32_t excd_14              :  1 ; /* bits 14:14 */
    ca_uint32_t excd_15              :  1 ; /* bits 15:15 */
    ca_uint32_t excd_16              :  1 ; /* bits 16:16 */
    ca_uint32_t excd_17              :  1 ; /* bits 17:17 */
    ca_uint32_t excd_18              :  1 ; /* bits 18:18 */
    ca_uint32_t excd_19              :  1 ; /* bits 19:19 */
    ca_uint32_t excd_20              :  1 ; /* bits 20:20 */
    ca_uint32_t excd_21              :  1 ; /* bits 21:21 */
    ca_uint32_t excd_22              :  1 ; /* bits 22:22 */
    ca_uint32_t excd_23              :  1 ; /* bits 23:23 */
    ca_uint32_t excd_24              :  1 ; /* bits 24:24 */
    ca_uint32_t excd_25              :  1 ; /* bits 25:25 */
    ca_uint32_t excd_26              :  1 ; /* bits 26:26 */
    ca_uint32_t excd_27              :  1 ; /* bits 27:27 */
    ca_uint32_t excd_28              :  1 ; /* bits 28:28 */
    ca_uint32_t excd_29              :  1 ; /* bits 29:29 */
    ca_uint32_t excd_30              :  1 ; /* bits 30:30 */
    ca_uint32_t excd_31              :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_PORT_MAC_LMT_CHK_STTS_0_t;


#define  SATURN_L2FE_L2E_PORT_MAC_LMT_CHK_STTS_1         0xd0001c40
#define  SATURN_L2FE_L2E_PORT_MAC_LMT_CHK_STTS_1_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t excd_0               :  1 ; /* bits 0:0 */
    ca_uint32_t excd_1               :  1 ; /* bits 1:1 */
    ca_uint32_t excd_2               :  1 ; /* bits 2:2 */
    ca_uint32_t excd_3               :  1 ; /* bits 3:3 */
    ca_uint32_t excd_4               :  1 ; /* bits 4:4 */
    ca_uint32_t excd_5               :  1 ; /* bits 5:5 */
    ca_uint32_t excd_6               :  1 ; /* bits 6:6 */
    ca_uint32_t excd_7               :  1 ; /* bits 7:7 */
    ca_uint32_t excd_8               :  1 ; /* bits 8:8 */
    ca_uint32_t excd_9               :  1 ; /* bits 9:9 */
    ca_uint32_t excd_10              :  1 ; /* bits 10:10 */
    ca_uint32_t excd_11              :  1 ; /* bits 11:11 */
    ca_uint32_t excd_12              :  1 ; /* bits 12:12 */
    ca_uint32_t excd_13              :  1 ; /* bits 13:13 */
    ca_uint32_t excd_14              :  1 ; /* bits 14:14 */
    ca_uint32_t excd_15              :  1 ; /* bits 15:15 */
    ca_uint32_t excd_16              :  1 ; /* bits 16:16 */
    ca_uint32_t excd_17              :  1 ; /* bits 17:17 */
    ca_uint32_t excd_18              :  1 ; /* bits 18:18 */
    ca_uint32_t excd_19              :  1 ; /* bits 19:19 */
    ca_uint32_t excd_20              :  1 ; /* bits 20:20 */
    ca_uint32_t excd_21              :  1 ; /* bits 21:21 */
    ca_uint32_t excd_22              :  1 ; /* bits 22:22 */
    ca_uint32_t excd_23              :  1 ; /* bits 23:23 */
    ca_uint32_t excd_24              :  1 ; /* bits 24:24 */
    ca_uint32_t excd_25              :  1 ; /* bits 25:25 */
    ca_uint32_t excd_26              :  1 ; /* bits 26:26 */
    ca_uint32_t excd_27              :  1 ; /* bits 27:27 */
    ca_uint32_t excd_28              :  1 ; /* bits 28:28 */
    ca_uint32_t excd_29              :  1 ; /* bits 29:29 */
    ca_uint32_t excd_30              :  1 ; /* bits 30:30 */
    ca_uint32_t excd_31              :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_PORT_MAC_LMT_CHK_STTS_1_t;


#define  SATURN_L2FE_L2E_HASH_CLLSN_STTS                 0xd0001c44
#define  SATURN_L2FE_L2E_HASH_CLLSN_STTS_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cllsn_det            :  1 ; /* bits 0:0 */
    ca_uint32_t cllsn_addr           :  9 ; /* bits 9:1 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_HASH_CLLSN_STTS_t;


#define  SATURN_L2FE_L2E_L2E_LRN_STS                     0xd0001c48
#define  SATURN_L2FE_L2E_L2E_LRN_STS_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t loop_det             :  1 ; /* bits 0:0 */
    ca_uint32_t hit_tmp_entry_sm     :  1 ; /* bits 1:1 */
    ca_uint32_t hit_static_entry_sm  :  1 ; /* bits 2:2 */
    ca_uint32_t hit_sm_entry_sm      :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_L2E_LRN_STS_t;


#define  SATURN_L2FE_L2E_SW_AGING_REPORT_FIFO_STTS       0xd0001c4c
#define  SATURN_L2FE_L2E_SW_AGING_REPORT_FIFO_STTS_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cpt_entry_flg        :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t cnt                  :  4 ; /* bits 7:4 */
    ca_uint32_t rsrvd2               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_SW_AGING_REPORT_FIFO_STTS_t;


#define  SATURN_L2FE_L2E_POINTER_FF_STS_REG              0xd0001c50
#define  SATURN_L2FE_L2E_POINTER_FF_STS_REG_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t overflow_ind         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_POINTER_FF_STS_REG_t;


#define  SATURN_L2FE_L2E_POINTER_FF_CNT                  0xd0001c54
#define  SATURN_L2FE_L2E_POINTER_FF_CNT_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_POINTER_FF_CNT_t;


#define  SATURN_L2FE_L2E_INFO_FF_STS_REG                 0xd0001c58
#define  SATURN_L2FE_L2E_INFO_FF_STS_REG_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t overflow_ind         : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_INFO_FF_STS_REG_t;


#define  SATURN_L2FE_L2E_INFO_FF_CNT_0                   0xd0001c5c
#define  SATURN_L2FE_L2E_INFO_FF_CNT_0_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_INFO_FF_CNT_0_t;


#define  SATURN_L2FE_L2E_INFO_FF_CNT_1                   0xd0001c60
#define  SATURN_L2FE_L2E_INFO_FF_CNT_1_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_INFO_FF_CNT_1_t;


#define  SATURN_L2FE_L2E_INFO_FF_CNT_2                   0xd0001c64
#define  SATURN_L2FE_L2E_INFO_FF_CNT_2_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_INFO_FF_CNT_2_t;


#define  SATURN_L2FE_L2E_INFO_FF_CNT_3                   0xd0001c68
#define  SATURN_L2FE_L2E_INFO_FF_CNT_3_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_INFO_FF_CNT_3_t;


#define  SATURN_L2FE_L2E_INFO_FF_CNT_4                   0xd0001c6c
#define  SATURN_L2FE_L2E_INFO_FF_CNT_4_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_INFO_FF_CNT_4_t;


#define  SATURN_L2FE_L2E_INFO_FF_CNT_5                   0xd0001c70
#define  SATURN_L2FE_L2E_INFO_FF_CNT_5_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_INFO_FF_CNT_5_t;


#define  SATURN_L2FE_L2E_INFO_FF_CNT_6                   0xd0001c74
#define  SATURN_L2FE_L2E_INFO_FF_CNT_6_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_INFO_FF_CNT_6_t;


#define  SATURN_L2FE_L2E_INFO_FF_CNT_7                   0xd0001c78
#define  SATURN_L2FE_L2E_INFO_FF_CNT_7_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_INFO_FF_CNT_7_t;


#define  SATURN_L2FE_L2E_INFO_FF_CNT_8                   0xd0001c7c
#define  SATURN_L2FE_L2E_INFO_FF_CNT_8_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_INFO_FF_CNT_8_t;


#define  SATURN_L2FE_L2E_INFO_FF_CNT_9                   0xd0001c80
#define  SATURN_L2FE_L2E_INFO_FF_CNT_9_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_INFO_FF_CNT_9_t;


#define  SATURN_L2FE_L2E_INFO_FF_CNT_10                  0xd0001c84
#define  SATURN_L2FE_L2E_INFO_FF_CNT_10_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_INFO_FF_CNT_10_t;


#define  SATURN_L2FE_L2E_INFO_FF_CNT_11                  0xd0001c88
#define  SATURN_L2FE_L2E_INFO_FF_CNT_11_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_INFO_FF_CNT_11_t;


#define  SATURN_L2FE_L2E_INFO_FF_CNT_12                  0xd0001c8c
#define  SATURN_L2FE_L2E_INFO_FF_CNT_12_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_INFO_FF_CNT_12_t;


#define  SATURN_L2FE_L2E_INFO_FF_CNT_13                  0xd0001c90
#define  SATURN_L2FE_L2E_INFO_FF_CNT_13_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_INFO_FF_CNT_13_t;


#define  SATURN_L2FE_L2E_INFO_FF_CNT_14                  0xd0001c94
#define  SATURN_L2FE_L2E_INFO_FF_CNT_14_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_INFO_FF_CNT_14_t;


#define  SATURN_L2FE_L2E_INFO_FF_CNT_15                  0xd0001c98
#define  SATURN_L2FE_L2E_INFO_FF_CNT_15_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_INFO_FF_CNT_15_t;


#define  SATURN_L2FE_L2E_L3FE_RFSH_STS                   0xd0001c9c
#define  SATURN_L2FE_L2E_L3FE_RFSH_STS_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rfsh_entry_ovfl      :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_L3FE_RFSH_STS_t;


#define  SATURN_L2FE_L2E_DEBUG_BUS                       0xd0001ca0
#define  SATURN_L2FE_L2E_DEBUG_BUS_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sel                  :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_DEBUG_BUS_t;


#define  SATURN_L2FE_L2E_FDB_ACCESS                      0xd0001ca4
#define  SATURN_L2FE_L2E_FDB_ACCESS_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 : 21 ; /* bits 20:0 */
    ca_uint32_t rsrvd1               :  9 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_FDB_ACCESS_t;


#define  SATURN_L2FE_L2E_FDB_DATA3                       0xd0001ca8
#define  SATURN_L2FE_L2E_FDB_DATA3_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac_addr             :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_FDB_DATA3_t;


#define  SATURN_L2FE_L2E_FDB_DATA2                       0xd0001cac
#define  SATURN_L2FE_L2E_FDB_DATA2_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac_addr             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_FDB_DATA2_t;


#define  SATURN_L2FE_L2E_FDB_DATA1                       0xd0001cb0
#define  SATURN_L2FE_L2E_FDB_DATA1_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t lrned_vid            :  3 ; /* bits 2:0 */
    ca_uint32_t key_dot1p            :  3 ; /* bits 5:3 */
    ca_uint32_t key_scind            :  1 ; /* bits 6:6 */
    ca_uint32_t key_vid              : 12 ; /* bits 18:7 */
    ca_uint32_t mac_addr             : 13 ; /* bits 31:19 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_FDB_DATA1_t;


#define  SATURN_L2FE_L2E_FDB_DATA0                       0xd0001cb4
#define  SATURN_L2FE_L2E_FDB_DATA0_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mcgid                : 10 ; /* bits 9:0 */
    ca_uint32_t mc_flag              :  1 ; /* bits 10:10 */
    ca_uint32_t aging_sts            :  8 ; /* bits 18:11 */
    ca_uint32_t is_static            :  1 ; /* bits 19:19 */
    ca_uint32_t da_permit            :  1 ; /* bits 20:20 */
    ca_uint32_t sa_permit            :  1 ; /* bits 21:21 */
    ca_uint32_t lrned_scind          :  1 ; /* bits 22:22 */
    ca_uint32_t lrned_vid            :  9 ; /* bits 31:23 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_FDB_DATA0_t;


#define  SATURN_L2FE_L2E_PORT_MAC_CNT_LMT_ACCESS         0xd0001cb8
#define  SATURN_L2FE_L2E_PORT_MAC_CNT_LMT_ACCESS_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 20 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_PORT_MAC_CNT_LMT_ACCESS_t;


#define  SATURN_L2FE_L2E_PORT_MAC_CNT_LMT_DATA           0xd0001cbc
#define  SATURN_L2FE_L2E_PORT_MAC_CNT_LMT_DATA_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t val                  : 13 ; /* bits 12:0 */
    ca_uint32_t rsrvd1               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_PORT_MAC_CNT_LMT_DATA_t;


#define  SATURN_L2FE_L2E_AGING_CTRL_EXT                  0xd0001cc0
#define  SATURN_L2FE_L2E_AGING_CTRL_EXT_dft              0x00000002

typedef volatile union {
  struct {
    ca_uint32_t sw_lrn_aging_start_val :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_L2E_AGING_CTRL_EXT_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* L2E */
typedef struct {
  SATURN_L2FE_L2E_CTRL_t                          CTRL;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_L2FE_L2E_AGING_CTRL_t                    AGING_CTRL;                    /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_L2FE_L2E_SW_AGING_CPT_ENTRY_3_t          SW_AGING_CPT_ENTRY_3;          /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_L2FE_L2E_SW_AGING_CPT_ENTRY_2_t          SW_AGING_CPT_ENTRY_2;          /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_L2FE_L2E_SW_AGING_CPT_ENTRY_1_t          SW_AGING_CPT_ENTRY_1;          /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_L2FE_L2E_SW_AGING_CPT_ENTRY_0_t          SW_AGING_CPT_ENTRY_0;          /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_L2FE_L2E_FDB_CPU_CMD_WORD4_t             FDB_CPU_CMD_WORD4;             /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  SATURN_L2FE_L2E_FDB_CPU_CMD_WORD3_t             FDB_CPU_CMD_WORD3;             /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  SATURN_L2FE_L2E_FDB_CPU_CMD_WORD2_t             FDB_CPU_CMD_WORD2;             /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  SATURN_L2FE_L2E_FDB_CPU_CMD_WORD1_t             FDB_CPU_CMD_WORD1;             /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  SATURN_L2FE_L2E_FDB_CPU_CMD_WORD0_t             FDB_CPU_CMD_WORD0;             /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  SATURN_L2FE_L2E_FDB_CMD_RETURN_t                FDB_CMD_RETURN;                /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  SATURN_L2FE_L2E_CNT_CMD_RETURN_t                CNT_CMD_RETURN;                /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  SATURN_L2FE_L2E_PORT_MAC_CNT_STTS_0_t           PORT_MAC_CNT_STTS_0;           /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  SATURN_L2FE_L2E_PORT_MAC_CNT_STTS_1_t           PORT_MAC_CNT_STTS_1;           /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  SATURN_L2FE_L2E_PORT_MAC_LMT_CHK_STTS_0_t       PORT_MAC_LMT_CHK_STTS_0;       /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  SATURN_L2FE_L2E_PORT_MAC_LMT_CHK_STTS_1_t       PORT_MAC_LMT_CHK_STTS_1;       /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  SATURN_L2FE_L2E_HASH_CLLSN_STTS_t               HASH_CLLSN_STTS;               /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  SATURN_L2FE_L2E_L2E_LRN_STS_t                   L2E_LRN_STS;                   /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  SATURN_L2FE_L2E_SW_AGING_REPORT_FIFO_STTS_t     SW_AGING_REPORT_FIFO_STTS;     /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  SATURN_L2FE_L2E_POINTER_FF_STS_REG_t            POINTER_FF_STS_REG;            /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  SATURN_L2FE_L2E_POINTER_FF_CNT_t                POINTER_FF_CNT;                /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  SATURN_L2FE_L2E_INFO_FF_STS_REG_t               INFO_FF_STS_REG;               /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  SATURN_L2FE_L2E_INFO_FF_CNT_0_t                 INFO_FF_CNT_0;                 /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  SATURN_L2FE_L2E_INFO_FF_CNT_1_t                 INFO_FF_CNT_1;                 /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  SATURN_L2FE_L2E_INFO_FF_CNT_2_t                 INFO_FF_CNT_2;                 /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  SATURN_L2FE_L2E_INFO_FF_CNT_3_t                 INFO_FF_CNT_3;                 /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  SATURN_L2FE_L2E_INFO_FF_CNT_4_t                 INFO_FF_CNT_4;                 /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  SATURN_L2FE_L2E_INFO_FF_CNT_5_t                 INFO_FF_CNT_5;                 /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  SATURN_L2FE_L2E_INFO_FF_CNT_6_t                 INFO_FF_CNT_6;                 /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  SATURN_L2FE_L2E_INFO_FF_CNT_7_t                 INFO_FF_CNT_7;                 /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  SATURN_L2FE_L2E_INFO_FF_CNT_8_t                 INFO_FF_CNT_8;                 /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  SATURN_L2FE_L2E_INFO_FF_CNT_9_t                 INFO_FF_CNT_9;                 /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  SATURN_L2FE_L2E_INFO_FF_CNT_10_t                INFO_FF_CNT_10;                /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  SATURN_L2FE_L2E_INFO_FF_CNT_11_t                INFO_FF_CNT_11;                /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  SATURN_L2FE_L2E_INFO_FF_CNT_12_t                INFO_FF_CNT_12;                /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  SATURN_L2FE_L2E_INFO_FF_CNT_13_t                INFO_FF_CNT_13;                /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  SATURN_L2FE_L2E_INFO_FF_CNT_14_t                INFO_FF_CNT_14;                /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  SATURN_L2FE_L2E_INFO_FF_CNT_15_t                INFO_FF_CNT_15;                /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];                   
  SATURN_L2FE_L2E_L3FE_RFSH_STS_t                 L3FE_RFSH_STS;                 /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];                   
  SATURN_L2FE_L2E_DEBUG_BUS_t                     DEBUG_BUS;                     /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];                   
  SATURN_L2FE_L2E_FDB_ACCESS_t                    FDB_ACCESS;                    /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];                   
  SATURN_L2FE_L2E_FDB_DATA3_t                     FDB_DATA3;                     /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];                   
  SATURN_L2FE_L2E_FDB_DATA2_t                     FDB_DATA2;                     /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd44[3];                   
  SATURN_L2FE_L2E_FDB_DATA1_t                     FDB_DATA1;                     /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd45[3];                   
  SATURN_L2FE_L2E_FDB_DATA0_t                     FDB_DATA0;                     /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd46[3];                   
  SATURN_L2FE_L2E_PORT_MAC_CNT_LMT_ACCESS_t       PORT_MAC_CNT_LMT_ACCESS;       /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd47[3];                   
  SATURN_L2FE_L2E_PORT_MAC_CNT_LMT_DATA_t         PORT_MAC_CNT_LMT_DATA;         /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd48[3];                   
  SATURN_L2FE_L2E_AGING_CTRL_EXT_t                AGING_CTRL_EXT;                /* addr: 0x000000c0 */
} SATURN_APB0_L2FE_L2E_t;


/*
 * IM3E
 */
        
#define  SATURN_L2FE_IM3E_CTRL                           0xd0001e00
#define  SATURN_L2FE_IM3E_CTRL_dft                       0x000000e4

typedef volatile union {
  struct {
    ca_uint32_t da_use_l2_addr       :  1 ; /* bits 0:0 */
    ca_uint32_t sa_use_l2_addr       :  1 ; /* bits 1:1 */
    ca_uint32_t use_l3mc_lkup        :  1 ; /* bits 2:2 */
    ca_uint32_t igmp_no_vlan_srch    :  1 ; /* bits 3:3 */
    ca_uint32_t mld_no_vlan_srch     :  1 ; /* bits 4:4 */
    ca_uint32_t mcu_oprt_mode        :  1 ; /* bits 5:5 */
    ca_uint32_t igmp_no_port_src_srch :  1 ; /* bits 6:6 */
    ca_uint32_t mld_no_port_src_srch :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_IM3E_CTRL_t;


#define  SATURN_L2FE_IM3E_MLDDA_TBL_INDRCT_ACCESS        0xd0001e04
#define  SATURN_L2FE_IM3E_MLDDA_TBL_INDRCT_ACCESS_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vld_entries_num      :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_IM3E_MLDDA_TBL_INDRCT_ACCESS_t;


#define  SATURN_L2FE_IM3E_MLDSA_TBL_INDRCT_ACCESS        0xd0001e08
#define  SATURN_L2FE_IM3E_MLDSA_TBL_INDRCT_ACCESS_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vld_entries_num      :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_IM3E_MLDSA_TBL_INDRCT_ACCESS_t;


#define  SATURN_L2FE_IM3E_STTS1                          0xd0001e0c
#define  SATURN_L2FE_IM3E_STTS1_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t da_cmd_oprt_incmpted :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_IM3E_STTS1_t;


#define  SATURN_L2FE_IM3E_STTS2                          0xd0001e10
#define  SATURN_L2FE_IM3E_STTS2_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sa_cmd_oprt_incmpted :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_IM3E_STTS2_t;


#define  SATURN_L2FE_IM3E_DEBUG                          0xd0001e14
#define  SATURN_L2FE_IM3E_DEBUG_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bus_sel              :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_IM3E_DEBUG_t;


#define  SATURN_L2FE_IM3E_MLDDA_ACCESS                   0xd0001e18
#define  SATURN_L2FE_IM3E_MLDDA_ACCESS_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_IM3E_MLDDA_ACCESS_t;


#define  SATURN_L2FE_IM3E_MLDDA_DATA5                    0xd0001e1c
#define  SATURN_L2FE_IM3E_MLDDA_DATA5_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vid                  :  1 ; /* bits 0:0 */
    ca_uint32_t vlan_sc_ind          :  1 ; /* bits 1:1 */
    ca_uint32_t wan_ind              :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_IM3E_MLDDA_DATA5_t;


#define  SATURN_L2FE_IM3E_MLDDA_DATA4                    0xd0001e20
#define  SATURN_L2FE_IM3E_MLDDA_DATA4_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ip_da                : 20 ; /* bits 19:0 */
    ca_uint32_t ipv6_flg             :  1 ; /* bits 20:20 */
    ca_uint32_t vid                  : 11 ; /* bits 31:21 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_IM3E_MLDDA_DATA4_t;


#define  SATURN_L2FE_IM3E_MLDDA_DATA3                    0xd0001e24
#define  SATURN_L2FE_IM3E_MLDDA_DATA3_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ip_da                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_IM3E_MLDDA_DATA3_t;


#define  SATURN_L2FE_IM3E_MLDDA_DATA2                    0xd0001e28
#define  SATURN_L2FE_IM3E_MLDDA_DATA2_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ip_da                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_IM3E_MLDDA_DATA2_t;


#define  SATURN_L2FE_IM3E_MLDDA_DATA1                    0xd0001e2c
#define  SATURN_L2FE_IM3E_MLDDA_DATA1_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ip_da                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_IM3E_MLDDA_DATA1_t;


#define  SATURN_L2FE_IM3E_MLDDA_DATA0                    0xd0001e30
#define  SATURN_L2FE_IM3E_MLDDA_DATA0_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t entry_valid          :  1 ; /* bits 0:0 */
    ca_uint32_t mc_group_id          : 10 ; /* bits 10:1 */
    ca_uint32_t v3_ind               :  1 ; /* bits 11:11 */
    ca_uint32_t connection_id        :  8 ; /* bits 19:12 */
    ca_uint32_t ip_da                : 12 ; /* bits 31:20 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_IM3E_MLDDA_DATA0_t;


#define  SATURN_L2FE_IM3E_MLDSA_ACCESS                   0xd0001e34
#define  SATURN_L2FE_IM3E_MLDSA_ACCESS_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_IM3E_MLDSA_ACCESS_t;


#define  SATURN_L2FE_IM3E_MLDSA_DATA4                    0xd0001e38
#define  SATURN_L2FE_IM3E_MLDSA_DATA4_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ipv6_sa              : 11 ; /* bits 10:0 */
    ca_uint32_t connection_id        :  8 ; /* bits 18:11 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_IM3E_MLDSA_DATA4_t;


#define  SATURN_L2FE_IM3E_MLDSA_DATA3                    0xd0001e3c
#define  SATURN_L2FE_IM3E_MLDSA_DATA3_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ipv6_sa              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_IM3E_MLDSA_DATA3_t;


#define  SATURN_L2FE_IM3E_MLDSA_DATA2                    0xd0001e40
#define  SATURN_L2FE_IM3E_MLDSA_DATA2_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ipv6_sa              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_IM3E_MLDSA_DATA2_t;


#define  SATURN_L2FE_IM3E_MLDSA_DATA1                    0xd0001e44
#define  SATURN_L2FE_IM3E_MLDSA_DATA1_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ipv6_sa              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_IM3E_MLDSA_DATA1_t;


#define  SATURN_L2FE_IM3E_MLDSA_DATA0                    0xd0001e48
#define  SATURN_L2FE_IM3E_MLDSA_DATA0_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t entry_valid          :  1 ; /* bits 0:0 */
    ca_uint32_t mc_group_id          : 10 ; /* bits 10:1 */
    ca_uint32_t ipv6_sa              : 21 ; /* bits 31:11 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_IM3E_MLDSA_DATA0_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* IM3E */
typedef struct {
  SATURN_L2FE_IM3E_CTRL_t                         CTRL;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_L2FE_IM3E_MLDDA_TBL_INDRCT_ACCESS_t      MLDDA_TBL_INDRCT_ACCESS;       /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_L2FE_IM3E_MLDSA_TBL_INDRCT_ACCESS_t      MLDSA_TBL_INDRCT_ACCESS;       /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_L2FE_IM3E_STTS1_t                        STTS1;                         /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_L2FE_IM3E_STTS2_t                        STTS2;                         /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_L2FE_IM3E_DEBUG_t                        _DEBUG;                        /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_L2FE_IM3E_MLDDA_ACCESS_t                 MLDDA_ACCESS;                  /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  SATURN_L2FE_IM3E_MLDDA_DATA5_t                  MLDDA_DATA5;                   /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  SATURN_L2FE_IM3E_MLDDA_DATA4_t                  MLDDA_DATA4;                   /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  SATURN_L2FE_IM3E_MLDDA_DATA3_t                  MLDDA_DATA3;                   /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  SATURN_L2FE_IM3E_MLDDA_DATA2_t                  MLDDA_DATA2;                   /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  SATURN_L2FE_IM3E_MLDDA_DATA1_t                  MLDDA_DATA1;                   /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  SATURN_L2FE_IM3E_MLDDA_DATA0_t                  MLDDA_DATA0;                   /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  SATURN_L2FE_IM3E_MLDSA_ACCESS_t                 MLDSA_ACCESS;                  /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  SATURN_L2FE_IM3E_MLDSA_DATA4_t                  MLDSA_DATA4;                   /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  SATURN_L2FE_IM3E_MLDSA_DATA3_t                  MLDSA_DATA3;                   /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  SATURN_L2FE_IM3E_MLDSA_DATA2_t                  MLDSA_DATA2;                   /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  SATURN_L2FE_IM3E_MLDSA_DATA1_t                  MLDSA_DATA1;                   /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  SATURN_L2FE_IM3E_MLDSA_DATA0_t                  MLDSA_DATA0;                   /* addr: 0x00000048 */
} SATURN_APB0_L2FE_IM3E_t;


/*
 * MIRE
 */
        
#define  SATURN_L2FE_MIRE_MIR_CTRL                       0xd0001f00
#define  SATURN_L2FE_MIRE_MIR_CTRL_dft                   0x00000001

typedef volatile union {
  struct {
    ca_uint32_t pkt_drop_src_mir_en  :  1 ; /* bits 0:0 */
    ca_uint32_t pkt_keep_old         :  1 ; /* bits 1:1 */
    ca_uint32_t lspid_remap          :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_MIRE_MIR_CTRL_t;


#define  SATURN_L2FE_MIRE_MIR_RULE_SSID_0                0xd0001f04
#define  SATURN_L2FE_MIRE_MIR_RULE_SSID_0_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t flowid               :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t ldpid                :  6 ; /* bits 15:10 */
    ca_uint32_t lspid                :  6 ; /* bits 21:16 */
    ca_uint32_t mode                 :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd2               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_MIRE_MIR_RULE_SSID_0_t;


#define  SATURN_L2FE_MIRE_MIR_RULE_SSID_1                0xd0001f08
#define  SATURN_L2FE_MIRE_MIR_RULE_SSID_1_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t flowid               :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t ldpid                :  6 ; /* bits 15:10 */
    ca_uint32_t lspid                :  6 ; /* bits 21:16 */
    ca_uint32_t mode                 :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd2               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_MIRE_MIR_RULE_SSID_1_t;


#define  SATURN_L2FE_MIRE_MIR_RULE_SSID_2                0xd0001f0c
#define  SATURN_L2FE_MIRE_MIR_RULE_SSID_2_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t flowid               :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t ldpid                :  6 ; /* bits 15:10 */
    ca_uint32_t lspid                :  6 ; /* bits 21:16 */
    ca_uint32_t mode                 :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd2               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_MIRE_MIR_RULE_SSID_2_t;


#define  SATURN_L2FE_MIRE_MIR_RULE_SSID_3                0xd0001f10
#define  SATURN_L2FE_MIRE_MIR_RULE_SSID_3_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t flowid               :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t ldpid                :  6 ; /* bits 15:10 */
    ca_uint32_t lspid                :  6 ; /* bits 21:16 */
    ca_uint32_t mode                 :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd2               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_MIRE_MIR_RULE_SSID_3_t;


#define  SATURN_L2FE_MIRE_MIR_ACT_0_SSID_0               0xd0001f14
#define  SATURN_L2FE_MIRE_MIR_ACT_0_SSID_0_dft           0x0000433a

typedef volatile union {
  struct {
    ca_uint32_t lspid                :  6 ; /* bits 5:0 */
    ca_uint32_t pspid                :  4 ; /* bits 9:6 */
    ca_uint32_t ldpid                :  6 ; /* bits 15:10 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_MIRE_MIR_ACT_0_SSID_0_t;


#define  SATURN_L2FE_MIRE_MIR_ACT_0_SSID_1               0xd0001f18
#define  SATURN_L2FE_MIRE_MIR_ACT_0_SSID_1_dft           0x0000437b

typedef volatile union {
  struct {
    ca_uint32_t lspid                :  6 ; /* bits 5:0 */
    ca_uint32_t pspid                :  4 ; /* bits 9:6 */
    ca_uint32_t ldpid                :  6 ; /* bits 15:10 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_MIRE_MIR_ACT_0_SSID_1_t;


#define  SATURN_L2FE_MIRE_MIR_ACT_0_SSID_2               0xd0001f1c
#define  SATURN_L2FE_MIRE_MIR_ACT_0_SSID_2_dft           0x000043bc

typedef volatile union {
  struct {
    ca_uint32_t lspid                :  6 ; /* bits 5:0 */
    ca_uint32_t pspid                :  4 ; /* bits 9:6 */
    ca_uint32_t ldpid                :  6 ; /* bits 15:10 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_MIRE_MIR_ACT_0_SSID_2_t;


#define  SATURN_L2FE_MIRE_MIR_ACT_0_SSID_3               0xd0001f20
#define  SATURN_L2FE_MIRE_MIR_ACT_0_SSID_3_dft           0x000043fd

typedef volatile union {
  struct {
    ca_uint32_t lspid                :  6 ; /* bits 5:0 */
    ca_uint32_t pspid                :  4 ; /* bits 9:6 */
    ca_uint32_t ldpid                :  6 ; /* bits 15:10 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_MIRE_MIR_ACT_0_SSID_3_t;


#define  SATURN_L2FE_MIRE_MIR_ACT_1_SSID_0               0xd0001f24
#define  SATURN_L2FE_MIRE_MIR_ACT_1_SSID_0_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dot1p                :  3 ; /* bits 2:0 */
    ca_uint32_t sc_ind               :  1 ; /* bits 3:3 */
    ca_uint32_t vid                  : 12 ; /* bits 15:4 */
    ca_uint32_t vlan_cmd             :  1 ; /* bits 16:16 */
    ca_uint32_t cos_vld              :  1 ; /* bits 17:17 */
    ca_uint32_t cos                  :  3 ; /* bits 20:18 */
    ca_uint32_t sv_tpid_sel          :  2 ; /* bits 22:21 */
    ca_uint32_t cv_tpid_sel          :  2 ; /* bits 24:23 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_MIRE_MIR_ACT_1_SSID_0_t;


#define  SATURN_L2FE_MIRE_MIR_ACT_1_SSID_1               0xd0001f28
#define  SATURN_L2FE_MIRE_MIR_ACT_1_SSID_1_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dot1p                :  3 ; /* bits 2:0 */
    ca_uint32_t sc_ind               :  1 ; /* bits 3:3 */
    ca_uint32_t vid                  : 12 ; /* bits 15:4 */
    ca_uint32_t vlan_cmd             :  1 ; /* bits 16:16 */
    ca_uint32_t cos_vld              :  1 ; /* bits 17:17 */
    ca_uint32_t cos                  :  3 ; /* bits 20:18 */
    ca_uint32_t sv_tpid_sel          :  2 ; /* bits 22:21 */
    ca_uint32_t cv_tpid_sel          :  2 ; /* bits 24:23 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_MIRE_MIR_ACT_1_SSID_1_t;


#define  SATURN_L2FE_MIRE_MIR_ACT_1_SSID_2               0xd0001f2c
#define  SATURN_L2FE_MIRE_MIR_ACT_1_SSID_2_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dot1p                :  3 ; /* bits 2:0 */
    ca_uint32_t sc_ind               :  1 ; /* bits 3:3 */
    ca_uint32_t vid                  : 12 ; /* bits 15:4 */
    ca_uint32_t vlan_cmd             :  1 ; /* bits 16:16 */
    ca_uint32_t cos_vld              :  1 ; /* bits 17:17 */
    ca_uint32_t cos                  :  3 ; /* bits 20:18 */
    ca_uint32_t sv_tpid_sel          :  2 ; /* bits 22:21 */
    ca_uint32_t cv_tpid_sel          :  2 ; /* bits 24:23 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_MIRE_MIR_ACT_1_SSID_2_t;


#define  SATURN_L2FE_MIRE_MIR_ACT_1_SSID_3               0xd0001f30
#define  SATURN_L2FE_MIRE_MIR_ACT_1_SSID_3_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dot1p                :  3 ; /* bits 2:0 */
    ca_uint32_t sc_ind               :  1 ; /* bits 3:3 */
    ca_uint32_t vid                  : 12 ; /* bits 15:4 */
    ca_uint32_t vlan_cmd             :  1 ; /* bits 16:16 */
    ca_uint32_t cos_vld              :  1 ; /* bits 17:17 */
    ca_uint32_t cos                  :  3 ; /* bits 20:18 */
    ca_uint32_t sv_tpid_sel          :  2 ; /* bits 22:21 */
    ca_uint32_t cv_tpid_sel          :  2 ; /* bits 24:23 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_MIRE_MIR_ACT_1_SSID_3_t;


#define  SATURN_L2FE_MIRE_MIR_STTS_0                     0xd0001f34
#define  SATURN_L2FE_MIRE_MIR_STTS_0_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pspid_vld            :  1 ; /* bits 0:0 */
    ca_uint32_t pspid                :  4 ; /* bits 4:1 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_MIRE_MIR_STTS_0_t;


#define  SATURN_L2FE_MIRE_MIR_STTS_1                     0xd0001f38
#define  SATURN_L2FE_MIRE_MIR_STTS_1_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pspid_vld            :  1 ; /* bits 0:0 */
    ca_uint32_t pspid                :  4 ; /* bits 4:1 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_MIRE_MIR_STTS_1_t;


#define  SATURN_L2FE_MIRE_MIR_STTS_2                     0xd0001f3c
#define  SATURN_L2FE_MIRE_MIR_STTS_2_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pspid_vld            :  1 ; /* bits 0:0 */
    ca_uint32_t pspid                :  4 ; /* bits 4:1 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_MIRE_MIR_STTS_2_t;


#define  SATURN_L2FE_MIRE_MIR_STTS_3                     0xd0001f40
#define  SATURN_L2FE_MIRE_MIR_STTS_3_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pspid_vld            :  1 ; /* bits 0:0 */
    ca_uint32_t pspid                :  4 ; /* bits 4:1 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_MIRE_MIR_STTS_3_t;


#define  SATURN_L2FE_MIRE_PINGPONG_STS                   0xd0001f44
#define  SATURN_L2FE_MIRE_PINGPONG_STS_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ovfl                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_MIRE_PINGPONG_STS_t;


#define  SATURN_L2FE_MIRE_DATA_FIFO_CNT                  0xd0001f48
#define  SATURN_L2FE_MIRE_DATA_FIFO_CNT_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t entry_cnt            :  7 ; /* bits 6:0 */
    ca_uint32_t seg_cnt              :  4 ; /* bits 10:7 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t extra_store_cnt      :  2 ; /* bits 17:16 */
    ca_uint32_t data_ltched          :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd2               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_MIRE_DATA_FIFO_CNT_t;


#define  SATURN_L2FE_MIRE_DATA_FIFO_STTS                 0xd0001f4c
#define  SATURN_L2FE_MIRE_DATA_FIFO_STTS_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ovfl                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_MIRE_DATA_FIFO_STTS_t;


#define  SATURN_L2FE_MIRE_DEBUG                          0xd0001f50
#define  SATURN_L2FE_MIRE_DEBUG_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sel                  :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2FE_MIRE_DEBUG_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* MIRE */
typedef struct {
  SATURN_L2FE_MIRE_MIR_CTRL_t                     MIR_CTRL;                      /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_L2FE_MIRE_MIR_RULE_SSID_0_t              MIR_RULE_SSID_0;               /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_L2FE_MIRE_MIR_RULE_SSID_1_t              MIR_RULE_SSID_1;               /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_L2FE_MIRE_MIR_RULE_SSID_2_t              MIR_RULE_SSID_2;               /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_L2FE_MIRE_MIR_RULE_SSID_3_t              MIR_RULE_SSID_3;               /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_L2FE_MIRE_MIR_ACT_0_SSID_0_t             MIR_ACT_0_SSID_0;              /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_L2FE_MIRE_MIR_ACT_0_SSID_1_t             MIR_ACT_0_SSID_1;              /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  SATURN_L2FE_MIRE_MIR_ACT_0_SSID_2_t             MIR_ACT_0_SSID_2;              /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  SATURN_L2FE_MIRE_MIR_ACT_0_SSID_3_t             MIR_ACT_0_SSID_3;              /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  SATURN_L2FE_MIRE_MIR_ACT_1_SSID_0_t             MIR_ACT_1_SSID_0;              /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  SATURN_L2FE_MIRE_MIR_ACT_1_SSID_1_t             MIR_ACT_1_SSID_1;              /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  SATURN_L2FE_MIRE_MIR_ACT_1_SSID_2_t             MIR_ACT_1_SSID_2;              /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  SATURN_L2FE_MIRE_MIR_ACT_1_SSID_3_t             MIR_ACT_1_SSID_3;              /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  SATURN_L2FE_MIRE_MIR_STTS_0_t                   MIR_STTS_0;                    /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  SATURN_L2FE_MIRE_MIR_STTS_1_t                   MIR_STTS_1;                    /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  SATURN_L2FE_MIRE_MIR_STTS_2_t                   MIR_STTS_2;                    /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  SATURN_L2FE_MIRE_MIR_STTS_3_t                   MIR_STTS_3;                    /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  SATURN_L2FE_MIRE_PINGPONG_STS_t                 PINGPONG_STS;                  /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  SATURN_L2FE_MIRE_DATA_FIFO_CNT_t                DATA_FIFO_CNT;                 /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  SATURN_L2FE_MIRE_DATA_FIFO_STTS_t               DATA_FIFO_STTS;                /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  SATURN_L2FE_MIRE_DEBUG_t                        _DEBUG;                        /* addr: 0x00000050 */
} SATURN_APB0_L2FE_MIRE_t;

    
  
        
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* L2FE */

typedef struct {
  SATURN_APB0_L2FE_GLB_t                          GLB;                           /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[241];                  
  SATURN_APB0_L2FE_PP_t                           PP;                            /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd2[379];                  
  SATURN_APB0_L2FE_PLA_t                          PLA;                           /* addr: 0x00000300 */
  ca_uint32_t                              rsrvd3[239];                  
  SATURN_APB0_L2FE_PLC_t                          PLC;                           /* addr: 0x00000400 */
  ca_uint32_t                              rsrvd4[237];                  
  SATURN_APB0_L2FE_PLE_t                          PLE;                           /* addr: 0x00000500 */
  ca_uint32_t                              rsrvd5[201];                  
  SATURN_APB0_L2FE_ARB_t                          ARB;                           /* addr: 0x00000600 */
  ca_uint32_t                              rsrvd6[213];                  
  SATURN_APB0_L2FE_PE_t                           PE;                            /* addr: 0x00000700 */
  ca_uint32_t                              rsrvd7[465];                  
  SATURN_APB0_L2FE_LF_t                           LF;                            /* addr: 0x00000900 */
  ca_uint32_t                              rsrvd8[249];                  
  SATURN_APB0_L2FE_VE_t                           VE;                            /* addr: 0x00000a00 */
  ca_uint32_t                              rsrvd9[213];                  
  SATURN_APB0_L2FE_CLE_t                          CLE;                           /* addr: 0x00000b00 */
  ca_uint32_t                              rsrvd10[169];                 
  SATURN_APB0_L2FE_L2E_t                          L2E;                           /* addr: 0x00000c00 */
  ca_uint32_t                              rsrvd11[415];                 
  SATURN_APB0_L2FE_IM3E_t                         IM3E;                          /* addr: 0x00000e00 */
  ca_uint32_t                              rsrvd12[219];                 
  SATURN_APB0_L2FE_MIRE_t                         MIRE;                          /* addr: 0x00000f00 */
} SATURN_APB0_L2FE_t;


/*
 * L2TM
 */
  
/*
 * l2tm_glb
 */
        
#define  SATURN_L2TM_L2TM_GLB_REV_ID                     0xd0002000
#define  SATURN_L2TM_L2TM_GLB_REV_ID_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t minor                : 16 ; /* bits 15:0 */
    ca_uint32_t major                : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_GLB_REV_ID_t;


#define  SATURN_L2TM_L2TM_GLB_INT                        0xd0002004
#define  SATURN_L2TM_L2TM_GLB_INT_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bm                   :  1 ; /* bits 0:0 */
    ca_uint32_t qm                   :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_GLB_INT_t;


#define  SATURN_L2TM_L2TM_GLB_INTE                       0xd0002008
#define  SATURN_L2TM_L2TM_GLB_INTE_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bmE                  :  1 ; /* bits 0:0 */
    ca_uint32_t qmE                  :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_GLB_INTE_t;


#define  SATURN_L2TM_L2TM_GLB_STS                        0xd000200c
#define  SATURN_L2TM_L2TM_GLB_STS_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 14 ;
    ca_uint32_t voqinfo_ram_init_done :  1 ; /* bits 14:14 */
    ca_uint32_t freeq_ram_init_done  :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd2               : 14 ;
    ca_uint32_t idle                 :  1 ; /* bits 30:30 */
    ca_uint32_t init_done            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_GLB_STS_t;


#define  SATURN_L2TM_L2TM_GLB_CTRL                       0xd0002010
#define  SATURN_L2TM_L2TM_GLB_CTRL_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 31 ;
    ca_uint32_t cntrcfg_clear_on_read :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_GLB_CTRL_t;


#define  SATURN_L2TM_L2TM_GLB_SPARE_CFG                  0xd0002014
#define  SATURN_L2TM_L2TM_GLB_SPARE_CFG_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t spare                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_GLB_SPARE_CFG_t;


#define  SATURN_L2TM_L2TM_GLB_SPARE_STS                  0xd0002018
#define  SATURN_L2TM_L2TM_GLB_SPARE_STS_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t spare                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_GLB_SPARE_STS_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2tm_glb */
typedef struct {
  SATURN_L2TM_L2TM_GLB_REV_ID_t                   REV_ID;                        /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_L2TM_L2TM_GLB_INT_t                      INT;                           /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_L2TM_L2TM_GLB_INTE_t                     INTE;                          /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_L2TM_L2TM_GLB_STS_t                      STS;                           /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_L2TM_L2TM_GLB_CTRL_t                     CTRL;                          /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_L2TM_L2TM_GLB_SPARE_CFG_t                SPARE_CFG;                     /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_L2TM_L2TM_GLB_SPARE_STS_t                SPARE_STS;                     /* addr: 0x00000018 */
} SATURN_APB0_L2TM_L2TM_GLB_t;


/*
 * l2tm_bm
 */
        
#define  SATURN_L2TM_L2TM_BM_INT                         0xd0002100
#define  SATURN_L2TM_L2TM_BM_INT_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sb_drop              :  1 ; /* bits 0:0 */
    ca_uint32_t hdr_drop             :  1 ; /* bits 1:1 */
    ca_uint32_t te_drop              :  1 ; /* bits 2:2 */
    ca_uint32_t wvoqid               :  1 ; /* bits 3:3 */
    ca_uint32_t szerr                :  1 ; /* bits 4:4 */
    ca_uint32_t seglenerr            :  1 ; /* bits 5:5 */
    ca_uint32_t seq_err              :  1 ; /* bits 6:6 */
    ca_uint32_t fc_mirror_drop       :  1 ; /* bits 7:7 */
    ca_uint32_t dq_sb_drop           :  1 ; /* bits 8:8 */
    ca_uint32_t dq_hdr_drop          :  1 ; /* bits 9:9 */
    ca_uint32_t dq_wvoqid            :  1 ; /* bits 10:10 */
    ca_uint32_t dq_szerr             :  1 ; /* bits 11:11 */
    ca_uint32_t dq_seglenerr         :  1 ; /* bits 12:12 */
    ca_uint32_t dq_seq_err           :  1 ; /* bits 13:13 */
    ca_uint32_t dq_ff_undrflo        :  1 ; /* bits 14:14 */
    ca_uint32_t dq_ff_ovrflo         :  1 ; /* bits 15:15 */
    ca_uint32_t dq_pack_ff_undrflo   :  1 ; /* bits 16:16 */
    ca_uint32_t dq_pack_ff_ovrflo    :  1 ; /* bits 17:17 */
    ca_uint32_t fe_ff_undrflo        :  1 ; /* bits 18:18 */
    ca_uint32_t fe_ff_ovrflo         :  1 ; /* bits 19:19 */
    ca_uint32_t pack_ff_undrflo      :  1 ; /* bits 20:20 */
    ca_uint32_t pack_ff_ovrflo       :  1 ; /* bits 21:21 */
    ca_uint32_t wdat_ff_undrflo      :  1 ; /* bits 22:22 */
    ca_uint32_t wdat_ff_ovrflo       :  1 ; /* bits 23:23 */
    ca_uint32_t wcmd_ff_undrflo      :  1 ; /* bits 24:24 */
    ca_uint32_t wcmd_ff_ovrflo       :  1 ; /* bits 25:25 */
    ca_uint32_t rdat_ff_undrflo      :  1 ; /* bits 26:26 */
    ca_uint32_t rdat_ff_ovrflo       :  1 ; /* bits 27:27 */
    ca_uint32_t rcmd_ff_undrflo      :  1 ; /* bits 28:28 */
    ca_uint32_t rcmd_ff_ovrflo       :  1 ; /* bits 29:29 */
    ca_uint32_t rcyc_ff_undrflo      :  1 ; /* bits 30:30 */
    ca_uint32_t rcyc_ff_ovrflo       :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_INT_t;


#define  SATURN_L2TM_L2TM_BM_INTE                        0xd0002104
#define  SATURN_L2TM_L2TM_BM_INTE_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sb_dropE             :  1 ; /* bits 0:0 */
    ca_uint32_t hdr_dropE            :  1 ; /* bits 1:1 */
    ca_uint32_t te_dropE             :  1 ; /* bits 2:2 */
    ca_uint32_t wvoqidE              :  1 ; /* bits 3:3 */
    ca_uint32_t szerrE               :  1 ; /* bits 4:4 */
    ca_uint32_t seglenerrE           :  1 ; /* bits 5:5 */
    ca_uint32_t seq_errE             :  1 ; /* bits 6:6 */
    ca_uint32_t fc_mirror_dropE      :  1 ; /* bits 7:7 */
    ca_uint32_t dq_sb_dropE          :  1 ; /* bits 8:8 */
    ca_uint32_t dq_hdr_dropE         :  1 ; /* bits 9:9 */
    ca_uint32_t dq_wvoqidE           :  1 ; /* bits 10:10 */
    ca_uint32_t dq_szerrE            :  1 ; /* bits 11:11 */
    ca_uint32_t dq_seglenerrE        :  1 ; /* bits 12:12 */
    ca_uint32_t dq_seq_errE          :  1 ; /* bits 13:13 */
    ca_uint32_t dq_ff_undrfloE       :  1 ; /* bits 14:14 */
    ca_uint32_t dq_ff_ovrfloE        :  1 ; /* bits 15:15 */
    ca_uint32_t dq_pack_ff_undrfloE  :  1 ; /* bits 16:16 */
    ca_uint32_t dq_pack_ff_ovrfloE   :  1 ; /* bits 17:17 */
    ca_uint32_t fe_ff_undrfloE       :  1 ; /* bits 18:18 */
    ca_uint32_t fe_ff_ovrfloE        :  1 ; /* bits 19:19 */
    ca_uint32_t pack_ff_undrfloE     :  1 ; /* bits 20:20 */
    ca_uint32_t pack_ff_ovrfloE      :  1 ; /* bits 21:21 */
    ca_uint32_t wdat_ff_undrfloE     :  1 ; /* bits 22:22 */
    ca_uint32_t wdat_ff_ovrfloE      :  1 ; /* bits 23:23 */
    ca_uint32_t wcmd_ff_undrfloE     :  1 ; /* bits 24:24 */
    ca_uint32_t wcmd_ff_ovrfloE      :  1 ; /* bits 25:25 */
    ca_uint32_t rdat_ff_undrfloE     :  1 ; /* bits 26:26 */
    ca_uint32_t rdat_ff_ovrfloE      :  1 ; /* bits 27:27 */
    ca_uint32_t rcmd_ff_undrfloE     :  1 ; /* bits 28:28 */
    ca_uint32_t rcmd_ff_ovrfloE      :  1 ; /* bits 29:29 */
    ca_uint32_t rcyc_ff_undrfloE     :  1 ; /* bits 30:30 */
    ca_uint32_t rcyc_ff_ovrfloE      :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_INTE_t;


#define  SATURN_L2TM_L2TM_BM_CTRL                        0xd0002108
#define  SATURN_L2TM_L2TM_BM_CTRL_dft                    0xc0000000

typedef volatile union {
  struct {
    ca_uint32_t rx_drop_cos          :  3 ; /* bits 2:0 */
    ca_uint32_t rx_drop_pid          :  4 ; /* bits 6:3 */
    ca_uint32_t rx_drop_en           :  2 ; /* bits 8:7 */
    ca_uint32_t sb_drop_dis          :  1 ; /* bits 9:9 */
    ca_uint32_t hdr_drop_code_upd_en :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd1               : 13 ;
    ca_uint32_t min_pktlen           :  7 ; /* bits 30:24 */
    ca_uint32_t rx_en                :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_CTRL_t;


#define  SATURN_L2TM_L2TM_BM_TM_TO_9THQ_QUEUE_MAP        0xd000210c
#define  SATURN_L2TM_L2TM_BM_TM_TO_9THQ_QUEUE_MAP_dft    0x76543210

typedef volatile union {
  struct {
    ca_uint32_t qsel_0               :  3 ; /* bits 2:0 */
    ca_uint32_t flag_0               :  1 ; /* bits 3:3 */
    ca_uint32_t qsel_1               :  3 ; /* bits 6:4 */
    ca_uint32_t flag_1               :  1 ; /* bits 7:7 */
    ca_uint32_t qsel_2               :  3 ; /* bits 10:8 */
    ca_uint32_t flag_2               :  1 ; /* bits 11:11 */
    ca_uint32_t qsel_3               :  3 ; /* bits 14:12 */
    ca_uint32_t flag_3               :  1 ; /* bits 15:15 */
    ca_uint32_t qsel_4               :  3 ; /* bits 18:16 */
    ca_uint32_t flag_4               :  1 ; /* bits 19:19 */
    ca_uint32_t qsel_5               :  3 ; /* bits 22:20 */
    ca_uint32_t flag_5               :  1 ; /* bits 23:23 */
    ca_uint32_t qsel_6               :  3 ; /* bits 26:24 */
    ca_uint32_t flag_6               :  1 ; /* bits 27:27 */
    ca_uint32_t qsel_7               :  3 ; /* bits 30:28 */
    ca_uint32_t flag_7               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_TM_TO_9THQ_QUEUE_MAP_t;


#define  SATURN_L2TM_L2TM_BM_TM_TO_CPUQ_QUEUE_MAP        0xd0002110
#define  SATURN_L2TM_L2TM_BM_TM_TO_CPUQ_QUEUE_MAP_dft    0x76543210

typedef volatile union {
  struct {
    ca_uint32_t qsel_0               :  3 ; /* bits 2:0 */
    ca_uint32_t flag_0               :  1 ; /* bits 3:3 */
    ca_uint32_t qsel_1               :  3 ; /* bits 6:4 */
    ca_uint32_t flag_1               :  1 ; /* bits 7:7 */
    ca_uint32_t qsel_2               :  3 ; /* bits 10:8 */
    ca_uint32_t flag_2               :  1 ; /* bits 11:11 */
    ca_uint32_t qsel_3               :  3 ; /* bits 14:12 */
    ca_uint32_t flag_3               :  1 ; /* bits 15:15 */
    ca_uint32_t qsel_4               :  3 ; /* bits 18:16 */
    ca_uint32_t flag_4               :  1 ; /* bits 19:19 */
    ca_uint32_t qsel_5               :  3 ; /* bits 22:20 */
    ca_uint32_t flag_5               :  1 ; /* bits 23:23 */
    ca_uint32_t qsel_6               :  3 ; /* bits 26:24 */
    ca_uint32_t flag_6               :  1 ; /* bits 27:27 */
    ca_uint32_t qsel_7               :  3 ; /* bits 30:28 */
    ca_uint32_t flag_7               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_TM_TO_CPUQ_QUEUE_MAP_t;


#define  SATURN_L2TM_L2TM_BM_TM_TO_CPU256Q_QUEUE_MAP     0xd0002114
#define  SATURN_L2TM_L2TM_BM_TM_TO_CPU256Q_QUEUE_MAP_dft 0x00000076

typedef volatile union {
  struct {
    ca_uint32_t qsel_0               :  3 ; /* bits 2:0 */
    ca_uint32_t flag_0               :  1 ; /* bits 3:3 */
    ca_uint32_t qsel_1               :  3 ; /* bits 6:4 */
    ca_uint32_t flag_1               :  1 ; /* bits 7:7 */
    ca_uint32_t rxpfc_0              :  1 ; /* bits 8:8 */
    ca_uint32_t rxpfc_1              :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_TM_TO_CPU256Q_QUEUE_MAP_t;


#define  SATURN_L2TM_L2TM_BM_TM_TO_DQ_QUEUE_MAP          0xd0002118
#define  SATURN_L2TM_L2TM_BM_TM_TO_DQ_QUEUE_MAP_dft      0x76543210

typedef volatile union {
  struct {
    ca_uint32_t qsel_0               :  3 ; /* bits 2:0 */
    ca_uint32_t flag_0               :  1 ; /* bits 3:3 */
    ca_uint32_t qsel_1               :  3 ; /* bits 6:4 */
    ca_uint32_t flag_1               :  1 ; /* bits 7:7 */
    ca_uint32_t qsel_2               :  3 ; /* bits 10:8 */
    ca_uint32_t flag_2               :  1 ; /* bits 11:11 */
    ca_uint32_t qsel_3               :  3 ; /* bits 14:12 */
    ca_uint32_t flag_3               :  1 ; /* bits 15:15 */
    ca_uint32_t qsel_4               :  3 ; /* bits 18:16 */
    ca_uint32_t flag_4               :  1 ; /* bits 19:19 */
    ca_uint32_t qsel_5               :  3 ; /* bits 22:20 */
    ca_uint32_t flag_5               :  1 ; /* bits 23:23 */
    ca_uint32_t qsel_6               :  3 ; /* bits 26:24 */
    ca_uint32_t flag_6               :  1 ; /* bits 27:27 */
    ca_uint32_t qsel_7               :  3 ; /* bits 30:28 */
    ca_uint32_t flag_7               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_TM_TO_DQ_QUEUE_MAP_t;


#define  SATURN_L2TM_L2TM_BM_DQ_TO_TM_QUEUE_MAP          0xd000211c
#define  SATURN_L2TM_L2TM_BM_DQ_TO_TM_QUEUE_MAP_dft      0x76543210

typedef volatile union {
  struct {
    ca_uint32_t qsel_0               :  3 ; /* bits 2:0 */
    ca_uint32_t flag_0               :  1 ; /* bits 3:3 */
    ca_uint32_t qsel_1               :  3 ; /* bits 6:4 */
    ca_uint32_t flag_1               :  1 ; /* bits 7:7 */
    ca_uint32_t qsel_2               :  3 ; /* bits 10:8 */
    ca_uint32_t flag_2               :  1 ; /* bits 11:11 */
    ca_uint32_t qsel_3               :  3 ; /* bits 14:12 */
    ca_uint32_t flag_3               :  1 ; /* bits 15:15 */
    ca_uint32_t qsel_4               :  3 ; /* bits 18:16 */
    ca_uint32_t flag_4               :  1 ; /* bits 19:19 */
    ca_uint32_t qsel_5               :  3 ; /* bits 22:20 */
    ca_uint32_t flag_5               :  1 ; /* bits 23:23 */
    ca_uint32_t qsel_6               :  3 ; /* bits 26:24 */
    ca_uint32_t flag_6               :  1 ; /* bits 27:27 */
    ca_uint32_t qsel_7               :  3 ; /* bits 30:28 */
    ca_uint32_t flag_7               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_DQ_TO_TM_QUEUE_MAP_t;


#define  SATURN_L2TM_L2TM_BM_DQ_TO_TM_PORT_MAP           0xd0002120
#define  SATURN_L2TM_L2TM_BM_DQ_TO_TM_PORT_MAP_dft       0x76543210

typedef volatile union {
  struct {
    ca_uint32_t tm_dpid_sel_0        :  4 ; /* bits 3:0 */
    ca_uint32_t tm_dpid_sel_1        :  4 ; /* bits 7:4 */
    ca_uint32_t tm_dpid_sel_2        :  4 ; /* bits 11:8 */
    ca_uint32_t tm_dpid_sel_3        :  4 ; /* bits 15:12 */
    ca_uint32_t tm_dpid_sel_4        :  4 ; /* bits 19:16 */
    ca_uint32_t tm_dpid_sel_5        :  4 ; /* bits 23:20 */
    ca_uint32_t tm_dpid_sel_6        :  4 ; /* bits 27:24 */
    ca_uint32_t tm_dpid_sel_7        :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_DQ_TO_TM_PORT_MAP_t;


#define  SATURN_L2TM_L2TM_BM_RX_DQ_PCNT                  0xd0002124
#define  SATURN_L2TM_L2TM_BM_RX_DQ_PCNT_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_RX_DQ_PCNT_t;


#define  SATURN_L2TM_L2TM_BM_RX_DQ_DPCNT                 0xd0002128
#define  SATURN_L2TM_L2TM_BM_RX_DQ_DPCNT_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_RX_DQ_DPCNT_t;


#define  SATURN_L2TM_L2TM_BM_RX_PCNT                     0xd000212c
#define  SATURN_L2TM_L2TM_BM_RX_PCNT_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_RX_PCNT_t;


#define  SATURN_L2TM_L2TM_BM_TX_PCNT                     0xd0002130
#define  SATURN_L2TM_L2TM_BM_TX_PCNT_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_TX_PCNT_t;


#define  SATURN_L2TM_L2TM_BM_SB_DPCNT                    0xd0002134
#define  SATURN_L2TM_L2TM_BM_SB_DPCNT_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_SB_DPCNT_t;


#define  SATURN_L2TM_L2TM_BM_HDR_DPCNT                   0xd0002138
#define  SATURN_L2TM_L2TM_BM_HDR_DPCNT_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_HDR_DPCNT_t;


#define  SATURN_L2TM_L2TM_BM_TE_DPCNT                    0xd000213c
#define  SATURN_L2TM_L2TM_BM_TE_DPCNT_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_TE_DPCNT_t;


#define  SATURN_L2TM_L2TM_BM_ERR_DPCNT                   0xd0002140
#define  SATURN_L2TM_L2TM_BM_ERR_DPCNT_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_ERR_DPCNT_t;


#define  SATURN_L2TM_L2TM_BM_FC_MIRROR0_DPCNT            0xd0002144
#define  SATURN_L2TM_L2TM_BM_FC_MIRROR0_DPCNT_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_FC_MIRROR0_DPCNT_t;


#define  SATURN_L2TM_L2TM_BM_FC_MIRROR1_DPCNT            0xd0002148
#define  SATURN_L2TM_L2TM_BM_FC_MIRROR1_DPCNT_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_FC_MIRROR1_DPCNT_t;


#define  SATURN_L2TM_L2TM_BM_FC_MIRROR2_DPCNT            0xd000214c
#define  SATURN_L2TM_L2TM_BM_FC_MIRROR2_DPCNT_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_FC_MIRROR2_DPCNT_t;


#define  SATURN_L2TM_L2TM_BM_FC_MIRROR3_DPCNT            0xd0002150
#define  SATURN_L2TM_L2TM_BM_FC_MIRROR3_DPCNT_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_FC_MIRROR3_DPCNT_t;


#define  SATURN_L2TM_L2TM_BM_RX_DPCNT                    0xd0002154
#define  SATURN_L2TM_L2TM_BM_RX_DPCNT_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_RX_DPCNT_t;


#define  SATURN_L2TM_L2TM_BM_NOBUF_DPCNT                 0xd0002158
#define  SATURN_L2TM_L2TM_BM_NOBUF_DPCNT_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_NOBUF_DPCNT_t;


#define  SATURN_L2TM_L2TM_BM_RX_FE_HEADER_31_0           0xd000215c
#define  SATURN_L2TM_L2TM_BM_RX_FE_HEADER_31_0_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_RX_FE_HEADER_31_0_t;


#define  SATURN_L2TM_L2TM_BM_RX_FE_HEADER_63_32          0xd0002160
#define  SATURN_L2TM_L2TM_BM_RX_FE_HEADER_63_32_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_RX_FE_HEADER_63_32_t;


#define  SATURN_L2TM_L2TM_BM_RX_NI_HEADER_31_0           0xd0002164
#define  SATURN_L2TM_L2TM_BM_RX_NI_HEADER_31_0_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_RX_NI_HEADER_31_0_t;


#define  SATURN_L2TM_L2TM_BM_RX_NI_HEADER_63_32          0xd0002168
#define  SATURN_L2TM_L2TM_BM_RX_NI_HEADER_63_32_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_RX_NI_HEADER_63_32_t;


#define  SATURN_L2TM_L2TM_BM_TX_NI_HEADER_31_0           0xd000216c
#define  SATURN_L2TM_L2TM_BM_TX_NI_HEADER_31_0_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_TX_NI_HEADER_31_0_t;


#define  SATURN_L2TM_L2TM_BM_TX_NI_HEADER_63_32          0xd0002170
#define  SATURN_L2TM_L2TM_BM_TX_NI_HEADER_63_32_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_TX_NI_HEADER_63_32_t;


#define  SATURN_L2TM_L2TM_BM_STS                         0xd0002174
#define  SATURN_L2TM_L2TM_BM_STS_dft                     0xff80000a

typedef volatile union {
  struct {
    ca_uint32_t fe_tm_vld            :  1 ; /* bits 0:0 */
    ca_uint32_t tm_fe_rdy            :  1 ; /* bits 1:1 */
    ca_uint32_t ni_tm_vld            :  1 ; /* bits 2:2 */
    ca_uint32_t tm_ni_rdy            :  1 ; /* bits 3:3 */
    ca_uint32_t tm_ni_vld            :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 18 ;
    ca_uint32_t dq_ff_empty          :  1 ; /* bits 23:23 */
    ca_uint32_t dq_pack_ff_empty     :  1 ; /* bits 24:24 */
    ca_uint32_t fe_ff_empty          :  1 ; /* bits 25:25 */
    ca_uint32_t pack_ff_empty        :  1 ; /* bits 26:26 */
    ca_uint32_t wdat_ff_empty        :  1 ; /* bits 27:27 */
    ca_uint32_t wcmd_ff_empty        :  1 ; /* bits 28:28 */
    ca_uint32_t rdat_ff_empty        :  1 ; /* bits 29:29 */
    ca_uint32_t rcmd_ff_empty        :  1 ; /* bits 30:30 */
    ca_uint32_t rcyc_ff_empty        :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_STS_t;


#define  SATURN_L2TM_L2TM_BM_PKT_MEM_ACCESS              0xd0002178
#define  SATURN_L2TM_L2TM_BM_PKT_MEM_ACCESS_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 15 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_PKT_MEM_ACCESS_t;


#define  SATURN_L2TM_L2TM_BM_PKT_MEM_DATA7               0xd000217c
#define  SATURN_L2TM_L2TM_BM_PKT_MEM_DATA7_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_PKT_MEM_DATA7_t;


#define  SATURN_L2TM_L2TM_BM_PKT_MEM_DATA6               0xd0002180
#define  SATURN_L2TM_L2TM_BM_PKT_MEM_DATA6_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_PKT_MEM_DATA6_t;


#define  SATURN_L2TM_L2TM_BM_PKT_MEM_DATA5               0xd0002184
#define  SATURN_L2TM_L2TM_BM_PKT_MEM_DATA5_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_PKT_MEM_DATA5_t;


#define  SATURN_L2TM_L2TM_BM_PKT_MEM_DATA4               0xd0002188
#define  SATURN_L2TM_L2TM_BM_PKT_MEM_DATA4_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_PKT_MEM_DATA4_t;


#define  SATURN_L2TM_L2TM_BM_PKT_MEM_DATA3               0xd000218c
#define  SATURN_L2TM_L2TM_BM_PKT_MEM_DATA3_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_PKT_MEM_DATA3_t;


#define  SATURN_L2TM_L2TM_BM_PKT_MEM_DATA2               0xd0002190
#define  SATURN_L2TM_L2TM_BM_PKT_MEM_DATA2_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_PKT_MEM_DATA2_t;


#define  SATURN_L2TM_L2TM_BM_PKT_MEM_DATA1               0xd0002194
#define  SATURN_L2TM_L2TM_BM_PKT_MEM_DATA1_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_PKT_MEM_DATA1_t;


#define  SATURN_L2TM_L2TM_BM_PKT_MEM_DATA0               0xd0002198
#define  SATURN_L2TM_L2TM_BM_PKT_MEM_DATA0_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_BM_PKT_MEM_DATA0_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2tm_bm */
typedef struct {
  SATURN_L2TM_L2TM_BM_INT_t                       INT;                           /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_L2TM_L2TM_BM_INTE_t                      INTE;                          /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_L2TM_L2TM_BM_CTRL_t                      CTRL;                          /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_L2TM_L2TM_BM_TM_TO_9THQ_QUEUE_MAP_t      TM_TO_9THQ_QUEUE_MAP;          /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_L2TM_L2TM_BM_TM_TO_CPUQ_QUEUE_MAP_t      TM_TO_CPUQ_QUEUE_MAP;          /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_L2TM_L2TM_BM_TM_TO_CPU256Q_QUEUE_MAP_t   TM_TO_CPU256Q_QUEUE_MAP;       /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_L2TM_L2TM_BM_TM_TO_DQ_QUEUE_MAP_t        TM_TO_DQ_QUEUE_MAP;            /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  SATURN_L2TM_L2TM_BM_DQ_TO_TM_QUEUE_MAP_t        DQ_TO_TM_QUEUE_MAP;            /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  SATURN_L2TM_L2TM_BM_DQ_TO_TM_PORT_MAP_t         DQ_TO_TM_PORT_MAP;             /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  SATURN_L2TM_L2TM_BM_RX_DQ_PCNT_t                RX_DQ_PCNT;                    /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  SATURN_L2TM_L2TM_BM_RX_DQ_DPCNT_t               RX_DQ_DPCNT;                   /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  SATURN_L2TM_L2TM_BM_RX_PCNT_t                   RX_PCNT;                       /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  SATURN_L2TM_L2TM_BM_TX_PCNT_t                   TX_PCNT;                       /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  SATURN_L2TM_L2TM_BM_SB_DPCNT_t                  SB_DPCNT;                      /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  SATURN_L2TM_L2TM_BM_HDR_DPCNT_t                 HDR_DPCNT;                     /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  SATURN_L2TM_L2TM_BM_TE_DPCNT_t                  TE_DPCNT;                      /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  SATURN_L2TM_L2TM_BM_ERR_DPCNT_t                 ERR_DPCNT;                     /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  SATURN_L2TM_L2TM_BM_FC_MIRROR0_DPCNT_t          FC_MIRROR0_DPCNT;              /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  SATURN_L2TM_L2TM_BM_FC_MIRROR1_DPCNT_t          FC_MIRROR1_DPCNT;              /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  SATURN_L2TM_L2TM_BM_FC_MIRROR2_DPCNT_t          FC_MIRROR2_DPCNT;              /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  SATURN_L2TM_L2TM_BM_FC_MIRROR3_DPCNT_t          FC_MIRROR3_DPCNT;              /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  SATURN_L2TM_L2TM_BM_RX_DPCNT_t                  RX_DPCNT;                      /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  SATURN_L2TM_L2TM_BM_NOBUF_DPCNT_t               NOBUF_DPCNT;                   /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  SATURN_L2TM_L2TM_BM_RX_FE_HEADER_31_0_t         RX_FE_HEADER_31_0;             /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  SATURN_L2TM_L2TM_BM_RX_FE_HEADER_63_32_t        RX_FE_HEADER_63_32;            /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  SATURN_L2TM_L2TM_BM_RX_NI_HEADER_31_0_t         RX_NI_HEADER_31_0;             /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  SATURN_L2TM_L2TM_BM_RX_NI_HEADER_63_32_t        RX_NI_HEADER_63_32;            /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  SATURN_L2TM_L2TM_BM_TX_NI_HEADER_31_0_t         TX_NI_HEADER_31_0;             /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  SATURN_L2TM_L2TM_BM_TX_NI_HEADER_63_32_t        TX_NI_HEADER_63_32;            /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  SATURN_L2TM_L2TM_BM_STS_t                       STS;                           /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  SATURN_L2TM_L2TM_BM_PKT_MEM_ACCESS_t            PKT_MEM_ACCESS;                /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  SATURN_L2TM_L2TM_BM_PKT_MEM_DATA7_t             PKT_MEM_DATA7;                 /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  SATURN_L2TM_L2TM_BM_PKT_MEM_DATA6_t             PKT_MEM_DATA6;                 /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  SATURN_L2TM_L2TM_BM_PKT_MEM_DATA5_t             PKT_MEM_DATA5;                 /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  SATURN_L2TM_L2TM_BM_PKT_MEM_DATA4_t             PKT_MEM_DATA4;                 /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  SATURN_L2TM_L2TM_BM_PKT_MEM_DATA3_t             PKT_MEM_DATA3;                 /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  SATURN_L2TM_L2TM_BM_PKT_MEM_DATA2_t             PKT_MEM_DATA2;                 /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  SATURN_L2TM_L2TM_BM_PKT_MEM_DATA1_t             PKT_MEM_DATA1;                 /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  SATURN_L2TM_L2TM_BM_PKT_MEM_DATA0_t             PKT_MEM_DATA0;                 /* addr: 0x00000098 */
} SATURN_APB0_L2TM_L2TM_BM_t;


/*
 * l2tm_qm
 */
        
#define  SATURN_L2TM_L2TM_QM_INT                         0xd0002200
#define  SATURN_L2TM_L2TM_QM_INT_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t freeq_ecc_correctederr :  1 ; /* bits 0:0 */
    ca_uint32_t freeq_ecc_err        :  1 ; /* bits 1:1 */
    ca_uint32_t voqinfo_ecc_correctederr :  1 ; /* bits 2:2 */
    ca_uint32_t voqinfo_ecc_err      :  1 ; /* bits 3:3 */
    ca_uint32_t nobuf_drop           :  1 ; /* bits 4:4 */
    ca_uint32_t bid_out_of_range     :  1 ; /* bits 5:5 */
    ca_uint32_t wr_race_err          :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               :  9 ;
    ca_uint32_t eq0_stack_err        :  1 ; /* bits 16:16 */
    ca_uint32_t eq1_stack_err        :  1 ; /* bits 17:17 */
    ca_uint32_t enq_ff_undrflo       :  1 ; /* bits 18:18 */
    ca_uint32_t enq_ff_ovrflo        :  1 ; /* bits 19:19 */
    ca_uint32_t deq_ff_undrflo       :  1 ; /* bits 20:20 */
    ca_uint32_t deq_ff_ovrflo        :  1 ; /* bits 21:21 */
    ca_uint32_t rsrvd2               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_QM_INT_t;


#define  SATURN_L2TM_L2TM_QM_INTE                        0xd0002204
#define  SATURN_L2TM_L2TM_QM_INTE_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t freeq_ecc_correctederrE :  1 ; /* bits 0:0 */
    ca_uint32_t freeq_ecc_errE       :  1 ; /* bits 1:1 */
    ca_uint32_t voqinfo_ecc_correctederrE :  1 ; /* bits 2:2 */
    ca_uint32_t voqinfo_ecc_errE     :  1 ; /* bits 3:3 */
    ca_uint32_t nobuf_dropE          :  1 ; /* bits 4:4 */
    ca_uint32_t bid_out_of_rangeE    :  1 ; /* bits 5:5 */
    ca_uint32_t wr_race_errE         :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               :  9 ;
    ca_uint32_t eq0_stack_errE       :  1 ; /* bits 16:16 */
    ca_uint32_t eq1_stack_errE       :  1 ; /* bits 17:17 */
    ca_uint32_t enq_ff_undrfloE      :  1 ; /* bits 18:18 */
    ca_uint32_t enq_ff_ovrfloE       :  1 ; /* bits 19:19 */
    ca_uint32_t deq_ff_undrfloE      :  1 ; /* bits 20:20 */
    ca_uint32_t deq_ff_ovrfloE       :  1 ; /* bits 21:21 */
    ca_uint32_t rsrvd2               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_QM_INTE_t;


#define  SATURN_L2TM_L2TM_QM_EQ_CFG                      0xd0002208
#define  SATURN_L2TM_L2TM_QM_EQ_CFG_dft                  0x00040008

typedef volatile union {
  struct {
    ca_uint32_t eq0_bufnum           :  5 ; /* bits 4:0 */
    ca_uint32_t eq0_prvt             : 11 ; /* bits 15:5 */
    ca_uint32_t eq1_bufnum           :  4 ; /* bits 19:16 */
    ca_uint32_t eq1_prvt             : 10 ; /* bits 29:20 */
    ca_uint32_t eq0_en               :  1 ; /* bits 30:30 */
    ca_uint32_t eq1_en               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_QM_EQ_CFG_t;


#define  SATURN_L2TM_L2TM_QM_EQ_CFG1                     0xd000220c
#define  SATURN_L2TM_L2TM_QM_EQ_CFG1_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t eq0_buffer_weight    :  1 ; /* bits 0:0 */
    ca_uint32_t eq1_buffer_weight    :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_QM_EQ_CFG1_t;


#define  SATURN_L2TM_L2TM_QM_GLOB_BUF_CFG                0xd0002210
#define  SATURN_L2TM_L2TM_QM_GLOB_BUF_CFG_dft            0x90000020

typedef volatile union {
  struct {
    ca_uint32_t nodrop               : 15 ; /* bits 14:0 */
    ca_uint32_t drop_en              :  1 ; /* bits 15:15 */
    ca_uint32_t noncong              : 15 ; /* bits 30:16 */
    ca_uint32_t fe_bp_en             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_QM_GLOB_BUF_CFG_t;


#define  SATURN_L2TM_L2TM_QM_GLOB_BUF_CFG1               0xd0002214
#define  SATURN_L2TM_L2TM_QM_GLOB_BUF_CFG1_dft           0x00000010

typedef volatile union {
  struct {
    ca_uint32_t fe_bp_th             : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_QM_GLOB_BUF_CFG1_t;


#define  SATURN_L2TM_L2TM_QM_PORT_PRVT_PROFILE0          0xd0002218
#define  SATURN_L2TM_L2TM_QM_PORT_PRVT_PROFILE0_dft      0x00100000

typedef volatile union {
  struct {
    ca_uint32_t cnt_even             : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t cnt_odd              : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_QM_PORT_PRVT_PROFILE0_t;


#define  SATURN_L2TM_L2TM_QM_PORT_PRVT_PROFILE1          0xd000221c
#define  SATURN_L2TM_L2TM_QM_PORT_PRVT_PROFILE1_dft      0x00400020

typedef volatile union {
  struct {
    ca_uint32_t cnt_even             : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t cnt_odd              : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_QM_PORT_PRVT_PROFILE1_t;


#define  SATURN_L2TM_L2TM_QM_PORT_PRVT_PROFILE2          0xd0002220
#define  SATURN_L2TM_L2TM_QM_PORT_PRVT_PROFILE2_dft      0x00c00080

typedef volatile union {
  struct {
    ca_uint32_t cnt_even             : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t cnt_odd              : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_QM_PORT_PRVT_PROFILE2_t;


#define  SATURN_L2TM_L2TM_QM_PORT_PRVT_PROFILE3          0xd0002224
#define  SATURN_L2TM_L2TM_QM_PORT_PRVT_PROFILE3_dft      0x01400100

typedef volatile union {
  struct {
    ca_uint32_t cnt_even             : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t cnt_odd              : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_QM_PORT_PRVT_PROFILE3_t;


#define  SATURN_L2TM_L2TM_QM_PORT_PRVT_SELECT0           0xd0002228
#define  SATURN_L2TM_L2TM_QM_PORT_PRVT_SELECT0_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t port0                :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t port1                :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t port2                :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t port3                :  3 ; /* bits 14:12 */
    ca_uint32_t rsrvd4               :  1 ;
    ca_uint32_t port4                :  3 ; /* bits 18:16 */
    ca_uint32_t rsrvd5               :  1 ;
    ca_uint32_t port5                :  3 ; /* bits 22:20 */
    ca_uint32_t rsrvd6               :  1 ;
    ca_uint32_t port6                :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd7               :  1 ;
    ca_uint32_t port7                :  3 ; /* bits 30:28 */
    ca_uint32_t rsrvd8               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_QM_PORT_PRVT_SELECT0_t;


#define  SATURN_L2TM_L2TM_QM_PORT_PRVT_SELECT1           0xd000222c
#define  SATURN_L2TM_L2TM_QM_PORT_PRVT_SELECT1_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t port0                :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t port1                :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t port2                :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t port3                :  3 ; /* bits 14:12 */
    ca_uint32_t rsrvd4               :  1 ;
    ca_uint32_t port4                :  3 ; /* bits 18:16 */
    ca_uint32_t rsrvd5               :  1 ;
    ca_uint32_t port5                :  3 ; /* bits 22:20 */
    ca_uint32_t rsrvd6               :  1 ;
    ca_uint32_t port6                :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd7               :  1 ;
    ca_uint32_t port7                :  3 ; /* bits 30:28 */
    ca_uint32_t rsrvd8               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_QM_PORT_PRVT_SELECT1_t;


#define  SATURN_L2TM_L2TM_QM_PORT_NO_PRVT_STS            0xd0002230
#define  SATURN_L2TM_L2TM_QM_PORT_NO_PRVT_STS_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pid                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_QM_PORT_NO_PRVT_STS_t;


#define  SATURN_L2TM_L2TM_QM_EQ_GLB_FREECNT              0xd0002234
#define  SATURN_L2TM_L2TM_QM_EQ_GLB_FREECNT_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sum_of_eqcnt         : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_QM_EQ_GLB_FREECNT_t;


#define  SATURN_L2TM_L2TM_QM_EQ_COS0_BUFCNT              0xd0002238
#define  SATURN_L2TM_L2TM_QM_EQ_COS0_BUFCNT_STRIDE       4
#define  SATURN_L2TM_L2TM_QM_EQ_COS0_BUFCNT_COUNT        8
#define  SATURN_L2TM_L2TM_QM_EQ_COS0_BUFCNT_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sum_of_eqcnt         : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_QM_EQ_COS0_BUFCNT_t;

                            
#define  SATURN_L2TM_L2TM_QM_PORT_PRVT_BUFCNT_MEM_ACCESS 0xd0002258
#define  SATURN_L2TM_L2TM_QM_PORT_PRVT_BUFCNT_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_QM_PORT_PRVT_BUFCNT_MEM_ACCESS_t;


#define  SATURN_L2TM_L2TM_QM_PORT_PRVT_BUFCNT_MEM_DATA   0xd000225c
#define  SATURN_L2TM_L2TM_QM_PORT_PRVT_BUFCNT_MEM_DATA_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt0                 : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_QM_PORT_PRVT_BUFCNT_MEM_DATA_t;


#define  SATURN_L2TM_L2TM_QM_EQ_FREECNT                  0xd0002260
#define  SATURN_L2TM_L2TM_QM_EQ_FREECNT_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t eq0                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t eq1                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_QM_EQ_FREECNT_t;


#define  SATURN_L2TM_L2TM_QM_EQ_HEAD                     0xd0002264
#define  SATURN_L2TM_L2TM_QM_EQ_HEAD_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t eq0                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t eq1                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_QM_EQ_HEAD_t;


#define  SATURN_L2TM_L2TM_QM_EQ0_STACK_CFG               0xd0002268
#define  SATURN_L2TM_L2TM_QM_EQ0_STACK_CFG_dft           0x00302010

typedef volatile union {
  struct {
    ca_uint32_t low_ths              :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t mid_ths              :  6 ; /* bits 13:8 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t high_ths             :  6 ; /* bits 21:16 */
    ca_uint32_t rsrvd3               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_QM_EQ0_STACK_CFG_t;


#define  SATURN_L2TM_L2TM_QM_EQ0_STACK_CTRL              0xd000226c
#define  SATURN_L2TM_L2TM_QM_EQ0_STACK_CTRL_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t stack_unfill         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_QM_EQ0_STACK_CTRL_t;


#define  SATURN_L2TM_L2TM_QM_EQ0_STACK_STS               0xd0002270
#define  SATURN_L2TM_L2TM_QM_EQ0_STACK_STS_dft           0x00000007

typedef volatile union {
  struct {
    ca_uint32_t stack_unfill_done    :  1 ; /* bits 0:0 */
    ca_uint32_t stack_idle           :  1 ; /* bits 1:1 */
    ca_uint32_t stack_empty          :  1 ; /* bits 2:2 */
    ca_uint32_t stack_full           :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 12 ;
    ca_uint32_t stack_cntr           :  6 ; /* bits 21:16 */
    ca_uint32_t rsrvd2               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_QM_EQ0_STACK_STS_t;


#define  SATURN_L2TM_L2TM_QM_EQ1_STACK_CFG               0xd0002274
#define  SATURN_L2TM_L2TM_QM_EQ1_STACK_CFG_dft           0x00302010

typedef volatile union {
  struct {
    ca_uint32_t low_ths              :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t mid_ths              :  6 ; /* bits 13:8 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t high_ths             :  6 ; /* bits 21:16 */
    ca_uint32_t rsrvd3               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_QM_EQ1_STACK_CFG_t;


#define  SATURN_L2TM_L2TM_QM_EQ1_STACK_CTRL              0xd0002278
#define  SATURN_L2TM_L2TM_QM_EQ1_STACK_CTRL_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t stack_unfill         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_QM_EQ1_STACK_CTRL_t;


#define  SATURN_L2TM_L2TM_QM_EQ1_STACK_STS               0xd000227c
#define  SATURN_L2TM_L2TM_QM_EQ1_STACK_STS_dft           0x00000007

typedef volatile union {
  struct {
    ca_uint32_t stack_unfill_done    :  1 ; /* bits 0:0 */
    ca_uint32_t stack_idle           :  1 ; /* bits 1:1 */
    ca_uint32_t stack_empty          :  1 ; /* bits 2:2 */
    ca_uint32_t stack_full           :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 12 ;
    ca_uint32_t stack_cntr           :  6 ; /* bits 21:16 */
    ca_uint32_t rsrvd2               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_QM_EQ1_STACK_STS_t;


#define  SATURN_L2TM_L2TM_QM_CTRL                        0xd0002280
#define  SATURN_L2TM_L2TM_QM_CTRL_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 31 ;
    ca_uint32_t force_init_done      :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_QM_CTRL_t;


#define  SATURN_L2TM_L2TM_QM_STS                         0xd0002284
#define  SATURN_L2TM_L2TM_QM_STS_dft                     0x000c0000

typedef volatile union {
  struct {
    ca_uint32_t plm_nempty           : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t enq_ff_empty         :  1 ; /* bits 18:18 */
    ca_uint32_t deq_ff_empty         :  1 ; /* bits 19:19 */
    ca_uint32_t rsrvd2               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_QM_STS_t;


#define  SATURN_L2TM_L2TM_QM_STS1                        0xd0002288
#define  SATURN_L2TM_L2TM_QM_STS1_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t init_adr             : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t init_data            :  8 ; /* bits 23:16 */
    ca_uint32_t freeq_cs             :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t sm_reset             :  1 ; /* bits 30:30 */
    ca_uint32_t init_done            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_QM_STS1_t;


#define  SATURN_L2TM_L2TM_QM_STS2                        0xd000228c
#define  SATURN_L2TM_L2TM_QM_STS2_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t init_adr             :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               :  9 ;
    ca_uint32_t init_data            :  8 ; /* bits 23:16 */
    ca_uint32_t voqinfo_cs           :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t sm_reset             :  1 ; /* bits 30:30 */
    ca_uint32_t init_done            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_QM_STS2_t;


#define  SATURN_L2TM_L2TM_QM_FREEQ_MEM_ACCESS            0xd0002290
#define  SATURN_L2TM_L2TM_QM_FREEQ_MEM_ACCESS_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 15 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_QM_FREEQ_MEM_ACCESS_t;


#define  SATURN_L2TM_L2TM_QM_FREEQ_MEM_DATA1             0xd0002294
#define  SATURN_L2TM_L2TM_QM_FREEQ_MEM_DATA1_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ecc                  :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_QM_FREEQ_MEM_DATA1_t;


#define  SATURN_L2TM_L2TM_QM_FREEQ_MEM_DATA0             0xd0002298
#define  SATURN_L2TM_L2TM_QM_FREEQ_MEM_DATA0_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t blen                 :  7 ; /* bits 6:0 */
    ca_uint32_t eqid                 :  1 ; /* bits 7:7 */
    ca_uint32_t eop                  :  1 ; /* bits 8:8 */
    ca_uint32_t sop                  :  1 ; /* bits 9:9 */
    ca_uint32_t cpu                  :  1 ; /* bits 10:10 */
    ca_uint32_t prvt                 :  1 ; /* bits 11:11 */
    ca_uint32_t nxt_ptr              : 15 ; /* bits 26:12 */
    ca_uint32_t ecc                  :  5 ; /* bits 31:27 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_QM_FREEQ_MEM_DATA0_t;


#define  SATURN_L2TM_L2TM_QM_VOQINFO_MEM_ACCESS          0xd000229c
#define  SATURN_L2TM_L2TM_QM_VOQINFO_MEM_ACCESS_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_QM_VOQINFO_MEM_ACCESS_t;


#define  SATURN_L2TM_L2TM_QM_VOQINFO_MEM_DATA1           0xd00022a0
#define  SATURN_L2TM_L2TM_QM_VOQINFO_MEM_DATA1_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tail_ptr             : 10 ; /* bits 9:0 */
    ca_uint32_t vallid               :  1 ; /* bits 10:10 */
    ca_uint32_t ecc                  :  7 ; /* bits 17:11 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_QM_VOQINFO_MEM_DATA1_t;


#define  SATURN_L2TM_L2TM_QM_VOQINFO_MEM_DATA0           0xd00022a4
#define  SATURN_L2TM_L2TM_QM_VOQINFO_MEM_DATA0_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t blen                 :  7 ; /* bits 6:0 */
    ca_uint32_t eqid                 :  1 ; /* bits 7:7 */
    ca_uint32_t eop                  :  1 ; /* bits 8:8 */
    ca_uint32_t sop                  :  1 ; /* bits 9:9 */
    ca_uint32_t cpu                  :  1 ; /* bits 10:10 */
    ca_uint32_t prvt                 :  1 ; /* bits 11:11 */
    ca_uint32_t head_ptr             : 15 ; /* bits 26:12 */
    ca_uint32_t tail_ptr             :  5 ; /* bits 31:27 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_QM_VOQINFO_MEM_DATA0_t;


#define  SATURN_L2TM_L2TM_QM_VOQ_PCNT_MEM_ACCESS         0xd00022a8
#define  SATURN_L2TM_L2TM_QM_VOQ_PCNT_MEM_ACCESS_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_QM_VOQ_PCNT_MEM_ACCESS_t;


#define  SATURN_L2TM_L2TM_QM_VOQ_PCNT_MEM_DATA           0xd00022ac
#define  SATURN_L2TM_L2TM_QM_VOQ_PCNT_MEM_DATA_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt0                 : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_QM_VOQ_PCNT_MEM_DATA_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2tm_qm */
typedef struct {
  SATURN_L2TM_L2TM_QM_INT_t                       INT;                           /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_L2TM_L2TM_QM_INTE_t                      INTE;                          /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_L2TM_L2TM_QM_EQ_CFG_t                    EQ_CFG;                        /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_L2TM_L2TM_QM_EQ_CFG1_t                   EQ_CFG1;                       /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_L2TM_L2TM_QM_GLOB_BUF_CFG_t              GLOB_BUF_CFG;                  /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_L2TM_L2TM_QM_GLOB_BUF_CFG1_t             GLOB_BUF_CFG1;                 /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_L2TM_L2TM_QM_PORT_PRVT_PROFILE0_t        PORT_PRVT_PROFILE0;            /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  SATURN_L2TM_L2TM_QM_PORT_PRVT_PROFILE1_t        PORT_PRVT_PROFILE1;            /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  SATURN_L2TM_L2TM_QM_PORT_PRVT_PROFILE2_t        PORT_PRVT_PROFILE2;            /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  SATURN_L2TM_L2TM_QM_PORT_PRVT_PROFILE3_t        PORT_PRVT_PROFILE3;            /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  SATURN_L2TM_L2TM_QM_PORT_PRVT_SELECT0_t         PORT_PRVT_SELECT0;             /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  SATURN_L2TM_L2TM_QM_PORT_PRVT_SELECT1_t         PORT_PRVT_SELECT1;             /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  SATURN_L2TM_L2TM_QM_PORT_NO_PRVT_STS_t          PORT_NO_PRVT_STS;              /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  SATURN_L2TM_L2TM_QM_EQ_GLB_FREECNT_t            EQ_GLB_FREECNT;                /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  SATURN_L2TM_L2TM_QM_EQ_COS0_BUFCNT_t            EQ_COS0_BUFCNT;                /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[31];                  
  SATURN_L2TM_L2TM_QM_PORT_PRVT_BUFCNT_MEM_ACCESS_t PORT_PRVT_BUFCNT_MEM_ACCESS;   /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd16[3];                   
  SATURN_L2TM_L2TM_QM_PORT_PRVT_BUFCNT_MEM_DATA_t PORT_PRVT_BUFCNT_MEM_DATA;     /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd17[3];                   
  SATURN_L2TM_L2TM_QM_EQ_FREECNT_t                EQ_FREECNT;                    /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd18[3];                   
  SATURN_L2TM_L2TM_QM_EQ_HEAD_t                   EQ_HEAD;                       /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd19[3];                   
  SATURN_L2TM_L2TM_QM_EQ0_STACK_CFG_t             EQ0_STACK_CFG;                 /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd20[3];                   
  SATURN_L2TM_L2TM_QM_EQ0_STACK_CTRL_t            EQ0_STACK_CTRL;                /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd21[3];                   
  SATURN_L2TM_L2TM_QM_EQ0_STACK_STS_t             EQ0_STACK_STS;                 /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd22[3];                   
  SATURN_L2TM_L2TM_QM_EQ1_STACK_CFG_t             EQ1_STACK_CFG;                 /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd23[3];                   
  SATURN_L2TM_L2TM_QM_EQ1_STACK_CTRL_t            EQ1_STACK_CTRL;                /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd24[3];                   
  SATURN_L2TM_L2TM_QM_EQ1_STACK_STS_t             EQ1_STACK_STS;                 /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd25[3];                   
  SATURN_L2TM_L2TM_QM_CTRL_t                      CTRL;                          /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd26[3];                   
  SATURN_L2TM_L2TM_QM_STS_t                       STS;                           /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd27[3];                   
  SATURN_L2TM_L2TM_QM_STS1_t                      STS1;                          /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd28[3];                   
  SATURN_L2TM_L2TM_QM_STS2_t                      STS2;                          /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd29[3];                   
  SATURN_L2TM_L2TM_QM_FREEQ_MEM_ACCESS_t          FREEQ_MEM_ACCESS;              /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd30[3];                   
  SATURN_L2TM_L2TM_QM_FREEQ_MEM_DATA1_t           FREEQ_MEM_DATA1;               /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd31[3];                   
  SATURN_L2TM_L2TM_QM_FREEQ_MEM_DATA0_t           FREEQ_MEM_DATA0;               /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd32[3];                   
  SATURN_L2TM_L2TM_QM_VOQINFO_MEM_ACCESS_t        VOQINFO_MEM_ACCESS;            /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd33[3];                   
  SATURN_L2TM_L2TM_QM_VOQINFO_MEM_DATA1_t         VOQINFO_MEM_DATA1;             /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd34[3];                   
  SATURN_L2TM_L2TM_QM_VOQINFO_MEM_DATA0_t         VOQINFO_MEM_DATA0;             /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd35[3];                   
  SATURN_L2TM_L2TM_QM_VOQ_PCNT_MEM_ACCESS_t       VOQ_PCNT_MEM_ACCESS;           /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd36[3];                   
  SATURN_L2TM_L2TM_QM_VOQ_PCNT_MEM_DATA_t         VOQ_PCNT_MEM_DATA;             /* addr: 0x000000ac */
} SATURN_APB0_L2TM_L2TM_QM_t;


/*
 * l2tm_es
 */
        
#define  SATURN_L2TM_L2TM_ES_CTRL                        0xd0002300
#define  SATURN_L2TM_L2TM_ES_CTRL_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_port0_en          :  1 ; /* bits 0:0 */
    ca_uint32_t tx_port1_en          :  1 ; /* bits 1:1 */
    ca_uint32_t tx_port2_en          :  1 ; /* bits 2:2 */
    ca_uint32_t tx_port3_en          :  1 ; /* bits 3:3 */
    ca_uint32_t tx_port4_en          :  1 ; /* bits 4:4 */
    ca_uint32_t tx_port5_en          :  1 ; /* bits 5:5 */
    ca_uint32_t tx_port6_en          :  1 ; /* bits 6:6 */
    ca_uint32_t tx_port7_en          :  1 ; /* bits 7:7 */
    ca_uint32_t tx_port8_en          :  1 ; /* bits 8:8 */
    ca_uint32_t tx_port9_en          :  1 ; /* bits 9:9 */
    ca_uint32_t tx_port10_en         :  1 ; /* bits 10:10 */
    ca_uint32_t tx_port11_en         :  1 ; /* bits 11:11 */
    ca_uint32_t tx_port12_en         :  1 ; /* bits 12:12 */
    ca_uint32_t tx_port13_en         :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t tx_port15_en         :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd2               : 15 ;
    ca_uint32_t tx_en                :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_ES_CTRL_t;


#define  SATURN_L2TM_L2TM_ES_SCH_CFG0                    0xd0002304
#define  SATURN_L2TM_L2TM_ES_SCH_CFG0_STRIDE             12
#define  SATURN_L2TM_L2TM_ES_SCH_CFG0_COUNT              15
#define  SATURN_L2TM_L2TM_ES_SCH_CFG0_dft                0x000400ff

typedef volatile union {
  struct {
    ca_uint32_t voq_en               :  8 ; /* bits 7:0 */
    ca_uint32_t flush_voqid          :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t flush_en             :  1 ; /* bits 15:15 */
    ca_uint32_t speed                :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd2               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_ES_SCH_CFG0_t;


#define  SATURN_L2TM_L2TM_ES_VOQ3_0_WEIGHT_RATIO_CFG0    0xd0002308
#define  SATURN_L2TM_L2TM_ES_VOQ3_0_WEIGHT_RATIO_CFG0_STRIDE 12
#define  SATURN_L2TM_L2TM_ES_VOQ3_0_WEIGHT_RATIO_CFG0_COUNT 15
#define  SATURN_L2TM_L2TM_ES_VOQ3_0_WEIGHT_RATIO_CFG0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t voq0                 :  8 ; /* bits 7:0 */
    ca_uint32_t voq1                 :  8 ; /* bits 15:8 */
    ca_uint32_t voq2                 :  8 ; /* bits 23:16 */
    ca_uint32_t voq3                 :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_ES_VOQ3_0_WEIGHT_RATIO_CFG0_t;


#define  SATURN_L2TM_L2TM_ES_VOQ7_4_WEIGHT_RATIO_CFG0    0xd000230c
#define  SATURN_L2TM_L2TM_ES_VOQ7_4_WEIGHT_RATIO_CFG0_STRIDE 12
#define  SATURN_L2TM_L2TM_ES_VOQ7_4_WEIGHT_RATIO_CFG0_COUNT 15
#define  SATURN_L2TM_L2TM_ES_VOQ7_4_WEIGHT_RATIO_CFG0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t voq4                 :  8 ; /* bits 7:0 */
    ca_uint32_t voq5                 :  8 ; /* bits 15:8 */
    ca_uint32_t voq6                 :  8 ; /* bits 23:16 */
    ca_uint32_t voq7                 :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_ES_VOQ7_4_WEIGHT_RATIO_CFG0_t;

                                                                                                                                                                        
#define  SATURN_L2TM_L2TM_ES_PORT3_0_WEIGHT_RATIO_CFG    0xd00023b8
#define  SATURN_L2TM_L2TM_ES_PORT3_0_WEIGHT_RATIO_CFG_dft 0x01010101

typedef volatile union {
  struct {
    ca_uint32_t port0                :  8 ; /* bits 7:0 */
    ca_uint32_t port1                :  8 ; /* bits 15:8 */
    ca_uint32_t port2                :  8 ; /* bits 23:16 */
    ca_uint32_t port3                :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_ES_PORT3_0_WEIGHT_RATIO_CFG_t;


#define  SATURN_L2TM_L2TM_ES_PORT7_4_WEIGHT_RATIO_CFG    0xd00023bc
#define  SATURN_L2TM_L2TM_ES_PORT7_4_WEIGHT_RATIO_CFG_dft 0x01010101

typedef volatile union {
  struct {
    ca_uint32_t port4                :  8 ; /* bits 7:0 */
    ca_uint32_t port5                :  8 ; /* bits 15:8 */
    ca_uint32_t port6                :  8 ; /* bits 23:16 */
    ca_uint32_t port7                :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_ES_PORT7_4_WEIGHT_RATIO_CFG_t;


#define  SATURN_L2TM_L2TM_ES_PORT11_8_WEIGHT_RATIO_CFG   0xd00023c0
#define  SATURN_L2TM_L2TM_ES_PORT11_8_WEIGHT_RATIO_CFG_dft 0x01010101

typedef volatile union {
  struct {
    ca_uint32_t port8                :  8 ; /* bits 7:0 */
    ca_uint32_t port9                :  8 ; /* bits 15:8 */
    ca_uint32_t port10               :  8 ; /* bits 23:16 */
    ca_uint32_t port11               :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_ES_PORT11_8_WEIGHT_RATIO_CFG_t;


#define  SATURN_L2TM_L2TM_ES_PORT15_12_WEIGHT_RATIO_CFG  0xd00023c4
#define  SATURN_L2TM_L2TM_ES_PORT15_12_WEIGHT_RATIO_CFG_dft 0x01000101

typedef volatile union {
  struct {
    ca_uint32_t port12               :  8 ; /* bits 7:0 */
    ca_uint32_t port13               :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t port15               :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_ES_PORT15_12_WEIGHT_RATIO_CFG_t;


#define  SATURN_L2TM_L2TM_ES_DRR_WEIGHT_BASE             0xd00023c8
#define  SATURN_L2TM_L2TM_ES_DRR_WEIGHT_BASE_dft         0x00000014

typedef volatile union {
  struct {
    ca_uint32_t w_rate               :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t base_select          :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd2               :  5 ;
    ca_uint32_t dwrr_unit            :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd3               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_ES_DRR_WEIGHT_BASE_t;


#define  SATURN_L2TM_L2TM_ES_CFG                         0xd00023cc
#define  SATURN_L2TM_L2TM_ES_CFG_dft                     0x00000340

typedef volatile union {
  struct {
    ca_uint32_t sch_ack_len          :  8 ; /* bits 7:0 */
    ca_uint32_t sch_sync_upd         :  1 ; /* bits 8:8 */
    ca_uint32_t sch_rr_grant         :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_ES_CFG_t;


#define  SATURN_L2TM_L2TM_ES_STS                         0xd00023d0
#define  SATURN_L2TM_L2TM_ES_STS_dft                     0x00003fff

typedef volatile union {
  struct {
    ca_uint32_t ni_port_rdy          : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_ES_STS_t;


#define  SATURN_L2TM_L2TM_ES_VOQ_STS0                    0xd00023d4
#define  SATURN_L2TM_L2TM_ES_VOQ_STS0_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t qid                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_ES_VOQ_STS0_t;


#define  SATURN_L2TM_L2TM_ES_VOQ_STS1                    0xd00023d8
#define  SATURN_L2TM_L2TM_ES_VOQ_STS1_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t qid                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_ES_VOQ_STS1_t;


#define  SATURN_L2TM_L2TM_ES_VOQ_STS2                    0xd00023dc
#define  SATURN_L2TM_L2TM_ES_VOQ_STS2_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t qid                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_ES_VOQ_STS2_t;


#define  SATURN_L2TM_L2TM_ES_VOQ_STS3                    0xd00023e0
#define  SATURN_L2TM_L2TM_ES_VOQ_STS3_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t qid                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_ES_VOQ_STS3_t;


#define  SATURN_L2TM_L2TM_ES_VOQ_OK_STS0                 0xd00023e4
#define  SATURN_L2TM_L2TM_ES_VOQ_OK_STS0_dft             0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t qid                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_ES_VOQ_OK_STS0_t;


#define  SATURN_L2TM_L2TM_ES_VOQ_OK_STS1                 0xd00023e8
#define  SATURN_L2TM_L2TM_ES_VOQ_OK_STS1_dft             0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t qid                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_ES_VOQ_OK_STS1_t;


#define  SATURN_L2TM_L2TM_ES_VOQ_OK_STS2                 0xd00023ec
#define  SATURN_L2TM_L2TM_ES_VOQ_OK_STS2_dft             0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t qid                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_ES_VOQ_OK_STS2_t;


#define  SATURN_L2TM_L2TM_ES_VOQ_OK_STS3                 0xd00023f0
#define  SATURN_L2TM_L2TM_ES_VOQ_OK_STS3_dft             0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t qid                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_ES_VOQ_OK_STS3_t;


#define  SATURN_L2TM_L2TM_ES_PORT_OK_STS                 0xd00023f4
#define  SATURN_L2TM_L2TM_ES_PORT_OK_STS_dft             0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t pid                  : 16 ; /* bits 15:0 */
    ca_uint32_t voq_grp              : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TM_ES_PORT_OK_STS_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2tm_es */
typedef struct {
  SATURN_L2TM_L2TM_ES_CTRL_t                      CTRL;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_L2TM_L2TM_ES_SCH_CFG0_t                  SCH_CFG0;                      /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_L2TM_L2TM_ES_VOQ3_0_WEIGHT_RATIO_CFG0_t  VOQ3_0_WEIGHT_RATIO_CFG0;      /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_L2TM_L2TM_ES_VOQ7_4_WEIGHT_RATIO_CFG0_t  VOQ7_4_WEIGHT_RATIO_CFG0;      /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[171];                  
  SATURN_L2TM_L2TM_ES_PORT3_0_WEIGHT_RATIO_CFG_t  PORT3_0_WEIGHT_RATIO_CFG;      /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_L2TM_L2TM_ES_PORT7_4_WEIGHT_RATIO_CFG_t  PORT7_4_WEIGHT_RATIO_CFG;      /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_L2TM_L2TM_ES_PORT11_8_WEIGHT_RATIO_CFG_t PORT11_8_WEIGHT_RATIO_CFG;     /* addr: 0x000000c0 */
  ca_uint32_t                              rsrvd7[3];                    
  SATURN_L2TM_L2TM_ES_PORT15_12_WEIGHT_RATIO_CFG_t PORT15_12_WEIGHT_RATIO_CFG;    /* addr: 0x000000c4 */
  ca_uint32_t                              rsrvd8[3];                    
  SATURN_L2TM_L2TM_ES_DRR_WEIGHT_BASE_t           DRR_WEIGHT_BASE;               /* addr: 0x000000c8 */
  ca_uint32_t                              rsrvd9[3];                    
  SATURN_L2TM_L2TM_ES_CFG_t                       CFG;                           /* addr: 0x000000cc */
  ca_uint32_t                              rsrvd10[3];                   
  SATURN_L2TM_L2TM_ES_STS_t                       STS;                           /* addr: 0x000000d0 */
  ca_uint32_t                              rsrvd11[3];                   
  SATURN_L2TM_L2TM_ES_VOQ_STS0_t                  VOQ_STS0;                      /* addr: 0x000000d4 */
  ca_uint32_t                              rsrvd12[3];                   
  SATURN_L2TM_L2TM_ES_VOQ_STS1_t                  VOQ_STS1;                      /* addr: 0x000000d8 */
  ca_uint32_t                              rsrvd13[3];                   
  SATURN_L2TM_L2TM_ES_VOQ_STS2_t                  VOQ_STS2;                      /* addr: 0x000000dc */
  ca_uint32_t                              rsrvd14[3];                   
  SATURN_L2TM_L2TM_ES_VOQ_STS3_t                  VOQ_STS3;                      /* addr: 0x000000e0 */
  ca_uint32_t                              rsrvd15[3];                   
  SATURN_L2TM_L2TM_ES_VOQ_OK_STS0_t               VOQ_OK_STS0;                   /* addr: 0x000000e4 */
  ca_uint32_t                              rsrvd16[3];                   
  SATURN_L2TM_L2TM_ES_VOQ_OK_STS1_t               VOQ_OK_STS1;                   /* addr: 0x000000e8 */
  ca_uint32_t                              rsrvd17[3];                   
  SATURN_L2TM_L2TM_ES_VOQ_OK_STS2_t               VOQ_OK_STS2;                   /* addr: 0x000000ec */
  ca_uint32_t                              rsrvd18[3];                   
  SATURN_L2TM_L2TM_ES_VOQ_OK_STS3_t               VOQ_OK_STS3;                   /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd19[3];                   
  SATURN_L2TM_L2TM_ES_PORT_OK_STS_t               PORT_OK_STS;                   /* addr: 0x000000f4 */
} SATURN_APB0_L2TM_L2TM_ES_t;


/*
 * l2te_glb
 */
        
#define  SATURN_L2TM_L2TE_GLB_REV_ID                     0xd0002400
#define  SATURN_L2TM_L2TE_GLB_REV_ID_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t minor                : 16 ; /* bits 15:0 */
    ca_uint32_t major                : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_GLB_REV_ID_t;


#define  SATURN_L2TM_L2TE_GLB_CTRL                       0xd0002404
#define  SATURN_L2TM_L2TE_GLB_CTRL_dft                   0x07000000

typedef volatile union {
  struct {
    ca_uint32_t pol_en               :  1 ; /* bits 0:0 */
    ca_uint32_t shp_en               :  1 ; /* bits 1:1 */
    ca_uint32_t taildrop_en          :  1 ; /* bits 2:2 */
    ca_uint32_t wred_en              :  1 ; /* bits 3:3 */
    ca_uint32_t mark_ecn_en          :  1 ; /* bits 4:4 */
    ca_uint32_t pol_ecn_en           :  1 ; /* bits 5:5 */
    ca_uint32_t wred_ecn_en          :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               :  9 ;
    ca_uint32_t glb_deepq_port_rdy_en :  8 ; /* bits 23:16 */
    ca_uint32_t glb_deepq_port_rdy_id :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd2               :  4 ;
    ca_uint32_t force_init_done      :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_GLB_CTRL_t;


#define  SATURN_L2TM_L2TE_GLB_INT                        0xd0002408
#define  SATURN_L2TM_L2TE_GLB_INT_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pol_mark             :  1 ; /* bits 0:0 */
    ca_uint32_t pol_drop             :  1 ; /* bits 1:1 */
    ca_uint32_t tail_drop            :  1 ; /* bits 2:2 */
    ca_uint32_t wred_y_drop          :  1 ; /* bits 3:3 */
    ca_uint32_t wred_g_drop          :  1 ; /* bits 4:4 */
    ca_uint32_t ecn                  :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t feio                 :  1 ; /* bits 14:14 */
    ca_uint32_t tmio                 :  1 ; /* bits 15:15 */
    ca_uint32_t cb                   :  1 ; /* bits 16:16 */
    ca_uint32_t fc                   :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd2               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_GLB_INT_t;


#define  SATURN_L2TM_L2TE_GLB_INTE                       0xd000240c
#define  SATURN_L2TM_L2TE_GLB_INTE_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pol_markE            :  1 ; /* bits 0:0 */
    ca_uint32_t pol_dropE            :  1 ; /* bits 1:1 */
    ca_uint32_t tail_dropE           :  1 ; /* bits 2:2 */
    ca_uint32_t wred_y_dropE         :  1 ; /* bits 3:3 */
    ca_uint32_t wred_g_dropE         :  1 ; /* bits 4:4 */
    ca_uint32_t ecnE                 :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t feioE                :  1 ; /* bits 14:14 */
    ca_uint32_t tmioE                :  1 ; /* bits 15:15 */
    ca_uint32_t cbE                  :  1 ; /* bits 16:16 */
    ca_uint32_t fcE                  :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd2               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_GLB_INTE_t;


#define  SATURN_L2TM_L2TE_GLB_STS                        0xd0002410
#define  SATURN_L2TM_L2TE_GLB_STS_dft                    0x07000000

typedef volatile union {
  struct {
    ca_uint32_t pol_fifo_ovrn        :  1 ; /* bits 0:0 */
    ca_uint32_t l2io_fifo_ovrn       :  1 ; /* bits 1:1 */
    ca_uint32_t qmio_enq_ovrn        :  1 ; /* bits 2:2 */
    ca_uint32_t qmio_deq_ovrn        :  1 ; /* bits 3:3 */
    ca_uint32_t qmio_shp_ovrn        :  1 ; /* bits 4:4 */
    ca_uint32_t te_qm_nrdy           :  1 ; /* bits 5:5 */
    ca_uint32_t ptp_fifo_err         :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t pol_init_done        :  1 ; /* bits 12:12 */
    ca_uint32_t shp_init_done        :  1 ; /* bits 13:13 */
    ca_uint32_t cb_init_done         :  1 ; /* bits 14:14 */
    ca_uint32_t wred_init_done       :  1 ; /* bits 15:15 */
    ca_uint32_t feio_sm              :  4 ; /* bits 19:16 */
    ca_uint32_t fe_te_req            :  1 ; /* bits 20:20 */
    ca_uint32_t te_fe_ack            :  1 ; /* bits 21:21 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t l2io_idle            :  1 ; /* bits 24:24 */
    ca_uint32_t qmio_idle            :  1 ; /* bits 25:25 */
    ca_uint32_t ptp_fifo_idle        :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd3               :  4 ;
    ca_uint32_t init_done            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_GLB_STS_t;


#define  SATURN_L2TM_L2TE_GLB_PTP_CFG                    0xd0002414
#define  SATURN_L2TM_L2TE_GLB_PTP_CFG_dft                0x000007ff

typedef volatile union {
  struct {
    ca_uint32_t pol_id               :  8 ; /* bits 7:0 */
    ca_uint32_t pol_grp_id           :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t pol_en               :  1 ; /* bits 12:12 */
    ca_uint32_t pol_grp_en           :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd2               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_GLB_PTP_CFG_t;


#define  SATURN_L2TM_L2TE_GLB_SPARE_CFG                  0xd0002418
#define  SATURN_L2TM_L2TE_GLB_SPARE_CFG_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t spare                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_GLB_SPARE_CFG_t;


#define  SATURN_L2TM_L2TE_GLB_SPARE_STS                  0xd000241c
#define  SATURN_L2TM_L2TE_GLB_SPARE_STS_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t spare                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_GLB_SPARE_STS_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2te_glb */
typedef struct {
  SATURN_L2TM_L2TE_GLB_REV_ID_t                   REV_ID;                        /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_L2TM_L2TE_GLB_CTRL_t                     CTRL;                          /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_L2TM_L2TE_GLB_INT_t                      INT;                           /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_L2TM_L2TE_GLB_INTE_t                     INTE;                          /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_L2TM_L2TE_GLB_STS_t                      STS;                           /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_L2TM_L2TE_GLB_PTP_CFG_t                  PTP_CFG;                       /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_L2TM_L2TE_GLB_SPARE_CFG_t                SPARE_CFG;                     /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  SATURN_L2TM_L2TE_GLB_SPARE_STS_t                SPARE_STS;                     /* addr: 0x0000001c */
} SATURN_APB0_L2TM_L2TE_GLB_t;


/*
 * l2te_pol
 */
        
#define  SATURN_L2TM_L2TE_POL_PKT_TYPE_CTRL0             0xd0002500
#define  SATURN_L2TM_L2TE_POL_PKT_TYPE_CTRL0_STRIDE      4
#define  SATURN_L2TM_L2TE_POL_PKT_TYPE_CTRL0_COUNT       16
#define  SATURN_L2TM_L2TE_POL_PKT_TYPE_CTRL0_dft         0x00000500

typedef volatile union {
  struct {
    ca_uint32_t type                 :  3 ; /* bits 2:0 */
    ca_uint32_t color_blind          :  1 ; /* bits 3:3 */
    ca_uint32_t pkt_mode             :  1 ; /* bits 4:4 */
    ca_uint32_t egr_len_sel          :  1 ; /* bits 5:5 */
    ca_uint32_t ipg                  :  5 ; /* bits 10:6 */
    ca_uint32_t bypass_yellow        :  1 ; /* bits 11:11 */
    ca_uint32_t bypass_red           :  1 ; /* bits 12:12 */
    ca_uint32_t update_mode          :  1 ; /* bits 13:13 */
    ca_uint32_t nest_level           :  2 ; /* bits 15:14 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_POL_PKT_TYPE_CTRL0_t;

                                                            
#define  SATURN_L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_ACCESS 0xd0002540
#define  SATURN_L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_ACCESS_t;


#define  SATURN_L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA2 0xd0002544
#define  SATURN_L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA2_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t peak_bs              : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA2_t;


#define  SATURN_L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA1 0xd0002548
#define  SATURN_L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t committed_bs         :  6 ; /* bits 5:0 */
    ca_uint32_t peak_rate_k          : 10 ; /* bits 15:6 */
    ca_uint32_t peak_rate_m          : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA1_t;


#define  SATURN_L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA0 0xd000254c
#define  SATURN_L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t committed_rate_k     : 10 ; /* bits 9:0 */
    ca_uint32_t committed_rate_m     : 16 ; /* bits 25:10 */
    ca_uint32_t committed_bs         :  6 ; /* bits 31:26 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA0_t;


#define  SATURN_L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_ACCESS 0xd0002550
#define  SATURN_L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_ACCESS_t;


#define  SATURN_L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_DATA1 0xd0002554
#define  SATURN_L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_DATA1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t peak_tbc             : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_DATA1_t;


#define  SATURN_L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_DATA0 0xd0002558
#define  SATURN_L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_DATA0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t committed_tbc        : 21 ; /* bits 20:0 */
    ca_uint32_t peak_tbc             : 11 ; /* bits 31:21 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_DATA0_t;


#define  SATURN_L2TM_L2TE_POL_PORT_CTRL0                 0xd000255c
#define  SATURN_L2TM_L2TE_POL_PORT_CTRL0_STRIDE          4
#define  SATURN_L2TM_L2TE_POL_PORT_CTRL0_COUNT           16
#define  SATURN_L2TM_L2TE_POL_PORT_CTRL0_dft             0x00000500

typedef volatile union {
  struct {
    ca_uint32_t type                 :  3 ; /* bits 2:0 */
    ca_uint32_t color_blind          :  1 ; /* bits 3:3 */
    ca_uint32_t pkt_mode             :  1 ; /* bits 4:4 */
    ca_uint32_t egr_len_sel          :  1 ; /* bits 5:5 */
    ca_uint32_t ipg                  :  5 ; /* bits 10:6 */
    ca_uint32_t bypass_yellow        :  1 ; /* bits 11:11 */
    ca_uint32_t bypass_red           :  1 ; /* bits 12:12 */
    ca_uint32_t update_mode          :  1 ; /* bits 13:13 */
    ca_uint32_t nest_level           :  2 ; /* bits 15:14 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_POL_PORT_CTRL0_t;

                                                            
#define  SATURN_L2TM_L2TE_POL_PORT_PROFILE_MEM_ACCESS    0xd000259c
#define  SATURN_L2TM_L2TE_POL_PORT_PROFILE_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_POL_PORT_PROFILE_MEM_ACCESS_t;


#define  SATURN_L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA2     0xd00025a0
#define  SATURN_L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA2_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t peak_bs              : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA2_t;


#define  SATURN_L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA1     0xd00025a4
#define  SATURN_L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t committed_bs         :  6 ; /* bits 5:0 */
    ca_uint32_t peak_rate_k          : 10 ; /* bits 15:6 */
    ca_uint32_t peak_rate_m          : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA1_t;


#define  SATURN_L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA0     0xd00025a8
#define  SATURN_L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t committed_rate_k     : 10 ; /* bits 9:0 */
    ca_uint32_t committed_rate_m     : 16 ; /* bits 25:10 */
    ca_uint32_t committed_bs         :  6 ; /* bits 31:26 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA0_t;


#define  SATURN_L2TM_L2TE_POL_PORT_COUNTER_MEM_ACCESS    0xd00025ac
#define  SATURN_L2TM_L2TE_POL_PORT_COUNTER_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_POL_PORT_COUNTER_MEM_ACCESS_t;


#define  SATURN_L2TM_L2TE_POL_PORT_COUNTER_MEM_DATA1     0xd00025b0
#define  SATURN_L2TM_L2TE_POL_PORT_COUNTER_MEM_DATA1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t peak_tbc             : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_POL_PORT_COUNTER_MEM_DATA1_t;


#define  SATURN_L2TM_L2TE_POL_PORT_COUNTER_MEM_DATA0     0xd00025b4
#define  SATURN_L2TM_L2TE_POL_PORT_COUNTER_MEM_DATA0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t committed_tbc        : 21 ; /* bits 20:0 */
    ca_uint32_t peak_tbc             : 11 ; /* bits 31:21 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_POL_PORT_COUNTER_MEM_DATA0_t;


#define  SATURN_L2TM_L2TE_POL_FLOW_GRP_CTRL0             0xd00025b8
#define  SATURN_L2TM_L2TE_POL_FLOW_GRP_CTRL0_STRIDE      4
#define  SATURN_L2TM_L2TE_POL_FLOW_GRP_CTRL0_COUNT       8
#define  SATURN_L2TM_L2TE_POL_FLOW_GRP_CTRL0_dft         0x00000500

typedef volatile union {
  struct {
    ca_uint32_t type                 :  3 ; /* bits 2:0 */
    ca_uint32_t color_blind          :  1 ; /* bits 3:3 */
    ca_uint32_t pkt_mode             :  1 ; /* bits 4:4 */
    ca_uint32_t egr_len_sel          :  1 ; /* bits 5:5 */
    ca_uint32_t ipg                  :  5 ; /* bits 10:6 */
    ca_uint32_t bypass_yellow        :  1 ; /* bits 11:11 */
    ca_uint32_t bypass_red           :  1 ; /* bits 12:12 */
    ca_uint32_t update_mode          :  1 ; /* bits 13:13 */
    ca_uint32_t nest_level           :  2 ; /* bits 15:14 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_POL_FLOW_GRP_CTRL0_t;

                            
#define  SATURN_L2TM_L2TE_POL_FLOW_PROFILE_MEM_ACCESS    0xd00025d8
#define  SATURN_L2TM_L2TE_POL_FLOW_PROFILE_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_POL_FLOW_PROFILE_MEM_ACCESS_t;


#define  SATURN_L2TM_L2TE_POL_FLOW_PROFILE_MEM_DATA2     0xd00025dc
#define  SATURN_L2TM_L2TE_POL_FLOW_PROFILE_MEM_DATA2_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t peak_bs              : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_POL_FLOW_PROFILE_MEM_DATA2_t;


#define  SATURN_L2TM_L2TE_POL_FLOW_PROFILE_MEM_DATA1     0xd00025e0
#define  SATURN_L2TM_L2TE_POL_FLOW_PROFILE_MEM_DATA1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t committed_bs         :  6 ; /* bits 5:0 */
    ca_uint32_t peak_rate_k          : 10 ; /* bits 15:6 */
    ca_uint32_t peak_rate_m          : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_POL_FLOW_PROFILE_MEM_DATA1_t;


#define  SATURN_L2TM_L2TE_POL_FLOW_PROFILE_MEM_DATA0     0xd00025e4
#define  SATURN_L2TM_L2TE_POL_FLOW_PROFILE_MEM_DATA0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t committed_rate_k     : 10 ; /* bits 9:0 */
    ca_uint32_t committed_rate_m     : 16 ; /* bits 25:10 */
    ca_uint32_t committed_bs         :  6 ; /* bits 31:26 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_POL_FLOW_PROFILE_MEM_DATA0_t;


#define  SATURN_L2TM_L2TE_POL_FLOW_COUNTER_MEM_ACCESS    0xd00025e8
#define  SATURN_L2TM_L2TE_POL_FLOW_COUNTER_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_POL_FLOW_COUNTER_MEM_ACCESS_t;


#define  SATURN_L2TM_L2TE_POL_FLOW_COUNTER_MEM_DATA1     0xd00025ec
#define  SATURN_L2TM_L2TE_POL_FLOW_COUNTER_MEM_DATA1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t peak_tbc             : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_POL_FLOW_COUNTER_MEM_DATA1_t;


#define  SATURN_L2TM_L2TE_POL_FLOW_COUNTER_MEM_DATA0     0xd00025f0
#define  SATURN_L2TM_L2TE_POL_FLOW_COUNTER_MEM_DATA0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t committed_tbc        : 21 ; /* bits 20:0 */
    ca_uint32_t peak_tbc             : 11 ; /* bits 31:21 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_POL_FLOW_COUNTER_MEM_DATA0_t;


#define  SATURN_L2TM_L2TE_POL_AGRFLOW_CTRL0              0xd00025f4
#define  SATURN_L2TM_L2TE_POL_AGRFLOW_CTRL0_STRIDE       4
#define  SATURN_L2TM_L2TE_POL_AGRFLOW_CTRL0_COUNT        8
#define  SATURN_L2TM_L2TE_POL_AGRFLOW_CTRL0_dft          0x00000500

typedef volatile union {
  struct {
    ca_uint32_t type                 :  3 ; /* bits 2:0 */
    ca_uint32_t color_blind          :  1 ; /* bits 3:3 */
    ca_uint32_t pkt_mode             :  1 ; /* bits 4:4 */
    ca_uint32_t egr_len_sel          :  1 ; /* bits 5:5 */
    ca_uint32_t ipg                  :  5 ; /* bits 10:6 */
    ca_uint32_t bypass_yellow        :  1 ; /* bits 11:11 */
    ca_uint32_t bypass_red           :  1 ; /* bits 12:12 */
    ca_uint32_t update_mode          :  1 ; /* bits 13:13 */
    ca_uint32_t nest_level           :  2 ; /* bits 15:14 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_POL_AGRFLOW_CTRL0_t;

                            
#define  SATURN_L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_ACCESS 0xd0002614
#define  SATURN_L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 27 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_ACCESS_t;


#define  SATURN_L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA2  0xd0002618
#define  SATURN_L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA2_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t peak_bs              : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA2_t;


#define  SATURN_L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA1  0xd000261c
#define  SATURN_L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t committed_bs         :  6 ; /* bits 5:0 */
    ca_uint32_t peak_rate_k          : 10 ; /* bits 15:6 */
    ca_uint32_t peak_rate_m          : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA1_t;


#define  SATURN_L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA0  0xd0002620
#define  SATURN_L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t committed_rate_k     : 10 ; /* bits 9:0 */
    ca_uint32_t committed_rate_m     : 16 ; /* bits 25:10 */
    ca_uint32_t committed_bs         :  6 ; /* bits 31:26 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA0_t;


#define  SATURN_L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_ACCESS 0xd0002624
#define  SATURN_L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 27 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_ACCESS_t;


#define  SATURN_L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_DATA1  0xd0002628
#define  SATURN_L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_DATA1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t peak_tbc             : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_DATA1_t;


#define  SATURN_L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_DATA0  0xd000262c
#define  SATURN_L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_DATA0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t committed_tbc        : 21 ; /* bits 20:0 */
    ca_uint32_t peak_tbc             : 11 ; /* bits 31:21 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_DATA0_t;


#define  SATURN_L2TM_L2TE_POL_TB_CTRL                    0xd0002630
#define  SATURN_L2TM_L2TE_POL_TB_CTRL_dft                0x2ff3e723

typedef volatile union {
  struct {
    ca_uint32_t addtok_en            :  1 ; /* bits 0:0 */
    ca_uint32_t subtok_en            :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t upd_cnt_lmt          :  4 ; /* bits 7:4 */
    ca_uint32_t cyc_cnt_lmt          : 12 ; /* bits 19:8 */
    ca_uint32_t last_upd_cyc         : 12 ; /* bits 31:20 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_POL_TB_CTRL_t;


#define  SATURN_L2TM_L2TE_POL_TB_CTRL1                   0xd0002634
#define  SATURN_L2TM_L2TE_POL_TB_CTRL1_dft               0x000001f3

typedef volatile union {
  struct {
    ca_uint32_t k_cnt_lmt            : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_POL_TB_CTRL1_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2te_pol */
typedef struct {
  SATURN_L2TM_L2TE_POL_PKT_TYPE_CTRL0_t           PKT_TYPE_CTRL0;                /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[63];                   
  SATURN_L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_ACCESS_t PKT_TYPE_PROFILE_MEM_ACCESS;   /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA2_t PKT_TYPE_PROFILE_MEM_DATA2;    /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA1_t PKT_TYPE_PROFILE_MEM_DATA1;    /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA0_t PKT_TYPE_PROFILE_MEM_DATA0;    /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_ACCESS_t PKT_TYPE_COUNTER_MEM_ACCESS;   /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_DATA1_t PKT_TYPE_COUNTER_MEM_DATA1;    /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd7[3];                    
  SATURN_L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_DATA0_t PKT_TYPE_COUNTER_MEM_DATA0;    /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd8[3];                    
  SATURN_L2TM_L2TE_POL_PORT_CTRL0_t               PORT_CTRL0;                    /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd9[63];                   
  SATURN_L2TM_L2TE_POL_PORT_PROFILE_MEM_ACCESS_t  PORT_PROFILE_MEM_ACCESS;       /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd10[3];                   
  SATURN_L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA2_t   PORT_PROFILE_MEM_DATA2;        /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd11[3];                   
  SATURN_L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA1_t   PORT_PROFILE_MEM_DATA1;        /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd12[3];                   
  SATURN_L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA0_t   PORT_PROFILE_MEM_DATA0;        /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd13[3];                   
  SATURN_L2TM_L2TE_POL_PORT_COUNTER_MEM_ACCESS_t  PORT_COUNTER_MEM_ACCESS;       /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd14[3];                   
  SATURN_L2TM_L2TE_POL_PORT_COUNTER_MEM_DATA1_t   PORT_COUNTER_MEM_DATA1;        /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd15[3];                   
  SATURN_L2TM_L2TE_POL_PORT_COUNTER_MEM_DATA0_t   PORT_COUNTER_MEM_DATA0;        /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd16[3];                   
  SATURN_L2TM_L2TE_POL_FLOW_GRP_CTRL0_t           FLOW_GRP_CTRL0;                /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd17[31];                  
  SATURN_L2TM_L2TE_POL_FLOW_PROFILE_MEM_ACCESS_t  FLOW_PROFILE_MEM_ACCESS;       /* addr: 0x000000d8 */
  ca_uint32_t                              rsrvd18[3];                   
  SATURN_L2TM_L2TE_POL_FLOW_PROFILE_MEM_DATA2_t   FLOW_PROFILE_MEM_DATA2;        /* addr: 0x000000dc */
  ca_uint32_t                              rsrvd19[3];                   
  SATURN_L2TM_L2TE_POL_FLOW_PROFILE_MEM_DATA1_t   FLOW_PROFILE_MEM_DATA1;        /* addr: 0x000000e0 */
  ca_uint32_t                              rsrvd20[3];                   
  SATURN_L2TM_L2TE_POL_FLOW_PROFILE_MEM_DATA0_t   FLOW_PROFILE_MEM_DATA0;        /* addr: 0x000000e4 */
  ca_uint32_t                              rsrvd21[3];                   
  SATURN_L2TM_L2TE_POL_FLOW_COUNTER_MEM_ACCESS_t  FLOW_COUNTER_MEM_ACCESS;       /* addr: 0x000000e8 */
  ca_uint32_t                              rsrvd22[3];                   
  SATURN_L2TM_L2TE_POL_FLOW_COUNTER_MEM_DATA1_t   FLOW_COUNTER_MEM_DATA1;        /* addr: 0x000000ec */
  ca_uint32_t                              rsrvd23[3];                   
  SATURN_L2TM_L2TE_POL_FLOW_COUNTER_MEM_DATA0_t   FLOW_COUNTER_MEM_DATA0;        /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd24[3];                   
  SATURN_L2TM_L2TE_POL_AGRFLOW_CTRL0_t            AGRFLOW_CTRL0;                 /* addr: 0x000000f4 */
  ca_uint32_t                              rsrvd25[31];                  
  SATURN_L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_ACCESS_t AGRFLOW_PROFILE_MEM_ACCESS;    /* addr: 0x00000114 */
  ca_uint32_t                              rsrvd26[3];                   
  SATURN_L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA2_t AGRFLOW_PROFILE_MEM_DATA2;     /* addr: 0x00000118 */
  ca_uint32_t                              rsrvd27[3];                   
  SATURN_L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA1_t AGRFLOW_PROFILE_MEM_DATA1;     /* addr: 0x0000011c */
  ca_uint32_t                              rsrvd28[3];                   
  SATURN_L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA0_t AGRFLOW_PROFILE_MEM_DATA0;     /* addr: 0x00000120 */
  ca_uint32_t                              rsrvd29[3];                   
  SATURN_L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_ACCESS_t AGRFLOW_COUNTER_MEM_ACCESS;    /* addr: 0x00000124 */
  ca_uint32_t                              rsrvd30[3];                   
  SATURN_L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_DATA1_t AGRFLOW_COUNTER_MEM_DATA1;     /* addr: 0x00000128 */
  ca_uint32_t                              rsrvd31[3];                   
  SATURN_L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_DATA0_t AGRFLOW_COUNTER_MEM_DATA0;     /* addr: 0x0000012c */
  ca_uint32_t                              rsrvd32[3];                   
  SATURN_L2TM_L2TE_POL_TB_CTRL_t                  TB_CTRL;                       /* addr: 0x00000130 */
  ca_uint32_t                              rsrvd33[3];                   
  SATURN_L2TM_L2TE_POL_TB_CTRL1_t                 TB_CTRL1;                      /* addr: 0x00000134 */
} SATURN_APB0_L2TM_L2TE_POL_t;


/*
 * l2te_shp
 */
        
#define  SATURN_L2TM_L2TE_SHP_IPG_PROFILE                0xd0002700
#define  SATURN_L2TM_L2TE_SHP_IPG_PROFILE_dft            0x14141414

typedef volatile union {
  struct {
    ca_uint32_t ipg0                 :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t ipg1                 :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t ipg2                 :  5 ; /* bits 20:16 */
    ca_uint32_t rsrvd3               :  3 ;
    ca_uint32_t ipg3                 :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd4               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_SHP_IPG_PROFILE_t;


#define  SATURN_L2TM_L2TE_SHP_PORT_IPG_SELECT0           0xd0002704
#define  SATURN_L2TM_L2TE_SHP_PORT_IPG_SELECT0_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pid0                 :  2 ; /* bits 1:0 */
    ca_uint32_t pid1                 :  2 ; /* bits 3:2 */
    ca_uint32_t pid2                 :  2 ; /* bits 5:4 */
    ca_uint32_t pid3                 :  2 ; /* bits 7:6 */
    ca_uint32_t pid4                 :  2 ; /* bits 9:8 */
    ca_uint32_t pid5                 :  2 ; /* bits 11:10 */
    ca_uint32_t pid6                 :  2 ; /* bits 13:12 */
    ca_uint32_t pid7                 :  2 ; /* bits 15:14 */
    ca_uint32_t pid8                 :  2 ; /* bits 17:16 */
    ca_uint32_t pid9                 :  2 ; /* bits 19:18 */
    ca_uint32_t pid10                :  2 ; /* bits 21:20 */
    ca_uint32_t pid11                :  2 ; /* bits 23:22 */
    ca_uint32_t pid12                :  2 ; /* bits 25:24 */
    ca_uint32_t pid13                :  2 ; /* bits 27:26 */
    ca_uint32_t pid14                :  2 ; /* bits 29:28 */
    ca_uint32_t pid15                :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_SHP_PORT_IPG_SELECT0_t;


#define  SATURN_L2TM_L2TE_SHP_SRP_CONFIG0                0xd0002708
#define  SATURN_L2TM_L2TE_SHP_SRP_CONFIG0_STRIDE         4
#define  SATURN_L2TM_L2TE_SHP_SRP_CONFIG0_COUNT          2
#define  SATURN_L2TM_L2TE_SHP_SRP_CONFIG0_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cfg0_enb             :  1 ; /* bits 0:0 */
    ca_uint32_t cfg0_cos             :  3 ; /* bits 3:1 */
    ca_uint32_t rsrvd1               : 11 ;
    ca_uint32_t cfg0_class_b         :  1 ; /* bits 15:15 */
    ca_uint32_t cfg1_enb             :  1 ; /* bits 16:16 */
    ca_uint32_t cfg1_cos             :  3 ; /* bits 19:17 */
    ca_uint32_t rsrvd2               : 11 ;
    ca_uint32_t cfg1_class_b         :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_SHP_SRP_CONFIG0_t;

    
#define  SATURN_L2TM_L2TE_SHP_SRP_CONFIG_EN              0xd0002710
#define  SATURN_L2TM_L2TE_SHP_SRP_CONFIG_EN_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pid0                 :  4 ; /* bits 3:0 */
    ca_uint32_t pid1                 :  4 ; /* bits 7:4 */
    ca_uint32_t pid2                 :  4 ; /* bits 11:8 */
    ca_uint32_t pid3                 :  4 ; /* bits 15:12 */
    ca_uint32_t pid4                 :  4 ; /* bits 19:16 */
    ca_uint32_t pid5                 :  4 ; /* bits 23:20 */
    ca_uint32_t pid6                 :  4 ; /* bits 27:24 */
    ca_uint32_t pid7                 :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_SHP_SRP_CONFIG_EN_t;


#define  SATURN_L2TM_L2TE_SHP_CTRL                       0xd0002714
#define  SATURN_L2TM_L2TE_SHP_CTRL_dft                   0x0000007c

typedef volatile union {
  struct {
    ca_uint32_t pkt_mode_class0_cnt  :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t pkt_mode_class1_cnt  :  7 ; /* bits 14:8 */
    ca_uint32_t rsrvd2               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_SHP_CTRL_t;


#define  SATURN_L2TM_L2TE_SHP_PORT_TBC_MEM_ACCESS        0xd0002718
#define  SATURN_L2TM_L2TE_SHP_PORT_TBC_MEM_ACCESS_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_SHP_PORT_TBC_MEM_ACCESS_t;


#define  SATURN_L2TM_L2TE_SHP_PORT_TBC_MEM_DATA1         0xd000271c
#define  SATURN_L2TM_L2TE_SHP_PORT_TBC_MEM_DATA1_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bs                   :  6 ; /* bits 5:0 */
    ca_uint32_t enb                  :  2 ; /* bits 7:6 */
    ca_uint32_t mode                 :  1 ; /* bits 8:8 */
    ca_uint32_t tbc                  : 21 ; /* bits 29:9 */
    ca_uint32_t pkt_mode_class_sel   :  1 ; /* bits 30:30 */
    ca_uint32_t rsrvd1               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_SHP_PORT_TBC_MEM_DATA1_t;


#define  SATURN_L2TM_L2TE_SHP_PORT_TBC_MEM_DATA0         0xd0002720
#define  SATURN_L2TM_L2TE_SHP_PORT_TBC_MEM_DATA0_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rate_k               : 10 ; /* bits 9:0 */
    ca_uint32_t rate_m               : 16 ; /* bits 25:10 */
    ca_uint32_t bs                   :  6 ; /* bits 31:26 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_SHP_PORT_TBC_MEM_DATA0_t;


#define  SATURN_L2TM_L2TE_SHP_GROUP_TBC_MEM_ACCESS       0xd0002724
#define  SATURN_L2TM_L2TE_SHP_GROUP_TBC_MEM_ACCESS_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_SHP_GROUP_TBC_MEM_ACCESS_t;


#define  SATURN_L2TM_L2TE_SHP_GROUP_TBC_MEM_DATA1        0xd0002728
#define  SATURN_L2TM_L2TE_SHP_GROUP_TBC_MEM_DATA1_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bs                   :  6 ; /* bits 5:0 */
    ca_uint32_t enb                  :  2 ; /* bits 7:6 */
    ca_uint32_t mode                 :  1 ; /* bits 8:8 */
    ca_uint32_t tbc                  : 21 ; /* bits 29:9 */
    ca_uint32_t pkt_mode_class_sel   :  1 ; /* bits 30:30 */
    ca_uint32_t rsrvd1               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_SHP_GROUP_TBC_MEM_DATA1_t;


#define  SATURN_L2TM_L2TE_SHP_GROUP_TBC_MEM_DATA0        0xd000272c
#define  SATURN_L2TM_L2TE_SHP_GROUP_TBC_MEM_DATA0_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rate_k               : 10 ; /* bits 9:0 */
    ca_uint32_t rate_m               : 16 ; /* bits 25:10 */
    ca_uint32_t bs                   :  6 ; /* bits 31:26 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_SHP_GROUP_TBC_MEM_DATA0_t;


#define  SATURN_L2TM_L2TE_SHP_VOQ_TBC_MEM_ACCESS         0xd0002730
#define  SATURN_L2TM_L2TE_SHP_VOQ_TBC_MEM_ACCESS_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_SHP_VOQ_TBC_MEM_ACCESS_t;


#define  SATURN_L2TM_L2TE_SHP_VOQ_TBC_MEM_DATA1          0xd0002734
#define  SATURN_L2TM_L2TE_SHP_VOQ_TBC_MEM_DATA1_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bs                   :  6 ; /* bits 5:0 */
    ca_uint32_t enb                  :  2 ; /* bits 7:6 */
    ca_uint32_t mode                 :  1 ; /* bits 8:8 */
    ca_uint32_t tbc                  : 21 ; /* bits 29:9 */
    ca_uint32_t pkt_mode_class_sel   :  1 ; /* bits 30:30 */
    ca_uint32_t rsrvd1               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_SHP_VOQ_TBC_MEM_DATA1_t;


#define  SATURN_L2TM_L2TE_SHP_VOQ_TBC_MEM_DATA0          0xd0002738
#define  SATURN_L2TM_L2TE_SHP_VOQ_TBC_MEM_DATA0_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rate_k               : 10 ; /* bits 9:0 */
    ca_uint32_t rate_m               : 16 ; /* bits 25:10 */
    ca_uint32_t bs                   :  6 ; /* bits 31:26 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_SHP_VOQ_TBC_MEM_DATA0_t;


#define  SATURN_L2TM_L2TE_SHP_TB_CTRL                    0xd000273c
#define  SATURN_L2TM_L2TE_SHP_TB_CTRL_dft                0x2ff3e723

typedef volatile union {
  struct {
    ca_uint32_t addtok_en            :  1 ; /* bits 0:0 */
    ca_uint32_t subtok_en            :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t upd_cnt_lmt          :  4 ; /* bits 7:4 */
    ca_uint32_t cyc_cnt_lmt          : 12 ; /* bits 19:8 */
    ca_uint32_t last_upd_cyc         : 12 ; /* bits 31:20 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_SHP_TB_CTRL_t;


#define  SATURN_L2TM_L2TE_SHP_TB_CTRL1                   0xd0002740
#define  SATURN_L2TM_L2TE_SHP_TB_CTRL1_dft               0x000001f3

typedef volatile union {
  struct {
    ca_uint32_t k_cnt_lmt            : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_SHP_TB_CTRL1_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2te_shp */
typedef struct {
  SATURN_L2TM_L2TE_SHP_IPG_PROFILE_t              IPG_PROFILE;                   /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_L2TM_L2TE_SHP_PORT_IPG_SELECT0_t         PORT_IPG_SELECT0;              /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_L2TM_L2TE_SHP_SRP_CONFIG0_t              SRP_CONFIG0;                   /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[7];                    
  SATURN_L2TM_L2TE_SHP_SRP_CONFIG_EN_t            SRP_CONFIG_EN;                 /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_L2TM_L2TE_SHP_CTRL_t                     CTRL;                          /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_L2TM_L2TE_SHP_PORT_TBC_MEM_ACCESS_t      PORT_TBC_MEM_ACCESS;           /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_L2TM_L2TE_SHP_PORT_TBC_MEM_DATA1_t       PORT_TBC_MEM_DATA1;            /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd7[3];                    
  SATURN_L2TM_L2TE_SHP_PORT_TBC_MEM_DATA0_t       PORT_TBC_MEM_DATA0;            /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd8[3];                    
  SATURN_L2TM_L2TE_SHP_GROUP_TBC_MEM_ACCESS_t     GROUP_TBC_MEM_ACCESS;          /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd9[3];                    
  SATURN_L2TM_L2TE_SHP_GROUP_TBC_MEM_DATA1_t      GROUP_TBC_MEM_DATA1;           /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd10[3];                   
  SATURN_L2TM_L2TE_SHP_GROUP_TBC_MEM_DATA0_t      GROUP_TBC_MEM_DATA0;           /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd11[3];                   
  SATURN_L2TM_L2TE_SHP_VOQ_TBC_MEM_ACCESS_t       VOQ_TBC_MEM_ACCESS;            /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd12[3];                   
  SATURN_L2TM_L2TE_SHP_VOQ_TBC_MEM_DATA1_t        VOQ_TBC_MEM_DATA1;             /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd13[3];                   
  SATURN_L2TM_L2TE_SHP_VOQ_TBC_MEM_DATA0_t        VOQ_TBC_MEM_DATA0;             /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd14[3];                   
  SATURN_L2TM_L2TE_SHP_TB_CTRL_t                  TB_CTRL;                       /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd15[3];                   
  SATURN_L2TM_L2TE_SHP_TB_CTRL1_t                 TB_CTRL1;                      /* addr: 0x00000040 */
} SATURN_APB0_L2TM_L2TE_SHP_t;


/*
 * l2te_wred
 */
        
#define  SATURN_L2TM_L2TE_WRED_CTRL                      0xd0002800
#define  SATURN_L2TM_L2TE_WRED_CTRL_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t fast_decay           :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t afgs_weight          :  4 ; /* bits 7:4 */
    ca_uint32_t rsrvd3               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_WRED_CTRL_t;


#define  SATURN_L2TM_L2TE_WRED_AFGS_MEM_ACCESS           0xd0002804
#define  SATURN_L2TM_L2TE_WRED_AFGS_MEM_ACCESS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 29 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_WRED_AFGS_MEM_ACCESS_t;


#define  SATURN_L2TM_L2TE_WRED_AFGS_MEM_DATA             0xd0002808
#define  SATURN_L2TM_L2TE_WRED_AFGS_MEM_DATA_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t depth                : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_WRED_AFGS_MEM_DATA_t;


#define  SATURN_L2TM_L2TE_WRED_PROFILE_MEM_ACCESS        0xd000280c
#define  SATURN_L2TM_L2TE_WRED_PROFILE_MEM_ACCESS_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_WRED_PROFILE_MEM_ACCESS_t;


#define  SATURN_L2TM_L2TE_WRED_PROFILE_MEM_DATA7         0xd0002810
#define  SATURN_L2TM_L2TE_WRED_PROFILE_MEM_DATA7_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data_rsvd            :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_WRED_PROFILE_MEM_DATA7_t;


#define  SATURN_L2TM_L2TE_WRED_PROFILE_MEM_DATA6         0xd0002814
#define  SATURN_L2TM_L2TE_WRED_PROFILE_MEM_DATA6_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t unmark_idx           :  4 ; /* bits 3:0 */
    ca_uint32_t mark_idx             :  4 ; /* bits 7:4 */
    ca_uint32_t data_rsvd            : 24 ; /* bits 31:8 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_WRED_PROFILE_MEM_DATA6_t;


#define  SATURN_L2TM_L2TE_WRED_PROFILE_MEM_DATA5         0xd0002818
#define  SATURN_L2TM_L2TE_WRED_PROFILE_MEM_DATA5_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mark_dps             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_WRED_PROFILE_MEM_DATA5_t;


#define  SATURN_L2TM_L2TE_WRED_PROFILE_MEM_DATA4         0xd000281c
#define  SATURN_L2TM_L2TE_WRED_PROFILE_MEM_DATA4_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mark_dps             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_WRED_PROFILE_MEM_DATA4_t;


#define  SATURN_L2TM_L2TE_WRED_PROFILE_MEM_DATA3         0xd0002820
#define  SATURN_L2TM_L2TE_WRED_PROFILE_MEM_DATA3_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mark_dps             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_WRED_PROFILE_MEM_DATA3_t;


#define  SATURN_L2TM_L2TE_WRED_PROFILE_MEM_DATA2         0xd0002824
#define  SATURN_L2TM_L2TE_WRED_PROFILE_MEM_DATA2_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t unmark_dps           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_WRED_PROFILE_MEM_DATA2_t;


#define  SATURN_L2TM_L2TE_WRED_PROFILE_MEM_DATA1         0xd0002828
#define  SATURN_L2TM_L2TE_WRED_PROFILE_MEM_DATA1_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t unmark_dps           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_WRED_PROFILE_MEM_DATA1_t;


#define  SATURN_L2TM_L2TE_WRED_PROFILE_MEM_DATA0         0xd000282c
#define  SATURN_L2TM_L2TE_WRED_PROFILE_MEM_DATA0_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t unmark_dps           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_WRED_PROFILE_MEM_DATA0_t;


#define  SATURN_L2TM_L2TE_WRED_PROFILE_SELECT_MEM_ACCESS 0xd0002830
#define  SATURN_L2TM_L2TE_WRED_PROFILE_SELECT_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_WRED_PROFILE_SELECT_MEM_ACCESS_t;


#define  SATURN_L2TM_L2TE_WRED_PROFILE_SELECT_MEM_DATA1  0xd0002834
#define  SATURN_L2TM_L2TE_WRED_PROFILE_SELECT_MEM_DATA1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sel6                 :  3 ; /* bits 2:0 */
    ca_uint32_t sel7                 :  5 ; /* bits 7:3 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_WRED_PROFILE_SELECT_MEM_DATA1_t;


#define  SATURN_L2TM_L2TE_WRED_PROFILE_SELECT_MEM_DATA0  0xd0002838
#define  SATURN_L2TM_L2TE_WRED_PROFILE_SELECT_MEM_DATA0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sel0                 :  5 ; /* bits 4:0 */
    ca_uint32_t sel1                 :  5 ; /* bits 9:5 */
    ca_uint32_t sel2                 :  5 ; /* bits 14:10 */
    ca_uint32_t sel3                 :  5 ; /* bits 19:15 */
    ca_uint32_t sel4                 :  5 ; /* bits 24:20 */
    ca_uint32_t sel5                 :  5 ; /* bits 29:25 */
    ca_uint32_t sel6                 :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_WRED_PROFILE_SELECT_MEM_DATA0_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2te_wred */
typedef struct {
  SATURN_L2TM_L2TE_WRED_CTRL_t                    CTRL;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_L2TM_L2TE_WRED_AFGS_MEM_ACCESS_t         AFGS_MEM_ACCESS;               /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_L2TM_L2TE_WRED_AFGS_MEM_DATA_t           AFGS_MEM_DATA;                 /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_L2TM_L2TE_WRED_PROFILE_MEM_ACCESS_t      PROFILE_MEM_ACCESS;            /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_L2TM_L2TE_WRED_PROFILE_MEM_DATA7_t       PROFILE_MEM_DATA7;             /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_L2TM_L2TE_WRED_PROFILE_MEM_DATA6_t       PROFILE_MEM_DATA6;             /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_L2TM_L2TE_WRED_PROFILE_MEM_DATA5_t       PROFILE_MEM_DATA5;             /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  SATURN_L2TM_L2TE_WRED_PROFILE_MEM_DATA4_t       PROFILE_MEM_DATA4;             /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  SATURN_L2TM_L2TE_WRED_PROFILE_MEM_DATA3_t       PROFILE_MEM_DATA3;             /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  SATURN_L2TM_L2TE_WRED_PROFILE_MEM_DATA2_t       PROFILE_MEM_DATA2;             /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  SATURN_L2TM_L2TE_WRED_PROFILE_MEM_DATA1_t       PROFILE_MEM_DATA1;             /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  SATURN_L2TM_L2TE_WRED_PROFILE_MEM_DATA0_t       PROFILE_MEM_DATA0;             /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  SATURN_L2TM_L2TE_WRED_PROFILE_SELECT_MEM_ACCESS_t PROFILE_SELECT_MEM_ACCESS;     /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  SATURN_L2TM_L2TE_WRED_PROFILE_SELECT_MEM_DATA1_t PROFILE_SELECT_MEM_DATA1;      /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  SATURN_L2TM_L2TE_WRED_PROFILE_SELECT_MEM_DATA0_t PROFILE_SELECT_MEM_DATA0;      /* addr: 0x00000038 */
} SATURN_APB0_L2TM_L2TE_WRED_t;


/*
 * l2te_fc_glb
 */
        
#define  SATURN_L2TM_L2TE_FC_GLB_INT                     0xd0002900
#define  SATURN_L2TM_L2TE_FC_GLB_INT_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rxflowcntl0          :  1 ; /* bits 0:0 */
    ca_uint32_t rxflowcntl1          :  1 ; /* bits 1:1 */
    ca_uint32_t rxflowcntl2          :  1 ; /* bits 2:2 */
    ca_uint32_t rxflowcntl3          :  1 ; /* bits 3:3 */
    ca_uint32_t rxflowcntl4          :  1 ; /* bits 4:4 */
    ca_uint32_t rxflowcntl5          :  1 ; /* bits 5:5 */
    ca_uint32_t rxflowcntl6          :  1 ; /* bits 6:6 */
    ca_uint32_t rxflowcntl7          :  1 ; /* bits 7:7 */
    ca_uint32_t rxflowcntl8          :  1 ; /* bits 8:8 */
    ca_uint32_t rxflowcntl9          :  1 ; /* bits 9:9 */
    ca_uint32_t rxflowcntl10         :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t rxflowcntl13         :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t txflowcntl0          :  1 ; /* bits 16:16 */
    ca_uint32_t txflowcntl1          :  1 ; /* bits 17:17 */
    ca_uint32_t txflowcntl2          :  1 ; /* bits 18:18 */
    ca_uint32_t txflowcntl3          :  1 ; /* bits 19:19 */
    ca_uint32_t txflowcntl4          :  1 ; /* bits 20:20 */
    ca_uint32_t txflowcntl5          :  1 ; /* bits 21:21 */
    ca_uint32_t txflowcntl6          :  1 ; /* bits 22:22 */
    ca_uint32_t txflowcntl7          :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t txflowcntl9          :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd4               :  1 ;
    ca_uint32_t txflowcntl11         :  1 ; /* bits 27:27 */
    ca_uint32_t txflowcntl12         :  1 ; /* bits 28:28 */
    ca_uint32_t txflowcntl13         :  1 ; /* bits 29:29 */
    ca_uint32_t txflowcntl14         :  1 ; /* bits 30:30 */
    ca_uint32_t txflowcntl15         :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_FC_GLB_INT_t;


#define  SATURN_L2TM_L2TE_FC_GLB_INTE                    0xd0002904
#define  SATURN_L2TM_L2TE_FC_GLB_INTE_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rxflowcntl0E         :  1 ; /* bits 0:0 */
    ca_uint32_t rxflowcntl1E         :  1 ; /* bits 1:1 */
    ca_uint32_t rxflowcntl2E         :  1 ; /* bits 2:2 */
    ca_uint32_t rxflowcntl3E         :  1 ; /* bits 3:3 */
    ca_uint32_t rxflowcntl4E         :  1 ; /* bits 4:4 */
    ca_uint32_t rxflowcntl5E         :  1 ; /* bits 5:5 */
    ca_uint32_t rxflowcntl6E         :  1 ; /* bits 6:6 */
    ca_uint32_t rxflowcntl7E         :  1 ; /* bits 7:7 */
    ca_uint32_t rxflowcntl8E         :  1 ; /* bits 8:8 */
    ca_uint32_t rxflowcntl9E         :  1 ; /* bits 9:9 */
    ca_uint32_t rxflowcntl10E        :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t rxflowcntl13E        :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t txflowcntl0E         :  1 ; /* bits 16:16 */
    ca_uint32_t txflowcntl1E         :  1 ; /* bits 17:17 */
    ca_uint32_t txflowcntl2E         :  1 ; /* bits 18:18 */
    ca_uint32_t txflowcntl3E         :  1 ; /* bits 19:19 */
    ca_uint32_t txflowcntl4E         :  1 ; /* bits 20:20 */
    ca_uint32_t txflowcntl5E         :  1 ; /* bits 21:21 */
    ca_uint32_t txflowcntl6E         :  1 ; /* bits 22:22 */
    ca_uint32_t txflowcntl7E         :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t txflowcntl9E         :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd4               :  1 ;
    ca_uint32_t txflowcntl11E        :  1 ; /* bits 27:27 */
    ca_uint32_t txflowcntl12E        :  1 ; /* bits 28:28 */
    ca_uint32_t txflowcntl13E        :  1 ; /* bits 29:29 */
    ca_uint32_t txflowcntl14E        :  1 ; /* bits 30:30 */
    ca_uint32_t txflowcntl15E        :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_FC_GLB_INTE_t;


#define  SATURN_L2TM_L2TE_FC_GLB_CTRL                    0xd0002908
#define  SATURN_L2TM_L2TE_FC_GLB_CTRL_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t deepq_rxpfc_en       :  8 ; /* bits 7:0 */
    ca_uint32_t cpu_rxpfc_en         :  8 ; /* bits 15:8 */
    ca_uint32_t l3fewan_rxpfc_en     :  8 ; /* bits 23:16 */
    ca_uint32_t l3felan_rxpfc_en     :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_FC_GLB_CTRL_t;


#define  SATURN_L2TM_L2TE_FC_GLB_STS                     0xd000290c
#define  SATURN_L2TM_L2TE_FC_GLB_STS_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t deepq_rxpfc          :  8 ; /* bits 7:0 */
    ca_uint32_t cpu_rxpfc            :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_FC_GLB_STS_t;


#define  SATURN_L2TM_L2TE_FC_GLB_TIMER                   0xd0002910
#define  SATURN_L2TM_L2TE_FC_GLB_TIMER_dft               0x000073ff

typedef volatile union {
  struct {
    ca_uint32_t num_of_cycles        : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t cycle_unit           :  3 ; /* bits 14:12 */
    ca_uint32_t rsrvd2               : 16 ;
    ca_uint32_t enable               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_FC_GLB_TIMER_t;


#define  SATURN_L2TM_L2TE_FC_GLB_PFC_CTRL0               0xd0002914
#define  SATURN_L2TM_L2TE_FC_GLB_PFC_CTRL0_STRIDE        8
#define  SATURN_L2TM_L2TE_FC_GLB_PFC_CTRL0_COUNT         2
#define  SATURN_L2TM_L2TE_FC_GLB_PFC_CTRL0_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cos_bmap             :  8 ; /* bits 7:0 */
    ca_uint32_t port_bmap            :  8 ; /* bits 15:8 */
    ca_uint32_t rxpfc_en             :  1 ; /* bits 16:16 */
    ca_uint32_t txpfc_en             :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_FC_GLB_PFC_CTRL0_t;


#define  SATURN_L2TM_L2TE_FC_GLB_PFC_CNT0                0xd0002918
#define  SATURN_L2TM_L2TE_FC_GLB_PFC_CNT0_STRIDE         8
#define  SATURN_L2TM_L2TE_FC_GLB_PFC_CNT0_COUNT          2
#define  SATURN_L2TM_L2TE_FC_GLB_PFC_CNT0_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_FC_GLB_PFC_CNT0_t;

            
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2te_fc_glb */
typedef struct {
  SATURN_L2TM_L2TE_FC_GLB_INT_t                   INT;                           /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_L2TM_L2TE_FC_GLB_INTE_t                  INTE;                          /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_L2TM_L2TE_FC_GLB_CTRL_t                  CTRL;                          /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_L2TM_L2TE_FC_GLB_STS_t                   STS;                           /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_L2TM_L2TE_FC_GLB_TIMER_t                 TIMER;                         /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_L2TM_L2TE_FC_GLB_PFC_CTRL0_t             PFC_CTRL0;                     /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_L2TM_L2TE_FC_GLB_PFC_CNT0_t              PFC_CNT0;                      /* addr: 0x00000018 */
} SATURN_APB0_L2TM_L2TE_FC_GLB_t;


/*
 * l2te_fc[0..13]
 */
        
#define  SATURN_L2TM_L2TE_FC_CTRL                        0xd0002980
#define  SATURN_L2TM_L2TE_FC_CTRL_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_en                :  1 ; /* bits 0:0 */
    ca_uint32_t tx_en                :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t stat_pri_sel         :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_FC_CTRL_t;


#define  SATURN_L2TM_L2TE_FC_STS                         0xd0002984
#define  SATURN_L2TM_L2TE_FC_STS_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rxpfc                :  8 ; /* bits 7:0 */
    ca_uint32_t txpfc                :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_FC_STS_t;


#define  SATURN_L2TM_L2TE_FC_STAT                        0xd0002988
#define  SATURN_L2TM_L2TE_FC_STAT_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t flag_num             :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t voq                  :  7 ; /* bits 10:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t qm_voq               :  9 ; /* bits 20:12 */
    ca_uint32_t rsrvd3               :  9 ;
    ca_uint32_t txpfc                :  1 ; /* bits 30:30 */
    ca_uint32_t rxpfc                :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_FC_STAT_t;

    
#define  SATURN_APB0_L2TM_L2TE_FC_STRIDE                 64
#define  SATURN_APB0_L2TM_L2TE_FC_COUNT                  14
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2te_fc */
typedef struct {
  SATURN_L2TM_L2TE_FC_CTRL_t                      CTRL;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_L2TM_L2TE_FC_STS_t                       STS;                           /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_L2TM_L2TE_FC_STAT_t                      STAT;                          /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[55];                   
} SATURN_APB0_L2TM_L2TE_FC_t;


/*
 * l2te_cb
 */
        
#define  SATURN_L2TM_L2TE_CB_INT                         0xd0002d00
#define  SATURN_L2TM_L2TE_CB_INT_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t voq_bufcnt_udfl      :  1 ; /* bits 0:0 */
    ca_uint32_t voq_bufcnt_ovfl      :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t port_freecnt_udfl    :  1 ; /* bits 4:4 */
    ca_uint32_t port_freecnt_ovfl    :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd2               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_INT_t;


#define  SATURN_L2TM_L2TE_CB_INTE                        0xd0002d04
#define  SATURN_L2TM_L2TE_CB_INTE_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t voq_bufcnt_udflE     :  1 ; /* bits 0:0 */
    ca_uint32_t voq_bufcnt_ovflE     :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t port_freecnt_udflE   :  1 ; /* bits 4:4 */
    ca_uint32_t port_freecnt_ovflE   :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd2               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_INTE_t;


#define  SATURN_L2TM_L2TE_CB_ERR_INFO                    0xd0002d08
#define  SATURN_L2TM_L2TE_CB_ERR_INFO_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t voq_of_buferr        :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_ERR_INFO_t;


#define  SATURN_L2TM_L2TE_CB_CTRL                        0xd0002d0c
#define  SATURN_L2TM_L2TE_CB_CTRL_dft                    0x0003ff03

typedef volatile union {
  struct {
    ca_uint32_t scan_cycle_per_run   :  8 ; /* bits 7:0 */
    ca_uint32_t scan_cycle_unit      : 10 ; /* bits 17:8 */
    ca_uint32_t rsrvd1               : 13 ;
    ca_uint32_t scan_enable          :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_CTRL_t;


#define  SATURN_L2TM_L2TE_CB_TM_DQSCH_HI_BUF_USG0        0xd0002d10
#define  SATURN_L2TM_L2TE_CB_TM_DQSCH_HI_BUF_USG0_STRIDE 4
#define  SATURN_L2TM_L2TE_CB_TM_DQSCH_HI_BUF_USG0_COUNT  2
#define  SATURN_L2TM_L2TE_CB_TM_DQSCH_HI_BUF_USG0_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dqid                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_TM_DQSCH_HI_BUF_USG0_t;

    
#define  SATURN_L2TM_L2TE_CB_TM_DQSCH_MID_BUF_USG0       0xd0002d18
#define  SATURN_L2TM_L2TE_CB_TM_DQSCH_MID_BUF_USG0_STRIDE 4
#define  SATURN_L2TM_L2TE_CB_TM_DQSCH_MID_BUF_USG0_COUNT 2
#define  SATURN_L2TM_L2TE_CB_TM_DQSCH_MID_BUF_USG0_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dqid                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_TM_DQSCH_MID_BUF_USG0_t;

    
#define  SATURN_L2TM_L2TE_CB_TM_TAILDROP_STS0            0xd0002d20
#define  SATURN_L2TM_L2TE_CB_TM_TAILDROP_STS0_STRIDE     4
#define  SATURN_L2TM_L2TE_CB_TM_TAILDROP_STS0_COUNT      4
#define  SATURN_L2TM_L2TE_CB_TM_TAILDROP_STS0_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t voq                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_TM_TAILDROP_STS0_t;

            
#define  SATURN_L2TM_L2TE_CB_QM_TAILDROP_STS0            0xd0002d30
#define  SATURN_L2TM_L2TE_CB_QM_TAILDROP_STS0_STRIDE     4
#define  SATURN_L2TM_L2TE_CB_QM_TAILDROP_STS0_COUNT      12
#define  SATURN_L2TM_L2TE_CB_QM_TAILDROP_STS0_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t voq                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_QM_TAILDROP_STS0_t;

                                            
#define  SATURN_L2TM_L2TE_CB_GLOB_TD_STS                 0xd0002d60
#define  SATURN_L2TM_L2TE_CB_GLOB_TD_STS_dft             0x0020ffff

typedef volatile union {
  struct {
    ca_uint32_t per_port_prvt_avl    : 16 ; /* bits 15:0 */
    ca_uint32_t noncong_buf_avl      :  1 ; /* bits 16:16 */
    ca_uint32_t common_buf_avl       :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t fc_buf_usg_l         :  1 ; /* bits 21:21 */
    ca_uint32_t fc_buf_usg_m         :  1 ; /* bits 22:22 */
    ca_uint32_t fc_buf_usg_h         :  1 ; /* bits 23:23 */
    ca_uint32_t pfc                  :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_GLOB_TD_STS_t;


#define  SATURN_L2TM_L2TE_CB_PORT_TD_STS                 0xd0002d64
#define  SATURN_L2TM_L2TE_CB_PORT_TD_STS_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t port                 : 16 ; /* bits 15:0 */
    ca_uint32_t src_port             : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_PORT_TD_STS_t;


#define  SATURN_L2TM_L2TE_CB_VOQ_TD_STS0                 0xd0002d68
#define  SATURN_L2TM_L2TE_CB_VOQ_TD_STS0_STRIDE          4
#define  SATURN_L2TM_L2TE_CB_VOQ_TD_STS0_COUNT           4
#define  SATURN_L2TM_L2TE_CB_VOQ_TD_STS0_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t voq                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_VOQ_TD_STS0_t;

            
#define  SATURN_L2TM_L2TE_CB_SRC_PRI_TD_STS              0xd0002d78
#define  SATURN_L2TM_L2TE_CB_SRC_PRI_TD_STS_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t src_pri              : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_SRC_PRI_TD_STS_t;


#define  SATURN_L2TM_L2TE_CB_PORT_THRSH_PROFILE0         0xd0002d7c
#define  SATURN_L2TM_L2TE_CB_PORT_THRSH_PROFILE0_STRIDE  8
#define  SATURN_L2TM_L2TE_CB_PORT_THRSH_PROFILE0_COUNT   4
#define  SATURN_L2TM_L2TE_CB_PORT_THRSH_PROFILE0_dft     0x7fff7fff

typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t hth                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_PORT_THRSH_PROFILE0_t;


#define  SATURN_L2TM_L2TE_CB_PORT_GRPTHRSH_PROFILE0      0xd0002d80
#define  SATURN_L2TM_L2TE_CB_PORT_GRPTHRSH_PROFILE0_STRIDE 8
#define  SATURN_L2TM_L2TE_CB_PORT_GRPTHRSH_PROFILE0_COUNT 4
#define  SATURN_L2TM_L2TE_CB_PORT_GRPTHRSH_PROFILE0_dft  0x7fff7fff

typedef volatile union {
  struct {
    ca_uint32_t grplth               : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t grphth               : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_PORT_GRPTHRSH_PROFILE0_t;

                        
#define  SATURN_L2TM_L2TE_CB_PORT_THRSH_SELECT           0xd0002d9c
#define  SATURN_L2TM_L2TE_CB_PORT_THRSH_SELECT_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t thsel0               :  2 ; /* bits 1:0 */
    ca_uint32_t thsel1               :  2 ; /* bits 3:2 */
    ca_uint32_t thsel2               :  2 ; /* bits 5:4 */
    ca_uint32_t thsel3               :  2 ; /* bits 7:6 */
    ca_uint32_t thsel4               :  2 ; /* bits 9:8 */
    ca_uint32_t thsel5               :  2 ; /* bits 11:10 */
    ca_uint32_t thsel6               :  2 ; /* bits 13:12 */
    ca_uint32_t thsel7               :  2 ; /* bits 15:14 */
    ca_uint32_t thsel8               :  2 ; /* bits 17:16 */
    ca_uint32_t thsel9               :  2 ; /* bits 19:18 */
    ca_uint32_t thsel10              :  2 ; /* bits 21:20 */
    ca_uint32_t thsel11              :  2 ; /* bits 23:22 */
    ca_uint32_t thsel12              :  2 ; /* bits 25:24 */
    ca_uint32_t thsel13              :  2 ; /* bits 27:26 */
    ca_uint32_t thsel14              :  2 ; /* bits 29:28 */
    ca_uint32_t thsel15              :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_PORT_THRSH_SELECT_t;


#define  SATURN_L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_ACCESS 0xd0002da0
#define  SATURN_L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 27 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_ACCESS_t;


#define  SATURN_L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_DATA1 0xd0002da4
#define  SATURN_L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_DATA1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t grplth               : 13 ; /* bits 12:0 */
    ca_uint32_t grphth               : 15 ; /* bits 27:13 */
    ca_uint32_t rsrvd1               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_DATA1_t;


#define  SATURN_L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_DATA0 0xd0002da8
#define  SATURN_L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_DATA0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t hth                  : 15 ; /* bits 29:15 */
    ca_uint32_t grplth               :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_DATA0_t;


#define  SATURN_L2TM_L2TE_CB_VOQ_THRSH_SELECT_MEM_ACCESS 0xd0002dac
#define  SATURN_L2TM_L2TE_CB_VOQ_THRSH_SELECT_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_VOQ_THRSH_SELECT_MEM_ACCESS_t;


#define  SATURN_L2TM_L2TE_CB_VOQ_THRSH_SELECT_MEM_DATA   0xd0002db0
#define  SATURN_L2TM_L2TE_CB_VOQ_THRSH_SELECT_MEM_DATA_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sel                  :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_VOQ_THRSH_SELECT_MEM_DATA_t;


#define  SATURN_L2TM_L2TE_CB_PORT_FREECNT_MEM_ACCESS     0xd0002db4
#define  SATURN_L2TM_L2TE_CB_PORT_FREECNT_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_PORT_FREECNT_MEM_ACCESS_t;


#define  SATURN_L2TM_L2TE_CB_PORT_FREECNT_MEM_DATA       0xd0002db8
#define  SATURN_L2TM_L2TE_CB_PORT_FREECNT_MEM_DATA_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt0                 : 15 ; /* bits 14:0 */
    ca_uint32_t cnt0_msb             :  1 ; /* bits 15:15 */
    ca_uint32_t cnt1                 : 15 ; /* bits 30:16 */
    ca_uint32_t cnt1_msb             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_PORT_FREECNT_MEM_DATA_t;


#define  SATURN_L2TM_L2TE_CB_VOQ_BUFCNT_MEM_ACCESS       0xd0002dbc
#define  SATURN_L2TM_L2TE_CB_VOQ_BUFCNT_MEM_ACCESS_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_VOQ_BUFCNT_MEM_ACCESS_t;


#define  SATURN_L2TM_L2TE_CB_VOQ_BUFCNT_MEM_DATA         0xd0002dc0
#define  SATURN_L2TM_L2TE_CB_VOQ_BUFCNT_MEM_DATA_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt0                 : 15 ; /* bits 14:0 */
    ca_uint32_t cnt0_rsvd            :  1 ; /* bits 15:15 */
    ca_uint32_t cnt1                 : 15 ; /* bits 30:16 */
    ca_uint32_t cnt1_rsvd            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_VOQ_BUFCNT_MEM_DATA_t;


#define  SATURN_L2TM_L2TE_CB_VOQ_MAX_BUFCNT_MEM_ACCESS   0xd0002dc4
#define  SATURN_L2TM_L2TE_CB_VOQ_MAX_BUFCNT_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_VOQ_MAX_BUFCNT_MEM_ACCESS_t;


#define  SATURN_L2TM_L2TE_CB_VOQ_MAX_BUFCNT_MEM_DATA     0xd0002dc8
#define  SATURN_L2TM_L2TE_CB_VOQ_MAX_BUFCNT_MEM_DATA_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_VOQ_MAX_BUFCNT_MEM_DATA_t;


#define  SATURN_L2TM_L2TE_CB_GLB_THRSH                   0xd0002dcc
#define  SATURN_L2TM_L2TE_CB_GLB_THRSH_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t hth                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_GLB_THRSH_t;


#define  SATURN_L2TM_L2TE_CB_GLB_PRI_THRSH0              0xd0002dd0
#define  SATURN_L2TM_L2TE_CB_GLB_PRI_THRSH0_STRIDE       4
#define  SATURN_L2TM_L2TE_CB_GLB_PRI_THRSH0_COUNT        8
#define  SATURN_L2TM_L2TE_CB_GLB_PRI_THRSH0_dft          0x7fff7fff

typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t hth                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_GLB_PRI_THRSH0_t;

                            
#define  SATURN_L2TM_L2TE_CB_SRC_CTRL                    0xd0002df0
#define  SATURN_L2TM_L2TE_CB_SRC_CTRL_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t src0_pri_nspid       :  3 ; /* bits 2:0 */
    ca_uint32_t src0_pri_en          :  1 ; /* bits 3:3 */
    ca_uint32_t src1_pri_nspid       :  3 ; /* bits 6:4 */
    ca_uint32_t src1_pri_en          :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_SRC_CTRL_t;


#define  SATURN_L2TM_L2TE_CB_SRC_PORT_THRSH_PROFILE0     0xd0002df4
#define  SATURN_L2TM_L2TE_CB_SRC_PORT_THRSH_PROFILE0_STRIDE 4
#define  SATURN_L2TM_L2TE_CB_SRC_PORT_THRSH_PROFILE0_COUNT 4
#define  SATURN_L2TM_L2TE_CB_SRC_PORT_THRSH_PROFILE0_dft 0x7fff7fff

typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t hth                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_SRC_PORT_THRSH_PROFILE0_t;

            
#define  SATURN_L2TM_L2TE_CB_SRC_PORT_THRSH_SELECT       0xd0002e04
#define  SATURN_L2TM_L2TE_CB_SRC_PORT_THRSH_SELECT_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t thsel0               :  2 ; /* bits 1:0 */
    ca_uint32_t thsel1               :  2 ; /* bits 3:2 */
    ca_uint32_t thsel2               :  2 ; /* bits 5:4 */
    ca_uint32_t thsel3               :  2 ; /* bits 7:6 */
    ca_uint32_t thsel4               :  2 ; /* bits 9:8 */
    ca_uint32_t thsel5               :  2 ; /* bits 11:10 */
    ca_uint32_t thsel6               :  2 ; /* bits 13:12 */
    ca_uint32_t thsel7               :  2 ; /* bits 15:14 */
    ca_uint32_t thsel8               :  2 ; /* bits 17:16 */
    ca_uint32_t thsel9               :  2 ; /* bits 19:18 */
    ca_uint32_t thsel10              :  2 ; /* bits 21:20 */
    ca_uint32_t thsel11              :  2 ; /* bits 23:22 */
    ca_uint32_t thsel12              :  2 ; /* bits 25:24 */
    ca_uint32_t thsel13              :  2 ; /* bits 27:26 */
    ca_uint32_t thsel14              :  2 ; /* bits 29:28 */
    ca_uint32_t thsel15              :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_SRC_PORT_THRSH_SELECT_t;


#define  SATURN_L2TM_L2TE_CB_SRC0_PRI_THRSH0             0xd0002e08
#define  SATURN_L2TM_L2TE_CB_SRC0_PRI_THRSH0_STRIDE      4
#define  SATURN_L2TM_L2TE_CB_SRC0_PRI_THRSH0_COUNT       8
#define  SATURN_L2TM_L2TE_CB_SRC0_PRI_THRSH0_dft         0x7fff7fff

typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t hth                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_SRC0_PRI_THRSH0_t;

                            
#define  SATURN_L2TM_L2TE_CB_SRC1_PRI_THRSH0             0xd0002e28
#define  SATURN_L2TM_L2TE_CB_SRC1_PRI_THRSH0_STRIDE      4
#define  SATURN_L2TM_L2TE_CB_SRC1_PRI_THRSH0_COUNT       8
#define  SATURN_L2TM_L2TE_CB_SRC1_PRI_THRSH0_dft         0x7fff7fff

typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t hth                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_SRC1_PRI_THRSH0_t;

                            
#define  SATURN_L2TM_L2TE_CB_SRC_PORT_BUFCNT_MEM_ACCESS  0xd0002e48
#define  SATURN_L2TM_L2TE_CB_SRC_PORT_BUFCNT_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_SRC_PORT_BUFCNT_MEM_ACCESS_t;


#define  SATURN_L2TM_L2TE_CB_SRC_PORT_BUFCNT_MEM_DATA    0xd0002e4c
#define  SATURN_L2TM_L2TE_CB_SRC_PORT_BUFCNT_MEM_DATA_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt0                 : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_SRC_PORT_BUFCNT_MEM_DATA_t;


#define  SATURN_L2TM_L2TE_CB_SRC_PRI_BUFCNT_MEM_ACCESS   0xd0002e50
#define  SATURN_L2TM_L2TE_CB_SRC_PRI_BUFCNT_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_SRC_PRI_BUFCNT_MEM_ACCESS_t;


#define  SATURN_L2TM_L2TE_CB_SRC_PRI_BUFCNT_MEM_DATA     0xd0002e54
#define  SATURN_L2TM_L2TE_CB_SRC_PRI_BUFCNT_MEM_DATA_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt0                 : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_SRC_PRI_BUFCNT_MEM_DATA_t;


#define  SATURN_L2TM_L2TE_CB_DQSCH_EQ_PROFILE_THRSH0     0xd0002e58
#define  SATURN_L2TM_L2TE_CB_DQSCH_EQ_PROFILE_THRSH0_dft 0x00007fff

typedef volatile union {
  struct {
    ca_uint32_t th0                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_DQSCH_EQ_PROFILE_THRSH0_t;


#define  SATURN_L2TM_L2TE_CB_DQSCH_PORT_THRSH_PROFILE0   0xd0002e5c
#define  SATURN_L2TM_L2TE_CB_DQSCH_PORT_THRSH_PROFILE0_STRIDE 4
#define  SATURN_L2TM_L2TE_CB_DQSCH_PORT_THRSH_PROFILE0_COUNT 4
#define  SATURN_L2TM_L2TE_CB_DQSCH_PORT_THRSH_PROFILE0_dft 0x7fff7fff

typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t hth                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_DQSCH_PORT_THRSH_PROFILE0_t;

            
#define  SATURN_L2TM_L2TE_CB_DQSCH_PORT_THRSH_SELECT     0xd0002e6c
#define  SATURN_L2TM_L2TE_CB_DQSCH_PORT_THRSH_SELECT_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t thsel0               :  2 ; /* bits 1:0 */
    ca_uint32_t thsel1               :  2 ; /* bits 3:2 */
    ca_uint32_t thsel2               :  2 ; /* bits 5:4 */
    ca_uint32_t thsel3               :  2 ; /* bits 7:6 */
    ca_uint32_t thsel4               :  2 ; /* bits 9:8 */
    ca_uint32_t thsel5               :  2 ; /* bits 11:10 */
    ca_uint32_t thsel6               :  2 ; /* bits 13:12 */
    ca_uint32_t thsel7               :  2 ; /* bits 15:14 */
    ca_uint32_t thsel8               :  2 ; /* bits 17:16 */
    ca_uint32_t thsel9               :  2 ; /* bits 19:18 */
    ca_uint32_t thsel10              :  2 ; /* bits 21:20 */
    ca_uint32_t thsel11              :  2 ; /* bits 23:22 */
    ca_uint32_t thsel12              :  2 ; /* bits 25:24 */
    ca_uint32_t thsel13              :  2 ; /* bits 27:26 */
    ca_uint32_t thsel14              :  2 ; /* bits 29:28 */
    ca_uint32_t thsel15              :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_DQSCH_PORT_THRSH_SELECT_t;


#define  SATURN_L2TM_L2TE_CB_DQSCH_VOQ_THRSH_PROFILE_MEM_ACCESS 0xd0002e70
#define  SATURN_L2TM_L2TE_CB_DQSCH_VOQ_THRSH_PROFILE_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 27 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_DQSCH_VOQ_THRSH_PROFILE_MEM_ACCESS_t;


#define  SATURN_L2TM_L2TE_CB_DQSCH_VOQ_THRSH_PROFILE_MEM_DATA 0xd0002e74
#define  SATURN_L2TM_L2TE_CB_DQSCH_VOQ_THRSH_PROFILE_MEM_DATA_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t hth                  : 15 ; /* bits 29:15 */
    ca_uint32_t rsrvd1               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_DQSCH_VOQ_THRSH_PROFILE_MEM_DATA_t;


#define  SATURN_L2TM_L2TE_CB_DQSCH_VOQ_THRSH_SELECT_MEM_ACCESS 0xd0002e78
#define  SATURN_L2TM_L2TE_CB_DQSCH_VOQ_THRSH_SELECT_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_DQSCH_VOQ_THRSH_SELECT_MEM_ACCESS_t;


#define  SATURN_L2TM_L2TE_CB_DQSCH_VOQ_THRSH_SELECT_MEM_DATA 0xd0002e7c
#define  SATURN_L2TM_L2TE_CB_DQSCH_VOQ_THRSH_SELECT_MEM_DATA_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sel                  :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_CB_DQSCH_VOQ_THRSH_SELECT_MEM_DATA_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2te_cb */
typedef struct {
  SATURN_L2TM_L2TE_CB_INT_t                       INT;                           /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_L2TM_L2TE_CB_INTE_t                      INTE;                          /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_L2TM_L2TE_CB_ERR_INFO_t                  ERR_INFO;                      /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_L2TM_L2TE_CB_CTRL_t                      CTRL;                          /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_L2TM_L2TE_CB_TM_DQSCH_HI_BUF_USG0_t      TM_DQSCH_HI_BUF_USG0;          /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[7];                    
  SATURN_L2TM_L2TE_CB_TM_DQSCH_MID_BUF_USG0_t     TM_DQSCH_MID_BUF_USG0;         /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd6[7];                    
  SATURN_L2TM_L2TE_CB_TM_TAILDROP_STS0_t          TM_TAILDROP_STS0;              /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd7[15];                   
  SATURN_L2TM_L2TE_CB_QM_TAILDROP_STS0_t          QM_TAILDROP_STS0;              /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd8[47];                   
  SATURN_L2TM_L2TE_CB_GLOB_TD_STS_t               GLOB_TD_STS;                   /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd9[3];                    
  SATURN_L2TM_L2TE_CB_PORT_TD_STS_t               PORT_TD_STS;                   /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd10[3];                   
  SATURN_L2TM_L2TE_CB_VOQ_TD_STS0_t               VOQ_TD_STS0;                   /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd11[15];                  
  SATURN_L2TM_L2TE_CB_SRC_PRI_TD_STS_t            SRC_PRI_TD_STS;                /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd12[3];                   
  SATURN_L2TM_L2TE_CB_PORT_THRSH_PROFILE0_t       PORT_THRSH_PROFILE0;           /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd13[3];                   
  SATURN_L2TM_L2TE_CB_PORT_GRPTHRSH_PROFILE0_t    PORT_GRPTHRSH_PROFILE0;        /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd14[27];                  
  SATURN_L2TM_L2TE_CB_PORT_THRSH_SELECT_t         PORT_THRSH_SELECT;             /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd15[3];                   
  SATURN_L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_ACCESS_t VOQ_THRSH_PROFILE_MEM_ACCESS;  /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd16[3];                   
  SATURN_L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_DATA1_t VOQ_THRSH_PROFILE_MEM_DATA1;   /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd17[3];                   
  SATURN_L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_DATA0_t VOQ_THRSH_PROFILE_MEM_DATA0;   /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd18[3];                   
  SATURN_L2TM_L2TE_CB_VOQ_THRSH_SELECT_MEM_ACCESS_t VOQ_THRSH_SELECT_MEM_ACCESS;   /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd19[3];                   
  SATURN_L2TM_L2TE_CB_VOQ_THRSH_SELECT_MEM_DATA_t VOQ_THRSH_SELECT_MEM_DATA;     /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd20[3];                   
  SATURN_L2TM_L2TE_CB_PORT_FREECNT_MEM_ACCESS_t   PORT_FREECNT_MEM_ACCESS;       /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd21[3];                   
  SATURN_L2TM_L2TE_CB_PORT_FREECNT_MEM_DATA_t     PORT_FREECNT_MEM_DATA;         /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd22[3];                   
  SATURN_L2TM_L2TE_CB_VOQ_BUFCNT_MEM_ACCESS_t     VOQ_BUFCNT_MEM_ACCESS;         /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd23[3];                   
  SATURN_L2TM_L2TE_CB_VOQ_BUFCNT_MEM_DATA_t       VOQ_BUFCNT_MEM_DATA;           /* addr: 0x000000c0 */
  ca_uint32_t                              rsrvd24[3];                   
  SATURN_L2TM_L2TE_CB_VOQ_MAX_BUFCNT_MEM_ACCESS_t VOQ_MAX_BUFCNT_MEM_ACCESS;     /* addr: 0x000000c4 */
  ca_uint32_t                              rsrvd25[3];                   
  SATURN_L2TM_L2TE_CB_VOQ_MAX_BUFCNT_MEM_DATA_t   VOQ_MAX_BUFCNT_MEM_DATA;       /* addr: 0x000000c8 */
  ca_uint32_t                              rsrvd26[3];                   
  SATURN_L2TM_L2TE_CB_GLB_THRSH_t                 GLB_THRSH;                     /* addr: 0x000000cc */
  ca_uint32_t                              rsrvd27[3];                   
  SATURN_L2TM_L2TE_CB_GLB_PRI_THRSH0_t            GLB_PRI_THRSH0;                /* addr: 0x000000d0 */
  ca_uint32_t                              rsrvd28[31];                  
  SATURN_L2TM_L2TE_CB_SRC_CTRL_t                  SRC_CTRL;                      /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd29[3];                   
  SATURN_L2TM_L2TE_CB_SRC_PORT_THRSH_PROFILE0_t   SRC_PORT_THRSH_PROFILE0;       /* addr: 0x000000f4 */
  ca_uint32_t                              rsrvd30[15];                  
  SATURN_L2TM_L2TE_CB_SRC_PORT_THRSH_SELECT_t     SRC_PORT_THRSH_SELECT;         /* addr: 0x00000104 */
  ca_uint32_t                              rsrvd31[3];                   
  SATURN_L2TM_L2TE_CB_SRC0_PRI_THRSH0_t           SRC0_PRI_THRSH0;               /* addr: 0x00000108 */
  ca_uint32_t                              rsrvd32[31];                  
  SATURN_L2TM_L2TE_CB_SRC1_PRI_THRSH0_t           SRC1_PRI_THRSH0;               /* addr: 0x00000128 */
  ca_uint32_t                              rsrvd33[31];                  
  SATURN_L2TM_L2TE_CB_SRC_PORT_BUFCNT_MEM_ACCESS_t SRC_PORT_BUFCNT_MEM_ACCESS;    /* addr: 0x00000148 */
  ca_uint32_t                              rsrvd34[3];                   
  SATURN_L2TM_L2TE_CB_SRC_PORT_BUFCNT_MEM_DATA_t  SRC_PORT_BUFCNT_MEM_DATA;      /* addr: 0x0000014c */
  ca_uint32_t                              rsrvd35[3];                   
  SATURN_L2TM_L2TE_CB_SRC_PRI_BUFCNT_MEM_ACCESS_t SRC_PRI_BUFCNT_MEM_ACCESS;     /* addr: 0x00000150 */
  ca_uint32_t                              rsrvd36[3];                   
  SATURN_L2TM_L2TE_CB_SRC_PRI_BUFCNT_MEM_DATA_t   SRC_PRI_BUFCNT_MEM_DATA;       /* addr: 0x00000154 */
  ca_uint32_t                              rsrvd37[3];                   
  SATURN_L2TM_L2TE_CB_DQSCH_EQ_PROFILE_THRSH0_t   DQSCH_EQ_PROFILE_THRSH0;       /* addr: 0x00000158 */
  ca_uint32_t                              rsrvd38[3];                   
  SATURN_L2TM_L2TE_CB_DQSCH_PORT_THRSH_PROFILE0_t DQSCH_PORT_THRSH_PROFILE0;     /* addr: 0x0000015c */
  ca_uint32_t                              rsrvd39[15];                  
  SATURN_L2TM_L2TE_CB_DQSCH_PORT_THRSH_SELECT_t   DQSCH_PORT_THRSH_SELECT;       /* addr: 0x0000016c */
  ca_uint32_t                              rsrvd40[3];                   
  SATURN_L2TM_L2TE_CB_DQSCH_VOQ_THRSH_PROFILE_MEM_ACCESS_t DQSCH_VOQ_THRSH_PROFILE_MEM_ACCESS; /* addr: 0x00000170 */
  ca_uint32_t                              rsrvd41[3];                   
  SATURN_L2TM_L2TE_CB_DQSCH_VOQ_THRSH_PROFILE_MEM_DATA_t DQSCH_VOQ_THRSH_PROFILE_MEM_DATA; /* addr: 0x00000174 */
  ca_uint32_t                              rsrvd42[3];                   
  SATURN_L2TM_L2TE_CB_DQSCH_VOQ_THRSH_SELECT_MEM_ACCESS_t DQSCH_VOQ_THRSH_SELECT_MEM_ACCESS; /* addr: 0x00000178 */
  ca_uint32_t                              rsrvd43[3];                   
  SATURN_L2TM_L2TE_CB_DQSCH_VOQ_THRSH_SELECT_MEM_DATA_t DQSCH_VOQ_THRSH_SELECT_MEM_DATA; /* addr: 0x0000017c */
} SATURN_APB0_L2TM_L2TE_CB_t;


/*
 * l2te_pm
 */
        
#define  SATURN_L2TM_L2TE_PM_CTRL                        0xd0002f00
#define  SATURN_L2TM_L2TE_PM_CTRL_dft                    0x00000ca0

typedef volatile union {
  struct {
    ca_uint32_t cnt_saturate         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t mem_saturate         :  1 ; /* bits 4:4 */
    ca_uint32_t mem_auto_clr_on_read :  1 ; /* bits 5:5 */
    ca_uint32_t mem_init             :  1 ; /* bits 6:6 */
    ca_uint32_t mem_disable          :  1 ; /* bits 7:7 */
    ca_uint32_t cnt0_mem_event_sel   :  1 ; /* bits 8:8 */
    ca_uint32_t cnt0_mem_id_sel      :  1 ; /* bits 9:9 */
    ca_uint32_t cnt1_mem_event_sel   :  1 ; /* bits 10:10 */
    ca_uint32_t cnt1_mem_id_sel      :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd2               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_PM_CTRL_t;


#define  SATURN_L2TM_L2TE_PM_EVENT_CFG_0                 0xd0002f04
#define  SATURN_L2TM_L2TE_PM_EVENT_CFG_0_dft             0x33445550

typedef volatile union {
  struct {
    ca_uint32_t cnt0_lo              :  4 ; /* bits 3:0 */
    ca_uint32_t cnt0_hi              :  4 ; /* bits 7:4 */
    ca_uint32_t cnt1_lo              :  4 ; /* bits 11:8 */
    ca_uint32_t cnt1_hi              :  4 ; /* bits 15:12 */
    ca_uint32_t cnt2_lo              :  4 ; /* bits 19:16 */
    ca_uint32_t cnt2_hi              :  4 ; /* bits 23:20 */
    ca_uint32_t cnt3_lo              :  4 ; /* bits 27:24 */
    ca_uint32_t cnt3_hi              :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_PM_EVENT_CFG_0_t;


#define  SATURN_L2TM_L2TE_PM_EVENT_CFG_1                 0xd0002f08
#define  SATURN_L2TM_L2TE_PM_EVENT_CFG_1_dft             0x33445550

typedef volatile union {
  struct {
    ca_uint32_t cnt0_lo              :  4 ; /* bits 3:0 */
    ca_uint32_t cnt0_hi              :  4 ; /* bits 7:4 */
    ca_uint32_t cnt1_lo              :  4 ; /* bits 11:8 */
    ca_uint32_t cnt1_hi              :  4 ; /* bits 15:12 */
    ca_uint32_t cnt2_lo              :  4 ; /* bits 19:16 */
    ca_uint32_t cnt2_hi              :  4 ; /* bits 23:20 */
    ca_uint32_t cnt3_lo              :  4 ; /* bits 27:24 */
    ca_uint32_t cnt3_hi              :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_PM_EVENT_CFG_1_t;


#define  SATURN_L2TM_L2TE_PM_STS                         0xd0002f0c
#define  SATURN_L2TM_L2TE_PM_STS_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pcnt0_init_done      :  1 ; /* bits 0:0 */
    ca_uint32_t pcnt1_init_done      :  1 ; /* bits 1:1 */
    ca_uint32_t bcnt0_init_done      :  1 ; /* bits 2:2 */
    ca_uint32_t bcnt1_init_done      :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_PM_STS_t;


#define  SATURN_L2TM_L2TE_PM_PCNT                        0xd0002f10
#define  SATURN_L2TM_L2TE_PM_PCNT_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_PM_PCNT_t;


#define  SATURN_L2TM_L2TE_PM_PRE_MARK_PCNT               0xd0002f14
#define  SATURN_L2TM_L2TE_PM_PRE_MARK_PCNT_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_PM_PRE_MARK_PCNT_t;


#define  SATURN_L2TM_L2TE_PM_POL_DROP_PCNT               0xd0002f18
#define  SATURN_L2TM_L2TE_PM_POL_DROP_PCNT_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_PM_POL_DROP_PCNT_t;


#define  SATURN_L2TM_L2TE_PM_TAIL_DROP_PCNT              0xd0002f1c
#define  SATURN_L2TM_L2TE_PM_TAIL_DROP_PCNT_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_PM_TAIL_DROP_PCNT_t;


#define  SATURN_L2TM_L2TE_PM_WRED_Y_DROP_PCNT            0xd0002f20
#define  SATURN_L2TM_L2TE_PM_WRED_Y_DROP_PCNT_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_PM_WRED_Y_DROP_PCNT_t;


#define  SATURN_L2TM_L2TE_PM_WRED_G_DROP_PCNT            0xd0002f24
#define  SATURN_L2TM_L2TE_PM_WRED_G_DROP_PCNT_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_PM_WRED_G_DROP_PCNT_t;


#define  SATURN_L2TM_L2TE_PM_MARK_PCNT                   0xd0002f28
#define  SATURN_L2TM_L2TE_PM_MARK_PCNT_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_PM_MARK_PCNT_t;


#define  SATURN_L2TM_L2TE_PM_POL_MARK_PCNT               0xd0002f2c
#define  SATURN_L2TM_L2TE_PM_POL_MARK_PCNT_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_PM_POL_MARK_PCNT_t;


#define  SATURN_L2TM_L2TE_PM_BYPASS_PCNT                 0xd0002f30
#define  SATURN_L2TM_L2TE_PM_BYPASS_PCNT_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_PM_BYPASS_PCNT_t;


#define  SATURN_L2TM_L2TE_PM_BYPASS_FLOW_PCNT            0xd0002f34
#define  SATURN_L2TM_L2TE_PM_BYPASS_FLOW_PCNT_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_PM_BYPASS_FLOW_PCNT_t;


#define  SATURN_L2TM_L2TE_PM_CE_PCNT                     0xd0002f38
#define  SATURN_L2TM_L2TE_PM_CE_PCNT_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_PM_CE_PCNT_t;


#define  SATURN_L2TM_L2TE_PM_CNT_MEM_ACCESS              0xd0002f3c
#define  SATURN_L2TM_L2TE_PM_CNT_MEM_ACCESS_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 20 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_PM_CNT_MEM_ACCESS_t;


#define  SATURN_L2TM_L2TE_PM_CNT_MEM_DATA8               0xd0002f40
#define  SATURN_L2TM_L2TE_PM_CNT_MEM_DATA8_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt7                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_PM_CNT_MEM_DATA8_t;


#define  SATURN_L2TM_L2TE_PM_CNT_MEM_DATA7               0xd0002f44
#define  SATURN_L2TM_L2TE_PM_CNT_MEM_DATA7_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt6                 : 12 ; /* bits 11:0 */
    ca_uint32_t cnt7                 : 20 ; /* bits 31:12 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_PM_CNT_MEM_DATA7_t;


#define  SATURN_L2TM_L2TE_PM_CNT_MEM_DATA6               0xd0002f48
#define  SATURN_L2TM_L2TE_PM_CNT_MEM_DATA6_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt5                 :  8 ; /* bits 7:0 */
    ca_uint32_t cnt6                 : 24 ; /* bits 31:8 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_PM_CNT_MEM_DATA6_t;


#define  SATURN_L2TM_L2TE_PM_CNT_MEM_DATA5               0xd0002f4c
#define  SATURN_L2TM_L2TE_PM_CNT_MEM_DATA5_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt4                 :  4 ; /* bits 3:0 */
    ca_uint32_t cnt5                 : 28 ; /* bits 31:4 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_PM_CNT_MEM_DATA5_t;


#define  SATURN_L2TM_L2TE_PM_CNT_MEM_DATA4               0xd0002f50
#define  SATURN_L2TM_L2TE_PM_CNT_MEM_DATA4_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt4                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_PM_CNT_MEM_DATA4_t;


#define  SATURN_L2TM_L2TE_PM_CNT_MEM_DATA3               0xd0002f54
#define  SATURN_L2TM_L2TE_PM_CNT_MEM_DATA3_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt3                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_PM_CNT_MEM_DATA3_t;


#define  SATURN_L2TM_L2TE_PM_CNT_MEM_DATA2               0xd0002f58
#define  SATURN_L2TM_L2TE_PM_CNT_MEM_DATA2_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt2                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_PM_CNT_MEM_DATA2_t;


#define  SATURN_L2TM_L2TE_PM_CNT_MEM_DATA1               0xd0002f5c
#define  SATURN_L2TM_L2TE_PM_CNT_MEM_DATA1_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_PM_CNT_MEM_DATA1_t;


#define  SATURN_L2TM_L2TE_PM_CNT_MEM_DATA0               0xd0002f60
#define  SATURN_L2TM_L2TE_PM_CNT_MEM_DATA0_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L2TM_L2TE_PM_CNT_MEM_DATA0_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2te_pm */
typedef struct {
  SATURN_L2TM_L2TE_PM_CTRL_t                      CTRL;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_L2TM_L2TE_PM_EVENT_CFG_0_t               EVENT_CFG_0;                   /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_L2TM_L2TE_PM_EVENT_CFG_1_t               EVENT_CFG_1;                   /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_L2TM_L2TE_PM_STS_t                       STS;                           /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_L2TM_L2TE_PM_PCNT_t                      PCNT;                          /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_L2TM_L2TE_PM_PRE_MARK_PCNT_t             PRE_MARK_PCNT;                 /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_L2TM_L2TE_PM_POL_DROP_PCNT_t             POL_DROP_PCNT;                 /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  SATURN_L2TM_L2TE_PM_TAIL_DROP_PCNT_t            TAIL_DROP_PCNT;                /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  SATURN_L2TM_L2TE_PM_WRED_Y_DROP_PCNT_t          WRED_Y_DROP_PCNT;              /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  SATURN_L2TM_L2TE_PM_WRED_G_DROP_PCNT_t          WRED_G_DROP_PCNT;              /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  SATURN_L2TM_L2TE_PM_MARK_PCNT_t                 MARK_PCNT;                     /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  SATURN_L2TM_L2TE_PM_POL_MARK_PCNT_t             POL_MARK_PCNT;                 /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  SATURN_L2TM_L2TE_PM_BYPASS_PCNT_t               BYPASS_PCNT;                   /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  SATURN_L2TM_L2TE_PM_BYPASS_FLOW_PCNT_t          BYPASS_FLOW_PCNT;              /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  SATURN_L2TM_L2TE_PM_CE_PCNT_t                   CE_PCNT;                       /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  SATURN_L2TM_L2TE_PM_CNT_MEM_ACCESS_t            CNT_MEM_ACCESS;                /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  SATURN_L2TM_L2TE_PM_CNT_MEM_DATA8_t             CNT_MEM_DATA8;                 /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  SATURN_L2TM_L2TE_PM_CNT_MEM_DATA7_t             CNT_MEM_DATA7;                 /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  SATURN_L2TM_L2TE_PM_CNT_MEM_DATA6_t             CNT_MEM_DATA6;                 /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  SATURN_L2TM_L2TE_PM_CNT_MEM_DATA5_t             CNT_MEM_DATA5;                 /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  SATURN_L2TM_L2TE_PM_CNT_MEM_DATA4_t             CNT_MEM_DATA4;                 /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  SATURN_L2TM_L2TE_PM_CNT_MEM_DATA3_t             CNT_MEM_DATA3;                 /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  SATURN_L2TM_L2TE_PM_CNT_MEM_DATA2_t             CNT_MEM_DATA2;                 /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  SATURN_L2TM_L2TE_PM_CNT_MEM_DATA1_t             CNT_MEM_DATA1;                 /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  SATURN_L2TM_L2TE_PM_CNT_MEM_DATA0_t             CNT_MEM_DATA0;                 /* addr: 0x00000060 */
} SATURN_APB0_L2TM_L2TE_PM_t;

    
  
        
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* L2TM */

typedef struct {
  SATURN_APB0_L2TM_L2TM_GLB_t                     l2tm_glb;                      /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[243];                  
  SATURN_APB0_L2TM_L2TM_BM_t                      l2tm_bm;                       /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd2[179];                  
  SATURN_APB0_L2TM_L2TM_QM_t                      l2tm_qm;                       /* addr: 0x00000200 */
  ca_uint32_t                              rsrvd3[169];                  
  SATURN_APB0_L2TM_L2TM_ES_t                      l2tm_es;                       /* addr: 0x00000300 */
  ca_uint32_t                              rsrvd4[133];                  
  SATURN_APB0_L2TM_L2TE_GLB_t                     l2te_glb;                      /* addr: 0x00000400 */
  ca_uint32_t                              rsrvd5[241];                  
  SATURN_APB0_L2TM_L2TE_POL_t                     l2te_pol;                      /* addr: 0x00000500 */
  ca_uint32_t                              rsrvd6[357];                  
  SATURN_APB0_L2TM_L2TE_SHP_t                     l2te_shp;                      /* addr: 0x00000700 */
  ca_uint32_t                              rsrvd7[223];                  
  SATURN_APB0_L2TM_L2TE_WRED_t                    l2te_wred;                     /* addr: 0x00000800 */
  ca_uint32_t                              rsrvd8[227];                  
  SATURN_APB0_L2TM_L2TE_FC_GLB_t                  l2te_fc_glb;                   /* addr: 0x00000900 */
  ca_uint32_t                              rsrvd9[111];                  
  SATURN_APB0_L2TM_L2TE_FC_t                      l2te_fc[14];                   /* addr: 0x00000980 */
  SATURN_APB0_L2TM_L2TE_CB_t                      l2te_cb;                       /* addr: 0x00000d00 */
  ca_uint32_t                              rsrvd10[321];                 
  SATURN_APB0_L2TM_L2TE_PM_t                      l2te_pm;                       /* addr: 0x00000f00 */
} SATURN_APB0_L2TM_t;


/*
 * L3FE
 */
  
/*
 * GLB
 */
        
#define  SATURN_L3FE_GLB_EGRESS_L3_IF_TBL_ACCESS         0xd0003000
#define  SATURN_L3FE_GLB_EGRESS_L3_IF_TBL_ACCESS_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_EGRESS_L3_IF_TBL_ACCESS_t;


#define  SATURN_L3FE_GLB_EGRESS_L3_IF_TBL_DATA2          0xd0003004
#define  SATURN_L3FE_GLB_EGRESS_L3_IF_TBL_DATA2_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t PPPOE_SESSION_ID     :  9 ; /* bits 8:0 */
    ca_uint32_t MAC_DA_VLD           :  1 ; /* bits 9:9 */
    ca_uint32_t MAC_DA_AN_SEL        :  4 ; /* bits 13:10 */
    ca_uint32_t MAC_SA_VLD           :  1 ; /* bits 14:14 */
    ca_uint32_t MAC_SA_AN_SEL        :  4 ; /* bits 18:15 */
    ca_uint32_t L2_FORMAT_VLD        :  1 ; /* bits 19:19 */
    ca_uint32_t L2_FORMAT            :  1 ; /* bits 20:20 */
    ca_uint32_t LDPID_VLD            :  1 ; /* bits 21:21 */
    ca_uint32_t LDPID                :  6 ; /* bits 27:22 */
    ca_uint32_t DEEP_Q               :  1 ; /* bits 28:28 */
    ca_uint32_t STAGE3_CTRL_VLD      :  1 ; /* bits 29:29 */
    ca_uint32_t STAGE3_CTRL          :  1 ; /* bits 30:30 */
    ca_uint32_t rsrvd1               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_EGRESS_L3_IF_TBL_DATA2_t;


#define  SATURN_L3FE_GLB_EGRESS_L3_IF_TBL_DATA1          0xd0003008
#define  SATURN_L3FE_GLB_EGRESS_L3_IF_TBL_DATA1_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t INNER_TPID_ENC       :  3 ; /* bits 2:0 */
    ca_uint32_t TOP_DEI_SEL          :  2 ; /* bits 4:3 */
    ca_uint32_t TOP_DEI              :  1 ; /* bits 5:5 */
    ca_uint32_t TOP_VID              : 12 ; /* bits 17:6 */
    ca_uint32_t TOP_TPID_ENC         :  3 ; /* bits 20:18 */
    ca_uint32_t VLAN_CNT             :  2 ; /* bits 22:21 */
    ca_uint32_t PPPOE_SET            :  1 ; /* bits 23:23 */
    ca_uint32_t PPPOE_VLD            :  1 ; /* bits 24:24 */
    ca_uint32_t PPPOE_SESSION_ID     :  7 ; /* bits 31:25 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_EGRESS_L3_IF_TBL_DATA1_t;


#define  SATURN_L3FE_GLB_EGRESS_L3_IF_TBL_DATA0          0xd000300c
#define  SATURN_L3FE_GLB_EGRESS_L3_IF_TBL_DATA0_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t MTU_VLD              :  1 ; /* bits 0:0 */
    ca_uint32_t MTU_ENC              :  2 ; /* bits 2:1 */
    ca_uint32_t INNER_802_1P_SEL     :  3 ; /* bits 5:3 */
    ca_uint32_t INNER_802_1P         :  3 ; /* bits 8:6 */
    ca_uint32_t TOP_802_1P_SEL       :  3 ; /* bits 11:9 */
    ca_uint32_t TOP_802_1P           :  3 ; /* bits 14:12 */
    ca_uint32_t QOS_802_1P_TABLE_SEL :  1 ; /* bits 15:15 */
    ca_uint32_t VLAN_VLD             :  1 ; /* bits 16:16 */
    ca_uint32_t INNER_DEI_SEL        :  2 ; /* bits 18:17 */
    ca_uint32_t INNER_DEI            :  1 ; /* bits 19:19 */
    ca_uint32_t INNER_VID            : 12 ; /* bits 31:20 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_EGRESS_L3_IF_TBL_DATA0_t;


#define  SATURN_L3FE_GLB_DSCP_MAP_TBL_ACCESS             0xd0003010
#define  SATURN_L3FE_GLB_DSCP_MAP_TBL_ACCESS_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_DSCP_MAP_TBL_ACCESS_t;


#define  SATURN_L3FE_GLB_DSCP_MAP_TBL_DATA1              0xd0003014
#define  SATURN_L3FE_GLB_DSCP_MAP_TBL_DATA1_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dscp_2_pf1_dscp      :  2 ; /* bits 1:0 */
    ca_uint32_t dscp_2_pf1_cos       :  4 ; /* bits 5:2 */
    ca_uint32_t dscp_2_pf1_pol_id    :  9 ; /* bits 14:6 */
    ca_uint32_t dscp_2_pf1_pol_grp_id :  3 ; /* bits 17:15 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_DSCP_MAP_TBL_DATA1_t;


#define  SATURN_L3FE_GLB_DSCP_MAP_TBL_DATA0              0xd0003018
#define  SATURN_L3FE_GLB_DSCP_MAP_TBL_DATA0_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dscp_2_pf0_dot1p     :  3 ; /* bits 2:0 */
    ca_uint32_t dscp_2_pf0_dscp      :  6 ; /* bits 8:3 */
    ca_uint32_t dscp_2_pf0_cos       :  4 ; /* bits 12:9 */
    ca_uint32_t dscp_2_pf0_pol_id    :  9 ; /* bits 21:13 */
    ca_uint32_t dscp_2_pf0_pol_grp_id :  3 ; /* bits 24:22 */
    ca_uint32_t dscp_2_pf1_dot1p     :  3 ; /* bits 27:25 */
    ca_uint32_t dscp_2_pf1_dscp      :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_DSCP_MAP_TBL_DATA0_t;


#define  SATURN_L3FE_GLB_DOT1P_MAPPING_0_0               0xd000301c
#define  SATURN_L3FE_GLB_DOT1P_MAPPING_0_0_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_DOT1P_MAPPING_0_0_t;


#define  SATURN_L3FE_GLB_DOT1P_MAPPING_1_0               0xd0003020
#define  SATURN_L3FE_GLB_DOT1P_MAPPING_1_0_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_DOT1P_MAPPING_1_0_t;


#define  SATURN_L3FE_GLB_DOT1P_MAPPING_0_1               0xd0003024
#define  SATURN_L3FE_GLB_DOT1P_MAPPING_0_1_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_DOT1P_MAPPING_0_1_t;


#define  SATURN_L3FE_GLB_DOT1P_MAPPING_1_1               0xd0003028
#define  SATURN_L3FE_GLB_DOT1P_MAPPING_1_1_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_DOT1P_MAPPING_1_1_t;


#define  SATURN_L3FE_GLB_DOT1P_MAPPING_0_2               0xd000302c
#define  SATURN_L3FE_GLB_DOT1P_MAPPING_0_2_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_DOT1P_MAPPING_0_2_t;


#define  SATURN_L3FE_GLB_DOT1P_MAPPING_1_2               0xd0003030
#define  SATURN_L3FE_GLB_DOT1P_MAPPING_1_2_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_DOT1P_MAPPING_1_2_t;


#define  SATURN_L3FE_GLB_DOT1P_MAPPING_0_3               0xd0003034
#define  SATURN_L3FE_GLB_DOT1P_MAPPING_0_3_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_DOT1P_MAPPING_0_3_t;


#define  SATURN_L3FE_GLB_DOT1P_MAPPING_1_3               0xd0003038
#define  SATURN_L3FE_GLB_DOT1P_MAPPING_1_3_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_DOT1P_MAPPING_1_3_t;


#define  SATURN_L3FE_GLB_DOT1P_MAPPING_0_4               0xd000303c
#define  SATURN_L3FE_GLB_DOT1P_MAPPING_0_4_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_DOT1P_MAPPING_0_4_t;


#define  SATURN_L3FE_GLB_DOT1P_MAPPING_1_4               0xd0003040
#define  SATURN_L3FE_GLB_DOT1P_MAPPING_1_4_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_DOT1P_MAPPING_1_4_t;


#define  SATURN_L3FE_GLB_DOT1P_MAPPING_0_5               0xd0003044
#define  SATURN_L3FE_GLB_DOT1P_MAPPING_0_5_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_DOT1P_MAPPING_0_5_t;


#define  SATURN_L3FE_GLB_DOT1P_MAPPING_1_5               0xd0003048
#define  SATURN_L3FE_GLB_DOT1P_MAPPING_1_5_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_DOT1P_MAPPING_1_5_t;


#define  SATURN_L3FE_GLB_DOT1P_MAPPING_0_6               0xd000304c
#define  SATURN_L3FE_GLB_DOT1P_MAPPING_0_6_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_DOT1P_MAPPING_0_6_t;


#define  SATURN_L3FE_GLB_DOT1P_MAPPING_1_6               0xd0003050
#define  SATURN_L3FE_GLB_DOT1P_MAPPING_1_6_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_DOT1P_MAPPING_1_6_t;


#define  SATURN_L3FE_GLB_DOT1P_MAPPING_0_7               0xd0003054
#define  SATURN_L3FE_GLB_DOT1P_MAPPING_0_7_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_DOT1P_MAPPING_0_7_t;


#define  SATURN_L3FE_GLB_DOT1P_MAPPING_1_7               0xd0003058
#define  SATURN_L3FE_GLB_DOT1P_MAPPING_1_7_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_DOT1P_MAPPING_1_7_t;


#define  SATURN_L3FE_GLB_COS_MAPPING_0_0                 0xd000305c
#define  SATURN_L3FE_GLB_COS_MAPPING_0_0_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_COS_MAPPING_0_0_t;


#define  SATURN_L3FE_GLB_COS_MAPPING_1_0                 0xd0003060
#define  SATURN_L3FE_GLB_COS_MAPPING_1_0_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_COS_MAPPING_1_0_t;


#define  SATURN_L3FE_GLB_COS_MAPPING_0_1                 0xd0003064
#define  SATURN_L3FE_GLB_COS_MAPPING_0_1_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_COS_MAPPING_0_1_t;


#define  SATURN_L3FE_GLB_COS_MAPPING_1_1                 0xd0003068
#define  SATURN_L3FE_GLB_COS_MAPPING_1_1_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_COS_MAPPING_1_1_t;


#define  SATURN_L3FE_GLB_COS_MAPPING_0_2                 0xd000306c
#define  SATURN_L3FE_GLB_COS_MAPPING_0_2_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_COS_MAPPING_0_2_t;


#define  SATURN_L3FE_GLB_COS_MAPPING_1_2                 0xd0003070
#define  SATURN_L3FE_GLB_COS_MAPPING_1_2_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_COS_MAPPING_1_2_t;


#define  SATURN_L3FE_GLB_COS_MAPPING_0_3                 0xd0003074
#define  SATURN_L3FE_GLB_COS_MAPPING_0_3_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_COS_MAPPING_0_3_t;


#define  SATURN_L3FE_GLB_COS_MAPPING_1_3                 0xd0003078
#define  SATURN_L3FE_GLB_COS_MAPPING_1_3_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_COS_MAPPING_1_3_t;


#define  SATURN_L3FE_GLB_COS_MAPPING_0_4                 0xd000307c
#define  SATURN_L3FE_GLB_COS_MAPPING_0_4_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_COS_MAPPING_0_4_t;


#define  SATURN_L3FE_GLB_COS_MAPPING_1_4                 0xd0003080
#define  SATURN_L3FE_GLB_COS_MAPPING_1_4_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_COS_MAPPING_1_4_t;


#define  SATURN_L3FE_GLB_COS_MAPPING_0_5                 0xd0003084
#define  SATURN_L3FE_GLB_COS_MAPPING_0_5_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_COS_MAPPING_0_5_t;


#define  SATURN_L3FE_GLB_COS_MAPPING_1_5                 0xd0003088
#define  SATURN_L3FE_GLB_COS_MAPPING_1_5_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_COS_MAPPING_1_5_t;


#define  SATURN_L3FE_GLB_COS_MAPPING_0_6                 0xd000308c
#define  SATURN_L3FE_GLB_COS_MAPPING_0_6_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_COS_MAPPING_0_6_t;


#define  SATURN_L3FE_GLB_COS_MAPPING_1_6                 0xd0003090
#define  SATURN_L3FE_GLB_COS_MAPPING_1_6_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_COS_MAPPING_1_6_t;


#define  SATURN_L3FE_GLB_COS_MAPPING_0_7                 0xd0003094
#define  SATURN_L3FE_GLB_COS_MAPPING_0_7_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_COS_MAPPING_0_7_t;


#define  SATURN_L3FE_GLB_COS_MAPPING_1_7                 0xd0003098
#define  SATURN_L3FE_GLB_COS_MAPPING_1_7_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_COS_MAPPING_1_7_t;


#define  SATURN_L3FE_GLB_FWD_CTRL_0                      0xd000309c
#define  SATURN_L3FE_GLB_FWD_CTRL_0_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t change_to_llc        :  1 ; /* bits 0:0 */
    ca_uint32_t ipv4_change_ipv6     :  1 ; /* bits 1:1 */
    ca_uint32_t llc_raw8023_change   :  1 ; /* bits 2:2 */
    ca_uint32_t nonip_change_ip      :  1 ; /* bits 3:3 */
    ca_uint32_t nonip_add_pppoe      :  1 ; /* bits 4:4 */
    ca_uint32_t nonl4_change_l4      :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_FWD_CTRL_0_t;


#define  SATURN_L3FE_GLB_FWD_CTRL_1                      0xd00030a0
#define  SATURN_L3FE_GLB_FWD_CTRL_1_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t change_to_llc        :  1 ; /* bits 0:0 */
    ca_uint32_t ipv4_change_ipv6     :  1 ; /* bits 1:1 */
    ca_uint32_t llc_raw8023_change   :  1 ; /* bits 2:2 */
    ca_uint32_t nonip_change_ip      :  1 ; /* bits 3:3 */
    ca_uint32_t nonip_add_pppoe      :  1 ; /* bits 4:4 */
    ca_uint32_t nonl4_change_l4      :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_FWD_CTRL_1_t;


#define  SATURN_L3FE_GLB_FWD_CTRL_2                      0xd00030a4
#define  SATURN_L3FE_GLB_FWD_CTRL_2_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t change_to_llc        :  1 ; /* bits 0:0 */
    ca_uint32_t ipv4_change_ipv6     :  1 ; /* bits 1:1 */
    ca_uint32_t llc_raw8023_change   :  1 ; /* bits 2:2 */
    ca_uint32_t nonip_change_ip      :  1 ; /* bits 3:3 */
    ca_uint32_t nonip_add_pppoe      :  1 ; /* bits 4:4 */
    ca_uint32_t nonl4_change_l4      :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_FWD_CTRL_2_t;


#define  SATURN_L3FE_GLB_FWD_CTRL_3                      0xd00030a8
#define  SATURN_L3FE_GLB_FWD_CTRL_3_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t change_to_llc        :  1 ; /* bits 0:0 */
    ca_uint32_t ipv4_change_ipv6     :  1 ; /* bits 1:1 */
    ca_uint32_t llc_raw8023_change   :  1 ; /* bits 2:2 */
    ca_uint32_t nonip_change_ip      :  1 ; /* bits 3:3 */
    ca_uint32_t nonip_add_pppoe      :  1 ; /* bits 4:4 */
    ca_uint32_t nonl4_change_l4      :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_FWD_CTRL_3_t;


#define  SATURN_L3FE_GLB_GLB_CFG                         0xd00030ac
#define  SATURN_L3FE_GLB_GLB_CFG_dft                     0x0001b000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  6 ;
    ca_uint32_t spcl_port            :  6 ; /* bits 11:6 */
    ca_uint32_t mc_port              :  6 ; /* bits 17:12 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t ni_fe_12_bv          :  1 ; /* bits 21:21 */
    ca_uint32_t pl_mode              :  2 ; /* bits 23:22 */
    ca_uint32_t rsrvd3               :  7 ;
    ca_uint32_t l3fe_pon_mode        :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_GLB_CFG_t;


#define  SATURN_L3FE_GLB_LF_CFG                          0xd00030b0
#define  SATURN_L3FE_GLB_LF_CFG_dft                      0x004641f4

typedef volatile union {
  struct {
    ca_uint32_t hi_threshold         : 10 ; /* bits 9:0 */
    ca_uint32_t low_threshold        : 10 ; /* bits 19:10 */
    ca_uint32_t wr_fifo_threshold    :  4 ; /* bits 23:20 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_LF_CFG_t;


#define  SATURN_L3FE_GLB_ILPB_01                         0xd00030b4
#define  SATURN_L3FE_GLB_ILPB_01_STRIDE                  8
#define  SATURN_L3FE_GLB_ILPB_01_COUNT                   4
#define  SATURN_L3FE_GLB_ILPB_01_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t entry1               : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_ILPB_01_t;


#define  SATURN_L3FE_GLB_ILPB_00                         0xd00030b8
#define  SATURN_L3FE_GLB_ILPB_00_STRIDE                  8
#define  SATURN_L3FE_GLB_ILPB_00_COUNT                   4
#define  SATURN_L3FE_GLB_ILPB_00_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t entry0               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_ILPB_00_t;

                        
#define  SATURN_L3FE_GLB_ILPB_LDPID                      0xd00030d4
#define  SATURN_L3FE_GLB_ILPB_LDPID_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t valid0               :  1 ; /* bits 0:0 */
    ca_uint32_t ldpid0               :  6 ; /* bits 6:1 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t valid1               :  1 ; /* bits 8:8 */
    ca_uint32_t ldpid1               :  6 ; /* bits 14:9 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t valid2               :  1 ; /* bits 16:16 */
    ca_uint32_t ldpid2               :  6 ; /* bits 22:17 */
    ca_uint32_t valid3               :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd3               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_ILPB_LDPID_t;


#define  SATURN_L3FE_GLB_ELPB1                           0xd00030d8
#define  SATURN_L3FE_GLB_ELPB1_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t entry1               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_ELPB1_t;


#define  SATURN_L3FE_GLB_ELPB0                           0xd00030dc
#define  SATURN_L3FE_GLB_ELPB0_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t entry0               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_ELPB0_t;


#define  SATURN_L3FE_GLB_ELPB_DEEPQ_VLD1                 0xd00030e0
#define  SATURN_L3FE_GLB_ELPB_DEEPQ_VLD1_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ldpid1               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_ELPB_DEEPQ_VLD1_t;


#define  SATURN_L3FE_GLB_ELPB_DEEPQ_VLD0                 0xd00030e4
#define  SATURN_L3FE_GLB_ELPB_DEEPQ_VLD0_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ldpid0               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_ELPB_DEEPQ_VLD0_t;


#define  SATURN_L3FE_GLB_ELPB_DEEPQ1                     0xd00030e8
#define  SATURN_L3FE_GLB_ELPB_DEEPQ1_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ldpid1               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_ELPB_DEEPQ1_t;


#define  SATURN_L3FE_GLB_ELPB_DEEPQ0                     0xd00030ec
#define  SATURN_L3FE_GLB_ELPB_DEEPQ0_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ldpid0               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_ELPB_DEEPQ0_t;


#define  SATURN_L3FE_GLB_L3FE_L2FE_LDPID                 0xd00030f0
#define  SATURN_L3FE_GLB_L3FE_L2FE_LDPID_dft             0x00000019

typedef volatile union {
  struct {
    ca_uint32_t ldpid                :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_L3FE_L2FE_LDPID_t;


#define  SATURN_L3FE_GLB_VE                              0xd00030f4
#define  SATURN_L3FE_GLB_VE_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t stag_tpid_enc        :  3 ; /* bits 2:0 */
    ca_uint32_t ctag_tpid_enc        :  3 ; /* bits 5:3 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_VE_t;


#define  SATURN_L3FE_GLB_T5_OPTION                       0xd00030f8
#define  SATURN_L3FE_GLB_T5_OPTION_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bits                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_T5_OPTION_t;


#define  SATURN_L3FE_GLB_TE_OPTION                       0xd00030fc
#define  SATURN_L3FE_GLB_TE_OPTION_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bits                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_TE_OPTION_t;


#define  SATURN_L3FE_GLB_CLS_STG_MONITOR_CTRL            0xd0003100
#define  SATURN_L3FE_GLB_CLS_STG_MONITOR_CTRL_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bus_sel              :  8 ; /* bits 7:0 */
    ca_uint32_t enable               :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_CLS_STG_MONITOR_CTRL_t;


#define  SATURN_L3FE_GLB_CLS_STG_MONITOR_RETURN          0xd0003104
#define  SATURN_L3FE_GLB_CLS_STG_MONITOR_RETURN_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_CLS_STG_MONITOR_RETURN_t;


#define  SATURN_L3FE_GLB_DBG_IDX                         0xd0003108
#define  SATURN_L3FE_GLB_DBG_IDX_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t idx                  : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_DBG_IDX_t;


#define  SATURN_L3FE_GLB_DBG_DAT                         0xd000310c
#define  SATURN_L3FE_GLB_DBG_DAT_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dat                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_GLB_DBG_DAT_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* GLB */
typedef struct {
  SATURN_L3FE_GLB_EGRESS_L3_IF_TBL_ACCESS_t       EGRESS_L3_IF_TBL_ACCESS;       /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_L3FE_GLB_EGRESS_L3_IF_TBL_DATA2_t        EGRESS_L3_IF_TBL_DATA2;        /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_L3FE_GLB_EGRESS_L3_IF_TBL_DATA1_t        EGRESS_L3_IF_TBL_DATA1;        /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_L3FE_GLB_EGRESS_L3_IF_TBL_DATA0_t        EGRESS_L3_IF_TBL_DATA0;        /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_L3FE_GLB_DSCP_MAP_TBL_ACCESS_t           DSCP_MAP_TBL_ACCESS;           /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_L3FE_GLB_DSCP_MAP_TBL_DATA1_t            DSCP_MAP_TBL_DATA1;            /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_L3FE_GLB_DSCP_MAP_TBL_DATA0_t            DSCP_MAP_TBL_DATA0;            /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  SATURN_L3FE_GLB_DOT1P_MAPPING_0_0_t             DOT1P_MAPPING_0_0;             /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  SATURN_L3FE_GLB_DOT1P_MAPPING_1_0_t             DOT1P_MAPPING_1_0;             /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  SATURN_L3FE_GLB_DOT1P_MAPPING_0_1_t             DOT1P_MAPPING_0_1;             /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  SATURN_L3FE_GLB_DOT1P_MAPPING_1_1_t             DOT1P_MAPPING_1_1;             /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  SATURN_L3FE_GLB_DOT1P_MAPPING_0_2_t             DOT1P_MAPPING_0_2;             /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  SATURN_L3FE_GLB_DOT1P_MAPPING_1_2_t             DOT1P_MAPPING_1_2;             /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  SATURN_L3FE_GLB_DOT1P_MAPPING_0_3_t             DOT1P_MAPPING_0_3;             /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  SATURN_L3FE_GLB_DOT1P_MAPPING_1_3_t             DOT1P_MAPPING_1_3;             /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  SATURN_L3FE_GLB_DOT1P_MAPPING_0_4_t             DOT1P_MAPPING_0_4;             /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  SATURN_L3FE_GLB_DOT1P_MAPPING_1_4_t             DOT1P_MAPPING_1_4;             /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  SATURN_L3FE_GLB_DOT1P_MAPPING_0_5_t             DOT1P_MAPPING_0_5;             /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  SATURN_L3FE_GLB_DOT1P_MAPPING_1_5_t             DOT1P_MAPPING_1_5;             /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  SATURN_L3FE_GLB_DOT1P_MAPPING_0_6_t             DOT1P_MAPPING_0_6;             /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  SATURN_L3FE_GLB_DOT1P_MAPPING_1_6_t             DOT1P_MAPPING_1_6;             /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  SATURN_L3FE_GLB_DOT1P_MAPPING_0_7_t             DOT1P_MAPPING_0_7;             /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  SATURN_L3FE_GLB_DOT1P_MAPPING_1_7_t             DOT1P_MAPPING_1_7;             /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  SATURN_L3FE_GLB_COS_MAPPING_0_0_t               COS_MAPPING_0_0;               /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  SATURN_L3FE_GLB_COS_MAPPING_1_0_t               COS_MAPPING_1_0;               /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  SATURN_L3FE_GLB_COS_MAPPING_0_1_t               COS_MAPPING_0_1;               /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  SATURN_L3FE_GLB_COS_MAPPING_1_1_t               COS_MAPPING_1_1;               /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  SATURN_L3FE_GLB_COS_MAPPING_0_2_t               COS_MAPPING_0_2;               /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  SATURN_L3FE_GLB_COS_MAPPING_1_2_t               COS_MAPPING_1_2;               /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  SATURN_L3FE_GLB_COS_MAPPING_0_3_t               COS_MAPPING_0_3;               /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  SATURN_L3FE_GLB_COS_MAPPING_1_3_t               COS_MAPPING_1_3;               /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  SATURN_L3FE_GLB_COS_MAPPING_0_4_t               COS_MAPPING_0_4;               /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  SATURN_L3FE_GLB_COS_MAPPING_1_4_t               COS_MAPPING_1_4;               /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  SATURN_L3FE_GLB_COS_MAPPING_0_5_t               COS_MAPPING_0_5;               /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  SATURN_L3FE_GLB_COS_MAPPING_1_5_t               COS_MAPPING_1_5;               /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  SATURN_L3FE_GLB_COS_MAPPING_0_6_t               COS_MAPPING_0_6;               /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  SATURN_L3FE_GLB_COS_MAPPING_1_6_t               COS_MAPPING_1_6;               /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  SATURN_L3FE_GLB_COS_MAPPING_0_7_t               COS_MAPPING_0_7;               /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  SATURN_L3FE_GLB_COS_MAPPING_1_7_t               COS_MAPPING_1_7;               /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];                   
  SATURN_L3FE_GLB_FWD_CTRL_0_t                    FWD_CTRL_0;                    /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];                   
  SATURN_L3FE_GLB_FWD_CTRL_1_t                    FWD_CTRL_1;                    /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];                   
  SATURN_L3FE_GLB_FWD_CTRL_2_t                    FWD_CTRL_2;                    /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];                   
  SATURN_L3FE_GLB_FWD_CTRL_3_t                    FWD_CTRL_3;                    /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];                   
  SATURN_L3FE_GLB_GLB_CFG_t                       GLB_CFG;                       /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd44[3];                   
  SATURN_L3FE_GLB_LF_CFG_t                        LF_CFG;                        /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd45[3];                   
  SATURN_L3FE_GLB_ILPB_01_t                       ILPB_01;                       /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd46[3];                   
  SATURN_L3FE_GLB_ILPB_00_t                       ILPB_00;                       /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd47[27];                  
  SATURN_L3FE_GLB_ILPB_LDPID_t                    ILPB_LDPID;                    /* addr: 0x000000d4 */
  ca_uint32_t                              rsrvd48[3];                   
  SATURN_L3FE_GLB_ELPB1_t                         ELPB1;                         /* addr: 0x000000d8 */
  ca_uint32_t                              rsrvd49[3];                   
  SATURN_L3FE_GLB_ELPB0_t                         ELPB0;                         /* addr: 0x000000dc */
  ca_uint32_t                              rsrvd50[3];                   
  SATURN_L3FE_GLB_ELPB_DEEPQ_VLD1_t               ELPB_DEEPQ_VLD1;               /* addr: 0x000000e0 */
  ca_uint32_t                              rsrvd51[3];                   
  SATURN_L3FE_GLB_ELPB_DEEPQ_VLD0_t               ELPB_DEEPQ_VLD0;               /* addr: 0x000000e4 */
  ca_uint32_t                              rsrvd52[3];                   
  SATURN_L3FE_GLB_ELPB_DEEPQ1_t                   ELPB_DEEPQ1;                   /* addr: 0x000000e8 */
  ca_uint32_t                              rsrvd53[3];                   
  SATURN_L3FE_GLB_ELPB_DEEPQ0_t                   ELPB_DEEPQ0;                   /* addr: 0x000000ec */
  ca_uint32_t                              rsrvd54[3];                   
  SATURN_L3FE_GLB_L3FE_L2FE_LDPID_t               L3FE_L2FE_LDPID;               /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd55[3];                   
  SATURN_L3FE_GLB_VE_t                            VE;                            /* addr: 0x000000f4 */
  ca_uint32_t                              rsrvd56[3];                   
  SATURN_L3FE_GLB_T5_OPTION_t                     T5_OPTION;                     /* addr: 0x000000f8 */
  ca_uint32_t                              rsrvd57[3];                   
  SATURN_L3FE_GLB_TE_OPTION_t                     TE_OPTION;                     /* addr: 0x000000fc */
  ca_uint32_t                              rsrvd58[3];                   
  SATURN_L3FE_GLB_CLS_STG_MONITOR_CTRL_t          CLS_STG_MONITOR_CTRL;          /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd59[3];                   
  SATURN_L3FE_GLB_CLS_STG_MONITOR_RETURN_t        CLS_STG_MONITOR_RETURN;        /* addr: 0x00000104 */
  ca_uint32_t                              rsrvd60[3];                   
  SATURN_L3FE_GLB_DBG_IDX_t                       DBG_IDX;                       /* addr: 0x00000108 */
  ca_uint32_t                              rsrvd61[3];                   
  SATURN_L3FE_GLB_DBG_DAT_t                       DBG_DAT;                       /* addr: 0x0000010c */
} SATURN_APB0_L3FE_GLB_t;


/*
 * PP
 */
        
#define  SATURN_L3FE_PP_FIELD_CAM_ACCESS                 0xd0003200
#define  SATURN_L3FE_PP_FIELD_CAM_ACCESS_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 : 20 ; /* bits 19:0 */
    ca_uint32_t rsrvd1               : 10 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_FIELD_CAM_ACCESS_t;


#define  SATURN_L3FE_PP_FIELD_CAM_DATA4                  0xd0003204
#define  SATURN_L3FE_PP_FIELD_CAM_DATA4_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_FIELD_CAM_DATA4_t;


#define  SATURN_L3FE_PP_FIELD_CAM_DATA3                  0xd0003208
#define  SATURN_L3FE_PP_FIELD_CAM_DATA3_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_FIELD_CAM_DATA3_t;


#define  SATURN_L3FE_PP_FIELD_CAM_DATA2                  0xd000320c
#define  SATURN_L3FE_PP_FIELD_CAM_DATA2_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_FIELD_CAM_DATA2_t;


#define  SATURN_L3FE_PP_FIELD_CAM_DATA1                  0xd0003210
#define  SATURN_L3FE_PP_FIELD_CAM_DATA1_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_FIELD_CAM_DATA1_t;


#define  SATURN_L3FE_PP_FIELD_CAM_DATA0                  0xd0003214
#define  SATURN_L3FE_PP_FIELD_CAM_DATA0_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_FIELD_CAM_DATA0_t;


#define  SATURN_L3FE_PP_SPCL_PKT_DETECTION_CFG           0xd0003218
#define  SATURN_L3FE_PP_SPCL_PKT_DETECTION_CFG_dft       0x0739dc24

typedef volatile union {
  struct {
    ca_uint32_t check_arp_target_ip  :  1 ; /* bits 0:0 */
    ca_uint32_t mpcp_opcode_en       :  1 ; /* bits 1:1 */
    ca_uint32_t my_mac_enable        :  1 ; /* bits 2:2 */
    ca_uint32_t type_0_en            :  1 ; /* bits 3:3 */
    ca_uint32_t type_1_en            :  1 ; /* bits 4:4 */
    ca_uint32_t udp_lite_enable      :  1 ; /* bits 5:5 */
    ca_uint32_t user_def_spcl_0_en   :  1 ; /* bits 6:6 */
    ca_uint32_t user_def_spcl_1_en   :  1 ; /* bits 7:7 */
    ca_uint32_t user_def_spcl_2_en   :  1 ; /* bits 8:8 */
    ca_uint32_t user_def_spcl_3_en   :  1 ; /* bits 9:9 */
    ca_uint32_t l2_spcl_hdr_en       :  1 ; /* bits 10:10 */
    ca_uint32_t l3_spcl_hdr_en       :  1 ; /* bits 11:11 */
    ca_uint32_t l4_spcl_hdr_en       :  1 ; /* bits 12:12 */
    ca_uint32_t user_define_hi_pri   :  1 ; /* bits 13:13 */
    ca_uint32_t rdp_v1_detection_en  :  1 ; /* bits 14:14 */
    ca_uint32_t ipv4_chksum_chk_enable :  1 ; /* bits 15:15 */
    ca_uint32_t l4_chksum_chk_enable :  1 ; /* bits 16:16 */
    ca_uint32_t l4_chksum_rh_chk_enable :  1 ; /* bits 17:17 */
    ca_uint32_t chksum_err_drop      :  6 ; /* bits 23:18 */
    ca_uint32_t bpdu_mac_08_en       :  1 ; /* bits 24:24 */
    ca_uint32_t subtype_en           :  1 ; /* bits 25:25 */
    ca_uint32_t rdp_l4_msgs_det_en   :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t drop_udp_ov_ip6_cs_zero_en :  1 ; /* bits 28:28 */
    ca_uint32_t ni2fe_pkt_cnt_wrap_en :  1 ; /* bits 29:29 */
    ca_uint32_t use_mdata_high_6bits_as_spcl_enc :  1 ; /* bits 30:30 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_SPCL_PKT_DETECTION_CFG_t;


#define  SATURN_L3FE_PP_IPNIP_SPCL_PKT_DET_EN            0xd000321c
#define  SATURN_L3FE_PP_IPNIP_SPCL_PKT_DET_EN_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dhcpv4               :  1 ; /* bits 0:0 */
    ca_uint32_t dhcpv6               :  1 ; /* bits 1:1 */
    ca_uint32_t l4ptp                :  1 ; /* bits 2:2 */
    ca_uint32_t dns                  :  1 ; /* bits 3:3 */
    ca_uint32_t rip                  :  1 ; /* bits 4:4 */
    ca_uint32_t ssdp                 :  1 ; /* bits 5:5 */
    ca_uint32_t l4_msgs              :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_IPNIP_SPCL_PKT_DET_EN_t;


#define  SATURN_L3FE_PP_OFFSET_HDR                       0xd0003220
#define  SATURN_L3FE_PP_OFFSET_HDR_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t offset               :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_OFFSET_HDR_t;


#define  SATURN_L3FE_PP_PARSING_LMT                      0xd0003224
#define  SATURN_L3FE_PP_PARSING_LMT_dft                  0x00000014

typedef volatile union {
  struct {
    ca_uint32_t offset               :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_PARSING_LMT_t;


#define  SATURN_L3FE_PP_PARSING_STTS_0                   0xd0003228
#define  SATURN_L3FE_PP_PARSING_STTS_0_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t parsing_err          :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_PARSING_STTS_0_t;


#define  SATURN_L3FE_PP_PARSING_STTS_1                   0xd000322c
#define  SATURN_L3FE_PP_PARSING_STTS_1_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t parsing_err          : 20 ; /* bits 19:0 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_PARSING_STTS_1_t;


#define  SATURN_L3FE_PP_PARSING_ERR_FWD_0                0xd0003230
#define  SATURN_L3FE_PP_PARSING_ERR_FWD_0_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 10 ;
    ca_uint32_t ipv4_hdr_cs_err      :  2 ; /* bits 11:10 */
    ca_uint32_t pkt_l2_size_err      :  2 ; /* bits 13:12 */
    ca_uint32_t pkt_l3_total_len_err :  2 ; /* bits 15:14 */
    ca_uint32_t ip_hdr_err           :  2 ; /* bits 17:16 */
    ca_uint32_t ipv4_total_len_err   :  2 ; /* bits 19:18 */
    ca_uint32_t tcp_data_offset_err  :  2 ; /* bits 21:20 */
    ca_uint32_t udp_total_len_err    :  2 ; /* bits 23:22 */
    ca_uint32_t udp_lite_cs_cvrg_err :  2 ; /* bits 25:24 */
    ca_uint32_t rdp_hdr_len_err      :  2 ; /* bits 27:26 */
    ca_uint32_t offset_l3_excd_255_err :  2 ; /* bits 29:28 */
    ca_uint32_t offset_l4_excd_255_err :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_PARSING_ERR_FWD_0_t;


#define  SATURN_L3FE_PP_PARSING_ERR_FWD_1                0xd0003234
#define  SATURN_L3FE_PP_PARSING_ERR_FWD_1_dft            0x00005000

typedef volatile union {
  struct {
    ca_uint32_t dsl_inner_ip_hdr_cs_err :  2 ; /* bits 1:0 */
    ca_uint32_t pkt_inner_l3_total_len_err :  2 ; /* bits 3:2 */
    ca_uint32_t inner_ip_hdr_err     :  2 ; /* bits 5:4 */
    ca_uint32_t dsl_inner_ipv4_total_len_err :  2 ; /* bits 7:6 */
    ca_uint32_t offset_l3_inner_excd_255_err :  2 ; /* bits 9:8 */
    ca_uint32_t udp_zero_chksum_err  :  2 ; /* bits 11:10 */
    ca_uint32_t more_than_2_vlan_tags_flg :  2 ; /* bits 13:12 */
    ca_uint32_t l2tp_hdr_err         :  2 ; /* bits 15:14 */
    ca_uint32_t rdp_ver_err          :  2 ; /* bits 17:16 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_PARSING_ERR_FWD_1_t;


#define  SATURN_L3FE_PP_PARSING_ERR_TRAP                 0xd0003238
#define  SATURN_L3FE_PP_PARSING_ERR_TRAP_dft             0xfffffa10

typedef volatile union {
  struct {
    ca_uint32_t rdir_ldpid           :  6 ; /* bits 5:0 */
    ca_uint32_t rdir_cos             :  3 ; /* bits 8:6 */
    ca_uint32_t keep_orig_pkt        :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t t0_ctrl              :  1 ; /* bits 11:11 */
    ca_uint32_t t1_ctrl              :  4 ; /* bits 15:12 */
    ca_uint32_t t2_ctrl              :  4 ; /* bits 19:16 */
    ca_uint32_t t3_ctrl              :  4 ; /* bits 23:20 */
    ca_uint32_t t4_ctrl              :  4 ; /* bits 27:24 */
    ca_uint32_t t5_ctrl              :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_PARSING_ERR_TRAP_t;


#define  SATURN_L3FE_PP_PARSING_OVER_VLAN_FWD_CTL        0xd000323c
#define  SATURN_L3FE_PP_PARSING_OVER_VLAN_FWD_CTL_dft    0xfffffa10

typedef volatile union {
  struct {
    ca_uint32_t rdir_ldpid           :  6 ; /* bits 5:0 */
    ca_uint32_t rdir_cos             :  3 ; /* bits 8:6 */
    ca_uint32_t keep_orig_pkt        :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t t0_ctrl              :  1 ; /* bits 11:11 */
    ca_uint32_t t1_ctrl              :  4 ; /* bits 15:12 */
    ca_uint32_t t2_ctrl              :  4 ; /* bits 19:16 */
    ca_uint32_t t3_ctrl              :  4 ; /* bits 23:20 */
    ca_uint32_t t4_ctrl              :  4 ; /* bits 27:24 */
    ca_uint32_t t5_ctrl              :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_PARSING_OVER_VLAN_FWD_CTL_t;


#define  SATURN_L3FE_PP_USER_TYPE_0                      0xd0003240
#define  SATURN_L3FE_PP_USER_TYPE_0_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t user_type_0          : 16 ; /* bits 15:0 */
    ca_uint32_t user_type_1          : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_USER_TYPE_0_t;


#define  SATURN_L3FE_PP_USER_TYPE_1                      0xd0003244
#define  SATURN_L3FE_PP_USER_TYPE_1_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t user_type_2          : 16 ; /* bits 15:0 */
    ca_uint32_t user_type_3          : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_USER_TYPE_1_t;


#define  SATURN_L3FE_PP_USER_MAC_0_LOW                   0xd0003248
#define  SATURN_L3FE_PP_USER_MAC_0_LOW_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t user_mac_0           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_USER_MAC_0_LOW_t;


#define  SATURN_L3FE_PP_USER_MAC_0_HI                    0xd000324c
#define  SATURN_L3FE_PP_USER_MAC_0_HI_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t user_mac_0           : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_USER_MAC_0_HI_t;


#define  SATURN_L3FE_PP_USER_MAC_1_LOW                   0xd0003250
#define  SATURN_L3FE_PP_USER_MAC_1_LOW_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t user_mac_1           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_USER_MAC_1_LOW_t;


#define  SATURN_L3FE_PP_USER_MAC_1_HI                    0xd0003254
#define  SATURN_L3FE_PP_USER_MAC_1_HI_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t user_mac_1           : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_USER_MAC_1_HI_t;


#define  SATURN_L3FE_PP_USER_MAC_0_MASK_LOW              0xd0003258
#define  SATURN_L3FE_PP_USER_MAC_0_MASK_LOW_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t user_mac_mask_0      : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_USER_MAC_0_MASK_LOW_t;


#define  SATURN_L3FE_PP_USER_MAC_0_MASK_HI               0xd000325c
#define  SATURN_L3FE_PP_USER_MAC_0_MASK_HI_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t user_mac_mask_0      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_USER_MAC_0_MASK_HI_t;


#define  SATURN_L3FE_PP_USER_MAC_1_MASK_LOW              0xd0003260
#define  SATURN_L3FE_PP_USER_MAC_1_MASK_LOW_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t user_mac_mask_1      : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_USER_MAC_1_MASK_LOW_t;


#define  SATURN_L3FE_PP_USER_MAC_1_MASK_HI               0xd0003264
#define  SATURN_L3FE_PP_USER_MAC_1_MASK_HI_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t user_mac_mask_1      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_USER_MAC_1_MASK_HI_t;


#define  SATURN_L3FE_PP_TPID_0                           0xd0003268
#define  SATURN_L3FE_PP_TPID_0_dft                       0x88a88100

typedef volatile union {
  struct {
    ca_uint32_t tpid_0               : 16 ; /* bits 15:0 */
    ca_uint32_t tpid_1               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_TPID_0_t;


#define  SATURN_L3FE_PP_TPID_1                           0xd000326c
#define  SATURN_L3FE_PP_TPID_1_dft                       0x92009100

typedef volatile union {
  struct {
    ca_uint32_t tpid_2               : 16 ; /* bits 15:0 */
    ca_uint32_t tpid_3               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_TPID_1_t;


#define  SATURN_L3FE_PP_TPID_CTRL                        0xd0003270
#define  SATURN_L3FE_PP_TPID_CTRL_dft                    0x00000077

typedef volatile union {
  struct {
    ca_uint32_t top_vlan_en          :  4 ; /* bits 3:0 */
    ca_uint32_t inner_vlan_en        :  4 ; /* bits 7:4 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_TPID_CTRL_t;


#define  SATURN_L3FE_PP_ARP_TARGET_IP                    0xd0003274
#define  SATURN_L3FE_PP_ARP_TARGET_IP_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t target_ip            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_ARP_TARGET_IP_t;


#define  SATURN_L3FE_PP_OAM                              0xd0003278
#define  SATURN_L3FE_PP_OAM_dft                          0x00000803

typedef volatile union {
  struct {
    ca_uint32_t subtype              :  8 ; /* bits 7:0 */
    ca_uint32_t mymdlvl              :  3 ; /* bits 10:8 */
    ca_uint32_t mymdlvl_det_en       :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_OAM_t;


#define  SATURN_L3FE_PP_HELLO_MAC_LOW                    0xd000327c
#define  SATURN_L3FE_PP_HELLO_MAC_LOW_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_HELLO_MAC_LOW_t;


#define  SATURN_L3FE_PP_HELLO_MAC_HI                     0xd0003280
#define  SATURN_L3FE_PP_HELLO_MAC_HI_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_HELLO_MAC_HI_t;


#define  SATURN_L3FE_PP_MY_MAC_LOW                       0xd0003284
#define  SATURN_L3FE_PP_MY_MAC_LOW_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mymac                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_MY_MAC_LOW_t;


#define  SATURN_L3FE_PP_MY_MAC_HI                        0xd0003288
#define  SATURN_L3FE_PP_MY_MAC_HI_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mymac                : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_MY_MAC_HI_t;


#define  SATURN_L3FE_PP_MC_MAC_HI_RNG                    0xd000328c
#define  SATURN_L3FE_PP_MC_MAC_HI_RNG_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hi_rng_mac_low       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_MC_MAC_HI_RNG_t;


#define  SATURN_L3FE_PP_MC_MAC_LOW_RNG                   0xd0003290
#define  SATURN_L3FE_PP_MC_MAC_LOW_RNG_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t low_rng_mac_low      : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_MC_MAC_LOW_RNG_t;


#define  SATURN_L3FE_PP_MC_MAC_RNG                       0xd0003294
#define  SATURN_L3FE_PP_MC_MAC_RNG_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t low_rng_mac_hi       : 16 ; /* bits 15:0 */
    ca_uint32_t hi_rng_mac_hi        : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_MC_MAC_RNG_t;


#define  SATURN_L3FE_PP_HTTP_LINK_0                      0xd0003298
#define  SATURN_L3FE_PP_HTTP_LINK_0_dft                  0x04000000

typedef volatile union {
  struct {
    ca_uint32_t rule_l4_pid          : 16 ; /* bits 15:0 */
    ca_uint32_t rule_l4_pid_sel      :  1 ; /* bits 16:16 */
    ca_uint32_t rule_l4_type         :  3 ; /* bits 19:17 */
    ca_uint32_t rule_lspid           :  6 ; /* bits 25:20 */
    ca_uint32_t rule_lspid_msk       :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t rule_vld             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_HTTP_LINK_0_t;


#define  SATURN_L3FE_PP_HTTP_LINK_1                      0xd000329c
#define  SATURN_L3FE_PP_HTTP_LINK_1_dft                  0x04000000

typedef volatile union {
  struct {
    ca_uint32_t rule_l4_pid          : 16 ; /* bits 15:0 */
    ca_uint32_t rule_l4_pid_sel      :  1 ; /* bits 16:16 */
    ca_uint32_t rule_l4_type         :  3 ; /* bits 19:17 */
    ca_uint32_t rule_lspid           :  6 ; /* bits 25:20 */
    ca_uint32_t rule_lspid_msk       :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t rule_vld             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_HTTP_LINK_1_t;


#define  SATURN_L3FE_PP_HTTP_LINK_2                      0xd00032a0
#define  SATURN_L3FE_PP_HTTP_LINK_2_dft                  0x04000000

typedef volatile union {
  struct {
    ca_uint32_t rule_l4_pid          : 16 ; /* bits 15:0 */
    ca_uint32_t rule_l4_pid_sel      :  1 ; /* bits 16:16 */
    ca_uint32_t rule_l4_type         :  3 ; /* bits 19:17 */
    ca_uint32_t rule_lspid           :  6 ; /* bits 25:20 */
    ca_uint32_t rule_lspid_msk       :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t rule_vld             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_HTTP_LINK_2_t;


#define  SATURN_L3FE_PP_HTTP_LINK_3                      0xd00032a4
#define  SATURN_L3FE_PP_HTTP_LINK_3_dft                  0x04000000

typedef volatile union {
  struct {
    ca_uint32_t rule_l4_pid          : 16 ; /* bits 15:0 */
    ca_uint32_t rule_l4_pid_sel      :  1 ; /* bits 16:16 */
    ca_uint32_t rule_l4_type         :  3 ; /* bits 19:17 */
    ca_uint32_t rule_lspid           :  6 ; /* bits 25:20 */
    ca_uint32_t rule_lspid_msk       :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t rule_vld             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_HTTP_LINK_3_t;


#define  SATURN_L3FE_PP_PINGPONG_STS                     0xd00032a8
#define  SATURN_L3FE_PP_PINGPONG_STS_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ovfl                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_PINGPONG_STS_t;


#define  SATURN_L3FE_PP_NI_INTF_ERR_STTS_0               0xd00032ac
#define  SATURN_L3FE_PP_NI_INTF_ERR_STTS_0_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sop_eop_mismatch     :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_NI_INTF_ERR_STTS_0_t;


#define  SATURN_L3FE_PP_NI_INTF_ERR_STTS_1               0xd00032b0
#define  SATURN_L3FE_PP_NI_INTF_ERR_STTS_1_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t runt_l2_pkt          :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_NI_INTF_ERR_STTS_1_t;


#define  SATURN_L3FE_PP_NI_INTF_STS                      0xd00032b4
#define  SATURN_L3FE_PP_NI_INTF_STS_dft                  0x00000001

typedef volatile union {
  struct {
    ca_uint32_t rdy                  :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_NI_INTF_STS_t;


#define  SATURN_L3FE_PP_NI_INTF_PKT_CNT                  0xd00032b8
#define  SATURN_L3FE_PP_NI_INTF_PKT_CNT_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t eop                  : 16 ; /* bits 15:0 */
    ca_uint32_t sop                  : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_NI_INTF_PKT_CNT_t;


#define  SATURN_L3FE_PP_L4_CS_ERR                        0xd00032bc
#define  SATURN_L3FE_PP_L4_CS_ERR_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_L4_CS_ERR_t;


#define  SATURN_L3FE_PP_HEADER_A_LOW                     0xd00032c0
#define  SATURN_L3FE_PP_HEADER_A_LOW_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_HEADER_A_LOW_t;


#define  SATURN_L3FE_PP_HEADER_A_HI                      0xd00032c4
#define  SATURN_L3FE_PP_HEADER_A_HI_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_HEADER_A_HI_t;


#define  SATURN_L3FE_PP_HEADER_CPU_LOW                   0xd00032c8
#define  SATURN_L3FE_PP_HEADER_CPU_LOW_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_HEADER_CPU_LOW_t;


#define  SATURN_L3FE_PP_HEADER_CPU_HI                    0xd00032cc
#define  SATURN_L3FE_PP_HEADER_CPU_HI_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_HEADER_CPU_HI_t;


#define  SATURN_L3FE_PP_NI2FE_INTF_FF_STS                0xd00032d0
#define  SATURN_L3FE_PP_NI2FE_INTF_FF_STS_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ovfl                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_PP_NI2FE_INTF_FF_STS_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PP */
typedef struct {
  SATURN_L3FE_PP_FIELD_CAM_ACCESS_t               FIELD_CAM_ACCESS;              /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_L3FE_PP_FIELD_CAM_DATA4_t                FIELD_CAM_DATA4;               /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_L3FE_PP_FIELD_CAM_DATA3_t                FIELD_CAM_DATA3;               /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_L3FE_PP_FIELD_CAM_DATA2_t                FIELD_CAM_DATA2;               /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_L3FE_PP_FIELD_CAM_DATA1_t                FIELD_CAM_DATA1;               /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_L3FE_PP_FIELD_CAM_DATA0_t                FIELD_CAM_DATA0;               /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_L3FE_PP_SPCL_PKT_DETECTION_CFG_t         SPCL_PKT_DETECTION_CFG;        /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  SATURN_L3FE_PP_IPNIP_SPCL_PKT_DET_EN_t          IPNIP_SPCL_PKT_DET_EN;         /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  SATURN_L3FE_PP_OFFSET_HDR_t                     OFFSET_HDR;                    /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  SATURN_L3FE_PP_PARSING_LMT_t                    PARSING_LMT;                   /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  SATURN_L3FE_PP_PARSING_STTS_0_t                 PARSING_STTS_0;                /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  SATURN_L3FE_PP_PARSING_STTS_1_t                 PARSING_STTS_1;                /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  SATURN_L3FE_PP_PARSING_ERR_FWD_0_t              PARSING_ERR_FWD_0;             /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  SATURN_L3FE_PP_PARSING_ERR_FWD_1_t              PARSING_ERR_FWD_1;             /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  SATURN_L3FE_PP_PARSING_ERR_TRAP_t               PARSING_ERR_TRAP;              /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  SATURN_L3FE_PP_PARSING_OVER_VLAN_FWD_CTL_t      PARSING_OVER_VLAN_FWD_CTL;     /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  SATURN_L3FE_PP_USER_TYPE_0_t                    USER_TYPE_0;                   /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  SATURN_L3FE_PP_USER_TYPE_1_t                    USER_TYPE_1;                   /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  SATURN_L3FE_PP_USER_MAC_0_LOW_t                 USER_MAC_0_LOW;                /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  SATURN_L3FE_PP_USER_MAC_0_HI_t                  USER_MAC_0_HI;                 /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  SATURN_L3FE_PP_USER_MAC_1_LOW_t                 USER_MAC_1_LOW;                /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  SATURN_L3FE_PP_USER_MAC_1_HI_t                  USER_MAC_1_HI;                 /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  SATURN_L3FE_PP_USER_MAC_0_MASK_LOW_t            USER_MAC_0_MASK_LOW;           /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  SATURN_L3FE_PP_USER_MAC_0_MASK_HI_t             USER_MAC_0_MASK_HI;            /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  SATURN_L3FE_PP_USER_MAC_1_MASK_LOW_t            USER_MAC_1_MASK_LOW;           /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  SATURN_L3FE_PP_USER_MAC_1_MASK_HI_t             USER_MAC_1_MASK_HI;            /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  SATURN_L3FE_PP_TPID_0_t                         TPID_0;                        /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  SATURN_L3FE_PP_TPID_1_t                         TPID_1;                        /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  SATURN_L3FE_PP_TPID_CTRL_t                      TPID_CTRL;                     /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  SATURN_L3FE_PP_ARP_TARGET_IP_t                  ARP_TARGET_IP;                 /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  SATURN_L3FE_PP_OAM_t                            OAM;                           /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  SATURN_L3FE_PP_HELLO_MAC_LOW_t                  HELLO_MAC_LOW;                 /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  SATURN_L3FE_PP_HELLO_MAC_HI_t                   HELLO_MAC_HI;                  /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  SATURN_L3FE_PP_MY_MAC_LOW_t                     MY_MAC_LOW;                    /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  SATURN_L3FE_PP_MY_MAC_HI_t                      MY_MAC_HI;                     /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  SATURN_L3FE_PP_MC_MAC_HI_RNG_t                  MC_MAC_HI_RNG;                 /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  SATURN_L3FE_PP_MC_MAC_LOW_RNG_t                 MC_MAC_LOW_RNG;                /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  SATURN_L3FE_PP_MC_MAC_RNG_t                     MC_MAC_RNG;                    /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  SATURN_L3FE_PP_HTTP_LINK_0_t                    HTTP_LINK_0;                   /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];                   
  SATURN_L3FE_PP_HTTP_LINK_1_t                    HTTP_LINK_1;                   /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];                   
  SATURN_L3FE_PP_HTTP_LINK_2_t                    HTTP_LINK_2;                   /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];                   
  SATURN_L3FE_PP_HTTP_LINK_3_t                    HTTP_LINK_3;                   /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];                   
  SATURN_L3FE_PP_PINGPONG_STS_t                   PINGPONG_STS;                  /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];                   
  SATURN_L3FE_PP_NI_INTF_ERR_STTS_0_t             NI_INTF_ERR_STTS_0;            /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd44[3];                   
  SATURN_L3FE_PP_NI_INTF_ERR_STTS_1_t             NI_INTF_ERR_STTS_1;            /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd45[3];                   
  SATURN_L3FE_PP_NI_INTF_STS_t                    NI_INTF_STS;                   /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd46[3];                   
  SATURN_L3FE_PP_NI_INTF_PKT_CNT_t                NI_INTF_PKT_CNT;               /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd47[3];                   
  SATURN_L3FE_PP_L4_CS_ERR_t                      L4_CS_ERR;                     /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd48[3];                   
  SATURN_L3FE_PP_HEADER_A_LOW_t                   HEADER_A_LOW;                  /* addr: 0x000000c0 */
  ca_uint32_t                              rsrvd49[3];                   
  SATURN_L3FE_PP_HEADER_A_HI_t                    HEADER_A_HI;                   /* addr: 0x000000c4 */
  ca_uint32_t                              rsrvd50[3];                   
  SATURN_L3FE_PP_HEADER_CPU_LOW_t                 HEADER_CPU_LOW;                /* addr: 0x000000c8 */
  ca_uint32_t                              rsrvd51[3];                   
  SATURN_L3FE_PP_HEADER_CPU_HI_t                  HEADER_CPU_HI;                 /* addr: 0x000000cc */
  ca_uint32_t                              rsrvd52[3];                   
  SATURN_L3FE_PP_NI2FE_INTF_FF_STS_t              NI2FE_INTF_FF_STS;             /* addr: 0x000000d0 */
} SATURN_APB0_L3FE_PP_t;


/*
 * CLS
 */
        
#define  SATURN_L3FE_CLS_KEY_TBL_ACCESS                  0xd0003300
#define  SATURN_L3FE_CLS_KEY_TBL_ACCESS_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_CLS_KEY_TBL_ACCESS_t;


#define  SATURN_L3FE_CLS_KEY_TBL_DATA10                  0xd0003304
#define  SATURN_L3FE_CLS_KEY_TBL_DATA10_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 12 ; /* bits 11:0 */
    ca_uint32_t cl_entry_mode        :  1 ; /* bits 12:12 */
    ca_uint32_t cl_pri               :  4 ; /* bits 16:13 */
    ca_uint32_t cl_rslt_type         :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_type          :  3 ; /* bits 20:18 */
    ca_uint32_t cl_key_valid         :  4 ; /* bits 24:21 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_CLS_KEY_TBL_DATA10_t;


#define  SATURN_L3FE_CLS_KEY_TBL_DATA9                   0xd0003308
#define  SATURN_L3FE_CLS_KEY_TBL_DATA9_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_CLS_KEY_TBL_DATA9_t;


#define  SATURN_L3FE_CLS_KEY_TBL_DATA8                   0xd000330c
#define  SATURN_L3FE_CLS_KEY_TBL_DATA8_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_CLS_KEY_TBL_DATA8_t;


#define  SATURN_L3FE_CLS_KEY_TBL_DATA7                   0xd0003310
#define  SATURN_L3FE_CLS_KEY_TBL_DATA7_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_CLS_KEY_TBL_DATA7_t;


#define  SATURN_L3FE_CLS_KEY_TBL_DATA6                   0xd0003314
#define  SATURN_L3FE_CLS_KEY_TBL_DATA6_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_CLS_KEY_TBL_DATA6_t;


#define  SATURN_L3FE_CLS_KEY_TBL_DATA5                   0xd0003318
#define  SATURN_L3FE_CLS_KEY_TBL_DATA5_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_CLS_KEY_TBL_DATA5_t;


#define  SATURN_L3FE_CLS_KEY_TBL_DATA4                   0xd000331c
#define  SATURN_L3FE_CLS_KEY_TBL_DATA4_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_CLS_KEY_TBL_DATA4_t;


#define  SATURN_L3FE_CLS_KEY_TBL_DATA3                   0xd0003320
#define  SATURN_L3FE_CLS_KEY_TBL_DATA3_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_CLS_KEY_TBL_DATA3_t;


#define  SATURN_L3FE_CLS_KEY_TBL_DATA2                   0xd0003324
#define  SATURN_L3FE_CLS_KEY_TBL_DATA2_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_CLS_KEY_TBL_DATA2_t;


#define  SATURN_L3FE_CLS_KEY_TBL_DATA1                   0xd0003328
#define  SATURN_L3FE_CLS_KEY_TBL_DATA1_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_CLS_KEY_TBL_DATA1_t;


#define  SATURN_L3FE_CLS_KEY_TBL_DATA0                   0xd000332c
#define  SATURN_L3FE_CLS_KEY_TBL_DATA0_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_CLS_KEY_TBL_DATA0_t;


#define  SATURN_L3FE_CLS_FIB_TBL_ACCESS                  0xd0003330
#define  SATURN_L3FE_CLS_FIB_TBL_ACCESS_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 20 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_CLS_FIB_TBL_ACCESS_t;


#define  SATURN_L3FE_CLS_FIB_TBL_DATA6                   0xd0003334
#define  SATURN_L3FE_CLS_FIB_TBL_DATA6_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_CLS_FIB_TBL_DATA6_t;


#define  SATURN_L3FE_CLS_FIB_TBL_DATA5                   0xd0003338
#define  SATURN_L3FE_CLS_FIB_TBL_DATA5_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_CLS_FIB_TBL_DATA5_t;


#define  SATURN_L3FE_CLS_FIB_TBL_DATA4                   0xd000333c
#define  SATURN_L3FE_CLS_FIB_TBL_DATA4_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_CLS_FIB_TBL_DATA4_t;


#define  SATURN_L3FE_CLS_FIB_TBL_DATA3                   0xd0003340
#define  SATURN_L3FE_CLS_FIB_TBL_DATA3_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_CLS_FIB_TBL_DATA3_t;


#define  SATURN_L3FE_CLS_FIB_TBL_DATA2                   0xd0003344
#define  SATURN_L3FE_CLS_FIB_TBL_DATA2_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_CLS_FIB_TBL_DATA2_t;


#define  SATURN_L3FE_CLS_FIB_TBL_DATA1                   0xd0003348
#define  SATURN_L3FE_CLS_FIB_TBL_DATA1_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_CLS_FIB_TBL_DATA1_t;


#define  SATURN_L3FE_CLS_FIB_TBL_DATA0                   0xd000334c
#define  SATURN_L3FE_CLS_FIB_TBL_DATA0_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_CLS_FIB_TBL_DATA0_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* CLS */
typedef struct {
  SATURN_L3FE_CLS_KEY_TBL_ACCESS_t                KEY_TBL_ACCESS;                /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  SATURN_L3FE_CLS_KEY_TBL_DATA10_t                KEY_TBL_DATA10;                /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  SATURN_L3FE_CLS_KEY_TBL_DATA9_t                 KEY_TBL_DATA9;                 /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  SATURN_L3FE_CLS_KEY_TBL_DATA8_t                 KEY_TBL_DATA8;                 /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  SATURN_L3FE_CLS_KEY_TBL_DATA7_t                 KEY_TBL_DATA7;                 /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  SATURN_L3FE_CLS_KEY_TBL_DATA6_t                 KEY_TBL_DATA6;                 /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  SATURN_L3FE_CLS_KEY_TBL_DATA5_t                 KEY_TBL_DATA5;                 /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  SATURN_L3FE_CLS_KEY_TBL_DATA4_t                 KEY_TBL_DATA4;                 /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  SATURN_L3FE_CLS_KEY_TBL_DATA3_t                 KEY_TBL_DATA3;                 /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  SATURN_L3FE_CLS_KEY_TBL_DATA2_t                 KEY_TBL_DATA2;                 /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  SATURN_L3FE_CLS_KEY_TBL_DATA1_t                 KEY_TBL_DATA1;                 /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  SATURN_L3FE_CLS_KEY_TBL_DATA0_t                 KEY_TBL_DATA0;                 /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  SATURN_L3FE_CLS_FIB_TBL_ACCESS_t                FIB_TBL_ACCESS;                /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  SATURN_L3FE_CLS_FIB_TBL_DATA6_t                 FIB_TBL_DATA6;                 /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  SATURN_L3FE_CLS_FIB_TBL_DATA5_t                 FIB_TBL_DATA5;                 /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  SATURN_L3FE_CLS_FIB_TBL_DATA4_t                 FIB_TBL_DATA4;                 /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  SATURN_L3FE_CLS_FIB_TBL_DATA3_t                 FIB_TBL_DATA3;                 /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  SATURN_L3FE_CLS_FIB_TBL_DATA2_t                 FIB_TBL_DATA2;                 /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  SATURN_L3FE_CLS_FIB_TBL_DATA1_t                 FIB_TBL_DATA1;                 /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  SATURN_L3FE_CLS_FIB_TBL_DATA0_t                 FIB_TBL_DATA0;                 /* addr: 0x0000004c */
} SATURN_APB0_L3FE_CLS_t;


/*
 * STG0
 */
        
#define  SATURN_L3FE_STG0_CTRL                           0xd0003380
#define  SATURN_L3FE_STG0_CTRL_dft                       0x00047c7e

typedef volatile union {
  struct {
    ca_uint32_t lpb_idx_mode         :  1 ; /* bits 0:0 */
    ca_uint32_t mac_fltr_fail_pkt_mru_chk_en :  1 ; /* bits 1:1 */
    ca_uint32_t mru_chk_fail_pkt_l2_lkup_dis :  1 ; /* bits 2:2 */
    ca_uint32_t other_mac_pkt_keep_lspid_en :  1 ; /* bits 3:3 */
    ca_uint32_t wan_lspid            :  6 ; /* bits 9:4 */
    ca_uint32_t use_lspid_ovwr_o_lspid :  1 ; /* bits 10:10 */
    ca_uint32_t spcl_pkt_keep_old    :  1 ; /* bits 11:11 */
    ca_uint32_t wan_lspid_1          :  6 ; /* bits 17:12 */
    ca_uint32_t msk_my_mac_match_en_for_lspid_upd :  1 ; /* bits 18:18 */
    ca_uint32_t keep_lspid_unchange  :  1 ; /* bits 19:19 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_STG0_CTRL_t;


#define  SATURN_L3FE_STG0_LDPID_MAP                      0xd0003384
#define  SATURN_L3FE_STG0_LDPID_MAP_dft                  0x03591807

typedef volatile union {
  struct {
    ca_uint32_t rule_0               :  6 ; /* bits 5:0 */
    ca_uint32_t lpb_idx_0            :  2 ; /* bits 7:6 */
    ca_uint32_t rule_1               :  6 ; /* bits 13:8 */
    ca_uint32_t lpb_idx_1            :  2 ; /* bits 15:14 */
    ca_uint32_t rule_2               :  6 ; /* bits 21:16 */
    ca_uint32_t lpb_idx_2            :  2 ; /* bits 23:22 */
    ca_uint32_t lpb_idx_3            :  2 ; /* bits 25:24 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_STG0_LDPID_MAP_t;


#define  SATURN_L3FE_STG0_LPB_TBL_LOW_0                  0xd0003388
#define  SATURN_L3FE_STG0_LPB_TBL_LOW_0_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_STG0_LPB_TBL_LOW_0_t;


#define  SATURN_L3FE_STG0_LPB_TBL_MID_0                  0xd000338c
#define  SATURN_L3FE_STG0_LPB_TBL_MID_0_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_STG0_LPB_TBL_MID_0_t;


#define  SATURN_L3FE_STG0_LPB_TBL_HIGH_0                 0xd0003390
#define  SATURN_L3FE_STG0_LPB_TBL_HIGH_0_dft             0x18000190

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_STG0_LPB_TBL_HIGH_0_t;


#define  SATURN_L3FE_STG0_LPB_TBL_LOW_1                  0xd0003394
#define  SATURN_L3FE_STG0_LPB_TBL_LOW_1_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_STG0_LPB_TBL_LOW_1_t;


#define  SATURN_L3FE_STG0_LPB_TBL_MID_1                  0xd0003398
#define  SATURN_L3FE_STG0_LPB_TBL_MID_1_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} SATURN_L3FE_STG0_LPB_TBL_MID_1_t;


#define  SATURN_L