/*
 * REGISTERS.h
 *
 * THIS FILE WAS AUTOMATICALLY GENERATED BY /auto/project/bin/rdb2tt.pl
 * -config ./reg_generator/rdb2h.yml -db ./reg.db
 *
 */
#ifndef _CA8279_PON_REGISTERS_H_
#define _CA8279_PON_REGISTERS_H_

#include "ca_types.h"

/******************************************************************
 *
 * Each register in the map is defined as a struct with bitfields.
 *
 ******************************************************************/

/*
 * APB2
 */
  
/*
 * GLB
 */
        

#define GLOBAL_EPON_CNTL                         0x44100004
#define GLOBAL_EPON_CNTL_dft                     0x00030000

typedef volatile union {
  struct {
    ca_uint32_t epon_rst_n           :  1 ; /* bits 0:0 */
    ca_uint32_t onumpcp_rst_n        :  1 ; /* bits 1:1 */
    ca_uint32_t onugepn_rst_n        :  1 ; /* bits 2:2 */
    ca_uint32_t xgepn_rst_n          :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t rx_coresec_10_rst_n  :  1 ; /* bits 5:5 */
    ca_uint32_t tx_coresec_10_rst_n  :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t gepn_rx_rst_n        :  1 ; /* bits 8:8 */
    ca_uint32_t gepn_tx_rst_n        :  1 ; /* bits 9:9 */
    ca_uint32_t xgepn_rx_rst_n       :  1 ; /* bits 10:10 */
    ca_uint32_t xgepn_tx_rst_n       :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd3               :  4 ;
    ca_uint32_t epon_onu_mode        :  2 ; /* bits 17:16 */
    ca_uint32_t epon_ethernet_mode   :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd4               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_EPON_CNTL_t;


#define GLOBAL_EPON_STATUS                       0x44100008
#define GLOBAL_EPON_STATUS_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t xgepon_linkok        :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_EPON_STATUS_t;


#define GLOBAL_GPON_CNTL                         0x4410000c
#define GLOBAL_GPON_CNTL_dft                     0x00000300

typedef volatile union {
  struct {
    ca_uint32_t ani_rst_n            :  1 ; /* bits 0:0 */
    ca_uint32_t gpon_rst_n           :  1 ; /* bits 1:1 */
    ca_uint32_t xgpn_rst_n           :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t us10g_mode           :  1 ; /* bits 8:8 */
    ca_uint32_t nxgs_mode            :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd2               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_GPON_CNTL_t;


#define GLOBAL_OPT_MODULE_CNTL                   0x44100010
#define GLOBAL_OPT_MODULE_CNTL_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t opt_tx_power_down    :  1 ; /* bits 0:0 */
    ca_uint32_t en_lao_det           :  1 ; /* bits 1:1 */
    ca_uint32_t hw_lao_enable        :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_OPT_MODULE_CNTL_t;


#define GLOBAL_OPT_MODULE_LAO_CNTL               0x44100014
#define GLOBAL_OPT_MODULE_LAO_CNTL_dft           0x00ff00ff

typedef volatile union {
  struct {
    ca_uint32_t lao_accu_one         : 16 ; /* bits 15:0 */
    ca_uint32_t lao_accu_zero        : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_OPT_MODULE_LAO_CNTL_t;


#define GLOBAL_OPT_INTERRUPT                     0x44100018
#define GLOBAL_OPT_INTERRUPT_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_los               :  1 ; /* bits 0:0 */
    ca_uint32_t tx_fault             :  1 ; /* bits 1:1 */
    ca_uint32_t mod_abs              :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t lao_stuck_at_one_int :  1 ; /* bits 8:8 */
    ca_uint32_t lao_stuck_at_zero_int :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd2               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_OPT_INTERRUPT_t;


#define GLOBAL_OPT_INTENABLE                     0x4410001c
#define GLOBAL_OPT_INTENABLE_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_losE              :  1 ; /* bits 0:0 */
    ca_uint32_t tx_faultE            :  1 ; /* bits 1:1 */
    ca_uint32_t mod_absE             :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t lao_stuck_at_one_intE :  1 ; /* bits 8:8 */
    ca_uint32_t lao_stuck_at_zero_intE :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd2               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_OPT_INTENABLE_t;


#define GLOBAL_OPT_MODULE_STATUS                 0x44100020
#define GLOBAL_OPT_MODULE_STATUS_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t opt_tx_fault         :  1 ; /* bits 0:0 */
    ca_uint32_t opt_tx_sd            :  1 ; /* bits 1:1 */
    ca_uint32_t opt_mod_abs          :  1 ; /* bits 2:2 */
    ca_uint32_t opt_rx_los           :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_OPT_MODULE_STATUS_t;


#define GLOBAL_PON_CNTL                          0x44100024
#define GLOBAL_PON_CNTL_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t epon_mode            :  1 ; /* bits 0:0 */
    ca_uint32_t pon_serdes_rst_n     :  1 ; /* bits 1:1 */
    ca_uint32_t psds_reg_rst_n       :  1 ; /* bits 2:2 */
    ca_uint32_t ptp_rst_n            :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t puc_reset            :  1 ; /* bits 8:8 */
    ca_uint32_t pdc_reset            :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd2               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_PON_CNTL_t;


/*
 * CLKGEN
 */
        
#define CLKGEN_CLKGEN_CONFIG                     0x44109000
#define CLKGEN_CLKGEN_CONFIG_dft                 0x01000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 10 ;
    ca_uint32_t use_gphy_clk         :  1 ; /* bits 10:10 */
    ca_uint32_t ext_eth_refclk       :  1 ; /* bits 11:11 */
    ca_uint32_t refclk_sel           :  2 ; /* bits 13:12 */
    ca_uint32_t sel_mck_out          :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd2               :  9 ;
    ca_uint32_t ptp_timer_reset      :  1 ; /* bits 24:24 */
    ca_uint32_t cpu_ap_pd            :  1 ; /* bits 25:25 */
    ca_uint32_t cpu_dsp_pd           :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd3               :  5 ;
  } bf ;
  ca_uint32_t     wrd ;
} CLKGEN_CLKGEN_CONFIG_t;


#define CLKGEN_PSDS_INIT_CNTL                    0x44109004
#define CLKGEN_PSDS_INIT_CNTL_dft                0x00000001

typedef volatile union {
  struct {
    ca_uint32_t REG_BG_LC_SEL        :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t ben_oen              :  1 ; /* bits 4:4 */
    ca_uint32_t POW_PCIX             :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t PRSTB_H              :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd3               :  5 ;
    ca_uint32_t PWDPAD_33            :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd4               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} CLKGEN_PSDS_INIT_CNTL_t;
  
/*
 * APB1
 */
  
/*
 * EPON
 */
  
/*
 * epon_glb
 */
        
#define EPON_EPON_GLB_INTERRUPT                  0xd0030000
#define EPON_EPON_GLB_INTERRUPT_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t onu_epon_int         :  1 ; /* bits 0:0 */
    ca_uint32_t xgepn_int            :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t mpcp_int             :  1 ; /* bits 3:3 */
    ca_uint32_t onu_1pps_int         :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t onu_gps_int          :  1 ; /* bits 6:6 */
    ca_uint32_t extif_int            :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd3               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_INTERRUPT_t;


#define EPON_EPON_GLB_INTERRUPTE                 0xd0030004
#define EPON_EPON_GLB_INTERRUPTE_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t onu_epon_intE        :  1 ; /* bits 0:0 */
    ca_uint32_t xgepn_intE           :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t mpcp_intE            :  1 ; /* bits 3:3 */
    ca_uint32_t onu_1pps_intE        :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t onu_gps_intE         :  1 ; /* bits 6:6 */
    ca_uint32_t extif_intE           :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd3               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_INTERRUPTE_t;


#define EPON_EPON_GLB_ONU_EPON_INTERRUPT         0xd0030008
#define EPON_EPON_GLB_ONU_EPON_INTERRUPT_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t TX_NON_EMPTYi        :  1 ; /* bits 8:8 */
    ca_uint32_t TX_PKT_CUTi          :  1 ; /* bits 9:9 */
    ca_uint32_t TX_OVERRUNi          :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t ptp_eg_ltsI          :  1 ; /* bits 12:12 */
    ca_uint32_t TX_PACKET_UFLOWi     :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t BM_PON_TX_MONi       :  1 ; /* bits 15:15 */
    ca_uint32_t txoam_DONEi          :  1 ; /* bits 16:16 */
    ca_uint32_t rx_data_fifo_overflow :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd4               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_ONU_EPON_INTERRUPT_t;


#define EPON_EPON_GLB_ONU_EPON_INTERRUPTE        0xd003000c
#define EPON_EPON_GLB_ONU_EPON_INTERRUPTE_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t TX_NON_EMPTYiE       :  1 ; /* bits 8:8 */
    ca_uint32_t TX_PKT_CUTiE         :  1 ; /* bits 9:9 */
    ca_uint32_t TX_OVERRUNiE         :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t ptp_eg_ltsIE         :  1 ; /* bits 12:12 */
    ca_uint32_t TX_PACKET_UFLOWiE    :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t BM_PON_TX_MONiE      :  1 ; /* bits 15:15 */
    ca_uint32_t txoam_DONEiE         :  1 ; /* bits 16:16 */
    ca_uint32_t rx_data_fifo_overflowE :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd4               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_ONU_EPON_INTERRUPTE_t;


#define EPON_EPON_GLB_EPON_STATUS                0xd0030010
#define EPON_EPON_GLB_EPON_STATUS_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sigloss              :  1 ; /* bits 0:0 */
    ca_uint32_t pcs_sync_xg          :  1 ; /* bits 1:1 */
    ca_uint32_t pcs_sync_1g          :  1 ; /* bits 2:2 */
    ca_uint32_t ethernet_mode        :  1 ; /* bits 3:3 */
    ca_uint32_t datapath_speed       :  2 ; /* bits 5:4 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_EPON_STATUS_t;


#define EPON_EPON_GLB_STATIC_CFG                 0xd0030014
#define EPON_EPON_GLB_STATIC_CFG_dft             0xcc100c00

typedef volatile union {
  struct {
    ca_uint32_t sigloss_polarity     :  1 ; /* bits 0:0 */
    ca_uint32_t laser_always_on      :  1 ; /* bits 1:1 */
    ca_uint32_t laser_tx_polarity    :  1 ; /* bits 2:2 */
    ca_uint32_t bc_llid_sel          :  1 ; /* bits 3:3 */
    ca_uint32_t txarb_mpfifo_rst_ctrl :  2 ; /* bits 5:4 */
    ca_uint32_t txarb_datfifo_rst_ctrl :  2 ; /* bits 7:6 */
    ca_uint32_t tx_ipg               :  4 ; /* bits 11:8 */
    ca_uint32_t tx_pause_sel_te      :  1 ; /* bits 12:12 */
    ca_uint32_t tx_pause_sel_l2te    :  1 ; /* bits 13:13 */
    ca_uint32_t tx_pause_sel_rxmux   :  1 ; /* bits 14:14 */
    ca_uint32_t tx_pause_sel_sw      :  1 ; /* bits 15:15 */
    ca_uint32_t sw_tx_pause          :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t dis_pdc_thrtl        :  1 ; /* bits 20:20 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t tx_dat_ipg           :  4 ; /* bits 27:24 */
    ca_uint32_t tx_oam_ipg           :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_STATIC_CFG_t;


#define EPON_EPON_GLB_XGEPN_MAC_ADDR_H           0xd0030018
#define EPON_EPON_GLB_XGEPN_MAC_ADDR_H_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_XGEPN_MAC_ADDR_H_t;


#define EPON_EPON_GLB_XGEPN_MAC_ADDR_L           0xd003001c
#define EPON_EPON_GLB_XGEPN_MAC_ADDR_L_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_XGEPN_MAC_ADDR_L_t;


#define EPON_EPON_GLB_CORESEC10_CFG              0xd0030020
#define EPON_EPON_GLB_CORESEC10_CFG_dft          0x0000000f

typedef volatile union {
  struct {
    ca_uint32_t algo_sel             :  2 ; /* bits 1:0 */
    ca_uint32_t tx_algo_sel          :  2 ; /* bits 3:2 */
    ca_uint32_t tx_IvSa_sel          :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_CORESEC10_CFG_t;


#define EPON_EPON_GLB_XGPCS_FEC_CFG              0xd0030024
#define EPON_EPON_GLB_XGPCS_FEC_CFG_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_off               :  1 ; /* bits 0:0 */
    ca_uint32_t tx_win_ctrl          :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t rx_mode              :  2 ; /* bits 5:4 */
    ca_uint32_t rsrvd2               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_XGPCS_FEC_CFG_t;


#define EPON_EPON_GLB_XGPCS_FEC_RXMODE_ST        0xd0030028
#define EPON_EPON_GLB_XGPCS_FEC_RXMODE_ST_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t misc                 : 18 ; /* bits 17:0 */
    ca_uint32_t rsrvd1               : 13 ;
    ca_uint32_t disable              :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_XGPCS_FEC_RXMODE_ST_t;


#define EPON_EPON_GLB_XGPCS_BD_pattern_fecless2  0xd003002c
#define EPON_EPON_GLB_XGPCS_BD_pattern_fecless2_dft 0x00000001

typedef volatile union {
  struct {
    ca_uint32_t val2                 :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_XGPCS_BD_pattern_fecless2_t;


#define EPON_EPON_GLB_XGPCS_BD_pattern_fecless1  0xd0030030
#define EPON_EPON_GLB_XGPCS_BD_pattern_fecless1_dft 0xb92f1a54

typedef volatile union {
  struct {
    ca_uint32_t val1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_XGPCS_BD_pattern_fecless1_t;


#define EPON_EPON_GLB_XGPCS_BD_pattern_fecless0  0xd0030034
#define EPON_EPON_GLB_XGPCS_BD_pattern_fecless0_dft 0x2c192eba

typedef volatile union {
  struct {
    ca_uint32_t val0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_XGPCS_BD_pattern_fecless0_t;


#define EPON_EPON_GLB_SFI64_KSDS32_XFER          0xd0030038
#define EPON_EPON_GLB_SFI64_KSDS32_XFER_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t rx_swap              :  1 ; /* bits 2:2 */
    ca_uint32_t tx_swap              :  1 ; /* bits 3:3 */
    ca_uint32_t rx_swap_dw           :  1 ; /* bits 4:4 */
    ca_uint32_t tx_swap_dw           :  1 ; /* bits 5:5 */
    ca_uint32_t rx_swap_dw_all       :  1 ; /* bits 6:6 */
    ca_uint32_t tx_swap_dw_all       :  1 ; /* bits 7:7 */
    ca_uint32_t debug_bus_sel        :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd2               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_SFI64_KSDS32_XFER_t;


#define EPON_EPON_GLB_PTP_CFG                    0xd003003c
#define EPON_EPON_GLB_PTP_CFG_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t en                   :  1 ; /* bits 0:0 */
    ca_uint32_t ptp_mode             :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_PTP_CFG_t;


#define EPON_EPON_GLB_NI_MODULE_IRQ_STATS        0xd0030040
#define EPON_EPON_GLB_NI_MODULE_IRQ_STATS_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t onu_1pps             :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t onurpt               :  1 ; /* bits 4:4 */
    ca_uint32_t onu_epon             :  1 ; /* bits 5:5 */
    ca_uint32_t rsvd_1b              :  1 ; /* bits 6:6 */
    ca_uint32_t xgepn_txarb          :  1 ; /* bits 7:7 */
    ca_uint32_t xgepn_xgmac          :  1 ; /* bits 8:8 */
    ca_uint32_t xgepn_xgpcs_rx       :  1 ; /* bits 9:9 */
    ca_uint32_t xgepn_xgpcs_tx       :  1 ; /* bits 10:10 */
    ca_uint32_t rx_coresec10         :  1 ; /* bits 11:11 */
    ca_uint32_t tx_coresec10         :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd2               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_NI_MODULE_IRQ_STATS_t;


#define EPON_EPON_GLB_MP_LT_RO_CTRL              0xd0030044
#define EPON_EPON_GLB_MP_LT_RO_CTRL_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t SWpulse              :  1 ; /* bits 1:1 */
    ca_uint32_t ts_en                :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd2               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_MP_LT_RO_CTRL_t;


#define EPON_EPON_GLB_PUC_CFG0                   0xd0030048
#define EPON_EPON_GLB_PUC_CFG0_dft               0x00300100

typedef volatile union {
  struct {
    ca_uint32_t puc_rpt_latency      : 16 ; /* bits 15:0 */
    ca_uint32_t puc_endrpt_latency   : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_PUC_CFG0_t;


#define EPON_EPON_GLB_PUC_CFG1                   0xd003004c
#define EPON_EPON_GLB_PUC_CFG1_dft               0x00000005

typedef volatile union {
  struct {
    ca_uint32_t puc_sch_latency      :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_PUC_CFG1_t;


#define EPON_EPON_GLB_PMAC_PKT_REQ_CNT           0xd0030050
#define EPON_EPON_GLB_PMAC_PKT_REQ_CNT_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pmac_pkt_req_cnt     : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_PMAC_PKT_REQ_CNT_t;


#define EPON_EPON_GLB_PUC_PKT_CNT                0xd0030054
#define EPON_EPON_GLB_PUC_PKT_CNT_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t puc_pkt_cnt          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_PUC_PKT_CNT_t;


#define EPON_EPON_GLB_PUC_BURST_CNT              0xd0030058
#define EPON_EPON_GLB_PUC_BURST_CNT_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t puc_burst_cnt        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_PUC_BURST_CNT_t;


#define EPON_EPON_GLB_PDC_PKT_CNT                0xd003005c
#define EPON_EPON_GLB_PDC_PKT_CNT_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pdc_pkt_cnt          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_PDC_PKT_CNT_t;


#define EPON_EPON_GLB_PUC_SCHSZ_CTRL             0xd0030060
#define EPON_EPON_GLB_PUC_SCHSZ_CTRL_dft         0x000001f4

typedef volatile union {
  struct {
    ca_uint32_t puc_schsz            : 21 ; /* bits 20:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t puc_schsz_fixed      :  1 ; /* bits 24:24 */
    ca_uint32_t rsrvd2               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_PUC_SCHSZ_CTRL_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY0          0xd0030064
#define EPON_EPON_GLB_LLID_TABLE_ENTRY0_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY0_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY1          0xd0030068
#define EPON_EPON_GLB_LLID_TABLE_ENTRY1_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY1_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY2          0xd003006c
#define EPON_EPON_GLB_LLID_TABLE_ENTRY2_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY2_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY3          0xd0030070
#define EPON_EPON_GLB_LLID_TABLE_ENTRY3_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY3_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY4          0xd0030074
#define EPON_EPON_GLB_LLID_TABLE_ENTRY4_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY4_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY5          0xd0030078
#define EPON_EPON_GLB_LLID_TABLE_ENTRY5_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY5_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY6          0xd003007c
#define EPON_EPON_GLB_LLID_TABLE_ENTRY6_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY6_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY7          0xd0030080
#define EPON_EPON_GLB_LLID_TABLE_ENTRY7_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY7_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY8          0xd0030084
#define EPON_EPON_GLB_LLID_TABLE_ENTRY8_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY8_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY9          0xd0030088
#define EPON_EPON_GLB_LLID_TABLE_ENTRY9_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY9_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY10         0xd003008c
#define EPON_EPON_GLB_LLID_TABLE_ENTRY10_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY10_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY11         0xd0030090
#define EPON_EPON_GLB_LLID_TABLE_ENTRY11_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY11_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY12         0xd0030094
#define EPON_EPON_GLB_LLID_TABLE_ENTRY12_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY12_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY13         0xd0030098
#define EPON_EPON_GLB_LLID_TABLE_ENTRY13_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY13_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY14         0xd003009c
#define EPON_EPON_GLB_LLID_TABLE_ENTRY14_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY14_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY15         0xd00300a0
#define EPON_EPON_GLB_LLID_TABLE_ENTRY15_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY15_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY16         0xd00300a4
#define EPON_EPON_GLB_LLID_TABLE_ENTRY16_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY16_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY17         0xd00300a8
#define EPON_EPON_GLB_LLID_TABLE_ENTRY17_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY17_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY18         0xd00300ac
#define EPON_EPON_GLB_LLID_TABLE_ENTRY18_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY18_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY19         0xd00300b0
#define EPON_EPON_GLB_LLID_TABLE_ENTRY19_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY19_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY20         0xd00300b4
#define EPON_EPON_GLB_LLID_TABLE_ENTRY20_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY20_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY21         0xd00300b8
#define EPON_EPON_GLB_LLID_TABLE_ENTRY21_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY21_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY22         0xd00300bc
#define EPON_EPON_GLB_LLID_TABLE_ENTRY22_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY22_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY23         0xd00300c0
#define EPON_EPON_GLB_LLID_TABLE_ENTRY23_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY23_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY24         0xd00300c4
#define EPON_EPON_GLB_LLID_TABLE_ENTRY24_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY24_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY25         0xd00300c8
#define EPON_EPON_GLB_LLID_TABLE_ENTRY25_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY25_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY26         0xd00300cc
#define EPON_EPON_GLB_LLID_TABLE_ENTRY26_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY26_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY27         0xd00300d0
#define EPON_EPON_GLB_LLID_TABLE_ENTRY27_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY27_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY28         0xd00300d4
#define EPON_EPON_GLB_LLID_TABLE_ENTRY28_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY28_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY29         0xd00300d8
#define EPON_EPON_GLB_LLID_TABLE_ENTRY29_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY29_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY30         0xd00300dc
#define EPON_EPON_GLB_LLID_TABLE_ENTRY30_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY30_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY31         0xd00300e0
#define EPON_EPON_GLB_LLID_TABLE_ENTRY31_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY31_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY32         0xd00300e4
#define EPON_EPON_GLB_LLID_TABLE_ENTRY32_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY32_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY33         0xd00300e8
#define EPON_EPON_GLB_LLID_TABLE_ENTRY33_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY33_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY34         0xd00300ec
#define EPON_EPON_GLB_LLID_TABLE_ENTRY34_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY34_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY35         0xd00300f0
#define EPON_EPON_GLB_LLID_TABLE_ENTRY35_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY35_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY36         0xd00300f4
#define EPON_EPON_GLB_LLID_TABLE_ENTRY36_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY36_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY37         0xd00300f8
#define EPON_EPON_GLB_LLID_TABLE_ENTRY37_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY37_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY38         0xd00300fc
#define EPON_EPON_GLB_LLID_TABLE_ENTRY38_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY38_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY39         0xd0030100
#define EPON_EPON_GLB_LLID_TABLE_ENTRY39_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY39_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY40         0xd0030104
#define EPON_EPON_GLB_LLID_TABLE_ENTRY40_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY40_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY41         0xd0030108
#define EPON_EPON_GLB_LLID_TABLE_ENTRY41_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY41_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY42         0xd003010c
#define EPON_EPON_GLB_LLID_TABLE_ENTRY42_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY42_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY43         0xd0030110
#define EPON_EPON_GLB_LLID_TABLE_ENTRY43_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY43_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY44         0xd0030114
#define EPON_EPON_GLB_LLID_TABLE_ENTRY44_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY44_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY45         0xd0030118
#define EPON_EPON_GLB_LLID_TABLE_ENTRY45_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY45_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY46         0xd003011c
#define EPON_EPON_GLB_LLID_TABLE_ENTRY46_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY46_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY47         0xd0030120
#define EPON_EPON_GLB_LLID_TABLE_ENTRY47_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY47_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY48         0xd0030124
#define EPON_EPON_GLB_LLID_TABLE_ENTRY48_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY48_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY49         0xd0030128
#define EPON_EPON_GLB_LLID_TABLE_ENTRY49_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY49_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY50         0xd003012c
#define EPON_EPON_GLB_LLID_TABLE_ENTRY50_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY50_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY51         0xd0030130
#define EPON_EPON_GLB_LLID_TABLE_ENTRY51_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY51_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY52         0xd0030134
#define EPON_EPON_GLB_LLID_TABLE_ENTRY52_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY52_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY53         0xd0030138
#define EPON_EPON_GLB_LLID_TABLE_ENTRY53_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY53_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY54         0xd003013c
#define EPON_EPON_GLB_LLID_TABLE_ENTRY54_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY54_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY55         0xd0030140
#define EPON_EPON_GLB_LLID_TABLE_ENTRY55_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY55_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY56         0xd0030144
#define EPON_EPON_GLB_LLID_TABLE_ENTRY56_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY56_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY57         0xd0030148
#define EPON_EPON_GLB_LLID_TABLE_ENTRY57_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY57_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY58         0xd003014c
#define EPON_EPON_GLB_LLID_TABLE_ENTRY58_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY58_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY59         0xd0030150
#define EPON_EPON_GLB_LLID_TABLE_ENTRY59_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY59_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY60         0xd0030154
#define EPON_EPON_GLB_LLID_TABLE_ENTRY60_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY60_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY61         0xd0030158
#define EPON_EPON_GLB_LLID_TABLE_ENTRY61_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY61_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY62         0xd003015c
#define EPON_EPON_GLB_LLID_TABLE_ENTRY62_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY62_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY63         0xd0030160
#define EPON_EPON_GLB_LLID_TABLE_ENTRY63_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY63_t;


#define EPON_EPON_GLB_LLID_TBL_ACC_DAT           0xd0030164
#define EPON_EPON_GLB_LLID_TBL_ACC_DAT_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t sw_index             :  6 ; /* bits 21:16 */
    ca_uint32_t mc_llid              :  1 ; /* bits 22:22 */
    ca_uint32_t op                   :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TBL_ACC_DAT_t;


#define EPON_EPON_GLB_LLID_TBL_ACC               0xd0030168
#define EPON_EPON_GLB_LLID_TBL_ACC_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t acc                  :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TBL_ACC_t;


#define EPON_EPON_GLB_LLID_TBL_ACC_STS           0xd003016c
#define EPON_EPON_GLB_LLID_TBL_ACC_STS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t status               :  3 ; /* bits 2:0 */
    ca_uint32_t rsv1                 : 29 ; /* bits 31:3 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TBL_ACC_STS_t;


#define EPON_EPON_GLB_LLID_MAPPING_CFG1          0xd0030170
#define EPON_EPON_GLB_LLID_MAPPING_CFG1_dft      0x3c3f003f

typedef volatile union {
  struct {
    ca_uint32_t fake_bcast_idx       :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t fake_bc_llid_pass    :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd2               :  8 ;
    ca_uint32_t bcast_idx            :  6 ; /* bits 21:16 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t sw_mode              :  1 ; /* bits 23:23 */
    ca_uint32_t mon_idx              :  6 ; /* bits 29:24 */
    ca_uint32_t monitor_mode         :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_MAPPING_CFG1_t;


#define EPON_EPON_GLB_LLID_MAPPING_CFG2          0xd0030174
#define EPON_EPON_GLB_LLID_MAPPING_CFG2_dft      0x00008000

typedef volatile union {
  struct {
    ca_uint32_t reflect_Nmatch_idx   :  6 ; /* bits 5:0 */
    ca_uint32_t reflect_Nmatch_mcast :  1 ; /* bits 6:6 */
    ca_uint32_t reflect_Nmatch_drop  :  1 ; /* bits 7:7 */
    ca_uint32_t reflect_match_idx    :  6 ; /* bits 13:8 */
    ca_uint32_t reflect_match_mcast  :  1 ; /* bits 14:14 */
    ca_uint32_t reflect_match_drop   :  1 ; /* bits 15:15 */
    ca_uint32_t reflect_Nmatch_mac_index :  5 ; /* bits 20:16 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t reflect_match_mac_index :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd2               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_MAPPING_CFG2_t;


#define EPON_EPON_GLB_DS_HDRA_CFG1               0xd0030178
#define EPON_EPON_GLB_DS_HDRA_CFG1_dft           0x03800000

typedef volatile union {
  struct {
    ca_uint32_t cos                  :  3 ; /* bits 2:0 */
    ca_uint32_t ldpid                :  6 ; /* bits 8:3 */
    ca_uint32_t fe_bypass            :  1 ; /* bits 9:9 */
    ca_uint32_t hdr_type             :  2 ; /* bits 11:10 */
    ca_uint32_t mcgid                :  8 ; /* bits 19:12 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t mirror               :  1 ; /* bits 21:21 */
    ca_uint32_t mark                 :  1 ; /* bits 22:22 */
    ca_uint32_t lspid                :  6 ; /* bits 28:23 */
    ca_uint32_t drop_code            :  3 ; /* bits 31:29 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_DS_HDRA_CFG1_t;


#define EPON_EPON_GLB_DS_HDRA_CFG2               0xd003017c
#define EPON_EPON_GLB_DS_HDRA_CFG2_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pol_en               :  2 ; /* bits 1:0 */
    ca_uint32_t pol_id               :  9 ; /* bits 10:2 */
    ca_uint32_t pol_grpid            :  3 ; /* bits 13:11 */
    ca_uint32_t dpq                  :  1 ; /* bits 14:14 */
    ca_uint32_t cpu_flg              :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_DS_HDRA_CFG2_t;


#define EPON_EPON_GLB_MISC_CTRL                  0xd0030180
#define EPON_EPON_GLB_MISC_CTRL_dft              0x00020023

typedef volatile union {
  struct {
    ca_uint32_t tx_burst_oen         :  1 ; /* bits 0:0 */
    ca_uint32_t tx_dis_oen           :  1 ; /* bits 1:1 */
    ca_uint32_t rsvd0                :  2 ; /* bits 3:2 */
    ca_uint32_t dis_opt_power        :  1 ; /* bits 4:4 */
    ca_uint32_t dis_opt_power_polarity :  1 ; /* bits 5:5 */
    ca_uint32_t rsvd1                : 10 ; /* bits 15:6 */
    ca_uint32_t rssi_pulse_on        :  1 ; /* bits 16:16 */
    ca_uint32_t rssi_polarity        :  1 ; /* bits 17:17 */
    ca_uint32_t txoam_rpt_replace    :  1 ; /* bits 18:18 */
    ca_uint32_t txfec_1g_on          :  1 ; /* bits 19:19 */
    ca_uint32_t txfec_1g_sel         :  1 ; /* bits 20:20 */
    ca_uint32_t rsvd2                : 10 ; /* bits 30:21 */
    ca_uint32_t llid_tbl_clr_all     :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_MISC_CTRL_t;


#define EPON_EPON_GLB_TX_SW_FRAME_HEADER         0xd0030184
#define EPON_EPON_GLB_TX_SW_FRAME_HEADER_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hdr                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_TX_SW_FRAME_HEADER_t;


#define EPON_EPON_GLB_TX_SW_FRAME_DATA_ACCESS    0xd0030188
#define EPON_EPON_GLB_TX_SW_FRAME_DATA_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_TX_SW_FRAME_DATA_ACCESS_t;


#define EPON_EPON_GLB_TX_SW_FRAME_DATA_DATA1     0xd003018c
#define EPON_EPON_GLB_TX_SW_FRAME_DATA_DATA1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_TX_SW_FRAME_DATA_DATA1_t;


#define EPON_EPON_GLB_TX_SW_FRAME_DATA_DATA0     0xd0030190
#define EPON_EPON_GLB_TX_SW_FRAME_DATA_DATA0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_TX_SW_FRAME_DATA_DATA0_t;


#define EPON_EPON_GLB_TX_SW_START                0xd0030194
#define EPON_EPON_GLB_TX_SW_START_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ready                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_TX_SW_START_t;


#define EPON_EPON_GLB_TXARB_DAT_BUF_THRESHOLD    0xd0030198
#define EPON_EPON_GLB_TXARB_DAT_BUF_THRESHOLD_dft 0x00001600

typedef volatile union {
  struct {
    ca_uint32_t lo                   :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t hi                   :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_TXARB_DAT_BUF_THRESHOLD_t;


#define EPON_EPON_GLB_TXARB_LAST_HDR_SIZE        0xd003019c
#define EPON_EPON_GLB_TXARB_LAST_HDR_SIZE_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hdr                  : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t count                : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_TXARB_LAST_HDR_SIZE_t;


#define EPON_EPON_GLB_EXTIF_INTERRUPT            0xd00301a0
#define EPON_EPON_GLB_EXTIF_INTERRUPT_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pucrpt_error_intrpt  :  1 ; /* bits 0:0 */
    ca_uint32_t pucsch_error_intrpt  :  1 ; /* bits 1:1 */
    ca_uint32_t puc_pkt_lengthERRi   :  1 ; /* bits 2:2 */
    ca_uint32_t sig_LOSSi            :  1 ; /* bits 3:3 */
    ca_uint32_t puc_miss_eop_intrpt  :  1 ; /* bits 4:4 */
    ca_uint32_t txarb_pkt_size_mismatch :  1 ; /* bits 5:5 */
    ca_uint32_t pcs_sync_1gi         :  1 ; /* bits 6:6 */
    ca_uint32_t pdc_pmac_throttle    :  1 ; /* bits 7:7 */
    ca_uint32_t rsv8                 :  1 ; /* bits 8:8 */
    ca_uint32_t rsv9                 :  1 ; /* bits 9:9 */
    ca_uint32_t rsv10                :  1 ; /* bits 10:10 */
    ca_uint32_t rsv11                :  1 ; /* bits 11:11 */
    ca_uint32_t rsv12                :  1 ; /* bits 12:12 */
    ca_uint32_t rsv13                :  1 ; /* bits 13:13 */
    ca_uint32_t rsv14                :  1 ; /* bits 14:14 */
    ca_uint32_t rsv15                :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_EXTIF_INTERRUPT_t;


#define EPON_EPON_GLB_EXTIF_INTERRUPTE           0xd00301a4
#define EPON_EPON_GLB_EXTIF_INTERRUPTE_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pucrpt_error_intrptE :  1 ; /* bits 0:0 */
    ca_uint32_t pucsch_error_intrptE :  1 ; /* bits 1:1 */
    ca_uint32_t puc_pkt_lengthERRiE  :  1 ; /* bits 2:2 */
    ca_uint32_t sig_LOSSiE           :  1 ; /* bits 3:3 */
    ca_uint32_t puc_miss_eop_intrptE :  1 ; /* bits 4:4 */
    ca_uint32_t txarb_pkt_size_mismatchE :  1 ; /* bits 5:5 */
    ca_uint32_t pcs_sync_1giE        :  1 ; /* bits 6:6 */
    ca_uint32_t pdc_pmac_throttleE   :  1 ; /* bits 7:7 */
    ca_uint32_t rsv8E                :  1 ; /* bits 8:8 */
    ca_uint32_t rsv9E                :  1 ; /* bits 9:9 */
    ca_uint32_t rsv10E               :  1 ; /* bits 10:10 */
    ca_uint32_t rsv11E               :  1 ; /* bits 11:11 */
    ca_uint32_t rsv12E               :  1 ; /* bits 12:12 */
    ca_uint32_t rsv13E               :  1 ; /* bits 13:13 */
    ca_uint32_t rsv14E               :  1 ; /* bits 14:14 */
    ca_uint32_t rsv15E               :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_EXTIF_INTERRUPTE_t;


#define EPON_EPON_GLB_PUC_PKT_LENGTH             0xd00301a8
#define EPON_EPON_GLB_PUC_PKT_LENGTH_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t received_puc_pkt_byte : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t received_puc_pkt_len : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_PUC_PKT_LENGTH_t;


#define EPON_EPON_GLB_REVISION                   0xd00301ac
#define EPON_EPON_GLB_REVISION_dft               0x20170217

typedef volatile union {
  struct {
    ca_uint32_t date                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_REVISION_t;


#define EPON_EPON_GLB_CVS_REV                    0xd00301b0
#define EPON_EPON_GLB_CVS_REV_dft                0x20161005

typedef volatile union {
  struct {
    ca_uint32_t tag                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_CVS_REV_t;


#define EPON_EPON_GLB_SW_TXPKT_CNTR              0xd00301b4
#define EPON_EPON_GLB_SW_TXPKT_CNTR_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_pktcnt            : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_SW_TXPKT_CNTR_t;


#define EPON_EPON_GLB_DAT_TXPKT_CNTR             0xd00301b8
#define EPON_EPON_GLB_DAT_TXPKT_CNTR_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_pktcnt            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_DAT_TXPKT_CNTR_t;


#define EPON_EPON_GLB_EXTENSION_TYPE_CFG         0xd00301bc
#define EPON_EPON_GLB_EXTENSION_TYPE_CFG_dft     0x8808fffe

typedef volatile union {
  struct {
    ca_uint32_t ext                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_EXTENSION_TYPE_CFG_t;


#define EPON_EPON_GLB_XGEPON_INTERRUPT           0xd00301c0
#define EPON_EPON_GLB_XGEPON_INTERRUPT_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t xgepn_xgmac          :  1 ; /* bits 8:8 */
    ca_uint32_t xgepn_xgpcs_rx       :  1 ; /* bits 9:9 */
    ca_uint32_t xgepn_xgpcs_tx       :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd2               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_XGEPON_INTERRUPT_t;


#define EPON_EPON_GLB_XGEPON_INTERRUPTE          0xd00301c4
#define EPON_EPON_GLB_XGEPON_INTERRUPTE_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t xgepn_xgmacE         :  1 ; /* bits 8:8 */
    ca_uint32_t xgepn_xgpcs_rxE      :  1 ; /* bits 9:9 */
    ca_uint32_t xgepn_xgpcs_txE      :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd2               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_XGEPON_INTERRUPTE_t;


#define EPON_EPON_GLB_SPARE_CFG                  0xd00301c8
#define EPON_EPON_GLB_SPARE_CFG_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t spare_csr            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_SPARE_CFG_t;


#define EPON_EPON_GLB_SPARE_STS                  0xd00301cc
#define EPON_EPON_GLB_SPARE_STS_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t spare_sts            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_SPARE_STS_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* epon_glb */
typedef struct {
  EPON_EPON_GLB_INTERRUPT_t                INTERRUPT;                     /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  EPON_EPON_GLB_INTERRUPTE_t               INTERRUPTE;                    /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  EPON_EPON_GLB_ONU_EPON_INTERRUPT_t       ONU_EPON_INTERRUPT;            /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  EPON_EPON_GLB_ONU_EPON_INTERRUPTE_t      ONU_EPON_INTERRUPTE;           /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  EPON_EPON_GLB_EPON_STATUS_t              EPON_STATUS;                   /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  EPON_EPON_GLB_STATIC_CFG_t               STATIC_CFG;                    /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  EPON_EPON_GLB_XGEPN_MAC_ADDR_H_t         XGEPN_MAC_ADDR_H;              /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  EPON_EPON_GLB_XGEPN_MAC_ADDR_L_t         XGEPN_MAC_ADDR_L;              /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  EPON_EPON_GLB_CORESEC10_CFG_t            CORESEC10_CFG;                 /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  EPON_EPON_GLB_XGPCS_FEC_CFG_t            XGPCS_FEC_CFG;                 /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  EPON_EPON_GLB_XGPCS_FEC_RXMODE_ST_t      XGPCS_FEC_RXMODE_ST;           /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  EPON_EPON_GLB_XGPCS_BD_pattern_fecless2_t XGPCS_BD_pattern_fecless2;     /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  EPON_EPON_GLB_XGPCS_BD_pattern_fecless1_t XGPCS_BD_pattern_fecless1;     /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  EPON_EPON_GLB_XGPCS_BD_pattern_fecless0_t XGPCS_BD_pattern_fecless0;     /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  EPON_EPON_GLB_SFI64_KSDS32_XFER_t        SFI64_KSDS32_XFER;             /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  EPON_EPON_GLB_PTP_CFG_t                  PTP_CFG;                       /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  EPON_EPON_GLB_NI_MODULE_IRQ_STATS_t      NI_MODULE_IRQ_STATS;           /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  EPON_EPON_GLB_MP_LT_RO_CTRL_t            MP_LT_RO_CTRL;                 /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  EPON_EPON_GLB_PUC_CFG0_t                 PUC_CFG0;                      /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  EPON_EPON_GLB_PUC_CFG1_t                 PUC_CFG1;                      /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  EPON_EPON_GLB_PMAC_PKT_REQ_CNT_t         PMAC_PKT_REQ_CNT;              /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  EPON_EPON_GLB_PUC_PKT_CNT_t              PUC_PKT_CNT;                   /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  EPON_EPON_GLB_PUC_BURST_CNT_t            PUC_BURST_CNT;                 /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  EPON_EPON_GLB_PDC_PKT_CNT_t              PDC_PKT_CNT;                   /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  EPON_EPON_GLB_PUC_SCHSZ_CTRL_t           PUC_SCHSZ_CTRL;                /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY0_t        LLID_TABLE_ENTRY0;             /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY1_t        LLID_TABLE_ENTRY1;             /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY2_t        LLID_TABLE_ENTRY2;             /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY3_t        LLID_TABLE_ENTRY3;             /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY4_t        LLID_TABLE_ENTRY4;             /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY5_t        LLID_TABLE_ENTRY5;             /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY6_t        LLID_TABLE_ENTRY6;             /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY7_t        LLID_TABLE_ENTRY7;             /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY8_t        LLID_TABLE_ENTRY8;             /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY9_t        LLID_TABLE_ENTRY9;             /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY10_t       LLID_TABLE_ENTRY10;            /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY11_t       LLID_TABLE_ENTRY11;            /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY12_t       LLID_TABLE_ENTRY12;            /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY13_t       LLID_TABLE_ENTRY13;            /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY14_t       LLID_TABLE_ENTRY14;            /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY15_t       LLID_TABLE_ENTRY15;            /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY16_t       LLID_TABLE_ENTRY16;            /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY17_t       LLID_TABLE_ENTRY17;            /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY18_t       LLID_TABLE_ENTRY18;            /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd44[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY19_t       LLID_TABLE_ENTRY19;            /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd45[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY20_t       LLID_TABLE_ENTRY20;            /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd46[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY21_t       LLID_TABLE_ENTRY21;            /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd47[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY22_t       LLID_TABLE_ENTRY22;            /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd48[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY23_t       LLID_TABLE_ENTRY23;            /* addr: 0x000000c0 */
  ca_uint32_t                              rsrvd49[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY24_t       LLID_TABLE_ENTRY24;            /* addr: 0x000000c4 */
  ca_uint32_t                              rsrvd50[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY25_t       LLID_TABLE_ENTRY25;            /* addr: 0x000000c8 */
  ca_uint32_t                              rsrvd51[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY26_t       LLID_TABLE_ENTRY26;            /* addr: 0x000000cc */
  ca_uint32_t                              rsrvd52[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY27_t       LLID_TABLE_ENTRY27;            /* addr: 0x000000d0 */
  ca_uint32_t                              rsrvd53[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY28_t       LLID_TABLE_ENTRY28;            /* addr: 0x000000d4 */
  ca_uint32_t                              rsrvd54[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY29_t       LLID_TABLE_ENTRY29;            /* addr: 0x000000d8 */
  ca_uint32_t                              rsrvd55[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY30_t       LLID_TABLE_ENTRY30;            /* addr: 0x000000dc */
  ca_uint32_t                              rsrvd56[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY31_t       LLID_TABLE_ENTRY31;            /* addr: 0x000000e0 */
  ca_uint32_t                              rsrvd57[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY32_t       LLID_TABLE_ENTRY32;            /* addr: 0x000000e4 */
  ca_uint32_t                              rsrvd58[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY33_t       LLID_TABLE_ENTRY33;            /* addr: 0x000000e8 */
  ca_uint32_t                              rsrvd59[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY34_t       LLID_TABLE_ENTRY34;            /* addr: 0x000000ec */
  ca_uint32_t                              rsrvd60[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY35_t       LLID_TABLE_ENTRY35;            /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd61[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY36_t       LLID_TABLE_ENTRY36;            /* addr: 0x000000f4 */
  ca_uint32_t                              rsrvd62[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY37_t       LLID_TABLE_ENTRY37;            /* addr: 0x000000f8 */
  ca_uint32_t                              rsrvd63[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY38_t       LLID_TABLE_ENTRY38;            /* addr: 0x000000fc */
  ca_uint32_t                              rsrvd64[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY39_t       LLID_TABLE_ENTRY39;            /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd65[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY40_t       LLID_TABLE_ENTRY40;            /* addr: 0x00000104 */
  ca_uint32_t                              rsrvd66[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY41_t       LLID_TABLE_ENTRY41;            /* addr: 0x00000108 */
  ca_uint32_t                              rsrvd67[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY42_t       LLID_TABLE_ENTRY42;            /* addr: 0x0000010c */
  ca_uint32_t                              rsrvd68[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY43_t       LLID_TABLE_ENTRY43;            /* addr: 0x00000110 */
  ca_uint32_t                              rsrvd69[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY44_t       LLID_TABLE_ENTRY44;            /* addr: 0x00000114 */
  ca_uint32_t                              rsrvd70[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY45_t       LLID_TABLE_ENTRY45;            /* addr: 0x00000118 */
  ca_uint32_t                              rsrvd71[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY46_t       LLID_TABLE_ENTRY46;            /* addr: 0x0000011c */
  ca_uint32_t                              rsrvd72[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY47_t       LLID_TABLE_ENTRY47;            /* addr: 0x00000120 */
  ca_uint32_t                              rsrvd73[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY48_t       LLID_TABLE_ENTRY48;            /* addr: 0x00000124 */
  ca_uint32_t                              rsrvd74[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY49_t       LLID_TABLE_ENTRY49;            /* addr: 0x00000128 */
  ca_uint32_t                              rsrvd75[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY50_t       LLID_TABLE_ENTRY50;            /* addr: 0x0000012c */
  ca_uint32_t                              rsrvd76[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY51_t       LLID_TABLE_ENTRY51;            /* addr: 0x00000130 */
  ca_uint32_t                              rsrvd77[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY52_t       LLID_TABLE_ENTRY52;            /* addr: 0x00000134 */
  ca_uint32_t                              rsrvd78[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY53_t       LLID_TABLE_ENTRY53;            /* addr: 0x00000138 */
  ca_uint32_t                              rsrvd79[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY54_t       LLID_TABLE_ENTRY54;            /* addr: 0x0000013c */
  ca_uint32_t                              rsrvd80[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY55_t       LLID_TABLE_ENTRY55;            /* addr: 0x00000140 */
  ca_uint32_t                              rsrvd81[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY56_t       LLID_TABLE_ENTRY56;            /* addr: 0x00000144 */
  ca_uint32_t                              rsrvd82[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY57_t       LLID_TABLE_ENTRY57;            /* addr: 0x00000148 */
  ca_uint32_t                              rsrvd83[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY58_t       LLID_TABLE_ENTRY58;            /* addr: 0x0000014c */
  ca_uint32_t                              rsrvd84[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY59_t       LLID_TABLE_ENTRY59;            /* addr: 0x00000150 */
  ca_uint32_t                              rsrvd85[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY60_t       LLID_TABLE_ENTRY60;            /* addr: 0x00000154 */
  ca_uint32_t                              rsrvd86[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY61_t       LLID_TABLE_ENTRY61;            /* addr: 0x00000158 */
  ca_uint32_t                              rsrvd87[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY62_t       LLID_TABLE_ENTRY62;            /* addr: 0x0000015c */
  ca_uint32_t                              rsrvd88[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY63_t       LLID_TABLE_ENTRY63;            /* addr: 0x00000160 */
  ca_uint32_t                              rsrvd89[3];                   
  EPON_EPON_GLB_LLID_TBL_ACC_DAT_t         LLID_TBL_ACC_DAT;              /* addr: 0x00000164 */
  ca_uint32_t                              rsrvd90[3];                   
  EPON_EPON_GLB_LLID_TBL_ACC_t             LLID_TBL_ACC;                  /* addr: 0x00000168 */
  ca_uint32_t                              rsrvd91[3];                   
  EPON_EPON_GLB_LLID_TBL_ACC_STS_t         LLID_TBL_ACC_STS;              /* addr: 0x0000016c */
  ca_uint32_t                              rsrvd92[3];                   
  EPON_EPON_GLB_LLID_MAPPING_CFG1_t        LLID_MAPPING_CFG1;             /* addr: 0x00000170 */
  ca_uint32_t                              rsrvd93[3];                   
  EPON_EPON_GLB_LLID_MAPPING_CFG2_t        LLID_MAPPING_CFG2;             /* addr: 0x00000174 */
  ca_uint32_t                              rsrvd94[3];                   
  EPON_EPON_GLB_DS_HDRA_CFG1_t             DS_HDRA_CFG1;                  /* addr: 0x00000178 */
  ca_uint32_t                              rsrvd95[3];                   
  EPON_EPON_GLB_DS_HDRA_CFG2_t             DS_HDRA_CFG2;                  /* addr: 0x0000017c */
  ca_uint32_t                              rsrvd96[3];                   
  EPON_EPON_GLB_MISC_CTRL_t                MISC_CTRL;                     /* addr: 0x00000180 */
  ca_uint32_t                              rsrvd97[3];                   
  EPON_EPON_GLB_TX_SW_FRAME_HEADER_t       TX_SW_FRAME_HEADER;            /* addr: 0x00000184 */
  ca_uint32_t                              rsrvd98[3];                   
  EPON_EPON_GLB_TX_SW_FRAME_DATA_ACCESS_t  TX_SW_FRAME_DATA_ACCESS;       /* addr: 0x00000188 */
  ca_uint32_t                              rsrvd99[3];                   
  EPON_EPON_GLB_TX_SW_FRAME_DATA_DATA1_t   TX_SW_FRAME_DATA_DATA1;        /* addr: 0x0000018c */
  ca_uint32_t                              rsrvd100[3];                  
  EPON_EPON_GLB_TX_SW_FRAME_DATA_DATA0_t   TX_SW_FRAME_DATA_DATA0;        /* addr: 0x00000190 */
  ca_uint32_t                              rsrvd101[3];                  
  EPON_EPON_GLB_TX_SW_START_t              TX_SW_START;                   /* addr: 0x00000194 */
  ca_uint32_t                              rsrvd102[3];                  
  EPON_EPON_GLB_TXARB_DAT_BUF_THRESHOLD_t  TXARB_DAT_BUF_THRESHOLD;       /* addr: 0x00000198 */
  ca_uint32_t                              rsrvd103[3];                  
  EPON_EPON_GLB_TXARB_LAST_HDR_SIZE_t      TXARB_LAST_HDR_SIZE;           /* addr: 0x0000019c */
  ca_uint32_t                              rsrvd104[3];                  
  EPON_EPON_GLB_EXTIF_INTERRUPT_t          EXTIF_INTERRUPT;               /* addr: 0x000001a0 */
  ca_uint32_t                              rsrvd105[3];                  
  EPON_EPON_GLB_EXTIF_INTERRUPTE_t         EXTIF_INTERRUPTE;              /* addr: 0x000001a4 */
  ca_uint32_t                              rsrvd106[3];                  
  EPON_EPON_GLB_PUC_PKT_LENGTH_t           PUC_PKT_LENGTH;                /* addr: 0x000001a8 */
  ca_uint32_t                              rsrvd107[3];                  
  EPON_EPON_GLB_REVISION_t                 REVISION;                      /* addr: 0x000001ac */
  ca_uint32_t                              rsrvd108[3];                  
  EPON_EPON_GLB_CVS_REV_t                  CVS_REV;                       /* addr: 0x000001b0 */
  ca_uint32_t                              rsrvd109[3];                  
  EPON_EPON_GLB_SW_TXPKT_CNTR_t            SW_TXPKT_CNTR;                 /* addr: 0x000001b4 */
  ca_uint32_t                              rsrvd110[3];                  
  EPON_EPON_GLB_DAT_TXPKT_CNTR_t           DAT_TXPKT_CNTR;                /* addr: 0x000001b8 */
  ca_uint32_t                              rsrvd111[3];                  
  EPON_EPON_GLB_EXTENSION_TYPE_CFG_t       EXTENSION_TYPE_CFG;            /* addr: 0x000001bc */
  ca_uint32_t                              rsrvd112[3];                  
  EPON_EPON_GLB_XGEPON_INTERRUPT_t         XGEPON_INTERRUPT;              /* addr: 0x000001c0 */
  ca_uint32_t                              rsrvd113[3];                  
  EPON_EPON_GLB_XGEPON_INTERRUPTE_t        XGEPON_INTERRUPTE;             /* addr: 0x000001c4 */
  ca_uint32_t                              rsrvd114[3];                  
  EPON_EPON_GLB_SPARE_CFG_t                SPARE_CFG;                     /* addr: 0x000001c8 */
  ca_uint32_t                              rsrvd115[3];                  
  EPON_EPON_GLB_SPARE_STS_t                SPARE_STS;                     /* addr: 0x000001cc */
} APB1_EPON_EPON_GLB_t;


/*
 * epon_mib
 */
        
#define EPON_EPON_MIB_MIB_RAM_STATUS_REG         0xd0030600
#define EPON_EPON_MIB_MIB_RAM_STATUS_REG_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ram_initdone         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_MIB_RAM_STATUS_REG_t;


#define EPON_EPON_MIB_MIB_CTL                    0xd0030604
#define EPON_EPON_MIB_MIB_CTL_dft                0x00000019

typedef volatile union {
  struct {
    ca_uint32_t ram_clr_en           :  1 ; /* bits 0:0 */
    ca_uint32_t ram_sw_initial       :  1 ; /* bits 1:1 */
    ca_uint32_t dbg_en               :  1 ; /* bits 2:2 */
    ca_uint32_t ram_init_en          :  1 ; /* bits 3:3 */
    ca_uint32_t term_dbg_en          :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_MIB_CTL_t;


#define EPON_EPON_MIB_RX_LLID_MPCP_MIB_ACC_ACCESS 0xd0030608
#define EPON_EPON_MIB_RX_LLID_MPCP_MIB_ACC_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Addr                 : 11 ; /* bits 10:0 */
    ca_uint32_t rsrvd1               : 19 ;
    ca_uint32_t rw                   :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_RX_LLID_MPCP_MIB_ACC_ACCESS_t;


#define EPON_EPON_MIB_RX_LLID_MPCP_MIB_ACC_DATA  0xd003060c
#define EPON_EPON_MIB_RX_LLID_MPCP_MIB_ACC_DATA_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_RX_LLID_MPCP_MIB_ACC_DATA_t;


#define EPON_EPON_MIB_RX_LLID_FRMCNT_MIB_ACC_ACCESS 0xd0030610
#define EPON_EPON_MIB_RX_LLID_FRMCNT_MIB_ACC_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Addr                 : 11 ; /* bits 10:0 */
    ca_uint32_t rsrvd1               : 19 ;
    ca_uint32_t rw                   :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_RX_LLID_FRMCNT_MIB_ACC_ACCESS_t;


#define EPON_EPON_MIB_RX_LLID_FRMCNT_MIB_ACC_DATA 0xd0030614
#define EPON_EPON_MIB_RX_LLID_FRMCNT_MIB_ACC_DATA_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_RX_LLID_FRMCNT_MIB_ACC_DATA_t;


#define EPON_EPON_MIB_RX_XGEPON_ETHNET_MIB_ACC_ACCESS 0xd0030618
#define EPON_EPON_MIB_RX_XGEPON_ETHNET_MIB_ACC_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Addr                 :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t rw                   :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_RX_XGEPON_ETHNET_MIB_ACC_ACCESS_t;


#define EPON_EPON_MIB_RX_XGEPON_ETHNET_MIB_ACC_DATA 0xd003061c
#define EPON_EPON_MIB_RX_XGEPON_ETHNET_MIB_ACC_DATA_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_RX_XGEPON_ETHNET_MIB_ACC_DATA_t;


#define EPON_EPON_MIB_TX_LLID_MPCP_MIB_ACC_ACCESS 0xd0030620
#define EPON_EPON_MIB_TX_LLID_MPCP_MIB_ACC_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Addr                 : 11 ; /* bits 10:0 */
    ca_uint32_t rsrvd1               : 19 ;
    ca_uint32_t rw                   :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_TX_LLID_MPCP_MIB_ACC_ACCESS_t;


#define EPON_EPON_MIB_TX_LLID_MPCP_MIB_ACC_DATA  0xd0030624
#define EPON_EPON_MIB_TX_LLID_MPCP_MIB_ACC_DATA_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_TX_LLID_MPCP_MIB_ACC_DATA_t;


#define EPON_EPON_MIB_TX_LLID_FRMCNT_MIB_ACC_ACCESS 0xd0030628
#define EPON_EPON_MIB_TX_LLID_FRMCNT_MIB_ACC_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Addr                 : 11 ; /* bits 10:0 */
    ca_uint32_t rsrvd1               : 19 ;
    ca_uint32_t rw                   :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_TX_LLID_FRMCNT_MIB_ACC_ACCESS_t;


#define EPON_EPON_MIB_TX_LLID_FRMCNT_MIB_ACC_DATA 0xd003062c
#define EPON_EPON_MIB_TX_LLID_FRMCNT_MIB_ACC_DATA_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_TX_LLID_FRMCNT_MIB_ACC_DATA_t;


#define EPON_EPON_MIB_TX_XGEPON_ETHNET_MIB_ACC_ACCESS 0xd0030630
#define EPON_EPON_MIB_TX_XGEPON_ETHNET_MIB_ACC_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Addr                 :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t rw                   :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_TX_XGEPON_ETHNET_MIB_ACC_ACCESS_t;


#define EPON_EPON_MIB_TX_XGEPON_ETHNET_MIB_ACC_DATA 0xd0030634
#define EPON_EPON_MIB_TX_XGEPON_ETHNET_MIB_ACC_DATA_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_TX_XGEPON_ETHNET_MIB_ACC_DATA_t;


#define EPON_EPON_MIB_MIB_TX_DROPCNT             0xd0030638
#define EPON_EPON_MIB_MIB_TX_DROPCNT_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_MIB_TX_DROPCNT_t;


#define EPON_EPON_MIB_MIB_RX_DROPCNT             0xd003063c
#define EPON_EPON_MIB_MIB_RX_DROPCNT_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_MIB_RX_DROPCNT_t;


#define EPON_EPON_MIB_LLID_MIB_RX_BYTECNT_HI     0xd0030640
#define EPON_EPON_MIB_LLID_MIB_RX_BYTECNT_HI_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mib_cnt              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_LLID_MIB_RX_BYTECNT_HI_t;


#define EPON_EPON_MIB_LLID_MIB_TX_BYTECNT_HI     0xd0030644
#define EPON_EPON_MIB_LLID_MIB_TX_BYTECNT_HI_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mib_cnt              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_LLID_MIB_TX_BYTECNT_HI_t;


#define EPON_EPON_MIB_XGEPN_MIB_RX_BYTECNT_HI    0xd0030648
#define EPON_EPON_MIB_XGEPN_MIB_RX_BYTECNT_HI_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mib_cnt              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_XGEPN_MIB_RX_BYTECNT_HI_t;


#define EPON_EPON_MIB_XGEPN_MIB_TX_BYTECNT_HI    0xd003064c
#define EPON_EPON_MIB_XGEPN_MIB_TX_BYTECNT_HI_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mib_cnt              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_XGEPN_MIB_TX_BYTECNT_HI_t;


#define EPON_EPON_MIB_XOFF_PKT_CNT               0xd0030650
#define EPON_EPON_MIB_XOFF_PKT_CNT_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t xoff_pkt_cnt         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_XOFF_PKT_CNT_t;


#define EPON_EPON_MIB_XON_PKT_CNT                0xd0030654
#define EPON_EPON_MIB_XON_PKT_CNT_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t xon_pkt_cnt          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_XON_PKT_CNT_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* epon_mib */
typedef struct {
  EPON_EPON_MIB_MIB_RAM_STATUS_REG_t       MIB_RAM_STATUS_REG;            /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  EPON_EPON_MIB_MIB_CTL_t                  MIB_CTL;                       /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  EPON_EPON_MIB_RX_LLID_MPCP_MIB_ACC_ACCESS_t RX_LLID_MPCP_MIB_ACC_ACCESS;   /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  EPON_EPON_MIB_RX_LLID_MPCP_MIB_ACC_DATA_t RX_LLID_MPCP_MIB_ACC_DATA;     /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  EPON_EPON_MIB_RX_LLID_FRMCNT_MIB_ACC_ACCESS_t RX_LLID_FRMCNT_MIB_ACC_ACCESS; /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  EPON_EPON_MIB_RX_LLID_FRMCNT_MIB_ACC_DATA_t RX_LLID_FRMCNT_MIB_ACC_DATA;   /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  EPON_EPON_MIB_RX_XGEPON_ETHNET_MIB_ACC_ACCESS_t RX_XGEPON_ETHNET_MIB_ACC_ACCESS; /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  EPON_EPON_MIB_RX_XGEPON_ETHNET_MIB_ACC_DATA_t RX_XGEPON_ETHNET_MIB_ACC_DATA; /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  EPON_EPON_MIB_TX_LLID_MPCP_MIB_ACC_ACCESS_t TX_LLID_MPCP_MIB_ACC_ACCESS;   /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  EPON_EPON_MIB_TX_LLID_MPCP_MIB_ACC_DATA_t TX_LLID_MPCP_MIB_ACC_DATA;     /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  EPON_EPON_MIB_TX_LLID_FRMCNT_MIB_ACC_ACCESS_t TX_LLID_FRMCNT_MIB_ACC_ACCESS; /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  EPON_EPON_MIB_TX_LLID_FRMCNT_MIB_ACC_DATA_t TX_LLID_FRMCNT_MIB_ACC_DATA;   /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  EPON_EPON_MIB_TX_XGEPON_ETHNET_MIB_ACC_ACCESS_t TX_XGEPON_ETHNET_MIB_ACC_ACCESS; /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  EPON_EPON_MIB_TX_XGEPON_ETHNET_MIB_ACC_DATA_t TX_XGEPON_ETHNET_MIB_ACC_DATA; /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  EPON_EPON_MIB_MIB_TX_DROPCNT_t           MIB_TX_DROPCNT;                /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  EPON_EPON_MIB_MIB_RX_DROPCNT_t           MIB_RX_DROPCNT;                /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  EPON_EPON_MIB_LLID_MIB_RX_BYTECNT_HI_t   LLID_MIB_RX_BYTECNT_HI;        /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  EPON_EPON_MIB_LLID_MIB_TX_BYTECNT_HI_t   LLID_MIB_TX_BYTECNT_HI;        /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  EPON_EPON_MIB_XGEPN_MIB_RX_BYTECNT_HI_t  XGEPN_MIB_RX_BYTECNT_HI;       /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  EPON_EPON_MIB_XGEPN_MIB_TX_BYTECNT_HI_t  XGEPN_MIB_TX_BYTECNT_HI;       /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  EPON_EPON_MIB_XOFF_PKT_CNT_t             XOFF_PKT_CNT;                  /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  EPON_EPON_MIB_XON_PKT_CNT_t              XON_PKT_CNT;                   /* addr: 0x00000054 */
} APB1_EPON_EPON_MIB_t;


/*
 * ONU_EPON
 */
        
#define EPON_ONU_EPON_PCS_CFG                    0xd0030800
#define EPON_ONU_EPON_PCS_CFG_dft                0x00235c08

typedef volatile union {
  struct {
    ca_uint32_t pcs_loop_cnt_hi      :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               :  6 ;
    ca_uint32_t pon_10balign_en      :  1 ; /* bits 10:10 */
    ca_uint32_t pon_fec_sync_en      :  1 ; /* bits 11:11 */
    ca_uint32_t pcs_loop_cnt_lo      :  4 ; /* bits 15:12 */
    ca_uint32_t an_ps1               :  1 ; /* bits 16:16 */
    ca_uint32_t an_ps2               :  1 ; /* bits 17:17 */
    ca_uint32_t an_rf1               :  1 ; /* bits 18:18 */
    ca_uint32_t an_rf2               :  1 ; /* bits 19:19 */
    ca_uint32_t restart_auto_neg     :  1 ; /* bits 20:20 */
    ca_uint32_t dis_auto_neg         :  1 ; /* bits 21:21 */
    ca_uint32_t rsrvd2               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PCS_CFG_t;


#define EPON_ONU_EPON_PCS_Status_Reg             0xd0030804
#define EPON_ONU_EPON_PCS_Status_Reg_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t An_PS1               :  1 ; /* bits 1:1 */
    ca_uint32_t An_PS2               :  1 ; /* bits 2:2 */
    ca_uint32_t An_RF1               :  1 ; /* bits 3:3 */
    ca_uint32_t An_RF2               :  1 ; /* bits 4:4 */
    ca_uint32_t Link_partner_duplex  :  1 ; /* bits 5:5 */
    ca_uint32_t An_done              :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd2               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PCS_Status_Reg_t;


#define EPON_ONU_EPON_FEC_CFG                    0xd0030808
#define EPON_ONU_EPON_FEC_CFG_dft                0x0000c160

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t tx_1st_preamble_mode :  1 ; /* bits 5:5 */
    ca_uint32_t tx_rep_mode          :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t tfec_rep             :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd3               :  3 ;
    ca_uint32_t tx_ipg_adj           :  3 ; /* bits 14:12 */
    ca_uint32_t tx_fec8B             :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd4               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_FEC_CFG_t;


#define EPON_ONU_EPON_FEC_TX_ERRINJ              0xd003080c
#define EPON_ONU_EPON_FEC_TX_ERRINJ_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t err_sfec             :  1 ; /* bits 0:0 */
    ca_uint32_t err_data             :  1 ; /* bits 1:1 */
    ca_uint32_t err_tfec1            :  1 ; /* bits 2:2 */
    ca_uint32_t err_prty             :  1 ; /* bits 3:3 */
    ca_uint32_t err_tfec2            :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t err_bytecnt          :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t err_bitcnt           :  2 ; /* bits 15:14 */
    ca_uint32_t err_pktcnt           :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd3               :  2 ;
    ca_uint32_t err_burst            :  1 ; /* bits 26:26 */
    ca_uint32_t err_sel              :  1 ; /* bits 27:27 */
    ca_uint32_t rsrvd4               :  3 ;
    ca_uint32_t err_en               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_FEC_TX_ERRINJ_t;


#define EPON_ONU_EPON_FEC_CTRL                   0xd0030810
#define EPON_ONU_EPON_FEC_CTRL_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t fec_decode_enable    :  1 ; /* bits 0:0 */
    ca_uint32_t fec_encode_enable    :  1 ; /* bits 1:1 */
    ca_uint32_t fec_rx_clr           :  1 ; /* bits 2:2 */
    ca_uint32_t fec_tx_clr           :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t rsv7                 :  1 ; /* bits 7:7 */
    ca_uint32_t non_FEC_mode         :  1 ; /* bits 8:8 */
    ca_uint32_t rsv1                 :  1 ; /* bits 9:9 */
    ca_uint32_t rsv2                 :  1 ; /* bits 10:10 */
    ca_uint32_t rsv3                 :  1 ; /* bits 11:11 */
    ca_uint32_t rsv4                 :  1 ; /* bits 12:12 */
    ca_uint32_t rsv5                 :  1 ; /* bits 13:13 */
    ca_uint32_t fec_rx_ctrl          : 11 ; /* bits 24:14 */
    ca_uint32_t rsrvd2               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_FEC_CTRL_t;


#define EPON_ONU_EPON_TX_RCC_CNT                 0xd0030814
#define EPON_ONU_EPON_TX_RCC_CNT_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_TX_RCC_CNT_t;


#define EPON_ONU_EPON_FEC_MISC_STATUS            0xd0030818
#define EPON_ONU_EPON_FEC_MISC_STATUS_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pack_full            :  1 ; /* bits 0:0 */
    ca_uint32_t prty_full            :  1 ; /* bits 1:1 */
    ca_uint32_t cmd_full             :  1 ; /* bits 2:2 */
    ca_uint32_t cwb_full             :  1 ; /* bits 3:3 */
    ca_uint32_t pipe_stall           :  1 ; /* bits 4:4 */
    ca_uint32_t los_tfec1            :  1 ; /* bits 5:5 */
    ca_uint32_t los_tfec2            :  1 ; /* bits 6:6 */
    ca_uint32_t fec_errors           :  4 ; /* bits 10:7 */
    ca_uint32_t fec_uncorr           :  1 ; /* bits 11:11 */
    ca_uint32_t fec_dacor_ack_q      :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t fec_pkt_st           :  4 ; /* bits 19:16 */
    ca_uint32_t rsrvd2               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_FEC_MISC_STATUS_t;


#define EPON_ONU_EPON_FEC_Counter_Control        0xd003081c
#define EPON_ONU_EPON_FEC_Counter_Control_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t FEC_CNTR_rd_clr_mode :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_FEC_Counter_Control_t;


#define EPON_ONU_EPON_FEC_Block_Correctable_Error_Counter 0xd0030820
#define EPON_ONU_EPON_FEC_Block_Correctable_Error_Counter_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t FEC_RCNT             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_FEC_Block_Correctable_Error_Counter_t;


#define EPON_ONU_EPON_FEC_Block_Uncorrectable_Error_Counter 0xd0030824
#define EPON_ONU_EPON_FEC_Block_Uncorrectable_Error_Counter_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t FEC_UCNT             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_FEC_Block_Uncorrectable_Error_Counter_t;


#define EPON_ONU_EPON_FEC_Block_No_Error_Counter 0xd0030828
#define EPON_ONU_EPON_FEC_Block_No_Error_Counter_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t FEC_NOERR            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_FEC_Block_No_Error_Counter_t;


#define EPON_ONU_EPON_FEC_Block_Counter          0xd003082c
#define EPON_ONU_EPON_FEC_Block_Counter_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t FEC_BLK_CNT          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_FEC_Block_Counter_t;


#define EPON_ONU_EPON_FEC_Corr_Byte_Counter      0xd0030830
#define EPON_ONU_EPON_FEC_Corr_Byte_Counter_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t FEC_CORR_BYTE_CNT    : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_FEC_Corr_Byte_Counter_t;


#define EPON_ONU_EPON_TXCTRL                     0xd0030834
#define EPON_ONU_EPON_TXCTRL_dft                 0x0001c000

typedef volatile union {
  struct {
    ca_uint32_t TX_EN                :  1 ; /* bits 0:0 */
    ca_uint32_t reserved_1           :  1 ; /* bits 1:1 */
    ca_uint32_t reserved_2           :  1 ; /* bits 2:2 */
    ca_uint32_t drain                :  1 ; /* bits 3:3 */
    ca_uint32_t reserved_4           :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t reserved_6           :  1 ; /* bits 6:6 */
    ca_uint32_t reserved_7           :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd2               :  4 ;
    ca_uint32_t laser_delay          :  6 ; /* bits 17:12 */
    ca_uint32_t laser_burst_polarity :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t ipg_sel              :  2 ; /* bits 21:20 */
    ca_uint32_t crc8_calculation_order_select :  2 ; /* bits 23:22 */
    ca_uint32_t bf                   :  1 ; /* bits 24:24 */
    ca_uint32_t disable_crc32_re_generation :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd4               :  4 ;
    ca_uint32_t max_pkt_size_limit   :  1 ; /* bits 30:30 */
    ca_uint32_t tx_pause_enable      :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_TXCTRL_t;


#define EPON_ONU_EPON_MAXPKTSIZE                 0xd0030838
#define EPON_ONU_EPON_MAXPKTSIZE_dft             0x30003000

typedef volatile union {
  struct {
    ca_uint32_t tx_max_pkt_size      : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t rx_max_pkt_size      : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_MAXPKTSIZE_t;


#define EPON_ONU_EPON_TXCTRL_FFCFG               0xd003083c
#define EPON_ONU_EPON_TXCTRL_FFCFG_dft           0xc1f44008

typedef volatile union {
  struct {
    ca_uint32_t sync_fifo_low_threshold :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t async_fifo_low_threshold :  4 ; /* bits 15:12 */
    ca_uint32_t sync_fifo_high_threshold :  9 ; /* bits 24:16 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t async_fifo_high_threshold :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_TXCTRL_FFCFG_t;


#define EPON_ONU_EPON_TXMAC_CFG                  0xd0030840
#define EPON_ONU_EPON_TXMAC_CFG_dft              0x000a0212

typedef volatile union {
  struct {
    ca_uint32_t ptp_lsr_on_adj       :  8 ; /* bits 7:0 */
    ca_uint32_t win_dly_adj          :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t lsr_on_adj           :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd2               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_TXMAC_CFG_t;


#define EPON_ONU_EPON_PACKET_DRAIN_CNT           0xd0030844
#define EPON_ONU_EPON_PACKET_DRAIN_CNT_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt_drain_cnt        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PACKET_DRAIN_CNT_t;


#define EPON_ONU_EPON_TX_CRCERR_CNT              0xd0030848
#define EPON_ONU_EPON_TX_CRCERR_CNT_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t txcrcErrCnt          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_TX_CRCERR_CNT_t;


#define EPON_ONU_EPON_OUTPCS_CNT                 0xd003084c
#define EPON_ONU_EPON_OUTPCS_CNT_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t is                   : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_OUTPCS_CNT_t;


#define EPON_ONU_EPON_OUTMAC_CNT                 0xd0030850
#define EPON_ONU_EPON_OUTMAC_CNT_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t is                   : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_OUTMAC_CNT_t;


#define EPON_ONU_EPON_OUTLSR_CNT                 0xd0030854
#define EPON_ONU_EPON_OUTLSR_CNT_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t is                   : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_OUTLSR_CNT_t;


#define EPON_ONU_EPON_DATAPATH_STATUS            0xd0030858
#define EPON_ONU_EPON_DATAPATH_STATUS_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t txpath1              :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd2               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_DATAPATH_STATUS_t;


#define EPON_ONU_EPON_RCC_CNT                    0xd003085c
#define EPON_ONU_EPON_RCC_CNT_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_RCC_CNT_t;


#define EPON_ONU_EPON_PTP_ASYM_DELAY             0xd0030860
#define EPON_ONU_EPON_PTP_ASYM_DELAY_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t correction           : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PTP_ASYM_DELAY_t;


#define EPON_ONU_EPON_PTP_EG_TIME_LATCH          0xd0030864
#define EPON_ONU_EPON_PTP_EG_TIME_LATCH_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t local_time           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PTP_EG_TIME_LATCH_t;


#define EPON_ONU_EPON_PTP_EG_TIMES_LATCH1        0xd0030868
#define EPON_ONU_EPON_PTP_EG_TIMES_LATCH1_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t local_time1          : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PTP_EG_TIMES_LATCH1_t;


#define EPON_ONU_EPON_PTP_EG_TIMES_LATCH0        0xd003086c
#define EPON_ONU_EPON_PTP_EG_TIMES_LATCH0_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t local_time0          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PTP_EG_TIMES_LATCH0_t;


#define EPON_ONU_EPON_PTP_EG_LATCH               0xd0030870
#define EPON_ONU_EPON_PTP_EG_LATCH_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sqid                 : 16 ; /* bits 15:0 */
    ca_uint32_t message_type         :  2 ; /* bits 17:16 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PTP_EG_LATCH_t;


#define EPON_ONU_EPON_PTP_PIPE_EMPTY             0xd0030874
#define EPON_ONU_EPON_PTP_PIPE_EMPTY_dft         0x000003f0

typedef volatile union {
  struct {
    ca_uint32_t en                   : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PTP_PIPE_EMPTY_t;


#define EPON_ONU_EPON_DBG_SEL                    0xd0030878
#define EPON_ONU_EPON_DBG_SEL_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dbg_sel              :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t dbg_sel_aes          :  5 ; /* bits 12:8 */
    ca_uint32_t dbg_sel_fec          :  3 ; /* bits 15:13 */
    ca_uint32_t rsrvd2               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_DBG_SEL_t;


#define EPON_ONU_EPON_DBG_OUT                    0xd003087c
#define EPON_ONU_EPON_DBG_OUT_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dbg_out              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_DBG_OUT_t;


#define EPON_ONU_EPON_FF_STS                     0xd0030880
#define EPON_ONU_EPON_FF_STS_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t asyncff_full         :  1 ; /* bits 0:0 */
    ca_uint32_t asyncff_empty        :  1 ; /* bits 1:1 */
    ca_uint32_t syncff_full          :  1 ; /* bits 2:2 */
    ca_uint32_t syncff_empty         :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_FF_STS_t;


#define EPON_ONU_EPON_SPARE                      0xd0030884
#define EPON_ONU_EPON_SPARE_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cfg                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_SPARE_t;


#define EPON_ONU_EPON_RSVR                       0xd0030888
#define EPON_ONU_EPON_RSVR_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t val                  :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_RSVR_t;


#define EPON_ONU_EPON_RXCTRL                     0xd003088c
#define EPON_ONU_EPON_RXCTRL_dft                 0x0c002100

typedef volatile union {
  struct {
    ca_uint32_t RX_EN                :  1 ; /* bits 0:0 */
    ca_uint32_t rx_pause_enable      :  1 ; /* bits 1:1 */
    ca_uint32_t mpcp_to_cpu          :  1 ; /* bits 2:2 */
    ca_uint32_t ipg_cnt              :  3 ; /* bits 5:3 */
    ca_uint32_t gmii                 :  1 ; /* bits 6:6 */
    ca_uint32_t sfd_mode2            :  1 ; /* bits 7:7 */
    ca_uint32_t max_mtu_tag_en       :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t disable_crc8_checking :  1 ; /* bits 10:10 */
    ca_uint32_t drop_mask            : 11 ; /* bits 21:11 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t dis_bypass_extn      :  1 ; /* bits 23:23 */
    ca_uint32_t dis_bypass_oam       :  1 ; /* bits 24:24 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t check_da_mac         :  1 ; /* bits 26:26 */
    ca_uint32_t check_mp_length      :  1 ; /* bits 27:27 */
    ca_uint32_t rsrvd4               :  3 ;
    ca_uint32_t bypass               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_RXCTRL_t;


#define EPON_ONU_EPON_RX_MONITOR                 0xd0030890
#define EPON_ONU_EPON_RX_MONITOR_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mp_discovery_cnt     :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_RX_MONITOR_t;


#define EPON_ONU_EPON_RXMAC_CFG                  0xd0030894
#define EPON_ONU_EPON_RXMAC_CFG_dft              0x00ffff40

typedef volatile union {
  struct {
    ca_uint32_t filtering_threshold  :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t mtu_tag_pattern      : 16 ; /* bits 23:8 */
    ca_uint32_t rsrvd2               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_RXMAC_CFG_t;


#define EPON_ONU_EPON_RXMAC_EXTENSION_CFG        0xd0030898
#define EPON_ONU_EPON_RXMAC_EXTENSION_CFG_dft    0x0000fffe

typedef volatile union {
  struct {
    ca_uint32_t opcode               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_RXMAC_EXTENSION_CFG_t;


#define EPON_ONU_EPON_RXMAC_EXTENSION_OUI        0xd003089c
#define EPON_ONU_EPON_RXMAC_EXTENSION_OUI_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t oui                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t check_oui            :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd2               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_RXMAC_EXTENSION_OUI_t;


#define EPON_ONU_EPON_RXMAC_EXTENSION_DA1        0xd00308a0
#define EPON_ONU_EPON_RXMAC_EXTENSION_DA1_dft    0x00000180

typedef volatile union {
  struct {
    ca_uint32_t extda1               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_RXMAC_EXTENSION_DA1_t;


#define EPON_ONU_EPON_RXMAC_EXTENSION_DA0        0xd00308a4
#define EPON_ONU_EPON_RXMAC_EXTENSION_DA0_dft    0xc2000001

typedef volatile union {
  struct {
    ca_uint32_t extda0               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_RXMAC_EXTENSION_DA0_t;


#define EPON_ONU_EPON_DATAPATH_BYPASS            0xd00308a8
#define EPON_ONU_EPON_DATAPATH_BYPASS_dft        0x00000026

typedef volatile union {
  struct {
    ca_uint32_t rxpath_bypass        :  4 ; /* bits 3:0 */
    ca_uint32_t txpath_bypass        :  5 ; /* bits 8:4 */
    ca_uint32_t rxpath_sw_mode       :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t fec_tx_delay_en      :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd2               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_DATAPATH_BYPASS_t;


#define EPON_ONU_EPON_FEC_DEFINE_PKTSIZE         0xd00308ac
#define EPON_ONU_EPON_FEC_DEFINE_PKTSIZE_dft     0x00032608

typedef volatile union {
  struct {
    ca_uint32_t max_pkt_size         : 12 ; /* bits 11:0 */
    ca_uint32_t min_pkt_size         : 12 ; /* bits 23:12 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_FEC_DEFINE_PKTSIZE_t;


#define EPON_ONU_EPON_FEC_DEFINE_LATENCY         0xd00308b0
#define EPON_ONU_EPON_FEC_DEFINE_LATENCY_dft     0x0014c608

typedef volatile union {
  struct {
    ca_uint32_t pckt_latency         : 12 ; /* bits 11:0 */
    ca_uint32_t fdec_latency         :  9 ; /* bits 20:12 */
    ca_uint32_t rsrvd1               : 11 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_FEC_DEFINE_LATENCY_t;


#define EPON_ONU_EPON_AES_MODE_CTL               0xd00308b4
#define EPON_ONU_EPON_AES_MODE_CTL_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t CntDiff              :  8 ; /* bits 7:0 */
    ca_uint32_t CntIncDec            :  1 ; /* bits 8:8 */
    ca_uint32_t tx_CntDiff           :  8 ; /* bits 16:9 */
    ca_uint32_t tx_CntIncDec         :  1 ; /* bits 17:17 */
    ca_uint32_t rx_enc_en_cnt_clr    :  1 ; /* bits 18:18 */
    ca_uint32_t tx_port_encrypt_en   :  1 ; /* bits 19:19 */
    ca_uint32_t rx_enc_en_cnt_lmt    :  3 ; /* bits 22:20 */
    ca_uint32_t tx_ReverseCrc8En     :  1 ; /* bits 23:23 */
    ca_uint32_t tx_ReverseCrc8Out    :  1 ; /* bits 24:24 */
    ca_uint32_t tx_crc8_gen_disable  :  1 ; /* bits 25:25 */
    ca_uint32_t port_encrypt_index_sel :  1 ; /* bits 26:26 */
    ca_uint32_t csr_port_encrypt_index :  1 ; /* bits 27:27 */
    ca_uint32_t tx_port_decryptonly_en :  1 ; /* bits 28:28 */
    ca_uint32_t AesModeSel           :  3 ; /* bits 31:29 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_AES_MODE_CTL_t;


#define EPON_ONU_EPON_UC_KEY03                   0xd00308b8
#define EPON_ONU_EPON_UC_KEY03_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key03                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_UC_KEY03_t;


#define EPON_ONU_EPON_UC_KEY02                   0xd00308bc
#define EPON_ONU_EPON_UC_KEY02_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key02                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_UC_KEY02_t;


#define EPON_ONU_EPON_UC_KEY01                   0xd00308c0
#define EPON_ONU_EPON_UC_KEY01_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key01                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_UC_KEY01_t;


#define EPON_ONU_EPON_UC_KEY00                   0xd00308c4
#define EPON_ONU_EPON_UC_KEY00_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key00                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_UC_KEY00_t;


#define EPON_ONU_EPON_UC_KEY13                   0xd00308c8
#define EPON_ONU_EPON_UC_KEY13_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key13                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_UC_KEY13_t;


#define EPON_ONU_EPON_UC_KEY12                   0xd00308cc
#define EPON_ONU_EPON_UC_KEY12_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key12                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_UC_KEY12_t;


#define EPON_ONU_EPON_UC_KEY11                   0xd00308d0
#define EPON_ONU_EPON_UC_KEY11_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key11                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_UC_KEY11_t;


#define EPON_ONU_EPON_UC_KEY10                   0xd00308d4
#define EPON_ONU_EPON_UC_KEY10_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key10                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_UC_KEY10_t;


#define EPON_ONU_EPON_PKT_MON03                  0xd00308d8
#define EPON_ONU_EPON_PKT_MON03_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t recv_pkt_r3          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PKT_MON03_t;


#define EPON_ONU_EPON_PKT_MON02                  0xd00308dc
#define EPON_ONU_EPON_PKT_MON02_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t recv_pkt_r2          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PKT_MON02_t;


#define EPON_ONU_EPON_PKT_MON01                  0xd00308e0
#define EPON_ONU_EPON_PKT_MON01_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t recv_pkt_r1          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PKT_MON01_t;


#define EPON_ONU_EPON_PKT_MON00                  0xd00308e4
#define EPON_ONU_EPON_PKT_MON00_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t recv_pkt_r0          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PKT_MON00_t;


#define EPON_ONU_EPON_PKT_MON13                  0xd00308e8
#define EPON_ONU_EPON_PKT_MON13_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t decrypt_pkt_r3       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PKT_MON13_t;


#define EPON_ONU_EPON_PKT_MON12                  0xd00308ec
#define EPON_ONU_EPON_PKT_MON12_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t decrypt_pkt_r2       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PKT_MON12_t;


#define EPON_ONU_EPON_PKT_MON11                  0xd00308f0
#define EPON_ONU_EPON_PKT_MON11_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t decrypt_pkt_r1       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PKT_MON11_t;


#define EPON_ONU_EPON_PKT_MON10                  0xd00308f4
#define EPON_ONU_EPON_PKT_MON10_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t decrypt_pkt_r0       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PKT_MON10_t;


#define EPON_ONU_EPON_PKT_MON2                   0xd00308f8
#define EPON_ONU_EPON_PKT_MON2_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t last_rx_key_index    :  1 ; /* bits 0:0 */
    ca_uint32_t RCC_b0               :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  6 ;
    ca_uint32_t rx_aes_flag          :  8 ; /* bits 15:8 */
    ca_uint32_t key_ind_tog_cnt      :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd2               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PKT_MON2_t;


#define EPON_ONU_EPON_PKT_MON31                  0xd00308fc
#define EPON_ONU_EPON_PKT_MON31_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mpcp_cnt_recode_err1 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PKT_MON31_t;


#define EPON_ONU_EPON_PKT_MON30                  0xd0030900
#define EPON_ONU_EPON_PKT_MON30_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mpcp_cnt_recode_err0 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PKT_MON30_t;


#define EPON_ONU_EPON_KEYREQUEST_OAM_CNT         0xd0030904
#define EPON_ONU_EPON_KEYREQUEST_OAM_CNT_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t keyrequest_oam_cnt   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_KEYREQUEST_OAM_CNT_t;


#define EPON_ONU_EPON_AES_DBG_CNT0               0xd0030908
#define EPON_ONU_EPON_AES_DBG_CNT0_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_AES_DBG_CNT0_t;


#define EPON_ONU_EPON_AES_DBG_GOOD_CNT0          0xd003090c
#define EPON_ONU_EPON_AES_DBG_GOOD_CNT0_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_AES_DBG_GOOD_CNT0_t;


#define EPON_ONU_EPON_AES_DBG_CNT1               0xd0030910
#define EPON_ONU_EPON_AES_DBG_CNT1_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_AES_DBG_CNT1_t;


#define EPON_ONU_EPON_AES_DBG_GOOD_CNT1          0xd0030914
#define EPON_ONU_EPON_AES_DBG_GOOD_CNT1_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_AES_DBG_GOOD_CNT1_t;


#define EPON_ONU_EPON_UC_TX_KEY03                0xd0030918
#define EPON_ONU_EPON_UC_TX_KEY03_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key03                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_UC_TX_KEY03_t;


#define EPON_ONU_EPON_UC_TX_KEY02                0xd003091c
#define EPON_ONU_EPON_UC_TX_KEY02_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key02                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_UC_TX_KEY02_t;


#define EPON_ONU_EPON_UC_TX_KEY01                0xd0030920
#define EPON_ONU_EPON_UC_TX_KEY01_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key01                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_UC_TX_KEY01_t;


#define EPON_ONU_EPON_UC_TX_KEY00                0xd0030924
#define EPON_ONU_EPON_UC_TX_KEY00_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key00                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_UC_TX_KEY00_t;


#define EPON_ONU_EPON_UC_TX_KEY13                0xd0030928
#define EPON_ONU_EPON_UC_TX_KEY13_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key13                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_UC_TX_KEY13_t;


#define EPON_ONU_EPON_UC_TX_KEY12                0xd003092c
#define EPON_ONU_EPON_UC_TX_KEY12_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key12                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_UC_TX_KEY12_t;


#define EPON_ONU_EPON_UC_TX_KEY11                0xd0030930
#define EPON_ONU_EPON_UC_TX_KEY11_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key11                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_UC_TX_KEY11_t;


#define EPON_ONU_EPON_UC_TX_KEY10                0xd0030934
#define EPON_ONU_EPON_UC_TX_KEY10_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key10                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_UC_TX_KEY10_t;


#define EPON_ONU_EPON_UC_TX_KEY_CTRL             0xd0030938
#define EPON_ONU_EPON_UC_TX_KEY_CTRL_dft         0x00000003

typedef volatile union {
  struct {
    ca_uint32_t tx_key_sel           :  1 ; /* bits 0:0 */
    ca_uint32_t tx_rcc_b0_sel        :  1 ; /* bits 1:1 */
    ca_uint32_t tx_pkt_ts_sel        :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_UC_TX_KEY_CTRL_t;


#define EPON_ONU_EPON_AES_CHURNING_CTRL          0xd003093c
#define EPON_ONU_EPON_AES_CHURNING_CTRL_dft      0x00000680

typedef volatile union {
  struct {
    ca_uint32_t enable_decryption_function_churning_or_AES :  1 ; /* bits 0:0 */
    ca_uint32_t enable_single_de_churning_function :  1 ; /* bits 1:1 */
    ca_uint32_t reverse_bit_order_of_random_generated_key :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t key_rdout_sel        :  1 ; /* bits 5:5 */
    ca_uint32_t revser_sel           :  1 ; /* bits 6:6 */
    ca_uint32_t HW_key_mode          :  1 ; /* bits 7:7 */
    ca_uint32_t rcc_correct_dis      :  1 ; /* bits 8:8 */
    ca_uint32_t oam_enc_dis          :  1 ; /* bits 9:9 */
    ca_uint32_t mp_enc_dis           :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd2               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_AES_CHURNING_CTRL_t;


#define EPON_ONU_EPON_CHURN_CONFIG_CONTROL       0xd0030940
#define EPON_ONU_EPON_CHURN_CONFIG_CONTROL_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t select_sw_key_as_decryption_key :  1 ; /* bits 3:3 */
    ca_uint32_t enable_Transmit_churning_OAM :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t SW_sel               :  1 ; /* bits 7:7 */
    ca_uint32_t key_sel_mode         :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd3               :  6 ;
    ca_uint32_t rsv15                :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd4               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_CHURN_CONFIG_CONTROL_t;


#define EPON_ONU_EPON_MISC_CFG                   0xd0030944
#define EPON_ONU_EPON_MISC_CFG_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t glb_pon_aes_disable  :  1 ; /* bits 0:0 */
    ca_uint32_t dpoe_dec_iv_sel      :  1 ; /* bits 1:1 */
    ca_uint32_t dpoe_key_mem_sel     :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_MISC_CFG_t;


#define EPON_ONU_EPON_SLD_ERR_CNT                0xd0030948
#define EPON_ONU_EPON_SLD_ERR_CNT_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sld_cnt              : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_SLD_ERR_CNT_t;


#define EPON_ONU_EPON_CRC8_ERR_CNT               0xd003094c
#define EPON_ONU_EPON_CRC8_ERR_CNT_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t crc8e_cnt            : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_CRC8_ERR_CNT_t;


#define EPON_ONU_EPON_IPG_DROP_CNT               0xd0030950
#define EPON_ONU_EPON_IPG_DROP_CNT_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ipg_drop_cnt         : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_IPG_DROP_CNT_t;


#define EPON_ONU_EPON_MISC                       0xd0030954
#define EPON_ONU_EPON_MISC_dft                   0x00000002

typedef volatile union {
  struct {
    ca_uint32_t cnt_op_mode          :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_MISC_t;


#define EPON_ONU_EPON_RXCTRL_STS                 0xd0030958
#define EPON_ONU_EPON_RXCTRL_STS_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t drop_short_cnt       :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_RXCTRL_STS_t;


#define EPON_ONU_EPON_AES_DEC_LLID_INDEX_0       0xd003095c
#define EPON_ONU_EPON_AES_DEC_LLID_INDEX_0_STRIDE 4
#define EPON_ONU_EPON_AES_DEC_LLID_INDEX_0_COUNT 8
#define EPON_ONU_EPON_AES_DEC_LLID_INDEX_0_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t entry                : 20 ; /* bits 19:0 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_AES_DEC_LLID_INDEX_0_t;

                            
#define EPON_ONU_EPON_AES_DEC_KEY_TBL_ACCESS     0xd003097c
#define EPON_ONU_EPON_AES_DEC_KEY_TBL_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_AES_DEC_KEY_TBL_ACCESS_t;


#define EPON_ONU_EPON_AES_DEC_KEY_TBL_DATA3      0xd0030980
#define EPON_ONU_EPON_AES_DEC_KEY_TBL_DATA3_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_AES_DEC_KEY_TBL_DATA3_t;


#define EPON_ONU_EPON_AES_DEC_KEY_TBL_DATA2      0xd0030984
#define EPON_ONU_EPON_AES_DEC_KEY_TBL_DATA2_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_AES_DEC_KEY_TBL_DATA2_t;


#define EPON_ONU_EPON_AES_DEC_KEY_TBL_DATA1      0xd0030988
#define EPON_ONU_EPON_AES_DEC_KEY_TBL_DATA1_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_AES_DEC_KEY_TBL_DATA1_t;


#define EPON_ONU_EPON_AES_DEC_KEY_TBL_DATA0      0xd003098c
#define EPON_ONU_EPON_AES_DEC_KEY_TBL_DATA0_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_AES_DEC_KEY_TBL_DATA0_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* ONU_EPON */
typedef struct {
  EPON_ONU_EPON_PCS_CFG_t                  PCS_CFG;                       /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  EPON_ONU_EPON_PCS_Status_Reg_t           PCS_Status_Reg;                /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  EPON_ONU_EPON_FEC_CFG_t                  FEC_CFG;                       /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  EPON_ONU_EPON_FEC_TX_ERRINJ_t            FEC_TX_ERRINJ;                 /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  EPON_ONU_EPON_FEC_CTRL_t                 FEC_CTRL;                      /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  EPON_ONU_EPON_TX_RCC_CNT_t               TX_RCC_CNT;                    /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  EPON_ONU_EPON_FEC_MISC_STATUS_t          FEC_MISC_STATUS;               /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  EPON_ONU_EPON_FEC_Counter_Control_t      FEC_Counter_Control;           /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  EPON_ONU_EPON_FEC_Block_Correctable_Error_Counter_t FEC_Block_Correctable_Error_Counter; /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  EPON_ONU_EPON_FEC_Block_Uncorrectable_Error_Counter_t FEC_Block_Uncorrectable_Error_Counter; /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  EPON_ONU_EPON_FEC_Block_No_Error_Counter_t FEC_Block_No_Error_Counter;    /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  EPON_ONU_EPON_FEC_Block_Counter_t        FEC_Block_Counter;             /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  EPON_ONU_EPON_FEC_Corr_Byte_Counter_t    FEC_Corr_Byte_Counter;         /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  EPON_ONU_EPON_TXCTRL_t                   TXCTRL;                        /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  EPON_ONU_EPON_MAXPKTSIZE_t               MAXPKTSIZE;                    /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  EPON_ONU_EPON_TXCTRL_FFCFG_t             TXCTRL_FFCFG;                  /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  EPON_ONU_EPON_TXMAC_CFG_t                TXMAC_CFG;                     /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  EPON_ONU_EPON_PACKET_DRAIN_CNT_t         PACKET_DRAIN_CNT;              /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  EPON_ONU_EPON_TX_CRCERR_CNT_t            TX_CRCERR_CNT;                 /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  EPON_ONU_EPON_OUTPCS_CNT_t               OUTPCS_CNT;                    /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  EPON_ONU_EPON_OUTMAC_CNT_t               OUTMAC_CNT;                    /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  EPON_ONU_EPON_OUTLSR_CNT_t               OUTLSR_CNT;                    /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  EPON_ONU_EPON_DATAPATH_STATUS_t          DATAPATH_STATUS;               /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  EPON_ONU_EPON_RCC_CNT_t                  RCC_CNT;                       /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  EPON_ONU_EPON_PTP_ASYM_DELAY_t           PTP_ASYM_DELAY;                /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  EPON_ONU_EPON_PTP_EG_TIME_LATCH_t        PTP_EG_TIME_LATCH;             /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  EPON_ONU_EPON_PTP_EG_TIMES_LATCH1_t      PTP_EG_TIMES_LATCH1;           /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  EPON_ONU_EPON_PTP_EG_TIMES_LATCH0_t      PTP_EG_TIMES_LATCH0;           /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  EPON_ONU_EPON_PTP_EG_LATCH_t             PTP_EG_LATCH;                  /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  EPON_ONU_EPON_PTP_PIPE_EMPTY_t           PTP_PIPE_EMPTY;                /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  EPON_ONU_EPON_DBG_SEL_t                  DBG_SEL;                       /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  EPON_ONU_EPON_DBG_OUT_t                  DBG_OUT;                       /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  EPON_ONU_EPON_FF_STS_t                   FF_STS;                        /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  EPON_ONU_EPON_SPARE_t                    SPARE;                         /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  EPON_ONU_EPON_RSVR_t                     RSVR;                          /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  EPON_ONU_EPON_RXCTRL_t                   RXCTRL;                        /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  EPON_ONU_EPON_RX_MONITOR_t               RX_MONITOR;                    /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  EPON_ONU_EPON_RXMAC_CFG_t                RXMAC_CFG;                     /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  EPON_ONU_EPON_RXMAC_EXTENSION_CFG_t      RXMAC_EXTENSION_CFG;           /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];                   
  EPON_ONU_EPON_RXMAC_EXTENSION_OUI_t      RXMAC_EXTENSION_OUI;           /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];                   
  EPON_ONU_EPON_RXMAC_EXTENSION_DA1_t      RXMAC_EXTENSION_DA1;           /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];                   
  EPON_ONU_EPON_RXMAC_EXTENSION_DA0_t      RXMAC_EXTENSION_DA0;           /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];                   
  EPON_ONU_EPON_DATAPATH_BYPASS_t          DATAPATH_BYPASS;               /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];                   
  EPON_ONU_EPON_FEC_DEFINE_PKTSIZE_t       FEC_DEFINE_PKTSIZE;            /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd44[3];                   
  EPON_ONU_EPON_FEC_DEFINE_LATENCY_t       FEC_DEFINE_LATENCY;            /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd45[3];                   
  EPON_ONU_EPON_AES_MODE_CTL_t             AES_MODE_CTL;                  /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd46[3];                   
  EPON_ONU_EPON_UC_KEY03_t                 UC_KEY03;                      /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd47[3];                   
  EPON_ONU_EPON_UC_KEY02_t                 UC_KEY02;                      /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd48[3];                   
  EPON_ONU_EPON_UC_KEY01_t                 UC_KEY01;                      /* addr: 0x000000c0 */
  ca_uint32_t                              rsrvd49[3];                   
  EPON_ONU_EPON_UC_KEY00_t                 UC_KEY00;                      /* addr: 0x000000c4 */
  ca_uint32_t                              rsrvd50[3];                   
  EPON_ONU_EPON_UC_KEY13_t                 UC_KEY13;                      /* addr: 0x000000c8 */
  ca_uint32_t                              rsrvd51[3];                   
  EPON_ONU_EPON_UC_KEY12_t                 UC_KEY12;                      /* addr: 0x000000cc */
  ca_uint32_t                              rsrvd52[3];                   
  EPON_ONU_EPON_UC_KEY11_t                 UC_KEY11;                      /* addr: 0x000000d0 */
  ca_uint32_t                              rsrvd53[3];                   
  EPON_ONU_EPON_UC_KEY10_t                 UC_KEY10;                      /* addr: 0x000000d4 */
  ca_uint32_t                              rsrvd54[3];                   
  EPON_ONU_EPON_PKT_MON03_t                PKT_MON03;                     /* addr: 0x000000d8 */
  ca_uint32_t                              rsrvd55[3];                   
  EPON_ONU_EPON_PKT_MON02_t                PKT_MON02;                     /* addr: 0x000000dc */
  ca_uint32_t                              rsrvd56[3];                   
  EPON_ONU_EPON_PKT_MON01_t                PKT_MON01;                     /* addr: 0x000000e0 */
  ca_uint32_t                              rsrvd57[3];                   
  EPON_ONU_EPON_PKT_MON00_t                PKT_MON00;                     /* addr: 0x000000e4 */
  ca_uint32_t                              rsrvd58[3];                   
  EPON_ONU_EPON_PKT_MON13_t                PKT_MON13;                     /* addr: 0x000000e8 */
  ca_uint32_t                              rsrvd59[3];                   
  EPON_ONU_EPON_PKT_MON12_t                PKT_MON12;                     /* addr: 0x000000ec */
  ca_uint32_t                              rsrvd60[3];                   
  EPON_ONU_EPON_PKT_MON11_t                PKT_MON11;                     /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd61[3];                   
  EPON_ONU_EPON_PKT_MON10_t                PKT_MON10;                     /* addr: 0x000000f4 */
  ca_uint32_t                              rsrvd62[3];                   
  EPON_ONU_EPON_PKT_MON2_t                 PKT_MON2;                      /* addr: 0x000000f8 */
  ca_uint32_t                              rsrvd63[3];                   
  EPON_ONU_EPON_PKT_MON31_t                PKT_MON31;                     /* addr: 0x000000fc */
  ca_uint32_t                              rsrvd64[3];                   
  EPON_ONU_EPON_PKT_MON30_t                PKT_MON30;                     /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd65[3];                   
  EPON_ONU_EPON_KEYREQUEST_OAM_CNT_t       KEYREQUEST_OAM_CNT;            /* addr: 0x00000104 */
  ca_uint32_t                              rsrvd66[3];                   
  EPON_ONU_EPON_AES_DBG_CNT0_t             AES_DBG_CNT0;                  /* addr: 0x00000108 */
  ca_uint32_t                              rsrvd67[3];                   
  EPON_ONU_EPON_AES_DBG_GOOD_CNT0_t        AES_DBG_GOOD_CNT0;             /* addr: 0x0000010c */
  ca_uint32_t                              rsrvd68[3];                   
  EPON_ONU_EPON_AES_DBG_CNT1_t             AES_DBG_CNT1;                  /* addr: 0x00000110 */
  ca_uint32_t                              rsrvd69[3];                   
  EPON_ONU_EPON_AES_DBG_GOOD_CNT1_t        AES_DBG_GOOD_CNT1;             /* addr: 0x00000114 */
  ca_uint32_t                              rsrvd70[3];                   
  EPON_ONU_EPON_UC_TX_KEY03_t              UC_TX_KEY03;                   /* addr: 0x00000118 */
  ca_uint32_t                              rsrvd71[3];                   
  EPON_ONU_EPON_UC_TX_KEY02_t              UC_TX_KEY02;                   /* addr: 0x0000011c */
  ca_uint32_t                              rsrvd72[3];                   
  EPON_ONU_EPON_UC_TX_KEY01_t              UC_TX_KEY01;                   /* addr: 0x00000120 */
  ca_uint32_t                              rsrvd73[3];                   
  EPON_ONU_EPON_UC_TX_KEY00_t              UC_TX_KEY00;                   /* addr: 0x00000124 */
  ca_uint32_t                              rsrvd74[3];                   
  EPON_ONU_EPON_UC_TX_KEY13_t              UC_TX_KEY13;                   /* addr: 0x00000128 */
  ca_uint32_t                              rsrvd75[3];                   
  EPON_ONU_EPON_UC_TX_KEY12_t              UC_TX_KEY12;                   /* addr: 0x0000012c */
  ca_uint32_t                              rsrvd76[3];                   
  EPON_ONU_EPON_UC_TX_KEY11_t              UC_TX_KEY11;                   /* addr: 0x00000130 */
  ca_uint32_t                              rsrvd77[3];                   
  EPON_ONU_EPON_UC_TX_KEY10_t              UC_TX_KEY10;                   /* addr: 0x00000134 */
  ca_uint32_t                              rsrvd78[3];                   
  EPON_ONU_EPON_UC_TX_KEY_CTRL_t           UC_TX_KEY_CTRL;                /* addr: 0x00000138 */
  ca_uint32_t                              rsrvd79[3];                   
  EPON_ONU_EPON_AES_CHURNING_CTRL_t        AES_CHURNING_CTRL;             /* addr: 0x0000013c */
  ca_uint32_t                              rsrvd80[3];                   
  EPON_ONU_EPON_CHURN_CONFIG_CONTROL_t     CHURN_CONFIG_CONTROL;          /* addr: 0x00000140 */
  ca_uint32_t                              rsrvd81[3];                   
  EPON_ONU_EPON_MISC_CFG_t                 MISC_CFG;                      /* addr: 0x00000144 */
  ca_uint32_t                              rsrvd82[3];                   
  EPON_ONU_EPON_SLD_ERR_CNT_t              SLD_ERR_CNT;                   /* addr: 0x00000148 */
  ca_uint32_t                              rsrvd83[3];                   
  EPON_ONU_EPON_CRC8_ERR_CNT_t             CRC8_ERR_CNT;                  /* addr: 0x0000014c */
  ca_uint32_t                              rsrvd84[3];                   
  EPON_ONU_EPON_IPG_DROP_CNT_t             IPG_DROP_CNT;                  /* addr: 0x00000150 */
  ca_uint32_t                              rsrvd85[3];                   
  EPON_ONU_EPON_MISC_t                     MISC;                          /* addr: 0x00000154 */
  ca_uint32_t                              rsrvd86[3];                   
  EPON_ONU_EPON_RXCTRL_STS_t               RXCTRL_STS;                    /* addr: 0x00000158 */
  ca_uint32_t                              rsrvd87[3];                   
  EPON_ONU_EPON_AES_DEC_LLID_INDEX_0_t     AES_DEC_LLID_INDEX_0;          /* addr: 0x0000015c */
  ca_uint32_t                              rsrvd88[31];                  
  EPON_ONU_EPON_AES_DEC_KEY_TBL_ACCESS_t   AES_DEC_KEY_TBL_ACCESS;        /* addr: 0x0000017c */
  ca_uint32_t                              rsrvd89[3];                   
  EPON_ONU_EPON_AES_DEC_KEY_TBL_DATA3_t    AES_DEC_KEY_TBL_DATA3;         /* addr: 0x00000180 */
  ca_uint32_t                              rsrvd90[3];                   
  EPON_ONU_EPON_AES_DEC_KEY_TBL_DATA2_t    AES_DEC_KEY_TBL_DATA2;         /* addr: 0x00000184 */
  ca_uint32_t                              rsrvd91[3];                   
  EPON_ONU_EPON_AES_DEC_KEY_TBL_DATA1_t    AES_DEC_KEY_TBL_DATA1;         /* addr: 0x00000188 */
  ca_uint32_t                              rsrvd92[3];                   
  EPON_ONU_EPON_AES_DEC_KEY_TBL_DATA0_t    AES_DEC_KEY_TBL_DATA0;         /* addr: 0x0000018c */
} APB1_EPON_ONU_EPON_t;


/*
 * onu_1pps
 */
        
#define EPON_ONU_1PPS_INTERRUPT_SOURCE           0xd0030c00
#define EPON_ONU_1PPS_INTERRUPT_SOURCE_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pps_timeout          :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_1PPS_INTERRUPT_SOURCE_t;


#define EPON_ONU_1PPS_INTERRUPT_SOURCEE          0xd0030c04
#define EPON_ONU_1PPS_INTERRUPT_SOURCEE_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pps_timeoutE         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_1PPS_INTERRUPT_SOURCEE_t;


#define EPON_ONU_1PPS_CFG                        0xd0030c08
#define EPON_ONU_1PPS_CFG_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gen_1pps_tod_en      :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_1PPS_CFG_t;


#define EPON_ONU_1PPS_TOD_S_PPS                  0xd0030c0c
#define EPON_ONU_1PPS_TOD_S_PPS_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t s_pps                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_1PPS_TOD_S_PPS_t;


#define EPON_ONU_1PPS_TOD_PPS_WID                0xd0030c10
#define EPON_ONU_1PPS_TOD_PPS_WID_dft            0x0000000f

typedef volatile union {
  struct {
    ca_uint32_t pps_width            : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_1PPS_TOD_PPS_WID_t;


#define EPON_ONU_1PPS_TOD_S_TOD                  0xd0030c14
#define EPON_ONU_1PPS_TOD_S_TOD_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t s_tod                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_1PPS_TOD_S_TOD_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* onu_1pps */
typedef struct {
  EPON_ONU_1PPS_INTERRUPT_SOURCE_t         INTERRUPT_SOURCE;              /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  EPON_ONU_1PPS_INTERRUPT_SOURCEE_t        INTERRUPT_SOURCEE;             /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  EPON_ONU_1PPS_CFG_t                      CFG;                           /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  EPON_ONU_1PPS_TOD_S_PPS_t                TOD_S_PPS;                     /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  EPON_ONU_1PPS_TOD_PPS_WID_t              TOD_PPS_WID;                   /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  EPON_ONU_1PPS_TOD_S_TOD_t                TOD_S_TOD;                     /* addr: 0x00000014 */
} APB1_EPON_ONU_1PPS_t;


/*
 * glb_ptp
 */
        
#define EPON_GLB_PTP_INTERRUPT_ENABLE            0xd0030d00
#define EPON_GLB_PTP_INTERRUPT_ENABLE_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t gpsEnable1           :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd2               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_GLB_PTP_INTERRUPT_ENABLE_t;


#define EPON_GLB_PTP_INTERRUPT_SOURCE            0xd0030d04
#define EPON_GLB_PTP_INTERRUPT_SOURCE_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t gpsIRQ1              :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd2               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_GLB_PTP_INTERRUPT_SOURCE_t;


#define EPON_GLB_PTP_PTP_LTH_SRC_REG             0xd0030d08
#define EPON_GLB_PTP_PTP_LTH_SRC_REG_dft         0x000000e0

typedef volatile union {
  struct {
    ca_uint32_t slt_pad_gps          :  1 ; /* bits 0:0 */
    ca_uint32_t slt_sw_gps           :  1 ; /* bits 1:1 */
    ca_uint32_t slt_pps_gps          :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t add_adjust_timer     :  1 ; /* bits 5:5 */
    ca_uint32_t add_adjust_timer_s   :  1 ; /* bits 6:6 */
    ca_uint32_t reg_ptp_sync         :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd2               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_GLB_PTP_PTP_LTH_SRC_REG_t;


#define EPON_GLB_PTP_GLOBAL_TIMER_REG            0xd0030d0c
#define EPON_GLB_PTP_GLOBAL_TIMER_REG_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t glb_timer            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_GLB_PTP_GLOBAL_TIMER_REG_t;


#define EPON_GLB_PTP_ADJUST_TIMER_REG            0xd0030d10
#define EPON_GLB_PTP_ADJUST_TIMER_REG_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t adjust_timer         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_GLB_PTP_ADJUST_TIMER_REG_t;


#define EPON_GLB_PTP_GLOBAL_TIMER_S_LO_REG       0xd0030d14
#define EPON_GLB_PTP_GLOBAL_TIMER_S_LO_REG_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t glb_timer_s_lo       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_GLB_PTP_GLOBAL_TIMER_S_LO_REG_t;


#define EPON_GLB_PTP_GLOBAL_TIMER_S_HI_REG       0xd0030d18
#define EPON_GLB_PTP_GLOBAL_TIMER_S_HI_REG_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t glb_timer_s_hi       : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_GLB_PTP_GLOBAL_TIMER_S_HI_REG_t;


#define EPON_GLB_PTP_GLOBAL_CNT_1S_REG           0xd0030d1c
#define EPON_GLB_PTP_GLOBAL_CNT_1S_REG_dft       0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t cnt_1s               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_GLB_PTP_GLOBAL_CNT_1S_REG_t;


#define EPON_GLB_PTP_ADJUST_TIMER_S_LO_REG       0xd0030d20
#define EPON_GLB_PTP_ADJUST_TIMER_S_LO_REG_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t adjust_timer_s_lo    : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_GLB_PTP_ADJUST_TIMER_S_LO_REG_t;


#define EPON_GLB_PTP_ADJUST_TIMER_S_HI_REG       0xd0030d24
#define EPON_GLB_PTP_ADJUST_TIMER_S_HI_REG_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t adjust_timer_s_hi    : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_GLB_PTP_ADJUST_TIMER_S_HI_REG_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* glb_ptp */
typedef struct {
  EPON_GLB_PTP_INTERRUPT_ENABLE_t          INTERRUPT_ENABLE;              /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  EPON_GLB_PTP_INTERRUPT_SOURCE_t          INTERRUPT_SOURCE;              /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  EPON_GLB_PTP_PTP_LTH_SRC_REG_t           PTP_LTH_SRC_REG;               /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  EPON_GLB_PTP_GLOBAL_TIMER_REG_t          GLOBAL_TIMER_REG;              /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  EPON_GLB_PTP_ADJUST_TIMER_REG_t          ADJUST_TIMER_REG;              /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  EPON_GLB_PTP_GLOBAL_TIMER_S_LO_REG_t     GLOBAL_TIMER_S_LO_REG;         /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  EPON_GLB_PTP_GLOBAL_TIMER_S_HI_REG_t     GLOBAL_TIMER_S_HI_REG;         /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  EPON_GLB_PTP_GLOBAL_CNT_1S_REG_t         GLOBAL_CNT_1S_REG;             /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  EPON_GLB_PTP_ADJUST_TIMER_S_LO_REG_t     ADJUST_TIMER_S_LO_REG;         /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  EPON_GLB_PTP_ADJUST_TIMER_S_HI_REG_t     ADJUST_TIMER_S_HI_REG;         /* addr: 0x00000024 */
} APB1_EPON_GLB_PTP_t;


/*
 * onu_lt
 */
        
#define EPON_ONU_LT_RTT_COMPENSATION_CFG_1G_RX   0xd0030f00
#define EPON_ONU_LT_RTT_COMPENSATION_CFG_1G_RX_dft 0x00310001

typedef volatile union {
  struct {
    ca_uint32_t csrB                 : 16 ; /* bits 15:0 */
    ca_uint32_t csrA                 : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_LT_RTT_COMPENSATION_CFG_1G_RX_t;


#define EPON_ONU_LT_RTT_COMPENSATION_CFG_1G_TX   0xd0030f04
#define EPON_ONU_LT_RTT_COMPENSATION_CFG_1G_TX_dft 0x00120011

typedef volatile union {
  struct {
    ca_uint32_t csrD                 : 16 ; /* bits 15:0 */
    ca_uint32_t csrC                 : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_LT_RTT_COMPENSATION_CFG_1G_TX_t;


#define EPON_ONU_LT_RTT_COMPENSATION_CFG_10G_RX  0xd0030f08
#define EPON_ONU_LT_RTT_COMPENSATION_CFG_10G_RX_dft 0x005c0004

typedef volatile union {
  struct {
    ca_uint32_t csrB                 : 16 ; /* bits 15:0 */
    ca_uint32_t csrA                 : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_LT_RTT_COMPENSATION_CFG_10G_RX_t;


#define EPON_ONU_LT_RTT_COMPENSATION_CFG_10G_TX  0xd0030f0c
#define EPON_ONU_LT_RTT_COMPENSATION_CFG_10G_TX_dft 0x001b0016

typedef volatile union {
  struct {
    ca_uint32_t csrD                 : 16 ; /* bits 15:0 */
    ca_uint32_t csrC                 : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_LT_RTT_COMPENSATION_CFG_10G_TX_t;


#define EPON_ONU_LT_RTT_COMPENSATION_TXMAC_OFFSET 0xd0030f10
#define EPON_ONU_LT_RTT_COMPENSATION_TXMAC_OFFSET_dft 0x00160013

typedef volatile union {
  struct {
    ca_uint32_t tx1g                 : 16 ; /* bits 15:0 */
    ca_uint32_t tx10g                : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_LT_RTT_COMPENSATION_TXMAC_OFFSET_t;


#define EPON_ONU_LT_MISC_CFG                     0xd0030f14
#define EPON_ONU_LT_MISC_CFG_dft                 0x00000002

typedef volatile union {
  struct {
    ca_uint32_t forbidden_win_size   :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_LT_MISC_CFG_t;


#define EPON_ONU_LT_MPCP_TIMER_MATCH_CFG         0xd0030f18
#define EPON_ONU_LT_MPCP_TIMER_MATCH_CFG_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t epon_mpcp_timer_match_val : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_LT_MPCP_TIMER_MATCH_CFG_t;


#define EPON_ONU_LT_LAST_DRIFT                   0xd0030f1c
#define EPON_ONU_LT_LAST_DRIFT_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t last_drift_value     : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_LT_LAST_DRIFT_t;


#define EPON_ONU_LT_SDS_DLY                      0xd0030f20
#define EPON_ONU_LT_SDS_DLY_dft                  0x01010101

typedef volatile union {
  struct {
    ca_uint32_t tx1g                 :  8 ; /* bits 7:0 */
    ca_uint32_t rx1g                 :  8 ; /* bits 15:8 */
    ca_uint32_t tx10g                :  8 ; /* bits 23:16 */
    ca_uint32_t rx10g                :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_LT_SDS_DLY_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* onu_lt */
typedef struct {
  EPON_ONU_LT_RTT_COMPENSATION_CFG_1G_RX_t RTT_COMPENSATION_CFG_1G_RX;    /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  EPON_ONU_LT_RTT_COMPENSATION_CFG_1G_TX_t RTT_COMPENSATION_CFG_1G_TX;    /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  EPON_ONU_LT_RTT_COMPENSATION_CFG_10G_RX_t RTT_COMPENSATION_CFG_10G_RX;   /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  EPON_ONU_LT_RTT_COMPENSATION_CFG_10G_TX_t RTT_COMPENSATION_CFG_10G_TX;   /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  EPON_ONU_LT_RTT_COMPENSATION_TXMAC_OFFSET_t RTT_COMPENSATION_TXMAC_OFFSET; /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  EPON_ONU_LT_MISC_CFG_t                   MISC_CFG;                      /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  EPON_ONU_LT_MPCP_TIMER_MATCH_CFG_t       MPCP_TIMER_MATCH_CFG;          /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  EPON_ONU_LT_LAST_DRIFT_t                 LAST_DRIFT;                    /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  EPON_ONU_LT_SDS_DLY_t                    SDS_DLY;                       /* addr: 0x00000020 */
} APB1_EPON_ONU_LT_t;


/*
 * XGEPN
 */
  
/*
 * xmac
 */
  
/*
 * txmac
 */
        
#define EPON_XGEPN_XMAC_TXMAC_CONFIG             0xd0031000
#define EPON_XGEPN_XMAC_TXMAC_CONFIG_dft         0x7fff106a

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t xgepcs               :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t ins_2idles           :  1 ; /* bits 3:3 */
    ca_uint32_t sel_t4burst_ctrl     :  1 ; /* bits 4:4 */
    ca_uint32_t eob_cnt              :  3 ; /* bits 7:5 */
    ca_uint32_t idl_cnt              :  3 ; /* bits 10:8 */
    ca_uint32_t en_true_burst_end    :  1 ; /* bits 11:11 */
    ca_uint32_t en_txf_empty_end     :  1 ; /* bits 12:12 */
    ca_uint32_t en_dfemp_burst_end   :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd3               :  2 ;
    ca_uint32_t txp_resend_quanta    : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_TXMAC_CONFIG_t;


#define EPON_XGEPN_XMAC_TXMAC_TX_CONFIG          0xd0031004
#define EPON_XGEPN_XMAC_TXMAC_TX_CONFIG_dft      0x1c40c030

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t reset                :  1 ; /* bits 1:1 */
    ca_uint32_t tx_pause_en          :  1 ; /* bits 2:2 */
    ca_uint32_t mac_en               :  1 ; /* bits 3:3 */
    ca_uint32_t crc_recaculate_en    :  1 ; /* bits 4:4 */
    ca_uint32_t ch_timestamp         :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t loopback             :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd3               :  4 ;
    ca_uint32_t ipg_minimal          :  5 ; /* bits 16:12 */
    ca_uint32_t dic_maximum          :  2 ; /* bits 18:17 */
    ca_uint32_t rsrvd4               :  1 ;
    ca_uint32_t burst_cnt            :  5 ; /* bits 24:20 */
    ca_uint32_t burst_testmode       :  1 ; /* bits 25:25 */
    ca_uint32_t burst_end_cnt        :  5 ; /* bits 30:26 */
    ca_uint32_t burst_end_test_mode  :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_TXMAC_TX_CONFIG_t;


#define EPON_XGEPN_XMAC_TXMAC_TX_PAKT_MIB0       0xd0031008
#define EPON_XGEPN_XMAC_TXMAC_TX_PAKT_MIB0_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t latch                :  1 ; /* bits 16:16 */
    ca_uint32_t clr                  :  1 ; /* bits 17:17 */
    ca_uint32_t match                :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_TXMAC_TX_PAKT_MIB0_t;


#define EPON_XGEPN_XMAC_TXMAC_TX_PAKT_MIB1       0xd003100c
#define EPON_XGEPN_XMAC_TXMAC_TX_PAKT_MIB1_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t count                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_TXMAC_TX_PAKT_MIB1_t;


#define EPON_XGEPN_XMAC_TXMAC_MACSEC_LLIDEN0     0xd0031010
#define EPON_XGEPN_XMAC_TXMAC_MACSEC_LLIDEN0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid_sec_en          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_TXMAC_MACSEC_LLIDEN0_t;


#define EPON_XGEPN_XMAC_TXMAC_SECTAG_LLIDEN0     0xd0031014
#define EPON_XGEPN_XMAC_TXMAC_SECTAG_LLIDEN0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sectag_type          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_TXMAC_SECTAG_LLIDEN0_t;


#define EPON_XGEPN_XMAC_TXMAC_PKT_TYPE_EN        0xd0031018
#define EPON_XGEPN_XMAC_TXMAC_PKT_TYPE_EN_dft    0x88080000

typedef volatile union {
  struct {
    ca_uint32_t ethernettype_sec_en  :  1 ; /* bits 0:0 */
    ca_uint32_t oam_sec_en           :  1 ; /* bits 1:1 */
    ca_uint32_t mpcp_sec_en          :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 13 ;
    ca_uint32_t pkt_type             : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_TXMAC_PKT_TYPE_EN_t;


#define EPON_XGEPN_XMAC_TXMAC_XGEPN_BURST_TEST   0xd003101c
#define EPON_XGEPN_XMAC_TXMAC_XGEPN_BURST_TEST_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sync_st_testmode     :  1 ; /* bits 0:0 */
    ca_uint32_t xgepn_st_testmode    :  1 ; /* bits 1:1 */
    ca_uint32_t xgepn_end_testmode   :  1 ; /* bits 2:2 */
    ca_uint32_t xgepn_trueend_testmode :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_TXMAC_XGEPN_BURST_TEST_t;


#define EPON_XGEPN_XMAC_TXMAC_XGEPN_TX_FIFO_UNDERFLOW 0xd0031020
#define EPON_XGEPN_XMAC_TXMAC_XGEPN_TX_FIFO_UNDERFLOW_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t async_tx_underflow   :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_TXMAC_XGEPN_TX_FIFO_UNDERFLOW_t;


#define EPON_XGEPN_XMAC_TXMAC_XGEPN_TX_DBG       0xd0031024
#define EPON_XGEPN_XMAC_TXMAC_XGEPN_TX_DBG_dft   0x00000009

typedef volatile union {
  struct {
    ca_uint32_t dbg                  : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_TXMAC_XGEPN_TX_DBG_t;


#define EPON_XGEPN_XMAC_TXMAC_XGEPN_PAUSE_QUANTA 0xd0031028
#define EPON_XGEPN_XMAC_TXMAC_XGEPN_PAUSE_QUANTA_dft 0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t rx_pause_quanta      : 16 ; /* bits 15:0 */
    ca_uint32_t tx_pause_quanta      : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_TXMAC_XGEPN_PAUSE_QUANTA_t;


#define EPON_XGEPN_XMAC_TXMAC_XGEPN_RX_PAUSE     0xd003102c
#define EPON_XGEPN_XMAC_TXMAC_XGEPN_RX_PAUSE_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t trig                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_TXMAC_XGEPN_RX_PAUSE_t;


#define EPON_XGEPN_XMAC_TXMAC_XGEPN_TX_PAUSE     0xd0031030
#define EPON_XGEPN_XMAC_TXMAC_XGEPN_TX_PAUSE_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t trig                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_TXMAC_XGEPN_TX_PAUSE_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* txmac */
typedef struct {
  EPON_XGEPN_XMAC_TXMAC_CONFIG_t           CONFIG;                        /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  EPON_XGEPN_XMAC_TXMAC_TX_CONFIG_t        TX_CONFIG;                     /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  EPON_XGEPN_XMAC_TXMAC_TX_PAKT_MIB0_t     TX_PAKT_MIB0;                  /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  EPON_XGEPN_XMAC_TXMAC_TX_PAKT_MIB1_t     TX_PAKT_MIB1;                  /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  EPON_XGEPN_XMAC_TXMAC_MACSEC_LLIDEN0_t   MACSEC_LLIDEN0;                /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  EPON_XGEPN_XMAC_TXMAC_SECTAG_LLIDEN0_t   SECTAG_LLIDEN0;                /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  EPON_XGEPN_XMAC_TXMAC_PKT_TYPE_EN_t      PKT_TYPE_EN;                   /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  EPON_XGEPN_XMAC_TXMAC_XGEPN_BURST_TEST_t XGEPN_BURST_TEST;              /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  EPON_XGEPN_XMAC_TXMAC_XGEPN_TX_FIFO_UNDERFLOW_t XGEPN_TX_FIFO_UNDERFLOW;       /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  EPON_XGEPN_XMAC_TXMAC_XGEPN_TX_DBG_t     XGEPN_TX_DBG;                  /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  EPON_XGEPN_XMAC_TXMAC_XGEPN_PAUSE_QUANTA_t XGEPN_PAUSE_QUANTA;            /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  EPON_XGEPN_XMAC_TXMAC_XGEPN_RX_PAUSE_t   XGEPN_RX_PAUSE;                /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  EPON_XGEPN_XMAC_TXMAC_XGEPN_TX_PAUSE_t   XGEPN_TX_PAUSE;                /* addr: 0x00000030 */
} APB1_EPON_XGEPN_XMAC_TXMAC_t;


/*
 * rxmac
 */
        
#define EPON_XGEPN_XMAC_RXMAC_RX_MPCP0           0xd00310b0
#define EPON_XGEPN_XMAC_RXMAC_RX_MPCP0_dft       0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t reg_sts              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_RXMAC_RX_MPCP0_t;


#define EPON_XGEPN_XMAC_RXMAC_RX_CONFIG          0xd00310b4
#define EPON_XGEPN_XMAC_RXMAC_RX_CONFIG_dft      0x5ffe1210

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t reset                :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t mpcp_lt_emb          :  1 ; /* bits 3:3 */
    ca_uint32_t mpcp_crc_chk         :  1 ; /* bits 4:4 */
    ca_uint32_t llid_filter_dis      :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t mac_en               :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd4               :  1 ;
    ca_uint32_t pause_en             :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd5               :  1 ;
    ca_uint32_t en_old_fsm           :  1 ; /* bits 11:11 */
    ca_uint32_t dis_rtt_ts_adj       :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd6               :  4 ;
    ca_uint32_t max_size             : 14 ; /* bits 30:17 */
    ca_uint32_t rsrvd7               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_RXMAC_RX_CONFIG_t;


#define EPON_XGEPN_XMAC_RXMAC_RX_PKT_DET         0xd00310b8
#define EPON_XGEPN_XMAC_RXMAC_RX_PKT_DET_dft     0x00251bff

typedef volatile union {
  struct {
    ca_uint32_t check_idle           :  1 ; /* bits 0:0 */
    ca_uint32_t check_start          :  1 ; /* bits 1:1 */
    ca_uint32_t check_sld            :  1 ; /* bits 2:2 */
    ca_uint32_t check_preamble       :  1 ; /* bits 3:3 */
    ca_uint32_t check_llid           :  1 ; /* bits 4:4 */
    ca_uint32_t check_sfd            :  1 ; /* bits 5:5 */
    ca_uint32_t check_terminate      :  1 ; /* bits 6:6 */
    ca_uint32_t mc_mpcp              :  6 ; /* bits 12:7 */
    ca_uint32_t uc_mpcp              :  6 ; /* bits 18:13 */
    ca_uint32_t slow_subtype         :  3 ; /* bits 21:19 */
    ca_uint32_t mpcp_fw              :  6 ; /* bits 27:22 */
    ca_uint32_t rsrvd1               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_RXMAC_RX_PKT_DET_t;


#define EPON_XGEPN_XMAC_RXMAC_RX_LOCALTIME_ADJUST 0xd00310bc
#define EPON_XGEPN_XMAC_RXMAC_RX_LOCALTIME_ADJUST_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t adjust_loctimer      : 17 ; /* bits 16:0 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_RXMAC_RX_LOCALTIME_ADJUST_t;


#define EPON_XGEPN_XMAC_RXMAC_RX_PAKT_MIB0       0xd00310c0
#define EPON_XGEPN_XMAC_RXMAC_RX_PAKT_MIB0_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t latch                :  1 ; /* bits 16:16 */
    ca_uint32_t clr                  :  1 ; /* bits 17:17 */
    ca_uint32_t match                :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_RXMAC_RX_PAKT_MIB0_t;


#define EPON_XGEPN_XMAC_RXMAC_RX_PAKT_MIB1       0xd00310c4
#define EPON_XGEPN_XMAC_RXMAC_RX_PAKT_MIB1_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t count                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_RXMAC_RX_PAKT_MIB1_t;


#define EPON_XGEPN_XMAC_RXMAC_XGEPN_SLD_CRC8_ERRCNT 0xd00310c8
#define EPON_XGEPN_XMAC_RXMAC_XGEPN_SLD_CRC8_ERRCNT_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sld_crc8_err_cnt     : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_RXMAC_XGEPN_SLD_CRC8_ERRCNT_t;


#define EPON_XGEPN_XMAC_RXMAC_XGEPN_RX_PKT_HEAD0 0xd00310cc
#define EPON_XGEPN_XMAC_RXMAC_XGEPN_RX_PKT_HEAD0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_RXMAC_XGEPN_RX_PKT_HEAD0_t;


#define EPON_XGEPN_XMAC_RXMAC_XGEPN_RX_PKT_HEAD1 0xd00310d0
#define EPON_XGEPN_XMAC_RXMAC_XGEPN_RX_PKT_HEAD1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_RXMAC_XGEPN_RX_PKT_HEAD1_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* rxmac */
typedef struct {
  EPON_XGEPN_XMAC_RXMAC_RX_MPCP0_t         RX_MPCP0;                      /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  EPON_XGEPN_XMAC_RXMAC_RX_CONFIG_t        RX_CONFIG;                     /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  EPON_XGEPN_XMAC_RXMAC_RX_PKT_DET_t       RX_PKT_DET;                    /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  EPON_XGEPN_XMAC_RXMAC_RX_LOCALTIME_ADJUST_t RX_LOCALTIME_ADJUST;           /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  EPON_XGEPN_XMAC_RXMAC_RX_PAKT_MIB0_t     RX_PAKT_MIB0;                  /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  EPON_XGEPN_XMAC_RXMAC_RX_PAKT_MIB1_t     RX_PAKT_MIB1;                  /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  EPON_XGEPN_XMAC_RXMAC_XGEPN_SLD_CRC8_ERRCNT_t XGEPN_SLD_CRC8_ERRCNT;         /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  EPON_XGEPN_XMAC_RXMAC_XGEPN_RX_PKT_HEAD0_t XGEPN_RX_PKT_HEAD0;            /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  EPON_XGEPN_XMAC_RXMAC_XGEPN_RX_PKT_HEAD1_t XGEPN_RX_PKT_HEAD1;            /* addr: 0x00000020 */
} APB1_EPON_XGEPN_XMAC_RXMAC_t;


/*
 * ctrl
 */
        
#define EPON_XGEPN_XMAC_CTRL_XGEPN_RX_CTL        0xd0031250
#define EPON_XGEPN_XMAC_CTRL_XGEPN_RX_CTL_dft    0x380ff000

typedef volatile union {
  struct {
    ca_uint32_t ptp_da_en            :  1 ; /* bits 0:0 */
    ca_uint32_t clr_rcffoverrun      :  1 ; /* bits 1:1 */
    ca_uint32_t drop_ptp_pkt_type    : 10 ; /* bits 11:2 */
    ca_uint32_t frame_error_drop_en  :  1 ; /* bits 12:12 */
    ca_uint32_t frame_fcs_error_drop_en :  1 ; /* bits 13:13 */
    ca_uint32_t frame_unopcode_drop_en :  1 ; /* bits 14:14 */
    ca_uint32_t frame_pause_drop_en  :  1 ; /* bits 15:15 */
    ca_uint32_t frame_runt_drop_en   :  1 ; /* bits 16:16 */
    ca_uint32_t frame_oversize_drop_en :  1 ; /* bits 17:17 */
    ca_uint32_t frame_ffoverflow_drop_en :  1 ; /* bits 18:18 */
    ca_uint32_t frame_mpcp_drop_en   :  1 ; /* bits 19:19 */
    ca_uint32_t ptp_ing_ts_cmp       :  5 ; /* bits 24:20 */
    ca_uint32_t frame_exmpcp_datadrop_en :  1 ; /* bits 25:25 */
    ca_uint32_t frame_unda_drop_en   :  1 ; /* bits 26:26 */
    ca_uint32_t frame_invld_llid_drop_en :  1 ; /* bits 27:27 */
    ca_uint32_t frame_keyex_oam_drop_en :  1 ; /* bits 28:28 */
    ca_uint32_t frame_exmpcp_mpcpdrop_en :  1 ; /* bits 29:29 */
    ca_uint32_t frame_bytecnt_drop_en :  1 ; /* bits 30:30 */
    ca_uint32_t bypass               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_RX_CTL_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_CTL        0xd0031254
#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_CTL_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t tx_remheader_dis     :  1 ; /* bits 1:1 */
    ca_uint32_t bm_pausereq_sel      :  1 ; /* bits 2:2 */
    ca_uint32_t tx_pad_en            :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t ptp_eg_ts_comp       :  5 ; /* bits 9:5 */
    ca_uint32_t rsrvd3               : 18 ;
    ca_uint32_t dbg_bus_sel          :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_TX_CTL_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_FF_THRESHOLD 0xd0031258
#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_FF_THRESHOLD_dft 0x00f0702b

typedef volatile union {
  struct {
    ca_uint32_t txff_wrff_threshold  :  4 ; /* bits 3:0 */
    ca_uint32_t txff_rdff_threshold  :  4 ; /* bits 7:4 */
    ca_uint32_t txctl_wrff_threshold :  7 ; /* bits 14:8 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t txctl_rdff_threshold :  7 ; /* bits 26:20 */
    ca_uint32_t rsrvd2               :  5 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_TX_FF_THRESHOLD_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_RX_STATUS0    0xd003125c
#define EPON_XGEPN_XMAC_CTRL_XGEPN_RX_STATUS0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rcdrop_cnt           : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_RX_STATUS0_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_RX_STATUS1    0xd0031260
#define EPON_XGEPN_XMAC_CTRL_XGEPN_RX_STATUS1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rcff_pktnum          :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_RX_STATUS1_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_STATUS2    0xd0031264
#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_STATUS2_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tcff_pktnum          :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_TX_STATUS2_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_STATUS3    0xd0031268
#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_STATUS3_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t length_mismatch      :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_TX_STATUS3_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_STATUS4    0xd003126c
#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_STATUS4_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t es_runt_pkt          :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_TX_STATUS4_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_FF_STATUS     0xd0031270
#define EPON_XGEPN_XMAC_CTRL_XGEPN_FF_STATUS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_ffempty           :  1 ; /* bits 0:0 */
    ca_uint32_t tx_fffull            :  1 ; /* bits 1:1 */
    ca_uint32_t rx_ffempty           :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fffull            :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_FF_STATUS_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_INTERRUPT     0xd0031274
#define EPON_XGEPN_XMAC_CTRL_XGEPN_INTERRUPT_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rc_ffoverrun_intI    :  1 ; /* bits 0:0 */
    ca_uint32_t mpcp_ffoverrun_intI  :  1 ; /* bits 1:1 */
    ca_uint32_t burst_end_mismatch_intI :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 13 ;
    ca_uint32_t rc_ptp_pkt_intI      :  1 ; /* bits 16:16 */
    ca_uint32_t tc_ptp_pkt_intI      :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd2               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_INTERRUPT_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_INTERRUPTE0   0xd0031278
#define EPON_XGEPN_XMAC_CTRL_XGEPN_INTERRUPTE0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rc_ffoverrun_intIE   :  1 ; /* bits 0:0 */
    ca_uint32_t mpcp_ffoverrun_intIE :  1 ; /* bits 1:1 */
    ca_uint32_t burst_end_mismatch_intIE :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 13 ;
    ca_uint32_t rc_ptp_pkt_intIE     :  1 ; /* bits 16:16 */
    ca_uint32_t tc_ptp_pkt_intIE     :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd2               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_INTERRUPTE0_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_INTERRUPTE1   0xd003127c
#define EPON_XGEPN_XMAC_CTRL_XGEPN_INTERRUPTE1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rc_ffoverrun_intIE   :  1 ; /* bits 0:0 */
    ca_uint32_t mpcp_ffoverrun_intIE :  1 ; /* bits 1:1 */
    ca_uint32_t burst_end_mismatch_intIE :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 13 ;
    ca_uint32_t rc_ptp_pkt_intIE     :  1 ; /* bits 16:16 */
    ca_uint32_t tc_ptp_pkt_intIE     :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd2               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_INTERRUPTE1_t;


#define EPON_XGEPN_XMAC_CTRL_RX_BYTE_MIB0        0xd0031280
#define EPON_XGEPN_XMAC_CTRL_RX_BYTE_MIB0_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t latch                :  1 ; /* bits 16:16 */
    ca_uint32_t clr                  :  1 ; /* bits 17:17 */
    ca_uint32_t match                :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_RX_BYTE_MIB0_t;


#define EPON_XGEPN_XMAC_CTRL_RX_BYTE_MIB1        0xd0031284
#define EPON_XGEPN_XMAC_CTRL_RX_BYTE_MIB1_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t count                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_RX_BYTE_MIB1_t;


#define EPON_XGEPN_XMAC_CTRL_RX_MPCP_MIB0        0xd0031288
#define EPON_XGEPN_XMAC_CTRL_RX_MPCP_MIB0_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t latch                :  1 ; /* bits 16:16 */
    ca_uint32_t clr                  :  1 ; /* bits 17:17 */
    ca_uint32_t match                :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_RX_MPCP_MIB0_t;


#define EPON_XGEPN_XMAC_CTRL_RX_MPCP_MIB1        0xd003128c
#define EPON_XGEPN_XMAC_CTRL_RX_MPCP_MIB1_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t count                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_RX_MPCP_MIB1_t;


#define EPON_XGEPN_XMAC_CTRL_RX_OAM_MIB0         0xd0031290
#define EPON_XGEPN_XMAC_CTRL_RX_OAM_MIB0_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 16 ;
    ca_uint32_t latch                :  1 ; /* bits 16:16 */
    ca_uint32_t clr                  :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd2               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_RX_OAM_MIB0_t;


#define EPON_XGEPN_XMAC_CTRL_RX_OAM_MIB1         0xd0031294
#define EPON_XGEPN_XMAC_CTRL_RX_OAM_MIB1_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t count                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_RX_OAM_MIB1_t;


#define EPON_XGEPN_XMAC_CTRL_TX_BYTE_MIB0        0xd0031298
#define EPON_XGEPN_XMAC_CTRL_TX_BYTE_MIB0_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t latch                :  1 ; /* bits 16:16 */
    ca_uint32_t clr                  :  1 ; /* bits 17:17 */
    ca_uint32_t match                :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_TX_BYTE_MIB0_t;


#define EPON_XGEPN_XMAC_CTRL_TX_BYTE_MIB1        0xd003129c
#define EPON_XGEPN_XMAC_CTRL_TX_BYTE_MIB1_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t count                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_TX_BYTE_MIB1_t;


#define EPON_XGEPN_XMAC_CTRL_TX_MPCP_MIB0        0xd00312a0
#define EPON_XGEPN_XMAC_CTRL_TX_MPCP_MIB0_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t latch                :  1 ; /* bits 16:16 */
    ca_uint32_t clr                  :  1 ; /* bits 17:17 */
    ca_uint32_t match                :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_TX_MPCP_MIB0_t;


#define EPON_XGEPN_XMAC_CTRL_TX_MPCP_MIB1        0xd00312a4
#define EPON_XGEPN_XMAC_CTRL_TX_MPCP_MIB1_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t count                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_TX_MPCP_MIB1_t;


#define EPON_XGEPN_XMAC_CTRL_TX_OAM_MIB0         0xd00312a8
#define EPON_XGEPN_XMAC_CTRL_TX_OAM_MIB0_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 16 ;
    ca_uint32_t latch                :  1 ; /* bits 16:16 */
    ca_uint32_t clr                  :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd2               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_TX_OAM_MIB0_t;


#define EPON_XGEPN_XMAC_CTRL_TX_OAM_MIB1         0xd00312ac
#define EPON_XGEPN_XMAC_CTRL_TX_OAM_MIB1_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t count                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_TX_OAM_MIB1_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_TM     0xd00312b0
#define EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_TM_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ptp_tm               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_TM_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_TM_S_LO 0xd00312b4
#define EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_TM_S_LO_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ptp_tm               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_TM_S_LO_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_TM_S_HI 0xd00312b8
#define EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_TM_S_HI_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ptp_tm               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_TM_S_HI_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_TYPE   0xd00312bc
#define EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_TYPE_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ptp_type             :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_TYPE_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_SQID   0xd00312c0
#define EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_SQID_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sq_id                : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_SQID_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_TM     0xd00312c4
#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_TM_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ptp_tm               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_TM_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_TM_S_LO 0xd00312c8
#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_TM_S_LO_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ptp_tm               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_TM_S_LO_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_TM_S_HI 0xd00312cc
#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_TM_S_HI_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ptp_tm               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_TM_S_HI_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_SQID   0xd00312d0
#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_SQID_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sq_id                : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_SQID_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_TYPE   0xd00312d4
#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_TYPE_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ptp_type             :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_TYPE_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_PTP_VLAN0     0xd00312d8
#define EPON_XGEPN_XMAC_CTRL_XGEPN_PTP_VLAN0_dft 0x81009100

typedef volatile union {
  struct {
    ca_uint32_t vlan0                : 16 ; /* bits 15:0 */
    ca_uint32_t vlan1                : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_PTP_VLAN0_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_PTP_VLAN1     0xd00312dc
#define EPON_XGEPN_XMAC_CTRL_XGEPN_PTP_VLAN1_dft 0x81009100

typedef volatile union {
  struct {
    ca_uint32_t vlan0                : 16 ; /* bits 15:0 */
    ca_uint32_t vlan1                : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_PTP_VLAN1_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_RX_DBG        0xd00312e0
#define EPON_XGEPN_XMAC_CTRL_XGEPN_RX_DBG_dft    0x80000009

typedef volatile union {
  struct {
    ca_uint32_t dbg                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_RX_DBG_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_DBG        0xd00312e4
#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_DBG_dft    0x0000000e

typedef volatile union {
  struct {
    ca_uint32_t dbg                  : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_TX_DBG_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_RXFPGA_DROPCNT 0xd00312e8
#define EPON_XGEPN_XMAC_CTRL_XGEPN_RXFPGA_DROPCNT_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t asyncff_dropcnt      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_RXFPGA_DROPCNT_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_RXFPGA_FF_THRESHOLD 0xd00312ec
#define EPON_XGEPN_XMAC_CTRL_XGEPN_RXFPGA_FF_THRESHOLD_dft 0x30000090

typedef volatile union {
  struct {
    ca_uint32_t rx_wrff_threshold    :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 20 ;
    ca_uint32_t rx_rdff_ipg          :  3 ; /* bits 30:28 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_RXFPGA_FF_THRESHOLD_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_TXFPGA_FF_THRESHOLD 0xd00312f0
#define EPON_XGEPN_XMAC_CTRL_XGEPN_TXFPGA_FF_THRESHOLD_dft 0x004000f0

typedef volatile union {
  struct {
    ca_uint32_t tx_wrff_threshold    :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t tx_rdff_threshold    :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd2               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_TXFPGA_FF_THRESHOLD_t;


#define EPON_XGEPN_XMAC_CTRL_SPARE               0xd00312f4
#define EPON_XGEPN_XMAC_CTRL_SPARE_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t spare                :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_SPARE_t;


#define EPON_XGEPN_XMAC_CTRL_SPARE1              0xd00312f8
#define EPON_XGEPN_XMAC_CTRL_SPARE1_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t spare                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_SPARE1_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* ctrl */
typedef struct {
  EPON_XGEPN_XMAC_CTRL_XGEPN_RX_CTL_t      XGEPN_RX_CTL;                  /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  EPON_XGEPN_XMAC_CTRL_XGEPN_TX_CTL_t      XGEPN_TX_CTL;                  /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  EPON_XGEPN_XMAC_CTRL_XGEPN_TX_FF_THRESHOLD_t XGEPN_TX_FF_THRESHOLD;         /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  EPON_XGEPN_XMAC_CTRL_XGEPN_RX_STATUS0_t  XGEPN_RX_STATUS0;              /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  EPON_XGEPN_XMAC_CTRL_XGEPN_RX_STATUS1_t  XGEPN_RX_STATUS1;              /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  EPON_XGEPN_XMAC_CTRL_XGEPN_TX_STATUS2_t  XGEPN_TX_STATUS2;              /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  EPON_XGEPN_XMAC_CTRL_XGEPN_TX_STATUS3_t  XGEPN_TX_STATUS3;              /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  EPON_XGEPN_XMAC_CTRL_XGEPN_TX_STATUS4_t  XGEPN_TX_STATUS4;              /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  EPON_XGEPN_XMAC_CTRL_XGEPN_FF_STATUS_t   XGEPN_FF_STATUS;               /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  EPON_XGEPN_XMAC_CTRL_XGEPN_INTERRUPT_t   XGEPN_INTERRUPT;               /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  EPON_XGEPN_XMAC_CTRL_XGEPN_INTERRUPTE0_t XGEPN_INTERRUPTE0;             /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  EPON_XGEPN_XMAC_CTRL_XGEPN_INTERRUPTE1_t XGEPN_INTERRUPTE1;             /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  EPON_XGEPN_XMAC_CTRL_RX_BYTE_MIB0_t      RX_BYTE_MIB0;                  /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  EPON_XGEPN_XMAC_CTRL_RX_BYTE_MIB1_t      RX_BYTE_MIB1;                  /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  EPON_XGEPN_XMAC_CTRL_RX_MPCP_MIB0_t      RX_MPCP_MIB0;                  /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  EPON_XGEPN_XMAC_CTRL_RX_MPCP_MIB1_t      RX_MPCP_MIB1;                  /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  EPON_XGEPN_XMAC_CTRL_RX_OAM_MIB0_t       RX_OAM_MIB0;                   /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  EPON_XGEPN_XMAC_CTRL_RX_OAM_MIB1_t       RX_OAM_MIB1;                   /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  EPON_XGEPN_XMAC_CTRL_TX_BYTE_MIB0_t      TX_BYTE_MIB0;                  /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  EPON_XGEPN_XMAC_CTRL_TX_BYTE_MIB1_t      TX_BYTE_MIB1;                  /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  EPON_XGEPN_XMAC_CTRL_TX_MPCP_MIB0_t      TX_MPCP_MIB0;                  /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  EPON_XGEPN_XMAC_CTRL_TX_MPCP_MIB1_t      TX_MPCP_MIB1;                  /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  EPON_XGEPN_XMAC_CTRL_TX_OAM_MIB0_t       TX_OAM_MIB0;                   /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  EPON_XGEPN_XMAC_CTRL_TX_OAM_MIB1_t       TX_OAM_MIB1;                   /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_TM_t   XGEPN_RX_PTP_TM;               /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_TM_S_LO_t XGEPN_RX_PTP_TM_S_LO;          /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_TM_S_HI_t XGEPN_RX_PTP_TM_S_HI;          /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_TYPE_t XGEPN_RX_PTP_TYPE;             /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_SQID_t XGEPN_RX_PTP_SQID;             /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_TM_t   XGEPN_TX_PTP_TM;               /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_TM_S_LO_t XGEPN_TX_PTP_TM_S_LO;          /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_TM_S_HI_t XGEPN_TX_PTP_TM_S_HI;          /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_SQID_t XGEPN_TX_PTP_SQID;             /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_TYPE_t XGEPN_TX_PTP_TYPE;             /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  EPON_XGEPN_XMAC_CTRL_XGEPN_PTP_VLAN0_t   XGEPN_PTP_VLAN0;               /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  EPON_XGEPN_XMAC_CTRL_XGEPN_PTP_VLAN1_t   XGEPN_PTP_VLAN1;               /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  EPON_XGEPN_XMAC_CTRL_XGEPN_RX_DBG_t      XGEPN_RX_DBG;                  /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  EPON_XGEPN_XMAC_CTRL_XGEPN_TX_DBG_t      XGEPN_TX_DBG;                  /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  EPON_XGEPN_XMAC_CTRL_XGEPN_RXFPGA_DROPCNT_t XGEPN_RXFPGA_DROPCNT;          /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];                   
  EPON_XGEPN_XMAC_CTRL_XGEPN_RXFPGA_FF_THRESHOLD_t XGEPN_RXFPGA_FF_THRESHOLD;     /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];                   
  EPON_XGEPN_XMAC_CTRL_XGEPN_TXFPGA_FF_THRESHOLD_t XGEPN_TXFPGA_FF_THRESHOLD;     /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];                   
  EPON_XGEPN_XMAC_CTRL_SPARE_t             SPARE;                         /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];                   
  EPON_XGEPN_XMAC_CTRL_SPARE1_t            SPARE1;                        /* addr: 0x000000a8 */
} APB1_EPON_XGEPN_XMAC_CTRL_t;

    
  
        
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* xmac */

typedef struct {
  APB1_EPON_XGEPN_XMAC_TXMAC_t             txmac;                         /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[151];                  
  APB1_EPON_XGEPN_XMAC_RXMAC_t             rxmac;                         /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd2[399];                  
  APB1_EPON_XGEPN_XMAC_CTRL_t              ctrl;                          /* addr: 0x00000250 */
} APB1_EPON_XGEPN_XMAC_t;


/*
 * XGPCS
 */
  
/*
 * tx
 */
        
#define EPON_XGEPN_XGPCS_TX_TXINT                0xd0031300
#define EPON_XGEPN_XGPCS_TX_TXINT_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t errorpktI            :  1 ; /* bits 0:0 */
    ca_uint32_t errorpktsatI         :  1 ; /* bits 1:1 */
    ca_uint32_t goodpktsatI          :  1 ; /* bits 2:2 */
    ca_uint32_t badburstendI         :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_TXINT_t;


#define EPON_XGEPN_XGPCS_TX_TXINTE0              0xd0031304
#define EPON_XGEPN_XGPCS_TX_TXINTE0_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t errorpktIE           :  1 ; /* bits 0:0 */
    ca_uint32_t errorpktsatIE        :  1 ; /* bits 1:1 */
    ca_uint32_t goodpktsatIE         :  1 ; /* bits 2:2 */
    ca_uint32_t badburstendIE        :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_TXINTE0_t;


#define EPON_XGEPN_XGPCS_TX_TXINTE1              0xd0031308
#define EPON_XGEPN_XGPCS_TX_TXINTE1_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t errorpktIE           :  1 ; /* bits 0:0 */
    ca_uint32_t errorpktsatIE        :  1 ; /* bits 1:1 */
    ca_uint32_t goodpktsatIE         :  1 ; /* bits 2:2 */
    ca_uint32_t badburstendIE        :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_TXINTE1_t;


#define EPON_XGEPN_XGPCS_TX_TXCNTRL              0xd003130c
#define EPON_XGEPN_XGPCS_TX_TXCNTRL_dft          0x02000004

typedef volatile union {
  struct {
    ca_uint32_t txcode_control       :  2 ; /* bits 1:0 */
    ca_uint32_t swap_tx_bus          :  1 ; /* bits 2:2 */
    ca_uint32_t scram_tx_dis         :  1 ; /* bits 3:3 */
    ca_uint32_t prb31_tx_disable_inversion :  1 ; /* bits 4:4 */
    ca_uint32_t tx_loopback          :  1 ; /* bits 5:5 */
    ca_uint32_t tx_estore_resync     :  1 ; /* bits 6:6 */
    ca_uint32_t test_tx_err          :  1 ; /* bits 7:7 */
    ca_uint32_t pcs6_tx_test         :  2 ; /* bits 9:8 */
    ca_uint32_t pseudo_tx_inv        :  1 ; /* bits 10:10 */
    ca_uint32_t square_tx_pat        :  4 ; /* bits 14:11 */
    ca_uint32_t logicReset           :  1 ; /* bits 15:15 */
    ca_uint32_t laserctrldelay       :  5 ; /* bits 20:16 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t laserctrlpolarity    :  1 ; /* bits 24:24 */
    ca_uint32_t close_laser_advance_en :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd2               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_TXCNTRL_t;

#define     square_tx_pat_Low                             0x0
#define     square_tx_pat_Square1                         0x1
#define     square_tx_pat_Square2                         0x2
#define     square_tx_pat_Square4                         0x3
#define     square_tx_pat_Square8                         0x4
#define     square_tx_pat_Square16                        0x5
#define     square_tx_pat_Pulse0                          0x6
#define     square_tx_pat_Pulse1                          0x7
#define     square_tx_pat_High                            0x8
#define     pcs6_tx_test_Normal                           0x0
#define     pcs6_tx_test_PRBS31                           0x1
#define     pcs6_tx_test_Square                           0x2
#define     pcs6_tx_test_Pseudo                           0x3
#define     txcode_control_Normal                         0x0
#define     txcode_control_Invert                         0x1
#define     txcode_control_Force_00                       0x2
#define     txcode_control_Force_11                       0x3

#define EPON_XGEPN_XGPCS_TX_TXSTATUS             0xd0031310
#define EPON_XGEPN_XGPCS_TX_TXSTATUS_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t errorpktsat          :  1 ; /* bits 1:1 */
    ca_uint32_t goodpktsat           :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd2               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_TXSTATUS_t;


#define EPON_XGEPN_XGPCS_TX_GOODPKT              0xd0031314
#define EPON_XGEPN_XGPCS_TX_GOODPKT_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t good_pktM_tx         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_GOODPKT_t;


#define EPON_XGEPN_XGPCS_TX_ERRPKT               0xd0031318
#define EPON_XGEPN_XGPCS_TX_ERRPKT_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t err_pktM_tx          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_ERRPKT_t;


#define EPON_XGEPN_XGPCS_TX_SEED_A1              0xd003131c
#define EPON_XGEPN_XGPCS_TX_SEED_A1_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pseudo_tx_A1         : 26 ; /* bits 25:0 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_SEED_A1_t;


#define EPON_XGEPN_XGPCS_TX_SEED_A0              0xd0031320
#define EPON_XGEPN_XGPCS_TX_SEED_A0_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pseudo_tx_A0         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_SEED_A0_t;


#define EPON_XGEPN_XGPCS_TX_SEED_B1              0xd0031324
#define EPON_XGEPN_XGPCS_TX_SEED_B1_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pseudo_tx_B1         : 26 ; /* bits 25:0 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_SEED_B1_t;


#define EPON_XGEPN_XGPCS_TX_SEED_B0              0xd0031328
#define EPON_XGEPN_XGPCS_TX_SEED_B0_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pseudo_tx_B0         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_SEED_B0_t;


#define EPON_XGEPN_XGPCS_TX_SEED_D1              0xd003132c
#define EPON_XGEPN_XGPCS_TX_SEED_D1_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pseudo_tx_D1         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_SEED_D1_t;


#define EPON_XGEPN_XGPCS_TX_SEED_D0              0xd0031330
#define EPON_XGEPN_XGPCS_TX_SEED_D0_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pseudo_tx_D0         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_SEED_D0_t;


#define EPON_XGEPN_XGPCS_TX_FMRO                 0xd0031334
#define EPON_XGEPN_XGPCS_TX_FMRO_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t fmro_rx_view         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t fmro_view_sel        :  5 ; /* bits 8:4 */
    ca_uint32_t rsrvd2               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_FMRO_t;

#define     fmro_view_sel_PCS6_XGMII_0                    0x0
#define     fmro_view_sel_PCS6_XGMII_1                    0x1
#define     fmro_view_sel_PCS6_XGMII_2                    0x2
#define     fmro_view_sel_PCS6_XGMII_3                    0x3
#define     fmro_view_sel_PCS6_XGMII_4                    0x4
#define     fmro_view_sel_PCS6_XGMII_5                    0x5
#define     fmro_view_sel_PCS6_XGMII_6                    0x6
#define     fmro_view_sel_PCS6_XGMII_7                    0x7
#define     fmro_view_sel_PCS6_CODE_0                     0x8
#define     fmro_view_sel_PCS6_CODE_1                     0x9
#define     fmro_view_sel_PCS6_CODE_2                     0xa
#define     fmro_view_sel_PCS6_CODE_3                     0xb
#define     fmro_view_sel_PCS6_LINE_0                     0xc
#define     fmro_view_sel_PCS6_LINE_1                     0xd
#define     fmro_rx_view_PCS6_Transmit                    0x0
#define     fmro_rx_view_PCS6_Receive                     0x1

#define EPON_XGEPN_XGPCS_TX_PCSERRINS            0xd0031338
#define EPON_XGEPN_XGPCS_TX_PCSERRINS_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t LOCATION             :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t TYPE                 :  4 ; /* bits 11:8 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t SINGLE               :  1 ; /* bits 14:14 */
    ca_uint32_t ENABLE               :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd3               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_PCSERRINS_t;


#define EPON_XGEPN_XGPCS_TX_TXDISFEC             0xd003133c
#define EPON_XGEPN_XGPCS_TX_TXDISFEC_dft         0x0000f03c

typedef volatile union {
  struct {
    ca_uint32_t disableFEC           :  1 ; /* bits 0:0 */
    ca_uint32_t swap_before_fec      :  1 ; /* bits 1:1 */
    ca_uint32_t swap_before_fec_encoder :  1 ; /* bits 2:2 */
    ca_uint32_t swap_after_fec_encoder :  1 ; /* bits 3:3 */
    ca_uint32_t EOBTerminatorLength  :  8 ; /* bits 11:4 */
    ca_uint32_t error_inject_count   :  4 ; /* bits 15:12 */
    ca_uint32_t tx_fec_bypass_delay_mode :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_TXDISFEC_t;


#define EPON_XGEPN_XGPCS_TX_PKTGEN_MEM_ACCESS    0xd0031340
#define EPON_XGEPN_XGPCS_TX_PKTGEN_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t CPUPktEn_OnuSPLen    :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_PKTGEN_MEM_ACCESS_t;


#define EPON_XGEPN_XGPCS_TX_PKTGEN_MEM_DATA2     0xd0031344
#define EPON_XGEPN_XGPCS_TX_PKTGEN_MEM_DATA2_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t PktData              :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_PKTGEN_MEM_DATA2_t;


#define EPON_XGEPN_XGPCS_TX_PKTGEN_MEM_DATA1     0xd0031348
#define EPON_XGEPN_XGPCS_TX_PKTGEN_MEM_DATA1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t PktData              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_PKTGEN_MEM_DATA1_t;


#define EPON_XGEPN_XGPCS_TX_PKTGEN_MEM_DATA0     0xd003134c
#define EPON_XGEPN_XGPCS_TX_PKTGEN_MEM_DATA0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t PktData              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_PKTGEN_MEM_DATA0_t;


#define EPON_XGEPN_XGPCS_TX_StartDeque           0xd0031350
#define EPON_XGEPN_XGPCS_TX_StartDeque_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t init                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_StartDeque_t;


#define EPON_XGEPN_XGPCS_TX_CPUPktEn             0xd0031354
#define EPON_XGEPN_XGPCS_TX_CPUPktEn_dft         0x00000052

typedef volatile union {
  struct {
    ca_uint32_t Enable               :  1 ; /* bits 0:0 */
    ca_uint32_t NumLines             :  5 ; /* bits 5:1 */
    ca_uint32_t NumPkts              :  9 ; /* bits 14:6 */
    ca_uint32_t SendForever          :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_CPUPktEn_t;


#define EPON_XGEPN_XGPCS_TX_BERMonitor           0xd0031358
#define EPON_XGEPN_XGPCS_TX_BERMonitor_dft       0x00000019

typedef volatile union {
  struct {
    ca_uint32_t Window               :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_BERMonitor_t;


#define EPON_XGEPN_XGPCS_TX_FEC_MASK_MEM_SW_ACCESS 0xd003135c
#define EPON_XGEPN_XGPCS_TX_FEC_MASK_MEM_SW_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t MASK_MEM_ADDR        :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t w_rdn                :  1 ; /* bits 30:30 */
    ca_uint32_t ACCESS               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_FEC_MASK_MEM_SW_ACCESS_t;


#define EPON_XGEPN_XGPCS_TX_FEC_MASK_MEM_SW_DATA2 0xd0031360
#define EPON_XGEPN_XGPCS_TX_FEC_MASK_MEM_SW_DATA2_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t MASK_MEM_DATA        :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_FEC_MASK_MEM_SW_DATA2_t;


#define EPON_XGEPN_XGPCS_TX_FEC_MASK_MEM_SW_DATA1 0xd0031364
#define EPON_XGEPN_XGPCS_TX_FEC_MASK_MEM_SW_DATA1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t MASK_MEM_DATA        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_FEC_MASK_MEM_SW_DATA1_t;


#define EPON_XGEPN_XGPCS_TX_FEC_MASK_MEM_SW_DATA0 0xd0031368
#define EPON_XGEPN_XGPCS_TX_FEC_MASK_MEM_SW_DATA0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t MASK_MEM_DATA        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_FEC_MASK_MEM_SW_DATA0_t;


#define EPON_XGEPN_XGPCS_TX_FEC_ERROR_INJECT     0xd003136c
#define EPON_XGEPN_XGPCS_TX_FEC_ERROR_INJECT_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t enable               :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_FEC_ERROR_INJECT_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* tx */
typedef struct {
  EPON_XGEPN_XGPCS_TX_TXINT_t              TXINT;                         /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  EPON_XGEPN_XGPCS_TX_TXINTE0_t            TXINTE0;                       /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  EPON_XGEPN_XGPCS_TX_TXINTE1_t            TXINTE1;                       /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  EPON_XGEPN_XGPCS_TX_TXCNTRL_t            TXCNTRL;                       /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  EPON_XGEPN_XGPCS_TX_TXSTATUS_t           TXSTATUS;                      /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  EPON_XGEPN_XGPCS_TX_GOODPKT_t            GOODPKT;                       /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  EPON_XGEPN_XGPCS_TX_ERRPKT_t             ERRPKT;                        /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  EPON_XGEPN_XGPCS_TX_SEED_A1_t            SEED_A1;                       /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  EPON_XGEPN_XGPCS_TX_SEED_A0_t            SEED_A0;                       /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  EPON_XGEPN_XGPCS_TX_SEED_B1_t            SEED_B1;                       /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  EPON_XGEPN_XGPCS_TX_SEED_B0_t            SEED_B0;                       /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  EPON_XGEPN_XGPCS_TX_SEED_D1_t            SEED_D1;                       /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  EPON_XGEPN_XGPCS_TX_SEED_D0_t            SEED_D0;                       /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  EPON_XGEPN_XGPCS_TX_FMRO_t               FMRO;                          /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  EPON_XGEPN_XGPCS_TX_PCSERRINS_t          PCSERRINS;                     /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  EPON_XGEPN_XGPCS_TX_TXDISFEC_t           TXDISFEC;                      /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  EPON_XGEPN_XGPCS_TX_PKTGEN_MEM_ACCESS_t  PKTGEN_MEM_ACCESS;             /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  EPON_XGEPN_XGPCS_TX_PKTGEN_MEM_DATA2_t   PKTGEN_MEM_DATA2;              /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  EPON_XGEPN_XGPCS_TX_PKTGEN_MEM_DATA1_t   PKTGEN_MEM_DATA1;              /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  EPON_XGEPN_XGPCS_TX_PKTGEN_MEM_DATA0_t   PKTGEN_MEM_DATA0;              /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  EPON_XGEPN_XGPCS_TX_StartDeque_t         StartDeque;                    /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  EPON_XGEPN_XGPCS_TX_CPUPktEn_t           CPUPktEn;                      /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  EPON_XGEPN_XGPCS_TX_BERMonitor_t         BERMonitor;                    /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  EPON_XGEPN_XGPCS_TX_FEC_MASK_MEM_SW_ACCESS_t FEC_MASK_MEM_SW_ACCESS;        /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  EPON_XGEPN_XGPCS_TX_FEC_MASK_MEM_SW_DATA2_t FEC_MASK_MEM_SW_DATA2;         /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  EPON_XGEPN_XGPCS_TX_FEC_MASK_MEM_SW_DATA1_t FEC_MASK_MEM_SW_DATA1;         /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  EPON_XGEPN_XGPCS_TX_FEC_MASK_MEM_SW_DATA0_t FEC_MASK_MEM_SW_DATA0;         /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  EPON_XGEPN_XGPCS_TX_FEC_ERROR_INJECT_t   FEC_ERROR_INJECT;              /* addr: 0x0000006c */
} APB1_EPON_XGEPN_XGPCS_TX_t;


/*
 * rx
 */
        
#define EPON_XGEPN_XGPCS_RX_RXINT                0xd0031370
#define EPON_XGEPN_XGPCS_RX_RXINT_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t errorpktI            :  1 ; /* bits 0:0 */
    ca_uint32_t errorpktsatI         :  1 ; /* bits 1:1 */
    ca_uint32_t goodpktsatI          :  1 ; /* bits 2:2 */
    ca_uint32_t errordecI            :  1 ; /* bits 3:3 */
    ca_uint32_t errordecsatI         :  1 ; /* bits 4:4 */
    ca_uint32_t errorpatI            :  1 ; /* bits 5:5 */
    ca_uint32_t errorpatsatI         :  1 ; /* bits 6:6 */
    ca_uint32_t errorbersatI         :  1 ; /* bits 7:7 */
    ca_uint32_t syncdetI             :  1 ; /* bits 8:8 */
    ca_uint32_t berhighI             :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t patsyncI             :  1 ; /* bits 11:11 */
    ca_uint32_t fecdeccorrsatI       :  1 ; /* bits 12:12 */
    ca_uint32_t fecdecuncorrsatI     :  1 ; /* bits 13:13 */
    ca_uint32_t fecdecpersistfailI   :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t linkdown             :  1 ; /* bits 17:17 */
    ca_uint32_t linkup               :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd3               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_RXINT_t;


#define EPON_XGEPN_XGPCS_RX_RXINTE0              0xd0031374
#define EPON_XGEPN_XGPCS_RX_RXINTE0_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t errorpktIE           :  1 ; /* bits 0:0 */
    ca_uint32_t errorpktsatIE        :  1 ; /* bits 1:1 */
    ca_uint32_t goodpktsatIE         :  1 ; /* bits 2:2 */
    ca_uint32_t errordecIE           :  1 ; /* bits 3:3 */
    ca_uint32_t errordecsatIE        :  1 ; /* bits 4:4 */
    ca_uint32_t errorpatIE           :  1 ; /* bits 5:5 */
    ca_uint32_t errorpatsatIE        :  1 ; /* bits 6:6 */
    ca_uint32_t errorbersatIE        :  1 ; /* bits 7:7 */
    ca_uint32_t syncdetIE            :  1 ; /* bits 8:8 */
    ca_uint32_t berhighIE            :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t patsyncIE            :  1 ; /* bits 11:11 */
    ca_uint32_t fecdeccorrsatIE      :  1 ; /* bits 12:12 */
    ca_uint32_t fecdecuncorrsatIE    :  1 ; /* bits 13:13 */
    ca_uint32_t fecdecpersistfailIE  :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t linkdownE            :  1 ; /* bits 17:17 */
    ca_uint32_t linkupE              :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd3               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_RXINTE0_t;


#define EPON_XGEPN_XGPCS_RX_RXINTE1              0xd0031378
#define EPON_XGEPN_XGPCS_RX_RXINTE1_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t errorpktIE           :  1 ; /* bits 0:0 */
    ca_uint32_t errorpktsatIE        :  1 ; /* bits 1:1 */
    ca_uint32_t goodpktsatIE         :  1 ; /* bits 2:2 */
    ca_uint32_t errordecIE           :  1 ; /* bits 3:3 */
    ca_uint32_t errordecsatIE        :  1 ; /* bits 4:4 */
    ca_uint32_t errorpatIE           :  1 ; /* bits 5:5 */
    ca_uint32_t errorpatsatIE        :  1 ; /* bits 6:6 */
    ca_uint32_t errorbersatIE        :  1 ; /* bits 7:7 */
    ca_uint32_t syncdetIE            :  1 ; /* bits 8:8 */
    ca_uint32_t berhighIE            :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t patsyncIE            :  1 ; /* bits 11:11 */
    ca_uint32_t fecdeccorrsatIE      :  1 ; /* bits 12:12 */
    ca_uint32_t fecdecuncorrsatIE    :  1 ; /* bits 13:13 */
    ca_uint32_t fecdecpersistfailIE  :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t linkdownE            :  1 ; /* bits 17:17 */
    ca_uint32_t linkupE              :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd3               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_RXINTE1_t;


#define EPON_XGEPN_XGPCS_RX_RXCNTRL              0xd003137c
#define EPON_XGEPN_XGPCS_RX_RXCNTRL_dft          0x00005004

typedef volatile union {
  struct {
    ca_uint32_t rx_loopback          :  1 ; /* bits 0:0 */
    ca_uint32_t rx_estore_resync     :  1 ; /* bits 1:1 */
    ca_uint32_t swap_rx_bus          :  1 ; /* bits 2:2 */
    ca_uint32_t descram_rx_dis       :  1 ; /* bits 3:3 */
    ca_uint32_t prb31_rx_disable_inversion :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t pcs6_rx_test         :  2 ; /* bits 9:8 */
    ca_uint32_t pseudo_rx_inv        :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t latchEach1e          :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t dontFilterFsig       :  1 ; /* bits 14:14 */
    ca_uint32_t logicReset           :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd4               : 15 ;
    ca_uint32_t link_sel             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_RXCNTRL_t;

#define     pcs6_rx_test_Normal                           0x0
#define     pcs6_rx_test_PRBS31                           0x1
#define     pcs6_rx_test_Reserved                         0x2
#define     pcs6_rx_test_Pseudo                           0x3

#define EPON_XGEPN_XGPCS_RX_RXSTATUS             0xd0031380
#define EPON_XGEPN_XGPCS_RX_RXSTATUS_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t errorpktsat          :  1 ; /* bits 1:1 */
    ca_uint32_t goodpktsat           :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t errordecsat          :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t errorpatsat          :  1 ; /* bits 6:6 */
    ca_uint32_t errorbersat          :  1 ; /* bits 7:7 */
    ca_uint32_t syncdetS             :  1 ; /* bits 8:8 */
    ca_uint32_t berhighS             :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd4               :  1 ;
    ca_uint32_t patsyncS             :  1 ; /* bits 11:11 */
    ca_uint32_t fecdeccorrsat        :  1 ; /* bits 12:12 */
    ca_uint32_t fecdecuncorrsat      :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd5               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_RXSTATUS_t;


#define EPON_XGEPN_XGPCS_RX_GOODPKT              0xd0031384
#define EPON_XGEPN_XGPCS_RX_GOODPKT_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t good_pktM_rx         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_GOODPKT_t;


#define EPON_XGEPN_XGPCS_RX_ERRPKT               0xd0031388
#define EPON_XGEPN_XGPCS_RX_ERRPKT_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t err_pktM_rx          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_ERRPKT_t;


#define EPON_XGEPN_XGPCS_RX_ERRPAT               0xd003138c
#define EPON_XGEPN_XGPCS_RX_ERRPAT_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t err_pat_rx           : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_ERRPAT_t;


#define EPON_XGEPN_XGPCS_RX_ERRDEC               0xd0031390
#define EPON_XGEPN_XGPCS_RX_ERRDEC_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t err_dec_rx           : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_ERRDEC_t;


#define EPON_XGEPN_XGPCS_RX_ERRBER               0xd0031394
#define EPON_XGEPN_XGPCS_RX_ERRBER_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t err_ber_rx           : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_ERRBER_t;


#define EPON_XGEPN_XGPCS_RX_FECCORCODE           0xd0031398
#define EPON_XGEPN_XGPCS_RX_FECCORCODE_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t fec_corcodM_rx       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_FECCORCODE_t;


#define EPON_XGEPN_XGPCS_RX_FECUNCORCODE         0xd003139c
#define EPON_XGEPN_XGPCS_RX_FECUNCORCODE_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t fec_uncorcodM_rx     : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_FECUNCORCODE_t;


#define EPON_XGEPN_XGPCS_RX_SYNOFF               0xd00313a0
#define EPON_XGEPN_XGPCS_RX_SYNOFF_dft           0x00000100

typedef volatile union {
  struct {
    ca_uint32_t sync_valid_off       :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t sync_invalid_off     :  4 ; /* bits 11:8 */
    ca_uint32_t rsrvd2               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_SYNOFF_t;


#define EPON_XGEPN_XGPCS_RX_SEED_A1              0xd00313a4
#define EPON_XGEPN_XGPCS_RX_SEED_A1_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pseudo_rx_A1         : 26 ; /* bits 25:0 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_SEED_A1_t;


#define EPON_XGEPN_XGPCS_RX_SEED_A0              0xd00313a8
#define EPON_XGEPN_XGPCS_RX_SEED_A0_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pseudo_rx_A0         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_SEED_A0_t;


#define EPON_XGEPN_XGPCS_RX_SEED_B1              0xd00313ac
#define EPON_XGEPN_XGPCS_RX_SEED_B1_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pseudo_rx_B1         : 26 ; /* bits 25:0 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_SEED_B1_t;


#define EPON_XGEPN_XGPCS_RX_SEED_B0              0xd00313b0
#define EPON_XGEPN_XGPCS_RX_SEED_B0_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pseudo_rx_B0         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_SEED_B0_t;


#define EPON_XGEPN_XGPCS_RX_SEED_D1              0xd00313b4
#define EPON_XGEPN_XGPCS_RX_SEED_D1_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pseudo_rx_D1         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_SEED_D1_t;


#define EPON_XGEPN_XGPCS_RX_SEED_D0              0xd00313b8
#define EPON_XGEPN_XGPCS_RX_SEED_D0_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pseudo_rx_D0         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_SEED_D0_t;


#define EPON_XGEPN_XGPCS_RX_FECCNTRL             0xd00313bc
#define EPON_XGEPN_XGPCS_RX_FECCNTRL_dft         0x00000023

typedef volatile union {
  struct {
    ca_uint32_t persist_dec_fail_threshold :  3 ; /* bits 2:0 */
    ca_uint32_t disableFECcorrection :  1 ; /* bits 3:3 */
    ca_uint32_t disableFECtotal      :  1 ; /* bits 4:4 */
    ca_uint32_t mark_uncorrectable   :  1 ; /* bits 5:5 */
    ca_uint32_t swap_PCS65_block     :  1 ; /* bits 6:6 */
    ca_uint32_t swap_8bits_data_symbol :  1 ; /* bits 7:7 */
    ca_uint32_t swap_8bits_parity_symbol :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               : 10 ;
    ca_uint32_t rx_fec_bypass_delay_mode :  1 ; /* bits 19:19 */
    ca_uint32_t rsrvd2               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_FECCNTRL_t;


#define EPON_XGEPN_XGPCS_RX_BER_THRESHOLD        0xd00313c0
#define EPON_XGEPN_XGPCS_RX_BER_THRESHOLD_dft    0x00000640

typedef volatile union {
  struct {
    ca_uint32_t sync_ber_threshold   : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_BER_THRESHOLD_t;


#define EPON_XGEPN_XGPCS_RX_DEBUG_CONFIG_REG     0xd00313c4
#define EPON_XGEPN_XGPCS_RX_DEBUG_CONFIG_REG_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mask_hiber           :  1 ; /* bits 0:0 */
    ca_uint32_t slip_manual_mode     :  1 ; /* bits 1:1 */
    ca_uint32_t rx_fec_bypass        :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_DEBUG_CONFIG_REG_t;


#define EPON_XGEPN_XGPCS_RX_DEBUG_TRIG_REG       0xd00313c8
#define EPON_XGEPN_XGPCS_RX_DEBUG_TRIG_REG_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t trigger_slip         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_DEBUG_TRIG_REG_t;


#define EPON_XGEPN_XGPCS_RX_XGEPN_LINK_DETECT_CFG 0xd00313cc
#define EPON_XGEPN_XGPCS_RX_XGEPN_LINK_DETECT_CFG_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t detect_mode          :  1 ; /* bits 0:0 */
    ca_uint32_t opt_los_polarity     :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  6 ;
    ca_uint32_t detect_period        :  6 ; /* bits 13:8 */
    ca_uint32_t rsrvd2               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_XGEPN_LINK_DETECT_CFG_t;


#define EPON_XGEPN_XGPCS_RX_XGEPN_LINK_STATUS    0xd00313d0
#define EPON_XGEPN_XGPCS_RX_XGEPN_LINK_STATUS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t link_status          :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_XGEPN_LINK_STATUS_t;


#define EPON_XGEPN_XGPCS_RX_FECCORRBYTE          0xd00313d4
#define EPON_XGEPN_XGPCS_RX_FECCORRBYTE_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_FECCORRBYTE_t;


#define EPON_XGEPN_XGPCS_RX_FECTOTALCODE         0xd00313d8
#define EPON_XGEPN_XGPCS_RX_FECTOTALCODE_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_FECTOTALCODE_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* rx */
typedef struct {
  EPON_XGEPN_XGPCS_RX_RXINT_t              RXINT;                         /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  EPON_XGEPN_XGPCS_RX_RXINTE0_t            RXINTE0;                       /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  EPON_XGEPN_XGPCS_RX_RXINTE1_t            RXINTE1;                       /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  EPON_XGEPN_XGPCS_RX_RXCNTRL_t            RXCNTRL;                       /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  EPON_XGEPN_XGPCS_RX_RXSTATUS_t           RXSTATUS;                      /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  EPON_XGEPN_XGPCS_RX_GOODPKT_t            GOODPKT;                       /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  EPON_XGEPN_XGPCS_RX_ERRPKT_t             ERRPKT;                        /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  EPON_XGEPN_XGPCS_RX_ERRPAT_t             ERRPAT;                        /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  EPON_XGEPN_XGPCS_RX_ERRDEC_t             ERRDEC;                        /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  EPON_XGEPN_XGPCS_RX_ERRBER_t             ERRBER;                        /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  EPON_XGEPN_XGPCS_RX_FECCORCODE_t         FECCORCODE;                    /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  EPON_XGEPN_XGPCS_RX_FECUNCORCODE_t       FECUNCORCODE;                  /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  EPON_XGEPN_XGPCS_RX_SYNOFF_t             SYNOFF;                        /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  EPON_XGEPN_XGPCS_RX_SEED_A1_t            SEED_A1;                       /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  EPON_XGEPN_XGPCS_RX_SEED_A0_t            SEED_A0;                       /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  EPON_XGEPN_XGPCS_RX_SEED_B1_t            SEED_B1;                       /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  EPON_XGEPN_XGPCS_RX_SEED_B0_t            SEED_B0;                       /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  EPON_XGEPN_XGPCS_RX_SEED_D1_t            SEED_D1;                       /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  EPON_XGEPN_XGPCS_RX_SEED_D0_t            SEED_D0;                       /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  EPON_XGEPN_XGPCS_RX_FECCNTRL_t           FECCNTRL;                      /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  EPON_XGEPN_XGPCS_RX_BER_THRESHOLD_t      BER_THRESHOLD;                 /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  EPON_XGEPN_XGPCS_RX_DEBUG_CONFIG_REG_t   DEBUG_CONFIG_REG;              /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  EPON_XGEPN_XGPCS_RX_DEBUG_TRIG_REG_t     DEBUG_TRIG_REG;                /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  EPON_XGEPN_XGPCS_RX_XGEPN_LINK_DETECT_CFG_t XGEPN_LINK_DETECT_CFG;         /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  EPON_XGEPN_XGPCS_RX_XGEPN_LINK_STATUS_t  XGEPN_LINK_STATUS;             /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  EPON_XGEPN_XGPCS_RX_FECCORRBYTE_t        FECCORRBYTE;                   /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  EPON_XGEPN_XGPCS_RX_FECTOTALCODE_t       FECTOTALCODE;                  /* addr: 0x00000068 */
} APB1_EPON_XGEPN_XGPCS_RX_t;

    
  
        
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* XGPCS */

typedef struct {
  APB1_EPON_XGEPN_XGPCS_TX_t               tx;                            /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[57];                   
  APB1_EPON_XGEPN_XGPCS_RX_t               rx;                            /* addr: 0x00000070 */
} APB1_EPON_XGEPN_XGPCS_t;


/*
 * CORESEC10_TOP[0..1]
 */
  
/*
 * NANDI
 */
        
#define EPON_XGEPN_CORESEC10_TOP_NANDI_INTERRUPT_0 0xd0031420
#define EPON_XGEPN_CORESEC10_TOP_NANDI_INTERRUPT_0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cpu_cmd_executed     :  1 ; /* bits 0:0 */
    ca_uint32_t pn_thld_reached      :  1 ; /* bits 1:1 */
    ca_uint32_t key_hash_mem_rd_err  :  1 ; /* bits 2:2 */
    ca_uint32_t key_hash_mem_rd_Cerr :  1 ; /* bits 3:3 */
    ca_uint32_t cntl_mem_rd_err      :  1 ; /* bits 4:4 */
    ca_uint32_t cntl_mem_rd_Cerr     :  1 ; /* bits 5:5 */
    ca_uint32_t pn_mem_rd_err        :  1 ; /* bits 6:6 */
    ca_uint32_t pn_mem_rd_Cerr       :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_INTERRUPT_0_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_INTENABLE_0 0xd0031424
#define EPON_XGEPN_CORESEC10_TOP_NANDI_INTENABLE_0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cpu_cmd_executed_E   :  1 ; /* bits 0:0 */
    ca_uint32_t pn_thld_reached_E    :  1 ; /* bits 1:1 */
    ca_uint32_t key_hash_mem_rd_err_E :  1 ; /* bits 2:2 */
    ca_uint32_t key_hash_mem_rd_Cerr_E :  1 ; /* bits 3:3 */
    ca_uint32_t cntl_mem_rd_err_E    :  1 ; /* bits 4:4 */
    ca_uint32_t cntl_mem_rd_Cerr_E   :  1 ; /* bits 5:5 */
    ca_uint32_t pn_mem_rd_err_E      :  1 ; /* bits 6:6 */
    ca_uint32_t pn_mem_rd_Cerr_E     :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_INTENABLE_0_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_INTERRUPT_1 0xd0031428
#define EPON_XGEPN_CORESEC10_TOP_NANDI_INTERRUPT_1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cpu_cmd_executed     :  1 ; /* bits 0:0 */
    ca_uint32_t pn_thld_reached      :  1 ; /* bits 1:1 */
    ca_uint32_t key_hash_mem_rd_err  :  1 ; /* bits 2:2 */
    ca_uint32_t key_hash_mem_rd_Cerr :  1 ; /* bits 3:3 */
    ca_uint32_t cntl_mem_rd_err      :  1 ; /* bits 4:4 */
    ca_uint32_t cntl_mem_rd_Cerr     :  1 ; /* bits 5:5 */
    ca_uint32_t pn_mem_rd_err        :  1 ; /* bits 6:6 */
    ca_uint32_t pn_mem_rd_Cerr       :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_INTERRUPT_1_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_INTENABLE_1 0xd003142c
#define EPON_XGEPN_CORESEC10_TOP_NANDI_INTENABLE_1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cpu_cmd_executed_E   :  1 ; /* bits 0:0 */
    ca_uint32_t pn_thld_reached_E    :  1 ; /* bits 1:1 */
    ca_uint32_t key_hash_mem_rd_err_E :  1 ; /* bits 2:2 */
    ca_uint32_t key_hash_mem_rd_Cerr_E :  1 ; /* bits 3:3 */
    ca_uint32_t cntl_mem_rd_err_E    :  1 ; /* bits 4:4 */
    ca_uint32_t cntl_mem_rd_Cerr_E   :  1 ; /* bits 5:5 */
    ca_uint32_t pn_mem_rd_err_E      :  1 ; /* bits 6:6 */
    ca_uint32_t pn_mem_rd_Cerr_E     :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_INTENABLE_1_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_CONFIG    0xd0031430
#define EPON_XGEPN_CORESEC10_TOP_NANDI_CONFIG_dft 0x00000002

typedef volatile union {
  struct {
    ca_uint32_t sec_tag_mem_cmd      :  1 ; /* bits 0:0 */
    ca_uint32_t sec_tag_icv_send_en  :  1 ; /* bits 1:1 */
    ca_uint32_t sci_llid_disable     :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_CONFIG_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_STATUS    0xd0031434
#define EPON_XGEPN_CORESEC10_TOP_NANDI_STATUS_dft 0x00000001

typedef volatile union {
  struct {
    ca_uint32_t mem_init_done        :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_STATUS_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_COMMAND_CONTROL 0xd0031438
#define EPON_XGEPN_CORESEC10_TOP_NANDI_COMMAND_CONTROL_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t start_write          :  1 ; /* bits 0:0 */
    ca_uint32_t rwn                  :  1 ; /* bits 1:1 */
    ca_uint32_t said                 : 10 ; /* bits 11:2 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_COMMAND_CONTROL_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY0_3 0xd003143c
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY0_3_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key03                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY0_3_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY0_2 0xd0031440
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY0_2_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key02                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY0_2_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY0_1 0xd0031444
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY0_1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key01                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY0_1_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY0_0 0xd0031448
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY0_0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key00                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY0_0_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH0_3 0xd003144c
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH0_3_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hash03               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH0_3_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH0_2 0xd0031450
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH0_2_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hash02               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH0_2_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH0_1 0xd0031454
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH0_1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hash01               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH0_1_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH0_0 0xd0031458
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH0_0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hash00               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH0_0_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY1_3 0xd003145c
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY1_3_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key13                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY1_3_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY1_2 0xd0031460
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY1_2_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key12                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY1_2_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY1_1 0xd0031464
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY1_1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key11                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY1_1_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY1_0 0xd0031468
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY1_0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key10                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY1_0_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH1_3 0xd003146c
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH1_3_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hash13               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH1_3_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH1_2 0xd0031470
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH1_2_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hash12               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH1_2_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH1_1 0xd0031474
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH1_1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hash11               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH1_1_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH1_0 0xd0031478
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH1_0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hash10               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH1_0_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_PacketNumber 0xd003147c
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_PacketNumber_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pn                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_PacketNumber_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_NextPacketNumber 0xd0031480
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_NextPacketNumber_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t npn                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_NextPacketNumber_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_Control 0xd0031484
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_Control_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t control              : 17 ; /* bits 16:0 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_Control_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_DATAFIELD_VALID 0xd0031488
#define EPON_XGEPN_CORESEC10_TOP_NANDI_DATAFIELD_VALID_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key0_vld             :  1 ; /* bits 0:0 */
    ca_uint32_t hash0_vld            :  1 ; /* bits 1:1 */
    ca_uint32_t key1_vld             :  1 ; /* bits 2:2 */
    ca_uint32_t hash1_vld            :  1 ; /* bits 3:3 */
    ca_uint32_t sc_vld               :  1 ; /* bits 4:4 */
    ca_uint32_t pn_vld               :  1 ; /* bits 5:5 */
    ca_uint32_t npn_vld              :  1 ; /* bits 6:6 */
    ca_uint32_t an_vld               :  1 ; /* bits 7:7 */
    ca_uint32_t scb_vld              :  1 ; /* bits 8:8 */
    ca_uint32_t es_vld               :  1 ; /* bits 9:9 */
    ca_uint32_t co_vld               :  1 ; /* bits 10:10 */
    ca_uint32_t rlyen_vld            :  1 ; /* bits 11:11 */
    ca_uint32_t sec_mode_vld         :  1 ; /* bits 12:12 */
    ca_uint32_t v_config_vld         :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_DATAFIELD_VALID_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SCI1      0xd003148c
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SCI1_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t SCI1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SCI1_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SCI0      0xd0031490
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SCI0_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t SCI0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SCI0_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_PNTHLD    0xd0031494
#define EPON_XGEPN_CORESEC10_TOP_NANDI_PNTHLD_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t PN_threshold         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_PNTHLD_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_REPLAYWINDOW 0xd0031498
#define EPON_XGEPN_CORESEC10_TOP_NANDI_REPLAYWINDOW_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t replay_window        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_REPLAYWINDOW_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* NANDI */
typedef struct {
  EPON_XGEPN_CORESEC10_TOP_NANDI_INTERRUPT_0_t INTERRUPT_0;                   /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  EPON_XGEPN_CORESEC10_TOP_NANDI_INTENABLE_0_t INTENABLE_0;                   /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  EPON_XGEPN_CORESEC10_TOP_NANDI_INTERRUPT_1_t INTERRUPT_1;                   /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  EPON_XGEPN_CORESEC10_TOP_NANDI_INTENABLE_1_t INTENABLE_1;                   /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  EPON_XGEPN_CORESEC10_TOP_NANDI_CONFIG_t  CONFIG;                        /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  EPON_XGEPN_CORESEC10_TOP_NANDI_STATUS_t  STATUS;                        /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  EPON_XGEPN_CORESEC10_TOP_NANDI_COMMAND_CONTROL_t COMMAND_CONTROL;               /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY0_3_t SADB_KEY0_3;                   /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY0_2_t SADB_KEY0_2;                   /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY0_1_t SADB_KEY0_1;                   /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY0_0_t SADB_KEY0_0;                   /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH0_3_t SADB_HASH0_3;                  /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH0_2_t SADB_HASH0_2;                  /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH0_1_t SADB_HASH0_1;                  /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH0_0_t SADB_HASH0_0;                  /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY1_3_t SADB_KEY1_3;                   /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY1_2_t SADB_KEY1_2;                   /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY1_1_t SADB_KEY1_1;                   /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY1_0_t SADB_KEY1_0;                   /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH1_3_t SADB_HASH1_3;                  /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH1_2_t SADB_HASH1_2;                  /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH1_1_t SADB_HASH1_1;                  /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH1_0_t SADB_HASH1_0;                  /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_PacketNumber_t SADB_PacketNumber;             /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_NextPacketNumber_t SADB_NextPacketNumber;         /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_Control_t SADB_Control;                  /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_DATAFIELD_VALID_t DATAFIELD_VALID;               /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_SCI1_t    SCI1;                          /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_SCI0_t    SCI0;                          /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_PNTHLD_t  PNTHLD;                        /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_REPLAYWINDOW_t REPLAYWINDOW;                  /* addr: 0x00000078 */
} APB1_EPON_XGEPN_CORESEC10_TOP_NANDI_t;


/*
 * CORESEC10
 */
        
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_INTERRUPT_0 0xd00314c0
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_INTERRUPT_0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t macsec_dec_err       :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_INTERRUPT_0_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_INTERRUPT_ENABLE_0 0xd00314c4
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_INTERRUPT_ENABLE_0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t macsec_dec_err_en    :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_INTERRUPT_ENABLE_0_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_INTERRUPT_1 0xd00314c8
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_INTERRUPT_1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t macsec_dec_err       :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_INTERRUPT_1_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_INTERRUPT_ENABLE_1 0xd00314cc
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_INTERRUPT_ENABLE_1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t macsec_dec_err_en    :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_INTERRUPT_ENABLE_1_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_CORESEC10_GLOBAL_CONFIG 0xd00314d0
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_CORESEC10_GLOBAL_CONFIG_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t disable_crc8_chk     :  1 ; /* bits 0:0 */
    ca_uint32_t key_exhange_mode     :  1 ; /* bits 1:1 */
    ca_uint32_t dis_drop_macsec_err_ptk :  1 ; /* bits 2:2 */
    ca_uint32_t dis_preamble_chk     :  1 ; /* bits 3:3 */
    ca_uint32_t dis_crc32_chk        :  1 ; /* bits 4:4 */
    ca_uint32_t cfg_dont_modify_crc32 :  1 ; /* bits 5:5 */
    ca_uint32_t cfg_mask_dec_err     :  1 ; /* bits 6:6 */
    ca_uint32_t soft_reset           :  1 ; /* bits 7:7 */
    ca_uint32_t en_co_error          :  1 ; /* bits 8:8 */
    ca_uint32_t drop_untag_pkt_mode  :  2 ; /* bits 10:9 */
    ca_uint32_t debug_bus_sel        :  3 ; /* bits 13:11 */
    ca_uint32_t dis_ver0_macsec_err  :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_CORESEC10_GLOBAL_CONFIG_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_CORESEC10_MPCP_TIMER_ADJUST 0xd00314d4
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_CORESEC10_MPCP_TIMER_ADJUST_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mpcp_timer_comp_mac_coresec_10 :  5 ; /* bits 4:0 */
    ca_uint32_t mpcp_timer_comp_coresec_10 :  2 ; /* bits 6:5 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_CORESEC10_MPCP_TIMER_ADJUST_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_SA_0  0xd00314d8
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_SA_0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t local_sa_reg0        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_SA_0_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_SA_1  0xd00314dc
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_SA_1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t local_sa_reg1        : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 15 ;
    ca_uint32_t sel_local_sa_reg     :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_SA_1_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_NOT_DROP_ETHERTYPE 0xd00314e0
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_NOT_DROP_ETHERTYPE_dft 0x00030000

typedef volatile union {
  struct {
    ca_uint32_t user_defined         : 16 ; /* bits 15:0 */
    ca_uint32_t no_drop_oam          :  1 ; /* bits 16:16 */
    ca_uint32_t no_drop_mpcp         :  1 ; /* bits 17:17 */
    ca_uint32_t no_drop_802_1x       :  1 ; /* bits 18:18 */
    ca_uint32_t no_drop_user_def     :  1 ; /* bits 19:19 */
    ca_uint32_t no_drop_user_def10   :  1 ; /* bits 20:20 */
    ca_uint32_t no_drop_user_def11   :  1 ; /* bits 21:21 */
    ca_uint32_t no_drop_user_def20   :  1 ; /* bits 22:22 */
    ca_uint32_t no_drop_user_def21   :  1 ; /* bits 23:23 */
    ca_uint32_t no_drop_8902         :  1 ; /* bits 24:24 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_NOT_DROP_ETHERTYPE_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_NOT_DROP_ETHERTYPE_1 0xd00314e4
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_NOT_DROP_ETHERTYPE_1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t user_defined10       : 16 ; /* bits 15:0 */
    ca_uint32_t user_defined11       : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_NOT_DROP_ETHERTYPE_1_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_NOT_DROP_ETHERTYPE_2 0xd00314e8
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_NOT_DROP_ETHERTYPE_2_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t user_defined20       : 16 ; /* bits 15:0 */
    ca_uint32_t user_defined21       : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_NOT_DROP_ETHERTYPE_2_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_LLID_PROG_MEM_ACCESS 0xd00314ec
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_LLID_PROG_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mem_loc              :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_LLID_PROG_MEM_ACCESS_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_LLID_PROG_MEM_DATA 0xd00314f0
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_LLID_PROG_MEM_DATA_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t LLID_value           : 16 ; /* bits 15:0 */
    ca_uint32_t valid                :  1 ; /* bits 16:16 */
    ca_uint32_t SA_ID                :  6 ; /* bits 22:17 */
    ca_uint32_t rsrvd1               :  9 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_LLID_PROG_MEM_DATA_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_ACCESS 0xd00314f4
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mem_loc              :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 21 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_ACCESS_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA10 0xd00314f8
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA10_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t InPktsUnusedSA       : 22 ; /* bits 21:0 */
    ca_uint32_t rsrvd1               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA10_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA9 0xd00314fc
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA9_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t InPktsNotUsingSA     : 22 ; /* bits 21:0 */
    ca_uint32_t InPktsUnusedSA       : 10 ; /* bits 31:22 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA9_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA8 0xd0031500
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA8_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t InPktsNotValid       : 22 ; /* bits 21:0 */
    ca_uint32_t InPktsNotUsingSA     : 10 ; /* bits 31:22 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA8_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA7 0xd0031504
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA7_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t InPktsInvalid        : 22 ; /* bits 21:0 */
    ca_uint32_t InPktsNotValid       : 10 ; /* bits 31:22 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA7_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA6 0xd0031508
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA6_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t InPktsOK             : 22 ; /* bits 21:0 */
    ca_uint32_t InPktsInvalid        : 10 ; /* bits 31:22 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA6_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA5 0xd003150c
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA5_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t InPktsLate           : 22 ; /* bits 21:0 */
    ca_uint32_t InPktsOK             : 10 ; /* bits 31:22 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA5_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA4 0xd0031510
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA4_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t InOctetsDecrypted_OutOctetsEncrypted : 22 ; /* bits 21:0 */
    ca_uint32_t InPktsLate           : 10 ; /* bits 31:22 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA4_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA3 0xd0031514
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA3_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t InOctetsValidated_OutOctetsProtected : 11 ; /* bits 10:0 */
    ca_uint32_t InOctetsDecrypted_OutOctetsEncrypted : 21 ; /* bits 31:11 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA3_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA2 0xd0031518
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA2_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t InOctetsValidated_OutOctetsProtected : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA2_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA1 0xd003151c
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t InPktsDelayed_OutPktsEncrypted : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA1_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA0 0xd0031520
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t InPktsUnchecked_OutPktsProtected : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA0_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_MACSEC_MIB_OutPktsUnTagged 0xd0031524
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_MACSEC_MIB_OutPktsUnTagged_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_macsec_mib_OutPktsUnTagged_inc : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_MACSEC_MIB_OutPktsUnTagged_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_MACSEC_MIB_OutPktsTooLong 0xd0031528
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_MACSEC_MIB_OutPktsTooLong_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_macsec_mib_OutPktsTooLong_inc : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_MACSEC_MIB_OutPktsTooLong_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsUnTagged 0xd003152c
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsUnTagged_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_macsec_mib_InPktsUnTagged_inc : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsUnTagged_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsNoTag 0xd0031530
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsNoTag_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_macsec_mib_InPktsNoTag_inc : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsNoTag_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsBadTag 0xd0031534
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsBadTag_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_macsec_mib_InPktsBadTag_inc : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsBadTag_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsUnKnownSCI 0xd0031538
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsUnKnownSCI_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_macsec_mib_InPktsUnKnownSCI_inc : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsUnKnownSCI_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsNoSCI 0xd003153c
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsNoSCI_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_macsec_mib_InPktsNoSCI_inc : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsNoSCI_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsOverrun 0xd0031540
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsOverrun_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_macsec_mib_InPktsOverrun_inc : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsOverrun_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_DEC_INVALID_CO_ERR_CNT 0xd0031544
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_DEC_INVALID_CO_ERR_CNT_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_macsec_dec_invalid_co_err_cnt_inc : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_DEC_INVALID_CO_ERR_CNT_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_DEC_VER_NUM_ERR_CNT 0xd0031548
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_DEC_VER_NUM_ERR_CNT_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_macsec_dec_ver_num_err_cnt_inc : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_DEC_VER_NUM_ERR_CNT_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_DEC_SL_MSB_ERR_CNT 0xd003154c
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_DEC_SL_MSB_ERR_CNT_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_macsec_dec_sl_msb_err_cnt_inc : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_DEC_SL_MSB_ERR_CNT_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_DEC_AUTH_FAIL_ERR_CNT 0xd0031550
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_DEC_AUTH_FAIL_ERR_CNT_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_macsec_dec_auth_fail_err_cnt_inc : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_DEC_AUTH_FAIL_ERR_CNT_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_STATUS 0xd0031554
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_STATUS_dft 0x00000001

typedef volatile union {
  struct {
    ca_uint32_t stat_mem_init_done   :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_STATUS_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_PKTS_UN_REG_LLID_CNT 0xd0031558
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_PKTS_UN_REG_LLID_CNT_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_pkts_un_known_llid : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_PKTS_UN_REG_LLID_CNT_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_RUNT_PKTS_CNT 0xd003155c
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_RUNT_PKTS_CNT_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_runt_pkts         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_RUNT_PKTS_CNT_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* CORESEC10 */
typedef struct {
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_INTERRUPT_0_t INTERRUPT_0;                   /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_INTERRUPT_ENABLE_0_t INTERRUPT_ENABLE_0;            /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_INTERRUPT_1_t INTERRUPT_1;                   /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_INTERRUPT_ENABLE_1_t INTERRUPT_ENABLE_1;            /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_CORESEC10_GLOBAL_CONFIG_t CORESEC10_GLOBAL_CONFIG;       /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_CORESEC10_MPCP_TIMER_ADJUST_t CORESEC10_MPCP_TIMER_ADJUST;   /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_SA_0_t SA_0;                          /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_SA_1_t SA_1;                          /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_NOT_DROP_ETHERTYPE_t NOT_DROP_ETHERTYPE;            /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_NOT_DROP_ETHERTYPE_1_t NOT_DROP_ETHERTYPE_1;          /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_NOT_DROP_ETHERTYPE_2_t NOT_DROP_ETHERTYPE_2;          /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_LLID_PROG_MEM_ACCESS_t LLID_PROG_MEM_ACCESS;          /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_LLID_PROG_MEM_DATA_t LLID_PROG_MEM_DATA;            /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_ACCESS_t TX_RX_MIB_MEM_ACCESS;          /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA10_t TX_RX_MIB_MEM_DATA10;          /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA9_t TX_RX_MIB_MEM_DATA9;           /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA8_t TX_RX_MIB_MEM_DATA8;           /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA7_t TX_RX_MIB_MEM_DATA7;           /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA6_t TX_RX_MIB_MEM_DATA6;           /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA5_t TX_RX_MIB_MEM_DATA5;           /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA4_t TX_RX_MIB_MEM_DATA4;           /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA3_t TX_RX_MIB_MEM_DATA3;           /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA2_t TX_RX_MIB_MEM_DATA2;           /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA1_t TX_RX_MIB_MEM_DATA1;           /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA0_t TX_RX_MIB_MEM_DATA0;           /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_MACSEC_MIB_OutPktsUnTagged_t TX_MACSEC_MIB_OutPktsUnTagged; /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_MACSEC_MIB_OutPktsTooLong_t TX_MACSEC_MIB_OutPktsTooLong;  /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsUnTagged_t RX_MACSEC_MIB_InPktsUnTagged;  /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsNoTag_t RX_MACSEC_MIB_InPktsNoTag;     /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsBadTag_t RX_MACSEC_MIB_InPktsBadTag;    /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsUnKnownSCI_t RX_MACSEC_MIB_InPktsUnKnownSCI; /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsNoSCI_t RX_MACSEC_MIB_InPktsNoSCI;     /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsOverrun_t RX_MACSEC_MIB_InPktsOverrun;   /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_DEC_INVALID_CO_ERR_CNT_t RX_MACSEC_DEC_INVALID_CO_ERR_CNT; /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_DEC_VER_NUM_ERR_CNT_t RX_MACSEC_DEC_VER_NUM_ERR_CNT; /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_DEC_SL_MSB_ERR_CNT_t RX_MACSEC_DEC_SL_MSB_ERR_CNT;  /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_DEC_AUTH_FAIL_ERR_CNT_t RX_MACSEC_DEC_AUTH_FAIL_ERR_CNT; /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_STATUS_t STATUS;                        /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_PKTS_UN_REG_LLID_CNT_t RX_PKTS_UN_REG_LLID_CNT;       /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_RUNT_PKTS_CNT_t RX_RUNT_PKTS_CNT;              /* addr: 0x0000009c */
} APB1_EPON_XGEPN_CORESEC10_TOP_CORESEC10_t;

    
#define APB1_EPON_XGEPN_CORESEC10_TOP_STRIDE     320
#define APB1_EPON_XGEPN_CORESEC10_TOP_COUNT      2
  
        
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* CORESEC10_TOP */

typedef struct {
  APB1_EPON_XGEPN_CORESEC10_TOP_NANDI_t    NANDI;                         /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[99];                   
  APB1_EPON_XGEPN_CORESEC10_TOP_CORESEC10_t CORESEC10;                     /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd2[81];                   
} APB1_EPON_XGEPN_CORESEC10_TOP_t;

    
  
        
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* XGEPN */

typedef struct {
  APB1_EPON_XGEPN_XMAC_t                   xmac;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[91];                   
  APB1_EPON_XGEPN_XGPCS_t                  XGPCS;                         /* addr: 0x00000300 */
  ca_uint32_t                              rsrvd2[123];                  
  APB1_EPON_XGEPN_CORESEC10_TOP_t          CORESEC10_TOP[2];              /* addr: 0x00000420 */
} APB1_EPON_XGEPN_t;


/*
 * xgonu_mpcp
 */
        
#define EPON_XGONU_MPCP_MPCP_IRQ_SRC_INTERRUPT   0xd0032000
#define EPON_XGONU_MPCP_MPCP_IRQ_SRC_INTERRUPT_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t reg_status_changei   :  1 ; /* bits 0:0 */
    ca_uint32_t rx_register_framei   :  1 ; /* bits 1:1 */
    ca_uint32_t gate_timer_expiri    :  1 ; /* bits 2:2 */
    ca_uint32_t mpcp_timer_expiri    :  1 ; /* bits 3:3 */
    ca_uint32_t report_timer_expiri  :  1 ; /* bits 4:4 */
    ca_uint32_t reg_req_retryi       :  1 ; /* bits 5:5 */
    ca_uint32_t ts_drifti            :  1 ; /* bits 6:6 */
    ca_uint32_t grant_fifo_exceedi   :  1 ; /* bits 7:7 */
    ca_uint32_t grant_fifo_accerri   :  1 ; /* bits 8:8 */
    ca_uint32_t grant_drop_tfi       :  1 ; /* bits 9:9 */
    ca_uint32_t grant_drop_tsi       :  1 ; /* bits 10:10 */
    ca_uint32_t grant_drop_tmi       :  1 ; /* bits 11:11 */
    ca_uint32_t grant_drop_disi      :  1 ; /* bits 12:12 */
    ca_uint32_t rx_extend_framei     :  1 ; /* bits 13:13 */
    ca_uint32_t dis_pend_tmr_expiri  :  1 ; /* bits 14:14 */
    ca_uint32_t no_endrpt_reqi       :  1 ; /* bits 15:15 */
    ca_uint32_t grant_drop_tli       :  1 ; /* bits 16:16 */
    ca_uint32_t llid_tbl_remove_emptyi :  1 ; /* bits 17:17 */
    ca_uint32_t llid_tbl_fulli       :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_IRQ_SRC_INTERRUPT_t;


#define EPON_XGONU_MPCP_MPCP_IRQ_SRC_INTERRUPTE  0xd0032004
#define EPON_XGONU_MPCP_MPCP_IRQ_SRC_INTERRUPTE_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t reg_status_changeiE  :  1 ; /* bits 0:0 */
    ca_uint32_t rx_register_frameiE  :  1 ; /* bits 1:1 */
    ca_uint32_t gate_timer_expiriE   :  1 ; /* bits 2:2 */
    ca_uint32_t mpcp_timer_expiriE   :  1 ; /* bits 3:3 */
    ca_uint32_t report_timer_expiriE :  1 ; /* bits 4:4 */
    ca_uint32_t reg_req_retryiE      :  1 ; /* bits 5:5 */
    ca_uint32_t ts_driftiE           :  1 ; /* bits 6:6 */
    ca_uint32_t grant_fifo_exceediE  :  1 ; /* bits 7:7 */
    ca_uint32_t grant_fifo_accerriE  :  1 ; /* bits 8:8 */
    ca_uint32_t grant_drop_tfiE      :  1 ; /* bits 9:9 */
    ca_uint32_t grant_drop_tsiE      :  1 ; /* bits 10:10 */
    ca_uint32_t grant_drop_tmiE      :  1 ; /* bits 11:11 */
    ca_uint32_t grant_drop_disiE     :  1 ; /* bits 12:12 */
    ca_uint32_t rx_extend_frameiE    :  1 ; /* bits 13:13 */
    ca_uint32_t dis_pend_tmr_expiriE :  1 ; /* bits 14:14 */
    ca_uint32_t no_endrpt_reqiE      :  1 ; /* bits 15:15 */
    ca_uint32_t grant_drop_tliE      :  1 ; /* bits 16:16 */
    ca_uint32_t llid_tbl_remove_emptyiE :  1 ; /* bits 17:17 */
    ca_uint32_t llid_tbl_fulliE      :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_IRQ_SRC_INTERRUPTE_t;


#define EPON_XGONU_MPCP_MPCP_INIT_CFG            0xd0032008
#define EPON_XGONU_MPCP_MPCP_INIT_CFG_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac_index            :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t sw_index             :  6 ; /* bits 13:8 */
    ca_uint32_t rsrvd2               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_INIT_CFG_t;


#define EPON_XGONU_MPCP_MPCP_START_CFG           0xd003200c
#define EPON_XGONU_MPCP_MPCP_START_CFG_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mpcp_start           :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_START_CFG_t;


#define EPON_XGONU_MPCP_MPCP_REGISTER_FRAME_STS  0xd0032010
#define EPON_XGONU_MPCP_MPCP_REGISTER_FRAME_STS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t assigned_llid        : 16 ; /* bits 15:0 */
    ca_uint32_t flag                 :  4 ; /* bits 19:16 */
    ca_uint32_t mac_index            :  5 ; /* bits 24:20 */
    ca_uint32_t vld                  :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_REGISTER_FRAME_STS_t;


#define EPON_XGONU_MPCP_MAC_REG_STATUS           0xd0032014
#define EPON_XGONU_MPCP_MAC_REG_STATUS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sts                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MAC_REG_STATUS_t;


#define EPON_XGONU_MPCP_MAC_MPCP_STS1            0xd0032018
#define EPON_XGONU_MPCP_MAC_MPCP_STS1_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t stat1                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MAC_MPCP_STS1_t;


#define EPON_XGONU_MPCP_MAC_MPCP_STS0            0xd003201c
#define EPON_XGONU_MPCP_MAC_MPCP_STS0_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t stat0                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MAC_MPCP_STS0_t;


#define EPON_XGONU_MPCP_MPCP_CFG0                0xd0032020
#define EPON_XGONU_MPCP_MPCP_CFG0_dft            0x00010082

typedef volatile union {
  struct {
    ca_uint32_t max_pending_grant    :  4 ; /* bits 3:0 */
    ca_uint32_t dis_min_grant_check  :  1 ; /* bits 4:4 */
    ca_uint32_t req_frame_llid_sel   :  1 ; /* bits 5:5 */
    ca_uint32_t bak_grt_en           :  1 ; /* bits 6:6 */
    ca_uint32_t flush_grtff_en       :  1 ; /* bits 7:7 */
    ca_uint32_t report_mode_sel      :  3 ; /* bits 10:8 */
    ca_uint32_t t4_report_en         :  1 ; /* bits 11:11 */
    ca_uint32_t overlap_grt_ok       :  1 ; /* bits 12:12 */
    ca_uint32_t ts_drift_threshold   :  6 ; /* bits 18:13 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t sieponB_mode         :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t ignore_olt_disc_info :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t pre_grt_vld_mode     :  1 ; /* bits 27:27 */
    ca_uint32_t mllid_rereg_wait     :  1 ; /* bits 28:28 */
    ca_uint32_t mllid_mode           :  1 ; /* bits 29:29 */
    ca_uint32_t debug_mode           :  1 ; /* bits 30:30 */
    ca_uint32_t rsrvd4               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_CFG0_t;


#define EPON_XGONU_MPCP_MPCP_CFG                 0xd0032024
#define EPON_XGONU_MPCP_MPCP_CFG_dft             0x01270020

typedef volatile union {
  struct {
    ca_uint32_t mpcp_registration_init :  1 ; /* bits 0:0 */
    ca_uint32_t allow_direct_reg     :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t ctc_onu_silence_en   :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t en_period_report     :  1 ; /* bits 5:5 */
    ca_uint32_t en_end_rpt           :  1 ; /* bits 6:6 */
    ca_uint32_t dis_granting         :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd3               :  8 ;
    ca_uint32_t mpcp_timer_expir_dereg :  1 ; /* bits 16:16 */
    ca_uint32_t gate_timer_expir_dereg :  1 ; /* bits 17:17 */
    ca_uint32_t en_ts_drift_dereg    :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd4               :  1 ;
    ca_uint32_t ctl_txarb_timer      :  8 ; /* bits 27:20 */
    ca_uint32_t rsrvd5               :  2 ;
    ca_uint32_t clr_permit           :  1 ; /* bits 30:30 */
    ca_uint32_t llid_en              :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_CFG_t;


#define EPON_XGONU_MPCP_MPCP_CFG_1G              0xd0032028
#define EPON_XGONU_MPCP_MPCP_CFG_1G_dft          0x00000f2a

typedef volatile union {
  struct {
    ca_uint32_t min_pkt_size_1g      :  8 ; /* bits 7:0 */
    ca_uint32_t fec_overhead_1g      :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_CFG_1G_t;


#define EPON_XGONU_MPCP_MPCP_CFG_10G             0xd003202c
#define EPON_XGONU_MPCP_MPCP_CFG_10G_dft         0x10000e06

typedef volatile union {
  struct {
    ca_uint32_t min_grant_len_10g_nofec :  8 ; /* bits 7:0 */
    ca_uint32_t min_grant_len_10g    :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t burst_end_xgpcs_dly  :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_CFG_10G_t;


#define EPON_XGONU_MPCP_GRANT_VLD_AHEAD_TIMER    0xd0032030
#define EPON_XGONU_MPCP_GRANT_VLD_AHEAD_TIMER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_GRANT_VLD_AHEAD_TIMER_t;


#define EPON_XGONU_MPCP_ES_STOP_WIN_CFG          0xd0032034
#define EPON_XGONU_MPCP_ES_STOP_WIN_CFG_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ahead_timer          :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 30 ;
    ca_uint32_t wait                 :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_ES_STOP_WIN_CFG_t;


#define EPON_XGONU_MPCP_MPCP_GRANT_TIMER         0xd0032038
#define EPON_XGONU_MPCP_MPCP_GRANT_TIMER_dft     0x040003ff

typedef volatile union {
  struct {
    ca_uint32_t max_future_grant_time : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               :  6 ;
    ca_uint32_t min_processing_time  : 12 ; /* bits 27:16 */
    ca_uint32_t rsrvd2               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_GRANT_TIMER_t;


#define EPON_XGONU_MPCP_MPCP_LASER_TIME_CFG      0xd003203c
#define EPON_XGONU_MPCP_MPCP_LASER_TIME_CFG_dft  0x00200020

typedef volatile union {
  struct {
    ca_uint32_t laserOnTime_cfg      :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t laserOffTime_cfg     :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd2               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_LASER_TIME_CFG_t;


#define EPON_XGONU_MPCP_MPCP_STIME_ADJ           0xd0032040
#define EPON_XGONU_MPCP_MPCP_STIME_ADJ_dft       0x00000002

typedef volatile union {
  struct {
    ca_uint32_t process_delay        :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_STIME_ADJ_t;


#define EPON_XGONU_MPCP_MPCP_CTC_REG_TIME        0xd0032044
#define EPON_XGONU_MPCP_MPCP_CTC_REG_TIME_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t silence              :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_CTC_REG_TIME_t;


#define EPON_XGONU_MPCP_MPCP_RPT_TIME_THRED      0xd0032048
#define EPON_XGONU_MPCP_MPCP_RPT_TIME_THRED_dft  0x000001a0

typedef volatile union {
  struct {
    ca_uint32_t val                  : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_RPT_TIME_THRED_t;


#define EPON_XGONU_MPCP_MPCP_TIMER_EXP_THRED     0xd003204c
#define EPON_XGONU_MPCP_MPCP_TIMER_EXP_THRED_dft 0x01f42710

typedef volatile union {
  struct {
    ca_uint32_t mpcp                 : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t gate                 : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_TIMER_EXP_THRED_t;


#define EPON_XGONU_MPCP_MPCP_DIS_PEND_TIME_THRED 0xd0032050
#define EPON_XGONU_MPCP_MPCP_DIS_PEND_TIME_THRED_dft 0x80000fff

typedef volatile union {
  struct {
    ca_uint32_t val                  : 20 ; /* bits 19:0 */
    ca_uint32_t rsrvd1               : 11 ;
    ca_uint32_t en                   :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_DIS_PEND_TIME_THRED_t;


#define EPON_XGONU_MPCP_MPCP_REG_REQ_RESV0       0xd0032054
#define EPON_XGONU_MPCP_MPCP_REG_REQ_RESV0_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_REG_REQ_RESV0_t;


#define EPON_XGONU_MPCP_MPCP_REG_REQ_RESV1       0xd0032058
#define EPON_XGONU_MPCP_MPCP_REG_REQ_RESV1_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_REG_REQ_RESV1_t;


#define EPON_XGONU_MPCP_MPCP_REG_REQ_RESV2       0xd003205c
#define EPON_XGONU_MPCP_MPCP_REG_REQ_RESV2_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_REG_REQ_RESV2_t;


#define EPON_XGONU_MPCP_MPCP_REG_REQ_RESV3       0xd0032060
#define EPON_XGONU_MPCP_MPCP_REG_REQ_RESV3_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_REG_REQ_RESV3_t;


#define EPON_XGONU_MPCP_MPCP_REG_REQ_RESV4       0xd0032064
#define EPON_XGONU_MPCP_MPCP_REG_REQ_RESV4_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_REG_REQ_RESV4_t;


#define EPON_XGONU_MPCP_MPCP_REG_REQ_RESV5       0xd0032068
#define EPON_XGONU_MPCP_MPCP_REG_REQ_RESV5_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_REG_REQ_RESV5_t;


#define EPON_XGONU_MPCP_MPCP_REG_REQ_RESV6       0xd003206c
#define EPON_XGONU_MPCP_MPCP_REG_REQ_RESV6_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_REG_REQ_RESV6_t;


#define EPON_XGONU_MPCP_MPCP_REG_REQ_RESV7       0xd0032070
#define EPON_XGONU_MPCP_MPCP_REG_REQ_RESV7_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_REG_REQ_RESV7_t;


#define EPON_XGONU_MPCP_MPCP_REG_REQ_RESV8       0xd0032074
#define EPON_XGONU_MPCP_MPCP_REG_REQ_RESV8_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_REG_REQ_RESV8_t;


#define EPON_XGONU_MPCP_MPCP_ACK_RESV0           0xd0032078
#define EPON_XGONU_MPCP_MPCP_ACK_RESV0_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_ACK_RESV0_t;


#define EPON_XGONU_MPCP_MPCP_ACK_RESV1           0xd003207c
#define EPON_XGONU_MPCP_MPCP_ACK_RESV1_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_ACK_RESV1_t;


#define EPON_XGONU_MPCP_MPCP_ACK_RESV2           0xd0032080
#define EPON_XGONU_MPCP_MPCP_ACK_RESV2_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_ACK_RESV2_t;


#define EPON_XGONU_MPCP_MPCP_ACK_RESV3           0xd0032084
#define EPON_XGONU_MPCP_MPCP_ACK_RESV3_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_ACK_RESV3_t;


#define EPON_XGONU_MPCP_MPCP_ACK_RESV4           0xd0032088
#define EPON_XGONU_MPCP_MPCP_ACK_RESV4_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_ACK_RESV4_t;


#define EPON_XGONU_MPCP_MPCP_ACK_RESV5           0xd003208c
#define EPON_XGONU_MPCP_MPCP_ACK_RESV5_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_ACK_RESV5_t;


#define EPON_XGONU_MPCP_MPCP_ACK_RESV6           0xd0032090
#define EPON_XGONU_MPCP_MPCP_ACK_RESV6_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_ACK_RESV6_t;


#define EPON_XGONU_MPCP_MPCP_ACK_RESV7           0xd0032094
#define EPON_XGONU_MPCP_MPCP_ACK_RESV7_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_ACK_RESV7_t;


#define EPON_XGONU_MPCP_MPCP_ACK_RESV8           0xd0032098
#define EPON_XGONU_MPCP_MPCP_ACK_RESV8_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_ACK_RESV8_t;


#define EPON_XGONU_MPCP_TIMESTAMP                0xd003209c
#define EPON_XGONU_MPCP_TIMESTAMP_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_TIMESTAMP_t;


#define EPON_XGONU_MPCP_MPCP_OLTMACH             0xd00320a0
#define EPON_XGONU_MPCP_MPCP_OLTMACH_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t olt_macH             : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_OLTMACH_t;


#define EPON_XGONU_MPCP_MPCP_OLTMACL             0xd00320a4
#define EPON_XGONU_MPCP_MPCP_OLTMACL_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t olt_macL             : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_OLTMACL_t;


#define EPON_XGONU_MPCP_MPCP_LOCAL_DISINFO       0xd00320a8
#define EPON_XGONU_MPCP_MPCP_LOCAL_DISINFO_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t onu                  :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_LOCAL_DISINFO_t;


#define EPON_XGONU_MPCP_MPCP_REMOTE_DISINFO      0xd00320ac
#define EPON_XGONU_MPCP_MPCP_REMOTE_DISINFO_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t olt                  : 16 ; /* bits 15:0 */
    ca_uint32_t grant_size           : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_REMOTE_DISINFO_t;


#define EPON_XGONU_MPCP_MPCP_SELF_RPT_STS        0xd00320b0
#define EPON_XGONU_MPCP_MPCP_SELF_RPT_STS_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t self_rpt             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_SELF_RPT_STS_t;


#define EPON_XGONU_MPCP_MPCP_ONU_PATH_SPEED      0xd00320b4
#define EPON_XGONU_MPCP_MPCP_ONU_PATH_SPEED_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t txpath_speed         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_ONU_PATH_SPEED_t;


#define EPON_XGONU_MPCP_MPCP_GRANT_FIFO_STS      0xd00320b8
#define EPON_XGONU_MPCP_MPCP_GRANT_FIFO_STS_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t full_grt             :  1 ; /* bits 0:0 */
    ca_uint32_t empty_grt            :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_GRANT_FIFO_STS_t;


#define EPON_XGONU_MPCP_MPCP_GRANT_DROP_CNTR     0xd00320bc
#define EPON_XGONU_MPCP_MPCP_GRANT_DROP_CNTR_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ovd_cnt              :  8 ; /* bits 7:0 */
    ca_uint32_t max_cnt              :  8 ; /* bits 15:8 */
    ca_uint32_t min_cnt              :  8 ; /* bits 23:16 */
    ca_uint32_t localLTstart_cnt     :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_GRANT_DROP_CNTR_t;


#define EPON_XGONU_MPCP_MPCP_GRANT_DROP_CNTR1    0xd00320c0
#define EPON_XGONU_MPCP_MPCP_GRANT_DROP_CNTR1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wr_full_cnt          :  8 ; /* bits 7:0 */
    ca_uint32_t rd_empty_cnt         :  8 ; /* bits 15:8 */
    ca_uint32_t rd_drop_cnt          :  8 ; /* bits 23:16 */
    ca_uint32_t llid_mismatch_drop_cnt :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_GRANT_DROP_CNTR1_t;


#define EPON_XGONU_MPCP_MPCP_BAK_GRANT_CNTR      0xd00320c4
#define EPON_XGONU_MPCP_MPCP_BAK_GRANT_CNTR_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_BAK_GRANT_CNTR_t;


#define EPON_XGONU_MPCP_MPCP_LLID_SYNCTIME       0xd00320c8
#define EPON_XGONU_MPCP_MPCP_LLID_SYNCTIME_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sync_time            : 16 ; /* bits 15:0 */
    ca_uint32_t assigned_llid        : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_LLID_SYNCTIME_t;


#define EPON_XGONU_MPCP_MPCP_DIS_SYNCTIME        0xd00320cc
#define EPON_XGONU_MPCP_MPCP_DIS_SYNCTIME_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sync_time_xg         : 16 ; /* bits 15:0 */
    ca_uint32_t sync_time_1g         : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_DIS_SYNCTIME_t;


#define EPON_XGONU_MPCP_MPCP_SYNCTIME_CFG        0xd00320d0
#define EPON_XGONU_MPCP_MPCP_SYNCTIME_CFG_dft    0x00200020

typedef volatile union {
  struct {
    ca_uint32_t sync_time_dis        : 16 ; /* bits 15:0 */
    ca_uint32_t sync_time_norm       : 15 ; /* bits 30:16 */
    ca_uint32_t mode                 :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_SYNCTIME_CFG_t;


#define EPON_XGONU_MPCP_MPCP_LASER_TIME_STS      0xd00320d4
#define EPON_XGONU_MPCP_MPCP_LASER_TIME_STS_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t laserOnTime_sts      :  8 ; /* bits 7:0 */
    ca_uint32_t laserOffTime_sts     :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_LASER_TIME_STS_t;


#define EPON_XGONU_MPCP_MPCP_PKT_FLAG            0xd00320d8
#define EPON_XGONU_MPCP_MPCP_PKT_FLAG_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ack_flag             :  8 ; /* bits 7:0 */
    ca_uint32_t request_flag         :  8 ; /* bits 15:8 */
    ca_uint32_t register_flag        :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_PKT_FLAG_t;


#define EPON_XGONU_MPCP_MPCP_REGISTER_STS        0xd00320dc
#define EPON_XGONU_MPCP_MPCP_REGISTER_STS_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t prereg               :  1 ; /* bits 0:0 */
    ca_uint32_t registered           :  1 ; /* bits 1:1 */
    ca_uint32_t permit               :  1 ; /* bits 2:2 */
    ca_uint32_t retry                :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_REGISTER_STS_t;


#define EPON_XGONU_MPCP_MPCP_DEREG               0xd00320e0
#define EPON_XGONU_MPCP_MPCP_DEREG_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t en_local_offline     : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_DEREG_t;


#define EPON_XGONU_MPCP_MPCP_GATE_TIMER_STS      0xd00320e4
#define EPON_XGONU_MPCP_MPCP_GATE_TIMER_STS_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t expire_sts           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_GATE_TIMER_STS_t;


#define EPON_XGONU_MPCP_MPCP_DEREG_CAUSE         0xd00320e8
#define EPON_XGONU_MPCP_MPCP_DEREG_CAUSE_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t code                 :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t first_dereg_code     :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  9 ;
    ca_uint32_t dereg_cnt            : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_DEREG_CAUSE_t;


#define EPON_XGONU_MPCP_MPCP_MON_CNTR            0xd00320ec
#define EPON_XGONU_MPCP_MPCP_MON_CNTR_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ts_drift_cnt         :  8 ; /* bits 7:0 */
    ca_uint32_t mpcp_timer_expir_cnt :  8 ; /* bits 15:8 */
    ca_uint32_t gate_timer_expir_cnt :  8 ; /* bits 23:16 */
    ca_uint32_t reged_cnt            :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_MON_CNTR_t;


#define EPON_XGONU_MPCP_MPCP_MON_STS             0xd00320f0
#define EPON_XGONU_MPCP_MPCP_MON_STS_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t force_report_before_reged :  1 ; /* bits 0:0 */
    ca_uint32_t normal_gate_before_reged :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 14 ;
    ca_uint32_t retry_cnt            : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_MON_STS_t;


#define EPON_XGONU_MPCP_MPCP_LLID_DBG            0xd00320f4
#define EPON_XGONU_MPCP_MPCP_LLID_DBG_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dbg_mac_idx          :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 11 ;
    ca_uint32_t debug_sel            :  7 ; /* bits 22:16 */
    ca_uint32_t rsrvd2               :  8 ;
    ca_uint32_t en_llid_debug        :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_LLID_DBG_t;


#define EPON_XGONU_MPCP_MPCP_GRANT_FIFO_CTRL     0xd00320f8
#define EPON_XGONU_MPCP_MPCP_GRANT_FIFO_CTRL_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_GRANT_FIFO_CTRL_t;


#define EPON_XGONU_MPCP_MPCP_GRANT_FIFO_DATA     0xd00320fc
#define EPON_XGONU_MPCP_MPCP_GRANT_FIFO_DATA_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_GRANT_FIFO_DATA_t;


#define EPON_XGONU_MPCP_MPCP_RXPKT_CNTR          0xd0032100
#define EPON_XGONU_MPCP_MPCP_RXPKT_CNTR_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_pktcnt            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_RXPKT_CNTR_t;


#define EPON_XGONU_MPCP_MPCP_TXPKT_CNTR          0xd0032104
#define EPON_XGONU_MPCP_MPCP_TXPKT_CNTR_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_pktcnt            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_TXPKT_CNTR_t;


#define EPON_XGONU_MPCP_CTL_RPT_TMR              0xd0032108
#define EPON_XGONU_MPCP_CTL_RPT_TMR_dft          0x0007000c

typedef volatile union {
  struct {
    ca_uint32_t reg_rpt_vld_tmr      : 16 ; /* bits 15:0 */
    ca_uint32_t reg_rpt_req_tmr      : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_CTL_RPT_TMR_t;


#define EPON_XGONU_MPCP_POWER_SAVING_CFG         0xd003210c
#define EPON_XGONU_MPCP_POWER_SAVING_CFG_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sleep_cycle_en       :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_POWER_SAVING_CFG_t;


#define EPON_XGONU_MPCP_POWER_SAVING_STS         0xd0032110
#define EPON_XGONU_MPCP_POWER_SAVING_STS_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sleep_cycle_st       :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_POWER_SAVING_STS_t;


#define EPON_XGONU_MPCP_SPARE                    0xd0032114
#define EPON_XGONU_MPCP_SPARE_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cfg                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_SPARE_t;


#define EPON_XGONU_MPCP_RSVR                     0xd0032118
#define EPON_XGONU_MPCP_RSVR_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_RSVR_t;


#define EPON_XGONU_MPCP_MP_RPT_CNT               0xd003211c
#define EPON_XGONU_MPCP_MP_RPT_CNT_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_rpt_cnt           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MP_RPT_CNT_t;


#define EPON_XGONU_MPCP_MPCP_DISPKT_CNTR         0xd0032120
#define EPON_XGONU_MPCP_MPCP_DISPKT_CNTR_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t disfrm_cnt           : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_DISPKT_CNTR_t;


#define EPON_XGONU_MPCP_MPCP_DISPKT_PERIOD       0xd0032124
#define EPON_XGONU_MPCP_MPCP_DISPKT_PERIOD_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t disfrm_period        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_DISPKT_PERIOD_t;


#define EPON_XGONU_MPCP_MISC                     0xd0032128
#define EPON_XGONU_MPCP_MISC_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mpcp_datapath_rst    :  1 ; /* bits 0:0 */
    ca_uint32_t txACK_mode           :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MISC_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* xgonu_mpcp */
typedef struct {
  EPON_XGONU_MPCP_MPCP_IRQ_SRC_INTERRUPT_t MPCP_IRQ_SRC_INTERRUPT;        /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  EPON_XGONU_MPCP_MPCP_IRQ_SRC_INTERRUPTE_t MPCP_IRQ_SRC_INTERRUPTE;       /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  EPON_XGONU_MPCP_MPCP_INIT_CFG_t          MPCP_INIT_CFG;                 /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  EPON_XGONU_MPCP_MPCP_START_CFG_t         MPCP_START_CFG;                /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  EPON_XGONU_MPCP_MPCP_REGISTER_FRAME_STS_t MPCP_REGISTER_FRAME_STS;       /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  EPON_XGONU_MPCP_MAC_REG_STATUS_t         MAC_REG_STATUS;                /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  EPON_XGONU_MPCP_MAC_MPCP_STS1_t          MAC_MPCP_STS1;                 /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  EPON_XGONU_MPCP_MAC_MPCP_STS0_t          MAC_MPCP_STS0;                 /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  EPON_XGONU_MPCP_MPCP_CFG0_t              MPCP_CFG0;                     /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  EPON_XGONU_MPCP_MPCP_CFG_t               MPCP_CFG;                      /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  EPON_XGONU_MPCP_MPCP_CFG_1G_t            MPCP_CFG_1G;                   /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  EPON_XGONU_MPCP_MPCP_CFG_10G_t           MPCP_CFG_10G;                  /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  EPON_XGONU_MPCP_GRANT_VLD_AHEAD_TIMER_t  GRANT_VLD_AHEAD_TIMER;         /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  EPON_XGONU_MPCP_ES_STOP_WIN_CFG_t        ES_STOP_WIN_CFG;               /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  EPON_XGONU_MPCP_MPCP_GRANT_TIMER_t       MPCP_GRANT_TIMER;              /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  EPON_XGONU_MPCP_MPCP_LASER_TIME_CFG_t    MPCP_LASER_TIME_CFG;           /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  EPON_XGONU_MPCP_MPCP_STIME_ADJ_t         MPCP_STIME_ADJ;                /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  EPON_XGONU_MPCP_MPCP_CTC_REG_TIME_t      MPCP_CTC_REG_TIME;             /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  EPON_XGONU_MPCP_MPCP_RPT_TIME_THRED_t    MPCP_RPT_TIME_THRED;           /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  EPON_XGONU_MPCP_MPCP_TIMER_EXP_THRED_t   MPCP_TIMER_EXP_THRED;          /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  EPON_XGONU_MPCP_MPCP_DIS_PEND_TIME_THRED_t MPCP_DIS_PEND_TIME_THRED;      /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  EPON_XGONU_MPCP_MPCP_REG_REQ_RESV0_t     MPCP_REG_REQ_RESV0;            /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  EPON_XGONU_MPCP_MPCP_REG_REQ_RESV1_t     MPCP_REG_REQ_RESV1;            /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  EPON_XGONU_MPCP_MPCP_REG_REQ_RESV2_t     MPCP_REG_REQ_RESV2;            /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  EPON_XGONU_MPCP_MPCP_REG_REQ_RESV3_t     MPCP_REG_REQ_RESV3;            /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  EPON_XGONU_MPCP_MPCP_REG_REQ_RESV4_t     MPCP_REG_REQ_RESV4;            /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  EPON_XGONU_MPCP_MPCP_REG_REQ_RESV5_t     MPCP_REG_REQ_RESV5;            /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  EPON_XGONU_MPCP_MPCP_REG_REQ_RESV6_t     MPCP_REG_REQ_RESV6;            /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  EPON_XGONU_MPCP_MPCP_REG_REQ_RESV7_t     MPCP_REG_REQ_RESV7;            /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  EPON_XGONU_MPCP_MPCP_REG_REQ_RESV8_t     MPCP_REG_REQ_RESV8;            /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  EPON_XGONU_MPCP_MPCP_ACK_RESV0_t         MPCP_ACK_RESV0;                /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  EPON_XGONU_MPCP_MPCP_ACK_RESV1_t         MPCP_ACK_RESV1;                /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  EPON_XGONU_MPCP_MPCP_ACK_RESV2_t         MPCP_ACK_RESV2;                /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  EPON_XGONU_MPCP_MPCP_ACK_RESV3_t         MPCP_ACK_RESV3;                /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  EPON_XGONU_MPCP_MPCP_ACK_RESV4_t         MPCP_ACK_RESV4;                /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  EPON_XGONU_MPCP_MPCP_ACK_RESV5_t         MPCP_ACK_RESV5;                /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  EPON_XGONU_MPCP_MPCP_ACK_RESV6_t         MPCP_ACK_RESV6;                /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  EPON_XGONU_MPCP_MPCP_ACK_RESV7_t         MPCP_ACK_RESV7;                /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  EPON_XGONU_MPCP_MPCP_ACK_RESV8_t         MPCP_ACK_RESV8;                /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];                   
  EPON_XGONU_MPCP_TIMESTAMP_t              TIMESTAMP;                     /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];                   
  EPON_XGONU_MPCP_MPCP_OLTMACH_t           MPCP_OLTMACH;                  /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];                   
  EPON_XGONU_MPCP_MPCP_OLTMACL_t           MPCP_OLTMACL;                  /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];                   
  EPON_XGONU_MPCP_MPCP_LOCAL_DISINFO_t     MPCP_LOCAL_DISINFO;            /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];                   
  EPON_XGONU_MPCP_MPCP_REMOTE_DISINFO_t    MPCP_REMOTE_DISINFO;           /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd44[3];                   
  EPON_XGONU_MPCP_MPCP_SELF_RPT_STS_t      MPCP_SELF_RPT_STS;             /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd45[3];                   
  EPON_XGONU_MPCP_MPCP_ONU_PATH_SPEED_t    MPCP_ONU_PATH_SPEED;           /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd46[3];                   
  EPON_XGONU_MPCP_MPCP_GRANT_FIFO_STS_t    MPCP_GRANT_FIFO_STS;           /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd47[3];                   
  EPON_XGONU_MPCP_MPCP_GRANT_DROP_CNTR_t   MPCP_GRANT_DROP_CNTR;          /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd48[3];                   
  EPON_XGONU_MPCP_MPCP_GRANT_DROP_CNTR1_t  MPCP_GRANT_DROP_CNTR1;         /* addr: 0x000000c0 */
  ca_uint32_t                              rsrvd49[3];                   
  EPON_XGONU_MPCP_MPCP_BAK_GRANT_CNTR_t    MPCP_BAK_GRANT_CNTR;           /* addr: 0x000000c4 */
  ca_uint32_t                              rsrvd50[3];                   
  EPON_XGONU_MPCP_MPCP_LLID_SYNCTIME_t     MPCP_LLID_SYNCTIME;            /* addr: 0x000000c8 */
  ca_uint32_t                              rsrvd51[3];                   
  EPON_XGONU_MPCP_MPCP_DIS_SYNCTIME_t      MPCP_DIS_SYNCTIME;             /* addr: 0x000000cc */
  ca_uint32_t                              rsrvd52[3];                   
  EPON_XGONU_MPCP_MPCP_SYNCTIME_CFG_t      MPCP_SYNCTIME_CFG;             /* addr: 0x000000d0 */
  ca_uint32_t                              rsrvd53[3];                   
  EPON_XGONU_MPCP_MPCP_LASER_TIME_STS_t    MPCP_LASER_TIME_STS;           /* addr: 0x000000d4 */
  ca_uint32_t                              rsrvd54[3];                   
  EPON_XGONU_MPCP_MPCP_PKT_FLAG_t          MPCP_PKT_FLAG;                 /* addr: 0x000000d8 */
  ca_uint32_t                              rsrvd55[3];                   
  EPON_XGONU_MPCP_MPCP_REGISTER_STS_t      MPCP_REGISTER_STS;             /* addr: 0x000000dc */
  ca_uint32_t                              rsrvd56[3];                   
  EPON_XGONU_MPCP_MPCP_DEREG_t             MPCP_DEREG;                    /* addr: 0x000000e0 */
  ca_uint32_t                              rsrvd57[3];                   
  EPON_XGONU_MPCP_MPCP_GATE_TIMER_STS_t    MPCP_GATE_TIMER_STS;           /* addr: 0x000000e4 */
  ca_uint32_t                              rsrvd58[3];                   
  EPON_XGONU_MPCP_MPCP_DEREG_CAUSE_t       MPCP_DEREG_CAUSE;              /* addr: 0x000000e8 */
  ca_uint32_t                              rsrvd59[3];                   
  EPON_XGONU_MPCP_MPCP_MON_CNTR_t          MPCP_MON_CNTR;                 /* addr: 0x000000ec */
  ca_uint32_t                              rsrvd60[3];                   
  EPON_XGONU_MPCP_MPCP_MON_STS_t           MPCP_MON_STS;                  /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd61[3];                   
  EPON_XGONU_MPCP_MPCP_LLID_DBG_t          MPCP_LLID_DBG;                 /* addr: 0x000000f4 */
  ca_uint32_t                              rsrvd62[3];                   
  EPON_XGONU_MPCP_MPCP_GRANT_FIFO_CTRL_t   MPCP_GRANT_FIFO_CTRL;          /* addr: 0x000000f8 */
  ca_uint32_t                              rsrvd63[3];                   
  EPON_XGONU_MPCP_MPCP_GRANT_FIFO_DATA_t   MPCP_GRANT_FIFO_DATA;          /* addr: 0x000000fc */
  ca_uint32_t                              rsrvd64[3];                   
  EPON_XGONU_MPCP_MPCP_RXPKT_CNTR_t        MPCP_RXPKT_CNTR;               /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd65[3];                   
  EPON_XGONU_MPCP_MPCP_TXPKT_CNTR_t        MPCP_TXPKT_CNTR;               /* addr: 0x00000104 */
  ca_uint32_t                              rsrvd66[3];                   
  EPON_XGONU_MPCP_CTL_RPT_TMR_t            CTL_RPT_TMR;                   /* addr: 0x00000108 */
  ca_uint32_t                              rsrvd67[3];                   
  EPON_XGONU_MPCP_POWER_SAVING_CFG_t       POWER_SAVING_CFG;              /* addr: 0x0000010c */
  ca_uint32_t                              rsrvd68[3];                   
  EPON_XGONU_MPCP_POWER_SAVING_STS_t       POWER_SAVING_STS;              /* addr: 0x00000110 */
  ca_uint32_t                              rsrvd69[3];                   
  EPON_XGONU_MPCP_SPARE_t                  SPARE;                         /* addr: 0x00000114 */
  ca_uint32_t                              rsrvd70[3];                   
  EPON_XGONU_MPCP_RSVR_t                   RSVR;                          /* addr: 0x00000118 */
  ca_uint32_t                              rsrvd71[3];                   
  EPON_XGONU_MPCP_MP_RPT_CNT_t             MP_RPT_CNT;                    /* addr: 0x0000011c */
  ca_uint32_t                              rsrvd72[3];                   
  EPON_XGONU_MPCP_MPCP_DISPKT_CNTR_t       MPCP_DISPKT_CNTR;              /* addr: 0x00000120 */
  ca_uint32_t                              rsrvd73[3];                   
  EPON_XGONU_MPCP_MPCP_DISPKT_PERIOD_t     MPCP_DISPKT_PERIOD;            /* addr: 0x00000124 */
  ca_uint32_t                              rsrvd74[3];                   
  EPON_XGONU_MPCP_MISC_t                   MISC;                          /* addr: 0x00000128 */
} APB1_EPON_XGONU_MPCP_t;

    
  
        
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* EPON */

typedef struct {
  APB1_EPON_EPON_GLB_t                     epon_glb;                      /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[1305];                 
  APB1_EPON_EPON_MIB_t                     epon_mib;                      /* addr: 0x00000600 */
  ca_uint32_t                              rsrvd2[469];                  
  APB1_EPON_ONU_EPON_t                     ONU_EPON;                      /* addr: 0x00000800 */
  ca_uint32_t                              rsrvd3[825];                  
  APB1_EPON_ONU_1PPS_t                     onu_1pps;                      /* addr: 0x00000c00 */
  ca_uint32_t                              rsrvd4[245];                  
  APB1_EPON_GLB_PTP_t                      glb_ptp;                       /* addr: 0x00000d00 */
  ca_uint32_t                              rsrvd5[493];                  
  APB1_EPON_ONU_LT_t                       onu_lt;                        /* addr: 0x00000f00 */
  ca_uint32_t                              rsrvd6[239];                  
  APB1_EPON_XGEPN_t                        XGEPN;                         /* addr: 0x00001000 */
  ca_uint32_t                              rsrvd7[2400];                 
  APB1_EPON_XGONU_MPCP_t                   xgonu_mpcp;                    /* addr: 0x00002000 */
} APB1_EPON_t;


/*
 * XGPN
 */
  
/*
 * xgpn_glb
 */
        
#define XGPN_XGPN_GLB_VERSION_ID                 0xd0034000
#define XGPN_XGPN_GLB_VERSION_ID_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t revid                : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_XGPN_GLB_VERSION_ID_t;


#define XGPN_XGPN_GLB_CTRL                       0xd0034004
#define XGPN_XGPN_GLB_CTRL_dft                   0x000000c0

typedef volatile union {
  struct {
    ca_uint32_t mac_en               :  2 ; /* bits 1:0 */
    ca_uint32_t power_saving_mode    :  2 ; /* bits 3:2 */
    ca_uint32_t pm_mode              :  2 ; /* bits 5:4 */
    ca_uint32_t us_line_rate         :  2 ; /* bits 7:6 */
    ca_uint32_t uwlch_id             :  4 ; /* bits 11:8 */
    ca_uint32_t rsrvd1               : 12 ;
    ca_uint32_t flush_id             :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t flush_en             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_XGPN_GLB_CTRL_t;


#define XGPN_XGPN_GLB_INTERRUPT0                 0xd0034008
#define XGPN_XGPN_GLB_INTERRUPT0_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t DSFP                 :  1 ; /* bits 0:0 */
    ca_uint32_t USBG                 :  1 ; /* bits 1:1 */
    ca_uint32_t PLMP                 :  1 ; /* bits 2:2 */
    ca_uint32_t BWMP                 :  1 ; /* bits 3:3 */
    ca_uint32_t ACTP                 :  1 ; /* bits 4:4 */
    ca_uint32_t AES                  :  1 ; /* bits 5:5 */
    ca_uint32_t AES_PLMP             :  1 ; /* bits 6:6 */
    ca_uint32_t XGFEC                :  1 ; /* bits 7:7 */
    ca_uint32_t RXCTL                :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_XGPN_GLB_INTERRUPT0_t;


#define XGPN_XGPN_GLB_INTERRUPT0E                0xd003400c
#define XGPN_XGPN_GLB_INTERRUPT0E_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t DSFPE                :  1 ; /* bits 0:0 */
    ca_uint32_t USBGE                :  1 ; /* bits 1:1 */
    ca_uint32_t PLMPE                :  1 ; /* bits 2:2 */
    ca_uint32_t BWMPE                :  1 ; /* bits 3:3 */
    ca_uint32_t ACTPE                :  1 ; /* bits 4:4 */
    ca_uint32_t AESE                 :  1 ; /* bits 5:5 */
    ca_uint32_t AES_PLMPE            :  1 ; /* bits 6:6 */
    ca_uint32_t XGFECE               :  1 ; /* bits 7:7 */
    ca_uint32_t RXCTLE               :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_XGPN_GLB_INTERRUPT0E_t;


#define XGPN_XGPN_GLB_INTERRUPT1                 0xd0034010
#define XGPN_XGPN_GLB_INTERRUPT1_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t DSFP                 :  1 ; /* bits 0:0 */
    ca_uint32_t USBG                 :  1 ; /* bits 1:1 */
    ca_uint32_t PLMP                 :  1 ; /* bits 2:2 */
    ca_uint32_t BWMP                 :  1 ; /* bits 3:3 */
    ca_uint32_t ACTP                 :  1 ; /* bits 4:4 */
    ca_uint32_t AES                  :  1 ; /* bits 5:5 */
    ca_uint32_t AES_PLMP             :  1 ; /* bits 6:6 */
    ca_uint32_t XGFEC                :  1 ; /* bits 7:7 */
    ca_uint32_t RXCTL                :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_XGPN_GLB_INTERRUPT1_t;


#define XGPN_XGPN_GLB_INTERRUPT1E                0xd0034014
#define XGPN_XGPN_GLB_INTERRUPT1E_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t DSFPE                :  1 ; /* bits 0:0 */
    ca_uint32_t USBGE                :  1 ; /* bits 1:1 */
    ca_uint32_t PLMPE                :  1 ; /* bits 2:2 */
    ca_uint32_t BWMPE                :  1 ; /* bits 3:3 */
    ca_uint32_t ACTPE                :  1 ; /* bits 4:4 */
    ca_uint32_t AESE                 :  1 ; /* bits 5:5 */
    ca_uint32_t AES_PLMPE            :  1 ; /* bits 6:6 */
    ca_uint32_t XGFECE               :  1 ; /* bits 7:7 */
    ca_uint32_t RXCTLE               :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_XGPN_GLB_INTERRUPT1E_t;


#define XGPN_XGPN_GLB_DEBUG_CTRL                 0xd0034018
#define XGPN_XGPN_GLB_DEBUG_CTRL_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sel                  :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_XGPN_GLB_DEBUG_CTRL_t;


#define XGPN_XGPN_GLB_DEBUG_STATUS0              0xd003401c
#define XGPN_XGPN_GLB_DEBUG_STATUS0_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_XGPN_GLB_DEBUG_STATUS0_t;


#define XGPN_XGPN_GLB_DEBUG_STATUS1              0xd0034020
#define XGPN_XGPN_GLB_DEBUG_STATUS1_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_XGPN_GLB_DEBUG_STATUS1_t;


#define XGPN_XGPN_GLB_SUPER_FRAME_MATCH_VAL1     0xd0034024
#define XGPN_XGPN_GLB_SUPER_FRAME_MATCH_VAL1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sfc1                 : 19 ; /* bits 18:0 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_XGPN_GLB_SUPER_FRAME_MATCH_VAL1_t;


#define XGPN_XGPN_GLB_SUPER_FRAME_MATCH_VAL0     0xd0034028
#define XGPN_XGPN_GLB_SUPER_FRAME_MATCH_VAL0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sfc0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_XGPN_GLB_SUPER_FRAME_MATCH_VAL0_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* xgpn_glb */
typedef struct {
  XGPN_XGPN_GLB_VERSION_ID_t               VERSION_ID;                    /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  XGPN_XGPN_GLB_CTRL_t                     CTRL;                          /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  XGPN_XGPN_GLB_INTERRUPT0_t               INTERRUPT0;                    /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  XGPN_XGPN_GLB_INTERRUPT0E_t              INTERRUPT0E;                   /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  XGPN_XGPN_GLB_INTERRUPT1_t               INTERRUPT1;                    /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  XGPN_XGPN_GLB_INTERRUPT1E_t              INTERRUPT1E;                   /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  XGPN_XGPN_GLB_DEBUG_CTRL_t               DEBUG_CTRL;                    /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  XGPN_XGPN_GLB_DEBUG_STATUS0_t            DEBUG_STATUS0;                 /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  XGPN_XGPN_GLB_DEBUG_STATUS1_t            DEBUG_STATUS1;                 /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  XGPN_XGPN_GLB_SUPER_FRAME_MATCH_VAL1_t   SUPER_FRAME_MATCH_VAL1;        /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  XGPN_XGPN_GLB_SUPER_FRAME_MATCH_VAL0_t   SUPER_FRAME_MATCH_VAL0;        /* addr: 0x00000028 */
} APB1_XGPN_XGPN_GLB_t;


/*
 * dsfp
 */
        
#define XGPN_DSFP_hec_ctl                        0xd0034100
#define XGPN_DSFP_hec_ctl_dft                    0x00000003

typedef volatile union {
  struct {
    ca_uint32_t hec0_en              :  1 ; /* bits 0:0 */
    ca_uint32_t hec1_en              :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_hec_ctl_t;


#define XGPN_DSFP_sync_ctl                       0xd0034104
#define XGPN_DSFP_sync_ctl_dft                   0x0003002d

typedef volatile union {
  struct {
    ca_uint32_t ds_descramble_en     :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t sfc_hecchk_en        :  1 ; /* bits 2:2 */
    ca_uint32_t ponid_hecchk_en      :  1 ; /* bits 3:3 */
    ca_uint32_t psbd_err_allow       :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  9 ;
    ca_uint32_t resync_loss_frame_num :  3 ; /* bits 18:16 */
    ca_uint32_t rsrvd3               : 11 ;
    ca_uint32_t byte_swap_en         :  1 ; /* bits 30:30 */
    ca_uint32_t bit_swap_en          :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_sync_ctl_t;


#define XGPN_DSFP_xgtc_ctl                       0xd0034108
#define XGPN_DSFP_xgtc_ctl_dft                   0x0000000f

typedef volatile union {
  struct {
    ca_uint32_t hec_chk_en           :  1 ; /* bits 0:0 */
    ca_uint32_t bwmp_en              :  1 ; /* bits 1:1 */
    ca_uint32_t ploam_en             :  1 ; /* bits 2:2 */
    ca_uint32_t ds_en                :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t drop_xgtc_frame_en   :  1 ; /* bits 28:28 */
    ca_uint32_t rsrvd2               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_xgtc_ctl_t;


#define XGPN_DSFP_xgem_ctl                       0xd003410c
#define XGPN_DSFP_xgem_ctl_dft                   0x00000019

typedef volatile union {
  struct {
    ca_uint32_t hec_chk_en           :  1 ; /* bits 0:0 */
    ca_uint32_t invld_key_xgem_drop_en :  1 ; /* bits 1:1 */
    ca_uint32_t old_key_xgem_drop_en :  1 ; /* bits 2:2 */
    ca_uint32_t los_word_cnt_clr_en  :  1 ; /* bits 3:3 */
    ca_uint32_t short_pkt_drop_en    :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_xgem_ctl_t;


#define XGPN_DSFP_rxmac_ctl                      0xd0034110
#define XGPN_DSFP_rxmac_ctl_dft                  0x07d00281

typedef volatile union {
  struct {
    ca_uint32_t crc_chk_en           :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t omci_min_pkt_size    :  6 ; /* bits 9:4 */
    ca_uint32_t rsrvd2               :  6 ;
    ca_uint32_t max_pkt_size         : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd3               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_rxmac_ctl_t;


#define XGPN_DSFP_rxmac_ctl1                     0xd0034114
#define XGPN_DSFP_rxmac_ctl1_dft                 0x07d00000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 16 ;
    ca_uint32_t max_pkt_size         : 11 ; /* bits 26:16 */
    ca_uint32_t rsrvd2               :  5 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_rxmac_ctl1_t;


#define XGPN_DSFP_INTERRUPT                      0xd0034118
#define XGPN_DSFP_INTERRUPT_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ds_losI              :  1 ; /* bits 0:0 */
    ca_uint32_t ds_psync_failI       :  1 ; /* bits 1:1 */
    ca_uint32_t ds_sfc_failI         :  1 ; /* bits 2:2 */
    ca_uint32_t xgem_fifo_overflowI  :  1 ; /* bits 3:3 */
    ca_uint32_t short_pkt_err        :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t xgem_portid_mismatchI :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t pkt_length_mismatchI :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd3               :  5 ;
    ca_uint32_t bip_32_errSat        :  1 ; /* bits 16:16 */
    ca_uint32_t bip_32_dw1Sat        :  1 ; /* bits 17:17 */
    ca_uint32_t psbd_hec_errSat      :  1 ; /* bits 18:18 */
    ca_uint32_t psbd_hec_uncorrected_mibSat :  1 ; /* bits 19:19 */
    ca_uint32_t xgtc_hec_correctedSat :  1 ; /* bits 20:20 */
    ca_uint32_t xgtc_hec_uncorrected_mibSat :  1 ; /* bits 21:21 */
    ca_uint32_t bwmap_hec_correctedSat :  1 ; /* bits 22:22 */
    ca_uint32_t bwmap_hec_uncorrected_mibSat :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd4               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_INTERRUPT_t;


#define XGPN_DSFP_INTERRUPTE0                    0xd003411c
#define XGPN_DSFP_INTERRUPTE0_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ds_losIE             :  1 ; /* bits 0:0 */
    ca_uint32_t ds_psync_failIE      :  1 ; /* bits 1:1 */
    ca_uint32_t ds_sfc_failIE        :  1 ; /* bits 2:2 */
    ca_uint32_t xgem_fifo_overflowIE :  1 ; /* bits 3:3 */
    ca_uint32_t short_pkt_errE       :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t xgem_portid_mismatchIE :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t pkt_length_mismatchIE :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd3               :  5 ;
    ca_uint32_t bip_32_errSatE       :  1 ; /* bits 16:16 */
    ca_uint32_t bip_32_dw1SatE       :  1 ; /* bits 17:17 */
    ca_uint32_t psbd_hec_errSatE     :  1 ; /* bits 18:18 */
    ca_uint32_t psbd_hec_uncorrected_mibSatE :  1 ; /* bits 19:19 */
    ca_uint32_t xgtc_hec_correctedSatE :  1 ; /* bits 20:20 */
    ca_uint32_t xgtc_hec_uncorrected_mibSatE :  1 ; /* bits 21:21 */
    ca_uint32_t bwmap_hec_correctedSatE :  1 ; /* bits 22:22 */
    ca_uint32_t bwmap_hec_uncorrected_mibSatE :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd4               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_INTERRUPTE0_t;


#define XGPN_DSFP_INTERRUPTE1                    0xd0034120
#define XGPN_DSFP_INTERRUPTE1_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ds_losIE             :  1 ; /* bits 0:0 */
    ca_uint32_t ds_psync_failIE      :  1 ; /* bits 1:1 */
    ca_uint32_t ds_sfc_failIE        :  1 ; /* bits 2:2 */
    ca_uint32_t xgem_fifo_overflowIE :  1 ; /* bits 3:3 */
    ca_uint32_t short_pkt_errE       :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t xgem_portid_mismatchIE :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t pkt_length_mismatchIE :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd3               :  5 ;
    ca_uint32_t bip_32_errSatE       :  1 ; /* bits 16:16 */
    ca_uint32_t bip_32_dw1SatE       :  1 ; /* bits 17:17 */
    ca_uint32_t psbd_hec_errSatE     :  1 ; /* bits 18:18 */
    ca_uint32_t psbd_hec_uncorrected_mibSatE :  1 ; /* bits 19:19 */
    ca_uint32_t xgtc_hec_correctedSatE :  1 ; /* bits 20:20 */
    ca_uint32_t xgtc_hec_uncorrected_mibSatE :  1 ; /* bits 21:21 */
    ca_uint32_t bwmap_hec_correctedSatE :  1 ; /* bits 22:22 */
    ca_uint32_t bwmap_hec_uncorrected_mibSatE :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd4               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_INTERRUPTE1_t;


#define XGPN_DSFP_xgem_key_ctl                   0xd0034124
#define XGPN_DSFP_xgem_key_ctl_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key0_idx_vld         :  1 ; /* bits 0:0 */
    ca_uint32_t key1_idx_vld         :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_xgem_key_ctl_t;


#define XGPN_DSFP_xgem_mc_key_ctl                0xd0034128
#define XGPN_DSFP_xgem_mc_key_ctl_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key0_idx_vld         :  1 ; /* bits 0:0 */
    ca_uint32_t key1_idx_vld         :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_xgem_mc_key_ctl_t;


#define XGPN_DSFP_portid0_ctl_xgem               0xd003412c
#define XGPN_DSFP_portid0_ctl_xgem_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid0_ctl_xgem_t;


#define XGPN_DSFP_portid1_ctl_xgem               0xd0034130
#define XGPN_DSFP_portid1_ctl_xgem_dft           0x00000001

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid1_ctl_xgem_t;


#define XGPN_DSFP_portid2_ctl_xgem               0xd0034134
#define XGPN_DSFP_portid2_ctl_xgem_dft           0x00000002

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid2_ctl_xgem_t;


#define XGPN_DSFP_portid3_ctl_xgem               0xd0034138
#define XGPN_DSFP_portid3_ctl_xgem_dft           0x00000003

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid3_ctl_xgem_t;


#define XGPN_DSFP_portid4_ctl_xgem               0xd003413c
#define XGPN_DSFP_portid4_ctl_xgem_dft           0x00000004

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid4_ctl_xgem_t;


#define XGPN_DSFP_portid5_ctl_xgem               0xd0034140
#define XGPN_DSFP_portid5_ctl_xgem_dft           0x00000005

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid5_ctl_xgem_t;


#define XGPN_DSFP_portid6_ctl_xgem               0xd0034144
#define XGPN_DSFP_portid6_ctl_xgem_dft           0x00000006

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid6_ctl_xgem_t;


#define XGPN_DSFP_portid7_ctl_xgem               0xd0034148
#define XGPN_DSFP_portid7_ctl_xgem_dft           0x00000007

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid7_ctl_xgem_t;


#define XGPN_DSFP_portid8_ctl_xgem               0xd003414c
#define XGPN_DSFP_portid8_ctl_xgem_dft           0x00000008

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid8_ctl_xgem_t;


#define XGPN_DSFP_portid9_ctl_xgem               0xd0034150
#define XGPN_DSFP_portid9_ctl_xgem_dft           0x00000009

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid9_ctl_xgem_t;


#define XGPN_DSFP_portid10_ctl_xgem              0xd0034154
#define XGPN_DSFP_portid10_ctl_xgem_dft          0x0000000a

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid10_ctl_xgem_t;


#define XGPN_DSFP_portid11_ctl_xgem              0xd0034158
#define XGPN_DSFP_portid11_ctl_xgem_dft          0x0000000b

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid11_ctl_xgem_t;


#define XGPN_DSFP_portid12_ctl_xgem              0xd003415c
#define XGPN_DSFP_portid12_ctl_xgem_dft          0x0000000c

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid12_ctl_xgem_t;


#define XGPN_DSFP_portid13_ctl_xgem              0xd0034160
#define XGPN_DSFP_portid13_ctl_xgem_dft          0x0000000d

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid13_ctl_xgem_t;


#define XGPN_DSFP_portid14_ctl_xgem              0xd0034164
#define XGPN_DSFP_portid14_ctl_xgem_dft          0x0000000e

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid14_ctl_xgem_t;


#define XGPN_DSFP_portid15_ctl_xgem              0xd0034168
#define XGPN_DSFP_portid15_ctl_xgem_dft          0x0000000f

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid15_ctl_xgem_t;


#define XGPN_DSFP_portid16_ctl_xgem              0xd003416c
#define XGPN_DSFP_portid16_ctl_xgem_dft          0x00000010

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid16_ctl_xgem_t;


#define XGPN_DSFP_portid17_ctl_xgem              0xd0034170
#define XGPN_DSFP_portid17_ctl_xgem_dft          0x00000011

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid17_ctl_xgem_t;


#define XGPN_DSFP_portid18_ctl_xgem              0xd0034174
#define XGPN_DSFP_portid18_ctl_xgem_dft          0x00000012

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid18_ctl_xgem_t;


#define XGPN_DSFP_portid19_ctl_xgem              0xd0034178
#define XGPN_DSFP_portid19_ctl_xgem_dft          0x00000013

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid19_ctl_xgem_t;


#define XGPN_DSFP_portid20_ctl_xgem              0xd003417c
#define XGPN_DSFP_portid20_ctl_xgem_dft          0x00000014

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid20_ctl_xgem_t;


#define XGPN_DSFP_portid21_ctl_xgem              0xd0034180
#define XGPN_DSFP_portid21_ctl_xgem_dft          0x00000015

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid21_ctl_xgem_t;


#define XGPN_DSFP_portid22_ctl_xgem              0xd0034184
#define XGPN_DSFP_portid22_ctl_xgem_dft          0x00000016

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid22_ctl_xgem_t;


#define XGPN_DSFP_portid23_ctl_xgem              0xd0034188
#define XGPN_DSFP_portid23_ctl_xgem_dft          0x00000017

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid23_ctl_xgem_t;


#define XGPN_DSFP_portid24_ctl_xgem              0xd003418c
#define XGPN_DSFP_portid24_ctl_xgem_dft          0x00000018

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid24_ctl_xgem_t;


#define XGPN_DSFP_portid25_ctl_xgem              0xd0034190
#define XGPN_DSFP_portid25_ctl_xgem_dft          0x00000019

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid25_ctl_xgem_t;


#define XGPN_DSFP_portid26_ctl_xgem              0xd0034194
#define XGPN_DSFP_portid26_ctl_xgem_dft          0x0000001a

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid26_ctl_xgem_t;


#define XGPN_DSFP_portid27_ctl_xgem              0xd0034198
#define XGPN_DSFP_portid27_ctl_xgem_dft          0x0000001b

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid27_ctl_xgem_t;


#define XGPN_DSFP_portid28_ctl_xgem              0xd003419c
#define XGPN_DSFP_portid28_ctl_xgem_dft          0x0000001c

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid28_ctl_xgem_t;


#define XGPN_DSFP_portid29_ctl_xgem              0xd00341a0
#define XGPN_DSFP_portid29_ctl_xgem_dft          0x0000001d

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid29_ctl_xgem_t;


#define XGPN_DSFP_portid30_ctl_xgem              0xd00341a4
#define XGPN_DSFP_portid30_ctl_xgem_dft          0x0000001e

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid30_ctl_xgem_t;


#define XGPN_DSFP_portid31_ctl_xgem              0xd00341a8
#define XGPN_DSFP_portid31_ctl_xgem_dft          0x0000001f

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid31_ctl_xgem_t;


#define XGPN_DSFP_portid32_ctl_xgem              0xd00341ac
#define XGPN_DSFP_portid32_ctl_xgem_dft          0x00000020

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid32_ctl_xgem_t;


#define XGPN_DSFP_portid33_ctl_xgem              0xd00341b0
#define XGPN_DSFP_portid33_ctl_xgem_dft          0x00000021

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid33_ctl_xgem_t;


#define XGPN_DSFP_portid34_ctl_xgem              0xd00341b4
#define XGPN_DSFP_portid34_ctl_xgem_dft          0x00000022

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid34_ctl_xgem_t;


#define XGPN_DSFP_portid35_ctl_xgem              0xd00341b8
#define XGPN_DSFP_portid35_ctl_xgem_dft          0x00000023

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid35_ctl_xgem_t;


#define XGPN_DSFP_portid36_ctl_xgem              0xd00341bc
#define XGPN_DSFP_portid36_ctl_xgem_dft          0x00000024

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid36_ctl_xgem_t;


#define XGPN_DSFP_portid37_ctl_xgem              0xd00341c0
#define XGPN_DSFP_portid37_ctl_xgem_dft          0x00000025

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid37_ctl_xgem_t;


#define XGPN_DSFP_portid38_ctl_xgem              0xd00341c4
#define XGPN_DSFP_portid38_ctl_xgem_dft          0x00000026

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid38_ctl_xgem_t;


#define XGPN_DSFP_portid39_ctl_xgem              0xd00341c8
#define XGPN_DSFP_portid39_ctl_xgem_dft          0x00000027

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid39_ctl_xgem_t;


#define XGPN_DSFP_portid40_ctl_xgem              0xd00341cc
#define XGPN_DSFP_portid40_ctl_xgem_dft          0x00000028

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid40_ctl_xgem_t;


#define XGPN_DSFP_portid41_ctl_xgem              0xd00341d0
#define XGPN_DSFP_portid41_ctl_xgem_dft          0x00000029

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid41_ctl_xgem_t;


#define XGPN_DSFP_portid42_ctl_xgem              0xd00341d4
#define XGPN_DSFP_portid42_ctl_xgem_dft          0x0000002a

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid42_ctl_xgem_t;


#define XGPN_DSFP_portid43_ctl_xgem              0xd00341d8
#define XGPN_DSFP_portid43_ctl_xgem_dft          0x0000002b

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid43_ctl_xgem_t;


#define XGPN_DSFP_portid44_ctl_xgem              0xd00341dc
#define XGPN_DSFP_portid44_ctl_xgem_dft          0x0000002c

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid44_ctl_xgem_t;


#define XGPN_DSFP_portid45_ctl_xgem              0xd00341e0
#define XGPN_DSFP_portid45_ctl_xgem_dft          0x0000002d

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid45_ctl_xgem_t;


#define XGPN_DSFP_portid46_ctl_xgem              0xd00341e4
#define XGPN_DSFP_portid46_ctl_xgem_dft          0x0000002e

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid46_ctl_xgem_t;


#define XGPN_DSFP_portid47_ctl_xgem              0xd00341e8
#define XGPN_DSFP_portid47_ctl_xgem_dft          0x0000002f

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid47_ctl_xgem_t;


#define XGPN_DSFP_portid48_ctl_xgem              0xd00341ec
#define XGPN_DSFP_portid48_ctl_xgem_dft          0x00000030

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid48_ctl_xgem_t;


#define XGPN_DSFP_portid49_ctl_xgem              0xd00341f0
#define XGPN_DSFP_portid49_ctl_xgem_dft          0x00000031

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid49_ctl_xgem_t;


#define XGPN_DSFP_portid50_ctl_xgem              0xd00341f4
#define XGPN_DSFP_portid50_ctl_xgem_dft          0x00000032

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid50_ctl_xgem_t;


#define XGPN_DSFP_portid51_ctl_xgem              0xd00341f8
#define XGPN_DSFP_portid51_ctl_xgem_dft          0x00000033

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid51_ctl_xgem_t;


#define XGPN_DSFP_portid52_ctl_xgem              0xd00341fc
#define XGPN_DSFP_portid52_ctl_xgem_dft          0x00000034

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid52_ctl_xgem_t;


#define XGPN_DSFP_portid53_ctl_xgem              0xd0034200
#define XGPN_DSFP_portid53_ctl_xgem_dft          0x00000035

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid53_ctl_xgem_t;


#define XGPN_DSFP_portid54_ctl_xgem              0xd0034204
#define XGPN_DSFP_portid54_ctl_xgem_dft          0x00000036

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid54_ctl_xgem_t;


#define XGPN_DSFP_portid55_ctl_xgem              0xd0034208
#define XGPN_DSFP_portid55_ctl_xgem_dft          0x00000037

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid55_ctl_xgem_t;


#define XGPN_DSFP_portid56_ctl_xgem              0xd003420c
#define XGPN_DSFP_portid56_ctl_xgem_dft          0x00000038

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid56_ctl_xgem_t;


#define XGPN_DSFP_portid57_ctl_xgem              0xd0034210
#define XGPN_DSFP_portid57_ctl_xgem_dft          0x00000039

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid57_ctl_xgem_t;


#define XGPN_DSFP_portid58_ctl_xgem              0xd0034214
#define XGPN_DSFP_portid58_ctl_xgem_dft          0x0000003a

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid58_ctl_xgem_t;


#define XGPN_DSFP_portid59_ctl_xgem              0xd0034218
#define XGPN_DSFP_portid59_ctl_xgem_dft          0x0000003b

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid59_ctl_xgem_t;


#define XGPN_DSFP_portid60_ctl_xgem              0xd003421c
#define XGPN_DSFP_portid60_ctl_xgem_dft          0x0000003c

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid60_ctl_xgem_t;


#define XGPN_DSFP_portid61_ctl_xgem              0xd0034220
#define XGPN_DSFP_portid61_ctl_xgem_dft          0x0000003d

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid61_ctl_xgem_t;


#define XGPN_DSFP_portid62_ctl_xgem              0xd0034224
#define XGPN_DSFP_portid62_ctl_xgem_dft          0x0000003e

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid62_ctl_xgem_t;


#define XGPN_DSFP_portid63_ctl_xgem              0xd0034228
#define XGPN_DSFP_portid63_ctl_xgem_dft          0x0000003f

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid63_ctl_xgem_t;


#define XGPN_DSFP_portid64_ctl_xgem              0xd003422c
#define XGPN_DSFP_portid64_ctl_xgem_dft          0x00000040

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid64_ctl_xgem_t;


#define XGPN_DSFP_portid65_ctl_xgem              0xd0034230
#define XGPN_DSFP_portid65_ctl_xgem_dft          0x00000041

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid65_ctl_xgem_t;


#define XGPN_DSFP_portid66_ctl_xgem              0xd0034234
#define XGPN_DSFP_portid66_ctl_xgem_dft          0x00000042

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid66_ctl_xgem_t;


#define XGPN_DSFP_portid67_ctl_xgem              0xd0034238
#define XGPN_DSFP_portid67_ctl_xgem_dft          0x00000043

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid67_ctl_xgem_t;


#define XGPN_DSFP_portid68_ctl_xgem              0xd003423c
#define XGPN_DSFP_portid68_ctl_xgem_dft          0x00000044

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid68_ctl_xgem_t;


#define XGPN_DSFP_portid69_ctl_xgem              0xd0034240
#define XGPN_DSFP_portid69_ctl_xgem_dft          0x00000045

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid69_ctl_xgem_t;


#define XGPN_DSFP_portid70_ctl_xgem              0xd0034244
#define XGPN_DSFP_portid70_ctl_xgem_dft          0x00000046

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid70_ctl_xgem_t;


#define XGPN_DSFP_portid71_ctl_xgem              0xd0034248
#define XGPN_DSFP_portid71_ctl_xgem_dft          0x00000047

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid71_ctl_xgem_t;


#define XGPN_DSFP_portid72_ctl_xgem              0xd003424c
#define XGPN_DSFP_portid72_ctl_xgem_dft          0x00000048

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid72_ctl_xgem_t;


#define XGPN_DSFP_portid73_ctl_xgem              0xd0034250
#define XGPN_DSFP_portid73_ctl_xgem_dft          0x00000049

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid73_ctl_xgem_t;


#define XGPN_DSFP_portid74_ctl_xgem              0xd0034254
#define XGPN_DSFP_portid74_ctl_xgem_dft          0x0000004a

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid74_ctl_xgem_t;


#define XGPN_DSFP_portid75_ctl_xgem              0xd0034258
#define XGPN_DSFP_portid75_ctl_xgem_dft          0x0000004b

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid75_ctl_xgem_t;


#define XGPN_DSFP_portid76_ctl_xgem              0xd003425c
#define XGPN_DSFP_portid76_ctl_xgem_dft          0x0000004c

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid76_ctl_xgem_t;


#define XGPN_DSFP_portid77_ctl_xgem              0xd0034260
#define XGPN_DSFP_portid77_ctl_xgem_dft          0x0000004d

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid77_ctl_xgem_t;


#define XGPN_DSFP_portid78_ctl_xgem              0xd0034264
#define XGPN_DSFP_portid78_ctl_xgem_dft          0x0000004e

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid78_ctl_xgem_t;


#define XGPN_DSFP_portid79_ctl_xgem              0xd0034268
#define XGPN_DSFP_portid79_ctl_xgem_dft          0x0000004f

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid79_ctl_xgem_t;


#define XGPN_DSFP_portid80_ctl_xgem              0xd003426c
#define XGPN_DSFP_portid80_ctl_xgem_dft          0x00000050

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid80_ctl_xgem_t;


#define XGPN_DSFP_portid81_ctl_xgem              0xd0034270
#define XGPN_DSFP_portid81_ctl_xgem_dft          0x00000051

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid81_ctl_xgem_t;


#define XGPN_DSFP_portid82_ctl_xgem              0xd0034274
#define XGPN_DSFP_portid82_ctl_xgem_dft          0x00000052

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid82_ctl_xgem_t;


#define XGPN_DSFP_portid83_ctl_xgem              0xd0034278
#define XGPN_DSFP_portid83_ctl_xgem_dft          0x00000053

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid83_ctl_xgem_t;


#define XGPN_DSFP_portid84_ctl_xgem              0xd003427c
#define XGPN_DSFP_portid84_ctl_xgem_dft          0x00000054

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid84_ctl_xgem_t;


#define XGPN_DSFP_portid85_ctl_xgem              0xd0034280
#define XGPN_DSFP_portid85_ctl_xgem_dft          0x00000055

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid85_ctl_xgem_t;


#define XGPN_DSFP_portid86_ctl_xgem              0xd0034284
#define XGPN_DSFP_portid86_ctl_xgem_dft          0x00000056

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid86_ctl_xgem_t;


#define XGPN_DSFP_portid87_ctl_xgem              0xd0034288
#define XGPN_DSFP_portid87_ctl_xgem_dft          0x00000057

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid87_ctl_xgem_t;


#define XGPN_DSFP_portid88_ctl_xgem              0xd003428c
#define XGPN_DSFP_portid88_ctl_xgem_dft          0x00000058

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid88_ctl_xgem_t;


#define XGPN_DSFP_portid89_ctl_xgem              0xd0034290
#define XGPN_DSFP_portid89_ctl_xgem_dft          0x00000059

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid89_ctl_xgem_t;


#define XGPN_DSFP_portid90_ctl_xgem              0xd0034294
#define XGPN_DSFP_portid90_ctl_xgem_dft          0x0000005a

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid90_ctl_xgem_t;


#define XGPN_DSFP_portid91_ctl_xgem              0xd0034298
#define XGPN_DSFP_portid91_ctl_xgem_dft          0x0000005b

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid91_ctl_xgem_t;


#define XGPN_DSFP_portid92_ctl_xgem              0xd003429c
#define XGPN_DSFP_portid92_ctl_xgem_dft          0x0000005c

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid92_ctl_xgem_t;


#define XGPN_DSFP_portid93_ctl_xgem              0xd00342a0
#define XGPN_DSFP_portid93_ctl_xgem_dft          0x0000005d

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid93_ctl_xgem_t;


#define XGPN_DSFP_portid94_ctl_xgem              0xd00342a4
#define XGPN_DSFP_portid94_ctl_xgem_dft          0x0000005e

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid94_ctl_xgem_t;


#define XGPN_DSFP_portid95_ctl_xgem              0xd00342a8
#define XGPN_DSFP_portid95_ctl_xgem_dft          0x0000005f

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid95_ctl_xgem_t;


#define XGPN_DSFP_portid96_ctl_xgem              0xd00342ac
#define XGPN_DSFP_portid96_ctl_xgem_dft          0x00000060

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid96_ctl_xgem_t;


#define XGPN_DSFP_portid97_ctl_xgem              0xd00342b0
#define XGPN_DSFP_portid97_ctl_xgem_dft          0x00000061

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid97_ctl_xgem_t;


#define XGPN_DSFP_portid98_ctl_xgem              0xd00342b4
#define XGPN_DSFP_portid98_ctl_xgem_dft          0x00000062

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid98_ctl_xgem_t;


#define XGPN_DSFP_portid99_ctl_xgem              0xd00342b8
#define XGPN_DSFP_portid99_ctl_xgem_dft          0x00000063

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid99_ctl_xgem_t;


#define XGPN_DSFP_portid100_ctl_xgem             0xd00342bc
#define XGPN_DSFP_portid100_ctl_xgem_dft         0x00000064

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid100_ctl_xgem_t;


#define XGPN_DSFP_portid101_ctl_xgem             0xd00342c0
#define XGPN_DSFP_portid101_ctl_xgem_dft         0x00000065

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid101_ctl_xgem_t;


#define XGPN_DSFP_portid102_ctl_xgem             0xd00342c4
#define XGPN_DSFP_portid102_ctl_xgem_dft         0x00000066

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid102_ctl_xgem_t;


#define XGPN_DSFP_portid103_ctl_xgem             0xd00342c8
#define XGPN_DSFP_portid103_ctl_xgem_dft         0x00000067

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid103_ctl_xgem_t;


#define XGPN_DSFP_portid104_ctl_xgem             0xd00342cc
#define XGPN_DSFP_portid104_ctl_xgem_dft         0x00000068

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid104_ctl_xgem_t;


#define XGPN_DSFP_portid105_ctl_xgem             0xd00342d0
#define XGPN_DSFP_portid105_ctl_xgem_dft         0x00000069

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid105_ctl_xgem_t;


#define XGPN_DSFP_portid106_ctl_xgem             0xd00342d4
#define XGPN_DSFP_portid106_ctl_xgem_dft         0x0000006a

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid106_ctl_xgem_t;


#define XGPN_DSFP_portid107_ctl_xgem             0xd00342d8
#define XGPN_DSFP_portid107_ctl_xgem_dft         0x0000006b

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid107_ctl_xgem_t;


#define XGPN_DSFP_portid108_ctl_xgem             0xd00342dc
#define XGPN_DSFP_portid108_ctl_xgem_dft         0x0000006c

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid108_ctl_xgem_t;


#define XGPN_DSFP_portid109_ctl_xgem             0xd00342e0
#define XGPN_DSFP_portid109_ctl_xgem_dft         0x0000006d

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid109_ctl_xgem_t;


#define XGPN_DSFP_portid110_ctl_xgem             0xd00342e4
#define XGPN_DSFP_portid110_ctl_xgem_dft         0x0000006e

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid110_ctl_xgem_t;


#define XGPN_DSFP_portid111_ctl_xgem             0xd00342e8
#define XGPN_DSFP_portid111_ctl_xgem_dft         0x0000006f

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid111_ctl_xgem_t;


#define XGPN_DSFP_portid112_ctl_xgem             0xd00342ec
#define XGPN_DSFP_portid112_ctl_xgem_dft         0x00000070

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid112_ctl_xgem_t;


#define XGPN_DSFP_portid113_ctl_xgem             0xd00342f0
#define XGPN_DSFP_portid113_ctl_xgem_dft         0x00000071

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid113_ctl_xgem_t;


#define XGPN_DSFP_portid114_ctl_xgem             0xd00342f4
#define XGPN_DSFP_portid114_ctl_xgem_dft         0x00000072

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid114_ctl_xgem_t;


#define XGPN_DSFP_portid115_ctl_xgem             0xd00342f8
#define XGPN_DSFP_portid115_ctl_xgem_dft         0x00000073

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid115_ctl_xgem_t;


#define XGPN_DSFP_portid116_ctl_xgem             0xd00342fc
#define XGPN_DSFP_portid116_ctl_xgem_dft         0x00000074

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid116_ctl_xgem_t;


#define XGPN_DSFP_portid117_ctl_xgem             0xd0034300
#define XGPN_DSFP_portid117_ctl_xgem_dft         0x00000075

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid117_ctl_xgem_t;


#define XGPN_DSFP_portid118_ctl_xgem             0xd0034304
#define XGPN_DSFP_portid118_ctl_xgem_dft         0x00000076

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid118_ctl_xgem_t;


#define XGPN_DSFP_portid119_ctl_xgem             0xd0034308
#define XGPN_DSFP_portid119_ctl_xgem_dft         0x00000077

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid119_ctl_xgem_t;


#define XGPN_DSFP_portid120_ctl_xgem             0xd003430c
#define XGPN_DSFP_portid120_ctl_xgem_dft         0x00000078

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid120_ctl_xgem_t;


#define XGPN_DSFP_portid121_ctl_xgem             0xd0034310
#define XGPN_DSFP_portid121_ctl_xgem_dft         0x00000079

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid121_ctl_xgem_t;


#define XGPN_DSFP_portid122_ctl_xgem             0xd0034314
#define XGPN_DSFP_portid122_ctl_xgem_dft         0x0000007a

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid122_ctl_xgem_t;


#define XGPN_DSFP_portid123_ctl_xgem             0xd0034318
#define XGPN_DSFP_portid123_ctl_xgem_dft         0x0000007b

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid123_ctl_xgem_t;


#define XGPN_DSFP_portid124_ctl_xgem             0xd003431c
#define XGPN_DSFP_portid124_ctl_xgem_dft         0x0000007c

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid124_ctl_xgem_t;


#define XGPN_DSFP_portid125_ctl_xgem             0xd0034320
#define XGPN_DSFP_portid125_ctl_xgem_dft         0x0000007d

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid125_ctl_xgem_t;


#define XGPN_DSFP_portid126_ctl_xgem             0xd0034324
#define XGPN_DSFP_portid126_ctl_xgem_dft         0x0000007e

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid126_ctl_xgem_t;


#define XGPN_DSFP_portid127_ctl_xgem             0xd0034328
#define XGPN_DSFP_portid127_ctl_xgem_dft         0x0000007f

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid127_ctl_xgem_t;


#define XGPN_DSFP_ds_sync                        0xd003432c
#define XGPN_DSFP_ds_sync_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t state                :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_ds_sync_t;


#define XGPN_DSFP_superframe1                    0xd0034330
#define XGPN_DSFP_superframe1_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt1                 : 19 ; /* bits 18:0 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_superframe1_t;


#define XGPN_DSFP_superframe0                    0xd0034334
#define XGPN_DSFP_superframe0_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_superframe0_t;


#define XGPN_DSFP_OC_body1                       0xd0034338
#define XGPN_DSFP_OC_body1_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t TOL1                 :  9 ; /* bits 8:0 */
    ca_uint32_t C_flag1              :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t link_type1           :  2 ; /* bits 12:11 */
    ca_uint32_t P_flag1              :  1 ; /* bits 13:13 */
    ca_uint32_t DS_FEC_flag1         :  1 ; /* bits 14:14 */
    ca_uint32_t ODN_class1           :  3 ; /* bits 17:15 */
    ca_uint32_t RE_flag1             :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd2               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_OC_body1_t;


#define XGPN_DSFP_OC_body0                       0xd003433c
#define XGPN_DSFP_OC_body0_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pon_id0              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_OC_body0_t;


#define XGPN_DSFP_bip_32_dw1                     0xd0034340
#define XGPN_DSFP_bip_32_dw1_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_bip_32_dw1_t;


#define XGPN_DSFP_bip_32_dw0                     0xd0034344
#define XGPN_DSFP_bip_32_dw0_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_bip_32_dw0_t;


#define XGPN_DSFP_bip_32_err                     0xd0034348
#define XGPN_DSFP_bip_32_err_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_bip_32_err_t;


#define XGPN_DSFP_psbd_hec_err                   0xd003434c
#define XGPN_DSFP_psbd_hec_err_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_psbd_hec_err_t;


#define XGPN_DSFP_sfc_hec_corrected              0xd0034350
#define XGPN_DSFP_sfc_hec_corrected_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_sfc_hec_corrected_t;


#define XGPN_DSFP_sfc_hec_uncorrected_mib        0xd0034354
#define XGPN_DSFP_sfc_hec_uncorrected_mib_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_sfc_hec_uncorrected_mib_t;


#define XGPN_DSFP_ponid_hec_corrected            0xd0034358
#define XGPN_DSFP_ponid_hec_corrected_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_ponid_hec_corrected_t;


#define XGPN_DSFP_ponid_hec_uncorrected_mib      0xd003435c
#define XGPN_DSFP_ponid_hec_uncorrected_mib_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_ponid_hec_uncorrected_mib_t;


#define XGPN_DSFP_psbd_hec_uncorrected_mib       0xd0034360
#define XGPN_DSFP_psbd_hec_uncorrected_mib_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_psbd_hec_uncorrected_mib_t;


#define XGPN_DSFP_bwmap_hec_corrected            0xd0034364
#define XGPN_DSFP_bwmap_hec_corrected_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_bwmap_hec_corrected_t;


#define XGPN_DSFP_bwmap_hec_uncorrected_mib      0xd0034368
#define XGPN_DSFP_bwmap_hec_uncorrected_mib_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_bwmap_hec_uncorrected_mib_t;


#define XGPN_DSFP_xgtc_err                       0xd003436c
#define XGPN_DSFP_xgtc_err_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hd                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_xgtc_err_t;


#define XGPN_DSFP_xgtc_frame                     0xd0034370
#define XGPN_DSFP_xgtc_frame_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_xgtc_frame_t;


#define XGPN_DSFP_xgtc_hec_corrected             0xd0034374
#define XGPN_DSFP_xgtc_hec_corrected_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_xgtc_hec_corrected_t;


#define XGPN_DSFP_xgtc_hec_uncorrected_mib       0xd0034378
#define XGPN_DSFP_xgtc_hec_uncorrected_mib_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_xgtc_hec_uncorrected_mib_t;


#define XGPN_DSFP_xgem_err0                      0xd003437c
#define XGPN_DSFP_xgem_err0_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hd                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_xgem_err0_t;


#define XGPN_DSFP_xgem_err1                      0xd0034380
#define XGPN_DSFP_xgem_err1_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hd                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_xgem_err1_t;


#define XGPN_DSFP_xgem_frame                     0xd0034384
#define XGPN_DSFP_xgem_frame_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_xgem_frame_t;


#define XGPN_DSFP_xgem_hec_corrected             0xd0034388
#define XGPN_DSFP_xgem_hec_corrected_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_xgem_hec_corrected_t;


#define XGPN_DSFP_xgem_hec_uncorrected_mib       0xd003438c
#define XGPN_DSFP_xgem_hec_uncorrected_mib_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_xgem_hec_uncorrected_mib_t;


#define XGPN_DSFP_xgem_nolf_mib                  0xd0034390
#define XGPN_DSFP_xgem_nolf_mib_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_xgem_nolf_mib_t;


#define XGPN_DSFP_xgem_los_word_mib              0xd0034394
#define XGPN_DSFP_xgem_los_word_mib_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_xgem_los_word_mib_t;


#define XGPN_DSFP_xgem_err_key_mib               0xd0034398
#define XGPN_DSFP_xgem_err_key_mib_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_xgem_err_key_mib_t;


#define XGPN_DSFP_rxmac_xgem_frame               0xd003439c
#define XGPN_DSFP_rxmac_xgem_frame_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_rxmac_xgem_frame_t;


#define XGPN_DSFP_rxmac_omci_frame               0xd00343a0
#define XGPN_DSFP_rxmac_omci_frame_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_rxmac_omci_frame_t;


#define XGPN_DSFP_rxmac_pkt_frame                0xd00343a4
#define XGPN_DSFP_rxmac_pkt_frame_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_rxmac_pkt_frame_t;


#define XGPN_DSFP_rxmac_pkt_crc_err              0xd00343a8
#define XGPN_DSFP_rxmac_pkt_crc_err_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_rxmac_pkt_crc_err_t;


#define XGPN_DSFP_rxmac_xgem_frame_status        0xd00343ac
#define XGPN_DSFP_rxmac_xgem_frame_status_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t fg_xgem_err          :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_rxmac_xgem_frame_status_t;


#define XGPN_DSFP_async_ff_status                0xd00343b0
#define XGPN_DSFP_async_ff_status_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t overflow             :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_async_ff_status_t;


#define XGPN_DSFP_MIB_RAM_STATUS_REG             0xd00343b4
#define XGPN_DSFP_MIB_RAM_STATUS_REG_dft         0x00000001

typedef volatile union {
  struct {
    ca_uint32_t ram_initdone         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_MIB_RAM_STATUS_REG_t;


#define XGPN_DSFP_PORTID_XGEM_MIB_ACCESS         0xd00343b8
#define XGPN_DSFP_PORTID_XGEM_MIB_ACCESS_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rw                   :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_PORTID_XGEM_MIB_ACCESS_t;


#define XGPN_DSFP_PORTID_XGEM_MIB_DATA2          0xd00343bc
#define XGPN_DSFP_PORTID_XGEM_MIB_DATA2_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t byte_cnt             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_PORTID_XGEM_MIB_DATA2_t;


#define XGPN_DSFP_PORTID_XGEM_MIB_DATA1          0xd00343c0
#define XGPN_DSFP_PORTID_XGEM_MIB_DATA1_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t byte_cnt             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_PORTID_XGEM_MIB_DATA1_t;


#define XGPN_DSFP_PORTID_XGEM_MIB_DATA0          0xd00343c4
#define XGPN_DSFP_PORTID_XGEM_MIB_DATA0_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t frame_cnt            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_PORTID_XGEM_MIB_DATA0_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* dsfp */
typedef struct {
  XGPN_DSFP_hec_ctl_t                      hec_ctl;                       /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  XGPN_DSFP_sync_ctl_t                     sync_ctl;                      /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  XGPN_DSFP_xgtc_ctl_t                     xgtc_ctl;                      /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  XGPN_DSFP_xgem_ctl_t                     xgem_ctl;                      /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  XGPN_DSFP_rxmac_ctl_t                    rxmac_ctl;                     /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  XGPN_DSFP_rxmac_ctl1_t                   rxmac_ctl1;                    /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  XGPN_DSFP_INTERRUPT_t                    INTERRUPT;                     /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  XGPN_DSFP_INTERRUPTE0_t                  INTERRUPTE0;                   /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  XGPN_DSFP_INTERRUPTE1_t                  INTERRUPTE1;                   /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  XGPN_DSFP_xgem_key_ctl_t                 xgem_key_ctl;                  /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  XGPN_DSFP_xgem_mc_key_ctl_t              xgem_mc_key_ctl;               /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  XGPN_DSFP_portid0_ctl_xgem_t             portid0_ctl_xgem;              /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  XGPN_DSFP_portid1_ctl_xgem_t             portid1_ctl_xgem;              /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  XGPN_DSFP_portid2_ctl_xgem_t             portid2_ctl_xgem;              /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  XGPN_DSFP_portid3_ctl_xgem_t             portid3_ctl_xgem;              /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  XGPN_DSFP_portid4_ctl_xgem_t             portid4_ctl_xgem;              /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  XGPN_DSFP_portid5_ctl_xgem_t             portid5_ctl_xgem;              /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  XGPN_DSFP_portid6_ctl_xgem_t             portid6_ctl_xgem;              /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  XGPN_DSFP_portid7_ctl_xgem_t             portid7_ctl_xgem;              /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  XGPN_DSFP_portid8_ctl_xgem_t             portid8_ctl_xgem;              /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  XGPN_DSFP_portid9_ctl_xgem_t             portid9_ctl_xgem;              /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  XGPN_DSFP_portid10_ctl_xgem_t            portid10_ctl_xgem;             /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  XGPN_DSFP_portid11_ctl_xgem_t            portid11_ctl_xgem;             /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  XGPN_DSFP_portid12_ctl_xgem_t            portid12_ctl_xgem;             /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  XGPN_DSFP_portid13_ctl_xgem_t            portid13_ctl_xgem;             /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  XGPN_DSFP_portid14_ctl_xgem_t            portid14_ctl_xgem;             /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  XGPN_DSFP_portid15_ctl_xgem_t            portid15_ctl_xgem;             /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  XGPN_DSFP_portid16_ctl_xgem_t            portid16_ctl_xgem;             /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  XGPN_DSFP_portid17_ctl_xgem_t            portid17_ctl_xgem;             /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  XGPN_DSFP_portid18_ctl_xgem_t            portid18_ctl_xgem;             /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  XGPN_DSFP_portid19_ctl_xgem_t            portid19_ctl_xgem;             /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  XGPN_DSFP_portid20_ctl_xgem_t            portid20_ctl_xgem;             /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  XGPN_DSFP_portid21_ctl_xgem_t            portid21_ctl_xgem;             /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  XGPN_DSFP_portid22_ctl_xgem_t            portid22_ctl_xgem;             /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  XGPN_DSFP_portid23_ctl_xgem_t            portid23_ctl_xgem;             /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  XGPN_DSFP_portid24_ctl_xgem_t            portid24_ctl_xgem;             /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  XGPN_DSFP_portid25_ctl_xgem_t            portid25_ctl_xgem;             /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  XGPN_DSFP_portid26_ctl_xgem_t            portid26_ctl_xgem;             /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  XGPN_DSFP_portid27_ctl_xgem_t            portid27_ctl_xgem;             /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];                   
  XGPN_DSFP_portid28_ctl_xgem_t            portid28_ctl_xgem;             /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];                   
  XGPN_DSFP_portid29_ctl_xgem_t            portid29_ctl_xgem;             /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];                   
  XGPN_DSFP_portid30_ctl_xgem_t            portid30_ctl_xgem;             /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];                   
  XGPN_DSFP_portid31_ctl_xgem_t            portid31_ctl_xgem;             /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];                   
  XGPN_DSFP_portid32_ctl_xgem_t            portid32_ctl_xgem;             /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd44[3];                   
  XGPN_DSFP_portid33_ctl_xgem_t            portid33_ctl_xgem;             /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd45[3];                   
  XGPN_DSFP_portid34_ctl_xgem_t            portid34_ctl_xgem;             /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd46[3];                   
  XGPN_DSFP_portid35_ctl_xgem_t            portid35_ctl_xgem;             /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd47[3];                   
  XGPN_DSFP_portid36_ctl_xgem_t            portid36_ctl_xgem;             /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd48[3];                   
  XGPN_DSFP_portid37_ctl_xgem_t            portid37_ctl_xgem;             /* addr: 0x000000c0 */
  ca_uint32_t                              rsrvd49[3];                   
  XGPN_DSFP_portid38_ctl_xgem_t            portid38_ctl_xgem;             /* addr: 0x000000c4 */
  ca_uint32_t                              rsrvd50[3];                   
  XGPN_DSFP_portid39_ctl_xgem_t            portid39_ctl_xgem;             /* addr: 0x000000c8 */
  ca_uint32_t                              rsrvd51[3];                   
  XGPN_DSFP_portid40_ctl_xgem_t            portid40_ctl_xgem;             /* addr: 0x000000cc */
  ca_uint32_t                              rsrvd52[3];                   
  XGPN_DSFP_portid41_ctl_xgem_t            portid41_ctl_xgem;             /* addr: 0x000000d0 */
  ca_uint32_t                              rsrvd53[3];                   
  XGPN_DSFP_portid42_ctl_xgem_t            portid42_ctl_xgem;             /* addr: 0x000000d4 */
  ca_uint32_t                              rsrvd54[3];                   
  XGPN_DSFP_portid43_ctl_xgem_t            portid43_ctl_xgem;             /* addr: 0x000000d8 */
  ca_uint32_t                              rsrvd55[3];                   
  XGPN_DSFP_portid44_ctl_xgem_t            portid44_ctl_xgem;             /* addr: 0x000000dc */
  ca_uint32_t                              rsrvd56[3];                   
  XGPN_DSFP_portid45_ctl_xgem_t            portid45_ctl_xgem;             /* addr: 0x000000e0 */
  ca_uint32_t                              rsrvd57[3];                   
  XGPN_DSFP_portid46_ctl_xgem_t            portid46_ctl_xgem;             /* addr: 0x000000e4 */
  ca_uint32_t                              rsrvd58[3];                   
  XGPN_DSFP_portid47_ctl_xgem_t            portid47_ctl_xgem;             /* addr: 0x000000e8 */
  ca_uint32_t                              rsrvd59[3];                   
  XGPN_DSFP_portid48_ctl_xgem_t            portid48_ctl_xgem;             /* addr: 0x000000ec */
  ca_uint32_t                              rsrvd60[3];                   
  XGPN_DSFP_portid49_ctl_xgem_t            portid49_ctl_xgem;             /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd61[3];                   
  XGPN_DSFP_portid50_ctl_xgem_t            portid50_ctl_xgem;             /* addr: 0x000000f4 */
  ca_uint32_t                              rsrvd62[3];                   
  XGPN_DSFP_portid51_ctl_xgem_t            portid51_ctl_xgem;             /* addr: 0x000000f8 */
  ca_uint32_t                              rsrvd63[3];                   
  XGPN_DSFP_portid52_ctl_xgem_t            portid52_ctl_xgem;             /* addr: 0x000000fc */
  ca_uint32_t                              rsrvd64[3];                   
  XGPN_DSFP_portid53_ctl_xgem_t            portid53_ctl_xgem;             /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd65[3];                   
  XGPN_DSFP_portid54_ctl_xgem_t            portid54_ctl_xgem;             /* addr: 0x00000104 */
  ca_uint32_t                              rsrvd66[3];                   
  XGPN_DSFP_portid55_ctl_xgem_t            portid55_ctl_xgem;             /* addr: 0x00000108 */
  ca_uint32_t                              rsrvd67[3];                   
  XGPN_DSFP_portid56_ctl_xgem_t            portid56_ctl_xgem;             /* addr: 0x0000010c */
  ca_uint32_t                              rsrvd68[3];                   
  XGPN_DSFP_portid57_ctl_xgem_t            portid57_ctl_xgem;             /* addr: 0x00000110 */
  ca_uint32_t                              rsrvd69[3];                   
  XGPN_DSFP_portid58_ctl_xgem_t            portid58_ctl_xgem;             /* addr: 0x00000114 */
  ca_uint32_t                              rsrvd70[3];                   
  XGPN_DSFP_portid59_ctl_xgem_t            portid59_ctl_xgem;             /* addr: 0x00000118 */
  ca_uint32_t                              rsrvd71[3];                   
  XGPN_DSFP_portid60_ctl_xgem_t            portid60_ctl_xgem;             /* addr: 0x0000011c */
  ca_uint32_t                              rsrvd72[3];                   
  XGPN_DSFP_portid61_ctl_xgem_t            portid61_ctl_xgem;             /* addr: 0x00000120 */
  ca_uint32_t                              rsrvd73[3];                   
  XGPN_DSFP_portid62_ctl_xgem_t            portid62_ctl_xgem;             /* addr: 0x00000124 */
  ca_uint32_t                              rsrvd74[3];                   
  XGPN_DSFP_portid63_ctl_xgem_t            portid63_ctl_xgem;             /* addr: 0x00000128 */
  ca_uint32_t                              rsrvd75[3];                   
  XGPN_DSFP_portid64_ctl_xgem_t            portid64_ctl_xgem;             /* addr: 0x0000012c */
  ca_uint32_t                              rsrvd76[3];                   
  XGPN_DSFP_portid65_ctl_xgem_t            portid65_ctl_xgem;             /* addr: 0x00000130 */
  ca_uint32_t                              rsrvd77[3];                   
  XGPN_DSFP_portid66_ctl_xgem_t            portid66_ctl_xgem;             /* addr: 0x00000134 */
  ca_uint32_t                              rsrvd78[3];                   
  XGPN_DSFP_portid67_ctl_xgem_t            portid67_ctl_xgem;             /* addr: 0x00000138 */
  ca_uint32_t                              rsrvd79[3];                   
  XGPN_DSFP_portid68_ctl_xgem_t            portid68_ctl_xgem;             /* addr: 0x0000013c */
  ca_uint32_t                              rsrvd80[3];                   
  XGPN_DSFP_portid69_ctl_xgem_t            portid69_ctl_xgem;             /* addr: 0x00000140 */
  ca_uint32_t                              rsrvd81[3];                   
  XGPN_DSFP_portid70_ctl_xgem_t            portid70_ctl_xgem;             /* addr: 0x00000144 */
  ca_uint32_t                              rsrvd82[3];                   
  XGPN_DSFP_portid71_ctl_xgem_t            portid71_ctl_xgem;             /* addr: 0x00000148 */
  ca_uint32_t                              rsrvd83[3];                   
  XGPN_DSFP_portid72_ctl_xgem_t            portid72_ctl_xgem;             /* addr: 0x0000014c */
  ca_uint32_t                              rsrvd84[3];                   
  XGPN_DSFP_portid73_ctl_xgem_t            portid73_ctl_xgem;             /* addr: 0x00000150 */
  ca_uint32_t                              rsrvd85[3];                   
  XGPN_DSFP_portid74_ctl_xgem_t            portid74_ctl_xgem;             /* addr: 0x00000154 */
  ca_uint32_t                              rsrvd86[3];                   
  XGPN_DSFP_portid75_ctl_xgem_t            portid75_ctl_xgem;             /* addr: 0x00000158 */
  ca_uint32_t                              rsrvd87[3];                   
  XGPN_DSFP_portid76_ctl_xgem_t            portid76_ctl_xgem;             /* addr: 0x0000015c */
  ca_uint32_t                              rsrvd88[3];                   
  XGPN_DSFP_portid77_ctl_xgem_t            portid77_ctl_xgem;             /* addr: 0x00000160 */
  ca_uint32_t                              rsrvd89[3];                   
  XGPN_DSFP_portid78_ctl_xgem_t            portid78_ctl_xgem;             /* addr: 0x00000164 */
  ca_uint32_t                              rsrvd90[3];                   
  XGPN_DSFP_portid79_ctl_xgem_t            portid79_ctl_xgem;             /* addr: 0x00000168 */
  ca_uint32_t                              rsrvd91[3];                   
  XGPN_DSFP_portid80_ctl_xgem_t            portid80_ctl_xgem;             /* addr: 0x0000016c */
  ca_uint32_t                              rsrvd92[3];                   
  XGPN_DSFP_portid81_ctl_xgem_t            portid81_ctl_xgem;             /* addr: 0x00000170 */
  ca_uint32_t                              rsrvd93[3];                   
  XGPN_DSFP_portid82_ctl_xgem_t            portid82_ctl_xgem;             /* addr: 0x00000174 */
  ca_uint32_t                              rsrvd94[3];                   
  XGPN_DSFP_portid83_ctl_xgem_t            portid83_ctl_xgem;             /* addr: 0x00000178 */
  ca_uint32_t                              rsrvd95[3];                   
  XGPN_DSFP_portid84_ctl_xgem_t            portid84_ctl_xgem;             /* addr: 0x0000017c */
  ca_uint32_t                              rsrvd96[3];                   
  XGPN_DSFP_portid85_ctl_xgem_t            portid85_ctl_xgem;             /* addr: 0x00000180 */
  ca_uint32_t                              rsrvd97[3];                   
  XGPN_DSFP_portid86_ctl_xgem_t            portid86_ctl_xgem;             /* addr: 0x00000184 */
  ca_uint32_t                              rsrvd98[3];                   
  XGPN_DSFP_portid87_ctl_xgem_t            portid87_ctl_xgem;             /* addr: 0x00000188 */
  ca_uint32_t                              rsrvd99[3];                   
  XGPN_DSFP_portid88_ctl_xgem_t            portid88_ctl_xgem;             /* addr: 0x0000018c */
  ca_uint32_t                              rsrvd100[3];                  
  XGPN_DSFP_portid89_ctl_xgem_t            portid89_ctl_xgem;             /* addr: 0x00000190 */
  ca_uint32_t                              rsrvd101[3];                  
  XGPN_DSFP_portid90_ctl_xgem_t            portid90_ctl_xgem;             /* addr: 0x00000194 */
  ca_uint32_t                              rsrvd102[3];                  
  XGPN_DSFP_portid91_ctl_xgem_t            portid91_ctl_xgem;             /* addr: 0x00000198 */
  ca_uint32_t                              rsrvd103[3];                  
  XGPN_DSFP_portid92_ctl_xgem_t            portid92_ctl_xgem;             /* addr: 0x0000019c */
  ca_uint32_t                              rsrvd104[3];                  
  XGPN_DSFP_portid93_ctl_xgem_t            portid93_ctl_xgem;             /* addr: 0x000001a0 */
  ca_uint32_t                              rsrvd105[3];                  
  XGPN_DSFP_portid94_ctl_xgem_t            portid94_ctl_xgem;             /* addr: 0x000001a4 */
  ca_uint32_t                              rsrvd106[3];                  
  XGPN_DSFP_portid95_ctl_xgem_t            portid95_ctl_xgem;             /* addr: 0x000001a8 */
  ca_uint32_t                              rsrvd107[3];                  
  XGPN_DSFP_portid96_ctl_xgem_t            portid96_ctl_xgem;             /* addr: 0x000001ac */
  ca_uint32_t                              rsrvd108[3];                  
  XGPN_DSFP_portid97_ctl_xgem_t            portid97_ctl_xgem;             /* addr: 0x000001b0 */
  ca_uint32_t                              rsrvd109[3];                  
  XGPN_DSFP_portid98_ctl_xgem_t            portid98_ctl_xgem;             /* addr: 0x000001b4 */
  ca_uint32_t                              rsrvd110[3];                  
  XGPN_DSFP_portid99_ctl_xgem_t            portid99_ctl_xgem;             /* addr: 0x000001b8 */
  ca_uint32_t                              rsrvd111[3];                  
  XGPN_DSFP_portid100_ctl_xgem_t           portid100_ctl_xgem;            /* addr: 0x000001bc */
  ca_uint32_t                              rsrvd112[3];                  
  XGPN_DSFP_portid101_ctl_xgem_t           portid101_ctl_xgem;            /* addr: 0x000001c0 */
  ca_uint32_t                              rsrvd113[3];                  
  XGPN_DSFP_portid102_ctl_xgem_t           portid102_ctl_xgem;            /* addr: 0x000001c4 */
  ca_uint32_t                              rsrvd114[3];                  
  XGPN_DSFP_portid103_ctl_xgem_t           portid103_ctl_xgem;            /* addr: 0x000001c8 */
  ca_uint32_t                              rsrvd115[3];                  
  XGPN_DSFP_portid104_ctl_xgem_t           portid104_ctl_xgem;            /* addr: 0x000001cc */
  ca_uint32_t                              rsrvd116[3];                  
  XGPN_DSFP_portid105_ctl_xgem_t           portid105_ctl_xgem;            /* addr: 0x000001d0 */
  ca_uint32_t                              rsrvd117[3];                  
  XGPN_DSFP_portid106_ctl_xgem_t           portid106_ctl_xgem;            /* addr: 0x000001d4 */
  ca_uint32_t                              rsrvd118[3];                  
  XGPN_DSFP_portid107_ctl_xgem_t           portid107_ctl_xgem;            /* addr: 0x000001d8 */
  ca_uint32_t                              rsrvd119[3];                  
  XGPN_DSFP_portid108_ctl_xgem_t           portid108_ctl_xgem;            /* addr: 0x000001dc */
  ca_uint32_t                              rsrvd120[3];                  
  XGPN_DSFP_portid109_ctl_xgem_t           portid109_ctl_xgem;            /* addr: 0x000001e0 */
  ca_uint32_t                              rsrvd121[3];                  
  XGPN_DSFP_portid110_ctl_xgem_t           portid110_ctl_xgem;            /* addr: 0x000001e4 */
  ca_uint32_t                              rsrvd122[3];                  
  XGPN_DSFP_portid111_ctl_xgem_t           portid111_ctl_xgem;            /* addr: 0x000001e8 */
  ca_uint32_t                              rsrvd123[3];                  
  XGPN_DSFP_portid112_ctl_xgem_t           portid112_ctl_xgem;            /* addr: 0x000001ec */
  ca_uint32_t                              rsrvd124[3];                  
  XGPN_DSFP_portid113_ctl_xgem_t           portid113_ctl_xgem;            /* addr: 0x000001f0 */
  ca_uint32_t                              rsrvd125[3];                  
  XGPN_DSFP_portid114_ctl_xgem_t           portid114_ctl_xgem;            /* addr: 0x000001f4 */
  ca_uint32_t                              rsrvd126[3];                  
  XGPN_DSFP_portid115_ctl_xgem_t           portid115_ctl_xgem;            /* addr: 0x000001f8 */
  ca_uint32_t                              rsrvd127[3];                  
  XGPN_DSFP_portid116_ctl_xgem_t           portid116_ctl_xgem;            /* addr: 0x000001fc */
  ca_uint32_t                              rsrvd128[3];                  
  XGPN_DSFP_portid117_ctl_xgem_t           portid117_ctl_xgem;            /* addr: 0x00000200 */
  ca_uint32_t                              rsrvd129[3];                  
  XGPN_DSFP_portid118_ctl_xgem_t           portid118_ctl_xgem;            /* addr: 0x00000204 */
  ca_uint32_t                              rsrvd130[3];                  
  XGPN_DSFP_portid119_ctl_xgem_t           portid119_ctl_xgem;            /* addr: 0x00000208 */
  ca_uint32_t                              rsrvd131[3];                  
  XGPN_DSFP_portid120_ctl_xgem_t           portid120_ctl_xgem;            /* addr: 0x0000020c */
  ca_uint32_t                              rsrvd132[3];                  
  XGPN_DSFP_portid121_ctl_xgem_t           portid121_ctl_xgem;            /* addr: 0x00000210 */
  ca_uint32_t                              rsrvd133[3];                  
  XGPN_DSFP_portid122_ctl_xgem_t           portid122_ctl_xgem;            /* addr: 0x00000214 */
  ca_uint32_t                              rsrvd134[3];                  
  XGPN_DSFP_portid123_ctl_xgem_t           portid123_ctl_xgem;            /* addr: 0x00000218 */
  ca_uint32_t                              rsrvd135[3];                  
  XGPN_DSFP_portid124_ctl_xgem_t           portid124_ctl_xgem;            /* addr: 0x0000021c */
  ca_uint32_t                              rsrvd136[3];                  
  XGPN_DSFP_portid125_ctl_xgem_t           portid125_ctl_xgem;            /* addr: 0x00000220 */
  ca_uint32_t                              rsrvd137[3];                  
  XGPN_DSFP_portid126_ctl_xgem_t           portid126_ctl_xgem;            /* addr: 0x00000224 */
  ca_uint32_t                              rsrvd138[3];                  
  XGPN_DSFP_portid127_ctl_xgem_t           portid127_ctl_xgem;            /* addr: 0x00000228 */
  ca_uint32_t                              rsrvd139[3];                  
  XGPN_DSFP_ds_sync_t                      ds_sync;                       /* addr: 0x0000022c */
  ca_uint32_t                              rsrvd140[3];                  
  XGPN_DSFP_superframe1_t                  superframe1;                   /* addr: 0x00000230 */
  ca_uint32_t                              rsrvd141[3];                  
  XGPN_DSFP_superframe0_t                  superframe0;                   /* addr: 0x00000234 */
  ca_uint32_t                              rsrvd142[3];                  
  XGPN_DSFP_OC_body1_t                     OC_body1;                      /* addr: 0x00000238 */
  ca_uint32_t                              rsrvd143[3];                  
  XGPN_DSFP_OC_body0_t                     OC_body0;                      /* addr: 0x0000023c */
  ca_uint32_t                              rsrvd144[3];                  
  XGPN_DSFP_bip_32_dw1_t                   bip_32_dw1;                    /* addr: 0x00000240 */
  ca_uint32_t                              rsrvd145[3];                  
  XGPN_DSFP_bip_32_dw0_t                   bip_32_dw0;                    /* addr: 0x00000244 */
  ca_uint32_t                              rsrvd146[3];                  
  XGPN_DSFP_bip_32_err_t                   bip_32_err;                    /* addr: 0x00000248 */
  ca_uint32_t                              rsrvd147[3];                  
  XGPN_DSFP_psbd_hec_err_t                 psbd_hec_err;                  /* addr: 0x0000024c */
  ca_uint32_t                              rsrvd148[3];                  
  XGPN_DSFP_sfc_hec_corrected_t            sfc_hec_corrected;             /* addr: 0x00000250 */
  ca_uint32_t                              rsrvd149[3];                  
  XGPN_DSFP_sfc_hec_uncorrected_mib_t      sfc_hec_uncorrected_mib;       /* addr: 0x00000254 */
  ca_uint32_t                              rsrvd150[3];                  
  XGPN_DSFP_ponid_hec_corrected_t          ponid_hec_corrected;           /* addr: 0x00000258 */
  ca_uint32_t                              rsrvd151[3];                  
  XGPN_DSFP_ponid_hec_uncorrected_mib_t    ponid_hec_uncorrected_mib;     /* addr: 0x0000025c */
  ca_uint32_t                              rsrvd152[3];                  
  XGPN_DSFP_psbd_hec_uncorrected_mib_t     psbd_hec_uncorrected_mib;      /* addr: 0x00000260 */
  ca_uint32_t                              rsrvd153[3];                  
  XGPN_DSFP_bwmap_hec_corrected_t          bwmap_hec_corrected;           /* addr: 0x00000264 */
  ca_uint32_t                              rsrvd154[3];                  
  XGPN_DSFP_bwmap_hec_uncorrected_mib_t    bwmap_hec_uncorrected_mib;     /* addr: 0x00000268 */
  ca_uint32_t                              rsrvd155[3];                  
  XGPN_DSFP_xgtc_err_t                     xgtc_err;                      /* addr: 0x0000026c */
  ca_uint32_t                              rsrvd156[3];                  
  XGPN_DSFP_xgtc_frame_t                   xgtc_frame;                    /* addr: 0x00000270 */
  ca_uint32_t                              rsrvd157[3];                  
  XGPN_DSFP_xgtc_hec_corrected_t           xgtc_hec_corrected;            /* addr: 0x00000274 */
  ca_uint32_t                              rsrvd158[3];                  
  XGPN_DSFP_xgtc_hec_uncorrected_mib_t     xgtc_hec_uncorrected_mib;      /* addr: 0x00000278 */
  ca_uint32_t                              rsrvd159[3];                  
  XGPN_DSFP_xgem_err0_t                    xgem_err0;                     /* addr: 0x0000027c */
  ca_uint32_t                              rsrvd160[3];                  
  XGPN_DSFP_xgem_err1_t                    xgem_err1;                     /* addr: 0x00000280 */
  ca_uint32_t                              rsrvd161[3];                  
  XGPN_DSFP_xgem_frame_t                   xgem_frame;                    /* addr: 0x00000284 */
  ca_uint32_t                              rsrvd162[3];                  
  XGPN_DSFP_xgem_hec_corrected_t           xgem_hec_corrected;            /* addr: 0x00000288 */
  ca_uint32_t                              rsrvd163[3];                  
  XGPN_DSFP_xgem_hec_uncorrected_mib_t     xgem_hec_uncorrected_mib;      /* addr: 0x0000028c */
  ca_uint32_t                              rsrvd164[3];                  
  XGPN_DSFP_xgem_nolf_mib_t                xgem_nolf_mib;                 /* addr: 0x00000290 */
  ca_uint32_t                              rsrvd165[3];                  
  XGPN_DSFP_xgem_los_word_mib_t            xgem_los_word_mib;             /* addr: 0x00000294 */
  ca_uint32_t                              rsrvd166[3];                  
  XGPN_DSFP_xgem_err_key_mib_t             xgem_err_key_mib;              /* addr: 0x00000298 */
  ca_uint32_t                              rsrvd167[3];                  
  XGPN_DSFP_rxmac_xgem_frame_t             rxmac_xgem_frame;              /* addr: 0x0000029c */
  ca_uint32_t                              rsrvd168[3];                  
  XGPN_DSFP_rxmac_omci_frame_t             rxmac_omci_frame;              /* addr: 0x000002a0 */
  ca_uint32_t                              rsrvd169[3];                  
  XGPN_DSFP_rxmac_pkt_frame_t              rxmac_pkt_frame;               /* addr: 0x000002a4 */
  ca_uint32_t                              rsrvd170[3];                  
  XGPN_DSFP_rxmac_pkt_crc_err_t            rxmac_pkt_crc_err;             /* addr: 0x000002a8 */
  ca_uint32_t                              rsrvd171[3];                  
  XGPN_DSFP_rxmac_xgem_frame_status_t      rxmac_xgem_frame_status;       /* addr: 0x000002ac */
  ca_uint32_t                              rsrvd172[3];                  
  XGPN_DSFP_async_ff_status_t              async_ff_status;               /* addr: 0x000002b0 */
  ca_uint32_t                              rsrvd173[3];                  
  XGPN_DSFP_MIB_RAM_STATUS_REG_t           MIB_RAM_STATUS_REG;            /* addr: 0x000002b4 */
  ca_uint32_t                              rsrvd174[3];                  
  XGPN_DSFP_PORTID_XGEM_MIB_ACCESS_t       PORTID_XGEM_MIB_ACCESS;        /* addr: 0x000002b8 */
  ca_uint32_t                              rsrvd175[3];                  
  XGPN_DSFP_PORTID_XGEM_MIB_DATA2_t        PORTID_XGEM_MIB_DATA2;         /* addr: 0x000002bc */
  ca_uint32_t                              rsrvd176[3];                  
  XGPN_DSFP_PORTID_XGEM_MIB_DATA1_t        PORTID_XGEM_MIB_DATA1;         /* addr: 0x000002c0 */
  ca_uint32_t                              rsrvd177[3];                  
  XGPN_DSFP_PORTID_XGEM_MIB_DATA0_t        PORTID_XGEM_MIB_DATA0;         /* addr: 0x000002c4 */
} APB1_XGPN_DSFP_t;


/*
 * usbg
 */
        
#define XGPN_USBG_GBL_CTRL                       0xd0034400
#define XGPN_USBG_GBL_CTRL_dft                   0x000000c3

typedef volatile union {
  struct {
    ca_uint32_t xgtc_en              :  1 ; /* bits 0:0 */
    ca_uint32_t scramble_en          :  1 ; /* bits 1:1 */
    ca_uint32_t laser_on             :  1 ; /* bits 2:2 */
    ca_uint32_t laser_polarity       :  1 ; /* bits 3:3 */
    ca_uint32_t swap_tx_bus          :  2 ; /* bits 5:4 */
    ca_uint32_t pf_align_mode        :  1 ; /* bits 6:6 */
    ca_uint32_t aes_encrypt_en       :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd1               : 16 ;
    ca_uint32_t laser_on_align       :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_GBL_CTRL_t;


#define XGPN_USBG_XGTC_CTRL                      0xd0034404
#define XGPN_USBG_XGTC_CTRL_dft                  0x00000017

typedef volatile union {
  struct {
    ca_uint32_t xgem_en              :  1 ; /* bits 0:0 */
    ca_uint32_t dbru_en              :  1 ; /* bits 1:1 */
    ca_uint32_t ploam_en             :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t O7_plmp_off          :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd2               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_XGTC_CTRL_t;


#define XGPN_USBG_GUARD_TM_CFG                   0xd0034408
#define XGPN_USBG_GUARD_TM_CFG_dft               0x00000004

typedef volatile union {
  struct {
    ca_uint32_t time                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_GUARD_TM_CFG_t;


#define XGPN_USBG_IDLE_FM_CFG                    0xd003440c
#define XGPN_USBG_IDLE_FM_CFG_dft                0x80000001

typedef volatile union {
  struct {
    ca_uint32_t size                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t mode                 :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_IDLE_FM_CFG_t;


#define XGPN_USBG_XGTC_HD_IND_CFG                0xd0034410
#define XGPN_USBG_XGTC_HD_IND_CFG_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dg                   :  1 ; /* bits 0:0 */
    ca_uint32_t rsv                  :  7 ; /* bits 7:1 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_XGTC_HD_IND_CFG_t;


#define XGPN_USBG_AES_UNI_KEY_IDX_CTRL           0xd0034414
#define XGPN_USBG_AES_UNI_KEY_IDX_CTRL_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key_idx              :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_AES_UNI_KEY_IDX_CTRL_t;


#define XGPN_USBG_XGEM_PID_TBL_ACCESS            0xd0034418
#define XGPN_USBG_XGEM_PID_TBL_ACCESS_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rw                   :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_XGEM_PID_TBL_ACCESS_t;


#define XGPN_USBG_XGEM_PID_TBL_DATA              0xd003441c
#define XGPN_USBG_XGEM_PID_TBL_DATA_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t XGEM_PortID          : 16 ; /* bits 15:0 */
    ca_uint32_t port_en              :  1 ; /* bits 16:16 */
    ca_uint32_t aes_mode             :  1 ; /* bits 17:17 */
    ca_uint32_t MC_flag              :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_XGEM_PID_TBL_DATA_t;


#define XGPN_USBG_XGEM_BUF_CFG                   0xd0034420
#define XGPN_USBG_XGEM_BUF_CFG_dft               0x03e00040

typedef volatile union {
  struct {
    ca_uint32_t lo_threshold         :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t hi_threshold         : 10 ; /* bits 25:16 */
    ca_uint32_t rsrvd2               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_XGEM_BUF_CFG_t;


#define XGPN_USBG_DBRU_CFG                       0xd0034424
#define XGPN_USBG_DBRU_CFG_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 30 ;
    ca_uint32_t tcon_residue_en      :  1 ; /* bits 30:30 */
    ca_uint32_t mode                 :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_DBRU_CFG_t;


#define XGPN_USBG_PLOAMU_QU_CFG                  0xd0034428
#define XGPN_USBG_PLOAMU_QU_CFG_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t no_empty             :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 30 ;
    ca_uint32_t mode                 :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_PLOAMU_QU_CFG_t;


#define XGPN_USBG_FRAG_FF_DUMP_CFG               0xd003442c
#define XGPN_USBG_FRAG_FF_DUMP_CFG_dft           0x8002ab70

typedef volatile union {
  struct {
    ca_uint32_t dump_time            : 18 ; /* bits 17:0 */
    ca_uint32_t rsrvd1               : 13 ;
    ca_uint32_t dump_en              :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_FRAG_FF_DUMP_CFG_t;


#define XGPN_USBG_XGTC_ERR_DUMP_CFG              0xd0034430
#define XGPN_USBG_XGTC_ERR_DUMP_CFG_dft          0x00000040

typedef volatile union {
  struct {
    ca_uint32_t dly_time             :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_XGTC_ERR_DUMP_CFG_t;


#define XGPN_USBG_DBRU_RPT_MAX_CFG               0xd0034434
#define XGPN_USBG_DBRU_RPT_MAX_CFG_dft           0x001ffffe

typedef volatile union {
  struct {
    ca_uint32_t val                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_DBRU_RPT_MAX_CFG_t;


#define XGPN_USBG_DBRU_BUFOCC_TBL_ACCESS         0xd0034438
#define XGPN_USBG_DBRU_BUFOCC_TBL_ACCESS_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Addr                 :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 11 ;
    ca_uint32_t Select               :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd2               : 13 ;
    ca_uint32_t rw                   :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_DBRU_BUFOCC_TBL_ACCESS_t;


#define XGPN_USBG_DBRU_BUFOCC_TBL_DATA           0xd003443c
#define XGPN_USBG_DBRU_BUFOCC_TBL_DATA_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t BufOcc               : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_DBRU_BUFOCC_TBL_DATA_t;


#define XGPN_USBG_INTERRUPT                      0xd0034440
#define XGPN_USBG_INTERRUPT_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t buf_empty_pop_intI   :  1 ; /* bits 0:0 */
    ca_uint32_t st_chk_err_intI      :  1 ; /* bits 1:1 */
    ca_uint32_t xgem_ff_of_intI      :  1 ; /* bits 2:2 */
    ca_uint32_t xgem_ff_uf_intI      :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t xgem_port_disable_intI :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t xgem_mc_port_intI    :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd3               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_INTERRUPT_t;


#define XGPN_USBG_INTERRUPTE0                    0xd0034444
#define XGPN_USBG_INTERRUPTE0_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t buf_empty_pop_intIE  :  1 ; /* bits 0:0 */
    ca_uint32_t st_chk_err_intIE     :  1 ; /* bits 1:1 */
    ca_uint32_t xgem_ff_of_intIE     :  1 ; /* bits 2:2 */
    ca_uint32_t xgem_ff_uf_intIE     :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t xgem_port_disable_intIE :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t xgem_mc_port_intIE   :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd3               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_INTERRUPTE0_t;


#define XGPN_USBG_INTERRUPTE1                    0xd0034448
#define XGPN_USBG_INTERRUPTE1_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t buf_empty_pop_intIE  :  1 ; /* bits 0:0 */
    ca_uint32_t st_chk_err_intIE     :  1 ; /* bits 1:1 */
    ca_uint32_t xgem_ff_of_intIE     :  1 ; /* bits 2:2 */
    ca_uint32_t xgem_ff_uf_intIE     :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t xgem_port_disable_intIE :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t xgem_mc_port_intIE   :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd3               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_INTERRUPTE1_t;


#define XGPN_USBG_INIT_STS                       0xd003444c
#define XGPN_USBG_INIT_STS_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t init_done            :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_INIT_STS_t;


#define XGPN_USBG_BURST_PF0_INFOR_STS            0xd0034450
#define XGPN_USBG_BURST_PF0_INFOR_STS_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pcnt                 :  8 ; /* bits 7:0 */
    ca_uint32_t plen                 :  4 ; /* bits 11:8 */
    ca_uint32_t dlen                 :  4 ; /* bits 15:12 */
    ca_uint32_t oh_len               : 10 ; /* bits 25:16 */
    ca_uint32_t fecu                 :  1 ; /* bits 26:26 */
    ca_uint32_t ver                  :  4 ; /* bits 30:27 */
    ca_uint32_t vld                  :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF0_INFOR_STS_t;


#define XGPN_USBG_BURST_PF0_DP_H32_STS           0xd0034454
#define XGPN_USBG_BURST_PF0_DP_H32_STS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dp                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF0_DP_H32_STS_t;


#define XGPN_USBG_BURST_PF0_DP_L32_STS           0xd0034458
#define XGPN_USBG_BURST_PF0_DP_L32_STS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dp                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF0_DP_L32_STS_t;


#define XGPN_USBG_BURST_PF0_PP_H32_STS           0xd003445c
#define XGPN_USBG_BURST_PF0_PP_H32_STS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pp                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF0_PP_H32_STS_t;


#define XGPN_USBG_BURST_PF0_PP_L32_STS           0xd0034460
#define XGPN_USBG_BURST_PF0_PP_L32_STS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pp                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF0_PP_L32_STS_t;


#define XGPN_USBG_BURST_PF1_INFOR_STS            0xd0034464
#define XGPN_USBG_BURST_PF1_INFOR_STS_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pcnt                 :  8 ; /* bits 7:0 */
    ca_uint32_t plen                 :  4 ; /* bits 11:8 */
    ca_uint32_t dlen                 :  4 ; /* bits 15:12 */
    ca_uint32_t oh_len               : 10 ; /* bits 25:16 */
    ca_uint32_t fecu                 :  1 ; /* bits 26:26 */
    ca_uint32_t ver                  :  4 ; /* bits 30:27 */
    ca_uint32_t vld                  :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF1_INFOR_STS_t;


#define XGPN_USBG_BURST_PF1_DP_H32_STS           0xd0034468
#define XGPN_USBG_BURST_PF1_DP_H32_STS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dp                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF1_DP_H32_STS_t;


#define XGPN_USBG_BURST_PF1_DP_L32_STS           0xd003446c
#define XGPN_USBG_BURST_PF1_DP_L32_STS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dp                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF1_DP_L32_STS_t;


#define XGPN_USBG_BURST_PF1_PP_H32_STS           0xd0034470
#define XGPN_USBG_BURST_PF1_PP_H32_STS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pp                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF1_PP_H32_STS_t;


#define XGPN_USBG_BURST_PF1_PP_L32_STS           0xd0034474
#define XGPN_USBG_BURST_PF1_PP_L32_STS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pp                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF1_PP_L32_STS_t;


#define XGPN_USBG_BURST_PF2_INFOR_STS            0xd0034478
#define XGPN_USBG_BURST_PF2_INFOR_STS_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pcnt                 :  8 ; /* bits 7:0 */
    ca_uint32_t plen                 :  4 ; /* bits 11:8 */
    ca_uint32_t dlen                 :  4 ; /* bits 15:12 */
    ca_uint32_t oh_len               : 10 ; /* bits 25:16 */
    ca_uint32_t fecu                 :  1 ; /* bits 26:26 */
    ca_uint32_t ver                  :  4 ; /* bits 30:27 */
    ca_uint32_t vld                  :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF2_INFOR_STS_t;


#define XGPN_USBG_BURST_PF2_DP_H32_STS           0xd003447c
#define XGPN_USBG_BURST_PF2_DP_H32_STS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dp                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF2_DP_H32_STS_t;


#define XGPN_USBG_BURST_PF2_DP_L32_STS           0xd0034480
#define XGPN_USBG_BURST_PF2_DP_L32_STS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dp                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF2_DP_L32_STS_t;


#define XGPN_USBG_BURST_PF2_PP_H32_STS           0xd0034484
#define XGPN_USBG_BURST_PF2_PP_H32_STS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pp                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF2_PP_H32_STS_t;


#define XGPN_USBG_BURST_PF2_PP_L32_STS           0xd0034488
#define XGPN_USBG_BURST_PF2_PP_L32_STS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pp                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF2_PP_L32_STS_t;


#define XGPN_USBG_BURST_PF3_INFOR_STS            0xd003448c
#define XGPN_USBG_BURST_PF3_INFOR_STS_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pcnt                 :  8 ; /* bits 7:0 */
    ca_uint32_t plen                 :  4 ; /* bits 11:8 */
    ca_uint32_t dlen                 :  4 ; /* bits 15:12 */
    ca_uint32_t oh_len               : 10 ; /* bits 25:16 */
    ca_uint32_t fecu                 :  1 ; /* bits 26:26 */
    ca_uint32_t ver                  :  4 ; /* bits 30:27 */
    ca_uint32_t vld                  :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF3_INFOR_STS_t;


#define XGPN_USBG_BURST_PF3_DP_H32_STS           0xd0034490
#define XGPN_USBG_BURST_PF3_DP_H32_STS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dp                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF3_DP_H32_STS_t;


#define XGPN_USBG_BURST_PF3_DP_L32_STS           0xd0034494
#define XGPN_USBG_BURST_PF3_DP_L32_STS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dp                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF3_DP_L32_STS_t;


#define XGPN_USBG_BURST_PF3_PP_H32_STS           0xd0034498
#define XGPN_USBG_BURST_PF3_PP_H32_STS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pp                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF3_PP_H32_STS_t;


#define XGPN_USBG_BURST_PF3_PP_L32_STS           0xd003449c
#define XGPN_USBG_BURST_PF3_PP_L32_STS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pp                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF3_PP_L32_STS_t;


#define XGPN_USBG_BP_VER_OL_STS                  0xd00344a0
#define XGPN_USBG_BP_VER_OL_STS_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ind0                 :  1 ; /* bits 0:0 */
    ca_uint32_t ind1                 :  1 ; /* bits 1:1 */
    ca_uint32_t ind2                 :  1 ; /* bits 2:2 */
    ca_uint32_t ind3                 :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BP_VER_OL_STS_t;


#define XGPN_USBG_MIB_RAM_STATUS_REG             0xd00344a4
#define XGPN_USBG_MIB_RAM_STATUS_REG_dft         0x00000001

typedef volatile union {
  struct {
    ca_uint32_t ram_initdone         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_MIB_RAM_STATUS_REG_t;


#define XGPN_USBG_MIB_CTL                        0xd00344a8
#define XGPN_USBG_MIB_CTL_dft                    0x00000001

typedef volatile union {
  struct {
    ca_uint32_t ram_clr_en           :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_MIB_CTL_t;


#define XGPN_USBG_PORTID_XGEM_MIB_ACCESS         0xd00344ac
#define XGPN_USBG_PORTID_XGEM_MIB_ACCESS_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rw                   :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_PORTID_XGEM_MIB_ACCESS_t;


#define XGPN_USBG_PORTID_XGEM_MIB_DATA2          0xd00344b0
#define XGPN_USBG_PORTID_XGEM_MIB_DATA2_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t byte_cnt             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_PORTID_XGEM_MIB_DATA2_t;


#define XGPN_USBG_PORTID_XGEM_MIB_DATA1          0xd00344b4
#define XGPN_USBG_PORTID_XGEM_MIB_DATA1_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t byte_cnt             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_PORTID_XGEM_MIB_DATA1_t;


#define XGPN_USBG_PORTID_XGEM_MIB_DATA0          0xd00344b8
#define XGPN_USBG_PORTID_XGEM_MIB_DATA0_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t frame_cnt            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_PORTID_XGEM_MIB_DATA0_t;


#define XGPN_USBG_XGEM_LF0                       0xd00344bc
#define XGPN_USBG_XGEM_LF0_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_XGEM_LF0_t;


#define XGPN_USBG_XGTC_FM_CNT                    0xd00344c0
#define XGPN_USBG_XGTC_FM_CNT_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_XGTC_FM_CNT_t;


#define XGPN_USBG_XGTC_FEC_BLK_CNT               0xd00344c4
#define XGPN_USBG_XGTC_FEC_BLK_CNT_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t blk                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_XGTC_FEC_BLK_CNT_t;


#define XGPN_USBG_PLM_FM_CNT                     0xd00344c8
#define XGPN_USBG_PLM_FM_CNT_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_PLM_FM_CNT_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* usbg */
typedef struct {
  XGPN_USBG_GBL_CTRL_t                     GBL_CTRL;                      /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  XGPN_USBG_XGTC_CTRL_t                    XGTC_CTRL;                     /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  XGPN_USBG_GUARD_TM_CFG_t                 GUARD_TM_CFG;                  /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  XGPN_USBG_IDLE_FM_CFG_t                  IDLE_FM_CFG;                   /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  XGPN_USBG_XGTC_HD_IND_CFG_t              XGTC_HD_IND_CFG;               /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  XGPN_USBG_AES_UNI_KEY_IDX_CTRL_t         AES_UNI_KEY_IDX_CTRL;          /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  XGPN_USBG_XGEM_PID_TBL_ACCESS_t          XGEM_PID_TBL_ACCESS;           /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  XGPN_USBG_XGEM_PID_TBL_DATA_t            XGEM_PID_TBL_DATA;             /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  XGPN_USBG_XGEM_BUF_CFG_t                 XGEM_BUF_CFG;                  /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  XGPN_USBG_DBRU_CFG_t                     DBRU_CFG;                      /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  XGPN_USBG_PLOAMU_QU_CFG_t                PLOAMU_QU_CFG;                 /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  XGPN_USBG_FRAG_FF_DUMP_CFG_t             FRAG_FF_DUMP_CFG;              /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  XGPN_USBG_XGTC_ERR_DUMP_CFG_t            XGTC_ERR_DUMP_CFG;             /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  XGPN_USBG_DBRU_RPT_MAX_CFG_t             DBRU_RPT_MAX_CFG;              /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  XGPN_USBG_DBRU_BUFOCC_TBL_ACCESS_t       DBRU_BUFOCC_TBL_ACCESS;        /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  XGPN_USBG_DBRU_BUFOCC_TBL_DATA_t         DBRU_BUFOCC_TBL_DATA;          /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  XGPN_USBG_INTERRUPT_t                    INTERRUPT;                     /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  XGPN_USBG_INTERRUPTE0_t                  INTERRUPTE0;                   /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  XGPN_USBG_INTERRUPTE1_t                  INTERRUPTE1;                   /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  XGPN_USBG_INIT_STS_t                     INIT_STS;                      /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  XGPN_USBG_BURST_PF0_INFOR_STS_t          BURST_PF0_INFOR_STS;           /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  XGPN_USBG_BURST_PF0_DP_H32_STS_t         BURST_PF0_DP_H32_STS;          /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  XGPN_USBG_BURST_PF0_DP_L32_STS_t         BURST_PF0_DP_L32_STS;          /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  XGPN_USBG_BURST_PF0_PP_H32_STS_t         BURST_PF0_PP_H32_STS;          /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  XGPN_USBG_BURST_PF0_PP_L32_STS_t         BURST_PF0_PP_L32_STS;          /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  XGPN_USBG_BURST_PF1_INFOR_STS_t          BURST_PF1_INFOR_STS;           /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  XGPN_USBG_BURST_PF1_DP_H32_STS_t         BURST_PF1_DP_H32_STS;          /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  XGPN_USBG_BURST_PF1_DP_L32_STS_t         BURST_PF1_DP_L32_STS;          /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  XGPN_USBG_BURST_PF1_PP_H32_STS_t         BURST_PF1_PP_H32_STS;          /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  XGPN_USBG_BURST_PF1_PP_L32_STS_t         BURST_PF1_PP_L32_STS;          /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  XGPN_USBG_BURST_PF2_INFOR_STS_t          BURST_PF2_INFOR_STS;           /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  XGPN_USBG_BURST_PF2_DP_H32_STS_t         BURST_PF2_DP_H32_STS;          /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  XGPN_USBG_BURST_PF2_DP_L32_STS_t         BURST_PF2_DP_L32_STS;          /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  XGPN_USBG_BURST_PF2_PP_H32_STS_t         BURST_PF2_PP_H32_STS;          /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  XGPN_USBG_BURST_PF2_PP_L32_STS_t         BURST_PF2_PP_L32_STS;          /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  XGPN_USBG_BURST_PF3_INFOR_STS_t          BURST_PF3_INFOR_STS;           /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  XGPN_USBG_BURST_PF3_DP_H32_STS_t         BURST_PF3_DP_H32_STS;          /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  XGPN_USBG_BURST_PF3_DP_L32_STS_t         BURST_PF3_DP_L32_STS;          /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  XGPN_USBG_BURST_PF3_PP_H32_STS_t         BURST_PF3_PP_H32_STS;          /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];                   
  XGPN_USBG_BURST_PF3_PP_L32_STS_t         BURST_PF3_PP_L32_STS;          /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];                   
  XGPN_USBG_BP_VER_OL_STS_t                BP_VER_OL_STS;                 /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];                   
  XGPN_USBG_MIB_RAM_STATUS_REG_t           MIB_RAM_STATUS_REG;            /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];                   
  XGPN_USBG_MIB_CTL_t                      MIB_CTL;                       /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];                   
  XGPN_USBG_PORTID_XGEM_MIB_ACCESS_t       PORTID_XGEM_MIB_ACCESS;        /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd44[3];                   
  XGPN_USBG_PORTID_XGEM_MIB_DATA2_t        PORTID_XGEM_MIB_DATA2;         /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd45[3];                   
  XGPN_USBG_PORTID_XGEM_MIB_DATA1_t        PORTID_XGEM_MIB_DATA1;         /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd46[3];                   
  XGPN_USBG_PORTID_XGEM_MIB_DATA0_t        PORTID_XGEM_MIB_DATA0;         /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd47[3];                   
  XGPN_USBG_XGEM_LF0_t                     XGEM_LF0;                      /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd48[3];                   
  XGPN_USBG_XGTC_FM_CNT_t                  XGTC_FM_CNT;                   /* addr: 0x000000c0 */
  ca_uint32_t                              rsrvd49[3];                   
  XGPN_USBG_XGTC_FEC_BLK_CNT_t             XGTC_FEC_BLK_CNT;              /* addr: 0x000000c4 */
  ca_uint32_t                              rsrvd50[3];                   
  XGPN_USBG_PLM_FM_CNT_t                   PLM_FM_CNT;                    /* addr: 0x000000c8 */
} APB1_XGPN_USBG_t;


/*
 * bwmp
 */
        
#define XGPN_BWMP_GBL_CTRL                       0xd0034600
#define XGPN_BWMP_GBL_CTRL_dft                   0x00000619

typedef volatile union {
  struct {
    ca_uint32_t rx_fltr_en           :  1 ; /* bits 0:0 */
    ca_uint32_t grant_src_mode       :  1 ; /* bits 1:1 */
    ca_uint32_t st_out_chk_en        :  1 ; /* bits 2:2 */
    ca_uint32_t pre_st_out_chk_en    :  1 ; /* bits 3:3 */
    ca_uint32_t grt_always_drop_num  :  3 ; /* bits 6:4 */
    ca_uint32_t grt_always_drop_en   :  1 ; /* bits 7:7 */
    ca_uint32_t scope_remove         :  1 ; /* bits 8:8 */
    ca_uint32_t max_burst_per_bwmap  :  4 ; /* bits 12:9 */
    ca_uint32_t bst_end_ov_drop_en   :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_GBL_CTRL_t;


#define XGPN_BWMP_RSP_TM_CFG                     0xd0034604
#define XGPN_BWMP_RSP_TM_CFG_dft                 0x00001543

typedef volatile union {
  struct {
    ca_uint32_t time                 : 13 ; /* bits 12:0 */
    ca_uint32_t rsrvd1               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_RSP_TM_CFG_t;


#define XGPN_BWMP_BST_MG_CFG                     0xd0034608
#define XGPN_BWMP_BST_MG_CFG_dft                 0x00000100

typedef volatile union {
  struct {
    ca_uint32_t time                 :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_BST_MG_CFG_t;


#define XGPN_BWMP_SEQ_TM_CTRL                    0xd003460c
#define XGPN_BWMP_SEQ_TM_CTRL_dft                0x000001ff

typedef volatile union {
  struct {
    ca_uint32_t map_lead_tm          : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_SEQ_TM_CTRL_t;


#define XGPN_BWMP_GRT_MSG_CTL                    0xd0034610
#define XGPN_BWMP_GRT_MSG_CTL_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 31 ;
    ca_uint32_t access_wr            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_GRT_MSG_CTL_t;


#define XGPN_BWMP_GRT_MSG_DATA0                  0xd0034614
#define XGPN_BWMP_GRT_MSG_DATA0_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t infor                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_GRT_MSG_DATA0_t;


#define XGPN_BWMP_GRT_MSG_DATA1                  0xd0034618
#define XGPN_BWMP_GRT_MSG_DATA1_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t infor                : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_GRT_MSG_DATA1_t;


#define XGPN_BWMP_GRT_FF_CTL                     0xd003461c
#define XGPN_BWMP_GRT_FF_CTL_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 21 ;
    ca_uint32_t grant_ff_sel         :  2 ; /* bits 30:29 */
    ca_uint32_t access_rd            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_GRT_FF_CTL_t;


#define XGPN_BWMP_GRT_FF_DATA0                   0xd0034620
#define XGPN_BWMP_GRT_FF_DATA0_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t grant_size           : 16 ; /* bits 15:0 */
    ca_uint32_t st_tm                : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_GRT_FF_DATA0_t;


#define XGPN_BWMP_GRT_FF_DATA1                   0xd0034624
#define XGPN_BWMP_GRT_FF_DATA1_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bp_ind               :  2 ; /* bits 1:0 */
    ca_uint32_t fecu                 :  1 ; /* bits 2:2 */
    ca_uint32_t ploamu               :  1 ; /* bits 3:3 */
    ca_uint32_t dbru                 :  1 ; /* bits 4:4 */
    ca_uint32_t tcont_id             :  5 ; /* bits 9:5 */
    ca_uint32_t rsrvd1               :  6 ;
    ca_uint32_t tcont_en             :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd2               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_GRT_FF_DATA1_t;


#define XGPN_BWMP_BM_BUF_CFG                     0xd0034628
#define XGPN_BWMP_BM_BUF_CFG_dft                 0x00000002

typedef volatile union {
  struct {
    ca_uint32_t wr_threshold         :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_BM_BUF_CFG_t;


#define XGPN_BWMP_INTERRUPT                      0xd003462c
#define XGPN_BWMP_INTERRUPT_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bwmap_lmt_intI       :  1 ; /* bits 0:0 */
    ca_uint32_t hec_chk_err_intI     :  1 ; /* bits 1:1 */
    ca_uint32_t allocid_tbl_full_drop_intI :  1 ; /* bits 2:2 */
    ca_uint32_t unk_allco_series_intI :  1 ; /* bits 3:3 */
    ca_uint32_t burst_profile_invld_intI :  1 ; /* bits 4:4 */
    ca_uint32_t bw_grnt_ff_of_intI   :  1 ; /* bits 5:5 */
    ca_uint32_t bw_grnt_ff_uf_intI   :  1 ; /* bits 6:6 */
    ca_uint32_t bm_grnt_ff_of_intI   :  1 ; /* bits 7:7 */
    ca_uint32_t bm_grnt_ff_uf_intI   :  1 ; /* bits 8:8 */
    ca_uint32_t xgtc_grnt_ff_of_intI :  1 ; /* bits 9:9 */
    ca_uint32_t xgtc_grnt_ff_uf_intI :  1 ; /* bits 10:10 */
    ca_uint32_t gs_less4_drop_intI   :  1 ; /* bits 11:11 */
    ca_uint32_t st_chk_err_intI      :  1 ; /* bits 12:12 */
    ca_uint32_t grt_drop_ff_full_intI :  1 ; /* bits 13:13 */
    ca_uint32_t xg_ov_clash_err_intI :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t UNK_PF_MIBSat        :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd2               :  9 ;
    ca_uint32_t eqd_reduce_drop_intI :  1 ; /* bits 26:26 */
    ca_uint32_t alloc_id_remove_intI :  1 ; /* bits 27:27 */
    ca_uint32_t alloc_id_add_intI    :  1 ; /* bits 28:28 */
    ca_uint32_t pre_sn_grant_intI    :  1 ; /* bits 29:29 */
    ca_uint32_t pre_rang_grant_intI  :  1 ; /* bits 30:30 */
    ca_uint32_t fwi_intI             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_INTERRUPT_t;


#define XGPN_BWMP_INTERRUPTE0                    0xd0034630
#define XGPN_BWMP_INTERRUPTE0_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bwmap_lmt_intIE      :  1 ; /* bits 0:0 */
    ca_uint32_t hec_chk_err_intIE    :  1 ; /* bits 1:1 */
    ca_uint32_t allocid_tbl_full_drop_intIE :  1 ; /* bits 2:2 */
    ca_uint32_t unk_allco_series_intIE :  1 ; /* bits 3:3 */
    ca_uint32_t burst_profile_invld_intIE :  1 ; /* bits 4:4 */
    ca_uint32_t bw_grnt_ff_of_intIE  :  1 ; /* bits 5:5 */
    ca_uint32_t bw_grnt_ff_uf_intIE  :  1 ; /* bits 6:6 */
    ca_uint32_t bm_grnt_ff_of_intIE  :  1 ; /* bits 7:7 */
    ca_uint32_t bm_grnt_ff_uf_intIE  :  1 ; /* bits 8:8 */
    ca_uint32_t xgtc_grnt_ff_of_intIE :  1 ; /* bits 9:9 */
    ca_uint32_t xgtc_grnt_ff_uf_intIE :  1 ; /* bits 10:10 */
    ca_uint32_t gs_less4_drop_intIE  :  1 ; /* bits 11:11 */
    ca_uint32_t st_chk_err_intIE     :  1 ; /* bits 12:12 */
    ca_uint32_t grt_drop_ff_full_intIE :  1 ; /* bits 13:13 */
    ca_uint32_t xg_ov_clash_err_intIE :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t UNK_PF_MIBSatE       :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd2               :  9 ;
    ca_uint32_t eqd_reduce_drop_intIE :  1 ; /* bits 26:26 */
    ca_uint32_t alloc_id_remove_intIE :  1 ; /* bits 27:27 */
    ca_uint32_t alloc_id_add_intIE   :  1 ; /* bits 28:28 */
    ca_uint32_t pre_sn_grant_intIE   :  1 ; /* bits 29:29 */
    ca_uint32_t pre_rang_grant_intIE :  1 ; /* bits 30:30 */
    ca_uint32_t fwi_intIE            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_INTERRUPTE0_t;


#define XGPN_BWMP_INTERRUPTE1                    0xd0034634
#define XGPN_BWMP_INTERRUPTE1_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bwmap_lmt_intIE      :  1 ; /* bits 0:0 */
    ca_uint32_t hec_chk_err_intIE    :  1 ; /* bits 1:1 */
    ca_uint32_t allocid_tbl_full_drop_intIE :  1 ; /* bits 2:2 */
    ca_uint32_t unk_allco_series_intIE :  1 ; /* bits 3:3 */
    ca_uint32_t burst_profile_invld_intIE :  1 ; /* bits 4:4 */
    ca_uint32_t bw_grnt_ff_of_intIE  :  1 ; /* bits 5:5 */
    ca_uint32_t bw_grnt_ff_uf_intIE  :  1 ; /* bits 6:6 */
    ca_uint32_t bm_grnt_ff_of_intIE  :  1 ; /* bits 7:7 */
    ca_uint32_t bm_grnt_ff_uf_intIE  :  1 ; /* bits 8:8 */
    ca_uint32_t xgtc_grnt_ff_of_intIE :  1 ; /* bits 9:9 */
    ca_uint32_t xgtc_grnt_ff_uf_intIE :  1 ; /* bits 10:10 */
    ca_uint32_t gs_less4_drop_intIE  :  1 ; /* bits 11:11 */
    ca_uint32_t st_chk_err_intIE     :  1 ; /* bits 12:12 */
    ca_uint32_t grt_drop_ff_full_intIE :  1 ; /* bits 13:13 */
    ca_uint32_t xg_ov_clash_err_intIE :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t UNK_PF_MIBSatE       :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd2               :  9 ;
    ca_uint32_t eqd_reduce_drop_intIE :  1 ; /* bits 26:26 */
    ca_uint32_t alloc_id_remove_intIE :  1 ; /* bits 27:27 */
    ca_uint32_t alloc_id_add_intIE   :  1 ; /* bits 28:28 */
    ca_uint32_t pre_sn_grant_intIE   :  1 ; /* bits 29:29 */
    ca_uint32_t pre_rang_grant_intIE :  1 ; /* bits 30:30 */
    ca_uint32_t fwi_intIE            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_INTERRUPTE1_t;


#define XGPN_BWMP_ALLOC_LUT_ACCESS               0xd0034638
#define XGPN_BWMP_ALLOC_LUT_ACCESS_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tcontID              :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t uwlchID              :  4 ; /* bits 11:8 */
    ca_uint32_t rsrvd2               :  4 ;
    ca_uint32_t array                :  5 ; /* bits 20:16 */
    ca_uint32_t rsrvd3               :  9 ;
    ca_uint32_t rnw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_ALLOC_LUT_ACCESS_t;


#define XGPN_BWMP_ALLOC_LUT_DATA                 0xd003463c
#define XGPN_BWMP_ALLOC_LUT_DATA_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t allocation_ID        : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 10 ;
    ca_uint32_t omci_en              :  1 ; /* bits 24:24 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t ploam_en             :  1 ; /* bits 28:28 */
    ca_uint32_t rsrvd3               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_ALLOC_LUT_DATA_t;


#define XGPN_BWMP_ALLOC_LUT_DEBUG                0xd0034640
#define XGPN_BWMP_ALLOC_LUT_DEBUG_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t allocID              : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t tcontID              :  5 ; /* bits 20:16 */
    ca_uint32_t rsrvd2               : 11 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_ALLOC_LUT_DEBUG_t;


#define XGPN_BWMP_EQD_STS                        0xd0034644
#define XGPN_BWMP_EQD_STS_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_EQD_STS_t;


#define XGPN_BWMP_RANDOM_DLY_STS                 0xd0034648
#define XGPN_BWMP_RANDOM_DLY_STS_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_RANDOM_DLY_STS_t;


#define XGPN_BWMP_LMT_DROP_SRC_STS               0xd003464c
#define XGPN_BWMP_LMT_DROP_SRC_STS_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t total_alloc_num_os   :  1 ; /* bits 0:0 */
    ca_uint32_t per_bst_alloc_num_os :  1 ; /* bits 1:1 */
    ca_uint32_t bst_series_num_os    :  1 ; /* bits 2:2 */
    ca_uint32_t bst_sz_sum_os        :  1 ; /* bits 3:3 */
    ca_uint32_t alloc_sz_chk_vld_os  :  1 ; /* bits 4:4 */
    ca_uint32_t st_chk_fail          :  1 ; /* bits 5:5 */
    ca_uint32_t bst_end_time_os      :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_LMT_DROP_SRC_STS_t;


#define XGPN_BWMP_BWMAP_GRT_FF_STS               0xd0034650
#define XGPN_BWMP_BWMAP_GRT_FF_STS_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wr_ptr               :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t wr_sel               :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd2               :  5 ;
    ca_uint32_t rd_ptr               :  5 ; /* bits 20:16 */
    ca_uint32_t rsrvd3               :  3 ;
    ca_uint32_t rd_sel               :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd4               :  5 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_BWMAP_GRT_FF_STS_t;


#define XGPN_BWMP_XGTC_GRT_FF_STS                0xd0034654
#define XGPN_BWMP_XGTC_GRT_FF_STS_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wr_ptr               :  5 ; /* bits 4:0 */
    ca_uint32_t wr_sel               :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t rd_ptr               :  5 ; /* bits 12:8 */
    ca_uint32_t rd_sel               :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd2               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_XGTC_GRT_FF_STS_t;


#define XGPN_BWMP_BM_GRT_FF_STS                  0xd0034658
#define XGPN_BWMP_BM_GRT_FF_STS_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wr_ptr               :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t rd_ptr               :  7 ; /* bits 14:8 */
    ca_uint32_t rsrvd2               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_BM_GRT_FF_STS_t;


#define XGPN_BWMP_UNK_PF_MIB                     0xd003465c
#define XGPN_BWMP_UNK_PF_MIB_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cntr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_UNK_PF_MIB_t;


#define XGPN_BWMP_AS_CNT                         0xd0034660
#define XGPN_BWMP_AS_CNT_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t entry                : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_AS_CNT_t;


#define XGPN_BWMP_AS_HEC_ERR_CNT                 0xd0034664
#define XGPN_BWMP_AS_HEC_ERR_CNT_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t entry                : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_AS_HEC_ERR_CNT_t;


#define XGPN_BWMP_BWMAP_CNT_CTRL                 0xd0034668
#define XGPN_BWMP_BWMAP_CNT_CTRL_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t latch                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_BWMAP_CNT_CTRL_t;


#define XGPN_BWMP_DS_FM_SYNC_CNT                 0xd003466c
#define XGPN_BWMP_DS_FM_SYNC_CNT_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 17 ; /* bits 16:0 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_DS_FM_SYNC_CNT_t;


#define XGPN_BWMP_US_MAP_CNT                     0xd0034670
#define XGPN_BWMP_US_MAP_CNT_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 17 ; /* bits 16:0 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_US_MAP_CNT_t;


#define XGPN_BWMP_US_XGEM_CNT                    0xd0034674
#define XGPN_BWMP_US_XGEM_CNT_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 17 ; /* bits 16:0 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_US_XGEM_CNT_t;


#define XGPN_BWMP_US_XGTC_CNT                    0xd0034678
#define XGPN_BWMP_US_XGTC_CNT_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 17 ; /* bits 16:0 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_US_XGTC_CNT_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* bwmp */
typedef struct {
  XGPN_BWMP_GBL_CTRL_t                     GBL_CTRL;                      /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  XGPN_BWMP_RSP_TM_CFG_t                   RSP_TM_CFG;                    /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  XGPN_BWMP_BST_MG_CFG_t                   BST_MG_CFG;                    /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  XGPN_BWMP_SEQ_TM_CTRL_t                  SEQ_TM_CTRL;                   /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  XGPN_BWMP_GRT_MSG_CTL_t                  GRT_MSG_CTL;                   /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  XGPN_BWMP_GRT_MSG_DATA0_t                GRT_MSG_DATA0;                 /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  XGPN_BWMP_GRT_MSG_DATA1_t                GRT_MSG_DATA1;                 /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  XGPN_BWMP_GRT_FF_CTL_t                   GRT_FF_CTL;                    /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  XGPN_BWMP_GRT_FF_DATA0_t                 GRT_FF_DATA0;                  /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  XGPN_BWMP_GRT_FF_DATA1_t                 GRT_FF_DATA1;                  /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  XGPN_BWMP_BM_BUF_CFG_t                   BM_BUF_CFG;                    /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  XGPN_BWMP_INTERRUPT_t                    INTERRUPT;                     /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  XGPN_BWMP_INTERRUPTE0_t                  INTERRUPTE0;                   /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  XGPN_BWMP_INTERRUPTE1_t                  INTERRUPTE1;                   /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  XGPN_BWMP_ALLOC_LUT_ACCESS_t             ALLOC_LUT_ACCESS;              /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  XGPN_BWMP_ALLOC_LUT_DATA_t               ALLOC_LUT_DATA;                /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  XGPN_BWMP_ALLOC_LUT_DEBUG_t              ALLOC_LUT_DEBUG;               /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  XGPN_BWMP_EQD_STS_t                      EQD_STS;                       /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  XGPN_BWMP_RANDOM_DLY_STS_t               RANDOM_DLY_STS;                /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  XGPN_BWMP_LMT_DROP_SRC_STS_t             LMT_DROP_SRC_STS;              /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  XGPN_BWMP_BWMAP_GRT_FF_STS_t             BWMAP_GRT_FF_STS;              /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  XGPN_BWMP_XGTC_GRT_FF_STS_t              XGTC_GRT_FF_STS;               /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  XGPN_BWMP_BM_GRT_FF_STS_t                BM_GRT_FF_STS;                 /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  XGPN_BWMP_UNK_PF_MIB_t                   UNK_PF_MIB;                    /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  XGPN_BWMP_AS_CNT_t                       AS_CNT;                        /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  XGPN_BWMP_AS_HEC_ERR_CNT_t               AS_HEC_ERR_CNT;                /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  XGPN_BWMP_BWMAP_CNT_CTRL_t               BWMAP_CNT_CTRL;                /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  XGPN_BWMP_DS_FM_SYNC_CNT_t               DS_FM_SYNC_CNT;                /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  XGPN_BWMP_US_MAP_CNT_t                   US_MAP_CNT;                    /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  XGPN_BWMP_US_XGEM_CNT_t                  US_XGEM_CNT;                   /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  XGPN_BWMP_US_XGTC_CNT_t                  US_XGTC_CNT;                   /* addr: 0x00000078 */
} APB1_XGPN_BWMP_t;


/*
 * plmp
 */
        
#define XGPN_PLMP_CTRL                           0xd0034800
#define XGPN_PLMP_CTRL_dft                       0x0000007a

typedef volatile union {
  struct {
    ca_uint32_t sw_mode_en           :  1 ; /* bits 0:0 */
    ca_uint32_t dereg_rst_en         :  1 ; /* bits 1:1 */
    ca_uint32_t resrv_bc_en          :  1 ; /* bits 2:2 */
    ca_uint32_t resrv_id_sel         :  2 ; /* bits 4:3 */
    ca_uint32_t tuning_rst_en        :  1 ; /* bits 5:5 */
    ca_uint32_t tuning_mic_rst_en    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_CTRL_t;


#define XGPN_PLMP_DS_CTRL                        0xd0034804
#define XGPN_PLMP_DS_CTRL_dft                    0x06000000

typedef volatile union {
  struct {
    ca_uint32_t mic_chk_dis          :  1 ; /* bits 0:0 */
    ca_uint32_t seq_chk_dis          :  1 ; /* bits 1:1 */
    ca_uint32_t onuid_flt_dis        :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t capt_msg_en          :  1 ; /* bits 4:4 */
    ca_uint32_t capt_msg_type        :  8 ; /* bits 12:5 */
    ca_uint32_t capt_onu_id          : 10 ; /* bits 22:13 */
    ca_uint32_t extension_en         :  1 ; /* bits 23:23 */
    ca_uint32_t unkwn_msg_type_en    :  1 ; /* bits 24:24 */
    ca_uint32_t dozing_filter_en     :  1 ; /* bits 25:25 */
    ca_uint32_t o7_filter_en         :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t pktgen_rdy_chk_en    :  1 ; /* bits 29:29 */
    ca_uint32_t extension_msg_type_en :  1 ; /* bits 30:30 */
    ca_uint32_t capt_msg_bpressure_en :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_DS_CTRL_t;


#define XGPN_PLMP_RX_CAPTURE                     0xd0034808
#define XGPN_PLMP_RX_CAPTURE_dft                 0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t msg_en               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_RX_CAPTURE_t;


#define XGPN_PLMP_US_CTRL                        0xd003480c
#define XGPN_PLMP_US_CTRL_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mic_gen_dis          :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_US_CTRL_t;


#define XGPN_PLMP_VENDOR_ID_CFG                  0xd0034810
#define XGPN_PLMP_VENDOR_ID_CFG_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_VENDOR_ID_CFG_t;


#define XGPN_PLMP_VSSN_CFG                       0xd0034814
#define XGPN_PLMP_VSSN_CFG_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_VSSN_CFG_t;


#define XGPN_PLMP_CORRELATION                    0xd0034818
#define XGPN_PLMP_CORRELATION_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tag                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_CORRELATION_t;


#define XGPN_PLMP_US_PON_ID                      0xd003481c
#define XGPN_PLMP_US_PON_ID_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_US_PON_ID_t;


#define XGPN_PLMP_CALIBRATION_EVEN               0xd0034820
#define XGPN_PLMP_CALIBRATION_EVEN_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t record               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_CALIBRATION_EVEN_t;


#define XGPN_PLMP_CALIBRATION_ODD                0xd0034824
#define XGPN_PLMP_CALIBRATION_ODD_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t record               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_CALIBRATION_ODD_t;


#define XGPN_PLMP_TUNING_PARAMETER               0xd0034828
#define XGPN_PLMP_TUNING_PARAMETER_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t granularity          :  8 ; /* bits 7:0 */
    ca_uint32_t time                 :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_TUNING_PARAMETER_t;


#define XGPN_PLMP_ATTENUATION                    0xd003482c
#define XGPN_PLMP_ATTENUATION_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t level                :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t capability           :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd2               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_ATTENUATION_t;


#define XGPN_PLMP_RGST_ID_CFG0                   0xd0034830
#define XGPN_PLMP_RGST_ID_CFG0_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_RGST_ID_CFG0_t;


#define XGPN_PLMP_RGST_ID_CFG1                   0xd0034834
#define XGPN_PLMP_RGST_ID_CFG1_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_RGST_ID_CFG1_t;


#define XGPN_PLMP_RGST_ID_CFG2                   0xd0034838
#define XGPN_PLMP_RGST_ID_CFG2_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_RGST_ID_CFG2_t;


#define XGPN_PLMP_RGST_ID_CFG3                   0xd003483c
#define XGPN_PLMP_RGST_ID_CFG3_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_RGST_ID_CFG3_t;


#define XGPN_PLMP_RGST_ID_CFG4                   0xd0034840
#define XGPN_PLMP_RGST_ID_CFG4_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_RGST_ID_CFG4_t;


#define XGPN_PLMP_RGST_ID_CFG5                   0xd0034844
#define XGPN_PLMP_RGST_ID_CFG5_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_RGST_ID_CFG5_t;


#define XGPN_PLMP_RGST_ID_CFG6                   0xd0034848
#define XGPN_PLMP_RGST_ID_CFG6_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_RGST_ID_CFG6_t;


#define XGPN_PLMP_RGST_ID_CFG7                   0xd003484c
#define XGPN_PLMP_RGST_ID_CFG7_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_RGST_ID_CFG7_t;


#define XGPN_PLMP_RGST_ID_CFG8                   0xd0034850
#define XGPN_PLMP_RGST_ID_CFG8_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_RGST_ID_CFG8_t;


#define XGPN_PLMP_TUNING_CONFIG                  0xd0034854
#define XGPN_PLMP_TUNING_CONFIG_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t request_schedule_sfc : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               :  6 ;
    ca_uint32_t skip_rx              :  1 ; /* bits 22:22 */
    ca_uint32_t rollback_allow       :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd2               :  4 ;
    ca_uint32_t request_lead_sfc     :  3 ; /* bits 30:28 */
    ca_uint32_t rsrvd3               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_TUNING_CONFIG_t;


#define XGPN_PLMP_SW_RESPONSE                    0xd0034858
#define XGPN_PLMP_SW_RESPONSE_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tuning_request       :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t tuning_operation_code :  4 ; /* bits 7:4 */
    ca_uint32_t seqno                :  8 ; /* bits 15:8 */
    ca_uint32_t tuning_response_code : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_SW_RESPONSE_t;


#define XGPN_PLMP_EQD_THRSHLD                    0xd003485c
#define XGPN_PLMP_EQD_THRSHLD_dft                0x00097e00

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_EQD_THRSHLD_t;


#define XGPN_PLMP_ACK_PLOAM_NO_MSG0              0xd0034860
#define XGPN_PLMP_ACK_PLOAM_NO_MSG0_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mic                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_ACK_PLOAM_NO_MSG0_t;


#define XGPN_PLMP_ACK_PLOAM_NO_MSG1              0xd0034864
#define XGPN_PLMP_ACK_PLOAM_NO_MSG1_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mic                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_ACK_PLOAM_NO_MSG1_t;


#define XGPN_PLMP_ACK_PLOAM_BUSY_MSG_CFG         0xd0034868
#define XGPN_PLMP_ACK_PLOAM_BUSY_MSG_CFG_dft     0x00020000

typedef volatile union {
  struct {
    ca_uint32_t seq                  :  8 ; /* bits 7:0 */
    ca_uint32_t start                :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t complt_code          :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd2               :  7 ;
    ca_uint32_t ok                   :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_ACK_PLOAM_BUSY_MSG_CFG_t;


#define XGPN_PLMP_ACK_PLOAM_BUSY_MSG0            0xd003486c
#define XGPN_PLMP_ACK_PLOAM_BUSY_MSG0_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mic                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_ACK_PLOAM_BUSY_MSG0_t;


#define XGPN_PLMP_ACK_PLOAM_BUSY_MSG1            0xd0034870
#define XGPN_PLMP_ACK_PLOAM_BUSY_MSG1_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mic                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_ACK_PLOAM_BUSY_MSG1_t;


#define XGPN_PLMP_PLOAM_CFG                      0xd0034874
#define XGPN_PLMP_PLOAM_CFG_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t done                 :  1 ; /* bits 0:0 */
    ca_uint32_t msg_type             :  8 ; /* bits 8:1 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_PLOAM_CFG_t;


#define XGPN_PLMP_PLOAM_CFG_DATA0                0xd0034878
#define XGPN_PLMP_PLOAM_CFG_DATA0_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_PLOAM_CFG_DATA0_t;


#define XGPN_PLMP_PLOAM_CFG_DATA1                0xd003487c
#define XGPN_PLMP_PLOAM_CFG_DATA1_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_PLOAM_CFG_DATA1_t;


#define XGPN_PLMP_PLOAM_CFG_DATA2                0xd0034880
#define XGPN_PLMP_PLOAM_CFG_DATA2_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_PLOAM_CFG_DATA2_t;


#define XGPN_PLMP_PLOAM_CFG_DATA3                0xd0034884
#define XGPN_PLMP_PLOAM_CFG_DATA3_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_PLOAM_CFG_DATA3_t;


#define XGPN_PLMP_PLOAM_CFG_DATA4                0xd0034888
#define XGPN_PLMP_PLOAM_CFG_DATA4_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_PLOAM_CFG_DATA4_t;


#define XGPN_PLMP_PLOAM_CFG_DATA5                0xd003488c
#define XGPN_PLMP_PLOAM_CFG_DATA5_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_PLOAM_CFG_DATA5_t;


#define XGPN_PLMP_PLOAM_CFG_DATA6                0xd0034890
#define XGPN_PLMP_PLOAM_CFG_DATA6_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_PLOAM_CFG_DATA6_t;


#define XGPN_PLMP_PLOAM_CFG_DATA7                0xd0034894
#define XGPN_PLMP_PLOAM_CFG_DATA7_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_PLOAM_CFG_DATA7_t;


#define XGPN_PLMP_PLOAM_CFG_DATA8                0xd0034898
#define XGPN_PLMP_PLOAM_CFG_DATA8_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_PLOAM_CFG_DATA8_t;


#define XGPN_PLMP_KEY_EXCHG_THRSHD               0xd003489c
#define XGPN_PLMP_KEY_EXCHG_THRSHD_dft           0x032000a0

typedef volatile union {
  struct {
    ca_uint32_t tk5_timeout          :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t tk4_timeout          : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_KEY_EXCHG_THRSHD_t;


#define XGPN_PLMP_INTERRUPT                      0xd00348a0
#define XGPN_PLMP_INTERRUPT_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wrong_onuid_intI     :  1 ; /* bits 0:0 */
    ca_uint32_t bc_seq_mismch_intI   :  1 ; /* bits 1:1 */
    ca_uint32_t uc_seq_mismch_intI   :  1 ; /* bits 2:2 */
    ca_uint32_t mic_chk_fail_intI    :  1 ; /* bits 3:3 */
    ca_uint32_t wrong_ploam_intI     :  1 ; /* bits 4:4 */
    ca_uint32_t key_exchg_tk4_timeout_intI :  1 ; /* bits 5:5 */
    ca_uint32_t key_exchg_tk5_timeout_intI :  1 ; /* bits 6:6 */
    ca_uint32_t key_ctrl_intI        :  1 ; /* bits 7:7 */
    ca_uint32_t sleep_allow_intI     :  1 ; /* bits 8:8 */
    ca_uint32_t sleep_req_done_intI  :  1 ; /* bits 9:9 */
    ca_uint32_t eqd_err_intI         :  1 ; /* bits 10:10 */
    ca_uint32_t busy_err_intI        :  1 ; /* bits 11:11 */
    ca_uint32_t registration_msg_intI :  1 ; /* bits 12:12 */
    ca_uint32_t burst_prfl_intI      :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t tuning_request       :  1 ; /* bits 16:16 */
    ca_uint32_t protection_ctrl      :  1 ; /* bits 17:17 */
    ca_uint32_t chng_pwr_level       :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t mib_sat              :  1 ; /* bits 20:20 */
    ca_uint32_t rsrvd3               :  7 ;
    ca_uint32_t sw_ploamd_overlap_drop :  1 ; /* bits 28:28 */
    ca_uint32_t sw_ploamd_full_drop  :  1 ; /* bits 29:29 */
    ca_uint32_t rxbuf0_rdy_intI      :  1 ; /* bits 30:30 */
    ca_uint32_t rxbuf1_rdy_intI      :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_INTERRUPT_t;


#define XGPN_PLMP_INTERRUPTE0                    0xd00348a4
#define XGPN_PLMP_INTERRUPTE0_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wrong_onuid_intIE    :  1 ; /* bits 0:0 */
    ca_uint32_t bc_seq_mismch_intIE  :  1 ; /* bits 1:1 */
    ca_uint32_t uc_seq_mismch_intIE  :  1 ; /* bits 2:2 */
    ca_uint32_t mic_chk_fail_intIE   :  1 ; /* bits 3:3 */
    ca_uint32_t wrong_ploam_intIE    :  1 ; /* bits 4:4 */
    ca_uint32_t key_exchg_tk4_timeout_intIE :  1 ; /* bits 5:5 */
    ca_uint32_t key_exchg_tk5_timeout_intIE :  1 ; /* bits 6:6 */
    ca_uint32_t key_ctrl_intIE       :  1 ; /* bits 7:7 */
    ca_uint32_t sleep_allow_intIE    :  1 ; /* bits 8:8 */
    ca_uint32_t sleep_req_done_intIE :  1 ; /* bits 9:9 */
    ca_uint32_t eqd_err_intIE        :  1 ; /* bits 10:10 */
    ca_uint32_t busy_err_intIE       :  1 ; /* bits 11:11 */
    ca_uint32_t registration_msg_intIE :  1 ; /* bits 12:12 */
    ca_uint32_t burst_prfl_intIE     :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t tuning_requestE      :  1 ; /* bits 16:16 */
    ca_uint32_t protection_ctrlE     :  1 ; /* bits 17:17 */
    ca_uint32_t chng_pwr_levelE      :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t mib_satE             :  1 ; /* bits 20:20 */
    ca_uint32_t rsrvd3               :  7 ;
    ca_uint32_t sw_ploamd_overlap_dropE :  1 ; /* bits 28:28 */
    ca_uint32_t sw_ploamd_full_dropE :  1 ; /* bits 29:29 */
    ca_uint32_t rxbuf0_rdy_intIE     :  1 ; /* bits 30:30 */
    ca_uint32_t rxbuf1_rdy_intIE     :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_INTERRUPTE0_t;


#define XGPN_PLMP_INTERRUPTE1                    0xd00348a8
#define XGPN_PLMP_INTERRUPTE1_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wrong_onuid_intIE    :  1 ; /* bits 0:0 */
    ca_uint32_t bc_seq_mismch_intIE  :  1 ; /* bits 1:1 */
    ca_uint32_t uc_seq_mismch_intIE  :  1 ; /* bits 2:2 */
    ca_uint32_t mic_chk_fail_intIE   :  1 ; /* bits 3:3 */
    ca_uint32_t wrong_ploam_intIE    :  1 ; /* bits 4:4 */
    ca_uint32_t key_exchg_tk4_timeout_intIE :  1 ; /* bits 5:5 */
    ca_uint32_t key_exchg_tk5_timeout_intIE :  1 ; /* bits 6:6 */
    ca_uint32_t key_ctrl_intIE       :  1 ; /* bits 7:7 */
    ca_uint32_t sleep_allow_intIE    :  1 ; /* bits 8:8 */
    ca_uint32_t sleep_req_done_intIE :  1 ; /* bits 9:9 */
    ca_uint32_t eqd_err_intIE        :  1 ; /* bits 10:10 */
    ca_uint32_t busy_err_intIE       :  1 ; /* bits 11:11 */
    ca_uint32_t registration_msg_intIE :  1 ; /* bits 12:12 */
    ca_uint32_t burst_prfl_intIE     :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t tuning_requestE      :  1 ; /* bits 16:16 */
    ca_uint32_t protection_ctrlE     :  1 ; /* bits 17:17 */
    ca_uint32_t chng_pwr_levelE      :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t mib_satE             :  1 ; /* bits 20:20 */
    ca_uint32_t rsrvd3               :  7 ;
    ca_uint32_t sw_ploamd_overlap_dropE :  1 ; /* bits 28:28 */
    ca_uint32_t sw_ploamd_full_dropE :  1 ; /* bits 29:29 */
    ca_uint32_t rxbuf0_rdy_intIE     :  1 ; /* bits 30:30 */
    ca_uint32_t rxbuf1_rdy_intIE     :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_INTERRUPTE1_t;


#define XGPN_PLMP_MIB_SAT_INT                    0xd00348ac
#define XGPN_PLMP_MIB_SAT_INT_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t MIC_ERR_mib_sat      :  1 ; /* bits 0:0 */
    ca_uint32_t DS_RX_mib_sat        :  1 ; /* bits 1:1 */
    ca_uint32_t SYSTEM_PRFL_mib_sat  :  1 ; /* bits 2:2 */
    ca_uint32_t CHANNEL_PRFL_mib_sat :  1 ; /* bits 3:3 */
    ca_uint32_t PRFL_mib_sat         :  1 ; /* bits 4:4 */
    ca_uint32_t ASSGN_ONUID_mib_sat  :  1 ; /* bits 5:5 */
    ca_uint32_t RANGING_TIME_mib_sat :  1 ; /* bits 6:6 */
    ca_uint32_t PROTECT_CTRL_mib_sat :  1 ; /* bits 7:7 */
    ca_uint32_t ADJ_TX_WVLN_mib_sat  :  1 ; /* bits 8:8 */
    ca_uint32_t DEACTV_ONU_mib_sat   :  1 ; /* bits 9:9 */
    ca_uint32_t DISABLE_SN_mib_sat   :  1 ; /* bits 10:10 */
    ca_uint32_t REQ_REGST_mib_sat    :  1 ; /* bits 11:11 */
    ca_uint32_t ASSGN_ALLCTID_mib_sat :  1 ; /* bits 12:12 */
    ca_uint32_t KEY_CTRL_mib_sat     :  1 ; /* bits 13:13 */
    ca_uint32_t SLEEP_ALLW_mib_sat   :  1 ; /* bits 14:14 */
    ca_uint32_t TUNING_CTRL_REQ_mib_sat :  1 ; /* bits 15:15 */
    ca_uint32_t TUNING_CTRL_CMPLT_mib_sat :  1 ; /* bits 16:16 */
    ca_uint32_t CALIBRT_REQ_mib_sat  :  1 ; /* bits 17:17 */
    ca_uint32_t US_TX_mib_sat        :  1 ; /* bits 18:18 */
    ca_uint32_t SN_ONU_mib_sat       :  1 ; /* bits 19:19 */
    ca_uint32_t REGST_mib_sat        :  1 ; /* bits 20:20 */
    ca_uint32_t ACK_mib_sat          :  1 ; /* bits 21:21 */
    ca_uint32_t KEY_REPORT_mib_sat   :  1 ; /* bits 22:22 */
    ca_uint32_t SLEEP_REQ_mib_sat    :  1 ; /* bits 23:23 */
    ca_uint32_t TUN_REQ_RSP_mib_sat  :  1 ; /* bits 24:24 */
    ca_uint32_t TUN_CMPLTU_mib_sat   :  1 ; /* bits 25:25 */
    ca_uint32_t PWR_CNSMPT_RPT_mib_sat :  1 ; /* bits 26:26 */
    ca_uint32_t SW_PLOAMD_FULL_DROP_mib_sat :  1 ; /* bits 27:27 */
    ca_uint32_t SW_PLOAMD_OVERLAP_DROP_mib_sat :  1 ; /* bits 28:28 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_MIB_SAT_INT_t;


#define XGPN_PLMP_MIB_SAT_INTE                   0xd00348b0
#define XGPN_PLMP_MIB_SAT_INTE_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t MIC_ERR_mib_satE     :  1 ; /* bits 0:0 */
    ca_uint32_t DS_RX_mib_satE       :  1 ; /* bits 1:1 */
    ca_uint32_t SYSTEM_PRFL_mib_satE :  1 ; /* bits 2:2 */
    ca_uint32_t CHANNEL_PRFL_mib_satE :  1 ; /* bits 3:3 */
    ca_uint32_t PRFL_mib_satE        :  1 ; /* bits 4:4 */
    ca_uint32_t ASSGN_ONUID_mib_satE :  1 ; /* bits 5:5 */
    ca_uint32_t RANGING_TIME_mib_satE :  1 ; /* bits 6:6 */
    ca_uint32_t PROTECT_CTRL_mib_satE :  1 ; /* bits 7:7 */
    ca_uint32_t ADJ_TX_WVLN_mib_satE :  1 ; /* bits 8:8 */
    ca_uint32_t DEACTV_ONU_mib_satE  :  1 ; /* bits 9:9 */
    ca_uint32_t DISABLE_SN_mib_satE  :  1 ; /* bits 10:10 */
    ca_uint32_t REQ_REGST_mib_satE   :  1 ; /* bits 11:11 */
    ca_uint32_t ASSGN_ALLCTID_mib_satE :  1 ; /* bits 12:12 */
    ca_uint32_t KEY_CTRL_mib_satE    :  1 ; /* bits 13:13 */
    ca_uint32_t SLEEP_ALLW_mib_satE  :  1 ; /* bits 14:14 */
    ca_uint32_t TUNING_CTRL_REQ_mib_satE :  1 ; /* bits 15:15 */
    ca_uint32_t TUNING_CTRL_CMPLT_mib_satE :  1 ; /* bits 16:16 */
    ca_uint32_t CALIBRT_REQ_mib_satE :  1 ; /* bits 17:17 */
    ca_uint32_t US_TX_mib_satE       :  1 ; /* bits 18:18 */
    ca_uint32_t SN_ONU_mib_satE      :  1 ; /* bits 19:19 */
    ca_uint32_t REGST_mib_satE       :  1 ; /* bits 20:20 */
    ca_uint32_t ACK_mib_satE         :  1 ; /* bits 21:21 */
    ca_uint32_t KEY_REPORT_mib_satE  :  1 ; /* bits 22:22 */
    ca_uint32_t SLEEP_REQ_mib_satE   :  1 ; /* bits 23:23 */
    ca_uint32_t TUN_REQ_RSP_mib_satE :  1 ; /* bits 24:24 */
    ca_uint32_t TUN_CMPLTU_mib_satE  :  1 ; /* bits 25:25 */
    ca_uint32_t PWR_CNSMPT_RPT_mib_satE :  1 ; /* bits 26:26 */
    ca_uint32_t SW_PLOAMD_FULL_DROP_mib_satE :  1 ; /* bits 27:27 */
    ca_uint32_t SW_PLOAMD_OVERLAP_DROP_mib_satE :  1 ; /* bits 28:28 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_MIB_SAT_INTE_t;


#define XGPN_PLMP_KEY_CTRL_STAT                  0xd00348b4
#define XGPN_PLMP_KEY_CTRL_STAT_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t seq                  :  8 ; /* bits 7:0 */
    ca_uint32_t type                 :  8 ; /* bits 15:8 */
    ca_uint32_t index                :  8 ; /* bits 23:16 */
    ca_uint32_t length               :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_KEY_CTRL_STAT_t;


#define XGPN_PLMP_KEY_REPORT                     0xd00348b8
#define XGPN_PLMP_KEY_REPORT_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t seq                  :  8 ; /* bits 7:0 */
    ca_uint32_t type                 :  8 ; /* bits 15:8 */
    ca_uint32_t index                :  8 ; /* bits 23:16 */
    ca_uint32_t fragment_num         :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t rdy                  :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_KEY_REPORT_t;


#define XGPN_PLMP_KEY_REPORT_FRAG0               0xd00348bc
#define XGPN_PLMP_KEY_REPORT_FRAG0_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_KEY_REPORT_FRAG0_t;


#define XGPN_PLMP_KEY_REPORT_FRAG1               0xd00348c0
#define XGPN_PLMP_KEY_REPORT_FRAG1_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_KEY_REPORT_FRAG1_t;


#define XGPN_PLMP_KEY_REPORT_FRAG2               0xd00348c4
#define XGPN_PLMP_KEY_REPORT_FRAG2_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_KEY_REPORT_FRAG2_t;


#define XGPN_PLMP_KEY_REPORT_FRAG3               0xd00348c8
#define XGPN_PLMP_KEY_REPORT_FRAG3_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_KEY_REPORT_FRAG3_t;


#define XGPN_PLMP_SLEEP_ALLOW_STAT               0xd00348cc
#define XGPN_PLMP_SLEEP_ALLOW_STAT_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t seq                  :  8 ; /* bits 7:0 */
    ca_uint32_t type                 :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_SLEEP_ALLOW_STAT_t;


#define XGPN_PLMP_SLEEP_REQ                      0xd00348d0
#define XGPN_PLMP_SLEEP_REQ_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t activity_level       :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rdy                  :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_SLEEP_REQ_t;


#define XGPN_PLMP_SW_ACK                         0xd00348d4
#define XGPN_PLMP_SW_ACK_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t complt_code          :  8 ; /* bits 7:0 */
    ca_uint32_t seqno                :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               : 14 ;
    ca_uint32_t chng_pwr_level       :  1 ; /* bits 30:30 */
    ca_uint32_t protect_ctrl         :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_SW_ACK_t;


#define XGPN_PLMP_CH0_POWER_CONSUMPTION          0xd00348d8
#define XGPN_PLMP_CH0_POWER_CONSUMPTION_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t indicate             : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_CH0_POWER_CONSUMPTION_t;


#define XGPN_PLMP_CH1_POWER_CONSUMPTION          0xd00348dc
#define XGPN_PLMP_CH1_POWER_CONSUMPTION_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t indicate             : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_CH1_POWER_CONSUMPTION_t;


#define XGPN_PLMP_CH2_POWER_CONSUMPTION          0xd00348e0
#define XGPN_PLMP_CH2_POWER_CONSUMPTION_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t indicate             : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_CH2_POWER_CONSUMPTION_t;


#define XGPN_PLMP_CH3_POWER_CONSUMPTION          0xd00348e4
#define XGPN_PLMP_CH3_POWER_CONSUMPTION_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t indicate             : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_CH3_POWER_CONSUMPTION_t;


#define XGPN_PLMP_CH4_POWER_CONSUMPTION          0xd00348e8
#define XGPN_PLMP_CH4_POWER_CONSUMPTION_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t indicate             : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_CH4_POWER_CONSUMPTION_t;


#define XGPN_PLMP_CH5_POWER_CONSUMPTION          0xd00348ec
#define XGPN_PLMP_CH5_POWER_CONSUMPTION_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t indicate             : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_CH5_POWER_CONSUMPTION_t;


#define XGPN_PLMP_CH6_POWER_CONSUMPTION          0xd00348f0
#define XGPN_PLMP_CH6_POWER_CONSUMPTION_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t indicate             : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_CH6_POWER_CONSUMPTION_t;


#define XGPN_PLMP_CH7_POWER_CONSUMPTION          0xd00348f4
#define XGPN_PLMP_CH7_POWER_CONSUMPTION_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t indicate             : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_CH7_POWER_CONSUMPTION_t;


#define XGPN_PLMP_TXBUF_CTRL                     0xd00348f8
#define XGPN_PLMP_TXBUF_CTRL_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t defkey               :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 30 ;
    ca_uint32_t pkt_rdy              :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_TXBUF_CTRL_t;


#define XGPN_PLMP_TXBUF_DATA0                    0xd00348fc
#define XGPN_PLMP_TXBUF_DATA0_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_TXBUF_DATA0_t;


#define XGPN_PLMP_TXBUF_DATA1                    0xd0034900
#define XGPN_PLMP_TXBUF_DATA1_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_TXBUF_DATA1_t;


#define XGPN_PLMP_TXBUF_DATA2                    0xd0034904
#define XGPN_PLMP_TXBUF_DATA2_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_TXBUF_DATA2_t;


#define XGPN_PLMP_TXBUF_DATA3                    0xd0034908
#define XGPN_PLMP_TXBUF_DATA3_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_TXBUF_DATA3_t;


#define XGPN_PLMP_TXBUF_DATA4                    0xd003490c
#define XGPN_PLMP_TXBUF_DATA4_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_TXBUF_DATA4_t;


#define XGPN_PLMP_TXBUF_DATA5                    0xd0034910
#define XGPN_PLMP_TXBUF_DATA5_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_TXBUF_DATA5_t;


#define XGPN_PLMP_TXBUF_DATA6                    0xd0034914
#define XGPN_PLMP_TXBUF_DATA6_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_TXBUF_DATA6_t;


#define XGPN_PLMP_TXBUF_DATA7                    0xd0034918
#define XGPN_PLMP_TXBUF_DATA7_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_TXBUF_DATA7_t;


#define XGPN_PLMP_TXBUF_DATA8                    0xd003491c
#define XGPN_PLMP_TXBUF_DATA8_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_TXBUF_DATA8_t;


#define XGPN_PLMP_TXBUF_DATA9                    0xd0034920
#define XGPN_PLMP_TXBUF_DATA9_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_TXBUF_DATA9_t;


#define XGPN_PLMP_RXBUF0_STAT                    0xd0034924
#define XGPN_PLMP_RXBUF0_STAT_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 15 ;
    ca_uint32_t mic_err              :  1 ; /* bits 15:15 */
    ca_uint32_t rx_sfc               :  4 ; /* bits 19:16 */
    ca_uint32_t rsrvd2               : 10 ;
    ca_uint32_t turn                 :  1 ; /* bits 30:30 */
    ca_uint32_t pkt_rdy              :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_RXBUF0_STAT_t;


#define XGPN_PLMP_RXBUF1_STAT                    0xd0034928
#define XGPN_PLMP_RXBUF1_STAT_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 15 ;
    ca_uint32_t mic_err              :  1 ; /* bits 15:15 */
    ca_uint32_t rx_sfc               :  4 ; /* bits 19:16 */
    ca_uint32_t rsrvd2               : 10 ;
    ca_uint32_t turn                 :  1 ; /* bits 30:30 */
    ca_uint32_t pkt_rdy              :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_RXBUF1_STAT_t;


#define XGPN_PLMP_RXBUF                          0xd0034980
#define XGPN_PLMP_RXBUF_STRIDE                   4
#define XGPN_PLMP_RXBUF_COUNT                    24
#define XGPN_PLMP_RXBUF_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_RXBUF_t;


#define XGPN_PLMP_MIC_ERR_MIB                    0xd0034a00
#define XGPN_PLMP_MIC_ERR_MIB_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_MIC_ERR_MIB_t;


#define XGPN_PLMP_DS_RX_MIB                      0xd0034a04
#define XGPN_PLMP_DS_RX_MIB_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_DS_RX_MIB_t;


#define XGPN_PLMP_SYSTEM_PRFL_MIB                0xd0034a08
#define XGPN_PLMP_SYSTEM_PRFL_MIB_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_SYSTEM_PRFL_MIB_t;


#define XGPN_PLMP_CHANNEL_PRFL_MIB               0xd0034a0c
#define XGPN_PLMP_CHANNEL_PRFL_MIB_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_CHANNEL_PRFL_MIB_t;


#define XGPN_PLMP_PRFL_MIB                       0xd0034a10
#define XGPN_PLMP_PRFL_MIB_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_PRFL_MIB_t;


#define XGPN_PLMP_ASSGN_ONUID_MIB                0xd0034a14
#define XGPN_PLMP_ASSGN_ONUID_MIB_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_ASSGN_ONUID_MIB_t;


#define XGPN_PLMP_RANGING_TIME_MIB               0xd0034a18
#define XGPN_PLMP_RANGING_TIME_MIB_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_RANGING_TIME_MIB_t;


#define XGPN_PLMP_PROTECT_CTRL_MIB               0xd0034a1c
#define XGPN_PLMP_PROTECT_CTRL_MIB_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_PROTECT_CTRL_MIB_t;


#define XGPN_PLMP_ADJ_TX_WVLN_MIB                0xd0034a20
#define XGPN_PLMP_ADJ_TX_WVLN_MIB_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_ADJ_TX_WVLN_MIB_t;


#define XGPN_PLMP_DEACTV_ONU_MIB                 0xd0034a24
#define XGPN_PLMP_DEACTV_ONU_MIB_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_DEACTV_ONU_MIB_t;


#define XGPN_PLMP_DISABLE_SN_MIB                 0xd0034a28
#define XGPN_PLMP_DISABLE_SN_MIB_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_DISABLE_SN_MIB_t;


#define XGPN_PLMP_REQ_REGST_MIB                  0xd0034a2c
#define XGPN_PLMP_REQ_REGST_MIB_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_REQ_REGST_MIB_t;


#define XGPN_PLMP_ASSGN_ALLCTID_MIB              0xd0034a30
#define XGPN_PLMP_ASSGN_ALLCTID_MIB_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_ASSGN_ALLCTID_MIB_t;


#define XGPN_PLMP_KEY_CTRL_MIB                   0xd0034a34
#define XGPN_PLMP_KEY_CTRL_MIB_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_KEY_CTRL_MIB_t;


#define XGPN_PLMP_SLEEP_ALLW_MIB                 0xd0034a38
#define XGPN_PLMP_SLEEP_ALLW_MIB_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_SLEEP_ALLW_MIB_t;


#define XGPN_PLMP_TUNING_CTRL_REQ_MIB            0xd0034a3c
#define XGPN_PLMP_TUNING_CTRL_REQ_MIB_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_TUNING_CTRL_REQ_MIB_t;


#define XGPN_PLMP_TUNING_CTRL_CMPLT_MIB          0xd0034a40
#define XGPN_PLMP_TUNING_CTRL_CMPLT_MIB_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_TUNING_CTRL_CMPLT_MIB_t;


#define XGPN_PLMP_CALIBRT_REQ_MIB                0xd0034a44
#define XGPN_PLMP_CALIBRT_REQ_MIB_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_CALIBRT_REQ_MIB_t;


#define XGPN_PLMP_US_TX_MIB                      0xd0034a48
#define XGPN_PLMP_US_TX_MIB_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_US_TX_MIB_t;


#define XGPN_PLMP_SN_ONU_MIB                     0xd0034a4c
#define XGPN_PLMP_SN_ONU_MIB_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_SN_ONU_MIB_t;


#define XGPN_PLMP_REGST_MIB                      0xd0034a50
#define XGPN_PLMP_REGST_MIB_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_REGST_MIB_t;


#define XGPN_PLMP_ACK_MIB                        0xd0034a54
#define XGPN_PLMP_ACK_MIB_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_ACK_MIB_t;


#define XGPN_PLMP_KEY_REPORT_MIB                 0xd0034a58
#define XGPN_PLMP_KEY_REPORT_MIB_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_KEY_REPORT_MIB_t;


#define XGPN_PLMP_SLEEP_REQ_MIB                  0xd0034a5c
#define XGPN_PLMP_SLEEP_REQ_MIB_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_SLEEP_REQ_MIB_t;


#define XGPN_PLMP_TUN_REQ_RSP_MIB                0xd0034a60
#define XGPN_PLMP_TUN_REQ_RSP_MIB_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_TUN_REQ_RSP_MIB_t;


#define XGPN_PLMP_TUN_CMPLTU_MIB                 0xd0034a64
#define XGPN_PLMP_TUN_CMPLTU_MIB_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_TUN_CMPLTU_MIB_t;


#define XGPN_PLMP_PWR_CNSMPT_RPT_MIB             0xd0034a68
#define XGPN_PLMP_PWR_CNSMPT_RPT_MIB_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_PWR_CNSMPT_RPT_MIB_t;


#define XGPN_PLMP_DEBUG_STS0                     0xd0034a6c
#define XGPN_PLMP_DEBUG_STS0_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sn_random_delay      : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_DEBUG_STS0_t;


#define XGPN_PLMP_DEBUG_STS1                     0xd0034a70
#define XGPN_PLMP_DEBUG_STS1_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pon_tag_low          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_DEBUG_STS1_t;


#define XGPN_PLMP_DEBUG_STS2                     0xd0034a74
#define XGPN_PLMP_DEBUG_STS2_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pon_tag_high         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_DEBUG_STS2_t;


#define XGPN_PLMP_BC_PLOAM_SEQ                   0xd0034a78
#define XGPN_PLMP_BC_PLOAM_SEQ_dft               0x00000001

typedef volatile union {
  struct {
    ca_uint32_t number               :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_BC_PLOAM_SEQ_t;


#define XGPN_PLMP_UC_PLOAM_SEQ                   0xd0034a7c
#define XGPN_PLMP_UC_PLOAM_SEQ_dft               0x00000001

typedef volatile union {
  struct {
    ca_uint32_t number               :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_UC_PLOAM_SEQ_t;


#define XGPN_PLMP_BC_MSG_CNT                     0xd0034a80
#define XGPN_PLMP_BC_MSG_CNT_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t deact_onu_pkt        :  4 ; /* bits 3:0 */
    ca_uint32_t assgn_eqd_pkt        :  4 ; /* bits 7:4 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_BC_MSG_CNT_t;


#define XGPN_PLMP_ENABLE_ONU_CNT                 0xd0034a84
#define XGPN_PLMP_ENABLE_ONU_CNT_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_ENABLE_ONU_CNT_t;


#define XGPN_PLMP_UC_UPDT_PRFL_CNT               0xd0034a88
#define XGPN_PLMP_UC_UPDT_PRFL_CNT_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_UC_UPDT_PRFL_CNT_t;


#define XGPN_PLMP_EXTENSION_CNT                  0xd0034a8c
#define XGPN_PLMP_EXTENSION_CNT_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_EXTENSION_CNT_t;


#define XGPN_PLMP_REGST_CNT                      0xd0034a90
#define XGPN_PLMP_REGST_CNT_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rang_gnt_pkt         : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_REGST_CNT_t;


#define XGPN_PLMP_ACK_OK_CNT                     0xd0034a94
#define XGPN_PLMP_ACK_OK_CNT_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_ACK_OK_CNT_t;


#define XGPN_PLMP_PLOAMD_ERR_CNT                 0xd0034a98
#define XGPN_PLMP_PLOAMD_ERR_CNT_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_PLOAMD_ERR_CNT_t;


#define XGPN_PLMP_DS_TX_CNT                      0xd0034a9c
#define XGPN_PLMP_DS_TX_CNT_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_DS_TX_CNT_t;


#define XGPN_PLMP_DS_DROP_CNT                    0xd0034aa0
#define XGPN_PLMP_DS_DROP_CNT_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bc_pkt               : 16 ; /* bits 15:0 */
    ca_uint32_t uc_pkt               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_DS_DROP_CNT_t;


#define XGPN_PLMP_RX_FF_DROP_CNT                 0xd0034aa4
#define XGPN_PLMP_RX_FF_DROP_CNT_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_RX_FF_DROP_CNT_t;


#define XGPN_PLMP_EXTEN_DROP_CNT                 0xd0034aa8
#define XGPN_PLMP_EXTEN_DROP_CNT_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_EXTEN_DROP_CNT_t;


#define XGPN_PLMP_US_RX_CNT                      0xd0034aac
#define XGPN_PLMP_US_RX_CNT_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_US_RX_CNT_t;


#define XGPN_PLMP_US_SW_TX_CNT                   0xd0034ab0
#define XGPN_PLMP_US_SW_TX_CNT_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_US_SW_TX_CNT_t;


#define XGPN_PLMP_DS_SW_RX_CNT                   0xd0034ab4
#define XGPN_PLMP_DS_SW_RX_CNT_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_DS_SW_RX_CNT_t;


#define XGPN_PLMP_EXTENSION_MSG_TYPE             0xd0034ab8
#define XGPN_PLMP_EXTENSION_MSG_TYPE_dft         0xfffbd985

typedef volatile union {
  struct {
    ca_uint32_t en                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_EXTENSION_MSG_TYPE_t;


#define XGPN_PLMP_PLOAM_PKT_GEN_FIFO_CTRL        0xd0034abc
#define XGPN_PLMP_PLOAM_PKT_GEN_FIFO_CTRL_dft    0x00000007

typedef volatile union {
  struct {
    ca_uint32_t threshold            :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_PLOAM_PKT_GEN_FIFO_CTRL_t;


#define XGPN_PLMP_PLOAM_MSG_DROP_CNTR            0xd0034ac0
#define XGPN_PLMP_PLOAM_MSG_DROP_CNTR_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cntr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_PLOAM_MSG_DROP_CNTR_t;


#define XGPN_PLMP_SW_PLOAMD_FULL_DROP_MIB        0xd0034ac4
#define XGPN_PLMP_SW_PLOAMD_FULL_DROP_MIB_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cntr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_SW_PLOAMD_FULL_DROP_MIB_t;


#define XGPN_PLMP_SW_PLOAMD_OVERLAP_DROP_MIB     0xd0034ac8
#define XGPN_PLMP_SW_PLOAMD_OVERLAP_DROP_MIB_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cntr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_SW_PLOAMD_OVERLAP_DROP_MIB_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* plmp */
typedef struct {
  XGPN_PLMP_CTRL_t                         CTRL;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  XGPN_PLMP_DS_CTRL_t                      DS_CTRL;                       /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  XGPN_PLMP_RX_CAPTURE_t                   RX_CAPTURE;                    /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  XGPN_PLMP_US_CTRL_t                      US_CTRL;                       /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  XGPN_PLMP_VENDOR_ID_CFG_t                VENDOR_ID_CFG;                 /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  XGPN_PLMP_VSSN_CFG_t                     VSSN_CFG;                      /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  XGPN_PLMP_CORRELATION_t                  CORRELATION;                   /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  XGPN_PLMP_US_PON_ID_t                    US_PON_ID;                     /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  XGPN_PLMP_CALIBRATION_EVEN_t             CALIBRATION_EVEN;              /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  XGPN_PLMP_CALIBRATION_ODD_t              CALIBRATION_ODD;               /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  XGPN_PLMP_TUNING_PARAMETER_t             TUNING_PARAMETER;              /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  XGPN_PLMP_ATTENUATION_t                  ATTENUATION;                   /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  XGPN_PLMP_RGST_ID_CFG0_t                 RGST_ID_CFG0;                  /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  XGPN_PLMP_RGST_ID_CFG1_t                 RGST_ID_CFG1;                  /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  XGPN_PLMP_RGST_ID_CFG2_t                 RGST_ID_CFG2;                  /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  XGPN_PLMP_RGST_ID_CFG3_t                 RGST_ID_CFG3;                  /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  XGPN_PLMP_RGST_ID_CFG4_t                 RGST_ID_CFG4;                  /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  XGPN_PLMP_RGST_ID_CFG5_t                 RGST_ID_CFG5;                  /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  XGPN_PLMP_RGST_ID_CFG6_t                 RGST_ID_CFG6;                  /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  XGPN_PLMP_RGST_ID_CFG7_t                 RGST_ID_CFG7;                  /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  XGPN_PLMP_RGST_ID_CFG8_t                 RGST_ID_CFG8;                  /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  XGPN_PLMP_TUNING_CONFIG_t                TUNING_CONFIG;                 /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  XGPN_PLMP_SW_RESPONSE_t                  SW_RESPONSE;                   /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  XGPN_PLMP_EQD_THRSHLD_t                  EQD_THRSHLD;                   /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  XGPN_PLMP_ACK_PLOAM_NO_MSG0_t            ACK_PLOAM_NO_MSG0;             /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  XGPN_PLMP_ACK_PLOAM_NO_MSG1_t            ACK_PLOAM_NO_MSG1;             /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  XGPN_PLMP_ACK_PLOAM_BUSY_MSG_CFG_t       ACK_PLOAM_BUSY_MSG_CFG;        /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  XGPN_PLMP_ACK_PLOAM_BUSY_MSG0_t          ACK_PLOAM_BUSY_MSG0;           /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  XGPN_PLMP_ACK_PLOAM_BUSY_MSG1_t          ACK_PLOAM_BUSY_MSG1;           /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  XGPN_PLMP_PLOAM_CFG_t                    PLOAM_CFG;                     /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  XGPN_PLMP_PLOAM_CFG_DATA0_t              PLOAM_CFG_DATA0;               /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  XGPN_PLMP_PLOAM_CFG_DATA1_t              PLOAM_CFG_DATA1;               /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  XGPN_PLMP_PLOAM_CFG_DATA2_t              PLOAM_CFG_DATA2;               /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  XGPN_PLMP_PLOAM_CFG_DATA3_t              PLOAM_CFG_DATA3;               /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  XGPN_PLMP_PLOAM_CFG_DATA4_t              PLOAM_CFG_DATA4;               /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  XGPN_PLMP_PLOAM_CFG_DATA5_t              PLOAM_CFG_DATA5;               /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  XGPN_PLMP_PLOAM_CFG_DATA6_t              PLOAM_CFG_DATA6;               /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  XGPN_PLMP_PLOAM_CFG_DATA7_t              PLOAM_CFG_DATA7;               /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  XGPN_PLMP_PLOAM_CFG_DATA8_t              PLOAM_CFG_DATA8;               /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];                   
  XGPN_PLMP_KEY_EXCHG_THRSHD_t             KEY_EXCHG_THRSHD;              /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];                   
  XGPN_PLMP_INTERRUPT_t                    INTERRUPT;                     /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];                   
  XGPN_PLMP_INTERRUPTE0_t                  INTERRUPTE0;                   /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];                   
  XGPN_PLMP_INTERRUPTE1_t                  INTERRUPTE1;                   /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];                   
  XGPN_PLMP_MIB_SAT_INT_t                  MIB_SAT_INT;                   /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd44[3];                   
  XGPN_PLMP_MIB_SAT_INTE_t                 MIB_SAT_INTE;                  /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd45[3];                   
  XGPN_PLMP_KEY_CTRL_STAT_t                KEY_CTRL_STAT;                 /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd46[3];                   
  XGPN_PLMP_KEY_REPORT_t                   KEY_REPORT;                    /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd47[3];                   
  XGPN_PLMP_KEY_REPORT_FRAG0_t             KEY_REPORT_FRAG0;              /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd48[3];                   
  XGPN_PLMP_KEY_REPORT_FRAG1_t             KEY_REPORT_FRAG1;              /* addr: 0x000000c0 */
  ca_uint32_t                              rsrvd49[3];                   
  XGPN_PLMP_KEY_REPORT_FRAG2_t             KEY_REPORT_FRAG2;              /* addr: 0x000000c4 */
  ca_uint32_t                              rsrvd50[3];                   
  XGPN_PLMP_KEY_REPORT_FRAG3_t             KEY_REPORT_FRAG3;              /* addr: 0x000000c8 */
  ca_uint32_t                              rsrvd51[3];                   
  XGPN_PLMP_SLEEP_ALLOW_STAT_t             SLEEP_ALLOW_STAT;              /* addr: 0x000000cc */
  ca_uint32_t                              rsrvd52[3];                   
  XGPN_PLMP_SLEEP_REQ_t                    SLEEP_REQ;                     /* addr: 0x000000d0 */
  ca_uint32_t                              rsrvd53[3];                   
  XGPN_PLMP_SW_ACK_t                       SW_ACK;                        /* addr: 0x000000d4 */
  ca_uint32_t                              rsrvd54[3];                   
  XGPN_PLMP_CH0_POWER_CONSUMPTION_t        CH0_POWER_CONSUMPTION;         /* addr: 0x000000d8 */
  ca_uint32_t                              rsrvd55[3];                   
  XGPN_PLMP_CH1_POWER_CONSUMPTION_t        CH1_POWER_CONSUMPTION;         /* addr: 0x000000dc */
  ca_uint32_t                              rsrvd56[3];                   
  XGPN_PLMP_CH2_POWER_CONSUMPTION_t        CH2_POWER_CONSUMPTION;         /* addr: 0x000000e0 */
  ca_uint32_t                              rsrvd57[3];                   
  XGPN_PLMP_CH3_POWER_CONSUMPTION_t        CH3_POWER_CONSUMPTION;         /* addr: 0x000000e4 */
  ca_uint32_t                              rsrvd58[3];                   
  XGPN_PLMP_CH4_POWER_CONSUMPTION_t        CH4_POWER_CONSUMPTION;         /* addr: 0x000000e8 */
  ca_uint32_t                              rsrvd59[3];                   
  XGPN_PLMP_CH5_POWER_CONSUMPTION_t        CH5_POWER_CONSUMPTION;         /* addr: 0x000000ec */
  ca_uint32_t                              rsrvd60[3];                   
  XGPN_PLMP_CH6_POWER_CONSUMPTION_t        CH6_POWER_CONSUMPTION;         /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd61[3];                   
  XGPN_PLMP_CH7_POWER_CONSUMPTION_t        CH7_POWER_CONSUMPTION;         /* addr: 0x000000f4 */
  ca_uint32_t                              rsrvd62[3];                   
  XGPN_PLMP_TXBUF_CTRL_t                   TXBUF_CTRL;                    /* addr: 0x000000f8 */
  ca_uint32_t                              rsrvd63[3];                   
  XGPN_PLMP_TXBUF_DATA0_t                  TXBUF_DATA0;                   /* addr: 0x000000fc */
  ca_uint32_t                              rsrvd64[3];                   
  XGPN_PLMP_TXBUF_DATA1_t                  TXBUF_DATA1;                   /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd65[3];                   
  XGPN_PLMP_TXBUF_DATA2_t                  TXBUF_DATA2;                   /* addr: 0x00000104 */
  ca_uint32_t                              rsrvd66[3];                   
  XGPN_PLMP_TXBUF_DATA3_t                  TXBUF_DATA3;                   /* addr: 0x00000108 */
  ca_uint32_t                              rsrvd67[3];                   
  XGPN_PLMP_TXBUF_DATA4_t                  TXBUF_DATA4;                   /* addr: 0x0000010c */
  ca_uint32_t                              rsrvd68[3];                   
  XGPN_PLMP_TXBUF_DATA5_t                  TXBUF_DATA5;                   /* addr: 0x00000110 */
  ca_uint32_t                              rsrvd69[3];                   
  XGPN_PLMP_TXBUF_DATA6_t                  TXBUF_DATA6;                   /* addr: 0x00000114 */
  ca_uint32_t                              rsrvd70[3];                   
  XGPN_PLMP_TXBUF_DATA7_t                  TXBUF_DATA7;                   /* addr: 0x00000118 */
  ca_uint32_t                              rsrvd71[3];                   
  XGPN_PLMP_TXBUF_DATA8_t                  TXBUF_DATA8;                   /* addr: 0x0000011c */
  ca_uint32_t                              rsrvd72[3];                   
  XGPN_PLMP_TXBUF_DATA9_t                  TXBUF_DATA9;                   /* addr: 0x00000120 */
  ca_uint32_t                              rsrvd73[3];                   
  XGPN_PLMP_RXBUF0_STAT_t                  RXBUF0_STAT;                   /* addr: 0x00000124 */
  ca_uint32_t                              rsrvd74[3];                   
  XGPN_PLMP_RXBUF1_STAT_t                  RXBUF1_STAT;                   /* addr: 0x00000128 */
  ca_uint32_t                              rsrvd75[87];                  
  XGPN_PLMP_RXBUF_t                        RXBUF[24];                     /* addr: 0x00000180 */
  ca_uint32_t                              rsrvd76[104];                 
  XGPN_PLMP_MIC_ERR_MIB_t                  MIC_ERR_MIB;                   /* addr: 0x00000200 */
  ca_uint32_t                              rsrvd77[3];                   
  XGPN_PLMP_DS_RX_MIB_t                    DS_RX_MIB;                     /* addr: 0x00000204 */
  ca_uint32_t                              rsrvd78[3];                   
  XGPN_PLMP_SYSTEM_PRFL_MIB_t              SYSTEM_PRFL_MIB;               /* addr: 0x00000208 */
  ca_uint32_t                              rsrvd79[3];                   
  XGPN_PLMP_CHANNEL_PRFL_MIB_t             CHANNEL_PRFL_MIB;              /* addr: 0x0000020c */
  ca_uint32_t                              rsrvd80[3];                   
  XGPN_PLMP_PRFL_MIB_t                     PRFL_MIB;                      /* addr: 0x00000210 */
  ca_uint32_t                              rsrvd81[3];                   
  XGPN_PLMP_ASSGN_ONUID_MIB_t              ASSGN_ONUID_MIB;               /* addr: 0x00000214 */
  ca_uint32_t                              rsrvd82[3];                   
  XGPN_PLMP_RANGING_TIME_MIB_t             RANGING_TIME_MIB;              /* addr: 0x00000218 */
  ca_uint32_t                              rsrvd83[3];                   
  XGPN_PLMP_PROTECT_CTRL_MIB_t             PROTECT_CTRL_MIB;              /* addr: 0x0000021c */
  ca_uint32_t                              rsrvd84[3];                   
  XGPN_PLMP_ADJ_TX_WVLN_MIB_t              ADJ_TX_WVLN_MIB;               /* addr: 0x00000220 */
  ca_uint32_t                              rsrvd85[3];                   
  XGPN_PLMP_DEACTV_ONU_MIB_t               DEACTV_ONU_MIB;                /* addr: 0x00000224 */
  ca_uint32_t                              rsrvd86[3];                   
  XGPN_PLMP_DISABLE_SN_MIB_t               DISABLE_SN_MIB;                /* addr: 0x00000228 */
  ca_uint32_t                              rsrvd87[3];                   
  XGPN_PLMP_REQ_REGST_MIB_t                REQ_REGST_MIB;                 /* addr: 0x0000022c */
  ca_uint32_t                              rsrvd88[3];                   
  XGPN_PLMP_ASSGN_ALLCTID_MIB_t            ASSGN_ALLCTID_MIB;             /* addr: 0x00000230 */
  ca_uint32_t                              rsrvd89[3];                   
  XGPN_PLMP_KEY_CTRL_MIB_t                 KEY_CTRL_MIB;                  /* addr: 0x00000234 */
  ca_uint32_t                              rsrvd90[3];                   
  XGPN_PLMP_SLEEP_ALLW_MIB_t               SLEEP_ALLW_MIB;                /* addr: 0x00000238 */
  ca_uint32_t                              rsrvd91[3];                   
  XGPN_PLMP_TUNING_CTRL_REQ_MIB_t          TUNING_CTRL_REQ_MIB;           /* addr: 0x0000023c */
  ca_uint32_t                              rsrvd92[3];                   
  XGPN_PLMP_TUNING_CTRL_CMPLT_MIB_t        TUNING_CTRL_CMPLT_MIB;         /* addr: 0x00000240 */
  ca_uint32_t                              rsrvd93[3];                   
  XGPN_PLMP_CALIBRT_REQ_MIB_t              CALIBRT_REQ_MIB;               /* addr: 0x00000244 */
  ca_uint32_t                              rsrvd94[3];                   
  XGPN_PLMP_US_TX_MIB_t                    US_TX_MIB;                     /* addr: 0x00000248 */
  ca_uint32_t                              rsrvd95[3];                   
  XGPN_PLMP_SN_ONU_MIB_t                   SN_ONU_MIB;                    /* addr: 0x0000024c */
  ca_uint32_t                              rsrvd96[3];                   
  XGPN_PLMP_REGST_MIB_t                    REGST_MIB;                     /* addr: 0x00000250 */
  ca_uint32_t                              rsrvd97[3];                   
  XGPN_PLMP_ACK_MIB_t                      ACK_MIB;                       /* addr: 0x00000254 */
  ca_uint32_t                              rsrvd98[3];                   
  XGPN_PLMP_KEY_REPORT_MIB_t               KEY_REPORT_MIB;                /* addr: 0x00000258 */
  ca_uint32_t                              rsrvd99[3];                   
  XGPN_PLMP_SLEEP_REQ_MIB_t                SLEEP_REQ_MIB;                 /* addr: 0x0000025c */
  ca_uint32_t                              rsrvd100[3];                  
  XGPN_PLMP_TUN_REQ_RSP_MIB_t              TUN_REQ_RSP_MIB;               /* addr: 0x00000260 */
  ca_uint32_t                              rsrvd101[3];                  
  XGPN_PLMP_TUN_CMPLTU_MIB_t               TUN_CMPLTU_MIB;                /* addr: 0x00000264 */
  ca_uint32_t                              rsrvd102[3];                  
  XGPN_PLMP_PWR_CNSMPT_RPT_MIB_t           PWR_CNSMPT_RPT_MIB;            /* addr: 0x00000268 */
  ca_uint32_t                              rsrvd103[3];                  
  XGPN_PLMP_DEBUG_STS0_t                   DEBUG_STS0;                    /* addr: 0x0000026c */
  ca_uint32_t                              rsrvd104[3];                  
  XGPN_PLMP_DEBUG_STS1_t                   DEBUG_STS1;                    /* addr: 0x00000270 */
  ca_uint32_t                              rsrvd105[3];                  
  XGPN_PLMP_DEBUG_STS2_t                   DEBUG_STS2;                    /* addr: 0x00000274 */
  ca_uint32_t                              rsrvd106[3];                  
  XGPN_PLMP_BC_PLOAM_SEQ_t                 BC_PLOAM_SEQ;                  /* addr: 0x00000278 */
  ca_uint32_t                              rsrvd107[3];                  
  XGPN_PLMP_UC_PLOAM_SEQ_t                 UC_PLOAM_SEQ;                  /* addr: 0x0000027c */
  ca_uint32_t                              rsrvd108[3];                  
  XGPN_PLMP_BC_MSG_CNT_t                   BC_MSG_CNT;                    /* addr: 0x00000280 */
  ca_uint32_t                              rsrvd109[3];                  
  XGPN_PLMP_ENABLE_ONU_CNT_t               ENABLE_ONU_CNT;                /* addr: 0x00000284 */
  ca_uint32_t                              rsrvd110[3];                  
  XGPN_PLMP_UC_UPDT_PRFL_CNT_t             UC_UPDT_PRFL_CNT;              /* addr: 0x00000288 */
  ca_uint32_t                              rsrvd111[3];                  
  XGPN_PLMP_EXTENSION_CNT_t                EXTENSION_CNT;                 /* addr: 0x0000028c */
  ca_uint32_t                              rsrvd112[3];                  
  XGPN_PLMP_REGST_CNT_t                    REGST_CNT;                     /* addr: 0x00000290 */
  ca_uint32_t                              rsrvd113[3];                  
  XGPN_PLMP_ACK_OK_CNT_t                   ACK_OK_CNT;                    /* addr: 0x00000294 */
  ca_uint32_t                              rsrvd114[3];                  
  XGPN_PLMP_PLOAMD_ERR_CNT_t               PLOAMD_ERR_CNT;                /* addr: 0x00000298 */
  ca_uint32_t                              rsrvd115[3];                  
  XGPN_PLMP_DS_TX_CNT_t                    DS_TX_CNT;                     /* addr: 0x0000029c */
  ca_uint32_t                              rsrvd116[3];                  
  XGPN_PLMP_DS_DROP_CNT_t                  DS_DROP_CNT;                   /* addr: 0x000002a0 */
  ca_uint32_t                              rsrvd117[3];                  
  XGPN_PLMP_RX_FF_DROP_CNT_t               RX_FF_DROP_CNT;                /* addr: 0x000002a4 */
  ca_uint32_t                              rsrvd118[3];                  
  XGPN_PLMP_EXTEN_DROP_CNT_t               EXTEN_DROP_CNT;                /* addr: 0x000002a8 */
  ca_uint32_t                              rsrvd119[3];                  
  XGPN_PLMP_US_RX_CNT_t                    US_RX_CNT;                     /* addr: 0x000002ac */
  ca_uint32_t                              rsrvd120[3];                  
  XGPN_PLMP_US_SW_TX_CNT_t                 US_SW_TX_CNT;                  /* addr: 0x000002b0 */
  ca_uint32_t                              rsrvd121[3];                  
  XGPN_PLMP_DS_SW_RX_CNT_t                 DS_SW_RX_CNT;                  /* addr: 0x000002b4 */
  ca_uint32_t                              rsrvd122[3];                  
  XGPN_PLMP_EXTENSION_MSG_TYPE_t           EXTENSION_MSG_TYPE;            /* addr: 0x000002b8 */
  ca_uint32_t                              rsrvd123[3];                  
  XGPN_PLMP_PLOAM_PKT_GEN_FIFO_CTRL_t      PLOAM_PKT_GEN_FIFO_CTRL;       /* addr: 0x000002bc */
  ca_uint32_t                              rsrvd124[3];                  
  XGPN_PLMP_PLOAM_MSG_DROP_CNTR_t          PLOAM_MSG_DROP_CNTR;           /* addr: 0x000002c0 */
  ca_uint32_t                              rsrvd125[3];                  
  XGPN_PLMP_SW_PLOAMD_FULL_DROP_MIB_t      SW_PLOAMD_FULL_DROP_MIB;       /* addr: 0x000002c4 */
  ca_uint32_t                              rsrvd126[3];                  
  XGPN_PLMP_SW_PLOAMD_OVERLAP_DROP_MIB_t   SW_PLOAMD_OVERLAP_DROP_MIB;    /* addr: 0x000002c8 */
} APB1_XGPN_PLMP_t;


/*
 * actp
 */
        
#define XGPN_ACTP_CTRL                           0xd0034b00
#define XGPN_ACTP_CTRL_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sw_mode              :  1 ; /* bits 0:0 */
    ca_uint32_t sw_discard_all       :  1 ; /* bits 1:1 */
    ca_uint32_t sw_discard_brstpf    :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t response_threshold   :  4 ; /* bits 7:4 */
    ca_uint32_t rsrvd2               :  8 ;
    ca_uint32_t wlcp_enable          :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd3               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_ACTP_CTRL_t;


#define XGPN_ACTP_SYNC_HUNT                      0xd0034b04
#define XGPN_ACTP_SYNC_HUNT_dft                  0x00000320

typedef volatile union {
  struct {
    ca_uint32_t threshold            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_ACTP_SYNC_HUNT_t;


#define XGPN_ACTP_TOZ                            0xd0034b08
#define XGPN_ACTP_TOZ_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t threshold            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_ACTP_TOZ_t;


#define XGPN_ACTP_TO1                            0xd0034b0c
#define XGPN_ACTP_TO1_dft                        0x00013880

typedef volatile union {
  struct {
    ca_uint32_t threshold            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_ACTP_TO1_t;


#define XGPN_ACTP_TO23                           0xd0034b10
#define XGPN_ACTP_TO23_dft                       0x00000320

typedef volatile union {
  struct {
    ca_uint32_t threshold            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_ACTP_TO23_t;


#define XGPN_ACTP_TO4                            0xd0034b14
#define XGPN_ACTP_TO4_dft                        0x00013880

typedef volatile union {
  struct {
    ca_uint32_t threshold            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_ACTP_TO4_t;


#define XGPN_ACTP_TO5                            0xd0034b18
#define XGPN_ACTP_TO5_dft                        0x00013880

typedef volatile union {
  struct {
    ca_uint32_t threshold            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_ACTP_TO5_t;


#define XGPN_ACTP_INTERRUPT                      0xd0034b1c
#define XGPN_ACTP_INTERRUPT_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t onu_state_change     :  1 ; /* bits 0:0 */
    ca_uint32_t hunt_sync_expire     :  1 ; /* bits 1:1 */
    ca_uint32_t profile_learning     :  1 ; /* bits 2:2 */
    ca_uint32_t tx_response_cross    :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_ACTP_INTERRUPT_t;


#define XGPN_ACTP_INTERRUPTE0                    0xd0034b20
#define XGPN_ACTP_INTERRUPTE0_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t onu_state_changeE    :  1 ; /* bits 0:0 */
    ca_uint32_t hunt_sync_expireE    :  1 ; /* bits 1:1 */
    ca_uint32_t profile_learningE    :  1 ; /* bits 2:2 */
    ca_uint32_t tx_response_crossE   :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_ACTP_INTERRUPTE0_t;


#define XGPN_ACTP_INTERRUPTE1                    0xd0034b24
#define XGPN_ACTP_INTERRUPTE1_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t onu_state_changeE    :  1 ; /* bits 0:0 */
    ca_uint32_t hunt_sync_expireE    :  1 ; /* bits 1:1 */
    ca_uint32_t profile_learningE    :  1 ; /* bits 2:2 */
    ca_uint32_t tx_response_crossE   :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_ACTP_INTERRUPTE1_t;


#define XGPN_ACTP_ST_CHG_INT                     0xd0034b28
#define XGPN_ACTP_ST_CHG_INT_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t deregst              :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd2               :  4 ;
    ca_uint32_t loss_sync            :  1 ; /* bits 6:6 */
    ca_uint32_t ds_synced            :  1 ; /* bits 7:7 */
    ca_uint32_t DWLCH_appropriate    :  1 ; /* bits 8:8 */
    ca_uint32_t DWLCH_inappropriate  :  1 ; /* bits 9:9 */
    ca_uint32_t disable_SN           :  1 ; /* bits 10:10 */
    ca_uint32_t deactivate_OID       :  1 ; /* bits 11:11 */
    ca_uint32_t assign_OID           :  1 ; /* bits 12:12 */
    ca_uint32_t calibr_req_mismatch  :  1 ; /* bits 13:13 */
    ca_uint32_t TOZ_expire           :  1 ; /* bits 14:14 */
    ca_uint32_t TO1_expire           :  1 ; /* bits 15:15 */
    ca_uint32_t assign_OID_inconsist :  1 ; /* bits 16:16 */
    ca_uint32_t assign_EqD           :  1 ; /* bits 17:17 */
    ca_uint32_t tuning_request_ack   :  1 ; /* bits 18:18 */
    ca_uint32_t tuning_request_tx    :  1 ; /* bits 19:19 */
    ca_uint32_t tuning_request_rx    :  1 ; /* bits 20:20 */
    ca_uint32_t enable_SN            :  1 ; /* bits 21:21 */
    ca_uint32_t us_tuning_confirm    :  1 ; /* bits 22:22 */
    ca_uint32_t TO2_expire           :  1 ; /* bits 23:23 */
    ca_uint32_t TO3_expire           :  1 ; /* bits 24:24 */
    ca_uint32_t TO4_expire           :  1 ; /* bits 25:25 */
    ca_uint32_t TO5_expire           :  1 ; /* bits 26:26 */
    ca_uint32_t ds_synced_O6         :  1 ; /* bits 27:27 */
    ca_uint32_t rsrvd3               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_ACTP_ST_CHG_INT_t;


#define XGPN_ACTP_ST_CHG_INTE                    0xd0034b2c
#define XGPN_ACTP_ST_CHG_INTE_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t deregstE             :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd2               :  4 ;
    ca_uint32_t loss_syncE           :  1 ; /* bits 6:6 */
    ca_uint32_t ds_syncedE           :  1 ; /* bits 7:7 */
    ca_uint32_t DWLCH_appropriateE   :  1 ; /* bits 8:8 */
    ca_uint32_t DWLCH_inappropriateE :  1 ; /* bits 9:9 */
    ca_uint32_t disable_SNE          :  1 ; /* bits 10:10 */
    ca_uint32_t deactivate_OIDE      :  1 ; /* bits 11:11 */
    ca_uint32_t assign_OIDE          :  1 ; /* bits 12:12 */
    ca_uint32_t calibr_req_mismatchE :  1 ; /* bits 13:13 */
    ca_uint32_t TOZ_expireE          :  1 ; /* bits 14:14 */
    ca_uint32_t TO1_expireE          :  1 ; /* bits 15:15 */
    ca_uint32_t assign_OID_inconsistE :  1 ; /* bits 16:16 */
    ca_uint32_t assign_EqDE          :  1 ; /* bits 17:17 */
    ca_uint32_t tuning_request_ackE  :  1 ; /* bits 18:18 */
    ca_uint32_t tuning_request_txE   :  1 ; /* bits 19:19 */
    ca_uint32_t tuning_request_rxE   :  1 ; /* bits 20:20 */
    ca_uint32_t enable_SNE           :  1 ; /* bits 21:21 */
    ca_uint32_t us_tuning_confirmE   :  1 ; /* bits 22:22 */
    ca_uint32_t TO2_expireE          :  1 ; /* bits 23:23 */
    ca_uint32_t TO3_expireE          :  1 ; /* bits 24:24 */
    ca_uint32_t TO4_expireE          :  1 ; /* bits 25:25 */
    ca_uint32_t TO5_expireE          :  1 ; /* bits 26:26 */
    ca_uint32_t ds_synced_O6E        :  1 ; /* bits 27:27 */
    ca_uint32_t rsrvd3               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_ACTP_ST_CHG_INTE_t;


#define XGPN_ACTP_STS                            0xd0034b30
#define XGPN_ACTP_STS_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t onu_state            :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t onu_sub_state        :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t previous_onu_state   :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t previous_sub_state   :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd4               :  3 ;
    ca_uint32_t profile_learning     :  2 ; /* bits 17:16 */
    ca_uint32_t rsrvd5               :  6 ;
    ca_uint32_t rx_optical_tuning    :  1 ; /* bits 24:24 */
    ca_uint32_t rsrvd6               :  3 ;
    ca_uint32_t tx_optical_tuning    :  1 ; /* bits 28:28 */
    ca_uint32_t rsrvd7               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_ACTP_STS_t;


#define XGPN_ACTP_DEREG_STS                      0xd0034b34
#define XGPN_ACTP_DEREG_STS_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t onu_state            :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_ACTP_DEREG_STS_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* actp */
typedef struct {
  XGPN_ACTP_CTRL_t                         CTRL;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  XGPN_ACTP_SYNC_HUNT_t                    SYNC_HUNT;                     /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  XGPN_ACTP_TOZ_t                          TOZ;                           /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  XGPN_ACTP_TO1_t                          TO1;                           /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  XGPN_ACTP_TO23_t                         TO23;                          /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  XGPN_ACTP_TO4_t                          TO4;                           /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  XGPN_ACTP_TO5_t                          TO5;                           /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  XGPN_ACTP_INTERRUPT_t                    INTERRUPT;                     /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  XGPN_ACTP_INTERRUPTE0_t                  INTERRUPTE0;                   /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  XGPN_ACTP_INTERRUPTE1_t                  INTERRUPTE1;                   /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  XGPN_ACTP_ST_CHG_INT_t                   ST_CHG_INT;                    /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  XGPN_ACTP_ST_CHG_INTE_t                  ST_CHG_INTE;                   /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  XGPN_ACTP_STS_t                          STS;                           /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  XGPN_ACTP_DEREG_STS_t                    DEREG_STS;                     /* addr: 0x00000034 */
} APB1_XGPN_ACTP_t;


/*
 * xgfec
 */
        
#define XGPN_XGFEC_RXINT                         0xd0034b80
#define XGPN_XGFEC_RXINT_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t CorrByteMsb          :  1 ; /* bits 0:0 */
    ca_uint32_t CorrCodeMsb          :  1 ; /* bits 1:1 */
    ca_uint32_t UncorCodeMsb         :  1 ; /* bits 2:2 */
    ca_uint32_t TotalCodeMsb         :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 12 ;
    ca_uint32_t CorrByteSat          :  1 ; /* bits 16:16 */
    ca_uint32_t CorrCodeSat          :  1 ; /* bits 17:17 */
    ca_uint32_t UncorCodeSat         :  1 ; /* bits 18:18 */
    ca_uint32_t TotalCodeSat         :  1 ; /* bits 19:19 */
    ca_uint32_t rsrvd2               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_XGFEC_RXINT_t;


#define XGPN_XGFEC_RXINTE0                       0xd0034b84
#define XGPN_XGFEC_RXINTE0_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t CorrByteMsbE         :  1 ; /* bits 0:0 */
    ca_uint32_t CorrCodeMsbE         :  1 ; /* bits 1:1 */
    ca_uint32_t UncorCodeMsbE        :  1 ; /* bits 2:2 */
    ca_uint32_t TotalCodeMsbE        :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 12 ;
    ca_uint32_t CorrByteSatE         :  1 ; /* bits 16:16 */
    ca_uint32_t CorrCodeSatE         :  1 ; /* bits 17:17 */
    ca_uint32_t UncorCodeSatE        :  1 ; /* bits 18:18 */
    ca_uint32_t TotalCodeSatE        :  1 ; /* bits 19:19 */
    ca_uint32_t rsrvd2               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_XGFEC_RXINTE0_t;


#define XGPN_XGFEC_RXINTE1                       0xd0034b88
#define XGPN_XGFEC_RXINTE1_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t CorrByteMsbE         :  1 ; /* bits 0:0 */
    ca_uint32_t CorrCodeMsbE         :  1 ; /* bits 1:1 */
    ca_uint32_t UncorCodeMsbE        :  1 ; /* bits 2:2 */
    ca_uint32_t TotalCodeMsbE        :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 12 ;
    ca_uint32_t CorrByteSatE         :  1 ; /* bits 16:16 */
    ca_uint32_t CorrCodeSatE         :  1 ; /* bits 17:17 */
    ca_uint32_t UncorCodeSatE        :  1 ; /* bits 18:18 */
    ca_uint32_t TotalCodeSatE        :  1 ; /* bits 19:19 */
    ca_uint32_t rsrvd2               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_XGFEC_RXINTE1_t;


#define XGPN_XGFEC_FECCORRBYTE                   0xd0034b8c
#define XGPN_XGFEC_FECCORRBYTE_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_XGFEC_FECCORRBYTE_t;


#define XGPN_XGFEC_FECTOTALCODE                  0xd0034b90
#define XGPN_XGFEC_FECTOTALCODE_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_XGFEC_FECTOTALCODE_t;


#define XGPN_XGFEC_FECCORRCODE                   0xd0034b94
#define XGPN_XGFEC_FECCORRCODE_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_XGFEC_FECCORRCODE_t;


#define XGPN_XGFEC_FECUNCORCODE                  0xd0034b98
#define XGPN_XGFEC_FECUNCORCODE_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_XGFEC_FECUNCORCODE_t;


#define XGPN_XGFEC_FECCNTRL                      0xd0034b9c
#define XGPN_XGFEC_FECCNTRL_dft                  0x00080000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 16 ;
    ca_uint32_t fec_dec_corr_disable :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t rx_fec_bypass_delay_mode :  1 ; /* bits 19:19 */
    ca_uint32_t rsrvd3               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_XGFEC_FECCNTRL_t;


#define XGPN_XGFEC_TXDISFEC                      0xd0034ba0
#define XGPN_XGFEC_TXDISFEC_dft                  0x0001f000

typedef volatile union {
  struct {
    ca_uint32_t disableFEC           :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t swap_before_fec_encoder :  1 ; /* bits 2:2 */
    ca_uint32_t swap_after_fec_encoder :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd2               :  8 ;
    ca_uint32_t error_inject_count   :  4 ; /* bits 15:12 */
    ca_uint32_t tx_fec_bypass_delay_mode :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd3               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_XGFEC_TXDISFEC_t;


#define XGPN_XGFEC_FEC_MASK_MEM_SW_ACCESS        0xd0034ba4
#define XGPN_XGFEC_FEC_MASK_MEM_SW_ACCESS_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t MASK_MEM_ADDR        :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t w_rdn                :  1 ; /* bits 30:30 */
    ca_uint32_t ACCESS               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_XGFEC_FEC_MASK_MEM_SW_ACCESS_t;


#define XGPN_XGFEC_FEC_MASK_MEM_SW_DATA          0xd0034ba8
#define XGPN_XGFEC_FEC_MASK_MEM_SW_DATA_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t MASK_MEM_DATA        : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_XGFEC_FEC_MASK_MEM_SW_DATA_t;


#define XGPN_XGFEC_FEC_ERROR_INJECT              0xd0034bac
#define XGPN_XGFEC_FEC_ERROR_INJECT_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t enable               :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_XGFEC_FEC_ERROR_INJECT_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* xgfec */
typedef struct {
  XGPN_XGFEC_RXINT_t                       RXINT;                         /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  XGPN_XGFEC_RXINTE0_t                     RXINTE0;                       /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  XGPN_XGFEC_RXINTE1_t                     RXINTE1;                       /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  XGPN_XGFEC_FECCORRBYTE_t                 FECCORRBYTE;                   /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  XGPN_XGFEC_FECTOTALCODE_t                FECTOTALCODE;                  /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  XGPN_XGFEC_FECCORRCODE_t                 FECCORRCODE;                   /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  XGPN_XGFEC_FECUNCORCODE_t                FECUNCORCODE;                  /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  XGPN_XGFEC_FECCNTRL_t                    FECCNTRL;                      /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  XGPN_XGFEC_TXDISFEC_t                    TXDISFEC;                      /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  XGPN_XGFEC_FEC_MASK_MEM_SW_ACCESS_t      FEC_MASK_MEM_SW_ACCESS;        /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  XGPN_XGFEC_FEC_MASK_MEM_SW_DATA_t        FEC_MASK_MEM_SW_DATA;          /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  XGPN_XGFEC_FEC_ERROR_INJECT_t            FEC_ERROR_INJECT;              /* addr: 0x0000002c */
} APB1_XGPN_XGFEC_t;


/*
 * aes_plmp
 */
        
#define XGPN_AES_PLMP_GBL_CTRL                   0xd0034c00
#define XGPN_AES_PLMP_GBL_CTRL_dft               0x00000050

typedef volatile union {
  struct {
    ca_uint32_t key_len              :  5 ; /* bits 4:0 */
    ca_uint32_t msk_reg_id_src_sel   :  1 ; /* bits 5:5 */
    ca_uint32_t key_hw_mode          :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t sma_mode             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_PLMP_GBL_CTRL_t;


#define XGPN_AES_PLMP_SUBKEY_CTRL                0xd0034c04
#define XGPN_AES_PLMP_SUBKEY_CTRL_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gene_st              :  1 ; /* bits 0:0 */
    ca_uint32_t sk_sw_st             :  1 ; /* bits 1:1 */
    ca_uint32_t ik_sw_st             :  1 ; /* bits 2:2 */
    ca_uint32_t mic_k12_sw_st        :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_PLMP_SUBKEY_CTRL_t;


#define XGPN_AES_PLMP_INTERRUPT                  0xd0034c08
#define XGPN_AES_PLMP_INTERRUPT_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t req_nokey_intI       :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_PLMP_INTERRUPT_t;


#define XGPN_AES_PLMP_INTERRUPTE0                0xd0034c0c
#define XGPN_AES_PLMP_INTERRUPTE0_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t req_nokey_intIE      :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_PLMP_INTERRUPTE0_t;


#define XGPN_AES_PLMP_INTERRUPTE1                0xd0034c10
#define XGPN_AES_PLMP_INTERRUPTE1_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t req_nokey_intIE      :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_PLMP_INTERRUPTE1_t;


#define XGPN_AES_PLMP_MSK3_STS                   0xd0034c14
#define XGPN_AES_PLMP_MSK3_STS_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_PLMP_MSK3_STS_t;


#define XGPN_AES_PLMP_MSK2_STS                   0xd0034c18
#define XGPN_AES_PLMP_MSK2_STS_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_PLMP_MSK2_STS_t;


#define XGPN_AES_PLMP_MSK1_STS                   0xd0034c1c
#define XGPN_AES_PLMP_MSK1_STS_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_PLMP_MSK1_STS_t;


#define XGPN_AES_PLMP_MSK0_STS                   0xd0034c20
#define XGPN_AES_PLMP_MSK0_STS_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_PLMP_MSK0_STS_t;


#define XGPN_AES_PLMP_SK3_STS                    0xd0034c24
#define XGPN_AES_PLMP_SK3_STS_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_PLMP_SK3_STS_t;


#define XGPN_AES_PLMP_SK2_STS                    0xd0034c28
#define XGPN_AES_PLMP_SK2_STS_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_PLMP_SK2_STS_t;


#define XGPN_AES_PLMP_SK1_STS                    0xd0034c2c
#define XGPN_AES_PLMP_SK1_STS_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_PLMP_SK1_STS_t;


#define XGPN_AES_PLMP_SK0_STS                    0xd0034c30
#define XGPN_AES_PLMP_SK0_STS_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_PLMP_SK0_STS_t;


#define XGPN_AES_PLMP_IK3_STS                    0xd0034c34
#define XGPN_AES_PLMP_IK3_STS_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_PLMP_IK3_STS_t;


#define XGPN_AES_PLMP_IK2_STS                    0xd0034c38
#define XGPN_AES_PLMP_IK2_STS_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_PLMP_IK2_STS_t;


#define XGPN_AES_PLMP_IK1_STS                    0xd0034c3c
#define XGPN_AES_PLMP_IK1_STS_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_PLMP_IK1_STS_t;


#define XGPN_AES_PLMP_IK0_STS                    0xd0034c40
#define XGPN_AES_PLMP_IK0_STS_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_PLMP_IK0_STS_t;


#define XGPN_AES_PLMP_MIC3_K1_STS                0xd0034c44
#define XGPN_AES_PLMP_MIC3_K1_STS_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_PLMP_MIC3_K1_STS_t;


#define XGPN_AES_PLMP_MIC2_K1_STS                0xd0034c48
#define XGPN_AES_PLMP_MIC2_K1_STS_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_PLMP_MIC2_K1_STS_t;


#define XGPN_AES_PLMP_MIC1_K1_STS                0xd0034c4c
#define XGPN_AES_PLMP_MIC1_K1_STS_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_PLMP_MIC1_K1_STS_t;


#define XGPN_AES_PLMP_MIC0_K1_STS                0xd0034c50
#define XGPN_AES_PLMP_MIC0_K1_STS_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_PLMP_MIC0_K1_STS_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* aes_plmp */
typedef struct {
  XGPN_AES_PLMP_GBL_CTRL_t                 GBL_CTRL;                      /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  XGPN_AES_PLMP_SUBKEY_CTRL_t              SUBKEY_CTRL;                   /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  XGPN_AES_PLMP_INTERRUPT_t                INTERRUPT;                     /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  XGPN_AES_PLMP_INTERRUPTE0_t              INTERRUPTE0;                   /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  XGPN_AES_PLMP_INTERRUPTE1_t              INTERRUPTE1;                   /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  XGPN_AES_PLMP_MSK3_STS_t                 MSK3_STS;                      /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  XGPN_AES_PLMP_MSK2_STS_t                 MSK2_STS;                      /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  XGPN_AES_PLMP_MSK1_STS_t                 MSK1_STS;                      /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  XGPN_AES_PLMP_MSK0_STS_t                 MSK0_STS;                      /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  XGPN_AES_PLMP_SK3_STS_t                  SK3_STS;                       /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  XGPN_AES_PLMP_SK2_STS_t                  SK2_STS;                       /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  XGPN_AES_PLMP_SK1_STS_t                  SK1_STS;                       /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  XGPN_AES_PLMP_SK0_STS_t                  SK0_STS;                       /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  XGPN_AES_PLMP_IK3_STS_t                  IK3_STS;                       /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  XGPN_AES_PLMP_IK2_STS_t                  IK2_STS;                       /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  XGPN_AES_PLMP_IK1_STS_t                  IK1_STS;                       /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  XGPN_AES_PLMP_IK0_STS_t                  IK0_STS;                       /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  XGPN_AES_PLMP_MIC3_K1_STS_t              MIC3_K1_STS;                   /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  XGPN_AES_PLMP_MIC2_K1_STS_t              MIC2_K1_STS;                   /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  XGPN_AES_PLMP_MIC1_K1_STS_t              MIC1_K1_STS;                   /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  XGPN_AES_PLMP_MIC0_K1_STS_t              MIC0_K1_STS;                   /* addr: 0x00000050 */
} APB1_XGPN_AES_PLMP_t;


/*
 * aes
 */
        
#define XGPN_AES_UC_KEY03                        0xd0034d00
#define XGPN_AES_UC_KEY03_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key3                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_UC_KEY03_t;


#define XGPN_AES_UC_KEY02                        0xd0034d04
#define XGPN_AES_UC_KEY02_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key2                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_UC_KEY02_t;


#define XGPN_AES_UC_KEY01                        0xd0034d08
#define XGPN_AES_UC_KEY01_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_UC_KEY01_t;


#define XGPN_AES_UC_KEY00                        0xd0034d0c
#define XGPN_AES_UC_KEY00_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_UC_KEY00_t;


#define XGPN_AES_UC_KEY13                        0xd0034d10
#define XGPN_AES_UC_KEY13_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key3                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_UC_KEY13_t;


#define XGPN_AES_UC_KEY12                        0xd0034d14
#define XGPN_AES_UC_KEY12_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key2                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_UC_KEY12_t;


#define XGPN_AES_UC_KEY11                        0xd0034d18
#define XGPN_AES_UC_KEY11_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_UC_KEY11_t;


#define XGPN_AES_UC_KEY10                        0xd0034d1c
#define XGPN_AES_UC_KEY10_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_UC_KEY10_t;


#define XGPN_AES_MC_KEY03                        0xd0034d20
#define XGPN_AES_MC_KEY03_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key3                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_MC_KEY03_t;


#define XGPN_AES_MC_KEY02                        0xd0034d24
#define XGPN_AES_MC_KEY02_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key2                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_MC_KEY02_t;


#define XGPN_AES_MC_KEY01                        0xd0034d28
#define XGPN_AES_MC_KEY01_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_MC_KEY01_t;


#define XGPN_AES_MC_KEY00                        0xd0034d2c
#define XGPN_AES_MC_KEY00_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_MC_KEY00_t;


#define XGPN_AES_MC_KEY13                        0xd0034d30
#define XGPN_AES_MC_KEY13_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key3                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_MC_KEY13_t;


#define XGPN_AES_MC_KEY12                        0xd0034d34
#define XGPN_AES_MC_KEY12_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key2                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_MC_KEY12_t;


#define XGPN_AES_MC_KEY11                        0xd0034d38
#define XGPN_AES_MC_KEY11_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_MC_KEY11_t;


#define XGPN_AES_MC_KEY10                        0xd0034d3c
#define XGPN_AES_MC_KEY10_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_MC_KEY10_t;


#define XGPN_AES_INTERRUPT                       0xd0034d40
#define XGPN_AES_INTERRUPT_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t us_aescore_nofree_intI :  1 ; /* bits 0:0 */
    ca_uint32_t ds_aescore_nofree_intI :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_INTERRUPT_t;


#define XGPN_AES_INTERRUPTE0                     0xd0034d44
#define XGPN_AES_INTERRUPTE0_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t us_aescore_nofree_intIE :  1 ; /* bits 0:0 */
    ca_uint32_t ds_aescore_nofree_intIE :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_INTERRUPTE0_t;


#define XGPN_AES_INTERRUPTE1                     0xd0034d48
#define XGPN_AES_INTERRUPTE1_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t us_aescore_nofree_intIE :  1 ; /* bits 0:0 */
    ca_uint32_t ds_aescore_nofree_intIE :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_AES_INTERRUPTE1_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* aes */
typedef struct {
  XGPN_AES_UC_KEY03_t                      UC_KEY03;                      /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  XGPN_AES_UC_KEY02_t                      UC_KEY02;                      /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  XGPN_AES_UC_KEY01_t                      UC_KEY01;                      /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  XGPN_AES_UC_KEY00_t                      UC_KEY00;                      /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  XGPN_AES_UC_KEY13_t                      UC_KEY13;                      /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  XGPN_AES_UC_KEY12_t                      UC_KEY12;                      /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  XGPN_AES_UC_KEY11_t                      UC_KEY11;                      /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  XGPN_AES_UC_KEY10_t                      UC_KEY10;                      /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  XGPN_AES_MC_KEY03_t                      MC_KEY03;                      /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  XGPN_AES_MC_KEY02_t                      MC_KEY02;                      /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  XGPN_AES_MC_KEY01_t                      MC_KEY01;                      /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  XGPN_AES_MC_KEY00_t                      MC_KEY00;                      /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  XGPN_AES_MC_KEY13_t                      MC_KEY13;                      /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  XGPN_AES_MC_KEY12_t                      MC_KEY12;                      /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  XGPN_AES_MC_KEY11_t                      MC_KEY11;                      /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  XGPN_AES_MC_KEY10_t                      MC_KEY10;                      /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  XGPN_AES_INTERRUPT_t                     INTERRUPT;                     /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  XGPN_AES_INTERRUPTE0_t                   INTERRUPTE0;                   /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  XGPN_AES_INTERRUPTE1_t                   INTERRUPTE1;                   /* addr: 0x00000048 */
} APB1_XGPN_AES_t;


/*
 * rxctl
 */
        
#define XGPN_RXCTL_rx_port                       0xd0034d80
#define XGPN_RXCTL_rx_port_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t spid                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_RXCTL_rx_port_t;


#define XGPN_RXCTL_rx_pkt_ctl                    0xd0034d84
#define XGPN_RXCTL_rx_pkt_ctl_dft                0x2008007f

typedef volatile union {
  struct {
    ca_uint32_t frame_oversize_drop_en :  1 ; /* bits 0:0 */
    ca_uint32_t frame_runt_drop_en   :  1 ; /* bits 1:1 */
    ca_uint32_t frame_length_mismatch_drop_en :  1 ; /* bits 2:2 */
    ca_uint32_t frame_fcs_error_drop_en :  1 ; /* bits 3:3 */
    ca_uint32_t frame_ffoverflow_drop_en :  1 ; /* bits 4:4 */
    ca_uint32_t fragment_drop_en     :  1 ; /* bits 5:5 */
    ca_uint32_t omci_runt_drop_en    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t drop_ptp_pkt_type    : 10 ; /* bits 17:8 */
    ca_uint32_t ptp_da_en            :  1 ; /* bits 18:18 */
    ca_uint32_t ptp_mode_sel         :  1 ; /* bits 19:19 */
    ca_uint32_t ptp_ing_ts_cmp       :  5 ; /* bits 24:20 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t cripple_frame_drop_en :  1 ; /* bits 28:28 */
    ca_uint32_t omci_pad_en          :  1 ; /* bits 29:29 */
    ca_uint32_t rsrvd3               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_RXCTL_rx_pkt_ctl_t;


#define XGPN_RXCTL_ptp_lay1                      0xd0034d88
#define XGPN_RXCTL_ptp_lay1_dft                  0x81009100

typedef volatile union {
  struct {
    ca_uint32_t vlan0                : 16 ; /* bits 15:0 */
    ca_uint32_t vlan1                : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_RXCTL_ptp_lay1_t;


#define XGPN_RXCTL_ptp_lay2                      0xd0034d8c
#define XGPN_RXCTL_ptp_lay2_dft                  0x81009100

typedef volatile union {
  struct {
    ca_uint32_t vlan0                : 16 ; /* bits 15:0 */
    ca_uint32_t vlan1                : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_RXCTL_ptp_lay2_t;


#define XGPN_RXCTL_INTERRUPT                     0xd0034d90
#define XGPN_RXCTL_INTERRUPT_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t discarded_frames_msbi :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t ff_overflow          :  1 ; /* bits 8:8 */
    ca_uint32_t ing_ptp_pkt_rptI     :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd2               :  6 ;
    ca_uint32_t frame_oversize_drop  :  1 ; /* bits 16:16 */
    ca_uint32_t frame_runt_drop      :  1 ; /* bits 17:17 */
    ca_uint32_t frame_length_mismatch_drop :  1 ; /* bits 18:18 */
    ca_uint32_t frame_fcs_error_drop :  1 ; /* bits 19:19 */
    ca_uint32_t frame_ffoverflow_drop :  1 ; /* bits 20:20 */
    ca_uint32_t fragment_drop        :  1 ; /* bits 21:21 */
    ca_uint32_t omci_runt_drop       :  1 ; /* bits 22:22 */
    ca_uint32_t rsrvd3               :  9 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_RXCTL_INTERRUPT_t;


#define XGPN_RXCTL_INTERRUPTE0                   0xd0034d94
#define XGPN_RXCTL_INTERRUPTE0_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t discarded_frames_msbiE :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t ff_overflowE         :  1 ; /* bits 8:8 */
    ca_uint32_t ing_ptp_pkt_rptIE    :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd2               :  6 ;
    ca_uint32_t frame_oversize_dropE :  1 ; /* bits 16:16 */
    ca_uint32_t frame_runt_dropE     :  1 ; /* bits 17:17 */
    ca_uint32_t frame_length_mismatch_dropE :  1 ; /* bits 18:18 */
    ca_uint32_t frame_fcs_error_dropE :  1 ; /* bits 19:19 */
    ca_uint32_t frame_ffoverflow_dropE :  1 ; /* bits 20:20 */
    ca_uint32_t fragment_dropE       :  1 ; /* bits 21:21 */
    ca_uint32_t omci_runt_dropE      :  1 ; /* bits 22:22 */
    ca_uint32_t rsrvd3               :  9 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_RXCTL_INTERRUPTE0_t;


#define XGPN_RXCTL_INTERRUPTE1                   0xd0034d98
#define XGPN_RXCTL_INTERRUPTE1_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t discarded_frames_msbiE :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t ff_overflowE         :  1 ; /* bits 8:8 */
    ca_uint32_t ing_ptp_pkt_rptIE    :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd2               :  6 ;
    ca_uint32_t frame_oversize_dropE :  1 ; /* bits 16:16 */
    ca_uint32_t frame_runt_dropE     :  1 ; /* bits 17:17 */
    ca_uint32_t frame_length_mismatch_dropE :  1 ; /* bits 18:18 */
    ca_uint32_t frame_fcs_error_dropE :  1 ; /* bits 19:19 */
    ca_uint32_t frame_ffoverflow_dropE :  1 ; /* bits 20:20 */
    ca_uint32_t fragment_dropE       :  1 ; /* bits 21:21 */
    ca_uint32_t omci_runt_dropE      :  1 ; /* bits 22:22 */
    ca_uint32_t rsrvd3               :  9 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_RXCTL_INTERRUPTE1_t;


#define XGPN_RXCTL_ptp_status0                   0xd0034d9c
#define XGPN_RXCTL_ptp_status0_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ts                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_RXCTL_ptp_status0_t;


#define XGPN_RXCTL_ptp_status1                   0xd0034da0
#define XGPN_RXCTL_ptp_status1_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t type                 :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_RXCTL_ptp_status1_t;


#define XGPN_RXCTL_discarded_frames              0xd0034da4
#define XGPN_RXCTL_discarded_frames_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_RXCTL_discarded_frames_t;


#define XGPN_RXCTL_rc_status1                    0xd0034da8
#define XGPN_RXCTL_rc_status1_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rcff_pktnum          :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_RXCTL_rc_status1_t;


#define XGPN_RXCTL_rc_status2                    0xd0034dac
#define XGPN_RXCTL_rc_status2_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ff                   :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_RXCTL_rc_status2_t;


#define XGPN_RXCTL_usbg_dbg                      0xd0034db0
#define XGPN_RXCTL_usbg_dbg_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t state                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_RXCTL_usbg_dbg_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* rxctl */
typedef struct {
  XGPN_RXCTL_rx_port_t                     rx_port;                       /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  XGPN_RXCTL_rx_pkt_ctl_t                  rx_pkt_ctl;                    /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  XGPN_RXCTL_ptp_lay1_t                    ptp_lay1;                      /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  XGPN_RXCTL_ptp_lay2_t                    ptp_lay2;                      /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  XGPN_RXCTL_INTERRUPT_t                   INTERRUPT;                     /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  XGPN_RXCTL_INTERRUPTE0_t                 INTERRUPTE0;                   /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  XGPN_RXCTL_INTERRUPTE1_t                 INTERRUPTE1;                   /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  XGPN_RXCTL_ptp_status0_t                 ptp_status0;                   /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  XGPN_RXCTL_ptp_status1_t                 ptp_status1;                   /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  XGPN_RXCTL_discarded_frames_t            discarded_frames;              /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  XGPN_RXCTL_rc_status1_t                  rc_status1;                    /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  XGPN_RXCTL_rc_status2_t                  rc_status2;                    /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  XGPN_RXCTL_usbg_dbg_t                    usbg_dbg;                      /* addr: 0x00000030 */
} APB1_XGPN_RXCTL_t;


/*
 * pucif
 */
        
#define XGPN_PUCIF_CTRL                          0xd0034e00
#define XGPN_PUCIF_CTRL_dft                      0x1040a100

typedef volatile union {
  struct {
    ca_uint32_t cntr_tconid          :  5 ; /* bits 4:0 */
    ca_uint32_t cntr_tconid_en       :  1 ; /* bits 5:5 */
    ca_uint32_t cntr0_event_sel      :  3 ; /* bits 8:6 */
    ca_uint32_t cntr1_event_sel      :  3 ; /* bits 11:9 */
    ca_uint32_t cntr2_event_sel      :  3 ; /* bits 14:12 */
    ca_uint32_t single_thread        :  1 ; /* bits 15:15 */
    ca_uint32_t sch_to_threshold     : 12 ; /* bits 27:16 */
    ca_uint32_t sch_early_end        :  1 ; /* bits 28:28 */
    ca_uint32_t cntr_inccfg          :  3 ; /* bits 31:29 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PUCIF_CTRL_t;


#define XGPN_PUCIF_CNTR0                         0xd0034e04
#define XGPN_PUCIF_CNTR0_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PUCIF_CNTR0_t;


#define XGPN_PUCIF_CNTR1                         0xd0034e08
#define XGPN_PUCIF_CNTR1_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PUCIF_CNTR1_t;


#define XGPN_PUCIF_CNTR2                         0xd0034e0c
#define XGPN_PUCIF_CNTR2_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PUCIF_CNTR2_t;


#define XGPN_PUCIF_STS                           0xd0034e10
#define XGPN_PUCIF_STS_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sch_tconid           :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t data_tconid          :  5 ; /* bits 12:8 */
    ca_uint32_t data_gemid           :  7 ; /* bits 19:13 */
    ca_uint32_t rsrvd2               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PUCIF_STS_t;


#define XGPN_PUCIF_PROTECT                       0xd0034e14
#define XGPN_PUCIF_PROTECT_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pucif_hang           :  1 ; /* bits 0:0 */
    ca_uint32_t pucif_hang_tcon_id   :  5 ; /* bits 5:1 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PUCIF_PROTECT_t;


#define XGPN_PUCIF_CTRL1                         0xd0034e18
#define XGPN_PUCIF_CTRL1_dft                     0x0000003a

typedef volatile union {
  struct {
    ca_uint32_t afifo_thresh_hi      :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PUCIF_CTRL1_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* pucif */
typedef struct {
  XGPN_PUCIF_CTRL_t                        CTRL;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  XGPN_PUCIF_CNTR0_t                       CNTR0;                         /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  XGPN_PUCIF_CNTR1_t                       CNTR1;                         /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  XGPN_PUCIF_CNTR2_t                       CNTR2;                         /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  XGPN_PUCIF_STS_t                         STS;                           /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  XGPN_PUCIF_PROTECT_t                     PROTECT;                       /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  XGPN_PUCIF_CTRL1_t                       CTRL1;                         /* addr: 0x00000018 */
} APB1_XGPN_PUCIF_t;

    
  
        
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* XGPN */

typedef struct {
  APB1_XGPN_XGPN_GLB_t                     xgpn_glb;                      /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[235];                  
  APB1_XGPN_DSFP_t                         dsfp;                          /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd2[413];                  
  APB1_XGPN_USBG_t                         usbg;                          /* addr: 0x00000400 */
  ca_uint32_t                              rsrvd3[411];                  
  APB1_XGPN_BWMP_t                         bwmp;                          /* addr: 0x00000600 */
  ca_uint32_t                              rsrvd4[451];                  
  APB1_XGPN_PLMP_t                         plmp;                          /* addr: 0x00000800 */
  ca_uint32_t                              rsrvd5[411];                  
  APB1_XGPN_ACTP_t                         actp;                          /* addr: 0x00000b00 */
  ca_uint32_t                              rsrvd6[101];                  
  APB1_XGPN_XGFEC_t                        xgfec;                         /* addr: 0x00000b80 */
  ca_uint32_t                              rsrvd7[105];                  
  APB1_XGPN_AES_PLMP_t                     aes_plmp;                      /* addr: 0x00000c00 */
  ca_uint32_t                              rsrvd8[215];                  
  APB1_XGPN_AES_t                          aes;                           /* addr: 0x00000d00 */
  ca_uint32_t                              rsrvd9[91];                   
  APB1_XGPN_RXCTL_t                        rxctl;                         /* addr: 0x00000d80 */
  ca_uint32_t                              rsrvd10[103];                 
  APB1_XGPN_PUCIF_t                        pucif;                         /* addr: 0x00000e00 */
} APB1_XGPN_t;


/*
 * GPON_MAC
 */
  
/*
 * gpon
 */
        
#define GPON_MAC_GPON_ds                         0xd0036000
#define GPON_MAC_GPON_ds_dft                     0x05ee3352

typedef volatile union {
  struct {
    ca_uint32_t pre_sync_threshold   :  4 ; /* bits 3:0 */
    ca_uint32_t miss_sync_threshold  :  4 ; /* bits 7:4 */
    ca_uint32_t los_timer_threshold  :  4 ; /* bits 11:8 */
    ca_uint32_t fec_switch_threshold :  3 ; /* bits 14:12 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t max_packet_size      : 14 ; /* bits 29:16 */
    ca_uint32_t tag_exclude          :  1 ; /* bits 30:30 */
    ca_uint32_t stop_gpn_fe          :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_ds_t;


#define GPON_MAC_GPON_act                        0xd0036004
#define GPON_MAC_GPON_act_dft                    0x32013880

typedef volatile union {
  struct {
    ca_uint32_t to1_timer_threshold  : 18 ; /* bits 17:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t to2_timer_threshold  : 12 ; /* bits 31:20 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_act_t;


#define GPON_MAC_GPON_sn                         0xd0036008
#define GPON_MAC_GPON_sn_dft                     0x0000000a

typedef volatile union {
  struct {
    ca_uint32_t req_threshold        :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t rspnd_extend         :  7 ; /* bits 14:8 */
    ca_uint32_t rsrvd2               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_sn_t;


#define GPON_MAC_GPON_us                         0xd003600c
#define GPON_MAC_GPON_us_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t frame_var            :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t eqd_select           :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd2               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_us_t;


#define GPON_MAC_GPON_signal                     0xd0036010
#define GPON_MAC_GPON_signal_dft                 0x00003333

typedef volatile union {
  struct {
    ca_uint32_t fail_threshold       :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t fail_remove_threshold :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t degrade_threshold    :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t degrade_remove_threshold :  3 ; /* bits 14:12 */
    ca_uint32_t rsrvd4               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_signal_t;


#define GPON_MAC_GPON_vendor                     0xd0036014
#define GPON_MAC_GPON_vendor_dft                 0x20202020

typedef volatile union {
  struct {
    ca_uint32_t id                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_vendor_t;


#define GPON_MAC_GPON_vendor_spec                0xd0036018
#define GPON_MAC_GPON_vendor_spec_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sn                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_vendor_spec_t;


#define GPON_MAC_GPON_pfrag0                     0xd003601c
#define GPON_MAC_GPON_pfrag0_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t password             : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_pfrag0_t;


#define GPON_MAC_GPON_pfrag1                     0xd0036020
#define GPON_MAC_GPON_pfrag1_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t password             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_pfrag1_t;


#define GPON_MAC_GPON_pfrag2                     0xd0036024
#define GPON_MAC_GPON_pfrag2_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t password             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_pfrag2_t;


#define GPON_MAC_GPON_power_down                 0xd0036028
#define GPON_MAC_GPON_power_down_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t on                   :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_power_down_t;


#define GPON_MAC_GPON_ploamd_ctrl                0xd003602c
#define GPON_MAC_GPON_ploamd_ctrl_dft            0x00000001

typedef volatile union {
  struct {
    ca_uint32_t hw_key_switch        :  1 ; /* bits 0:0 */
    ca_uint32_t dying_gasp_extra     :  2 ; /* bits 2:1 */
    ca_uint32_t rsrvd1               : 13 ;
    ca_uint32_t key_index0           :  8 ; /* bits 23:16 */
    ca_uint32_t key_index1           :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_ploamd_ctrl_t;


#define GPON_MAC_GPON_key0_frag0                 0xd0036030
#define GPON_MAC_GPON_key0_frag0_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t aes                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_key0_frag0_t;


#define GPON_MAC_GPON_key0_frag1                 0xd0036034
#define GPON_MAC_GPON_key0_frag1_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t aes                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_key0_frag1_t;


#define GPON_MAC_GPON_key0_frag2                 0xd0036038
#define GPON_MAC_GPON_key0_frag2_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t aes                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_key0_frag2_t;


#define GPON_MAC_GPON_key0_frag3                 0xd003603c
#define GPON_MAC_GPON_key0_frag3_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t aes                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_key0_frag3_t;


#define GPON_MAC_GPON_key1_frag0                 0xd0036040
#define GPON_MAC_GPON_key1_frag0_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t aes                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_key1_frag0_t;


#define GPON_MAC_GPON_key1_frag1                 0xd0036044
#define GPON_MAC_GPON_key1_frag1_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t aes                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_key1_frag1_t;


#define GPON_MAC_GPON_key1_frag2                 0xd0036048
#define GPON_MAC_GPON_key1_frag2_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t aes                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_key1_frag2_t;


#define GPON_MAC_GPON_key1_frag3                 0xd003604c
#define GPON_MAC_GPON_key1_frag3_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t aes                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_key1_frag3_t;


#define GPON_MAC_GPON_override                   0xd0036050
#define GPON_MAC_GPON_override_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t onu_state            :  3 ; /* bits 2:0 */
    ca_uint32_t onu_state_override   :  1 ; /* bits 3:3 */
    ca_uint32_t onu_state_hold       :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_override_t;


#define GPON_MAC_GPON_onu_pst                    0xd0036054
#define GPON_MAC_GPON_onu_pst_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 15 ;
    ca_uint32_t line_num             :  1 ; /* bits 15:15 */
    ca_uint32_t k1                   :  8 ; /* bits 23:16 */
    ca_uint32_t k2                   :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_onu_pst_t;


#define GPON_MAC_GPON_bip_error                  0xd0036058
#define GPON_MAC_GPON_bip_error_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_bip_error_t;


#define GPON_MAC_GPON_bip_error_accum            0xd003605c
#define GPON_MAC_GPON_bip_error_accum_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_bip_error_accum_t;


#define GPON_MAC_GPON_bip_error_frame_count      0xd0036060
#define GPON_MAC_GPON_bip_error_frame_count_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_bip_error_frame_count_t;


#define GPON_MAC_GPON_ds_omci_gem                0xd0036064
#define GPON_MAC_GPON_ds_omci_gem_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_ds_omci_gem_t;


#define GPON_MAC_GPON_ds_omci_pkt                0xd0036068
#define GPON_MAC_GPON_ds_omci_pkt_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_ds_omci_pkt_t;


#define GPON_MAC_GPON_ds_pkt_crc                 0xd003606c
#define GPON_MAC_GPON_ds_pkt_crc_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_ds_pkt_crc_t;


#define GPON_MAC_GPON_ds_udrsz_pkt               0xd0036070
#define GPON_MAC_GPON_ds_udrsz_pkt_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_ds_udrsz_pkt_t;


#define GPON_MAC_GPON_ds_ovrsz_pkt               0xd0036074
#define GPON_MAC_GPON_ds_ovrsz_pkt_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_ds_ovrsz_pkt_t;


#define GPON_MAC_GPON_ploamu                     0xd0036078
#define GPON_MAC_GPON_ploamu_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sn_rdm_dly           : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t rei_seq_num          :  4 ; /* bits 19:16 */
    ca_uint32_t rsrvd2               :  4 ;
    ca_uint32_t key_pointer          :  1 ; /* bits 24:24 */
    ca_uint32_t req_key_mask         :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd3               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_ploamu_t;


#define GPON_MAC_GPON_alarm                      0xd003607c
#define GPON_MAC_GPON_alarm_dft                  0x00000003

typedef volatile union {
  struct {
    ca_uint32_t los                  :  1 ; /* bits 0:0 */
    ca_uint32_t lof                  :  1 ; /* bits 1:1 */
    ca_uint32_t sf                   :  1 ; /* bits 2:2 */
    ca_uint32_t sd                   :  1 ; /* bits 3:3 */
    ca_uint32_t lcdg                 :  1 ; /* bits 4:4 */
    ca_uint32_t tf                   :  1 ; /* bits 5:5 */
    ca_uint32_t suf                  :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t dact                 :  1 ; /* bits 8:8 */
    ca_uint32_t dis                  :  1 ; /* bits 9:9 */
    ca_uint32_t mis                  :  1 ; /* bits 10:10 */
    ca_uint32_t pee                  :  1 ; /* bits 11:11 */
    ca_uint32_t rdi                  :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd2               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_alarm_t;


#define GPON_MAC_GPON_int_sts                    0xd0036080
#define GPON_MAC_GPON_int_sts_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ploam_drop           :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_int_sts_t;


#define GPON_MAC_GPON_interrupt_top              0xd0036084
#define GPON_MAC_GPON_interrupt_top_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t INTERRUPTi           :  1 ; /* bits 0:0 */
    ca_uint32_t INTERRUPT2i          :  1 ; /* bits 1:1 */
    ca_uint32_t INTERRUPT3i          :  1 ; /* bits 2:2 */
    ca_uint32_t INTERRUPT4i          :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_interrupt_top_t;


#define GPON_MAC_GPON_int_top_en                 0xd0036088
#define GPON_MAC_GPON_int_top_en_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t INTERRUPTe           :  1 ; /* bits 0:0 */
    ca_uint32_t INTERRUPT2e          :  1 ; /* bits 1:1 */
    ca_uint32_t INTERRUPT3e          :  1 ; /* bits 2:2 */
    ca_uint32_t INTERRUPT4e          :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_int_top_en_t;


#define GPON_MAC_GPON_interrupt                  0xd003608c
#define GPON_MAC_GPON_interrupt_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t LOSi                 :  1 ; /* bits 0:0 */
    ca_uint32_t LOFi                 :  1 ; /* bits 1:1 */
    ca_uint32_t SFi                  :  1 ; /* bits 2:2 */
    ca_uint32_t SDi                  :  1 ; /* bits 3:3 */
    ca_uint32_t LCDGi                :  1 ; /* bits 4:4 */
    ca_uint32_t TFi                  :  1 ; /* bits 5:5 */
    ca_uint32_t SUFi                 :  1 ; /* bits 6:6 */
    ca_uint32_t MEMi                 :  1 ; /* bits 7:7 */
    ca_uint32_t DACTi                :  1 ; /* bits 8:8 */
    ca_uint32_t DISi                 :  1 ; /* bits 9:9 */
    ca_uint32_t MISi                 :  1 ; /* bits 10:10 */
    ca_uint32_t PEEi                 :  1 ; /* bits 11:11 */
    ca_uint32_t RDIi                 :  1 ; /* bits 12:12 */
    ca_uint32_t POPUPi               :  1 ; /* bits 13:13 */
    ca_uint32_t DS_FEC_ONi           :  1 ; /* bits 14:14 */
    ca_uint32_t DS_FEC_OFFi          :  1 ; /* bits 15:15 */
    ca_uint32_t ALLOCIDi             :  1 ; /* bits 16:16 */
    ca_uint32_t PORTIDi              :  1 ; /* bits 17:17 */
    ca_uint32_t CPLi                 :  1 ; /* bits 18:18 */
    ca_uint32_t KSWi                 :  1 ; /* bits 19:19 */
    ca_uint32_t PDROPi               :  1 ; /* bits 20:20 */
    ca_uint32_t HPLOAMUi             :  1 ; /* bits 21:21 */
    ca_uint32_t UNSYNCi              :  1 ; /* bits 22:22 */
    ca_uint32_t LF_UNDERi            :  1 ; /* bits 23:23 */
    ca_uint32_t DS_PKTi              :  1 ; /* bits 24:24 */
    ca_uint32_t DS_FRMi              :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t ONU_IDi              :  1 ; /* bits 30:30 */
    ca_uint32_t ONU_ST_CHGi          :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_interrupt_t;


#define GPON_MAC_GPON_int_en                     0xd0036090
#define GPON_MAC_GPON_int_en_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t LOSe                 :  1 ; /* bits 0:0 */
    ca_uint32_t LOFe                 :  1 ; /* bits 1:1 */
    ca_uint32_t SFe                  :  1 ; /* bits 2:2 */
    ca_uint32_t SDe                  :  1 ; /* bits 3:3 */
    ca_uint32_t LCDGe                :  1 ; /* bits 4:4 */
    ca_uint32_t TFe                  :  1 ; /* bits 5:5 */
    ca_uint32_t SUFe                 :  1 ; /* bits 6:6 */
    ca_uint32_t MEMe                 :  1 ; /* bits 7:7 */
    ca_uint32_t DACTe                :  1 ; /* bits 8:8 */
    ca_uint32_t DISe                 :  1 ; /* bits 9:9 */
    ca_uint32_t MISe                 :  1 ; /* bits 10:10 */
    ca_uint32_t PEEe                 :  1 ; /* bits 11:11 */
    ca_uint32_t RDIe                 :  1 ; /* bits 12:12 */
    ca_uint32_t POPUPe               :  1 ; /* bits 13:13 */
    ca_uint32_t DS_FEC_ONe           :  1 ; /* bits 14:14 */
    ca_uint32_t DS_FEC_OFFe          :  1 ; /* bits 15:15 */
    ca_uint32_t ALLOCIDe             :  1 ; /* bits 16:16 */
    ca_uint32_t PORTIDe              :  1 ; /* bits 17:17 */
    ca_uint32_t CPLe                 :  1 ; /* bits 18:18 */
    ca_uint32_t KSWe                 :  1 ; /* bits 19:19 */
    ca_uint32_t PDROPe               :  1 ; /* bits 20:20 */
    ca_uint32_t HPLOAMUe             :  1 ; /* bits 21:21 */
    ca_uint32_t UNSYNCe              :  1 ; /* bits 22:22 */
    ca_uint32_t LF_UNDERe            :  1 ; /* bits 23:23 */
    ca_uint32_t DS_PKTe              :  1 ; /* bits 24:24 */
    ca_uint32_t DS_FRMe              :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t ONU_IDe              :  1 ; /* bits 30:30 */
    ca_uint32_t ONU_ST_CHGe          :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_int_en_t;


#define GPON_MAC_GPON_interrupt2                 0xd0036094
#define GPON_MAC_GPON_interrupt2_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t BAD_ONU_IDi          :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t UFRAMEREQ_SECi       :  1 ; /* bits 26:26 */
    ca_uint32_t UFRAMEREQ_DEDi       :  1 ; /* bits 27:27 */
    ca_uint32_t TCPARSE_SECi         :  1 ; /* bits 28:28 */
    ca_uint32_t TCPARSE_DEDi         :  1 ; /* bits 29:29 */
    ca_uint32_t TCREQUE_SECi         :  1 ; /* bits 30:30 */
    ca_uint32_t TCREQUE_DEDi         :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_interrupt2_t;


#define GPON_MAC_GPON_int2_en                    0xd0036098
#define GPON_MAC_GPON_int2_en_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t BAD_ONU_IDe          :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t UFRAMEREQ_SECe       :  1 ; /* bits 26:26 */
    ca_uint32_t UFRAMEREQ_DEDe       :  1 ; /* bits 27:27 */
    ca_uint32_t TCPARSE_SECe         :  1 ; /* bits 28:28 */
    ca_uint32_t TCPARSE_DEDe         :  1 ; /* bits 29:29 */
    ca_uint32_t TCREQUE_SECe         :  1 ; /* bits 30:30 */
    ca_uint32_t TCREQUE_DEDe         :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_int2_en_t;


#define GPON_MAC_GPON_interrupt3                 0xd003609c
#define GPON_MAC_GPON_interrupt3_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t LOSi                 :  1 ; /* bits 0:0 */
    ca_uint32_t LOFi                 :  1 ; /* bits 1:1 */
    ca_uint32_t SFi                  :  1 ; /* bits 2:2 */
    ca_uint32_t SDi                  :  1 ; /* bits 3:3 */
    ca_uint32_t LCDGi                :  1 ; /* bits 4:4 */
    ca_uint32_t TFi                  :  1 ; /* bits 5:5 */
    ca_uint32_t SUFi                 :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t DACTi                :  1 ; /* bits 8:8 */
    ca_uint32_t DISi                 :  1 ; /* bits 9:9 */
    ca_uint32_t MISi                 :  1 ; /* bits 10:10 */
    ca_uint32_t PEEi                 :  1 ; /* bits 11:11 */
    ca_uint32_t RDIi                 :  1 ; /* bits 12:12 */
    ca_uint32_t bwmap_corrected_biterr_msbi :  1 ; /* bits 13:13 */
    ca_uint32_t BWMAP_HWDONEi        :  1 ; /* bits 14:14 */
    ca_uint32_t ds_ovrsz_pkt_msbi    :  1 ; /* bits 15:15 */
    ca_uint32_t ds_udrsz_pkt_msbi    :  1 ; /* bits 16:16 */
    ca_uint32_t ds_pkt_crc_msbi      :  1 ; /* bits 17:17 */
    ca_uint32_t ds_omci_pkt_msbi     :  1 ; /* bits 18:18 */
    ca_uint32_t ds_omci_gem_msbi     :  1 ; /* bits 19:19 */
    ca_uint32_t bip_error_accum_msbi :  1 ; /* bits 20:20 */
    ca_uint32_t bip_error_frame_count_msbi :  1 ; /* bits 21:21 */
    ca_uint32_t plend_biterr_msbi    :  1 ; /* bits 22:22 */
    ca_uint32_t plend_err_msbi       :  1 ; /* bits 23:23 */
    ca_uint32_t omci_crc_msbi        :  1 ; /* bits 24:24 */
    ca_uint32_t bwmap_uncorrected_biterr_msbi :  1 ; /* bits 25:25 */
    ca_uint32_t o5_msbi              :  1 ; /* bits 26:26 */
    ca_uint32_t gem_frag_drop_msbi   :  1 ; /* bits 27:27 */
    ca_uint32_t gem_one_biterr_msbi  :  1 ; /* bits 28:28 */
    ca_uint32_t gem_two_biterr_msbi  :  1 ; /* bits 29:29 */
    ca_uint32_t gem_uncorrected_biterr_msbi :  1 ; /* bits 30:30 */
    ca_uint32_t bwmap_drop_msbi      :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_interrupt3_t;


#define GPON_MAC_GPON_int3_en                    0xd00360a0
#define GPON_MAC_GPON_int3_en_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t LOSe                 :  1 ; /* bits 0:0 */
    ca_uint32_t LOFe                 :  1 ; /* bits 1:1 */
    ca_uint32_t SFe                  :  1 ; /* bits 2:2 */
    ca_uint32_t SDe                  :  1 ; /* bits 3:3 */
    ca_uint32_t LCDGe                :  1 ; /* bits 4:4 */
    ca_uint32_t TFe                  :  1 ; /* bits 5:5 */
    ca_uint32_t SUFe                 :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t DACTe                :  1 ; /* bits 8:8 */
    ca_uint32_t DISe                 :  1 ; /* bits 9:9 */
    ca_uint32_t MISe                 :  1 ; /* bits 10:10 */
    ca_uint32_t PEEe                 :  1 ; /* bits 11:11 */
    ca_uint32_t RDIe                 :  1 ; /* bits 12:12 */
    ca_uint32_t bwmap_corrected_biterr_msbe :  1 ; /* bits 13:13 */
    ca_uint32_t BWMAP_HWDONEe        :  1 ; /* bits 14:14 */
    ca_uint32_t ds_ovrsz_pkt_msbe    :  1 ; /* bits 15:15 */
    ca_uint32_t ds_udrsz_pkt_msbe    :  1 ; /* bits 16:16 */
    ca_uint32_t ds_pkt_crc_msbe      :  1 ; /* bits 17:17 */
    ca_uint32_t ds_omci_pkt_msbe     :  1 ; /* bits 18:18 */
    ca_uint32_t ds_omci_gem_msbe     :  1 ; /* bits 19:19 */
    ca_uint32_t bip_error_accum_msbe :  1 ; /* bits 20:20 */
    ca_uint32_t bip_error_frame_count_msbe :  1 ; /* bits 21:21 */
    ca_uint32_t plend_biterr_msbe    :  1 ; /* bits 22:22 */
    ca_uint32_t plend_err_msbe       :  1 ; /* bits 23:23 */
    ca_uint32_t omci_crc_msbe        :  1 ; /* bits 24:24 */
    ca_uint32_t bwmap_uncorrected_biterr_msbe :  1 ; /* bits 25:25 */
    ca_uint32_t o5_msbe              :  1 ; /* bits 26:26 */
    ca_uint32_t gem_frag_drop_msbe   :  1 ; /* bits 27:27 */
    ca_uint32_t gem_one_biterr_msbe  :  1 ; /* bits 28:28 */
    ca_uint32_t gem_two_biterr_msbe  :  1 ; /* bits 29:29 */
    ca_uint32_t gem_uncorrected_biterr_msbe :  1 ; /* bits 30:30 */
    ca_uint32_t bwmap_drop_msbe      :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_int3_en_t;


#define GPON_MAC_GPON_interrupt4                 0xd00360a4
#define GPON_MAC_GPON_interrupt4_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t fec_corr_blk_cntmsbi :  1 ; /* bits 0:0 */
    ca_uint32_t fec_uncorr_blk_cntmsbi :  1 ; /* bits 1:1 */
    ca_uint32_t fec_noerr_blk_cntmsbi :  1 ; /* bits 2:2 */
    ca_uint32_t fec_tot_blk_cntmsbi  :  1 ; /* bits 3:3 */
    ca_uint32_t fec_corr_byt_cntmsbi :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_interrupt4_t;


#define GPON_MAC_GPON_int4_en                    0xd00360a8
#define GPON_MAC_GPON_int4_en_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t fec_corr_blk_cntmsbe :  1 ; /* bits 0:0 */
    ca_uint32_t fec_uncorr_blk_cntmsbe :  1 ; /* bits 1:1 */
    ca_uint32_t fec_noerr_blk_cntmsbe :  1 ; /* bits 2:2 */
    ca_uint32_t fec_tot_blk_cntmsbe  :  1 ; /* bits 3:3 */
    ca_uint32_t fec_corr_byt_cntmsbe :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_int4_en_t;


#define GPON_MAC_GPON_bits                       0xd00360ac
#define GPON_MAC_GPON_bits_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t guard                :  8 ; /* bits 7:0 */
    ca_uint32_t t1_preamble          :  8 ; /* bits 15:8 */
    ca_uint32_t t2_preamble          :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_bits_t;


#define GPON_MAC_GPON_pattern                    0xd00360b0
#define GPON_MAC_GPON_pattern_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t t3_preamble          :  8 ; /* bits 7:0 */
    ca_uint32_t delimiter            : 24 ; /* bits 31:8 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_pattern_t;


#define GPON_MAC_GPON_sn_acquire                 0xd00360b4
#define GPON_MAC_GPON_sn_acquire_dft             0x00000002

typedef volatile union {
  struct {
    ca_uint32_t mask_en              :  1 ; /* bits 0:0 */
    ca_uint32_t en                   :  1 ; /* bits 1:1 */
    ca_uint32_t extra                :  2 ; /* bits 3:2 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_sn_acquire_t;


#define GPON_MAC_GPON_pre_assign                 0xd00360b8
#define GPON_MAC_GPON_pre_assign_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t eqd                  : 16 ; /* bits 15:0 */
    ca_uint32_t eqd_en               :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_pre_assign_t;


#define GPON_MAC_GPON_onu                        0xd00360bc
#define GPON_MAC_GPON_onu_dft                    0x000000ff

typedef volatile union {
  struct {
    ca_uint32_t id                   :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t state                :  3 ; /* bits 18:16 */
    ca_uint32_t rsrvd2               :  5 ;
    ca_uint32_t gpn_fe_mask          :  1 ; /* bits 24:24 */
    ca_uint32_t rsrvd3               :  3 ;
    ca_uint32_t power_level          :  2 ; /* bits 29:28 */
    ca_uint32_t rsrvd4               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_onu_t;


#define GPON_MAC_GPON_main                       0xd00360c0
#define GPON_MAC_GPON_main_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t eqd                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_main_t;


#define GPON_MAC_GPON_protection                 0xd00360c4
#define GPON_MAC_GPON_protection_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t eqd                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_protection_t;


#define GPON_MAC_GPON_omci_port                  0xd00360c8
#define GPON_MAC_GPON_omci_port_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t id                   : 12 ; /* bits 11:0 */
    ca_uint32_t en                   :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd1               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_omci_port_t;


#define GPON_MAC_GPON_olt_pst                    0xd00360cc
#define GPON_MAC_GPON_olt_pst_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 15 ;
    ca_uint32_t line_num             :  1 ; /* bits 15:15 */
    ca_uint32_t k1                   :  8 ; /* bits 23:16 */
    ca_uint32_t k2                   :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_olt_pst_t;


#define GPON_MAC_GPON_ber                        0xd00360d0
#define GPON_MAC_GPON_ber_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t interval             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_ber_t;


#define GPON_MAC_GPON_key_switching              0xd00360d4
#define GPON_MAC_GPON_key_switching_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t time                 : 30 ; /* bits 29:0 */
    ca_uint32_t rsrvd1               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_key_switching_t;


#define GPON_MAC_GPON_t3_preamble                0xd00360d8
#define GPON_MAC_GPON_t3_preamble_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pre_range            :  8 ; /* bits 7:0 */
    ca_uint32_t ranged               :  8 ; /* bits 15:8 */
    ca_uint32_t extend               :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_t3_preamble_t;


#define GPON_MAC_GPON_superframe                 0xd00360dc
#define GPON_MAC_GPON_superframe_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t counter              : 30 ; /* bits 29:0 */
    ca_uint32_t rsrvd1               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_superframe_t;


#define GPON_MAC_GPON_hi_ploamu                  0xd00360e0
#define GPON_MAC_GPON_hi_ploamu_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t req                  :  1 ; /* bits 0:0 */
    ca_uint32_t reqd                 :  1 ; /* bits 1:1 */
    ca_uint32_t reqd_ignore_state    :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_hi_ploamu_t;


#define GPON_MAC_GPON_hi_ploamu0                 0xd00360e4
#define GPON_MAC_GPON_hi_ploamu0_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t message              :  8 ; /* bits 7:0 */
    ca_uint32_t onu                  :  8 ; /* bits 15:8 */
    ca_uint32_t data                 : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_hi_ploamu0_t;


#define GPON_MAC_GPON_hi_ploamu1                 0xd00360e8
#define GPON_MAC_GPON_hi_ploamu1_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_hi_ploamu1_t;


#define GPON_MAC_GPON_hi_ploamu2                 0xd00360ec
#define GPON_MAC_GPON_hi_ploamu2_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_hi_ploamu2_t;


#define GPON_MAC_GPON_panic                      0xd00360f0
#define GPON_MAC_GPON_panic_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t enable               : 11 ; /* bits 10:0 */
    ca_uint32_t rsrvd1               : 20 ;
    ca_uint32_t state                :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_panic_t;


#define GPON_MAC_GPON_PLOAMD_FF_CTL              0xd00360f4
#define GPON_MAC_GPON_PLOAMD_FF_CTL_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pop                  :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_PLOAMD_FF_CTL_t;


#define GPON_MAC_GPON_PLOAMD_FIFO3               0xd00360f8
#define GPON_MAC_GPON_PLOAMD_FIFO3_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data3                :  8 ; /* bits 7:0 */
    ca_uint32_t entry3               :  7 ; /* bits 14:8 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_PLOAMD_FIFO3_t;


#define GPON_MAC_GPON_PLOAMD_FIFO2               0xd00360fc
#define GPON_MAC_GPON_PLOAMD_FIFO2_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data2                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_PLOAMD_FIFO2_t;


#define GPON_MAC_GPON_PLOAMD_FIFO1               0xd0036100
#define GPON_MAC_GPON_PLOAMD_FIFO1_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data1                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_PLOAMD_FIFO1_t;


#define GPON_MAC_GPON_PLOAMD_FIFO0               0xd0036104
#define GPON_MAC_GPON_PLOAMD_FIFO0_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data0                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_PLOAMD_FIFO0_t;


#define GPON_MAC_GPON_PLOAMU_STS2                0xd0036108
#define GPON_MAC_GPON_PLOAMU_STS2_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t message2             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_PLOAMU_STS2_t;


#define GPON_MAC_GPON_PLOAMU_STS1                0xd003610c
#define GPON_MAC_GPON_PLOAMU_STS1_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t message1             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_PLOAMU_STS1_t;


#define GPON_MAC_GPON_PLOAMU_STS0                0xd0036110
#define GPON_MAC_GPON_PLOAMU_STS0_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t message0             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_PLOAMU_STS0_t;


#define GPON_MAC_GPON_onu_ctl                    0xd0036114
#define GPON_MAC_GPON_onu_ctl_dft                0x00460060

typedef volatile union {
  struct {
    ca_uint32_t no_up                :  1 ; /* bits 0:0 */
    ca_uint32_t en                   :  1 ; /* bits 1:1 */
    ca_uint32_t stop                 :  1 ; /* bits 2:2 */
    ca_uint32_t omcc_padding         :  1 ; /* bits 3:3 */
    ca_uint32_t dpath_rst            :  1 ; /* bits 4:4 */
    ca_uint32_t aes_en               :  1 ; /* bits 5:5 */
    ca_uint32_t ploam_crc_en         :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t pm_mode              :  2 ; /* bits 9:8 */
    ca_uint32_t plen_match           :  1 ; /* bits 10:10 */
    ca_uint32_t stop_us_wr           :  1 ; /* bits 11:11 */
    ca_uint32_t stop_hw_plu          :  1 ; /* bits 12:12 */
    ca_uint32_t sleep_mode           :  2 ; /* bits 14:13 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t sch_lead_time        : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_onu_ctl_t;


#define GPON_MAC_GPON_onu_cfg                    0xd0036118
#define GPON_MAC_GPON_onu_cfg_dft                0x00000780

typedef volatile union {
  struct {
    ca_uint32_t omci_crc_dis         :  1 ; /* bits 0:0 */
    ca_uint32_t us_scramb_dis        :  1 ; /* bits 1:1 */
    ca_uint32_t ds_scramb_dis        :  1 ; /* bits 2:2 */
    ca_uint32_t dbru_blk_size        :  3 ; /* bits 5:3 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t laser_pre_bias       :  5 ; /* bits 11:7 */
    ca_uint32_t laser_on             :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t plmd_ff_wr_ext       :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd3               :  7 ;
    ca_uint32_t laser_on_align       :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_onu_cfg_t;


#define GPON_MAC_GPON_ploamd_disable             0xd003611c
#define GPON_MAC_GPON_ploamd_disable_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mask                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_ploamd_disable_t;


#define GPON_MAC_GPON_ploamd_fifo_wr             0xd0036120
#define GPON_MAC_GPON_ploamd_fifo_wr_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mask                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_ploamd_fifo_wr_t;


#define GPON_MAC_GPON_ploamu_disable             0xd0036124
#define GPON_MAC_GPON_ploamu_disable_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mask                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_ploamu_disable_t;


#define GPON_MAC_GPON_DS_PROCESS                 0xd0036128
#define GPON_MAC_GPON_DS_PROCESS_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t cfm_check_da         :  1 ; /* bits 8:8 */
    ca_uint32_t ptp_check_da         :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t cfm_en               :  4 ; /* bits 15:12 */
    ca_uint32_t ptp_en               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_DS_PROCESS_t;


#define GPON_MAC_GPON_TCONT_ACCESS               0xd003612c
#define GPON_MAC_GPON_TCONT_ACCESS_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t alloc_id             : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t sw_plm_en            :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd2               : 13 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_TCONT_ACCESS_t;


#define GPON_MAC_GPON_TCONT_DATA                 0xd0036130
#define GPON_MAC_GPON_TCONT_DATA_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ploam_en             :  1 ; /* bits 0:0 */
    ca_uint32_t omci_en              :  1 ; /* bits 1:1 */
    ca_uint32_t index                :  4 ; /* bits 5:2 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_TCONT_DATA_t;


#define GPON_MAC_GPON_DS_GEM_PORT_ACCESS         0xd0036134
#define GPON_MAC_GPON_DS_GEM_PORT_ACCESS_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t id                   : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t sw_aes               :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd2               : 13 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_DS_GEM_PORT_ACCESS_t;


#define GPON_MAC_GPON_DS_GEM_PORT_DATA           0xd0036138
#define GPON_MAC_GPON_DS_GEM_PORT_DATA_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vld                  :  1 ; /* bits 0:0 */
    ca_uint32_t aes                  :  1 ; /* bits 1:1 */
    ca_uint32_t tdm                  :  1 ; /* bits 2:2 */
    ca_uint32_t index                :  6 ; /* bits 8:3 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_DS_GEM_PORT_DATA_t;


#define GPON_MAC_GPON_DS_PORT_ACCESS             0xd003613c
#define GPON_MAC_GPON_DS_PORT_ACCESS_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t index                :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_DS_PORT_ACCESS_t;


#define GPON_MAC_GPON_DS_PORT_DATA3              0xd0036140
#define GPON_MAC_GPON_DS_PORT_DATA3_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bcnt                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_DS_PORT_DATA3_t;


#define GPON_MAC_GPON_DS_PORT_DATA2              0xd0036144
#define GPON_MAC_GPON_DS_PORT_DATA2_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bcnt                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_DS_PORT_DATA2_t;


#define GPON_MAC_GPON_DS_PORT_DATA1              0xd0036148
#define GPON_MAC_GPON_DS_PORT_DATA1_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t fcnt                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_DS_PORT_DATA1_t;


#define GPON_MAC_GPON_DS_PORT_DATA0              0xd003614c
#define GPON_MAC_GPON_DS_PORT_DATA0_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pcnt                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_DS_PORT_DATA0_t;


#define GPON_MAC_GPON_US_MIB_ACCESS              0xd0036150
#define GPON_MAC_GPON_US_MIB_ACCESS_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sel                  :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 21 ;
    ca_uint32_t op_code              :  2 ; /* bits 29:28 */
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_US_MIB_ACCESS_t;

#define     sel_GEM0PktCnt                                0x0
#define     sel_GEM1PktCnt                                0x1
#define     sel_GEM2PktCnt                                0x2
#define     sel_GEM3PktCnt                                0x3
#define     sel_GEM4PktCnt                                0x4
#define     sel_GEM5PktCnt                                0x5
#define     sel_GEM6PktCnt                                0x6
#define     sel_GEM7PktCnt                                0x7
#define     sel_GEM8PktCnt                                0x8
#define     sel_GEM9PktCnt                                0x9
#define     sel_GEM10PktCnt                               0xa
#define     sel_GEM11PktCnt                               0xb
#define     sel_GEM12PktCnt                               0xc
#define     sel_GEM13PktCnt                               0xd
#define     sel_GEM14PktCnt                               0xe
#define     sel_GEM15PktCnt                               0xf
#define     sel_GEM16PktCnt                               0x10
#define     sel_GEM17PktCnt                               0x11
#define     sel_GEM18PktCnt                               0x12
#define     sel_GEM19PktCnt                               0x13
#define     sel_GEM20PktCnt                               0x14
#define     sel_GEM21PktCnt                               0x15
#define     sel_GEM22PktCnt                               0x16
#define     sel_GEM23PktCnt                               0x17
#define     sel_GEM24PktCnt                               0x18
#define     sel_GEM25PktCnt                               0x19
#define     sel_GEM26PktCnt                               0x1a
#define     sel_GEM27PktCnt                               0x1b
#define     sel_GEM28PktCnt                               0x1c
#define     sel_GEM29PktCnt                               0x1d
#define     sel_GEM30PktCnt                               0x1e
#define     sel_GEM31PktCnt                               0x1f
#define     sel_GEM32PktCnt                               0x20
#define     sel_GEM33PktCnt                               0x21
#define     sel_GEM34PktCnt                               0x22
#define     sel_GEM35PktCnt                               0x23
#define     sel_GEM36PktCnt                               0x24
#define     sel_GEM37PktCnt                               0x25
#define     sel_GEM38PktCnt                               0x26
#define     sel_GEM39PktCnt                               0x27
#define     sel_GEM40PktCnt                               0x28
#define     sel_GEM41PktCnt                               0x29
#define     sel_GEM42PktCnt                               0x2a
#define     sel_GEM43PktCnt                               0x2b
#define     sel_GEM44PktCnt                               0x2c
#define     sel_GEM45PktCnt                               0x2d
#define     sel_GEM46PktCnt                               0x2e
#define     sel_GEM47PktCnt                               0x2f
#define     sel_GEM48PktCnt                               0x30
#define     sel_GEM49PktCnt                               0x31
#define     sel_GEM50PktCnt                               0x32
#define     sel_GEM51PktCnt                               0x33
#define     sel_GEM52PktCnt                               0x34
#define     sel_GEM53PktCnt                               0x35
#define     sel_GEM54PktCnt                               0x36
#define     sel_GEM55PktCnt                               0x37
#define     sel_GEM56PktCnt                               0x38
#define     sel_GEM57PktCnt                               0x39
#define     sel_GEM58PktCnt                               0x3a
#define     sel_GEM59PktCnt                               0x3b
#define     sel_GEM60PktCnt                               0x3c
#define     sel_GEM61PktCnt                               0x3d
#define     sel_GEM62PktCnt                               0x3e
#define     sel_GEM63PktCnt                               0x3f
#define     sel_OMCCellCnt                                0x40
#define     sel_Tct0PktCnt                                0x41
#define     sel_Tct1PktCnt                                0x42
#define     sel_Tct2PktCnt                                0x43
#define     sel_Tct3PktCnt                                0x44
#define     sel_Tct4PktCnt                                0x45
#define     sel_Tct5PktCnt                                0x46
#define     sel_Tct6PktCnt                                0x47
#define     sel_Tct7PktCnt                                0x48
#define     sel_Tct8PktCnt                                0x49
#define     sel_Tct0IdleCnt                               0x4a
#define     sel_Tct1IdleCnt                               0x4b
#define     sel_Tct2IdleCnt                               0x4c
#define     sel_Tct3IdleCnt                               0x4d
#define     sel_Tct4IdleCnt                               0x4e
#define     sel_Tct5IdleCnt                               0x4f
#define     sel_Tct6IdleCnt                               0x50
#define     sel_Tct7IdleCnt                               0x51
#define     sel_Tct8IdleCnt                               0x52

#define GPON_MAC_GPON_US_MIB_DATA2               0xd0036154
#define GPON_MAC_GPON_US_MIB_DATA2_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bcnt                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_US_MIB_DATA2_t;


#define GPON_MAC_GPON_US_MIB_DATA1               0xd0036158
#define GPON_MAC_GPON_US_MIB_DATA1_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bcnt                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_US_MIB_DATA1_t;


#define GPON_MAC_GPON_US_MIB_DATA0               0xd003615c
#define GPON_MAC_GPON_US_MIB_DATA0_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t fcnt                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_US_MIB_DATA0_t;


#define GPON_MAC_GPON_PLM_MIB_ACCESS             0xd0036160
#define GPON_MAC_GPON_PLM_MIB_ACCESS_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sel                  : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 18 ;
    ca_uint32_t op_code              :  2 ; /* bits 29:28 */
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_PLM_MIB_ACCESS_t;

#define     sel_PLMuID00Cnt                               0x0
#define     sel_PLMuIDffCnt                               0xff
#define     sel_PLMdID00Cnt                               0x100
#define     sel_PLMdIDffCnt                               0x1ff
#define     sel_PLMdCRCERRCnt                             0x200

#define GPON_MAC_GPON_PLM_MIB_DATA               0xd0036164
#define GPON_MAC_GPON_PLM_MIB_DATA_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_PLM_MIB_DATA_t;


#define GPON_MAC_GPON_MIB_INIT                   0xd0036168
#define GPON_MAC_GPON_MIB_INIT_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t us                   :  1 ; /* bits 0:0 */
    ca_uint32_t ds                   :  1 ; /* bits 1:1 */
    ca_uint32_t plm                  :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_MIB_INIT_t;


#define GPON_MAC_GPON_US_PORT_ID_ACCESS          0xd003616c
#define GPON_MAC_GPON_US_PORT_ID_ACCESS_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t index                :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_US_PORT_ID_ACCESS_t;


#define GPON_MAC_GPON_US_PORT_ID_DATA            0xd0036170
#define GPON_MAC_GPON_US_PORT_ID_DATA_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t id                   : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_US_PORT_ID_DATA_t;


#define GPON_MAC_GPON_bwmap_ctl                  0xd0036174
#define GPON_MAC_GPON_bwmap_ctl_dft              0x00000004

typedef volatile union {
  struct {
    ca_uint32_t enable               :  1 ; /* bits 0:0 */
    ca_uint32_t mode                 :  1 ; /* bits 1:1 */
    ca_uint32_t hwdone               :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t count                :  7 ; /* bits 14:8 */
    ca_uint32_t rsrvd2               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_bwmap_ctl_t;


#define GPON_MAC_GPON_bwmap_data0                0xd0036178
#define GPON_MAC_GPON_bwmap_data0_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_bwmap_data0_t;


#define GPON_MAC_GPON_bwmap_data1                0xd003617c
#define GPON_MAC_GPON_bwmap_data1_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_bwmap_data1_t;


#define GPON_MAC_GPON_up                         0xd0036180
#define GPON_MAC_GPON_up_dft                     0x0000f000

typedef volatile union {
  struct {
    ca_uint32_t gpf_low_threshold    :  8 ; /* bits 7:0 */
    ca_uint32_t gpf_high_threshold   :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_up_t;


#define GPON_MAC_GPON_o5                         0xd0036184
#define GPON_MAC_GPON_o5_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t count                : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_o5_t;


#define GPON_MAC_GPON_gem_frag_drop              0xd0036188
#define GPON_MAC_GPON_gem_frag_drop_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t count                : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_gem_frag_drop_t;


#define GPON_MAC_GPON_gem_one_biterr             0xd003618c
#define GPON_MAC_GPON_gem_one_biterr_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t count                : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_gem_one_biterr_t;


#define GPON_MAC_GPON_gem_two_biterr             0xd0036190
#define GPON_MAC_GPON_gem_two_biterr_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t count                : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_gem_two_biterr_t;


#define GPON_MAC_GPON_gem_uncorrected_biterr     0xd0036194
#define GPON_MAC_GPON_gem_uncorrected_biterr_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t count                : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_gem_uncorrected_biterr_t;


#define GPON_MAC_GPON_bwmap_drop                 0xd0036198
#define GPON_MAC_GPON_bwmap_drop_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t count                : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_bwmap_drop_t;


#define GPON_MAC_GPON_omci_crc                   0xd003619c
#define GPON_MAC_GPON_omci_crc_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t count                : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_omci_crc_t;


#define GPON_MAC_GPON_plend_err                  0xd00361a0
#define GPON_MAC_GPON_plend_err_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t count                : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_plend_err_t;


#define GPON_MAC_GPON_plend_biterr               0xd00361a4
#define GPON_MAC_GPON_plend_biterr_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t count                : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_plend_biterr_t;


#define GPON_MAC_GPON_ds_asmbl_fifo_drop_cnt     0xd00361a8
#define GPON_MAC_GPON_ds_asmbl_fifo_drop_cnt_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t drop_cnt             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_ds_asmbl_fifo_drop_cnt_t;


#define GPON_MAC_GPON_bypass                     0xd00361ac
#define GPON_MAC_GPON_bypass_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t omci_cos             :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t omci_dpid            :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t ptp_cos              :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t ptp_dpid             :  3 ; /* bits 14:12 */
    ca_uint32_t rsrvd4               :  1 ;
    ca_uint32_t sw_cos               :  3 ; /* bits 18:16 */
    ca_uint32_t rsrvd5               :  1 ;
    ca_uint32_t sw_dpid              :  3 ; /* bits 22:20 */
    ca_uint32_t rsrvd6               :  1 ;
    ca_uint32_t sw_en                :  1 ; /* bits 24:24 */
    ca_uint32_t rsrvd7               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_bypass_t;


#define GPON_MAC_GPON_sw_dbru                    0xd00361b0
#define GPON_MAC_GPON_sw_dbru_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 16 ; /* bits 15:0 */
    ca_uint32_t enble                :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 13 ;
    ca_uint32_t tcon_residue_en      :  1 ; /* bits 30:30 */
    ca_uint32_t bufocc_mode          :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_sw_dbru_t;


#define GPON_MAC_GPON_scratch                    0xd00361b4
#define GPON_MAC_GPON_scratch_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t scratch              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_scratch_t;


#define GPON_MAC_GPON_DBRU_BUFOCC_TBL_ACCESS     0xd00361b8
#define GPON_MAC_GPON_DBRU_BUFOCC_TBL_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Addr                 :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 12 ;
    ca_uint32_t Select               :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd2               : 13 ;
    ca_uint32_t rw                   :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_DBRU_BUFOCC_TBL_ACCESS_t;


#define GPON_MAC_GPON_DBRU_BUFOCC_TBL_DATA       0xd00361bc
#define GPON_MAC_GPON_DBRU_BUFOCC_TBL_DATA_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t BufOcc               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_DBRU_BUFOCC_TBL_DATA_t;


#define GPON_MAC_GPON_CTRL                       0xd00361c0
#define GPON_MAC_GPON_CTRL_dft                   0x00400000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t mapper_contiguous_frame_no_wait_stt :  1 ; /* bits 22:22 */
    ca_uint32_t mapper_frame_no_wait_stt :  1 ; /* bits 23:23 */
    ca_uint32_t flush_id             :  4 ; /* bits 27:24 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t flush_en             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_CTRL_t;


#define GPON_MAC_GPON_SUPER_FRAME_MATCH_VAL      0xd00361c4
#define GPON_MAC_GPON_SUPER_FRAME_MATCH_VAL_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sfc                  : 30 ; /* bits 29:0 */
    ca_uint32_t rsrvd1               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_SUPER_FRAME_MATCH_VAL_t;


#define GPON_MAC_GPON_DEBUG_CTRL                 0xd00361c8
#define GPON_MAC_GPON_DEBUG_CTRL_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sel                  :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_DEBUG_CTRL_t;


#define GPON_MAC_GPON_DEBUG_STATUS0              0xd00361cc
#define GPON_MAC_GPON_DEBUG_STATUS0_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_DEBUG_STATUS0_t;


#define GPON_MAC_GPON_DEBUG_STATUS1              0xd00361d0
#define GPON_MAC_GPON_DEBUG_STATUS1_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_DEBUG_STATUS1_t;


#define GPON_MAC_GPON_bwmap_uncorrected_biterr   0xd00361d4
#define GPON_MAC_GPON_bwmap_uncorrected_biterr_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t count                : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_bwmap_uncorrected_biterr_t;


#define GPON_MAC_GPON_bwmap_corrected_biterr     0xd00361d8
#define GPON_MAC_GPON_bwmap_corrected_biterr_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t count                : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_GPON_bwmap_corrected_biterr_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* gpon */
typedef struct {
  GPON_MAC_GPON_ds_t                       ds;                            /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  GPON_MAC_GPON_act_t                      act;                           /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  GPON_MAC_GPON_sn_t                       sn;                            /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  GPON_MAC_GPON_us_t                       us;                            /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  GPON_MAC_GPON_signal_t                   signal;                        /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  GPON_MAC_GPON_vendor_t                   vendor;                        /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  GPON_MAC_GPON_vendor_spec_t              vendor_spec;                   /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  GPON_MAC_GPON_pfrag0_t                   pfrag0;                        /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  GPON_MAC_GPON_pfrag1_t                   pfrag1;                        /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  GPON_MAC_GPON_pfrag2_t                   pfrag2;                        /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  GPON_MAC_GPON_power_down_t               power_down;                    /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  GPON_MAC_GPON_ploamd_ctrl_t              ploamd_ctrl;                   /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  GPON_MAC_GPON_key0_frag0_t               key0_frag0;                    /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  GPON_MAC_GPON_key0_frag1_t               key0_frag1;                    /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  GPON_MAC_GPON_key0_frag2_t               key0_frag2;                    /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  GPON_MAC_GPON_key0_frag3_t               key0_frag3;                    /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  GPON_MAC_GPON_key1_frag0_t               key1_frag0;                    /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  GPON_MAC_GPON_key1_frag1_t               key1_frag1;                    /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  GPON_MAC_GPON_key1_frag2_t               key1_frag2;                    /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  GPON_MAC_GPON_key1_frag3_t               key1_frag3;                    /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  GPON_MAC_GPON_override_t                 override;                      /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  GPON_MAC_GPON_onu_pst_t                  onu_pst;                       /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  GPON_MAC_GPON_bip_error_t                bip_error;                     /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  GPON_MAC_GPON_bip_error_accum_t          bip_error_accum;               /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  GPON_MAC_GPON_bip_error_frame_count_t    bip_error_frame_count;         /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  GPON_MAC_GPON_ds_omci_gem_t              ds_omci_gem;                   /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  GPON_MAC_GPON_ds_omci_pkt_t              ds_omci_pkt;                   /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  GPON_MAC_GPON_ds_pkt_crc_t               ds_pkt_crc;                    /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  GPON_MAC_GPON_ds_udrsz_pkt_t             ds_udrsz_pkt;                  /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  GPON_MAC_GPON_ds_ovrsz_pkt_t             ds_ovrsz_pkt;                  /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  GPON_MAC_GPON_ploamu_t                   ploamu;                        /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  GPON_MAC_GPON_alarm_t                    alarm;                         /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  GPON_MAC_GPON_int_sts_t                  int_sts;                       /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  GPON_MAC_GPON_interrupt_top_t            interrupt_top;                 /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  GPON_MAC_GPON_int_top_en_t               int_top_en;                    /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  GPON_MAC_GPON_interrupt_t                interrupt;                     /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  GPON_MAC_GPON_int_en_t                   int_en;                        /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  GPON_MAC_GPON_interrupt2_t               interrupt2;                    /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  GPON_MAC_GPON_int2_en_t                  int2_en;                       /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];                   
  GPON_MAC_GPON_interrupt3_t               interrupt3;                    /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];                   
  GPON_MAC_GPON_int3_en_t                  int3_en;                       /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];                   
  GPON_MAC_GPON_interrupt4_t               interrupt4;                    /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];                   
  GPON_MAC_GPON_int4_en_t                  int4_en;                       /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];                   
  GPON_MAC_GPON_bits_t                     bits;                          /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd44[3];                   
  GPON_MAC_GPON_pattern_t                  pattern;                       /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd45[3];                   
  GPON_MAC_GPON_sn_acquire_t               sn_acquire;                    /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd46[3];                   
  GPON_MAC_GPON_pre_assign_t               pre_assign;                    /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd47[3];                   
  GPON_MAC_GPON_onu_t                      onu;                           /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd48[3];                   
  GPON_MAC_GPON_main_t                     main;                          /* addr: 0x000000c0 */
  ca_uint32_t                              rsrvd49[3];                   
  GPON_MAC_GPON_protection_t               protection;                    /* addr: 0x000000c4 */
  ca_uint32_t                              rsrvd50[3];                   
  GPON_MAC_GPON_omci_port_t                omci_port;                     /* addr: 0x000000c8 */
  ca_uint32_t                              rsrvd51[3];                   
  GPON_MAC_GPON_olt_pst_t                  olt_pst;                       /* addr: 0x000000cc */
  ca_uint32_t                              rsrvd52[3];                   
  GPON_MAC_GPON_ber_t                      ber;                           /* addr: 0x000000d0 */
  ca_uint32_t                              rsrvd53[3];                   
  GPON_MAC_GPON_key_switching_t            key_switching;                 /* addr: 0x000000d4 */
  ca_uint32_t                              rsrvd54[3];                   
  GPON_MAC_GPON_t3_preamble_t              t3_preamble;                   /* addr: 0x000000d8 */
  ca_uint32_t                              rsrvd55[3];                   
  GPON_MAC_GPON_superframe_t               superframe;                    /* addr: 0x000000dc */
  ca_uint32_t                              rsrvd56[3];                   
  GPON_MAC_GPON_hi_ploamu_t                hi_ploamu;                     /* addr: 0x000000e0 */
  ca_uint32_t                              rsrvd57[3];                   
  GPON_MAC_GPON_hi_ploamu0_t               hi_ploamu0;                    /* addr: 0x000000e4 */
  ca_uint32_t                              rsrvd58[3];                   
  GPON_MAC_GPON_hi_ploamu1_t               hi_ploamu1;                    /* addr: 0x000000e8 */
  ca_uint32_t                              rsrvd59[3];                   
  GPON_MAC_GPON_hi_ploamu2_t               hi_ploamu2;                    /* addr: 0x000000ec */
  ca_uint32_t                              rsrvd60[3];                   
  GPON_MAC_GPON_panic_t                    panic;                         /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd61[3];                   
  GPON_MAC_GPON_PLOAMD_FF_CTL_t            PLOAMD_FF_CTL;                 /* addr: 0x000000f4 */
  ca_uint32_t                              rsrvd62[3];                   
  GPON_MAC_GPON_PLOAMD_FIFO3_t             PLOAMD_FIFO3;                  /* addr: 0x000000f8 */
  ca_uint32_t                              rsrvd63[3];                   
  GPON_MAC_GPON_PLOAMD_FIFO2_t             PLOAMD_FIFO2;                  /* addr: 0x000000fc */
  ca_uint32_t                              rsrvd64[3];                   
  GPON_MAC_GPON_PLOAMD_FIFO1_t             PLOAMD_FIFO1;                  /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd65[3];                   
  GPON_MAC_GPON_PLOAMD_FIFO0_t             PLOAMD_FIFO0;                  /* addr: 0x00000104 */
  ca_uint32_t                              rsrvd66[3];                   
  GPON_MAC_GPON_PLOAMU_STS2_t              PLOAMU_STS2;                   /* addr: 0x00000108 */
  ca_uint32_t                              rsrvd67[3];                   
  GPON_MAC_GPON_PLOAMU_STS1_t              PLOAMU_STS1;                   /* addr: 0x0000010c */
  ca_uint32_t                              rsrvd68[3];                   
  GPON_MAC_GPON_PLOAMU_STS0_t              PLOAMU_STS0;                   /* addr: 0x00000110 */
  ca_uint32_t                              rsrvd69[3];                   
  GPON_MAC_GPON_onu_ctl_t                  onu_ctl;                       /* addr: 0x00000114 */
  ca_uint32_t                              rsrvd70[3];                   
  GPON_MAC_GPON_onu_cfg_t                  onu_cfg;                       /* addr: 0x00000118 */
  ca_uint32_t                              rsrvd71[3];                   
  GPON_MAC_GPON_ploamd_disable_t           ploamd_disable;                /* addr: 0x0000011c */
  ca_uint32_t                              rsrvd72[3];                   
  GPON_MAC_GPON_ploamd_fifo_wr_t           ploamd_fifo_wr;                /* addr: 0x00000120 */
  ca_uint32_t                              rsrvd73[3];                   
  GPON_MAC_GPON_ploamu_disable_t           ploamu_disable;                /* addr: 0x00000124 */
  ca_uint32_t                              rsrvd74[3];                   
  GPON_MAC_GPON_DS_PROCESS_t               DS_PROCESS;                    /* addr: 0x00000128 */
  ca_uint32_t                              rsrvd75[3];                   
  GPON_MAC_GPON_TCONT_ACCESS_t             TCONT_ACCESS;                  /* addr: 0x0000012c */
  ca_uint32_t                              rsrvd76[3];                   
  GPON_MAC_GPON_TCONT_DATA_t               TCONT_DATA;                    /* addr: 0x00000130 */
  ca_uint32_t                              rsrvd77[3];                   
  GPON_MAC_GPON_DS_GEM_PORT_ACCESS_t       DS_GEM_PORT_ACCESS;            /* addr: 0x00000134 */
  ca_uint32_t                              rsrvd78[3];                   
  GPON_MAC_GPON_DS_GEM_PORT_DATA_t         DS_GEM_PORT_DATA;              /* addr: 0x00000138 */
  ca_uint32_t                              rsrvd79[3];                   
  GPON_MAC_GPON_DS_PORT_ACCESS_t           DS_PORT_ACCESS;                /* addr: 0x0000013c */
  ca_uint32_t                              rsrvd80[3];                   
  GPON_MAC_GPON_DS_PORT_DATA3_t            DS_PORT_DATA3;                 /* addr: 0x00000140 */
  ca_uint32_t                              rsrvd81[3];                   
  GPON_MAC_GPON_DS_PORT_DATA2_t            DS_PORT_DATA2;                 /* addr: 0x00000144 */
  ca_uint32_t                              rsrvd82[3];                   
  GPON_MAC_GPON_DS_PORT_DATA1_t            DS_PORT_DATA1;                 /* addr: 0x00000148 */
  ca_uint32_t                              rsrvd83[3];                   
  GPON_MAC_GPON_DS_PORT_DATA0_t            DS_PORT_DATA0;                 /* addr: 0x0000014c */
  ca_uint32_t                              rsrvd84[3];                   
  GPON_MAC_GPON_US_MIB_ACCESS_t            US_MIB_ACCESS;                 /* addr: 0x00000150 */
  ca_uint32_t                              rsrvd85[3];                   
  GPON_MAC_GPON_US_MIB_DATA2_t             US_MIB_DATA2;                  /* addr: 0x00000154 */
  ca_uint32_t                              rsrvd86[3];                   
  GPON_MAC_GPON_US_MIB_DATA1_t             US_MIB_DATA1;                  /* addr: 0x00000158 */
  ca_uint32_t                              rsrvd87[3];                   
  GPON_MAC_GPON_US_MIB_DATA0_t             US_MIB_DATA0;                  /* addr: 0x0000015c */
  ca_uint32_t                              rsrvd88[3];                   
  GPON_MAC_GPON_PLM_MIB_ACCESS_t           PLM_MIB_ACCESS;                /* addr: 0x00000160 */
  ca_uint32_t                              rsrvd89[3];                   
  GPON_MAC_GPON_PLM_MIB_DATA_t             PLM_MIB_DATA;                  /* addr: 0x00000164 */
  ca_uint32_t                              rsrvd90[3];                   
  GPON_MAC_GPON_MIB_INIT_t                 MIB_INIT;                      /* addr: 0x00000168 */
  ca_uint32_t                              rsrvd91[3];                   
  GPON_MAC_GPON_US_PORT_ID_ACCESS_t        US_PORT_ID_ACCESS;             /* addr: 0x0000016c */
  ca_uint32_t                              rsrvd92[3];                   
  GPON_MAC_GPON_US_PORT_ID_DATA_t          US_PORT_ID_DATA;               /* addr: 0x00000170 */
  ca_uint32_t                              rsrvd93[3];                   
  GPON_MAC_GPON_bwmap_ctl_t                bwmap_ctl;                     /* addr: 0x00000174 */
  ca_uint32_t                              rsrvd94[3];                   
  GPON_MAC_GPON_bwmap_data0_t              bwmap_data0;                   /* addr: 0x00000178 */
  ca_uint32_t                              rsrvd95[3];                   
  GPON_MAC_GPON_bwmap_data1_t              bwmap_data1;                   /* addr: 0x0000017c */
  ca_uint32_t                              rsrvd96[3];                   
  GPON_MAC_GPON_up_t                       up;                            /* addr: 0x00000180 */
  ca_uint32_t                              rsrvd97[3];                   
  GPON_MAC_GPON_o5_t                       o5;                            /* addr: 0x00000184 */
  ca_uint32_t                              rsrvd98[3];                   
  GPON_MAC_GPON_gem_frag_drop_t            gem_frag_drop;                 /* addr: 0x00000188 */
  ca_uint32_t                              rsrvd99[3];                   
  GPON_MAC_GPON_gem_one_biterr_t           gem_one_biterr;                /* addr: 0x0000018c */
  ca_uint32_t                              rsrvd100[3];                  
  GPON_MAC_GPON_gem_two_biterr_t           gem_two_biterr;                /* addr: 0x00000190 */
  ca_uint32_t                              rsrvd101[3];                  
  GPON_MAC_GPON_gem_uncorrected_biterr_t   gem_uncorrected_biterr;        /* addr: 0x00000194 */
  ca_uint32_t                              rsrvd102[3];                  
  GPON_MAC_GPON_bwmap_drop_t               bwmap_drop;                    /* addr: 0x00000198 */
  ca_uint32_t                              rsrvd103[3];                  
  GPON_MAC_GPON_omci_crc_t                 omci_crc;                      /* addr: 0x0000019c */
  ca_uint32_t                              rsrvd104[3];                  
  GPON_MAC_GPON_plend_err_t                plend_err;                     /* addr: 0x000001a0 */
  ca_uint32_t                              rsrvd105[3];                  
  GPON_MAC_GPON_plend_biterr_t             plend_biterr;                  /* addr: 0x000001a4 */
  ca_uint32_t                              rsrvd106[3];                  
  GPON_MAC_GPON_ds_asmbl_fifo_drop_cnt_t   ds_asmbl_fifo_drop_cnt;        /* addr: 0x000001a8 */
  ca_uint32_t                              rsrvd107[3];                  
  GPON_MAC_GPON_bypass_t                   bypass;                        /* addr: 0x000001ac */
  ca_uint32_t                              rsrvd108[3];                  
  GPON_MAC_GPON_sw_dbru_t                  sw_dbru;                       /* addr: 0x000001b0 */
  ca_uint32_t                              rsrvd109[3];                  
  GPON_MAC_GPON_scratch_t                  scratch;                       /* addr: 0x000001b4 */
  ca_uint32_t                              rsrvd110[3];                  
  GPON_MAC_GPON_DBRU_BUFOCC_TBL_ACCESS_t   DBRU_BUFOCC_TBL_ACCESS;        /* addr: 0x000001b8 */
  ca_uint32_t                              rsrvd111[3];                  
  GPON_MAC_GPON_DBRU_BUFOCC_TBL_DATA_t     DBRU_BUFOCC_TBL_DATA;          /* addr: 0x000001bc */
  ca_uint32_t                              rsrvd112[3];                  
  GPON_MAC_GPON_CTRL_t                     CTRL;                          /* addr: 0x000001c0 */
  ca_uint32_t                              rsrvd113[3];                  
  GPON_MAC_GPON_SUPER_FRAME_MATCH_VAL_t    SUPER_FRAME_MATCH_VAL;         /* addr: 0x000001c4 */
  ca_uint32_t                              rsrvd114[3];                  
  GPON_MAC_GPON_DEBUG_CTRL_t               DEBUG_CTRL;                    /* addr: 0x000001c8 */
  ca_uint32_t                              rsrvd115[3];                  
  GPON_MAC_GPON_DEBUG_STATUS0_t            DEBUG_STATUS0;                 /* addr: 0x000001cc */
  ca_uint32_t                              rsrvd116[3];                  
  GPON_MAC_GPON_DEBUG_STATUS1_t            DEBUG_STATUS1;                 /* addr: 0x000001d0 */
  ca_uint32_t                              rsrvd117[3];                  
  GPON_MAC_GPON_bwmap_uncorrected_biterr_t bwmap_uncorrected_biterr;      /* addr: 0x000001d4 */
  ca_uint32_t                              rsrvd118[3];                  
  GPON_MAC_GPON_bwmap_corrected_biterr_t   bwmap_corrected_biterr;        /* addr: 0x000001d8 */
} APB1_GPON_MAC_GPON_t;


/*
 * aes
 */
        
#define GPON_MAC_AES_AES_MODE_CTL                0xd0036400
#define GPON_MAC_AES_AES_MODE_CTL_dft            0x3f800000

typedef volatile union {
  struct {
    ca_uint32_t CntDiff              : 16 ; /* bits 15:0 */
    ca_uint32_t CntIncDec            :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t loc_cnt_debug        :  1 ; /* bits 22:22 */
    ca_uint32_t mc_grp_preamble      :  7 ; /* bits 29:23 */
    ca_uint32_t AesModeSel           :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_AES_AES_MODE_CTL_t;


#define GPON_MAC_AES_CURR_KEY_INDEX              0xd0036404
#define GPON_MAC_AES_CURR_KEY_INDEX_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t MULTI_INDEX          :  8 ; /* bits 7:0 */
    ca_uint32_t UNICAST              :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_AES_CURR_KEY_INDEX_t;


#define GPON_MAC_AES_MC_TBL_TRANS0               0xd0036408
#define GPON_MAC_AES_MC_TBL_TRANS0_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tbl_idx0             :  3 ; /* bits 2:0 */
    ca_uint32_t tbl_vld0             :  1 ; /* bits 3:3 */
    ca_uint32_t tbl_idx1             :  3 ; /* bits 6:4 */
    ca_uint32_t tbl_vld1             :  1 ; /* bits 7:7 */
    ca_uint32_t tbl_idx2             :  3 ; /* bits 10:8 */
    ca_uint32_t tbl_vld2             :  1 ; /* bits 11:11 */
    ca_uint32_t tbl_idx3             :  3 ; /* bits 14:12 */
    ca_uint32_t tbl_vld3             :  1 ; /* bits 15:15 */
    ca_uint32_t tbl_idx4             :  3 ; /* bits 18:16 */
    ca_uint32_t tbl_vld4             :  1 ; /* bits 19:19 */
    ca_uint32_t tbl_idx5             :  3 ; /* bits 22:20 */
    ca_uint32_t tbl_vld5             :  1 ; /* bits 23:23 */
    ca_uint32_t tbl_idx6             :  3 ; /* bits 26:24 */
    ca_uint32_t tbl_vld6             :  1 ; /* bits 27:27 */
    ca_uint32_t tbl_idx7             :  3 ; /* bits 30:28 */
    ca_uint32_t tbl_vld7             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_AES_MC_TBL_TRANS0_t;


#define GPON_MAC_AES_MC_TBL_TRANS1               0xd003640c
#define GPON_MAC_AES_MC_TBL_TRANS1_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tbl_idx8             :  3 ; /* bits 2:0 */
    ca_uint32_t tbl_vld8             :  1 ; /* bits 3:3 */
    ca_uint32_t tbl_idx9             :  3 ; /* bits 6:4 */
    ca_uint32_t tbl_vld9             :  1 ; /* bits 7:7 */
    ca_uint32_t tbl_idx10            :  3 ; /* bits 10:8 */
    ca_uint32_t tbl_vld10            :  1 ; /* bits 11:11 */
    ca_uint32_t tbl_idx11            :  3 ; /* bits 14:12 */
    ca_uint32_t tbl_vld11            :  1 ; /* bits 15:15 */
    ca_uint32_t tbl_idx12            :  3 ; /* bits 18:16 */
    ca_uint32_t tbl_vld12            :  1 ; /* bits 19:19 */
    ca_uint32_t tbl_idx13            :  3 ; /* bits 22:20 */
    ca_uint32_t tbl_vld13            :  1 ; /* bits 23:23 */
    ca_uint32_t tbl_idx14            :  3 ; /* bits 26:24 */
    ca_uint32_t tbl_vld14            :  1 ; /* bits 27:27 */
    ca_uint32_t tbl_idx15            :  3 ; /* bits 30:28 */
    ca_uint32_t tbl_vld15            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_AES_MC_TBL_TRANS1_t;


#define GPON_MAC_AES_MC_TBL_TRANS2               0xd0036410
#define GPON_MAC_AES_MC_TBL_TRANS2_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tbl_idx16            :  3 ; /* bits 2:0 */
    ca_uint32_t tbl_vld16            :  1 ; /* bits 3:3 */
    ca_uint32_t tbl_idx17            :  3 ; /* bits 6:4 */
    ca_uint32_t tbl_vld17            :  1 ; /* bits 7:7 */
    ca_uint32_t tbl_idx18            :  3 ; /* bits 10:8 */
    ca_uint32_t tbl_vld18            :  1 ; /* bits 11:11 */
    ca_uint32_t tbl_idx19            :  3 ; /* bits 14:12 */
    ca_uint32_t tbl_vld19            :  1 ; /* bits 15:15 */
    ca_uint32_t tbl_idx20            :  3 ; /* bits 18:16 */
    ca_uint32_t tbl_vld20            :  1 ; /* bits 19:19 */
    ca_uint32_t tbl_idx21            :  3 ; /* bits 22:20 */
    ca_uint32_t tbl_vld21            :  1 ; /* bits 23:23 */
    ca_uint32_t tbl_idx22            :  3 ; /* bits 26:24 */
    ca_uint32_t tbl_vld22            :  1 ; /* bits 27:27 */
    ca_uint32_t tbl_idx23            :  3 ; /* bits 30:28 */
    ca_uint32_t tbl_vld23            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_AES_MC_TBL_TRANS2_t;


#define GPON_MAC_AES_MC_TBL_TRANS3               0xd0036414
#define GPON_MAC_AES_MC_TBL_TRANS3_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tbl_idx24            :  3 ; /* bits 2:0 */
    ca_uint32_t tbl_vld24            :  1 ; /* bits 3:3 */
    ca_uint32_t tbl_idx25            :  3 ; /* bits 6:4 */
    ca_uint32_t tbl_vld25            :  1 ; /* bits 7:7 */
    ca_uint32_t tbl_idx26            :  3 ; /* bits 10:8 */
    ca_uint32_t tbl_vld26            :  1 ; /* bits 11:11 */
    ca_uint32_t tbl_idx27            :  3 ; /* bits 14:12 */
    ca_uint32_t tbl_vld27            :  1 ; /* bits 15:15 */
    ca_uint32_t tbl_idx28            :  3 ; /* bits 18:16 */
    ca_uint32_t tbl_vld28            :  1 ; /* bits 19:19 */
    ca_uint32_t tbl_idx29            :  3 ; /* bits 22:20 */
    ca_uint32_t tbl_vld29            :  1 ; /* bits 23:23 */
    ca_uint32_t tbl_idx30            :  3 ; /* bits 26:24 */
    ca_uint32_t tbl_vld30            :  1 ; /* bits 27:27 */
    ca_uint32_t tbl_idx31            :  3 ; /* bits 30:28 */
    ca_uint32_t tbl_vld31            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_AES_MC_TBL_TRANS3_t;


#define GPON_MAC_AES_MC_TBL_TRANS4               0xd0036418
#define GPON_MAC_AES_MC_TBL_TRANS4_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tbl_idx32            :  3 ; /* bits 2:0 */
    ca_uint32_t tbl_vld32            :  1 ; /* bits 3:3 */
    ca_uint32_t tbl_idx33            :  3 ; /* bits 6:4 */
    ca_uint32_t tbl_vld33            :  1 ; /* bits 7:7 */
    ca_uint32_t tbl_idx34            :  3 ; /* bits 10:8 */
    ca_uint32_t tbl_vld34            :  1 ; /* bits 11:11 */
    ca_uint32_t tbl_idx35            :  3 ; /* bits 14:12 */
    ca_uint32_t tbl_vld35            :  1 ; /* bits 15:15 */
    ca_uint32_t tbl_idx36            :  3 ; /* bits 18:16 */
    ca_uint32_t tbl_vld36            :  1 ; /* bits 19:19 */
    ca_uint32_t tbl_idx37            :  3 ; /* bits 22:20 */
    ca_uint32_t tbl_vld37            :  1 ; /* bits 23:23 */
    ca_uint32_t tbl_idx38            :  3 ; /* bits 26:24 */
    ca_uint32_t tbl_vld38            :  1 ; /* bits 27:27 */
    ca_uint32_t tbl_idx39            :  3 ; /* bits 30:28 */
    ca_uint32_t tbl_vld39            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_AES_MC_TBL_TRANS4_t;


#define GPON_MAC_AES_MC_TBL_TRANS5               0xd003641c
#define GPON_MAC_AES_MC_TBL_TRANS5_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tbl_idx40            :  3 ; /* bits 2:0 */
    ca_uint32_t tbl_vld40            :  1 ; /* bits 3:3 */
    ca_uint32_t tbl_idx41            :  3 ; /* bits 6:4 */
    ca_uint32_t tbl_vld41            :  1 ; /* bits 7:7 */
    ca_uint32_t tbl_idx42            :  3 ; /* bits 10:8 */
    ca_uint32_t tbl_vld42            :  1 ; /* bits 11:11 */
    ca_uint32_t tbl_idx43            :  3 ; /* bits 14:12 */
    ca_uint32_t tbl_vld43            :  1 ; /* bits 15:15 */
    ca_uint32_t tbl_idx44            :  3 ; /* bits 18:16 */
    ca_uint32_t tbl_vld44            :  1 ; /* bits 19:19 */
    ca_uint32_t tbl_idx45            :  3 ; /* bits 22:20 */
    ca_uint32_t tbl_vld45            :  1 ; /* bits 23:23 */
    ca_uint32_t tbl_idx46            :  3 ; /* bits 26:24 */
    ca_uint32_t tbl_vld46            :  1 ; /* bits 27:27 */
    ca_uint32_t tbl_idx47            :  3 ; /* bits 30:28 */
    ca_uint32_t tbl_vld47            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_AES_MC_TBL_TRANS5_t;


#define GPON_MAC_AES_MC_TBL_TRANS6               0xd0036420
#define GPON_MAC_AES_MC_TBL_TRANS6_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tbl_idx48            :  3 ; /* bits 2:0 */
    ca_uint32_t tbl_vld48            :  1 ; /* bits 3:3 */
    ca_uint32_t tbl_idx49            :  3 ; /* bits 6:4 */
    ca_uint32_t tbl_vld49            :  1 ; /* bits 7:7 */
    ca_uint32_t tbl_idx50            :  3 ; /* bits 10:8 */
    ca_uint32_t tbl_vld50            :  1 ; /* bits 11:11 */
    ca_uint32_t tbl_idx51            :  3 ; /* bits 14:12 */
    ca_uint32_t tbl_vld51            :  1 ; /* bits 15:15 */
    ca_uint32_t tbl_idx52            :  3 ; /* bits 18:16 */
    ca_uint32_t tbl_vld52            :  1 ; /* bits 19:19 */
    ca_uint32_t tbl_idx53            :  3 ; /* bits 22:20 */
    ca_uint32_t tbl_vld53            :  1 ; /* bits 23:23 */
    ca_uint32_t tbl_idx54            :  3 ; /* bits 26:24 */
    ca_uint32_t tbl_vld54            :  1 ; /* bits 27:27 */
    ca_uint32_t tbl_idx55            :  3 ; /* bits 30:28 */
    ca_uint32_t tbl_vld55            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_AES_MC_TBL_TRANS6_t;


#define GPON_MAC_AES_MC_TBL_TRANS7               0xd0036424
#define GPON_MAC_AES_MC_TBL_TRANS7_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tbl_idx56            :  3 ; /* bits 2:0 */
    ca_uint32_t tbl_vld56            :  1 ; /* bits 3:3 */
    ca_uint32_t tbl_idx57            :  3 ; /* bits 6:4 */
    ca_uint32_t tbl_vld57            :  1 ; /* bits 7:7 */
    ca_uint32_t tbl_idx58            :  3 ; /* bits 10:8 */
    ca_uint32_t tbl_vld58            :  1 ; /* bits 11:11 */
    ca_uint32_t tbl_idx59            :  3 ; /* bits 14:12 */
    ca_uint32_t tbl_vld59            :  1 ; /* bits 15:15 */
    ca_uint32_t tbl_idx60            :  3 ; /* bits 18:16 */
    ca_uint32_t tbl_vld60            :  1 ; /* bits 19:19 */
    ca_uint32_t tbl_idx61            :  3 ; /* bits 22:20 */
    ca_uint32_t tbl_vld61            :  1 ; /* bits 23:23 */
    ca_uint32_t tbl_idx62            :  3 ; /* bits 26:24 */
    ca_uint32_t tbl_vld62            :  1 ; /* bits 27:27 */
    ca_uint32_t tbl_idx63            :  3 ; /* bits 30:28 */
    ca_uint32_t tbl_vld63            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_AES_MC_TBL_TRANS7_t;


#define GPON_MAC_AES_UC_KEY03                    0xd0036428
#define GPON_MAC_AES_UC_KEY03_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key03                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_AES_UC_KEY03_t;


#define GPON_MAC_AES_UC_KEY02                    0xd003642c
#define GPON_MAC_AES_UC_KEY02_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key02                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_AES_UC_KEY02_t;


#define GPON_MAC_AES_UC_KEY01                    0xd0036430
#define GPON_MAC_AES_UC_KEY01_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key01                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_AES_UC_KEY01_t;


#define GPON_MAC_AES_UC_KEY00                    0xd0036434
#define GPON_MAC_AES_UC_KEY00_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key00                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_AES_UC_KEY00_t;


#define GPON_MAC_AES_UC_KEY13                    0xd0036438
#define GPON_MAC_AES_UC_KEY13_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key13                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_AES_UC_KEY13_t;


#define GPON_MAC_AES_UC_KEY12                    0xd003643c
#define GPON_MAC_AES_UC_KEY12_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key12                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_AES_UC_KEY12_t;


#define GPON_MAC_AES_UC_KEY11                    0xd0036440
#define GPON_MAC_AES_UC_KEY11_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key11                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_AES_UC_KEY11_t;


#define GPON_MAC_AES_UC_KEY10                    0xd0036444
#define GPON_MAC_AES_UC_KEY10_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key10                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_AES_UC_KEY10_t;


#define GPON_MAC_AES_MC_KEY3                     0xd0036500
#define GPON_MAC_AES_MC_KEY3_STRIDE              16
#define GPON_MAC_AES_MC_KEY3_COUNT               16
#define GPON_MAC_AES_MC_KEY3_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data3                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_AES_MC_KEY3_t;


#define GPON_MAC_AES_MC_KEY2                     0xd0036504
#define GPON_MAC_AES_MC_KEY2_STRIDE              16
#define GPON_MAC_AES_MC_KEY2_COUNT               16
#define GPON_MAC_AES_MC_KEY2_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data2                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_AES_MC_KEY2_t;


#define GPON_MAC_AES_MC_KEY1                     0xd0036508
#define GPON_MAC_AES_MC_KEY1_STRIDE              16
#define GPON_MAC_AES_MC_KEY1_COUNT               16
#define GPON_MAC_AES_MC_KEY1_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data1                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_AES_MC_KEY1_t;


#define GPON_MAC_AES_MC_KEY0                     0xd003650c
#define GPON_MAC_AES_MC_KEY0_STRIDE              16
#define GPON_MAC_AES_MC_KEY0_COUNT               16
#define GPON_MAC_AES_MC_KEY0_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data0                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_AES_MC_KEY0_t;


#define GPON_MAC_AES_uc_dec_dbg_cnt              0xd0036600
#define GPON_MAC_AES_uc_dec_dbg_cnt_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mpcp_cnt_dbg         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_AES_uc_dec_dbg_cnt_t;


#define GPON_MAC_AES_SW_KEY03                    0xd0036604
#define GPON_MAC_AES_SW_KEY03_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key3                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_AES_SW_KEY03_t;


#define GPON_MAC_AES_SW_KEY02                    0xd0036608
#define GPON_MAC_AES_SW_KEY02_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key2                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_AES_SW_KEY02_t;


#define GPON_MAC_AES_SW_KEY01                    0xd003660c
#define GPON_MAC_AES_SW_KEY01_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_AES_SW_KEY01_t;


#define GPON_MAC_AES_SW_KEY00                    0xd0036610
#define GPON_MAC_AES_SW_KEY00_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_AES_SW_KEY00_t;


#define GPON_MAC_AES_SW_KEY13                    0xd0036614
#define GPON_MAC_AES_SW_KEY13_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key3                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_AES_SW_KEY13_t;


#define GPON_MAC_AES_SW_KEY12                    0xd0036618
#define GPON_MAC_AES_SW_KEY12_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key2                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_AES_SW_KEY12_t;


#define GPON_MAC_AES_SW_KEY11                    0xd003661c
#define GPON_MAC_AES_SW_KEY11_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_AES_SW_KEY11_t;


#define GPON_MAC_AES_SW_KEY10                    0xd0036620
#define GPON_MAC_AES_SW_KEY10_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_AES_SW_KEY10_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* aes */
typedef struct {
  GPON_MAC_AES_AES_MODE_CTL_t              AES_MODE_CTL;                  /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  GPON_MAC_AES_CURR_KEY_INDEX_t            CURR_KEY_INDEX;                /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  GPON_MAC_AES_MC_TBL_TRANS0_t             MC_TBL_TRANS0;                 /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  GPON_MAC_AES_MC_TBL_TRANS1_t             MC_TBL_TRANS1;                 /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  GPON_MAC_AES_MC_TBL_TRANS2_t             MC_TBL_TRANS2;                 /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  GPON_MAC_AES_MC_TBL_TRANS3_t             MC_TBL_TRANS3;                 /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  GPON_MAC_AES_MC_TBL_TRANS4_t             MC_TBL_TRANS4;                 /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  GPON_MAC_AES_MC_TBL_TRANS5_t             MC_TBL_TRANS5;                 /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  GPON_MAC_AES_MC_TBL_TRANS6_t             MC_TBL_TRANS6;                 /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  GPON_MAC_AES_MC_TBL_TRANS7_t             MC_TBL_TRANS7;                 /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  GPON_MAC_AES_UC_KEY03_t                  UC_KEY03;                      /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  GPON_MAC_AES_UC_KEY02_t                  UC_KEY02;                      /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  GPON_MAC_AES_UC_KEY01_t                  UC_KEY01;                      /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  GPON_MAC_AES_UC_KEY00_t                  UC_KEY00;                      /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  GPON_MAC_AES_UC_KEY13_t                  UC_KEY13;                      /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  GPON_MAC_AES_UC_KEY12_t                  UC_KEY12;                      /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  GPON_MAC_AES_UC_KEY11_t                  UC_KEY11;                      /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  GPON_MAC_AES_UC_KEY10_t                  UC_KEY10;                      /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[187];                 
  GPON_MAC_AES_MC_KEY3_t                   MC_KEY3;                       /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd19[3];                   
  GPON_MAC_AES_MC_KEY2_t                   MC_KEY2;                       /* addr: 0x00000104 */
  ca_uint32_t                              rsrvd20[3];                   
  GPON_MAC_AES_MC_KEY1_t                   MC_KEY1;                       /* addr: 0x00000108 */
  ca_uint32_t                              rsrvd21[3];                   
  GPON_MAC_AES_MC_KEY0_t                   MC_KEY0;                       /* addr: 0x0000010c */
  ca_uint32_t                              rsrvd22[243];                 
  GPON_MAC_AES_uc_dec_dbg_cnt_t            uc_dec_dbg_cnt;                /* addr: 0x00000200 */
  ca_uint32_t                              rsrvd23[3];                   
  GPON_MAC_AES_SW_KEY03_t                  SW_KEY03;                      /* addr: 0x00000204 */
  ca_uint32_t                              rsrvd24[3];                   
  GPON_MAC_AES_SW_KEY02_t                  SW_KEY02;                      /* addr: 0x00000208 */
  ca_uint32_t                              rsrvd25[3];                   
  GPON_MAC_AES_SW_KEY01_t                  SW_KEY01;                      /* addr: 0x0000020c */
  ca_uint32_t                              rsrvd26[3];                   
  GPON_MAC_AES_SW_KEY00_t                  SW_KEY00;                      /* addr: 0x00000210 */
  ca_uint32_t                              rsrvd27[3];                   
  GPON_MAC_AES_SW_KEY13_t                  SW_KEY13;                      /* addr: 0x00000214 */
  ca_uint32_t                              rsrvd28[3];                   
  GPON_MAC_AES_SW_KEY12_t                  SW_KEY12;                      /* addr: 0x00000218 */
  ca_uint32_t                              rsrvd29[3];                   
  GPON_MAC_AES_SW_KEY11_t                  SW_KEY11;                      /* addr: 0x0000021c */
  ca_uint32_t                              rsrvd30[3];                   
  GPON_MAC_AES_SW_KEY10_t                  SW_KEY10;                      /* addr: 0x00000220 */
} APB1_GPON_MAC_AES_t;


/*
 * fec
 */
        
#define GPON_MAC_FEC_FEC_CTRL                    0xd0036800
#define GPON_MAC_FEC_FEC_CTRL_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t unc_ctr_clr          :  1 ; /* bits 5:5 */
    ca_uint32_t cor_ctr_clr          :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t halt_unc             :  1 ; /* bits 8:8 */
    ca_uint32_t halt_cor             :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd3               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_FEC_FEC_CTRL_t;


#define GPON_MAC_FEC_FEC_MISC_STATUS             0xd0036804
#define GPON_MAC_FEC_FEC_MISC_STATUS_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t fec_errors           :  4 ; /* bits 10:7 */
    ca_uint32_t fec_uncorr           :  1 ; /* bits 11:11 */
    ca_uint32_t fec_dacor_ack_q      :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd2               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_FEC_FEC_MISC_STATUS_t;


#define GPON_MAC_FEC_FEC_Block_Correctable_Error_Counter 0xd0036808
#define GPON_MAC_FEC_FEC_Block_Correctable_Error_Counter_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t FEC_RCNT             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_FEC_FEC_Block_Correctable_Error_Counter_t;


#define GPON_MAC_FEC_FEC_Block_Uncorrectable_Error_Counter 0xd003680c
#define GPON_MAC_FEC_FEC_Block_Uncorrectable_Error_Counter_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t FEC_UCNT             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_FEC_FEC_Block_Uncorrectable_Error_Counter_t;


#define GPON_MAC_FEC_FEC_Block_No_Error_Counter  0xd0036810
#define GPON_MAC_FEC_FEC_Block_No_Error_Counter_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t FEC_NOERR            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_FEC_FEC_Block_No_Error_Counter_t;


#define GPON_MAC_FEC_FEC_Block_Counter           0xd0036814
#define GPON_MAC_FEC_FEC_Block_Counter_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t FEC_BLK_CNT          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_FEC_FEC_Block_Counter_t;


#define GPON_MAC_FEC_FEC_Corr_Byte_Counter       0xd0036818
#define GPON_MAC_FEC_FEC_Corr_Byte_Counter_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t FEC_CORR_BYTE_CNT    : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_FEC_FEC_Corr_Byte_Counter_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* fec */
typedef struct {
  GPON_MAC_FEC_FEC_CTRL_t                  FEC_CTRL;                      /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  GPON_MAC_FEC_FEC_MISC_STATUS_t           FEC_MISC_STATUS;               /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  GPON_MAC_FEC_FEC_Block_Correctable_Error_Counter_t FEC_Block_Correctable_Error_Counter; /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  GPON_MAC_FEC_FEC_Block_Uncorrectable_Error_Counter_t FEC_Block_Uncorrectable_Error_Counter; /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  GPON_MAC_FEC_FEC_Block_No_Error_Counter_t FEC_Block_No_Error_Counter;    /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  GPON_MAC_FEC_FEC_Block_Counter_t         FEC_Block_Counter;             /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  GPON_MAC_FEC_FEC_Corr_Byte_Counter_t     FEC_Corr_Byte_Counter;         /* addr: 0x00000018 */
} APB1_GPON_MAC_FEC_t;


/*
 * pucif
 */
        
#define GPON_MAC_PUCIF_CTRL                      0xd0036e00
#define GPON_MAC_PUCIF_CTRL_dft                  0x0040a100

typedef volatile union {
  struct {
    ca_uint32_t cntr_tconid          :  5 ; /* bits 4:0 */
    ca_uint32_t cntr_tconid_en       :  1 ; /* bits 5:5 */
    ca_uint32_t cntr0_event_sel      :  3 ; /* bits 8:6 */
    ca_uint32_t cntr1_event_sel      :  3 ; /* bits 11:9 */
    ca_uint32_t cntr2_event_sel      :  3 ; /* bits 14:12 */
    ca_uint32_t single_thread        :  1 ; /* bits 15:15 */
    ca_uint32_t sch_to_threshold     : 12 ; /* bits 27:16 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t cntr_inccfg          :  3 ; /* bits 31:29 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_PUCIF_CTRL_t;


#define GPON_MAC_PUCIF_CNTR0                     0xd0036e04
#define GPON_MAC_PUCIF_CNTR0_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_PUCIF_CNTR0_t;


#define GPON_MAC_PUCIF_CNTR1                     0xd0036e08
#define GPON_MAC_PUCIF_CNTR1_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_PUCIF_CNTR1_t;


#define GPON_MAC_PUCIF_CNTR2                     0xd0036e0c
#define GPON_MAC_PUCIF_CNTR2_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_PUCIF_CNTR2_t;


#define GPON_MAC_PUCIF_STS                       0xd0036e10
#define GPON_MAC_PUCIF_STS_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sch_tconid           :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t data_tconid          :  5 ; /* bits 12:8 */
    ca_uint32_t data_gemid           :  7 ; /* bits 19:13 */
    ca_uint32_t rsrvd2               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_PUCIF_STS_t;


#define GPON_MAC_PUCIF_PROTECT                   0xd0036e14
#define GPON_MAC_PUCIF_PROTECT_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pucif_hang           :  1 ; /* bits 0:0 */
    ca_uint32_t pucif_hang_tcon_id   :  5 ; /* bits 5:1 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} GPON_MAC_PUCIF_PROTECT_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* pucif */
typedef struct {
  GPON_MAC_PUCIF_CTRL_t                    CTRL;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  GPON_MAC_PUCIF_CNTR0_t                   CNTR0;                         /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  GPON_MAC_PUCIF_CNTR1_t                   CNTR1;                         /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  GPON_MAC_PUCIF_CNTR2_t                   CNTR2;                         /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  GPON_MAC_PUCIF_STS_t                     STS;                           /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  GPON_MAC_PUCIF_PROTECT_t                 PROTECT;                       /* addr: 0x00000014 */
} APB1_GPON_MAC_PUCIF_t;

    
  
        
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* GPON_MAC */

typedef struct {
  APB1_GPON_MAC_GPON_t                     gpon;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[787];                  
  APB1_GPON_MAC_AES_t                      aes;                           /* addr: 0x00000400 */
  ca_uint32_t                              rsrvd2[751];                  
  APB1_GPON_MAC_FEC_t                      fec;                           /* addr: 0x00000800 */
  ca_uint32_t                              rsrvd3[1523];                 
  APB1_GPON_MAC_PUCIF_t                    pucif;                         /* addr: 0x00000e00 */
} APB1_GPON_MAC_t;


/*
 * PUC
 */
        
#define PUC_PVTBL_ACCESS                         0xd0038000
#define PUC_PVTBL_ACCESS_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ADDR                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_PVTBL_ACCESS_t;


#define PUC_PVTBL_DATA4                          0xd0038004
#define PUC_PVTBL_DATA4_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wrrratio7            :  8 ; /* bits 7:0 */
    ca_uint32_t nxtptr               :  6 ; /* bits 13:8 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t nxtptrvld            :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd2               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PUC_PVTBL_DATA4_t;


#define PUC_PVTBL_DATA3                          0xd0038008
#define PUC_PVTBL_DATA3_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wrrratio3            :  8 ; /* bits 7:0 */
    ca_uint32_t wrrratio4            :  8 ; /* bits 15:8 */
    ca_uint32_t wrrratio5            :  8 ; /* bits 23:16 */
    ca_uint32_t wrrratio6            :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_PVTBL_DATA3_t;


#define PUC_PVTBL_DATA2                          0xd003800c
#define PUC_PVTBL_DATA2_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t schmode              :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t entryvld             :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t wrrratio0            :  8 ; /* bits 15:8 */
    ca_uint32_t wrrratio1            :  8 ; /* bits 23:16 */
    ca_uint32_t wrrratio2            :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_PVTBL_DATA2_t;


#define PUC_PVTBL_DATA1                          0xd0038010
#define PUC_PVTBL_DATA1_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t voq4                 :  8 ; /* bits 7:0 */
    ca_uint32_t voq5                 :  8 ; /* bits 15:8 */
    ca_uint32_t voq6                 :  8 ; /* bits 23:16 */
    ca_uint32_t voq7                 :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_PVTBL_DATA1_t;


#define PUC_PVTBL_DATA0                          0xd0038014
#define PUC_PVTBL_DATA0_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t voq0                 :  8 ; /* bits 7:0 */
    ca_uint32_t voq1                 :  8 ; /* bits 15:8 */
    ca_uint32_t voq2                 :  8 ; /* bits 23:16 */
    ca_uint32_t voq3                 :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_PVTBL_DATA0_t;


#define PUC_HPMEM_ACCESS                         0xd0038018
#define PUC_HPMEM_ACCESS_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ADDR                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_HPMEM_ACCESS_t;


#define PUC_HPMEM_DATA                           0xd003801c
#define PUC_HPMEM_DATA_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hptr                 : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PUC_HPMEM_DATA_t;


#define PUC_BCMEM_ACCESS                         0xd0038020
#define PUC_BCMEM_ACCESS_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ADDR                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_BCMEM_ACCESS_t;


#define PUC_BCMEM_DATA1                          0xd0038024
#define PUC_BCMEM_DATA1_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bufcnt               :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} PUC_BCMEM_DATA1_t;


#define PUC_BCMEM_DATA0                          0xd0038028
#define PUC_BCMEM_DATA0_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bytecnt              : 21 ; /* bits 20:0 */
    ca_uint32_t bufcnt               : 11 ; /* bits 31:21 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_BCMEM_DATA0_t;


#define PUC_TQMEM_ACCESS                         0xd003802c
#define PUC_TQMEM_ACCESS_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ADDR                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_TQMEM_ACCESS_t;


#define PUC_TQMEM_DATA1                          0xd0038030
#define PUC_TQMEM_DATA1_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pktcnt               :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} PUC_TQMEM_DATA1_t;


#define PUC_TQMEM_DATA0                          0xd0038034
#define PUC_TQMEM_DATA0_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bytecnt              : 21 ; /* bits 20:0 */
    ca_uint32_t pktcnt               : 11 ; /* bits 31:21 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_TQMEM_DATA0_t;


#define PUC_OPMEM_ACCESS                         0xd0038038
#define PUC_OPMEM_ACCESS_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ADDR                 :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_OPMEM_ACCESS_t;


#define PUC_OPMEM_DATA                           0xd003803c
#define PUC_OPMEM_DATA_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bytecnt              : 14 ; /* bits 13:0 */
    ca_uint32_t voqid                :  7 ; /* bits 20:14 */
    ca_uint32_t gempid               :  7 ; /* bits 27:21 */
    ca_uint32_t rsrvd1               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} PUC_OPMEM_DATA_t;


#define PUC_BPMEM_ACCESS                         0xd0038040
#define PUC_BPMEM_ACCESS_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ADDR                 : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 15 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_BPMEM_ACCESS_t;


#define PUC_BPMEM_DATA                           0xd0038044
#define PUC_BPMEM_DATA_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t nptr                 : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} PUC_BPMEM_DATA_t;


#define PUC_VOQSCHCFG                            0xd0038048
#define PUC_VOQSCHCFG_dft                        0x00000140

typedef volatile union {
  struct {
    ca_uint32_t basesel              :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t ratecomp             :  5 ; /* bits 8:4 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t dwrrunit             :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd3               :  3 ;
    ca_uint32_t pkgbsch              :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd4               :  3 ;
    ca_uint32_t pkgbschmode          :  2 ; /* bits 21:20 */
    ca_uint32_t rsrvd5               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} PUC_VOQSCHCFG_t;


#define PUC_VOQMAPCFG                            0xd003804c
#define PUC_VOQMAPCFG_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t voqmapsel            :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} PUC_VOQMAPCFG_t;


#define PUC_BTCCFG                               0xd0038050
#define PUC_BTCCFG_dft                           0x41000114

typedef volatile union {
  struct {
    ca_uint32_t pfovrhd              :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t schmode              :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t ethmode              :  1 ; /* bits 11:11 */
    ca_uint32_t wdaligned            :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd3               :  3 ;
    ca_uint32_t lrgfrmfragen         :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd4               :  3 ;
    ca_uint32_t pyld1gfecon          :  1 ; /* bits 20:20 */
    ca_uint32_t rsrvd5               :  3 ;
    ca_uint32_t schen                :  1 ; /* bits 24:24 */
    ca_uint32_t rsrvd6               :  2 ;
    ca_uint32_t minrmnwindowsz       :  5 ; /* bits 31:27 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_BTCCFG_t;


#define PUC_RPTCFG                               0xd0038054
#define PUC_RPTCFG_dft                           0x1000c081

typedef volatile union {
  struct {
    ca_uint32_t numqsets             :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t rptpreamblovhd       :  6 ; /* bits 9:4 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t rptipgovhd           :  5 ; /* bits 16:12 */
    ca_uint32_t rsrvd3               :  3 ;
    ca_uint32_t rpt1gfecon           :  1 ; /* bits 20:20 */
    ca_uint32_t rsrvd4               :  3 ;
    ca_uint32_t firstqstot           :  1 ; /* bits 24:24 */
    ca_uint32_t rsrvd5               :  2 ;
    ca_uint32_t noemptyqsetreport    :  1 ; /* bits 27:27 */
    ca_uint32_t lastqstot            :  1 ; /* bits 28:28 */
    ca_uint32_t rsrvd6               :  1 ;
    ca_uint32_t pkgarpt              :  1 ; /* bits 30:30 */
    ca_uint32_t aggrth               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_RPTCFG_t;


#define PUC_NTTCFG                               0xd0038058
#define PUC_NTTCFG_dft                           0x00020000

typedef volatile union {
  struct {
    ca_uint32_t zeroqth              : 21 ; /* bits 20:0 */
    ca_uint32_t rsrvd1               : 10 ;
    ca_uint32_t zeroqrpten           :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_NTTCFG_t;


#define PUC_PVTCFG                               0xd003805c
#define PUC_PVTCFG_dft                           0x00280010

typedef volatile union {
  struct {
    ca_uint32_t pkgbrptceil          :  1 ; /* bits 0:0 */
    ca_uint32_t pucfmrosel           :  3 ; /* bits 3:1 */
    ca_uint32_t pkgboptschen         :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t pmacschszadj         :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t freebufnibplowth     : 15 ; /* bits 30:16 */
    ca_uint32_t freebufnibpen        :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_PVTCFG_t;


#define PUC_VSTBL_ACCESS                         0xd0038060
#define PUC_VSTBL_ACCESS_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ADDR                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_VSTBL_ACCESS_t;


#define PUC_VSTBL_DATA4                          0xd0038064
#define PUC_VSTBL_DATA4_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tbc6                 : 12 ; /* bits 11:0 */
    ca_uint32_t tbc7                 : 20 ; /* bits 31:12 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_VSTBL_DATA4_t;


#define PUC_VSTBL_DATA3                          0xd0038068
#define PUC_VSTBL_DATA3_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tbc4                 :  4 ; /* bits 3:0 */
    ca_uint32_t tbc5                 : 20 ; /* bits 23:4 */
    ca_uint32_t tbc6                 :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_VSTBL_DATA3_t;


#define PUC_VSTBL_DATA2                          0xd003806c
#define PUC_VSTBL_DATA2_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tbc3                 : 16 ; /* bits 15:0 */
    ca_uint32_t tbc4                 : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_VSTBL_DATA2_t;


#define PUC_VSTBL_DATA1                          0xd0038070
#define PUC_VSTBL_DATA1_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tbc1                 :  8 ; /* bits 7:0 */
    ca_uint32_t tbc2                 : 20 ; /* bits 27:8 */
    ca_uint32_t tbc3                 :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_VSTBL_DATA1_t;


#define PUC_VSTBL_DATA0                          0xd0038074
#define PUC_VSTBL_DATA0_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tbc0                 : 20 ; /* bits 19:0 */
    ca_uint32_t tbc1                 : 12 ; /* bits 31:20 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_VSTBL_DATA0_t;


#define PUC_RPTQSCFG12                           0xd0038078
#define PUC_RPTQSCFG12_dft                       0x07d003e8

typedef volatile union {
  struct {
    ca_uint32_t qs1th                : 16 ; /* bits 15:0 */
    ca_uint32_t qs2th                : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_RPTQSCFG12_t;


#define PUC_RPTQSCFG23                           0xd003807c
#define PUC_RPTQSCFG23_dft                       0x0fa00bb8

typedef volatile union {
  struct {
    ca_uint32_t qs3th                : 16 ; /* bits 15:0 */
    ca_uint32_t qs4th                : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_RPTQSCFG23_t;


#define PUC_SLLIDVOQ74CFG                        0xd0038080
#define PUC_SLLIDVOQ74CFG_dft                    0x87868584

typedef volatile union {
  struct {
    ca_uint32_t voq4                 :  7 ; /* bits 6:0 */
    ca_uint32_t voq4vld              :  1 ; /* bits 7:7 */
    ca_uint32_t voq5                 :  7 ; /* bits 14:8 */
    ca_uint32_t voq5vld              :  1 ; /* bits 15:15 */
    ca_uint32_t voq6                 :  7 ; /* bits 22:16 */
    ca_uint32_t voq6vld              :  1 ; /* bits 23:23 */
    ca_uint32_t voq7                 :  7 ; /* bits 30:24 */
    ca_uint32_t voq7vld              :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_SLLIDVOQ74CFG_t;


#define PUC_SLLIDVOQ30CFG                        0xd0038084
#define PUC_SLLIDVOQ30CFG_dft                    0x83828180

typedef volatile union {
  struct {
    ca_uint32_t voq0                 :  7 ; /* bits 6:0 */
    ca_uint32_t voq0vld              :  1 ; /* bits 7:7 */
    ca_uint32_t voq1                 :  7 ; /* bits 14:8 */
    ca_uint32_t voq1vld              :  1 ; /* bits 15:15 */
    ca_uint32_t voq2                 :  7 ; /* bits 22:16 */
    ca_uint32_t voq2vld              :  1 ; /* bits 23:23 */
    ca_uint32_t voq3                 :  7 ; /* bits 30:24 */
    ca_uint32_t voq3vld              :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_SLLIDVOQ30CFG_t;


#define PUC_BMSTS                                0xd0038088
#define PUC_BMSTS_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bpmem_initdone       :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PUC_BMSTS_t;


#define PUC_PUCCFG                               0xd003808c
#define PUC_PUCCFG_dft                           0x80040001

typedef volatile union {
  struct {
    ca_uint32_t crccntl              :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               : 14 ;
    ca_uint32_t inccfg               :  3 ; /* bits 18:16 */
    ca_uint32_t rsrvd2               : 12 ;
    ca_uint32_t sllidmode            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_PUCCFG_t;


#define PUC_VOQBUFLIMITSEL1500                   0xd0038090
#define PUC_VOQBUFLIMITSEL1500_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t buflimitsel          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_VOQBUFLIMITSEL1500_t;


#define PUC_VOQBUFLIMITSEL3116                   0xd0038094
#define PUC_VOQBUFLIMITSEL3116_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t buflimitsel          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_VOQBUFLIMITSEL3116_t;


#define PUC_VOQBUFLIMITSEL4732                   0xd0038098
#define PUC_VOQBUFLIMITSEL4732_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t buflimitsel          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_VOQBUFLIMITSEL4732_t;


#define PUC_VOQBUFLIMITSEL6348                   0xd003809c
#define PUC_VOQBUFLIMITSEL6348_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t buflimitsel          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_VOQBUFLIMITSEL6348_t;


#define PUC_VOQBUFLIMIT_A                        0xd00380a0
#define PUC_VOQBUFLIMIT_A_dft                    0x00007fff

typedef volatile union {
  struct {
    ca_uint32_t buflimit             : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} PUC_VOQBUFLIMIT_A_t;


#define PUC_VOQBUFLIMIT_B                        0xd00380a4
#define PUC_VOQBUFLIMIT_B_dft                    0x00007fff

typedef volatile union {
  struct {
    ca_uint32_t buflimit             : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} PUC_VOQBUFLIMIT_B_t;


#define PUC_VOQBUFLIMIT_C                        0xd00380a8
#define PUC_VOQBUFLIMIT_C_dft                    0x00007fff

typedef volatile union {
  struct {
    ca_uint32_t buflimit             : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} PUC_VOQBUFLIMIT_C_t;


#define PUC_VOQFLUSH                             0xd00380ac
#define PUC_VOQFLUSH_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t voqid                :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t tcontid              :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t openpktflushen       :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd3               : 14 ;
    ca_uint32_t start                :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_VOQFLUSH_t;


#define PUC_VOQDROP                              0xd00380b0
#define PUC_VOQDROP_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t voqid                :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t enable               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_VOQDROP_t;


#define PUC_BPCNTL                               0xd00380b4
#define PUC_BPCNTL_dft                           0x02000000

typedef volatile union {
  struct {
    ca_uint32_t bpen                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t dropen               :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd2               : 11 ;
    ca_uint32_t bpth                 : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd3               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} PUC_BPCNTL_t;


#define PUC_VOQBPREMAP_ACCESS                    0xd00380b8
#define PUC_VOQBPREMAP_ACCESS_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ADDR                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_VOQBPREMAP_ACCESS_t;


#define PUC_VOQBPREMAP_DATA                      0xd00380bc
#define PUC_VOQBPREMAP_DATA_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tqmvoqid             :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} PUC_VOQBPREMAP_DATA_t;


#define PUC_PONCNTL_INTERRUPT                    0xd00380c0
#define PUC_PONCNTL_INTERRUPT_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bpmeminitdone_intI   :  1 ; /* bits 0:0 */
    ca_uint32_t voqflushdone_intI    :  1 ; /* bits 1:1 */
    ca_uint32_t gnttoosmall_intI     :  1 ; /* bits 2:2 */
    ca_uint32_t opm_correctedeccerr_intI :  1 ; /* bits 3:3 */
    ca_uint32_t lfram_correctedeccerr_intI :  1 ; /* bits 4:4 */
    ca_uint32_t tqm_correctedeccerr_intI :  1 ; /* bits 5:5 */
    ca_uint32_t bcm_correctedeccerr_intI :  1 ; /* bits 6:6 */
    ca_uint32_t pllm_correctedeccerr_intI :  1 ; /* bits 7:7 */
    ca_uint32_t bpmem_correctedeccerr_intI :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t bmc_pe_fifo_overflow_intI :  1 ; /* bits 16:16 */
    ca_uint32_t bmc_data_fifo_overflow_intI :  1 ; /* bits 17:17 */
    ca_uint32_t bmc_front_fifo_overflow_intI :  1 ; /* bits 18:18 */
    ca_uint32_t bmc_rx_err_pkt_intI  :  1 ; /* bits 19:19 */
    ca_uint32_t bmc_length_err_pkt_intI :  1 ; /* bits 20:20 */
    ca_uint32_t rsrvd2               :  5 ;
    ca_uint32_t opm_eccerr_intI      :  1 ; /* bits 26:26 */
    ca_uint32_t lfram_eccerr_intI    :  1 ; /* bits 27:27 */
    ca_uint32_t tqm_eccerr_intI      :  1 ; /* bits 28:28 */
    ca_uint32_t bcm_eccerr_intI      :  1 ; /* bits 29:29 */
    ca_uint32_t pllm_eccerr_intI     :  1 ; /* bits 30:30 */
    ca_uint32_t bpmem_eccerr_intI    :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_PONCNTL_INTERRUPT_t;


#define PUC_PONCNTL_INTENABLE                    0xd00380c4
#define PUC_PONCNTL_INTENABLE_dft                0xfc1f01fa

typedef volatile union {
  struct {
    ca_uint32_t bpmeminitdone_intE   :  1 ; /* bits 0:0 */
    ca_uint32_t voqflushdone_intE    :  1 ; /* bits 1:1 */
    ca_uint32_t gnttoosmall_intE     :  1 ; /* bits 2:2 */
    ca_uint32_t opm_correctedeccerr_intE :  1 ; /* bits 3:3 */
    ca_uint32_t lfram_correctedeccerr_intE :  1 ; /* bits 4:4 */
    ca_uint32_t tqm_correctedeccerr_intE :  1 ; /* bits 5:5 */
    ca_uint32_t bcm_correctedeccerr_intE :  1 ; /* bits 6:6 */
    ca_uint32_t pllm_correctedeccerr_intE :  1 ; /* bits 7:7 */
    ca_uint32_t bpmem_correctedeccerr_intE :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t bmc_pe_fifo_overflow_intE :  1 ; /* bits 16:16 */
    ca_uint32_t bmc_data_fifo_overflow_intE :  1 ; /* bits 17:17 */
    ca_uint32_t bmc_front_fifo_overflow_intE :  1 ; /* bits 18:18 */
    ca_uint32_t bmc_rx_err_pkt_intE  :  1 ; /* bits 19:19 */
    ca_uint32_t bmc_length_err_pkt_intE :  1 ; /* bits 20:20 */
    ca_uint32_t rsrvd2               :  5 ;
    ca_uint32_t opm_eccerr_intE      :  1 ; /* bits 26:26 */
    ca_uint32_t lfram_eccerr_intE    :  1 ; /* bits 27:27 */
    ca_uint32_t tqm_eccerr_intE      :  1 ; /* bits 28:28 */
    ca_uint32_t bcm_eccerr_intE      :  1 ; /* bits 29:29 */
    ca_uint32_t pllm_eccerr_intE     :  1 ; /* bits 30:30 */
    ca_uint32_t bpmem_eccerr_intE    :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_PONCNTL_INTENABLE_t;


#define PUC_RPTADJCFG1                           0xd00380c8
#define PUC_RPTADJCFG1_dft                       0x00001000

typedef volatile union {
  struct {
    ca_uint32_t rptadjpid            :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t rptadjqnum           :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t rptadjqsnum          :  3 ; /* bits 14:12 */
    ca_uint32_t rsrvd3               :  9 ;
    ca_uint32_t rptgapcnten          :  1 ; /* bits 24:24 */
    ca_uint32_t rsrvd4               :  3 ;
    ca_uint32_t rptadjbuffullen      :  1 ; /* bits 28:28 */
    ca_uint32_t rsrvd5               :  2 ;
    ca_uint32_t rptadjunibursten     :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_RPTADJCFG1_t;


#define PUC_RPTADJCFG2                           0xd00380cc
#define PUC_RPTADJCFG2_dft                       0x09c40040

typedef volatile union {
  struct {
    ca_uint32_t rptadjfbloth         : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t rptadjval10us        : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_RPTADJCFG2_t;


#define PUC_RPTADJCFG3                           0xd00380d0
#define PUC_RPTADJCFG3_dft                       0x7a1230d4

typedef volatile union {
  struct {
    ca_uint32_t rptadjval100us       : 16 ; /* bits 15:0 */
    ca_uint32_t rptadjval500us       : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_RPTADJCFG3_t;


#define PUC_RPTGAPVAL                            0xd00380d4
#define PUC_RPTGAPVAL_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rptgapval            : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} PUC_RPTGAPVAL_t;


#define PUC_PKGBGNTINFO                          0xd00380d8
#define PUC_PKGBGNTINFO_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dbawindowcntr        : 16 ; /* bits 15:0 */
    ca_uint32_t gntmismatchcntr      : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_PKGBGNTINFO_t;


#define PUC_MICROSECCLKCNT                       0xd00380dc
#define PUC_MICROSECCLKCNT_dft                   0x0000014d

typedef volatile union {
  struct {
    ca_uint32_t microsecclkcnt       :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} PUC_MICROSECCLKCNT_t;


#define PUC_BMDBGFBCNT                           0xd00380e0
#define PUC_BMDBGFBCNT_dft                       0x40004000

typedef volatile union {
  struct {
    ca_uint32_t fbpacnt              : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t fbpbcnt              : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} PUC_BMDBGFBCNT_t;


#define PUC_BMDBGFBPA                            0xd00380e4
#define PUC_BMDBGFBPA_dft                        0x00004000

typedef volatile union {
  struct {
    ca_uint32_t fbcnta               : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t fbphptra             : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} PUC_BMDBGFBPA_t;


#define PUC_BMDBGFBPB                            0xd00380e8
#define PUC_BMDBGFBPB_dft                        0x00004000

typedef volatile union {
  struct {
    ca_uint32_t fbcntb               : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t fbphptrb             : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} PUC_BMDBGFBPB_t;


#define PUC_BTCDBG1                              0xd00380ec
#define PUC_BTCDBG1_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pmacschreqcnt        : 16 ; /* bits 15:0 */
    ca_uint32_t pucschdonecnt        : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_BTCDBG1_t;


#define PUC_BTCDBG2                              0xd00380f0
#define PUC_BTCDBG2_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pmacschsize          : 21 ; /* bits 20:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t pmacschpid           :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd2               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} PUC_BTCDBG2_t;


#define PUC_BTCDBG3                              0xd00380f4
#define PUC_BTCDBG3_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t btcstate             :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} PUC_BTCDBG3_t;


#define PUC_DQMDBG1                              0xd00380f8
#define PUC_DQMDBG1_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pucsobcnt            : 16 ; /* bits 15:0 */
    ca_uint32_t puceobcnt            : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_DQMDBG1_t;


#define PUC_DQMDBG2                              0xd00380fc
#define PUC_DQMDBG2_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pucsofcnt            : 16 ; /* bits 15:0 */
    ca_uint32_t puceofcnt            : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_DQMDBG2_t;


#define PUC_DQMDBG3                              0xd0038100
#define PUC_DQMDBG3_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pucpid               :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t pmacpucrdy           :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd2               :  8 ;
    ca_uint32_t dqrffull             :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd3               :  7 ;
    ca_uint32_t lfdepth              :  7 ; /* bits 30:24 */
    ca_uint32_t rsrvd4               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} PUC_DQMDBG3_t;


#define PUC_RPCDBG1                              0xd0038104
#define PUC_RPCDBG1_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pmacrptreqcnt        : 16 ; /* bits 15:0 */
    ca_uint32_t pucrptdonecnt        : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_RPCDBG1_t;


#define PUC_RPCDBG2                              0xd0038108
#define PUC_RPCDBG2_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rpcstate             :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 11 ;
    ca_uint32_t pmacrptpid           :  5 ; /* bits 20:16 */
    ca_uint32_t rsrvd2               : 11 ;
  } bf ;
  ca_uint32_t     wrd ;
} PUC_RPCDBG2_t;


#define PUC_CTRL                                 0xd003810c
#define PUC_CTRL_dft                             0x3000007c

typedef volatile union {
  struct {
    ca_uint32_t pkt_mode_class0_cnt  :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t pkt_mode_class1_cnt  :  7 ; /* bits 14:8 */
    ca_uint32_t rsrvd2               : 12 ;
    ca_uint32_t force_init_done      :  1 ; /* bits 27:27 */
    ca_uint32_t addtok_en            :  1 ; /* bits 28:28 */
    ca_uint32_t subtok_en            :  1 ; /* bits 29:29 */
    ca_uint32_t shp_en               :  1 ; /* bits 30:30 */
    ca_uint32_t rsrvd3               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} PUC_CTRL_t;


#define PUC_STS                                  0xd0038110
#define PUC_STS_dft                              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t shp_fifo_overflow    :  1 ; /* bits 1:1 */
    ca_uint32_t shp_fifo_empty       :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd2               : 28 ;
    ca_uint32_t shp_init_done        :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_STS_t;


#define PUC_GLOBAL_DA_SA2                        0xd0038114
#define PUC_GLOBAL_DA_SA2_dft                    0x00132500

typedef volatile union {
  struct {
    ca_uint32_t dasa2                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_GLOBAL_DA_SA2_t;


#define PUC_GLOBAL_DA_SA1                        0xd0038118
#define PUC_GLOBAL_DA_SA1_dft                    0x00000013

typedef volatile union {
  struct {
    ca_uint32_t dasa1                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_GLOBAL_DA_SA1_t;


#define PUC_GLOBAL_DA_SA0                        0xd003811c
#define PUC_GLOBAL_DA_SA0_dft                    0x25000001

typedef volatile union {
  struct {
    ca_uint32_t dasa0                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_GLOBAL_DA_SA0_t;


#define PUC_GLOBAL_MAC_TYPE                      0xd0038120
#define PUC_GLOBAL_MAC_TYPE_dft                  0xfff00000

typedef volatile union {
  struct {
    ca_uint32_t type                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_GLOBAL_MAC_TYPE_t;


#define PUC_GLOBAL_LNK_TYPE                      0xd0038124
#define PUC_GLOBAL_LNK_TYPE_dft                  0xfff10000

typedef volatile union {
  struct {
    ca_uint32_t type                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_GLOBAL_LNK_TYPE_t;


#define PUC_US_OMCI_HDR_A_CFG                    0xd0038128
#define PUC_US_OMCI_HDR_A_CFG_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gemid_replacement    :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t cos_replacement      :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd2               :  5 ;
    ca_uint32_t tcont_replacement    :  6 ; /* bits 21:16 */
    ca_uint32_t rsrvd3               :  8 ;
    ca_uint32_t enable_data_pkt_replacement :  1 ; /* bits 30:30 */
    ca_uint32_t enable_replacement   :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_US_OMCI_HDR_A_CFG_t;


#define PUC_US_OMCI_HP_HDR_A_CFG                 0xd003812c
#define PUC_US_OMCI_HP_HDR_A_CFG_dft             0x00000101

typedef volatile union {
  struct {
    ca_uint32_t gemid_replacement    :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t cos_replacement      :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd2               :  5 ;
    ca_uint32_t tcont_replacement    :  6 ; /* bits 21:16 */
    ca_uint32_t rsrvd3               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} PUC_US_OMCI_HP_HDR_A_CFG_t;


#define PUC_GLOBAL_PLOAM_CFG                     0xd0038130
#define PUC_GLOBAL_PLOAM_CFG_dft                 0x00000760

typedef volatile union {
  struct {
    ca_uint32_t us_ploam_msg_gen_en  :  1 ; /* bits 0:0 */
    ca_uint32_t ds_ploam_pkt_gen_en  :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t us_ploam_omci_hdr_a_compare_en :  1 ; /* bits 3:3 */
    ca_uint32_t us_omci_hdr_a_field  :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t us_ploam_hdr_a_field :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd3               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} PUC_GLOBAL_PLOAM_CFG_t;


#define PUC_DS_PLOAM_HDR_A_CFG1                  0xd0038134
#define PUC_DS_PLOAM_HDR_A_CFG1_dft              0x00002000

typedef volatile union {
  struct {
    ca_uint32_t data1                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_DS_PLOAM_HDR_A_CFG1_t;


#define PUC_DS_PLOAM_HDR_A_CFG0                  0xd0038138
#define PUC_DS_PLOAM_HDR_A_CFG0_dft              0x00220e37

typedef volatile union {
  struct {
    ca_uint32_t data0                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_DS_PLOAM_HDR_A_CFG0_t;


#define PUC_BMC_CONTROL_PKT_CNTR_mac             0xd003813c
#define PUC_BMC_CONTROL_PKT_CNTR_mac_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cntr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PUC_BMC_CONTROL_PKT_CNTR_mac_t;


#define PUC_BMC_CONTROL_PKT_CNTR_lnk             0xd0038140
#define PUC_BMC_CONTROL_PKT_CNTR_lnk_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cntr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PUC_BMC_CONTROL_PKT_CNTR_lnk_t;


#define PUC_BMC_RX_PKT                           0xd0038144
#define PUC_BMC_RX_PKT_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ni_cntr              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_BMC_RX_PKT_t;


#define PUC_BMC_RX_PKT_enq                       0xd0038148
#define PUC_BMC_RX_PKT_enq_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cntr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_BMC_RX_PKT_enq_t;


#define PUC_BMC_FORCE_DROP                       0xd003814c
#define PUC_BMC_FORCE_DROP_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cntr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PUC_BMC_FORCE_DROP_t;


#define PUC_BMC_LENGTH_ERROR                     0xd0038150
#define PUC_BMC_LENGTH_ERROR_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cntr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PUC_BMC_LENGTH_ERROR_t;


#define PUC_BMC_DEBUG                            0xd0038154
#define PUC_BMC_DEBUG_dft                        0x00014000

typedef volatile union {
  struct {
    ca_uint32_t pe_status            : 16 ; /* bits 15:0 */
    ca_uint32_t intf_status          :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} PUC_BMC_DEBUG_t;


#define PUC_BMC_FIFO_STS                         0xd0038158
#define PUC_BMC_FIFO_STS_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t intf_fifo_depth      :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t intf_fifo_overflow   :  1 ; /* bits 6:6 */
    ca_uint32_t intf_fifo_front_overflow :  1 ; /* bits 7:7 */
    ca_uint32_t intf_fifo_front_depth :  4 ; /* bits 11:8 */
    ca_uint32_t wqf_data_fifo_depth  :  4 ; /* bits 15:12 */
    ca_uint32_t buf_link_fifo_depth  :  4 ; /* bits 19:16 */
    ca_uint32_t wqf_cmd_fifo_depth   :  3 ; /* bits 22:20 */
    ca_uint32_t rqf_cmd_fifo_depth   :  3 ; /* bits 25:23 */
    ca_uint32_t bmc_pe               :  6 ; /* bits 31:26 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_BMC_FIFO_STS_t;


#define PUC_BMC_PKT_HDR1                         0xd003815c
#define PUC_BMC_PKT_HDR1_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hdr_a1               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_BMC_PKT_HDR1_t;


#define PUC_BMC_PKT_HDR0                         0xd0038160
#define PUC_BMC_PKT_HDR0_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hdr_a0               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_BMC_PKT_HDR0_t;


#define PUC_BMC_MTU                              0xd0038164
#define PUC_BMC_MTU_dft                          0x00002ee0

typedef volatile union {
  struct {
    ca_uint32_t size                 : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PUC_BMC_MTU_t;


#define PUC_VOQ_TBC_MEM_ACCESS                   0xd0038168
#define PUC_VOQ_TBC_MEM_ACCESS_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_VOQ_TBC_MEM_ACCESS_t;


#define PUC_VOQ_TBC_MEM_DATA1                    0xd003816c
#define PUC_VOQ_TBC_MEM_DATA1_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bs                   :  6 ; /* bits 5:0 */
    ca_uint32_t enb                  :  2 ; /* bits 7:6 */
    ca_uint32_t mode                 :  1 ; /* bits 8:8 */
    ca_uint32_t tbc                  : 21 ; /* bits 29:9 */
    ca_uint32_t pkt_mode_class_sel   :  1 ; /* bits 30:30 */
    ca_uint32_t rsrvd1               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} PUC_VOQ_TBC_MEM_DATA1_t;


#define PUC_VOQ_TBC_MEM_DATA0                    0xd0038170
#define PUC_VOQ_TBC_MEM_DATA0_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rate_k               : 10 ; /* bits 9:0 */
    ca_uint32_t rate_m               : 16 ; /* bits 25:10 */
    ca_uint32_t bs                   :  6 ; /* bits 31:26 */
  } bf ;
  ca_uint32_t     wrd ;
} PUC_VOQ_TBC_MEM_DATA0_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PUC */
typedef struct {
  PUC_PVTBL_ACCESS_t                       PVTBL_ACCESS;                  /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  PUC_PVTBL_DATA4_t                        PVTBL_DATA4;                   /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  PUC_PVTBL_DATA3_t                        PVTBL_DATA3;                   /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  PUC_PVTBL_DATA2_t                        PVTBL_DATA2;                   /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  PUC_PVTBL_DATA1_t                        PVTBL_DATA1;                   /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  PUC_PVTBL_DATA0_t                        PVTBL_DATA0;                   /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  PUC_HPMEM_ACCESS_t                       HPMEM_ACCESS;                  /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  PUC_HPMEM_DATA_t                         HPMEM_DATA;                    /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  PUC_BCMEM_ACCESS_t                       BCMEM_ACCESS;                  /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  PUC_BCMEM_DATA1_t                        BCMEM_DATA1;                   /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  PUC_BCMEM_DATA0_t                        BCMEM_DATA0;                   /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  PUC_TQMEM_ACCESS_t                       TQMEM_ACCESS;                  /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  PUC_TQMEM_DATA1_t                        TQMEM_DATA1;                   /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  PUC_TQMEM_DATA0_t                        TQMEM_DATA0;                   /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  PUC_OPMEM_ACCESS_t                       OPMEM_ACCESS;                  /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  PUC_OPMEM_DATA_t                         OPMEM_DATA;                    /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  PUC_BPMEM_ACCESS_t                       BPMEM_ACCESS;                  /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  PUC_BPMEM_DATA_t                         BPMEM_DATA;                    /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  PUC_VOQSCHCFG_t                          VOQSCHCFG;                     /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  PUC_VOQMAPCFG_t                          VOQMAPCFG;                     /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  PUC_BTCCFG_t                             BTCCFG;                        /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  PUC_RPTCFG_t                             RPTCFG;                        /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  PUC_NTTCFG_t                             NTTCFG;                        /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  PUC_PVTCFG_t                             PVTCFG;                        /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  PUC_VSTBL_ACCESS_t                       VSTBL_ACCESS;                  /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  PUC_VSTBL_DATA4_t                        VSTBL_DATA4;                   /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  PUC_VSTBL_DATA3_t                        VSTBL_DATA3;                   /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  PUC_VSTBL_DATA2_t                        VSTBL_DATA2;                   /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  PUC_VSTBL_DATA1_t                        VSTBL_DATA1;                   /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  PUC_VSTBL_DATA0_t                        VSTBL_DATA0;                   /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  PUC_RPTQSCFG12_t                         RPTQSCFG12;                    /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  PUC_RPTQSCFG23_t                         RPTQSCFG23;                    /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  PUC_SLLIDVOQ74CFG_t                      SLLIDVOQ74CFG;                 /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  PUC_SLLIDVOQ30CFG_t                      SLLIDVOQ30CFG;                 /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  PUC_BMSTS_t                              BMSTS;                         /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  PUC_PUCCFG_t                             PUCCFG;                        /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  PUC_VOQBUFLIMITSEL1500_t                 VOQBUFLIMITSEL1500;            /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  PUC_VOQBUFLIMITSEL3116_t                 VOQBUFLIMITSEL3116;            /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  PUC_VOQBUFLIMITSEL4732_t                 VOQBUFLIMITSEL4732;            /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];                   
  PUC_VOQBUFLIMITSEL6348_t                 VOQBUFLIMITSEL6348;            /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];                   
  PUC_VOQBUFLIMIT_A_t                      VOQBUFLIMIT_A;                 /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];                   
  PUC_VOQBUFLIMIT_B_t                      VOQBUFLIMIT_B;                 /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];                   
  PUC_VOQBUFLIMIT_C_t                      VOQBUFLIMIT_C;                 /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];                   
  PUC_VOQFLUSH_t                           VOQFLUSH;                      /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd44[3];                   
  PUC_VOQDROP_t                            VOQDROP;                       /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd45[3];                   
  PUC_BPCNTL_t                             BPCNTL;                        /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd46[3];                   
  PUC_VOQBPREMAP_ACCESS_t                  VOQBPREMAP_ACCESS;             /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd47[3];                   
  PUC_VOQBPREMAP_DATA_t                    VOQBPREMAP_DATA;               /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd48[3];                   
  PUC_PONCNTL_INTERRUPT_t                  PONCNTL_INTERRUPT;             /* addr: 0x000000c0 */
  ca_uint32_t                              rsrvd49[3];                   
  PUC_PONCNTL_INTENABLE_t                  PONCNTL_INTENABLE;             /* addr: 0x000000c4 */
  ca_uint32_t                              rsrvd50[3];                   
  PUC_RPTADJCFG1_t                         RPTADJCFG1;                    /* addr: 0x000000c8 */
  ca_uint32_t                              rsrvd51[3];                   
  PUC_RPTADJCFG2_t                         RPTADJCFG2;                    /* addr: 0x000000cc */
  ca_uint32_t                              rsrvd52[3];                   
  PUC_RPTADJCFG3_t                         RPTADJCFG3;                    /* addr: 0x000000d0 */
  ca_uint32_t                              rsrvd53[3];                   
  PUC_RPTGAPVAL_t                          RPTGAPVAL;                     /* addr: 0x000000d4 */
  ca_uint32_t                              rsrvd54[3];                   
  PUC_PKGBGNTINFO_t                        PKGBGNTINFO;                   /* addr: 0x000000d8 */
  ca_uint32_t                              rsrvd55[3];                   
  PUC_MICROSECCLKCNT_t                     MICROSECCLKCNT;                /* addr: 0x000000dc */
  ca_uint32_t                              rsrvd56[3];                   
  PUC_BMDBGFBCNT_t                         BMDBGFBCNT;                    /* addr: 0x000000e0 */
  ca_uint32_t                              rsrvd57[3];                   
  PUC_BMDBGFBPA_t                          BMDBGFBPA;                     /* addr: 0x000000e4 */
  ca_uint32_t                              rsrvd58[3];                   
  PUC_BMDBGFBPB_t                          BMDBGFBPB;                     /* addr: 0x000000e8 */
  ca_uint32_t                              rsrvd59[3];                   
  PUC_BTCDBG1_t                            BTCDBG1;                       /* addr: 0x000000ec */
  ca_uint32_t                              rsrvd60[3];                   
  PUC_BTCDBG2_t                            BTCDBG2;                       /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd61[3];                   
  PUC_BTCDBG3_t                            BTCDBG3;                       /* addr: 0x000000f4 */
  ca_uint32_t                              rsrvd62[3];                   
  PUC_DQMDBG1_t                            DQMDBG1;                       /* addr: 0x000000f8 */
  ca_uint32_t                              rsrvd63[3];                   
  PUC_DQMDBG2_t                            DQMDBG2;                       /* addr: 0x000000fc */
  ca_uint32_t                              rsrvd64[3];                   
  PUC_DQMDBG3_t                            DQMDBG3;                       /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd65[3];                   
  PUC_RPCDBG1_t                            RPCDBG1;                       /* addr: 0x00000104 */
  ca_uint32_t                              rsrvd66[3];                   
  PUC_RPCDBG2_t                            RPCDBG2;                       /* addr: 0x00000108 */
  ca_uint32_t                              rsrvd67[3];                   
  PUC_CTRL_t                               CTRL;                          /* addr: 0x0000010c */
  ca_uint32_t                              rsrvd68[3];                   
  PUC_STS_t                                STS;                           /* addr: 0x00000110 */
  ca_uint32_t                              rsrvd69[3];                   
  PUC_GLOBAL_DA_SA2_t                      GLOBAL_DA_SA2;                 /* addr: 0x00000114 */
  ca_uint32_t                              rsrvd70[3];                   
  PUC_GLOBAL_DA_SA1_t                      GLOBAL_DA_SA1;                 /* addr: 0x00000118 */
  ca_uint32_t                              rsrvd71[3];                   
  PUC_GLOBAL_DA_SA0_t                      GLOBAL_DA_SA0;                 /* addr: 0x0000011c */
  ca_uint32_t                              rsrvd72[3];                   
  PUC_GLOBAL_MAC_TYPE_t                    GLOBAL_MAC_TYPE;               /* addr: 0x00000120 */
  ca_uint32_t                              rsrvd73[3];                   
  PUC_GLOBAL_LNK_TYPE_t                    GLOBAL_LNK_TYPE;               /* addr: 0x00000124 */
  ca_uint32_t                              rsrvd74[3];                   
  PUC_US_OMCI_HDR_A_CFG_t                  US_OMCI_HDR_A_CFG;             /* addr: 0x00000128 */
  ca_uint32_t                              rsrvd75[3];                   
  PUC_US_OMCI_HP_HDR_A_CFG_t               US_OMCI_HP_HDR_A_CFG;          /* addr: 0x0000012c */
  ca_uint32_t                              rsrvd76[3];                   
  PUC_GLOBAL_PLOAM_CFG_t                   GLOBAL_PLOAM_CFG;              /* addr: 0x00000130 */
  ca_uint32_t                              rsrvd77[3];                   
  PUC_DS_PLOAM_HDR_A_CFG1_t                DS_PLOAM_HDR_A_CFG1;           /* addr: 0x00000134 */
  ca_uint32_t                              rsrvd78[3];                   
  PUC_DS_PLOAM_HDR_A_CFG0_t                DS_PLOAM_HDR_A_CFG0;           /* addr: 0x00000138 */
  ca_uint32_t                              rsrvd79[3];                   
  PUC_BMC_CONTROL_PKT_CNTR_mac_t           BMC_CONTROL_PKT_CNTR_mac;      /* addr: 0x0000013c */
  ca_uint32_t                              rsrvd80[3];                   
  PUC_BMC_CONTROL_PKT_CNTR_lnk_t           BMC_CONTROL_PKT_CNTR_lnk;      /* addr: 0x00000140 */
  ca_uint32_t                              rsrvd81[3];                   
  PUC_BMC_RX_PKT_t                         BMC_RX_PKT;                    /* addr: 0x00000144 */
  ca_uint32_t                              rsrvd82[3];                   
  PUC_BMC_RX_PKT_enq_t                     BMC_RX_PKT_enq;                /* addr: 0x00000148 */
  ca_uint32_t                              rsrvd83[3];                   
  PUC_BMC_FORCE_DROP_t                     BMC_FORCE_DROP;                /* addr: 0x0000014c */
  ca_uint32_t                              rsrvd84[3];                   
  PUC_BMC_LENGTH_ERROR_t                   BMC_LENGTH_ERROR;              /* addr: 0x00000150 */
  ca_uint32_t                              rsrvd85[3];                   
  PUC_BMC_DEBUG_t                          BMC_DEBUG;                     /* addr: 0x00000154 */
  ca_uint32_t                              rsrvd86[3];                   
  PUC_BMC_FIFO_STS_t                       BMC_FIFO_STS;                  /* addr: 0x00000158 */
  ca_uint32_t                              rsrvd87[3];                   
  PUC_BMC_PKT_HDR1_t                       BMC_PKT_HDR1;                  /* addr: 0x0000015c */
  ca_uint32_t                              rsrvd88[3];                   
  PUC_BMC_PKT_HDR0_t                       BMC_PKT_HDR0;                  /* addr: 0x00000160 */
  ca_uint32_t                              rsrvd89[3];                   
  PUC_BMC_MTU_t                            BMC_MTU;                       /* addr: 0x00000164 */
  ca_uint32_t                              rsrvd90[3];                   
  PUC_VOQ_TBC_MEM_ACCESS_t                 VOQ_TBC_MEM_ACCESS;            /* addr: 0x00000168 */
  ca_uint32_t                              rsrvd91[3];                   
  PUC_VOQ_TBC_MEM_DATA1_t                  VOQ_TBC_MEM_DATA1;             /* addr: 0x0000016c */
  ca_uint32_t                              rsrvd92[3];                   
  PUC_VOQ_TBC_MEM_DATA0_t                  VOQ_TBC_MEM_DATA0;             /* addr: 0x00000170 */
} APB1_PUC_t;


/*
 * PDC
 */
        
#define PDC_CNTR_CFG                             0xd0039000
#define PDC_CNTR_CFG_dft                         0x00000004

typedef volatile union {
  struct {
    ca_uint32_t inccfg               :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} PDC_CNTR_CFG_t;


#define PDC_PKT_CNTR                             0xd0039004
#define PDC_PKT_CNTR_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cntr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PDC_PKT_CNTR_t;


#define PDC_ERR_PKT_CNTR                         0xd0039008
#define PDC_ERR_PKT_CNTR_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cntr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PDC_ERR_PKT_CNTR_t;


#define PDC_SPARE                                0xd003900c
#define PDC_SPARE_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t spare                : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PDC_SPARE_t;


#define PDC_FIFO_STATUS                          0xd0039010
#define PDC_FIFO_STATUS_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t depth                :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  9 ;
    ca_uint32_t over_flow            :  1 ; /* bits 14:14 */
    ca_uint32_t map_fifo_over_flow   :  1 ; /* bits 15:15 */
    ca_uint32_t spare                : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} PDC_FIFO_STATUS_t;


#define PDC_CTRL                                 0xd0039014
#define PDC_CTRL_dft                             0x00000002

typedef volatile union {
  struct {
    ca_uint32_t nocrc_insert         :  1 ; /* bits 0:0 */
    ca_uint32_t pdc_map_mem_en       :  1 ; /* bits 1:1 */
    ca_uint32_t epon_insert_16byte_hdr :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} PDC_CTRL_t;


#define PDC_CONTROL_PKT_CNTR_mac                 0xd0039018
#define PDC_CONTROL_PKT_CNTR_mac_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac_layer            : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PDC_CONTROL_PKT_CNTR_mac_t;


#define PDC_CONTROL_PKT_CNTR_lnk                 0xd003901c
#define PDC_CONTROL_PKT_CNTR_lnk_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t link_layer           : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PDC_CONTROL_PKT_CNTR_lnk_t;


#define PDC_PDC_MAP_MEM_ACCESS                   0xd0039020
#define PDC_PDC_MAP_MEM_ACCESS_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} PDC_PDC_MAP_MEM_ACCESS_t;


#define PDC_PDC_MAP_MEM_DATA1                    0xd0039024
#define PDC_PDC_MAP_MEM_DATA1_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mirror               :  1 ; /* bits 0:0 */
    ca_uint32_t mark                 :  1 ; /* bits 1:1 */
    ca_uint32_t pol_en               :  2 ; /* bits 3:2 */
    ca_uint32_t pol_id               :  9 ; /* bits 12:4 */
    ca_uint32_t pol_grp_id           :  3 ; /* bits 15:13 */
    ca_uint32_t deepq                :  1 ; /* bits 16:16 */
    ca_uint32_t cpu_flag             :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} PDC_PDC_MAP_MEM_DATA1_t;


#define PDC_PDC_MAP_MEM_DATA0                    0xd0039028
#define PDC_PDC_MAP_MEM_DATA0_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cos                  :  3 ; /* bits 2:0 */
    ca_uint32_t ldpid                :  6 ; /* bits 8:3 */
    ca_uint32_t lspid                :  6 ; /* bits 14:9 */
    ca_uint32_t fe_bypass            :  1 ; /* bits 15:15 */
    ca_uint32_t hdr_type             :  2 ; /* bits 17:16 */
    ca_uint32_t mcgid                :  8 ; /* bits 25:18 */
    ca_uint32_t drop_code            :  3 ; /* bits 28:26 */
    ca_uint32_t rx_pkt_type          :  2 ; /* bits 30:29 */
    ca_uint32_t no_drop              :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} PDC_PDC_MAP_MEM_DATA0_t;


#define PDC_DEBUG_CTRL                           0xd003902c
#define PDC_DEBUG_CTRL_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sel                  :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} PDC_DEBUG_CTRL_t;


#define PDC_DEBUG_STATUS                         0xd0039030
#define PDC_DEBUG_STATUS_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PDC_DEBUG_STATUS_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PDC */
typedef struct {
  PDC_CNTR_CFG_t                           CNTR_CFG;                      /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  PDC_PKT_CNTR_t                           PKT_CNTR;                      /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  PDC_ERR_PKT_CNTR_t                       ERR_PKT_CNTR;                  /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  PDC_SPARE_t                              SPARE;                         /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  PDC_FIFO_STATUS_t                        FIFO_STATUS;                   /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  PDC_CTRL_t                               CTRL;                          /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  PDC_CONTROL_PKT_CNTR_mac_t               CONTROL_PKT_CNTR_mac;          /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  PDC_CONTROL_PKT_CNTR_lnk_t               CONTROL_PKT_CNTR_lnk;          /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  PDC_PDC_MAP_MEM_ACCESS_t                 PDC_MAP_MEM_ACCESS;            /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  PDC_PDC_MAP_MEM_DATA1_t                  PDC_MAP_MEM_DATA1;             /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  PDC_PDC_MAP_MEM_DATA0_t                  PDC_MAP_MEM_DATA0;             /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  PDC_DEBUG_CTRL_t                         DEBUG_CTRL;                    /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  PDC_DEBUG_STATUS_t                       DEBUG_STATUS;                  /* addr: 0x00000030 */
} APB1_PDC_t;


/*
 * PSDS_WRAP
 */
        
#define PSDS_RG00                                0xd003a000
#define PSDS_RG00_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t REG_CKREF_TEST_EN    :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG00_t;


#define PSDS_RG01                                0xd003a004
#define PSDS_RG01_dft                            0x00001444

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t REG_SEL_IBLPF_CMU_LC :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t REG0_CMU_RSEL        :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t REG_VSEL_LREG        :  3 ; /* bits 10:8 */
    ca_uint32_t REG_EN_LDO_1p1V      :  1 ; /* bits 11:11 */
    ca_uint32_t REG_VSEL_LREGD       :  3 ; /* bits 14:12 */
    ca_uint32_t REG_LREGD_SEL_VREF   :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd4               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG01_t;


#define PSDS_RG02                                0xd003a008
#define PSDS_RG02_dft                            0x0000080d

typedef volatile union {
  struct {
    ca_uint32_t REG_CMU_ICP_SEL      :  5 ; /* bits 4:0 */
    ca_uint32_t REG_ICP_SEL_LBW      :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t REG_CMU_SEL_R        :  4 ; /* bits 11:8 */
    ca_uint32_t REG_CMU_LPF_CPSEL    :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t REG_PI_IBSEL         :  2 ; /* bits 15:14 */
    ca_uint32_t rsrvd3               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG02_t;


#define PSDS_RG03                                0xd003a00c
#define PSDS_RG03_dft                            0x00001017

typedef volatile union {
  struct {
    ca_uint32_t REG_ISTANK_SEL       :  2 ; /* bits 1:0 */
    ca_uint32_t REG_CMU_LC_I_BOOST   :  2 ; /* bits 3:2 */
    ca_uint32_t REG_LCBIAS_LPF_EN    :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t REG_LCVCO_HSMODE     :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t REG_LCVCO_TR         :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd3               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG03_t;


#define PSDS_RG04                                0xd003a010
#define PSDS_RG04_dft                            0x0000444c

typedef volatile union {
  struct {
    ca_uint32_t REG_LOBUF_VCM_ST0    :  3 ; /* bits 2:0 */
    ca_uint32_t REG_CK_EN_S0         :  1 ; /* bits 3:3 */
    ca_uint32_t REG_LOBUF_VCM_ST1    :  3 ; /* bits 6:4 */
    ca_uint32_t REG_CK_EN_S1         :  1 ; /* bits 7:7 */
    ca_uint32_t REG_LOBUF_VCM_ST2    :  3 ; /* bits 10:8 */
    ca_uint32_t REG_CK_EN_S2         :  1 ; /* bits 11:11 */
    ca_uint32_t REG_LOBUF_VCM_ST3    :  3 ; /* bits 14:12 */
    ca_uint32_t REG_CK_EN_S3         :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG04_t;


#define PSDS_RG05                                0xd003a014
#define PSDS_RG05_dft                            0x0000328d

typedef volatile union {
  struct {
    ca_uint32_t REG_FLD_VREF_SEL     :  2 ; /* bits 1:0 */
    ca_uint32_t REG_FLD_DSEL         :  2 ; /* bits 3:2 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t REG_CMURX_RSEL       :  3 ; /* bits 7:5 */
    ca_uint32_t REG_CMU_LC_RESERVED  :  6 ; /* bits 13:8 */
    ca_uint32_t REG_CMU_LC_TESTEN    :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd2               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG05_t;


#define PSDS_RG06                                0xd003a018
#define PSDS_RG06_dft                            0x0000c921

typedef volatile union {
  struct {
    ca_uint32_t REG_CMU_cp_time      :  3 ; /* bits 2:0 */
    ca_uint32_t REG_CMU_cp_en_manual :  1 ; /* bits 3:3 */
    ca_uint32_t REG_CMU_calib_time   :  3 ; /* bits 6:4 */
    ca_uint32_t REG_CMU_calib_manual :  1 ; /* bits 7:7 */
    ca_uint32_t REG_CMU_init_time    :  3 ; /* bits 10:8 */
    ca_uint32_t REG_CMU_auto_mode    :  1 ; /* bits 11:11 */
    ca_uint32_t REG_CMU_adp_time     :  3 ; /* bits 14:12 */
    ca_uint32_t REG_CMU_AUTO_K       :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG06_t;


#define PSDS_RG07                                0xd003a01c
#define PSDS_RG07_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t REG_CMU_TBASE        : 12 ; /* bits 11:0 */
    ca_uint32_t REG_CMU_EN_SSC       :  1 ; /* bits 12:12 */
    ca_uint32_t REG_CMU_SSC_ORDER    :  1 ; /* bits 13:13 */
    ca_uint32_t REG_CMU_EN_CENTER_IN :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG07_t;


#define PSDS_RG08                                0xd003a020
#define PSDS_RG08_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t REG_CMU_STEP_IN      : 13 ; /* bits 12:0 */
    ca_uint32_t rsrvd1               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG08_t;


#define PSDS_RG09                                0xd003a024
#define PSDS_RG09_dft                            0x00000018

typedef volatile union {
  struct {
    ca_uint32_t REG_WD_ENABLE        :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t REG_TIME_RDY_CKOUT   :  2 ; /* bits 3:2 */
    ca_uint32_t REG_TIME0_CK         :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t REG_TIME2_RST_WIDTH  :  2 ; /* bits 9:8 */
    ca_uint32_t rsrvd3               :  2 ;
    ca_uint32_t REG_F390K            :  2 ; /* bits 13:12 */
    ca_uint32_t rsrvd4               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG09_t;


#define PSDS_RG0A                                0xd003a028
#define PSDS_RG0A_dft                            0x00005aa0

typedef volatile union {
  struct {
    ca_uint32_t REG0_OOBS_TYP        :  1 ; /* bits 0:0 */
    ca_uint32_t REG0_OOBS_VCM        :  2 ; /* bits 2:1 */
    ca_uint32_t REG0_OOBS_CALI       :  2 ; /* bits 4:3 */
    ca_uint32_t REG0_OOBS_SEN_VAL    :  5 ; /* bits 9:5 */
    ca_uint32_t REG0_LEON_CALI       :  2 ; /* bits 11:10 */
    ca_uint32_t REG0_LEON_RSSI_SEN   :  2 ; /* bits 13:12 */
    ca_uint32_t REG0_FIBER_CALI      :  2 ; /* bits 15:14 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG0A_t;


#define PSDS_RG0B                                0xd003a02c
#define PSDS_RG0B_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 15 ;
    ca_uint32_t REG0_OOBS_RXIDLE_MANUAL :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd2               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG0B_t;


#define PSDS_RG0C                                0xd003a030
#define PSDS_RG0C_dft                            0x00000002

typedef volatile union {
  struct {
    ca_uint32_t REG0_FORCE_SEN       :  1 ; /* bits 0:0 */
    ca_uint32_t REG0_FORCE_CAL       :  1 ; /* bits 1:1 */
    ca_uint32_t REG0_SAVE_VALUE_EN   :  1 ; /* bits 2:2 */
    ca_uint32_t REG0_OOBS_NSQDLY_SEL :  1 ; /* bits 3:3 */
    ca_uint32_t REG0_OOBS_FREQ_SEL   :  1 ; /* bits 4:4 */
    ca_uint32_t REG0_CALSEL          :  1 ; /* bits 5:5 */
    ca_uint32_t REG0_CALRSETI        :  5 ; /* bits 10:6 */
    ca_uint32_t REG0_CALNSETI        :  5 ; /* bits 15:11 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG0C_t;


#define PSDS_RG0D                                0xd003a034
#define PSDS_RG0D_dft                            0x00000005

typedef volatile union {
  struct {
    ca_uint32_t REG0_AGC_CTRL        :  3 ; /* bits 2:0 */
    ca_uint32_t REG0_AGC_LOOP_SEL    :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t REG0_IBRX_ADJ        :  2 ; /* bits 9:8 */
    ca_uint32_t REG0_IBRX_LEQ_BOOST  :  1 ; /* bits 10:10 */
    ca_uint32_t REG0_IBRX_DFE_BOOST  :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd2               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG0D_t;


#define PSDS_RG0E                                0xd003a038
#define PSDS_RG0E_dft                            0x00001c03

typedef volatile union {
  struct {
    ca_uint32_t REG0_LEQ_DC_GAIN     :  5 ; /* bits 4:0 */
    ca_uint32_t REG0_LEQ_DC_GAIN_BOOST :  2 ; /* bits 6:5 */
    ca_uint32_t REG0_LEQ_ACTYPE_SEL  :  1 ; /* bits 7:7 */
    ca_uint32_t REG0_LEQ_I_ADJ       :  2 ; /* bits 9:8 */
    ca_uint32_t REG0_LEQ_R_SEL       :  2 ; /* bits 11:10 */
    ca_uint32_t REG0_IVGA_ADJ        :  2 ; /* bits 13:12 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG0E_t;


#define PSDS_RG0F                                0xd003a03c
#define PSDS_RG0F_dft                            0x00000002

typedef volatile union {
  struct {
    ca_uint32_t REG0_OFFSET_SEQ      :  1 ; /* bits 0:0 */
    ca_uint32_t REG0_EN_KOFFSET      :  1 ; /* bits 1:1 */
    ca_uint32_t REG0_OFFSET_RANGE    :  2 ; /* bits 3:2 */
    ca_uint32_t REG0_OFFSET_OK_MANUAL_EN :  1 ; /* bits 4:4 */
    ca_uint32_t REG0_OFFSET_OK_MANUAL :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG0F_t;


#define PSDS_RG10                                0xd003a040
#define PSDS_RG10_dft                            0x00004646

typedef volatile union {
  struct {
    ca_uint32_t REG0_PI_IBSEL        :  4 ; /* bits 3:0 */
    ca_uint32_t REG0_PI_CSEL         :  2 ; /* bits 5:4 */
    ca_uint32_t REG0_PI_BUF_IADJ     :  2 ; /* bits 7:6 */
    ca_uint32_t REG0_CDR2_PI_IBSEL   :  4 ; /* bits 11:8 */
    ca_uint32_t REG0_CDR2_PI_CSEL    :  2 ; /* bits 13:12 */
    ca_uint32_t REG0_CDR2_PI_BUF_IADJ :  2 ; /* bits 15:14 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG10_t;


#define PSDS_RG11                                0xd003a044
#define PSDS_RG11_dft                            0x00000006

typedef volatile union {
  struct {
    ca_uint32_t REG0_PI_EYE_IBSEL    :  4 ; /* bits 3:0 */
    ca_uint32_t REG0_PI_EYE_CSEL     :  2 ; /* bits 5:4 */
    ca_uint32_t REG0_EYE_SCAN_EN     :  1 ; /* bits 6:6 */
    ca_uint32_t REG0_EYE_CK_SEL      :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG11_t;


#define PSDS_RG12                                0xd003a048
#define PSDS_RG12_dft                            0x00004221

typedef volatile union {
  struct {
    ca_uint32_t REG0_RX_SEL_RXIDLE   :  1 ; /* bits 0:0 */
    ca_uint32_t REG0_RX_IDLE_SPD     :  1 ; /* bits 1:1 */
    ca_uint32_t REG0_RX_FREQDIV2_EN  :  1 ; /* bits 2:2 */
    ca_uint32_t REG0_RX_FORCERUN     :  1 ; /* bits 3:3 */
    ca_uint32_t REG0_RX_EN_SELF      :  1 ; /* bits 4:4 */
    ca_uint32_t REG0_RX_EN_INITCAL   :  1 ; /* bits 5:5 */
    ca_uint32_t REG0_RX_DFE_VTH_EXTEND :  1 ; /* bits 6:6 */
    ca_uint32_t REG0_RX_DEMUX_CLK_RST :  1 ; /* bits 7:7 */
    ca_uint32_t REG0_RX_DATA_PSAVE   :  1 ; /* bits 8:8 */
    ca_uint32_t REG0_RX_CLK_PSAVE    :  1 ; /* bits 9:9 */
    ca_uint32_t REG0_RSTB_BITERR_PRIORITY :  1 ; /* bits 10:10 */
    ca_uint32_t REG0_RESET_MANUAL    :  1 ; /* bits 11:11 */
    ca_uint32_t REG0_DLPFEN_MANUAL   :  1 ; /* bits 12:12 */
    ca_uint32_t REG0_CDR_RESET_SEL   :  1 ; /* bits 13:13 */
    ca_uint32_t REG0_CDR_DEC_RST_SEL :  1 ; /* bits 14:14 */
    ca_uint32_t REG0_125M_MODE       :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG12_t;


#define PSDS_RG13                                0xd003a04c
#define PSDS_RG13_dft                            0x00000002

typedef volatile union {
  struct {
    ca_uint32_t REG0_SD_POR_SEL      :  1 ; /* bits 0:0 */
    ca_uint32_t REG0_RX_SD_DEBOUNCE_SEL :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t REG0_RX_EN_TEST      :  1 ; /* bits 4:4 */
    ca_uint32_t REG0_RX_DBG_SEL      :  2 ; /* bits 6:5 */
    ca_uint32_t rsrvd2               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG13_t;


#define PSDS_RG14                                0xd003a050
#define PSDS_RG14_dft                            0x0000000f

typedef volatile union {
  struct {
    ca_uint32_t REG0_RESERVED_L      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG14_t;


#define PSDS_RG15                                0xd003a054
#define PSDS_RG15_dft                            0x0000003b

typedef volatile union {
  struct {
    ca_uint32_t REG0_RESERVED_H      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG15_t;


#define PSDS_RG16                                0xd003a058
#define PSDS_RG16_dft                            0x00000445

typedef volatile union {
  struct {
    ca_uint32_t REG0_DFE_IV33_ADJ    :  2 ; /* bits 1:0 */
    ca_uint32_t REG0_DFE_ICALI_ADJ   :  2 ; /* bits 3:2 */
    ca_uint32_t REG0_DFE_IEXT_LATCH_ADJ :  4 ; /* bits 7:4 */
    ca_uint32_t REG0_DFE_VCALI_CTRL  :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd1               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG16_t;


#define PSDS_RG17                                0xd003a05c
#define PSDS_RG17_dft                            0x00005555

typedef volatile union {
  struct {
    ca_uint32_t REG0_DFE_IREF_ODD_ADJ :  2 ; /* bits 1:0 */
    ca_uint32_t REG0_DFE_IREF_EVEN_ADJ :  2 ; /* bits 3:2 */
    ca_uint32_t REG0_DFE_IPD_ODD_ADJ :  2 ; /* bits 5:4 */
    ca_uint32_t REG0_DFE_IPD_EVEN_ADJ :  2 ; /* bits 7:6 */
    ca_uint32_t REG0_DFE_IMAIN_ODD_ADJ :  2 ; /* bits 9:8 */
    ca_uint32_t REG0_DFE_IMAIN_EVEN_ADJ :  2 ; /* bits 11:10 */
    ca_uint32_t REG0_DFE_ICMLATCH_ODD_ADJ :  2 ; /* bits 13:12 */
    ca_uint32_t REG0_DFE_ICMLATCH_EVEN_ADJ :  2 ; /* bits 15:14 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG17_t;


#define PSDS_RG18                                0xd003a060
#define PSDS_RG18_dft                            0x000014e5

typedef volatile union {
  struct {
    ca_uint32_t REG_CMUTX_BG_SEL     :  2 ; /* bits 1:0 */
    ca_uint32_t REG_CMUTX_SEL_IBLPF  :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t REG_CMUTX_TESTEN     :  1 ; /* bits 4:4 */
    ca_uint32_t REG_CMUTX_BYPASS_BERNY :  1 ; /* bits 5:5 */
    ca_uint32_t REG_CMUTX_BYPASS_POWCLKRX :  1 ; /* bits 6:6 */
    ca_uint32_t REG_CMUTX_REF_SEL    :  1 ; /* bits 7:7 */
    ca_uint32_t REG_CMUTX_VSEL_LREG  :  3 ; /* bits 10:8 */
    ca_uint32_t REG_CMUTX_EN_LDO_1p1V :  1 ; /* bits 11:11 */
    ca_uint32_t REG_CMUTX_VSEL_LREGD :  3 ; /* bits 14:12 */
    ca_uint32_t REG_CMUTX_LREGD_SEL_VREF :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd2               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG18_t;


#define PSDS_RG19                                0xd003a064
#define PSDS_RG19_dft                            0x0000180d

typedef volatile union {
  struct {
    ca_uint32_t REG_CMUTX_ICP_SEL    :  5 ; /* bits 4:0 */
    ca_uint32_t REG_CMUTX_ICP_SEL_LBW :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t REG_CMUTX_SEL_R      :  4 ; /* bits 11:8 */
    ca_uint32_t REG_CMUTX_LPF_CPSEL  :  1 ; /* bits 12:12 */
    ca_uint32_t REG_CMUTX_PI_IBSEL   :  2 ; /* bits 14:13 */
    ca_uint32_t rsrvd2               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG19_t;


#define PSDS_RG1A                                0xd003a068
#define PSDS_RG1A_dft                            0x00001017

typedef volatile union {
  struct {
    ca_uint32_t REG_CMUTX_ISTANK_SEL :  2 ; /* bits 1:0 */
    ca_uint32_t REG_CMUTX_I_BOOST    :  2 ; /* bits 3:2 */
    ca_uint32_t REG_CMUTX_LCBIAS_LPF_EN :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t REG_CMUTX_LCVCO_HSMODE :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t REG_CMUTX_LCVCO_TR   :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd3               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG1A_t;


#define PSDS_RG1B                                0xd003a06c
#define PSDS_RG1B_dft                            0x00004444

typedef volatile union {
  struct {
    ca_uint32_t REG_CMUTX_VCM_ST0    :  3 ; /* bits 2:0 */
    ca_uint32_t REG_CMUTX_CK_EN_S0   :  1 ; /* bits 3:3 */
    ca_uint32_t REG_CMUTX_VCM_ST1    :  3 ; /* bits 6:4 */
    ca_uint32_t REG_CMUTX_CK_EN_S1   :  1 ; /* bits 7:7 */
    ca_uint32_t REG_CMUTX_VCM_ST2    :  3 ; /* bits 10:8 */
    ca_uint32_t REG_CMUTX_CK_EN_S2   :  1 ; /* bits 11:11 */
    ca_uint32_t REG_CMUTX_VCM_ST3    :  3 ; /* bits 14:12 */
    ca_uint32_t REG_CMUTX_CK_EN_S3   :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG1B_t;


#define PSDS_RG1C                                0xd003a070
#define PSDS_RG1C_dft                            0x00000001

typedef volatile union {
  struct {
    ca_uint32_t REG_CMUTX_FLD_VREF_SEL :  2 ; /* bits 1:0 */
    ca_uint32_t REG_CMUTX_FLD_DSEL   :  2 ; /* bits 3:2 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t REG_CMUTX_RESERVED   :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd2               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG1C_t;


#define PSDS_RG1D                                0xd003a074
#define PSDS_RG1D_dft                            0x0000c921

typedef volatile union {
  struct {
    ca_uint32_t REG_CMUTX_cp_time    :  3 ; /* bits 2:0 */
    ca_uint32_t REG_CMUTX_cp_en_manual :  1 ; /* bits 3:3 */
    ca_uint32_t REG_CMUTX_calib_time :  3 ; /* bits 6:4 */
    ca_uint32_t REG_CMUTX_calib_manual :  1 ; /* bits 7:7 */
    ca_uint32_t REG_CMUTX_init_time  :  3 ; /* bits 10:8 */
    ca_uint32_t REG_CMUTX_auto_mode  :  1 ; /* bits 11:11 */
    ca_uint32_t REG_CMUTX_adp_time   :  3 ; /* bits 14:12 */
    ca_uint32_t REG_CMUTX_AUTO_K     :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG1D_t;


#define PSDS_RG1E                                0xd003a078
#define PSDS_RG1E_dft                            0x00004000

typedef volatile union {
  struct {
    ca_uint32_t REG_CMUTX_TBASE      : 12 ; /* bits 11:0 */
    ca_uint32_t REG_CMUTX_EN_SSC     :  1 ; /* bits 12:12 */
    ca_uint32_t REG_CMUTX_SSC_ORDER  :  1 ; /* bits 13:13 */
    ca_uint32_t REG_CMUTX_EN_CENTER_IN :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG1E_t;


#define PSDS_RG1F                                0xd003a07c
#define PSDS_RG1F_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t REG_CMUTX_STEP_IN    : 13 ; /* bits 12:0 */
    ca_uint32_t rsrvd1               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG1F_t;


#define PSDS_RG20                                0xd003a080
#define PSDS_RG20_dft                            0x0000005a

typedef volatile union {
  struct {
    ca_uint32_t REG_CMUTX_WD_ENABLE  :  1 ; /* bits 0:0 */
    ca_uint32_t REG_CMUTX_TIME_RDY_CKOUT :  2 ; /* bits 2:1 */
    ca_uint32_t REG_CMUTX_TIME0_CK   :  3 ; /* bits 5:3 */
    ca_uint32_t REG_CMUTX_TIME2_RST_WIDTH :  2 ; /* bits 7:6 */
    ca_uint32_t REG_CMUTX_F390K      :  2 ; /* bits 9:8 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG20_t;


#define PSDS_RG21                                0xd003a084
#define PSDS_RG21_dft                            0x0000701f

typedef volatile union {
  struct {
    ca_uint32_t REG0_AMP             :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t REG0_MAIN_AMP        :  5 ; /* bits 12:8 */
    ca_uint32_t REG0_BOOST_MAIN      :  1 ; /* bits 13:13 */
    ca_uint32_t REG0_MAIN_EN         :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd2               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG21_t;


#define PSDS_RG22                                0xd003a088
#define PSDS_RG22_dft                            0x00001010

typedef volatile union {
  struct {
    ca_uint32_t REG0_POST_AMP        :  5 ; /* bits 4:0 */
    ca_uint32_t REG0_POST_EN         :  1 ; /* bits 5:5 */
    ca_uint32_t REG0_BOOST_POST      :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t REG0_PRE_AMP         :  5 ; /* bits 12:8 */
    ca_uint32_t REG0_PRE_EN          :  1 ; /* bits 13:13 */
    ca_uint32_t REG0_BOOST_PRE       :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd2               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG22_t;


#define PSDS_RG23                                0xd003a08c
#define PSDS_RG23_dft                            0x00000050

typedef volatile union {
  struct {
    ca_uint32_t REG0_TXDLY           :  2 ; /* bits 1:0 */
    ca_uint32_t REG0_TXTESTEN        :  1 ; /* bits 2:2 */
    ca_uint32_t REG0_TXLASENDB       :  1 ; /* bits 3:3 */
    ca_uint32_t REG0_TX_SEL_CKRD_DUTY :  1 ; /* bits 4:4 */
    ca_uint32_t REG0_TX_EN_TEST      :  1 ; /* bits 5:5 */
    ca_uint32_t REG0_TX_D2S_SEL      :  1 ; /* bits 6:6 */
    ca_uint32_t REG0_SLEW_CTRL       :  1 ; /* bits 7:7 */
    ca_uint32_t REG0_IBTX_ADJ        :  2 ; /* bits 9:8 */
    ca_uint32_t REG0_SEL_CKRDY_DLY   :  1 ; /* bits 10:10 */
    ca_uint32_t REG0_FORCE_CONNECT   :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG23_t;


#define PSDS_RG24                                0xd003a090
#define PSDS_RG24_dft                            0x00000025

typedef volatile union {
  struct {
    ca_uint32_t REG_TTL_DRI_SEL      :  2 ; /* bits 1:0 */
    ca_uint32_t REG_BEN_TTL_OUT      :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t REG_BEN_POR_SEL      :  2 ; /* bits 5:4 */
    ca_uint32_t rsrvd2               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG24_t;


#define PSDS_RG25                                0xd003a094
#define PSDS_RG25_dft                            0x00000008

typedef volatile union {
  struct {
    ca_uint32_t REG0_CLK_LA_R_SEL    :  4 ; /* bits 3:0 */
    ca_uint32_t REG0_CLK_LA_EN       :  1 ; /* bits 4:4 */
    ca_uint32_t REG0_ZTEST_CLK       :  1 ; /* bits 5:5 */
    ca_uint32_t REG0_CLK_LA_AMP      :  2 ; /* bits 7:6 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG25_t;


#define PSDS_RG26                                0xd003a098
#define PSDS_RG26_dft                            0x00000929

typedef volatile union {
  struct {
    ca_uint32_t REG_RING_CMUEN_TOGGLE :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t REG_RING_EN_MANUAL_EN :  1 ; /* bits 2:2 */
    ca_uint32_t REG_RING_EN_MANUAL   :  1 ; /* bits 3:3 */
    ca_uint32_t REG_RING_LDO_VREF    :  2 ; /* bits 5:4 */
    ca_uint32_t REG_RING_LDO_MODESEL :  1 ; /* bits 6:6 */
    ca_uint32_t REG_RING_25MOUT_EN   :  1 ; /* bits 7:7 */
    ca_uint32_t REG_CKSYNC_25M_CML_I :  3 ; /* bits 10:8 */
    ca_uint32_t REG_CKSYNC_25M_CML_EN :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd2               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG26_t;


#define PSDS_RG27                                0xd003a09c
#define PSDS_RG27_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t REG_RING_RESERVED    :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG27_t;


#define PSDS_RG28                                0xd003a0a0
#define PSDS_RG28_dft                            0x00005970

typedef volatile union {
  struct {
    ca_uint32_t REG_RING_CP_ISEL     :  5 ; /* bits 4:0 */
    ca_uint32_t REG_RING_CP_NEW_EN   :  1 ; /* bits 5:5 */
    ca_uint32_t REG_RING_CCO_BKVCO   :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t REG_RING_SR          :  3 ; /* bits 10:8 */
    ca_uint32_t REG_RING_SC          :  1 ; /* bits 11:11 */
    ca_uint32_t REG_RING_PI_ISEL     :  2 ; /* bits 13:12 */
    ca_uint32_t REG_RING_PI_SELNEW   :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd2               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG28_t;


#define PSDS_RG29                                0xd003a0a4
#define PSDS_RG29_dft                            0x00004000

typedef volatile union {
  struct {
    ca_uint32_t REG_RING_TBASE       : 12 ; /* bits 11:0 */
    ca_uint32_t REG_RING_EN_SSC      :  1 ; /* bits 12:12 */
    ca_uint32_t REG_RING_EN_CENTER_IN :  1 ; /* bits 13:13 */
    ca_uint32_t REG_RING_SSC_ORDER   :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG29_t;


#define PSDS_RG2A                                0xd003a0a8
#define PSDS_RG2A_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t REG_RING_STEP_IN     : 13 ; /* bits 12:0 */
    ca_uint32_t rsrvd1               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG2A_t;


#define PSDS_RG2B                                0xd003a0ac
#define PSDS_RG2B_dft                            0x00001134

typedef volatile union {
  struct {
    ca_uint32_t REG_RING_WD_ENABLE   :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t REG_RING_TIME_RDY_CKOUT :  2 ; /* bits 3:2 */
    ca_uint32_t REG_RING_TIME0_CK    :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t REG_RING_TIME2_RST_WIDTH :  2 ; /* bits 9:8 */
    ca_uint32_t rsrvd3               :  2 ;
    ca_uint32_t REG_RING_F390K       :  2 ; /* bits 13:12 */
    ca_uint32_t rsrvd4               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG2B_t;


#define PSDS_RG2C                                0xd003a0b0
#define PSDS_RG2C_dft                            0x00000888

typedef volatile union {
  struct {
    ca_uint32_t REG0_Z0_TXADJ        :  4 ; /* bits 3:0 */
    ca_uint32_t REG0_Z0_TXAUTO_K     :  1 ; /* bits 4:4 */
    ca_uint32_t REG0_85OHM_TX        :  1 ; /* bits 5:5 */
    ca_uint32_t REG0_80OHM_TX        :  1 ; /* bits 6:6 */
    ca_uint32_t REG0_ZTUNE           :  1 ; /* bits 7:7 */
    ca_uint32_t REG0_Z0_RXADJ        :  4 ; /* bits 11:8 */
    ca_uint32_t REG0_Z0_RXAUTO_K     :  1 ; /* bits 12:12 */
    ca_uint32_t REG0_85OHM_RX        :  1 ; /* bits 13:13 */
    ca_uint32_t REG0_80OHM_RX        :  1 ; /* bits 14:14 */
    ca_uint32_t REG0_ZTEST           :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG2C_t;


#define PSDS_RG2D                                0xd003a0b4
#define PSDS_RG2D_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t REG_TCALR            :  5 ; /* bits 4:0 */
    ca_uint32_t REG_TCALN            :  5 ; /* bits 9:5 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG2D_t;


#define PSDS_RG40                                0xd003a0b8
#define PSDS_RG40_dft                            0x0000fe40

typedef volatile union {
  struct {
    ca_uint32_t LEQ_EN               :  1 ; /* bits 0:0 */
    ca_uint32_t DFE_EN               :  1 ; /* bits 1:1 */
    ca_uint32_t REG0_TEST_EN         :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t REG0_CLK_SEL         :  1 ; /* bits 4:4 */
    ca_uint32_t REG0_CLK_INV         :  1 ; /* bits 5:5 */
    ca_uint32_t REG0_SHIFT_INV       :  1 ; /* bits 6:6 */
    ca_uint32_t reg_ck_500m_inv      :  1 ; /* bits 7:7 */
    ca_uint32_t REG_CDR_RST_SEL      :  1 ; /* bits 8:8 */
    ca_uint32_t REG_CDR_RST_N        :  1 ; /* bits 9:9 */
    ca_uint32_t REG0_ST_M_VALUE      :  6 ; /* bits 15:10 */
    ca_uint32_t rsrvd2               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG40_t;


#define PSDS_RG41                                0xd003a0bc
#define PSDS_RG41_dft                            0x0000003f

typedef volatile union {
  struct {
    ca_uint32_t REG0_EQ_UPPER_LIMIT  :  5 ; /* bits 4:0 */
    ca_uint32_t REG0_EQ_SLICER_EN    :  1 ; /* bits 5:5 */
    ca_uint32_t REG0_EQ_GAIN         :  2 ; /* bits 7:6 */
    ca_uint32_t REG0_TAP0_EN_SEL     :  1 ; /* bits 8:8 */
    ca_uint32_t REG0_TAP1_EN_SEL     :  1 ; /* bits 9:9 */
    ca_uint32_t REG0_TAP2_EN_SEL     :  1 ; /* bits 10:10 */
    ca_uint32_t REG0_TAP3_EN_SEL     :  1 ; /* bits 11:11 */
    ca_uint32_t REG0_TAP4_EN_SEL     :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd1               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG41_t;


#define PSDS_RG42                                0xd003a0c0
#define PSDS_RG42_dft                            0x00002070

typedef volatile union {
  struct {
    ca_uint32_t REG0_FILTER_OUT      :  7 ; /* bits 6:0 */
    ca_uint32_t REG0_EQ_SELREG       :  1 ; /* bits 7:7 */
    ca_uint32_t REG0_EQOUT_OFFSET    :  5 ; /* bits 12:8 */
    ca_uint32_t REG0_EQED_SEL        :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG42_t;


#define PSDS_RG43                                0xd003a0c4
#define PSDS_RG43_dft                            0x00001000

typedef volatile union {
  struct {
    ca_uint32_t REG0_ACC2_PERIOD     : 10 ; /* bits 9:0 */
    ca_uint32_t REG0_ACC2_MANUAL     :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t REG0_SQU_TRI         :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd2               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG43_t;


#define PSDS_RG44                                0xd003a0c8
#define PSDS_RG44_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t REG0_INT_INIT        : 11 ; /* bits 10:0 */
    ca_uint32_t REG0_BYPASS_SDM_INT  :  1 ; /* bits 11:11 */
    ca_uint32_t REG0_PI_M_MODE       :  1 ; /* bits 12:12 */
    ca_uint32_t REG0_ST_MODE         :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG44_t;


#define PSDS_RG45                                0xd003a0cc
#define PSDS_RG45_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t REG0_ACC2_PERIOD_2   : 10 ; /* bits 9:0 */
    ca_uint32_t REG0_ACC2_MANUAL_2   :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd1               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG45_t;


#define PSDS_RG46                                0xd003a0d0
#define PSDS_RG46_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t REG0_KP_CDR2         :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t REG0_KI_CDR2         :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t REG0_KP_DIV          :  2 ; /* bits 13:12 */
    ca_uint32_t REG0_DYN_KP_EN       :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd3               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG46_t;


#define PSDS_RG47                                0xd003a0d4
#define PSDS_RG47_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t REG0_INT_INIT_2      : 11 ; /* bits 10:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t REG0_SQU_TRI_2       :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd2               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG47_t;


#define PSDS_RG48                                0xd003a0d8
#define PSDS_RG48_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t REG0_TIMER_LPF       :  5 ; /* bits 4:0 */
    ca_uint32_t REG0_TIMER_EQ        :  5 ; /* bits 9:5 */
    ca_uint32_t REG0_TIMER_BER       :  5 ; /* bits 14:10 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG48_t;


#define PSDS_RG49                                0xd003a0dc
#define PSDS_RG49_dft                            0x00005027

typedef volatile union {
  struct {
    ca_uint32_t REG0_TIMER_MAXHOLD   :  8 ; /* bits 7:0 */
    ca_uint32_t REG0_MAXHOLD_EN      :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t REG0_SUMMER_CNT      :  3 ; /* bits 14:12 */
    ca_uint32_t rsrvd2               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG49_t;


#define PSDS_RG4A                                0xd003a0e0
#define PSDS_RG4A_dft                            0x00000031

typedef volatile union {
  struct {
    ca_uint32_t REG0_LFPS_LPERIOD    :  4 ; /* bits 3:0 */
    ca_uint32_t REG0_LFPS_HPERIOD    :  4 ; /* bits 7:4 */
    ca_uint32_t REG0_LFPS_LAST       :  2 ; /* bits 9:8 */
    ca_uint32_t REG0_LFPS_DEBOUNCE   :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd1               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG4A_t;


#define PSDS_RG4B                                0xd003a0e4
#define PSDS_RG4B_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t REG0_EYE_REF_CTRL    :  6 ; /* bits 5:0 */
    ca_uint32_t REG0_VTH_STEP        :  2 ; /* bits 7:6 */
    ca_uint32_t REG0_VTH_INTERVAL    :  4 ; /* bits 11:8 */
    ca_uint32_t REG0_EYE_XOR_CK_SEL  :  2 ; /* bits 13:12 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG4B_t;


#define PSDS_RG4C                                0xd003a0e8
#define PSDS_RG4C_dft                            0x0000ffff

typedef volatile union {
  struct {
    ca_uint32_t REG0_EYE_PI_ST       : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG4C_t;


#define PSDS_RG4D                                0xd003a0ec
#define PSDS_RG4D_dft                            0x00000300

typedef volatile union {
  struct {
    ca_uint32_t CSR_MODE             :  1 ; /* bits 0:0 */
    ca_uint32_t CSR_FREQ_OFFSET_RD_TOG :  1 ; /* bits 1:1 */
    ca_uint32_t CSR_FREQ_OFFSET_WR   :  1 ; /* bits 2:2 */
    ca_uint32_t CSR_KI_WR            :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t REG0_EYE_PI_EN       :  4 ; /* bits 11:8 */
    ca_uint32_t REG0_EN_ST_STEP      :  2 ; /* bits 13:12 */
    ca_uint32_t rsrvd2               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG4D_t;


#define PSDS_RG4E                                0xd003a0f0
#define PSDS_RG4E_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t CSR_FREQ_OFF_WR_H    : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG4E_t;


#define PSDS_RG4F                                0xd003a0f4
#define PSDS_RG4F_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t CSR_FREQ_OFF_WR_L    : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG4F_t;


#define PSDS_RG50                                0xd003a0f8
#define PSDS_RG50_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t reg0_eq_start        :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t reg0_eq_hold         :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t reg0_dfe_adapt_leq_eqen :  1 ; /* bits 8:8 */
    ca_uint32_t reg0_dfe_adapt_leq_en :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd3               :  2 ;
    ca_uint32_t reg0_reduce_adapt_gain :  2 ; /* bits 13:12 */
    ca_uint32_t reg0_hold_timer_en   :  1 ; /* bits 14:14 */
    ca_uint32_t reg0_record_limit_en :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd4               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG50_t;


#define PSDS_RG51                                0xd003a0fc
#define PSDS_RG51_dft                            0x00007fff

typedef volatile union {
  struct {
    ca_uint32_t reg0_load_in_init    :  7 ; /* bits 6:0 */
    ca_uint32_t reg0_load_leq_init   :  1 ; /* bits 7:7 */
    ca_uint32_t reg0_gray_en         :  7 ; /* bits 14:8 */
    ca_uint32_t reg0_ki_avg          :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG51_t;


#define PSDS_RG52                                0xd003a100
#define PSDS_RG52_dft                            0x00003d20

typedef volatile union {
  struct {
    ca_uint32_t reg0_cali_debug_sel  :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t reg0_cali_en         :  2 ; /* bits 5:4 */
    ca_uint32_t reg0_cali_gray_en    :  2 ; /* bits 7:6 */
    ca_uint32_t reg0_cali_ini        :  4 ; /* bits 11:8 */
    ca_uint32_t reg0_cali_load_in_init :  2 ; /* bits 13:12 */
    ca_uint32_t rsrvd2               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG52_t;


#define PSDS_RG53                                0xd003a104
#define PSDS_RG53_dft                            0x00000f00

typedef volatile union {
  struct {
    ca_uint32_t reg0_cali_loop_gain  :  4 ; /* bits 3:0 */
    ca_uint32_t reg0_cali_pc         :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t reg0_cali_stable_th  :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG53_t;


#define PSDS_RG54                                0xd003a108
#define PSDS_RG54_dft                            0x00008000

typedef volatile union {
  struct {
    ca_uint32_t reg0_dfe_adapt_en    :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t reg0_dfe_adapt_en2   :  6 ; /* bits 13:8 */
    ca_uint32_t reg0_dfe_adapt_mode  :  2 ; /* bits 15:14 */
    ca_uint32_t rsrvd2               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG54_t;


#define PSDS_RG55                                0xd003a10c
#define PSDS_RG55_dft                            0x00008440

typedef volatile union {
  struct {
    ca_uint32_t reg0_leq_gain_prec   :  3 ; /* bits 2:0 */
    ca_uint32_t reg0_leq_sign_prec   :  1 ; /* bits 3:3 */
    ca_uint32_t reg0_leq_gain_1      :  3 ; /* bits 6:4 */
    ca_uint32_t reg0_leq_sign_1      :  1 ; /* bits 7:7 */
    ca_uint32_t reg0_leq_gain_2      :  3 ; /* bits 10:8 */
    ca_uint32_t reg0_leq_sign_2      :  1 ; /* bits 11:11 */
    ca_uint32_t reg0_leq_code        :  2 ; /* bits 13:12 */
    ca_uint32_t reg0_adapt_mode      :  2 ; /* bits 15:14 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG55_t;


#define PSDS_RG56                                0xd003a110
#define PSDS_RG56_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t reg0_leq_start       :  3 ; /* bits 2:0 */
    ca_uint32_t reg0_leq_init        :  5 ; /* bits 7:3 */
    ca_uint32_t reg0_leq_hold        :  3 ; /* bits 10:8 */
    ca_uint32_t reg0_leq_min         :  5 ; /* bits 15:11 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG56_t;


#define PSDS_RG57                                0xd003a114
#define PSDS_RG57_dft                            0x00000fff

typedef volatile union {
  struct {
    ca_uint32_t reg0_offset_delay_cnt_0 :  4 ; /* bits 3:0 */
    ca_uint32_t reg0_offset_delay_cnt_1 :  4 ; /* bits 7:4 */
    ca_uint32_t reg0_offset_delay_cnt :  4 ; /* bits 11:8 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG57_t;


#define PSDS_RG58                                0xd003a118
#define PSDS_RG58_dft                            0x0000ffff

typedef volatile union {
  struct {
    ca_uint32_t reg0_offset_delay_cnt_2 :  4 ; /* bits 3:0 */
    ca_uint32_t reg0_offset_delay_cnt_3 :  4 ; /* bits 7:4 */
    ca_uint32_t reg0_offset_delay_cnt_4 :  4 ; /* bits 11:8 */
    ca_uint32_t reg0_offset_delay_cnt_5 :  4 ; /* bits 15:12 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG58_t;


#define PSDS_RG59                                0xd003a11c
#define PSDS_RG59_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t reg0_offset_divisor_1 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t reg0_offset_divisor_0 :  6 ; /* bits 13:8 */
    ca_uint32_t rsrvd2               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG59_t;


#define PSDS_RG5A                                0xd003a120
#define PSDS_RG5A_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t reg0_offset_divisor_3 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t reg0_offset_divisor_2 :  6 ; /* bits 13:8 */
    ca_uint32_t rsrvd2               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG5A_t;


#define PSDS_RG5B                                0xd003a124
#define PSDS_RG5B_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t reg0_offset_divisor_5 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t reg0_offset_divisor_4 :  6 ; /* bits 13:8 */
    ca_uint32_t rsrvd2               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG5B_t;


#define PSDS_RG5C                                0xd003a128
#define PSDS_RG5C_dft                            0x00000080

typedef volatile union {
  struct {
    ca_uint32_t reg0_offset_ini      :  8 ; /* bits 7:0 */
    ca_uint32_t reg0_offset_divisor  :  6 ; /* bits 13:8 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG5C_t;


#define PSDS_RG5D                                0xd003a12c
#define PSDS_RG5D_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t reg0_offset_ini_1    :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t reg0_offset_ini_0    :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG5D_t;


#define PSDS_RG5E                                0xd003a130
#define PSDS_RG5E_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t reg0_offset_ini_3    :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t reg0_offset_ini_2    :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG5E_t;


#define PSDS_RG5F                                0xd003a134
#define PSDS_RG5F_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t reg0_offset_ini_5    :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t reg0_offset_ini_4    :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG5F_t;


#define PSDS_RG60                                0xd003a138
#define PSDS_RG60_dft                            0x00000070

typedef volatile union {
  struct {
    ca_uint32_t reg0_offset_pc_0     :  1 ; /* bits 0:0 */
    ca_uint32_t reg0_offset_pc_1     :  1 ; /* bits 1:1 */
    ca_uint32_t reg0_offset_pc_2     :  1 ; /* bits 2:2 */
    ca_uint32_t reg0_offset_pc_3     :  1 ; /* bits 3:3 */
    ca_uint32_t reg0_offset_pc_4     :  1 ; /* bits 4:4 */
    ca_uint32_t reg0_offset_pc_5     :  1 ; /* bits 5:5 */
    ca_uint32_t reg0_offset_pc       :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t reg0_offset_manual_0 :  1 ; /* bits 8:8 */
    ca_uint32_t reg0_offset_manual_1 :  1 ; /* bits 9:9 */
    ca_uint32_t reg0_offset_manual_2 :  1 ; /* bits 10:10 */
    ca_uint32_t reg0_offset_manual_3 :  1 ; /* bits 11:11 */
    ca_uint32_t reg0_offset_manual_4 :  1 ; /* bits 12:12 */
    ca_uint32_t reg0_offset_manual_5 :  1 ; /* bits 13:13 */
    ca_uint32_t reg0_offset_manual   :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd2               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG60_t;


#define PSDS_RG61                                0xd003a13c
#define PSDS_RG61_dft                            0x00003fff

typedef volatile union {
  struct {
    ca_uint32_t reg0_offset_stable_cnt :  2 ; /* bits 1:0 */
    ca_uint32_t reg0_offset_stable_cnt_0 :  2 ; /* bits 3:2 */
    ca_uint32_t reg0_offset_stable_cnt_1 :  2 ; /* bits 5:4 */
    ca_uint32_t reg0_offset_stable_cnt_2 :  2 ; /* bits 7:6 */
    ca_uint32_t reg0_offset_stable_cnt_3 :  2 ; /* bits 9:8 */
    ca_uint32_t reg0_offset_stable_cnt_4 :  2 ; /* bits 11:10 */
    ca_uint32_t reg0_offset_stable_cnt_5 :  2 ; /* bits 13:12 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG61_t;


#define PSDS_RG62                                0xd003a140
#define PSDS_RG62_dft                            0x00000080

typedef volatile union {
  struct {
    ca_uint32_t reg0_servo_ini_en_0  :  1 ; /* bits 0:0 */
    ca_uint32_t reg0_servo_ini_en_1  :  1 ; /* bits 1:1 */
    ca_uint32_t reg0_servo_ini_en_2  :  1 ; /* bits 2:2 */
    ca_uint32_t reg0_servo_ini_en_3  :  1 ; /* bits 3:3 */
    ca_uint32_t reg0_servo_ini_en_4  :  1 ; /* bits 4:4 */
    ca_uint32_t reg0_servo_ini_en_5  :  1 ; /* bits 5:5 */
    ca_uint32_t reg0_servo_ini_en    :  1 ; /* bits 6:6 */
    ca_uint32_t reg0_servo_inv       :  1 ; /* bits 7:7 */
    ca_uint32_t reg0_servo_trans     :  1 ; /* bits 8:8 */
    ca_uint32_t reg0_servo_notrans   :  1 ; /* bits 9:9 */
    ca_uint32_t reg0_servo_stable_th :  5 ; /* bits 14:10 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG62_t;


#define PSDS_RG63                                0xd003a144
#define PSDS_RG63_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t reg0_servo_divisor   :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t reg0_servo_start     :  2 ; /* bits 9:8 */
    ca_uint32_t reg0_servo_hold      :  2 ; /* bits 11:10 */
    ca_uint32_t reg0_servo_gain      :  3 ; /* bits 14:12 */
    ca_uint32_t rsrvd2               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG63_t;


#define PSDS_RG64                                0xd003a148
#define PSDS_RG64_dft                            0x00007f00

typedef volatile union {
  struct {
    ca_uint32_t reg0_stable_range    :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t reg0_stable_en       :  7 ; /* bits 14:8 */
    ca_uint32_t rsrvd2               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG64_t;


#define PSDS_RG65                                0xd003a14c
#define PSDS_RG65_dft                            0x00001000

typedef volatile union {
  struct {
    ca_uint32_t reg0_th_min_en       :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t reg0_tap_divisor     :  6 ; /* bits 13:8 */
    ca_uint32_t reg0_start_timer_en  :  1 ; /* bits 14:14 */
    ca_uint32_t reg0_summer_manual   :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd2               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG65_t;


#define PSDS_RG66                                0xd003a150
#define PSDS_RG66_dft                            0x00000087

typedef volatile union {
  struct {
    ca_uint32_t reg0_vth_threshold   :  4 ; /* bits 3:0 */
    ca_uint32_t reg0_vth_divisor     :  4 ; /* bits 7:4 */
    ca_uint32_t reg0_trans_rlength   :  3 ; /* bits 10:8 */
    ca_uint32_t reg0_transition_only :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG66_t;


#define PSDS_RG67                                0xd003a154
#define PSDS_RG67_dft                            0x0000f077

typedef volatile union {
  struct {
    ca_uint32_t reg0_vthp_init       :  4 ; /* bits 3:0 */
    ca_uint32_t reg0_vthn_init       :  4 ; /* bits 7:4 */
    ca_uint32_t reg0_vth_min         :  4 ; /* bits 11:8 */
    ca_uint32_t reg0_vth_max         :  4 ; /* bits 15:12 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG67_t;


#define PSDS_RG68                                0xd003a158
#define PSDS_RG68_dft                            0x00001000

typedef volatile union {
  struct {
    ca_uint32_t reg0_tap0_threshold  :  4 ; /* bits 3:0 */
    ca_uint32_t reg0_tap0_start      :  3 ; /* bits 6:4 */
    ca_uint32_t reg0_tap0_hold       :  3 ; /* bits 9:7 */
    ca_uint32_t reg0_tap0_adjust     :  2 ; /* bits 11:10 */
    ca_uint32_t reg0_tap0_notrans    :  1 ; /* bits 12:12 */
    ca_uint32_t reg0_tap0_trans      :  1 ; /* bits 13:13 */
    ca_uint32_t reg0_tap0_inv        :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG68_t;


#define PSDS_RG69                                0xd003a15c
#define PSDS_RG69_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t reg0_tap25_start     :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t reg0_tap25_hold      :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t reg0_tap1_start      :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t reg0_tap1_hold       :  3 ; /* bits 14:12 */
    ca_uint32_t rsrvd4               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG69_t;


#define PSDS_RG6A                                0xd003a160
#define PSDS_RG6A_dft                            0x000000f0

typedef volatile union {
  struct {
    ca_uint32_t reg0_tap1_trans_mode :  1 ; /* bits 0:0 */
    ca_uint32_t reg0_tap2_trans_mode :  1 ; /* bits 1:1 */
    ca_uint32_t reg0_tap3_trans_mode :  1 ; /* bits 2:2 */
    ca_uint32_t reg0_tap4_trans_mode :  1 ; /* bits 3:3 */
    ca_uint32_t reg0_tap1_trans      :  1 ; /* bits 4:4 */
    ca_uint32_t reg0_tap2_trans      :  1 ; /* bits 5:5 */
    ca_uint32_t reg0_tap3_trans      :  1 ; /* bits 6:6 */
    ca_uint32_t reg0_tap4_trans      :  1 ; /* bits 7:7 */
    ca_uint32_t reg0_tap1_inv        :  1 ; /* bits 8:8 */
    ca_uint32_t reg0_tap2_inv        :  1 ; /* bits 9:9 */
    ca_uint32_t reg0_tap3_inv        :  1 ; /* bits 10:10 */
    ca_uint32_t reg0_tap4_inv        :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG6A_t;


#define PSDS_RG6B                                0xd003a164
#define PSDS_RG6B_dft                            0x0000001f

typedef volatile union {
  struct {
    ca_uint32_t reg0_tap0_th_min     :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG6B_t;


#define PSDS_RG6C                                0xd003a168
#define PSDS_RG6C_dft                            0x00003f1f

typedef volatile union {
  struct {
    ca_uint32_t reg0_tap2_th_min     :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t reg0_tap1_th_min     :  6 ; /* bits 13:8 */
    ca_uint32_t rsrvd2               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG6C_t;


#define PSDS_RG6D                                0xd003a16c
#define PSDS_RG6D_dft                            0x00001f1f

typedef volatile union {
  struct {
    ca_uint32_t reg0_tap4_th_min     :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t reg0_tap3_th_min     :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG6D_t;


#define PSDS_RG6E                                0xd003a170
#define PSDS_RG6E_dft                            0x00000008

typedef volatile union {
  struct {
    ca_uint32_t reg0_tap0_gain       :  3 ; /* bits 2:0 */
    ca_uint32_t reg0_tap1_gain       :  3 ; /* bits 5:3 */
    ca_uint32_t reg0_tap2_gain       :  3 ; /* bits 8:6 */
    ca_uint32_t reg0_tap3_gain       :  3 ; /* bits 11:9 */
    ca_uint32_t reg0_tap4_gain       :  3 ; /* bits 14:12 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG6E_t;


#define PSDS_RG6F                                0xd003a174
#define PSDS_RG6F_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t reg0_tap0_init       :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG6F_t;


#define PSDS_RG70                                0xd003a178
#define PSDS_RG70_dft                            0x00002323

typedef volatile union {
  struct {
    ca_uint32_t reg0_tap1_init_odd   :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t reg0_tap1_init_even  :  7 ; /* bits 14:8 */
    ca_uint32_t rsrvd2               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG70_t;


#define PSDS_RG71                                0xd003a17c
#define PSDS_RG71_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t reg0_tap2_init_odd   :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t reg0_tap2_init_even  :  6 ; /* bits 13:8 */
    ca_uint32_t rsrvd2               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG71_t;


#define PSDS_RG72                                0xd003a180
#define PSDS_RG72_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t reg0_tap3_init_odd   :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t reg0_tap3_init_even  :  6 ; /* bits 13:8 */
    ca_uint32_t rsrvd2               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG72_t;


#define PSDS_RG73                                0xd003a184
#define PSDS_RG73_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t reg0_tap4_init_odd   :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t reg0_tap4_init_even  :  6 ; /* bits 13:8 */
    ca_uint32_t rsrvd2               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG73_t;


#define PSDS_RG74                                0xd003a188
#define PSDS_RG74_dft                            0x0000003f

typedef volatile union {
  struct {
    ca_uint32_t reg0_tap1_min        :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t reg0_tap0_max        :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG74_t;


#define PSDS_RG75                                0xd003a18c
#define PSDS_RG75_dft                            0x00001f1f

typedef volatile union {
  struct {
    ca_uint32_t reg0_tap2_min        :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t reg0_tap2_max        :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG75_t;


#define PSDS_RG76                                0xd003a190
#define PSDS_RG76_dft                            0x00001f1f

typedef volatile union {
  struct {
    ca_uint32_t reg0_tap3_min        :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t reg0_tap3_max        :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG76_t;


#define PSDS_RG77                                0xd003a194
#define PSDS_RG77_dft                            0x00001f1f

typedef volatile union {
  struct {
    ca_uint32_t reg0_tap4_min        :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t reg0_tap4_max        :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG77_t;


#define PSDS_RG78                                0xd003a198
#define PSDS_RG78_dft                            0x00000404

typedef volatile union {
  struct {
    ca_uint32_t reg0_tap1_stable_th  :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t reg0_tap0_stable_th  :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG78_t;


#define PSDS_RG79                                0xd003a19c
#define PSDS_RG79_dft                            0x00000404

typedef volatile union {
  struct {
    ca_uint32_t reg0_tap3_stable_th  :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t reg0_tap2_stable_th  :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG79_t;


#define PSDS_RG7A                                0xd003a1a0
#define PSDS_RG7A_dft                            0x00000004

typedef volatile union {
  struct {
    ca_uint32_t reg0_tap4_stable_th  :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG7A_t;


#define PSDS_RG7B                                0xd003a1a4
#define PSDS_RG7B_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t reg0_z0_ok_0         :  1 ; /* bits 0:0 */
    ca_uint32_t reg0_z0_ok_1         :  1 ; /* bits 1:1 */
    ca_uint32_t reg0_z0_ok_2         :  1 ; /* bits 2:2 */
    ca_uint32_t reg0_z0_ok_3         :  1 ; /* bits 3:3 */
    ca_uint32_t reg0_z0_ok_4         :  1 ; /* bits 4:4 */
    ca_uint32_t reg0_z0_ok_5         :  1 ; /* bits 5:5 */
    ca_uint32_t reg0_z0_ok           :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG7B_t;


#define PSDS_RG7C                                0xd003a1a8
#define PSDS_RG7C_dft                            0x00000018

typedef volatile union {
  struct {
    ca_uint32_t reg0_eye_cali_en     :  1 ; /* bits 0:0 */
    ca_uint32_t reg0_eye_dir_ini     :  1 ; /* bits 1:1 */
    ca_uint32_t reg0_eye_inv         :  1 ; /* bits 2:2 */
    ca_uint32_t reg0_rstn_eye_xor    :  1 ; /* bits 3:3 */
    ca_uint32_t reg0_ckmdio          :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t reg0_sample          :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t reg0_eye_step        :  4 ; /* bits 15:12 */
    ca_uint32_t rsrvd3               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG7C_t;


#define PSDS_RG7D                                0xd003a1ac
#define PSDS_RG7D_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t reg0_limit_sel       :  5 ; /* bits 4:0 */
    ca_uint32_t reg0_loop_sel        :  3 ; /* bits 7:5 */
    ca_uint32_t reg_sample_sel       :  2 ; /* bits 9:8 */
    ca_uint32_t reg_phase_sel        :  2 ; /* bits 11:10 */
    ca_uint32_t reg_mux_sel          :  2 ; /* bits 13:12 */
    ca_uint32_t reg_duty_det         :  1 ; /* bits 14:14 */
    ca_uint32_t reg_ck_det_sel       :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG7D_t;


#define PSDS_RG7E                                0xd003a1b0
#define PSDS_RG7E_dft                            0x00000018

typedef volatile union {
  struct {
    ca_uint32_t reg0_coef_sel        :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t reg0_debug_sel       :  6 ; /* bits 13:8 */
    ca_uint32_t rsrvd2               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG7E_t;


#define PSDS_RG7F                                0xd003a1b4
#define PSDS_RG7F_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t CSR_FREQ_OFFSET_RD_H : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG7F_t;


#define PSDS_RG80                                0xd003a1b8
#define PSDS_RG80_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t CSR_FREQ_OFFSET_RD_L : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG80_t;


#define PSDS_RG81                                0xd003a1bc
#define PSDS_RG81_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t CSR_KI_RD            :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 10 ;
    ca_uint32_t CSR_FREQ_OFFSET_RD_TOG_ACK :  1 ; /* bits 14:14 */
    ca_uint32_t REG0_OUT_ADP_FAIL    :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd2               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG81_t;


#define PSDS_RG90                                0xd003a1c0
#define PSDS_RG90_dft                            0x00000002

typedef volatile union {
  struct {
    ca_uint32_t REG_XTAL24P576M_EN   :  1 ; /* bits 0:0 */
    ca_uint32_t REG_SEL_25M          :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG90_t;


#define PSDS_RG91                                0xd003a1c4
#define PSDS_RG91_dft                            0x0000a341

typedef volatile union {
  struct {
    ca_uint32_t REG_CMU_SELPREDIV    :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t REG_CMU_stg1_div2    :  1 ; /* bits 5:5 */
    ca_uint32_t REG_CMU_stg2_div1    :  1 ; /* bits 6:6 */
    ca_uint32_t REG_CMU_stg2_div2    :  1 ; /* bits 7:7 */
    ca_uint32_t REG_CMU_NCODE_IN     :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd2               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG91_t;


#define PSDS_RG92                                0xd003a1c8
#define PSDS_RG92_dft                            0x00002000

typedef volatile union {
  struct {
    ca_uint32_t REG_CMU_FCODE_IN     : 13 ; /* bits 12:0 */
    ca_uint32_t REG_CMU_PI_BYPASS    :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG92_t;


#define PSDS_RG93                                0xd003a1cc
#define PSDS_RG93_dft                            0x00004294

typedef volatile union {
  struct {
    ca_uint32_t REG_CMU_lock_up_limit : 10 ; /* bits 9:0 */
    ca_uint32_t REG_CMU_divide_num   :  6 ; /* bits 15:10 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG93_t;


#define PSDS_RG94                                0xd003a1d0
#define PSDS_RG94_dft                            0x00000694

typedef volatile union {
  struct {
    ca_uint32_t REG_CMU_lock_dn_limit : 10 ; /* bits 9:0 */
    ca_uint32_t REG_CMU_FLD_CLK_SEL  :  2 ; /* bits 11:10 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG94_t;


#define PSDS_RG95                                0xd003a1d4
#define PSDS_RG95_dft                            0x0000359b

typedef volatile union {
  struct {
    ca_uint32_t REG0_SPDSEL_RX       :  3 ; /* bits 2:0 */
    ca_uint32_t REG0_PON_MODE        :  1 ; /* bits 3:3 */
    ca_uint32_t REG0_SEL_SD          :  2 ; /* bits 5:4 */
    ca_uint32_t REG0_FIBER_MODE      :  1 ; /* bits 6:6 */
    ca_uint32_t REG0_CDR2_POST1_DIV3 :  1 ; /* bits 7:7 */
    ca_uint32_t REG0_CDR2_POST1_DIN  :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG95_t;


#define PSDS_RG96                                0xd003a1d8
#define PSDS_RG96_dft                            0x00000983

typedef volatile union {
  struct {
    ca_uint32_t REG0_CLKWR_PCS_DIV   :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t REG0_CDR2_POSTDIV2_EN :  1 ; /* bits 6:6 */
    ca_uint32_t REG0_CDR2_POST2_DIV3 :  1 ; /* bits 7:7 */
    ca_uint32_t REG0_CDR2_POST2_DIN  :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd2               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG96_t;


#define PSDS_RG97                                0xd003a1dc
#define PSDS_RG97_dft                            0x00001f11

typedef volatile union {
  struct {
    ca_uint32_t REG_CMUTX_EN         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t REG_CMUTX_SELPREDIV  :  2 ; /* bits 3:2 */
    ca_uint32_t REG_CMUTX_stg1_div2  :  1 ; /* bits 4:4 */
    ca_uint32_t REG_CMUTX_stg2_div1  :  1 ; /* bits 5:5 */
    ca_uint32_t REG_CMUTX_stg2_div2  :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t REG_CMUTX_NCODE_IN   :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd3               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG97_t;


#define PSDS_RG98                                0xd003a1e0
#define PSDS_RG98_dft                            0x00002000

typedef volatile union {
  struct {
    ca_uint32_t REG_CMUTX_FCODE_IN   : 13 ; /* bits 12:0 */
    ca_uint32_t REG_CMUTX_PI_BYPASS  :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG98_t;


#define PSDS_RG99                                0xd003a1e4
#define PSDS_RG99_dft                            0x00006b5a

typedef volatile union {
  struct {
    ca_uint32_t REG_CMUTX_lock_up_limit : 10 ; /* bits 9:0 */
    ca_uint32_t REG_CMUTX_divide_num :  6 ; /* bits 15:10 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG99_t;


#define PSDS_RG9A                                0xd003a1e8
#define PSDS_RG9A_dft                            0x0000035a

typedef volatile union {
  struct {
    ca_uint32_t REG_CMUTX_lock_dn_limit : 10 ; /* bits 9:0 */
    ca_uint32_t REG_CMUTX_FLD_CLK_SEL :  2 ; /* bits 11:10 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG9A_t;


#define PSDS_RG9B                                0xd003a1ec
#define PSDS_RG9B_dft                            0x000009c0

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  6 ;
    ca_uint32_t REG_CMUTX_POSTDIV_EN :  1 ; /* bits 6:6 */
    ca_uint32_t REG_CMUTX_POST_DIV3  :  1 ; /* bits 7:7 */
    ca_uint32_t REG_CMUTX_POST_DIVN  :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd2               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG9B_t;


#define PSDS_RG9C                                0xd003a1f0
#define PSDS_RG9C_dft                            0x00000033

typedef volatile union {
  struct {
    ca_uint32_t REG0_SPDSEL_TX       :  3 ; /* bits 2:0 */
    ca_uint32_t REG0_CDR2_SEL        :  1 ; /* bits 3:3 */
    ca_uint32_t REG0_CLKRD_PCS_DIV   :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG9C_t;


#define PSDS_RG9D                                0xd003a1f4
#define PSDS_RG9D_dft                            0x00001e03

typedef volatile union {
  struct {
    ca_uint32_t REG_RING_REF_SEL     :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t REG_RING_PREDIV      :  2 ; /* bits 5:4 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t REG_RING_NCODE_IN    :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd3               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG9D_t;


#define PSDS_RG9E                                0xd003a1f8
#define PSDS_RG9E_dft                            0x00002000

typedef volatile union {
  struct {
    ca_uint32_t REG_RING_FCODE_IN    : 13 ; /* bits 12:0 */
    ca_uint32_t REG_RING_PI_BYPASS   :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG9E_t;


#define PSDS_RG9F                                0xd003a1fc
#define PSDS_RG9F_dft                            0x00000841

typedef volatile union {
  struct {
    ca_uint32_t REG_RING_EN          :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t REG_CKMPCP_EN        :  1 ; /* bits 4:4 */
    ca_uint32_t REG_CKGPHY_SEL       :  1 ; /* bits 5:5 */
    ca_uint32_t REG_RING_POSTDIV_EN  :  1 ; /* bits 6:6 */
    ca_uint32_t REG_RING_POST_DIV3   :  1 ; /* bits 7:7 */
    ca_uint32_t REG_RING_POST_DIVN   :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd2               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RG9F_t;


#define PSDS_RGA0                                0xd003a200
#define PSDS_RGA0_dft                            0x00000101

typedef volatile union {
  struct {
    ca_uint32_t REG0_KI              :  4 ; /* bits 3:0 */
    ca_uint32_t REG0_KP              :  6 ; /* bits 9:4 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RGA0_t;


#define PSDS_RGA1                                0xd003a204
#define PSDS_RGA1_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t REG0_ST_M_VALUE_CDR2 :  6 ; /* bits 5:0 */
    ca_uint32_t REG0_ST_MODE_2       :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t REG0_PI_M_MODE_CDR2  :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t REG0_LPF_BYPASS      :  1 ; /* bits 12:12 */
    ca_uint32_t REG0_LPF_COEF        :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd3               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RGA1_t;


#define PSDS_RGB0                                0xd003a208
#define PSDS_RGB0_dft                            0x00000c10

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t CSR_RX_CLKWR_EN      :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t CSR_CM_ON            :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t CSR_S0_RSTB_EQ       :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd4               :  1 ;
    ca_uint32_t CSR_OOBS_RSTB        :  1 ; /* bits 8:8 */
    ca_uint32_t CSR_CMURING_EN       :  1 ; /* bits 9:9 */
    ca_uint32_t CSR_RSTB_BITERR      :  1 ; /* bits 10:10 */
    ca_uint32_t CSR_PDOWN            :  1 ; /* bits 11:11 */
    ca_uint32_t CSR_V2ANALOG         :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd5               :  1 ;
    ca_uint32_t CSR_RX_DATA_EN       :  1 ; /* bits 14:14 */
    ca_uint32_t CSR_RX_EN            :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd6               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RGB0_t;


#define PSDS_RGB1                                0xd003a20c
#define PSDS_RGB1_dft                            0x00000001

typedef volatile union {
  struct {
    ca_uint32_t RXIDLE_D             :  1 ; /* bits 0:0 */
    ca_uint32_t CMUTX_EN             :  1 ; /* bits 1:1 */
    ca_uint32_t CMURX_EN             :  1 ; /* bits 2:2 */
    ca_uint32_t NO_SDS               :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RGB1_t;


#define PSDS_RGB2                                0xd003a210
#define PSDS_RGB2_dft                            0x00000100

typedef volatile union {
  struct {
    ca_uint32_t SD_DEB_SEL           :  1 ; /* bits 0:0 */
    ca_uint32_t RXIDLE_D_SEL0        :  1 ; /* bits 1:1 */
    ca_uint32_t RXIDLE_D_SEL1        :  1 ; /* bits 2:2 */
    ca_uint32_t RX_DATA_EN_SEL0      :  1 ; /* bits 3:3 */
    ca_uint32_t RX_DATA_EN_SEL1      :  1 ; /* bits 4:4 */
    ca_uint32_t CSR_LEQ_SEL          :  1 ; /* bits 5:5 */
    ca_uint32_t CSR_DFE_SEL          :  1 ; /* bits 6:6 */
    ca_uint32_t CSR_DFE_DLY_SEL      :  3 ; /* bits 9:7 */
    ca_uint32_t CSR_S0_RSTB_EQ_SEL   :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd1               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RGB2_t;


#define PSDS_RGB8                                0xd003a214
#define PSDS_RGB8_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t RX_LOS               :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  9 ;
    ca_uint32_t CKRDY_RX             :  1 ; /* bits 10:10 */
    ca_uint32_t CKRDY_TX             :  1 ; /* bits 11:11 */
    ca_uint32_t CKRDY_MPCP           :  1 ; /* bits 12:12 */
    ca_uint32_t CKRDY_SYNC2XFI       :  1 ; /* bits 13:13 */
    ca_uint32_t RXIDLE               :  1 ; /* bits 14:14 */
    ca_uint32_t BER_NOTIFY           :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd2               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_RGB8_t;


#define PSDS_GBOX_CTRL                           0xd003a218
#define PSDS_GBOX_CTRL_dft                       0x00000450

typedef volatile union {
  struct {
    ca_uint32_t prbs_rx_en           :  1 ; /* bits 0:0 */
    ca_uint32_t prbs_tx_en           :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t rx_bit_ordering      :  2 ; /* bits 5:4 */
    ca_uint32_t tx_bit_ordering      :  2 ; /* bits 7:6 */
    ca_uint32_t rx_elst_ff_rsync     :  1 ; /* bits 8:8 */
    ca_uint32_t tx_elst_ff_rsync     :  1 ; /* bits 9:9 */
    ca_uint32_t rx_1gepn_turbo_bit_ordering :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t lpbk_rx_tx_near_en   :  1 ; /* bits 13:13 */
    ca_uint32_t lpbk_tx_rx_en        :  1 ; /* bits 14:14 */
    ca_uint32_t lao_en               :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd3               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_GBOX_CTRL_t;


#define PSDS_PRBS_CTRL                           0xd003a21c
#define PSDS_PRBS_CTRL_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_prbs_mode         :  2 ; /* bits 1:0 */
    ca_uint32_t tx_insertOneBitErrorOnce :  1 ; /* bits 2:2 */
    ca_uint32_t tx_insertOneBitError :  1 ; /* bits 3:3 */
    ca_uint32_t tx_invertPrbs        :  1 ; /* bits 4:4 */
    ca_uint32_t tx_insertErrorOnce   :  1 ; /* bits 5:5 */
    ca_uint32_t tx_insertError       :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t rx_prbs_mode         :  2 ; /* bits 9:8 */
    ca_uint32_t rx_invertPrbs        :  1 ; /* bits 10:10 */
    ca_uint32_t rx_clrCnt            :  1 ; /* bits 11:11 */
    ca_uint32_t rx_prbsEnabled       :  1 ; /* bits 12:12 */
    ca_uint32_t rx_loadPrbsState     :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd2               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_PRBS_CTRL_t;


#define PSDS_PRBS_INTR                           0xd003a220
#define PSDS_PRBS_INTR_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t syncState            :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_PRBS_INTR_t;


#define PSDS_PRBS_INTRE                          0xd003a224
#define PSDS_PRBS_INTRE_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t syncStateE           :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_PRBS_INTRE_t;


#define PSDS_PRBS_STS                            0xd003a228
#define PSDS_PRBS_STS_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t syncState            :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_PRBS_STS_t;


#define PSDS_PRBS_ERR_CNT_L                      0xd003a22c
#define PSDS_PRBS_ERR_CNT_L_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t prbsErrCnt_l         : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_PRBS_ERR_CNT_L_t;


#define PSDS_PRBS_ERR_CNT_H                      0xd003a230
#define PSDS_PRBS_ERR_CNT_H_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t prbsErrCnt_h         : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_PRBS_ERR_CNT_H_t;


#define PSDS_DEBUG_MONITOR_CTRL                  0xd003a234
#define PSDS_DEBUG_MONITOR_CTRL_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dbg_CLK156_EN        :  1 ; /* bits 0:0 */
    ca_uint32_t dbg_CLK161_EN        :  1 ; /* bits 1:1 */
    ca_uint32_t dbg_CLK250_EN        :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_DEBUG_MONITOR_CTRL_t;


#define PSDS_DEBUG_MONITOR_0                     0xd003a238
#define PSDS_DEBUG_MONITOR_0_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dbg_CK125M_FX100     :  1 ; /* bits 0:0 */
    ca_uint32_t dbg_CLKRD_156        :  1 ; /* bits 1:1 */
    ca_uint32_t dbg_CLKRD_161        :  1 ; /* bits 2:2 */
    ca_uint32_t dbg_CLKRD_250        :  1 ; /* bits 3:3 */
    ca_uint32_t dbg_CLKWR_156        :  1 ; /* bits 4:4 */
    ca_uint32_t dbg_CLKWR_161        :  1 ; /* bits 5:5 */
    ca_uint32_t dbg_CLKWR_250        :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_DEBUG_MONITOR_0_t;


#define PSDS_DEBUG_MONITOR_1                     0xd003a23c
#define PSDS_DEBUG_MONITOR_1_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dbg_CMUTX_DEBUG_L    : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_DEBUG_MONITOR_1_t;


#define PSDS_DEBUG_MONITOR_2                     0xd003a240
#define PSDS_DEBUG_MONITOR_2_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dbg_CMUTX_DEBUG_H    :  6 ; /* bits 5:0 */
    ca_uint32_t dbg_DEBUG0_CLK_LA    :  1 ; /* bits 6:6 */
    ca_uint32_t dbg_DEBUG_CKREF      :  1 ; /* bits 7:7 */
    ca_uint32_t dbg_LC_CMU_DEBUG_L   :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_DEBUG_MONITOR_2_t;


#define PSDS_DEBUG_MONITOR_3                     0xd003a244
#define PSDS_DEBUG_MONITOR_3_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dbg_LC_CMU_DEBUG_H   : 14 ; /* bits 13:0 */
    ca_uint32_t dbg_RXSPD            :  2 ; /* bits 15:14 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_DEBUG_MONITOR_3_t;


#define PSDS_DEBUG_MONITOR_4                     0xd003a248
#define PSDS_DEBUG_MONITOR_4_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dbg_RX_DEBUG0_L      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_DEBUG_MONITOR_4_t;


#define PSDS_DEBUG_MONITOR_5                     0xd003a24c
#define PSDS_DEBUG_MONITOR_5_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dbg_RX_DEBUG0_H      : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_DEBUG_MONITOR_5_t;


#define PSDS_DEBUG_MONITOR_6                     0xd003a250
#define PSDS_DEBUG_MONITOR_6_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dbg_RING_CMU_DEBUG   :  3 ; /* bits 2:0 */
    ca_uint32_t dbg_S0_E2S_CK_AFE    :  1 ; /* bits 3:3 */
    ca_uint32_t dbg_S0_EYE_SCORE     :  8 ; /* bits 11:4 */
    ca_uint32_t dbg_S0_EYE_SCORE_VALID :  1 ; /* bits 12:12 */
    ca_uint32_t dbg_S0_LFPS_DET      :  1 ; /* bits 13:13 */
    ca_uint32_t dbg_S0_calib_ok      :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_DEBUG_MONITOR_6_t;


#define PSDS_DEBUG_MONITOR_7                     0xd003a254
#define PSDS_DEBUG_MONITOR_7_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dbg_S0_DEBUG_OUT_L   : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_DEBUG_MONITOR_7_t;


#define PSDS_DEBUG_MONITOR_8                     0xd003a258
#define PSDS_DEBUG_MONITOR_8_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dbg_S0_DEBUG_OUT_H   : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_DEBUG_MONITOR_8_t;


#define PSDS_DEBUG_MONITOR_9                     0xd003a25c
#define PSDS_DEBUG_MONITOR_9_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dbg_S0_ST_CDR2_BIN_RO :  6 ; /* bits 5:0 */
    ca_uint32_t dbg_S0_ST_BIN_RO     :  6 ; /* bits 11:6 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_DEBUG_MONITOR_9_t;


#define PSDS_DEBUG_MONITOR_10                    0xd003a260
#define PSDS_DEBUG_MONITOR_10_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dbg_S0_STEP_RO       :  5 ; /* bits 4:0 */
    ca_uint32_t dbg_S0_coef_data     :  8 ; /* bits 12:5 */
    ca_uint32_t rsrvd1               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_DEBUG_MONITOR_10_t;


#define PSDS_DEBUG_MONITOR_11                    0xd003a264
#define PSDS_DEBUG_MONITOR_11_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dbg_S0_dout_eye_xor  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_DEBUG_MONITOR_11_t;


#define PSDS_DEBUG_MONITOR_12                    0xd003a268
#define PSDS_DEBUG_MONITOR_12_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dbg_TX_DEBUG0        : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_DEBUG_MONITOR_12_t;


#define PSDS_DEBUG_MONITOR_13                    0xd003a26c
#define PSDS_DEBUG_MONITOR_13_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dbg_Z0_DEBUG_L       : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_DEBUG_MONITOR_13_t;


#define PSDS_DEBUG_MONITOR_14                    0xd003a270
#define PSDS_DEBUG_MONITOR_14_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dbg_Z0_DEBUG_H       :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               :  6 ;
    ca_uint32_t dbg_S0_limit_data    :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd2               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_DEBUG_MONITOR_14_t;


#define PSDS_DEBUG_CTRL                          0xd003a274
#define PSDS_DEBUG_CTRL_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sel                  :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} PSDS_DEBUG_CTRL_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PSDS_WRAP */
typedef struct {
  PSDS_RG00_t                              RG00;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  PSDS_RG01_t                              RG01;                          /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  PSDS_RG02_t                              RG02;                          /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  PSDS_RG03_t                              RG03;                          /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  PSDS_RG04_t                              RG04;                          /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  PSDS_RG05_t                              RG05;                          /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  PSDS_RG06_t                              RG06;                          /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  PSDS_RG07_t                              RG07;                          /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  PSDS_RG08_t                              RG08;                          /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  PSDS_RG09_t                              RG09;                          /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  PSDS_RG0A_t                              RG0A;                          /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  PSDS_RG0B_t                              RG0B;                          /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  PSDS_RG0C_t                              RG0C;                          /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  PSDS_RG0D_t                              RG0D;                          /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  PSDS_RG0E_t                              RG0E;                          /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  PSDS_RG0F_t                              RG0F;                          /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  PSDS_RG10_t                              RG10;                          /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  PSDS_RG11_t                              RG11;                          /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  PSDS_RG12_t                              RG12;                          /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  PSDS_RG13_t                              RG13;                          /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  PSDS_RG14_t                              RG14;                          /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  PSDS_RG15_t                              RG15;                          /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  PSDS_RG16_t                              RG16;                          /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  PSDS_RG17_t                              RG17;                          /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  PSDS_RG18_t                              RG18;                          /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  PSDS_RG19_t                              RG19;                          /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  PSDS_RG1A_t                              RG1A;                          /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  PSDS_RG1B_t                              RG1B;                          /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  PSDS_RG1C_t                              RG1C;                          /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  PSDS_RG1D_t                              RG1D;                          /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  PSDS_RG1E_t                              RG1E;                          /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  PSDS_RG1F_t                              RG1F;                          /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  PSDS_RG20_t                              RG20;                          /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  PSDS_RG21_t                              RG21;                          /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  PSDS_RG22_t                              RG22;                          /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  PSDS_RG23_t                              RG23;                          /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  PSDS_RG24_t                              RG24;                          /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  PSDS_RG25_t                              RG25;                          /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  PSDS_RG26_t                              RG26;                          /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];                   
  PSDS_RG27_t                              RG27;                          /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];                   
  PSDS_RG28_t                              RG28;                          /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];                   
  PSDS_RG29_t                              RG29;                          /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];                   
  PSDS_RG2A_t                              RG2A;                          /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];                   
  PSDS_RG2B_t                              RG2B;                          /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd44[3];                   
  PSDS_RG2C_t                              RG2C;                          /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd45[3];                   
  PSDS_RG2D_t                              RG2D;                          /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd46[3];                   
  PSDS_RG40_t                              RG40;                          /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd47[3];                   
  PSDS_RG41_t                              RG41;                          /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd48[3];                   
  PSDS_RG42_t                              RG42;                          /* addr: 0x000000c0 */
  ca_uint32_t                              rsrvd49[3];                   
  PSDS_RG43_t                              RG43;                          /* addr: 0x000000c4 */
  ca_uint32_t                              rsrvd50[3];                   
  PSDS_RG44_t                              RG44;                          /* addr: 0x000000c8 */
  ca_uint32_t                              rsrvd51[3];                   
  PSDS_RG45_t                              RG45;                          /* addr: 0x000000cc */
  ca_uint32_t                              rsrvd52[3];                   
  PSDS_RG46_t                              RG46;                          /* addr: 0x000000d0 */
  ca_uint32_t                              rsrvd53[3];                   
  PSDS_RG47_t                              RG47;                          /* addr: 0x000000d4 */
  ca_uint32_t                              rsrvd54[3];                   
  PSDS_RG48_t                              RG48;                          /* addr: 0x000000d8 */
  ca_uint32_t                              rsrvd55[3];                   
  PSDS_RG49_t                              RG49;                          /* addr: 0x000000dc */
  ca_uint32_t                              rsrvd56[3];                   
  PSDS_RG4A_t                              RG4A;                          /* addr: 0x000000e0 */
  ca_uint32_t                              rsrvd57[3];                   
  PSDS_RG4B_t                              RG4B;                          /* addr: 0x000000e4 */
  ca_uint32_t                              rsrvd58[3];                   
  PSDS_RG4C_t                              RG4C;                          /* addr: 0x000000e8 */
  ca_uint32_t                              rsrvd59[3];                   
  PSDS_RG4D_t                              RG4D;                          /* addr: 0x000000ec */
  ca_uint32_t                              rsrvd60[3];                   
  PSDS_RG4E_t                              RG4E;                          /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd61[3];                   
  PSDS_RG4F_t                              RG4F;                          /* addr: 0x000000f4 */
  ca_uint32_t                              rsrvd62[3];                   
  PSDS_RG50_t                              RG50;                          /* addr: 0x000000f8 */
  ca_uint32_t                              rsrvd63[3];                   
  PSDS_RG51_t                              RG51;                          /* addr: 0x000000fc */
  ca_uint32_t                              rsrvd64[3];                   
  PSDS_RG52_t                              RG52;                          /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd65[3];                   
  PSDS_RG53_t                              RG53;                          /* addr: 0x00000104 */
  ca_uint32_t                              rsrvd66[3];                   
  PSDS_RG54_t                              RG54;                          /* addr: 0x00000108 */
  ca_uint32_t                              rsrvd67[3];                   
  PSDS_RG55_t                              RG55;                          /* addr: 0x0000010c */
  ca_uint32_t                              rsrvd68[3];                   
  PSDS_RG56_t                              RG56;                          /* addr: 0x00000110 */
  ca_uint32_t                              rsrvd69[3];                   
  PSDS_RG57_t                              RG57;                          /* addr: 0x00000114 */
  ca_uint32_t                              rsrvd70[3];                   
  PSDS_RG58_t                              RG58;                          /* addr: 0x00000118 */
  ca_uint32_t                              rsrvd71[3];                   
  PSDS_RG59_t                              RG59;                          /* addr: 0x0000011c */
  ca_uint32_t                              rsrvd72[3];                   
  PSDS_RG5A_t                              RG5A;                          /* addr: 0x00000120 */
  ca_uint32_t                              rsrvd73[3];                   
  PSDS_RG5B_t                              RG5B;                          /* addr: 0x00000124 */
  ca_uint32_t                              rsrvd74[3];                   
  PSDS_RG5C_t                              RG5C;                          /* addr: 0x00000128 */
  ca_uint32_t                              rsrvd75[3];                   
  PSDS_RG5D_t                              RG5D;                          /* addr: 0x0000012c */
  ca_uint32_t                              rsrvd76[3];                   
  PSDS_RG5E_t                              RG5E;                          /* addr: 0x00000130 */
  ca_uint32_t                              rsrvd77[3];                   
  PSDS_RG5F_t                              RG5F;                          /* addr: 0x00000134 */
  ca_uint32_t                              rsrvd78[3];                   
  PSDS_RG60_t                              RG60;                          /* addr: 0x00000138 */
  ca_uint32_t                              rsrvd79[3];                   
  PSDS_RG61_t                              RG61;                          /* addr: 0x0000013c */
  ca_uint32_t                              rsrvd80[3];                   
  PSDS_RG62_t                              RG62;                          /* addr: 0x00000140 */
  ca_uint32_t                              rsrvd81[3];                   
  PSDS_RG63_t                              RG63;                          /* addr: 0x00000144 */
  ca_uint32_t                              rsrvd82[3];                   
  PSDS_RG64_t                              RG64;                          /* addr: 0x00000148 */
  ca_uint32_t                              rsrvd83[3];                   
  PSDS_RG65_t                              RG65;                          /* addr: 0x0000014c */
  ca_uint32_t                              rsrvd84[3];                   
  PSDS_RG66_t                              RG66;                          /* addr: 0x00000150 */
  ca_uint32_t                              rsrvd85[3];                   
  PSDS_RG67_t                              RG67;                          /* addr: 0x00000154 */
  ca_uint32_t                              rsrvd86[3];                   
  PSDS_RG68_t                              RG68;                          /* addr: 0x00000158 */
  ca_uint32_t                              rsrvd87[3];                   
  PSDS_RG69_t                              RG69;                          /* addr: 0x0000015c */
  ca_uint32_t                              rsrvd88[3];                   
  PSDS_RG6A_t                              RG6A;                          /* addr: 0x00000160 */
  ca_uint32_t                              rsrvd89[3];                   
  PSDS_RG6B_t                              RG6B;                          /* addr: 0x00000164 */
  ca_uint32_t                              rsrvd90[3];                   
  PSDS_RG6C_t                              RG6C;                          /* addr: 0x00000168 */
  ca_uint32_t                              rsrvd91[3];                   
  PSDS_RG6D_t                              RG6D;                          /* addr: 0x0000016c */
  ca_uint32_t                              rsrvd92[3];                   
  PSDS_RG6E_t                              RG6E;                          /* addr: 0x00000170 */
  ca_uint32_t                              rsrvd93[3];                   
  PSDS_RG6F_t                              RG6F;                          /* addr: 0x00000174 */
  ca_uint32_t                              rsrvd94[3];                   
  PSDS_RG70_t                              RG70;                          /* addr: 0x00000178 */
  ca_uint32_t                              rsrvd95[3];                   
  PSDS_RG71_t                              RG71;                          /* addr: 0x0000017c */
  ca_uint32_t                              rsrvd96[3];                   
  PSDS_RG72_t                              RG72;                          /* addr: 0x00000180 */
  ca_uint32_t                              rsrvd97[3];                   
  PSDS_RG73_t                              RG73;                          /* addr: 0x00000184 */
  ca_uint32_t                              rsrvd98[3];                   
  PSDS_RG74_t                              RG74;                          /* addr: 0x00000188 */
  ca_uint32_t                              rsrvd99[3];                   
  PSDS_RG75_t                              RG75;                          /* addr: 0x0000018c */
  ca_uint32_t                              rsrvd100[3];                  
  PSDS_RG76_t                              RG76;                          /* addr: 0x00000190 */
  ca_uint32_t                              rsrvd101[3];                  
  PSDS_RG77_t                              RG77;                          /* addr: 0x00000194 */
  ca_uint32_t                              rsrvd102[3];                  
  PSDS_RG78_t                              RG78;                          /* addr: 0x00000198 */
  ca_uint32_t                              rsrvd103[3];                  
  PSDS_RG79_t                              RG79;                          /* addr: 0x0000019c */
  ca_uint32_t                              rsrvd104[3];                  
  PSDS_RG7A_t                              RG7A;                          /* addr: 0x000001a0 */
  ca_uint32_t                              rsrvd105[3];                  
  PSDS_RG7B_t                              RG7B;                          /* addr: 0x000001a4 */
  ca_uint32_t                              rsrvd106[3];                  
  PSDS_RG7C_t                              RG7C;                          /* addr: 0x000001a8 */
  ca_uint32_t                              rsrvd107[3];                  
  PSDS_RG7D_t                              RG7D;                          /* addr: 0x000001ac */
  ca_uint32_t                              rsrvd108[3];                  
  PSDS_RG7E_t                              RG7E;                          /* addr: 0x000001b0 */
  ca_uint32_t                              rsrvd109[3];                  
  PSDS_RG7F_t                              RG7F;                          /* addr: 0x000001b4 */
  ca_uint32_t                              rsrvd110[3];                  
  PSDS_RG80_t                              RG80;                          /* addr: 0x000001b8 */
  ca_uint32_t                              rsrvd111[3];                  
  PSDS_RG81_t                              RG81;                          /* addr: 0x000001bc */
  ca_uint32_t                              rsrvd112[3];                  
  PSDS_RG90_t                              RG90;                          /* addr: 0x000001c0 */
  ca_uint32_t                              rsrvd113[3];                  
  PSDS_RG91_t                              RG91;                          /* addr: 0x000001c4 */
  ca_uint32_t                              rsrvd114[3];                  
  PSDS_RG92_t                              RG92;                          /* addr: 0x000001c8 */
  ca_uint32_t                              rsrvd115[3];                  
  PSDS_RG93_t                              RG93;                          /* addr: 0x000001cc */
  ca_uint32_t                              rsrvd116[3];                  
  PSDS_RG94_t                              RG94;                          /* addr: 0x000001d0 */
  ca_uint32_t                              rsrvd117[3];                  
  PSDS_RG95_t                              RG95;                          /* addr: 0x000001d4 */
  ca_uint32_t                              rsrvd118[3];                  
  PSDS_RG96_t                              RG96;                          /* addr: 0x000001d8 */
  ca_uint32_t                              rsrvd119[3];                  
  PSDS_RG97_t                              RG97;                          /* addr: 0x000001dc */
  ca_uint32_t                              rsrvd120[3];                  
  PSDS_RG98_t                              RG98;                          /* addr: 0x000001e0 */
  ca_uint32_t                              rsrvd121[3];                  
  PSDS_RG99_t                              RG99;                          /* addr: 0x000001e4 */
  ca_uint32_t                              rsrvd122[3];                  
  PSDS_RG9A_t                              RG9A;                          /* addr: 0x000001e8 */
  ca_uint32_t                              rsrvd123[3];                  
  PSDS_RG9B_t                              RG9B;                          /* addr: 0x000001ec */
  ca_uint32_t                              rsrvd124[3];                  
  PSDS_RG9C_t                              RG9C;                          /* addr: 0x000001f0 */
  ca_uint32_t                              rsrvd125[3];                  
  PSDS_RG9D_t                              RG9D;                          /* addr: 0x000001f4 */
  ca_uint32_t                              rsrvd126[3];                  
  PSDS_RG9E_t                              RG9E;                          /* addr: 0x000001f8 */
  ca_uint32_t                              rsrvd127[3];                  
  PSDS_RG9F_t                              RG9F;                          /* addr: 0x000001fc */
  ca_uint32_t                              rsrvd128[3];                  
  PSDS_RGA0_t                              RGA0;                          /* addr: 0x00000200 */
  ca_uint32_t                              rsrvd129[3];                  
  PSDS_RGA1_t                              RGA1;                          /* addr: 0x00000204 */
  ca_uint32_t                              rsrvd130[3];                  
  PSDS_RGB0_t                              RGB0;                          /* addr: 0x00000208 */
  ca_uint32_t                              rsrvd131[3];                  
  PSDS_RGB1_t                              RGB1;                          /* addr: 0x0000020c */
  ca_uint32_t                              rsrvd132[3];                  
  PSDS_RGB2_t                              RGB2;                          /* addr: 0x00000210 */
  ca_uint32_t                              rsrvd133[3];                  
  PSDS_RGB8_t                              RGB8;                          /* addr: 0x00000214 */
  ca_uint32_t                              rsrvd134[3];                  
  PSDS_GBOX_CTRL_t                         GBOX_CTRL;                     /* addr: 0x00000218 */
  ca_uint32_t                              rsrvd135[3];                  
  PSDS_PRBS_CTRL_t                         PRBS_CTRL;                     /* addr: 0x0000021c */
  ca_uint32_t                              rsrvd136[3];                  
  PSDS_PRBS_INTR_t                         PRBS_INTR;                     /* addr: 0x00000220 */
  ca_uint32_t                              rsrvd137[3];                  
  PSDS_PRBS_INTRE_t                        PRBS_INTRE;                    /* addr: 0x00000224 */
  ca_uint32_t                              rsrvd138[3];                  
  PSDS_PRBS_STS_t                          PRBS_STS;                      /* addr: 0x00000228 */
  ca_uint32_t                              rsrvd139[3];                  
  PSDS_PRBS_ERR_CNT_L_t                    PRBS_ERR_CNT_L;                /* addr: 0x0000022c */
  ca_uint32_t                              rsrvd140[3];                  
  PSDS_PRBS_ERR_CNT_H_t                    PRBS_ERR_CNT_H;                /* addr: 0x00000230 */
  ca_uint32_t                              rsrvd141[3];                  
  PSDS_DEBUG_MONITOR_CTRL_t                DEBUG_MONITOR_CTRL;            /* addr: 0x00000234 */
  ca_uint32_t                              rsrvd142[3];                  
  PSDS_DEBUG_MONITOR_0_t                   DEBUG_MONITOR_0;               /* addr: 0x00000238 */
  ca_uint32_t                              rsrvd143[3];                  
  PSDS_DEBUG_MONITOR_1_t                   DEBUG_MONITOR_1;               /* addr: 0x0000023c */
  ca_uint32_t                              rsrvd144[3];                  
  PSDS_DEBUG_MONITOR_2_t                   DEBUG_MONITOR_2;               /* addr: 0x00000240 */
  ca_uint32_t                              rsrvd145[3];                  
  PSDS_DEBUG_MONITOR_3_t                   DEBUG_MONITOR_3;               /* addr: 0x00000244 */
  ca_uint32_t                              rsrvd146[3];                  
  PSDS_DEBUG_MONITOR_4_t                   DEBUG_MONITOR_4;               /* addr: 0x00000248 */
  ca_uint32_t                              rsrvd147[3];                  
  PSDS_DEBUG_MONITOR_5_t                   DEBUG_MONITOR_5;               /* addr: 0x0000024c */
  ca_uint32_t                              rsrvd148[3];                  
  PSDS_DEBUG_MONITOR_6_t                   DEBUG_MONITOR_6;               /* addr: 0x00000250 */
  ca_uint32_t                              rsrvd149[3];                  
  PSDS_DEBUG_MONITOR_7_t                   DEBUG_MONITOR_7;               /* addr: 0x00000254 */
  ca_uint32_t                              rsrvd150[3];                  
  PSDS_DEBUG_MONITOR_8_t                   DEBUG_MONITOR_8;               /* addr: 0x00000258 */
  ca_uint32_t                              rsrvd151[3];                  
  PSDS_DEBUG_MONITOR_9_t                   DEBUG_MONITOR_9;               /* addr: 0x0000025c */
  ca_uint32_t                              rsrvd152[3];                  
  PSDS_DEBUG_MONITOR_10_t                  DEBUG_MONITOR_10;              /* addr: 0x00000260 */
  ca_uint32_t                              rsrvd153[3];                  
  PSDS_DEBUG_MONITOR_11_t                  DEBUG_MONITOR_11;              /* addr: 0x00000264 */
  ca_uint32_t                              rsrvd154[3];                  
  PSDS_DEBUG_MONITOR_12_t                  DEBUG_MONITOR_12;              /* addr: 0x00000268 */
  ca_uint32_t                              rsrvd155[3];                  
  PSDS_DEBUG_MONITOR_13_t                  DEBUG_MONITOR_13;              /* addr: 0x0000026c */
  ca_uint32_t                              rsrvd156[3];                  
  PSDS_DEBUG_MONITOR_14_t                  DEBUG_MONITOR_14;              /* addr: 0x00000270 */
  ca_uint32_t                              rsrvd157[3];                  
  PSDS_DEBUG_CTRL_t                        DEBUG_CTRL;                    /* addr: 0x00000274 */
} APB1_PSDS_WRAP_t;

    
  
        
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* APB1 */

typedef struct {
  APB1_EPON_t                              EPON;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[8043];                 
  APB1_XGPN_t                              XGPN;                          /* addr: 0x00004000 */
  ca_uint32_t                              rsrvd2[4595];                 
  APB1_GPON_MAC_t                          GPON_MAC;                      /* addr: 0x00006000 */
  ca_uint32_t                              rsrvd3[4597];                 
  APB1_PUC_t                               PUC;                           /* addr: 0x00008000 */
  ca_uint32_t                              rsrvd4[3911];                 
  APB1_PDC_t                               PDC;                           /* addr: 0x00009000 */
  ca_uint32_t                              rsrvd5[4071];                 
  APB1_PSDS_WRAP_t                         PSDS_WRAP;                     /* addr: 0x0000a000 */
} APB1_PON_t;


/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/


#endif /* _CA827X_REGISTERS_H_ */
