/*
 * REGISTERS.h
 *
 * THIS FILE WAS AUTOMATICALLY GENERATED BY /auto/project/bin/rdb2tt.pl
 * -config /home/rtseng/reg_generator/rdb2h.yml -db ./reg.db
 *
 */
#ifndef _G3_REGISTERS_H_
#define _G3_REGISTERS_H_

#include "ca_types.h"

/******************************************************************
 *
 * Each register in the map is defined as a struct with bitfields.
 *
 ******************************************************************/

/*
 * APB0
 */
  
/*
 * L2FE
 */
  
/*
 * GLB
 */
        
#define L2FE_GLB_VER_CTRL                        0xf4301000
#define L2FE_GLB_VER_CTRL_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rev_id               : 16 ; /* bits 15:0 */
    ca_uint32_t ver_id               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_VER_CTRL_t;


#define L2FE_GLB_CTRL                            0xf4301004
#define L2FE_GLB_CTRL_dft                        0x00000014

typedef volatile union {
  struct {
    ca_uint32_t soft_reset           :  1 ; /* bits 0:0 */
    ca_uint32_t pipeline_clk_num     :  5 ; /* bits 5:1 */
    ca_uint32_t change_ip_if_pop_en  :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_CTRL_t;


#define L2FE_GLB_INTERRUPT                       0xf4301008
#define L2FE_GLB_INTERRUPT_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t lf_overflow_intI     :  1 ; /* bits 1:1 */
    ca_uint32_t ple_hd_ff_overflow_intI :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd2               :  5 ;
    ca_uint32_t port_mac_lmt_excd_intI :  1 ; /* bits 8:8 */
    ca_uint32_t l2e_hash_collision_intI :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd3               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_INTERRUPT_t;


#define L2FE_GLB_INTERRUPTE                      0xf430100c
#define L2FE_GLB_INTERRUPTE_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t lf_overflow_intIE    :  1 ; /* bits 1:1 */
    ca_uint32_t ple_hd_ff_overflow_intIE :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd2               :  5 ;
    ca_uint32_t port_mac_lmt_excd_intIE :  1 ; /* bits 8:8 */
    ca_uint32_t l2e_hash_collision_intIE :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd3               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_INTERRUPTE_t;


#define L2FE_GLB_STTS                            0xf4301010
#define L2FE_GLB_STTS_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t l2fe_init_done       :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_STTS_t;


#define L2FE_GLB_L2FE_CFG_SPARE                  0xf4301014
#define L2FE_GLB_L2FE_CFG_SPARE_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bit                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_L2FE_CFG_SPARE_t;


#define L2FE_GLB_L2FE_STTS_SPARE                 0xf4301018
#define L2FE_GLB_L2FE_STTS_SPARE_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bit                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_L2FE_STTS_SPARE_t;


#define L2FE_GLB_DEBUG                           0xf430101c
#define L2FE_GLB_DEBUG_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bus_sel              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_GLB_DEBUG_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* GLB */
typedef struct {
  L2FE_GLB_VER_CTRL_t                      VER_CTRL;                      /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  L2FE_GLB_CTRL_t                          CTRL;                          /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  L2FE_GLB_INTERRUPT_t                     INTERRUPT;                     /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  L2FE_GLB_INTERRUPTE_t                    INTERRUPTE;                    /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  L2FE_GLB_STTS_t                          STTS;                          /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  L2FE_GLB_L2FE_CFG_SPARE_t                L2FE_CFG_SPARE;                /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  L2FE_GLB_L2FE_STTS_SPARE_t               L2FE_STTS_SPARE;               /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  L2FE_GLB_DEBUG_t                         _DEBUG;                        /* addr: 0x0000001c */
} APB0_L2FE_GLB_t;


/*
 * PP
 */
        
#define L2FE_PP_PPID_ATTR_CFG                    0xf4301100
#define L2FE_PP_PPID_ATTR_CFG_dft                0x009d0000

typedef volatile union {
  struct {
    ca_uint32_t ppid0                :  2 ; /* bits 1:0 */
    ca_uint32_t ppid1                :  2 ; /* bits 3:2 */
    ca_uint32_t ppid2                :  2 ; /* bits 5:4 */
    ca_uint32_t ppid3                :  2 ; /* bits 7:6 */
    ca_uint32_t ppid4                :  2 ; /* bits 9:8 */
    ca_uint32_t ppid5                :  2 ; /* bits 11:10 */
    ca_uint32_t ppid6                :  2 ; /* bits 13:12 */
    ca_uint32_t ppid7                :  2 ; /* bits 15:14 */
    ca_uint32_t ppid8                :  2 ; /* bits 17:16 */
    ca_uint32_t ppid9                :  2 ; /* bits 19:18 */
    ca_uint32_t ppid10               :  2 ; /* bits 21:20 */
    ca_uint32_t ppid11               :  2 ; /* bits 23:22 */
    ca_uint32_t ppid12               :  2 ; /* bits 25:24 */
    ca_uint32_t ppid13               :  2 ; /* bits 27:26 */
    ca_uint32_t ppid14               :  2 ; /* bits 29:28 */
    ca_uint32_t ppid15               :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_PPID_ATTR_CFG_t;


#define L2FE_PP_DPB_CTRL                         0xf4301104
#define L2FE_PP_DPB_CTRL_dft                     0x00000003

typedef volatile union {
  struct {
    ca_uint32_t ldpid_pattern        :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_DPB_CTRL_t;


#define L2FE_PP_TPID_CMP_S                       0xf4301108
#define L2FE_PP_TPID_CMP_S_dft                   0x00008100

typedef volatile union {
  struct {
    ca_uint32_t tpid                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_TPID_CMP_S_t;


#define L2FE_PP_TPID_CMP_C                       0xf430110c
#define L2FE_PP_TPID_CMP_C_dft                   0x00008100

typedef volatile union {
  struct {
    ca_uint32_t tpid                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_TPID_CMP_C_t;


#define L2FE_PP_TPID_CMP_O                       0xf4301110
#define L2FE_PP_TPID_CMP_O_dft                   0x00008100

typedef volatile union {
  struct {
    ca_uint32_t tpid                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_TPID_CMP_O_t;


#define L2FE_PP_HELLO_PKT_ENABLE_DA_LOW          0xf4301114
#define L2FE_PP_HELLO_PKT_ENABLE_DA_LOW_dft      0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t enable               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_HELLO_PKT_ENABLE_DA_LOW_t;


#define L2FE_PP_HELLO_PKT_ENABLE_DA_HI           0xf4301118
#define L2FE_PP_HELLO_PKT_ENABLE_DA_HI_dft       0x0000ffff

typedef volatile union {
  struct {
    ca_uint32_t enable               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_HELLO_PKT_ENABLE_DA_HI_t;


#define L2FE_PP_HELLO_PKT_DA_LOW                 0xf430111c
#define L2FE_PP_HELLO_PKT_DA_LOW_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_HELLO_PKT_DA_LOW_t;


#define L2FE_PP_HELLO_PKT_DA_HI                  0xf4301120
#define L2FE_PP_HELLO_PKT_DA_HI_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_HELLO_PKT_DA_HI_t;


#define L2FE_PP_SPECIAL_ENABLE_DA_0_LOW          0xf4301124
#define L2FE_PP_SPECIAL_ENABLE_DA_0_LOW_dft      0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t enable               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_SPECIAL_ENABLE_DA_0_LOW_t;


#define L2FE_PP_SPECIAL_ENABLE_DA_0_HI           0xf4301128
#define L2FE_PP_SPECIAL_ENABLE_DA_0_HI_dft       0x0000ffff

typedef volatile union {
  struct {
    ca_uint32_t enable               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_SPECIAL_ENABLE_DA_0_HI_t;


#define L2FE_PP_SPECIAL_DA_0_LOW                 0xf430112c
#define L2FE_PP_SPECIAL_DA_0_LOW_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_SPECIAL_DA_0_LOW_t;


#define L2FE_PP_SPECIAL_DA_0_HI                  0xf4301130
#define L2FE_PP_SPECIAL_DA_0_HI_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_SPECIAL_DA_0_HI_t;


#define L2FE_PP_SPECIAL_EV2PT                    0xf4301134
#define L2FE_PP_SPECIAL_EV2PT_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ev2pt                : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_SPECIAL_EV2PT_t;


#define L2FE_PP_SPECIAL_ENABLE_DA_1_LOW          0xf4301138
#define L2FE_PP_SPECIAL_ENABLE_DA_1_LOW_dft      0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t enable               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_SPECIAL_ENABLE_DA_1_LOW_t;


#define L2FE_PP_SPECIAL_ENABLE_DA_1_HI           0xf430113c
#define L2FE_PP_SPECIAL_ENABLE_DA_1_HI_dft       0x0000ffff

typedef volatile union {
  struct {
    ca_uint32_t enable               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_SPECIAL_ENABLE_DA_1_HI_t;


#define L2FE_PP_SPECIAL_DA_1_LOW                 0xf4301140
#define L2FE_PP_SPECIAL_DA_1_LOW_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_SPECIAL_DA_1_LOW_t;


#define L2FE_PP_SPECIAL_DA_1_HI                  0xf4301144
#define L2FE_PP_SPECIAL_DA_1_HI_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_SPECIAL_DA_1_HI_t;


#define L2FE_PP_SPECIAL_VLAN                     0xf4301148
#define L2FE_PP_SPECIAL_VLAN_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vlan                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_SPECIAL_VLAN_t;


#define L2FE_PP_MY_MAC_LOW                       0xf430114c
#define L2FE_PP_MY_MAC_LOW_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_MY_MAC_LOW_t;


#define L2FE_PP_MY_MAC_HI                        0xf4301150
#define L2FE_PP_MY_MAC_HI_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_MY_MAC_HI_t;


#define L2FE_PP_MY_MAC_ENABLE_LOW                0xf4301154
#define L2FE_PP_MY_MAC_ENABLE_LOW_dft            0x00ffffff

typedef volatile union {
  struct {
    ca_uint32_t enable               : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_MY_MAC_ENABLE_LOW_t;


#define L2FE_PP_MY_MAC_LOW_1                     0xf4301158
#define L2FE_PP_MY_MAC_LOW_1_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_MY_MAC_LOW_1_t;


#define L2FE_PP_MY_MAC_HI_1                      0xf430115c
#define L2FE_PP_MY_MAC_HI_1_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_MY_MAC_HI_1_t;


#define L2FE_PP_MY_MAC_ENABLE_LOW_1              0xf4301160
#define L2FE_PP_MY_MAC_ENABLE_LOW_1_dft          0x00ffffff

typedef volatile union {
  struct {
    ca_uint32_t enable               : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_MY_MAC_ENABLE_LOW_1_t;


#define L2FE_PP_RSV_MAC_MC_LOW                   0xf4301164
#define L2FE_PP_RSV_MAC_MC_LOW_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_RSV_MAC_MC_LOW_t;


#define L2FE_PP_RSV_MAC_MC_HI                    0xf4301168
#define L2FE_PP_RSV_MAC_MC_HI_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_RSV_MAC_MC_HI_t;


#define L2FE_PP_RSV_ENABLE_MC_LOW                0xf430116c
#define L2FE_PP_RSV_ENABLE_MC_LOW_dft            0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t enable               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_RSV_ENABLE_MC_LOW_t;


#define L2FE_PP_RSV_ENABLE_MC_HI                 0xf4301170
#define L2FE_PP_RSV_ENABLE_MC_HI_dft             0x0000ffff

typedef volatile union {
  struct {
    ca_uint32_t enable               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_RSV_ENABLE_MC_HI_t;


#define L2FE_PP_RSV_GROUP_MAC_LOW                0xf4301174
#define L2FE_PP_RSV_GROUP_MAC_LOW_dft            0xc2000000

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_RSV_GROUP_MAC_LOW_t;


#define L2FE_PP_RSV_GROUP_MAC_HI                 0xf4301178
#define L2FE_PP_RSV_GROUP_MAC_HI_dft             0x00000180

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_RSV_GROUP_MAC_HI_t;


#define L2FE_PP_RSV_GROUP_ENABLE_LOW             0xf430117c
#define L2FE_PP_RSV_GROUP_ENABLE_LOW_dft         0xfffffff0

typedef volatile union {
  struct {
    ca_uint32_t enable               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_RSV_GROUP_ENABLE_LOW_t;


#define L2FE_PP_RSV_GROUP_ENABLE_HI              0xf4301180
#define L2FE_PP_RSV_GROUP_ENABLE_HI_dft          0x0000ffff

typedef volatile union {
  struct {
    ca_uint32_t enable               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_RSV_GROUP_ENABLE_HI_t;


#define L2FE_PP_MEF_OAM_MAC_0_LOW                0xf4301184
#define L2FE_PP_MEF_OAM_MAC_0_LOW_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_MEF_OAM_MAC_0_LOW_t;


#define L2FE_PP_MEF_OAM_MAC_0_HI                 0xf4301188
#define L2FE_PP_MEF_OAM_MAC_0_HI_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_MEF_OAM_MAC_0_HI_t;


#define L2FE_PP_MEF_OAM_TYPE_0                   0xf430118c
#define L2FE_PP_MEF_OAM_TYPE_0_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t type                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_MEF_OAM_TYPE_0_t;


#define L2FE_PP_MEF_OAM_MAC_1_LOW                0xf4301190
#define L2FE_PP_MEF_OAM_MAC_1_LOW_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_MEF_OAM_MAC_1_LOW_t;


#define L2FE_PP_MEF_OAM_MAC_1_HI                 0xf4301194
#define L2FE_PP_MEF_OAM_MAC_1_HI_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_MEF_OAM_MAC_1_HI_t;


#define L2FE_PP_MEF_OAM_TYPE_1                   0xf4301198
#define L2FE_PP_MEF_OAM_TYPE_1_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t type                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_MEF_OAM_TYPE_1_t;


#define L2FE_PP_L7_OFFSET                        0xf430119c
#define L2FE_PP_L7_OFFSET_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t offset               :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_L7_OFFSET_t;


#define L2FE_PP_NI_INTF_ERR_STTS_0               0xf43011a0
#define L2FE_PP_NI_INTF_ERR_STTS_0_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sop_eop_mismatch_0   :  1 ; /* bits 0:0 */
    ca_uint32_t sop_eop_mismatch_1   :  1 ; /* bits 1:1 */
    ca_uint32_t sop_eop_mismatch_2   :  1 ; /* bits 2:2 */
    ca_uint32_t sop_eop_mismatch_3   :  1 ; /* bits 3:3 */
    ca_uint32_t sop_eop_mismatch_4   :  1 ; /* bits 4:4 */
    ca_uint32_t sop_eop_mismatch_5   :  1 ; /* bits 5:5 */
    ca_uint32_t sop_eop_mismatch_6   :  1 ; /* bits 6:6 */
    ca_uint32_t sop_eop_mismatch_7   :  1 ; /* bits 7:7 */
    ca_uint32_t sop_eop_mismatch_8   :  1 ; /* bits 8:8 */
    ca_uint32_t sop_eop_mismatch_9   :  1 ; /* bits 9:9 */
    ca_uint32_t sop_eop_mismatch_10  :  1 ; /* bits 10:10 */
    ca_uint32_t sop_eop_mismatch_11  :  1 ; /* bits 11:11 */
    ca_uint32_t sop_eop_mismatch_12  :  1 ; /* bits 12:12 */
    ca_uint32_t sop_eop_mismatch_13  :  1 ; /* bits 13:13 */
    ca_uint32_t sop_eop_mismatch_14  :  1 ; /* bits 14:14 */
    ca_uint32_t sop_eop_mismatch_15  :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_NI_INTF_ERR_STTS_0_t;


#define L2FE_PP_NI_INTF_ERR_STTS_1               0xf43011a4
#define L2FE_PP_NI_INTF_ERR_STTS_1_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t runt_l2_pkt_0        :  1 ; /* bits 0:0 */
    ca_uint32_t runt_l2_pkt_1        :  1 ; /* bits 1:1 */
    ca_uint32_t runt_l2_pkt_2        :  1 ; /* bits 2:2 */
    ca_uint32_t runt_l2_pkt_3        :  1 ; /* bits 3:3 */
    ca_uint32_t runt_l2_pkt_4        :  1 ; /* bits 4:4 */
    ca_uint32_t runt_l2_pkt_5        :  1 ; /* bits 5:5 */
    ca_uint32_t runt_l2_pkt_6        :  1 ; /* bits 6:6 */
    ca_uint32_t runt_l2_pkt_7        :  1 ; /* bits 7:7 */
    ca_uint32_t runt_l2_pkt_8        :  1 ; /* bits 8:8 */
    ca_uint32_t runt_l2_pkt_9        :  1 ; /* bits 9:9 */
    ca_uint32_t runt_l2_pkt_10       :  1 ; /* bits 10:10 */
    ca_uint32_t runt_l2_pkt_11       :  1 ; /* bits 11:11 */
    ca_uint32_t runt_l2_pkt_12       :  1 ; /* bits 12:12 */
    ca_uint32_t runt_l2_pkt_13       :  1 ; /* bits 13:13 */
    ca_uint32_t runt_l2_pkt_14       :  1 ; /* bits 14:14 */
    ca_uint32_t runt_l2_pkt_15       :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_NI_INTF_ERR_STTS_1_t;


#define L2FE_PP_NI_INTF_ERR_STTS_2               0xf43011a8
#define L2FE_PP_NI_INTF_ERR_STTS_2_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sob_eob_mismatch_0   :  1 ; /* bits 0:0 */
    ca_uint32_t sob_eob_mismatch_1   :  1 ; /* bits 1:1 */
    ca_uint32_t sob_eob_mismatch_2   :  1 ; /* bits 2:2 */
    ca_uint32_t sob_eob_mismatch_3   :  1 ; /* bits 3:3 */
    ca_uint32_t sob_eob_mismatch_4   :  1 ; /* bits 4:4 */
    ca_uint32_t sob_eob_mismatch_5   :  1 ; /* bits 5:5 */
    ca_uint32_t sob_eob_mismatch_6   :  1 ; /* bits 6:6 */
    ca_uint32_t sob_eob_mismatch_7   :  1 ; /* bits 7:7 */
    ca_uint32_t sob_eob_mismatch_8   :  1 ; /* bits 8:8 */
    ca_uint32_t sob_eob_mismatch_9   :  1 ; /* bits 9:9 */
    ca_uint32_t sob_eob_mismatch_10  :  1 ; /* bits 10:10 */
    ca_uint32_t sob_eob_mismatch_11  :  1 ; /* bits 11:11 */
    ca_uint32_t sob_eob_mismatch_12  :  1 ; /* bits 12:12 */
    ca_uint32_t sob_eob_mismatch_13  :  1 ; /* bits 13:13 */
    ca_uint32_t sob_eob_mismatch_14  :  1 ; /* bits 14:14 */
    ca_uint32_t sob_eob_mismatch_15  :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_NI_INTF_ERR_STTS_2_t;


#define L2FE_PP_NI_INTF_ERR_STTS_3               0xf43011ac
#define L2FE_PP_NI_INTF_ERR_STTS_3_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sop_2_sop_gap        :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_NI_INTF_ERR_STTS_3_t;


#define L2FE_PP_PINGPONG_STS                     0xf43011b0
#define L2FE_PP_PINGPONG_STS_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ovfl                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_PINGPONG_STS_t;


#define L2FE_PP_NI_INTF_STS                      0xf43011b4
#define L2FE_PP_NI_INTF_STS_dft                  0x00000001

typedef volatile union {
  struct {
    ca_uint32_t rdy                  :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_NI_INTF_STS_t;


#define L2FE_PP_NI_INTF_DROP_CNT                 0xf43011b8
#define L2FE_PP_NI_INTF_DROP_CNT_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t drop                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_NI_INTF_DROP_CNT_t;


#define L2FE_PP_NI_INTF_PKT_CNT                  0xf43011bc
#define L2FE_PP_NI_INTF_PKT_CNT_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t eop                  : 16 ; /* bits 15:0 */
    ca_uint32_t sop                  : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_NI_INTF_PKT_CNT_t;


#define L2FE_PP_HEADER_A_LOW                     0xf43011c0
#define L2FE_PP_HEADER_A_LOW_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_HEADER_A_LOW_t;


#define L2FE_PP_HEADER_A_MID                     0xf43011c4
#define L2FE_PP_HEADER_A_MID_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_HEADER_A_MID_t;


#define L2FE_PP_HEADER_A_HI                      0xf43011c8
#define L2FE_PP_HEADER_A_HI_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_HEADER_A_HI_t;


#define L2FE_PP_PARSER_CTRL                      0xf43011cc
#define L2FE_PP_PARSER_CTRL_dft                  0xa03b0000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 14 ;
    ca_uint32_t use_ip_addr_mc       :  1 ; /* bits 14:14 */
    ca_uint32_t l3fe_to_l2fe_lrn_ctrl :  1 ; /* bits 15:15 */
    ca_uint32_t egr_ptp_pkt_no_drop_set :  1 ; /* bits 16:16 */
    ca_uint32_t ipv4_checksum_check_enable :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t detect_oam_subtype   :  1 ; /* bits 19:19 */
    ca_uint32_t oam_subtype          :  8 ; /* bits 27:20 */
    ca_uint32_t udf0_det_en          :  1 ; /* bits 28:28 */
    ca_uint32_t udf0_det_type_en     :  1 ; /* bits 29:29 */
    ca_uint32_t udf1_det_en          :  1 ; /* bits 30:30 */
    ca_uint32_t udf1_det_vlan_en     :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_PARSER_CTRL_t;


#define L2FE_PP_SPECIAL_PKT                      0xf43011d0
#define L2FE_PP_SPECIAL_PKT_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t type                 :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_SPECIAL_PKT_t;


#define L2FE_PP_DEBUG_BUS                        0xf43011d4
#define L2FE_PP_DEBUG_BUS_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sel                  :  4 ; /* bits 3:0 */
    ca_uint32_t ni2fe_pkt_cnt_wrap_en :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_DEBUG_BUS_t;


#define L2FE_PP_IPPB_ACCESS                      0xf43011d8
#define L2FE_PP_IPPB_ACCESS_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_IPPB_ACCESS_t;


#define L2FE_PP_IPPB_DATA                        0xf43011dc
#define L2FE_PP_IPPB_DATA_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t lspid                :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_IPPB_DATA_t;


#define L2FE_PP_ILPB_ACCESS                      0xf43011e0
#define L2FE_PP_ILPB_ACCESS_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_ILPB_ACCESS_t;


#define L2FE_PP_ILPB_DATA4                       0xf43011e4
#define L2FE_PP_ILPB_DATA4_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ilpb_reserved_1      : 10 ; /* bits 9:0 */
    ca_uint32_t ilpb_wan_ind         :  1 ; /* bits 10:10 */
    ca_uint32_t ilpb_reserved        :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_ILPB_DATA4_t;


#define L2FE_PP_ILPB_DATA3                       0xf43011e8
#define L2FE_PP_ILPB_DATA3_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ilpb_sc_ind          :  1 ; /* bits 0:0 */
    ca_uint32_t ilpb_default_vlanid  : 12 ; /* bits 12:1 */
    ca_uint32_t ilpb_unkwn_pol_idx   :  3 ; /* bits 15:13 */
    ca_uint32_t ilpb_flowid_as_gemid :  1 ; /* bits 16:16 */
    ca_uint32_t ilpb_gemid_dynamic_mode :  1 ; /* bits 17:17 */
    ca_uint32_t ilpb_reserved_1      : 14 ; /* bits 31:18 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_ILPB_DATA3_t;


#define L2FE_PP_ILPB_DATA2                       0xf43011ec
#define L2FE_PP_ILPB_DATA2_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ilpb_other_tpid_match :  4 ; /* bits 3:0 */
    ca_uint32_t ilpb_inner_c_tpid_enable :  1 ; /* bits 4:4 */
    ca_uint32_t ilpb_inner_s_tpid_enable :  1 ; /* bits 5:5 */
    ca_uint32_t ilpb_top_c_tpid_enable :  1 ; /* bits 6:6 */
    ca_uint32_t ilpb_top_s_tpid_enable :  1 ; /* bits 7:7 */
    ca_uint32_t ilpb_c_tpid_match    :  4 ; /* bits 11:8 */
    ca_uint32_t ilpb_s_tpid_match    :  4 ; /* bits 15:12 */
    ca_uint32_t ilpb_drop_doubletagged_packet :  1 ; /* bits 16:16 */
    ca_uint32_t ilpb_drop_prytagged_packet :  1 ; /* bits 17:17 */
    ca_uint32_t ilpb_drop_untagged_packet :  1 ; /* bits 18:18 */
    ca_uint32_t ilpb_drop_ctag_packet :  1 ; /* bits 19:19 */
    ca_uint32_t ilpb_drop_stag_packet :  1 ; /* bits 20:20 */
    ca_uint32_t ilpb_drop_singletagged_packet :  1 ; /* bits 21:21 */
    ca_uint32_t ilpb_default_noninnertag_cmd :  1 ; /* bits 22:22 */
    ca_uint32_t ilpb_inner_vlan_cmd  :  2 ; /* bits 24:23 */
    ca_uint32_t ilpb_inner_vid_sel_bm :  2 ; /* bits 26:25 */
    ca_uint32_t ilpb_default_untag_cmd :  1 ; /* bits 27:27 */
    ca_uint32_t ilpb_default_top_vlan_cmd :  2 ; /* bits 29:28 */
    ca_uint32_t ilpb_vlan_cmd_sel_bm :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_ILPB_DATA2_t;


#define L2FE_PP_ILPB_DATA1                       0xf43011f0
#define L2FE_PP_ILPB_DATA1_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ilpb_802_1p_mark_control_bm :  1 ; /* bits 0:0 */
    ca_uint32_t ilpb_change_1p_if_pop :  1 ; /* bits 1:1 */
    ca_uint32_t ilpb_top_802_1p_mode_sel :  2 ; /* bits 3:2 */
    ca_uint32_t ilpb_flowid_sel_bm   :  3 ; /* bits 6:4 */
    ca_uint32_t ilpb_cls_length      :  6 ; /* bits 12:7 */
    ca_uint32_t ilpb_cls_start       :  8 ; /* bits 20:13 */
    ca_uint32_t ilpb_igr_cls_lookup_en :  1 ; /* bits 21:21 */
    ca_uint32_t ilpb_spcl_pkt_idx    :  4 ; /* bits 25:22 */
    ca_uint32_t ilpb_da_sa_swap_en   :  1 ; /* bits 26:26 */
    ca_uint32_t ilpb_loop_enable     :  1 ; /* bits 27:27 */
    ca_uint32_t ilpb_sa_move_dis_fwd :  1 ; /* bits 28:28 */
    ca_uint32_t ilpb_station_move_en :  1 ; /* bits 29:29 */
    ca_uint32_t ilpb_stp_mode        :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_ILPB_DATA1_t;


#define L2FE_PP_ILPB_DATA0                       0xf43011f4
#define L2FE_PP_ILPB_DATA0_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ilpb_dflt_premark    :  1 ; /* bits 0:0 */
    ca_uint32_t ilpb_color_src_sel   :  2 ; /* bits 2:1 */
    ca_uint32_t ilpb_ing_fltr_ena    :  1 ; /* bits 3:3 */
    ca_uint32_t ilpb_default_cos     :  3 ; /* bits 6:4 */
    ca_uint32_t ilpb_cos_control_bm  :  3 ; /* bits 9:7 */
    ca_uint32_t ilpb_cos_mode_sel    :  3 ; /* bits 12:10 */
    ca_uint32_t ilpb_default_dscp    :  6 ; /* bits 18:13 */
    ca_uint32_t ilpb_dscp_mark_control_bm :  3 ; /* bits 21:19 */
    ca_uint32_t ilpb_dscp_mode_sel   :  2 ; /* bits 23:22 */
    ca_uint32_t ilpb_dscp_markdown_en :  1 ; /* bits 24:24 */
    ca_uint32_t ilpb_default_802_1p  :  3 ; /* bits 27:25 */
    ca_uint32_t ilpb_inner_802_1p_mode_sel :  2 ; /* bits 29:28 */
    ca_uint32_t ilpb_802_1p_mark_control_bm :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_ILPB_DATA0_t;


#define L2FE_PP_DPB_ACCESS                       0xf43011f8
#define L2FE_PP_DPB_ACCESS_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_DPB_ACCESS_t;


#define L2FE_PP_DPB_DATA                         0xf43011fc
#define L2FE_PP_DPB_DATA_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cos                  :  3 ; /* bits 2:0 */
    ca_uint32_t ldpid                :  6 ; /* bits 8:3 */
    ca_uint32_t bypass               :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_DPB_DATA_t;


#define L2FE_PP_HTTP_LINK_0                      0xf4301200
#define L2FE_PP_HTTP_LINK_0_dft                  0x04000000

typedef volatile union {
  struct {
    ca_uint32_t rule_l4_pid          : 16 ; /* bits 15:0 */
    ca_uint32_t rule_l4_pid_sel      :  1 ; /* bits 16:16 */
    ca_uint32_t rule_l4_type         :  2 ; /* bits 18:17 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t rule_lspid           :  6 ; /* bits 25:20 */
    ca_uint32_t rule_lspid_msk       :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd2               :  4 ;
    ca_uint32_t rule_vld             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_HTTP_LINK_0_t;


#define L2FE_PP_HTTP_LINK_1                      0xf4301204
#define L2FE_PP_HTTP_LINK_1_dft                  0x04000000

typedef volatile union {
  struct {
    ca_uint32_t rule_l4_pid          : 16 ; /* bits 15:0 */
    ca_uint32_t rule_l4_pid_sel      :  1 ; /* bits 16:16 */
    ca_uint32_t rule_l4_type         :  2 ; /* bits 18:17 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t rule_lspid           :  6 ; /* bits 25:20 */
    ca_uint32_t rule_lspid_msk       :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd2               :  4 ;
    ca_uint32_t rule_vld             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_HTTP_LINK_1_t;


#define L2FE_PP_HTTP_LINK_2                      0xf4301208
#define L2FE_PP_HTTP_LINK_2_dft                  0x04000000

typedef volatile union {
  struct {
    ca_uint32_t rule_l4_pid          : 16 ; /* bits 15:0 */
    ca_uint32_t rule_l4_pid_sel      :  1 ; /* bits 16:16 */
    ca_uint32_t rule_l4_type         :  2 ; /* bits 18:17 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t rule_lspid           :  6 ; /* bits 25:20 */
    ca_uint32_t rule_lspid_msk       :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd2               :  4 ;
    ca_uint32_t rule_vld             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PP_HTTP_LINK_2_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PP */
typedef struct {
  L2FE_PP_PPID_ATTR_CFG_t                  PPID_ATTR_CFG;                 /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  L2FE_PP_DPB_CTRL_t                       DPB_CTRL;                      /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  L2FE_PP_TPID_CMP_S_t                     TPID_CMP_S;                    /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  L2FE_PP_TPID_CMP_C_t                     TPID_CMP_C;                    /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  L2FE_PP_TPID_CMP_O_t                     TPID_CMP_O;                    /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  L2FE_PP_HELLO_PKT_ENABLE_DA_LOW_t        HELLO_PKT_ENABLE_DA_LOW;       /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  L2FE_PP_HELLO_PKT_ENABLE_DA_HI_t         HELLO_PKT_ENABLE_DA_HI;        /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  L2FE_PP_HELLO_PKT_DA_LOW_t               HELLO_PKT_DA_LOW;              /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  L2FE_PP_HELLO_PKT_DA_HI_t                HELLO_PKT_DA_HI;               /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  L2FE_PP_SPECIAL_ENABLE_DA_0_LOW_t        SPECIAL_ENABLE_DA_0_LOW;       /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  L2FE_PP_SPECIAL_ENABLE_DA_0_HI_t         SPECIAL_ENABLE_DA_0_HI;        /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  L2FE_PP_SPECIAL_DA_0_LOW_t               SPECIAL_DA_0_LOW;              /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  L2FE_PP_SPECIAL_DA_0_HI_t                SPECIAL_DA_0_HI;               /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  L2FE_PP_SPECIAL_EV2PT_t                  SPECIAL_EV2PT;                 /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  L2FE_PP_SPECIAL_ENABLE_DA_1_LOW_t        SPECIAL_ENABLE_DA_1_LOW;       /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  L2FE_PP_SPECIAL_ENABLE_DA_1_HI_t         SPECIAL_ENABLE_DA_1_HI;        /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  L2FE_PP_SPECIAL_DA_1_LOW_t               SPECIAL_DA_1_LOW;              /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  L2FE_PP_SPECIAL_DA_1_HI_t                SPECIAL_DA_1_HI;               /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  L2FE_PP_SPECIAL_VLAN_t                   SPECIAL_VLAN;                  /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  L2FE_PP_MY_MAC_LOW_t                     MY_MAC_LOW;                    /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  L2FE_PP_MY_MAC_HI_t                      MY_MAC_HI;                     /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  L2FE_PP_MY_MAC_ENABLE_LOW_t              MY_MAC_ENABLE_LOW;             /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  L2FE_PP_MY_MAC_LOW_1_t                   MY_MAC_LOW_1;                  /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  L2FE_PP_MY_MAC_HI_1_t                    MY_MAC_HI_1;                   /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  L2FE_PP_MY_MAC_ENABLE_LOW_1_t            MY_MAC_ENABLE_LOW_1;           /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  L2FE_PP_RSV_MAC_MC_LOW_t                 RSV_MAC_MC_LOW;                /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  L2FE_PP_RSV_MAC_MC_HI_t                  RSV_MAC_MC_HI;                 /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  L2FE_PP_RSV_ENABLE_MC_LOW_t              RSV_ENABLE_MC_LOW;             /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  L2FE_PP_RSV_ENABLE_MC_HI_t               RSV_ENABLE_MC_HI;              /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  L2FE_PP_RSV_GROUP_MAC_LOW_t              RSV_GROUP_MAC_LOW;             /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  L2FE_PP_RSV_GROUP_MAC_HI_t               RSV_GROUP_MAC_HI;              /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  L2FE_PP_RSV_GROUP_ENABLE_LOW_t           RSV_GROUP_ENABLE_LOW;          /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  L2FE_PP_RSV_GROUP_ENABLE_HI_t            RSV_GROUP_ENABLE_HI;           /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  L2FE_PP_MEF_OAM_MAC_0_LOW_t              MEF_OAM_MAC_0_LOW;             /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  L2FE_PP_MEF_OAM_MAC_0_HI_t               MEF_OAM_MAC_0_HI;              /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  L2FE_PP_MEF_OAM_TYPE_0_t                 MEF_OAM_TYPE_0;                /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  L2FE_PP_MEF_OAM_MAC_1_LOW_t              MEF_OAM_MAC_1_LOW;             /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  L2FE_PP_MEF_OAM_MAC_1_HI_t               MEF_OAM_MAC_1_HI;              /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  L2FE_PP_MEF_OAM_TYPE_1_t                 MEF_OAM_TYPE_1;                /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];                   
  L2FE_PP_L7_OFFSET_t                      L7_OFFSET;                     /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];                   
  L2FE_PP_NI_INTF_ERR_STTS_0_t             NI_INTF_ERR_STTS_0;            /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];                   
  L2FE_PP_NI_INTF_ERR_STTS_1_t             NI_INTF_ERR_STTS_1;            /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];                   
  L2FE_PP_NI_INTF_ERR_STTS_2_t             NI_INTF_ERR_STTS_2;            /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];                   
  L2FE_PP_NI_INTF_ERR_STTS_3_t             NI_INTF_ERR_STTS_3;            /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd44[3];                   
  L2FE_PP_PINGPONG_STS_t                   PINGPONG_STS;                  /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd45[3];                   
  L2FE_PP_NI_INTF_STS_t                    NI_INTF_STS;                   /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd46[3];                   
  L2FE_PP_NI_INTF_DROP_CNT_t               NI_INTF_DROP_CNT;              /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd47[3];                   
  L2FE_PP_NI_INTF_PKT_CNT_t                NI_INTF_PKT_CNT;               /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd48[3];                   
  L2FE_PP_HEADER_A_LOW_t                   HEADER_A_LOW;                  /* addr: 0x000000c0 */
  ca_uint32_t                              rsrvd49[3];                   
  L2FE_PP_HEADER_A_MID_t                   HEADER_A_MID;                  /* addr: 0x000000c4 */
  ca_uint32_t                              rsrvd50[3];                   
  L2FE_PP_HEADER_A_HI_t                    HEADER_A_HI;                   /* addr: 0x000000c8 */
  ca_uint32_t                              rsrvd51[3];                   
  L2FE_PP_PARSER_CTRL_t                    PARSER_CTRL;                   /* addr: 0x000000cc */
  ca_uint32_t                              rsrvd52[3];                   
  L2FE_PP_SPECIAL_PKT_t                    SPECIAL_PKT;                   /* addr: 0x000000d0 */
  ca_uint32_t                              rsrvd53[3];                   
  L2FE_PP_DEBUG_BUS_t                      DEBUG_BUS;                     /* addr: 0x000000d4 */
  ca_uint32_t                              rsrvd54[3];                   
  L2FE_PP_IPPB_ACCESS_t                    IPPB_ACCESS;                   /* addr: 0x000000d8 */
  ca_uint32_t                              rsrvd55[3];                   
  L2FE_PP_IPPB_DATA_t                      IPPB_DATA;                     /* addr: 0x000000dc */
  ca_uint32_t                              rsrvd56[3];                   
  L2FE_PP_ILPB_ACCESS_t                    ILPB_ACCESS;                   /* addr: 0x000000e0 */
  ca_uint32_t                              rsrvd57[3];                   
  L2FE_PP_ILPB_DATA4_t                     ILPB_DATA4;                    /* addr: 0x000000e4 */
  ca_uint32_t                              rsrvd58[3];                   
  L2FE_PP_ILPB_DATA3_t                     ILPB_DATA3;                    /* addr: 0x000000e8 */
  ca_uint32_t                              rsrvd59[3];                   
  L2FE_PP_ILPB_DATA2_t                     ILPB_DATA2;                    /* addr: 0x000000ec */
  ca_uint32_t                              rsrvd60[3];                   
  L2FE_PP_ILPB_DATA1_t                     ILPB_DATA1;                    /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd61[3];                   
  L2FE_PP_ILPB_DATA0_t                     ILPB_DATA0;                    /* addr: 0x000000f4 */
  ca_uint32_t                              rsrvd62[3];                   
  L2FE_PP_DPB_ACCESS_t                     DPB_ACCESS;                    /* addr: 0x000000f8 */
  ca_uint32_t                              rsrvd63[3];                   
  L2FE_PP_DPB_DATA_t                       DPB_DATA;                      /* addr: 0x000000fc */
  ca_uint32_t                              rsrvd64[3];                   
  L2FE_PP_HTTP_LINK_0_t                    HTTP_LINK_0;                   /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd65[3];                   
  L2FE_PP_HTTP_LINK_1_t                    HTTP_LINK_1;                   /* addr: 0x00000104 */
  ca_uint32_t                              rsrvd66[3];                   
  L2FE_PP_HTTP_LINK_2_t                    HTTP_LINK_2;                   /* addr: 0x00000108 */
} APB0_L2FE_PP_t;


/*
 * PLA
 */
        
#define L2FE_PLA_DEBUG_BUS                       0xf4301300
#define L2FE_PLA_DEBUG_BUS_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sel                  :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLA_DEBUG_BUS_t;


#define L2FE_PLA_EV2_PT_CNVT_ACCESS              0xf4301304
#define L2FE_PLA_EV2_PT_CNVT_ACCESS_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLA_EV2_PT_CNVT_ACCESS_t;


#define L2FE_PLA_EV2_PT_CNVT_DATA                0xf4301308
#define L2FE_PLA_EV2_PT_CNVT_DATA_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ev2_pt_cnvt_encoded_value :  5 ; /* bits 4:0 */
    ca_uint32_t ev2_pt_cnvt_ethertype : 16 ; /* bits 20:5 */
    ca_uint32_t rsrvd1               : 11 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLA_EV2_PT_CNVT_DATA_t;


#define L2FE_PLA_SPB_ACCESS                      0xf430130c
#define L2FE_PLA_SPB_ACCESS_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLA_SPB_ACCESS_t;


#define L2FE_PLA_SPB_DATA                        0xf4301310
#define L2FE_PLA_SPB_DATA_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t spb_pkt_no_edit      :  1 ; /* bits 0:0 */
    ca_uint32_t spb_keep_ts          :  1 ; /* bits 1:1 */
    ca_uint32_t spb_bypass_sa_lrn_chk :  1 ; /* bits 2:2 */
    ca_uint32_t spb_limit_fwd_permit :  1 ; /* bits 3:3 */
    ca_uint32_t spb_learn_dis        :  1 ; /* bits 4:4 */
    ca_uint32_t spb_dscp_mark_down   :  1 ; /* bits 5:5 */
    ca_uint32_t spb_flowid           : 12 ; /* bits 17:6 */
    ca_uint32_t spb_flow_en          :  1 ; /* bits 18:18 */
    ca_uint32_t spb_rate_limit_bypass :  1 ; /* bits 19:19 */
    ca_uint32_t spb_cos              :  3 ; /* bits 22:20 */
    ca_uint32_t spb_ldpid            :  6 ; /* bits 28:23 */
    ca_uint32_t spb_spcl_fwd         :  1 ; /* bits 29:29 */
    ca_uint32_t spb_pkt_no_drop      :  1 ; /* bits 30:30 */
    ca_uint32_t spb_hash_cllsn_fwd_permit :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLA_SPB_DATA_t;


#define L2FE_PLA_DOT1P_MAP_ACCESS                0xf4301314
#define L2FE_PLA_DOT1P_MAP_ACCESS_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLA_DOT1P_MAP_ACCESS_t;


#define L2FE_PLA_DOT1P_MAP_DATA                  0xf4301318
#define L2FE_PLA_DOT1P_MAP_DATA_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dot1p_map_mapped_premark :  1 ; /* bits 0:0 */
    ca_uint32_t dot1p_map_mapped_cos :  3 ; /* bits 3:1 */
    ca_uint32_t dot1p_map_mapped_1p  :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLA_DOT1P_MAP_DATA_t;


#define L2FE_PLA_DSCP_MAP_ACCESS                 0xf430131c
#define L2FE_PLA_DSCP_MAP_ACCESS_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLA_DSCP_MAP_ACCESS_t;


#define L2FE_PLA_DSCP_MAP_DATA                   0xf4301320
#define L2FE_PLA_DSCP_MAP_DATA_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mapped_premark       :  1 ; /* bits 0:0 */
    ca_uint32_t dscp_map_mapped_cos  :  3 ; /* bits 3:1 */
    ca_uint32_t dscp_map_marked_flag :  1 ; /* bits 4:4 */
    ca_uint32_t dscp_map_mapped_dscp :  6 ; /* bits 10:5 */
    ca_uint32_t rsrvd1               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLA_DSCP_MAP_DATA_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PLA */
typedef struct {
  L2FE_PLA_DEBUG_BUS_t                     DEBUG_BUS;                     /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  L2FE_PLA_EV2_PT_CNVT_ACCESS_t            EV2_PT_CNVT_ACCESS;            /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  L2FE_PLA_EV2_PT_CNVT_DATA_t              EV2_PT_CNVT_DATA;              /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  L2FE_PLA_SPB_ACCESS_t                    SPB_ACCESS;                    /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  L2FE_PLA_SPB_DATA_t                      SPB_DATA;                      /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  L2FE_PLA_DOT1P_MAP_ACCESS_t              DOT1P_MAP_ACCESS;              /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  L2FE_PLA_DOT1P_MAP_DATA_t                DOT1P_MAP_DATA;                /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  L2FE_PLA_DSCP_MAP_ACCESS_t               DSCP_MAP_ACCESS;               /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  L2FE_PLA_DSCP_MAP_DATA_t                 DSCP_MAP_DATA;                 /* addr: 0x00000020 */
} APB0_L2FE_PLA_t;


/*
 * PLC
 */
        
#define L2FE_PLC_HASH_CTRL                       0xf4301400
#define L2FE_PLC_HASH_CTRL_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t lan_sa_hashing_vid_sel :  1 ; /* bits 0:0 */
    ca_uint32_t lan_da_hashing_vid_sel :  1 ; /* bits 1:1 */
    ca_uint32_t lan_sa_learning_vid_sel :  1 ; /* bits 2:2 */
    ca_uint32_t wan_sa_hashing_vid_sel :  1 ; /* bits 3:3 */
    ca_uint32_t wan_da_hashing_vid_sel :  1 ; /* bits 4:4 */
    ca_uint32_t wan_sa_learning_vid_sel :  1 ; /* bits 5:5 */
    ca_uint32_t use_dot1p_l2e        :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLC_HASH_CTRL_t;


#define L2FE_PLC_DPID_FWD_CTRL                   0xf4301404
#define L2FE_PLC_DPID_FWD_CTRL_dft               0x00000001

typedef volatile union {
  struct {
    ca_uint32_t vid_fff_fwd          :  1 ; /* bits 0:0 */
    ca_uint32_t unkvlan_fwd          :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLC_DPID_FWD_CTRL_t;


#define L2FE_PLC_LRN_FWD_CTRL_0                  0xf4301408
#define L2FE_PLC_LRN_FWD_CTRL_0_dft              0x02000210

typedef volatile union {
  struct {
    ca_uint32_t l2_mac_sw_lrn_ldpid  :  6 ; /* bits 5:0 */
    ca_uint32_t l2_mac_sw_lrn_cos    :  3 ; /* bits 8:6 */
    ca_uint32_t l2_mac_sw_lrn_keep_old_wan :  1 ; /* bits 9:9 */
    ca_uint32_t l2_mac_sw_lrn_keep_old_lan :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd1               : 14 ;
    ca_uint32_t sa_miss_fwd          :  1 ; /* bits 25:25 */
    ca_uint32_t nonstd_sa_all_zero_fwd :  1 ; /* bits 26:26 */
    ca_uint32_t nonstd_sa_all_one_fwd :  1 ; /* bits 27:27 */
    ca_uint32_t nonstd_sa_b40_is_one_fwd :  1 ; /* bits 28:28 */
    ca_uint32_t sm_static_entry_fwd  :  1 ; /* bits 29:29 */
    ca_uint32_t sm_tmp_entry_fwd     :  1 ; /* bits 30:30 */
    ca_uint32_t sm_sm_entry_fwd      :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLC_LRN_FWD_CTRL_0_t;


#define L2FE_PLC_LRN_FWD_CTRL_1                  0xf430140c
#define L2FE_PLC_LRN_FWD_CTRL_1_dft              0x08100810

typedef volatile union {
  struct {
    ca_uint32_t sa_limit_excd_ldpid  :  6 ; /* bits 5:0 */
    ca_uint32_t sa_limit_excd_cos    :  3 ; /* bits 8:6 */
    ca_uint32_t sa_limit_excd_fwd_ctrl :  2 ; /* bits 10:9 */
    ca_uint32_t sa_limit_excd_keep_old_wan :  1 ; /* bits 11:11 */
    ca_uint32_t sa_limit_excd_keep_old_lan :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t sa_hash_cllsn_ldpid  :  6 ; /* bits 21:16 */
    ca_uint32_t sa_hash_cllsn_cos    :  3 ; /* bits 24:22 */
    ca_uint32_t sa_hash_cllsn_fwd_ctrl :  2 ; /* bits 26:25 */
    ca_uint32_t sa_hash_cllsn_keep_old_wan :  1 ; /* bits 27:27 */
    ca_uint32_t sa_hash_cllsn_keep_old_lan :  1 ; /* bits 28:28 */
    ca_uint32_t swlrn_othr_pkt_fwd   :  1 ; /* bits 29:29 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLC_LRN_FWD_CTRL_1_t;


#define L2FE_PLC_L2_LEARNING_CTRL                0xf4301410
#define L2FE_PLC_L2_LEARNING_CTRL_dft            0x00000046

typedef volatile union {
  struct {
    ca_uint32_t unkvlan_learn        :  1 ; /* bits 0:0 */
    ca_uint32_t unk_ethtype_no_learn :  1 ; /* bits 1:1 */
    ca_uint32_t igr_dropped_pkt_no_learn :  1 ; /* bits 2:2 */
    ca_uint32_t non_std_sa_all_zero_learn :  1 ; /* bits 3:3 */
    ca_uint32_t non_std_sa_all_one_learn :  1 ; /* bits 4:4 */
    ca_uint32_t non_std_sa_b40_is_one_learn :  1 ; /* bits 5:5 */
    ca_uint32_t loop_pkt_no_learn    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLC_L2_LEARNING_CTRL_t;


#define L2FE_PLC_VLAN_MODE_CTRL                  0xf4301414
#define L2FE_PLC_VLAN_MODE_CTRL_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t l2e_glb_vlan_mode    :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLC_VLAN_MODE_CTRL_t;


#define L2FE_PLC_SA_CHK_CTL                      0xf4301418
#define L2FE_PLC_SA_CHK_CTL_dft                  0x00000001

typedef volatile union {
  struct {
    ca_uint32_t skip_sa_chk          :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLC_SA_CHK_CTL_t;


#define L2FE_PLC_DEBUG                           0xf430141c
#define L2FE_PLC_DEBUG_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bus_sel              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLC_DEBUG_t;


#define L2FE_PLC_ELPB_ACCESS                     0xf4301420
#define L2FE_PLC_ELPB_ACCESS_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLC_ELPB_ACCESS_t;


#define L2FE_PLC_ELPB_DATA                       0xf4301424
#define L2FE_PLC_ELPB_DATA_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t elpb_egr_vlan_aware_mode :  1 ; /* bits 0:0 */
    ca_uint32_t elpb_egr_port_stp_status :  1 ; /* bits 1:1 */
    ca_uint32_t elpb_egr_ve_srch_en  :  1 ; /* bits 2:2 */
    ca_uint32_t elpb_egr_dest_wan    :  1 ; /* bits 3:3 */
    ca_uint32_t elpb_egr_cls_length  :  6 ; /* bits 9:4 */
    ca_uint32_t elpb_egr_cls_start   :  8 ; /* bits 17:10 */
    ca_uint32_t elpb_egr_cls_lookup_en :  1 ; /* bits 18:18 */
    ca_uint32_t elpb_egr_cls_flowid_sel :  1 ; /* bits 19:19 */
    ca_uint32_t elpb_egr_cls_cos_sel :  1 ; /* bits 20:20 */
    ca_uint32_t elpb_reserved        :  3 ; /* bits 23:21 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLC_ELPB_DATA_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PLC */
typedef struct {
  L2FE_PLC_HASH_CTRL_t                     HASH_CTRL;                     /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  L2FE_PLC_DPID_FWD_CTRL_t                 DPID_FWD_CTRL;                 /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  L2FE_PLC_LRN_FWD_CTRL_0_t                LRN_FWD_CTRL_0;                /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  L2FE_PLC_LRN_FWD_CTRL_1_t                LRN_FWD_CTRL_1;                /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  L2FE_PLC_L2_LEARNING_CTRL_t              L2_LEARNING_CTRL;              /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  L2FE_PLC_VLAN_MODE_CTRL_t                VLAN_MODE_CTRL;                /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  L2FE_PLC_SA_CHK_CTL_t                    SA_CHK_CTL;                    /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  L2FE_PLC_DEBUG_t                         _DEBUG;                        /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  L2FE_PLC_ELPB_ACCESS_t                   ELPB_ACCESS;                   /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  L2FE_PLC_ELPB_DATA_t                     ELPB_DATA;                     /* addr: 0x00000024 */
} APB0_L2FE_PLC_t;


/*
 * PLE
 */
        
#define L2FE_PLE_CTL_REG                         0xf4301500
#define L2FE_PLE_CTL_REG_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t txvlan_membshp_chk_en_lan :  1 ; /* bits 0:0 */
    ca_uint32_t txvlan_membshp_chk_en_wan :  1 ; /* bits 1:1 */
    ca_uint32_t cos_l3_only          :  1 ; /* bits 2:2 */
    ca_uint32_t skip_port_lpbk_chk   :  1 ; /* bits 3:3 */
    ca_uint32_t pon_mode             :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_CTL_REG_t;


#define L2FE_PLE_DEFAULT_REG                     0xf4301504
#define L2FE_PLE_DEFAULT_REG_dft                 0x001b0000

typedef volatile union {
  struct {
    ca_uint32_t dflt_flow_en         :  1 ; /* bits 0:0 */
    ca_uint32_t dflt_flowid          : 12 ; /* bits 12:1 */
    ca_uint32_t dflt_markdown_en     :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t dflt_mc_pid          :  6 ; /* bits 21:16 */
    ca_uint32_t rsrvd2               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_DEFAULT_REG_t;


#define L2FE_PLE_RX_UNKWN_VLAN_DFT               0xf4301508
#define L2FE_PLE_RX_UNKWN_VLAN_DFT_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t memshp_bm            : 16 ; /* bits 15:0 */
    ca_uint32_t vl_grp_id            : 10 ; /* bits 25:16 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_RX_UNKWN_VLAN_DFT_t;


#define L2FE_PLE_TX_UNKWN_VLAN_DFT_1             0xf430150c
#define L2FE_PLE_TX_UNKWN_VLAN_DFT_1_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t stp_mode             :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TX_UNKWN_VLAN_DFT_1_t;


#define L2FE_PLE_TX_UNKWN_VLAN_DFT_2             0xf4301510
#define L2FE_PLE_TX_UNKWN_VLAN_DFT_2_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t memshp_bm            : 16 ; /* bits 15:0 */
    ca_uint32_t untag_bm             : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TX_UNKWN_VLAN_DFT_2_t;


#define L2FE_PLE_TRUNK_GRP_CTRL_0                0xf4301514
#define L2FE_PLE_TRUNK_GRP_CTRL_0_dft            0x00000012

typedef volatile union {
  struct {
    ca_uint32_t trunk_hash_field_sel_mac_sa :  1 ; /* bits 0:0 */
    ca_uint32_t trunk_hash_field_sel_mac_da :  1 ; /* bits 1:1 */
    ca_uint32_t trunk_hash_field_sel_tx_top_vid :  1 ; /* bits 2:2 */
    ca_uint32_t trunk_hash_field_sel_ip_sa :  1 ; /* bits 3:3 */
    ca_uint32_t trunk_hash_field_sel_ip_da :  1 ; /* bits 4:4 */
    ca_uint32_t trunk_hash_field_sel_l4_sp :  1 ; /* bits 5:5 */
    ca_uint32_t trunk_hash_field_sel_l4_dp :  1 ; /* bits 6:6 */
    ca_uint32_t trunk_hash_field_sel_cos :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TRUNK_GRP_CTRL_0_t;


#define L2FE_PLE_TRUNK_GRP_0_MEMBER_0            0xf4301518
#define L2FE_PLE_TRUNK_GRP_0_MEMBER_0_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t valid                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TRUNK_GRP_0_MEMBER_0_t;


#define L2FE_PLE_TRUNK_GRP_0_MEMBER_1            0xf430151c
#define L2FE_PLE_TRUNK_GRP_0_MEMBER_1_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t valid                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TRUNK_GRP_0_MEMBER_1_t;


#define L2FE_PLE_TRUNK_GRP_CTRL_1                0xf4301520
#define L2FE_PLE_TRUNK_GRP_CTRL_1_dft            0x00000012

typedef volatile union {
  struct {
    ca_uint32_t trunk_hash_field_sel_mac_sa :  1 ; /* bits 0:0 */
    ca_uint32_t trunk_hash_field_sel_mac_da :  1 ; /* bits 1:1 */
    ca_uint32_t trunk_hash_field_sel_tx_top_vid :  1 ; /* bits 2:2 */
    ca_uint32_t trunk_hash_field_sel_ip_sa :  1 ; /* bits 3:3 */
    ca_uint32_t trunk_hash_field_sel_ip_da :  1 ; /* bits 4:4 */
    ca_uint32_t trunk_hash_field_sel_l4_sp :  1 ; /* bits 5:5 */
    ca_uint32_t trunk_hash_field_sel_l4_dp :  1 ; /* bits 6:6 */
    ca_uint32_t trunk_hash_field_sel_cos :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TRUNK_GRP_CTRL_1_t;


#define L2FE_PLE_TRUNK_GRP_1_MEMBER_0            0xf4301524
#define L2FE_PLE_TRUNK_GRP_1_MEMBER_0_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t valid                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TRUNK_GRP_1_MEMBER_0_t;


#define L2FE_PLE_TRUNK_GRP_1_MEMBER_1            0xf4301528
#define L2FE_PLE_TRUNK_GRP_1_MEMBER_1_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t valid                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TRUNK_GRP_1_MEMBER_1_t;


#define L2FE_PLE_HD_FF_CTL_REG                   0xf430152c
#define L2FE_PLE_HD_FF_CTL_REG_dft               0x00000610

typedef volatile union {
  struct {
    ca_uint32_t low_thr              :  6 ; /* bits 5:0 */
    ca_uint32_t high_thr             :  6 ; /* bits 11:6 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_HD_FF_CTL_REG_t;


#define L2FE_PLE_HD_FF_STS_REG                   0xf4301530
#define L2FE_PLE_HD_FF_STS_REG_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t overflow_ind         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_HD_FF_STS_REG_t;


#define L2FE_PLE_HD_FF_HDR_CNT                   0xf4301534
#define L2FE_PLE_HD_FF_HDR_CNT_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_HD_FF_HDR_CNT_t;


#define L2FE_PLE_DEBUG_BUS                       0xf4301538
#define L2FE_PLE_DEBUG_BUS_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sel                  :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_DEBUG_BUS_t;


#define L2FE_PLE_TX_DSCP_MAP_ACCESS              0xf430153c
#define L2FE_PLE_TX_DSCP_MAP_ACCESS_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TX_DSCP_MAP_ACCESS_t;


#define L2FE_PLE_TX_DSCP_MAP_DATA                0xf4301540
#define L2FE_PLE_TX_DSCP_MAP_DATA_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t txdscp_map_mapped_cos :  3 ; /* bits 2:0 */
    ca_uint32_t txdscp_map_mapped_1p :  3 ; /* bits 5:3 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TX_DSCP_MAP_DATA_t;


#define L2FE_PLE_TX_DOT1P_MAP_ACCESS             0xf4301544
#define L2FE_PLE_TX_DOT1P_MAP_ACCESS_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TX_DOT1P_MAP_ACCESS_t;


#define L2FE_PLE_TX_DOT1P_MAP_DATA               0xf4301548
#define L2FE_PLE_TX_DOT1P_MAP_DATA_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t txdot1p_map_mapped_cos :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TX_DOT1P_MAP_DATA_t;


#define L2FE_PLE_DFT_FWD_ACCESS                  0xf430154c
#define L2FE_PLE_DFT_FWD_ACCESS_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_DFT_FWD_ACCESS_t;


#define L2FE_PLE_DFT_FWD_DATA                    0xf4301550
#define L2FE_PLE_DFT_FWD_DATA_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dft_fwd_deny         :  1 ; /* bits 0:0 */
    ca_uint32_t dft_fwd_mc_group_id  : 10 ; /* bits 10:1 */
    ca_uint32_t dft_fwd_redir_en     :  1 ; /* bits 11:11 */
    ca_uint32_t dft_fwd_mc_group_id_valid :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd1               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_DFT_FWD_DATA_t;


#define L2FE_PLE_MMSHP_CHK_ID_MAP_ACCESS         0xf4301554
#define L2FE_PLE_MMSHP_CHK_ID_MAP_ACCESS_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_MMSHP_CHK_ID_MAP_ACCESS_t;


#define L2FE_PLE_MMSHP_CHK_ID_MAP_DATA           0xf4301558
#define L2FE_PLE_MMSHP_CHK_ID_MAP_DATA_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mmshp_chk_id_map_chk_id :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_MMSHP_CHK_ID_MAP_DATA_t;


#define L2FE_PLE_PORT_MMSHP_CHK_ACCESS           0xf430155c
#define L2FE_PLE_PORT_MMSHP_CHK_ACCESS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_PORT_MMSHP_CHK_ACCESS_t;


#define L2FE_PLE_PORT_MMSHP_CHK_DATA1            0xf4301560
#define L2FE_PLE_PORT_MMSHP_CHK_DATA1_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ldpid_bm             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_PORT_MMSHP_CHK_DATA1_t;


#define L2FE_PLE_PORT_MMSHP_CHK_DATA0            0xf4301564
#define L2FE_PLE_PORT_MMSHP_CHK_DATA0_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ldpid_bm             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_PORT_MMSHP_CHK_DATA0_t;


#define L2FE_PLE_TRUNK_DEST_MAP_TBL_ACCESS       0xf4301568
#define L2FE_PLE_TRUNK_DEST_MAP_TBL_ACCESS_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TRUNK_DEST_MAP_TBL_ACCESS_t;


#define L2FE_PLE_TRUNK_DEST_MAP_TBL_DATA         0xf430156c
#define L2FE_PLE_TRUNK_DEST_MAP_TBL_DATA_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ldpid                :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PLE_TRUNK_DEST_MAP_TBL_DATA_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PLE */
typedef struct {
  L2FE_PLE_CTL_REG_t                       CTL_REG;                       /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  L2FE_PLE_DEFAULT_REG_t                   DEFAULT_REG;                   /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  L2FE_PLE_RX_UNKWN_VLAN_DFT_t             RX_UNKWN_VLAN_DFT;             /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  L2FE_PLE_TX_UNKWN_VLAN_DFT_1_t           TX_UNKWN_VLAN_DFT_1;           /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  L2FE_PLE_TX_UNKWN_VLAN_DFT_2_t           TX_UNKWN_VLAN_DFT_2;           /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  L2FE_PLE_TRUNK_GRP_CTRL_0_t              TRUNK_GRP_CTRL_0;              /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  L2FE_PLE_TRUNK_GRP_0_MEMBER_0_t          TRUNK_GRP_0_MEMBER_0;          /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  L2FE_PLE_TRUNK_GRP_0_MEMBER_1_t          TRUNK_GRP_0_MEMBER_1;          /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  L2FE_PLE_TRUNK_GRP_CTRL_1_t              TRUNK_GRP_CTRL_1;              /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  L2FE_PLE_TRUNK_GRP_1_MEMBER_0_t          TRUNK_GRP_1_MEMBER_0;          /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  L2FE_PLE_TRUNK_GRP_1_MEMBER_1_t          TRUNK_GRP_1_MEMBER_1;          /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  L2FE_PLE_HD_FF_CTL_REG_t                 HD_FF_CTL_REG;                 /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  L2FE_PLE_HD_FF_STS_REG_t                 HD_FF_STS_REG;                 /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  L2FE_PLE_HD_FF_HDR_CNT_t                 HD_FF_HDR_CNT;                 /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  L2FE_PLE_DEBUG_BUS_t                     DEBUG_BUS;                     /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  L2FE_PLE_TX_DSCP_MAP_ACCESS_t            TX_DSCP_MAP_ACCESS;            /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  L2FE_PLE_TX_DSCP_MAP_DATA_t              TX_DSCP_MAP_DATA;              /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  L2FE_PLE_TX_DOT1P_MAP_ACCESS_t           TX_DOT1P_MAP_ACCESS;           /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  L2FE_PLE_TX_DOT1P_MAP_DATA_t             TX_DOT1P_MAP_DATA;             /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  L2FE_PLE_DFT_FWD_ACCESS_t                DFT_FWD_ACCESS;                /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  L2FE_PLE_DFT_FWD_DATA_t                  DFT_FWD_DATA;                  /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  L2FE_PLE_MMSHP_CHK_ID_MAP_ACCESS_t       MMSHP_CHK_ID_MAP_ACCESS;       /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  L2FE_PLE_MMSHP_CHK_ID_MAP_DATA_t         MMSHP_CHK_ID_MAP_DATA;         /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  L2FE_PLE_PORT_MMSHP_CHK_ACCESS_t         PORT_MMSHP_CHK_ACCESS;         /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  L2FE_PLE_PORT_MMSHP_CHK_DATA1_t          PORT_MMSHP_CHK_DATA1;          /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  L2FE_PLE_PORT_MMSHP_CHK_DATA0_t          PORT_MMSHP_CHK_DATA0;          /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  L2FE_PLE_TRUNK_DEST_MAP_TBL_ACCESS_t     TRUNK_DEST_MAP_TBL_ACCESS;     /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  L2FE_PLE_TRUNK_DEST_MAP_TBL_DATA_t       TRUNK_DEST_MAP_TBL_DATA;       /* addr: 0x0000006c */
} APB0_L2FE_PLE_t;


/*
 * ARB
 */
        
#define L2FE_ARB_ARB_CTRL                        0xf4301600
#define L2FE_ARB_ARB_CTRL_dft                    0x00000180

typedef volatile union {
  struct {
    ca_uint32_t drop_redir_keep_old  :  1 ; /* bits 0:0 */
    ca_uint32_t dbuf_sel             :  1 ; /* bits 1:1 */
    ca_uint32_t ip_ecn_en            :  1 ; /* bits 2:2 */
    ca_uint32_t mc_idx_copy_en       :  1 ; /* bits 3:3 */
    ca_uint32_t dbuf_dpid            :  4 ; /* bits 7:4 */
    ca_uint32_t use_hdr_a_dbuf_en    :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_ARB_CTRL_t;


#define L2FE_ARB_PER_COS_DONT_MARK_CTRL          0xf4301604
#define L2FE_ARB_PER_COS_DONT_MARK_CTRL_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bitmap_dst_lan       :  8 ; /* bits 7:0 */
    ca_uint32_t bitmap_dst_wan       :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_PER_COS_DONT_MARK_CTRL_t;


#define L2FE_ARB_ARB_DEBUG                       0xf4301608
#define L2FE_ARB_ARB_DEBUG_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sel                  :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_ARB_DEBUG_t;


#define L2FE_ARB_REDIR_LDPID_CONFIG_TBL_ACCESS   0xf430160c
#define L2FE_ARB_REDIR_LDPID_CONFIG_TBL_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_REDIR_LDPID_CONFIG_TBL_ACCESS_t;


#define L2FE_ARB_REDIR_LDPID_CONFIG_TBL_DATA     0xf4301610
#define L2FE_ARB_REDIR_LDPID_CONFIG_TBL_DATA_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rdir_cos_vld         :  1 ; /* bits 0:0 */
    ca_uint32_t rdir_cos             :  3 ; /* bits 3:1 */
    ca_uint32_t rdir_ldpid           :  6 ; /* bits 9:4 */
    ca_uint32_t rdir_en              :  1 ; /* bits 10:10 */
    ca_uint32_t rdir_wan_dst         :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_REDIR_LDPID_CONFIG_TBL_DATA_t;


#define L2FE_ARB_REDIR_DROP_SRC_CONFIG_TBL_ACCESS 0xf4301614
#define L2FE_ARB_REDIR_DROP_SRC_CONFIG_TBL_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_REDIR_DROP_SRC_CONFIG_TBL_ACCESS_t;


#define L2FE_ARB_REDIR_DROP_SRC_CONFIG_TBL_DATA  0xf4301618
#define L2FE_ARB_REDIR_DROP_SRC_CONFIG_TBL_DATA_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rdir_cos_vld         :  1 ; /* bits 0:0 */
    ca_uint32_t rdir_cos             :  3 ; /* bits 3:1 */
    ca_uint32_t rdir_ldpid           :  6 ; /* bits 9:4 */
    ca_uint32_t rdir_en              :  1 ; /* bits 10:10 */
    ca_uint32_t rdir_wan_dst         :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_REDIR_DROP_SRC_CONFIG_TBL_DATA_t;


#define L2FE_ARB_NON_KNOWN_POL_MAP_TBL_ACCESS    0xf430161c
#define L2FE_ARB_NON_KNOWN_POL_MAP_TBL_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_NON_KNOWN_POL_MAP_TBL_ACCESS_t;


#define L2FE_ARB_NON_KNOWN_POL_MAP_TBL_DATA      0xf4301620
#define L2FE_ARB_NON_KNOWN_POL_MAP_TBL_DATA_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t flooding_pol_id      :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_NON_KNOWN_POL_MAP_TBL_DATA_t;


#define L2FE_ARB_DSCP_TE_MARK_TBL_ACCESS         0xf4301624
#define L2FE_ARB_DSCP_TE_MARK_TBL_ACCESS_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_DSCP_TE_MARK_TBL_ACCESS_t;


#define L2FE_ARB_DSCP_TE_MARK_TBL_DATA           0xf4301628
#define L2FE_ARB_DSCP_TE_MARK_TBL_DATA_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mark_value           :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_DSCP_TE_MARK_TBL_DATA_t;


#define L2FE_ARB_MC_FIB_TBL_ACCESS               0xf430162c
#define L2FE_ARB_MC_FIB_TBL_ACCESS_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_MC_FIB_TBL_ACCESS_t;


#define L2FE_ARB_MC_FIB_TBL_DATA3                0xf4301630
#define L2FE_ARB_MC_FIB_TBL_DATA3_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pol_en               :  1 ; /* bits 0:0 */
    ca_uint32_t cos                  :  3 ; /* bits 3:1 */
    ca_uint32_t ldpid                :  6 ; /* bits 9:4 */
    ca_uint32_t mac_sa_sel           :  1 ; /* bits 10:10 */
    ca_uint32_t mac_sa_cmd           :  1 ; /* bits 11:11 */
    ca_uint32_t permit_spid_en       :  1 ; /* bits 12:12 */
    ca_uint32_t wan_dst              :  1 ; /* bits 13:13 */
    ca_uint32_t cos_cmd              :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_MC_FIB_TBL_DATA3_t;


#define L2FE_ARB_MC_FIB_TBL_DATA2                0xf4301634
#define L2FE_ARB_MC_FIB_TBL_DATA2_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vid                  :  5 ; /* bits 4:0 */
    ca_uint32_t vlan_cmd             :  3 ; /* bits 7:5 */
    ca_uint32_t vlan_fltr_en         :  1 ; /* bits 8:8 */
    ca_uint32_t mcgid                : 10 ; /* bits 18:9 */
    ca_uint32_t mcgid_en             :  1 ; /* bits 19:19 */
    ca_uint32_t pol_id               :  9 ; /* bits 28:20 */
    ca_uint32_t pol_grp_id           :  3 ; /* bits 31:29 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_MC_FIB_TBL_DATA2_t;


#define L2FE_ARB_MC_FIB_TBL_DATA1                0xf4301638
#define L2FE_ARB_MC_FIB_TBL_DATA1_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac_da               : 16 ; /* bits 15:0 */
    ca_uint32_t mac_cmd              :  1 ; /* bits 16:16 */
    ca_uint32_t dei                  :  1 ; /* bits 17:17 */
    ca_uint32_t dei_cmd              :  1 ; /* bits 18:18 */
    ca_uint32_t dot1p                :  3 ; /* bits 21:19 */
    ca_uint32_t dot1p_cmd            :  2 ; /* bits 23:22 */
    ca_uint32_t sc_ind               :  1 ; /* bits 24:24 */
    ca_uint32_t vid                  :  7 ; /* bits 31:25 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_MC_FIB_TBL_DATA1_t;


#define L2FE_ARB_MC_FIB_TBL_DATA0                0xf430163c
#define L2FE_ARB_MC_FIB_TBL_DATA0_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac_da               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_MC_FIB_TBL_DATA0_t;


#define L2FE_ARB_FLOW_DBUF_TBL_ACCESS            0xf4301640
#define L2FE_ARB_FLOW_DBUF_TBL_ACCESS_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_FLOW_DBUF_TBL_ACCESS_t;


#define L2FE_ARB_FLOW_DBUF_TBL_DATA              0xf4301644
#define L2FE_ARB_FLOW_DBUF_TBL_DATA_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dbuf_flg_0           :  1 ; /* bits 0:0 */
    ca_uint32_t dbuf_flg_1           :  1 ; /* bits 1:1 */
    ca_uint32_t dbuf_flg_2           :  1 ; /* bits 2:2 */
    ca_uint32_t dbuf_flg_3           :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_FLOW_DBUF_TBL_DATA_t;


#define L2FE_ARB_PORT_DBUF_TBL_ACCESS            0xf4301648
#define L2FE_ARB_PORT_DBUF_TBL_ACCESS_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 27 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_PORT_DBUF_TBL_ACCESS_t;


#define L2FE_ARB_PORT_DBUF_TBL_DATA              0xf430164c
#define L2FE_ARB_PORT_DBUF_TBL_DATA_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dbuf_flg             :  1 ; /* bits 0:0 */
    ca_uint32_t ldpid_vld            :  1 ; /* bits 1:1 */
    ca_uint32_t ldpid                :  6 ; /* bits 7:2 */
    ca_uint32_t lspid_vld            :  1 ; /* bits 8:8 */
    ca_uint32_t lspid                :  6 ; /* bits 14:9 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_PORT_DBUF_TBL_DATA_t;


#define L2FE_ARB_PDPID_MAP_TBL_ACCESS            0xf4301650
#define L2FE_ARB_PDPID_MAP_TBL_ACCESS_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_PDPID_MAP_TBL_ACCESS_t;


#define L2FE_ARB_PDPID_MAP_TBL_DATA              0xf4301654
#define L2FE_ARB_PDPID_MAP_TBL_DATA_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pdpid                :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_ARB_PDPID_MAP_TBL_DATA_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* ARB */
typedef struct {
  L2FE_ARB_ARB_CTRL_t                      ARB_CTRL;                      /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  L2FE_ARB_PER_COS_DONT_MARK_CTRL_t        PER_COS_DONT_MARK_CTRL;        /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  L2FE_ARB_ARB_DEBUG_t                     ARB_DEBUG;                     /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  L2FE_ARB_REDIR_LDPID_CONFIG_TBL_ACCESS_t REDIR_LDPID_CONFIG_TBL_ACCESS; /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  L2FE_ARB_REDIR_LDPID_CONFIG_TBL_DATA_t   REDIR_LDPID_CONFIG_TBL_DATA;   /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  L2FE_ARB_REDIR_DROP_SRC_CONFIG_TBL_ACCESS_t REDIR_DROP_SRC_CONFIG_TBL_ACCESS; /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  L2FE_ARB_REDIR_DROP_SRC_CONFIG_TBL_DATA_t REDIR_DROP_SRC_CONFIG_TBL_DATA; /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  L2FE_ARB_NON_KNOWN_POL_MAP_TBL_ACCESS_t  NON_KNOWN_POL_MAP_TBL_ACCESS;  /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  L2FE_ARB_NON_KNOWN_POL_MAP_TBL_DATA_t    NON_KNOWN_POL_MAP_TBL_DATA;    /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  L2FE_ARB_DSCP_TE_MARK_TBL_ACCESS_t       DSCP_TE_MARK_TBL_ACCESS;       /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  L2FE_ARB_DSCP_TE_MARK_TBL_DATA_t         DSCP_TE_MARK_TBL_DATA;         /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  L2FE_ARB_MC_FIB_TBL_ACCESS_t             MC_FIB_TBL_ACCESS;             /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  L2FE_ARB_MC_FIB_TBL_DATA3_t              MC_FIB_TBL_DATA3;              /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  L2FE_ARB_MC_FIB_TBL_DATA2_t              MC_FIB_TBL_DATA2;              /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  L2FE_ARB_MC_FIB_TBL_DATA1_t              MC_FIB_TBL_DATA1;              /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  L2FE_ARB_MC_FIB_TBL_DATA0_t              MC_FIB_TBL_DATA0;              /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  L2FE_ARB_FLOW_DBUF_TBL_ACCESS_t          FLOW_DBUF_TBL_ACCESS;          /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  L2FE_ARB_FLOW_DBUF_TBL_DATA_t            FLOW_DBUF_TBL_DATA;            /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  L2FE_ARB_PORT_DBUF_TBL_ACCESS_t          PORT_DBUF_TBL_ACCESS;          /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  L2FE_ARB_PORT_DBUF_TBL_DATA_t            PORT_DBUF_TBL_DATA;            /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  L2FE_ARB_PDPID_MAP_TBL_ACCESS_t          PDPID_MAP_TBL_ACCESS;          /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  L2FE_ARB_PDPID_MAP_TBL_DATA_t            PDPID_MAP_TBL_DATA;            /* addr: 0x00000054 */
} APB0_L2FE_ARB_t;


/*
 * PE
 */
        
#define L2FE_PE_CTRL                             0xf4301700
#define L2FE_PE_CTRL_dft                         0x000000f0

typedef volatile union {
  struct {
    ca_uint32_t l2_padding_dis       :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t wan_top_dei_keep_old :  1 ; /* bits 4:4 */
    ca_uint32_t lan_top_dei_keep_old :  1 ; /* bits 5:5 */
    ca_uint32_t wan_inner_dei_keep_old :  1 ; /* bits 6:6 */
    ca_uint32_t lan_inner_dei_keep_old :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd2               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_CTRL_t;


#define L2FE_PE_CFG_VLAN_TPID_A                  0xf4301704
#define L2FE_PE_CFG_VLAN_TPID_A_dft              0x00008100

typedef volatile union {
  struct {
    ca_uint32_t tpid                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_CFG_VLAN_TPID_A_t;


#define L2FE_PE_CFG_VLAN_TPID_B                  0xf4301708
#define L2FE_PE_CFG_VLAN_TPID_B_dft              0x00008100

typedef volatile union {
  struct {
    ca_uint32_t tpid                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_CFG_VLAN_TPID_B_t;


#define L2FE_PE_CFG_VLAN_TPID_C                  0xf430170c
#define L2FE_PE_CFG_VLAN_TPID_C_dft              0x00008100

typedef volatile union {
  struct {
    ca_uint32_t tpid                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_CFG_VLAN_TPID_C_t;


#define L2FE_PE_CFG_VLAN_TPID_D                  0xf4301710
#define L2FE_PE_CFG_VLAN_TPID_D_dft              0x00008100

typedef volatile union {
  struct {
    ca_uint32_t tpid                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_CFG_VLAN_TPID_D_t;


#define L2FE_PE_MY_MAC_LOW_0                     0xf4301714
#define L2FE_PE_MY_MAC_LOW_0_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_MY_MAC_LOW_0_t;


#define L2FE_PE_MY_MAC_HIGH_0                    0xf4301718
#define L2FE_PE_MY_MAC_HIGH_0_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_MY_MAC_HIGH_0_t;


#define L2FE_PE_MY_MAC_LOW_1                     0xf430171c
#define L2FE_PE_MY_MAC_LOW_1_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_MY_MAC_LOW_1_t;


#define L2FE_PE_MY_MAC_HIGH_1                    0xf4301720
#define L2FE_PE_MY_MAC_HIGH_1_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_MY_MAC_HIGH_1_t;


#define L2FE_PE_CMD_FF_CTL_REG                   0xf4301724
#define L2FE_PE_CMD_FF_CTL_REG_dft               0x00004343

typedef volatile union {
  struct {
    ca_uint32_t low_thr_mir          :  4 ; /* bits 3:0 */
    ca_uint32_t high_thr_mir         :  4 ; /* bits 7:4 */
    ca_uint32_t low_thr_ppl          :  4 ; /* bits 11:8 */
    ca_uint32_t high_thr_ppl         :  4 ; /* bits 15:12 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_CMD_FF_CTL_REG_t;


#define L2FE_PE_CMD_FF_STS_REG                   0xf4301728
#define L2FE_PE_CMD_FF_STS_REG_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t overflow_ind_mir     :  1 ; /* bits 0:0 */
    ca_uint32_t overflow_ind_ppl     :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_CMD_FF_STS_REG_t;


#define L2FE_PE_CMD_FF_CMD_CNT                   0xf430172c
#define L2FE_PE_CMD_FF_CMD_CNT_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num_mir              :  4 ; /* bits 3:0 */
    ca_uint32_t num_ppl              :  4 ; /* bits 7:4 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_CMD_FF_CMD_CNT_t;


#define L2FE_PE_TM_INTERFACE_PKT_CNT             0xf4301730
#define L2FE_PE_TM_INTERFACE_PKT_CNT_dft         0x80000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_TM_INTERFACE_PKT_CNT_t;


#define L2FE_PE_DROP_CNT_TBL_CLR                 0xf4301734
#define L2FE_PE_DROP_CNT_TBL_CLR_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t set                  :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_DROP_CNT_TBL_CLR_t;


#define L2FE_PE_HEADER_A_LOW                     0xf4301738
#define L2FE_PE_HEADER_A_LOW_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_HEADER_A_LOW_t;


#define L2FE_PE_HEADER_A_MID                     0xf430173c
#define L2FE_PE_HEADER_A_MID_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_HEADER_A_MID_t;


#define L2FE_PE_HEADER_A_HI                      0xf4301740
#define L2FE_PE_HEADER_A_HI_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_HEADER_A_HI_t;


#define L2FE_PE_DROP_CNT_GEAR_FF_CNT             0xf4301744
#define L2FE_PE_DROP_CNT_GEAR_FF_CNT_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_DROP_CNT_GEAR_FF_CNT_t;


#define L2FE_PE_DROP_CNT_GEAR_FF_STS             0xf4301748
#define L2FE_PE_DROP_CNT_GEAR_FF_STS_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ovfl                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_DROP_CNT_GEAR_FF_STS_t;


#define L2FE_PE_DEBUG                            0xf430174c
#define L2FE_PE_DEBUG_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bus_sel              :  4 ; /* bits 3:0 */
    ca_uint32_t fe2tm_pkt_cnt_wrap_en :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_DEBUG_t;


#define L2FE_PE_DROP_STTS_ACCESS                 0xf4301750
#define L2FE_PE_DROP_STTS_ACCESS_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_DROP_STTS_ACCESS_t;


#define L2FE_PE_DROP_STTS_DATA                   0xf4301754
#define L2FE_PE_DROP_STTS_DATA_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_DROP_STTS_DATA_t;


#define L2FE_PE_TPID_SEL_CONFIG_TBL_ACCESS       0xf4301758
#define L2FE_PE_TPID_SEL_CONFIG_TBL_ACCESS_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_TPID_SEL_CONFIG_TBL_ACCESS_t;


#define L2FE_PE_TPID_SEL_CONFIG_TBL_DATA         0xf430175c
#define L2FE_PE_TPID_SEL_CONFIG_TBL_DATA_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ctag                 :  2 ; /* bits 1:0 */
    ca_uint32_t stag                 :  2 ; /* bits 3:2 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_PE_TPID_SEL_CONFIG_TBL_DATA_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PE */
typedef struct {
  L2FE_PE_CTRL_t                           CTRL;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  L2FE_PE_CFG_VLAN_TPID_A_t                CFG_VLAN_TPID_A;               /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  L2FE_PE_CFG_VLAN_TPID_B_t                CFG_VLAN_TPID_B;               /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  L2FE_PE_CFG_VLAN_TPID_C_t                CFG_VLAN_TPID_C;               /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  L2FE_PE_CFG_VLAN_TPID_D_t                CFG_VLAN_TPID_D;               /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  L2FE_PE_MY_MAC_LOW_0_t                   MY_MAC_LOW_0;                  /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  L2FE_PE_MY_MAC_HIGH_0_t                  MY_MAC_HIGH_0;                 /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  L2FE_PE_MY_MAC_LOW_1_t                   MY_MAC_LOW_1;                  /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  L2FE_PE_MY_MAC_HIGH_1_t                  MY_MAC_HIGH_1;                 /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  L2FE_PE_CMD_FF_CTL_REG_t                 CMD_FF_CTL_REG;                /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  L2FE_PE_CMD_FF_STS_REG_t                 CMD_FF_STS_REG;                /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  L2FE_PE_CMD_FF_CMD_CNT_t                 CMD_FF_CMD_CNT;                /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  L2FE_PE_TM_INTERFACE_PKT_CNT_t           TM_INTERFACE_PKT_CNT;          /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  L2FE_PE_DROP_CNT_TBL_CLR_t               DROP_CNT_TBL_CLR;              /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  L2FE_PE_HEADER_A_LOW_t                   HEADER_A_LOW;                  /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  L2FE_PE_HEADER_A_MID_t                   HEADER_A_MID;                  /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  L2FE_PE_HEADER_A_HI_t                    HEADER_A_HI;                   /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  L2FE_PE_DROP_CNT_GEAR_FF_CNT_t           DROP_CNT_GEAR_FF_CNT;          /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  L2FE_PE_DROP_CNT_GEAR_FF_STS_t           DROP_CNT_GEAR_FF_STS;          /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  L2FE_PE_DEBUG_t                          _DEBUG;                        /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  L2FE_PE_DROP_STTS_ACCESS_t               DROP_STTS_ACCESS;              /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  L2FE_PE_DROP_STTS_DATA_t                 DROP_STTS_DATA;                /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  L2FE_PE_TPID_SEL_CONFIG_TBL_ACCESS_t     TPID_SEL_CONFIG_TBL_ACCESS;    /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  L2FE_PE_TPID_SEL_CONFIG_TBL_DATA_t       TPID_SEL_CONFIG_TBL_DATA;      /* addr: 0x0000005c */
} APB0_L2FE_PE_t;


/*
 * LF
 */
        
#define L2FE_LF_THRESHOLD                        0xf4301900
#define L2FE_LF_THRESHOLD_dft                    0x0001d8b4

typedef volatile union {
  struct {
    ca_uint32_t low                  :  9 ; /* bits 8:0 */
    ca_uint32_t high                 :  9 ; /* bits 17:9 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_LF_THRESHOLD_t;


#define L2FE_LF_CNT                              0xf4301904
#define L2FE_LF_CNT_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t entry_cnt            :  9 ; /* bits 8:0 */
    ca_uint32_t seg_cnt              :  7 ; /* bits 15:9 */
    ca_uint32_t extra_store_cnt      :  2 ; /* bits 17:16 */
    ca_uint32_t data_ltched          :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_LF_CNT_t;


#define L2FE_LF_STS                              0xf4301908
#define L2FE_LF_STS_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ovfl                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_LF_STS_t;


#define L2FE_LF_DEBUG                            0xf430190c
#define L2FE_LF_DEBUG_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sel                  :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_LF_DEBUG_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* LF */
typedef struct {
  L2FE_LF_THRESHOLD_t                      THRESHOLD;                     /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  L2FE_LF_CNT_t                            CNT;                           /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  L2FE_LF_STS_t                            STS;                           /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  L2FE_LF_DEBUG_t                          _DEBUG;                        /* addr: 0x0000000c */
} APB0_L2FE_LF_t;


/*
 * VE
 */
        
#define L2FE_VE_DEBUG_BUS                        0xf4301a00
#define L2FE_VE_DEBUG_BUS_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sel                  :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_DEBUG_BUS_t;


#define L2FE_VE_WAN_SVL_IDX_ACCESS               0xf4301a04
#define L2FE_VE_WAN_SVL_IDX_ACCESS_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 18 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_WAN_SVL_IDX_ACCESS_t;


#define L2FE_VE_WAN_SVL_IDX_DATA                 0xf4301a08
#define L2FE_VE_WAN_SVL_IDX_DATA_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wan_svl_idx_entry_vld :  1 ; /* bits 0:0 */
    ca_uint32_t wan_svl_idx_fib_idx  :  7 ; /* bits 7:1 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_WAN_SVL_IDX_DATA_t;


#define L2FE_VE_WAN_SVL_FIB_ACCESS               0xf4301a0c
#define L2FE_VE_WAN_SVL_FIB_ACCESS_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_WAN_SVL_FIB_ACCESS_t;


#define L2FE_VE_WAN_SVL_FIB_DATA3                0xf4301a10
#define L2FE_VE_WAN_SVL_FIB_DATA3_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wan_svl_fib_vid      :  8 ; /* bits 7:0 */
    ca_uint32_t wan_svl_fib_do_inner_vid_lookup :  1 ; /* bits 8:8 */
    ca_uint32_t wan_svl_fib_reserved :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_WAN_SVL_FIB_DATA3_t;


#define L2FE_VE_WAN_SVL_FIB_DATA2                0xf4301a14
#define L2FE_VE_WAN_SVL_FIB_DATA2_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wan_svl_fib_dscp     :  6 ; /* bits 5:0 */
    ca_uint32_t wan_svl_fib_802_1p   :  3 ; /* bits 8:6 */
    ca_uint32_t wan_svl_fib_ldpid_vld :  1 ; /* bits 9:9 */
    ca_uint32_t wan_svl_fib_ldpid    :  6 ; /* bits 15:10 */
    ca_uint32_t wan_svl_fib_mc_vlan_ind :  1 ; /* bits 16:16 */
    ca_uint32_t wan_svl_fib_stp_mode :  2 ; /* bits 18:17 */
    ca_uint32_t wan_svl_fib_inner_cmd_valid :  1 ; /* bits 19:19 */
    ca_uint32_t wan_svl_fib_innervid_usel2 :  1 ; /* bits 20:20 */
    ca_uint32_t wan_svl_fib_inner_vlan_cmd :  2 ; /* bits 22:21 */
    ca_uint32_t wan_svl_fib_top_cmd_valid :  1 ; /* bits 23:23 */
    ca_uint32_t wan_svl_fib_topvid_usel2 :  1 ; /* bits 24:24 */
    ca_uint32_t wan_svl_fib_top_vlan_cmd :  2 ; /* bits 26:25 */
    ca_uint32_t wan_svl_fib_sc_ind   :  1 ; /* bits 27:27 */
    ca_uint32_t wan_svl_fib_vid      :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_WAN_SVL_FIB_DATA2_t;


#define L2FE_VE_WAN_SVL_FIB_DATA1                0xf4301a18
#define L2FE_VE_WAN_SVL_FIB_DATA1_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wan_svl_fib_vl_group_id : 10 ; /* bits 9:0 */
    ca_uint32_t wan_svl_fib_da_sa_swap :  1 ; /* bits 10:10 */
    ca_uint32_t wan_svl_fib_permit   :  1 ; /* bits 11:11 */
    ca_uint32_t wan_svl_fib_markdown_en :  1 ; /* bits 12:12 */
    ca_uint32_t wan_svl_fib_flowid_valid :  1 ; /* bits 13:13 */
    ca_uint32_t wan_svl_fib_flowid   : 12 ; /* bits 25:14 */
    ca_uint32_t wan_svl_fib_cos_valid :  1 ; /* bits 26:26 */
    ca_uint32_t wan_svl_fib_dscp_valid :  1 ; /* bits 27:27 */
    ca_uint32_t wan_svl_fib_802_1p_valid :  1 ; /* bits 28:28 */
    ca_uint32_t wan_svl_fib_cos      :  3 ; /* bits 31:29 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_WAN_SVL_FIB_DATA1_t;


#define L2FE_VE_WAN_SVL_FIB_DATA0                0xf4301a1c
#define L2FE_VE_WAN_SVL_FIB_DATA0_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wan_svl_fib_egress_top_untag_bm : 16 ; /* bits 15:0 */
    ca_uint32_t wan_svl_fib_membership_bm : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_WAN_SVL_FIB_DATA0_t;


#define L2FE_VE_WAN_CVL_IDX_ACCESS               0xf4301a20
#define L2FE_VE_WAN_CVL_IDX_ACCESS_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 18 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_WAN_CVL_IDX_ACCESS_t;


#define L2FE_VE_WAN_CVL_IDX_DATA                 0xf4301a24
#define L2FE_VE_WAN_CVL_IDX_DATA_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wan_cvl_idx_entry_vld :  1 ; /* bits 0:0 */
    ca_uint32_t wan_cvl_idx_fib_idx  :  7 ; /* bits 7:1 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_WAN_CVL_IDX_DATA_t;


#define L2FE_VE_WAN_CVL_FIB_ACCESS               0xf4301a28
#define L2FE_VE_WAN_CVL_FIB_ACCESS_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_WAN_CVL_FIB_ACCESS_t;


#define L2FE_VE_WAN_CVL_FIB_DATA3                0xf4301a2c
#define L2FE_VE_WAN_CVL_FIB_DATA3_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wan_cvl_fib_vid      :  8 ; /* bits 7:0 */
    ca_uint32_t wan_cvl_fib_reserved :  2 ; /* bits 9:8 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_WAN_CVL_FIB_DATA3_t;


#define L2FE_VE_WAN_CVL_FIB_DATA2                0xf4301a30
#define L2FE_VE_WAN_CVL_FIB_DATA2_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wan_cvl_fib_dscp     :  6 ; /* bits 5:0 */
    ca_uint32_t wan_cvl_fib_802_1p   :  3 ; /* bits 8:6 */
    ca_uint32_t wan_cvl_fib_ldpid_vld :  1 ; /* bits 9:9 */
    ca_uint32_t wan_cvl_fib_ldpid    :  6 ; /* bits 15:10 */
    ca_uint32_t wan_cvl_fib_mc_vlan_ind :  1 ; /* bits 16:16 */
    ca_uint32_t wan_cvl_fib_stp_mode :  2 ; /* bits 18:17 */
    ca_uint32_t wan_cvl_fib_inner_cmd_valid :  1 ; /* bits 19:19 */
    ca_uint32_t wan_cvl_fib_innervid_usel2 :  1 ; /* bits 20:20 */
    ca_uint32_t wan_cvl_fib_inner_vlan_cmd :  2 ; /* bits 22:21 */
    ca_uint32_t wan_cvl_fib_top_cmd_valid :  1 ; /* bits 23:23 */
    ca_uint32_t wan_cvl_fib_topvid_usel2 :  1 ; /* bits 24:24 */
    ca_uint32_t wan_cvl_fib_top_vlan_cmd :  2 ; /* bits 26:25 */
    ca_uint32_t wan_cvl_fib_sc_ind   :  1 ; /* bits 27:27 */
    ca_uint32_t wan_cvl_fib_vid      :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_WAN_CVL_FIB_DATA2_t;


#define L2FE_VE_WAN_CVL_FIB_DATA1                0xf4301a34
#define L2FE_VE_WAN_CVL_FIB_DATA1_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wan_cvl_fib_vl_group_id : 10 ; /* bits 9:0 */
    ca_uint32_t wan_cvl_fib_da_sa_swap :  1 ; /* bits 10:10 */
    ca_uint32_t wan_cvl_fib_permit   :  1 ; /* bits 11:11 */
    ca_uint32_t wan_cvl_fib_markdown_en :  1 ; /* bits 12:12 */
    ca_uint32_t wan_cvl_fib_flowid_valid :  1 ; /* bits 13:13 */
    ca_uint32_t wan_cvl_fib_flowid   : 12 ; /* bits 25:14 */
    ca_uint32_t wan_cvl_fib_cos_valid :  1 ; /* bits 26:26 */
    ca_uint32_t wan_cvl_fib_dscp_valid :  1 ; /* bits 27:27 */
    ca_uint32_t wan_cvl_fib_802_1p_valid :  1 ; /* bits 28:28 */
    ca_uint32_t wan_cvl_fib_cos      :  3 ; /* bits 31:29 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_WAN_CVL_FIB_DATA1_t;


#define L2FE_VE_WAN_CVL_FIB_DATA0                0xf4301a38
#define L2FE_VE_WAN_CVL_FIB_DATA0_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wan_cvl_fib_egress_top_untag_bm : 16 ; /* bits 15:0 */
    ca_uint32_t wan_cvl_fib_membership_bm : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_WAN_CVL_FIB_DATA0_t;


#define L2FE_VE_LAN_VL_IDX_ACCESS                0xf4301a3c
#define L2FE_VE_LAN_VL_IDX_ACCESS_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 18 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_LAN_VL_IDX_ACCESS_t;


#define L2FE_VE_LAN_VL_IDX_DATA                  0xf4301a40
#define L2FE_VE_LAN_VL_IDX_DATA_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t lan_vl_idx_entry_vld :  1 ; /* bits 0:0 */
    ca_uint32_t lan_vl_idx_fib_idx   :  7 ; /* bits 7:1 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_LAN_VL_IDX_DATA_t;


#define L2FE_VE_LAN_VL_FIB_ACCESS                0xf4301a44
#define L2FE_VE_LAN_VL_FIB_ACCESS_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_LAN_VL_FIB_ACCESS_t;


#define L2FE_VE_LAN_VL_FIB_DATA3                 0xf4301a48
#define L2FE_VE_LAN_VL_FIB_DATA3_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t lan_vl_fib_vid       :  6 ; /* bits 5:0 */
    ca_uint32_t lan_vl_fib_reserved  :  4 ; /* bits 9:6 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_LAN_VL_FIB_DATA3_t;


#define L2FE_VE_LAN_VL_FIB_DATA2                 0xf4301a4c
#define L2FE_VE_LAN_VL_FIB_DATA2_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t lan_vl_fib_dscp      :  6 ; /* bits 5:0 */
    ca_uint32_t lan_vl_fib_802_1p    :  3 ; /* bits 8:6 */
    ca_uint32_t lan_vl_fib_ldpid_vld :  1 ; /* bits 9:9 */
    ca_uint32_t lan_vl_fib_ldpid     :  6 ; /* bits 15:10 */
    ca_uint32_t lan_vl_fib_mc_vlan_ind :  1 ; /* bits 16:16 */
    ca_uint32_t lan_vl_fib_stp_mode  :  2 ; /* bits 18:17 */
    ca_uint32_t lan_vl_fib_inner_cmd_valid :  1 ; /* bits 19:19 */
    ca_uint32_t lan_vl_fib_inner_vlan_cmd :  2 ; /* bits 21:20 */
    ca_uint32_t lan_vl_fib_top_cmd_valid :  1 ; /* bits 22:22 */
    ca_uint32_t lan_vl_fib_top_vlan_cmd :  2 ; /* bits 24:23 */
    ca_uint32_t lan_vl_fib_sc_ind    :  1 ; /* bits 25:25 */
    ca_uint32_t lan_vl_fib_vid       :  6 ; /* bits 31:26 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_LAN_VL_FIB_DATA2_t;


#define L2FE_VE_LAN_VL_FIB_DATA1                 0xf4301a50
#define L2FE_VE_LAN_VL_FIB_DATA1_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t lan_vl_fib_vl_group_id : 10 ; /* bits 9:0 */
    ca_uint32_t lan_vl_fib_da_sa_swap :  1 ; /* bits 10:10 */
    ca_uint32_t lan_vl_fib_permit    :  1 ; /* bits 11:11 */
    ca_uint32_t lan_vl_fib_markdown_en :  1 ; /* bits 12:12 */
    ca_uint32_t lan_vl_fib_flowid_valid :  1 ; /* bits 13:13 */
    ca_uint32_t lan_vl_fib_flowid    : 12 ; /* bits 25:14 */
    ca_uint32_t lan_vl_fib_cos_valid :  1 ; /* bits 26:26 */
    ca_uint32_t lan_vl_fib_dscp_valid :  1 ; /* bits 27:27 */
    ca_uint32_t lan_vl_fib_802_1p_valid :  1 ; /* bits 28:28 */
    ca_uint32_t lan_vl_fib_cos       :  3 ; /* bits 31:29 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_LAN_VL_FIB_DATA1_t;


#define L2FE_VE_LAN_VL_FIB_DATA0                 0xf4301a54
#define L2FE_VE_LAN_VL_FIB_DATA0_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t lan_vl_fib_egress_top_untag_bm : 16 ; /* bits 15:0 */
    ca_uint32_t lan_vl_fib_membership_bm : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_VE_LAN_VL_FIB_DATA0_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* VE */
typedef struct {
  L2FE_VE_DEBUG_BUS_t                      DEBUG_BUS;                     /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  L2FE_VE_WAN_SVL_IDX_ACCESS_t             WAN_SVL_IDX_ACCESS;            /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  L2FE_VE_WAN_SVL_IDX_DATA_t               WAN_SVL_IDX_DATA;              /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  L2FE_VE_WAN_SVL_FIB_ACCESS_t             WAN_SVL_FIB_ACCESS;            /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  L2FE_VE_WAN_SVL_FIB_DATA3_t              WAN_SVL_FIB_DATA3;             /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  L2FE_VE_WAN_SVL_FIB_DATA2_t              WAN_SVL_FIB_DATA2;             /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  L2FE_VE_WAN_SVL_FIB_DATA1_t              WAN_SVL_FIB_DATA1;             /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  L2FE_VE_WAN_SVL_FIB_DATA0_t              WAN_SVL_FIB_DATA0;             /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  L2FE_VE_WAN_CVL_IDX_ACCESS_t             WAN_CVL_IDX_ACCESS;            /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  L2FE_VE_WAN_CVL_IDX_DATA_t               WAN_CVL_IDX_DATA;              /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  L2FE_VE_WAN_CVL_FIB_ACCESS_t             WAN_CVL_FIB_ACCESS;            /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  L2FE_VE_WAN_CVL_FIB_DATA3_t              WAN_CVL_FIB_DATA3;             /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  L2FE_VE_WAN_CVL_FIB_DATA2_t              WAN_CVL_FIB_DATA2;             /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  L2FE_VE_WAN_CVL_FIB_DATA1_t              WAN_CVL_FIB_DATA1;             /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  L2FE_VE_WAN_CVL_FIB_DATA0_t              WAN_CVL_FIB_DATA0;             /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  L2FE_VE_LAN_VL_IDX_ACCESS_t              LAN_VL_IDX_ACCESS;             /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  L2FE_VE_LAN_VL_IDX_DATA_t                LAN_VL_IDX_DATA;               /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  L2FE_VE_LAN_VL_FIB_ACCESS_t              LAN_VL_FIB_ACCESS;             /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  L2FE_VE_LAN_VL_FIB_DATA3_t               LAN_VL_FIB_DATA3;              /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  L2FE_VE_LAN_VL_FIB_DATA2_t               LAN_VL_FIB_DATA2;              /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  L2FE_VE_LAN_VL_FIB_DATA1_t               LAN_VL_FIB_DATA1;              /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  L2FE_VE_LAN_VL_FIB_DATA0_t               LAN_VL_FIB_DATA0;              /* addr: 0x00000054 */
} APB0_L2FE_VE_t;


/*
 * CLE
 */
        
#define L2FE_CLE_CTRL                            0xf4301b00
#define L2FE_CLE_CTRL_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t igr_use_frst_hit     :  1 ; /* bits 0:0 */
    ca_uint32_t egr_use_frst_hit     :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_CTRL_t;


#define L2FE_CLE_CONFG_STTS1                     0xf4301b04
#define L2FE_CLE_CONFG_STTS1_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t igr_configured_length_over_size :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_CONFG_STTS1_t;


#define L2FE_CLE_CONFG_STTS2                     0xf4301b08
#define L2FE_CLE_CONFG_STTS2_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t egr_configured_length_over_size :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_CONFG_STTS2_t;


#define L2FE_CLE_DEBUG                           0xf4301b0c
#define L2FE_CLE_DEBUG_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t igr_cls_bus_sel      :  2 ; /* bits 1:0 */
    ca_uint32_t egr_cls_bus_sel      :  2 ; /* bits 3:2 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_DEBUG_t;


#define L2FE_CLE_IGR_KEY_ACCESS                  0xf4301b10
#define L2FE_CLE_IGR_KEY_ACCESS_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_ACCESS_t;


#define L2FE_CLE_IGR_KEY_DATA12                  0xf4301b14
#define L2FE_CLE_IGR_KEY_DATA12_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_entry_type    :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_valid         :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA12_t;


#define L2FE_CLE_IGR_KEY_DATA11                  0xf4301b18
#define L2FE_CLE_IGR_KEY_DATA11_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_mac_da :  8 ; /* bits 7:0 */
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_ecn_mask :  1 ; /* bits 8:8 */
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_ecn :  2 ; /* bits 10:9 */
    ca_uint32_t cl_key_orhr_ipv4e_reserved : 19 ; /* bits 29:11 */
    ca_uint32_t cl_key_orhr_ipv6_valid :  1 ; /* bits 30:30 */
    ca_uint32_t cl_key_entry_type    :  1 ; /* bits 31:31 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_da : 27 ; /* bits 26:0 */
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_ecn_mask :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_ecn :  2 ; /* bits 29:28 */
    ca_uint32_t cl_key_tre_rule_hinge :  1 ; /* bits 30:30 */
    ca_uint32_t rsrvd1               :  1 ;
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_1_mac_da : 19 ; /* bits 18:0 */
    ca_uint32_t cl_key_tre_l2rl2r_1_reserved :  7 ; /* bits 25:19 */
    ca_uint32_t cl_key_tre_rule_type_1 :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_rule_type_0 :  2 ; /* bits 29:28 */
    ca_uint32_t rsrvd1               :  2 ;
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_1_mac_da : 19 ; /* bits 18:0 */
    ca_uint32_t cl_key_tre_l2rl3r_1_reserved :  7 ; /* bits 25:19 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_1_mac_da : 19 ; /* bits 18:0 */
    ca_uint32_t cl_key_tre_l2rcmr_1_reserved :  7 ; /* bits 25:19 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_da : 17 ; /* bits 16:0 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ecn_mask :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ecn :  2 ; /* bits 19:18 */
    ca_uint32_t cl_key_tre_l3rl2r_1_reserved :  6 ; /* bits 25:20 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_da : 17 ; /* bits 16:0 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ecn_mask :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ecn :  2 ; /* bits 19:18 */
    ca_uint32_t cl_key_tre_l3rl3r_1_reserved :  6 ; /* bits 25:20 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_da : 17 ; /* bits 16:0 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ecn_mask :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ecn :  2 ; /* bits 19:18 */
    ca_uint32_t cl_key_tre_l3rcmr_1_reserved :  6 ; /* bits 25:20 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_1_mac_addr : 17 ; /* bits 16:0 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ecn_mask :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ecn :  2 ; /* bits 19:18 */
    ca_uint32_t cl_key_tre_cmrl2r_1_reserved :  6 ; /* bits 25:20 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_1_mac_addr : 17 ; /* bits 16:0 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ecn_mask :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ecn :  2 ; /* bits 19:18 */
    ca_uint32_t cl_key_tre_cmrl3r_1_reserved :  6 ; /* bits 25:20 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_1_mac_addr : 17 ; /* bits 16:0 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ecn_mask :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ecn :  2 ; /* bits 19:18 */
    ca_uint32_t cl_key_tre_cmrcmr_1_reserved :  6 ; /* bits 25:20 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf10 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA11_t;


#define L2FE_CLE_IGR_KEY_DATA10                  0xf4301b1c
#define L2FE_CLE_IGR_KEY_DATA10_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_mac_da : 32 ; /* bits 31:0 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_da : 32 ; /* bits 31:0 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_1_mac_sa :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l2rl2r_1_mac_da : 29 ; /* bits 31:3 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_1_mac_sa :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l2rl3r_1_mac_da : 29 ; /* bits 31:3 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_1_mac_sa :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l2rcmr_1_mac_da : 29 ; /* bits 31:3 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_sa : 17 ; /* bits 16:0 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_da : 15 ; /* bits 31:17 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_sa : 17 ; /* bits 16:0 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_da : 15 ; /* bits 31:17 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_sa : 17 ; /* bits 16:0 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_da : 15 ; /* bits 31:17 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_addr :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrl2r_1_mac_addr : 31 ; /* bits 31:1 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_addr :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrl3r_1_mac_addr : 31 ; /* bits 31:1 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_addr :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrcmr_1_mac_addr : 31 ; /* bits 31:1 */
  } bf10 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA10_t;


#define L2FE_CLE_IGR_KEY_DATA9                   0xf4301b20
#define L2FE_CLE_IGR_KEY_DATA9_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_mac_sa : 24 ; /* bits 23:0 */
    ca_uint32_t cl_key_orhr_ipv4e_mac_da :  8 ; /* bits 31:24 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_da : 32 ; /* bits 31:0 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_1_mac_sa : 32 ; /* bits 31:0 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_1_mac_sa : 32 ; /* bits 31:0 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_1_mac_sa : 32 ; /* bits 31:0 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_flags :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_fragment :  1 ; /* bits 1:1 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_option :  1 ; /* bits 2:2 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ip_tos :  6 ; /* bits 8:3 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ip_pt :  8 ; /* bits 16:9 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_sa : 15 ; /* bits 31:17 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_flags :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_fragment :  1 ; /* bits 1:1 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_option :  1 ; /* bits 2:2 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ip_tos :  6 ; /* bits 8:3 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ip_pt :  8 ; /* bits 16:9 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_sa : 15 ; /* bits 31:17 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_flags :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_fragment :  1 ; /* bits 1:1 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_option :  1 ; /* bits 2:2 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ip_tos :  6 ; /* bits 8:3 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ip_pt :  8 ; /* bits 16:9 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_sa : 15 ; /* bits 31:17 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_1_ip_pt :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_addr : 31 ; /* bits 31:1 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_1_ip_pt :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_addr : 31 ; /* bits 31:1 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_1_ip_pt :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_addr : 31 ; /* bits 31:1 */
  } bf10 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA9_t;


#define L2FE_CLE_IGR_KEY_DATA8                   0xf4301b24
#define L2FE_CLE_IGR_KEY_DATA8_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_top_vid :  8 ; /* bits 7:0 */
    ca_uint32_t cl_key_orhr_ipv4e_mac_sa : 24 ; /* bits 31:8 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_da : 32 ; /* bits 31:0 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_1_inner_vid :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_l2rl2r_1_top_sc_ind :  1 ; /* bits 6:6 */
    ca_uint32_t cl_key_tre_l2rl2r_1_top_vid : 12 ; /* bits 18:7 */
    ca_uint32_t cl_key_tre_l2rl2r_1_mac_sa : 13 ; /* bits 31:19 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_1_inner_vid :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_l2rl3r_1_top_sc_ind :  1 ; /* bits 6:6 */
    ca_uint32_t cl_key_tre_l2rl3r_1_top_vid : 12 ; /* bits 18:7 */
    ca_uint32_t cl_key_tre_l2rl3r_1_mac_sa : 13 ; /* bits 31:19 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_1_inner_vid :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_l2rcmr_1_top_sc_ind :  1 ; /* bits 6:6 */
    ca_uint32_t cl_key_tre_l2rcmr_1_top_vid : 12 ; /* bits 18:7 */
    ca_uint32_t cl_key_tre_l2rcmr_1_mac_sa : 13 ; /* bits 31:19 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_1_inner_vid : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_l3rl2r_1_top_sc_ind :  1 ; /* bits 12:12 */
    ca_uint32_t cl_key_tre_l3rl2r_1_top_vid : 12 ; /* bits 24:13 */
    ca_uint32_t cl_key_tre_l3rl2r_1_special_pkt_code :  5 ; /* bits 29:25 */
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_flags :  2 ; /* bits 31:30 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_1_inner_vid : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_l3rl3r_1_top_sc_ind :  1 ; /* bits 12:12 */
    ca_uint32_t cl_key_tre_l3rl3r_1_top_vid : 12 ; /* bits 24:13 */
    ca_uint32_t cl_key_tre_l3rl3r_1_special_pkt_code :  5 ; /* bits 29:25 */
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_flags :  2 ; /* bits 31:30 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_1_inner_vid : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_l3rcmr_1_top_sc_ind :  1 ; /* bits 12:12 */
    ca_uint32_t cl_key_tre_l3rcmr_1_top_vid : 12 ; /* bits 24:13 */
    ca_uint32_t cl_key_tre_l3rcmr_1_special_pkt_code :  5 ; /* bits 29:25 */
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_flags :  2 ; /* bits 31:30 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_1_top_vid :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_tre_cmrl2r_1_special_pkt_code :  5 ; /* bits 13:9 */
    ca_uint32_t cl_key_tre_cmrl2r_1_l4_flags :  3 ; /* bits 16:14 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_fragment :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_option :  1 ; /* bits 18:18 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ip_tos :  6 ; /* bits 24:19 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ip_pt :  7 ; /* bits 31:25 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_1_top_vid :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_tre_cmrl3r_1_special_pkt_code :  5 ; /* bits 13:9 */
    ca_uint32_t cl_key_tre_cmrl3r_1_l4_flags :  3 ; /* bits 16:14 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_fragment :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_option :  1 ; /* bits 18:18 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ip_tos :  6 ; /* bits 24:19 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ip_pt :  7 ; /* bits 31:25 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_1_top_vid :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_tre_cmrcmr_1_special_pkt_code :  5 ; /* bits 13:9 */
    ca_uint32_t cl_key_tre_cmrcmr_1_l4_flags :  3 ; /* bits 16:14 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_fragment :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_option :  1 ; /* bits 18:18 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ip_tos :  6 ; /* bits 24:19 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ip_pt :  7 ; /* bits 31:25 */
  } bf10 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA8_t;


#define L2FE_CLE_IGR_KEY_DATA7                   0xf4301b28
#define L2FE_CLE_IGR_KEY_DATA7_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_da :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_orhr_ipv4e_ev2_pt :  5 ; /* bits 5:1 */
    ca_uint32_t cl_key_orhr_ipv4e_tag_num :  2 ; /* bits 7:6 */
    ca_uint32_t cl_key_orhr_ipv4e_inner_802_1p :  3 ; /* bits 10:8 */
    ca_uint32_t cl_key_orhr_ipv4e_top_802_1p :  3 ; /* bits 13:11 */
    ca_uint32_t cl_key_orhr_ipv4e_inner_sc_ind :  1 ; /* bits 14:14 */
    ca_uint32_t cl_key_orhr_ipv4e_inner_vid : 12 ; /* bits 26:15 */
    ca_uint32_t cl_key_orhr_ipv4e_top_sc_ind :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_orhr_ipv4e_top_vid :  4 ; /* bits 31:28 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa : 27 ; /* bits 26:0 */
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_da :  5 ; /* bits 31:27 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_1_l4_dp : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_l2rl2r_1_ev2_pt :  5 ; /* bits 16:12 */
    ca_uint32_t cl_key_tre_l2rl2r_1_tag_num :  2 ; /* bits 18:17 */
    ca_uint32_t cl_key_tre_l2rl2r_1_inner_802_1p :  3 ; /* bits 21:19 */
    ca_uint32_t cl_key_tre_l2rl2r_1_top_802_1p :  3 ; /* bits 24:22 */
    ca_uint32_t cl_key_tre_l2rl2r_1_inner_sc_ind :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_l2rl2r_1_inner_vid :  6 ; /* bits 31:26 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_1_l4_dp : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_l2rl3r_1_ev2_pt :  5 ; /* bits 16:12 */
    ca_uint32_t cl_key_tre_l2rl3r_1_tag_num :  2 ; /* bits 18:17 */
    ca_uint32_t cl_key_tre_l2rl3r_1_inner_802_1p :  3 ; /* bits 21:19 */
    ca_uint32_t cl_key_tre_l2rl3r_1_top_802_1p :  3 ; /* bits 24:22 */
    ca_uint32_t cl_key_tre_l2rl3r_1_inner_sc_ind :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_l2rl3r_1_inner_vid :  6 ; /* bits 31:26 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_1_l4_dp : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_l2rcmr_1_ev2_pt :  5 ; /* bits 16:12 */
    ca_uint32_t cl_key_tre_l2rcmr_1_tag_num :  2 ; /* bits 18:17 */
    ca_uint32_t cl_key_tre_l2rcmr_1_inner_802_1p :  3 ; /* bits 21:19 */
    ca_uint32_t cl_key_tre_l2rcmr_1_top_802_1p :  3 ; /* bits 24:22 */
    ca_uint32_t cl_key_tre_l2rcmr_1_inner_sc_ind :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_l2rcmr_1_inner_vid :  6 ; /* bits 31:26 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_sp :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_dp : 16 ; /* bits 17:2 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ev2_pt :  5 ; /* bits 22:18 */
    ca_uint32_t cl_key_tre_l3rl2r_1_tag_num :  2 ; /* bits 24:23 */
    ca_uint32_t cl_key_tre_l3rl2r_1_inner_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_l3rl2r_1_top_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_l3rl2r_1_inner_sc_ind :  1 ; /* bits 31:31 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_sp :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_dp : 16 ; /* bits 17:2 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ev2_pt :  5 ; /* bits 22:18 */
    ca_uint32_t cl_key_tre_l3rl3r_1_tag_num :  2 ; /* bits 24:23 */
    ca_uint32_t cl_key_tre_l3rl3r_1_inner_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_l3rl3r_1_top_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_l3rl3r_1_inner_sc_ind :  1 ; /* bits 31:31 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_sp :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_dp : 16 ; /* bits 17:2 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ev2_pt :  5 ; /* bits 22:18 */
    ca_uint32_t cl_key_tre_l3rcmr_1_tag_num :  2 ; /* bits 24:23 */
    ca_uint32_t cl_key_tre_l3rcmr_1_inner_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_l3rcmr_1_top_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_l3rcmr_1_inner_sc_ind :  1 ; /* bits 31:31 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_1_l4_sp :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_cmrl2r_1_l4_dp : 16 ; /* bits 17:2 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ev2_pt :  5 ; /* bits 22:18 */
    ca_uint32_t cl_key_tre_cmrl2r_1_tag_num :  2 ; /* bits 24:23 */
    ca_uint32_t cl_key_tre_cmrl2r_1_top_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_cmrl2r_1_top_sc_ind :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_cmrl2r_1_top_vid :  3 ; /* bits 31:29 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_1_l4_sp :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_cmrl3r_1_l4_dp : 16 ; /* bits 17:2 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ev2_pt :  5 ; /* bits 22:18 */
    ca_uint32_t cl_key_tre_cmrl3r_1_tag_num :  2 ; /* bits 24:23 */
    ca_uint32_t cl_key_tre_cmrl3r_1_top_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_cmrl3r_1_top_sc_ind :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_cmrl3r_1_top_vid :  3 ; /* bits 31:29 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_1_l4_sp :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_cmrcmr_1_l4_dp : 16 ; /* bits 17:2 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ev2_pt :  5 ; /* bits 22:18 */
    ca_uint32_t cl_key_tre_cmrcmr_1_tag_num :  2 ; /* bits 24:23 */
    ca_uint32_t cl_key_tre_cmrcmr_1_top_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_cmrcmr_1_top_sc_ind :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_cmrcmr_1_top_vid :  3 ; /* bits 31:29 */
  } bf10 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA7_t;


#define L2FE_CLE_IGR_KEY_DATA6                   0xf4301b2c
#define L2FE_CLE_IGR_KEY_DATA6_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_sa :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_da : 31 ; /* bits 31:1 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa : 32 ; /* bits 31:0 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_1_fields_operator :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l2rl2r_1_mask :  2 ; /* bits 2:1 */
    ca_uint32_t cl_key_tre_l2rl2r_1_l4_ctrl :  3 ; /* bits 5:3 */
    ca_uint32_t cl_key_tre_l2rl2r_1_dot1p_ctrl :  2 ; /* bits 7:6 */
    ca_uint32_t cl_key_tre_l2rl2r_1_vid_ctrl :  2 ; /* bits 9:8 */
    ca_uint32_t cl_key_tre_l2rl2r_1_mac_ctrl :  2 ; /* bits 11:10 */
    ca_uint32_t cl_key_tre_l2rl2r_1_l4_sp : 16 ; /* bits 27:12 */
    ca_uint32_t cl_key_tre_l2rl2r_1_l4_dp :  4 ; /* bits 31:28 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_1_fields_operator :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l2rl3r_1_mask :  2 ; /* bits 2:1 */
    ca_uint32_t cl_key_tre_l2rl3r_1_l4_ctrl :  3 ; /* bits 5:3 */
    ca_uint32_t cl_key_tre_l2rl3r_1_dot1p_ctrl :  2 ; /* bits 7:6 */
    ca_uint32_t cl_key_tre_l2rl3r_1_vid_ctrl :  2 ; /* bits 9:8 */
    ca_uint32_t cl_key_tre_l2rl3r_1_mac_ctrl :  2 ; /* bits 11:10 */
    ca_uint32_t cl_key_tre_l2rl3r_1_l4_sp : 16 ; /* bits 27:12 */
    ca_uint32_t cl_key_tre_l2rl3r_1_l4_dp :  4 ; /* bits 31:28 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_1_fields_operator :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l2rcmr_1_mask :  2 ; /* bits 2:1 */
    ca_uint32_t cl_key_tre_l2rcmr_1_l4_ctrl :  3 ; /* bits 5:3 */
    ca_uint32_t cl_key_tre_l2rcmr_1_dot1p_ctrl :  2 ; /* bits 7:6 */
    ca_uint32_t cl_key_tre_l2rcmr_1_vid_ctrl :  2 ; /* bits 9:8 */
    ca_uint32_t cl_key_tre_l2rcmr_1_mac_ctrl :  2 ; /* bits 11:10 */
    ca_uint32_t cl_key_tre_l2rcmr_1_l4_sp : 16 ; /* bits 27:12 */
    ca_uint32_t cl_key_tre_l2rcmr_1_l4_dp :  4 ; /* bits 31:28 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_1_fields_operator :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l3rl2r_1_mask :  8 ; /* bits 8:1 */
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_ctrl :  3 ; /* bits 11:9 */
    ca_uint32_t cl_key_tre_l3rl2r_1_dot1p_ctrl :  2 ; /* bits 13:12 */
    ca_uint32_t cl_key_tre_l3rl2r_1_vid_ctrl :  2 ; /* bits 15:14 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ip_ctrl :  2 ; /* bits 17:16 */
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_sp : 14 ; /* bits 31:18 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_1_fields_operator :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l3rl3r_1_mask :  8 ; /* bits 8:1 */
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_ctrl :  3 ; /* bits 11:9 */
    ca_uint32_t cl_key_tre_l3rl3r_1_dot1p_ctrl :  2 ; /* bits 13:12 */
    ca_uint32_t cl_key_tre_l3rl3r_1_vid_ctrl :  2 ; /* bits 15:14 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ip_ctrl :  2 ; /* bits 17:16 */
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_sp : 14 ; /* bits 31:18 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_1_fields_operator :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l3rcmr_1_mask :  8 ; /* bits 8:1 */
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_ctrl :  3 ; /* bits 11:9 */
    ca_uint32_t cl_key_tre_l3rcmr_1_dot1p_ctrl :  2 ; /* bits 13:12 */
    ca_uint32_t cl_key_tre_l3rcmr_1_vid_ctrl :  2 ; /* bits 15:14 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ip_ctrl :  2 ; /* bits 17:16 */
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_sp : 14 ; /* bits 31:18 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_1_fields_operator :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrl2r_1_mask : 12 ; /* bits 12:1 */
    ca_uint32_t cl_key_tre_cmrl2r_1_l4_ctrl :  3 ; /* bits 15:13 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_addr_sel :  1 ; /* bits 16:16 */
    ca_uint32_t cl_key_tre_cmrl2r_1_mac_addr_sel :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_cmrl2r_1_l4_sp : 14 ; /* bits 31:18 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_1_fields_operator :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrl3r_1_mask : 12 ; /* bits 12:1 */
    ca_uint32_t cl_key_tre_cmrl3r_1_l4_ctrl :  3 ; /* bits 15:13 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_addr_sel :  1 ; /* bits 16:16 */
    ca_uint32_t cl_key_tre_cmrl3r_1_mac_addr_sel :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_cmrl3r_1_l4_sp : 14 ; /* bits 31:18 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_1_fields_operator :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrcmr_1_mask : 12 ; /* bits 12:1 */
    ca_uint32_t cl_key_tre_cmrcmr_1_l4_ctrl :  3 ; /* bits 15:13 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_addr_sel :  1 ; /* bits 16:16 */
    ca_uint32_t cl_key_tre_cmrcmr_1_mac_addr_sel :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_cmrcmr_1_l4_sp : 14 ; /* bits 31:18 */
  } bf10 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA6_t;


#define L2FE_CLE_IGR_KEY_DATA5                   0xf4301b30
#define L2FE_CLE_IGR_KEY_DATA5_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_ip_pt :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_sa : 31 ; /* bits 31:1 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa : 32 ; /* bits 31:0 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_2_mac_da : 22 ; /* bits 21:0 */
    ca_uint32_t cl_key_tre_l2rl2r_2_reserved :  7 ; /* bits 28:22 */
    ca_uint32_t cl_key_tre_l2rl2r_1_prcd :  3 ; /* bits 31:29 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_da : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ecn_mask :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ecn :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_l2rl3r_2_reserved :  6 ; /* bits 28:23 */
    ca_uint32_t cl_key_tre_l2rl3r_1_prcd :  3 ; /* bits 31:29 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_2_mac_addr : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ecn_mask :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ecn :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_l2rcmr_2_reserved :  6 ; /* bits 28:23 */
    ca_uint32_t cl_key_tre_l2rcmr_1_prcd :  3 ; /* bits 31:29 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_2_mac_da : 22 ; /* bits 21:0 */
    ca_uint32_t cl_key_tre_l3rl2r_2_reserved :  7 ; /* bits 28:22 */
    ca_uint32_t cl_key_tre_l3rl2r_1_prcd :  3 ; /* bits 31:29 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_da : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ecn_mask :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ecn :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_l3rl3r_2_reserved :  6 ; /* bits 28:23 */
    ca_uint32_t cl_key_tre_l3rl3r_1_prcd :  3 ; /* bits 31:29 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_2_mac_addr : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ecn_mask :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ecn :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_l3rcmr_2_reserved :  6 ; /* bits 28:23 */
    ca_uint32_t cl_key_tre_l3rcmr_1_prcd :  3 ; /* bits 31:29 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_2_mac_da : 22 ; /* bits 21:0 */
    ca_uint32_t cl_key_tre_cmrl2r_2_reserved :  7 ; /* bits 28:22 */
    ca_uint32_t cl_key_tre_cmrl2r_1_prcd :  3 ; /* bits 31:29 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_da : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ecn_mask :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ecn :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_cmrl3r_2_reserved :  6 ; /* bits 28:23 */
    ca_uint32_t cl_key_tre_cmrl3r_1_prcd :  3 ; /* bits 31:29 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_2_mac_addr : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ecn_mask :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ecn :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_cmrcmr_2_reserved :  6 ; /* bits 28:23 */
    ca_uint32_t cl_key_tre_cmrcmr_1_prcd :  3 ; /* bits 31:29 */
  } bf10 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA5_t;


#define L2FE_CLE_IGR_KEY_DATA4                   0xf4301b34
#define L2FE_CLE_IGR_KEY_DATA4_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_l4_dp_low :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_dp_high : 16 ; /* bits 16:1 */
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_fragment :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_option :  1 ; /* bits 18:18 */
    ca_uint32_t cl_key_orhr_ipv4e_ip_tos :  6 ; /* bits 24:19 */
    ca_uint32_t cl_key_orhr_ipv4e_ip_pt :  7 ; /* bits 31:25 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa : 32 ; /* bits 31:0 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_2_mac_sa :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_l2rl2r_2_mac_da : 26 ; /* bits 31:6 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_sa : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_da : 12 ; /* bits 31:20 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_addr :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_l2rcmr_2_mac_addr : 28 ; /* bits 31:4 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_2_mac_sa :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_l3rl2r_2_mac_da : 26 ; /* bits 31:6 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_sa : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_da : 12 ; /* bits 31:20 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_addr :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_l3rcmr_2_mac_addr : 28 ; /* bits 31:4 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_2_mac_sa :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_cmrl2r_2_mac_da : 26 ; /* bits 31:6 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_sa : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_da : 12 ; /* bits 31:20 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_addr :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_cmrcmr_2_mac_addr : 28 ; /* bits 31:4 */
  } bf10 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA4_t;


#define L2FE_CLE_IGR_KEY_DATA3                   0xf4301b38
#define L2FE_CLE_IGR_KEY_DATA3_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_l4_sp_low :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_sp_high : 16 ; /* bits 16:1 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_dp_low : 15 ; /* bits 31:17 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ip_tos :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_orhr_ipv6e_ip_pt :  8 ; /* bits 12:5 */
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_mask : 14 ; /* bits 26:13 */
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa :  5 ; /* bits 31:27 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_2_mac_sa : 32 ; /* bits 31:0 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_2_special_pkt_code :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l2rl3r_2_l4_flags :  3 ; /* bits 3:1 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_fragment :  1 ; /* bits 4:4 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_option :  1 ; /* bits 5:5 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ip_tos :  6 ; /* bits 11:6 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ip_pt :  8 ; /* bits 19:12 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_sa : 12 ; /* bits 31:20 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_2_ip_pt :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_addr : 28 ; /* bits 31:4 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_2_mac_sa : 32 ; /* bits 31:0 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_2_special_pkt_code :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l3rl3r_2_l4_flags :  3 ; /* bits 3:1 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_fragment :  1 ; /* bits 4:4 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_option :  1 ; /* bits 5:5 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ip_tos :  6 ; /* bits 11:6 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ip_pt :  8 ; /* bits 19:12 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_sa : 12 ; /* bits 31:20 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_2_ip_pt :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_addr : 28 ; /* bits 31:4 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_2_mac_sa : 32 ; /* bits 31:0 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_2_special_pkt_code :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrl3r_2_l4_flags :  3 ; /* bits 3:1 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_fragment :  1 ; /* bits 4:4 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_option :  1 ; /* bits 5:5 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ip_tos :  6 ; /* bits 11:6 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ip_pt :  8 ; /* bits 19:12 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_sa : 12 ; /* bits 31:20 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_2_ip_pt :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_addr : 28 ; /* bits 31:4 */
  } bf10 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA3_t;


#define L2FE_CLE_IGR_KEY_DATA2                   0xf4301b3c
#define L2FE_CLE_IGR_KEY_DATA2_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_global_key :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_orhr_ipv4e_special_pkt_code :  5 ; /* bits 13:9 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_flags :  3 ; /* bits 16:14 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_sp_low : 15 ; /* bits 31:17 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_l4_dp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_orhr_ipv6e_tag_num :  2 ; /* bits 6:5 */
    ca_uint32_t cl_key_orhr_ipv6e_top_802_1p :  3 ; /* bits 9:7 */
    ca_uint32_t cl_key_orhr_ipv6e_top_sc_ind :  1 ; /* bits 10:10 */
    ca_uint32_t cl_key_orhr_ipv6e_top_vid : 12 ; /* bits 22:11 */
    ca_uint32_t cl_key_orhr_ipv6e_special_pkt_code :  5 ; /* bits 27:23 */
    ca_uint32_t cl_key_orhr_ipv6e_l4_flags :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_orhr_ipv6e_ip_tos :  1 ; /* bits 31:31 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_2_inner_vid :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_tre_l2rl2r_2_top_sc_ind :  1 ; /* bits 9:9 */
    ca_uint32_t cl_key_tre_l2rl2r_2_top_vid : 12 ; /* bits 21:10 */
    ca_uint32_t cl_key_tre_l2rl2r_2_mac_sa : 10 ; /* bits 31:22 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_2_top_802_1p :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l2rl3r_2_inner_sc_ind :  1 ; /* bits 2:2 */
    ca_uint32_t cl_key_tre_l2rl3r_2_inner_vid : 12 ; /* bits 14:3 */
    ca_uint32_t cl_key_tre_l2rl3r_2_top_sc_ind :  1 ; /* bits 15:15 */
    ca_uint32_t cl_key_tre_l2rl3r_2_top_vid : 12 ; /* bits 27:16 */
    ca_uint32_t cl_key_tre_l2rl3r_2_special_pkt_code :  4 ; /* bits 31:28 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_2_top_vid : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_l2rcmr_2_special_pkt_code :  5 ; /* bits 16:12 */
    ca_uint32_t cl_key_tre_l2rcmr_2_l4_flags :  3 ; /* bits 19:17 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_fragment :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_option :  1 ; /* bits 21:21 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ip_tos :  6 ; /* bits 27:22 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ip_pt :  4 ; /* bits 31:28 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_2_inner_vid :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_tre_l3rl2r_2_top_sc_ind :  1 ; /* bits 9:9 */
    ca_uint32_t cl_key_tre_l3rl2r_2_top_vid : 12 ; /* bits 21:10 */
    ca_uint32_t cl_key_tre_l3rl2r_2_mac_sa : 10 ; /* bits 31:22 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_2_top_802_1p :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l3rl3r_2_inner_sc_ind :  1 ; /* bits 2:2 */
    ca_uint32_t cl_key_tre_l3rl3r_2_inner_vid : 12 ; /* bits 14:3 */
    ca_uint32_t cl_key_tre_l3rl3r_2_top_sc_ind :  1 ; /* bits 15:15 */
    ca_uint32_t cl_key_tre_l3rl3r_2_top_vid : 12 ; /* bits 27:16 */
    ca_uint32_t cl_key_tre_l3rl3r_2_special_pkt_code :  4 ; /* bits 31:28 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_2_top_vid : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_l3rcmr_2_special_pkt_code :  5 ; /* bits 16:12 */
    ca_uint32_t cl_key_tre_l3rcmr_2_l4_flags :  3 ; /* bits 19:17 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_fragment :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_option :  1 ; /* bits 21:21 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ip_tos :  6 ; /* bits 27:22 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ip_pt :  4 ; /* bits 31:28 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_2_inner_vid :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_tre_cmrl2r_2_top_sc_ind :  1 ; /* bits 9:9 */
    ca_uint32_t cl_key_tre_cmrl2r_2_top_vid : 12 ; /* bits 21:10 */
    ca_uint32_t cl_key_tre_cmrl2r_2_mac_sa : 10 ; /* bits 31:22 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_2_top_802_1p :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_cmrl3r_2_inner_sc_ind :  1 ; /* bits 2:2 */
    ca_uint32_t cl_key_tre_cmrl3r_2_inner_vid : 12 ; /* bits 14:3 */
    ca_uint32_t cl_key_tre_cmrl3r_2_top_sc_ind :  1 ; /* bits 15:15 */
    ca_uint32_t cl_key_tre_cmrl3r_2_top_vid : 12 ; /* bits 27:16 */
    ca_uint32_t cl_key_tre_cmrl3r_2_special_pkt_code :  4 ; /* bits 31:28 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_2_top_vid : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_cmrcmr_2_special_pkt_code :  5 ; /* bits 16:12 */
    ca_uint32_t cl_key_tre_cmrcmr_2_l4_flags :  3 ; /* bits 19:17 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_fragment :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_option :  1 ; /* bits 21:21 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ip_tos :  6 ; /* bits 27:22 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ip_pt :  4 ; /* bits 31:28 */
  } bf10 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA2_t;


#define L2FE_CLE_IGR_KEY_DATA1                   0xf4301b40
#define L2FE_CLE_IGR_KEY_DATA1_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_ip_ctrl :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_orhr_ipv4e_dot1p_ctrl :  2 ; /* bits 4:3 */
    ca_uint32_t cl_key_orhr_ipv4e_vid_ctrl :  2 ; /* bits 6:5 */
    ca_uint32_t cl_key_orhr_ipv4e_mac_ctrl :  2 ; /* bits 8:7 */
    ca_uint32_t cl_key_orhr_ipv4e_global_key : 23 ; /* bits 31:9 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_flow_label :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_orhr_ipv6e_l4_sp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_orhr_ipv6e_l4_dp : 11 ; /* bits 31:21 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_2_l4_dp : 15 ; /* bits 14:0 */
    ca_uint32_t cl_key_tre_l2rl2r_2_ev2_pt :  5 ; /* bits 19:15 */
    ca_uint32_t cl_key_tre_l2rl2r_2_tag_num :  2 ; /* bits 21:20 */
    ca_uint32_t cl_key_tre_l2rl2r_2_inner_802_1p :  3 ; /* bits 24:22 */
    ca_uint32_t cl_key_tre_l2rl2r_2_top_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_l2rl2r_2_inner_sc_ind :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_l2rl2r_2_inner_vid :  3 ; /* bits 31:29 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_2_l4_sp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_tre_l2rl3r_2_l4_dp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ev2_pt :  5 ; /* bits 25:21 */
    ca_uint32_t cl_key_tre_l2rl3r_2_tag_num :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_l2rl3r_2_inner_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_l2rl3r_2_top_802_1p :  1 ; /* bits 31:31 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_2_l4_sp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_tre_l2rcmr_2_l4_dp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ev2_pt :  5 ; /* bits 25:21 */
    ca_uint32_t cl_key_tre_l2rcmr_2_tag_num :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_l2rcmr_2_top_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_l2rcmr_2_top_sc_ind :  1 ; /* bits 31:31 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_2_l4_dp : 15 ; /* bits 14:0 */
    ca_uint32_t cl_key_tre_l3rl2r_2_ev2_pt :  5 ; /* bits 19:15 */
    ca_uint32_t cl_key_tre_l3rl2r_2_tag_num :  2 ; /* bits 21:20 */
    ca_uint32_t cl_key_tre_l3rl2r_2_inner_802_1p :  3 ; /* bits 24:22 */
    ca_uint32_t cl_key_tre_l3rl2r_2_top_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_l3rl2r_2_inner_sc_ind :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_l3rl2r_2_inner_vid :  3 ; /* bits 31:29 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_2_l4_sp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_tre_l3rl3r_2_l4_dp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ev2_pt :  5 ; /* bits 25:21 */
    ca_uint32_t cl_key_tre_l3rl3r_2_tag_num :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_l3rl3r_2_inner_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_l3rl3r_2_top_802_1p :  1 ; /* bits 31:31 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_2_l4_sp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_tre_l3rcmr_2_l4_dp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ev2_pt :  5 ; /* bits 25:21 */
    ca_uint32_t cl_key_tre_l3rcmr_2_tag_num :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_l3rcmr_2_top_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_l3rcmr_2_top_sc_ind :  1 ; /* bits 31:31 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_2_l4_dp : 15 ; /* bits 14:0 */
    ca_uint32_t cl_key_tre_cmrl2r_2_ev2_pt :  5 ; /* bits 19:15 */
    ca_uint32_t cl_key_tre_cmrl2r_2_tag_num :  2 ; /* bits 21:20 */
    ca_uint32_t cl_key_tre_cmrl2r_2_inner_802_1p :  3 ; /* bits 24:22 */
    ca_uint32_t cl_key_tre_cmrl2r_2_top_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_cmrl2r_2_inner_sc_ind :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_cmrl2r_2_inner_vid :  3 ; /* bits 31:29 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_2_l4_sp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_tre_cmrl3r_2_l4_dp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ev2_pt :  5 ; /* bits 25:21 */
    ca_uint32_t cl_key_tre_cmrl3r_2_tag_num :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_cmrl3r_2_inner_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_cmrl3r_2_top_802_1p :  1 ; /* bits 31:31 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_2_l4_sp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_tre_cmrcmr_2_l4_dp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ev2_pt :  5 ; /* bits 25:21 */
    ca_uint32_t cl_key_tre_cmrcmr_2_tag_num :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_cmrcmr_2_top_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_cmrcmr_2_top_sc_ind :  1 ; /* bits 31:31 */
  } bf10 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA1_t;


#define L2FE_CLE_IGR_KEY_DATA0                   0xf4301b44
#define L2FE_CLE_IGR_KEY_DATA0_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_orhr_ipv4e_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_orhr_ipv4e_mask : 22 ; /* bits 25:4 */
    ca_uint32_t cl_key_orhr_ipv4e_l7_ctrl :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_sp_ctrl :  2 ; /* bits 29:28 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_dp_ctrl :  2 ; /* bits 31:30 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_orhr_ipv6e_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_orhr_ipv6e_mask :  8 ; /* bits 11:4 */
    ca_uint32_t cl_key_orhr_ipv6e_l4_ctrl :  3 ; /* bits 14:12 */
    ca_uint32_t cl_key_orhr_ipv6e_ip_ctrl :  2 ; /* bits 16:15 */
    ca_uint32_t cl_key_orhr_ipv6e_flow_label : 15 ; /* bits 31:17 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l2rl2r_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_l2rl2r_2_mask :  2 ; /* bits 5:4 */
    ca_uint32_t cl_key_tre_l2rl2r_2_l4_ctrl :  3 ; /* bits 8:6 */
    ca_uint32_t cl_key_tre_l2rl2r_2_dot1p_ctrl :  2 ; /* bits 10:9 */
    ca_uint32_t cl_key_tre_l2rl2r_2_vid_ctrl :  2 ; /* bits 12:11 */
    ca_uint32_t cl_key_tre_l2rl2r_2_mac_ctrl :  2 ; /* bits 14:13 */
    ca_uint32_t cl_key_tre_l2rl2r_2_l4_sp : 16 ; /* bits 30:15 */
    ca_uint32_t cl_key_tre_l2rl2r_2_l4_dp :  1 ; /* bits 31:31 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l2rl3r_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_l2rl3r_2_mask :  8 ; /* bits 11:4 */
    ca_uint32_t cl_key_tre_l2rl3r_2_l4_ctrl :  3 ; /* bits 14:12 */
    ca_uint32_t cl_key_tre_l2rl3r_2_dot1p_ctrl :  2 ; /* bits 16:15 */
    ca_uint32_t cl_key_tre_l2rl3r_2_vid_ctrl :  2 ; /* bits 18:17 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ip_ctrl :  2 ; /* bits 20:19 */
    ca_uint32_t cl_key_tre_l2rl3r_2_l4_sp : 11 ; /* bits 31:21 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l2rcmr_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_l2rcmr_2_mask : 12 ; /* bits 15:4 */
    ca_uint32_t cl_key_tre_l2rcmr_2_l4_ctrl :  3 ; /* bits 18:16 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_addr_sel :  1 ; /* bits 19:19 */
    ca_uint32_t cl_key_tre_l2rcmr_2_mac_addr_sel :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l2rcmr_2_l4_sp : 11 ; /* bits 31:21 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l3rl2r_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_l3rl2r_2_mask :  2 ; /* bits 5:4 */
    ca_uint32_t cl_key_tre_l3rl2r_2_l4_ctrl :  3 ; /* bits 8:6 */
    ca_uint32_t cl_key_tre_l3rl2r_2_dot1p_ctrl :  2 ; /* bits 10:9 */
    ca_uint32_t cl_key_tre_l3rl2r_2_vid_ctrl :  2 ; /* bits 12:11 */
    ca_uint32_t cl_key_tre_l3rl2r_2_mac_ctrl :  2 ; /* bits 14:13 */
    ca_uint32_t cl_key_tre_l3rl2r_2_l4_sp : 16 ; /* bits 30:15 */
    ca_uint32_t cl_key_tre_l3rl2r_2_l4_dp :  1 ; /* bits 31:31 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l3rl3r_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_l3rl3r_2_mask :  8 ; /* bits 11:4 */
    ca_uint32_t cl_key_tre_l3rl3r_2_l4_ctrl :  3 ; /* bits 14:12 */
    ca_uint32_t cl_key_tre_l3rl3r_2_dot1p_ctrl :  2 ; /* bits 16:15 */
    ca_uint32_t cl_key_tre_l3rl3r_2_vid_ctrl :  2 ; /* bits 18:17 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ip_ctrl :  2 ; /* bits 20:19 */
    ca_uint32_t cl_key_tre_l3rl3r_2_l4_sp : 11 ; /* bits 31:21 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l3rcmr_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_l3rcmr_2_mask : 12 ; /* bits 15:4 */
    ca_uint32_t cl_key_tre_l3rcmr_2_l4_ctrl :  3 ; /* bits 18:16 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_addr_sel :  1 ; /* bits 19:19 */
    ca_uint32_t cl_key_tre_l3rcmr_2_mac_addr_sel :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l3rcmr_2_l4_sp : 11 ; /* bits 31:21 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_cmrl2r_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_cmrl2r_2_mask :  2 ; /* bits 5:4 */
    ca_uint32_t cl_key_tre_cmrl2r_2_l4_ctrl :  3 ; /* bits 8:6 */
    ca_uint32_t cl_key_tre_cmrl2r_2_dot1p_ctrl :  2 ; /* bits 10:9 */
    ca_uint32_t cl_key_tre_cmrl2r_2_vid_ctrl :  2 ; /* bits 12:11 */
    ca_uint32_t cl_key_tre_cmrl2r_2_mac_ctrl :  2 ; /* bits 14:13 */
    ca_uint32_t cl_key_tre_cmrl2r_2_l4_sp : 16 ; /* bits 30:15 */
    ca_uint32_t cl_key_tre_cmrl2r_2_l4_dp :  1 ; /* bits 31:31 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_cmrl3r_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_cmrl3r_2_mask :  8 ; /* bits 11:4 */
    ca_uint32_t cl_key_tre_cmrl3r_2_l4_ctrl :  3 ; /* bits 14:12 */
    ca_uint32_t cl_key_tre_cmrl3r_2_dot1p_ctrl :  2 ; /* bits 16:15 */
    ca_uint32_t cl_key_tre_cmrl3r_2_vid_ctrl :  2 ; /* bits 18:17 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ip_ctrl :  2 ; /* bits 20:19 */
    ca_uint32_t cl_key_tre_cmrl3r_2_l4_sp : 11 ; /* bits 31:21 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_cmrcmr_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_cmrcmr_2_mask : 12 ; /* bits 15:4 */
    ca_uint32_t cl_key_tre_cmrcmr_2_l4_ctrl :  3 ; /* bits 18:16 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_addr_sel :  1 ; /* bits 19:19 */
    ca_uint32_t cl_key_tre_cmrcmr_2_mac_addr_sel :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_cmrcmr_2_l4_sp : 11 ; /* bits 31:21 */
  } bf10 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_KEY_DATA0_t;


#define L2FE_CLE_EGR_KEY_ACCESS                  0xf4301b48
#define L2FE_CLE_EGR_KEY_ACCESS_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_EGR_KEY_ACCESS_t;


#define L2FE_CLE_EGR_KEY_DATA12                  0xf4301b4c
#define L2FE_CLE_EGR_KEY_DATA12_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_entry_type    :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_valid         :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_EGR_KEY_DATA12_t;


#define L2FE_CLE_EGR_KEY_DATA11                  0xf4301b50
#define L2FE_CLE_EGR_KEY_DATA11_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_mac_da :  8 ; /* bits 7:0 */
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_ecn_mask :  1 ; /* bits 8:8 */
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_ecn :  2 ; /* bits 10:9 */
    ca_uint32_t cl_key_orhr_ipv4e_reserved : 19 ; /* bits 29:11 */
    ca_uint32_t cl_key_orhr_ipv6_valid :  1 ; /* bits 30:30 */
    ca_uint32_t cl_key_entry_type    :  1 ; /* bits 31:31 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_da : 27 ; /* bits 26:0 */
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_ecn_mask :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_ecn :  2 ; /* bits 29:28 */
    ca_uint32_t cl_key_tre_rule_hinge :  1 ; /* bits 30:30 */
    ca_uint32_t rsrvd1               :  1 ;
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_1_mac_da : 19 ; /* bits 18:0 */
    ca_uint32_t cl_key_tre_l2rl2r_1_reserved :  7 ; /* bits 25:19 */
    ca_uint32_t cl_key_tre_rule_type_1 :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_rule_type_0 :  2 ; /* bits 29:28 */
    ca_uint32_t rsrvd1               :  2 ;
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_1_mac_da : 19 ; /* bits 18:0 */
    ca_uint32_t cl_key_tre_l2rl3r_1_reserved :  7 ; /* bits 25:19 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_1_mac_da : 19 ; /* bits 18:0 */
    ca_uint32_t cl_key_tre_l2rcmr_1_reserved :  7 ; /* bits 25:19 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_da : 17 ; /* bits 16:0 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ecn_mask :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ecn :  2 ; /* bits 19:18 */
    ca_uint32_t cl_key_tre_l3rl2r_1_reserved :  6 ; /* bits 25:20 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_da : 17 ; /* bits 16:0 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ecn_mask :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ecn :  2 ; /* bits 19:18 */
    ca_uint32_t cl_key_tre_l3rl3r_1_reserved :  6 ; /* bits 25:20 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_da : 17 ; /* bits 16:0 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ecn_mask :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ecn :  2 ; /* bits 19:18 */
    ca_uint32_t cl_key_tre_l3rcmr_1_reserved :  6 ; /* bits 25:20 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_1_mac_addr : 17 ; /* bits 16:0 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ecn_mask :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ecn :  2 ; /* bits 19:18 */
    ca_uint32_t cl_key_tre_cmrl2r_1_reserved :  6 ; /* bits 25:20 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_1_mac_addr : 17 ; /* bits 16:0 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ecn_mask :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ecn :  2 ; /* bits 19:18 */
    ca_uint32_t cl_key_tre_cmrl3r_1_reserved :  6 ; /* bits 25:20 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_1_mac_addr : 17 ; /* bits 16:0 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ecn_mask :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ecn :  2 ; /* bits 19:18 */
    ca_uint32_t cl_key_tre_cmrcmr_1_reserved :  6 ; /* bits 25:20 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf10 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_EGR_KEY_DATA11_t;


#define L2FE_CLE_EGR_KEY_DATA10                  0xf4301b54
#define L2FE_CLE_EGR_KEY_DATA10_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_mac_da : 32 ; /* bits 31:0 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_da : 32 ; /* bits 31:0 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_1_mac_sa :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l2rl2r_1_mac_da : 29 ; /* bits 31:3 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_1_mac_sa :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l2rl3r_1_mac_da : 29 ; /* bits 31:3 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_1_mac_sa :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l2rcmr_1_mac_da : 29 ; /* bits 31:3 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_sa : 17 ; /* bits 16:0 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_da : 15 ; /* bits 31:17 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_sa : 17 ; /* bits 16:0 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_da : 15 ; /* bits 31:17 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_sa : 17 ; /* bits 16:0 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_da : 15 ; /* bits 31:17 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_addr :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrl2r_1_mac_addr : 31 ; /* bits 31:1 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_addr :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrl3r_1_mac_addr : 31 ; /* bits 31:1 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_addr :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrcmr_1_mac_addr : 31 ; /* bits 31:1 */
  } bf10 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_EGR_KEY_DATA10_t;


#define L2FE_CLE_EGR_KEY_DATA9                   0xf4301b58
#define L2FE_CLE_EGR_KEY_DATA9_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_mac_sa : 24 ; /* bits 23:0 */
    ca_uint32_t cl_key_orhr_ipv4e_mac_da :  8 ; /* bits 31:24 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_da : 32 ; /* bits 31:0 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_1_mac_sa : 32 ; /* bits 31:0 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_1_mac_sa : 32 ; /* bits 31:0 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_1_mac_sa : 32 ; /* bits 31:0 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_flags :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_fragment :  1 ; /* bits 1:1 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_option :  1 ; /* bits 2:2 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ip_tos :  6 ; /* bits 8:3 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ip_pt :  8 ; /* bits 16:9 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ipv4_sa : 15 ; /* bits 31:17 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_flags :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_fragment :  1 ; /* bits 1:1 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_option :  1 ; /* bits 2:2 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ip_tos :  6 ; /* bits 8:3 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ip_pt :  8 ; /* bits 16:9 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ipv4_sa : 15 ; /* bits 31:17 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_flags :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_fragment :  1 ; /* bits 1:1 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_option :  1 ; /* bits 2:2 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ip_tos :  6 ; /* bits 8:3 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ip_pt :  8 ; /* bits 16:9 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ipv4_sa : 15 ; /* bits 31:17 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_1_ip_pt :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_addr : 31 ; /* bits 31:1 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_1_ip_pt :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_addr : 31 ; /* bits 31:1 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_1_ip_pt :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_addr : 31 ; /* bits 31:1 */
  } bf10 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_EGR_KEY_DATA9_t;


#define L2FE_CLE_EGR_KEY_DATA8                   0xf4301b5c
#define L2FE_CLE_EGR_KEY_DATA8_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_top_vid :  8 ; /* bits 7:0 */
    ca_uint32_t cl_key_orhr_ipv4e_mac_sa : 24 ; /* bits 31:8 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_da : 32 ; /* bits 31:0 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_1_inner_vid :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_l2rl2r_1_top_sc_ind :  1 ; /* bits 6:6 */
    ca_uint32_t cl_key_tre_l2rl2r_1_top_vid : 12 ; /* bits 18:7 */
    ca_uint32_t cl_key_tre_l2rl2r_1_mac_sa : 13 ; /* bits 31:19 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_1_inner_vid :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_l2rl3r_1_top_sc_ind :  1 ; /* bits 6:6 */
    ca_uint32_t cl_key_tre_l2rl3r_1_top_vid : 12 ; /* bits 18:7 */
    ca_uint32_t cl_key_tre_l2rl3r_1_mac_sa : 13 ; /* bits 31:19 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_1_inner_vid :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_l2rcmr_1_top_sc_ind :  1 ; /* bits 6:6 */
    ca_uint32_t cl_key_tre_l2rcmr_1_top_vid : 12 ; /* bits 18:7 */
    ca_uint32_t cl_key_tre_l2rcmr_1_mac_sa : 13 ; /* bits 31:19 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_1_inner_vid : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_l3rl2r_1_top_sc_ind :  1 ; /* bits 12:12 */
    ca_uint32_t cl_key_tre_l3rl2r_1_top_vid : 12 ; /* bits 24:13 */
    ca_uint32_t cl_key_tre_l3rl2r_1_special_pkt_code :  5 ; /* bits 29:25 */
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_flags :  2 ; /* bits 31:30 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_1_inner_vid : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_l3rl3r_1_top_sc_ind :  1 ; /* bits 12:12 */
    ca_uint32_t cl_key_tre_l3rl3r_1_top_vid : 12 ; /* bits 24:13 */
    ca_uint32_t cl_key_tre_l3rl3r_1_special_pkt_code :  5 ; /* bits 29:25 */
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_flags :  2 ; /* bits 31:30 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_1_inner_vid : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_l3rcmr_1_top_sc_ind :  1 ; /* bits 12:12 */
    ca_uint32_t cl_key_tre_l3rcmr_1_top_vid : 12 ; /* bits 24:13 */
    ca_uint32_t cl_key_tre_l3rcmr_1_special_pkt_code :  5 ; /* bits 29:25 */
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_flags :  2 ; /* bits 31:30 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_1_top_vid :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_tre_cmrl2r_1_special_pkt_code :  5 ; /* bits 13:9 */
    ca_uint32_t cl_key_tre_cmrl2r_1_l4_flags :  3 ; /* bits 16:14 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_fragment :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_option :  1 ; /* bits 18:18 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ip_tos :  6 ; /* bits 24:19 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ip_pt :  7 ; /* bits 31:25 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_1_top_vid :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_tre_cmrl3r_1_special_pkt_code :  5 ; /* bits 13:9 */
    ca_uint32_t cl_key_tre_cmrl3r_1_l4_flags :  3 ; /* bits 16:14 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_fragment :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_option :  1 ; /* bits 18:18 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ip_tos :  6 ; /* bits 24:19 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ip_pt :  7 ; /* bits 31:25 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_1_top_vid :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_tre_cmrcmr_1_special_pkt_code :  5 ; /* bits 13:9 */
    ca_uint32_t cl_key_tre_cmrcmr_1_l4_flags :  3 ; /* bits 16:14 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_fragment :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_option :  1 ; /* bits 18:18 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ip_tos :  6 ; /* bits 24:19 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ip_pt :  7 ; /* bits 31:25 */
  } bf10 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_EGR_KEY_DATA8_t;


#define L2FE_CLE_EGR_KEY_DATA7                   0xf4301b60
#define L2FE_CLE_EGR_KEY_DATA7_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_da :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_orhr_ipv4e_ev2_pt :  5 ; /* bits 5:1 */
    ca_uint32_t cl_key_orhr_ipv4e_tag_num :  2 ; /* bits 7:6 */
    ca_uint32_t cl_key_orhr_ipv4e_inner_802_1p :  3 ; /* bits 10:8 */
    ca_uint32_t cl_key_orhr_ipv4e_top_802_1p :  3 ; /* bits 13:11 */
    ca_uint32_t cl_key_orhr_ipv4e_inner_sc_ind :  1 ; /* bits 14:14 */
    ca_uint32_t cl_key_orhr_ipv4e_inner_vid : 12 ; /* bits 26:15 */
    ca_uint32_t cl_key_orhr_ipv4e_top_sc_ind :  1 ; /* bits 27:27 */
    ca_uint32_t cl_key_orhr_ipv4e_top_vid :  4 ; /* bits 31:28 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa : 27 ; /* bits 26:0 */
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_da :  5 ; /* bits 31:27 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_1_l4_dp : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_l2rl2r_1_ev2_pt :  5 ; /* bits 16:12 */
    ca_uint32_t cl_key_tre_l2rl2r_1_tag_num :  2 ; /* bits 18:17 */
    ca_uint32_t cl_key_tre_l2rl2r_1_inner_802_1p :  3 ; /* bits 21:19 */
    ca_uint32_t cl_key_tre_l2rl2r_1_top_802_1p :  3 ; /* bits 24:22 */
    ca_uint32_t cl_key_tre_l2rl2r_1_inner_sc_ind :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_l2rl2r_1_inner_vid :  6 ; /* bits 31:26 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_1_l4_dp : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_l2rl3r_1_ev2_pt :  5 ; /* bits 16:12 */
    ca_uint32_t cl_key_tre_l2rl3r_1_tag_num :  2 ; /* bits 18:17 */
    ca_uint32_t cl_key_tre_l2rl3r_1_inner_802_1p :  3 ; /* bits 21:19 */
    ca_uint32_t cl_key_tre_l2rl3r_1_top_802_1p :  3 ; /* bits 24:22 */
    ca_uint32_t cl_key_tre_l2rl3r_1_inner_sc_ind :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_l2rl3r_1_inner_vid :  6 ; /* bits 31:26 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_1_l4_dp : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_l2rcmr_1_ev2_pt :  5 ; /* bits 16:12 */
    ca_uint32_t cl_key_tre_l2rcmr_1_tag_num :  2 ; /* bits 18:17 */
    ca_uint32_t cl_key_tre_l2rcmr_1_inner_802_1p :  3 ; /* bits 21:19 */
    ca_uint32_t cl_key_tre_l2rcmr_1_top_802_1p :  3 ; /* bits 24:22 */
    ca_uint32_t cl_key_tre_l2rcmr_1_inner_sc_ind :  1 ; /* bits 25:25 */
    ca_uint32_t cl_key_tre_l2rcmr_1_inner_vid :  6 ; /* bits 31:26 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_sp :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_dp : 16 ; /* bits 17:2 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ev2_pt :  5 ; /* bits 22:18 */
    ca_uint32_t cl_key_tre_l3rl2r_1_tag_num :  2 ; /* bits 24:23 */
    ca_uint32_t cl_key_tre_l3rl2r_1_inner_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_l3rl2r_1_top_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_l3rl2r_1_inner_sc_ind :  1 ; /* bits 31:31 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_sp :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_dp : 16 ; /* bits 17:2 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ev2_pt :  5 ; /* bits 22:18 */
    ca_uint32_t cl_key_tre_l3rl3r_1_tag_num :  2 ; /* bits 24:23 */
    ca_uint32_t cl_key_tre_l3rl3r_1_inner_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_l3rl3r_1_top_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_l3rl3r_1_inner_sc_ind :  1 ; /* bits 31:31 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_sp :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_dp : 16 ; /* bits 17:2 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ev2_pt :  5 ; /* bits 22:18 */
    ca_uint32_t cl_key_tre_l3rcmr_1_tag_num :  2 ; /* bits 24:23 */
    ca_uint32_t cl_key_tre_l3rcmr_1_inner_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_l3rcmr_1_top_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_l3rcmr_1_inner_sc_ind :  1 ; /* bits 31:31 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_1_l4_sp :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_cmrl2r_1_l4_dp : 16 ; /* bits 17:2 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ev2_pt :  5 ; /* bits 22:18 */
    ca_uint32_t cl_key_tre_cmrl2r_1_tag_num :  2 ; /* bits 24:23 */
    ca_uint32_t cl_key_tre_cmrl2r_1_top_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_cmrl2r_1_top_sc_ind :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_cmrl2r_1_top_vid :  3 ; /* bits 31:29 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_1_l4_sp :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_cmrl3r_1_l4_dp : 16 ; /* bits 17:2 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ev2_pt :  5 ; /* bits 22:18 */
    ca_uint32_t cl_key_tre_cmrl3r_1_tag_num :  2 ; /* bits 24:23 */
    ca_uint32_t cl_key_tre_cmrl3r_1_top_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_cmrl3r_1_top_sc_ind :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_cmrl3r_1_top_vid :  3 ; /* bits 31:29 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_1_l4_sp :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_cmrcmr_1_l4_dp : 16 ; /* bits 17:2 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ev2_pt :  5 ; /* bits 22:18 */
    ca_uint32_t cl_key_tre_cmrcmr_1_tag_num :  2 ; /* bits 24:23 */
    ca_uint32_t cl_key_tre_cmrcmr_1_top_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_cmrcmr_1_top_sc_ind :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_cmrcmr_1_top_vid :  3 ; /* bits 31:29 */
  } bf10 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_EGR_KEY_DATA7_t;


#define L2FE_CLE_EGR_KEY_DATA6                   0xf4301b64
#define L2FE_CLE_EGR_KEY_DATA6_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_sa :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_da : 31 ; /* bits 31:1 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa : 32 ; /* bits 31:0 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_1_fields_operator :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l2rl2r_1_mask :  2 ; /* bits 2:1 */
    ca_uint32_t cl_key_tre_l2rl2r_1_l4_ctrl :  3 ; /* bits 5:3 */
    ca_uint32_t cl_key_tre_l2rl2r_1_dot1p_ctrl :  2 ; /* bits 7:6 */
    ca_uint32_t cl_key_tre_l2rl2r_1_vid_ctrl :  2 ; /* bits 9:8 */
    ca_uint32_t cl_key_tre_l2rl2r_1_mac_ctrl :  2 ; /* bits 11:10 */
    ca_uint32_t cl_key_tre_l2rl2r_1_l4_sp : 16 ; /* bits 27:12 */
    ca_uint32_t cl_key_tre_l2rl2r_1_l4_dp :  4 ; /* bits 31:28 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_1_fields_operator :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l2rl3r_1_mask :  2 ; /* bits 2:1 */
    ca_uint32_t cl_key_tre_l2rl3r_1_l4_ctrl :  3 ; /* bits 5:3 */
    ca_uint32_t cl_key_tre_l2rl3r_1_dot1p_ctrl :  2 ; /* bits 7:6 */
    ca_uint32_t cl_key_tre_l2rl3r_1_vid_ctrl :  2 ; /* bits 9:8 */
    ca_uint32_t cl_key_tre_l2rl3r_1_mac_ctrl :  2 ; /* bits 11:10 */
    ca_uint32_t cl_key_tre_l2rl3r_1_l4_sp : 16 ; /* bits 27:12 */
    ca_uint32_t cl_key_tre_l2rl3r_1_l4_dp :  4 ; /* bits 31:28 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_1_fields_operator :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l2rcmr_1_mask :  2 ; /* bits 2:1 */
    ca_uint32_t cl_key_tre_l2rcmr_1_l4_ctrl :  3 ; /* bits 5:3 */
    ca_uint32_t cl_key_tre_l2rcmr_1_dot1p_ctrl :  2 ; /* bits 7:6 */
    ca_uint32_t cl_key_tre_l2rcmr_1_vid_ctrl :  2 ; /* bits 9:8 */
    ca_uint32_t cl_key_tre_l2rcmr_1_mac_ctrl :  2 ; /* bits 11:10 */
    ca_uint32_t cl_key_tre_l2rcmr_1_l4_sp : 16 ; /* bits 27:12 */
    ca_uint32_t cl_key_tre_l2rcmr_1_l4_dp :  4 ; /* bits 31:28 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_1_fields_operator :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l3rl2r_1_mask :  8 ; /* bits 8:1 */
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_ctrl :  3 ; /* bits 11:9 */
    ca_uint32_t cl_key_tre_l3rl2r_1_dot1p_ctrl :  2 ; /* bits 13:12 */
    ca_uint32_t cl_key_tre_l3rl2r_1_vid_ctrl :  2 ; /* bits 15:14 */
    ca_uint32_t cl_key_tre_l3rl2r_1_ip_ctrl :  2 ; /* bits 17:16 */
    ca_uint32_t cl_key_tre_l3rl2r_1_l4_sp : 14 ; /* bits 31:18 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_1_fields_operator :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l3rl3r_1_mask :  8 ; /* bits 8:1 */
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_ctrl :  3 ; /* bits 11:9 */
    ca_uint32_t cl_key_tre_l3rl3r_1_dot1p_ctrl :  2 ; /* bits 13:12 */
    ca_uint32_t cl_key_tre_l3rl3r_1_vid_ctrl :  2 ; /* bits 15:14 */
    ca_uint32_t cl_key_tre_l3rl3r_1_ip_ctrl :  2 ; /* bits 17:16 */
    ca_uint32_t cl_key_tre_l3rl3r_1_l4_sp : 14 ; /* bits 31:18 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_1_fields_operator :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l3rcmr_1_mask :  8 ; /* bits 8:1 */
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_ctrl :  3 ; /* bits 11:9 */
    ca_uint32_t cl_key_tre_l3rcmr_1_dot1p_ctrl :  2 ; /* bits 13:12 */
    ca_uint32_t cl_key_tre_l3rcmr_1_vid_ctrl :  2 ; /* bits 15:14 */
    ca_uint32_t cl_key_tre_l3rcmr_1_ip_ctrl :  2 ; /* bits 17:16 */
    ca_uint32_t cl_key_tre_l3rcmr_1_l4_sp : 14 ; /* bits 31:18 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_1_fields_operator :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrl2r_1_mask : 12 ; /* bits 12:1 */
    ca_uint32_t cl_key_tre_cmrl2r_1_l4_ctrl :  3 ; /* bits 15:13 */
    ca_uint32_t cl_key_tre_cmrl2r_1_ipv4_addr_sel :  1 ; /* bits 16:16 */
    ca_uint32_t cl_key_tre_cmrl2r_1_mac_addr_sel :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_cmrl2r_1_l4_sp : 14 ; /* bits 31:18 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_1_fields_operator :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrl3r_1_mask : 12 ; /* bits 12:1 */
    ca_uint32_t cl_key_tre_cmrl3r_1_l4_ctrl :  3 ; /* bits 15:13 */
    ca_uint32_t cl_key_tre_cmrl3r_1_ipv4_addr_sel :  1 ; /* bits 16:16 */
    ca_uint32_t cl_key_tre_cmrl3r_1_mac_addr_sel :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_cmrl3r_1_l4_sp : 14 ; /* bits 31:18 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_1_fields_operator :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrcmr_1_mask : 12 ; /* bits 12:1 */
    ca_uint32_t cl_key_tre_cmrcmr_1_l4_ctrl :  3 ; /* bits 15:13 */
    ca_uint32_t cl_key_tre_cmrcmr_1_ipv4_addr_sel :  1 ; /* bits 16:16 */
    ca_uint32_t cl_key_tre_cmrcmr_1_mac_addr_sel :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_tre_cmrcmr_1_l4_sp : 14 ; /* bits 31:18 */
  } bf10 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_EGR_KEY_DATA6_t;


#define L2FE_CLE_EGR_KEY_DATA5                   0xf4301b68
#define L2FE_CLE_EGR_KEY_DATA5_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_ip_pt :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_sa : 31 ; /* bits 31:1 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa : 32 ; /* bits 31:0 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_2_mac_da : 22 ; /* bits 21:0 */
    ca_uint32_t cl_key_tre_l2rl2r_2_reserved :  7 ; /* bits 28:22 */
    ca_uint32_t cl_key_tre_l2rl2r_1_prcd :  3 ; /* bits 31:29 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_da : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ecn_mask :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ecn :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_l2rl3r_2_reserved :  6 ; /* bits 28:23 */
    ca_uint32_t cl_key_tre_l2rl3r_1_prcd :  3 ; /* bits 31:29 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_2_mac_addr : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ecn_mask :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ecn :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_l2rcmr_2_reserved :  6 ; /* bits 28:23 */
    ca_uint32_t cl_key_tre_l2rcmr_1_prcd :  3 ; /* bits 31:29 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_2_mac_da : 22 ; /* bits 21:0 */
    ca_uint32_t cl_key_tre_l3rl2r_2_reserved :  7 ; /* bits 28:22 */
    ca_uint32_t cl_key_tre_l3rl2r_1_prcd :  3 ; /* bits 31:29 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_da : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ecn_mask :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ecn :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_l3rl3r_2_reserved :  6 ; /* bits 28:23 */
    ca_uint32_t cl_key_tre_l3rl3r_1_prcd :  3 ; /* bits 31:29 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_2_mac_addr : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ecn_mask :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ecn :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_l3rcmr_2_reserved :  6 ; /* bits 28:23 */
    ca_uint32_t cl_key_tre_l3rcmr_1_prcd :  3 ; /* bits 31:29 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_2_mac_da : 22 ; /* bits 21:0 */
    ca_uint32_t cl_key_tre_cmrl2r_2_reserved :  7 ; /* bits 28:22 */
    ca_uint32_t cl_key_tre_cmrl2r_1_prcd :  3 ; /* bits 31:29 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_da : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ecn_mask :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ecn :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_cmrl3r_2_reserved :  6 ; /* bits 28:23 */
    ca_uint32_t cl_key_tre_cmrl3r_1_prcd :  3 ; /* bits 31:29 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_2_mac_addr : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ecn_mask :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ecn :  2 ; /* bits 22:21 */
    ca_uint32_t cl_key_tre_cmrcmr_2_reserved :  6 ; /* bits 28:23 */
    ca_uint32_t cl_key_tre_cmrcmr_1_prcd :  3 ; /* bits 31:29 */
  } bf10 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_EGR_KEY_DATA5_t;


#define L2FE_CLE_EGR_KEY_DATA4                   0xf4301b6c
#define L2FE_CLE_EGR_KEY_DATA4_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_l4_dp_low :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_dp_high : 16 ; /* bits 16:1 */
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_fragment :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_orhr_ipv4e_ipv4_option :  1 ; /* bits 18:18 */
    ca_uint32_t cl_key_orhr_ipv4e_ip_tos :  6 ; /* bits 24:19 */
    ca_uint32_t cl_key_orhr_ipv4e_ip_pt :  7 ; /* bits 31:25 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa : 32 ; /* bits 31:0 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_2_mac_sa :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_l2rl2r_2_mac_da : 26 ; /* bits 31:6 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_sa : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_da : 12 ; /* bits 31:20 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_addr :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_l2rcmr_2_mac_addr : 28 ; /* bits 31:4 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_2_mac_sa :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_l3rl2r_2_mac_da : 26 ; /* bits 31:6 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_sa : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_da : 12 ; /* bits 31:20 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_addr :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_l3rcmr_2_mac_addr : 28 ; /* bits 31:4 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_2_mac_sa :  6 ; /* bits 5:0 */
    ca_uint32_t cl_key_tre_cmrl2r_2_mac_da : 26 ; /* bits 31:6 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_sa : 20 ; /* bits 19:0 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_da : 12 ; /* bits 31:20 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_addr :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_cmrcmr_2_mac_addr : 28 ; /* bits 31:4 */
  } bf10 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_EGR_KEY_DATA4_t;


#define L2FE_CLE_EGR_KEY_DATA3                   0xf4301b70
#define L2FE_CLE_EGR_KEY_DATA3_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_l4_sp_low :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_sp_high : 16 ; /* bits 16:1 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_dp_low : 15 ; /* bits 31:17 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_ip_tos :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_orhr_ipv6e_ip_pt :  8 ; /* bits 12:5 */
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_mask : 14 ; /* bits 26:13 */
    ca_uint32_t cl_key_orhr_ipv6e_ipv6_sa :  5 ; /* bits 31:27 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_2_mac_sa : 32 ; /* bits 31:0 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_2_special_pkt_code :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l2rl3r_2_l4_flags :  3 ; /* bits 3:1 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_fragment :  1 ; /* bits 4:4 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_option :  1 ; /* bits 5:5 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ip_tos :  6 ; /* bits 11:6 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ip_pt :  8 ; /* bits 19:12 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ipv4_sa : 12 ; /* bits 31:20 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_2_ip_pt :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_addr : 28 ; /* bits 31:4 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_2_mac_sa : 32 ; /* bits 31:0 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_2_special_pkt_code :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_l3rl3r_2_l4_flags :  3 ; /* bits 3:1 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_fragment :  1 ; /* bits 4:4 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_option :  1 ; /* bits 5:5 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ip_tos :  6 ; /* bits 11:6 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ip_pt :  8 ; /* bits 19:12 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ipv4_sa : 12 ; /* bits 31:20 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_2_ip_pt :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_addr : 28 ; /* bits 31:4 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_2_mac_sa : 32 ; /* bits 31:0 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_2_special_pkt_code :  1 ; /* bits 0:0 */
    ca_uint32_t cl_key_tre_cmrl3r_2_l4_flags :  3 ; /* bits 3:1 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_fragment :  1 ; /* bits 4:4 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_option :  1 ; /* bits 5:5 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ip_tos :  6 ; /* bits 11:6 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ip_pt :  8 ; /* bits 19:12 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ipv4_sa : 12 ; /* bits 31:20 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_2_ip_pt :  4 ; /* bits 3:0 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_addr : 28 ; /* bits 31:4 */
  } bf10 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_EGR_KEY_DATA3_t;


#define L2FE_CLE_EGR_KEY_DATA2                   0xf4301b74
#define L2FE_CLE_EGR_KEY_DATA2_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_global_key :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_orhr_ipv4e_special_pkt_code :  5 ; /* bits 13:9 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_flags :  3 ; /* bits 16:14 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_sp_low : 15 ; /* bits 31:17 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_l4_dp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_orhr_ipv6e_tag_num :  2 ; /* bits 6:5 */
    ca_uint32_t cl_key_orhr_ipv6e_top_802_1p :  3 ; /* bits 9:7 */
    ca_uint32_t cl_key_orhr_ipv6e_top_sc_ind :  1 ; /* bits 10:10 */
    ca_uint32_t cl_key_orhr_ipv6e_top_vid : 12 ; /* bits 22:11 */
    ca_uint32_t cl_key_orhr_ipv6e_special_pkt_code :  5 ; /* bits 27:23 */
    ca_uint32_t cl_key_orhr_ipv6e_l4_flags :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_orhr_ipv6e_ip_tos :  1 ; /* bits 31:31 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_2_inner_vid :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_tre_l2rl2r_2_top_sc_ind :  1 ; /* bits 9:9 */
    ca_uint32_t cl_key_tre_l2rl2r_2_top_vid : 12 ; /* bits 21:10 */
    ca_uint32_t cl_key_tre_l2rl2r_2_mac_sa : 10 ; /* bits 31:22 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_2_top_802_1p :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l2rl3r_2_inner_sc_ind :  1 ; /* bits 2:2 */
    ca_uint32_t cl_key_tre_l2rl3r_2_inner_vid : 12 ; /* bits 14:3 */
    ca_uint32_t cl_key_tre_l2rl3r_2_top_sc_ind :  1 ; /* bits 15:15 */
    ca_uint32_t cl_key_tre_l2rl3r_2_top_vid : 12 ; /* bits 27:16 */
    ca_uint32_t cl_key_tre_l2rl3r_2_special_pkt_code :  4 ; /* bits 31:28 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_2_top_vid : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_l2rcmr_2_special_pkt_code :  5 ; /* bits 16:12 */
    ca_uint32_t cl_key_tre_l2rcmr_2_l4_flags :  3 ; /* bits 19:17 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_fragment :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_option :  1 ; /* bits 21:21 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ip_tos :  6 ; /* bits 27:22 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ip_pt :  4 ; /* bits 31:28 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_2_inner_vid :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_tre_l3rl2r_2_top_sc_ind :  1 ; /* bits 9:9 */
    ca_uint32_t cl_key_tre_l3rl2r_2_top_vid : 12 ; /* bits 21:10 */
    ca_uint32_t cl_key_tre_l3rl2r_2_mac_sa : 10 ; /* bits 31:22 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_2_top_802_1p :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_l3rl3r_2_inner_sc_ind :  1 ; /* bits 2:2 */
    ca_uint32_t cl_key_tre_l3rl3r_2_inner_vid : 12 ; /* bits 14:3 */
    ca_uint32_t cl_key_tre_l3rl3r_2_top_sc_ind :  1 ; /* bits 15:15 */
    ca_uint32_t cl_key_tre_l3rl3r_2_top_vid : 12 ; /* bits 27:16 */
    ca_uint32_t cl_key_tre_l3rl3r_2_special_pkt_code :  4 ; /* bits 31:28 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_2_top_vid : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_l3rcmr_2_special_pkt_code :  5 ; /* bits 16:12 */
    ca_uint32_t cl_key_tre_l3rcmr_2_l4_flags :  3 ; /* bits 19:17 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_fragment :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_option :  1 ; /* bits 21:21 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ip_tos :  6 ; /* bits 27:22 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ip_pt :  4 ; /* bits 31:28 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_2_inner_vid :  9 ; /* bits 8:0 */
    ca_uint32_t cl_key_tre_cmrl2r_2_top_sc_ind :  1 ; /* bits 9:9 */
    ca_uint32_t cl_key_tre_cmrl2r_2_top_vid : 12 ; /* bits 21:10 */
    ca_uint32_t cl_key_tre_cmrl2r_2_mac_sa : 10 ; /* bits 31:22 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_2_top_802_1p :  2 ; /* bits 1:0 */
    ca_uint32_t cl_key_tre_cmrl3r_2_inner_sc_ind :  1 ; /* bits 2:2 */
    ca_uint32_t cl_key_tre_cmrl3r_2_inner_vid : 12 ; /* bits 14:3 */
    ca_uint32_t cl_key_tre_cmrl3r_2_top_sc_ind :  1 ; /* bits 15:15 */
    ca_uint32_t cl_key_tre_cmrl3r_2_top_vid : 12 ; /* bits 27:16 */
    ca_uint32_t cl_key_tre_cmrl3r_2_special_pkt_code :  4 ; /* bits 31:28 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_2_top_vid : 12 ; /* bits 11:0 */
    ca_uint32_t cl_key_tre_cmrcmr_2_special_pkt_code :  5 ; /* bits 16:12 */
    ca_uint32_t cl_key_tre_cmrcmr_2_l4_flags :  3 ; /* bits 19:17 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_fragment :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_option :  1 ; /* bits 21:21 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ip_tos :  6 ; /* bits 27:22 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ip_pt :  4 ; /* bits 31:28 */
  } bf10 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_EGR_KEY_DATA2_t;


#define L2FE_CLE_EGR_KEY_DATA1                   0xf4301b78
#define L2FE_CLE_EGR_KEY_DATA1_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_ip_ctrl :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_orhr_ipv4e_dot1p_ctrl :  2 ; /* bits 4:3 */
    ca_uint32_t cl_key_orhr_ipv4e_vid_ctrl :  2 ; /* bits 6:5 */
    ca_uint32_t cl_key_orhr_ipv4e_mac_ctrl :  2 ; /* bits 8:7 */
    ca_uint32_t cl_key_orhr_ipv4e_global_key : 23 ; /* bits 31:9 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_flow_label :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_orhr_ipv6e_l4_sp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_orhr_ipv6e_l4_dp : 11 ; /* bits 31:21 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_2_l4_dp : 15 ; /* bits 14:0 */
    ca_uint32_t cl_key_tre_l2rl2r_2_ev2_pt :  5 ; /* bits 19:15 */
    ca_uint32_t cl_key_tre_l2rl2r_2_tag_num :  2 ; /* bits 21:20 */
    ca_uint32_t cl_key_tre_l2rl2r_2_inner_802_1p :  3 ; /* bits 24:22 */
    ca_uint32_t cl_key_tre_l2rl2r_2_top_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_l2rl2r_2_inner_sc_ind :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_l2rl2r_2_inner_vid :  3 ; /* bits 31:29 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_2_l4_sp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_tre_l2rl3r_2_l4_dp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ev2_pt :  5 ; /* bits 25:21 */
    ca_uint32_t cl_key_tre_l2rl3r_2_tag_num :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_l2rl3r_2_inner_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_l2rl3r_2_top_802_1p :  1 ; /* bits 31:31 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_2_l4_sp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_tre_l2rcmr_2_l4_dp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ev2_pt :  5 ; /* bits 25:21 */
    ca_uint32_t cl_key_tre_l2rcmr_2_tag_num :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_l2rcmr_2_top_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_l2rcmr_2_top_sc_ind :  1 ; /* bits 31:31 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_2_l4_dp : 15 ; /* bits 14:0 */
    ca_uint32_t cl_key_tre_l3rl2r_2_ev2_pt :  5 ; /* bits 19:15 */
    ca_uint32_t cl_key_tre_l3rl2r_2_tag_num :  2 ; /* bits 21:20 */
    ca_uint32_t cl_key_tre_l3rl2r_2_inner_802_1p :  3 ; /* bits 24:22 */
    ca_uint32_t cl_key_tre_l3rl2r_2_top_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_l3rl2r_2_inner_sc_ind :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_l3rl2r_2_inner_vid :  3 ; /* bits 31:29 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_2_l4_sp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_tre_l3rl3r_2_l4_dp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ev2_pt :  5 ; /* bits 25:21 */
    ca_uint32_t cl_key_tre_l3rl3r_2_tag_num :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_l3rl3r_2_inner_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_l3rl3r_2_top_802_1p :  1 ; /* bits 31:31 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_2_l4_sp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_tre_l3rcmr_2_l4_dp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ev2_pt :  5 ; /* bits 25:21 */
    ca_uint32_t cl_key_tre_l3rcmr_2_tag_num :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_l3rcmr_2_top_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_l3rcmr_2_top_sc_ind :  1 ; /* bits 31:31 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_2_l4_dp : 15 ; /* bits 14:0 */
    ca_uint32_t cl_key_tre_cmrl2r_2_ev2_pt :  5 ; /* bits 19:15 */
    ca_uint32_t cl_key_tre_cmrl2r_2_tag_num :  2 ; /* bits 21:20 */
    ca_uint32_t cl_key_tre_cmrl2r_2_inner_802_1p :  3 ; /* bits 24:22 */
    ca_uint32_t cl_key_tre_cmrl2r_2_top_802_1p :  3 ; /* bits 27:25 */
    ca_uint32_t cl_key_tre_cmrl2r_2_inner_sc_ind :  1 ; /* bits 28:28 */
    ca_uint32_t cl_key_tre_cmrl2r_2_inner_vid :  3 ; /* bits 31:29 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_2_l4_sp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_tre_cmrl3r_2_l4_dp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ev2_pt :  5 ; /* bits 25:21 */
    ca_uint32_t cl_key_tre_cmrl3r_2_tag_num :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_cmrl3r_2_inner_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_cmrl3r_2_top_802_1p :  1 ; /* bits 31:31 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_2_l4_sp :  5 ; /* bits 4:0 */
    ca_uint32_t cl_key_tre_cmrcmr_2_l4_dp : 16 ; /* bits 20:5 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ev2_pt :  5 ; /* bits 25:21 */
    ca_uint32_t cl_key_tre_cmrcmr_2_tag_num :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_tre_cmrcmr_2_top_802_1p :  3 ; /* bits 30:28 */
    ca_uint32_t cl_key_tre_cmrcmr_2_top_sc_ind :  1 ; /* bits 31:31 */
  } bf10 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_EGR_KEY_DATA1_t;


#define L2FE_CLE_EGR_KEY_DATA0                   0xf4301b7c
#define L2FE_CLE_EGR_KEY_DATA0_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_key_orhr_ipv4e_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_orhr_ipv4e_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_orhr_ipv4e_mask : 22 ; /* bits 25:4 */
    ca_uint32_t cl_key_orhr_ipv4e_l7_ctrl :  2 ; /* bits 27:26 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_sp_ctrl :  2 ; /* bits 29:28 */
    ca_uint32_t cl_key_orhr_ipv4e_l4_dp_ctrl :  2 ; /* bits 31:30 */
  } bf0 ;
  struct {
    ca_uint32_t cl_key_orhr_ipv6e_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_orhr_ipv6e_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_orhr_ipv6e_mask :  8 ; /* bits 11:4 */
    ca_uint32_t cl_key_orhr_ipv6e_l4_ctrl :  3 ; /* bits 14:12 */
    ca_uint32_t cl_key_orhr_ipv6e_ip_ctrl :  2 ; /* bits 16:15 */
    ca_uint32_t cl_key_orhr_ipv6e_flow_label : 15 ; /* bits 31:17 */
  } bf1 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl2r_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l2rl2r_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_l2rl2r_2_mask :  2 ; /* bits 5:4 */
    ca_uint32_t cl_key_tre_l2rl2r_2_l4_ctrl :  3 ; /* bits 8:6 */
    ca_uint32_t cl_key_tre_l2rl2r_2_dot1p_ctrl :  2 ; /* bits 10:9 */
    ca_uint32_t cl_key_tre_l2rl2r_2_vid_ctrl :  2 ; /* bits 12:11 */
    ca_uint32_t cl_key_tre_l2rl2r_2_mac_ctrl :  2 ; /* bits 14:13 */
    ca_uint32_t cl_key_tre_l2rl2r_2_l4_sp : 16 ; /* bits 30:15 */
    ca_uint32_t cl_key_tre_l2rl2r_2_l4_dp :  1 ; /* bits 31:31 */
  } bf2 ;
  struct {
    ca_uint32_t cl_key_tre_l2rl3r_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l2rl3r_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_l2rl3r_2_mask :  8 ; /* bits 11:4 */
    ca_uint32_t cl_key_tre_l2rl3r_2_l4_ctrl :  3 ; /* bits 14:12 */
    ca_uint32_t cl_key_tre_l2rl3r_2_dot1p_ctrl :  2 ; /* bits 16:15 */
    ca_uint32_t cl_key_tre_l2rl3r_2_vid_ctrl :  2 ; /* bits 18:17 */
    ca_uint32_t cl_key_tre_l2rl3r_2_ip_ctrl :  2 ; /* bits 20:19 */
    ca_uint32_t cl_key_tre_l2rl3r_2_l4_sp : 11 ; /* bits 31:21 */
  } bf3 ;
  struct {
    ca_uint32_t cl_key_tre_l2rcmr_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l2rcmr_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_l2rcmr_2_mask : 12 ; /* bits 15:4 */
    ca_uint32_t cl_key_tre_l2rcmr_2_l4_ctrl :  3 ; /* bits 18:16 */
    ca_uint32_t cl_key_tre_l2rcmr_2_ipv4_addr_sel :  1 ; /* bits 19:19 */
    ca_uint32_t cl_key_tre_l2rcmr_2_mac_addr_sel :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l2rcmr_2_l4_sp : 11 ; /* bits 31:21 */
  } bf4 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl2r_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l3rl2r_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_l3rl2r_2_mask :  2 ; /* bits 5:4 */
    ca_uint32_t cl_key_tre_l3rl2r_2_l4_ctrl :  3 ; /* bits 8:6 */
    ca_uint32_t cl_key_tre_l3rl2r_2_dot1p_ctrl :  2 ; /* bits 10:9 */
    ca_uint32_t cl_key_tre_l3rl2r_2_vid_ctrl :  2 ; /* bits 12:11 */
    ca_uint32_t cl_key_tre_l3rl2r_2_mac_ctrl :  2 ; /* bits 14:13 */
    ca_uint32_t cl_key_tre_l3rl2r_2_l4_sp : 16 ; /* bits 30:15 */
    ca_uint32_t cl_key_tre_l3rl2r_2_l4_dp :  1 ; /* bits 31:31 */
  } bf5 ;
  struct {
    ca_uint32_t cl_key_tre_l3rl3r_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l3rl3r_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_l3rl3r_2_mask :  8 ; /* bits 11:4 */
    ca_uint32_t cl_key_tre_l3rl3r_2_l4_ctrl :  3 ; /* bits 14:12 */
    ca_uint32_t cl_key_tre_l3rl3r_2_dot1p_ctrl :  2 ; /* bits 16:15 */
    ca_uint32_t cl_key_tre_l3rl3r_2_vid_ctrl :  2 ; /* bits 18:17 */
    ca_uint32_t cl_key_tre_l3rl3r_2_ip_ctrl :  2 ; /* bits 20:19 */
    ca_uint32_t cl_key_tre_l3rl3r_2_l4_sp : 11 ; /* bits 31:21 */
  } bf6 ;
  struct {
    ca_uint32_t cl_key_tre_l3rcmr_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_l3rcmr_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_l3rcmr_2_mask : 12 ; /* bits 15:4 */
    ca_uint32_t cl_key_tre_l3rcmr_2_l4_ctrl :  3 ; /* bits 18:16 */
    ca_uint32_t cl_key_tre_l3rcmr_2_ipv4_addr_sel :  1 ; /* bits 19:19 */
    ca_uint32_t cl_key_tre_l3rcmr_2_mac_addr_sel :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_l3rcmr_2_l4_sp : 11 ; /* bits 31:21 */
  } bf7 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl2r_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_cmrl2r_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_cmrl2r_2_mask :  2 ; /* bits 5:4 */
    ca_uint32_t cl_key_tre_cmrl2r_2_l4_ctrl :  3 ; /* bits 8:6 */
    ca_uint32_t cl_key_tre_cmrl2r_2_dot1p_ctrl :  2 ; /* bits 10:9 */
    ca_uint32_t cl_key_tre_cmrl2r_2_vid_ctrl :  2 ; /* bits 12:11 */
    ca_uint32_t cl_key_tre_cmrl2r_2_mac_ctrl :  2 ; /* bits 14:13 */
    ca_uint32_t cl_key_tre_cmrl2r_2_l4_sp : 16 ; /* bits 30:15 */
    ca_uint32_t cl_key_tre_cmrl2r_2_l4_dp :  1 ; /* bits 31:31 */
  } bf8 ;
  struct {
    ca_uint32_t cl_key_tre_cmrl3r_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_cmrl3r_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_cmrl3r_2_mask :  8 ; /* bits 11:4 */
    ca_uint32_t cl_key_tre_cmrl3r_2_l4_ctrl :  3 ; /* bits 14:12 */
    ca_uint32_t cl_key_tre_cmrl3r_2_dot1p_ctrl :  2 ; /* bits 16:15 */
    ca_uint32_t cl_key_tre_cmrl3r_2_vid_ctrl :  2 ; /* bits 18:17 */
    ca_uint32_t cl_key_tre_cmrl3r_2_ip_ctrl :  2 ; /* bits 20:19 */
    ca_uint32_t cl_key_tre_cmrl3r_2_l4_sp : 11 ; /* bits 31:21 */
  } bf9 ;
  struct {
    ca_uint32_t cl_key_tre_cmrcmr_2_prcd :  3 ; /* bits 2:0 */
    ca_uint32_t cl_key_tre_cmrcmr_2_fields_operator :  1 ; /* bits 3:3 */
    ca_uint32_t cl_key_tre_cmrcmr_2_mask : 12 ; /* bits 15:4 */
    ca_uint32_t cl_key_tre_cmrcmr_2_l4_ctrl :  3 ; /* bits 18:16 */
    ca_uint32_t cl_key_tre_cmrcmr_2_ipv4_addr_sel :  1 ; /* bits 19:19 */
    ca_uint32_t cl_key_tre_cmrcmr_2_mac_addr_sel :  1 ; /* bits 20:20 */
    ca_uint32_t cl_key_tre_cmrcmr_2_l4_sp : 11 ; /* bits 31:21 */
  } bf10 ;
  ca_uint32_t     wrd ;
} L2FE_CLE_EGR_KEY_DATA0_t;


#define L2FE_CLE_IGR_FIB_ACCESS                  0xf4301b80
#define L2FE_CLE_IGR_FIB_ACCESS_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_FIB_ACCESS_t;


#define L2FE_CLE_IGR_FIB_DATA4                   0xf4301b84
#define L2FE_CLE_IGR_FIB_DATA4_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_fib_xr_inner_vid_0 :  3 ; /* bits 2:0 */
    ca_uint32_t cl_fib_xr_top_cmd_valid_0 :  1 ; /* bits 3:3 */
    ca_uint32_t cl_fib_xr_top_vlan_cmd_0 :  2 ; /* bits 5:4 */
    ca_uint32_t cl_fib_xr_top_sc_ind_0 :  1 ; /* bits 6:6 */
    ca_uint32_t cl_fib_xr_top_vid_0  : 12 ; /* bits 18:7 */
    ca_uint32_t cl_fib_xr_pkt_no_drop_0 :  1 ; /* bits 19:19 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_FIB_DATA4_t;


#define L2FE_CLE_IGR_FIB_DATA3                   0xf4301b88
#define L2FE_CLE_IGR_FIB_DATA3_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_fib_xr_ldpid_0    :  4 ; /* bits 3:0 */
    ca_uint32_t cl_fib_xr_cos_valid_0 :  1 ; /* bits 4:4 */
    ca_uint32_t cl_fib_xr_dscp_valid_0 :  1 ; /* bits 5:5 */
    ca_uint32_t cl_fib_xr_802_1p_valid_0 :  1 ; /* bits 6:6 */
    ca_uint32_t cl_fib_xr_cos_0      :  3 ; /* bits 9:7 */
    ca_uint32_t cl_fib_xr_dscp_0     :  6 ; /* bits 15:10 */
    ca_uint32_t cl_fib_xr_802_1p_0   :  3 ; /* bits 18:16 */
    ca_uint32_t cl_fib_xr_inner_cmd_valid_0 :  1 ; /* bits 19:19 */
    ca_uint32_t cl_fib_xr_inner_vlan_cmd_0 :  2 ; /* bits 21:20 */
    ca_uint32_t cl_fib_xr_inner_sc_ind_0 :  1 ; /* bits 22:22 */
    ca_uint32_t cl_fib_xr_inner_vid_0 :  9 ; /* bits 31:23 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_FIB_DATA3_t;


#define L2FE_CLE_IGR_FIB_DATA2                   0xf4301b8c
#define L2FE_CLE_IGR_FIB_DATA2_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_fib_xr_top_vid_1  :  9 ; /* bits 8:0 */
    ca_uint32_t cl_fib_xr_pkt_no_drop_1 :  1 ; /* bits 9:9 */
    ca_uint32_t cl_fib_xr_stp_mode_0 :  2 ; /* bits 11:10 */
    ca_uint32_t cl_fib_xr_permit_valid_0 :  1 ; /* bits 12:12 */
    ca_uint32_t cl_fib_xr_permit_0   :  1 ; /* bits 13:13 */
    ca_uint32_t cl_fib_xr_premarked_0 :  1 ; /* bits 14:14 */
    ca_uint32_t cl_fib_xr_dscp_markdown_0 :  1 ; /* bits 15:15 */
    ca_uint32_t cl_fib_xr_mark_en_0  :  1 ; /* bits 16:16 */
    ca_uint32_t cl_fib_xr_flowid_0   : 12 ; /* bits 28:17 */
    ca_uint32_t cl_fib_xr_dp_valid_0 :  1 ; /* bits 29:29 */
    ca_uint32_t cl_fib_xr_ldpid_0    :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_FIB_DATA2_t;


#define L2FE_CLE_IGR_FIB_DATA1                   0xf4301b90
#define L2FE_CLE_IGR_FIB_DATA1_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_fib_xr_dscp_1     :  6 ; /* bits 5:0 */
    ca_uint32_t cl_fib_xr_802_1p_1   :  3 ; /* bits 8:6 */
    ca_uint32_t cl_fib_xr_inner_cmd_valid_1 :  1 ; /* bits 9:9 */
    ca_uint32_t cl_fib_xr_inner_vlan_cmd_1 :  2 ; /* bits 11:10 */
    ca_uint32_t cl_fib_xr_inner_sc_ind_1 :  1 ; /* bits 12:12 */
    ca_uint32_t cl_fib_xr_inner_vid_1 : 12 ; /* bits 24:13 */
    ca_uint32_t cl_fib_xr_top_cmd_valid_1 :  1 ; /* bits 25:25 */
    ca_uint32_t cl_fib_xr_top_vlan_cmd_1 :  2 ; /* bits 27:26 */
    ca_uint32_t cl_fib_xr_top_sc_ind_1 :  1 ; /* bits 28:28 */
    ca_uint32_t cl_fib_xr_top_vid_1  :  3 ; /* bits 31:29 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_FIB_DATA1_t;


#define L2FE_CLE_IGR_FIB_DATA0                   0xf4301b94
#define L2FE_CLE_IGR_FIB_DATA0_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_fib_xr_stp_mode_1 :  2 ; /* bits 1:0 */
    ca_uint32_t cl_fib_xr_permit_valid_1 :  1 ; /* bits 2:2 */
    ca_uint32_t cl_fib_xr_permit_1   :  1 ; /* bits 3:3 */
    ca_uint32_t cl_fib_xr_premarked_1 :  1 ; /* bits 4:4 */
    ca_uint32_t cl_fib_xr_dscp_markdown_1 :  1 ; /* bits 5:5 */
    ca_uint32_t cl_fib_xr_mark_en_1  :  1 ; /* bits 6:6 */
    ca_uint32_t cl_fib_xr_flowid_1   : 12 ; /* bits 18:7 */
    ca_uint32_t cl_fib_xr_dp_valid_1 :  1 ; /* bits 19:19 */
    ca_uint32_t cl_fib_xr_ldpid_1    :  6 ; /* bits 25:20 */
    ca_uint32_t cl_fib_xr_cos_valid_1 :  1 ; /* bits 26:26 */
    ca_uint32_t cl_fib_xr_dscp_valid_1 :  1 ; /* bits 27:27 */
    ca_uint32_t cl_fib_xr_802_1p_valid_1 :  1 ; /* bits 28:28 */
    ca_uint32_t cl_fib_xr_cos_1      :  3 ; /* bits 31:29 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_IGR_FIB_DATA0_t;


#define L2FE_CLE_EGR_FIB_ACCESS                  0xf4301b98
#define L2FE_CLE_EGR_FIB_ACCESS_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_EGR_FIB_ACCESS_t;


#define L2FE_CLE_EGR_FIB_DATA4                   0xf4301b9c
#define L2FE_CLE_EGR_FIB_DATA4_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_fib_xr_inner_vid_0 :  3 ; /* bits 2:0 */
    ca_uint32_t cl_fib_xr_top_cmd_valid_0 :  1 ; /* bits 3:3 */
    ca_uint32_t cl_fib_xr_top_vlan_cmd_0 :  2 ; /* bits 5:4 */
    ca_uint32_t cl_fib_xr_top_sc_ind_0 :  1 ; /* bits 6:6 */
    ca_uint32_t cl_fib_xr_top_vid_0  : 12 ; /* bits 18:7 */
    ca_uint32_t cl_fib_xr_pkt_no_drop_0 :  1 ; /* bits 19:19 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_EGR_FIB_DATA4_t;


#define L2FE_CLE_EGR_FIB_DATA3                   0xf4301ba0
#define L2FE_CLE_EGR_FIB_DATA3_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_fib_xr_ldpid_0    :  4 ; /* bits 3:0 */
    ca_uint32_t cl_fib_xr_cos_valid_0 :  1 ; /* bits 4:4 */
    ca_uint32_t cl_fib_xr_dscp_valid_0 :  1 ; /* bits 5:5 */
    ca_uint32_t cl_fib_xr_802_1p_valid_0 :  1 ; /* bits 6:6 */
    ca_uint32_t cl_fib_xr_cos_0      :  3 ; /* bits 9:7 */
    ca_uint32_t cl_fib_xr_dscp_0     :  6 ; /* bits 15:10 */
    ca_uint32_t cl_fib_xr_802_1p_0   :  3 ; /* bits 18:16 */
    ca_uint32_t cl_fib_xr_inner_cmd_valid_0 :  1 ; /* bits 19:19 */
    ca_uint32_t cl_fib_xr_inner_vlan_cmd_0 :  2 ; /* bits 21:20 */
    ca_uint32_t cl_fib_xr_inner_sc_ind_0 :  1 ; /* bits 22:22 */
    ca_uint32_t cl_fib_xr_inner_vid_0 :  9 ; /* bits 31:23 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_EGR_FIB_DATA3_t;


#define L2FE_CLE_EGR_FIB_DATA2                   0xf4301ba4
#define L2FE_CLE_EGR_FIB_DATA2_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_fib_xr_top_vid_1  :  9 ; /* bits 8:0 */
    ca_uint32_t cl_fib_xr_pkt_no_drop_1 :  1 ; /* bits 9:9 */
    ca_uint32_t cl_fib_xr_stp_mode_0 :  2 ; /* bits 11:10 */
    ca_uint32_t cl_fib_xr_permit_valid_0 :  1 ; /* bits 12:12 */
    ca_uint32_t cl_fib_xr_permit_0   :  1 ; /* bits 13:13 */
    ca_uint32_t cl_fib_xr_premarked_0 :  1 ; /* bits 14:14 */
    ca_uint32_t cl_fib_xr_dscp_markdown_0 :  1 ; /* bits 15:15 */
    ca_uint32_t cl_fib_xr_mark_en_0  :  1 ; /* bits 16:16 */
    ca_uint32_t cl_fib_xr_flowid_0   : 12 ; /* bits 28:17 */
    ca_uint32_t cl_fib_xr_dp_valid_0 :  1 ; /* bits 29:29 */
    ca_uint32_t cl_fib_xr_ldpid_0    :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_EGR_FIB_DATA2_t;


#define L2FE_CLE_EGR_FIB_DATA1                   0xf4301ba8
#define L2FE_CLE_EGR_FIB_DATA1_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_fib_xr_dscp_1     :  6 ; /* bits 5:0 */
    ca_uint32_t cl_fib_xr_802_1p_1   :  3 ; /* bits 8:6 */
    ca_uint32_t cl_fib_xr_inner_cmd_valid_1 :  1 ; /* bits 9:9 */
    ca_uint32_t cl_fib_xr_inner_vlan_cmd_1 :  2 ; /* bits 11:10 */
    ca_uint32_t cl_fib_xr_inner_sc_ind_1 :  1 ; /* bits 12:12 */
    ca_uint32_t cl_fib_xr_inner_vid_1 : 12 ; /* bits 24:13 */
    ca_uint32_t cl_fib_xr_top_cmd_valid_1 :  1 ; /* bits 25:25 */
    ca_uint32_t cl_fib_xr_top_vlan_cmd_1 :  2 ; /* bits 27:26 */
    ca_uint32_t cl_fib_xr_top_sc_ind_1 :  1 ; /* bits 28:28 */
    ca_uint32_t cl_fib_xr_top_vid_1  :  3 ; /* bits 31:29 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_EGR_FIB_DATA1_t;


#define L2FE_CLE_EGR_FIB_DATA0                   0xf4301bac
#define L2FE_CLE_EGR_FIB_DATA0_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_fib_xr_stp_mode_1 :  2 ; /* bits 1:0 */
    ca_uint32_t cl_fib_xr_permit_valid_1 :  1 ; /* bits 2:2 */
    ca_uint32_t cl_fib_xr_permit_1   :  1 ; /* bits 3:3 */
    ca_uint32_t cl_fib_xr_premarked_1 :  1 ; /* bits 4:4 */
    ca_uint32_t cl_fib_xr_dscp_markdown_1 :  1 ; /* bits 5:5 */
    ca_uint32_t cl_fib_xr_mark_en_1  :  1 ; /* bits 6:6 */
    ca_uint32_t cl_fib_xr_flowid_1   : 12 ; /* bits 18:7 */
    ca_uint32_t cl_fib_xr_dp_valid_1 :  1 ; /* bits 19:19 */
    ca_uint32_t cl_fib_xr_ldpid_1    :  6 ; /* bits 25:20 */
    ca_uint32_t cl_fib_xr_cos_valid_1 :  1 ; /* bits 26:26 */
    ca_uint32_t cl_fib_xr_dscp_valid_1 :  1 ; /* bits 27:27 */
    ca_uint32_t cl_fib_xr_802_1p_valid_1 :  1 ; /* bits 28:28 */
    ca_uint32_t cl_fib_xr_cos_1      :  3 ; /* bits 31:29 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_CLE_EGR_FIB_DATA0_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* CLE */
typedef struct {
  L2FE_CLE_CTRL_t                          CTRL;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  L2FE_CLE_CONFG_STTS1_t                   CONFG_STTS1;                   /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  L2FE_CLE_CONFG_STTS2_t                   CONFG_STTS2;                   /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  L2FE_CLE_DEBUG_t                         _DEBUG;                        /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  L2FE_CLE_IGR_KEY_ACCESS_t                IGR_KEY_ACCESS;                /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  L2FE_CLE_IGR_KEY_DATA12_t                IGR_KEY_DATA12;                /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  L2FE_CLE_IGR_KEY_DATA11_t                IGR_KEY_DATA11;                /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  L2FE_CLE_IGR_KEY_DATA10_t                IGR_KEY_DATA10;                /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  L2FE_CLE_IGR_KEY_DATA9_t                 IGR_KEY_DATA9;                 /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  L2FE_CLE_IGR_KEY_DATA8_t                 IGR_KEY_DATA8;                 /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  L2FE_CLE_IGR_KEY_DATA7_t                 IGR_KEY_DATA7;                 /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  L2FE_CLE_IGR_KEY_DATA6_t                 IGR_KEY_DATA6;                 /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  L2FE_CLE_IGR_KEY_DATA5_t                 IGR_KEY_DATA5;                 /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  L2FE_CLE_IGR_KEY_DATA4_t                 IGR_KEY_DATA4;                 /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  L2FE_CLE_IGR_KEY_DATA3_t                 IGR_KEY_DATA3;                 /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  L2FE_CLE_IGR_KEY_DATA2_t                 IGR_KEY_DATA2;                 /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  L2FE_CLE_IGR_KEY_DATA1_t                 IGR_KEY_DATA1;                 /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  L2FE_CLE_IGR_KEY_DATA0_t                 IGR_KEY_DATA0;                 /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  L2FE_CLE_EGR_KEY_ACCESS_t                EGR_KEY_ACCESS;                /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  L2FE_CLE_EGR_KEY_DATA12_t                EGR_KEY_DATA12;                /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  L2FE_CLE_EGR_KEY_DATA11_t                EGR_KEY_DATA11;                /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  L2FE_CLE_EGR_KEY_DATA10_t                EGR_KEY_DATA10;                /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  L2FE_CLE_EGR_KEY_DATA9_t                 EGR_KEY_DATA9;                 /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  L2FE_CLE_EGR_KEY_DATA8_t                 EGR_KEY_DATA8;                 /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  L2FE_CLE_EGR_KEY_DATA7_t                 EGR_KEY_DATA7;                 /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  L2FE_CLE_EGR_KEY_DATA6_t                 EGR_KEY_DATA6;                 /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  L2FE_CLE_EGR_KEY_DATA5_t                 EGR_KEY_DATA5;                 /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  L2FE_CLE_EGR_KEY_DATA4_t                 EGR_KEY_DATA4;                 /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  L2FE_CLE_EGR_KEY_DATA3_t                 EGR_KEY_DATA3;                 /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  L2FE_CLE_EGR_KEY_DATA2_t                 EGR_KEY_DATA2;                 /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  L2FE_CLE_EGR_KEY_DATA1_t                 EGR_KEY_DATA1;                 /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  L2FE_CLE_EGR_KEY_DATA0_t                 EGR_KEY_DATA0;                 /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  L2FE_CLE_IGR_FIB_ACCESS_t                IGR_FIB_ACCESS;                /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  L2FE_CLE_IGR_FIB_DATA4_t                 IGR_FIB_DATA4;                 /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  L2FE_CLE_IGR_FIB_DATA3_t                 IGR_FIB_DATA3;                 /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  L2FE_CLE_IGR_FIB_DATA2_t                 IGR_FIB_DATA2;                 /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  L2FE_CLE_IGR_FIB_DATA1_t                 IGR_FIB_DATA1;                 /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  L2FE_CLE_IGR_FIB_DATA0_t                 IGR_FIB_DATA0;                 /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  L2FE_CLE_EGR_FIB_ACCESS_t                EGR_FIB_ACCESS;                /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];                   
  L2FE_CLE_EGR_FIB_DATA4_t                 EGR_FIB_DATA4;                 /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];                   
  L2FE_CLE_EGR_FIB_DATA3_t                 EGR_FIB_DATA3;                 /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];                   
  L2FE_CLE_EGR_FIB_DATA2_t                 EGR_FIB_DATA2;                 /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];                   
  L2FE_CLE_EGR_FIB_DATA1_t                 EGR_FIB_DATA1;                 /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];                   
  L2FE_CLE_EGR_FIB_DATA0_t                 EGR_FIB_DATA0;                 /* addr: 0x000000ac */
} APB0_L2FE_CLE_t;


/*
 * L2E
 */
        
#define L2FE_L2E_CTRL                            0xf4301c00
#define L2FE_L2E_CTRL_dft                        0x1ca00ff9

typedef volatile union {
  struct {
    ca_uint32_t aging_en             :  1 ; /* bits 0:0 */
    ca_uint32_t tmp_entry_aging_dis  :  1 ; /* bits 1:1 */
    ca_uint32_t aging_mode           :  1 ; /* bits 2:2 */
    ca_uint32_t aging_start_val      :  8 ; /* bits 10:3 */
    ca_uint32_t st_move_en           :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t st_mv_window         :  9 ; /* bits 21:13 */
    ca_uint32_t lrn_dis              :  1 ; /* bits 22:22 */
    ca_uint32_t lrn_mode             :  2 ; /* bits 24:23 */
    ca_uint32_t hash_collision_overwrite :  1 ; /* bits 25:25 */
    ca_uint32_t hashing_mode         :  2 ; /* bits 27:26 */
    ca_uint32_t da_deny_dnt_lrn      :  1 ; /* bits 28:28 */
    ca_uint32_t ovfl_entries_rcyc_en :  1 ; /* bits 29:29 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t cpu_opt_mode         :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_CTRL_t;


#define L2FE_L2E_AGING_CTRL                      0xf4301c04
#define L2FE_L2E_AGING_CTRL_dft                  0x77b0012c

typedef volatile union {
  struct {
    ca_uint32_t aging_out_time       : 19 ; /* bits 18:0 */
    ca_uint32_t cnt_to_1s            : 13 ; /* bits 31:19 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_AGING_CTRL_t;


#define L2FE_L2E_SW_AGING_CPT_ENTRY_3            0xf4301c08
#define L2FE_L2E_SW_AGING_CPT_ENTRY_3_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_SW_AGING_CPT_ENTRY_3_t;


#define L2FE_L2E_SW_AGING_CPT_ENTRY_2            0xf4301c0c
#define L2FE_L2E_SW_AGING_CPT_ENTRY_2_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_SW_AGING_CPT_ENTRY_2_t;


#define L2FE_L2E_SW_AGING_CPT_ENTRY_1            0xf4301c10
#define L2FE_L2E_SW_AGING_CPT_ENTRY_1_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_SW_AGING_CPT_ENTRY_1_t;


#define L2FE_L2E_SW_AGING_CPT_ENTRY_0            0xf4301c14
#define L2FE_L2E_SW_AGING_CPT_ENTRY_0_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_SW_AGING_CPT_ENTRY_0_t;


#define L2FE_L2E_FDB_CPU_CMD_WORD4               0xf4301c18
#define L2FE_L2E_FDB_CPU_CMD_WORD4_dft           0x00007fff

typedef volatile union {
  struct {
    ca_uint32_t word                 : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_FDB_CPU_CMD_WORD4_t;


#define L2FE_L2E_FDB_CPU_CMD_WORD3               0xf4301c1c
#define L2FE_L2E_FDB_CPU_CMD_WORD3_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t word                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_FDB_CPU_CMD_WORD3_t;


#define L2FE_L2E_FDB_CPU_CMD_WORD2               0xf4301c20
#define L2FE_L2E_FDB_CPU_CMD_WORD2_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t word                 : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_FDB_CPU_CMD_WORD2_t;


#define L2FE_L2E_FDB_CPU_CMD_WORD1               0xf4301c24
#define L2FE_L2E_FDB_CPU_CMD_WORD1_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t word                 : 27 ; /* bits 26:0 */
    ca_uint32_t rsrvd1               :  5 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_FDB_CPU_CMD_WORD1_t;


#define L2FE_L2E_FDB_CPU_CMD_WORD0               0xf4301c28
#define L2FE_L2E_FDB_CPU_CMD_WORD0_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t word                 : 27 ; /* bits 26:0 */
    ca_uint32_t rsrvd1               :  5 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_FDB_CPU_CMD_WORD0_t;


#define L2FE_L2E_FDB_CMD_RETURN                  0xf4301c2c
#define L2FE_L2E_FDB_CMD_RETURN_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t status               :  4 ; /* bits 3:0 */
    ca_uint32_t ext_status           : 13 ; /* bits 16:4 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_FDB_CMD_RETURN_t;


#define L2FE_L2E_CNT_CMD_RETURN                  0xf4301c30
#define L2FE_L2E_CNT_CMD_RETURN_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t status               :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_CNT_CMD_RETURN_t;


#define L2FE_L2E_PORT_MAC_CNT_STTS_0             0xf4301c34
#define L2FE_L2E_PORT_MAC_CNT_STTS_0_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t underflow_0          :  1 ; /* bits 0:0 */
    ca_uint32_t underflow_1          :  1 ; /* bits 1:1 */
    ca_uint32_t underflow_2          :  1 ; /* bits 2:2 */
    ca_uint32_t underflow_3          :  1 ; /* bits 3:3 */
    ca_uint32_t underflow_4          :  1 ; /* bits 4:4 */
    ca_uint32_t underflow_5          :  1 ; /* bits 5:5 */
    ca_uint32_t underflow_6          :  1 ; /* bits 6:6 */
    ca_uint32_t underflow_7          :  1 ; /* bits 7:7 */
    ca_uint32_t underflow_8          :  1 ; /* bits 8:8 */
    ca_uint32_t underflow_9          :  1 ; /* bits 9:9 */
    ca_uint32_t underflow_10         :  1 ; /* bits 10:10 */
    ca_uint32_t underflow_11         :  1 ; /* bits 11:11 */
    ca_uint32_t underflow_12         :  1 ; /* bits 12:12 */
    ca_uint32_t underflow_13         :  1 ; /* bits 13:13 */
    ca_uint32_t underflow_14         :  1 ; /* bits 14:14 */
    ca_uint32_t underflow_15         :  1 ; /* bits 15:15 */
    ca_uint32_t underflow_16         :  1 ; /* bits 16:16 */
    ca_uint32_t underflow_17         :  1 ; /* bits 17:17 */
    ca_uint32_t underflow_18         :  1 ; /* bits 18:18 */
    ca_uint32_t underflow_19         :  1 ; /* bits 19:19 */
    ca_uint32_t underflow_20         :  1 ; /* bits 20:20 */
    ca_uint32_t underflow_21         :  1 ; /* bits 21:21 */
    ca_uint32_t underflow_22         :  1 ; /* bits 22:22 */
    ca_uint32_t underflow_23         :  1 ; /* bits 23:23 */
    ca_uint32_t underflow_24         :  1 ; /* bits 24:24 */
    ca_uint32_t underflow_25         :  1 ; /* bits 25:25 */
    ca_uint32_t underflow_26         :  1 ; /* bits 26:26 */
    ca_uint32_t underflow_27         :  1 ; /* bits 27:27 */
    ca_uint32_t underflow_28         :  1 ; /* bits 28:28 */
    ca_uint32_t underflow_29         :  1 ; /* bits 29:29 */
    ca_uint32_t underflow_30         :  1 ; /* bits 30:30 */
    ca_uint32_t underflow_31         :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_PORT_MAC_CNT_STTS_0_t;


#define L2FE_L2E_PORT_MAC_CNT_STTS_1             0xf4301c38
#define L2FE_L2E_PORT_MAC_CNT_STTS_1_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t underflow_0          :  1 ; /* bits 0:0 */
    ca_uint32_t underflow_1          :  1 ; /* bits 1:1 */
    ca_uint32_t underflow_2          :  1 ; /* bits 2:2 */
    ca_uint32_t underflow_3          :  1 ; /* bits 3:3 */
    ca_uint32_t underflow_4          :  1 ; /* bits 4:4 */
    ca_uint32_t underflow_5          :  1 ; /* bits 5:5 */
    ca_uint32_t underflow_6          :  1 ; /* bits 6:6 */
    ca_uint32_t underflow_7          :  1 ; /* bits 7:7 */
    ca_uint32_t underflow_8          :  1 ; /* bits 8:8 */
    ca_uint32_t underflow_9          :  1 ; /* bits 9:9 */
    ca_uint32_t underflow_10         :  1 ; /* bits 10:10 */
    ca_uint32_t underflow_11         :  1 ; /* bits 11:11 */
    ca_uint32_t underflow_12         :  1 ; /* bits 12:12 */
    ca_uint32_t underflow_13         :  1 ; /* bits 13:13 */
    ca_uint32_t underflow_14         :  1 ; /* bits 14:14 */
    ca_uint32_t underflow_15         :  1 ; /* bits 15:15 */
    ca_uint32_t underflow_16         :  1 ; /* bits 16:16 */
    ca_uint32_t underflow_17         :  1 ; /* bits 17:17 */
    ca_uint32_t underflow_18         :  1 ; /* bits 18:18 */
    ca_uint32_t underflow_19         :  1 ; /* bits 19:19 */
    ca_uint32_t underflow_20         :  1 ; /* bits 20:20 */
    ca_uint32_t underflow_21         :  1 ; /* bits 21:21 */
    ca_uint32_t underflow_22         :  1 ; /* bits 22:22 */
    ca_uint32_t underflow_23         :  1 ; /* bits 23:23 */
    ca_uint32_t underflow_24         :  1 ; /* bits 24:24 */
    ca_uint32_t underflow_25         :  1 ; /* bits 25:25 */
    ca_uint32_t underflow_26         :  1 ; /* bits 26:26 */
    ca_uint32_t underflow_27         :  1 ; /* bits 27:27 */
    ca_uint32_t underflow_28         :  1 ; /* bits 28:28 */
    ca_uint32_t underflow_29         :  1 ; /* bits 29:29 */
    ca_uint32_t underflow_30         :  1 ; /* bits 30:30 */
    ca_uint32_t underflow_31         :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_PORT_MAC_CNT_STTS_1_t;


#define L2FE_L2E_PORT_MAC_LMT_CHK_STTS_0         0xf4301c3c
#define L2FE_L2E_PORT_MAC_LMT_CHK_STTS_0_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t excd_0               :  1 ; /* bits 0:0 */
    ca_uint32_t excd_1               :  1 ; /* bits 1:1 */
    ca_uint32_t excd_2               :  1 ; /* bits 2:2 */
    ca_uint32_t excd_3               :  1 ; /* bits 3:3 */
    ca_uint32_t excd_4               :  1 ; /* bits 4:4 */
    ca_uint32_t excd_5               :  1 ; /* bits 5:5 */
    ca_uint32_t excd_6               :  1 ; /* bits 6:6 */
    ca_uint32_t excd_7               :  1 ; /* bits 7:7 */
    ca_uint32_t excd_8               :  1 ; /* bits 8:8 */
    ca_uint32_t excd_9               :  1 ; /* bits 9:9 */
    ca_uint32_t excd_10              :  1 ; /* bits 10:10 */
    ca_uint32_t excd_11              :  1 ; /* bits 11:11 */
    ca_uint32_t excd_12              :  1 ; /* bits 12:12 */
    ca_uint32_t excd_13              :  1 ; /* bits 13:13 */
    ca_uint32_t excd_14              :  1 ; /* bits 14:14 */
    ca_uint32_t excd_15              :  1 ; /* bits 15:15 */
    ca_uint32_t excd_16              :  1 ; /* bits 16:16 */
    ca_uint32_t excd_17              :  1 ; /* bits 17:17 */
    ca_uint32_t excd_18              :  1 ; /* bits 18:18 */
    ca_uint32_t excd_19              :  1 ; /* bits 19:19 */
    ca_uint32_t excd_20              :  1 ; /* bits 20:20 */
    ca_uint32_t excd_21              :  1 ; /* bits 21:21 */
    ca_uint32_t excd_22              :  1 ; /* bits 22:22 */
    ca_uint32_t excd_23              :  1 ; /* bits 23:23 */
    ca_uint32_t excd_24              :  1 ; /* bits 24:24 */
    ca_uint32_t excd_25              :  1 ; /* bits 25:25 */
    ca_uint32_t excd_26              :  1 ; /* bits 26:26 */
    ca_uint32_t excd_27              :  1 ; /* bits 27:27 */
    ca_uint32_t excd_28              :  1 ; /* bits 28:28 */
    ca_uint32_t excd_29              :  1 ; /* bits 29:29 */
    ca_uint32_t excd_30              :  1 ; /* bits 30:30 */
    ca_uint32_t excd_31              :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_PORT_MAC_LMT_CHK_STTS_0_t;


#define L2FE_L2E_PORT_MAC_LMT_CHK_STTS_1         0xf4301c40
#define L2FE_L2E_PORT_MAC_LMT_CHK_STTS_1_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t excd_0               :  1 ; /* bits 0:0 */
    ca_uint32_t excd_1               :  1 ; /* bits 1:1 */
    ca_uint32_t excd_2               :  1 ; /* bits 2:2 */
    ca_uint32_t excd_3               :  1 ; /* bits 3:3 */
    ca_uint32_t excd_4               :  1 ; /* bits 4:4 */
    ca_uint32_t excd_5               :  1 ; /* bits 5:5 */
    ca_uint32_t excd_6               :  1 ; /* bits 6:6 */
    ca_uint32_t excd_7               :  1 ; /* bits 7:7 */
    ca_uint32_t excd_8               :  1 ; /* bits 8:8 */
    ca_uint32_t excd_9               :  1 ; /* bits 9:9 */
    ca_uint32_t excd_10              :  1 ; /* bits 10:10 */
    ca_uint32_t excd_11              :  1 ; /* bits 11:11 */
    ca_uint32_t excd_12              :  1 ; /* bits 12:12 */
    ca_uint32_t excd_13              :  1 ; /* bits 13:13 */
    ca_uint32_t excd_14              :  1 ; /* bits 14:14 */
    ca_uint32_t excd_15              :  1 ; /* bits 15:15 */
    ca_uint32_t excd_16              :  1 ; /* bits 16:16 */
    ca_uint32_t excd_17              :  1 ; /* bits 17:17 */
    ca_uint32_t excd_18              :  1 ; /* bits 18:18 */
    ca_uint32_t excd_19              :  1 ; /* bits 19:19 */
    ca_uint32_t excd_20              :  1 ; /* bits 20:20 */
    ca_uint32_t excd_21              :  1 ; /* bits 21:21 */
    ca_uint32_t excd_22              :  1 ; /* bits 22:22 */
    ca_uint32_t excd_23              :  1 ; /* bits 23:23 */
    ca_uint32_t excd_24              :  1 ; /* bits 24:24 */
    ca_uint32_t excd_25              :  1 ; /* bits 25:25 */
    ca_uint32_t excd_26              :  1 ; /* bits 26:26 */
    ca_uint32_t excd_27              :  1 ; /* bits 27:27 */
    ca_uint32_t excd_28              :  1 ; /* bits 28:28 */
    ca_uint32_t excd_29              :  1 ; /* bits 29:29 */
    ca_uint32_t excd_30              :  1 ; /* bits 30:30 */
    ca_uint32_t excd_31              :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_PORT_MAC_LMT_CHK_STTS_1_t;


#define L2FE_L2E_HASH_CLLSN_STTS                 0xf4301c44
#define L2FE_L2E_HASH_CLLSN_STTS_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cllsn_det            :  1 ; /* bits 0:0 */
    ca_uint32_t cllsn_addr           :  9 ; /* bits 9:1 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_HASH_CLLSN_STTS_t;


#define L2FE_L2E_L2E_LRN_STS                     0xf4301c48
#define L2FE_L2E_L2E_LRN_STS_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t loop_det             :  1 ; /* bits 0:0 */
    ca_uint32_t hit_tmp_entry_sm     :  1 ; /* bits 1:1 */
    ca_uint32_t hit_static_entry_sm  :  1 ; /* bits 2:2 */
    ca_uint32_t hit_sm_entry_sm      :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_L2E_LRN_STS_t;


#define L2FE_L2E_SW_AGING_REPORT_FIFO_STTS       0xf4301c4c
#define L2FE_L2E_SW_AGING_REPORT_FIFO_STTS_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cpt_entry_flg        :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t cnt                  :  4 ; /* bits 7:4 */
    ca_uint32_t rsrvd2               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_SW_AGING_REPORT_FIFO_STTS_t;


#define L2FE_L2E_POINTER_FF_STS_REG              0xf4301c50
#define L2FE_L2E_POINTER_FF_STS_REG_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t overflow_ind         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_POINTER_FF_STS_REG_t;


#define L2FE_L2E_POINTER_FF_CNT                  0xf4301c54
#define L2FE_L2E_POINTER_FF_CNT_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_POINTER_FF_CNT_t;


#define L2FE_L2E_INFO_FF_STS_REG                 0xf4301c58
#define L2FE_L2E_INFO_FF_STS_REG_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t overflow_ind         : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_STS_REG_t;


#define L2FE_L2E_INFO_FF_CNT_0                   0xf4301c5c
#define L2FE_L2E_INFO_FF_CNT_0_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_0_t;


#define L2FE_L2E_INFO_FF_CNT_1                   0xf4301c60
#define L2FE_L2E_INFO_FF_CNT_1_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_1_t;


#define L2FE_L2E_INFO_FF_CNT_2                   0xf4301c64
#define L2FE_L2E_INFO_FF_CNT_2_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_2_t;


#define L2FE_L2E_INFO_FF_CNT_3                   0xf4301c68
#define L2FE_L2E_INFO_FF_CNT_3_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_3_t;


#define L2FE_L2E_INFO_FF_CNT_4                   0xf4301c6c
#define L2FE_L2E_INFO_FF_CNT_4_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_4_t;


#define L2FE_L2E_INFO_FF_CNT_5                   0xf4301c70
#define L2FE_L2E_INFO_FF_CNT_5_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_5_t;


#define L2FE_L2E_INFO_FF_CNT_6                   0xf4301c74
#define L2FE_L2E_INFO_FF_CNT_6_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_6_t;


#define L2FE_L2E_INFO_FF_CNT_7                   0xf4301c78
#define L2FE_L2E_INFO_FF_CNT_7_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_7_t;


#define L2FE_L2E_INFO_FF_CNT_8                   0xf4301c7c
#define L2FE_L2E_INFO_FF_CNT_8_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_8_t;


#define L2FE_L2E_INFO_FF_CNT_9                   0xf4301c80
#define L2FE_L2E_INFO_FF_CNT_9_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_9_t;


#define L2FE_L2E_INFO_FF_CNT_10                  0xf4301c84
#define L2FE_L2E_INFO_FF_CNT_10_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_10_t;


#define L2FE_L2E_INFO_FF_CNT_11                  0xf4301c88
#define L2FE_L2E_INFO_FF_CNT_11_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_11_t;


#define L2FE_L2E_INFO_FF_CNT_12                  0xf4301c8c
#define L2FE_L2E_INFO_FF_CNT_12_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_12_t;


#define L2FE_L2E_INFO_FF_CNT_13                  0xf4301c90
#define L2FE_L2E_INFO_FF_CNT_13_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_13_t;


#define L2FE_L2E_INFO_FF_CNT_14                  0xf4301c94
#define L2FE_L2E_INFO_FF_CNT_14_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_14_t;


#define L2FE_L2E_INFO_FF_CNT_15                  0xf4301c98
#define L2FE_L2E_INFO_FF_CNT_15_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_INFO_FF_CNT_15_t;


#define L2FE_L2E_L3FE_RFSH_STS                   0xf4301c9c
#define L2FE_L2E_L3FE_RFSH_STS_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rfsh_entry_ovfl      :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_L3FE_RFSH_STS_t;


#define L2FE_L2E_DEBUG_BUS                       0xf4301ca0
#define L2FE_L2E_DEBUG_BUS_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sel                  :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_DEBUG_BUS_t;


#define L2FE_L2E_FDB_ACCESS                      0xf4301ca4
#define L2FE_L2E_FDB_ACCESS_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 : 21 ; /* bits 20:0 */
    ca_uint32_t rsrvd1               :  9 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_FDB_ACCESS_t;


#define L2FE_L2E_FDB_DATA3                       0xf4301ca8
#define L2FE_L2E_FDB_DATA3_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac_addr             :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_FDB_DATA3_t;


#define L2FE_L2E_FDB_DATA2                       0xf4301cac
#define L2FE_L2E_FDB_DATA2_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac_addr             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_FDB_DATA2_t;


#define L2FE_L2E_FDB_DATA1                       0xf4301cb0
#define L2FE_L2E_FDB_DATA1_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t lrned_vid            :  3 ; /* bits 2:0 */
    ca_uint32_t key_dot1p            :  3 ; /* bits 5:3 */
    ca_uint32_t key_scind            :  1 ; /* bits 6:6 */
    ca_uint32_t key_vid              : 12 ; /* bits 18:7 */
    ca_uint32_t mac_addr             : 13 ; /* bits 31:19 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_FDB_DATA1_t;


#define L2FE_L2E_FDB_DATA0                       0xf4301cb4
#define L2FE_L2E_FDB_DATA0_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mcgid                : 10 ; /* bits 9:0 */
    ca_uint32_t mc_flag              :  1 ; /* bits 10:10 */
    ca_uint32_t aging_sts            :  8 ; /* bits 18:11 */
    ca_uint32_t is_static            :  1 ; /* bits 19:19 */
    ca_uint32_t da_permit            :  1 ; /* bits 20:20 */
    ca_uint32_t sa_permit            :  1 ; /* bits 21:21 */
    ca_uint32_t lrned_scind          :  1 ; /* bits 22:22 */
    ca_uint32_t lrned_vid            :  9 ; /* bits 31:23 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_FDB_DATA0_t;


#define L2FE_L2E_PORT_MAC_CNT_LMT_ACCESS         0xf4301cb8
#define L2FE_L2E_PORT_MAC_CNT_LMT_ACCESS_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 20 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_PORT_MAC_CNT_LMT_ACCESS_t;


#define L2FE_L2E_PORT_MAC_CNT_LMT_DATA           0xf4301cbc
#define L2FE_L2E_PORT_MAC_CNT_LMT_DATA_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t val                  : 13 ; /* bits 12:0 */
    ca_uint32_t rsrvd1               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_PORT_MAC_CNT_LMT_DATA_t;


#define L2FE_L2E_AGING_CTRL_EXT                  0xf4301cc0
#define L2FE_L2E_AGING_CTRL_EXT_dft              0x00000002

typedef volatile union {
  struct {
    ca_uint32_t sw_lrn_aging_start_val :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_L2E_AGING_CTRL_EXT_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* L2E */
typedef struct {
  L2FE_L2E_CTRL_t                          CTRL;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  L2FE_L2E_AGING_CTRL_t                    AGING_CTRL;                    /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  L2FE_L2E_SW_AGING_CPT_ENTRY_3_t          SW_AGING_CPT_ENTRY_3;          /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  L2FE_L2E_SW_AGING_CPT_ENTRY_2_t          SW_AGING_CPT_ENTRY_2;          /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  L2FE_L2E_SW_AGING_CPT_ENTRY_1_t          SW_AGING_CPT_ENTRY_1;          /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  L2FE_L2E_SW_AGING_CPT_ENTRY_0_t          SW_AGING_CPT_ENTRY_0;          /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  L2FE_L2E_FDB_CPU_CMD_WORD4_t             FDB_CPU_CMD_WORD4;             /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  L2FE_L2E_FDB_CPU_CMD_WORD3_t             FDB_CPU_CMD_WORD3;             /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  L2FE_L2E_FDB_CPU_CMD_WORD2_t             FDB_CPU_CMD_WORD2;             /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  L2FE_L2E_FDB_CPU_CMD_WORD1_t             FDB_CPU_CMD_WORD1;             /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  L2FE_L2E_FDB_CPU_CMD_WORD0_t             FDB_CPU_CMD_WORD0;             /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  L2FE_L2E_FDB_CMD_RETURN_t                FDB_CMD_RETURN;                /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  L2FE_L2E_CNT_CMD_RETURN_t                CNT_CMD_RETURN;                /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  L2FE_L2E_PORT_MAC_CNT_STTS_0_t           PORT_MAC_CNT_STTS_0;           /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  L2FE_L2E_PORT_MAC_CNT_STTS_1_t           PORT_MAC_CNT_STTS_1;           /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  L2FE_L2E_PORT_MAC_LMT_CHK_STTS_0_t       PORT_MAC_LMT_CHK_STTS_0;       /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  L2FE_L2E_PORT_MAC_LMT_CHK_STTS_1_t       PORT_MAC_LMT_CHK_STTS_1;       /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  L2FE_L2E_HASH_CLLSN_STTS_t               HASH_CLLSN_STTS;               /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  L2FE_L2E_L2E_LRN_STS_t                   L2E_LRN_STS;                   /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  L2FE_L2E_SW_AGING_REPORT_FIFO_STTS_t     SW_AGING_REPORT_FIFO_STTS;     /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  L2FE_L2E_POINTER_FF_STS_REG_t            POINTER_FF_STS_REG;            /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  L2FE_L2E_POINTER_FF_CNT_t                POINTER_FF_CNT;                /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  L2FE_L2E_INFO_FF_STS_REG_t               INFO_FF_STS_REG;               /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  L2FE_L2E_INFO_FF_CNT_0_t                 INFO_FF_CNT_0;                 /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  L2FE_L2E_INFO_FF_CNT_1_t                 INFO_FF_CNT_1;                 /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  L2FE_L2E_INFO_FF_CNT_2_t                 INFO_FF_CNT_2;                 /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  L2FE_L2E_INFO_FF_CNT_3_t                 INFO_FF_CNT_3;                 /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  L2FE_L2E_INFO_FF_CNT_4_t                 INFO_FF_CNT_4;                 /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  L2FE_L2E_INFO_FF_CNT_5_t                 INFO_FF_CNT_5;                 /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  L2FE_L2E_INFO_FF_CNT_6_t                 INFO_FF_CNT_6;                 /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  L2FE_L2E_INFO_FF_CNT_7_t                 INFO_FF_CNT_7;                 /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  L2FE_L2E_INFO_FF_CNT_8_t                 INFO_FF_CNT_8;                 /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  L2FE_L2E_INFO_FF_CNT_9_t                 INFO_FF_CNT_9;                 /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  L2FE_L2E_INFO_FF_CNT_10_t                INFO_FF_CNT_10;                /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  L2FE_L2E_INFO_FF_CNT_11_t                INFO_FF_CNT_11;                /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  L2FE_L2E_INFO_FF_CNT_12_t                INFO_FF_CNT_12;                /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  L2FE_L2E_INFO_FF_CNT_13_t                INFO_FF_CNT_13;                /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  L2FE_L2E_INFO_FF_CNT_14_t                INFO_FF_CNT_14;                /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  L2FE_L2E_INFO_FF_CNT_15_t                INFO_FF_CNT_15;                /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];                   
  L2FE_L2E_L3FE_RFSH_STS_t                 L3FE_RFSH_STS;                 /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];                   
  L2FE_L2E_DEBUG_BUS_t                     DEBUG_BUS;                     /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];                   
  L2FE_L2E_FDB_ACCESS_t                    FDB_ACCESS;                    /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];                   
  L2FE_L2E_FDB_DATA3_t                     FDB_DATA3;                     /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];                   
  L2FE_L2E_FDB_DATA2_t                     FDB_DATA2;                     /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd44[3];                   
  L2FE_L2E_FDB_DATA1_t                     FDB_DATA1;                     /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd45[3];                   
  L2FE_L2E_FDB_DATA0_t                     FDB_DATA0;                     /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd46[3];                   
  L2FE_L2E_PORT_MAC_CNT_LMT_ACCESS_t       PORT_MAC_CNT_LMT_ACCESS;       /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd47[3];                   
  L2FE_L2E_PORT_MAC_CNT_LMT_DATA_t         PORT_MAC_CNT_LMT_DATA;         /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd48[3];                   
  L2FE_L2E_AGING_CTRL_EXT_t                AGING_CTRL_EXT;                /* addr: 0x000000c0 */
} APB0_L2FE_L2E_t;


/*
 * IM3E
 */
        
#define L2FE_IM3E_CTRL                           0xf4301e00
#define L2FE_IM3E_CTRL_dft                       0x00000024

typedef volatile union {
  struct {
    ca_uint32_t da_use_l2_addr       :  1 ; /* bits 0:0 */
    ca_uint32_t sa_use_l2_addr       :  1 ; /* bits 1:1 */
    ca_uint32_t use_l3mc_lkup        :  1 ; /* bits 2:2 */
    ca_uint32_t igmp_no_vlan_srch    :  1 ; /* bits 3:3 */
    ca_uint32_t mld_no_vlan_srch     :  1 ; /* bits 4:4 */
    ca_uint32_t mcu_oprt_mode        :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_IM3E_CTRL_t;


#define L2FE_IM3E_MLDDA_TBL_INDRCT_ACCESS        0xf4301e04
#define L2FE_IM3E_MLDDA_TBL_INDRCT_ACCESS_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vld_entries_num      :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_IM3E_MLDDA_TBL_INDRCT_ACCESS_t;


#define L2FE_IM3E_MLDSA_TBL_INDRCT_ACCESS        0xf4301e08
#define L2FE_IM3E_MLDSA_TBL_INDRCT_ACCESS_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vld_entries_num      :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_IM3E_MLDSA_TBL_INDRCT_ACCESS_t;


#define L2FE_IM3E_STTS1                          0xf4301e0c
#define L2FE_IM3E_STTS1_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t da_cmd_oprt_incmpted :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_IM3E_STTS1_t;


#define L2FE_IM3E_STTS2                          0xf4301e10
#define L2FE_IM3E_STTS2_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sa_cmd_oprt_incmpted :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_IM3E_STTS2_t;


#define L2FE_IM3E_DEBUG                          0xf4301e14
#define L2FE_IM3E_DEBUG_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bus_sel              :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_IM3E_DEBUG_t;


#define L2FE_IM3E_MLDDA_ACCESS                   0xf4301e18
#define L2FE_IM3E_MLDDA_ACCESS_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_IM3E_MLDDA_ACCESS_t;


#define L2FE_IM3E_MLDDA_DATA5                    0xf4301e1c
#define L2FE_IM3E_MLDDA_DATA5_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vid                  :  1 ; /* bits 0:0 */
    ca_uint32_t vlan_sc_ind          :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_IM3E_MLDDA_DATA5_t;


#define L2FE_IM3E_MLDDA_DATA4                    0xf4301e20
#define L2FE_IM3E_MLDDA_DATA4_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ip_da                : 20 ; /* bits 19:0 */
    ca_uint32_t ipv6_flg             :  1 ; /* bits 20:20 */
    ca_uint32_t vid                  : 11 ; /* bits 31:21 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_IM3E_MLDDA_DATA4_t;


#define L2FE_IM3E_MLDDA_DATA3                    0xf4301e24
#define L2FE_IM3E_MLDDA_DATA3_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ip_da                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_IM3E_MLDDA_DATA3_t;


#define L2FE_IM3E_MLDDA_DATA2                    0xf4301e28
#define L2FE_IM3E_MLDDA_DATA2_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ip_da                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_IM3E_MLDDA_DATA2_t;


#define L2FE_IM3E_MLDDA_DATA1                    0xf4301e2c
#define L2FE_IM3E_MLDDA_DATA1_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ip_da                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_IM3E_MLDDA_DATA1_t;


#define L2FE_IM3E_MLDDA_DATA0                    0xf4301e30
#define L2FE_IM3E_MLDDA_DATA0_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t entry_valid          :  1 ; /* bits 0:0 */
    ca_uint32_t mc_group_id          : 10 ; /* bits 10:1 */
    ca_uint32_t v3_ind               :  1 ; /* bits 11:11 */
    ca_uint32_t connection_id        :  8 ; /* bits 19:12 */
    ca_uint32_t ip_da                : 12 ; /* bits 31:20 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_IM3E_MLDDA_DATA0_t;


#define L2FE_IM3E_MLDSA_ACCESS                   0xf4301e34
#define L2FE_IM3E_MLDSA_ACCESS_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_IM3E_MLDSA_ACCESS_t;


#define L2FE_IM3E_MLDSA_DATA4                    0xf4301e38
#define L2FE_IM3E_MLDSA_DATA4_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ipv6_sa              : 11 ; /* bits 10:0 */
    ca_uint32_t connection_id        :  8 ; /* bits 18:11 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_IM3E_MLDSA_DATA4_t;


#define L2FE_IM3E_MLDSA_DATA3                    0xf4301e3c
#define L2FE_IM3E_MLDSA_DATA3_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ipv6_sa              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_IM3E_MLDSA_DATA3_t;


#define L2FE_IM3E_MLDSA_DATA2                    0xf4301e40
#define L2FE_IM3E_MLDSA_DATA2_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ipv6_sa              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_IM3E_MLDSA_DATA2_t;


#define L2FE_IM3E_MLDSA_DATA1                    0xf4301e44
#define L2FE_IM3E_MLDSA_DATA1_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ipv6_sa              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_IM3E_MLDSA_DATA1_t;


#define L2FE_IM3E_MLDSA_DATA0                    0xf4301e48
#define L2FE_IM3E_MLDSA_DATA0_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t entry_valid          :  1 ; /* bits 0:0 */
    ca_uint32_t mc_group_id          : 10 ; /* bits 10:1 */
    ca_uint32_t ipv6_sa              : 21 ; /* bits 31:11 */
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_IM3E_MLDSA_DATA0_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* IM3E */
typedef struct {
  L2FE_IM3E_CTRL_t                         CTRL;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  L2FE_IM3E_MLDDA_TBL_INDRCT_ACCESS_t      MLDDA_TBL_INDRCT_ACCESS;       /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  L2FE_IM3E_MLDSA_TBL_INDRCT_ACCESS_t      MLDSA_TBL_INDRCT_ACCESS;       /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  L2FE_IM3E_STTS1_t                        STTS1;                         /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  L2FE_IM3E_STTS2_t                        STTS2;                         /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  L2FE_IM3E_DEBUG_t                        _DEBUG;                        /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  L2FE_IM3E_MLDDA_ACCESS_t                 MLDDA_ACCESS;                  /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  L2FE_IM3E_MLDDA_DATA5_t                  MLDDA_DATA5;                   /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  L2FE_IM3E_MLDDA_DATA4_t                  MLDDA_DATA4;                   /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  L2FE_IM3E_MLDDA_DATA3_t                  MLDDA_DATA3;                   /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  L2FE_IM3E_MLDDA_DATA2_t                  MLDDA_DATA2;                   /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  L2FE_IM3E_MLDDA_DATA1_t                  MLDDA_DATA1;                   /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  L2FE_IM3E_MLDDA_DATA0_t                  MLDDA_DATA0;                   /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  L2FE_IM3E_MLDSA_ACCESS_t                 MLDSA_ACCESS;                  /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  L2FE_IM3E_MLDSA_DATA4_t                  MLDSA_DATA4;                   /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  L2FE_IM3E_MLDSA_DATA3_t                  MLDSA_DATA3;                   /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  L2FE_IM3E_MLDSA_DATA2_t                  MLDSA_DATA2;                   /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  L2FE_IM3E_MLDSA_DATA1_t                  MLDSA_DATA1;                   /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  L2FE_IM3E_MLDSA_DATA0_t                  MLDSA_DATA0;                   /* addr: 0x00000048 */
} APB0_L2FE_IM3E_t;


/*
 * MIRE
 */
        
#define L2FE_MIRE_MIR_CTRL                       0xf4301f00
#define L2FE_MIRE_MIR_CTRL_dft                   0x00000001

typedef volatile union {
  struct {
    ca_uint32_t pkt_drop_src_mir_en  :  1 ; /* bits 0:0 */
    ca_uint32_t pkt_keep_old         :  1 ; /* bits 1:1 */
    ca_uint32_t lspid_remap          :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_CTRL_t;


#define L2FE_MIRE_MIR_RULE_SSID_0                0xf4301f04
#define L2FE_MIRE_MIR_RULE_SSID_0_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t flowid               :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t ldpid                :  6 ; /* bits 15:10 */
    ca_uint32_t lspid                :  6 ; /* bits 21:16 */
    ca_uint32_t mode                 :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd2               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_RULE_SSID_0_t;


#define L2FE_MIRE_MIR_RULE_SSID_1                0xf4301f08
#define L2FE_MIRE_MIR_RULE_SSID_1_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t flowid               :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t ldpid                :  6 ; /* bits 15:10 */
    ca_uint32_t lspid                :  6 ; /* bits 21:16 */
    ca_uint32_t mode                 :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd2               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_RULE_SSID_1_t;


#define L2FE_MIRE_MIR_RULE_SSID_2                0xf4301f0c
#define L2FE_MIRE_MIR_RULE_SSID_2_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t flowid               :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t ldpid                :  6 ; /* bits 15:10 */
    ca_uint32_t lspid                :  6 ; /* bits 21:16 */
    ca_uint32_t mode                 :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd2               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_RULE_SSID_2_t;


#define L2FE_MIRE_MIR_RULE_SSID_3                0xf4301f10
#define L2FE_MIRE_MIR_RULE_SSID_3_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t flowid               :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t ldpid                :  6 ; /* bits 15:10 */
    ca_uint32_t lspid                :  6 ; /* bits 21:16 */
    ca_uint32_t mode                 :  3 ; /* bits 24:22 */
    ca_uint32_t rsrvd2               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_RULE_SSID_3_t;


#define L2FE_MIRE_MIR_ACT_0_SSID_0               0xf4301f14
#define L2FE_MIRE_MIR_ACT_0_SSID_0_dft           0x0000433a

typedef volatile union {
  struct {
    ca_uint32_t lspid                :  6 ; /* bits 5:0 */
    ca_uint32_t pspid                :  4 ; /* bits 9:6 */
    ca_uint32_t ldpid                :  6 ; /* bits 15:10 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_ACT_0_SSID_0_t;


#define L2FE_MIRE_MIR_ACT_0_SSID_1               0xf4301f18
#define L2FE_MIRE_MIR_ACT_0_SSID_1_dft           0x0000437b

typedef volatile union {
  struct {
    ca_uint32_t lspid                :  6 ; /* bits 5:0 */
    ca_uint32_t pspid                :  4 ; /* bits 9:6 */
    ca_uint32_t ldpid                :  6 ; /* bits 15:10 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_ACT_0_SSID_1_t;


#define L2FE_MIRE_MIR_ACT_0_SSID_2               0xf4301f1c
#define L2FE_MIRE_MIR_ACT_0_SSID_2_dft           0x000043bc

typedef volatile union {
  struct {
    ca_uint32_t lspid                :  6 ; /* bits 5:0 */
    ca_uint32_t pspid                :  4 ; /* bits 9:6 */
    ca_uint32_t ldpid                :  6 ; /* bits 15:10 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_ACT_0_SSID_2_t;


#define L2FE_MIRE_MIR_ACT_0_SSID_3               0xf4301f20
#define L2FE_MIRE_MIR_ACT_0_SSID_3_dft           0x000043fd

typedef volatile union {
  struct {
    ca_uint32_t lspid                :  6 ; /* bits 5:0 */
    ca_uint32_t pspid                :  4 ; /* bits 9:6 */
    ca_uint32_t ldpid                :  6 ; /* bits 15:10 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_ACT_0_SSID_3_t;


#define L2FE_MIRE_MIR_ACT_1_SSID_0               0xf4301f24
#define L2FE_MIRE_MIR_ACT_1_SSID_0_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dot1p                :  3 ; /* bits 2:0 */
    ca_uint32_t sc_ind               :  1 ; /* bits 3:3 */
    ca_uint32_t vid                  : 12 ; /* bits 15:4 */
    ca_uint32_t vlan_cmd             :  1 ; /* bits 16:16 */
    ca_uint32_t cos_vld              :  1 ; /* bits 17:17 */
    ca_uint32_t cos                  :  3 ; /* bits 20:18 */
    ca_uint32_t sv_tpid_sel          :  2 ; /* bits 22:21 */
    ca_uint32_t cv_tpid_sel          :  2 ; /* bits 24:23 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_ACT_1_SSID_0_t;


#define L2FE_MIRE_MIR_ACT_1_SSID_1               0xf4301f28
#define L2FE_MIRE_MIR_ACT_1_SSID_1_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dot1p                :  3 ; /* bits 2:0 */
    ca_uint32_t sc_ind               :  1 ; /* bits 3:3 */
    ca_uint32_t vid                  : 12 ; /* bits 15:4 */
    ca_uint32_t vlan_cmd             :  1 ; /* bits 16:16 */
    ca_uint32_t cos_vld              :  1 ; /* bits 17:17 */
    ca_uint32_t cos                  :  3 ; /* bits 20:18 */
    ca_uint32_t sv_tpid_sel          :  2 ; /* bits 22:21 */
    ca_uint32_t cv_tpid_sel          :  2 ; /* bits 24:23 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_ACT_1_SSID_1_t;


#define L2FE_MIRE_MIR_ACT_1_SSID_2               0xf4301f2c
#define L2FE_MIRE_MIR_ACT_1_SSID_2_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dot1p                :  3 ; /* bits 2:0 */
    ca_uint32_t sc_ind               :  1 ; /* bits 3:3 */
    ca_uint32_t vid                  : 12 ; /* bits 15:4 */
    ca_uint32_t vlan_cmd             :  1 ; /* bits 16:16 */
    ca_uint32_t cos_vld              :  1 ; /* bits 17:17 */
    ca_uint32_t cos                  :  3 ; /* bits 20:18 */
    ca_uint32_t sv_tpid_sel          :  2 ; /* bits 22:21 */
    ca_uint32_t cv_tpid_sel          :  2 ; /* bits 24:23 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_ACT_1_SSID_2_t;


#define L2FE_MIRE_MIR_ACT_1_SSID_3               0xf4301f30
#define L2FE_MIRE_MIR_ACT_1_SSID_3_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dot1p                :  3 ; /* bits 2:0 */
    ca_uint32_t sc_ind               :  1 ; /* bits 3:3 */
    ca_uint32_t vid                  : 12 ; /* bits 15:4 */
    ca_uint32_t vlan_cmd             :  1 ; /* bits 16:16 */
    ca_uint32_t cos_vld              :  1 ; /* bits 17:17 */
    ca_uint32_t cos                  :  3 ; /* bits 20:18 */
    ca_uint32_t sv_tpid_sel          :  2 ; /* bits 22:21 */
    ca_uint32_t cv_tpid_sel          :  2 ; /* bits 24:23 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_ACT_1_SSID_3_t;


#define L2FE_MIRE_MIR_STTS_0                     0xf4301f34
#define L2FE_MIRE_MIR_STTS_0_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pspid_vld            :  1 ; /* bits 0:0 */
    ca_uint32_t pspid                :  4 ; /* bits 4:1 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_STTS_0_t;


#define L2FE_MIRE_MIR_STTS_1                     0xf4301f38
#define L2FE_MIRE_MIR_STTS_1_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pspid_vld            :  1 ; /* bits 0:0 */
    ca_uint32_t pspid                :  4 ; /* bits 4:1 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_STTS_1_t;


#define L2FE_MIRE_MIR_STTS_2                     0xf4301f3c
#define L2FE_MIRE_MIR_STTS_2_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pspid_vld            :  1 ; /* bits 0:0 */
    ca_uint32_t pspid                :  4 ; /* bits 4:1 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_STTS_2_t;


#define L2FE_MIRE_MIR_STTS_3                     0xf4301f40
#define L2FE_MIRE_MIR_STTS_3_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pspid_vld            :  1 ; /* bits 0:0 */
    ca_uint32_t pspid                :  4 ; /* bits 4:1 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_MIR_STTS_3_t;


#define L2FE_MIRE_PINGPONG_STS                   0xf4301f44
#define L2FE_MIRE_PINGPONG_STS_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ovfl                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_PINGPONG_STS_t;


#define L2FE_MIRE_DATA_FIFO_CNT                  0xf4301f48
#define L2FE_MIRE_DATA_FIFO_CNT_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t entry_cnt            :  7 ; /* bits 6:0 */
    ca_uint32_t seg_cnt              :  4 ; /* bits 10:7 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t extra_store_cnt      :  2 ; /* bits 17:16 */
    ca_uint32_t data_ltched          :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd2               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_DATA_FIFO_CNT_t;


#define L2FE_MIRE_DATA_FIFO_STTS                 0xf4301f4c
#define L2FE_MIRE_DATA_FIFO_STTS_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ovfl                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_DATA_FIFO_STTS_t;


#define L2FE_MIRE_DEBUG                          0xf4301f50
#define L2FE_MIRE_DEBUG_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sel                  :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2FE_MIRE_DEBUG_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* MIRE */
typedef struct {
  L2FE_MIRE_MIR_CTRL_t                     MIR_CTRL;                      /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  L2FE_MIRE_MIR_RULE_SSID_0_t              MIR_RULE_SSID_0;               /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  L2FE_MIRE_MIR_RULE_SSID_1_t              MIR_RULE_SSID_1;               /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  L2FE_MIRE_MIR_RULE_SSID_2_t              MIR_RULE_SSID_2;               /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  L2FE_MIRE_MIR_RULE_SSID_3_t              MIR_RULE_SSID_3;               /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  L2FE_MIRE_MIR_ACT_0_SSID_0_t             MIR_ACT_0_SSID_0;              /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  L2FE_MIRE_MIR_ACT_0_SSID_1_t             MIR_ACT_0_SSID_1;              /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  L2FE_MIRE_MIR_ACT_0_SSID_2_t             MIR_ACT_0_SSID_2;              /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  L2FE_MIRE_MIR_ACT_0_SSID_3_t             MIR_ACT_0_SSID_3;              /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  L2FE_MIRE_MIR_ACT_1_SSID_0_t             MIR_ACT_1_SSID_0;              /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  L2FE_MIRE_MIR_ACT_1_SSID_1_t             MIR_ACT_1_SSID_1;              /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  L2FE_MIRE_MIR_ACT_1_SSID_2_t             MIR_ACT_1_SSID_2;              /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  L2FE_MIRE_MIR_ACT_1_SSID_3_t             MIR_ACT_1_SSID_3;              /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  L2FE_MIRE_MIR_STTS_0_t                   MIR_STTS_0;                    /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  L2FE_MIRE_MIR_STTS_1_t                   MIR_STTS_1;                    /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  L2FE_MIRE_MIR_STTS_2_t                   MIR_STTS_2;                    /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  L2FE_MIRE_MIR_STTS_3_t                   MIR_STTS_3;                    /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  L2FE_MIRE_PINGPONG_STS_t                 PINGPONG_STS;                  /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  L2FE_MIRE_DATA_FIFO_CNT_t                DATA_FIFO_CNT;                 /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  L2FE_MIRE_DATA_FIFO_STTS_t               DATA_FIFO_STTS;                /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  L2FE_MIRE_DEBUG_t                        _DEBUG;                        /* addr: 0x00000050 */
} APB0_L2FE_MIRE_t;

    
  
        
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* L2FE */

typedef struct {
  APB0_L2FE_GLB_t                          GLB;                           /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[241];                  
  APB0_L2FE_PP_t                           PP;                            /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd2[379];                  
  APB0_L2FE_PLA_t                          PLA;                           /* addr: 0x00000300 */
  ca_uint32_t                              rsrvd3[239];                  
  APB0_L2FE_PLC_t                          PLC;                           /* addr: 0x00000400 */
  ca_uint32_t                              rsrvd4[237];                  
  APB0_L2FE_PLE_t                          PLE;                           /* addr: 0x00000500 */
  ca_uint32_t                              rsrvd5[201];                  
  APB0_L2FE_ARB_t                          ARB;                           /* addr: 0x00000600 */
  ca_uint32_t                              rsrvd6[213];                  
  APB0_L2FE_PE_t                           PE;                            /* addr: 0x00000700 */
  ca_uint32_t                              rsrvd7[465];                  
  APB0_L2FE_LF_t                           LF;                            /* addr: 0x00000900 */
  ca_uint32_t                              rsrvd8[249];                  
  APB0_L2FE_VE_t                           VE;                            /* addr: 0x00000a00 */
  ca_uint32_t                              rsrvd9[213];                  
  APB0_L2FE_CLE_t                          CLE;                           /* addr: 0x00000b00 */
  ca_uint32_t                              rsrvd10[169];                 
  APB0_L2FE_L2E_t                          L2E;                           /* addr: 0x00000c00 */
  ca_uint32_t                              rsrvd11[415];                 
  APB0_L2FE_IM3E_t                         IM3E;                          /* addr: 0x00000e00 */
  ca_uint32_t                              rsrvd12[219];                 
  APB0_L2FE_MIRE_t                         MIRE;                          /* addr: 0x00000f00 */
} APB0_L2FE_t;


/*
 * L2TM
 */
  
/*
 * l2tm_glb
 */
        
#define L2TM_L2TM_GLB_REV_ID                     0xf4302000
#define L2TM_L2TM_GLB_REV_ID_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t minor                : 16 ; /* bits 15:0 */
    ca_uint32_t major                : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_GLB_REV_ID_t;


#define L2TM_L2TM_GLB_INT                        0xf4302004
#define L2TM_L2TM_GLB_INT_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bm                   :  1 ; /* bits 0:0 */
    ca_uint32_t qm                   :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_GLB_INT_t;


#define L2TM_L2TM_GLB_INTE                       0xf4302008
#define L2TM_L2TM_GLB_INTE_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bmE                  :  1 ; /* bits 0:0 */
    ca_uint32_t qmE                  :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_GLB_INTE_t;


#define L2TM_L2TM_GLB_STS                        0xf430200c
#define L2TM_L2TM_GLB_STS_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 14 ;
    ca_uint32_t voqinfo_ram_init_done :  1 ; /* bits 14:14 */
    ca_uint32_t freeq_ram_init_done  :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd2               : 14 ;
    ca_uint32_t idle                 :  1 ; /* bits 30:30 */
    ca_uint32_t init_done            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_GLB_STS_t;


#define L2TM_L2TM_GLB_CTRL                       0xf4302010
#define L2TM_L2TM_GLB_CTRL_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 31 ;
    ca_uint32_t cntrcfg_clear_on_read :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_GLB_CTRL_t;


#define L2TM_L2TM_GLB_SPARE_CFG                  0xf4302014
#define L2TM_L2TM_GLB_SPARE_CFG_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t spare                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_GLB_SPARE_CFG_t;


#define L2TM_L2TM_GLB_SPARE_STS                  0xf4302018
#define L2TM_L2TM_GLB_SPARE_STS_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t spare                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_GLB_SPARE_STS_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2tm_glb */
typedef struct {
  L2TM_L2TM_GLB_REV_ID_t                   REV_ID;                        /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  L2TM_L2TM_GLB_INT_t                      INT;                           /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  L2TM_L2TM_GLB_INTE_t                     INTE;                          /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  L2TM_L2TM_GLB_STS_t                      STS;                           /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  L2TM_L2TM_GLB_CTRL_t                     CTRL;                          /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  L2TM_L2TM_GLB_SPARE_CFG_t                SPARE_CFG;                     /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  L2TM_L2TM_GLB_SPARE_STS_t                SPARE_STS;                     /* addr: 0x00000018 */
} APB0_L2TM_L2TM_GLB_t;


/*
 * l2tm_bm
 */
        
#define L2TM_L2TM_BM_INT                         0xf4302100
#define L2TM_L2TM_BM_INT_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sb_drop              :  1 ; /* bits 0:0 */
    ca_uint32_t hdr_drop             :  1 ; /* bits 1:1 */
    ca_uint32_t te_drop              :  1 ; /* bits 2:2 */
    ca_uint32_t wvoqid               :  1 ; /* bits 3:3 */
    ca_uint32_t szerr                :  1 ; /* bits 4:4 */
    ca_uint32_t seglenerr            :  1 ; /* bits 5:5 */
    ca_uint32_t seq_err              :  1 ; /* bits 6:6 */
    ca_uint32_t fc_mirror_drop       :  1 ; /* bits 7:7 */
    ca_uint32_t dq_sb_drop           :  1 ; /* bits 8:8 */
    ca_uint32_t dq_hdr_drop          :  1 ; /* bits 9:9 */
    ca_uint32_t dq_wvoqid            :  1 ; /* bits 10:10 */
    ca_uint32_t dq_szerr             :  1 ; /* bits 11:11 */
    ca_uint32_t dq_seglenerr         :  1 ; /* bits 12:12 */
    ca_uint32_t dq_seq_err           :  1 ; /* bits 13:13 */
    ca_uint32_t dq_ff_undrflo        :  1 ; /* bits 14:14 */
    ca_uint32_t dq_ff_ovrflo         :  1 ; /* bits 15:15 */
    ca_uint32_t dq_pack_ff_undrflo   :  1 ; /* bits 16:16 */
    ca_uint32_t dq_pack_ff_ovrflo    :  1 ; /* bits 17:17 */
    ca_uint32_t fe_ff_undrflo        :  1 ; /* bits 18:18 */
    ca_uint32_t fe_ff_ovrflo         :  1 ; /* bits 19:19 */
    ca_uint32_t pack_ff_undrflo      :  1 ; /* bits 20:20 */
    ca_uint32_t pack_ff_ovrflo       :  1 ; /* bits 21:21 */
    ca_uint32_t wdat_ff_undrflo      :  1 ; /* bits 22:22 */
    ca_uint32_t wdat_ff_ovrflo       :  1 ; /* bits 23:23 */
    ca_uint32_t wcmd_ff_undrflo      :  1 ; /* bits 24:24 */
    ca_uint32_t wcmd_ff_ovrflo       :  1 ; /* bits 25:25 */
    ca_uint32_t rdat_ff_undrflo      :  1 ; /* bits 26:26 */
    ca_uint32_t rdat_ff_ovrflo       :  1 ; /* bits 27:27 */
    ca_uint32_t rcmd_ff_undrflo      :  1 ; /* bits 28:28 */
    ca_uint32_t rcmd_ff_ovrflo       :  1 ; /* bits 29:29 */
    ca_uint32_t rcyc_ff_undrflo      :  1 ; /* bits 30:30 */
    ca_uint32_t rcyc_ff_ovrflo       :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_INT_t;


#define L2TM_L2TM_BM_INTE                        0xf4302104
#define L2TM_L2TM_BM_INTE_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sb_dropE             :  1 ; /* bits 0:0 */
    ca_uint32_t hdr_dropE            :  1 ; /* bits 1:1 */
    ca_uint32_t te_dropE             :  1 ; /* bits 2:2 */
    ca_uint32_t wvoqidE              :  1 ; /* bits 3:3 */
    ca_uint32_t szerrE               :  1 ; /* bits 4:4 */
    ca_uint32_t seglenerrE           :  1 ; /* bits 5:5 */
    ca_uint32_t seq_errE             :  1 ; /* bits 6:6 */
    ca_uint32_t fc_mirror_dropE      :  1 ; /* bits 7:7 */
    ca_uint32_t dq_sb_dropE          :  1 ; /* bits 8:8 */
    ca_uint32_t dq_hdr_dropE         :  1 ; /* bits 9:9 */
    ca_uint32_t dq_wvoqidE           :  1 ; /* bits 10:10 */
    ca_uint32_t dq_szerrE            :  1 ; /* bits 11:11 */
    ca_uint32_t dq_seglenerrE        :  1 ; /* bits 12:12 */
    ca_uint32_t dq_seq_errE          :  1 ; /* bits 13:13 */
    ca_uint32_t dq_ff_undrfloE       :  1 ; /* bits 14:14 */
    ca_uint32_t dq_ff_ovrfloE        :  1 ; /* bits 15:15 */
    ca_uint32_t dq_pack_ff_undrfloE  :  1 ; /* bits 16:16 */
    ca_uint32_t dq_pack_ff_ovrfloE   :  1 ; /* bits 17:17 */
    ca_uint32_t fe_ff_undrfloE       :  1 ; /* bits 18:18 */
    ca_uint32_t fe_ff_ovrfloE        :  1 ; /* bits 19:19 */
    ca_uint32_t pack_ff_undrfloE     :  1 ; /* bits 20:20 */
    ca_uint32_t pack_ff_ovrfloE      :  1 ; /* bits 21:21 */
    ca_uint32_t wdat_ff_undrfloE     :  1 ; /* bits 22:22 */
    ca_uint32_t wdat_ff_ovrfloE      :  1 ; /* bits 23:23 */
    ca_uint32_t wcmd_ff_undrfloE     :  1 ; /* bits 24:24 */
    ca_uint32_t wcmd_ff_ovrfloE      :  1 ; /* bits 25:25 */
    ca_uint32_t rdat_ff_undrfloE     :  1 ; /* bits 26:26 */
    ca_uint32_t rdat_ff_ovrfloE      :  1 ; /* bits 27:27 */
    ca_uint32_t rcmd_ff_undrfloE     :  1 ; /* bits 28:28 */
    ca_uint32_t rcmd_ff_ovrfloE      :  1 ; /* bits 29:29 */
    ca_uint32_t rcyc_ff_undrfloE     :  1 ; /* bits 30:30 */
    ca_uint32_t rcyc_ff_ovrfloE      :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_INTE_t;


#define L2TM_L2TM_BM_CTRL                        0xf4302108
#define L2TM_L2TM_BM_CTRL_dft                    0xc0000000

typedef volatile union {
  struct {
    ca_uint32_t rx_drop_cos          :  3 ; /* bits 2:0 */
    ca_uint32_t rx_drop_pid          :  4 ; /* bits 6:3 */
    ca_uint32_t rx_drop_en           :  2 ; /* bits 8:7 */
    ca_uint32_t sb_drop_dis          :  1 ; /* bits 9:9 */
    ca_uint32_t hdr_drop_code_upd_en :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd1               : 13 ;
    ca_uint32_t min_pktlen           :  7 ; /* bits 30:24 */
    ca_uint32_t rx_en                :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_CTRL_t;


#define L2TM_L2TM_BM_TM_TO_9THQ_QUEUE_MAP        0xf430210c
#define L2TM_L2TM_BM_TM_TO_9THQ_QUEUE_MAP_dft    0x76543210

typedef volatile union {
  struct {
    ca_uint32_t qsel_0               :  3 ; /* bits 2:0 */
    ca_uint32_t flag_0               :  1 ; /* bits 3:3 */
    ca_uint32_t qsel_1               :  3 ; /* bits 6:4 */
    ca_uint32_t flag_1               :  1 ; /* bits 7:7 */
    ca_uint32_t qsel_2               :  3 ; /* bits 10:8 */
    ca_uint32_t flag_2               :  1 ; /* bits 11:11 */
    ca_uint32_t qsel_3               :  3 ; /* bits 14:12 */
    ca_uint32_t flag_3               :  1 ; /* bits 15:15 */
    ca_uint32_t qsel_4               :  3 ; /* bits 18:16 */
    ca_uint32_t flag_4               :  1 ; /* bits 19:19 */
    ca_uint32_t qsel_5               :  3 ; /* bits 22:20 */
    ca_uint32_t flag_5               :  1 ; /* bits 23:23 */
    ca_uint32_t qsel_6               :  3 ; /* bits 26:24 */
    ca_uint32_t flag_6               :  1 ; /* bits 27:27 */
    ca_uint32_t qsel_7               :  3 ; /* bits 30:28 */
    ca_uint32_t flag_7               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_TM_TO_9THQ_QUEUE_MAP_t;


#define L2TM_L2TM_BM_TM_TO_CPUQ_QUEUE_MAP        0xf4302110
#define L2TM_L2TM_BM_TM_TO_CPUQ_QUEUE_MAP_dft    0x76543210

typedef volatile union {
  struct {
    ca_uint32_t qsel_0               :  3 ; /* bits 2:0 */
    ca_uint32_t flag_0               :  1 ; /* bits 3:3 */
    ca_uint32_t qsel_1               :  3 ; /* bits 6:4 */
    ca_uint32_t flag_1               :  1 ; /* bits 7:7 */
    ca_uint32_t qsel_2               :  3 ; /* bits 10:8 */
    ca_uint32_t flag_2               :  1 ; /* bits 11:11 */
    ca_uint32_t qsel_3               :  3 ; /* bits 14:12 */
    ca_uint32_t flag_3               :  1 ; /* bits 15:15 */
    ca_uint32_t qsel_4               :  3 ; /* bits 18:16 */
    ca_uint32_t flag_4               :  1 ; /* bits 19:19 */
    ca_uint32_t qsel_5               :  3 ; /* bits 22:20 */
    ca_uint32_t flag_5               :  1 ; /* bits 23:23 */
    ca_uint32_t qsel_6               :  3 ; /* bits 26:24 */
    ca_uint32_t flag_6               :  1 ; /* bits 27:27 */
    ca_uint32_t qsel_7               :  3 ; /* bits 30:28 */
    ca_uint32_t flag_7               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_TM_TO_CPUQ_QUEUE_MAP_t;


#define L2TM_L2TM_BM_TM_TO_CPU256Q_QUEUE_MAP     0xf4302114
#define L2TM_L2TM_BM_TM_TO_CPU256Q_QUEUE_MAP_dft 0x00000076

typedef volatile union {
  struct {
    ca_uint32_t qsel_0               :  3 ; /* bits 2:0 */
    ca_uint32_t flag_0               :  1 ; /* bits 3:3 */
    ca_uint32_t qsel_1               :  3 ; /* bits 6:4 */
    ca_uint32_t flag_1               :  1 ; /* bits 7:7 */
    ca_uint32_t rxpfc_0              :  1 ; /* bits 8:8 */
    ca_uint32_t rxpfc_1              :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_TM_TO_CPU256Q_QUEUE_MAP_t;


#define L2TM_L2TM_BM_TM_TO_DQ_QUEUE_MAP          0xf4302118
#define L2TM_L2TM_BM_TM_TO_DQ_QUEUE_MAP_dft      0x76543210

typedef volatile union {
  struct {
    ca_uint32_t qsel_0               :  3 ; /* bits 2:0 */
    ca_uint32_t flag_0               :  1 ; /* bits 3:3 */
    ca_uint32_t qsel_1               :  3 ; /* bits 6:4 */
    ca_uint32_t flag_1               :  1 ; /* bits 7:7 */
    ca_uint32_t qsel_2               :  3 ; /* bits 10:8 */
    ca_uint32_t flag_2               :  1 ; /* bits 11:11 */
    ca_uint32_t qsel_3               :  3 ; /* bits 14:12 */
    ca_uint32_t flag_3               :  1 ; /* bits 15:15 */
    ca_uint32_t qsel_4               :  3 ; /* bits 18:16 */
    ca_uint32_t flag_4               :  1 ; /* bits 19:19 */
    ca_uint32_t qsel_5               :  3 ; /* bits 22:20 */
    ca_uint32_t flag_5               :  1 ; /* bits 23:23 */
    ca_uint32_t qsel_6               :  3 ; /* bits 26:24 */
    ca_uint32_t flag_6               :  1 ; /* bits 27:27 */
    ca_uint32_t qsel_7               :  3 ; /* bits 30:28 */
    ca_uint32_t flag_7               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_TM_TO_DQ_QUEUE_MAP_t;


#define L2TM_L2TM_BM_DQ_TO_TM_QUEUE_MAP          0xf430211c
#define L2TM_L2TM_BM_DQ_TO_TM_QUEUE_MAP_dft      0x76543210

typedef volatile union {
  struct {
    ca_uint32_t qsel_0               :  3 ; /* bits 2:0 */
    ca_uint32_t flag_0               :  1 ; /* bits 3:3 */
    ca_uint32_t qsel_1               :  3 ; /* bits 6:4 */
    ca_uint32_t flag_1               :  1 ; /* bits 7:7 */
    ca_uint32_t qsel_2               :  3 ; /* bits 10:8 */
    ca_uint32_t flag_2               :  1 ; /* bits 11:11 */
    ca_uint32_t qsel_3               :  3 ; /* bits 14:12 */
    ca_uint32_t flag_3               :  1 ; /* bits 15:15 */
    ca_uint32_t qsel_4               :  3 ; /* bits 18:16 */
    ca_uint32_t flag_4               :  1 ; /* bits 19:19 */
    ca_uint32_t qsel_5               :  3 ; /* bits 22:20 */
    ca_uint32_t flag_5               :  1 ; /* bits 23:23 */
    ca_uint32_t qsel_6               :  3 ; /* bits 26:24 */
    ca_uint32_t flag_6               :  1 ; /* bits 27:27 */
    ca_uint32_t qsel_7               :  3 ; /* bits 30:28 */
    ca_uint32_t flag_7               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_DQ_TO_TM_QUEUE_MAP_t;


#define L2TM_L2TM_BM_DQ_TO_TM_PORT_MAP           0xf4302120
#define L2TM_L2TM_BM_DQ_TO_TM_PORT_MAP_dft       0x76543210

typedef volatile union {
  struct {
    ca_uint32_t tm_dpid_sel_0        :  4 ; /* bits 3:0 */
    ca_uint32_t tm_dpid_sel_1        :  4 ; /* bits 7:4 */
    ca_uint32_t tm_dpid_sel_2        :  4 ; /* bits 11:8 */
    ca_uint32_t tm_dpid_sel_3        :  4 ; /* bits 15:12 */
    ca_uint32_t tm_dpid_sel_4        :  4 ; /* bits 19:16 */
    ca_uint32_t tm_dpid_sel_5        :  4 ; /* bits 23:20 */
    ca_uint32_t tm_dpid_sel_6        :  4 ; /* bits 27:24 */
    ca_uint32_t tm_dpid_sel_7        :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_DQ_TO_TM_PORT_MAP_t;


#define L2TM_L2TM_BM_RX_DQ_PCNT                  0xf4302124
#define L2TM_L2TM_BM_RX_DQ_PCNT_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_RX_DQ_PCNT_t;


#define L2TM_L2TM_BM_RX_DQ_DPCNT                 0xf4302128
#define L2TM_L2TM_BM_RX_DQ_DPCNT_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_RX_DQ_DPCNT_t;


#define L2TM_L2TM_BM_RX_PCNT                     0xf430212c
#define L2TM_L2TM_BM_RX_PCNT_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_RX_PCNT_t;


#define L2TM_L2TM_BM_TX_PCNT                     0xf4302130
#define L2TM_L2TM_BM_TX_PCNT_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_TX_PCNT_t;


#define L2TM_L2TM_BM_SB_DPCNT                    0xf4302134
#define L2TM_L2TM_BM_SB_DPCNT_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_SB_DPCNT_t;


#define L2TM_L2TM_BM_HDR_DPCNT                   0xf4302138
#define L2TM_L2TM_BM_HDR_DPCNT_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_HDR_DPCNT_t;


#define L2TM_L2TM_BM_TE_DPCNT                    0xf430213c
#define L2TM_L2TM_BM_TE_DPCNT_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_TE_DPCNT_t;


#define L2TM_L2TM_BM_ERR_DPCNT                   0xf4302140
#define L2TM_L2TM_BM_ERR_DPCNT_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_ERR_DPCNT_t;


#define L2TM_L2TM_BM_FC_MIRROR0_DPCNT            0xf4302144
#define L2TM_L2TM_BM_FC_MIRROR0_DPCNT_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_FC_MIRROR0_DPCNT_t;


#define L2TM_L2TM_BM_FC_MIRROR1_DPCNT            0xf4302148
#define L2TM_L2TM_BM_FC_MIRROR1_DPCNT_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_FC_MIRROR1_DPCNT_t;


#define L2TM_L2TM_BM_FC_MIRROR2_DPCNT            0xf430214c
#define L2TM_L2TM_BM_FC_MIRROR2_DPCNT_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_FC_MIRROR2_DPCNT_t;


#define L2TM_L2TM_BM_FC_MIRROR3_DPCNT            0xf4302150
#define L2TM_L2TM_BM_FC_MIRROR3_DPCNT_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_FC_MIRROR3_DPCNT_t;


#define L2TM_L2TM_BM_RX_DPCNT                    0xf4302154
#define L2TM_L2TM_BM_RX_DPCNT_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_RX_DPCNT_t;


#define L2TM_L2TM_BM_NOBUF_DPCNT                 0xf4302158
#define L2TM_L2TM_BM_NOBUF_DPCNT_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_NOBUF_DPCNT_t;


#define L2TM_L2TM_BM_RX_FE_HEADER_31_0           0xf430215c
#define L2TM_L2TM_BM_RX_FE_HEADER_31_0_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_RX_FE_HEADER_31_0_t;


#define L2TM_L2TM_BM_RX_FE_HEADER_63_32          0xf4302160
#define L2TM_L2TM_BM_RX_FE_HEADER_63_32_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_RX_FE_HEADER_63_32_t;


#define L2TM_L2TM_BM_RX_NI_HEADER_31_0           0xf4302164
#define L2TM_L2TM_BM_RX_NI_HEADER_31_0_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_RX_NI_HEADER_31_0_t;


#define L2TM_L2TM_BM_RX_NI_HEADER_63_32          0xf4302168
#define L2TM_L2TM_BM_RX_NI_HEADER_63_32_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_RX_NI_HEADER_63_32_t;


#define L2TM_L2TM_BM_TX_NI_HEADER_31_0           0xf430216c
#define L2TM_L2TM_BM_TX_NI_HEADER_31_0_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_TX_NI_HEADER_31_0_t;


#define L2TM_L2TM_BM_TX_NI_HEADER_63_32          0xf4302170
#define L2TM_L2TM_BM_TX_NI_HEADER_63_32_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_TX_NI_HEADER_63_32_t;


#define L2TM_L2TM_BM_STS                         0xf4302174
#define L2TM_L2TM_BM_STS_dft                     0xff80000a

typedef volatile union {
  struct {
    ca_uint32_t fe_tm_vld            :  1 ; /* bits 0:0 */
    ca_uint32_t tm_fe_rdy            :  1 ; /* bits 1:1 */
    ca_uint32_t ni_tm_vld            :  1 ; /* bits 2:2 */
    ca_uint32_t tm_ni_rdy            :  1 ; /* bits 3:3 */
    ca_uint32_t tm_ni_vld            :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 18 ;
    ca_uint32_t dq_ff_empty          :  1 ; /* bits 23:23 */
    ca_uint32_t dq_pack_ff_empty     :  1 ; /* bits 24:24 */
    ca_uint32_t fe_ff_empty          :  1 ; /* bits 25:25 */
    ca_uint32_t pack_ff_empty        :  1 ; /* bits 26:26 */
    ca_uint32_t wdat_ff_empty        :  1 ; /* bits 27:27 */
    ca_uint32_t wcmd_ff_empty        :  1 ; /* bits 28:28 */
    ca_uint32_t rdat_ff_empty        :  1 ; /* bits 29:29 */
    ca_uint32_t rcmd_ff_empty        :  1 ; /* bits 30:30 */
    ca_uint32_t rcyc_ff_empty        :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_STS_t;


#define L2TM_L2TM_BM_PKT_MEM_ACCESS              0xf4302178
#define L2TM_L2TM_BM_PKT_MEM_ACCESS_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 15 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_PKT_MEM_ACCESS_t;


#define L2TM_L2TM_BM_PKT_MEM_DATA7               0xf430217c
#define L2TM_L2TM_BM_PKT_MEM_DATA7_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_PKT_MEM_DATA7_t;


#define L2TM_L2TM_BM_PKT_MEM_DATA6               0xf4302180
#define L2TM_L2TM_BM_PKT_MEM_DATA6_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_PKT_MEM_DATA6_t;


#define L2TM_L2TM_BM_PKT_MEM_DATA5               0xf4302184
#define L2TM_L2TM_BM_PKT_MEM_DATA5_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_PKT_MEM_DATA5_t;


#define L2TM_L2TM_BM_PKT_MEM_DATA4               0xf4302188
#define L2TM_L2TM_BM_PKT_MEM_DATA4_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_PKT_MEM_DATA4_t;


#define L2TM_L2TM_BM_PKT_MEM_DATA3               0xf430218c
#define L2TM_L2TM_BM_PKT_MEM_DATA3_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_PKT_MEM_DATA3_t;


#define L2TM_L2TM_BM_PKT_MEM_DATA2               0xf4302190
#define L2TM_L2TM_BM_PKT_MEM_DATA2_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_PKT_MEM_DATA2_t;


#define L2TM_L2TM_BM_PKT_MEM_DATA1               0xf4302194
#define L2TM_L2TM_BM_PKT_MEM_DATA1_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_PKT_MEM_DATA1_t;


#define L2TM_L2TM_BM_PKT_MEM_DATA0               0xf4302198
#define L2TM_L2TM_BM_PKT_MEM_DATA0_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_BM_PKT_MEM_DATA0_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2tm_bm */
typedef struct {
  L2TM_L2TM_BM_INT_t                       INT;                           /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  L2TM_L2TM_BM_INTE_t                      INTE;                          /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  L2TM_L2TM_BM_CTRL_t                      CTRL;                          /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  L2TM_L2TM_BM_TM_TO_9THQ_QUEUE_MAP_t      TM_TO_9THQ_QUEUE_MAP;          /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  L2TM_L2TM_BM_TM_TO_CPUQ_QUEUE_MAP_t      TM_TO_CPUQ_QUEUE_MAP;          /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  L2TM_L2TM_BM_TM_TO_CPU256Q_QUEUE_MAP_t   TM_TO_CPU256Q_QUEUE_MAP;       /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  L2TM_L2TM_BM_TM_TO_DQ_QUEUE_MAP_t        TM_TO_DQ_QUEUE_MAP;            /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  L2TM_L2TM_BM_DQ_TO_TM_QUEUE_MAP_t        DQ_TO_TM_QUEUE_MAP;            /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  L2TM_L2TM_BM_DQ_TO_TM_PORT_MAP_t         DQ_TO_TM_PORT_MAP;             /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  L2TM_L2TM_BM_RX_DQ_PCNT_t                RX_DQ_PCNT;                    /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  L2TM_L2TM_BM_RX_DQ_DPCNT_t               RX_DQ_DPCNT;                   /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  L2TM_L2TM_BM_RX_PCNT_t                   RX_PCNT;                       /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  L2TM_L2TM_BM_TX_PCNT_t                   TX_PCNT;                       /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  L2TM_L2TM_BM_SB_DPCNT_t                  SB_DPCNT;                      /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  L2TM_L2TM_BM_HDR_DPCNT_t                 HDR_DPCNT;                     /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  L2TM_L2TM_BM_TE_DPCNT_t                  TE_DPCNT;                      /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  L2TM_L2TM_BM_ERR_DPCNT_t                 ERR_DPCNT;                     /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  L2TM_L2TM_BM_FC_MIRROR0_DPCNT_t          FC_MIRROR0_DPCNT;              /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  L2TM_L2TM_BM_FC_MIRROR1_DPCNT_t          FC_MIRROR1_DPCNT;              /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  L2TM_L2TM_BM_FC_MIRROR2_DPCNT_t          FC_MIRROR2_DPCNT;              /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  L2TM_L2TM_BM_FC_MIRROR3_DPCNT_t          FC_MIRROR3_DPCNT;              /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  L2TM_L2TM_BM_RX_DPCNT_t                  RX_DPCNT;                      /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  L2TM_L2TM_BM_NOBUF_DPCNT_t               NOBUF_DPCNT;                   /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  L2TM_L2TM_BM_RX_FE_HEADER_31_0_t         RX_FE_HEADER_31_0;             /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  L2TM_L2TM_BM_RX_FE_HEADER_63_32_t        RX_FE_HEADER_63_32;            /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  L2TM_L2TM_BM_RX_NI_HEADER_31_0_t         RX_NI_HEADER_31_0;             /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  L2TM_L2TM_BM_RX_NI_HEADER_63_32_t        RX_NI_HEADER_63_32;            /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  L2TM_L2TM_BM_TX_NI_HEADER_31_0_t         TX_NI_HEADER_31_0;             /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  L2TM_L2TM_BM_TX_NI_HEADER_63_32_t        TX_NI_HEADER_63_32;            /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  L2TM_L2TM_BM_STS_t                       STS;                           /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  L2TM_L2TM_BM_PKT_MEM_ACCESS_t            PKT_MEM_ACCESS;                /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  L2TM_L2TM_BM_PKT_MEM_DATA7_t             PKT_MEM_DATA7;                 /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  L2TM_L2TM_BM_PKT_MEM_DATA6_t             PKT_MEM_DATA6;                 /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  L2TM_L2TM_BM_PKT_MEM_DATA5_t             PKT_MEM_DATA5;                 /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  L2TM_L2TM_BM_PKT_MEM_DATA4_t             PKT_MEM_DATA4;                 /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  L2TM_L2TM_BM_PKT_MEM_DATA3_t             PKT_MEM_DATA3;                 /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  L2TM_L2TM_BM_PKT_MEM_DATA2_t             PKT_MEM_DATA2;                 /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  L2TM_L2TM_BM_PKT_MEM_DATA1_t             PKT_MEM_DATA1;                 /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  L2TM_L2TM_BM_PKT_MEM_DATA0_t             PKT_MEM_DATA0;                 /* addr: 0x00000098 */
} APB0_L2TM_L2TM_BM_t;


/*
 * l2tm_qm
 */
        
#define L2TM_L2TM_QM_INT                         0xf4302200
#define L2TM_L2TM_QM_INT_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t freeq_ecc_correctederr :  1 ; /* bits 0:0 */
    ca_uint32_t freeq_ecc_err        :  1 ; /* bits 1:1 */
    ca_uint32_t voqinfo_ecc_correctederr :  1 ; /* bits 2:2 */
    ca_uint32_t voqinfo_ecc_err      :  1 ; /* bits 3:3 */
    ca_uint32_t nobuf_drop           :  1 ; /* bits 4:4 */
    ca_uint32_t bid_out_of_range     :  1 ; /* bits 5:5 */
    ca_uint32_t wr_race_err          :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               :  9 ;
    ca_uint32_t eq0_stack_err        :  1 ; /* bits 16:16 */
    ca_uint32_t eq1_stack_err        :  1 ; /* bits 17:17 */
    ca_uint32_t enq_ff_undrflo       :  1 ; /* bits 18:18 */
    ca_uint32_t enq_ff_ovrflo        :  1 ; /* bits 19:19 */
    ca_uint32_t deq_ff_undrflo       :  1 ; /* bits 20:20 */
    ca_uint32_t deq_ff_ovrflo        :  1 ; /* bits 21:21 */
    ca_uint32_t rsrvd2               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_INT_t;


#define L2TM_L2TM_QM_INTE                        0xf4302204
#define L2TM_L2TM_QM_INTE_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t freeq_ecc_correctederrE :  1 ; /* bits 0:0 */
    ca_uint32_t freeq_ecc_errE       :  1 ; /* bits 1:1 */
    ca_uint32_t voqinfo_ecc_correctederrE :  1 ; /* bits 2:2 */
    ca_uint32_t voqinfo_ecc_errE     :  1 ; /* bits 3:3 */
    ca_uint32_t nobuf_dropE          :  1 ; /* bits 4:4 */
    ca_uint32_t bid_out_of_rangeE    :  1 ; /* bits 5:5 */
    ca_uint32_t wr_race_errE         :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               :  9 ;
    ca_uint32_t eq0_stack_errE       :  1 ; /* bits 16:16 */
    ca_uint32_t eq1_stack_errE       :  1 ; /* bits 17:17 */
    ca_uint32_t enq_ff_undrfloE      :  1 ; /* bits 18:18 */
    ca_uint32_t enq_ff_ovrfloE       :  1 ; /* bits 19:19 */
    ca_uint32_t deq_ff_undrfloE      :  1 ; /* bits 20:20 */
    ca_uint32_t deq_ff_ovrfloE       :  1 ; /* bits 21:21 */
    ca_uint32_t rsrvd2               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_INTE_t;


#define L2TM_L2TM_QM_EQ_CFG                      0xf4302208
#define L2TM_L2TM_QM_EQ_CFG_dft                  0x00040008

typedef volatile union {
  struct {
    ca_uint32_t eq0_bufnum           :  5 ; /* bits 4:0 */
    ca_uint32_t eq0_prvt             : 11 ; /* bits 15:5 */
    ca_uint32_t eq1_bufnum           :  4 ; /* bits 19:16 */
    ca_uint32_t eq1_prvt             : 10 ; /* bits 29:20 */
    ca_uint32_t eq0_en               :  1 ; /* bits 30:30 */
    ca_uint32_t eq1_en               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_EQ_CFG_t;


#define L2TM_L2TM_QM_EQ_CFG1                     0xf430220c
#define L2TM_L2TM_QM_EQ_CFG1_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t eq0_buffer_weight    :  1 ; /* bits 0:0 */
    ca_uint32_t eq1_buffer_weight    :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_EQ_CFG1_t;


#define L2TM_L2TM_QM_GLOB_BUF_CFG                0xf4302210
#define L2TM_L2TM_QM_GLOB_BUF_CFG_dft            0x90000020

typedef volatile union {
  struct {
    ca_uint32_t nodrop               : 15 ; /* bits 14:0 */
    ca_uint32_t drop_en              :  1 ; /* bits 15:15 */
    ca_uint32_t noncong              : 15 ; /* bits 30:16 */
    ca_uint32_t fe_bp_en             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_GLOB_BUF_CFG_t;


#define L2TM_L2TM_QM_GLOB_BUF_CFG1               0xf4302214
#define L2TM_L2TM_QM_GLOB_BUF_CFG1_dft           0x00000010

typedef volatile union {
  struct {
    ca_uint32_t fe_bp_th             : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_GLOB_BUF_CFG1_t;


#define L2TM_L2TM_QM_PORT_PRVT_PROFILE0          0xf4302218
#define L2TM_L2TM_QM_PORT_PRVT_PROFILE0_dft      0x00100000

typedef volatile union {
  struct {
    ca_uint32_t cnt_even             : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t cnt_odd              : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_PORT_PRVT_PROFILE0_t;


#define L2TM_L2TM_QM_PORT_PRVT_PROFILE1          0xf430221c
#define L2TM_L2TM_QM_PORT_PRVT_PROFILE1_dft      0x00400020

typedef volatile union {
  struct {
    ca_uint32_t cnt_even             : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t cnt_odd              : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_PORT_PRVT_PROFILE1_t;


#define L2TM_L2TM_QM_PORT_PRVT_PROFILE2          0xf4302220
#define L2TM_L2TM_QM_PORT_PRVT_PROFILE2_dft      0x00c00080

typedef volatile union {
  struct {
    ca_uint32_t cnt_even             : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t cnt_odd              : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_PORT_PRVT_PROFILE2_t;


#define L2TM_L2TM_QM_PORT_PRVT_PROFILE3          0xf4302224
#define L2TM_L2TM_QM_PORT_PRVT_PROFILE3_dft      0x01400100

typedef volatile union {
  struct {
    ca_uint32_t cnt_even             : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t cnt_odd              : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_PORT_PRVT_PROFILE3_t;


#define L2TM_L2TM_QM_PORT_PRVT_SELECT0           0xf4302228
#define L2TM_L2TM_QM_PORT_PRVT_SELECT0_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t port0                :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t port1                :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t port2                :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t port3                :  3 ; /* bits 14:12 */
    ca_uint32_t rsrvd4               :  1 ;
    ca_uint32_t port4                :  3 ; /* bits 18:16 */
    ca_uint32_t rsrvd5               :  1 ;
    ca_uint32_t port5                :  3 ; /* bits 22:20 */
    ca_uint32_t rsrvd6               :  1 ;
    ca_uint32_t port6                :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd7               :  1 ;
    ca_uint32_t port7                :  3 ; /* bits 30:28 */
    ca_uint32_t rsrvd8               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_PORT_PRVT_SELECT0_t;


#define L2TM_L2TM_QM_PORT_PRVT_SELECT1           0xf430222c
#define L2TM_L2TM_QM_PORT_PRVT_SELECT1_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t port0                :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t port1                :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t port2                :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t port3                :  3 ; /* bits 14:12 */
    ca_uint32_t rsrvd4               :  1 ;
    ca_uint32_t port4                :  3 ; /* bits 18:16 */
    ca_uint32_t rsrvd5               :  1 ;
    ca_uint32_t port5                :  3 ; /* bits 22:20 */
    ca_uint32_t rsrvd6               :  1 ;
    ca_uint32_t port6                :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd7               :  1 ;
    ca_uint32_t port7                :  3 ; /* bits 30:28 */
    ca_uint32_t rsrvd8               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_PORT_PRVT_SELECT1_t;


#define L2TM_L2TM_QM_PORT_NO_PRVT_STS            0xf4302230
#define L2TM_L2TM_QM_PORT_NO_PRVT_STS_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pid                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_PORT_NO_PRVT_STS_t;


#define L2TM_L2TM_QM_EQ_GLB_FREECNT              0xf4302234
#define L2TM_L2TM_QM_EQ_GLB_FREECNT_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sum_of_eqcnt         : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_EQ_GLB_FREECNT_t;


#define L2TM_L2TM_QM_EQ_COS0_BUFCNT              0xf4302238
#define L2TM_L2TM_QM_EQ_COS0_BUFCNT_STRIDE       4
#define L2TM_L2TM_QM_EQ_COS0_BUFCNT_COUNT        8
#define L2TM_L2TM_QM_EQ_COS0_BUFCNT_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sum_of_eqcnt         : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_EQ_COS0_BUFCNT_t;

                            
#define L2TM_L2TM_QM_PORT_PRVT_BUFCNT_MEM_ACCESS 0xf4302258
#define L2TM_L2TM_QM_PORT_PRVT_BUFCNT_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_PORT_PRVT_BUFCNT_MEM_ACCESS_t;


#define L2TM_L2TM_QM_PORT_PRVT_BUFCNT_MEM_DATA   0xf430225c
#define L2TM_L2TM_QM_PORT_PRVT_BUFCNT_MEM_DATA_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt0                 : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_PORT_PRVT_BUFCNT_MEM_DATA_t;


#define L2TM_L2TM_QM_EQ_FREECNT                  0xf4302260
#define L2TM_L2TM_QM_EQ_FREECNT_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t eq0                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t eq1                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_EQ_FREECNT_t;


#define L2TM_L2TM_QM_EQ_HEAD                     0xf4302264
#define L2TM_L2TM_QM_EQ_HEAD_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t eq0                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t eq1                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_EQ_HEAD_t;


#define L2TM_L2TM_QM_EQ0_STACK_CFG               0xf4302268
#define L2TM_L2TM_QM_EQ0_STACK_CFG_dft           0x00302010

typedef volatile union {
  struct {
    ca_uint32_t low_ths              :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t mid_ths              :  6 ; /* bits 13:8 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t high_ths             :  6 ; /* bits 21:16 */
    ca_uint32_t rsrvd3               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_EQ0_STACK_CFG_t;


#define L2TM_L2TM_QM_EQ0_STACK_CTRL              0xf430226c
#define L2TM_L2TM_QM_EQ0_STACK_CTRL_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t stack_unfill         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_EQ0_STACK_CTRL_t;


#define L2TM_L2TM_QM_EQ0_STACK_STS               0xf4302270
#define L2TM_L2TM_QM_EQ0_STACK_STS_dft           0x00000007

typedef volatile union {
  struct {
    ca_uint32_t stack_unfill_done    :  1 ; /* bits 0:0 */
    ca_uint32_t stack_idle           :  1 ; /* bits 1:1 */
    ca_uint32_t stack_empty          :  1 ; /* bits 2:2 */
    ca_uint32_t stack_full           :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 12 ;
    ca_uint32_t stack_cntr           :  6 ; /* bits 21:16 */
    ca_uint32_t rsrvd2               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_EQ0_STACK_STS_t;


#define L2TM_L2TM_QM_EQ1_STACK_CFG               0xf4302274
#define L2TM_L2TM_QM_EQ1_STACK_CFG_dft           0x00302010

typedef volatile union {
  struct {
    ca_uint32_t low_ths              :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t mid_ths              :  6 ; /* bits 13:8 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t high_ths             :  6 ; /* bits 21:16 */
    ca_uint32_t rsrvd3               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_EQ1_STACK_CFG_t;


#define L2TM_L2TM_QM_EQ1_STACK_CTRL              0xf4302278
#define L2TM_L2TM_QM_EQ1_STACK_CTRL_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t stack_unfill         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_EQ1_STACK_CTRL_t;


#define L2TM_L2TM_QM_EQ1_STACK_STS               0xf430227c
#define L2TM_L2TM_QM_EQ1_STACK_STS_dft           0x00000007

typedef volatile union {
  struct {
    ca_uint32_t stack_unfill_done    :  1 ; /* bits 0:0 */
    ca_uint32_t stack_idle           :  1 ; /* bits 1:1 */
    ca_uint32_t stack_empty          :  1 ; /* bits 2:2 */
    ca_uint32_t stack_full           :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 12 ;
    ca_uint32_t stack_cntr           :  6 ; /* bits 21:16 */
    ca_uint32_t rsrvd2               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_EQ1_STACK_STS_t;


#define L2TM_L2TM_QM_CTRL                        0xf4302280
#define L2TM_L2TM_QM_CTRL_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 31 ;
    ca_uint32_t force_init_done      :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_CTRL_t;


#define L2TM_L2TM_QM_STS                         0xf4302284
#define L2TM_L2TM_QM_STS_dft                     0x000c0000

typedef volatile union {
  struct {
    ca_uint32_t plm_nempty           : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t enq_ff_empty         :  1 ; /* bits 18:18 */
    ca_uint32_t deq_ff_empty         :  1 ; /* bits 19:19 */
    ca_uint32_t rsrvd2               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_STS_t;


#define L2TM_L2TM_QM_STS1                        0xf4302288
#define L2TM_L2TM_QM_STS1_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t init_adr             : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t init_data            :  8 ; /* bits 23:16 */
    ca_uint32_t freeq_cs             :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t sm_reset             :  1 ; /* bits 30:30 */
    ca_uint32_t init_done            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_STS1_t;


#define L2TM_L2TM_QM_STS2                        0xf430228c
#define L2TM_L2TM_QM_STS2_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t init_adr             :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               :  9 ;
    ca_uint32_t init_data            :  8 ; /* bits 23:16 */
    ca_uint32_t voqinfo_cs           :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t sm_reset             :  1 ; /* bits 30:30 */
    ca_uint32_t init_done            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_STS2_t;


#define L2TM_L2TM_QM_FREEQ_MEM_ACCESS            0xf4302290
#define L2TM_L2TM_QM_FREEQ_MEM_ACCESS_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 15 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_FREEQ_MEM_ACCESS_t;


#define L2TM_L2TM_QM_FREEQ_MEM_DATA1             0xf4302294
#define L2TM_L2TM_QM_FREEQ_MEM_DATA1_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ecc                  :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_FREEQ_MEM_DATA1_t;


#define L2TM_L2TM_QM_FREEQ_MEM_DATA0             0xf4302298
#define L2TM_L2TM_QM_FREEQ_MEM_DATA0_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t blen                 :  7 ; /* bits 6:0 */
    ca_uint32_t eqid                 :  1 ; /* bits 7:7 */
    ca_uint32_t eop                  :  1 ; /* bits 8:8 */
    ca_uint32_t sop                  :  1 ; /* bits 9:9 */
    ca_uint32_t cpu                  :  1 ; /* bits 10:10 */
    ca_uint32_t prvt                 :  1 ; /* bits 11:11 */
    ca_uint32_t nxt_ptr              : 15 ; /* bits 26:12 */
    ca_uint32_t ecc                  :  5 ; /* bits 31:27 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_FREEQ_MEM_DATA0_t;


#define L2TM_L2TM_QM_VOQINFO_MEM_ACCESS          0xf430229c
#define L2TM_L2TM_QM_VOQINFO_MEM_ACCESS_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_VOQINFO_MEM_ACCESS_t;


#define L2TM_L2TM_QM_VOQINFO_MEM_DATA1           0xf43022a0
#define L2TM_L2TM_QM_VOQINFO_MEM_DATA1_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tail_ptr             : 10 ; /* bits 9:0 */
    ca_uint32_t vallid               :  1 ; /* bits 10:10 */
    ca_uint32_t ecc                  :  7 ; /* bits 17:11 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_VOQINFO_MEM_DATA1_t;


#define L2TM_L2TM_QM_VOQINFO_MEM_DATA0           0xf43022a4
#define L2TM_L2TM_QM_VOQINFO_MEM_DATA0_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t blen                 :  7 ; /* bits 6:0 */
    ca_uint32_t eqid                 :  1 ; /* bits 7:7 */
    ca_uint32_t eop                  :  1 ; /* bits 8:8 */
    ca_uint32_t sop                  :  1 ; /* bits 9:9 */
    ca_uint32_t cpu                  :  1 ; /* bits 10:10 */
    ca_uint32_t prvt                 :  1 ; /* bits 11:11 */
    ca_uint32_t head_ptr             : 15 ; /* bits 26:12 */
    ca_uint32_t tail_ptr             :  5 ; /* bits 31:27 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_VOQINFO_MEM_DATA0_t;


#define L2TM_L2TM_QM_VOQ_PCNT_MEM_ACCESS         0xf43022a8
#define L2TM_L2TM_QM_VOQ_PCNT_MEM_ACCESS_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_VOQ_PCNT_MEM_ACCESS_t;


#define L2TM_L2TM_QM_VOQ_PCNT_MEM_DATA           0xf43022ac
#define L2TM_L2TM_QM_VOQ_PCNT_MEM_DATA_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt0                 : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_QM_VOQ_PCNT_MEM_DATA_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2tm_qm */
typedef struct {
  L2TM_L2TM_QM_INT_t                       INT;                           /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  L2TM_L2TM_QM_INTE_t                      INTE;                          /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  L2TM_L2TM_QM_EQ_CFG_t                    EQ_CFG;                        /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  L2TM_L2TM_QM_EQ_CFG1_t                   EQ_CFG1;                       /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  L2TM_L2TM_QM_GLOB_BUF_CFG_t              GLOB_BUF_CFG;                  /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  L2TM_L2TM_QM_GLOB_BUF_CFG1_t             GLOB_BUF_CFG1;                 /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  L2TM_L2TM_QM_PORT_PRVT_PROFILE0_t        PORT_PRVT_PROFILE0;            /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  L2TM_L2TM_QM_PORT_PRVT_PROFILE1_t        PORT_PRVT_PROFILE1;            /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  L2TM_L2TM_QM_PORT_PRVT_PROFILE2_t        PORT_PRVT_PROFILE2;            /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  L2TM_L2TM_QM_PORT_PRVT_PROFILE3_t        PORT_PRVT_PROFILE3;            /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  L2TM_L2TM_QM_PORT_PRVT_SELECT0_t         PORT_PRVT_SELECT0;             /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  L2TM_L2TM_QM_PORT_PRVT_SELECT1_t         PORT_PRVT_SELECT1;             /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  L2TM_L2TM_QM_PORT_NO_PRVT_STS_t          PORT_NO_PRVT_STS;              /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  L2TM_L2TM_QM_EQ_GLB_FREECNT_t            EQ_GLB_FREECNT;                /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  L2TM_L2TM_QM_EQ_COS0_BUFCNT_t            EQ_COS0_BUFCNT;                /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[31];                  
  L2TM_L2TM_QM_PORT_PRVT_BUFCNT_MEM_ACCESS_t PORT_PRVT_BUFCNT_MEM_ACCESS;   /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd16[3];                   
  L2TM_L2TM_QM_PORT_PRVT_BUFCNT_MEM_DATA_t PORT_PRVT_BUFCNT_MEM_DATA;     /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd17[3];                   
  L2TM_L2TM_QM_EQ_FREECNT_t                EQ_FREECNT;                    /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd18[3];                   
  L2TM_L2TM_QM_EQ_HEAD_t                   EQ_HEAD;                       /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd19[3];                   
  L2TM_L2TM_QM_EQ0_STACK_CFG_t             EQ0_STACK_CFG;                 /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd20[3];                   
  L2TM_L2TM_QM_EQ0_STACK_CTRL_t            EQ0_STACK_CTRL;                /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd21[3];                   
  L2TM_L2TM_QM_EQ0_STACK_STS_t             EQ0_STACK_STS;                 /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd22[3];                   
  L2TM_L2TM_QM_EQ1_STACK_CFG_t             EQ1_STACK_CFG;                 /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd23[3];                   
  L2TM_L2TM_QM_EQ1_STACK_CTRL_t            EQ1_STACK_CTRL;                /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd24[3];                   
  L2TM_L2TM_QM_EQ1_STACK_STS_t             EQ1_STACK_STS;                 /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd25[3];                   
  L2TM_L2TM_QM_CTRL_t                      CTRL;                          /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd26[3];                   
  L2TM_L2TM_QM_STS_t                       STS;                           /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd27[3];                   
  L2TM_L2TM_QM_STS1_t                      STS1;                          /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd28[3];                   
  L2TM_L2TM_QM_STS2_t                      STS2;                          /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd29[3];                   
  L2TM_L2TM_QM_FREEQ_MEM_ACCESS_t          FREEQ_MEM_ACCESS;              /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd30[3];                   
  L2TM_L2TM_QM_FREEQ_MEM_DATA1_t           FREEQ_MEM_DATA1;               /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd31[3];                   
  L2TM_L2TM_QM_FREEQ_MEM_DATA0_t           FREEQ_MEM_DATA0;               /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd32[3];                   
  L2TM_L2TM_QM_VOQINFO_MEM_ACCESS_t        VOQINFO_MEM_ACCESS;            /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd33[3];                   
  L2TM_L2TM_QM_VOQINFO_MEM_DATA1_t         VOQINFO_MEM_DATA1;             /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd34[3];                   
  L2TM_L2TM_QM_VOQINFO_MEM_DATA0_t         VOQINFO_MEM_DATA0;             /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd35[3];                   
  L2TM_L2TM_QM_VOQ_PCNT_MEM_ACCESS_t       VOQ_PCNT_MEM_ACCESS;           /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd36[3];                   
  L2TM_L2TM_QM_VOQ_PCNT_MEM_DATA_t         VOQ_PCNT_MEM_DATA;             /* addr: 0x000000ac */
} APB0_L2TM_L2TM_QM_t;


/*
 * l2tm_es
 */
        
#define L2TM_L2TM_ES_CTRL                        0xf4302300
#define L2TM_L2TM_ES_CTRL_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_port0_en          :  1 ; /* bits 0:0 */
    ca_uint32_t tx_port1_en          :  1 ; /* bits 1:1 */
    ca_uint32_t tx_port2_en          :  1 ; /* bits 2:2 */
    ca_uint32_t tx_port3_en          :  1 ; /* bits 3:3 */
    ca_uint32_t tx_port4_en          :  1 ; /* bits 4:4 */
    ca_uint32_t tx_port5_en          :  1 ; /* bits 5:5 */
    ca_uint32_t tx_port6_en          :  1 ; /* bits 6:6 */
    ca_uint32_t tx_port7_en          :  1 ; /* bits 7:7 */
    ca_uint32_t tx_port8_en          :  1 ; /* bits 8:8 */
    ca_uint32_t tx_port9_en          :  1 ; /* bits 9:9 */
    ca_uint32_t tx_port10_en         :  1 ; /* bits 10:10 */
    ca_uint32_t tx_port11_en         :  1 ; /* bits 11:11 */
    ca_uint32_t tx_port12_en         :  1 ; /* bits 12:12 */
    ca_uint32_t tx_port13_en         :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t tx_port15_en         :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd2               : 15 ;
    ca_uint32_t tx_en                :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_CTRL_t;


#define L2TM_L2TM_ES_SCH_CFG0                    0xf4302304
#define L2TM_L2TM_ES_SCH_CFG0_STRIDE             12
#define L2TM_L2TM_ES_SCH_CFG0_COUNT              15
#define L2TM_L2TM_ES_SCH_CFG0_dft                0x000400ff

typedef volatile union {
  struct {
    ca_uint32_t voq_en               :  8 ; /* bits 7:0 */
    ca_uint32_t flush_voqid          :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t flush_en             :  1 ; /* bits 15:15 */
    ca_uint32_t speed                :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd2               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_SCH_CFG0_t;


#define L2TM_L2TM_ES_VOQ3_0_WEIGHT_RATIO_CFG0    0xf4302308
#define L2TM_L2TM_ES_VOQ3_0_WEIGHT_RATIO_CFG0_STRIDE 12
#define L2TM_L2TM_ES_VOQ3_0_WEIGHT_RATIO_CFG0_COUNT 15
#define L2TM_L2TM_ES_VOQ3_0_WEIGHT_RATIO_CFG0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t voq0                 :  8 ; /* bits 7:0 */
    ca_uint32_t voq1                 :  8 ; /* bits 15:8 */
    ca_uint32_t voq2                 :  8 ; /* bits 23:16 */
    ca_uint32_t voq3                 :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_VOQ3_0_WEIGHT_RATIO_CFG0_t;


#define L2TM_L2TM_ES_VOQ7_4_WEIGHT_RATIO_CFG0    0xf430230c
#define L2TM_L2TM_ES_VOQ7_4_WEIGHT_RATIO_CFG0_STRIDE 12
#define L2TM_L2TM_ES_VOQ7_4_WEIGHT_RATIO_CFG0_COUNT 15
#define L2TM_L2TM_ES_VOQ7_4_WEIGHT_RATIO_CFG0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t voq4                 :  8 ; /* bits 7:0 */
    ca_uint32_t voq5                 :  8 ; /* bits 15:8 */
    ca_uint32_t voq6                 :  8 ; /* bits 23:16 */
    ca_uint32_t voq7                 :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_VOQ7_4_WEIGHT_RATIO_CFG0_t;

                                                                                                                                                                        
#define L2TM_L2TM_ES_PORT3_0_WEIGHT_RATIO_CFG    0xf43023b8
#define L2TM_L2TM_ES_PORT3_0_WEIGHT_RATIO_CFG_dft 0x01010101

typedef volatile union {
  struct {
    ca_uint32_t port0                :  8 ; /* bits 7:0 */
    ca_uint32_t port1                :  8 ; /* bits 15:8 */
    ca_uint32_t port2                :  8 ; /* bits 23:16 */
    ca_uint32_t port3                :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_PORT3_0_WEIGHT_RATIO_CFG_t;


#define L2TM_L2TM_ES_PORT7_4_WEIGHT_RATIO_CFG    0xf43023bc
#define L2TM_L2TM_ES_PORT7_4_WEIGHT_RATIO_CFG_dft 0x01010101

typedef volatile union {
  struct {
    ca_uint32_t port4                :  8 ; /* bits 7:0 */
    ca_uint32_t port5                :  8 ; /* bits 15:8 */
    ca_uint32_t port6                :  8 ; /* bits 23:16 */
    ca_uint32_t port7                :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_PORT7_4_WEIGHT_RATIO_CFG_t;


#define L2TM_L2TM_ES_PORT11_8_WEIGHT_RATIO_CFG   0xf43023c0
#define L2TM_L2TM_ES_PORT11_8_WEIGHT_RATIO_CFG_dft 0x01010101

typedef volatile union {
  struct {
    ca_uint32_t port8                :  8 ; /* bits 7:0 */
    ca_uint32_t port9                :  8 ; /* bits 15:8 */
    ca_uint32_t port10               :  8 ; /* bits 23:16 */
    ca_uint32_t port11               :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_PORT11_8_WEIGHT_RATIO_CFG_t;


#define L2TM_L2TM_ES_PORT15_12_WEIGHT_RATIO_CFG  0xf43023c4
#define L2TM_L2TM_ES_PORT15_12_WEIGHT_RATIO_CFG_dft 0x01000101

typedef volatile union {
  struct {
    ca_uint32_t port12               :  8 ; /* bits 7:0 */
    ca_uint32_t port13               :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t port15               :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_PORT15_12_WEIGHT_RATIO_CFG_t;


#define L2TM_L2TM_ES_DRR_WEIGHT_BASE             0xf43023c8
#define L2TM_L2TM_ES_DRR_WEIGHT_BASE_dft         0x00000014

typedef volatile union {
  struct {
    ca_uint32_t w_rate               :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t base_select          :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd2               :  5 ;
    ca_uint32_t dwrr_unit            :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd3               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_DRR_WEIGHT_BASE_t;


#define L2TM_L2TM_ES_CFG                         0xf43023cc
#define L2TM_L2TM_ES_CFG_dft                     0x00000340

typedef volatile union {
  struct {
    ca_uint32_t sch_ack_len          :  8 ; /* bits 7:0 */
    ca_uint32_t sch_sync_upd         :  1 ; /* bits 8:8 */
    ca_uint32_t sch_rr_grant         :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_CFG_t;


#define L2TM_L2TM_ES_STS                         0xf43023d0
#define L2TM_L2TM_ES_STS_dft                     0x00003fff

typedef volatile union {
  struct {
    ca_uint32_t ni_port_rdy          : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_STS_t;


#define L2TM_L2TM_ES_VOQ_STS0                    0xf43023d4
#define L2TM_L2TM_ES_VOQ_STS0_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t qid                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_VOQ_STS0_t;


#define L2TM_L2TM_ES_VOQ_STS1                    0xf43023d8
#define L2TM_L2TM_ES_VOQ_STS1_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t qid                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_VOQ_STS1_t;


#define L2TM_L2TM_ES_VOQ_STS2                    0xf43023dc
#define L2TM_L2TM_ES_VOQ_STS2_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t qid                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_VOQ_STS2_t;


#define L2TM_L2TM_ES_VOQ_STS3                    0xf43023e0
#define L2TM_L2TM_ES_VOQ_STS3_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t qid                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_VOQ_STS3_t;


#define L2TM_L2TM_ES_VOQ_OK_STS0                 0xf43023e4
#define L2TM_L2TM_ES_VOQ_OK_STS0_dft             0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t qid                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_VOQ_OK_STS0_t;


#define L2TM_L2TM_ES_VOQ_OK_STS1                 0xf43023e8
#define L2TM_L2TM_ES_VOQ_OK_STS1_dft             0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t qid                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_VOQ_OK_STS1_t;


#define L2TM_L2TM_ES_VOQ_OK_STS2                 0xf43023ec
#define L2TM_L2TM_ES_VOQ_OK_STS2_dft             0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t qid                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_VOQ_OK_STS2_t;


#define L2TM_L2TM_ES_VOQ_OK_STS3                 0xf43023f0
#define L2TM_L2TM_ES_VOQ_OK_STS3_dft             0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t qid                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_VOQ_OK_STS3_t;


#define L2TM_L2TM_ES_PORT_OK_STS                 0xf43023f4
#define L2TM_L2TM_ES_PORT_OK_STS_dft             0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t pid                  : 16 ; /* bits 15:0 */
    ca_uint32_t voq_grp              : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TM_ES_PORT_OK_STS_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2tm_es */
typedef struct {
  L2TM_L2TM_ES_CTRL_t                      CTRL;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  L2TM_L2TM_ES_SCH_CFG0_t                  SCH_CFG0;                      /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  L2TM_L2TM_ES_VOQ3_0_WEIGHT_RATIO_CFG0_t  VOQ3_0_WEIGHT_RATIO_CFG0;      /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  L2TM_L2TM_ES_VOQ7_4_WEIGHT_RATIO_CFG0_t  VOQ7_4_WEIGHT_RATIO_CFG0;      /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[171];                  
  L2TM_L2TM_ES_PORT3_0_WEIGHT_RATIO_CFG_t  PORT3_0_WEIGHT_RATIO_CFG;      /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd5[3];                    
  L2TM_L2TM_ES_PORT7_4_WEIGHT_RATIO_CFG_t  PORT7_4_WEIGHT_RATIO_CFG;      /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd6[3];                    
  L2TM_L2TM_ES_PORT11_8_WEIGHT_RATIO_CFG_t PORT11_8_WEIGHT_RATIO_CFG;     /* addr: 0x000000c0 */
  ca_uint32_t                              rsrvd7[3];                    
  L2TM_L2TM_ES_PORT15_12_WEIGHT_RATIO_CFG_t PORT15_12_WEIGHT_RATIO_CFG;    /* addr: 0x000000c4 */
  ca_uint32_t                              rsrvd8[3];                    
  L2TM_L2TM_ES_DRR_WEIGHT_BASE_t           DRR_WEIGHT_BASE;               /* addr: 0x000000c8 */
  ca_uint32_t                              rsrvd9[3];                    
  L2TM_L2TM_ES_CFG_t                       CFG;                           /* addr: 0x000000cc */
  ca_uint32_t                              rsrvd10[3];                   
  L2TM_L2TM_ES_STS_t                       STS;                           /* addr: 0x000000d0 */
  ca_uint32_t                              rsrvd11[3];                   
  L2TM_L2TM_ES_VOQ_STS0_t                  VOQ_STS0;                      /* addr: 0x000000d4 */
  ca_uint32_t                              rsrvd12[3];                   
  L2TM_L2TM_ES_VOQ_STS1_t                  VOQ_STS1;                      /* addr: 0x000000d8 */
  ca_uint32_t                              rsrvd13[3];                   
  L2TM_L2TM_ES_VOQ_STS2_t                  VOQ_STS2;                      /* addr: 0x000000dc */
  ca_uint32_t                              rsrvd14[3];                   
  L2TM_L2TM_ES_VOQ_STS3_t                  VOQ_STS3;                      /* addr: 0x000000e0 */
  ca_uint32_t                              rsrvd15[3];                   
  L2TM_L2TM_ES_VOQ_OK_STS0_t               VOQ_OK_STS0;                   /* addr: 0x000000e4 */
  ca_uint32_t                              rsrvd16[3];                   
  L2TM_L2TM_ES_VOQ_OK_STS1_t               VOQ_OK_STS1;                   /* addr: 0x000000e8 */
  ca_uint32_t                              rsrvd17[3];                   
  L2TM_L2TM_ES_VOQ_OK_STS2_t               VOQ_OK_STS2;                   /* addr: 0x000000ec */
  ca_uint32_t                              rsrvd18[3];                   
  L2TM_L2TM_ES_VOQ_OK_STS3_t               VOQ_OK_STS3;                   /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd19[3];                   
  L2TM_L2TM_ES_PORT_OK_STS_t               PORT_OK_STS;                   /* addr: 0x000000f4 */
} APB0_L2TM_L2TM_ES_t;


/*
 * l2te_glb
 */
        
#define L2TM_L2TE_GLB_REV_ID                     0xf4302400
#define L2TM_L2TE_GLB_REV_ID_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t minor                : 16 ; /* bits 15:0 */
    ca_uint32_t major                : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_GLB_REV_ID_t;


#define L2TM_L2TE_GLB_CTRL                       0xf4302404
#define L2TM_L2TE_GLB_CTRL_dft                   0x07000000

typedef volatile union {
  struct {
    ca_uint32_t pol_en               :  1 ; /* bits 0:0 */
    ca_uint32_t shp_en               :  1 ; /* bits 1:1 */
    ca_uint32_t taildrop_en          :  1 ; /* bits 2:2 */
    ca_uint32_t wred_en              :  1 ; /* bits 3:3 */
    ca_uint32_t mark_ecn_en          :  1 ; /* bits 4:4 */
    ca_uint32_t pol_ecn_en           :  1 ; /* bits 5:5 */
    ca_uint32_t wred_ecn_en          :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               :  9 ;
    ca_uint32_t glb_deepq_port_rdy_en :  8 ; /* bits 23:16 */
    ca_uint32_t glb_deepq_port_rdy_id :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd2               :  4 ;
    ca_uint32_t force_init_done      :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_GLB_CTRL_t;


#define L2TM_L2TE_GLB_INT                        0xf4302408
#define L2TM_L2TE_GLB_INT_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pol_mark             :  1 ; /* bits 0:0 */
    ca_uint32_t pol_drop             :  1 ; /* bits 1:1 */
    ca_uint32_t tail_drop            :  1 ; /* bits 2:2 */
    ca_uint32_t wred_y_drop          :  1 ; /* bits 3:3 */
    ca_uint32_t wred_g_drop          :  1 ; /* bits 4:4 */
    ca_uint32_t ecn                  :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t feio                 :  1 ; /* bits 14:14 */
    ca_uint32_t tmio                 :  1 ; /* bits 15:15 */
    ca_uint32_t cb                   :  1 ; /* bits 16:16 */
    ca_uint32_t fc                   :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd2               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_GLB_INT_t;


#define L2TM_L2TE_GLB_INTE                       0xf430240c
#define L2TM_L2TE_GLB_INTE_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pol_markE            :  1 ; /* bits 0:0 */
    ca_uint32_t pol_dropE            :  1 ; /* bits 1:1 */
    ca_uint32_t tail_dropE           :  1 ; /* bits 2:2 */
    ca_uint32_t wred_y_dropE         :  1 ; /* bits 3:3 */
    ca_uint32_t wred_g_dropE         :  1 ; /* bits 4:4 */
    ca_uint32_t ecnE                 :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t feioE                :  1 ; /* bits 14:14 */
    ca_uint32_t tmioE                :  1 ; /* bits 15:15 */
    ca_uint32_t cbE                  :  1 ; /* bits 16:16 */
    ca_uint32_t fcE                  :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd2               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_GLB_INTE_t;


#define L2TM_L2TE_GLB_STS                        0xf4302410
#define L2TM_L2TE_GLB_STS_dft                    0x07000000

typedef volatile union {
  struct {
    ca_uint32_t pol_fifo_ovrn        :  1 ; /* bits 0:0 */
    ca_uint32_t l2io_fifo_ovrn       :  1 ; /* bits 1:1 */
    ca_uint32_t qmio_enq_ovrn        :  1 ; /* bits 2:2 */
    ca_uint32_t qmio_deq_ovrn        :  1 ; /* bits 3:3 */
    ca_uint32_t qmio_shp_ovrn        :  1 ; /* bits 4:4 */
    ca_uint32_t te_qm_nrdy           :  1 ; /* bits 5:5 */
    ca_uint32_t ptp_fifo_err         :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t pol_init_done        :  1 ; /* bits 12:12 */
    ca_uint32_t shp_init_done        :  1 ; /* bits 13:13 */
    ca_uint32_t cb_init_done         :  1 ; /* bits 14:14 */
    ca_uint32_t wred_init_done       :  1 ; /* bits 15:15 */
    ca_uint32_t feio_sm              :  4 ; /* bits 19:16 */
    ca_uint32_t fe_te_req            :  1 ; /* bits 20:20 */
    ca_uint32_t te_fe_ack            :  1 ; /* bits 21:21 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t l2io_idle            :  1 ; /* bits 24:24 */
    ca_uint32_t qmio_idle            :  1 ; /* bits 25:25 */
    ca_uint32_t ptp_fifo_idle        :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd3               :  4 ;
    ca_uint32_t init_done            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_GLB_STS_t;


#define L2TM_L2TE_GLB_PTP_CFG                    0xf4302414
#define L2TM_L2TE_GLB_PTP_CFG_dft                0x000007ff

typedef volatile union {
  struct {
    ca_uint32_t pol_id               :  8 ; /* bits 7:0 */
    ca_uint32_t pol_grp_id           :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t pol_en               :  1 ; /* bits 12:12 */
    ca_uint32_t pol_grp_en           :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd2               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_GLB_PTP_CFG_t;


#define L2TM_L2TE_GLB_SPARE_CFG                  0xf4302418
#define L2TM_L2TE_GLB_SPARE_CFG_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t spare                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_GLB_SPARE_CFG_t;


#define L2TM_L2TE_GLB_SPARE_STS                  0xf430241c
#define L2TM_L2TE_GLB_SPARE_STS_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t spare                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_GLB_SPARE_STS_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2te_glb */
typedef struct {
  L2TM_L2TE_GLB_REV_ID_t                   REV_ID;                        /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  L2TM_L2TE_GLB_CTRL_t                     CTRL;                          /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  L2TM_L2TE_GLB_INT_t                      INT;                           /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  L2TM_L2TE_GLB_INTE_t                     INTE;                          /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  L2TM_L2TE_GLB_STS_t                      STS;                           /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  L2TM_L2TE_GLB_PTP_CFG_t                  PTP_CFG;                       /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  L2TM_L2TE_GLB_SPARE_CFG_t                SPARE_CFG;                     /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  L2TM_L2TE_GLB_SPARE_STS_t                SPARE_STS;                     /* addr: 0x0000001c */
} APB0_L2TM_L2TE_GLB_t;


/*
 * l2te_pol
 */
        
#define L2TM_L2TE_POL_PKT_TYPE_CTRL0             0xf4302500
#define L2TM_L2TE_POL_PKT_TYPE_CTRL0_STRIDE      4
#define L2TM_L2TE_POL_PKT_TYPE_CTRL0_COUNT       16
#define L2TM_L2TE_POL_PKT_TYPE_CTRL0_dft         0x00000500

typedef volatile union {
  struct {
    ca_uint32_t type                 :  3 ; /* bits 2:0 */
    ca_uint32_t color_blind          :  1 ; /* bits 3:3 */
    ca_uint32_t pkt_mode             :  1 ; /* bits 4:4 */
    ca_uint32_t egr_len_sel          :  1 ; /* bits 5:5 */
    ca_uint32_t ipg                  :  5 ; /* bits 10:6 */
    ca_uint32_t bypass_yellow        :  1 ; /* bits 11:11 */
    ca_uint32_t bypass_red           :  1 ; /* bits 12:12 */
    ca_uint32_t update_mode          :  1 ; /* bits 13:13 */
    ca_uint32_t nest_level           :  2 ; /* bits 15:14 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PKT_TYPE_CTRL0_t;

                                                            
#define L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_ACCESS 0xf4302540
#define L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_ACCESS_t;


#define L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA2 0xf4302544
#define L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA2_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t peak_bs              : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA2_t;


#define L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA1 0xf4302548
#define L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t committed_bs         :  6 ; /* bits 5:0 */
    ca_uint32_t peak_rate_k          : 10 ; /* bits 15:6 */
    ca_uint32_t peak_rate_m          : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA1_t;


#define L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA0 0xf430254c
#define L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t committed_rate_k     : 10 ; /* bits 9:0 */
    ca_uint32_t committed_rate_m     : 16 ; /* bits 25:10 */
    ca_uint32_t committed_bs         :  6 ; /* bits 31:26 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA0_t;


#define L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_ACCESS 0xf4302550
#define L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_ACCESS_t;


#define L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_DATA1 0xf4302554
#define L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_DATA1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t peak_tbc             : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_DATA1_t;


#define L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_DATA0 0xf4302558
#define L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_DATA0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t committed_tbc        : 21 ; /* bits 20:0 */
    ca_uint32_t peak_tbc             : 11 ; /* bits 31:21 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_DATA0_t;


#define L2TM_L2TE_POL_PORT_CTRL0                 0xf430255c
#define L2TM_L2TE_POL_PORT_CTRL0_STRIDE          4
#define L2TM_L2TE_POL_PORT_CTRL0_COUNT           16
#define L2TM_L2TE_POL_PORT_CTRL0_dft             0x00000500

typedef volatile union {
  struct {
    ca_uint32_t type                 :  3 ; /* bits 2:0 */
    ca_uint32_t color_blind          :  1 ; /* bits 3:3 */
    ca_uint32_t pkt_mode             :  1 ; /* bits 4:4 */
    ca_uint32_t egr_len_sel          :  1 ; /* bits 5:5 */
    ca_uint32_t ipg                  :  5 ; /* bits 10:6 */
    ca_uint32_t bypass_yellow        :  1 ; /* bits 11:11 */
    ca_uint32_t bypass_red           :  1 ; /* bits 12:12 */
    ca_uint32_t update_mode          :  1 ; /* bits 13:13 */
    ca_uint32_t nest_level           :  2 ; /* bits 15:14 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PORT_CTRL0_t;

                                                            
#define L2TM_L2TE_POL_PORT_PROFILE_MEM_ACCESS    0xf430259c
#define L2TM_L2TE_POL_PORT_PROFILE_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PORT_PROFILE_MEM_ACCESS_t;


#define L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA2     0xf43025a0
#define L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA2_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t peak_bs              : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA2_t;


#define L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA1     0xf43025a4
#define L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t committed_bs         :  6 ; /* bits 5:0 */
    ca_uint32_t peak_rate_k          : 10 ; /* bits 15:6 */
    ca_uint32_t peak_rate_m          : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA1_t;


#define L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA0     0xf43025a8
#define L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t committed_rate_k     : 10 ; /* bits 9:0 */
    ca_uint32_t committed_rate_m     : 16 ; /* bits 25:10 */
    ca_uint32_t committed_bs         :  6 ; /* bits 31:26 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA0_t;


#define L2TM_L2TE_POL_PORT_COUNTER_MEM_ACCESS    0xf43025ac
#define L2TM_L2TE_POL_PORT_COUNTER_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PORT_COUNTER_MEM_ACCESS_t;


#define L2TM_L2TE_POL_PORT_COUNTER_MEM_DATA1     0xf43025b0
#define L2TM_L2TE_POL_PORT_COUNTER_MEM_DATA1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t peak_tbc             : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PORT_COUNTER_MEM_DATA1_t;


#define L2TM_L2TE_POL_PORT_COUNTER_MEM_DATA0     0xf43025b4
#define L2TM_L2TE_POL_PORT_COUNTER_MEM_DATA0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t committed_tbc        : 21 ; /* bits 20:0 */
    ca_uint32_t peak_tbc             : 11 ; /* bits 31:21 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_PORT_COUNTER_MEM_DATA0_t;


#define L2TM_L2TE_POL_FLOW_GRP_CTRL0             0xf43025b8
#define L2TM_L2TE_POL_FLOW_GRP_CTRL0_STRIDE      4
#define L2TM_L2TE_POL_FLOW_GRP_CTRL0_COUNT       8
#define L2TM_L2TE_POL_FLOW_GRP_CTRL0_dft         0x00000500

typedef volatile union {
  struct {
    ca_uint32_t type                 :  3 ; /* bits 2:0 */
    ca_uint32_t color_blind          :  1 ; /* bits 3:3 */
    ca_uint32_t pkt_mode             :  1 ; /* bits 4:4 */
    ca_uint32_t egr_len_sel          :  1 ; /* bits 5:5 */
    ca_uint32_t ipg                  :  5 ; /* bits 10:6 */
    ca_uint32_t bypass_yellow        :  1 ; /* bits 11:11 */
    ca_uint32_t bypass_red           :  1 ; /* bits 12:12 */
    ca_uint32_t update_mode          :  1 ; /* bits 13:13 */
    ca_uint32_t nest_level           :  2 ; /* bits 15:14 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_FLOW_GRP_CTRL0_t;

                            
#define L2TM_L2TE_POL_FLOW_PROFILE_MEM_ACCESS    0xf43025d8
#define L2TM_L2TE_POL_FLOW_PROFILE_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_FLOW_PROFILE_MEM_ACCESS_t;


#define L2TM_L2TE_POL_FLOW_PROFILE_MEM_DATA2     0xf43025dc
#define L2TM_L2TE_POL_FLOW_PROFILE_MEM_DATA2_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t peak_bs              : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_FLOW_PROFILE_MEM_DATA2_t;


#define L2TM_L2TE_POL_FLOW_PROFILE_MEM_DATA1     0xf43025e0
#define L2TM_L2TE_POL_FLOW_PROFILE_MEM_DATA1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t committed_bs         :  6 ; /* bits 5:0 */
    ca_uint32_t peak_rate_k          : 10 ; /* bits 15:6 */
    ca_uint32_t peak_rate_m          : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_FLOW_PROFILE_MEM_DATA1_t;


#define L2TM_L2TE_POL_FLOW_PROFILE_MEM_DATA0     0xf43025e4
#define L2TM_L2TE_POL_FLOW_PROFILE_MEM_DATA0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t committed_rate_k     : 10 ; /* bits 9:0 */
    ca_uint32_t committed_rate_m     : 16 ; /* bits 25:10 */
    ca_uint32_t committed_bs         :  6 ; /* bits 31:26 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_FLOW_PROFILE_MEM_DATA0_t;


#define L2TM_L2TE_POL_FLOW_COUNTER_MEM_ACCESS    0xf43025e8
#define L2TM_L2TE_POL_FLOW_COUNTER_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_FLOW_COUNTER_MEM_ACCESS_t;


#define L2TM_L2TE_POL_FLOW_COUNTER_MEM_DATA1     0xf43025ec
#define L2TM_L2TE_POL_FLOW_COUNTER_MEM_DATA1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t peak_tbc             : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_FLOW_COUNTER_MEM_DATA1_t;


#define L2TM_L2TE_POL_FLOW_COUNTER_MEM_DATA0     0xf43025f0
#define L2TM_L2TE_POL_FLOW_COUNTER_MEM_DATA0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t committed_tbc        : 21 ; /* bits 20:0 */
    ca_uint32_t peak_tbc             : 11 ; /* bits 31:21 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_FLOW_COUNTER_MEM_DATA0_t;


#define L2TM_L2TE_POL_AGRFLOW_CTRL0              0xf43025f4
#define L2TM_L2TE_POL_AGRFLOW_CTRL0_STRIDE       4
#define L2TM_L2TE_POL_AGRFLOW_CTRL0_COUNT        8
#define L2TM_L2TE_POL_AGRFLOW_CTRL0_dft          0x00000500

typedef volatile union {
  struct {
    ca_uint32_t type                 :  3 ; /* bits 2:0 */
    ca_uint32_t color_blind          :  1 ; /* bits 3:3 */
    ca_uint32_t pkt_mode             :  1 ; /* bits 4:4 */
    ca_uint32_t egr_len_sel          :  1 ; /* bits 5:5 */
    ca_uint32_t ipg                  :  5 ; /* bits 10:6 */
    ca_uint32_t bypass_yellow        :  1 ; /* bits 11:11 */
    ca_uint32_t bypass_red           :  1 ; /* bits 12:12 */
    ca_uint32_t update_mode          :  1 ; /* bits 13:13 */
    ca_uint32_t nest_level           :  2 ; /* bits 15:14 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_AGRFLOW_CTRL0_t;

                            
#define L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_ACCESS 0xf4302614
#define L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 27 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_ACCESS_t;


#define L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA2  0xf4302618
#define L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA2_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t peak_bs              : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA2_t;


#define L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA1  0xf430261c
#define L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t committed_bs         :  6 ; /* bits 5:0 */
    ca_uint32_t peak_rate_k          : 10 ; /* bits 15:6 */
    ca_uint32_t peak_rate_m          : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA1_t;


#define L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA0  0xf4302620
#define L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t committed_rate_k     : 10 ; /* bits 9:0 */
    ca_uint32_t committed_rate_m     : 16 ; /* bits 25:10 */
    ca_uint32_t committed_bs         :  6 ; /* bits 31:26 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA0_t;


#define L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_ACCESS 0xf4302624
#define L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 27 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_ACCESS_t;


#define L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_DATA1  0xf4302628
#define L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_DATA1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t peak_tbc             : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_DATA1_t;


#define L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_DATA0  0xf430262c
#define L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_DATA0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t committed_tbc        : 21 ; /* bits 20:0 */
    ca_uint32_t peak_tbc             : 11 ; /* bits 31:21 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_DATA0_t;


#define L2TM_L2TE_POL_TB_CTRL                    0xf4302630
#define L2TM_L2TE_POL_TB_CTRL_dft                0x2ff3e723

typedef volatile union {
  struct {
    ca_uint32_t addtok_en            :  1 ; /* bits 0:0 */
    ca_uint32_t subtok_en            :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t upd_cnt_lmt          :  4 ; /* bits 7:4 */
    ca_uint32_t cyc_cnt_lmt          : 12 ; /* bits 19:8 */
    ca_uint32_t last_upd_cyc         : 12 ; /* bits 31:20 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_TB_CTRL_t;


#define L2TM_L2TE_POL_TB_CTRL1                   0xf4302634
#define L2TM_L2TE_POL_TB_CTRL1_dft               0x000001f3

typedef volatile union {
  struct {
    ca_uint32_t k_cnt_lmt            : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_POL_TB_CTRL1_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2te_pol */
typedef struct {
  L2TM_L2TE_POL_PKT_TYPE_CTRL0_t           PKT_TYPE_CTRL0;                /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[63];                   
  L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_ACCESS_t PKT_TYPE_PROFILE_MEM_ACCESS;   /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd2[3];                    
  L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA2_t PKT_TYPE_PROFILE_MEM_DATA2;    /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd3[3];                    
  L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA1_t PKT_TYPE_PROFILE_MEM_DATA1;    /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd4[3];                    
  L2TM_L2TE_POL_PKT_TYPE_PROFILE_MEM_DATA0_t PKT_TYPE_PROFILE_MEM_DATA0;    /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd5[3];                    
  L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_ACCESS_t PKT_TYPE_COUNTER_MEM_ACCESS;   /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd6[3];                    
  L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_DATA1_t PKT_TYPE_COUNTER_MEM_DATA1;    /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd7[3];                    
  L2TM_L2TE_POL_PKT_TYPE_COUNTER_MEM_DATA0_t PKT_TYPE_COUNTER_MEM_DATA0;    /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd8[3];                    
  L2TM_L2TE_POL_PORT_CTRL0_t               PORT_CTRL0;                    /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd9[63];                   
  L2TM_L2TE_POL_PORT_PROFILE_MEM_ACCESS_t  PORT_PROFILE_MEM_ACCESS;       /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd10[3];                   
  L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA2_t   PORT_PROFILE_MEM_DATA2;        /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd11[3];                   
  L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA1_t   PORT_PROFILE_MEM_DATA1;        /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd12[3];                   
  L2TM_L2TE_POL_PORT_PROFILE_MEM_DATA0_t   PORT_PROFILE_MEM_DATA0;        /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd13[3];                   
  L2TM_L2TE_POL_PORT_COUNTER_MEM_ACCESS_t  PORT_COUNTER_MEM_ACCESS;       /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd14[3];                   
  L2TM_L2TE_POL_PORT_COUNTER_MEM_DATA1_t   PORT_COUNTER_MEM_DATA1;        /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd15[3];                   
  L2TM_L2TE_POL_PORT_COUNTER_MEM_DATA0_t   PORT_COUNTER_MEM_DATA0;        /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd16[3];                   
  L2TM_L2TE_POL_FLOW_GRP_CTRL0_t           FLOW_GRP_CTRL0;                /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd17[31];                  
  L2TM_L2TE_POL_FLOW_PROFILE_MEM_ACCESS_t  FLOW_PROFILE_MEM_ACCESS;       /* addr: 0x000000d8 */
  ca_uint32_t                              rsrvd18[3];                   
  L2TM_L2TE_POL_FLOW_PROFILE_MEM_DATA2_t   FLOW_PROFILE_MEM_DATA2;        /* addr: 0x000000dc */
  ca_uint32_t                              rsrvd19[3];                   
  L2TM_L2TE_POL_FLOW_PROFILE_MEM_DATA1_t   FLOW_PROFILE_MEM_DATA1;        /* addr: 0x000000e0 */
  ca_uint32_t                              rsrvd20[3];                   
  L2TM_L2TE_POL_FLOW_PROFILE_MEM_DATA0_t   FLOW_PROFILE_MEM_DATA0;        /* addr: 0x000000e4 */
  ca_uint32_t                              rsrvd21[3];                   
  L2TM_L2TE_POL_FLOW_COUNTER_MEM_ACCESS_t  FLOW_COUNTER_MEM_ACCESS;       /* addr: 0x000000e8 */
  ca_uint32_t                              rsrvd22[3];                   
  L2TM_L2TE_POL_FLOW_COUNTER_MEM_DATA1_t   FLOW_COUNTER_MEM_DATA1;        /* addr: 0x000000ec */
  ca_uint32_t                              rsrvd23[3];                   
  L2TM_L2TE_POL_FLOW_COUNTER_MEM_DATA0_t   FLOW_COUNTER_MEM_DATA0;        /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd24[3];                   
  L2TM_L2TE_POL_AGRFLOW_CTRL0_t            AGRFLOW_CTRL0;                 /* addr: 0x000000f4 */
  ca_uint32_t                              rsrvd25[31];                  
  L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_ACCESS_t AGRFLOW_PROFILE_MEM_ACCESS;    /* addr: 0x00000114 */
  ca_uint32_t                              rsrvd26[3];                   
  L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA2_t AGRFLOW_PROFILE_MEM_DATA2;     /* addr: 0x00000118 */
  ca_uint32_t                              rsrvd27[3];                   
  L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA1_t AGRFLOW_PROFILE_MEM_DATA1;     /* addr: 0x0000011c */
  ca_uint32_t                              rsrvd28[3];                   
  L2TM_L2TE_POL_AGRFLOW_PROFILE_MEM_DATA0_t AGRFLOW_PROFILE_MEM_DATA0;     /* addr: 0x00000120 */
  ca_uint32_t                              rsrvd29[3];                   
  L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_ACCESS_t AGRFLOW_COUNTER_MEM_ACCESS;    /* addr: 0x00000124 */
  ca_uint32_t                              rsrvd30[3];                   
  L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_DATA1_t AGRFLOW_COUNTER_MEM_DATA1;     /* addr: 0x00000128 */
  ca_uint32_t                              rsrvd31[3];                   
  L2TM_L2TE_POL_AGRFLOW_COUNTER_MEM_DATA0_t AGRFLOW_COUNTER_MEM_DATA0;     /* addr: 0x0000012c */
  ca_uint32_t                              rsrvd32[3];                   
  L2TM_L2TE_POL_TB_CTRL_t                  TB_CTRL;                       /* addr: 0x00000130 */
  ca_uint32_t                              rsrvd33[3];                   
  L2TM_L2TE_POL_TB_CTRL1_t                 TB_CTRL1;                      /* addr: 0x00000134 */
} APB0_L2TM_L2TE_POL_t;


/*
 * l2te_shp
 */
        
#define L2TM_L2TE_SHP_IPG_PROFILE                0xf4302700
#define L2TM_L2TE_SHP_IPG_PROFILE_dft            0x14141414

typedef volatile union {
  struct {
    ca_uint32_t ipg0                 :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t ipg1                 :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t ipg2                 :  5 ; /* bits 20:16 */
    ca_uint32_t rsrvd3               :  3 ;
    ca_uint32_t ipg3                 :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd4               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_IPG_PROFILE_t;


#define L2TM_L2TE_SHP_PORT_IPG_SELECT0           0xf4302704
#define L2TM_L2TE_SHP_PORT_IPG_SELECT0_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pid0                 :  2 ; /* bits 1:0 */
    ca_uint32_t pid1                 :  2 ; /* bits 3:2 */
    ca_uint32_t pid2                 :  2 ; /* bits 5:4 */
    ca_uint32_t pid3                 :  2 ; /* bits 7:6 */
    ca_uint32_t pid4                 :  2 ; /* bits 9:8 */
    ca_uint32_t pid5                 :  2 ; /* bits 11:10 */
    ca_uint32_t pid6                 :  2 ; /* bits 13:12 */
    ca_uint32_t pid7                 :  2 ; /* bits 15:14 */
    ca_uint32_t pid8                 :  2 ; /* bits 17:16 */
    ca_uint32_t pid9                 :  2 ; /* bits 19:18 */
    ca_uint32_t pid10                :  2 ; /* bits 21:20 */
    ca_uint32_t pid11                :  2 ; /* bits 23:22 */
    ca_uint32_t pid12                :  2 ; /* bits 25:24 */
    ca_uint32_t pid13                :  2 ; /* bits 27:26 */
    ca_uint32_t pid14                :  2 ; /* bits 29:28 */
    ca_uint32_t pid15                :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_PORT_IPG_SELECT0_t;


#define L2TM_L2TE_SHP_SRP_CONFIG0                0xf4302708
#define L2TM_L2TE_SHP_SRP_CONFIG0_STRIDE         4
#define L2TM_L2TE_SHP_SRP_CONFIG0_COUNT          2
#define L2TM_L2TE_SHP_SRP_CONFIG0_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cfg0_enb             :  1 ; /* bits 0:0 */
    ca_uint32_t cfg0_cos             :  3 ; /* bits 3:1 */
    ca_uint32_t rsrvd1               : 11 ;
    ca_uint32_t cfg0_class_b         :  1 ; /* bits 15:15 */
    ca_uint32_t cfg1_enb             :  1 ; /* bits 16:16 */
    ca_uint32_t cfg1_cos             :  3 ; /* bits 19:17 */
    ca_uint32_t rsrvd2               : 11 ;
    ca_uint32_t cfg1_class_b         :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_SRP_CONFIG0_t;

    
#define L2TM_L2TE_SHP_SRP_CONFIG_EN              0xf4302710
#define L2TM_L2TE_SHP_SRP_CONFIG_EN_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pid0                 :  4 ; /* bits 3:0 */
    ca_uint32_t pid1                 :  4 ; /* bits 7:4 */
    ca_uint32_t pid2                 :  4 ; /* bits 11:8 */
    ca_uint32_t pid3                 :  4 ; /* bits 15:12 */
    ca_uint32_t pid4                 :  4 ; /* bits 19:16 */
    ca_uint32_t pid5                 :  4 ; /* bits 23:20 */
    ca_uint32_t pid6                 :  4 ; /* bits 27:24 */
    ca_uint32_t pid7                 :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_SRP_CONFIG_EN_t;


#define L2TM_L2TE_SHP_CTRL                       0xf4302714
#define L2TM_L2TE_SHP_CTRL_dft                   0x0000007c

typedef volatile union {
  struct {
    ca_uint32_t pkt_mode_class0_cnt  :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t pkt_mode_class1_cnt  :  7 ; /* bits 14:8 */
    ca_uint32_t rsrvd2               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_CTRL_t;


#define L2TM_L2TE_SHP_PORT_TBC_MEM_ACCESS        0xf4302718
#define L2TM_L2TE_SHP_PORT_TBC_MEM_ACCESS_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_PORT_TBC_MEM_ACCESS_t;


#define L2TM_L2TE_SHP_PORT_TBC_MEM_DATA1         0xf430271c
#define L2TM_L2TE_SHP_PORT_TBC_MEM_DATA1_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bs                   :  6 ; /* bits 5:0 */
    ca_uint32_t enb                  :  2 ; /* bits 7:6 */
    ca_uint32_t mode                 :  1 ; /* bits 8:8 */
    ca_uint32_t tbc                  : 21 ; /* bits 29:9 */
    ca_uint32_t pkt_mode_class_sel   :  1 ; /* bits 30:30 */
    ca_uint32_t rsrvd1               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_PORT_TBC_MEM_DATA1_t;


#define L2TM_L2TE_SHP_PORT_TBC_MEM_DATA0         0xf4302720
#define L2TM_L2TE_SHP_PORT_TBC_MEM_DATA0_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rate_k               : 10 ; /* bits 9:0 */
    ca_uint32_t rate_m               : 16 ; /* bits 25:10 */
    ca_uint32_t bs                   :  6 ; /* bits 31:26 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_PORT_TBC_MEM_DATA0_t;


#define L2TM_L2TE_SHP_GROUP_TBC_MEM_ACCESS       0xf4302724
#define L2TM_L2TE_SHP_GROUP_TBC_MEM_ACCESS_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_GROUP_TBC_MEM_ACCESS_t;


#define L2TM_L2TE_SHP_GROUP_TBC_MEM_DATA1        0xf4302728
#define L2TM_L2TE_SHP_GROUP_TBC_MEM_DATA1_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bs                   :  6 ; /* bits 5:0 */
    ca_uint32_t enb                  :  2 ; /* bits 7:6 */
    ca_uint32_t mode                 :  1 ; /* bits 8:8 */
    ca_uint32_t tbc                  : 21 ; /* bits 29:9 */
    ca_uint32_t pkt_mode_class_sel   :  1 ; /* bits 30:30 */
    ca_uint32_t rsrvd1               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_GROUP_TBC_MEM_DATA1_t;


#define L2TM_L2TE_SHP_GROUP_TBC_MEM_DATA0        0xf430272c
#define L2TM_L2TE_SHP_GROUP_TBC_MEM_DATA0_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rate_k               : 10 ; /* bits 9:0 */
    ca_uint32_t rate_m               : 16 ; /* bits 25:10 */
    ca_uint32_t bs                   :  6 ; /* bits 31:26 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_GROUP_TBC_MEM_DATA0_t;


#define L2TM_L2TE_SHP_VOQ_TBC_MEM_ACCESS         0xf4302730
#define L2TM_L2TE_SHP_VOQ_TBC_MEM_ACCESS_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_VOQ_TBC_MEM_ACCESS_t;


#define L2TM_L2TE_SHP_VOQ_TBC_MEM_DATA1          0xf4302734
#define L2TM_L2TE_SHP_VOQ_TBC_MEM_DATA1_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bs                   :  6 ; /* bits 5:0 */
    ca_uint32_t enb                  :  2 ; /* bits 7:6 */
    ca_uint32_t mode                 :  1 ; /* bits 8:8 */
    ca_uint32_t tbc                  : 21 ; /* bits 29:9 */
    ca_uint32_t pkt_mode_class_sel   :  1 ; /* bits 30:30 */
    ca_uint32_t rsrvd1               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_VOQ_TBC_MEM_DATA1_t;


#define L2TM_L2TE_SHP_VOQ_TBC_MEM_DATA0          0xf4302738
#define L2TM_L2TE_SHP_VOQ_TBC_MEM_DATA0_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rate_k               : 10 ; /* bits 9:0 */
    ca_uint32_t rate_m               : 16 ; /* bits 25:10 */
    ca_uint32_t bs                   :  6 ; /* bits 31:26 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_VOQ_TBC_MEM_DATA0_t;


#define L2TM_L2TE_SHP_TB_CTRL                    0xf430273c
#define L2TM_L2TE_SHP_TB_CTRL_dft                0x2ff3e723

typedef volatile union {
  struct {
    ca_uint32_t addtok_en            :  1 ; /* bits 0:0 */
    ca_uint32_t subtok_en            :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t upd_cnt_lmt          :  4 ; /* bits 7:4 */
    ca_uint32_t cyc_cnt_lmt          : 12 ; /* bits 19:8 */
    ca_uint32_t last_upd_cyc         : 12 ; /* bits 31:20 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_TB_CTRL_t;


#define L2TM_L2TE_SHP_TB_CTRL1                   0xf4302740
#define L2TM_L2TE_SHP_TB_CTRL1_dft               0x000001f3

typedef volatile union {
  struct {
    ca_uint32_t k_cnt_lmt            : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_SHP_TB_CTRL1_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2te_shp */
typedef struct {
  L2TM_L2TE_SHP_IPG_PROFILE_t              IPG_PROFILE;                   /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  L2TM_L2TE_SHP_PORT_IPG_SELECT0_t         PORT_IPG_SELECT0;              /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  L2TM_L2TE_SHP_SRP_CONFIG0_t              SRP_CONFIG0;                   /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[7];                    
  L2TM_L2TE_SHP_SRP_CONFIG_EN_t            SRP_CONFIG_EN;                 /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd4[3];                    
  L2TM_L2TE_SHP_CTRL_t                     CTRL;                          /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd5[3];                    
  L2TM_L2TE_SHP_PORT_TBC_MEM_ACCESS_t      PORT_TBC_MEM_ACCESS;           /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd6[3];                    
  L2TM_L2TE_SHP_PORT_TBC_MEM_DATA1_t       PORT_TBC_MEM_DATA1;            /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd7[3];                    
  L2TM_L2TE_SHP_PORT_TBC_MEM_DATA0_t       PORT_TBC_MEM_DATA0;            /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd8[3];                    
  L2TM_L2TE_SHP_GROUP_TBC_MEM_ACCESS_t     GROUP_TBC_MEM_ACCESS;          /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd9[3];                    
  L2TM_L2TE_SHP_GROUP_TBC_MEM_DATA1_t      GROUP_TBC_MEM_DATA1;           /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd10[3];                   
  L2TM_L2TE_SHP_GROUP_TBC_MEM_DATA0_t      GROUP_TBC_MEM_DATA0;           /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd11[3];                   
  L2TM_L2TE_SHP_VOQ_TBC_MEM_ACCESS_t       VOQ_TBC_MEM_ACCESS;            /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd12[3];                   
  L2TM_L2TE_SHP_VOQ_TBC_MEM_DATA1_t        VOQ_TBC_MEM_DATA1;             /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd13[3];                   
  L2TM_L2TE_SHP_VOQ_TBC_MEM_DATA0_t        VOQ_TBC_MEM_DATA0;             /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd14[3];                   
  L2TM_L2TE_SHP_TB_CTRL_t                  TB_CTRL;                       /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd15[3];                   
  L2TM_L2TE_SHP_TB_CTRL1_t                 TB_CTRL1;                      /* addr: 0x00000040 */
} APB0_L2TM_L2TE_SHP_t;


/*
 * l2te_wred
 */
        
#define L2TM_L2TE_WRED_CTRL                      0xf4302800
#define L2TM_L2TE_WRED_CTRL_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t fast_decay           :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t afgs_weight          :  4 ; /* bits 7:4 */
    ca_uint32_t rsrvd3               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_CTRL_t;


#define L2TM_L2TE_WRED_AFGS_MEM_ACCESS           0xf4302804
#define L2TM_L2TE_WRED_AFGS_MEM_ACCESS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 29 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_AFGS_MEM_ACCESS_t;


#define L2TM_L2TE_WRED_AFGS_MEM_DATA             0xf4302808
#define L2TM_L2TE_WRED_AFGS_MEM_DATA_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t depth                : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_AFGS_MEM_DATA_t;


#define L2TM_L2TE_WRED_PROFILE_MEM_ACCESS        0xf430280c
#define L2TM_L2TE_WRED_PROFILE_MEM_ACCESS_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_PROFILE_MEM_ACCESS_t;


#define L2TM_L2TE_WRED_PROFILE_MEM_DATA7         0xf4302810
#define L2TM_L2TE_WRED_PROFILE_MEM_DATA7_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data_rsvd            :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_PROFILE_MEM_DATA7_t;


#define L2TM_L2TE_WRED_PROFILE_MEM_DATA6         0xf4302814
#define L2TM_L2TE_WRED_PROFILE_MEM_DATA6_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t unmark_idx           :  4 ; /* bits 3:0 */
    ca_uint32_t mark_idx             :  4 ; /* bits 7:4 */
    ca_uint32_t data_rsvd            : 24 ; /* bits 31:8 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_PROFILE_MEM_DATA6_t;


#define L2TM_L2TE_WRED_PROFILE_MEM_DATA5         0xf4302818
#define L2TM_L2TE_WRED_PROFILE_MEM_DATA5_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mark_dps             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_PROFILE_MEM_DATA5_t;


#define L2TM_L2TE_WRED_PROFILE_MEM_DATA4         0xf430281c
#define L2TM_L2TE_WRED_PROFILE_MEM_DATA4_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mark_dps             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_PROFILE_MEM_DATA4_t;


#define L2TM_L2TE_WRED_PROFILE_MEM_DATA3         0xf4302820
#define L2TM_L2TE_WRED_PROFILE_MEM_DATA3_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mark_dps             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_PROFILE_MEM_DATA3_t;


#define L2TM_L2TE_WRED_PROFILE_MEM_DATA2         0xf4302824
#define L2TM_L2TE_WRED_PROFILE_MEM_DATA2_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t unmark_dps           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_PROFILE_MEM_DATA2_t;


#define L2TM_L2TE_WRED_PROFILE_MEM_DATA1         0xf4302828
#define L2TM_L2TE_WRED_PROFILE_MEM_DATA1_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t unmark_dps           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_PROFILE_MEM_DATA1_t;


#define L2TM_L2TE_WRED_PROFILE_MEM_DATA0         0xf430282c
#define L2TM_L2TE_WRED_PROFILE_MEM_DATA0_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t unmark_dps           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_PROFILE_MEM_DATA0_t;


#define L2TM_L2TE_WRED_PROFILE_SELECT_MEM_ACCESS 0xf4302830
#define L2TM_L2TE_WRED_PROFILE_SELECT_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_PROFILE_SELECT_MEM_ACCESS_t;


#define L2TM_L2TE_WRED_PROFILE_SELECT_MEM_DATA1  0xf4302834
#define L2TM_L2TE_WRED_PROFILE_SELECT_MEM_DATA1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sel6                 :  3 ; /* bits 2:0 */
    ca_uint32_t sel7                 :  5 ; /* bits 7:3 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_PROFILE_SELECT_MEM_DATA1_t;


#define L2TM_L2TE_WRED_PROFILE_SELECT_MEM_DATA0  0xf4302838
#define L2TM_L2TE_WRED_PROFILE_SELECT_MEM_DATA0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sel0                 :  5 ; /* bits 4:0 */
    ca_uint32_t sel1                 :  5 ; /* bits 9:5 */
    ca_uint32_t sel2                 :  5 ; /* bits 14:10 */
    ca_uint32_t sel3                 :  5 ; /* bits 19:15 */
    ca_uint32_t sel4                 :  5 ; /* bits 24:20 */
    ca_uint32_t sel5                 :  5 ; /* bits 29:25 */
    ca_uint32_t sel6                 :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_WRED_PROFILE_SELECT_MEM_DATA0_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2te_wred */
typedef struct {
  L2TM_L2TE_WRED_CTRL_t                    CTRL;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  L2TM_L2TE_WRED_AFGS_MEM_ACCESS_t         AFGS_MEM_ACCESS;               /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  L2TM_L2TE_WRED_AFGS_MEM_DATA_t           AFGS_MEM_DATA;                 /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  L2TM_L2TE_WRED_PROFILE_MEM_ACCESS_t      PROFILE_MEM_ACCESS;            /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  L2TM_L2TE_WRED_PROFILE_MEM_DATA7_t       PROFILE_MEM_DATA7;             /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  L2TM_L2TE_WRED_PROFILE_MEM_DATA6_t       PROFILE_MEM_DATA6;             /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  L2TM_L2TE_WRED_PROFILE_MEM_DATA5_t       PROFILE_MEM_DATA5;             /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  L2TM_L2TE_WRED_PROFILE_MEM_DATA4_t       PROFILE_MEM_DATA4;             /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  L2TM_L2TE_WRED_PROFILE_MEM_DATA3_t       PROFILE_MEM_DATA3;             /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  L2TM_L2TE_WRED_PROFILE_MEM_DATA2_t       PROFILE_MEM_DATA2;             /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  L2TM_L2TE_WRED_PROFILE_MEM_DATA1_t       PROFILE_MEM_DATA1;             /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  L2TM_L2TE_WRED_PROFILE_MEM_DATA0_t       PROFILE_MEM_DATA0;             /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  L2TM_L2TE_WRED_PROFILE_SELECT_MEM_ACCESS_t PROFILE_SELECT_MEM_ACCESS;     /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  L2TM_L2TE_WRED_PROFILE_SELECT_MEM_DATA1_t PROFILE_SELECT_MEM_DATA1;      /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  L2TM_L2TE_WRED_PROFILE_SELECT_MEM_DATA0_t PROFILE_SELECT_MEM_DATA0;      /* addr: 0x00000038 */
} APB0_L2TM_L2TE_WRED_t;


/*
 * l2te_fc_glb
 */
        
#define L2TM_L2TE_FC_GLB_INT                     0xf4302900
#define L2TM_L2TE_FC_GLB_INT_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rxflowcntl0          :  1 ; /* bits 0:0 */
    ca_uint32_t rxflowcntl1          :  1 ; /* bits 1:1 */
    ca_uint32_t rxflowcntl2          :  1 ; /* bits 2:2 */
    ca_uint32_t rxflowcntl3          :  1 ; /* bits 3:3 */
    ca_uint32_t rxflowcntl4          :  1 ; /* bits 4:4 */
    ca_uint32_t rxflowcntl5          :  1 ; /* bits 5:5 */
    ca_uint32_t rxflowcntl6          :  1 ; /* bits 6:6 */
    ca_uint32_t rxflowcntl7          :  1 ; /* bits 7:7 */
    ca_uint32_t rxflowcntl8          :  1 ; /* bits 8:8 */
    ca_uint32_t rxflowcntl9          :  1 ; /* bits 9:9 */
    ca_uint32_t rxflowcntl10         :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t rxflowcntl13         :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t txflowcntl0          :  1 ; /* bits 16:16 */
    ca_uint32_t txflowcntl1          :  1 ; /* bits 17:17 */
    ca_uint32_t txflowcntl2          :  1 ; /* bits 18:18 */
    ca_uint32_t txflowcntl3          :  1 ; /* bits 19:19 */
    ca_uint32_t txflowcntl4          :  1 ; /* bits 20:20 */
    ca_uint32_t txflowcntl5          :  1 ; /* bits 21:21 */
    ca_uint32_t txflowcntl6          :  1 ; /* bits 22:22 */
    ca_uint32_t txflowcntl7          :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t txflowcntl9          :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd4               :  1 ;
    ca_uint32_t txflowcntl11         :  1 ; /* bits 27:27 */
    ca_uint32_t txflowcntl12         :  1 ; /* bits 28:28 */
    ca_uint32_t txflowcntl13         :  1 ; /* bits 29:29 */
    ca_uint32_t txflowcntl14         :  1 ; /* bits 30:30 */
    ca_uint32_t txflowcntl15         :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_FC_GLB_INT_t;


#define L2TM_L2TE_FC_GLB_INTE                    0xf4302904
#define L2TM_L2TE_FC_GLB_INTE_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rxflowcntl0E         :  1 ; /* bits 0:0 */
    ca_uint32_t rxflowcntl1E         :  1 ; /* bits 1:1 */
    ca_uint32_t rxflowcntl2E         :  1 ; /* bits 2:2 */
    ca_uint32_t rxflowcntl3E         :  1 ; /* bits 3:3 */
    ca_uint32_t rxflowcntl4E         :  1 ; /* bits 4:4 */
    ca_uint32_t rxflowcntl5E         :  1 ; /* bits 5:5 */
    ca_uint32_t rxflowcntl6E         :  1 ; /* bits 6:6 */
    ca_uint32_t rxflowcntl7E         :  1 ; /* bits 7:7 */
    ca_uint32_t rxflowcntl8E         :  1 ; /* bits 8:8 */
    ca_uint32_t rxflowcntl9E         :  1 ; /* bits 9:9 */
    ca_uint32_t rxflowcntl10E        :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t rxflowcntl13E        :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t txflowcntl0E         :  1 ; /* bits 16:16 */
    ca_uint32_t txflowcntl1E         :  1 ; /* bits 17:17 */
    ca_uint32_t txflowcntl2E         :  1 ; /* bits 18:18 */
    ca_uint32_t txflowcntl3E         :  1 ; /* bits 19:19 */
    ca_uint32_t txflowcntl4E         :  1 ; /* bits 20:20 */
    ca_uint32_t txflowcntl5E         :  1 ; /* bits 21:21 */
    ca_uint32_t txflowcntl6E         :  1 ; /* bits 22:22 */
    ca_uint32_t txflowcntl7E         :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t txflowcntl9E         :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd4               :  1 ;
    ca_uint32_t txflowcntl11E        :  1 ; /* bits 27:27 */
    ca_uint32_t txflowcntl12E        :  1 ; /* bits 28:28 */
    ca_uint32_t txflowcntl13E        :  1 ; /* bits 29:29 */
    ca_uint32_t txflowcntl14E        :  1 ; /* bits 30:30 */
    ca_uint32_t txflowcntl15E        :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_FC_GLB_INTE_t;


#define L2TM_L2TE_FC_GLB_CTRL                    0xf4302908
#define L2TM_L2TE_FC_GLB_CTRL_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t deepq_rxpfc_en       :  8 ; /* bits 7:0 */
    ca_uint32_t cpu_rxpfc_en         :  8 ; /* bits 15:8 */
    ca_uint32_t l3fewan_rxpfc_en     :  8 ; /* bits 23:16 */
    ca_uint32_t l3felan_rxpfc_en     :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_FC_GLB_CTRL_t;


#define L2TM_L2TE_FC_GLB_STS                     0xf430290c
#define L2TM_L2TE_FC_GLB_STS_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t deepq_rxpfc          :  8 ; /* bits 7:0 */
    ca_uint32_t cpu_rxpfc            :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_FC_GLB_STS_t;


#define L2TM_L2TE_FC_GLB_TIMER                   0xf4302910
#define L2TM_L2TE_FC_GLB_TIMER_dft               0x000073ff

typedef volatile union {
  struct {
    ca_uint32_t num_of_cycles        : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t cycle_unit           :  3 ; /* bits 14:12 */
    ca_uint32_t rsrvd2               : 16 ;
    ca_uint32_t enable               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_FC_GLB_TIMER_t;


#define L2TM_L2TE_FC_GLB_PFC_CTRL0               0xf4302914
#define L2TM_L2TE_FC_GLB_PFC_CTRL0_STRIDE        8
#define L2TM_L2TE_FC_GLB_PFC_CTRL0_COUNT         2
#define L2TM_L2TE_FC_GLB_PFC_CTRL0_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cos_bmap             :  8 ; /* bits 7:0 */
    ca_uint32_t port_bmap            :  8 ; /* bits 15:8 */
    ca_uint32_t rxpfc_en             :  1 ; /* bits 16:16 */
    ca_uint32_t txpfc_en             :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_FC_GLB_PFC_CTRL0_t;


#define L2TM_L2TE_FC_GLB_PFC_CNT0                0xf4302918
#define L2TM_L2TE_FC_GLB_PFC_CNT0_STRIDE         8
#define L2TM_L2TE_FC_GLB_PFC_CNT0_COUNT          2
#define L2TM_L2TE_FC_GLB_PFC_CNT0_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_FC_GLB_PFC_CNT0_t;

            
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2te_fc_glb */
typedef struct {
  L2TM_L2TE_FC_GLB_INT_t                   INT;                           /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  L2TM_L2TE_FC_GLB_INTE_t                  INTE;                          /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  L2TM_L2TE_FC_GLB_CTRL_t                  CTRL;                          /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  L2TM_L2TE_FC_GLB_STS_t                   STS;                           /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  L2TM_L2TE_FC_GLB_TIMER_t                 TIMER;                         /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  L2TM_L2TE_FC_GLB_PFC_CTRL0_t             PFC_CTRL0;                     /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  L2TM_L2TE_FC_GLB_PFC_CNT0_t              PFC_CNT0;                      /* addr: 0x00000018 */
} APB0_L2TM_L2TE_FC_GLB_t;


/*
 * l2te_fc[0..13]
 */
        
#define L2TM_L2TE_FC_CTRL                        0xf4302980
#define L2TM_L2TE_FC_CTRL_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_en                :  1 ; /* bits 0:0 */
    ca_uint32_t tx_en                :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t stat_pri_sel         :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_FC_CTRL_t;


#define L2TM_L2TE_FC_STS                         0xf4302984
#define L2TM_L2TE_FC_STS_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rxpfc                :  8 ; /* bits 7:0 */
    ca_uint32_t txpfc                :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_FC_STS_t;


#define L2TM_L2TE_FC_STAT                        0xf4302988
#define L2TM_L2TE_FC_STAT_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t flag_num             :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t voq                  :  7 ; /* bits 10:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t qm_voq               :  9 ; /* bits 20:12 */
    ca_uint32_t rsrvd3               :  9 ;
    ca_uint32_t txpfc                :  1 ; /* bits 30:30 */
    ca_uint32_t rxpfc                :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_FC_STAT_t;

    
#define APB0_L2TM_L2TE_FC_STRIDE                 64
#define APB0_L2TM_L2TE_FC_COUNT                  14
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2te_fc */
typedef struct {
  L2TM_L2TE_FC_CTRL_t                      CTRL;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  L2TM_L2TE_FC_STS_t                       STS;                           /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  L2TM_L2TE_FC_STAT_t                      STAT;                          /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[55];                   
} APB0_L2TM_L2TE_FC_t;


/*
 * l2te_cb
 */
        
#define L2TM_L2TE_CB_INT                         0xf4302d00
#define L2TM_L2TE_CB_INT_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t voq_bufcnt_udfl      :  1 ; /* bits 0:0 */
    ca_uint32_t voq_bufcnt_ovfl      :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t port_freecnt_udfl    :  1 ; /* bits 4:4 */
    ca_uint32_t port_freecnt_ovfl    :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd2               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_INT_t;


#define L2TM_L2TE_CB_INTE                        0xf4302d04
#define L2TM_L2TE_CB_INTE_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t voq_bufcnt_udflE     :  1 ; /* bits 0:0 */
    ca_uint32_t voq_bufcnt_ovflE     :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t port_freecnt_udflE   :  1 ; /* bits 4:4 */
    ca_uint32_t port_freecnt_ovflE   :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd2               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_INTE_t;


#define L2TM_L2TE_CB_ERR_INFO                    0xf4302d08
#define L2TM_L2TE_CB_ERR_INFO_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t voq_of_buferr        :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_ERR_INFO_t;


#define L2TM_L2TE_CB_CTRL                        0xf4302d0c
#define L2TM_L2TE_CB_CTRL_dft                    0x0003ff03

typedef volatile union {
  struct {
    ca_uint32_t scan_cycle_per_run   :  8 ; /* bits 7:0 */
    ca_uint32_t scan_cycle_unit      : 10 ; /* bits 17:8 */
    ca_uint32_t rsrvd1               : 13 ;
    ca_uint32_t scan_enable          :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_CTRL_t;


#define L2TM_L2TE_CB_TM_DQSCH_HI_BUF_USG0        0xf4302d10
#define L2TM_L2TE_CB_TM_DQSCH_HI_BUF_USG0_STRIDE 4
#define L2TM_L2TE_CB_TM_DQSCH_HI_BUF_USG0_COUNT  2
#define L2TM_L2TE_CB_TM_DQSCH_HI_BUF_USG0_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dqid                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_TM_DQSCH_HI_BUF_USG0_t;

    
#define L2TM_L2TE_CB_TM_DQSCH_MID_BUF_USG0       0xf4302d18
#define L2TM_L2TE_CB_TM_DQSCH_MID_BUF_USG0_STRIDE 4
#define L2TM_L2TE_CB_TM_DQSCH_MID_BUF_USG0_COUNT 2
#define L2TM_L2TE_CB_TM_DQSCH_MID_BUF_USG0_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dqid                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_TM_DQSCH_MID_BUF_USG0_t;

    
#define L2TM_L2TE_CB_TM_TAILDROP_STS0            0xf4302d20
#define L2TM_L2TE_CB_TM_TAILDROP_STS0_STRIDE     4
#define L2TM_L2TE_CB_TM_TAILDROP_STS0_COUNT      4
#define L2TM_L2TE_CB_TM_TAILDROP_STS0_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t voq                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_TM_TAILDROP_STS0_t;

            
#define L2TM_L2TE_CB_QM_TAILDROP_STS0            0xf4302d30
#define L2TM_L2TE_CB_QM_TAILDROP_STS0_STRIDE     4
#define L2TM_L2TE_CB_QM_TAILDROP_STS0_COUNT      12
#define L2TM_L2TE_CB_QM_TAILDROP_STS0_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t voq                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_QM_TAILDROP_STS0_t;

                                            
#define L2TM_L2TE_CB_GLOB_TD_STS                 0xf4302d60
#define L2TM_L2TE_CB_GLOB_TD_STS_dft             0x0020ffff

typedef volatile union {
  struct {
    ca_uint32_t per_port_prvt_avl    : 16 ; /* bits 15:0 */
    ca_uint32_t noncong_buf_avl      :  1 ; /* bits 16:16 */
    ca_uint32_t common_buf_avl       :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t fc_buf_usg_l         :  1 ; /* bits 21:21 */
    ca_uint32_t fc_buf_usg_m         :  1 ; /* bits 22:22 */
    ca_uint32_t fc_buf_usg_h         :  1 ; /* bits 23:23 */
    ca_uint32_t pfc                  :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_GLOB_TD_STS_t;


#define L2TM_L2TE_CB_PORT_TD_STS                 0xf4302d64
#define L2TM_L2TE_CB_PORT_TD_STS_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t port                 : 16 ; /* bits 15:0 */
    ca_uint32_t src_port             : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_PORT_TD_STS_t;


#define L2TM_L2TE_CB_VOQ_TD_STS0                 0xf4302d68
#define L2TM_L2TE_CB_VOQ_TD_STS0_STRIDE          4
#define L2TM_L2TE_CB_VOQ_TD_STS0_COUNT           4
#define L2TM_L2TE_CB_VOQ_TD_STS0_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t voq                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VOQ_TD_STS0_t;

            
#define L2TM_L2TE_CB_SRC_PRI_TD_STS              0xf4302d78
#define L2TM_L2TE_CB_SRC_PRI_TD_STS_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t src_pri              : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_SRC_PRI_TD_STS_t;


#define L2TM_L2TE_CB_PORT_THRSH_PROFILE0         0xf4302d7c
#define L2TM_L2TE_CB_PORT_THRSH_PROFILE0_STRIDE  8
#define L2TM_L2TE_CB_PORT_THRSH_PROFILE0_COUNT   4
#define L2TM_L2TE_CB_PORT_THRSH_PROFILE0_dft     0x7fff7fff

typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t hth                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_PORT_THRSH_PROFILE0_t;


#define L2TM_L2TE_CB_PORT_GRPTHRSH_PROFILE0      0xf4302d80
#define L2TM_L2TE_CB_PORT_GRPTHRSH_PROFILE0_STRIDE 8
#define L2TM_L2TE_CB_PORT_GRPTHRSH_PROFILE0_COUNT 4
#define L2TM_L2TE_CB_PORT_GRPTHRSH_PROFILE0_dft  0x7fff7fff

typedef volatile union {
  struct {
    ca_uint32_t grplth               : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t grphth               : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_PORT_GRPTHRSH_PROFILE0_t;

                        
#define L2TM_L2TE_CB_PORT_THRSH_SELECT           0xf4302d9c
#define L2TM_L2TE_CB_PORT_THRSH_SELECT_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t thsel0               :  2 ; /* bits 1:0 */
    ca_uint32_t thsel1               :  2 ; /* bits 3:2 */
    ca_uint32_t thsel2               :  2 ; /* bits 5:4 */
    ca_uint32_t thsel3               :  2 ; /* bits 7:6 */
    ca_uint32_t thsel4               :  2 ; /* bits 9:8 */
    ca_uint32_t thsel5               :  2 ; /* bits 11:10 */
    ca_uint32_t thsel6               :  2 ; /* bits 13:12 */
    ca_uint32_t thsel7               :  2 ; /* bits 15:14 */
    ca_uint32_t thsel8               :  2 ; /* bits 17:16 */
    ca_uint32_t thsel9               :  2 ; /* bits 19:18 */
    ca_uint32_t thsel10              :  2 ; /* bits 21:20 */
    ca_uint32_t thsel11              :  2 ; /* bits 23:22 */
    ca_uint32_t thsel12              :  2 ; /* bits 25:24 */
    ca_uint32_t thsel13              :  2 ; /* bits 27:26 */
    ca_uint32_t thsel14              :  2 ; /* bits 29:28 */
    ca_uint32_t thsel15              :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_PORT_THRSH_SELECT_t;


#define L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_ACCESS 0xf4302da0
#define L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 27 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_ACCESS_t;


#define L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_DATA1 0xf4302da4
#define L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_DATA1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t grplth               : 13 ; /* bits 12:0 */
    ca_uint32_t grphth               : 15 ; /* bits 27:13 */
    ca_uint32_t rsrvd1               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_DATA1_t;


#define L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_DATA0 0xf4302da8
#define L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_DATA0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t hth                  : 15 ; /* bits 29:15 */
    ca_uint32_t grplth               :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_DATA0_t;


#define L2TM_L2TE_CB_VOQ_THRSH_SELECT_MEM_ACCESS 0xf4302dac
#define L2TM_L2TE_CB_VOQ_THRSH_SELECT_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VOQ_THRSH_SELECT_MEM_ACCESS_t;


#define L2TM_L2TE_CB_VOQ_THRSH_SELECT_MEM_DATA   0xf4302db0
#define L2TM_L2TE_CB_VOQ_THRSH_SELECT_MEM_DATA_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sel                  :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VOQ_THRSH_SELECT_MEM_DATA_t;


#define L2TM_L2TE_CB_PORT_FREECNT_MEM_ACCESS     0xf4302db4
#define L2TM_L2TE_CB_PORT_FREECNT_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_PORT_FREECNT_MEM_ACCESS_t;


#define L2TM_L2TE_CB_PORT_FREECNT_MEM_DATA       0xf4302db8
#define L2TM_L2TE_CB_PORT_FREECNT_MEM_DATA_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt0                 : 15 ; /* bits 14:0 */
    ca_uint32_t cnt0_msb             :  1 ; /* bits 15:15 */
    ca_uint32_t cnt1                 : 15 ; /* bits 30:16 */
    ca_uint32_t cnt1_msb             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_PORT_FREECNT_MEM_DATA_t;


#define L2TM_L2TE_CB_VOQ_BUFCNT_MEM_ACCESS       0xf4302dbc
#define L2TM_L2TE_CB_VOQ_BUFCNT_MEM_ACCESS_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VOQ_BUFCNT_MEM_ACCESS_t;


#define L2TM_L2TE_CB_VOQ_BUFCNT_MEM_DATA         0xf4302dc0
#define L2TM_L2TE_CB_VOQ_BUFCNT_MEM_DATA_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt0                 : 15 ; /* bits 14:0 */
    ca_uint32_t cnt0_rsvd            :  1 ; /* bits 15:15 */
    ca_uint32_t cnt1                 : 15 ; /* bits 30:16 */
    ca_uint32_t cnt1_rsvd            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VOQ_BUFCNT_MEM_DATA_t;


#define L2TM_L2TE_CB_VOQ_MAX_BUFCNT_MEM_ACCESS   0xf4302dc4
#define L2TM_L2TE_CB_VOQ_MAX_BUFCNT_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VOQ_MAX_BUFCNT_MEM_ACCESS_t;


#define L2TM_L2TE_CB_VOQ_MAX_BUFCNT_MEM_DATA     0xf4302dc8
#define L2TM_L2TE_CB_VOQ_MAX_BUFCNT_MEM_DATA_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_VOQ_MAX_BUFCNT_MEM_DATA_t;


#define L2TM_L2TE_CB_GLB_THRSH                   0xf4302dcc
#define L2TM_L2TE_CB_GLB_THRSH_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t hth                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_GLB_THRSH_t;


#define L2TM_L2TE_CB_GLB_PRI_THRSH0              0xf4302dd0
#define L2TM_L2TE_CB_GLB_PRI_THRSH0_STRIDE       4
#define L2TM_L2TE_CB_GLB_PRI_THRSH0_COUNT        8
#define L2TM_L2TE_CB_GLB_PRI_THRSH0_dft          0x7fff7fff

typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t hth                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_GLB_PRI_THRSH0_t;

                            
#define L2TM_L2TE_CB_SRC_CTRL                    0xf4302df0
#define L2TM_L2TE_CB_SRC_CTRL_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t src0_pri_nspid       :  3 ; /* bits 2:0 */
    ca_uint32_t src0_pri_en          :  1 ; /* bits 3:3 */
    ca_uint32_t src1_pri_nspid       :  3 ; /* bits 6:4 */
    ca_uint32_t src1_pri_en          :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_SRC_CTRL_t;


#define L2TM_L2TE_CB_SRC_PORT_THRSH_PROFILE0     0xf4302df4
#define L2TM_L2TE_CB_SRC_PORT_THRSH_PROFILE0_STRIDE 4
#define L2TM_L2TE_CB_SRC_PORT_THRSH_PROFILE0_COUNT 4
#define L2TM_L2TE_CB_SRC_PORT_THRSH_PROFILE0_dft 0x7fff7fff

typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t hth                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_SRC_PORT_THRSH_PROFILE0_t;

            
#define L2TM_L2TE_CB_SRC_PORT_THRSH_SELECT       0xf4302e04
#define L2TM_L2TE_CB_SRC_PORT_THRSH_SELECT_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t thsel0               :  2 ; /* bits 1:0 */
    ca_uint32_t thsel1               :  2 ; /* bits 3:2 */
    ca_uint32_t thsel2               :  2 ; /* bits 5:4 */
    ca_uint32_t thsel3               :  2 ; /* bits 7:6 */
    ca_uint32_t thsel4               :  2 ; /* bits 9:8 */
    ca_uint32_t thsel5               :  2 ; /* bits 11:10 */
    ca_uint32_t thsel6               :  2 ; /* bits 13:12 */
    ca_uint32_t thsel7               :  2 ; /* bits 15:14 */
    ca_uint32_t thsel8               :  2 ; /* bits 17:16 */
    ca_uint32_t thsel9               :  2 ; /* bits 19:18 */
    ca_uint32_t thsel10              :  2 ; /* bits 21:20 */
    ca_uint32_t thsel11              :  2 ; /* bits 23:22 */
    ca_uint32_t thsel12              :  2 ; /* bits 25:24 */
    ca_uint32_t thsel13              :  2 ; /* bits 27:26 */
    ca_uint32_t thsel14              :  2 ; /* bits 29:28 */
    ca_uint32_t thsel15              :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_SRC_PORT_THRSH_SELECT_t;


#define L2TM_L2TE_CB_SRC0_PRI_THRSH0             0xf4302e08
#define L2TM_L2TE_CB_SRC0_PRI_THRSH0_STRIDE      4
#define L2TM_L2TE_CB_SRC0_PRI_THRSH0_COUNT       8
#define L2TM_L2TE_CB_SRC0_PRI_THRSH0_dft         0x7fff7fff

typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t hth                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_SRC0_PRI_THRSH0_t;

                            
#define L2TM_L2TE_CB_SRC1_PRI_THRSH0             0xf4302e28
#define L2TM_L2TE_CB_SRC1_PRI_THRSH0_STRIDE      4
#define L2TM_L2TE_CB_SRC1_PRI_THRSH0_COUNT       8
#define L2TM_L2TE_CB_SRC1_PRI_THRSH0_dft         0x7fff7fff

typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t hth                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_SRC1_PRI_THRSH0_t;

                            
#define L2TM_L2TE_CB_SRC_PORT_BUFCNT_MEM_ACCESS  0xf4302e48
#define L2TM_L2TE_CB_SRC_PORT_BUFCNT_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_SRC_PORT_BUFCNT_MEM_ACCESS_t;


#define L2TM_L2TE_CB_SRC_PORT_BUFCNT_MEM_DATA    0xf4302e4c
#define L2TM_L2TE_CB_SRC_PORT_BUFCNT_MEM_DATA_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt0                 : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_SRC_PORT_BUFCNT_MEM_DATA_t;


#define L2TM_L2TE_CB_SRC_PRI_BUFCNT_MEM_ACCESS   0xf4302e50
#define L2TM_L2TE_CB_SRC_PRI_BUFCNT_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_SRC_PRI_BUFCNT_MEM_ACCESS_t;


#define L2TM_L2TE_CB_SRC_PRI_BUFCNT_MEM_DATA     0xf4302e54
#define L2TM_L2TE_CB_SRC_PRI_BUFCNT_MEM_DATA_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt0                 : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_SRC_PRI_BUFCNT_MEM_DATA_t;


#define L2TM_L2TE_CB_DQSCH_EQ_PROFILE_THRSH0     0xf4302e58
#define L2TM_L2TE_CB_DQSCH_EQ_PROFILE_THRSH0_dft 0x00007fff

typedef volatile union {
  struct {
    ca_uint32_t th0                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_DQSCH_EQ_PROFILE_THRSH0_t;


#define L2TM_L2TE_CB_DQSCH_PORT_THRSH_PROFILE0   0xf4302e5c
#define L2TM_L2TE_CB_DQSCH_PORT_THRSH_PROFILE0_STRIDE 4
#define L2TM_L2TE_CB_DQSCH_PORT_THRSH_PROFILE0_COUNT 4
#define L2TM_L2TE_CB_DQSCH_PORT_THRSH_PROFILE0_dft 0x7fff7fff

typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t hth                  : 15 ; /* bits 30:16 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_DQSCH_PORT_THRSH_PROFILE0_t;

            
#define L2TM_L2TE_CB_DQSCH_PORT_THRSH_SELECT     0xf4302e6c
#define L2TM_L2TE_CB_DQSCH_PORT_THRSH_SELECT_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t thsel0               :  2 ; /* bits 1:0 */
    ca_uint32_t thsel1               :  2 ; /* bits 3:2 */
    ca_uint32_t thsel2               :  2 ; /* bits 5:4 */
    ca_uint32_t thsel3               :  2 ; /* bits 7:6 */
    ca_uint32_t thsel4               :  2 ; /* bits 9:8 */
    ca_uint32_t thsel5               :  2 ; /* bits 11:10 */
    ca_uint32_t thsel6               :  2 ; /* bits 13:12 */
    ca_uint32_t thsel7               :  2 ; /* bits 15:14 */
    ca_uint32_t thsel8               :  2 ; /* bits 17:16 */
    ca_uint32_t thsel9               :  2 ; /* bits 19:18 */
    ca_uint32_t thsel10              :  2 ; /* bits 21:20 */
    ca_uint32_t thsel11              :  2 ; /* bits 23:22 */
    ca_uint32_t thsel12              :  2 ; /* bits 25:24 */
    ca_uint32_t thsel13              :  2 ; /* bits 27:26 */
    ca_uint32_t thsel14              :  2 ; /* bits 29:28 */
    ca_uint32_t thsel15              :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_DQSCH_PORT_THRSH_SELECT_t;


#define L2TM_L2TE_CB_DQSCH_VOQ_THRSH_PROFILE_MEM_ACCESS 0xf4302e70
#define L2TM_L2TE_CB_DQSCH_VOQ_THRSH_PROFILE_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 27 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_DQSCH_VOQ_THRSH_PROFILE_MEM_ACCESS_t;


#define L2TM_L2TE_CB_DQSCH_VOQ_THRSH_PROFILE_MEM_DATA 0xf4302e74
#define L2TM_L2TE_CB_DQSCH_VOQ_THRSH_PROFILE_MEM_DATA_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t lth                  : 15 ; /* bits 14:0 */
    ca_uint32_t hth                  : 15 ; /* bits 29:15 */
    ca_uint32_t rsrvd1               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_DQSCH_VOQ_THRSH_PROFILE_MEM_DATA_t;


#define L2TM_L2TE_CB_DQSCH_VOQ_THRSH_SELECT_MEM_ACCESS 0xf4302e78
#define L2TM_L2TE_CB_DQSCH_VOQ_THRSH_SELECT_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_DQSCH_VOQ_THRSH_SELECT_MEM_ACCESS_t;


#define L2TM_L2TE_CB_DQSCH_VOQ_THRSH_SELECT_MEM_DATA 0xf4302e7c
#define L2TM_L2TE_CB_DQSCH_VOQ_THRSH_SELECT_MEM_DATA_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sel                  :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_CB_DQSCH_VOQ_THRSH_SELECT_MEM_DATA_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2te_cb */
typedef struct {
  L2TM_L2TE_CB_INT_t                       INT;                           /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  L2TM_L2TE_CB_INTE_t                      INTE;                          /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  L2TM_L2TE_CB_ERR_INFO_t                  ERR_INFO;                      /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  L2TM_L2TE_CB_CTRL_t                      CTRL;                          /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  L2TM_L2TE_CB_TM_DQSCH_HI_BUF_USG0_t      TM_DQSCH_HI_BUF_USG0;          /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[7];                    
  L2TM_L2TE_CB_TM_DQSCH_MID_BUF_USG0_t     TM_DQSCH_MID_BUF_USG0;         /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd6[7];                    
  L2TM_L2TE_CB_TM_TAILDROP_STS0_t          TM_TAILDROP_STS0;              /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd7[15];                   
  L2TM_L2TE_CB_QM_TAILDROP_STS0_t          QM_TAILDROP_STS0;              /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd8[47];                   
  L2TM_L2TE_CB_GLOB_TD_STS_t               GLOB_TD_STS;                   /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd9[3];                    
  L2TM_L2TE_CB_PORT_TD_STS_t               PORT_TD_STS;                   /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd10[3];                   
  L2TM_L2TE_CB_VOQ_TD_STS0_t               VOQ_TD_STS0;                   /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd11[15];                  
  L2TM_L2TE_CB_SRC_PRI_TD_STS_t            SRC_PRI_TD_STS;                /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd12[3];                   
  L2TM_L2TE_CB_PORT_THRSH_PROFILE0_t       PORT_THRSH_PROFILE0;           /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd13[3];                   
  L2TM_L2TE_CB_PORT_GRPTHRSH_PROFILE0_t    PORT_GRPTHRSH_PROFILE0;        /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd14[27];                  
  L2TM_L2TE_CB_PORT_THRSH_SELECT_t         PORT_THRSH_SELECT;             /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd15[3];                   
  L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_ACCESS_t VOQ_THRSH_PROFILE_MEM_ACCESS;  /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd16[3];                   
  L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_DATA1_t VOQ_THRSH_PROFILE_MEM_DATA1;   /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd17[3];                   
  L2TM_L2TE_CB_VOQ_THRSH_PROFILE_MEM_DATA0_t VOQ_THRSH_PROFILE_MEM_DATA0;   /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd18[3];                   
  L2TM_L2TE_CB_VOQ_THRSH_SELECT_MEM_ACCESS_t VOQ_THRSH_SELECT_MEM_ACCESS;   /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd19[3];                   
  L2TM_L2TE_CB_VOQ_THRSH_SELECT_MEM_DATA_t VOQ_THRSH_SELECT_MEM_DATA;     /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd20[3];                   
  L2TM_L2TE_CB_PORT_FREECNT_MEM_ACCESS_t   PORT_FREECNT_MEM_ACCESS;       /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd21[3];                   
  L2TM_L2TE_CB_PORT_FREECNT_MEM_DATA_t     PORT_FREECNT_MEM_DATA;         /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd22[3];                   
  L2TM_L2TE_CB_VOQ_BUFCNT_MEM_ACCESS_t     VOQ_BUFCNT_MEM_ACCESS;         /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd23[3];                   
  L2TM_L2TE_CB_VOQ_BUFCNT_MEM_DATA_t       VOQ_BUFCNT_MEM_DATA;           /* addr: 0x000000c0 */
  ca_uint32_t                              rsrvd24[3];                   
  L2TM_L2TE_CB_VOQ_MAX_BUFCNT_MEM_ACCESS_t VOQ_MAX_BUFCNT_MEM_ACCESS;     /* addr: 0x000000c4 */
  ca_uint32_t                              rsrvd25[3];                   
  L2TM_L2TE_CB_VOQ_MAX_BUFCNT_MEM_DATA_t   VOQ_MAX_BUFCNT_MEM_DATA;       /* addr: 0x000000c8 */
  ca_uint32_t                              rsrvd26[3];                   
  L2TM_L2TE_CB_GLB_THRSH_t                 GLB_THRSH;                     /* addr: 0x000000cc */
  ca_uint32_t                              rsrvd27[3];                   
  L2TM_L2TE_CB_GLB_PRI_THRSH0_t            GLB_PRI_THRSH0;                /* addr: 0x000000d0 */
  ca_uint32_t                              rsrvd28[31];                  
  L2TM_L2TE_CB_SRC_CTRL_t                  SRC_CTRL;                      /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd29[3];                   
  L2TM_L2TE_CB_SRC_PORT_THRSH_PROFILE0_t   SRC_PORT_THRSH_PROFILE0;       /* addr: 0x000000f4 */
  ca_uint32_t                              rsrvd30[15];                  
  L2TM_L2TE_CB_SRC_PORT_THRSH_SELECT_t     SRC_PORT_THRSH_SELECT;         /* addr: 0x00000104 */
  ca_uint32_t                              rsrvd31[3];                   
  L2TM_L2TE_CB_SRC0_PRI_THRSH0_t           SRC0_PRI_THRSH0;               /* addr: 0x00000108 */
  ca_uint32_t                              rsrvd32[31];                  
  L2TM_L2TE_CB_SRC1_PRI_THRSH0_t           SRC1_PRI_THRSH0;               /* addr: 0x00000128 */
  ca_uint32_t                              rsrvd33[31];                  
  L2TM_L2TE_CB_SRC_PORT_BUFCNT_MEM_ACCESS_t SRC_PORT_BUFCNT_MEM_ACCESS;    /* addr: 0x00000148 */
  ca_uint32_t                              rsrvd34[3];                   
  L2TM_L2TE_CB_SRC_PORT_BUFCNT_MEM_DATA_t  SRC_PORT_BUFCNT_MEM_DATA;      /* addr: 0x0000014c */
  ca_uint32_t                              rsrvd35[3];                   
  L2TM_L2TE_CB_SRC_PRI_BUFCNT_MEM_ACCESS_t SRC_PRI_BUFCNT_MEM_ACCESS;     /* addr: 0x00000150 */
  ca_uint32_t                              rsrvd36[3];                   
  L2TM_L2TE_CB_SRC_PRI_BUFCNT_MEM_DATA_t   SRC_PRI_BUFCNT_MEM_DATA;       /* addr: 0x00000154 */
  ca_uint32_t                              rsrvd37[3];                   
  L2TM_L2TE_CB_DQSCH_EQ_PROFILE_THRSH0_t   DQSCH_EQ_PROFILE_THRSH0;       /* addr: 0x00000158 */
  ca_uint32_t                              rsrvd38[3];                   
  L2TM_L2TE_CB_DQSCH_PORT_THRSH_PROFILE0_t DQSCH_PORT_THRSH_PROFILE0;     /* addr: 0x0000015c */
  ca_uint32_t                              rsrvd39[15];                  
  L2TM_L2TE_CB_DQSCH_PORT_THRSH_SELECT_t   DQSCH_PORT_THRSH_SELECT;       /* addr: 0x0000016c */
  ca_uint32_t                              rsrvd40[3];                   
  L2TM_L2TE_CB_DQSCH_VOQ_THRSH_PROFILE_MEM_ACCESS_t DQSCH_VOQ_THRSH_PROFILE_MEM_ACCESS; /* addr: 0x00000170 */
  ca_uint32_t                              rsrvd41[3];                   
  L2TM_L2TE_CB_DQSCH_VOQ_THRSH_PROFILE_MEM_DATA_t DQSCH_VOQ_THRSH_PROFILE_MEM_DATA; /* addr: 0x00000174 */
  ca_uint32_t                              rsrvd42[3];                   
  L2TM_L2TE_CB_DQSCH_VOQ_THRSH_SELECT_MEM_ACCESS_t DQSCH_VOQ_THRSH_SELECT_MEM_ACCESS; /* addr: 0x00000178 */
  ca_uint32_t                              rsrvd43[3];                   
  L2TM_L2TE_CB_DQSCH_VOQ_THRSH_SELECT_MEM_DATA_t DQSCH_VOQ_THRSH_SELECT_MEM_DATA; /* addr: 0x0000017c */
} APB0_L2TM_L2TE_CB_t;


/*
 * l2te_pm
 */
        
#define L2TM_L2TE_PM_CTRL                        0xf4302f00
#define L2TM_L2TE_PM_CTRL_dft                    0x00000ca0

typedef volatile union {
  struct {
    ca_uint32_t cnt_saturate         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t mem_saturate         :  1 ; /* bits 4:4 */
    ca_uint32_t mem_auto_clr_on_read :  1 ; /* bits 5:5 */
    ca_uint32_t mem_init             :  1 ; /* bits 6:6 */
    ca_uint32_t mem_disable          :  1 ; /* bits 7:7 */
    ca_uint32_t cnt0_mem_event_sel   :  1 ; /* bits 8:8 */
    ca_uint32_t cnt0_mem_id_sel      :  1 ; /* bits 9:9 */
    ca_uint32_t cnt1_mem_event_sel   :  1 ; /* bits 10:10 */
    ca_uint32_t cnt1_mem_id_sel      :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd2               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_CTRL_t;


#define L2TM_L2TE_PM_EVENT_CFG_0                 0xf4302f04
#define L2TM_L2TE_PM_EVENT_CFG_0_dft             0x33445550

typedef volatile union {
  struct {
    ca_uint32_t cnt0_lo              :  4 ; /* bits 3:0 */
    ca_uint32_t cnt0_hi              :  4 ; /* bits 7:4 */
    ca_uint32_t cnt1_lo              :  4 ; /* bits 11:8 */
    ca_uint32_t cnt1_hi              :  4 ; /* bits 15:12 */
    ca_uint32_t cnt2_lo              :  4 ; /* bits 19:16 */
    ca_uint32_t cnt2_hi              :  4 ; /* bits 23:20 */
    ca_uint32_t cnt3_lo              :  4 ; /* bits 27:24 */
    ca_uint32_t cnt3_hi              :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_EVENT_CFG_0_t;


#define L2TM_L2TE_PM_EVENT_CFG_1                 0xf4302f08
#define L2TM_L2TE_PM_EVENT_CFG_1_dft             0x33445550

typedef volatile union {
  struct {
    ca_uint32_t cnt0_lo              :  4 ; /* bits 3:0 */
    ca_uint32_t cnt0_hi              :  4 ; /* bits 7:4 */
    ca_uint32_t cnt1_lo              :  4 ; /* bits 11:8 */
    ca_uint32_t cnt1_hi              :  4 ; /* bits 15:12 */
    ca_uint32_t cnt2_lo              :  4 ; /* bits 19:16 */
    ca_uint32_t cnt2_hi              :  4 ; /* bits 23:20 */
    ca_uint32_t cnt3_lo              :  4 ; /* bits 27:24 */
    ca_uint32_t cnt3_hi              :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_EVENT_CFG_1_t;


#define L2TM_L2TE_PM_STS                         0xf4302f0c
#define L2TM_L2TE_PM_STS_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pcnt0_init_done      :  1 ; /* bits 0:0 */
    ca_uint32_t pcnt1_init_done      :  1 ; /* bits 1:1 */
    ca_uint32_t bcnt0_init_done      :  1 ; /* bits 2:2 */
    ca_uint32_t bcnt1_init_done      :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_STS_t;


#define L2TM_L2TE_PM_PCNT                        0xf4302f10
#define L2TM_L2TE_PM_PCNT_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_PCNT_t;


#define L2TM_L2TE_PM_PRE_MARK_PCNT               0xf4302f14
#define L2TM_L2TE_PM_PRE_MARK_PCNT_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_PRE_MARK_PCNT_t;


#define L2TM_L2TE_PM_POL_DROP_PCNT               0xf4302f18
#define L2TM_L2TE_PM_POL_DROP_PCNT_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_POL_DROP_PCNT_t;


#define L2TM_L2TE_PM_TAIL_DROP_PCNT              0xf4302f1c
#define L2TM_L2TE_PM_TAIL_DROP_PCNT_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_TAIL_DROP_PCNT_t;


#define L2TM_L2TE_PM_WRED_Y_DROP_PCNT            0xf4302f20
#define L2TM_L2TE_PM_WRED_Y_DROP_PCNT_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_WRED_Y_DROP_PCNT_t;


#define L2TM_L2TE_PM_WRED_G_DROP_PCNT            0xf4302f24
#define L2TM_L2TE_PM_WRED_G_DROP_PCNT_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_WRED_G_DROP_PCNT_t;


#define L2TM_L2TE_PM_MARK_PCNT                   0xf4302f28
#define L2TM_L2TE_PM_MARK_PCNT_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_MARK_PCNT_t;


#define L2TM_L2TE_PM_POL_MARK_PCNT               0xf4302f2c
#define L2TM_L2TE_PM_POL_MARK_PCNT_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_POL_MARK_PCNT_t;


#define L2TM_L2TE_PM_BYPASS_PCNT                 0xf4302f30
#define L2TM_L2TE_PM_BYPASS_PCNT_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_BYPASS_PCNT_t;


#define L2TM_L2TE_PM_BYPASS_FLOW_PCNT            0xf4302f34
#define L2TM_L2TE_PM_BYPASS_FLOW_PCNT_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_BYPASS_FLOW_PCNT_t;


#define L2TM_L2TE_PM_CE_PCNT                     0xf4302f38
#define L2TM_L2TE_PM_CE_PCNT_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_CE_PCNT_t;


#define L2TM_L2TE_PM_CNT_MEM_ACCESS              0xf4302f3c
#define L2TM_L2TE_PM_CNT_MEM_ACCESS_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 20 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_CNT_MEM_ACCESS_t;


#define L2TM_L2TE_PM_CNT_MEM_DATA8               0xf4302f40
#define L2TM_L2TE_PM_CNT_MEM_DATA8_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt7                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_CNT_MEM_DATA8_t;


#define L2TM_L2TE_PM_CNT_MEM_DATA7               0xf4302f44
#define L2TM_L2TE_PM_CNT_MEM_DATA7_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt6                 : 12 ; /* bits 11:0 */
    ca_uint32_t cnt7                 : 20 ; /* bits 31:12 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_CNT_MEM_DATA7_t;


#define L2TM_L2TE_PM_CNT_MEM_DATA6               0xf4302f48
#define L2TM_L2TE_PM_CNT_MEM_DATA6_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt5                 :  8 ; /* bits 7:0 */
    ca_uint32_t cnt6                 : 24 ; /* bits 31:8 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_CNT_MEM_DATA6_t;


#define L2TM_L2TE_PM_CNT_MEM_DATA5               0xf4302f4c
#define L2TM_L2TE_PM_CNT_MEM_DATA5_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt4                 :  4 ; /* bits 3:0 */
    ca_uint32_t cnt5                 : 28 ; /* bits 31:4 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_CNT_MEM_DATA5_t;


#define L2TM_L2TE_PM_CNT_MEM_DATA4               0xf4302f50
#define L2TM_L2TE_PM_CNT_MEM_DATA4_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt4                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_CNT_MEM_DATA4_t;


#define L2TM_L2TE_PM_CNT_MEM_DATA3               0xf4302f54
#define L2TM_L2TE_PM_CNT_MEM_DATA3_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt3                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_CNT_MEM_DATA3_t;


#define L2TM_L2TE_PM_CNT_MEM_DATA2               0xf4302f58
#define L2TM_L2TE_PM_CNT_MEM_DATA2_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt2                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_CNT_MEM_DATA2_t;


#define L2TM_L2TE_PM_CNT_MEM_DATA1               0xf4302f5c
#define L2TM_L2TE_PM_CNT_MEM_DATA1_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_CNT_MEM_DATA1_t;


#define L2TM_L2TE_PM_CNT_MEM_DATA0               0xf4302f60
#define L2TM_L2TE_PM_CNT_MEM_DATA0_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L2TM_L2TE_PM_CNT_MEM_DATA0_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* l2te_pm */
typedef struct {
  L2TM_L2TE_PM_CTRL_t                      CTRL;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  L2TM_L2TE_PM_EVENT_CFG_0_t               EVENT_CFG_0;                   /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  L2TM_L2TE_PM_EVENT_CFG_1_t               EVENT_CFG_1;                   /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  L2TM_L2TE_PM_STS_t                       STS;                           /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  L2TM_L2TE_PM_PCNT_t                      PCNT;                          /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  L2TM_L2TE_PM_PRE_MARK_PCNT_t             PRE_MARK_PCNT;                 /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  L2TM_L2TE_PM_POL_DROP_PCNT_t             POL_DROP_PCNT;                 /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  L2TM_L2TE_PM_TAIL_DROP_PCNT_t            TAIL_DROP_PCNT;                /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  L2TM_L2TE_PM_WRED_Y_DROP_PCNT_t          WRED_Y_DROP_PCNT;              /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  L2TM_L2TE_PM_WRED_G_DROP_PCNT_t          WRED_G_DROP_PCNT;              /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  L2TM_L2TE_PM_MARK_PCNT_t                 MARK_PCNT;                     /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  L2TM_L2TE_PM_POL_MARK_PCNT_t             POL_MARK_PCNT;                 /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  L2TM_L2TE_PM_BYPASS_PCNT_t               BYPASS_PCNT;                   /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  L2TM_L2TE_PM_BYPASS_FLOW_PCNT_t          BYPASS_FLOW_PCNT;              /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  L2TM_L2TE_PM_CE_PCNT_t                   CE_PCNT;                       /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  L2TM_L2TE_PM_CNT_MEM_ACCESS_t            CNT_MEM_ACCESS;                /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  L2TM_L2TE_PM_CNT_MEM_DATA8_t             CNT_MEM_DATA8;                 /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  L2TM_L2TE_PM_CNT_MEM_DATA7_t             CNT_MEM_DATA7;                 /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  L2TM_L2TE_PM_CNT_MEM_DATA6_t             CNT_MEM_DATA6;                 /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  L2TM_L2TE_PM_CNT_MEM_DATA5_t             CNT_MEM_DATA5;                 /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  L2TM_L2TE_PM_CNT_MEM_DATA4_t             CNT_MEM_DATA4;                 /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  L2TM_L2TE_PM_CNT_MEM_DATA3_t             CNT_MEM_DATA3;                 /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  L2TM_L2TE_PM_CNT_MEM_DATA2_t             CNT_MEM_DATA2;                 /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  L2TM_L2TE_PM_CNT_MEM_DATA1_t             CNT_MEM_DATA1;                 /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  L2TM_L2TE_PM_CNT_MEM_DATA0_t             CNT_MEM_DATA0;                 /* addr: 0x00000060 */
} APB0_L2TM_L2TE_PM_t;

    
  
        
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* L2TM */

typedef struct {
  APB0_L2TM_L2TM_GLB_t                     l2tm_glb;                      /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[243];                  
  APB0_L2TM_L2TM_BM_t                      l2tm_bm;                       /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd2[179];                  
  APB0_L2TM_L2TM_QM_t                      l2tm_qm;                       /* addr: 0x00000200 */
  ca_uint32_t                              rsrvd3[169];                  
  APB0_L2TM_L2TM_ES_t                      l2tm_es;                       /* addr: 0x00000300 */
  ca_uint32_t                              rsrvd4[133];                  
  APB0_L2TM_L2TE_GLB_t                     l2te_glb;                      /* addr: 0x00000400 */
  ca_uint32_t                              rsrvd5[241];                  
  APB0_L2TM_L2TE_POL_t                     l2te_pol;                      /* addr: 0x00000500 */
  ca_uint32_t                              rsrvd6[357];                  
  APB0_L2TM_L2TE_SHP_t                     l2te_shp;                      /* addr: 0x00000700 */
  ca_uint32_t                              rsrvd7[223];                  
  APB0_L2TM_L2TE_WRED_t                    l2te_wred;                     /* addr: 0x00000800 */
  ca_uint32_t                              rsrvd8[227];                  
  APB0_L2TM_L2TE_FC_GLB_t                  l2te_fc_glb;                   /* addr: 0x00000900 */
  ca_uint32_t                              rsrvd9[111];                  
  APB0_L2TM_L2TE_FC_t                      l2te_fc[14];                   /* addr: 0x00000980 */
  APB0_L2TM_L2TE_CB_t                      l2te_cb;                       /* addr: 0x00000d00 */
  ca_uint32_t                              rsrvd10[321];                 
  APB0_L2TM_L2TE_PM_t                      l2te_pm;                       /* addr: 0x00000f00 */
} APB0_L2TM_t;


/*
 * L3FE
 */
  
/*
 * GLB
 */
        
#define L3FE_GLB_EGRESS_L3_IF_TBL_ACCESS         0xf4303000
#define L3FE_GLB_EGRESS_L3_IF_TBL_ACCESS_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_EGRESS_L3_IF_TBL_ACCESS_t;


#define L3FE_GLB_EGRESS_L3_IF_TBL_DATA2          0xf4303004
#define L3FE_GLB_EGRESS_L3_IF_TBL_DATA2_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t PPPOE_SESSION_ID     :  9 ; /* bits 8:0 */
    ca_uint32_t MAC_DA_VLD           :  1 ; /* bits 9:9 */
    ca_uint32_t MAC_DA_AN_SEL        :  4 ; /* bits 13:10 */
    ca_uint32_t MAC_SA_VLD           :  1 ; /* bits 14:14 */
    ca_uint32_t MAC_SA_AN_SEL        :  4 ; /* bits 18:15 */
    ca_uint32_t L2_FORMAT_VLD        :  1 ; /* bits 19:19 */
    ca_uint32_t L2_FORMAT            :  1 ; /* bits 20:20 */
    ca_uint32_t LDPID_VLD            :  1 ; /* bits 21:21 */
    ca_uint32_t LDPID                :  6 ; /* bits 27:22 */
    ca_uint32_t DEEP_Q               :  1 ; /* bits 28:28 */
    ca_uint32_t STAGE3_CTRL_VLD      :  1 ; /* bits 29:29 */
    ca_uint32_t STAGE3_CTRL          :  1 ; /* bits 30:30 */
    ca_uint32_t rsrvd1               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_EGRESS_L3_IF_TBL_DATA2_t;


#define L3FE_GLB_EGRESS_L3_IF_TBL_DATA1          0xf4303008
#define L3FE_GLB_EGRESS_L3_IF_TBL_DATA1_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t INNER_TPID_ENC       :  3 ; /* bits 2:0 */
    ca_uint32_t TOP_DEI_SEL          :  2 ; /* bits 4:3 */
    ca_uint32_t TOP_DEI              :  1 ; /* bits 5:5 */
    ca_uint32_t TOP_VID              : 12 ; /* bits 17:6 */
    ca_uint32_t TOP_TPID_ENC         :  3 ; /* bits 20:18 */
    ca_uint32_t VLAN_CNT             :  2 ; /* bits 22:21 */
    ca_uint32_t PPPOE_SET            :  1 ; /* bits 23:23 */
    ca_uint32_t PPPOE_VLD            :  1 ; /* bits 24:24 */
    ca_uint32_t PPPOE_SESSION_ID     :  7 ; /* bits 31:25 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_EGRESS_L3_IF_TBL_DATA1_t;


#define L3FE_GLB_EGRESS_L3_IF_TBL_DATA0          0xf430300c
#define L3FE_GLB_EGRESS_L3_IF_TBL_DATA0_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t MTU_VLD              :  1 ; /* bits 0:0 */
    ca_uint32_t MTU_ENC              :  2 ; /* bits 2:1 */
    ca_uint32_t INNER_802_1P_SEL     :  3 ; /* bits 5:3 */
    ca_uint32_t INNER_802_1P         :  3 ; /* bits 8:6 */
    ca_uint32_t TOP_802_1P_SEL       :  3 ; /* bits 11:9 */
    ca_uint32_t TOP_802_1P           :  3 ; /* bits 14:12 */
    ca_uint32_t QOS_802_1P_TABLE_SEL :  1 ; /* bits 15:15 */
    ca_uint32_t VLAN_VLD             :  1 ; /* bits 16:16 */
    ca_uint32_t INNER_DEI_SEL        :  2 ; /* bits 18:17 */
    ca_uint32_t INNER_DEI            :  1 ; /* bits 19:19 */
    ca_uint32_t INNER_VID            : 12 ; /* bits 31:20 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_EGRESS_L3_IF_TBL_DATA0_t;


#define L3FE_GLB_DSCP_MAP_TBL_ACCESS             0xf4303010
#define L3FE_GLB_DSCP_MAP_TBL_ACCESS_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DSCP_MAP_TBL_ACCESS_t;


#define L3FE_GLB_DSCP_MAP_TBL_DATA1              0xf4303014
#define L3FE_GLB_DSCP_MAP_TBL_DATA1_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dscp_2_pf1_dscp      :  2 ; /* bits 1:0 */
    ca_uint32_t dscp_2_pf1_cos       :  4 ; /* bits 5:2 */
    ca_uint32_t dscp_2_pf1_pol_id    :  9 ; /* bits 14:6 */
    ca_uint32_t dscp_2_pf1_pol_grp_id :  3 ; /* bits 17:15 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DSCP_MAP_TBL_DATA1_t;


#define L3FE_GLB_DSCP_MAP_TBL_DATA0              0xf4303018
#define L3FE_GLB_DSCP_MAP_TBL_DATA0_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dscp_2_pf0_dot1p     :  3 ; /* bits 2:0 */
    ca_uint32_t dscp_2_pf0_dscp      :  6 ; /* bits 8:3 */
    ca_uint32_t dscp_2_pf0_cos       :  4 ; /* bits 12:9 */
    ca_uint32_t dscp_2_pf0_pol_id    :  9 ; /* bits 21:13 */
    ca_uint32_t dscp_2_pf0_pol_grp_id :  3 ; /* bits 24:22 */
    ca_uint32_t dscp_2_pf1_dot1p     :  3 ; /* bits 27:25 */
    ca_uint32_t dscp_2_pf1_dscp      :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DSCP_MAP_TBL_DATA0_t;


#define L3FE_GLB_DOT1P_MAPPING_0_0               0xf430301c
#define L3FE_GLB_DOT1P_MAPPING_0_0_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_0_0_t;


#define L3FE_GLB_DOT1P_MAPPING_1_0               0xf4303020
#define L3FE_GLB_DOT1P_MAPPING_1_0_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_1_0_t;


#define L3FE_GLB_DOT1P_MAPPING_0_1               0xf4303024
#define L3FE_GLB_DOT1P_MAPPING_0_1_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_0_1_t;


#define L3FE_GLB_DOT1P_MAPPING_1_1               0xf4303028
#define L3FE_GLB_DOT1P_MAPPING_1_1_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_1_1_t;


#define L3FE_GLB_DOT1P_MAPPING_0_2               0xf430302c
#define L3FE_GLB_DOT1P_MAPPING_0_2_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_0_2_t;


#define L3FE_GLB_DOT1P_MAPPING_1_2               0xf4303030
#define L3FE_GLB_DOT1P_MAPPING_1_2_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_1_2_t;


#define L3FE_GLB_DOT1P_MAPPING_0_3               0xf4303034
#define L3FE_GLB_DOT1P_MAPPING_0_3_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_0_3_t;


#define L3FE_GLB_DOT1P_MAPPING_1_3               0xf4303038
#define L3FE_GLB_DOT1P_MAPPING_1_3_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_1_3_t;


#define L3FE_GLB_DOT1P_MAPPING_0_4               0xf430303c
#define L3FE_GLB_DOT1P_MAPPING_0_4_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_0_4_t;


#define L3FE_GLB_DOT1P_MAPPING_1_4               0xf4303040
#define L3FE_GLB_DOT1P_MAPPING_1_4_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_1_4_t;


#define L3FE_GLB_DOT1P_MAPPING_0_5               0xf4303044
#define L3FE_GLB_DOT1P_MAPPING_0_5_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_0_5_t;


#define L3FE_GLB_DOT1P_MAPPING_1_5               0xf4303048
#define L3FE_GLB_DOT1P_MAPPING_1_5_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_1_5_t;


#define L3FE_GLB_DOT1P_MAPPING_0_6               0xf430304c
#define L3FE_GLB_DOT1P_MAPPING_0_6_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_0_6_t;


#define L3FE_GLB_DOT1P_MAPPING_1_6               0xf4303050
#define L3FE_GLB_DOT1P_MAPPING_1_6_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_1_6_t;


#define L3FE_GLB_DOT1P_MAPPING_0_7               0xf4303054
#define L3FE_GLB_DOT1P_MAPPING_0_7_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_0_7_t;


#define L3FE_GLB_DOT1P_MAPPING_1_7               0xf4303058
#define L3FE_GLB_DOT1P_MAPPING_1_7_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DOT1P_MAPPING_1_7_t;


#define L3FE_GLB_COS_MAPPING_0_0                 0xf430305c
#define L3FE_GLB_COS_MAPPING_0_0_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_0_0_t;


#define L3FE_GLB_COS_MAPPING_1_0                 0xf4303060
#define L3FE_GLB_COS_MAPPING_1_0_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_1_0_t;


#define L3FE_GLB_COS_MAPPING_0_1                 0xf4303064
#define L3FE_GLB_COS_MAPPING_0_1_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_0_1_t;


#define L3FE_GLB_COS_MAPPING_1_1                 0xf4303068
#define L3FE_GLB_COS_MAPPING_1_1_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_1_1_t;


#define L3FE_GLB_COS_MAPPING_0_2                 0xf430306c
#define L3FE_GLB_COS_MAPPING_0_2_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_0_2_t;


#define L3FE_GLB_COS_MAPPING_1_2                 0xf4303070
#define L3FE_GLB_COS_MAPPING_1_2_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_1_2_t;


#define L3FE_GLB_COS_MAPPING_0_3                 0xf4303074
#define L3FE_GLB_COS_MAPPING_0_3_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_0_3_t;


#define L3FE_GLB_COS_MAPPING_1_3                 0xf4303078
#define L3FE_GLB_COS_MAPPING_1_3_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_1_3_t;


#define L3FE_GLB_COS_MAPPING_0_4                 0xf430307c
#define L3FE_GLB_COS_MAPPING_0_4_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_0_4_t;


#define L3FE_GLB_COS_MAPPING_1_4                 0xf4303080
#define L3FE_GLB_COS_MAPPING_1_4_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_1_4_t;


#define L3FE_GLB_COS_MAPPING_0_5                 0xf4303084
#define L3FE_GLB_COS_MAPPING_0_5_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_0_5_t;


#define L3FE_GLB_COS_MAPPING_1_5                 0xf4303088
#define L3FE_GLB_COS_MAPPING_1_5_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_1_5_t;


#define L3FE_GLB_COS_MAPPING_0_6                 0xf430308c
#define L3FE_GLB_COS_MAPPING_0_6_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_0_6_t;


#define L3FE_GLB_COS_MAPPING_1_6                 0xf4303090
#define L3FE_GLB_COS_MAPPING_1_6_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_1_6_t;


#define L3FE_GLB_COS_MAPPING_0_7                 0xf4303094
#define L3FE_GLB_COS_MAPPING_0_7_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_0_7_t;


#define L3FE_GLB_COS_MAPPING_1_7                 0xf4303098
#define L3FE_GLB_COS_MAPPING_1_7_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_COS_MAPPING_1_7_t;


#define L3FE_GLB_FWD_CTRL_0                      0xf430309c
#define L3FE_GLB_FWD_CTRL_0_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t change_to_llc        :  1 ; /* bits 0:0 */
    ca_uint32_t ipv4_change_ipv6     :  1 ; /* bits 1:1 */
    ca_uint32_t llc_raw8023_change   :  1 ; /* bits 2:2 */
    ca_uint32_t nonip_change_ip      :  1 ; /* bits 3:3 */
    ca_uint32_t nonip_add_pppoe      :  1 ; /* bits 4:4 */
    ca_uint32_t nonl4_change_l4      :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_FWD_CTRL_0_t;


#define L3FE_GLB_FWD_CTRL_1                      0xf43030a0
#define L3FE_GLB_FWD_CTRL_1_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t change_to_llc        :  1 ; /* bits 0:0 */
    ca_uint32_t ipv4_change_ipv6     :  1 ; /* bits 1:1 */
    ca_uint32_t llc_raw8023_change   :  1 ; /* bits 2:2 */
    ca_uint32_t nonip_change_ip      :  1 ; /* bits 3:3 */
    ca_uint32_t nonip_add_pppoe      :  1 ; /* bits 4:4 */
    ca_uint32_t nonl4_change_l4      :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_FWD_CTRL_1_t;


#define L3FE_GLB_FWD_CTRL_2                      0xf43030a4
#define L3FE_GLB_FWD_CTRL_2_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t change_to_llc        :  1 ; /* bits 0:0 */
    ca_uint32_t ipv4_change_ipv6     :  1 ; /* bits 1:1 */
    ca_uint32_t llc_raw8023_change   :  1 ; /* bits 2:2 */
    ca_uint32_t nonip_change_ip      :  1 ; /* bits 3:3 */
    ca_uint32_t nonip_add_pppoe      :  1 ; /* bits 4:4 */
    ca_uint32_t nonl4_change_l4      :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_FWD_CTRL_2_t;


#define L3FE_GLB_FWD_CTRL_3                      0xf43030a8
#define L3FE_GLB_FWD_CTRL_3_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t change_to_llc        :  1 ; /* bits 0:0 */
    ca_uint32_t ipv4_change_ipv6     :  1 ; /* bits 1:1 */
    ca_uint32_t llc_raw8023_change   :  1 ; /* bits 2:2 */
    ca_uint32_t nonip_change_ip      :  1 ; /* bits 3:3 */
    ca_uint32_t nonip_add_pppoe      :  1 ; /* bits 4:4 */
    ca_uint32_t nonl4_change_l4      :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_FWD_CTRL_3_t;


#define L3FE_GLB_GLB_CFG                         0xf43030ac
#define L3FE_GLB_GLB_CFG_dft                     0x0001b000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  6 ;
    ca_uint32_t spcl_port            :  6 ; /* bits 11:6 */
    ca_uint32_t mc_port              :  6 ; /* bits 17:12 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t ni_fe_12_bv          :  1 ; /* bits 21:21 */
    ca_uint32_t pl_mode              :  2 ; /* bits 23:22 */
    ca_uint32_t rsrvd3               :  7 ;
    ca_uint32_t l3fe_pon_mode        :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_GLB_CFG_t;


#define L3FE_GLB_LF_CFG                          0xf43030b0
#define L3FE_GLB_LF_CFG_dft                      0x004641f4

typedef volatile union {
  struct {
    ca_uint32_t hi_threshold         : 10 ; /* bits 9:0 */
    ca_uint32_t low_threshold        : 10 ; /* bits 19:10 */
    ca_uint32_t wr_fifo_threshold    :  4 ; /* bits 23:20 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_LF_CFG_t;


#define L3FE_GLB_ILPB_01                         0xf43030b4
#define L3FE_GLB_ILPB_01_STRIDE                  8
#define L3FE_GLB_ILPB_01_COUNT                   4
#define L3FE_GLB_ILPB_01_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t entry1               : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_ILPB_01_t;


#define L3FE_GLB_ILPB_00                         0xf43030b8
#define L3FE_GLB_ILPB_00_STRIDE                  8
#define L3FE_GLB_ILPB_00_COUNT                   4
#define L3FE_GLB_ILPB_00_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t entry0               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_ILPB_00_t;

                        
#define L3FE_GLB_ILPB_LDPID                      0xf43030d4
#define L3FE_GLB_ILPB_LDPID_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t valid0               :  1 ; /* bits 0:0 */
    ca_uint32_t ldpid0               :  6 ; /* bits 6:1 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t valid1               :  1 ; /* bits 8:8 */
    ca_uint32_t ldpid1               :  6 ; /* bits 14:9 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t valid2               :  1 ; /* bits 16:16 */
    ca_uint32_t ldpid2               :  6 ; /* bits 22:17 */
    ca_uint32_t valid3               :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd3               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_ILPB_LDPID_t;


#define L3FE_GLB_ELPB1                           0xf43030d8
#define L3FE_GLB_ELPB1_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t entry1               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_ELPB1_t;


#define L3FE_GLB_ELPB0                           0xf43030dc
#define L3FE_GLB_ELPB0_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t entry0               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_ELPB0_t;


#define L3FE_GLB_ELPB_DEEPQ_VLD1                 0xf43030e0
#define L3FE_GLB_ELPB_DEEPQ_VLD1_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ldpid1               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_ELPB_DEEPQ_VLD1_t;


#define L3FE_GLB_ELPB_DEEPQ_VLD0                 0xf43030e4
#define L3FE_GLB_ELPB_DEEPQ_VLD0_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ldpid0               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_ELPB_DEEPQ_VLD0_t;


#define L3FE_GLB_ELPB_DEEPQ1                     0xf43030e8
#define L3FE_GLB_ELPB_DEEPQ1_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ldpid1               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_ELPB_DEEPQ1_t;


#define L3FE_GLB_ELPB_DEEPQ0                     0xf43030ec
#define L3FE_GLB_ELPB_DEEPQ0_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ldpid0               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_ELPB_DEEPQ0_t;


#define L3FE_GLB_L3FE_L2FE_LDPID                 0xf43030f0
#define L3FE_GLB_L3FE_L2FE_LDPID_dft             0x00000019

typedef volatile union {
  struct {
    ca_uint32_t ldpid                :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_L3FE_L2FE_LDPID_t;


#define L3FE_GLB_VE                              0xf43030f4
#define L3FE_GLB_VE_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t stag_tpid_enc        :  3 ; /* bits 2:0 */
    ca_uint32_t ctag_tpid_enc        :  3 ; /* bits 5:3 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_VE_t;


#define L3FE_GLB_T5_OPTION                       0xf43030f8
#define L3FE_GLB_T5_OPTION_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bits                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_T5_OPTION_t;


#define L3FE_GLB_TE_OPTION                       0xf43030fc
#define L3FE_GLB_TE_OPTION_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bits                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_TE_OPTION_t;


#define L3FE_GLB_CLS_STG_MONITOR_CTRL            0xf4303100
#define L3FE_GLB_CLS_STG_MONITOR_CTRL_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bus_sel              :  8 ; /* bits 7:0 */
    ca_uint32_t enable               :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_CLS_STG_MONITOR_CTRL_t;


#define L3FE_GLB_CLS_STG_MONITOR_RETURN          0xf4303104
#define L3FE_GLB_CLS_STG_MONITOR_RETURN_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_CLS_STG_MONITOR_RETURN_t;


#define L3FE_GLB_DBG_IDX                         0xf4303108
#define L3FE_GLB_DBG_IDX_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t idx                  : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DBG_IDX_t;


#define L3FE_GLB_DBG_DAT                         0xf430310c
#define L3FE_GLB_DBG_DAT_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dat                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_GLB_DBG_DAT_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* GLB */
typedef struct {
  L3FE_GLB_EGRESS_L3_IF_TBL_ACCESS_t       EGRESS_L3_IF_TBL_ACCESS;       /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  L3FE_GLB_EGRESS_L3_IF_TBL_DATA2_t        EGRESS_L3_IF_TBL_DATA2;        /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  L3FE_GLB_EGRESS_L3_IF_TBL_DATA1_t        EGRESS_L3_IF_TBL_DATA1;        /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  L3FE_GLB_EGRESS_L3_IF_TBL_DATA0_t        EGRESS_L3_IF_TBL_DATA0;        /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  L3FE_GLB_DSCP_MAP_TBL_ACCESS_t           DSCP_MAP_TBL_ACCESS;           /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  L3FE_GLB_DSCP_MAP_TBL_DATA1_t            DSCP_MAP_TBL_DATA1;            /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  L3FE_GLB_DSCP_MAP_TBL_DATA0_t            DSCP_MAP_TBL_DATA0;            /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  L3FE_GLB_DOT1P_MAPPING_0_0_t             DOT1P_MAPPING_0_0;             /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  L3FE_GLB_DOT1P_MAPPING_1_0_t             DOT1P_MAPPING_1_0;             /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  L3FE_GLB_DOT1P_MAPPING_0_1_t             DOT1P_MAPPING_0_1;             /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  L3FE_GLB_DOT1P_MAPPING_1_1_t             DOT1P_MAPPING_1_1;             /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  L3FE_GLB_DOT1P_MAPPING_0_2_t             DOT1P_MAPPING_0_2;             /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  L3FE_GLB_DOT1P_MAPPING_1_2_t             DOT1P_MAPPING_1_2;             /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  L3FE_GLB_DOT1P_MAPPING_0_3_t             DOT1P_MAPPING_0_3;             /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  L3FE_GLB_DOT1P_MAPPING_1_3_t             DOT1P_MAPPING_1_3;             /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  L3FE_GLB_DOT1P_MAPPING_0_4_t             DOT1P_MAPPING_0_4;             /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  L3FE_GLB_DOT1P_MAPPING_1_4_t             DOT1P_MAPPING_1_4;             /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  L3FE_GLB_DOT1P_MAPPING_0_5_t             DOT1P_MAPPING_0_5;             /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  L3FE_GLB_DOT1P_MAPPING_1_5_t             DOT1P_MAPPING_1_5;             /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  L3FE_GLB_DOT1P_MAPPING_0_6_t             DOT1P_MAPPING_0_6;             /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  L3FE_GLB_DOT1P_MAPPING_1_6_t             DOT1P_MAPPING_1_6;             /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  L3FE_GLB_DOT1P_MAPPING_0_7_t             DOT1P_MAPPING_0_7;             /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  L3FE_GLB_DOT1P_MAPPING_1_7_t             DOT1P_MAPPING_1_7;             /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  L3FE_GLB_COS_MAPPING_0_0_t               COS_MAPPING_0_0;               /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  L3FE_GLB_COS_MAPPING_1_0_t               COS_MAPPING_1_0;               /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  L3FE_GLB_COS_MAPPING_0_1_t               COS_MAPPING_0_1;               /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  L3FE_GLB_COS_MAPPING_1_1_t               COS_MAPPING_1_1;               /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  L3FE_GLB_COS_MAPPING_0_2_t               COS_MAPPING_0_2;               /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  L3FE_GLB_COS_MAPPING_1_2_t               COS_MAPPING_1_2;               /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  L3FE_GLB_COS_MAPPING_0_3_t               COS_MAPPING_0_3;               /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  L3FE_GLB_COS_MAPPING_1_3_t               COS_MAPPING_1_3;               /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  L3FE_GLB_COS_MAPPING_0_4_t               COS_MAPPING_0_4;               /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  L3FE_GLB_COS_MAPPING_1_4_t               COS_MAPPING_1_4;               /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  L3FE_GLB_COS_MAPPING_0_5_t               COS_MAPPING_0_5;               /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  L3FE_GLB_COS_MAPPING_1_5_t               COS_MAPPING_1_5;               /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  L3FE_GLB_COS_MAPPING_0_6_t               COS_MAPPING_0_6;               /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  L3FE_GLB_COS_MAPPING_1_6_t               COS_MAPPING_1_6;               /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  L3FE_GLB_COS_MAPPING_0_7_t               COS_MAPPING_0_7;               /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  L3FE_GLB_COS_MAPPING_1_7_t               COS_MAPPING_1_7;               /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];                   
  L3FE_GLB_FWD_CTRL_0_t                    FWD_CTRL_0;                    /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];                   
  L3FE_GLB_FWD_CTRL_1_t                    FWD_CTRL_1;                    /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];                   
  L3FE_GLB_FWD_CTRL_2_t                    FWD_CTRL_2;                    /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];                   
  L3FE_GLB_FWD_CTRL_3_t                    FWD_CTRL_3;                    /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];                   
  L3FE_GLB_GLB_CFG_t                       GLB_CFG;                       /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd44[3];                   
  L3FE_GLB_LF_CFG_t                        LF_CFG;                        /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd45[3];                   
  L3FE_GLB_ILPB_01_t                       ILPB_01;                       /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd46[3];                   
  L3FE_GLB_ILPB_00_t                       ILPB_00;                       /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd47[27];                  
  L3FE_GLB_ILPB_LDPID_t                    ILPB_LDPID;                    /* addr: 0x000000d4 */
  ca_uint32_t                              rsrvd48[3];                   
  L3FE_GLB_ELPB1_t                         ELPB1;                         /* addr: 0x000000d8 */
  ca_uint32_t                              rsrvd49[3];                   
  L3FE_GLB_ELPB0_t                         ELPB0;                         /* addr: 0x000000dc */
  ca_uint32_t                              rsrvd50[3];                   
  L3FE_GLB_ELPB_DEEPQ_VLD1_t               ELPB_DEEPQ_VLD1;               /* addr: 0x000000e0 */
  ca_uint32_t                              rsrvd51[3];                   
  L3FE_GLB_ELPB_DEEPQ_VLD0_t               ELPB_DEEPQ_VLD0;               /* addr: 0x000000e4 */
  ca_uint32_t                              rsrvd52[3];                   
  L3FE_GLB_ELPB_DEEPQ1_t                   ELPB_DEEPQ1;                   /* addr: 0x000000e8 */
  ca_uint32_t                              rsrvd53[3];                   
  L3FE_GLB_ELPB_DEEPQ0_t                   ELPB_DEEPQ0;                   /* addr: 0x000000ec */
  ca_uint32_t                              rsrvd54[3];                   
  L3FE_GLB_L3FE_L2FE_LDPID_t               L3FE_L2FE_LDPID;               /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd55[3];                   
  L3FE_GLB_VE_t                            VE;                            /* addr: 0x000000f4 */
  ca_uint32_t                              rsrvd56[3];                   
  L3FE_GLB_T5_OPTION_t                     T5_OPTION;                     /* addr: 0x000000f8 */
  ca_uint32_t                              rsrvd57[3];                   
  L3FE_GLB_TE_OPTION_t                     TE_OPTION;                     /* addr: 0x000000fc */
  ca_uint32_t                              rsrvd58[3];                   
  L3FE_GLB_CLS_STG_MONITOR_CTRL_t          CLS_STG_MONITOR_CTRL;          /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd59[3];                   
  L3FE_GLB_CLS_STG_MONITOR_RETURN_t        CLS_STG_MONITOR_RETURN;        /* addr: 0x00000104 */
  ca_uint32_t                              rsrvd60[3];                   
  L3FE_GLB_DBG_IDX_t                       DBG_IDX;                       /* addr: 0x00000108 */
  ca_uint32_t                              rsrvd61[3];                   
  L3FE_GLB_DBG_DAT_t                       DBG_DAT;                       /* addr: 0x0000010c */
} APB0_L3FE_GLB_t;


/*
 * PP
 */
        
#define L3FE_PP_FIELD_CAM_ACCESS                 0xf4303200
#define L3FE_PP_FIELD_CAM_ACCESS_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 : 20 ; /* bits 19:0 */
    ca_uint32_t rsrvd1               : 10 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_FIELD_CAM_ACCESS_t;


#define L3FE_PP_FIELD_CAM_DATA4                  0xf4303204
#define L3FE_PP_FIELD_CAM_DATA4_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_FIELD_CAM_DATA4_t;


#define L3FE_PP_FIELD_CAM_DATA3                  0xf4303208
#define L3FE_PP_FIELD_CAM_DATA3_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_FIELD_CAM_DATA3_t;


#define L3FE_PP_FIELD_CAM_DATA2                  0xf430320c
#define L3FE_PP_FIELD_CAM_DATA2_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_FIELD_CAM_DATA2_t;


#define L3FE_PP_FIELD_CAM_DATA1                  0xf4303210
#define L3FE_PP_FIELD_CAM_DATA1_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_FIELD_CAM_DATA1_t;


#define L3FE_PP_FIELD_CAM_DATA0                  0xf4303214
#define L3FE_PP_FIELD_CAM_DATA0_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_FIELD_CAM_DATA0_t;


#define L3FE_PP_SPCL_PKT_DETECTION_CFG           0xf4303218
#define L3FE_PP_SPCL_PKT_DETECTION_CFG_dft       0x0739dc24

typedef volatile union {
  struct {
    ca_uint32_t check_arp_target_ip  :  1 ; /* bits 0:0 */
    ca_uint32_t mpcp_opcode_en       :  1 ; /* bits 1:1 */
    ca_uint32_t my_mac_enable        :  1 ; /* bits 2:2 */
    ca_uint32_t type_0_en            :  1 ; /* bits 3:3 */
    ca_uint32_t type_1_en            :  1 ; /* bits 4:4 */
    ca_uint32_t udp_lite_enable      :  1 ; /* bits 5:5 */
    ca_uint32_t user_def_spcl_0_en   :  1 ; /* bits 6:6 */
    ca_uint32_t user_def_spcl_1_en   :  1 ; /* bits 7:7 */
    ca_uint32_t user_def_spcl_2_en   :  1 ; /* bits 8:8 */
    ca_uint32_t user_def_spcl_3_en   :  1 ; /* bits 9:9 */
    ca_uint32_t l2_spcl_hdr_en       :  1 ; /* bits 10:10 */
    ca_uint32_t l3_spcl_hdr_en       :  1 ; /* bits 11:11 */
    ca_uint32_t l4_spcl_hdr_en       :  1 ; /* bits 12:12 */
    ca_uint32_t user_define_hi_pri   :  1 ; /* bits 13:13 */
    ca_uint32_t rdp_v1_detection_en  :  1 ; /* bits 14:14 */
    ca_uint32_t ipv4_chksum_chk_enable :  1 ; /* bits 15:15 */
    ca_uint32_t l4_chksum_chk_enable :  1 ; /* bits 16:16 */
    ca_uint32_t l4_chksum_rh_chk_enable :  1 ; /* bits 17:17 */
    ca_uint32_t chksum_err_drop      :  6 ; /* bits 23:18 */
    ca_uint32_t bpdu_mac_08_en       :  1 ; /* bits 24:24 */
    ca_uint32_t subtype_en           :  1 ; /* bits 25:25 */
    ca_uint32_t rdp_l4_msgs_det_en   :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t drop_udp_ov_ip6_cs_zero_en :  1 ; /* bits 28:28 */
    ca_uint32_t ni2fe_pkt_cnt_wrap_en :  1 ; /* bits 29:29 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_SPCL_PKT_DETECTION_CFG_t;


#define L3FE_PP_IPNIP_SPCL_PKT_DET_EN            0xf430321c
#define L3FE_PP_IPNIP_SPCL_PKT_DET_EN_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dhcpv4               :  1 ; /* bits 0:0 */
    ca_uint32_t dhcpv6               :  1 ; /* bits 1:1 */
    ca_uint32_t l4ptp                :  1 ; /* bits 2:2 */
    ca_uint32_t dns                  :  1 ; /* bits 3:3 */
    ca_uint32_t rip                  :  1 ; /* bits 4:4 */
    ca_uint32_t ssdp                 :  1 ; /* bits 5:5 */
    ca_uint32_t l4_msgs              :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_IPNIP_SPCL_PKT_DET_EN_t;


#define L3FE_PP_OFFSET_HDR                       0xf4303220
#define L3FE_PP_OFFSET_HDR_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t offset               :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_OFFSET_HDR_t;


#define L3FE_PP_PARSING_LMT                      0xf4303224
#define L3FE_PP_PARSING_LMT_dft                  0x00000014

typedef volatile union {
  struct {
    ca_uint32_t offset               :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_PARSING_LMT_t;


#define L3FE_PP_PARSING_STTS_0                   0xf4303228
#define L3FE_PP_PARSING_STTS_0_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t parsing_err          :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_PARSING_STTS_0_t;


#define L3FE_PP_PARSING_STTS_1                   0xf430322c
#define L3FE_PP_PARSING_STTS_1_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t parsing_err          : 20 ; /* bits 19:0 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_PARSING_STTS_1_t;


#define L3FE_PP_PARSING_ERR_FWD_0                0xf4303230
#define L3FE_PP_PARSING_ERR_FWD_0_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 10 ;
    ca_uint32_t ipv4_hdr_cs_err      :  2 ; /* bits 11:10 */
    ca_uint32_t pkt_l2_size_err      :  2 ; /* bits 13:12 */
    ca_uint32_t pkt_l3_total_len_err :  2 ; /* bits 15:14 */
    ca_uint32_t ip_hdr_err           :  2 ; /* bits 17:16 */
    ca_uint32_t ipv4_total_len_err   :  2 ; /* bits 19:18 */
    ca_uint32_t tcp_data_offset_err  :  2 ; /* bits 21:20 */
    ca_uint32_t udp_total_len_err    :  2 ; /* bits 23:22 */
    ca_uint32_t udp_lite_cs_cvrg_err :  2 ; /* bits 25:24 */
    ca_uint32_t rdp_hdr_len_err      :  2 ; /* bits 27:26 */
    ca_uint32_t offset_l3_excd_255_err :  2 ; /* bits 29:28 */
    ca_uint32_t offset_l4_excd_255_err :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_PARSING_ERR_FWD_0_t;


#define L3FE_PP_PARSING_ERR_FWD_1                0xf4303234
#define L3FE_PP_PARSING_ERR_FWD_1_dft            0x00005000

typedef volatile union {
  struct {
    ca_uint32_t dsl_inner_ip_hdr_cs_err :  2 ; /* bits 1:0 */
    ca_uint32_t pkt_inner_l3_total_len_err :  2 ; /* bits 3:2 */
    ca_uint32_t inner_ip_hdr_err     :  2 ; /* bits 5:4 */
    ca_uint32_t dsl_inner_ipv4_total_len_err :  2 ; /* bits 7:6 */
    ca_uint32_t offset_l3_inner_excd_255_err :  2 ; /* bits 9:8 */
    ca_uint32_t udp_zero_chksum_err  :  2 ; /* bits 11:10 */
    ca_uint32_t more_than_2_vlan_tags_flg :  2 ; /* bits 13:12 */
    ca_uint32_t l2tp_hdr_err         :  2 ; /* bits 15:14 */
    ca_uint32_t rdp_ver_err          :  2 ; /* bits 17:16 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_PARSING_ERR_FWD_1_t;


#define L3FE_PP_PARSING_ERR_TRAP                 0xf4303238
#define L3FE_PP_PARSING_ERR_TRAP_dft             0xfffffa10

typedef volatile union {
  struct {
    ca_uint32_t rdir_ldpid           :  6 ; /* bits 5:0 */
    ca_uint32_t rdir_cos             :  3 ; /* bits 8:6 */
    ca_uint32_t keep_orig_pkt        :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t t0_ctrl              :  1 ; /* bits 11:11 */
    ca_uint32_t t1_ctrl              :  4 ; /* bits 15:12 */
    ca_uint32_t t2_ctrl              :  4 ; /* bits 19:16 */
    ca_uint32_t t3_ctrl              :  4 ; /* bits 23:20 */
    ca_uint32_t t4_ctrl              :  4 ; /* bits 27:24 */
    ca_uint32_t t5_ctrl              :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_PARSING_ERR_TRAP_t;


#define L3FE_PP_PARSING_OVER_VLAN_FWD_CTL        0xf430323c
#define L3FE_PP_PARSING_OVER_VLAN_FWD_CTL_dft    0xfffffa10

typedef volatile union {
  struct {
    ca_uint32_t rdir_ldpid           :  6 ; /* bits 5:0 */
    ca_uint32_t rdir_cos             :  3 ; /* bits 8:6 */
    ca_uint32_t keep_orig_pkt        :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t t0_ctrl              :  1 ; /* bits 11:11 */
    ca_uint32_t t1_ctrl              :  4 ; /* bits 15:12 */
    ca_uint32_t t2_ctrl              :  4 ; /* bits 19:16 */
    ca_uint32_t t3_ctrl              :  4 ; /* bits 23:20 */
    ca_uint32_t t4_ctrl              :  4 ; /* bits 27:24 */
    ca_uint32_t t5_ctrl              :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_PARSING_OVER_VLAN_FWD_CTL_t;


#define L3FE_PP_USER_TYPE_0                      0xf4303240
#define L3FE_PP_USER_TYPE_0_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t user_type_0          : 16 ; /* bits 15:0 */
    ca_uint32_t user_type_1          : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_USER_TYPE_0_t;


#define L3FE_PP_USER_TYPE_1                      0xf4303244
#define L3FE_PP_USER_TYPE_1_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t user_type_2          : 16 ; /* bits 15:0 */
    ca_uint32_t user_type_3          : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_USER_TYPE_1_t;


#define L3FE_PP_USER_MAC_0_LOW                   0xf4303248
#define L3FE_PP_USER_MAC_0_LOW_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t user_mac_0           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_USER_MAC_0_LOW_t;


#define L3FE_PP_USER_MAC_0_HI                    0xf430324c
#define L3FE_PP_USER_MAC_0_HI_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t user_mac_0           : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_USER_MAC_0_HI_t;


#define L3FE_PP_USER_MAC_1_LOW                   0xf4303250
#define L3FE_PP_USER_MAC_1_LOW_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t user_mac_1           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_USER_MAC_1_LOW_t;


#define L3FE_PP_USER_MAC_1_HI                    0xf4303254
#define L3FE_PP_USER_MAC_1_HI_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t user_mac_1           : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_USER_MAC_1_HI_t;


#define L3FE_PP_USER_MAC_0_MASK_LOW              0xf4303258
#define L3FE_PP_USER_MAC_0_MASK_LOW_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t user_mac_mask_0      : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_USER_MAC_0_MASK_LOW_t;


#define L3FE_PP_USER_MAC_0_MASK_HI               0xf430325c
#define L3FE_PP_USER_MAC_0_MASK_HI_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t user_mac_mask_0      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_USER_MAC_0_MASK_HI_t;


#define L3FE_PP_USER_MAC_1_MASK_LOW              0xf4303260
#define L3FE_PP_USER_MAC_1_MASK_LOW_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t user_mac_mask_1      : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_USER_MAC_1_MASK_LOW_t;


#define L3FE_PP_USER_MAC_1_MASK_HI               0xf4303264
#define L3FE_PP_USER_MAC_1_MASK_HI_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t user_mac_mask_1      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_USER_MAC_1_MASK_HI_t;


#define L3FE_PP_TPID_0                           0xf4303268
#define L3FE_PP_TPID_0_dft                       0x88a88100

typedef volatile union {
  struct {
    ca_uint32_t tpid_0               : 16 ; /* bits 15:0 */
    ca_uint32_t tpid_1               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_TPID_0_t;


#define L3FE_PP_TPID_1                           0xf430326c
#define L3FE_PP_TPID_1_dft                       0x92009100

typedef volatile union {
  struct {
    ca_uint32_t tpid_2               : 16 ; /* bits 15:0 */
    ca_uint32_t tpid_3               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_TPID_1_t;


#define L3FE_PP_TPID_CTRL                        0xf4303270
#define L3FE_PP_TPID_CTRL_dft                    0x00000077

typedef volatile union {
  struct {
    ca_uint32_t top_vlan_en          :  4 ; /* bits 3:0 */
    ca_uint32_t inner_vlan_en        :  4 ; /* bits 7:4 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_TPID_CTRL_t;


#define L3FE_PP_ARP_TARGET_IP                    0xf4303274
#define L3FE_PP_ARP_TARGET_IP_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t target_ip            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_ARP_TARGET_IP_t;


#define L3FE_PP_OAM                              0xf4303278
#define L3FE_PP_OAM_dft                          0x00000803

typedef volatile union {
  struct {
    ca_uint32_t subtype              :  8 ; /* bits 7:0 */
    ca_uint32_t mymdlvl              :  3 ; /* bits 10:8 */
    ca_uint32_t mymdlvl_det_en       :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_OAM_t;


#define L3FE_PP_HELLO_MAC_LOW                    0xf430327c
#define L3FE_PP_HELLO_MAC_LOW_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_HELLO_MAC_LOW_t;


#define L3FE_PP_HELLO_MAC_HI                     0xf4303280
#define L3FE_PP_HELLO_MAC_HI_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_HELLO_MAC_HI_t;


#define L3FE_PP_MY_MAC_LOW                       0xf4303284
#define L3FE_PP_MY_MAC_LOW_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mymac                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_MY_MAC_LOW_t;


#define L3FE_PP_MY_MAC_HI                        0xf4303288
#define L3FE_PP_MY_MAC_HI_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mymac                : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_MY_MAC_HI_t;


#define L3FE_PP_MC_MAC_HI_RNG                    0xf430328c
#define L3FE_PP_MC_MAC_HI_RNG_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hi_rng_mac_low       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_MC_MAC_HI_RNG_t;


#define L3FE_PP_MC_MAC_LOW_RNG                   0xf4303290
#define L3FE_PP_MC_MAC_LOW_RNG_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t low_rng_mac_low      : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_MC_MAC_LOW_RNG_t;


#define L3FE_PP_MC_MAC_RNG                       0xf4303294
#define L3FE_PP_MC_MAC_RNG_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t low_rng_mac_hi       : 16 ; /* bits 15:0 */
    ca_uint32_t hi_rng_mac_hi        : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_MC_MAC_RNG_t;


#define L3FE_PP_HTTP_LINK_0                      0xf4303298
#define L3FE_PP_HTTP_LINK_0_dft                  0x04000000

typedef volatile union {
  struct {
    ca_uint32_t rule_l4_pid          : 16 ; /* bits 15:0 */
    ca_uint32_t rule_l4_pid_sel      :  1 ; /* bits 16:16 */
    ca_uint32_t rule_l4_type         :  3 ; /* bits 19:17 */
    ca_uint32_t rule_lspid           :  6 ; /* bits 25:20 */
    ca_uint32_t rule_lspid_msk       :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t rule_vld             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_HTTP_LINK_0_t;


#define L3FE_PP_HTTP_LINK_1                      0xf430329c
#define L3FE_PP_HTTP_LINK_1_dft                  0x04000000

typedef volatile union {
  struct {
    ca_uint32_t rule_l4_pid          : 16 ; /* bits 15:0 */
    ca_uint32_t rule_l4_pid_sel      :  1 ; /* bits 16:16 */
    ca_uint32_t rule_l4_type         :  3 ; /* bits 19:17 */
    ca_uint32_t rule_lspid           :  6 ; /* bits 25:20 */
    ca_uint32_t rule_lspid_msk       :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t rule_vld             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_HTTP_LINK_1_t;


#define L3FE_PP_HTTP_LINK_2                      0xf43032a0
#define L3FE_PP_HTTP_LINK_2_dft                  0x04000000

typedef volatile union {
  struct {
    ca_uint32_t rule_l4_pid          : 16 ; /* bits 15:0 */
    ca_uint32_t rule_l4_pid_sel      :  1 ; /* bits 16:16 */
    ca_uint32_t rule_l4_type         :  3 ; /* bits 19:17 */
    ca_uint32_t rule_lspid           :  6 ; /* bits 25:20 */
    ca_uint32_t rule_lspid_msk       :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t rule_vld             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_HTTP_LINK_2_t;


#define L3FE_PP_HTTP_LINK_3                      0xf43032a4
#define L3FE_PP_HTTP_LINK_3_dft                  0x04000000

typedef volatile union {
  struct {
    ca_uint32_t rule_l4_pid          : 16 ; /* bits 15:0 */
    ca_uint32_t rule_l4_pid_sel      :  1 ; /* bits 16:16 */
    ca_uint32_t rule_l4_type         :  3 ; /* bits 19:17 */
    ca_uint32_t rule_lspid           :  6 ; /* bits 25:20 */
    ca_uint32_t rule_lspid_msk       :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t rule_vld             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_HTTP_LINK_3_t;


#define L3FE_PP_PINGPONG_STS                     0xf43032a8
#define L3FE_PP_PINGPONG_STS_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ovfl                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_PINGPONG_STS_t;


#define L3FE_PP_NI_INTF_ERR_STTS_0               0xf43032ac
#define L3FE_PP_NI_INTF_ERR_STTS_0_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sop_eop_mismatch     :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_NI_INTF_ERR_STTS_0_t;


#define L3FE_PP_NI_INTF_ERR_STTS_1               0xf43032b0
#define L3FE_PP_NI_INTF_ERR_STTS_1_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t runt_l2_pkt          :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_NI_INTF_ERR_STTS_1_t;


#define L3FE_PP_NI_INTF_STS                      0xf43032b4
#define L3FE_PP_NI_INTF_STS_dft                  0x00000001

typedef volatile union {
  struct {
    ca_uint32_t rdy                  :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_NI_INTF_STS_t;


#define L3FE_PP_NI_INTF_PKT_CNT                  0xf43032b8
#define L3FE_PP_NI_INTF_PKT_CNT_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t eop                  : 16 ; /* bits 15:0 */
    ca_uint32_t sop                  : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_NI_INTF_PKT_CNT_t;


#define L3FE_PP_L4_CS_ERR                        0xf43032bc
#define L3FE_PP_L4_CS_ERR_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_L4_CS_ERR_t;


#define L3FE_PP_HEADER_A_LOW                     0xf43032c0
#define L3FE_PP_HEADER_A_LOW_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_HEADER_A_LOW_t;


#define L3FE_PP_HEADER_A_HI                      0xf43032c4
#define L3FE_PP_HEADER_A_HI_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_HEADER_A_HI_t;


#define L3FE_PP_HEADER_CPU_LOW                   0xf43032c8
#define L3FE_PP_HEADER_CPU_LOW_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_HEADER_CPU_LOW_t;


#define L3FE_PP_HEADER_CPU_HI                    0xf43032cc
#define L3FE_PP_HEADER_CPU_HI_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_HEADER_CPU_HI_t;


#define L3FE_PP_NI2FE_INTF_FF_STS                0xf43032d0
#define L3FE_PP_NI2FE_INTF_FF_STS_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ovfl                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PP_NI2FE_INTF_FF_STS_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PP */
typedef struct {
  L3FE_PP_FIELD_CAM_ACCESS_t               FIELD_CAM_ACCESS;              /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  L3FE_PP_FIELD_CAM_DATA4_t                FIELD_CAM_DATA4;               /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  L3FE_PP_FIELD_CAM_DATA3_t                FIELD_CAM_DATA3;               /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  L3FE_PP_FIELD_CAM_DATA2_t                FIELD_CAM_DATA2;               /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  L3FE_PP_FIELD_CAM_DATA1_t                FIELD_CAM_DATA1;               /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  L3FE_PP_FIELD_CAM_DATA0_t                FIELD_CAM_DATA0;               /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  L3FE_PP_SPCL_PKT_DETECTION_CFG_t         SPCL_PKT_DETECTION_CFG;        /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  L3FE_PP_IPNIP_SPCL_PKT_DET_EN_t          IPNIP_SPCL_PKT_DET_EN;         /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  L3FE_PP_OFFSET_HDR_t                     OFFSET_HDR;                    /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  L3FE_PP_PARSING_LMT_t                    PARSING_LMT;                   /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  L3FE_PP_PARSING_STTS_0_t                 PARSING_STTS_0;                /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  L3FE_PP_PARSING_STTS_1_t                 PARSING_STTS_1;                /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  L3FE_PP_PARSING_ERR_FWD_0_t              PARSING_ERR_FWD_0;             /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  L3FE_PP_PARSING_ERR_FWD_1_t              PARSING_ERR_FWD_1;             /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  L3FE_PP_PARSING_ERR_TRAP_t               PARSING_ERR_TRAP;              /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  L3FE_PP_PARSING_OVER_VLAN_FWD_CTL_t      PARSING_OVER_VLAN_FWD_CTL;     /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  L3FE_PP_USER_TYPE_0_t                    USER_TYPE_0;                   /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  L3FE_PP_USER_TYPE_1_t                    USER_TYPE_1;                   /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  L3FE_PP_USER_MAC_0_LOW_t                 USER_MAC_0_LOW;                /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  L3FE_PP_USER_MAC_0_HI_t                  USER_MAC_0_HI;                 /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  L3FE_PP_USER_MAC_1_LOW_t                 USER_MAC_1_LOW;                /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  L3FE_PP_USER_MAC_1_HI_t                  USER_MAC_1_HI;                 /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  L3FE_PP_USER_MAC_0_MASK_LOW_t            USER_MAC_0_MASK_LOW;           /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  L3FE_PP_USER_MAC_0_MASK_HI_t             USER_MAC_0_MASK_HI;            /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  L3FE_PP_USER_MAC_1_MASK_LOW_t            USER_MAC_1_MASK_LOW;           /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  L3FE_PP_USER_MAC_1_MASK_HI_t             USER_MAC_1_MASK_HI;            /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  L3FE_PP_TPID_0_t                         TPID_0;                        /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  L3FE_PP_TPID_1_t                         TPID_1;                        /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  L3FE_PP_TPID_CTRL_t                      TPID_CTRL;                     /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  L3FE_PP_ARP_TARGET_IP_t                  ARP_TARGET_IP;                 /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  L3FE_PP_OAM_t                            OAM;                           /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  L3FE_PP_HELLO_MAC_LOW_t                  HELLO_MAC_LOW;                 /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  L3FE_PP_HELLO_MAC_HI_t                   HELLO_MAC_HI;                  /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  L3FE_PP_MY_MAC_LOW_t                     MY_MAC_LOW;                    /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  L3FE_PP_MY_MAC_HI_t                      MY_MAC_HI;                     /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  L3FE_PP_MC_MAC_HI_RNG_t                  MC_MAC_HI_RNG;                 /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  L3FE_PP_MC_MAC_LOW_RNG_t                 MC_MAC_LOW_RNG;                /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  L3FE_PP_MC_MAC_RNG_t                     MC_MAC_RNG;                    /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  L3FE_PP_HTTP_LINK_0_t                    HTTP_LINK_0;                   /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];                   
  L3FE_PP_HTTP_LINK_1_t                    HTTP_LINK_1;                   /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];                   
  L3FE_PP_HTTP_LINK_2_t                    HTTP_LINK_2;                   /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];                   
  L3FE_PP_HTTP_LINK_3_t                    HTTP_LINK_3;                   /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];                   
  L3FE_PP_PINGPONG_STS_t                   PINGPONG_STS;                  /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];                   
  L3FE_PP_NI_INTF_ERR_STTS_0_t             NI_INTF_ERR_STTS_0;            /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd44[3];                   
  L3FE_PP_NI_INTF_ERR_STTS_1_t             NI_INTF_ERR_STTS_1;            /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd45[3];                   
  L3FE_PP_NI_INTF_STS_t                    NI_INTF_STS;                   /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd46[3];                   
  L3FE_PP_NI_INTF_PKT_CNT_t                NI_INTF_PKT_CNT;               /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd47[3];                   
  L3FE_PP_L4_CS_ERR_t                      L4_CS_ERR;                     /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd48[3];                   
  L3FE_PP_HEADER_A_LOW_t                   HEADER_A_LOW;                  /* addr: 0x000000c0 */
  ca_uint32_t                              rsrvd49[3];                   
  L3FE_PP_HEADER_A_HI_t                    HEADER_A_HI;                   /* addr: 0x000000c4 */
  ca_uint32_t                              rsrvd50[3];                   
  L3FE_PP_HEADER_CPU_LOW_t                 HEADER_CPU_LOW;                /* addr: 0x000000c8 */
  ca_uint32_t                              rsrvd51[3];                   
  L3FE_PP_HEADER_CPU_HI_t                  HEADER_CPU_HI;                 /* addr: 0x000000cc */
  ca_uint32_t                              rsrvd52[3];                   
  L3FE_PP_NI2FE_INTF_FF_STS_t              NI2FE_INTF_FF_STS;             /* addr: 0x000000d0 */
} APB0_L3FE_PP_t;


/*
 * CLS
 */
        
#define L3FE_CLS_KEY_TBL_ACCESS                  0xf4303300
#define L3FE_CLS_KEY_TBL_ACCESS_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_KEY_TBL_ACCESS_t;


#define L3FE_CLS_KEY_TBL_DATA10                  0xf4303304
#define L3FE_CLS_KEY_TBL_DATA10_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 12 ; /* bits 11:0 */
    ca_uint32_t cl_entry_mode        :  1 ; /* bits 12:12 */
    ca_uint32_t cl_pri               :  4 ; /* bits 16:13 */
    ca_uint32_t cl_rslt_type         :  1 ; /* bits 17:17 */
    ca_uint32_t cl_key_type          :  3 ; /* bits 20:18 */
    ca_uint32_t cl_key_valid         :  4 ; /* bits 24:21 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_KEY_TBL_DATA10_t;


#define L3FE_CLS_KEY_TBL_DATA9                   0xf4303308
#define L3FE_CLS_KEY_TBL_DATA9_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_KEY_TBL_DATA9_t;


#define L3FE_CLS_KEY_TBL_DATA8                   0xf430330c
#define L3FE_CLS_KEY_TBL_DATA8_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_KEY_TBL_DATA8_t;


#define L3FE_CLS_KEY_TBL_DATA7                   0xf4303310
#define L3FE_CLS_KEY_TBL_DATA7_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_KEY_TBL_DATA7_t;


#define L3FE_CLS_KEY_TBL_DATA6                   0xf4303314
#define L3FE_CLS_KEY_TBL_DATA6_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_KEY_TBL_DATA6_t;


#define L3FE_CLS_KEY_TBL_DATA5                   0xf4303318
#define L3FE_CLS_KEY_TBL_DATA5_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_KEY_TBL_DATA5_t;


#define L3FE_CLS_KEY_TBL_DATA4                   0xf430331c
#define L3FE_CLS_KEY_TBL_DATA4_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_KEY_TBL_DATA4_t;


#define L3FE_CLS_KEY_TBL_DATA3                   0xf4303320
#define L3FE_CLS_KEY_TBL_DATA3_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_KEY_TBL_DATA3_t;


#define L3FE_CLS_KEY_TBL_DATA2                   0xf4303324
#define L3FE_CLS_KEY_TBL_DATA2_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_KEY_TBL_DATA2_t;


#define L3FE_CLS_KEY_TBL_DATA1                   0xf4303328
#define L3FE_CLS_KEY_TBL_DATA1_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_KEY_TBL_DATA1_t;


#define L3FE_CLS_KEY_TBL_DATA0                   0xf430332c
#define L3FE_CLS_KEY_TBL_DATA0_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_KEY_TBL_DATA0_t;


#define L3FE_CLS_FIB_TBL_ACCESS                  0xf4303330
#define L3FE_CLS_FIB_TBL_ACCESS_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 20 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_FIB_TBL_ACCESS_t;


#define L3FE_CLS_FIB_TBL_DATA6                   0xf4303334
#define L3FE_CLS_FIB_TBL_DATA6_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_FIB_TBL_DATA6_t;


#define L3FE_CLS_FIB_TBL_DATA5                   0xf4303338
#define L3FE_CLS_FIB_TBL_DATA5_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_FIB_TBL_DATA5_t;


#define L3FE_CLS_FIB_TBL_DATA4                   0xf430333c
#define L3FE_CLS_FIB_TBL_DATA4_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_FIB_TBL_DATA4_t;


#define L3FE_CLS_FIB_TBL_DATA3                   0xf4303340
#define L3FE_CLS_FIB_TBL_DATA3_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_FIB_TBL_DATA3_t;


#define L3FE_CLS_FIB_TBL_DATA2                   0xf4303344
#define L3FE_CLS_FIB_TBL_DATA2_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_FIB_TBL_DATA2_t;


#define L3FE_CLS_FIB_TBL_DATA1                   0xf4303348
#define L3FE_CLS_FIB_TBL_DATA1_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_FIB_TBL_DATA1_t;


#define L3FE_CLS_FIB_TBL_DATA0                   0xf430334c
#define L3FE_CLS_FIB_TBL_DATA0_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cl_entry             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_CLS_FIB_TBL_DATA0_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* CLS */
typedef struct {
  L3FE_CLS_KEY_TBL_ACCESS_t                KEY_TBL_ACCESS;                /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  L3FE_CLS_KEY_TBL_DATA10_t                KEY_TBL_DATA10;                /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  L3FE_CLS_KEY_TBL_DATA9_t                 KEY_TBL_DATA9;                 /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  L3FE_CLS_KEY_TBL_DATA8_t                 KEY_TBL_DATA8;                 /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  L3FE_CLS_KEY_TBL_DATA7_t                 KEY_TBL_DATA7;                 /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  L3FE_CLS_KEY_TBL_DATA6_t                 KEY_TBL_DATA6;                 /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  L3FE_CLS_KEY_TBL_DATA5_t                 KEY_TBL_DATA5;                 /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  L3FE_CLS_KEY_TBL_DATA4_t                 KEY_TBL_DATA4;                 /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  L3FE_CLS_KEY_TBL_DATA3_t                 KEY_TBL_DATA3;                 /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  L3FE_CLS_KEY_TBL_DATA2_t                 KEY_TBL_DATA2;                 /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  L3FE_CLS_KEY_TBL_DATA1_t                 KEY_TBL_DATA1;                 /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  L3FE_CLS_KEY_TBL_DATA0_t                 KEY_TBL_DATA0;                 /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  L3FE_CLS_FIB_TBL_ACCESS_t                FIB_TBL_ACCESS;                /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  L3FE_CLS_FIB_TBL_DATA6_t                 FIB_TBL_DATA6;                 /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  L3FE_CLS_FIB_TBL_DATA5_t                 FIB_TBL_DATA5;                 /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  L3FE_CLS_FIB_TBL_DATA4_t                 FIB_TBL_DATA4;                 /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  L3FE_CLS_FIB_TBL_DATA3_t                 FIB_TBL_DATA3;                 /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  L3FE_CLS_FIB_TBL_DATA2_t                 FIB_TBL_DATA2;                 /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  L3FE_CLS_FIB_TBL_DATA1_t                 FIB_TBL_DATA1;                 /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  L3FE_CLS_FIB_TBL_DATA0_t                 FIB_TBL_DATA0;                 /* addr: 0x0000004c */
} APB0_L3FE_CLS_t;


/*
 * STG0
 */
        
#define L3FE_STG0_CTRL                           0xf4303380
#define L3FE_STG0_CTRL_dft                       0x00047c7e

typedef volatile union {
  struct {
    ca_uint32_t lpb_idx_mode         :  1 ; /* bits 0:0 */
    ca_uint32_t mac_fltr_fail_pkt_mru_chk_en :  1 ; /* bits 1:1 */
    ca_uint32_t mru_chk_fail_pkt_l2_lkup_dis :  1 ; /* bits 2:2 */
    ca_uint32_t other_mac_pkt_keep_lspid_en :  1 ; /* bits 3:3 */
    ca_uint32_t wan_lspid            :  6 ; /* bits 9:4 */
    ca_uint32_t use_lspid_ovwr_o_lspid :  1 ; /* bits 10:10 */
    ca_uint32_t spcl_pkt_keep_old    :  1 ; /* bits 11:11 */
    ca_uint32_t wan_lspid_1          :  6 ; /* bits 17:12 */
    ca_uint32_t msk_my_mac_match_en_for_lspid_upd :  1 ; /* bits 18:18 */
    ca_uint32_t keep_lspid_unchange  :  1 ; /* bits 19:19 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_CTRL_t;


#define L3FE_STG0_LDPID_MAP                      0xf4303384
#define L3FE_STG0_LDPID_MAP_dft                  0x03591807

typedef volatile union {
  struct {
    ca_uint32_t rule_0               :  6 ; /* bits 5:0 */
    ca_uint32_t lpb_idx_0            :  2 ; /* bits 7:6 */
    ca_uint32_t rule_1               :  6 ; /* bits 13:8 */
    ca_uint32_t lpb_idx_1            :  2 ; /* bits 15:14 */
    ca_uint32_t rule_2               :  6 ; /* bits 21:16 */
    ca_uint32_t lpb_idx_2            :  2 ; /* bits 23:22 */
    ca_uint32_t lpb_idx_3            :  2 ; /* bits 25:24 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LDPID_MAP_t;


#define L3FE_STG0_LPB_TBL_LOW_0                  0xf4303388
#define L3FE_STG0_LPB_TBL_LOW_0_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_TBL_LOW_0_t;


#define L3FE_STG0_LPB_TBL_MID_0                  0xf430338c
#define L3FE_STG0_LPB_TBL_MID_0_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_TBL_MID_0_t;


#define L3FE_STG0_LPB_TBL_HIGH_0                 0xf4303390
#define L3FE_STG0_LPB_TBL_HIGH_0_dft             0x18000190

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_TBL_HIGH_0_t;


#define L3FE_STG0_LPB_TBL_LOW_1                  0xf4303394
#define L3FE_STG0_LPB_TBL_LOW_1_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_TBL_LOW_1_t;


#define L3FE_STG0_LPB_TBL_MID_1                  0xf4303398
#define L3FE_STG0_LPB_TBL_MID_1_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_TBL_MID_1_t;


#define L3FE_STG0_LPB_TBL_HIGH_1                 0xf430339c
#define L3FE_STG0_LPB_TBL_HIGH_1_dft             0x19000070

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_TBL_HIGH_1_t;


#define L3FE_STG0_LPB_TBL_LOW_2                  0xf43033a0
#define L3FE_STG0_LPB_TBL_LOW_2_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_TBL_LOW_2_t;


#define L3FE_STG0_LPB_TBL_MID_2                  0xf43033a4
#define L3FE_STG0_LPB_TBL_MID_2_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_TBL_MID_2_t;


#define L3FE_STG0_LPB_TBL_HIGH_2                 0xf43033a8
#define L3FE_STG0_LPB_TBL_HIGH_2_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_TBL_HIGH_2_t;


#define L3FE_STG0_LPB_TBL_LOW_3                  0xf43033ac
#define L3FE_STG0_LPB_TBL_LOW_3_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_TBL_LOW_3_t;


#define L3FE_STG0_LPB_TBL_MID_3                  0xf43033b0
#define L3FE_STG0_LPB_TBL_MID_3_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_TBL_MID_3_t;


#define L3FE_STG0_LPB_TBL_HIGH_3                 0xf43033b4
#define L3FE_STG0_LPB_TBL_HIGH_3_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_TBL_HIGH_3_t;


#define L3FE_STG0_LPB_IDX_TBL_ACCESS             0xf43033b8
#define L3FE_STG0_LPB_IDX_TBL_ACCESS_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_IDX_TBL_ACCESS_t;


#define L3FE_STG0_LPB_IDX_TBL_DATA               0xf43033bc
#define L3FE_STG0_LPB_IDX_TBL_DATA_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t idx                  :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_LPB_IDX_TBL_DATA_t;


#define L3FE_STG0_SPB_TBL_ACCESS                 0xf43033c0
#define L3FE_STG0_SPB_TBL_ACCESS_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_SPB_TBL_ACCESS_t;


#define L3FE_STG0_SPB_TBL_DATA                   0xf43033c4
#define L3FE_STG0_SPB_TBL_DATA_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 28 ; /* bits 27:0 */
    ca_uint32_t rsrvd1               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG0_SPB_TBL_DATA_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* STG0 */
typedef struct {
  L3FE_STG0_CTRL_t                         CTRL;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  L3FE_STG0_LDPID_MAP_t                    LDPID_MAP;                     /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  L3FE_STG0_LPB_TBL_LOW_0_t                LPB_TBL_LOW_0;                 /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  L3FE_STG0_LPB_TBL_MID_0_t                LPB_TBL_MID_0;                 /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  L3FE_STG0_LPB_TBL_HIGH_0_t               LPB_TBL_HIGH_0;                /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  L3FE_STG0_LPB_TBL_LOW_1_t                LPB_TBL_LOW_1;                 /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  L3FE_STG0_LPB_TBL_MID_1_t                LPB_TBL_MID_1;                 /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  L3FE_STG0_LPB_TBL_HIGH_1_t               LPB_TBL_HIGH_1;                /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  L3FE_STG0_LPB_TBL_LOW_2_t                LPB_TBL_LOW_2;                 /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  L3FE_STG0_LPB_TBL_MID_2_t                LPB_TBL_MID_2;                 /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  L3FE_STG0_LPB_TBL_HIGH_2_t               LPB_TBL_HIGH_2;                /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  L3FE_STG0_LPB_TBL_LOW_3_t                LPB_TBL_LOW_3;                 /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  L3FE_STG0_LPB_TBL_MID_3_t                LPB_TBL_MID_3;                 /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  L3FE_STG0_LPB_TBL_HIGH_3_t               LPB_TBL_HIGH_3;                /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  L3FE_STG0_LPB_IDX_TBL_ACCESS_t           LPB_IDX_TBL_ACCESS;            /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  L3FE_STG0_LPB_IDX_TBL_DATA_t             LPB_IDX_TBL_DATA;              /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  L3FE_STG0_SPB_TBL_ACCESS_t               SPB_TBL_ACCESS;                /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  L3FE_STG0_SPB_TBL_DATA_t                 SPB_TBL_DATA;                  /* addr: 0x00000044 */
} APB0_L3FE_STG0_t;


/*
 * STG1
 */
        
#define L3FE_STG1_IPNIP_CTRL_REG                 0xf4303400
#define L3FE_STG1_IPNIP_CTRL_REG_dft             0x0f010e00

typedef volatile union {
  struct {
    ca_uint32_t sixrd_ecn_keep_outer :  1 ; /* bits 0:0 */
    ca_uint32_t sixrd_dscp_keep_outer :  1 ; /* bits 1:1 */
    ca_uint32_t sixrd_ttl_keep_outer :  1 ; /* bits 2:2 */
    ca_uint32_t dsl_ecn_keep_outer   :  1 ; /* bits 3:3 */
    ca_uint32_t dsl_dscp_keep_outer  :  1 ; /* bits 4:4 */
    ca_uint32_t dsl_ttl_keep_outer   :  1 ; /* bits 5:5 */
    ca_uint32_t dsl_rpf_chk_en       :  1 ; /* bits 6:6 */
    ca_uint32_t dsl_ipmc_addr_consistency_chk_en :  1 ; /* bits 7:7 */
    ca_uint32_t dsl_ipmc_addr_prfx_chk_en :  1 ; /* bits 8:8 */
    ca_uint32_t dsl_ipmc_ext_det_en  :  1 ; /* bits 9:9 */
    ca_uint32_t dsl_ipmc_ilg_chk_en  :  1 ; /* bits 10:10 */
    ca_uint32_t sixrd_ipmc_ilg_chk_en :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t ecn_chk_fail_fwd_ctl :  1 ; /* bits 16:16 */
    ca_uint32_t intf_chk_fail_fwd_ctl :  2 ; /* bits 18:17 */
    ca_uint32_t sixrd_decap_chk_fail_fwd_ctl :  2 ; /* bits 20:19 */
    ca_uint32_t dsl_decap_chk_fail_fwd_ctl :  2 ; /* bits 22:21 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t sixrd_ipmc_fwd_ctl   :  1 ; /* bits 24:24 */
    ca_uint32_t dsl_ipmc_fwd_ctl     :  1 ; /* bits 25:25 */
    ca_uint32_t sixrd_ipmc_new_mac_en :  1 ; /* bits 26:26 */
    ca_uint32_t dsl_ipmc_new_mac_en  :  1 ; /* bits 27:27 */
    ca_uint32_t rsrvd3               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG1_IPNIP_CTRL_REG_t;


#define L3FE_STG1_ECN_FAIL_FWD_CTRL              0xf4303404
#define L3FE_STG1_ECN_FAIL_FWD_CTRL_dft          0x02f8ffff

typedef volatile union {
  struct {
    ca_uint32_t t2_ctrl              :  4 ; /* bits 3:0 */
    ca_uint32_t t3_ctrl              :  4 ; /* bits 7:4 */
    ca_uint32_t t4_ctrl              :  4 ; /* bits 11:8 */
    ca_uint32_t t5_ctrl              :  4 ; /* bits 15:12 */
    ca_uint32_t cos                  :  3 ; /* bits 18:16 */
    ca_uint32_t ldpid                :  6 ; /* bits 24:19 */
    ca_uint32_t keep_orig_pkt        :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG1_ECN_FAIL_FWD_CTRL_t;


#define L3FE_STG1_IPNIP_FAIL_FWD_CTRL            0xf4303408
#define L3FE_STG1_IPNIP_FAIL_FWD_CTRL_dft        0x02f8ffff

typedef volatile union {
  struct {
    ca_uint32_t t2_ctrl              :  4 ; /* bits 3:0 */
    ca_uint32_t t3_ctrl              :  4 ; /* bits 7:4 */
    ca_uint32_t t4_ctrl              :  4 ; /* bits 11:8 */
    ca_uint32_t t5_ctrl              :  4 ; /* bits 15:12 */
    ca_uint32_t cos                  :  3 ; /* bits 18:16 */
    ca_uint32_t ldpid                :  6 ; /* bits 24:19 */
    ca_uint32_t keep_orig_pkt        :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG1_IPNIP_FAIL_FWD_CTRL_t;


#define L3FE_STG1_SIXRD_IPMC_FWD_CTRL            0xf430340c
#define L3FE_STG1_SIXRD_IPMC_FWD_CTRL_dft        0x02c8ffff

typedef volatile union {
  struct {
    ca_uint32_t t2_ctrl              :  4 ; /* bits 3:0 */
    ca_uint32_t t3_ctrl              :  4 ; /* bits 7:4 */
    ca_uint32_t t4_ctrl              :  4 ; /* bits 11:8 */
    ca_uint32_t t5_ctrl              :  4 ; /* bits 15:12 */
    ca_uint32_t cos                  :  3 ; /* bits 18:16 */
    ca_uint32_t ldpid                :  6 ; /* bits 24:19 */
    ca_uint32_t keep_orig_pkt        :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG1_SIXRD_IPMC_FWD_CTRL_t;


#define L3FE_STG1_DSL_IPMC_FWD_CTRL              0xf4303410
#define L3FE_STG1_DSL_IPMC_FWD_CTRL_dft          0x02c8ffff

typedef volatile union {
  struct {
    ca_uint32_t t2_ctrl              :  4 ; /* bits 3:0 */
    ca_uint32_t t3_ctrl              :  4 ; /* bits 7:4 */
    ca_uint32_t t4_ctrl              :  4 ; /* bits 11:8 */
    ca_uint32_t t5_ctrl              :  4 ; /* bits 15:12 */
    ca_uint32_t cos                  :  3 ; /* bits 18:16 */
    ca_uint32_t ldpid                :  6 ; /* bits 24:19 */
    ca_uint32_t keep_orig_pkt        :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG1_DSL_IPMC_FWD_CTRL_t;


#define L3FE_STG1_SIXRD_IPMC_NEW_MAC_DA          0xf4303414
#define L3FE_STG1_SIXRD_IPMC_NEW_MAC_DA_dft      0x00003333

typedef volatile union {
  struct {
    ca_uint32_t addr_prfx            : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG1_SIXRD_IPMC_NEW_MAC_DA_t;


#define L3FE_STG1_DSL_IPMC_NEW_MAC_DA            0xf4303418
#define L3FE_STG1_DSL_IPMC_NEW_MAC_DA_dft        0x000200bc

typedef volatile union {
  struct {
    ca_uint32_t addr_prfx            : 25 ; /* bits 24:0 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG1_DSL_IPMC_NEW_MAC_DA_t;


#define L3FE_STG1_INTF_FF_CTL_REG                0xf430341c
#define L3FE_STG1_INTF_FF_CTL_REG_dft            0x00000032

typedef volatile union {
  struct {
    ca_uint32_t low_thr              :  4 ; /* bits 3:0 */
    ca_uint32_t high_thr             :  4 ; /* bits 7:4 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG1_INTF_FF_CTL_REG_t;


#define L3FE_STG1_INTF_FF_STS_REG                0xf4303420
#define L3FE_STG1_INTF_FF_STS_REG_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ovfl_ind             :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG1_INTF_FF_STS_REG_t;


#define L3FE_STG1_INTF_FF_HDR_CNT                0xf4303424
#define L3FE_STG1_INTF_FF_HDR_CNT_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t num                  :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_STG1_INTF_FF_HDR_CNT_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* STG1 */
typedef struct {
  L3FE_STG1_IPNIP_CTRL_REG_t               IPNIP_CTRL_REG;                /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  L3FE_STG1_ECN_FAIL_FWD_CTRL_t            ECN_FAIL_FWD_CTRL;             /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  L3FE_STG1_IPNIP_FAIL_FWD_CTRL_t          IPNIP_FAIL_FWD_CTRL;           /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  L3FE_STG1_SIXRD_IPMC_FWD_CTRL_t          SIXRD_IPMC_FWD_CTRL;           /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  L3FE_STG1_DSL_IPMC_FWD_CTRL_t            DSL_IPMC_FWD_CTRL;             /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  L3FE_STG1_SIXRD_IPMC_NEW_MAC_DA_t        SIXRD_IPMC_NEW_MAC_DA;         /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  L3FE_STG1_DSL_IPMC_NEW_MAC_DA_t          DSL_IPMC_NEW_MAC_DA;           /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  L3FE_STG1_INTF_FF_CTL_REG_t              INTF_FF_CTL_REG;               /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  L3FE_STG1_INTF_FF_STS_REG_t              INTF_FF_STS_REG;               /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  L3FE_STG1_INTF_FF_HDR_CNT_t              INTF_FF_HDR_CNT;               /* addr: 0x00000024 */
} APB0_L3FE_STG1_t;


/*
 * PE
 */
        
#define L3FE_PE_PPPOE_CFG                        0xf4303500
#define L3FE_PE_PPPOE_CFG_dft                    0x00000011

typedef volatile union {
  struct {
    ca_uint32_t sess_ver_type        :  8 ; /* bits 7:0 */
    ca_uint32_t pppoe_code           :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_PPPOE_CFG_t;


#define L3FE_PE_PPPOE_PROT_CFG                   0xf4303504
#define L3FE_PE_PPPOE_PROT_CFG_dft               0x00570021

typedef volatile union {
  struct {
    ca_uint32_t ipv4_protocol        : 16 ; /* bits 15:0 */
    ca_uint32_t ipv6_protocol        : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_PPPOE_PROT_CFG_t;


#define L3FE_PE_MIB_CFG                          0xf4303508
#define L3FE_PE_MIB_CFG_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t counter_wrap_around  : 13 ; /* bits 12:0 */
    ca_uint32_t rsrvd1               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_MIB_CFG_t;


#define L3FE_PE_DROP_SRC_PKT_CLR                 0xf430350c
#define L3FE_PE_DROP_SRC_PKT_CLR_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t clear                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DROP_SRC_PKT_CLR_t;


#define L3FE_PE_DROP_SRC_BYTE_CLR                0xf4303510
#define L3FE_PE_DROP_SRC_BYTE_CLR_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t clear                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DROP_SRC_BYTE_CLR_t;


#define L3FE_PE_RX_IFID_CLR                      0xf4303514
#define L3FE_PE_RX_IFID_CLR_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t clear                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_RX_IFID_CLR_t;


#define L3FE_PE_TX_IFID_CLR                      0xf4303518
#define L3FE_PE_TX_IFID_CLR_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t clear                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_TX_IFID_CLR_t;


#define L3FE_PE_PE_CFG                           0xf430351c
#define L3FE_PE_PE_CFG_dft                       0x00000002

typedef volatile union {
  struct {
    ca_uint32_t stomp_crc            :  1 ; /* bits 0:0 */
    ca_uint32_t bypass_crc_update    :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t ignore_tqm_fe_rdy    :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd2               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_PE_CFG_t;


#define L3FE_PE_XRD_CLR                          0xf4303520
#define L3FE_PE_XRD_CLR_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t clear                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_XRD_CLR_t;


#define L3FE_PE_DSL_CLR                          0xf4303524
#define L3FE_PE_DSL_CLR_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t clear                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DSL_CLR_t;


#define L3FE_PE_PORT_EGRESS_BEHAVIOR_0_0         0xf4303528
#define L3FE_PE_PORT_EGRESS_BEHAVIOR_0_0_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_PORT_EGRESS_BEHAVIOR_0_0_t;


#define L3FE_PE_PORT_EGRESS_BEHAVIOR_1_0         0xf430352c
#define L3FE_PE_PORT_EGRESS_BEHAVIOR_1_0_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_PORT_EGRESS_BEHAVIOR_1_0_t;


#define L3FE_PE_PORT_EGRESS_BEHAVIOR_2_0         0xf4303530
#define L3FE_PE_PORT_EGRESS_BEHAVIOR_2_0_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_PORT_EGRESS_BEHAVIOR_2_0_t;


#define L3FE_PE_PORT_EGRESS_BEHAVIOR_0_1         0xf4303534
#define L3FE_PE_PORT_EGRESS_BEHAVIOR_0_1_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_PORT_EGRESS_BEHAVIOR_0_1_t;


#define L3FE_PE_PORT_EGRESS_BEHAVIOR_1_1         0xf4303538
#define L3FE_PE_PORT_EGRESS_BEHAVIOR_1_1_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_PORT_EGRESS_BEHAVIOR_1_1_t;


#define L3FE_PE_PORT_EGRESS_BEHAVIOR_2_1         0xf430353c
#define L3FE_PE_PORT_EGRESS_BEHAVIOR_2_1_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_PORT_EGRESS_BEHAVIOR_2_1_t;


#define L3FE_PE_PORT_EGRESS_BEHAVIOR_0_2         0xf4303540
#define L3FE_PE_PORT_EGRESS_BEHAVIOR_0_2_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_PORT_EGRESS_BEHAVIOR_0_2_t;


#define L3FE_PE_PORT_EGRESS_BEHAVIOR_1_2         0xf4303544
#define L3FE_PE_PORT_EGRESS_BEHAVIOR_1_2_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_PORT_EGRESS_BEHAVIOR_1_2_t;


#define L3FE_PE_PORT_EGRESS_BEHAVIOR_2_2         0xf4303548
#define L3FE_PE_PORT_EGRESS_BEHAVIOR_2_2_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_PORT_EGRESS_BEHAVIOR_2_2_t;


#define L3FE_PE_PORT_EGRESS_BEHAVIOR_0_3         0xf430354c
#define L3FE_PE_PORT_EGRESS_BEHAVIOR_0_3_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_PORT_EGRESS_BEHAVIOR_0_3_t;


#define L3FE_PE_PORT_EGRESS_BEHAVIOR_1_3         0xf4303550
#define L3FE_PE_PORT_EGRESS_BEHAVIOR_1_3_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_PORT_EGRESS_BEHAVIOR_1_3_t;


#define L3FE_PE_PORT_EGRESS_BEHAVIOR_2_3         0xf4303554
#define L3FE_PE_PORT_EGRESS_BEHAVIOR_2_3_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t vct                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_PORT_EGRESS_BEHAVIOR_2_3_t;


#define L3FE_PE_MTU_SIZE_0                       0xf4303558
#define L3FE_PE_MTU_SIZE_0_dft                   0x05dc05dc

typedef volatile union {
  struct {
    ca_uint32_t mtu_0                : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t mtu_1                : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_MTU_SIZE_0_t;


#define L3FE_PE_MTU_SIZE_1                       0xf430355c
#define L3FE_PE_MTU_SIZE_1_dft                   0x05dc05dc

typedef volatile union {
  struct {
    ca_uint32_t mtu_2                : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t mtu_3                : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_MTU_SIZE_1_t;


#define L3FE_PE_DSL_6RD_ENCAP_CFG                0xf4303560
#define L3FE_PE_DSL_6RD_ENCAP_CFG_dft            0x00002904

typedef volatile union {
  struct {
    ca_uint32_t nh_dsl_encap         :  8 ; /* bits 7:0 */
    ca_uint32_t prot_6rd_encap       :  8 ; /* bits 15:8 */
    ca_uint32_t df_6rd_encap         :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DSL_6RD_ENCAP_CFG_t;


#define L3FE_PE_DSL_6RD_ENCAP_TYPE               0xf4303564
#define L3FE_PE_DSL_6RD_ENCAP_TYPE_dft           0x080086dd

typedef volatile union {
  struct {
    ca_uint32_t etype_dsl_encap      : 16 ; /* bits 15:0 */
    ca_uint32_t etype_6rd_encap      : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DSL_6RD_ENCAP_TYPE_t;


#define L3FE_PE_DSL_6RD_DECAP_TYPE               0xf4303568
#define L3FE_PE_DSL_6RD_DECAP_TYPE_dft           0x86dd0800

typedef volatile union {
  struct {
    ca_uint32_t etype_dsl_decap      : 16 ; /* bits 15:0 */
    ca_uint32_t etype_6rd_decap      : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DSL_6RD_DECAP_TYPE_t;


#define L3FE_PE_MIRROR_CFG                       0xf430356c
#define L3FE_PE_MIRROR_CFG_dft                   0x000000ff

typedef volatile union {
  struct {
    ca_uint32_t mirr_fifo_high_threshold :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t mirr_cos             :  3 ; /* bits 18:16 */
    ca_uint32_t mirr_ldpid           :  6 ; /* bits 24:19 */
    ca_uint32_t rsrvd2               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_MIRROR_CFG_t;


#define L3FE_PE_MIRROR_LEN_CFG                   0xf4303570
#define L3FE_PE_MIRROR_LEN_CFG_dft               0x00000080

typedef volatile union {
  struct {
    ca_uint32_t mirr_len             : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_MIRROR_LEN_CFG_t;


#define L3FE_PE_SIXRD_TBL_ACCESS                 0xf4303574
#define L3FE_PE_SIXRD_TBL_ACCESS_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_SIXRD_TBL_ACCESS_t;


#define L3FE_PE_SIXRD_TBL_DATA6                  0xf4303578
#define L3FE_PE_SIXRD_TBL_DATA6_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t six_rd_ce_v4_ip      :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_SIXRD_TBL_DATA6_t;


#define L3FE_PE_SIXRD_TBL_DATA5                  0xf430357c
#define L3FE_PE_SIXRD_TBL_DATA5_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t six_rd_v4_msk_len    :  1 ; /* bits 0:0 */
    ca_uint32_t six_rd_ce_v4_ip      : 31 ; /* bits 31:1 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_SIXRD_TBL_DATA5_t;


#define L3FE_PE_SIXRD_TBL_DATA4                  0xf4303580
#define L3FE_PE_SIXRD_TBL_DATA4_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t six_rd_v6_prfx       : 22 ; /* bits 21:0 */
    ca_uint32_t six_rd_v6_prfx_len   :  6 ; /* bits 27:22 */
    ca_uint32_t six_rd_v4_msk_len    :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_SIXRD_TBL_DATA4_t;


#define L3FE_PE_SIXRD_TBL_DATA3                  0xf4303584
#define L3FE_PE_SIXRD_TBL_DATA3_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t six_rd_v6_prfx       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_SIXRD_TBL_DATA3_t;


#define L3FE_PE_SIXRD_TBL_DATA2                  0xf4303588
#define L3FE_PE_SIXRD_TBL_DATA2_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t six_rd_br_v4_ip      : 22 ; /* bits 21:0 */
    ca_uint32_t six_rd_v6_prfx       : 10 ; /* bits 31:22 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_SIXRD_TBL_DATA2_t;


#define L3FE_PE_SIXRD_TBL_DATA1                  0xf430358c
#define L3FE_PE_SIXRD_TBL_DATA1_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t six_rd_id_start      :  4 ; /* bits 3:0 */
    ca_uint32_t six_rd_ttl_en        :  1 ; /* bits 4:4 */
    ca_uint32_t six_rd_ttl           :  8 ; /* bits 12:5 */
    ca_uint32_t six_rd_tos_en        :  1 ; /* bits 13:13 */
    ca_uint32_t six_rd_tos           :  8 ; /* bits 21:14 */
    ca_uint32_t six_rd_br_v4_ip      : 10 ; /* bits 31:22 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_SIXRD_TBL_DATA1_t;


#define L3FE_PE_SIXRD_TBL_DATA0                  0xf4303590
#define L3FE_PE_SIXRD_TBL_DATA0_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t six_rd_valid         :  1 ; /* bits 0:0 */
    ca_uint32_t six_rd_ingr_chk_en   :  1 ; /* bits 1:1 */
    ca_uint32_t six_rd_br_only       :  1 ; /* bits 2:2 */
    ca_uint32_t six_rd_ipsa_mtch     :  1 ; /* bits 3:3 */
    ca_uint32_t six_rd_id_end        : 16 ; /* bits 19:4 */
    ca_uint32_t six_rd_id_start      : 12 ; /* bits 31:20 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_SIXRD_TBL_DATA0_t;


#define L3FE_PE_DSL_TBL_ACCESS                   0xf4303594
#define L3FE_PE_DSL_TBL_ACCESS_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DSL_TBL_ACCESS_t;


#define L3FE_PE_DSL_TBL_DATA9                    0xf4303598
#define L3FE_PE_DSL_TBL_DATA9_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dsl_b4_ip            :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DSL_TBL_DATA9_t;


#define L3FE_PE_DSL_TBL_DATA8                    0xf430359c
#define L3FE_PE_DSL_TBL_DATA8_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dsl_b4_ip            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DSL_TBL_DATA8_t;


#define L3FE_PE_DSL_TBL_DATA7                    0xf43035a0
#define L3FE_PE_DSL_TBL_DATA7_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dsl_b4_ip            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DSL_TBL_DATA7_t;


#define L3FE_PE_DSL_TBL_DATA6                    0xf43035a4
#define L3FE_PE_DSL_TBL_DATA6_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dsl_b4_ip            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DSL_TBL_DATA6_t;


#define L3FE_PE_DSL_TBL_DATA5                    0xf43035a8
#define L3FE_PE_DSL_TBL_DATA5_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dsl_aftr_ip          :  8 ; /* bits 7:0 */
    ca_uint32_t dsl_b4_ip            : 24 ; /* bits 31:8 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DSL_TBL_DATA5_t;


#define L3FE_PE_DSL_TBL_DATA4                    0xf43035ac
#define L3FE_PE_DSL_TBL_DATA4_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dsl_aftr_ip          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DSL_TBL_DATA4_t;


#define L3FE_PE_DSL_TBL_DATA3                    0xf43035b0
#define L3FE_PE_DSL_TBL_DATA3_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dsl_aftr_ip          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DSL_TBL_DATA3_t;


#define L3FE_PE_DSL_TBL_DATA2                    0xf43035b4
#define L3FE_PE_DSL_TBL_DATA2_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dsl_aftr_ip          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DSL_TBL_DATA2_t;


#define L3FE_PE_DSL_TBL_DATA1                    0xf43035b8
#define L3FE_PE_DSL_TBL_DATA1_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dsl_tc               :  8 ; /* bits 7:0 */
    ca_uint32_t dsl_aftr_ip          : 24 ; /* bits 31:8 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DSL_TBL_DATA1_t;


#define L3FE_PE_DSL_TBL_DATA0                    0xf43035bc
#define L3FE_PE_DSL_TBL_DATA0_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dsl_valid            :  1 ; /* bits 0:0 */
    ca_uint32_t dsl_mc               :  1 ; /* bits 1:1 */
    ca_uint32_t dsl_flwlabel         : 20 ; /* bits 21:2 */
    ca_uint32_t dsl_hoplimit_en      :  1 ; /* bits 22:22 */
    ca_uint32_t dsl_hoplimit         :  8 ; /* bits 30:23 */
    ca_uint32_t dsl_tc_en            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DSL_TBL_DATA0_t;


#define L3FE_PE_DROP_SRC_PKT_CNT_TBL_ACCESS      0xf43035c0
#define L3FE_PE_DROP_SRC_PKT_CNT_TBL_ACCESS_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DROP_SRC_PKT_CNT_TBL_ACCESS_t;


#define L3FE_PE_DROP_SRC_PKT_CNT_TBL_DATA1       0xf43035c4
#define L3FE_PE_DROP_SRC_PKT_CNT_TBL_DATA1_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DROP_SRC_PKT_CNT_TBL_DATA1_t;


#define L3FE_PE_DROP_SRC_PKT_CNT_TBL_DATA0       0xf43035c8
#define L3FE_PE_DROP_SRC_PKT_CNT_TBL_DATA0_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DROP_SRC_PKT_CNT_TBL_DATA0_t;


#define L3FE_PE_DROP_SRC_BYTE_CNT_TBL_ACCESS     0xf43035cc
#define L3FE_PE_DROP_SRC_BYTE_CNT_TBL_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DROP_SRC_BYTE_CNT_TBL_ACCESS_t;


#define L3FE_PE_DROP_SRC_BYTE_CNT_TBL_DATA1      0xf43035d0
#define L3FE_PE_DROP_SRC_BYTE_CNT_TBL_DATA1_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DROP_SRC_BYTE_CNT_TBL_DATA1_t;


#define L3FE_PE_DROP_SRC_BYTE_CNT_TBL_DATA0      0xf43035d4
#define L3FE_PE_DROP_SRC_BYTE_CNT_TBL_DATA0_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_DROP_SRC_BYTE_CNT_TBL_DATA0_t;


#define L3FE_PE_RX_IFID_CNT_TBL_ACCESS           0xf43035d8
#define L3FE_PE_RX_IFID_CNT_TBL_ACCESS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_RX_IFID_CNT_TBL_ACCESS_t;


#define L3FE_PE_RX_IFID_CNT_TBL_DATA7            0xf43035dc
#define L3FE_PE_RX_IFID_CNT_TBL_DATA7_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_RX_IFID_CNT_TBL_DATA7_t;


#define L3FE_PE_RX_IFID_CNT_TBL_DATA6            0xf43035e0
#define L3FE_PE_RX_IFID_CNT_TBL_DATA6_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_RX_IFID_CNT_TBL_DATA6_t;


#define L3FE_PE_RX_IFID_CNT_TBL_DATA5            0xf43035e4
#define L3FE_PE_RX_IFID_CNT_TBL_DATA5_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_RX_IFID_CNT_TBL_DATA5_t;


#define L3FE_PE_RX_IFID_CNT_TBL_DATA4            0xf43035e8
#define L3FE_PE_RX_IFID_CNT_TBL_DATA4_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_RX_IFID_CNT_TBL_DATA4_t;


#define L3FE_PE_RX_IFID_CNT_TBL_DATA3            0xf43035ec
#define L3FE_PE_RX_IFID_CNT_TBL_DATA3_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_RX_IFID_CNT_TBL_DATA3_t;


#define L3FE_PE_RX_IFID_CNT_TBL_DATA2            0xf43035f0
#define L3FE_PE_RX_IFID_CNT_TBL_DATA2_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_RX_IFID_CNT_TBL_DATA2_t;


#define L3FE_PE_RX_IFID_CNT_TBL_DATA1            0xf43035f4
#define L3FE_PE_RX_IFID_CNT_TBL_DATA1_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_RX_IFID_CNT_TBL_DATA1_t;


#define L3FE_PE_RX_IFID_CNT_TBL_DATA0            0xf43035f8
#define L3FE_PE_RX_IFID_CNT_TBL_DATA0_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_RX_IFID_CNT_TBL_DATA0_t;


#define L3FE_PE_TX_IFID_CNT_TBL_ACCESS           0xf43035fc
#define L3FE_PE_TX_IFID_CNT_TBL_ACCESS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_TX_IFID_CNT_TBL_ACCESS_t;


#define L3FE_PE_TX_IFID_CNT_TBL_DATA6            0xf4303600
#define L3FE_PE_TX_IFID_CNT_TBL_DATA6_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_TX_IFID_CNT_TBL_DATA6_t;


#define L3FE_PE_TX_IFID_CNT_TBL_DATA5            0xf4303604
#define L3FE_PE_TX_IFID_CNT_TBL_DATA5_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_TX_IFID_CNT_TBL_DATA5_t;


#define L3FE_PE_TX_IFID_CNT_TBL_DATA4            0xf4303608
#define L3FE_PE_TX_IFID_CNT_TBL_DATA4_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_TX_IFID_CNT_TBL_DATA4_t;


#define L3FE_PE_TX_IFID_CNT_TBL_DATA3            0xf430360c
#define L3FE_PE_TX_IFID_CNT_TBL_DATA3_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_TX_IFID_CNT_TBL_DATA3_t;


#define L3FE_PE_TX_IFID_CNT_TBL_DATA2            0xf4303610
#define L3FE_PE_TX_IFID_CNT_TBL_DATA2_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_TX_IFID_CNT_TBL_DATA2_t;


#define L3FE_PE_TX_IFID_CNT_TBL_DATA1            0xf4303614
#define L3FE_PE_TX_IFID_CNT_TBL_DATA1_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_TX_IFID_CNT_TBL_DATA1_t;


#define L3FE_PE_TX_IFID_CNT_TBL_DATA0            0xf4303618
#define L3FE_PE_TX_IFID_CNT_TBL_DATA0_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_PE_TX_IFID_CNT_TBL_DATA0_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PE */
typedef struct {
  L3FE_PE_PPPOE_CFG_t                      PPPOE_CFG;                     /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  L3FE_PE_PPPOE_PROT_CFG_t                 PPPOE_PROT_CFG;                /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  L3FE_PE_MIB_CFG_t                        MIB_CFG;                       /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  L3FE_PE_DROP_SRC_PKT_CLR_t               DROP_SRC_PKT_CLR;              /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  L3FE_PE_DROP_SRC_BYTE_CLR_t              DROP_SRC_BYTE_CLR;             /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  L3FE_PE_RX_IFID_CLR_t                    RX_IFID_CLR;                   /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  L3FE_PE_TX_IFID_CLR_t                    TX_IFID_CLR;                   /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  L3FE_PE_PE_CFG_t                         PE_CFG;                        /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  L3FE_PE_XRD_CLR_t                        XRD_CLR;                       /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  L3FE_PE_DSL_CLR_t                        DSL_CLR;                       /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  L3FE_PE_PORT_EGRESS_BEHAVIOR_0_0_t       PORT_EGRESS_BEHAVIOR_0_0;      /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  L3FE_PE_PORT_EGRESS_BEHAVIOR_1_0_t       PORT_EGRESS_BEHAVIOR_1_0;      /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  L3FE_PE_PORT_EGRESS_BEHAVIOR_2_0_t       PORT_EGRESS_BEHAVIOR_2_0;      /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  L3FE_PE_PORT_EGRESS_BEHAVIOR_0_1_t       PORT_EGRESS_BEHAVIOR_0_1;      /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  L3FE_PE_PORT_EGRESS_BEHAVIOR_1_1_t       PORT_EGRESS_BEHAVIOR_1_1;      /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  L3FE_PE_PORT_EGRESS_BEHAVIOR_2_1_t       PORT_EGRESS_BEHAVIOR_2_1;      /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  L3FE_PE_PORT_EGRESS_BEHAVIOR_0_2_t       PORT_EGRESS_BEHAVIOR_0_2;      /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  L3FE_PE_PORT_EGRESS_BEHAVIOR_1_2_t       PORT_EGRESS_BEHAVIOR_1_2;      /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  L3FE_PE_PORT_EGRESS_BEHAVIOR_2_2_t       PORT_EGRESS_BEHAVIOR_2_2;      /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  L3FE_PE_PORT_EGRESS_BEHAVIOR_0_3_t       PORT_EGRESS_BEHAVIOR_0_3;      /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  L3FE_PE_PORT_EGRESS_BEHAVIOR_1_3_t       PORT_EGRESS_BEHAVIOR_1_3;      /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  L3FE_PE_PORT_EGRESS_BEHAVIOR_2_3_t       PORT_EGRESS_BEHAVIOR_2_3;      /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  L3FE_PE_MTU_SIZE_0_t                     MTU_SIZE_0;                    /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  L3FE_PE_MTU_SIZE_1_t                     MTU_SIZE_1;                    /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  L3FE_PE_DSL_6RD_ENCAP_CFG_t              DSL_6RD_ENCAP_CFG;             /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  L3FE_PE_DSL_6RD_ENCAP_TYPE_t             DSL_6RD_ENCAP_TYPE;            /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  L3FE_PE_DSL_6RD_DECAP_TYPE_t             DSL_6RD_DECAP_TYPE;            /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  L3FE_PE_MIRROR_CFG_t                     MIRROR_CFG;                    /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  L3FE_PE_MIRROR_LEN_CFG_t                 MIRROR_LEN_CFG;                /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  L3FE_PE_SIXRD_TBL_ACCESS_t               SIXRD_TBL_ACCESS;              /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  L3FE_PE_SIXRD_TBL_DATA6_t                SIXRD_TBL_DATA6;               /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  L3FE_PE_SIXRD_TBL_DATA5_t                SIXRD_TBL_DATA5;               /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  L3FE_PE_SIXRD_TBL_DATA4_t                SIXRD_TBL_DATA4;               /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  L3FE_PE_SIXRD_TBL_DATA3_t                SIXRD_TBL_DATA3;               /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  L3FE_PE_SIXRD_TBL_DATA2_t                SIXRD_TBL_DATA2;               /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  L3FE_PE_SIXRD_TBL_DATA1_t                SIXRD_TBL_DATA1;               /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  L3FE_PE_SIXRD_TBL_DATA0_t                SIXRD_TBL_DATA0;               /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  L3FE_PE_DSL_TBL_ACCESS_t                 DSL_TBL_ACCESS;                /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  L3FE_PE_DSL_TBL_DATA9_t                  DSL_TBL_DATA9;                 /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];                   
  L3FE_PE_DSL_TBL_DATA8_t                  DSL_TBL_DATA8;                 /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];                   
  L3FE_PE_DSL_TBL_DATA7_t                  DSL_TBL_DATA7;                 /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];                   
  L3FE_PE_DSL_TBL_DATA6_t                  DSL_TBL_DATA6;                 /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];                   
  L3FE_PE_DSL_TBL_DATA5_t                  DSL_TBL_DATA5;                 /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];                   
  L3FE_PE_DSL_TBL_DATA4_t                  DSL_TBL_DATA4;                 /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd44[3];                   
  L3FE_PE_DSL_TBL_DATA3_t                  DSL_TBL_DATA3;                 /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd45[3];                   
  L3FE_PE_DSL_TBL_DATA2_t                  DSL_TBL_DATA2;                 /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd46[3];                   
  L3FE_PE_DSL_TBL_DATA1_t                  DSL_TBL_DATA1;                 /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd47[3];                   
  L3FE_PE_DSL_TBL_DATA0_t                  DSL_TBL_DATA0;                 /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd48[3];                   
  L3FE_PE_DROP_SRC_PKT_CNT_TBL_ACCESS_t    DROP_SRC_PKT_CNT_TBL_ACCESS;   /* addr: 0x000000c0 */
  ca_uint32_t                              rsrvd49[3];                   
  L3FE_PE_DROP_SRC_PKT_CNT_TBL_DATA1_t     DROP_SRC_PKT_CNT_TBL_DATA1;    /* addr: 0x000000c4 */
  ca_uint32_t                              rsrvd50[3];                   
  L3FE_PE_DROP_SRC_PKT_CNT_TBL_DATA0_t     DROP_SRC_PKT_CNT_TBL_DATA0;    /* addr: 0x000000c8 */
  ca_uint32_t                              rsrvd51[3];                   
  L3FE_PE_DROP_SRC_BYTE_CNT_TBL_ACCESS_t   DROP_SRC_BYTE_CNT_TBL_ACCESS;  /* addr: 0x000000cc */
  ca_uint32_t                              rsrvd52[3];                   
  L3FE_PE_DROP_SRC_BYTE_CNT_TBL_DATA1_t    DROP_SRC_BYTE_CNT_TBL_DATA1;   /* addr: 0x000000d0 */
  ca_uint32_t                              rsrvd53[3];                   
  L3FE_PE_DROP_SRC_BYTE_CNT_TBL_DATA0_t    DROP_SRC_BYTE_CNT_TBL_DATA0;   /* addr: 0x000000d4 */
  ca_uint32_t                              rsrvd54[3];                   
  L3FE_PE_RX_IFID_CNT_TBL_ACCESS_t         RX_IFID_CNT_TBL_ACCESS;        /* addr: 0x000000d8 */
  ca_uint32_t                              rsrvd55[3];                   
  L3FE_PE_RX_IFID_CNT_TBL_DATA7_t          RX_IFID_CNT_TBL_DATA7;         /* addr: 0x000000dc */
  ca_uint32_t                              rsrvd56[3];                   
  L3FE_PE_RX_IFID_CNT_TBL_DATA6_t          RX_IFID_CNT_TBL_DATA6;         /* addr: 0x000000e0 */
  ca_uint32_t                              rsrvd57[3];                   
  L3FE_PE_RX_IFID_CNT_TBL_DATA5_t          RX_IFID_CNT_TBL_DATA5;         /* addr: 0x000000e4 */
  ca_uint32_t                              rsrvd58[3];                   
  L3FE_PE_RX_IFID_CNT_TBL_DATA4_t          RX_IFID_CNT_TBL_DATA4;         /* addr: 0x000000e8 */
  ca_uint32_t                              rsrvd59[3];                   
  L3FE_PE_RX_IFID_CNT_TBL_DATA3_t          RX_IFID_CNT_TBL_DATA3;         /* addr: 0x000000ec */
  ca_uint32_t                              rsrvd60[3];                   
  L3FE_PE_RX_IFID_CNT_TBL_DATA2_t          RX_IFID_CNT_TBL_DATA2;         /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd61[3];                   
  L3FE_PE_RX_IFID_CNT_TBL_DATA1_t          RX_IFID_CNT_TBL_DATA1;         /* addr: 0x000000f4 */
  ca_uint32_t                              rsrvd62[3];                   
  L3FE_PE_RX_IFID_CNT_TBL_DATA0_t          RX_IFID_CNT_TBL_DATA0;         /* addr: 0x000000f8 */
  ca_uint32_t                              rsrvd63[3];                   
  L3FE_PE_TX_IFID_CNT_TBL_ACCESS_t         TX_IFID_CNT_TBL_ACCESS;        /* addr: 0x000000fc */
  ca_uint32_t                              rsrvd64[3];                   
  L3FE_PE_TX_IFID_CNT_TBL_DATA6_t          TX_IFID_CNT_TBL_DATA6;         /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd65[3];                   
  L3FE_PE_TX_IFID_CNT_TBL_DATA5_t          TX_IFID_CNT_TBL_DATA5;         /* addr: 0x00000104 */
  ca_uint32_t                              rsrvd66[3];                   
  L3FE_PE_TX_IFID_CNT_TBL_DATA4_t          TX_IFID_CNT_TBL_DATA4;         /* addr: 0x00000108 */
  ca_uint32_t                              rsrvd67[3];                   
  L3FE_PE_TX_IFID_CNT_TBL_DATA3_t          TX_IFID_CNT_TBL_DATA3;         /* addr: 0x0000010c */
  ca_uint32_t                              rsrvd68[3];                   
  L3FE_PE_TX_IFID_CNT_TBL_DATA2_t          TX_IFID_CNT_TBL_DATA2;         /* addr: 0x00000110 */
  ca_uint32_t                              rsrvd69[3];                   
  L3FE_PE_TX_IFID_CNT_TBL_DATA1_t          TX_IFID_CNT_TBL_DATA1;         /* addr: 0x00000114 */
  ca_uint32_t                              rsrvd70[3];                   
  L3FE_PE_TX_IFID_CNT_TBL_DATA0_t          TX_IFID_CNT_TBL_DATA0;         /* addr: 0x00000118 */
} APB0_L3FE_PE_t;


/*
 * FE_L3E_HS
 */
        
#define L3FE_FE_L3E_HS_PROFILE0_INI              0xf4303800
#define L3FE_FE_L3E_HS_PROFILE0_INI_STRIDE       44
#define L3FE_FE_L3E_HS_PROFILE0_INI_COUNT        15
#define L3FE_FE_L3E_HS_PROFILE0_INI_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tpl_num              :  4 ; /* bits 3:0 */
    ca_uint32_t default_sel_0e       :  5 ; /* bits 8:4 */
    ca_uint32_t default_sel_0a       :  5 ; /* bits 13:9 */
    ca_uint32_t default_sel_1e       :  5 ; /* bits 18:14 */
    ca_uint32_t default_sel_1a       :  5 ; /* bits 23:19 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_PROFILE0_INI_t;


#define L3FE_FE_L3E_HS_PROFILE0_TUPLE0           0xf4303804
#define L3FE_FE_L3E_HS_PROFILE0_TUPLE0_STRIDE    44
#define L3FE_FE_L3E_HS_PROFILE0_TUPLE0_COUNT     15
#define L3FE_FE_L3E_HS_PROFILE0_TUPLE0_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t maskptr              :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t pri                  :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t type                 :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd3               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_PROFILE0_TUPLE0_t;

                            
#define L3FE_FE_L3E_HS_PROFILE0_TYPE0_ACTION     0xf4303824
#define L3FE_FE_L3E_HS_PROFILE0_TYPE0_ACTION_STRIDE 44
#define L3FE_FE_L3E_HS_PROFILE0_TYPE0_ACTION_COUNT 15
#define L3FE_FE_L3E_HS_PROFILE0_TYPE0_ACTION_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t a_mask               : 24 ; /* bits 23:0 */
    ca_uint32_t fetch_sz             :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd1               :  5 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_PROFILE0_TYPE0_ACTION_t;

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            
#define L3FE_FE_L3E_HS_HASH_INI                  0xf4303a94
#define L3FE_FE_L3E_HS_HASH_INI_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hb_size              :  2 ; /* bits 1:0 */
    ca_uint32_t ht_size              :  3 ; /* bits 4:2 */
    ca_uint32_t ha_width             :  3 ; /* bits 7:5 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_HASH_INI_t;


#define L3FE_FE_L3E_HS_BA_MH1                    0xf4303a98
#define L3FE_FE_L3E_HS_BA_MH1_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ba1                  :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_BA_MH1_t;


#define L3FE_FE_L3E_HS_BA_MH0                    0xf4303a9c
#define L3FE_FE_L3E_HS_BA_MH0_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t ba0                  : 25 ; /* bits 31:7 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_BA_MH0_t;


#define L3FE_FE_L3E_HS_BA_MA1                    0xf4303aa0
#define L3FE_FE_L3E_HS_BA_MA1_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ba1                  :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_BA_MA1_t;


#define L3FE_FE_L3E_HS_BA_MA0                    0xf4303aa4
#define L3FE_FE_L3E_HS_BA_MA0_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t ba0                  : 25 ; /* bits 31:7 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_BA_MA0_t;


#define L3FE_FE_L3E_HS_OVERFLOW_INI              0xf4303aa8
#define L3FE_FE_L3E_HS_OVERFLOW_INI_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t oa_width             :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_OVERFLOW_INI_t;


#define L3FE_FE_L3E_HS_BA_OA1                    0xf4303aac
#define L3FE_FE_L3E_HS_BA_OA1_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ba1                  :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_BA_OA1_t;


#define L3FE_FE_L3E_HS_BA_OA0                    0xf4303ab0
#define L3FE_FE_L3E_HS_BA_OA0_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t ba0                  : 25 ; /* bits 31:7 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_BA_OA0_t;


#define L3FE_FE_L3E_HS_DEFAULT_INI               0xf4303ab4
#define L3FE_FE_L3E_HS_DEFAULT_INI_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t da_width             :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEFAULT_INI_t;


#define L3FE_FE_L3E_HS_BA_DA1                    0xf4303ab8
#define L3FE_FE_L3E_HS_BA_DA1_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ba1                  :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_BA_DA1_t;


#define L3FE_FE_L3E_HS_BA_DA0                    0xf4303abc
#define L3FE_FE_L3E_HS_BA_DA0_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t ba0                  : 25 ; /* bits 31:7 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_BA_DA0_t;


#define L3FE_FE_L3E_HS_DEFAULT_ACTION_0          0xf4303ac0
#define L3FE_FE_L3E_HS_DEFAULT_ACTION_0_STRIDE   4
#define L3FE_FE_L3E_HS_DEFAULT_ACTION_0_COUNT    32
#define L3FE_FE_L3E_HS_DEFAULT_ACTION_0_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t a_mask               : 24 ; /* bits 23:0 */
    ca_uint32_t fetch_sz             :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd1               :  5 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_DEFAULT_ACTION_0_t;

                                                                                                                            
#define L3FE_FE_L3E_HS_CACHE_INI                 0xf4303b40
#define L3FE_FE_L3E_HS_CACHE_INI_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ct_size              :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t ca_width             :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd2               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_INI_t;


#define L3FE_FE_L3E_HS_BA_CA1                    0xf4303b44
#define L3FE_FE_L3E_HS_BA_CA1_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ba1                  :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_BA_CA1_t;


#define L3FE_FE_L3E_HS_BA_CA0                    0xf4303b48
#define L3FE_FE_L3E_HS_BA_CA0_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t ba0                  : 25 ; /* bits 31:7 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_BA_CA0_t;


#define L3FE_FE_L3E_HS_CACHE_CTRL                0xf4303b4c
#define L3FE_FE_L3E_HS_CACHE_CTRL_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t slot                 :  5 ; /* bits 4:0 */
    ca_uint32_t crc16                : 16 ; /* bits 20:5 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t loc                  :  1 ; /* bits 24:24 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t age                  :  2 ; /* bits 27:26 */
    ca_uint32_t pri                  :  2 ; /* bits 29:28 */
    ca_uint32_t cmd                  :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_CTRL_t;


#define L3FE_FE_L3E_HS_CACHE_CTRL_REQ            0xf4303b50
#define L3FE_FE_L3E_HS_CACHE_CTRL_REQ_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t req_sts              :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_CTRL_REQ_t;


#define L3FE_FE_L3E_HS_CACHE_CTRL_STS            0xf4303b54
#define L3FE_FE_L3E_HS_CACHE_CTRL_STS_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bsy                  :  1 ; /* bits 0:0 */
    ca_uint32_t err_hash             :  1 ; /* bits 1:1 */
    ca_uint32_t err_free             :  1 ; /* bits 2:2 */
    ca_uint32_t err_nch              :  1 ; /* bits 3:3 */
    ca_uint32_t sts_match            :  1 ; /* bits 4:4 */
    ca_uint32_t sts_match_loc        :  1 ; /* bits 5:5 */
    ca_uint32_t sts_evict            :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_CTRL_STS_t;


#define L3FE_FE_L3E_HS_CACHE_AGE10               0xf4303b58
#define L3FE_FE_L3E_HS_CACHE_AGE10_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ut_t0                : 16 ; /* bits 15:0 */
    ca_uint32_t ut_t1                : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_AGE10_t;


#define L3FE_FE_L3E_HS_CACHE_AGE32               0xf4303b5c
#define L3FE_FE_L3E_HS_CACHE_AGE32_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ut_t2                : 16 ; /* bits 15:0 */
    ca_uint32_t ut_t3                : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_AGE32_t;


#define L3FE_FE_L3E_HS_CACHE_CNT                 0xf4303b60
#define L3FE_FE_L3E_HS_CACHE_CNT_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ut_cnt               : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_CNT_t;


#define L3FE_FE_L3E_HS_CACHE_MISC                0xf4303b64
#define L3FE_FE_L3E_HS_CACHE_MISC_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t s2_ra_en             :  1 ; /* bits 26:26 */
    ca_uint32_t s2_ra_pri            :  2 ; /* bits 28:27 */
    ca_uint32_t crep_en              :  1 ; /* bits 29:29 */
    ca_uint32_t s3_loc_n             :  1 ; /* bits 30:30 */
    ca_uint32_t s3_ra_en             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_MISC_t;


#define L3FE_FE_L3E_HS_AXI_CTRL_1                0xf4303b68
#define L3FE_FE_L3E_HS_AXI_CTRL_1_STRIDE         4
#define L3FE_FE_L3E_HS_AXI_CTRL_1_COUNT          4
#define L3FE_FE_L3E_HS_AXI_CTRL_1_dft            0x02000000

typedef volatile union {
  struct {
    ca_uint32_t user                 : 25 ; /* bits 24:0 */
    ca_uint32_t id                   :  4 ; /* bits 28:25 */
    ca_uint32_t ace                  :  1 ; /* bits 29:29 */
    ca_uint32_t rsrvd1               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_AXI_CTRL_1_t;

            
#define L3FE_FE_L3E_HS_SWO_IDX                   0xf4303b78
#define L3FE_FE_L3E_HS_SWO_IDX_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t idx                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_SWO_IDX_t;


#define L3FE_FE_L3E_HS_SWO_DAT                   0xf4303b7c
#define L3FE_FE_L3E_HS_SWO_DAT_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dat                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_SWO_DAT_t;


#define L3FE_FE_L3E_HS_SWO_CTRL                  0xf4303b80
#define L3FE_FE_L3E_HS_SWO_CTRL_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cmd_sts              :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_SWO_CTRL_t;


#define L3FE_FE_L3E_HS_CACHE_HASH_ACCESS         0xf4303b84
#define L3FE_FE_L3E_HS_CACHE_HASH_ACCESS_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              : 11 ; /* bits 10:0 */
    ca_uint32_t rsrvd1               : 19 ;
    ca_uint32_t r0w1                 :  1 ; /* bits 30:30 */
    ca_uint32_t status               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_HASH_ACCESS_t;


#define L3FE_FE_L3E_HS_CACHE_HASH_DATA1          0xf4303b88
#define L3FE_FE_L3E_HS_CACHE_HASH_DATA1_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t crc16                : 13 ; /* bits 12:0 */
    ca_uint32_t slot                 :  5 ; /* bits 17:13 */
    ca_uint32_t location             :  1 ; /* bits 18:18 */
    ca_uint32_t pri                  :  2 ; /* bits 20:19 */
    ca_uint32_t age                  :  2 ; /* bits 22:21 */
    ca_uint32_t rsrvd1               :  9 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_HASH_DATA1_t;


#define L3FE_FE_L3E_HS_CACHE_HASH_DATA0          0xf4303b8c
#define L3FE_FE_L3E_HS_CACHE_HASH_DATA0_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t crc32                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CACHE_HASH_DATA0_t;


#define L3FE_FE_L3E_HS_OVERFLOW_HASH_ACCESS      0xf4303b90
#define L3FE_FE_L3E_HS_OVERFLOW_HASH_ACCESS_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t r0w1                 :  1 ; /* bits 30:30 */
    ca_uint32_t status               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_OVERFLOW_HASH_ACCESS_t;


#define L3FE_FE_L3E_HS_OVERFLOW_HASH_DATA1       0xf4303b94
#define L3FE_FE_L3E_HS_OVERFLOW_HASH_DATA1_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t crc16                : 16 ; /* bits 15:0 */
    ca_uint32_t profile              :  4 ; /* bits 19:16 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_OVERFLOW_HASH_DATA1_t;


#define L3FE_FE_L3E_HS_OVERFLOW_HASH_DATA0       0xf4303b98
#define L3FE_FE_L3E_HS_OVERFLOW_HASH_DATA0_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t crc32                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_OVERFLOW_HASH_DATA0_t;


#define L3FE_FE_L3E_HS_MASK_MEM_ACCESS           0xf4303b9c
#define L3FE_FE_L3E_HS_MASK_MEM_ACCESS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t r0w1                 :  1 ; /* bits 30:30 */
    ca_uint32_t status               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_MASK_MEM_ACCESS_t;


#define L3FE_FE_L3E_HS_MASK_MEM_MASK3            0xf4303ba0
#define L3FE_FE_L3E_HS_MASK_MEM_MASK3_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_MASK_MEM_MASK3_t;


#define L3FE_FE_L3E_HS_MASK_MEM_MASK2            0xf4303ba4
#define L3FE_FE_L3E_HS_MASK_MEM_MASK2_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_MASK_MEM_MASK2_t;


#define L3FE_FE_L3E_HS_MASK_MEM_MASK1            0xf4303ba8
#define L3FE_FE_L3E_HS_MASK_MEM_MASK1_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_MASK_MEM_MASK1_t;


#define L3FE_FE_L3E_HS_MASK_MEM_MASK0            0xf4303bac
#define L3FE_FE_L3E_HS_MASK_MEM_MASK0_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_MASK_MEM_MASK0_t;


#define L3FE_FE_L3E_HS_AGING_GRANULARITY         0xf4303bb0
#define L3FE_FE_L3E_HS_AGING_GRANULARITY_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t timer                : 30 ; /* bits 29:0 */
    ca_uint32_t rsrvd1               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_AGING_GRANULARITY_t;


#define L3FE_FE_L3E_HS_HASH_AGE_MEM_ACCESS       0xf4303bb4
#define L3FE_FE_L3E_HS_HASH_AGE_MEM_ACCESS_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 18 ;
    ca_uint32_t r0w1                 :  1 ; /* bits 30:30 */
    ca_uint32_t age                  :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_HASH_AGE_MEM_ACCESS_t;


#define L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA3        0xf4303bb8
#define L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA3_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA3_t;


#define L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA2        0xf4303bbc
#define L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA2_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA2_t;


#define L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA1        0xf4303bc0
#define L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA1_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA1_t;


#define L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA0        0xf4303bc4
#define L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA0_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA0_t;


#define L3FE_FE_L3E_HS_MEM_INI                   0xf4303bc8
#define L3FE_FE_L3E_HS_MEM_INI_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t req_sts              :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_MEM_INI_t;


#define L3FE_FE_L3E_HS_CHK_FAIL_CTRL             0xf4303bcc
#define L3FE_FE_L3E_HS_CHK_FAIL_CTRL_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t type0                :  8 ; /* bits 7:0 */
    ca_uint32_t type1                :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_CHK_FAIL_CTRL_t;


#define L3FE_FE_L3E_HS_RSV0                      0xf4303bd0
#define L3FE_FE_L3E_HS_RSV0_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsv                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_RSV0_t;


#define L3FE_FE_L3E_HS_RSV1                      0xf4303bd4
#define L3FE_FE_L3E_HS_RSV1_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsv                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_RSV1_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* FE_L3E_HS */
typedef struct {
  L3FE_FE_L3E_HS_PROFILE0_INI_t            PROFILE0_INI;                  /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  L3FE_FE_L3E_HS_PROFILE0_TUPLE0_t         PROFILE0_TUPLE0;               /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[31];                   
  L3FE_FE_L3E_HS_PROFILE0_TYPE0_ACTION_t   PROFILE0_TYPE0_ACTION;         /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd3[623];                  
  L3FE_FE_L3E_HS_HASH_INI_t                HASH_INI;                      /* addr: 0x00000294 */
  ca_uint32_t                              rsrvd4[3];                    
  L3FE_FE_L3E_HS_BA_MH1_t                  BA_MH1;                        /* addr: 0x00000298 */
  ca_uint32_t                              rsrvd5[3];                    
  L3FE_FE_L3E_HS_BA_MH0_t                  BA_MH0;                        /* addr: 0x0000029c */
  ca_uint32_t                              rsrvd6[3];                    
  L3FE_FE_L3E_HS_BA_MA1_t                  BA_MA1;                        /* addr: 0x000002a0 */
  ca_uint32_t                              rsrvd7[3];                    
  L3FE_FE_L3E_HS_BA_MA0_t                  BA_MA0;                        /* addr: 0x000002a4 */
  ca_uint32_t                              rsrvd8[3];                    
  L3FE_FE_L3E_HS_OVERFLOW_INI_t            OVERFLOW_INI;                  /* addr: 0x000002a8 */
  ca_uint32_t                              rsrvd9[3];                    
  L3FE_FE_L3E_HS_BA_OA1_t                  BA_OA1;                        /* addr: 0x000002ac */
  ca_uint32_t                              rsrvd10[3];                   
  L3FE_FE_L3E_HS_BA_OA0_t                  BA_OA0;                        /* addr: 0x000002b0 */
  ca_uint32_t                              rsrvd11[3];                   
  L3FE_FE_L3E_HS_DEFAULT_INI_t             DEFAULT_INI;                   /* addr: 0x000002b4 */
  ca_uint32_t                              rsrvd12[3];                   
  L3FE_FE_L3E_HS_BA_DA1_t                  BA_DA1;                        /* addr: 0x000002b8 */
  ca_uint32_t                              rsrvd13[3];                   
  L3FE_FE_L3E_HS_BA_DA0_t                  BA_DA0;                        /* addr: 0x000002bc */
  ca_uint32_t                              rsrvd14[3];                   
  L3FE_FE_L3E_HS_DEFAULT_ACTION_0_t        DEFAULT_ACTION_0;              /* addr: 0x000002c0 */
  ca_uint32_t                              rsrvd15[127];                 
  L3FE_FE_L3E_HS_CACHE_INI_t               CACHE_INI;                     /* addr: 0x00000340 */
  ca_uint32_t                              rsrvd16[3];                   
  L3FE_FE_L3E_HS_BA_CA1_t                  BA_CA1;                        /* addr: 0x00000344 */
  ca_uint32_t                              rsrvd17[3];                   
  L3FE_FE_L3E_HS_BA_CA0_t                  BA_CA0;                        /* addr: 0x00000348 */
  ca_uint32_t                              rsrvd18[3];                   
  L3FE_FE_L3E_HS_CACHE_CTRL_t              CACHE_CTRL;                    /* addr: 0x0000034c */
  ca_uint32_t                              rsrvd19[3];                   
  L3FE_FE_L3E_HS_CACHE_CTRL_REQ_t          CACHE_CTRL_REQ;                /* addr: 0x00000350 */
  ca_uint32_t                              rsrvd20[3];                   
  L3FE_FE_L3E_HS_CACHE_CTRL_STS_t          CACHE_CTRL_STS;                /* addr: 0x00000354 */
  ca_uint32_t                              rsrvd21[3];                   
  L3FE_FE_L3E_HS_CACHE_AGE10_t             CACHE_AGE10;                   /* addr: 0x00000358 */
  ca_uint32_t                              rsrvd22[3];                   
  L3FE_FE_L3E_HS_CACHE_AGE32_t             CACHE_AGE32;                   /* addr: 0x0000035c */
  ca_uint32_t                              rsrvd23[3];                   
  L3FE_FE_L3E_HS_CACHE_CNT_t               CACHE_CNT;                     /* addr: 0x00000360 */
  ca_uint32_t                              rsrvd24[3];                   
  L3FE_FE_L3E_HS_CACHE_MISC_t              CACHE_MISC;                    /* addr: 0x00000364 */
  ca_uint32_t                              rsrvd25[3];                   
  L3FE_FE_L3E_HS_AXI_CTRL_1_t              AXI_CTRL_1;                    /* addr: 0x00000368 */
  ca_uint32_t                              rsrvd26[15];                  
  L3FE_FE_L3E_HS_SWO_IDX_t                 SWO_IDX;                       /* addr: 0x00000378 */
  ca_uint32_t                              rsrvd27[3];                   
  L3FE_FE_L3E_HS_SWO_DAT_t                 SWO_DAT;                       /* addr: 0x0000037c */
  ca_uint32_t                              rsrvd28[3];                   
  L3FE_FE_L3E_HS_SWO_CTRL_t                SWO_CTRL;                      /* addr: 0x00000380 */
  ca_uint32_t                              rsrvd29[3];                   
  L3FE_FE_L3E_HS_CACHE_HASH_ACCESS_t       CACHE_HASH_ACCESS;             /* addr: 0x00000384 */
  ca_uint32_t                              rsrvd30[3];                   
  L3FE_FE_L3E_HS_CACHE_HASH_DATA1_t        CACHE_HASH_DATA1;              /* addr: 0x00000388 */
  ca_uint32_t                              rsrvd31[3];                   
  L3FE_FE_L3E_HS_CACHE_HASH_DATA0_t        CACHE_HASH_DATA0;              /* addr: 0x0000038c */
  ca_uint32_t                              rsrvd32[3];                   
  L3FE_FE_L3E_HS_OVERFLOW_HASH_ACCESS_t    OVERFLOW_HASH_ACCESS;          /* addr: 0x00000390 */
  ca_uint32_t                              rsrvd33[3];                   
  L3FE_FE_L3E_HS_OVERFLOW_HASH_DATA1_t     OVERFLOW_HASH_DATA1;           /* addr: 0x00000394 */
  ca_uint32_t                              rsrvd34[3];                   
  L3FE_FE_L3E_HS_OVERFLOW_HASH_DATA0_t     OVERFLOW_HASH_DATA0;           /* addr: 0x00000398 */
  ca_uint32_t                              rsrvd35[3];                   
  L3FE_FE_L3E_HS_MASK_MEM_ACCESS_t         MASK_MEM_ACCESS;               /* addr: 0x0000039c */
  ca_uint32_t                              rsrvd36[3];                   
  L3FE_FE_L3E_HS_MASK_MEM_MASK3_t          MASK_MEM_MASK3;                /* addr: 0x000003a0 */
  ca_uint32_t                              rsrvd37[3];                   
  L3FE_FE_L3E_HS_MASK_MEM_MASK2_t          MASK_MEM_MASK2;                /* addr: 0x000003a4 */
  ca_uint32_t                              rsrvd38[3];                   
  L3FE_FE_L3E_HS_MASK_MEM_MASK1_t          MASK_MEM_MASK1;                /* addr: 0x000003a8 */
  ca_uint32_t                              rsrvd39[3];                   
  L3FE_FE_L3E_HS_MASK_MEM_MASK0_t          MASK_MEM_MASK0;                /* addr: 0x000003ac */
  ca_uint32_t                              rsrvd40[3];                   
  L3FE_FE_L3E_HS_AGING_GRANULARITY_t       AGING_GRANULARITY;             /* addr: 0x000003b0 */
  ca_uint32_t                              rsrvd41[3];                   
  L3FE_FE_L3E_HS_HASH_AGE_MEM_ACCESS_t     HASH_AGE_MEM_ACCESS;           /* addr: 0x000003b4 */
  ca_uint32_t                              rsrvd42[3];                   
  L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA3_t      HASH_AGE_MEM_DATA3;            /* addr: 0x000003b8 */
  ca_uint32_t                              rsrvd43[3];                   
  L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA2_t      HASH_AGE_MEM_DATA2;            /* addr: 0x000003bc */
  ca_uint32_t                              rsrvd44[3];                   
  L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA1_t      HASH_AGE_MEM_DATA1;            /* addr: 0x000003c0 */
  ca_uint32_t                              rsrvd45[3];                   
  L3FE_FE_L3E_HS_HASH_AGE_MEM_DATA0_t      HASH_AGE_MEM_DATA0;            /* addr: 0x000003c4 */
  ca_uint32_t                              rsrvd46[3];                   
  L3FE_FE_L3E_HS_MEM_INI_t                 MEM_INI;                       /* addr: 0x000003c8 */
  ca_uint32_t                              rsrvd47[3];                   
  L3FE_FE_L3E_HS_CHK_FAIL_CTRL_t           CHK_FAIL_CTRL;                 /* addr: 0x000003cc */
  ca_uint32_t                              rsrvd48[3];                   
  L3FE_FE_L3E_HS_RSV0_t                    RSV0;                          /* addr: 0x000003d0 */
  ca_uint32_t                              rsrvd49[3];                   
  L3FE_FE_L3E_HS_RSV1_t                    RSV1;                          /* addr: 0x000003d4 */
} APB0_L3FE_FE_L3E_HS_t;


/*
 * AXIM2
 */
        
#define L3FE_AXIM2_CONFIG                        0xf4303c80
#define L3FE_AXIM2_CONFIG_dft                    0x00000200

typedef volatile union {
  struct {
    ca_uint32_t axi_write_outtrans_num :  4 ; /* bits 3:0 */
    ca_uint32_t axi_read_outtrans_num :  4 ; /* bits 7:4 */
    ca_uint32_t axi_xbus_len         :  3 ; /* bits 10:8 */
    ca_uint32_t write_cacheline_trans_en :  1 ; /* bits 11:11 */
    ca_uint32_t write_cacheline_trans_size :  1 ; /* bits 12:12 */
    ca_uint32_t read_cacheline_trans_en :  1 ; /* bits 13:13 */
    ca_uint32_t read_cacheline_trans_size :  1 ; /* bits 14:14 */
    ca_uint32_t arcache_eos_en       :  1 ; /* bits 15:15 */
    ca_uint32_t awcache_eos_en       :  1 ; /* bits 16:16 */
    ca_uint32_t reserved             : 15 ; /* bits 31:17 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_AXIM2_CONFIG_t;


#define L3FE_AXIM2_TIMEOUT_THRESHOLD             0xf4303c84
#define L3FE_AXIM2_TIMEOUT_THRESHOLD_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t read_channel_threshold :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t write_channel_threshold :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd2               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_AXIM2_TIMEOUT_THRESHOLD_t;


#define L3FE_AXIM2_INTERRUPT_STATUS              0xf4303c88
#define L3FE_AXIM2_INTERRUPT_STATUS_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t read_trans_resp_timeout_int :  1 ; /* bits 0:0 */
    ca_uint32_t read_trans_resp_err_int :  1 ; /* bits 1:1 */
    ca_uint32_t write_trans_resp_timeout_int :  1 ; /* bits 2:2 */
    ca_uint32_t write_trans_resp_err_int :  1 ; /* bits 3:3 */
    ca_uint32_t read_trans_resp_ace_err_int :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_AXIM2_INTERRUPT_STATUS_t;


#define L3FE_AXIM2_INTERRUPT_ENABLE              0xf4303c8c
#define L3FE_AXIM2_INTERRUPT_ENABLE_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t read_trans_resp_timeout_int_en :  1 ; /* bits 0:0 */
    ca_uint32_t read_trans_resp_err_int_en :  1 ; /* bits 1:1 */
    ca_uint32_t write_trans_resp_timeout_int_en :  1 ; /* bits 2:2 */
    ca_uint32_t write_trans_resp_err_int_en :  1 ; /* bits 3:3 */
    ca_uint32_t read_trans_resp_ace_err_int_en :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_AXIM2_INTERRUPT_ENABLE_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* AXIM2 */
typedef struct {
  L3FE_AXIM2_CONFIG_t                      CONFIG;                        /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  L3FE_AXIM2_TIMEOUT_THRESHOLD_t           TIMEOUT_THRESHOLD;             /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  L3FE_AXIM2_INTERRUPT_STATUS_t            INTERRUPT_STATUS;              /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  L3FE_AXIM2_INTERRUPT_ENABLE_t            INTERRUPT_ENABLE;              /* addr: 0x0000000c */
} APB0_L3FE_AXIM2_t;


/*
 * FE_L3E_HS_LIGHT
 */
        
#define L3FE_FE_L3E_HS_LIGHT_CFG                 0xf4303d00
#define L3FE_FE_L3E_HS_LIGHT_CFG_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ht_size              :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_LIGHT_CFG_t;


#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_EN         0xf4303d04
#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_EN_STRIDE  12
#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_EN_COUNT   14
#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_EN_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tpl_num              :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t tpl_type             :  8 ; /* bits 15:8 */
    ca_uint32_t default_sel_0e       :  4 ; /* bits 19:16 */
    ca_uint32_t default_sel_0a       :  4 ; /* bits 23:20 */
    ca_uint32_t default_sel_1e       :  4 ; /* bits 27:24 */
    ca_uint32_t default_sel_1a       :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_LIGHT_PROFILE0_EN_t;


#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_MASKPTR1   0xf4303d08
#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_MASKPTR1_STRIDE 12
#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_MASKPTR1_COUNT 14
#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_MASKPTR1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t maskptr41            :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t maskptr51            :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t maskptr61            :  5 ; /* bits 20:16 */
    ca_uint32_t rsrvd3               :  3 ;
    ca_uint32_t maskptr71            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd4               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_LIGHT_PROFILE0_MASKPTR1_t;


#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_MASKPTR0   0xf4303d0c
#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_MASKPTR0_STRIDE 12
#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_MASKPTR0_COUNT 14
#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_MASKPTR0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t maskptr00            :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t maskptr10            :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t maskptr20            :  5 ; /* bits 20:16 */
    ca_uint32_t rsrvd3               :  3 ;
    ca_uint32_t maskptr30            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd4               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_LIGHT_PROFILE0_MASKPTR0_t;

                                                                                                                                                            
#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_ACTION     0xf4303dac
#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_ACTION_STRIDE 4
#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_ACTION_COUNT 14
#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_ACTION_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t act_mask_hit         : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_LIGHT_PROFILE0_ACTION_t;

                                                    
#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_ACTION_TYPE1 0xf4303de4
#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_ACTION_TYPE1_STRIDE 4
#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_ACTION_TYPE1_COUNT 14
#define L3FE_FE_L3E_HS_LIGHT_PROFILE0_ACTION_TYPE1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t act_mask_hit         : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_LIGHT_PROFILE0_ACTION_TYPE1_t;

                                                    
#define L3FE_FE_L3E_HS_LIGHT_PROFILE14_ACTION    0xf4303e1c
#define L3FE_FE_L3E_HS_LIGHT_PROFILE14_ACTION_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t act_mask             : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_LIGHT_PROFILE14_ACTION_t;


#define L3FE_FE_L3E_HS_LIGHT_DEFAULT_ACTION_MASK0 0xf4303e20
#define L3FE_FE_L3E_HS_LIGHT_DEFAULT_ACTION_MASK0_STRIDE 4
#define L3FE_FE_L3E_HS_LIGHT_DEFAULT_ACTION_MASK0_COUNT 16
#define L3FE_FE_L3E_HS_LIGHT_DEFAULT_ACTION_MASK0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t act_mask_dft         : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_LIGHT_DEFAULT_ACTION_MASK0_t;

                                                            
#define L3FE_FE_L3E_HS_LIGHT_AGING_GRANULARITY   0xf4303e60
#define L3FE_FE_L3E_HS_LIGHT_AGING_GRANULARITY_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t timer                : 30 ; /* bits 29:0 */
    ca_uint32_t rsrvd1               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_LIGHT_AGING_GRANULARITY_t;


#define L3FE_FE_L3E_HS_LIGHT_IND_X_ACCESS        0xf4303e64
#define L3FE_FE_L3E_HS_LIGHT_IND_X_ACCESS_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              : 15 ; /* bits 14:0 */
    ca_uint32_t rsrvd1               : 15 ;
    ca_uint32_t r0w1                 :  1 ; /* bits 30:30 */
    ca_uint32_t status               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_LIGHT_IND_X_ACCESS_t;


#define L3FE_FE_L3E_HS_LIGHT_IND_X_DATA5         0xf4303e68
#define L3FE_FE_L3E_HS_LIGHT_IND_X_DATA5_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_LIGHT_IND_X_DATA5_t;


#define L3FE_FE_L3E_HS_LIGHT_IND_X_DATA4         0xf4303e6c
#define L3FE_FE_L3E_HS_LIGHT_IND_X_DATA4_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_LIGHT_IND_X_DATA4_t;


#define L3FE_FE_L3E_HS_LIGHT_IND_X_DATA3         0xf4303e70
#define L3FE_FE_L3E_HS_LIGHT_IND_X_DATA3_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_LIGHT_IND_X_DATA3_t;


#define L3FE_FE_L3E_HS_LIGHT_IND_X_DATA2         0xf4303e74
#define L3FE_FE_L3E_HS_LIGHT_IND_X_DATA2_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_LIGHT_IND_X_DATA2_t;


#define L3FE_FE_L3E_HS_LIGHT_IND_X_DATA1         0xf4303e78
#define L3FE_FE_L3E_HS_LIGHT_IND_X_DATA1_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_LIGHT_IND_X_DATA1_t;


#define L3FE_FE_L3E_HS_LIGHT_IND_X_DATA0         0xf4303e7c
#define L3FE_FE_L3E_HS_LIGHT_IND_X_DATA0_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_LIGHT_IND_X_DATA0_t;


#define L3FE_FE_L3E_HS_LIGHT_MEM_INI             0xf4303e80
#define L3FE_FE_L3E_HS_LIGHT_MEM_INI_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t req_sts              :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_LIGHT_MEM_INI_t;


#define L3FE_FE_L3E_HS_LIGHT_CHK_FAIL_CTRL       0xf4303e84
#define L3FE_FE_L3E_HS_LIGHT_CHK_FAIL_CTRL_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t type0                :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_LIGHT_CHK_FAIL_CTRL_t;


#define L3FE_FE_L3E_HS_LIGHT_RSV0                0xf4303e88
#define L3FE_FE_L3E_HS_LIGHT_RSV0_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsv                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_HS_LIGHT_RSV0_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* FE_L3E_HS_LIGHT */
typedef struct {
  L3FE_FE_L3E_HS_LIGHT_CFG_t               CFG;                           /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  L3FE_FE_L3E_HS_LIGHT_PROFILE0_EN_t       PROFILE0_EN;                   /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  L3FE_FE_L3E_HS_LIGHT_PROFILE0_MASKPTR1_t PROFILE0_MASKPTR1;             /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  L3FE_FE_L3E_HS_LIGHT_PROFILE0_MASKPTR0_t PROFILE0_MASKPTR0;             /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[159];                  
  L3FE_FE_L3E_HS_LIGHT_PROFILE0_ACTION_t   PROFILE0_ACTION;               /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd5[55];                   
  L3FE_FE_L3E_HS_LIGHT_PROFILE0_ACTION_TYPE1_t PROFILE0_ACTION_TYPE1;         /* addr: 0x000000e4 */
  ca_uint32_t                              rsrvd6[55];                   
  L3FE_FE_L3E_HS_LIGHT_PROFILE14_ACTION_t  PROFILE14_ACTION;              /* addr: 0x0000011c */
  ca_uint32_t                              rsrvd7[3];                    
  L3FE_FE_L3E_HS_LIGHT_DEFAULT_ACTION_MASK0_t DEFAULT_ACTION_MASK0;          /* addr: 0x00000120 */
  ca_uint32_t                              rsrvd8[63];                   
  L3FE_FE_L3E_HS_LIGHT_AGING_GRANULARITY_t AGING_GRANULARITY;             /* addr: 0x00000160 */
  ca_uint32_t                              rsrvd9[3];                    
  L3FE_FE_L3E_HS_LIGHT_IND_X_ACCESS_t      IND_X_ACCESS;                  /* addr: 0x00000164 */
  ca_uint32_t                              rsrvd10[3];                   
  L3FE_FE_L3E_HS_LIGHT_IND_X_DATA5_t       IND_X_DATA5;                   /* addr: 0x00000168 */
  ca_uint32_t                              rsrvd11[3];                   
  L3FE_FE_L3E_HS_LIGHT_IND_X_DATA4_t       IND_X_DATA4;                   /* addr: 0x0000016c */
  ca_uint32_t                              rsrvd12[3];                   
  L3FE_FE_L3E_HS_LIGHT_IND_X_DATA3_t       IND_X_DATA3;                   /* addr: 0x00000170 */
  ca_uint32_t                              rsrvd13[3];                   
  L3FE_FE_L3E_HS_LIGHT_IND_X_DATA2_t       IND_X_DATA2;                   /* addr: 0x00000174 */
  ca_uint32_t                              rsrvd14[3];                   
  L3FE_FE_L3E_HS_LIGHT_IND_X_DATA1_t       IND_X_DATA1;                   /* addr: 0x00000178 */
  ca_uint32_t                              rsrvd15[3];                   
  L3FE_FE_L3E_HS_LIGHT_IND_X_DATA0_t       IND_X_DATA0;                   /* addr: 0x0000017c */
  ca_uint32_t                              rsrvd16[3];                   
  L3FE_FE_L3E_HS_LIGHT_MEM_INI_t           MEM_INI;                       /* addr: 0x00000180 */
  ca_uint32_t                              rsrvd17[3];                   
  L3FE_FE_L3E_HS_LIGHT_CHK_FAIL_CTRL_t     CHK_FAIL_CTRL;                 /* addr: 0x00000184 */
  ca_uint32_t                              rsrvd18[3];                   
  L3FE_FE_L3E_HS_LIGHT_RSV0_t              RSV0;                          /* addr: 0x00000188 */
} APB0_L3FE_FE_L3E_HS_LIGHT_t;


/*
 * FE_L3E_LPM
 */
        
#define L3FE_FE_L3E_LPM_CTRL_PF0                 0xf4303f00
#define L3FE_FE_L3E_LPM_CTRL_PF0_dft             0x1f001c03

typedef volatile union {
  struct {
    ca_uint32_t v4_inc_last_row      :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t v6_dec_last_row      :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t v4_inc_1st_row       :  5 ; /* bits 20:16 */
    ca_uint32_t rsrvd3               :  3 ;
    ca_uint32_t v6_dec_1st_row       :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd4               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_CTRL_PF0_t;


#define L3FE_FE_L3E_LPM_CTRL_PF1                 0xf4303f04
#define L3FE_FE_L3E_LPM_CTRL_PF1_dft             0x1b041807

typedef volatile union {
  struct {
    ca_uint32_t v4_inc_last_row      :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t v6_dec_last_row      :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t v4_inc_1st_row       :  5 ; /* bits 20:16 */
    ca_uint32_t rsrvd3               :  3 ;
    ca_uint32_t v6_dec_1st_row       :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd4               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_CTRL_PF1_t;


#define L3FE_FE_L3E_LPM_CTRL_PF2                 0xf4303f08
#define L3FE_FE_L3E_LPM_CTRL_PF2_dft             0x1708140b

typedef volatile union {
  struct {
    ca_uint32_t v4_inc_last_row      :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t v6_dec_last_row      :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t v4_inc_1st_row       :  5 ; /* bits 20:16 */
    ca_uint32_t rsrvd3               :  3 ;
    ca_uint32_t v6_dec_1st_row       :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd4               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_CTRL_PF2_t;


#define L3FE_FE_L3E_LPM_CTRL_PF3                 0xf4303f0c
#define L3FE_FE_L3E_LPM_CTRL_PF3_dft             0x130c100f

typedef volatile union {
  struct {
    ca_uint32_t v4_inc_last_row      :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t v6_dec_last_row      :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t v4_inc_1st_row       :  5 ; /* bits 20:16 */
    ca_uint32_t rsrvd3               :  3 ;
    ca_uint32_t v6_dec_1st_row       :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd4               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_CTRL_PF3_t;


#define L3FE_FE_L3E_LPM_IPV4_ACTION_CTRL1        0xf4303f10
#define L3FE_FE_L3E_LPM_IPV4_ACTION_CTRL1_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t t4_ctrl_01           :  4 ; /* bits 3:0 */
    ca_uint32_t t4_ctrl_11           :  4 ; /* bits 7:4 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_IPV4_ACTION_CTRL1_t;


#define L3FE_FE_L3E_LPM_IPV4_ACTION_CTRL0        0xf4303f14
#define L3FE_FE_L3E_LPM_IPV4_ACTION_CTRL0_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t default_idx0         : 12 ; /* bits 11:0 */
    ca_uint32_t default_ctrl0        :  4 ; /* bits 15:12 */
    ca_uint32_t default_dpid0        :  6 ; /* bits 21:16 */
    ca_uint32_t default_dpid_vld0    :  1 ; /* bits 22:22 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t default_stg0         :  2 ; /* bits 25:24 */
    ca_uint32_t default_stg_ud0      :  2 ; /* bits 27:26 */
    ca_uint32_t rsrvd2               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_IPV4_ACTION_CTRL0_t;


#define L3FE_FE_L3E_LPM_IPV6_ACTION_CTRL1        0xf4303f18
#define L3FE_FE_L3E_LPM_IPV6_ACTION_CTRL1_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t t4_ctrl_01           :  4 ; /* bits 3:0 */
    ca_uint32_t t4_ctrl_11           :  4 ; /* bits 7:4 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_IPV6_ACTION_CTRL1_t;


#define L3FE_FE_L3E_LPM_IPV6_ACTION_CTRL0        0xf4303f1c
#define L3FE_FE_L3E_LPM_IPV6_ACTION_CTRL0_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t default_idx0         : 12 ; /* bits 11:0 */
    ca_uint32_t default_ctrl0        :  4 ; /* bits 15:12 */
    ca_uint32_t default_dpid0        :  6 ; /* bits 21:16 */
    ca_uint32_t default_dpid_vld0    :  1 ; /* bits 22:22 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t default_stg0         :  2 ; /* bits 25:24 */
    ca_uint32_t default_stg_ud0      :  2 ; /* bits 27:26 */
    ca_uint32_t rsrvd2               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_IPV6_ACTION_CTRL0_t;


#define L3FE_FE_L3E_LPM_STS31                    0xf4303f20
#define L3FE_FE_L3E_LPM_STS31_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bits31               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_STS31_t;


#define L3FE_FE_L3E_LPM_STS30                    0xf4303f24
#define L3FE_FE_L3E_LPM_STS30_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bits30               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_STS30_t;


#define L3FE_FE_L3E_LPM_STS29                    0xf4303f28
#define L3FE_FE_L3E_LPM_STS29_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bits29               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_STS29_t;


#define L3FE_FE_L3E_LPM_STS28                    0xf4303f2c
#define L3FE_FE_L3E_LPM_STS28_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bits28               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_STS28_t;


#define L3FE_FE_L3E_LPM_STS27                    0xf4303f30
#define L3FE_FE_L3E_LPM_STS27_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bits27               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_STS27_t;


#define L3FE_FE_L3E_LPM_STS26                    0xf4303f34
#define L3FE_FE_L3E_LPM_STS26_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bits26               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_STS26_t;


#define L3FE_FE_L3E_LPM_STS25                    0xf4303f38
#define L3FE_FE_L3E_LPM_STS25_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bits25               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_STS25_t;


#define L3FE_FE_L3E_LPM_STS24                    0xf4303f3c
#define L3FE_FE_L3E_LPM_STS24_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bits24               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_STS24_t;


#define L3FE_FE_L3E_LPM_STS23                    0xf4303f40
#define L3FE_FE_L3E_LPM_STS23_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bits23               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_STS23_t;


#define L3FE_FE_L3E_LPM_STS22                    0xf4303f44
#define L3FE_FE_L3E_LPM_STS22_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bits22               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_STS22_t;


#define L3FE_FE_L3E_LPM_STS21                    0xf4303f48
#define L3FE_FE_L3E_LPM_STS21_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bits21               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_STS21_t;


#define L3FE_FE_L3E_LPM_STS20                    0xf4303f4c
#define L3FE_FE_L3E_LPM_STS20_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bits20               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_STS20_t;


#define L3FE_FE_L3E_LPM_STS19                    0xf4303f50
#define L3FE_FE_L3E_LPM_STS19_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bits19               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_STS19_t;


#define L3FE_FE_L3E_LPM_STS18                    0xf4303f54
#define L3FE_FE_L3E_LPM_STS18_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bits18               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_STS18_t;


#define L3FE_FE_L3E_LPM_STS17                    0xf4303f58
#define L3FE_FE_L3E_LPM_STS17_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bits17               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_STS17_t;


#define L3FE_FE_L3E_LPM_STS16                    0xf4303f5c
#define L3FE_FE_L3E_LPM_STS16_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bits16               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_STS16_t;


#define L3FE_FE_L3E_LPM_STS15                    0xf4303f60
#define L3FE_FE_L3E_LPM_STS15_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bits15               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_STS15_t;


#define L3FE_FE_L3E_LPM_STS14                    0xf4303f64
#define L3FE_FE_L3E_LPM_STS14_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bits14               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_STS14_t;


#define L3FE_FE_L3E_LPM_STS13                    0xf4303f68
#define L3FE_FE_L3E_LPM_STS13_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bits13               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_STS13_t;


#define L3FE_FE_L3E_LPM_STS12                    0xf4303f6c
#define L3FE_FE_L3E_LPM_STS12_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bits12               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_STS12_t;


#define L3FE_FE_L3E_LPM_STS11                    0xf4303f70
#define L3FE_FE_L3E_LPM_STS11_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bits11               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_STS11_t;


#define L3FE_FE_L3E_LPM_STS10                    0xf4303f74
#define L3FE_FE_L3E_LPM_STS10_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bits10               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_STS10_t;


#define L3FE_FE_L3E_LPM_STS9                     0xf4303f78
#define L3FE_FE_L3E_LPM_STS9_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bits9                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_STS9_t;


#define L3FE_FE_L3E_LPM_STS8                     0xf4303f7c
#define L3FE_FE_L3E_LPM_STS8_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bits8                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_STS8_t;


#define L3FE_FE_L3E_LPM_STS7                     0xf4303f80
#define L3FE_FE_L3E_LPM_STS7_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bits7                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_STS7_t;


#define L3FE_FE_L3E_LPM_STS6                     0xf4303f84
#define L3FE_FE_L3E_LPM_STS6_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bits6                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_STS6_t;


#define L3FE_FE_L3E_LPM_STS5                     0xf4303f88
#define L3FE_FE_L3E_LPM_STS5_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bits5                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_STS5_t;


#define L3FE_FE_L3E_LPM_STS4                     0xf4303f8c
#define L3FE_FE_L3E_LPM_STS4_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bits4                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_STS4_t;


#define L3FE_FE_L3E_LPM_STS3                     0xf4303f90
#define L3FE_FE_L3E_LPM_STS3_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bits3                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_STS3_t;


#define L3FE_FE_L3E_LPM_STS2                     0xf4303f94
#define L3FE_FE_L3E_LPM_STS2_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bits2                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_STS2_t;


#define L3FE_FE_L3E_LPM_STS1                     0xf4303f98
#define L3FE_FE_L3E_LPM_STS1_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bits1                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_STS1_t;


#define L3FE_FE_L3E_LPM_STS0                     0xf4303f9c
#define L3FE_FE_L3E_LPM_STS0_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bits0                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_STS0_t;


#define L3FE_FE_L3E_LPM_DBG0                     0xf4303fa0
#define L3FE_FE_L3E_LPM_DBG0_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bits                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_DBG0_t;


#define L3FE_FE_L3E_LPM_TBL_ACCESS               0xf4303fa4
#define L3FE_FE_L3E_LPM_TBL_ACCESS_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 20 ;
    ca_uint32_t r0w1                 :  1 ; /* bits 30:30 */
    ca_uint32_t status               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_TBL_ACCESS_t;


#define L3FE_FE_L3E_LPM_TBL_DATA1                0xf4303fa8
#define L3FE_FE_L3E_LPM_TBL_DATA1_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mask                 :  6 ; /* bits 5:0 */
    ca_uint32_t attr                 :  2 ; /* bits 7:6 */
    ca_uint32_t rst_idx              : 12 ; /* bits 19:8 */
    ca_uint32_t rst_ctrl             :  1 ; /* bits 20:20 */
    ca_uint32_t valid                :  1 ; /* bits 21:21 */
    ca_uint32_t rsrvd1               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_TBL_DATA1_t;


#define L3FE_FE_L3E_LPM_TBL_DATA0                0xf4303fac
#define L3FE_FE_L3E_LPM_TBL_DATA0_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_TBL_DATA0_t;


#define L3FE_FE_L3E_LPM_MEM_INI                  0xf4303fb0
#define L3FE_FE_L3E_LPM_MEM_INI_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t req_sts              :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} L3FE_FE_L3E_LPM_MEM_INI_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* FE_L3E_LPM */
typedef struct {
  L3FE_FE_L3E_LPM_CTRL_PF0_t               CTRL_PF0;                      /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  L3FE_FE_L3E_LPM_CTRL_PF1_t               CTRL_PF1;                      /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  L3FE_FE_L3E_LPM_CTRL_PF2_t               CTRL_PF2;                      /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  L3FE_FE_L3E_LPM_CTRL_PF3_t               CTRL_PF3;                      /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  L3FE_FE_L3E_LPM_IPV4_ACTION_CTRL1_t      IPV4_ACTION_CTRL1;             /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  L3FE_FE_L3E_LPM_IPV4_ACTION_CTRL0_t      IPV4_ACTION_CTRL0;             /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  L3FE_FE_L3E_LPM_IPV6_ACTION_CTRL1_t      IPV6_ACTION_CTRL1;             /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  L3FE_FE_L3E_LPM_IPV6_ACTION_CTRL0_t      IPV6_ACTION_CTRL0;             /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  L3FE_FE_L3E_LPM_STS31_t                  STS31;                         /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  L3FE_FE_L3E_LPM_STS30_t                  STS30;                         /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  L3FE_FE_L3E_LPM_STS29_t                  STS29;                         /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  L3FE_FE_L3E_LPM_STS28_t                  STS28;                         /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  L3FE_FE_L3E_LPM_STS27_t                  STS27;                         /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  L3FE_FE_L3E_LPM_STS26_t                  STS26;                         /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  L3FE_FE_L3E_LPM_STS25_t                  STS25;                         /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  L3FE_FE_L3E_LPM_STS24_t                  STS24;                         /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  L3FE_FE_L3E_LPM_STS23_t                  STS23;                         /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  L3FE_FE_L3E_LPM_STS22_t                  STS22;                         /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  L3FE_FE_L3E_LPM_STS21_t                  STS21;                         /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  L3FE_FE_L3E_LPM_STS20_t                  STS20;                         /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  L3FE_FE_L3E_LPM_STS19_t                  STS19;                         /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  L3FE_FE_L3E_LPM_STS18_t                  STS18;                         /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  L3FE_FE_L3E_LPM_STS17_t                  STS17;                         /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  L3FE_FE_L3E_LPM_STS16_t                  STS16;                         /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  L3FE_FE_L3E_LPM_STS15_t                  STS15;                         /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  L3FE_FE_L3E_LPM_STS14_t                  STS14;                         /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  L3FE_FE_L3E_LPM_STS13_t                  STS13;                         /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  L3FE_FE_L3E_LPM_STS12_t                  STS12;                         /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  L3FE_FE_L3E_LPM_STS11_t                  STS11;                         /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  L3FE_FE_L3E_LPM_STS10_t                  STS10;                         /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  L3FE_FE_L3E_LPM_STS9_t                   STS9;                          /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  L3FE_FE_L3E_LPM_STS8_t                   STS8;                          /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  L3FE_FE_L3E_LPM_STS7_t                   STS7;                          /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  L3FE_FE_L3E_LPM_STS6_t                   STS6;                          /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  L3FE_FE_L3E_LPM_STS5_t                   STS5;                          /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  L3FE_FE_L3E_LPM_STS4_t                   STS4;                          /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  L3FE_FE_L3E_LPM_STS3_t                   STS3;                          /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  L3FE_FE_L3E_LPM_STS2_t                   STS2;                          /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  L3FE_FE_L3E_LPM_STS1_t                   STS1;                          /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];                   
  L3FE_FE_L3E_LPM_STS0_t                   STS0;                          /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];                   
  L3FE_FE_L3E_LPM_DBG0_t                   DBG0;                          /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];                   
  L3FE_FE_L3E_LPM_TBL_ACCESS_t             TBL_ACCESS;                    /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];                   
  L3FE_FE_L3E_LPM_TBL_DATA1_t              TBL_DATA1;                     /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];                   
  L3FE_FE_L3E_LPM_TBL_DATA0_t              TBL_DATA0;                     /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd44[3];                   
  L3FE_FE_L3E_LPM_MEM_INI_t                MEM_INI;                       /* addr: 0x000000b0 */
} APB0_L3FE_FE_L3E_LPM_t;

    
  
        
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* L3FE */

typedef struct {
  APB0_L3FE_GLB_t                          GLB;                           /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[377];                  
  APB0_L3FE_PP_t                           PP;                            /* addr: 0x00000200 */
  ca_uint32_t                              rsrvd2[151];                  
  APB0_L3FE_CLS_t                          CLS;                           /* addr: 0x00000300 */
  ca_uint32_t                              rsrvd3[89];                   
  APB0_L3FE_STG0_t                         STG0;                          /* addr: 0x00000380 */
  ca_uint32_t                              rsrvd4[93];                   
  APB0_L3FE_STG1_t                         STG1;                          /* addr: 0x00000400 */
  ca_uint32_t                              rsrvd5[237];                  
  APB0_L3FE_PE_t                           PE;                            /* addr: 0x00000500 */
  ca_uint32_t                              rsrvd6[627];                  
  APB0_L3FE_FE_L3E_HS_t                    FE_L3E_HS;                     /* addr: 0x00000800 */
  ca_uint32_t                              rsrvd7[661];                  
  APB0_L3FE_AXIM2_t                        AXIM2;                         /* addr: 0x00000c80 */
  ca_uint32_t                              rsrvd8[121];                  
  APB0_L3FE_FE_L3E_HS_LIGHT_t              FE_L3E_HS_LIGHT;               /* addr: 0x00000d00 */
  ca_uint32_t                              rsrvd9[315];                  
  APB0_L3FE_FE_L3E_LPM_t                   FE_L3E_LPM;                    /* addr: 0x00000f00 */
} APB0_L3FE_t;


/*
 * NI_HV
 */
  
/*
 * GLB
 */
        
#define NI_HV_GLB_REVISION                       0xf4304000
#define NI_HV_GLB_REVISION_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t minor                : 16 ; /* bits 15:0 */
    ca_uint32_t major                : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_REVISION_t;


#define NI_HV_GLB_INIT_DONE                      0xf4304004
#define NI_HV_GLB_INIT_DONE_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t ni_init_done         :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd2               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_INIT_DONE_t;


#define NI_HV_GLB_INTF_RST_CONFIG                0xf4304008
#define NI_HV_GLB_INTF_RST_CONFIG_dft            0x000fffff

typedef volatile union {
  struct {
    ca_uint32_t intf_rst_p0          :  1 ; /* bits 0:0 */
    ca_uint32_t intf_rst_p1          :  1 ; /* bits 1:1 */
    ca_uint32_t intf_rst_p2          :  1 ; /* bits 2:2 */
    ca_uint32_t intf_rst_p3          :  1 ; /* bits 3:3 */
    ca_uint32_t intf_rst_p4          :  1 ; /* bits 4:4 */
    ca_uint32_t mac_rx_rst_p0        :  1 ; /* bits 5:5 */
    ca_uint32_t mac_rx_rst_p1        :  1 ; /* bits 6:6 */
    ca_uint32_t mac_rx_rst_p2        :  1 ; /* bits 7:7 */
    ca_uint32_t mac_rx_rst_p3        :  1 ; /* bits 8:8 */
    ca_uint32_t mac_rx_rst_p4        :  1 ; /* bits 9:9 */
    ca_uint32_t mac_tx_rst_p0        :  1 ; /* bits 10:10 */
    ca_uint32_t mac_tx_rst_p1        :  1 ; /* bits 11:11 */
    ca_uint32_t mac_tx_rst_p2        :  1 ; /* bits 12:12 */
    ca_uint32_t mac_tx_rst_p3        :  1 ; /* bits 13:13 */
    ca_uint32_t mac_tx_rst_p4        :  1 ; /* bits 14:14 */
    ca_uint32_t port_rst_p5          :  1 ; /* bits 15:15 */
    ca_uint32_t pcs_rst_p6           :  1 ; /* bits 16:16 */
    ca_uint32_t pcs_rst_p7           :  1 ; /* bits 17:17 */
    ca_uint32_t mac_rst_p6           :  1 ; /* bits 18:18 */
    ca_uint32_t mac_rst_p7           :  1 ; /* bits 19:19 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_INTF_RST_CONFIG_t;


#define NI_HV_GLB_STATIC_CFG                     0xf430400c
#define NI_HV_GLB_STATIC_CFG_dft                 0x0220012f

typedef volatile union {
  struct {
    ca_uint32_t port_to_cpu          :  4 ; /* bits 3:0 */
    ca_uint32_t mgmt_pt_to_fe_also   :  1 ; /* bits 4:4 */
    ca_uint32_t txcrc_chk_en         :  1 ; /* bits 5:5 */
    ca_uint32_t p4_rgmii_tx_clk_phase :  2 ; /* bits 7:6 */
    ca_uint32_t p4_rgmii_tx_data_order :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t rxmib_mode           :  1 ; /* bits 16:16 */
    ca_uint32_t txmib_mode           :  1 ; /* bits 17:17 */
    ca_uint32_t eth_sch_rdy_pkt      :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t rxaui_mode           :  2 ; /* bits 21:20 */
    ca_uint32_t rxaui_sigdet         :  2 ; /* bits 23:22 */
    ca_uint32_t cnt_op_mode          :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd3               :  5 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_STATIC_CFG_t;


#define NI_HV_GLB_MAC_ADDR_CFG0                  0xf4304010
#define NI_HV_GLB_MAC_ADDR_CFG0_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac_addr0            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_MAC_ADDR_CFG0_t;


#define NI_HV_GLB_MAC_ADDR_CFG1                  0xf4304014
#define NI_HV_GLB_MAC_ADDR_CFG1_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac_addr1            :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_MAC_ADDR_CFG1_t;


#define NI_HV_GLB_WOL_PASSWD_0                   0xf4304018
#define NI_HV_GLB_WOL_PASSWD_0_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wol_passwd0          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_WOL_PASSWD_0_t;


#define NI_HV_GLB_WOL_PASSWD_1                   0xf430401c
#define NI_HV_GLB_WOL_PASSWD_1_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wol_passwd1          :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_WOL_PASSWD_1_t;


#define NI_HV_GLB_PKT_LEN_CFG                    0xf4304020
#define NI_HV_GLB_PKT_LEN_CFG_dft                0x004023f1

typedef volatile union {
  struct {
    ca_uint32_t max_pkt_size         : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t min_pkt_size         : 10 ; /* bits 25:16 */
    ca_uint32_t rsrvd2               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_PKT_LEN_CFG_t;


#define NI_HV_GLB_PKT_STOR_LEN_CFG               0xf4304024
#define NI_HV_GLB_PKT_STOR_LEN_CFG_dft           0x00002454

typedef volatile union {
  struct {
    ca_uint32_t max_stor_pkt_len     : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_PKT_STOR_LEN_CFG_t;


#define NI_HV_GLB_P5_BYPASS_CFG                  0xf4304028
#define NI_HV_GLB_P5_BYPASS_CFG_dft              0x00000008

typedef volatile union {
  struct {
    ca_uint32_t byp_cos              :  3 ; /* bits 2:0 */
    ca_uint32_t byp_dpq              :  1 ; /* bits 3:3 */
    ca_uint32_t byp_dpid             :  6 ; /* bits 9:4 */
    ca_uint32_t byp_mir              :  1 ; /* bits 10:10 */
    ca_uint32_t byp_ndrp             :  1 ; /* bits 11:11 */
    ca_uint32_t byp_en               :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd1               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_P5_BYPASS_CFG_t;


#define NI_HV_GLB_XGE_BYPASS_CFG                 0xf430402c
#define NI_HV_GLB_XGE_BYPASS_CFG_dft             0x00080008

typedef volatile union {
  struct {
    ca_uint32_t p6_byp_cos           :  3 ; /* bits 2:0 */
    ca_uint32_t p6_byp_dpq           :  1 ; /* bits 3:3 */
    ca_uint32_t p6_byp_dpid          :  6 ; /* bits 9:4 */
    ca_uint32_t p6_byp_mir           :  1 ; /* bits 10:10 */
    ca_uint32_t p6_byp_ndrp          :  1 ; /* bits 11:11 */
    ca_uint32_t p6_byp_en            :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t p7_byp_cos           :  3 ; /* bits 18:16 */
    ca_uint32_t p7_byp_dpq           :  1 ; /* bits 19:19 */
    ca_uint32_t p7_byp_dpid          :  6 ; /* bits 25:20 */
    ca_uint32_t p7_byp_mir           :  1 ; /* bits 26:26 */
    ca_uint32_t p7_byp_ndrp          :  1 ; /* bits 27:27 */
    ca_uint32_t p7_byp_en            :  1 ; /* bits 28:28 */
    ca_uint32_t p6_ts_fifo_rst       :  1 ; /* bits 29:29 */
    ca_uint32_t p7_ts_fifo_rst       :  1 ; /* bits 30:30 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_XGE_BYPASS_CFG_t;


#define NI_HV_GLB_XGE6_RXPAUSE_CFG               0xf4304030
#define NI_HV_GLB_XGE6_RXPAUSE_CFG_dft           0x0004b064

typedef volatile union {
  struct {
    ca_uint32_t thre_lo              : 10 ; /* bits 9:0 */
    ca_uint32_t thre_hi              : 10 ; /* bits 19:10 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_XGE6_RXPAUSE_CFG_t;


#define NI_HV_GLB_XGE7_RXFIFO_THRESHOLD          0xf4304034
#define NI_HV_GLB_XGE7_RXFIFO_THRESHOLD_dft      0x00264100

typedef volatile union {
  struct {
    ca_uint32_t free_buf_thre_lo     : 10 ; /* bits 9:0 */
    ca_uint32_t free_buf_thre_hi     : 10 ; /* bits 19:10 */
    ca_uint32_t xge7_12k_fifo_full_thre : 10 ; /* bits 29:20 */
    ca_uint32_t rsrvd1               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_XGE7_RXFIFO_THRESHOLD_t;


#define NI_HV_GLB_XGE6_MAC_CFG1                  0xf4304038
#define NI_HV_GLB_XGE6_MAC_CFG1_STRIDE           48
#define NI_HV_GLB_XGE6_MAC_CFG1_COUNT            2
#define NI_HV_GLB_XGE6_MAC_CFG1_dft              0x00000200

typedef volatile union {
  struct {
    ca_uint32_t mac1                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_XGE6_MAC_CFG1_t;


#define NI_HV_GLB_XGE6_MAC_CFG0                  0xf430403c
#define NI_HV_GLB_XGE6_MAC_CFG0_STRIDE           48
#define NI_HV_GLB_XGE6_MAC_CFG0_COUNT            2
#define NI_HV_GLB_XGE6_MAC_CFG0_dft              0x00000002

typedef volatile union {
  struct {
    ca_uint32_t mac0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_XGE6_MAC_CFG0_t;


#define NI_HV_GLB_XGE6_FLOW_CONTROL_CFG          0xf4304040
#define NI_HV_GLB_XGE6_FLOW_CONTROL_CFG_STRIDE   48
#define NI_HV_GLB_XGE6_FLOW_CONTROL_CFG_COUNT    2
#define NI_HV_GLB_XGE6_FLOW_CONTROL_CFG_dft      0xc4ff011c

typedef volatile union {
  struct {
    ca_uint32_t qbb_tx_en            :  1 ; /* bits 0:0 */
    ca_uint32_t qbb_rx_en            :  1 ; /* bits 1:1 */
    ca_uint32_t pau_tx_en            :  1 ; /* bits 2:2 */
    ca_uint32_t pau_rx_en            :  1 ; /* bits 3:3 */
    ca_uint32_t adjust_pause_cnt     : 12 ; /* bits 15:4 */
    ca_uint32_t qbb_qen              :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t tx_sw_pause_en       :  1 ; /* bits 25:25 */
    ca_uint32_t rx_drp_pau_en        :  1 ; /* bits 26:26 */
    ca_uint32_t tx_sw_pausereq       :  1 ; /* bits 27:27 */
    ca_uint32_t internal_txstop_sel  :  1 ; /* bits 28:28 */
    ca_uint32_t tx_remheader_dis     :  1 ; /* bits 29:29 */
    ca_uint32_t rx_pausereq_sel      :  1 ; /* bits 30:30 */
    ca_uint32_t te_pausereq_sel      :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_XGE6_FLOW_CONTROL_CFG_t;


#define NI_HV_GLB_XGE6_TX_REPEAT_CNT             0xf4304044
#define NI_HV_GLB_XGE6_TX_REPEAT_CNT_STRIDE      48
#define NI_HV_GLB_XGE6_TX_REPEAT_CNT_COUNT       2
#define NI_HV_GLB_XGE6_TX_REPEAT_CNT_dft         0x00008000

typedef volatile union {
  struct {
    ca_uint32_t repeat_cnt           : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_XGE6_TX_REPEAT_CNT_t;


#define NI_HV_GLB_XGE6_TX_QUANTA0                0xf4304048
#define NI_HV_GLB_XGE6_TX_QUANTA0_STRIDE         48
#define NI_HV_GLB_XGE6_TX_QUANTA0_COUNT          2
#define NI_HV_GLB_XGE6_TX_QUANTA0_dft            0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t pause_quanta0        : 16 ; /* bits 15:0 */
    ca_uint32_t pause_quanta1        : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_XGE6_TX_QUANTA0_t;


#define NI_HV_GLB_XGE6_TX_QUANTA1                0xf430404c
#define NI_HV_GLB_XGE6_TX_QUANTA1_STRIDE         48
#define NI_HV_GLB_XGE6_TX_QUANTA1_COUNT          2
#define NI_HV_GLB_XGE6_TX_QUANTA1_dft            0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t pause_quanta2        : 16 ; /* bits 15:0 */
    ca_uint32_t pause_quanta3        : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_XGE6_TX_QUANTA1_t;


#define NI_HV_GLB_XGE6_TX_QUANTA2                0xf4304050
#define NI_HV_GLB_XGE6_TX_QUANTA2_STRIDE         48
#define NI_HV_GLB_XGE6_TX_QUANTA2_COUNT          2
#define NI_HV_GLB_XGE6_TX_QUANTA2_dft            0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t pause_quanta4        : 16 ; /* bits 15:0 */
    ca_uint32_t pause_quanta5        : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_XGE6_TX_QUANTA2_t;


#define NI_HV_GLB_XGE6_TX_QUANTA3                0xf4304054
#define NI_HV_GLB_XGE6_TX_QUANTA3_STRIDE         48
#define NI_HV_GLB_XGE6_TX_QUANTA3_COUNT          2
#define NI_HV_GLB_XGE6_TX_QUANTA3_dft            0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t pause_quanta6        : 16 ; /* bits 15:0 */
    ca_uint32_t pause_quanta7        : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_XGE6_TX_QUANTA3_t;


#define NI_HV_GLB_XGE6_QBB_WAIT_TIME             0xf4304058
#define NI_HV_GLB_XGE6_QBB_WAIT_TIME_STRIDE      48
#define NI_HV_GLB_XGE6_QBB_WAIT_TIME_COUNT       2
#define NI_HV_GLB_XGE6_QBB_WAIT_TIME_dft         0x00000005

typedef volatile union {
  struct {
    ca_uint32_t wait_cnt             : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_XGE6_QBB_WAIT_TIME_t;


#define NI_HV_GLB_XGE6_RX_FLOW_CTRL_PKT_CNT      0xf430405c
#define NI_HV_GLB_XGE6_RX_FLOW_CTRL_PKT_CNT_STRIDE 48
#define NI_HV_GLB_XGE6_RX_FLOW_CTRL_PKT_CNT_COUNT 2
#define NI_HV_GLB_XGE6_RX_FLOW_CTRL_PKT_CNT_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pause_pkt_cnt        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_XGE6_RX_FLOW_CTRL_PKT_CNT_t;


#define NI_HV_GLB_XGE6_RX_FAKE_PAUS_PKT_CNT      0xf4304060
#define NI_HV_GLB_XGE6_RX_FAKE_PAUS_PKT_CNT_STRIDE 48
#define NI_HV_GLB_XGE6_RX_FAKE_PAUS_PKT_CNT_COUNT 2
#define NI_HV_GLB_XGE6_RX_FAKE_PAUS_PKT_CNT_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t err_paus_pkt_cnt     : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_XGE6_RX_FAKE_PAUS_PKT_CNT_t;


#define NI_HV_GLB_XGE6_TX_FLOW_CTRL_PKT_CNT      0xf4304064
#define NI_HV_GLB_XGE6_TX_FLOW_CTRL_PKT_CNT_STRIDE 48
#define NI_HV_GLB_XGE6_TX_FLOW_CTRL_PKT_CNT_COUNT 2
#define NI_HV_GLB_XGE6_TX_FLOW_CTRL_PKT_CNT_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pause_pkt_cnt        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_XGE6_TX_FLOW_CTRL_PKT_CNT_t;

                                                
#define NI_HV_GLB_RXMUX_INTPT_CALENDAR_CFG1      0xf4304098
#define NI_HV_GLB_RXMUX_INTPT_CALENDAR_CFG1_dft  0xe4e4e4e4

typedef volatile union {
  struct {
    ca_uint32_t int_cal1             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RXMUX_INTPT_CALENDAR_CFG1_t;


#define NI_HV_GLB_RXMUX_INTPT_CALENDAR_CFG0      0xf430409c
#define NI_HV_GLB_RXMUX_INTPT_CALENDAR_CFG0_dft  0xe4e4e4e4

typedef volatile union {
  struct {
    ca_uint32_t int_cal0             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RXMUX_INTPT_CALENDAR_CFG0_t;


#define NI_HV_GLB_RXMUX_CTRL_CFG                 0xf43040a0
#define NI_HV_GLB_RXMUX_CTRL_CFG_dft             0x100a09ba

typedef volatile union {
  struct {
    ca_uint32_t l3fe_pspid           :  4 ; /* bits 3:0 */
    ca_uint32_t mce_pspid            :  4 ; /* bits 7:4 */
    ca_uint32_t dma_pspid            :  4 ; /* bits 11:8 */
    ca_uint32_t err_pkt_ok           :  1 ; /* bits 12:12 */
    ca_uint32_t calendar_en          :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t next_sop_delay       : 12 ; /* bits 27:16 */
    ca_uint32_t dbg_sel              :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RXMUX_CTRL_CFG_t;


#define NI_HV_GLB_RXMUX_LAST_HDR_A2              0xf43040a4
#define NI_HV_GLB_RXMUX_LAST_HDR_A2_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hdra2                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RXMUX_LAST_HDR_A2_t;


#define NI_HV_GLB_RXMUX_LAST_HDR_A1              0xf43040a8
#define NI_HV_GLB_RXMUX_LAST_HDR_A1_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hdra1                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RXMUX_LAST_HDR_A1_t;


#define NI_HV_GLB_RXMUX_LAST_HDR_A0              0xf43040ac
#define NI_HV_GLB_RXMUX_LAST_HDR_A0_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hdra0                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RXMUX_LAST_HDR_A0_t;


#define NI_HV_GLB_RXMUX_PKTCNT                   0xf43040b0
#define NI_HV_GLB_RXMUX_PKTCNT_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dbg_pkt_cnt          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RXMUX_PKTCNT_t;


#define NI_HV_GLB_RXMUX_PORT0_FC_THRESHOLD_CFG   0xf43040b4
#define NI_HV_GLB_RXMUX_PORT0_FC_THRESHOLD_CFG_STRIDE 4
#define NI_HV_GLB_RXMUX_PORT0_FC_THRESHOLD_CFG_COUNT 12
#define NI_HV_GLB_RXMUX_PORT0_FC_THRESHOLD_CFG_dft 0x0000a014

typedef volatile union {
  struct {
    ca_uint32_t thre_lo              : 10 ; /* bits 9:0 */
    ca_uint32_t thre_hi              : 10 ; /* bits 19:10 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RXMUX_PORT0_FC_THRESHOLD_CFG_t;

                                            
#define NI_HV_GLB_RX_P11_SEG_BUF_TOP_BOTTOM_ADDR_CFG 0xf43040e4
#define NI_HV_GLB_RX_P11_SEG_BUF_TOP_BOTTOM_ADDR_CFG_dft 0x000fffc0

typedef volatile union {
  struct {
    ca_uint32_t base_ptr             : 10 ; /* bits 9:0 */
    ca_uint32_t top_ptr              : 10 ; /* bits 19:10 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RX_P11_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t;


#define NI_HV_GLB_RX_P10_SEG_BUF_TOP_BOTTOM_ADDR_CFG 0xf43040e8
#define NI_HV_GLB_RX_P10_SEG_BUF_TOP_BOTTOM_ADDR_CFG_dft 0x000eff80

typedef volatile union {
  struct {
    ca_uint32_t base_ptr             : 10 ; /* bits 9:0 */
    ca_uint32_t top_ptr              : 10 ; /* bits 19:10 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RX_P10_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t;


#define NI_HV_GLB_RX_P9_SEG_BUF_TOP_BOTTOM_ADDR_CFG 0xf43040ec
#define NI_HV_GLB_RX_P9_SEG_BUF_TOP_BOTTOM_ADDR_CFG_dft 0x000dff40

typedef volatile union {
  struct {
    ca_uint32_t base_ptr             : 10 ; /* bits 9:0 */
    ca_uint32_t top_ptr              : 10 ; /* bits 19:10 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RX_P9_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t;


#define NI_HV_GLB_RX_P8_SEG_BUF_TOP_BOTTOM_ADDR_CFG 0xf43040f0
#define NI_HV_GLB_RX_P8_SEG_BUF_TOP_BOTTOM_ADDR_CFG_dft 0x000cff00

typedef volatile union {
  struct {
    ca_uint32_t base_ptr             : 10 ; /* bits 9:0 */
    ca_uint32_t top_ptr              : 10 ; /* bits 19:10 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RX_P8_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t;


#define NI_HV_GLB_RX_P7_SEG_BUF_TOP_BOTTOM_ADDR_CFG 0xf43040f4
#define NI_HV_GLB_RX_P7_SEG_BUF_TOP_BOTTOM_ADDR_CFG_dft 0x000bfe00

typedef volatile union {
  struct {
    ca_uint32_t base_ptr             : 10 ; /* bits 9:0 */
    ca_uint32_t top_ptr              : 10 ; /* bits 19:10 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RX_P7_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t;


#define NI_HV_GLB_RX_P6_SEG_BUF_TOP_BOTTOM_ADDR_CFG 0xf43040f8
#define NI_HV_GLB_RX_P6_SEG_BUF_TOP_BOTTOM_ADDR_CFG_dft 0x0007fd80

typedef volatile union {
  struct {
    ca_uint32_t base_ptr             : 10 ; /* bits 9:0 */
    ca_uint32_t top_ptr              : 10 ; /* bits 19:10 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RX_P6_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t;


#define NI_HV_GLB_RX_P5_SEG_BUF_TOP_BOTTOM_ADDR_CFG 0xf43040fc
#define NI_HV_GLB_RX_P5_SEG_BUF_TOP_BOTTOM_ADDR_CFG_dft 0x0005fd40

typedef volatile union {
  struct {
    ca_uint32_t base_ptr             : 10 ; /* bits 9:0 */
    ca_uint32_t top_ptr              : 10 ; /* bits 19:10 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RX_P5_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t;


#define NI_HV_GLB_RX_P4_SEG_BUF_TOP_BOTTOM_ADDR_CFG 0xf4304100
#define NI_HV_GLB_RX_P4_SEG_BUF_TOP_BOTTOM_ADDR_CFG_dft 0x0004fd00

typedef volatile union {
  struct {
    ca_uint32_t base_ptr             : 10 ; /* bits 9:0 */
    ca_uint32_t top_ptr              : 10 ; /* bits 19:10 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RX_P4_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t;


#define NI_HV_GLB_RX_P3_SEG_BUF_TOP_BOTTOM_ADDR_CFG 0xf4304104
#define NI_HV_GLB_RX_P3_SEG_BUF_TOP_BOTTOM_ADDR_CFG_dft 0x0003fcc0

typedef volatile union {
  struct {
    ca_uint32_t base_ptr             : 10 ; /* bits 9:0 */
    ca_uint32_t top_ptr              : 10 ; /* bits 19:10 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RX_P3_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t;


#define NI_HV_GLB_RX_P2_SEG_BUF_TOP_BOTTOM_ADDR_CFG 0xf4304108
#define NI_HV_GLB_RX_P2_SEG_BUF_TOP_BOTTOM_ADDR_CFG_dft 0x0002fc80

typedef volatile union {
  struct {
    ca_uint32_t base_ptr             : 10 ; /* bits 9:0 */
    ca_uint32_t top_ptr              : 10 ; /* bits 19:10 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RX_P2_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t;


#define NI_HV_GLB_RX_P1_SEG_BUF_TOP_BOTTOM_ADDR_CFG 0xf430410c
#define NI_HV_GLB_RX_P1_SEG_BUF_TOP_BOTTOM_ADDR_CFG_dft 0x0001fc40

typedef volatile union {
  struct {
    ca_uint32_t base_ptr             : 10 ; /* bits 9:0 */
    ca_uint32_t top_ptr              : 10 ; /* bits 19:10 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RX_P1_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t;


#define NI_HV_GLB_RX_P0_SEG_BUF_TOP_BOTTOM_ADDR_CFG 0xf4304110
#define NI_HV_GLB_RX_P0_SEG_BUF_TOP_BOTTOM_ADDR_CFG_dft 0x0000fc00

typedef volatile union {
  struct {
    ca_uint32_t base_ptr             : 10 ; /* bits 9:0 */
    ca_uint32_t top_ptr              : 10 ; /* bits 19:10 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RX_P0_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t;


#define NI_HV_GLB_RX_SEG_BUFSIZE_UPDATE          0xf4304114
#define NI_HV_GLB_RX_SEG_BUFSIZE_UPDATE_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t load                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RX_SEG_BUFSIZE_UPDATE_t;


#define NI_HV_GLB_RX_SEG_VLAN_TAG_INSERT_CFG     0xf4304118
#define NI_HV_GLB_RX_SEG_VLAN_TAG_INSERT_CFG_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t p0_vlan_tag_num      :  2 ; /* bits 1:0 */
    ca_uint32_t p1_vlan_tag_num      :  2 ; /* bits 3:2 */
    ca_uint32_t p2_vlan_tag_num      :  2 ; /* bits 5:4 */
    ca_uint32_t p3_vlan_tag_num      :  2 ; /* bits 7:6 */
    ca_uint32_t p4_vlan_tag_num      :  2 ; /* bits 9:8 */
    ca_uint32_t p5_vlan_tag_num      :  2 ; /* bits 11:10 */
    ca_uint32_t p6_vlan_tag_num      :  2 ; /* bits 13:12 */
    ca_uint32_t p7_vlan_tag_num      :  2 ; /* bits 15:14 */
    ca_uint32_t p8_vlan_tag_num      :  2 ; /* bits 17:16 */
    ca_uint32_t p9_vlan_tag_num      :  2 ; /* bits 19:18 */
    ca_uint32_t p10_vlan_tag_num     :  2 ; /* bits 21:20 */
    ca_uint32_t p11_vlan_tag_num     :  2 ; /* bits 23:22 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RX_SEG_VLAN_TAG_INSERT_CFG_t;


#define NI_HV_GLB_RXMUX_HDR_BUF_STATUS           0xf430411c
#define NI_HV_GLB_RXMUX_HDR_BUF_STATUS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hdr_buf_empty        : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RXMUX_HDR_BUF_STATUS_t;


#define NI_HV_GLB_RXMUX_DATA_BUF_STATUS          0xf4304120
#define NI_HV_GLB_RXMUX_DATA_BUF_STATUS_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t seg_buf_empty        : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t seg_buf_full         : 12 ; /* bits 27:16 */
    ca_uint32_t l2fe_ni_rdy          :  1 ; /* bits 28:28 */
    ca_uint32_t rsrvd2               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RXMUX_DATA_BUF_STATUS_t;


#define NI_HV_GLB_RXMUX_DBG_CFG                  0xf4304124
#define NI_HV_GLB_RXMUX_DBG_CFG_dft              0x00000021

typedef volatile union {
  struct {
    ca_uint32_t cnt0_sel             :  4 ; /* bits 3:0 */
    ca_uint32_t cnt1_sel             :  4 ; /* bits 7:4 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RXMUX_DBG_CFG_t;


#define NI_HV_GLB_RXMUX_OUT_CNT0                 0xf4304128
#define NI_HV_GLB_RXMUX_OUT_CNT0_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RXMUX_OUT_CNT0_t;


#define NI_HV_GLB_RXMUX_OUT_CNT1                 0xf430412c
#define NI_HV_GLB_RXMUX_OUT_CNT1_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RXMUX_OUT_CNT1_t;


#define NI_HV_GLB_RXMUX_OUT_DRPCNT0              0xf4304130
#define NI_HV_GLB_RXMUX_OUT_DRPCNT0_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RXMUX_OUT_DRPCNT0_t;


#define NI_HV_GLB_RXMUX_OUT_DRPCNT1              0xf4304134
#define NI_HV_GLB_RXMUX_OUT_DRPCNT1_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RXMUX_OUT_DRPCNT1_t;


#define NI_HV_GLB_NIRX_XRAM_STS                  0xf4304138
#define NI_HV_GLB_NIRX_XRAM_STS_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sts                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_NIRX_XRAM_STS_t;


#define NI_HV_GLB_NIRX_L3QM_STS                  0xf430413c
#define NI_HV_GLB_NIRX_L3QM_STS_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sts                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_NIRX_L3QM_STS_t;


#define NI_HV_GLB_NIRX_L3FE_STS                  0xf4304140
#define NI_HV_GLB_NIRX_L3FE_STS_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sts                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_NIRX_L3FE_STS_t;


#define NI_HV_GLB_P0_RX_DROPCNT                  0xf4304144
#define NI_HV_GLB_P0_RX_DROPCNT_STRIDE           4
#define NI_HV_GLB_P0_RX_DROPCNT_COUNT            8
#define NI_HV_GLB_P0_RX_DROPCNT_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t CNT                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_P0_RX_DROPCNT_t;

                            
#define NI_HV_GLB_P0_TX_SHARE_FIFO_BASE_CFG      0xf4304164
#define NI_HV_GLB_P0_TX_SHARE_FIFO_BASE_CFG_dft  0x007f0000

typedef volatile union {
  struct {
    ca_uint32_t base_addr            : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               :  6 ;
    ca_uint32_t max                  : 10 ; /* bits 25:16 */
    ca_uint32_t rsrvd2               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_P0_TX_SHARE_FIFO_BASE_CFG_t;


#define NI_HV_GLB_P1_TX_SHARE_FIFO_BASE_CFG      0xf4304168
#define NI_HV_GLB_P1_TX_SHARE_FIFO_BASE_CFG_dft  0x007f0080

typedef volatile union {
  struct {
    ca_uint32_t base_addr            : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               :  6 ;
    ca_uint32_t max                  : 10 ; /* bits 25:16 */
    ca_uint32_t rsrvd2               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_P1_TX_SHARE_FIFO_BASE_CFG_t;


#define NI_HV_GLB_P2_TX_SHARE_FIFO_BASE_CFG      0xf430416c
#define NI_HV_GLB_P2_TX_SHARE_FIFO_BASE_CFG_dft  0x007f0100

typedef volatile union {
  struct {
    ca_uint32_t base_addr            : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               :  6 ;
    ca_uint32_t max                  : 10 ; /* bits 25:16 */
    ca_uint32_t rsrvd2               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_P2_TX_SHARE_FIFO_BASE_CFG_t;


#define NI_HV_GLB_P3_TX_SHARE_FIFO_BASE_CFG      0xf4304170
#define NI_HV_GLB_P3_TX_SHARE_FIFO_BASE_CFG_dft  0x007f0180

typedef volatile union {
  struct {
    ca_uint32_t base_addr            : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               :  6 ;
    ca_uint32_t max                  : 10 ; /* bits 25:16 */
    ca_uint32_t rsrvd2               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_P3_TX_SHARE_FIFO_BASE_CFG_t;


#define NI_HV_GLB_P4_TX_SHARE_FIFO_BASE_CFG      0xf4304174
#define NI_HV_GLB_P4_TX_SHARE_FIFO_BASE_CFG_dft  0x007f0200

typedef volatile union {
  struct {
    ca_uint32_t base_addr            : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               :  6 ;
    ca_uint32_t max                  : 10 ; /* bits 25:16 */
    ca_uint32_t rsrvd2               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_P4_TX_SHARE_FIFO_BASE_CFG_t;


#define NI_HV_GLB_MCE_TX_SHARE_FIFO_BASE_CFG     0xf4304178
#define NI_HV_GLB_MCE_TX_SHARE_FIFO_BASE_CFG_dft 0x007f0280

typedef volatile union {
  struct {
    ca_uint32_t base_addr            : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               :  6 ;
    ca_uint32_t max                  : 10 ; /* bits 25:16 */
    ca_uint32_t rsrvd2               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_MCE_TX_SHARE_FIFO_BASE_CFG_t;


#define NI_HV_GLB_PG_DA_CFG0                     0xf430417c
#define NI_HV_GLB_PG_DA_CFG0_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac_addr0            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_PG_DA_CFG0_t;


#define NI_HV_GLB_PG_DA_CFG1                     0xf4304180
#define NI_HV_GLB_PG_DA_CFG1_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac_addr1            :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_PG_DA_CFG1_t;


#define NI_HV_GLB_PG_SA_CFG0                     0xf4304184
#define NI_HV_GLB_PG_SA_CFG0_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac_addr0            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_PG_SA_CFG0_t;


#define NI_HV_GLB_PG_SA_CFG1                     0xf4304188
#define NI_HV_GLB_PG_SA_CFG1_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac_addr1            :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_PG_SA_CFG1_t;


#define NI_HV_GLB_PG_CFG0                        0xf430418c
#define NI_HV_GLB_PG_CFG0_dft                    0x00648064

typedef volatile union {
  struct {
    ca_uint32_t pg_len               : 11 ; /* bits 10:0 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t pg_len_data          :  1 ; /* bits 15:15 */
    ca_uint32_t pg_frm_cnt           : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_PG_CFG0_t;


#define NI_HV_GLB_PG_CFG1                        0xf4304190
#define NI_HV_GLB_PG_CFG1_dft                    0x81008100

typedef volatile union {
  struct {
    ca_uint32_t pg_vlan1_tpid        : 16 ; /* bits 15:0 */
    ca_uint32_t pg_vlan2_tpid        : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_PG_CFG1_t;


#define NI_HV_GLB_PG_FXPT_CFG                    0xf4304194
#define NI_HV_GLB_PG_FXPT_CFG_dft                0xaaaa5555

typedef volatile union {
  struct {
    ca_uint32_t pg_fxpat             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_PG_FXPT_CFG_t;


#define NI_HV_GLB_PC_DA1                         0xf4304198
#define NI_HV_GLB_PC_DA1_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pc_da4               :  8 ; /* bits 7:0 */
    ca_uint32_t pc_da3               :  8 ; /* bits 15:8 */
    ca_uint32_t pc_da2               :  8 ; /* bits 23:16 */
    ca_uint32_t pc_da1               :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_PC_DA1_t;


#define NI_HV_GLB_PC_DA2                         0xf430419c
#define NI_HV_GLB_PC_DA2_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pc_da5               :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_PC_DA2_t;


#define NI_HV_GLB_PC_SA1                         0xf43041a0
#define NI_HV_GLB_PC_SA1_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pc_sa4               :  8 ; /* bits 7:0 */
    ca_uint32_t pc_sa3               :  8 ; /* bits 15:8 */
    ca_uint32_t pc_sa2               :  8 ; /* bits 23:16 */
    ca_uint32_t pc_sa1               :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_PC_SA1_t;


#define NI_HV_GLB_PC_SA2                         0xf43041a4
#define NI_HV_GLB_PC_SA2_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pc_sa5               :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_PC_SA2_t;


#define NI_HV_GLB_PC_CFG0                        0xf43041a8
#define NI_HV_GLB_PC_CFG0_dft                    0x00000064

typedef volatile union {
  struct {
    ca_uint32_t pc_len               : 11 ; /* bits 10:0 */
    ca_uint32_t rsrvd1               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_PC_CFG0_t;


#define NI_HV_GLB_PC_CFG1                        0xf43041ac
#define NI_HV_GLB_PC_CFG1_dft                    0x81008100

typedef volatile union {
  struct {
    ca_uint32_t pc_vlan1_tpid        : 16 ; /* bits 15:0 */
    ca_uint32_t pc_vlan2_tpid        : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_PC_CFG1_t;


#define NI_HV_GLB_PC_FXPT                        0xf43041b0
#define NI_HV_GLB_PC_FXPT_dft                    0xaaaa5555

typedef volatile union {
  struct {
    ca_uint32_t pc_fxpat             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_PC_FXPT_t;


#define NI_HV_GLB_RM_CFG                         0xf43041b4
#define NI_HV_GLB_RM_CFG_dft                     0x2100000a

typedef volatile union {
  struct {
    ca_uint32_t rm_en                :  1 ; /* bits 0:0 */
    ca_uint32_t rm_pid               :  4 ; /* bits 4:1 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t rm_cntpkts           :  1 ; /* bits 8:8 */
    ca_uint32_t rm_clrcnt            :  1 ; /* bits 9:9 */
    ca_uint32_t rm_clrtb             :  1 ; /* bits 10:10 */
    ca_uint32_t debug_mode           :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd2               : 12 ;
    ca_uint32_t rm_tbinc             :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RM_CFG_t;


#define NI_HV_GLB_RM_TBMAX                       0xf43041b8
#define NI_HV_GLB_RM_TBMAX_dft                   0x00ffffff

typedef volatile union {
  struct {
    ca_uint32_t rm_tbmax             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RM_TBMAX_t;


#define NI_HV_GLB_RM_CNTR                        0xf43041bc
#define NI_HV_GLB_RM_CNTR_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rm_cnt               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RM_CNTR_t;


#define NI_HV_GLB_RM_LASTCNTR                    0xf43041c0
#define NI_HV_GLB_RM_LASTCNTR_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rm_lastcnt           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RM_LASTCNTR_t;


#define NI_HV_GLB_RXMIB_ACCESS                   0xf43041c4
#define NI_HV_GLB_RXMIB_ACCESS_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t counter_id           :  5 ; /* bits 4:0 */
    ca_uint32_t port_id              :  3 ; /* bits 7:5 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t debug_mode           :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd2               : 11 ;
    ca_uint32_t op_code              :  2 ; /* bits 29:28 */
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RXMIB_ACCESS_t;

#define     counter_id_RxUCPktCnt                         0x0
#define     counter_id_RxMCFrmCnt                         0x1
#define     counter_id_RxBCFrmCnt                         0x2
#define     counter_id_RxOAMFrmCnt                        0x3
#define     counter_id_RxJumboFrmCnt                      0x4
#define     counter_id_RxPauseFrmCnt                      0x5
#define     counter_id_RxPFCFrmCnt                        0x6
#define     counter_id_RxUnKnownOCFrmCnt                  0x7
#define     counter_id_RxCrcErrFrmCnt                     0x8
#define     counter_id_RxUndersizeFrmCnt                  0x9
#define     counter_id_RxRuntFrmCnt                       0xa
#define     counter_id_RxOvSizeFrmCnt                     0xb
#define     counter_id_RxJabberFrmCnt                     0xc
#define     counter_id_RxInvalidFrmCnt                    0xd
#define     counter_id_RxInvalidFlowFrmCnt                0xe
#define     counter_id_RxStatsFrm64Oct                    0xf
#define     counter_id_RxStatsFrm65to127Oct               0x10
#define     counter_id_RxStatsFrm128to255Oct              0x11
#define     counter_id_RxStatsFrm256to511Oct              0x12
#define     counter_id_RxStatsFrm512to1023Oct             0x13
#define     counter_id_RxStatsFrm1024to1518Oct            0x14
#define     counter_id_RxStatsFrm1519to2100Oct            0x15
#define     counter_id_RxStatsFrm2101to9200Oct            0x16
#define     counter_id_RxStatsFrm9201toMaxOct             0x17
#define     counter_id_RxByteCount_Lo                     0x18
#define     counter_id_RxByteCount_Hi                     0x19

#define NI_HV_GLB_RXMIB_DATA1                    0xf43041c8
#define NI_HV_GLB_RXMIB_DATA1_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt_val_hi           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RXMIB_DATA1_t;


#define NI_HV_GLB_RXMIB_DATA0                    0xf43041cc
#define NI_HV_GLB_RXMIB_DATA0_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt_val_lo           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RXMIB_DATA0_t;


#define NI_HV_GLB_TXMIB_ACCESS                   0xf43041d0
#define NI_HV_GLB_TXMIB_ACCESS_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t counter_id           :  5 ; /* bits 4:0 */
    ca_uint32_t port_id              :  3 ; /* bits 7:5 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t debug_mode           :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd2               : 11 ;
    ca_uint32_t op_code              :  2 ; /* bits 29:28 */
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_TXMIB_ACCESS_t;

#define     counter_id_TxUCPktCnt                         0x0
#define     counter_id_TxMCFrmCnt                         0x1
#define     counter_id_TxBCFrmCnt                         0x2
#define     counter_id_TxOAMFrmCnt                        0x3
#define     counter_id_TxJumboFrmCnt                      0x4
#define     counter_id_TxPauseFrmCnt                      0x5
#define     counter_id_TxPFCFrmCnt                        0x6
#define     counter_id_TxCrcErrFrmCnt                     0x7
#define     counter_id_TxOvSizeFrmCnt                     0x8
#define     counter_id_TxSingleColFrm                     0x9
#define     counter_id_TxMultiColFrm                      0xa
#define     counter_id_TxLateColFrm                       0xb
#define     counter_id_TxExessColFrm                      0xd
#define     counter_id_TxStatsFrm64Oct                    0xe
#define     counter_id_TxStatsFrm65to127Oct               0xf
#define     counter_id_TxStatsFrm128to255Oct              0x10
#define     counter_id_TxStatsFrm256to511Oct              0x11
#define     counter_id_TxStatsFrm512to1023Oct             0x12
#define     counter_id_TxStatsFrm1024to1518Oct            0x13
#define     counter_id_TxStatsFrm1519to2100Oct            0x14
#define     counter_id_TxStatsFrm2101to9200Oct            0x15
#define     counter_id_TxStatsFrm9201toMaxOct             0x16
#define     counter_id_TxByteCount_Lo                     0x18
#define     counter_id_TxByteCount_Hi                     0x19

#define NI_HV_GLB_TXMIB_DATA1                    0xf43041d4
#define NI_HV_GLB_TXMIB_DATA1_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt_val_hi           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_TXMIB_DATA1_t;


#define NI_HV_GLB_TXMIB_DATA0                    0xf43041d8
#define NI_HV_GLB_TXMIB_DATA0_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt_val_lo           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_TXMIB_DATA0_t;


#define NI_HV_GLB_INTERNAL_PORT_ID_CFG           0xf43041dc
#define NI_HV_GLB_INTERNAL_PORT_ID_CFG_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t l3qmrx_demux_sel     :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 14 ;
    ca_uint32_t wan_rxsel            :  2 ; /* bits 23:22 */
    ca_uint32_t dma_to_l3fe          :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_INTERNAL_PORT_ID_CFG_t;


#define NI_HV_GLB_INTERNAL_PORT_ID_CFG2          0xf43041e0
#define NI_HV_GLB_INTERNAL_PORT_ID_CFG2_dft      0x0024009b

typedef volatile union {
  struct {
    ca_uint32_t mce_lspid            :  6 ; /* bits 5:0 */
    ca_uint32_t mce_dpq              :  1 ; /* bits 6:6 */
    ca_uint32_t mce_fe_bypass        :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd1               : 10 ;
    ca_uint32_t rx_cpu               :  6 ; /* bits 23:18 */
    ca_uint32_t rsrvd2               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_INTERNAL_PORT_ID_CFG2_t;


#define NI_HV_GLB_RX_PORT_ID_CFG                 0xf43041e4
#define NI_HV_GLB_RX_PORT_ID_CFG_dft             0x040c2040

typedef volatile union {
  struct {
    ca_uint32_t port0_id             :  6 ; /* bits 5:0 */
    ca_uint32_t port1_id             :  6 ; /* bits 11:6 */
    ca_uint32_t port2_id             :  6 ; /* bits 17:12 */
    ca_uint32_t port3_id             :  6 ; /* bits 23:18 */
    ca_uint32_t port4_id             :  6 ; /* bits 29:24 */
    ca_uint32_t rsrvd1               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RX_PORT_ID_CFG_t;


#define NI_HV_GLB_RX_PORT_ID_CFG2                0xf43041e8
#define NI_HV_GLB_RX_PORT_ID_CFG2_dft            0x00007185

typedef volatile union {
  struct {
    ca_uint32_t port5_id             :  6 ; /* bits 5:0 */
    ca_uint32_t port6_id             :  6 ; /* bits 11:6 */
    ca_uint32_t port7_id             :  6 ; /* bits 17:12 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RX_PORT_ID_CFG2_t;


#define NI_HV_GLB_NIRX_L3FE_DEMUX_CFG3           0xf43041ec
#define NI_HV_GLB_NIRX_L3FE_DEMUX_CFG3_dft       0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t demux_id3            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_NIRX_L3FE_DEMUX_CFG3_t;


#define NI_HV_GLB_NIRX_L3FE_DEMUX_CFG2           0xf43041f0
#define NI_HV_GLB_NIRX_L3FE_DEMUX_CFG2_dft       0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t demux_id2            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_NIRX_L3FE_DEMUX_CFG2_t;


#define NI_HV_GLB_NIRX_L3FE_DEMUX_CFG1           0xf43041f4
#define NI_HV_GLB_NIRX_L3FE_DEMUX_CFG1_dft       0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t demux_id1            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_NIRX_L3FE_DEMUX_CFG1_t;


#define NI_HV_GLB_NIRX_L3FE_DEMUX_CFG0           0xf43041f8
#define NI_HV_GLB_NIRX_L3FE_DEMUX_CFG0_dft       0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t demux_id0            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_NIRX_L3FE_DEMUX_CFG0_t;


#define NI_HV_GLB_NIRX_L3FE_DPQ_DEMUX_CFG3       0xf43041fc
#define NI_HV_GLB_NIRX_L3FE_DPQ_DEMUX_CFG3_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t demux_id3            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_NIRX_L3FE_DPQ_DEMUX_CFG3_t;


#define NI_HV_GLB_NIRX_L3FE_DPQ_DEMUX_CFG2       0xf4304200
#define NI_HV_GLB_NIRX_L3FE_DPQ_DEMUX_CFG2_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t demux_id2            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_NIRX_L3FE_DPQ_DEMUX_CFG2_t;


#define NI_HV_GLB_NIRX_L3FE_DPQ_DEMUX_CFG1       0xf4304204
#define NI_HV_GLB_NIRX_L3FE_DPQ_DEMUX_CFG1_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t demux_id1            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_NIRX_L3FE_DPQ_DEMUX_CFG1_t;


#define NI_HV_GLB_NIRX_L3FE_DPQ_DEMUX_CFG0       0xf4304208
#define NI_HV_GLB_NIRX_L3FE_DPQ_DEMUX_CFG0_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t demux_id0            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_NIRX_L3FE_DPQ_DEMUX_CFG0_t;


#define NI_HV_GLB_NITX_MISC_CFG                  0xf430420c
#define NI_HV_GLB_NITX_MISC_CFG_dft              0x00078ffc

typedef volatile union {
  struct {
    ca_uint32_t xge6_hdrA_tx_en      :  1 ; /* bits 0:0 */
    ca_uint32_t xge7_hdrA_tx_en      :  1 ; /* bits 1:1 */
    ca_uint32_t xge6_tx_rd_thre_en   :  1 ; /* bits 2:2 */
    ca_uint32_t xge7_tx_rd_thre_en   :  1 ; /* bits 3:3 */
    ca_uint32_t xaui_tx_rd_thre_en   :  1 ; /* bits 4:4 */
    ca_uint32_t l3qm_tx_rd_thre_en0  :  1 ; /* bits 5:5 */
    ca_uint32_t l3qm_tx_rd_thre_en1  :  1 ; /* bits 6:6 */
    ca_uint32_t l3qm_tx_rd_thre_en3  :  1 ; /* bits 7:7 */
    ca_uint32_t l3fe_tx_rd_thre_en0  :  1 ; /* bits 8:8 */
    ca_uint32_t l3fe_tx_rd_thre_en1  :  1 ; /* bits 9:9 */
    ca_uint32_t l3fe_tx_rd_thre_en2  :  1 ; /* bits 10:10 */
    ca_uint32_t l3fe_tx_rd_thre_en3  :  1 ; /* bits 11:11 */
    ca_uint32_t xge6_link_fault_halt_tx_en :  1 ; /* bits 12:12 */
    ca_uint32_t xge7_link_fault_halt_tx_en :  1 ; /* bits 13:13 */
    ca_uint32_t time_base_cnt        :  6 ; /* bits 19:14 */
    ca_uint32_t xge6_tx_drain        :  1 ; /* bits 20:20 */
    ca_uint32_t xge7_tx_drain        :  1 ; /* bits 21:21 */
    ca_uint32_t xaui5_tx_drain       :  1 ; /* bits 22:22 */
    ca_uint32_t rsrvd1               :  9 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_NITX_MISC_CFG_t;


#define NI_HV_GLB_NIRX_MISC_CFG                  0xf4304210
#define NI_HV_GLB_NIRX_MISC_CFG_dft              0x00034000

typedef volatile union {
  struct {
    ca_uint32_t l3fe_to_l2fe_deepq_csr0 :  1 ; /* bits 0:0 */
    ca_uint32_t l3fe_to_l2fe_deepq_csr1 :  1 ; /* bits 1:1 */
    ca_uint32_t l3fe_to_l2fe_deepq_csr2 :  1 ; /* bits 2:2 */
    ca_uint32_t l3fe_to_l3qm_l4cs_err_en :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t l2te_ni_mc_rdy_en    :  1 ; /* bits 9:9 */
    ca_uint32_t l2te_ni_l3fewan_port_rdy_en :  1 ; /* bits 10:10 */
    ca_uint32_t l2te_ni_l3felan_port_rdy_en :  1 ; /* bits 11:11 */
    ca_uint32_t l2te_ni_txdma_l2fe_rdy_en :  1 ; /* bits 12:12 */
    ca_uint32_t l2te_ni_txdma_l3fe_rdy_en :  1 ; /* bits 13:13 */
    ca_uint32_t l2_wan_pfc_send_en   :  1 ; /* bits 14:14 */
    ca_uint32_t l3_wan_pfc_send_en   :  1 ; /* bits 15:15 */
    ca_uint32_t xge6_rx_errpkt_drp_en :  1 ; /* bits 16:16 */
    ca_uint32_t xge7_rx_errpkt_drp_en :  1 ; /* bits 17:17 */
    ca_uint32_t l3fe_to_wan_l4cs_err_en :  1 ; /* bits 18:18 */
    ca_uint32_t l3fe_to_l2fe_l4cs_err_en :  1 ; /* bits 19:19 */
    ca_uint32_t use_p0_as_wan_port_en :  1 ; /* bits 20:20 */
    ca_uint32_t rsrvd2               : 11 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_NIRX_MISC_CFG_t;


#define NI_HV_GLB_TX_PORT_ID_CFG                 0xf4304214
#define NI_HV_GLB_TX_PORT_ID_CFG_dft             0x76543210

typedef volatile union {
  struct {
    ca_uint32_t port0_id             :  4 ; /* bits 3:0 */
    ca_uint32_t port1_id             :  4 ; /* bits 7:4 */
    ca_uint32_t port2_id             :  4 ; /* bits 11:8 */
    ca_uint32_t port3_id             :  4 ; /* bits 15:12 */
    ca_uint32_t port4_id             :  4 ; /* bits 19:16 */
    ca_uint32_t port5_id             :  4 ; /* bits 23:20 */
    ca_uint32_t port6_id             :  4 ; /* bits 27:24 */
    ca_uint32_t port7_id             :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_TX_PORT_ID_CFG_t;


#define NI_HV_GLB_TX_INTERNAL_PORT_ID_CFG        0xf4304218
#define NI_HV_GLB_TX_INTERNAL_PORT_ID_CFG_dft    0x00cbda98

typedef volatile union {
  struct {
    ca_uint32_t l3qm_tx_dpid0        :  4 ; /* bits 3:0 */
    ca_uint32_t l3qm_tx_dpid1        :  4 ; /* bits 7:4 */
    ca_uint32_t l3fe_tx_dpid0        :  4 ; /* bits 11:8 */
    ca_uint32_t l3fe_tx_dpid1        :  4 ; /* bits 15:12 */
    ca_uint32_t mce_tx_dpid          :  4 ; /* bits 19:16 */
    ca_uint32_t oam_tx_dpid          :  4 ; /* bits 23:20 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_TX_INTERNAL_PORT_ID_CFG_t;


#define NI_HV_GLB_TX_INTERNAL_PORT_ID_CFG2       0xf430421c
#define NI_HV_GLB_TX_INTERNAL_PORT_ID_CFG2_dft   0x7000da98

typedef volatile union {
  struct {
    ca_uint32_t l3qm_tx_spid0        :  4 ; /* bits 3:0 */
    ca_uint32_t l3qm_tx_spid1        :  4 ; /* bits 7:4 */
    ca_uint32_t l3fe_tx_spid0        :  4 ; /* bits 11:8 */
    ca_uint32_t l3fe_tx_spid1        :  4 ; /* bits 15:12 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t l3fe_tx_spid2        :  4 ; /* bits 27:24 */
    ca_uint32_t l3fe_tx_spid3        :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_TX_INTERNAL_PORT_ID_CFG2_t;


#define NI_HV_GLB_NITX_CRCE_CNT                  0xf4304220
#define NI_HV_GLB_NITX_CRCE_CNT_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t crce_cnt             : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_NITX_CRCE_CNT_t;


#define NI_HV_GLB_NITX_P5_DRAINCNT               0xf4304224
#define NI_HV_GLB_NITX_P5_DRAINCNT_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t drain_cnt            : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_NITX_P5_DRAINCNT_t;


#define NI_HV_GLB_NITX_P6_DRAINCNT               0xf4304228
#define NI_HV_GLB_NITX_P6_DRAINCNT_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t drain_cnt            : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_NITX_P6_DRAINCNT_t;


#define NI_HV_GLB_NITX_P7_DRAINCNT               0xf430422c
#define NI_HV_GLB_NITX_P7_DRAINCNT_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t drain_cnt            : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_NITX_P7_DRAINCNT_t;


#define NI_HV_GLB_NITX_OAMERR_CNT                0xf4304230
#define NI_HV_GLB_NITX_OAMERR_CNT_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t oame_cnt             : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_NITX_OAMERR_CNT_t;


#define NI_HV_GLB_TXFIFO_READ_THRESHOLD          0xf4304234
#define NI_HV_GLB_TXFIFO_READ_THRESHOLD_dft      0x64503c28

typedef volatile union {
  struct {
    ca_uint32_t rxaui_txfifo_lo      :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t rxaui_txfifo_hi      :  7 ; /* bits 14:8 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t xge6_txfifo_lo       :  7 ; /* bits 22:16 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t xge6_txfifo_hi       :  7 ; /* bits 30:24 */
    ca_uint32_t rsrvd4               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_TXFIFO_READ_THRESHOLD_t;


#define NI_HV_GLB_TXFIFO_THRESHOLD_XGE7_CFG1     0xf4304238
#define NI_HV_GLB_TXFIFO_THRESHOLD_XGE7_CFG1_dft 0x780c7864

typedef volatile union {
  struct {
    ca_uint32_t from_l3fe_txfifo_lo  :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t from_l3fe_txfifo_hi  :  7 ; /* bits 14:8 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t from_l3qm_txfifo_lo  :  7 ; /* bits 22:16 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t from_l3qm_txfifo_hi  :  7 ; /* bits 30:24 */
    ca_uint32_t rsrvd4               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_TXFIFO_THRESHOLD_XGE7_CFG1_t;


#define NI_HV_GLB_TXFIFO_THRESHOLD_XGE7_CFG2     0xf430423c
#define NI_HV_GLB_TXFIFO_THRESHOLD_XGE7_CFG2_dft 0x78a3e8c8

typedef volatile union {
  struct {
    ca_uint32_t rd_thre_txfifo_lo    :  9 ; /* bits 8:0 */
    ca_uint32_t rd_thre_txfifo_hi    :  9 ; /* bits 17:9 */
    ca_uint32_t from_tm_txfifo_lo    :  7 ; /* bits 24:18 */
    ca_uint32_t from_tm_txfifo_hi    :  7 ; /* bits 31:25 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_TXFIFO_THRESHOLD_XGE7_CFG2_t;


#define NI_HV_GLB_TXFIFO_THRESHOLD_L3QM_CFG1     0xf4304240
#define NI_HV_GLB_TXFIFO_THRESHOLD_L3QM_CFG1_dft 0x51505150

typedef volatile union {
  struct {
    ca_uint32_t from_tm9_txfifo_lo   :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t from_tm9_txfifo_hi   :  7 ; /* bits 14:8 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t from_tm8_txfifo_lo   :  7 ; /* bits 22:16 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t from_tm8_txfifo_hi   :  7 ; /* bits 30:24 */
    ca_uint32_t rsrvd4               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_TXFIFO_THRESHOLD_L3QM_CFG1_t;


#define NI_HV_GLB_TXFIFO_THRESHOLD_L3QM_CFG2     0xf4304244
#define NI_HV_GLB_TXFIFO_THRESHOLD_L3QM_CFG2_dft 0x00005150

typedef volatile union {
  struct {
    ca_uint32_t from_l3fe_txfifo_lo  :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t from_l3fe_txfifo_hi  :  7 ; /* bits 14:8 */
    ca_uint32_t rsrvd2               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_TXFIFO_THRESHOLD_L3QM_CFG2_t;


#define NI_HV_GLB_TXFIFO_THRESHOLD_L3FE_CFG1     0xf4304248
#define NI_HV_GLB_TXFIFO_THRESHOLD_L3FE_CFG1_dft 0xaa6c6b6a

typedef volatile union {
  struct {
    ca_uint32_t from_wan_txfifo_lo   :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t from_wan_txfifo_hi   :  7 ; /* bits 14:8 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t from_tm_txfifo_lo    :  8 ; /* bits 23:16 */
    ca_uint32_t from_tm_txfifo_hi    :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_TXFIFO_THRESHOLD_L3FE_CFG1_t;


#define NI_HV_GLB_TXFIFO_THRESHOLD_L3FE_CFG2     0xf430424c
#define NI_HV_GLB_TXFIFO_THRESHOLD_L3FE_CFG2_dft 0x0400f06e

typedef volatile union {
  struct {
    ca_uint32_t from_dma_txfifo_lo   :  8 ; /* bits 7:0 */
    ca_uint32_t from_dma_txfifo_hi   :  8 ; /* bits 15:8 */
    ca_uint32_t tm2_shared_fifo_lo   :  6 ; /* bits 21:16 */
    ca_uint32_t tm2_shared_fifo_hi   :  6 ; /* bits 27:22 */
    ca_uint32_t rsrvd1               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_TXFIFO_THRESHOLD_L3FE_CFG2_t;


#define NI_HV_GLB_TXFIFO_THRESHOLD_MISC_CFG      0xf4304250
#define NI_HV_GLB_TXFIFO_THRESHOLD_MISC_CFG_dft  0x3c280000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 16 ;
    ca_uint32_t oam_from_tm_txfifo_lo :  7 ; /* bits 22:16 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t oam_from_tm_txfifo_hi :  7 ; /* bits 30:24 */
    ca_uint32_t rsrvd3               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_TXFIFO_THRESHOLD_MISC_CFG_t;


#define NI_HV_GLB_TXFIFO_THRESHOLD_MISC_CFG2     0xf4304254
#define NI_HV_GLB_TXFIFO_THRESHOLD_MISC_CFG2_dft 0x50285028

typedef volatile union {
  struct {
    ca_uint32_t txfifo_l3qm_path0_lo :  8 ; /* bits 7:0 */
    ca_uint32_t txfifo_l3qm_path0_hi :  8 ; /* bits 15:8 */
    ca_uint32_t txfifo_l3qm_path1_lo :  8 ; /* bits 23:16 */
    ca_uint32_t txfifo_l3qm_path1_hi :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_TXFIFO_THRESHOLD_MISC_CFG2_t;


#define NI_HV_GLB_TXFIFO_THRESHOLD_MISC_CFG3     0xf4304258
#define NI_HV_GLB_TXFIFO_THRESHOLD_MISC_CFG3_dft 0x00005028

typedef volatile union {
  struct {
    ca_uint32_t txfifo_l3qm_path2_lo :  8 ; /* bits 7:0 */
    ca_uint32_t txfifo_l3qm_path2_hi :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_TXFIFO_THRESHOLD_MISC_CFG3_t;


#define NI_HV_GLB_TXFIFO_MCE_THRESHOLD_CFG       0xf430425c
#define NI_HV_GLB_TXFIFO_MCE_THRESHOLD_CFG_dft   0x00019028

typedef volatile union {
  struct {
    ca_uint32_t mce_from_tm_txfifo_lo : 10 ; /* bits 9:0 */
    ca_uint32_t mce_from_tm_txfifo_hi : 10 ; /* bits 19:10 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_TXFIFO_MCE_THRESHOLD_CFG_t;


#define NI_HV_GLB_RXFIFO_THRESHOLD_MISC_CFG      0xf4304260
#define NI_HV_GLB_RXFIFO_THRESHOLD_MISC_CFG_dft  0x780a780a

typedef volatile union {
  struct {
    ca_uint32_t l3fe_rxfifo_lo       :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t l3fe_rxfifo_hi       :  7 ; /* bits 14:8 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t l3qm_rxfifo_lo       :  7 ; /* bits 22:16 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t l3qm_rxfifo_hi       :  7 ; /* bits 30:24 */
    ca_uint32_t rsrvd4               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RXFIFO_THRESHOLD_MISC_CFG_t;


#define NI_HV_GLB_RXFIFO_XGE6_THRESHOLD_CFG      0xf4304264
#define NI_HV_GLB_RXFIFO_XGE6_THRESHOLD_CFG_dft  0x0003c00a

typedef volatile union {
  struct {
    ca_uint32_t thre_lo              :  9 ; /* bits 8:0 */
    ca_uint32_t thre_hi              :  9 ; /* bits 17:9 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_RXFIFO_XGE6_THRESHOLD_CFG_t;


#define NI_HV_GLB_NIRX_L3QM_THRESHOLD_CFG        0xf4304268
#define NI_HV_GLB_NIRX_L3QM_THRESHOLD_CFG_dft    0x00008080

typedef volatile union {
  struct {
    ca_uint32_t l2tm_fifo_thre       :  8 ; /* bits 7:0 */
    ca_uint32_t wan_fifo_thre        :  8 ; /* bits 15:8 */
    ca_uint32_t dis_fifo_thre        :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_NIRX_L3QM_THRESHOLD_CFG_t;


#define NI_HV_GLB_PTP_TX_CFG                     0xf430426c
#define NI_HV_GLB_PTP_TX_CFG_dft                 0x000000ff

typedef volatile union {
  struct {
    ca_uint32_t p0_ptp_tx_en         :  1 ; /* bits 0:0 */
    ca_uint32_t p1_ptp_tx_en         :  1 ; /* bits 1:1 */
    ca_uint32_t p2_ptp_tx_en         :  1 ; /* bits 2:2 */
    ca_uint32_t p3_ptp_tx_en         :  1 ; /* bits 3:3 */
    ca_uint32_t p4_ptp_tx_en         :  1 ; /* bits 4:4 */
    ca_uint32_t p5_ptp_tx_en         :  1 ; /* bits 5:5 */
    ca_uint32_t p6_ptp_tx_en         :  1 ; /* bits 6:6 */
    ca_uint32_t p7_ptp_tx_en         :  1 ; /* bits 7:7 */
    ca_uint32_t p0_ptp_tx_bypass     :  1 ; /* bits 8:8 */
    ca_uint32_t p1_ptp_tx_bypass     :  1 ; /* bits 9:9 */
    ca_uint32_t p2_ptp_tx_bypass     :  1 ; /* bits 10:10 */
    ca_uint32_t p3_ptp_tx_bypass     :  1 ; /* bits 11:11 */
    ca_uint32_t p4_ptp_tx_bypass     :  1 ; /* bits 12:12 */
    ca_uint32_t p5_ptp_tx_bypass     :  1 ; /* bits 13:13 */
    ca_uint32_t p6_ptp_tx_bypass     :  1 ; /* bits 14:14 */
    ca_uint32_t p7_ptp_tx_bypass     :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_PTP_TX_CFG_t;


#define NI_HV_GLB_GE_PTP_ASYM_CFG_01             0xf4304270
#define NI_HV_GLB_GE_PTP_ASYM_CFG_01_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t asym_cfg_01          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_GE_PTP_ASYM_CFG_01_t;


#define NI_HV_GLB_GE_PTP_ASYM_CFG_00             0xf4304274
#define NI_HV_GLB_GE_PTP_ASYM_CFG_00_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t asym_cfg_00          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_GE_PTP_ASYM_CFG_00_t;


#define NI_HV_GLB_GE_PTP_ASYM_CFG_11             0xf4304278
#define NI_HV_GLB_GE_PTP_ASYM_CFG_11_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t asym_cfg_11          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_GE_PTP_ASYM_CFG_11_t;


#define NI_HV_GLB_GE_PTP_ASYM_CFG_10             0xf430427c
#define NI_HV_GLB_GE_PTP_ASYM_CFG_10_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t asym_cfg_10          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_GE_PTP_ASYM_CFG_10_t;


#define NI_HV_GLB_GE_PTP_ASYM_CFG_21             0xf4304280
#define NI_HV_GLB_GE_PTP_ASYM_CFG_21_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t asym_cfg_21          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_GE_PTP_ASYM_CFG_21_t;


#define NI_HV_GLB_GE_PTP_ASYM_CFG_20             0xf4304284
#define NI_HV_GLB_GE_PTP_ASYM_CFG_20_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t asym_cfg_20          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_GE_PTP_ASYM_CFG_20_t;


#define NI_HV_GLB_GE_PTP_ASYM_CFG_31             0xf4304288
#define NI_HV_GLB_GE_PTP_ASYM_CFG_31_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t asym_cfg_31          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_GE_PTP_ASYM_CFG_31_t;


#define NI_HV_GLB_GE_PTP_ASYM_CFG_30             0xf430428c
#define NI_HV_GLB_GE_PTP_ASYM_CFG_30_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t asym_cfg_30          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_GE_PTP_ASYM_CFG_30_t;


#define NI_HV_GLB_XAUI_PTP_ASYM_CFG_01           0xf4304290
#define NI_HV_GLB_XAUI_PTP_ASYM_CFG_01_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t asym_cfg_01          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_XAUI_PTP_ASYM_CFG_01_t;


#define NI_HV_GLB_XAUI_PTP_ASYM_CFG_00           0xf4304294
#define NI_HV_GLB_XAUI_PTP_ASYM_CFG_00_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t asym_cfg_00          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_XAUI_PTP_ASYM_CFG_00_t;


#define NI_HV_GLB_XAUI_PTP_ASYM_CFG_11           0xf4304298
#define NI_HV_GLB_XAUI_PTP_ASYM_CFG_11_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t asym_cfg_11          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_XAUI_PTP_ASYM_CFG_11_t;


#define NI_HV_GLB_XAUI_PTP_ASYM_CFG_10           0xf430429c
#define NI_HV_GLB_XAUI_PTP_ASYM_CFG_10_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t asym_cfg_10          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_XAUI_PTP_ASYM_CFG_10_t;


#define NI_HV_GLB_XAUI_PTP_ASYM_CFG_21           0xf43042a0
#define NI_HV_GLB_XAUI_PTP_ASYM_CFG_21_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t asym_cfg_21          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_XAUI_PTP_ASYM_CFG_21_t;


#define NI_HV_GLB_XAUI_PTP_ASYM_CFG_20           0xf43042a4
#define NI_HV_GLB_XAUI_PTP_ASYM_CFG_20_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t asym_cfg_20          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_XAUI_PTP_ASYM_CFG_20_t;


#define NI_HV_GLB_XAUI_PTP_ASYM_CFG_31           0xf43042a8
#define NI_HV_GLB_XAUI_PTP_ASYM_CFG_31_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t asym_cfg_31          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_XAUI_PTP_ASYM_CFG_31_t;


#define NI_HV_GLB_XAUI_PTP_ASYM_CFG_30           0xf43042ac
#define NI_HV_GLB_XAUI_PTP_ASYM_CFG_30_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t asym_cfg_30          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_XAUI_PTP_ASYM_CFG_30_t;


#define NI_HV_GLB_XGE_PTP_ASYM_CFG_01            0xf43042b0
#define NI_HV_GLB_XGE_PTP_ASYM_CFG_01_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t asym_cfg_01          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_XGE_PTP_ASYM_CFG_01_t;


#define NI_HV_GLB_XGE_PTP_ASYM_CFG_00            0xf43042b4
#define NI_HV_GLB_XGE_PTP_ASYM_CFG_00_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t asym_cfg_00          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_XGE_PTP_ASYM_CFG_00_t;


#define NI_HV_GLB_XGE_PTP_ASYM_CFG_11            0xf43042b8
#define NI_HV_GLB_XGE_PTP_ASYM_CFG_11_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t asym_cfg_11          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_XGE_PTP_ASYM_CFG_11_t;


#define NI_HV_GLB_XGE_PTP_ASYM_CFG_10            0xf43042bc
#define NI_HV_GLB_XGE_PTP_ASYM_CFG_10_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t asym_cfg_10          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_XGE_PTP_ASYM_CFG_10_t;


#define NI_HV_GLB_XGE_PTP_ASYM_CFG_21            0xf43042c0
#define NI_HV_GLB_XGE_PTP_ASYM_CFG_21_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t asym_cfg_21          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_XGE_PTP_ASYM_CFG_21_t;


#define NI_HV_GLB_XGE_PTP_ASYM_CFG_20            0xf43042c4
#define NI_HV_GLB_XGE_PTP_ASYM_CFG_20_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t asym_cfg_20          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_XGE_PTP_ASYM_CFG_20_t;


#define NI_HV_GLB_XGE_PTP_ASYM_CFG_31            0xf43042c8
#define NI_HV_GLB_XGE_PTP_ASYM_CFG_31_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t asym_cfg_31          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_XGE_PTP_ASYM_CFG_31_t;


#define NI_HV_GLB_XGE_PTP_ASYM_CFG_30            0xf43042cc
#define NI_HV_GLB_XGE_PTP_ASYM_CFG_30_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t asym_cfg_30          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_XGE_PTP_ASYM_CFG_30_t;


#define NI_HV_GLB_P0_PTP_TX_TIMESTAMP            0xf43042d0
#define NI_HV_GLB_P0_PTP_TX_TIMESTAMP_STRIDE     4
#define NI_HV_GLB_P0_PTP_TX_TIMESTAMP_COUNT      8
#define NI_HV_GLB_P0_PTP_TX_TIMESTAMP_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_ts                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_P0_PTP_TX_TIMESTAMP_t;

                            
#define NI_HV_GLB_NITX_STS                       0xf43042f0
#define NI_HV_GLB_NITX_STS_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sts                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_NITX_STS_t;


#define NI_HV_GLB_SPARE                          0xf43042f4
#define NI_HV_GLB_SPARE_dft                      0x0000ff00

typedef volatile union {
  struct {
    ca_uint32_t VALUE                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_SPARE_t;


#define NI_HV_GLB_MISC_STS                       0xf43042f8
#define NI_HV_GLB_MISC_STS_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t xge6_link_fault      :  1 ; /* bits 0:0 */
    ca_uint32_t xge7_link_fault      :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_MISC_STS_t;


#define NI_HV_GLB_SPARESAMPLE                    0xf43042fc
#define NI_HV_GLB_SPARESAMPLE_dft                0x0000ff00

typedef volatile union {
  struct {
    ca_uint32_t VALUE                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_SPARESAMPLE_t;


#define NI_HV_GLB_PORT_0_INTERRUPT               0xf4304300
#define NI_HV_GLB_PORT_0_INTERRUPT_STRIDE        8
#define NI_HV_GLB_PORT_0_INTERRUPT_COUNT         5
#define NI_HV_GLB_PORT_0_INTERRUPT_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t link_stat_chgI       :  1 ; /* bits 0:0 */
    ca_uint32_t txfifo_underrunI     :  1 ; /* bits 1:1 */
    ca_uint32_t txfifo_overrunI      :  1 ; /* bits 2:2 */
    ca_uint32_t rxcntrl_overrunI     :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t rxmib_cntmsb_setI    :  1 ; /* bits 5:5 */
    ca_uint32_t txmib_cntmsb_setI    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t lpi_assert_stat_chgI :  1 ; /* bits 9:9 */
    ca_uint32_t rx_lpi_stat_chgI     :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd3               :  2 ;
    ca_uint32_t ni_wol_int           :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd4               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_PORT_0_INTERRUPT_t;


#define NI_HV_GLB_PORT_0_INTERRUPTE              0xf4304304
#define NI_HV_GLB_PORT_0_INTERRUPTE_STRIDE       8
#define NI_HV_GLB_PORT_0_INTERRUPTE_COUNT        5
#define NI_HV_GLB_PORT_0_INTERRUPTE_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t link_stat_chgIE      :  1 ; /* bits 0:0 */
    ca_uint32_t txfifo_underrunIE    :  1 ; /* bits 1:1 */
    ca_uint32_t txfifo_overrunIE     :  1 ; /* bits 2:2 */
    ca_uint32_t rxcntrl_overrunIE    :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t rxmib_cntmsb_setIE   :  1 ; /* bits 5:5 */
    ca_uint32_t txmib_cntmsb_setIE   :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t lpi_assert_stat_chgIE :  1 ; /* bits 9:9 */
    ca_uint32_t rx_lpi_stat_chgIE    :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd3               :  2 ;
    ca_uint32_t ni_wol_intE          :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd4               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_PORT_0_INTERRUPTE_t;

                                
#define NI_HV_GLB_PORT_5_INTERRUPT               0xf4304328
#define NI_HV_GLB_PORT_5_INTERRUPT_STRIDE        8
#define NI_HV_GLB_PORT_5_INTERRUPT_COUNT         3
#define NI_HV_GLB_PORT_5_INTERRUPT_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t rxcntrl_overrunI     :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd2               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_PORT_5_INTERRUPT_t;


#define NI_HV_GLB_PORT_5_INTERRUPTE              0xf430432c
#define NI_HV_GLB_PORT_5_INTERRUPTE_STRIDE       8
#define NI_HV_GLB_PORT_5_INTERRUPTE_COUNT        3
#define NI_HV_GLB_PORT_5_INTERRUPTE_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t rxcntrl_overrunIE    :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd2               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_PORT_5_INTERRUPTE_t;

                
#define NI_HV_GLB_PORT_8_INTERRUPT               0xf4304340
#define NI_HV_GLB_PORT_8_INTERRUPT_STRIDE        8
#define NI_HV_GLB_PORT_8_INTERRUPT_COUNT         4
#define NI_HV_GLB_PORT_8_INTERRUPT_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t rxcntrl_overrunI     :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t rxmib_cntmsb_setI    :  1 ; /* bits 5:5 */
    ca_uint32_t txmib_cntmsb_setI    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd3               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_PORT_8_INTERRUPT_t;


#define NI_HV_GLB_PORT_8_INTERRUPTE              0xf4304344
#define NI_HV_GLB_PORT_8_INTERRUPTE_STRIDE       8
#define NI_HV_GLB_PORT_8_INTERRUPTE_COUNT        4
#define NI_HV_GLB_PORT_8_INTERRUPTE_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t rxcntrl_overrunIE    :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t rxmib_cntmsb_setIE   :  1 ; /* bits 5:5 */
    ca_uint32_t txmib_cntmsb_setIE   :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd3               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_PORT_8_INTERRUPTE_t;

                        
#define NI_HV_GLB_NIFIFO_INTERRUPT               0xf4304360
#define NI_HV_GLB_NIFIFO_INTERRUPT_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t p0_nitx_fifo_under_run_setI :  1 ; /* bits 0:0 */
    ca_uint32_t p0_nitx_fifo_over_run_setI :  1 ; /* bits 1:1 */
    ca_uint32_t p1_nitx_fifo_under_run_setI :  1 ; /* bits 2:2 */
    ca_uint32_t p1_nitx_fifo_over_run_setI :  1 ; /* bits 3:3 */
    ca_uint32_t p2_nitx_fifo_under_run_setI :  1 ; /* bits 4:4 */
    ca_uint32_t p2_nitx_fifo_over_run_setI :  1 ; /* bits 5:5 */
    ca_uint32_t p3_nitx_fifo_under_run_setI :  1 ; /* bits 6:6 */
    ca_uint32_t p3_nitx_fifo_over_run_setI :  1 ; /* bits 7:7 */
    ca_uint32_t p4_nitx_fifo_under_run_setI :  1 ; /* bits 8:8 */
    ca_uint32_t p4_nitx_fifo_over_run_setI :  1 ; /* bits 9:9 */
    ca_uint32_t p5_nitx_fifo_under_run_setI :  1 ; /* bits 10:10 */
    ca_uint32_t p5_nitx_fifo_over_run_setI :  1 ; /* bits 11:11 */
    ca_uint32_t p6_nitx_fifo_under_run_setI :  1 ; /* bits 12:12 */
    ca_uint32_t p6_nitx_fifo_over_run_setI :  1 ; /* bits 13:13 */
    ca_uint32_t p7_nitx_fifo_under_run_setI :  1 ; /* bits 14:14 */
    ca_uint32_t p7_nitx_fifo_over_run_setI :  1 ; /* bits 15:15 */
    ca_uint32_t p8_nitx_fifo_under_run_setI :  1 ; /* bits 16:16 */
    ca_uint32_t p8_nitx_fifo_over_run_setI :  1 ; /* bits 17:17 */
    ca_uint32_t p9_nitx_fifo_under_run_setI :  1 ; /* bits 18:18 */
    ca_uint32_t p9_nitx_fifo_over_run_setI :  1 ; /* bits 19:19 */
    ca_uint32_t p10_nitx_fifo_under_run_setI :  1 ; /* bits 20:20 */
    ca_uint32_t p10_nitx_fifo_over_run_setI :  1 ; /* bits 21:21 */
    ca_uint32_t p11_nitx_fifo_under_run_setI :  1 ; /* bits 22:22 */
    ca_uint32_t p11_nitx_fifo_over_run_setI :  1 ; /* bits 23:23 */
    ca_uint32_t p12_nitx_fifo_under_run_setI :  1 ; /* bits 24:24 */
    ca_uint32_t p12_nitx_fifo_over_run_setI :  1 ; /* bits 25:25 */
    ca_uint32_t p13_nitx_fifo_under_run_setI :  1 ; /* bits 26:26 */
    ca_uint32_t p13_nitx_fifo_over_run_setI :  1 ; /* bits 27:27 */
    ca_uint32_t l3qm_nirx_fifo_under_run_setI :  1 ; /* bits 28:28 */
    ca_uint32_t l3qm_nirx_fifo_over_run_setI :  1 ; /* bits 29:29 */
    ca_uint32_t l3fe_nirx_fifo_under_run_setI :  1 ; /* bits 30:30 */
    ca_uint32_t l3fe_nirx_fifo_over_run_setI :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_NIFIFO_INTERRUPT_t;


#define NI_HV_GLB_NIFIFO_INTERRUPTE              0xf4304364
#define NI_HV_GLB_NIFIFO_INTERRUPTE_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t p0_nitx_fifo_under_run_setIE :  1 ; /* bits 0:0 */
    ca_uint32_t p0_nitx_fifo_over_run_setIE :  1 ; /* bits 1:1 */
    ca_uint32_t p1_nitx_fifo_under_run_setIE :  1 ; /* bits 2:2 */
    ca_uint32_t p1_nitx_fifo_over_run_setIE :  1 ; /* bits 3:3 */
    ca_uint32_t p2_nitx_fifo_under_run_setIE :  1 ; /* bits 4:4 */
    ca_uint32_t p2_nitx_fifo_over_run_setIE :  1 ; /* bits 5:5 */
    ca_uint32_t p3_nitx_fifo_under_run_setIE :  1 ; /* bits 6:6 */
    ca_uint32_t p3_nitx_fifo_over_run_setIE :  1 ; /* bits 7:7 */
    ca_uint32_t p4_nitx_fifo_under_run_setIE :  1 ; /* bits 8:8 */
    ca_uint32_t p4_nitx_fifo_over_run_setIE :  1 ; /* bits 9:9 */
    ca_uint32_t p5_nitx_fifo_under_run_setIE :  1 ; /* bits 10:10 */
    ca_uint32_t p5_nitx_fifo_over_run_setIE :  1 ; /* bits 11:11 */
    ca_uint32_t p6_nitx_fifo_under_run_setIE :  1 ; /* bits 12:12 */
    ca_uint32_t p6_nitx_fifo_over_run_setIE :  1 ; /* bits 13:13 */
    ca_uint32_t p7_nitx_fifo_under_run_setIE :  1 ; /* bits 14:14 */
    ca_uint32_t p7_nitx_fifo_over_run_setIE :  1 ; /* bits 15:15 */
    ca_uint32_t p8_nitx_fifo_under_run_setIE :  1 ; /* bits 16:16 */
    ca_uint32_t p8_nitx_fifo_over_run_setIE :  1 ; /* bits 17:17 */
    ca_uint32_t p9_nitx_fifo_under_run_setIE :  1 ; /* bits 18:18 */
    ca_uint32_t p9_nitx_fifo_over_run_setIE :  1 ; /* bits 19:19 */
    ca_uint32_t p10_nitx_fifo_under_run_setIE :  1 ; /* bits 20:20 */
    ca_uint32_t p10_nitx_fifo_over_run_setIE :  1 ; /* bits 21:21 */
    ca_uint32_t p11_nitx_fifo_under_run_setIE :  1 ; /* bits 22:22 */
    ca_uint32_t p11_nitx_fifo_over_run_setIE :  1 ; /* bits 23:23 */
    ca_uint32_t p12_nitx_fifo_under_run_setIE :  1 ; /* bits 24:24 */
    ca_uint32_t p12_nitx_fifo_over_run_setIE :  1 ; /* bits 25:25 */
    ca_uint32_t p13_nitx_fifo_under_run_setIE :  1 ; /* bits 26:26 */
    ca_uint32_t p13_nitx_fifo_over_run_setIE :  1 ; /* bits 27:27 */
    ca_uint32_t l3qm_nirx_fifo_under_run_setIE :  1 ; /* bits 28:28 */
    ca_uint32_t l3qm_nirx_fifo_over_run_setIE :  1 ; /* bits 29:29 */
    ca_uint32_t l3fe_nirx_fifo_under_run_setIE :  1 ; /* bits 30:30 */
    ca_uint32_t l3fe_nirx_fifo_over_run_setIE :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_NIFIFO_INTERRUPTE_t;


#define NI_HV_GLB_MISC_INTERRUPT                 0xf4304368
#define NI_HV_GLB_MISC_INTERRUPT_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t xge6_link_faultI     :  1 ; /* bits 0:0 */
    ca_uint32_t xge7_link_faultI     :  1 ; /* bits 1:1 */
    ca_uint32_t l2tm_nitx_overrunI   :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_MISC_INTERRUPT_t;


#define NI_HV_GLB_MISC_INTERRUPTE                0xf430436c
#define NI_HV_GLB_MISC_INTERRUPTE_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t xge6_link_faultIE    :  1 ; /* bits 0:0 */
    ca_uint32_t xge7_link_faultIE    :  1 ; /* bits 1:1 */
    ca_uint32_t l2tm_nitx_overrunIE  :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_MISC_INTERRUPTE_t;


#define NI_HV_GLB_TXEM_INTERRUPT                 0xf4304370
#define NI_HV_GLB_TXEM_INTERRUPT_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t txem_ififo_ovfI      :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t txrm_cntovfI         :  1 ; /* bits 2:2 */
    ca_uint32_t txmib_fifo_ovfI      :  1 ; /* bits 3:3 */
    ca_uint32_t rxmib_fifo_ovfI      :  1 ; /* bits 4:4 */
    ca_uint32_t txem_ptp_voqchg_errI :  1 ; /* bits 5:5 */
    ca_uint32_t txem_ptp_cachevoq_errI :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t txem_ptp_v6csum0_errI :  1 ; /* bits 9:9 */
    ca_uint32_t txrm_timerexpI       :  1 ; /* bits 10:10 */
    ca_uint32_t nitx_crc_errI        :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd3               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_TXEM_INTERRUPT_t;


#define NI_HV_GLB_TXEM_INTERRUPTE                0xf4304374
#define NI_HV_GLB_TXEM_INTERRUPTE_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t txem_ififo_ovfIE     :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t txrm_cntovfIE        :  1 ; /* bits 2:2 */
    ca_uint32_t txmib_fifo_ovfIE     :  1 ; /* bits 3:3 */
    ca_uint32_t rxmib_fifo_ovfIE     :  1 ; /* bits 4:4 */
    ca_uint32_t txem_ptp_voqchg_errIE :  1 ; /* bits 5:5 */
    ca_uint32_t txem_ptp_cachevoq_errIE :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t txem_ptp_v6csum0_errIE :  1 ; /* bits 9:9 */
    ca_uint32_t txrm_timerexpIE      :  1 ; /* bits 10:10 */
    ca_uint32_t nitx_crc_errIE       :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd3               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_TXEM_INTERRUPTE_t;


#define NI_HV_GLB_PC0_INTERRUPT                  0xf4304378
#define NI_HV_GLB_PC0_INTERRUPT_STRIDE           8
#define NI_HV_GLB_PC0_INTERRUPT_COUNT            5
#define NI_HV_GLB_PC0_INTERRUPT_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dchkoutofsyncI       :  1 ; /* bits 0:0 */
    ca_uint32_t dstaddrmismatchI     :  1 ; /* bits 1:1 */
    ca_uint32_t srcaddrmismatchI     :  1 ; /* bits 2:2 */
    ca_uint32_t vlan1fieldmismatchI  :  1 ; /* bits 3:3 */
    ca_uint32_t vlan2fieldmismatchI  :  1 ; /* bits 4:4 */
    ca_uint32_t typefieldmismatchI   :  1 ; /* bits 5:5 */
    ca_uint32_t seqnummismatchI      :  1 ; /* bits 6:6 */
    ca_uint32_t datamismatchI        :  1 ; /* bits 7:7 */
    ca_uint32_t framelenmismatchI    :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_PC0_INTERRUPT_t;


#define NI_HV_GLB_PC0_INTERRUPTE                 0xf430437c
#define NI_HV_GLB_PC0_INTERRUPTE_STRIDE          8
#define NI_HV_GLB_PC0_INTERRUPTE_COUNT           5
#define NI_HV_GLB_PC0_INTERRUPTE_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dchkoutofsyncIE      :  1 ; /* bits 0:0 */
    ca_uint32_t dstaddrmismatchIE    :  1 ; /* bits 1:1 */
    ca_uint32_t srcaddrmismatchIE    :  1 ; /* bits 2:2 */
    ca_uint32_t vlan1fieldmismatchIE :  1 ; /* bits 3:3 */
    ca_uint32_t vlan2fieldmismatchIE :  1 ; /* bits 4:4 */
    ca_uint32_t typefieldmismatchIE  :  1 ; /* bits 5:5 */
    ca_uint32_t seqnummismatchIE     :  1 ; /* bits 6:6 */
    ca_uint32_t datamismatchIE       :  1 ; /* bits 7:7 */
    ca_uint32_t framelenmismatchIE   :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_PC0_INTERRUPTE_t;

                                
#define NI_HV_GLB_CPUXRAM_CNTR_INTERRUPT         0xf43043a0
#define NI_HV_GLB_CPUXRAM_CNTR_INTERRUPT_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt_drop_err_0_cntmsb_setI :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  9 ;
    ca_uint32_t pkt_to_xram_0_cntmsb_setI :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd2               :  9 ;
    ca_uint32_t byt_to_xram_0_cntmsb_setI :  1 ; /* bits 20:20 */
    ca_uint32_t rsrvd3               :  8 ;
    ca_uint32_t dma_pkt_to_cpu_cntmsb_setI :  1 ; /* bits 29:29 */
    ca_uint32_t dma_byte_to_cpu_cntmsb_setI :  1 ; /* bits 30:30 */
    ca_uint32_t rsrvd4               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_CPUXRAM_CNTR_INTERRUPT_t;


#define NI_HV_GLB_CPUXRAM_CNTR_INTERRUPTE        0xf43043a4
#define NI_HV_GLB_CPUXRAM_CNTR_INTERRUPTE_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt_drop_err_0_cntmsb_setIE :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  9 ;
    ca_uint32_t pkt_to_xram_0_cntmsb_setIE :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd2               :  9 ;
    ca_uint32_t byt_to_xram_0_cntmsb_setIE :  1 ; /* bits 20:20 */
    ca_uint32_t rsrvd3               :  8 ;
    ca_uint32_t dma_pkt_to_cpu_cntmsb_setIE :  1 ; /* bits 29:29 */
    ca_uint32_t dma_byte_to_cpu_cntmsb_setIE :  1 ; /* bits 30:30 */
    ca_uint32_t rsrvd4               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_CPUXRAM_CNTR_INTERRUPTE_t;


#define NI_HV_GLB_CPUXRAM_ERR_INTERRUPT          0xf43043a8
#define NI_HV_GLB_CPUXRAM_ERR_INTERRUPT_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t xram_rx_0_ptrbkupI   :  1 ; /* bits 0:0 */
    ca_uint32_t xram_rx_no_hdrAI     :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 20 ;
    ca_uint32_t xram_rx_mgmtfifo_overrunI :  1 ; /* bits 22:22 */
    ca_uint32_t dma_fifo_overrunI    :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd2               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_CPUXRAM_ERR_INTERRUPT_t;


#define NI_HV_GLB_CPUXRAM_ERR_INTERRUPTE         0xf43043ac
#define NI_HV_GLB_CPUXRAM_ERR_INTERRUPTE_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t xram_rx_0_ptrbkupIE  :  1 ; /* bits 0:0 */
    ca_uint32_t xram_rx_no_hdrAIE    :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 20 ;
    ca_uint32_t xram_rx_mgmtfifo_overrunIE :  1 ; /* bits 22:22 */
    ca_uint32_t dma_fifo_overrunIE   :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd2               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_CPUXRAM_ERR_INTERRUPTE_t;


#define NI_HV_GLB_PTP_INTERRUPT                  0xf43043b0
#define NI_HV_GLB_PTP_INTERRUPT_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t port0_tx_timestamp_rdy_intI :  1 ; /* bits 0:0 */
    ca_uint32_t port1_tx_timestamp_rdy_intI :  1 ; /* bits 1:1 */
    ca_uint32_t port2_tx_timestamp_rdy_intI :  1 ; /* bits 2:2 */
    ca_uint32_t port3_tx_timestamp_rdy_intI :  1 ; /* bits 3:3 */
    ca_uint32_t port4_tx_timestamp_rdy_intI :  1 ; /* bits 4:4 */
    ca_uint32_t port5_tx_timestamp_rdy_intI :  1 ; /* bits 5:5 */
    ca_uint32_t port6_tx_timestamp_rdy_intI :  1 ; /* bits 6:6 */
    ca_uint32_t port7_tx_timestamp_rdy_intI :  1 ; /* bits 7:7 */
    ca_uint32_t port0_tx_ptpfifo_overflow_intI :  1 ; /* bits 8:8 */
    ca_uint32_t port1_tx_ptpfifo_overflow_intI :  1 ; /* bits 9:9 */
    ca_uint32_t port2_tx_ptpfifo_overflow_intI :  1 ; /* bits 10:10 */
    ca_uint32_t port3_tx_ptpfifo_overflow_intI :  1 ; /* bits 11:11 */
    ca_uint32_t port4_tx_ptpfifo_overflow_intI :  1 ; /* bits 12:12 */
    ca_uint32_t port5_tx_ptpfifo_overflow_intI :  1 ; /* bits 13:13 */
    ca_uint32_t port6_tx_ptpfifo_overflow_intI :  1 ; /* bits 14:14 */
    ca_uint32_t port7_tx_ptpfifo_overflow_intI :  1 ; /* bits 15:15 */
    ca_uint32_t port0_tx_ptpfifo_underflow_intI :  1 ; /* bits 16:16 */
    ca_uint32_t port1_tx_ptpfifo_underflow_intI :  1 ; /* bits 17:17 */
    ca_uint32_t port2_tx_ptpfifo_underflow_intI :  1 ; /* bits 18:18 */
    ca_uint32_t port3_tx_ptpfifo_underflow_intI :  1 ; /* bits 19:19 */
    ca_uint32_t port4_tx_ptpfifo_underflow_intI :  1 ; /* bits 20:20 */
    ca_uint32_t port5_tx_ptpfifo_underflow_intI :  1 ; /* bits 21:21 */
    ca_uint32_t port6_tx_ptpfifo_underflow_intI :  1 ; /* bits 22:22 */
    ca_uint32_t port7_tx_ptpfifo_underflow_intI :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t timer_rollover_intI  :  1 ; /* bits 29:29 */
    ca_uint32_t pps_event_intI       :  1 ; /* bits 30:30 */
    ca_uint32_t pps_out_falledge_intI :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_PTP_INTERRUPT_t;


#define NI_HV_GLB_PTP_INTERRUPTE                 0xf43043b4
#define NI_HV_GLB_PTP_INTERRUPTE_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t port0_tx_timestamp_rdy_intIE :  1 ; /* bits 0:0 */
    ca_uint32_t port1_tx_timestamp_rdy_intIE :  1 ; /* bits 1:1 */
    ca_uint32_t port2_tx_timestamp_rdy_intIE :  1 ; /* bits 2:2 */
    ca_uint32_t port3_tx_timestamp_rdy_intIE :  1 ; /* bits 3:3 */
    ca_uint32_t port4_tx_timestamp_rdy_intIE :  1 ; /* bits 4:4 */
    ca_uint32_t port5_tx_timestamp_rdy_intIE :  1 ; /* bits 5:5 */
    ca_uint32_t port6_tx_timestamp_rdy_intIE :  1 ; /* bits 6:6 */
    ca_uint32_t port7_tx_timestamp_rdy_intIE :  1 ; /* bits 7:7 */
    ca_uint32_t port0_tx_ptpfifo_overflow_intIE :  1 ; /* bits 8:8 */
    ca_uint32_t port1_tx_ptpfifo_overflow_intIE :  1 ; /* bits 9:9 */
    ca_uint32_t port2_tx_ptpfifo_overflow_intIE :  1 ; /* bits 10:10 */
    ca_uint32_t port3_tx_ptpfifo_overflow_intIE :  1 ; /* bits 11:11 */
    ca_uint32_t port4_tx_ptpfifo_overflow_intIE :  1 ; /* bits 12:12 */
    ca_uint32_t port5_tx_ptpfifo_overflow_intIE :  1 ; /* bits 13:13 */
    ca_uint32_t port6_tx_ptpfifo_overflow_intIE :  1 ; /* bits 14:14 */
    ca_uint32_t port7_tx_ptpfifo_overflow_intIE :  1 ; /* bits 15:15 */
    ca_uint32_t port0_tx_ptpfifo_underflow_intIE :  1 ; /* bits 16:16 */
    ca_uint32_t port1_tx_ptpfifo_underflow_intIE :  1 ; /* bits 17:17 */
    ca_uint32_t port2_tx_ptpfifo_underflow_intIE :  1 ; /* bits 18:18 */
    ca_uint32_t port3_tx_ptpfifo_underflow_intIE :  1 ; /* bits 19:19 */
    ca_uint32_t port4_tx_ptpfifo_underflow_intIE :  1 ; /* bits 20:20 */
    ca_uint32_t port5_tx_ptpfifo_underflow_intIE :  1 ; /* bits 21:21 */
    ca_uint32_t port6_tx_ptpfifo_underflow_intIE :  1 ; /* bits 22:22 */
    ca_uint32_t port7_tx_ptpfifo_underflow_intIE :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t timer_rollover_intIE :  1 ; /* bits 29:29 */
    ca_uint32_t pps_event_intIE      :  1 ; /* bits 30:30 */
    ca_uint32_t pps_out_falledge_intIE :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_PTP_INTERRUPTE_t;


#define NI_HV_GLB_CPUXRAM_RXPKT_INTERRUPT        0xf43043b8
#define NI_HV_GLB_CPUXRAM_RXPKT_INTERRUPT_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t xram_rx_doneI        :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_CPUXRAM_RXPKT_INTERRUPT_t;


#define NI_HV_GLB_CPUXRAM_RXPKT_INTERRUPTE       0xf43043bc
#define NI_HV_GLB_CPUXRAM_RXPKT_INTERRUPTE_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t xram_rx_doneIE       :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_CPUXRAM_RXPKT_INTERRUPTE_t;


#define NI_HV_GLB_CPUXRAM_TXPKT_INTERRUPT        0xf43043c0
#define NI_HV_GLB_CPUXRAM_TXPKT_INTERRUPT_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t xram_tx_0_doneI      :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_CPUXRAM_TXPKT_INTERRUPT_t;


#define NI_HV_GLB_CPUXRAM_TXPKT_INTERRUPTE       0xf43043c4
#define NI_HV_GLB_CPUXRAM_TXPKT_INTERRUPTE_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t xram_tx_0_doneIE     :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_CPUXRAM_TXPKT_INTERRUPTE_t;


#define NI_HV_GLB_MC_INTERRUPT                   0xf43043c8
#define NI_HV_GLB_MC_INTERRUPT_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t mc_ff_full_drop_intI :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t bitmap_zero_drop_intI :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd3               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_MC_INTERRUPT_t;


#define NI_HV_GLB_MC_INTERRUPTE                  0xf43043cc
#define NI_HV_GLB_MC_INTERRUPTE_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t mc_ff_full_drop_intIE :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t bitmap_zero_drop_intIE :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd3               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_MC_INTERRUPTE_t;


#define NI_HV_GLB_INTERRUPT                      0xf43043d0
#define NI_HV_GLB_INTERRUPT_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t int_stat_pspid_0     :  1 ; /* bits 0:0 */
    ca_uint32_t int_stat_pspid_1     :  1 ; /* bits 1:1 */
    ca_uint32_t int_stat_pspid_2     :  1 ; /* bits 2:2 */
    ca_uint32_t int_stat_pspid_3     :  1 ; /* bits 3:3 */
    ca_uint32_t int_stat_pspid_4     :  1 ; /* bits 4:4 */
    ca_uint32_t int_stat_pspid_5     :  1 ; /* bits 5:5 */
    ca_uint32_t int_stat_pspid_6     :  1 ; /* bits 6:6 */
    ca_uint32_t int_stat_pspid_7     :  1 ; /* bits 7:7 */
    ca_uint32_t int_stat_pspid_8     :  1 ; /* bits 8:8 */
    ca_uint32_t int_stat_pspid_9     :  1 ; /* bits 9:9 */
    ca_uint32_t int_stat_pspid_10    :  1 ; /* bits 10:10 */
    ca_uint32_t int_stat_pspid_11    :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t xge6_int             :  1 ; /* bits 13:13 */
    ca_uint32_t xaui_int             :  1 ; /* bits 14:14 */
    ca_uint32_t xge7_int             :  1 ; /* bits 15:15 */
    ca_uint32_t int_stat_txem        :  1 ; /* bits 16:16 */
    ca_uint32_t int_stat_pc0         :  1 ; /* bits 17:17 */
    ca_uint32_t int_stat_pc1         :  1 ; /* bits 18:18 */
    ca_uint32_t int_stat_pc2         :  1 ; /* bits 19:19 */
    ca_uint32_t int_stat_pc3         :  1 ; /* bits 20:20 */
    ca_uint32_t int_stat_pc4         :  1 ; /* bits 21:21 */
    ca_uint32_t sxgmii6_int          :  1 ; /* bits 22:22 */
    ca_uint32_t sxgmii7_int          :  1 ; /* bits 23:23 */
    ca_uint32_t misc                 :  1 ; /* bits 24:24 */
    ca_uint32_t cpuxram_int_stat_cntr :  1 ; /* bits 25:25 */
    ca_uint32_t cpuxram_int_stat_err :  1 ; /* bits 26:26 */
    ca_uint32_t int_stat_ptp         :  1 ; /* bits 27:27 */
    ca_uint32_t int_stat_mceng       :  1 ; /* bits 28:28 */
    ca_uint32_t cpuxram_rxpkt        :  1 ; /* bits 29:29 */
    ca_uint32_t cpuxram_txpkt        :  1 ; /* bits 30:30 */
    ca_uint32_t ni_fifo              :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_INTERRUPT_t;


#define NI_HV_GLB_INTERRUPTE                     0xf43043d4
#define NI_HV_GLB_INTERRUPTE_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t int_stat_pspid_0E    :  1 ; /* bits 0:0 */
    ca_uint32_t int_stat_pspid_1E    :  1 ; /* bits 1:1 */
    ca_uint32_t int_stat_pspid_2E    :  1 ; /* bits 2:2 */
    ca_uint32_t int_stat_pspid_3E    :  1 ; /* bits 3:3 */
    ca_uint32_t int_stat_pspid_4E    :  1 ; /* bits 4:4 */
    ca_uint32_t int_stat_pspid_5E    :  1 ; /* bits 5:5 */
    ca_uint32_t int_stat_pspid_6E    :  1 ; /* bits 6:6 */
    ca_uint32_t int_stat_pspid_7E    :  1 ; /* bits 7:7 */
    ca_uint32_t int_stat_pspid_8E    :  1 ; /* bits 8:8 */
    ca_uint32_t int_stat_pspid_9E    :  1 ; /* bits 9:9 */
    ca_uint32_t int_stat_pspid_10E   :  1 ; /* bits 10:10 */
    ca_uint32_t int_stat_pspid_11E   :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t xge6_intE            :  1 ; /* bits 13:13 */
    ca_uint32_t xaui_intE            :  1 ; /* bits 14:14 */
    ca_uint32_t xge7_intE            :  1 ; /* bits 15:15 */
    ca_uint32_t int_stat_txemE       :  1 ; /* bits 16:16 */
    ca_uint32_t int_stat_pc0E        :  1 ; /* bits 17:17 */
    ca_uint32_t int_stat_pc1E        :  1 ; /* bits 18:18 */
    ca_uint32_t int_stat_pc2E        :  1 ; /* bits 19:19 */
    ca_uint32_t int_stat_pc3E        :  1 ; /* bits 20:20 */
    ca_uint32_t int_stat_pc4E        :  1 ; /* bits 21:21 */
    ca_uint32_t sxgmii6_intE         :  1 ; /* bits 22:22 */
    ca_uint32_t sxgmii7_intE         :  1 ; /* bits 23:23 */
    ca_uint32_t miscE                :  1 ; /* bits 24:24 */
    ca_uint32_t cpuxram_int_stat_cntrE :  1 ; /* bits 25:25 */
    ca_uint32_t cpuxram_int_stat_errE :  1 ; /* bits 26:26 */
    ca_uint32_t int_stat_ptpE        :  1 ; /* bits 27:27 */
    ca_uint32_t int_stat_mcengE      :  1 ; /* bits 28:28 */
    ca_uint32_t cpuxram_rxpktE       :  1 ; /* bits 29:29 */
    ca_uint32_t cpuxram_txpktE       :  1 ; /* bits 30:30 */
    ca_uint32_t ni_fifoE             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_INTERRUPTE_t;


#define NI_HV_GLB_ETH_TX_MISC_CFG                0xf43043d8
#define NI_HV_GLB_ETH_TX_MISC_CFG_dft            0x00002020

typedef volatile union {
  struct {
    ca_uint32_t rdy_low_thld_ge      :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t rdy_high_thld_ge     :  9 ; /* bits 18:10 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t rdy_low_thld_fe      :  5 ; /* bits 24:20 */
    ca_uint32_t rsrvd3               :  2 ;
    ca_uint32_t rdy_high_thld_fe     :  5 ; /* bits 31:27 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_ETH_TX_MISC_CFG_t;


#define NI_HV_GLB_DEBUG_2                        0xf43043dc
#define NI_HV_GLB_DEBUG_2_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dbg_ptp_hw_cnt       : 30 ; /* bits 29:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t ptp_hw_cnt_dbg       :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_DEBUG_2_t;


#define NI_HV_GLB_DEBUG_3                        0xf43043e0
#define NI_HV_GLB_DEBUG_3_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sel                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_GLB_DEBUG_3_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* GLB */
typedef struct {
  NI_HV_GLB_REVISION_t                     REVISION;                      /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  NI_HV_GLB_INIT_DONE_t                    INIT_DONE;                     /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  NI_HV_GLB_INTF_RST_CONFIG_t              INTF_RST_CONFIG;               /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  NI_HV_GLB_STATIC_CFG_t                   STATIC_CFG;                    /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  NI_HV_GLB_MAC_ADDR_CFG0_t                MAC_ADDR_CFG0;                 /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  NI_HV_GLB_MAC_ADDR_CFG1_t                MAC_ADDR_CFG1;                 /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  NI_HV_GLB_WOL_PASSWD_0_t                 WOL_PASSWD_0;                  /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  NI_HV_GLB_WOL_PASSWD_1_t                 WOL_PASSWD_1;                  /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  NI_HV_GLB_PKT_LEN_CFG_t                  PKT_LEN_CFG;                   /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  NI_HV_GLB_PKT_STOR_LEN_CFG_t             PKT_STOR_LEN_CFG;              /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  NI_HV_GLB_P5_BYPASS_CFG_t                P5_BYPASS_CFG;                 /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  NI_HV_GLB_XGE_BYPASS_CFG_t               XGE_BYPASS_CFG;                /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  NI_HV_GLB_XGE6_RXPAUSE_CFG_t             XGE6_RXPAUSE_CFG;              /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  NI_HV_GLB_XGE7_RXFIFO_THRESHOLD_t        XGE7_RXFIFO_THRESHOLD;         /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  NI_HV_GLB_XGE6_MAC_CFG1_t                XGE6_MAC_CFG1;                 /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  NI_HV_GLB_XGE6_MAC_CFG0_t                XGE6_MAC_CFG0;                 /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  NI_HV_GLB_XGE6_FLOW_CONTROL_CFG_t        XGE6_FLOW_CONTROL_CFG;         /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  NI_HV_GLB_XGE6_TX_REPEAT_CNT_t           XGE6_TX_REPEAT_CNT;            /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  NI_HV_GLB_XGE6_TX_QUANTA0_t              XGE6_TX_QUANTA0;               /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  NI_HV_GLB_XGE6_TX_QUANTA1_t              XGE6_TX_QUANTA1;               /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  NI_HV_GLB_XGE6_TX_QUANTA2_t              XGE6_TX_QUANTA2;               /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  NI_HV_GLB_XGE6_TX_QUANTA3_t              XGE6_TX_QUANTA3;               /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  NI_HV_GLB_XGE6_QBB_WAIT_TIME_t           XGE6_QBB_WAIT_TIME;            /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  NI_HV_GLB_XGE6_RX_FLOW_CTRL_PKT_CNT_t    XGE6_RX_FLOW_CTRL_PKT_CNT;     /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  NI_HV_GLB_XGE6_RX_FAKE_PAUS_PKT_CNT_t    XGE6_RX_FAKE_PAUS_PKT_CNT;     /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  NI_HV_GLB_XGE6_TX_FLOW_CTRL_PKT_CNT_t    XGE6_TX_FLOW_CTRL_PKT_CNT;     /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[51];                  
  NI_HV_GLB_RXMUX_INTPT_CALENDAR_CFG1_t    RXMUX_INTPT_CALENDAR_CFG1;     /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd27[3];                   
  NI_HV_GLB_RXMUX_INTPT_CALENDAR_CFG0_t    RXMUX_INTPT_CALENDAR_CFG0;     /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd28[3];                   
  NI_HV_GLB_RXMUX_CTRL_CFG_t               RXMUX_CTRL_CFG;                /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd29[3];                   
  NI_HV_GLB_RXMUX_LAST_HDR_A2_t            RXMUX_LAST_HDR_A2;             /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd30[3];                   
  NI_HV_GLB_RXMUX_LAST_HDR_A1_t            RXMUX_LAST_HDR_A1;             /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd31[3];                   
  NI_HV_GLB_RXMUX_LAST_HDR_A0_t            RXMUX_LAST_HDR_A0;             /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd32[3];                   
  NI_HV_GLB_RXMUX_PKTCNT_t                 RXMUX_PKTCNT;                  /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd33[3];                   
  NI_HV_GLB_RXMUX_PORT0_FC_THRESHOLD_CFG_t RXMUX_PORT0_FC_THRESHOLD_CFG;  /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd34[47];                  
  NI_HV_GLB_RX_P11_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t RX_P11_SEG_BUF_TOP_BOTTOM_ADDR_CFG; /* addr: 0x000000e4 */
  ca_uint32_t                              rsrvd35[3];                   
  NI_HV_GLB_RX_P10_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t RX_P10_SEG_BUF_TOP_BOTTOM_ADDR_CFG; /* addr: 0x000000e8 */
  ca_uint32_t                              rsrvd36[3];                   
  NI_HV_GLB_RX_P9_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t RX_P9_SEG_BUF_TOP_BOTTOM_ADDR_CFG; /* addr: 0x000000ec */
  ca_uint32_t                              rsrvd37[3];                   
  NI_HV_GLB_RX_P8_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t RX_P8_SEG_BUF_TOP_BOTTOM_ADDR_CFG; /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd38[3];                   
  NI_HV_GLB_RX_P7_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t RX_P7_SEG_BUF_TOP_BOTTOM_ADDR_CFG; /* addr: 0x000000f4 */
  ca_uint32_t                              rsrvd39[3];                   
  NI_HV_GLB_RX_P6_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t RX_P6_SEG_BUF_TOP_BOTTOM_ADDR_CFG; /* addr: 0x000000f8 */
  ca_uint32_t                              rsrvd40[3];                   
  NI_HV_GLB_RX_P5_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t RX_P5_SEG_BUF_TOP_BOTTOM_ADDR_CFG; /* addr: 0x000000fc */
  ca_uint32_t                              rsrvd41[3];                   
  NI_HV_GLB_RX_P4_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t RX_P4_SEG_BUF_TOP_BOTTOM_ADDR_CFG; /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd42[3];                   
  NI_HV_GLB_RX_P3_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t RX_P3_SEG_BUF_TOP_BOTTOM_ADDR_CFG; /* addr: 0x00000104 */
  ca_uint32_t                              rsrvd43[3];                   
  NI_HV_GLB_RX_P2_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t RX_P2_SEG_BUF_TOP_BOTTOM_ADDR_CFG; /* addr: 0x00000108 */
  ca_uint32_t                              rsrvd44[3];                   
  NI_HV_GLB_RX_P1_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t RX_P1_SEG_BUF_TOP_BOTTOM_ADDR_CFG; /* addr: 0x0000010c */
  ca_uint32_t                              rsrvd45[3];                   
  NI_HV_GLB_RX_P0_SEG_BUF_TOP_BOTTOM_ADDR_CFG_t RX_P0_SEG_BUF_TOP_BOTTOM_ADDR_CFG; /* addr: 0x00000110 */
  ca_uint32_t                              rsrvd46[3];                   
  NI_HV_GLB_RX_SEG_BUFSIZE_UPDATE_t        RX_SEG_BUFSIZE_UPDATE;         /* addr: 0x00000114 */
  ca_uint32_t                              rsrvd47[3];                   
  NI_HV_GLB_RX_SEG_VLAN_TAG_INSERT_CFG_t   RX_SEG_VLAN_TAG_INSERT_CFG;    /* addr: 0x00000118 */
  ca_uint32_t                              rsrvd48[3];                   
  NI_HV_GLB_RXMUX_HDR_BUF_STATUS_t         RXMUX_HDR_BUF_STATUS;          /* addr: 0x0000011c */
  ca_uint32_t                              rsrvd49[3];                   
  NI_HV_GLB_RXMUX_DATA_BUF_STATUS_t        RXMUX_DATA_BUF_STATUS;         /* addr: 0x00000120 */
  ca_uint32_t                              rsrvd50[3];                   
  NI_HV_GLB_RXMUX_DBG_CFG_t                RXMUX_DBG_CFG;                 /* addr: 0x00000124 */
  ca_uint32_t                              rsrvd51[3];                   
  NI_HV_GLB_RXMUX_OUT_CNT0_t               RXMUX_OUT_CNT0;                /* addr: 0x00000128 */
  ca_uint32_t                              rsrvd52[3];                   
  NI_HV_GLB_RXMUX_OUT_CNT1_t               RXMUX_OUT_CNT1;                /* addr: 0x0000012c */
  ca_uint32_t                              rsrvd53[3];                   
  NI_HV_GLB_RXMUX_OUT_DRPCNT0_t            RXMUX_OUT_DRPCNT0;             /* addr: 0x00000130 */
  ca_uint32_t                              rsrvd54[3];                   
  NI_HV_GLB_RXMUX_OUT_DRPCNT1_t            RXMUX_OUT_DRPCNT1;             /* addr: 0x00000134 */
  ca_uint32_t                              rsrvd55[3];                   
  NI_HV_GLB_NIRX_XRAM_STS_t                NIRX_XRAM_STS;                 /* addr: 0x00000138 */
  ca_uint32_t                              rsrvd56[3];                   
  NI_HV_GLB_NIRX_L3QM_STS_t                NIRX_L3QM_STS;                 /* addr: 0x0000013c */
  ca_uint32_t                              rsrvd57[3];                   
  NI_HV_GLB_NIRX_L3FE_STS_t                NIRX_L3FE_STS;                 /* addr: 0x00000140 */
  ca_uint32_t                              rsrvd58[3];                   
  NI_HV_GLB_P0_RX_DROPCNT_t                P0_RX_DROPCNT;                 /* addr: 0x00000144 */
  ca_uint32_t                              rsrvd59[31];                  
  NI_HV_GLB_P0_TX_SHARE_FIFO_BASE_CFG_t    P0_TX_SHARE_FIFO_BASE_CFG;     /* addr: 0x00000164 */
  ca_uint32_t                              rsrvd60[3];                   
  NI_HV_GLB_P1_TX_SHARE_FIFO_BASE_CFG_t    P1_TX_SHARE_FIFO_BASE_CFG;     /* addr: 0x00000168 */
  ca_uint32_t                              rsrvd61[3];                   
  NI_HV_GLB_P2_TX_SHARE_FIFO_BASE_CFG_t    P2_TX_SHARE_FIFO_BASE_CFG;     /* addr: 0x0000016c */
  ca_uint32_t                              rsrvd62[3];                   
  NI_HV_GLB_P3_TX_SHARE_FIFO_BASE_CFG_t    P3_TX_SHARE_FIFO_BASE_CFG;     /* addr: 0x00000170 */
  ca_uint32_t                              rsrvd63[3];                   
  NI_HV_GLB_P4_TX_SHARE_FIFO_BASE_CFG_t    P4_TX_SHARE_FIFO_BASE_CFG;     /* addr: 0x00000174 */
  ca_uint32_t                              rsrvd64[3];                   
  NI_HV_GLB_MCE_TX_SHARE_FIFO_BASE_CFG_t   MCE_TX_SHARE_FIFO_BASE_CFG;    /* addr: 0x00000178 */
  ca_uint32_t                              rsrvd65[3];                   
  NI_HV_GLB_PG_DA_CFG0_t                   PG_DA_CFG0;                    /* addr: 0x0000017c */
  ca_uint32_t                              rsrvd66[3];                   
  NI_HV_GLB_PG_DA_CFG1_t                   PG_DA_CFG1;                    /* addr: 0x00000180 */
  ca_uint32_t                              rsrvd67[3];                   
  NI_HV_GLB_PG_SA_CFG0_t                   PG_SA_CFG0;                    /* addr: 0x00000184 */
  ca_uint32_t                              rsrvd68[3];                   
  NI_HV_GLB_PG_SA_CFG1_t                   PG_SA_CFG1;                    /* addr: 0x00000188 */
  ca_uint32_t                              rsrvd69[3];                   
  NI_HV_GLB_PG_CFG0_t                      PG_CFG0;                       /* addr: 0x0000018c */
  ca_uint32_t                              rsrvd70[3];                   
  NI_HV_GLB_PG_CFG1_t                      PG_CFG1;                       /* addr: 0x00000190 */
  ca_uint32_t                              rsrvd71[3];                   
  NI_HV_GLB_PG_FXPT_CFG_t                  PG_FXPT_CFG;                   /* addr: 0x00000194 */
  ca_uint32_t                              rsrvd72[3];                   
  NI_HV_GLB_PC_DA1_t                       PC_DA1;                        /* addr: 0x00000198 */
  ca_uint32_t                              rsrvd73[3];                   
  NI_HV_GLB_PC_DA2_t                       PC_DA2;                        /* addr: 0x0000019c */
  ca_uint32_t                              rsrvd74[3];                   
  NI_HV_GLB_PC_SA1_t                       PC_SA1;                        /* addr: 0x000001a0 */
  ca_uint32_t                              rsrvd75[3];                   
  NI_HV_GLB_PC_SA2_t                       PC_SA2;                        /* addr: 0x000001a4 */
  ca_uint32_t                              rsrvd76[3];                   
  NI_HV_GLB_PC_CFG0_t                      PC_CFG0;                       /* addr: 0x000001a8 */
  ca_uint32_t                              rsrvd77[3];                   
  NI_HV_GLB_PC_CFG1_t                      PC_CFG1;                       /* addr: 0x000001ac */
  ca_uint32_t                              rsrvd78[3];                   
  NI_HV_GLB_PC_FXPT_t                      PC_FXPT;                       /* addr: 0x000001b0 */
  ca_uint32_t                              rsrvd79[3];                   
  NI_HV_GLB_RM_CFG_t                       RM_CFG;                        /* addr: 0x000001b4 */
  ca_uint32_t                              rsrvd80[3];                   
  NI_HV_GLB_RM_TBMAX_t                     RM_TBMAX;                      /* addr: 0x000001b8 */
  ca_uint32_t                              rsrvd81[3];                   
  NI_HV_GLB_RM_CNTR_t                      RM_CNTR;                       /* addr: 0x000001bc */
  ca_uint32_t                              rsrvd82[3];                   
  NI_HV_GLB_RM_LASTCNTR_t                  RM_LASTCNTR;                   /* addr: 0x000001c0 */
  ca_uint32_t                              rsrvd83[3];                   
  NI_HV_GLB_RXMIB_ACCESS_t                 RXMIB_ACCESS;                  /* addr: 0x000001c4 */
  ca_uint32_t                              rsrvd84[3];                   
  NI_HV_GLB_RXMIB_DATA1_t                  RXMIB_DATA1;                   /* addr: 0x000001c8 */
  ca_uint32_t                              rsrvd85[3];                   
  NI_HV_GLB_RXMIB_DATA0_t                  RXMIB_DATA0;                   /* addr: 0x000001cc */
  ca_uint32_t                              rsrvd86[3];                   
  NI_HV_GLB_TXMIB_ACCESS_t                 TXMIB_ACCESS;                  /* addr: 0x000001d0 */
  ca_uint32_t                              rsrvd87[3];                   
  NI_HV_GLB_TXMIB_DATA1_t                  TXMIB_DATA1;                   /* addr: 0x000001d4 */
  ca_uint32_t                              rsrvd88[3];                   
  NI_HV_GLB_TXMIB_DATA0_t                  TXMIB_DATA0;                   /* addr: 0x000001d8 */
  ca_uint32_t                              rsrvd89[3];                   
  NI_HV_GLB_INTERNAL_PORT_ID_CFG_t         INTERNAL_PORT_ID_CFG;          /* addr: 0x000001dc */
  ca_uint32_t                              rsrvd90[3];                   
  NI_HV_GLB_INTERNAL_PORT_ID_CFG2_t        INTERNAL_PORT_ID_CFG2;         /* addr: 0x000001e0 */
  ca_uint32_t                              rsrvd91[3];                   
  NI_HV_GLB_RX_PORT_ID_CFG_t               RX_PORT_ID_CFG;                /* addr: 0x000001e4 */
  ca_uint32_t                              rsrvd92[3];                   
  NI_HV_GLB_RX_PORT_ID_CFG2_t              RX_PORT_ID_CFG2;               /* addr: 0x000001e8 */
  ca_uint32_t                              rsrvd93[3];                   
  NI_HV_GLB_NIRX_L3FE_DEMUX_CFG3_t         NIRX_L3FE_DEMUX_CFG3;          /* addr: 0x000001ec */
  ca_uint32_t                              rsrvd94[3];                   
  NI_HV_GLB_NIRX_L3FE_DEMUX_CFG2_t         NIRX_L3FE_DEMUX_CFG2;          /* addr: 0x000001f0 */
  ca_uint32_t                              rsrvd95[3];                   
  NI_HV_GLB_NIRX_L3FE_DEMUX_CFG1_t         NIRX_L3FE_DEMUX_CFG1;          /* addr: 0x000001f4 */
  ca_uint32_t                              rsrvd96[3];                   
  NI_HV_GLB_NIRX_L3FE_DEMUX_CFG0_t         NIRX_L3FE_DEMUX_CFG0;          /* addr: 0x000001f8 */
  ca_uint32_t                              rsrvd97[3];                   
  NI_HV_GLB_NIRX_L3FE_DPQ_DEMUX_CFG3_t     NIRX_L3FE_DPQ_DEMUX_CFG3;      /* addr: 0x000001fc */
  ca_uint32_t                              rsrvd98[3];                   
  NI_HV_GLB_NIRX_L3FE_DPQ_DEMUX_CFG2_t     NIRX_L3FE_DPQ_DEMUX_CFG2;      /* addr: 0x00000200 */
  ca_uint32_t                              rsrvd99[3];                   
  NI_HV_GLB_NIRX_L3FE_DPQ_DEMUX_CFG1_t     NIRX_L3FE_DPQ_DEMUX_CFG1;      /* addr: 0x00000204 */
  ca_uint32_t                              rsrvd100[3];                  
  NI_HV_GLB_NIRX_L3FE_DPQ_DEMUX_CFG0_t     NIRX_L3FE_DPQ_DEMUX_CFG0;      /* addr: 0x00000208 */
  ca_uint32_t                              rsrvd101[3];                  
  NI_HV_GLB_NITX_MISC_CFG_t                NITX_MISC_CFG;                 /* addr: 0x0000020c */
  ca_uint32_t                              rsrvd102[3];                  
  NI_HV_GLB_NIRX_MISC_CFG_t                NIRX_MISC_CFG;                 /* addr: 0x00000210 */
  ca_uint32_t                              rsrvd103[3];                  
  NI_HV_GLB_TX_PORT_ID_CFG_t               TX_PORT_ID_CFG;                /* addr: 0x00000214 */
  ca_uint32_t                              rsrvd104[3];                  
  NI_HV_GLB_TX_INTERNAL_PORT_ID_CFG_t      TX_INTERNAL_PORT_ID_CFG;       /* addr: 0x00000218 */
  ca_uint32_t                              rsrvd105[3];                  
  NI_HV_GLB_TX_INTERNAL_PORT_ID_CFG2_t     TX_INTERNAL_PORT_ID_CFG2;      /* addr: 0x0000021c */
  ca_uint32_t                              rsrvd106[3];                  
  NI_HV_GLB_NITX_CRCE_CNT_t                NITX_CRCE_CNT;                 /* addr: 0x00000220 */
  ca_uint32_t                              rsrvd107[3];                  
  NI_HV_GLB_NITX_P5_DRAINCNT_t             NITX_P5_DRAINCNT;              /* addr: 0x00000224 */
  ca_uint32_t                              rsrvd108[3];                  
  NI_HV_GLB_NITX_P6_DRAINCNT_t             NITX_P6_DRAINCNT;              /* addr: 0x00000228 */
  ca_uint32_t                              rsrvd109[3];                  
  NI_HV_GLB_NITX_P7_DRAINCNT_t             NITX_P7_DRAINCNT;              /* addr: 0x0000022c */
  ca_uint32_t                              rsrvd110[3];                  
  NI_HV_GLB_NITX_OAMERR_CNT_t              NITX_OAMERR_CNT;               /* addr: 0x00000230 */
  ca_uint32_t                              rsrvd111[3];                  
  NI_HV_GLB_TXFIFO_READ_THRESHOLD_t        TXFIFO_READ_THRESHOLD;         /* addr: 0x00000234 */
  ca_uint32_t                              rsrvd112[3];                  
  NI_HV_GLB_TXFIFO_THRESHOLD_XGE7_CFG1_t   TXFIFO_THRESHOLD_XGE7_CFG1;    /* addr: 0x00000238 */
  ca_uint32_t                              rsrvd113[3];                  
  NI_HV_GLB_TXFIFO_THRESHOLD_XGE7_CFG2_t   TXFIFO_THRESHOLD_XGE7_CFG2;    /* addr: 0x0000023c */
  ca_uint32_t                              rsrvd114[3];                  
  NI_HV_GLB_TXFIFO_THRESHOLD_L3QM_CFG1_t   TXFIFO_THRESHOLD_L3QM_CFG1;    /* addr: 0x00000240 */
  ca_uint32_t                              rsrvd115[3];                  
  NI_HV_GLB_TXFIFO_THRESHOLD_L3QM_CFG2_t   TXFIFO_THRESHOLD_L3QM_CFG2;    /* addr: 0x00000244 */
  ca_uint32_t                              rsrvd116[3];                  
  NI_HV_GLB_TXFIFO_THRESHOLD_L3FE_CFG1_t   TXFIFO_THRESHOLD_L3FE_CFG1;    /* addr: 0x00000248 */
  ca_uint32_t                              rsrvd117[3];                  
  NI_HV_GLB_TXFIFO_THRESHOLD_L3FE_CFG2_t   TXFIFO_THRESHOLD_L3FE_CFG2;    /* addr: 0x0000024c */
  ca_uint32_t                              rsrvd118[3];                  
  NI_HV_GLB_TXFIFO_THRESHOLD_MISC_CFG_t    TXFIFO_THRESHOLD_MISC_CFG;     /* addr: 0x00000250 */
  ca_uint32_t                              rsrvd119[3];                  
  NI_HV_GLB_TXFIFO_THRESHOLD_MISC_CFG2_t   TXFIFO_THRESHOLD_MISC_CFG2;    /* addr: 0x00000254 */
  ca_uint32_t                              rsrvd120[3];                  
  NI_HV_GLB_TXFIFO_THRESHOLD_MISC_CFG3_t   TXFIFO_THRESHOLD_MISC_CFG3;    /* addr: 0x00000258 */
  ca_uint32_t                              rsrvd121[3];                  
  NI_HV_GLB_TXFIFO_MCE_THRESHOLD_CFG_t     TXFIFO_MCE_THRESHOLD_CFG;      /* addr: 0x0000025c */
  ca_uint32_t                              rsrvd122[3];                  
  NI_HV_GLB_RXFIFO_THRESHOLD_MISC_CFG_t    RXFIFO_THRESHOLD_MISC_CFG;     /* addr: 0x00000260 */
  ca_uint32_t                              rsrvd123[3];                  
  NI_HV_GLB_RXFIFO_XGE6_THRESHOLD_CFG_t    RXFIFO_XGE6_THRESHOLD_CFG;     /* addr: 0x00000264 */
  ca_uint32_t                              rsrvd124[3];                  
  NI_HV_GLB_NIRX_L3QM_THRESHOLD_CFG_t      NIRX_L3QM_THRESHOLD_CFG;       /* addr: 0x00000268 */
  ca_uint32_t                              rsrvd125[3];                  
  NI_HV_GLB_PTP_TX_CFG_t                   PTP_TX_CFG;                    /* addr: 0x0000026c */
  ca_uint32_t                              rsrvd126[3];                  
  NI_HV_GLB_GE_PTP_ASYM_CFG_01_t           GE_PTP_ASYM_CFG_01;            /* addr: 0x00000270 */
  ca_uint32_t                              rsrvd127[3];                  
  NI_HV_GLB_GE_PTP_ASYM_CFG_00_t           GE_PTP_ASYM_CFG_00;            /* addr: 0x00000274 */
  ca_uint32_t                              rsrvd128[3];                  
  NI_HV_GLB_GE_PTP_ASYM_CFG_11_t           GE_PTP_ASYM_CFG_11;            /* addr: 0x00000278 */
  ca_uint32_t                              rsrvd129[3];                  
  NI_HV_GLB_GE_PTP_ASYM_CFG_10_t           GE_PTP_ASYM_CFG_10;            /* addr: 0x0000027c */
  ca_uint32_t                              rsrvd130[3];                  
  NI_HV_GLB_GE_PTP_ASYM_CFG_21_t           GE_PTP_ASYM_CFG_21;            /* addr: 0x00000280 */
  ca_uint32_t                              rsrvd131[3];                  
  NI_HV_GLB_GE_PTP_ASYM_CFG_20_t           GE_PTP_ASYM_CFG_20;            /* addr: 0x00000284 */
  ca_uint32_t                              rsrvd132[3];                  
  NI_HV_GLB_GE_PTP_ASYM_CFG_31_t           GE_PTP_ASYM_CFG_31;            /* addr: 0x00000288 */
  ca_uint32_t                              rsrvd133[3];                  
  NI_HV_GLB_GE_PTP_ASYM_CFG_30_t           GE_PTP_ASYM_CFG_30;            /* addr: 0x0000028c */
  ca_uint32_t                              rsrvd134[3];                  
  NI_HV_GLB_XAUI_PTP_ASYM_CFG_01_t         XAUI_PTP_ASYM_CFG_01;          /* addr: 0x00000290 */
  ca_uint32_t                              rsrvd135[3];                  
  NI_HV_GLB_XAUI_PTP_ASYM_CFG_00_t         XAUI_PTP_ASYM_CFG_00;          /* addr: 0x00000294 */
  ca_uint32_t                              rsrvd136[3];                  
  NI_HV_GLB_XAUI_PTP_ASYM_CFG_11_t         XAUI_PTP_ASYM_CFG_11;          /* addr: 0x00000298 */
  ca_uint32_t                              rsrvd137[3];                  
  NI_HV_GLB_XAUI_PTP_ASYM_CFG_10_t         XAUI_PTP_ASYM_CFG_10;          /* addr: 0x0000029c */
  ca_uint32_t                              rsrvd138[3];                  
  NI_HV_GLB_XAUI_PTP_ASYM_CFG_21_t         XAUI_PTP_ASYM_CFG_21;          /* addr: 0x000002a0 */
  ca_uint32_t                              rsrvd139[3];                  
  NI_HV_GLB_XAUI_PTP_ASYM_CFG_20_t         XAUI_PTP_ASYM_CFG_20;          /* addr: 0x000002a4 */
  ca_uint32_t                              rsrvd140[3];                  
  NI_HV_GLB_XAUI_PTP_ASYM_CFG_31_t         XAUI_PTP_ASYM_CFG_31;          /* addr: 0x000002a8 */
  ca_uint32_t                              rsrvd141[3];                  
  NI_HV_GLB_XAUI_PTP_ASYM_CFG_30_t         XAUI_PTP_ASYM_CFG_30;          /* addr: 0x000002ac */
  ca_uint32_t                              rsrvd142[3];                  
  NI_HV_GLB_XGE_PTP_ASYM_CFG_01_t          XGE_PTP_ASYM_CFG_01;           /* addr: 0x000002b0 */
  ca_uint32_t                              rsrvd143[3];                  
  NI_HV_GLB_XGE_PTP_ASYM_CFG_00_t          XGE_PTP_ASYM_CFG_00;           /* addr: 0x000002b4 */
  ca_uint32_t                              rsrvd144[3];                  
  NI_HV_GLB_XGE_PTP_ASYM_CFG_11_t          XGE_PTP_ASYM_CFG_11;           /* addr: 0x000002b8 */
  ca_uint32_t                              rsrvd145[3];                  
  NI_HV_GLB_XGE_PTP_ASYM_CFG_10_t          XGE_PTP_ASYM_CFG_10;           /* addr: 0x000002bc */
  ca_uint32_t                              rsrvd146[3];                  
  NI_HV_GLB_XGE_PTP_ASYM_CFG_21_t          XGE_PTP_ASYM_CFG_21;           /* addr: 0x000002c0 */
  ca_uint32_t                              rsrvd147[3];                  
  NI_HV_GLB_XGE_PTP_ASYM_CFG_20_t          XGE_PTP_ASYM_CFG_20;           /* addr: 0x000002c4 */
  ca_uint32_t                              rsrvd148[3];                  
  NI_HV_GLB_XGE_PTP_ASYM_CFG_31_t          XGE_PTP_ASYM_CFG_31;           /* addr: 0x000002c8 */
  ca_uint32_t                              rsrvd149[3];                  
  NI_HV_GLB_XGE_PTP_ASYM_CFG_30_t          XGE_PTP_ASYM_CFG_30;           /* addr: 0x000002cc */
  ca_uint32_t                              rsrvd150[3];                  
  NI_HV_GLB_P0_PTP_TX_TIMESTAMP_t          P0_PTP_TX_TIMESTAMP;           /* addr: 0x000002d0 */
  ca_uint32_t                              rsrvd151[31];                 
  NI_HV_GLB_NITX_STS_t                     NITX_STS;                      /* addr: 0x000002f0 */
  ca_uint32_t                              rsrvd152[3];                  
  NI_HV_GLB_SPARE_t                        SPARE;                         /* addr: 0x000002f4 */
  ca_uint32_t                              rsrvd153[3];                  
  NI_HV_GLB_MISC_STS_t                     MISC_STS;                      /* addr: 0x000002f8 */
  ca_uint32_t                              rsrvd154[3];                  
  NI_HV_GLB_SPARESAMPLE_t                  SPARESAMPLE;                   /* addr: 0x000002fc */
  ca_uint32_t                              rsrvd155[3];                  
  NI_HV_GLB_PORT_0_INTERRUPT_t             PORT_0_INTERRUPT;              /* addr: 0x00000300 */
  ca_uint32_t                              rsrvd156[3];                  
  NI_HV_GLB_PORT_0_INTERRUPTE_t            PORT_0_INTERRUPTE;             /* addr: 0x00000304 */
  ca_uint32_t                              rsrvd157[35];                 
  NI_HV_GLB_PORT_5_INTERRUPT_t             PORT_5_INTERRUPT;              /* addr: 0x00000328 */
  ca_uint32_t                              rsrvd158[3];                  
  NI_HV_GLB_PORT_5_INTERRUPTE_t            PORT_5_INTERRUPTE;             /* addr: 0x0000032c */
  ca_uint32_t                              rsrvd159[19];                 
  NI_HV_GLB_PORT_8_INTERRUPT_t             PORT_8_INTERRUPT;              /* addr: 0x00000340 */
  ca_uint32_t                              rsrvd160[3];                  
  NI_HV_GLB_PORT_8_INTERRUPTE_t            PORT_8_INTERRUPTE;             /* addr: 0x00000344 */
  ca_uint32_t                              rsrvd161[27];                 
  NI_HV_GLB_NIFIFO_INTERRUPT_t             NIFIFO_INTERRUPT;              /* addr: 0x00000360 */
  ca_uint32_t                              rsrvd162[3];                  
  NI_HV_GLB_NIFIFO_INTERRUPTE_t            NIFIFO_INTERRUPTE;             /* addr: 0x00000364 */
  ca_uint32_t                              rsrvd163[3];                  
  NI_HV_GLB_MISC_INTERRUPT_t               MISC_INTERRUPT;                /* addr: 0x00000368 */
  ca_uint32_t                              rsrvd164[3];                  
  NI_HV_GLB_MISC_INTERRUPTE_t              MISC_INTERRUPTE;               /* addr: 0x0000036c */
  ca_uint32_t                              rsrvd165[3];                  
  NI_HV_GLB_TXEM_INTERRUPT_t               TXEM_INTERRUPT;                /* addr: 0x00000370 */
  ca_uint32_t                              rsrvd166[3];                  
  NI_HV_GLB_TXEM_INTERRUPTE_t              TXEM_INTERRUPTE;               /* addr: 0x00000374 */
  ca_uint32_t                              rsrvd167[3];                  
  NI_HV_GLB_PC0_INTERRUPT_t                PC0_INTERRUPT;                 /* addr: 0x00000378 */
  ca_uint32_t                              rsrvd168[3];                  
  NI_HV_GLB_PC0_INTERRUPTE_t               PC0_INTERRUPTE;                /* addr: 0x0000037c */
  ca_uint32_t                              rsrvd169[35];                 
  NI_HV_GLB_CPUXRAM_CNTR_INTERRUPT_t       CPUXRAM_CNTR_INTERRUPT;        /* addr: 0x000003a0 */
  ca_uint32_t                              rsrvd170[3];                  
  NI_HV_GLB_CPUXRAM_CNTR_INTERRUPTE_t      CPUXRAM_CNTR_INTERRUPTE;       /* addr: 0x000003a4 */
  ca_uint32_t                              rsrvd171[3];                  
  NI_HV_GLB_CPUXRAM_ERR_INTERRUPT_t        CPUXRAM_ERR_INTERRUPT;         /* addr: 0x000003a8 */
  ca_uint32_t                              rsrvd172[3];                  
  NI_HV_GLB_CPUXRAM_ERR_INTERRUPTE_t       CPUXRAM_ERR_INTERRUPTE;        /* addr: 0x000003ac */
  ca_uint32_t                              rsrvd173[3];                  
  NI_HV_GLB_PTP_INTERRUPT_t                PTP_INTERRUPT;                 /* addr: 0x000003b0 */
  ca_uint32_t                              rsrvd174[3];                  
  NI_HV_GLB_PTP_INTERRUPTE_t               PTP_INTERRUPTE;                /* addr: 0x000003b4 */
  ca_uint32_t                              rsrvd175[3];                  
  NI_HV_GLB_CPUXRAM_RXPKT_INTERRUPT_t      CPUXRAM_RXPKT_INTERRUPT;       /* addr: 0x000003b8 */
  ca_uint32_t                              rsrvd176[3];                  
  NI_HV_GLB_CPUXRAM_RXPKT_INTERRUPTE_t     CPUXRAM_RXPKT_INTERRUPTE;      /* addr: 0x000003bc */
  ca_uint32_t                              rsrvd177[3];                  
  NI_HV_GLB_CPUXRAM_TXPKT_INTERRUPT_t      CPUXRAM_TXPKT_INTERRUPT;       /* addr: 0x000003c0 */
  ca_uint32_t                              rsrvd178[3];                  
  NI_HV_GLB_CPUXRAM_TXPKT_INTERRUPTE_t     CPUXRAM_TXPKT_INTERRUPTE;      /* addr: 0x000003c4 */
  ca_uint32_t                              rsrvd179[3];                  
  NI_HV_GLB_MC_INTERRUPT_t                 MC_INTERRUPT;                  /* addr: 0x000003c8 */
  ca_uint32_t                              rsrvd180[3];                  
  NI_HV_GLB_MC_INTERRUPTE_t                MC_INTERRUPTE;                 /* addr: 0x000003cc */
  ca_uint32_t                              rsrvd181[3];                  
  NI_HV_GLB_INTERRUPT_t                    INTERRUPT;                     /* addr: 0x000003d0 */
  ca_uint32_t                              rsrvd182[3];                  
  NI_HV_GLB_INTERRUPTE_t                   INTERRUPTE;                    /* addr: 0x000003d4 */
  ca_uint32_t                              rsrvd183[3];                  
  NI_HV_GLB_ETH_TX_MISC_CFG_t              ETH_TX_MISC_CFG;               /* addr: 0x000003d8 */
  ca_uint32_t                              rsrvd184[3];                  
  NI_HV_GLB_DEBUG_2_t                      DEBUG_2;                       /* addr: 0x000003dc */
  ca_uint32_t                              rsrvd185[3];                  
  NI_HV_GLB_DEBUG_3_t                      DEBUG_3;                       /* addr: 0x000003e0 */
} APB0_NI_HV_GLB_t;


/*
 * PT[0..4]
 */
        
#define NI_HV_PT_PORT_STATIC_CFG                 0xf4304400
#define NI_HV_PT_PORT_STATIC_CFG_dft             0x00000200

typedef volatile union {
  struct {
    ca_uint32_t int_cfg              :  4 ; /* bits 3:0 */
    ca_uint32_t phy_mode             :  1 ; /* bits 4:4 */
    ca_uint32_t rmii_clksrc          :  1 ; /* bits 5:5 */
    ca_uint32_t inv_clk_in           :  1 ; /* bits 6:6 */
    ca_uint32_t inv_clk_out          :  1 ; /* bits 7:7 */
    ca_uint32_t inv_rxclk_out        :  1 ; /* bits 8:8 */
    ca_uint32_t tx_use_gefifo        :  1 ; /* bits 9:9 */
    ca_uint32_t smii_tx_stat         :  1 ; /* bits 10:10 */
    ca_uint32_t crs_polarity         :  1 ; /* bits 11:11 */
    ca_uint32_t lpbk_mode            :  2 ; /* bits 13:12 */
    ca_uint32_t gmii_like_half_duplex_en :  1 ; /* bits 14:14 */
    ca_uint32_t sup_tx_to_rx_lpbk_data :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t mac_addr6            :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_PT_PORT_STATIC_CFG_t;

#define     int_cfg_GMII_GE                               0x0
#define     int_cfg_MII                                   0x1
#define     int_cfg_RGMII_GE                              0x2
#define     int_cfg_RGMII_FE                              0x3

#define NI_HV_PT_PORT_GLB_CFG                    0xf4304404
#define NI_HV_PT_PORT_GLB_CFG_dft                0x00000004

typedef volatile union {
  struct {
    ca_uint32_t speed                :  1 ; /* bits 0:0 */
    ca_uint32_t duplex               :  1 ; /* bits 1:1 */
    ca_uint32_t link_status          :  1 ; /* bits 2:2 */
    ca_uint32_t link_stat_mask       :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t power_dwn_rx         :  1 ; /* bits 11:11 */
    ca_uint32_t power_dwn_tx         :  1 ; /* bits 12:12 */
    ca_uint32_t tx_intf_lp_time      :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd2               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_PT_PORT_GLB_CFG_t;


#define NI_HV_PT_RXMAC_CFG                       0xf4304408
#define NI_HV_PT_RXMAC_CFG_dft                   0x00000101

typedef volatile union {
  struct {
    ca_uint32_t rx_en                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t rx_flow_disable      :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t rx_flow_to_tx_en     :  1 ; /* bits 12:12 */
    ca_uint32_t rx_pfc_disable       :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd3               : 15 ;
    ca_uint32_t send_pg_data         :  1 ; /* bits 29:29 */
    ca_uint32_t rsrvd4               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_PT_RXMAC_CFG_t;


#define NI_HV_PT_RXMAC_WOL_CFG                   0xf430440c
#define NI_HV_PT_RXMAC_WOL_CFG_dft               0x00000f00

typedef volatile union {
  struct {
    ca_uint32_t wol_pkt_det_en       :  1 ; /* bits 0:0 */
    ca_uint32_t wol_chk_da           :  2 ; /* bits 2:1 */
    ca_uint32_t wol_ign_err          :  1 ; /* bits 3:3 */
    ca_uint32_t wol_secure_on        :  1 ; /* bits 4:4 */
    ca_uint32_t wol_passwd_cnt       :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t wol_mac_adr_cnt      :  6 ; /* bits 13:8 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t wol_passwd6          :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd3               :  7 ;
    ca_uint32_t wol_wake_on_any_pkt  :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_PT_RXMAC_WOL_CFG_t;


#define NI_HV_PT_MAC_STATUS                      0xf4304410
#define NI_HV_PT_MAC_STATUS_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rcv_speed            :  2 ; /* bits 1:0 */
    ca_uint32_t rcv_duplex           :  1 ; /* bits 2:2 */
    ca_uint32_t rcv_lnk_stat         :  1 ; /* bits 3:3 */
    ca_uint32_t rx_lpi_detect        :  1 ; /* bits 4:4 */
    ca_uint32_t lpi_assert           :  1 ; /* bits 5:5 */
    ca_uint32_t lpi_mac_dis          :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_PT_MAC_STATUS_t;


#define NI_HV_PT_TXMAC_CFG                       0xf4304414
#define NI_HV_PT_TXMAC_CFG_dft                   0x04019901

typedef volatile union {
  struct {
    ca_uint32_t tx_en                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t mac_crc_calc_en      :  1 ; /* bits 8:8 */
    ca_uint32_t tx_ipg_sel           :  3 ; /* bits 11:9 */
    ca_uint32_t tx_flow_disable      :  1 ; /* bits 12:12 */
    ca_uint32_t tx_drain             :  1 ; /* bits 13:13 */
    ca_uint32_t tx_pfc_disable       :  1 ; /* bits 14:14 */
    ca_uint32_t tx_pau_sel           :  2 ; /* bits 16:15 */
    ca_uint32_t rsrvd2               :  9 ;
    ca_uint32_t tx_auto_xon          :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t pass_thru_hdr        :  1 ; /* bits 28:28 */
    ca_uint32_t rsrvd4               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_PT_TXMAC_CFG_t;


#define NI_HV_PT_ETH_TXMAC_PAUSE_TIMER_CFG0      0xf4304418
#define NI_HV_PT_ETH_TXMAC_PAUSE_TIMER_CFG0_dft  0x00ff00ff

typedef volatile union {
  struct {
    ca_uint32_t txpfc_time_0         : 16 ; /* bits 15:0 */
    ca_uint32_t txpfc_time_1         : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_PT_ETH_TXMAC_PAUSE_TIMER_CFG0_t;


#define NI_HV_PT_ETH_TXMAC_PAUSE_TIMER_CFG1      0xf430441c
#define NI_HV_PT_ETH_TXMAC_PAUSE_TIMER_CFG1_dft  0x00ff00ff

typedef volatile union {
  struct {
    ca_uint32_t txpfc_time_2         : 16 ; /* bits 15:0 */
    ca_uint32_t txpfc_time_3         : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_PT_ETH_TXMAC_PAUSE_TIMER_CFG1_t;


#define NI_HV_PT_ETH_TXMAC_PAUSE_TIMER_CFG2      0xf4304420
#define NI_HV_PT_ETH_TXMAC_PAUSE_TIMER_CFG2_dft  0x00ff00ff

typedef volatile union {
  struct {
    ca_uint32_t txpfc_time_4         : 16 ; /* bits 15:0 */
    ca_uint32_t txpfc_time_5         : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_PT_ETH_TXMAC_PAUSE_TIMER_CFG2_t;


#define NI_HV_PT_ETH_TXMAC_PAUSE_TIMER_CFG3      0xf4304424
#define NI_HV_PT_ETH_TXMAC_PAUSE_TIMER_CFG3_dft  0x00ff00ff

typedef volatile union {
  struct {
    ca_uint32_t txpfc_time_6         : 16 ; /* bits 15:0 */
    ca_uint32_t txpfc_time_7         : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_PT_ETH_TXMAC_PAUSE_TIMER_CFG3_t;


#define NI_HV_PT_EEE_LPI_CFG0                    0xf4304428
#define NI_HV_PT_EEE_LPI_CFG0_dft                0x01387000

typedef volatile union {
  struct {
    ca_uint32_t tx_eee_enable        :  1 ; /* bits 0:0 */
    ca_uint32_t cpu_lpi_deassert     :  1 ; /* bits 1:1 */
    ca_uint32_t stop_txclk_on_lpi    :  1 ; /* bits 2:2 */
    ca_uint32_t lpi_data_mode        :  1 ; /* bits 3:3 */
    ca_uint32_t lpi_mode_te          :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t txfifo_empty_cnt     : 20 ; /* bits 31:12 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_PT_EEE_LPI_CFG0_t;


#define NI_HV_PT_EEE_LPI_CFG1                    0xf430442c
#define NI_HV_PT_EEE_LPI_CFG1_dft                0x0000071b

typedef volatile union {
  struct {
    ca_uint32_t lpi_min_assert_cnt   : 20 ; /* bits 19:0 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_PT_EEE_LPI_CFG1_t;


#define NI_HV_PT_EEE_LPI_CFG2                    0xf4304430
#define NI_HV_PT_EEE_LPI_CFG2_dft                0x000000a4

typedef volatile union {
  struct {
    ca_uint32_t lpi_min_wakeup_cnt   : 20 ; /* bits 19:0 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_PT_EEE_LPI_CFG2_t;


#define NI_HV_PT_EEE_LPI_CFG3                    0xf4304434
#define NI_HV_PT_EEE_LPI_CFG3_dft                0x0f000005

typedef volatile union {
  struct {
    ca_uint32_t lpi_mac_dis_wait_cnt : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t stop_txclk_en_cnt    : 12 ; /* bits 31:20 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_PT_EEE_LPI_CFG3_t;


#define NI_HV_PT_RX_CNTRL_CFG                    0xf4304438
#define NI_HV_PT_RX_CNTRL_CFG_dft                0x08000400

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t ff_overrun_drop_dis  :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t crc_drop_dis         :  1 ; /* bits 4:4 */
    ca_uint32_t ovr_drop_dis         :  1 ; /* bits 5:5 */
    ca_uint32_t runt_drop_dis        :  1 ; /* bits 6:6 */
    ca_uint32_t flow_drop_dis        :  1 ; /* bits 7:7 */
    ca_uint32_t ukopcode_drop_dis    :  1 ; /* bits 8:8 */
    ca_uint32_t oam_drop_dis         :  1 ; /* bits 9:9 */
    ca_uint32_t linkstat_drop_dis    :  1 ; /* bits 10:10 */
    ca_uint32_t pfc_drop_dis         :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd3               :  4 ;
    ca_uint32_t rxctrl_byp_dpid      :  6 ; /* bits 21:16 */
    ca_uint32_t rsrvd4               :  2 ;
    ca_uint32_t rxctrl_byp_cos       :  3 ; /* bits 26:24 */
    ca_uint32_t rxctrl_byp_dpq       :  1 ; /* bits 27:27 */
    ca_uint32_t rxctrl_byp_en        :  1 ; /* bits 28:28 */
    ca_uint32_t rsrvd5               :  1 ;
    ca_uint32_t rxctrl_byp_mir       :  1 ; /* bits 30:30 */
    ca_uint32_t rxctrl_byp_ndrp      :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_PT_RX_CNTRL_CFG_t;


#define NI_HV_PT_TXFIFO_THLD_CFG                 0xf430443c
#define NI_HV_PT_TXFIFO_THLD_CFG_dft             0x00280064

typedef volatile union {
  struct {
    ca_uint32_t high_thld            : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               :  6 ;
    ca_uint32_t low_thld             : 10 ; /* bits 25:16 */
    ca_uint32_t rsrvd2               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_PT_TXFIFO_THLD_CFG_t;


#define NI_HV_PT_PG_CFG0                         0xf4304440
#define NI_HV_PT_PG_CFG0_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pg_da6               :  8 ; /* bits 7:0 */
    ca_uint32_t pg_sa6               :  8 ; /* bits 15:8 */
    ca_uint32_t pg_type              : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_PT_PG_CFG0_t;


#define NI_HV_PT_PG_CFG1                         0xf4304444
#define NI_HV_PT_PG_CFG1_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pg_vlan1             : 16 ; /* bits 15:0 */
    ca_uint32_t pg_vlan2             : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_PT_PG_CFG1_t;


#define NI_HV_PT_PG_CNTRL_CFG                    0xf4304448
#define NI_HV_PT_PG_CNTRL_CFG_dft                0x08018000

typedef volatile union {
  struct {
    ca_uint32_t pg_en                :  1 ; /* bits 0:0 */
    ca_uint32_t pg_fixedcount        :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t pg_fixedlen          :  1 ; /* bits 4:4 */
    ca_uint32_t pg_insvlan2          :  1 ; /* bits 5:5 */
    ca_uint32_t pg_insvlan1          :  1 ; /* bits 6:6 */
    ca_uint32_t pg_instype           :  1 ; /* bits 7:7 */
    ca_uint32_t pg_insseqnum         :  1 ; /* bits 8:8 */
    ca_uint32_t pg_invpat            :  1 ; /* bits 9:9 */
    ca_uint32_t pg_insfixpattern     :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd2               :  4 ;
    ca_uint32_t pg_linerate          :  9 ; /* bits 23:15 */
    ca_uint32_t pg_ipg               :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_PT_PG_CNTRL_CFG_t;


#define NI_HV_PT_PC_CFG1                         0xf430444c
#define NI_HV_PT_PC_CFG1_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pc_da6               :  8 ; /* bits 7:0 */
    ca_uint32_t pc_sa6               :  8 ; /* bits 15:8 */
    ca_uint32_t pc_type              : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_PT_PC_CFG1_t;


#define NI_HV_PT_PC_CFG2                         0xf4304450
#define NI_HV_PT_PC_CFG2_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pc_vlan1             : 16 ; /* bits 15:0 */
    ca_uint32_t pc_vlan2             : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_PT_PC_CFG2_t;


#define NI_HV_PT_PC_CNTRL                        0xf4304454
#define NI_HV_PT_PC_CNTRL_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pc_en                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t pc_fixedlen          :  1 ; /* bits 4:4 */
    ca_uint32_t pc_expvlan2          :  1 ; /* bits 5:5 */
    ca_uint32_t pc_expvlan1          :  1 ; /* bits 6:6 */
    ca_uint32_t pc_exptype           :  1 ; /* bits 7:7 */
    ca_uint32_t pc_expseqnum         :  1 ; /* bits 8:8 */
    ca_uint32_t pc_invpat            :  1 ; /* bits 9:9 */
    ca_uint32_t pc_expfixpattern     :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd2               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_PT_PC_CNTRL_t;


#define NI_HV_PT_PC_STAT                         0xf4304458
#define NI_HV_PT_PC_STAT_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pc_dchkstatus        :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_PT_PC_STAT_t;


#define NI_HV_PT_DEBUG_1                         0xf430445c
#define NI_HV_PT_DEBUG_1_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hd_backoff_cnt       : 10 ; /* bits 9:0 */
    ca_uint32_t hd_backoff_dbg       :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd1               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_PT_DEBUG_1_t;


#define NI_HV_PT_TX_DRAINCNT                     0xf4304460
#define NI_HV_PT_TX_DRAINCNT_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t CNT                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_PT_TX_DRAINCNT_t;


#define NI_HV_PT_SPARE                           0xf4304464
#define NI_HV_PT_SPARE_dft                       0x0000ff00

typedef volatile union {
  struct {
    ca_uint32_t VALUE                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_PT_SPARE_t;


#define NI_HV_PT_SPARESAMPLE                     0xf4304468
#define NI_HV_PT_SPARESAMPLE_dft                 0x0000ff00

typedef volatile union {
  struct {
    ca_uint32_t VALUE                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_PT_SPARESAMPLE_t;

    
#define APB0_NI_HV_PT_STRIDE                     160
#define APB0_NI_HV_PT_COUNT                      5
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PT */
typedef struct {
  NI_HV_PT_PORT_STATIC_CFG_t               PORT_STATIC_CFG;               /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  NI_HV_PT_PORT_GLB_CFG_t                  PORT_GLB_CFG;                  /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  NI_HV_PT_RXMAC_CFG_t                     RXMAC_CFG;                     /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  NI_HV_PT_RXMAC_WOL_CFG_t                 RXMAC_WOL_CFG;                 /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  NI_HV_PT_MAC_STATUS_t                    MAC_STATUS;                    /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  NI_HV_PT_TXMAC_CFG_t                     TXMAC_CFG;                     /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  NI_HV_PT_ETH_TXMAC_PAUSE_TIMER_CFG0_t    ETH_TXMAC_PAUSE_TIMER_CFG0;    /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  NI_HV_PT_ETH_TXMAC_PAUSE_TIMER_CFG1_t    ETH_TXMAC_PAUSE_TIMER_CFG1;    /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  NI_HV_PT_ETH_TXMAC_PAUSE_TIMER_CFG2_t    ETH_TXMAC_PAUSE_TIMER_CFG2;    /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  NI_HV_PT_ETH_TXMAC_PAUSE_TIMER_CFG3_t    ETH_TXMAC_PAUSE_TIMER_CFG3;    /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  NI_HV_PT_EEE_LPI_CFG0_t                  EEE_LPI_CFG0;                  /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  NI_HV_PT_EEE_LPI_CFG1_t                  EEE_LPI_CFG1;                  /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  NI_HV_PT_EEE_LPI_CFG2_t                  EEE_LPI_CFG2;                  /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  NI_HV_PT_EEE_LPI_CFG3_t                  EEE_LPI_CFG3;                  /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  NI_HV_PT_RX_CNTRL_CFG_t                  RX_CNTRL_CFG;                  /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  NI_HV_PT_TXFIFO_THLD_CFG_t               TXFIFO_THLD_CFG;               /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  NI_HV_PT_PG_CFG0_t                       PG_CFG0;                       /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  NI_HV_PT_PG_CFG1_t                       PG_CFG1;                       /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  NI_HV_PT_PG_CNTRL_CFG_t                  PG_CNTRL_CFG;                  /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  NI_HV_PT_PC_CFG1_t                       PC_CFG1;                       /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  NI_HV_PT_PC_CFG2_t                       PC_CFG2;                       /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  NI_HV_PT_PC_CNTRL_t                      PC_CNTRL;                      /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  NI_HV_PT_PC_STAT_t                       PC_STAT;                       /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  NI_HV_PT_DEBUG_1_t                       DEBUG_1;                       /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  NI_HV_PT_TX_DRAINCNT_t                   TX_DRAINCNT;                   /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  NI_HV_PT_SPARE_t                         SPARE;                         /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  NI_HV_PT_SPARESAMPLE_t                   SPARESAMPLE;                   /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[55];                  
} APB0_NI_HV_PT_t;


/*
 * INTPT[0..3]
 */
        
#define NI_HV_INTPT_RX_CNTRL_CFG                 0xf4304720
#define NI_HV_INTPT_RX_CNTRL_CFG_dft             0x00028000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 14 ;
    ca_uint32_t rx_rate              :  8 ; /* bits 21:14 */
    ca_uint32_t rsrvd2               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_INTPT_RX_CNTRL_CFG_t;


#define NI_HV_INTPT_RX_MISSING_SOP_EOP_CNT       0xf4304724
#define NI_HV_INTPT_RX_MISSING_SOP_EOP_CNT_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_missing_eop_pkt_cnt : 16 ; /* bits 15:0 */
    ca_uint32_t rx_missing_sop_pkt_cnt : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_INTPT_RX_MISSING_SOP_EOP_CNT_t;


#define NI_HV_INTPT_RX_SHORT_ERR_CNT             0xf4304728
#define NI_HV_INTPT_RX_SHORT_ERR_CNT_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_err_pkt_cnt       : 16 ; /* bits 15:0 */
    ca_uint32_t rx_short_pkt_cnt     : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_INTPT_RX_SHORT_ERR_CNT_t;


#define NI_HV_INTPT_RX_PKT_CNT                   0xf430472c
#define NI_HV_INTPT_RX_PKT_CNT_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_pkt_cnt           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_INTPT_RX_PKT_CNT_t;


#define NI_HV_INTPT_RX_PKT_BYTE_HI_CNT           0xf4304730
#define NI_HV_INTPT_RX_PKT_BYTE_HI_CNT_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_pkt_cnt           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_INTPT_RX_PKT_BYTE_HI_CNT_t;


#define NI_HV_INTPT_RX_PKT_BYTE_LO_CNT           0xf4304734
#define NI_HV_INTPT_RX_PKT_BYTE_LO_CNT_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_pkt_cnt           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_INTPT_RX_PKT_BYTE_LO_CNT_t;


#define NI_HV_INTPT_TX_MISSING_SOP_EOP_CNT       0xf4304738
#define NI_HV_INTPT_TX_MISSING_SOP_EOP_CNT_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_missing_eop_pkt_cnt : 16 ; /* bits 15:0 */
    ca_uint32_t tx_missing_sop_pkt_cnt : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_INTPT_TX_MISSING_SOP_EOP_CNT_t;


#define NI_HV_INTPT_TX_SHORT_ERR_CNT             0xf430473c
#define NI_HV_INTPT_TX_SHORT_ERR_CNT_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_err_pkt_cnt       : 16 ; /* bits 15:0 */
    ca_uint32_t tx_short_pkt_cnt     : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_INTPT_TX_SHORT_ERR_CNT_t;


#define NI_HV_INTPT_TX_PKT_CNT                   0xf4304740
#define NI_HV_INTPT_TX_PKT_CNT_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_pkt_cnt           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_INTPT_TX_PKT_CNT_t;


#define NI_HV_INTPT_TX_PKT_BYTE_HI_CNT           0xf4304744
#define NI_HV_INTPT_TX_PKT_BYTE_HI_CNT_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_pkt_cnt           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_INTPT_TX_PKT_BYTE_HI_CNT_t;


#define NI_HV_INTPT_TX_PKT_BYTE_LO_CNT           0xf4304748
#define NI_HV_INTPT_TX_PKT_BYTE_LO_CNT_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_pkt_cnt           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_INTPT_TX_PKT_BYTE_LO_CNT_t;

    
#define APB0_NI_HV_INTPT_STRIDE                  64
#define APB0_NI_HV_INTPT_COUNT                   4
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* INTPT */
typedef struct {
  NI_HV_INTPT_RX_CNTRL_CFG_t               RX_CNTRL_CFG;                  /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  NI_HV_INTPT_RX_MISSING_SOP_EOP_CNT_t     RX_MISSING_SOP_EOP_CNT;        /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  NI_HV_INTPT_RX_SHORT_ERR_CNT_t           RX_SHORT_ERR_CNT;              /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  NI_HV_INTPT_RX_PKT_CNT_t                 RX_PKT_CNT;                    /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  NI_HV_INTPT_RX_PKT_BYTE_HI_CNT_t         RX_PKT_BYTE_HI_CNT;            /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  NI_HV_INTPT_RX_PKT_BYTE_LO_CNT_t         RX_PKT_BYTE_LO_CNT;            /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  NI_HV_INTPT_TX_MISSING_SOP_EOP_CNT_t     TX_MISSING_SOP_EOP_CNT;        /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  NI_HV_INTPT_TX_SHORT_ERR_CNT_t           TX_SHORT_ERR_CNT;              /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  NI_HV_INTPT_TX_PKT_CNT_t                 TX_PKT_CNT;                    /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  NI_HV_INTPT_TX_PKT_BYTE_HI_CNT_t         TX_PKT_BYTE_HI_CNT;            /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  NI_HV_INTPT_TX_PKT_BYTE_LO_CNT_t         TX_PKT_BYTE_LO_CNT;            /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[23];                  
} APB0_NI_HV_INTPT_t;


/*
 * XRAM
 */
        
#define NI_HV_XRAM_CPUXRAM_ADRCFG_RX             0xf4304820
#define NI_HV_XRAM_CPUXRAM_ADRCFG_RX_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_base_addr         : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               :  6 ;
    ca_uint32_t rx_top_addr          : 10 ; /* bits 25:16 */
    ca_uint32_t rsrvd2               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XRAM_CPUXRAM_ADRCFG_RX_t;


#define NI_HV_XRAM_CPUXRAM_ADRCFG_TX_0           0xf4304824
#define NI_HV_XRAM_CPUXRAM_ADRCFG_TX_0_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_base_addr         : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               :  6 ;
    ca_uint32_t tx_top_addr          : 10 ; /* bits 25:16 */
    ca_uint32_t rsrvd2               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XRAM_CPUXRAM_ADRCFG_TX_0_t;


#define NI_HV_XRAM_CPUXRAM_CFG                   0xf4304828
#define NI_HV_XRAM_CPUXRAM_CFG_dft               0x0000c001

typedef volatile union {
  struct {
    ca_uint32_t rx_0_cpu_pkt_dis     :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t tx_0_cpu_pkt_dis     :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t rx_x_drop_err_pkt    :  1 ; /* bits 11:11 */
    ca_uint32_t xram_mgmt_dis_drop_ovsz_pkt :  1 ; /* bits 12:12 */
    ca_uint32_t xram_mgmt_term_large_pkt :  1 ; /* bits 13:13 */
    ca_uint32_t xram_mgmt_promisc_mode :  2 ; /* bits 15:14 */
    ca_uint32_t xram_cntr_debug_mode :  1 ; /* bits 16:16 */
    ca_uint32_t xram_cntr_op_code    :  2 ; /* bits 18:17 */
    ca_uint32_t rsrvd3               :  2 ;
    ca_uint32_t xram_rx_mgmtfifo_srst :  1 ; /* bits 21:21 */
    ca_uint32_t xram_dma_fifo_srst   :  1 ; /* bits 22:22 */
    ca_uint32_t rsrvd4               :  9 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XRAM_CPUXRAM_CFG_t;


#define NI_HV_XRAM_CPUXRAM_CPU_CFG_RX_0          0xf430482c
#define NI_HV_XRAM_CPUXRAM_CPU_CFG_RX_0_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt_rd_ptr           : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XRAM_CPUXRAM_CPU_CFG_RX_0_t;


#define NI_HV_XRAM_CPUXRAM_CPU_STA_RX_0          0xf4304830
#define NI_HV_XRAM_CPUXRAM_CPU_STA_RX_0_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt_wr_ptr           : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t int_colsc_thresh_reached :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd2               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XRAM_CPUXRAM_CPU_STA_RX_0_t;


#define NI_HV_XRAM_CPUXRAM_INT_COLSC_CFG_0       0xf4304834
#define NI_HV_XRAM_CPUXRAM_INT_COLSC_CFG_0_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t int_colsc_dly_time   : 20 ; /* bits 19:0 */
    ca_uint32_t int_colsc_pkt        : 10 ; /* bits 29:20 */
    ca_uint32_t int_colsc_first_en   :  1 ; /* bits 30:30 */
    ca_uint32_t int_colsc_en         :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XRAM_CPUXRAM_INT_COLSC_CFG_0_t;


#define NI_HV_XRAM_CPUXRAM_PKT_CNT_0             0xf4304838
#define NI_HV_XRAM_CPUXRAM_PKT_CNT_0_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt_to_xram          : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XRAM_CPUXRAM_PKT_CNT_0_t;


#define NI_HV_XRAM_CPUXRAM_BYT_CNT_0             0xf430483c
#define NI_HV_XRAM_CPUXRAM_BYT_CNT_0_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t byt_to_xram          : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XRAM_CPUXRAM_BYT_CNT_0_t;


#define NI_HV_XRAM_CPUXRAM_PKT_ERR_DRP_0         0xf4304840
#define NI_HV_XRAM_CPUXRAM_PKT_ERR_DRP_0_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt_drop_err         : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XRAM_CPUXRAM_PKT_ERR_DRP_0_t;


#define NI_HV_XRAM_CPUXRAM_CPU_CFG_TX_0          0xf4304844
#define NI_HV_XRAM_CPUXRAM_CPU_CFG_TX_0_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt_wr_ptr           : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XRAM_CPUXRAM_CPU_CFG_TX_0_t;


#define NI_HV_XRAM_CPUXRAM_CPU_STAT_TX_0         0xf4304848
#define NI_HV_XRAM_CPUXRAM_CPU_STAT_TX_0_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt_rd_ptr           : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XRAM_CPUXRAM_CPU_STAT_TX_0_t;


#define NI_HV_XRAM_DMA_PKT_CNT                   0xf430484c
#define NI_HV_XRAM_DMA_PKT_CNT_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dma_pkt_to_cpu       : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XRAM_DMA_PKT_CNT_t;


#define NI_HV_XRAM_DMA_BYTE_CNT                  0xf4304850
#define NI_HV_XRAM_DMA_BYTE_CNT_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dma_byte_to_cpu      : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XRAM_DMA_BYTE_CNT_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* XRAM */
typedef struct {
  NI_HV_XRAM_CPUXRAM_ADRCFG_RX_t           CPUXRAM_ADRCFG_RX;             /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  NI_HV_XRAM_CPUXRAM_ADRCFG_TX_0_t         CPUXRAM_ADRCFG_TX_0;           /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  NI_HV_XRAM_CPUXRAM_CFG_t                 CPUXRAM_CFG;                   /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  NI_HV_XRAM_CPUXRAM_CPU_CFG_RX_0_t        CPUXRAM_CPU_CFG_RX_0;          /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  NI_HV_XRAM_CPUXRAM_CPU_STA_RX_0_t        CPUXRAM_CPU_STA_RX_0;          /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  NI_HV_XRAM_CPUXRAM_INT_COLSC_CFG_0_t     CPUXRAM_INT_COLSC_CFG_0;       /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  NI_HV_XRAM_CPUXRAM_PKT_CNT_0_t           CPUXRAM_PKT_CNT_0;             /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  NI_HV_XRAM_CPUXRAM_BYT_CNT_0_t           CPUXRAM_BYT_CNT_0;             /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  NI_HV_XRAM_CPUXRAM_PKT_ERR_DRP_0_t       CPUXRAM_PKT_ERR_DRP_0;         /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  NI_HV_XRAM_CPUXRAM_CPU_CFG_TX_0_t        CPUXRAM_CPU_CFG_TX_0;          /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  NI_HV_XRAM_CPUXRAM_CPU_STAT_TX_0_t       CPUXRAM_CPU_STAT_TX_0;         /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  NI_HV_XRAM_DMA_PKT_CNT_t                 DMA_PKT_CNT;                   /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  NI_HV_XRAM_DMA_BYTE_CNT_t                DMA_BYTE_CNT;                  /* addr: 0x00000030 */
} APB0_NI_HV_XRAM_t;


/*
 * MCE
 */
        
#define NI_HV_MCE_CTL_REG                        0xf4304860
#define NI_HV_MCE_CTL_REG_dft                    0x0002f0ff

typedef volatile union {
  struct {
    ca_uint32_t ff_thrshd            : 10 ; /* bits 9:0 */
    ca_uint32_t min_pktsize          :  6 ; /* bits 15:10 */
    ca_uint32_t crc_err_drop_en      :  1 ; /* bits 16:16 */
    ca_uint32_t cp_lspid_to_pol_id_en :  1 ; /* bits 17:17 */
    ca_uint32_t buf_flush_en         :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_MCE_CTL_REG_t;


#define NI_HV_MCE_INDX_LKUP_ACCESS               0xf4304864
#define NI_HV_MCE_INDX_LKUP_ACCESS_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_MCE_INDX_LKUP_ACCESS_t;


#define NI_HV_MCE_INDX_LKUP_DATA1                0xf4304868
#define NI_HV_MCE_INDX_LKUP_DATA1_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mc_vec               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_MCE_INDX_LKUP_DATA1_t;


#define NI_HV_MCE_INDX_LKUP_DATA0                0xf430486c
#define NI_HV_MCE_INDX_LKUP_DATA0_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mc_vec               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_MCE_INDX_LKUP_DATA0_t;


#define NI_HV_MCE_ZERO_BITMAP_DROP_CNT           0xf4304870
#define NI_HV_MCE_ZERO_BITMAP_DROP_CNT_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_MCE_ZERO_BITMAP_DROP_CNT_t;


#define NI_HV_MCE_INGRESS_CNT                    0xf4304874
#define NI_HV_MCE_INGRESS_CNT_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_MCE_INGRESS_CNT_t;


#define NI_HV_MCE_EGRESS_CNT                     0xf4304878
#define NI_HV_MCE_EGRESS_CNT_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_MCE_EGRESS_CNT_t;


#define NI_HV_MCE_LAST_IN_HDR2                   0xf430487c
#define NI_HV_MCE_LAST_IN_HDR2_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hdr2                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_MCE_LAST_IN_HDR2_t;


#define NI_HV_MCE_LAST_IN_HDR1                   0xf4304880
#define NI_HV_MCE_LAST_IN_HDR1_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hdr1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_MCE_LAST_IN_HDR1_t;


#define NI_HV_MCE_LAST_IN_HDR0                   0xf4304884
#define NI_HV_MCE_LAST_IN_HDR0_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hdr0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_MCE_LAST_IN_HDR0_t;


#define NI_HV_MCE_LAST_OUT_HDR2                  0xf4304888
#define NI_HV_MCE_LAST_OUT_HDR2_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hdr2                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_MCE_LAST_OUT_HDR2_t;


#define NI_HV_MCE_LAST_OUT_HDR1                  0xf430488c
#define NI_HV_MCE_LAST_OUT_HDR1_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hdr1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_MCE_LAST_OUT_HDR1_t;


#define NI_HV_MCE_LAST_OUT_HDR0                  0xf4304890
#define NI_HV_MCE_LAST_OUT_HDR0_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hdr0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_MCE_LAST_OUT_HDR0_t;


#define NI_HV_MCE_ERROR_STS                      0xf4304894
#define NI_HV_MCE_ERROR_STS_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t flag                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_MCE_ERROR_STS_t;


#define NI_HV_MCE_ERROR_STS1                     0xf4304898
#define NI_HV_MCE_ERROR_STS1_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t flag                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_MCE_ERROR_STS1_t;


#define NI_HV_MCE_ERROR_STS2                     0xf430489c
#define NI_HV_MCE_ERROR_STS2_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t flag                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_MCE_ERROR_STS2_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* MCE */
typedef struct {
  NI_HV_MCE_CTL_REG_t                      CTL_REG;                       /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  NI_HV_MCE_INDX_LKUP_ACCESS_t             INDX_LKUP_ACCESS;              /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  NI_HV_MCE_INDX_LKUP_DATA1_t              INDX_LKUP_DATA1;               /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  NI_HV_MCE_INDX_LKUP_DATA0_t              INDX_LKUP_DATA0;               /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  NI_HV_MCE_ZERO_BITMAP_DROP_CNT_t         ZERO_BITMAP_DROP_CNT;          /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  NI_HV_MCE_INGRESS_CNT_t                  INGRESS_CNT;                   /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  NI_HV_MCE_EGRESS_CNT_t                   EGRESS_CNT;                    /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  NI_HV_MCE_LAST_IN_HDR2_t                 LAST_IN_HDR2;                  /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  NI_HV_MCE_LAST_IN_HDR1_t                 LAST_IN_HDR1;                  /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  NI_HV_MCE_LAST_IN_HDR0_t                 LAST_IN_HDR0;                  /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  NI_HV_MCE_LAST_OUT_HDR2_t                LAST_OUT_HDR2;                 /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  NI_HV_MCE_LAST_OUT_HDR1_t                LAST_OUT_HDR1;                 /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  NI_HV_MCE_LAST_OUT_HDR0_t                LAST_OUT_HDR0;                 /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  NI_HV_MCE_ERROR_STS_t                    ERROR_STS;                     /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  NI_HV_MCE_ERROR_STS1_t                   ERROR_STS1;                    /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  NI_HV_MCE_ERROR_STS2_t                   ERROR_STS2;                    /* addr: 0x0000003c */
} APB0_NI_HV_MCE_t;


/*
 * PTP
 */
        
#define NI_HV_PTP_PPS_CFG_0                      0xf43048a0
#define NI_HV_PTP_PPS_CFG_0_dft                  0x60000039

typedef volatile union {
  struct {
    ca_uint32_t ptp_en               :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t pps_in_en            :  1 ; /* bits 2:2 */
    ca_uint32_t pps_edge_sel_sample  :  1 ; /* bits 3:3 */
    ca_uint32_t pps_edge_sel_load    :  1 ; /* bits 4:4 */
    ca_uint32_t pps_load_en          :  1 ; /* bits 5:5 */
    ca_uint32_t pps_out_en           :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd2               :  9 ;
    ca_uint32_t pps_width            : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_PTP_PPS_CFG_0_t;


#define NI_HV_PTP_PPS_CFG_1                      0xf43048a4
#define NI_HV_PTP_PPS_CFG_1_dft                  0x80000000

typedef volatile union {
  struct {
    ca_uint32_t ptp_sum_val          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_PTP_PPS_CFG_1_t;


#define NI_HV_PTP_PPS_CFG_2                      0xf43048a8
#define NI_HV_PTP_PPS_CFG_2_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pps_timestamp_load   : 30 ; /* bits 29:0 */
    ca_uint32_t rsrvd1               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_PTP_PPS_CFG_2_t;


#define NI_HV_PTP_PPS_CFG_3                      0xf43048ac
#define NI_HV_PTP_PPS_CFG_3_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t s_pps                : 30 ; /* bits 29:0 */
    ca_uint32_t rsrvd1               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_PTP_PPS_CFG_3_t;


#define NI_HV_PTP_PPS_CFG_4                      0xf43048b0
#define NI_HV_PTP_PPS_CFG_4_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t s_tod                : 30 ; /* bits 29:0 */
    ca_uint32_t rsrvd1               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_PTP_PPS_CFG_4_t;


#define NI_HV_PTP_PPS_CFG_5                      0xf43048b4
#define NI_HV_PTP_PPS_CFG_5_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t load_matching_tmr    : 30 ; /* bits 29:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t load_matching_tmr_en :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_PTP_PPS_CFG_5_t;


#define NI_HV_PTP_TIMER_ON_PPS                   0xf43048b8
#define NI_HV_PTP_TIMER_ON_PPS_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pps_timestamp_sample : 30 ; /* bits 29:0 */
    ca_uint32_t rsrvd1               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_PTP_TIMER_ON_PPS_t;


#define NI_HV_PTP_TIMER                          0xf43048bc
#define NI_HV_PTP_TIMER_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ptp_hw_ts            : 30 ; /* bits 29:0 */
    ca_uint32_t rsrvd1               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_PTP_TIMER_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PTP */
typedef struct {
  NI_HV_PTP_PPS_CFG_0_t                    PPS_CFG_0;                     /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  NI_HV_PTP_PPS_CFG_1_t                    PPS_CFG_1;                     /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  NI_HV_PTP_PPS_CFG_2_t                    PPS_CFG_2;                     /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  NI_HV_PTP_PPS_CFG_3_t                    PPS_CFG_3;                     /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  NI_HV_PTP_PPS_CFG_4_t                    PPS_CFG_4;                     /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  NI_HV_PTP_PPS_CFG_5_t                    PPS_CFG_5;                     /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  NI_HV_PTP_TIMER_ON_PPS_t                 TIMER_ON_PPS;                  /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  NI_HV_PTP_TIMER_t                        TIMER;                         /* addr: 0x0000001c */
} APB0_NI_HV_PTP_t;


/*
 * XAUI
 */
  
/*
 * XGXS_TOP
 */
  
/*
 * xgxs_rx
 */
        
#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl0     0xf43048e0
#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t xgxs_rx_mode         :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t xgxs_rx_random_6     :  1 ; /* bits 3:3 */
    ca_uint32_t xgxs_rx_err_inj      :  4 ; /* bits 7:4 */
    ca_uint32_t xgxs_fpat_sel        :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd2               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl0_t;

#define     xgxs_fpat_sel_Register                        0x0
#define     xgxs_fpat_sel_High                            0x1
#define     xgxs_fpat_sel_Low                             0x2
#define     xgxs_fpat_sel_Mixed                           0x3
#define     xgxs_rx_mode_Data                             0x0
#define     xgxs_rx_mode_Frequency                        0x1
#define     xgxs_rx_mode_Random                           0x2
#define     xgxs_rx_mode_Jitter                           0x3

#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl1     0xf43048e4
#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t xgxs_fpat_0          :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl1_t;


#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl2     0xf43048e8
#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl2_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t xgxs_fpat_1          :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl2_t;


#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl3     0xf43048ec
#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl3_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t xgxs_fpat_2          :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl3_t;


#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl4     0xf43048f0
#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl4_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t xgxs_fpat_3          :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl4_t;


#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl5     0xf43048f4
#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl5_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t xgxs_rx_phase        :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t xgxs_rx_fzero        :  4 ; /* bits 11:8 */
    ca_uint32_t xgxs_rx_fone         :  4 ; /* bits 15:12 */
    ca_uint32_t rsrvd2               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl5_t;


#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_RX_INTSTAT   0xf43048f8
#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_RX_INTSTAT_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t ErrorPktSat          :  1 ; /* bits 1:1 */
    ca_uint32_t GoodPktSat           :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd2               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XGXS_TOP_XGXS_RX_RX_INTSTAT_t;


#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_RX_INTERRUPT 0xf43048fc
#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_RX_INTERRUPT_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ErrorPktI            :  1 ; /* bits 0:0 */
    ca_uint32_t ErrorPktSatI         :  1 ; /* bits 1:1 */
    ca_uint32_t GoodPktSatI          :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XGXS_TOP_XGXS_RX_RX_INTERRUPT_t;


#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_RX_INTENABLE 0xf4304900
#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_RX_INTENABLE_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ErrorPkte            :  1 ; /* bits 0:0 */
    ca_uint32_t ErrorPktSate         :  1 ; /* bits 1:1 */
    ca_uint32_t GoodPktSate          :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XGXS_TOP_XGXS_RX_RX_INTENABLE_t;


#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_GoodPkt      0xf4304904
#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_GoodPkt_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t good_pkt_rx          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XGXS_TOP_XGXS_RX_GoodPkt_t;


#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_ErrPkt       0xf4304908
#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_ErrPkt_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t err_pkt_rx           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XGXS_TOP_XGXS_RX_ErrPkt_t;


#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_SCRATCH      0xf430490c
#define NI_HV_XAUI_XGXS_TOP_XGXS_RX_SCRATCH_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t scratch              : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XGXS_TOP_XGXS_RX_SCRATCH_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* xgxs_rx */
typedef struct {
  NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl0_t   RxCntrl0;                      /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl1_t   RxCntrl1;                      /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl2_t   RxCntrl2;                      /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl3_t   RxCntrl3;                      /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl4_t   RxCntrl4;                      /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  NI_HV_XAUI_XGXS_TOP_XGXS_RX_RxCntrl5_t   RxCntrl5;                      /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  NI_HV_XAUI_XGXS_TOP_XGXS_RX_RX_INTSTAT_t RX_INTSTAT;                    /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  NI_HV_XAUI_XGXS_TOP_XGXS_RX_RX_INTERRUPT_t RX_INTERRUPT;                  /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  NI_HV_XAUI_XGXS_TOP_XGXS_RX_RX_INTENABLE_t RX_INTENABLE;                  /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  NI_HV_XAUI_XGXS_TOP_XGXS_RX_GoodPkt_t    GoodPkt;                       /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  NI_HV_XAUI_XGXS_TOP_XGXS_RX_ErrPkt_t     ErrPkt;                        /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  NI_HV_XAUI_XGXS_TOP_XGXS_RX_SCRATCH_t    SCRATCH;                       /* addr: 0x0000002c */
} APB0_NI_HV_XAUI_XGXS_TOP_XGXS_RX_t;


/*
 * xgxs_tx
 */
        
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl0     0xf4304920
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t xgxs_tx_mode         :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t xgxs_lf_enable       :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t xgxs_ddsa_enable     :  1 ; /* bits 7:7 */
    ca_uint32_t xgxs_fpat_sel        :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd3               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl0_t;

#define     xgxs_tx_mode_Data                             0x0
#define     xgxs_tx_mode_Frequency                        0x1
#define     xgxs_tx_mode_Random                           0x2
#define     xgxs_tx_mode_Jitter                           0x3

#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl1     0xf4304924
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t xgxs_fpat_0          :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl1_t;


#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl2     0xf4304928
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl2_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t xgxs_fpat_1          :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl2_t;


#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl3     0xf430492c
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl3_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t xgxs_fpat_2          :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl3_t;


#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl4     0xf4304930
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl4_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t xgxs_fpat_3          :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl4_t;


#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl5     0xf4304934
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl5_dft 0x00000a00

typedef volatile union {
  struct {
    ca_uint32_t rxaui_cgalign_ena_mode :  2 ; /* bits 1:0 */
    ca_uint32_t rxaui_a_column_ena_mode :  2 ; /* bits 3:2 */
    ca_uint32_t rxaui_a_column_verify_mode :  1 ; /* bits 4:4 */
    ca_uint32_t rxaui_lane_swap_01   :  1 ; /* bits 5:5 */
    ca_uint32_t rxaui_lane_swap_23   :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t rxaui_comma_thresh   :  6 ; /* bits 13:8 */
    ca_uint32_t rsrvd2               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl5_t;


#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_TX_INTSTAT   0xf4304938
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_TX_INTSTAT_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t ErrorPktSat          :  1 ; /* bits 1:1 */
    ca_uint32_t GoodPktSat           :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t InvCodeSat           :  1 ; /* bits 4:4 */
    ca_uint32_t xgxs_comma_found_0   :  1 ; /* bits 5:5 */
    ca_uint32_t PatErrSat            :  1 ; /* bits 6:6 */
    ca_uint32_t xgxs_comma_found_1   :  1 ; /* bits 7:7 */
    ca_uint32_t SyncDet0             :  1 ; /* bits 8:8 */
    ca_uint32_t SyncDet1             :  1 ; /* bits 9:9 */
    ca_uint32_t SyncDet2             :  1 ; /* bits 10:10 */
    ca_uint32_t SyncDet3             :  1 ; /* bits 11:11 */
    ca_uint32_t xgxs_align_det       :  1 ; /* bits 12:12 */
    ca_uint32_t xgxs_cpat_lock       :  1 ; /* bits 13:13 */
    ca_uint32_t xgxs_A_column_found_0 :  1 ; /* bits 14:14 */
    ca_uint32_t xgxs_A_column_found_1 :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd3               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_TX_INTSTAT_t;


#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_TX_INTERRUPT 0xf430493c
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_TX_INTERRUPT_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ErrorPktI            :  1 ; /* bits 0:0 */
    ca_uint32_t ErrorPktSatI         :  1 ; /* bits 1:1 */
    ca_uint32_t GoodPktSatI          :  1 ; /* bits 2:2 */
    ca_uint32_t InvCodeI             :  1 ; /* bits 3:3 */
    ca_uint32_t InvCodeSatI          :  1 ; /* bits 4:4 */
    ca_uint32_t PatErrI              :  1 ; /* bits 5:5 */
    ca_uint32_t PatErrSatI           :  1 ; /* bits 6:6 */
    ca_uint32_t comma_foundI         :  1 ; /* bits 7:7 */
    ca_uint32_t SyncDet0I            :  1 ; /* bits 8:8 */
    ca_uint32_t SyncDet1I            :  1 ; /* bits 9:9 */
    ca_uint32_t SyncDet2I            :  1 ; /* bits 10:10 */
    ca_uint32_t SyncDet3I            :  1 ; /* bits 11:11 */
    ca_uint32_t AlignDetI            :  1 ; /* bits 12:12 */
    ca_uint32_t PatLockDetI          :  1 ; /* bits 13:13 */
    ca_uint32_t A_column_found0I     :  1 ; /* bits 14:14 */
    ca_uint32_t A_column_found1I     :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_TX_INTERRUPT_t;


#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_TX_INTENABLE 0xf4304940
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_TX_INTENABLE_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ErrorPkte            :  1 ; /* bits 0:0 */
    ca_uint32_t ErrorPktSate         :  1 ; /* bits 1:1 */
    ca_uint32_t GoodPktSate          :  1 ; /* bits 2:2 */
    ca_uint32_t InvCodee             :  1 ; /* bits 3:3 */
    ca_uint32_t InvCodeSate          :  1 ; /* bits 4:4 */
    ca_uint32_t PatErre              :  1 ; /* bits 5:5 */
    ca_uint32_t PatErrSate           :  1 ; /* bits 6:6 */
    ca_uint32_t CommaFounde          :  1 ; /* bits 7:7 */
    ca_uint32_t SyncDet0e            :  1 ; /* bits 8:8 */
    ca_uint32_t SyncDet1e            :  1 ; /* bits 9:9 */
    ca_uint32_t SyncDet2e            :  1 ; /* bits 10:10 */
    ca_uint32_t SyncDet3e            :  1 ; /* bits 11:11 */
    ca_uint32_t AlignDete            :  1 ; /* bits 12:12 */
    ca_uint32_t PatLockDete          :  1 ; /* bits 13:13 */
    ca_uint32_t A_column_found0e     :  1 ; /* bits 14:14 */
    ca_uint32_t A_column_found1e     :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_TX_INTENABLE_t;


#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_GoodPkt      0xf4304944
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_GoodPkt_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t good_pkt_tx          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_GoodPkt_t;


#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_ErrPkt       0xf4304948
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_ErrPkt_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t err_pkt_tx           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_ErrPkt_t;


#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_ICC0         0xf430494c
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_ICC0_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t xgxs_icc_0           : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_ICC0_t;


#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_ICC1         0xf4304950
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_ICC1_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t xgxs_icc_1           : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_ICC1_t;


#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_ICC2         0xf4304954
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_ICC2_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t xgxs_icc_2           : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_ICC2_t;


#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_ICC3         0xf4304958
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_ICC3_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t xgxs_icc_3           : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_ICC3_t;


#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_PEC0         0xf430495c
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_PEC0_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t xgxs_pec_0           : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_PEC0_t;


#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_PEC1         0xf4304960
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_PEC1_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t xgxs_pec_1           : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_PEC1_t;


#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_PEC2         0xf4304964
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_PEC2_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t xgxs_pec_2           : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_PEC2_t;


#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_PEC3         0xf4304968
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_PEC3_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t xgxs_pec_3           : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_PEC3_t;


#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_SCRATCH      0xf430496c
#define NI_HV_XAUI_XGXS_TOP_XGXS_TX_SCRATCH_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t scratch              : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XGXS_TOP_XGXS_TX_SCRATCH_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* xgxs_tx */
typedef struct {
  NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl0_t   TxCntrl0;                      /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl1_t   TxCntrl1;                      /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl2_t   TxCntrl2;                      /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl3_t   TxCntrl3;                      /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl4_t   TxCntrl4;                      /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  NI_HV_XAUI_XGXS_TOP_XGXS_TX_TxCntrl5_t   TxCntrl5;                      /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  NI_HV_XAUI_XGXS_TOP_XGXS_TX_TX_INTSTAT_t TX_INTSTAT;                    /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  NI_HV_XAUI_XGXS_TOP_XGXS_TX_TX_INTERRUPT_t TX_INTERRUPT;                  /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  NI_HV_XAUI_XGXS_TOP_XGXS_TX_TX_INTENABLE_t TX_INTENABLE;                  /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  NI_HV_XAUI_XGXS_TOP_XGXS_TX_GoodPkt_t    GoodPkt;                       /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  NI_HV_XAUI_XGXS_TOP_XGXS_TX_ErrPkt_t     ErrPkt;                        /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  NI_HV_XAUI_XGXS_TOP_XGXS_TX_ICC0_t       ICC0;                          /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  NI_HV_XAUI_XGXS_TOP_XGXS_TX_ICC1_t       ICC1;                          /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  NI_HV_XAUI_XGXS_TOP_XGXS_TX_ICC2_t       ICC2;                          /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  NI_HV_XAUI_XGXS_TOP_XGXS_TX_ICC3_t       ICC3;                          /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  NI_HV_XAUI_XGXS_TOP_XGXS_TX_PEC0_t       PEC0;                          /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  NI_HV_XAUI_XGXS_TOP_XGXS_TX_PEC1_t       PEC1;                          /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  NI_HV_XAUI_XGXS_TOP_XGXS_TX_PEC2_t       PEC2;                          /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  NI_HV_XAUI_XGXS_TOP_XGXS_TX_PEC3_t       PEC3;                          /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  NI_HV_XAUI_XGXS_TOP_XGXS_TX_SCRATCH_t    SCRATCH;                       /* addr: 0x0000004c */
} APB0_NI_HV_XAUI_XGXS_TOP_XGXS_TX_t;

    
  
        
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* XGXS_TOP */

typedef struct {
  APB0_NI_HV_XAUI_XGXS_TOP_XGXS_RX_t       xgxs_rx;                       /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[41];                   
  APB0_NI_HV_XAUI_XGXS_TOP_XGXS_TX_t       xgxs_tx;                       /* addr: 0x00000040 */
} APB0_NI_HV_XAUI_XGXS_TOP_t;


/*
 * xaui_mac
 */
  
/*
 * ctrl
 */
        
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_INTERRUPT  0xf4304980
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_INTERRUPT_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rc_ffoverrun_intI    :  1 ; /* bits 0:0 */
    ca_uint32_t tc_espkterr_intI     :  1 ; /* bits 1:1 */
    ca_uint32_t rxestore0_intI       :  1 ; /* bits 2:2 */
    ca_uint32_t rxestore1_intI       :  1 ; /* bits 3:3 */
    ca_uint32_t rxestore2_intI       :  1 ; /* bits 4:4 */
    ca_uint32_t rxestore3_intI       :  1 ; /* bits 5:5 */
    ca_uint32_t txestore0_intI       :  1 ; /* bits 6:6 */
    ca_uint32_t txestore1_intI       :  1 ; /* bits 7:7 */
    ca_uint32_t txestore2_intI       :  1 ; /* bits 8:8 */
    ca_uint32_t txestore3_intI       :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               :  6 ;
    ca_uint32_t rc_ptp_pkt_intI      :  1 ; /* bits 16:16 */
    ca_uint32_t tc_ptp_pkt_intI      :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd2               :  6 ;
    ca_uint32_t tc_ffoverrun_intI    :  1 ; /* bits 24:24 */
    ca_uint32_t tx_asyncff_underrun_intI :  1 ; /* bits 25:25 */
    ca_uint32_t tx_asyncff_overrun_intI :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd3               :  5 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_INTERRUPT_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_INTERRUPTE 0xf4304984
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_INTERRUPTE_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rc_ffoverrun_intIE   :  1 ; /* bits 0:0 */
    ca_uint32_t tc_espkterr_intIE    :  1 ; /* bits 1:1 */
    ca_uint32_t rxestore0_intIE      :  1 ; /* bits 2:2 */
    ca_uint32_t rxestore1_intIE      :  1 ; /* bits 3:3 */
    ca_uint32_t rxestore2_intIE      :  1 ; /* bits 4:4 */
    ca_uint32_t rxestore3_intIE      :  1 ; /* bits 5:5 */
    ca_uint32_t txestore0_intIE      :  1 ; /* bits 6:6 */
    ca_uint32_t txestore1_intIE      :  1 ; /* bits 7:7 */
    ca_uint32_t txestore2_intIE      :  1 ; /* bits 8:8 */
    ca_uint32_t txestore3_intIE      :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               :  6 ;
    ca_uint32_t rc_ptp_pkt_intIE     :  1 ; /* bits 16:16 */
    ca_uint32_t tc_ptp_pkt_intIE     :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd2               :  6 ;
    ca_uint32_t tc_ffoverrun_intIE   :  1 ; /* bits 24:24 */
    ca_uint32_t tx_asyncff_underrun_intIE :  1 ; /* bits 25:25 */
    ca_uint32_t tx_asyncff_overrun_intIE :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd3               :  5 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_INTERRUPTE_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_CTRL_CFG        0xf4304988
#define NI_HV_XAUI_XAUI_MAC_CTRL_CTRL_CFG_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx2tx_lpbk_en        :  1 ; /* bits 0:0 */
    ca_uint32_t tx2rx_lpbk_en        :  1 ; /* bits 1:1 */
    ca_uint32_t rs_locfault_en       :  1 ; /* bits 2:2 */
    ca_uint32_t rs_rmtfault_en       :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_CTRL_CFG_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_BRIGE_CTRL      0xf430498c
#define NI_HV_XAUI_XAUI_MAC_CTRL_BRIGE_CTRL_dft  0xe4e40000

typedef volatile union {
  struct {
    ca_uint32_t flip_sds_xgxs_rx_en  :  1 ; /* bits 0:0 */
    ca_uint32_t flip_sds_xgxs_tx_en  :  1 ; /* bits 1:1 */
    ca_uint32_t pcs_line_swap_txd_en :  1 ; /* bits 2:2 */
    ca_uint32_t pcs_line_swap_rxd_en :  1 ; /* bits 3:3 */
    ca_uint32_t rx_invert_ctl        :  1 ; /* bits 4:4 */
    ca_uint32_t tx_invert_ctl        :  1 ; /* bits 5:5 */
    ca_uint32_t rx_data_resync0      :  1 ; /* bits 6:6 */
    ca_uint32_t rx_data_resync1      :  1 ; /* bits 7:7 */
    ca_uint32_t rx_data_resync2      :  1 ; /* bits 8:8 */
    ca_uint32_t rx_data_resync3      :  1 ; /* bits 9:9 */
    ca_uint32_t tx_data_resync0      :  1 ; /* bits 10:10 */
    ca_uint32_t tx_data_resync1      :  1 ; /* bits 11:11 */
    ca_uint32_t tx_data_resync2      :  1 ; /* bits 12:12 */
    ca_uint32_t tx_data_resync3      :  1 ; /* bits 13:13 */
    ca_uint32_t tx_scramble          :  1 ; /* bits 14:14 */
    ca_uint32_t rx_scramble          :  1 ; /* bits 15:15 */
    ca_uint32_t rxswap0              :  2 ; /* bits 17:16 */
    ca_uint32_t rxswap1              :  2 ; /* bits 19:18 */
    ca_uint32_t rxswap2              :  2 ; /* bits 21:20 */
    ca_uint32_t rxswap3              :  2 ; /* bits 23:22 */
    ca_uint32_t txswap0              :  2 ; /* bits 25:24 */
    ca_uint32_t txswap1              :  2 ; /* bits 27:26 */
    ca_uint32_t txswap2              :  2 ; /* bits 29:28 */
    ca_uint32_t txswap3              :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_BRIGE_CTRL_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_ADDRESS_H       0xf4304990
#define NI_HV_XAUI_XAUI_MAC_CTRL_ADDRESS_H_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_ADDRESS_H_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_ADDRESS_L       0xf4304994
#define NI_HV_XAUI_XAUI_MAC_CTRL_ADDRESS_L_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t address              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_ADDRESS_L_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_CTRL_MODE       0xf4304998
#define NI_HV_XAUI_XAUI_MAC_CTRL_CTRL_MODE_dft   0x40003601

typedef volatile union {
  struct {
    ca_uint32_t ctrl_mode_en         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t flush_pkt_en         :  5 ; /* bits 8:4 */
    ca_uint32_t flush_pkt_en1        :  1 ; /* bits 9:9 */
    ca_uint32_t flush_pkt_sdid       :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t pkt_tocsport_en      :  1 ; /* bits 12:12 */
    ca_uint32_t pkt_toupport_en      :  1 ; /* bits 13:13 */
    ca_uint32_t pkt_tocsport_toup    :  1 ; /* bits 14:14 */
    ca_uint32_t pkt_toupport_tocs    :  1 ; /* bits 15:15 */
    ca_uint32_t flush_touplink_pkt   :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd3               : 13 ;
    ca_uint32_t mask_nop_en          :  1 ; /* bits 30:30 */
    ca_uint32_t mask_ddbm_en         :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_CTRL_MODE_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_CTL     0xf430499c
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_CTL_dft 0x0007b800

typedef volatile union {
  struct {
    ca_uint32_t clr_rcffoverrun      :  1 ; /* bits 0:0 */
    ca_uint32_t drop_ptp_pkt_type    : 10 ; /* bits 10:1 */
    ca_uint32_t qbb_pause_drop_en    :  1 ; /* bits 11:11 */
    ca_uint32_t frame_error_drop_en  :  1 ; /* bits 12:12 */
    ca_uint32_t frame_fcs_error_drop_en :  1 ; /* bits 13:13 */
    ca_uint32_t frame_bytecnt_drop_en :  1 ; /* bits 14:14 */
    ca_uint32_t frame_pause_drop_en  :  1 ; /* bits 15:15 */
    ca_uint32_t frame_runt_drop_en   :  1 ; /* bits 16:16 */
    ca_uint32_t frame_oversize_drop_en :  1 ; /* bits 17:17 */
    ca_uint32_t frame_ffoverflow_drop_en :  1 ; /* bits 18:18 */
    ca_uint32_t frame_management_drop_en :  1 ; /* bits 19:19 */
    ca_uint32_t frame_nomanagement_drop_en :  1 ; /* bits 20:20 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t qbb_pause_det_en     :  1 ; /* bits 23:23 */
    ca_uint32_t bypass               :  1 ; /* bits 24:24 */
    ca_uint32_t ptp_ing_ts_cmp       :  5 ; /* bits 29:25 */
    ca_uint32_t rx_pkt_clr           :  1 ; /* bits 30:30 */
    ca_uint32_t ptp_da_en            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_CTL_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_DA_HI 0xf43049a0
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_DA_HI_dft 0x00000180

typedef volatile union {
  struct {
    ca_uint32_t management_da        : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_DA_HI_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_DA_LO 0xf43049a4
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_DA_LO_dft 0xc2000001

typedef volatile union {
  struct {
    ca_uint32_t management_da        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_DA_LO_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE0 0xf43049a8
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE0_dft 0x00008809

typedef volatile union {
  struct {
    ca_uint32_t management_type0     : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 15 ;
    ca_uint32_t det_type0_en         :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE0_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE1 0xf43049ac
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE1_dft 0x00008808

typedef volatile union {
  struct {
    ca_uint32_t management_type1     : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 15 ;
    ca_uint32_t det_type1_en         :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE1_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE2 0xf43049b0
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE2_dft 0x00008863

typedef volatile union {
  struct {
    ca_uint32_t management_type2     : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 15 ;
    ca_uint32_t det_type2_en         :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE2_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE3 0xf43049b4
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE3_dft 0x00008864

typedef volatile union {
  struct {
    ca_uint32_t management_type3     : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 15 ;
    ca_uint32_t det_type3_en         :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE3_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE4 0xf43049b8
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE4_dft 0x0000888e

typedef volatile union {
  struct {
    ca_uint32_t management_type4     : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 15 ;
    ca_uint32_t det_type4_en         :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE4_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE5 0xf43049bc
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE5_dft 0x00000806

typedef volatile union {
  struct {
    ca_uint32_t management_type5     : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 15 ;
    ca_uint32_t det_type5_en         :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE5_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE6 0xf43049c0
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE6_dft 0x0000814c

typedef volatile union {
  struct {
    ca_uint32_t management_type6     : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 15 ;
    ca_uint32_t det_type6_en         :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE6_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE7 0xf43049c4
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE7_dft 0x0000ffff

typedef volatile union {
  struct {
    ca_uint32_t management_type7     : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 15 ;
    ca_uint32_t det_type7_en         :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE7_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_FLOWON_CTL 0xf43049c8
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_FLOWON_CTL_dft 0x000001ff

typedef volatile union {
  struct {
    ca_uint32_t xon_threshold        : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_FLOWON_CTL_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_FLOWOFF_CTL 0xf43049cc
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_FLOWOFF_CTL_dft 0x000002ff

typedef volatile union {
  struct {
    ca_uint32_t xoff_threshold       : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_FLOWOFF_CTL_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_CTL     0xf43049d0
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_CTL_dft 0x00ff0000

typedef volatile union {
  struct {
    ca_uint32_t pau_flow_en          :  1 ; /* bits 0:0 */
    ca_uint32_t tx_remheader_dis     :  1 ; /* bits 1:1 */
    ca_uint32_t tx_pkt_clr           :  1 ; /* bits 2:2 */
    ca_uint32_t tx_pad_en            :  1 ; /* bits 3:3 */
    ca_uint32_t loopback             :  1 ; /* bits 4:4 */
    ca_uint32_t ptp_eg_ts_comp       :  5 ; /* bits 9:5 */
    ca_uint32_t external_pausereq_pol :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t qbb_flow_en          :  1 ; /* bits 15:15 */
    ca_uint32_t qbb_qen              :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t external_txstop_sel  :  1 ; /* bits 27:27 */
    ca_uint32_t internal_txstop_sel  :  1 ; /* bits 28:28 */
    ca_uint32_t external_pausereq_sel :  1 ; /* bits 29:29 */
    ca_uint32_t rx_pausereq_sel      :  1 ; /* bits 30:30 */
    ca_uint32_t te_pfcreq_sel        :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_CTL_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA  0xf43049d4
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA_dft 0x7f0dffff

typedef volatile union {
  struct {
    ca_uint32_t pause_quanta         : 16 ; /* bits 15:0 */
    ca_uint32_t adjust_qbb_cnt       :  8 ; /* bits 23:16 */
    ca_uint32_t adjust_1g_qbb_cnt    :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA1 0xf43049d8
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA1_dft 0x0000ffff

typedef volatile union {
  struct {
    ca_uint32_t pause_quanta         : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA1_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA2 0xf43049dc
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA2_dft 0x0000ffff

typedef volatile union {
  struct {
    ca_uint32_t pause_quanta         : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA2_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA3 0xf43049e0
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA3_dft 0x0000ffff

typedef volatile union {
  struct {
    ca_uint32_t pause_quanta         : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA3_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA4 0xf43049e4
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA4_dft 0x0000ffff

typedef volatile union {
  struct {
    ca_uint32_t pause_quanta         : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA4_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA5 0xf43049e8
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA5_dft 0x0000ffff

typedef volatile union {
  struct {
    ca_uint32_t pause_quanta         : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA5_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA6 0xf43049ec
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA6_dft 0x0000ffff

typedef volatile union {
  struct {
    ca_uint32_t pause_quanta         : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA6_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA7 0xf43049f0
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA7_dft 0x0000ffff

typedef volatile union {
  struct {
    ca_uint32_t pause_quanta         : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA7_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_FF_THRESHOLD 0xf43049f4
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_FF_THRESHOLD_dft 0x803f01fa

typedef volatile union {
  struct {
    ca_uint32_t txff_wrff_threshold  :  6 ; /* bits 5:0 */
    ca_uint32_t txff_rdff_threshold  :  6 ; /* bits 11:6 */
    ca_uint32_t txctl_wrff_threshold :  9 ; /* bits 20:12 */
    ca_uint32_t rd_thre_en           :  1 ; /* bits 21:21 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t txctl_rdff_threshold :  9 ; /* bits 31:23 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_FF_THRESHOLD_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS0 0xf43049f8
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rcdrop_cnt           : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS0_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS1 0xf43049fc
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rcff_pktnum          : 11 ; /* bits 10:0 */
    ca_uint32_t rs_locfault          :  1 ; /* bits 11:11 */
    ca_uint32_t rs_rmtfault          :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd1               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS1_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS2 0xf4304a00
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS2_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt_torxmux_cnt      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS2_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS3 0xf4304a04
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS3_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt_tocstxmux_cnt    : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS3_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS4 0xf4304a08
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS4_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt_touptxmux_cnt    : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS4_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS5 0xf4304a0c
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS5_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt_tocstxmux_errcnt :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS5_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS6 0xf4304a10
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS6_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt_cs_flushcnt      :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS6_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_STATUS0 0xf4304a14
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_STATUS0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tcdrop_cnt           : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_STATUS0_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_STATUS1 0xf4304a18
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_STATUS1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tcff_pktnum          :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_STATUS1_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_STATUS3 0xf4304a1c
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_STATUS3_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t length_mismatch      :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_STATUS3_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_STATUS4 0xf4304a20
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_STATUS4_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t es_runt_pkt          :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_STATUS4_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_FF_STATUS  0xf4304a24
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_FF_STATUS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_ffempty           :  1 ; /* bits 0:0 */
    ca_uint32_t tx_fffull            :  1 ; /* bits 1:1 */
    ca_uint32_t rx_ffempty           :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fffull            :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_FF_STATUS_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_BP_CTRL    0xf4304a28
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_BP_CTRL_dft 0x00ffd200

typedef volatile union {
  struct {
    ca_uint32_t cascade_bp_en        :  1 ; /* bits 0:0 */
    ca_uint32_t external_stoptx_en   :  1 ; /* bits 1:1 */
    ca_uint32_t external_pausereq_en :  1 ; /* bits 2:2 */
    ca_uint32_t external_pausereq_pol :  1 ; /* bits 3:3 */
    ca_uint32_t cascade_ff_threshold : 10 ; /* bits 13:4 */
    ca_uint32_t external_pausereq_oen_sel :  1 ; /* bits 14:14 */
    ca_uint32_t external_pausereq_oen :  1 ; /* bits 15:15 */
    ca_uint32_t xaui_die_tx_threshold :  9 ; /* bits 24:16 */
    ca_uint32_t external_stop_lcl_en :  1 ; /* bits 25:25 */
    ca_uint32_t uplink_lcl_pol       :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t dbg_sel              :  3 ; /* bits 30:28 */
    ca_uint32_t die_cascade_bp_en    :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_BP_CTRL_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_SLD_ERRCNT 0xf4304a2c
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_SLD_ERRCNT_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sld_crc8_err_cnt     : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_SLD_ERRCNT_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_MIB_RAM_STATUS_REG 0xf4304a30
#define NI_HV_XAUI_XAUI_MAC_CTRL_MIB_RAM_STATUS_REG_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ram_initdone         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_MIB_RAM_STATUS_REG_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_MIB_CTL         0xf4304a34
#define NI_HV_XAUI_XAUI_MAC_CTRL_MIB_CTL_dft     0x00000009

typedef volatile union {
  struct {
    ca_uint32_t ram_clr_en           :  1 ; /* bits 0:0 */
    ca_uint32_t ram_sw_initial       :  1 ; /* bits 1:1 */
    ca_uint32_t dbg_sel              :  1 ; /* bits 2:2 */
    ca_uint32_t term_dbg_en          :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_MIB_CTL_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_RX_MIB_ACC_ACCESS 0xf4304a38
#define NI_HV_XAUI_XAUI_MAC_CTRL_RX_MIB_ACC_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Addr                 :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t rw                   :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_RX_MIB_ACC_ACCESS_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_RX_MIB_ACC_DATA 0xf4304a3c
#define NI_HV_XAUI_XAUI_MAC_CTRL_RX_MIB_ACC_DATA_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_RX_MIB_ACC_DATA_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_TX_MIB_ACC_ACCESS 0xf4304a40
#define NI_HV_XAUI_XAUI_MAC_CTRL_TX_MIB_ACC_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Addr                 :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t rw                   :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_TX_MIB_ACC_ACCESS_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_TX_MIB_ACC_DATA 0xf4304a44
#define NI_HV_XAUI_XAUI_MAC_CTRL_TX_MIB_ACC_DATA_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_TX_MIB_ACC_DATA_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_MIB_RX_DROPCNT  0xf4304a48
#define NI_HV_XAUI_XAUI_MAC_CTRL_MIB_RX_DROPCNT_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mib_drop_cnt         : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_MIB_RX_DROPCNT_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_MIB_TX_DROPCNT  0xf4304a4c
#define NI_HV_XAUI_XAUI_MAC_CTRL_MIB_TX_DROPCNT_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mib_drop_cnt         : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_MIB_TX_DROPCNT_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_TX_PKT_MIB      0xf4304a50
#define NI_HV_XAUI_XAUI_MAC_CTRL_TX_PKT_MIB_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t count                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_TX_PKT_MIB_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_RX_PKT_MIB      0xf4304a54
#define NI_HV_XAUI_XAUI_MAC_CTRL_RX_PKT_MIB_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t count                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_RX_PKT_MIB_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_MIB_RX_BYTECNT_HI 0xf4304a58
#define NI_HV_XAUI_XAUI_MAC_CTRL_MIB_RX_BYTECNT_HI_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mib_cnt              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_MIB_RX_BYTECNT_HI_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_MIB_TX_BYTECNT_HI 0xf4304a5c
#define NI_HV_XAUI_XAUI_MAC_CTRL_MIB_TX_BYTECNT_HI_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mib_cnt              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_MIB_TX_BYTECNT_HI_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_PAU     0xf4304a60
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_PAU_dft 0x80000005

typedef volatile union {
  struct {
    ca_uint32_t wait_cnt             : 16 ; /* bits 15:0 */
    ca_uint32_t repeat_cnt           : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_PAU_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_DIE0    0xf4304a64
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_DIE0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pktcnt               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_DIE0_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_DIE1    0xf4304a68
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_DIE1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pktcnt               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_DIE1_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_DIE2    0xf4304a6c
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_DIE2_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pktcnt               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_DIE2_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_DIE3    0xf4304a70
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_DIE3_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pktcnt               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_DIE3_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_UPLINK  0xf4304a74
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_UPLINK_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pktcnt               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_UPLINK_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_PTP_TM  0xf4304a78
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_PTP_TM_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ptp_tm               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_PTP_TM_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_PTP_TM_S_LO 0xf4304a7c
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_PTP_TM_S_LO_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ptp_tm               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_PTP_TM_S_LO_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_PTP_TM_S_HI 0xf4304a80
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_PTP_TM_S_HI_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ptp_tm               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_PTP_TM_S_HI_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_PTP_TYPE 0xf4304a84
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_PTP_TYPE_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ptp_type             :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_PTP_TYPE_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_PTP_SQID 0xf4304a88
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_PTP_SQID_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sq_id                : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_PTP_SQID_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_PTP_TM  0xf4304a8c
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_PTP_TM_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ptp_tm               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_PTP_TM_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_PTP_TM_S_LO 0xf4304a90
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_PTP_TM_S_LO_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ptp_tm               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_PTP_TM_S_LO_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_PTP_TM_S_HI 0xf4304a94
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_PTP_TM_S_HI_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ptp_tm               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_PTP_TM_S_HI_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_PTP_TYPE 0xf4304a98
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_PTP_TYPE_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ptp_type             :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_PTP_TYPE_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_PTP_SQID 0xf4304a9c
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_PTP_SQID_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sq_id                : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_PTP_SQID_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_CT_CTL     0xf4304aa0
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_CT_CTL_dft 0x81000002

typedef volatile union {
  struct {
    ca_uint32_t rx_ct_mode_en        :  1 ; /* bits 0:0 */
    ca_uint32_t drop_ct_en           :  1 ; /* bits 1:1 */
    ca_uint32_t tx_ct_mode_en        :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 13 ;
    ca_uint32_t ct_tpid              : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_CT_CTL_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_CT_LLID_CTL 0xf4304aa4
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_CT_LLID_CTL_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pon_llid             : 13 ; /* bits 12:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t xgpon_llid           : 13 ; /* bits 28:16 */
    ca_uint32_t rsrvd2               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_CT_LLID_CTL_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_PTP_VLAN0  0xf4304aa8
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_PTP_VLAN0_dft 0x81009100

typedef volatile union {
  struct {
    ca_uint32_t vlan0                : 16 ; /* bits 15:0 */
    ca_uint32_t vlan1                : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_PTP_VLAN0_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_PTP_VLAN1  0xf4304aac
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_PTP_VLAN1_dft 0x81009100

typedef volatile union {
  struct {
    ca_uint32_t vlan0                : 16 ; /* bits 15:0 */
    ca_uint32_t vlan1                : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_PTP_VLAN1_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_DBG0            0xf4304ab0
#define NI_HV_XAUI_XAUI_MAC_CTRL_DBG0_dft        0x00004006

typedef volatile union {
  struct {
    ca_uint32_t dbg                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_DBG0_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_DBG1            0xf4304ab4
#define NI_HV_XAUI_XAUI_MAC_CTRL_DBG1_dft        0x00000003

typedef volatile union {
  struct {
    ca_uint32_t dbg                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_DBG1_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_DBG2            0xf4304ab8
#define NI_HV_XAUI_XAUI_MAC_CTRL_DBG2_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dbg                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_DBG2_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_DBG3            0xf4304abc
#define NI_HV_XAUI_XAUI_MAC_CTRL_DBG3_dft        0x00000014

typedef volatile union {
  struct {
    ca_uint32_t dbg                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_DBG3_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_GE_DBG_RX_CNT   0xf4304ac0
#define NI_HV_XAUI_XAUI_MAC_CTRL_GE_DBG_RX_CNT_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_GE_DBG_RX_CNT_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_GE_DBG_TX_CNT   0xf4304ac4
#define NI_HV_XAUI_XAUI_MAC_CTRL_GE_DBG_TX_CNT_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_GE_DBG_TX_CNT_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_FLUSH_KNOW 0xf4304ac8
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_FLUSH_KNOW_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pktcnt               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_FLUSH_KNOW_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_FLUSH_SDID 0xf4304acc
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_FLUSH_SDID_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pktcnt               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_FLUSH_SDID_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RXFPGA_DROPCNT 0xf4304ad0
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RXFPGA_DROPCNT_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t asyncff_dropcnt      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RXFPGA_DROPCNT_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RXFPGA_FF_THRESHOLD 0xf4304ad4
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RXFPGA_FF_THRESHOLD_dft 0x30000090

typedef volatile union {
  struct {
    ca_uint32_t rx_wrff_threshold    :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 20 ;
    ca_uint32_t rx_rdff_ipg          :  3 ; /* bits 30:28 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RXFPGA_FF_THRESHOLD_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TXFPGA_FF_THRESHOLD 0xf4304ad8
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TXFPGA_FF_THRESHOLD_dft 0x004000f0

typedef volatile union {
  struct {
    ca_uint32_t tx_wrff_threshold    :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t tx_rdff_threshold    :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd2               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TXFPGA_FF_THRESHOLD_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_DBGCNT0 0xf4304adc
#define NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_DBGCNT0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rc_sop_cnt           : 16 ; /* bits 15:0 */
    ca_uint32_t rc_eop_cnt           : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_DBGCNT0_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_SPARE           0xf4304ae0
#define NI_HV_XAUI_XAUI_MAC_CTRL_SPARE_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t spare                :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_SPARE_t;


#define NI_HV_XAUI_XAUI_MAC_CTRL_SPARE1          0xf4304ae4
#define NI_HV_XAUI_XAUI_MAC_CTRL_SPARE1_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t spare                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_CTRL_SPARE1_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* ctrl */
typedef struct {
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_INTERRUPT_t XAUI_INTERRUPT;                /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_INTERRUPTE_t XAUI_INTERRUPTE;               /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  NI_HV_XAUI_XAUI_MAC_CTRL_CTRL_CFG_t      CTRL_CFG;                      /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  NI_HV_XAUI_XAUI_MAC_CTRL_BRIGE_CTRL_t    BRIGE_CTRL;                    /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  NI_HV_XAUI_XAUI_MAC_CTRL_ADDRESS_H_t     ADDRESS_H;                     /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  NI_HV_XAUI_XAUI_MAC_CTRL_ADDRESS_L_t     ADDRESS_L;                     /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  NI_HV_XAUI_XAUI_MAC_CTRL_CTRL_MODE_t     CTRL_MODE;                     /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_CTL_t   XAUI_RX_CTL;                   /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_DA_HI_t XAUI_MANAGEMENT_DA_HI;         /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_DA_LO_t XAUI_MANAGEMENT_DA_LO;         /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE0_t XAUI_MANAGEMENT_TYPE0;         /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE1_t XAUI_MANAGEMENT_TYPE1;         /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE2_t XAUI_MANAGEMENT_TYPE2;         /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE3_t XAUI_MANAGEMENT_TYPE3;         /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE4_t XAUI_MANAGEMENT_TYPE4;         /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE5_t XAUI_MANAGEMENT_TYPE5;         /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE6_t XAUI_MANAGEMENT_TYPE6;         /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_MANAGEMENT_TYPE7_t XAUI_MANAGEMENT_TYPE7;         /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_FLOWON_CTL_t XAUI_FLOWON_CTL;               /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_FLOWOFF_CTL_t XAUI_FLOWOFF_CTL;              /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_CTL_t   XAUI_TX_CTL;                   /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA_t XAUI_TX_QUANTA;                /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA1_t XAUI_TX_QUANTA1;               /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA2_t XAUI_TX_QUANTA2;               /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA3_t XAUI_TX_QUANTA3;               /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA4_t XAUI_TX_QUANTA4;               /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA5_t XAUI_TX_QUANTA5;               /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA6_t XAUI_TX_QUANTA6;               /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_QUANTA7_t XAUI_TX_QUANTA7;               /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_FF_THRESHOLD_t XAUI_TX_FF_THRESHOLD;          /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS0_t XAUI_RX_STATUS0;               /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS1_t XAUI_RX_STATUS1;               /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS2_t XAUI_RX_STATUS2;               /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS3_t XAUI_RX_STATUS3;               /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS4_t XAUI_RX_STATUS4;               /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS5_t XAUI_RX_STATUS5;               /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_STATUS6_t XAUI_RX_STATUS6;               /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_STATUS0_t XAUI_TX_STATUS0;               /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_STATUS1_t XAUI_TX_STATUS1;               /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_STATUS3_t XAUI_TX_STATUS3;               /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_STATUS4_t XAUI_TX_STATUS4;               /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_FF_STATUS_t XAUI_FF_STATUS;                /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_BP_CTRL_t  XAUI_BP_CTRL;                  /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_SLD_ERRCNT_t XAUI_SLD_ERRCNT;               /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd44[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_MIB_RAM_STATUS_REG_t MIB_RAM_STATUS_REG;            /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd45[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_MIB_CTL_t       MIB_CTL;                       /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd46[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_RX_MIB_ACC_ACCESS_t RX_MIB_ACC_ACCESS;             /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd47[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_RX_MIB_ACC_DATA_t RX_MIB_ACC_DATA;               /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd48[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_TX_MIB_ACC_ACCESS_t TX_MIB_ACC_ACCESS;             /* addr: 0x000000c0 */
  ca_uint32_t                              rsrvd49[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_TX_MIB_ACC_DATA_t TX_MIB_ACC_DATA;               /* addr: 0x000000c4 */
  ca_uint32_t                              rsrvd50[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_MIB_RX_DROPCNT_t MIB_RX_DROPCNT;                /* addr: 0x000000c8 */
  ca_uint32_t                              rsrvd51[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_MIB_TX_DROPCNT_t MIB_TX_DROPCNT;                /* addr: 0x000000cc */
  ca_uint32_t                              rsrvd52[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_TX_PKT_MIB_t    TX_PKT_MIB;                    /* addr: 0x000000d0 */
  ca_uint32_t                              rsrvd53[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_RX_PKT_MIB_t    RX_PKT_MIB;                    /* addr: 0x000000d4 */
  ca_uint32_t                              rsrvd54[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_MIB_RX_BYTECNT_HI_t MIB_RX_BYTECNT_HI;             /* addr: 0x000000d8 */
  ca_uint32_t                              rsrvd55[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_MIB_TX_BYTECNT_HI_t MIB_TX_BYTECNT_HI;             /* addr: 0x000000dc */
  ca_uint32_t                              rsrvd56[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_PAU_t   XAUI_TX_PAU;                   /* addr: 0x000000e0 */
  ca_uint32_t                              rsrvd57[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_DIE0_t  XAUI_RX_DIE0;                  /* addr: 0x000000e4 */
  ca_uint32_t                              rsrvd58[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_DIE1_t  XAUI_RX_DIE1;                  /* addr: 0x000000e8 */
  ca_uint32_t                              rsrvd59[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_DIE2_t  XAUI_RX_DIE2;                  /* addr: 0x000000ec */
  ca_uint32_t                              rsrvd60[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_DIE3_t  XAUI_RX_DIE3;                  /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd61[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_UPLINK_t XAUI_RX_UPLINK;                /* addr: 0x000000f4 */
  ca_uint32_t                              rsrvd62[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_PTP_TM_t XAUI_RX_PTP_TM;                /* addr: 0x000000f8 */
  ca_uint32_t                              rsrvd63[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_PTP_TM_S_LO_t XAUI_RX_PTP_TM_S_LO;           /* addr: 0x000000fc */
  ca_uint32_t                              rsrvd64[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_PTP_TM_S_HI_t XAUI_RX_PTP_TM_S_HI;           /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd65[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_PTP_TYPE_t XAUI_RX_PTP_TYPE;              /* addr: 0x00000104 */
  ca_uint32_t                              rsrvd66[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_PTP_SQID_t XAUI_RX_PTP_SQID;              /* addr: 0x00000108 */
  ca_uint32_t                              rsrvd67[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_PTP_TM_t XAUI_TX_PTP_TM;                /* addr: 0x0000010c */
  ca_uint32_t                              rsrvd68[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_PTP_TM_S_LO_t XAUI_TX_PTP_TM_S_LO;           /* addr: 0x00000110 */
  ca_uint32_t                              rsrvd69[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_PTP_TM_S_HI_t XAUI_TX_PTP_TM_S_HI;           /* addr: 0x00000114 */
  ca_uint32_t                              rsrvd70[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_PTP_TYPE_t XAUI_TX_PTP_TYPE;              /* addr: 0x00000118 */
  ca_uint32_t                              rsrvd71[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TX_PTP_SQID_t XAUI_TX_PTP_SQID;              /* addr: 0x0000011c */
  ca_uint32_t                              rsrvd72[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_CT_CTL_t   XAUI_CT_CTL;                   /* addr: 0x00000120 */
  ca_uint32_t                              rsrvd73[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_CT_LLID_CTL_t XAUI_CT_LLID_CTL;              /* addr: 0x00000124 */
  ca_uint32_t                              rsrvd74[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_PTP_VLAN0_t XAUI_PTP_VLAN0;                /* addr: 0x00000128 */
  ca_uint32_t                              rsrvd75[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_PTP_VLAN1_t XAUI_PTP_VLAN1;                /* addr: 0x0000012c */
  ca_uint32_t                              rsrvd76[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_DBG0_t          DBG0;                          /* addr: 0x00000130 */
  ca_uint32_t                              rsrvd77[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_DBG1_t          DBG1;                          /* addr: 0x00000134 */
  ca_uint32_t                              rsrvd78[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_DBG2_t          DBG2;                          /* addr: 0x00000138 */
  ca_uint32_t                              rsrvd79[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_DBG3_t          DBG3;                          /* addr: 0x0000013c */
  ca_uint32_t                              rsrvd80[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_GE_DBG_RX_CNT_t GE_DBG_RX_CNT;                 /* addr: 0x00000140 */
  ca_uint32_t                              rsrvd81[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_GE_DBG_TX_CNT_t GE_DBG_TX_CNT;                 /* addr: 0x00000144 */
  ca_uint32_t                              rsrvd82[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_FLUSH_KNOW_t XAUI_RX_FLUSH_KNOW;            /* addr: 0x00000148 */
  ca_uint32_t                              rsrvd83[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_FLUSH_SDID_t XAUI_RX_FLUSH_SDID;            /* addr: 0x0000014c */
  ca_uint32_t                              rsrvd84[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RXFPGA_DROPCNT_t XAUI_RXFPGA_DROPCNT;           /* addr: 0x00000150 */
  ca_uint32_t                              rsrvd85[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RXFPGA_FF_THRESHOLD_t XAUI_RXFPGA_FF_THRESHOLD;      /* addr: 0x00000154 */
  ca_uint32_t                              rsrvd86[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_TXFPGA_FF_THRESHOLD_t XAUI_TXFPGA_FF_THRESHOLD;      /* addr: 0x00000158 */
  ca_uint32_t                              rsrvd87[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_XAUI_RX_DBGCNT0_t XAUI_RX_DBGCNT0;               /* addr: 0x0000015c */
  ca_uint32_t                              rsrvd88[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_SPARE_t         SPARE;                         /* addr: 0x00000160 */
  ca_uint32_t                              rsrvd89[3];                   
  NI_HV_XAUI_XAUI_MAC_CTRL_SPARE1_t        SPARE1;                        /* addr: 0x00000164 */
} APB0_NI_HV_XAUI_XAUI_MAC_CTRL_t;


/*
 * txmac
 */
        
#define NI_HV_XAUI_XAUI_MAC_TXMAC_TX_CONFIG      0xf4304b00
#define NI_HV_XAUI_XAUI_MAC_TXMAC_TX_CONFIG_dft  0x40000070

typedef volatile union {
  struct {
    ca_uint32_t insert_cshead        :  1 ; /* bits 0:0 */
    ca_uint32_t reset                :  1 ; /* bits 1:1 */
    ca_uint32_t flow_en              :  1 ; /* bits 2:2 */
    ca_uint32_t mac_en               :  1 ; /* bits 3:3 */
    ca_uint32_t crc_recaculate_en    :  1 ; /* bits 4:4 */
    ca_uint32_t swap_crc8_en         :  1 ; /* bits 5:5 */
    ca_uint32_t swap_datain_en       :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               :  6 ;
    ca_uint32_t dic_mode             :  2 ; /* bits 14:13 */
    ca_uint32_t rsrvd2               : 15 ;
    ca_uint32_t link_fault_en        :  1 ; /* bits 30:30 */
    ca_uint32_t insert_nop           :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_TXMAC_TX_CONFIG_t;


#define NI_HV_XAUI_XAUI_MAC_TXMAC_ASYNC_FF_STATUS 0xf4304b04
#define NI_HV_XAUI_XAUI_MAC_TXMAC_ASYNC_FF_STATUS_dft 0x00000001

typedef volatile union {
  struct {
    ca_uint32_t empty                :  1 ; /* bits 0:0 */
    ca_uint32_t full                 :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_TXMAC_ASYNC_FF_STATUS_t;


#define NI_HV_XAUI_XAUI_MAC_TXMAC_TX_DBG0        0xf4304b08
#define NI_HV_XAUI_XAUI_MAC_TXMAC_TX_DBG0_dft    0x00000040

typedef volatile union {
  struct {
    ca_uint32_t dbg                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_TXMAC_TX_DBG0_t;


#define NI_HV_XAUI_XAUI_MAC_TXMAC_TX_DBG1        0xf4304b0c
#define NI_HV_XAUI_XAUI_MAC_TXMAC_TX_DBG1_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dbg                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_TXMAC_TX_DBG1_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* txmac */
typedef struct {
  NI_HV_XAUI_XAUI_MAC_TXMAC_TX_CONFIG_t    TX_CONFIG;                     /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  NI_HV_XAUI_XAUI_MAC_TXMAC_ASYNC_FF_STATUS_t ASYNC_FF_STATUS;               /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  NI_HV_XAUI_XAUI_MAC_TXMAC_TX_DBG0_t      TX_DBG0;                       /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  NI_HV_XAUI_XAUI_MAC_TXMAC_TX_DBG1_t      TX_DBG1;                       /* addr: 0x0000000c */
} APB0_NI_HV_XAUI_XAUI_MAC_TXMAC_t;


/*
 * rxmac
 */
        
#define NI_HV_XAUI_XAUI_MAC_RXMAC_RX_CONFIG      0xf4304b20
#define NI_HV_XAUI_XAUI_MAC_RXMAC_RX_CONFIG_dft  0x07ff0230

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t reset                :  1 ; /* bits 1:1 */
    ca_uint32_t dxaui_quanta_mode    :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t swap_crc8_en         :  1 ; /* bits 4:4 */
    ca_uint32_t swap_datain_en       :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t mac_en               :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd4               :  1 ;
    ca_uint32_t pause_en             :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd5               :  6 ;
    ca_uint32_t max_size             : 11 ; /* bits 26:16 */
    ca_uint32_t rsrvd6               :  5 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_RXMAC_RX_CONFIG_t;


#define NI_HV_XAUI_XAUI_MAC_RXMAC_RX_PKT_DET     0xf4304b24
#define NI_HV_XAUI_XAUI_MAC_RXMAC_RX_PKT_DET_dft 0x0000006f

typedef volatile union {
  struct {
    ca_uint32_t check_idle           :  1 ; /* bits 0:0 */
    ca_uint32_t check_start          :  1 ; /* bits 1:1 */
    ca_uint32_t check_sld            :  1 ; /* bits 2:2 */
    ca_uint32_t check_preamble       :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t check_crc8           :  1 ; /* bits 5:5 */
    ca_uint32_t check_terminate      :  1 ; /* bits 6:6 */
    ca_uint32_t rx_revcs             :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd2               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_RXMAC_RX_PKT_DET_t;


#define NI_HV_XAUI_XAUI_MAC_RXMAC_RX_CASCADE_HD  0xf4304b28
#define NI_HV_XAUI_XAUI_MAC_RXMAC_RX_CASCADE_HD_dft 0x10000000

typedef volatile union {
  struct {
    ca_uint32_t cascade_hd           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_RXMAC_RX_CASCADE_HD_t;


#define NI_HV_XAUI_XAUI_MAC_RXMAC_RX_INIT_CASCADE_HD 0xf4304b2c
#define NI_HV_XAUI_XAUI_MAC_RXMAC_RX_INIT_CASCADE_HD_dft 0x10000000

typedef volatile union {
  struct {
    ca_uint32_t cascade_hd           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_RXMAC_RX_INIT_CASCADE_HD_t;


#define NI_HV_XAUI_XAUI_MAC_RXMAC_RX_ASYNC_FF_OVERFLOW 0xf4304b30
#define NI_HV_XAUI_XAUI_MAC_RXMAC_RX_ASYNC_FF_OVERFLOW_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_asyncff_overflow  :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_RXMAC_RX_ASYNC_FF_OVERFLOW_t;


#define NI_HV_XAUI_XAUI_MAC_RXMAC_RX_DBG0        0xf4304b34
#define NI_HV_XAUI_XAUI_MAC_RXMAC_RX_DBG0_dft    0x000000ff

typedef volatile union {
  struct {
    ca_uint32_t dbg                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_RXMAC_RX_DBG0_t;


#define NI_HV_XAUI_XAUI_MAC_RXMAC_RX_DBG1        0xf4304b38
#define NI_HV_XAUI_XAUI_MAC_RXMAC_RX_DBG1_dft    0x10000000

typedef volatile union {
  struct {
    ca_uint32_t dbg                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_MAC_RXMAC_RX_DBG1_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* rxmac */
typedef struct {
  NI_HV_XAUI_XAUI_MAC_RXMAC_RX_CONFIG_t    RX_CONFIG;                     /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  NI_HV_XAUI_XAUI_MAC_RXMAC_RX_PKT_DET_t   RX_PKT_DET;                    /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  NI_HV_XAUI_XAUI_MAC_RXMAC_RX_CASCADE_HD_t RX_CASCADE_HD;                 /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  NI_HV_XAUI_XAUI_MAC_RXMAC_RX_INIT_CASCADE_HD_t RX_INIT_CASCADE_HD;            /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  NI_HV_XAUI_XAUI_MAC_RXMAC_RX_ASYNC_FF_OVERFLOW_t RX_ASYNC_FF_OVERFLOW;          /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  NI_HV_XAUI_XAUI_MAC_RXMAC_RX_DBG0_t      RX_DBG0;                       /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  NI_HV_XAUI_XAUI_MAC_RXMAC_RX_DBG1_t      RX_DBG1;                       /* addr: 0x00000018 */
} APB0_NI_HV_XAUI_XAUI_MAC_RXMAC_t;

    
  
        
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* xaui_mac */

typedef struct {
  APB0_NI_HV_XAUI_XAUI_MAC_CTRL_t          ctrl;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[205];                  
  APB0_NI_HV_XAUI_XAUI_MAC_TXMAC_t         txmac;                         /* addr: 0x00000180 */
  ca_uint32_t                              rsrvd2[25];                   
  APB0_NI_HV_XAUI_XAUI_MAC_RXMAC_t         rxmac;                         /* addr: 0x000001a0 */
} APB0_NI_HV_XAUI_XAUI_MAC_t;


/*
 * xaui_xgrs
 */
  
/*
 * tx
 */
        
#define NI_HV_XAUI_XAUI_XGRS_TX_TXCNTRL          0xf4304b40
#define NI_HV_XAUI_XAUI_XGRS_TX_TXCNTRL_dft      0x00000013

typedef volatile union {
  struct {
    ca_uint32_t tx_localOrdEn        :  1 ; /* bits 0:0 */
    ca_uint32_t tx_remoteOrdEn       :  1 ; /* bits 1:1 */
    ca_uint32_t tx_userOrdEn         :  1 ; /* bits 2:2 */
    ca_uint32_t tx_dataTruncEn       :  1 ; /* bits 3:3 */
    ca_uint32_t tx_pcs6_line_txd_en  :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 10 ;
    ca_uint32_t tx_logicReset        :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd2               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_XGRS_TX_TXCNTRL_t;


#define NI_HV_XAUI_XAUI_XGRS_TX_TXUSERORD1       0xf4304b44
#define NI_HV_XAUI_XAUI_XGRS_TX_TXUSERORD1_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_userOrdL1         :  8 ; /* bits 7:0 */
    ca_uint32_t tx_userOrdL2         :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_XGRS_TX_TXUSERORD1_t;


#define NI_HV_XAUI_XAUI_XGRS_TX_TXUSERORD2       0xf4304b48
#define NI_HV_XAUI_XAUI_XGRS_TX_TXUSERORD2_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_userOrdL3         :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_XGRS_TX_TXUSERORD2_t;


#define NI_HV_XAUI_XAUI_XGRS_TX_TXINT            0xf4304b4c
#define NI_HV_XAUI_XAUI_XGRS_TX_TXINT_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t truncPktI            :  1 ; /* bits 0:0 */
    ca_uint32_t truncPktSatI         :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_XGRS_TX_TXINT_t;


#define NI_HV_XAUI_XAUI_XGRS_TX_TXINTENABLE      0xf4304b50
#define NI_HV_XAUI_XAUI_XGRS_TX_TXINTENABLE_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t truncPktE            :  1 ; /* bits 0:0 */
    ca_uint32_t truncPktSatE         :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_XGRS_TX_TXINTENABLE_t;


#define NI_HV_XAUI_XAUI_XGRS_TX_TRUNCPKT         0xf4304b54
#define NI_HV_XAUI_XAUI_XGRS_TX_TRUNCPKT_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t trunc_pkt_tx         : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_XGRS_TX_TRUNCPKT_t;


#define NI_HV_XAUI_XAUI_XGRS_TX_OIDLECOUNT       0xf4304b58
#define NI_HV_XAUI_XAUI_XGRS_TX_OIDLECOUNT_dft   0x00000006

typedef volatile union {
  struct {
    ca_uint32_t oidle_pkt_tx         :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_XGRS_TX_OIDLECOUNT_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* tx */
typedef struct {
  NI_HV_XAUI_XAUI_XGRS_TX_TXCNTRL_t        TXCNTRL;                       /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  NI_HV_XAUI_XAUI_XGRS_TX_TXUSERORD1_t     TXUSERORD1;                    /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  NI_HV_XAUI_XAUI_XGRS_TX_TXUSERORD2_t     TXUSERORD2;                    /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  NI_HV_XAUI_XAUI_XGRS_TX_TXINT_t          TXINT;                         /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  NI_HV_XAUI_XAUI_XGRS_TX_TXINTENABLE_t    TXINTENABLE;                   /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  NI_HV_XAUI_XAUI_XGRS_TX_TRUNCPKT_t       TRUNCPKT;                      /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  NI_HV_XAUI_XAUI_XGRS_TX_OIDLECOUNT_t     OIDLECOUNT;                    /* addr: 0x00000018 */
} APB0_NI_HV_XAUI_XAUI_XGRS_TX_t;


/*
 * rx
 */
        
#define NI_HV_XAUI_XAUI_XGRS_RX_RXCNTRL1         0xf4304b60
#define NI_HV_XAUI_XAUI_XGRS_RX_RXCNTRL1_dft     0x0000028f

typedef volatile union {
  struct {
    ca_uint32_t rx_dataLosEn         :  1 ; /* bits 0:0 */
    ca_uint32_t rx_lockLosEn         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_sigLosEn          :  1 ; /* bits 2:2 */
    ca_uint32_t rx_phyRLFEn          :  1 ; /* bits 3:3 */
    ca_uint32_t rx_losPolarity       :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t rx_noIpg             :  1 ; /* bits 7:7 */
    ca_uint32_t rx_ofsmUNHEn         :  1 ; /* bits 8:8 */
    ca_uint32_t rx_pcs6_line_rxd_en  :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd2               :  5 ;
    ca_uint32_t rx_logicReset        :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd3               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_XGRS_RX_RXCNTRL1_t;

#define     rx_losPolarity_HIGH_LOS_POL                   0x0
#define     rx_losPolarity_LOW_LOS_POL                    0x1

#define NI_HV_XAUI_XAUI_XGRS_RX_RXCNTRL2         0xf4304b64
#define NI_HV_XAUI_XAUI_XGRS_RX_RXCNTRL2_dft     0x0000037f

typedef volatile union {
  struct {
    ca_uint32_t rx_col_thr           :  8 ; /* bits 7:0 */
    ca_uint32_t rx_seq_thr           :  4 ; /* bits 11:8 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_XGRS_RX_RXCNTRL2_t;


#define NI_HV_XAUI_XAUI_XGRS_RX_RXSTATUS         0xf4304b68
#define NI_HV_XAUI_XAUI_XGRS_RX_RXSTATUS_dft     0x00000001

typedef volatile union {
  struct {
    ca_uint32_t localordS            :  1 ; /* bits 0:0 */
    ca_uint32_t remoteordS           :  1 ; /* bits 1:1 */
    ca_uint32_t unknownordS          :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_XGRS_RX_RXSTATUS_t;


#define NI_HV_XAUI_XAUI_XGRS_RX_RXINT            0xf4304b6c
#define NI_HV_XAUI_XAUI_XGRS_RX_RXINT_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t localordI            :  1 ; /* bits 0:0 */
    ca_uint32_t remoteordI           :  1 ; /* bits 1:1 */
    ca_uint32_t unknownordI          :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_XGRS_RX_RXINT_t;


#define NI_HV_XAUI_XAUI_XGRS_RX_RXINTENABLE      0xf4304b70
#define NI_HV_XAUI_XAUI_XGRS_RX_RXINTENABLE_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t localordE            :  1 ; /* bits 0:0 */
    ca_uint32_t remoteordE           :  1 ; /* bits 1:1 */
    ca_uint32_t unknownordE          :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_XGRS_RX_RXINTENABLE_t;


#define NI_HV_XAUI_XAUI_XGRS_RX_UNKNOWNORD1      0xf4304b74
#define NI_HV_XAUI_XAUI_XGRS_RX_UNKNOWNORD1_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_unknownOrd_l1     :  8 ; /* bits 7:0 */
    ca_uint32_t rx_unknownOrd_l2     :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_XGRS_RX_UNKNOWNORD1_t;


#define NI_HV_XAUI_XAUI_XGRS_RX_UNKNOWNORD2      0xf4304b78
#define NI_HV_XAUI_XAUI_XGRS_RX_UNKNOWNORD2_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_unknownOrd_l3     :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_XGRS_RX_UNKNOWNORD2_t;


#define NI_HV_XAUI_XAUI_XGRS_RX_FAULT_SEL        0xf4304b7c
#define NI_HV_XAUI_XAUI_XGRS_RX_FAULT_SEL_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t loc_fault_sel        :  1 ; /* bits 0:0 */
    ca_uint32_t rmt_fault_sel        :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XAUI_XAUI_XGRS_RX_FAULT_SEL_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* rx */
typedef struct {
  NI_HV_XAUI_XAUI_XGRS_RX_RXCNTRL1_t       RXCNTRL1;                      /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  NI_HV_XAUI_XAUI_XGRS_RX_RXCNTRL2_t       RXCNTRL2;                      /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  NI_HV_XAUI_XAUI_XGRS_RX_RXSTATUS_t       RXSTATUS;                      /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  NI_HV_XAUI_XAUI_XGRS_RX_RXINT_t          RXINT;                         /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  NI_HV_XAUI_XAUI_XGRS_RX_RXINTENABLE_t    RXINTENABLE;                   /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  NI_HV_XAUI_XAUI_XGRS_RX_UNKNOWNORD1_t    UNKNOWNORD1;                   /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  NI_HV_XAUI_XAUI_XGRS_RX_UNKNOWNORD2_t    UNKNOWNORD2;                   /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  NI_HV_XAUI_XAUI_XGRS_RX_FAULT_SEL_t      FAULT_SEL;                     /* addr: 0x0000001c */
} APB0_NI_HV_XAUI_XAUI_XGRS_RX_t;

    
  
        
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* xaui_xgrs */

typedef struct {
  APB0_NI_HV_XAUI_XAUI_XGRS_TX_t           tx;                            /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[19];                   
  APB0_NI_HV_XAUI_XAUI_XGRS_RX_t           rx;                            /* addr: 0x00000020 */
} APB0_NI_HV_XAUI_XAUI_XGRS_t;

    
  
        
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* XAUI */

typedef struct {
  APB0_NI_HV_XAUI_XGXS_TOP_t               XGXS_TOP;                      /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[57];                   
  APB0_NI_HV_XAUI_XAUI_MAC_t               xaui_mac;                      /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd2[19];                   
  APB0_NI_HV_XAUI_XAUI_XGRS_t              xaui_xgrs;                     /* addr: 0x00000260 */
} APB0_NI_HV_XAUI_t;


/*
 * XGE[0..1]
 */
  
/*
 * MAC
 */
        
#define NI_HV_XGE_MAC_CFG_COM                    0xf4304b80
#define NI_HV_XGE_MAC_CFG_COM_dft                0x00000010

typedef volatile union {
  struct {
    ca_uint32_t rpr_mode             :  1 ; /* bits 0:0 */
    ca_uint32_t stack_en             :  1 ; /* bits 1:1 */
    ca_uint32_t clronread            :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t stats_err_order      :  3 ; /* bits 6:4 */
    ca_uint32_t stats_drop_en        :  1 ; /* bits 7:7 */
    ca_uint32_t core_tx2rx_lb        :  1 ; /* bits 8:8 */
    ca_uint32_t core_rx2tx_lb        :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t cntr_rst             :  1 ; /* bits 13:13 */
    ca_uint32_t rx_rst               :  1 ; /* bits 14:14 */
    ca_uint32_t tx_rst               :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd3               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MAC_CFG_COM_t;


#define NI_HV_XGE_MAC_CFG_RX                     0xf4304b84
#define NI_HV_XGE_MAC_CFG_RX_dft                 0x00001bc1

typedef volatile union {
  struct {
    ca_uint32_t promis_mode          :  1 ; /* bits 0:0 */
    ca_uint32_t drop_short           :  1 ; /* bits 1:1 */
    ca_uint32_t strip                :  2 ; /* bits 3:2 */
    ca_uint32_t pause_term           :  1 ; /* bits 4:4 */
    ca_uint32_t pause_extract        :  1 ; /* bits 5:5 */
    ca_uint32_t len_chk_en           :  1 ; /* bits 6:6 */
    ca_uint32_t len_chk_en_pause     :  1 ; /* bits 7:7 */
    ca_uint32_t len_chk_en_pad       :  1 ; /* bits 8:8 */
    ca_uint32_t fcs_chk_en           :  1 ; /* bits 9:9 */
    ca_uint32_t IFG_mode_rx          :  1 ; /* bits 10:10 */
    ca_uint32_t crc_err_fatal        :  1 ; /* bits 11:11 */
    ca_uint32_t maxlen_mode          :  1 ; /* bits 12:12 */
    ca_uint32_t prmbl_sfd_gmii_err   :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MAC_CFG_RX_t;

#define     maxlen_mode_FIX                               0x0
#define     maxlen_mode_AUTO                              0x1
#define     IFG_mode_rx_STD                               0x0
#define     IFG_mode_rx_BEST                              0x1
#define     strip_NONE                                    0x0
#define     strip_FCS                                     0x1
#define     strip_PADFCS                                  0x2

#define NI_HV_XGE_MAC_CFG_TX                     0xf4304b88
#define NI_HV_XGE_MAC_CFG_TX_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t IFG_mode_tx          :  2 ; /* bits 1:0 */
    ca_uint32_t halt                 :  1 ; /* bits 2:2 */
    ca_uint32_t insSA                :  1 ; /* bits 3:3 */
    ca_uint32_t pause_req_en         :  1 ; /* bits 4:4 */
    ca_uint32_t pause_req_auto_xon   :  1 ; /* bits 5:5 */
    ca_uint32_t lf_auto_flush_en     :  1 ; /* bits 6:6 */
    ca_uint32_t vlan_pad_mode        :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MAC_CFG_TX_t;

#define     vlan_pad_mode_MD_64B                          0x0
#define     vlan_pad_mode_MD_VAR                          0x1
#define     IFG_mode_tx_STD                               0x0
#define     IFG_mode_tx_DIC12                             0x1
#define     IFG_mode_tx_DIC8                              0x2
#define     IFG_mode_tx_RSVD                              0x3

#define NI_HV_XGE_MAC_CFG_TX_2                   0xf4304b8c
#define NI_HV_XGE_MAC_CFG_TX_2_dft               0x0000060e

typedef volatile union {
  struct {
    ca_uint32_t fifo1_thr_afull      :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t fifo1_read_thr       :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MAC_CFG_TX_2_t;


#define NI_HV_XGE_MAC_CFG_TX_IFG                 0xf4304b90
#define NI_HV_XGE_MAC_CFG_TX_IFG_dft             0x0000000c

typedef volatile union {
  struct {
    ca_uint32_t ifg                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MAC_CFG_TX_IFG_t;


#define NI_HV_XGE_MAC_MAC_ADDR_A                 0xf4304b94
#define NI_HV_XGE_MAC_MAC_ADDR_A_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MAC_MAC_ADDR_A_t;


#define NI_HV_XGE_MAC_MAC_ADDR_B                 0xf4304b98
#define NI_HV_XGE_MAC_MAC_ADDR_B_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MAC_MAC_ADDR_B_t;


#define NI_HV_XGE_MAC_MAC_ADDR_C                 0xf4304b9c
#define NI_HV_XGE_MAC_MAC_ADDR_C_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MAC_MAC_ADDR_C_t;


#define NI_HV_XGE_MAC_VLAN_TAG1                  0xf4304ba0
#define NI_HV_XGE_MAC_VLAN_TAG1_dft              0x00008100

typedef volatile union {
  struct {
    ca_uint32_t tag                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MAC_VLAN_TAG1_t;


#define NI_HV_XGE_MAC_VLAN_TAG2                  0xf4304ba4
#define NI_HV_XGE_MAC_VLAN_TAG2_dft              0x00008100

typedef volatile union {
  struct {
    ca_uint32_t tag                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MAC_VLAN_TAG2_t;


#define NI_HV_XGE_MAC_VLAN_TAG3                  0xf4304ba8
#define NI_HV_XGE_MAC_VLAN_TAG3_dft              0x00008100

typedef volatile union {
  struct {
    ca_uint32_t tag                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MAC_VLAN_TAG3_t;


#define NI_HV_XGE_MAC_MINLEN                     0xf4304bac
#define NI_HV_XGE_MAC_MINLEN_dft                 0x00000040

typedef volatile union {
  struct {
    ca_uint32_t minlen               :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MAC_MINLEN_t;


#define NI_HV_XGE_MAC_MAXLEN                     0xf4304bb0
#define NI_HV_XGE_MAC_MAXLEN_dft                 0x00002328

typedef volatile union {
  struct {
    ca_uint32_t maxlen               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MAC_MAXLEN_t;


#define NI_HV_XGE_MAC_PAUSE_ADDR_A               0xf4304bb4
#define NI_HV_XGE_MAC_PAUSE_ADDR_A_dft           0x00000180

typedef volatile union {
  struct {
    ca_uint32_t addr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MAC_PAUSE_ADDR_A_t;


#define NI_HV_XGE_MAC_PAUSE_ADDR_B               0xf4304bb8
#define NI_HV_XGE_MAC_PAUSE_ADDR_B_dft           0x0000c200

typedef volatile union {
  struct {
    ca_uint32_t addr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MAC_PAUSE_ADDR_B_t;


#define NI_HV_XGE_MAC_PAUSE_ADDR_C               0xf4304bbc
#define NI_HV_XGE_MAC_PAUSE_ADDR_C_dft           0x00000001

typedef volatile union {
  struct {
    ca_uint32_t addr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MAC_PAUSE_ADDR_C_t;


#define NI_HV_XGE_MAC_PQUANTA                    0xf4304bc0
#define NI_HV_XGE_MAC_PQUANTA_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pq                   : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MAC_PQUANTA_t;


#define NI_HV_XGE_MAC_PAUSE_TX_CMD               0xf4304bc4
#define NI_HV_XGE_MAC_PAUSE_TX_CMD_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t X_GEN                :  1 ; /* bits 0:0 */
    ca_uint32_t XON_XOFF             :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MAC_PAUSE_TX_CMD_t;


#define NI_HV_XGE_MAC_INTERRUPT                  0xf4304bc8
#define NI_HV_XGE_MAC_INTERRUPT_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t miscI                :  1 ; /* bits 0:0 */
    ca_uint32_t stats1I              :  1 ; /* bits 1:1 */
    ca_uint32_t stats2I              :  1 ; /* bits 2:2 */
    ca_uint32_t stats3I              :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MAC_INTERRUPT_t;


#define NI_HV_XGE_MAC_INTENABLE                  0xf4304bcc
#define NI_HV_XGE_MAC_INTENABLE_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t miscE                :  1 ; /* bits 0:0 */
    ca_uint32_t stats1E              :  1 ; /* bits 1:1 */
    ca_uint32_t stats2E              :  1 ; /* bits 2:2 */
    ca_uint32_t stats3E              :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MAC_INTENABLE_t;


#define NI_HV_XGE_MAC_MISC_INTERRUPT             0xf4304bd0
#define NI_HV_XGE_MAC_MISC_INTERRUPT_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo1_uflwI       :  1 ; /* bits 0:0 */
    ca_uint32_t tx_fifo1_oflwI       :  1 ; /* bits 1:1 */
    ca_uint32_t tx_pause_doneI       :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t rx_no_sfdI           :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd2               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MAC_MISC_INTERRUPT_t;


#define NI_HV_XGE_MAC_MISC_INTENABLE             0xf4304bd4
#define NI_HV_XGE_MAC_MISC_INTENABLE_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo1_uflwE       :  1 ; /* bits 0:0 */
    ca_uint32_t tx_fifo1_oflwE       :  1 ; /* bits 1:1 */
    ca_uint32_t tx_pause_doneE       :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t rx_no_sfdE           :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd2               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MAC_MISC_INTENABLE_t;


#define NI_HV_XGE_MAC_STATS_INTERRUPT1           0xf4304bd8
#define NI_HV_XGE_MAC_STATS_INTERRUPT1_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_good_framesI      :  1 ; /* bits 0:0 */
    ca_uint32_t tx_good_octetsI      :  1 ; /* bits 1:1 */
    ca_uint32_t tx_pause_framesI     :  1 ; /* bits 2:2 */
    ca_uint32_t rx_good_framesI      :  1 ; /* bits 3:3 */
    ca_uint32_t rx_good_octetsI      :  1 ; /* bits 4:4 */
    ca_uint32_t rx_pause_framesI     :  1 ; /* bits 5:5 */
    ca_uint32_t rx_crcerr_framesI    :  1 ; /* bits 6:6 */
    ca_uint32_t rx_alignerr_framesI  :  1 ; /* bits 7:7 */
    ca_uint32_t tx_ucast_framesI     :  1 ; /* bits 8:8 */
    ca_uint32_t tx_mcast_framesI     :  1 ; /* bits 9:9 */
    ca_uint32_t tx_bcast_framesI     :  1 ; /* bits 10:10 */
    ca_uint32_t tx_err_framesI       :  1 ; /* bits 11:11 */
    ca_uint32_t rx_ucast_framesI     :  1 ; /* bits 12:12 */
    ca_uint32_t rx_mcast_framesI     :  1 ; /* bits 13:13 */
    ca_uint32_t rx_bcast_framesI     :  1 ; /* bits 14:14 */
    ca_uint32_t rx_err_framesI       :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MAC_STATS_INTERRUPT1_t;


#define NI_HV_XGE_MAC_STATS_INTENABLE1           0xf4304bdc
#define NI_HV_XGE_MAC_STATS_INTENABLE1_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_good_framesE      :  1 ; /* bits 0:0 */
    ca_uint32_t tx_good_octetsE      :  1 ; /* bits 1:1 */
    ca_uint32_t tx_pause_framesE     :  1 ; /* bits 2:2 */
    ca_uint32_t rx_good_framesE      :  1 ; /* bits 3:3 */
    ca_uint32_t rx_good_octetsE      :  1 ; /* bits 4:4 */
    ca_uint32_t rx_pause_framesE     :  1 ; /* bits 5:5 */
    ca_uint32_t rx_crcerr_framesE    :  1 ; /* bits 6:6 */
    ca_uint32_t rx_alignerr_framesE  :  1 ; /* bits 7:7 */
    ca_uint32_t tx_ucast_framesE     :  1 ; /* bits 8:8 */
    ca_uint32_t tx_mcast_framesE     :  1 ; /* bits 9:9 */
    ca_uint32_t tx_bcast_framesE     :  1 ; /* bits 10:10 */
    ca_uint32_t tx_err_framesE       :  1 ; /* bits 11:11 */
    ca_uint32_t rx_ucast_framesE     :  1 ; /* bits 12:12 */
    ca_uint32_t rx_mcast_framesE     :  1 ; /* bits 13:13 */
    ca_uint32_t rx_bcast_framesE     :  1 ; /* bits 14:14 */
    ca_uint32_t rx_err_framesE       :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MAC_STATS_INTENABLE1_t;


#define NI_HV_XGE_MAC_STATS_INTERRUPT2           0xf4304be0
#define NI_HV_XGE_MAC_STATS_INTERRUPT2_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_octetsI           :  1 ; /* bits 0:0 */
    ca_uint32_t rx_framesI           :  1 ; /* bits 1:1 */
    ca_uint32_t rx_runt_framesI      :  1 ; /* bits 2:2 */
    ca_uint32_t rx_short_framesI     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_undersize_framesI :  1 ; /* bits 4:4 */
    ca_uint32_t rx_giant_framesI     :  1 ; /* bits 5:5 */
    ca_uint32_t rx_jabber_framesI    :  1 ; /* bits 6:6 */
    ca_uint32_t rx_64b_framesI       :  1 ; /* bits 7:7 */
    ca_uint32_t rx_65b_to_127b_framesI :  1 ; /* bits 8:8 */
    ca_uint32_t rx_128b_to_255b_framesI :  1 ; /* bits 9:9 */
    ca_uint32_t rx_256b_to_511b_framesI :  1 ; /* bits 10:10 */
    ca_uint32_t rx_512b_to_1023b_framesI :  1 ; /* bits 11:11 */
    ca_uint32_t rx_1024b_to_1518b_framesI :  1 ; /* bits 12:12 */
    ca_uint32_t rx_1519b_to_maxb_framesI :  1 ; /* bits 13:13 */
    ca_uint32_t tx_octetsI           :  1 ; /* bits 14:14 */
    ca_uint32_t tx_framesI           :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MAC_STATS_INTERRUPT2_t;


#define NI_HV_XGE_MAC_STATS_INTENABLE2           0xf4304be4
#define NI_HV_XGE_MAC_STATS_INTENABLE2_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_octetsE           :  1 ; /* bits 0:0 */
    ca_uint32_t rx_framesE           :  1 ; /* bits 1:1 */
    ca_uint32_t rx_runt_framesE      :  1 ; /* bits 2:2 */
    ca_uint32_t rx_short_framesE     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_undersize_framesE :  1 ; /* bits 4:4 */
    ca_uint32_t rx_giant_framesE     :  1 ; /* bits 5:5 */
    ca_uint32_t rx_jabber_framesE    :  1 ; /* bits 6:6 */
    ca_uint32_t rx_64b_framesE       :  1 ; /* bits 7:7 */
    ca_uint32_t rx_65b_to_127b_framesE :  1 ; /* bits 8:8 */
    ca_uint32_t rx_128b_to_255b_framesE :  1 ; /* bits 9:9 */
    ca_uint32_t rx_256b_to_511b_framesE :  1 ; /* bits 10:10 */
    ca_uint32_t rx_512b_to_1023b_framesE :  1 ; /* bits 11:11 */
    ca_uint32_t rx_1024b_to_1518b_framesE :  1 ; /* bits 12:12 */
    ca_uint32_t rx_1519b_to_maxb_framesE :  1 ; /* bits 13:13 */
    ca_uint32_t tx_octetsE           :  1 ; /* bits 14:14 */
    ca_uint32_t tx_framesE           :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MAC_STATS_INTENABLE2_t;


#define NI_HV_XGE_MAC_STATS_INTERRUPT3           0xf4304be8
#define NI_HV_XGE_MAC_STATS_INTERRUPT3_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_64b_framesI       :  1 ; /* bits 0:0 */
    ca_uint32_t tx_65b_to_127b_framesI :  1 ; /* bits 1:1 */
    ca_uint32_t tx_128b_to_255b_framesI :  1 ; /* bits 2:2 */
    ca_uint32_t tx_256b_to_511b_framesI :  1 ; /* bits 3:3 */
    ca_uint32_t tx_512b_to_1023b_framesI :  1 ; /* bits 4:4 */
    ca_uint32_t tx_1024b_to_1518b_framesI :  1 ; /* bits 5:5 */
    ca_uint32_t tx_1519b_framesI     :  1 ; /* bits 6:6 */
    ca_uint32_t drop_rx_crcerr_framesI :  1 ; /* bits 7:7 */
    ca_uint32_t drop_rx_alignerr_framesI :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MAC_STATS_INTERRUPT3_t;


#define NI_HV_XGE_MAC_STATS_INTENABLE3           0xf4304bec
#define NI_HV_XGE_MAC_STATS_INTENABLE3_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_64b_framesE       :  1 ; /* bits 0:0 */
    ca_uint32_t tx_65b_to_127b_framesE :  1 ; /* bits 1:1 */
    ca_uint32_t tx_128b_to_255b_framesE :  1 ; /* bits 2:2 */
    ca_uint32_t tx_256b_to_511b_framesE :  1 ; /* bits 3:3 */
    ca_uint32_t tx_512b_to_1023b_framesE :  1 ; /* bits 4:4 */
    ca_uint32_t tx_1024b_to_1518b_framesE :  1 ; /* bits 5:5 */
    ca_uint32_t tx_1519b_framesE     :  1 ; /* bits 6:6 */
    ca_uint32_t drop_rx_crcerr_framesE :  1 ; /* bits 7:7 */
    ca_uint32_t drop_rx_alignerr_framesE :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MAC_STATS_INTENABLE3_t;


#define NI_HV_XGE_MAC_STATS_ACCESS               0xf4304bf0
#define NI_HV_XGE_MAC_STATS_ACCESS_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt_id               :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t dbg_write            :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MAC_STATS_ACCESS_t;

#define     cnt_id_TX_GOOD_FRAMES                         0x0
#define     cnt_id_TX_GOOD_OCTETS                         0x1
#define     cnt_id_TX_PAUSE_FRAMES                        0x2
#define     cnt_id_RX_GOOD_FRAMES                         0x3
#define     cnt_id_RX_GOOD_OCTETS                         0x4
#define     cnt_id_RX_PAUSE_FRAMES                        0x5
#define     cnt_id_RX_CRC_ERR_FRAMES                      0x6
#define     cnt_id_RX_ALIGN_ERR_FRAMES                    0x7
#define     cnt_id_TX_UCAST_FRAMES                        0x8
#define     cnt_id_TX_MCAST_FRAMES                        0x9
#define     cnt_id_TX_BCAST_FRAMES                        0xa
#define     cnt_id_TX_ERR_FRAMES                          0xb
#define     cnt_id_RX_UCAST_FRAMES                        0xc
#define     cnt_id_RX_MCAST_FRAMES                        0xd
#define     cnt_id_RX_BCAST_FRAMES                        0xe
#define     cnt_id_RX_ERR_FRAMES                          0xf
#define     cnt_id_RX_OCTETS                              0x10
#define     cnt_id_RX_FRAMES                              0x11
#define     cnt_id_RX_RUNT_FRAMES                         0x12
#define     cnt_id_RX_SHORT_FRAMES                        0x13
#define     cnt_id_RX_UNDERSIZE_FRAMES                    0x14
#define     cnt_id_RX_GIANT_FRAMES                        0x15
#define     cnt_id_RX_JABBER_FRAMES                       0x16
#define     cnt_id_RX_64B_FRAMES                          0x17
#define     cnt_id_RX_65B_TO_127B_FRAMES                  0x18
#define     cnt_id_RX_128B_TO_255B_FRAMES                 0x19
#define     cnt_id_RX_256B_TO_511B_FRAMES                 0x1a
#define     cnt_id_RX_512B_TO_1023B_FRAMES                0x1b
#define     cnt_id_RX_1024B_TO_1518B_FRAMES               0x1c
#define     cnt_id_RX_1519B_TO_MAXB_FRAMES                0x1d
#define     cnt_id_TX_OCTETS                              0x1e
#define     cnt_id_TX_FRAMES                              0x1f
#define     cnt_id_TX_64B_FRAMES                          0x20
#define     cnt_id_TX_65B_TO_127B_FRAMES                  0x21
#define     cnt_id_TX_128B_TO_255B_FRAMES                 0x22
#define     cnt_id_TX_256B_TO_511B_FRAMES                 0x23
#define     cnt_id_TX_512B_TO_1023B_FRAMES                0x24
#define     cnt_id_TX_1024B_TO_1518B_FRAMES               0x25
#define     cnt_id_TX_1519B_FRAMES                        0x26
#define     cnt_id_DROP_RX_CRC_ERR_FRAMES                 0x27
#define     cnt_id_DROP_RX_ALIGN_ERR_FRAMES               0x28

#define NI_HV_XGE_MAC_STATS_DATA1                0xf4304bf4
#define NI_HV_XGE_MAC_STATS_DATA1_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MAC_STATS_DATA1_t;


#define NI_HV_XGE_MAC_STATS_DATA0                0xf4304bf8
#define NI_HV_XGE_MAC_STATS_DATA0_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MAC_STATS_DATA0_t;


#define NI_HV_XGE_MAC_MAC_ADDR_RDONLY2           0xf4304bfc
#define NI_HV_XGE_MAC_MAC_ADDR_RDONLY2_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MAC_MAC_ADDR_RDONLY2_t;


#define NI_HV_XGE_MAC_MAC_ADDR_RDONLY1           0xf4304c00
#define NI_HV_XGE_MAC_MAC_ADDR_RDONLY1_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MAC_MAC_ADDR_RDONLY1_t;


#define NI_HV_XGE_MAC_MAC_ADDR_RDONLY0           0xf4304c04
#define NI_HV_XGE_MAC_MAC_ADDR_RDONLY0_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MAC_MAC_ADDR_RDONLY0_t;


#define NI_HV_XGE_MAC_TL_BOUNDARY                0xf4304c08
#define NI_HV_XGE_MAC_TL_BOUNDARY_dft            0x00000600

typedef volatile union {
  struct {
    ca_uint32_t boundary             : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MAC_TL_BOUNDARY_t;


#define NI_HV_XGE_MAC_FMRO                       0xf4304c0c
#define NI_HV_XGE_MAC_FMRO_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data_sel             :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t clk_sel              :  2 ; /* bits 9:8 */
    ca_uint32_t rsrvd2               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MAC_FMRO_t;

#define     clk_sel_DISABLE                               0x0
#define     clk_sel_MAC                                   0x1
#define     clk_sel_322RX                                 0x2
#define     clk_sel_322TX                                 0x3
#define     data_sel_DISABLE                              0x0
#define     data_sel_322RX_1                              0x1
#define     data_sel_322RX_2                              0x2
#define     data_sel_322RX_3                              0x3
#define     data_sel_322RX_4                              0x4
#define     data_sel_322RX_5                              0x5
#define     data_sel_322RX_6                              0x6
#define     data_sel_322RX_7                              0x7
#define     data_sel_322RX_8                              0x8
#define     data_sel_322RX_9                              0x9
#define     data_sel_322RX_10                             0xa
#define     data_sel_322RX_11                             0xb
#define     data_sel_322RX_12                             0xc
#define     data_sel_322RX_13                             0xd
#define     data_sel_322TX_0                              0x10
#define     data_sel_322TX_1                              0x11
#define     data_sel_322TX_2                              0x12
#define     data_sel_322TX_3                              0x13
#define     data_sel_322TX_4                              0x14
#define     data_sel_322TX_5                              0x15
#define     data_sel_322TX_6                              0x16
#define     data_sel_322TX_7                              0x17
#define     data_sel_322TX_8                              0x18
#define     data_sel_322TX_9                              0x19
#define     data_sel_322TX_10                             0x1a
#define     data_sel_322TX_11                             0x1b
#define     data_sel_322TX_12                             0x1c
#define     data_sel_322TX_13                             0x1d
#define     data_sel_322TX_14                             0x1e
#define     data_sel_322TX_15                             0x1f
#define     data_sel_322TX_16                             0x20
#define     data_sel_322TX_17                             0x21
#define     data_sel_322TX_18                             0x22
#define     data_sel_322TX_19                             0x23
#define     data_sel_322TX_20                             0x24
#define     data_sel_322TX_21                             0x25
#define     data_sel_322TX_22                             0x26
#define     data_sel_322TX_23                             0x27
#define     data_sel_322TX_24                             0x28
#define     data_sel_322TX_25                             0x29
#define     data_sel_322TX_26                             0x2a
#define     data_sel_322TX_27                             0x2b
#define     data_sel_322TX_28                             0x2c
#define     data_sel_322TX_29                             0x2d
#define     data_sel_322TX_30                             0x2e
#define     data_sel_322TX_31                             0x2f
#define     data_sel_322TX_32                             0x30
#define     data_sel_322TX_33                             0x31
#define     data_sel_322TX_34                             0x32
#define     data_sel_322TX_35                             0x33
#define     data_sel_322TX_36                             0x34
#define     data_sel_322TX_37                             0x35
#define     data_sel_322TX_38                             0x36
#define     data_sel_322TX_39                             0x37
#define     data_sel_322TX_40                             0x38
#define     data_sel_322TX_41                             0x39
#define     data_sel_MAC_0                                0x40
#define     data_sel_MAC_1                                0x41
#define     data_sel_MAC_2                                0x42
#define     data_sel_MAC_3                                0x43
#define     data_sel_MAC_4                                0x44
#define     data_sel_MAC_5                                0x45
#define     data_sel_MAC_6                                0x46
#define     data_sel_MAC_7                                0x47
#define     data_sel_MAC_8                                0x48
#define     data_sel_MAC_9                                0x49
#define     data_sel_MAC_10                               0x4a
#define     data_sel_MAC_11                               0x4b
#define     data_sel_MAC_12                               0x4c
#define     data_sel_MAC_13                               0x4d
#define     data_sel_MAC_14                               0x4e
#define     data_sel_MAC_15                               0x4f
#define     data_sel_MAC_16                               0x50
#define     data_sel_MAC_17                               0x51
#define     data_sel_MAC_18                               0x52
#define     data_sel_MAC_19                               0x53
#define     data_sel_MAC_20                               0x54
#define     data_sel_MAC_21                               0x55
#define     data_sel_MAC_22                               0x56
#define     data_sel_MAC_23                               0x57
#define     data_sel_MAC_24                               0x58
#define     data_sel_MAC_25                               0x59
#define     data_sel_MAC_26                               0x5a
#define     data_sel_MAC_27                               0x5b
#define     data_sel_MAC_28                               0x5c
#define     data_sel_MAC_29                               0x5d
#define     data_sel_MAC_30                               0x5e
#define     data_sel_MAC_31                               0x5f
#define     data_sel_MAC_32                               0x60
#define     data_sel_MAC_33                               0x61
#define     data_sel_MAC_34                               0x62
#define     data_sel_MAC_35                               0x63
#define     data_sel_MAC_36                               0x64
#define     data_sel_MAC_37                               0x65
#define     data_sel_MAC_38                               0x66
#define     data_sel_MAC_39                               0x67
#define     data_sel_MAC_40                               0x68
#define     data_sel_MAC_41                               0x69
#define     data_sel_MAC_42                               0x6a
#define     data_sel_MAC_43                               0x6b
#define     data_sel_MAC_44                               0x6c
#define     data_sel_MAC_45                               0x6d
#define     data_sel_MAC_46                               0x6e
#define     data_sel_MAC_47                               0x6f
#define     data_sel_MAC_48                               0x70
#define     data_sel_MAC_49                               0x71
#define     data_sel_MAC_50                               0x72
#define     data_sel_MAC_51                               0x73
#define     data_sel_MAC_52                               0x74
#define     data_sel_MAC_53                               0x75
#define     data_sel_MAC_54                               0x76
#define     data_sel_MAC_55                               0x77
#define     data_sel_MAC_56                               0x78
    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* MAC */
typedef struct {
  NI_HV_XGE_MAC_CFG_COM_t                  CFG_COM;                       /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  NI_HV_XGE_MAC_CFG_RX_t                   CFG_RX;                        /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  NI_HV_XGE_MAC_CFG_TX_t                   CFG_TX;                        /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  NI_HV_XGE_MAC_CFG_TX_2_t                 CFG_TX_2;                      /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  NI_HV_XGE_MAC_CFG_TX_IFG_t               CFG_TX_IFG;                    /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  NI_HV_XGE_MAC_MAC_ADDR_A_t               MAC_ADDR_A;                    /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  NI_HV_XGE_MAC_MAC_ADDR_B_t               MAC_ADDR_B;                    /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  NI_HV_XGE_MAC_MAC_ADDR_C_t               MAC_ADDR_C;                    /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  NI_HV_XGE_MAC_VLAN_TAG1_t                VLAN_TAG1;                     /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  NI_HV_XGE_MAC_VLAN_TAG2_t                VLAN_TAG2;                     /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  NI_HV_XGE_MAC_VLAN_TAG3_t                VLAN_TAG3;                     /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  NI_HV_XGE_MAC_MINLEN_t                   MINLEN;                        /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  NI_HV_XGE_MAC_MAXLEN_t                   MAXLEN;                        /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  NI_HV_XGE_MAC_PAUSE_ADDR_A_t             PAUSE_ADDR_A;                  /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  NI_HV_XGE_MAC_PAUSE_ADDR_B_t             PAUSE_ADDR_B;                  /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  NI_HV_XGE_MAC_PAUSE_ADDR_C_t             PAUSE_ADDR_C;                  /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  NI_HV_XGE_MAC_PQUANTA_t                  PQUANTA;                       /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  NI_HV_XGE_MAC_PAUSE_TX_CMD_t             PAUSE_TX_CMD;                  /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  NI_HV_XGE_MAC_INTERRUPT_t                INTERRUPT;                     /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  NI_HV_XGE_MAC_INTENABLE_t                INTENABLE;                     /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  NI_HV_XGE_MAC_MISC_INTERRUPT_t           MISC_INTERRUPT;                /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  NI_HV_XGE_MAC_MISC_INTENABLE_t           MISC_INTENABLE;                /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  NI_HV_XGE_MAC_STATS_INTERRUPT1_t         STATS_INTERRUPT1;              /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  NI_HV_XGE_MAC_STATS_INTENABLE1_t         STATS_INTENABLE1;              /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  NI_HV_XGE_MAC_STATS_INTERRUPT2_t         STATS_INTERRUPT2;              /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  NI_HV_XGE_MAC_STATS_INTENABLE2_t         STATS_INTENABLE2;              /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  NI_HV_XGE_MAC_STATS_INTERRUPT3_t         STATS_INTERRUPT3;              /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  NI_HV_XGE_MAC_STATS_INTENABLE3_t         STATS_INTENABLE3;              /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  NI_HV_XGE_MAC_STATS_ACCESS_t             STATS_ACCESS;                  /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  NI_HV_XGE_MAC_STATS_DATA1_t              STATS_DATA1;                   /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  NI_HV_XGE_MAC_STATS_DATA0_t              STATS_DATA0;                   /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  NI_HV_XGE_MAC_MAC_ADDR_RDONLY2_t         MAC_ADDR_RDONLY2;              /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  NI_HV_XGE_MAC_MAC_ADDR_RDONLY1_t         MAC_ADDR_RDONLY1;              /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  NI_HV_XGE_MAC_MAC_ADDR_RDONLY0_t         MAC_ADDR_RDONLY0;              /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  NI_HV_XGE_MAC_TL_BOUNDARY_t              TL_BOUNDARY;                   /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  NI_HV_XGE_MAC_FMRO_t                     FMRO;                          /* addr: 0x0000008c */
} APB0_NI_HV_XGE_MAC_t;


/*
 * misc
 */
        
#define NI_HV_XGE_MISC_INTERRUPT                 0xf4304c20
#define NI_HV_XGE_MISC_INTERRUPT_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t macI                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MISC_INTERRUPT_t;


#define NI_HV_XGE_MISC_INTENABLE                 0xf4304c24
#define NI_HV_XGE_MISC_INTENABLE_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t macE                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MISC_INTENABLE_t;


#define NI_HV_XGE_MISC_CONFIG                    0xf4304c28
#define NI_HV_XGE_MISC_CONFIG_dft                0x000000ff

typedef volatile union {
  struct {
    ca_uint32_t spare                : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 16 ;
    ca_uint32_t mode322              :  1 ; /* bits 30:30 */
    ca_uint32_t gige_mode            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MISC_CONFIG_t;


#define NI_HV_XGE_MISC_FMRO                      0xf4304c2c
#define NI_HV_XGE_MISC_FMRO_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sel                  :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_XGE_MISC_FMRO_t;

#define     sel_MAC                                       0x0
#define     sel_PCS                                       0x1
#define     sel_WISRX                                     0x2
#define     sel_WISTX                                     0x3
#define     sel_PCS1GERX                                  0x4
#define     sel_PCS1GETX                                  0x5
    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* misc */
typedef struct {
  NI_HV_XGE_MISC_INTERRUPT_t               INTERRUPT;                     /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  NI_HV_XGE_MISC_INTENABLE_t               INTENABLE;                     /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  NI_HV_XGE_MISC_CONFIG_t                  CONFIG;                        /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  NI_HV_XGE_MISC_FMRO_t                    FMRO;                          /* addr: 0x0000000c */
} APB0_NI_HV_XGE_MISC_t;

    
#define APB0_NI_HV_XGE_STRIDE                    256
#define APB0_NI_HV_XGE_COUNT                     2
  
        
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* XGE */

typedef struct {
  APB0_NI_HV_XGE_MAC_t                     MAC;                           /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[89];                   
  APB0_NI_HV_XGE_MISC_t                    misc;                          /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd2[89];                   
} APB0_NI_HV_XGE_t;


/*
 * SXGMII[0..1]
 */
  
/*
 * sxgra
 */
        
#define NI_HV_SXGMII_SXGRA_LINKSPEEDCTL          0xf4305000
#define NI_HV_SXGMII_SXGRA_LINKSPEEDCTL_dft      0x00000003

typedef volatile union {
  struct {
    ca_uint32_t linkspeed            :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 12 ;
    ca_uint32_t autoneg_complete     :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd2               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_SXGMII_SXGRA_LINKSPEEDCTL_t;


#define NI_HV_SXGMII_SXGRA_SXGMISCCTL            0xf4305004
#define NI_HV_SXGMII_SXGRA_SXGMISCCTL_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t txgmfreinit          :  1 ; /* bits 0:0 */
    ca_uint32_t txxgmfreinit         :  1 ; /* bits 1:1 */
    ca_uint32_t txpcsfreinit         :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t rxpcsfreinit         :  1 ; /* bits 4:4 */
    ca_uint32_t rxxgmfreinit         :  1 ; /* bits 5:5 */
    ca_uint32_t rxgmfreinit          :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd2               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_SXGMII_SXGRA_SXGMISCCTL_t;


#define NI_HV_SXGMII_SXGRA_PCSSDSMISCCTL         0xf4305008
#define NI_HV_SXGMII_SXGRA_PCSSDSMISCCTL_dft     0x00002800

typedef volatile union {
  struct {
    ca_uint32_t clk_rdy              :  1 ; /* bits 0:0 */
    ca_uint32_t clk_rdy_sel          :  1 ; /* bits 1:1 */
    ca_uint32_t ber_notify           :  1 ; /* bits 2:2 */
    ca_uint32_t ber_notify_sel       :  1 ; /* bits 3:3 */
    ca_uint32_t rxidle               :  1 ; /* bits 4:4 */
    ca_uint32_t rxidle_sel           :  1 ; /* bits 5:5 */
    ca_uint32_t cfg_md_sel           :  1 ; /* bits 6:6 */
    ca_uint32_t cfg_frc_ld           :  1 ; /* bits 7:7 */
    ca_uint32_t v2analog_sel         :  1 ; /* bits 8:8 */
    ca_uint32_t v2analog             :  1 ; /* bits 9:9 */
    ca_uint32_t rstb_biterr_sel      :  1 ; /* bits 10:10 */
    ca_uint32_t rstb_biterr          :  1 ; /* bits 11:11 */
    ca_uint32_t oobs_rstb_sel        :  1 ; /* bits 12:12 */
    ca_uint32_t oobs_rstb            :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_SXGMII_SXGRA_PCSSDSMISCCTL_t;


#define NI_HV_SXGMII_SXGRA_MISCCTL_1             0xf430500c
#define NI_HV_SXGMII_SXGRA_MISCCTL_1_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t fcw                  : 21 ; /* bits 20:0 */
    ca_uint32_t rsrvd1               : 11 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_SXGMII_SXGRA_MISCCTL_1_t;


#define NI_HV_SXGMII_SXGRA_MISCCTL_2             0xf4305010
#define NI_HV_SXGMII_SXGRA_MISCCTL_2_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t fcw_max              : 21 ; /* bits 20:0 */
    ca_uint32_t rsrvd1               : 11 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_SXGMII_SXGRA_MISCCTL_2_t;


#define NI_HV_SXGMII_SXGRA_SXG_INTERRUPT         0xf4305014
#define NI_HV_SXGMII_SXGRA_SXG_INTERRUPT_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t txgmfptradjerr_intI  :  1 ; /* bits 0:0 */
    ca_uint32_t txxgmfptradjerr_intI :  1 ; /* bits 1:1 */
    ca_uint32_t txpfptradjerr_intI   :  1 ; /* bits 2:2 */
    ca_uint32_t rxgmfptradjerr_intI  :  1 ; /* bits 3:3 */
    ca_uint32_t rxxgmfptradjerr_intI :  1 ; /* bits 4:4 */
    ca_uint32_t rxpfptradjerr_intI   :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t linkup_intI          :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t ancfgwddet_intI      :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd3               :  3 ;
    ca_uint32_t ancfgwdabdet_intI    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd4               :  3 ;
    ca_uint32_t ancfgwdnulldet_intI  :  1 ; /* bits 20:20 */
    ca_uint32_t rsrvd5               :  3 ;
    ca_uint32_t anidledet_intI       :  1 ; /* bits 24:24 */
    ca_uint32_t rsrvd6               :  3 ;
    ca_uint32_t hwancomplete_intI    :  1 ; /* bits 28:28 */
    ca_uint32_t xfipcslnkfault_IntI  :  1 ; /* bits 29:29 */
    ca_uint32_t xfipcsrxerr_IntI     :  1 ; /* bits 30:30 */
    ca_uint32_t xfipcs_intI          :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_SXGMII_SXGRA_SXG_INTERRUPT_t;


#define NI_HV_SXGMII_SXGRA_SXG_INTENABLE         0xf4305018
#define NI_HV_SXGMII_SXGRA_SXG_INTENABLE_dft     0x00010000

typedef volatile union {
  struct {
    ca_uint32_t txgmfptradjerr_intE  :  1 ; /* bits 0:0 */
    ca_uint32_t txxgmfptradjerr_intE :  1 ; /* bits 1:1 */
    ca_uint32_t txpfptradjerr_intE   :  1 ; /* bits 2:2 */
    ca_uint32_t rxgmfptradjerr_intE  :  1 ; /* bits 3:3 */
    ca_uint32_t rxxgmfptradjerr_intE :  1 ; /* bits 4:4 */
    ca_uint32_t rxpfptradjerr_intE   :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t linkup_intE          :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t ancfgwddet_intE      :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd3               :  3 ;
    ca_uint32_t ancfgwdabdet_intE    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd4               :  3 ;
    ca_uint32_t ancfgwdnulldet_intE  :  1 ; /* bits 20:20 */
    ca_uint32_t rsrvd5               :  3 ;
    ca_uint32_t anidledet_intE       :  1 ; /* bits 24:24 */
    ca_uint32_t rsrvd6               :  3 ;
    ca_uint32_t hwancomplete_intE    :  1 ; /* bits 28:28 */
    ca_uint32_t xfipcslnkfault_intE  :  1 ; /* bits 29:29 */
    ca_uint32_t xfipcsrxerr_intE     :  1 ; /* bits 30:30 */
    ca_uint32_t xfipcs_intE          :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_SXGMII_SXGRA_SXG_INTENABLE_t;


#define NI_HV_SXGMII_SXGRA_SXGSTS                0xf430501c
#define NI_HV_SXGMII_SXGRA_SXGSTS_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t linkup               :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_SXGMII_SXGRA_SXGSTS_t;


#define NI_HV_SXGMII_SXGRA_SXGRST                0xf4305020
#define NI_HV_SXGMII_SXGRA_SXGRST_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cpureset             :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_SXGMII_SXGRA_SXGRST_t;


#define NI_HV_SXGMII_SXGRA_ANTXCFGWD             0xf4305024
#define NI_HV_SXGMII_SXGRA_ANTXCFGWD_dft         0x9c000003

typedef volatile union {
  struct {
    ca_uint32_t txcfgwd              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_SXGMII_SXGRA_ANTXCFGWD_t;


#define NI_HV_SXGMII_SXGRA_ANTXCFGWDCTL          0xf4305028
#define NI_HV_SXGMII_SXGRA_ANTXCFGWDCTL_dft      0x00000001

typedef volatile union {
  struct {
    ca_uint32_t txcfgwdctl           :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_SXGMII_SXGRA_ANTXCFGWDCTL_t;


#define NI_HV_SXGMII_SXGRA_ANTXCFGWD2            0xf430502c
#define NI_HV_SXGMII_SXGRA_ANTXCFGWD2_dft        0x9c960103

typedef volatile union {
  struct {
    ca_uint32_t txcfgwd2             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_SXGMII_SXGRA_ANTXCFGWD2_t;


#define NI_HV_SXGMII_SXGRA_ANTXCFGWD2CTL         0xf4305030
#define NI_HV_SXGMII_SXGRA_ANTXCFGWD2CTL_dft     0x00000001

typedef volatile union {
  struct {
    ca_uint32_t txcfgwd2ctl          :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_SXGMII_SXGRA_ANTXCFGWD2CTL_t;


#define NI_HV_SXGMII_SXGRA_ANTXCFGWD3            0xf4305034
#define NI_HV_SXGMII_SXGRA_ANTXCFGWD3_dft        0x9cd60103

typedef volatile union {
  struct {
    ca_uint32_t txcfgwd3             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_SXGMII_SXGRA_ANTXCFGWD3_t;


#define NI_HV_SXGMII_SXGRA_ANTXCFGWD3CTL         0xf4305038
#define NI_HV_SXGMII_SXGRA_ANTXCFGWD3CTL_dft     0x00000001

typedef volatile union {
  struct {
    ca_uint32_t txcfgwd3ctl          :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_SXGMII_SXGRA_ANTXCFGWD3CTL_t;


#define NI_HV_SXGMII_SXGRA_ANTXIDLECFGWD         0xf430503c
#define NI_HV_SXGMII_SXGRA_ANTXIDLECFGWD_dft     0x07070707

typedef volatile union {
  struct {
    ca_uint32_t txidlecfgwd          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_SXGMII_SXGRA_ANTXIDLECFGWD_t;


#define NI_HV_SXGMII_SXGRA_ANTXIDLECFGWDCTL      0xf4305040
#define NI_HV_SXGMII_SXGRA_ANTXIDLECFGWDCTL_dft  0x0000000f

typedef volatile union {
  struct {
    ca_uint32_t txidlecfgwdctl       :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_SXGMII_SXGRA_ANTXIDLECFGWDCTL_t;


#define NI_HV_SXGMII_SXGRA_ANTXCTL               0xf4305044
#define NI_HV_SXGMII_SXGRA_ANTXCTL_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t txcfgwden            :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t txcfgwd2en           :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd2               :  7 ;
    ca_uint32_t txcfgwd3en           :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd3               :  7 ;
    ca_uint32_t txidlecfgwden        :  1 ; /* bits 24:24 */
    ca_uint32_t rsrvd4               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_SXGMII_SXGRA_ANTXCTL_t;


#define NI_HV_SXGMII_SXGRA_ANRXCFGWDCTL          0xf4305048
#define NI_HV_SXGMII_SXGRA_ANRXCFGWDCTL_dft      0x0300009c

typedef volatile union {
  struct {
    ca_uint32_t rxcfgwd_ctlchar      :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 16 ;
    ca_uint32_t rxcfgwd_opcode       :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_SXGMII_SXGRA_ANRXCFGWDCTL_t;


#define NI_HV_SXGMII_SXGRA_ANRXCTL               0xf430504c
#define NI_HV_SXGMII_SXGRA_ANRXCTL_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rxcfgwddeten         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t rxcfgwdabdeten       :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t rxcfgwdnulldeten     :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd3               :  3 ;
    ca_uint32_t rxidledeten          :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd4               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_SXGMII_SXGRA_ANRXCTL_t;


#define NI_HV_SXGMII_SXGRA_ANRXCFGWDAB           0xf4305050
#define NI_HV_SXGMII_SXGRA_ANRXCFGWDAB_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rxcfgrcvd            : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_SXGMII_SXGRA_ANRXCFGWDAB_t;


#define NI_HV_SXGMII_SXGRA_ANRXCFGWD             0xf4305054
#define NI_HV_SXGMII_SXGRA_ANRXCFGWD_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rxcfgrcvd            : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_SXGMII_SXGRA_ANRXCFGWD_t;


#define NI_HV_SXGMII_SXGRA_PCSCTL                0xf4305058
#define NI_HV_SXGMII_SXGRA_PCSCTL_dft            0x80000000

typedef volatile union {
  struct {
    ca_uint32_t pcs1gen              :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t hisgmiien            :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd2               : 26 ;
    ca_uint32_t pcs1gcpureset        :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_SXGMII_SXGRA_PCSCTL_t;


#define NI_HV_SXGMII_SXGRA_SXG_INTERRUPT1        0xf430505c
#define NI_HV_SXGMII_SXGRA_SXG_INTERRUPT1_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t txgmfptradjerr_intI  :  1 ; /* bits 0:0 */
    ca_uint32_t txxgmfptradjerr_intI :  1 ; /* bits 1:1 */
    ca_uint32_t txpfptradjerr_intI   :  1 ; /* bits 2:2 */
    ca_uint32_t rxgmfptradjerr_intI  :  1 ; /* bits 3:3 */
    ca_uint32_t rxxgmfptradjerr_intI :  1 ; /* bits 4:4 */
    ca_uint32_t rxpfptradjerr_intI   :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t linkup_intI          :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t ancfgwddet_intI      :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd3               :  3 ;
    ca_uint32_t ancfgwdabdet_intI    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd4               :  3 ;
    ca_uint32_t ancfgwdnulldet_intI  :  1 ; /* bits 20:20 */
    ca_uint32_t rsrvd5               :  3 ;
    ca_uint32_t anidledet_intI       :  1 ; /* bits 24:24 */
    ca_uint32_t rsrvd6               :  4 ;
    ca_uint32_t xfipcslnkfault_IntI  :  1 ; /* bits 29:29 */
    ca_uint32_t xfipcsrxerr_IntI     :  1 ; /* bits 30:30 */
    ca_uint32_t xfipcs_intI          :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_SXGMII_SXGRA_SXG_INTERRUPT1_t;


#define NI_HV_SXGMII_SXGRA_SXG_INTENABLE1        0xf4305060
#define NI_HV_SXGMII_SXGRA_SXG_INTENABLE1_dft    0x00010000

typedef volatile union {
  struct {
    ca_uint32_t txgmfptradjerr_intE  :  1 ; /* bits 0:0 */
    ca_uint32_t txxgmfptradjerr_intE :  1 ; /* bits 1:1 */
    ca_uint32_t txpfptradjerr_intE   :  1 ; /* bits 2:2 */
    ca_uint32_t rxgmfptradjerr_intE  :  1 ; /* bits 3:3 */
    ca_uint32_t rxxgmfptradjerr_intE :  1 ; /* bits 4:4 */
    ca_uint32_t rxpfptradjerr_intE   :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t linkup_intE          :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t ancfgwddet_intE      :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd3               :  3 ;
    ca_uint32_t ancfgwdabdet_intE    :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd4               :  3 ;
    ca_uint32_t ancfgwdnulldet_intE  :  1 ; /* bits 20:20 */
    ca_uint32_t rsrvd5               :  3 ;
    ca_uint32_t anidledet_intE       :  1 ; /* bits 24:24 */
    ca_uint32_t rsrvd6               :  4 ;
    ca_uint32_t xfipcslnkfault_intE  :  1 ; /* bits 29:29 */
    ca_uint32_t xfipcsrxerr_intE     :  1 ; /* bits 30:30 */
    ca_uint32_t xfipcs_intE          :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_SXGMII_SXGRA_SXG_INTENABLE1_t;


#define NI_HV_SXGMII_SXGRA_XFIPCSMISCCTL_1       0xf4305064
#define NI_HV_SXGMII_SXGRA_XFIPCSMISCCTL_1_dft   0x00110080

typedef volatile union {
  struct {
    ca_uint32_t intp_src             :  1 ; /* bits 0:0 */
    ca_uint32_t unidir_en            :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t expand_ratio         :  5 ; /* bits 8:4 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t cfg_ack_dly          :  2 ; /* bits 13:12 */
    ca_uint32_t rsrvd3               :  2 ;
    ca_uint32_t cfg_clr_start        :  3 ; /* bits 18:16 */
    ca_uint32_t rsrvd4               :  1 ;
    ca_uint32_t cfg_clr_len          :  3 ; /* bits 22:20 */
    ca_uint32_t rsrvd5               :  9 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_SXGMII_SXGRA_XFIPCSMISCCTL_1_t;


#define NI_HV_SXGMII_SXGRA_XFIPCSMISCSTS_1       0xf4305068
#define NI_HV_SXGMII_SXGRA_XFIPCSMISCSTS_1_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t link_fault           :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_SXGMII_SXGRA_XFIPCSMISCSTS_1_t;


#define NI_HV_SXGMII_SXGRA_ANMISCCTL             0xf430506c
#define NI_HV_SXGMII_SXGRA_ANMISCCTL_dft         0x00000001

typedef volatile union {
  struct {
    ca_uint32_t blkmactxdata         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_SXGMII_SXGRA_ANMISCCTL_t;


#define NI_HV_SXGMII_SXGRA_SXGHWANCTL            0xf4305070
#define NI_HV_SXGMII_SXGRA_SXGHWANCTL_dft        0xfffff100

typedef volatile union {
  struct {
    ca_uint32_t hwanenable           :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t hwanstart            :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t hwancopyrcvdspd      :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd3               :  2 ;
    ca_uint32_t hwannoconsistchk     :  1 ; /* bits 11:11 */
    ca_uint32_t linktmr              : 20 ; /* bits 31:12 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_SXGMII_SXGRA_SXGHWANCTL_t;


#define NI_HV_SXGMII_SXGRA_SXGHWANSTS            0xf4305074
#define NI_HV_SXGMII_SXGRA_SXGHWANSTS_dft        0x00000003

typedef volatile union {
  struct {
    ca_uint32_t hwanlinkspeed        :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 12 ;
    ca_uint32_t hwancomplete         :  1 ; /* bits 15:15 */
    ca_uint32_t hwanrxcfgwd          : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_SXGMII_SXGRA_SXGHWANSTS_t;


#define NI_HV_SXGMII_SXGRA_SXGDBG1               0xf4305078
#define NI_HV_SXGMII_SXGRA_SXGDBG1_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t anstate              :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t hwanstate            :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} NI_HV_SXGMII_SXGRA_SXGDBG1_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* sxgra */
typedef struct {
  NI_HV_SXGMII_SXGRA_LINKSPEEDCTL_t        LINKSPEEDCTL;                  /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  NI_HV_SXGMII_SXGRA_SXGMISCCTL_t          SXGMISCCTL;                    /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  NI_HV_SXGMII_SXGRA_PCSSDSMISCCTL_t       PCSSDSMISCCTL;                 /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  NI_HV_SXGMII_SXGRA_MISCCTL_1_t           MISCCTL_1;                     /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  NI_HV_SXGMII_SXGRA_MISCCTL_2_t           MISCCTL_2;                     /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  NI_HV_SXGMII_SXGRA_SXG_INTERRUPT_t       SXG_INTERRUPT;                 /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  NI_HV_SXGMII_SXGRA_SXG_INTENABLE_t       SXG_INTENABLE;                 /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  NI_HV_SXGMII_SXGRA_SXGSTS_t              SXGSTS;                        /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  NI_HV_SXGMII_SXGRA_SXGRST_t              SXGRST;                        /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  NI_HV_SXGMII_SXGRA_ANTXCFGWD_t           ANTXCFGWD;                     /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  NI_HV_SXGMII_SXGRA_ANTXCFGWDCTL_t        ANTXCFGWDCTL;                  /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  NI_HV_SXGMII_SXGRA_ANTXCFGWD2_t          ANTXCFGWD2;                    /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  NI_HV_SXGMII_SXGRA_ANTXCFGWD2CTL_t       ANTXCFGWD2CTL;                 /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  NI_HV_SXGMII_SXGRA_ANTXCFGWD3_t          ANTXCFGWD3;                    /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  NI_HV_SXGMII_SXGRA_ANTXCFGWD3CTL_t       ANT