/*
 * REGISTERS.h
 *
 * THIS FILE WAS AUTOMATICALLY GENERATED BY /auto/project/bin/rdb2tt.pl
 * -config reg_generator/rdb2h.yml -db ./reg.db
 *
 * register header For Titan_bf3_may11
 */
#ifndef _TITAN_REGISTERS_H_
#define _TITAN_REGISTERS_H_

#include "ca_types.h"

/******************************************************************
 *
 * Each register in the map is defined as a struct with bitfields.
 *
 ******************************************************************/

/*
 * APB2
 */
  
/*
 * GLB
 */
        
#define GLOBAL_JTAG_ID                           0x44100000
#define GLOBAL_JTAG_ID_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t jtag_id              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_JTAG_ID_t;


#define GLOBAL_EPON_CNTL                         0x44100004
#define GLOBAL_EPON_CNTL_dft                     0x00030000

typedef volatile union {
  struct {
    ca_uint32_t epon_rst_n           :  1 ; /* bits 0:0 */
    ca_uint32_t onumpcp_rst_n        :  1 ; /* bits 1:1 */
    ca_uint32_t onugepn_rst_n        :  1 ; /* bits 2:2 */
    ca_uint32_t xgepn_rst_n          :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t rx_coresec_10_rst_n  :  1 ; /* bits 5:5 */
    ca_uint32_t tx_coresec_10_rst_n  :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t gepn_rx_rst_n        :  1 ; /* bits 8:8 */
    ca_uint32_t gepn_tx_rst_n        :  1 ; /* bits 9:9 */
    ca_uint32_t xgepn_rx_rst_n       :  1 ; /* bits 10:10 */
    ca_uint32_t xgepn_tx_rst_n       :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd3               :  4 ;
    ca_uint32_t epon_onu_mode        :  2 ; /* bits 17:16 */
    ca_uint32_t epon_ethernet_mode   :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd4               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_EPON_CNTL_t;


#define GLOBAL_EPON_STATUS                       0x44100008
#define GLOBAL_EPON_STATUS_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t xgepon_linkok        :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_EPON_STATUS_t;


#define GLOBAL_GPON_CNTL                         0x4410000c
#define GLOBAL_GPON_CNTL_dft                     0x00000300

typedef volatile union {
  struct {
    ca_uint32_t ani_rst_n            :  1 ; /* bits 0:0 */
    ca_uint32_t gpon_rst_n           :  1 ; /* bits 1:1 */
    ca_uint32_t xgpn_rst_n           :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t us10g_mode           :  1 ; /* bits 8:8 */
    ca_uint32_t nxgs_mode            :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd2               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_GPON_CNTL_t;


#define GLOBAL_OPT_MODULE_CNTL                   0x44100010
#define GLOBAL_OPT_MODULE_CNTL_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t opt_tx_power_down    :  1 ; /* bits 0:0 */
    ca_uint32_t en_lao_det           :  1 ; /* bits 1:1 */
    ca_uint32_t hw_lao_enable        :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_OPT_MODULE_CNTL_t;


#define GLOBAL_OPT_MODULE_LAO_CNTL               0x44100014
#define GLOBAL_OPT_MODULE_LAO_CNTL_dft           0x00ff00ff

typedef volatile union {
  struct {
    ca_uint32_t lao_accu_one         : 16 ; /* bits 15:0 */
    ca_uint32_t lao_accu_zero        : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_OPT_MODULE_LAO_CNTL_t;


#define GLOBAL_OPT_INTERRUPT                     0x44100018
#define GLOBAL_OPT_INTERRUPT_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_los               :  1 ; /* bits 0:0 */
    ca_uint32_t tx_fault             :  1 ; /* bits 1:1 */
    ca_uint32_t mod_abs              :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t lao_stuck_at_one_int :  1 ; /* bits 8:8 */
    ca_uint32_t lao_stuck_at_zero_int :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd2               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_OPT_INTERRUPT_t;


#define GLOBAL_OPT_INTENABLE                     0x4410001c
#define GLOBAL_OPT_INTENABLE_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_losE              :  1 ; /* bits 0:0 */
    ca_uint32_t tx_faultE            :  1 ; /* bits 1:1 */
    ca_uint32_t mod_absE             :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t lao_stuck_at_one_intE :  1 ; /* bits 8:8 */
    ca_uint32_t lao_stuck_at_zero_intE :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd2               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_OPT_INTENABLE_t;


#define GLOBAL_OPT_MODULE_STATUS                 0x44100020
#define GLOBAL_OPT_MODULE_STATUS_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t opt_tx_fault         :  1 ; /* bits 0:0 */
    ca_uint32_t opt_tx_sd            :  1 ; /* bits 1:1 */
    ca_uint32_t opt_mod_abs          :  1 ; /* bits 2:2 */
    ca_uint32_t opt_rx_los           :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_OPT_MODULE_STATUS_t;


#define GLOBAL_PON_CNTL                          0x44100024
#define GLOBAL_PON_CNTL_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t epon_mode            :  1 ; /* bits 0:0 */
    ca_uint32_t pon_serdes_rst_n     :  1 ; /* bits 1:1 */
    ca_uint32_t psds_reg_rst_n       :  1 ; /* bits 2:2 */
    ca_uint32_t ptp_rst_n            :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t puc_reset            :  1 ; /* bits 8:8 */
    ca_uint32_t pdc_reset            :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd2               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_PON_CNTL_t;


#define GLOBAL_BLOCK_RESET                       0x44100028
#define GLOBAL_BLOCK_RESET_dft                   0x4f29003f

typedef volatile union {
  struct {
    ca_uint32_t reset_ni             :  1 ; /* bits 0:0 */
    ca_uint32_t reset_l2fe           :  1 ; /* bits 1:1 */
    ca_uint32_t reset_l2tm           :  1 ; /* bits 2:2 */
    ca_uint32_t reset_l3fe           :  1 ; /* bits 3:3 */
    ca_uint32_t reset_sdram          :  1 ; /* bits 4:4 */
    ca_uint32_t reset_tqm            :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t reset_flash          :  1 ; /* bits 14:14 */
    ca_uint32_t reset_per            :  1 ; /* bits 15:15 */
    ca_uint32_t reset_dma            :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t reset_cpu_ap         :  1 ; /* bits 18:18 */
    ca_uint32_t reset_cpu_dsp        :  1 ; /* bits 19:19 */
    ca_uint32_t reset_rcpu0          :  1 ; /* bits 20:20 */
    ca_uint32_t reset_rcpu1          :  1 ; /* bits 21:21 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t reset_taroko0_atu    :  1 ; /* bits 23:23 */
    ca_uint32_t reset_taroko1_atu    :  1 ; /* bits 24:24 */
    ca_uint32_t reset_ldma           :  1 ; /* bits 25:25 */
    ca_uint32_t reset_fbm            :  1 ; /* bits 26:26 */
    ca_uint32_t reset_eaxi           :  1 ; /* bits 27:27 */
    ca_uint32_t reset_sd             :  1 ; /* bits 28:28 */
    ca_uint32_t reset_otprom         :  1 ; /* bits 29:29 */
    ca_uint32_t reset_iic_slv        :  1 ; /* bits 30:30 */
    ca_uint32_t rsrvd4               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_BLOCK_RESET_t;


#define GLOBAL_GPHY_STATUS                       0x4410002c
#define GLOBAL_GPHY_STATUS_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t anaprob              :  1 ; /* bits 0:0 */
    ca_uint32_t prob_av_cen_l        :  1 ; /* bits 1:1 */
    ca_uint32_t prob_dv_cen_l        :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_GPHY_STATUS_t;


#define GLOBAL_FABRIC_RESET                      0x44100030
#define GLOBAL_FABRIC_RESET_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t reset_capsram        :  1 ; /* bits 1:1 */
    ca_uint32_t reset_capsramreg     :  1 ; /* bits 2:2 */
    ca_uint32_t reset_cpu_sw         :  1 ; /* bits 3:3 */
    ca_uint32_t reset_ne_sw          :  1 ; /* bits 4:4 */
    ca_uint32_t reset_io_sw          :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd2               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_FABRIC_RESET_t;


#define GLOBAL_STRAP                             0x44100034
#define GLOBAL_STRAP_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t debug_mode           :  1 ; /* bits 0:0 */
    ca_uint32_t speed                :  2 ; /* bits 2:1 */
    ca_uint32_t dsp_avail            :  1 ; /* bits 3:3 */
    ca_uint32_t chip_type            :  2 ; /* bits 5:4 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t sd_emmc_avail        :  1 ; /* bits 7:7 */
    ca_uint32_t flashSize            :  2 ; /* bits 9:8 */
    ca_uint32_t flashWidth           :  1 ; /* bits 10:10 */
    ca_uint32_t flashPin             :  1 ; /* bits 11:11 */
    ca_uint32_t flashType            :  3 ; /* bits 14:12 */
    ca_uint32_t uart_message         :  1 ; /* bits 15:15 */
    ca_uint32_t sd                   :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd2               :  5 ;
    ca_uint32_t misc_mode            :  8 ; /* bits 29:22 */
    ca_uint32_t jtag_osc_2           :  1 ; /* bits 30:30 */
    ca_uint32_t jtag_osc_3           :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_STRAP_t;


#define GLOBAL_STRAP_OVERRIDE                    0x44100038
#define GLOBAL_STRAP_OVERRIDE_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t speed                :  2 ; /* bits 2:1 */
    ca_uint32_t dsp_avail            :  1 ; /* bits 3:3 */
    ca_uint32_t chip_type            :  2 ; /* bits 5:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t sd_emmc_avail        :  1 ; /* bits 7:7 */
    ca_uint32_t flashSize            :  2 ; /* bits 9:8 */
    ca_uint32_t flashWidth           :  1 ; /* bits 10:10 */
    ca_uint32_t flashPin             :  1 ; /* bits 11:11 */
    ca_uint32_t flashType            :  3 ; /* bits 14:12 */
    ca_uint32_t uart_message         :  1 ; /* bits 15:15 */
    ca_uint32_t sd                   :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd3               :  5 ;
    ca_uint32_t misc_mode            :  8 ; /* bits 29:22 */
    ca_uint32_t rsrvd4               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_STRAP_OVERRIDE_t;


#define GLOBAL_STRAP_OVERRIDE_VALUE              0x4410003c
#define GLOBAL_STRAP_OVERRIDE_VALUE_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t speed                :  2 ; /* bits 2:1 */
    ca_uint32_t dsp_avail            :  1 ; /* bits 3:3 */
    ca_uint32_t chip_type            :  2 ; /* bits 5:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t sd_emmc_avail        :  1 ; /* bits 7:7 */
    ca_uint32_t flashSize            :  2 ; /* bits 9:8 */
    ca_uint32_t flashWidth           :  1 ; /* bits 10:10 */
    ca_uint32_t flashPin             :  1 ; /* bits 11:11 */
    ca_uint32_t flashType            :  3 ; /* bits 14:12 */
    ca_uint32_t uart_message         :  1 ; /* bits 15:15 */
    ca_uint32_t sd                   :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd3               :  5 ;
    ca_uint32_t misc_mode            :  8 ; /* bits 29:22 */
    ca_uint32_t rsrvd4               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_STRAP_OVERRIDE_VALUE_t;


#define GLOBAL_BIST_RESULT                       0x44100040
#define GLOBAL_BIST_RESULT_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bist_complete_capsram :  1 ; /* bits 0:0 */
    ca_uint32_t bist_complete_l3qm2  :  1 ; /* bits 1:1 */
    ca_uint32_t bist_complete_l3qm1  :  1 ; /* bits 2:2 */
    ca_uint32_t bist_complete_l2tm2  :  1 ; /* bits 3:3 */
    ca_uint32_t bist_complete_l2tm1  :  1 ; /* bits 4:4 */
    ca_uint32_t bist_complete_taroko_im0 :  1 ; /* bits 5:5 */
    ca_uint32_t bist_complete_taroko_dm0 :  1 ; /* bits 6:6 */
    ca_uint32_t bist_complete_taroko_im1 :  1 ; /* bits 7:7 */
    ca_uint32_t bist_complete_taroko_dm1 :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t capsram              : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_BIST_RESULT_t;


#define GLOBAL_BIST_DATA                         0x44100044
#define GLOBAL_BIST_DATA_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t capsram              :  3 ; /* bits 10:8 */
    ca_uint32_t l3qm2                :  5 ; /* bits 15:11 */
    ca_uint32_t l3qm1                :  5 ; /* bits 20:16 */
    ca_uint32_t l2tm2                :  5 ; /* bits 25:21 */
    ca_uint32_t l2tm1                :  5 ; /* bits 30:26 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_BIST_DATA_t;


#define GLOBAL_GLOBAL_CONFIG                     0x44100048
#define GLOBAL_GLOBAL_CONFIG_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t wd_reset_subsys_enable :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t wd_reset_all_blocks  :  1 ; /* bits 6:6 */
    ca_uint32_t wd_reset_remap       :  1 ; /* bits 7:7 */
    ca_uint32_t wd_reset_ext_reset   :  1 ; /* bits 8:8 */
    ca_uint32_t ext_reset            :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd3               :  6 ;
    ca_uint32_t gpon_pd              :  1 ; /* bits 16:16 */
    ca_uint32_t epon_pd              :  1 ; /* bits 17:17 */
    ca_uint32_t l3fe_pd              :  1 ; /* bits 18:18 */
    ca_uint32_t per_pd               :  1 ; /* bits 19:19 */
    ca_uint32_t flash_pd             :  1 ; /* bits 20:20 */
    ca_uint32_t sd_pd                :  1 ; /* bits 21:21 */
    ca_uint32_t iosw_pd              :  1 ; /* bits 22:22 */
    ca_uint32_t rsrvd4               :  9 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_GLOBAL_CONFIG_t;


#define GLOBAL_PHY_CONTROL                       0x4410004c
#define GLOBAL_PHY_CONTROL_dft                   0x00000001

typedef volatile union {
  struct {
    ca_uint32_t cfg_xfi0_10g         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 27 ;
    ca_uint32_t s0_p_mdio_enable_reg :  1 ; /* bits 28:28 */
    ca_uint32_t rsrvd2               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_PHY_CONTROL_t;


#define GLOBAL_PIN_MUX                           0x44100050
#define GLOBAL_PIN_MUX_dft                       0x02080004

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t flash_mux_sel        :  1 ; /* bits 2:2 */
    ca_uint32_t iomux_uart_1_enable  :  1 ; /* bits 3:3 */
    ca_uint32_t iomux_led_enable     :  1 ; /* bits 4:4 */
    ca_uint32_t iomux_pwm_enable     :  1 ; /* bits 5:5 */
    ca_uint32_t iomux_spi_cs1_en     :  1 ; /* bits 6:6 */
    ca_uint32_t iomux_uart_0_hwfc_enable :  1 ; /* bits 7:7 */
    ca_uint32_t iomux_rtk_biws_enable :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t iomux_sd_volt_reg    :  1 ; /* bits 11:11 */
    ca_uint32_t iomux_g3_comm        :  1 ; /* bits 12:12 */
    ca_uint32_t iomux_sd_mmc_resetn  :  1 ; /* bits 13:13 */
    ca_uint32_t iomux_optical_pwdn_enable :  1 ; /* bits 14:14 */
    ca_uint32_t iomux_frac_clk_en_extsclk :  1 ; /* bits 15:15 */
    ca_uint32_t iomux_frac_clk_en_extclk :  1 ; /* bits 16:16 */
    ca_uint32_t iomux_tdm_wan_clk    :  1 ; /* bits 17:17 */
    ca_uint32_t iomux_tdm_wan_clk_sel :  1 ; /* bits 18:18 */
    ca_uint32_t iomux_eaxi_enable    :  1 ; /* bits 19:19 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t iomux_use_cspi       :  1 ; /* bits 21:21 */
    ca_uint32_t iomux_sflash_cs1_en  :  1 ; /* bits 22:22 */
    ca_uint32_t iomux_intout_enable  :  1 ; /* bits 23:23 */
    ca_uint32_t iomux_sflash4_enable :  1 ; /* bits 24:24 */
    ca_uint32_t iomux_pado_spare_1   :  1 ; /* bits 25:25 */
    ca_uint32_t iomux_pade_spare_1   :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd4               :  4 ;
    ca_uint32_t fmro_enable          :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_PIN_MUX_t;


#define GLOBAL_IO_DRIVE_CONTROL                  0x44100054
#define GLOBAL_IO_DRIVE_CONTROL_dft              0x00330000

typedef volatile union {
  struct {
    ca_uint32_t gmac_dp              :  3 ; /* bits 2:0 */
    ca_uint32_t gmac_dn              :  3 ; /* bits 5:3 */
    ca_uint32_t gmac_mode            :  2 ; /* bits 7:6 */
    ca_uint32_t gmac_ds              :  1 ; /* bits 8:8 */
    ca_uint32_t flash_ds             :  1 ; /* bits 9:9 */
    ca_uint32_t nu_ds                :  1 ; /* bits 10:10 */
    ca_uint32_t ssp_ds               :  1 ; /* bits 11:11 */
    ca_uint32_t spi_ds               :  1 ; /* bits 12:12 */
    ca_uint32_t gpio_ds              :  1 ; /* bits 13:13 */
    ca_uint32_t misc_ds              :  1 ; /* bits 14:14 */
    ca_uint32_t eaxi_ds              :  1 ; /* bits 15:15 */
    ca_uint32_t sd_ds                :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_IO_DRIVE_CONTROL_t;


#define GLOBAL_GPIO_MUX_0                        0x44100058
#define GLOBAL_GPIO_MUX_0_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gpio0en              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_GPIO_MUX_0_t;


#define GLOBAL_GPIO_MUX_1                        0x4410005c
#define GLOBAL_GPIO_MUX_1_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gpio1en              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_GPIO_MUX_1_t;


#define GLOBAL_GPIO_MUX_2                        0x44100060
#define GLOBAL_GPIO_MUX_2_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gpio2en              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_GPIO_MUX_2_t;


#define GLOBAL_GPIO_MUX_3                        0x44100064
#define GLOBAL_GPIO_MUX_3_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gpio3en              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_GPIO_MUX_3_t;


#define GLOBAL_GIGE_PHY                          0x44100068
#define GLOBAL_GIGE_PHY_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gphy_phyrst_cen_b    :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_GIGE_PHY_t;


#define GLOBAL_TAROKO_STATE                      0x4410006c
#define GLOBAL_TAROKO_STATE_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cpu_ap_debug_mode    :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t cpu_ap_power_down_out :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd2               :  5 ;
    ca_uint32_t cpu_dsp_debug_mode   :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t cpu_dsp_power_down_out :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd4               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_TAROKO_STATE_t;


#define GLOBAL_SYSTEM_INTERRUPT_0                0x44100070
#define GLOBAL_SYSTEM_INTERRUPT_0_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t misc_intr_i          :  1 ; /* bits 0:0 */
    ca_uint32_t ddr_ctrl_i           :  1 ; /* bits 1:1 */
    ca_uint32_t flash_irqReqi        :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t PER_UART0_INTi       :  1 ; /* bits 4:4 */
    ca_uint32_t PER_UART1_INTi       :  1 ; /* bits 5:5 */
    ca_uint32_t gphy_mac_inti        :  1 ; /* bits 6:6 */
    ca_uint32_t psds_prbs_inti       :  1 ; /* bits 7:7 */
    ca_uint32_t cpu_ap_clkchange_complete_int :  1 ; /* bits 8:8 */
    ca_uint32_t cpu_dsp_clkchange_complete_int :  1 ; /* bits 9:9 */
    ca_uint32_t cpu_ap_clkchange_failed_int :  1 ; /* bits 10:10 */
    ca_uint32_t cpu_dsp_clkchange_failed_int :  1 ; /* bits 11:11 */
    ca_uint32_t titan_int            :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd2               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_SYSTEM_INTERRUPT_0_t;


#define GLOBAL_SYSTEM_INTENABLE_0                0x44100074
#define GLOBAL_SYSTEM_INTENABLE_0_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t misc_intr_e          :  1 ; /* bits 0:0 */
    ca_uint32_t ddr_ctrl_e           :  1 ; /* bits 1:1 */
    ca_uint32_t flash_irqReqe        :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t PER_UART0_INTe       :  1 ; /* bits 4:4 */
    ca_uint32_t PER_UART1_INTe       :  1 ; /* bits 5:5 */
    ca_uint32_t gphy_mac_inte        :  1 ; /* bits 6:6 */
    ca_uint32_t psds_prbs_inte       :  1 ; /* bits 7:7 */
    ca_uint32_t cpu_ap_clkchange_complete_inte :  1 ; /* bits 8:8 */
    ca_uint32_t cpu_dsp_clkchange_complete_inte :  1 ; /* bits 9:9 */
    ca_uint32_t cpu_ap_clkchange_failed_inte :  1 ; /* bits 10:10 */
    ca_uint32_t cpu_dsp_clkchange_failed_inte :  1 ; /* bits 11:11 */
    ca_uint32_t titan_inte           :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd2               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_SYSTEM_INTENABLE_0_t;


#define GLOBAL_SW_INTERRUPT_0                    0x44100078
#define GLOBAL_SW_INTERRUPT_0_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sw_int               :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_SW_INTERRUPT_0_t;


#define GLOBAL_CPU_IPC_SOFT_INTERRUPT_0          0x4410007c
#define GLOBAL_CPU_IPC_SOFT_INTERRUPT_0_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t IRQ_soft0iSeti       :  1 ; /* bits 0:0 */
    ca_uint32_t IRQ_soft1iSeti       :  1 ; /* bits 1:1 */
    ca_uint32_t ipc_int_pe0i         :  1 ; /* bits 2:2 */
    ca_uint32_t ipc_int_pe1i         :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_CPU_IPC_SOFT_INTERRUPT_0_t;


#define GLOBAL_CPU_IPC_SOFT_INTENABLE_0          0x44100080
#define GLOBAL_CPU_IPC_SOFT_INTENABLE_0_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t IRQ_soft0iSete       :  1 ; /* bits 0:0 */
    ca_uint32_t IRQ_soft1iSete       :  1 ; /* bits 1:1 */
    ca_uint32_t ipc_int_pe0e         :  1 ; /* bits 2:2 */
    ca_uint32_t ipc_int_pe1e         :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_CPU_IPC_SOFT_INTENABLE_0_t;


#define GLOBAL_CPU_LSOSSPFBM_INTERRUPT_0         0x44100084
#define GLOBAL_CPU_LSOSSPFBM_INTERRUPT_0_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t DMA_LSO_INTERRUPTi   :  8 ; /* bits 7:0 */
    ca_uint32_t DMA_SSP_INTERRUPTi   :  8 ; /* bits 15:8 */
    ca_uint32_t FBM_IRQi             :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_CPU_LSOSSPFBM_INTERRUPT_0_t;


#define GLOBAL_CPU_LSOSSPFBM_INTENABLE0          0x44100088
#define GLOBAL_CPU_LSOSSPFBM_INTENABLE0_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t DMA_LSO_INTERRUPTe   :  8 ; /* bits 7:0 */
    ca_uint32_t DMA_SSP_INTERRUPTe   :  8 ; /* bits 15:8 */
    ca_uint32_t FBM_IRQe             :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_CPU_LSOSSPFBM_INTENABLE0_t;


#define GLOBAL_LDMA_INTERRUPT_0                  0x4410008c
#define GLOBAL_LDMA_INTERRUPT_0_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ldma_irqi            :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_LDMA_INTERRUPT_0_t;


#define GLOBAL_LDMA_INTENABLE0                   0x44100090
#define GLOBAL_LDMA_INTENABLE0_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ldma_irqe            :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_LDMA_INTENABLE0_t;


#define GLOBAL_CPU_QM_INTERRUPT_0                0x44100094
#define GLOBAL_CPU_QM_INTERRUPT_0_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t CPU_EPP_FIFO_0i      :  1 ; /* bits 8:8 */
    ca_uint32_t CPU_EPP_FIFO_1i      :  1 ; /* bits 9:9 */
    ca_uint32_t CPU_EPP_FIFO_2i      :  1 ; /* bits 10:10 */
    ca_uint32_t CPU_EPP_FIFO_3i      :  1 ; /* bits 11:11 */
    ca_uint32_t CPU_EPP_FIFO_4i      :  1 ; /* bits 12:12 */
    ca_uint32_t CPU_EPP_FIFO_5i      :  1 ; /* bits 13:13 */
    ca_uint32_t CPU_EPP_FIFO_6i      :  1 ; /* bits 14:14 */
    ca_uint32_t CPU_EPP_FIFO_7i      :  1 ; /* bits 15:15 */
    ca_uint32_t CPU_REFILL_REQ_0i    :  1 ; /* bits 16:16 */
    ca_uint32_t CPU_REFILL_REQ_1i    :  1 ; /* bits 17:17 */
    ca_uint32_t CPU_REFILL_REQ_2i    :  1 ; /* bits 18:18 */
    ca_uint32_t CPU_REFILL_REQ_3i    :  1 ; /* bits 19:19 */
    ca_uint32_t CPU_REFILL_REQ_4i    :  1 ; /* bits 20:20 */
    ca_uint32_t CPU_REFILL_REQ_5i    :  1 ; /* bits 21:21 */
    ca_uint32_t CPU_REFILL_REQ_6i    :  1 ; /* bits 22:22 */
    ca_uint32_t CPU_REFILL_REQ_7i    :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd2               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_CPU_QM_INTERRUPT_0_t;


#define GLOBAL_CPU_QM_INTENABLE_0                0x44100098
#define GLOBAL_CPU_QM_INTENABLE_0_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t CPU_EPP_FIFO_0e      :  1 ; /* bits 8:8 */
    ca_uint32_t CPU_EPP_FIFO_1e      :  1 ; /* bits 9:9 */
    ca_uint32_t CPU_EPP_FIFO_2e      :  1 ; /* bits 10:10 */
    ca_uint32_t CPU_EPP_FIFO_3e      :  1 ; /* bits 11:11 */
    ca_uint32_t CPU_EPP_FIFO_4e      :  1 ; /* bits 12:12 */
    ca_uint32_t CPU_EPP_FIFO_5e      :  1 ; /* bits 13:13 */
    ca_uint32_t CPU_EPP_FIFO_6e      :  1 ; /* bits 14:14 */
    ca_uint32_t CPU_EPP_FIFO_7e      :  1 ; /* bits 15:15 */
    ca_uint32_t CPU_REFILL_REQ_0e    :  1 ; /* bits 16:16 */
    ca_uint32_t CPU_REFILL_REQ_1e    :  1 ; /* bits 17:17 */
    ca_uint32_t CPU_REFILL_REQ_2e    :  1 ; /* bits 18:18 */
    ca_uint32_t CPU_REFILL_REQ_3e    :  1 ; /* bits 19:19 */
    ca_uint32_t CPU_REFILL_REQ_4e    :  1 ; /* bits 20:20 */
    ca_uint32_t CPU_REFILL_REQ_5e    :  1 ; /* bits 21:21 */
    ca_uint32_t CPU_REFILL_REQ_6e    :  1 ; /* bits 22:22 */
    ca_uint32_t CPU_REFILL_REQ_7e    :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd2               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_CPU_QM_INTENABLE_0_t;


#define GLOBAL_NETWORK_ENGINE_INTERRUPT_0        0x4410009c
#define GLOBAL_NETWORK_ENGINE_INTERRUPT_0_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t NIi                  :  1 ; /* bits 0:0 */
    ca_uint32_t L2FEi                :  1 ; /* bits 1:1 */
    ca_uint32_t L2TMi                :  1 ; /* bits 2:2 */
    ca_uint32_t L3TEi                :  1 ; /* bits 3:3 */
    ca_uint32_t TQMi                 :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t WOL_inti             :  1 ; /* bits 7:7 */
    ca_uint32_t XFI0_inti            :  1 ; /* bits 8:8 */
    ca_uint32_t XFI1_inti            :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd2               :  6 ;
    ca_uint32_t PTPi                 :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd3               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_NETWORK_ENGINE_INTERRUPT_0_t;


#define GLOBAL_NETWORK_ENGINE_INTENABLE_0        0x441000a0
#define GLOBAL_NETWORK_ENGINE_INTENABLE_0_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t NIe                  :  1 ; /* bits 0:0 */
    ca_uint32_t L2FEe                :  1 ; /* bits 1:1 */
    ca_uint32_t L2TMe                :  1 ; /* bits 2:2 */
    ca_uint32_t L3TEe                :  1 ; /* bits 3:3 */
    ca_uint32_t TQMe                 :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t WOL_inte             :  1 ; /* bits 7:7 */
    ca_uint32_t XFI0_inte            :  1 ; /* bits 8:8 */
    ca_uint32_t XFI1_inte            :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd2               :  6 ;
    ca_uint32_t PTPe                 :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd3               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_NETWORK_ENGINE_INTENABLE_0_t;


#define GLOBAL_SYSTEM_INTERRUPT_1                0x441000a4
#define GLOBAL_SYSTEM_INTERRUPT_1_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t misc_intr_i          :  1 ; /* bits 0:0 */
    ca_uint32_t ddr_ctrl_i           :  1 ; /* bits 1:1 */
    ca_uint32_t flash_irqReqi        :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t PER_UART0_INTi       :  1 ; /* bits 4:4 */
    ca_uint32_t PER_UART1_INTi       :  1 ; /* bits 5:5 */
    ca_uint32_t gphy_mac_inti        :  1 ; /* bits 6:6 */
    ca_uint32_t psds_prbs_inti       :  1 ; /* bits 7:7 */
    ca_uint32_t cpu_ap_clkchange_complete_int :  1 ; /* bits 8:8 */
    ca_uint32_t cpu_dsp_clkchange_complete_int :  1 ; /* bits 9:9 */
    ca_uint32_t cpu_ap_clkchange_failed_int :  1 ; /* bits 10:10 */
    ca_uint32_t cpu_dsp_clkchange_failed_int :  1 ; /* bits 11:11 */
    ca_uint32_t titan_int            :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd2               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_SYSTEM_INTERRUPT_1_t;


#define GLOBAL_SYSTEM_INTENABLE_1                0x441000a8
#define GLOBAL_SYSTEM_INTENABLE_1_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t misc_intr_e          :  1 ; /* bits 0:0 */
    ca_uint32_t ddr_ctrl_e           :  1 ; /* bits 1:1 */
    ca_uint32_t flash_irqReqe        :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t PER_UART0_INTe       :  1 ; /* bits 4:4 */
    ca_uint32_t PER_UART1_INTe       :  1 ; /* bits 5:5 */
    ca_uint32_t gphy_mac_inte        :  1 ; /* bits 6:6 */
    ca_uint32_t psds_prbs_inte       :  1 ; /* bits 7:7 */
    ca_uint32_t cpu_ap_clkchange_complete_inte :  1 ; /* bits 8:8 */
    ca_uint32_t cpu_dsp_clkchange_complete_inte :  1 ; /* bits 9:9 */
    ca_uint32_t cpu_ap_clkchange_failed_inte :  1 ; /* bits 10:10 */
    ca_uint32_t cpu_dsp_clkchange_failed_inte :  1 ; /* bits 11:11 */
    ca_uint32_t titan_inte           :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd2               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_SYSTEM_INTENABLE_1_t;


#define GLOBAL_SW_INTERRUPT_1                    0x441000ac
#define GLOBAL_SW_INTERRUPT_1_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sw_int               :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_SW_INTERRUPT_1_t;


#define GLOBAL_CPU_IPC_SOFT_INTERRUPT_1          0x441000b0
#define GLOBAL_CPU_IPC_SOFT_INTERRUPT_1_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t IRQ_soft0iSeti       :  1 ; /* bits 0:0 */
    ca_uint32_t IRQ_soft1iSeti       :  1 ; /* bits 1:1 */
    ca_uint32_t ipc_int_pe0i         :  1 ; /* bits 2:2 */
    ca_uint32_t ipc_int_pe1i         :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_CPU_IPC_SOFT_INTERRUPT_1_t;


#define GLOBAL_CPU_IPC_SOFT_INTENABLE_1          0x441000b4
#define GLOBAL_CPU_IPC_SOFT_INTENABLE_1_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t IRQ_soft0iSete       :  1 ; /* bits 0:0 */
    ca_uint32_t IRQ_soft1iSete       :  1 ; /* bits 1:1 */
    ca_uint32_t ipc_int_pe0e         :  1 ; /* bits 2:2 */
    ca_uint32_t ipc_int_pe1e         :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_CPU_IPC_SOFT_INTENABLE_1_t;


#define GLOBAL_CPU_LSOSSPFBM_INTERRUPT_1         0x441000b8
#define GLOBAL_CPU_LSOSSPFBM_INTERRUPT_1_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t DMA_LSO_INTERRUPTi   :  8 ; /* bits 7:0 */
    ca_uint32_t DMA_SSP_INTERRUPTi   :  8 ; /* bits 15:8 */
    ca_uint32_t FBM_IRQi             :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_CPU_LSOSSPFBM_INTERRUPT_1_t;


#define GLOBAL_CPU_LSOSSPFBM_INTENABLE1          0x441000bc
#define GLOBAL_CPU_LSOSSPFBM_INTENABLE1_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t DMA_LSO_INTERRUPTe   :  8 ; /* bits 7:0 */
    ca_uint32_t DMA_SSP_INTERRUPTe   :  8 ; /* bits 15:8 */
    ca_uint32_t FBM_IRQe             :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_CPU_LSOSSPFBM_INTENABLE1_t;


#define GLOBAL_LDMA_INTERRUPT_1                  0x441000c0
#define GLOBAL_LDMA_INTERRUPT_1_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ldma_irqi            :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_LDMA_INTERRUPT_1_t;


#define GLOBAL_LDMA_INTENABLE1                   0x441000c4
#define GLOBAL_LDMA_INTENABLE1_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ldma_irqe            :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_LDMA_INTENABLE1_t;


#define GLOBAL_CPU_QM_INTERRUPT_1                0x441000c8
#define GLOBAL_CPU_QM_INTERRUPT_1_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t CPU_EPP_FIFO_0i      :  1 ; /* bits 8:8 */
    ca_uint32_t CPU_EPP_FIFO_1i      :  1 ; /* bits 9:9 */
    ca_uint32_t CPU_EPP_FIFO_2i      :  1 ; /* bits 10:10 */
    ca_uint32_t CPU_EPP_FIFO_3i      :  1 ; /* bits 11:11 */
    ca_uint32_t CPU_EPP_FIFO_4i      :  1 ; /* bits 12:12 */
    ca_uint32_t CPU_EPP_FIFO_5i      :  1 ; /* bits 13:13 */
    ca_uint32_t CPU_EPP_FIFO_6i      :  1 ; /* bits 14:14 */
    ca_uint32_t CPU_EPP_FIFO_7i      :  1 ; /* bits 15:15 */
    ca_uint32_t CPU_REFILL_REQ_0i    :  1 ; /* bits 16:16 */
    ca_uint32_t CPU_REFILL_REQ_1i    :  1 ; /* bits 17:17 */
    ca_uint32_t CPU_REFILL_REQ_2i    :  1 ; /* bits 18:18 */
    ca_uint32_t CPU_REFILL_REQ_3i    :  1 ; /* bits 19:19 */
    ca_uint32_t CPU_REFILL_REQ_4i    :  1 ; /* bits 20:20 */
    ca_uint32_t CPU_REFILL_REQ_5i    :  1 ; /* bits 21:21 */
    ca_uint32_t CPU_REFILL_REQ_6i    :  1 ; /* bits 22:22 */
    ca_uint32_t CPU_REFILL_REQ_7i    :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd2               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_CPU_QM_INTERRUPT_1_t;


#define GLOBAL_CPU_QM_INTENABLE_1                0x441000cc
#define GLOBAL_CPU_QM_INTENABLE_1_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t CPU_EPP_FIFO_0e      :  1 ; /* bits 8:8 */
    ca_uint32_t CPU_EPP_FIFO_1e      :  1 ; /* bits 9:9 */
    ca_uint32_t CPU_EPP_FIFO_2e      :  1 ; /* bits 10:10 */
    ca_uint32_t CPU_EPP_FIFO_3e      :  1 ; /* bits 11:11 */
    ca_uint32_t CPU_EPP_FIFO_4e      :  1 ; /* bits 12:12 */
    ca_uint32_t CPU_EPP_FIFO_5e      :  1 ; /* bits 13:13 */
    ca_uint32_t CPU_EPP_FIFO_6e      :  1 ; /* bits 14:14 */
    ca_uint32_t CPU_EPP_FIFO_7e      :  1 ; /* bits 15:15 */
    ca_uint32_t CPU_REFILL_REQ_0e    :  1 ; /* bits 16:16 */
    ca_uint32_t CPU_REFILL_REQ_1e    :  1 ; /* bits 17:17 */
    ca_uint32_t CPU_REFILL_REQ_2e    :  1 ; /* bits 18:18 */
    ca_uint32_t CPU_REFILL_REQ_3e    :  1 ; /* bits 19:19 */
    ca_uint32_t CPU_REFILL_REQ_4e    :  1 ; /* bits 20:20 */
    ca_uint32_t CPU_REFILL_REQ_5e    :  1 ; /* bits 21:21 */
    ca_uint32_t CPU_REFILL_REQ_6e    :  1 ; /* bits 22:22 */
    ca_uint32_t CPU_REFILL_REQ_7e    :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd2               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_CPU_QM_INTENABLE_1_t;


#define GLOBAL_NETWORK_ENGINE_INTERRUPT_1        0x441000d0
#define GLOBAL_NETWORK_ENGINE_INTERRUPT_1_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t NIi                  :  1 ; /* bits 0:0 */
    ca_uint32_t L2FEi                :  1 ; /* bits 1:1 */
    ca_uint32_t L2TMi                :  1 ; /* bits 2:2 */
    ca_uint32_t L3TEi                :  1 ; /* bits 3:3 */
    ca_uint32_t TQMi                 :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t WOL_inti             :  1 ; /* bits 7:7 */
    ca_uint32_t XFI0_inti            :  1 ; /* bits 8:8 */
    ca_uint32_t XFI1_inti            :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd2               :  6 ;
    ca_uint32_t PTPi                 :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd3               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_NETWORK_ENGINE_INTERRUPT_1_t;


#define GLOBAL_NETWORK_ENGINE_INTENABLE_1        0x441000d4
#define GLOBAL_NETWORK_ENGINE_INTENABLE_1_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t NIe                  :  1 ; /* bits 0:0 */
    ca_uint32_t L2FEe                :  1 ; /* bits 1:1 */
    ca_uint32_t L2TMe                :  1 ; /* bits 2:2 */
    ca_uint32_t L3TEe                :  1 ; /* bits 3:3 */
    ca_uint32_t TQMe                 :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t WOL_inte             :  1 ; /* bits 7:7 */
    ca_uint32_t XFI0_inte            :  1 ; /* bits 8:8 */
    ca_uint32_t XFI1_inte            :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd2               :  6 ;
    ca_uint32_t PTPe                 :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd3               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_NETWORK_ENGINE_INTENABLE_1_t;


#define GLOBAL_TAROKO_INT                        0x441000d8
#define GLOBAL_TAROKO_INT_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t taroko0_intreq       : 14 ; /* bits 13:0 */
    ca_uint32_t sw_ext_int0          :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t taroko1_intreq       : 14 ; /* bits 29:16 */
    ca_uint32_t sw_ext_int1          :  1 ; /* bits 30:30 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_TAROKO_INT_t;


#define GLOBAL_TAROKO_INTENABLE                  0x441000dc
#define GLOBAL_TAROKO_INTENABLE_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t taroko0_inte         : 14 ; /* bits 13:0 */
    ca_uint32_t sw_ext_int0e         :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t taroko1_inte         : 14 ; /* bits 29:16 */
    ca_uint32_t sw_ext_int1e         :  1 ; /* bits 30:30 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_TAROKO_INTENABLE_t;


#define GLOBAL_MISC_INTERRUPT                    0x441000e0
#define GLOBAL_MISC_INTERRUPT_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t CPLL_LOCKi           :  1 ; /* bits 0:0 */
    ca_uint32_t sd_intri             :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_MISC_INTERRUPT_t;


#define GLOBAL_MISC_INTENABLE                    0x441000e4
#define GLOBAL_MISC_INTENABLE_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t CPLL_LOCKe           :  1 ; /* bits 0:0 */
    ca_uint32_t sd_intre             :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_MISC_INTENABLE_t;


#define GLOBAL_WOL_INTERRUPT                     0x441000e8
#define GLOBAL_WOL_INTERRUPT_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t PORT3_WOLi           :  1 ; /* bits 3:3 */
    ca_uint32_t PORT4_WOLi           :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd2               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_WOL_INTERRUPT_t;


#define GLOBAL_WOL_INTENABLE                     0x441000ec
#define GLOBAL_WOL_INTENABLE_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t PORT3_WOLe           :  1 ; /* bits 3:3 */
    ca_uint32_t PORT4_WOLe           :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd2               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_WOL_INTENABLE_t;


#define GLOBAL_NETWORK_ENGINE_STATUS             0x441000f0
#define GLOBAL_NETWORK_ENGINE_STATUS_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t l2fe_init_done       :  1 ; /* bits 0:0 */
    ca_uint32_t l2tm_init_done       :  1 ; /* bits 1:1 */
    ca_uint32_t tqm_init_done        :  1 ; /* bits 2:2 */
    ca_uint32_t tqm_glb_idle         :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_NETWORK_ENGINE_STATUS_t;


#define GLOBAL_JTAG_TAP_CONTROL                  0x441000f4
#define GLOBAL_JTAG_TAP_CONTROL_dft              0x00000002

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t enable_taroko_0      :  1 ; /* bits 1:1 */
    ca_uint32_t enable_taroko_1      :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd2               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_JTAG_TAP_CONTROL_t;


#define GLOBAL_SOFTWARE                          0x441000f8
#define GLOBAL_SOFTWARE_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_SOFTWARE_t;


#define GLOBAL_SOFTWARE2                         0x441000fc
#define GLOBAL_SOFTWARE2_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_SOFTWARE2_t;


#define GLOBAL_SCRATCH                           0x44100100
#define GLOBAL_SCRATCH_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t scratch              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_SCRATCH_t;


#define GLOBAL_FMRO                              0x44100104
#define GLOBAL_FMRO_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t fmro_sel             : 16 ; /* bits 15:0 */
    ca_uint32_t clk_sel              :  6 ; /* bits 21:16 */
    ca_uint32_t blk_sel              :  6 ; /* bits 27:22 */
    ca_uint32_t rsrvd1               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_FMRO_t;


#define GLOBAL_SPEED_OVERRIDE                    0x44100108
#define GLOBAL_SPEED_OVERRIDE_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t speed                :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t ov_enable            : 29 ; /* bits 31:3 */
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_SPEED_OVERRIDE_t;


#define GLOBAL_SD_DLL_CTRL                       0x4410010c
#define GLOBAL_SD_DLL_CTRL_dft                   0x00140000

typedef volatile union {
  struct {
    ca_uint32_t sd_clk_sel           :  2 ; /* bits 1:0 */
    ca_uint32_t sd_dll_reset         :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t sd_dll_shiftClk0_phaseSel :  4 ; /* bits 7:4 */
    ca_uint32_t sd_dll_shiftClk1_phaseSel :  4 ; /* bits 11:8 */
    ca_uint32_t sd_dll_shiftClk0_bypass :  1 ; /* bits 12:12 */
    ca_uint32_t sd_dll_shiftClk1_bypass :  1 ; /* bits 13:13 */
    ca_uint32_t sd_phase_reset_override :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t sd_drv_phase         :  6 ; /* bits 21:16 */
    ca_uint32_t rsrvd3               :  2 ;
    ca_uint32_t sd_sample_phase      :  7 ; /* bits 30:24 */
    ca_uint32_t rsrvd4               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_SD_DLL_CTRL_t;


#define GLOBAL_SD_DLL_STATUS                     0x44100110
#define GLOBAL_SD_DLL_STATUS_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sd_dll_state         :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t sd_dll_tapNum        :  9 ; /* bits 12:4 */
    ca_uint32_t rsrvd2               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_SD_DLL_STATUS_t;


#define GLOBAL_LED_CONTROL                       0x44100114
#define GLOBAL_LED_CONTROL_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t blink_rate_1         :  8 ; /* bits 7:0 */
    ca_uint32_t blink_rate_2         :  8 ; /* bits 15:8 */
    ca_uint32_t led_test             :  1 ; /* bits 16:16 */
    ca_uint32_t led_clk_polarity     :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 12 ;
    ca_uint32_t led_test_activity    :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_LED_CONTROL_t;


#define GLOBAL_LED_CONFIG_0                      0x44100118
#define GLOBAL_LED_CONFIG_0_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t led_event_on         :  3 ; /* bits 2:0 */
    ca_uint32_t led_event_blink      :  3 ; /* bits 5:3 */
    ca_uint32_t led_event_off        :  3 ; /* bits 8:6 */
    ca_uint32_t led_off_on           :  2 ; /* bits 10:9 */
    ca_uint32_t led_port             :  3 ; /* bits 13:11 */
    ca_uint32_t led_off_val          :  1 ; /* bits 14:14 */
    ca_uint32_t led_sw_event         :  1 ; /* bits 15:15 */
    ca_uint32_t led_blink_sel        :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_LED_CONFIG_0_t;


#define GLOBAL_LED_CONFIG_1                      0x4410011c
#define GLOBAL_LED_CONFIG_1_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t led_event_on         :  3 ; /* bits 2:0 */
    ca_uint32_t led_event_blink      :  3 ; /* bits 5:3 */
    ca_uint32_t led_event_off        :  3 ; /* bits 8:6 */
    ca_uint32_t led_off_on           :  2 ; /* bits 10:9 */
    ca_uint32_t led_port             :  3 ; /* bits 13:11 */
    ca_uint32_t led_off_val          :  1 ; /* bits 14:14 */
    ca_uint32_t led_sw_event         :  1 ; /* bits 15:15 */
    ca_uint32_t led_blink_sel        :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_LED_CONFIG_1_t;


#define GLOBAL_LED_CONFIG_2                      0x44100120
#define GLOBAL_LED_CONFIG_2_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t led_event_on         :  3 ; /* bits 2:0 */
    ca_uint32_t led_event_blink      :  3 ; /* bits 5:3 */
    ca_uint32_t led_event_off        :  3 ; /* bits 8:6 */
    ca_uint32_t led_off_on           :  2 ; /* bits 10:9 */
    ca_uint32_t led_port             :  3 ; /* bits 13:11 */
    ca_uint32_t led_off_val          :  1 ; /* bits 14:14 */
    ca_uint32_t led_sw_event         :  1 ; /* bits 15:15 */
    ca_uint32_t led_blink_sel        :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_LED_CONFIG_2_t;


#define GLOBAL_LED_CONFIG_3                      0x44100124
#define GLOBAL_LED_CONFIG_3_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t led_event_on         :  3 ; /* bits 2:0 */
    ca_uint32_t led_event_blink      :  3 ; /* bits 5:3 */
    ca_uint32_t led_event_off        :  3 ; /* bits 8:6 */
    ca_uint32_t led_off_on           :  2 ; /* bits 10:9 */
    ca_uint32_t led_port             :  3 ; /* bits 13:11 */
    ca_uint32_t led_off_val          :  1 ; /* bits 14:14 */
    ca_uint32_t led_sw_event         :  1 ; /* bits 15:15 */
    ca_uint32_t led_blink_sel        :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_LED_CONFIG_3_t;


#define GLOBAL_LED_CONFIG_4                      0x44100128
#define GLOBAL_LED_CONFIG_4_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t led_event_on         :  3 ; /* bits 2:0 */
    ca_uint32_t led_event_blink      :  3 ; /* bits 5:3 */
    ca_uint32_t led_event_off        :  3 ; /* bits 8:6 */
    ca_uint32_t led_off_on           :  2 ; /* bits 10:9 */
    ca_uint32_t led_port             :  3 ; /* bits 13:11 */
    ca_uint32_t led_off_val          :  1 ; /* bits 14:14 */
    ca_uint32_t led_sw_event         :  1 ; /* bits 15:15 */
    ca_uint32_t led_blink_sel        :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_LED_CONFIG_4_t;


#define GLOBAL_LED_CONFIG_5                      0x4410012c
#define GLOBAL_LED_CONFIG_5_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t led_event_on         :  3 ; /* bits 2:0 */
    ca_uint32_t led_event_blink      :  3 ; /* bits 5:3 */
    ca_uint32_t led_event_off        :  3 ; /* bits 8:6 */
    ca_uint32_t led_off_on           :  2 ; /* bits 10:9 */
    ca_uint32_t led_port             :  3 ; /* bits 13:11 */
    ca_uint32_t led_off_val          :  1 ; /* bits 14:14 */
    ca_uint32_t led_sw_event         :  1 ; /* bits 15:15 */
    ca_uint32_t led_blink_sel        :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_LED_CONFIG_5_t;


#define GLOBAL_LED_CONFIG_6                      0x44100130
#define GLOBAL_LED_CONFIG_6_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t led_event_on         :  3 ; /* bits 2:0 */
    ca_uint32_t led_event_blink      :  3 ; /* bits 5:3 */
    ca_uint32_t led_event_off        :  3 ; /* bits 8:6 */
    ca_uint32_t led_off_on           :  2 ; /* bits 10:9 */
    ca_uint32_t led_port             :  3 ; /* bits 13:11 */
    ca_uint32_t led_off_val          :  1 ; /* bits 14:14 */
    ca_uint32_t led_sw_event         :  1 ; /* bits 15:15 */
    ca_uint32_t led_blink_sel        :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_LED_CONFIG_6_t;


#define GLOBAL_LED_CONFIG_7                      0x44100134
#define GLOBAL_LED_CONFIG_7_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t led_event_on         :  3 ; /* bits 2:0 */
    ca_uint32_t led_event_blink      :  3 ; /* bits 5:3 */
    ca_uint32_t led_event_off        :  3 ; /* bits 8:6 */
    ca_uint32_t led_off_on           :  2 ; /* bits 10:9 */
    ca_uint32_t led_port             :  3 ; /* bits 13:11 */
    ca_uint32_t led_off_val          :  1 ; /* bits 14:14 */
    ca_uint32_t led_sw_event         :  1 ; /* bits 15:15 */
    ca_uint32_t led_blink_sel        :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_LED_CONFIG_7_t;


#define GLOBAL_LED_CONFIG_8                      0x44100138
#define GLOBAL_LED_CONFIG_8_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t led_event_on         :  3 ; /* bits 2:0 */
    ca_uint32_t led_event_blink      :  3 ; /* bits 5:3 */
    ca_uint32_t led_event_off        :  3 ; /* bits 8:6 */
    ca_uint32_t led_off_on           :  2 ; /* bits 10:9 */
    ca_uint32_t led_port             :  3 ; /* bits 13:11 */
    ca_uint32_t led_off_val          :  1 ; /* bits 14:14 */
    ca_uint32_t led_sw_event         :  1 ; /* bits 15:15 */
    ca_uint32_t led_blink_sel        :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_LED_CONFIG_8_t;


#define GLOBAL_LED_CONFIG_9                      0x4410013c
#define GLOBAL_LED_CONFIG_9_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t led_event_on         :  3 ; /* bits 2:0 */
    ca_uint32_t led_event_blink      :  3 ; /* bits 5:3 */
    ca_uint32_t led_event_off        :  3 ; /* bits 8:6 */
    ca_uint32_t led_off_on           :  2 ; /* bits 10:9 */
    ca_uint32_t led_port             :  3 ; /* bits 13:11 */
    ca_uint32_t led_off_val          :  1 ; /* bits 14:14 */
    ca_uint32_t led_sw_event         :  1 ; /* bits 15:15 */
    ca_uint32_t led_blink_sel        :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_LED_CONFIG_9_t;


#define GLOBAL_LED_CONFIG_10                     0x44100140
#define GLOBAL_LED_CONFIG_10_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t led_event_on         :  3 ; /* bits 2:0 */
    ca_uint32_t led_event_blink      :  3 ; /* bits 5:3 */
    ca_uint32_t led_event_off        :  3 ; /* bits 8:6 */
    ca_uint32_t led_off_on           :  2 ; /* bits 10:9 */
    ca_uint32_t led_port             :  3 ; /* bits 13:11 */
    ca_uint32_t led_off_val          :  1 ; /* bits 14:14 */
    ca_uint32_t led_sw_event         :  1 ; /* bits 15:15 */
    ca_uint32_t led_blink_sel        :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_LED_CONFIG_10_t;


#define GLOBAL_LED_CONFIG_11                     0x44100144
#define GLOBAL_LED_CONFIG_11_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t led_event_on         :  3 ; /* bits 2:0 */
    ca_uint32_t led_event_blink      :  3 ; /* bits 5:3 */
    ca_uint32_t led_event_off        :  3 ; /* bits 8:6 */
    ca_uint32_t led_off_on           :  2 ; /* bits 10:9 */
    ca_uint32_t led_port             :  3 ; /* bits 13:11 */
    ca_uint32_t led_off_val          :  1 ; /* bits 14:14 */
    ca_uint32_t led_sw_event         :  1 ; /* bits 15:15 */
    ca_uint32_t led_blink_sel        :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_LED_CONFIG_11_t;


#define GLOBAL_LED_CONFIG_12                     0x44100148
#define GLOBAL_LED_CONFIG_12_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t led_event_on         :  3 ; /* bits 2:0 */
    ca_uint32_t led_event_blink      :  3 ; /* bits 5:3 */
    ca_uint32_t led_event_off        :  3 ; /* bits 8:6 */
    ca_uint32_t led_off_on           :  2 ; /* bits 10:9 */
    ca_uint32_t led_port             :  3 ; /* bits 13:11 */
    ca_uint32_t led_off_val          :  1 ; /* bits 14:14 */
    ca_uint32_t led_sw_event         :  1 ; /* bits 15:15 */
    ca_uint32_t led_blink_sel        :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_LED_CONFIG_12_t;


#define GLOBAL_LED_CONFIG_13                     0x4410014c
#define GLOBAL_LED_CONFIG_13_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t led_event_on         :  3 ; /* bits 2:0 */
    ca_uint32_t led_event_blink      :  3 ; /* bits 5:3 */
    ca_uint32_t led_event_off        :  3 ; /* bits 8:6 */
    ca_uint32_t led_off_on           :  2 ; /* bits 10:9 */
    ca_uint32_t led_port             :  3 ; /* bits 13:11 */
    ca_uint32_t led_off_val          :  1 ; /* bits 14:14 */
    ca_uint32_t led_sw_event         :  1 ; /* bits 15:15 */
    ca_uint32_t led_blink_sel        :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_LED_CONFIG_13_t;


#define GLOBAL_LED_CONFIG_14                     0x44100150
#define GLOBAL_LED_CONFIG_14_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t led_event_on         :  3 ; /* bits 2:0 */
    ca_uint32_t led_event_blink      :  3 ; /* bits 5:3 */
    ca_uint32_t led_event_off        :  3 ; /* bits 8:6 */
    ca_uint32_t led_off_on           :  2 ; /* bits 10:9 */
    ca_uint32_t led_port             :  3 ; /* bits 13:11 */
    ca_uint32_t led_off_val          :  1 ; /* bits 14:14 */
    ca_uint32_t led_sw_event         :  1 ; /* bits 15:15 */
    ca_uint32_t led_blink_sel        :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_LED_CONFIG_14_t;


#define GLOBAL_LED_CONFIG_15                     0x44100154
#define GLOBAL_LED_CONFIG_15_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t led_event_on         :  3 ; /* bits 2:0 */
    ca_uint32_t led_event_blink      :  3 ; /* bits 5:3 */
    ca_uint32_t led_event_off        :  3 ; /* bits 8:6 */
    ca_uint32_t led_off_on           :  2 ; /* bits 10:9 */
    ca_uint32_t led_port             :  3 ; /* bits 13:11 */
    ca_uint32_t led_off_val          :  1 ; /* bits 14:14 */
    ca_uint32_t led_sw_event         :  1 ; /* bits 15:15 */
    ca_uint32_t led_blink_sel        :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_LED_CONFIG_15_t;


#define GLOBAL_SECURITY_OVERRIDE                 0x44100158
#define GLOBAL_SECURITY_OVERRIDE_dft             0x00f80000

typedef volatile union {
  struct {
    ca_uint32_t secure_override_ne   :  1 ; /* bits 0:0 */
    ca_uint32_t secure_override_per  :  1 ; /* bits 1:1 */
    ca_uint32_t secure_override_fbm  :  1 ; /* bits 2:2 */
    ca_uint32_t secure_override_dma  :  1 ; /* bits 3:3 */
    ca_uint32_t secure_override_ldma :  1 ; /* bits 4:4 */
    ca_uint32_t secure_override_flash :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t secure_override_capsram :  1 ; /* bits 10:10 */
    ca_uint32_t secure_override_ddr  :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t secure_override_xfi  :  1 ; /* bits 14:14 */
    ca_uint32_t secure_override_otprom :  1 ; /* bits 15:15 */
    ca_uint32_t secure_override_atu0 :  1 ; /* bits 16:16 */
    ca_uint32_t secure_override_atu1 :  1 ; /* bits 17:17 */
    ca_uint32_t otp_lock_prot_fields :  1 ; /* bits 18:18 */
    ca_uint32_t secure_override_global :  1 ; /* bits 19:19 */
    ca_uint32_t secure_override_eaxi :  1 ; /* bits 20:20 */
    ca_uint32_t secure_override_eaxiatu :  1 ; /* bits 21:21 */
    ca_uint32_t secure_override_pon  :  1 ; /* bits 22:22 */
    ca_uint32_t secure_override_clkgen :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd3               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_SECURITY_OVERRIDE_t;


#define GLOBAL_MASTER_OVERRIDE_SECURITY          0x4410015c
#define GLOBAL_MASTER_OVERRIDE_SECURITY_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t master_secure_override_ne :  1 ; /* bits 0:0 */
    ca_uint32_t master_secure_override_dma :  1 ; /* bits 1:1 */
    ca_uint32_t master_secure_override_ldma :  1 ; /* bits 2:2 */
    ca_uint32_t master_secure_override_fbm :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_MASTER_OVERRIDE_SECURITY_t;


#define GLOBAL_PE_ISO_MODE                       0x44100160
#define GLOBAL_PE_ISO_MODE_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pe_iso_mode          :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_PE_ISO_MODE_t;


#define GLOBAL_ROMOTP_SLV_ID                     0x44100164
#define GLOBAL_ROMOTP_SLV_ID_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t reg_id_entry0        :  6 ; /* bits 5:0 */
    ca_uint32_t reg_id_entry1        :  6 ; /* bits 11:6 */
    ca_uint32_t reg_id_entry2        :  6 ; /* bits 17:12 */
    ca_uint32_t reg_id_entry3        :  6 ; /* bits 23:18 */
    ca_uint32_t reg_id_en0           :  1 ; /* bits 24:24 */
    ca_uint32_t reg_id_en1           :  1 ; /* bits 25:25 */
    ca_uint32_t reg_id_en2           :  1 ; /* bits 26:26 */
    ca_uint32_t reg_id_en3           :  1 ; /* bits 27:27 */
    ca_uint32_t reg_enabled          :  1 ; /* bits 28:28 */
    ca_uint32_t rom_enabled          :  1 ; /* bits 29:29 */
    ca_uint32_t rsrvd1               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_ROMOTP_SLV_ID_t;


#define GLOBAL_ROMOTP_SLV_ID_MASK                0x44100168
#define GLOBAL_ROMOTP_SLV_ID_MASK_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t reg_id_entry_mask0   :  6 ; /* bits 5:0 */
    ca_uint32_t reg_id_entry_mask1   :  6 ; /* bits 11:6 */
    ca_uint32_t reg_id_entry_mask2   :  6 ; /* bits 17:12 */
    ca_uint32_t reg_id_entry_mask3   :  6 ; /* bits 23:18 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_ROMOTP_SLV_ID_MASK_t;


#define GLOBAL_BOOT_VEC_0                        0x4410016c
#define GLOBAL_BOOT_VEC_0_dft                    0x17ff4000

typedef volatile union {
  struct {
    ca_uint32_t global_boot_0        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_BOOT_VEC_0_t;


#define GLOBAL_BOOT_VEC_4                        0x44100170
#define GLOBAL_BOOT_VEC_4_dft                    0xd503201f

typedef volatile union {
  struct {
    ca_uint32_t global_boot_4        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_BOOT_VEC_4_t;


#define GLOBAL_BOOT_VEC_8                        0x44100174
#define GLOBAL_BOOT_VEC_8_dft                    0xd503201f

typedef volatile union {
  struct {
    ca_uint32_t global_boot_8        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_BOOT_VEC_8_t;


#define GLOBAL_BOOT_VEC_C                        0x44100178
#define GLOBAL_BOOT_VEC_C_dft                    0xd503201f

typedef volatile union {
  struct {
    ca_uint32_t global_boot_c        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_BOOT_VEC_C_t;


#define GLOBAL_TMS_REG_A                         0x4410017c
#define GLOBAL_TMS_REG_A_dft                     0x086d6b85

typedef volatile union {
  struct {
    ca_uint32_t reg_a                : 29 ; /* bits 28:0 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_TMS_REG_A_t;


#define GLOBAL_TMS_REG_B                         0x44100180
#define GLOBAL_TMS_REG_B_dft                     0x0036f2cd

typedef volatile union {
  struct {
    ca_uint32_t reg_b                : 22 ; /* bits 21:0 */
    ca_uint32_t rsrvd1               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_TMS_REG_B_t;


#define GLOBAL_TMS_REG_C                         0x44100184
#define GLOBAL_TMS_REG_C_dft                     0x0101010c

typedef volatile union {
  struct {
    ca_uint32_t rstb                 :  1 ; /* bits 0:0 */
    ca_uint32_t adccksel             :  1 ; /* bits 1:1 */
    ca_uint32_t biasdem_en           :  1 ; /* bits 2:2 */
    ca_uint32_t ppow                 :  1 ; /* bits 3:3 */
    ca_uint32_t chopen               :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t hold_dly             :  2 ; /* bits 9:8 */
    ca_uint32_t hold_en              :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd2               :  5 ;
    ca_uint32_t osr                  :  3 ; /* bits 18:16 */
    ca_uint32_t rsrvd3               :  5 ;
    ca_uint32_t chopfreqsel          :  4 ; /* bits 27:24 */
    ca_uint32_t rsrvd4               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_TMS_REG_C_t;


#define GLOBAL_TMS_TEMP_DATA                     0x44100188
#define GLOBAL_TMS_TEMP_DATA_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tm_out               : 19 ; /* bits 18:0 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_TMS_TEMP_DATA_t;


#define GLOBAL_TMS_ADC_DATA                      0x4410018c
#define GLOBAL_TMS_ADC_DATA_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t adc_out              : 22 ; /* bits 21:0 */
    ca_uint32_t rsrvd1               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_TMS_ADC_DATA_t;


#define GLOBAL_FUSE_CONTROL                      0x44100190
#define GLOBAL_FUSE_CONTROL_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t fuse_group_number    :  5 ; /* bits 4:0 */
    ca_uint32_t fuse_number          :  5 ; /* bits 9:5 */
    ca_uint32_t fuse_mr              :  1 ; /* bits 10:10 */
    ca_uint32_t fuse_do_program      :  1 ; /* bits 11:11 */
    ca_uint32_t fuse_do_read         :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd1               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_FUSE_CONTROL_t;


#define GLOBAL_FUSE_RESULT                       0x44100194
#define GLOBAL_FUSE_RESULT_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t fuse_done            :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_FUSE_RESULT_t;


#define GLOBAL_FUSE_VALUE                        0x44100198
#define GLOBAL_FUSE_VALUE_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t fuse_value           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_FUSE_VALUE_t;


#define GLOBAL_FUSE_PGM_TIMING                   0x4410019c
#define GLOBAL_FUSE_PGM_TIMING_dft               0x0aa65889

typedef volatile union {
  struct {
    ca_uint32_t fuse_COUNT_THP_CS    :  3 ; /* bits 2:0 */
    ca_uint32_t fuse_COUNT_THP_PD_PS :  3 ; /* bits 5:3 */
    ca_uint32_t fuse_COUNT_THP_PS    :  3 ; /* bits 8:6 */
    ca_uint32_t fuse_COUNT_TPGM      :  9 ; /* bits 17:9 */
    ca_uint32_t fuse_COUNT_TSUP_CS   :  3 ; /* bits 20:18 */
    ca_uint32_t fuse_COUNT_TSUP_PD_PS :  5 ; /* bits 25:21 */
    ca_uint32_t fuse_COUNT_TSUP_PS_CS :  3 ; /* bits 28:26 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_FUSE_PGM_TIMING_t;


#define GLOBAL_FUSE_READ_TIMING                  0x441001a0
#define GLOBAL_FUSE_READ_TIMING_dft              0x002a4cd1

typedef volatile union {
  struct {
    ca_uint32_t fuse_COUNT_THR_CS    :  3 ; /* bits 2:0 */
    ca_uint32_t fuse_COUNT_THR_PS_CS :  3 ; /* bits 5:3 */
    ca_uint32_t fuse_COUNT_TRD       :  4 ; /* bits 9:6 */
    ca_uint32_t fuse_COUNT_TSQ       :  4 ; /* bits 13:10 */
    ca_uint32_t fuse_COUNT_TSUR_CS   :  3 ; /* bits 16:14 */
    ca_uint32_t fuse_COUNT_TSUR_PD   :  5 ; /* bits 21:17 */
    ca_uint32_t rsrvd1               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_FUSE_READ_TIMING_t;


#define GLOBAL_SATURN_COMM                       0x441001a4
#define GLOBAL_SATURN_COMM_dft                   0x00000007

typedef volatile union {
  struct {
    ca_uint32_t reset_g3_com         :  1 ; /* bits 0:0 */
    ca_uint32_t g3_send_training     :  1 ; /* bits 1:1 */
    ca_uint32_t g3_get_trained       :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_SATURN_COMM_t;


#define GLOBAL_DSS_0_CNTL                        0x441001a8
#define GLOBAL_DSS_0_CNTL_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dss_rst_n            :  1 ; /* bits 0:0 */
    ca_uint32_t ro_sel               :  3 ; /* bits 3:1 */
    ca_uint32_t wire_sel             :  1 ; /* bits 4:4 */
    ca_uint32_t data_in              : 20 ; /* bits 24:5 */
    ca_uint32_t speed_en             :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_DSS_0_CNTL_t;


#define GLOBAL_DSS_0_STATUS                      0x441001ac
#define GLOBAL_DSS_0_STATUS_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ready                :  1 ; /* bits 0:0 */
    ca_uint32_t count_out            : 20 ; /* bits 20:1 */
    ca_uint32_t wsort_go             :  1 ; /* bits 21:21 */
    ca_uint32_t rsrvd1               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_DSS_0_STATUS_t;


#define GLOBAL_DEVICE_ASSIGN_ID1                 0x441001b0
#define GLOBAL_DEVICE_ASSIGN_ID1_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t device_id1           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_DEVICE_ASSIGN_ID1_t;


#define GLOBAL_DEVICE_ASSIGN_ID0                 0x441001b4
#define GLOBAL_DEVICE_ASSIGN_ID0_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t device_id0           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_DEVICE_ASSIGN_ID0_t;


#define GLOBAL_TAROKO_BIST_RESULT                0x441001b8
#define GLOBAL_TAROKO_BIST_RESULT_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t result               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_TAROKO_BIST_RESULT_t;


#define GLOBAL_SOFTWARE3                         0x441001bc
#define GLOBAL_SOFTWARE3_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_SOFTWARE3_t;


#define GLOBAL_SOFTWARE4                         0x441001c0
#define GLOBAL_SOFTWARE4_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_SOFTWARE4_t;


#define GLOBAL_SW_INTERRUPT_EXT_0                0x441001c4
#define GLOBAL_SW_INTERRUPT_EXT_0_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sw_int               :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_SW_INTERRUPT_EXT_0_t;


#define GLOBAL_SW_INTERRUPT_EXT_1                0x441001c8
#define GLOBAL_SW_INTERRUPT_EXT_1_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sw_int               :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} GLOBAL_SW_INTERRUPT_EXT_1_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* GLB */
typedef struct {
  GLOBAL_JTAG_ID_t                         JTAG_ID;                       /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  GLOBAL_EPON_CNTL_t                       EPON_CNTL;                     /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  GLOBAL_EPON_STATUS_t                     EPON_STATUS;                   /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  GLOBAL_GPON_CNTL_t                       GPON_CNTL;                     /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  GLOBAL_OPT_MODULE_CNTL_t                 OPT_MODULE_CNTL;               /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  GLOBAL_OPT_MODULE_LAO_CNTL_t             OPT_MODULE_LAO_CNTL;           /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  GLOBAL_OPT_INTERRUPT_t                   OPT_INTERRUPT;                 /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  GLOBAL_OPT_INTENABLE_t                   OPT_INTENABLE;                 /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  GLOBAL_OPT_MODULE_STATUS_t               OPT_MODULE_STATUS;             /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  GLOBAL_PON_CNTL_t                        PON_CNTL;                      /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  GLOBAL_BLOCK_RESET_t                     BLOCK_RESET;                   /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  GLOBAL_GPHY_STATUS_t                     GPHY_STATUS;                   /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  GLOBAL_FABRIC_RESET_t                    FABRIC_RESET;                  /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  GLOBAL_STRAP_t                           STRAP;                         /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  GLOBAL_STRAP_OVERRIDE_t                  STRAP_OVERRIDE;                /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  GLOBAL_STRAP_OVERRIDE_VALUE_t            STRAP_OVERRIDE_VALUE;          /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  GLOBAL_BIST_RESULT_t                     BIST_RESULT;                   /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  GLOBAL_BIST_DATA_t                       BIST_DATA;                     /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  GLOBAL_GLOBAL_CONFIG_t                   GLOBAL_CONFIG;                 /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  GLOBAL_PHY_CONTROL_t                     PHY_CONTROL;                   /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  GLOBAL_PIN_MUX_t                         PIN_MUX;                       /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  GLOBAL_IO_DRIVE_CONTROL_t                IO_DRIVE_CONTROL;              /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  GLOBAL_GPIO_MUX_0_t                      GPIO_MUX_0;                    /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  GLOBAL_GPIO_MUX_1_t                      GPIO_MUX_1;                    /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  GLOBAL_GPIO_MUX_2_t                      GPIO_MUX_2;                    /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  GLOBAL_GPIO_MUX_3_t                      GPIO_MUX_3;                    /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  GLOBAL_GIGE_PHY_t                        GIGE_PHY;                      /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  GLOBAL_TAROKO_STATE_t                    TAROKO_STATE;                  /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  GLOBAL_SYSTEM_INTERRUPT_0_t              SYSTEM_INTERRUPT_0;            /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  GLOBAL_SYSTEM_INTENABLE_0_t              SYSTEM_INTENABLE_0;            /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  GLOBAL_SW_INTERRUPT_0_t                  SW_INTERRUPT_0;                /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  GLOBAL_CPU_IPC_SOFT_INTERRUPT_0_t        CPU_IPC_SOFT_INTERRUPT_0;      /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  GLOBAL_CPU_IPC_SOFT_INTENABLE_0_t        CPU_IPC_SOFT_INTENABLE_0;      /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  GLOBAL_CPU_LSOSSPFBM_INTERRUPT_0_t       CPU_LSOSSPFBM_INTERRUPT_0;     /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  GLOBAL_CPU_LSOSSPFBM_INTENABLE0_t        CPU_LSOSSPFBM_INTENABLE0;      /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  GLOBAL_LDMA_INTERRUPT_0_t                LDMA_INTERRUPT_0;              /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  GLOBAL_LDMA_INTENABLE0_t                 LDMA_INTENABLE0;               /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  GLOBAL_CPU_QM_INTERRUPT_0_t              CPU_QM_INTERRUPT_0;            /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  GLOBAL_CPU_QM_INTENABLE_0_t              CPU_QM_INTENABLE_0;            /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];                   
  GLOBAL_NETWORK_ENGINE_INTERRUPT_0_t      NETWORK_ENGINE_INTERRUPT_0;    /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];                   
  GLOBAL_NETWORK_ENGINE_INTENABLE_0_t      NETWORK_ENGINE_INTENABLE_0;    /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];                   
  GLOBAL_SYSTEM_INTERRUPT_1_t              SYSTEM_INTERRUPT_1;            /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];                   
  GLOBAL_SYSTEM_INTENABLE_1_t              SYSTEM_INTENABLE_1;            /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];                   
  GLOBAL_SW_INTERRUPT_1_t                  SW_INTERRUPT_1;                /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd44[3];                   
  GLOBAL_CPU_IPC_SOFT_INTERRUPT_1_t        CPU_IPC_SOFT_INTERRUPT_1;      /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd45[3];                   
  GLOBAL_CPU_IPC_SOFT_INTENABLE_1_t        CPU_IPC_SOFT_INTENABLE_1;      /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd46[3];                   
  GLOBAL_CPU_LSOSSPFBM_INTERRUPT_1_t       CPU_LSOSSPFBM_INTERRUPT_1;     /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd47[3];                   
  GLOBAL_CPU_LSOSSPFBM_INTENABLE1_t        CPU_LSOSSPFBM_INTENABLE1;      /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd48[3];                   
  GLOBAL_LDMA_INTERRUPT_1_t                LDMA_INTERRUPT_1;              /* addr: 0x000000c0 */
  ca_uint32_t                              rsrvd49[3];                   
  GLOBAL_LDMA_INTENABLE1_t                 LDMA_INTENABLE1;               /* addr: 0x000000c4 */
  ca_uint32_t                              rsrvd50[3];                   
  GLOBAL_CPU_QM_INTERRUPT_1_t              CPU_QM_INTERRUPT_1;            /* addr: 0x000000c8 */
  ca_uint32_t                              rsrvd51[3];                   
  GLOBAL_CPU_QM_INTENABLE_1_t              CPU_QM_INTENABLE_1;            /* addr: 0x000000cc */
  ca_uint32_t                              rsrvd52[3];                   
  GLOBAL_NETWORK_ENGINE_INTERRUPT_1_t      NETWORK_ENGINE_INTERRUPT_1;    /* addr: 0x000000d0 */
  ca_uint32_t                              rsrvd53[3];                   
  GLOBAL_NETWORK_ENGINE_INTENABLE_1_t      NETWORK_ENGINE_INTENABLE_1;    /* addr: 0x000000d4 */
  ca_uint32_t                              rsrvd54[3];                   
  GLOBAL_TAROKO_INT_t                      TAROKO_INT;                    /* addr: 0x000000d8 */
  ca_uint32_t                              rsrvd55[3];                   
  GLOBAL_TAROKO_INTENABLE_t                TAROKO_INTENABLE;              /* addr: 0x000000dc */
  ca_uint32_t                              rsrvd56[3];                   
  GLOBAL_MISC_INTERRUPT_t                  MISC_INTERRUPT;                /* addr: 0x000000e0 */
  ca_uint32_t                              rsrvd57[3];                   
  GLOBAL_MISC_INTENABLE_t                  MISC_INTENABLE;                /* addr: 0x000000e4 */
  ca_uint32_t                              rsrvd58[3];                   
  GLOBAL_WOL_INTERRUPT_t                   WOL_INTERRUPT;                 /* addr: 0x000000e8 */
  ca_uint32_t                              rsrvd59[3];                   
  GLOBAL_WOL_INTENABLE_t                   WOL_INTENABLE;                 /* addr: 0x000000ec */
  ca_uint32_t                              rsrvd60[3];                   
  GLOBAL_NETWORK_ENGINE_STATUS_t           NETWORK_ENGINE_STATUS;         /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd61[3];                   
  GLOBAL_JTAG_TAP_CONTROL_t                JTAG_TAP_CONTROL;              /* addr: 0x000000f4 */
  ca_uint32_t                              rsrvd62[3];                   
  GLOBAL_SOFTWARE_t                        SOFTWARE;                      /* addr: 0x000000f8 */
  ca_uint32_t                              rsrvd63[3];                   
  GLOBAL_SOFTWARE2_t                       SOFTWARE2;                     /* addr: 0x000000fc */
  ca_uint32_t                              rsrvd64[3];                   
  GLOBAL_SCRATCH_t                         SCRATCH;                       /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd65[3];                   
  GLOBAL_FMRO_t                            FMRO;                          /* addr: 0x00000104 */
  ca_uint32_t                              rsrvd66[3];                   
  GLOBAL_SPEED_OVERRIDE_t                  SPEED_OVERRIDE;                /* addr: 0x00000108 */
  ca_uint32_t                              rsrvd67[3];                   
  GLOBAL_SD_DLL_CTRL_t                     SD_DLL_CTRL;                   /* addr: 0x0000010c */
  ca_uint32_t                              rsrvd68[3];                   
  GLOBAL_SD_DLL_STATUS_t                   SD_DLL_STATUS;                 /* addr: 0x00000110 */
  ca_uint32_t                              rsrvd69[3];                   
  GLOBAL_LED_CONTROL_t                     LED_CONTROL;                   /* addr: 0x00000114 */
  ca_uint32_t                              rsrvd70[3];                   
  GLOBAL_LED_CONFIG_0_t                    LED_CONFIG_0;                  /* addr: 0x00000118 */
  ca_uint32_t                              rsrvd71[3];                   
  GLOBAL_LED_CONFIG_1_t                    LED_CONFIG_1;                  /* addr: 0x0000011c */
  ca_uint32_t                              rsrvd72[3];                   
  GLOBAL_LED_CONFIG_2_t                    LED_CONFIG_2;                  /* addr: 0x00000120 */
  ca_uint32_t                              rsrvd73[3];                   
  GLOBAL_LED_CONFIG_3_t                    LED_CONFIG_3;                  /* addr: 0x00000124 */
  ca_uint32_t                              rsrvd74[3];                   
  GLOBAL_LED_CONFIG_4_t                    LED_CONFIG_4;                  /* addr: 0x00000128 */
  ca_uint32_t                              rsrvd75[3];                   
  GLOBAL_LED_CONFIG_5_t                    LED_CONFIG_5;                  /* addr: 0x0000012c */
  ca_uint32_t                              rsrvd76[3];                   
  GLOBAL_LED_CONFIG_6_t                    LED_CONFIG_6;                  /* addr: 0x00000130 */
  ca_uint32_t                              rsrvd77[3];                   
  GLOBAL_LED_CONFIG_7_t                    LED_CONFIG_7;                  /* addr: 0x00000134 */
  ca_uint32_t                              rsrvd78[3];                   
  GLOBAL_LED_CONFIG_8_t                    LED_CONFIG_8;                  /* addr: 0x00000138 */
  ca_uint32_t                              rsrvd79[3];                   
  GLOBAL_LED_CONFIG_9_t                    LED_CONFIG_9;                  /* addr: 0x0000013c */
  ca_uint32_t                              rsrvd80[3];                   
  GLOBAL_LED_CONFIG_10_t                   LED_CONFIG_10;                 /* addr: 0x00000140 */
  ca_uint32_t                              rsrvd81[3];                   
  GLOBAL_LED_CONFIG_11_t                   LED_CONFIG_11;                 /* addr: 0x00000144 */
  ca_uint32_t                              rsrvd82[3];                   
  GLOBAL_LED_CONFIG_12_t                   LED_CONFIG_12;                 /* addr: 0x00000148 */
  ca_uint32_t                              rsrvd83[3];                   
  GLOBAL_LED_CONFIG_13_t                   LED_CONFIG_13;                 /* addr: 0x0000014c */
  ca_uint32_t                              rsrvd84[3];                   
  GLOBAL_LED_CONFIG_14_t                   LED_CONFIG_14;                 /* addr: 0x00000150 */
  ca_uint32_t                              rsrvd85[3];                   
  GLOBAL_LED_CONFIG_15_t                   LED_CONFIG_15;                 /* addr: 0x00000154 */
  ca_uint32_t                              rsrvd86[3];                   
  GLOBAL_SECURITY_OVERRIDE_t               SECURITY_OVERRIDE;             /* addr: 0x00000158 */
  ca_uint32_t                              rsrvd87[3];                   
  GLOBAL_MASTER_OVERRIDE_SECURITY_t        MASTER_OVERRIDE_SECURITY;      /* addr: 0x0000015c */
  ca_uint32_t                              rsrvd88[3];                   
  GLOBAL_PE_ISO_MODE_t                     PE_ISO_MODE;                   /* addr: 0x00000160 */
  ca_uint32_t                              rsrvd89[3];                   
  GLOBAL_ROMOTP_SLV_ID_t                   ROMOTP_SLV_ID;                 /* addr: 0x00000164 */
  ca_uint32_t                              rsrvd90[3];                   
  GLOBAL_ROMOTP_SLV_ID_MASK_t              ROMOTP_SLV_ID_MASK;            /* addr: 0x00000168 */
  ca_uint32_t                              rsrvd91[3];                   
  GLOBAL_BOOT_VEC_0_t                      BOOT_VEC_0;                    /* addr: 0x0000016c */
  ca_uint32_t                              rsrvd92[3];                   
  GLOBAL_BOOT_VEC_4_t                      BOOT_VEC_4;                    /* addr: 0x00000170 */
  ca_uint32_t                              rsrvd93[3];                   
  GLOBAL_BOOT_VEC_8_t                      BOOT_VEC_8;                    /* addr: 0x00000174 */
  ca_uint32_t                              rsrvd94[3];                   
  GLOBAL_BOOT_VEC_C_t                      BOOT_VEC_C;                    /* addr: 0x00000178 */
  ca_uint32_t                              rsrvd95[3];                   
  GLOBAL_TMS_REG_A_t                       TMS_REG_A;                     /* addr: 0x0000017c */
  ca_uint32_t                              rsrvd96[3];                   
  GLOBAL_TMS_REG_B_t                       TMS_REG_B;                     /* addr: 0x00000180 */
  ca_uint32_t                              rsrvd97[3];                   
  GLOBAL_TMS_REG_C_t                       TMS_REG_C;                     /* addr: 0x00000184 */
  ca_uint32_t                              rsrvd98[3];                   
  GLOBAL_TMS_TEMP_DATA_t                   TMS_TEMP_DATA;                 /* addr: 0x00000188 */
  ca_uint32_t                              rsrvd99[3];                   
  GLOBAL_TMS_ADC_DATA_t                    TMS_ADC_DATA;                  /* addr: 0x0000018c */
  ca_uint32_t                              rsrvd100[3];                  
  GLOBAL_FUSE_CONTROL_t                    FUSE_CONTROL;                  /* addr: 0x00000190 */
  ca_uint32_t                              rsrvd101[3];                  
  GLOBAL_FUSE_RESULT_t                     FUSE_RESULT;                   /* addr: 0x00000194 */
  ca_uint32_t                              rsrvd102[3];                  
  GLOBAL_FUSE_VALUE_t                      FUSE_VALUE;                    /* addr: 0x00000198 */
  ca_uint32_t                              rsrvd103[3];                  
  GLOBAL_FUSE_PGM_TIMING_t                 FUSE_PGM_TIMING;               /* addr: 0x0000019c */
  ca_uint32_t                              rsrvd104[3];                  
  GLOBAL_FUSE_READ_TIMING_t                FUSE_READ_TIMING;              /* addr: 0x000001a0 */
  ca_uint32_t                              rsrvd105[3];                  
  GLOBAL_SATURN_COMM_t                     SATURN_COMM;                   /* addr: 0x000001a4 */
  ca_uint32_t                              rsrvd106[3];                  
  GLOBAL_DSS_0_CNTL_t                      DSS_0_CNTL;                    /* addr: 0x000001a8 */
  ca_uint32_t                              rsrvd107[3];                  
  GLOBAL_DSS_0_STATUS_t                    DSS_0_STATUS;                  /* addr: 0x000001ac */
  ca_uint32_t                              rsrvd108[3];                  
  GLOBAL_DEVICE_ASSIGN_ID1_t               DEVICE_ASSIGN_ID1;             /* addr: 0x000001b0 */
  ca_uint32_t                              rsrvd109[3];                  
  GLOBAL_DEVICE_ASSIGN_ID0_t               DEVICE_ASSIGN_ID0;             /* addr: 0x000001b4 */
  ca_uint32_t                              rsrvd110[3];                  
  GLOBAL_TAROKO_BIST_RESULT_t              TAROKO_BIST_RESULT;            /* addr: 0x000001b8 */
  ca_uint32_t                              rsrvd111[3];                  
  GLOBAL_SOFTWARE3_t                       SOFTWARE3;                     /* addr: 0x000001bc */
  ca_uint32_t                              rsrvd112[3];                  
  GLOBAL_SOFTWARE4_t                       SOFTWARE4;                     /* addr: 0x000001c0 */
  ca_uint32_t                              rsrvd113[3];                  
  GLOBAL_SW_INTERRUPT_EXT_0_t              SW_INTERRUPT_EXT_0;            /* addr: 0x000001c4 */
  ca_uint32_t                              rsrvd114[3];                  
  GLOBAL_SW_INTERRUPT_EXT_1_t              SW_INTERRUPT_EXT_1;            /* addr: 0x000001c8 */
} APB2_GLB_t;


/*
 * PE_TAROKO_ATU
 */
  
/*
 * TAROKO0_ATU
 */
        
#define PE_TAROKO_ATU_TAROKO0_ATU_CTL            0x44101100
#define PE_TAROKO_ATU_TAROKO0_ATU_CTL_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t enable               :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 16 ;
    ca_uint32_t idx                  :  6 ; /* bits 29:24 */
    ca_uint32_t r                    :  1 ; /* bits 30:30 */
    ca_uint32_t w                    :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} PE_TAROKO_ATU_TAROKO0_ATU_CTL_t;


#define PE_TAROKO_ATU_TAROKO0_ATU_DATA0          0x44101104
#define PE_TAROKO_ATU_TAROKO0_ATU_DATA0_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr_input_comp      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_TAROKO_ATU_TAROKO0_ATU_DATA0_t;


#define PE_TAROKO_ATU_TAROKO0_ATU_DATA1          0x44101108
#define PE_TAROKO_ATU_TAROKO0_ATU_DATA1_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr_input_mask      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_TAROKO_ATU_TAROKO0_ATU_DATA1_t;


#define PE_TAROKO_ATU_TAROKO0_ATU_DATA2          0x4410110c
#define PE_TAROKO_ATU_TAROKO0_ATU_DATA2_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr_output_value    : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_TAROKO_ATU_TAROKO0_ATU_DATA2_t;


#define PE_TAROKO_ATU_TAROKO0_ATU_DATA3          0x44101110
#define PE_TAROKO_ATU_TAROKO0_ATU_DATA3_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t arprot               :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t awprot               :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t arqos                :  4 ; /* bits 11:8 */
    ca_uint32_t awqos                :  4 ; /* bits 15:12 */
    ca_uint32_t arcache              :  4 ; /* bits 19:16 */
    ca_uint32_t awcache              :  4 ; /* bits 23:20 */
    ca_uint32_t user_en              :  1 ; /* bits 24:24 */
    ca_uint32_t prot_en              :  1 ; /* bits 25:25 */
    ca_uint32_t cache_en             :  1 ; /* bits 26:26 */
    ca_uint32_t qos_en               :  1 ; /* bits 27:27 */
    ca_uint32_t rsrvd3               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_TAROKO_ATU_TAROKO0_ATU_DATA3_t;


#define PE_TAROKO_ATU_TAROKO0_ATU_DATA4          0x44101114
#define PE_TAROKO_ATU_TAROKO0_ATU_DATA4_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t aruser               : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_TAROKO_ATU_TAROKO0_ATU_DATA4_t;


#define PE_TAROKO_ATU_TAROKO0_ATU_DATA5          0x44101118
#define PE_TAROKO_ATU_TAROKO0_ATU_DATA5_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t awuser               : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_TAROKO_ATU_TAROKO0_ATU_DATA5_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* TAROKO0_ATU */
typedef struct {
  PE_TAROKO_ATU_TAROKO0_ATU_CTL_t          CTL;                           /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  PE_TAROKO_ATU_TAROKO0_ATU_DATA0_t        DATA0;                         /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  PE_TAROKO_ATU_TAROKO0_ATU_DATA1_t        DATA1;                         /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  PE_TAROKO_ATU_TAROKO0_ATU_DATA2_t        DATA2;                         /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  PE_TAROKO_ATU_TAROKO0_ATU_DATA3_t        DATA3;                         /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  PE_TAROKO_ATU_TAROKO0_ATU_DATA4_t        DATA4;                         /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  PE_TAROKO_ATU_TAROKO0_ATU_DATA5_t        DATA5;                         /* addr: 0x00000018 */
} APB2_PE_TAROKO_ATU_TAROKO0_ATU_t;


/*
 * TAROKO1_ATU
 */
        
#define PE_TAROKO_ATU_TAROKO1_ATU_CTL            0x44101200
#define PE_TAROKO_ATU_TAROKO1_ATU_CTL_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t enable               :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 16 ;
    ca_uint32_t idx                  :  6 ; /* bits 29:24 */
    ca_uint32_t r                    :  1 ; /* bits 30:30 */
    ca_uint32_t w                    :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} PE_TAROKO_ATU_TAROKO1_ATU_CTL_t;


#define PE_TAROKO_ATU_TAROKO1_ATU_DATA0          0x44101204
#define PE_TAROKO_ATU_TAROKO1_ATU_DATA0_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr_input_comp      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_TAROKO_ATU_TAROKO1_ATU_DATA0_t;


#define PE_TAROKO_ATU_TAROKO1_ATU_DATA1          0x44101208
#define PE_TAROKO_ATU_TAROKO1_ATU_DATA1_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr_input_mask      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_TAROKO_ATU_TAROKO1_ATU_DATA1_t;


#define PE_TAROKO_ATU_TAROKO1_ATU_DATA2          0x4410120c
#define PE_TAROKO_ATU_TAROKO1_ATU_DATA2_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr_output_value    : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_TAROKO_ATU_TAROKO1_ATU_DATA2_t;


#define PE_TAROKO_ATU_TAROKO1_ATU_DATA3          0x44101210
#define PE_TAROKO_ATU_TAROKO1_ATU_DATA3_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t arprot               :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t awprot               :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t arqos                :  4 ; /* bits 11:8 */
    ca_uint32_t awqos                :  4 ; /* bits 15:12 */
    ca_uint32_t arcache              :  4 ; /* bits 19:16 */
    ca_uint32_t awcache              :  4 ; /* bits 23:20 */
    ca_uint32_t user_en              :  1 ; /* bits 24:24 */
    ca_uint32_t prot_en              :  1 ; /* bits 25:25 */
    ca_uint32_t cache_en             :  1 ; /* bits 26:26 */
    ca_uint32_t qos_en               :  1 ; /* bits 27:27 */
    ca_uint32_t rsrvd3               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_TAROKO_ATU_TAROKO1_ATU_DATA3_t;


#define PE_TAROKO_ATU_TAROKO1_ATU_DATA4          0x44101214
#define PE_TAROKO_ATU_TAROKO1_ATU_DATA4_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t aruser               : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_TAROKO_ATU_TAROKO1_ATU_DATA4_t;


#define PE_TAROKO_ATU_TAROKO1_ATU_DATA5          0x44101218
#define PE_TAROKO_ATU_TAROKO1_ATU_DATA5_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t awuser               : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} PE_TAROKO_ATU_TAROKO1_ATU_DATA5_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* TAROKO1_ATU */
typedef struct {
  PE_TAROKO_ATU_TAROKO1_ATU_CTL_t          CTL;                           /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  PE_TAROKO_ATU_TAROKO1_ATU_DATA0_t        DATA0;                         /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  PE_TAROKO_ATU_TAROKO1_ATU_DATA1_t        DATA1;                         /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  PE_TAROKO_ATU_TAROKO1_ATU_DATA2_t        DATA2;                         /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  PE_TAROKO_ATU_TAROKO1_ATU_DATA3_t        DATA3;                         /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  PE_TAROKO_ATU_TAROKO1_ATU_DATA4_t        DATA4;                         /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  PE_TAROKO_ATU_TAROKO1_ATU_DATA5_t        DATA5;                         /* addr: 0x00000018 */
} APB2_PE_TAROKO_ATU_TAROKO1_ATU_t;

    
  
        
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* PE_TAROKO_ATU */

typedef struct {
  ca_uint32_t                              rsrvd1[256];                  
  APB2_PE_TAROKO_ATU_TAROKO0_ATU_t         TAROKO0_ATU;                   /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd2[243];                  
  APB2_PE_TAROKO_ATU_TAROKO1_ATU_t         TAROKO1_ATU;                   /* addr: 0x00000200 */
} APB2_PE_TAROKO_ATU_t;


/*
 * CAPSRAM
 */
        
#define CAPSRAM_TZCONTROL                        0x44102000
#define CAPSRAM_TZCONTROL_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t SEGSECURE            : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} CAPSRAM_TZCONTROL_t;


#define CAPSRAM_INIT                             0x44102004
#define CAPSRAM_INIT_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t INIT                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} CAPSRAM_INIT_t;


#define CAPSRAM_INITRANGE                        0x44102008
#define CAPSRAM_INITRANGE_dft                    0x1fff0000

typedef volatile union {
  struct {
    ca_uint32_t MIN                  : 13 ; /* bits 12:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t MAX                  : 13 ; /* bits 28:16 */
    ca_uint32_t rsrvd2               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} CAPSRAM_INITRANGE_t;


#define CAPSRAM_SRAMBAD0                         0x4410200c
#define CAPSRAM_SRAMBAD0_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ADDR                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} CAPSRAM_SRAMBAD0_t;


#define CAPSRAM_SRAMBAD1                         0x44102010
#define CAPSRAM_SRAMBAD1_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t BURST                :  2 ; /* bits 1:0 */
    ca_uint32_t SIZE                 :  3 ; /* bits 4:2 */
    ca_uint32_t PROT                 :  3 ; /* bits 7:5 */
    ca_uint32_t LEN                  :  4 ; /* bits 11:8 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t ID                   : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} CAPSRAM_SRAMBAD1_t;


#define CAPSRAM_SRAMBAD2                         0x44102014
#define CAPSRAM_SRAMBAD2_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t VALID                :  1 ; /* bits 0:0 */
    ca_uint32_t INST                 :  3 ; /* bits 3:1 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t VEC                  :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd2               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} CAPSRAM_SRAMBAD2_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* CAPSRAM */
typedef struct {
  CAPSRAM_TZCONTROL_t                      TZCONTROL;                     /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  CAPSRAM_INIT_t                           INIT;                          /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  CAPSRAM_INITRANGE_t                      INITRANGE;                     /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  CAPSRAM_SRAMBAD0_t                       SRAMBAD0;                      /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  CAPSRAM_SRAMBAD1_t                       SRAMBAD1;                      /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  CAPSRAM_SRAMBAD2_t                       SRAMBAD2;                      /* addr: 0x00000014 */
} APB2_CAPSRAM_t;


/*
 * LDMA
 */
      
  

/*
 * LDMA_RCPU
 */
      
  

/*
 * EAXI_WRAPPER
 */
  
/*
 * EAXI_ATU
 */
        
#define EAXI_WRAPPER_EAXI_ATU_CTL                0x44106000
#define EAXI_WRAPPER_EAXI_ATU_CTL_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t enable               :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 16 ;
    ca_uint32_t idx                  :  6 ; /* bits 29:24 */
    ca_uint32_t r                    :  1 ; /* bits 30:30 */
    ca_uint32_t w                    :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EAXI_WRAPPER_EAXI_ATU_CTL_t;


#define EAXI_WRAPPER_EAXI_ATU_DATA0              0x44106004
#define EAXI_WRAPPER_EAXI_ATU_DATA0_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr_input_comp      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EAXI_WRAPPER_EAXI_ATU_DATA0_t;


#define EAXI_WRAPPER_EAXI_ATU_DATA1              0x44106008
#define EAXI_WRAPPER_EAXI_ATU_DATA1_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr_input_mask      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EAXI_WRAPPER_EAXI_ATU_DATA1_t;


#define EAXI_WRAPPER_EAXI_ATU_DATA2              0x4410600c
#define EAXI_WRAPPER_EAXI_ATU_DATA2_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr_output_value    : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EAXI_WRAPPER_EAXI_ATU_DATA2_t;


#define EAXI_WRAPPER_EAXI_ATU_DATA3              0x44106010
#define EAXI_WRAPPER_EAXI_ATU_DATA3_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t arprot               :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t awprot               :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t arqos                :  4 ; /* bits 11:8 */
    ca_uint32_t awqos                :  4 ; /* bits 15:12 */
    ca_uint32_t arcache              :  4 ; /* bits 19:16 */
    ca_uint32_t awcache              :  4 ; /* bits 23:20 */
    ca_uint32_t user_en              :  1 ; /* bits 24:24 */
    ca_uint32_t prot_en              :  1 ; /* bits 25:25 */
    ca_uint32_t cache_en             :  1 ; /* bits 26:26 */
    ca_uint32_t qos_en               :  1 ; /* bits 27:27 */
    ca_uint32_t rsrvd3               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} EAXI_WRAPPER_EAXI_ATU_DATA3_t;


#define EAXI_WRAPPER_EAXI_ATU_DATA4              0x44106014
#define EAXI_WRAPPER_EAXI_ATU_DATA4_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t aruser               : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} EAXI_WRAPPER_EAXI_ATU_DATA4_t;


#define EAXI_WRAPPER_EAXI_ATU_DATA5              0x44106018
#define EAXI_WRAPPER_EAXI_ATU_DATA5_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t awuser               : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} EAXI_WRAPPER_EAXI_ATU_DATA5_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* EAXI_ATU */
typedef struct {
  EAXI_WRAPPER_EAXI_ATU_CTL_t              CTL;                           /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  EAXI_WRAPPER_EAXI_ATU_DATA0_t            DATA0;                         /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  EAXI_WRAPPER_EAXI_ATU_DATA1_t            DATA1;                         /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  EAXI_WRAPPER_EAXI_ATU_DATA2_t            DATA2;                         /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  EAXI_WRAPPER_EAXI_ATU_DATA3_t            DATA3;                         /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  EAXI_WRAPPER_EAXI_ATU_DATA4_t            DATA4;                         /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  EAXI_WRAPPER_EAXI_ATU_DATA5_t            DATA5;                         /* addr: 0x00000018 */
} APB2_EAXI_WRAPPER_EAXI_ATU_t;


/*
 * EAXI
 */
  
/*
 * EAXI
 */
        
#define EAXI_WRAPPER_EAXI_EAXI_CTL0              0x44106100
#define EAXI_WRAPPER_EAXI_EAXI_CTL0_dft          0x00000100

typedef volatile union {
  struct {
    ca_uint32_t enable               :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t slavecam             :  1 ; /* bits 8:8 */
    ca_uint32_t slavesingle          :  1 ; /* bits 9:9 */
    ca_uint32_t rxhysdis             :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd2               :  5 ;
    ca_uint32_t rxthresh             :  6 ; /* bits 21:16 */
    ca_uint32_t rsrvd3               :  2 ;
    ca_uint32_t rx2tx                :  1 ; /* bits 24:24 */
    ca_uint32_t rsrvd4               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} EAXI_WRAPPER_EAXI_EAXI_CTL0_t;


#define EAXI_WRAPPER_EAXI_EAXI_CTL1              0x44106104
#define EAXI_WRAPPER_EAXI_EAXI_CTL1_dft          0x03020100

typedef volatile union {
  struct {
    ca_uint32_t id0mux               :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t id1mux               :  4 ; /* bits 11:8 */
    ca_uint32_t rsrvd2               :  4 ;
    ca_uint32_t id2mux               :  4 ; /* bits 19:16 */
    ca_uint32_t rsrvd3               :  4 ;
    ca_uint32_t id3mux               :  4 ; /* bits 27:24 */
    ca_uint32_t rsrvd4               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} EAXI_WRAPPER_EAXI_EAXI_CTL1_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* EAXI */
typedef struct {
  EAXI_WRAPPER_EAXI_EAXI_CTL0_t            CTL0;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  EAXI_WRAPPER_EAXI_EAXI_CTL1_t            CTL1;                          /* addr: 0x00000004 */
} APB2_EAXI_WRAPPER_EAXI_EAXI_t;


/*
 * EAXI_TX
 */
        
#define EAXI_WRAPPER_EAXI_EAXI_TX_TXCTL          0x44106110
#define EAXI_WRAPPER_EAXI_EAXI_TX_TXCTL_dft      0x01001100

typedef volatile union {
  struct {
    ca_uint32_t txqos                :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t mingap               :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t chmingap             :  3 ; /* bits 14:12 */
    ca_uint32_t rsrvd3               :  9 ;
    ca_uint32_t invert               :  1 ; /* bits 24:24 */
    ca_uint32_t tx2rx                :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd4               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} EAXI_WRAPPER_EAXI_EAXI_TX_TXCTL_t;


#define EAXI_WRAPPER_EAXI_EAXI_TX_REMAP0         0x44106114
#define EAXI_WRAPPER_EAXI_EAXI_TX_REMAP0_STRIDE  4
#define EAXI_WRAPPER_EAXI_EAXI_TX_REMAP0_COUNT   16
#define EAXI_WRAPPER_EAXI_EAXI_TX_REMAP0_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t range                : 16 ; /* bits 15:0 */
    ca_uint32_t value                : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EAXI_WRAPPER_EAXI_EAXI_TX_REMAP0_t;

                                                                
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* EAXI_TX */
typedef struct {
  EAXI_WRAPPER_EAXI_EAXI_TX_TXCTL_t        TXCTL;                         /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  EAXI_WRAPPER_EAXI_EAXI_TX_REMAP0_t       REMAP0;                        /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[28];                   
} APB2_EAXI_WRAPPER_EAXI_EAXI_TX_t;

    
  
        
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* EAXI */

typedef struct {
  APB2_EAXI_WRAPPER_EAXI_EAXI_t            EAXI;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[13];                   
  APB2_EAXI_WRAPPER_EAXI_EAXI_TX_t         EAXI_TX;                       /* addr: 0x00000010 */
} APB2_EAXI_WRAPPER_EAXI_t;

    
  
        
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* EAXI_WRAPPER */

typedef struct {
  APB2_EAXI_WRAPPER_EAXI_ATU_t             EAXI_ATU;                      /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[243];                  
  APB2_EAXI_WRAPPER_EAXI_t                 EAXI;                          /* addr: 0x00000100 */
} APB2_EAXI_WRAPPER_t;


/*
 * DDR_CTRL
 */
      
  

/*
 * CLKGEN
 */
      
  

/*
 * TITANGLB
 */
        
#define TITANGLB_REV_ID                          0x4410a000
#define TITANGLB_REV_ID_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t minor                : 24 ; /* bits 23:0 */
    ca_uint32_t major                :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} TITANGLB_REV_ID_t;


#define TITANGLB_STS                             0x4410a004
#define TITANGLB_STS_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sl_sleepsys_r        :  1 ; /* bits 0:0 */
    ca_uint32_t wdt_hard_reset       :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} TITANGLB_STS_t;


#define TITANGLB_STS2                            0x4410a008
#define TITANGLB_STS2_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t opt_xgpn_tx_fault    :  1 ; /* bits 2:2 */
    ca_uint32_t opt_xgpn_rx_los      :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd2               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} TITANGLB_STS2_t;


#define TITANGLB_CTRL0                           0x4410a00c
#define TITANGLB_CTRL0_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t RESET_ALL_XCVR       :  1 ; /* bits 0:0 */
    ca_uint32_t RX_ELASTIC_RESET     :  1 ; /* bits 1:1 */
    ca_uint32_t TX_ELASTIC_RESET     :  1 ; /* bits 2:2 */
    ca_uint32_t DP_GMAC_RESET        :  1 ; /* bits 3:3 */
    ca_uint32_t reserved_4           :  1 ; /* bits 4:4 */
    ca_uint32_t RESET_PON_XCVR       :  1 ; /* bits 5:5 */
    ca_uint32_t RESET_PON_RX_PLL_DP  :  1 ; /* bits 6:6 */
    ca_uint32_t reserved_7           :  1 ; /* bits 7:7 */
    ca_uint32_t RESET_PON_TX_PLL_DP  :  1 ; /* bits 8:8 */
    ca_uint32_t RESET_PON_TX_DP      :  1 ; /* bits 9:9 */
    ca_uint32_t reserved_10          :  1 ; /* bits 10:10 */
    ca_uint32_t RESET_XGE_BLOCK      :  1 ; /* bits 11:11 */
    ca_uint32_t reserved_12          :  1 ; /* bits 12:12 */
    ca_uint32_t RESET_PON_MAC_PLL    :  1 ; /* bits 13:13 */
    ca_uint32_t RESET_PLL_125MHZ     :  1 ; /* bits 14:14 */
    ca_uint32_t RESET_SI5315         :  1 ; /* bits 15:15 */
    ca_uint32_t reserved_31_16       : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} TITANGLB_CTRL0_t;


#define TITANGLB_CTRL1                           0x4410a010
#define TITANGLB_CTRL1_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t SEL_PON_TX_REFCLK    :  1 ; /* bits 0:0 */
    ca_uint32_t EN_PON_LASER         :  1 ; /* bits 1:1 */
    ca_uint32_t EN_XGE_LASER         :  1 ; /* bits 2:2 */
    ca_uint32_t INVERT_XGE_LOS       :  1 ; /* bits 3:3 */
    ca_uint32_t reserved_31_4        : 28 ; /* bits 31:4 */
  } bf ;
  ca_uint32_t     wrd ;
} TITANGLB_CTRL1_t;


#define TITANGLB_STATUS0                         0x4410a014
#define TITANGLB_STATUS0_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ALL_INIT_DONE        :  1 ; /* bits 0:0 */
    ca_uint32_t XCVR_PON_RXPMA_RESETDONE :  1 ; /* bits 1:1 */
    ca_uint32_t XCVR_PON_TXPMA_RESETDONE :  1 ; /* bits 2:2 */
    ca_uint32_t XCVR_PON_RESET_RX_DONE :  1 ; /* bits 3:3 */
    ca_uint32_t XCVR_PON_RESET_TX_DONE :  1 ; /* bits 4:4 */
    ca_uint32_t XCVR_PON_RXCLK_ACTIVE :  1 ; /* bits 5:5 */
    ca_uint32_t XCVR_PON_TXCLK_ACTIVE :  1 ; /* bits 6:6 */
    ca_uint32_t XCVR_PON_INIT_DONE   :  1 ; /* bits 7:7 */
    ca_uint32_t XGE_MAC_RESETDONE    :  1 ; /* bits 8:8 */
    ca_uint32_t XGE_MAC_QPLLLOCK     :  1 ; /* bits 9:9 */
    ca_uint32_t XFP_RX_LOS           :  1 ; /* bits 10:10 */
    ca_uint32_t SFP_RX_LOS           :  1 ; /* bits 11:11 */
    ca_uint32_t reserved_12          :  1 ; /* bits 12:12 */
    ca_uint32_t PON_MAC_PLL_LOCKED   :  1 ; /* bits 13:13 */
    ca_uint32_t MPCLK_125MHZ_LOCKED  :  1 ; /* bits 14:14 */
    ca_uint32_t SI51315_LOCKED       :  1 ; /* bits 15:15 */
    ca_uint32_t reserved_31_16       : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} TITANGLB_STATUS0_t;


#define TITANGLB_STATUS1                         0x4410a018
#define TITANGLB_STATUS1_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t reserved_31_0        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} TITANGLB_STATUS1_t;


#define TITANGLB_CTL                             0x4410a01c
#define TITANGLB_CTL_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t i2c                  :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} TITANGLB_CTL_t;


#define TITANGLB_FPGA_IDP_CNTL                   0x4410a020
#define TITANGLB_FPGA_IDP_CNTL_dft               0x00000005

typedef volatile union {
  struct {
    ca_uint32_t en_remote_cpu_path   :  1 ; /* bits 0:0 */
    ca_uint32_t en_local_cpu_path    :  1 ; /* bits 1:1 */
    ca_uint32_t sel_pkt_gen          :  1 ; /* bits 2:2 */
    ca_uint32_t idp_rst_n            :  1 ; /* bits 3:3 */
    ca_uint32_t remote_cpu_lpbk      :  1 ; /* bits 4:4 */
    ca_uint32_t xge_lpbk             :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t cpu2lan_en           :  1 ; /* bits 8:8 */
    ca_uint32_t lan2cpu_en           :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd2               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} TITANGLB_FPGA_IDP_CNTL_t;


#define TITANGLB_FPGA_RGMII_CNTL                 0x4410a024
#define TITANGLB_FPGA_RGMII_CNTL_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rgmii_rst_n          :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} TITANGLB_FPGA_RGMII_CNTL_t;


#define TITANGLB_XFI_CNTL                        0x4410a028
#define TITANGLB_XFI_CNTL_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ni_rst_n             :  1 ; /* bits 0:0 */
    ca_uint32_t fpga_xfi_deep_loopback :  1 ; /* bits 1:1 */
    ca_uint32_t link_fault_halt_tx_en :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t xfi_serdes_rst_n     :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd2               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} TITANGLB_XFI_CNTL_t;


#define TITANGLB_PORT_STATUS                     0x4410a02c
#define TITANGLB_PORT_STATUS_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t link_fault_sts       :  1 ; /* bits 0:0 */
    ca_uint32_t xgmac_xgrs_txv       :  1 ; /* bits 1:1 */
    ca_uint32_t xge_txeth_txff_rdy   :  1 ; /* bits 2:2 */
    ca_uint32_t xgige_eth_mode       :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t gpon_tx_elst_ff_pointer_adjusted :  1 ; /* bits 8:8 */
    ca_uint32_t gpon_rx_elst_ff_pointer_adjusted :  1 ; /* bits 9:9 */
    ca_uint32_t xgepn_rx_elst_ff_pointer_adjusted :  1 ; /* bits 10:10 */
    ca_uint32_t epn_rx_elst_ff_pointer_adjusted :  1 ; /* bits 11:11 */
    ca_uint32_t syncState            :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd2               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} TITANGLB_PORT_STATUS_t;


#define TITANGLB_FPGA_EAXI_CNTL                  0x4410a030
#define TITANGLB_FPGA_EAXI_CNTL_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t eaxi_reset           :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} TITANGLB_FPGA_EAXI_CNTL_t;


#define TITANGLB_DEBUG_IN                        0x4410a034
#define TITANGLB_DEBUG_IN_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t debug_sel            :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} TITANGLB_DEBUG_IN_t;


#define TITANGLB_DEBUG_OUT1                      0x4410a038
#define TITANGLB_DEBUG_OUT1_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t debug_bus1           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} TITANGLB_DEBUG_OUT1_t;


#define TITANGLB_DEBUG_OUT0                      0x4410a03c
#define TITANGLB_DEBUG_OUT0_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t debug_bus0           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} TITANGLB_DEBUG_OUT0_t;


#define TITANGLB_FORCE_INT                       0x4410a040
#define TITANGLB_FORCE_INT_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t interrupt_code       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} TITANGLB_FORCE_INT_t;


#define TITANGLB_LASER_CTRL                      0x4410a044
#define TITANGLB_LASER_CTRL_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dly_cyc_num          :  4 ; /* bits 3:0 */
    ca_uint32_t dly_bit_num          :  6 ; /* bits 9:4 */
    ca_uint32_t rsrvd1               : 21 ;
    ca_uint32_t shift_en             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} TITANGLB_LASER_CTRL_t;


#define TITANGLB_OTHER_CTRL                      0x4410a048
#define TITANGLB_OTHER_CTRL_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_elst_ff_rsync     :  1 ; /* bits 0:0 */
    ca_uint32_t tx_elst_ff_rsync     :  1 ; /* bits 1:1 */
    ca_uint32_t tx_prbs_mode         :  2 ; /* bits 3:2 */
    ca_uint32_t tx_insertOneBitErrorOnce :  1 ; /* bits 4:4 */
    ca_uint32_t tx_insertOneBitError :  1 ; /* bits 5:5 */
    ca_uint32_t tx_invertPrbs        :  1 ; /* bits 6:6 */
    ca_uint32_t tx_insertErrorOnce   :  1 ; /* bits 7:7 */
    ca_uint32_t tx_insertError       :  1 ; /* bits 8:8 */
    ca_uint32_t rx_prbs_mode         :  2 ; /* bits 10:9 */
    ca_uint32_t rx_invertPrbs        :  1 ; /* bits 11:11 */
    ca_uint32_t rx_clrCnt            :  1 ; /* bits 12:12 */
    ca_uint32_t rx_prbsEnabled       :  1 ; /* bits 13:13 */
    ca_uint32_t rx_loadPrbsState     :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd1               : 15 ;
    ca_uint32_t prbs_tx_en           :  1 ; /* bits 30:30 */
    ca_uint32_t prbs_rx_en           :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} TITANGLB_OTHER_CTRL_t;


#define TITANGLB_FPGA_SYSTEM_INTERRUPT           0x4410a04c
#define TITANGLB_FPGA_SYSTEM_INTERRUPT_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 27 ;
    ca_uint32_t FORCE_INTi           :  1 ; /* bits 27:27 */
    ca_uint32_t IDP_DOWN_INTi        :  1 ; /* bits 28:28 */
    ca_uint32_t IDP_UP_INTi          :  1 ; /* bits 29:29 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} TITANGLB_FPGA_SYSTEM_INTERRUPT_t;


#define TITANGLB_FPGA_SYSTEM_INTENABLE           0x4410a050
#define TITANGLB_FPGA_SYSTEM_INTENABLE_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 27 ;
    ca_uint32_t FORCE_INTe           :  1 ; /* bits 27:27 */
    ca_uint32_t IDP_DOWN_INTe        :  1 ; /* bits 28:28 */
    ca_uint32_t IDP_UP_INTe          :  1 ; /* bits 29:29 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} TITANGLB_FPGA_SYSTEM_INTENABLE_t;


#define TITANGLB_PRBS_ERR_CNT                    0x4410a054
#define TITANGLB_PRBS_ERR_CNT_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t prbsErrCnt           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} TITANGLB_PRBS_ERR_CNT_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* TITANGLB */
typedef struct {
  TITANGLB_REV_ID_t                        REV_ID;                        /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  TITANGLB_STS_t                           STS;                           /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  TITANGLB_STS2_t                          STS2;                          /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  TITANGLB_CTRL0_t                         CTRL0;                         /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  TITANGLB_CTRL1_t                         CTRL1;                         /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  TITANGLB_STATUS0_t                       STATUS0;                       /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  TITANGLB_STATUS1_t                       STATUS1;                       /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  TITANGLB_CTL_t                           CTL;                           /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  TITANGLB_FPGA_IDP_CNTL_t                 FPGA_IDP_CNTL;                 /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  TITANGLB_FPGA_RGMII_CNTL_t               FPGA_RGMII_CNTL;               /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  TITANGLB_XFI_CNTL_t                      XFI_CNTL;                      /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  TITANGLB_PORT_STATUS_t                   PORT_STATUS;                   /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  TITANGLB_FPGA_EAXI_CNTL_t                FPGA_EAXI_CNTL;                /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  TITANGLB_DEBUG_IN_t                      DEBUG_IN;                      /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  TITANGLB_DEBUG_OUT1_t                    DEBUG_OUT1;                    /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  TITANGLB_DEBUG_OUT0_t                    DEBUG_OUT0;                    /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  TITANGLB_FORCE_INT_t                     FORCE_INT;                     /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  TITANGLB_LASER_CTRL_t                    LASER_CTRL;                    /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  TITANGLB_OTHER_CTRL_t                    OTHER_CTRL;                    /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  TITANGLB_FPGA_SYSTEM_INTERRUPT_t         FPGA_SYSTEM_INTERRUPT;         /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  TITANGLB_FPGA_SYSTEM_INTENABLE_t         FPGA_SYSTEM_INTENABLE;         /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  TITANGLB_PRBS_ERR_CNT_t                  PRBS_ERR_CNT;                  /* addr: 0x00000054 */
} APB2_TITANGLB_t;

    
  
        
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* APB2 */

typedef struct {
  APB2_GLB_t                               GLB;                           /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3867];                 
  APB2_PE_TAROKO_ATU_t                     PE_TAROKO_ATU;                 /* addr: 0x00001000 */
  ca_uint32_t                              rsrvd2[3571];                 
  APB2_CAPSRAM_t                           CAPSRAM;                       /* addr: 0x00002000 */
  ca_uint32_t                              rsrvd3[16373];                
  APB2_EAXI_WRAPPER_t                      EAXI_WRAPPER;                  /* addr: 0x00006000 */
  ca_uint32_t                              rsrvd4[16079];                
  APB2_TITANGLB_t                          TITANGLB;                      /* addr: 0x0000a000 */
} APB2_t;


/*
 * APB4
 */
  
/*
 * TAROKO_ATU
 */
      
  

/*
 * FPGA_FLASH
 */
        
#define FLASH_ID                                 0x52223000
#define FLASH_ID_dft                             0x00000101

typedef volatile union {
  struct {
    ca_uint32_t flashRevID           :  8 ; /* bits 7:0 */
    ca_uint32_t flashDevID           : 24 ; /* bits 31:8 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_ID_t;


#define FLASH_TIMEOUT                            0x52223004
#define FLASH_TIMEOUT_dft                        0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t timeout_load         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_TIMEOUT_t;


#define FLASH_STATUS                             0x52223008
#define FLASH_STATUS_dft                         0x06000000

typedef volatile union {
  struct {
    ca_uint32_t sState               :  4 ; /* bits 3:0 */
    ca_uint32_t pState               :  4 ; /* bits 7:4 */
    ca_uint32_t nState               :  4 ; /* bits 11:8 */
    ca_uint32_t rsrvd1               : 13 ;
    ca_uint32_t pflash_rbIn_d        :  1 ; /* bits 25:25 */
    ca_uint32_t nflash_rbIn_d        :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd2               :  5 ;
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_STATUS_t;


#define FLASH_TYPE                               0x5222300c
#define FLASH_TYPE_dft                           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  9 ;
    ca_uint32_t flashSize            :  2 ; /* bits 10:9 */
    ca_uint32_t flashWidth           :  1 ; /* bits 11:11 */
    ca_uint32_t flashType            :  3 ; /* bits 14:12 */
    ca_uint32_t flashPin             :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd2               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_TYPE_t;


#define FLASH_FLASH_ACCESS_START                 0x52223010
#define FLASH_FLASH_ACCESS_START_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t nflashRegReq         :  1 ; /* bits 0:0 */
    ca_uint32_t sflashRegReq         :  1 ; /* bits 1:1 */
    ca_uint32_t nflashFifoReq        :  1 ; /* bits 2:2 */
    ca_uint32_t sflashFifoReq        :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t sflashRegCmd         :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t nflashRegCmd         :  2 ; /* bits 13:12 */
    ca_uint32_t rsrvd3               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_FLASH_ACCESS_START_t;


#define FLASH_FLASH_INTERRUPT                    0x52223014
#define FLASH_FLASH_INTERRUPT_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t regIrq               :  1 ; /* bits 0:0 */
    ca_uint32_t fifoIrq              :  1 ; /* bits 1:1 */
    ca_uint32_t f_addr_err           :  1 ; /* bits 2:2 */
    ca_uint32_t eccIrq               :  1 ; /* bits 3:3 */
    ca_uint32_t nfWdtIrq             :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t bchGenIrq            :  1 ; /* bits 6:6 */
    ca_uint32_t bchDecIrq            :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd2               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_FLASH_INTERRUPT_t;


#define FLASH_FLASH_MASK                         0x52223018
#define FLASH_FLASH_MASK_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t flashRegIrqMask      :  1 ; /* bits 0:0 */
    ca_uint32_t fifoIrqMask          :  1 ; /* bits 1:1 */
    ca_uint32_t f_addr_IrqMask       :  1 ; /* bits 2:2 */
    ca_uint32_t eccIrqMask           :  1 ; /* bits 3:3 */
    ca_uint32_t nfWdtIrqMask         :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t bchGenIrqMask        :  1 ; /* bits 6:6 */
    ca_uint32_t bchDecIrqMask        :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd2               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_FLASH_MASK_t;


#define FLASH_FIFO_CONTROL                       0x5222301c
#define FLASH_FIFO_CONTROL_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t fifoCmd              :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t fifoDbgSel           :  4 ; /* bits 7:4 */
    ca_uint32_t fifoClear            :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd2               : 15 ;
    ca_uint32_t fifoRDTH             :  2 ; /* bits 25:24 */
    ca_uint32_t fifoWRTH             :  2 ; /* bits 27:26 */
    ca_uint32_t rsrvd3               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_FIFO_CONTROL_t;


#define FLASH_FIFO_STATUS                        0x52223020
#define FLASH_FIFO_STATUS_dft                    0x00000004

typedef volatile union {
  struct {
    ca_uint32_t f_state              :  2 ; /* bits 1:0 */
    ca_uint32_t f_empty              :  1 ; /* bits 2:2 */
    ca_uint32_t f_full               :  1 ; /* bits 3:3 */
    ca_uint32_t f_ptr_rd             :  5 ; /* bits 8:4 */
    ca_uint32_t f_ptr_wr             :  5 ; /* bits 13:9 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t f_addr_count         :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd2               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_FIFO_STATUS_t;


#define FLASH_FIFO_ADDRESS                       0x52223024
#define FLASH_FIFO_ADDRESS_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t f_AXADDR             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_FIFO_ADDRESS_t;


#define FLASH_FIFO_MATCH_ADDRESS                 0x52223028
#define FLASH_FIFO_MATCH_ADDRESS_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t f_AXADDR_compare     : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_FIFO_MATCH_ADDRESS_t;


#define FLASH_FIFO_DATA                          0x5222302c
#define FLASH_FIFO_DATA_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t f_ebuf_mem1          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_FIFO_DATA_t;


#define FLASH_SF_ACCESS                          0x52223030
#define FLASH_SF_ACCESS_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sflashOpCode         :  8 ; /* bits 7:0 */
    ca_uint32_t sflashAcCode         :  4 ; /* bits 11:8 */
    ca_uint32_t sflashForceTerm      :  1 ; /* bits 12:12 */
    ca_uint32_t sflashForceBurst     :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t sflashCnMode         :  1 ; /* bits 15:15 */
    ca_uint32_t sflashCeAlt          :  1 ; /* bits 16:16 */
    ca_uint32_t sflashHSRd           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd2               :  6 ;
    ca_uint32_t sflashMData          :  1 ; /* bits 24:24 */
    ca_uint32_t sflashMAddr          :  1 ; /* bits 25:25 */
    ca_uint32_t sflashMCmd           :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t sflashDDR            :  2 ; /* bits 29:28 */
    ca_uint32_t sflashMIO            :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_SF_ACCESS_t;


#define FLASH_SF_EXT_ACCESS                      0x52223034
#define FLASH_SF_EXT_ACCESS_dft                  0x3fffff00

typedef volatile union {
  struct {
    ca_uint32_t sflashOpCode         :  8 ; /* bits 7:0 */
    ca_uint32_t sflashDataCount      : 13 ; /* bits 20:8 */
    ca_uint32_t sflashAddrCount      :  3 ; /* bits 23:21 */
    ca_uint32_t sflashDummyCount     :  6 ; /* bits 29:24 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t sflashDirRdCmdEn     :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_SF_EXT_ACCESS_t;


#define FLASH_SF_ADDRESS                         0x52223038
#define FLASH_SF_ADDRESS_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sflashRegAddr        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_SF_ADDRESS_t;


#define FLASH_SF_DATA                            0x5222303c
#define FLASH_SF_DATA_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sflashRegWData       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_SF_DATA_t;


#define FLASH_SF_TIMING                          0x52223040
#define FLASH_SF_TIMING_dft                      0x00373737

typedef volatile union {
  struct {
    ca_uint32_t sflashIdleTime       :  8 ; /* bits 7:0 */
    ca_uint32_t sflashHoldTime       :  8 ; /* bits 15:8 */
    ca_uint32_t sflashSetupTime      :  8 ; /* bits 23:16 */
    ca_uint32_t sflashClkWidth       :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd1               :  5 ;
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_SF_TIMING_t;


#define FLASH_PF_ACCESS                          0x52223050
#define FLASH_PF_ACCESS_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pflashExtAddr        :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 11 ;
    ca_uint32_t pflashCeAlt          :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t pflashBzChk          :  1 ; /* bits 20:20 */
    ca_uint32_t pflashBzPol          :  1 ; /* bits 21:21 */
    ca_uint32_t pflashRdPol          :  1 ; /* bits 22:22 */
    ca_uint32_t pflashWrPol          :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd3               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_PF_ACCESS_t;


#define FLASH_PF_TIMING                          0x52223054
#define FLASH_PF_TIMING_dft                      0x000f0f07

typedef volatile union {
  struct {
    ca_uint32_t pflashIdleTime       :  8 ; /* bits 7:0 */
    ca_uint32_t pflashHoldTime       :  8 ; /* bits 15:8 */
    ca_uint32_t pflashSetupTime      :  8 ; /* bits 23:16 */
    ca_uint32_t pflashClkWidth       :  2 ; /* bits 25:24 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_PF_TIMING_t;


#define FLASH_NF_ACCESS                          0x52223060
#define FLASH_NF_ACCESS_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t nflashExtAddr        :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t nflashRegWidth       :  2 ; /* bits 11:10 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t nflashCeAlt          :  1 ; /* bits 15:15 */
    ca_uint32_t autoReset            :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd3               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_ACCESS_t;


#define FLASH_NF_COUNT                           0x52223064
#define FLASH_NF_COUNT_dft                       0xffffff00

typedef volatile union {
  struct {
    ca_uint32_t nflashRegCmdCount    :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t nflashRegAddrCount   :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t nflashRegDataCount   : 14 ; /* bits 21:8 */
    ca_uint32_t nflashRegOobCount    : 10 ; /* bits 31:22 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_COUNT_t;


#define FLASH_NF_COMMAND                         0x52223068
#define FLASH_NF_COMMAND_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t nflashRegCmd0        :  8 ; /* bits 7:0 */
    ca_uint32_t nflashRegCmd1        :  8 ; /* bits 15:8 */
    ca_uint32_t nflashRegCmd2        :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_COMMAND_t;


#define FLASH_NF_ADDRESS_1                       0x5222306c
#define FLASH_NF_ADDRESS_1_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t nflashRegAddr0       :  8 ; /* bits 7:0 */
    ca_uint32_t nflashRegAddr1       :  8 ; /* bits 15:8 */
    ca_uint32_t nflashRegAddr2       :  8 ; /* bits 23:16 */
    ca_uint32_t nflashRegAddr3       :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_ADDRESS_1_t;


#define FLASH_NF_ADDRESS_2                       0x52223070
#define FLASH_NF_ADDRESS_2_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t nflashRegAddr4       :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_ADDRESS_2_t;


#define FLASH_NF_DATA                            0x52223074
#define FLASH_NF_DATA_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t nflashRegWData       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_DATA_t;


#define FLASH_NF_TIMING                          0x52223078
#define FLASH_NF_TIMING_dft                      0x00041703

typedef volatile union {
  struct {
    ca_uint32_t nflashIdleTime       :  8 ; /* bits 7:0 */
    ca_uint32_t nflashHoldTime       :  8 ; /* bits 15:8 */
    ca_uint32_t nflashSetupTime      :  8 ; /* bits 23:16 */
    ca_uint32_t nflashClkWidth       :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd1               :  5 ;
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_TIMING_t;


#define FLASH_NF_ECC_STATUS                      0x5222307c
#define FLASH_NF_ECC_STATUS_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t eccStatus            :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t eccErrBit            :  4 ; /* bits 6:3 */
    ca_uint32_t eccErrByte           :  9 ; /* bits 15:7 */
    ca_uint32_t eccErrWord           :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd2               :  7 ;
    ca_uint32_t eccDone              :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_ECC_STATUS_t;


#define FLASH_NF_ECC_CONTROL                     0x52223080
#define FLASH_NF_ECC_CONTROL_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t eccGenMode           :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t eccCodeSel           :  4 ; /* bits 7:4 */
    ca_uint32_t eccEn                :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd3               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_ECC_CONTROL_t;


#define FLASH_NF_ECC_OOB                         0x52223084
#define FLASH_NF_ECC_OOB_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t eccCodeOob           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_ECC_OOB_t;


#define FLASH_NF_ECC_GEN0                        0x52223088
#define FLASH_NF_ECC_GEN0_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t eccCodeGen0          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_ECC_GEN0_t;


#define FLASH_NF_ECC_GEN1                        0x5222308c
#define FLASH_NF_ECC_GEN1_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t eccCodeGen1          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_ECC_GEN1_t;


#define FLASH_NF_ECC_GEN2                        0x52223090
#define FLASH_NF_ECC_GEN2_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t eccCodeGen2          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_ECC_GEN2_t;


#define FLASH_NF_ECC_GEN3                        0x52223094
#define FLASH_NF_ECC_GEN3_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t eccCodeGen3          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_ECC_GEN3_t;


#define FLASH_NF_ECC_GEN4                        0x52223098
#define FLASH_NF_ECC_GEN4_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t eccCodeGen4          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_ECC_GEN4_t;


#define FLASH_NF_ECC_GEN5                        0x5222309c
#define FLASH_NF_ECC_GEN5_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t eccCodeGen5          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_ECC_GEN5_t;


#define FLASH_NF_ECC_GEN6                        0x522230a0
#define FLASH_NF_ECC_GEN6_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t eccCodeGen6          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_ECC_GEN6_t;


#define FLASH_NF_ECC_GEN7                        0x522230a4
#define FLASH_NF_ECC_GEN7_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t eccCodeGen7          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_ECC_GEN7_t;


#define FLASH_NF_ECC_GEN8                        0x522230a8
#define FLASH_NF_ECC_GEN8_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t eccCodeGen8          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_ECC_GEN8_t;


#define FLASH_NF_ECC_GEN9                        0x522230ac
#define FLASH_NF_ECC_GEN9_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t eccCodeGen9          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_ECC_GEN9_t;


#define FLASH_NF_ECC_GEN10                       0x522230b0
#define FLASH_NF_ECC_GEN10_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t eccCodeGen10         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_ECC_GEN10_t;


#define FLASH_NF_ECC_GEN11                       0x522230b4
#define FLASH_NF_ECC_GEN11_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t eccCodeGen11         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_ECC_GEN11_t;


#define FLASH_NF_ECC_GEN12                       0x522230b8
#define FLASH_NF_ECC_GEN12_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t eccCodeGen12         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_ECC_GEN12_t;


#define FLASH_NF_ECC_GEN13                       0x522230bc
#define FLASH_NF_ECC_GEN13_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t eccCodeGen13         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_ECC_GEN13_t;


#define FLASH_NF_ECC_GEN14                       0x522230c0
#define FLASH_NF_ECC_GEN14_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t eccCodeGen14         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_ECC_GEN14_t;


#define FLASH_NF_ECC_GEN15                       0x522230c4
#define FLASH_NF_ECC_GEN15_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t eccCodeGen15         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_ECC_GEN15_t;


#define FLASH_NF_ECC_RESET                       0x522230c8
#define FLASH_NF_ECC_RESET_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t eccClear             :  1 ; /* bits 0:0 */
    ca_uint32_t fifoClear            :  1 ; /* bits 1:1 */
    ca_uint32_t nflash_reset         :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_ECC_RESET_t;


#define FLASH_NF_BCH_CONTROL                     0x522230cc
#define FLASH_NF_BCH_CONTROL_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCompare           :  1 ; /* bits 0:0 */
    ca_uint32_t bchOpcode            :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t bchCodeSel           :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t bchEn                :  1 ; /* bits 8:8 */
    ca_uint32_t bchErrCap            :  2 ; /* bits 10:9 */
    ca_uint32_t rsrvd3               :  5 ;
    ca_uint32_t bchTestCtrl          :  4 ; /* bits 19:16 */
    ca_uint32_t rsrvd4               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_CONTROL_t;


#define FLASH_NF_BCH_STATUS                      0x522230d0
#define FLASH_NF_BCH_STATUS_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchDecStatus         :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               :  6 ;
    ca_uint32_t bchErrNum            :  6 ; /* bits 13:8 */
    ca_uint32_t rsrvd2               : 16 ;
    ca_uint32_t bchDecDone           :  1 ; /* bits 30:30 */
    ca_uint32_t bchGenDone           :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_STATUS_t;


#define FLASH_NF_BCH_ERROR_LOC01                 0x522230d4
#define FLASH_NF_BCH_ERROR_LOC01_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchErrLoc0           : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t bchErrLoc1           : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_ERROR_LOC01_t;


#define FLASH_NF_BCH_ERROR_LOC23                 0x522230d8
#define FLASH_NF_BCH_ERROR_LOC23_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchErrLoc2           : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t bchErrLoc3           : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_ERROR_LOC23_t;


#define FLASH_NF_BCH_ERROR_LOC45                 0x522230dc
#define FLASH_NF_BCH_ERROR_LOC45_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchErrLoc4           : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t bchErrLoc5           : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_ERROR_LOC45_t;


#define FLASH_NF_BCH_ERROR_LOC67                 0x522230e0
#define FLASH_NF_BCH_ERROR_LOC67_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchErrLoc6           : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t bchErrLoc7           : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_ERROR_LOC67_t;


#define FLASH_NF_BCH_ERROR_LOC89                 0x522230e4
#define FLASH_NF_BCH_ERROR_LOC89_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchErrLoc8           : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t bchErrLoc9           : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_ERROR_LOC89_t;


#define FLASH_NF_BCH_ERROR_LOC1011               0x522230e8
#define FLASH_NF_BCH_ERROR_LOC1011_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchErrLoc10          : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t bchErrLoc11          : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_ERROR_LOC1011_t;


#define FLASH_NF_BCH_ERROR_LOC1213               0x522230ec
#define FLASH_NF_BCH_ERROR_LOC1213_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchErrLoc12          : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t bchErrLoc13          : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_ERROR_LOC1213_t;


#define FLASH_NF_BCH_ERROR_LOC1415               0x522230f0
#define FLASH_NF_BCH_ERROR_LOC1415_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchErrLoc14          : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t bchErrLoc15          : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_ERROR_LOC1415_t;


#define FLASH_NF_BCH_ERROR_LOC1617               0x522230f4
#define FLASH_NF_BCH_ERROR_LOC1617_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchErrLoc16          : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t bchErrLoc17          : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_ERROR_LOC1617_t;


#define FLASH_NF_BCH_ERROR_LOC1819               0x522230f8
#define FLASH_NF_BCH_ERROR_LOC1819_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchErrLoc18          : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t bchErrLoc19          : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_ERROR_LOC1819_t;


#define FLASH_NF_BCH_ERROR_LOC2021               0x522230fc
#define FLASH_NF_BCH_ERROR_LOC2021_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchErrLoc20          : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t bchErrLoc21          : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_ERROR_LOC2021_t;


#define FLASH_NF_BCH_ERROR_LOC2223               0x52223100
#define FLASH_NF_BCH_ERROR_LOC2223_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchErrLoc22          : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t bchErrLoc23          : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_ERROR_LOC2223_t;


#define FLASH_NF_BCH_ERROR_LOC2425               0x52223104
#define FLASH_NF_BCH_ERROR_LOC2425_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchErrLoc24          : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t bchErrLoc25          : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_ERROR_LOC2425_t;


#define FLASH_NF_BCH_ERROR_LOC2627               0x52223108
#define FLASH_NF_BCH_ERROR_LOC2627_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchErrLoc26          : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t bchErrLoc27          : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_ERROR_LOC2627_t;


#define FLASH_NF_BCH_ERROR_LOC2829               0x5222310c
#define FLASH_NF_BCH_ERROR_LOC2829_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchErrLoc28          : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t bchErrLoc29          : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_ERROR_LOC2829_t;


#define FLASH_NF_BCH_ERROR_LOC3031               0x52223110
#define FLASH_NF_BCH_ERROR_LOC3031_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchErrLoc30          : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t bchErrLoc31          : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_ERROR_LOC3031_t;


#define FLASH_NF_BCH_ERROR_LOC3233               0x52223114
#define FLASH_NF_BCH_ERROR_LOC3233_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchErrLoc32          : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t bchErrLoc33          : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_ERROR_LOC3233_t;


#define FLASH_NF_BCH_ERROR_LOC3435               0x52223118
#define FLASH_NF_BCH_ERROR_LOC3435_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchErrLoc34          : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t bchErrLoc35          : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_ERROR_LOC3435_t;


#define FLASH_NF_BCH_ERROR_LOC3637               0x5222311c
#define FLASH_NF_BCH_ERROR_LOC3637_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchErrLoc36          : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t bchErrLoc37          : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_ERROR_LOC3637_t;


#define FLASH_NF_BCH_ERROR_LOC3839               0x52223120
#define FLASH_NF_BCH_ERROR_LOC3839_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchErrLoc38          : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t bchErrLoc39          : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_ERROR_LOC3839_t;


#define FLASH_NF_BCH_OOB0                        0x52223124
#define FLASH_NF_BCH_OOB0_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeOob0          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_OOB0_t;


#define FLASH_NF_BCH_OOB1                        0x52223128
#define FLASH_NF_BCH_OOB1_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeOob1          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_OOB1_t;


#define FLASH_NF_BCH_OOB2                        0x5222312c
#define FLASH_NF_BCH_OOB2_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeOob2          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_OOB2_t;


#define FLASH_NF_BCH_OOB3                        0x52223130
#define FLASH_NF_BCH_OOB3_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeOob3          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_OOB3_t;


#define FLASH_NF_BCH_OOB4                        0x52223134
#define FLASH_NF_BCH_OOB4_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeOob4          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_OOB4_t;


#define FLASH_NF_BCH_OOB5                        0x52223138
#define FLASH_NF_BCH_OOB5_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeOob5          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_OOB5_t;


#define FLASH_NF_BCH_OOB6                        0x5222313c
#define FLASH_NF_BCH_OOB6_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeOob6          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_OOB6_t;


#define FLASH_NF_BCH_OOB7                        0x52223140
#define FLASH_NF_BCH_OOB7_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeOob7          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_OOB7_t;


#define FLASH_NF_BCH_OOB8                        0x52223144
#define FLASH_NF_BCH_OOB8_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeOob8          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_OOB8_t;


#define FLASH_NF_BCH_OOB9                        0x52223148
#define FLASH_NF_BCH_OOB9_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeOob9          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_OOB9_t;


#define FLASH_NF_BCH_OOB10                       0x5222314c
#define FLASH_NF_BCH_OOB10_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeOob10         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_OOB10_t;


#define FLASH_NF_BCH_OOB11                       0x52223150
#define FLASH_NF_BCH_OOB11_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeOob11         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_OOB11_t;


#define FLASH_NF_BCH_OOB12                       0x52223154
#define FLASH_NF_BCH_OOB12_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeOob12         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_OOB12_t;


#define FLASH_NF_BCH_OOB13                       0x52223158
#define FLASH_NF_BCH_OOB13_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeOob13         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_OOB13_t;


#define FLASH_NF_BCH_OOB14                       0x5222315c
#define FLASH_NF_BCH_OOB14_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeOob14         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_OOB14_t;


#define FLASH_NF_BCH_OOB15                       0x52223160
#define FLASH_NF_BCH_OOB15_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeOob15         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_OOB15_t;


#define FLASH_NF_BCH_OOB16                       0x52223164
#define FLASH_NF_BCH_OOB16_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeOob16         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_OOB16_t;


#define FLASH_NF_BCH_OOB17                       0x52223168
#define FLASH_NF_BCH_OOB17_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeOob17         : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_OOB17_t;


#define FLASH_NF_BCH_GEN0_0                      0x5222316c
#define FLASH_NF_BCH_GEN0_0_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen0_0        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN0_0_t;


#define FLASH_NF_BCH_GEN0_1                      0x52223170
#define FLASH_NF_BCH_GEN0_1_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen0_1        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN0_1_t;


#define FLASH_NF_BCH_GEN0_2                      0x52223174
#define FLASH_NF_BCH_GEN0_2_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen0_2        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN0_2_t;


#define FLASH_NF_BCH_GEN0_3                      0x52223178
#define FLASH_NF_BCH_GEN0_3_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen0_3        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN0_3_t;


#define FLASH_NF_BCH_GEN0_4                      0x5222317c
#define FLASH_NF_BCH_GEN0_4_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen0_4        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN0_4_t;


#define FLASH_NF_BCH_GEN0_5                      0x52223180
#define FLASH_NF_BCH_GEN0_5_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen0_5        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN0_5_t;


#define FLASH_NF_BCH_GEN0_6                      0x52223184
#define FLASH_NF_BCH_GEN0_6_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen0_6        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN0_6_t;


#define FLASH_NF_BCH_GEN0_7                      0x52223188
#define FLASH_NF_BCH_GEN0_7_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen0_7        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN0_7_t;


#define FLASH_NF_BCH_GEN0_8                      0x5222318c
#define FLASH_NF_BCH_GEN0_8_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen0_8        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN0_8_t;


#define FLASH_NF_BCH_GEN0_9                      0x52223190
#define FLASH_NF_BCH_GEN0_9_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen0_9        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN0_9_t;


#define FLASH_NF_BCH_GEN0_10                     0x52223194
#define FLASH_NF_BCH_GEN0_10_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen0_10       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN0_10_t;


#define FLASH_NF_BCH_GEN0_11                     0x52223198
#define FLASH_NF_BCH_GEN0_11_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen0_11       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN0_11_t;


#define FLASH_NF_BCH_GEN0_12                     0x5222319c
#define FLASH_NF_BCH_GEN0_12_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen0_12       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN0_12_t;


#define FLASH_NF_BCH_GEN0_13                     0x522231a0
#define FLASH_NF_BCH_GEN0_13_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen0_13       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN0_13_t;


#define FLASH_NF_BCH_GEN0_14                     0x522231a4
#define FLASH_NF_BCH_GEN0_14_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen0_14       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN0_14_t;


#define FLASH_NF_BCH_GEN0_15                     0x522231a8
#define FLASH_NF_BCH_GEN0_15_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen0_15       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN0_15_t;


#define FLASH_NF_BCH_GEN0_16                     0x522231ac
#define FLASH_NF_BCH_GEN0_16_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen0_16       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN0_16_t;


#define FLASH_NF_BCH_GEN0_17                     0x522231b0
#define FLASH_NF_BCH_GEN0_17_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen0_17       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN0_17_t;


#define FLASH_NF_BCH_GEN1_0                      0x522231b4
#define FLASH_NF_BCH_GEN1_0_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen1_0        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN1_0_t;


#define FLASH_NF_BCH_GEN1_1                      0x522231b8
#define FLASH_NF_BCH_GEN1_1_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen1_1        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN1_1_t;


#define FLASH_NF_BCH_GEN1_2                      0x522231bc
#define FLASH_NF_BCH_GEN1_2_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen1_2        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN1_2_t;


#define FLASH_NF_BCH_GEN1_3                      0x522231c0
#define FLASH_NF_BCH_GEN1_3_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen1_3        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN1_3_t;


#define FLASH_NF_BCH_GEN1_4                      0x522231c4
#define FLASH_NF_BCH_GEN1_4_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen1_4        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN1_4_t;


#define FLASH_NF_BCH_GEN1_5                      0x522231c8
#define FLASH_NF_BCH_GEN1_5_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen1_5        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN1_5_t;


#define FLASH_NF_BCH_GEN1_6                      0x522231cc
#define FLASH_NF_BCH_GEN1_6_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen1_6        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN1_6_t;


#define FLASH_NF_BCH_GEN1_7                      0x522231d0
#define FLASH_NF_BCH_GEN1_7_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen1_7        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN1_7_t;


#define FLASH_NF_BCH_GEN1_8                      0x522231d4
#define FLASH_NF_BCH_GEN1_8_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen1_8        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN1_8_t;


#define FLASH_NF_BCH_GEN1_9                      0x522231d8
#define FLASH_NF_BCH_GEN1_9_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen1_9        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN1_9_t;


#define FLASH_NF_BCH_GEN1_10                     0x522231dc
#define FLASH_NF_BCH_GEN1_10_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen1_10       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN1_10_t;


#define FLASH_NF_BCH_GEN1_11                     0x522231e0
#define FLASH_NF_BCH_GEN1_11_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen1_11       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN1_11_t;


#define FLASH_NF_BCH_GEN1_12                     0x522231e4
#define FLASH_NF_BCH_GEN1_12_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen1_12       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN1_12_t;


#define FLASH_NF_BCH_GEN1_13                     0x522231e8
#define FLASH_NF_BCH_GEN1_13_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen1_13       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN1_13_t;


#define FLASH_NF_BCH_GEN1_14                     0x522231ec
#define FLASH_NF_BCH_GEN1_14_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen1_14       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN1_14_t;


#define FLASH_NF_BCH_GEN1_15                     0x522231f0
#define FLASH_NF_BCH_GEN1_15_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen1_15       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN1_15_t;


#define FLASH_NF_BCH_GEN1_16                     0x522231f4
#define FLASH_NF_BCH_GEN1_16_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen1_16       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN1_16_t;


#define FLASH_NF_BCH_GEN1_17                     0x522231f8
#define FLASH_NF_BCH_GEN1_17_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen1_17       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN1_17_t;


#define FLASH_NF_BCH_GEN2_0                      0x522231fc
#define FLASH_NF_BCH_GEN2_0_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen2_0        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN2_0_t;


#define FLASH_NF_BCH_GEN2_1                      0x52223200
#define FLASH_NF_BCH_GEN2_1_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen2_1        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN2_1_t;


#define FLASH_NF_BCH_GEN2_2                      0x52223204
#define FLASH_NF_BCH_GEN2_2_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen2_2        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN2_2_t;


#define FLASH_NF_BCH_GEN2_3                      0x52223208
#define FLASH_NF_BCH_GEN2_3_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen2_3        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN2_3_t;


#define FLASH_NF_BCH_GEN2_4                      0x5222320c
#define FLASH_NF_BCH_GEN2_4_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen2_4        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN2_4_t;


#define FLASH_NF_BCH_GEN2_5                      0x52223210
#define FLASH_NF_BCH_GEN2_5_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen2_5        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN2_5_t;


#define FLASH_NF_BCH_GEN2_6                      0x52223214
#define FLASH_NF_BCH_GEN2_6_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen2_6        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN2_6_t;


#define FLASH_NF_BCH_GEN2_7                      0x52223218
#define FLASH_NF_BCH_GEN2_7_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen2_7        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN2_7_t;


#define FLASH_NF_BCH_GEN2_8                      0x5222321c
#define FLASH_NF_BCH_GEN2_8_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen2_8        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN2_8_t;


#define FLASH_NF_BCH_GEN2_9                      0x52223220
#define FLASH_NF_BCH_GEN2_9_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen2_9        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN2_9_t;


#define FLASH_NF_BCH_GEN2_10                     0x52223224
#define FLASH_NF_BCH_GEN2_10_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen2_10       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN2_10_t;


#define FLASH_NF_BCH_GEN2_11                     0x52223228
#define FLASH_NF_BCH_GEN2_11_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen2_11       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN2_11_t;


#define FLASH_NF_BCH_GEN2_12                     0x5222322c
#define FLASH_NF_BCH_GEN2_12_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen2_12       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN2_12_t;


#define FLASH_NF_BCH_GEN2_13                     0x52223230
#define FLASH_NF_BCH_GEN2_13_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen2_13       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN2_13_t;


#define FLASH_NF_BCH_GEN2_14                     0x52223234
#define FLASH_NF_BCH_GEN2_14_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen2_14       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN2_14_t;


#define FLASH_NF_BCH_GEN2_15                     0x52223238
#define FLASH_NF_BCH_GEN2_15_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen2_15       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN2_15_t;


#define FLASH_NF_BCH_GEN2_16                     0x5222323c
#define FLASH_NF_BCH_GEN2_16_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen2_16       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN2_16_t;


#define FLASH_NF_BCH_GEN2_17                     0x52223240
#define FLASH_NF_BCH_GEN2_17_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen2_17       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN2_17_t;


#define FLASH_NF_BCH_GEN3_0                      0x52223244
#define FLASH_NF_BCH_GEN3_0_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen3_0        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN3_0_t;


#define FLASH_NF_BCH_GEN3_1                      0x52223248
#define FLASH_NF_BCH_GEN3_1_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen3_1        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN3_1_t;


#define FLASH_NF_BCH_GEN3_2                      0x5222324c
#define FLASH_NF_BCH_GEN3_2_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen3_2        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN3_2_t;


#define FLASH_NF_BCH_GEN3_3                      0x52223250
#define FLASH_NF_BCH_GEN3_3_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen3_3        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN3_3_t;


#define FLASH_NF_BCH_GEN3_4                      0x52223254
#define FLASH_NF_BCH_GEN3_4_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen3_4        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN3_4_t;


#define FLASH_NF_BCH_GEN3_5                      0x52223258
#define FLASH_NF_BCH_GEN3_5_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen3_5        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN3_5_t;


#define FLASH_NF_BCH_GEN3_6                      0x5222325c
#define FLASH_NF_BCH_GEN3_6_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen3_6        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN3_6_t;


#define FLASH_NF_BCH_GEN3_7                      0x52223260
#define FLASH_NF_BCH_GEN3_7_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen3_7        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN3_7_t;


#define FLASH_NF_BCH_GEN3_8                      0x52223264
#define FLASH_NF_BCH_GEN3_8_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen3_8        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN3_8_t;


#define FLASH_NF_BCH_GEN3_9                      0x52223268
#define FLASH_NF_BCH_GEN3_9_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen3_9        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN3_9_t;


#define FLASH_NF_BCH_GEN3_10                     0x5222326c
#define FLASH_NF_BCH_GEN3_10_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen3_10       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN3_10_t;


#define FLASH_NF_BCH_GEN3_11                     0x52223270
#define FLASH_NF_BCH_GEN3_11_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen3_11       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN3_11_t;


#define FLASH_NF_BCH_GEN3_12                     0x52223274
#define FLASH_NF_BCH_GEN3_12_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen3_12       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN3_12_t;


#define FLASH_NF_BCH_GEN3_13                     0x52223278
#define FLASH_NF_BCH_GEN3_13_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen3_13       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN3_13_t;


#define FLASH_NF_BCH_GEN3_14                     0x5222327c
#define FLASH_NF_BCH_GEN3_14_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen3_14       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN3_14_t;


#define FLASH_NF_BCH_GEN3_15                     0x52223280
#define FLASH_NF_BCH_GEN3_15_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen3_15       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN3_15_t;


#define FLASH_NF_BCH_GEN3_16                     0x52223284
#define FLASH_NF_BCH_GEN3_16_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen3_16       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN3_16_t;


#define FLASH_NF_BCH_GEN3_17                     0x52223288
#define FLASH_NF_BCH_GEN3_17_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen3_17       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN3_17_t;


#define FLASH_NF_BCH_GEN4_0                      0x5222328c
#define FLASH_NF_BCH_GEN4_0_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen4_0        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN4_0_t;


#define FLASH_NF_BCH_GEN4_1                      0x52223290
#define FLASH_NF_BCH_GEN4_1_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen4_1        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN4_1_t;


#define FLASH_NF_BCH_GEN4_2                      0x52223294
#define FLASH_NF_BCH_GEN4_2_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen4_2        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN4_2_t;


#define FLASH_NF_BCH_GEN4_3                      0x52223298
#define FLASH_NF_BCH_GEN4_3_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen4_3        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN4_3_t;


#define FLASH_NF_BCH_GEN4_4                      0x5222329c
#define FLASH_NF_BCH_GEN4_4_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen4_4        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN4_4_t;


#define FLASH_NF_BCH_GEN4_5                      0x522232a0
#define FLASH_NF_BCH_GEN4_5_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen4_5        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN4_5_t;


#define FLASH_NF_BCH_GEN4_6                      0x522232a4
#define FLASH_NF_BCH_GEN4_6_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen4_6        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN4_6_t;


#define FLASH_NF_BCH_GEN4_7                      0x522232a8
#define FLASH_NF_BCH_GEN4_7_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen4_7        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN4_7_t;


#define FLASH_NF_BCH_GEN4_8                      0x522232ac
#define FLASH_NF_BCH_GEN4_8_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen4_8        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN4_8_t;


#define FLASH_NF_BCH_GEN4_9                      0x522232b0
#define FLASH_NF_BCH_GEN4_9_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen4_9        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN4_9_t;


#define FLASH_NF_BCH_GEN4_10                     0x522232b4
#define FLASH_NF_BCH_GEN4_10_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen4_10       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN4_10_t;


#define FLASH_NF_BCH_GEN4_11                     0x522232b8
#define FLASH_NF_BCH_GEN4_11_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen4_11       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN4_11_t;


#define FLASH_NF_BCH_GEN4_12                     0x522232bc
#define FLASH_NF_BCH_GEN4_12_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen4_12       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN4_12_t;


#define FLASH_NF_BCH_GEN4_13                     0x522232c0
#define FLASH_NF_BCH_GEN4_13_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen4_13       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN4_13_t;


#define FLASH_NF_BCH_GEN4_14                     0x522232c4
#define FLASH_NF_BCH_GEN4_14_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen4_14       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN4_14_t;


#define FLASH_NF_BCH_GEN4_15                     0x522232c8
#define FLASH_NF_BCH_GEN4_15_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen4_15       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN4_15_t;


#define FLASH_NF_BCH_GEN4_16                     0x522232cc
#define FLASH_NF_BCH_GEN4_16_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen4_16       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN4_16_t;


#define FLASH_NF_BCH_GEN4_17                     0x522232d0
#define FLASH_NF_BCH_GEN4_17_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen4_17       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN4_17_t;


#define FLASH_NF_BCH_GEN5_0                      0x522232d4
#define FLASH_NF_BCH_GEN5_0_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen5_0        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN5_0_t;


#define FLASH_NF_BCH_GEN5_1                      0x522232d8
#define FLASH_NF_BCH_GEN5_1_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen5_1        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN5_1_t;


#define FLASH_NF_BCH_GEN5_2                      0x522232dc
#define FLASH_NF_BCH_GEN5_2_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen5_2        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN5_2_t;


#define FLASH_NF_BCH_GEN5_3                      0x522232e0
#define FLASH_NF_BCH_GEN5_3_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen5_3        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN5_3_t;


#define FLASH_NF_BCH_GEN5_4                      0x522232e4
#define FLASH_NF_BCH_GEN5_4_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen5_4        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN5_4_t;


#define FLASH_NF_BCH_GEN5_5                      0x522232e8
#define FLASH_NF_BCH_GEN5_5_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen5_5        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN5_5_t;


#define FLASH_NF_BCH_GEN5_6                      0x522232ec
#define FLASH_NF_BCH_GEN5_6_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen5_6        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN5_6_t;


#define FLASH_NF_BCH_GEN5_7                      0x522232f0
#define FLASH_NF_BCH_GEN5_7_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen5_7        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN5_7_t;


#define FLASH_NF_BCH_GEN5_8                      0x522232f4
#define FLASH_NF_BCH_GEN5_8_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen5_8        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN5_8_t;


#define FLASH_NF_BCH_GEN5_9                      0x522232f8
#define FLASH_NF_BCH_GEN5_9_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen5_9        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN5_9_t;


#define FLASH_NF_BCH_GEN5_10                     0x522232fc
#define FLASH_NF_BCH_GEN5_10_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen5_10       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN5_10_t;


#define FLASH_NF_BCH_GEN5_11                     0x52223300
#define FLASH_NF_BCH_GEN5_11_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen5_11       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN5_11_t;


#define FLASH_NF_BCH_GEN5_12                     0x52223304
#define FLASH_NF_BCH_GEN5_12_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen5_12       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN5_12_t;


#define FLASH_NF_BCH_GEN5_13                     0x52223308
#define FLASH_NF_BCH_GEN5_13_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen5_13       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN5_13_t;


#define FLASH_NF_BCH_GEN5_14                     0x5222330c
#define FLASH_NF_BCH_GEN5_14_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen5_14       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN5_14_t;


#define FLASH_NF_BCH_GEN5_15                     0x52223310
#define FLASH_NF_BCH_GEN5_15_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen5_15       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN5_15_t;


#define FLASH_NF_BCH_GEN5_16                     0x52223314
#define FLASH_NF_BCH_GEN5_16_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen5_16       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN5_16_t;


#define FLASH_NF_BCH_GEN5_17                     0x52223318
#define FLASH_NF_BCH_GEN5_17_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen5_17       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN5_17_t;


#define FLASH_NF_BCH_GEN6_0                      0x5222331c
#define FLASH_NF_BCH_GEN6_0_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen6_0        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN6_0_t;


#define FLASH_NF_BCH_GEN6_1                      0x52223320
#define FLASH_NF_BCH_GEN6_1_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen6_1        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN6_1_t;


#define FLASH_NF_BCH_GEN6_2                      0x52223324
#define FLASH_NF_BCH_GEN6_2_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen6_2        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN6_2_t;


#define FLASH_NF_BCH_GEN6_3                      0x52223328
#define FLASH_NF_BCH_GEN6_3_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen6_3        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN6_3_t;


#define FLASH_NF_BCH_GEN6_4                      0x5222332c
#define FLASH_NF_BCH_GEN6_4_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen6_4        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN6_4_t;


#define FLASH_NF_BCH_GEN6_5                      0x52223330
#define FLASH_NF_BCH_GEN6_5_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen6_5        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN6_5_t;


#define FLASH_NF_BCH_GEN6_6                      0x52223334
#define FLASH_NF_BCH_GEN6_6_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen6_6        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN6_6_t;


#define FLASH_NF_BCH_GEN6_7                      0x52223338
#define FLASH_NF_BCH_GEN6_7_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen6_7        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN6_7_t;


#define FLASH_NF_BCH_GEN6_8                      0x5222333c
#define FLASH_NF_BCH_GEN6_8_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen6_8        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN6_8_t;


#define FLASH_NF_BCH_GEN6_9                      0x52223340
#define FLASH_NF_BCH_GEN6_9_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen6_9        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN6_9_t;


#define FLASH_NF_BCH_GEN6_10                     0x52223344
#define FLASH_NF_BCH_GEN6_10_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen6_10       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN6_10_t;


#define FLASH_NF_BCH_GEN6_11                     0x52223348
#define FLASH_NF_BCH_GEN6_11_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen6_11       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN6_11_t;


#define FLASH_NF_BCH_GEN6_12                     0x5222334c
#define FLASH_NF_BCH_GEN6_12_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen6_12       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN6_12_t;


#define FLASH_NF_BCH_GEN6_13                     0x52223350
#define FLASH_NF_BCH_GEN6_13_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen6_13       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN6_13_t;


#define FLASH_NF_BCH_GEN6_14                     0x52223354
#define FLASH_NF_BCH_GEN6_14_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen6_14       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN6_14_t;


#define FLASH_NF_BCH_GEN6_15                     0x52223358
#define FLASH_NF_BCH_GEN6_15_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen6_15       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN6_15_t;


#define FLASH_NF_BCH_GEN6_16                     0x5222335c
#define FLASH_NF_BCH_GEN6_16_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen6_16       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN6_16_t;


#define FLASH_NF_BCH_GEN6_17                     0x52223360
#define FLASH_NF_BCH_GEN6_17_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen6_17       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN6_17_t;


#define FLASH_NF_BCH_GEN7_0                      0x52223364
#define FLASH_NF_BCH_GEN7_0_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen7_0        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN7_0_t;


#define FLASH_NF_BCH_GEN7_1                      0x52223368
#define FLASH_NF_BCH_GEN7_1_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen7_1        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN7_1_t;


#define FLASH_NF_BCH_GEN7_2                      0x5222336c
#define FLASH_NF_BCH_GEN7_2_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen7_2        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN7_2_t;


#define FLASH_NF_BCH_GEN7_3                      0x52223370
#define FLASH_NF_BCH_GEN7_3_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen7_3        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN7_3_t;


#define FLASH_NF_BCH_GEN7_4                      0x52223374
#define FLASH_NF_BCH_GEN7_4_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen7_4        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN7_4_t;


#define FLASH_NF_BCH_GEN7_5                      0x52223378
#define FLASH_NF_BCH_GEN7_5_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen7_5        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN7_5_t;


#define FLASH_NF_BCH_GEN7_6                      0x5222337c
#define FLASH_NF_BCH_GEN7_6_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen7_6        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN7_6_t;


#define FLASH_NF_BCH_GEN7_7                      0x52223380
#define FLASH_NF_BCH_GEN7_7_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen7_7        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN7_7_t;


#define FLASH_NF_BCH_GEN7_8                      0x52223384
#define FLASH_NF_BCH_GEN7_8_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen7_8        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN7_8_t;


#define FLASH_NF_BCH_GEN7_9                      0x52223388
#define FLASH_NF_BCH_GEN7_9_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen7_9        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN7_9_t;


#define FLASH_NF_BCH_GEN7_10                     0x5222338c
#define FLASH_NF_BCH_GEN7_10_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen7_10       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN7_10_t;


#define FLASH_NF_BCH_GEN7_11                     0x52223390
#define FLASH_NF_BCH_GEN7_11_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen7_11       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN7_11_t;


#define FLASH_NF_BCH_GEN7_12                     0x52223394
#define FLASH_NF_BCH_GEN7_12_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen7_12       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN7_12_t;


#define FLASH_NF_BCH_GEN7_13                     0x52223398
#define FLASH_NF_BCH_GEN7_13_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen7_13       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN7_13_t;


#define FLASH_NF_BCH_GEN7_14                     0x5222339c
#define FLASH_NF_BCH_GEN7_14_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen7_14       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN7_14_t;


#define FLASH_NF_BCH_GEN7_15                     0x522233a0
#define FLASH_NF_BCH_GEN7_15_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen7_15       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN7_15_t;


#define FLASH_NF_BCH_GEN7_16                     0x522233a4
#define FLASH_NF_BCH_GEN7_16_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen7_16       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN7_16_t;


#define FLASH_NF_BCH_GEN7_17                     0x522233a8
#define FLASH_NF_BCH_GEN7_17_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bchCodeGen7_17       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FLASH_NF_BCH_GEN7_17_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* FPGA_FLASH */
typedef struct {
  FLASH_ID_t                               ID;                            /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  FLASH_TIMEOUT_t                          TIMEOUT;                       /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  FLASH_STATUS_t                           STATUS;                        /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  FLASH_TYPE_t                             TYPE;                          /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  FLASH_FLASH_ACCESS_START_t               FLASH_ACCESS_START;            /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  FLASH_FLASH_INTERRUPT_t                  FLASH_INTERRUPT;               /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  FLASH_FLASH_MASK_t                       FLASH_MASK;                    /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  FLASH_FIFO_CONTROL_t                     FIFO_CONTROL;                  /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  FLASH_FIFO_STATUS_t                      FIFO_STATUS;                   /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  FLASH_FIFO_ADDRESS_t                     FIFO_ADDRESS;                  /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  FLASH_FIFO_MATCH_ADDRESS_t               FIFO_MATCH_ADDRESS;            /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  FLASH_FIFO_DATA_t                        FIFO_DATA;                     /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  FLASH_SF_ACCESS_t                        SF_ACCESS;                     /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  FLASH_SF_EXT_ACCESS_t                    SF_EXT_ACCESS;                 /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  FLASH_SF_ADDRESS_t                       SF_ADDRESS;                    /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  FLASH_SF_DATA_t                          SF_DATA;                       /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  FLASH_SF_TIMING_t                        SF_TIMING;                     /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[15];                  
  FLASH_PF_ACCESS_t                        PF_ACCESS;                     /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd18[3];                   
  FLASH_PF_TIMING_t                        PF_TIMING;                     /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd19[11];                  
  FLASH_NF_ACCESS_t                        NF_ACCESS;                     /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd20[3];                   
  FLASH_NF_COUNT_t                         NF_COUNT;                      /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd21[3];                   
  FLASH_NF_COMMAND_t                       NF_COMMAND;                    /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd22[3];                   
  FLASH_NF_ADDRESS_1_t                     NF_ADDRESS_1;                  /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd23[3];                   
  FLASH_NF_ADDRESS_2_t                     NF_ADDRESS_2;                  /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd24[3];                   
  FLASH_NF_DATA_t                          NF_DATA;                       /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd25[3];                   
  FLASH_NF_TIMING_t                        NF_TIMING;                     /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd26[3];                   
  FLASH_NF_ECC_STATUS_t                    NF_ECC_STATUS;                 /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd27[3];                   
  FLASH_NF_ECC_CONTROL_t                   NF_ECC_CONTROL;                /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd28[3];                   
  FLASH_NF_ECC_OOB_t                       NF_ECC_OOB;                    /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd29[3];                   
  FLASH_NF_ECC_GEN0_t                      NF_ECC_GEN0;                   /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd30[3];                   
  FLASH_NF_ECC_GEN1_t                      NF_ECC_GEN1;                   /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd31[3];                   
  FLASH_NF_ECC_GEN2_t                      NF_ECC_GEN2;                   /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd32[3];                   
  FLASH_NF_ECC_GEN3_t                      NF_ECC_GEN3;                   /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd33[3];                   
  FLASH_NF_ECC_GEN4_t                      NF_ECC_GEN4;                   /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd34[3];                   
  FLASH_NF_ECC_GEN5_t                      NF_ECC_GEN5;                   /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd35[3];                   
  FLASH_NF_ECC_GEN6_t                      NF_ECC_GEN6;                   /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd36[3];                   
  FLASH_NF_ECC_GEN7_t                      NF_ECC_GEN7;                   /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd37[3];                   
  FLASH_NF_ECC_GEN8_t                      NF_ECC_GEN8;                   /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd38[3];                   
  FLASH_NF_ECC_GEN9_t                      NF_ECC_GEN9;                   /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd39[3];                   
  FLASH_NF_ECC_GEN10_t                     NF_ECC_GEN10;                  /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd40[3];                   
  FLASH_NF_ECC_GEN11_t                     NF_ECC_GEN11;                  /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd41[3];                   
  FLASH_NF_ECC_GEN12_t                     NF_ECC_GEN12;                  /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd42[3];                   
  FLASH_NF_ECC_GEN13_t                     NF_ECC_GEN13;                  /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd43[3];                   
  FLASH_NF_ECC_GEN14_t                     NF_ECC_GEN14;                  /* addr: 0x000000c0 */
  ca_uint32_t                              rsrvd44[3];                   
  FLASH_NF_ECC_GEN15_t                     NF_ECC_GEN15;                  /* addr: 0x000000c4 */
  ca_uint32_t                              rsrvd45[3];                   
  FLASH_NF_ECC_RESET_t                     NF_ECC_RESET;                  /* addr: 0x000000c8 */
  ca_uint32_t                              rsrvd46[3];                   
  FLASH_NF_BCH_CONTROL_t                   NF_BCH_CONTROL;                /* addr: 0x000000cc */
  ca_uint32_t                              rsrvd47[3];                   
  FLASH_NF_BCH_STATUS_t                    NF_BCH_STATUS;                 /* addr: 0x000000d0 */
  ca_uint32_t                              rsrvd48[3];                   
  FLASH_NF_BCH_ERROR_LOC01_t               NF_BCH_ERROR_LOC01;            /* addr: 0x000000d4 */
  ca_uint32_t                              rsrvd49[3];                   
  FLASH_NF_BCH_ERROR_LOC23_t               NF_BCH_ERROR_LOC23;            /* addr: 0x000000d8 */
  ca_uint32_t                              rsrvd50[3];                   
  FLASH_NF_BCH_ERROR_LOC45_t               NF_BCH_ERROR_LOC45;            /* addr: 0x000000dc */
  ca_uint32_t                              rsrvd51[3];                   
  FLASH_NF_BCH_ERROR_LOC67_t               NF_BCH_ERROR_LOC67;            /* addr: 0x000000e0 */
  ca_uint32_t                              rsrvd52[3];                   
  FLASH_NF_BCH_ERROR_LOC89_t               NF_BCH_ERROR_LOC89;            /* addr: 0x000000e4 */
  ca_uint32_t                              rsrvd53[3];                   
  FLASH_NF_BCH_ERROR_LOC1011_t             NF_BCH_ERROR_LOC1011;          /* addr: 0x000000e8 */
  ca_uint32_t                              rsrvd54[3];                   
  FLASH_NF_BCH_ERROR_LOC1213_t             NF_BCH_ERROR_LOC1213;          /* addr: 0x000000ec */
  ca_uint32_t                              rsrvd55[3];                   
  FLASH_NF_BCH_ERROR_LOC1415_t             NF_BCH_ERROR_LOC1415;          /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd56[3];                   
  FLASH_NF_BCH_ERROR_LOC1617_t             NF_BCH_ERROR_LOC1617;          /* addr: 0x000000f4 */
  ca_uint32_t                              rsrvd57[3];                   
  FLASH_NF_BCH_ERROR_LOC1819_t             NF_BCH_ERROR_LOC1819;          /* addr: 0x000000f8 */
  ca_uint32_t                              rsrvd58[3];                   
  FLASH_NF_BCH_ERROR_LOC2021_t             NF_BCH_ERROR_LOC2021;          /* addr: 0x000000fc */
  ca_uint32_t                              rsrvd59[3];                   
  FLASH_NF_BCH_ERROR_LOC2223_t             NF_BCH_ERROR_LOC2223;          /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd60[3];                   
  FLASH_NF_BCH_ERROR_LOC2425_t             NF_BCH_ERROR_LOC2425;          /* addr: 0x00000104 */
  ca_uint32_t                              rsrvd61[3];                   
  FLASH_NF_BCH_ERROR_LOC2627_t             NF_BCH_ERROR_LOC2627;          /* addr: 0x00000108 */
  ca_uint32_t                              rsrvd62[3];                   
  FLASH_NF_BCH_ERROR_LOC2829_t             NF_BCH_ERROR_LOC2829;          /* addr: 0x0000010c */
  ca_uint32_t                              rsrvd63[3];                   
  FLASH_NF_BCH_ERROR_LOC3031_t             NF_BCH_ERROR_LOC3031;          /* addr: 0x00000110 */
  ca_uint32_t                              rsrvd64[3];                   
  FLASH_NF_BCH_ERROR_LOC3233_t             NF_BCH_ERROR_LOC3233;          /* addr: 0x00000114 */
  ca_uint32_t                              rsrvd65[3];                   
  FLASH_NF_BCH_ERROR_LOC3435_t             NF_BCH_ERROR_LOC3435;          /* addr: 0x00000118 */
  ca_uint32_t                              rsrvd66[3];                   
  FLASH_NF_BCH_ERROR_LOC3637_t             NF_BCH_ERROR_LOC3637;          /* addr: 0x0000011c */
  ca_uint32_t                              rsrvd67[3];                   
  FLASH_NF_BCH_ERROR_LOC3839_t             NF_BCH_ERROR_LOC3839;          /* addr: 0x00000120 */
  ca_uint32_t                              rsrvd68[3];                   
  FLASH_NF_BCH_OOB0_t                      NF_BCH_OOB0;                   /* addr: 0x00000124 */
  ca_uint32_t                              rsrvd69[3];                   
  FLASH_NF_BCH_OOB1_t                      NF_BCH_OOB1;                   /* addr: 0x00000128 */
  ca_uint32_t                              rsrvd70[3];                   
  FLASH_NF_BCH_OOB2_t                      NF_BCH_OOB2;                   /* addr: 0x0000012c */
  ca_uint32_t                              rsrvd71[3];                   
  FLASH_NF_BCH_OOB3_t                      NF_BCH_OOB3;                   /* addr: 0x00000130 */
  ca_uint32_t                              rsrvd72[3];                   
  FLASH_NF_BCH_OOB4_t                      NF_BCH_OOB4;                   /* addr: 0x00000134 */
  ca_uint32_t                              rsrvd73[3];                   
  FLASH_NF_BCH_OOB5_t                      NF_BCH_OOB5;                   /* addr: 0x00000138 */
  ca_uint32_t                              rsrvd74[3];                   
  FLASH_NF_BCH_OOB6_t                      NF_BCH_OOB6;                   /* addr: 0x0000013c */
  ca_uint32_t                              rsrvd75[3];                   
  FLASH_NF_BCH_OOB7_t                      NF_BCH_OOB7;                   /* addr: 0x00000140 */
  ca_uint32_t                              rsrvd76[3];                   
  FLASH_NF_BCH_OOB8_t                      NF_BCH_OOB8;                   /* addr: 0x00000144 */
  ca_uint32_t                              rsrvd77[3];                   
  FLASH_NF_BCH_OOB9_t                      NF_BCH_OOB9;                   /* addr: 0x00000148 */
  ca_uint32_t                              rsrvd78[3];                   
  FLASH_NF_BCH_OOB10_t                     NF_BCH_OOB10;                  /* addr: 0x0000014c */
  ca_uint32_t                              rsrvd79[3];                   
  FLASH_NF_BCH_OOB11_t                     NF_BCH_OOB11;                  /* addr: 0x00000150 */
  ca_uint32_t                              rsrvd80[3];                   
  FLASH_NF_BCH_OOB12_t                     NF_BCH_OOB12;                  /* addr: 0x00000154 */
  ca_uint32_t                              rsrvd81[3];                   
  FLASH_NF_BCH_OOB13_t                     NF_BCH_OOB13;                  /* addr: 0x00000158 */
  ca_uint32_t                              rsrvd82[3];                   
  FLASH_NF_BCH_OOB14_t                     NF_BCH_OOB14;                  /* addr: 0x0000015c */
  ca_uint32_t                              rsrvd83[3];                   
  FLASH_NF_BCH_OOB15_t                     NF_BCH_OOB15;                  /* addr: 0x00000160 */
  ca_uint32_t                              rsrvd84[3];                   
  FLASH_NF_BCH_OOB16_t                     NF_BCH_OOB16;                  /* addr: 0x00000164 */
  ca_uint32_t                              rsrvd85[3];                   
  FLASH_NF_BCH_OOB17_t                     NF_BCH_OOB17;                  /* addr: 0x00000168 */
  ca_uint32_t                              rsrvd86[3];                   
  FLASH_NF_BCH_GEN0_0_t                    NF_BCH_GEN0_0;                 /* addr: 0x0000016c */
  ca_uint32_t                              rsrvd87[3];                   
  FLASH_NF_BCH_GEN0_1_t                    NF_BCH_GEN0_1;                 /* addr: 0x00000170 */
  ca_uint32_t                              rsrvd88[3];                   
  FLASH_NF_BCH_GEN0_2_t                    NF_BCH_GEN0_2;                 /* addr: 0x00000174 */
  ca_uint32_t                              rsrvd89[3];                   
  FLASH_NF_BCH_GEN0_3_t                    NF_BCH_GEN0_3;                 /* addr: 0x00000178 */
  ca_uint32_t                              rsrvd90[3];                   
  FLASH_NF_BCH_GEN0_4_t                    NF_BCH_GEN0_4;                 /* addr: 0x0000017c */
  ca_uint32_t                              rsrvd91[3];                   
  FLASH_NF_BCH_GEN0_5_t                    NF_BCH_GEN0_5;                 /* addr: 0x00000180 */
  ca_uint32_t                              rsrvd92[3];                   
  FLASH_NF_BCH_GEN0_6_t                    NF_BCH_GEN0_6;                 /* addr: 0x00000184 */
  ca_uint32_t                              rsrvd93[3];                   
  FLASH_NF_BCH_GEN0_7_t                    NF_BCH_GEN0_7;                 /* addr: 0x00000188 */
  ca_uint32_t                              rsrvd94[3];                   
  FLASH_NF_BCH_GEN0_8_t                    NF_BCH_GEN0_8;                 /* addr: 0x0000018c */
  ca_uint32_t                              rsrvd95[3];                   
  FLASH_NF_BCH_GEN0_9_t                    NF_BCH_GEN0_9;                 /* addr: 0x00000190 */
  ca_uint32_t                              rsrvd96[3];                   
  FLASH_NF_BCH_GEN0_10_t                   NF_BCH_GEN0_10;                /* addr: 0x00000194 */
  ca_uint32_t                              rsrvd97[3];                   
  FLASH_NF_BCH_GEN0_11_t                   NF_BCH_GEN0_11;                /* addr: 0x00000198 */
  ca_uint32_t                              rsrvd98[3];                   
  FLASH_NF_BCH_GEN0_12_t                   NF_BCH_GEN0_12;                /* addr: 0x0000019c */
  ca_uint32_t                              rsrvd99[3];                   
  FLASH_NF_BCH_GEN0_13_t                   NF_BCH_GEN0_13;                /* addr: 0x000001a0 */
  ca_uint32_t                              rsrvd100[3];                  
  FLASH_NF_BCH_GEN0_14_t                   NF_BCH_GEN0_14;                /* addr: 0x000001a4 */
  ca_uint32_t                              rsrvd101[3];                  
  FLASH_NF_BCH_GEN0_15_t                   NF_BCH_GEN0_15;                /* addr: 0x000001a8 */
  ca_uint32_t                              rsrvd102[3];                  
  FLASH_NF_BCH_GEN0_16_t                   NF_BCH_GEN0_16;                /* addr: 0x000001ac */
  ca_uint32_t                              rsrvd103[3];                  
  FLASH_NF_BCH_GEN0_17_t                   NF_BCH_GEN0_17;                /* addr: 0x000001b0 */
  ca_uint32_t                              rsrvd104[3];                  
  FLASH_NF_BCH_GEN1_0_t                    NF_BCH_GEN1_0;                 /* addr: 0x000001b4 */
  ca_uint32_t                              rsrvd105[3];                  
  FLASH_NF_BCH_GEN1_1_t                    NF_BCH_GEN1_1;                 /* addr: 0x000001b8 */
  ca_uint32_t                              rsrvd106[3];                  
  FLASH_NF_BCH_GEN1_2_t                    NF_BCH_GEN1_2;                 /* addr: 0x000001bc */
  ca_uint32_t                              rsrvd107[3];                  
  FLASH_NF_BCH_GEN1_3_t                    NF_BCH_GEN1_3;                 /* addr: 0x000001c0 */
  ca_uint32_t                              rsrvd108[3];                  
  FLASH_NF_BCH_GEN1_4_t                    NF_BCH_GEN1_4;                 /* addr: 0x000001c4 */
  ca_uint32_t                              rsrvd109[3];                  
  FLASH_NF_BCH_GEN1_5_t                    NF_BCH_GEN1_5;                 /* addr: 0x000001c8 */
  ca_uint32_t                              rsrvd110[3];                  
  FLASH_NF_BCH_GEN1_6_t                    NF_BCH_GEN1_6;                 /* addr: 0x000001cc */
  ca_uint32_t                              rsrvd111[3];                  
  FLASH_NF_BCH_GEN1_7_t                    NF_BCH_GEN1_7;                 /* addr: 0x000001d0 */
  ca_uint32_t                              rsrvd112[3];                  
  FLASH_NF_BCH_GEN1_8_t                    NF_BCH_GEN1_8;                 /* addr: 0x000001d4 */
  ca_uint32_t                              rsrvd113[3];                  
  FLASH_NF_BCH_GEN1_9_t                    NF_BCH_GEN1_9;                 /* addr: 0x000001d8 */
  ca_uint32_t                              rsrvd114[3];                  
  FLASH_NF_BCH_GEN1_10_t                   NF_BCH_GEN1_10;                /* addr: 0x000001dc */
  ca_uint32_t                              rsrvd115[3];                  
  FLASH_NF_BCH_GEN1_11_t                   NF_BCH_GEN1_11;                /* addr: 0x000001e0 */
  ca_uint32_t                              rsrvd116[3];                  
  FLASH_NF_BCH_GEN1_12_t                   NF_BCH_GEN1_12;                /* addr: 0x000001e4 */
  ca_uint32_t                              rsrvd117[3];                  
  FLASH_NF_BCH_GEN1_13_t                   NF_BCH_GEN1_13;                /* addr: 0x000001e8 */
  ca_uint32_t                              rsrvd118[3];                  
  FLASH_NF_BCH_GEN1_14_t                   NF_BCH_GEN1_14;                /* addr: 0x000001ec */
  ca_uint32_t                              rsrvd119[3];                  
  FLASH_NF_BCH_GEN1_15_t                   NF_BCH_GEN1_15;                /* addr: 0x000001f0 */
  ca_uint32_t                              rsrvd120[3];                  
  FLASH_NF_BCH_GEN1_16_t                   NF_BCH_GEN1_16;                /* addr: 0x000001f4 */
  ca_uint32_t                              rsrvd121[3];                  
  FLASH_NF_BCH_GEN1_17_t                   NF_BCH_GEN1_17;                /* addr: 0x000001f8 */
  ca_uint32_t                              rsrvd122[3];                  
  FLASH_NF_BCH_GEN2_0_t                    NF_BCH_GEN2_0;                 /* addr: 0x000001fc */
  ca_uint32_t                              rsrvd123[3];                  
  FLASH_NF_BCH_GEN2_1_t                    NF_BCH_GEN2_1;                 /* addr: 0x00000200 */
  ca_uint32_t                              rsrvd124[3];                  
  FLASH_NF_BCH_GEN2_2_t                    NF_BCH_GEN2_2;                 /* addr: 0x00000204 */
  ca_uint32_t                              rsrvd125[3];                  
  FLASH_NF_BCH_GEN2_3_t                    NF_BCH_GEN2_3;                 /* addr: 0x00000208 */
  ca_uint32_t                              rsrvd126[3];                  
  FLASH_NF_BCH_GEN2_4_t                    NF_BCH_GEN2_4;                 /* addr: 0x0000020c */
  ca_uint32_t                              rsrvd127[3];                  
  FLASH_NF_BCH_GEN2_5_t                    NF_BCH_GEN2_5;                 /* addr: 0x00000210 */
  ca_uint32_t                              rsrvd128[3];                  
  FLASH_NF_BCH_GEN2_6_t                    NF_BCH_GEN2_6;                 /* addr: 0x00000214 */
  ca_uint32_t                              rsrvd129[3];                  
  FLASH_NF_BCH_GEN2_7_t                    NF_BCH_GEN2_7;                 /* addr: 0x00000218 */
  ca_uint32_t                              rsrvd130[3];                  
  FLASH_NF_BCH_GEN2_8_t                    NF_BCH_GEN2_8;                 /* addr: 0x0000021c */
  ca_uint32_t                              rsrvd131[3];                  
  FLASH_NF_BCH_GEN2_9_t                    NF_BCH_GEN2_9;                 /* addr: 0x00000220 */
  ca_uint32_t                              rsrvd132[3];                  
  FLASH_NF_BCH_GEN2_10_t                   NF_BCH_GEN2_10;                /* addr: 0x00000224 */
  ca_uint32_t                              rsrvd133[3];                  
  FLASH_NF_BCH_GEN2_11_t                   NF_BCH_GEN2_11;                /* addr: 0x00000228 */
  ca_uint32_t                              rsrvd134[3];                  
  FLASH_NF_BCH_GEN2_12_t                   NF_BCH_GEN2_12;                /* addr: 0x0000022c */
  ca_uint32_t                              rsrvd135[3];                  
  FLASH_NF_BCH_GEN2_13_t                   NF_BCH_GEN2_13;                /* addr: 0x00000230 */
  ca_uint32_t                              rsrvd136[3];                  
  FLASH_NF_BCH_GEN2_14_t                   NF_BCH_GEN2_14;                /* addr: 0x00000234 */
  ca_uint32_t                              rsrvd137[3];                  
  FLASH_NF_BCH_GEN2_15_t                   NF_BCH_GEN2_15;                /* addr: 0x00000238 */
  ca_uint32_t                              rsrvd138[3];                  
  FLASH_NF_BCH_GEN2_16_t                   NF_BCH_GEN2_16;                /* addr: 0x0000023c */
  ca_uint32_t                              rsrvd139[3];                  
  FLASH_NF_BCH_GEN2_17_t                   NF_BCH_GEN2_17;                /* addr: 0x00000240 */
  ca_uint32_t                              rsrvd140[3];                  
  FLASH_NF_BCH_GEN3_0_t                    NF_BCH_GEN3_0;                 /* addr: 0x00000244 */
  ca_uint32_t                              rsrvd141[3];                  
  FLASH_NF_BCH_GEN3_1_t                    NF_BCH_GEN3_1;                 /* addr: 0x00000248 */
  ca_uint32_t                              rsrvd142[3];                  
  FLASH_NF_BCH_GEN3_2_t                    NF_BCH_GEN3_2;                 /* addr: 0x0000024c */
  ca_uint32_t                              rsrvd143[3];                  
  FLASH_NF_BCH_GEN3_3_t                    NF_BCH_GEN3_3;                 /* addr: 0x00000250 */
  ca_uint32_t                              rsrvd144[3];                  
  FLASH_NF_BCH_GEN3_4_t                    NF_BCH_GEN3_4;                 /* addr: 0x00000254 */
  ca_uint32_t                              rsrvd145[3];                  
  FLASH_NF_BCH_GEN3_5_t                    NF_BCH_GEN3_5;                 /* addr: 0x00000258 */
  ca_uint32_t                              rsrvd146[3];                  
  FLASH_NF_BCH_GEN3_6_t                    NF_BCH_GEN3_6;                 /* addr: 0x0000025c */
  ca_uint32_t                              rsrvd147[3];                  
  FLASH_NF_BCH_GEN3_7_t                    NF_BCH_GEN3_7;                 /* addr: 0x00000260 */
  ca_uint32_t                              rsrvd148[3];                  
  FLASH_NF_BCH_GEN3_8_t                    NF_BCH_GEN3_8;                 /* addr: 0x00000264 */
  ca_uint32_t                              rsrvd149[3];                  
  FLASH_NF_BCH_GEN3_9_t                    NF_BCH_GEN3_9;                 /* addr: 0x00000268 */
  ca_uint32_t                              rsrvd150[3];                  
  FLASH_NF_BCH_GEN3_10_t                   NF_BCH_GEN3_10;                /* addr: 0x0000026c */
  ca_uint32_t                              rsrvd151[3];                  
  FLASH_NF_BCH_GEN3_11_t                   NF_BCH_GEN3_11;                /* addr: 0x00000270 */
  ca_uint32_t                              rsrvd152[3];                  
  FLASH_NF_BCH_GEN3_12_t                   NF_BCH_GEN3_12;                /* addr: 0x00000274 */
  ca_uint32_t                              rsrvd153[3];                  
  FLASH_NF_BCH_GEN3_13_t                   NF_BCH_GEN3_13;                /* addr: 0x00000278 */
  ca_uint32_t                              rsrvd154[3];                  
  FLASH_NF_BCH_GEN3_14_t                   NF_BCH_GEN3_14;                /* addr: 0x0000027c */
  ca_uint32_t                              rsrvd155[3];                  
  FLASH_NF_BCH_GEN3_15_t                   NF_BCH_GEN3_15;                /* addr: 0x00000280 */
  ca_uint32_t                              rsrvd156[3];                  
  FLASH_NF_BCH_GEN3_16_t                   NF_BCH_GEN3_16;                /* addr: 0x00000284 */
  ca_uint32_t                              rsrvd157[3];                  
  FLASH_NF_BCH_GEN3_17_t                   NF_BCH_GEN3_17;                /* addr: 0x00000288 */
  ca_uint32_t                              rsrvd158[3];                  
  FLASH_NF_BCH_GEN4_0_t                    NF_BCH_GEN4_0;                 /* addr: 0x0000028c */
  ca_uint32_t                              rsrvd159[3];                  
  FLASH_NF_BCH_GEN4_1_t                    NF_BCH_GEN4_1;                 /* addr: 0x00000290 */
  ca_uint32_t                              rsrvd160[3];                  
  FLASH_NF_BCH_GEN4_2_t                    NF_BCH_GEN4_2;                 /* addr: 0x00000294 */
  ca_uint32_t                              rsrvd161[3];                  
  FLASH_NF_BCH_GEN4_3_t                    NF_BCH_GEN4_3;                 /* addr: 0x00000298 */
  ca_uint32_t                              rsrvd162[3];                  
  FLASH_NF_BCH_GEN4_4_t                    NF_BCH_GEN4_4;                 /* addr: 0x0000029c */
  ca_uint32_t                              rsrvd163[3];                  
  FLASH_NF_BCH_GEN4_5_t                    NF_BCH_GEN4_5;                 /* addr: 0x000002a0 */
  ca_uint32_t                              rsrvd164[3];                  
  FLASH_NF_BCH_GEN4_6_t                    NF_BCH_GEN4_6;                 /* addr: 0x000002a4 */
  ca_uint32_t                              rsrvd165[3];                  
  FLASH_NF_BCH_GEN4_7_t                    NF_BCH_GEN4_7;                 /* addr: 0x000002a8 */
  ca_uint32_t                              rsrvd166[3];                  
  FLASH_NF_BCH_GEN4_8_t                    NF_BCH_GEN4_8;                 /* addr: 0x000002ac */
  ca_uint32_t                              rsrvd167[3];                  
  FLASH_NF_BCH_GEN4_9_t                    NF_BCH_GEN4_9;                 /* addr: 0x000002b0 */
  ca_uint32_t                              rsrvd168[3];                  
  FLASH_NF_BCH_GEN4_10_t                   NF_BCH_GEN4_10;                /* addr: 0x000002b4 */
  ca_uint32_t                              rsrvd169[3];                  
  FLASH_NF_BCH_GEN4_11_t                   NF_BCH_GEN4_11;                /* addr: 0x000002b8 */
  ca_uint32_t                              rsrvd170[3];                  
  FLASH_NF_BCH_GEN4_12_t                   NF_BCH_GEN4_12;                /* addr: 0x000002bc */
  ca_uint32_t                              rsrvd171[3];                  
  FLASH_NF_BCH_GEN4_13_t                   NF_BCH_GEN4_13;                /* addr: 0x000002c0 */
  ca_uint32_t                              rsrvd172[3];                  
  FLASH_NF_BCH_GEN4_14_t                   NF_BCH_GEN4_14;                /* addr: 0x000002c4 */
  ca_uint32_t                              rsrvd173[3];                  
  FLASH_NF_BCH_GEN4_15_t                   NF_BCH_GEN4_15;                /* addr: 0x000002c8 */
  ca_uint32_t                              rsrvd174[3];                  
  FLASH_NF_BCH_GEN4_16_t                   NF_BCH_GEN4_16;                /* addr: 0x000002cc */
  ca_uint32_t                              rsrvd175[3];                  
  FLASH_NF_BCH_GEN4_17_t                   NF_BCH_GEN4_17;                /* addr: 0x000002d0 */
  ca_uint32_t                              rsrvd176[3];                  
  FLASH_NF_BCH_GEN5_0_t                    NF_BCH_GEN5_0;                 /* addr: 0x000002d4 */
  ca_uint32_t                              rsrvd177[3];                  
  FLASH_NF_BCH_GEN5_1_t                    NF_BCH_GEN5_1;                 /* addr: 0x000002d8 */
  ca_uint32_t                              rsrvd178[3];                  
  FLASH_NF_BCH_GEN5_2_t                    NF_BCH_GEN5_2;                 /* addr: 0x000002dc */
  ca_uint32_t                              rsrvd179[3];                  
  FLASH_NF_BCH_GEN5_3_t                    NF_BCH_GEN5_3;                 /* addr: 0x000002e0 */
  ca_uint32_t                              rsrvd180[3];                  
  FLASH_NF_BCH_GEN5_4_t                    NF_BCH_GEN5_4;                 /* addr: 0x000002e4 */
  ca_uint32_t                              rsrvd181[3];                  
  FLASH_NF_BCH_GEN5_5_t                    NF_BCH_GEN5_5;                 /* addr: 0x000002e8 */
  ca_uint32_t                              rsrvd182[3];                  
  FLASH_NF_BCH_GEN5_6_t                    NF_BCH_GEN5_6;                 /* addr: 0x000002ec */
  ca_uint32_t                              rsrvd183[3];                  
  FLASH_NF_BCH_GEN5_7_t                    NF_BCH_GEN5_7;                 /* addr: 0x000002f0 */
  ca_uint32_t                              rsrvd184[3];                  
  FLASH_NF_BCH_GEN5_8_t                    NF_BCH_GEN5_8;                 /* addr: 0x000002f4 */
  ca_uint32_t                              rsrvd185[3];                  
  FLASH_NF_BCH_GEN5_9_t                    NF_BCH_GEN5_9;                 /* addr: 0x000002f8 */
  ca_uint32_t                              rsrvd186[3];                  
  FLASH_NF_BCH_GEN5_10_t                   NF_BCH_GEN5_10;                /* addr: 0x000002fc */
  ca_uint32_t                              rsrvd187[3];                  
  FLASH_NF_BCH_GEN5_11_t                   NF_BCH_GEN5_11;                /* addr: 0x00000300 */
  ca_uint32_t                              rsrvd188[3];                  
  FLASH_NF_BCH_GEN5_12_t                   NF_BCH_GEN5_12;                /* addr: 0x00000304 */
  ca_uint32_t                              rsrvd189[3];                  
  FLASH_NF_BCH_GEN5_13_t                   NF_BCH_GEN5_13;                /* addr: 0x00000308 */
  ca_uint32_t                              rsrvd190[3];                  
  FLASH_NF_BCH_GEN5_14_t                   NF_BCH_GEN5_14;                /* addr: 0x0000030c */
  ca_uint32_t                              rsrvd191[3];                  
  FLASH_NF_BCH_GEN5_15_t                   NF_BCH_GEN5_15;                /* addr: 0x00000310 */
  ca_uint32_t                              rsrvd192[3];                  
  FLASH_NF_BCH_GEN5_16_t                   NF_BCH_GEN5_16;                /* addr: 0x00000314 */
  ca_uint32_t                              rsrvd193[3];                  
  FLASH_NF_BCH_GEN5_17_t                   NF_BCH_GEN5_17;                /* addr: 0x00000318 */
  ca_uint32_t                              rsrvd194[3];                  
  FLASH_NF_BCH_GEN6_0_t                    NF_BCH_GEN6_0;                 /* addr: 0x0000031c */
  ca_uint32_t                              rsrvd195[3];                  
  FLASH_NF_BCH_GEN6_1_t                    NF_BCH_GEN6_1;                 /* addr: 0x00000320 */
  ca_uint32_t                              rsrvd196[3];                  
  FLASH_NF_BCH_GEN6_2_t                    NF_BCH_GEN6_2;                 /* addr: 0x00000324 */
  ca_uint32_t                              rsrvd197[3];                  
  FLASH_NF_BCH_GEN6_3_t                    NF_BCH_GEN6_3;                 /* addr: 0x00000328 */
  ca_uint32_t                              rsrvd198[3];                  
  FLASH_NF_BCH_GEN6_4_t                    NF_BCH_GEN6_4;                 /* addr: 0x0000032c */
  ca_uint32_t                              rsrvd199[3];                  
  FLASH_NF_BCH_GEN6_5_t                    NF_BCH_GEN6_5;                 /* addr: 0x00000330 */
  ca_uint32_t                              rsrvd200[3];                  
  FLASH_NF_BCH_GEN6_6_t                    NF_BCH_GEN6_6;                 /* addr: 0x00000334 */
  ca_uint32_t                              rsrvd201[3];                  
  FLASH_NF_BCH_GEN6_7_t                    NF_BCH_GEN6_7;                 /* addr: 0x00000338 */
  ca_uint32_t                              rsrvd202[3];                  
  FLASH_NF_BCH_GEN6_8_t                    NF_BCH_GEN6_8;                 /* addr: 0x0000033c */
  ca_uint32_t                              rsrvd203[3];                  
  FLASH_NF_BCH_GEN6_9_t                    NF_BCH_GEN6_9;                 /* addr: 0x00000340 */
  ca_uint32_t                              rsrvd204[3];                  
  FLASH_NF_BCH_GEN6_10_t                   NF_BCH_GEN6_10;                /* addr: 0x00000344 */
  ca_uint32_t                              rsrvd205[3];                  
  FLASH_NF_BCH_GEN6_11_t                   NF_BCH_GEN6_11;                /* addr: 0x00000348 */
  ca_uint32_t                              rsrvd206[3];                  
  FLASH_NF_BCH_GEN6_12_t                   NF_BCH_GEN6_12;                /* addr: 0x0000034c */
  ca_uint32_t                              rsrvd207[3];                  
  FLASH_NF_BCH_GEN6_13_t                   NF_BCH_GEN6_13;                /* addr: 0x00000350 */
  ca_uint32_t                              rsrvd208[3];                  
  FLASH_NF_BCH_GEN6_14_t                   NF_BCH_GEN6_14;                /* addr: 0x00000354 */
  ca_uint32_t                              rsrvd209[3];                  
  FLASH_NF_BCH_GEN6_15_t                   NF_BCH_GEN6_15;                /* addr: 0x00000358 */
  ca_uint32_t                              rsrvd210[3];                  
  FLASH_NF_BCH_GEN6_16_t                   NF_BCH_GEN6_16;                /* addr: 0x0000035c */
  ca_uint32_t                              rsrvd211[3];                  
  FLASH_NF_BCH_GEN6_17_t                   NF_BCH_GEN6_17;                /* addr: 0x00000360 */
  ca_uint32_t                              rsrvd212[3];                  
  FLASH_NF_BCH_GEN7_0_t                    NF_BCH_GEN7_0;                 /* addr: 0x00000364 */
  ca_uint32_t                              rsrvd213[3];                  
  FLASH_NF_BCH_GEN7_1_t                    NF_BCH_GEN7_1;                 /* addr: 0x00000368 */
  ca_uint32_t                              rsrvd214[3];                  
  FLASH_NF_BCH_GEN7_2_t                    NF_BCH_GEN7_2;                 /* addr: 0x0000036c */
  ca_uint32_t                              rsrvd215[3];                  
  FLASH_NF_BCH_GEN7_3_t                    NF_BCH_GEN7_3;                 /* addr: 0x00000370 */
  ca_uint32_t                              rsrvd216[3];                  
  FLASH_NF_BCH_GEN7_4_t                    NF_BCH_GEN7_4;                 /* addr: 0x00000374 */
  ca_uint32_t                              rsrvd217[3];                  
  FLASH_NF_BCH_GEN7_5_t                    NF_BCH_GEN7_5;                 /* addr: 0x00000378 */
  ca_uint32_t                              rsrvd218[3];                  
  FLASH_NF_BCH_GEN7_6_t                    NF_BCH_GEN7_6;                 /* addr: 0x0000037c */
  ca_uint32_t                              rsrvd219[3];                  
  FLASH_NF_BCH_GEN7_7_t                    NF_BCH_GEN7_7;                 /* addr: 0x00000380 */
  ca_uint32_t                              rsrvd220[3];                  
  FLASH_NF_BCH_GEN7_8_t                    NF_BCH_GEN7_8;                 /* addr: 0x00000384 */
  ca_uint32_t                              rsrvd221[3];                  
  FLASH_NF_BCH_GEN7_9_t                    NF_BCH_GEN7_9;                 /* addr: 0x00000388 */
  ca_uint32_t                              rsrvd222[3];                  
  FLASH_NF_BCH_GEN7_10_t                   NF_BCH_GEN7_10;                /* addr: 0x0000038c */
  ca_uint32_t                              rsrvd223[3];                  
  FLASH_NF_BCH_GEN7_11_t                   NF_BCH_GEN7_11;                /* addr: 0x00000390 */
  ca_uint32_t                              rsrvd224[3];                  
  FLASH_NF_BCH_GEN7_12_t                   NF_BCH_GEN7_12;                /* addr: 0x00000394 */
  ca_uint32_t                              rsrvd225[3];                  
  FLASH_NF_BCH_GEN7_13_t                   NF_BCH_GEN7_13;                /* addr: 0x00000398 */
  ca_uint32_t                              rsrvd226[3];                  
  FLASH_NF_BCH_GEN7_14_t                   NF_BCH_GEN7_14;                /* addr: 0x0000039c */
  ca_uint32_t                              rsrvd227[3];                  
  FLASH_NF_BCH_GEN7_15_t                   NF_BCH_GEN7_15;                /* addr: 0x000003a0 */
  ca_uint32_t                              rsrvd228[3];                  
  FLASH_NF_BCH_GEN7_16_t                   NF_BCH_GEN7_16;                /* addr: 0x000003a4 */
  ca_uint32_t                              rsrvd229[3];                  
  FLASH_NF_BCH_GEN7_17_t                   NF_BCH_GEN7_17;                /* addr: 0x000003a8 */
} APB4_FPGA_FLASH_t;


/*
 * FPGA_PER
 */
        
#define PER_SOFT_RESET                           0x52224000
#define PER_SOFT_RESET_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t soft_reset           :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_SOFT_RESET_t;


#define PER_PERIPHERAL_INTERRUPT_0               0x52224004
#define PER_PERIPHERAL_INTERRUPT_0_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t soft0i               :  1 ; /* bits 0:0 */
    ca_uint32_t soft1i               :  1 ; /* bits 1:1 */
    ca_uint32_t tmr1i                :  1 ; /* bits 2:2 */
    ca_uint32_t tmr2i                :  1 ; /* bits 3:3 */
    ca_uint32_t wdti                 :  1 ; /* bits 4:4 */
    ca_uint32_t spii                 :  1 ; /* bits 5:5 */
    ca_uint32_t gpio0i               :  1 ; /* bits 6:6 */
    ca_uint32_t gpio1i               :  1 ; /* bits 7:7 */
    ca_uint32_t gpio2i               :  1 ; /* bits 8:8 */
    ca_uint32_t gpio3i               :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t biwi                 :  1 ; /* bits 11:11 */
    ca_uint32_t mdioi                :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t cspii                :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd3               :  4 ;
    ca_uint32_t taroko_timer0i       :  1 ; /* bits 20:20 */
    ca_uint32_t taroko_timer1i       :  1 ; /* bits 21:21 */
    ca_uint32_t rsrvd4               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_PERIPHERAL_INTERRUPT_0_t;


#define PER_PERIPHERAL_INTENABLE_0               0x52224008
#define PER_PERIPHERAL_INTENABLE_0_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t soft0e               :  1 ; /* bits 0:0 */
    ca_uint32_t soft1e               :  1 ; /* bits 1:1 */
    ca_uint32_t tmr1e                :  1 ; /* bits 2:2 */
    ca_uint32_t tmr2e                :  1 ; /* bits 3:3 */
    ca_uint32_t wdte                 :  1 ; /* bits 4:4 */
    ca_uint32_t spie                 :  1 ; /* bits 5:5 */
    ca_uint32_t gpio0e               :  1 ; /* bits 6:6 */
    ca_uint32_t gpio1e               :  1 ; /* bits 7:7 */
    ca_uint32_t gpio2e               :  1 ; /* bits 8:8 */
    ca_uint32_t gpio3e               :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t biwe                 :  1 ; /* bits 11:11 */
    ca_uint32_t mdioe                :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t cspie                :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd3               :  4 ;
    ca_uint32_t taroko_timer0e       :  1 ; /* bits 20:20 */
    ca_uint32_t taroko_timer1e       :  1 ; /* bits 21:21 */
    ca_uint32_t rsrvd4               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_PERIPHERAL_INTENABLE_0_t;


#define PER_PERIPHERAL_INTERRUPT_1               0x5222400c
#define PER_PERIPHERAL_INTERRUPT_1_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t soft0i               :  1 ; /* bits 0:0 */
    ca_uint32_t soft1i               :  1 ; /* bits 1:1 */
    ca_uint32_t tmr1i                :  1 ; /* bits 2:2 */
    ca_uint32_t tmr2i                :  1 ; /* bits 3:3 */
    ca_uint32_t wdti                 :  1 ; /* bits 4:4 */
    ca_uint32_t spii                 :  1 ; /* bits 5:5 */
    ca_uint32_t gpio0i               :  1 ; /* bits 6:6 */
    ca_uint32_t gpio1i               :  1 ; /* bits 7:7 */
    ca_uint32_t gpio2i               :  1 ; /* bits 8:8 */
    ca_uint32_t gpio3i               :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t biwi                 :  1 ; /* bits 11:11 */
    ca_uint32_t mdioi                :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t cspii                :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd3               :  4 ;
    ca_uint32_t taroko_timer0i       :  1 ; /* bits 20:20 */
    ca_uint32_t taroko_timer1i       :  1 ; /* bits 21:21 */
    ca_uint32_t rsrvd4               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_PERIPHERAL_INTERRUPT_1_t;


#define PER_PERIPHERAL_INTENABLE_1               0x52224010
#define PER_PERIPHERAL_INTENABLE_1_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t soft0e               :  1 ; /* bits 0:0 */
    ca_uint32_t soft1e               :  1 ; /* bits 1:1 */
    ca_uint32_t tmr1e                :  1 ; /* bits 2:2 */
    ca_uint32_t tmr2e                :  1 ; /* bits 3:3 */
    ca_uint32_t wdte                 :  1 ; /* bits 4:4 */
    ca_uint32_t spie                 :  1 ; /* bits 5:5 */
    ca_uint32_t gpio0e               :  1 ; /* bits 6:6 */
    ca_uint32_t gpio1e               :  1 ; /* bits 7:7 */
    ca_uint32_t gpio2e               :  1 ; /* bits 8:8 */
    ca_uint32_t gpio3e               :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t biwe                 :  1 ; /* bits 11:11 */
    ca_uint32_t mdioe                :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t cspie                :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd3               :  4 ;
    ca_uint32_t taroko_timer0e       :  1 ; /* bits 20:20 */
    ca_uint32_t taroko_timer1e       :  1 ; /* bits 21:21 */
    ca_uint32_t rsrvd4               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_PERIPHERAL_INTENABLE_1_t;


#define PER_IRQ_SOFT1                            0x52224014
#define PER_IRQ_SOFT1_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t softiSet             :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_IRQ_SOFT1_t;


#define PER_IRQ_SOFT0                            0x52224018
#define PER_IRQ_SOFT0_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t softiSet             :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_IRQ_SOFT0_t;


#define PER_WDT_CTRL                             0x5222401c
#define PER_WDT_CTRL_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wdten                :  1 ; /* bits 0:0 */
    ca_uint32_t rsten                :  1 ; /* bits 1:1 */
    ca_uint32_t clksel               :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_WDT_CTRL_t;

#define     clksel_perdiv                                 0x0
#define     clksel_peronly                                0x1
#define     rsten_DIS                                     0x0
#define     rsten_ena                                     0x1
#define     wdten_DIS                                     0x0
#define     wdten_ENA                                     0x1

#define PER_WDT_PS                               0x52224020
#define PER_WDT_PS_dft                           0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t wdtps                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_WDT_PS_t;


#define PER_WDT_DIV                              0x52224024
#define PER_WDT_DIV_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t div_load             : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_WDT_DIV_t;


#define PER_WDT_LD                               0x52224028
#define PER_WDT_LD_dft                           0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t wdtld                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_WDT_LD_t;


#define PER_WDT_LOADE                            0x5222402c
#define PER_WDT_LOADE_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t update_wdt           :  1 ; /* bits 0:0 */
    ca_uint32_t update_pre           :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_WDT_LOADE_t;


#define PER_WDT_CNT                              0x52224030
#define PER_WDT_CNT_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wdtcount             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_WDT_CNT_t;


#define PER_WDT_IE_0                             0x52224034
#define PER_WDT_IE_0_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wdte                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_WDT_IE_0_t;


#define PER_WDT_INT_0                            0x52224038
#define PER_WDT_INT_0_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wdti                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_WDT_INT_0_t;


#define PER_WDT_STAT_0                           0x5222403c
#define PER_WDT_STAT_0_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wdts                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_WDT_STAT_0_t;


#define PER_WDT_IE_1                             0x52224040
#define PER_WDT_IE_1_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wdte                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_WDT_IE_1_t;


#define PER_WDT_INT_1                            0x52224044
#define PER_WDT_INT_1_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wdti                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_WDT_INT_1_t;


#define PER_WDT_STAT_1                           0x52224048
#define PER_WDT_STAT_1_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wdts                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_WDT_STAT_1_t;


#define PER_WDT_TST                              0x5222404c
#define PER_WDT_TST_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t testmode             :  1 ; /* bits 0:0 */
    ca_uint32_t testclken            :  1 ; /* bits 1:1 */
    ca_uint32_t testreset            :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_WDT_TST_t;


#define PER_TMR_LD1                              0x52224050
#define PER_TMR_LD1_dft                          0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t load1                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_TMR_LD1_t;


#define PER_TMR_CTRL1                            0x52224054
#define PER_TMR_CTRL1_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t clksel1              :  2 ; /* bits 3:2 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t rlmode1              :  1 ; /* bits 6:6 */
    ca_uint32_t timen1               :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd3               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_TMR_CTRL1_t;

#define     timen1_DIS                                    0x0
#define     timen1_ENA                                    0x1
#define     rlmode1_ROLL                                  0x0
#define     rlmode1_LOAD                                  0x1
#define     clksel1_direct                                0x0
#define     clksel1_dv64                                  0x1
#define     clksel1_dv1024                                0x2
#define     clksel1_dv4096                                0x3

#define PER_TMR_CNT1                             0x52224058
#define PER_TMR_CNT1_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t count1               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_TMR_CNT1_t;


#define PER_TMR_IE1_0                            0x5222405c
#define PER_TMR_IE1_0_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tmr1e                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_TMR_IE1_0_t;


#define PER_TMR_IE1_1                            0x52224060
#define PER_TMR_IE1_1_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tmr1e                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_TMR_IE1_1_t;


#define PER_TMR_INT1_0                           0x52224064
#define PER_TMR_INT1_0_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tmr1i                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_TMR_INT1_0_t;


#define PER_TMR_INT1_1                           0x52224068
#define PER_TMR_INT1_1_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tmr1i                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_TMR_INT1_1_t;


#define PER_TMR_STAT1                            0x5222406c
#define PER_TMR_STAT1_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tmr1s                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_TMR_STAT1_t;


#define PER_TMR_LD2                              0x52224070
#define PER_TMR_LD2_dft                          0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t load2                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_TMR_LD2_t;


#define PER_TMR_CTRL2                            0x52224074
#define PER_TMR_CTRL2_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t clksel2              :  2 ; /* bits 3:2 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t rlmode2              :  1 ; /* bits 6:6 */
    ca_uint32_t timen2               :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd3               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_TMR_CTRL2_t;

#define     timen2_DIS                                    0x0
#define     timen2_ENA                                    0x1
#define     rlmode2_ROLL                                  0x0
#define     rlmode2_LOAD                                  0x1
#define     clksel2_direct                                0x0
#define     clksel2_dv64                                  0x1
#define     clksel2_dv1024                                0x2
#define     clksel2_dv4096                                0x3

#define PER_TMR_CNT2                             0x52224078
#define PER_TMR_CNT2_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t count2               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_TMR_CNT2_t;


#define PER_TMR_IE2_0                            0x5222407c
#define PER_TMR_IE2_0_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tmr1e                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_TMR_IE2_0_t;


#define PER_TMR_IE2_1                            0x52224080
#define PER_TMR_IE2_1_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tmr1e                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_TMR_IE2_1_t;


#define PER_TMR_INT2_0                           0x52224084
#define PER_TMR_INT2_0_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tmr1i                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_TMR_INT2_0_t;


#define PER_TMR_INT2_1                           0x52224088
#define PER_TMR_INT2_1_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tmr1i                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_TMR_INT2_1_t;


#define PER_TMR_STAT2                            0x5222408c
#define PER_TMR_STAT2_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tmr2s                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_TMR_STAT2_t;


#define PER_TMR_LOADE                            0x52224090
#define PER_TMR_LOADE_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t update_tmr1          :  1 ; /* bits 1:1 */
    ca_uint32_t update_tmr2          :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd2               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_TMR_LOADE_t;


#define PER_TMR_TST                              0x52224094
#define PER_TMR_TST_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t testclksel           :  1 ; /* bits 0:0 */
    ca_uint32_t test1                :  1 ; /* bits 1:1 */
    ca_uint32_t test2                :  1 ; /* bits 2:2 */
    ca_uint32_t pps_timer1_en        :  1 ; /* bits 3:3 */
    ca_uint32_t pps_timer2_en        :  1 ; /* bits 4:4 */
    ca_uint32_t pps_from_timer       :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_TMR_TST_t;


#define PER_SPI_CLK                              0x52224098
#define PER_SPI_CLK_dft                          0x00000002

typedef volatile union {
  struct {
    ca_uint32_t counter_load         : 16 ; /* bits 15:0 */
    ca_uint32_t ssp_igap             :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_SPI_CLK_t;


#define PER_SPI_CFG                              0x5222409c
#define PER_SPI_CFG_dft                          0x3f090000

typedef volatile union {
  struct {
    ca_uint32_t command_cyc          :  1 ; /* bits 0:0 */
    ca_uint32_t read_write           :  1 ; /* bits 1:1 */
    ca_uint32_t micro_wire_cs_sel    :  5 ; /* bits 6:2 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t sel_ssp_cs           :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t ssp_cmd_cnt          :  7 ; /* bits 22:16 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t pre_ssp_dat_cnt      :  6 ; /* bits 29:24 */
    ca_uint32_t sspcs_en3_gpio       :  1 ; /* bits 30:30 */
    ca_uint32_t sspcs_en4_gpio       :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_SPI_CFG_t;

#define     micro_wire_cs_sel_SPI                         0x0
#define     micro_wire_cs_sel_MWR                         0x1
#define     read_write_WR                                 0x0
#define     read_write_RD                                 0x1
#define     command_cyc_NORM                              0x0
#define     command_cyc_CONLY                             0x1

#define PER_SPI_MODE                             0x522240a0
#define PER_SPI_MODE_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cfg                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_SPI_MODE_t;


#define PER_SPI_CTRL                             0x522240a4
#define PER_SPI_CTRL_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sspdone              :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  6 ;
    ca_uint32_t sspstart             :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd2               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_SPI_CTRL_t;


#define PER_SPI_CA0                              0x522240a8
#define PER_SPI_CA0_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ssp_cmd_addr0        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_SPI_CA0_t;


#define PER_SPI_CA1                              0x522240ac
#define PER_SPI_CA1_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ssp_cmd_addr1        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_SPI_CA1_t;


#define PER_SPI_CA2                              0x522240b0
#define PER_SPI_CA2_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ssp_cmd_addr2        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_SPI_CA2_t;


#define PER_SPI_WDAT1                            0x522240b4
#define PER_SPI_WDAT1_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ssp_wdata1           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_SPI_WDAT1_t;


#define PER_SPI_WDAT0                            0x522240b8
#define PER_SPI_WDAT0_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ssp_wdata0           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_SPI_WDAT0_t;


#define PER_SPI_RDAT1                            0x522240bc
#define PER_SPI_RDAT1_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ssp_rdata1           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_SPI_RDAT1_t;


#define PER_SPI_RDAT0                            0x522240c0
#define PER_SPI_RDAT0_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ssp_rdata0           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_SPI_RDAT0_t;


#define PER_SPI_IE_0                             0x522240c4
#define PER_SPI_IE_0_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t spie                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_SPI_IE_0_t;


#define PER_SPI_INT_0                            0x522240c8
#define PER_SPI_INT_0_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sspi                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_SPI_INT_0_t;


#define PER_SPI_IE_1                             0x522240cc
#define PER_SPI_IE_1_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t spie                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_SPI_IE_1_t;


#define PER_SPI_INT_1                            0x522240d0
#define PER_SPI_INT_1_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sspi                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_SPI_INT_1_t;


#define PER_SPI_STAT                             0x522240d4
#define PER_SPI_STAT_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ssps                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_SPI_STAT_t;


#define PER_MDIO_CFG                             0x522240d8
#define PER_MDIO_CFG_dft                         0x10000001

typedef volatile union {
  struct {
    ca_uint32_t mdio_manual          :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 15 ;
    ca_uint32_t mdio_pre_scale       : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_MDIO_CFG_t;

#define     mdio_manual_AUTO                              0x0
#define     mdio_manual_MAN                               0x1

#define PER_MDIO_ADDR                            0x522240dc
#define PER_MDIO_ADDR_dft                        0x00080000

typedef volatile union {
  struct {
    ca_uint32_t mdio_addr            :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t mdio_offset          :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t mdio_rd_wr           :  1 ; /* bits 15:15 */
    ca_uint32_t mdio_st              :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t mdio_op              :  2 ; /* bits 19:18 */
    ca_uint32_t rsrvd4               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_MDIO_ADDR_t;

#define     mdio_op_ADDR_WR                               0x0
#define     mdio_op_WR                                    0x1
#define     mdio_op_RD_INC                                0x2
#define     mdio_op_RD                                    0x3
#define     mdio_st_Direct                                0x0
#define     mdio_st_Indirect                              0x1
#define     mdio_rd_wr_WR                                 0x0
#define     mdio_rd_wr_RD                                 0x1
#define     mdio_addr_NORM                                0x0
#define     mdio_addr_CONLY                               0x1

#define PER_MDIO_WRDATA                          0x522240e0
#define PER_MDIO_WRDATA_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mdio_wrdata          : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_MDIO_WRDATA_t;


#define PER_MDIO_RDDATA                          0x522240e4
#define PER_MDIO_RDDATA_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mdio_rddata          : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_MDIO_RDDATA_t;


#define PER_MDIO_CTRL                            0x522240e8
#define PER_MDIO_CTRL_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mdiodone             :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  6 ;
    ca_uint32_t mdiostart            :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd2               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_MDIO_CTRL_t;


#define PER_MDIO_AUTO_CFG                        0x522240ec
#define PER_MDIO_AUTO_CFG_dft                    0x00001f00

typedef volatile union {
  struct {
    ca_uint32_t auto_mdio_phy_start_idx :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t auto_mdio_phy_end_idx :  6 ; /* bits 13:8 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t auto_mdio_gpio       :  1 ; /* bits 15:15 */
    ca_uint32_t auto_mdio_reg_to_read :  5 ; /* bits 20:16 */
    ca_uint32_t rsrvd3               : 11 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_MDIO_AUTO_CFG_t;

#define     auto_mdio_gpio_32                             0x0
#define     auto_mdio_gpio_64                             0x1

#define PER_MDIO_AUTO_INTV                       0x522240f0
#define PER_MDIO_AUTO_INTV_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t poll_wait_cycles     : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_MDIO_AUTO_INTV_t;


#define PER_MDIO_AUTO_RM                         0x522240f4
#define PER_MDIO_AUTO_RM_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t auto_mdio_bit_invert : 16 ; /* bits 15:0 */
    ca_uint32_t auto_mdio_bit_mask   : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_MDIO_AUTO_RM_t;

#define     auto_mdio_bit_mask_UNMASKED                   0x0
#define     auto_mdio_bit_mask_MASKED                     0x1
#define     auto_mdio_bit_invert_NONINV                   0x0
#define     auto_mdio_bit_invert_INV                      0x1

#define PER_MDIO_AUTO_AADDR                      0x522240f8
#define PER_MDIO_AUTO_AADDR_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t auto_mdio_phy_alert_addr :  5 ; /* bits 4:0 */
    ca_uint32_t auto_mdio_phy_alert_range :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               : 10 ;
    ca_uint32_t auto_mdio_rddata     : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_MDIO_AUTO_AADDR_t;

#define     auto_mdio_phy_alert_range_low                 0x0
#define     auto_mdio_phy_alert_range_hi                  0x1

#define PER_MDIO_ENTAB0                          0x522240fc
#define PER_MDIO_ENTAB0_dft                      0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t slot_enable0         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_MDIO_ENTAB0_t;


#define PER_MDIO_ENTAB1                          0x52224100
#define PER_MDIO_ENTAB1_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t slot_enable1         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_MDIO_ENTAB1_t;


#define PER_MDIO_ITAB0                           0x52224104
#define PER_MDIO_ITAB0_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t i                    : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_MDIO_ITAB0_t;


#define PER_MDIO_ITAB1                           0x52224108
#define PER_MDIO_ITAB1_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t i                    : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_MDIO_ITAB1_t;


#define PER_MDIO_IE_0                            0x5222410c
#define PER_MDIO_IE_0_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mdioe                :  1 ; /* bits 0:0 */
    ca_uint32_t autopolle            :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_MDIO_IE_0_t;


#define PER_MDIO_INT_0                           0x52224110
#define PER_MDIO_INT_0_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mdioi                :  1 ; /* bits 0:0 */
    ca_uint32_t autopolli            :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_MDIO_INT_0_t;


#define PER_MDIO_IE_1                            0x52224114
#define PER_MDIO_IE_1_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mdioe                :  1 ; /* bits 0:0 */
    ca_uint32_t autopolle            :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_MDIO_IE_1_t;


#define PER_MDIO_INT_1                           0x52224118
#define PER_MDIO_INT_1_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mdioi                :  1 ; /* bits 0:0 */
    ca_uint32_t autopolli            :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_MDIO_INT_1_t;


#define PER_MDIO_STAT                            0x5222411c
#define PER_MDIO_STAT_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mdios                :  1 ; /* bits 0:0 */
    ca_uint32_t autopolls            :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_MDIO_STAT_t;


#define PER_BIW_CFG                              0x52224120
#define PER_BIW_CFG_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t core_en              :  1 ; /* bits 0:0 */
    ca_uint32_t biw_soft_reset       :  1 ; /* bits 1:1 */
    ca_uint32_t busywait_en          :  1 ; /* bits 2:2 */
    ca_uint32_t stretch_en           :  1 ; /* bits 3:3 */
    ca_uint32_t arb_en               :  1 ; /* bits 4:4 */
    ca_uint32_t clksync_en           :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t spike_cnt            :  4 ; /* bits 11:8 */
    ca_uint32_t rsrvd2               :  4 ;
    ca_uint32_t prer                 : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_BIW_CFG_t;

#define     core_en_DIS                                   0x0
#define     core_en_ENA                                   0x1

#define PER_BIW_CTRL                             0x52224124
#define PER_BIW_CTRL_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t biwdone              :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t ack_in               :  1 ; /* bits 3:3 */
    ca_uint32_t write                :  1 ; /* bits 4:4 */
    ca_uint32_t read                 :  1 ; /* bits 5:5 */
    ca_uint32_t stop                 :  1 ; /* bits 6:6 */
    ca_uint32_t start                :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd2               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_BIW_CTRL_t;


#define PER_BIW_TXR                              0x52224128
#define PER_BIW_TXR_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t txr                  :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_BIW_TXR_t;


#define PER_BIW_RXR                              0x5222412c
#define PER_BIW_RXR_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rxr                  :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_BIW_RXR_t;


#define PER_BIW_ACK                              0x52224130
#define PER_BIW_ACK_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t al                   :  1 ; /* bits 0:0 */
    ca_uint32_t biw_busy             :  1 ; /* bits 1:1 */
    ca_uint32_t ack_out              :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_BIW_ACK_t;

#define     biw_busy_FREE                                 0x0
#define     biw_busy_BUSY                                 0x1
#define     al_OK                                         0x0
#define     al_LOST                                       0x1

#define PER_BIW_IE_0                             0x52224134
#define PER_BIW_IE_0_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t biwe                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_BIW_IE_0_t;


#define PER_BIW_INT_0                            0x52224138
#define PER_BIW_INT_0_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t biwi                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_BIW_INT_0_t;


#define PER_BIW_IE_1                             0x5222413c
#define PER_BIW_IE_1_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t biwe                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_BIW_IE_1_t;


#define PER_BIW_INT_1                            0x52224140
#define PER_BIW_INT_1_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t biwi                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_BIW_INT_1_t;


#define PER_BIW_STAT                             0x52224144
#define PER_BIW_STAT_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t biws                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_BIW_STAT_t;


#define PER_UART0_CFG                            0x52224148
#define PER_UART0_CFG_dft                        0x00000003

typedef volatile union {
  struct {
    ca_uint32_t char_cnt             :  2 ; /* bits 1:0 */
    ca_uint32_t uart_stop_2bit       :  1 ; /* bits 2:2 */
    ca_uint32_t even_parity_sel      :  1 ; /* bits 3:3 */
    ca_uint32_t uart_parity_en       :  1 ; /* bits 4:4 */
    ca_uint32_t tx_sm_enable         :  1 ; /* bits 5:5 */
    ca_uint32_t rx_sm_enable         :  1 ; /* bits 6:6 */
    ca_uint32_t uart_en              :  1 ; /* bits 7:7 */
    ca_uint32_t baud_count           : 24 ; /* bits 31:8 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART0_CFG_t;

#define     uart_en_DIS                                   0x0
#define     uart_en_ENA                                   0x1
#define     rx_sm_enable_DIS                              0x0
#define     rx_sm_enable_ENA                              0x1
#define     tx_sm_enable_DIS                              0x0
#define     tx_sm_enable_ENA                              0x1
#define     uart_parity_en_DIS                            0x0
#define     uart_parity_en_ENA                            0x1
#define     even_parity_sel_ODD                           0x0
#define     even_parity_sel_EvEN                          0x1
#define     uart_stop_2bit_1                              0x0
#define     uart_stop_2bit_2                              0x1
#define     char_cnt_5                                    0x0
#define     char_cnt_6                                    0x1
#define     char_cnt_7                                    0x2
#define     char_cnt_8                                    0x3

#define PER_UART0_FC                             0x5222414c
#define PER_UART0_FC_dft                         0x00000588

typedef volatile union {
  struct {
    ca_uint32_t rx_wm                :  6 ; /* bits 5:0 */
    ca_uint32_t inv_cts              :  1 ; /* bits 6:6 */
    ca_uint32_t no_cts               :  1 ; /* bits 7:7 */
    ca_uint32_t cts_reg              :  1 ; /* bits 8:8 */
    ca_uint32_t inv_rts              :  1 ; /* bits 9:9 */
    ca_uint32_t no_rts               :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd1               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART0_FC_t;

#define     no_rts_ENA                                    0x0
#define     no_rts_DIS                                    0x1
#define     inv_rts_POS                                   0x0
#define     inv_rts_NEG                                   0x1
#define     no_cts_ENA                                    0x0
#define     no_cts_DIS                                    0x1
#define     inv_cts_POS                                   0x0
#define     inv_cts_NEG                                   0x1

#define PER_UART0_RX_SAMPLE                      0x52224150
#define PER_UART0_RX_SAMPLE_dft                  0x0000000f

typedef volatile union {
  struct {
    ca_uint32_t rx_center            : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART0_RX_SAMPLE_t;


#define PER_UART0_TUN                            0x52224154
#define PER_UART0_TUN_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_fine_tune_ctl     :  8 ; /* bits 7:0 */
    ca_uint32_t rx_tune_add          :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t tx_fine_tune_ctl     :  8 ; /* bits 23:16 */
    ca_uint32_t tx_tune_add          :  1 ; /* bits 24:24 */
    ca_uint32_t rsrvd2               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART0_TUN_t;

#define     tx_tune_add_FASTER                            0x0
#define     tx_tune_add_SLOWER                            0x1
#define     rx_tune_add_FASTER                            0x0
#define     rx_tune_add_SLOWER                            0x1

#define PER_UART0_TXDAT                          0x52224158
#define PER_UART0_TXDAT_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_data              :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART0_TXDAT_t;


#define PER_UART0_RXDAT                          0x5222415c
#define PER_UART0_RXDAT_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_data_lat          :  8 ; /* bits 7:0 */
    ca_uint32_t rx_data_vld          :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART0_RXDAT_t;


#define PER_UART0_INFO                           0x52224160
#define PER_UART0_INFO_dft                       0x0000000a

typedef volatile union {
  struct {
    ca_uint32_t rx_fifo_full         :  1 ; /* bits 0:0 */
    ca_uint32_t rx_fifo_empty        :  1 ; /* bits 1:1 */
    ca_uint32_t tx_fifo_full         :  1 ; /* bits 2:2 */
    ca_uint32_t tx_fifo_empty        :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART0_INFO_t;


#define PER_UART0_IE_0                           0x52224164
#define PER_UART0_IE_0_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overrune     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_erre         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_erre       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overrune     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underrune    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptye       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptye    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART0_IE_0_t;


#define PER_UART0_IE_1                           0x52224168
#define PER_UART0_IE_1_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overrune     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_erre         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_erre       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overrune     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underrune    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptye       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptye    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART0_IE_1_t;


#define PER_UART0_INT_0                          0x5222416c
#define PER_UART0_INT_0_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overruni     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_erri         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_erri       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overruni     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underruni    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptyi       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptyi    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART0_INT_0_t;


#define PER_UART0_INT_1                          0x52224170
#define PER_UART0_INT_1_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overruni     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_erri         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_erri       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overruni     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underruni    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptyi       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptyi    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART0_INT_1_t;


#define PER_UART0_STAT                           0x52224174
#define PER_UART0_STAT_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overruns     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_errs         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_errs       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overruns     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underruns    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptys       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptys    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART0_STAT_t;


#define PER_UART1_CFG                            0x52224178
#define PER_UART1_CFG_dft                        0x00000003

typedef volatile union {
  struct {
    ca_uint32_t char_cnt             :  2 ; /* bits 1:0 */
    ca_uint32_t uart_stop_2bit       :  1 ; /* bits 2:2 */
    ca_uint32_t even_parity_sel      :  1 ; /* bits 3:3 */
    ca_uint32_t uart_parity_en       :  1 ; /* bits 4:4 */
    ca_uint32_t tx_sm_enable         :  1 ; /* bits 5:5 */
    ca_uint32_t rx_sm_enable         :  1 ; /* bits 6:6 */
    ca_uint32_t uart_en              :  1 ; /* bits 7:7 */
    ca_uint32_t baud_count           : 24 ; /* bits 31:8 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART1_CFG_t;


#define PER_UART1_FC                             0x5222417c
#define PER_UART1_FC_dft                         0x00000588

typedef volatile union {
  struct {
    ca_uint32_t rx_wm                :  6 ; /* bits 5:0 */
    ca_uint32_t inv_cts              :  1 ; /* bits 6:6 */
    ca_uint32_t no_cts               :  1 ; /* bits 7:7 */
    ca_uint32_t cts_reg              :  1 ; /* bits 8:8 */
    ca_uint32_t inv_rts              :  1 ; /* bits 9:9 */
    ca_uint32_t no_rts               :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd1               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART1_FC_t;


#define PER_UART1_RX_SAMPLE                      0x52224180
#define PER_UART1_RX_SAMPLE_dft                  0x0000000f

typedef volatile union {
  struct {
    ca_uint32_t rx_center            : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART1_RX_SAMPLE_t;


#define PER_UART1_TUN                            0x52224184
#define PER_UART1_TUN_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_fine_tune_ctl     :  8 ; /* bits 7:0 */
    ca_uint32_t rx_tune_add          :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t tx_fine_tune_ctl     :  8 ; /* bits 23:16 */
    ca_uint32_t tx_tune_add          :  1 ; /* bits 24:24 */
    ca_uint32_t rsrvd2               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART1_TUN_t;


#define PER_UART1_TXDAT                          0x52224188
#define PER_UART1_TXDAT_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_data              :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART1_TXDAT_t;


#define PER_UART1_RXDAT                          0x5222418c
#define PER_UART1_RXDAT_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_data_lat          :  8 ; /* bits 7:0 */
    ca_uint32_t rx_data_vld          :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART1_RXDAT_t;


#define PER_UART1_INFO                           0x52224190
#define PER_UART1_INFO_dft                       0x0000000a

typedef volatile union {
  struct {
    ca_uint32_t rx_fifo_full         :  1 ; /* bits 0:0 */
    ca_uint32_t rx_fifo_empty        :  1 ; /* bits 1:1 */
    ca_uint32_t tx_fifo_full         :  1 ; /* bits 2:2 */
    ca_uint32_t tx_fifo_empty        :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART1_INFO_t;


#define PER_UART1_IE_0                           0x52224194
#define PER_UART1_IE_0_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overrune     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_erre         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_erre       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overrune     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underrune    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptye       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptye    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART1_IE_0_t;


#define PER_UART1_IE_1                           0x52224198
#define PER_UART1_IE_1_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overrune     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_erre         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_erre       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overrune     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underrune    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptye       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptye    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART1_IE_1_t;


#define PER_UART1_INT_0                          0x5222419c
#define PER_UART1_INT_0_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overruni     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_erri         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_erri       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overruni     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underruni    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptyi       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptyi    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART1_INT_0_t;


#define PER_UART1_INT_1                          0x522241a0
#define PER_UART1_INT_1_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overruni     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_erri         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_erri       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overruni     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underruni    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptyi       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptyi    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART1_INT_1_t;


#define PER_UART1_STAT                           0x522241a4
#define PER_UART1_STAT_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overruns     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_errs         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_errs       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overruns     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underruns    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptys       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptys    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART1_STAT_t;


#define PER_UART2_CFG                            0x522241a8
#define PER_UART2_CFG_dft                        0x00000003

typedef volatile union {
  struct {
    ca_uint32_t char_cnt             :  2 ; /* bits 1:0 */
    ca_uint32_t uart_stop_2bit       :  1 ; /* bits 2:2 */
    ca_uint32_t even_parity_sel      :  1 ; /* bits 3:3 */
    ca_uint32_t uart_parity_en       :  1 ; /* bits 4:4 */
    ca_uint32_t tx_sm_enable         :  1 ; /* bits 5:5 */
    ca_uint32_t rx_sm_enable         :  1 ; /* bits 6:6 */
    ca_uint32_t uart_en              :  1 ; /* bits 7:7 */
    ca_uint32_t baud_count           : 24 ; /* bits 31:8 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART2_CFG_t;


#define PER_UART2_FC                             0x522241ac
#define PER_UART2_FC_dft                         0x00000588

typedef volatile union {
  struct {
    ca_uint32_t rx_wm                :  6 ; /* bits 5:0 */
    ca_uint32_t inv_cts              :  1 ; /* bits 6:6 */
    ca_uint32_t no_cts               :  1 ; /* bits 7:7 */
    ca_uint32_t cts_reg              :  1 ; /* bits 8:8 */
    ca_uint32_t inv_rts              :  1 ; /* bits 9:9 */
    ca_uint32_t no_rts               :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd1               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART2_FC_t;


#define PER_UART2_RX_SAMPLE                      0x522241b0
#define PER_UART2_RX_SAMPLE_dft                  0x0000000f

typedef volatile union {
  struct {
    ca_uint32_t rx_center            : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART2_RX_SAMPLE_t;


#define PER_UART2_TUN                            0x522241b4
#define PER_UART2_TUN_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_fine_tune_ctl     :  8 ; /* bits 7:0 */
    ca_uint32_t rx_tune_add          :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t tx_fine_tune_ctl     :  8 ; /* bits 23:16 */
    ca_uint32_t tx_tune_add          :  1 ; /* bits 24:24 */
    ca_uint32_t rsrvd2               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART2_TUN_t;


#define PER_UART2_TXDAT                          0x522241b8
#define PER_UART2_TXDAT_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_data              :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART2_TXDAT_t;


#define PER_UART2_RXDAT                          0x522241bc
#define PER_UART2_RXDAT_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_data_lat          :  8 ; /* bits 7:0 */
    ca_uint32_t rx_data_vld          :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART2_RXDAT_t;


#define PER_UART2_INFO                           0x522241c0
#define PER_UART2_INFO_dft                       0x0000000a

typedef volatile union {
  struct {
    ca_uint32_t rx_fifo_full         :  1 ; /* bits 0:0 */
    ca_uint32_t rx_fifo_empty        :  1 ; /* bits 1:1 */
    ca_uint32_t tx_fifo_full         :  1 ; /* bits 2:2 */
    ca_uint32_t tx_fifo_empty        :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART2_INFO_t;


#define PER_UART2_IE_0                           0x522241c4
#define PER_UART2_IE_0_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overrune     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_erre         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_erre       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overrune     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underrune    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptye       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptye    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART2_IE_0_t;


#define PER_UART2_IE_1                           0x522241c8
#define PER_UART2_IE_1_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overrune     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_erre         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_erre       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overrune     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underrune    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptye       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptye    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART2_IE_1_t;


#define PER_UART2_INT_0                          0x522241cc
#define PER_UART2_INT_0_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overruni     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_erri         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_erri       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overruni     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underruni    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptyi       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptyi    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART2_INT_0_t;


#define PER_UART2_INT_1                          0x522241d0
#define PER_UART2_INT_1_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overruni     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_erri         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_erri       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overruni     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underruni    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptyi       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptyi    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART2_INT_1_t;


#define PER_UART2_STAT                           0x522241d4
#define PER_UART2_STAT_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overruns     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_errs         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_errs       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overruns     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underruns    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptys       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptys    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART2_STAT_t;


#define PER_UART3_CFG                            0x522241d8
#define PER_UART3_CFG_dft                        0x00000003

typedef volatile union {
  struct {
    ca_uint32_t char_cnt             :  2 ; /* bits 1:0 */
    ca_uint32_t uart_stop_2bit       :  1 ; /* bits 2:2 */
    ca_uint32_t even_parity_sel      :  1 ; /* bits 3:3 */
    ca_uint32_t uart_parity_en       :  1 ; /* bits 4:4 */
    ca_uint32_t tx_sm_enable         :  1 ; /* bits 5:5 */
    ca_uint32_t rx_sm_enable         :  1 ; /* bits 6:6 */
    ca_uint32_t uart_en              :  1 ; /* bits 7:7 */
    ca_uint32_t baud_count           : 24 ; /* bits 31:8 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART3_CFG_t;


#define PER_UART3_FC                             0x522241dc
#define PER_UART3_FC_dft                         0x00000588

typedef volatile union {
  struct {
    ca_uint32_t rx_wm                :  6 ; /* bits 5:0 */
    ca_uint32_t inv_cts              :  1 ; /* bits 6:6 */
    ca_uint32_t no_cts               :  1 ; /* bits 7:7 */
    ca_uint32_t cts_reg              :  1 ; /* bits 8:8 */
    ca_uint32_t inv_rts              :  1 ; /* bits 9:9 */
    ca_uint32_t no_rts               :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd1               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART3_FC_t;


#define PER_UART3_RX_SAMPLE                      0x522241e0
#define PER_UART3_RX_SAMPLE_dft                  0x0000000f

typedef volatile union {
  struct {
    ca_uint32_t rx_center            : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART3_RX_SAMPLE_t;


#define PER_UART3_TUN                            0x522241e4
#define PER_UART3_TUN_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_fine_tune_ctl     :  8 ; /* bits 7:0 */
    ca_uint32_t rx_tune_add          :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t tx_fine_tune_ctl     :  8 ; /* bits 23:16 */
    ca_uint32_t tx_tune_add          :  1 ; /* bits 24:24 */
    ca_uint32_t rsrvd2               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART3_TUN_t;


#define PER_UART3_TXDAT                          0x522241e8
#define PER_UART3_TXDAT_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_data              :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART3_TXDAT_t;


#define PER_UART3_RXDAT                          0x522241ec
#define PER_UART3_RXDAT_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_data_lat          :  8 ; /* bits 7:0 */
    ca_uint32_t rx_data_vld          :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART3_RXDAT_t;


#define PER_UART3_INFO                           0x522241f0
#define PER_UART3_INFO_dft                       0x0000000a

typedef volatile union {
  struct {
    ca_uint32_t rx_fifo_full         :  1 ; /* bits 0:0 */
    ca_uint32_t rx_fifo_empty        :  1 ; /* bits 1:1 */
    ca_uint32_t tx_fifo_full         :  1 ; /* bits 2:2 */
    ca_uint32_t tx_fifo_empty        :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART3_INFO_t;


#define PER_UART3_IE_0                           0x522241f4
#define PER_UART3_IE_0_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overrune     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_erre         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_erre       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overrune     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underrune    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptye       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptye    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART3_IE_0_t;


#define PER_UART3_IE_1                           0x522241f8
#define PER_UART3_IE_1_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overrune     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_erre         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_erre       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overrune     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underrune    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptye       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptye    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART3_IE_1_t;


#define PER_UART3_INT_0                          0x522241fc
#define PER_UART3_INT_0_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overruni     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_erri         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_erri       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overruni     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underruni    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptyi       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptyi    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART3_INT_0_t;


#define PER_UART3_INT_1                          0x52224200
#define PER_UART3_INT_1_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overruni     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_erri         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_erri       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overruni     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underruni    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptyi       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptyi    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART3_INT_1_t;


#define PER_UART3_STAT                           0x52224204
#define PER_UART3_STAT_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_fifo_overruns     :  1 ; /* bits 0:0 */
    ca_uint32_t rx_stop_errs         :  1 ; /* bits 1:1 */
    ca_uint32_t rx_parity_errs       :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fifo_overruns     :  1 ; /* bits 3:3 */
    ca_uint32_t rx_fifo_underruns    :  1 ; /* bits 4:4 */
    ca_uint32_t tx_fifo_emptys       :  1 ; /* bits 5:5 */
    ca_uint32_t rx_fifo_nonemptys    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_UART3_STAT_t;


#define PER_TOD_CFG                              0x52224208
#define PER_TOD_CFG_dft                          0x00000026

typedef volatile union {
  struct {
    ca_uint32_t tod_counter          :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t tod_en               :  1 ; /* bits 7:7 */
    ca_uint32_t tod_uart             :  2 ; /* bits 9:8 */
    ca_uint32_t rsrvd2               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_TOD_CFG_t;


#define PER_TOD_MEM                              0x52224240
#define PER_TOD_MEM_STRIDE                       4
#define PER_TOD_MEM_COUNT                        16
#define PER_TOD_MEM_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tod_bst_mem          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_TOD_MEM_t;


#define PER_GPIO0_CFG                            0x52224280
#define PER_GPIO0_CFG_dft                        0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t iopmod               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_GPIO0_CFG_t;

#define     iopmod_OUT                                    0x0
#define     iopmod_IN                                     0x1

#define PER_GPIO0_OUT                            0x52224284
#define PER_GPIO0_OUT_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dataout              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_GPIO0_OUT_t;


#define PER_GPIO0_IN                             0x52224288
#define PER_GPIO0_IN_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t iopdata              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_GPIO0_IN_t;


#define PER_GPIO0_LVL                            0x5222428c
#define PER_GPIO0_LVL_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t level                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_GPIO0_LVL_t;

#define     level_LOW                                     0x0
#define     level_HIGH                                    0x1

#define PER_GPIO0_EDGE                           0x52224290
#define PER_GPIO0_EDGE_dft                       0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t i_edge               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_GPIO0_EDGE_t;

#define     i_edge_LOW                                    0x0
#define     i_edge_HIGH                                   0x1

#define PER_GPIO0_BOTHEDGE                       0x52224294
#define PER_GPIO0_BOTHEDGE_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t i_bothedge           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_GPIO0_BOTHEDGE_t;

#define     i_bothedge_LOW                                0x0
#define     i_bothedge_HIGH                               0x1

#define PER_GPIO0_IE                             0x52224298
#define PER_GPIO0_IE_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gpioe                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_GPIO0_IE_t;


#define PER_GPIO0_INT                            0x5222429c
#define PER_GPIO0_INT_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gpioi                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_GPIO0_INT_t;


#define PER_GPIO0_STAT                           0x522242a0
#define PER_GPIO0_STAT_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gpios                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_GPIO0_STAT_t;


#define PER_GPIO1_CFG                            0x522242a4
#define PER_GPIO1_CFG_dft                        0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t iopmod               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_GPIO1_CFG_t;


#define PER_GPIO1_OUT                            0x522242a8
#define PER_GPIO1_OUT_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dataout              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_GPIO1_OUT_t;


#define PER_GPIO1_IN                             0x522242ac
#define PER_GPIO1_IN_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t iopdata              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_GPIO1_IN_t;


#define PER_GPIO1_LVL                            0x522242b0
#define PER_GPIO1_LVL_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t level                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_GPIO1_LVL_t;


#define PER_GPIO1_EDGE                           0x522242b4
#define PER_GPIO1_EDGE_dft                       0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t i_edge               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_GPIO1_EDGE_t;


#define PER_GPIO1_BOTHEDGE                       0x522242b8
#define PER_GPIO1_BOTHEDGE_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t i_bothedge           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_GPIO1_BOTHEDGE_t;


#define PER_GPIO1_IE                             0x522242bc
#define PER_GPIO1_IE_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gpioe                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_GPIO1_IE_t;


#define PER_GPIO1_INT                            0x522242c0
#define PER_GPIO1_INT_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gpioi                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_GPIO1_INT_t;


#define PER_GPIO1_STAT                           0x522242c4
#define PER_GPIO1_STAT_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gpios                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_GPIO1_STAT_t;


#define PER_GPIO2_CFG                            0x522242c8
#define PER_GPIO2_CFG_dft                        0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t iopmod               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_GPIO2_CFG_t;


#define PER_GPIO2_OUT                            0x522242cc
#define PER_GPIO2_OUT_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dataout              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_GPIO2_OUT_t;


#define PER_GPIO2_IN                             0x522242d0
#define PER_GPIO2_IN_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t iopdata              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_GPIO2_IN_t;


#define PER_GPIO2_LVL                            0x522242d4
#define PER_GPIO2_LVL_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t level                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_GPIO2_LVL_t;


#define PER_GPIO2_EDGE                           0x522242d8
#define PER_GPIO2_EDGE_dft                       0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t i_edge               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_GPIO2_EDGE_t;


#define PER_GPIO2_BOTHEDGE                       0x522242dc
#define PER_GPIO2_BOTHEDGE_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t i_bothedge           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_GPIO2_BOTHEDGE_t;


#define PER_GPIO2_IE                             0x522242e0
#define PER_GPIO2_IE_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gpioe                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_GPIO2_IE_t;


#define PER_GPIO2_INT                            0x522242e4
#define PER_GPIO2_INT_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gpioi                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_GPIO2_INT_t;


#define PER_GPIO2_STAT                           0x522242e8
#define PER_GPIO2_STAT_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gpios                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_GPIO2_STAT_t;


#define PER_GPIO3_CFG                            0x522242ec
#define PER_GPIO3_CFG_dft                        0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t iopmod               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_GPIO3_CFG_t;


#define PER_GPIO3_OUT                            0x522242f0
#define PER_GPIO3_OUT_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dataout              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_GPIO3_OUT_t;


#define PER_GPIO3_IN                             0x522242f4
#define PER_GPIO3_IN_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t iopdata              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_GPIO3_IN_t;


#define PER_GPIO3_LVL                            0x522242f8
#define PER_GPIO3_LVL_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t level                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_GPIO3_LVL_t;


#define PER_GPIO3_EDGE                           0x522242fc
#define PER_GPIO3_EDGE_dft                       0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t i_edge               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_GPIO3_EDGE_t;


#define PER_GPIO3_BOTHEDGE                       0x52224300
#define PER_GPIO3_BOTHEDGE_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t i_bothedge           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_GPIO3_BOTHEDGE_t;


#define PER_GPIO3_IE                             0x52224304
#define PER_GPIO3_IE_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gpioe                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_GPIO3_IE_t;


#define PER_GPIO3_INT                            0x52224308
#define PER_GPIO3_INT_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gpioi                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_GPIO3_INT_t;


#define PER_GPIO3_STAT                           0x5222430c
#define PER_GPIO3_STAT_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gpios                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_GPIO3_STAT_t;


#define PER_SYS_TIMER1                           0x52224310
#define PER_SYS_TIMER1_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gtimer1              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_SYS_TIMER1_t;


#define PER_SYS_TIMER0                           0x52224314
#define PER_SYS_TIMER0_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gtimer0              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_SYS_TIMER0_t;


#define PER_SYS_TIMER_COMPARATOR_CPU_01          0x52224318
#define PER_SYS_TIMER_COMPARATOR_CPU_01_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t comp1                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_SYS_TIMER_COMPARATOR_CPU_01_t;


#define PER_SYS_TIMER_COMPARATOR_CPU_00          0x5222431c
#define PER_SYS_TIMER_COMPARATOR_CPU_00_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t comp0                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_SYS_TIMER_COMPARATOR_CPU_00_t;


#define PER_SYS_TIMER_AUTOINC_CPU_01             0x52224320
#define PER_SYS_TIMER_AUTOINC_CPU_01_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t autoinc1             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_SYS_TIMER_AUTOINC_CPU_01_t;


#define PER_SYS_TIMER_AUTOINC_CPU_00             0x52224324
#define PER_SYS_TIMER_AUTOINC_CPU_00_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t autoinc0             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_SYS_TIMER_AUTOINC_CPU_00_t;


#define PER_SYS_TIMER_CPU_0_INTENABLE            0x52224328
#define PER_SYS_TIMER_CPU_0_INTENABLE_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t systimere            :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_SYS_TIMER_CPU_0_INTENABLE_t;


#define PER_SYS_TIMER_CPU_0_INTERRUPT            0x5222432c
#define PER_SYS_TIMER_CPU_0_INTERRUPT_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t systimeri            :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_SYS_TIMER_CPU_0_INTERRUPT_t;


#define PER_SYS_TIMER_COMPARATOR_CPU_11          0x52224330
#define PER_SYS_TIMER_COMPARATOR_CPU_11_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t comp1                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_SYS_TIMER_COMPARATOR_CPU_11_t;


#define PER_SYS_TIMER_COMPARATOR_CPU_10          0x52224334
#define PER_SYS_TIMER_COMPARATOR_CPU_10_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t comp0                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_SYS_TIMER_COMPARATOR_CPU_10_t;


#define PER_SYS_TIMER_AUTOINC_CPU_11             0x52224338
#define PER_SYS_TIMER_AUTOINC_CPU_11_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t autoinc1             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_SYS_TIMER_AUTOINC_CPU_11_t;


#define PER_SYS_TIMER_AUTOINC_CPU_10             0x5222433c
#define PER_SYS_TIMER_AUTOINC_CPU_10_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t autoinc0             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_SYS_TIMER_AUTOINC_CPU_10_t;


#define PER_SYS_TIMER_CPU_1_INTENABLE            0x52224340
#define PER_SYS_TIMER_CPU_1_INTENABLE_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t systimere            :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_SYS_TIMER_CPU_1_INTENABLE_t;


#define PER_SYS_TIMER_CPU_1_INTERRUPT            0x52224344
#define PER_SYS_TIMER_CPU_1_INTERRUPT_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t systimeri            :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_SYS_TIMER_CPU_1_INTERRUPT_t;


#define PER_SYS_TIMER_COMPARATOR_CPU_21          0x52224348
#define PER_SYS_TIMER_COMPARATOR_CPU_21_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t comp1                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_SYS_TIMER_COMPARATOR_CPU_21_t;


#define PER_SYS_TIMER_COMPARATOR_CPU_20          0x5222434c
#define PER_SYS_TIMER_COMPARATOR_CPU_20_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t comp0                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_SYS_TIMER_COMPARATOR_CPU_20_t;


#define PER_SYS_TIMER_AUTOINC_CPU_21             0x52224350
#define PER_SYS_TIMER_AUTOINC_CPU_21_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t autoinc1             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_SYS_TIMER_AUTOINC_CPU_21_t;


#define PER_SYS_TIMER_AUTOINC_CPU_20             0x52224354
#define PER_SYS_TIMER_AUTOINC_CPU_20_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t autoinc0             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_SYS_TIMER_AUTOINC_CPU_20_t;


#define PER_SYS_TIMER_CPU_2_INTENABLE            0x52224358
#define PER_SYS_TIMER_CPU_2_INTENABLE_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t systimere            :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_SYS_TIMER_CPU_2_INTENABLE_t;


#define PER_SYS_TIMER_CPU_2_INTERRUPT            0x5222435c
#define PER_SYS_TIMER_CPU_2_INTERRUPT_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t systimeri            :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_SYS_TIMER_CPU_2_INTERRUPT_t;


#define PER_SYS_TIMER_COMPARATOR_CPU_31          0x52224360
#define PER_SYS_TIMER_COMPARATOR_CPU_31_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t comp1                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_SYS_TIMER_COMPARATOR_CPU_31_t;


#define PER_SYS_TIMER_COMPARATOR_CPU_30          0x52224364
#define PER_SYS_TIMER_COMPARATOR_CPU_30_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t comp0                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_SYS_TIMER_COMPARATOR_CPU_30_t;


#define PER_SYS_TIMER_AUTOINC_CPU_31             0x52224368
#define PER_SYS_TIMER_AUTOINC_CPU_31_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t autoinc1             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_SYS_TIMER_AUTOINC_CPU_31_t;


#define PER_SYS_TIMER_AUTOINC_CPU_30             0x5222436c
#define PER_SYS_TIMER_AUTOINC_CPU_30_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t autoinc0             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_SYS_TIMER_AUTOINC_CPU_30_t;


#define PER_SYS_TIMER_CPU_3_INTENABLE            0x52224370
#define PER_SYS_TIMER_CPU_3_INTENABLE_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t systimere            :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_SYS_TIMER_CPU_3_INTENABLE_t;


#define PER_SYS_TIMER_CPU_3_INTERRUPT            0x52224374
#define PER_SYS_TIMER_CPU_3_INTERRUPT_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t systimeri            :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_SYS_TIMER_CPU_3_INTERRUPT_t;


#define PER_PWM_TIMER_PERIOD_0                   0x52224378
#define PER_PWM_TIMER_PERIOD_0_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t period               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_PWM_TIMER_PERIOD_0_t;


#define PER_PWM_TIMER_COMP_0                     0x5222437c
#define PER_PWM_TIMER_COMP_0_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t comp                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_PWM_TIMER_COMP_0_t;


#define PER_PWM_TIMER_PERIOD_1                   0x52224380
#define PER_PWM_TIMER_PERIOD_1_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t period               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_PWM_TIMER_PERIOD_1_t;


#define PER_PWM_TIMER_COMP_1                     0x52224384
#define PER_PWM_TIMER_COMP_1_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t comp                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_PWM_TIMER_COMP_1_t;


#define PER_CSPI_CLK                             0x52224388
#define PER_CSPI_CLK_dft                         0x00000002

typedef volatile union {
  struct {
    ca_uint32_t divisor              : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 14 ;
    ca_uint32_t cpha                 :  1 ; /* bits 30:30 */
    ca_uint32_t cpol                 :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_CSPI_CLK_t;

#define     cpol_IDLE0                                    0x0
#define     cpol_IDLE1                                    0x1
#define     cpha_RXFIRST                                  0x0
#define     cpha_TXFIRST                                  0x1

#define PER_CSPI_FMT                             0x5222438c
#define PER_CSPI_FMT_dft                         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t highbit              :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t frontporch           :  8 ; /* bits 15:8 */
    ca_uint32_t backporch            :  8 ; /* bits 23:16 */
    ca_uint32_t gap                  :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_CSPI_FMT_t;


#define PER_CSPI_CS                              0x52224390
#define PER_CSPI_CS_dft                          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t enable               :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t active_hi            :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               : 18 ;
    ca_uint32_t force                :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_CSPI_CS_t;

#define     force_NORM                                    0x0
#define     force_FORCE                                   0x1
#define     active_hi_ACT_LO                              0x0
#define     active_hi_ACT_HI                              0x1
#define     enable_DISABLED                               0x0
#define     enable_ENABLED                                0x1

#define PER_CSPI_WDATA1                          0x52224394
#define PER_CSPI_WDATA1_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wdata1               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_CSPI_WDATA1_t;


#define PER_CSPI_WDATA0                          0x52224398
#define PER_CSPI_WDATA0_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wdata0               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_CSPI_WDATA0_t;


#define PER_CSPI_RDATA1                          0x5222439c
#define PER_CSPI_RDATA1_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rdata1               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_CSPI_RDATA1_t;


#define PER_CSPI_RDATA0                          0x522243a0
#define PER_CSPI_RDATA0_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rdata0               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_CSPI_RDATA0_t;


#define PER_CSPI_CONTROL                         0x522243a4
#define PER_CSPI_CONTROL_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t start                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_CSPI_CONTROL_t;


#define PER_CSPI_IE_0                            0x522243a8
#define PER_CSPI_IE_0_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cspie                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_CSPI_IE_0_t;


#define PER_CSPI_INT_0                           0x522243ac
#define PER_CSPI_INT_0_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cspii                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_CSPI_INT_0_t;


#define PER_CSPI_IE_1                            0x522243b0
#define PER_CSPI_IE_1_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cspie                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_CSPI_IE_1_t;


#define PER_CSPI_INT_1                           0x522243b4
#define PER_CSPI_INT_1_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cspii                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_CSPI_INT_1_t;


#define PER_CSPI_STAT                            0x522243b8
#define PER_CSPI_STAT_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cspis                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} PER_CSPI_STAT_t;


#define PER_SPARE                                0x522243bc
#define PER_SPARE_dft                            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t spare                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} PER_SPARE_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* FPGA_PER */
typedef struct {
  PER_SOFT_RESET_t                         SOFT_RESET;                    /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  PER_PERIPHERAL_INTERRUPT_0_t             PERIPHERAL_INTERRUPT_0;        /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  PER_PERIPHERAL_INTENABLE_0_t             PERIPHERAL_INTENABLE_0;        /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  PER_PERIPHERAL_INTERRUPT_1_t             PERIPHERAL_INTERRUPT_1;        /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  PER_PERIPHERAL_INTENABLE_1_t             PERIPHERAL_INTENABLE_1;        /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  PER_IRQ_SOFT1_t                          IRQ_SOFT1;                     /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  PER_IRQ_SOFT0_t                          IRQ_SOFT0;                     /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  PER_WDT_CTRL_t                           WDT_CTRL;                      /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  PER_WDT_PS_t                             WDT_PS;                        /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  PER_WDT_DIV_t                            WDT_DIV;                       /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  PER_WDT_LD_t                             WDT_LD;                        /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  PER_WDT_LOADE_t                          WDT_LOADE;                     /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  PER_WDT_CNT_t                            WDT_CNT;                       /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  PER_WDT_IE_0_t                           WDT_IE_0;                      /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  PER_WDT_INT_0_t                          WDT_INT_0;                     /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  PER_WDT_STAT_0_t                         WDT_STAT_0;                    /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  PER_WDT_IE_1_t                           WDT_IE_1;                      /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  PER_WDT_INT_1_t                          WDT_INT_1;                     /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  PER_WDT_STAT_1_t                         WDT_STAT_1;                    /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  PER_WDT_TST_t                            WDT_TST;                       /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  PER_TMR_LD1_t                            TMR_LD1;                       /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  PER_TMR_CTRL1_t                          TMR_CTRL1;                     /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  PER_TMR_CNT1_t                           TMR_CNT1;                      /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  PER_TMR_IE1_0_t                          TMR_IE1_0;                     /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  PER_TMR_IE1_1_t                          TMR_IE1_1;                     /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  PER_TMR_INT1_0_t                         TMR_INT1_0;                    /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  PER_TMR_INT1_1_t                         TMR_INT1_1;                    /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  PER_TMR_STAT1_t                          TMR_STAT1;                     /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  PER_TMR_LD2_t                            TMR_LD2;                       /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  PER_TMR_CTRL2_t                          TMR_CTRL2;                     /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  PER_TMR_CNT2_t                           TMR_CNT2;                      /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  PER_TMR_IE2_0_t                          TMR_IE2_0;                     /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  PER_TMR_IE2_1_t                          TMR_IE2_1;                     /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  PER_TMR_INT2_0_t                         TMR_INT2_0;                    /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  PER_TMR_INT2_1_t                         TMR_INT2_1;                    /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  PER_TMR_STAT2_t                          TMR_STAT2;                     /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  PER_TMR_LOADE_t                          TMR_LOADE;                     /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  PER_TMR_TST_t                            TMR_TST;                       /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  PER_SPI_CLK_t                            SPI_CLK;                       /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];                   
  PER_SPI_CFG_t                            SPI_CFG;                       /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];                   
  PER_SPI_MODE_t                           SPI_MODE;                      /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];                   
  PER_SPI_CTRL_t                           SPI_CTRL;                      /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];                   
  PER_SPI_CA0_t                            SPI_CA0;                       /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];                   
  PER_SPI_CA1_t                            SPI_CA1;                       /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd44[3];                   
  PER_SPI_CA2_t                            SPI_CA2;                       /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd45[3];                   
  PER_SPI_WDAT1_t                          SPI_WDAT1;                     /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd46[3];                   
  PER_SPI_WDAT0_t                          SPI_WDAT0;                     /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd47[3];                   
  PER_SPI_RDAT1_t                          SPI_RDAT1;                     /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd48[3];                   
  PER_SPI_RDAT0_t                          SPI_RDAT0;                     /* addr: 0x000000c0 */
  ca_uint32_t                              rsrvd49[3];                   
  PER_SPI_IE_0_t                           SPI_IE_0;                      /* addr: 0x000000c4 */
  ca_uint32_t                              rsrvd50[3];                   
  PER_SPI_INT_0_t                          SPI_INT_0;                     /* addr: 0x000000c8 */
  ca_uint32_t                              rsrvd51[3];                   
  PER_SPI_IE_1_t                           SPI_IE_1;                      /* addr: 0x000000cc */
  ca_uint32_t                              rsrvd52[3];                   
  PER_SPI_INT_1_t                          SPI_INT_1;                     /* addr: 0x000000d0 */
  ca_uint32_t                              rsrvd53[3];                   
  PER_SPI_STAT_t                           SPI_STAT;                      /* addr: 0x000000d4 */
  ca_uint32_t                              rsrvd54[3];                   
  PER_MDIO_CFG_t                           MDIO_CFG;                      /* addr: 0x000000d8 */
  ca_uint32_t                              rsrvd55[3];                   
  PER_MDIO_ADDR_t                          MDIO_ADDR;                     /* addr: 0x000000dc */
  ca_uint32_t                              rsrvd56[3];                   
  PER_MDIO_WRDATA_t                        MDIO_WRDATA;                   /* addr: 0x000000e0 */
  ca_uint32_t                              rsrvd57[3];                   
  PER_MDIO_RDDATA_t                        MDIO_RDDATA;                   /* addr: 0x000000e4 */
  ca_uint32_t                              rsrvd58[3];                   
  PER_MDIO_CTRL_t                          MDIO_CTRL;                     /* addr: 0x000000e8 */
  ca_uint32_t                              rsrvd59[3];                   
  PER_MDIO_AUTO_CFG_t                      MDIO_AUTO_CFG;                 /* addr: 0x000000ec */
  ca_uint32_t                              rsrvd60[3];                   
  PER_MDIO_AUTO_INTV_t                     MDIO_AUTO_INTV;                /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd61[3];                   
  PER_MDIO_AUTO_RM_t                       MDIO_AUTO_RM;                  /* addr: 0x000000f4 */
  ca_uint32_t                              rsrvd62[3];                   
  PER_MDIO_AUTO_AADDR_t                    MDIO_AUTO_AADDR;               /* addr: 0x000000f8 */
  ca_uint32_t                              rsrvd63[3];                   
  PER_MDIO_ENTAB0_t                        MDIO_ENTAB0;                   /* addr: 0x000000fc */
  ca_uint32_t                              rsrvd64[3];                   
  PER_MDIO_ENTAB1_t                        MDIO_ENTAB1;                   /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd65[3];                   
  PER_MDIO_ITAB0_t                         MDIO_ITAB0;                    /* addr: 0x00000104 */
  ca_uint32_t                              rsrvd66[3];                   
  PER_MDIO_ITAB1_t                         MDIO_ITAB1;                    /* addr: 0x00000108 */
  ca_uint32_t                              rsrvd67[3];                   
  PER_MDIO_IE_0_t                          MDIO_IE_0;                     /* addr: 0x0000010c */
  ca_uint32_t                              rsrvd68[3];                   
  PER_MDIO_INT_0_t                         MDIO_INT_0;                    /* addr: 0x00000110 */
  ca_uint32_t                              rsrvd69[3];                   
  PER_MDIO_IE_1_t                          MDIO_IE_1;                     /* addr: 0x00000114 */
  ca_uint32_t                              rsrvd70[3];                   
  PER_MDIO_INT_1_t                         MDIO_INT_1;                    /* addr: 0x00000118 */
  ca_uint32_t                              rsrvd71[3];                   
  PER_MDIO_STAT_t                          MDIO_STAT;                     /* addr: 0x0000011c */
  ca_uint32_t                              rsrvd72[3];                   
  PER_BIW_CFG_t                            BIW_CFG;                       /* addr: 0x00000120 */
  ca_uint32_t                              rsrvd73[3];                   
  PER_BIW_CTRL_t                           BIW_CTRL;                      /* addr: 0x00000124 */
  ca_uint32_t                              rsrvd74[3];                   
  PER_BIW_TXR_t                            BIW_TXR;                       /* addr: 0x00000128 */
  ca_uint32_t                              rsrvd75[3];                   
  PER_BIW_RXR_t                            BIW_RXR;                       /* addr: 0x0000012c */
  ca_uint32_t                              rsrvd76[3];                   
  PER_BIW_ACK_t                            BIW_ACK;                       /* addr: 0x00000130 */
  ca_uint32_t                              rsrvd77[3];                   
  PER_BIW_IE_0_t                           BIW_IE_0;                      /* addr: 0x00000134 */
  ca_uint32_t                              rsrvd78[3];                   
  PER_BIW_INT_0_t                          BIW_INT_0;                     /* addr: 0x00000138 */
  ca_uint32_t                              rsrvd79[3];                   
  PER_BIW_IE_1_t                           BIW_IE_1;                      /* addr: 0x0000013c */
  ca_uint32_t                              rsrvd80[3];                   
  PER_BIW_INT_1_t                          BIW_INT_1;                     /* addr: 0x00000140 */
  ca_uint32_t                              rsrvd81[3];                   
  PER_BIW_STAT_t                           BIW_STAT;                      /* addr: 0x00000144 */
  ca_uint32_t                              rsrvd82[3];                   
  PER_UART0_CFG_t                          UART0_CFG;                     /* addr: 0x00000148 */
  ca_uint32_t                              rsrvd83[3];                   
  PER_UART0_FC_t                           UART0_FC;                      /* addr: 0x0000014c */
  ca_uint32_t                              rsrvd84[3];                   
  PER_UART0_RX_SAMPLE_t                    UART0_RX_SAMPLE;               /* addr: 0x00000150 */
  ca_uint32_t                              rsrvd85[3];                   
  PER_UART0_TUN_t                          UART0_TUN;                     /* addr: 0x00000154 */
  ca_uint32_t                              rsrvd86[3];                   
  PER_UART0_TXDAT_t                        UART0_TXDAT;                   /* addr: 0x00000158 */
  ca_uint32_t                              rsrvd87[3];                   
  PER_UART0_RXDAT_t                        UART0_RXDAT;                   /* addr: 0x0000015c */
  ca_uint32_t                              rsrvd88[3];                   
  PER_UART0_INFO_t                         UART0_INFO;                    /* addr: 0x00000160 */
  ca_uint32_t                              rsrvd89[3];                   
  PER_UART0_IE_0_t                         UART0_IE_0;                    /* addr: 0x00000164 */
  ca_uint32_t                              rsrvd90[3];                   
  PER_UART0_IE_1_t                         UART0_IE_1;                    /* addr: 0x00000168 */
  ca_uint32_t                              rsrvd91[3];                   
  PER_UART0_INT_0_t                        UART0_INT_0;                   /* addr: 0x0000016c */
  ca_uint32_t                              rsrvd92[3];                   
  PER_UART0_INT_1_t                        UART0_INT_1;                   /* addr: 0x00000170 */
  ca_uint32_t                              rsrvd93[3];                   
  PER_UART0_STAT_t                         UART0_STAT;                    /* addr: 0x00000174 */
  ca_uint32_t                              rsrvd94[3];                   
  PER_UART1_CFG_t                          UART1_CFG;                     /* addr: 0x00000178 */
  ca_uint32_t                              rsrvd95[3];                   
  PER_UART1_FC_t                           UART1_FC;                      /* addr: 0x0000017c */
  ca_uint32_t                              rsrvd96[3];                   
  PER_UART1_RX_SAMPLE_t                    UART1_RX_SAMPLE;               /* addr: 0x00000180 */
  ca_uint32_t                              rsrvd97[3];                   
  PER_UART1_TUN_t                          UART1_TUN;                     /* addr: 0x00000184 */
  ca_uint32_t                              rsrvd98[3];                   
  PER_UART1_TXDAT_t                        UART1_TXDAT;                   /* addr: 0x00000188 */
  ca_uint32_t                              rsrvd99[3];                   
  PER_UART1_RXDAT_t                        UART1_RXDAT;                   /* addr: 0x0000018c */
  ca_uint32_t                              rsrvd100[3];                  
  PER_UART1_INFO_t                         UART1_INFO;                    /* addr: 0x00000190 */
  ca_uint32_t                              rsrvd101[3];                  
  PER_UART1_IE_0_t                         UART1_IE_0;                    /* addr: 0x00000194 */
  ca_uint32_t                              rsrvd102[3];                  
  PER_UART1_IE_1_t                         UART1_IE_1;                    /* addr: 0x00000198 */
  ca_uint32_t                              rsrvd103[3];                  
  PER_UART1_INT_0_t                        UART1_INT_0;                   /* addr: 0x0000019c */
  ca_uint32_t                              rsrvd104[3];                  
  PER_UART1_INT_1_t                        UART1_INT_1;                   /* addr: 0x000001a0 */
  ca_uint32_t                              rsrvd105[3];                  
  PER_UART1_STAT_t                         UART1_STAT;                    /* addr: 0x000001a4 */
  ca_uint32_t                              rsrvd106[3];                  
  PER_UART2_CFG_t                          UART2_CFG;                     /* addr: 0x000001a8 */
  ca_uint32_t                              rsrvd107[3];                  
  PER_UART2_FC_t                           UART2_FC;                      /* addr: 0x000001ac */
  ca_uint32_t                              rsrvd108[3];                  
  PER_UART2_RX_SAMPLE_t                    UART2_RX_SAMPLE;               /* addr: 0x000001b0 */
  ca_uint32_t                              rsrvd109[3];                  
  PER_UART2_TUN_t                          UART2_TUN;                     /* addr: 0x000001b4 */
  ca_uint32_t                              rsrvd110[3];                  
  PER_UART2_TXDAT_t                        UART2_TXDAT;                   /* addr: 0x000001b8 */
  ca_uint32_t                              rsrvd111[3];                  
  PER_UART2_RXDAT_t                        UART2_RXDAT;                   /* addr: 0x000001bc */
  ca_uint32_t                              rsrvd112[3];                  
  PER_UART2_INFO_t                         UART2_INFO;                    /* addr: 0x000001c0 */
  ca_uint32_t                              rsrvd113[3];                  
  PER_UART2_IE_0_t                         UART2_IE_0;                    /* addr: 0x000001c4 */
  ca_uint32_t                              rsrvd114[3];                  
  PER_UART2_IE_1_t                         UART2_IE_1;                    /* addr: 0x000001c8 */
  ca_uint32_t                              rsrvd115[3];                  
  PER_UART2_INT_0_t                        UART2_INT_0;                   /* addr: 0x000001cc */
  ca_uint32_t                              rsrvd116[3];                  
  PER_UART2_INT_1_t                        UART2_INT_1;                   /* addr: 0x000001d0 */
  ca_uint32_t                              rsrvd117[3];                  
  PER_UART2_STAT_t                         UART2_STAT;                    /* addr: 0x000001d4 */
  ca_uint32_t                              rsrvd118[3];                  
  PER_UART3_CFG_t                          UART3_CFG;                     /* addr: 0x000001d8 */
  ca_uint32_t                              rsrvd119[3];                  
  PER_UART3_FC_t                           UART3_FC;                      /* addr: 0x000001dc */
  ca_uint32_t                              rsrvd120[3];                  
  PER_UART3_RX_SAMPLE_t                    UART3_RX_SAMPLE;               /* addr: 0x000001e0 */
  ca_uint32_t                              rsrvd121[3];                  
  PER_UART3_TUN_t                          UART3_TUN;                     /* addr: 0x000001e4 */
  ca_uint32_t                              rsrvd122[3];                  
  PER_UART3_TXDAT_t                        UART3_TXDAT;                   /* addr: 0x000001e8 */
  ca_uint32_t                              rsrvd123[3];                  
  PER_UART3_RXDAT_t                        UART3_RXDAT;                   /* addr: 0x000001ec */
  ca_uint32_t                              rsrvd124[3];                  
  PER_UART3_INFO_t                         UART3_INFO;                    /* addr: 0x000001f0 */
  ca_uint32_t                              rsrvd125[3];                  
  PER_UART3_IE_0_t                         UART3_IE_0;                    /* addr: 0x000001f4 */
  ca_uint32_t                              rsrvd126[3];                  
  PER_UART3_IE_1_t                         UART3_IE_1;                    /* addr: 0x000001f8 */
  ca_uint32_t                              rsrvd127[3];                  
  PER_UART3_INT_0_t                        UART3_INT_0;                   /* addr: 0x000001fc */
  ca_uint32_t                              rsrvd128[3];                  
  PER_UART3_INT_1_t                        UART3_INT_1;                   /* addr: 0x00000200 */
  ca_uint32_t                              rsrvd129[3];                  
  PER_UART3_STAT_t                         UART3_STAT;                    /* addr: 0x00000204 */
  ca_uint32_t                              rsrvd130[3];                  
  PER_TOD_CFG_t                            TOD_CFG;                       /* addr: 0x00000208 */
  ca_uint32_t                              rsrvd131[55];                 
  PER_TOD_MEM_t                            TOD_MEM[16];                   /* addr: 0x00000240 */
  ca_uint32_t                              rsrvd132[48];                 
  PER_GPIO0_CFG_t                          GPIO0_CFG;                     /* addr: 0x00000280 */
  ca_uint32_t                              rsrvd133[3];                  
  PER_GPIO0_OUT_t                          GPIO0_OUT;                     /* addr: 0x00000284 */
  ca_uint32_t                              rsrvd134[3];                  
  PER_GPIO0_IN_t                           GPIO0_IN;                      /* addr: 0x00000288 */
  ca_uint32_t                              rsrvd135[3];                  
  PER_GPIO0_LVL_t                          GPIO0_LVL;                     /* addr: 0x0000028c */
  ca_uint32_t                              rsrvd136[3];                  
  PER_GPIO0_EDGE_t                         GPIO0_EDGE;                    /* addr: 0x00000290 */
  ca_uint32_t                              rsrvd137[3];                  
  PER_GPIO0_BOTHEDGE_t                     GPIO0_BOTHEDGE;                /* addr: 0x00000294 */
  ca_uint32_t                              rsrvd138[3];                  
  PER_GPIO0_IE_t                           GPIO0_IE;                      /* addr: 0x00000298 */
  ca_uint32_t                              rsrvd139[3];                  
  PER_GPIO0_INT_t                          GPIO0_INT;                     /* addr: 0x0000029c */
  ca_uint32_t                              rsrvd140[3];                  
  PER_GPIO0_STAT_t                         GPIO0_STAT;                    /* addr: 0x000002a0 */
  ca_uint32_t                              rsrvd141[3];                  
  PER_GPIO1_CFG_t                          GPIO1_CFG;                     /* addr: 0x000002a4 */
  ca_uint32_t                              rsrvd142[3];                  
  PER_GPIO1_OUT_t                          GPIO1_OUT;                     /* addr: 0x000002a8 */
  ca_uint32_t                              rsrvd143[3];                  
  PER_GPIO1_IN_t                           GPIO1_IN;                      /* addr: 0x000002ac */
  ca_uint32_t                              rsrvd144[3];                  
  PER_GPIO1_LVL_t                          GPIO1_LVL;                     /* addr: 0x000002b0 */
  ca_uint32_t                              rsrvd145[3];                  
  PER_GPIO1_EDGE_t                         GPIO1_EDGE;                    /* addr: 0x000002b4 */
  ca_uint32_t                              rsrvd146[3];                  
  PER_GPIO1_BOTHEDGE_t                     GPIO1_BOTHEDGE;                /* addr: 0x000002b8 */
  ca_uint32_t                              rsrvd147[3];                  
  PER_GPIO1_IE_t                           GPIO1_IE;                      /* addr: 0x000002bc */
  ca_uint32_t                              rsrvd148[3];                  
  PER_GPIO1_INT_t                          GPIO1_INT;                     /* addr: 0x000002c0 */
  ca_uint32_t                              rsrvd149[3];                  
  PER_GPIO1_STAT_t                         GPIO1_STAT;                    /* addr: 0x000002c4 */
  ca_uint32_t                              rsrvd150[3];                  
  PER_GPIO2_CFG_t                          GPIO2_CFG;                     /* addr: 0x000002c8 */
  ca_uint32_t                              rsrvd151[3];                  
  PER_GPIO2_OUT_t                          GPIO2_OUT;                     /* addr: 0x000002cc */
  ca_uint32_t                              rsrvd152[3];                  
  PER_GPIO2_IN_t                           GPIO2_IN;                      /* addr: 0x000002d0 */
  ca_uint32_t                              rsrvd153[3];                  
  PER_GPIO2_LVL_t                          GPIO2_LVL;                     /* addr: 0x000002d4 */
  ca_uint32_t                              rsrvd154[3];                  
  PER_GPIO2_EDGE_t                         GPIO2_EDGE;                    /* addr: 0x000002d8 */
  ca_uint32_t                              rsrvd155[3];                  
  PER_GPIO2_BOTHEDGE_t                     GPIO2_BOTHEDGE;                /* addr: 0x000002dc */
  ca_uint32_t                              rsrvd156[3];                  
  PER_GPIO2_IE_t                           GPIO2_IE;                      /* addr: 0x000002e0 */
  ca_uint32_t                              rsrvd157[3];                  
  PER_GPIO2_INT_t                          GPIO2_INT;                     /* addr: 0x000002e4 */
  ca_uint32_t                              rsrvd158[3];                  
  PER_GPIO2_STAT_t                         GPIO2_STAT;                    /* addr: 0x000002e8 */
  ca_uint32_t                              rsrvd159[3];                  
  PER_GPIO3_CFG_t                          GPIO3_CFG;                     /* addr: 0x000002ec */
  ca_uint32_t                              rsrvd160[3];                  
  PER_GPIO3_OUT_t                          GPIO3_OUT;                     /* addr: 0x000002f0 */
  ca_uint32_t                              rsrvd161[3];                  
  PER_GPIO3_IN_t                           GPIO3_IN;                      /* addr: 0x000002f4 */
  ca_uint32_t                              rsrvd162[3];                  
  PER_GPIO3_LVL_t                          GPIO3_LVL;                     /* addr: 0x000002f8 */
  ca_uint32_t                              rsrvd163[3];                  
  PER_GPIO3_EDGE_t                         GPIO3_EDGE;                    /* addr: 0x000002fc */
  ca_uint32_t                              rsrvd164[3];                  
  PER_GPIO3_BOTHEDGE_t                     GPIO3_BOTHEDGE;                /* addr: 0x00000300 */
  ca_uint32_t                              rsrvd165[3];                  
  PER_GPIO3_IE_t                           GPIO3_IE;                      /* addr: 0x00000304 */
  ca_uint32_t                              rsrvd166[3];                  
  PER_GPIO3_INT_t                          GPIO3_INT;                     /* addr: 0x00000308 */
  ca_uint32_t                              rsrvd167[3];                  
  PER_GPIO3_STAT_t                         GPIO3_STAT;                    /* addr: 0x0000030c */
  ca_uint32_t                              rsrvd168[3];                  
  PER_SYS_TIMER1_t                         SYS_TIMER1;                    /* addr: 0x00000310 */
  ca_uint32_t                              rsrvd169[3];                  
  PER_SYS_TIMER0_t                         SYS_TIMER0;                    /* addr: 0x00000314 */
  ca_uint32_t                              rsrvd170[3];                  
  PER_SYS_TIMER_COMPARATOR_CPU_01_t        SYS_TIMER_COMPARATOR_CPU_01;   /* addr: 0x00000318 */
  ca_uint32_t                              rsrvd171[3];                  
  PER_SYS_TIMER_COMPARATOR_CPU_00_t        SYS_TIMER_COMPARATOR_CPU_00;   /* addr: 0x0000031c */
  ca_uint32_t                              rsrvd172[3];                  
  PER_SYS_TIMER_AUTOINC_CPU_01_t           SYS_TIMER_AUTOINC_CPU_01;      /* addr: 0x00000320 */
  ca_uint32_t                              rsrvd173[3];                  
  PER_SYS_TIMER_AUTOINC_CPU_00_t           SYS_TIMER_AUTOINC_CPU_00;      /* addr: 0x00000324 */
  ca_uint32_t                              rsrvd174[3];                  
  PER_SYS_TIMER_CPU_0_INTENABLE_t          SYS_TIMER_CPU_0_INTENABLE;     /* addr: 0x00000328 */
  ca_uint32_t                              rsrvd175[3];                  
  PER_SYS_TIMER_CPU_0_INTERRUPT_t          SYS_TIMER_CPU_0_INTERRUPT;     /* addr: 0x0000032c */
  ca_uint32_t                              rsrvd176[3];                  
  PER_SYS_TIMER_COMPARATOR_CPU_11_t        SYS_TIMER_COMPARATOR_CPU_11;   /* addr: 0x00000330 */
  ca_uint32_t                              rsrvd177[3];                  
  PER_SYS_TIMER_COMPARATOR_CPU_10_t        SYS_TIMER_COMPARATOR_CPU_10;   /* addr: 0x00000334 */
  ca_uint32_t                              rsrvd178[3];                  
  PER_SYS_TIMER_AUTOINC_CPU_11_t           SYS_TIMER_AUTOINC_CPU_11;      /* addr: 0x00000338 */
  ca_uint32_t                              rsrvd179[3];                  
  PER_SYS_TIMER_AUTOINC_CPU_10_t           SYS_TIMER_AUTOINC_CPU_10;      /* addr: 0x0000033c */
  ca_uint32_t                              rsrvd180[3];                  
  PER_SYS_TIMER_CPU_1_INTENABLE_t          SYS_TIMER_CPU_1_INTENABLE;     /* addr: 0x00000340 */
  ca_uint32_t                              rsrvd181[3];                  
  PER_SYS_TIMER_CPU_1_INTERRUPT_t          SYS_TIMER_CPU_1_INTERRUPT;     /* addr: 0x00000344 */
  ca_uint32_t                              rsrvd182[3];                  
  PER_SYS_TIMER_COMPARATOR_CPU_21_t        SYS_TIMER_COMPARATOR_CPU_21;   /* addr: 0x00000348 */
  ca_uint32_t                              rsrvd183[3];                  
  PER_SYS_TIMER_COMPARATOR_CPU_20_t        SYS_TIMER_COMPARATOR_CPU_20;   /* addr: 0x0000034c */
  ca_uint32_t                              rsrvd184[3];                  
  PER_SYS_TIMER_AUTOINC_CPU_21_t           SYS_TIMER_AUTOINC_CPU_21;      /* addr: 0x00000350 */
  ca_uint32_t                              rsrvd185[3];                  
  PER_SYS_TIMER_AUTOINC_CPU_20_t           SYS_TIMER_AUTOINC_CPU_20;      /* addr: 0x00000354 */
  ca_uint32_t                              rsrvd186[3];                  
  PER_SYS_TIMER_CPU_2_INTENABLE_t          SYS_TIMER_CPU_2_INTENABLE;     /* addr: 0x00000358 */
  ca_uint32_t                              rsrvd187[3];                  
  PER_SYS_TIMER_CPU_2_INTERRUPT_t          SYS_TIMER_CPU_2_INTERRUPT;     /* addr: 0x0000035c */
  ca_uint32_t                              rsrvd188[3];                  
  PER_SYS_TIMER_COMPARATOR_CPU_31_t        SYS_TIMER_COMPARATOR_CPU_31;   /* addr: 0x00000360 */
  ca_uint32_t                              rsrvd189[3];                  
  PER_SYS_TIMER_COMPARATOR_CPU_30_t        SYS_TIMER_COMPARATOR_CPU_30;   /* addr: 0x00000364 */
  ca_uint32_t                              rsrvd190[3];                  
  PER_SYS_TIMER_AUTOINC_CPU_31_t           SYS_TIMER_AUTOINC_CPU_31;      /* addr: 0x00000368 */
  ca_uint32_t                              rsrvd191[3];                  
  PER_SYS_TIMER_AUTOINC_CPU_30_t           SYS_TIMER_AUTOINC_CPU_30;      /* addr: 0x0000036c */
  ca_uint32_t                              rsrvd192[3];                  
  PER_SYS_TIMER_CPU_3_INTENABLE_t          SYS_TIMER_CPU_3_INTENABLE;     /* addr: 0x00000370 */
  ca_uint32_t                              rsrvd193[3];                  
  PER_SYS_TIMER_CPU_3_INTERRUPT_t          SYS_TIMER_CPU_3_INTERRUPT;     /* addr: 0x00000374 */
  ca_uint32_t                              rsrvd194[3];                  
  PER_PWM_TIMER_PERIOD_0_t                 PWM_TIMER_PERIOD_0;            /* addr: 0x00000378 */
  ca_uint32_t                              rsrvd195[3];                  
  PER_PWM_TIMER_COMP_0_t                   PWM_TIMER_COMP_0;              /* addr: 0x0000037c */
  ca_uint32_t                              rsrvd196[3];                  
  PER_PWM_TIMER_PERIOD_1_t                 PWM_TIMER_PERIOD_1;            /* addr: 0x00000380 */
  ca_uint32_t                              rsrvd197[3];                  
  PER_PWM_TIMER_COMP_1_t                   PWM_TIMER_COMP_1;              /* addr: 0x00000384 */
  ca_uint32_t                              rsrvd198[3];                  
  PER_CSPI_CLK_t                           CSPI_CLK;                      /* addr: 0x00000388 */
  ca_uint32_t                              rsrvd199[3];                  
  PER_CSPI_FMT_t                           CSPI_FMT;                      /* addr: 0x0000038c */
  ca_uint32_t                              rsrvd200[3];                  
  PER_CSPI_CS_t                            CSPI_CS;                       /* addr: 0x00000390 */
  ca_uint32_t                              rsrvd201[3];                  
  PER_CSPI_WDATA1_t                        CSPI_WDATA1;                   /* addr: 0x00000394 */
  ca_uint32_t                              rsrvd202[3];                  
  PER_CSPI_WDATA0_t                        CSPI_WDATA0;                   /* addr: 0x00000398 */
  ca_uint32_t                              rsrvd203[3];                  
  PER_CSPI_RDATA1_t                        CSPI_RDATA1;                   /* addr: 0x0000039c */
  ca_uint32_t                              rsrvd204[3];                  
  PER_CSPI_RDATA0_t                        CSPI_RDATA0;                   /* addr: 0x000003a0 */
  ca_uint32_t                              rsrvd205[3];                  
  PER_CSPI_CONTROL_t                       CSPI_CONTROL;                  /* addr: 0x000003a4 */
  ca_uint32_t                              rsrvd206[3];                  
  PER_CSPI_IE_0_t                          CSPI_IE_0;                     /* addr: 0x000003a8 */
  ca_uint32_t                              rsrvd207[3];                  
  PER_CSPI_INT_0_t                         CSPI_INT_0;                    /* addr: 0x000003ac */
  ca_uint32_t                              rsrvd208[3];                  
  PER_CSPI_IE_1_t                          CSPI_IE_1;                     /* addr: 0x000003b0 */
  ca_uint32_t                              rsrvd209[3];                  
  PER_CSPI_INT_1_t                         CSPI_INT_1;                    /* addr: 0x000003b4 */
  ca_uint32_t                              rsrvd210[3];                  
  PER_CSPI_STAT_t                          CSPI_STAT;                     /* addr: 0x000003b8 */
  ca_uint32_t                              rsrvd211[3];                  
  PER_SPARE_t                              SPARE;                         /* addr: 0x000003bc */
} APB4_FPGA_PER_t;


/*
 * FPGA_IIC_SLV
 */
      
  

/*
 * MAC_TEST
 */
      
  

/*
 * FPGA_XGE
 */
      
  

/*
 * FPGA_IDP_DOWN
 */
        
#define FPGA_IDP_DOWN_CPU_RX_PKT_DATA1           0x52228000
#define FPGA_IDP_DOWN_CPU_RX_PKT_DATA1_STRIDE    8
#define FPGA_IDP_DOWN_CPU_RX_PKT_DATA1_COUNT     256
#define FPGA_IDP_DOWN_CPU_RX_PKT_DATA1_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t payload1             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_DOWN_CPU_RX_PKT_DATA1_t;


#define FPGA_IDP_DOWN_CPU_RX_PKT_DATA0           0x52228004
#define FPGA_IDP_DOWN_CPU_RX_PKT_DATA0_STRIDE    8
#define FPGA_IDP_DOWN_CPU_RX_PKT_DATA0_COUNT     256
#define FPGA_IDP_DOWN_CPU_RX_PKT_DATA0_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t payload0             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_DOWN_CPU_RX_PKT_DATA0_t;


#define FPGA_IDP_DOWN_MY_MAC_HI                  0x52228800
#define FPGA_IDP_DOWN_MY_MAC_HI_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac_da_hi            : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_DOWN_MY_MAC_HI_t;


#define FPGA_IDP_DOWN_MY_MAC_LO                  0x52228804
#define FPGA_IDP_DOWN_MY_MAC_LO_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac_da_lo            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_DOWN_MY_MAC_LO_t;


#define FPGA_IDP_DOWN_MY_ETH_TYPE                0x52228808
#define FPGA_IDP_DOWN_MY_ETH_TYPE_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t eth_type             : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_DOWN_MY_ETH_TYPE_t;


#define FPGA_IDP_DOWN_CNTL                       0x5222880c
#define FPGA_IDP_DOWN_CNTL_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cpu_read_done        :  1 ; /* bits 0:0 */
    ca_uint32_t count_clear          :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_DOWN_CNTL_t;


#define FPGA_IDP_DOWN_CPURX_PKT                  0x52228810
#define FPGA_IDP_DOWN_CPURX_PKT_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt_size             : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_DOWN_CPURX_PKT_t;


#define FPGA_IDP_DOWN_RGMII_PATH_CTRL            0x52228814
#define FPGA_IDP_DOWN_RGMII_PATH_CTRL_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t snoop_en             :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_DOWN_RGMII_PATH_CTRL_t;


#define FPGA_IDP_DOWN_INT                        0x52228818
#define FPGA_IDP_DOWN_INT_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t localcpu_rx_pkt_rdy  :  1 ; /* bits 0:0 */
    ca_uint32_t receive_pkt_err      :  1 ; /* bits 1:1 */
    ca_uint32_t localcpu_oversize    :  1 ; /* bits 2:2 */
    ca_uint32_t localcpu_pkt_drop    :  1 ; /* bits 3:3 */
    ca_uint32_t remote_cpu_oversize  :  1 ; /* bits 4:4 */
    ca_uint32_t remote_cpu_pkt_drop  :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t xge_overflow         :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd2               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_DOWN_INT_t;


#define FPGA_IDP_DOWN_INTE                       0x5222881c
#define FPGA_IDP_DOWN_INTE_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t localcpu_rx_pkt_rdyE :  1 ; /* bits 0:0 */
    ca_uint32_t receive_pkt_errE     :  1 ; /* bits 1:1 */
    ca_uint32_t localcpu_oversizeE   :  1 ; /* bits 2:2 */
    ca_uint32_t localcpu_pkt_dropE   :  1 ; /* bits 3:3 */
    ca_uint32_t remote_cpu_oversizeE :  1 ; /* bits 4:4 */
    ca_uint32_t remote_cpu_pkt_dropE :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t xge_overflowE        :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd2               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_DOWN_INTE_t;


#define FPGA_IDP_DOWN_TO_REMOTE_CPU_PKT_COUNT    0x52228820
#define FPGA_IDP_DOWN_TO_REMOTE_CPU_PKT_COUNT_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt_count            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_DOWN_TO_REMOTE_CPU_PKT_COUNT_t;


#define FPGA_IDP_DOWN_TO_REMOTE_CPU_BYT_COUNT    0x52228824
#define FPGA_IDP_DOWN_TO_REMOTE_CPU_BYT_COUNT_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t byt_count            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_DOWN_TO_REMOTE_CPU_BYT_COUNT_t;


#define FPGA_IDP_DOWN_TO_XGE_PKT_COUNT           0x52228828
#define FPGA_IDP_DOWN_TO_XGE_PKT_COUNT_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt_count            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_DOWN_TO_XGE_PKT_COUNT_t;


#define FPGA_IDP_DOWN_TO_XGE_BYT_COUNT           0x5222882c
#define FPGA_IDP_DOWN_TO_XGE_BYT_COUNT_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t byt_count            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_DOWN_TO_XGE_BYT_COUNT_t;


#define FPGA_IDP_DOWN_COUNTERS_ACCESS            0x52228830
#define FPGA_IDP_DOWN_COUNTERS_ACCESS_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ADDR                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_DOWN_COUNTERS_ACCESS_t;


#define FPGA_IDP_DOWN_COUNTERS_DATA1             0x52228834
#define FPGA_IDP_DOWN_COUNTERS_DATA1_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt_count            : 20 ; /* bits 19:0 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_DOWN_COUNTERS_DATA1_t;


#define FPGA_IDP_DOWN_COUNTERS_DATA0             0x52228838
#define FPGA_IDP_DOWN_COUNTERS_DATA0_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t byt_count            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_DOWN_COUNTERS_DATA0_t;


#define FPGA_IDP_DOWN_CPU2LAN_CNTL               0x5222883c
#define FPGA_IDP_DOWN_CPU2LAN_CNTL_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cpu_write_done       :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_DOWN_CPU2LAN_CNTL_t;


#define FPGA_IDP_DOWN_CPU2LAN_PKT                0x52228840
#define FPGA_IDP_DOWN_CPU2LAN_PKT_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt_size             : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_DOWN_CPU2LAN_PKT_t;


#define FPGA_IDP_DOWN_CTRL                       0x52228844
#define FPGA_IDP_DOWN_CTRL_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t push_vlan_tpid       : 16 ; /* bits 15:0 */
    ca_uint32_t push_vlan_en         :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_DOWN_CTRL_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* FPGA_IDP_DOWN */
typedef struct {
  FPGA_IDP_DOWN_CPU_RX_PKT_DATA1_t         CPU_RX_PKT_DATA1;              /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  FPGA_IDP_DOWN_CPU_RX_PKT_DATA0_t         CPU_RX_PKT_DATA0;              /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[2043];                 
  FPGA_IDP_DOWN_MY_MAC_HI_t                MY_MAC_HI;                     /* addr: 0x00000800 */
  ca_uint32_t                              rsrvd3[3];                    
  FPGA_IDP_DOWN_MY_MAC_LO_t                MY_MAC_LO;                     /* addr: 0x00000804 */
  ca_uint32_t                              rsrvd4[3];                    
  FPGA_IDP_DOWN_MY_ETH_TYPE_t              MY_ETH_TYPE;                   /* addr: 0x00000808 */
  ca_uint32_t                              rsrvd5[3];                    
  FPGA_IDP_DOWN_CNTL_t                     CNTL;                          /* addr: 0x0000080c */
  ca_uint32_t                              rsrvd6[3];                    
  FPGA_IDP_DOWN_CPURX_PKT_t                CPURX_PKT;                     /* addr: 0x00000810 */
  ca_uint32_t                              rsrvd7[3];                    
  FPGA_IDP_DOWN_RGMII_PATH_CTRL_t          RGMII_PATH_CTRL;               /* addr: 0x00000814 */
  ca_uint32_t                              rsrvd8[3];                    
  FPGA_IDP_DOWN_INT_t                      INT;                           /* addr: 0x00000818 */
  ca_uint32_t                              rsrvd9[3];                    
  FPGA_IDP_DOWN_INTE_t                     INTE;                          /* addr: 0x0000081c */
  ca_uint32_t                              rsrvd10[3];                   
  FPGA_IDP_DOWN_TO_REMOTE_CPU_PKT_COUNT_t  TO_REMOTE_CPU_PKT_COUNT;       /* addr: 0x00000820 */
  ca_uint32_t                              rsrvd11[3];                   
  FPGA_IDP_DOWN_TO_REMOTE_CPU_BYT_COUNT_t  TO_REMOTE_CPU_BYT_COUNT;       /* addr: 0x00000824 */
  ca_uint32_t                              rsrvd12[3];                   
  FPGA_IDP_DOWN_TO_XGE_PKT_COUNT_t         TO_XGE_PKT_COUNT;              /* addr: 0x00000828 */
  ca_uint32_t                              rsrvd13[3];                   
  FPGA_IDP_DOWN_TO_XGE_BYT_COUNT_t         TO_XGE_BYT_COUNT;              /* addr: 0x0000082c */
  ca_uint32_t                              rsrvd14[3];                   
  FPGA_IDP_DOWN_COUNTERS_ACCESS_t          COUNTERS_ACCESS;               /* addr: 0x00000830 */
  ca_uint32_t                              rsrvd15[3];                   
  FPGA_IDP_DOWN_COUNTERS_DATA1_t           COUNTERS_DATA1;                /* addr: 0x00000834 */
  ca_uint32_t                              rsrvd16[3];                   
  FPGA_IDP_DOWN_COUNTERS_DATA0_t           COUNTERS_DATA0;                /* addr: 0x00000838 */
  ca_uint32_t                              rsrvd17[3];                   
  FPGA_IDP_DOWN_CPU2LAN_CNTL_t             CPU2LAN_CNTL;                  /* addr: 0x0000083c */
  ca_uint32_t                              rsrvd18[3];                   
  FPGA_IDP_DOWN_CPU2LAN_PKT_t              CPU2LAN_PKT;                   /* addr: 0x00000840 */
  ca_uint32_t                              rsrvd19[3];                   
  FPGA_IDP_DOWN_CTRL_t                     CTRL;                          /* addr: 0x00000844 */
} APB4_FPGA_IDP_DOWN_t;


/*
 * FPGA_IDP_MEM
 */
        
#define FPGA_IDP_MEM_CPU2LAN_PKT_DATA1           0x52229000
#define FPGA_IDP_MEM_CPU2LAN_PKT_DATA1_STRIDE    8
#define FPGA_IDP_MEM_CPU2LAN_PKT_DATA1_COUNT     256
#define FPGA_IDP_MEM_CPU2LAN_PKT_DATA1_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data1                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_MEM_CPU2LAN_PKT_DATA1_t;


#define FPGA_IDP_MEM_CPU2LAN_PKT_DATA0           0x52229004
#define FPGA_IDP_MEM_CPU2LAN_PKT_DATA0_STRIDE    8
#define FPGA_IDP_MEM_CPU2LAN_PKT_DATA0_COUNT     256
#define FPGA_IDP_MEM_CPU2LAN_PKT_DATA0_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data0                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_MEM_CPU2LAN_PKT_DATA0_t;


#define FPGA_IDP_MEM_LAN2CPU_PKT_DATA1           0x52229800
#define FPGA_IDP_MEM_LAN2CPU_PKT_DATA1_STRIDE    8
#define FPGA_IDP_MEM_LAN2CPU_PKT_DATA1_COUNT     256
#define FPGA_IDP_MEM_LAN2CPU_PKT_DATA1_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t payload1             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_MEM_LAN2CPU_PKT_DATA1_t;


#define FPGA_IDP_MEM_LAN2CPU_PKT_DATA0           0x52229804
#define FPGA_IDP_MEM_LAN2CPU_PKT_DATA0_STRIDE    8
#define FPGA_IDP_MEM_LAN2CPU_PKT_DATA0_COUNT     256
#define FPGA_IDP_MEM_LAN2CPU_PKT_DATA0_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t payload0             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_MEM_LAN2CPU_PKT_DATA0_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* FPGA_IDP_MEM */
typedef struct {
  FPGA_IDP_MEM_CPU2LAN_PKT_DATA1_t         CPU2LAN_PKT_DATA1;             /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  FPGA_IDP_MEM_CPU2LAN_PKT_DATA0_t         CPU2LAN_PKT_DATA0;             /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[2043];                 
  FPGA_IDP_MEM_LAN2CPU_PKT_DATA1_t         LAN2CPU_PKT_DATA1;             /* addr: 0x00000800 */
  ca_uint32_t                              rsrvd3[3];                    
  FPGA_IDP_MEM_LAN2CPU_PKT_DATA0_t         LAN2CPU_PKT_DATA0;             /* addr: 0x00000804 */
} APB4_FPGA_IDP_MEM_t;


/*
 * FPGA_IDP_UP
 */
        
#define FPGA_IDP_UP_CPU_TX_PKT_DATA1             0x5222a000
#define FPGA_IDP_UP_CPU_TX_PKT_DATA1_STRIDE      8
#define FPGA_IDP_UP_CPU_TX_PKT_DATA1_COUNT       256
#define FPGA_IDP_UP_CPU_TX_PKT_DATA1_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data1                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_UP_CPU_TX_PKT_DATA1_t;


#define FPGA_IDP_UP_CPU_TX_PKT_DATA0             0x5222a004
#define FPGA_IDP_UP_CPU_TX_PKT_DATA0_STRIDE      8
#define FPGA_IDP_UP_CPU_TX_PKT_DATA0_COUNT       256
#define FPGA_IDP_UP_CPU_TX_PKT_DATA0_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data0                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_UP_CPU_TX_PKT_DATA0_t;


#define FPGA_IDP_UP_PKT_RPT_CNT0                 0x5222a800
#define FPGA_IDP_UP_PKT_RPT_CNT0_STRIDE          4
#define FPGA_IDP_UP_PKT_RPT_CNT0_COUNT           4
#define FPGA_IDP_UP_PKT_RPT_CNT0_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rpt_cnt0             :  8 ; /* bits 7:0 */
    ca_uint32_t rpt_cnt1             :  8 ; /* bits 15:8 */
    ca_uint32_t rpt_cnt2             :  8 ; /* bits 23:16 */
    ca_uint32_t rpt_cnt3             :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_UP_PKT_RPT_CNT0_t;

            
#define FPGA_IDP_UP_PKT_GEN_VLD                  0x5222a810
#define FPGA_IDP_UP_PKT_GEN_VLD_dft              0x0002ffff

typedef volatile union {
  struct {
    ca_uint32_t pkt_vld              : 16 ; /* bits 15:0 */
    ca_uint32_t loop_cnt             : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_UP_PKT_GEN_VLD_t;


#define FPGA_IDP_UP_PKT_GEN_CNTL                 0x5222a814
#define FPGA_IDP_UP_PKT_GEN_CNTL_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t enable               :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_UP_PKT_GEN_CNTL_t;


#define FPGA_IDP_UP_MY_MAC_HI                    0x5222a818
#define FPGA_IDP_UP_MY_MAC_HI_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac_da_hi            : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_UP_MY_MAC_HI_t;


#define FPGA_IDP_UP_MY_MAC_LO                    0x5222a81c
#define FPGA_IDP_UP_MY_MAC_LO_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac_da_lo            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_UP_MY_MAC_LO_t;


#define FPGA_IDP_UP_MAC_SA_HI                    0x5222a820
#define FPGA_IDP_UP_MAC_SA_HI_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac_sa_hi            : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_UP_MAC_SA_HI_t;


#define FPGA_IDP_UP_MAC_SA_LO                    0x5222a824
#define FPGA_IDP_UP_MAC_SA_LO_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac_sa_lo            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_UP_MAC_SA_LO_t;


#define FPGA_IDP_UP_MY_PKT_TP                    0x5222a828
#define FPGA_IDP_UP_MY_PKT_TP_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pt                   : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_UP_MY_PKT_TP_t;


#define FPGA_IDP_UP_MY_LLID                      0x5222a82c
#define FPGA_IDP_UP_MY_LLID_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_UP_MY_LLID_t;


#define FPGA_IDP_UP_PKT_HDR_A_CNTL               0x5222a830
#define FPGA_IDP_UP_PKT_HDR_A_CNTL_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t fixed_hdr_a          :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_UP_PKT_HDR_A_CNTL_t;


#define FPGA_IDP_UP_PKT_HDR_A_HI                 0x5222a834
#define FPGA_IDP_UP_PKT_HDR_A_HI_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hdr_a_hi             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_UP_PKT_HDR_A_HI_t;


#define FPGA_IDP_UP_PKT_HDR_A_LO                 0x5222a838
#define FPGA_IDP_UP_PKT_HDR_A_LO_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hdr_a_lo             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_UP_PKT_HDR_A_LO_t;


#define FPGA_IDP_UP_CPU_CNTL                     0x5222a83c
#define FPGA_IDP_UP_CPU_CNTL_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cpu_write_done       :  1 ; /* bits 0:0 */
    ca_uint32_t count_clear          :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_UP_CPU_CNTL_t;


#define FPGA_IDP_UP_CPUTX_PKT                    0x5222a840
#define FPGA_IDP_UP_CPUTX_PKT_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt_size             : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_UP_CPUTX_PKT_t;


#define FPGA_IDP_UP_INT                          0x5222a844
#define FPGA_IDP_UP_INT_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t xge_sop_drop         :  1 ; /* bits 0:0 */
    ca_uint32_t xge_eop_drop         :  1 ; /* bits 1:1 */
    ca_uint32_t xge_packet_buffer_over_run :  1 ; /* bits 2:2 */
    ca_uint32_t xge_voqbp_drop       :  1 ; /* bits 3:3 */
    ca_uint32_t rgmii_sop_drop       :  1 ; /* bits 4:4 */
    ca_uint32_t rgmii_eop_drop       :  1 ; /* bits 5:5 */
    ca_uint32_t rgmii_packet_buffer_over_run :  1 ; /* bits 6:6 */
    ca_uint32_t rgmii_voqbp_drop     :  1 ; /* bits 7:7 */
    ca_uint32_t lan2cpu_rx_pkt_rdy   :  1 ; /* bits 8:8 */
    ca_uint32_t lan2cpu_receive_pkt_err :  1 ; /* bits 9:9 */
    ca_uint32_t lan2cpu_oversize     :  1 ; /* bits 10:10 */
    ca_uint32_t lan2cpu_pkt_drop     :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_UP_INT_t;


#define FPGA_IDP_UP_INTE                         0x5222a848
#define FPGA_IDP_UP_INTE_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t xge_sop_dropE        :  1 ; /* bits 0:0 */
    ca_uint32_t xge_eop_dropE        :  1 ; /* bits 1:1 */
    ca_uint32_t xge_packet_buffer_over_runE :  1 ; /* bits 2:2 */
    ca_uint32_t xge_voqbp_dropE      :  1 ; /* bits 3:3 */
    ca_uint32_t rgmii_sop_dropE      :  1 ; /* bits 4:4 */
    ca_uint32_t rgmii_eop_dropE      :  1 ; /* bits 5:5 */
    ca_uint32_t rgmii_packet_buffer_over_runE :  1 ; /* bits 6:6 */
    ca_uint32_t rgmii_voqbp_dropE    :  1 ; /* bits 7:7 */
    ca_uint32_t lan2cpu_rx_pkt_rdyE  :  1 ; /* bits 8:8 */
    ca_uint32_t lan2cpu_receive_pkt_errE :  1 ; /* bits 9:9 */
    ca_uint32_t lan2cpu_oversizeE    :  1 ; /* bits 10:10 */
    ca_uint32_t lan2cpu_pkt_dropE    :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_UP_INTE_t;


#define FPGA_IDP_UP_XGE_DROP_CNT                 0x5222a84c
#define FPGA_IDP_UP_XGE_DROP_CNT_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tail                 : 16 ; /* bits 15:0 */
    ca_uint32_t head                 : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_UP_XGE_DROP_CNT_t;


#define FPGA_IDP_UP_RGMII_DROP_CNT               0x5222a850
#define FPGA_IDP_UP_RGMII_DROP_CNT_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tail                 : 16 ; /* bits 15:0 */
    ca_uint32_t head                 : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_UP_RGMII_DROP_CNT_t;


#define FPGA_IDP_UP_XGE_PKT_CNT                  0x5222a854
#define FPGA_IDP_UP_XGE_PKT_CNT_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t count                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_UP_XGE_PKT_CNT_t;


#define FPGA_IDP_UP_RGMII_PKT_CNT                0x5222a858
#define FPGA_IDP_UP_RGMII_PKT_CNT_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t count                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_UP_RGMII_PKT_CNT_t;


#define FPGA_IDP_UP_PKT_MEM_ACCESS               0x5222a85c
#define FPGA_IDP_UP_PKT_MEM_ACCESS_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ADDR                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_UP_PKT_MEM_ACCESS_t;


#define FPGA_IDP_UP_PKT_MEM_DATA1                0x5222a860
#define FPGA_IDP_UP_PKT_MEM_DATA1_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_UP_PKT_MEM_DATA1_t;


#define FPGA_IDP_UP_PKT_MEM_DATA0                0x5222a864
#define FPGA_IDP_UP_PKT_MEM_DATA0_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_UP_PKT_MEM_DATA0_t;


#define FPGA_IDP_UP_LAN2CPURX_PKT                0x5222a868
#define FPGA_IDP_UP_LAN2CPURX_PKT_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt_size             : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_UP_LAN2CPURX_PKT_t;


#define FPGA_IDP_UP_LAN2CPU_CNTL                 0x5222a86c
#define FPGA_IDP_UP_LAN2CPU_CNTL_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cpu_read_done        :  1 ; /* bits 0:0 */
    ca_uint32_t count_clear          :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_UP_LAN2CPU_CNTL_t;


#define FPGA_IDP_UP_CTRL                         0x5222a870
#define FPGA_IDP_UP_CTRL_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t xge_voqbp_drop_en    :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t rgmii_voqbp_drop_en  :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd2               : 11 ;
    ca_uint32_t pop_vlan_en          :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd3               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_UP_CTRL_t;


#define FPGA_IDP_UP_XGE_DROP_CNT1                0x5222a874
#define FPGA_IDP_UP_XGE_DROP_CNT1_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t voqbp                : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_UP_XGE_DROP_CNT1_t;


#define FPGA_IDP_UP_RGMII_DROP_CNT1              0x5222a878
#define FPGA_IDP_UP_RGMII_DROP_CNT1_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t voqbp                : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_IDP_UP_RGMII_DROP_CNT1_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* FPGA_IDP_UP */
typedef struct {
  FPGA_IDP_UP_CPU_TX_PKT_DATA1_t           CPU_TX_PKT_DATA1;              /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  FPGA_IDP_UP_CPU_TX_PKT_DATA0_t           CPU_TX_PKT_DATA0;              /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[2043];                 
  FPGA_IDP_UP_PKT_RPT_CNT0_t               PKT_RPT_CNT0;                  /* addr: 0x00000800 */
  ca_uint32_t                              rsrvd3[15];                   
  FPGA_IDP_UP_PKT_GEN_VLD_t                PKT_GEN_VLD;                   /* addr: 0x00000810 */
  ca_uint32_t                              rsrvd4[3];                    
  FPGA_IDP_UP_PKT_GEN_CNTL_t               PKT_GEN_CNTL;                  /* addr: 0x00000814 */
  ca_uint32_t                              rsrvd5[3];                    
  FPGA_IDP_UP_MY_MAC_HI_t                  MY_MAC_HI;                     /* addr: 0x00000818 */
  ca_uint32_t                              rsrvd6[3];                    
  FPGA_IDP_UP_MY_MAC_LO_t                  MY_MAC_LO;                     /* addr: 0x0000081c */
  ca_uint32_t                              rsrvd7[3];                    
  FPGA_IDP_UP_MAC_SA_HI_t                  MAC_SA_HI;                     /* addr: 0x00000820 */
  ca_uint32_t                              rsrvd8[3];                    
  FPGA_IDP_UP_MAC_SA_LO_t                  MAC_SA_LO;                     /* addr: 0x00000824 */
  ca_uint32_t                              rsrvd9[3];                    
  FPGA_IDP_UP_MY_PKT_TP_t                  MY_PKT_TP;                     /* addr: 0x00000828 */
  ca_uint32_t                              rsrvd10[3];                   
  FPGA_IDP_UP_MY_LLID_t                    MY_LLID;                       /* addr: 0x0000082c */
  ca_uint32_t                              rsrvd11[3];                   
  FPGA_IDP_UP_PKT_HDR_A_CNTL_t             PKT_HDR_A_CNTL;                /* addr: 0x00000830 */
  ca_uint32_t                              rsrvd12[3];                   
  FPGA_IDP_UP_PKT_HDR_A_HI_t               PKT_HDR_A_HI;                  /* addr: 0x00000834 */
  ca_uint32_t                              rsrvd13[3];                   
  FPGA_IDP_UP_PKT_HDR_A_LO_t               PKT_HDR_A_LO;                  /* addr: 0x00000838 */
  ca_uint32_t                              rsrvd14[3];                   
  FPGA_IDP_UP_CPU_CNTL_t                   CPU_CNTL;                      /* addr: 0x0000083c */
  ca_uint32_t                              rsrvd15[3];                   
  FPGA_IDP_UP_CPUTX_PKT_t                  CPUTX_PKT;                     /* addr: 0x00000840 */
  ca_uint32_t                              rsrvd16[3];                   
  FPGA_IDP_UP_INT_t                        INT;                           /* addr: 0x00000844 */
  ca_uint32_t                              rsrvd17[3];                   
  FPGA_IDP_UP_INTE_t                       INTE;                          /* addr: 0x00000848 */
  ca_uint32_t                              rsrvd18[3];                   
  FPGA_IDP_UP_XGE_DROP_CNT_t               XGE_DROP_CNT;                  /* addr: 0x0000084c */
  ca_uint32_t                              rsrvd19[3];                   
  FPGA_IDP_UP_RGMII_DROP_CNT_t             RGMII_DROP_CNT;                /* addr: 0x00000850 */
  ca_uint32_t                              rsrvd20[3];                   
  FPGA_IDP_UP_XGE_PKT_CNT_t                XGE_PKT_CNT;                   /* addr: 0x00000854 */
  ca_uint32_t                              rsrvd21[3];                   
  FPGA_IDP_UP_RGMII_PKT_CNT_t              RGMII_PKT_CNT;                 /* addr: 0x00000858 */
  ca_uint32_t                              rsrvd22[3];                   
  FPGA_IDP_UP_PKT_MEM_ACCESS_t             PKT_MEM_ACCESS;                /* addr: 0x0000085c */
  ca_uint32_t                              rsrvd23[3];                   
  FPGA_IDP_UP_PKT_MEM_DATA1_t              PKT_MEM_DATA1;                 /* addr: 0x00000860 */
  ca_uint32_t                              rsrvd24[3];                   
  FPGA_IDP_UP_PKT_MEM_DATA0_t              PKT_MEM_DATA0;                 /* addr: 0x00000864 */
  ca_uint32_t                              rsrvd25[3];                   
  FPGA_IDP_UP_LAN2CPURX_PKT_t              LAN2CPURX_PKT;                 /* addr: 0x00000868 */
  ca_uint32_t                              rsrvd26[3];                   
  FPGA_IDP_UP_LAN2CPU_CNTL_t               LAN2CPU_CNTL;                  /* addr: 0x0000086c */
  ca_uint32_t                              rsrvd27[3];                   
  FPGA_IDP_UP_CTRL_t                       CTRL;                          /* addr: 0x00000870 */
  ca_uint32_t                              rsrvd28[3];                   
  FPGA_IDP_UP_XGE_DROP_CNT1_t              XGE_DROP_CNT1;                 /* addr: 0x00000874 */
  ca_uint32_t                              rsrvd29[3];                   
  FPGA_IDP_UP_RGMII_DROP_CNT1_t            RGMII_DROP_CNT1;               /* addr: 0x00000878 */
} APB4_FPGA_IDP_UP_t;


/*
 * FPGA_RGMII
 */
        
#define FPGA_RGMII_PORT_STATIC_CFG               0x5222b000
#define FPGA_RGMII_PORT_STATIC_CFG_dft           0x00030203

typedef volatile union {
  struct {
    ca_uint32_t int_cfg              :  4 ; /* bits 3:0 */
    ca_uint32_t phy_mode             :  1 ; /* bits 4:4 */
    ca_uint32_t rmii_clksrc          :  1 ; /* bits 5:5 */
    ca_uint32_t inv_clk_in           :  1 ; /* bits 6:6 */
    ca_uint32_t inv_clk_out          :  1 ; /* bits 7:7 */
    ca_uint32_t inv_rxclk_out        :  1 ; /* bits 8:8 */
    ca_uint32_t tx_use_gefifo        :  1 ; /* bits 9:9 */
    ca_uint32_t smii_tx_stat         :  1 ; /* bits 10:10 */
    ca_uint32_t crs_polarity         :  1 ; /* bits 11:11 */
    ca_uint32_t lpbk_mode            :  2 ; /* bits 13:12 */
    ca_uint32_t gmii_like_half_duplex_en :  1 ; /* bits 14:14 */
    ca_uint32_t sup_tx_to_rx_lpbk_data :  1 ; /* bits 15:15 */
    ca_uint32_t mac_rst              :  1 ; /* bits 16:16 */
    ca_uint32_t dbg0                 :  1 ; /* bits 17:17 */
    ca_uint32_t dbg1                 :  1 ; /* bits 18:18 */
    ca_uint32_t dbg2                 :  1 ; /* bits 19:19 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t mac_addr6            :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_PORT_STATIC_CFG_t;

#define     int_cfg_GMII_GE                               0x0
#define     int_cfg_MII                                   0x1
#define     int_cfg_RGMII_GE                              0x2
#define     int_cfg_RGMII_FE                              0x3

#define FPGA_RGMII_PORT_GLB_CFG                  0x5222b004
#define FPGA_RGMII_PORT_GLB_CFG_dft              0x00000004

typedef volatile union {
  struct {
    ca_uint32_t speed                :  1 ; /* bits 0:0 */
    ca_uint32_t duplex               :  1 ; /* bits 1:1 */
    ca_uint32_t link_status          :  1 ; /* bits 2:2 */
    ca_uint32_t link_stat_mask       :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t power_dwn_rx         :  1 ; /* bits 11:11 */
    ca_uint32_t power_dwn_tx         :  1 ; /* bits 12:12 */
    ca_uint32_t tx_intf_lp_time      :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd2               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_PORT_GLB_CFG_t;


#define FPGA_RGMII_RXMAC_CFG                     0x5222b008
#define FPGA_RGMII_RXMAC_CFG_dft                 0x00000101

typedef volatile union {
  struct {
    ca_uint32_t rx_en                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t rx_flow_disable      :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t rx_flow_to_tx_en     :  1 ; /* bits 12:12 */
    ca_uint32_t rx_pfc_disable       :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd3               : 15 ;
    ca_uint32_t send_pg_data         :  1 ; /* bits 29:29 */
    ca_uint32_t rsrvd4               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_RXMAC_CFG_t;


#define FPGA_RGMII_RXMAC_WOL_CFG                 0x5222b00c
#define FPGA_RGMII_RXMAC_WOL_CFG_dft             0x00000f00

typedef volatile union {
  struct {
    ca_uint32_t wol_pkt_det_en       :  1 ; /* bits 0:0 */
    ca_uint32_t wol_chk_da           :  2 ; /* bits 2:1 */
    ca_uint32_t wol_ign_err          :  1 ; /* bits 3:3 */
    ca_uint32_t wol_secure_on        :  1 ; /* bits 4:4 */
    ca_uint32_t wol_passwd_cnt       :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t wol_mac_adr_cnt      :  6 ; /* bits 13:8 */
    ca_uint32_t rsrvd2               : 17 ;
    ca_uint32_t wol_wake_on_any_pkt  :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_RXMAC_WOL_CFG_t;


#define FPGA_RGMII_MAC_STATUS                    0x5222b010
#define FPGA_RGMII_MAC_STATUS_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rcv_speed            :  2 ; /* bits 1:0 */
    ca_uint32_t rcv_duplex           :  1 ; /* bits 2:2 */
    ca_uint32_t rcv_lnk_stat         :  1 ; /* bits 3:3 */
    ca_uint32_t rx_lpi_detect        :  1 ; /* bits 4:4 */
    ca_uint32_t lpi_assert           :  1 ; /* bits 5:5 */
    ca_uint32_t lpi_mac_dis          :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_MAC_STATUS_t;


#define FPGA_RGMII_TXMAC_CFG                     0x5222b014
#define FPGA_RGMII_TXMAC_CFG_dft                 0x14019901

typedef volatile union {
  struct {
    ca_uint32_t tx_en                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t mac_crc_calc_en      :  1 ; /* bits 8:8 */
    ca_uint32_t tx_ipg_sel           :  3 ; /* bits 11:9 */
    ca_uint32_t tx_flow_disable      :  1 ; /* bits 12:12 */
    ca_uint32_t tx_drain             :  1 ; /* bits 13:13 */
    ca_uint32_t tx_pfc_disable       :  1 ; /* bits 14:14 */
    ca_uint32_t tx_pau_sel           :  2 ; /* bits 16:15 */
    ca_uint32_t rsrvd2               :  9 ;
    ca_uint32_t tx_auto_xon          :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t pass_thru_hdr        :  1 ; /* bits 28:28 */
    ca_uint32_t rsrvd4               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_TXMAC_CFG_t;


#define FPGA_RGMII_ETH_TXMAC_PAUSE_TIMER_CFG0    0x5222b018
#define FPGA_RGMII_ETH_TXMAC_PAUSE_TIMER_CFG0_dft 0x00ff00ff

typedef volatile union {
  struct {
    ca_uint32_t txpfc_time_0         : 16 ; /* bits 15:0 */
    ca_uint32_t txpfc_time_1         : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_ETH_TXMAC_PAUSE_TIMER_CFG0_t;


#define FPGA_RGMII_ETH_TXMAC_PAUSE_TIMER_CFG1    0x5222b01c
#define FPGA_RGMII_ETH_TXMAC_PAUSE_TIMER_CFG1_dft 0x00ff00ff

typedef volatile union {
  struct {
    ca_uint32_t txpfc_time_2         : 16 ; /* bits 15:0 */
    ca_uint32_t txpfc_time_3         : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_ETH_TXMAC_PAUSE_TIMER_CFG1_t;


#define FPGA_RGMII_ETH_TXMAC_PAUSE_TIMER_CFG2    0x5222b020
#define FPGA_RGMII_ETH_TXMAC_PAUSE_TIMER_CFG2_dft 0x00ff00ff

typedef volatile union {
  struct {
    ca_uint32_t txpfc_time_4         : 16 ; /* bits 15:0 */
    ca_uint32_t txpfc_time_5         : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_ETH_TXMAC_PAUSE_TIMER_CFG2_t;


#define FPGA_RGMII_ETH_TXMAC_PAUSE_TIMER_CFG3    0x5222b024
#define FPGA_RGMII_ETH_TXMAC_PAUSE_TIMER_CFG3_dft 0x00ff00ff

typedef volatile union {
  struct {
    ca_uint32_t txpfc_time_6         : 16 ; /* bits 15:0 */
    ca_uint32_t txpfc_time_7         : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_ETH_TXMAC_PAUSE_TIMER_CFG3_t;


#define FPGA_RGMII_EEE_LPI_CFG0                  0x5222b028
#define FPGA_RGMII_EEE_LPI_CFG0_dft              0x01387000

typedef volatile union {
  struct {
    ca_uint32_t tx_eee_enable        :  1 ; /* bits 0:0 */
    ca_uint32_t cpu_lpi_deassert     :  1 ; /* bits 1:1 */
    ca_uint32_t stop_txclk_on_lpi    :  1 ; /* bits 2:2 */
    ca_uint32_t lpi_data_mode        :  1 ; /* bits 3:3 */
    ca_uint32_t lpi_mode_te          :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t txfifo_empty_cnt     : 20 ; /* bits 31:12 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_EEE_LPI_CFG0_t;


#define FPGA_RGMII_EEE_LPI_CFG1                  0x5222b02c
#define FPGA_RGMII_EEE_LPI_CFG1_dft              0x0000071b

typedef volatile union {
  struct {
    ca_uint32_t lpi_min_assert_cnt   : 20 ; /* bits 19:0 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_EEE_LPI_CFG1_t;


#define FPGA_RGMII_EEE_LPI_CFG2                  0x5222b030
#define FPGA_RGMII_EEE_LPI_CFG2_dft              0x000000a4

typedef volatile union {
  struct {
    ca_uint32_t lpi_min_wakeup_cnt   : 20 ; /* bits 19:0 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_EEE_LPI_CFG2_t;


#define FPGA_RGMII_EEE_LPI_CFG3                  0x5222b034
#define FPGA_RGMII_EEE_LPI_CFG3_dft              0x0f000005

typedef volatile union {
  struct {
    ca_uint32_t lpi_mac_dis_wait_cnt : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t stop_txclk_en_cnt    : 12 ; /* bits 31:20 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_EEE_LPI_CFG3_t;


#define FPGA_RGMII_RX_CNTRL_CFG                  0x5222b038
#define FPGA_RGMII_RX_CNTRL_CFG_dft              0x08000400

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t ff_overrun_drop_dis  :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t crc_drop_dis         :  1 ; /* bits 4:4 */
    ca_uint32_t ovr_drop_dis         :  1 ; /* bits 5:5 */
    ca_uint32_t runt_drop_dis        :  1 ; /* bits 6:6 */
    ca_uint32_t flow_drop_dis        :  1 ; /* bits 7:7 */
    ca_uint32_t ukopcode_drop_dis    :  1 ; /* bits 8:8 */
    ca_uint32_t oam_drop_dis         :  1 ; /* bits 9:9 */
    ca_uint32_t linkstat_drop_dis    :  1 ; /* bits 10:10 */
    ca_uint32_t pfc_drop_dis         :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd3               :  4 ;
    ca_uint32_t rxctrl_byp_dpid      :  6 ; /* bits 21:16 */
    ca_uint32_t rsrvd4               :  2 ;
    ca_uint32_t rxctrl_byp_cos       :  3 ; /* bits 26:24 */
    ca_uint32_t rxctrl_byp_dpq       :  1 ; /* bits 27:27 */
    ca_uint32_t rxctrl_byp_en        :  1 ; /* bits 28:28 */
    ca_uint32_t rsrvd5               :  1 ;
    ca_uint32_t rxctrl_byp_mir       :  1 ; /* bits 30:30 */
    ca_uint32_t rxctrl_byp_ndrp      :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_RX_CNTRL_CFG_t;


#define FPGA_RGMII_TXFIFO_THLD_CFG               0x5222b03c
#define FPGA_RGMII_TXFIFO_THLD_CFG_dft           0x00280064

typedef volatile union {
  struct {
    ca_uint32_t high_thld            : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               :  6 ;
    ca_uint32_t low_thld             : 10 ; /* bits 25:16 */
    ca_uint32_t rsrvd2               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_TXFIFO_THLD_CFG_t;


#define FPGA_RGMII_PG_CFG0                       0x5222b040
#define FPGA_RGMII_PG_CFG0_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pg_da6               :  8 ; /* bits 7:0 */
    ca_uint32_t pg_sa6               :  8 ; /* bits 15:8 */
    ca_uint32_t pg_type              : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_PG_CFG0_t;


#define FPGA_RGMII_PG_CFG1                       0x5222b044
#define FPGA_RGMII_PG_CFG1_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pg_vlan1             : 16 ; /* bits 15:0 */
    ca_uint32_t pg_vlan2             : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_PG_CFG1_t;


#define FPGA_RGMII_PG_CNTRL_CFG                  0x5222b048
#define FPGA_RGMII_PG_CNTRL_CFG_dft              0x08018000

typedef volatile union {
  struct {
    ca_uint32_t pg_en                :  1 ; /* bits 0:0 */
    ca_uint32_t pg_fixedcount        :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t pg_fixedlen          :  1 ; /* bits 4:4 */
    ca_uint32_t pg_insvlan2          :  1 ; /* bits 5:5 */
    ca_uint32_t pg_insvlan1          :  1 ; /* bits 6:6 */
    ca_uint32_t pg_instype           :  1 ; /* bits 7:7 */
    ca_uint32_t pg_insseqnum         :  1 ; /* bits 8:8 */
    ca_uint32_t pg_invpat            :  1 ; /* bits 9:9 */
    ca_uint32_t pg_insfixpattern     :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd2               :  4 ;
    ca_uint32_t pg_linerate          :  9 ; /* bits 23:15 */
    ca_uint32_t pg_ipg               :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_PG_CNTRL_CFG_t;


#define FPGA_RGMII_PC_CFG1                       0x5222b04c
#define FPGA_RGMII_PC_CFG1_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pc_da6               :  8 ; /* bits 7:0 */
    ca_uint32_t pc_sa6               :  8 ; /* bits 15:8 */
    ca_uint32_t pc_type              : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_PC_CFG1_t;


#define FPGA_RGMII_PC_CFG2                       0x5222b050
#define FPGA_RGMII_PC_CFG2_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pc_vlan1             : 16 ; /* bits 15:0 */
    ca_uint32_t pc_vlan2             : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_PC_CFG2_t;


#define FPGA_RGMII_PC_CNTRL                      0x5222b054
#define FPGA_RGMII_PC_CNTRL_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pc_en                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t pc_fixedlen          :  1 ; /* bits 4:4 */
    ca_uint32_t pc_expvlan2          :  1 ; /* bits 5:5 */
    ca_uint32_t pc_expvlan1          :  1 ; /* bits 6:6 */
    ca_uint32_t pc_exptype           :  1 ; /* bits 7:7 */
    ca_uint32_t pc_expseqnum         :  1 ; /* bits 8:8 */
    ca_uint32_t pc_invpat            :  1 ; /* bits 9:9 */
    ca_uint32_t pc_expfixpattern     :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd2               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_PC_CNTRL_t;


#define FPGA_RGMII_PC_STAT                       0x5222b058
#define FPGA_RGMII_PC_STAT_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pc_dchkstatus        :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_PC_STAT_t;


#define FPGA_RGMII_DEBUG_1                       0x5222b05c
#define FPGA_RGMII_DEBUG_1_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hd_backoff_cnt       : 10 ; /* bits 9:0 */
    ca_uint32_t hd_backoff_dbg       :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd1               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_DEBUG_1_t;


#define FPGA_RGMII_TX_DRAINCNT                   0x5222b060
#define FPGA_RGMII_TX_DRAINCNT_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t CNT                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_TX_DRAINCNT_t;


#define FPGA_RGMII_SPARE                         0x5222b064
#define FPGA_RGMII_SPARE_dft                     0x0000ff00

typedef volatile union {
  struct {
    ca_uint32_t VALUE                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_SPARE_t;


#define FPGA_RGMII_SPARESAMPLE                   0x5222b068
#define FPGA_RGMII_SPARESAMPLE_dft               0x0000ff00

typedef volatile union {
  struct {
    ca_uint32_t VALUE                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_SPARESAMPLE_t;


#define FPGA_RGMII_MAC_ADDR_CFG1                 0x5222b06c
#define FPGA_RGMII_MAC_ADDR_CFG1_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac_addr1            : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_MAC_ADDR_CFG1_t;


#define FPGA_RGMII_MAC_ADDR_CFG0                 0x5222b070
#define FPGA_RGMII_MAC_ADDR_CFG0_dft             0xff000001

typedef volatile union {
  struct {
    ca_uint32_t mac_addr0            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_MAC_ADDR_CFG0_t;


#define FPGA_RGMII_WOL_PASSWD1                   0x5222b074
#define FPGA_RGMII_WOL_PASSWD1_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wol_passwd1          : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_WOL_PASSWD1_t;


#define FPGA_RGMII_WOL_PASSWD0                   0x5222b078
#define FPGA_RGMII_WOL_PASSWD0_dft               0xff000055

typedef volatile union {
  struct {
    ca_uint32_t wol_passwd0          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_WOL_PASSWD0_t;


#define FPGA_RGMII_STATIC_CFG                    0x5222b07c
#define FPGA_RGMII_STATIC_CFG_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t p4_port_id           :  6 ; /* bits 5:0 */
    ca_uint32_t p4_rgmii_tx_clk_phase :  2 ; /* bits 7:6 */
    ca_uint32_t p4_rgmii_tx_data_order :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_STATIC_CFG_t;


#define FPGA_RGMII_PKT_LEN_CFG                   0x5222b080
#define FPGA_RGMII_PKT_LEN_CFG_dft               0x00402328

typedef volatile union {
  struct {
    ca_uint32_t max_pkt_size         : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t min_pkt_size         : 10 ; /* bits 25:16 */
    ca_uint32_t rsrvd2               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_PKT_LEN_CFG_t;


#define FPGA_RGMII_PKT_STOR_LEN_CFG              0x5222b084
#define FPGA_RGMII_PKT_STOR_LEN_CFG_dft          0x000023f0

typedef volatile union {
  struct {
    ca_uint32_t max_stor_pkt_len     : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_PKT_STOR_LEN_CFG_t;


#define FPGA_RGMII_RXMIB_PKTCNT                  0x5222b088
#define FPGA_RGMII_RXMIB_PKTCNT_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rxpktcnt             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_RXMIB_PKTCNT_t;


#define FPGA_RGMII_TXMIB_PKTCNT                  0x5222b08c
#define FPGA_RGMII_TXMIB_PKTCNT_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t txpktcnt             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_TXMIB_PKTCNT_t;


#define FPGA_RGMII_RXMIB_BYTECNT                 0x5222b090
#define FPGA_RGMII_RXMIB_BYTECNT_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rxbytecnt            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_RXMIB_BYTECNT_t;


#define FPGA_RGMII_TXMIB_BYTECNT                 0x5222b094
#define FPGA_RGMII_TXMIB_BYTECNT_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t txbytecnt            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_TXMIB_BYTECNT_t;


#define FPGA_RGMII_MIB_CNTL                      0x5222b098
#define FPGA_RGMII_MIB_CNTL_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t RXMIB_count_clear    :  1 ; /* bits 0:0 */
    ca_uint32_t TXMIB_count_clear    :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} FPGA_RGMII_MIB_CNTL_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* FPGA_RGMII */
typedef struct {
  FPGA_RGMII_PORT_STATIC_CFG_t             PORT_STATIC_CFG;               /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  FPGA_RGMII_PORT_GLB_CFG_t                PORT_GLB_CFG;                  /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  FPGA_RGMII_RXMAC_CFG_t                   RXMAC_CFG;                     /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  FPGA_RGMII_RXMAC_WOL_CFG_t               RXMAC_WOL_CFG;                 /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  FPGA_RGMII_MAC_STATUS_t                  MAC_STATUS;                    /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  FPGA_RGMII_TXMAC_CFG_t                   TXMAC_CFG;                     /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  FPGA_RGMII_ETH_TXMAC_PAUSE_TIMER_CFG0_t  ETH_TXMAC_PAUSE_TIMER_CFG0;    /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  FPGA_RGMII_ETH_TXMAC_PAUSE_TIMER_CFG1_t  ETH_TXMAC_PAUSE_TIMER_CFG1;    /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  FPGA_RGMII_ETH_TXMAC_PAUSE_TIMER_CFG2_t  ETH_TXMAC_PAUSE_TIMER_CFG2;    /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  FPGA_RGMII_ETH_TXMAC_PAUSE_TIMER_CFG3_t  ETH_TXMAC_PAUSE_TIMER_CFG3;    /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  FPGA_RGMII_EEE_LPI_CFG0_t                EEE_LPI_CFG0;                  /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  FPGA_RGMII_EEE_LPI_CFG1_t                EEE_LPI_CFG1;                  /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  FPGA_RGMII_EEE_LPI_CFG2_t                EEE_LPI_CFG2;                  /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  FPGA_RGMII_EEE_LPI_CFG3_t                EEE_LPI_CFG3;                  /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  FPGA_RGMII_RX_CNTRL_CFG_t                RX_CNTRL_CFG;                  /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  FPGA_RGMII_TXFIFO_THLD_CFG_t             TXFIFO_THLD_CFG;               /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  FPGA_RGMII_PG_CFG0_t                     PG_CFG0;                       /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  FPGA_RGMII_PG_CFG1_t                     PG_CFG1;                       /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  FPGA_RGMII_PG_CNTRL_CFG_t                PG_CNTRL_CFG;                  /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  FPGA_RGMII_PC_CFG1_t                     PC_CFG1;                       /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  FPGA_RGMII_PC_CFG2_t                     PC_CFG2;                       /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  FPGA_RGMII_PC_CNTRL_t                    PC_CNTRL;                      /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  FPGA_RGMII_PC_STAT_t                     PC_STAT;                       /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  FPGA_RGMII_DEBUG_1_t                     DEBUG_1;                       /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  FPGA_RGMII_TX_DRAINCNT_t                 TX_DRAINCNT;                   /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  FPGA_RGMII_SPARE_t                       SPARE;                         /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  FPGA_RGMII_SPARESAMPLE_t                 SPARESAMPLE;                   /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  FPGA_RGMII_MAC_ADDR_CFG1_t               MAC_ADDR_CFG1;                 /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  FPGA_RGMII_MAC_ADDR_CFG0_t               MAC_ADDR_CFG0;                 /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  FPGA_RGMII_WOL_PASSWD1_t                 WOL_PASSWD1;                   /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  FPGA_RGMII_WOL_PASSWD0_t                 WOL_PASSWD0;                   /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  FPGA_RGMII_STATIC_CFG_t                  STATIC_CFG;                    /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  FPGA_RGMII_PKT_LEN_CFG_t                 PKT_LEN_CFG;                   /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  FPGA_RGMII_PKT_STOR_LEN_CFG_t            PKT_STOR_LEN_CFG;              /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  FPGA_RGMII_RXMIB_PKTCNT_t                RXMIB_PKTCNT;                  /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  FPGA_RGMII_TXMIB_PKTCNT_t                TXMIB_PKTCNT;                  /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  FPGA_RGMII_RXMIB_BYTECNT_t               RXMIB_BYTECNT;                 /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  FPGA_RGMII_TXMIB_BYTECNT_t               TXMIB_BYTECNT;                 /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  FPGA_RGMII_MIB_CNTL_t                    MIB_CNTL;                      /* addr: 0x00000098 */
} APB4_FPGA_RGMII_t;


/*
 * FPGA_DP_RGMII
 */
      
  

/*
 * FPGA_XILINX_XGE
 */
      
  
    
  
        
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* APB4 */

typedef struct {
  ca_uint32_t                              rsrvd1[12288];                
  APB4_FPGA_FLASH_t                        FPGA_FLASH;                    /* addr: 0x00003000 */
  ca_uint32_t                              rsrvd2[3627];                 
  APB4_FPGA_PER_t                          FPGA_PER;                      /* addr: 0x00004000 */
  ca_uint32_t                              rsrvd3[15905];                
  APB4_FPGA_IDP_DOWN_t                     FPGA_IDP_DOWN;                 /* addr: 0x00008000 */
  ca_uint32_t                              rsrvd4[3037];                 
  APB4_FPGA_IDP_MEM_t                      FPGA_IDP_MEM;                  /* addr: 0x00009000 */
  ca_uint32_t                              rsrvd5[2559];                 
  APB4_FPGA_IDP_UP_t                       FPGA_IDP_UP;                   /* addr: 0x0000a000 */
  ca_uint32_t                              rsrvd6[3011];                 
  APB4_FPGA_RGMII_t                        FPGA_RGMII;                    /* addr: 0x0000b000 */
} APB4_t;


/*
 * APB1
 */
  
/*
 * EPON
 */
  
/*
 * epon_glb
 */
        
#define EPON_EPON_GLB_INTERRUPT                  0xd0030000
#define EPON_EPON_GLB_INTERRUPT_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t onu_epon_int         :  1 ; /* bits 0:0 */
    ca_uint32_t xgepn_int            :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t mpcp_int             :  1 ; /* bits 3:3 */
    ca_uint32_t onu_1pps_int         :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t onu_gps_int          :  1 ; /* bits 6:6 */
    ca_uint32_t extif_int            :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd3               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_INTERRUPT_t;


#define EPON_EPON_GLB_INTERRUPTE                 0xd0030004
#define EPON_EPON_GLB_INTERRUPTE_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t onu_epon_intE        :  1 ; /* bits 0:0 */
    ca_uint32_t xgepn_intE           :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t mpcp_intE            :  1 ; /* bits 3:3 */
    ca_uint32_t onu_1pps_intE        :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t onu_gps_intE         :  1 ; /* bits 6:6 */
    ca_uint32_t extif_intE           :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd3               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_INTERRUPTE_t;


#define EPON_EPON_GLB_ONU_EPON_INTERRUPT         0xd0030008
#define EPON_EPON_GLB_ONU_EPON_INTERRUPT_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t TX_NON_EMPTYi        :  1 ; /* bits 8:8 */
    ca_uint32_t TX_PKT_CUTi          :  1 ; /* bits 9:9 */
    ca_uint32_t TX_OVERRUNi          :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t ptp_eg_ltsI          :  1 ; /* bits 12:12 */
    ca_uint32_t TX_PACKET_UFLOWi     :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t BM_PON_TX_MONi       :  1 ; /* bits 15:15 */
    ca_uint32_t txoam_DONEi          :  1 ; /* bits 16:16 */
    ca_uint32_t rx_data_fifo_overflow :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd4               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_ONU_EPON_INTERRUPT_t;


#define EPON_EPON_GLB_ONU_EPON_INTERRUPTE        0xd003000c
#define EPON_EPON_GLB_ONU_EPON_INTERRUPTE_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t TX_NON_EMPTYiE       :  1 ; /* bits 8:8 */
    ca_uint32_t TX_PKT_CUTiE         :  1 ; /* bits 9:9 */
    ca_uint32_t TX_OVERRUNiE         :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t ptp_eg_ltsIE         :  1 ; /* bits 12:12 */
    ca_uint32_t TX_PACKET_UFLOWiE    :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t BM_PON_TX_MONiE      :  1 ; /* bits 15:15 */
    ca_uint32_t txoam_DONEiE         :  1 ; /* bits 16:16 */
    ca_uint32_t rx_data_fifo_overflowE :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd4               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_ONU_EPON_INTERRUPTE_t;


#define EPON_EPON_GLB_EPON_STATUS                0xd0030010
#define EPON_EPON_GLB_EPON_STATUS_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sigloss              :  1 ; /* bits 0:0 */
    ca_uint32_t pcs_sync_xg          :  1 ; /* bits 1:1 */
    ca_uint32_t pcs_sync_1g          :  1 ; /* bits 2:2 */
    ca_uint32_t ethernet_mode        :  1 ; /* bits 3:3 */
    ca_uint32_t datapath_speed       :  2 ; /* bits 5:4 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_EPON_STATUS_t;


#define EPON_EPON_GLB_STATIC_CFG                 0xd0030014
#define EPON_EPON_GLB_STATIC_CFG_dft             0xcc100c00

typedef volatile union {
  struct {
    ca_uint32_t sigloss_polarity     :  1 ; /* bits 0:0 */
    ca_uint32_t laser_always_on      :  1 ; /* bits 1:1 */
    ca_uint32_t laser_tx_polarity    :  1 ; /* bits 2:2 */
    ca_uint32_t bc_llid_sel          :  1 ; /* bits 3:3 */
    ca_uint32_t txarb_mpfifo_rst_ctrl :  2 ; /* bits 5:4 */
    ca_uint32_t txarb_datfifo_rst_ctrl :  2 ; /* bits 7:6 */
    ca_uint32_t tx_ipg               :  4 ; /* bits 11:8 */
    ca_uint32_t tx_pause_sel_te      :  1 ; /* bits 12:12 */
    ca_uint32_t tx_pause_sel_l2te    :  1 ; /* bits 13:13 */
    ca_uint32_t tx_pause_sel_rxmux   :  1 ; /* bits 14:14 */
    ca_uint32_t tx_pause_sel_sw      :  1 ; /* bits 15:15 */
    ca_uint32_t sw_tx_pause          :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t dis_pdc_thrtl        :  1 ; /* bits 20:20 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t tx_dat_ipg           :  4 ; /* bits 27:24 */
    ca_uint32_t tx_oam_ipg           :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_STATIC_CFG_t;


#define EPON_EPON_GLB_XGEPN_MAC_ADDR_H           0xd0030018
#define EPON_EPON_GLB_XGEPN_MAC_ADDR_H_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_XGEPN_MAC_ADDR_H_t;


#define EPON_EPON_GLB_XGEPN_MAC_ADDR_L           0xd003001c
#define EPON_EPON_GLB_XGEPN_MAC_ADDR_L_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_XGEPN_MAC_ADDR_L_t;


#define EPON_EPON_GLB_CORESEC10_CFG              0xd0030020
#define EPON_EPON_GLB_CORESEC10_CFG_dft          0x0000000f

typedef volatile union {
  struct {
    ca_uint32_t algo_sel             :  2 ; /* bits 1:0 */
    ca_uint32_t tx_algo_sel          :  2 ; /* bits 3:2 */
    ca_uint32_t tx_IvSa_sel          :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_CORESEC10_CFG_t;


#define EPON_EPON_GLB_XGPCS_FEC_CFG              0xd0030024
#define EPON_EPON_GLB_XGPCS_FEC_CFG_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_off               :  1 ; /* bits 0:0 */
    ca_uint32_t tx_win_ctrl          :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t rx_mode              :  2 ; /* bits 5:4 */
    ca_uint32_t rsrvd2               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_XGPCS_FEC_CFG_t;


#define EPON_EPON_GLB_XGPCS_FEC_RXMODE_ST        0xd0030028
#define EPON_EPON_GLB_XGPCS_FEC_RXMODE_ST_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t misc                 : 18 ; /* bits 17:0 */
    ca_uint32_t rsrvd1               : 13 ;
    ca_uint32_t disable              :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_XGPCS_FEC_RXMODE_ST_t;


#define EPON_EPON_GLB_XGPCS_BD_pattern_fecless2  0xd003002c
#define EPON_EPON_GLB_XGPCS_BD_pattern_fecless2_dft 0x00000001

typedef volatile union {
  struct {
    ca_uint32_t val2                 :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_XGPCS_BD_pattern_fecless2_t;


#define EPON_EPON_GLB_XGPCS_BD_pattern_fecless1  0xd0030030
#define EPON_EPON_GLB_XGPCS_BD_pattern_fecless1_dft 0xb92f1a54

typedef volatile union {
  struct {
    ca_uint32_t val1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_XGPCS_BD_pattern_fecless1_t;


#define EPON_EPON_GLB_XGPCS_BD_pattern_fecless0  0xd0030034
#define EPON_EPON_GLB_XGPCS_BD_pattern_fecless0_dft 0x2c192eba

typedef volatile union {
  struct {
    ca_uint32_t val0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_XGPCS_BD_pattern_fecless0_t;


#define EPON_EPON_GLB_SFI64_KSDS32_XFER          0xd0030038
#define EPON_EPON_GLB_SFI64_KSDS32_XFER_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t rx_swap              :  1 ; /* bits 2:2 */
    ca_uint32_t tx_swap              :  1 ; /* bits 3:3 */
    ca_uint32_t rx_swap_dw           :  1 ; /* bits 4:4 */
    ca_uint32_t tx_swap_dw           :  1 ; /* bits 5:5 */
    ca_uint32_t rx_swap_dw_all       :  1 ; /* bits 6:6 */
    ca_uint32_t tx_swap_dw_all       :  1 ; /* bits 7:7 */
    ca_uint32_t debug_bus_sel        :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd2               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_SFI64_KSDS32_XFER_t;


#define EPON_EPON_GLB_PTP_CFG                    0xd003003c
#define EPON_EPON_GLB_PTP_CFG_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t en                   :  1 ; /* bits 0:0 */
    ca_uint32_t ptp_mode             :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_PTP_CFG_t;


#define EPON_EPON_GLB_NI_MODULE_IRQ_STATS        0xd0030040
#define EPON_EPON_GLB_NI_MODULE_IRQ_STATS_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t onu_1pps             :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t onurpt               :  1 ; /* bits 4:4 */
    ca_uint32_t onu_epon             :  1 ; /* bits 5:5 */
    ca_uint32_t rsvd_1b              :  1 ; /* bits 6:6 */
    ca_uint32_t xgepn_txarb          :  1 ; /* bits 7:7 */
    ca_uint32_t xgepn_xgmac          :  1 ; /* bits 8:8 */
    ca_uint32_t xgepn_xgpcs_rx       :  1 ; /* bits 9:9 */
    ca_uint32_t xgepn_xgpcs_tx       :  1 ; /* bits 10:10 */
    ca_uint32_t rx_coresec10         :  1 ; /* bits 11:11 */
    ca_uint32_t tx_coresec10         :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd2               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_NI_MODULE_IRQ_STATS_t;


#define EPON_EPON_GLB_MP_LT_RO_CTRL              0xd0030044
#define EPON_EPON_GLB_MP_LT_RO_CTRL_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t SWpulse              :  1 ; /* bits 1:1 */
    ca_uint32_t ts_en                :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd2               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_MP_LT_RO_CTRL_t;


#define EPON_EPON_GLB_PUC_CFG0                   0xd0030048
#define EPON_EPON_GLB_PUC_CFG0_dft               0x00300100

typedef volatile union {
  struct {
    ca_uint32_t puc_rpt_latency      : 16 ; /* bits 15:0 */
    ca_uint32_t puc_endrpt_latency   : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_PUC_CFG0_t;


#define EPON_EPON_GLB_PUC_CFG1                   0xd003004c
#define EPON_EPON_GLB_PUC_CFG1_dft               0x00000005

typedef volatile union {
  struct {
    ca_uint32_t puc_sch_latency      :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_PUC_CFG1_t;


#define EPON_EPON_GLB_PMAC_PKT_REQ_CNT           0xd0030050
#define EPON_EPON_GLB_PMAC_PKT_REQ_CNT_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pmac_pkt_req_cnt     : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_PMAC_PKT_REQ_CNT_t;


#define EPON_EPON_GLB_PUC_PKT_CNT                0xd0030054
#define EPON_EPON_GLB_PUC_PKT_CNT_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t puc_pkt_cnt          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_PUC_PKT_CNT_t;


#define EPON_EPON_GLB_PUC_BURST_CNT              0xd0030058
#define EPON_EPON_GLB_PUC_BURST_CNT_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t puc_burst_cnt        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_PUC_BURST_CNT_t;


#define EPON_EPON_GLB_PDC_PKT_CNT                0xd003005c
#define EPON_EPON_GLB_PDC_PKT_CNT_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pdc_pkt_cnt          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_PDC_PKT_CNT_t;


#define EPON_EPON_GLB_PUC_SCHSZ_CTRL             0xd0030060
#define EPON_EPON_GLB_PUC_SCHSZ_CTRL_dft         0x000001f4

typedef volatile union {
  struct {
    ca_uint32_t puc_schsz            : 21 ; /* bits 20:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t puc_schsz_fixed      :  1 ; /* bits 24:24 */
    ca_uint32_t rsrvd2               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_PUC_SCHSZ_CTRL_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY0          0xd0030064
#define EPON_EPON_GLB_LLID_TABLE_ENTRY0_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY0_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY1          0xd0030068
#define EPON_EPON_GLB_LLID_TABLE_ENTRY1_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY1_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY2          0xd003006c
#define EPON_EPON_GLB_LLID_TABLE_ENTRY2_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY2_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY3          0xd0030070
#define EPON_EPON_GLB_LLID_TABLE_ENTRY3_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY3_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY4          0xd0030074
#define EPON_EPON_GLB_LLID_TABLE_ENTRY4_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY4_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY5          0xd0030078
#define EPON_EPON_GLB_LLID_TABLE_ENTRY5_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY5_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY6          0xd003007c
#define EPON_EPON_GLB_LLID_TABLE_ENTRY6_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY6_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY7          0xd0030080
#define EPON_EPON_GLB_LLID_TABLE_ENTRY7_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY7_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY8          0xd0030084
#define EPON_EPON_GLB_LLID_TABLE_ENTRY8_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY8_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY9          0xd0030088
#define EPON_EPON_GLB_LLID_TABLE_ENTRY9_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY9_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY10         0xd003008c
#define EPON_EPON_GLB_LLID_TABLE_ENTRY10_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY10_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY11         0xd0030090
#define EPON_EPON_GLB_LLID_TABLE_ENTRY11_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY11_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY12         0xd0030094
#define EPON_EPON_GLB_LLID_TABLE_ENTRY12_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY12_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY13         0xd0030098
#define EPON_EPON_GLB_LLID_TABLE_ENTRY13_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY13_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY14         0xd003009c
#define EPON_EPON_GLB_LLID_TABLE_ENTRY14_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY14_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY15         0xd00300a0
#define EPON_EPON_GLB_LLID_TABLE_ENTRY15_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY15_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY16         0xd00300a4
#define EPON_EPON_GLB_LLID_TABLE_ENTRY16_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY16_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY17         0xd00300a8
#define EPON_EPON_GLB_LLID_TABLE_ENTRY17_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY17_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY18         0xd00300ac
#define EPON_EPON_GLB_LLID_TABLE_ENTRY18_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY18_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY19         0xd00300b0
#define EPON_EPON_GLB_LLID_TABLE_ENTRY19_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY19_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY20         0xd00300b4
#define EPON_EPON_GLB_LLID_TABLE_ENTRY20_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY20_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY21         0xd00300b8
#define EPON_EPON_GLB_LLID_TABLE_ENTRY21_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY21_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY22         0xd00300bc
#define EPON_EPON_GLB_LLID_TABLE_ENTRY22_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY22_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY23         0xd00300c0
#define EPON_EPON_GLB_LLID_TABLE_ENTRY23_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY23_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY24         0xd00300c4
#define EPON_EPON_GLB_LLID_TABLE_ENTRY24_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY24_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY25         0xd00300c8
#define EPON_EPON_GLB_LLID_TABLE_ENTRY25_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY25_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY26         0xd00300cc
#define EPON_EPON_GLB_LLID_TABLE_ENTRY26_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY26_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY27         0xd00300d0
#define EPON_EPON_GLB_LLID_TABLE_ENTRY27_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY27_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY28         0xd00300d4
#define EPON_EPON_GLB_LLID_TABLE_ENTRY28_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY28_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY29         0xd00300d8
#define EPON_EPON_GLB_LLID_TABLE_ENTRY29_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY29_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY30         0xd00300dc
#define EPON_EPON_GLB_LLID_TABLE_ENTRY30_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY30_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY31         0xd00300e0
#define EPON_EPON_GLB_LLID_TABLE_ENTRY31_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY31_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY32         0xd00300e4
#define EPON_EPON_GLB_LLID_TABLE_ENTRY32_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY32_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY33         0xd00300e8
#define EPON_EPON_GLB_LLID_TABLE_ENTRY33_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY33_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY34         0xd00300ec
#define EPON_EPON_GLB_LLID_TABLE_ENTRY34_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY34_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY35         0xd00300f0
#define EPON_EPON_GLB_LLID_TABLE_ENTRY35_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY35_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY36         0xd00300f4
#define EPON_EPON_GLB_LLID_TABLE_ENTRY36_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY36_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY37         0xd00300f8
#define EPON_EPON_GLB_LLID_TABLE_ENTRY37_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY37_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY38         0xd00300fc
#define EPON_EPON_GLB_LLID_TABLE_ENTRY38_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY38_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY39         0xd0030100
#define EPON_EPON_GLB_LLID_TABLE_ENTRY39_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY39_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY40         0xd0030104
#define EPON_EPON_GLB_LLID_TABLE_ENTRY40_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY40_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY41         0xd0030108
#define EPON_EPON_GLB_LLID_TABLE_ENTRY41_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY41_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY42         0xd003010c
#define EPON_EPON_GLB_LLID_TABLE_ENTRY42_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY42_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY43         0xd0030110
#define EPON_EPON_GLB_LLID_TABLE_ENTRY43_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY43_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY44         0xd0030114
#define EPON_EPON_GLB_LLID_TABLE_ENTRY44_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY44_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY45         0xd0030118
#define EPON_EPON_GLB_LLID_TABLE_ENTRY45_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY45_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY46         0xd003011c
#define EPON_EPON_GLB_LLID_TABLE_ENTRY46_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY46_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY47         0xd0030120
#define EPON_EPON_GLB_LLID_TABLE_ENTRY47_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY47_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY48         0xd0030124
#define EPON_EPON_GLB_LLID_TABLE_ENTRY48_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY48_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY49         0xd0030128
#define EPON_EPON_GLB_LLID_TABLE_ENTRY49_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY49_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY50         0xd003012c
#define EPON_EPON_GLB_LLID_TABLE_ENTRY50_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY50_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY51         0xd0030130
#define EPON_EPON_GLB_LLID_TABLE_ENTRY51_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY51_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY52         0xd0030134
#define EPON_EPON_GLB_LLID_TABLE_ENTRY52_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY52_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY53         0xd0030138
#define EPON_EPON_GLB_LLID_TABLE_ENTRY53_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY53_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY54         0xd003013c
#define EPON_EPON_GLB_LLID_TABLE_ENTRY54_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY54_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY55         0xd0030140
#define EPON_EPON_GLB_LLID_TABLE_ENTRY55_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY55_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY56         0xd0030144
#define EPON_EPON_GLB_LLID_TABLE_ENTRY56_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY56_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY57         0xd0030148
#define EPON_EPON_GLB_LLID_TABLE_ENTRY57_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY57_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY58         0xd003014c
#define EPON_EPON_GLB_LLID_TABLE_ENTRY58_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY58_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY59         0xd0030150
#define EPON_EPON_GLB_LLID_TABLE_ENTRY59_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY59_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY60         0xd0030154
#define EPON_EPON_GLB_LLID_TABLE_ENTRY60_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY60_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY61         0xd0030158
#define EPON_EPON_GLB_LLID_TABLE_ENTRY61_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY61_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY62         0xd003015c
#define EPON_EPON_GLB_LLID_TABLE_ENTRY62_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY62_t;


#define EPON_EPON_GLB_LLID_TABLE_ENTRY63         0xd0030160
#define EPON_EPON_GLB_LLID_TABLE_ENTRY63_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t index                :  6 ; /* bits 21:16 */
    ca_uint32_t mcast                :  1 ; /* bits 22:22 */
    ca_uint32_t vld                  :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TABLE_ENTRY63_t;


#define EPON_EPON_GLB_LLID_TBL_ACC_DAT           0xd0030164
#define EPON_EPON_GLB_LLID_TBL_ACC_DAT_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t sw_index             :  6 ; /* bits 21:16 */
    ca_uint32_t mc_llid              :  1 ; /* bits 22:22 */
    ca_uint32_t op                   :  1 ; /* bits 23:23 */
    ca_uint32_t mac_index            :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TBL_ACC_DAT_t;


#define EPON_EPON_GLB_LLID_TBL_ACC               0xd0030168
#define EPON_EPON_GLB_LLID_TBL_ACC_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t acc                  :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TBL_ACC_t;


#define EPON_EPON_GLB_LLID_TBL_ACC_STS           0xd003016c
#define EPON_EPON_GLB_LLID_TBL_ACC_STS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t status               :  3 ; /* bits 2:0 */
    ca_uint32_t rsv1                 : 29 ; /* bits 31:3 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_TBL_ACC_STS_t;


#define EPON_EPON_GLB_LLID_MAPPING_CFG1          0xd0030170
#define EPON_EPON_GLB_LLID_MAPPING_CFG1_dft      0x3c3f003f

typedef volatile union {
  struct {
    ca_uint32_t fake_bcast_idx       :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t fake_bc_llid_pass    :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd2               :  8 ;
    ca_uint32_t bcast_idx            :  6 ; /* bits 21:16 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t sw_mode              :  1 ; /* bits 23:23 */
    ca_uint32_t mon_idx              :  6 ; /* bits 29:24 */
    ca_uint32_t monitor_mode         :  2 ; /* bits 31:30 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_MAPPING_CFG1_t;


#define EPON_EPON_GLB_LLID_MAPPING_CFG2          0xd0030174
#define EPON_EPON_GLB_LLID_MAPPING_CFG2_dft      0x00008000

typedef volatile union {
  struct {
    ca_uint32_t reflect_Nmatch_idx   :  6 ; /* bits 5:0 */
    ca_uint32_t reflect_Nmatch_mcast :  1 ; /* bits 6:6 */
    ca_uint32_t reflect_Nmatch_drop  :  1 ; /* bits 7:7 */
    ca_uint32_t reflect_match_idx    :  6 ; /* bits 13:8 */
    ca_uint32_t reflect_match_mcast  :  1 ; /* bits 14:14 */
    ca_uint32_t reflect_match_drop   :  1 ; /* bits 15:15 */
    ca_uint32_t reflect_Nmatch_mac_index :  5 ; /* bits 20:16 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t reflect_match_mac_index :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd2               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_LLID_MAPPING_CFG2_t;


#define EPON_EPON_GLB_DS_HDRA_CFG1               0xd0030178
#define EPON_EPON_GLB_DS_HDRA_CFG1_dft           0x03800000

typedef volatile union {
  struct {
    ca_uint32_t cos                  :  3 ; /* bits 2:0 */
    ca_uint32_t ldpid                :  6 ; /* bits 8:3 */
    ca_uint32_t fe_bypass            :  1 ; /* bits 9:9 */
    ca_uint32_t hdr_type             :  2 ; /* bits 11:10 */
    ca_uint32_t mcgid                :  8 ; /* bits 19:12 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t mirror               :  1 ; /* bits 21:21 */
    ca_uint32_t mark                 :  1 ; /* bits 22:22 */
    ca_uint32_t lspid                :  6 ; /* bits 28:23 */
    ca_uint32_t drop_code            :  3 ; /* bits 31:29 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_DS_HDRA_CFG1_t;


#define EPON_EPON_GLB_DS_HDRA_CFG2               0xd003017c
#define EPON_EPON_GLB_DS_HDRA_CFG2_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pol_en               :  2 ; /* bits 1:0 */
    ca_uint32_t pol_id               :  9 ; /* bits 10:2 */
    ca_uint32_t pol_grpid            :  3 ; /* bits 13:11 */
    ca_uint32_t dpq                  :  1 ; /* bits 14:14 */
    ca_uint32_t cpu_flg              :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_DS_HDRA_CFG2_t;


#define EPON_EPON_GLB_MISC_CTRL                  0xd0030180
#define EPON_EPON_GLB_MISC_CTRL_dft              0x00020023

typedef volatile union {
  struct {
    ca_uint32_t tx_burst_oen         :  1 ; /* bits 0:0 */
    ca_uint32_t tx_dis_oen           :  1 ; /* bits 1:1 */
    ca_uint32_t rsvd0                :  2 ; /* bits 3:2 */
    ca_uint32_t dis_opt_power        :  1 ; /* bits 4:4 */
    ca_uint32_t dis_opt_power_polarity :  1 ; /* bits 5:5 */
    ca_uint32_t rsvd1                : 10 ; /* bits 15:6 */
    ca_uint32_t rssi_pulse_on        :  1 ; /* bits 16:16 */
    ca_uint32_t rssi_polarity        :  1 ; /* bits 17:17 */
    ca_uint32_t txoam_rpt_replace    :  1 ; /* bits 18:18 */
    ca_uint32_t txfec_1g_on          :  1 ; /* bits 19:19 */
    ca_uint32_t txfec_1g_sel         :  1 ; /* bits 20:20 */
    ca_uint32_t rsvd2                : 10 ; /* bits 30:21 */
    ca_uint32_t llid_tbl_clr_all     :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_MISC_CTRL_t;


#define EPON_EPON_GLB_TX_SW_FRAME_HEADER         0xd0030184
#define EPON_EPON_GLB_TX_SW_FRAME_HEADER_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hdr                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_TX_SW_FRAME_HEADER_t;


#define EPON_EPON_GLB_TX_SW_FRAME_DATA_ACCESS    0xd0030188
#define EPON_EPON_GLB_TX_SW_FRAME_DATA_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_TX_SW_FRAME_DATA_ACCESS_t;


#define EPON_EPON_GLB_TX_SW_FRAME_DATA_DATA1     0xd003018c
#define EPON_EPON_GLB_TX_SW_FRAME_DATA_DATA1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_TX_SW_FRAME_DATA_DATA1_t;


#define EPON_EPON_GLB_TX_SW_FRAME_DATA_DATA0     0xd0030190
#define EPON_EPON_GLB_TX_SW_FRAME_DATA_DATA0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_TX_SW_FRAME_DATA_DATA0_t;


#define EPON_EPON_GLB_TX_SW_START                0xd0030194
#define EPON_EPON_GLB_TX_SW_START_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ready                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_TX_SW_START_t;


#define EPON_EPON_GLB_TXARB_DAT_BUF_THRESHOLD    0xd0030198
#define EPON_EPON_GLB_TXARB_DAT_BUF_THRESHOLD_dft 0x00001600

typedef volatile union {
  struct {
    ca_uint32_t lo                   :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t hi                   :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_TXARB_DAT_BUF_THRESHOLD_t;


#define EPON_EPON_GLB_TXARB_LAST_HDR_SIZE        0xd003019c
#define EPON_EPON_GLB_TXARB_LAST_HDR_SIZE_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hdr                  : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t count                : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_TXARB_LAST_HDR_SIZE_t;


#define EPON_EPON_GLB_EXTIF_INTERRUPT            0xd00301a0
#define EPON_EPON_GLB_EXTIF_INTERRUPT_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pucrpt_error_intrpt  :  1 ; /* bits 0:0 */
    ca_uint32_t pucsch_error_intrpt  :  1 ; /* bits 1:1 */
    ca_uint32_t puc_pkt_lengthERRi   :  1 ; /* bits 2:2 */
    ca_uint32_t sig_LOSSi            :  1 ; /* bits 3:3 */
    ca_uint32_t puc_miss_eop_intrpt  :  1 ; /* bits 4:4 */
    ca_uint32_t txarb_pkt_size_mismatch :  1 ; /* bits 5:5 */
    ca_uint32_t pcs_sync_1gi         :  1 ; /* bits 6:6 */
    ca_uint32_t pdc_pmac_throttle    :  1 ; /* bits 7:7 */
    ca_uint32_t rsv8                 :  1 ; /* bits 8:8 */
    ca_uint32_t rsv9                 :  1 ; /* bits 9:9 */
    ca_uint32_t rsv10                :  1 ; /* bits 10:10 */
    ca_uint32_t rsv11                :  1 ; /* bits 11:11 */
    ca_uint32_t rsv12                :  1 ; /* bits 12:12 */
    ca_uint32_t rsv13                :  1 ; /* bits 13:13 */
    ca_uint32_t rsv14                :  1 ; /* bits 14:14 */
    ca_uint32_t rsv15                :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_EXTIF_INTERRUPT_t;


#define EPON_EPON_GLB_EXTIF_INTERRUPTE           0xd00301a4
#define EPON_EPON_GLB_EXTIF_INTERRUPTE_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pucrpt_error_intrptE :  1 ; /* bits 0:0 */
    ca_uint32_t pucsch_error_intrptE :  1 ; /* bits 1:1 */
    ca_uint32_t puc_pkt_lengthERRiE  :  1 ; /* bits 2:2 */
    ca_uint32_t sig_LOSSiE           :  1 ; /* bits 3:3 */
    ca_uint32_t puc_miss_eop_intrptE :  1 ; /* bits 4:4 */
    ca_uint32_t txarb_pkt_size_mismatchE :  1 ; /* bits 5:5 */
    ca_uint32_t pcs_sync_1giE        :  1 ; /* bits 6:6 */
    ca_uint32_t pdc_pmac_throttleE   :  1 ; /* bits 7:7 */
    ca_uint32_t rsv8E                :  1 ; /* bits 8:8 */
    ca_uint32_t rsv9E                :  1 ; /* bits 9:9 */
    ca_uint32_t rsv10E               :  1 ; /* bits 10:10 */
    ca_uint32_t rsv11E               :  1 ; /* bits 11:11 */
    ca_uint32_t rsv12E               :  1 ; /* bits 12:12 */
    ca_uint32_t rsv13E               :  1 ; /* bits 13:13 */
    ca_uint32_t rsv14E               :  1 ; /* bits 14:14 */
    ca_uint32_t rsv15E               :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_EXTIF_INTERRUPTE_t;


#define EPON_EPON_GLB_PUC_PKT_LENGTH             0xd00301a8
#define EPON_EPON_GLB_PUC_PKT_LENGTH_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t received_puc_pkt_byte : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t received_puc_pkt_len : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_PUC_PKT_LENGTH_t;


#define EPON_EPON_GLB_REVISION                   0xd00301ac
#define EPON_EPON_GLB_REVISION_dft               0x20170217

typedef volatile union {
  struct {
    ca_uint32_t date                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_REVISION_t;


#define EPON_EPON_GLB_CVS_REV                    0xd00301b0
#define EPON_EPON_GLB_CVS_REV_dft                0x20161005

typedef volatile union {
  struct {
    ca_uint32_t tag                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_CVS_REV_t;


#define EPON_EPON_GLB_SW_TXPKT_CNTR              0xd00301b4
#define EPON_EPON_GLB_SW_TXPKT_CNTR_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_pktcnt            : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_SW_TXPKT_CNTR_t;


#define EPON_EPON_GLB_DAT_TXPKT_CNTR             0xd00301b8
#define EPON_EPON_GLB_DAT_TXPKT_CNTR_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_pktcnt            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_DAT_TXPKT_CNTR_t;


#define EPON_EPON_GLB_EXTENSION_TYPE_CFG         0xd00301bc
#define EPON_EPON_GLB_EXTENSION_TYPE_CFG_dft     0x8808fffe

typedef volatile union {
  struct {
    ca_uint32_t ext                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_EXTENSION_TYPE_CFG_t;


#define EPON_EPON_GLB_XGEPON_INTERRUPT           0xd00301c0
#define EPON_EPON_GLB_XGEPON_INTERRUPT_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t xgepn_xgmac          :  1 ; /* bits 8:8 */
    ca_uint32_t xgepn_xgpcs_rx       :  1 ; /* bits 9:9 */
    ca_uint32_t xgepn_xgpcs_tx       :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd2               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_XGEPON_INTERRUPT_t;


#define EPON_EPON_GLB_XGEPON_INTERRUPTE          0xd00301c4
#define EPON_EPON_GLB_XGEPON_INTERRUPTE_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t xgepn_xgmacE         :  1 ; /* bits 8:8 */
    ca_uint32_t xgepn_xgpcs_rxE      :  1 ; /* bits 9:9 */
    ca_uint32_t xgepn_xgpcs_txE      :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd2               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_XGEPON_INTERRUPTE_t;


#define EPON_EPON_GLB_SPARE_CFG                  0xd00301c8
#define EPON_EPON_GLB_SPARE_CFG_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t spare_csr            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_SPARE_CFG_t;


#define EPON_EPON_GLB_SPARE_STS                  0xd00301cc
#define EPON_EPON_GLB_SPARE_STS_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t spare_sts            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_GLB_SPARE_STS_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* epon_glb */
typedef struct {
  EPON_EPON_GLB_INTERRUPT_t                INTERRUPT;                     /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  EPON_EPON_GLB_INTERRUPTE_t               INTERRUPTE;                    /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  EPON_EPON_GLB_ONU_EPON_INTERRUPT_t       ONU_EPON_INTERRUPT;            /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  EPON_EPON_GLB_ONU_EPON_INTERRUPTE_t      ONU_EPON_INTERRUPTE;           /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  EPON_EPON_GLB_EPON_STATUS_t              EPON_STATUS;                   /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  EPON_EPON_GLB_STATIC_CFG_t               STATIC_CFG;                    /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  EPON_EPON_GLB_XGEPN_MAC_ADDR_H_t         XGEPN_MAC_ADDR_H;              /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  EPON_EPON_GLB_XGEPN_MAC_ADDR_L_t         XGEPN_MAC_ADDR_L;              /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  EPON_EPON_GLB_CORESEC10_CFG_t            CORESEC10_CFG;                 /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  EPON_EPON_GLB_XGPCS_FEC_CFG_t            XGPCS_FEC_CFG;                 /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  EPON_EPON_GLB_XGPCS_FEC_RXMODE_ST_t      XGPCS_FEC_RXMODE_ST;           /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  EPON_EPON_GLB_XGPCS_BD_pattern_fecless2_t XGPCS_BD_pattern_fecless2;     /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  EPON_EPON_GLB_XGPCS_BD_pattern_fecless1_t XGPCS_BD_pattern_fecless1;     /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  EPON_EPON_GLB_XGPCS_BD_pattern_fecless0_t XGPCS_BD_pattern_fecless0;     /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  EPON_EPON_GLB_SFI64_KSDS32_XFER_t        SFI64_KSDS32_XFER;             /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  EPON_EPON_GLB_PTP_CFG_t                  PTP_CFG;                       /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  EPON_EPON_GLB_NI_MODULE_IRQ_STATS_t      NI_MODULE_IRQ_STATS;           /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  EPON_EPON_GLB_MP_LT_RO_CTRL_t            MP_LT_RO_CTRL;                 /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  EPON_EPON_GLB_PUC_CFG0_t                 PUC_CFG0;                      /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  EPON_EPON_GLB_PUC_CFG1_t                 PUC_CFG1;                      /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  EPON_EPON_GLB_PMAC_PKT_REQ_CNT_t         PMAC_PKT_REQ_CNT;              /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  EPON_EPON_GLB_PUC_PKT_CNT_t              PUC_PKT_CNT;                   /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  EPON_EPON_GLB_PUC_BURST_CNT_t            PUC_BURST_CNT;                 /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  EPON_EPON_GLB_PDC_PKT_CNT_t              PDC_PKT_CNT;                   /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  EPON_EPON_GLB_PUC_SCHSZ_CTRL_t           PUC_SCHSZ_CTRL;                /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY0_t        LLID_TABLE_ENTRY0;             /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY1_t        LLID_TABLE_ENTRY1;             /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY2_t        LLID_TABLE_ENTRY2;             /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY3_t        LLID_TABLE_ENTRY3;             /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY4_t        LLID_TABLE_ENTRY4;             /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY5_t        LLID_TABLE_ENTRY5;             /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY6_t        LLID_TABLE_ENTRY6;             /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY7_t        LLID_TABLE_ENTRY7;             /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY8_t        LLID_TABLE_ENTRY8;             /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY9_t        LLID_TABLE_ENTRY9;             /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY10_t       LLID_TABLE_ENTRY10;            /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY11_t       LLID_TABLE_ENTRY11;            /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY12_t       LLID_TABLE_ENTRY12;            /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY13_t       LLID_TABLE_ENTRY13;            /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY14_t       LLID_TABLE_ENTRY14;            /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY15_t       LLID_TABLE_ENTRY15;            /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY16_t       LLID_TABLE_ENTRY16;            /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY17_t       LLID_TABLE_ENTRY17;            /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY18_t       LLID_TABLE_ENTRY18;            /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd44[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY19_t       LLID_TABLE_ENTRY19;            /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd45[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY20_t       LLID_TABLE_ENTRY20;            /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd46[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY21_t       LLID_TABLE_ENTRY21;            /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd47[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY22_t       LLID_TABLE_ENTRY22;            /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd48[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY23_t       LLID_TABLE_ENTRY23;            /* addr: 0x000000c0 */
  ca_uint32_t                              rsrvd49[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY24_t       LLID_TABLE_ENTRY24;            /* addr: 0x000000c4 */
  ca_uint32_t                              rsrvd50[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY25_t       LLID_TABLE_ENTRY25;            /* addr: 0x000000c8 */
  ca_uint32_t                              rsrvd51[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY26_t       LLID_TABLE_ENTRY26;            /* addr: 0x000000cc */
  ca_uint32_t                              rsrvd52[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY27_t       LLID_TABLE_ENTRY27;            /* addr: 0x000000d0 */
  ca_uint32_t                              rsrvd53[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY28_t       LLID_TABLE_ENTRY28;            /* addr: 0x000000d4 */
  ca_uint32_t                              rsrvd54[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY29_t       LLID_TABLE_ENTRY29;            /* addr: 0x000000d8 */
  ca_uint32_t                              rsrvd55[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY30_t       LLID_TABLE_ENTRY30;            /* addr: 0x000000dc */
  ca_uint32_t                              rsrvd56[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY31_t       LLID_TABLE_ENTRY31;            /* addr: 0x000000e0 */
  ca_uint32_t                              rsrvd57[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY32_t       LLID_TABLE_ENTRY32;            /* addr: 0x000000e4 */
  ca_uint32_t                              rsrvd58[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY33_t       LLID_TABLE_ENTRY33;            /* addr: 0x000000e8 */
  ca_uint32_t                              rsrvd59[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY34_t       LLID_TABLE_ENTRY34;            /* addr: 0x000000ec */
  ca_uint32_t                              rsrvd60[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY35_t       LLID_TABLE_ENTRY35;            /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd61[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY36_t       LLID_TABLE_ENTRY36;            /* addr: 0x000000f4 */
  ca_uint32_t                              rsrvd62[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY37_t       LLID_TABLE_ENTRY37;            /* addr: 0x000000f8 */
  ca_uint32_t                              rsrvd63[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY38_t       LLID_TABLE_ENTRY38;            /* addr: 0x000000fc */
  ca_uint32_t                              rsrvd64[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY39_t       LLID_TABLE_ENTRY39;            /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd65[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY40_t       LLID_TABLE_ENTRY40;            /* addr: 0x00000104 */
  ca_uint32_t                              rsrvd66[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY41_t       LLID_TABLE_ENTRY41;            /* addr: 0x00000108 */
  ca_uint32_t                              rsrvd67[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY42_t       LLID_TABLE_ENTRY42;            /* addr: 0x0000010c */
  ca_uint32_t                              rsrvd68[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY43_t       LLID_TABLE_ENTRY43;            /* addr: 0x00000110 */
  ca_uint32_t                              rsrvd69[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY44_t       LLID_TABLE_ENTRY44;            /* addr: 0x00000114 */
  ca_uint32_t                              rsrvd70[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY45_t       LLID_TABLE_ENTRY45;            /* addr: 0x00000118 */
  ca_uint32_t                              rsrvd71[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY46_t       LLID_TABLE_ENTRY46;            /* addr: 0x0000011c */
  ca_uint32_t                              rsrvd72[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY47_t       LLID_TABLE_ENTRY47;            /* addr: 0x00000120 */
  ca_uint32_t                              rsrvd73[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY48_t       LLID_TABLE_ENTRY48;            /* addr: 0x00000124 */
  ca_uint32_t                              rsrvd74[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY49_t       LLID_TABLE_ENTRY49;            /* addr: 0x00000128 */
  ca_uint32_t                              rsrvd75[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY50_t       LLID_TABLE_ENTRY50;            /* addr: 0x0000012c */
  ca_uint32_t                              rsrvd76[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY51_t       LLID_TABLE_ENTRY51;            /* addr: 0x00000130 */
  ca_uint32_t                              rsrvd77[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY52_t       LLID_TABLE_ENTRY52;            /* addr: 0x00000134 */
  ca_uint32_t                              rsrvd78[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY53_t       LLID_TABLE_ENTRY53;            /* addr: 0x00000138 */
  ca_uint32_t                              rsrvd79[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY54_t       LLID_TABLE_ENTRY54;            /* addr: 0x0000013c */
  ca_uint32_t                              rsrvd80[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY55_t       LLID_TABLE_ENTRY55;            /* addr: 0x00000140 */
  ca_uint32_t                              rsrvd81[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY56_t       LLID_TABLE_ENTRY56;            /* addr: 0x00000144 */
  ca_uint32_t                              rsrvd82[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY57_t       LLID_TABLE_ENTRY57;            /* addr: 0x00000148 */
  ca_uint32_t                              rsrvd83[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY58_t       LLID_TABLE_ENTRY58;            /* addr: 0x0000014c */
  ca_uint32_t                              rsrvd84[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY59_t       LLID_TABLE_ENTRY59;            /* addr: 0x00000150 */
  ca_uint32_t                              rsrvd85[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY60_t       LLID_TABLE_ENTRY60;            /* addr: 0x00000154 */
  ca_uint32_t                              rsrvd86[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY61_t       LLID_TABLE_ENTRY61;            /* addr: 0x00000158 */
  ca_uint32_t                              rsrvd87[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY62_t       LLID_TABLE_ENTRY62;            /* addr: 0x0000015c */
  ca_uint32_t                              rsrvd88[3];                   
  EPON_EPON_GLB_LLID_TABLE_ENTRY63_t       LLID_TABLE_ENTRY63;            /* addr: 0x00000160 */
  ca_uint32_t                              rsrvd89[3];                   
  EPON_EPON_GLB_LLID_TBL_ACC_DAT_t         LLID_TBL_ACC_DAT;              /* addr: 0x00000164 */
  ca_uint32_t                              rsrvd90[3];                   
  EPON_EPON_GLB_LLID_TBL_ACC_t             LLID_TBL_ACC;                  /* addr: 0x00000168 */
  ca_uint32_t                              rsrvd91[3];                   
  EPON_EPON_GLB_LLID_TBL_ACC_STS_t         LLID_TBL_ACC_STS;              /* addr: 0x0000016c */
  ca_uint32_t                              rsrvd92[3];                   
  EPON_EPON_GLB_LLID_MAPPING_CFG1_t        LLID_MAPPING_CFG1;             /* addr: 0x00000170 */
  ca_uint32_t                              rsrvd93[3];                   
  EPON_EPON_GLB_LLID_MAPPING_CFG2_t        LLID_MAPPING_CFG2;             /* addr: 0x00000174 */
  ca_uint32_t                              rsrvd94[3];                   
  EPON_EPON_GLB_DS_HDRA_CFG1_t             DS_HDRA_CFG1;                  /* addr: 0x00000178 */
  ca_uint32_t                              rsrvd95[3];                   
  EPON_EPON_GLB_DS_HDRA_CFG2_t             DS_HDRA_CFG2;                  /* addr: 0x0000017c */
  ca_uint32_t                              rsrvd96[3];                   
  EPON_EPON_GLB_MISC_CTRL_t                MISC_CTRL;                     /* addr: 0x00000180 */
  ca_uint32_t                              rsrvd97[3];                   
  EPON_EPON_GLB_TX_SW_FRAME_HEADER_t       TX_SW_FRAME_HEADER;            /* addr: 0x00000184 */
  ca_uint32_t                              rsrvd98[3];                   
  EPON_EPON_GLB_TX_SW_FRAME_DATA_ACCESS_t  TX_SW_FRAME_DATA_ACCESS;       /* addr: 0x00000188 */
  ca_uint32_t                              rsrvd99[3];                   
  EPON_EPON_GLB_TX_SW_FRAME_DATA_DATA1_t   TX_SW_FRAME_DATA_DATA1;        /* addr: 0x0000018c */
  ca_uint32_t                              rsrvd100[3];                  
  EPON_EPON_GLB_TX_SW_FRAME_DATA_DATA0_t   TX_SW_FRAME_DATA_DATA0;        /* addr: 0x00000190 */
  ca_uint32_t                              rsrvd101[3];                  
  EPON_EPON_GLB_TX_SW_START_t              TX_SW_START;                   /* addr: 0x00000194 */
  ca_uint32_t                              rsrvd102[3];                  
  EPON_EPON_GLB_TXARB_DAT_BUF_THRESHOLD_t  TXARB_DAT_BUF_THRESHOLD;       /* addr: 0x00000198 */
  ca_uint32_t                              rsrvd103[3];                  
  EPON_EPON_GLB_TXARB_LAST_HDR_SIZE_t      TXARB_LAST_HDR_SIZE;           /* addr: 0x0000019c */
  ca_uint32_t                              rsrvd104[3];                  
  EPON_EPON_GLB_EXTIF_INTERRUPT_t          EXTIF_INTERRUPT;               /* addr: 0x000001a0 */
  ca_uint32_t                              rsrvd105[3];                  
  EPON_EPON_GLB_EXTIF_INTERRUPTE_t         EXTIF_INTERRUPTE;              /* addr: 0x000001a4 */
  ca_uint32_t                              rsrvd106[3];                  
  EPON_EPON_GLB_PUC_PKT_LENGTH_t           PUC_PKT_LENGTH;                /* addr: 0x000001a8 */
  ca_uint32_t                              rsrvd107[3];                  
  EPON_EPON_GLB_REVISION_t                 REVISION;                      /* addr: 0x000001ac */
  ca_uint32_t                              rsrvd108[3];                  
  EPON_EPON_GLB_CVS_REV_t                  CVS_REV;                       /* addr: 0x000001b0 */
  ca_uint32_t                              rsrvd109[3];                  
  EPON_EPON_GLB_SW_TXPKT_CNTR_t            SW_TXPKT_CNTR;                 /* addr: 0x000001b4 */
  ca_uint32_t                              rsrvd110[3];                  
  EPON_EPON_GLB_DAT_TXPKT_CNTR_t           DAT_TXPKT_CNTR;                /* addr: 0x000001b8 */
  ca_uint32_t                              rsrvd111[3];                  
  EPON_EPON_GLB_EXTENSION_TYPE_CFG_t       EXTENSION_TYPE_CFG;            /* addr: 0x000001bc */
  ca_uint32_t                              rsrvd112[3];                  
  EPON_EPON_GLB_XGEPON_INTERRUPT_t         XGEPON_INTERRUPT;              /* addr: 0x000001c0 */
  ca_uint32_t                              rsrvd113[3];                  
  EPON_EPON_GLB_XGEPON_INTERRUPTE_t        XGEPON_INTERRUPTE;             /* addr: 0x000001c4 */
  ca_uint32_t                              rsrvd114[3];                  
  EPON_EPON_GLB_SPARE_CFG_t                SPARE_CFG;                     /* addr: 0x000001c8 */
  ca_uint32_t                              rsrvd115[3];                  
  EPON_EPON_GLB_SPARE_STS_t                SPARE_STS;                     /* addr: 0x000001cc */
} APB1_EPON_EPON_GLB_t;


/*
 * epon_mib
 */
        
#define EPON_EPON_MIB_MIB_RAM_STATUS_REG         0xd0030600
#define EPON_EPON_MIB_MIB_RAM_STATUS_REG_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ram_initdone         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_MIB_RAM_STATUS_REG_t;


#define EPON_EPON_MIB_MIB_CTL                    0xd0030604
#define EPON_EPON_MIB_MIB_CTL_dft                0x00000019

typedef volatile union {
  struct {
    ca_uint32_t ram_clr_en           :  1 ; /* bits 0:0 */
    ca_uint32_t ram_sw_initial       :  1 ; /* bits 1:1 */
    ca_uint32_t dbg_en               :  1 ; /* bits 2:2 */
    ca_uint32_t ram_init_en          :  1 ; /* bits 3:3 */
    ca_uint32_t term_dbg_en          :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_MIB_CTL_t;


#define EPON_EPON_MIB_RX_LLID_MPCP_MIB_ACC_ACCESS 0xd0030608
#define EPON_EPON_MIB_RX_LLID_MPCP_MIB_ACC_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Addr                 : 11 ; /* bits 10:0 */
    ca_uint32_t rsrvd1               : 19 ;
    ca_uint32_t rw                   :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_RX_LLID_MPCP_MIB_ACC_ACCESS_t;


#define EPON_EPON_MIB_RX_LLID_MPCP_MIB_ACC_DATA  0xd003060c
#define EPON_EPON_MIB_RX_LLID_MPCP_MIB_ACC_DATA_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_RX_LLID_MPCP_MIB_ACC_DATA_t;


#define EPON_EPON_MIB_RX_LLID_FRMCNT_MIB_ACC_ACCESS 0xd0030610
#define EPON_EPON_MIB_RX_LLID_FRMCNT_MIB_ACC_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Addr                 : 11 ; /* bits 10:0 */
    ca_uint32_t rsrvd1               : 19 ;
    ca_uint32_t rw                   :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_RX_LLID_FRMCNT_MIB_ACC_ACCESS_t;


#define EPON_EPON_MIB_RX_LLID_FRMCNT_MIB_ACC_DATA 0xd0030614
#define EPON_EPON_MIB_RX_LLID_FRMCNT_MIB_ACC_DATA_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_RX_LLID_FRMCNT_MIB_ACC_DATA_t;


#define EPON_EPON_MIB_RX_XGEPON_ETHNET_MIB_ACC_ACCESS 0xd0030618
#define EPON_EPON_MIB_RX_XGEPON_ETHNET_MIB_ACC_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Addr                 :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t rw                   :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_RX_XGEPON_ETHNET_MIB_ACC_ACCESS_t;


#define EPON_EPON_MIB_RX_XGEPON_ETHNET_MIB_ACC_DATA 0xd003061c
#define EPON_EPON_MIB_RX_XGEPON_ETHNET_MIB_ACC_DATA_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_RX_XGEPON_ETHNET_MIB_ACC_DATA_t;


#define EPON_EPON_MIB_TX_LLID_MPCP_MIB_ACC_ACCESS 0xd0030620
#define EPON_EPON_MIB_TX_LLID_MPCP_MIB_ACC_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Addr                 : 11 ; /* bits 10:0 */
    ca_uint32_t rsrvd1               : 19 ;
    ca_uint32_t rw                   :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_TX_LLID_MPCP_MIB_ACC_ACCESS_t;


#define EPON_EPON_MIB_TX_LLID_MPCP_MIB_ACC_DATA  0xd0030624
#define EPON_EPON_MIB_TX_LLID_MPCP_MIB_ACC_DATA_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_TX_LLID_MPCP_MIB_ACC_DATA_t;


#define EPON_EPON_MIB_TX_LLID_FRMCNT_MIB_ACC_ACCESS 0xd0030628
#define EPON_EPON_MIB_TX_LLID_FRMCNT_MIB_ACC_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Addr                 : 11 ; /* bits 10:0 */
    ca_uint32_t rsrvd1               : 19 ;
    ca_uint32_t rw                   :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_TX_LLID_FRMCNT_MIB_ACC_ACCESS_t;


#define EPON_EPON_MIB_TX_LLID_FRMCNT_MIB_ACC_DATA 0xd003062c
#define EPON_EPON_MIB_TX_LLID_FRMCNT_MIB_ACC_DATA_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_TX_LLID_FRMCNT_MIB_ACC_DATA_t;


#define EPON_EPON_MIB_TX_XGEPON_ETHNET_MIB_ACC_ACCESS 0xd0030630
#define EPON_EPON_MIB_TX_XGEPON_ETHNET_MIB_ACC_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Addr                 :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t rw                   :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_TX_XGEPON_ETHNET_MIB_ACC_ACCESS_t;


#define EPON_EPON_MIB_TX_XGEPON_ETHNET_MIB_ACC_DATA 0xd0030634
#define EPON_EPON_MIB_TX_XGEPON_ETHNET_MIB_ACC_DATA_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_TX_XGEPON_ETHNET_MIB_ACC_DATA_t;


#define EPON_EPON_MIB_MIB_TX_DROPCNT             0xd0030638
#define EPON_EPON_MIB_MIB_TX_DROPCNT_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_MIB_TX_DROPCNT_t;


#define EPON_EPON_MIB_MIB_RX_DROPCNT             0xd003063c
#define EPON_EPON_MIB_MIB_RX_DROPCNT_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_MIB_RX_DROPCNT_t;


#define EPON_EPON_MIB_LLID_MIB_RX_BYTECNT_HI     0xd0030640
#define EPON_EPON_MIB_LLID_MIB_RX_BYTECNT_HI_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mib_cnt              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_LLID_MIB_RX_BYTECNT_HI_t;


#define EPON_EPON_MIB_LLID_MIB_TX_BYTECNT_HI     0xd0030644
#define EPON_EPON_MIB_LLID_MIB_TX_BYTECNT_HI_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mib_cnt              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_LLID_MIB_TX_BYTECNT_HI_t;


#define EPON_EPON_MIB_XGEPN_MIB_RX_BYTECNT_HI    0xd0030648
#define EPON_EPON_MIB_XGEPN_MIB_RX_BYTECNT_HI_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mib_cnt              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_XGEPN_MIB_RX_BYTECNT_HI_t;


#define EPON_EPON_MIB_XGEPN_MIB_TX_BYTECNT_HI    0xd003064c
#define EPON_EPON_MIB_XGEPN_MIB_TX_BYTECNT_HI_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mib_cnt              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_XGEPN_MIB_TX_BYTECNT_HI_t;


#define EPON_EPON_MIB_XOFF_PKT_CNT               0xd0030650
#define EPON_EPON_MIB_XOFF_PKT_CNT_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t xoff_pkt_cnt         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_XOFF_PKT_CNT_t;


#define EPON_EPON_MIB_XON_PKT_CNT                0xd0030654
#define EPON_EPON_MIB_XON_PKT_CNT_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t xon_pkt_cnt          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_EPON_MIB_XON_PKT_CNT_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* epon_mib */
typedef struct {
  EPON_EPON_MIB_MIB_RAM_STATUS_REG_t       MIB_RAM_STATUS_REG;            /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  EPON_EPON_MIB_MIB_CTL_t                  MIB_CTL;                       /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  EPON_EPON_MIB_RX_LLID_MPCP_MIB_ACC_ACCESS_t RX_LLID_MPCP_MIB_ACC_ACCESS;   /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  EPON_EPON_MIB_RX_LLID_MPCP_MIB_ACC_DATA_t RX_LLID_MPCP_MIB_ACC_DATA;     /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  EPON_EPON_MIB_RX_LLID_FRMCNT_MIB_ACC_ACCESS_t RX_LLID_FRMCNT_MIB_ACC_ACCESS; /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  EPON_EPON_MIB_RX_LLID_FRMCNT_MIB_ACC_DATA_t RX_LLID_FRMCNT_MIB_ACC_DATA;   /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  EPON_EPON_MIB_RX_XGEPON_ETHNET_MIB_ACC_ACCESS_t RX_XGEPON_ETHNET_MIB_ACC_ACCESS; /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  EPON_EPON_MIB_RX_XGEPON_ETHNET_MIB_ACC_DATA_t RX_XGEPON_ETHNET_MIB_ACC_DATA; /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  EPON_EPON_MIB_TX_LLID_MPCP_MIB_ACC_ACCESS_t TX_LLID_MPCP_MIB_ACC_ACCESS;   /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  EPON_EPON_MIB_TX_LLID_MPCP_MIB_ACC_DATA_t TX_LLID_MPCP_MIB_ACC_DATA;     /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  EPON_EPON_MIB_TX_LLID_FRMCNT_MIB_ACC_ACCESS_t TX_LLID_FRMCNT_MIB_ACC_ACCESS; /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  EPON_EPON_MIB_TX_LLID_FRMCNT_MIB_ACC_DATA_t TX_LLID_FRMCNT_MIB_ACC_DATA;   /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  EPON_EPON_MIB_TX_XGEPON_ETHNET_MIB_ACC_ACCESS_t TX_XGEPON_ETHNET_MIB_ACC_ACCESS; /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  EPON_EPON_MIB_TX_XGEPON_ETHNET_MIB_ACC_DATA_t TX_XGEPON_ETHNET_MIB_ACC_DATA; /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  EPON_EPON_MIB_MIB_TX_DROPCNT_t           MIB_TX_DROPCNT;                /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  EPON_EPON_MIB_MIB_RX_DROPCNT_t           MIB_RX_DROPCNT;                /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  EPON_EPON_MIB_LLID_MIB_RX_BYTECNT_HI_t   LLID_MIB_RX_BYTECNT_HI;        /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  EPON_EPON_MIB_LLID_MIB_TX_BYTECNT_HI_t   LLID_MIB_TX_BYTECNT_HI;        /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  EPON_EPON_MIB_XGEPN_MIB_RX_BYTECNT_HI_t  XGEPN_MIB_RX_BYTECNT_HI;       /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  EPON_EPON_MIB_XGEPN_MIB_TX_BYTECNT_HI_t  XGEPN_MIB_TX_BYTECNT_HI;       /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  EPON_EPON_MIB_XOFF_PKT_CNT_t             XOFF_PKT_CNT;                  /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  EPON_EPON_MIB_XON_PKT_CNT_t              XON_PKT_CNT;                   /* addr: 0x00000054 */
} APB1_EPON_EPON_MIB_t;


/*
 * ONU_EPON
 */
        
#define EPON_ONU_EPON_PCS_CFG                    0xd0030800
#define EPON_ONU_EPON_PCS_CFG_dft                0x00235c08

typedef volatile union {
  struct {
    ca_uint32_t pcs_loop_cnt_hi      :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               :  6 ;
    ca_uint32_t pon_10balign_en      :  1 ; /* bits 10:10 */
    ca_uint32_t pon_fec_sync_en      :  1 ; /* bits 11:11 */
    ca_uint32_t pcs_loop_cnt_lo      :  4 ; /* bits 15:12 */
    ca_uint32_t an_ps1               :  1 ; /* bits 16:16 */
    ca_uint32_t an_ps2               :  1 ; /* bits 17:17 */
    ca_uint32_t an_rf1               :  1 ; /* bits 18:18 */
    ca_uint32_t an_rf2               :  1 ; /* bits 19:19 */
    ca_uint32_t restart_auto_neg     :  1 ; /* bits 20:20 */
    ca_uint32_t dis_auto_neg         :  1 ; /* bits 21:21 */
    ca_uint32_t rsrvd2               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PCS_CFG_t;


#define EPON_ONU_EPON_PCS_Status_Reg             0xd0030804
#define EPON_ONU_EPON_PCS_Status_Reg_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t An_PS1               :  1 ; /* bits 1:1 */
    ca_uint32_t An_PS2               :  1 ; /* bits 2:2 */
    ca_uint32_t An_RF1               :  1 ; /* bits 3:3 */
    ca_uint32_t An_RF2               :  1 ; /* bits 4:4 */
    ca_uint32_t Link_partner_duplex  :  1 ; /* bits 5:5 */
    ca_uint32_t An_done              :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd2               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PCS_Status_Reg_t;


#define EPON_ONU_EPON_FEC_CFG                    0xd0030808
#define EPON_ONU_EPON_FEC_CFG_dft                0x0000c160

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t tx_1st_preamble_mode :  1 ; /* bits 5:5 */
    ca_uint32_t tx_rep_mode          :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t tfec_rep             :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd3               :  3 ;
    ca_uint32_t tx_ipg_adj           :  3 ; /* bits 14:12 */
    ca_uint32_t tx_fec8B             :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd4               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_FEC_CFG_t;


#define EPON_ONU_EPON_FEC_TX_ERRINJ              0xd003080c
#define EPON_ONU_EPON_FEC_TX_ERRINJ_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t err_sfec             :  1 ; /* bits 0:0 */
    ca_uint32_t err_data             :  1 ; /* bits 1:1 */
    ca_uint32_t err_tfec1            :  1 ; /* bits 2:2 */
    ca_uint32_t err_prty             :  1 ; /* bits 3:3 */
    ca_uint32_t err_tfec2            :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t err_bytecnt          :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t err_bitcnt           :  2 ; /* bits 15:14 */
    ca_uint32_t err_pktcnt           :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd3               :  2 ;
    ca_uint32_t err_burst            :  1 ; /* bits 26:26 */
    ca_uint32_t err_sel              :  1 ; /* bits 27:27 */
    ca_uint32_t rsrvd4               :  3 ;
    ca_uint32_t err_en               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_FEC_TX_ERRINJ_t;


#define EPON_ONU_EPON_FEC_CTRL                   0xd0030810
#define EPON_ONU_EPON_FEC_CTRL_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t fec_decode_enable    :  1 ; /* bits 0:0 */
    ca_uint32_t fec_encode_enable    :  1 ; /* bits 1:1 */
    ca_uint32_t fec_rx_clr           :  1 ; /* bits 2:2 */
    ca_uint32_t fec_tx_clr           :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t rsv7                 :  1 ; /* bits 7:7 */
    ca_uint32_t non_FEC_mode         :  1 ; /* bits 8:8 */
    ca_uint32_t rsv1                 :  1 ; /* bits 9:9 */
    ca_uint32_t rsv2                 :  1 ; /* bits 10:10 */
    ca_uint32_t rsv3                 :  1 ; /* bits 11:11 */
    ca_uint32_t rsv4                 :  1 ; /* bits 12:12 */
    ca_uint32_t rsv5                 :  1 ; /* bits 13:13 */
    ca_uint32_t fec_rx_ctrl          : 11 ; /* bits 24:14 */
    ca_uint32_t rsrvd2               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_FEC_CTRL_t;


#define EPON_ONU_EPON_TX_RCC_CNT                 0xd0030814
#define EPON_ONU_EPON_TX_RCC_CNT_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_TX_RCC_CNT_t;


#define EPON_ONU_EPON_FEC_MISC_STATUS            0xd0030818
#define EPON_ONU_EPON_FEC_MISC_STATUS_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pack_full            :  1 ; /* bits 0:0 */
    ca_uint32_t prty_full            :  1 ; /* bits 1:1 */
    ca_uint32_t cmd_full             :  1 ; /* bits 2:2 */
    ca_uint32_t cwb_full             :  1 ; /* bits 3:3 */
    ca_uint32_t pipe_stall           :  1 ; /* bits 4:4 */
    ca_uint32_t los_tfec1            :  1 ; /* bits 5:5 */
    ca_uint32_t los_tfec2            :  1 ; /* bits 6:6 */
    ca_uint32_t fec_errors           :  4 ; /* bits 10:7 */
    ca_uint32_t fec_uncorr           :  1 ; /* bits 11:11 */
    ca_uint32_t fec_dacor_ack_q      :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t fec_pkt_st           :  4 ; /* bits 19:16 */
    ca_uint32_t rsrvd2               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_FEC_MISC_STATUS_t;


#define EPON_ONU_EPON_FEC_Counter_Control        0xd003081c
#define EPON_ONU_EPON_FEC_Counter_Control_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t FEC_CNTR_rd_clr_mode :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_FEC_Counter_Control_t;


#define EPON_ONU_EPON_FEC_Block_Correctable_Error_Counter 0xd0030820
#define EPON_ONU_EPON_FEC_Block_Correctable_Error_Counter_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t FEC_RCNT             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_FEC_Block_Correctable_Error_Counter_t;


#define EPON_ONU_EPON_FEC_Block_Uncorrectable_Error_Counter 0xd0030824
#define EPON_ONU_EPON_FEC_Block_Uncorrectable_Error_Counter_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t FEC_UCNT             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_FEC_Block_Uncorrectable_Error_Counter_t;


#define EPON_ONU_EPON_FEC_Block_No_Error_Counter 0xd0030828
#define EPON_ONU_EPON_FEC_Block_No_Error_Counter_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t FEC_NOERR            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_FEC_Block_No_Error_Counter_t;


#define EPON_ONU_EPON_FEC_Block_Counter          0xd003082c
#define EPON_ONU_EPON_FEC_Block_Counter_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t FEC_BLK_CNT          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_FEC_Block_Counter_t;


#define EPON_ONU_EPON_FEC_Corr_Byte_Counter      0xd0030830
#define EPON_ONU_EPON_FEC_Corr_Byte_Counter_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t FEC_CORR_BYTE_CNT    : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_FEC_Corr_Byte_Counter_t;


#define EPON_ONU_EPON_TXCTRL                     0xd0030834
#define EPON_ONU_EPON_TXCTRL_dft                 0x0001c000

typedef volatile union {
  struct {
    ca_uint32_t TX_EN                :  1 ; /* bits 0:0 */
    ca_uint32_t reserved_1           :  1 ; /* bits 1:1 */
    ca_uint32_t reserved_2           :  1 ; /* bits 2:2 */
    ca_uint32_t drain                :  1 ; /* bits 3:3 */
    ca_uint32_t reserved_4           :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t reserved_6           :  1 ; /* bits 6:6 */
    ca_uint32_t reserved_7           :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd2               :  4 ;
    ca_uint32_t laser_delay          :  6 ; /* bits 17:12 */
    ca_uint32_t laser_burst_polarity :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t ipg_sel              :  2 ; /* bits 21:20 */
    ca_uint32_t crc8_calculation_order_select :  2 ; /* bits 23:22 */
    ca_uint32_t bf                   :  1 ; /* bits 24:24 */
    ca_uint32_t disable_crc32_re_generation :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd4               :  4 ;
    ca_uint32_t max_pkt_size_limit   :  1 ; /* bits 30:30 */
    ca_uint32_t tx_pause_enable      :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_TXCTRL_t;


#define EPON_ONU_EPON_MAXPKTSIZE                 0xd0030838
#define EPON_ONU_EPON_MAXPKTSIZE_dft             0x30003000

typedef volatile union {
  struct {
    ca_uint32_t tx_max_pkt_size      : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t rx_max_pkt_size      : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_MAXPKTSIZE_t;


#define EPON_ONU_EPON_TXCTRL_FFCFG               0xd003083c
#define EPON_ONU_EPON_TXCTRL_FFCFG_dft           0xc1f44008

typedef volatile union {
  struct {
    ca_uint32_t sync_fifo_low_threshold :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t async_fifo_low_threshold :  4 ; /* bits 15:12 */
    ca_uint32_t sync_fifo_high_threshold :  9 ; /* bits 24:16 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t async_fifo_high_threshold :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_TXCTRL_FFCFG_t;


#define EPON_ONU_EPON_TXMAC_CFG                  0xd0030840
#define EPON_ONU_EPON_TXMAC_CFG_dft              0x000a0212

typedef volatile union {
  struct {
    ca_uint32_t ptp_lsr_on_adj       :  8 ; /* bits 7:0 */
    ca_uint32_t win_dly_adj          :  5 ; /* bits 12:8 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t lsr_on_adj           :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd2               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_TXMAC_CFG_t;


#define EPON_ONU_EPON_PACKET_DRAIN_CNT           0xd0030844
#define EPON_ONU_EPON_PACKET_DRAIN_CNT_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt_drain_cnt        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PACKET_DRAIN_CNT_t;


#define EPON_ONU_EPON_TX_CRCERR_CNT              0xd0030848
#define EPON_ONU_EPON_TX_CRCERR_CNT_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t txcrcErrCnt          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_TX_CRCERR_CNT_t;


#define EPON_ONU_EPON_OUTPCS_CNT                 0xd003084c
#define EPON_ONU_EPON_OUTPCS_CNT_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t is                   : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_OUTPCS_CNT_t;


#define EPON_ONU_EPON_OUTMAC_CNT                 0xd0030850
#define EPON_ONU_EPON_OUTMAC_CNT_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t is                   : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_OUTMAC_CNT_t;


#define EPON_ONU_EPON_OUTLSR_CNT                 0xd0030854
#define EPON_ONU_EPON_OUTLSR_CNT_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t is                   : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_OUTLSR_CNT_t;


#define EPON_ONU_EPON_DATAPATH_STATUS            0xd0030858
#define EPON_ONU_EPON_DATAPATH_STATUS_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t txpath1              :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd2               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_DATAPATH_STATUS_t;


#define EPON_ONU_EPON_RCC_CNT                    0xd003085c
#define EPON_ONU_EPON_RCC_CNT_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_RCC_CNT_t;


#define EPON_ONU_EPON_PTP_ASYM_DELAY             0xd0030860
#define EPON_ONU_EPON_PTP_ASYM_DELAY_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t correction           : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PTP_ASYM_DELAY_t;


#define EPON_ONU_EPON_PTP_EG_TIME_LATCH          0xd0030864
#define EPON_ONU_EPON_PTP_EG_TIME_LATCH_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t local_time           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PTP_EG_TIME_LATCH_t;


#define EPON_ONU_EPON_PTP_EG_TIMES_LATCH1        0xd0030868
#define EPON_ONU_EPON_PTP_EG_TIMES_LATCH1_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t local_time1          : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PTP_EG_TIMES_LATCH1_t;


#define EPON_ONU_EPON_PTP_EG_TIMES_LATCH0        0xd003086c
#define EPON_ONU_EPON_PTP_EG_TIMES_LATCH0_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t local_time0          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PTP_EG_TIMES_LATCH0_t;


#define EPON_ONU_EPON_PTP_EG_LATCH               0xd0030870
#define EPON_ONU_EPON_PTP_EG_LATCH_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sqid                 : 16 ; /* bits 15:0 */
    ca_uint32_t message_type         :  2 ; /* bits 17:16 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PTP_EG_LATCH_t;


#define EPON_ONU_EPON_PTP_PIPE_EMPTY             0xd0030874
#define EPON_ONU_EPON_PTP_PIPE_EMPTY_dft         0x000003f0

typedef volatile union {
  struct {
    ca_uint32_t en                   : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PTP_PIPE_EMPTY_t;


#define EPON_ONU_EPON_DBG_SEL                    0xd0030878
#define EPON_ONU_EPON_DBG_SEL_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dbg_sel              :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t dbg_sel_aes          :  5 ; /* bits 12:8 */
    ca_uint32_t dbg_sel_fec          :  3 ; /* bits 15:13 */
    ca_uint32_t rsrvd2               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_DBG_SEL_t;


#define EPON_ONU_EPON_DBG_OUT                    0xd003087c
#define EPON_ONU_EPON_DBG_OUT_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dbg_out              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_DBG_OUT_t;


#define EPON_ONU_EPON_FF_STS                     0xd0030880
#define EPON_ONU_EPON_FF_STS_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t asyncff_full         :  1 ; /* bits 0:0 */
    ca_uint32_t asyncff_empty        :  1 ; /* bits 1:1 */
    ca_uint32_t syncff_full          :  1 ; /* bits 2:2 */
    ca_uint32_t syncff_empty         :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_FF_STS_t;


#define EPON_ONU_EPON_SPARE                      0xd0030884
#define EPON_ONU_EPON_SPARE_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cfg                  :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 26 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_SPARE_t;


#define EPON_ONU_EPON_RSVR                       0xd0030888
#define EPON_ONU_EPON_RSVR_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t val                  :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_RSVR_t;


#define EPON_ONU_EPON_RXCTRL                     0xd003088c
#define EPON_ONU_EPON_RXCTRL_dft                 0x0c002100

typedef volatile union {
  struct {
    ca_uint32_t RX_EN                :  1 ; /* bits 0:0 */
    ca_uint32_t rx_pause_enable      :  1 ; /* bits 1:1 */
    ca_uint32_t mpcp_to_cpu          :  1 ; /* bits 2:2 */
    ca_uint32_t ipg_cnt              :  3 ; /* bits 5:3 */
    ca_uint32_t gmii                 :  1 ; /* bits 6:6 */
    ca_uint32_t sfd_mode2            :  1 ; /* bits 7:7 */
    ca_uint32_t max_mtu_tag_en       :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t disable_crc8_checking :  1 ; /* bits 10:10 */
    ca_uint32_t drop_mask            : 11 ; /* bits 21:11 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t dis_bypass_extn      :  1 ; /* bits 23:23 */
    ca_uint32_t dis_bypass_oam       :  1 ; /* bits 24:24 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t check_da_mac         :  1 ; /* bits 26:26 */
    ca_uint32_t check_mp_length      :  1 ; /* bits 27:27 */
    ca_uint32_t rsrvd4               :  3 ;
    ca_uint32_t bypass               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_RXCTRL_t;


#define EPON_ONU_EPON_RX_MONITOR                 0xd0030890
#define EPON_ONU_EPON_RX_MONITOR_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mp_discovery_cnt     :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_RX_MONITOR_t;


#define EPON_ONU_EPON_RXMAC_CFG                  0xd0030894
#define EPON_ONU_EPON_RXMAC_CFG_dft              0x00ffff40

typedef volatile union {
  struct {
    ca_uint32_t filtering_threshold  :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t mtu_tag_pattern      : 16 ; /* bits 23:8 */
    ca_uint32_t rsrvd2               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_RXMAC_CFG_t;


#define EPON_ONU_EPON_RXMAC_EXTENSION_CFG        0xd0030898
#define EPON_ONU_EPON_RXMAC_EXTENSION_CFG_dft    0x0000fffe

typedef volatile union {
  struct {
    ca_uint32_t opcode               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_RXMAC_EXTENSION_CFG_t;


#define EPON_ONU_EPON_RXMAC_EXTENSION_OUI        0xd003089c
#define EPON_ONU_EPON_RXMAC_EXTENSION_OUI_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t oui                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t check_oui            :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd2               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_RXMAC_EXTENSION_OUI_t;


#define EPON_ONU_EPON_RXMAC_EXTENSION_DA1        0xd00308a0
#define EPON_ONU_EPON_RXMAC_EXTENSION_DA1_dft    0x00000180

typedef volatile union {
  struct {
    ca_uint32_t extda1               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_RXMAC_EXTENSION_DA1_t;


#define EPON_ONU_EPON_RXMAC_EXTENSION_DA0        0xd00308a4
#define EPON_ONU_EPON_RXMAC_EXTENSION_DA0_dft    0xc2000001

typedef volatile union {
  struct {
    ca_uint32_t extda0               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_RXMAC_EXTENSION_DA0_t;


#define EPON_ONU_EPON_DATAPATH_BYPASS            0xd00308a8
#define EPON_ONU_EPON_DATAPATH_BYPASS_dft        0x00000026

typedef volatile union {
  struct {
    ca_uint32_t rxpath_bypass        :  4 ; /* bits 3:0 */
    ca_uint32_t txpath_bypass        :  5 ; /* bits 8:4 */
    ca_uint32_t rxpath_sw_mode       :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t fec_tx_delay_en      :  1 ; /* bits 11:11 */
    ca_uint32_t rsrvd2               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_DATAPATH_BYPASS_t;


#define EPON_ONU_EPON_FEC_DEFINE_PKTSIZE         0xd00308ac
#define EPON_ONU_EPON_FEC_DEFINE_PKTSIZE_dft     0x00032608

typedef volatile union {
  struct {
    ca_uint32_t max_pkt_size         : 12 ; /* bits 11:0 */
    ca_uint32_t min_pkt_size         : 12 ; /* bits 23:12 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_FEC_DEFINE_PKTSIZE_t;


#define EPON_ONU_EPON_FEC_DEFINE_LATENCY         0xd00308b0
#define EPON_ONU_EPON_FEC_DEFINE_LATENCY_dft     0x0014c608

typedef volatile union {
  struct {
    ca_uint32_t pckt_latency         : 12 ; /* bits 11:0 */
    ca_uint32_t fdec_latency         :  9 ; /* bits 20:12 */
    ca_uint32_t rsrvd1               : 11 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_FEC_DEFINE_LATENCY_t;


#define EPON_ONU_EPON_AES_MODE_CTL               0xd00308b4
#define EPON_ONU_EPON_AES_MODE_CTL_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t CntDiff              :  8 ; /* bits 7:0 */
    ca_uint32_t CntIncDec            :  1 ; /* bits 8:8 */
    ca_uint32_t tx_CntDiff           :  8 ; /* bits 16:9 */
    ca_uint32_t tx_CntIncDec         :  1 ; /* bits 17:17 */
    ca_uint32_t rx_enc_en_cnt_clr    :  1 ; /* bits 18:18 */
    ca_uint32_t tx_port_encrypt_en   :  1 ; /* bits 19:19 */
    ca_uint32_t rx_enc_en_cnt_lmt    :  3 ; /* bits 22:20 */
    ca_uint32_t tx_ReverseCrc8En     :  1 ; /* bits 23:23 */
    ca_uint32_t tx_ReverseCrc8Out    :  1 ; /* bits 24:24 */
    ca_uint32_t tx_crc8_gen_disable  :  1 ; /* bits 25:25 */
    ca_uint32_t port_encrypt_index_sel :  1 ; /* bits 26:26 */
    ca_uint32_t csr_port_encrypt_index :  1 ; /* bits 27:27 */
    ca_uint32_t tx_port_decryptonly_en :  1 ; /* bits 28:28 */
    ca_uint32_t AesModeSel           :  3 ; /* bits 31:29 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_AES_MODE_CTL_t;


#define EPON_ONU_EPON_UC_KEY03                   0xd00308b8
#define EPON_ONU_EPON_UC_KEY03_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key03                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_UC_KEY03_t;


#define EPON_ONU_EPON_UC_KEY02                   0xd00308bc
#define EPON_ONU_EPON_UC_KEY02_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key02                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_UC_KEY02_t;


#define EPON_ONU_EPON_UC_KEY01                   0xd00308c0
#define EPON_ONU_EPON_UC_KEY01_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key01                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_UC_KEY01_t;


#define EPON_ONU_EPON_UC_KEY00                   0xd00308c4
#define EPON_ONU_EPON_UC_KEY00_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key00                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_UC_KEY00_t;


#define EPON_ONU_EPON_UC_KEY13                   0xd00308c8
#define EPON_ONU_EPON_UC_KEY13_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key13                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_UC_KEY13_t;


#define EPON_ONU_EPON_UC_KEY12                   0xd00308cc
#define EPON_ONU_EPON_UC_KEY12_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key12                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_UC_KEY12_t;


#define EPON_ONU_EPON_UC_KEY11                   0xd00308d0
#define EPON_ONU_EPON_UC_KEY11_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key11                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_UC_KEY11_t;


#define EPON_ONU_EPON_UC_KEY10                   0xd00308d4
#define EPON_ONU_EPON_UC_KEY10_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key10                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_UC_KEY10_t;


#define EPON_ONU_EPON_PKT_MON03                  0xd00308d8
#define EPON_ONU_EPON_PKT_MON03_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t recv_pkt_r3          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PKT_MON03_t;


#define EPON_ONU_EPON_PKT_MON02                  0xd00308dc
#define EPON_ONU_EPON_PKT_MON02_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t recv_pkt_r2          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PKT_MON02_t;


#define EPON_ONU_EPON_PKT_MON01                  0xd00308e0
#define EPON_ONU_EPON_PKT_MON01_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t recv_pkt_r1          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PKT_MON01_t;


#define EPON_ONU_EPON_PKT_MON00                  0xd00308e4
#define EPON_ONU_EPON_PKT_MON00_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t recv_pkt_r0          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PKT_MON00_t;


#define EPON_ONU_EPON_PKT_MON13                  0xd00308e8
#define EPON_ONU_EPON_PKT_MON13_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t decrypt_pkt_r3       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PKT_MON13_t;


#define EPON_ONU_EPON_PKT_MON12                  0xd00308ec
#define EPON_ONU_EPON_PKT_MON12_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t decrypt_pkt_r2       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PKT_MON12_t;


#define EPON_ONU_EPON_PKT_MON11                  0xd00308f0
#define EPON_ONU_EPON_PKT_MON11_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t decrypt_pkt_r1       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PKT_MON11_t;


#define EPON_ONU_EPON_PKT_MON10                  0xd00308f4
#define EPON_ONU_EPON_PKT_MON10_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t decrypt_pkt_r0       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PKT_MON10_t;


#define EPON_ONU_EPON_PKT_MON2                   0xd00308f8
#define EPON_ONU_EPON_PKT_MON2_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t last_rx_key_index    :  1 ; /* bits 0:0 */
    ca_uint32_t RCC_b0               :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  6 ;
    ca_uint32_t rx_aes_flag          :  8 ; /* bits 15:8 */
    ca_uint32_t key_ind_tog_cnt      :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd2               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PKT_MON2_t;


#define EPON_ONU_EPON_PKT_MON31                  0xd00308fc
#define EPON_ONU_EPON_PKT_MON31_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mpcp_cnt_recode_err1 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PKT_MON31_t;


#define EPON_ONU_EPON_PKT_MON30                  0xd0030900
#define EPON_ONU_EPON_PKT_MON30_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mpcp_cnt_recode_err0 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_PKT_MON30_t;


#define EPON_ONU_EPON_KEYREQUEST_OAM_CNT         0xd0030904
#define EPON_ONU_EPON_KEYREQUEST_OAM_CNT_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t keyrequest_oam_cnt   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_KEYREQUEST_OAM_CNT_t;


#define EPON_ONU_EPON_AES_DBG_CNT0               0xd0030908
#define EPON_ONU_EPON_AES_DBG_CNT0_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_AES_DBG_CNT0_t;


#define EPON_ONU_EPON_AES_DBG_GOOD_CNT0          0xd003090c
#define EPON_ONU_EPON_AES_DBG_GOOD_CNT0_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_AES_DBG_GOOD_CNT0_t;


#define EPON_ONU_EPON_AES_DBG_CNT1               0xd0030910
#define EPON_ONU_EPON_AES_DBG_CNT1_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_AES_DBG_CNT1_t;


#define EPON_ONU_EPON_AES_DBG_GOOD_CNT1          0xd0030914
#define EPON_ONU_EPON_AES_DBG_GOOD_CNT1_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_AES_DBG_GOOD_CNT1_t;


#define EPON_ONU_EPON_UC_TX_KEY03                0xd0030918
#define EPON_ONU_EPON_UC_TX_KEY03_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key03                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_UC_TX_KEY03_t;


#define EPON_ONU_EPON_UC_TX_KEY02                0xd003091c
#define EPON_ONU_EPON_UC_TX_KEY02_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key02                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_UC_TX_KEY02_t;


#define EPON_ONU_EPON_UC_TX_KEY01                0xd0030920
#define EPON_ONU_EPON_UC_TX_KEY01_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key01                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_UC_TX_KEY01_t;


#define EPON_ONU_EPON_UC_TX_KEY00                0xd0030924
#define EPON_ONU_EPON_UC_TX_KEY00_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key00                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_UC_TX_KEY00_t;


#define EPON_ONU_EPON_UC_TX_KEY13                0xd0030928
#define EPON_ONU_EPON_UC_TX_KEY13_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key13                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_UC_TX_KEY13_t;


#define EPON_ONU_EPON_UC_TX_KEY12                0xd003092c
#define EPON_ONU_EPON_UC_TX_KEY12_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key12                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_UC_TX_KEY12_t;


#define EPON_ONU_EPON_UC_TX_KEY11                0xd0030930
#define EPON_ONU_EPON_UC_TX_KEY11_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key11                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_UC_TX_KEY11_t;


#define EPON_ONU_EPON_UC_TX_KEY10                0xd0030934
#define EPON_ONU_EPON_UC_TX_KEY10_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key10                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_UC_TX_KEY10_t;


#define EPON_ONU_EPON_UC_TX_KEY_CTRL             0xd0030938
#define EPON_ONU_EPON_UC_TX_KEY_CTRL_dft         0x00000003

typedef volatile union {
  struct {
    ca_uint32_t tx_key_sel           :  1 ; /* bits 0:0 */
    ca_uint32_t tx_rcc_b0_sel        :  1 ; /* bits 1:1 */
    ca_uint32_t tx_pkt_ts_sel        :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_UC_TX_KEY_CTRL_t;


#define EPON_ONU_EPON_AES_CHURNING_CTRL          0xd003093c
#define EPON_ONU_EPON_AES_CHURNING_CTRL_dft      0x00000680

typedef volatile union {
  struct {
    ca_uint32_t enable_decryption_function_churning_or_AES :  1 ; /* bits 0:0 */
    ca_uint32_t enable_single_de_churning_function :  1 ; /* bits 1:1 */
    ca_uint32_t reverse_bit_order_of_random_generated_key :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t key_rdout_sel        :  1 ; /* bits 5:5 */
    ca_uint32_t revser_sel           :  1 ; /* bits 6:6 */
    ca_uint32_t HW_key_mode          :  1 ; /* bits 7:7 */
    ca_uint32_t rcc_correct_dis      :  1 ; /* bits 8:8 */
    ca_uint32_t oam_enc_dis          :  1 ; /* bits 9:9 */
    ca_uint32_t mp_enc_dis           :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd2               : 21 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_AES_CHURNING_CTRL_t;


#define EPON_ONU_EPON_CHURN_CONFIG_CONTROL       0xd0030940
#define EPON_ONU_EPON_CHURN_CONFIG_CONTROL_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t select_sw_key_as_decryption_key :  1 ; /* bits 3:3 */
    ca_uint32_t enable_Transmit_churning_OAM :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t SW_sel               :  1 ; /* bits 7:7 */
    ca_uint32_t key_sel_mode         :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd3               :  6 ;
    ca_uint32_t rsv15                :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd4               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_CHURN_CONFIG_CONTROL_t;


#define EPON_ONU_EPON_MISC_CFG                   0xd0030944
#define EPON_ONU_EPON_MISC_CFG_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t glb_pon_aes_disable  :  1 ; /* bits 0:0 */
    ca_uint32_t dpoe_dec_iv_sel      :  1 ; /* bits 1:1 */
    ca_uint32_t dpoe_key_mem_sel     :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_MISC_CFG_t;


#define EPON_ONU_EPON_SLD_ERR_CNT                0xd0030948
#define EPON_ONU_EPON_SLD_ERR_CNT_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sld_cnt              : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_SLD_ERR_CNT_t;


#define EPON_ONU_EPON_CRC8_ERR_CNT               0xd003094c
#define EPON_ONU_EPON_CRC8_ERR_CNT_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t crc8e_cnt            : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_CRC8_ERR_CNT_t;


#define EPON_ONU_EPON_IPG_DROP_CNT               0xd0030950
#define EPON_ONU_EPON_IPG_DROP_CNT_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ipg_drop_cnt         : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_IPG_DROP_CNT_t;


#define EPON_ONU_EPON_MISC                       0xd0030954
#define EPON_ONU_EPON_MISC_dft                   0x00000002

typedef volatile union {
  struct {
    ca_uint32_t cnt_op_mode          :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_MISC_t;


#define EPON_ONU_EPON_RXCTRL_STS                 0xd0030958
#define EPON_ONU_EPON_RXCTRL_STS_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t drop_short_cnt       :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_RXCTRL_STS_t;


#define EPON_ONU_EPON_AES_DEC_LLID_INDEX_0       0xd003095c
#define EPON_ONU_EPON_AES_DEC_LLID_INDEX_0_STRIDE 4
#define EPON_ONU_EPON_AES_DEC_LLID_INDEX_0_COUNT 8
#define EPON_ONU_EPON_AES_DEC_LLID_INDEX_0_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t entry                : 20 ; /* bits 19:0 */
    ca_uint32_t rsrvd1               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_AES_DEC_LLID_INDEX_0_t;

                            
#define EPON_ONU_EPON_AES_DEC_KEY_TBL_ACCESS     0xd003097c
#define EPON_ONU_EPON_AES_DEC_KEY_TBL_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 26 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_AES_DEC_KEY_TBL_ACCESS_t;


#define EPON_ONU_EPON_AES_DEC_KEY_TBL_DATA3      0xd0030980
#define EPON_ONU_EPON_AES_DEC_KEY_TBL_DATA3_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_AES_DEC_KEY_TBL_DATA3_t;


#define EPON_ONU_EPON_AES_DEC_KEY_TBL_DATA2      0xd0030984
#define EPON_ONU_EPON_AES_DEC_KEY_TBL_DATA2_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_AES_DEC_KEY_TBL_DATA2_t;


#define EPON_ONU_EPON_AES_DEC_KEY_TBL_DATA1      0xd0030988
#define EPON_ONU_EPON_AES_DEC_KEY_TBL_DATA1_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_AES_DEC_KEY_TBL_DATA1_t;


#define EPON_ONU_EPON_AES_DEC_KEY_TBL_DATA0      0xd003098c
#define EPON_ONU_EPON_AES_DEC_KEY_TBL_DATA0_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_EPON_AES_DEC_KEY_TBL_DATA0_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* ONU_EPON */
typedef struct {
  EPON_ONU_EPON_PCS_CFG_t                  PCS_CFG;                       /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  EPON_ONU_EPON_PCS_Status_Reg_t           PCS_Status_Reg;                /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  EPON_ONU_EPON_FEC_CFG_t                  FEC_CFG;                       /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  EPON_ONU_EPON_FEC_TX_ERRINJ_t            FEC_TX_ERRINJ;                 /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  EPON_ONU_EPON_FEC_CTRL_t                 FEC_CTRL;                      /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  EPON_ONU_EPON_TX_RCC_CNT_t               TX_RCC_CNT;                    /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  EPON_ONU_EPON_FEC_MISC_STATUS_t          FEC_MISC_STATUS;               /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  EPON_ONU_EPON_FEC_Counter_Control_t      FEC_Counter_Control;           /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  EPON_ONU_EPON_FEC_Block_Correctable_Error_Counter_t FEC_Block_Correctable_Error_Counter; /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  EPON_ONU_EPON_FEC_Block_Uncorrectable_Error_Counter_t FEC_Block_Uncorrectable_Error_Counter; /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  EPON_ONU_EPON_FEC_Block_No_Error_Counter_t FEC_Block_No_Error_Counter;    /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  EPON_ONU_EPON_FEC_Block_Counter_t        FEC_Block_Counter;             /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  EPON_ONU_EPON_FEC_Corr_Byte_Counter_t    FEC_Corr_Byte_Counter;         /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  EPON_ONU_EPON_TXCTRL_t                   TXCTRL;                        /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  EPON_ONU_EPON_MAXPKTSIZE_t               MAXPKTSIZE;                    /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  EPON_ONU_EPON_TXCTRL_FFCFG_t             TXCTRL_FFCFG;                  /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  EPON_ONU_EPON_TXMAC_CFG_t                TXMAC_CFG;                     /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  EPON_ONU_EPON_PACKET_DRAIN_CNT_t         PACKET_DRAIN_CNT;              /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  EPON_ONU_EPON_TX_CRCERR_CNT_t            TX_CRCERR_CNT;                 /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  EPON_ONU_EPON_OUTPCS_CNT_t               OUTPCS_CNT;                    /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  EPON_ONU_EPON_OUTMAC_CNT_t               OUTMAC_CNT;                    /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  EPON_ONU_EPON_OUTLSR_CNT_t               OUTLSR_CNT;                    /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  EPON_ONU_EPON_DATAPATH_STATUS_t          DATAPATH_STATUS;               /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  EPON_ONU_EPON_RCC_CNT_t                  RCC_CNT;                       /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  EPON_ONU_EPON_PTP_ASYM_DELAY_t           PTP_ASYM_DELAY;                /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  EPON_ONU_EPON_PTP_EG_TIME_LATCH_t        PTP_EG_TIME_LATCH;             /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  EPON_ONU_EPON_PTP_EG_TIMES_LATCH1_t      PTP_EG_TIMES_LATCH1;           /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  EPON_ONU_EPON_PTP_EG_TIMES_LATCH0_t      PTP_EG_TIMES_LATCH0;           /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  EPON_ONU_EPON_PTP_EG_LATCH_t             PTP_EG_LATCH;                  /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  EPON_ONU_EPON_PTP_PIPE_EMPTY_t           PTP_PIPE_EMPTY;                /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  EPON_ONU_EPON_DBG_SEL_t                  DBG_SEL;                       /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  EPON_ONU_EPON_DBG_OUT_t                  DBG_OUT;                       /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  EPON_ONU_EPON_FF_STS_t                   FF_STS;                        /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  EPON_ONU_EPON_SPARE_t                    SPARE;                         /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  EPON_ONU_EPON_RSVR_t                     RSVR;                          /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  EPON_ONU_EPON_RXCTRL_t                   RXCTRL;                        /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  EPON_ONU_EPON_RX_MONITOR_t               RX_MONITOR;                    /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  EPON_ONU_EPON_RXMAC_CFG_t                RXMAC_CFG;                     /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  EPON_ONU_EPON_RXMAC_EXTENSION_CFG_t      RXMAC_EXTENSION_CFG;           /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];                   
  EPON_ONU_EPON_RXMAC_EXTENSION_OUI_t      RXMAC_EXTENSION_OUI;           /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];                   
  EPON_ONU_EPON_RXMAC_EXTENSION_DA1_t      RXMAC_EXTENSION_DA1;           /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];                   
  EPON_ONU_EPON_RXMAC_EXTENSION_DA0_t      RXMAC_EXTENSION_DA0;           /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];                   
  EPON_ONU_EPON_DATAPATH_BYPASS_t          DATAPATH_BYPASS;               /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];                   
  EPON_ONU_EPON_FEC_DEFINE_PKTSIZE_t       FEC_DEFINE_PKTSIZE;            /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd44[3];                   
  EPON_ONU_EPON_FEC_DEFINE_LATENCY_t       FEC_DEFINE_LATENCY;            /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd45[3];                   
  EPON_ONU_EPON_AES_MODE_CTL_t             AES_MODE_CTL;                  /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd46[3];                   
  EPON_ONU_EPON_UC_KEY03_t                 UC_KEY03;                      /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd47[3];                   
  EPON_ONU_EPON_UC_KEY02_t                 UC_KEY02;                      /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd48[3];                   
  EPON_ONU_EPON_UC_KEY01_t                 UC_KEY01;                      /* addr: 0x000000c0 */
  ca_uint32_t                              rsrvd49[3];                   
  EPON_ONU_EPON_UC_KEY00_t                 UC_KEY00;                      /* addr: 0x000000c4 */
  ca_uint32_t                              rsrvd50[3];                   
  EPON_ONU_EPON_UC_KEY13_t                 UC_KEY13;                      /* addr: 0x000000c8 */
  ca_uint32_t                              rsrvd51[3];                   
  EPON_ONU_EPON_UC_KEY12_t                 UC_KEY12;                      /* addr: 0x000000cc */
  ca_uint32_t                              rsrvd52[3];                   
  EPON_ONU_EPON_UC_KEY11_t                 UC_KEY11;                      /* addr: 0x000000d0 */
  ca_uint32_t                              rsrvd53[3];                   
  EPON_ONU_EPON_UC_KEY10_t                 UC_KEY10;                      /* addr: 0x000000d4 */
  ca_uint32_t                              rsrvd54[3];                   
  EPON_ONU_EPON_PKT_MON03_t                PKT_MON03;                     /* addr: 0x000000d8 */
  ca_uint32_t                              rsrvd55[3];                   
  EPON_ONU_EPON_PKT_MON02_t                PKT_MON02;                     /* addr: 0x000000dc */
  ca_uint32_t                              rsrvd56[3];                   
  EPON_ONU_EPON_PKT_MON01_t                PKT_MON01;                     /* addr: 0x000000e0 */
  ca_uint32_t                              rsrvd57[3];                   
  EPON_ONU_EPON_PKT_MON00_t                PKT_MON00;                     /* addr: 0x000000e4 */
  ca_uint32_t                              rsrvd58[3];                   
  EPON_ONU_EPON_PKT_MON13_t                PKT_MON13;                     /* addr: 0x000000e8 */
  ca_uint32_t                              rsrvd59[3];                   
  EPON_ONU_EPON_PKT_MON12_t                PKT_MON12;                     /* addr: 0x000000ec */
  ca_uint32_t                              rsrvd60[3];                   
  EPON_ONU_EPON_PKT_MON11_t                PKT_MON11;                     /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd61[3];                   
  EPON_ONU_EPON_PKT_MON10_t                PKT_MON10;                     /* addr: 0x000000f4 */
  ca_uint32_t                              rsrvd62[3];                   
  EPON_ONU_EPON_PKT_MON2_t                 PKT_MON2;                      /* addr: 0x000000f8 */
  ca_uint32_t                              rsrvd63[3];                   
  EPON_ONU_EPON_PKT_MON31_t                PKT_MON31;                     /* addr: 0x000000fc */
  ca_uint32_t                              rsrvd64[3];                   
  EPON_ONU_EPON_PKT_MON30_t                PKT_MON30;                     /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd65[3];                   
  EPON_ONU_EPON_KEYREQUEST_OAM_CNT_t       KEYREQUEST_OAM_CNT;            /* addr: 0x00000104 */
  ca_uint32_t                              rsrvd66[3];                   
  EPON_ONU_EPON_AES_DBG_CNT0_t             AES_DBG_CNT0;                  /* addr: 0x00000108 */
  ca_uint32_t                              rsrvd67[3];                   
  EPON_ONU_EPON_AES_DBG_GOOD_CNT0_t        AES_DBG_GOOD_CNT0;             /* addr: 0x0000010c */
  ca_uint32_t                              rsrvd68[3];                   
  EPON_ONU_EPON_AES_DBG_CNT1_t             AES_DBG_CNT1;                  /* addr: 0x00000110 */
  ca_uint32_t                              rsrvd69[3];                   
  EPON_ONU_EPON_AES_DBG_GOOD_CNT1_t        AES_DBG_GOOD_CNT1;             /* addr: 0x00000114 */
  ca_uint32_t                              rsrvd70[3];                   
  EPON_ONU_EPON_UC_TX_KEY03_t              UC_TX_KEY03;                   /* addr: 0x00000118 */
  ca_uint32_t                              rsrvd71[3];                   
  EPON_ONU_EPON_UC_TX_KEY02_t              UC_TX_KEY02;                   /* addr: 0x0000011c */
  ca_uint32_t                              rsrvd72[3];                   
  EPON_ONU_EPON_UC_TX_KEY01_t              UC_TX_KEY01;                   /* addr: 0x00000120 */
  ca_uint32_t                              rsrvd73[3];                   
  EPON_ONU_EPON_UC_TX_KEY00_t              UC_TX_KEY00;                   /* addr: 0x00000124 */
  ca_uint32_t                              rsrvd74[3];                   
  EPON_ONU_EPON_UC_TX_KEY13_t              UC_TX_KEY13;                   /* addr: 0x00000128 */
  ca_uint32_t                              rsrvd75[3];                   
  EPON_ONU_EPON_UC_TX_KEY12_t              UC_TX_KEY12;                   /* addr: 0x0000012c */
  ca_uint32_t                              rsrvd76[3];                   
  EPON_ONU_EPON_UC_TX_KEY11_t              UC_TX_KEY11;                   /* addr: 0x00000130 */
  ca_uint32_t                              rsrvd77[3];                   
  EPON_ONU_EPON_UC_TX_KEY10_t              UC_TX_KEY10;                   /* addr: 0x00000134 */
  ca_uint32_t                              rsrvd78[3];                   
  EPON_ONU_EPON_UC_TX_KEY_CTRL_t           UC_TX_KEY_CTRL;                /* addr: 0x00000138 */
  ca_uint32_t                              rsrvd79[3];                   
  EPON_ONU_EPON_AES_CHURNING_CTRL_t        AES_CHURNING_CTRL;             /* addr: 0x0000013c */
  ca_uint32_t                              rsrvd80[3];                   
  EPON_ONU_EPON_CHURN_CONFIG_CONTROL_t     CHURN_CONFIG_CONTROL;          /* addr: 0x00000140 */
  ca_uint32_t                              rsrvd81[3];                   
  EPON_ONU_EPON_MISC_CFG_t                 MISC_CFG;                      /* addr: 0x00000144 */
  ca_uint32_t                              rsrvd82[3];                   
  EPON_ONU_EPON_SLD_ERR_CNT_t              SLD_ERR_CNT;                   /* addr: 0x00000148 */
  ca_uint32_t                              rsrvd83[3];                   
  EPON_ONU_EPON_CRC8_ERR_CNT_t             CRC8_ERR_CNT;                  /* addr: 0x0000014c */
  ca_uint32_t                              rsrvd84[3];                   
  EPON_ONU_EPON_IPG_DROP_CNT_t             IPG_DROP_CNT;                  /* addr: 0x00000150 */
  ca_uint32_t                              rsrvd85[3];                   
  EPON_ONU_EPON_MISC_t                     MISC;                          /* addr: 0x00000154 */
  ca_uint32_t                              rsrvd86[3];                   
  EPON_ONU_EPON_RXCTRL_STS_t               RXCTRL_STS;                    /* addr: 0x00000158 */
  ca_uint32_t                              rsrvd87[3];                   
  EPON_ONU_EPON_AES_DEC_LLID_INDEX_0_t     AES_DEC_LLID_INDEX_0;          /* addr: 0x0000015c */
  ca_uint32_t                              rsrvd88[31];                  
  EPON_ONU_EPON_AES_DEC_KEY_TBL_ACCESS_t   AES_DEC_KEY_TBL_ACCESS;        /* addr: 0x0000017c */
  ca_uint32_t                              rsrvd89[3];                   
  EPON_ONU_EPON_AES_DEC_KEY_TBL_DATA3_t    AES_DEC_KEY_TBL_DATA3;         /* addr: 0x00000180 */
  ca_uint32_t                              rsrvd90[3];                   
  EPON_ONU_EPON_AES_DEC_KEY_TBL_DATA2_t    AES_DEC_KEY_TBL_DATA2;         /* addr: 0x00000184 */
  ca_uint32_t                              rsrvd91[3];                   
  EPON_ONU_EPON_AES_DEC_KEY_TBL_DATA1_t    AES_DEC_KEY_TBL_DATA1;         /* addr: 0x00000188 */
  ca_uint32_t                              rsrvd92[3];                   
  EPON_ONU_EPON_AES_DEC_KEY_TBL_DATA0_t    AES_DEC_KEY_TBL_DATA0;         /* addr: 0x0000018c */
} APB1_EPON_ONU_EPON_t;


/*
 * onu_1pps
 */
        
#define EPON_ONU_1PPS_INTERRUPT_SOURCE           0xd0030c00
#define EPON_ONU_1PPS_INTERRUPT_SOURCE_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pps_timeout          :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_1PPS_INTERRUPT_SOURCE_t;


#define EPON_ONU_1PPS_INTERRUPT_SOURCEE          0xd0030c04
#define EPON_ONU_1PPS_INTERRUPT_SOURCEE_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pps_timeoutE         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_1PPS_INTERRUPT_SOURCEE_t;


#define EPON_ONU_1PPS_CFG                        0xd0030c08
#define EPON_ONU_1PPS_CFG_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t gen_1pps_tod_en      :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_1PPS_CFG_t;


#define EPON_ONU_1PPS_TOD_S_PPS                  0xd0030c0c
#define EPON_ONU_1PPS_TOD_S_PPS_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t s_pps                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_1PPS_TOD_S_PPS_t;


#define EPON_ONU_1PPS_TOD_PPS_WID                0xd0030c10
#define EPON_ONU_1PPS_TOD_PPS_WID_dft            0x0000000f

typedef volatile union {
  struct {
    ca_uint32_t pps_width            : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_1PPS_TOD_PPS_WID_t;


#define EPON_ONU_1PPS_TOD_S_TOD                  0xd0030c14
#define EPON_ONU_1PPS_TOD_S_TOD_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t s_tod                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_1PPS_TOD_S_TOD_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* onu_1pps */
typedef struct {
  EPON_ONU_1PPS_INTERRUPT_SOURCE_t         INTERRUPT_SOURCE;              /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  EPON_ONU_1PPS_INTERRUPT_SOURCEE_t        INTERRUPT_SOURCEE;             /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  EPON_ONU_1PPS_CFG_t                      CFG;                           /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  EPON_ONU_1PPS_TOD_S_PPS_t                TOD_S_PPS;                     /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  EPON_ONU_1PPS_TOD_PPS_WID_t              TOD_PPS_WID;                   /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  EPON_ONU_1PPS_TOD_S_TOD_t                TOD_S_TOD;                     /* addr: 0x00000014 */
} APB1_EPON_ONU_1PPS_t;


/*
 * glb_ptp
 */
        
#define EPON_GLB_PTP_INTERRUPT_ENABLE            0xd0030d00
#define EPON_GLB_PTP_INTERRUPT_ENABLE_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t gpsEnable1           :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd2               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_GLB_PTP_INTERRUPT_ENABLE_t;


#define EPON_GLB_PTP_INTERRUPT_SOURCE            0xd0030d04
#define EPON_GLB_PTP_INTERRUPT_SOURCE_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t gpsIRQ1              :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd2               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_GLB_PTP_INTERRUPT_SOURCE_t;


#define EPON_GLB_PTP_PTP_LTH_SRC_REG             0xd0030d08
#define EPON_GLB_PTP_PTP_LTH_SRC_REG_dft         0x000000e0

typedef volatile union {
  struct {
    ca_uint32_t slt_pad_gps          :  1 ; /* bits 0:0 */
    ca_uint32_t slt_sw_gps           :  1 ; /* bits 1:1 */
    ca_uint32_t slt_pps_gps          :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t add_adjust_timer     :  1 ; /* bits 5:5 */
    ca_uint32_t add_adjust_timer_s   :  1 ; /* bits 6:6 */
    ca_uint32_t reg_ptp_sync         :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd2               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_GLB_PTP_PTP_LTH_SRC_REG_t;


#define EPON_GLB_PTP_GLOBAL_TIMER_REG            0xd0030d0c
#define EPON_GLB_PTP_GLOBAL_TIMER_REG_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t glb_timer            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_GLB_PTP_GLOBAL_TIMER_REG_t;


#define EPON_GLB_PTP_ADJUST_TIMER_REG            0xd0030d10
#define EPON_GLB_PTP_ADJUST_TIMER_REG_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t adjust_timer         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_GLB_PTP_ADJUST_TIMER_REG_t;


#define EPON_GLB_PTP_GLOBAL_TIMER_S_LO_REG       0xd0030d14
#define EPON_GLB_PTP_GLOBAL_TIMER_S_LO_REG_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t glb_timer_s_lo       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_GLB_PTP_GLOBAL_TIMER_S_LO_REG_t;


#define EPON_GLB_PTP_GLOBAL_TIMER_S_HI_REG       0xd0030d18
#define EPON_GLB_PTP_GLOBAL_TIMER_S_HI_REG_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t glb_timer_s_hi       : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_GLB_PTP_GLOBAL_TIMER_S_HI_REG_t;


#define EPON_GLB_PTP_GLOBAL_CNT_1S_REG           0xd0030d1c
#define EPON_GLB_PTP_GLOBAL_CNT_1S_REG_dft       0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t cnt_1s               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_GLB_PTP_GLOBAL_CNT_1S_REG_t;


#define EPON_GLB_PTP_ADJUST_TIMER_S_LO_REG       0xd0030d20
#define EPON_GLB_PTP_ADJUST_TIMER_S_LO_REG_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t adjust_timer_s_lo    : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_GLB_PTP_ADJUST_TIMER_S_LO_REG_t;


#define EPON_GLB_PTP_ADJUST_TIMER_S_HI_REG       0xd0030d24
#define EPON_GLB_PTP_ADJUST_TIMER_S_HI_REG_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t adjust_timer_s_hi    : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_GLB_PTP_ADJUST_TIMER_S_HI_REG_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* glb_ptp */
typedef struct {
  EPON_GLB_PTP_INTERRUPT_ENABLE_t          INTERRUPT_ENABLE;              /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  EPON_GLB_PTP_INTERRUPT_SOURCE_t          INTERRUPT_SOURCE;              /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  EPON_GLB_PTP_PTP_LTH_SRC_REG_t           PTP_LTH_SRC_REG;               /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  EPON_GLB_PTP_GLOBAL_TIMER_REG_t          GLOBAL_TIMER_REG;              /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  EPON_GLB_PTP_ADJUST_TIMER_REG_t          ADJUST_TIMER_REG;              /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  EPON_GLB_PTP_GLOBAL_TIMER_S_LO_REG_t     GLOBAL_TIMER_S_LO_REG;         /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  EPON_GLB_PTP_GLOBAL_TIMER_S_HI_REG_t     GLOBAL_TIMER_S_HI_REG;         /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  EPON_GLB_PTP_GLOBAL_CNT_1S_REG_t         GLOBAL_CNT_1S_REG;             /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  EPON_GLB_PTP_ADJUST_TIMER_S_LO_REG_t     ADJUST_TIMER_S_LO_REG;         /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  EPON_GLB_PTP_ADJUST_TIMER_S_HI_REG_t     ADJUST_TIMER_S_HI_REG;         /* addr: 0x00000024 */
} APB1_EPON_GLB_PTP_t;


/*
 * onu_lt
 */
        
#define EPON_ONU_LT_RTT_COMPENSATION_CFG_1G_RX   0xd0030f00
#define EPON_ONU_LT_RTT_COMPENSATION_CFG_1G_RX_dft 0x00310001

typedef volatile union {
  struct {
    ca_uint32_t csrB                 : 16 ; /* bits 15:0 */
    ca_uint32_t csrA                 : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_LT_RTT_COMPENSATION_CFG_1G_RX_t;


#define EPON_ONU_LT_RTT_COMPENSATION_CFG_1G_TX   0xd0030f04
#define EPON_ONU_LT_RTT_COMPENSATION_CFG_1G_TX_dft 0x00120011

typedef volatile union {
  struct {
    ca_uint32_t csrD                 : 16 ; /* bits 15:0 */
    ca_uint32_t csrC                 : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_LT_RTT_COMPENSATION_CFG_1G_TX_t;


#define EPON_ONU_LT_RTT_COMPENSATION_CFG_10G_RX  0xd0030f08
#define EPON_ONU_LT_RTT_COMPENSATION_CFG_10G_RX_dft 0x005c0004

typedef volatile union {
  struct {
    ca_uint32_t csrB                 : 16 ; /* bits 15:0 */
    ca_uint32_t csrA                 : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_LT_RTT_COMPENSATION_CFG_10G_RX_t;


#define EPON_ONU_LT_RTT_COMPENSATION_CFG_10G_TX  0xd0030f0c
#define EPON_ONU_LT_RTT_COMPENSATION_CFG_10G_TX_dft 0x001b0016

typedef volatile union {
  struct {
    ca_uint32_t csrD                 : 16 ; /* bits 15:0 */
    ca_uint32_t csrC                 : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_LT_RTT_COMPENSATION_CFG_10G_TX_t;


#define EPON_ONU_LT_RTT_COMPENSATION_TXMAC_OFFSET 0xd0030f10
#define EPON_ONU_LT_RTT_COMPENSATION_TXMAC_OFFSET_dft 0x00160013

typedef volatile union {
  struct {
    ca_uint32_t tx1g                 : 16 ; /* bits 15:0 */
    ca_uint32_t tx10g                : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_LT_RTT_COMPENSATION_TXMAC_OFFSET_t;


#define EPON_ONU_LT_MISC_CFG                     0xd0030f14
#define EPON_ONU_LT_MISC_CFG_dft                 0x00000002

typedef volatile union {
  struct {
    ca_uint32_t forbidden_win_size   :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_LT_MISC_CFG_t;


#define EPON_ONU_LT_MPCP_TIMER_MATCH_CFG         0xd0030f18
#define EPON_ONU_LT_MPCP_TIMER_MATCH_CFG_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t epon_mpcp_timer_match_val : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_LT_MPCP_TIMER_MATCH_CFG_t;


#define EPON_ONU_LT_LAST_DRIFT                   0xd0030f1c
#define EPON_ONU_LT_LAST_DRIFT_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t last_drift_value     : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_LT_LAST_DRIFT_t;


#define EPON_ONU_LT_SDS_DLY                      0xd0030f20
#define EPON_ONU_LT_SDS_DLY_dft                  0x01010101

typedef volatile union {
  struct {
    ca_uint32_t tx1g                 :  8 ; /* bits 7:0 */
    ca_uint32_t rx1g                 :  8 ; /* bits 15:8 */
    ca_uint32_t tx10g                :  8 ; /* bits 23:16 */
    ca_uint32_t rx10g                :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_ONU_LT_SDS_DLY_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* onu_lt */
typedef struct {
  EPON_ONU_LT_RTT_COMPENSATION_CFG_1G_RX_t RTT_COMPENSATION_CFG_1G_RX;    /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  EPON_ONU_LT_RTT_COMPENSATION_CFG_1G_TX_t RTT_COMPENSATION_CFG_1G_TX;    /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  EPON_ONU_LT_RTT_COMPENSATION_CFG_10G_RX_t RTT_COMPENSATION_CFG_10G_RX;   /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  EPON_ONU_LT_RTT_COMPENSATION_CFG_10G_TX_t RTT_COMPENSATION_CFG_10G_TX;   /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  EPON_ONU_LT_RTT_COMPENSATION_TXMAC_OFFSET_t RTT_COMPENSATION_TXMAC_OFFSET; /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  EPON_ONU_LT_MISC_CFG_t                   MISC_CFG;                      /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  EPON_ONU_LT_MPCP_TIMER_MATCH_CFG_t       MPCP_TIMER_MATCH_CFG;          /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  EPON_ONU_LT_LAST_DRIFT_t                 LAST_DRIFT;                    /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  EPON_ONU_LT_SDS_DLY_t                    SDS_DLY;                       /* addr: 0x00000020 */
} APB1_EPON_ONU_LT_t;


/*
 * XGEPN
 */
  
/*
 * xmac
 */
  
/*
 * txmac
 */
        
#define EPON_XGEPN_XMAC_TXMAC_CONFIG             0xd0031000
#define EPON_XGEPN_XMAC_TXMAC_CONFIG_dft         0x7fff106a

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t xgepcs               :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t ins_2idles           :  1 ; /* bits 3:3 */
    ca_uint32_t sel_t4burst_ctrl     :  1 ; /* bits 4:4 */
    ca_uint32_t eob_cnt              :  3 ; /* bits 7:5 */
    ca_uint32_t idl_cnt              :  3 ; /* bits 10:8 */
    ca_uint32_t en_true_burst_end    :  1 ; /* bits 11:11 */
    ca_uint32_t en_txf_empty_end     :  1 ; /* bits 12:12 */
    ca_uint32_t en_dfemp_burst_end   :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd3               :  2 ;
    ca_uint32_t txp_resend_quanta    : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_TXMAC_CONFIG_t;


#define EPON_XGEPN_XMAC_TXMAC_TX_CONFIG          0xd0031004
#define EPON_XGEPN_XMAC_TXMAC_TX_CONFIG_dft      0x1c40c030

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t reset                :  1 ; /* bits 1:1 */
    ca_uint32_t tx_pause_en          :  1 ; /* bits 2:2 */
    ca_uint32_t mac_en               :  1 ; /* bits 3:3 */
    ca_uint32_t crc_recaculate_en    :  1 ; /* bits 4:4 */
    ca_uint32_t ch_timestamp         :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t loopback             :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd3               :  4 ;
    ca_uint32_t ipg_minimal          :  5 ; /* bits 16:12 */
    ca_uint32_t dic_maximum          :  2 ; /* bits 18:17 */
    ca_uint32_t rsrvd4               :  1 ;
    ca_uint32_t burst_cnt            :  5 ; /* bits 24:20 */
    ca_uint32_t burst_testmode       :  1 ; /* bits 25:25 */
    ca_uint32_t burst_end_cnt        :  5 ; /* bits 30:26 */
    ca_uint32_t burst_end_test_mode  :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_TXMAC_TX_CONFIG_t;


#define EPON_XGEPN_XMAC_TXMAC_TX_PAKT_MIB0       0xd0031008
#define EPON_XGEPN_XMAC_TXMAC_TX_PAKT_MIB0_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t latch                :  1 ; /* bits 16:16 */
    ca_uint32_t clr                  :  1 ; /* bits 17:17 */
    ca_uint32_t match                :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_TXMAC_TX_PAKT_MIB0_t;


#define EPON_XGEPN_XMAC_TXMAC_TX_PAKT_MIB1       0xd003100c
#define EPON_XGEPN_XMAC_TXMAC_TX_PAKT_MIB1_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t count                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_TXMAC_TX_PAKT_MIB1_t;


#define EPON_XGEPN_XMAC_TXMAC_MACSEC_LLIDEN0     0xd0031010
#define EPON_XGEPN_XMAC_TXMAC_MACSEC_LLIDEN0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid_sec_en          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_TXMAC_MACSEC_LLIDEN0_t;


#define EPON_XGEPN_XMAC_TXMAC_SECTAG_LLIDEN0     0xd0031014
#define EPON_XGEPN_XMAC_TXMAC_SECTAG_LLIDEN0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sectag_type          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_TXMAC_SECTAG_LLIDEN0_t;


#define EPON_XGEPN_XMAC_TXMAC_PKT_TYPE_EN        0xd0031018
#define EPON_XGEPN_XMAC_TXMAC_PKT_TYPE_EN_dft    0x88080000

typedef volatile union {
  struct {
    ca_uint32_t ethernettype_sec_en  :  1 ; /* bits 0:0 */
    ca_uint32_t oam_sec_en           :  1 ; /* bits 1:1 */
    ca_uint32_t mpcp_sec_en          :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 13 ;
    ca_uint32_t pkt_type             : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_TXMAC_PKT_TYPE_EN_t;


#define EPON_XGEPN_XMAC_TXMAC_XGEPN_BURST_TEST   0xd003101c
#define EPON_XGEPN_XMAC_TXMAC_XGEPN_BURST_TEST_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sync_st_testmode     :  1 ; /* bits 0:0 */
    ca_uint32_t xgepn_st_testmode    :  1 ; /* bits 1:1 */
    ca_uint32_t xgepn_end_testmode   :  1 ; /* bits 2:2 */
    ca_uint32_t xgepn_trueend_testmode :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_TXMAC_XGEPN_BURST_TEST_t;


#define EPON_XGEPN_XMAC_TXMAC_XGEPN_TX_FIFO_UNDERFLOW 0xd0031020
#define EPON_XGEPN_XMAC_TXMAC_XGEPN_TX_FIFO_UNDERFLOW_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t async_tx_underflow   :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_TXMAC_XGEPN_TX_FIFO_UNDERFLOW_t;


#define EPON_XGEPN_XMAC_TXMAC_XGEPN_TX_DBG       0xd0031024
#define EPON_XGEPN_XMAC_TXMAC_XGEPN_TX_DBG_dft   0x00000009

typedef volatile union {
  struct {
    ca_uint32_t dbg                  : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_TXMAC_XGEPN_TX_DBG_t;


#define EPON_XGEPN_XMAC_TXMAC_XGEPN_PAUSE_QUANTA 0xd0031028
#define EPON_XGEPN_XMAC_TXMAC_XGEPN_PAUSE_QUANTA_dft 0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t rx_pause_quanta      : 16 ; /* bits 15:0 */
    ca_uint32_t tx_pause_quanta      : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_TXMAC_XGEPN_PAUSE_QUANTA_t;


#define EPON_XGEPN_XMAC_TXMAC_XGEPN_RX_PAUSE     0xd003102c
#define EPON_XGEPN_XMAC_TXMAC_XGEPN_RX_PAUSE_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t trig                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_TXMAC_XGEPN_RX_PAUSE_t;


#define EPON_XGEPN_XMAC_TXMAC_XGEPN_TX_PAUSE     0xd0031030
#define EPON_XGEPN_XMAC_TXMAC_XGEPN_TX_PAUSE_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t trig                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_TXMAC_XGEPN_TX_PAUSE_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* txmac */
typedef struct {
  EPON_XGEPN_XMAC_TXMAC_CONFIG_t           CONFIG;                        /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  EPON_XGEPN_XMAC_TXMAC_TX_CONFIG_t        TX_CONFIG;                     /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  EPON_XGEPN_XMAC_TXMAC_TX_PAKT_MIB0_t     TX_PAKT_MIB0;                  /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  EPON_XGEPN_XMAC_TXMAC_TX_PAKT_MIB1_t     TX_PAKT_MIB1;                  /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  EPON_XGEPN_XMAC_TXMAC_MACSEC_LLIDEN0_t   MACSEC_LLIDEN0;                /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  EPON_XGEPN_XMAC_TXMAC_SECTAG_LLIDEN0_t   SECTAG_LLIDEN0;                /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  EPON_XGEPN_XMAC_TXMAC_PKT_TYPE_EN_t      PKT_TYPE_EN;                   /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  EPON_XGEPN_XMAC_TXMAC_XGEPN_BURST_TEST_t XGEPN_BURST_TEST;              /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  EPON_XGEPN_XMAC_TXMAC_XGEPN_TX_FIFO_UNDERFLOW_t XGEPN_TX_FIFO_UNDERFLOW;       /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  EPON_XGEPN_XMAC_TXMAC_XGEPN_TX_DBG_t     XGEPN_TX_DBG;                  /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  EPON_XGEPN_XMAC_TXMAC_XGEPN_PAUSE_QUANTA_t XGEPN_PAUSE_QUANTA;            /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  EPON_XGEPN_XMAC_TXMAC_XGEPN_RX_PAUSE_t   XGEPN_RX_PAUSE;                /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  EPON_XGEPN_XMAC_TXMAC_XGEPN_TX_PAUSE_t   XGEPN_TX_PAUSE;                /* addr: 0x00000030 */
} APB1_EPON_XGEPN_XMAC_TXMAC_t;


/*
 * rxmac
 */
        
#define EPON_XGEPN_XMAC_RXMAC_RX_MPCP0           0xd00310b0
#define EPON_XGEPN_XMAC_RXMAC_RX_MPCP0_dft       0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t reg_sts              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_RXMAC_RX_MPCP0_t;


#define EPON_XGEPN_XMAC_RXMAC_RX_CONFIG          0xd00310b4
#define EPON_XGEPN_XMAC_RXMAC_RX_CONFIG_dft      0x5ffe1210

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t reset                :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t mpcp_lt_emb          :  1 ; /* bits 3:3 */
    ca_uint32_t mpcp_crc_chk         :  1 ; /* bits 4:4 */
    ca_uint32_t llid_filter_dis      :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t mac_en               :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd4               :  1 ;
    ca_uint32_t pause_en             :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd5               :  1 ;
    ca_uint32_t en_old_fsm           :  1 ; /* bits 11:11 */
    ca_uint32_t dis_rtt_ts_adj       :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd6               :  4 ;
    ca_uint32_t max_size             : 14 ; /* bits 30:17 */
    ca_uint32_t rsrvd7               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_RXMAC_RX_CONFIG_t;


#define EPON_XGEPN_XMAC_RXMAC_RX_PKT_DET         0xd00310b8
#define EPON_XGEPN_XMAC_RXMAC_RX_PKT_DET_dft     0x00251bff

typedef volatile union {
  struct {
    ca_uint32_t check_idle           :  1 ; /* bits 0:0 */
    ca_uint32_t check_start          :  1 ; /* bits 1:1 */
    ca_uint32_t check_sld            :  1 ; /* bits 2:2 */
    ca_uint32_t check_preamble       :  1 ; /* bits 3:3 */
    ca_uint32_t check_llid           :  1 ; /* bits 4:4 */
    ca_uint32_t check_sfd            :  1 ; /* bits 5:5 */
    ca_uint32_t check_terminate      :  1 ; /* bits 6:6 */
    ca_uint32_t mc_mpcp              :  6 ; /* bits 12:7 */
    ca_uint32_t uc_mpcp              :  6 ; /* bits 18:13 */
    ca_uint32_t slow_subtype         :  3 ; /* bits 21:19 */
    ca_uint32_t mpcp_fw              :  6 ; /* bits 27:22 */
    ca_uint32_t rsrvd1               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_RXMAC_RX_PKT_DET_t;


#define EPON_XGEPN_XMAC_RXMAC_RX_LOCALTIME_ADJUST 0xd00310bc
#define EPON_XGEPN_XMAC_RXMAC_RX_LOCALTIME_ADJUST_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t adjust_loctimer      : 17 ; /* bits 16:0 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_RXMAC_RX_LOCALTIME_ADJUST_t;


#define EPON_XGEPN_XMAC_RXMAC_RX_PAKT_MIB0       0xd00310c0
#define EPON_XGEPN_XMAC_RXMAC_RX_PAKT_MIB0_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t latch                :  1 ; /* bits 16:16 */
    ca_uint32_t clr                  :  1 ; /* bits 17:17 */
    ca_uint32_t match                :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_RXMAC_RX_PAKT_MIB0_t;


#define EPON_XGEPN_XMAC_RXMAC_RX_PAKT_MIB1       0xd00310c4
#define EPON_XGEPN_XMAC_RXMAC_RX_PAKT_MIB1_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t count                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_RXMAC_RX_PAKT_MIB1_t;


#define EPON_XGEPN_XMAC_RXMAC_XGEPN_SLD_CRC8_ERRCNT 0xd00310c8
#define EPON_XGEPN_XMAC_RXMAC_XGEPN_SLD_CRC8_ERRCNT_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sld_crc8_err_cnt     : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_RXMAC_XGEPN_SLD_CRC8_ERRCNT_t;


#define EPON_XGEPN_XMAC_RXMAC_XGEPN_RX_PKT_HEAD0 0xd00310cc
#define EPON_XGEPN_XMAC_RXMAC_XGEPN_RX_PKT_HEAD0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_RXMAC_XGEPN_RX_PKT_HEAD0_t;


#define EPON_XGEPN_XMAC_RXMAC_XGEPN_RX_PKT_HEAD1 0xd00310d0
#define EPON_XGEPN_XMAC_RXMAC_XGEPN_RX_PKT_HEAD1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t header               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_RXMAC_XGEPN_RX_PKT_HEAD1_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* rxmac */
typedef struct {
  EPON_XGEPN_XMAC_RXMAC_RX_MPCP0_t         RX_MPCP0;                      /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  EPON_XGEPN_XMAC_RXMAC_RX_CONFIG_t        RX_CONFIG;                     /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  EPON_XGEPN_XMAC_RXMAC_RX_PKT_DET_t       RX_PKT_DET;                    /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  EPON_XGEPN_XMAC_RXMAC_RX_LOCALTIME_ADJUST_t RX_LOCALTIME_ADJUST;           /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  EPON_XGEPN_XMAC_RXMAC_RX_PAKT_MIB0_t     RX_PAKT_MIB0;                  /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  EPON_XGEPN_XMAC_RXMAC_RX_PAKT_MIB1_t     RX_PAKT_MIB1;                  /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  EPON_XGEPN_XMAC_RXMAC_XGEPN_SLD_CRC8_ERRCNT_t XGEPN_SLD_CRC8_ERRCNT;         /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  EPON_XGEPN_XMAC_RXMAC_XGEPN_RX_PKT_HEAD0_t XGEPN_RX_PKT_HEAD0;            /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  EPON_XGEPN_XMAC_RXMAC_XGEPN_RX_PKT_HEAD1_t XGEPN_RX_PKT_HEAD1;            /* addr: 0x00000020 */
} APB1_EPON_XGEPN_XMAC_RXMAC_t;


/*
 * ctrl
 */
        
#define EPON_XGEPN_XMAC_CTRL_XGEPN_RX_CTL        0xd0031250
#define EPON_XGEPN_XMAC_CTRL_XGEPN_RX_CTL_dft    0x380ff000

typedef volatile union {
  struct {
    ca_uint32_t ptp_da_en            :  1 ; /* bits 0:0 */
    ca_uint32_t clr_rcffoverrun      :  1 ; /* bits 1:1 */
    ca_uint32_t drop_ptp_pkt_type    : 10 ; /* bits 11:2 */
    ca_uint32_t frame_error_drop_en  :  1 ; /* bits 12:12 */
    ca_uint32_t frame_fcs_error_drop_en :  1 ; /* bits 13:13 */
    ca_uint32_t frame_unopcode_drop_en :  1 ; /* bits 14:14 */
    ca_uint32_t frame_pause_drop_en  :  1 ; /* bits 15:15 */
    ca_uint32_t frame_runt_drop_en   :  1 ; /* bits 16:16 */
    ca_uint32_t frame_oversize_drop_en :  1 ; /* bits 17:17 */
    ca_uint32_t frame_ffoverflow_drop_en :  1 ; /* bits 18:18 */
    ca_uint32_t frame_mpcp_drop_en   :  1 ; /* bits 19:19 */
    ca_uint32_t ptp_ing_ts_cmp       :  5 ; /* bits 24:20 */
    ca_uint32_t frame_exmpcp_datadrop_en :  1 ; /* bits 25:25 */
    ca_uint32_t frame_unda_drop_en   :  1 ; /* bits 26:26 */
    ca_uint32_t frame_invld_llid_drop_en :  1 ; /* bits 27:27 */
    ca_uint32_t frame_keyex_oam_drop_en :  1 ; /* bits 28:28 */
    ca_uint32_t frame_exmpcp_mpcpdrop_en :  1 ; /* bits 29:29 */
    ca_uint32_t frame_bytecnt_drop_en :  1 ; /* bits 30:30 */
    ca_uint32_t bypass               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_RX_CTL_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_CTL        0xd0031254
#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_CTL_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t tx_remheader_dis     :  1 ; /* bits 1:1 */
    ca_uint32_t bm_pausereq_sel      :  1 ; /* bits 2:2 */
    ca_uint32_t tx_pad_en            :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t ptp_eg_ts_comp       :  5 ; /* bits 9:5 */
    ca_uint32_t rsrvd3               : 18 ;
    ca_uint32_t dbg_bus_sel          :  4 ; /* bits 31:28 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_TX_CTL_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_FF_THRESHOLD 0xd0031258
#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_FF_THRESHOLD_dft 0x00f0702b

typedef volatile union {
  struct {
    ca_uint32_t txff_wrff_threshold  :  4 ; /* bits 3:0 */
    ca_uint32_t txff_rdff_threshold  :  4 ; /* bits 7:4 */
    ca_uint32_t txctl_wrff_threshold :  7 ; /* bits 14:8 */
    ca_uint32_t rsrvd1               :  5 ;
    ca_uint32_t txctl_rdff_threshold :  7 ; /* bits 26:20 */
    ca_uint32_t rsrvd2               :  5 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_TX_FF_THRESHOLD_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_RX_STATUS0    0xd003125c
#define EPON_XGEPN_XMAC_CTRL_XGEPN_RX_STATUS0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rcdrop_cnt           : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_RX_STATUS0_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_RX_STATUS1    0xd0031260
#define EPON_XGEPN_XMAC_CTRL_XGEPN_RX_STATUS1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rcff_pktnum          :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_RX_STATUS1_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_STATUS2    0xd0031264
#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_STATUS2_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tcff_pktnum          :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_TX_STATUS2_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_STATUS3    0xd0031268
#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_STATUS3_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t length_mismatch      :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_TX_STATUS3_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_STATUS4    0xd003126c
#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_STATUS4_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t es_runt_pkt          :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_TX_STATUS4_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_FF_STATUS     0xd0031270
#define EPON_XGEPN_XMAC_CTRL_XGEPN_FF_STATUS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_ffempty           :  1 ; /* bits 0:0 */
    ca_uint32_t tx_fffull            :  1 ; /* bits 1:1 */
    ca_uint32_t rx_ffempty           :  1 ; /* bits 2:2 */
    ca_uint32_t rx_fffull            :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_FF_STATUS_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_INTERRUPT     0xd0031274
#define EPON_XGEPN_XMAC_CTRL_XGEPN_INTERRUPT_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rc_ffoverrun_intI    :  1 ; /* bits 0:0 */
    ca_uint32_t mpcp_ffoverrun_intI  :  1 ; /* bits 1:1 */
    ca_uint32_t burst_end_mismatch_intI :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 13 ;
    ca_uint32_t rc_ptp_pkt_intI      :  1 ; /* bits 16:16 */
    ca_uint32_t tc_ptp_pkt_intI      :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd2               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_INTERRUPT_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_INTERRUPTE0   0xd0031278
#define EPON_XGEPN_XMAC_CTRL_XGEPN_INTERRUPTE0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rc_ffoverrun_intIE   :  1 ; /* bits 0:0 */
    ca_uint32_t mpcp_ffoverrun_intIE :  1 ; /* bits 1:1 */
    ca_uint32_t burst_end_mismatch_intIE :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 13 ;
    ca_uint32_t rc_ptp_pkt_intIE     :  1 ; /* bits 16:16 */
    ca_uint32_t tc_ptp_pkt_intIE     :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd2               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_INTERRUPTE0_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_INTERRUPTE1   0xd003127c
#define EPON_XGEPN_XMAC_CTRL_XGEPN_INTERRUPTE1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rc_ffoverrun_intIE   :  1 ; /* bits 0:0 */
    ca_uint32_t mpcp_ffoverrun_intIE :  1 ; /* bits 1:1 */
    ca_uint32_t burst_end_mismatch_intIE :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 13 ;
    ca_uint32_t rc_ptp_pkt_intIE     :  1 ; /* bits 16:16 */
    ca_uint32_t tc_ptp_pkt_intIE     :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd2               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_INTERRUPTE1_t;


#define EPON_XGEPN_XMAC_CTRL_RX_BYTE_MIB0        0xd0031280
#define EPON_XGEPN_XMAC_CTRL_RX_BYTE_MIB0_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t latch                :  1 ; /* bits 16:16 */
    ca_uint32_t clr                  :  1 ; /* bits 17:17 */
    ca_uint32_t match                :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_RX_BYTE_MIB0_t;


#define EPON_XGEPN_XMAC_CTRL_RX_BYTE_MIB1        0xd0031284
#define EPON_XGEPN_XMAC_CTRL_RX_BYTE_MIB1_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t count                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_RX_BYTE_MIB1_t;


#define EPON_XGEPN_XMAC_CTRL_RX_MPCP_MIB0        0xd0031288
#define EPON_XGEPN_XMAC_CTRL_RX_MPCP_MIB0_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t latch                :  1 ; /* bits 16:16 */
    ca_uint32_t clr                  :  1 ; /* bits 17:17 */
    ca_uint32_t match                :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_RX_MPCP_MIB0_t;


#define EPON_XGEPN_XMAC_CTRL_RX_MPCP_MIB1        0xd003128c
#define EPON_XGEPN_XMAC_CTRL_RX_MPCP_MIB1_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t count                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_RX_MPCP_MIB1_t;


#define EPON_XGEPN_XMAC_CTRL_RX_OAM_MIB0         0xd0031290
#define EPON_XGEPN_XMAC_CTRL_RX_OAM_MIB0_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 16 ;
    ca_uint32_t latch                :  1 ; /* bits 16:16 */
    ca_uint32_t clr                  :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd2               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_RX_OAM_MIB0_t;


#define EPON_XGEPN_XMAC_CTRL_RX_OAM_MIB1         0xd0031294
#define EPON_XGEPN_XMAC_CTRL_RX_OAM_MIB1_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t count                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_RX_OAM_MIB1_t;


#define EPON_XGEPN_XMAC_CTRL_TX_BYTE_MIB0        0xd0031298
#define EPON_XGEPN_XMAC_CTRL_TX_BYTE_MIB0_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t latch                :  1 ; /* bits 16:16 */
    ca_uint32_t clr                  :  1 ; /* bits 17:17 */
    ca_uint32_t match                :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_TX_BYTE_MIB0_t;


#define EPON_XGEPN_XMAC_CTRL_TX_BYTE_MIB1        0xd003129c
#define EPON_XGEPN_XMAC_CTRL_TX_BYTE_MIB1_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t count                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_TX_BYTE_MIB1_t;


#define EPON_XGEPN_XMAC_CTRL_TX_MPCP_MIB0        0xd00312a0
#define EPON_XGEPN_XMAC_CTRL_TX_MPCP_MIB0_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t llid                 : 16 ; /* bits 15:0 */
    ca_uint32_t latch                :  1 ; /* bits 16:16 */
    ca_uint32_t clr                  :  1 ; /* bits 17:17 */
    ca_uint32_t match                :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_TX_MPCP_MIB0_t;


#define EPON_XGEPN_XMAC_CTRL_TX_MPCP_MIB1        0xd00312a4
#define EPON_XGEPN_XMAC_CTRL_TX_MPCP_MIB1_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t count                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_TX_MPCP_MIB1_t;


#define EPON_XGEPN_XMAC_CTRL_TX_OAM_MIB0         0xd00312a8
#define EPON_XGEPN_XMAC_CTRL_TX_OAM_MIB0_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 16 ;
    ca_uint32_t latch                :  1 ; /* bits 16:16 */
    ca_uint32_t clr                  :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd2               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_TX_OAM_MIB0_t;


#define EPON_XGEPN_XMAC_CTRL_TX_OAM_MIB1         0xd00312ac
#define EPON_XGEPN_XMAC_CTRL_TX_OAM_MIB1_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t count                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_TX_OAM_MIB1_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_TM     0xd00312b0
#define EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_TM_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ptp_tm               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_TM_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_TM_S_LO 0xd00312b4
#define EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_TM_S_LO_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ptp_tm               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_TM_S_LO_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_TM_S_HI 0xd00312b8
#define EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_TM_S_HI_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ptp_tm               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_TM_S_HI_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_TYPE   0xd00312bc
#define EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_TYPE_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ptp_type             :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_TYPE_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_SQID   0xd00312c0
#define EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_SQID_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sq_id                : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_SQID_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_TM     0xd00312c4
#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_TM_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ptp_tm               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_TM_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_TM_S_LO 0xd00312c8
#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_TM_S_LO_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ptp_tm               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_TM_S_LO_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_TM_S_HI 0xd00312cc
#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_TM_S_HI_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ptp_tm               : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_TM_S_HI_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_SQID   0xd00312d0
#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_SQID_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sq_id                : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_SQID_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_TYPE   0xd00312d4
#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_TYPE_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ptp_type             :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_TYPE_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_PTP_VLAN0     0xd00312d8
#define EPON_XGEPN_XMAC_CTRL_XGEPN_PTP_VLAN0_dft 0x81009100

typedef volatile union {
  struct {
    ca_uint32_t vlan0                : 16 ; /* bits 15:0 */
    ca_uint32_t vlan1                : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_PTP_VLAN0_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_PTP_VLAN1     0xd00312dc
#define EPON_XGEPN_XMAC_CTRL_XGEPN_PTP_VLAN1_dft 0x81009100

typedef volatile union {
  struct {
    ca_uint32_t vlan0                : 16 ; /* bits 15:0 */
    ca_uint32_t vlan1                : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_PTP_VLAN1_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_RX_DBG        0xd00312e0
#define EPON_XGEPN_XMAC_CTRL_XGEPN_RX_DBG_dft    0x80000009

typedef volatile union {
  struct {
    ca_uint32_t dbg                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_RX_DBG_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_DBG        0xd00312e4
#define EPON_XGEPN_XMAC_CTRL_XGEPN_TX_DBG_dft    0x0000000e

typedef volatile union {
  struct {
    ca_uint32_t dbg                  : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_TX_DBG_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_RXFPGA_DROPCNT 0xd00312e8
#define EPON_XGEPN_XMAC_CTRL_XGEPN_RXFPGA_DROPCNT_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t asyncff_dropcnt      : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_RXFPGA_DROPCNT_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_RXFPGA_FF_THRESHOLD 0xd00312ec
#define EPON_XGEPN_XMAC_CTRL_XGEPN_RXFPGA_FF_THRESHOLD_dft 0x30000090

typedef volatile union {
  struct {
    ca_uint32_t rx_wrff_threshold    :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 20 ;
    ca_uint32_t rx_rdff_ipg          :  3 ; /* bits 30:28 */
    ca_uint32_t rsrvd2               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_RXFPGA_FF_THRESHOLD_t;


#define EPON_XGEPN_XMAC_CTRL_XGEPN_TXFPGA_FF_THRESHOLD 0xd00312f0
#define EPON_XGEPN_XMAC_CTRL_XGEPN_TXFPGA_FF_THRESHOLD_dft 0x004000f0

typedef volatile union {
  struct {
    ca_uint32_t tx_wrff_threshold    :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t tx_rdff_threshold    :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd2               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_XGEPN_TXFPGA_FF_THRESHOLD_t;


#define EPON_XGEPN_XMAC_CTRL_SPARE               0xd00312f4
#define EPON_XGEPN_XMAC_CTRL_SPARE_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t spare                :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_SPARE_t;


#define EPON_XGEPN_XMAC_CTRL_SPARE1              0xd00312f8
#define EPON_XGEPN_XMAC_CTRL_SPARE1_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t spare                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XMAC_CTRL_SPARE1_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* ctrl */
typedef struct {
  EPON_XGEPN_XMAC_CTRL_XGEPN_RX_CTL_t      XGEPN_RX_CTL;                  /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  EPON_XGEPN_XMAC_CTRL_XGEPN_TX_CTL_t      XGEPN_TX_CTL;                  /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  EPON_XGEPN_XMAC_CTRL_XGEPN_TX_FF_THRESHOLD_t XGEPN_TX_FF_THRESHOLD;         /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  EPON_XGEPN_XMAC_CTRL_XGEPN_RX_STATUS0_t  XGEPN_RX_STATUS0;              /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  EPON_XGEPN_XMAC_CTRL_XGEPN_RX_STATUS1_t  XGEPN_RX_STATUS1;              /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  EPON_XGEPN_XMAC_CTRL_XGEPN_TX_STATUS2_t  XGEPN_TX_STATUS2;              /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  EPON_XGEPN_XMAC_CTRL_XGEPN_TX_STATUS3_t  XGEPN_TX_STATUS3;              /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  EPON_XGEPN_XMAC_CTRL_XGEPN_TX_STATUS4_t  XGEPN_TX_STATUS4;              /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  EPON_XGEPN_XMAC_CTRL_XGEPN_FF_STATUS_t   XGEPN_FF_STATUS;               /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  EPON_XGEPN_XMAC_CTRL_XGEPN_INTERRUPT_t   XGEPN_INTERRUPT;               /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  EPON_XGEPN_XMAC_CTRL_XGEPN_INTERRUPTE0_t XGEPN_INTERRUPTE0;             /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  EPON_XGEPN_XMAC_CTRL_XGEPN_INTERRUPTE1_t XGEPN_INTERRUPTE1;             /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  EPON_XGEPN_XMAC_CTRL_RX_BYTE_MIB0_t      RX_BYTE_MIB0;                  /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  EPON_XGEPN_XMAC_CTRL_RX_BYTE_MIB1_t      RX_BYTE_MIB1;                  /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  EPON_XGEPN_XMAC_CTRL_RX_MPCP_MIB0_t      RX_MPCP_MIB0;                  /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  EPON_XGEPN_XMAC_CTRL_RX_MPCP_MIB1_t      RX_MPCP_MIB1;                  /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  EPON_XGEPN_XMAC_CTRL_RX_OAM_MIB0_t       RX_OAM_MIB0;                   /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  EPON_XGEPN_XMAC_CTRL_RX_OAM_MIB1_t       RX_OAM_MIB1;                   /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  EPON_XGEPN_XMAC_CTRL_TX_BYTE_MIB0_t      TX_BYTE_MIB0;                  /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  EPON_XGEPN_XMAC_CTRL_TX_BYTE_MIB1_t      TX_BYTE_MIB1;                  /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  EPON_XGEPN_XMAC_CTRL_TX_MPCP_MIB0_t      TX_MPCP_MIB0;                  /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  EPON_XGEPN_XMAC_CTRL_TX_MPCP_MIB1_t      TX_MPCP_MIB1;                  /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  EPON_XGEPN_XMAC_CTRL_TX_OAM_MIB0_t       TX_OAM_MIB0;                   /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  EPON_XGEPN_XMAC_CTRL_TX_OAM_MIB1_t       TX_OAM_MIB1;                   /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_TM_t   XGEPN_RX_PTP_TM;               /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_TM_S_LO_t XGEPN_RX_PTP_TM_S_LO;          /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_TM_S_HI_t XGEPN_RX_PTP_TM_S_HI;          /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_TYPE_t XGEPN_RX_PTP_TYPE;             /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  EPON_XGEPN_XMAC_CTRL_XGEPN_RX_PTP_SQID_t XGEPN_RX_PTP_SQID;             /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_TM_t   XGEPN_TX_PTP_TM;               /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_TM_S_LO_t XGEPN_TX_PTP_TM_S_LO;          /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_TM_S_HI_t XGEPN_TX_PTP_TM_S_HI;          /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_SQID_t XGEPN_TX_PTP_SQID;             /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  EPON_XGEPN_XMAC_CTRL_XGEPN_TX_PTP_TYPE_t XGEPN_TX_PTP_TYPE;             /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  EPON_XGEPN_XMAC_CTRL_XGEPN_PTP_VLAN0_t   XGEPN_PTP_VLAN0;               /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  EPON_XGEPN_XMAC_CTRL_XGEPN_PTP_VLAN1_t   XGEPN_PTP_VLAN1;               /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  EPON_XGEPN_XMAC_CTRL_XGEPN_RX_DBG_t      XGEPN_RX_DBG;                  /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  EPON_XGEPN_XMAC_CTRL_XGEPN_TX_DBG_t      XGEPN_TX_DBG;                  /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  EPON_XGEPN_XMAC_CTRL_XGEPN_RXFPGA_DROPCNT_t XGEPN_RXFPGA_DROPCNT;          /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];                   
  EPON_XGEPN_XMAC_CTRL_XGEPN_RXFPGA_FF_THRESHOLD_t XGEPN_RXFPGA_FF_THRESHOLD;     /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];                   
  EPON_XGEPN_XMAC_CTRL_XGEPN_TXFPGA_FF_THRESHOLD_t XGEPN_TXFPGA_FF_THRESHOLD;     /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];                   
  EPON_XGEPN_XMAC_CTRL_SPARE_t             SPARE;                         /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];                   
  EPON_XGEPN_XMAC_CTRL_SPARE1_t            SPARE1;                        /* addr: 0x000000a8 */
} APB1_EPON_XGEPN_XMAC_CTRL_t;

    
  
        
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* xmac */

typedef struct {
  APB1_EPON_XGEPN_XMAC_TXMAC_t             txmac;                         /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[151];                  
  APB1_EPON_XGEPN_XMAC_RXMAC_t             rxmac;                         /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd2[399];                  
  APB1_EPON_XGEPN_XMAC_CTRL_t              ctrl;                          /* addr: 0x00000250 */
} APB1_EPON_XGEPN_XMAC_t;


/*
 * XGPCS
 */
  
/*
 * tx
 */
        
#define EPON_XGEPN_XGPCS_TX_TXINT                0xd0031300
#define EPON_XGEPN_XGPCS_TX_TXINT_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t errorpktI            :  1 ; /* bits 0:0 */
    ca_uint32_t errorpktsatI         :  1 ; /* bits 1:1 */
    ca_uint32_t goodpktsatI          :  1 ; /* bits 2:2 */
    ca_uint32_t badburstendI         :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_TXINT_t;


#define EPON_XGEPN_XGPCS_TX_TXINTE0              0xd0031304
#define EPON_XGEPN_XGPCS_TX_TXINTE0_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t errorpktIE           :  1 ; /* bits 0:0 */
    ca_uint32_t errorpktsatIE        :  1 ; /* bits 1:1 */
    ca_uint32_t goodpktsatIE         :  1 ; /* bits 2:2 */
    ca_uint32_t badburstendIE        :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_TXINTE0_t;


#define EPON_XGEPN_XGPCS_TX_TXINTE1              0xd0031308
#define EPON_XGEPN_XGPCS_TX_TXINTE1_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t errorpktIE           :  1 ; /* bits 0:0 */
    ca_uint32_t errorpktsatIE        :  1 ; /* bits 1:1 */
    ca_uint32_t goodpktsatIE         :  1 ; /* bits 2:2 */
    ca_uint32_t badburstendIE        :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_TXINTE1_t;


#define EPON_XGEPN_XGPCS_TX_TXCNTRL              0xd003130c
#define EPON_XGEPN_XGPCS_TX_TXCNTRL_dft          0x02000004

typedef volatile union {
  struct {
    ca_uint32_t txcode_control       :  2 ; /* bits 1:0 */
    ca_uint32_t swap_tx_bus          :  1 ; /* bits 2:2 */
    ca_uint32_t scram_tx_dis         :  1 ; /* bits 3:3 */
    ca_uint32_t prb31_tx_disable_inversion :  1 ; /* bits 4:4 */
    ca_uint32_t tx_loopback          :  1 ; /* bits 5:5 */
    ca_uint32_t tx_estore_resync     :  1 ; /* bits 6:6 */
    ca_uint32_t test_tx_err          :  1 ; /* bits 7:7 */
    ca_uint32_t pcs6_tx_test         :  2 ; /* bits 9:8 */
    ca_uint32_t pseudo_tx_inv        :  1 ; /* bits 10:10 */
    ca_uint32_t square_tx_pat        :  4 ; /* bits 14:11 */
    ca_uint32_t logicReset           :  1 ; /* bits 15:15 */
    ca_uint32_t laserctrldelay       :  5 ; /* bits 20:16 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t laserctrlpolarity    :  1 ; /* bits 24:24 */
    ca_uint32_t close_laser_advance_en :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd2               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_TXCNTRL_t;

#define     square_tx_pat_Low                             0x0
#define     square_tx_pat_Square1                         0x1
#define     square_tx_pat_Square2                         0x2
#define     square_tx_pat_Square4                         0x3
#define     square_tx_pat_Square8                         0x4
#define     square_tx_pat_Square16                        0x5
#define     square_tx_pat_Pulse0                          0x6
#define     square_tx_pat_Pulse1                          0x7
#define     square_tx_pat_High                            0x8
#define     pcs6_tx_test_Normal                           0x0
#define     pcs6_tx_test_PRBS31                           0x1
#define     pcs6_tx_test_Square                           0x2
#define     pcs6_tx_test_Pseudo                           0x3
#define     txcode_control_Normal                         0x0
#define     txcode_control_Invert                         0x1
#define     txcode_control_Force_00                       0x2
#define     txcode_control_Force_11                       0x3

#define EPON_XGEPN_XGPCS_TX_TXSTATUS             0xd0031310
#define EPON_XGEPN_XGPCS_TX_TXSTATUS_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t errorpktsat          :  1 ; /* bits 1:1 */
    ca_uint32_t goodpktsat           :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd2               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_TXSTATUS_t;


#define EPON_XGEPN_XGPCS_TX_GOODPKT              0xd0031314
#define EPON_XGEPN_XGPCS_TX_GOODPKT_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t good_pktM_tx         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_GOODPKT_t;


#define EPON_XGEPN_XGPCS_TX_ERRPKT               0xd0031318
#define EPON_XGEPN_XGPCS_TX_ERRPKT_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t err_pktM_tx          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_ERRPKT_t;


#define EPON_XGEPN_XGPCS_TX_SEED_A1              0xd003131c
#define EPON_XGEPN_XGPCS_TX_SEED_A1_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pseudo_tx_A1         : 26 ; /* bits 25:0 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_SEED_A1_t;


#define EPON_XGEPN_XGPCS_TX_SEED_A0              0xd0031320
#define EPON_XGEPN_XGPCS_TX_SEED_A0_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pseudo_tx_A0         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_SEED_A0_t;


#define EPON_XGEPN_XGPCS_TX_SEED_B1              0xd0031324
#define EPON_XGEPN_XGPCS_TX_SEED_B1_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pseudo_tx_B1         : 26 ; /* bits 25:0 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_SEED_B1_t;


#define EPON_XGEPN_XGPCS_TX_SEED_B0              0xd0031328
#define EPON_XGEPN_XGPCS_TX_SEED_B0_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pseudo_tx_B0         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_SEED_B0_t;


#define EPON_XGEPN_XGPCS_TX_SEED_D1              0xd003132c
#define EPON_XGEPN_XGPCS_TX_SEED_D1_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pseudo_tx_D1         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_SEED_D1_t;


#define EPON_XGEPN_XGPCS_TX_SEED_D0              0xd0031330
#define EPON_XGEPN_XGPCS_TX_SEED_D0_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pseudo_tx_D0         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_SEED_D0_t;


#define EPON_XGEPN_XGPCS_TX_FMRO                 0xd0031334
#define EPON_XGEPN_XGPCS_TX_FMRO_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t fmro_rx_view         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t fmro_view_sel        :  5 ; /* bits 8:4 */
    ca_uint32_t rsrvd2               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_FMRO_t;

#define     fmro_view_sel_PCS6_XGMII_0                    0x0
#define     fmro_view_sel_PCS6_XGMII_1                    0x1
#define     fmro_view_sel_PCS6_XGMII_2                    0x2
#define     fmro_view_sel_PCS6_XGMII_3                    0x3
#define     fmro_view_sel_PCS6_XGMII_4                    0x4
#define     fmro_view_sel_PCS6_XGMII_5                    0x5
#define     fmro_view_sel_PCS6_XGMII_6                    0x6
#define     fmro_view_sel_PCS6_XGMII_7                    0x7
#define     fmro_view_sel_PCS6_CODE_0                     0x8
#define     fmro_view_sel_PCS6_CODE_1                     0x9
#define     fmro_view_sel_PCS6_CODE_2                     0xa
#define     fmro_view_sel_PCS6_CODE_3                     0xb
#define     fmro_view_sel_PCS6_LINE_0                     0xc
#define     fmro_view_sel_PCS6_LINE_1                     0xd
#define     fmro_rx_view_PCS6_Transmit                    0x0
#define     fmro_rx_view_PCS6_Receive                     0x1

#define EPON_XGEPN_XGPCS_TX_PCSERRINS            0xd0031338
#define EPON_XGEPN_XGPCS_TX_PCSERRINS_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t LOCATION             :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t TYPE                 :  4 ; /* bits 11:8 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t SINGLE               :  1 ; /* bits 14:14 */
    ca_uint32_t ENABLE               :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd3               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_PCSERRINS_t;


#define EPON_XGEPN_XGPCS_TX_TXDISFEC             0xd003133c
#define EPON_XGEPN_XGPCS_TX_TXDISFEC_dft         0x0000f03c

typedef volatile union {
  struct {
    ca_uint32_t disableFEC           :  1 ; /* bits 0:0 */
    ca_uint32_t swap_before_fec      :  1 ; /* bits 1:1 */
    ca_uint32_t swap_before_fec_encoder :  1 ; /* bits 2:2 */
    ca_uint32_t swap_after_fec_encoder :  1 ; /* bits 3:3 */
    ca_uint32_t EOBTerminatorLength  :  8 ; /* bits 11:4 */
    ca_uint32_t error_inject_count   :  4 ; /* bits 15:12 */
    ca_uint32_t tx_fec_bypass_delay_mode :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_TXDISFEC_t;


#define EPON_XGEPN_XGPCS_TX_PKTGEN_MEM_ACCESS    0xd0031340
#define EPON_XGEPN_XGPCS_TX_PKTGEN_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t CPUPktEn_OnuSPLen    :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 22 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_PKTGEN_MEM_ACCESS_t;


#define EPON_XGEPN_XGPCS_TX_PKTGEN_MEM_DATA2     0xd0031344
#define EPON_XGEPN_XGPCS_TX_PKTGEN_MEM_DATA2_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t PktData              :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_PKTGEN_MEM_DATA2_t;


#define EPON_XGEPN_XGPCS_TX_PKTGEN_MEM_DATA1     0xd0031348
#define EPON_XGEPN_XGPCS_TX_PKTGEN_MEM_DATA1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t PktData              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_PKTGEN_MEM_DATA1_t;


#define EPON_XGEPN_XGPCS_TX_PKTGEN_MEM_DATA0     0xd003134c
#define EPON_XGEPN_XGPCS_TX_PKTGEN_MEM_DATA0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t PktData              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_PKTGEN_MEM_DATA0_t;


#define EPON_XGEPN_XGPCS_TX_StartDeque           0xd0031350
#define EPON_XGEPN_XGPCS_TX_StartDeque_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t init                 :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_StartDeque_t;


#define EPON_XGEPN_XGPCS_TX_CPUPktEn             0xd0031354
#define EPON_XGEPN_XGPCS_TX_CPUPktEn_dft         0x00000052

typedef volatile union {
  struct {
    ca_uint32_t Enable               :  1 ; /* bits 0:0 */
    ca_uint32_t NumLines             :  5 ; /* bits 5:1 */
    ca_uint32_t NumPkts              :  9 ; /* bits 14:6 */
    ca_uint32_t SendForever          :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_CPUPktEn_t;


#define EPON_XGEPN_XGPCS_TX_BERMonitor           0xd0031358
#define EPON_XGEPN_XGPCS_TX_BERMonitor_dft       0x00000019

typedef volatile union {
  struct {
    ca_uint32_t Window               :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_BERMonitor_t;


#define EPON_XGEPN_XGPCS_TX_FEC_MASK_MEM_SW_ACCESS 0xd003135c
#define EPON_XGEPN_XGPCS_TX_FEC_MASK_MEM_SW_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t MASK_MEM_ADDR        :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t w_rdn                :  1 ; /* bits 30:30 */
    ca_uint32_t ACCESS               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_FEC_MASK_MEM_SW_ACCESS_t;


#define EPON_XGEPN_XGPCS_TX_FEC_MASK_MEM_SW_DATA2 0xd0031360
#define EPON_XGEPN_XGPCS_TX_FEC_MASK_MEM_SW_DATA2_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t MASK_MEM_DATA        :  2 ; /* bits 1:0 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_FEC_MASK_MEM_SW_DATA2_t;


#define EPON_XGEPN_XGPCS_TX_FEC_MASK_MEM_SW_DATA1 0xd0031364
#define EPON_XGEPN_XGPCS_TX_FEC_MASK_MEM_SW_DATA1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t MASK_MEM_DATA        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_FEC_MASK_MEM_SW_DATA1_t;


#define EPON_XGEPN_XGPCS_TX_FEC_MASK_MEM_SW_DATA0 0xd0031368
#define EPON_XGEPN_XGPCS_TX_FEC_MASK_MEM_SW_DATA0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t MASK_MEM_DATA        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_FEC_MASK_MEM_SW_DATA0_t;


#define EPON_XGEPN_XGPCS_TX_FEC_ERROR_INJECT     0xd003136c
#define EPON_XGEPN_XGPCS_TX_FEC_ERROR_INJECT_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t enable               :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_TX_FEC_ERROR_INJECT_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* tx */
typedef struct {
  EPON_XGEPN_XGPCS_TX_TXINT_t              TXINT;                         /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  EPON_XGEPN_XGPCS_TX_TXINTE0_t            TXINTE0;                       /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  EPON_XGEPN_XGPCS_TX_TXINTE1_t            TXINTE1;                       /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  EPON_XGEPN_XGPCS_TX_TXCNTRL_t            TXCNTRL;                       /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  EPON_XGEPN_XGPCS_TX_TXSTATUS_t           TXSTATUS;                      /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  EPON_XGEPN_XGPCS_TX_GOODPKT_t            GOODPKT;                       /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  EPON_XGEPN_XGPCS_TX_ERRPKT_t             ERRPKT;                        /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  EPON_XGEPN_XGPCS_TX_SEED_A1_t            SEED_A1;                       /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  EPON_XGEPN_XGPCS_TX_SEED_A0_t            SEED_A0;                       /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  EPON_XGEPN_XGPCS_TX_SEED_B1_t            SEED_B1;                       /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  EPON_XGEPN_XGPCS_TX_SEED_B0_t            SEED_B0;                       /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  EPON_XGEPN_XGPCS_TX_SEED_D1_t            SEED_D1;                       /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  EPON_XGEPN_XGPCS_TX_SEED_D0_t            SEED_D0;                       /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  EPON_XGEPN_XGPCS_TX_FMRO_t               FMRO;                          /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  EPON_XGEPN_XGPCS_TX_PCSERRINS_t          PCSERRINS;                     /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  EPON_XGEPN_XGPCS_TX_TXDISFEC_t           TXDISFEC;                      /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  EPON_XGEPN_XGPCS_TX_PKTGEN_MEM_ACCESS_t  PKTGEN_MEM_ACCESS;             /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  EPON_XGEPN_XGPCS_TX_PKTGEN_MEM_DATA2_t   PKTGEN_MEM_DATA2;              /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  EPON_XGEPN_XGPCS_TX_PKTGEN_MEM_DATA1_t   PKTGEN_MEM_DATA1;              /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  EPON_XGEPN_XGPCS_TX_PKTGEN_MEM_DATA0_t   PKTGEN_MEM_DATA0;              /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  EPON_XGEPN_XGPCS_TX_StartDeque_t         StartDeque;                    /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  EPON_XGEPN_XGPCS_TX_CPUPktEn_t           CPUPktEn;                      /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  EPON_XGEPN_XGPCS_TX_BERMonitor_t         BERMonitor;                    /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  EPON_XGEPN_XGPCS_TX_FEC_MASK_MEM_SW_ACCESS_t FEC_MASK_MEM_SW_ACCESS;        /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  EPON_XGEPN_XGPCS_TX_FEC_MASK_MEM_SW_DATA2_t FEC_MASK_MEM_SW_DATA2;         /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  EPON_XGEPN_XGPCS_TX_FEC_MASK_MEM_SW_DATA1_t FEC_MASK_MEM_SW_DATA1;         /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  EPON_XGEPN_XGPCS_TX_FEC_MASK_MEM_SW_DATA0_t FEC_MASK_MEM_SW_DATA0;         /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  EPON_XGEPN_XGPCS_TX_FEC_ERROR_INJECT_t   FEC_ERROR_INJECT;              /* addr: 0x0000006c */
} APB1_EPON_XGEPN_XGPCS_TX_t;


/*
 * rx
 */
        
#define EPON_XGEPN_XGPCS_RX_RXINT                0xd0031370
#define EPON_XGEPN_XGPCS_RX_RXINT_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t errorpktI            :  1 ; /* bits 0:0 */
    ca_uint32_t errorpktsatI         :  1 ; /* bits 1:1 */
    ca_uint32_t goodpktsatI          :  1 ; /* bits 2:2 */
    ca_uint32_t errordecI            :  1 ; /* bits 3:3 */
    ca_uint32_t errordecsatI         :  1 ; /* bits 4:4 */
    ca_uint32_t errorpatI            :  1 ; /* bits 5:5 */
    ca_uint32_t errorpatsatI         :  1 ; /* bits 6:6 */
    ca_uint32_t errorbersatI         :  1 ; /* bits 7:7 */
    ca_uint32_t syncdetI             :  1 ; /* bits 8:8 */
    ca_uint32_t berhighI             :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t patsyncI             :  1 ; /* bits 11:11 */
    ca_uint32_t fecdeccorrsatI       :  1 ; /* bits 12:12 */
    ca_uint32_t fecdecuncorrsatI     :  1 ; /* bits 13:13 */
    ca_uint32_t fecdecpersistfailI   :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t linkdown             :  1 ; /* bits 17:17 */
    ca_uint32_t linkup               :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd3               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_RXINT_t;


#define EPON_XGEPN_XGPCS_RX_RXINTE0              0xd0031374
#define EPON_XGEPN_XGPCS_RX_RXINTE0_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t errorpktIE           :  1 ; /* bits 0:0 */
    ca_uint32_t errorpktsatIE        :  1 ; /* bits 1:1 */
    ca_uint32_t goodpktsatIE         :  1 ; /* bits 2:2 */
    ca_uint32_t errordecIE           :  1 ; /* bits 3:3 */
    ca_uint32_t errordecsatIE        :  1 ; /* bits 4:4 */
    ca_uint32_t errorpatIE           :  1 ; /* bits 5:5 */
    ca_uint32_t errorpatsatIE        :  1 ; /* bits 6:6 */
    ca_uint32_t errorbersatIE        :  1 ; /* bits 7:7 */
    ca_uint32_t syncdetIE            :  1 ; /* bits 8:8 */
    ca_uint32_t berhighIE            :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t patsyncIE            :  1 ; /* bits 11:11 */
    ca_uint32_t fecdeccorrsatIE      :  1 ; /* bits 12:12 */
    ca_uint32_t fecdecuncorrsatIE    :  1 ; /* bits 13:13 */
    ca_uint32_t fecdecpersistfailIE  :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t linkdownE            :  1 ; /* bits 17:17 */
    ca_uint32_t linkupE              :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd3               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_RXINTE0_t;


#define EPON_XGEPN_XGPCS_RX_RXINTE1              0xd0031378
#define EPON_XGEPN_XGPCS_RX_RXINTE1_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t errorpktIE           :  1 ; /* bits 0:0 */
    ca_uint32_t errorpktsatIE        :  1 ; /* bits 1:1 */
    ca_uint32_t goodpktsatIE         :  1 ; /* bits 2:2 */
    ca_uint32_t errordecIE           :  1 ; /* bits 3:3 */
    ca_uint32_t errordecsatIE        :  1 ; /* bits 4:4 */
    ca_uint32_t errorpatIE           :  1 ; /* bits 5:5 */
    ca_uint32_t errorpatsatIE        :  1 ; /* bits 6:6 */
    ca_uint32_t errorbersatIE        :  1 ; /* bits 7:7 */
    ca_uint32_t syncdetIE            :  1 ; /* bits 8:8 */
    ca_uint32_t berhighIE            :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t patsyncIE            :  1 ; /* bits 11:11 */
    ca_uint32_t fecdeccorrsatIE      :  1 ; /* bits 12:12 */
    ca_uint32_t fecdecuncorrsatIE    :  1 ; /* bits 13:13 */
    ca_uint32_t fecdecpersistfailIE  :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t linkdownE            :  1 ; /* bits 17:17 */
    ca_uint32_t linkupE              :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd3               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_RXINTE1_t;


#define EPON_XGEPN_XGPCS_RX_RXCNTRL              0xd003137c
#define EPON_XGEPN_XGPCS_RX_RXCNTRL_dft          0x00005004

typedef volatile union {
  struct {
    ca_uint32_t rx_loopback          :  1 ; /* bits 0:0 */
    ca_uint32_t rx_estore_resync     :  1 ; /* bits 1:1 */
    ca_uint32_t swap_rx_bus          :  1 ; /* bits 2:2 */
    ca_uint32_t descram_rx_dis       :  1 ; /* bits 3:3 */
    ca_uint32_t prb31_rx_disable_inversion :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t pcs6_rx_test         :  2 ; /* bits 9:8 */
    ca_uint32_t pseudo_rx_inv        :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t latchEach1e          :  1 ; /* bits 12:12 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t dontFilterFsig       :  1 ; /* bits 14:14 */
    ca_uint32_t logicReset           :  1 ; /* bits 15:15 */
    ca_uint32_t rsrvd4               : 15 ;
    ca_uint32_t link_sel             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_RXCNTRL_t;

#define     pcs6_rx_test_Normal                           0x0
#define     pcs6_rx_test_PRBS31                           0x1
#define     pcs6_rx_test_Reserved                         0x2
#define     pcs6_rx_test_Pseudo                           0x3

#define EPON_XGEPN_XGPCS_RX_RXSTATUS             0xd0031380
#define EPON_XGEPN_XGPCS_RX_RXSTATUS_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t errorpktsat          :  1 ; /* bits 1:1 */
    ca_uint32_t goodpktsat           :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t errordecsat          :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t errorpatsat          :  1 ; /* bits 6:6 */
    ca_uint32_t errorbersat          :  1 ; /* bits 7:7 */
    ca_uint32_t syncdetS             :  1 ; /* bits 8:8 */
    ca_uint32_t berhighS             :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd4               :  1 ;
    ca_uint32_t patsyncS             :  1 ; /* bits 11:11 */
    ca_uint32_t fecdeccorrsat        :  1 ; /* bits 12:12 */
    ca_uint32_t fecdecuncorrsat      :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd5               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_RXSTATUS_t;


#define EPON_XGEPN_XGPCS_RX_GOODPKT              0xd0031384
#define EPON_XGEPN_XGPCS_RX_GOODPKT_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t good_pktM_rx         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_GOODPKT_t;


#define EPON_XGEPN_XGPCS_RX_ERRPKT               0xd0031388
#define EPON_XGEPN_XGPCS_RX_ERRPKT_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t err_pktM_rx          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_ERRPKT_t;


#define EPON_XGEPN_XGPCS_RX_ERRPAT               0xd003138c
#define EPON_XGEPN_XGPCS_RX_ERRPAT_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t err_pat_rx           : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_ERRPAT_t;


#define EPON_XGEPN_XGPCS_RX_ERRDEC               0xd0031390
#define EPON_XGEPN_XGPCS_RX_ERRDEC_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t err_dec_rx           : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_ERRDEC_t;


#define EPON_XGEPN_XGPCS_RX_ERRBER               0xd0031394
#define EPON_XGEPN_XGPCS_RX_ERRBER_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t err_ber_rx           : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_ERRBER_t;


#define EPON_XGEPN_XGPCS_RX_FECCORCODE           0xd0031398
#define EPON_XGEPN_XGPCS_RX_FECCORCODE_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t fec_corcodM_rx       : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_FECCORCODE_t;


#define EPON_XGEPN_XGPCS_RX_FECUNCORCODE         0xd003139c
#define EPON_XGEPN_XGPCS_RX_FECUNCORCODE_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t fec_uncorcodM_rx     : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_FECUNCORCODE_t;


#define EPON_XGEPN_XGPCS_RX_SYNOFF               0xd00313a0
#define EPON_XGEPN_XGPCS_RX_SYNOFF_dft           0x00000100

typedef volatile union {
  struct {
    ca_uint32_t sync_valid_off       :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t sync_invalid_off     :  4 ; /* bits 11:8 */
    ca_uint32_t rsrvd2               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_SYNOFF_t;


#define EPON_XGEPN_XGPCS_RX_SEED_A1              0xd00313a4
#define EPON_XGEPN_XGPCS_RX_SEED_A1_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pseudo_rx_A1         : 26 ; /* bits 25:0 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_SEED_A1_t;


#define EPON_XGEPN_XGPCS_RX_SEED_A0              0xd00313a8
#define EPON_XGEPN_XGPCS_RX_SEED_A0_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pseudo_rx_A0         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_SEED_A0_t;


#define EPON_XGEPN_XGPCS_RX_SEED_B1              0xd00313ac
#define EPON_XGEPN_XGPCS_RX_SEED_B1_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pseudo_rx_B1         : 26 ; /* bits 25:0 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_SEED_B1_t;


#define EPON_XGEPN_XGPCS_RX_SEED_B0              0xd00313b0
#define EPON_XGEPN_XGPCS_RX_SEED_B0_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pseudo_rx_B0         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_SEED_B0_t;


#define EPON_XGEPN_XGPCS_RX_SEED_D1              0xd00313b4
#define EPON_XGEPN_XGPCS_RX_SEED_D1_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pseudo_rx_D1         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_SEED_D1_t;


#define EPON_XGEPN_XGPCS_RX_SEED_D0              0xd00313b8
#define EPON_XGEPN_XGPCS_RX_SEED_D0_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pseudo_rx_D0         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_SEED_D0_t;


#define EPON_XGEPN_XGPCS_RX_FECCNTRL             0xd00313bc
#define EPON_XGEPN_XGPCS_RX_FECCNTRL_dft         0x00000023

typedef volatile union {
  struct {
    ca_uint32_t persist_dec_fail_threshold :  3 ; /* bits 2:0 */
    ca_uint32_t disableFECcorrection :  1 ; /* bits 3:3 */
    ca_uint32_t disableFECtotal      :  1 ; /* bits 4:4 */
    ca_uint32_t mark_uncorrectable   :  1 ; /* bits 5:5 */
    ca_uint32_t swap_PCS65_block     :  1 ; /* bits 6:6 */
    ca_uint32_t swap_8bits_data_symbol :  1 ; /* bits 7:7 */
    ca_uint32_t swap_8bits_parity_symbol :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               : 10 ;
    ca_uint32_t rx_fec_bypass_delay_mode :  1 ; /* bits 19:19 */
    ca_uint32_t rsrvd2               : 12 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_FECCNTRL_t;


#define EPON_XGEPN_XGPCS_RX_BER_THRESHOLD        0xd00313c0
#define EPON_XGEPN_XGPCS_RX_BER_THRESHOLD_dft    0x00000640

typedef volatile union {
  struct {
    ca_uint32_t sync_ber_threshold   : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_BER_THRESHOLD_t;


#define EPON_XGEPN_XGPCS_RX_DEBUG_CONFIG_REG     0xd00313c4
#define EPON_XGEPN_XGPCS_RX_DEBUG_CONFIG_REG_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mask_hiber           :  1 ; /* bits 0:0 */
    ca_uint32_t slip_manual_mode     :  1 ; /* bits 1:1 */
    ca_uint32_t rx_fec_bypass        :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_DEBUG_CONFIG_REG_t;


#define EPON_XGEPN_XGPCS_RX_DEBUG_TRIG_REG       0xd00313c8
#define EPON_XGEPN_XGPCS_RX_DEBUG_TRIG_REG_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t trigger_slip         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_DEBUG_TRIG_REG_t;


#define EPON_XGEPN_XGPCS_RX_XGEPN_LINK_DETECT_CFG 0xd00313cc
#define EPON_XGEPN_XGPCS_RX_XGEPN_LINK_DETECT_CFG_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t detect_mode          :  1 ; /* bits 0:0 */
    ca_uint32_t opt_los_polarity     :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  6 ;
    ca_uint32_t detect_period        :  6 ; /* bits 13:8 */
    ca_uint32_t rsrvd2               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_XGEPN_LINK_DETECT_CFG_t;


#define EPON_XGEPN_XGPCS_RX_XGEPN_LINK_STATUS    0xd00313d0
#define EPON_XGEPN_XGPCS_RX_XGEPN_LINK_STATUS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t link_status          :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_XGEPN_LINK_STATUS_t;


#define EPON_XGEPN_XGPCS_RX_FECCORRBYTE          0xd00313d4
#define EPON_XGEPN_XGPCS_RX_FECCORRBYTE_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_FECCORRBYTE_t;


#define EPON_XGEPN_XGPCS_RX_FECTOTALCODE         0xd00313d8
#define EPON_XGEPN_XGPCS_RX_FECTOTALCODE_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_XGPCS_RX_FECTOTALCODE_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* rx */
typedef struct {
  EPON_XGEPN_XGPCS_RX_RXINT_t              RXINT;                         /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  EPON_XGEPN_XGPCS_RX_RXINTE0_t            RXINTE0;                       /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  EPON_XGEPN_XGPCS_RX_RXINTE1_t            RXINTE1;                       /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  EPON_XGEPN_XGPCS_RX_RXCNTRL_t            RXCNTRL;                       /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  EPON_XGEPN_XGPCS_RX_RXSTATUS_t           RXSTATUS;                      /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  EPON_XGEPN_XGPCS_RX_GOODPKT_t            GOODPKT;                       /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  EPON_XGEPN_XGPCS_RX_ERRPKT_t             ERRPKT;                        /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  EPON_XGEPN_XGPCS_RX_ERRPAT_t             ERRPAT;                        /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  EPON_XGEPN_XGPCS_RX_ERRDEC_t             ERRDEC;                        /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  EPON_XGEPN_XGPCS_RX_ERRBER_t             ERRBER;                        /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  EPON_XGEPN_XGPCS_RX_FECCORCODE_t         FECCORCODE;                    /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  EPON_XGEPN_XGPCS_RX_FECUNCORCODE_t       FECUNCORCODE;                  /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  EPON_XGEPN_XGPCS_RX_SYNOFF_t             SYNOFF;                        /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  EPON_XGEPN_XGPCS_RX_SEED_A1_t            SEED_A1;                       /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  EPON_XGEPN_XGPCS_RX_SEED_A0_t            SEED_A0;                       /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  EPON_XGEPN_XGPCS_RX_SEED_B1_t            SEED_B1;                       /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  EPON_XGEPN_XGPCS_RX_SEED_B0_t            SEED_B0;                       /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  EPON_XGEPN_XGPCS_RX_SEED_D1_t            SEED_D1;                       /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  EPON_XGEPN_XGPCS_RX_SEED_D0_t            SEED_D0;                       /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  EPON_XGEPN_XGPCS_RX_FECCNTRL_t           FECCNTRL;                      /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  EPON_XGEPN_XGPCS_RX_BER_THRESHOLD_t      BER_THRESHOLD;                 /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  EPON_XGEPN_XGPCS_RX_DEBUG_CONFIG_REG_t   DEBUG_CONFIG_REG;              /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  EPON_XGEPN_XGPCS_RX_DEBUG_TRIG_REG_t     DEBUG_TRIG_REG;                /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  EPON_XGEPN_XGPCS_RX_XGEPN_LINK_DETECT_CFG_t XGEPN_LINK_DETECT_CFG;         /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  EPON_XGEPN_XGPCS_RX_XGEPN_LINK_STATUS_t  XGEPN_LINK_STATUS;             /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  EPON_XGEPN_XGPCS_RX_FECCORRBYTE_t        FECCORRBYTE;                   /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  EPON_XGEPN_XGPCS_RX_FECTOTALCODE_t       FECTOTALCODE;                  /* addr: 0x00000068 */
} APB1_EPON_XGEPN_XGPCS_RX_t;

    
  
        
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* XGPCS */

typedef struct {
  APB1_EPON_XGEPN_XGPCS_TX_t               tx;                            /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[57];                   
  APB1_EPON_XGEPN_XGPCS_RX_t               rx;                            /* addr: 0x00000070 */
} APB1_EPON_XGEPN_XGPCS_t;


/*
 * CORESEC10_TOP[0..1]
 */
  
/*
 * NANDI
 */
        
#define EPON_XGEPN_CORESEC10_TOP_NANDI_INTERRUPT_0 0xd0031420
#define EPON_XGEPN_CORESEC10_TOP_NANDI_INTERRUPT_0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cpu_cmd_executed     :  1 ; /* bits 0:0 */
    ca_uint32_t pn_thld_reached      :  1 ; /* bits 1:1 */
    ca_uint32_t key_hash_mem_rd_err  :  1 ; /* bits 2:2 */
    ca_uint32_t key_hash_mem_rd_Cerr :  1 ; /* bits 3:3 */
    ca_uint32_t cntl_mem_rd_err      :  1 ; /* bits 4:4 */
    ca_uint32_t cntl_mem_rd_Cerr     :  1 ; /* bits 5:5 */
    ca_uint32_t pn_mem_rd_err        :  1 ; /* bits 6:6 */
    ca_uint32_t pn_mem_rd_Cerr       :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_INTERRUPT_0_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_INTENABLE_0 0xd0031424
#define EPON_XGEPN_CORESEC10_TOP_NANDI_INTENABLE_0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cpu_cmd_executed_E   :  1 ; /* bits 0:0 */
    ca_uint32_t pn_thld_reached_E    :  1 ; /* bits 1:1 */
    ca_uint32_t key_hash_mem_rd_err_E :  1 ; /* bits 2:2 */
    ca_uint32_t key_hash_mem_rd_Cerr_E :  1 ; /* bits 3:3 */
    ca_uint32_t cntl_mem_rd_err_E    :  1 ; /* bits 4:4 */
    ca_uint32_t cntl_mem_rd_Cerr_E   :  1 ; /* bits 5:5 */
    ca_uint32_t pn_mem_rd_err_E      :  1 ; /* bits 6:6 */
    ca_uint32_t pn_mem_rd_Cerr_E     :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_INTENABLE_0_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_INTERRUPT_1 0xd0031428
#define EPON_XGEPN_CORESEC10_TOP_NANDI_INTERRUPT_1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cpu_cmd_executed     :  1 ; /* bits 0:0 */
    ca_uint32_t pn_thld_reached      :  1 ; /* bits 1:1 */
    ca_uint32_t key_hash_mem_rd_err  :  1 ; /* bits 2:2 */
    ca_uint32_t key_hash_mem_rd_Cerr :  1 ; /* bits 3:3 */
    ca_uint32_t cntl_mem_rd_err      :  1 ; /* bits 4:4 */
    ca_uint32_t cntl_mem_rd_Cerr     :  1 ; /* bits 5:5 */
    ca_uint32_t pn_mem_rd_err        :  1 ; /* bits 6:6 */
    ca_uint32_t pn_mem_rd_Cerr       :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_INTERRUPT_1_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_INTENABLE_1 0xd003142c
#define EPON_XGEPN_CORESEC10_TOP_NANDI_INTENABLE_1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cpu_cmd_executed_E   :  1 ; /* bits 0:0 */
    ca_uint32_t pn_thld_reached_E    :  1 ; /* bits 1:1 */
    ca_uint32_t key_hash_mem_rd_err_E :  1 ; /* bits 2:2 */
    ca_uint32_t key_hash_mem_rd_Cerr_E :  1 ; /* bits 3:3 */
    ca_uint32_t cntl_mem_rd_err_E    :  1 ; /* bits 4:4 */
    ca_uint32_t cntl_mem_rd_Cerr_E   :  1 ; /* bits 5:5 */
    ca_uint32_t pn_mem_rd_err_E      :  1 ; /* bits 6:6 */
    ca_uint32_t pn_mem_rd_Cerr_E     :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_INTENABLE_1_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_CONFIG    0xd0031430
#define EPON_XGEPN_CORESEC10_TOP_NANDI_CONFIG_dft 0x00000002

typedef volatile union {
  struct {
    ca_uint32_t sec_tag_mem_cmd      :  1 ; /* bits 0:0 */
    ca_uint32_t sec_tag_icv_send_en  :  1 ; /* bits 1:1 */
    ca_uint32_t sci_llid_disable     :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_CONFIG_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_STATUS    0xd0031434
#define EPON_XGEPN_CORESEC10_TOP_NANDI_STATUS_dft 0x00000001

typedef volatile union {
  struct {
    ca_uint32_t mem_init_done        :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_STATUS_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_COMMAND_CONTROL 0xd0031438
#define EPON_XGEPN_CORESEC10_TOP_NANDI_COMMAND_CONTROL_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t start_write          :  1 ; /* bits 0:0 */
    ca_uint32_t rwn                  :  1 ; /* bits 1:1 */
    ca_uint32_t said                 : 10 ; /* bits 11:2 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_COMMAND_CONTROL_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY0_3 0xd003143c
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY0_3_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key03                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY0_3_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY0_2 0xd0031440
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY0_2_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key02                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY0_2_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY0_1 0xd0031444
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY0_1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key01                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY0_1_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY0_0 0xd0031448
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY0_0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key00                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY0_0_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH0_3 0xd003144c
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH0_3_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hash03               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH0_3_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH0_2 0xd0031450
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH0_2_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hash02               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH0_2_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH0_1 0xd0031454
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH0_1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hash01               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH0_1_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH0_0 0xd0031458
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH0_0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hash00               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH0_0_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY1_3 0xd003145c
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY1_3_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key13                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY1_3_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY1_2 0xd0031460
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY1_2_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key12                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY1_2_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY1_1 0xd0031464
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY1_1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key11                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY1_1_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY1_0 0xd0031468
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY1_0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key10                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY1_0_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH1_3 0xd003146c
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH1_3_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hash13               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH1_3_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH1_2 0xd0031470
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH1_2_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hash12               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH1_2_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH1_1 0xd0031474
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH1_1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hash11               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH1_1_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH1_0 0xd0031478
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH1_0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hash10               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH1_0_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_PacketNumber 0xd003147c
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_PacketNumber_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pn                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_PacketNumber_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_NextPacketNumber 0xd0031480
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_NextPacketNumber_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t npn                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_NextPacketNumber_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_Control 0xd0031484
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_Control_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t control              : 17 ; /* bits 16:0 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_Control_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_DATAFIELD_VALID 0xd0031488
#define EPON_XGEPN_CORESEC10_TOP_NANDI_DATAFIELD_VALID_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key0_vld             :  1 ; /* bits 0:0 */
    ca_uint32_t hash0_vld            :  1 ; /* bits 1:1 */
    ca_uint32_t key1_vld             :  1 ; /* bits 2:2 */
    ca_uint32_t hash1_vld            :  1 ; /* bits 3:3 */
    ca_uint32_t sc_vld               :  1 ; /* bits 4:4 */
    ca_uint32_t pn_vld               :  1 ; /* bits 5:5 */
    ca_uint32_t npn_vld              :  1 ; /* bits 6:6 */
    ca_uint32_t an_vld               :  1 ; /* bits 7:7 */
    ca_uint32_t scb_vld              :  1 ; /* bits 8:8 */
    ca_uint32_t es_vld               :  1 ; /* bits 9:9 */
    ca_uint32_t co_vld               :  1 ; /* bits 10:10 */
    ca_uint32_t rlyen_vld            :  1 ; /* bits 11:11 */
    ca_uint32_t sec_mode_vld         :  1 ; /* bits 12:12 */
    ca_uint32_t v_config_vld         :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_DATAFIELD_VALID_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SCI1      0xd003148c
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SCI1_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t SCI1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SCI1_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_SCI0      0xd0031490
#define EPON_XGEPN_CORESEC10_TOP_NANDI_SCI0_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t SCI0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_SCI0_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_PNTHLD    0xd0031494
#define EPON_XGEPN_CORESEC10_TOP_NANDI_PNTHLD_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t PN_threshold         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_PNTHLD_t;


#define EPON_XGEPN_CORESEC10_TOP_NANDI_REPLAYWINDOW 0xd0031498
#define EPON_XGEPN_CORESEC10_TOP_NANDI_REPLAYWINDOW_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t replay_window        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_NANDI_REPLAYWINDOW_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* NANDI */
typedef struct {
  EPON_XGEPN_CORESEC10_TOP_NANDI_INTERRUPT_0_t INTERRUPT_0;                   /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  EPON_XGEPN_CORESEC10_TOP_NANDI_INTENABLE_0_t INTENABLE_0;                   /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  EPON_XGEPN_CORESEC10_TOP_NANDI_INTERRUPT_1_t INTERRUPT_1;                   /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  EPON_XGEPN_CORESEC10_TOP_NANDI_INTENABLE_1_t INTENABLE_1;                   /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  EPON_XGEPN_CORESEC10_TOP_NANDI_CONFIG_t  CONFIG;                        /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  EPON_XGEPN_CORESEC10_TOP_NANDI_STATUS_t  STATUS;                        /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  EPON_XGEPN_CORESEC10_TOP_NANDI_COMMAND_CONTROL_t COMMAND_CONTROL;               /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY0_3_t SADB_KEY0_3;                   /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY0_2_t SADB_KEY0_2;                   /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY0_1_t SADB_KEY0_1;                   /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY0_0_t SADB_KEY0_0;                   /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH0_3_t SADB_HASH0_3;                  /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH0_2_t SADB_HASH0_2;                  /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH0_1_t SADB_HASH0_1;                  /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH0_0_t SADB_HASH0_0;                  /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY1_3_t SADB_KEY1_3;                   /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY1_2_t SADB_KEY1_2;                   /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY1_1_t SADB_KEY1_1;                   /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_KEY1_0_t SADB_KEY1_0;                   /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH1_3_t SADB_HASH1_3;                  /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH1_2_t SADB_HASH1_2;                  /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH1_1_t SADB_HASH1_1;                  /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_HASH1_0_t SADB_HASH1_0;                  /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_PacketNumber_t SADB_PacketNumber;             /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_NextPacketNumber_t SADB_NextPacketNumber;         /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_SADB_Control_t SADB_Control;                  /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_DATAFIELD_VALID_t DATAFIELD_VALID;               /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_SCI1_t    SCI1;                          /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_SCI0_t    SCI0;                          /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_PNTHLD_t  PNTHLD;                        /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  EPON_XGEPN_CORESEC10_TOP_NANDI_REPLAYWINDOW_t REPLAYWINDOW;                  /* addr: 0x00000078 */
} APB1_EPON_XGEPN_CORESEC10_TOP_NANDI_t;


/*
 * CORESEC10
 */
        
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_INTERRUPT_0 0xd00314c0
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_INTERRUPT_0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t macsec_dec_err       :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_INTERRUPT_0_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_INTERRUPT_ENABLE_0 0xd00314c4
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_INTERRUPT_ENABLE_0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t macsec_dec_err_en    :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_INTERRUPT_ENABLE_0_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_INTERRUPT_1 0xd00314c8
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_INTERRUPT_1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t macsec_dec_err       :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_INTERRUPT_1_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_INTERRUPT_ENABLE_1 0xd00314cc
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_INTERRUPT_ENABLE_1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t macsec_dec_err_en    :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_INTERRUPT_ENABLE_1_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_CORESEC10_GLOBAL_CONFIG 0xd00314d0
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_CORESEC10_GLOBAL_CONFIG_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t disable_crc8_chk     :  1 ; /* bits 0:0 */
    ca_uint32_t key_exhange_mode     :  1 ; /* bits 1:1 */
    ca_uint32_t dis_drop_macsec_err_ptk :  1 ; /* bits 2:2 */
    ca_uint32_t dis_preamble_chk     :  1 ; /* bits 3:3 */
    ca_uint32_t dis_crc32_chk        :  1 ; /* bits 4:4 */
    ca_uint32_t cfg_dont_modify_crc32 :  1 ; /* bits 5:5 */
    ca_uint32_t cfg_mask_dec_err     :  1 ; /* bits 6:6 */
    ca_uint32_t soft_reset           :  1 ; /* bits 7:7 */
    ca_uint32_t en_co_error          :  1 ; /* bits 8:8 */
    ca_uint32_t drop_untag_pkt_mode  :  2 ; /* bits 10:9 */
    ca_uint32_t debug_bus_sel        :  3 ; /* bits 13:11 */
    ca_uint32_t dis_ver0_macsec_err  :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd1               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_CORESEC10_GLOBAL_CONFIG_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_CORESEC10_MPCP_TIMER_ADJUST 0xd00314d4
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_CORESEC10_MPCP_TIMER_ADJUST_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mpcp_timer_comp_mac_coresec_10 :  5 ; /* bits 4:0 */
    ca_uint32_t mpcp_timer_comp_coresec_10 :  2 ; /* bits 6:5 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_CORESEC10_MPCP_TIMER_ADJUST_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_SA_0  0xd00314d8
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_SA_0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t local_sa_reg0        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_SA_0_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_SA_1  0xd00314dc
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_SA_1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t local_sa_reg1        : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 15 ;
    ca_uint32_t sel_local_sa_reg     :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_SA_1_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_NOT_DROP_ETHERTYPE 0xd00314e0
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_NOT_DROP_ETHERTYPE_dft 0x00030000

typedef volatile union {
  struct {
    ca_uint32_t user_defined         : 16 ; /* bits 15:0 */
    ca_uint32_t no_drop_oam          :  1 ; /* bits 16:16 */
    ca_uint32_t no_drop_mpcp         :  1 ; /* bits 17:17 */
    ca_uint32_t no_drop_802_1x       :  1 ; /* bits 18:18 */
    ca_uint32_t no_drop_user_def     :  1 ; /* bits 19:19 */
    ca_uint32_t no_drop_user_def10   :  1 ; /* bits 20:20 */
    ca_uint32_t no_drop_user_def11   :  1 ; /* bits 21:21 */
    ca_uint32_t no_drop_user_def20   :  1 ; /* bits 22:22 */
    ca_uint32_t no_drop_user_def21   :  1 ; /* bits 23:23 */
    ca_uint32_t no_drop_8902         :  1 ; /* bits 24:24 */
    ca_uint32_t rsrvd1               :  7 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_NOT_DROP_ETHERTYPE_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_NOT_DROP_ETHERTYPE_1 0xd00314e4
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_NOT_DROP_ETHERTYPE_1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t user_defined10       : 16 ; /* bits 15:0 */
    ca_uint32_t user_defined11       : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_NOT_DROP_ETHERTYPE_1_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_NOT_DROP_ETHERTYPE_2 0xd00314e8
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_NOT_DROP_ETHERTYPE_2_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t user_defined20       : 16 ; /* bits 15:0 */
    ca_uint32_t user_defined21       : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_NOT_DROP_ETHERTYPE_2_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_LLID_PROG_MEM_ACCESS 0xd00314ec
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_LLID_PROG_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mem_loc              :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_LLID_PROG_MEM_ACCESS_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_LLID_PROG_MEM_DATA 0xd00314f0
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_LLID_PROG_MEM_DATA_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t LLID_value           : 16 ; /* bits 15:0 */
    ca_uint32_t valid                :  1 ; /* bits 16:16 */
    ca_uint32_t SA_ID                :  6 ; /* bits 22:17 */
    ca_uint32_t rsrvd1               :  9 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_LLID_PROG_MEM_DATA_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_ACCESS 0xd00314f4
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_ACCESS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mem_loc              :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 21 ;
    ca_uint32_t rbw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_ACCESS_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA10 0xd00314f8
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA10_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t InPktsUnusedSA       : 22 ; /* bits 21:0 */
    ca_uint32_t rsrvd1               : 10 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA10_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA9 0xd00314fc
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA9_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t InPktsNotUsingSA     : 22 ; /* bits 21:0 */
    ca_uint32_t InPktsUnusedSA       : 10 ; /* bits 31:22 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA9_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA8 0xd0031500
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA8_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t InPktsNotValid       : 22 ; /* bits 21:0 */
    ca_uint32_t InPktsNotUsingSA     : 10 ; /* bits 31:22 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA8_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA7 0xd0031504
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA7_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t InPktsInvalid        : 22 ; /* bits 21:0 */
    ca_uint32_t InPktsNotValid       : 10 ; /* bits 31:22 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA7_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA6 0xd0031508
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA6_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t InPktsOK             : 22 ; /* bits 21:0 */
    ca_uint32_t InPktsInvalid        : 10 ; /* bits 31:22 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA6_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA5 0xd003150c
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA5_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t InPktsLate           : 22 ; /* bits 21:0 */
    ca_uint32_t InPktsOK             : 10 ; /* bits 31:22 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA5_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA4 0xd0031510
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA4_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t InOctetsDecrypted_OutOctetsEncrypted : 22 ; /* bits 21:0 */
    ca_uint32_t InPktsLate           : 10 ; /* bits 31:22 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA4_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA3 0xd0031514
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA3_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t InOctetsValidated_OutOctetsProtected : 11 ; /* bits 10:0 */
    ca_uint32_t InOctetsDecrypted_OutOctetsEncrypted : 21 ; /* bits 31:11 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA3_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA2 0xd0031518
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA2_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t InOctetsValidated_OutOctetsProtected : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA2_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA1 0xd003151c
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t InPktsDelayed_OutPktsEncrypted : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA1_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA0 0xd0031520
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t InPktsUnchecked_OutPktsProtected : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA0_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_MACSEC_MIB_OutPktsUnTagged 0xd0031524
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_MACSEC_MIB_OutPktsUnTagged_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_macsec_mib_OutPktsUnTagged_inc : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_MACSEC_MIB_OutPktsUnTagged_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_MACSEC_MIB_OutPktsTooLong 0xd0031528
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_MACSEC_MIB_OutPktsTooLong_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_macsec_mib_OutPktsTooLong_inc : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_MACSEC_MIB_OutPktsTooLong_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsUnTagged 0xd003152c
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsUnTagged_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_macsec_mib_InPktsUnTagged_inc : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsUnTagged_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsNoTag 0xd0031530
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsNoTag_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_macsec_mib_InPktsNoTag_inc : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsNoTag_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsBadTag 0xd0031534
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsBadTag_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_macsec_mib_InPktsBadTag_inc : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsBadTag_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsUnKnownSCI 0xd0031538
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsUnKnownSCI_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_macsec_mib_InPktsUnKnownSCI_inc : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsUnKnownSCI_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsNoSCI 0xd003153c
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsNoSCI_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_macsec_mib_InPktsNoSCI_inc : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsNoSCI_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsOverrun 0xd0031540
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsOverrun_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_macsec_mib_InPktsOverrun_inc : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsOverrun_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_DEC_INVALID_CO_ERR_CNT 0xd0031544
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_DEC_INVALID_CO_ERR_CNT_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_macsec_dec_invalid_co_err_cnt_inc : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_DEC_INVALID_CO_ERR_CNT_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_DEC_VER_NUM_ERR_CNT 0xd0031548
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_DEC_VER_NUM_ERR_CNT_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_macsec_dec_ver_num_err_cnt_inc : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_DEC_VER_NUM_ERR_CNT_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_DEC_SL_MSB_ERR_CNT 0xd003154c
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_DEC_SL_MSB_ERR_CNT_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_macsec_dec_sl_msb_err_cnt_inc : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_DEC_SL_MSB_ERR_CNT_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_DEC_AUTH_FAIL_ERR_CNT 0xd0031550
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_DEC_AUTH_FAIL_ERR_CNT_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_macsec_dec_auth_fail_err_cnt_inc : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_DEC_AUTH_FAIL_ERR_CNT_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_STATUS 0xd0031554
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_STATUS_dft 0x00000001

typedef volatile union {
  struct {
    ca_uint32_t stat_mem_init_done   :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_STATUS_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_PKTS_UN_REG_LLID_CNT 0xd0031558
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_PKTS_UN_REG_LLID_CNT_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_pkts_un_known_llid : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_PKTS_UN_REG_LLID_CNT_t;


#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_RUNT_PKTS_CNT 0xd003155c
#define EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_RUNT_PKTS_CNT_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_runt_pkts         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_RUNT_PKTS_CNT_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* CORESEC10 */
typedef struct {
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_INTERRUPT_0_t INTERRUPT_0;                   /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_INTERRUPT_ENABLE_0_t INTERRUPT_ENABLE_0;            /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_INTERRUPT_1_t INTERRUPT_1;                   /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_INTERRUPT_ENABLE_1_t INTERRUPT_ENABLE_1;            /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_CORESEC10_GLOBAL_CONFIG_t CORESEC10_GLOBAL_CONFIG;       /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_CORESEC10_MPCP_TIMER_ADJUST_t CORESEC10_MPCP_TIMER_ADJUST;   /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_SA_0_t SA_0;                          /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_SA_1_t SA_1;                          /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_NOT_DROP_ETHERTYPE_t NOT_DROP_ETHERTYPE;            /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_NOT_DROP_ETHERTYPE_1_t NOT_DROP_ETHERTYPE_1;          /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_NOT_DROP_ETHERTYPE_2_t NOT_DROP_ETHERTYPE_2;          /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_LLID_PROG_MEM_ACCESS_t LLID_PROG_MEM_ACCESS;          /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_LLID_PROG_MEM_DATA_t LLID_PROG_MEM_DATA;            /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_ACCESS_t TX_RX_MIB_MEM_ACCESS;          /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA10_t TX_RX_MIB_MEM_DATA10;          /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA9_t TX_RX_MIB_MEM_DATA9;           /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA8_t TX_RX_MIB_MEM_DATA8;           /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA7_t TX_RX_MIB_MEM_DATA7;           /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA6_t TX_RX_MIB_MEM_DATA6;           /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA5_t TX_RX_MIB_MEM_DATA5;           /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA4_t TX_RX_MIB_MEM_DATA4;           /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA3_t TX_RX_MIB_MEM_DATA3;           /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA2_t TX_RX_MIB_MEM_DATA2;           /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA1_t TX_RX_MIB_MEM_DATA1;           /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_RX_MIB_MEM_DATA0_t TX_RX_MIB_MEM_DATA0;           /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_MACSEC_MIB_OutPktsUnTagged_t TX_MACSEC_MIB_OutPktsUnTagged; /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_TX_MACSEC_MIB_OutPktsTooLong_t TX_MACSEC_MIB_OutPktsTooLong;  /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsUnTagged_t RX_MACSEC_MIB_InPktsUnTagged;  /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsNoTag_t RX_MACSEC_MIB_InPktsNoTag;     /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsBadTag_t RX_MACSEC_MIB_InPktsBadTag;    /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsUnKnownSCI_t RX_MACSEC_MIB_InPktsUnKnownSCI; /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsNoSCI_t RX_MACSEC_MIB_InPktsNoSCI;     /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_MIB_InPktsOverrun_t RX_MACSEC_MIB_InPktsOverrun;   /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_DEC_INVALID_CO_ERR_CNT_t RX_MACSEC_DEC_INVALID_CO_ERR_CNT; /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_DEC_VER_NUM_ERR_CNT_t RX_MACSEC_DEC_VER_NUM_ERR_CNT; /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_DEC_SL_MSB_ERR_CNT_t RX_MACSEC_DEC_SL_MSB_ERR_CNT;  /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_MACSEC_DEC_AUTH_FAIL_ERR_CNT_t RX_MACSEC_DEC_AUTH_FAIL_ERR_CNT; /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_STATUS_t STATUS;                        /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_PKTS_UN_REG_LLID_CNT_t RX_PKTS_UN_REG_LLID_CNT;       /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];                   
  EPON_XGEPN_CORESEC10_TOP_CORESEC10_RX_RUNT_PKTS_CNT_t RX_RUNT_PKTS_CNT;              /* addr: 0x0000009c */
} APB1_EPON_XGEPN_CORESEC10_TOP_CORESEC10_t;

    
#define APB1_EPON_XGEPN_CORESEC10_TOP_STRIDE     320
#define APB1_EPON_XGEPN_CORESEC10_TOP_COUNT      2
  
        
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* CORESEC10_TOP */

typedef struct {
  APB1_EPON_XGEPN_CORESEC10_TOP_NANDI_t    NANDI;                         /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[99];                   
  APB1_EPON_XGEPN_CORESEC10_TOP_CORESEC10_t CORESEC10;                     /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd2[81];                   
} APB1_EPON_XGEPN_CORESEC10_TOP_t;

    
  
        
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* XGEPN */

typedef struct {
  APB1_EPON_XGEPN_XMAC_t                   xmac;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[91];                   
  APB1_EPON_XGEPN_XGPCS_t                  XGPCS;                         /* addr: 0x00000300 */
  ca_uint32_t                              rsrvd2[123];                  
  APB1_EPON_XGEPN_CORESEC10_TOP_t          CORESEC10_TOP[2];              /* addr: 0x00000420 */
} APB1_EPON_XGEPN_t;


/*
 * xgonu_mpcp
 */
        
#define EPON_XGONU_MPCP_MPCP_IRQ_SRC_INTERRUPT   0xd0032000
#define EPON_XGONU_MPCP_MPCP_IRQ_SRC_INTERRUPT_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t reg_status_changei   :  1 ; /* bits 0:0 */
    ca_uint32_t rx_register_framei   :  1 ; /* bits 1:1 */
    ca_uint32_t gate_timer_expiri    :  1 ; /* bits 2:2 */
    ca_uint32_t mpcp_timer_expiri    :  1 ; /* bits 3:3 */
    ca_uint32_t report_timer_expiri  :  1 ; /* bits 4:4 */
    ca_uint32_t reg_req_retryi       :  1 ; /* bits 5:5 */
    ca_uint32_t ts_drifti            :  1 ; /* bits 6:6 */
    ca_uint32_t grant_fifo_exceedi   :  1 ; /* bits 7:7 */
    ca_uint32_t grant_fifo_accerri   :  1 ; /* bits 8:8 */
    ca_uint32_t grant_drop_tfi       :  1 ; /* bits 9:9 */
    ca_uint32_t grant_drop_tsi       :  1 ; /* bits 10:10 */
    ca_uint32_t grant_drop_tmi       :  1 ; /* bits 11:11 */
    ca_uint32_t grant_drop_disi      :  1 ; /* bits 12:12 */
    ca_uint32_t rx_extend_framei     :  1 ; /* bits 13:13 */
    ca_uint32_t dis_pend_tmr_expiri  :  1 ; /* bits 14:14 */
    ca_uint32_t no_endrpt_reqi       :  1 ; /* bits 15:15 */
    ca_uint32_t grant_drop_tli       :  1 ; /* bits 16:16 */
    ca_uint32_t llid_tbl_remove_emptyi :  1 ; /* bits 17:17 */
    ca_uint32_t llid_tbl_fulli       :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_IRQ_SRC_INTERRUPT_t;


#define EPON_XGONU_MPCP_MPCP_IRQ_SRC_INTERRUPTE  0xd0032004
#define EPON_XGONU_MPCP_MPCP_IRQ_SRC_INTERRUPTE_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t reg_status_changeiE  :  1 ; /* bits 0:0 */
    ca_uint32_t rx_register_frameiE  :  1 ; /* bits 1:1 */
    ca_uint32_t gate_timer_expiriE   :  1 ; /* bits 2:2 */
    ca_uint32_t mpcp_timer_expiriE   :  1 ; /* bits 3:3 */
    ca_uint32_t report_timer_expiriE :  1 ; /* bits 4:4 */
    ca_uint32_t reg_req_retryiE      :  1 ; /* bits 5:5 */
    ca_uint32_t ts_driftiE           :  1 ; /* bits 6:6 */
    ca_uint32_t grant_fifo_exceediE  :  1 ; /* bits 7:7 */
    ca_uint32_t grant_fifo_accerriE  :  1 ; /* bits 8:8 */
    ca_uint32_t grant_drop_tfiE      :  1 ; /* bits 9:9 */
    ca_uint32_t grant_drop_tsiE      :  1 ; /* bits 10:10 */
    ca_uint32_t grant_drop_tmiE      :  1 ; /* bits 11:11 */
    ca_uint32_t grant_drop_disiE     :  1 ; /* bits 12:12 */
    ca_uint32_t rx_extend_frameiE    :  1 ; /* bits 13:13 */
    ca_uint32_t dis_pend_tmr_expiriE :  1 ; /* bits 14:14 */
    ca_uint32_t no_endrpt_reqiE      :  1 ; /* bits 15:15 */
    ca_uint32_t grant_drop_tliE      :  1 ; /* bits 16:16 */
    ca_uint32_t llid_tbl_remove_emptyiE :  1 ; /* bits 17:17 */
    ca_uint32_t llid_tbl_fulliE      :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_IRQ_SRC_INTERRUPTE_t;


#define EPON_XGONU_MPCP_MPCP_INIT_CFG            0xd0032008
#define EPON_XGONU_MPCP_MPCP_INIT_CFG_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mac_index            :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t sw_index             :  6 ; /* bits 13:8 */
    ca_uint32_t rsrvd2               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_INIT_CFG_t;


#define EPON_XGONU_MPCP_MPCP_START_CFG           0xd003200c
#define EPON_XGONU_MPCP_MPCP_START_CFG_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mpcp_start           :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_START_CFG_t;


#define EPON_XGONU_MPCP_MPCP_REGISTER_FRAME_STS  0xd0032010
#define EPON_XGONU_MPCP_MPCP_REGISTER_FRAME_STS_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t assigned_llid        : 16 ; /* bits 15:0 */
    ca_uint32_t flag                 :  4 ; /* bits 19:16 */
    ca_uint32_t mac_index            :  5 ; /* bits 24:20 */
    ca_uint32_t vld                  :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd1               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_REGISTER_FRAME_STS_t;


#define EPON_XGONU_MPCP_MAC_REG_STATUS           0xd0032014
#define EPON_XGONU_MPCP_MAC_REG_STATUS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sts                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MAC_REG_STATUS_t;


#define EPON_XGONU_MPCP_MAC_MPCP_STS1            0xd0032018
#define EPON_XGONU_MPCP_MAC_MPCP_STS1_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t stat1                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MAC_MPCP_STS1_t;


#define EPON_XGONU_MPCP_MAC_MPCP_STS0            0xd003201c
#define EPON_XGONU_MPCP_MAC_MPCP_STS0_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t stat0                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MAC_MPCP_STS0_t;


#define EPON_XGONU_MPCP_MPCP_CFG0                0xd0032020
#define EPON_XGONU_MPCP_MPCP_CFG0_dft            0x00010082

typedef volatile union {
  struct {
    ca_uint32_t max_pending_grant    :  4 ; /* bits 3:0 */
    ca_uint32_t dis_min_grant_check  :  1 ; /* bits 4:4 */
    ca_uint32_t req_frame_llid_sel   :  1 ; /* bits 5:5 */
    ca_uint32_t bak_grt_en           :  1 ; /* bits 6:6 */
    ca_uint32_t flush_grtff_en       :  1 ; /* bits 7:7 */
    ca_uint32_t report_mode_sel      :  3 ; /* bits 10:8 */
    ca_uint32_t t4_report_en         :  1 ; /* bits 11:11 */
    ca_uint32_t overlap_grt_ok       :  1 ; /* bits 12:12 */
    ca_uint32_t ts_drift_threshold   :  6 ; /* bits 18:13 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t sieponB_mode         :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t ignore_olt_disc_info :  1 ; /* bits 25:25 */
    ca_uint32_t rsrvd3               :  1 ;
    ca_uint32_t pre_grt_vld_mode     :  1 ; /* bits 27:27 */
    ca_uint32_t mllid_rereg_wait     :  1 ; /* bits 28:28 */
    ca_uint32_t mllid_mode           :  1 ; /* bits 29:29 */
    ca_uint32_t debug_mode           :  1 ; /* bits 30:30 */
    ca_uint32_t rsrvd4               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_CFG0_t;


#define EPON_XGONU_MPCP_MPCP_CFG                 0xd0032024
#define EPON_XGONU_MPCP_MPCP_CFG_dft             0x01270020

typedef volatile union {
  struct {
    ca_uint32_t mpcp_registration_init :  1 ; /* bits 0:0 */
    ca_uint32_t allow_direct_reg     :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t ctc_onu_silence_en   :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t en_period_report     :  1 ; /* bits 5:5 */
    ca_uint32_t en_end_rpt           :  1 ; /* bits 6:6 */
    ca_uint32_t dis_granting         :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd3               :  8 ;
    ca_uint32_t mpcp_timer_expir_dereg :  1 ; /* bits 16:16 */
    ca_uint32_t gate_timer_expir_dereg :  1 ; /* bits 17:17 */
    ca_uint32_t en_ts_drift_dereg    :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd4               :  1 ;
    ca_uint32_t ctl_txarb_timer      :  8 ; /* bits 27:20 */
    ca_uint32_t rsrvd5               :  2 ;
    ca_uint32_t clr_permit           :  1 ; /* bits 30:30 */
    ca_uint32_t llid_en              :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_CFG_t;


#define EPON_XGONU_MPCP_MPCP_CFG_1G              0xd0032028
#define EPON_XGONU_MPCP_MPCP_CFG_1G_dft          0x00000f2a

typedef volatile union {
  struct {
    ca_uint32_t min_pkt_size_1g      :  8 ; /* bits 7:0 */
    ca_uint32_t fec_overhead_1g      :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_CFG_1G_t;


#define EPON_XGONU_MPCP_MPCP_CFG_10G             0xd003202c
#define EPON_XGONU_MPCP_MPCP_CFG_10G_dft         0x10000e06

typedef volatile union {
  struct {
    ca_uint32_t min_grant_len_10g_nofec :  8 ; /* bits 7:0 */
    ca_uint32_t min_grant_len_10g    :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t burst_end_xgpcs_dly  :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_CFG_10G_t;


#define EPON_XGONU_MPCP_GRANT_VLD_AHEAD_TIMER    0xd0032030
#define EPON_XGONU_MPCP_GRANT_VLD_AHEAD_TIMER_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_GRANT_VLD_AHEAD_TIMER_t;


#define EPON_XGONU_MPCP_ES_STOP_WIN_CFG          0xd0032034
#define EPON_XGONU_MPCP_ES_STOP_WIN_CFG_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ahead_timer          :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 30 ;
    ca_uint32_t wait                 :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_ES_STOP_WIN_CFG_t;


#define EPON_XGONU_MPCP_MPCP_GRANT_TIMER         0xd0032038
#define EPON_XGONU_MPCP_MPCP_GRANT_TIMER_dft     0x040003ff

typedef volatile union {
  struct {
    ca_uint32_t max_future_grant_time : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               :  6 ;
    ca_uint32_t min_processing_time  : 12 ; /* bits 27:16 */
    ca_uint32_t rsrvd2               :  4 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_GRANT_TIMER_t;


#define EPON_XGONU_MPCP_MPCP_LASER_TIME_CFG      0xd003203c
#define EPON_XGONU_MPCP_MPCP_LASER_TIME_CFG_dft  0x00200020

typedef volatile union {
  struct {
    ca_uint32_t laserOnTime_cfg      :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t laserOffTime_cfg     :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd2               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_LASER_TIME_CFG_t;


#define EPON_XGONU_MPCP_MPCP_STIME_ADJ           0xd0032040
#define EPON_XGONU_MPCP_MPCP_STIME_ADJ_dft       0x00000002

typedef volatile union {
  struct {
    ca_uint32_t process_delay        :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_STIME_ADJ_t;


#define EPON_XGONU_MPCP_MPCP_CTC_REG_TIME        0xd0032044
#define EPON_XGONU_MPCP_MPCP_CTC_REG_TIME_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t silence              :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_CTC_REG_TIME_t;


#define EPON_XGONU_MPCP_MPCP_RPT_TIME_THRED      0xd0032048
#define EPON_XGONU_MPCP_MPCP_RPT_TIME_THRED_dft  0x000001a0

typedef volatile union {
  struct {
    ca_uint32_t val                  : 12 ; /* bits 11:0 */
    ca_uint32_t rsrvd1               : 20 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_RPT_TIME_THRED_t;


#define EPON_XGONU_MPCP_MPCP_TIMER_EXP_THRED     0xd003204c
#define EPON_XGONU_MPCP_MPCP_TIMER_EXP_THRED_dft 0x01f42710

typedef volatile union {
  struct {
    ca_uint32_t mpcp                 : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t gate                 : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd2               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_TIMER_EXP_THRED_t;


#define EPON_XGONU_MPCP_MPCP_DIS_PEND_TIME_THRED 0xd0032050
#define EPON_XGONU_MPCP_MPCP_DIS_PEND_TIME_THRED_dft 0x80000fff

typedef volatile union {
  struct {
    ca_uint32_t val                  : 20 ; /* bits 19:0 */
    ca_uint32_t rsrvd1               : 11 ;
    ca_uint32_t en                   :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_DIS_PEND_TIME_THRED_t;


#define EPON_XGONU_MPCP_MPCP_REG_REQ_RESV0       0xd0032054
#define EPON_XGONU_MPCP_MPCP_REG_REQ_RESV0_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_REG_REQ_RESV0_t;


#define EPON_XGONU_MPCP_MPCP_REG_REQ_RESV1       0xd0032058
#define EPON_XGONU_MPCP_MPCP_REG_REQ_RESV1_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_REG_REQ_RESV1_t;


#define EPON_XGONU_MPCP_MPCP_REG_REQ_RESV2       0xd003205c
#define EPON_XGONU_MPCP_MPCP_REG_REQ_RESV2_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_REG_REQ_RESV2_t;


#define EPON_XGONU_MPCP_MPCP_REG_REQ_RESV3       0xd0032060
#define EPON_XGONU_MPCP_MPCP_REG_REQ_RESV3_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_REG_REQ_RESV3_t;


#define EPON_XGONU_MPCP_MPCP_REG_REQ_RESV4       0xd0032064
#define EPON_XGONU_MPCP_MPCP_REG_REQ_RESV4_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_REG_REQ_RESV4_t;


#define EPON_XGONU_MPCP_MPCP_REG_REQ_RESV5       0xd0032068
#define EPON_XGONU_MPCP_MPCP_REG_REQ_RESV5_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_REG_REQ_RESV5_t;


#define EPON_XGONU_MPCP_MPCP_REG_REQ_RESV6       0xd003206c
#define EPON_XGONU_MPCP_MPCP_REG_REQ_RESV6_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_REG_REQ_RESV6_t;


#define EPON_XGONU_MPCP_MPCP_REG_REQ_RESV7       0xd0032070
#define EPON_XGONU_MPCP_MPCP_REG_REQ_RESV7_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_REG_REQ_RESV7_t;


#define EPON_XGONU_MPCP_MPCP_REG_REQ_RESV8       0xd0032074
#define EPON_XGONU_MPCP_MPCP_REG_REQ_RESV8_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_REG_REQ_RESV8_t;


#define EPON_XGONU_MPCP_MPCP_ACK_RESV0           0xd0032078
#define EPON_XGONU_MPCP_MPCP_ACK_RESV0_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_ACK_RESV0_t;


#define EPON_XGONU_MPCP_MPCP_ACK_RESV1           0xd003207c
#define EPON_XGONU_MPCP_MPCP_ACK_RESV1_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_ACK_RESV1_t;


#define EPON_XGONU_MPCP_MPCP_ACK_RESV2           0xd0032080
#define EPON_XGONU_MPCP_MPCP_ACK_RESV2_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_ACK_RESV2_t;


#define EPON_XGONU_MPCP_MPCP_ACK_RESV3           0xd0032084
#define EPON_XGONU_MPCP_MPCP_ACK_RESV3_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_ACK_RESV3_t;


#define EPON_XGONU_MPCP_MPCP_ACK_RESV4           0xd0032088
#define EPON_XGONU_MPCP_MPCP_ACK_RESV4_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_ACK_RESV4_t;


#define EPON_XGONU_MPCP_MPCP_ACK_RESV5           0xd003208c
#define EPON_XGONU_MPCP_MPCP_ACK_RESV5_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_ACK_RESV5_t;


#define EPON_XGONU_MPCP_MPCP_ACK_RESV6           0xd0032090
#define EPON_XGONU_MPCP_MPCP_ACK_RESV6_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_ACK_RESV6_t;


#define EPON_XGONU_MPCP_MPCP_ACK_RESV7           0xd0032094
#define EPON_XGONU_MPCP_MPCP_ACK_RESV7_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_ACK_RESV7_t;


#define EPON_XGONU_MPCP_MPCP_ACK_RESV8           0xd0032098
#define EPON_XGONU_MPCP_MPCP_ACK_RESV8_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_ACK_RESV8_t;


#define EPON_XGONU_MPCP_TIMESTAMP                0xd003209c
#define EPON_XGONU_MPCP_TIMESTAMP_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_TIMESTAMP_t;


#define EPON_XGONU_MPCP_MPCP_OLTMACH             0xd00320a0
#define EPON_XGONU_MPCP_MPCP_OLTMACH_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t olt_macH             : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_OLTMACH_t;


#define EPON_XGONU_MPCP_MPCP_OLTMACL             0xd00320a4
#define EPON_XGONU_MPCP_MPCP_OLTMACL_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t olt_macL             : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_OLTMACL_t;


#define EPON_XGONU_MPCP_MPCP_LOCAL_DISINFO       0xd00320a8
#define EPON_XGONU_MPCP_MPCP_LOCAL_DISINFO_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t onu                  :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_LOCAL_DISINFO_t;


#define EPON_XGONU_MPCP_MPCP_REMOTE_DISINFO      0xd00320ac
#define EPON_XGONU_MPCP_MPCP_REMOTE_DISINFO_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t olt                  : 16 ; /* bits 15:0 */
    ca_uint32_t grant_size           : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_REMOTE_DISINFO_t;


#define EPON_XGONU_MPCP_MPCP_SELF_RPT_STS        0xd00320b0
#define EPON_XGONU_MPCP_MPCP_SELF_RPT_STS_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t self_rpt             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_SELF_RPT_STS_t;


#define EPON_XGONU_MPCP_MPCP_ONU_PATH_SPEED      0xd00320b4
#define EPON_XGONU_MPCP_MPCP_ONU_PATH_SPEED_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t txpath_speed         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_ONU_PATH_SPEED_t;


#define EPON_XGONU_MPCP_MPCP_GRANT_FIFO_STS      0xd00320b8
#define EPON_XGONU_MPCP_MPCP_GRANT_FIFO_STS_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t full_grt             :  1 ; /* bits 0:0 */
    ca_uint32_t empty_grt            :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_GRANT_FIFO_STS_t;


#define EPON_XGONU_MPCP_MPCP_GRANT_DROP_CNTR     0xd00320bc
#define EPON_XGONU_MPCP_MPCP_GRANT_DROP_CNTR_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ovd_cnt              :  8 ; /* bits 7:0 */
    ca_uint32_t max_cnt              :  8 ; /* bits 15:8 */
    ca_uint32_t min_cnt              :  8 ; /* bits 23:16 */
    ca_uint32_t localLTstart_cnt     :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_GRANT_DROP_CNTR_t;


#define EPON_XGONU_MPCP_MPCP_GRANT_DROP_CNTR1    0xd00320c0
#define EPON_XGONU_MPCP_MPCP_GRANT_DROP_CNTR1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wr_full_cnt          :  8 ; /* bits 7:0 */
    ca_uint32_t rd_empty_cnt         :  8 ; /* bits 15:8 */
    ca_uint32_t rd_drop_cnt          :  8 ; /* bits 23:16 */
    ca_uint32_t llid_mismatch_drop_cnt :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_GRANT_DROP_CNTR1_t;


#define EPON_XGONU_MPCP_MPCP_BAK_GRANT_CNTR      0xd00320c4
#define EPON_XGONU_MPCP_MPCP_BAK_GRANT_CNTR_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_BAK_GRANT_CNTR_t;


#define EPON_XGONU_MPCP_MPCP_LLID_SYNCTIME       0xd00320c8
#define EPON_XGONU_MPCP_MPCP_LLID_SYNCTIME_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sync_time            : 16 ; /* bits 15:0 */
    ca_uint32_t assigned_llid        : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_LLID_SYNCTIME_t;


#define EPON_XGONU_MPCP_MPCP_DIS_SYNCTIME        0xd00320cc
#define EPON_XGONU_MPCP_MPCP_DIS_SYNCTIME_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sync_time_xg         : 16 ; /* bits 15:0 */
    ca_uint32_t sync_time_1g         : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_DIS_SYNCTIME_t;


#define EPON_XGONU_MPCP_MPCP_SYNCTIME_CFG        0xd00320d0
#define EPON_XGONU_MPCP_MPCP_SYNCTIME_CFG_dft    0x00200020

typedef volatile union {
  struct {
    ca_uint32_t sync_time_dis        : 16 ; /* bits 15:0 */
    ca_uint32_t sync_time_norm       : 15 ; /* bits 30:16 */
    ca_uint32_t mode                 :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_SYNCTIME_CFG_t;


#define EPON_XGONU_MPCP_MPCP_LASER_TIME_STS      0xd00320d4
#define EPON_XGONU_MPCP_MPCP_LASER_TIME_STS_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t laserOnTime_sts      :  8 ; /* bits 7:0 */
    ca_uint32_t laserOffTime_sts     :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_LASER_TIME_STS_t;


#define EPON_XGONU_MPCP_MPCP_PKT_FLAG            0xd00320d8
#define EPON_XGONU_MPCP_MPCP_PKT_FLAG_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ack_flag             :  8 ; /* bits 7:0 */
    ca_uint32_t request_flag         :  8 ; /* bits 15:8 */
    ca_uint32_t register_flag        :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_PKT_FLAG_t;


#define EPON_XGONU_MPCP_MPCP_REGISTER_STS        0xd00320dc
#define EPON_XGONU_MPCP_MPCP_REGISTER_STS_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t prereg               :  1 ; /* bits 0:0 */
    ca_uint32_t registered           :  1 ; /* bits 1:1 */
    ca_uint32_t permit               :  1 ; /* bits 2:2 */
    ca_uint32_t retry                :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_REGISTER_STS_t;


#define EPON_XGONU_MPCP_MPCP_DEREG               0xd00320e0
#define EPON_XGONU_MPCP_MPCP_DEREG_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t en_local_offline     : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_DEREG_t;


#define EPON_XGONU_MPCP_MPCP_GATE_TIMER_STS      0xd00320e4
#define EPON_XGONU_MPCP_MPCP_GATE_TIMER_STS_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t expire_sts           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_GATE_TIMER_STS_t;


#define EPON_XGONU_MPCP_MPCP_DEREG_CAUSE         0xd00320e8
#define EPON_XGONU_MPCP_MPCP_DEREG_CAUSE_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t code                 :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t first_dereg_code     :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  9 ;
    ca_uint32_t dereg_cnt            : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_DEREG_CAUSE_t;


#define EPON_XGONU_MPCP_MPCP_MON_CNTR            0xd00320ec
#define EPON_XGONU_MPCP_MPCP_MON_CNTR_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ts_drift_cnt         :  8 ; /* bits 7:0 */
    ca_uint32_t mpcp_timer_expir_cnt :  8 ; /* bits 15:8 */
    ca_uint32_t gate_timer_expir_cnt :  8 ; /* bits 23:16 */
    ca_uint32_t reged_cnt            :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_MON_CNTR_t;


#define EPON_XGONU_MPCP_MPCP_MON_STS             0xd00320f0
#define EPON_XGONU_MPCP_MPCP_MON_STS_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t force_report_before_reged :  1 ; /* bits 0:0 */
    ca_uint32_t normal_gate_before_reged :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 14 ;
    ca_uint32_t retry_cnt            : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_MON_STS_t;


#define EPON_XGONU_MPCP_MPCP_LLID_DBG            0xd00320f4
#define EPON_XGONU_MPCP_MPCP_LLID_DBG_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dbg_mac_idx          :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 11 ;
    ca_uint32_t debug_sel            :  7 ; /* bits 22:16 */
    ca_uint32_t rsrvd2               :  8 ;
    ca_uint32_t en_llid_debug        :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_LLID_DBG_t;


#define EPON_XGONU_MPCP_MPCP_GRANT_FIFO_CTRL     0xd00320f8
#define EPON_XGONU_MPCP_MPCP_GRANT_FIFO_CTRL_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_GRANT_FIFO_CTRL_t;


#define EPON_XGONU_MPCP_MPCP_GRANT_FIFO_DATA     0xd00320fc
#define EPON_XGONU_MPCP_MPCP_GRANT_FIFO_DATA_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_GRANT_FIFO_DATA_t;


#define EPON_XGONU_MPCP_MPCP_RXPKT_CNTR          0xd0032100
#define EPON_XGONU_MPCP_MPCP_RXPKT_CNTR_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rx_pktcnt            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_RXPKT_CNTR_t;


#define EPON_XGONU_MPCP_MPCP_TXPKT_CNTR          0xd0032104
#define EPON_XGONU_MPCP_MPCP_TXPKT_CNTR_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_pktcnt            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_TXPKT_CNTR_t;


#define EPON_XGONU_MPCP_CTL_RPT_TMR              0xd0032108
#define EPON_XGONU_MPCP_CTL_RPT_TMR_dft          0x0007000c

typedef volatile union {
  struct {
    ca_uint32_t reg_rpt_vld_tmr      : 16 ; /* bits 15:0 */
    ca_uint32_t reg_rpt_req_tmr      : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_CTL_RPT_TMR_t;


#define EPON_XGONU_MPCP_POWER_SAVING_CFG         0xd003210c
#define EPON_XGONU_MPCP_POWER_SAVING_CFG_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sleep_cycle_en       :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_POWER_SAVING_CFG_t;


#define EPON_XGONU_MPCP_POWER_SAVING_STS         0xd0032110
#define EPON_XGONU_MPCP_POWER_SAVING_STS_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sleep_cycle_st       :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_POWER_SAVING_STS_t;


#define EPON_XGONU_MPCP_SPARE                    0xd0032114
#define EPON_XGONU_MPCP_SPARE_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cfg                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_SPARE_t;


#define EPON_XGONU_MPCP_RSVR                     0xd0032118
#define EPON_XGONU_MPCP_RSVR_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t val                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_RSVR_t;


#define EPON_XGONU_MPCP_MP_RPT_CNT               0xd003211c
#define EPON_XGONU_MPCP_MP_RPT_CNT_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tx_rpt_cnt           : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MP_RPT_CNT_t;


#define EPON_XGONU_MPCP_MPCP_DISPKT_CNTR         0xd0032120
#define EPON_XGONU_MPCP_MPCP_DISPKT_CNTR_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t disfrm_cnt           : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_DISPKT_CNTR_t;


#define EPON_XGONU_MPCP_MPCP_DISPKT_PERIOD       0xd0032124
#define EPON_XGONU_MPCP_MPCP_DISPKT_PERIOD_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t disfrm_period        : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MPCP_DISPKT_PERIOD_t;


#define EPON_XGONU_MPCP_MISC                     0xd0032128
#define EPON_XGONU_MPCP_MISC_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mpcp_datapath_rst    :  1 ; /* bits 0:0 */
    ca_uint32_t txACK_mode           :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} EPON_XGONU_MPCP_MISC_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* xgonu_mpcp */
typedef struct {
  EPON_XGONU_MPCP_MPCP_IRQ_SRC_INTERRUPT_t MPCP_IRQ_SRC_INTERRUPT;        /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  EPON_XGONU_MPCP_MPCP_IRQ_SRC_INTERRUPTE_t MPCP_IRQ_SRC_INTERRUPTE;       /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  EPON_XGONU_MPCP_MPCP_INIT_CFG_t          MPCP_INIT_CFG;                 /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  EPON_XGONU_MPCP_MPCP_START_CFG_t         MPCP_START_CFG;                /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  EPON_XGONU_MPCP_MPCP_REGISTER_FRAME_STS_t MPCP_REGISTER_FRAME_STS;       /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  EPON_XGONU_MPCP_MAC_REG_STATUS_t         MAC_REG_STATUS;                /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  EPON_XGONU_MPCP_MAC_MPCP_STS1_t          MAC_MPCP_STS1;                 /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  EPON_XGONU_MPCP_MAC_MPCP_STS0_t          MAC_MPCP_STS0;                 /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  EPON_XGONU_MPCP_MPCP_CFG0_t              MPCP_CFG0;                     /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  EPON_XGONU_MPCP_MPCP_CFG_t               MPCP_CFG;                      /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  EPON_XGONU_MPCP_MPCP_CFG_1G_t            MPCP_CFG_1G;                   /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  EPON_XGONU_MPCP_MPCP_CFG_10G_t           MPCP_CFG_10G;                  /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  EPON_XGONU_MPCP_GRANT_VLD_AHEAD_TIMER_t  GRANT_VLD_AHEAD_TIMER;         /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  EPON_XGONU_MPCP_ES_STOP_WIN_CFG_t        ES_STOP_WIN_CFG;               /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  EPON_XGONU_MPCP_MPCP_GRANT_TIMER_t       MPCP_GRANT_TIMER;              /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  EPON_XGONU_MPCP_MPCP_LASER_TIME_CFG_t    MPCP_LASER_TIME_CFG;           /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  EPON_XGONU_MPCP_MPCP_STIME_ADJ_t         MPCP_STIME_ADJ;                /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  EPON_XGONU_MPCP_MPCP_CTC_REG_TIME_t      MPCP_CTC_REG_TIME;             /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  EPON_XGONU_MPCP_MPCP_RPT_TIME_THRED_t    MPCP_RPT_TIME_THRED;           /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  EPON_XGONU_MPCP_MPCP_TIMER_EXP_THRED_t   MPCP_TIMER_EXP_THRED;          /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  EPON_XGONU_MPCP_MPCP_DIS_PEND_TIME_THRED_t MPCP_DIS_PEND_TIME_THRED;      /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  EPON_XGONU_MPCP_MPCP_REG_REQ_RESV0_t     MPCP_REG_REQ_RESV0;            /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  EPON_XGONU_MPCP_MPCP_REG_REQ_RESV1_t     MPCP_REG_REQ_RESV1;            /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  EPON_XGONU_MPCP_MPCP_REG_REQ_RESV2_t     MPCP_REG_REQ_RESV2;            /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  EPON_XGONU_MPCP_MPCP_REG_REQ_RESV3_t     MPCP_REG_REQ_RESV3;            /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  EPON_XGONU_MPCP_MPCP_REG_REQ_RESV4_t     MPCP_REG_REQ_RESV4;            /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  EPON_XGONU_MPCP_MPCP_REG_REQ_RESV5_t     MPCP_REG_REQ_RESV5;            /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  EPON_XGONU_MPCP_MPCP_REG_REQ_RESV6_t     MPCP_REG_REQ_RESV6;            /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  EPON_XGONU_MPCP_MPCP_REG_REQ_RESV7_t     MPCP_REG_REQ_RESV7;            /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  EPON_XGONU_MPCP_MPCP_REG_REQ_RESV8_t     MPCP_REG_REQ_RESV8;            /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  EPON_XGONU_MPCP_MPCP_ACK_RESV0_t         MPCP_ACK_RESV0;                /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  EPON_XGONU_MPCP_MPCP_ACK_RESV1_t         MPCP_ACK_RESV1;                /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  EPON_XGONU_MPCP_MPCP_ACK_RESV2_t         MPCP_ACK_RESV2;                /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  EPON_XGONU_MPCP_MPCP_ACK_RESV3_t         MPCP_ACK_RESV3;                /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  EPON_XGONU_MPCP_MPCP_ACK_RESV4_t         MPCP_ACK_RESV4;                /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  EPON_XGONU_MPCP_MPCP_ACK_RESV5_t         MPCP_ACK_RESV5;                /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  EPON_XGONU_MPCP_MPCP_ACK_RESV6_t         MPCP_ACK_RESV6;                /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  EPON_XGONU_MPCP_MPCP_ACK_RESV7_t         MPCP_ACK_RESV7;                /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  EPON_XGONU_MPCP_MPCP_ACK_RESV8_t         MPCP_ACK_RESV8;                /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];                   
  EPON_XGONU_MPCP_TIMESTAMP_t              TIMESTAMP;                     /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];                   
  EPON_XGONU_MPCP_MPCP_OLTMACH_t           MPCP_OLTMACH;                  /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];                   
  EPON_XGONU_MPCP_MPCP_OLTMACL_t           MPCP_OLTMACL;                  /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];                   
  EPON_XGONU_MPCP_MPCP_LOCAL_DISINFO_t     MPCP_LOCAL_DISINFO;            /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];                   
  EPON_XGONU_MPCP_MPCP_REMOTE_DISINFO_t    MPCP_REMOTE_DISINFO;           /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd44[3];                   
  EPON_XGONU_MPCP_MPCP_SELF_RPT_STS_t      MPCP_SELF_RPT_STS;             /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd45[3];                   
  EPON_XGONU_MPCP_MPCP_ONU_PATH_SPEED_t    MPCP_ONU_PATH_SPEED;           /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd46[3];                   
  EPON_XGONU_MPCP_MPCP_GRANT_FIFO_STS_t    MPCP_GRANT_FIFO_STS;           /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd47[3];                   
  EPON_XGONU_MPCP_MPCP_GRANT_DROP_CNTR_t   MPCP_GRANT_DROP_CNTR;          /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd48[3];                   
  EPON_XGONU_MPCP_MPCP_GRANT_DROP_CNTR1_t  MPCP_GRANT_DROP_CNTR1;         /* addr: 0x000000c0 */
  ca_uint32_t                              rsrvd49[3];                   
  EPON_XGONU_MPCP_MPCP_BAK_GRANT_CNTR_t    MPCP_BAK_GRANT_CNTR;           /* addr: 0x000000c4 */
  ca_uint32_t                              rsrvd50[3];                   
  EPON_XGONU_MPCP_MPCP_LLID_SYNCTIME_t     MPCP_LLID_SYNCTIME;            /* addr: 0x000000c8 */
  ca_uint32_t                              rsrvd51[3];                   
  EPON_XGONU_MPCP_MPCP_DIS_SYNCTIME_t      MPCP_DIS_SYNCTIME;             /* addr: 0x000000cc */
  ca_uint32_t                              rsrvd52[3];                   
  EPON_XGONU_MPCP_MPCP_SYNCTIME_CFG_t      MPCP_SYNCTIME_CFG;             /* addr: 0x000000d0 */
  ca_uint32_t                              rsrvd53[3];                   
  EPON_XGONU_MPCP_MPCP_LASER_TIME_STS_t    MPCP_LASER_TIME_STS;           /* addr: 0x000000d4 */
  ca_uint32_t                              rsrvd54[3];                   
  EPON_XGONU_MPCP_MPCP_PKT_FLAG_t          MPCP_PKT_FLAG;                 /* addr: 0x000000d8 */
  ca_uint32_t                              rsrvd55[3];                   
  EPON_XGONU_MPCP_MPCP_REGISTER_STS_t      MPCP_REGISTER_STS;             /* addr: 0x000000dc */
  ca_uint32_t                              rsrvd56[3];                   
  EPON_XGONU_MPCP_MPCP_DEREG_t             MPCP_DEREG;                    /* addr: 0x000000e0 */
  ca_uint32_t                              rsrvd57[3];                   
  EPON_XGONU_MPCP_MPCP_GATE_TIMER_STS_t    MPCP_GATE_TIMER_STS;           /* addr: 0x000000e4 */
  ca_uint32_t                              rsrvd58[3];                   
  EPON_XGONU_MPCP_MPCP_DEREG_CAUSE_t       MPCP_DEREG_CAUSE;              /* addr: 0x000000e8 */
  ca_uint32_t                              rsrvd59[3];                   
  EPON_XGONU_MPCP_MPCP_MON_CNTR_t          MPCP_MON_CNTR;                 /* addr: 0x000000ec */
  ca_uint32_t                              rsrvd60[3];                   
  EPON_XGONU_MPCP_MPCP_MON_STS_t           MPCP_MON_STS;                  /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd61[3];                   
  EPON_XGONU_MPCP_MPCP_LLID_DBG_t          MPCP_LLID_DBG;                 /* addr: 0x000000f4 */
  ca_uint32_t                              rsrvd62[3];                   
  EPON_XGONU_MPCP_MPCP_GRANT_FIFO_CTRL_t   MPCP_GRANT_FIFO_CTRL;          /* addr: 0x000000f8 */
  ca_uint32_t                              rsrvd63[3];                   
  EPON_XGONU_MPCP_MPCP_GRANT_FIFO_DATA_t   MPCP_GRANT_FIFO_DATA;          /* addr: 0x000000fc */
  ca_uint32_t                              rsrvd64[3];                   
  EPON_XGONU_MPCP_MPCP_RXPKT_CNTR_t        MPCP_RXPKT_CNTR;               /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd65[3];                   
  EPON_XGONU_MPCP_MPCP_TXPKT_CNTR_t        MPCP_TXPKT_CNTR;               /* addr: 0x00000104 */
  ca_uint32_t                              rsrvd66[3];                   
  EPON_XGONU_MPCP_CTL_RPT_TMR_t            CTL_RPT_TMR;                   /* addr: 0x00000108 */
  ca_uint32_t                              rsrvd67[3];                   
  EPON_XGONU_MPCP_POWER_SAVING_CFG_t       POWER_SAVING_CFG;              /* addr: 0x0000010c */
  ca_uint32_t                              rsrvd68[3];                   
  EPON_XGONU_MPCP_POWER_SAVING_STS_t       POWER_SAVING_STS;              /* addr: 0x00000110 */
  ca_uint32_t                              rsrvd69[3];                   
  EPON_XGONU_MPCP_SPARE_t                  SPARE;                         /* addr: 0x00000114 */
  ca_uint32_t                              rsrvd70[3];                   
  EPON_XGONU_MPCP_RSVR_t                   RSVR;                          /* addr: 0x00000118 */
  ca_uint32_t                              rsrvd71[3];                   
  EPON_XGONU_MPCP_MP_RPT_CNT_t             MP_RPT_CNT;                    /* addr: 0x0000011c */
  ca_uint32_t                              rsrvd72[3];                   
  EPON_XGONU_MPCP_MPCP_DISPKT_CNTR_t       MPCP_DISPKT_CNTR;              /* addr: 0x00000120 */
  ca_uint32_t                              rsrvd73[3];                   
  EPON_XGONU_MPCP_MPCP_DISPKT_PERIOD_t     MPCP_DISPKT_PERIOD;            /* addr: 0x00000124 */
  ca_uint32_t                              rsrvd74[3];                   
  EPON_XGONU_MPCP_MISC_t                   MISC;                          /* addr: 0x00000128 */
} APB1_EPON_XGONU_MPCP_t;

    
  
        
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* EPON */

typedef struct {
  APB1_EPON_EPON_GLB_t                     epon_glb;                      /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[1305];                 
  APB1_EPON_EPON_MIB_t                     epon_mib;                      /* addr: 0x00000600 */
  ca_uint32_t                              rsrvd2[469];                  
  APB1_EPON_ONU_EPON_t                     ONU_EPON;                      /* addr: 0x00000800 */
  ca_uint32_t                              rsrvd3[825];                  
  APB1_EPON_ONU_1PPS_t                     onu_1pps;                      /* addr: 0x00000c00 */
  ca_uint32_t                              rsrvd4[245];                  
  APB1_EPON_GLB_PTP_t                      glb_ptp;                       /* addr: 0x00000d00 */
  ca_uint32_t                              rsrvd5[493];                  
  APB1_EPON_ONU_LT_t                       onu_lt;                        /* addr: 0x00000f00 */
  ca_uint32_t                              rsrvd6[239];                  
  APB1_EPON_XGEPN_t                        XGEPN;                         /* addr: 0x00001000 */
  ca_uint32_t                              rsrvd7[2400];                 
  APB1_EPON_XGONU_MPCP_t                   xgonu_mpcp;                    /* addr: 0x00002000 */
} APB1_EPON_t;


/*
 * XGPN
 */
  
/*
 * xgpn_glb
 */
        
#define XGPN_XGPN_GLB_VERSION_ID                 0xd0034000
#define XGPN_XGPN_GLB_VERSION_ID_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t revid                : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_XGPN_GLB_VERSION_ID_t;


#define XGPN_XGPN_GLB_CTRL                       0xd0034004
#define XGPN_XGPN_GLB_CTRL_dft                   0x000000c0

typedef volatile union {
  struct {
    ca_uint32_t mac_en               :  2 ; /* bits 1:0 */
    ca_uint32_t power_saving_mode    :  2 ; /* bits 3:2 */
    ca_uint32_t pm_mode              :  2 ; /* bits 5:4 */
    ca_uint32_t us_line_rate         :  2 ; /* bits 7:6 */
    ca_uint32_t uwlch_id             :  4 ; /* bits 11:8 */
    ca_uint32_t rsrvd1               : 12 ;
    ca_uint32_t flush_id             :  5 ; /* bits 28:24 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t flush_en             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_XGPN_GLB_CTRL_t;


#define XGPN_XGPN_GLB_INTERRUPT0                 0xd0034008
#define XGPN_XGPN_GLB_INTERRUPT0_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t DSFP                 :  1 ; /* bits 0:0 */
    ca_uint32_t USBG                 :  1 ; /* bits 1:1 */
    ca_uint32_t PLMP                 :  1 ; /* bits 2:2 */
    ca_uint32_t BWMP                 :  1 ; /* bits 3:3 */
    ca_uint32_t ACTP                 :  1 ; /* bits 4:4 */
    ca_uint32_t AES                  :  1 ; /* bits 5:5 */
    ca_uint32_t AES_PLMP             :  1 ; /* bits 6:6 */
    ca_uint32_t XGFEC                :  1 ; /* bits 7:7 */
    ca_uint32_t RXCTL                :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_XGPN_GLB_INTERRUPT0_t;


#define XGPN_XGPN_GLB_INTERRUPT0E                0xd003400c
#define XGPN_XGPN_GLB_INTERRUPT0E_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t DSFPE                :  1 ; /* bits 0:0 */
    ca_uint32_t USBGE                :  1 ; /* bits 1:1 */
    ca_uint32_t PLMPE                :  1 ; /* bits 2:2 */
    ca_uint32_t BWMPE                :  1 ; /* bits 3:3 */
    ca_uint32_t ACTPE                :  1 ; /* bits 4:4 */
    ca_uint32_t AESE                 :  1 ; /* bits 5:5 */
    ca_uint32_t AES_PLMPE            :  1 ; /* bits 6:6 */
    ca_uint32_t XGFECE               :  1 ; /* bits 7:7 */
    ca_uint32_t RXCTLE               :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_XGPN_GLB_INTERRUPT0E_t;


#define XGPN_XGPN_GLB_INTERRUPT1                 0xd0034010
#define XGPN_XGPN_GLB_INTERRUPT1_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t DSFP                 :  1 ; /* bits 0:0 */
    ca_uint32_t USBG                 :  1 ; /* bits 1:1 */
    ca_uint32_t PLMP                 :  1 ; /* bits 2:2 */
    ca_uint32_t BWMP                 :  1 ; /* bits 3:3 */
    ca_uint32_t ACTP                 :  1 ; /* bits 4:4 */
    ca_uint32_t AES                  :  1 ; /* bits 5:5 */
    ca_uint32_t AES_PLMP             :  1 ; /* bits 6:6 */
    ca_uint32_t XGFEC                :  1 ; /* bits 7:7 */
    ca_uint32_t RXCTL                :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_XGPN_GLB_INTERRUPT1_t;


#define XGPN_XGPN_GLB_INTERRUPT1E                0xd0034014
#define XGPN_XGPN_GLB_INTERRUPT1E_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t DSFPE                :  1 ; /* bits 0:0 */
    ca_uint32_t USBGE                :  1 ; /* bits 1:1 */
    ca_uint32_t PLMPE                :  1 ; /* bits 2:2 */
    ca_uint32_t BWMPE                :  1 ; /* bits 3:3 */
    ca_uint32_t ACTPE                :  1 ; /* bits 4:4 */
    ca_uint32_t AESE                 :  1 ; /* bits 5:5 */
    ca_uint32_t AES_PLMPE            :  1 ; /* bits 6:6 */
    ca_uint32_t XGFECE               :  1 ; /* bits 7:7 */
    ca_uint32_t RXCTLE               :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_XGPN_GLB_INTERRUPT1E_t;


#define XGPN_XGPN_GLB_DEBUG_CTRL                 0xd0034018
#define XGPN_XGPN_GLB_DEBUG_CTRL_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sel                  :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_XGPN_GLB_DEBUG_CTRL_t;


#define XGPN_XGPN_GLB_DEBUG_STATUS0              0xd003401c
#define XGPN_XGPN_GLB_DEBUG_STATUS0_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_XGPN_GLB_DEBUG_STATUS0_t;


#define XGPN_XGPN_GLB_DEBUG_STATUS1              0xd0034020
#define XGPN_XGPN_GLB_DEBUG_STATUS1_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_XGPN_GLB_DEBUG_STATUS1_t;


#define XGPN_XGPN_GLB_SUPER_FRAME_MATCH_VAL1     0xd0034024
#define XGPN_XGPN_GLB_SUPER_FRAME_MATCH_VAL1_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sfc1                 : 19 ; /* bits 18:0 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_XGPN_GLB_SUPER_FRAME_MATCH_VAL1_t;


#define XGPN_XGPN_GLB_SUPER_FRAME_MATCH_VAL0     0xd0034028
#define XGPN_XGPN_GLB_SUPER_FRAME_MATCH_VAL0_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sfc0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_XGPN_GLB_SUPER_FRAME_MATCH_VAL0_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* xgpn_glb */
typedef struct {
  XGPN_XGPN_GLB_VERSION_ID_t               VERSION_ID;                    /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  XGPN_XGPN_GLB_CTRL_t                     CTRL;                          /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  XGPN_XGPN_GLB_INTERRUPT0_t               INTERRUPT0;                    /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  XGPN_XGPN_GLB_INTERRUPT0E_t              INTERRUPT0E;                   /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  XGPN_XGPN_GLB_INTERRUPT1_t               INTERRUPT1;                    /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  XGPN_XGPN_GLB_INTERRUPT1E_t              INTERRUPT1E;                   /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  XGPN_XGPN_GLB_DEBUG_CTRL_t               DEBUG_CTRL;                    /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  XGPN_XGPN_GLB_DEBUG_STATUS0_t            DEBUG_STATUS0;                 /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  XGPN_XGPN_GLB_DEBUG_STATUS1_t            DEBUG_STATUS1;                 /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  XGPN_XGPN_GLB_SUPER_FRAME_MATCH_VAL1_t   SUPER_FRAME_MATCH_VAL1;        /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  XGPN_XGPN_GLB_SUPER_FRAME_MATCH_VAL0_t   SUPER_FRAME_MATCH_VAL0;        /* addr: 0x00000028 */
} APB1_XGPN_XGPN_GLB_t;


/*
 * dsfp
 */
        
#define XGPN_DSFP_hec_ctl                        0xd0034100
#define XGPN_DSFP_hec_ctl_dft                    0x00000003

typedef volatile union {
  struct {
    ca_uint32_t hec0_en              :  1 ; /* bits 0:0 */
    ca_uint32_t hec1_en              :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_hec_ctl_t;


#define XGPN_DSFP_sync_ctl                       0xd0034104
#define XGPN_DSFP_sync_ctl_dft                   0x0003002d

typedef volatile union {
  struct {
    ca_uint32_t ds_descramble_en     :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t sfc_hecchk_en        :  1 ; /* bits 2:2 */
    ca_uint32_t ponid_hecchk_en      :  1 ; /* bits 3:3 */
    ca_uint32_t psbd_err_allow       :  3 ; /* bits 6:4 */
    ca_uint32_t rsrvd2               :  9 ;
    ca_uint32_t resync_loss_frame_num :  3 ; /* bits 18:16 */
    ca_uint32_t rsrvd3               : 11 ;
    ca_uint32_t byte_swap_en         :  1 ; /* bits 30:30 */
    ca_uint32_t bit_swap_en          :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_sync_ctl_t;


#define XGPN_DSFP_xgtc_ctl                       0xd0034108
#define XGPN_DSFP_xgtc_ctl_dft                   0x0000000f

typedef volatile union {
  struct {
    ca_uint32_t hec_chk_en           :  1 ; /* bits 0:0 */
    ca_uint32_t bwmp_en              :  1 ; /* bits 1:1 */
    ca_uint32_t ploam_en             :  1 ; /* bits 2:2 */
    ca_uint32_t ds_en                :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 24 ;
    ca_uint32_t drop_xgtc_frame_en   :  1 ; /* bits 28:28 */
    ca_uint32_t rsrvd2               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_xgtc_ctl_t;


#define XGPN_DSFP_xgem_ctl                       0xd003410c
#define XGPN_DSFP_xgem_ctl_dft                   0x00000019

typedef volatile union {
  struct {
    ca_uint32_t hec_chk_en           :  1 ; /* bits 0:0 */
    ca_uint32_t invld_key_xgem_drop_en :  1 ; /* bits 1:1 */
    ca_uint32_t old_key_xgem_drop_en :  1 ; /* bits 2:2 */
    ca_uint32_t los_word_cnt_clr_en  :  1 ; /* bits 3:3 */
    ca_uint32_t short_pkt_drop_en    :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_xgem_ctl_t;


#define XGPN_DSFP_rxmac_ctl                      0xd0034110
#define XGPN_DSFP_rxmac_ctl_dft                  0x07d00281

typedef volatile union {
  struct {
    ca_uint32_t crc_chk_en           :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t omci_min_pkt_size    :  6 ; /* bits 9:4 */
    ca_uint32_t rsrvd2               :  6 ;
    ca_uint32_t max_pkt_size         : 14 ; /* bits 29:16 */
    ca_uint32_t rsrvd3               :  2 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_rxmac_ctl_t;


#define XGPN_DSFP_rxmac_ctl1                     0xd0034114
#define XGPN_DSFP_rxmac_ctl1_dft                 0x07d00000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 16 ;
    ca_uint32_t max_pkt_size         : 11 ; /* bits 26:16 */
    ca_uint32_t rsrvd2               :  5 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_rxmac_ctl1_t;


#define XGPN_DSFP_INTERRUPT                      0xd0034118
#define XGPN_DSFP_INTERRUPT_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ds_losI              :  1 ; /* bits 0:0 */
    ca_uint32_t ds_psync_failI       :  1 ; /* bits 1:1 */
    ca_uint32_t ds_sfc_failI         :  1 ; /* bits 2:2 */
    ca_uint32_t xgem_fifo_overflowI  :  1 ; /* bits 3:3 */
    ca_uint32_t short_pkt_err        :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t xgem_portid_mismatchI :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t pkt_length_mismatchI :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd3               :  5 ;
    ca_uint32_t bip_32_errSat        :  1 ; /* bits 16:16 */
    ca_uint32_t bip_32_dw1Sat        :  1 ; /* bits 17:17 */
    ca_uint32_t psbd_hec_errSat      :  1 ; /* bits 18:18 */
    ca_uint32_t psbd_hec_uncorrected_mibSat :  1 ; /* bits 19:19 */
    ca_uint32_t xgtc_hec_correctedSat :  1 ; /* bits 20:20 */
    ca_uint32_t xgtc_hec_uncorrected_mibSat :  1 ; /* bits 21:21 */
    ca_uint32_t bwmap_hec_correctedSat :  1 ; /* bits 22:22 */
    ca_uint32_t bwmap_hec_uncorrected_mibSat :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd4               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_INTERRUPT_t;


#define XGPN_DSFP_INTERRUPTE0                    0xd003411c
#define XGPN_DSFP_INTERRUPTE0_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ds_losIE             :  1 ; /* bits 0:0 */
    ca_uint32_t ds_psync_failIE      :  1 ; /* bits 1:1 */
    ca_uint32_t ds_sfc_failIE        :  1 ; /* bits 2:2 */
    ca_uint32_t xgem_fifo_overflowIE :  1 ; /* bits 3:3 */
    ca_uint32_t short_pkt_errE       :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t xgem_portid_mismatchIE :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t pkt_length_mismatchIE :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd3               :  5 ;
    ca_uint32_t bip_32_errSatE       :  1 ; /* bits 16:16 */
    ca_uint32_t bip_32_dw1SatE       :  1 ; /* bits 17:17 */
    ca_uint32_t psbd_hec_errSatE     :  1 ; /* bits 18:18 */
    ca_uint32_t psbd_hec_uncorrected_mibSatE :  1 ; /* bits 19:19 */
    ca_uint32_t xgtc_hec_correctedSatE :  1 ; /* bits 20:20 */
    ca_uint32_t xgtc_hec_uncorrected_mibSatE :  1 ; /* bits 21:21 */
    ca_uint32_t bwmap_hec_correctedSatE :  1 ; /* bits 22:22 */
    ca_uint32_t bwmap_hec_uncorrected_mibSatE :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd4               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_INTERRUPTE0_t;


#define XGPN_DSFP_INTERRUPTE1                    0xd0034120
#define XGPN_DSFP_INTERRUPTE1_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ds_losIE             :  1 ; /* bits 0:0 */
    ca_uint32_t ds_psync_failIE      :  1 ; /* bits 1:1 */
    ca_uint32_t ds_sfc_failIE        :  1 ; /* bits 2:2 */
    ca_uint32_t xgem_fifo_overflowIE :  1 ; /* bits 3:3 */
    ca_uint32_t short_pkt_errE       :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t xgem_portid_mismatchIE :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t pkt_length_mismatchIE :  1 ; /* bits 10:10 */
    ca_uint32_t rsrvd3               :  5 ;
    ca_uint32_t bip_32_errSatE       :  1 ; /* bits 16:16 */
    ca_uint32_t bip_32_dw1SatE       :  1 ; /* bits 17:17 */
    ca_uint32_t psbd_hec_errSatE     :  1 ; /* bits 18:18 */
    ca_uint32_t psbd_hec_uncorrected_mibSatE :  1 ; /* bits 19:19 */
    ca_uint32_t xgtc_hec_correctedSatE :  1 ; /* bits 20:20 */
    ca_uint32_t xgtc_hec_uncorrected_mibSatE :  1 ; /* bits 21:21 */
    ca_uint32_t bwmap_hec_correctedSatE :  1 ; /* bits 22:22 */
    ca_uint32_t bwmap_hec_uncorrected_mibSatE :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd4               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_INTERRUPTE1_t;


#define XGPN_DSFP_xgem_key_ctl                   0xd0034124
#define XGPN_DSFP_xgem_key_ctl_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key0_idx_vld         :  1 ; /* bits 0:0 */
    ca_uint32_t key1_idx_vld         :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_xgem_key_ctl_t;


#define XGPN_DSFP_xgem_mc_key_ctl                0xd0034128
#define XGPN_DSFP_xgem_mc_key_ctl_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key0_idx_vld         :  1 ; /* bits 0:0 */
    ca_uint32_t key1_idx_vld         :  1 ; /* bits 1:1 */
    ca_uint32_t rsrvd1               : 30 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_xgem_mc_key_ctl_t;


#define XGPN_DSFP_portid0_ctl_xgem               0xd003412c
#define XGPN_DSFP_portid0_ctl_xgem_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid0_ctl_xgem_t;


#define XGPN_DSFP_portid1_ctl_xgem               0xd0034130
#define XGPN_DSFP_portid1_ctl_xgem_dft           0x00000001

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid1_ctl_xgem_t;


#define XGPN_DSFP_portid2_ctl_xgem               0xd0034134
#define XGPN_DSFP_portid2_ctl_xgem_dft           0x00000002

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid2_ctl_xgem_t;


#define XGPN_DSFP_portid3_ctl_xgem               0xd0034138
#define XGPN_DSFP_portid3_ctl_xgem_dft           0x00000003

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid3_ctl_xgem_t;


#define XGPN_DSFP_portid4_ctl_xgem               0xd003413c
#define XGPN_DSFP_portid4_ctl_xgem_dft           0x00000004

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid4_ctl_xgem_t;


#define XGPN_DSFP_portid5_ctl_xgem               0xd0034140
#define XGPN_DSFP_portid5_ctl_xgem_dft           0x00000005

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid5_ctl_xgem_t;


#define XGPN_DSFP_portid6_ctl_xgem               0xd0034144
#define XGPN_DSFP_portid6_ctl_xgem_dft           0x00000006

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid6_ctl_xgem_t;


#define XGPN_DSFP_portid7_ctl_xgem               0xd0034148
#define XGPN_DSFP_portid7_ctl_xgem_dft           0x00000007

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid7_ctl_xgem_t;


#define XGPN_DSFP_portid8_ctl_xgem               0xd003414c
#define XGPN_DSFP_portid8_ctl_xgem_dft           0x00000008

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid8_ctl_xgem_t;


#define XGPN_DSFP_portid9_ctl_xgem               0xd0034150
#define XGPN_DSFP_portid9_ctl_xgem_dft           0x00000009

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid9_ctl_xgem_t;


#define XGPN_DSFP_portid10_ctl_xgem              0xd0034154
#define XGPN_DSFP_portid10_ctl_xgem_dft          0x0000000a

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid10_ctl_xgem_t;


#define XGPN_DSFP_portid11_ctl_xgem              0xd0034158
#define XGPN_DSFP_portid11_ctl_xgem_dft          0x0000000b

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid11_ctl_xgem_t;


#define XGPN_DSFP_portid12_ctl_xgem              0xd003415c
#define XGPN_DSFP_portid12_ctl_xgem_dft          0x0000000c

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid12_ctl_xgem_t;


#define XGPN_DSFP_portid13_ctl_xgem              0xd0034160
#define XGPN_DSFP_portid13_ctl_xgem_dft          0x0000000d

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid13_ctl_xgem_t;


#define XGPN_DSFP_portid14_ctl_xgem              0xd0034164
#define XGPN_DSFP_portid14_ctl_xgem_dft          0x0000000e

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid14_ctl_xgem_t;


#define XGPN_DSFP_portid15_ctl_xgem              0xd0034168
#define XGPN_DSFP_portid15_ctl_xgem_dft          0x0000000f

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid15_ctl_xgem_t;


#define XGPN_DSFP_portid16_ctl_xgem              0xd003416c
#define XGPN_DSFP_portid16_ctl_xgem_dft          0x00000010

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid16_ctl_xgem_t;


#define XGPN_DSFP_portid17_ctl_xgem              0xd0034170
#define XGPN_DSFP_portid17_ctl_xgem_dft          0x00000011

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid17_ctl_xgem_t;


#define XGPN_DSFP_portid18_ctl_xgem              0xd0034174
#define XGPN_DSFP_portid18_ctl_xgem_dft          0x00000012

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid18_ctl_xgem_t;


#define XGPN_DSFP_portid19_ctl_xgem              0xd0034178
#define XGPN_DSFP_portid19_ctl_xgem_dft          0x00000013

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid19_ctl_xgem_t;


#define XGPN_DSFP_portid20_ctl_xgem              0xd003417c
#define XGPN_DSFP_portid20_ctl_xgem_dft          0x00000014

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid20_ctl_xgem_t;


#define XGPN_DSFP_portid21_ctl_xgem              0xd0034180
#define XGPN_DSFP_portid21_ctl_xgem_dft          0x00000015

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid21_ctl_xgem_t;


#define XGPN_DSFP_portid22_ctl_xgem              0xd0034184
#define XGPN_DSFP_portid22_ctl_xgem_dft          0x00000016

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid22_ctl_xgem_t;


#define XGPN_DSFP_portid23_ctl_xgem              0xd0034188
#define XGPN_DSFP_portid23_ctl_xgem_dft          0x00000017

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid23_ctl_xgem_t;


#define XGPN_DSFP_portid24_ctl_xgem              0xd003418c
#define XGPN_DSFP_portid24_ctl_xgem_dft          0x00000018

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid24_ctl_xgem_t;


#define XGPN_DSFP_portid25_ctl_xgem              0xd0034190
#define XGPN_DSFP_portid25_ctl_xgem_dft          0x00000019

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid25_ctl_xgem_t;


#define XGPN_DSFP_portid26_ctl_xgem              0xd0034194
#define XGPN_DSFP_portid26_ctl_xgem_dft          0x0000001a

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid26_ctl_xgem_t;


#define XGPN_DSFP_portid27_ctl_xgem              0xd0034198
#define XGPN_DSFP_portid27_ctl_xgem_dft          0x0000001b

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid27_ctl_xgem_t;


#define XGPN_DSFP_portid28_ctl_xgem              0xd003419c
#define XGPN_DSFP_portid28_ctl_xgem_dft          0x0000001c

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid28_ctl_xgem_t;


#define XGPN_DSFP_portid29_ctl_xgem              0xd00341a0
#define XGPN_DSFP_portid29_ctl_xgem_dft          0x0000001d

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid29_ctl_xgem_t;


#define XGPN_DSFP_portid30_ctl_xgem              0xd00341a4
#define XGPN_DSFP_portid30_ctl_xgem_dft          0x0000001e

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid30_ctl_xgem_t;


#define XGPN_DSFP_portid31_ctl_xgem              0xd00341a8
#define XGPN_DSFP_portid31_ctl_xgem_dft          0x0000001f

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid31_ctl_xgem_t;


#define XGPN_DSFP_portid32_ctl_xgem              0xd00341ac
#define XGPN_DSFP_portid32_ctl_xgem_dft          0x00000020

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid32_ctl_xgem_t;


#define XGPN_DSFP_portid33_ctl_xgem              0xd00341b0
#define XGPN_DSFP_portid33_ctl_xgem_dft          0x00000021

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid33_ctl_xgem_t;


#define XGPN_DSFP_portid34_ctl_xgem              0xd00341b4
#define XGPN_DSFP_portid34_ctl_xgem_dft          0x00000022

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid34_ctl_xgem_t;


#define XGPN_DSFP_portid35_ctl_xgem              0xd00341b8
#define XGPN_DSFP_portid35_ctl_xgem_dft          0x00000023

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid35_ctl_xgem_t;


#define XGPN_DSFP_portid36_ctl_xgem              0xd00341bc
#define XGPN_DSFP_portid36_ctl_xgem_dft          0x00000024

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid36_ctl_xgem_t;


#define XGPN_DSFP_portid37_ctl_xgem              0xd00341c0
#define XGPN_DSFP_portid37_ctl_xgem_dft          0x00000025

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid37_ctl_xgem_t;


#define XGPN_DSFP_portid38_ctl_xgem              0xd00341c4
#define XGPN_DSFP_portid38_ctl_xgem_dft          0x00000026

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid38_ctl_xgem_t;


#define XGPN_DSFP_portid39_ctl_xgem              0xd00341c8
#define XGPN_DSFP_portid39_ctl_xgem_dft          0x00000027

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid39_ctl_xgem_t;


#define XGPN_DSFP_portid40_ctl_xgem              0xd00341cc
#define XGPN_DSFP_portid40_ctl_xgem_dft          0x00000028

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid40_ctl_xgem_t;


#define XGPN_DSFP_portid41_ctl_xgem              0xd00341d0
#define XGPN_DSFP_portid41_ctl_xgem_dft          0x00000029

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid41_ctl_xgem_t;


#define XGPN_DSFP_portid42_ctl_xgem              0xd00341d4
#define XGPN_DSFP_portid42_ctl_xgem_dft          0x0000002a

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid42_ctl_xgem_t;


#define XGPN_DSFP_portid43_ctl_xgem              0xd00341d8
#define XGPN_DSFP_portid43_ctl_xgem_dft          0x0000002b

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid43_ctl_xgem_t;


#define XGPN_DSFP_portid44_ctl_xgem              0xd00341dc
#define XGPN_DSFP_portid44_ctl_xgem_dft          0x0000002c

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid44_ctl_xgem_t;


#define XGPN_DSFP_portid45_ctl_xgem              0xd00341e0
#define XGPN_DSFP_portid45_ctl_xgem_dft          0x0000002d

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid45_ctl_xgem_t;


#define XGPN_DSFP_portid46_ctl_xgem              0xd00341e4
#define XGPN_DSFP_portid46_ctl_xgem_dft          0x0000002e

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid46_ctl_xgem_t;


#define XGPN_DSFP_portid47_ctl_xgem              0xd00341e8
#define XGPN_DSFP_portid47_ctl_xgem_dft          0x0000002f

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid47_ctl_xgem_t;


#define XGPN_DSFP_portid48_ctl_xgem              0xd00341ec
#define XGPN_DSFP_portid48_ctl_xgem_dft          0x00000030

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid48_ctl_xgem_t;


#define XGPN_DSFP_portid49_ctl_xgem              0xd00341f0
#define XGPN_DSFP_portid49_ctl_xgem_dft          0x00000031

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid49_ctl_xgem_t;


#define XGPN_DSFP_portid50_ctl_xgem              0xd00341f4
#define XGPN_DSFP_portid50_ctl_xgem_dft          0x00000032

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid50_ctl_xgem_t;


#define XGPN_DSFP_portid51_ctl_xgem              0xd00341f8
#define XGPN_DSFP_portid51_ctl_xgem_dft          0x00000033

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid51_ctl_xgem_t;


#define XGPN_DSFP_portid52_ctl_xgem              0xd00341fc
#define XGPN_DSFP_portid52_ctl_xgem_dft          0x00000034

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid52_ctl_xgem_t;


#define XGPN_DSFP_portid53_ctl_xgem              0xd0034200
#define XGPN_DSFP_portid53_ctl_xgem_dft          0x00000035

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid53_ctl_xgem_t;


#define XGPN_DSFP_portid54_ctl_xgem              0xd0034204
#define XGPN_DSFP_portid54_ctl_xgem_dft          0x00000036

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid54_ctl_xgem_t;


#define XGPN_DSFP_portid55_ctl_xgem              0xd0034208
#define XGPN_DSFP_portid55_ctl_xgem_dft          0x00000037

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid55_ctl_xgem_t;


#define XGPN_DSFP_portid56_ctl_xgem              0xd003420c
#define XGPN_DSFP_portid56_ctl_xgem_dft          0x00000038

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid56_ctl_xgem_t;


#define XGPN_DSFP_portid57_ctl_xgem              0xd0034210
#define XGPN_DSFP_portid57_ctl_xgem_dft          0x00000039

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid57_ctl_xgem_t;


#define XGPN_DSFP_portid58_ctl_xgem              0xd0034214
#define XGPN_DSFP_portid58_ctl_xgem_dft          0x0000003a

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid58_ctl_xgem_t;


#define XGPN_DSFP_portid59_ctl_xgem              0xd0034218
#define XGPN_DSFP_portid59_ctl_xgem_dft          0x0000003b

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid59_ctl_xgem_t;


#define XGPN_DSFP_portid60_ctl_xgem              0xd003421c
#define XGPN_DSFP_portid60_ctl_xgem_dft          0x0000003c

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid60_ctl_xgem_t;


#define XGPN_DSFP_portid61_ctl_xgem              0xd0034220
#define XGPN_DSFP_portid61_ctl_xgem_dft          0x0000003d

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid61_ctl_xgem_t;


#define XGPN_DSFP_portid62_ctl_xgem              0xd0034224
#define XGPN_DSFP_portid62_ctl_xgem_dft          0x0000003e

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid62_ctl_xgem_t;


#define XGPN_DSFP_portid63_ctl_xgem              0xd0034228
#define XGPN_DSFP_portid63_ctl_xgem_dft          0x0000003f

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid63_ctl_xgem_t;


#define XGPN_DSFP_portid64_ctl_xgem              0xd003422c
#define XGPN_DSFP_portid64_ctl_xgem_dft          0x00000040

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid64_ctl_xgem_t;


#define XGPN_DSFP_portid65_ctl_xgem              0xd0034230
#define XGPN_DSFP_portid65_ctl_xgem_dft          0x00000041

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid65_ctl_xgem_t;


#define XGPN_DSFP_portid66_ctl_xgem              0xd0034234
#define XGPN_DSFP_portid66_ctl_xgem_dft          0x00000042

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid66_ctl_xgem_t;


#define XGPN_DSFP_portid67_ctl_xgem              0xd0034238
#define XGPN_DSFP_portid67_ctl_xgem_dft          0x00000043

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid67_ctl_xgem_t;


#define XGPN_DSFP_portid68_ctl_xgem              0xd003423c
#define XGPN_DSFP_portid68_ctl_xgem_dft          0x00000044

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid68_ctl_xgem_t;


#define XGPN_DSFP_portid69_ctl_xgem              0xd0034240
#define XGPN_DSFP_portid69_ctl_xgem_dft          0x00000045

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid69_ctl_xgem_t;


#define XGPN_DSFP_portid70_ctl_xgem              0xd0034244
#define XGPN_DSFP_portid70_ctl_xgem_dft          0x00000046

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid70_ctl_xgem_t;


#define XGPN_DSFP_portid71_ctl_xgem              0xd0034248
#define XGPN_DSFP_portid71_ctl_xgem_dft          0x00000047

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid71_ctl_xgem_t;


#define XGPN_DSFP_portid72_ctl_xgem              0xd003424c
#define XGPN_DSFP_portid72_ctl_xgem_dft          0x00000048

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid72_ctl_xgem_t;


#define XGPN_DSFP_portid73_ctl_xgem              0xd0034250
#define XGPN_DSFP_portid73_ctl_xgem_dft          0x00000049

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid73_ctl_xgem_t;


#define XGPN_DSFP_portid74_ctl_xgem              0xd0034254
#define XGPN_DSFP_portid74_ctl_xgem_dft          0x0000004a

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid74_ctl_xgem_t;


#define XGPN_DSFP_portid75_ctl_xgem              0xd0034258
#define XGPN_DSFP_portid75_ctl_xgem_dft          0x0000004b

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid75_ctl_xgem_t;


#define XGPN_DSFP_portid76_ctl_xgem              0xd003425c
#define XGPN_DSFP_portid76_ctl_xgem_dft          0x0000004c

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid76_ctl_xgem_t;


#define XGPN_DSFP_portid77_ctl_xgem              0xd0034260
#define XGPN_DSFP_portid77_ctl_xgem_dft          0x0000004d

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid77_ctl_xgem_t;


#define XGPN_DSFP_portid78_ctl_xgem              0xd0034264
#define XGPN_DSFP_portid78_ctl_xgem_dft          0x0000004e

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid78_ctl_xgem_t;


#define XGPN_DSFP_portid79_ctl_xgem              0xd0034268
#define XGPN_DSFP_portid79_ctl_xgem_dft          0x0000004f

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid79_ctl_xgem_t;


#define XGPN_DSFP_portid80_ctl_xgem              0xd003426c
#define XGPN_DSFP_portid80_ctl_xgem_dft          0x00000050

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid80_ctl_xgem_t;


#define XGPN_DSFP_portid81_ctl_xgem              0xd0034270
#define XGPN_DSFP_portid81_ctl_xgem_dft          0x00000051

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid81_ctl_xgem_t;


#define XGPN_DSFP_portid82_ctl_xgem              0xd0034274
#define XGPN_DSFP_portid82_ctl_xgem_dft          0x00000052

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid82_ctl_xgem_t;


#define XGPN_DSFP_portid83_ctl_xgem              0xd0034278
#define XGPN_DSFP_portid83_ctl_xgem_dft          0x00000053

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid83_ctl_xgem_t;


#define XGPN_DSFP_portid84_ctl_xgem              0xd003427c
#define XGPN_DSFP_portid84_ctl_xgem_dft          0x00000054

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid84_ctl_xgem_t;


#define XGPN_DSFP_portid85_ctl_xgem              0xd0034280
#define XGPN_DSFP_portid85_ctl_xgem_dft          0x00000055

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid85_ctl_xgem_t;


#define XGPN_DSFP_portid86_ctl_xgem              0xd0034284
#define XGPN_DSFP_portid86_ctl_xgem_dft          0x00000056

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid86_ctl_xgem_t;


#define XGPN_DSFP_portid87_ctl_xgem              0xd0034288
#define XGPN_DSFP_portid87_ctl_xgem_dft          0x00000057

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid87_ctl_xgem_t;


#define XGPN_DSFP_portid88_ctl_xgem              0xd003428c
#define XGPN_DSFP_portid88_ctl_xgem_dft          0x00000058

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid88_ctl_xgem_t;


#define XGPN_DSFP_portid89_ctl_xgem              0xd0034290
#define XGPN_DSFP_portid89_ctl_xgem_dft          0x00000059

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid89_ctl_xgem_t;


#define XGPN_DSFP_portid90_ctl_xgem              0xd0034294
#define XGPN_DSFP_portid90_ctl_xgem_dft          0x0000005a

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid90_ctl_xgem_t;


#define XGPN_DSFP_portid91_ctl_xgem              0xd0034298
#define XGPN_DSFP_portid91_ctl_xgem_dft          0x0000005b

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid91_ctl_xgem_t;


#define XGPN_DSFP_portid92_ctl_xgem              0xd003429c
#define XGPN_DSFP_portid92_ctl_xgem_dft          0x0000005c

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid92_ctl_xgem_t;


#define XGPN_DSFP_portid93_ctl_xgem              0xd00342a0
#define XGPN_DSFP_portid93_ctl_xgem_dft          0x0000005d

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid93_ctl_xgem_t;


#define XGPN_DSFP_portid94_ctl_xgem              0xd00342a4
#define XGPN_DSFP_portid94_ctl_xgem_dft          0x0000005e

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid94_ctl_xgem_t;


#define XGPN_DSFP_portid95_ctl_xgem              0xd00342a8
#define XGPN_DSFP_portid95_ctl_xgem_dft          0x0000005f

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid95_ctl_xgem_t;


#define XGPN_DSFP_portid96_ctl_xgem              0xd00342ac
#define XGPN_DSFP_portid96_ctl_xgem_dft          0x00000060

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid96_ctl_xgem_t;


#define XGPN_DSFP_portid97_ctl_xgem              0xd00342b0
#define XGPN_DSFP_portid97_ctl_xgem_dft          0x00000061

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid97_ctl_xgem_t;


#define XGPN_DSFP_portid98_ctl_xgem              0xd00342b4
#define XGPN_DSFP_portid98_ctl_xgem_dft          0x00000062

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid98_ctl_xgem_t;


#define XGPN_DSFP_portid99_ctl_xgem              0xd00342b8
#define XGPN_DSFP_portid99_ctl_xgem_dft          0x00000063

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid99_ctl_xgem_t;


#define XGPN_DSFP_portid100_ctl_xgem             0xd00342bc
#define XGPN_DSFP_portid100_ctl_xgem_dft         0x00000064

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid100_ctl_xgem_t;


#define XGPN_DSFP_portid101_ctl_xgem             0xd00342c0
#define XGPN_DSFP_portid101_ctl_xgem_dft         0x00000065

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid101_ctl_xgem_t;


#define XGPN_DSFP_portid102_ctl_xgem             0xd00342c4
#define XGPN_DSFP_portid102_ctl_xgem_dft         0x00000066

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid102_ctl_xgem_t;


#define XGPN_DSFP_portid103_ctl_xgem             0xd00342c8
#define XGPN_DSFP_portid103_ctl_xgem_dft         0x00000067

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid103_ctl_xgem_t;


#define XGPN_DSFP_portid104_ctl_xgem             0xd00342cc
#define XGPN_DSFP_portid104_ctl_xgem_dft         0x00000068

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid104_ctl_xgem_t;


#define XGPN_DSFP_portid105_ctl_xgem             0xd00342d0
#define XGPN_DSFP_portid105_ctl_xgem_dft         0x00000069

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid105_ctl_xgem_t;


#define XGPN_DSFP_portid106_ctl_xgem             0xd00342d4
#define XGPN_DSFP_portid106_ctl_xgem_dft         0x0000006a

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid106_ctl_xgem_t;


#define XGPN_DSFP_portid107_ctl_xgem             0xd00342d8
#define XGPN_DSFP_portid107_ctl_xgem_dft         0x0000006b

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid107_ctl_xgem_t;


#define XGPN_DSFP_portid108_ctl_xgem             0xd00342dc
#define XGPN_DSFP_portid108_ctl_xgem_dft         0x0000006c

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid108_ctl_xgem_t;


#define XGPN_DSFP_portid109_ctl_xgem             0xd00342e0
#define XGPN_DSFP_portid109_ctl_xgem_dft         0x0000006d

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid109_ctl_xgem_t;


#define XGPN_DSFP_portid110_ctl_xgem             0xd00342e4
#define XGPN_DSFP_portid110_ctl_xgem_dft         0x0000006e

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid110_ctl_xgem_t;


#define XGPN_DSFP_portid111_ctl_xgem             0xd00342e8
#define XGPN_DSFP_portid111_ctl_xgem_dft         0x0000006f

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid111_ctl_xgem_t;


#define XGPN_DSFP_portid112_ctl_xgem             0xd00342ec
#define XGPN_DSFP_portid112_ctl_xgem_dft         0x00000070

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid112_ctl_xgem_t;


#define XGPN_DSFP_portid113_ctl_xgem             0xd00342f0
#define XGPN_DSFP_portid113_ctl_xgem_dft         0x00000071

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid113_ctl_xgem_t;


#define XGPN_DSFP_portid114_ctl_xgem             0xd00342f4
#define XGPN_DSFP_portid114_ctl_xgem_dft         0x00000072

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid114_ctl_xgem_t;


#define XGPN_DSFP_portid115_ctl_xgem             0xd00342f8
#define XGPN_DSFP_portid115_ctl_xgem_dft         0x00000073

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid115_ctl_xgem_t;


#define XGPN_DSFP_portid116_ctl_xgem             0xd00342fc
#define XGPN_DSFP_portid116_ctl_xgem_dft         0x00000074

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid116_ctl_xgem_t;


#define XGPN_DSFP_portid117_ctl_xgem             0xd0034300
#define XGPN_DSFP_portid117_ctl_xgem_dft         0x00000075

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid117_ctl_xgem_t;


#define XGPN_DSFP_portid118_ctl_xgem             0xd0034304
#define XGPN_DSFP_portid118_ctl_xgem_dft         0x00000076

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid118_ctl_xgem_t;


#define XGPN_DSFP_portid119_ctl_xgem             0xd0034308
#define XGPN_DSFP_portid119_ctl_xgem_dft         0x00000077

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid119_ctl_xgem_t;


#define XGPN_DSFP_portid120_ctl_xgem             0xd003430c
#define XGPN_DSFP_portid120_ctl_xgem_dft         0x00000078

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid120_ctl_xgem_t;


#define XGPN_DSFP_portid121_ctl_xgem             0xd0034310
#define XGPN_DSFP_portid121_ctl_xgem_dft         0x00000079

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid121_ctl_xgem_t;


#define XGPN_DSFP_portid122_ctl_xgem             0xd0034314
#define XGPN_DSFP_portid122_ctl_xgem_dft         0x0000007a

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid122_ctl_xgem_t;


#define XGPN_DSFP_portid123_ctl_xgem             0xd0034318
#define XGPN_DSFP_portid123_ctl_xgem_dft         0x0000007b

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid123_ctl_xgem_t;


#define XGPN_DSFP_portid124_ctl_xgem             0xd003431c
#define XGPN_DSFP_portid124_ctl_xgem_dft         0x0000007c

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid124_ctl_xgem_t;


#define XGPN_DSFP_portid125_ctl_xgem             0xd0034320
#define XGPN_DSFP_portid125_ctl_xgem_dft         0x0000007d

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid125_ctl_xgem_t;


#define XGPN_DSFP_portid126_ctl_xgem             0xd0034324
#define XGPN_DSFP_portid126_ctl_xgem_dft         0x0000007e

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid126_ctl_xgem_t;


#define XGPN_DSFP_portid127_ctl_xgem             0xd0034328
#define XGPN_DSFP_portid127_ctl_xgem_dft         0x0000007f

typedef volatile union {
  struct {
    ca_uint32_t portid               : 16 ; /* bits 15:0 */
    ca_uint32_t portid_mc            :  1 ; /* bits 16:16 */
    ca_uint32_t portid_vld           :  1 ; /* bits 17:17 */
    ca_uint32_t rsrvd1               : 14 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_portid127_ctl_xgem_t;


#define XGPN_DSFP_ds_sync                        0xd003432c
#define XGPN_DSFP_ds_sync_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t state                :  3 ; /* bits 2:0 */
    ca_uint32_t rsrvd1               : 29 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_ds_sync_t;


#define XGPN_DSFP_superframe1                    0xd0034330
#define XGPN_DSFP_superframe1_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt1                 : 19 ; /* bits 18:0 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_superframe1_t;


#define XGPN_DSFP_superframe0                    0xd0034334
#define XGPN_DSFP_superframe0_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_superframe0_t;


#define XGPN_DSFP_OC_body1                       0xd0034338
#define XGPN_DSFP_OC_body1_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t TOL1                 :  9 ; /* bits 8:0 */
    ca_uint32_t C_flag1              :  1 ; /* bits 9:9 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t link_type1           :  2 ; /* bits 12:11 */
    ca_uint32_t P_flag1              :  1 ; /* bits 13:13 */
    ca_uint32_t DS_FEC_flag1         :  1 ; /* bits 14:14 */
    ca_uint32_t ODN_class1           :  3 ; /* bits 17:15 */
    ca_uint32_t RE_flag1             :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd2               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_OC_body1_t;


#define XGPN_DSFP_OC_body0                       0xd003433c
#define XGPN_DSFP_OC_body0_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pon_id0              : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_OC_body0_t;


#define XGPN_DSFP_bip_32_dw1                     0xd0034340
#define XGPN_DSFP_bip_32_dw1_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt1                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_bip_32_dw1_t;


#define XGPN_DSFP_bip_32_dw0                     0xd0034344
#define XGPN_DSFP_bip_32_dw0_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt0                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_bip_32_dw0_t;


#define XGPN_DSFP_bip_32_err                     0xd0034348
#define XGPN_DSFP_bip_32_err_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_bip_32_err_t;


#define XGPN_DSFP_psbd_hec_err                   0xd003434c
#define XGPN_DSFP_psbd_hec_err_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_psbd_hec_err_t;


#define XGPN_DSFP_sfc_hec_corrected              0xd0034350
#define XGPN_DSFP_sfc_hec_corrected_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_sfc_hec_corrected_t;


#define XGPN_DSFP_sfc_hec_uncorrected_mib        0xd0034354
#define XGPN_DSFP_sfc_hec_uncorrected_mib_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_sfc_hec_uncorrected_mib_t;


#define XGPN_DSFP_ponid_hec_corrected            0xd0034358
#define XGPN_DSFP_ponid_hec_corrected_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_ponid_hec_corrected_t;


#define XGPN_DSFP_ponid_hec_uncorrected_mib      0xd003435c
#define XGPN_DSFP_ponid_hec_uncorrected_mib_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_ponid_hec_uncorrected_mib_t;


#define XGPN_DSFP_psbd_hec_uncorrected_mib       0xd0034360
#define XGPN_DSFP_psbd_hec_uncorrected_mib_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_psbd_hec_uncorrected_mib_t;


#define XGPN_DSFP_bwmap_hec_corrected            0xd0034364
#define XGPN_DSFP_bwmap_hec_corrected_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_bwmap_hec_corrected_t;


#define XGPN_DSFP_bwmap_hec_uncorrected_mib      0xd0034368
#define XGPN_DSFP_bwmap_hec_uncorrected_mib_dft  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_bwmap_hec_uncorrected_mib_t;


#define XGPN_DSFP_xgtc_err                       0xd003436c
#define XGPN_DSFP_xgtc_err_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hd                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_xgtc_err_t;


#define XGPN_DSFP_xgtc_frame                     0xd0034370
#define XGPN_DSFP_xgtc_frame_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_xgtc_frame_t;


#define XGPN_DSFP_xgtc_hec_corrected             0xd0034374
#define XGPN_DSFP_xgtc_hec_corrected_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_xgtc_hec_corrected_t;


#define XGPN_DSFP_xgtc_hec_uncorrected_mib       0xd0034378
#define XGPN_DSFP_xgtc_hec_uncorrected_mib_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_xgtc_hec_uncorrected_mib_t;


#define XGPN_DSFP_xgem_err0                      0xd003437c
#define XGPN_DSFP_xgem_err0_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hd                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_xgem_err0_t;


#define XGPN_DSFP_xgem_err1                      0xd0034380
#define XGPN_DSFP_xgem_err1_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t hd                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_xgem_err1_t;


#define XGPN_DSFP_xgem_frame                     0xd0034384
#define XGPN_DSFP_xgem_frame_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_xgem_frame_t;


#define XGPN_DSFP_xgem_hec_corrected             0xd0034388
#define XGPN_DSFP_xgem_hec_corrected_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_xgem_hec_corrected_t;


#define XGPN_DSFP_xgem_hec_uncorrected_mib       0xd003438c
#define XGPN_DSFP_xgem_hec_uncorrected_mib_dft   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_xgem_hec_uncorrected_mib_t;


#define XGPN_DSFP_xgem_nolf_mib                  0xd0034390
#define XGPN_DSFP_xgem_nolf_mib_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_xgem_nolf_mib_t;


#define XGPN_DSFP_xgem_los_word_mib              0xd0034394
#define XGPN_DSFP_xgem_los_word_mib_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_xgem_los_word_mib_t;


#define XGPN_DSFP_xgem_err_key_mib               0xd0034398
#define XGPN_DSFP_xgem_err_key_mib_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_xgem_err_key_mib_t;


#define XGPN_DSFP_rxmac_xgem_frame               0xd003439c
#define XGPN_DSFP_rxmac_xgem_frame_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_rxmac_xgem_frame_t;


#define XGPN_DSFP_rxmac_omci_frame               0xd00343a0
#define XGPN_DSFP_rxmac_omci_frame_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_rxmac_omci_frame_t;


#define XGPN_DSFP_rxmac_pkt_frame                0xd00343a4
#define XGPN_DSFP_rxmac_pkt_frame_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_rxmac_pkt_frame_t;


#define XGPN_DSFP_rxmac_pkt_crc_err              0xd00343a8
#define XGPN_DSFP_rxmac_pkt_crc_err_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_rxmac_pkt_crc_err_t;


#define XGPN_DSFP_rxmac_xgem_frame_status        0xd00343ac
#define XGPN_DSFP_rxmac_xgem_frame_status_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t fg_xgem_err          :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_rxmac_xgem_frame_status_t;


#define XGPN_DSFP_async_ff_status                0xd00343b0
#define XGPN_DSFP_async_ff_status_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t overflow             :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_async_ff_status_t;


#define XGPN_DSFP_MIB_RAM_STATUS_REG             0xd00343b4
#define XGPN_DSFP_MIB_RAM_STATUS_REG_dft         0x00000001

typedef volatile union {
  struct {
    ca_uint32_t ram_initdone         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_MIB_RAM_STATUS_REG_t;


#define XGPN_DSFP_PORTID_XGEM_MIB_ACCESS         0xd00343b8
#define XGPN_DSFP_PORTID_XGEM_MIB_ACCESS_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rw                   :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_PORTID_XGEM_MIB_ACCESS_t;


#define XGPN_DSFP_PORTID_XGEM_MIB_DATA2          0xd00343bc
#define XGPN_DSFP_PORTID_XGEM_MIB_DATA2_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t byte_cnt             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_PORTID_XGEM_MIB_DATA2_t;


#define XGPN_DSFP_PORTID_XGEM_MIB_DATA1          0xd00343c0
#define XGPN_DSFP_PORTID_XGEM_MIB_DATA1_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t byte_cnt             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_PORTID_XGEM_MIB_DATA1_t;


#define XGPN_DSFP_PORTID_XGEM_MIB_DATA0          0xd00343c4
#define XGPN_DSFP_PORTID_XGEM_MIB_DATA0_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t frame_cnt            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_DSFP_PORTID_XGEM_MIB_DATA0_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* dsfp */
typedef struct {
  XGPN_DSFP_hec_ctl_t                      hec_ctl;                       /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  XGPN_DSFP_sync_ctl_t                     sync_ctl;                      /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  XGPN_DSFP_xgtc_ctl_t                     xgtc_ctl;                      /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  XGPN_DSFP_xgem_ctl_t                     xgem_ctl;                      /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  XGPN_DSFP_rxmac_ctl_t                    rxmac_ctl;                     /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  XGPN_DSFP_rxmac_ctl1_t                   rxmac_ctl1;                    /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  XGPN_DSFP_INTERRUPT_t                    INTERRUPT;                     /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  XGPN_DSFP_INTERRUPTE0_t                  INTERRUPTE0;                   /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  XGPN_DSFP_INTERRUPTE1_t                  INTERRUPTE1;                   /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  XGPN_DSFP_xgem_key_ctl_t                 xgem_key_ctl;                  /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  XGPN_DSFP_xgem_mc_key_ctl_t              xgem_mc_key_ctl;               /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  XGPN_DSFP_portid0_ctl_xgem_t             portid0_ctl_xgem;              /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  XGPN_DSFP_portid1_ctl_xgem_t             portid1_ctl_xgem;              /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  XGPN_DSFP_portid2_ctl_xgem_t             portid2_ctl_xgem;              /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  XGPN_DSFP_portid3_ctl_xgem_t             portid3_ctl_xgem;              /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  XGPN_DSFP_portid4_ctl_xgem_t             portid4_ctl_xgem;              /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  XGPN_DSFP_portid5_ctl_xgem_t             portid5_ctl_xgem;              /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  XGPN_DSFP_portid6_ctl_xgem_t             portid6_ctl_xgem;              /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  XGPN_DSFP_portid7_ctl_xgem_t             portid7_ctl_xgem;              /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  XGPN_DSFP_portid8_ctl_xgem_t             portid8_ctl_xgem;              /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  XGPN_DSFP_portid9_ctl_xgem_t             portid9_ctl_xgem;              /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  XGPN_DSFP_portid10_ctl_xgem_t            portid10_ctl_xgem;             /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  XGPN_DSFP_portid11_ctl_xgem_t            portid11_ctl_xgem;             /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  XGPN_DSFP_portid12_ctl_xgem_t            portid12_ctl_xgem;             /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  XGPN_DSFP_portid13_ctl_xgem_t            portid13_ctl_xgem;             /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  XGPN_DSFP_portid14_ctl_xgem_t            portid14_ctl_xgem;             /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  XGPN_DSFP_portid15_ctl_xgem_t            portid15_ctl_xgem;             /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  XGPN_DSFP_portid16_ctl_xgem_t            portid16_ctl_xgem;             /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  XGPN_DSFP_portid17_ctl_xgem_t            portid17_ctl_xgem;             /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  XGPN_DSFP_portid18_ctl_xgem_t            portid18_ctl_xgem;             /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  XGPN_DSFP_portid19_ctl_xgem_t            portid19_ctl_xgem;             /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  XGPN_DSFP_portid20_ctl_xgem_t            portid20_ctl_xgem;             /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  XGPN_DSFP_portid21_ctl_xgem_t            portid21_ctl_xgem;             /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  XGPN_DSFP_portid22_ctl_xgem_t            portid22_ctl_xgem;             /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  XGPN_DSFP_portid23_ctl_xgem_t            portid23_ctl_xgem;             /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  XGPN_DSFP_portid24_ctl_xgem_t            portid24_ctl_xgem;             /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  XGPN_DSFP_portid25_ctl_xgem_t            portid25_ctl_xgem;             /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  XGPN_DSFP_portid26_ctl_xgem_t            portid26_ctl_xgem;             /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  XGPN_DSFP_portid27_ctl_xgem_t            portid27_ctl_xgem;             /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];                   
  XGPN_DSFP_portid28_ctl_xgem_t            portid28_ctl_xgem;             /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];                   
  XGPN_DSFP_portid29_ctl_xgem_t            portid29_ctl_xgem;             /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];                   
  XGPN_DSFP_portid30_ctl_xgem_t            portid30_ctl_xgem;             /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];                   
  XGPN_DSFP_portid31_ctl_xgem_t            portid31_ctl_xgem;             /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];                   
  XGPN_DSFP_portid32_ctl_xgem_t            portid32_ctl_xgem;             /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd44[3];                   
  XGPN_DSFP_portid33_ctl_xgem_t            portid33_ctl_xgem;             /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd45[3];                   
  XGPN_DSFP_portid34_ctl_xgem_t            portid34_ctl_xgem;             /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd46[3];                   
  XGPN_DSFP_portid35_ctl_xgem_t            portid35_ctl_xgem;             /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd47[3];                   
  XGPN_DSFP_portid36_ctl_xgem_t            portid36_ctl_xgem;             /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd48[3];                   
  XGPN_DSFP_portid37_ctl_xgem_t            portid37_ctl_xgem;             /* addr: 0x000000c0 */
  ca_uint32_t                              rsrvd49[3];                   
  XGPN_DSFP_portid38_ctl_xgem_t            portid38_ctl_xgem;             /* addr: 0x000000c4 */
  ca_uint32_t                              rsrvd50[3];                   
  XGPN_DSFP_portid39_ctl_xgem_t            portid39_ctl_xgem;             /* addr: 0x000000c8 */
  ca_uint32_t                              rsrvd51[3];                   
  XGPN_DSFP_portid40_ctl_xgem_t            portid40_ctl_xgem;             /* addr: 0x000000cc */
  ca_uint32_t                              rsrvd52[3];                   
  XGPN_DSFP_portid41_ctl_xgem_t            portid41_ctl_xgem;             /* addr: 0x000000d0 */
  ca_uint32_t                              rsrvd53[3];                   
  XGPN_DSFP_portid42_ctl_xgem_t            portid42_ctl_xgem;             /* addr: 0x000000d4 */
  ca_uint32_t                              rsrvd54[3];                   
  XGPN_DSFP_portid43_ctl_xgem_t            portid43_ctl_xgem;             /* addr: 0x000000d8 */
  ca_uint32_t                              rsrvd55[3];                   
  XGPN_DSFP_portid44_ctl_xgem_t            portid44_ctl_xgem;             /* addr: 0x000000dc */
  ca_uint32_t                              rsrvd56[3];                   
  XGPN_DSFP_portid45_ctl_xgem_t            portid45_ctl_xgem;             /* addr: 0x000000e0 */
  ca_uint32_t                              rsrvd57[3];                   
  XGPN_DSFP_portid46_ctl_xgem_t            portid46_ctl_xgem;             /* addr: 0x000000e4 */
  ca_uint32_t                              rsrvd58[3];                   
  XGPN_DSFP_portid47_ctl_xgem_t            portid47_ctl_xgem;             /* addr: 0x000000e8 */
  ca_uint32_t                              rsrvd59[3];                   
  XGPN_DSFP_portid48_ctl_xgem_t            portid48_ctl_xgem;             /* addr: 0x000000ec */
  ca_uint32_t                              rsrvd60[3];                   
  XGPN_DSFP_portid49_ctl_xgem_t            portid49_ctl_xgem;             /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd61[3];                   
  XGPN_DSFP_portid50_ctl_xgem_t            portid50_ctl_xgem;             /* addr: 0x000000f4 */
  ca_uint32_t                              rsrvd62[3];                   
  XGPN_DSFP_portid51_ctl_xgem_t            portid51_ctl_xgem;             /* addr: 0x000000f8 */
  ca_uint32_t                              rsrvd63[3];                   
  XGPN_DSFP_portid52_ctl_xgem_t            portid52_ctl_xgem;             /* addr: 0x000000fc */
  ca_uint32_t                              rsrvd64[3];                   
  XGPN_DSFP_portid53_ctl_xgem_t            portid53_ctl_xgem;             /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd65[3];                   
  XGPN_DSFP_portid54_ctl_xgem_t            portid54_ctl_xgem;             /* addr: 0x00000104 */
  ca_uint32_t                              rsrvd66[3];                   
  XGPN_DSFP_portid55_ctl_xgem_t            portid55_ctl_xgem;             /* addr: 0x00000108 */
  ca_uint32_t                              rsrvd67[3];                   
  XGPN_DSFP_portid56_ctl_xgem_t            portid56_ctl_xgem;             /* addr: 0x0000010c */
  ca_uint32_t                              rsrvd68[3];                   
  XGPN_DSFP_portid57_ctl_xgem_t            portid57_ctl_xgem;             /* addr: 0x00000110 */
  ca_uint32_t                              rsrvd69[3];                   
  XGPN_DSFP_portid58_ctl_xgem_t            portid58_ctl_xgem;             /* addr: 0x00000114 */
  ca_uint32_t                              rsrvd70[3];                   
  XGPN_DSFP_portid59_ctl_xgem_t            portid59_ctl_xgem;             /* addr: 0x00000118 */
  ca_uint32_t                              rsrvd71[3];                   
  XGPN_DSFP_portid60_ctl_xgem_t            portid60_ctl_xgem;             /* addr: 0x0000011c */
  ca_uint32_t                              rsrvd72[3];                   
  XGPN_DSFP_portid61_ctl_xgem_t            portid61_ctl_xgem;             /* addr: 0x00000120 */
  ca_uint32_t                              rsrvd73[3];                   
  XGPN_DSFP_portid62_ctl_xgem_t            portid62_ctl_xgem;             /* addr: 0x00000124 */
  ca_uint32_t                              rsrvd74[3];                   
  XGPN_DSFP_portid63_ctl_xgem_t            portid63_ctl_xgem;             /* addr: 0x00000128 */
  ca_uint32_t                              rsrvd75[3];                   
  XGPN_DSFP_portid64_ctl_xgem_t            portid64_ctl_xgem;             /* addr: 0x0000012c */
  ca_uint32_t                              rsrvd76[3];                   
  XGPN_DSFP_portid65_ctl_xgem_t            portid65_ctl_xgem;             /* addr: 0x00000130 */
  ca_uint32_t                              rsrvd77[3];                   
  XGPN_DSFP_portid66_ctl_xgem_t            portid66_ctl_xgem;             /* addr: 0x00000134 */
  ca_uint32_t                              rsrvd78[3];                   
  XGPN_DSFP_portid67_ctl_xgem_t            portid67_ctl_xgem;             /* addr: 0x00000138 */
  ca_uint32_t                              rsrvd79[3];                   
  XGPN_DSFP_portid68_ctl_xgem_t            portid68_ctl_xgem;             /* addr: 0x0000013c */
  ca_uint32_t                              rsrvd80[3];                   
  XGPN_DSFP_portid69_ctl_xgem_t            portid69_ctl_xgem;             /* addr: 0x00000140 */
  ca_uint32_t                              rsrvd81[3];                   
  XGPN_DSFP_portid70_ctl_xgem_t            portid70_ctl_xgem;             /* addr: 0x00000144 */
  ca_uint32_t                              rsrvd82[3];                   
  XGPN_DSFP_portid71_ctl_xgem_t            portid71_ctl_xgem;             /* addr: 0x00000148 */
  ca_uint32_t                              rsrvd83[3];                   
  XGPN_DSFP_portid72_ctl_xgem_t            portid72_ctl_xgem;             /* addr: 0x0000014c */
  ca_uint32_t                              rsrvd84[3];                   
  XGPN_DSFP_portid73_ctl_xgem_t            portid73_ctl_xgem;             /* addr: 0x00000150 */
  ca_uint32_t                              rsrvd85[3];                   
  XGPN_DSFP_portid74_ctl_xgem_t            portid74_ctl_xgem;             /* addr: 0x00000154 */
  ca_uint32_t                              rsrvd86[3];                   
  XGPN_DSFP_portid75_ctl_xgem_t            portid75_ctl_xgem;             /* addr: 0x00000158 */
  ca_uint32_t                              rsrvd87[3];                   
  XGPN_DSFP_portid76_ctl_xgem_t            portid76_ctl_xgem;             /* addr: 0x0000015c */
  ca_uint32_t                              rsrvd88[3];                   
  XGPN_DSFP_portid77_ctl_xgem_t            portid77_ctl_xgem;             /* addr: 0x00000160 */
  ca_uint32_t                              rsrvd89[3];                   
  XGPN_DSFP_portid78_ctl_xgem_t            portid78_ctl_xgem;             /* addr: 0x00000164 */
  ca_uint32_t                              rsrvd90[3];                   
  XGPN_DSFP_portid79_ctl_xgem_t            portid79_ctl_xgem;             /* addr: 0x00000168 */
  ca_uint32_t                              rsrvd91[3];                   
  XGPN_DSFP_portid80_ctl_xgem_t            portid80_ctl_xgem;             /* addr: 0x0000016c */
  ca_uint32_t                              rsrvd92[3];                   
  XGPN_DSFP_portid81_ctl_xgem_t            portid81_ctl_xgem;             /* addr: 0x00000170 */
  ca_uint32_t                              rsrvd93[3];                   
  XGPN_DSFP_portid82_ctl_xgem_t            portid82_ctl_xgem;             /* addr: 0x00000174 */
  ca_uint32_t                              rsrvd94[3];                   
  XGPN_DSFP_portid83_ctl_xgem_t            portid83_ctl_xgem;             /* addr: 0x00000178 */
  ca_uint32_t                              rsrvd95[3];                   
  XGPN_DSFP_portid84_ctl_xgem_t            portid84_ctl_xgem;             /* addr: 0x0000017c */
  ca_uint32_t                              rsrvd96[3];                   
  XGPN_DSFP_portid85_ctl_xgem_t            portid85_ctl_xgem;             /* addr: 0x00000180 */
  ca_uint32_t                              rsrvd97[3];                   
  XGPN_DSFP_portid86_ctl_xgem_t            portid86_ctl_xgem;             /* addr: 0x00000184 */
  ca_uint32_t                              rsrvd98[3];                   
  XGPN_DSFP_portid87_ctl_xgem_t            portid87_ctl_xgem;             /* addr: 0x00000188 */
  ca_uint32_t                              rsrvd99[3];                   
  XGPN_DSFP_portid88_ctl_xgem_t            portid88_ctl_xgem;             /* addr: 0x0000018c */
  ca_uint32_t                              rsrvd100[3];                  
  XGPN_DSFP_portid89_ctl_xgem_t            portid89_ctl_xgem;             /* addr: 0x00000190 */
  ca_uint32_t                              rsrvd101[3];                  
  XGPN_DSFP_portid90_ctl_xgem_t            portid90_ctl_xgem;             /* addr: 0x00000194 */
  ca_uint32_t                              rsrvd102[3];                  
  XGPN_DSFP_portid91_ctl_xgem_t            portid91_ctl_xgem;             /* addr: 0x00000198 */
  ca_uint32_t                              rsrvd103[3];                  
  XGPN_DSFP_portid92_ctl_xgem_t            portid92_ctl_xgem;             /* addr: 0x0000019c */
  ca_uint32_t                              rsrvd104[3];                  
  XGPN_DSFP_portid93_ctl_xgem_t            portid93_ctl_xgem;             /* addr: 0x000001a0 */
  ca_uint32_t                              rsrvd105[3];                  
  XGPN_DSFP_portid94_ctl_xgem_t            portid94_ctl_xgem;             /* addr: 0x000001a4 */
  ca_uint32_t                              rsrvd106[3];                  
  XGPN_DSFP_portid95_ctl_xgem_t            portid95_ctl_xgem;             /* addr: 0x000001a8 */
  ca_uint32_t                              rsrvd107[3];                  
  XGPN_DSFP_portid96_ctl_xgem_t            portid96_ctl_xgem;             /* addr: 0x000001ac */
  ca_uint32_t                              rsrvd108[3];                  
  XGPN_DSFP_portid97_ctl_xgem_t            portid97_ctl_xgem;             /* addr: 0x000001b0 */
  ca_uint32_t                              rsrvd109[3];                  
  XGPN_DSFP_portid98_ctl_xgem_t            portid98_ctl_xgem;             /* addr: 0x000001b4 */
  ca_uint32_t                              rsrvd110[3];                  
  XGPN_DSFP_portid99_ctl_xgem_t            portid99_ctl_xgem;             /* addr: 0x000001b8 */
  ca_uint32_t                              rsrvd111[3];                  
  XGPN_DSFP_portid100_ctl_xgem_t           portid100_ctl_xgem;            /* addr: 0x000001bc */
  ca_uint32_t                              rsrvd112[3];                  
  XGPN_DSFP_portid101_ctl_xgem_t           portid101_ctl_xgem;            /* addr: 0x000001c0 */
  ca_uint32_t                              rsrvd113[3];                  
  XGPN_DSFP_portid102_ctl_xgem_t           portid102_ctl_xgem;            /* addr: 0x000001c4 */
  ca_uint32_t                              rsrvd114[3];                  
  XGPN_DSFP_portid103_ctl_xgem_t           portid103_ctl_xgem;            /* addr: 0x000001c8 */
  ca_uint32_t                              rsrvd115[3];                  
  XGPN_DSFP_portid104_ctl_xgem_t           portid104_ctl_xgem;            /* addr: 0x000001cc */
  ca_uint32_t                              rsrvd116[3];                  
  XGPN_DSFP_portid105_ctl_xgem_t           portid105_ctl_xgem;            /* addr: 0x000001d0 */
  ca_uint32_t                              rsrvd117[3];                  
  XGPN_DSFP_portid106_ctl_xgem_t           portid106_ctl_xgem;            /* addr: 0x000001d4 */
  ca_uint32_t                              rsrvd118[3];                  
  XGPN_DSFP_portid107_ctl_xgem_t           portid107_ctl_xgem;            /* addr: 0x000001d8 */
  ca_uint32_t                              rsrvd119[3];                  
  XGPN_DSFP_portid108_ctl_xgem_t           portid108_ctl_xgem;            /* addr: 0x000001dc */
  ca_uint32_t                              rsrvd120[3];                  
  XGPN_DSFP_portid109_ctl_xgem_t           portid109_ctl_xgem;            /* addr: 0x000001e0 */
  ca_uint32_t                              rsrvd121[3];                  
  XGPN_DSFP_portid110_ctl_xgem_t           portid110_ctl_xgem;            /* addr: 0x000001e4 */
  ca_uint32_t                              rsrvd122[3];                  
  XGPN_DSFP_portid111_ctl_xgem_t           portid111_ctl_xgem;            /* addr: 0x000001e8 */
  ca_uint32_t                              rsrvd123[3];                  
  XGPN_DSFP_portid112_ctl_xgem_t           portid112_ctl_xgem;            /* addr: 0x000001ec */
  ca_uint32_t                              rsrvd124[3];                  
  XGPN_DSFP_portid113_ctl_xgem_t           portid113_ctl_xgem;            /* addr: 0x000001f0 */
  ca_uint32_t                              rsrvd125[3];                  
  XGPN_DSFP_portid114_ctl_xgem_t           portid114_ctl_xgem;            /* addr: 0x000001f4 */
  ca_uint32_t                              rsrvd126[3];                  
  XGPN_DSFP_portid115_ctl_xgem_t           portid115_ctl_xgem;            /* addr: 0x000001f8 */
  ca_uint32_t                              rsrvd127[3];                  
  XGPN_DSFP_portid116_ctl_xgem_t           portid116_ctl_xgem;            /* addr: 0x000001fc */
  ca_uint32_t                              rsrvd128[3];                  
  XGPN_DSFP_portid117_ctl_xgem_t           portid117_ctl_xgem;            /* addr: 0x00000200 */
  ca_uint32_t                              rsrvd129[3];                  
  XGPN_DSFP_portid118_ctl_xgem_t           portid118_ctl_xgem;            /* addr: 0x00000204 */
  ca_uint32_t                              rsrvd130[3];                  
  XGPN_DSFP_portid119_ctl_xgem_t           portid119_ctl_xgem;            /* addr: 0x00000208 */
  ca_uint32_t                              rsrvd131[3];                  
  XGPN_DSFP_portid120_ctl_xgem_t           portid120_ctl_xgem;            /* addr: 0x0000020c */
  ca_uint32_t                              rsrvd132[3];                  
  XGPN_DSFP_portid121_ctl_xgem_t           portid121_ctl_xgem;            /* addr: 0x00000210 */
  ca_uint32_t                              rsrvd133[3];                  
  XGPN_DSFP_portid122_ctl_xgem_t           portid122_ctl_xgem;            /* addr: 0x00000214 */
  ca_uint32_t                              rsrvd134[3];                  
  XGPN_DSFP_portid123_ctl_xgem_t           portid123_ctl_xgem;            /* addr: 0x00000218 */
  ca_uint32_t                              rsrvd135[3];                  
  XGPN_DSFP_portid124_ctl_xgem_t           portid124_ctl_xgem;            /* addr: 0x0000021c */
  ca_uint32_t                              rsrvd136[3];                  
  XGPN_DSFP_portid125_ctl_xgem_t           portid125_ctl_xgem;            /* addr: 0x00000220 */
  ca_uint32_t                              rsrvd137[3];                  
  XGPN_DSFP_portid126_ctl_xgem_t           portid126_ctl_xgem;            /* addr: 0x00000224 */
  ca_uint32_t                              rsrvd138[3];                  
  XGPN_DSFP_portid127_ctl_xgem_t           portid127_ctl_xgem;            /* addr: 0x00000228 */
  ca_uint32_t                              rsrvd139[3];                  
  XGPN_DSFP_ds_sync_t                      ds_sync;                       /* addr: 0x0000022c */
  ca_uint32_t                              rsrvd140[3];                  
  XGPN_DSFP_superframe1_t                  superframe1;                   /* addr: 0x00000230 */
  ca_uint32_t                              rsrvd141[3];                  
  XGPN_DSFP_superframe0_t                  superframe0;                   /* addr: 0x00000234 */
  ca_uint32_t                              rsrvd142[3];                  
  XGPN_DSFP_OC_body1_t                     OC_body1;                      /* addr: 0x00000238 */
  ca_uint32_t                              rsrvd143[3];                  
  XGPN_DSFP_OC_body0_t                     OC_body0;                      /* addr: 0x0000023c */
  ca_uint32_t                              rsrvd144[3];                  
  XGPN_DSFP_bip_32_dw1_t                   bip_32_dw1;                    /* addr: 0x00000240 */
  ca_uint32_t                              rsrvd145[3];                  
  XGPN_DSFP_bip_32_dw0_t                   bip_32_dw0;                    /* addr: 0x00000244 */
  ca_uint32_t                              rsrvd146[3];                  
  XGPN_DSFP_bip_32_err_t                   bip_32_err;                    /* addr: 0x00000248 */
  ca_uint32_t                              rsrvd147[3];                  
  XGPN_DSFP_psbd_hec_err_t                 psbd_hec_err;                  /* addr: 0x0000024c */
  ca_uint32_t                              rsrvd148[3];                  
  XGPN_DSFP_sfc_hec_corrected_t            sfc_hec_corrected;             /* addr: 0x00000250 */
  ca_uint32_t                              rsrvd149[3];                  
  XGPN_DSFP_sfc_hec_uncorrected_mib_t      sfc_hec_uncorrected_mib;       /* addr: 0x00000254 */
  ca_uint32_t                              rsrvd150[3];                  
  XGPN_DSFP_ponid_hec_corrected_t          ponid_hec_corrected;           /* addr: 0x00000258 */
  ca_uint32_t                              rsrvd151[3];                  
  XGPN_DSFP_ponid_hec_uncorrected_mib_t    ponid_hec_uncorrected_mib;     /* addr: 0x0000025c */
  ca_uint32_t                              rsrvd152[3];                  
  XGPN_DSFP_psbd_hec_uncorrected_mib_t     psbd_hec_uncorrected_mib;      /* addr: 0x00000260 */
  ca_uint32_t                              rsrvd153[3];                  
  XGPN_DSFP_bwmap_hec_corrected_t          bwmap_hec_corrected;           /* addr: 0x00000264 */
  ca_uint32_t                              rsrvd154[3];                  
  XGPN_DSFP_bwmap_hec_uncorrected_mib_t    bwmap_hec_uncorrected_mib;     /* addr: 0x00000268 */
  ca_uint32_t                              rsrvd155[3];                  
  XGPN_DSFP_xgtc_err_t                     xgtc_err;                      /* addr: 0x0000026c */
  ca_uint32_t                              rsrvd156[3];                  
  XGPN_DSFP_xgtc_frame_t                   xgtc_frame;                    /* addr: 0x00000270 */
  ca_uint32_t                              rsrvd157[3];                  
  XGPN_DSFP_xgtc_hec_corrected_t           xgtc_hec_corrected;            /* addr: 0x00000274 */
  ca_uint32_t                              rsrvd158[3];                  
  XGPN_DSFP_xgtc_hec_uncorrected_mib_t     xgtc_hec_uncorrected_mib;      /* addr: 0x00000278 */
  ca_uint32_t                              rsrvd159[3];                  
  XGPN_DSFP_xgem_err0_t                    xgem_err0;                     /* addr: 0x0000027c */
  ca_uint32_t                              rsrvd160[3];                  
  XGPN_DSFP_xgem_err1_t                    xgem_err1;                     /* addr: 0x00000280 */
  ca_uint32_t                              rsrvd161[3];                  
  XGPN_DSFP_xgem_frame_t                   xgem_frame;                    /* addr: 0x00000284 */
  ca_uint32_t                              rsrvd162[3];                  
  XGPN_DSFP_xgem_hec_corrected_t           xgem_hec_corrected;            /* addr: 0x00000288 */
  ca_uint32_t                              rsrvd163[3];                  
  XGPN_DSFP_xgem_hec_uncorrected_mib_t     xgem_hec_uncorrected_mib;      /* addr: 0x0000028c */
  ca_uint32_t                              rsrvd164[3];                  
  XGPN_DSFP_xgem_nolf_mib_t                xgem_nolf_mib;                 /* addr: 0x00000290 */
  ca_uint32_t                              rsrvd165[3];                  
  XGPN_DSFP_xgem_los_word_mib_t            xgem_los_word_mib;             /* addr: 0x00000294 */
  ca_uint32_t                              rsrvd166[3];                  
  XGPN_DSFP_xgem_err_key_mib_t             xgem_err_key_mib;              /* addr: 0x00000298 */
  ca_uint32_t                              rsrvd167[3];                  
  XGPN_DSFP_rxmac_xgem_frame_t             rxmac_xgem_frame;              /* addr: 0x0000029c */
  ca_uint32_t                              rsrvd168[3];                  
  XGPN_DSFP_rxmac_omci_frame_t             rxmac_omci_frame;              /* addr: 0x000002a0 */
  ca_uint32_t                              rsrvd169[3];                  
  XGPN_DSFP_rxmac_pkt_frame_t              rxmac_pkt_frame;               /* addr: 0x000002a4 */
  ca_uint32_t                              rsrvd170[3];                  
  XGPN_DSFP_rxmac_pkt_crc_err_t            rxmac_pkt_crc_err;             /* addr: 0x000002a8 */
  ca_uint32_t                              rsrvd171[3];                  
  XGPN_DSFP_rxmac_xgem_frame_status_t      rxmac_xgem_frame_status;       /* addr: 0x000002ac */
  ca_uint32_t                              rsrvd172[3];                  
  XGPN_DSFP_async_ff_status_t              async_ff_status;               /* addr: 0x000002b0 */
  ca_uint32_t                              rsrvd173[3];                  
  XGPN_DSFP_MIB_RAM_STATUS_REG_t           MIB_RAM_STATUS_REG;            /* addr: 0x000002b4 */
  ca_uint32_t                              rsrvd174[3];                  
  XGPN_DSFP_PORTID_XGEM_MIB_ACCESS_t       PORTID_XGEM_MIB_ACCESS;        /* addr: 0x000002b8 */
  ca_uint32_t                              rsrvd175[3];                  
  XGPN_DSFP_PORTID_XGEM_MIB_DATA2_t        PORTID_XGEM_MIB_DATA2;         /* addr: 0x000002bc */
  ca_uint32_t                              rsrvd176[3];                  
  XGPN_DSFP_PORTID_XGEM_MIB_DATA1_t        PORTID_XGEM_MIB_DATA1;         /* addr: 0x000002c0 */
  ca_uint32_t                              rsrvd177[3];                  
  XGPN_DSFP_PORTID_XGEM_MIB_DATA0_t        PORTID_XGEM_MIB_DATA0;         /* addr: 0x000002c4 */
} APB1_XGPN_DSFP_t;


/*
 * usbg
 */
        
#define XGPN_USBG_GBL_CTRL                       0xd0034400
#define XGPN_USBG_GBL_CTRL_dft                   0x000000c3

typedef volatile union {
  struct {
    ca_uint32_t xgtc_en              :  1 ; /* bits 0:0 */
    ca_uint32_t scramble_en          :  1 ; /* bits 1:1 */
    ca_uint32_t laser_on             :  1 ; /* bits 2:2 */
    ca_uint32_t laser_polarity       :  1 ; /* bits 3:3 */
    ca_uint32_t swap_tx_bus          :  2 ; /* bits 5:4 */
    ca_uint32_t pf_align_mode        :  1 ; /* bits 6:6 */
    ca_uint32_t aes_encrypt_en       :  1 ; /* bits 7:7 */
    ca_uint32_t rsrvd1               : 16 ;
    ca_uint32_t laser_on_align       :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_GBL_CTRL_t;


#define XGPN_USBG_XGTC_CTRL                      0xd0034404
#define XGPN_USBG_XGTC_CTRL_dft                  0x00000017

typedef volatile union {
  struct {
    ca_uint32_t xgem_en              :  1 ; /* bits 0:0 */
    ca_uint32_t dbru_en              :  1 ; /* bits 1:1 */
    ca_uint32_t ploam_en             :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t O7_plmp_off          :  1 ; /* bits 4:4 */
    ca_uint32_t rsrvd2               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_XGTC_CTRL_t;


#define XGPN_USBG_GUARD_TM_CFG                   0xd0034408
#define XGPN_USBG_GUARD_TM_CFG_dft               0x00000004

typedef volatile union {
  struct {
    ca_uint32_t time                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_GUARD_TM_CFG_t;


#define XGPN_USBG_IDLE_FM_CFG                    0xd003440c
#define XGPN_USBG_IDLE_FM_CFG_dft                0x80000001

typedef volatile union {
  struct {
    ca_uint32_t size                 :  6 ; /* bits 5:0 */
    ca_uint32_t rsrvd1               : 25 ;
    ca_uint32_t mode                 :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_IDLE_FM_CFG_t;


#define XGPN_USBG_XGTC_HD_IND_CFG                0xd0034410
#define XGPN_USBG_XGTC_HD_IND_CFG_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dg                   :  1 ; /* bits 0:0 */
    ca_uint32_t rsv                  :  7 ; /* bits 7:1 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_XGTC_HD_IND_CFG_t;


#define XGPN_USBG_AES_UNI_KEY_IDX_CTRL           0xd0034414
#define XGPN_USBG_AES_UNI_KEY_IDX_CTRL_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t key_idx              :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_AES_UNI_KEY_IDX_CTRL_t;


#define XGPN_USBG_XGEM_PID_TBL_ACCESS            0xd0034418
#define XGPN_USBG_XGEM_PID_TBL_ACCESS_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rw                   :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_XGEM_PID_TBL_ACCESS_t;


#define XGPN_USBG_XGEM_PID_TBL_DATA              0xd003441c
#define XGPN_USBG_XGEM_PID_TBL_DATA_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t XGEM_PortID          : 16 ; /* bits 15:0 */
    ca_uint32_t port_en              :  1 ; /* bits 16:16 */
    ca_uint32_t aes_mode             :  1 ; /* bits 17:17 */
    ca_uint32_t MC_flag              :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd1               : 13 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_XGEM_PID_TBL_DATA_t;


#define XGPN_USBG_XGEM_BUF_CFG                   0xd0034420
#define XGPN_USBG_XGEM_BUF_CFG_dft               0x03e00040

typedef volatile union {
  struct {
    ca_uint32_t lo_threshold         :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t hi_threshold         : 10 ; /* bits 25:16 */
    ca_uint32_t rsrvd2               :  6 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_XGEM_BUF_CFG_t;


#define XGPN_USBG_DBRU_CFG                       0xd0034424
#define XGPN_USBG_DBRU_CFG_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 30 ;
    ca_uint32_t tcon_residue_en      :  1 ; /* bits 30:30 */
    ca_uint32_t mode                 :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_DBRU_CFG_t;


#define XGPN_USBG_PLOAMU_QU_CFG                  0xd0034428
#define XGPN_USBG_PLOAMU_QU_CFG_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t no_empty             :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 30 ;
    ca_uint32_t mode                 :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_PLOAMU_QU_CFG_t;


#define XGPN_USBG_FRAG_FF_DUMP_CFG               0xd003442c
#define XGPN_USBG_FRAG_FF_DUMP_CFG_dft           0x8002ab70

typedef volatile union {
  struct {
    ca_uint32_t dump_time            : 18 ; /* bits 17:0 */
    ca_uint32_t rsrvd1               : 13 ;
    ca_uint32_t dump_en              :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_FRAG_FF_DUMP_CFG_t;


#define XGPN_USBG_XGTC_ERR_DUMP_CFG              0xd0034430
#define XGPN_USBG_XGTC_ERR_DUMP_CFG_dft          0x00000040

typedef volatile union {
  struct {
    ca_uint32_t dly_time             :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_XGTC_ERR_DUMP_CFG_t;


#define XGPN_USBG_DBRU_RPT_MAX_CFG               0xd0034434
#define XGPN_USBG_DBRU_RPT_MAX_CFG_dft           0x001ffffe

typedef volatile union {
  struct {
    ca_uint32_t val                  : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_DBRU_RPT_MAX_CFG_t;


#define XGPN_USBG_DBRU_BUFOCC_TBL_ACCESS         0xd0034438
#define XGPN_USBG_DBRU_BUFOCC_TBL_ACCESS_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Addr                 :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 11 ;
    ca_uint32_t Select               :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd2               : 13 ;
    ca_uint32_t rw                   :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_DBRU_BUFOCC_TBL_ACCESS_t;


#define XGPN_USBG_DBRU_BUFOCC_TBL_DATA           0xd003443c
#define XGPN_USBG_DBRU_BUFOCC_TBL_DATA_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t BufOcc               : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_DBRU_BUFOCC_TBL_DATA_t;


#define XGPN_USBG_INTERRUPT                      0xd0034440
#define XGPN_USBG_INTERRUPT_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t buf_empty_pop_intI   :  1 ; /* bits 0:0 */
    ca_uint32_t st_chk_err_intI      :  1 ; /* bits 1:1 */
    ca_uint32_t xgem_ff_of_intI      :  1 ; /* bits 2:2 */
    ca_uint32_t xgem_ff_uf_intI      :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t xgem_port_disable_intI :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t xgem_mc_port_intI    :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd3               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_INTERRUPT_t;


#define XGPN_USBG_INTERRUPTE0                    0xd0034444
#define XGPN_USBG_INTERRUPTE0_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t buf_empty_pop_intIE  :  1 ; /* bits 0:0 */
    ca_uint32_t st_chk_err_intIE     :  1 ; /* bits 1:1 */
    ca_uint32_t xgem_ff_of_intIE     :  1 ; /* bits 2:2 */
    ca_uint32_t xgem_ff_uf_intIE     :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t xgem_port_disable_intIE :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t xgem_mc_port_intIE   :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd3               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_INTERRUPTE0_t;


#define XGPN_USBG_INTERRUPTE1                    0xd0034448
#define XGPN_USBG_INTERRUPTE1_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t buf_empty_pop_intIE  :  1 ; /* bits 0:0 */
    ca_uint32_t st_chk_err_intIE     :  1 ; /* bits 1:1 */
    ca_uint32_t xgem_ff_of_intIE     :  1 ; /* bits 2:2 */
    ca_uint32_t xgem_ff_uf_intIE     :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t xgem_port_disable_intIE :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t xgem_mc_port_intIE   :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd3               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_INTERRUPTE1_t;


#define XGPN_USBG_INIT_STS                       0xd003444c
#define XGPN_USBG_INIT_STS_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t init_done            :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_INIT_STS_t;


#define XGPN_USBG_BURST_PF0_INFOR_STS            0xd0034450
#define XGPN_USBG_BURST_PF0_INFOR_STS_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pcnt                 :  8 ; /* bits 7:0 */
    ca_uint32_t plen                 :  4 ; /* bits 11:8 */
    ca_uint32_t dlen                 :  4 ; /* bits 15:12 */
    ca_uint32_t oh_len               : 10 ; /* bits 25:16 */
    ca_uint32_t fecu                 :  1 ; /* bits 26:26 */
    ca_uint32_t ver                  :  4 ; /* bits 30:27 */
    ca_uint32_t vld                  :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF0_INFOR_STS_t;


#define XGPN_USBG_BURST_PF0_DP_H32_STS           0xd0034454
#define XGPN_USBG_BURST_PF0_DP_H32_STS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dp                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF0_DP_H32_STS_t;


#define XGPN_USBG_BURST_PF0_DP_L32_STS           0xd0034458
#define XGPN_USBG_BURST_PF0_DP_L32_STS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dp                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF0_DP_L32_STS_t;


#define XGPN_USBG_BURST_PF0_PP_H32_STS           0xd003445c
#define XGPN_USBG_BURST_PF0_PP_H32_STS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pp                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF0_PP_H32_STS_t;


#define XGPN_USBG_BURST_PF0_PP_L32_STS           0xd0034460
#define XGPN_USBG_BURST_PF0_PP_L32_STS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pp                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF0_PP_L32_STS_t;


#define XGPN_USBG_BURST_PF1_INFOR_STS            0xd0034464
#define XGPN_USBG_BURST_PF1_INFOR_STS_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pcnt                 :  8 ; /* bits 7:0 */
    ca_uint32_t plen                 :  4 ; /* bits 11:8 */
    ca_uint32_t dlen                 :  4 ; /* bits 15:12 */
    ca_uint32_t oh_len               : 10 ; /* bits 25:16 */
    ca_uint32_t fecu                 :  1 ; /* bits 26:26 */
    ca_uint32_t ver                  :  4 ; /* bits 30:27 */
    ca_uint32_t vld                  :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF1_INFOR_STS_t;


#define XGPN_USBG_BURST_PF1_DP_H32_STS           0xd0034468
#define XGPN_USBG_BURST_PF1_DP_H32_STS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dp                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF1_DP_H32_STS_t;


#define XGPN_USBG_BURST_PF1_DP_L32_STS           0xd003446c
#define XGPN_USBG_BURST_PF1_DP_L32_STS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dp                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF1_DP_L32_STS_t;


#define XGPN_USBG_BURST_PF1_PP_H32_STS           0xd0034470
#define XGPN_USBG_BURST_PF1_PP_H32_STS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pp                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF1_PP_H32_STS_t;


#define XGPN_USBG_BURST_PF1_PP_L32_STS           0xd0034474
#define XGPN_USBG_BURST_PF1_PP_L32_STS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pp                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF1_PP_L32_STS_t;


#define XGPN_USBG_BURST_PF2_INFOR_STS            0xd0034478
#define XGPN_USBG_BURST_PF2_INFOR_STS_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pcnt                 :  8 ; /* bits 7:0 */
    ca_uint32_t plen                 :  4 ; /* bits 11:8 */
    ca_uint32_t dlen                 :  4 ; /* bits 15:12 */
    ca_uint32_t oh_len               : 10 ; /* bits 25:16 */
    ca_uint32_t fecu                 :  1 ; /* bits 26:26 */
    ca_uint32_t ver                  :  4 ; /* bits 30:27 */
    ca_uint32_t vld                  :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF2_INFOR_STS_t;


#define XGPN_USBG_BURST_PF2_DP_H32_STS           0xd003447c
#define XGPN_USBG_BURST_PF2_DP_H32_STS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dp                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF2_DP_H32_STS_t;


#define XGPN_USBG_BURST_PF2_DP_L32_STS           0xd0034480
#define XGPN_USBG_BURST_PF2_DP_L32_STS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dp                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF2_DP_L32_STS_t;


#define XGPN_USBG_BURST_PF2_PP_H32_STS           0xd0034484
#define XGPN_USBG_BURST_PF2_PP_H32_STS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pp                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF2_PP_H32_STS_t;


#define XGPN_USBG_BURST_PF2_PP_L32_STS           0xd0034488
#define XGPN_USBG_BURST_PF2_PP_L32_STS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pp                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF2_PP_L32_STS_t;


#define XGPN_USBG_BURST_PF3_INFOR_STS            0xd003448c
#define XGPN_USBG_BURST_PF3_INFOR_STS_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pcnt                 :  8 ; /* bits 7:0 */
    ca_uint32_t plen                 :  4 ; /* bits 11:8 */
    ca_uint32_t dlen                 :  4 ; /* bits 15:12 */
    ca_uint32_t oh_len               : 10 ; /* bits 25:16 */
    ca_uint32_t fecu                 :  1 ; /* bits 26:26 */
    ca_uint32_t ver                  :  4 ; /* bits 30:27 */
    ca_uint32_t vld                  :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF3_INFOR_STS_t;


#define XGPN_USBG_BURST_PF3_DP_H32_STS           0xd0034490
#define XGPN_USBG_BURST_PF3_DP_H32_STS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dp                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF3_DP_H32_STS_t;


#define XGPN_USBG_BURST_PF3_DP_L32_STS           0xd0034494
#define XGPN_USBG_BURST_PF3_DP_L32_STS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t dp                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF3_DP_L32_STS_t;


#define XGPN_USBG_BURST_PF3_PP_H32_STS           0xd0034498
#define XGPN_USBG_BURST_PF3_PP_H32_STS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pp                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF3_PP_H32_STS_t;


#define XGPN_USBG_BURST_PF3_PP_L32_STS           0xd003449c
#define XGPN_USBG_BURST_PF3_PP_L32_STS_dft       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pp                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BURST_PF3_PP_L32_STS_t;


#define XGPN_USBG_BP_VER_OL_STS                  0xd00344a0
#define XGPN_USBG_BP_VER_OL_STS_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t ind0                 :  1 ; /* bits 0:0 */
    ca_uint32_t ind1                 :  1 ; /* bits 1:1 */
    ca_uint32_t ind2                 :  1 ; /* bits 2:2 */
    ca_uint32_t ind3                 :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_BP_VER_OL_STS_t;


#define XGPN_USBG_MIB_RAM_STATUS_REG             0xd00344a4
#define XGPN_USBG_MIB_RAM_STATUS_REG_dft         0x00000001

typedef volatile union {
  struct {
    ca_uint32_t ram_initdone         :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_MIB_RAM_STATUS_REG_t;


#define XGPN_USBG_MIB_CTL                        0xd00344a8
#define XGPN_USBG_MIB_CTL_dft                    0x00000001

typedef volatile union {
  struct {
    ca_uint32_t ram_clr_en           :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_MIB_CTL_t;


#define XGPN_USBG_PORTID_XGEM_MIB_ACCESS         0xd00344ac
#define XGPN_USBG_PORTID_XGEM_MIB_ACCESS_dft     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t Addr                 :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rw                   :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_PORTID_XGEM_MIB_ACCESS_t;


#define XGPN_USBG_PORTID_XGEM_MIB_DATA2          0xd00344b0
#define XGPN_USBG_PORTID_XGEM_MIB_DATA2_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t byte_cnt             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_PORTID_XGEM_MIB_DATA2_t;


#define XGPN_USBG_PORTID_XGEM_MIB_DATA1          0xd00344b4
#define XGPN_USBG_PORTID_XGEM_MIB_DATA1_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t byte_cnt             : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_PORTID_XGEM_MIB_DATA1_t;


#define XGPN_USBG_PORTID_XGEM_MIB_DATA0          0xd00344b8
#define XGPN_USBG_PORTID_XGEM_MIB_DATA0_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t frame_cnt            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_PORTID_XGEM_MIB_DATA0_t;


#define XGPN_USBG_XGEM_LF0                       0xd00344bc
#define XGPN_USBG_XGEM_LF0_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_XGEM_LF0_t;


#define XGPN_USBG_XGTC_FM_CNT                    0xd00344c0
#define XGPN_USBG_XGTC_FM_CNT_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_XGTC_FM_CNT_t;


#define XGPN_USBG_XGTC_FEC_BLK_CNT               0xd00344c4
#define XGPN_USBG_XGTC_FEC_BLK_CNT_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t blk                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_XGTC_FEC_BLK_CNT_t;


#define XGPN_USBG_PLM_FM_CNT                     0xd00344c8
#define XGPN_USBG_PLM_FM_CNT_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_USBG_PLM_FM_CNT_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* usbg */
typedef struct {
  XGPN_USBG_GBL_CTRL_t                     GBL_CTRL;                      /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  XGPN_USBG_XGTC_CTRL_t                    XGTC_CTRL;                     /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  XGPN_USBG_GUARD_TM_CFG_t                 GUARD_TM_CFG;                  /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  XGPN_USBG_IDLE_FM_CFG_t                  IDLE_FM_CFG;                   /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  XGPN_USBG_XGTC_HD_IND_CFG_t              XGTC_HD_IND_CFG;               /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  XGPN_USBG_AES_UNI_KEY_IDX_CTRL_t         AES_UNI_KEY_IDX_CTRL;          /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  XGPN_USBG_XGEM_PID_TBL_ACCESS_t          XGEM_PID_TBL_ACCESS;           /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  XGPN_USBG_XGEM_PID_TBL_DATA_t            XGEM_PID_TBL_DATA;             /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  XGPN_USBG_XGEM_BUF_CFG_t                 XGEM_BUF_CFG;                  /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  XGPN_USBG_DBRU_CFG_t                     DBRU_CFG;                      /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  XGPN_USBG_PLOAMU_QU_CFG_t                PLOAMU_QU_CFG;                 /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  XGPN_USBG_FRAG_FF_DUMP_CFG_t             FRAG_FF_DUMP_CFG;              /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  XGPN_USBG_XGTC_ERR_DUMP_CFG_t            XGTC_ERR_DUMP_CFG;             /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  XGPN_USBG_DBRU_RPT_MAX_CFG_t             DBRU_RPT_MAX_CFG;              /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  XGPN_USBG_DBRU_BUFOCC_TBL_ACCESS_t       DBRU_BUFOCC_TBL_ACCESS;        /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  XGPN_USBG_DBRU_BUFOCC_TBL_DATA_t         DBRU_BUFOCC_TBL_DATA;          /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  XGPN_USBG_INTERRUPT_t                    INTERRUPT;                     /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  XGPN_USBG_INTERRUPTE0_t                  INTERRUPTE0;                   /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  XGPN_USBG_INTERRUPTE1_t                  INTERRUPTE1;                   /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  XGPN_USBG_INIT_STS_t                     INIT_STS;                      /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  XGPN_USBG_BURST_PF0_INFOR_STS_t          BURST_PF0_INFOR_STS;           /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  XGPN_USBG_BURST_PF0_DP_H32_STS_t         BURST_PF0_DP_H32_STS;          /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  XGPN_USBG_BURST_PF0_DP_L32_STS_t         BURST_PF0_DP_L32_STS;          /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  XGPN_USBG_BURST_PF0_PP_H32_STS_t         BURST_PF0_PP_H32_STS;          /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  XGPN_USBG_BURST_PF0_PP_L32_STS_t         BURST_PF0_PP_L32_STS;          /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  XGPN_USBG_BURST_PF1_INFOR_STS_t          BURST_PF1_INFOR_STS;           /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  XGPN_USBG_BURST_PF1_DP_H32_STS_t         BURST_PF1_DP_H32_STS;          /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  XGPN_USBG_BURST_PF1_DP_L32_STS_t         BURST_PF1_DP_L32_STS;          /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  XGPN_USBG_BURST_PF1_PP_H32_STS_t         BURST_PF1_PP_H32_STS;          /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  XGPN_USBG_BURST_PF1_PP_L32_STS_t         BURST_PF1_PP_L32_STS;          /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  XGPN_USBG_BURST_PF2_INFOR_STS_t          BURST_PF2_INFOR_STS;           /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  XGPN_USBG_BURST_PF2_DP_H32_STS_t         BURST_PF2_DP_H32_STS;          /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  XGPN_USBG_BURST_PF2_DP_L32_STS_t         BURST_PF2_DP_L32_STS;          /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  XGPN_USBG_BURST_PF2_PP_H32_STS_t         BURST_PF2_PP_H32_STS;          /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  XGPN_USBG_BURST_PF2_PP_L32_STS_t         BURST_PF2_PP_L32_STS;          /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  XGPN_USBG_BURST_PF3_INFOR_STS_t          BURST_PF3_INFOR_STS;           /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  XGPN_USBG_BURST_PF3_DP_H32_STS_t         BURST_PF3_DP_H32_STS;          /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  XGPN_USBG_BURST_PF3_DP_L32_STS_t         BURST_PF3_DP_L32_STS;          /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  XGPN_USBG_BURST_PF3_PP_H32_STS_t         BURST_PF3_PP_H32_STS;          /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];                   
  XGPN_USBG_BURST_PF3_PP_L32_STS_t         BURST_PF3_PP_L32_STS;          /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];                   
  XGPN_USBG_BP_VER_OL_STS_t                BP_VER_OL_STS;                 /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];                   
  XGPN_USBG_MIB_RAM_STATUS_REG_t           MIB_RAM_STATUS_REG;            /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];                   
  XGPN_USBG_MIB_CTL_t                      MIB_CTL;                       /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];                   
  XGPN_USBG_PORTID_XGEM_MIB_ACCESS_t       PORTID_XGEM_MIB_ACCESS;        /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd44[3];                   
  XGPN_USBG_PORTID_XGEM_MIB_DATA2_t        PORTID_XGEM_MIB_DATA2;         /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd45[3];                   
  XGPN_USBG_PORTID_XGEM_MIB_DATA1_t        PORTID_XGEM_MIB_DATA1;         /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd46[3];                   
  XGPN_USBG_PORTID_XGEM_MIB_DATA0_t        PORTID_XGEM_MIB_DATA0;         /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd47[3];                   
  XGPN_USBG_XGEM_LF0_t                     XGEM_LF0;                      /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd48[3];                   
  XGPN_USBG_XGTC_FM_CNT_t                  XGTC_FM_CNT;                   /* addr: 0x000000c0 */
  ca_uint32_t                              rsrvd49[3];                   
  XGPN_USBG_XGTC_FEC_BLK_CNT_t             XGTC_FEC_BLK_CNT;              /* addr: 0x000000c4 */
  ca_uint32_t                              rsrvd50[3];                   
  XGPN_USBG_PLM_FM_CNT_t                   PLM_FM_CNT;                    /* addr: 0x000000c8 */
} APB1_XGPN_USBG_t;


/*
 * bwmp
 */
        
#define XGPN_BWMP_GBL_CTRL                       0xd0034600
#define XGPN_BWMP_GBL_CTRL_dft                   0x00000619

typedef volatile union {
  struct {
    ca_uint32_t rx_fltr_en           :  1 ; /* bits 0:0 */
    ca_uint32_t grant_src_mode       :  1 ; /* bits 1:1 */
    ca_uint32_t st_out_chk_en        :  1 ; /* bits 2:2 */
    ca_uint32_t pre_st_out_chk_en    :  1 ; /* bits 3:3 */
    ca_uint32_t grt_always_drop_num  :  3 ; /* bits 6:4 */
    ca_uint32_t grt_always_drop_en   :  1 ; /* bits 7:7 */
    ca_uint32_t scope_remove         :  1 ; /* bits 8:8 */
    ca_uint32_t max_burst_per_bwmap  :  4 ; /* bits 12:9 */
    ca_uint32_t bst_end_ov_drop_en   :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd1               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_GBL_CTRL_t;


#define XGPN_BWMP_RSP_TM_CFG                     0xd0034604
#define XGPN_BWMP_RSP_TM_CFG_dft                 0x00001543

typedef volatile union {
  struct {
    ca_uint32_t time                 : 13 ; /* bits 12:0 */
    ca_uint32_t rsrvd1               : 19 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_RSP_TM_CFG_t;


#define XGPN_BWMP_BST_MG_CFG                     0xd0034608
#define XGPN_BWMP_BST_MG_CFG_dft                 0x00000100

typedef volatile union {
  struct {
    ca_uint32_t time                 :  9 ; /* bits 8:0 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_BST_MG_CFG_t;


#define XGPN_BWMP_SEQ_TM_CTRL                    0xd003460c
#define XGPN_BWMP_SEQ_TM_CTRL_dft                0x000001ff

typedef volatile union {
  struct {
    ca_uint32_t map_lead_tm          : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_SEQ_TM_CTRL_t;


#define XGPN_BWMP_GRT_MSG_CTL                    0xd0034610
#define XGPN_BWMP_GRT_MSG_CTL_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 31 ;
    ca_uint32_t access_wr            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_GRT_MSG_CTL_t;


#define XGPN_BWMP_GRT_MSG_DATA0                  0xd0034614
#define XGPN_BWMP_GRT_MSG_DATA0_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t infor                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_GRT_MSG_DATA0_t;


#define XGPN_BWMP_GRT_MSG_DATA1                  0xd0034618
#define XGPN_BWMP_GRT_MSG_DATA1_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t infor                : 10 ; /* bits 9:0 */
    ca_uint32_t rsrvd1               : 22 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_GRT_MSG_DATA1_t;


#define XGPN_BWMP_GRT_FF_CTL                     0xd003461c
#define XGPN_BWMP_GRT_FF_CTL_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t addr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 21 ;
    ca_uint32_t grant_ff_sel         :  2 ; /* bits 30:29 */
    ca_uint32_t access_rd            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_GRT_FF_CTL_t;


#define XGPN_BWMP_GRT_FF_DATA0                   0xd0034620
#define XGPN_BWMP_GRT_FF_DATA0_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t grant_size           : 16 ; /* bits 15:0 */
    ca_uint32_t st_tm                : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_GRT_FF_DATA0_t;


#define XGPN_BWMP_GRT_FF_DATA1                   0xd0034624
#define XGPN_BWMP_GRT_FF_DATA1_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bp_ind               :  2 ; /* bits 1:0 */
    ca_uint32_t fecu                 :  1 ; /* bits 2:2 */
    ca_uint32_t ploamu               :  1 ; /* bits 3:3 */
    ca_uint32_t dbru                 :  1 ; /* bits 4:4 */
    ca_uint32_t tcont_id             :  5 ; /* bits 9:5 */
    ca_uint32_t rsrvd1               :  6 ;
    ca_uint32_t tcont_en             :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd2               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_GRT_FF_DATA1_t;


#define XGPN_BWMP_BM_BUF_CFG                     0xd0034628
#define XGPN_BWMP_BM_BUF_CFG_dft                 0x00000002

typedef volatile union {
  struct {
    ca_uint32_t wr_threshold         :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_BM_BUF_CFG_t;


#define XGPN_BWMP_INTERRUPT                      0xd003462c
#define XGPN_BWMP_INTERRUPT_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bwmap_lmt_intI       :  1 ; /* bits 0:0 */
    ca_uint32_t hec_chk_err_intI     :  1 ; /* bits 1:1 */
    ca_uint32_t allocid_tbl_full_drop_intI :  1 ; /* bits 2:2 */
    ca_uint32_t unk_allco_series_intI :  1 ; /* bits 3:3 */
    ca_uint32_t burst_profile_invld_intI :  1 ; /* bits 4:4 */
    ca_uint32_t bw_grnt_ff_of_intI   :  1 ; /* bits 5:5 */
    ca_uint32_t bw_grnt_ff_uf_intI   :  1 ; /* bits 6:6 */
    ca_uint32_t bm_grnt_ff_of_intI   :  1 ; /* bits 7:7 */
    ca_uint32_t bm_grnt_ff_uf_intI   :  1 ; /* bits 8:8 */
    ca_uint32_t xgtc_grnt_ff_of_intI :  1 ; /* bits 9:9 */
    ca_uint32_t xgtc_grnt_ff_uf_intI :  1 ; /* bits 10:10 */
    ca_uint32_t gs_less4_drop_intI   :  1 ; /* bits 11:11 */
    ca_uint32_t st_chk_err_intI      :  1 ; /* bits 12:12 */
    ca_uint32_t grt_drop_ff_full_intI :  1 ; /* bits 13:13 */
    ca_uint32_t xg_ov_clash_err_intI :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t UNK_PF_MIBSat        :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd2               :  9 ;
    ca_uint32_t eqd_reduce_drop_intI :  1 ; /* bits 26:26 */
    ca_uint32_t alloc_id_remove_intI :  1 ; /* bits 27:27 */
    ca_uint32_t alloc_id_add_intI    :  1 ; /* bits 28:28 */
    ca_uint32_t pre_sn_grant_intI    :  1 ; /* bits 29:29 */
    ca_uint32_t pre_rang_grant_intI  :  1 ; /* bits 30:30 */
    ca_uint32_t fwi_intI             :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_INTERRUPT_t;


#define XGPN_BWMP_INTERRUPTE0                    0xd0034630
#define XGPN_BWMP_INTERRUPTE0_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bwmap_lmt_intIE      :  1 ; /* bits 0:0 */
    ca_uint32_t hec_chk_err_intIE    :  1 ; /* bits 1:1 */
    ca_uint32_t allocid_tbl_full_drop_intIE :  1 ; /* bits 2:2 */
    ca_uint32_t unk_allco_series_intIE :  1 ; /* bits 3:3 */
    ca_uint32_t burst_profile_invld_intIE :  1 ; /* bits 4:4 */
    ca_uint32_t bw_grnt_ff_of_intIE  :  1 ; /* bits 5:5 */
    ca_uint32_t bw_grnt_ff_uf_intIE  :  1 ; /* bits 6:6 */
    ca_uint32_t bm_grnt_ff_of_intIE  :  1 ; /* bits 7:7 */
    ca_uint32_t bm_grnt_ff_uf_intIE  :  1 ; /* bits 8:8 */
    ca_uint32_t xgtc_grnt_ff_of_intIE :  1 ; /* bits 9:9 */
    ca_uint32_t xgtc_grnt_ff_uf_intIE :  1 ; /* bits 10:10 */
    ca_uint32_t gs_less4_drop_intIE  :  1 ; /* bits 11:11 */
    ca_uint32_t st_chk_err_intIE     :  1 ; /* bits 12:12 */
    ca_uint32_t grt_drop_ff_full_intIE :  1 ; /* bits 13:13 */
    ca_uint32_t xg_ov_clash_err_intIE :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t UNK_PF_MIBSatE       :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd2               :  9 ;
    ca_uint32_t eqd_reduce_drop_intIE :  1 ; /* bits 26:26 */
    ca_uint32_t alloc_id_remove_intIE :  1 ; /* bits 27:27 */
    ca_uint32_t alloc_id_add_intIE   :  1 ; /* bits 28:28 */
    ca_uint32_t pre_sn_grant_intIE   :  1 ; /* bits 29:29 */
    ca_uint32_t pre_rang_grant_intIE :  1 ; /* bits 30:30 */
    ca_uint32_t fwi_intIE            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_INTERRUPTE0_t;


#define XGPN_BWMP_INTERRUPTE1                    0xd0034634
#define XGPN_BWMP_INTERRUPTE1_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bwmap_lmt_intIE      :  1 ; /* bits 0:0 */
    ca_uint32_t hec_chk_err_intIE    :  1 ; /* bits 1:1 */
    ca_uint32_t allocid_tbl_full_drop_intIE :  1 ; /* bits 2:2 */
    ca_uint32_t unk_allco_series_intIE :  1 ; /* bits 3:3 */
    ca_uint32_t burst_profile_invld_intIE :  1 ; /* bits 4:4 */
    ca_uint32_t bw_grnt_ff_of_intIE  :  1 ; /* bits 5:5 */
    ca_uint32_t bw_grnt_ff_uf_intIE  :  1 ; /* bits 6:6 */
    ca_uint32_t bm_grnt_ff_of_intIE  :  1 ; /* bits 7:7 */
    ca_uint32_t bm_grnt_ff_uf_intIE  :  1 ; /* bits 8:8 */
    ca_uint32_t xgtc_grnt_ff_of_intIE :  1 ; /* bits 9:9 */
    ca_uint32_t xgtc_grnt_ff_uf_intIE :  1 ; /* bits 10:10 */
    ca_uint32_t gs_less4_drop_intIE  :  1 ; /* bits 11:11 */
    ca_uint32_t st_chk_err_intIE     :  1 ; /* bits 12:12 */
    ca_uint32_t grt_drop_ff_full_intIE :  1 ; /* bits 13:13 */
    ca_uint32_t xg_ov_clash_err_intIE :  1 ; /* bits 14:14 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t UNK_PF_MIBSatE       :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd2               :  9 ;
    ca_uint32_t eqd_reduce_drop_intIE :  1 ; /* bits 26:26 */
    ca_uint32_t alloc_id_remove_intIE :  1 ; /* bits 27:27 */
    ca_uint32_t alloc_id_add_intIE   :  1 ; /* bits 28:28 */
    ca_uint32_t pre_sn_grant_intIE   :  1 ; /* bits 29:29 */
    ca_uint32_t pre_rang_grant_intIE :  1 ; /* bits 30:30 */
    ca_uint32_t fwi_intIE            :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_INTERRUPTE1_t;


#define XGPN_BWMP_ALLOC_LUT_ACCESS               0xd0034638
#define XGPN_BWMP_ALLOC_LUT_ACCESS_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tcontID              :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t uwlchID              :  4 ; /* bits 11:8 */
    ca_uint32_t rsrvd2               :  4 ;
    ca_uint32_t array                :  5 ; /* bits 20:16 */
    ca_uint32_t rsrvd3               :  9 ;
    ca_uint32_t rnw                  :  1 ; /* bits 30:30 */
    ca_uint32_t access               :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_ALLOC_LUT_ACCESS_t;


#define XGPN_BWMP_ALLOC_LUT_DATA                 0xd003463c
#define XGPN_BWMP_ALLOC_LUT_DATA_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t allocation_ID        : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               : 10 ;
    ca_uint32_t omci_en              :  1 ; /* bits 24:24 */
    ca_uint32_t rsrvd2               :  3 ;
    ca_uint32_t ploam_en             :  1 ; /* bits 28:28 */
    ca_uint32_t rsrvd3               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_ALLOC_LUT_DATA_t;


#define XGPN_BWMP_ALLOC_LUT_DEBUG                0xd0034640
#define XGPN_BWMP_ALLOC_LUT_DEBUG_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t allocID              : 14 ; /* bits 13:0 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t tcontID              :  5 ; /* bits 20:16 */
    ca_uint32_t rsrvd2               : 11 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_ALLOC_LUT_DEBUG_t;


#define XGPN_BWMP_EQD_STS                        0xd0034644
#define XGPN_BWMP_EQD_STS_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_EQD_STS_t;


#define XGPN_BWMP_RANDOM_DLY_STS                 0xd0034648
#define XGPN_BWMP_RANDOM_DLY_STS_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_RANDOM_DLY_STS_t;


#define XGPN_BWMP_LMT_DROP_SRC_STS               0xd003464c
#define XGPN_BWMP_LMT_DROP_SRC_STS_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t total_alloc_num_os   :  1 ; /* bits 0:0 */
    ca_uint32_t per_bst_alloc_num_os :  1 ; /* bits 1:1 */
    ca_uint32_t bst_series_num_os    :  1 ; /* bits 2:2 */
    ca_uint32_t bst_sz_sum_os        :  1 ; /* bits 3:3 */
    ca_uint32_t alloc_sz_chk_vld_os  :  1 ; /* bits 4:4 */
    ca_uint32_t st_chk_fail          :  1 ; /* bits 5:5 */
    ca_uint32_t bst_end_time_os      :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_LMT_DROP_SRC_STS_t;


#define XGPN_BWMP_BWMAP_GRT_FF_STS               0xd0034650
#define XGPN_BWMP_BWMAP_GRT_FF_STS_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wr_ptr               :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t wr_sel               :  3 ; /* bits 10:8 */
    ca_uint32_t rsrvd2               :  5 ;
    ca_uint32_t rd_ptr               :  5 ; /* bits 20:16 */
    ca_uint32_t rsrvd3               :  3 ;
    ca_uint32_t rd_sel               :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd4               :  5 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_BWMAP_GRT_FF_STS_t;


#define XGPN_BWMP_XGTC_GRT_FF_STS                0xd0034654
#define XGPN_BWMP_XGTC_GRT_FF_STS_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wr_ptr               :  5 ; /* bits 4:0 */
    ca_uint32_t wr_sel               :  1 ; /* bits 5:5 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t rd_ptr               :  5 ; /* bits 12:8 */
    ca_uint32_t rd_sel               :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd2               : 18 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_XGTC_GRT_FF_STS_t;


#define XGPN_BWMP_BM_GRT_FF_STS                  0xd0034658
#define XGPN_BWMP_BM_GRT_FF_STS_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wr_ptr               :  7 ; /* bits 6:0 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t rd_ptr               :  7 ; /* bits 14:8 */
    ca_uint32_t rsrvd2               : 17 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_BM_GRT_FF_STS_t;


#define XGPN_BWMP_UNK_PF_MIB                     0xd003465c
#define XGPN_BWMP_UNK_PF_MIB_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cntr                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_UNK_PF_MIB_t;


#define XGPN_BWMP_AS_CNT                         0xd0034660
#define XGPN_BWMP_AS_CNT_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t entry                : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_AS_CNT_t;


#define XGPN_BWMP_AS_HEC_ERR_CNT                 0xd0034664
#define XGPN_BWMP_AS_HEC_ERR_CNT_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t entry                : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_AS_HEC_ERR_CNT_t;


#define XGPN_BWMP_BWMAP_CNT_CTRL                 0xd0034668
#define XGPN_BWMP_BWMAP_CNT_CTRL_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t latch                :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_BWMAP_CNT_CTRL_t;


#define XGPN_BWMP_DS_FM_SYNC_CNT                 0xd003466c
#define XGPN_BWMP_DS_FM_SYNC_CNT_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 17 ; /* bits 16:0 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_DS_FM_SYNC_CNT_t;


#define XGPN_BWMP_US_MAP_CNT                     0xd0034670
#define XGPN_BWMP_US_MAP_CNT_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 17 ; /* bits 16:0 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_US_MAP_CNT_t;


#define XGPN_BWMP_US_XGEM_CNT                    0xd0034674
#define XGPN_BWMP_US_XGEM_CNT_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 17 ; /* bits 16:0 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_US_XGEM_CNT_t;


#define XGPN_BWMP_US_XGTC_CNT                    0xd0034678
#define XGPN_BWMP_US_XGTC_CNT_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 17 ; /* bits 16:0 */
    ca_uint32_t rsrvd1               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_BWMP_US_XGTC_CNT_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* bwmp */
typedef struct {
  XGPN_BWMP_GBL_CTRL_t                     GBL_CTRL;                      /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  XGPN_BWMP_RSP_TM_CFG_t                   RSP_TM_CFG;                    /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  XGPN_BWMP_BST_MG_CFG_t                   BST_MG_CFG;                    /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  XGPN_BWMP_SEQ_TM_CTRL_t                  SEQ_TM_CTRL;                   /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  XGPN_BWMP_GRT_MSG_CTL_t                  GRT_MSG_CTL;                   /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  XGPN_BWMP_GRT_MSG_DATA0_t                GRT_MSG_DATA0;                 /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  XGPN_BWMP_GRT_MSG_DATA1_t                GRT_MSG_DATA1;                 /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  XGPN_BWMP_GRT_FF_CTL_t                   GRT_FF_CTL;                    /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  XGPN_BWMP_GRT_FF_DATA0_t                 GRT_FF_DATA0;                  /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  XGPN_BWMP_GRT_FF_DATA1_t                 GRT_FF_DATA1;                  /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  XGPN_BWMP_BM_BUF_CFG_t                   BM_BUF_CFG;                    /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  XGPN_BWMP_INTERRUPT_t                    INTERRUPT;                     /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  XGPN_BWMP_INTERRUPTE0_t                  INTERRUPTE0;                   /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  XGPN_BWMP_INTERRUPTE1_t                  INTERRUPTE1;                   /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  XGPN_BWMP_ALLOC_LUT_ACCESS_t             ALLOC_LUT_ACCESS;              /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  XGPN_BWMP_ALLOC_LUT_DATA_t               ALLOC_LUT_DATA;                /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  XGPN_BWMP_ALLOC_LUT_DEBUG_t              ALLOC_LUT_DEBUG;               /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  XGPN_BWMP_EQD_STS_t                      EQD_STS;                       /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  XGPN_BWMP_RANDOM_DLY_STS_t               RANDOM_DLY_STS;                /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  XGPN_BWMP_LMT_DROP_SRC_STS_t             LMT_DROP_SRC_STS;              /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  XGPN_BWMP_BWMAP_GRT_FF_STS_t             BWMAP_GRT_FF_STS;              /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  XGPN_BWMP_XGTC_GRT_FF_STS_t              XGTC_GRT_FF_STS;               /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  XGPN_BWMP_BM_GRT_FF_STS_t                BM_GRT_FF_STS;                 /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  XGPN_BWMP_UNK_PF_MIB_t                   UNK_PF_MIB;                    /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  XGPN_BWMP_AS_CNT_t                       AS_CNT;                        /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  XGPN_BWMP_AS_HEC_ERR_CNT_t               AS_HEC_ERR_CNT;                /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  XGPN_BWMP_BWMAP_CNT_CTRL_t               BWMAP_CNT_CTRL;                /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  XGPN_BWMP_DS_FM_SYNC_CNT_t               DS_FM_SYNC_CNT;                /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  XGPN_BWMP_US_MAP_CNT_t                   US_MAP_CNT;                    /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  XGPN_BWMP_US_XGEM_CNT_t                  US_XGEM_CNT;                   /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  XGPN_BWMP_US_XGTC_CNT_t                  US_XGTC_CNT;                   /* addr: 0x00000078 */
} APB1_XGPN_BWMP_t;


/*
 * plmp
 */
        
#define XGPN_PLMP_CTRL                           0xd0034800
#define XGPN_PLMP_CTRL_dft                       0x0000007a

typedef volatile union {
  struct {
    ca_uint32_t sw_mode_en           :  1 ; /* bits 0:0 */
    ca_uint32_t dereg_rst_en         :  1 ; /* bits 1:1 */
    ca_uint32_t resrv_bc_en          :  1 ; /* bits 2:2 */
    ca_uint32_t resrv_id_sel         :  2 ; /* bits 4:3 */
    ca_uint32_t tuning_rst_en        :  1 ; /* bits 5:5 */
    ca_uint32_t tuning_mic_rst_en    :  1 ; /* bits 6:6 */
    ca_uint32_t rsrvd1               : 25 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_CTRL_t;


#define XGPN_PLMP_DS_CTRL                        0xd0034804
#define XGPN_PLMP_DS_CTRL_dft                    0x06000000

typedef volatile union {
  struct {
    ca_uint32_t mic_chk_dis          :  1 ; /* bits 0:0 */
    ca_uint32_t seq_chk_dis          :  1 ; /* bits 1:1 */
    ca_uint32_t onuid_flt_dis        :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t capt_msg_en          :  1 ; /* bits 4:4 */
    ca_uint32_t capt_msg_type        :  8 ; /* bits 12:5 */
    ca_uint32_t capt_onu_id          : 10 ; /* bits 22:13 */
    ca_uint32_t extension_en         :  1 ; /* bits 23:23 */
    ca_uint32_t unkwn_msg_type_en    :  1 ; /* bits 24:24 */
    ca_uint32_t dozing_filter_en     :  1 ; /* bits 25:25 */
    ca_uint32_t o7_filter_en         :  1 ; /* bits 26:26 */
    ca_uint32_t rsrvd2               :  2 ;
    ca_uint32_t pktgen_rdy_chk_en    :  1 ; /* bits 29:29 */
    ca_uint32_t extension_msg_type_en :  1 ; /* bits 30:30 */
    ca_uint32_t capt_msg_bpressure_en :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_DS_CTRL_t;


#define XGPN_PLMP_RX_CAPTURE                     0xd0034808
#define XGPN_PLMP_RX_CAPTURE_dft                 0xffffffff

typedef volatile union {
  struct {
    ca_uint32_t msg_en               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_RX_CAPTURE_t;


#define XGPN_PLMP_US_CTRL                        0xd003480c
#define XGPN_PLMP_US_CTRL_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mic_gen_dis          :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 31 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_US_CTRL_t;


#define XGPN_PLMP_VENDOR_ID_CFG                  0xd0034810
#define XGPN_PLMP_VENDOR_ID_CFG_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_VENDOR_ID_CFG_t;


#define XGPN_PLMP_VSSN_CFG                       0xd0034814
#define XGPN_PLMP_VSSN_CFG_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_VSSN_CFG_t;


#define XGPN_PLMP_CORRELATION                    0xd0034818
#define XGPN_PLMP_CORRELATION_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tag                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_CORRELATION_t;


#define XGPN_PLMP_US_PON_ID                      0xd003481c
#define XGPN_PLMP_US_PON_ID_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_US_PON_ID_t;


#define XGPN_PLMP_CALIBRATION_EVEN               0xd0034820
#define XGPN_PLMP_CALIBRATION_EVEN_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t record               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_CALIBRATION_EVEN_t;


#define XGPN_PLMP_CALIBRATION_ODD                0xd0034824
#define XGPN_PLMP_CALIBRATION_ODD_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t record               : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_CALIBRATION_ODD_t;


#define XGPN_PLMP_TUNING_PARAMETER               0xd0034828
#define XGPN_PLMP_TUNING_PARAMETER_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t granularity          :  8 ; /* bits 7:0 */
    ca_uint32_t time                 :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_TUNING_PARAMETER_t;


#define XGPN_PLMP_ATTENUATION                    0xd003482c
#define XGPN_PLMP_ATTENUATION_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t level                :  4 ; /* bits 3:0 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t capability           :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd2               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_ATTENUATION_t;


#define XGPN_PLMP_RGST_ID_CFG0                   0xd0034830
#define XGPN_PLMP_RGST_ID_CFG0_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_RGST_ID_CFG0_t;


#define XGPN_PLMP_RGST_ID_CFG1                   0xd0034834
#define XGPN_PLMP_RGST_ID_CFG1_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_RGST_ID_CFG1_t;


#define XGPN_PLMP_RGST_ID_CFG2                   0xd0034838
#define XGPN_PLMP_RGST_ID_CFG2_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_RGST_ID_CFG2_t;


#define XGPN_PLMP_RGST_ID_CFG3                   0xd003483c
#define XGPN_PLMP_RGST_ID_CFG3_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_RGST_ID_CFG3_t;


#define XGPN_PLMP_RGST_ID_CFG4                   0xd0034840
#define XGPN_PLMP_RGST_ID_CFG4_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_RGST_ID_CFG4_t;


#define XGPN_PLMP_RGST_ID_CFG5                   0xd0034844
#define XGPN_PLMP_RGST_ID_CFG5_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_RGST_ID_CFG5_t;


#define XGPN_PLMP_RGST_ID_CFG6                   0xd0034848
#define XGPN_PLMP_RGST_ID_CFG6_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_RGST_ID_CFG6_t;


#define XGPN_PLMP_RGST_ID_CFG7                   0xd003484c
#define XGPN_PLMP_RGST_ID_CFG7_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_RGST_ID_CFG7_t;


#define XGPN_PLMP_RGST_ID_CFG8                   0xd0034850
#define XGPN_PLMP_RGST_ID_CFG8_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_RGST_ID_CFG8_t;


#define XGPN_PLMP_TUNING_CONFIG                  0xd0034854
#define XGPN_PLMP_TUNING_CONFIG_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t request_schedule_sfc : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               :  6 ;
    ca_uint32_t skip_rx              :  1 ; /* bits 22:22 */
    ca_uint32_t rollback_allow       :  1 ; /* bits 23:23 */
    ca_uint32_t rsrvd2               :  4 ;
    ca_uint32_t request_lead_sfc     :  3 ; /* bits 30:28 */
    ca_uint32_t rsrvd3               :  1 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_TUNING_CONFIG_t;


#define XGPN_PLMP_SW_RESPONSE                    0xd0034858
#define XGPN_PLMP_SW_RESPONSE_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t tuning_request       :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               :  3 ;
    ca_uint32_t tuning_operation_code :  4 ; /* bits 7:4 */
    ca_uint32_t seqno                :  8 ; /* bits 15:8 */
    ca_uint32_t tuning_response_code : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_SW_RESPONSE_t;


#define XGPN_PLMP_EQD_THRSHLD                    0xd003485c
#define XGPN_PLMP_EQD_THRSHLD_dft                0x00097e00

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_EQD_THRSHLD_t;


#define XGPN_PLMP_ACK_PLOAM_NO_MSG0              0xd0034860
#define XGPN_PLMP_ACK_PLOAM_NO_MSG0_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mic                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_ACK_PLOAM_NO_MSG0_t;


#define XGPN_PLMP_ACK_PLOAM_NO_MSG1              0xd0034864
#define XGPN_PLMP_ACK_PLOAM_NO_MSG1_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mic                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_ACK_PLOAM_NO_MSG1_t;


#define XGPN_PLMP_ACK_PLOAM_BUSY_MSG_CFG         0xd0034868
#define XGPN_PLMP_ACK_PLOAM_BUSY_MSG_CFG_dft     0x00020000

typedef volatile union {
  struct {
    ca_uint32_t seq                  :  8 ; /* bits 7:0 */
    ca_uint32_t start                :  1 ; /* bits 8:8 */
    ca_uint32_t rsrvd1               :  7 ;
    ca_uint32_t complt_code          :  8 ; /* bits 23:16 */
    ca_uint32_t rsrvd2               :  7 ;
    ca_uint32_t ok                   :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_ACK_PLOAM_BUSY_MSG_CFG_t;


#define XGPN_PLMP_ACK_PLOAM_BUSY_MSG0            0xd003486c
#define XGPN_PLMP_ACK_PLOAM_BUSY_MSG0_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mic                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_ACK_PLOAM_BUSY_MSG0_t;


#define XGPN_PLMP_ACK_PLOAM_BUSY_MSG1            0xd0034870
#define XGPN_PLMP_ACK_PLOAM_BUSY_MSG1_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t mic                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_ACK_PLOAM_BUSY_MSG1_t;


#define XGPN_PLMP_PLOAM_CFG                      0xd0034874
#define XGPN_PLMP_PLOAM_CFG_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t done                 :  1 ; /* bits 0:0 */
    ca_uint32_t msg_type             :  8 ; /* bits 8:1 */
    ca_uint32_t rsrvd1               : 23 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_PLOAM_CFG_t;


#define XGPN_PLMP_PLOAM_CFG_DATA0                0xd0034878
#define XGPN_PLMP_PLOAM_CFG_DATA0_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_PLOAM_CFG_DATA0_t;


#define XGPN_PLMP_PLOAM_CFG_DATA1                0xd003487c
#define XGPN_PLMP_PLOAM_CFG_DATA1_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_PLOAM_CFG_DATA1_t;


#define XGPN_PLMP_PLOAM_CFG_DATA2                0xd0034880
#define XGPN_PLMP_PLOAM_CFG_DATA2_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_PLOAM_CFG_DATA2_t;


#define XGPN_PLMP_PLOAM_CFG_DATA3                0xd0034884
#define XGPN_PLMP_PLOAM_CFG_DATA3_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_PLOAM_CFG_DATA3_t;


#define XGPN_PLMP_PLOAM_CFG_DATA4                0xd0034888
#define XGPN_PLMP_PLOAM_CFG_DATA4_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_PLOAM_CFG_DATA4_t;


#define XGPN_PLMP_PLOAM_CFG_DATA5                0xd003488c
#define XGPN_PLMP_PLOAM_CFG_DATA5_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_PLOAM_CFG_DATA5_t;


#define XGPN_PLMP_PLOAM_CFG_DATA6                0xd0034890
#define XGPN_PLMP_PLOAM_CFG_DATA6_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_PLOAM_CFG_DATA6_t;


#define XGPN_PLMP_PLOAM_CFG_DATA7                0xd0034894
#define XGPN_PLMP_PLOAM_CFG_DATA7_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_PLOAM_CFG_DATA7_t;


#define XGPN_PLMP_PLOAM_CFG_DATA8                0xd0034898
#define XGPN_PLMP_PLOAM_CFG_DATA8_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_PLOAM_CFG_DATA8_t;


#define XGPN_PLMP_KEY_EXCHG_THRSHD               0xd003489c
#define XGPN_PLMP_KEY_EXCHG_THRSHD_dft           0x032000a0

typedef volatile union {
  struct {
    ca_uint32_t tk5_timeout          :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               :  8 ;
    ca_uint32_t tk4_timeout          : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_KEY_EXCHG_THRSHD_t;


#define XGPN_PLMP_INTERRUPT                      0xd00348a0
#define XGPN_PLMP_INTERRUPT_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wrong_onuid_intI     :  1 ; /* bits 0:0 */
    ca_uint32_t bc_seq_mismch_intI   :  1 ; /* bits 1:1 */
    ca_uint32_t uc_seq_mismch_intI   :  1 ; /* bits 2:2 */
    ca_uint32_t mic_chk_fail_intI    :  1 ; /* bits 3:3 */
    ca_uint32_t wrong_ploam_intI     :  1 ; /* bits 4:4 */
    ca_uint32_t key_exchg_tk4_timeout_intI :  1 ; /* bits 5:5 */
    ca_uint32_t key_exchg_tk5_timeout_intI :  1 ; /* bits 6:6 */
    ca_uint32_t key_ctrl_intI        :  1 ; /* bits 7:7 */
    ca_uint32_t sleep_allow_intI     :  1 ; /* bits 8:8 */
    ca_uint32_t sleep_req_done_intI  :  1 ; /* bits 9:9 */
    ca_uint32_t eqd_err_intI         :  1 ; /* bits 10:10 */
    ca_uint32_t busy_err_intI        :  1 ; /* bits 11:11 */
    ca_uint32_t registration_msg_intI :  1 ; /* bits 12:12 */
    ca_uint32_t burst_prfl_intI      :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t tuning_request       :  1 ; /* bits 16:16 */
    ca_uint32_t protection_ctrl      :  1 ; /* bits 17:17 */
    ca_uint32_t chng_pwr_level       :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t mib_sat              :  1 ; /* bits 20:20 */
    ca_uint32_t rsrvd3               :  7 ;
    ca_uint32_t sw_ploamd_overlap_drop :  1 ; /* bits 28:28 */
    ca_uint32_t sw_ploamd_full_drop  :  1 ; /* bits 29:29 */
    ca_uint32_t rxbuf0_rdy_intI      :  1 ; /* bits 30:30 */
    ca_uint32_t rxbuf1_rdy_intI      :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_INTERRUPT_t;


#define XGPN_PLMP_INTERRUPTE0                    0xd00348a4
#define XGPN_PLMP_INTERRUPTE0_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wrong_onuid_intIE    :  1 ; /* bits 0:0 */
    ca_uint32_t bc_seq_mismch_intIE  :  1 ; /* bits 1:1 */
    ca_uint32_t uc_seq_mismch_intIE  :  1 ; /* bits 2:2 */
    ca_uint32_t mic_chk_fail_intIE   :  1 ; /* bits 3:3 */
    ca_uint32_t wrong_ploam_intIE    :  1 ; /* bits 4:4 */
    ca_uint32_t key_exchg_tk4_timeout_intIE :  1 ; /* bits 5:5 */
    ca_uint32_t key_exchg_tk5_timeout_intIE :  1 ; /* bits 6:6 */
    ca_uint32_t key_ctrl_intIE       :  1 ; /* bits 7:7 */
    ca_uint32_t sleep_allow_intIE    :  1 ; /* bits 8:8 */
    ca_uint32_t sleep_req_done_intIE :  1 ; /* bits 9:9 */
    ca_uint32_t eqd_err_intIE        :  1 ; /* bits 10:10 */
    ca_uint32_t busy_err_intIE       :  1 ; /* bits 11:11 */
    ca_uint32_t registration_msg_intIE :  1 ; /* bits 12:12 */
    ca_uint32_t burst_prfl_intIE     :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t tuning_requestE      :  1 ; /* bits 16:16 */
    ca_uint32_t protection_ctrlE     :  1 ; /* bits 17:17 */
    ca_uint32_t chng_pwr_levelE      :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t mib_satE             :  1 ; /* bits 20:20 */
    ca_uint32_t rsrvd3               :  7 ;
    ca_uint32_t sw_ploamd_overlap_dropE :  1 ; /* bits 28:28 */
    ca_uint32_t sw_ploamd_full_dropE :  1 ; /* bits 29:29 */
    ca_uint32_t rxbuf0_rdy_intIE     :  1 ; /* bits 30:30 */
    ca_uint32_t rxbuf1_rdy_intIE     :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_INTERRUPTE0_t;


#define XGPN_PLMP_INTERRUPTE1                    0xd00348a8
#define XGPN_PLMP_INTERRUPTE1_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t wrong_onuid_intIE    :  1 ; /* bits 0:0 */
    ca_uint32_t bc_seq_mismch_intIE  :  1 ; /* bits 1:1 */
    ca_uint32_t uc_seq_mismch_intIE  :  1 ; /* bits 2:2 */
    ca_uint32_t mic_chk_fail_intIE   :  1 ; /* bits 3:3 */
    ca_uint32_t wrong_ploam_intIE    :  1 ; /* bits 4:4 */
    ca_uint32_t key_exchg_tk4_timeout_intIE :  1 ; /* bits 5:5 */
    ca_uint32_t key_exchg_tk5_timeout_intIE :  1 ; /* bits 6:6 */
    ca_uint32_t key_ctrl_intIE       :  1 ; /* bits 7:7 */
    ca_uint32_t sleep_allow_intIE    :  1 ; /* bits 8:8 */
    ca_uint32_t sleep_req_done_intIE :  1 ; /* bits 9:9 */
    ca_uint32_t eqd_err_intIE        :  1 ; /* bits 10:10 */
    ca_uint32_t busy_err_intIE       :  1 ; /* bits 11:11 */
    ca_uint32_t registration_msg_intIE :  1 ; /* bits 12:12 */
    ca_uint32_t burst_prfl_intIE     :  1 ; /* bits 13:13 */
    ca_uint32_t rsrvd1               :  2 ;
    ca_uint32_t tuning_requestE      :  1 ; /* bits 16:16 */
    ca_uint32_t protection_ctrlE     :  1 ; /* bits 17:17 */
    ca_uint32_t chng_pwr_levelE      :  1 ; /* bits 18:18 */
    ca_uint32_t rsrvd2               :  1 ;
    ca_uint32_t mib_satE             :  1 ; /* bits 20:20 */
    ca_uint32_t rsrvd3               :  7 ;
    ca_uint32_t sw_ploamd_overlap_dropE :  1 ; /* bits 28:28 */
    ca_uint32_t sw_ploamd_full_dropE :  1 ; /* bits 29:29 */
    ca_uint32_t rxbuf0_rdy_intIE     :  1 ; /* bits 30:30 */
    ca_uint32_t rxbuf1_rdy_intIE     :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_INTERRUPTE1_t;


#define XGPN_PLMP_MIB_SAT_INT                    0xd00348ac
#define XGPN_PLMP_MIB_SAT_INT_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t MIC_ERR_mib_sat      :  1 ; /* bits 0:0 */
    ca_uint32_t DS_RX_mib_sat        :  1 ; /* bits 1:1 */
    ca_uint32_t SYSTEM_PRFL_mib_sat  :  1 ; /* bits 2:2 */
    ca_uint32_t CHANNEL_PRFL_mib_sat :  1 ; /* bits 3:3 */
    ca_uint32_t PRFL_mib_sat         :  1 ; /* bits 4:4 */
    ca_uint32_t ASSGN_ONUID_mib_sat  :  1 ; /* bits 5:5 */
    ca_uint32_t RANGING_TIME_mib_sat :  1 ; /* bits 6:6 */
    ca_uint32_t PROTECT_CTRL_mib_sat :  1 ; /* bits 7:7 */
    ca_uint32_t ADJ_TX_WVLN_mib_sat  :  1 ; /* bits 8:8 */
    ca_uint32_t DEACTV_ONU_mib_sat   :  1 ; /* bits 9:9 */
    ca_uint32_t DISABLE_SN_mib_sat   :  1 ; /* bits 10:10 */
    ca_uint32_t REQ_REGST_mib_sat    :  1 ; /* bits 11:11 */
    ca_uint32_t ASSGN_ALLCTID_mib_sat :  1 ; /* bits 12:12 */
    ca_uint32_t KEY_CTRL_mib_sat     :  1 ; /* bits 13:13 */
    ca_uint32_t SLEEP_ALLW_mib_sat   :  1 ; /* bits 14:14 */
    ca_uint32_t TUNING_CTRL_REQ_mib_sat :  1 ; /* bits 15:15 */
    ca_uint32_t TUNING_CTRL_CMPLT_mib_sat :  1 ; /* bits 16:16 */
    ca_uint32_t CALIBRT_REQ_mib_sat  :  1 ; /* bits 17:17 */
    ca_uint32_t US_TX_mib_sat        :  1 ; /* bits 18:18 */
    ca_uint32_t SN_ONU_mib_sat       :  1 ; /* bits 19:19 */
    ca_uint32_t REGST_mib_sat        :  1 ; /* bits 20:20 */
    ca_uint32_t ACK_mib_sat          :  1 ; /* bits 21:21 */
    ca_uint32_t KEY_REPORT_mib_sat   :  1 ; /* bits 22:22 */
    ca_uint32_t SLEEP_REQ_mib_sat    :  1 ; /* bits 23:23 */
    ca_uint32_t TUN_REQ_RSP_mib_sat  :  1 ; /* bits 24:24 */
    ca_uint32_t TUN_CMPLTU_mib_sat   :  1 ; /* bits 25:25 */
    ca_uint32_t PWR_CNSMPT_RPT_mib_sat :  1 ; /* bits 26:26 */
    ca_uint32_t SW_PLOAMD_FULL_DROP_mib_sat :  1 ; /* bits 27:27 */
    ca_uint32_t SW_PLOAMD_OVERLAP_DROP_mib_sat :  1 ; /* bits 28:28 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_MIB_SAT_INT_t;


#define XGPN_PLMP_MIB_SAT_INTE                   0xd00348b0
#define XGPN_PLMP_MIB_SAT_INTE_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t MIC_ERR_mib_satE     :  1 ; /* bits 0:0 */
    ca_uint32_t DS_RX_mib_satE       :  1 ; /* bits 1:1 */
    ca_uint32_t SYSTEM_PRFL_mib_satE :  1 ; /* bits 2:2 */
    ca_uint32_t CHANNEL_PRFL_mib_satE :  1 ; /* bits 3:3 */
    ca_uint32_t PRFL_mib_satE        :  1 ; /* bits 4:4 */
    ca_uint32_t ASSGN_ONUID_mib_satE :  1 ; /* bits 5:5 */
    ca_uint32_t RANGING_TIME_mib_satE :  1 ; /* bits 6:6 */
    ca_uint32_t PROTECT_CTRL_mib_satE :  1 ; /* bits 7:7 */
    ca_uint32_t ADJ_TX_WVLN_mib_satE :  1 ; /* bits 8:8 */
    ca_uint32_t DEACTV_ONU_mib_satE  :  1 ; /* bits 9:9 */
    ca_uint32_t DISABLE_SN_mib_satE  :  1 ; /* bits 10:10 */
    ca_uint32_t REQ_REGST_mib_satE   :  1 ; /* bits 11:11 */
    ca_uint32_t ASSGN_ALLCTID_mib_satE :  1 ; /* bits 12:12 */
    ca_uint32_t KEY_CTRL_mib_satE    :  1 ; /* bits 13:13 */
    ca_uint32_t SLEEP_ALLW_mib_satE  :  1 ; /* bits 14:14 */
    ca_uint32_t TUNING_CTRL_REQ_mib_satE :  1 ; /* bits 15:15 */
    ca_uint32_t TUNING_CTRL_CMPLT_mib_satE :  1 ; /* bits 16:16 */
    ca_uint32_t CALIBRT_REQ_mib_satE :  1 ; /* bits 17:17 */
    ca_uint32_t US_TX_mib_satE       :  1 ; /* bits 18:18 */
    ca_uint32_t SN_ONU_mib_satE      :  1 ; /* bits 19:19 */
    ca_uint32_t REGST_mib_satE       :  1 ; /* bits 20:20 */
    ca_uint32_t ACK_mib_satE         :  1 ; /* bits 21:21 */
    ca_uint32_t KEY_REPORT_mib_satE  :  1 ; /* bits 22:22 */
    ca_uint32_t SLEEP_REQ_mib_satE   :  1 ; /* bits 23:23 */
    ca_uint32_t TUN_REQ_RSP_mib_satE :  1 ; /* bits 24:24 */
    ca_uint32_t TUN_CMPLTU_mib_satE  :  1 ; /* bits 25:25 */
    ca_uint32_t PWR_CNSMPT_RPT_mib_satE :  1 ; /* bits 26:26 */
    ca_uint32_t SW_PLOAMD_FULL_DROP_mib_satE :  1 ; /* bits 27:27 */
    ca_uint32_t SW_PLOAMD_OVERLAP_DROP_mib_satE :  1 ; /* bits 28:28 */
    ca_uint32_t rsrvd1               :  3 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_MIB_SAT_INTE_t;


#define XGPN_PLMP_KEY_CTRL_STAT                  0xd00348b4
#define XGPN_PLMP_KEY_CTRL_STAT_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t seq                  :  8 ; /* bits 7:0 */
    ca_uint32_t type                 :  8 ; /* bits 15:8 */
    ca_uint32_t index                :  8 ; /* bits 23:16 */
    ca_uint32_t length               :  8 ; /* bits 31:24 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_KEY_CTRL_STAT_t;


#define XGPN_PLMP_KEY_REPORT                     0xd00348b8
#define XGPN_PLMP_KEY_REPORT_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t seq                  :  8 ; /* bits 7:0 */
    ca_uint32_t type                 :  8 ; /* bits 15:8 */
    ca_uint32_t index                :  8 ; /* bits 23:16 */
    ca_uint32_t fragment_num         :  3 ; /* bits 26:24 */
    ca_uint32_t rsrvd1               :  4 ;
    ca_uint32_t rdy                  :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_KEY_REPORT_t;


#define XGPN_PLMP_KEY_REPORT_FRAG0               0xd00348bc
#define XGPN_PLMP_KEY_REPORT_FRAG0_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_KEY_REPORT_FRAG0_t;


#define XGPN_PLMP_KEY_REPORT_FRAG1               0xd00348c0
#define XGPN_PLMP_KEY_REPORT_FRAG1_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_KEY_REPORT_FRAG1_t;


#define XGPN_PLMP_KEY_REPORT_FRAG2               0xd00348c4
#define XGPN_PLMP_KEY_REPORT_FRAG2_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_KEY_REPORT_FRAG2_t;


#define XGPN_PLMP_KEY_REPORT_FRAG3               0xd00348c8
#define XGPN_PLMP_KEY_REPORT_FRAG3_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_KEY_REPORT_FRAG3_t;


#define XGPN_PLMP_SLEEP_ALLOW_STAT               0xd00348cc
#define XGPN_PLMP_SLEEP_ALLOW_STAT_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t seq                  :  8 ; /* bits 7:0 */
    ca_uint32_t type                 :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_SLEEP_ALLOW_STAT_t;


#define XGPN_PLMP_SLEEP_REQ                      0xd00348d0
#define XGPN_PLMP_SLEEP_REQ_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t activity_level       :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 23 ;
    ca_uint32_t rdy                  :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_SLEEP_REQ_t;


#define XGPN_PLMP_SW_ACK                         0xd00348d4
#define XGPN_PLMP_SW_ACK_dft                     0x00000000

typedef volatile union {
  struct {
    ca_uint32_t complt_code          :  8 ; /* bits 7:0 */
    ca_uint32_t seqno                :  8 ; /* bits 15:8 */
    ca_uint32_t rsrvd1               : 14 ;
    ca_uint32_t chng_pwr_level       :  1 ; /* bits 30:30 */
    ca_uint32_t protect_ctrl         :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_SW_ACK_t;


#define XGPN_PLMP_CH0_POWER_CONSUMPTION          0xd00348d8
#define XGPN_PLMP_CH0_POWER_CONSUMPTION_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t indicate             : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_CH0_POWER_CONSUMPTION_t;


#define XGPN_PLMP_CH1_POWER_CONSUMPTION          0xd00348dc
#define XGPN_PLMP_CH1_POWER_CONSUMPTION_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t indicate             : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_CH1_POWER_CONSUMPTION_t;


#define XGPN_PLMP_CH2_POWER_CONSUMPTION          0xd00348e0
#define XGPN_PLMP_CH2_POWER_CONSUMPTION_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t indicate             : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_CH2_POWER_CONSUMPTION_t;


#define XGPN_PLMP_CH3_POWER_CONSUMPTION          0xd00348e4
#define XGPN_PLMP_CH3_POWER_CONSUMPTION_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t indicate             : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_CH3_POWER_CONSUMPTION_t;


#define XGPN_PLMP_CH4_POWER_CONSUMPTION          0xd00348e8
#define XGPN_PLMP_CH4_POWER_CONSUMPTION_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t indicate             : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_CH4_POWER_CONSUMPTION_t;


#define XGPN_PLMP_CH5_POWER_CONSUMPTION          0xd00348ec
#define XGPN_PLMP_CH5_POWER_CONSUMPTION_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t indicate             : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_CH5_POWER_CONSUMPTION_t;


#define XGPN_PLMP_CH6_POWER_CONSUMPTION          0xd00348f0
#define XGPN_PLMP_CH6_POWER_CONSUMPTION_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t indicate             : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_CH6_POWER_CONSUMPTION_t;


#define XGPN_PLMP_CH7_POWER_CONSUMPTION          0xd00348f4
#define XGPN_PLMP_CH7_POWER_CONSUMPTION_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t indicate             : 24 ; /* bits 23:0 */
    ca_uint32_t rsrvd1               :  8 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_CH7_POWER_CONSUMPTION_t;


#define XGPN_PLMP_TXBUF_CTRL                     0xd00348f8
#define XGPN_PLMP_TXBUF_CTRL_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t defkey               :  1 ; /* bits 0:0 */
    ca_uint32_t rsrvd1               : 30 ;
    ca_uint32_t pkt_rdy              :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_TXBUF_CTRL_t;


#define XGPN_PLMP_TXBUF_DATA0                    0xd00348fc
#define XGPN_PLMP_TXBUF_DATA0_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_TXBUF_DATA0_t;


#define XGPN_PLMP_TXBUF_DATA1                    0xd0034900
#define XGPN_PLMP_TXBUF_DATA1_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_TXBUF_DATA1_t;


#define XGPN_PLMP_TXBUF_DATA2                    0xd0034904
#define XGPN_PLMP_TXBUF_DATA2_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_TXBUF_DATA2_t;


#define XGPN_PLMP_TXBUF_DATA3                    0xd0034908
#define XGPN_PLMP_TXBUF_DATA3_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_TXBUF_DATA3_t;


#define XGPN_PLMP_TXBUF_DATA4                    0xd003490c
#define XGPN_PLMP_TXBUF_DATA4_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_TXBUF_DATA4_t;


#define XGPN_PLMP_TXBUF_DATA5                    0xd0034910
#define XGPN_PLMP_TXBUF_DATA5_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_TXBUF_DATA5_t;


#define XGPN_PLMP_TXBUF_DATA6                    0xd0034914
#define XGPN_PLMP_TXBUF_DATA6_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_TXBUF_DATA6_t;


#define XGPN_PLMP_TXBUF_DATA7                    0xd0034918
#define XGPN_PLMP_TXBUF_DATA7_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_TXBUF_DATA7_t;


#define XGPN_PLMP_TXBUF_DATA8                    0xd003491c
#define XGPN_PLMP_TXBUF_DATA8_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_TXBUF_DATA8_t;


#define XGPN_PLMP_TXBUF_DATA9                    0xd0034920
#define XGPN_PLMP_TXBUF_DATA9_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t value                : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_TXBUF_DATA9_t;


#define XGPN_PLMP_RXBUF0_STAT                    0xd0034924
#define XGPN_PLMP_RXBUF0_STAT_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 15 ;
    ca_uint32_t mic_err              :  1 ; /* bits 15:15 */
    ca_uint32_t rx_sfc               :  4 ; /* bits 19:16 */
    ca_uint32_t rsrvd2               : 10 ;
    ca_uint32_t turn                 :  1 ; /* bits 30:30 */
    ca_uint32_t pkt_rdy              :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_RXBUF0_STAT_t;


#define XGPN_PLMP_RXBUF1_STAT                    0xd0034928
#define XGPN_PLMP_RXBUF1_STAT_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rsrvd1               : 15 ;
    ca_uint32_t mic_err              :  1 ; /* bits 15:15 */
    ca_uint32_t rx_sfc               :  4 ; /* bits 19:16 */
    ca_uint32_t rsrvd2               : 10 ;
    ca_uint32_t turn                 :  1 ; /* bits 30:30 */
    ca_uint32_t pkt_rdy              :  1 ; /* bits 31:31 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_RXBUF1_STAT_t;


#define XGPN_PLMP_RXBUF                          0xd0034980
#define XGPN_PLMP_RXBUF_STRIDE                   4
#define XGPN_PLMP_RXBUF_COUNT                    24
#define XGPN_PLMP_RXBUF_dft                      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t data                 : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_RXBUF_t;


#define XGPN_PLMP_MIC_ERR_MIB                    0xd0034a00
#define XGPN_PLMP_MIC_ERR_MIB_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_MIC_ERR_MIB_t;


#define XGPN_PLMP_DS_RX_MIB                      0xd0034a04
#define XGPN_PLMP_DS_RX_MIB_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_DS_RX_MIB_t;


#define XGPN_PLMP_SYSTEM_PRFL_MIB                0xd0034a08
#define XGPN_PLMP_SYSTEM_PRFL_MIB_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_SYSTEM_PRFL_MIB_t;


#define XGPN_PLMP_CHANNEL_PRFL_MIB               0xd0034a0c
#define XGPN_PLMP_CHANNEL_PRFL_MIB_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_CHANNEL_PRFL_MIB_t;


#define XGPN_PLMP_PRFL_MIB                       0xd0034a10
#define XGPN_PLMP_PRFL_MIB_dft                   0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_PRFL_MIB_t;


#define XGPN_PLMP_ASSGN_ONUID_MIB                0xd0034a14
#define XGPN_PLMP_ASSGN_ONUID_MIB_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_ASSGN_ONUID_MIB_t;


#define XGPN_PLMP_RANGING_TIME_MIB               0xd0034a18
#define XGPN_PLMP_RANGING_TIME_MIB_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_RANGING_TIME_MIB_t;


#define XGPN_PLMP_PROTECT_CTRL_MIB               0xd0034a1c
#define XGPN_PLMP_PROTECT_CTRL_MIB_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_PROTECT_CTRL_MIB_t;


#define XGPN_PLMP_ADJ_TX_WVLN_MIB                0xd0034a20
#define XGPN_PLMP_ADJ_TX_WVLN_MIB_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_ADJ_TX_WVLN_MIB_t;


#define XGPN_PLMP_DEACTV_ONU_MIB                 0xd0034a24
#define XGPN_PLMP_DEACTV_ONU_MIB_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_DEACTV_ONU_MIB_t;


#define XGPN_PLMP_DISABLE_SN_MIB                 0xd0034a28
#define XGPN_PLMP_DISABLE_SN_MIB_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_DISABLE_SN_MIB_t;


#define XGPN_PLMP_REQ_REGST_MIB                  0xd0034a2c
#define XGPN_PLMP_REQ_REGST_MIB_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_REQ_REGST_MIB_t;


#define XGPN_PLMP_ASSGN_ALLCTID_MIB              0xd0034a30
#define XGPN_PLMP_ASSGN_ALLCTID_MIB_dft          0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_ASSGN_ALLCTID_MIB_t;


#define XGPN_PLMP_KEY_CTRL_MIB                   0xd0034a34
#define XGPN_PLMP_KEY_CTRL_MIB_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_KEY_CTRL_MIB_t;


#define XGPN_PLMP_SLEEP_ALLW_MIB                 0xd0034a38
#define XGPN_PLMP_SLEEP_ALLW_MIB_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_SLEEP_ALLW_MIB_t;


#define XGPN_PLMP_TUNING_CTRL_REQ_MIB            0xd0034a3c
#define XGPN_PLMP_TUNING_CTRL_REQ_MIB_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_TUNING_CTRL_REQ_MIB_t;


#define XGPN_PLMP_TUNING_CTRL_CMPLT_MIB          0xd0034a40
#define XGPN_PLMP_TUNING_CTRL_CMPLT_MIB_dft      0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_TUNING_CTRL_CMPLT_MIB_t;


#define XGPN_PLMP_CALIBRT_REQ_MIB                0xd0034a44
#define XGPN_PLMP_CALIBRT_REQ_MIB_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_CALIBRT_REQ_MIB_t;


#define XGPN_PLMP_US_TX_MIB                      0xd0034a48
#define XGPN_PLMP_US_TX_MIB_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_US_TX_MIB_t;


#define XGPN_PLMP_SN_ONU_MIB                     0xd0034a4c
#define XGPN_PLMP_SN_ONU_MIB_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_SN_ONU_MIB_t;


#define XGPN_PLMP_REGST_MIB                      0xd0034a50
#define XGPN_PLMP_REGST_MIB_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_REGST_MIB_t;


#define XGPN_PLMP_ACK_MIB                        0xd0034a54
#define XGPN_PLMP_ACK_MIB_dft                    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_ACK_MIB_t;


#define XGPN_PLMP_KEY_REPORT_MIB                 0xd0034a58
#define XGPN_PLMP_KEY_REPORT_MIB_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_KEY_REPORT_MIB_t;


#define XGPN_PLMP_SLEEP_REQ_MIB                  0xd0034a5c
#define XGPN_PLMP_SLEEP_REQ_MIB_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_SLEEP_REQ_MIB_t;


#define XGPN_PLMP_TUN_REQ_RSP_MIB                0xd0034a60
#define XGPN_PLMP_TUN_REQ_RSP_MIB_dft            0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_TUN_REQ_RSP_MIB_t;


#define XGPN_PLMP_TUN_CMPLTU_MIB                 0xd0034a64
#define XGPN_PLMP_TUN_CMPLTU_MIB_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_TUN_CMPLTU_MIB_t;


#define XGPN_PLMP_PWR_CNSMPT_RPT_MIB             0xd0034a68
#define XGPN_PLMP_PWR_CNSMPT_RPT_MIB_dft         0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_PWR_CNSMPT_RPT_MIB_t;


#define XGPN_PLMP_DEBUG_STS0                     0xd0034a6c
#define XGPN_PLMP_DEBUG_STS0_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sn_random_delay      : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_DEBUG_STS0_t;


#define XGPN_PLMP_DEBUG_STS1                     0xd0034a70
#define XGPN_PLMP_DEBUG_STS1_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pon_tag_low          : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_DEBUG_STS1_t;


#define XGPN_PLMP_DEBUG_STS2                     0xd0034a74
#define XGPN_PLMP_DEBUG_STS2_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pon_tag_high         : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_DEBUG_STS2_t;


#define XGPN_PLMP_BC_PLOAM_SEQ                   0xd0034a78
#define XGPN_PLMP_BC_PLOAM_SEQ_dft               0x00000001

typedef volatile union {
  struct {
    ca_uint32_t number               :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_BC_PLOAM_SEQ_t;


#define XGPN_PLMP_UC_PLOAM_SEQ                   0xd0034a7c
#define XGPN_PLMP_UC_PLOAM_SEQ_dft               0x00000001

typedef volatile union {
  struct {
    ca_uint32_t number               :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_UC_PLOAM_SEQ_t;


#define XGPN_PLMP_BC_MSG_CNT                     0xd0034a80
#define XGPN_PLMP_BC_MSG_CNT_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t deact_onu_pkt        :  4 ; /* bits 3:0 */
    ca_uint32_t assgn_eqd_pkt        :  4 ; /* bits 7:4 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_BC_MSG_CNT_t;


#define XGPN_PLMP_ENABLE_ONU_CNT                 0xd0034a84
#define XGPN_PLMP_ENABLE_ONU_CNT_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_ENABLE_ONU_CNT_t;


#define XGPN_PLMP_UC_UPDT_PRFL_CNT               0xd0034a88
#define XGPN_PLMP_UC_UPDT_PRFL_CNT_dft           0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_UC_UPDT_PRFL_CNT_t;


#define XGPN_PLMP_EXTENSION_CNT                  0xd0034a8c
#define XGPN_PLMP_EXTENSION_CNT_dft              0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_EXTENSION_CNT_t;


#define XGPN_PLMP_REGST_CNT                      0xd0034a90
#define XGPN_PLMP_REGST_CNT_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t rang_gnt_pkt         : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_REGST_CNT_t;


#define XGPN_PLMP_ACK_OK_CNT                     0xd0034a94
#define XGPN_PLMP_ACK_OK_CNT_dft                 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_ACK_OK_CNT_t;


#define XGPN_PLMP_PLOAMD_ERR_CNT                 0xd0034a98
#define XGPN_PLMP_PLOAMD_ERR_CNT_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_PLOAMD_ERR_CNT_t;


#define XGPN_PLMP_DS_TX_CNT                      0xd0034a9c
#define XGPN_PLMP_DS_TX_CNT_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_DS_TX_CNT_t;


#define XGPN_PLMP_DS_DROP_CNT                    0xd0034aa0
#define XGPN_PLMP_DS_DROP_CNT_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t bc_pkt               : 16 ; /* bits 15:0 */
    ca_uint32_t uc_pkt               : 16 ; /* bits 31:16 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_DS_DROP_CNT_t;


#define XGPN_PLMP_RX_FF_DROP_CNT                 0xd0034aa4
#define XGPN_PLMP_RX_FF_DROP_CNT_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_RX_FF_DROP_CNT_t;


#define XGPN_PLMP_EXTEN_DROP_CNT                 0xd0034aa8
#define XGPN_PLMP_EXTEN_DROP_CNT_dft             0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt                  : 16 ; /* bits 15:0 */
    ca_uint32_t rsrvd1               : 16 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_EXTEN_DROP_CNT_t;


#define XGPN_PLMP_US_RX_CNT                      0xd0034aac
#define XGPN_PLMP_US_RX_CNT_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_US_RX_CNT_t;


#define XGPN_PLMP_US_SW_TX_CNT                   0xd0034ab0
#define XGPN_PLMP_US_SW_TX_CNT_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t pkt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_US_SW_TX_CNT_t;


#define XGPN_PLMP_DS_SW_RX_CNT                   0xd0034ab4
#define XGPN_PLMP_DS_SW_RX_CNT_dft               0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cnt                  : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_DS_SW_RX_CNT_t;


#define XGPN_PLMP_EXTENSION_MSG_TYPE             0xd0034ab8
#define XGPN_PLMP_EXTENSION_MSG_TYPE_dft         0xfffbd985

typedef volatile union {
  struct {
    ca_uint32_t en                   : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_EXTENSION_MSG_TYPE_t;


#define XGPN_PLMP_PLOAM_PKT_GEN_FIFO_CTRL        0xd0034abc
#define XGPN_PLMP_PLOAM_PKT_GEN_FIFO_CTRL_dft    0x00000007

typedef volatile union {
  struct {
    ca_uint32_t threshold            :  5 ; /* bits 4:0 */
    ca_uint32_t rsrvd1               : 27 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_PLOAM_PKT_GEN_FIFO_CTRL_t;


#define XGPN_PLMP_PLOAM_MSG_DROP_CNTR            0xd0034ac0
#define XGPN_PLMP_PLOAM_MSG_DROP_CNTR_dft        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cntr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_PLOAM_MSG_DROP_CNTR_t;


#define XGPN_PLMP_SW_PLOAMD_FULL_DROP_MIB        0xd0034ac4
#define XGPN_PLMP_SW_PLOAMD_FULL_DROP_MIB_dft    0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cntr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_SW_PLOAMD_FULL_DROP_MIB_t;


#define XGPN_PLMP_SW_PLOAMD_OVERLAP_DROP_MIB     0xd0034ac8
#define XGPN_PLMP_SW_PLOAMD_OVERLAP_DROP_MIB_dft 0x00000000

typedef volatile union {
  struct {
    ca_uint32_t cntr                 :  8 ; /* bits 7:0 */
    ca_uint32_t rsrvd1               : 24 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_PLMP_SW_PLOAMD_OVERLAP_DROP_MIB_t;

    
  
    
      
/******************************************************************
 *
 * Block declaration
 *
 ******************************************************************/

/* plmp */
typedef struct {
  XGPN_PLMP_CTRL_t                         CTRL;                          /* addr: 0x00000000 */
  ca_uint32_t                              rsrvd1[3];                    
  XGPN_PLMP_DS_CTRL_t                      DS_CTRL;                       /* addr: 0x00000004 */
  ca_uint32_t                              rsrvd2[3];                    
  XGPN_PLMP_RX_CAPTURE_t                   RX_CAPTURE;                    /* addr: 0x00000008 */
  ca_uint32_t                              rsrvd3[3];                    
  XGPN_PLMP_US_CTRL_t                      US_CTRL;                       /* addr: 0x0000000c */
  ca_uint32_t                              rsrvd4[3];                    
  XGPN_PLMP_VENDOR_ID_CFG_t                VENDOR_ID_CFG;                 /* addr: 0x00000010 */
  ca_uint32_t                              rsrvd5[3];                    
  XGPN_PLMP_VSSN_CFG_t                     VSSN_CFG;                      /* addr: 0x00000014 */
  ca_uint32_t                              rsrvd6[3];                    
  XGPN_PLMP_CORRELATION_t                  CORRELATION;                   /* addr: 0x00000018 */
  ca_uint32_t                              rsrvd7[3];                    
  XGPN_PLMP_US_PON_ID_t                    US_PON_ID;                     /* addr: 0x0000001c */
  ca_uint32_t                              rsrvd8[3];                    
  XGPN_PLMP_CALIBRATION_EVEN_t             CALIBRATION_EVEN;              /* addr: 0x00000020 */
  ca_uint32_t                              rsrvd9[3];                    
  XGPN_PLMP_CALIBRATION_ODD_t              CALIBRATION_ODD;               /* addr: 0x00000024 */
  ca_uint32_t                              rsrvd10[3];                   
  XGPN_PLMP_TUNING_PARAMETER_t             TUNING_PARAMETER;              /* addr: 0x00000028 */
  ca_uint32_t                              rsrvd11[3];                   
  XGPN_PLMP_ATTENUATION_t                  ATTENUATION;                   /* addr: 0x0000002c */
  ca_uint32_t                              rsrvd12[3];                   
  XGPN_PLMP_RGST_ID_CFG0_t                 RGST_ID_CFG0;                  /* addr: 0x00000030 */
  ca_uint32_t                              rsrvd13[3];                   
  XGPN_PLMP_RGST_ID_CFG1_t                 RGST_ID_CFG1;                  /* addr: 0x00000034 */
  ca_uint32_t                              rsrvd14[3];                   
  XGPN_PLMP_RGST_ID_CFG2_t                 RGST_ID_CFG2;                  /* addr: 0x00000038 */
  ca_uint32_t                              rsrvd15[3];                   
  XGPN_PLMP_RGST_ID_CFG3_t                 RGST_ID_CFG3;                  /* addr: 0x0000003c */
  ca_uint32_t                              rsrvd16[3];                   
  XGPN_PLMP_RGST_ID_CFG4_t                 RGST_ID_CFG4;                  /* addr: 0x00000040 */
  ca_uint32_t                              rsrvd17[3];                   
  XGPN_PLMP_RGST_ID_CFG5_t                 RGST_ID_CFG5;                  /* addr: 0x00000044 */
  ca_uint32_t                              rsrvd18[3];                   
  XGPN_PLMP_RGST_ID_CFG6_t                 RGST_ID_CFG6;                  /* addr: 0x00000048 */
  ca_uint32_t                              rsrvd19[3];                   
  XGPN_PLMP_RGST_ID_CFG7_t                 RGST_ID_CFG7;                  /* addr: 0x0000004c */
  ca_uint32_t                              rsrvd20[3];                   
  XGPN_PLMP_RGST_ID_CFG8_t                 RGST_ID_CFG8;                  /* addr: 0x00000050 */
  ca_uint32_t                              rsrvd21[3];                   
  XGPN_PLMP_TUNING_CONFIG_t                TUNING_CONFIG;                 /* addr: 0x00000054 */
  ca_uint32_t                              rsrvd22[3];                   
  XGPN_PLMP_SW_RESPONSE_t                  SW_RESPONSE;                   /* addr: 0x00000058 */
  ca_uint32_t                              rsrvd23[3];                   
  XGPN_PLMP_EQD_THRSHLD_t                  EQD_THRSHLD;                   /* addr: 0x0000005c */
  ca_uint32_t                              rsrvd24[3];                   
  XGPN_PLMP_ACK_PLOAM_NO_MSG0_t            ACK_PLOAM_NO_MSG0;             /* addr: 0x00000060 */
  ca_uint32_t                              rsrvd25[3];                   
  XGPN_PLMP_ACK_PLOAM_NO_MSG1_t            ACK_PLOAM_NO_MSG1;             /* addr: 0x00000064 */
  ca_uint32_t                              rsrvd26[3];                   
  XGPN_PLMP_ACK_PLOAM_BUSY_MSG_CFG_t       ACK_PLOAM_BUSY_MSG_CFG;        /* addr: 0x00000068 */
  ca_uint32_t                              rsrvd27[3];                   
  XGPN_PLMP_ACK_PLOAM_BUSY_MSG0_t          ACK_PLOAM_BUSY_MSG0;           /* addr: 0x0000006c */
  ca_uint32_t                              rsrvd28[3];                   
  XGPN_PLMP_ACK_PLOAM_BUSY_MSG1_t          ACK_PLOAM_BUSY_MSG1;           /* addr: 0x00000070 */
  ca_uint32_t                              rsrvd29[3];                   
  XGPN_PLMP_PLOAM_CFG_t                    PLOAM_CFG;                     /* addr: 0x00000074 */
  ca_uint32_t                              rsrvd30[3];                   
  XGPN_PLMP_PLOAM_CFG_DATA0_t              PLOAM_CFG_DATA0;               /* addr: 0x00000078 */
  ca_uint32_t                              rsrvd31[3];                   
  XGPN_PLMP_PLOAM_CFG_DATA1_t              PLOAM_CFG_DATA1;               /* addr: 0x0000007c */
  ca_uint32_t                              rsrvd32[3];                   
  XGPN_PLMP_PLOAM_CFG_DATA2_t              PLOAM_CFG_DATA2;               /* addr: 0x00000080 */
  ca_uint32_t                              rsrvd33[3];                   
  XGPN_PLMP_PLOAM_CFG_DATA3_t              PLOAM_CFG_DATA3;               /* addr: 0x00000084 */
  ca_uint32_t                              rsrvd34[3];                   
  XGPN_PLMP_PLOAM_CFG_DATA4_t              PLOAM_CFG_DATA4;               /* addr: 0x00000088 */
  ca_uint32_t                              rsrvd35[3];                   
  XGPN_PLMP_PLOAM_CFG_DATA5_t              PLOAM_CFG_DATA5;               /* addr: 0x0000008c */
  ca_uint32_t                              rsrvd36[3];                   
  XGPN_PLMP_PLOAM_CFG_DATA6_t              PLOAM_CFG_DATA6;               /* addr: 0x00000090 */
  ca_uint32_t                              rsrvd37[3];                   
  XGPN_PLMP_PLOAM_CFG_DATA7_t              PLOAM_CFG_DATA7;               /* addr: 0x00000094 */
  ca_uint32_t                              rsrvd38[3];                   
  XGPN_PLMP_PLOAM_CFG_DATA8_t              PLOAM_CFG_DATA8;               /* addr: 0x00000098 */
  ca_uint32_t                              rsrvd39[3];                   
  XGPN_PLMP_KEY_EXCHG_THRSHD_t             KEY_EXCHG_THRSHD;              /* addr: 0x0000009c */
  ca_uint32_t                              rsrvd40[3];                   
  XGPN_PLMP_INTERRUPT_t                    INTERRUPT;                     /* addr: 0x000000a0 */
  ca_uint32_t                              rsrvd41[3];                   
  XGPN_PLMP_INTERRUPTE0_t                  INTERRUPTE0;                   /* addr: 0x000000a4 */
  ca_uint32_t                              rsrvd42[3];                   
  XGPN_PLMP_INTERRUPTE1_t                  INTERRUPTE1;                   /* addr: 0x000000a8 */
  ca_uint32_t                              rsrvd43[3];                   
  XGPN_PLMP_MIB_SAT_INT_t                  MIB_SAT_INT;                   /* addr: 0x000000ac */
  ca_uint32_t                              rsrvd44[3];                   
  XGPN_PLMP_MIB_SAT_INTE_t                 MIB_SAT_INTE;                  /* addr: 0x000000b0 */
  ca_uint32_t                              rsrvd45[3];                   
  XGPN_PLMP_KEY_CTRL_STAT_t                KEY_CTRL_STAT;                 /* addr: 0x000000b4 */
  ca_uint32_t                              rsrvd46[3];                   
  XGPN_PLMP_KEY_REPORT_t                   KEY_REPORT;                    /* addr: 0x000000b8 */
  ca_uint32_t                              rsrvd47[3];                   
  XGPN_PLMP_KEY_REPORT_FRAG0_t             KEY_REPORT_FRAG0;              /* addr: 0x000000bc */
  ca_uint32_t                              rsrvd48[3];                   
  XGPN_PLMP_KEY_REPORT_FRAG1_t             KEY_REPORT_FRAG1;              /* addr: 0x000000c0 */
  ca_uint32_t                              rsrvd49[3];                   
  XGPN_PLMP_KEY_REPORT_FRAG2_t             KEY_REPORT_FRAG2;              /* addr: 0x000000c4 */
  ca_uint32_t                              rsrvd50[3];                   
  XGPN_PLMP_KEY_REPORT_FRAG3_t             KEY_REPORT_FRAG3;              /* addr: 0x000000c8 */
  ca_uint32_t                              rsrvd51[3];                   
  XGPN_PLMP_SLEEP_ALLOW_STAT_t             SLEEP_ALLOW_STAT;              /* addr: 0x000000cc */
  ca_uint32_t                              rsrvd52[3];                   
  XGPN_PLMP_SLEEP_REQ_t                    SLEEP_REQ;                     /* addr: 0x000000d0 */
  ca_uint32_t                              rsrvd53[3];                   
  XGPN_PLMP_SW_ACK_t                       SW_ACK;                        /* addr: 0x000000d4 */
  ca_uint32_t                              rsrvd54[3];                   
  XGPN_PLMP_CH0_POWER_CONSUMPTION_t        CH0_POWER_CONSUMPTION;         /* addr: 0x000000d8 */
  ca_uint32_t                              rsrvd55[3];                   
  XGPN_PLMP_CH1_POWER_CONSUMPTION_t        CH1_POWER_CONSUMPTION;         /* addr: 0x000000dc */
  ca_uint32_t                              rsrvd56[3];                   
  XGPN_PLMP_CH2_POWER_CONSUMPTION_t        CH2_POWER_CONSUMPTION;         /* addr: 0x000000e0 */
  ca_uint32_t                              rsrvd57[3];                   
  XGPN_PLMP_CH3_POWER_CONSUMPTION_t        CH3_POWER_CONSUMPTION;         /* addr: 0x000000e4 */
  ca_uint32_t                              rsrvd58[3];                   
  XGPN_PLMP_CH4_POWER_CONSUMPTION_t        CH4_POWER_CONSUMPTION;         /* addr: 0x000000e8 */
  ca_uint32_t                              rsrvd59[3];                   
  XGPN_PLMP_CH5_POWER_CONSUMPTION_t        CH5_POWER_CONSUMPTION;         /* addr: 0x000000ec */
  ca_uint32_t                              rsrvd60[3];                   
  XGPN_PLMP_CH6_POWER_CONSUMPTION_t        CH6_POWER_CONSUMPTION;         /* addr: 0x000000f0 */
  ca_uint32_t                              rsrvd61[3];                   
  XGPN_PLMP_CH7_POWER_CONSUMPTION_t        CH7_POWER_CONSUMPTION;         /* addr: 0x000000f4 */
  ca_uint32_t                              rsrvd62[3];                   
  XGPN_PLMP_TXBUF_CTRL_t                   TXBUF_CTRL;                    /* addr: 0x000000f8 */
  ca_uint32_t                              rsrvd63[3];                   
  XGPN_PLMP_TXBUF_DATA0_t                  TXBUF_DATA0;                   /* addr: 0x000000fc */
  ca_uint32_t                              rsrvd64[3];                   
  XGPN_PLMP_TXBUF_DATA1_t                  TXBUF_DATA1;                   /* addr: 0x00000100 */
  ca_uint32_t                              rsrvd65[3];                   
  XGPN_PLMP_TXBUF_DATA2_t                  TXBUF_DATA2;                   /* addr: 0x00000104 */
  ca_uint32_t                              rsrvd66[3];                   
  XGPN_PLMP_TXBUF_DATA3_t                  TXBUF_DATA3;                   /* addr: 0x00000108 */
  ca_uint32_t                              rsrvd67[3];                   
  XGPN_PLMP_TXBUF_DATA4_t                  TXBUF_DATA4;                   /* addr: 0x0000010c */
  ca_uint32_t                              rsrvd68[3];                   
  XGPN_PLMP_TXBUF_DATA5_t                  TXBUF_DATA5;                   /* addr: 0x00000110 */
  ca_uint32_t                              rsrvd69[3];                   
  XGPN_PLMP_TXBUF_DATA6_t                  TXBUF_DATA6;                   /* addr: 0x00000114 */
  ca_uint32_t                              rsrvd70[3];                   
  XGPN_PLMP_TXBUF_DATA7_t                  TXBUF_DATA7;                   /* addr: 0x00000118 */
  ca_uint32_t                              rsrvd71[3];                   
  XGPN_PLMP_TXBUF_DATA8_t                  TXBUF_DATA8;                   /* addr: 0x0000011c */
  ca_uint32_t                              rsrvd72[3];                   
  XGPN_PLMP_TXBUF_DATA9_t                  TXBUF_DATA9;                   /* addr: 0x00000120 */
  ca_uint32_t                              rsrvd73[3];                   
  XGPN_PLMP_RXBUF0_STAT_t                  RXBUF0_STAT;                   /* addr: 0x00000124 */
  ca_uint32_t                              rsrvd74[3];                   
  XGPN_PLMP_RXBUF1_STAT_t                  RXBUF1_STAT;                   /* addr: 0x00000128 */
  ca_uint32_t                              rsrvd75[87];                  
  XGPN_PLMP_RXBUF_t                        RXBUF[24];                     /* addr: 0x00000180 */
  ca_uint32_t                              rsrvd76[104];                 
  XGPN_PLMP_MIC_ERR_MIB_t                  MIC_ERR_MIB;                   /* addr: 0x00000200 */
  ca_uint32_t                              rsrvd77[3];                   
  XGPN_PLMP_DS_RX_MIB_t                    DS_RX_MIB;                     /* addr: 0x00000204 */
  ca_uint32_t                              rsrvd78[3];                   
  XGPN_PLMP_SYSTEM_PRFL_MIB_t              SYSTEM_PRFL_MIB;               /* addr: 0x00000208 */
  ca_uint32_t                              rsrvd79[3];                   
  XGPN_PLMP_CHANNEL_PRFL_MIB_t             CHANNEL_PRFL_MIB;              /* addr: 0x0000020c */
  ca_uint32_t                              rsrvd80[3];                   
  XGPN_PLMP_PRFL_MIB_t                     PRFL_MIB;                      /* addr: 0x00000210 */
  ca_uint32_t                              rsrvd81[3];                   
  XGPN_PLMP_ASSGN_ONUID_MIB_t              ASSGN_ONUID_MIB;               /* addr: 0x00000214 */
  ca_uint32_t                              rsrvd82[3];                   
  XGPN_PLMP_RANGING_TIME_MIB_t             RANGING_TIME_MIB;              /* addr: 0x00000218 */
  ca_uint32_t                              rsrvd83[3];                   
  XGPN_PLMP_PROTECT_CTRL_MIB_t             PROTECT_CTRL_MIB;              /* addr: 0x0000021c */
  ca_uint32_t                              rsrvd84[3];                   
  XGPN_PLMP_ADJ_TX_WVLN_MIB_t              ADJ_TX_WVLN_MIB;               /* addr: 0x00000220 */
  ca_uint32_t                              rsrvd85[3];                   
  XGPN_PLMP_DEACTV_ONU_MIB_t               DEACTV_ONU_MIB;                /* addr: 0x00000224 */
  ca_uint32_t                              rsrvd86[3];                   
  XGPN_PLMP_DISABLE_SN_MIB_t               DISABLE_SN_MIB;                /* addr: 0x00000228 */
  ca_uint32_t                              rsrvd87[3];                   
  XGPN_PLMP_REQ_REGST_MIB_t                REQ_REGST_MIB;                 /* addr: 0x0000022c */
  ca_uint32_t                              rsrvd88[3];                   
  XGPN_PLMP_ASSGN_ALLCTID_MIB_t            ASSGN_ALLCTID_MIB;             /* addr: 0x00000230 */
  ca_uint32_t                              rsrvd89[3];                   
  XGPN_PLMP_KEY_CTRL_MIB_t                 KEY_CTRL_MIB;                  /* addr: 0x00000234 */
  ca_uint32_t                              rsrvd90[3];                   
  XGPN_PLMP_SLEEP_ALLW_MIB_t               SLEEP_ALLW_MIB;                /* addr: 0x00000238 */
  ca_uint32_t                              rsrvd91[3];                   
  XGPN_PLMP_TUNING_CTRL_REQ_MIB_t          TUNING_CTRL_REQ_MIB;           /* addr: 0x0000023c */
  ca_uint32_t                              rsrvd92[3];                   
  XGPN_PLMP_TUNING_CTRL_CMPLT_MIB_t        TUNING_CTRL_CMPLT_MIB;         /* addr: 0x00000240 */
  ca_uint32_t                              rsrvd93[3];                   
  XGPN_PLMP_CALIBRT_REQ_MIB_t              CALIBRT_REQ_MIB;               /* addr: 0x00000244 */
  ca_uint32_t                              rsrvd94[3];                   
  XGPN_PLMP_US_TX_MIB_t                    US_TX_MIB;                     /* addr: 0x00000248 */
  ca_uint32_t                              rsrvd95[3];                   
  XGPN_PLMP_SN_ONU_MIB_t                   SN_ONU_MIB;                    /* addr: 0x0000024c */
  ca_uint32_t                              rsrvd96[3];                   
  XGPN_PLMP_REGST_MIB_t                    REGST_MIB;                     /* addr: 0x00000250 */
  ca_uint32_t                              rsrvd97[3];                   
  XGPN_PLMP_ACK_MIB_t                      ACK_MIB;                       /* addr: 0x00000254 */
  ca_uint32_t                              rsrvd98[3];                   
  XGPN_PLMP_KEY_REPORT_MIB_t               KEY_REPORT_MIB;                /* addr: 0x00000258 */
  ca_uint32_t                              rsrvd99[3];                   
  XGPN_PLMP_SLEEP_REQ_MIB_t                SLEEP_REQ_MIB;                 /* addr: 0x0000025c */
  ca_uint32_t                              rsrvd100[3];                  
  XGPN_PLMP_TUN_REQ_RSP_MIB_t              TUN_REQ_RSP_MIB;               /* addr: 0x00000260 */
  ca_uint32_t                              rsrvd101[3];                  
  XGPN_PLMP_TUN_CMPLTU_MIB_t               TUN_CMPLTU_MIB;                /* addr: 0x00000264 */
  ca_uint32_t                              rsrvd102[3];                  
  XGPN_PLMP_PWR_CNSMPT_RPT_MIB_t           PWR_CNSMPT_RPT_MIB;            /* addr: 0x00000268 */
  ca_uint32_t                              rsrvd103[3];                  
  XGPN_PLMP_DEBUG_STS0_t                   DEBUG_STS0;                    /* addr: 0x0000026c */
  ca_uint32_t                              rsrvd104[3];                  
  XGPN_PLMP_DEBUG_STS1_t                   DEBUG_STS1;                    /* addr: 0x00000270 */
  ca_uint32_t                              rsrvd105[3];                  
  XGPN_PLMP_DEBUG_STS2_t                   DEBUG_STS2;                    /* addr: 0x00000274 */
  ca_uint32_t                              rsrvd106[3];                  
  XGPN_PLMP_BC_PLOAM_SEQ_t                 BC_PLOAM_SEQ;                  /* addr: 0x00000278 */
  ca_uint32_t                              rsrvd107[3];                  
  XGPN_PLMP_UC_PLOAM_SEQ_t                 UC_PLOAM_SEQ;                  /* addr: 0x0000027c */
  ca_uint32_t                              rsrvd108[3];                  
  XGPN_PLMP_BC_MSG_CNT_t                   BC_MSG_CNT;                    /* addr: 0x00000280 */
  ca_uint32_t                              rsrvd109[3];                  
  XGPN_PLMP_ENABLE_ONU_CNT_t               ENABLE_ONU_CNT;                /* addr: 0x00000284 */
  ca_uint32_t                              rsrvd110[3];                  
  XGPN_PLMP_UC_UPDT_PRFL_CNT_t             UC_UPDT_PRFL_CNT;              /* addr: 0x00000288 */
  ca_uint32_t                              rsrvd111[3];                  
  XGPN_PLMP_EXTENSION_CNT_t                EXTENSION_CNT;                 /* addr: 0x0000028c */
  ca_uint32_t                              rsrvd112[3];                  
  XGPN_PLMP_REGST_CNT_t                    REGST_CNT;                     /* addr: 0x00000290 */
  ca_uint32_t                              rsrvd113[3];                  
  XGPN_PLMP_ACK_OK_CNT_t                   ACK_OK_CNT;                    /* addr: 0x00000294 */
  ca_uint32_t                              rsrvd114[3];                  
  XGPN_PLMP_PLOAMD_ERR_CNT_t               PLOAMD_ERR_CNT;                /* addr: 0x00000298 */
  ca_uint32_t                              rsrvd115[3];                  
  XGPN_PLMP_DS_TX_CNT_t                    DS_TX_CNT;                     /* addr: 0x0000029c */
  ca_uint32_t                              rsrvd116[3];                  
  XGPN_PLMP_DS_DROP_CNT_t                  DS_DROP_CNT;                   /* addr: 0x000002a0 */
  ca_uint32_t                              rsrvd117[3];                  
  XGPN_PLMP_RX_FF_DROP_CNT_t               RX_FF_DROP_CNT;                /* addr: 0x000002a4 */
  ca_uint32_t                              rsrvd118[3];                  
  XGPN_PLMP_EXTEN_DROP_CNT_t               EXTEN_DROP_CNT;                /* addr: 0x000002a8 */
  ca_uint32_t                              rsrvd119[3];                  
  XGPN_PLMP_US_RX_CNT_t                    US_RX_CNT;                     /* addr: 0x000002ac */
  ca_uint32_t                              rsrvd120[3];                  
  XGPN_PLMP_US_SW_TX_CNT_t                 US_SW_TX_CNT;                  /* addr: 0x000002b0 */
  ca_uint32_t                              rsrvd121[3];                  
  XGPN_PLMP_DS_SW_RX_CNT_t                 DS_SW_RX_CNT;                  /* addr: 0x000002b4 */
  ca_uint32_t                              rsrvd122[3];                  
  XGPN_PLMP_EXTENSION_MSG_TYPE_t           EXTENSION_MSG_TYPE;            /* addr: 0x000002b8 */
  ca_uint32_t                              rsrvd123[3];                  
  XGPN_PLMP_PLOAM_PKT_GEN_FIFO_CTRL_t      PLOAM_PKT_GEN_FIFO_CTRL;       /* addr: 0x000002bc */
  ca_uint32_t                              rsrvd124[3];                  
  XGPN_PLMP_PLOAM_MSG_DROP_CNTR_t          PLOAM_MSG_DROP_CNTR;           /* addr: 0x000002c0 */
  ca_uint32_t                              rsrvd125[3];                  
  XGPN_PLMP_SW_PLOAMD_FULL_DROP_MIB_t      SW_PLOAMD_FULL_DROP_MIB;       /* addr: 0x000002c4 */
  ca_uint32_t                              rsrvd126[3];                  
  XGPN_PLMP_SW_PLOAMD_OVERLAP_DROP_MIB_t   SW_PLOAMD_OVERLAP_DROP_MIB;    /* addr: 0x000002c8 */
} APB1_XGPN_PLMP_t;


/*
 * actp
 */
        
#define XGPN_ACTP_CTRL                           0xd0034b00
#define XGPN_ACTP_CTRL_dft                       0x00000000

typedef volatile union {
  struct {
    ca_uint32_t sw_mode              :  1 ; /* bits 0:0 */
    ca_uint32_t sw_discard_all       :  1 ; /* bits 1:1 */
    ca_uint32_t sw_discard_brstpf    :  1 ; /* bits 2:2 */
    ca_uint32_t rsrvd1               :  1 ;
    ca_uint32_t response_threshold   :  4 ; /* bits 7:4 */
    ca_uint32_t rsrvd2               :  8 ;
    ca_uint32_t wlcp_enable          :  1 ; /* bits 16:16 */
    ca_uint32_t rsrvd3               : 15 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_ACTP_CTRL_t;


#define XGPN_ACTP_SYNC_HUNT                      0xd0034b04
#define XGPN_ACTP_SYNC_HUNT_dft                  0x00000320

typedef volatile union {
  struct {
    ca_uint32_t threshold            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_ACTP_SYNC_HUNT_t;


#define XGPN_ACTP_TOZ                            0xd0034b08
#define XGPN_ACTP_TOZ_dft                        0x00000000

typedef volatile union {
  struct {
    ca_uint32_t threshold            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_ACTP_TOZ_t;


#define XGPN_ACTP_TO1                            0xd0034b0c
#define XGPN_ACTP_TO1_dft                        0x00013880

typedef volatile union {
  struct {
    ca_uint32_t threshold            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_ACTP_TO1_t;


#define XGPN_ACTP_TO23                           0xd0034b10
#define XGPN_ACTP_TO23_dft                       0x00000320

typedef volatile union {
  struct {
    ca_uint32_t threshold            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_ACTP_TO23_t;


#define XGPN_ACTP_TO4                            0xd0034b14
#define XGPN_ACTP_TO4_dft                        0x00013880

typedef volatile union {
  struct {
    ca_uint32_t threshold            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_ACTP_TO4_t;


#define XGPN_ACTP_TO5                            0xd0034b18
#define XGPN_ACTP_TO5_dft                        0x00013880

typedef volatile union {
  struct {
    ca_uint32_t threshold            : 32 ; /* bits 31:0 */
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_ACTP_TO5_t;


#define XGPN_ACTP_INTERRUPT                      0xd0034b1c
#define XGPN_ACTP_INTERRUPT_dft                  0x00000000

typedef volatile union {
  struct {
    ca_uint32_t onu_state_change     :  1 ; /* bits 0:0 */
    ca_uint32_t hunt_sync_expire     :  1 ; /* bits 1:1 */
    ca_uint32_t profile_learning     :  1 ; /* bits 2:2 */
    ca_uint32_t tx_response_cross    :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_ACTP_INTERRUPT_t;


#define XGPN_ACTP_INTERRUPTE0                    0xd0034b20
#define XGPN_ACTP_INTERRUPTE0_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t onu_state_changeE    :  1 ; /* bits 0:0 */
    ca_uint32_t hunt_sync_expireE    :  1 ; /* bits 1:1 */
    ca_uint32_t profile_learningE    :  1 ; /* bits 2:2 */
    ca_uint32_t tx_response_crossE   :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_ACTP_INTERRUPTE0_t;


#define XGPN_ACTP_INTERRUPTE1                    0xd0034b24
#define XGPN_ACTP_INTERRUPTE1_dft                0x00000000

typedef volatile union {
  struct {
    ca_uint32_t onu_state_changeE    :  1 ; /* bits 0:0 */
    ca_uint32_t hunt_sync_expireE    :  1 ; /* bits 1:1 */
    ca_uint32_t profile_learningE    :  1 ; /* bits 2:2 */
    ca_uint32_t tx_response_crossE   :  1 ; /* bits 3:3 */
    ca_uint32_t rsrvd1               : 28 ;
  } bf ;
  ca_uint32_t     wrd ;
} XGPN_ACTP_INTERRUPTE1_t;


#define XGPN_ACTP_ST_CHG_INT                     0xd0034b28
#define XGPN_ACTP_ST_CHG_INT_dft       