#ifndef __RTK_SHM_H__
#define __RTK_SHM_H__

#define PE_LOG_SIZE		0x4000U
#define IPC_LIST_SIZE	0x2D4000

//==============================================================================
//  for backport/middleware
//==============================================================================
#include <linux/netdevice.h>
#include <linux/version.h>
#if (CONFIG_WFO_VIRT_MODULE || CONFIG_WFO_VIRT)
#include <soc/realtek/wfo_virt_ext.h>
#endif

//==============================================================================
//  for rtk_pe_watchdog
//==============================================================================

typedef struct ecos_status{
	unsigned int heartbeat;
	int enable_pe_rx;
	int enable_pe_tx;
	int sysrq_trigger;
	int nic_tx_hang:16;
	int wifi_hang:16;
	int ipc_recover;
}ecos_status_t;

//==============================================================================
//  for wifi 8852ae_98d module paramemter
//==============================================================================

struct wifi_module_param {
       int rtw_ht_enable;
       int rtw_vht_enable;
       int rtw_he_enable;
       uint rtw_drv_log_level;
       uint phl_log_level;
};

//==============================================================================
//  for wifi 8852ae_98d module paramemter
//==============================================================================
struct wfo_pci_param {
	uint pci_dev_id;
	uint pci_status;
};

//==============================================================================
//  common shm structure
//==============================================================================
#define RTK_SHM_DRAM_BASE	0xB0000000
#define RTK_SHM_DRAM		((wfo_dram_t *)RTK_SHM_DRAM_BASE)
#define PE_STATUS ((ecos_status_t *)&(RTK_SHM_DRAM->hb))

typedef struct _rtk_shm_dram {
	unsigned int dram_size;
	unsigned int is_scanning;
	uint32_t dbg_trace[6];
	uint32_t trace_cnt[6];
	ecos_status_t hb;
#if (CONFIG_WFO_VIRT_MODULE || CONFIG_WFO_VIRT)
	struct middleware md;
#endif
	struct wifi_module_param wifi_param;
	struct wfo_pci_param pci_param;
} wfo_dram_t;

static inline void rtk_shm_set_dram_size(unsigned int size)
{
	wfo_dram_t *wfo_dram = RTK_SHM_DRAM;
	wfo_dram->dram_size = size;
}

static inline unsigned int rtk_shm_get_dram_size(void)
{
	wfo_dram_t *wfo_dram = RTK_SHM_DRAM;
	return wfo_dram->dram_size;
}

static void rtk_shm_dbg_trace(unsigned long func, int idx)
{
	wfo_dram_t *wfo_dram = RTK_SHM_DRAM;

	wfo_dram->dbg_trace[idx] = func;
	wfo_dram->trace_cnt[idx]++;
}

static void rtk_shm_trace_cnt_init(void)
{
	wfo_dram_t *wfo_dram = RTK_SHM_DRAM;

	memset(wfo_dram->dbg_trace, 0, 6 * sizeof(uint32_t));
	memset(wfo_dram->trace_cnt, 0, 6 * sizeof(uint32_t));
}

#endif /* __RTK_SHM_H__ */
