/*
 * =====================================================================================
 *
 *       Filename:  fmalgonoff.c
 *
 *    Description:  control the on-off of ALG by the web
 *
 *        Version:  1.0
 *        Created:  08/16/07 15:54:05    
 *       Revision:  none
 *       Compiler:  gcc
 *
 *         Author:  Ramen.Shen (Mr), ramen_shen@realsil.com.cn
 *        Company:  REALSIL Microelectronics Inc
 *
 * =====================================================================================
 */

/*-- System inlcude files --*/
#include <sys/ioctl.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <net/route.h>
#include <linux/if.h>

/*-- Local inlcude files --*/
#include "../webs.h"
#include "webform.h"
#include "mib.h"
#include "utility.h"
#ifdef EMBED
#include <linux/config.h>
#else
#include "../../../../include/linux/autoconf.h"
#endif
#ifdef CONFIG_IP_NF_ALG_ONOFF
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
enum algtype{
#ifdef CONFIG_NF_CONNTRACK_L2TP_MODULE
	   ALG_TYPE_L2TP=0,
#endif
#ifdef CONFIG_NF_CONNTRACK_IPSEC_MODULE
   ALG_TYPE_IPSEC,
#endif
#ifdef CONFIG_NF_CONNTRACK_H323_MODULE	
    ALG_TYPE_H323,
#endif
#ifdef CONFIG_NF_CONNTRACK_RTSP_MODULE
   ALG_TYPE_RTSP,
#endif
#if defined(CONFIG_NF_CONNTRACK_SIP_MODULE)
    ALG_TYPE_SIP,
#endif
#ifdef CONFIG_NF_CONNTRACK_FTP_MODULE
    ALG_TYPE_FTP,
#endif
 #ifdef CONFIG_NF_CONNTRACK_PPTP_MODULE
    ALG_TYPE_PPTP,  
#endif
#ifdef CONFIG_NF_CONNTRACK_TFTP_MODULE
	ALG_TYPE_TFTP,
#endif
#if 0 //CMCC does not need this
#ifdef CONFIG_NF_CONNTRACK_IRC
    ALG_TYPE_IRC,
 #endif
 #ifdef CONFIG_NF_CONNTRACK_QUAKE3
    ALG_TYPE_QUAKE3,
 #endif
 #ifdef CONFIG_NF_CONNTRACK_CUSEEME
    ALG_TYPE_CUSEEME,
 #endif 
#endif
    ALG_TYPE_MAX
};
struct {
	unsigned char id;
	unsigned int mibalgid;
	char* name;
	char* web_name;
}algTypeName[]={
#ifdef CONFIG_NF_CONNTRACK_L2TP_MODULE
	{ALG_TYPE_L2TP,MIB_IP_ALG_L2TP,"l2tp","L2TP"},
#endif
#ifdef CONFIG_NF_CONNTRACK_IPSEC_MODULE
{ALG_TYPE_IPSEC,MIB_IP_ALG_IPSEC,"ipsec","IPSec"},
#endif
#ifdef CONFIG_NF_CONNTRACK_H323_MODULE
{ALG_TYPE_H323,MIB_IP_ALG_H323,"h323","H.323"},
#endif
#ifdef CONFIG_NF_CONNTRACK_RTSP_MODULE
{ALG_TYPE_RTSP,MIB_IP_ALG_RTSP,"rtsp","RTSP"},
#endif
#if defined(CONFIG_NF_CONNTRACK_SIP_MODULE)
{ALG_TYPE_SIP,MIB_IP_ALG_SIP,"sip","SIP"},
#endif
#ifdef CONFIG_NF_CONNTRACK_FTP_MODULE
{ALG_TYPE_FTP,MIB_IP_ALG_FTP,"ftp","FTP"},
#endif
 #ifdef CONFIG_NF_CONNTRACK_PPTP_MODULE
{ALG_TYPE_PPTP, MIB_IP_ALG_PPTP,"pptp","PPTP"}, 
 #endif
 #ifdef CONFIG_NF_CONNTRACK_TFTP_MODULE
{ALG_TYPE_TFTP,MIB_IP_ALG_TFTP,"tftp","TFTP"},
#endif
#if 0 //CMCC does not need this
#ifdef CONFIG_NF_CONNTRACK_IRC
{ALG_TYPE_IRC,MIB_IP_ALG_IRC,"irc"},
#endif
#ifdef CONFIG_NF_CONNTRACK_QUAKE3
{ALG_TYPE_QUAKE3,MIB_IP_ALG_QUAKE3,"quake3"},
#endif
#ifdef CONFIG_NF_CONNTRACK_CUSEEME
{ALG_TYPE_CUSEEME,MIB_IP_ALG_CUSEEME,"cuseeme"},
#endif
#endif
{ALG_TYPE_MAX,0,NULL}
};

void formALGOnOff(request * wp, char *path, char *query)
{

	char	*str, *submitUrl;
	int len = 0;
	char tmpBuf[100];	
	char cmdstr[128]={0};
	//char cmdbuf[8]={0};
	unsigned char  algenable=0;
#if defined(CONFIG_CMCC)
	str = boaGetVar(wp, "apply", "");
	if (str[0]) {
#endif
	int i=0;	
	for(i=0;i<ALG_TYPE_MAX;i++)
	{
		char algTypeStr[32]={0};
		snprintf(algTypeStr,sizeof(algTypeStr),"%s_algonoff",algTypeName[i].name);
		len += snprintf(tmpBuf+len, sizeof(tmpBuf)-len, "%s:",algTypeName[i].name);
		str=boaGetVar(wp, algTypeStr, "0");
		//printf("%s is %s\n", algTypeStr, str);
		if(str[0])
		{
			algenable=atoi(str);
			if(!mib_set(algTypeName[i].mibalgid,(void*)&algenable))
				printf("%s mib set %d error!\n",__FUNCTION__,algTypeName[i].mibalgid);
			}		
		}			
#if defined(CONFIG_CMCC)
	}
#endif
	syslog(LOG_CRIT, "ALG %s\n", tmpBuf);
	// Mason Yu. alg_onoff_20101023
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif
#ifdef CONFIG_USER_RTK_NAT_ALG_PASS_THROUGH
	setupAlgOnOff();
#endif
		
	submitUrl = boaGetVar(wp, "submit-url", "");
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
	return;	
}

void GetAlgTypes(request * wp)
{
	unsigned char  value=0;
	int i = 0;
	for(i=0;i<ALG_TYPE_MAX;i++)
	{
		mib_get_s(algTypeName[i].mibalgid,&value, sizeof(value));
		//printf("%s is %d\n", algTypeName[i].name, value);
		if(value == 1){
			boaWrite(wp,"<tr>\n "
			"  <td ><input type=\"checkbox\" name=%s_algonoff value=1 onChange=\"checkChange(this)\" checked>启用%s ALG</td><td ></td>\n"
			"</tr>\n",algTypeName[i].name,algTypeName[i].web_name);
		}
		else{
			boaWrite(wp,"<tr>\n "
			"  <td ><input type=\"checkbox\" name=%s_algonoff value=0 onChange=\"checkChange(this)\">启用%s ALG</td>\n"
			"</tr>\n",algTypeName[i].name,algTypeName[i].web_name);
		}
		
	}
}

#ifdef CONFIG_CMCC_ENTERPRISE
int init_alg_page(int eid, request * wp, int argc, char **argv)
{
	unsigned char  value=0;
	int i = 0;
	int ret = 0;

	for(i=0;i<ALG_TYPE_MAX;i++)
	{
		mib_get(algTypeName[i].mibalgid,&value);
		printf("%s is %d\n", algTypeName[i].name, value);
		if(value == 1){
			ret += boaWrite(wp, "%s = 1;\n",algTypeName[i].name);
		}
		else{
			ret += boaWrite(wp, "%s = 0;\n",algTypeName[i].name);
		}
	}

	return ret;
}
#endif


void CreatejsAlgTypeStatus(request * wp)
{
	return;	
}
void initAlgOnOff(request * wp)
{
	return;   
}

#else //CONFIG_CMCC
enum algtype{
#ifdef CONFIG_NF_CONNTRACK_FTP_MODULE
    ALG_TYPE_FTP=0,
#endif
#ifdef CONFIG_NF_CONNTRACK_TFTP_MODULE
    ALG_TYPE_TFTP,
#endif
#ifdef CONFIG_NF_CONNTRACK_H323_MODULE	
    ALG_TYPE_H323,
#endif
#ifdef CONFIG_NF_CONNTRACK_IRC_MODULE
    ALG_TYPE_IRC,
 #endif
 #ifdef CONFIG_NF_CONNTRACK_RTSP_MODULE
    ALG_TYPE_RTSP,
 #endif
 #ifdef CONFIG_NF_CONNTRACK_QUAKE3_MODULE
    ALG_TYPE_QUAKE3,
 #endif
 #ifdef CONFIG_NF_CONNTRACK_CUSEEME_MODULE
    ALG_TYPE_CUSEEME,
 #endif 
 #ifdef CONFIG_NF_CONNTRACK_L2TP_MODULE
    ALG_TYPE_L2TP,
 #endif
 #ifdef CONFIG_NF_CONNTRACK_IPSEC_MODULE
    ALG_TYPE_IPSEC,
 #endif
#if defined(CONFIG_NF_CONNTRACK_SIP_MODULE)
    ALG_TYPE_SIP,
#endif
 #ifdef CONFIG_NF_CONNTRACK_PPTP_MODULE
    ALG_TYPE_PPTP,  
#endif
    ALG_TYPE_MAX
};
struct {
	unsigned char id;
	unsigned int mibalgid;
	char* name;
}algTypeName[]={
#ifdef CONFIG_NF_CONNTRACK_FTP_MODULE
{ALG_TYPE_FTP,MIB_IP_ALG_FTP,"ftp"},
#endif
#ifdef CONFIG_NF_CONNTRACK_TFTP_MODULE
{ALG_TYPE_TFTP,MIB_IP_ALG_TFTP,"tftp"},
#endif
#ifdef CONFIG_NF_CONNTRACK_H323_MODULE
{ALG_TYPE_H323,MIB_IP_ALG_H323,"h323"},
#endif
#ifdef CONFIG_NF_CONNTRACK_IRC_MODULE
{ALG_TYPE_IRC,MIB_IP_ALG_IRC,"irc"},
#endif
#ifdef CONFIG_NF_CONNTRACK_RTSP_MODULE
{ALG_TYPE_RTSP,MIB_IP_ALG_RTSP,"rtsp"},
#endif
#ifdef CONFIG_NF_CONNTRACK_QUAKE3_MODULE
{ALG_TYPE_QUAKE3,MIB_IP_ALG_QUAKE3,"quake3"},
#endif
#ifdef CONFIG_NF_CONNTRACK_CUSEEME_MODULE
{ALG_TYPE_CUSEEME,MIB_IP_ALG_CUSEEME,"cuseeme"},
#endif
#ifdef CONFIG_NF_CONNTRACK_L2TP_MODULE
{ALG_TYPE_L2TP,MIB_IP_ALG_L2TP,"l2tp"},
#endif
#ifdef CONFIG_NF_CONNTRACK_IPSEC_MODULE
{ALG_TYPE_IPSEC,MIB_IP_ALG_IPSEC,"ipsec"},
#endif
#if defined(CONFIG_NF_CONNTRACK_SIP_MODULE)
{ALG_TYPE_SIP,MIB_IP_ALG_SIP,"sip"},
#endif
 #ifdef CONFIG_NF_CONNTRACK_PPTP_MODULE
{ALG_TYPE_PPTP, MIB_IP_ALG_PPTP,"pptp"}, 
 #endif
{ALG_TYPE_MAX,0,NULL}
};
void formALGOnOff(request * wp, char *path, char *query)
{

	char	*str, *submitUrl;
	char tmpBuf[100];	
	char cmdstr[128]={0};
	//char cmdbuf[8]={0};
	unsigned char  algenable=0;
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
	str = boaGetVar(wp, "apply", "");
	if (str[0]) {
#endif
	int i=0;	
	for(i=0;i<ALG_TYPE_MAX;i++)
		{

		char algTypeStr[32]={0};
		snprintf(algTypeStr,sizeof(algTypeStr),"%s_algonoff",algTypeName[i].name);
		str=boaGetVar(wp, algTypeStr, "");
		if(str[0])
			{
			algenable=str[0]-'0';
			  snprintf(cmdstr,sizeof(cmdstr),"/proc/%s_algonoff",algTypeName[i].name);
			 FILE *fp=fopen(cmdstr,"w");
			 if(fp)
			 	{
			 	fwrite(str,sizeof(char),1,fp);
				fclose(fp);
			 	}
			if(!mib_set(algTypeName[i].mibalgid,(void*)&algenable))
				printf("%s mib set %d error!\n",__FUNCTION__,algTypeName[i].mibalgid);
			}		
		}			
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
 	}
#endif
	
	// Mason Yu. alg_onoff_20101023
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif
#ifdef CONFIG_USER_RTK_NAT_ALG_PASS_THROUGH
	setupAlgOnOff();
#endif
		
	submitUrl = boaGetVar(wp, "submit-url", "");
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
	return;	
}
void GetAlgTypes(request * wp)
{
	int i = 0;
	for(i=0;i<ALG_TYPE_MAX;i++)
	{
		boaWrite(wp,"<tr>\n <td ><font size=2>%s</td>\n"
		"  <td ><input type=\"radio\" name=%s_algonoff value=1 >启用</td>\n"
		"     <td ><input type=\"radio\" name=%s_algonoff value=0 >关闭</td>\n "
		"</tr>\n",algTypeName[i].name,algTypeName[i].name,algTypeName[i].name);
	}
	return;
}

void CreatejsAlgTypeStatus(request * wp)
{
unsigned char  value=0;
int i =0;
for(i=0;i<ALG_TYPE_MAX;i++)
{

	mib_get_s(algTypeName[i].mibalgid,&value, sizeof(value));	
	boaWrite(wp,"document.algof.%s_algonoff[%d].checked=true;\n",algTypeName[i].name,!value&0x01);	
}	
return;

}
void initAlgOnOff(request * wp)
{
	return;   
}
#endif //CONFIG_CMCC
#endif

