#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <signal.h>
#include <pthread.h>
#include <sys/prctl.h>
#include "mib.h"
#include "utility.h"
#include <errno.h>

enum {
	FM_EVT_NONE,
	FM_EVT_NET
};

typedef struct FM_APPLY_LIST_t
{
	int evt;
	int argc;
	void *args[8];
	unsigned char _doing_evt;
	struct FM_APPLY_LIST_t *_next;
	struct FM_APPLY_LIST_t *_prev;
}FM_APPLY_LIST_s;

static pthread_t fm_apply_thread = 0;
static pthread_mutex_t fm_list_mutex; 
static pthread_mutex_t fm_thread_mutex; 
static unsigned char fm_apply_thread_runnable = 0;
static FM_APPLY_LIST_s *fm_list_head = NULL, *fm_list_tail = NULL;;


int fm_check_enable_apply(void)
{
	unsigned char enable = 0;
	mib_get_s(MIB_BOA_APPLY_FAST, (void *)&enable, sizeof(enable));
	return (enable)?1:0;
}

int fm_add_apply_evt(FM_APPLY_LIST_s *apply_evt)
{
	pthread_mutex_lock(&fm_list_mutex);
	if(fm_list_tail){
		apply_evt->_prev = fm_list_tail;
		fm_list_tail->_next = apply_evt;
		fm_list_tail = apply_evt;
	}
	else{
		fm_list_tail = apply_evt;
		fm_list_head = apply_evt;
	}
		
	pthread_mutex_unlock(&fm_list_mutex);
	pthread_mutex_unlock(&fm_thread_mutex); //notify thread
	
	return 1;
}

int fm_restartWAN_check(void *pEntry)
{
	FM_APPLY_LIST_s *evt;
	MIB_CE_ATM_VC_Tp ptmpEntry;
	
	if(pEntry == NULL) return 0;
	
	pthread_mutex_lock(&fm_list_mutex);
	evt = fm_list_head;
	while(evt)
	{
		ptmpEntry = ((MIB_CE_ATM_VC_Tp)(evt->args[1]));
		if(ptmpEntry && ptmpEntry->ifIndex == ((MIB_CE_ATM_VC_Tp)pEntry)->ifIndex)
		{
			pthread_mutex_unlock(&fm_list_mutex);
			return 1;
		}
		evt = evt->_next;
	}
	pthread_mutex_unlock(&fm_list_mutex);
	
	return 0;
}

int fm_restartWAN(int configAll, void *pNewEntry,  void *pOldEntry)
{
	FM_APPLY_LIST_s *apply_evt = NULL;
	
	apply_evt = calloc(1, sizeof(FM_APPLY_LIST_s));
	apply_evt->evt = FM_EVT_NET;
	apply_evt->argc = 3;
	apply_evt->args[0] = malloc(sizeof(int));
	memcpy(apply_evt->args[0], &configAll, sizeof(int));
	
	if(pNewEntry){
		apply_evt->args[1] = malloc(sizeof(MIB_CE_ATM_VC_T));
		memcpy(apply_evt->args[1], pNewEntry, sizeof(MIB_CE_ATM_VC_T));
	}
	if(pOldEntry){
		apply_evt->args[2] = malloc(sizeof(MIB_CE_ATM_VC_T));
		memcpy(apply_evt->args[2], pOldEntry, sizeof(MIB_CE_ATM_VC_T));
	}
	
	fm_add_apply_evt(apply_evt);
	
	return 1;
}

int fm_configWLAN(int configAll, MIB_CE_ATM_VC_Tp pNewEntry, MIB_CE_ATM_VC_Tp pOldEntry)
{
	FM_APPLY_LIST_s *apply_evt = NULL;
	
	apply_evt = calloc(1, sizeof(FM_APPLY_LIST_s));
	apply_evt->evt = FM_EVT_NET;
	apply_evt->argc = 3;
	apply_evt->args[0] = malloc(sizeof(int));
	memcpy(apply_evt->args[0], &configAll, sizeof(int));
	
	if(pNewEntry){
		apply_evt->args[1] = malloc(sizeof(MIB_CE_ATM_VC_T));
		memcpy(apply_evt->args[1], pNewEntry, sizeof(MIB_CE_ATM_VC_T));
	}
	if(pOldEntry){
		apply_evt->args[2] = malloc(sizeof(MIB_CE_ATM_VC_T));
		memcpy(apply_evt->args[2], pOldEntry, sizeof(MIB_CE_ATM_VC_T));
	}
	
	fm_add_apply_evt(apply_evt);
	
	return 1;
}

void *fm_apply_work(void *arg)
{
	int i;
	sigset_t mask;
	FM_APPLY_LIST_s *apply_evt = NULL;
	
	prctl(PR_SET_NAME, "boa_form_apply", 0, 0, 0);
	
	pthread_detach(pthread_self());
	pthread_setcancelstate(PTHREAD_CANCEL_ENABLE, NULL);
#if 0	
	sigfillset(&mask); /* Mask all allowed signals */
    pthread_sigmask(SIG_BLOCK, &mask, NULL);
	
	sigemptyset(&mask);
	sigaddset(&mask, SIGINT);
	sigaddset(&mask, SIGTERM);
	pthread_sigmask(SIG_UNBLOCK, &mask, NULL);
#endif
	fm_apply_thread_runnable = 1;
	
	apply_evt = fm_list_head;
	
	while(fm_apply_thread_runnable)
	{
		printf("======> [%s] wait request....\n", __FUNCTION__);
		if(apply_evt == NULL ) pthread_mutex_lock(&fm_thread_mutex);
		
		pthread_mutex_lock(&fm_list_mutex);
		apply_evt = fm_list_head;
		pthread_mutex_unlock(&fm_list_mutex);
		
		if(apply_evt)
		{
			printf("======> [%s] handle request %p ....\n", __FUNCTION__, apply_evt);
			apply_evt->_doing_evt = 1;
			if(apply_evt->evt == FM_EVT_NET)
			{
				int configAll = *((int*)apply_evt->args[0]);
				MIB_CE_ATM_VC_Tp pNewEntry = ((MIB_CE_ATM_VC_Tp)(apply_evt->args[1]));
				MIB_CE_ATM_VC_Tp pOldEntry = ((MIB_CE_ATM_VC_Tp)(apply_evt->args[2]));
				printf("======> [%s]: restart WAN, ifIndex = %x\n", __FUNCTION__, pNewEntry?(pNewEntry->ifIndex):(pOldEntry)?pOldEntry->ifIndex:0 );
				restartWAN(configAll, pNewEntry);
#ifdef VOIP_SUPPORT				
				if(pNewEntry && 
					((pNewEntry->applicationtype & X_CT_SRV_VOICE) || 
					(pOldEntry && (pOldEntry->applicationtype & X_CT_SRV_VOICE)))
				){
					extern int web_restart_solar();		
					web_restart_solar();
				}
#endif
			}
			
			pthread_mutex_lock(&fm_list_mutex);
			fm_list_head = fm_list_head->_next;
			if(fm_list_head) fm_list_head->_prev = NULL;
			else fm_list_tail = NULL;
			for(i=0;i<apply_evt->argc;i++){
				if(apply_evt->args[i]){
					free(apply_evt->args[i]);
					apply_evt->args[i] = NULL;
				}
			}
			free(apply_evt);
			apply_evt = fm_list_head;
			pthread_mutex_unlock(&fm_list_mutex);
		}
	}
}

int init_fm_apply_thread(void)
{
	int ret = 0;
	pthread_mutex_init(&fm_thread_mutex,NULL);
	pthread_mutex_init(&fm_list_mutex,NULL);
	
	pthread_mutex_lock(&fm_thread_mutex);
	pthread_create(&fm_apply_thread, NULL, fm_apply_work, NULL);
	if(ret != 0){
		fprintf(stderr, "ERROR init form apply thread! %s\n", strerror(errno));
		return -1;
	}
	
	return 0;
}
