/*
 *      Include file of form handler
 *      Authors:
 *
 */


#ifndef _INCLUDE_FMDEFS_H
#define _INCLUDE_FMDEFS_H


#include <string.h>
#include "webform.h"
#include "strde.h"		// Mason Yu. IGMP Proxy for e8b
#include "../../webs.h"


#define _CGI_VER_TW10	1

#define _OPT				0
#define _NEED				1


#define	MAXIFNAMESIZE		30

//#define _CGI_DEBUG_

#define CHECK_INVALID(s)	if(!(s[0])) {lineno = __LINE__; goto check_err;}
#define CHECK_INVALID_OPT(s, opt)	if(opt && (s == NULL || !(s[0]))) {lineno = __LINE__; goto check_err;}
#ifdef _CGI_DEBUG_
#define FETCH_INVALID(s, n)	{s = boaGetVar(wp, n, ""); printf("%s:%s\n", n, s?s:"");CHECK_INVALID(s);}
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
#define FETCH_INVALID_OPT(s, n, opt){s = boaGetVar(wp, n, ""); printf("%s:%s\n", n, s?s:"");}
#else
#define FETCH_INVALID_OPT(s, n, opt){s = boaGetVar(wp, n, ""); printf("%s:%s\n", n, s?s:"");CHECK_INVALID_OPT(s, opt);}
#endif
#define _TRACE_CALL			{printf("entering %s....\n", __FUNCTION__);}
#define _TRACE_LEAVEL		{printf("leaving %s.... final line:%d\n", __FUNCTION__, lineno);}
#define _TRACE_POINT		{printf("line:%d\n",  __LINE__);}
#else
#define FETCH_INVALID(s, n)	{s = boaGetVar(wp, n, ""); CHECK_INVALID(s);}
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
#define FETCH_INVALID_OPT(s, n, opt){s = boaGetVar(wp, n, ""); printf("%s:%s\n", n, s?s:"");}
#else
#define FETCH_INVALID_OPT(s, n, opt){s = boaGetVar(wp, n, ""); printf("%s:%s\n", n, s?s:"");CHECK_INVALID_OPT(s, opt);}
#endif
#define _TRACE_CALL
#define _TRACE_LEAVEL
#define _TRACE_POINT
#endif

#define _GET_STR(name, opt)		{FETCH_INVALID_OPT(stemp, #name, opt); strlcpy(name, stemp, sizeof(name));}
#define _GET_PSTR(name, opt)	{FETCH_INVALID_OPT(p##name, #name, opt);}
#define _GET_IP(name, opt)		{FETCH_INVALID_OPT(stemp, #name, opt); name = inet_addr(stemp);}
#define _GET_IP_STR(name, addr, opt)		{FETCH_INVALID_OPT(stemp, #name, opt);inet_aton(stemp,&addr);name = addr.s_addr;}
#define _GET_INT(name, opt)		{FETCH_INVALID_OPT(stemp, #name, opt); name = atoi(stemp);}
#define _GET_BOOL(name, opt)	{FETCH_INVALID_OPT(stemp, #name, _OPT); name = (strcmp(stemp, "on") == 0 )? 1 : 0;}

#define _PUT_STR(name)			{boaWrite(wp, "cgi."#name" = \"%s\";\n", name);}
#define _PUT_PSTR(name)			{boaWrite(wp, "cgi."#name" = \"%s\";\n", p##name);}
#define _PUT_IP(name)			{boaWrite(wp, "cgi."#name" = \"%s\";\n", inet_ntoa(*(struct in_addr*)&(name)));}
#define _PUT_INT(name)			{boaWrite(wp, "cgi."#name" = %d;\n", name);}
/*ql:20080805 START: if #name == -1, it should be false value, but it is true before.*/
#define _PUT_BOOL(name)			{boaWrite(wp, "cgi."#name" = %s;\n", ((name)==1) ? "true" : "false");}
/*ql:20080805 END*/

#define _PUT_ENTRY_STR(name)	{boaWrite(wp, "cgi."#name" = \"%s\";\n", entry.name);}
#define _PUT_ENTRY_IP(name)		{boaWrite(wp, "cgi."#name" = \"%s\";\n", inet_ntoa(*(struct in_addr*)&(entry.name)));}
#define _PUT_ENTRY_INT(name)	{boaWrite(wp, "cgi."#name" = %d;\n", entry.name);}
#define _PUT_ENTRY_BOOL(name)	{boaWrite(wp, "cgi."#name" = %d;\n", (entry.name) ? 1 : 0);}

#define _ENTRY_STR(name, opt)	{FETCH_INVALID_OPT(stemp, #name, opt); memset(entry.name, 0, sizeof(entry.name)); strncpy(entry.name, stemp, (sizeof(entry.name)-1));}
#define _ENTRY_IP(name, opt)	{FETCH_INVALID_OPT(stemp, #name, opt); *(unsigned long*)&(entry.name) = (*stemp?inet_addr(stemp):0);}
#define _ENTRY_IPV4(name, opt)	{FETCH_INVALID_OPT(stemp, #name, opt); *(unsigned int*)&(entry.name) = (*stemp?inet_addr(stemp):0);}
#define _ENTRY_IP_STR(name, addr, opt)	{FETCH_INVALID_OPT(stemp, #name, opt);inet_aton(stemp,&addr);*(unsigned long*)&(entry.name) = (*stemp?addr.s_addr:0);}
#define _ENTRY_INT(name, opt)	{FETCH_INVALID_OPT(stemp, #name, opt); entry.name = atoi(stemp);}
#define _ENTRY_BOOL(name, opt)	{FETCH_INVALID_OPT(stemp, #name, _OPT); entry.name = (strcmp(stemp, "on") == 0 )? 1 : 0;}

#define _COND_REDIRECT			{char *s = boaGetVar(wp, "submit-url", ""); if(s && *s) boaRedirect(wp, s);}

#define _ERR_MSG(msg) if(errcode){ \
	boaHeader(wp); \
	boaWrite(wp, "<head><script>function go_back_referrer(){if(document.referrer&&document.referrer!=\"\") window.location=document.referrer; else history.go(-1); return 0;}</script></head>\n");\
	boaWrite(wp, "<body><blockquote><h4>%s</h4>\n", msg); \
	boaWrite(wp, "<input type=\"button\" onclick=\"go_back_referrer()\" value=\"&nbsp;&nbsp;%s&nbsp;&nbsp\" name=\"OK\"></blockquote></body>",IDS_RESULT_OK); \
	boaFooter(wp); \
	boaDone(wp, 200); \
}
#define _ERR_MSG_WAN(msg,url) if(errcode){ \
	boaHeader(wp); \
	boaWrite(wp, "<body><blockquote><h4>%s</h4>\n", msg); \
	boaWrite(wp, "<input type=\"button\" onclick=window.location.replace(\"%s\"  value=\"&nbsp;&nbsp;OK&nbsp;&nbsp\" name=\"OK\"></blockquote></body>"),url); \
	boaFooter(wp); \
	boaDone(wp, 200); \
}

#define _OK_MSG(url) if(errcode){ \
	boaHeader(wp); \
	boaWrite(wp, "<body><blockquote><h4>%s</h4>\n",IDS_RESULT_EFFECT); \
	if (url[0]) boaWrite(wp, "<input type=button value=\"  %s \" OnClick=window.location.replace(\"%s\"></form></blockquote></body>"), IDS_RESULT_OK,url);\
	else boaWrite(wp, "<input type=button value=\"  %s  \" OnClick=window.close()></blockquote></body>",IDS_RESULT_OK);\
	boaFooter(wp); \
	boaDone(wp, 200); \
}

#define _OK_MSG1(msg, url) if(errcode){ \
	boaHeader(wp); \
	boaWrite(wp, "<body><blockquote><h4>%s</h4>\n", msg); \
	if (url) boaWrite(wp, "<input type=button value=\"  %s \" OnClick=window.location.replace(\"%s\"></blockquote></body>"), IDS_RESULT_OK,url);\
	else boaWrite(wp, "<input type=button value=\"  %s  \" OnClick=window.close()></blockquote></body>",IDS_RESULT_OK);\
	boaFooter(wp); \
	boaDone(wp, 200); \
}

/*
 * for strde
 */
#define _BC_OPT				_OPT
#define _BC_NEED			_NEED

#define _BC_USE				_bcode* bc = NULL; int bcindex = 0; const char *sbc = NULL; float bcv = 0.0f;

#define _BC_INIT(vname)		{\
	FETCH_INVALID_OPT(sbc, vname, _NEED); \
	bc = bc_decode(sbc);\
	if(bc == NULL) {lineno = __LINE__; goto check_err;}\
	}
#define _BC_ISLIST()				(bc->flag & _BC_FLAG_LIST)
#define _BC_ITCNT()					(bc->itcnt)
#define _BC_NEXT()					(bc_seek(bc, bcindex++, 0) >= 0)
#define _BC_FREE()					{if(bc){bc_free(bc); bc = NULL;}}
#ifdef _CGI_DEBUG_
#define _BC_ENTRY_STR(name, opt)	{if((sbc = bc_gets(bc, #name)) == NULL){lineno = __LINE__; continue;} printf("%s:%s\n", #name, sbc?sbc:""); memset(entry.name, 0, sizeof(entry.name));strncpy(entry.name, sbc, (sizeof(entry.name)-1));}
#define _BC_ENTRY_IP(name, opt)		{if((sbc = bc_gets(bc, #name)) == NULL){lineno = __LINE__; continue;} printf("%s:%s\n", #name, sbc?sbc:""); entry.name = inet_addr(sbc);}
#define _BC_ENTRY_IPV4(name, opt)	{if((sbc = bc_gets(bc, #name)) == NULL){lineno = __LINE__; continue;} printf("%s:%s\n", #name, sbc?sbc:""); inet_aton(sbc, (struct in_addr *)&entry.name);}
#define _BC_ENTRY_INT(name, opt)	{if(bc_getv(bc, #name, &bcv) == _BC_FALSE){lineno = __LINE__; continue;} printf("%s:%.2f\n", #name, bcv); entry.name = (int)bcv;}
#define _BC_ENTRY_INTX(name, opt)	{if(bc_getv(bc, #name, &bcv) == _BC_FALSE){lineno = __LINE__; continue;} printf("%s:%.2f\n", #name, bcv); name = (int)bcv;}
#else
#define _BC_ENTRY_STR(name, opt)	{if((sbc = bc_gets(bc, #name)) == NULL){lineno = __LINE__; continue;} memset(entry.name, 0, sizeof(entry.name)); strncpy(entry.name, sbc, (sizeof(entry.name)-1));}
#define _BC_ENTRY_IP(name, opt)		{if((sbc = bc_gets(bc, #name)) == NULL){lineno = __LINE__; continue;} *(unsigned long*)&(entry.name) = inet_addr(sbc);}
#define _BC_ENTRY_IPV4(name, opt)	{if((sbc = bc_gets(bc, #name)) == NULL){lineno = __LINE__; continue;} inet_aton(sbc, (struct in_addr *)&entry.name);}
#define _BC_ENTRY_INT(name, opt)	{if(bc_getv(bc, #name, &bcv) == _BC_FALSE){lineno = __LINE__; continue;} entry.name = (int)bcv;}
#define _BC_ENTRY_INTX(name, opt)	{if(bc_getv(bc, #name, &bcv) == _BC_FALSE){lineno = __LINE__; continue;} name = (int)bcv;}
#endif

typedef enum _itty{_itt_int8, _itt_int16, _itt_int32, _itt_string} _itty;
typedef struct _itval
{
	char* 	key;	/*key name*/
	_itty	ty;		/*value type*/
	int		len;	/*pval size if ty == _itt_string*/
	int*	pval;	/*zero based address*/
	char	opt;	/*is optional ?*/
}_itval;

#define _OFFSETT(type, field)		((unsigned long)(long *)&(((type *)0)->field))
#define _OFFSETO(o, field)			((unsigned long)(long *)&(o->field))
#define _ITDEF(k, t, l, addr, opt)	{k, t, l, addr, opt}

#define _IT_TRUE		1
#define _IT_FALSE		0

#define _PTS_XSS		", new it(\"%s\", unescapeHTML(\"%s\"))"
#define _PTS			", new it(\"%s\", \"%s\")"
#define _PTI			", new it(\"%s\", %d)"
#define _PTU			", new it(\"%s\", %u)"
//jim added to print unsigned long format..
#define _PTUL			", new it(\"%s\", %lu)"
#define _PTULL			", new it(\"%s\", %llu)"

#define _PME_XSS(name)	#name, strValToASP(entry.name)
#define _PME(name)		#name, entry.name
#define _PMEX(name)		#name, name
#define _PMEX_XSS(name)	#name, strValToASP(name)
#define _PMEIP(name)	#name, strcpy(name, inet_ntoa(*(struct in_addr*)&(entry.name)))
#define _PMEXIP(name)	#name, strcpy(name, inet_ntoa(*(struct in_addr*)&(name)))

int	it_batfetch(request * wp, char *path, char *query, _itval* pitval);
#define MIB_CHAIN_DELETE(id,type,entry) \
			int cnt=mib_chain_total(id);\
			int mib_index=0;\
			type mibentry;\
			for(mib_index=0;mib_index<cnt;mib_index++)\
			{\
			mib_chain_get(id,mib_index,&mibentry);	\
			if(!memcmp(&mibentry,&entry,sizeof(type)))\
					{\
					mib_chain_delete(id, mib_index);\
					break;\
				}\
			}
#define MIB_CHAIN_DELETE_CHT(id,type,entry) \
			int cnt_cht=mib_chain_total(id);\
			int mib_index_cht=0;\
			type mibentry_cht;\
			for(mib_index_cht=0;mib_index_cht<cnt_cht;mib_index_cht++)\
			{\
				mib_chain_get(id,mib_index_cht,&mibentry_cht);	\
				if(!strcmp(mibentry_cht.name,entry.name)&&!strcmp(mibentry_cht.mac,entry.mac)&&(mibentry_cht.mode==entry.mode))\
				{\
					mib_chain_delete(id, mib_index_cht);\
					break;\
				}\
			}
/******************************************
**以下是为方便调试而添加的临时的结构定义，来自web_cgi_interface
*/
typedef struct status_info {
	char servName[32];	//服务
	char ifname[16];		//接口( Port/VPI/VCI)
	char encaps[8];		//封装方式
	char servType[4];		//服务类别
	char protocol[10];	//协议
	char ipAddr[16];		//IP地址
	unsigned int vlanId;	// VLAN ID
	unsigned int connId;	// Con. ID (It seems constantly to be 1)
	int igmpEnbl;		// IGMP: 1-enable;  0-disable
	int qosEnbl;		// QoS: 1-enable;  0-disable
	int pvcEnbl;		// State: 1-enable;  0-disable
	char *strStatus;		//状态
} status_info;

/*dhcp设备信息*/
typedef struct dhcp_device_info {
	unsigned int uIpAddr;
	char devname[20];	//Computer; …
} dhcp_device_info;

#if _CGI_VER_TW10 //暂时屏蔽
typedef struct atmvc_entryx {
	unsigned int ifIndex;	//nop
	unsigned char vpi;	// VPI
	//mapped to "qos" of MIB_CE_ATM_VC_T and recorded in "svtype" of MIB_CE_ATM_VC_T for web display
	/*
		 "UBR Without PCR" and UBR With PCR"  -->  ATMQOS_UBR
		"CBR"          -->       ATMQOS_CBR
		"Non Realtime VBR"  --->    ATMQOS_VBR_NRT
		"Realtime VBR"  --->    ATMQOS_VBR_RT
	*/
	unsigned char svtype;		//服务类型：0-"UBR Without PCR", 1-"UBR With PCR", 2-"CBR", 3-"Non Realtime VBR", 4-"Realtime VBR"
	unsigned short vci;	// VCI
	unsigned short pcr;	// 峰值信元速率
	unsigned short scr;	// 持续信元速率
	unsigned short mbs;	// 最大突发信元大小
	//unsigned int cdvt;	// nop
	unsigned char encap;	// 封装方式: 1- LLC;  0- VC- Mux
	unsigned char napt;	// NAT
#if defined(CONFIG_IPV6)
	unsigned char napt_v6;	// NATv6 0:disable, 1:natv6 2:nptv6
#ifdef CONFIG_USER_NDPPD
	unsigned char ndp_proxy;
#endif
#endif
	unsigned char cmode;	//0- bridge; (1-2)- Route; 2- PPPoE
	unsigned char brmode;	// 0: transparent bridging, 1: PPPoE bridging(PPPoE路由桥混合模式)
	unsigned char AddrMode;            // Bitmap, bit0: Slaac, bit1: Static, bit2: DS-Lite , bit3: 6rd, bit4: DHCP Client
	unsigned char pppUsername[MAX_PPP_NAME_LEN+1];	//用户名
	unsigned char pppPassword[MAX_PPP_PWD_LEN+1];	//密码
	unsigned char pppAuth;	// 0:AUTO, 1:PAP, 2:CHAP
	unsigned char pppACName[MAX_NAME_LEN];	// nop
	unsigned char pppServiceName[MAX_NAME_LEN];	//服务名称
	unsigned char pppCtype;	//拨号方式: 0- 自动连接;  1- 有流量时自动连接
	unsigned short pppIdleTime;	// nop
	unsigned short pppLcpEcho;
	unsigned short pppLcpEchoRetry;
	unsigned char ipDhcp;		//0- Static, 1- DHCP
	//unsigned char rip;		// nop
	unsigned char ipAddr[IP_ADDR_LEN];		//IP地址
	unsigned char remoteIpAddr[IP_ADDR_LEN];	//缺省网关
	unsigned char dgw;		//nop
	unsigned int mtu;			//nop
	unsigned char enable;		//nop
	unsigned char netMask[IP_ADDR_LEN];	//子网掩码
	//unsigned char ipunnumbered;	// nop
	unsigned char dnsMode;  // 1: enable, 0: disable
	unsigned char v4dns1[IP_ADDR_LEN];
	unsigned char v4dns2[IP_ADDR_LEN];
//#ifdef CONFIG_EXT_SWITCH
	// used for VLAN mapping
	unsigned char vlan;	// 启用VLAN
	unsigned short vid;	// VLAN ID
	unsigned short vprio;	// 802.1p priority bits
	unsigned char vpass;	// vlan passthrough
	unsigned int itfGroup;			//bit0- LAN 1; bit1- LAN 2; …; bit 4- WLAN ROOT; bit5- WLAN SSID1; ...
//#endif
//unsigned long cpePppIfIndex;   // Mason Yu. Remote Management
//unsigned long cpeIpIndex;      // Mason Yu. Remote Management

	unsigned char qos;	// QoS     mapped to "qosenable" of MIB_CE_ATM_VC_T

	unsigned char PPPoEProxyEnable;		//启用PPPoE代理
	unsigned int  PPPoEProxyMaxUser;	//代理用户数
	unsigned int applicationtype;  		//BOTH,INTERNET, TR069, Other
	unsigned char disableLanDhcp;  /* disable dhcp on lan interface binding with this wan interface */
#if defined(CONFIG_IPV6) && defined(DUAL_STACK_LITE)
	unsigned char dslite_enable;
	unsigned char dslite_aftr_mode;	//0: auto, 1:manual
	unsigned char dslite_aftr_hostname[64];
#endif
#ifdef SUPPORT_DHCP_PASS_THR_FOR_PPPOE_BRIDGE
	unsigned char enableDhcpPass;
#endif
#ifdef CONFIG_USER_CTCAPD
	unsigned char iptvwan;
#endif
#if defined(CONFIG_USER_NEW_BR_FOR_BRWAN)
	unsigned char newbr;
#endif
#if defined(CONFIG_SUPPORT_HQOS_APPLICATIONTYPE)
	unsigned char ipoeName[MAX_IPOE_NAME_LEN+1];
	unsigned char ipoePassword[MAX_IPOE_PWD_LEN+1];
#endif
} __PACK__ atmvc_entryx;
#if defined(CONFIG_USER_RTK_MULTI_BRIDGE_WAN)
typedef struct brwan_entryx {
	unsigned int ifIndex;	//nop
	unsigned char cmode;	//0- bridge; (1-2)- Route; 2- PPPoE
	unsigned char brmode;	// 0: transparent bridging, 1: PPPoE bridging(PPPoE路由桥混合模式)
	unsigned int mtu;
	unsigned char ipDhcp;		//0- Static, 1- DHCP
	unsigned char enable;		//nop
	unsigned char vlan;	// 启用VLAN
	unsigned short vid;	// VLAN ID
	unsigned short vprio;	// 802.1p priority bits
	unsigned char vpass;	// vlan passthrough
	unsigned int itfGroup;			//bit0- LAN 1; bit1- LAN 2; …; bit 4- WLAN ROOT; bit5- WLAN SSID1; ...
	unsigned int applicationtype;  		//BOTH,INTERNET, TR069, Other
	unsigned char disableLanDhcp;  /* disable dhcp on lan interface binding with this wan interface */
#ifdef CONFIG_USER_CTCAPD
	unsigned char iptvwan;
#endif
} __PACK__ brwan_entryx;
#endif
#endif

typedef struct dhcpd_entry {
	unsigned int dhcpRangeStart;		//初始IP地址
	unsigned int dhcpRangeEnd;		//终止IP地址
	unsigned int ipMask;			//子网掩码
	unsigned int ulTime;			//延续时间(单位: 秒)
}dhcpd_entry;


#if _CGI_VER_TW10 //暂时屏蔽
typedef struct macBaseDhcp_entryx {
	unsigned char macAddr[20];	//MAC地址
	unsigned char ipAddr[20];	//IP地址
} __PACK__ macBaseDhcp_entryx;
#endif

typedef struct dhcp_client_entry {
	unsigned int pcRangeStart;		//PC起始地址
	unsigned int pcRangeEnd;		//PC终止地址
	unsigned int cmrRangeStart;		//摄像头起始地址
	unsigned int cmrRangeEnd;		//摄像头终止地址
	unsigned int stbRangeStart;		//机顶盒起始地址
	unsigned int stbRangeEnd;		//机顶盒终止地址
	unsigned int phoneRangeStart;
	unsigned int phoneRangeEnd;
#ifdef CONFIG_CU
	unsigned int pcTime;//PC lease time
	unsigned int cmrTime;//camera lease time
	unsigned int stbTime;//stb lease time
	unsigned int phoneTime;//phone lease time
#endif
}dhcp_client_entry;

#if _CGI_VER_TW10 //暂时屏蔽
typedef struct rip_entryx {
	unsigned char ifIndex;		//nop
	char ifname[32];			//接口名
	unsigned char version;		//版本
	unsigned char operation;	//操作: 1- Active;  0- Passive
	unsigned char enable;		//启用
} __PACK__ rip_entryx;
#endif

typedef struct ipfilter_blacklist_entry {
	char filterName[32];		//过滤器名
#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
	char WanPath[16];		//WAN 接口
#endif
	unsigned char protoType;	//协议(0- 无;  1- TCP/UDP;  2- TCP;  3- UDP;  4- ICMP)
	unsigned int sipStart;		//源起始IP
	unsigned int sipEnd;		//源终止IP
	unsigned int smask;		//源子网掩码
	unsigned short sportStart;	//源起始端口
	unsigned short sportEnd;	//源终止端口
	unsigned int dipStart;		//目的起始IP
	unsigned int dipEnd;		//目的终止IP
	unsigned int dmask;		//目的子网掩码
	unsigned short dportStart;	//目的起始端口
	unsigned short dportEnd;	//目的终止端口
	unsigned char enable;	
} __PACK__ ipfilter_blacklist_entry;

typedef struct ipfilter_whitelist_entry {
	char filterName[32];		//过滤器名
#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
	char WanPath[16];		//WAN 接口
#endif
	unsigned char protoType;	//协议(0- 无;  1- TCP/UDP;  2- TCP;  3- UDP;  4- ICMP)
	unsigned int sipStart;		//源起始IP
	unsigned int sipEnd;		//源终止IP
	unsigned int smask;		//源子网掩码
	unsigned short sportStart;	//源起始端口
	unsigned short sportEnd;	//源终止端口
	unsigned int dipStart;		//目的起始IP
	unsigned int dipEnd;		//目的终止IP
	unsigned int dmask;		//目的子网掩码
	unsigned short dportStart;	//目的起始端口
	unsigned short dportEnd;	//目的终止端口
	unsigned char enable;

	/*** Need to sync with ipfilter_blacklist_entry above this line ***/
	unsigned char allport;		//全选
	unsigned char portnum;		//选中端口数
	char **ifname;					//选中端口名
} __PACK__ ipfilter_whitelist_entry;

#if _CGI_VER_TW10 //暂时屏蔽
typedef struct ddns_entryx {
	unsigned char provider[10];
	unsigned char hostname[35];
	//unsigned char interface[32]; //interface is a key for compiler
	unsigned char ifname[32];
	unsigned char username[35];
	unsigned char password[35];
#ifdef CONFIG_CMCC_ENTERPRISE
	unsigned char Enabled;
#endif
} __PACK__ ddns_entryx;
#endif
typedef struct igmproxy_entry {
	unsigned char ifName[40];	//接口名
	unsigned char enable;		//IGMP启用
} __PACK__ igmproxy_entry;

#ifdef CONFIG_RTK_DEV_AP
typedef struct mldproxy_entry {
	unsigned char ifName[40];	//接口名
	unsigned char enable;		//MLD启用
} __PACK__ mldproxy_entry;
#endif
#ifdef CONFIG_CMCC_ENTERPRISE
typedef struct mldproxy_entry {
	unsigned char ifName[40];
	unsigned char enable;
	unsigned int ifidx;
} __PACK__ mldproxy_entry;
#endif
typedef struct access_syslog_entry {
	char dateTime[32];		//日期/时间
	char severity[16];		//严重程度
	char *msg;				//信息
} __PACK__ access_syslog_entry;

/*info*/
/*
extern int getvar(int eid, request * wp, int argc, char ** argv);
extern int cgivar(int eid, request * wp, int argc, char ** argv);
*/

/*status*/

extern int listWanConfig(int eid, request * wp, int argc, char ** argv);
#ifdef CONFIG_CMCC_ENTERPRISE
extern int listWanStatus(int eid, request * wp, int argc, char **argv);
extern int listWanStatistics(int eid, request * wp, int argc, char ** argv);
extern int listWlanStatus(int eid, request * wp, int argc, char **argv);
extern int listWlanMainStatus(int eid, request * wp, int argc, char **argv);
extern int listWlan5GMainStatus(int eid, request * wp, int argc, char **argv);
#endif
#ifdef CONFIG_IPV6
extern int listWanConfigIpv6(int eid, request * wp, int argc, char ** argv);
#endif
#ifdef SUPPORT_WAN_BANDWIDTH_INFO
int listWanBandwidth(int eid, request * wp, int argc, char **argv);
#endif
extern int wlStatsList(int eid, request * wp, int argc, char **argv);
extern int wlStatus_parm(int eid, request * wp, int argc, char **argv);
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC) || defined(CONFIG_USER_AP_CMCC)
extern int wlStatsList_24G(int eid, request * wp, int argc, char **argv);
extern int wlStatus_parm_24G(int eid, request * wp, int argc, char **argv);
extern int wlan_interface_status_24G(int eid, request * wp, int argc, char **argv);
#if	defined(WLAN_DUALBAND_CONCURRENT)
extern int wlStatsList_5G(int eid, request * wp, int argc, char **argv);
extern int wlStatus_parm_5G(int eid, request * wp, int argc, char **argv);
extern int wlan_interface_status_5G(int eid, request * wp, int argc, char **argv);
#endif
#endif
extern int E8BPktStatsList(int eid, request * wp, int argc, char **argv);
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
extern int E8BLanDevList(int eid, request * wp, int argc, char **argv);
#else
extern int E8BDhcpClientList(int eid, request * wp, int argc, char **argv);
#endif
extern int getifstatus(int eid, request * wp, int argc, char **argv);
extern int addHttpNoCache(int eid, request * wp, int argc, char ** argv);
/*net*/
extern int listWanif(int eid, request * wp, int argc, char ** argv);
#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
extern int listWanPath(int eid, request * wp, int argc, char ** argv);
#endif
extern int initPageAdsl(int eid, request * wp, int argc, char ** argv);
extern int initPageAdsl2(int eid, request * wp, int argc, char ** argv);
#if defined(CONFIG_ETHWAN)
extern int initPageEth(int eid, request * wp, int argc, char ** argv);
extern int initPageEth2(int eid, request * wp, int argc, char ** argv);
extern void formEthernet(request * wp, char *path, char *query);
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
extern void formEthernet_cmcc(request * wp, char *path, char *query);
#ifdef CONFIG_CMCC_ENTERPRISE
extern int initPageNetworkWizard(int eid, request * wp, int argc, char ** argv);
extern int initProductInfo(int eid, request * wp, int argc, char ** argv);
extern int cmccEnterpriseHtmlDocType(int eid, request * wp, int argc, char ** argv);
extern int cmccEnterpriseHtmlCommonHead(int eid, request * wp, int argc, char ** argv);
extern int show_lan_staticis(int eid, request * wp, int argc, char ** argv);
extern int show_wan_staticis(int eid, request * wp, int argc, char ** argv);
extern void mac_filter_Form(request * wp, char *path, char *query);
#ifdef SUPPORT_TIME_SCHEDULE
extern void formSchedule(request * wp, char *path, char *query);
extern void formSchedList(request * wp, char *path, char *query);
extern int schedTableList(int eid, request * wp, int argc, char **argv);
extern int schedList_select(int eid, request * wp, int argc, char **argv);
#endif
extern int cmccEnterpriseHtmlIPQosInitPage(int eid, request * wp, int argc, char **argv);
extern void ip_qos_Form(request * wp, char* path, char* query);
extern void ip_download_qos_Form(request * wp, char* path, char* query);
extern void ip_qos_car_Form(request * wp, char* path, char* query);
extern int init_ip_filter_In(int eid,request * wp,int argc,char * * argv);
extern int init_ip_filter_Out(int eid,request * wp,int argc,char * * argv);
extern void ip_filter_Form(request * wp, char *path, char *query);
extern int initFirewallCfg(int eid, request * wp, int argc, char ** argv);
extern int initEnterprisePageURL(int eid, request * wp, int argc, char ** argv);
#endif
#ifdef DHCP_ARP_IGMP_RATE_LIMIT
extern int initPageL2Limit (int eid, request * wp, int argc, char ** argv);
extern void formL2Limit(request * wp, char *path, char *query);
#endif
#endif
extern int initVlanRange(int eid, request * wp, int argc, char ** argv);
#if defined(CONFIG_USER_RTK_MULTI_BRIDGE_WAN)
extern int initPageBr(int eid, request * wp, int argc, char ** argv);
extern void formBridgeWan(request * wp, char *path, char *query);
#endif
#endif
extern int initPageQoSAPP(int eid, request * wp, int argc, char ** argv);
extern int initdgwoption(int eid, request * wp, int argc, char ** argv);
extern void formAdsl(request * wp, char *path, char *query);
extern void formAdslClt(request * wp, char *path, char *query);	//客户端
extern void formSetAdsl(request * wp, char *path, char *query);
extern int init_dsl_page(int eid, request * wp, int argc, char **argv);
extern int showLanDns1(int eid, request * wp, int argc, char ** argv);
extern int showLanDns2(int eid, request * wp, int argc, char ** argv);
extern void formDhcpd(request * wp, char *path, char *query);
#ifdef CONFIG_USER_WAN_PORT_AUTO_SELECTION
extern void formWanPortSet(request *wp, char *path, char *query);
#endif
#ifdef CONFIG_USER_WAN_MODE_SWITCH
extern void formSwitchWanMode(request *wp, char *path, char *query);
#endif
#ifdef CONFIG_USER_DNS_RELAY_PROXY
extern void formlanipv4dns(request * wp, char *path, char *query);
#endif
extern int init_dhcpmain_page(int eid, request * wp, int argc, char **argv);
//ql_xu
#ifdef _PRMT_X_CT_COM_USERINFO_
extern int initE8clientUserRegPage(int eid, request * wp, int argc, char **argv);
extern int getProvinceInfo(int eid, request * wp, int argc, char **argv);
extern int regresultBodyStyle(int eid, request * wp, int argc, char **argv);
extern int regresultMainDivStyle(int eid, request * wp, int argc, char **argv);
extern int regresultBlankDivStyle(int eid, request * wp, int argc, char **argv);
extern int regresultLoginStyle(int eid, request * wp, int argc, char **argv);
extern int regresultLoginFontStyle(int eid, request * wp, int argc, char **argv);
extern int e8clientAccountRegResult(int eid, request * wp, int argc, char **argv);
extern int e8clientAutorunAccountRegResult(int eid, request * wp, int argc, char **argv);
extern void formAccountReg(request * wp, char *path, char *query);
extern int UserAccountRegResult(int eid, request * wp, int argc, char **argv);
#ifdef CONFIG_CMCC_ENTERPRISE
extern int initFloidCfg(int eid, request * wp, int argc, char ** argv);
extern int initLoidConfigCfg(int eid, request * wp, int argc, char ** argv);
extern int loginQuickRegisterResult(int eid, request * wp, int argc, char **argv);
extern int initOltRegisterStatus(int eid, request * wp, int argc, char **argv);
extern void formUserReg_inside_menu_pwd(request * wp, char *path, char *query);
extern void formUserReg_inside_menu_h5(request * wp, char *path, char *query);
#endif
extern void formUserReg(request * wp, char *path, char *query);
extern void formUserReg_inside_menu(request * wp, char *path, char *query);
extern int UserRegMsg(int eid, request * wp, int argc, char **argv);
extern int UserRegMsgPassword(int eid, request * wp, int argc, char **argv);
extern int UserInsideRegPage(int eid, request * wp, int argc, char **argv);
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
extern int UserInsideRegLoidPage(int eid, request * wp, int argc, char **argv);
#endif
extern int checkPopupRegPage(int eid, request * wp, int argc, char **argv);
#endif
#ifdef SUPPORT_PUSHWEB_FOR_FIRMWARE_UPGRADE
extern void formFirmwareUpgradeWarn(request * wp, char *path, char *query);
extern int initFirmwareUpgradeWarnPage(int eid, request * wp, int argc, char **argv);
#endif
extern void formIpRange(request * wp, char *path, char *query);
#ifdef CONFIG_CU_BASEON_CMCC
extern void formIPForward(request * wp, char *path, char *query);
extern int rteIPForwardList(int eid, request * wp, int argc, char ** argv);
#endif
extern int init_dhcp_device_page(int eid, request * wp, int argc, char **argv);
extern void formMacAddrBase(request * wp, char *path, char *query);
extern int showMACBaseTable(int eid, request * wp, int argc, char **argv);
#ifdef CONFIG_CMCC_ENTERPRISE
extern void formdhcpv4_cmcc_ent(request * wp, char *path, char *query);
extern void formdhcpv6_cmcc_ent(request * wp, char *path, char *query);
#endif
extern void formWlanSetup(request * wp, char *path, char *query);
#ifdef CONFIG_CMCC_ENTERPRISE
extern void formEntQuickWlanSetup(request * wp, char *path, char *query);
extern void formEntWlanSetup(request * wp, char *path, char *query);
#endif
extern int init_wlan_page(int eid, request * wp, int argc, char **argv);
#ifdef WLAN_MBSSID
extern void formMBSSID(request * wp, char *path, char *query);
extern int init_mbssid_page(int eid, request * wp, int argc, char **argv);
#endif
extern void formWlEncrypt(request * wp, char *path, char *query);
extern int init_wlanAdv_page(int eid, request * wp, int argc, char **argv);
extern void formTR069Config(request * wp, char *path, char *query);
extern void formCertcaInsert(request * wp, char *path, char *query);
extern int showCert(int eid, request * wp, int argc, char **argv);
extern void formTR069CertDel(request * wp, char *path, char *query);
extern void formTimezone(request * wp, char *path, char *query);
extern int init_sntp_page(int eid, request * wp, int argc, char **argv);
extern void formRoute(request * wp, char *path, char *query);
extern void formRip(request * wp, char *path, char *query);
extern int showRipIf(int eid, request * wp, int argc, char **argv);
extern int showStaticRoute(int eid, request * wp, int argc, char **argv);
#ifdef CONFIG_CU_BASEON_CMCC
extern int showIPForwardList(int eid, request * wp, int argc, char **argv);
#endif
#if defined(CONFIG_USER_VLAN_MAPPING)
extern int initPagePBind(int eid, request * wp, int argc, char ** argv);
extern void formVlanMapping(request * wp, char *path, char *query);
#endif
#if defined(CONFIG_USER_PORT_ISOLATION)
extern int initPagePIsolation(int eid, request * wp, int argc, char ** argv);
extern void formPortIsolation(request * wp, char *path, char *query);
#endif

#ifdef CONFIG_CMCC_MULTICAST_CROSS_VLAN_SUPPORT
extern int initCrossVlan(int eid, request * wp, int argc, char ** argv);
extern void formCrossVlan(request * wp, char *path, char *query);
#endif
#if (defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)) && defined(CONFIG_IPV6)
extern void formIPv6Binding(request * wp, char *path, char *query);
extern int showIPv6Binding(int eid, request * wp, int argc, char ** argv);
extern	void formVlanCfg(request * wp, char *path, char *query);
#endif
#ifdef CONFIG_USER_CUSPEEDTEST
extern void formSpeedtest(request * wp, char *path, char *query);
#endif
#ifdef CONFIG_MCAST_VLAN
extern int listWanName(int eid, request * wp, int argc, char ** argv);
extern void formMcastVlanMapping(request * wp, char *path, char *query);
#endif

/*security*/
extern int initPageURL(int eid, request * wp, int argc, char ** argv);
extern void formURL(request * wp, char *path, char *query);
extern int initPageFirewall(int eid, request * wp, int argc, char ** argv);
extern void formFirewall(request * wp, char *path, char *query);
extern int initPageDos(int eid, request * wp, int argc, char ** argv);
extern void formDos(request * wp, char *path, char *query);
extern void formIpv6SessionFw(request * wp, char *path, char *query);
extern int brgMacFilterList(int eid, request * wp, int argc, char ** argv);
extern void formBrgMacFilter(request * wp, char *path, char *query);
extern int initPageMacFilter(int eid, request * wp, int argc, char ** argv);
extern int rteMacFilterList(int eid, request * wp, int argc, char ** argv);
extern void formRteMacFilter(request * wp, char *path, char *query);
#ifdef WLAN_SEC_WEB_ENABLE
extern int WlanMacFilterList(int eid, request * wp, int argc, char ** argv);
extern void formWlanMacFilter(request * wp, char *path, char *query);
#endif
#ifdef SUPPORT_DNS_FILTER
extern int initPageDNS(int eid, request * wp, int argc, char ** argv);
extern void formDNSFilter(request * wp, char *path, char *query);
#endif
#ifdef CONFIG_SUPPORT_CAPTIVE_PORTAL
extern void formURLRedirect(request * wp, char *path, char *query);
#endif
#ifdef CONFIG_VIR_BOA_JEMBENCHTEST
extern int init_jembenchtest_page(int eid, request * wp, int argc, char **argv);
#endif

#ifdef LED_TIMER
extern void formLedTimer(request * wp, char *path, char *query);
#endif

#ifdef SLEEP_TIMER
extern int initPageSleepModeRule(int eid, request * wp, int argc, char ** argv);
extern void formSleepMode(request * wp, char *path, char *query);
#endif

#ifdef CONFIG_USER_LAN_BANDWIDTH_MONITOR
extern int initPageLanBandwidthMonitor(int eid, request * wp, int argc, char ** argv);
extern void formBandwidthMonitor(request * wp, char *path, char *query);
#endif

#ifdef CONFIG_USER_LAN_BANDWIDTH_CONTROL
extern int initPageBandwidthControl(int eid, request * wp, int argc, char ** argv);
extern void formBandWidth(request * wp, char *path, char *query);
#endif

#ifdef CONFIG_USER_LANNETINFO
extern int initPageLanNetInfo(int eid, request * wp, int argc, char ** argv);
#endif

extern int bandwidthSelect(int eid, request * wp, int argc, char ** argv);
extern int initPagePortBWControl(int eid, request * wp, int argc, char ** argv);
extern void formPortBandWidth(request * wp, char *path, char *query);

extern int ipPortFilterConfig(int eid, request * wp, int argc, char ** argv);
extern int ipPortFilterBlacklist (int eid, request * wp, int argc, char ** argv);
extern int ipPortFilterWhitelist (int eid, request * wp, int argc, char ** argv);
extern void formPortFilter(request * wp, char *path, char *query);
extern void formPortFilterWhite(request * wp, char *path, char *query);
extern void formPortFilterBlack(request * wp, char *path, char *query);
#if defined(CONFIG_APACHE_FELIX_FRAMEWORK) && defined(CONFIG_CMCC)
extern void formPermission(request * wp, char *path, char *query);
extern void formBundleUpload(request * wp, char *path, char *query);
extern void formBundleInstall(request * wp, char *path, char *query);
#endif
#if defined(CONFIG_CMCC) || defined(CONFIG_CU)
extern int ipPortFilterDirConfig(int eid, request * wp, int argc, char ** argv);
extern int ipPortFilterBlacklistIn (int eid, request * wp, int argc, char ** argv);
extern int ipPortFilterBlacklistOut (int eid, request * wp, int argc, char ** argv);
extern int ipPortFilterWhitelistIn (int eid, request * wp, int argc, char ** argv);
extern int ipPortFilterWhitelistOut (int eid, request * wp, int argc, char ** argv);
extern void formPortFilterIn(request * wp, char *path, char *query);
extern void formPortFilterOut(request * wp, char *path, char *query);
extern void formPortFilterWhiteIn(request * wp, char *path, char *query);
extern void formPortFilterWhiteOut(request * wp, char *path, char *query);
extern void formPortFilterBlackIn(request * wp, char *path, char *query);
extern void formPortFilterBlackOut(request * wp, char *path, char *query);
extern void formPortFilterPort(request * wp, char *path, char *query);
extern int initPagePortFilter(int eid, request * wp, int argc, char ** argv);
#endif
extern FILE * _uploadGet(request *wp, unsigned int *startPos, unsigned *endPos);
extern int strip_http(const char *fname, unsigned int offset, unsigned int nLen);
/*management*/
extern int initPageMgmUser(int eid, request * wp, int argc, char ** argv);
extern void formPasswordSetup(request * wp, char *path, char *query);
#ifdef CONFIG_CMCC_ENTERPRISE
extern int AccountList (int eid, request * wp, int argc, char **argv);
extern int ShowAccountList(int eid, request * wp, int argc, char **argv);
#endif
extern void formReboot(request * wp, char *path, char *query);
#ifdef CONFIG_USB_SUPPORT
extern void formUSBbak(request * wp, char *path, char *query);
extern void formUSBUmount(request * wp, char *path, char *query);
#endif
#ifdef CONFIG_USER_RTK_SYSLOG
extern int initPageSysLog(int eid, request * wp, int argc, char ** argv);
extern void formSysLog(request * wp, char *path, char *query);
extern int sysLogList(int eid, request * wp, int argc, char ** argv);
extern int initPageSysLogConfig(int eid, request * wp, int argc, char ** argv);
extern void formSysLogConfig(request * wp, char *path, char *query);
#endif
extern int initPageMntMnt(int eid, request * wp, int argc, char ** argv);
extern int initPagePingResult(int eid, request * wp, int argc, char ** argv);
extern void formDiagTest(request * wp, char *path, char *query);
extern int initPageUSBbak(int eid, request * wp, int argc, char ** argv);

/*application*/
extern int showDNSTable(int eid, request * wp, int argc, char **argv);
extern void formDDNS(request * wp, char *path, char *query);
#ifdef CONFIG_IP_NF_ALG_ONOFF
extern int showAlgConfig(int eid, request * wp, int argc, char **argv);
extern void formALGOnOff(request * wp, char *path, char *query);
#ifdef CONFIG_CMCC_ENTERPRISE
extern int init_alg_page(int eid, request * wp, int argc, char **argv);
#endif
#endif
#ifdef DMZ_SUPPORT
extern int showDmzConfig(int eid, request * wp, int argc, char **argv);
extern void formDMZ(request * wp, char *path, char *query);
#endif
#ifdef VIRTUAL_SERVER_SUPPORT
extern int virtualSvrList (int eid, request * wp, int argc, char **argv);
extern int virtualSvrLeft(int eid, request * wp, int argc, char **argv);
extern void formVrtsrv(request * wp, char *path, char *query);
#endif
#ifdef PORT_TRIGGER_SUPPORT
extern int PortTriggerList(int eid, request * wp, int argc, char **argv);
extern void formPortTrigger(request * wp, char *path, char *query);
extern int portTriggerLeft(int eid, request * wp, int argc, char **argv);
#endif
extern int initPageUpnp(int eid, request * wp, int argc, char ** argv);
extern void formUpnp(request * wp, char *path, char *query);
#ifdef CONFIG_CMCC_ENTERPRISE
extern int MLDProxyList(int eid, request * wp, int argc, char ** argv);
#endif
#ifdef CONFIG_RTK_DEV_AP
extern int mldproxyList(int eid, request * wp, int argc, char ** argv);
#endif
extern void formMLDProxy(request * wp, char *path, char *query);	// Mason Yu. MLD Proxy
extern void formModify(request * wp, char *path, char *query);
extern void formFactory(request * wp, char *path, char *query);
extern void formVendorVersion(request * wp, char *path, char *query);
extern int initHidePage(int eid, request * wp, int argc, char ** argv);
extern int initFactory(int eid, request * wp, int argc, char ** argv);
extern int initVendorVersion(int eid, request * wp, int argc, char ** argv);
extern int initPageIgmpSnooping(int eid, request * wp, int argc, char ** argv);
extern void formMLDSnooping(request * wp, char *path, char *query);
extern int igmproxyList(int eid, request * wp, int argc, char ** argv);
extern void formIgmproxy (request * wp, char *path, char *query);
#ifdef CONFIG_USB_SUPPORT
extern int listUsbDevices(int eid, request * wp, int argc, char ** argv);
#endif
extern int initPageStorage(int eid, request * wp, int argc, char ** argv);
extern void formApplication(request * wp, char *path, char *query);
extern void formServiceMgr(request * wp, char *path, char *query);
#ifdef CONFIG_PORT_MIRROR
extern void formPortMirror(request * wp, char *path, char *query);
extern int initPagePortMirror(int eid, request * wp, int argc, char ** argv);
#endif
extern int RestoreFactoryMode(int eid, request * wp, int argc, char **argv);
#ifdef CONFIG_CT_AWIFI_JITUAN_FEATURE
extern void formAwifiStation(request * wp, char *path, char *query);
extern int initAwifiNetwork(int eid, request * wp, int argc, char ** argv);
extern void formAwifiNetwork(request * wp, char *path, char *query);
extern int initAwifiLanAuth(int eid, request * wp, int argc, char ** argv);
extern void formAwifiLanAuth(request * wp, char *path, char *query);
extern int initAwifiSiteServer(int eid, request * wp, int argc, char ** argv);
extern void formAwifiSiteServer(request * wp, char *path, char *query);
extern int initAwifiDefaultServer(int eid, request * wp, int argc, char ** argv);
extern void formAwifiDefaultServer(request * wp, char *path, char *query);
extern int initAwifiUpdateCfg(int eid, request * wp, int argc, char ** argv);
extern void formAwifiUpdateCfg(request * wp, char *path, char *query);
#endif
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
extern int show_LAN_status_cmcc(int eid, request * wp, int argc, char **argv);
#else
extern int show_LAN_status(int eid, request * wp, int argc, char **argv);
#endif
#ifdef CONFIG_CU_BASEON_CMCC
extern int show_LAN_linkstatus(int eid, request * wp, int argc, char **argv);
#endif
#ifdef CONFIG_CU
extern int addHttpstyle(int eid, request * wp, int argc, char **argv);
#endif

#if defined(CONFIG_USER_SAMBA)
extern void formSambaAccount(request * wp, char *path, char *query);
extern int showSambaAccount(int eid, request * wp, int argc, char **argv);
#endif

extern void changeMacFormat(char *str, char s, char d);

#ifdef CONFIG_USER_RTK_BRIDGE_MODE
extern int initOpmode(int eid, request * wp, int argc, char **argv);
#endif

#if 0
#define UNDOWAIT 0
#define DOWAIT 1
#define MAX_SPACE_LEGNTH 1024
#define DOCMDINIT \
        char cmdargvs[MAX_SPACE_LEGNTH]={0};\
        int argvs_index=1;\
        char *_argvs[32]; \
        char *_saveptr = NULL;
#endif

#endif // _INCLUDE_FMDEFS_H
