/*
 *      Web server handler routines for DHCP Server stuffs
 *      Authors: Kaohj	<kaohj@realtek.com.tw>
 *
 */


/*-- System inlcude files --*/
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <dirent.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <signal.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <sys/wait.h>
#include <time.h>
#include <net/route.h>
#include <sys/ioctl.h>
#include <signal.h>
#include <sys/ioctl.h>
#include <linux/if.h>

/*-- Local inlcude files --*/
#include "../webs.h"
#include "fmdefs.h"
#include "mib.h"
#include "subr_net.h"
#include <rtk/utility.h>
#include "cJSON.h"

#ifdef CONFIG_RTK_DNS_TRAP
#include "sockmark_define.h"
#endif

#ifdef __i386__
#define _LITTLE_ENDIAN_
#endif

/*-- Macro declarations --*/
#ifdef _LITTLE_ENDIAN_
#define ntohdw(v) ( ((v&0xff)<<24) | (((v>>8)&0xff)<<16) | (((v>>16)&0xff)<<8) | ((v>>24)&0xff) )

#else
#define ntohdw(v) (v)
#endif

///////////////////////////////////////////////////////////////////
#define goto_dhcp_check_err(errorStr) \
    do {lineno = __LINE__; snprintf(tmpBuf, sizeof(tmpBuf), "%s", errorStr); goto check_err;} while(0)

int setLanIp(unsigned int uiIp, unsigned int uiMask)
{
	struct in_addr inOrigIp, inOrigMask;
	unsigned char ucLanIpChanged = 0, ucWLanState = 0;

	mib_get_s(MIB_ADSL_LAN_IP, (void *)&inOrigIp, sizeof(inOrigIp));
	if (inOrigIp.s_addr != uiIp)
	{
		ucLanIpChanged = 1;
		delete_dsldevice_on_hosts();
		mib_set(MIB_ADSL_LAN_DHCP_GATEWAY, (void *)&uiIp);
		mib_set(MIB_ADSL_LAN_IP, (void *)&uiIp);
		add_dsldevice_on_hosts();
		syslog(LOG_INFO, "DHCP: Change Lan IP %s", inet_ntoa(*(struct in_addr *)&uiIp));
	}

	mib_get_s(MIB_ADSL_LAN_SUBNET, (void *)&inOrigMask, sizeof(inOrigMask));
	if (inOrigMask.s_addr != uiMask)
	{
		ucLanIpChanged = 1;
		mib_set(MIB_ADSL_LAN_SUBNET, (void *)&uiMask);
		syslog(LOG_INFO, "DHCP: Change Lan Subnet %s", inet_ntoa(*(struct in_addr *)&uiMask));
	}

	if (ucLanIpChanged)
	{
		mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);
		restart_lanip();
#if defined(WEB_HTTP_SERVER_BIND_IP)|| defined(RTK_WEB_HTTP_SERVER_BIND_DEV)
		rebind_web_socket();
#endif
	}

	return ucLanIpChanged;
}

#if defined(IP_BASED_CLIENT_TYPE) && defined(CONFIG_CU_BASEON_CMCC)
void autoSetDhcpServingPool()
{
	struct in_addr inIp, inMask;
	struct in_addr inDhcpPoolStart, inDhcpPoolEnd;
	int i, entryNum;
	DHCPS_SERVING_POOL_T dhcppoolentry;
	unsigned int poolstartAddr, poolendAddr;
	unsigned int newpoolstartAddr, newpoolendAddr;

	mib_get_s(MIB_ADSL_LAN_IP, (void *)&inIp, sizeof(inIp));
	mib_get_s(MIB_ADSL_LAN_SUBNET, (void *)&inMask, sizeof(inMask));
	mib_get_s(MIB_DHCP_POOL_START, (void *)&inDhcpPoolStart, sizeof(inDhcpPoolStart));
	mib_get_s(MIB_DHCP_POOL_END, (void *)&inDhcpPoolEnd, sizeof(inDhcpPoolEnd));
	
	//printf("%s %d  inIp.s_addr=%0x inMask.s_addr=%0x\n", __FUNCTION__, __LINE__, inIp.s_addr, inMask.s_addr);
	entryNum = mib_chain_total(MIB_DHCPS_SERVING_POOL_TBL);
	for(i = 0; i < entryNum; i++)
	{
		if(!mib_chain_get(MIB_DHCPS_SERVING_POOL_TBL, i, (void *)&dhcppoolentry))
			continue;
		memcpy(&poolstartAddr, dhcppoolentry.startaddr, IP_ADDR_LEN);
		memcpy(&poolendAddr, dhcppoolentry.endaddr, IP_ADDR_LEN);
		newpoolstartAddr = (poolstartAddr&~inMask.s_addr) |(inIp.s_addr&inMask.s_addr);
		newpoolendAddr = (poolendAddr&~inMask.s_addr) |(inIp.s_addr&inMask.s_addr);
		if(newpoolstartAddr < inDhcpPoolStart.s_addr || newpoolstartAddr > inDhcpPoolEnd.s_addr)
			newpoolstartAddr = inDhcpPoolStart.s_addr;
		if(newpoolendAddr > inDhcpPoolEnd.s_addr || newpoolendAddr < inDhcpPoolStart.s_addr)
			newpoolendAddr = inDhcpPoolEnd.s_addr;
		memcpy(dhcppoolentry.startaddr, &newpoolstartAddr, IP_ADDR_LEN);
		memcpy(dhcppoolentry.endaddr, &newpoolendAddr, IP_ADDR_LEN);
		//printf("%s %d  newpoolstartAddr=%0x newpoolendAddr=%0x\n", __FUNCTION__, __LINE__, newpoolstartAddr, newpoolendAddr);
		mib_chain_update(MIB_DHCPS_SERVING_POOL_TBL, (void *)&dhcppoolentry, i);
	}
}
#endif

#ifdef DHCPS_DNS_OPTIONS
int setDhcpDNSType(unsigned char lanDnsType, unsigned int lanDns1,unsigned int lanDns2)
{
	unsigned char OrigDNSType, ucDhcpdChanged = 0;
	unsigned int OriglanDns1;
	unsigned int OriglanDns2;

	mib_get(MIB_DHCP_DNS_OPTION, (void *)&OrigDNSType);
	if (OrigDNSType != lanDnsType)
	{
		ucDhcpdChanged = 1;
		mib_set(MIB_DHCP_DNS_OPTION, (void *)&lanDnsType);
	}

	if(lanDnsType){
		mib_get(MIB_DHCPS_DNS1, (void *)&OriglanDns1);
		if (OriglanDns1 != lanDns1)
		{
			ucDhcpdChanged = 1;
			mib_set(MIB_DHCPS_DNS1, (void *)&lanDns1);
		}

		mib_get(MIB_DHCPS_DNS2, (void *)&OriglanDns2);
		if (OriglanDns2 != lanDns2)
		{
			ucDhcpdChanged = 1;
			mib_set(MIB_DHCPS_DNS2, (void *)&lanDns2);
		}

	}

	if (ucDhcpdChanged)
	{
		mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);
	}

	return ucDhcpdChanged;
}
#endif


int setDhcpMode(unsigned char ucMode, void *pvPara)
{
	unsigned char ucOrigMode, ucDhcpdChanged = 0, ucWLanState = 0;
	struct in_addr inOrigDhcpPoolStart, inOrigDhcpPoolEnd, inOrigRelayServer;
	unsigned int uiOrigLease;
	dhcpd_entry *pstDhcpdEntry;

	mib_get_s(MIB_DHCP_MODE, (void *)&ucOrigMode, sizeof(ucOrigMode));
	if (ucOrigMode != ucMode)
	{
		ucDhcpdChanged = 1;
		mib_set(MIB_DHCP_MODE, (void *)&ucMode);
		syslog(LOG_INFO, "DHCP: Change DHCP Mode %d\n", ucMode);
	}

DBPRINT(2, "ucMode=%d, ucOrigMode=%d\n", ucMode, ucOrigMode);

	switch (ucMode)
	{
		case DHCPV4_LAN_SERVER:
#ifdef CONFIG_AUTO_DHCP_CHECK
		case AUTO_DHCPV4_BRIDGE:
#endif
//			if (DHCPV4_LAN_SERVER == ucOrigMode)
//			{
				pstDhcpdEntry = (dhcpd_entry *)pvPara;

				mib_get_s(MIB_DHCP_POOL_START, (void *)&inOrigDhcpPoolStart, sizeof(inOrigDhcpPoolStart));

				if (inOrigDhcpPoolStart.s_addr != pstDhcpdEntry->dhcpRangeStart)
				{
					ucDhcpdChanged = 1;
					mib_set(MIB_DHCP_POOL_START, (void *)&pstDhcpdEntry->dhcpRangeStart);
					syslog(LOG_INFO, "DHCP: Change DHCP Pool Start %s", inet_ntoa(*(struct in_addr *) &pstDhcpdEntry->dhcpRangeStart));
				}

				mib_get_s(MIB_DHCP_POOL_END, (void *)&inOrigDhcpPoolEnd, sizeof(inOrigDhcpPoolEnd));
				if (inOrigDhcpPoolEnd.s_addr != pstDhcpdEntry->dhcpRangeEnd)
				{
					ucDhcpdChanged = 1;
					mib_set(MIB_DHCP_POOL_END, (void *)&pstDhcpdEntry->dhcpRangeEnd);
					syslog(LOG_INFO, "DHCP: Change DHCP Pool End %s", inet_ntoa(*(struct in_addr *) &pstDhcpdEntry->dhcpRangeEnd));
				}

				mib_get_s(MIB_ADSL_LAN_DHCP_LEASE, (void *)&uiOrigLease, sizeof(uiOrigLease));
				if (uiOrigLease != pstDhcpdEntry->ulTime)
				{
					ucDhcpdChanged = 1;
					mib_set(MIB_ADSL_LAN_DHCP_LEASE, (void *)&pstDhcpdEntry->ulTime);
					syslog(LOG_INFO, "DHCP: Change DHCP Lease Time %u", pstDhcpdEntry->ulTime);
				}
//			}

#if defined(IP_BASED_CLIENT_TYPE) && defined(CONFIG_CU_BASEON_CMCC)
				autoSetDhcpServingPool();
#endif		
			break;

		case DHCPV4_LAN_NONE:
			break;

#ifdef CONFIG_USER_DHCPCLIENT_MODE
		case DHCPV4_LAN_CLIENT:
			break;
#endif

		default: /* DHCPV4_LAN_RELAY */
			mib_get_s(MIB_ADSL_WAN_DHCPS, (void*)&inOrigRelayServer, sizeof(inOrigRelayServer));
			if (inOrigRelayServer.s_addr != *(unsigned long *)pvPara)
			{
				ucDhcpdChanged = 1;
				mib_set(MIB_ADSL_WAN_DHCPS, pvPara);
			}

			break;
	}

	if (ucDhcpdChanged)
	{
		mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);
		restart_dhcp();
	}

	return ucDhcpdChanged;
}


//show_lan_dns
int showLanDns1(int eid, request * wp, int argc, char ** argv)
{
#ifdef CONFIG_USER_DNS_RELAY_PROXY
	return 0;
#else
	return boaWrite(wp, "<!--\n");
#endif
}

int showLanDns2(int eid, request * wp, int argc, char ** argv)
{
#ifdef CONFIG_USER_DNS_RELAY_PROXY
	return 0;
#else
	return boaWrite(wp, "-->\n");
#endif
}



int isdigt(char *str)
{
	if (strspn(str, "0123456789") == strlen(str))
		return 1;
	else
		return 0;
}
//add by chenzhuoxin
void formDhcpd(request *wp, char *path, char *query)
{
	struct dhcpd_entry entry;
	unsigned int	uIp = 0;            //	modem ip
	unsigned int	uMask = 0;          //	modem netmask
	unsigned char	uDhcpType = 0;		//	0- 禁用dhcpserver;  1- 启用dhcpserver ; 2-enable dhcprelay
	unsigned int	uServerIp = 0;		//	dhcp relay server ip
	char*			stemp = "";
	int				lineno = __LINE__;
	char            tmpBuf[128];
#ifdef CONFIG_RTK_DNS_TRAP
	char dnstrap[64]={0};
	char origstr[30]={0};
	char *origstrDomain=origstr;
#endif	
	void            *pvDhcpdPara = NULL;
	unsigned char   ucDhcpdMode = DHCPV4_LAN_NONE;
	int time_temp;
#if defined(IP_BASED_CLIENT_TYPE) && (defined(CONFIG_CU_BASEON_CMCC)||defined(CONFIG_CU_BASEON_YUEME))
	int i, entryNum;
	DHCPS_SERVING_POOL_T dhcppoolentry;
	unsigned int poolstartAddr, poolendAddr;
	struct in_addr inOrigMask;
	unsigned int startHostNo,endHostNo = 0;
	unsigned int servingpoolstartAddr = 0xFFFFFFFF, servingpoolendAddr = 0;
#endif
#ifdef CONFIG_USER_DHCPCLIENT_MODE
	unsigned char value[64]={0};
	int dhcpc_pid;
#endif
#ifdef CONFIG_AUTO_DHCP_CHECK
		const char AUTO_DHCPPID[] = "/var/run/auto_dhcp.pid";
		int auto_dhcp_pid=0;
		char opmode=0;
#endif
	struct in_addr tmpaddr;
	char *str_uDhcpType;
	tmpBuf[0] = 0;

	_TRACE_CALL;

	//modem ip
	_GET_IP_STR(uIp,tmpaddr,_NEED);
	if(uIp == 0)
	{
		goto_dhcp_check_err(strWrongIP);
	}

	//netmask
	_GET_IP_STR(uMask,tmpaddr, _NEED);
	if(uMask == 0)
	{
		goto_dhcp_check_err(strWrongMask);
	}

	str_uDhcpType = boaGetVar(wp, "uDhcpType", "");
	if(!isdigt(str_uDhcpType))
		goto_dhcp_check_err(strSetDhcpModeerror);
	//service type
	_GET_INT(uDhcpType, _NEED);
#ifdef CONFIG_RTK_DNS_TRAP
	_GET_STR(dnstrap, _NEED);
	dnstrap[sizeof(dnstrap)-1] = '\0';
	printf("dnstrap=%s\n", dnstrap );
	
	mib_get_s(MIB_ADSL_LAN_DHCP_DOMAIN, (void *)origstrDomain, sizeof(origstr));
		if(strContainXSSChar(dnstrap))
			goto_dhcp_check_err(strsetdnstrapError);
		if ( !mib_set(MIB_ADSL_LAN_DHCP_DOMAIN, (void *)dnstrap)) {
			goto_dhcp_check_err(strsetdnstrapError);
		}

		if(strcmp(origstrDomain, dnstrap)!=0)
		{
			mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);			
			char cmdbuf[128] = {0}, strDomain_str[64]={0};
			strncpy(strDomain_str,dnstrap,sizeof(strDomain_str)-1);
			strtolower(strDomain_str,strlen(strDomain_str));
			if(strchr(strDomain_str, '.')==NULL)
				snprintf(strDomain_str+strlen(strDomain_str),  sizeof(strDomain_str)-strlen(strDomain_str)-1, "%s", ".com");
			create_hosts_file(strDomain_str);
			snprintf(cmdbuf, sizeof(cmdbuf), "echo \"%s\" > /proc/driver/realtek/domain_name",strDomain_str);
			system(cmdbuf);
#ifndef CONFIG_RTK_SKB_MARK2
			snprintf(cmdbuf,sizeof(cmdbuf),"echo %d > /proc/fc/ctrl/skbmark_fwdByPs",SOCK_MARK_METER_INDEX_END);
			system(cmdbuf);
#endif

		}
#endif

#ifdef CONFIG_AUTO_DHCP_CHECK
	if(uDhcpType > 4)
#else
#ifdef CONFIG_USER_DHCPCLIENT_MODE
	if(uDhcpType > DHCPV4_LAN_CLIENT)		
#else
	if(uDhcpType > 2)
#endif		
#endif
	{
		/* impossible */
		goto_dhcp_check_err(strSetDhcpModeerror);
	}
#ifdef CONFIG_AUTO_DHCP_CHECK
	if((uDhcpType == 1)||(uDhcpType == 4))  //1- 启用dhcpserver  4-启用auto_dhcp
#else
	if(uDhcpType == 1)	//1- 启用dhcpserver
#endif
	{
		_ENTRY_IP_STR(dhcpRangeStart,tmpaddr, _NEED);
		if(entry.dhcpRangeStart == 0)
		{
			goto_dhcp_check_err(strInvalidRange);
		}

		_ENTRY_IP_STR(dhcpRangeEnd,tmpaddr, _NEED);
		if(entry.dhcpRangeEnd == 0)
		{
			goto_dhcp_check_err(strInvalidRange);
		}

		if (entry.dhcpRangeEnd < entry.dhcpRangeStart)
		{
			goto_dhcp_check_err(strInvalidRange);
		}
#if defined(IP_BASED_CLIENT_TYPE) && (defined(CONFIG_CU_BASEON_CMCC)||defined(CONFIG_CU_BASEON_YUEME))
		mib_get_s(MIB_ADSL_LAN_SUBNET, (void *)&inOrigMask, sizeof(inOrigMask));
		entryNum = mib_chain_total(MIB_DHCPS_SERVING_POOL_TBL);
		for(i = 0; i < entryNum; i++)
		{
			if(!mib_chain_get(MIB_DHCPS_SERVING_POOL_TBL, i, (void *)&dhcppoolentry))
				continue;
			memcpy(&poolstartAddr, dhcppoolentry.startaddr, IP_ADDR_LEN);
			memcpy(&poolendAddr, dhcppoolentry.endaddr, IP_ADDR_LEN);
			if(servingpoolstartAddr > poolstartAddr)
				servingpoolstartAddr = poolstartAddr;
			if(servingpoolendAddr < poolendAddr)
				servingpoolendAddr = poolendAddr;
		}

		startHostNo = (~inOrigMask.s_addr)&servingpoolstartAddr;
		endHostNo = (~inOrigMask.s_addr)&servingpoolendAddr;
		//printf("%s %d startHostNo=%d endHostNo=%d\n", __FUNCTION__, __LINE__, startHostNo, endHostNo);
		if(~uMask < endHostNo)
			goto_dhcp_check_err(strInvalidTypeRange);
		if((~uMask&entry.dhcpRangeStart) > startHostNo || (~uMask&entry.dhcpRangeEnd) < endHostNo)
			goto_dhcp_check_err(strInvalidRange);
#endif
#if 0
		_ENTRY_IP(ipMask, _NEED);
		if(entry.ipMask == 0)
  	{
			goto_dhcp_check_err(strWrongMask);
		}
#endif

		_ENTRY_INT(ulTime, _NEED);
		if(entry.ulTime == 0)
		{
			goto_dhcp_check_err(strSetLeaseTimeerror);
		}
#ifdef CONFIG_AUTO_DHCP_CHECK
		if(uDhcpType == 4)
		{
			ucDhcpdMode = AUTO_DHCPV4_BRIDGE;
		}
		else
		{
			ucDhcpdMode = DHCPV4_LAN_SERVER;
		}
#else
		ucDhcpdMode = DHCPV4_LAN_SERVER;
#endif
		pvDhcpdPara = (void *)&entry;
	}
	else if(uDhcpType == 2)	//1- enable dhcprelay
	{
		//	dhcp relay server ip
		_GET_IP_STR(uServerIp,tmpaddr, _NEED);
		if(uServerIp == 0 || (check_ip_is_in_lan_subnet(&tmpaddr)==1) )
		{
			goto_dhcp_check_err(strInvalidGatewayerror);
		}

		ucDhcpdMode = DHCPV4_LAN_RELAY;
		pvDhcpdPara = (void *)&uServerIp;
	}
#ifdef CONFIG_USER_DHCPCLIENT_MODE
	else if(uDhcpType == 3)
	{
		ucDhcpdMode = DHCPV4_LAN_CLIENT;
	}
#endif		
	/*
	*Add code by Realtek
	*/
	if(setLanIp(uIp, uMask) == 1)
	{
		//log out users to prevent user cannot login in 5 minutes.
		free_from_login_list(wp);
	}


#ifdef CONFIG_AUTO_DHCP_CHECK

//	kill_by_pidfile((const char*)AUTO_DHCPPID, SIGTERM);
	kill_by_pidfile_new((const char*)AUTO_DHCPPID, SIGTERM);

#endif


	
	setDhcpMode(ucDhcpdMode, pvDhcpdPara);

#ifdef CONFIG_USER_DHCPCLIENT_MODE


	snprintf(value, 64, "%s.%s", (char*)DHCPC_PID, ALIASNAME_BR0);
#ifdef CONFIG_RTK_DEV_AP
	kill_by_pidfile_new((const char*)value, SIGTERM);
#else
	dhcpc_pid = read_pid((char*)value);
	if (dhcpc_pid > 0)
		kill(dhcpc_pid, SIGTERM);
#endif
	
	if( ucDhcpdMode == DHCPV4_LAN_CLIENT ){
		setupDHCPClient();
	}else{
		/* recover LAN IP address */
		restart_lanip();
	}
#endif

#ifdef CONFIG_AUTO_DHCP_CHECK
	mib_get_s(MIB_OP_MODE, (void *)&opmode, sizeof(opmode));
	if(opmode==BRIDGE_MODE && ucDhcpdMode == AUTO_DHCPV4_BRIDGE)
	{	
		va_cmd("/bin/Auto_DHCP_Check", 8, 0, "-a", "15", "-n", "5", "-d", "30", "-m", "10");
		start_process_check_pidfile((const char*)AUTO_DHCPPID);
	}
#endif

#if defined(CONFIG_USER_LANNETINFO) && (defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC))
	restartlanNetInfo();
#endif
	_COND_REDIRECT;
	_TRACE_LEAVEL;
	return;

check_err:
	_TRACE_LEAVEL;
	ERR_MSG(tmpBuf);
	return;
}

#ifdef CONFIG_USER_DNS_RELAY_PROXY

void formlanipv4dns(request * wp, char *path, char *query)
{
	char *str_extif,*submitUrl,*str_dns1,*str_dns2;
	static char tmpBuf[100];
	static char cmdBuf[100];
	char *lanIPv4DnsModeStr=NULL;
	unsigned char ipv4DnsMode=0;
	unsigned int ext_if;
	struct in_addr dnsv41, dnsv42;

	lanIPv4DnsModeStr = boaGetVar(wp, "ipv4landnsmode", "");
	str_extif = boaGetVar(wp, "ext_if", "");

	if(!lanIPv4DnsModeStr) {
		snprintf(tmpBuf,sizeof(tmpBuf), "%s", "Error!! get web LAN IPv4 DNS Mode fail!");
		goto setErr_ipv4;
	}

	ipv4DnsMode = lanIPv4DnsModeStr[0]-'0';

	//printf("%s  ipv4DnsMode = %d\n", __FUNCTION__, ipv4DnsMode);

	if ( !mib_set(MIB_LAN_DNSV4_MODE, (void *)&ipv4DnsMode)) {
		snprintf(tmpBuf,sizeof(tmpBuf), "%s", "Error!! set LAN IPv4 DNS Mode fail!");
		goto setErr_ipv4;
	}

	switch(ipv4DnsMode){
		case IPV4_DNS_PROXY:
			break;
		case IPV4_DNS_WANCONN_SPECIFIED:
			if(str_extif[0])
				ext_if = (unsigned int)atoi(str_extif);
			else
			{
				ext_if = DUMMY_IFINDEX;  // No interface selected.
				printf("%s - %d DUMMY_IFINDEX\n", __FUNCTION__, __LINE__);
				snprintf(tmpBuf,sizeof(tmpBuf), "%s", "Error!! set LAN IPv4 DNS WANCONN mode wan ifindex is NULL!");
				goto setErr_ipv4;
			}
			//printf("DNS WANConnect at 0x%x\n",ext_if);
			if ( !mib_set(MIB_DNSINFOV4_WANCONN, (void *)&ext_if)) {
				printf(tmpBuf,sizeof(tmpBuf), "%s", "Error!! set LAN IPv4 DNS WAN Conn fail!");
				goto setErr_ipv4;
			}
			break;
		case IPV4_DNS_STATIC:
			dnsv41.s_addr=0;
			dnsv42.s_addr=0;
			str_dns1 = boaGetVar(wp, "Ipv4Dns1", "");
			if(str_dns1[0]) {
				if ( !inet_pton(PF_INET, str_dns1, &dnsv41) ) {
					printf(tmpBuf,sizeof(tmpBuf), "%s", Tinvalid_DNS_address);
					goto setErr_ipv4;
				}
				if ( !mib_set(MIB_ADSL_LANV4_DNS1, (void *)&dnsv41)) {
	  				printf(tmpBuf,sizeof(tmpBuf), "%s", TDNS_mib_set_error);
					goto setErr_ipv4;
				}
			}

			str_dns2 = boaGetVar(wp, "Ipv4Dns2", "");
			if(str_dns2[0]) {
				if ( !inet_pton(PF_INET, str_dns2, &dnsv42) ) {
					printf(tmpBuf,sizeof(tmpBuf), "%s", Tinvalid_DNS_address);
					goto setErr_ipv4;
				}
				if ( !mib_set(MIB_ADSL_LANV4_DNS2, (void *)&dnsv42)) {
	  				printf(tmpBuf,sizeof(tmpBuf), "%s", TDNS_mib_set_error);
					goto setErr_ipv4;
				}
			}

			break;
		default:
			break;
	}

setOk_ipv4:

#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif

	restart_dhcp();

	submitUrl = boaGetVar(wp, "submit-url", "/");
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
	return;

setErr_ipv4:
	ERR_MSG(tmpBuf);
}


#endif



//add by chenzhuoxin
int init_dhcpmain_page(int eid, request * wp, int argc, char **argv)
{
	struct dhcpd_entry	entry;
	unsigned int	uIp;           //modem ip
	unsigned int	uMask;         // modem netmask
	unsigned char	uDhcpType = 1;				//0- 禁用;  1- 启用dhcpserver ; 2-enable dhcprelay
	unsigned int	uServerIp;     //dhcp rerty server ip
	int				lineno = __LINE__;
#ifdef DHCPS_DNS_OPTIONS
	unsigned int	lan_dns1;
	unsigned int	lan_dns2;
	unsigned char	lanDnsType = 1;
#endif
#ifdef CONFIG_USER_DHCPCLIENT_MODE
	unsigned char dhcp_client_support = 1;
#else
	unsigned char dhcp_client_support = 0;
#endif

	_TRACE_CALL;

	/*
	*Add code by Realtek
	*/
	mib_get_s(MIB_ADSL_LAN_IP, (void *)&uIp, sizeof(uIp));
	mib_get_s(MIB_ADSL_LAN_SUBNET, (void *)&uMask, sizeof(uMask));

	mib_get_s(MIB_DHCP_MODE, (void *)&uDhcpType, sizeof(uDhcpType));
	switch (uDhcpType)
	{
		case DHCPV4_LAN_SERVER:
			uDhcpType = 1;
			break;
#ifdef CONFIG_USER_DHCPCLIENT_MODE
		case DHCPV4_LAN_CLIENT:
			uDhcpType = 2;
			break;
#endif
		case DHCPV4_LAN_RELAY:
			
			uDhcpType = 3;
			break;
#ifdef CONFIG_AUTO_DHCP_CHECK
		case AUTO_DHCPV4_BRIDGE:
			uDhcpType = 4;
			break;
#endif
		default:
			uDhcpType = 0;
			break;
	}

	memset(&entry, 0, sizeof(dhcpd_entry));
	mib_get_s(MIB_DHCP_POOL_START, (void *)&entry.dhcpRangeStart, sizeof(entry.dhcpRangeStart));
	mib_get_s(MIB_DHCP_POOL_END, (void *)&entry.dhcpRangeEnd, sizeof(entry.dhcpRangeEnd));
	mib_get_s(MIB_ADSL_LAN_DHCP_LEASE, (void *)&entry.ulTime, sizeof(entry.ulTime));
	entry.ipMask = uMask;

	mib_get_s(MIB_ADSL_WAN_DHCPS, (void*)&uServerIp, sizeof(uServerIp));

	_PUT_IP(uIp);
	_PUT_IP(uMask);

	_PUT_INT(uDhcpType);

	_PUT_ENTRY_IP(dhcpRangeStart);
	_PUT_ENTRY_IP(dhcpRangeEnd);
	_PUT_ENTRY_IP(ipMask);
	_PUT_ENTRY_INT(ulTime);

	_PUT_IP(uServerIp);

#ifdef DHCPS_DNS_OPTIONS
	mib_get(MIB_DHCPS_DNS1, (void *)&lan_dns1);
	mib_get(MIB_DHCPS_DNS2, (void *)&lan_dns2);
	mib_get(MIB_DHCP_DNS_OPTION, (void *)&lanDnsType);
	_PUT_IP(lan_dns1);
	_PUT_IP(lan_dns2);
	_PUT_INT(lanDnsType);
#endif

	_PUT_INT(dhcp_client_support);

check_err:
	_TRACE_LEAVEL;
	return 0;
}

//add by chenzhuoxin
void formMacAddrBase(request * wp, char *path, char *query)
{
	MIB_CE_MAC_BASE_DHCP_T entry, entry2;
	char tmpBuf[128]={0};
	char macAddr_Dhcp[20]={0}, ipAddr_Dhcp[20]={0}, tbl_mac[20]={0}, tbl_ip[20]={0},serverIP[INET_ADDRSTRLEN]={0};
	int mibtotal, i;
	char *stemp = "";
	int lineno = __LINE__;
	in_addr_t ipaddr;
	struct in_addr inAddr,inDhcpPoolStart, inDhcpPoolEnd;

	_TRACE_CALL;

	FETCH_INVALID_OPT(stemp, "action", _NEED);

	if (strcmp(stemp, "sv") == 0)	//add
	{
		FETCH_INVALID_OPT(stemp, "macAddr_Dhcp", _NEED);
		//strcpy(tbl_mac, stemp);
		tbl_mac[sizeof(tbl_mac)-1]='\0';
		strncpy(tbl_mac, stemp, sizeof(tbl_mac)-1);
		changeMacStrToLower(tbl_mac);
		convert_mac(stemp);		
		memcpy(entry.macAddr_Dhcp, stemp, MAC_ADDR_LEN);

		FETCH_INVALID_OPT(stemp, "ipAddr_Dhcp", _NEED);
		//strcpy(tbl_ip, stemp);
		tbl_ip[sizeof(tbl_ip)-1]='\0';
		strncpy(tbl_ip, stemp, sizeof(tbl_ip)-1);
		inet_aton(stemp, (struct in_addr *)&entry.ipAddr_Dhcp);

		/************Place your code here, do what you want to do! ************/
		mib_get_s(MIB_DHCP_POOL_START, (void *)&inDhcpPoolStart, sizeof(inDhcpPoolStart));
		mib_get_s(MIB_DHCP_POOL_END, (void *)&inDhcpPoolEnd, sizeof(inDhcpPoolEnd));
		/*check static IP is in dhcp pool */
		ipaddr = *((in_addr_t *)entry.ipAddr_Dhcp);
		//printf("ipaddr=%u, inDhcpPoolStart.s_addr=%u, inDhcpPoolEnd.s_addr=%u\n",ipaddr,inDhcpPoolStart.s_addr,inDhcpPoolEnd.s_addr);
		if( ipaddr < inDhcpPoolStart.s_addr || ipaddr > inDhcpPoolEnd.s_addr)
			goto_dhcp_check_err(strInvalidTypeRange);
		if (getInAddr((char *)LANIF, IP_ADDR, &inAddr) == 1) {
			strlcpy(serverIP, inet_ntoa(inAddr), sizeof(serverIP));
		} else {
			getMIB2Str(MIB_ADSL_LAN_IP, serverIP);
		}
		/*check static IP isn't same br0 IP */
		if(!strcmp(tbl_ip, serverIP)){
			goto_dhcp_check_err(strStaticipSamelanip);
		}
		mibtotal = mib_chain_total(MIB_MAC_BASE_DHCP_TBL);
#define MAX_MAC_BASE_DHCP_ENTRY 10
		if (mibtotal >= MAX_MAC_BASE_DHCP_ENTRY) {
			goto_dhcp_check_err(strTableFull);
		}

		for (i = 0; i < mibtotal; i++) {
			mib_chain_get(MIB_MAC_BASE_DHCP_TBL, i,
				      (void *)&entry2);

			snprintf(macAddr_Dhcp, 18,
				 "%02x-%02x-%02x-%02x-%02x-%02x",
				 entry2.macAddr_Dhcp[0], entry2.macAddr_Dhcp[1],
				 entry2.macAddr_Dhcp[2], entry2.macAddr_Dhcp[3],
				 entry2.macAddr_Dhcp[4],
				 entry2.macAddr_Dhcp[5]);

			strcpy(ipAddr_Dhcp,
			       inet_ntoa(*(struct in_addr *)
					 &(entry2.ipAddr_Dhcp)));

			if (!strcmp(tbl_mac, macAddr_Dhcp)
			    || !strcmp(tbl_ip, ipAddr_Dhcp)) {
				goto_dhcp_check_err(strStaticipexist);
			}
		}
		mib_chain_add(MIB_MAC_BASE_DHCP_TBL, (unsigned char *)&entry);
		/************Place your code here, do what you want to do! ************/
	} else if (strcmp(stemp, "rm") == 0)	//remove
	{
		FETCH_INVALID_OPT(stemp, "macAddr_Dhcp", _NEED);
		//strcpy(tbl_mac, stemp);
		tbl_mac[sizeof(tbl_mac)-1]='\0';
		strncpy(tbl_mac, stemp, sizeof(tbl_mac)-1);
		FETCH_INVALID_OPT(stemp, "ipAddr_Dhcp", _NEED);
		//strcpy(tbl_ip, stemp);
		tbl_ip[sizeof(tbl_ip)-1]='\0';
		strncpy(tbl_ip, stemp, sizeof(tbl_ip)-1);

		/************Place your code here, do what you want to do! ************/
		mibtotal = mib_chain_total(MIB_MAC_BASE_DHCP_TBL);
		for (i = 0; i < mibtotal; i++) {
			mib_chain_get(MIB_MAC_BASE_DHCP_TBL, i, (void *)&entry);

			snprintf(macAddr_Dhcp, 18,
				 "%02x-%02x-%02x-%02x-%02x-%02x",
				 entry.macAddr_Dhcp[0], entry.macAddr_Dhcp[1],
				 entry.macAddr_Dhcp[2], entry.macAddr_Dhcp[3],
				 entry.macAddr_Dhcp[4], entry.macAddr_Dhcp[5]);

			strcpy(ipAddr_Dhcp,
			       inet_ntoa(*(struct in_addr *)
					 &(entry.ipAddr_Dhcp)));

			if (!strcmp(tbl_mac, macAddr_Dhcp)
			    || !strcmp(tbl_ip, ipAddr_Dhcp)) {
				break;
			}
		}

		mib_chain_delete(MIB_MAC_BASE_DHCP_TBL, i);
		/************Place your code here, do what you want to do! ************/
	} else {
		goto_dhcp_check_err("");
	}

	mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);
	restart_dhcp();

	_COND_REDIRECT;
	_TRACE_LEAVEL;
	return;

check_err:
	_TRACE_LEAVEL;
	ERR_MSG(tmpBuf);
	return;
}

int showMACBaseTable(int eid, request *wp, int argc, char **argv)
{
	MIB_CE_MAC_BASE_DHCP_T	entry;
	int cnt = 0;
	int lineno = __LINE__;
	int i;
	char macAddr_Dhcp[20], ipAddr_Dhcp[20];

	_TRACE_CALL;

	/*test code*/
	/*
	cnt = 1;
	memset(&entry, 0, sizeof(entry));
	strcpy(entry.macAddr, "00-11-22-33-44-55");
	strcpy(entry.ipAddr, "192.168.1.2");
	*/
	/*test code*/

	/************Place your code here, do what you want to do! ************/
	cnt = mib_chain_total(MIB_MAC_BASE_DHCP_TBL);
	/************Place your code here, do what you want to do! ************/

	for(i = 0; i < cnt; i++)
	{
		/************Place your code here, do what you want to do! ************/
		mib_chain_get(MIB_MAC_BASE_DHCP_TBL, i, (void*)&entry);

		snprintf(macAddr_Dhcp, 18, "%02x-%02x-%02x-%02x-%02x-%02x",
			entry.macAddr_Dhcp[0], entry.macAddr_Dhcp[1],
			entry.macAddr_Dhcp[2], entry.macAddr_Dhcp[3],
			entry.macAddr_Dhcp[4], entry.macAddr_Dhcp[5]);

		boaWrite(wp, "dmacips.push(new it_nr(\"%d\"" _PTS _PTS "));\n", i, _PMEX(macAddr_Dhcp), _PMEIP(ipAddr_Dhcp));
		/************Place your code here, do what you want to do! ************/
		/*printf("mac=%s; ip=%s\n", macAddr_Dhcp, ipAddr_Dhcp);*/
	}

check_err:
	_TRACE_LEAVEL;
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
int dhcpClientList(int eid, request * wp, int argc, char **argv)
{
	struct dhcp_device_info	entry;
	char			uIpAddr[16];
	int				cnt = 0;
	int				lineno = __LINE__;

	_TRACE_CALL;

	/*test code*/
	cnt = 0;
	memset(&entry, 0, sizeof(entry));
	memset(uIpAddr, 0, sizeof(uIpAddr));
	/*test code*/

	/************Place your code here, do what you want to do! ************/
#ifdef EMBED
#ifdef _CWMP_MIB_
	/* lijian: 20080904 START: Bug id 0003809: incorrect pointer cast, off_t *(64 bits) to unsigned long *(32 bits) */
	unsigned long leaseFileSize;
	char ipAddr[40], macAddr[40], liveTime[80], *buf=NULL, *ptr = NULL;
	unsigned int ipVal=0;
	int i, entryNum, ret;
	DHCPS_SERVING_POOL_T dhcppoolentry;
	
	if(getDhcpClientLeasesDB(&buf, &leaseFileSize) <=0)
		goto err;

	entryNum = mib_chain_total(MIB_DHCPS_SERVING_POOL_TBL);

	while (1)
	{
		uint32_t active_time = 0;
		ret = getOneDhcpClient(&ptr, &leaseFileSize, ipAddr, macAddr, liveTime, &active_time);
		/* lijian: 20080904 END */

		if (ret < 0)
			break;

		if (ret == 0)
			continue;

		inet_aton(ipAddr, (struct in_addr *)&ipVal);

		for( i = 0; i < entryNum; i++)
		{
			if(!mib_chain_get(MIB_DHCPS_SERVING_POOL_TBL, i, (void *)&dhcppoolentry))
				continue;

			if(ipVal >= *(unsigned int *)dhcppoolentry.startaddr && ipVal <= *(unsigned int *)dhcppoolentry.endaddr)
			{
				strcpy(entry.devname, dhcppoolentry.poolname);
				break;
			}
		}

		strncpy(uIpAddr, ipAddr, sizeof(uIpAddr)-1);
		boaWrite(wp, "clts.push(new it_nr(\"%d\"" _PTS _PTS "));\n", cnt, _PME(devname), _PMEX(uIpAddr));
		cnt++;
	}

err:
	if (cnt == 0)
		boaWrite(wp, "clts.push(new it_nr(\"%d\"" _PTS _PTS "));\n", cnt, _PME(devname), _PMEX(uIpAddr));

	if (buf)
		free(buf);

	return 0;
#endif //_CWMP_MIB_
#else
	return 0;
#endif

#if 0
	/************Place your code here, do what you want to do! ************/

	for(index = 0; index < cnt; index++)
	{
		/************Place your code here, do what you want to do! ************/
		/************Place your code here, do what you want to do! ************/

		boaWrite(wp, "clts.push(new it_nr(\"%d\"" _PTS _PTS "));\n", index, _PME(devname), _PMEIP(uIpAddr));
	}

check_err:
	_TRACE_LEAVEL;
	return 0;
#endif
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
void formReflashClientTbl(request * wp, char *path, char *query)
{
	char *submitUrl;

	submitUrl = boaGetVar(wp, "submit-url", "");
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
}

//////////////////////////////////////////////////////////////////////////////
#ifdef CONFIG_CU
//#ifdef IP_BASED_CLIENT_TYPE
#if 1
int setClientIpRange(dhcp_client_entry *pstClientIpRange)
{
	int i, entryNum, changed = 0;
	DHCPS_SERVING_POOL_T dhcppoolentry;

	entryNum = mib_chain_total(MIB_DHCPS_SERVING_POOL_TBL);
	
#if CONFIG_CU_BASEON_YUEME //check pool exist or not, if not exist, add it
	int pool_flag = CheckPoolExist();
	if(!(pool_flag&PC_POOL_EXIST) && (pstClientIpRange->pcRangeStart && pstClientIpRange->pcRangeEnd))
	{
		//add new pc pool chain
		DHCPS_SERVING_POOL_T new_dhcppoolentry;
		initSPDHCPOptEntry(&new_dhcppoolentry);
		strcpy(new_dhcppoolentry.poolname,"Computer");
		strcpy(new_dhcppoolentry.vendorclass,"Computer");
		memcpy(new_dhcppoolentry.startaddr, &pstClientIpRange->pcRangeStart, IP_ADDR_LEN);
		memcpy(new_dhcppoolentry.endaddr, &pstClientIpRange->pcRangeEnd, IP_ADDR_LEN);
		mib_chain_add(MIB_DHCPS_SERVING_POOL_TBL, (void *)&new_dhcppoolentry);
		changed++;
	}
	if(!(pool_flag&CAMERA_POOL_EXIST) && (pstClientIpRange->cmrRangeStart && pstClientIpRange->cmrRangeEnd))
	{
		//add new camera pool chain
		DHCPS_SERVING_POOL_T new_dhcppoolentry;
		initSPDHCPOptEntry(&new_dhcppoolentry);
		strcpy(new_dhcppoolentry.poolname,"Camera");
		strcpy(new_dhcppoolentry.vendorclass,"Camera");
		memcpy(new_dhcppoolentry.startaddr, &pstClientIpRange->cmrRangeStart, IP_ADDR_LEN);
		memcpy(new_dhcppoolentry.endaddr, &pstClientIpRange->cmrRangeEnd, IP_ADDR_LEN);
		mib_chain_add(MIB_DHCPS_SERVING_POOL_TBL, (void *)&new_dhcppoolentry);
		changed++;
	}
	if(!(pool_flag&STB_POOL_EXIST) && (pstClientIpRange->stbRangeStart && pstClientIpRange->stbRangeEnd))
	{
		//add new stb pool chain
		DHCPS_SERVING_POOL_T new_dhcppoolentry;
		initSPDHCPOptEntry(&new_dhcppoolentry);
		strcpy(new_dhcppoolentry.poolname,"STB");
		strcpy(new_dhcppoolentry.vendorclass,"STB");
		memcpy(new_dhcppoolentry.startaddr, &pstClientIpRange->stbRangeStart, IP_ADDR_LEN);
		memcpy(new_dhcppoolentry.endaddr, &pstClientIpRange->stbRangeStart, IP_ADDR_LEN);
		mib_chain_add(MIB_DHCPS_SERVING_POOL_TBL, (void *)&new_dhcppoolentry);
		changed++;
	}
	if(!(pool_flag&PHONE_POOL_EXIST) && (pstClientIpRange->phoneRangeStart && pstClientIpRange->phoneRangeEnd))
	{
		//add new phone pool chain
		DHCPS_SERVING_POOL_T new_dhcppoolentry;
		initSPDHCPOptEntry(&new_dhcppoolentry);
#ifdef CONFIG_CU
		strcpy(new_dhcppoolentry.poolname,"MVT");
		strcpy(new_dhcppoolentry.vendorclass,"MVT");
#else
		strcpy(new_dhcppoolentry.poolname,"Phone");
		strcpy(new_dhcppoolentry.vendorclass,"Phone");
#endif
		memcpy(new_dhcppoolentry.startaddr, &pstClientIpRange->phoneRangeStart, IP_ADDR_LEN);
		memcpy(new_dhcppoolentry.endaddr, &pstClientIpRange->phoneRangeEnd, IP_ADDR_LEN);
		mib_chain_add(MIB_DHCPS_SERVING_POOL_TBL, (void *)&new_dhcppoolentry);
		changed++;
	}
#endif
	
	for( i = 0; i < entryNum; i++)
	{
		if(!mib_chain_get(MIB_DHCPS_SERVING_POOL_TBL, i, (void *)&dhcppoolentry))
			continue;

		if(dhcppoolentry.poolname)
		{
			int ori_val = changed;

			if(!strcmp(dhcppoolentry.poolname, "Computer"))
			{
				if(memcmp(dhcppoolentry.startaddr, &pstClientIpRange->pcRangeStart, IP_ADDR_LEN) != 0)
				{
					memcpy(dhcppoolentry.startaddr, &pstClientIpRange->pcRangeStart, IP_ADDR_LEN);
					changed++;
				}

				if(memcmp(dhcppoolentry.endaddr, &pstClientIpRange->pcRangeEnd, IP_ADDR_LEN) != 0)
				{
					memcpy(dhcppoolentry.endaddr, &pstClientIpRange->pcRangeEnd, IP_ADDR_LEN);
					changed++;
				}

				if(dhcppoolentry.leasetime != pstClientIpRange->pcTime)
				{
					dhcppoolentry.leasetime = pstClientIpRange->pcTime;
					changed++;
				}
			}
			else if(!strcmp(dhcppoolentry.poolname, "Camera"))
			{
				if(memcmp(dhcppoolentry.startaddr, &pstClientIpRange->cmrRangeStart, IP_ADDR_LEN) != 0)
				{
					memcpy(dhcppoolentry.startaddr, &pstClientIpRange->cmrRangeStart, IP_ADDR_LEN);
					changed++;
				}

				if(memcmp(dhcppoolentry.endaddr, &pstClientIpRange->cmrRangeEnd, IP_ADDR_LEN) != 0)
				{
					memcpy(dhcppoolentry.endaddr, &pstClientIpRange->cmrRangeEnd, IP_ADDR_LEN);
					changed++;
				}

				if(dhcppoolentry.leasetime != pstClientIpRange->cmrTime)
				{
					dhcppoolentry.leasetime = pstClientIpRange->cmrTime;
					changed++;
				}

			}
			else if(!strcmp(dhcppoolentry.poolname, "STB"))
			{
				if(memcmp(dhcppoolentry.startaddr, &pstClientIpRange->stbRangeStart, IP_ADDR_LEN) != 0)
				{
					memcpy(dhcppoolentry.startaddr, &pstClientIpRange->stbRangeStart, IP_ADDR_LEN);
					changed++;
				}

				if(memcmp(dhcppoolentry.endaddr, &pstClientIpRange->stbRangeEnd, IP_ADDR_LEN) != 0)
				{
					memcpy(dhcppoolentry.endaddr, &pstClientIpRange->stbRangeEnd, IP_ADDR_LEN);
					changed++;
				}

				if(dhcppoolentry.leasetime != pstClientIpRange->stbTime)
				{
					dhcppoolentry.leasetime = pstClientIpRange->stbTime;
					changed++;
				}

			}
#ifdef CONFIG_CU
			else if(!strcmp(dhcppoolentry.poolname, "MVT"))
#else
			else if(!strcmp(dhcppoolentry.poolname, "Phone"))
#endif
			{
				if(memcmp(dhcppoolentry.startaddr, &pstClientIpRange->phoneRangeStart, IP_ADDR_LEN) != 0)
				{
					memcpy(dhcppoolentry.startaddr, &pstClientIpRange->phoneRangeStart, IP_ADDR_LEN);
					changed++;
				}

				if(memcmp(dhcppoolentry.endaddr, &pstClientIpRange->phoneRangeEnd, IP_ADDR_LEN) != 0)
				{
					memcpy(dhcppoolentry.endaddr, &pstClientIpRange->phoneRangeEnd, IP_ADDR_LEN);
					changed++;
				}

				if(dhcppoolentry.leasetime != pstClientIpRange->phoneTime)
				{
					dhcppoolentry.leasetime = pstClientIpRange->phoneTime;
					changed++;
				}

			}

			if( changed > ori_val )
				mib_chain_update(MIB_DHCPS_SERVING_POOL_TBL, (void *)&dhcppoolentry, i);
		}
	}

	if(changed)
	{
		mib_update(CURRENT_SETTING, CONFIG_MIB_ALL);
		restart_dhcp();
		return 1;
	}
	else
		return 0;
}
#endif


//add by chenhzuoxin
void formIpRange(request * wp, char *path, char *query)
{
	printf("<%s:%d> enter formIpRange.\n", __FUNCTION__, __LINE__);
#ifdef IP_BASED_CLIENT_TYPE
	struct dhcp_client_entry	entry;
	unsigned char	uDhcpType = 0;		//	0- 禁用dhcpserver;  1- 启用dhcpserver ; 2-enable dhcprelay
	unsigned int	uServerIp = 0;		//	dhcp relay server ip
	char*			stemp = "";
	int				lineno = __LINE__;
	char            tmpBuf[128];
	unsigned int    uStart;
	unsigned int    uEnd;

	_TRACE_CALL;
#ifdef CONFIG_CU_BASEON_YUEME
	char *str=NULL;
	unsigned int clientIpPool[4][2] = {0};
	memset(&entry,0,sizeof(struct dhcp_client_entry));

//check alreay exist pool
	int pool_flag = CheckPoolExist();
	//printf("<%s:%d> pool_flag=%d.\n", __FUNCTION__, __LINE__,pool_flag);
	str = boaGetVar(wp, "pcRangeStart", "");
	if(str[0])
	{
		_ENTRY_IP(pcRangeStart, _NEED);
	}
	str = boaGetVar(wp, "pcRangeEnd", "");
	if(str[0])
	{
		_ENTRY_IP(pcRangeEnd, _NEED);
	}
	str = boaGetVar(wp, "pcTime", "");
	if(str[0])
	{
		_ENTRY_INT(pcTime, _NEED);
	}

	if(pool_flag & PC_POOL_EXIST)
	{
		if(entry.pcRangeStart == 0)
		{
			goto_dhcp_check_err(strInvalidRangepc);
		}
		if(entry.pcRangeEnd == 0 || entry.pcRangeEnd < entry.pcRangeStart)
		{
			goto_dhcp_check_err(strInvalidRangepc);
		}
		if(entry.pcTime == 0)
		{
			goto_dhcp_check_err(strSetLeaseTimeerror);
		}
		clientIpPool[0][0]= entry.pcRangeStart;
		clientIpPool[0][1]= entry.pcRangeEnd;
	}
	else
	{
		if(entry.pcRangeStart == 0 && entry.pcRangeEnd != 0)
		{
			goto_dhcp_check_err(strInvalidRangepc);
		}	
		if(entry.pcRangeStart != 0 && entry.pcRangeEnd == 0)
		{
			goto_dhcp_check_err(strInvalidRangepc);
		}
		if(entry.pcRangeStart != 0 && entry.pcRangeEnd != 0)
		{
			if( entry.pcRangeEnd < entry.pcRangeStart)
			{
				goto_dhcp_check_err(strInvalidRangepc);
			}
			if(entry.pcTime == 0)
			{
				goto_dhcp_check_err(strSetLeaseTimeerror);
			}
			clientIpPool[0][0]= entry.pcRangeStart;
			clientIpPool[0][1]= entry.pcRangeEnd;
		}
	}
	str = boaGetVar(wp, "cmrRangeStart", "");
	if(str[0])
	{
		_ENTRY_IP(cmrRangeStart, _NEED);
	}
	str = boaGetVar(wp, "cmrRangeEnd", "");
	if(str[0])
	{
		_ENTRY_IP(cmrRangeEnd, _NEED);
	}
	str = boaGetVar(wp, "cmrTime", "");
	if(str[0])
	{
		_ENTRY_INT(cmrTime, _NEED);
	}
	if(pool_flag & CAMERA_POOL_EXIST)
	{
		if(entry.cmrRangeStart == 0)
		{
			goto_dhcp_check_err(strInvalidRangecmr);
		}
		if(entry.cmrRangeEnd == 0 || entry.cmrRangeEnd < entry.cmrRangeStart)
		{
			goto_dhcp_check_err(strInvalidRangecmr);
		}
		if(entry.cmrTime == 0)
		{
			goto_dhcp_check_err(strInvalidRangecmr);
		}
		clientIpPool[1][0]= entry.cmrRangeStart;
		clientIpPool[1][1]= entry.cmrRangeEnd;
	}
	else
	{
		if(entry.cmrRangeStart == 0 && entry.cmrRangeEnd != 0)
		{
			goto_dhcp_check_err(strInvalidRangecmr);
		}	
		if(entry.cmrRangeStart != 0 && entry.cmrRangeEnd == 0)
		{
			goto_dhcp_check_err(strInvalidRangecmr);
		}
		if(entry.cmrRangeStart != 0 && entry.cmrRangeEnd != 0)
		{
			if(entry.cmrRangeEnd < entry.cmrRangeStart)
			{
				goto_dhcp_check_err(strInvalidRangecmr);
			}
			if(entry.cmrTime == 0)
			{
				goto_dhcp_check_err(strSetLeaseTimeerror);
			}
			clientIpPool[1][0]= entry.cmrRangeStart;
			clientIpPool[1][1]= entry.cmrRangeEnd;
		}
	}
	str = boaGetVar(wp, "stbRangeStart", "");
	if(str[0])
	{
		_ENTRY_IP(stbRangeStart, _NEED);
	}
	str = boaGetVar(wp, "stbRangeEnd", "");
	if(str[0])
	{
		_ENTRY_IP(stbRangeEnd, _NEED);
	}
	str = boaGetVar(wp, "stbTime", "");
	if(str[0])
	{
		_ENTRY_INT(stbTime, _NEED);
	}
	
	if(pool_flag & STB_POOL_EXIST)
	{
		if(entry.stbRangeStart == 0)
		{
			goto_dhcp_check_err(strInvalidRangestb);
		}
		if(entry.stbRangeEnd == 0 || entry.stbRangeEnd < entry.stbRangeStart)
		{
			goto_dhcp_check_err(strInvalidRangestb);
		}
		if(entry.stbTime == 0)
		{
			goto_dhcp_check_err(strSetLeaseTimeerror);
		}
		clientIpPool[2][0]= entry.stbRangeStart;
		clientIpPool[2][1]= entry.stbRangeEnd;
	}
	else
	{
		if(entry.stbRangeStart == 0 && entry.stbRangeEnd != 0)
		{
			goto_dhcp_check_err(strInvalidRangestb);
		}	
		if(entry.stbRangeStart != 0 && entry.stbRangeEnd == 0)
		{
			goto_dhcp_check_err(strInvalidRangestb);
		}
		if(entry.stbRangeStart != 0 && entry.stbRangeEnd != 0)
		{
			if(entry.stbRangeEnd < entry.stbRangeStart)
			{
				goto_dhcp_check_err(strInvalidRangestb);
			}
			if(entry.stbTime == 0)
			{
				goto_dhcp_check_err(strSetLeaseTimeerror);
			}
			clientIpPool[2][0]= entry.stbRangeStart;
			clientIpPool[2][1]= entry.stbRangeEnd;
		}
	}
	str = boaGetVar(wp, "phoneRangeStart", "");
	if(str[0])
	{
		_ENTRY_IP(phoneRangeStart, _NEED);
	}
	str = boaGetVar(wp, "phoneRangeEnd", "");
	if(str[0])
	{
		_ENTRY_IP(phoneRangeEnd, _NEED);
	}
	str = boaGetVar(wp, "phoneTime", "");
	if(str[0])
	{
		_ENTRY_INT(phoneTime, _NEED);
	}
	if(pool_flag & PHONE_POOL_EXIST)
	{
		if(entry.phoneRangeStart == 0)
		{
			goto_dhcp_check_err(strInvalidRangephn);
		}
		if(entry.phoneRangeEnd == 0 || entry.phoneRangeEnd < entry.phoneRangeStart)
		{
			goto_dhcp_check_err(strInvalidRangephn);
		}
		if(entry.phoneTime == 0)
		{
			goto_dhcp_check_err(strSetLeaseTimeerror);
		}
		clientIpPool[3][0]= entry.phoneRangeStart;
		clientIpPool[3][1]= entry.phoneRangeEnd;
	}
	else
	{
		if(entry.phoneRangeStart == 0 && entry.phoneRangeEnd != 0)
		{
			goto_dhcp_check_err(strInvalidRangephn);
		}	
		if(entry.phoneRangeStart != 0 && entry.phoneRangeEnd == 0)
		{
			goto_dhcp_check_err(strInvalidRangephn);
		}
		if(entry.phoneRangeStart != 0 && entry.phoneRangeEnd != 0)
		{
			 if(entry.phoneRangeEnd < entry.phoneRangeStart)
			 {
				goto_dhcp_check_err(strInvalidRangephn);
			 }
			 if(entry.phoneTime == 0)
			{
				goto_dhcp_check_err(strSetLeaseTimeerror);
			}
			clientIpPool[3][0]= entry.phoneRangeStart;
			clientIpPool[3][1]= entry.phoneRangeEnd;
		}
	}

	int i, j;

	mib_get_s(MIB_DHCP_POOL_START, (void *)&uStart, sizeof(uStart));
	mib_get_s(MIB_DHCP_POOL_END, (void *)&uEnd, sizeof(uEnd));

	for (i = 0; i < 4; i++)
	{
		for (j = 0; j < 2; j++)
		{
			if(clientIpPool[i][j]==0)
				continue;
			if ((clientIpPool[i][j] < uStart) || (clientIpPool[i][j] > uEnd))
			{
				goto_dhcp_check_err(strInvalidTypeRange);
			}
		}
	}
	for (i = 0; i < 3; i++)
	{
		for (j = i + 1; j < 4; j++)
		{
			if(clientIpPool[i][1]==0)
				continue;
			if ((clientIpPool[i][1] >= clientIpPool[j][0]) && (clientIpPool[j][1] >= clientIpPool[i][0]))
			{
				goto_dhcp_check_err(strOverlapRange);
			}
		}
	}
#else
	//pc
	_ENTRY_IP(pcRangeStart, _NEED);
	if(entry.pcRangeStart == 0)
	{
		goto_dhcp_check_err(strInvalidRangepc);
	}

	_ENTRY_IP(pcRangeEnd, _NEED);
	if(entry.pcRangeEnd == 0 || entry.pcRangeEnd < entry.pcRangeStart)
	{
		goto_dhcp_check_err(strInvalidRangepc);
	}

	_ENTRY_IP(cmrRangeStart, _NEED);
	if(entry.cmrRangeStart == 0)
	{
		goto_dhcp_check_err(strInvalidRangecmr);
	}

	_ENTRY_IP(cmrRangeEnd, _NEED);
	if(entry.cmrRangeEnd == 0 || entry.cmrRangeEnd < entry.cmrRangeStart)
	{
		goto_dhcp_check_err(strInvalidRangecmr);
	}

	_ENTRY_IP(stbRangeStart, _NEED);
	if(entry.stbRangeStart == 0)
	{
		goto_dhcp_check_err(strInvalidRangestb);
	}

	_ENTRY_IP(stbRangeEnd, _NEED);
	if(entry.stbRangeEnd == 0 || entry.stbRangeEnd < entry.stbRangeStart)
	{
		goto_dhcp_check_err(strInvalidRangestb);
	}

	_ENTRY_IP(phoneRangeStart, _NEED);
	if(entry.phoneRangeStart == 0)
	{
		goto_dhcp_check_err(strInvalidRangestb);
	}

	_ENTRY_IP(phoneRangeEnd, _NEED);
	if(entry.phoneRangeEnd == 0 || entry.phoneRangeEnd < entry.phoneRangeStart)
	{
		goto_dhcp_check_err(strInvalidRangestb);
	}

	_ENTRY_INT(pcTime, _NEED);
	if(entry.pcTime == 0)
		goto_dhcp_check_err(strSetLeaseTimeerror);
	_ENTRY_INT(cmrTime, _NEED);
	if(entry.cmrTime == 0)
		goto_dhcp_check_err(strSetLeaseTimeerror);
	_ENTRY_INT(stbTime, _NEED);
	if(entry.stbTime == 0)
		goto_dhcp_check_err(strSetLeaseTimeerror);
	_ENTRY_INT(phoneTime, _NEED);
	if(entry.phoneTime == 0)
		goto_dhcp_check_err(strSetLeaseTimeerror);

	/*
	*Add code by Realtek
	*/
	{
		unsigned int clientIpPool[4][2] = {
			{entry.pcRangeStart, entry.pcRangeEnd},
			{entry.cmrRangeStart, entry.cmrRangeEnd},
			{entry.stbRangeStart, entry.stbRangeEnd},
			{entry.phoneRangeStart, entry.phoneRangeEnd}
		};
		int i, j;

		mib_get_s(MIB_DHCP_POOL_START, (void *)&uStart, sizeof(uStart));
		mib_get_s(MIB_DHCP_POOL_END, (void *)&uEnd, sizeof(uEnd));

		for (i = 0; i < 4; i++)
		{
			for (j = 0; j < 2; j++)
			{
				if ((clientIpPool[i][j] < uStart) || (clientIpPool[i][j] > uEnd))
				{
					goto_dhcp_check_err(strInvalidTypeRange);
				}
			}
		}

		for (i = 0; i < 3; i++)
		{
			for (j = i + 1; j < 4; j++)
			{
				if ((clientIpPool[i][1] >= clientIpPool[j][0]) && (clientIpPool[j][1] >= clientIpPool[i][0]))
				{
					goto_dhcp_check_err(strOverlapRange);
				}
			}
		}
	}
#endif
	setClientIpRange(&entry);
	

	_COND_REDIRECT;
	_TRACE_LEAVEL;
	return;

check_err:
	_TRACE_LEAVEL;
	ERR_MSG(tmpBuf);
	return;
#endif
}
int init_dhcp_device_page(int eid, request * wp, int argc, char **argv)
{
#ifdef CONFIG_CU_BASEON_YUEME
	int pool_flag= 0;
	pool_flag = CheckPoolExist();

	/*
	 *Add code by Realtek
	 */
	//Debug
	printf("enter init_dhcp_device_page\n");

	if (pool_flag&PC_POOL_EXIST)
		boaWrite(wp, "var pc_pool_exist = 1;\n");
	else
		boaWrite(wp, "var pc_pool_exist = 0;\n");

	if (pool_flag&CAMERA_POOL_EXIST)
		boaWrite(wp, "var camera_pool_exist = 1;\n");
	else
		boaWrite(wp, "var camera_pool_exist = 0;\n");

	if (pool_flag&STB_POOL_EXIST)
		boaWrite(wp, "var stb_pool_exist = 1;\n");
	else
		boaWrite(wp, "var stb_pool_exist = 0;\n");
	
	if (pool_flag&PHONE_POOL_EXIST)
		boaWrite(wp, "var phone_pool_exist = 1;\n");
	else
		boaWrite(wp, "var phone_pool_exist = 0;\n");
	/*
	 *Add code by Realtek
	 */
	printf("leave %s\n", __FUNCTION__);
	return 0;
#endif
}

#endif

#ifdef CONFIG_CMCC_ENTERPRISE
void formdhcpv4_cmcc_ent(request * wp, char *path, char *query)
{
	struct dhcpd_entry entry;
	unsigned int	uIp = 0;			//	modem ip
	unsigned int	uMask = 0;			//	modem netmask
	unsigned char	uDhcpType = 0;		//	0- 禁用dhcpserver;	1- 启用dhcpserver ; 2-enable dhcprelay
	unsigned int	uServerIp = 0;		//	dhcp relay server ip
	char*			stemp = "";
	int 			lineno = __LINE__;
	char			tmpBuf[128];
	void			*pvDhcpdPara = NULL;
	unsigned char	ucDhcpdMode = DHCP_LAN_NONE;
	unsigned char   ucDhcpdChanged = 0;
#ifdef DHCPS_DNS_OPTIONS
	unsigned char	lanDnsType = 0;
	unsigned int	lanDns1 = 0;
	unsigned int	lanDns2 = 0;
#endif
	MIB_CE_MAC_BASE_DHCP_T bindentry;
	int cnt=0, i;
	cJSON* maciplist_json=NULL;
	cJSON* macipentry_json=NULL;
	cJSON* mac_json=NULL;
	cJSON* ip_json=NULL;
#ifdef CONFIG_USER_DHCPCLIENT_MODE
	unsigned char value[64];
	int dhcpc_pid;
#endif
#ifdef RTK_SMART_ROAMING
	FILE *fp = NULL;
	unsigned char vChar = 0;
#endif


	tmpBuf[0] = 0;

	_TRACE_CALL;

	//modem ip
	_GET_IP(uIp, _NEED);
	if(uIp == 0)
	{
		goto_dhcp_check_err(strWrongIP);
	}

	//netmask
	_GET_IP(uMask, _NEED);
	if(uMask == 0)
	{
		goto_dhcp_check_err(strWrongMask);
	}
#ifdef DHCPS_DNS_OPTIONS
	//service type
	_GET_INT(lanDnsType, _NEED);
	if(lanDnsType){
		_GET_IP(lanDns1, _NEED);
		if(lanDns1 == 0)
		{
			goto_dhcp_check_err(strWrongMask);
		}

		_GET_IP(lanDns2, _NEED);
	}
#endif
	//service type
	_GET_INT(uDhcpType, _NEED);
	if(uDhcpType==1)	//1- 启用dhcpserver
	{
		//printf("uDhcpType");
		_ENTRY_IP(dhcpRangeStart, _NEED);
		if(entry.dhcpRangeStart == 0)
		{
			goto_dhcp_check_err(strInvalidRange);
		}

		_ENTRY_IP(dhcpRangeEnd, _NEED);
		if(entry.dhcpRangeEnd == 0)
		{
			goto_dhcp_check_err(strInvalidRange);
		}

		if (entry.dhcpRangeEnd < entry.dhcpRangeStart)
		{
			goto_dhcp_check_err(strInvalidRange);
		}
#if 0
		_ENTRY_IP(ipMask, _NEED);
		if(entry.ipMask == 0)
	{
			goto_dhcp_check_err(strWrongMask);
		}
#endif

		_ENTRY_INT(ulTime, _NEED);
		if(entry.ulTime == 0)
		{
			goto_dhcp_check_err(strSetLeaseTimeerror);
		}

		ucDhcpdMode = DHCP_LAN_SERVER;
		pvDhcpdPara = (void *)&entry;
	}
#ifdef CONFIG_USER_DHCPCLIENT_MODE
	else if(uDhcpType == 3)
	{
		ucDhcpdMode = DHCP_LAN_CLIENT;
	}
#endif

	//add mac-ip bind
	FETCH_INVALID_OPT(stemp, "maciplist", _OPT);
	mib_chain_clear(MIB_MAC_BASE_DHCP_TBL);
	maciplist_json = cJSON_Parse(stemp);
	if(!maciplist_json)
		{lineno = __LINE__; goto check_err;}
	cnt = cJSON_GetArraySize(maciplist_json);
	//printf(" input json array size %d\n",cnt);
	for(i = 0;i<cnt;i++){
		memset(&bindentry, 0, sizeof(bindentry));
		macipentry_json = cJSON_GetArrayItem(maciplist_json,i);
		if(!macipentry_json) continue;
		//printf("\t%d entry:%s",i, cJSON_PrintUnformatted(macipentry_json));
		mac_json = cJSON_GetObjectItem(macipentry_json,"macAddr_Dhcp");
		if(mac_json)
			convertMacFormat(mac_json->valuestring, bindentry.macAddr_Dhcp);
		else
			continue;
		ip_json = cJSON_GetObjectItem(macipentry_json,"ipAddr_Dhcp");
		//printf("\t\t ip_json->valuestring:%s",ip_json->valuestring);
		if(ip_json){
			//bindentry.ipAddr_Dhcp = inet_addr(ip_json->valuestring);
			inet_aton(ip_json->valuestring, (struct in_addr *)&bindentry.ipAddr_Dhcp);
		}
		else
			continue;
		bindentry.Enabled = 1;
		mib_chain_add(MIB_MAC_BASE_DHCP_TBL,&bindentry);
	}
	/*
	*Add code by Realtek
	*/
	if(setLanIp(uIp, uMask) == 1)
	{
		//log out users to prevent user cannot login in 5 minutes.
		free_from_login_list(wp);
	}

#ifdef DHCPS_DNS_OPTIONS
	setDhcpDNSType(lanDnsType,lanDns1,lanDns2);
#endif
	ucDhcpdChanged = setDhcpMode(ucDhcpdMode, pvDhcpdPara);
#ifdef CONFIG_USER_DHCPCLIENT_MODE
	snprintf(value, 64, "%s.%s", (char*)DHCPC_PID, ALIASNAME_BR0);
	dhcpc_pid = read_pid((char*)value);
	if (dhcpc_pid > 0)
		kill(dhcpc_pid, SIGTERM);

	if( ucDhcpdMode == DHCP_LAN_CLIENT ){
#if	defined(CONFIG_RTK_RG_INIT)
		va_cmd(IFCONFIG, 6, 1, (char*)LANIF, "0.0.0.0", "netmask", "255.255.255.0", "mtu", "1500");
		RG_reset_LAN();
#endif
		setupDHCPClient();
	}else{
		/* recover LAN IP address */
		restart_lanip();
	}
#endif
#ifdef RTK_SMART_ROAMING
	if(!(fp = fopen(CAPWAP_APP_DHCP_CONFIG, "w"))){
		sprintf(tmpBuf, "open %s file fail\n",CAPWAP_APP_DHCP_CONFIG);
		goto check_err;
	}

	if(mib_get( MIB_DHCP_MODE, (void *)&vChar)){
		fprintf(fp, "%d", vChar);
	}

	fclose(fp);
#endif

	// For mac-base or DNS type
	if (ucDhcpdChanged==0)
		restart_dhcp();

#if defined(CONFIG_USER_LANNETINFO) && (defined(CONFIG_CMCC) || defined(CONFIG_CU))
	restartlanNetInfo();
#endif
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif
	_COND_REDIRECT;
	_TRACE_LEAVEL;
	return;

check_err:
	_TRACE_LEAVEL;
	ERR_MSG(tmpBuf);
	return;
	}
#endif

