/*-- System inlcude files --*/
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <sys/wait.h>

#include "../webs.h"
#include "webform.h"
#include "mib.h"
#include "utility.h"
#include "../ipv6_info.h"

#ifdef EMBED
#include <linux/config.h>
#include <config/autoconf.h>
#else
#include "../../../../include/linux/autoconf.h"
#include "../../../../config/autoconf.h"
#endif

#ifdef CONFIG_IPV6
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
void formlanipv6dhcp(request * wp, char *path, char *query)
{
	char *str, *submitUrl, *strVal, *pStr;
	static char tmpBuf[100];
	unsigned char origvChar,vChar;
	unsigned int origInt;
	unsigned char mode = 0, dnsmode=0, dhcpMode=0;
	int dhcpd6pid;
	unsigned int ext_if, i=0;
	unsigned char prefixLen=0;
	unsigned int DLTime, PFTime;
	struct in6_addr dnsv61, dnsv62, dnsv63;
	unsigned char value[64]={0}, cmdBuf[128]={0};
	unsigned char devAddr[MAC_ADDR_LEN]={0};
	unsigned char meui64[8]={0};
	unsigned char lanipv6prefix[64]={0};
	unsigned char ipv6AddrFormat=0;
	unsigned char ipv6dnsv61[100]={0}, ipv6dnsv62[100]={0};
	unsigned char min_address[64] = {0}, max_address[64] = {0};
	unsigned char ipv6_address[MAX_V6_IP_LEN] = {0};
	unsigned char static_prefix_str[INET6_ADDRSTRLEN] = {0};
	struct in6_addr ip6Addr_start, ip6Addr_end,ip6Addr, targetIP;
	char origDhcpv6Type=0;
	PREFIX_V6_INFO_T prefixInfo;
#ifdef CONFIG_USER_RTK_IPV6_MULTI_LAN_SERVICE_WITH_SINGLE_BR
	PREFIX_V6_INFO_T lan_prefixInfo = {0};
#endif

#ifndef NO_ACTION
	int pid;
#endif

	//Init
	memset(&ip6Addr_start, 0, sizeof(struct in6_addr));
	memset(&ip6Addr_end, 0, sizeof(struct in6_addr));
	memset(&ip6Addr, 0 ,sizeof(struct in6_addr));
	memset(&targetIP, 0 ,sizeof(struct in6_addr));

	//Clear old static IPv6 info in br0
	if ( !mib_get_s( MIB_DHCPV6_MODE, (void *)&origvChar, sizeof(origvChar)) ) {
		//strcpy(tmpBuf, strGetDhcpModeerror);
		snprintf(tmpBuf, sizeof(tmpBuf), "%s", strGetDhcpModeerror);
		goto setErr_dhcpv6;
	}
	if ( !mib_get_s( MIB_DHCPV6S_TYPE, (void *)&origDhcpv6Type, sizeof(origDhcpv6Type)) ) {
		snprintf(tmpBuf,sizeof(tmpBuf), "Get dhcpv6 type err!");
		goto setErr_dhcpv6;
	}

	if ((origvChar == DHCP_LAN_SERVER) && (origDhcpv6Type == DHCPV6S_TYPE_STATIC)){
		mib_get_s(MIB_DHCPV6S_RANGE_START, (void *)ip6Addr_start.s6_addr, sizeof(ip6Addr_start.s6_addr));
		mib_get_s(MIB_DHCPV6S_PREFIX_LENGTH, (void *)&prefixLen, sizeof(prefixLen));
		memcpy(prefixInfo.prefixIP, &ip6Addr_start, IP6_ADDR_LEN);
		prefixInfo.prefixLen = prefixLen;
		//del dhcpv6 static prefix address
		set_lan_ipv6_global_address(NULL,&prefixInfo,(char*)LANIF,0,0);
		//del dhcpv6 static prefix route for LAN route table(IP_ROUTE_LAN_TABLE)
		set_ipv6_lan_policy_route((char *)LANIF, (struct in6_addr *)&prefixInfo.prefixIP, prefixInfo.prefixLen, 0);
	}else if (origvChar == DHCP_LAN_RELAY){
		char upper_ifname[8];
		unsigned int upper_if;
		MIB_CE_ATM_VC_T Entry;
		if ( !mib_get_s(MIB_DHCPV6R_UPPER_IFINDEX, (void *)&upper_if, sizeof(upper_if))) {
			snprintf(tmpBuf, sizeof(tmpBuf),"Get MIB_DHCPV6R_UPPER_IFINDEX mib error!");
			goto setErr_dhcpv6;
		}		
	
		if ( upper_if != DUMMY_IFINDEX ){
			ifGetName(upper_if, upper_ifname, sizeof(upper_ifname));
		}
		else{
			printf("Error: The upper interface of dhcrelayV6 not set !");
		}
	
		if (!(getATMVCEntryByIfIndex(upper_if, &Entry))){
			printf("Error! Could not get MIB entry info from wanconn\n");
		}
	
		if (get_prefixv6_info_by_wan(&prefixInfo, upper_if)!=0){
			printf("Error:get prefix info from %s failed\n", upper_ifname);
		}
		if(set_lan_ipv6_global_address(NULL,&prefixInfo,(char*)LANIF,0,0)!=0){
			printf("Error:del br0 global address failed\n");
		}
	}

	//check box type will use default value
	strVal = boaGetVar(wp, "enableDhcpServer", "0");
	mib_get_s( MIB_DHCPV6_MODE, (void *)&origvChar, sizeof(origvChar));
	printf("enableDhcpServer: %s\n", strVal);
	if ( strVal[0] ) {
		vChar = strVal[0] - '0';
		mode = vChar;
		if(mode!=origvChar){
			syslog(LOG_INFO, "DHCPV6: Change DHCP Mode %d", mode);
		}
		if ( !mib_set(MIB_DHCPV6_MODE, (void *)&mode)) {
  			strcpy(tmpBuf, strSetDhcpModeerror);
			goto setErr_dhcpv6;
		}
	}

#ifdef SUPPORT_DHCPV6_RELAY
	if( mode == DHCP_LAN_RELAY ){
		unsigned int upper_if;
	
		str = boaGetVar(wp, "upper_if", "");
		if(str[0])
		{
			upper_if = (unsigned int)atoi(str);
			if ( !mib_set(MIB_DHCPV6R_UPPER_IFINDEX, (void *)&upper_if)) {
				strcpy(tmpBuf, "设定 MIB_DHCPV6R_UPPER_IFINDEX mib 错误!"); //Set MIB_DHCPV6R_UPPER_IFINDEX mib error!
				goto setErr_dhcpv6;
			}	
			if(upper_if!= DUMMY_IFINDEX){
				ifGetName(upper_if, value,sizeof(value));
				syslog(LOG_INFO, "DHCPV6: Relay Interface %s", value);
			}
		}
		else
		{
			strcpy(tmpBuf, "中继绑定的连接不能为空!");
			goto setErr_dhcpv6;
		}
	}
	else
#endif
	if( mode != DHCP_LAN_NONE)
	{
	strVal = boaGetVar(wp, "ipv6landnsconf", "");
	printf("ipv6landnsconf: %s\n", strVal);
	if ( strVal[0] ) {
		dhcpMode = strVal[0] - '0';
		mib_set( MIB_DHCPV6S_TYPE, (void *)&dhcpMode);
		if( dhcpMode == DHCPV6S_TYPE_STATIC ) {
			vChar = IPV6_PREFIX_STATIC; //DHCP static too
			mib_set( MIB_PREFIXINFO_PREFIX_MODE, (void *)&vChar);
			vChar = IPV6_DNS_STATIC; //Set Static DNS
			mib_set( MIB_LAN_DNSV6_MODE, (void *)&vChar);
		}
		else {
			vChar = IPV6_PREFIX_DELEGATION; //DHCP auto
			mib_set( MIB_PREFIXINFO_PREFIX_MODE, (void *)&vChar);
		}
	}

	switch(dhcpMode){
	case DHCPV6S_TYPE_STATIC: //static
#ifdef CONFIG_USER_RTK_IPV6_MULTI_LAN_SERVICE_WITH_SINGLE_BR
		//single br should delete default prefix from br0, br0 only accept 1 global IP.
		if(get_prefixv6_info(&lan_prefixInfo) == 0)
			set_lan_ipv6_global_address(NULL, &lan_prefixInfo, (char *)BRIF, 0, 0);
#endif
		str = boaGetVar(wp, "ipv6AddrFormat", "0");
		printf("ipv6AddrFormat: %s\n", str);
		if (str[0]) {
			vChar = atoi(str);
			if ( !mib_set(MIB_DHCPV6S_POOL_ADDR_FORMAT, (void *)&vChar)) {
				strcpy(tmpBuf, "分配地址格式设定错误!"); 
				goto setErr_dhcpv6;
			}
			ipv6AddrFormat = vChar;
		}

		str = boaGetVar(wp, "lanIpv6dhcpprefixlen", "");
		printf("lanIpv6dhcpprefixlen: %s\n", str);
		if (str[0]) {
			prefixLen = atoi(str);
			if ( !mib_set(MIB_DHCPV6S_PREFIX_LENGTH, (void *)&prefixLen) || !mib_set(MIB_IPV6_LAN_PREFIX_LEN, (void *)&prefixLen)) {
				strcpy(tmpBuf, "前缀长度设定错误!"); 
				goto setErr_dhcpv6;
			}
		}
		
		str = boaGetVar(wp, "lanIpv6dhcpprefix", "");
		printf("lanIpv6dhcpprefix: %s\n", str);
		if (str[0]) {
			inet_pton(AF_INET6, str, &ip6Addr);
			prefixtoIp6(&ip6Addr, prefixLen, &targetIP, 0);
			inet_ntop(PF_INET6, &targetIP, lanipv6prefix, sizeof(lanipv6prefix));
			if (!mib_set(MIB_IPV6_LAN_PREFIX, (void *)lanipv6prefix) || !mib_set(MIB_DHCPV6S_PREFIX, (void *)lanipv6prefix) ) {
				strcpy(tmpBuf, "前缀设定错误!"); 
				goto setErr_dhcpv6;
			}
			
			/*Later restart_default_dhcpv6_server will not use MIB_IPV6_LAN_PREFIX and MIB_IPV6_LAN_PREFIX_LEN
			*it will use MIB_DHCPV6S_RANGE_START and MIB_DHCPV6S_RANGE_END
			* we need keep prefix in MIB_IPV6_LAN_PREFIX and MIB_DHCPV6S_RANGE_START in line
			*/
			prefixtoIp6(&ip6Addr, prefixLen, &ip6Addr_start, 0);
			prefixtoIp6(&ip6Addr, prefixLen, &ip6Addr_end, 1);
			inet_ntop(PF_INET6, &ip6Addr_start, min_address, sizeof(min_address));
			inet_ntop(PF_INET6, &ip6Addr_end, max_address, sizeof(max_address));
			printf("dhcpd6 start address: %s  with end address %s", min_address, max_address);
		
			if ( !mib_set(MIB_DHCPV6S_RANGE_START, (void *)&ip6Addr_start)) {
				strcpy(tmpBuf, "地址池开始地址设定错误!"); 
				goto setErr_dhcpv6;
			}
			if ( !mib_set(MIB_DHCPV6S_RANGE_END, (void *)&ip6Addr_end)) {
				strcpy(tmpBuf, "地址池结束地址设定错误!"); 
				goto setErr_dhcpv6;
			}
		}

		str = boaGetVar(wp, "lanIpv6dhcpPreferredLifetime", "");
		printf("lanIpv6dhcpPreferredLifetime: %s\n", str);
		if (str[0]) {
			PFTime = atoi(str);
			if ( !mib_set(MIB_DHCPV6S_PREFERRED_LIFETIME, (void *)&PFTime)) {
				strcpy(tmpBuf, "首选寿命设定错误!"); //Set ULA prefix mib error!
				goto setErr_dhcpv6;
			}
		}
		
		str = boaGetVar(wp, "lanIpv6dhcpValidLifetime", "");
		printf("lanIpv6dhcpValidLifetime: %s\n", str);
		if (str[0]) {
			DLTime = atoi(str);
			if ( !mib_set(MIB_DHCPV6S_DEFAULT_LEASE, (void *)&DLTime)) {
				strcpy(tmpBuf, "有效寿命设定错误!"); //Set ULA prefix mib error!
				goto setErr_dhcpv6;
			}
		}
		
		str = boaGetVar(wp, "Ipv6Dns1", "");
		printf("Ipv6Dns1: %s\n", str);
		strcpy(ipv6dnsv61, str);
		if (str[0]) {
			if ( !inet_pton(PF_INET6, str, &dnsv61) ) {
				strcpy(tmpBuf, Tinvalid_DNS_address);
				goto setErr_dhcpv6;
			}
			if ( !mib_set(MIB_ADSL_WAN_DNSV61, (void *)&dnsv61)) {
				strcpy(tmpBuf, "首选DNS服务器设定错误!"); //Set ULA prefix mib error!
				goto setErr_dhcpv6;
			}
		}
		
		str = boaGetVar(wp, "Ipv6Dns2", "");
		printf("Ipv6Dns2: %s\n", str);
		strcpy(ipv6dnsv62, str);
		if (str[0]) {
			if ( !inet_pton(PF_INET6, str, &dnsv62) ) {
				strcpy(tmpBuf, Tinvalid_DNS_address);
				goto setErr_dhcpv6;
			}
			if ( !mib_set(MIB_ADSL_WAN_DNSV62, (void *)&dnsv62)) {
				strcpy(tmpBuf, "备用DNS服务器设定错误!"); //Set ULA prefix mib error!
				goto setErr_dhcpv6;
			}
		}
		/* Now we only have br0 for LAN bridge. Add static pd route for default wan interface policy route. */
		snprintf(static_prefix_str, sizeof(static_prefix_str), "%s/%d", lanipv6prefix, prefixLen);
		add_static_pd_route_for_default_waninf((char *)static_prefix_str, (char *)BRIF);

		syslog(LOG_INFO, "DHCPV6: DNS mode Static, addrFormat: %d, prefix: %s, prefixLen: %d, preferredLifetime: %d, validLifetime: %d, Dns1: %s, Dns2: %s", 
			ipv6AddrFormat, lanipv6prefix, prefixLen, PFTime, DLTime, ipv6dnsv61, ipv6dnsv62);
		break;
	case DHCPV6S_TYPE_AUTO:
	case DHCPV6S_TYPE_AUTO_DNS_ONLY:
		strVal = boaGetVar(wp, "ipv6landnsmode", "");
		printf("ipv6landnsmode: original value %s\n", strVal);
		if ( strVal[0] ) {
			ext_if = (unsigned int)atoi(strVal);
			if(ext_if == 0 || ext_if == 2){
				mode = ext_if;
				mib_set( MIB_LAN_DNSV6_MODE, (void *)&mode);
			}
			else{
				mode = IPV6_DNS_WANCONN;
				mib_set( MIB_LAN_DNSV6_MODE, (void *)&mode);
			}
		}
		printf("ipv6landnsmode: %d\n", mode);
		
		switch(mode){
		case IPV6_DNS_HGWPROXY://HGWProxy
			syslog(LOG_INFO, "DHCPV6: DNS mode %s, HGWPROXY", dhcpMode == DHCPV6S_TYPE_AUTO? "Prefix+DNS": "DNS only");
			break;
		case IPV6_DNS_WANCONN:
			printf("DNS WANConnect at 0x%x\n",ext_if);
			if ( !mib_set(MIB_DNSINFO_WANCONN, (void *)&ext_if)) {
				strcpy(tmpBuf, "Error!! set LAN IPv6 DNS WAN Conn fail!");
				goto setErr_dhcpv6;
			}
			if(ext_if!=DUMMY_IFINDEX){
				ifGetName(ext_if, value, sizeof(value));
				syslog(LOG_INFO, "DHCPV6: DNS mode %s, wan interface %s", dhcpMode == DHCPV6S_TYPE_AUTO? "Prefix+DNS": "DNS only", value);
			}
			else
				syslog(LOG_INFO, "DHCPV6: DNS mode %s", dhcpMode == DHCPV6S_TYPE_AUTO? "Prefix+DNS": "DNS only");
			break;
		case IPV6_DNS_STATIC://static
			str = boaGetVar(wp, "Ipv6Dns1", "");
			printf("Ipv6Dns1: %s\n", str);
			strcpy(ipv6dnsv61, str);
			if (str[0]) {
				if ( !inet_pton(PF_INET6, str, &dnsv61) ) {
					strcpy(tmpBuf, Tinvalid_DNS_address);
					goto setErr_dhcpv6;
				}
				if ( !mib_set(MIB_ADSL_WAN_DNSV61, (void *)&dnsv61)) {
					strcpy(tmpBuf, "首选DNS服务器设定错误!"); //Set ULA prefix mib error!
					goto setErr_dhcpv6;
				}
			}
			
			str = boaGetVar(wp, "Ipv6Dns2", "");
			printf("Ipv6Dns2: %s\n", str);
			strcpy(ipv6dnsv62, str);
			if (str[0]) {
				if ( !inet_pton(PF_INET6, str, &dnsv62) ) {
					strcpy(tmpBuf, Tinvalid_DNS_address);
					goto setErr_dhcpv6;
				}
				if ( !mib_set(MIB_ADSL_WAN_DNSV62, (void *)&dnsv62)) {
					strcpy(tmpBuf, "备用DNS服务器设定错误!"); //Set ULA prefix mib error!
					goto setErr_dhcpv6;
				}
			}
			syslog(LOG_INFO, "DHCPV6: DNS mode %s, Dns1: %s, Dns2: %s", dhcpMode == DHCPV6S_TYPE_AUTO? "Prefix+DNS": "DNS only", ipv6dnsv61, ipv6dnsv62);
			break;
		}
		
		break;
	}
	}
// Magician: Commit immediately
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif
    //restart flow will clean old daemon
	restart_default_dhcpv6_server();
#ifndef NO_ACTION
	pid = fork();
	if (pid)
		waitpid(pid, NULL, 0);
	else if (pid == 0) {
		snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _CONFIG_SCRIPT_PROG);
#ifdef HOME_GATEWAY
		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "gw", "bridge", NULL);
#else
		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "ap", "bridge", NULL);
#endif
		exit(1);
	}
#endif

	submitUrl = boaGetVar(wp, "submit-url", "");
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
  return;

setErr_dhcpv6:
	ERR_MSG(tmpBuf);

}
#endif
void formDhcpv6(request * wp, char *path, char *query)
{
	char *submitUrl, *str, *str_prefix, *str_min, *str_max,*strVal;
	static char tmpBuf[100];
	unsigned char origvChar,vChar;
	unsigned int origInt;
	char *strdhcpenable;
	char origDhcpv6Type=0, newDhcpv6Type=0, *strdhcpetype=NULL;
	unsigned char mode;
	DHCP_TYPE_T curDhcp;
	unsigned char prefixLen=0;
	struct in6_addr ip6Addr_prefix, ip6Addr_start, ip6Addr_end;
	int dhcpd6pid;
	PREFIX_V6_INFO_T prefixInfo;

	//Clear old static IPv6 info in br0
	if ( !mib_get_s( MIB_DHCPV6_MODE, (void *)&origvChar, sizeof(origvChar)) ) {
		//strcpy(tmpBuf, strGetDhcpModeerror);
		snprintf(tmpBuf, sizeof(tmpBuf), "%s", strGetDhcpModeerror);
		goto setErr_dhcpv6;
	}
	if ( !mib_get_s( MIB_DHCPV6S_TYPE, (void *)&origDhcpv6Type, sizeof(origDhcpv6Type)) ) {
		snprintf(tmpBuf,sizeof(tmpBuf), "Get dhcpv6 type err!");
		goto setErr_dhcpv6;
	}

	if ((origvChar == DHCP_LAN_SERVER) && (origDhcpv6Type == DHCPV6S_TYPE_STATIC)){
		mib_get_s(MIB_DHCPV6S_RANGE_START, (void *)ip6Addr_prefix.s6_addr, sizeof(ip6Addr_prefix.s6_addr));
		mib_get_s(MIB_DHCPV6S_PREFIX_LENGTH, (void *)&prefixLen, sizeof(prefixLen));
		memcpy(prefixInfo.prefixIP, &ip6Addr_prefix, IP6_ADDR_LEN);
		prefixInfo.prefixLen = prefixLen;
		//del dhcpv6 static prefix address
		set_lan_ipv6_global_address(NULL,&prefixInfo,(char*)LANIF,0,0);
		//del dhcpv6 static prefix route for LAN route table(IP_ROUTE_LAN_TABLE)
		set_ipv6_lan_policy_route((char *)LANIF, (struct in6_addr *)&prefixInfo.prefixIP, prefixInfo.prefixLen, 0);
	}else if (origvChar == DHCP_LAN_RELAY){
		char upper_ifname[8];
		unsigned int upper_if;
		MIB_CE_ATM_VC_T Entry;
		if ( !mib_get_s(MIB_DHCPV6R_UPPER_IFINDEX, (void *)&upper_if, sizeof(upper_if))) {
			snprintf(tmpBuf, sizeof(tmpBuf),"Get MIB_DHCPV6R_UPPER_IFINDEX mib error!");
			goto setErr_dhcpv6;
		}		
	
		if ( upper_if != DUMMY_IFINDEX ){
			ifGetName(upper_if, upper_ifname, sizeof(upper_ifname));
		}
		else{
			printf("Error: The upper interface of dhcrelayV6 not set !");
		}
	
		if (!(getATMVCEntryByIfIndex(upper_if, &Entry))){
			printf("Error! Could not get MIB entry info from wanconn\n");
		}
	
		if (get_prefixv6_info_by_wan(&prefixInfo, upper_if)!=0){
			printf("Error:get prefix info from %s failed\n", upper_ifname);
		}
		if(set_lan_ipv6_global_address(NULL,&prefixInfo,(char*)LANIF,0,0)!=0){
			printf("Error:del br0 global address failed\n");
		}
	}

	strdhcpenable = boaGetVar(wp, "dhcpdenable", "");
	if(strdhcpenable[0])
	{
		sscanf(strdhcpenable, "%u", &origInt);
		mode = (unsigned char)origInt;
		if ( !mib_set(MIB_DHCPV6_MODE, (void *)&mode)) {
  			strcpy(tmpBuf, strSetDhcpModeerror);
			goto setErr_dhcpv6;
		}

		strdhcpetype = boaGetVar(wp, "dhcpdv6Type", "");
		if(strdhcpetype[0])
		{
			newDhcpv6Type = (*strdhcpetype - '0');
			if ( !mib_set(MIB_DHCPV6S_TYPE, (void *)&newDhcpv6Type)) {
				strcpy(tmpBuf, strSetDhcpModeerror);
				goto setErr_dhcpv6;
			}
		}
	}

	if ( !mib_get_s( MIB_DHCPV6_MODE, (void *)&origvChar, sizeof(origvChar)) ) {
		strcpy(tmpBuf, strGetDhcpModeerror);
		goto setErr_dhcpv6;
	}
	curDhcp = (DHCP_TYPE_T) origvChar;

	if ( !mib_get_s( MIB_DHCPV6S_TYPE, (void *)&origDhcpv6Type, sizeof(origDhcpv6Type))){
		strcpy(tmpBuf, strGetDhcpModeerror);
		goto setErr_dhcpv6;
	}

	if (curDhcp == DHCP_LAN_SERVER){ 
		if (origDhcpv6Type==DHCPV6S_TYPE_AUTO)  {
			str = boaGetVar(wp, "save", "");
			if (str[0]) {
				str_min = boaGetVar(wp, "dhcpRangeStart", "");
				str_max = boaGetVar(wp, "dhcpRangeEnd", "");

				printf("[%s:%d] min %s, max %s\n",__func__,__LINE__,str_min,str_max);
				//TODO: check if the start, end IP range could be valid IPv6 Address
				mib_set(MIB_DHCPV6S_MIN_ADDRESS, (void *)str_min);
				mib_set(MIB_DHCPV6S_MAX_ADDRESS, (void *)str_max);

			} // of save
		}else if (origDhcpv6Type==DHCPV6S_TYPE_STATIC){
			unsigned int DLTime, PFTime, RNTime, RBTime;

			str = boaGetVar(wp, "save", "");
			if (str[0]) {
				str = boaGetVar(wp, "dhcpRangeStart", "");
				if (!inet_pton(PF_INET6, str, &ip6Addr_start)) {
					strcpy(tmpBuf, Tinvalid_start_ip);
					goto setErr_dhcpv6;
				}

				str = boaGetVar(wp, "dhcpRangeEnd", "");
				if (!inet_pton(PF_INET6, str, &ip6Addr_end)) {
					strcpy(tmpBuf, Tinvalid_end_ip);
					goto setErr_dhcpv6;
				}

				str = boaGetVar(wp, "prefix_len", "");
				prefixLen = (char)atoi(str);

				str = boaGetVar(wp, "Dltime", "");
				sscanf(str, "%u", &DLTime);

				str = boaGetVar(wp, "PFtime", "");
				sscanf(str, "%u", &PFTime);

				str = boaGetVar(wp, "RNtime", "");
				sscanf(str, "%u", &RNTime);

				str = boaGetVar(wp, "RBtime", "");
				sscanf(str, "%u", &RBTime);

				str = boaGetVar(wp, "clientID", "");

				// Everything is ok, so set it.
				mib_set(MIB_DHCPV6S_RANGE_START, (void *)&ip6Addr_start);
				mib_set(MIB_DHCPV6S_RANGE_END, (void *)&ip6Addr_end);
				mib_set(MIB_DHCPV6S_PREFIX_LENGTH, (char *)&prefixLen);
				mib_set(MIB_DHCPV6S_DEFAULT_LEASE, (void *)&DLTime);
				mib_set(MIB_DHCPV6S_PREFERRED_LIFETIME, (void *)&PFTime);
				mib_set(MIB_DHCPV6S_RENEW_TIME, (void *)&RNTime);
				mib_set(MIB_DHCPV6S_REBIND_TIME, (void *)&RBTime);
				mib_set(MIB_DHCPV6S_CLIENT_DUID, (void *)str);
			} // of save

			// Delete all Name Server
			str = boaGetVar(wp, "delAllNameServer", "");
			if (str[0]) {
				mib_chain_clear(MIB_DHCPV6S_NAME_SERVER_TBL); /* clear chain record */
				goto setOk_dhcpv6;
			}

			/* Delete selected Name Server */
			str = boaGetVar(wp, "delNameServer", "");
			if (str[0]) {
				unsigned int i;
				unsigned int idx;
				unsigned int totalEntry = mib_chain_total(MIB_DHCPV6S_NAME_SERVER_TBL); /* get chain record size */
				unsigned int deleted = 0;

				for (i=0; i<totalEntry; i++) {

					idx = totalEntry-i-1;
					snprintf(tmpBuf, 20, "select%d", idx);
					strVal = boaGetVar(wp, tmpBuf, "");

					if ( !gstrcmp(strVal, "ON") ) {
						deleted ++;
						if(mib_chain_delete(MIB_DHCPV6S_NAME_SERVER_TBL, idx) != 1) {
							strcpy(tmpBuf, "删除失败!"); //Delete chain record error!
							goto setErr_dhcpv6;
						}
					}
				}
				if (deleted <= 0) {
					strcpy(tmpBuf, "没有选择删除的项目(MIB_DHCPV6S_NAME_SERVER_TBL)!"); //There is no item selected to delete
					goto setErr_dhcpv6;
				}

				goto setOk_dhcpv6;
			}

			// Add Name server
			str = boaGetVar(wp, "addNameServer", "");
			if (str[0]) {
				MIB_DHCPV6S_NAME_SERVER_T entry;
				int i, intVal;
				unsigned int totalEntry = mib_chain_total(MIB_DHCPV6S_NAME_SERVER_TBL); /* get chain record size */

				str = boaGetVar(wp, "nameServerIP", "");

				if (strlen(str) == 0)
				{		
					strcpy(tmpBuf, "错误：不能加入空的Name Server" );
					goto setErr_dhcpv6;
				}
				//printf("formDOMAINBLK:(Add) str = %s\n", str);
				// Jenny, check duplicated rule
				for (i = 0; i< totalEntry; i++) {
					if (!mib_chain_get(MIB_DHCPV6S_NAME_SERVER_TBL, i, (void *)&entry)) {
						strcpy(tmpBuf, errGetEntry);
						goto setErr_dhcpv6;
					}
					if (!strcmp(entry.nameServer, str)) {
						strcpy(tmpBuf, strMACInList );
						goto setErr_dhcpv6;
					}
				}

				// add into configuration (chain record)
				strcpy(entry.nameServer, str);

				intVal = mib_chain_add(MIB_DHCPV6S_NAME_SERVER_TBL, (unsigned char*)&entry);
				if (intVal == 0) {
					//boaWrite(wp, "%s", "Error: Add Domain Blocking chain record.");
					//return;
					strcpy(tmpBuf, "错误: 加入 Name Server chain record for DHCPv6."); //Error: Add Name Server chain record for DHCPv6.
					goto setErr_dhcpv6;
				}
				else if (intVal == -1) {
					strcpy(tmpBuf, strTableFull);
					goto setErr_dhcpv6;
				}

			}

			// Delete all Domain
			str = boaGetVar(wp, "delAllDomain", "");
			if (str[0]) {
				mib_chain_clear(MIB_DHCPV6S_DOMAIN_SEARCH_TBL); /* clear chain record */
				goto setOk_dhcpv6;
			}

			/* Delete selected Domain */
			str = boaGetVar(wp, "delDomain", "");
			if (str[0]) {
				unsigned int i;
				unsigned int idx;
				unsigned int totalEntry = mib_chain_total(MIB_DHCPV6S_DOMAIN_SEARCH_TBL); /* get chain record size */
				unsigned int deleted = 0;

				for (i=0; i<totalEntry; i++) {

					idx = totalEntry-i-1;
					snprintf(tmpBuf, 20, "select%d", idx);
					strVal = boaGetVar(wp, tmpBuf, "");

					if ( !gstrcmp(strVal, "ON") ) {
						deleted ++;
						if(mib_chain_delete(MIB_DHCPV6S_DOMAIN_SEARCH_TBL, idx) != 1) {
							strcpy(tmpBuf, "删除失败!"); //Delete chain record error!
							goto setErr_dhcpv6;
						}
					}
				}
				if (deleted <= 0) {
					strcpy(tmpBuf, "没有选择删除的项目(MIB_DHCPV6S_DOMAIN_SEARCH_TBL)!"); //There is no item selected to delete
					goto setErr_dhcpv6;
				}

				goto setOk_dhcpv6;
			}

			// Add doamin
			str = boaGetVar(wp, "addDomain", "");
			if (str[0]) {
				MIB_DHCPV6S_DOMAIN_SEARCH_T entry;
				int i, intVal;
				unsigned int totalEntry = mib_chain_total(MIB_DHCPV6S_DOMAIN_SEARCH_TBL); /* get chain record size */

				str = boaGetVar(wp, "domainStr", "");
				//printf("formDOMAINBLK:(Add) str = %s\n", str);
				// Jenny, check duplicated rule
				if (strlen(str) == 0)
				{		
					strcpy(tmpBuf, "错误：不能加入空的Domain Name" );
					goto setErr_dhcpv6;
				}
				for (i = 0; i< totalEntry; i++) {
					if (!mib_chain_get(MIB_DHCPV6S_DOMAIN_SEARCH_TBL, i, (void *)&entry)) {
						strcpy(tmpBuf, errGetEntry);
						goto setErr_dhcpv6;
					}
					if (!strcmp(entry.domain, str)) {
						strcpy(tmpBuf, strMACInList );
						goto setErr_dhcpv6;
					}
				}

				// add into configuration (chain record)
				strcpy(entry.domain, str);

				intVal = mib_chain_add(MIB_DHCPV6S_DOMAIN_SEARCH_TBL, (unsigned char*)&entry);
				if (intVal == 0) {
					//boaWrite(wp, "%s", "Error: Add Domain Blocking chain record.");
					//return;
					strcpy(tmpBuf, "错误: 加入 Domain chain record for DHCPv6."); //Error: Add Domain chain record for DHCPv6.
					goto setErr_dhcpv6;
				}
				else if (intVal == -1) {
					strcpy(tmpBuf, strTableFull);
					goto setErr_dhcpv6;
				}

			}
		}
	}
	else if( curDhcp == DHCP_LAN_RELAY ){
		unsigned int upper_if;

		str = boaGetVar(wp, "upper_if", "");
		upper_if = (unsigned int)atoi(str);

		if ( !mib_set(MIB_DHCPV6R_UPPER_IFINDEX, (void *)&upper_if)) {
			strcpy(tmpBuf, "设定 MIB_DHCPV6R_UPPER_IFINDEX mib 错误!"); //Set MIB_DHCPV6R_UPPER_IFINDEX mib error!
			goto setErr_dhcpv6;
		}

	}

setOk_dhcpv6:
	// start dhcpd

// Magician: Commit immediately
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif
    //restart flow will clean old daemon
	restart_default_dhcpv6_server();

#ifndef NO_ACTION
	pid = fork();
	if (pid)
		waitpid(pid, NULL, 0);
	else if (pid == 0) {
		snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _CONFIG_SCRIPT_PROG);
#ifdef HOME_GATEWAY
		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "gw", "bridge", NULL);
#else
		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "ap", "bridge", NULL);
#endif
		exit(1);
	}
#endif

	submitUrl = boaGetVar(wp, "submit-url", "");
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
  return;

setErr_dhcpv6:
	ERR_MSG(tmpBuf);
}


int showDhcpv6SNameServerTable(int eid, request * wp, int argc, char **argv)
{
	int nBytesSent=0;

	unsigned int entryNum, i;
	MIB_DHCPV6S_NAME_SERVER_T Entry;
	unsigned long int d,g,m;
	unsigned char sdest[MAX_V6_IP_LEN];

	entryNum = mib_chain_total(MIB_DHCPV6S_NAME_SERVER_TBL);

	nBytesSent += boaWrite(wp, "'<tr><font size=1>'+"
	"'<td align=center width=\"5%%\" bgcolor=\"#808080\">Select</td>'+\n"
	"'<td align=center width=\"35%%\" bgcolor=\"#808080\">Name Server</td></font></tr>'+\n");


	for (i=0; i<entryNum; i++) {

		if (!mib_chain_get(MIB_DHCPV6S_NAME_SERVER_TBL, i, (void *)&Entry))
		{
  			boaError(wp, 400, "读取Name Server chain record错误!\n"); //Get Name Server chain record error!
			return -1;
		}

		strncpy(sdest, Entry.nameServer, strlen(Entry.nameServer));
		sdest[strlen(Entry.nameServer)] = '\0';

		nBytesSent += boaWrite(wp, "'<tr>'+"
//		"<td align=center width=\"5%%\" bgcolor=\"#C0C0C0\"><input type=\"radio\" name=\"select\""
//		" value=\"s%d\"></td>\n"
		"'<td align=center width=\"5%%\" bgcolor=\"#C0C0C0\"><input type=\"checkbox\" name=\"select%d\" value=\"ON\"></td>'+\n"
		"'<td align=center width=\"35%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"><b>%s</b></font></td></tr>'+\n",
		i, sdest);
	}

	return 0;
}

int showDhcpv6SDOMAINTable(int eid, request * wp, int argc, char **argv)
{
	int nBytesSent=0;

	unsigned int entryNum, i;
	MIB_DHCPV6S_DOMAIN_SEARCH_T Entry;
	unsigned long int d,g,m;
	unsigned char sdest[MAX_DOMAIN_LENGTH];

	entryNum = mib_chain_total(MIB_DHCPV6S_DOMAIN_SEARCH_TBL);

	nBytesSent += boaWrite(wp, "'<tr><font size=1>'+"
	"'<td align=center width=\"5%%\" bgcolor=\"#808080\">Select</td>'+\n"
	"'<td align=center width=\"35%%\" bgcolor=\"#808080\">Domain</td></font></tr>'+\n");


	for (i=0; i<entryNum; i++) {

		if (!mib_chain_get(MIB_DHCPV6S_DOMAIN_SEARCH_TBL, i, (void *)&Entry))
		{
  			boaError(wp, 400, "读取Domain search chain record错误!\n"); //Get Domain search chain record error!
			return -1;
		}

		strncpy(sdest, Entry.domain, strlen(Entry.domain));
		sdest[strlen(Entry.domain)] = '\0';

		nBytesSent += boaWrite(wp, "'<tr>'+"
//		"<td align=center width=\"5%%\" bgcolor=\"#C0C0C0\"><input type=\"radio\" name=\"select\""
//		" value=\"s%d\"></td>\n"
		"'<td align=center width=\"5%%\" bgcolor=\"#C0C0C0\"><input type=\"checkbox\" name=\"select%d\" value=\"ON\"></td>'+\n"
		"'<td align=center width=\"35%%\" bgcolor=\"#C0C0C0\"><font size=\"2\"><b>%s</b></font></td></tr>'+\n",
		i, sdest);
	}

	return 0;
}

#endif  //#ifdef CONFIG_IPV6

