#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <dirent.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <signal.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <sys/wait.h>
#include <time.h>
#include <net/route.h>
#include <sys/ioctl.h>
#include <signal.h>
#include <sys/ioctl.h>

/*-- Local inlcude files --*/
#include "../../webs.h"
#include "webform.h"
#include "mib.h"
#include "../sysconfig.h"
#include "../utility.h"


int fmDMS_checkWrite(int eid, request * wp, int argc, char **argv)
{
	char *name;	
	unsigned int enable;
	
   	if (boaArgs(argc, argv, "%s", &name) < 1) {
   		boaError(wp, 400, "Insufficient args\n");
		//printf( "%s: error, line=%d\n", __FUNCTION__, __LINE__ );
   		return -1;
   	}

	// Mason Yu. use table not chain		
	mib_get_s(MIB_DMS_ENABLE, (void *)&enable, sizeof(enable));

	if(!strcmp(name, "fmDMS-enable-dis")) {
		if(enable==0) boaWrite(wp, "checked");
		return 0;
	}
	else if(!strcmp(name, "fmDMS-enable-en")) {
		if(enable) boaWrite(wp, "checked");
		return 0;
	}
	
	return 0;
}

#define RECONNECT_MSG(url) do { \
	boaHeader(wp); \
	boaWrite(wp, "<body><blockquote><h4>Change setting successfully!" \
                "<form><input type=button value=\"  OK  \" OnClick=window.location.replace(\"%s\")></form></blockquote></body>", url);\
	boaFooter(wp); \
	boaDone(wp, 200); \
} while(0)


void formDMSConf(request * wp, char *path, char *query)
{
	// Mason Yu. use table not chain
	char *strVal;	
	int enable;
	char tmpBuf[100];

	// enable/disable DMS
	strVal = boaGetVar(wp, "enableDMS", "");

	if ( strVal[0] == '1' ) {//enable
		enable = 1;
	}
	else if( strVal[0] == '0' )//disable
		enable = 0;
	else{
		snprintf(tmpBuf, sizeof(tmpBuf), "%s", "get enableDMS error!");
		goto setErr_dms;
	}
	
	mib_set(MIB_DMS_ENABLE, (void *)&enable);		

#ifdef CONFIG_USER_MINIDLNA
	if(enable)
		startMiniDLNA();
	else
		stopMiniDLNA();
#endif
// Magician: Commit immediately
#ifdef COMMIT_IMMEDIATELY	
	Commit();
#endif
	
	strVal = boaGetVar(wp, "submit-url", "");
	//RECONNECT_MSG(strVal);
	if (strVal[0])
		boaRedirect(wp, strVal);
	else
		boaDone(wp, 200);
	return;

setErr_dms:
	ERR_MSG(tmpBuf);
	return;

}

