/*
 *      Web server handler routines for IGMP proxy stuffs
 *
 */


/*-- System inlcude files --*/
#include <string.h>
#include <sys/socket.h>
#include <linux/if.h>
#include <signal.h>

/*-- Local inlcude files --*/
#include "../webs.h"
#include "webform.h"
#include "mib.h"
#include "utility.h"
#include "fmdefs.h"    // Mason Yu. IGMP Proxy for e8b

#ifdef __i386__
#define _LITTLE_ENDIAN_
#endif

/*-- Macro declarations --*/
#ifdef _LITTLE_ENDIAN_
#define ntohdw(v) ( ((v&0xff)<<24) | (((v>>8)&0xff)<<16) | (((v>>16)&0xff)<<8) | ((v>>24)&0xff) )

#else
#define ntohdw(v) (v)
#endif

extern int startIgmproxy();

#ifdef CONFIG_USER_IGMPPROXY
#define RUNFILE "/var/run/igmp_pid"
///////////////////////////////////////////////////////////////////
void formIgmproxy (request * wp, char *path, char *query)
{
	struct igmproxy_entry	entry;
	char*			str_enb;
	int				index = 0;
	int				lineno = __LINE__;
	unsigned int entryNum, i;
	MIB_CE_ATM_VC_T Entry;
	char wanname[MAX_WAN_NAME_LEN];
	unsigned char is_enabled;
	
	_BC_USE;
	
	_TRACE_CALL;

	str_enb = boaGetVar(wp, "igmpProxy", "");
	if(str_enb[0])
	{
		if (!strcmp((const char*)str_enb, "on"))
			is_enabled = 1;
		else
			is_enabled = 0;

		mib_set(MIB_IGMP_PROXY, (void *)&is_enabled);
	}

	_BC_INIT("bcdata");

	while(_BC_NEXT())
	{
		memset(&entry, 0, sizeof(struct igmproxy_entry));
		_BC_ENTRY_STR(ifName, _BC_NEED);
		_BC_ENTRY_INT(enable, _BC_NEED);
		if(entry.enable > 1){lineno = __LINE__; continue;}

		/************Place your code here, do what you want to do! ************/
		/************Place your code here, do what you want to do! ************/
		entryNum = mib_chain_total(MIB_ATM_VC_TBL);
		for (i=0; i<entryNum; i++) 
		{
			if (!mib_chain_get(MIB_ATM_VC_TBL, i, (void *)&Entry))
			{
				boaError(wp, 400, "读取chain record错误!\n"); //Get chain record error!
				_BC_FREE();
				return;
			}
			getWanName(&Entry, wanname);

			if(!strcmp(entry.ifName,wanname)){
				if(entry.enable)
					Entry.enableIGMP =1;
				else 
					Entry.enableIGMP =0;

				mib_chain_update(MIB_ATM_VC_TBL, (void *)&Entry,i);
				break;
			}	 		
		 }			
	}
		   
#ifdef CONFIG_IGMPPROXY_MULTIWAN
	setting_Igmproxy();
#endif

// Magician: Commit immediately
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif	 
	
	_COND_REDIRECT;
check_err:
	_BC_FREE();
	_TRACE_LEAVEL;
	return;
}

#if 0
void formIgmproxy(request * wp, char *path, char *query)
{
	char	*str, *submitUrl;
	char tmpBuf[100];
	FILE *fp;
	char * argv[8];
	char ifname[6];
#ifndef NO_ACTION
	int pid;
#endif
	unsigned char proxy;
	unsigned int proxy_if;
#ifdef EMBED
	unsigned char if_num;
	int igmp_pid;
#endif

	// Set IGMP proxy
	str = boaGetVar(wp, "proxy", "");
	if (str[0]) {
		if (str[0] == '0')
			proxy = 0;
		else
			proxy = 1;
		if ( !mib_set(MIB_IGMP_PROXY, (void *)&proxy)) {
			strcpy(tmpBuf, "Set IGMP proxy error!");
			goto setErr_igmp;
		}
	}
#ifdef CONFIG_IGMPPROXY_MULTIWAN
	setting_Igmproxy();
#else
	str = boaGetVar(wp, "proxy_if", "");
	if (str[0]) {
		proxy_if = (unsigned int)atoi(str);
		if ( !mib_set(MIB_IGMP_PROXY_ITF, (void *)&proxy_if)) {
			strcpy(tmpBuf, "Set IGMP proxy interface index error!");
			goto setErr_igmp;
		}
	}

#ifdef EMBED
	startIgmproxy();
#endif
#endif // of CONFIG_IGMPPROXY_MULTIWAN

// Magician: Commit immediately
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif

#ifndef NO_ACTION
	pid = fork();
	if (pid)
		waitpid(pid, NULL, 0);
	else if (pid == 0) {
		snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _CONFIG_SCRIPT_PROG);
#ifdef HOME_GATEWAY
		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "gw", "bridge", NULL);
#else
		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "ap", "bridge", NULL);
#endif
		exit(1);
	}
#endif

	submitUrl = boaGetVar(wp, "submit-url", "");
	OK_MSG(submitUrl);
	return;

setErr_igmp:
	ERR_MSG(tmpBuf);
}
#endif

// Mason Yu. IGMP Proxy for e8b
int igmproxyList(int eid, request * wp, int argc, char ** argv)
{
	struct igmproxy_entry	entry ;
	int				cnt = 2;
	int				index = 0;
	int				lineno = __LINE__;

    unsigned int entryNum, i;
		
	MIB_CE_ATM_VC_T Entry;
	char wanname[MAX_WAN_NAME_LEN];
	unsigned char igmpProxy;
	_TRACE_CALL;

	mib_get_s(MIB_IGMP_PROXY, &igmpProxy, sizeof(igmpProxy));
	_PUT_BOOL(igmpProxy);
	
	entryNum = mib_chain_total(MIB_ATM_VC_TBL);
	for (i=0; i<entryNum; i++) 
	{
		if (!mib_chain_get(MIB_ATM_VC_TBL, i, (void *)&Entry))
		{
  			boaError(wp, 400, "Get chain record error!\n");
			return -1;
		}
		
		if (Entry.enable == 0)
			continue;
		if(((Entry.cmode == CHANNEL_MODE_IPOE||Entry.cmode == CHANNEL_MODE_PPPOA||Entry.cmode == CHANNEL_MODE_PPPOE||Entry.cmode == CHANNEL_MODE_RT1483))
        )
		{
			if(Entry.IpProtocol & IPVER_IPV4){
			memset(&entry, 0, sizeof(struct igmproxy_entry));
			memset(wanname, 0, sizeof(wanname));
			getWanName(&Entry, wanname);
			strcpy(entry.ifName,wanname);
			entry.enable= Entry.enableIGMP;     // Mason Yu. IGMP Proxy for e8b
                       
			boaWrite(wp, "push(new it_nr(\"%d\"" _PTS _PTI "));\n", 
			entryNum, _PME(ifName), _PME(enable));
			}
		}	
		
	}
		
check_err:
	_TRACE_LEAVEL;
	return 0;
}

#endif	// of CONFIG_USER_IGMPPROXY

// List all the available WAN side ip interface at web page.
// return: number of ip interface listed.
int ifwanList(int eid, request * wp, int argc, char **argv)
{
	int nBytesSent=0;
	int ifnum=0;
	unsigned int entryNum, i;
	MIB_CE_ATM_VC_T Entry;
	//char  buffer[3];
	char *name;
	int type, hasAny = 0, wtype=-1;
	int innerHTML=0;  // Mason Yu
	int protocol = IPVER_IPV4_IPV6; // 1:IPv4, 2: IPv6, 3: both. Mason Yu
	int hasVPN = 0;
#ifdef CONFIG_NET_IPIP
	MIB_IPIP_T ipip_Entry;
#endif
#ifdef CONFIG_USER_PPTP_CLIENT_PPTP
	MIB_PPTP_T pptp_Entry;
#endif
#ifdef CONFIG_USER_L2TPD_L2TPD
	MIB_L2TP_T l2tp_Entry;
#endif
#ifdef CONFIG_USER_DNS_RELAY_PROXY
	int lanv4_dns_sign=0;
#endif

	char web_ifname[15];
	char wanname[MAX_WAN_NAME_LEN];
	unsigned int enable;	
	
	if (boaArgs(argc, argv, "%s", &name) < 1) {
		boaError(wp, 400, "Insufficient args\n");
		return -1;
	}

	if ( !strcmp(name, "all") )
		type = 0;
	else if ( !strcmp(name, "all-include-vpn") ) {
			type = 0;
			hasVPN = 1;
	}
	else if ( !strcmp(name, "allv4-include-vpn") ) {
			type = 0;
			hasVPN = 1;
			protocol = IPVER_IPV4;
	}
	else if ( !strcmp(name, "allv6-include-vpn") ) {
			type = 0;
			hasVPN = 1;
			protocol = IPVER_IPV6;
	}
	else if ( !strcmp(name, "all2") ) {  // Mason Yu
			type = 0;
			innerHTML = 1;
	}
	else if ( !strcmp(name, "all2-include-vpn") ) {
			type = 0;
			innerHTML = 1;
			hasVPN = 1;
	}
	else if ( !strcmp(name, "all2v4-include-vpn") ) {
			type = 0;
			innerHTML = 1;
			hasVPN = 1;
			protocol = IPVER_IPV4;
	}
	else if ( !strcmp(name, "all2v6-include-vpn") ) {
			type = 0;
			innerHTML = 1;
			hasVPN = 1;
			protocol = IPVER_IPV6;
	}
	else if ( !strcmp(name, "rt") ) {
		type = 1;	// route interface
		protocol = IPVER_IPV4;
	}
	else if ( !strcmp(name, "rt_dns") ) {
#ifdef CONFIG_USER_DNS_RELAY_PROXY
		type = 1;	hasVPN = 1; // route interface
		protocol = IPVER_IPV4;
		lanv4_dns_sign=1;
#endif

	}
	else if ( !strcmp(name, "rt-any") )
		{
			type = 1; hasAny = 1;
		}
	else if ( !strcmp(name, "br") )
		type = 2;	// bridge interface
	else if ( !strcmp(name, "p2p") )
		type = 3;	// point-to-point interface
	else if ( !strcmp(name, "queueITF") )
		type = 4;  	// Queue interface
#ifdef CONFIG_IPV6
	else if ( !strcmp(name, "rtv4") ) {  // Mason Yu
		type = 1;
		protocol = IPVER_IPV4;
	}
	else if ( !strcmp(name, "rtv6") ) {  // Mason Yu
		type = 1;
		protocol = IPVER_IPV6;
	}
	else if ( !strcmp(name, "rtv4_inet") ) {  // Mason Yu
		type = 1;
		protocol = IPVER_IPV4;
		wtype = 2;
	}
	else if ( !strcmp(name, "rtv6_inet") ) {  // Mason Yu
		type = 1;
		protocol = IPVER_IPV6;
		wtype = 2;
	}
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
	else if ( !strcmp(name, "rtOther") ) {  
		type = 1;
		wtype = 1;
	}
	else if ( !strcmp(name, "rtInternet") ) {  
		type = 1;
		wtype = 2;
	}
	else if ( !strcmp(name, "rtInternetOther") ) {  
		type = 1;
		wtype = 3;
	}
#endif
#endif
#if defined(CONFIG_NET_IPIP) || defined(CONFIG_USER_PPTP_CLIENT_PPTP) || defined(CONFIG_USER_L2TPD_L2TPD)
	else if ( !strcmp(name, "rt-any-vpn") )
		{
			type = 1; hasAny = 1; hasVPN = 1;
		}
	else if ( !strcmp(name, "rtv6-any-vpn") )
		{
			type = 1; hasAny = 1; hasVPN = 1;
		}
#endif
	else if (!strcmp(name, "adsl")) {
		type = 5;
	}
	else if (!strcmp(name, "vdsl")) {
		type = 6;
	}
	else if (!strcmp(name, "eth")) {
		type = 7;
	}
	else
		type = 1;	// default to route

	if (hasAny) {
		nBytesSent += boaWrite(wp, "<option value=%u>Any</option>\n", DUMMY_IFINDEX);
	}

	entryNum = mib_chain_total(MIB_ATM_VC_TBL);

	for (i=0; i<entryNum; i++) {

		if (!mib_chain_get(MIB_ATM_VC_TBL, i, (void *)&Entry))
		{
  			boaError(wp, 400, "Get chain record error!\n");
			return -1;
		}

		if (Entry.enable == 0 || !isValidMedia(Entry.ifIndex))
			continue;
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
		if(wtype == 1)
		{
			if(!(((Entry.cmode == CHANNEL_MODE_IPOE||Entry.cmode == CHANNEL_MODE_PPPOA||\
			Entry.cmode == CHANNEL_MODE_PPPOE||Entry.cmode == CHANNEL_MODE_RT1483))\
			&&(Entry.applicationtype&X_CT_SRV_OTHER)))
				continue;
		}

		if(wtype == 2)
		{
			if(!(((Entry.cmode == CHANNEL_MODE_IPOE||Entry.cmode == CHANNEL_MODE_PPPOA||\
			Entry.cmode == CHANNEL_MODE_PPPOE||Entry.cmode == CHANNEL_MODE_RT1483))\
			&&(Entry.applicationtype&X_CT_SRV_INTERNET)))
				continue;
		}

		if(wtype == 3)
		{
			if(!(((Entry.cmode == CHANNEL_MODE_IPOE||Entry.cmode == CHANNEL_MODE_PPPOA||\
				Entry.cmode == CHANNEL_MODE_PPPOE||Entry.cmode == CHANNEL_MODE_RT1483))\
			&&((Entry.applicationtype&X_CT_SRV_INTERNET)||(Entry.applicationtype&X_CT_SRV_OTHER))&&(Entry.IpProtocol==IPVER_IPV6||Entry.IpProtocol==IPVER_IPV4_IPV6)))
				continue;
		}
#endif

 		//ifGetName(Entry.ifIndex, wanname, sizeof(wanname));
		getWanName(&Entry, wanname);
		if (type == 2) {
			if (Entry.cmode == CHANNEL_MODE_BRIDGE)
			{
				nBytesSent += boaWrite(wp, "<option value=%u>%s</option>\n",
					Entry.ifIndex, wanname);
				ifnum++;
			}
		}
		else if (type == 5) {
			if (MEDIA_INDEX(Entry.ifIndex) == MEDIA_ATM) {
				nBytesSent += boaWrite(wp, "<option value=%u>%s</option>\n",
						Entry.ifIndex, wanname);
			}
		}
		/*
		else if (type == 6) {
		}
		*/
		else if (type == 7) {
			if (MEDIA_INDEX(Entry.ifIndex) == MEDIA_ETH) {
				nBytesSent += boaWrite(wp, "<option value=%u>%s</option>\n",
						Entry.ifIndex, wanname);
			}
		}
		else { // rt or all (1 or 0)
			if ((type == 1 || type == 3) && Entry.cmode == CHANNEL_MODE_BRIDGE)
				continue;

			// check for p-2-p link
//			if (type == 3 && Entry.cmode == CHANNEL_MODE_IPOE)
			if (type == 3 && (Entry.cmode == CHANNEL_MODE_IPOE || Entry.ipunnumbered==1))	// Jenny
				continue;

			// Mason Yu. for IPv6
#ifdef CONFIG_IPV6
			if ( protocol == IPVER_IPV4_IPV6 || Entry.IpProtocol == IPVER_IPV4_IPV6 ) {
				if ( innerHTML != 1 ) {
					nBytesSent += boaWrite(wp, "<option value=%u>%s</option>\n",
						Entry.ifIndex, wanname);
				} else {
					nBytesSent += boaWrite(wp, "<option value=%u>%s</option>",
						Entry.ifIndex, wanname);
				}
			} else if ( protocol == Entry.IpProtocol ) {
				if ( innerHTML != 1 ) {
					nBytesSent += boaWrite(wp, "<option value=%u>%s</option>\n",
						Entry.ifIndex, wanname);
				} else {
					nBytesSent += boaWrite(wp, "<option value=%u>%s</option>",
						Entry.ifIndex, wanname);
				}
			}
#else
			if ( innerHTML != 1 ) {
				nBytesSent += boaWrite(wp, "<option value=%u>%s</option>\n",
					Entry.ifIndex, wanname);
			} else {
				nBytesSent += boaWrite(wp, "<option value=%u>%s</option>",
					Entry.ifIndex, wanname);
			}
#endif
			ifnum++;
		}
	}

#if defined(CONFIG_NET_IPIP) || defined(CONFIG_USER_PPTP_CLIENT_PPTP) || defined(CONFIG_USER_L2TPD_L2TPD)
	if (hasVPN) {
#ifdef CONFIG_NET_IPIP
		// (1) IPIP Tunnel
		if ( !mib_get_s(MIB_IPIP_ENABLE, (void *)&enable, sizeof(enable)) ) {
			boaError(wp, 400, "Get MIB_IPIP_ENABLE chain record error!\n");
			return -1;
		}

		if ( enable) {
			entryNum = mib_chain_total(MIB_IPIP_TBL);
			for (i=0; i<entryNum; i++)
			{
				if (!mib_chain_get(MIB_IPIP_TBL, i, (void *)&ipip_Entry))
				{
					boaError(wp, 400, "Get MIB_IPIP_TBL chain record error!\n");
					return -1;
				}

				ifGetName(ipip_Entry.ifIndex, wanname, sizeof(wanname));
				nBytesSent += boaWrite(wp, "<option value=%u>%s</option>\n",
					ipip_Entry.ifIndex, wanname);
			}
		}
#endif

#ifdef CONFIG_USER_PPTP_CLIENT_PPTP
		// (2) PPTP Tunnel
		if ( !mib_get_s(MIB_PPTP_ENABLE, (void *)&enable, sizeof(enable)) ) {
			boaError(wp, 400, "Get MIB_PPTP_ENABLE chain record error!\n");
			return -1;
		}

		if ( enable) {
			entryNum = mib_chain_total(MIB_PPTP_TBL);
			for (i=0; i<entryNum; i++)
			{
				if (!mib_chain_get(MIB_PPTP_TBL, i, (void *)&pptp_Entry))
				{
					boaError(wp, 400, "Get MIB_PPTP_TBL chain record error!\n");
					return -1;
				}

				ifGetName(pptp_Entry.ifIndex, wanname, sizeof(wanname));
				snprintf(web_ifname, 15, "pptp%d(%s)", pptp_Entry.idx, wanname);
				nBytesSent += boaWrite(wp, "<option value=%u>%s</option>\n",
					pptp_Entry.ifIndex, web_ifname);
			}
		}
#endif

#ifdef CONFIG_USER_L2TPD_L2TPD
		// (3) L2TP Tunnel
		if ( !mib_get_s(MIB_L2TP_ENABLE, (void *)&enable, sizeof(enable)) ) {
			boaError(wp, 400, "Get MIB_L2TP_ENABLE chain record error!\n");
			return -1;
		}

		if ( enable) {
			entryNum = mib_chain_total(MIB_L2TP_TBL);
			for (i=0; i<entryNum; i++)
			{
				if (!mib_chain_get(MIB_L2TP_TBL, i, (void *)&l2tp_Entry))
				{
					boaError(wp, 400, "Get MIB_L2TP_TBL chain record error!\n");
					return -1;
				}

				ifGetName(l2tp_Entry.ifIndex, wanname, sizeof(wanname));
				snprintf(web_ifname, 15, "l2tp%d(%s)", l2tp_Entry.idx, wanname);
				nBytesSent += boaWrite(wp, "<option value=%u>%s</option>\n",
					l2tp_Entry.ifIndex, web_ifname);
			}
		}
#endif
	}
#endif
	//snprintf(buffer, 3, "%u", ifnum);
	//ejSetResult(eid, buffer);
	return nBytesSent;
}

// Mason Yu. IGMP snooping for e8b
void formIgmpSnooping(request * wp, char *path, char *query)
{
	char	*str, *submitUrl, *strSnoop;
	char tmpBuf[100], mode;	
#ifndef NO_ACTION
	int pid;
#endif	
	
#if defined(CONFIG_RTL_IGMP_SNOOPING)
	char origmode = 0;
	strSnoop = boaGetVar(wp, "snoop", "");
	if ( strSnoop[0] ) {
		// bitmap for virtual lan port function
		// Port Mapping: bit-0
		// QoS : bit-1
		// IGMP snooping: bit-2		
		mib_get_s(MIB_MPMODE, (void *)&mode, sizeof(mode));
		origmode = mode;
		strSnoop = boaGetVar(wp, "snoop", "");		
		if ( strSnoop[0] == '1' ) {
			mode |= MP_IGMP_MASK;
			//if(origmode != mode)
			//	igmp_changed_flag = 1;
			// take effect immediately
		}
		else {
			mode &= ~MP_IGMP_MASK;
			//if(origmode != mode)
			//	igmp_changed_flag = 1;
		}		
		mib_set(MIB_MPMODE, (void *)&mode);
		__dev_setupIGMPSnoop((mode & MP_IGMP_MASK)?1:0);
	}
#endif
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif	
		
	submitUrl = boaGetVar(wp, "submit-url", "");
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
	return;	
}

#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
void formIgmpMldSnooping(request * wp, char *path, char *query)
{
	char *strIgmpSnp, *strMldSnp, *submitUrl;
	char mode;
	unsigned char IgmpsnpEnable=1;
	unsigned char MldsnpEnable=1;
#if defined(CONFIG_RTL_IGMP_SNOOPING)
	strIgmpSnp = boaGetVar(wp, "snp_igmp", "");
	strMldSnp = boaGetVar(wp, "snp_mld", "");
	if(strIgmpSnp[0] && strMldSnp[0])
	{
		// bitmap for virtual lan port function
		// Port Mapping: bit-0
		// QoS : bit-1
		// IGMP snooping: bit-2	
		// MLD snooping:bit-3
		mib_get_s(MIB_MPMODE, (void *)&mode, sizeof(mode));

		if(strIgmpSnp[0]=='1') 
			IgmpsnpEnable=1;
		else
			IgmpsnpEnable=0;
		if(strMldSnp[0]=='1')
			MldsnpEnable=1;
		else
			MldsnpEnable=0;


		if(strIgmpSnp[0]=='1')
		{
			mode|=0x4;
#if !(defined(CONFIG_LUNA) && defined(CONFIG_RTK_L34_ENABLE))
			system("/bin/echo 1 > /proc/br_igmpsnoop");
			system("/bin/echo 1 > /proc/br_igmpquery");
#endif
			printf("IGMP Snooping: enable\n");
		}
		else
		{
			mode&=0xFB;
#if !(defined(CONFIG_LUNA) && defined(CONFIG_RTK_L34_ENABLE))
			system("/bin/echo 0 > /proc/br_igmpsnoop");
			system("/bin/echo 0 > /proc/br_igmpquery");
#endif
			printf("IGMP Snooping: disable\n");
		}

		if(strMldSnp[0]=='1')
		{
			mode|=0x8;
#if !(defined(CONFIG_LUNA) && defined(CONFIG_RTK_L34_ENABLE))
			system("/bin/echo 1 > /proc/br_mldsnoop");
			system("/bin/echo 1 > /proc/br_mldquery");
#endif
			printf("MLD Snooping: enable\n");
		}
		else
		{
			mode&=0xF7;
#if !(defined(CONFIG_LUNA) && defined(CONFIG_RTK_L34_ENABLE))
			system("/bin/echo 0 > /proc/br_mldsnoop");
			system("/bin/echo 0 > /proc/br_mldquery");
#endif
			printf("MLD Snooping: disable\n");
		}
#if defined(CONFIG_LUNA) && defined(CONFIG_RTK_L34_ENABLE)
		handleIGMPandMLD(IgmpsnpEnable, MldsnpEnable);
#endif
		mib_set(MIB_MPMODE, (void *)&mode);
	}
	
#endif
#if defined(CONFIG_RTL_IGMP_SNOOPING) || defined(CONFIG_RTL_MLD_SNOOPING) || defined(CONFIG_BRIDGE_IGMP_SNOOPING)
	rtk_multicast_snooping();
#endif

#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif	

	submitUrl = boaGetVar(wp, "submit-url", "");
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
	return;	
}

void formIgmpMldProxy(request * wp, char *path, char *query)
{
	char *submitUrl, *strIgmpProxy, *strMldProxy, *str_extif;
	MIB_CE_ATM_VC_T Entry;
	unsigned char proxyEnable=1, is_enabled, mld_proxy_wan_enable = 0;
	int entryNum, i;
	char tmpBuf[100], vChar=0;
	unsigned int ext_if;
	
	strIgmpProxy = boaGetVar(wp, "igmp_proxy", "");
	strMldProxy = boaGetVar(wp, "mld_proxy", "");
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
	mib_get_s(PROVINCE_WEB_MLD_PROXY_WAN, &mld_proxy_wan_enable, sizeof(mld_proxy_wan_enable));
	if (mld_proxy_wan_enable==1)
		str_extif = boaGetVar(wp, "ext_if", "");
	else
		str_extif="";
#endif
#ifdef CONFIG_USER_IGMPPROXY
	if(strIgmpProxy[0])
	{
		entryNum = mib_chain_total(MIB_ATM_VC_TBL);
		for (i=0; i<entryNum; i++) 
		{
			if (!mib_chain_get(MIB_ATM_VC_TBL, i, (void *)&Entry))
			{
				boaError(wp, 400, "Get chain record error!\n");
				return;
			}
			if (Entry.enable == 0)
				continue;
			if(((Entry.cmode == CHANNEL_MODE_IPOE||Entry.cmode == CHANNEL_MODE_PPPOA||Entry.cmode == CHANNEL_MODE_PPPOE||Entry.cmode == CHANNEL_MODE_RT1483))
						&&(Entry.applicationtype&X_CT_SRV_OTHER))
			{		
				if(strIgmpProxy[0]=='1')
					Entry.enableIGMP = 1;
				//When turn off, don't care
			}
			mib_chain_update(MIB_ATM_VC_TBL, (void *)&Entry,i);
		}
		if(strIgmpProxy[0]=='1')
			vChar = 1;
		mib_set(MIB_IGMP_PROXY, (void *)&vChar);
#ifdef CONFIG_IGMPPROXY_MULTIWAN
		setting_Igmproxy();
#endif
		syslog(LOG_CRIT,"IGMP Proxy:%s",(strIgmpProxy[0]=='1')?"enable":"disable");
	}
#endif			

#ifdef CONFIG_IPV6
#ifdef CONFIG_USER_MLDPROXY
	if(strMldProxy[0])
	{
		if (strMldProxy[0] == '0')
			is_enabled = 0;
		else
			is_enabled = 1;

#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)			
		if(str_extif[0])
			ext_if = (unsigned int)atoi(str_extif);
		else
			ext_if = DUMMY_IFINDEX;  // No interface selected.
#endif

		entryNum = mib_chain_total(MIB_ATM_VC_TBL);
		for (i=0; i<entryNum; i++) 
		{
			if (!mib_chain_get(MIB_ATM_VC_TBL, i, (void *)&Entry))
			{
				boaError(wp, 400, "Get chain record error!\n");
				return;
			}
			if (Entry.enable == 0)
				continue;
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
			if(((Entry.cmode == CHANNEL_MODE_IPOE||Entry.cmode == CHANNEL_MODE_PPPOA||Entry.cmode == CHANNEL_MODE_PPPOE\
			||Entry.cmode == CHANNEL_MODE_RT1483))&&((Entry.applicationtype&X_CT_SRV_INTERNET)||(Entry.applicationtype&X_CT_SRV_OTHER))&&(Entry.IpProtocol==IPVER_IPV6||Entry.IpProtocol==IPVER_IPV4_IPV6))
			{
				if(Entry.ifIndex == ext_if)
					break;
			}

#else
			if(((Entry.cmode == CHANNEL_MODE_IPOE||Entry.cmode == CHANNEL_MODE_PPPOA||Entry.cmode == CHANNEL_MODE_PPPOE||Entry.cmode == CHANNEL_MODE_RT1483))
						&&(Entry.applicationtype&X_CT_SRV_INTERNET))
				break;
#endif
		}

		if(i<entryNum)
			ext_if = Entry.ifIndex;
		else
			ext_if = DUMMY_IFINDEX;  // No interface selected.

		if(!mib_set(MIB_MLD_PROXY_DAEMON, (void *)&is_enabled))
		{
			strcpy(tmpBuf, "Set UPNP error!");
			goto setErr_igmp;
		}

		if(is_enabled)
		{
			if(!mib_set(MIB_MLD_PROXY_EXT_ITF, (void *)&ext_if))
			{
				printf("Set UPNP Binded WAN interface index error(1)\n");
				strcpy(tmpBuf, "UPNP Binded WAN interface index 设定错误!");  //Set UPNP Binded WAN interface index error!
				goto setErr_igmp;
			}
		}
		startMLDproxy();
		syslog(LOG_CRIT,"MLD Proxy:%s",is_enabled?"enable":"disable");
	}
#endif
#endif
	
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif	

	submitUrl = boaGetVar(wp, "submit-url", "");
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
	return;	
	
setErr_igmp:
	ERR_MSG(tmpBuf);
}
#endif
#ifdef CONFIG_CMCC_ENTERPRISE
void igmp_Form(request * wp, char *path, char *query)
{
        char *str, *submitUrl, *strSnoop;
        char tmpBuf[100], mode;
#ifndef NO_ACTION
        int pid;
#endif

#if defined(CONFIG_RTL_IGMP_SNOOPING)
        char origmode = 0;
        // bitmap for virtual lan port function
        // Port Mapping: bit-0
        // QoS : bit-1
        // IGMP snooping: bit-2
	mib_get_s(MIB_MPMODE, (void *)&mode, sizeof(mode));
	origmode = mode;
	strSnoop = boaGetVar(wp, "snooping", "");
	if ( strSnoop[0] ) {
		mode |= MP_IGMP_MASK;
	}
	else {
		mode &= ~MP_IGMP_MASK;
	}
	mib_set(MIB_MPMODE, (void *)&mode);
	__dev_setupIGMPSnoop((mode & MP_IGMP_MASK)?1:0);

#endif
#ifdef COMMIT_IMMEDIATELY
        Commit();
#endif

        submitUrl = boaGetVar(wp, "submit-url", "");
        if (submitUrl[0])
                boaRedirect(wp, submitUrl);
        else
                boaDone(wp, 200);
        return;
}
#endif
