/*-- System inlcude files --*/
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <sys/wait.h>

#include "../webs.h"
#include "webform.h"
#include "mib.h"
#include "utility.h"
#include "ipv6_info.h"

#ifdef EMBED
#include <linux/config.h>
#include <config/autoconf.h>
#else
#include "../../../../include/linux/autoconf.h"
#include "../../../../config/autoconf.h"
#endif

#ifdef CONFIG_IPV6
static const char RADVD_NEW_CONF[] ="/var/radvd2.conf";
static const char DHCPDV6_NEW_CONF[] ="/var/dhcpd6_new_conf";
static const char KEYWORD1[]= "RDNSS ";                    //RADVD use, the last character(space) is necessary
static const char KEYWORD2[]= "option dhcp6.name-servers"; //DHCPv6 Server use!

static void kickRAChangeRDNSS(char *RDNSS, char *lan_ifname)
{
	FILE *fp=NULL;
	FILE *nfp=NULL;
	char buf[512];
	int radvdpid;
	int num_sign_left_braces = 0; // {

	if ((fp = fopen(RADVD_CONF, "r")) == NULL) {
		printf("Open file %s Error!\n", RADVD_CONF);
		return;
	}

	if ((nfp = fopen(RADVD_NEW_CONF, "w")) == NULL) {
		printf("Open file %s Error!\n", RADVD_NEW_CONF);
		fclose(fp);
		return;
	}

	while (fgets(buf, sizeof(buf), fp) > 0) {
		if (strstr(buf,"interface"))
		{
			fprintf(nfp,"%s",buf);
			if (strstr(buf, lan_ifname))
			{
				while (fgets(buf, sizeof(buf), fp) > 0) {
					if (strstr(buf, "{"))
						num_sign_left_braces++;
					if (strstr(buf, "}"))
						num_sign_left_braces--;
					if(strstr(buf, KEYWORD1))
					{
						fprintf(nfp,"\t%s %s\n", KEYWORD1, RDNSS); //only write RDNSS to lan_ifname.
						break;
					}
					else
						fprintf(nfp,"%s",buf);

					if (num_sign_left_braces == 0) //means end of this interface
						break;
				}
			}
		}
		else
			fprintf(nfp,"%s",buf);
	}

#if 0
	while(fgets(buf,sizeof(buf),fp)>0) {
		if(strstr(buf,KEYWORD1))
			fprintf(nfp,"\t%s %s\n",KEYWORD1,RDNSS);
		else
			fprintf(nfp,"%s",buf);
	}
#endif
	fclose(fp);
	fclose(nfp);

	sprintf(buf,"cp %s %s\n",RADVD_NEW_CONF, RADVD_CONF);
	system(buf);

	radvdpid = read_pid((char *)RADVD_PID);
	if (radvdpid > 0) {
		kill(radvdpid, SIGHUP);
	}
}

static void replaceDHCPv6Conf(char *oldFileName, char *newFileName, char *keywordStr, char *replaceStr)
{
	FILE *fp=NULL;
	FILE *nfp=NULL;
	char buf[512];

	if ((fp = fopen(oldFileName, "r")) == NULL) {
		printf("Open file %s Error!\n", oldFileName);
		return;
	}

	if ((nfp = fopen(newFileName, "w")) == NULL) {
		printf("Open file %s Error!\n", newFileName);
		fclose(fp);
		return;
	}

	while(fgets(buf,sizeof(buf),fp)>0) {
		if(strstr(buf, keywordStr))
			fprintf(nfp,"%s %s;\n",keywordStr,replaceStr);
		else
			fprintf(nfp,"%s",buf);
	}

	fclose(fp);
	fclose(nfp);

	sprintf(buf,"cp %s %s\n",newFileName, oldFileName);
	system(buf);

}

static void kickDHCPv6ChangeRDNSS(char *RDNSS, char *lan_ifname)
{
	//replaceDHCPv6Conf((char *)DHCPDV6_CONF_AUTO, (char *)DHCPDV6_NEW_CONF, (char *)KEYWORD2, RDNSS);
	replaceDHCPv6Conf((char *)DHCPDV6_CONF, (char *)DHCPDV6_NEW_CONF, (char *)KEYWORD2, RDNSS);
	restart_default_dhcpv6_server();
}

static void kickDNSRelayChangeOnTheFly()
{
#if defined(CONFIG_USER_DNSMASQ_DNSMASQ) || defined(CONFIG_USER_DNSMASQ_DNSMASQ245)
	reload_dnsrelay("all");
#endif
}

void formlanipv6(request * wp, char *path, char *query)
{
	char *submitUrl;
	static char tmpBuf[100];
	static char cmdBuf[100];
	char *lanIPv6AddrStr=NULL;
	unsigned char ipv6DnsMode=0;

	printf("%s - %d\n", __FUNCTION__, __LINE__);
	if (mib_get_s(MIB_IPV6_LAN_LLA_IP_ADDR, (void *)tmpBuf, sizeof(tmpBuf)) != 0) {
		char cmdBuf[48];
		sprintf(cmdBuf, "%s/%d", tmpBuf, 64);
		va_cmd(IFCONFIG, 3, 1, LANIF, ARG_DEL, cmdBuf);
	}
	lanIPv6AddrStr = boaGetVar(wp, "lanIpv6addr", "");

	if(!lanIPv6AddrStr) {
		strcpy(tmpBuf, "不合法的LAN IPv6地址!"); //Invalid LAN IPv6 address!
		goto setErr_ipv6;
	}

	if ( !mib_set(MIB_IPV6_LAN_LLA_IP_ADDR, (void *)lanIPv6AddrStr)) {
		strcpy(tmpBuf, "LAN IPv6地址设定错误!"); //set LAN IPv6 address fail!
		goto setErr_ipv6;
	}

	sprintf(cmdBuf, "%s/%d", lanIPv6AddrStr, 64);
	va_cmd(IFCONFIG, 3, 1, LANIF, ARG_ADD, cmdBuf);

	if (!mib_get_s(MIB_LAN_DNSV6_MODE, (void *)&ipv6DnsMode, sizeof(ipv6DnsMode))) {
		strcpy(tmpBuf, "Error!! set LAN IPv6 DNS Mode fail!");
		goto setErr_ipv6;
	}

	sleep(3);
	/* only change RDNSS for default interface. exp:br0, Becauese we can't replace it for binding LAN interace.*/
	if (ipv6DnsMode == IPV6_DNS_HGWPROXY)
	{
		kickRAChangeRDNSS(lanIPv6AddrStr, (char *)BRIF);
		kickDHCPv6ChangeRDNSS(lanIPv6AddrStr, (char *)BRIF);
	}
	kickDNSRelayChangeOnTheFly();

setOk_ipv6:

#ifdef COMMIT_IMMEDIATELY
		Commit();
#endif

	submitUrl = boaGetVar(wp, "submit-url", "/");
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
	return;

setErr_ipv6:
	ERR_MSG(tmpBuf);
}


void formlanipv6dns(request * wp, char *path, char *query)
{
	char *str_extif,*submitUrl,*str_dns1,*str_dns2;
	static char tmpBuf[100];
	static char cmdBuf[100];
	char *lanIPv6DnsModeStr=NULL;
	unsigned char ipv6DnsMode=0, ipv6_radvd_rdnss_mode = 0;
	unsigned int ext_if;
	struct in6_addr dnsv61={0}, dnsv62={0}, dnsv63={0};

	lanIPv6DnsModeStr = boaGetVar(wp, "ipv6landnsmode", "");
	str_extif = boaGetVar(wp, "ext_if", "");

	if(!lanIPv6DnsModeStr) {
		strcpy(tmpBuf, "Error!! get web LAN IPv6 DNS Mode fail!");
		goto setErr_ipv6;
	}

	ipv6DnsMode = lanIPv6DnsModeStr[0]-'0';
	ipv6_radvd_rdnss_mode =  lanIPv6DnsModeStr[0]-'0';

	printf("%s  ipv6DnsMode = %d, ipv6_radvd_rdnss_mode = %d\n", __FUNCTION__, ipv6DnsMode, ipv6_radvd_rdnss_mode);

	if ( !mib_set(MIB_LAN_DNSV6_MODE, (void *)&ipv6DnsMode)) {
		strcpy(tmpBuf, "Error!! set LAN IPv6 DNS Mode fail!");
		goto setErr_ipv6;
	}

	if ( !mib_set(MIB_V6_RADVD_RDNSS_MODE, (void *)&ipv6_radvd_rdnss_mode)) {
		strcpy(tmpBuf, "Error!! set LAN IPv6 DNS Mode fail!");
		goto setErr_ipv6;
	}

	switch(ipv6DnsMode){
		case IPV6_DNS_HGWPROXY:
			break;
		case IPV6_DNS_WANCONN:
			if(str_extif[0])
				ext_if = (unsigned int)atoi(str_extif);
			else
			{
				ext_if = DUMMY_IFINDEX;  // No interface selected.
				printf("%s - %d DUMMY_IFINDEX\n", __FUNCTION__, __LINE__);
				strcpy(tmpBuf, "Error!! set LAN IPv6 DNS WANCONN mode wan ifindex is NULL!");
				goto setErr_ipv6;
			}
			printf("DNS WANConnect at 0x%x\n",ext_if);
			if ( !mib_set(MIB_DNSINFO_WANCONN, (void *)&ext_if)) {
				strcpy(tmpBuf, "Error!! set LAN IPv6 DNS WAN Conn fail!");
				goto setErr_ipv6;
			}

			if ( !mib_set(MIB_V6_RADVD_DNSINFO_WANCONN, (void *)&ext_if)) {
				strcpy(tmpBuf, "Error!! set LAN IPv6 RADVD RDNSS WAN Conn fail!");
				goto setErr_ipv6;
			}

			break;
		case IPV6_DNS_STATIC:
			memset(dnsv61.s6_addr, 0, 16);
			memset(dnsv62.s6_addr, 0, 16);

			str_dns1 = boaGetVar(wp, "Ipv6Dns1", "");
			if(str_dns1[0]) {
				if ( !inet_pton(PF_INET6, str_dns1, &dnsv61) ) {
					strcpy(tmpBuf, Tinvalid_DNS_address);
					goto setErr_ipv6;
				}
				if ( !mib_set(MIB_ADSL_WAN_DNSV61, (void *)&dnsv61)) {
	  				strcpy(tmpBuf, TDNS_mib_set_error);
					goto setErr_ipv6;
				}
				if ( !mib_set(MIB_V6_RDNSS1, (void *)str_dns1)) {
					strcpy(tmpBuf, TDNS_mib_set_error);
					goto setErr_ipv6;
				}
			}

			str_dns2 = boaGetVar(wp, "Ipv6Dns2", "");
			if(str_dns2[0]) {
				if ( !inet_pton(PF_INET6, str_dns2, &dnsv62) ) {
					strcpy(tmpBuf, Tinvalid_DNS_address);
					goto setErr_ipv6;
				}
				if ( !mib_set(MIB_ADSL_WAN_DNSV62, (void *)&dnsv62)) {
	  				strcpy(tmpBuf, TDNS_mib_set_error);
					goto setErr_ipv6;
				}
				if ( !mib_set(MIB_V6_RDNSS2, (void *)str_dns2)) {
					strcpy(tmpBuf, TDNS_mib_set_error);
					goto setErr_ipv6;
				}
			}

			break;
		default:
			break;
	}

setOk_ipv6:

#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif

	restartLanV6Server();

	submitUrl = boaGetVar(wp, "submit-url", "/");
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
	return;

setErr_ipv6:
	ERR_MSG(tmpBuf);
}

void formlanipv6prefix(request * wp, char *path, char *query)
{
	char *submitUrl, *str_extif;
	static char tmpBuf[100];
	char *lanIPv6PrefixStr=NULL,*lanIPv6PrefixModeStr=NULL;
	char *tok=NULL, *prefixStr=NULL, *saveptr1=NULL;
	char len=0;
	char lanIPv6PrefixMode = 0, lanIPv6_radvd_PrefixMode = 0;
	unsigned int ext_if;
	int i = 0;
	unsigned char pre_static_prefix_len[32] = {0}, pre_static_ipaddr[64] = {0}, value[64] = {0}, cmdBuf[128] = {0};
	struct in6_addr ip6Addr;
	unsigned char devAddr[MAC_ADDR_LEN];
	unsigned char meui64[8];
	char prefix_len[16] = {0};
	char *dst;
	char static_prefix_str[INET6_ADDRSTRLEN] = {0};
	char pre_static_prefix_str[INET6_ADDRSTRLEN] = {0};


	lanIPv6PrefixModeStr = boaGetVar(wp, "ipv6lanprefixmode", "");
	lanIPv6PrefixMode = lanIPv6PrefixModeStr[0]-'0';
	lanIPv6_radvd_PrefixMode  =  lanIPv6PrefixModeStr[0]-'0';
	printf("[%s] lanIPv6PrefixMode=%d , lanIPv6_radvd_PrefixMode=%d\n",__func__,lanIPv6PrefixMode, lanIPv6_radvd_PrefixMode);
	if ( !mib_set(MIB_PREFIXINFO_PREFIX_MODE, (void *)&lanIPv6PrefixMode)) {
		strcpy(tmpBuf, "LAN IPv6前缀模式设定错误!"); //set LAN IPv6 prefix mode fail!
		goto setErr_ipv6;
	}
	if ( !mib_set(MIB_V6_RADVD_PREFIX_MODE, (void *)&lanIPv6_radvd_PrefixMode)) {
		strcpy(tmpBuf, "LAN IPv6前缀模式设定错误!"); //set LAN IPv6 prefix mode fail!
		goto setErr_ipv6;
	}
	if ( !mib_set(MIB_PREFIXINFO_PREFIX_MODE, (void *)&lanIPv6_radvd_PrefixMode)) {
		strcpy(tmpBuf, "LAN IPv6前缀模式设定错误!"); //set LAN IPv6 prefix mode fail!
		goto setErr_ipv6;
	}
	//new radvd structure, so still need to set radvd static mib node
	if ((lanIPv6PrefixMode == RADVD_MODE_AUTO)|| (lanIPv6PrefixMode == RADVD_MODE_MANUAL))
	{
		if ( !mib_set(MIB_V6_RADVD_PREFIX_MODE, (void *)&lanIPv6PrefixMode)) {
			strcpy(tmpBuf, "LAN IPv6前缀模式设定错误!"); //set LAN IPv6 prefix mode fail!
			goto setErr_ipv6;
		}
	}

	//read and delete all static ipv6 address
	mib_get_s(MIB_V6_PREFIX_IP, (void *)pre_static_ipaddr, sizeof(pre_static_ipaddr));
	mib_get_s(MIB_V6_PREFIX_LEN, (void *)pre_static_prefix_len, sizeof(pre_static_prefix_len));

	//delete all ipv6 static address
	if(pre_static_ipaddr[0])
	{
		snprintf(pre_static_prefix_str, sizeof(pre_static_prefix_str), "%s/%s", pre_static_ipaddr, pre_static_prefix_len);	
		del_static_pd_route(pre_static_prefix_str, (char *)BRIF);

		inet_pton(AF_INET6, pre_static_ipaddr, &ip6Addr);
		mib_get_s(MIB_ELAN_MAC_ADDR, (void *)devAddr, sizeof(devAddr));
		mac_meui64(devAddr, meui64);
		for (i=0; i<8; i++)
			ip6Addr.s6_addr[i+8] = meui64[i];
		inet_ntop(PF_INET6, &ip6Addr, value, sizeof(value));
		sprintf(cmdBuf, "%s %s %s %s/%s", IFCONFIG, LANIF, ARG_DEL, value, pre_static_prefix_len);
		printf("%s del %s %s/%s IP\n", __FUNCTION__, LANIF, value, pre_static_prefix_len);
		system(cmdBuf);
	}

	switch(lanIPv6PrefixMode){
		case IPV6_PREFIX_DELEGATION:
			//MIB_PREFIXINFO_DELEGATED_WANCONN
			str_extif = boaGetVar(wp, "ext_if", "");
			if(str_extif[0])
				ext_if = (unsigned int)atoi(str_extif);
			else
				ext_if = DUMMY_IFINDEX;  // No interface selected.

			printf("Prefix is delegated WAN at %d\n",ext_if);
			if(!mib_set(MIB_PREFIXINFO_DELEGATED_WANCONN, (void *)&ext_if))
			{
				strcpy(tmpBuf, "Set PrefixInfo Delegated wanconn error!");
				goto setErr_ipv6;
			}
			if(!mib_set(MIB_V6_RADVD_DNSINFO_WANCONN, (void *)&ext_if))
			{
				strcpy(tmpBuf, "Set Radvd PrefixInfo Delegated wanconn error!");
				goto setErr_ipv6;
			}
			break;

		case IPV6_PREFIX_STATIC:
			lanIPv6PrefixStr = boaGetVar(wp, "lanIpv6prefix", "");

			if(!lanIPv6PrefixStr) {
				strcpy(tmpBuf, "不合法的LAN IPv6前缀!"); //Invalid LAN IPv6 Prefix!
				goto setErr_ipv6;
			}

			//Prefix will be like 2001:2222::/64 form
			prefixStr = strtok_r(lanIPv6PrefixStr,"/",&saveptr1);
			tok = saveptr1;
			if(tok && *tok)
			{
				snprintf(prefix_len, sizeof(prefix_len), "%s", tok);
				len = atoi(tok);
			}
			if(!prefixStr) {
				strcpy(tmpBuf, "不合法的LAN IPv6前缀!"); //Invalid LAN IPv6 Prefix!
				goto setErr_ipv6;
			}

			if((len>64) || (len<48) ) {
				strcpy(tmpBuf, "不合法的LAN IPv6前缀长度!"); //Invalid LAN IPv6 Prefix Len!
				goto setErr_ipv6;
			}

			if ( !mib_set(MIB_IPV6_LAN_PREFIX, (void *)prefixStr)) {
				strcpy(tmpBuf, "LAN IPv6前缀设定错误!"); //set LAN IPv6 prefix fail!
				goto setErr_ipv6;
			}

			if ( !mib_set(MIB_IPV6_LAN_PREFIX_LEN, (void *)&len )) {
				strcpy(tmpBuf, "LAN IPv6前缀长度设定错误!"); //set LAN IPv6 prefix length fail!
				goto setErr_ipv6;
			}
			//new radvd structure, so still need to set radvd static mib node
			if ( !mib_set(MIB_V6_PREFIX_IP, (void *)prefixStr)) {
				strcpy(tmpBuf, "LAN IPv6前缀设定错误!"); //set LAN IPv6 prefix fail!
				goto setErr_ipv6;
			}

			if ( !mib_set(MIB_V6_PREFIX_LEN, (void *)prefix_len )) {
				strcpy(tmpBuf, "LAN IPv6前缀长度设定错误!"); //set LAN IPv6 prefix length fail!
				goto setErr_ipv6;
			}
			/* Now we only have br0 for LAN bridge. Add static pd route for default wan interface policy route. */
			snprintf(static_prefix_str, sizeof(static_prefix_str), "%s/%d", prefixStr, len);
			add_static_pd_route_for_default_waninf(static_prefix_str, (char *)BRIF);

			break;
	}

setOk_ipv6:

#ifdef COMMIT_IMMEDIATELY
		Commit();
#endif

	restartLanV6Server(); // only restart default dhcpv6 server and full radvd. no binding dhcpv6 server.

	submitUrl = boaGetVar(wp, "submit-url", "/");
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
	return;

setErr_ipv6:
	ERR_MSG(tmpBuf);
}

#ifdef CONFIG_CMCC_ENTERPRISE
void formdhcpv6_cmcc_ent(request * wp, char *path, char *query)
{
	char *submitUrl;
	static char tmpBuf[100];
	static char cmdBuf[100];
	char *lanIPv6AddrStr=NULL;
	char *str_extif=NULL;
	char *lanIPv6PrefixStr=NULL,*lanIPv6PrefixLenStr=NULL,*lanIPv6PrefixModeStr=NULL;
	char *prfixPTimeStr=NULL,*prefixVTimeStr=NULL;
	unsigned char PrefixLen=0;
	char lanIPv6PrefixMode;
	unsigned int prefix_ext_if;
	char *radvdModeStr=NULL;
	unsigned char radvdMode=0;
	char *radvdMFlagStr=NULL,*radvdOFlagStr=NULL;
	unsigned char radvdMFlag=0,radvdOFlag=1, autonomousMode=0;
	char *radvdMaxINtervalStr=NULL,*radvdMinINtervalStr=NULL;
	char *dhcpv6ModeStr=NULL, *dhcpv6StartAddr=NULL, *dhcpv6EndAddr=NULL;
	unsigned char dhcpv6Mode = 0;
	char *lanIPv6DnsModeStr=NULL;
	unsigned char ipv6DnsMode=0;
	unsigned int dns_ext_if;
	char *str_dns1=NULL,*str_dns2=NULL;
	struct in6_addr dnsv61, dnsv62, dnsv63;
	char lanDhcpv6Addr[64]={0};
	struct in6_addr ip6Addr_start = {0}, ip6Addr_end = {0};

	if (mib_get(MIB_IPV6_LAN_LLA_IP_ADDR, (void *)tmpBuf) != 0) {
		char cmdBuf[48];
		sprintf(cmdBuf, "%s/%d", tmpBuf, 64);
		va_cmd(IFCONFIG, 3, 1, LANIF, ARG_DEL, cmdBuf);
	}
	lanIPv6AddrStr = boaGetVar(wp, "ipv6linkaddr", "");

	if(!lanIPv6AddrStr) {
		strcpy(tmpBuf, "不合法的LAN IPv6地址!"); //Invalid LAN IPv6 address!
		goto setErr_ipv6;
	}

	if ( !mib_set(MIB_IPV6_LAN_LLA_IP_ADDR, (void *)lanIPv6AddrStr)) {
		strcpy(tmpBuf, "LAN IPv6地址设定错误!"); //set LAN IPv6 address fail!
		goto setErr_ipv6;
	}

	sprintf(cmdBuf, "%s/%d", lanIPv6AddrStr, 64);
	va_cmd(IFCONFIG, 3, 1, LANIF, ARG_ADD, cmdBuf);
//prefix
	lanIPv6PrefixModeStr = boaGetVar(wp, "per_pd_prefix_sel", "");
	lanIPv6PrefixMode = lanIPv6PrefixModeStr[0]-'0';
	printf("[%s] lanIPv6PrefixMode=%d\n",__func__,lanIPv6PrefixMode);
	if ( !mib_set(MIB_V6_RADVD_PREFIX_MODE, (void *)&lanIPv6PrefixMode)) {
		strcpy(tmpBuf, "LAN IPv6前缀模式设定错误!"); //set LAN IPv6 prefix mode fail!
		goto setErr_ipv6;
	}

	switch(lanIPv6PrefixMode){
		case IPV6_PREFIX_DELEGATION:
			//MIB_PREFIXINFO_DELEGATED_WANCONN
			str_extif = boaGetVar(wp, "wan_conlist", "");
			if(str_extif[0])
				prefix_ext_if = (unsigned int)atoi(str_extif);
			else
				prefix_ext_if = DUMMY_IFINDEX;  // No interface selected.

			printf("Prefix is delegated WAN at %d\n",prefix_ext_if);
			if(!mib_set(MIB_PREFIXINFO_DELEGATED_WANCONN, (void *)&prefix_ext_if))
			{
				strcpy(tmpBuf, "Set PrefixInfo Delegated wanconn error!");
				goto setErr_ipv6;
			}
			break;

		case IPV6_PREFIX_STATIC:
			lanIPv6PrefixStr = boaGetVar(wp, "prefix", "");
			lanIPv6PrefixLenStr = boaGetVar(wp, "prefix_len", "");
			//printf("lanIPv6PrefixLenStr=%s\n",lanIPv6PrefixLenStr);
			prfixPTimeStr=boaGetVar(wp, "preferred_lifetime", "");
			prefixVTimeStr=boaGetVar(wp, "valid_lifetime", "");
			PrefixLen = atoi(lanIPv6PrefixLenStr);
			if(!lanIPv6PrefixStr) {
				strcpy(tmpBuf, "不合法的LAN IPv6前缀!"); //Invalid LAN IPv6 Prefix!
				goto setErr_ipv6;
			}

			if((PrefixLen>64) || (PrefixLen<48) ) {
				strcpy(tmpBuf, "不合法的LAN IPv6前缀长度!"); //Invalid LAN IPv6 Prefix Len!
				goto setErr_ipv6;
			}

			if ( !mib_set(MIB_V6_PREFIX_IP, (void *)lanIPv6PrefixStr)) {
				strcpy(tmpBuf, "LAN IPv6前缀(MIB_V6_PREFIX_IP)设定错误!"); //set LAN IPv6 prefix fail!
				goto setErr_ipv6;
			}

			if ( !mib_set(MIB_V6_PREFIX_LEN, (void *)lanIPv6PrefixLenStr )) {
				strcpy(tmpBuf, "LAN IPv6前缀长度(MIB_V6_PREFIX_LEN)设定错误!"); //set LAN IPv6 prefix length fail!
				goto setErr_ipv6;
			}
			if (!mib_set(MIB_IPV6_LAN_PREFIX, (void *)lanIPv6PrefixStr)) { 
				strcpy(tmpBuf, "LAN IPv6前缀(MIB_IPV6_LAN_PREFIX)设定错误!"); //set LAN IPv6 prefix fail!
				goto setErr_ipv6;
			}

			if (!mib_set(MIB_IPV6_LAN_PREFIX_LEN, (void *)&PrefixLen)) {
				strcpy(tmpBuf, "LAN IPv6前缀长度(MIB_IPV6_LAN_PREFIX_LEN)设定错误!"); //set LAN IPv6 prefix length fail!
				goto setErr_ipv6;
			}
			if ( !mib_set(MIB_V6_VALIDLIFETIME, (void *)prefixVTimeStr)) {
				strcpy(tmpBuf, "LAN IPv6前缀有效生命期设定错误!"); //Set ULA prefix valid time mib error!
				goto setErr_ipv6;
			}

			if ( !mib_set(MIB_V6_PREFERREDLIFETIME, (void *)prfixPTimeStr)) {
				strcpy(tmpBuf, "LAN IPv6前缀首选生命期设定错误!"); //Set ULA prefix prefered time mib error!
				goto setErr_ipv6;
			}

			break;
			}
//radvd
	radvdModeStr =	boaGetVar(wp, "radvdvalue", "");
	radvdMode = radvdModeStr[0]-'0';
	//printf("radvdMode=%u\n",radvdMode);
	if ( !mib_set(MIB_V6_RADVD_ENABLE, (void *)&radvdMode)) {
		strcpy(tmpBuf, "Error!! set LAN IPv6 RADVD Mode fail!");
		goto setErr_ipv6;
	}
	if(radvdMode){
		radvdMFlagStr = boaGetVar(wp, "managed_flag_value", "");
		radvdOFlagStr = boaGetVar(wp, "other_flag_value", "");
		radvdMFlag = radvdMFlagStr[0]-'0';
		radvdOFlag = radvdOFlagStr[0]-'0';
		//printf("radvdMFlagStr=%s,radvdOFlagStr=%s,radvdMFlag=%d,radvdOFlag=%d",radvdMFlagStr,radvdOFlagStr,radvdMFlag,radvdOFlag);
		radvdMaxINtervalStr = boaGetVar(wp, "ra_max_interval_time", "");
		radvdMinINtervalStr = boaGetVar(wp, "ra_min_interval_time", "");
		if( !mib_set( MIB_V6_MANAGEDFLAG, (void *)&radvdMFlag)) {
			strcpy(tmpBuf, "RADVD M标志位设定错误!"); //Set ULA prefix prefered time mib error!
			goto setErr_ipv6;
		}
		if (radvdMFlag)
			autonomousMode = 0;
		else
			autonomousMode = 1;
               if( !mib_set( MIB_V6_AUTONOMOUS, (void *)&autonomousMode)) {
                        strcpy(tmpBuf, "RADVD M标志位设定错误!"); //Set ULA prefix prefered time mib error!^M
                        goto setErr_ipv6;
                }
		if( !mib_set( MIB_V6_OTHERCONFIGFLAG, (void *)&radvdOFlag)) {
			strcpy(tmpBuf, "RADVD O标志位设定错误!"); //Set ULA prefix prefered time mib error!
			goto setErr_ipv6;
		}
		if ( !mib_set(MIB_V6_MAXRTRADVINTERVAL, (void *)radvdMaxINtervalStr)) {
			strcpy(tmpBuf, "RA周期最大值设定错误!"); //Set ULA prefix prefered time mib error!
			goto setErr_ipv6;
			}
		if ( !mib_set(MIB_V6_MINRTRADVINTERVAL, (void *)radvdMinINtervalStr)) {
			strcpy(tmpBuf, "RA周期最小值设定错误!"); //Set ULA prefix prefered time mib error!
			goto setErr_ipv6;
			}
	}
//dhcpv6
	dhcpv6ModeStr=boaGetVar(wp, "Dhcp6svalue", "");
	dhcpv6Mode = dhcpv6ModeStr[0]-'0';
	//printf("dhcpv6Mode=%u\n",dhcpv6Mode);
	if ( !mib_set(MIB_DHCPV6_MODE, (void *)&dhcpv6Mode)) {
		strcpy(tmpBuf, "Error!! set LAN DHCPV6 Mode fail!");
		goto setErr_ipv6;
	}

	if(dhcpv6Mode){
		dhcpv6StartAddr= boaGetVar(wp, "Dhcp6s_minaddr", "");
		dhcpv6EndAddr=boaGetVar(wp, "Dhcp6s_maxaddr", "");
		if(dhcpv6StartAddr)
			printf("dhcpv6StartAddr=%s\n",dhcpv6StartAddr);
		if(dhcpv6EndAddr)
			printf("dhcpv6EndAddr=%s\n",dhcpv6EndAddr);
		if ( !mib_set(MIB_DHCPV6S_MIN_ADDRESS, (void *)dhcpv6StartAddr)) {
			strcpy(tmpBuf, "Error!! set LAN DHCPV6 Start Address fail!");
			goto setErr_ipv6;
		 }
		if ( !mib_set(MIB_DHCPV6S_MAX_ADDRESS, (void *)dhcpv6EndAddr)) {
			strcpy(tmpBuf, "Error!! set LAN DHCPV6 Start Address fail!");
			goto setErr_ipv6;
		 }
		if (lanIPv6PrefixMode == 	IPV6_PREFIX_STATIC) {
			memset(&ip6Addr_start, 0, sizeof(struct in6_addr));
			memset(&ip6Addr_end, 0, sizeof(struct in6_addr));
			printf("lanIPv6PrefixStr=%s\n",lanIPv6PrefixStr);
			sprintf(lanDhcpv6Addr, "%s%s", lanIPv6PrefixStr, dhcpv6StartAddr);
			printf("dhcpv6StartAddr=%s\n",lanDhcpv6Addr);
			if (!inet_pton(PF_INET6, lanDhcpv6Addr, &ip6Addr_start)) {
				goto setErr_ipv6;
			}
			sprintf(lanDhcpv6Addr, "%s%s", lanIPv6PrefixStr, dhcpv6EndAddr);
			printf("dhcpv6EndAddr=%s\n",lanDhcpv6Addr);
			if (!inet_pton(PF_INET6, lanDhcpv6Addr, &ip6Addr_end)) {
				goto setErr_ipv6;
			}

			if ( !mib_set(MIB_DHCPV6S_RANGE_START, (void *)&ip6Addr_start)) {
				strcpy(tmpBuf, "Error!! set LAN DHCPV6 Start Address fail!");
				goto setErr_ipv6;
			}
			if ( !mib_set(MIB_DHCPV6S_RANGE_END, (void *)&ip6Addr_end)) {
				strcpy(tmpBuf, "Error!! set LAN DHCPV6 End Address fail!");
				goto setErr_ipv6;
			}
		}
	}

//DNS
	lanIPv6DnsModeStr = boaGetVar(wp, "dnsv6_type_sel", "");
	str_extif = boaGetVar(wp, "wan_dns_conlist", "");

	if(!lanIPv6DnsModeStr) {
		goto setErr_ipv6;
	}

	ipv6DnsMode = lanIPv6DnsModeStr[0]-'0';
	//printf("ipv6DnsMode=%u\n",ipv6DnsMode);
	if ( !mib_set(MIB_LAN_DNSV6_MODE, (void *)&ipv6DnsMode)) {
		strcpy(tmpBuf, "Error!! set LAN IPv6 DNS Mode fail!");
		goto setErr_ipv6;
	}
	switch(ipv6DnsMode){
		case IPV6_DNS_HGWPROXY:
			break;
		case IPV6_DNS_WANCONN:
			if(str_extif[0])
				dns_ext_if = (unsigned int)atoi(str_extif);
			else
				dns_ext_if = DUMMY_IFINDEX;  // No interface selected.

			printf("DNS WANConnect at 0x%x\n",dns_ext_if);
			if ( !mib_set(MIB_DNSINFO_WANCONN, (void *)&dns_ext_if)) {
				strcpy(tmpBuf, "Error!! set LAN IPv6 DNS WAN Conn fail!");
				goto setErr_ipv6;
			}

			break;
		case IPV6_DNS_STATIC:
			memset(dnsv61.s6_addr, 0, 16);
			memset(dnsv62.s6_addr, 0, 16);
			str_dns1 = boaGetVar(wp, "primary_dns", "");
			if(str_dns1) {
				if ( !inet_pton(PF_INET6, str_dns1, &dnsv61) ) {
					strcpy(tmpBuf, Tinvalid_DNS_address);
					goto setErr_ipv6;
				}
				if ( !mib_set(MIB_ADSL_WAN_DNSV61, (void *)&dnsv61)) {
					strcpy(tmpBuf, TDNS_mib_set_error);
					goto setErr_ipv6;
				}
			}

			str_dns2 = boaGetVar(wp, "secondary_dns", "");
			if(str_dns2) {
				if ( !inet_pton(PF_INET6, str_dns2, &dnsv62) ) {
					strcpy(tmpBuf, Tinvalid_DNS_address);
					goto setErr_ipv6;
				}
				if ( !mib_set(MIB_ADSL_WAN_DNSV62, (void *)&dnsv62)) {
					strcpy(tmpBuf, TDNS_mib_set_error);
					goto setErr_ipv6;
				}
			}

			break;
		default:
			break;
	}
	if ( !mib_set(MIB_DHCPV6S_TYPE, (void *)&lanIPv6PrefixMode)) {
		strcpy(tmpBuf, "Error!! set LAN DHCPV6 Mode fail!");
		goto setErr_ipv6;
	}
setOk_ipv6:
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif

	kickRAChangeRDNSS(lanIPv6AddrStr, (char *)BRIF);
	kickDHCPv6ChangeRDNSS(lanIPv6AddrStr, (char *)BRIF);
	kickDNSRelayChangeOnTheFly();
	restartLanV6Server();
	submitUrl = boaGetVar(wp, "submit-url", "/");
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
	return;

setErr_ipv6:
	ERR_MSG(tmpBuf);
}


#endif

#endif  //#ifdef CONFIG_IPV6

