/*-- System inlcude files --*/
#include <string.h>
#include <sys/socket.h>
#include <linux/if.h>
#include <signal.h>
/*-- Local inlcude files --*/
#include "../webs.h"
#include "webform.h"
#include "mib.h"
#include "utility.h"
#include "fmdefs.h"   

// Mason Yu. MLD Proxy
#ifdef CONFIG_IPV6
#ifdef CONFIG_USER_MLDPROXY
#ifndef CONFIG_RTK_DEV_AP
///////////////////////////////////////////////////////////////////
void formMLDProxy(request * wp, char *path, char *query)
{
	char	*str_enb, *str_extif, *submitUrl;
	char tmpBuf[100];
	FILE *fp;
	char * argv[8];
	char ifname[6];
#ifndef NO_ACTION
	int pid;
#endif
	unsigned char is_enabled, pre_enabled;
	unsigned int ext_if, pre_ext_if;
#ifdef EMBED
	unsigned char if_num;
	int igmp_pid;
#endif

	str_enb = boaGetVar(wp, "daemon", "");
	str_extif = boaGetVar(wp, "ext_if", "");

	if(str_enb[0])
	{
		if (str_enb[0] == '0')
			is_enabled = 0;
		else
			is_enabled = 1;

		if(str_extif[0])
			ext_if = (unsigned int)atoi(str_extif);
		else
			ext_if = DUMMY_IFINDEX;  // No interface selected.

		if(!mib_set(MIB_MLD_PROXY_DAEMON, (void *)&is_enabled))
		{
			strcpy(tmpBuf, "Set UPNP error!");
			goto setErr_igmp;
		}

		if(is_enabled)
		{
			if(!mib_set(MIB_MLD_PROXY_EXT_ITF, (void *)&ext_if))
			{
				printf("Set UPNP Binded WAN interface index error(1)\n");
				strcpy(tmpBuf, "UPNP Binded WAN interface index 设定错误!");  //Set UPNP Binded WAN interface index error!
				goto setErr_igmp;
			}
		}
	}

	startMLDproxy();

// Magician: Commit immediately
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif

#ifndef NO_ACTION
	pid = fork();
	if (pid)
		waitpid(pid, NULL, 0);
	else if (pid == 0)
	{
		snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _CONFIG_SCRIPT_PROG);
#ifdef HOME_GATEWAY
		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "gw", "bridge", NULL);
#else
		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "ap", "bridge", NULL);
#endif
		exit(1);
	}
#endif

	submitUrl = boaGetVar(wp, "submit-url", "");
	//OK_MSG(submitUrl);
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
	return;

setErr_igmp:
	ERR_MSG(tmpBuf);
}

#else

int mldproxyList(int eid, request * wp, int argc, char ** argv)
{
	struct mldproxy_entry	entry ;
	int				cnt = 2;
	int				index = 0;
	int				lineno = __LINE__;

    unsigned int entryNum, i;
		
	MIB_CE_ATM_VC_T Entry;
	char wanname[MAX_WAN_NAME_LEN];
	unsigned char mldProxy;

	mib_get_s(MIB_MLD_PROXY_DAEMON, &mldProxy, sizeof(mldProxy));
	_PUT_BOOL(mldProxy);


	entryNum = mib_chain_total(MIB_ATM_VC_TBL);
	for (i=0; i<entryNum; i++) 
	{
		if (!mib_chain_get(MIB_ATM_VC_TBL, i, (void *)&Entry))
		{
  			boaError(wp, 400, "Get chain record error!\n");
			return -1;
		}
		
		if (Entry.enable == 0)
			continue;
		if(((Entry.cmode == CHANNEL_MODE_IPOE||Entry.cmode == CHANNEL_MODE_PPPOA||Entry.cmode == CHANNEL_MODE_PPPOE||Entry.cmode == CHANNEL_MODE_RT1483))
        )
		{
			if(Entry.IpProtocol & IPVER_IPV6){
			memset(&entry, 0, sizeof(struct mldproxy_entry));
			memset(wanname, 0, sizeof(wanname));
			getWanName(&Entry, wanname);
			strcpy(entry.ifName,wanname);
			entry.enable= Entry.enableMLD;     
                       
			boaWrite(wp, "push(new it_nr(\"%d\"" _PTS _PTI "));\n", 
			entryNum, _PME(ifName), _PME(enable));
			}
		}	
		
	}
		
check_err:
	_TRACE_LEAVEL;
	return 0;
}

///////////////////////////////////////////////////////////////////
void formMLDProxy (request * wp, char *path, char *query)
{
	struct mldproxy_entry	entry;
	char*			str_enb;
	int				index = 0;
	int				lineno = __LINE__;
	unsigned int entryNum, i;
	MIB_CE_ATM_VC_T Entry;
	char wanname[MAX_WAN_NAME_LEN];
	unsigned char is_enabled;
	
	_BC_USE;
	
	_TRACE_CALL;

	str_enb = boaGetVar(wp, "mldProxy", "");
	if(str_enb[0])
	{
		if (!strcmp((const char*)str_enb, "on"))
			is_enabled = 1;
		else
			is_enabled = 0;

		mib_set(MIB_MLD_PROXY_DAEMON, (void *)&is_enabled);
	}

	_BC_INIT("bcdata");

	while(_BC_NEXT())
	{
			printf("%s:%d \n",__FUNCTION__,__LINE__);	
		memset(&entry, 0, sizeof(struct mldproxy_entry));
		_BC_ENTRY_STR(ifName, _BC_NEED);
		_BC_ENTRY_INT(enable, _BC_NEED);
		if(entry.enable > 1){lineno = __LINE__; continue;}

		/************Place your code here, do what you want to do! ************/
		/************Place your code here, do what you want to do! ************/
		entryNum = mib_chain_total(MIB_ATM_VC_TBL);
		for (i=0; i<entryNum; i++) 
		{
			printf("%s:%d ,i =%d\n",__FUNCTION__,__LINE__,i);	
			if (!mib_chain_get(MIB_ATM_VC_TBL, i, (void *)&Entry))
			{
				boaError(wp, 400, "读取chain record错误!\n"); //Get chain record error!
				_BC_FREE();
				return;
			}
			getWanName(&Entry, wanname);
			
			if(!strcmp(entry.ifName,wanname)){
				if(entry.enable)
					Entry.enableMLD =1;
				else 
					Entry.enableMLD =0;

				mib_chain_update(MIB_ATM_VC_TBL, (void *)&Entry,i);
				break;
			}	 		
		 }			
	}

#ifdef CONFIG_MLDPROXY_MULTIWAN
	startMLDproxy();
#endif

// Magician: Commit immediately
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif	 
	
	_COND_REDIRECT;
check_err:
	_BC_FREE();
	_TRACE_LEAVEL;
	return;
}

#endif
#endif





// Mason Yu. MLD snooping for e8b
void formMLDSnooping(request * wp, char *path, char *query)
{
	char	*str, *submitUrl, *strSnoop;
	char tmpBuf[100], mode;
#ifndef NO_ACTION
	int pid;
#endif

#if defined(CONFIG_RTL_MLD_SNOOPING)
	char origmode = 0;
	strSnoop = boaGetVar(wp, "snoop", "");
	if ( strSnoop[0] ) {
		// bitmap for virtual lan port function
		// Port Mapping: bit-0
		// QoS : bit-1
		// IGMP snooping: bit-2
		// MLD snooping: bit-3
		mib_get_s(MIB_MPMODE, (void *)&mode, sizeof(mode));
		origmode = mode;
		strSnoop = boaGetVar(wp, "snoop", "");
		if ( strSnoop[0] == '1' ) {
			mode |= MP_MLD_MASK;
			//if(origmode != mode)
			//	igmp_changed_flag = 1;
			// take effect immediately
		}
		else {
			mode &= ~MP_MLD_MASK;
			//if(origmode != mode)
			//	igmp_changed_flag = 1;
		}
		mib_set(MIB_MPMODE, (void *)&mode);
		__dev_setupMLDSnoop((mode & MP_MLD_MASK)?1:0);

#if defined(CONFIG_USER_MLDPROXY_HANDLE_MCFLOW)
		int mldproxy_pid=0;
		mldproxy_pid = read_pid((char *) MLDPROXY_PID);
		if (mldproxy_pid>0)
			kill(mldproxy_pid, SIGHUP);
#endif

	}
#endif

#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif

	submitUrl = boaGetVar(wp, "submit-url", "");
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
	return;
}
#endif
#ifdef CONFIG_CMCC_ENTERPRISE
int MLDProxyList(int eid, request * wp, int argc, char ** argv)
{
	struct mldproxy_entry entry ;
	unsigned char is_enabled;
	unsigned int entryNum, i;
	unsigned int ext_if;
	MIB_CE_ATM_VC_T Entry;
	char wanname[MAX_WAN_NAME_LEN];
	unsigned char igmp_proxy;
	_TRACE_CALL;
	mib_get(MIB_MLD_PROXY_DAEMON, (void *)&is_enabled);
	mib_get(MIB_MLD_PROXY_EXT_ITF, (void *)&ext_if);

	if(!is_enabled)
		ext_if = DUMMY_IFINDEX;

	entryNum = mib_chain_total(MIB_ATM_VC_TBL);
	for (i=0; i<entryNum; i++)
	{
		if (!mib_chain_get(MIB_ATM_VC_TBL, i, (void *)&Entry))
		{
			boaError(wp, 400, "Get chain record error!\n");
			return -1;
		}
		if (Entry.enable == 0)
			continue;
		if(((Entry.cmode == CHANNEL_MODE_IPOE||Entry.cmode == CHANNEL_MODE_PPPOA||Entry.cmode == CHANNEL_MODE_PPPOE||Entry.cmode == CHANNEL_MODE_RT1483)))
		{
			if(Entry.IpProtocol & IPVER_IPV6){
				memset(&entry, 0, sizeof(struct igmproxy_entry));
				memset(wanname, 0, sizeof(wanname));
				getWanName(&Entry, wanname);
				strcpy(entry.ifName,wanname);
				entry.ifidx = Entry.ifIndex;
				if(Entry.ifIndex == ext_if)
					entry.enable= 1;
				else
					entry.enable=0;
				boaWrite(wp, "push(new it_nr(\"%d\"" _PTS _PTI _PTI"));\n", entryNum, _PME(ifName), _PME(enable), _PME(ifidx));
			}
		}
	}
check_err:
	_TRACE_LEAVEL;
	return 0;
}

void mld_Form(request * wp, char *path, char *query)
{
	char	*str, *submitUrl, *strSnoop;
	char tmpBuf[100], mode;
#ifndef NO_ACTION
	int pid;
#endif

#if defined(CONFIG_RTL_IGMP_SNOOPING)
	char origmode = 0;
	strSnoop = boaGetVar(wp, "MLDsnooping", "");
	// bitmap for virtual lan port function
	// Port Mapping: bit-0
	// QoS : bit-1
	// IGMP snooping: bit-2
	// MLD snooping: bit-3
	mib_get(MIB_MPMODE, (void *)&mode);
	origmode = mode;
	if ( strSnoop[0] ) {
		mode |= 0x08;
		//if(origmode != mode)
		//	igmp_changed_flag = 1;
		// take effect immediately
#if defined(CONFIG_RTL_MLD_SNOOPING)
		__dev_setupMLDSnoop(1);
#endif
	}
	else {
		mode &= 0xf7;
		//if(origmode != mode)
		//	igmp_changed_flag = 1;
#if defined(CONFIG_RTL_MLD_SNOOPING)
		__dev_setupMLDSnoop(0);
#endif
	}
	mib_set(MIB_MPMODE, (void *)&mode);
#endif
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif
	submitUrl = boaGetVar(wp, "submit-url", "");
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
	return;
}
void mld_proxy_Form(request * wp, char *path, char *query)
{
	char	*str_enb, *str_extif, *submitUrl;
	char tmpBuf[100];
	FILE *fp;
	char * argv[8];
	char ifname[6];
#ifndef NO_ACTION
	int pid;
#endif
	unsigned char is_enabled, pre_enabled;
	unsigned int ext_if, pre_ext_if;
#ifdef EMBED
	unsigned char if_num;
	int igmp_pid;
#endif

	str_extif = boaGetVar(wp, "checkedIdx", "");
	ext_if = (unsigned int)atoi(str_extif);

	if(str_extif[0])
	{
		if (ext_if == DUMMY_IFINDEX)
			is_enabled = 0;
		else
			is_enabled = 1;

		if(!mib_set(MIB_MLD_PROXY_DAEMON, (void *)&is_enabled))
		{
			strcpy(tmpBuf, "Set UPNP error!");
			goto setErr_igmp;
		}

		if(is_enabled)
		{
			if(!mib_set(MIB_MLD_PROXY_EXT_ITF, (void *)&ext_if))
			{
				printf("Set UPNP Binded WAN interface index error(1)\n");
				strcpy(tmpBuf, "UPNP Binded WAN interface index 趨!");  //Set UPNP Binded WAN interface index error!
				goto setErr_igmp;
			}
		}
	}

	startMLDproxy();

// Magician: Commit immediately
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif

	submitUrl = boaGetVar(wp, "submit-url", "");
	//OK_MSG(submitUrl);
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
	return;

setErr_igmp:
	ERR_MSG(tmpBuf);
}

#endif
