#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "../webs.h"
#include "mib.h"
#include "webform.h"
#include "utility.h"
#include "../subr_multiap.h"

void formMultiAP(request *wp, char *path, char *query)
{
	char *submitUrl, *strVal;
	MIB_CE_MBSSIB_T Entry;
#ifdef WLAN_DUALBAND_CONCURRENT
	int orig_wlan_idx = wlan_idx;
#endif
#ifdef CONFIG_USER_DHCPCLIENT_MODE
	unsigned char value[64] = {0};
	int dhcpc_pid = -1;
	unsigned char orig_dhcp_mode = 0;
#endif
	unsigned char dhcp_mode = 0;
#ifdef CONFIG_AUTO_DHCP_CHECK
	const char AUTO_DHCPPID[] = "/var/run/auto_dhcp.pid";
#endif
	char opmode=0;

	//Check if it is push button press, trigger push button then return.
	strVal    = boaGetVar(wp, "start_wsc", "");
	if (strVal[0]) {
#ifdef CONFIG_USER_CTCAPD
		system("ubus send \"propertieschanged\" \'{\"wpsswitch\":\"on\"}\'");
#endif
#ifdef WLAN_WPS_HAPD
		system("echo 2 > /tmp/virtual_push_button");
#else
		system("echo 1 > /tmp/virtual_push_button");
#endif
		submitUrl = boaGetVar(wp, "submit-url", "");
		boaRedirect(wp, submitUrl);
		return;
	}
#ifdef CONFIG_USER_DHCPCLIENT_MODE
	mib_get_s( MIB_DHCP_MODE, (void *)&orig_dhcp_mode, sizeof(orig_dhcp_mode));
	dhcp_mode = orig_dhcp_mode;
#endif

#ifdef CONFIG_USER_RTK_BRIDGE_MODE
	mib_get_s(MIB_OP_MODE, (void *)&opmode, sizeof(opmode));
#endif

	int i, j;
	// Enable dot11kv if not already enabled
	unsigned char mibVal = 1;
	strVal     = boaGetVar(wp, "needEnable11kv", "");
	if (!strcmp(strVal, "1")) {
		for (i = 0; i < NUM_WLAN_INTERFACE; i++) {
			for (j = 0; j <= NUM_VWLAN_INTERFACE; j++) {
				mib_chain_local_mapping_get(MIB_MBSSIB_TBL, i, j, (void *)&Entry);
#ifdef WLAN_11K
				Entry.rm_activated = mibVal;
#endif
#ifdef WLAN_11V
				Entry.BssTransEnable = mibVal;
#endif
				mib_chain_local_mapping_update(MIB_MBSSIB_TBL, i, (void *)&Entry, j);
			}
		}
	}

	char *device_name = boaGetVar(wp, "device_name_text", "");
	mib_set(MIB_MAP_DEVICE_NAME, (void *)device_name);

	// mibVal = 1;
	// apmib_set(MIB_STP_ENABLED, (void *)&mibVal);

	char *role_prev = boaGetVar(wp, "role_prev", "");

	char *controller_backhaul_link = boaGetVar(wp, "controller_backhaul_radio", "");
	char *agent_backhaul_link = boaGetVar(wp, "agent_backhaul_radio", "");

	// Read role info from form and set to mib accordingly
	strVal = boaGetVar(wp, "role", "");
	mibVal = 0;
	if (!strcmp(strVal, "controller")) {
#if defined(MAP_DYNAMIC_BACKHAUL_BSS_IF)
		if(setupMultiAPController(strVal, role_prev, controller_backhaul_link, &dhcp_mode) == -1)
		{
#ifdef WLAN_DUALBAND_CONCURRENT
			wlan_idx = orig_wlan_idx;
#endif
			ERR_MSG("MAP: Dynamic Backhaul BSS is enabled and NO avaliable interface for EasyMesh Backhaul BSS!");
			return;
		}
#else
		setupMultiAPController(strVal, role_prev, controller_backhaul_link, &dhcp_mode);
#endif
	} else if (!strcmp(strVal, "agent")) {
		setupMultiAPAgent(strVal, role_prev, agent_backhaul_link, &dhcp_mode);
			}
#if defined(WLAN_MULTI_AP_ROLE_AUTO_SELECT)
	else if(!strcmp(strVal, "auto")){
		setupMultiAPAuto(strVal, role_prev, agent_backhaul_link, &dhcp_mode);
		}
#endif
	else if (!strcmp(strVal, "disabled")) {
		setupMultiAPDisabled();
		}

#ifdef CONFIG_AUTO_DHCP_CHECK
	kill_by_pidfile_new((const char*)AUTO_DHCPPID, SIGTERM);
#endif

#ifdef CONFIG_USER_DHCPCLIENT_MODE
	if(orig_dhcp_mode != dhcp_mode){
		if(orig_dhcp_mode == DHCPV4_LAN_CLIENT){
			snprintf(value, 64, "%s.%s", (char*)DHCPC_PID, ALIASNAME_BR0);
			dhcpc_pid = read_pid((char*)value);
			if (dhcpc_pid > 0)
				kill(dhcpc_pid, SIGTERM);
		}

		if( dhcp_mode == DHCPV4_LAN_CLIENT ){
			setupDHCPClient();
		}else{
			/* recover LAN IP address */
			restart_lanip();
		}
		restart_dhcp();
	}
#endif

#ifdef CONFIG_AUTO_DHCP_CHECK
	if(opmode == BRIDGE_MODE && dhcp_mode == AUTO_DHCPV4_BRIDGE)
	{	
		va_cmd("/bin/Auto_DHCP_Check", 8, 0, "-a", "15", "-n", "5", "-d", "30", "-m", "10");
		start_process_check_pidfile((const char*)AUTO_DHCPPID);
	}
#endif

	config_WLAN(ACT_RESTART, CONFIG_SSID_ALL);
	// update flash
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif // of #if COMMIT_IMMEDIATELY

	strVal    = boaGetVar(wp, "save_apply", "");
	submitUrl = boaGetVar(wp, "submit-url", "");
	// sysconf init   if save_apply
	if (strVal[0]) {
		OK_MSG(submitUrl);
	} else {
		boaRedirect(wp, submitUrl);
	}
#ifdef WLAN_DUALBAND_CONCURRENT
	wlan_idx = orig_wlan_idx;
#endif

	return;
}

int showBackhaulSelection(int eid, request * wp, int argc, char **argv)
{
#if defined(TRIBAND_SUPPORT)
	boaWrite(wp, "<tr id=\"controller_backhaul\"> <td width=\"30%%\">Backhaul BSS:</td> <td width=\"70%%\"> \
	<input type=\"radio\" id=\"controller_backhaul_wlan0\" name=\"controller_backhaul_radio\" value=\"0\" onclick=\"isBackhaulOnChange()\">wlan0&nbsp;&nbsp; \
	<input type=\"radio\" id=\"controller_backhaul_wlan1\" name=\"controller_backhaul_radio\" value=\"1\" onclick=\"isBackhaulOnChange()\">wlan1&nbsp;&nbsp; \
	<input type=\"radio\" id=\"controller_backhaul_wlan2\" name=\"controller_backhaul_radio\" value=\"2\" onclick=\"isBackhaulOnChange()\">wlan2&nbsp;&nbsp;</tr>");
	boaWrite(wp, "<tr id=\"agent_backhaul\"> <td width=\"30%%\">Backhaul STA:</td> <td width=\"70%%\"> \
	<input type=\"radio\" id=\"agent_backhaul_wlan0\" name=\"agent_backhaul_radio\" value=\"0\" onclick=\"isBackhaulOnChange()\">wlan0&nbsp;&nbsp; \
	<input type=\"radio\" id=\"agent_backhaul_wlan1\" name=\"agent_backhaul_radio\" value=\"1\" onclick=\"isBackhaulOnChange()\">wlan1&nbsp;&nbsp; \
	<input type=\"radio\" id=\"agent_backhaul_wlan2\" name=\"agent_backhaul_radio\" value=\"2\" onclick=\"isBackhaulOnChange()\">wlan2&nbsp;&nbsp;</tr>");
#else
	boaWrite(wp, "<tr id=\"controller_backhaul\"> <td width=\"30%%\">Backhaul BSS:</td> <td width=\"70%%\"> \
	<input type=\"radio\" id=\"controller_backhaul_wlan0\" name=\"controller_backhaul_radio\" value=\"0\" onclick=\"isBackhaulOnChange()\">wlan0&nbsp;&nbsp; \
	<input type=\"radio\" id=\"controller_backhaul_wlan1\" name=\"controller_backhaul_radio\" value=\"1\" onclick=\"isBackhaulOnChange()\">wlan1&nbsp;&nbsp;</tr>");
	boaWrite(wp, "<tr id=\"agent_backhaul\"> <td width=\"30%%\">Backhaul STA:</td> <td width=\"70%%\"> \
	<input type=\"radio\" id=\"agent_backhaul_wlan0\" name=\"agent_backhaul_radio\" value=\"0\" onclick=\"isBackhaulOnChange()\">wlan0&nbsp;&nbsp; \
	<input type=\"radio\" id=\"agent_backhaul_wlan1\" name=\"agent_backhaul_radio\" value=\"1\" onclick=\"isBackhaulOnChange()\">wlan1&nbsp;&nbsp;</tr>");
#endif
	return 0;
}
