#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <dirent.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <signal.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <sys/wait.h>
#include <time.h>
#include <net/route.h>
#include <sys/ioctl.h>
#include <signal.h>
#include <sys/ioctl.h>

/*-- Local inlcude files --*/
#include "../webs.h"
#include "webform.h"
#include "utility.h"
#include "../defs.h"
#include "debug.h"
#include "multilang.h"
#include "fmdefs.h"
extern int SetWlan_idx(char * wlan_iface_name);
void countdown_to_refresh(request * wp){
	boaHeader(wp);
	boaWrite(wp, "<head><META http-equiv=content-type content=\"text/html; charset=utf-8\"><style>\n" \
		"#cntdwn{ border-color: white; border-width: 0px; font-size: 12pt; color: red; text-align:left; font-weight:bold; font-family: Courier;}\n" \
		"</style><script language=javascript>\n" \
		"var h = 15;\n" \
		"function stop() { clearTimeout(id); }\n"\
		"function start() { h--; if (h >= 0) { frm.time.value = h; frm.textname.value='设备配置中，请稍等...'; id = setTimeout(\"start()\", 1000); }\n" \
		"if (h == 0) { window.location.reload(true); }}\n" \
		"</script></head>");
		boaWrite(wp,
		"<body bgcolor=white onLoad=\"start();\" onUnload=\"stop();\"><blockquote>" \
		"<form name=frm><b><font color=red><input type=text name=textname size=40 id=\"cntdwn\">\n" \
		"<input type=text name=time size=5 id=\"cntdwn\"></font></form></blockquote></body>" );
	boaFooter(wp);
	boaDone(wp, 200);
}
#ifdef CONFIG_USER_RTK_BRIDGE_MODE
int initOpmode(int eid, request * wp, int argc, char ** argv)
{
	_TRACE_CALL;	
	
	_TRACE_LEAVEL;
	
	return 0;
}

int setDHCPMode(char opmode, char dhcp_mode)
{
	int setDhcp=0;
	
	if(opmode==GATEWAY_MODE && dhcp_mode!=DHCPV4_LAN_SERVER)
	{
		dhcp_mode=DHCPV4_LAN_SERVER;
		setDhcp = 1;
	}
	else if(opmode==BRIDGE_MODE)
	{
#if 0//defined(CONFIG_AUTO_DHCP_CHECK) 
		if(dhcp_mode!=AUTO_DHCP_BRIDGE){
			dhcp_mode=AUTO_DHCP_BRIDGE;
			setDhcp = 1;
		}
#elif defined(CONFIG_USER_DHCPCLIENT_MODE)
		if(dhcp_mode!=DHCPV4_LAN_CLIENT){
			dhcp_mode=DHCPV4_LAN_CLIENT;
			setDhcp = 1;
		}
#endif
	}

	if(setDhcp){
		mib_set(MIB_DHCP_MODE, (void *)&dhcp_mode);
	}

	return 0;
}

void formInternetMode(request * wp, char *path, char *query)
{	
	char *strOpMode=NULL, *submitUrl=NULL;
	char tmpBuf[64]={0};
	int opmode_changed_flag=0;
	char dhcp_mode=0;

	int tmpVal;
	unsigned char origVal, curVal;
	mib_get(MIB_OP_MODE, (void *)&origVal);
	mib_get(MIB_DHCP_MODE, (void *)&dhcp_mode);
	
	strOpMode = boaGetVar(wp, "opmode", "");

#if defined(WLAN_UNIVERSAL_REPEATER) && defined(CONFIG_USER_RTK_REPEATER_MODE)	
	int rptmode_changed_flag=0;
	MIB_CE_MBSSIB_T Entry;
	int BUF_SIZE_TEMP = 20;
	char wlan_vxd_if[BUF_SIZE_TEMP];
	int i = 0;
	unsigned char curOpmode=0, origRptmode=0;

	mib_get(MIB_REPEATER_MODE, (void *)&origRptmode);
	if(strOpMode[0])
	{
		sscanf(strOpMode, "%d", &tmpVal);
		curVal=(unsigned char)tmpVal;
		if(curVal == 0){ //gw
			curOpmode = 0;
			if(origRptmode)
				rptmode_changed_flag = 1;
		}
		else if(curVal == 1){ //bridge
			curOpmode = 1;
			if(origRptmode == 1)
				rptmode_changed_flag = 1;
		}
		else{ //repeater
			curOpmode = 1;
			if(origRptmode == 0)
				rptmode_changed_flag = 1;
		}
		if((curOpmode != origVal) || rptmode_changed_flag)
		{
			opmode_changed_flag = 1;
		}
	}
	if(opmode_changed_flag == 1)
	{
		
#ifdef CONFIG_USER_RTK_BRIDGE_MODE
		cleanSystem();
#endif
		
		if (!mib_set(MIB_OP_MODE, (void *)&curOpmode)) 
		{
			//strcpy(tmpBuf, "multilang(LANG_SET_MIB_OP_MODE_FAIL)");
			goto setErr_opmode;
		}
		if(curVal==3) // repeater mode
		{
			char rptr_enabled = 1;
#ifdef CONFIG_USER_ANDLINK_PLUGIN
			mib_set(MIB_RTL_LINK_MODE, (void *)&rptr_enabled);
#endif

			curVal = 1;
			mib_set(MIB_OP_MODE, (void *)&curVal);
			mib_set(MIB_REPEATER_MODE, (void *)&rptr_enabled);
#ifdef RTK_CROSSBAND_REPEATER
			mib_set(MIB_CROSSBAND_ENABLE, (void *)&rptr_enabled);
#endif

			mib_save_wlanIdx();
			for(i=0; i<NUM_WLAN_INTERFACE;++i){
				snprintf(wlan_vxd_if, BUF_SIZE, VXD_IF, i);
				SetWlan_idx(wlan_vxd_if);
				mib_set(MIB_REPEATER_ENABLED1, (void *)&rptr_enabled);
				
				mib_chain_get(MIB_MBSSIB_TBL, WLAN_REPEATER_ITF_INDEX, (void *)&Entry);
				Entry.wlanDisabled = 0;
				Entry.wlanMode=CLIENT_MODE;
				mib_chain_update(MIB_MBSSIB_TBL, (void *)&Entry, WLAN_REPEATER_ITF_INDEX);
			}	
			mib_recov_wlanIdx();		
		}else //opmode is gw or bridge
		{
			char rpt_enabled=0;
			
#ifdef CONFIG_USER_ANDLINK_PLUGIN
			char rtl_link_mode;
			if(curVal == BRIDGE_MODE){
				rtl_link_mode = 0;
				mib_set(MIB_RTL_LINK_MODE, (void *)&rtl_link_mode);
			}else{
				rtl_link_mode = 2;
				mib_set(MIB_RTL_LINK_MODE, (void *)&rtl_link_mode);
			}
#endif
#ifdef RTK_CROSSBAND_REPEATER
			mib_set(MIB_CROSSBAND_ENABLE, (void *)&rpt_enabled);
#endif
			
			if(rptmode_changed_flag){
				mib_set(MIB_REPEATER_MODE, (void *)&rpt_enabled);
				mib_save_wlanIdx();
				for(i=0; i<NUM_WLAN_INTERFACE;++i){
					snprintf(wlan_vxd_if, BUF_SIZE, VXD_IF, i);
					SetWlan_idx(wlan_vxd_if);
					mib_set(MIB_REPEATER_ENABLED1, (void *)&rpt_enabled);
					
					mib_chain_get(MIB_MBSSIB_TBL, WLAN_REPEATER_ITF_INDEX, (void *)&Entry);
					Entry.wlanDisabled = 1;
					mib_chain_update(MIB_MBSSIB_TBL, (void *)&Entry, WLAN_REPEATER_ITF_INDEX);
				}	
				mib_recov_wlanIdx();
			}
		}

		setDHCPMode(curOpmode, dhcp_mode);
		
#ifdef COMMIT_IMMEDIATELY
		Commit();
#endif
#ifdef CONFIG_USER_RTK_BRIDGE_MODE
		reStartSystem();	
#endif
	}
#else
	
	if(strOpMode[0])
	{
		sscanf(strOpMode, "%d", &tmpVal);
		curVal=(unsigned char)tmpVal;		
		
		if(curVal != origVal)
		{
			opmode_changed_flag = 1;
		}
	}
	if(opmode_changed_flag == 1)
	{
#ifdef CONFIG_USER_RTK_BRIDGE_MODE
		cleanSystem();
#endif		
		if (!mib_set(MIB_OP_MODE, (void *)&curVal)) 
		{
			//strcpy(tmpBuf, "multilang(LANG_SET_MIB_OP_MODE_FAIL)");
			goto setErr_opmode;
		}

		setDHCPMode(curVal, dhcp_mode);
	
#ifdef COMMIT_IMMEDIATELY
		Commit();
#endif
#ifdef CONFIG_USER_RTK_BRIDGE_MODE
		reStartSystem();
#endif	
	}
#endif //end of CONFIG_USER_RTK_REPEATER_MODE
	else
	{
		submitUrl = boaGetVar(wp, "submit-url", "");
		if (submitUrl[0])
			boaRedirect(wp, submitUrl);
		else
			boaDone(wp, 200);
	}
	
#if defined(CONFIG_USER_RTK_VLAN_PASSTHROUGH)
	init_vlan_passthrough();
#endif
	return;
	
setErr_opmode:
	ERR_MSG(tmpBuf);
	
}
#endif

