/*
 *      Web server handler routines for Routing stuffs
 *
 */


/*-- System inlcude files --*/
#include <string.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <linux/if.h>
#include <net/route.h>

/*-- Local inlcude files --*/
#include "../webs.h"
#include "webform.h"
#include "mib.h"
#include "utility.h"
#include "../../port.h"
#if !defined(CONFIG_CMCC) && !defined(CONFIG_CU_BASEON_CMCC)
#include "utf8_string.h"
#endif
#ifdef CONFIG_CU_BASEON_CMCC
#include "fmdefs.h"
#endif

#if defined(CONFIG_APACHE_FELIX_FRAMEWORK) && defined(CONFIG_CMCC)
///////////////////////////////////////////////////////////////////
#define OSGI_PERMISSION_LOCKFILE	"/var/run/osgi_permission_lockfile.lock."

//op: 0--> add  1-->del
int rtk_osgi_setup_permission_api(unsigned int inst, int op)
{
	MIB_CE_OSGI_PERMISSION_API_T entry;
	int osgi_permission_lockfd=lock_file_by_flock(OSGI_PERMISSION_LOCKFILE,1);
	int totalEntry=mib_chain_total(MIB_OSGI_PERMISSION_API_TBL);
	int i=0;

	printf("%s:%d inst %d op %d\n", __FUNCTION__, __LINE__, inst, op);
	memset(&entry, 0, sizeof(entry));
	if(op==1){
		for(i=totalEntry-1; i >= 0; i--){
			if (!mib_chain_get(MIB_OSGI_PERMISSION_API_TBL, i, (void *)&entry)) {
				printf("%s:%d fail\n", __FUNCTION__, __LINE__);
			}

			if(entry.DUInstNum == inst){
				if(mib_chain_delete(MIB_OSGI_PERMISSION_API_TBL, i) != 1) {
					printf("%s:%d fail\n", __FUNCTION__, __LINE__);
				}
			}
		}
	}
	else{
		entry.DUInstNum = inst;
		for(i=0; i<CURRENT_PERMISSION_API_NUM; i++){
			entry.instNum=i+1;
			strcpy(entry.APIName, osgi_capbilities_long[i]);
			mib_chain_add(MIB_OSGI_PERMISSION_API_TBL, (unsigned char*)&entry);
		}
	}
	unlock_file_by_flock(osgi_permission_lockfd);
	return 0;
}

void formPermission(request * wp, char *path, char *query)
{
	char	*str, *submitUrl;
	char tmpBuf[100];
	MIB_CE_OSGI_PERMISSION_T entry;
	int xflag, allPermissionEnable;
	int skfd;
	int intVal;
	int totalEntry;

	memset( &entry, 0, sizeof(MIB_CE_OSGI_PERMISSION_T));

	// Delete
	str = boaGetVar(wp, "delPermission", "");
	if (str[0]) {
		printf("delPermission\n");
		unsigned int i;
		unsigned int idx;
		MIB_CE_OSGI_PERMISSION_T Entry;
		unsigned int totalEntry = mib_chain_total(MIB_OSGI_PERMISSION_TBL); /* get chain record size */
		str = boaGetVar(wp, "select", "");

		if (str[0]) {
			for (i=0; i<totalEntry; i++) {
				idx = totalEntry-i-1;
				snprintf(tmpBuf, 4, "s%d", idx);

				if ( !gstrcmp(str, tmpBuf) ) {
					//struct sockaddr_in *s_in;
					/* get the specified chain record */
					if (!mib_chain_get(MIB_OSGI_PERMISSION_TBL, idx, (void *)&Entry)) {
						strcpy(tmpBuf, errGetEntry);
						goto setErr_permission;
					}
					
					// delete from chain record
					if(mib_chain_delete(MIB_OSGI_PERMISSION_TBL, idx) != 1) {
						strcpy(tmpBuf, "删除失败!"); //Delete chain record error!
						goto setErr_permission;
					}
					rtk_osgi_setup_permission_api(Entry.instNum, 1);

					rtk_osgi_setup_osgi_permissions(NULL);
					//TODO write permission
					goto setOk_permission;
				}
			} // end of for
		}
		else {
			strcpy(tmpBuf, "没有选择删除的项目?"); //There is no item selected to delete!
			goto setErr_permission;
		}

		goto setOk_permission;
	}

	// parse input
	str = boaGetVar(wp, "allPermissionEnable", "0");
	allPermissionEnable = 0;
	if(atoi(str)==1){
		allPermissionEnable = 1;
	}
	
	str = boaGetVar(wp, "symbolicName", "");
	strcpy(entry.DUName, str);
	entry.instNum = rtk_osgi_get_permission_empty_inst();

	printf("addPermission allPermissionEnable %d\n", allPermissionEnable);
	printf("addPermission entry.DUName %s\n", entry.DUName);
	printf("addPermission instNum %d\n", entry.instNum);
	
	// Add
	str = boaGetVar(wp, "addPermission", "");
	if (str && str[0]) {

		/* Clean out the RTREQ sgructure. */
		intVal = mib_chain_add(MIB_OSGI_PERMISSION_TBL, (unsigned char*)&entry);
		if (intVal == 0) {
			strcpy(tmpBuf, Tadd_chain_error);
			goto setErr_permission;
		}
		else if (intVal == -1) {
			strcpy(tmpBuf, strTableFull);
			goto setErr_permission;
		}
		/* get chain record size */
		totalEntry = mib_chain_total(MIB_OSGI_PERMISSION_TBL); 
		rtk_osgi_setup_permission_api(entry.instNum, 1);
		if(allPermissionEnable==1){
			rtk_osgi_setup_permission_api(entry.instNum, 0);
		}
		rtk_osgi_setup_osgi_permissions(NULL);
	}

setOk_permission:
// Magician: Commit immediately
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif

	submitUrl = boaGetVar(wp, "submit-url", "");
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
  	return;

setErr_permission:
	ERR_MSG(tmpBuf);
}

int rtk_osgi_is_all_permission_api(unsigned int inst)
{
	
	MIB_CE_OSGI_PERMISSION_API_T entry;
	int totalEntry=mib_chain_total(MIB_OSGI_PERMISSION_API_TBL);
	int i=0,j=0;
	
	memset(&entry, 0, sizeof(entry));

	for(i=0; i<totalEntry; i++){
		if (!mib_chain_get(MIB_OSGI_PERMISSION_API_TBL, i, (void *)&entry)) {
			printf("%s:%d fail\n", __FUNCTION__, __LINE__);
		}
		if(entry.DUInstNum == inst){
			j++;
		}
	}

	if(j==CURRENT_PERMISSION_API_NUM){
		return 1;
	}
	else{
		return 0;
	}
}

int showPermission(int eid, request * wp, int argc, char **argv)
{
	int nBytesSent=0;

	unsigned int entryNum, i;
	MIB_CE_OSGI_PERMISSION_T Entry;
	int allPermissionEnable=0;

	entryNum = mib_chain_total(MIB_OSGI_PERMISSION_TBL);
	nBytesSent += boaWrite(wp, "<tr>"
	"<td align=center width=\"8%%\">Inst</td>\n"
	"<td align=center width=\"8%%\">Symbolic Name</td>\n"
	"<td align=center width=\"8%%\">All Permission</td>\n"
	"<td align=center width=\"5%%\">删除</td>\n"
	"</tr>\n");

	for (i=0; i<entryNum; i++) {
		if (!mib_chain_get(MIB_OSGI_PERMISSION_TBL, i, (void *)&Entry))
		{
  			boaError(wp, 400, "Get chain record error!\n");
			return -1;
		}
		
		allPermissionEnable = rtk_osgi_is_all_permission_api(Entry.instNum);
		// copy the static memory before reuse it
		nBytesSent += boaWrite(wp, "<tr>"
		"<td align=center width=\"8%%\"> %d</td>\n"
		"<td align=left width=\"8%%\"> %s</td>\n"
		"<td align=center width=\"8%%\"> %d</td>"
		"<td align=center width=\"5%%\"><input type=\"radio\" name=\"select\""
		" value=\"s%d\" "
		"onClick=\"postGW('%s', %d,'select%d' )\""
		"></td>\n"
		
		"</tr>\n",
		Entry.instNum, Entry.DUName, allPermissionEnable,
		i, Entry.DUName, allPermissionEnable, i);
	}

	return 0;
}

int showBundles(int eid, request * wp, int argc, char **argv)
{
	int nBytesSent=0;

	OSGI_BUNDLE_INFO_Tp list=NULL;
	int entryNum=0, i;

	listAllOsgiPlugin(&list, &entryNum);
	nBytesSent += boaWrite(wp, "<tr>"
	"<td align=center width=\"8%%\">Bundle ID</td>\n"
	"<td align=center width=\"8%%\">Symbolic Name</td>\n"
	"<td align=center width=\"8%%\">Plugin Name</td>\n"
	"<td align=center width=\"8%%\">Version</td>\n"
	"<td align=center width=\"8%%\">State</td>\n"
	"<td align=center width=\"8%%\">Level</td>\n"
	"<td align=center width=\"5%%\">删除</td>\n"
	"</tr>\n");

	for (i=0; i<entryNum; i++) {
		// copy the static memory before reuse it
		nBytesSent += boaWrite(wp, "<tr>"
		"<td align=center width=\"8%%\"> %d</td>\n"
		"<td align=left width=\"8%%\"> %s</td>\n"
		"<td align=left width=\"8%%\"> %s</td>\n"
		"<td align=left width=\"8%%\"> %s</td>\n"
		"<td align=left width=\"8%%\"> %s</td>\n"
		"<td align=center width=\"8%%\"> %d</td>"
		"<td align=center width=\"5%%\"><input type=\"radio\" name=\"select\""
		" value=\"%d\" "
		"onClick=\"postBundle('%s', %d,'select%d' )\""
		"></td>\n"
		
		"</tr>\n",
		list[i].bundle_id, list[i].symbolic_name, list[i].plugin_name, list[i].version, list[i].status, list[i].level,
		list[i].bundle_id, list[i].symbolic_name, list[i].bundle_id, i);
	}
	if(list){
		free(list);
	}
	return 0;
}

void formBundleUpload(request * wp, char *path, char *query)
{
	char	*str, *submitUrl;
	char tmpBuf[100]={0};
	char tmpMsg[1024]={0};
	MIB_CE_OSGI_PERMISSION_T entry;
	int xflag, allPermissionEnable;
	int skfd;
	int intVal;
	int totalEntry;
	unsigned int startPos, endPos, nLen;
	FILE *fp = NULL;
	struct stat st;
	MIB_CMCC_OSGI_PLUGIN_T plEntry;

	memset(&entry, 0, sizeof(MIB_CE_OSGI_PERMISSION_T));

	// Delete
	str = boaGetVar(wp, "delBundle", "");
	if (str[0]) {
		printf("delBundle\n");
		str = boaGetVar(wp, "select", "");
		printf("delBundle select %s\n", str);
		if(str[0] !=0){
			va_cmd("/bin/sh", 4, 1, OSGI_PLUGIN_UNINSTALL, str, hideErrMsg1, hideErrMsg2);
			intVal = rtk_osgi_get_plugin_by_bundleid(atoi(str), &plEntry);
			if(intVal!=-1){
				sprintf(tmpBuf, "rm -rf %s", plEntry.path);
				system(tmpBuf);
				mib_chain_delete(MIB_CMCC_OSGI_PLUGIN_TBL, intVal);
				
				snprintf(tmpMsg, sizeof(tmpMsg), "Uninstall bundle %s successful", plEntry.symbolic_name);
				rtk_osgi_bundle_log(tmpMsg);
			}
		}

		goto end;
	}

	str = boaGetVar(wp, "startBundle", "");
	if (str[0]) {
		printf("startBundle\n");
		str = boaGetVar(wp, "select", "");
		printf("startBundle select %s\n", str);
		if(str[0] !=0){
			va_cmd("/bin/sh", 4, 1, OSGI_PLUGIN_RUN, str, hideErrMsg1, hideErrMsg2);
			intVal = rtk_osgi_get_plugin_by_bundleid(atoi(str), &plEntry);
			if(intVal!=-1){
				plEntry.state=BUNDLE_STATE_ACTIVE;
				mib_chain_update(MIB_CMCC_OSGI_PLUGIN_TBL, &plEntry,intVal);
				
				snprintf(tmpMsg, sizeof(tmpMsg), "Start bundle %s successful", plEntry.symbolic_name);
				rtk_osgi_bundle_log(tmpMsg);
			}
		}
		goto end;
	}

	str = boaGetVar(wp, "stopBundle", "");
	if (str[0]) {
		printf("stopBundle\n");
		str = boaGetVar(wp, "select", "");
		printf("stopBundle select %s\n", str);
		if(str[0] !=0){
			va_cmd("/bin/sh", 4, 1, OSGI_PLUGIN_STOP, str, hideErrMsg1, hideErrMsg2);
			intVal = rtk_osgi_get_plugin_by_bundleid(atoi(str), &plEntry);
			if(intVal!=-1){
				plEntry.state=BUNDLE_STATE_RESOLVED;
				mib_chain_update(MIB_CMCC_OSGI_PLUGIN_TBL, &plEntry,intVal);

				snprintf(tmpMsg, sizeof(tmpMsg), "Stop bundle %s successful", plEntry.symbolic_name);
				rtk_osgi_bundle_log(tmpMsg);
			}
		}
		goto end;
	}

end:
	rtk_osgi_check_bundle_file();
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif

	submitUrl = boaGetVar(wp, "submit-url", "");
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
  	return;

}

FILE * uploadGetFile(request *wp, unsigned int *startPos, unsigned int *endPos)
{
	FILE *fp=NULL;
	struct stat statbuf;
	unsigned char c, *buf;
	char boundary[80]={};
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
	char cmd[32] = {0};
#endif

	if (wp->method == M_POST)
	{
		int i=0;

		fstat(wp->post_data_fd, &statbuf);
		lseek(wp->post_data_fd, 0, SEEK_SET);

		//printf("file size=%d, wp->post_file_name %s\n",statbuf.st_size, wp->post_file_name);
		fp=fopen(wp->post_file_name,"rb");
		if(fp==NULL) goto error;

		memset( boundary, 0, sizeof( boundary ) );
		if( fgets( boundary,80,fp )==NULL ) goto error;
		if( boundary[0]!='-' || boundary[1]!='-') 
		{
			goto error;
		}

		i= strlen( boundary ) - 1;
		while( boundary[i]=='\r' || boundary[i]=='\n' )
		{
			boundary[i]='\0';
			i--;
		}
		printf( "boundary=%s\n", boundary );
	}
	else goto error;


   	//printf("_uploadGet\n");
   	do
   	{
		if(feof(fp))
		{
			printf("Cannot find start of file\n");
			goto error;
		}
		c= fgetc(fp);
		if (c!=0xd)
			continue;
		c= fgetc(fp);
		if (c!=0xa)
			continue;
		c= fgetc(fp);
		if (c!=0xd)
			continue;
		c= fgetc(fp);
		if (c!=0xa)
			continue;
		break;
	}while(1);
	(*startPos)=ftell(fp);

   	if(fseek(fp,statbuf.st_size-0x200,SEEK_SET)<0)
	{
      		goto error;
	}

	do
	{
		if(feof(fp))
		{
			printf("Cannot find end of file\n");
			goto error;
		}
		c= fgetc(fp);
		if (c!=0xd)
			continue;
		c= fgetc(fp);
		if (c!=0xa)
			continue;

		{
			int i, blen;

			blen= strlen( boundary );
			for( i=0; i<blen; i++)
			{
				c= fgetc(fp);
				//printf("%c(%u)", c, c);
				if (c!=boundary[i])
				{
					ungetc( c, fp );
					break;
				}
			}
			//printf("\r\n");
			if( i!=blen ) continue;
		}

		break;
	}while(1);
	(*endPos)=ftell(fp)-strlen(boundary)-2;

   	return fp;
error:
	if(fp) fclose(fp);
   	return NULL;
}

void formBundleInstall(request * wp, char *path, char *query)
{
	char	*str, *submitUrl;
	char tmpBuf[256];
	char tmpBuf1[256];
	int skfd;
	int intVal;
	int totalEntry;
	unsigned int startPos, endPos, nLen;
	FILE *fp = NULL;
	struct stat st;
	char filepath[256];
	int bundleId=0;
	OSGI_BUNDLE_INFO_Tp list=NULL;
	int entryNum=0, i;
	MIB_CMCC_OSGI_PLUGIN_T plEntry;
	char symbolicName[256];
	int update = 0;
	char bundle_id_str[8];
	int index;

	memset(&plEntry, 0, sizeof(plEntry));
	if ((fp = uploadGetFile(wp, &startPos, &endPos)) == NULL) {
		goto end;
	}
	fclose(fp);

	printf("endPos=%u startPos=%u\n", endPos, startPos);
	nLen = endPos - startPos;
	
	strip_http(wp->post_file_name, startPos, nLen);
	stat(wp->post_file_name, &st);
	nLen = st.st_size;

	printf("Upgrade Bundle: filename %s, size %d\n", wp->post_file_name, nLen);

	//copy uploaded file to /var/osgi_app/bundle
	rtk_osgi_get_bundlefile_symbolicname(wp->post_file_name, symbolicName);
	sprintf(filepath, "/var/osgi_app/bundle/%s.jar", symbolicName);

	sprintf(tmpBuf, "mv %s %s", wp->post_file_name, filepath);
	
	printf("%s:%d tmpBuf %s\n",__FUNCTION__, __LINE__,tmpBuf);
	system(tmpBuf);

	listAllOsgiPlugin(&list, &entryNum);

	for(i=0; i < entryNum; i++){
		if(strcmp(list[i].symbolic_name, symbolicName) == 0){
			update = 1;
			bundleId = list[i].bundle_id;
			snprintf(bundle_id_str, sizeof(bundle_id_str), "%d", bundleId);
		}
	}
		
	if(list){
		free(list);
		list = NULL;
	}

	if(update==1){
		va_cmd("/bin/sh", 5, 1, OSGI_PLUGIN_UPDATE, bundle_id_str, filepath, hideErrMsg1, hideErrMsg2);
	}
	else{
		//install bundle
		va_cmd("/bin/sh", 4, 1, OSGI_PLUGIN_INSTALL, filepath, hideErrMsg1, hideErrMsg2);
		//wait bundle install finish
		if(rtk_osgi_is_bundle_action_timeout(&bundleId, filepath) == 1){
			printf("%s:%d install timeout\n",__FUNCTION__, __LINE__);
			goto end;
		}
		printf("%s:%d bundle id is %d\n",__FUNCTION__, __LINE__, bundleId);
	}


	//start bundle
	sprintf(tmpBuf, "%d", bundleId);
	printf("%s:%d tmpBuf %s\n",__FUNCTION__, __LINE__, tmpBuf);
	va_cmd("/bin/sh", 4, 1, OSGI_PLUGIN_RUN, tmpBuf, hideErrMsg1, hideErrMsg2);
	
	sleep(1);
	listAllOsgiPlugin(&list, &entryNum);
	index = rtk_osgi_get_plugin_by_bundleid(bundleId, &plEntry);
	for(i=0; i < entryNum; i++){
		if(list[i].bundle_id == bundleId){
			printf("%s:%d bundle id %d, symbolic_name %s\n",__FUNCTION__, __LINE__, list[i].bundle_id, list[i].symbolic_name);
			printf("%s:%d               version %s\n",__FUNCTION__, __LINE__, list[i].version);
			strcpy(plEntry.path, filepath);
			plEntry.size = nLen;
			plEntry.state = BUNDLE_STATE_ACTIVE;
			strcpy(plEntry.symbolic_name, list[i].symbolic_name);
			strcpy(plEntry.version, list[i].version);
			if(index < 0){
				plEntry.auto_start=1;
				plEntry.bundle_id = bundleId;
				strcpy(plEntry.os, "0");
				mib_chain_add(MIB_CMCC_OSGI_PLUGIN_TBL, &plEntry);
			}else{
				mib_chain_update(MIB_CMCC_OSGI_PLUGIN_TBL, &plEntry,index);
			}
			break;
		}
	}
		
	if(list){
		free(list);
		list = NULL;
	}
	
end:
	
	rtk_osgi_check_bundle_file();
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif
	submitUrl = boaGetVar(wp, "submit-url", "/bd/permission_cmcc.asp");

	if (submitUrl[0]){
		boaRedirect(wp, submitUrl);
	}
	else
		boaDone(wp, 200);
  	return;

}

#endif
