/*
 *      Web server handler routines for Routing stuffs
 *
 */


/*-- System inlcude files --*/
#include <string.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <linux/if.h>
#include <net/route.h>

/*-- Local inlcude files --*/
#include "../webs.h"
#include "webform.h"
#include "mib.h"
#include "utility.h"
#include "../../port.h"
#if !defined(CONFIG_CMCC) && !defined(CONFIG_CU_BASEON_CMCC)
#include "utf8_string.h"
#endif
#include "fmdefs.h"

#if defined(CONFIG_APACHE_FELIX_FRAMEWORK) && defined(CONFIG_CMCC_ENTERPRISE)
///////////////////////////////////////////////////////////////////
int showPreBundles(int eid, request * wp, int argc, char **argv)
{
	int nBytesSent=0;

	OSGI_BUNDLE_INFO_Tp list=NULL;
	int entryNum=0, i, j;
	MIB_CMCC_OSGI_PLUGIN_T Entry;
	int mibtotal;
	
	mibtotal = mib_chain_total(MIB_CMCC_OSGI_PLUGIN_TBL);

	listAllOsgiPlugin(&list, &entryNum);

	
	for(i=0; i < mibtotal; i++){
		if(!mib_chain_get(MIB_CMCC_OSGI_PLUGIN_TBL, i, (void *)&Entry))
			continue;

		for (j=0; j<entryNum; j++) {
			if(strcmp(Entry.symbolic_name, list[j].symbolic_name) == 0){
				// copy the static memory before reuse it
				nBytesSent += boaWrite(wp, "<tr>"
				"<td align=center> %s</td>\n"
				"<td align=left > %s</td>\n"
				"</tr>\n",
				list[j].symbolic_name, list[j].status);
				break;
			}
		}
	}
	if(list){
		free(list);
	}
	return 0;
}

static char *fixupBundleLoginfo(char *info)
{
	static char loginfo[4096] = { 0 };
	int i = 0, j = 0;
	int info_length = strlen(info);

	memset(loginfo, 0, sizeof(loginfo));

	for (i = 0; i < info_length; i++) {
		if (info[i] == '"' || info[i] == '\\') {
			loginfo[j++] = '\\';
		}
		loginfo[j++] = info[i];
	}

	return loginfo;
}

int bundleLogList(int eid, request * wp, int argc, char ** argv)
{
	char tmpbuf[1024];
	FILE *fp = NULL;
	int nBytesSent = 0;
	struct access_syslog_entry entry;
	unsigned char displayLevel;
	unsigned int s, security, log_file=0;

	if ((fp = fopen("/var/run/bundleLog.txt", "r")) == NULL)
			goto bundleLogList_err;

	while (fgets(tmpbuf, sizeof(tmpbuf), fp)) {
		tmpbuf[strlen(tmpbuf) - 1] = '\0';
		memset(&entry, 0, sizeof(entry));

		/* get dateTime */
		memcpy(entry.dateTime, tmpbuf, sizeof("YYYY-MM-DD HH:MM:SS") - 1);

		/* get msg */
		entry.msg = fixupBundleLoginfo(tmpbuf+sizeof("YYYY-MM-DD HH:MM:SS"));

		nBytesSent += boaWrite(wp, "rcs.push(new Array(\"%s\", \"%s\"));\n",
				entry.dateTime, entry.msg);
	}

bundleLogList_err:
	if(fp != NULL)
		fclose(fp);
	return nBytesSent;
}

#endif
