/*
 *      Web server handler routines for NET
 *
 */

/*-- System inlcude files --*/
#include <config/autoconf.h>
#include "../webs.h"
#include "fmdefs.h"
#include "mib.h"
#include "utility.h"
#include <stdlib.h>
#include "subr_net.h"

int initPagePIsolation(int eid, request * wp, int argc, char ** argv)
{
	int total, i;
	MIB_CE_PORT_ISOLATION_T pbEntry;

	total = mib_chain_total(MIB_PORT_ISOLATION_TBL);
	for (i=0; i<total; i++) 
	{
		mib_chain_get(MIB_PORT_ISOLATION_TBL, i, (void*)&pbEntry);
		boaWrite(wp, "setValue('Isolation%d', %d);\n\t", pbEntry.port, pbEntry.isolation);
	}
	
	return 0;
}

void formPortIsolation(request * wp, char *path, char *query)
{
	char *strData;
	char *submitUrl;
	int total, i, nVal;
	char tmpBuf[100];
	MIB_CE_PORT_ISOLATION_T pbEntry;

	for(i=0; i < PMAP_ITF_END; i++){
		if(mib_chain_get(MIB_PORT_ISOLATION_TBL, i, (void*)&pbEntry) !=0){
			snprintf(tmpBuf, sizeof(tmpBuf), "Isolation%d", pbEntry.port);
			strData = boaGetVar(wp, tmpBuf, "");
			nVal = atoi(strData);
			pbEntry.isolation = nVal;
			mib_chain_update(MIB_PORT_ISOLATION_TBL, (void *)&pbEntry, i);
		}
	}
	
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif

	rtk_lan_clear_lan_port_isolation();
	rtk_lan_handle_lan_port_isolation();

	submitUrl = boaGetVar(wp, "submit-url", "");   // hidden page
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
	return;
}

