/*
 *      Web server handler routines for IP QoS
 *
 */

/*-- System inlcude files --*/
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <sys/wait.h>

#include "../webs.h"
#include "webform.h"
#include "mib.h"
#include "utility.h"
#include "fc_api.h"

#ifdef EMBED
#include <linux/config.h>
#else
#include "../../../uClibc/include/linux/autoconf.h"
#endif

#undef QOS_DEBUG
static int function_print = 1;
static int debug_print    = 1;

#define QUEUE_RULE_NUM_MAX     256
#define TRAFFICTL_RULE_NUM_MAX 256

#define DELIM      '&'
#define SUBDELIM   '|'
#define SUBDELIM1  "|"

//print debug information
#ifdef QOS_DEBUG
#define PRINT_FUNCTION do{ if(function_print) printf("%s: %s\n", __FILE__, __FUNCTION__);}while(0);
#define QOS_DEBUG(fmt, args...) do{if(debug_print) printf("QOS DEBUG: " fmt, ##args);}while(0)

#define  PRINT_QUEUE(pEntry)  \
    printf("[QUEUE]: ifIndex:%d, ifname:%s, desc:%s, prio:%d, queueKey:%d, enable:%d\n",  \
	    pEntry->ifIndex, pEntry->ifname, pEntry->desc, pEntry->prio, pEntry->queueKey, pEntry->enable);

#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
#define PRINT_QUEUE_RULE(pEntry)  \
   printf("[QUEUE RULE]: ifidx:0x%x, name:%s, state:%d, prio:%d, mark dscp:0x%02x,\n"      \
	"mark 8021p:%d, dscp:0x%02x, tos:0x%02x, vlan 8021p:%d, phyPort:%d, prototype:%d, "	\
	  "srcip:%s, smaskbits:%d, dstip:%s, dmaskbits:%d, src port:%d-%d, dst port:%d-%d, connection_type:%d\n", 			\
	   pEntry->outif, pEntry->RuleName, pEntry->enable, pEntry->prior, \
	   pEntry->m_dscp, pEntry->m_1p, pEntry->qosDscp, pEntry->tos,pEntry->vlan1p, pEntry->phyPort, pEntry->protoType,  \
	   inet_ntoa(*((struct in_addr*)&pEntry->sip)), pEntry->smaskbit, \
	   inet_ntoa(*((struct in_addr*)&pEntry->dip)), pEntry->dmaskbit, pEntry->sPort,          \
	   pEntry->sPortRangeMax, pEntry->dPort, pEntry->dPortRangeMax, pEntry->applicationtype);
#else
#define PRINT_QUEUE_RULE(pEntry)  \
   printf("[QUEUE RULE]: ifidx:0x%x, name:%s, state:%d, prio:%d, mark dscp:0x%02x,\n"      \
	  "mark 8021p:%d, dscp:0x%02x, vlan 8021p:%d, phyPort:%d, prototype:%d, "    \
	  "srcip:%s, smaskbits:%d, dstip:%s, dmaskbits:%d, src port:%d-%d, dst port:%d-%d, connection_type:%d\n", 			\
	   pEntry->outif, pEntry->RuleName, pEntry->enable, pEntry->prior, \
	   pEntry->m_dscp, pEntry->m_1p, pEntry->qosDscp, pEntry->vlan1p, pEntry->phyPort, pEntry->protoType,  \
	   inet_ntoa(*((struct in_addr*)&pEntry->sip)), pEntry->smaskbit, \
	   inet_ntoa(*((struct in_addr*)&pEntry->dip)), pEntry->dmaskbit, pEntry->sPort,          \
	   pEntry->sPortRangeMax, pEntry->dPort, pEntry->dPortRangeMax, pEntry->applicationtype);
#endif

#define PRINT_TRAFFICTL_RULE(pEntry) \
    printf("[TRAFFIC CONTROL]: entryid:%d, ifIndex:%d, srcip:%s, smaskbits:%d, dstip:%s, dmaskbits:%d,"  \
	   "sport:%d, dport%d, protoType:%d, limitspeed:%d\n",                                                      \
	    pEntry->entryid, pEntry->ifIndex, inet_ntoa(*((struct in_addr*)&pEntry->srcip)),        \
	    pEntry->smaskbits, inet_ntoa(*((struct in_addr*)&pEntry->dstip)), pEntry->dmaskbits,                    \
	    pEntry->sport, pEntry->dport, pEntry->protoType, pEntry->limitSpeed);

#else

#define PRINT_FUNCTION do{}while(0);
#define QOS_DEBUG(fmt, args...) do{}while(0)
#define PRINT_QUEUE(pEntry)
#define PRINT_QUEUE_RULE(pEntry)
#define PRINT_TRAFFICTL_RULE(pEntry)

#endif

extern int getQosQueueEnable(int prio);
//show the wan interface list, using js code, must have waniflist array in js code
int ifWanList_tc(int eid, request * wp, int argc, char **argv)
{
	MIB_CE_ATM_VC_T entry;
	int entryNum = 0, i=0, nBytes = 0;
	char wanif[IFNAMSIZ] = {0};

	PRINT_FUNCTION

	entryNum = mib_chain_total(MIB_ATM_VC_TBL);
	QOS_DEBUG("Total entry num:%d\n", entryNum);

	//default
	nBytes += boaWrite(wp, "waniflst.add(new it(\" \", \" \"));");

	for(i=0;i<entryNum;i++)
	{
		if(!mib_chain_get(MIB_ATM_VC_TBL, i, &entry))
		    continue;

		//getWanName(&entry, wanif);
		ifGetName(entry.ifIndex, wanif, sizeof(wanif));
		nBytes += boaWrite(wp, "waniflst.add(new it(\"%d|%s\", \"%s\"));",
			entry.ifIndex, wanif, wanif);
	}

	return nBytes;
}

int initQosLanif(int eid, request * wp, int argc, char **argv)
{
	int i, j;
	int nBytes = 0;
	
#if defined(CONFIG_QOS_SUPPORT_WLAN_INTF)
	MIB_CE_MBSSIB_T entry;
	int lanItfNum = 0;
#endif	

	for (i=0; i < SW_LAN_PORT_NUM; i++) {
		nBytes += boaWrite(wp, "iffs.add(new it(\"%d\", \"LAN%d\"));\n", i+1, i+1);
	}
#if defined(CONFIG_QOS_SUPPORT_WLAN_INTF)
	for(i=0 ; i<NUM_WLAN_INTERFACE ; i++) {
		for (j=0 ; j<WLAN_SSID_NUM ; j++) {
			mib_chain_local_mapping_get(MIB_MBSSIB_TBL, i, j, (void *)&entry);
			if(entry.wlanDisabled) {
				continue;
			}
			nBytes += boaWrite(wp, "iffs.add(new it(\"%d\", \"SSID%d\"));\n", (SW_LAN_PORT_NUM+lanItfNum+1),(WLAN_SSID_NUM*i)+(j+1));
			lanItfNum++;
		}
	}
#endif

	return nBytes;
}

int initQosTypeLanif(int eid, request * wp, int argc, char **argv)
{
	int i, j;
	int nBytes = 0;
	
#if defined(CONFIG_QOS_SUPPORT_WLAN_INTF)
	MIB_CE_MBSSIB_T entry;
#endif	
	int lanItfNum = 0;
	for (i=0; i < SW_LAN_PORT_NUM; i++) {
		nBytes += boaWrite(wp, "LanList[%d]=new stLan(\"%d\", \"LAN%d\");\n", lanItfNum++,i+1, i+1);
	}
#if defined(CONFIG_QOS_SUPPORT_WLAN_INTF)
	for(i=0 ; i<NUM_WLAN_INTERFACE ; i++) {
		for (j=0 ; j<WLAN_SSID_NUM ; j++) {
			mib_chain_local_mapping_get(MIB_MBSSIB_TBL, i, j, (void *)&entry);
			if(entry.wlanDisabled) {
				continue;
			}
			nBytes += boaWrite(wp, "LanList[%d]=new stLan(\"%d\", \"SSID%d\");\n", lanItfNum,(lanItfNum+1),(WLAN_SSID_NUM*i)+(j+1));
			lanItfNum++;
		}
	}
#endif
	return nBytes;
}

int initOutif(int eid, request * wp, int argc, char **argv)
{
	MIB_CE_ATM_VC_T vcEntry;
	int entryNum, i, j, nBytes = 0;
	//char wanif[MAX_WAN_NAME_LEN]={0};
	char wanif[IFNAMSIZ]={0};
	
	PRINT_FUNCTION

	entryNum = mib_chain_total(MIB_ATM_VC_TBL);

	for(i=0; i<entryNum; i++)
	{
		if(!mib_chain_get(MIB_ATM_VC_TBL, i, &vcEntry))
			continue;

		//getWanName(&vcEntry, wanif);
		ifGetName(vcEntry.ifIndex, wanif, sizeof(wanif));

		nBytes += boaWrite(wp, "oifkeys.add(new it(\"%d\", \"%s\"));\n",
			vcEntry.ifIndex, wanif);
	}
	return nBytes;
}

int initConnType(int eid, request * wp, int argc, char **argv)
{
	int nBytes = 0;

	PRINT_FUNCTION

#ifdef CONFIG_YUEME
	nBytes += boaWrite(wp, "connTypes.push(\"\");");
	nBytes += boaWrite(wp, "connTypes.push(\"TR069_INTERNET\");");
	nBytes += boaWrite(wp, "connTypes.push(\"INTERNET\");");
	nBytes += boaWrite(wp, "connTypes.push(\"TR069\");");
	nBytes += boaWrite(wp, "connTypes.push(\"Other\");");
	nBytes += boaWrite(wp, "connTypes.push(\"VOICE\");");
	nBytes += boaWrite(wp, "connTypes.push(\"TR069_VOICE\");");
	nBytes += boaWrite(wp, "connTypes.push(\"VOICE_INTERNET\");");
	nBytes += boaWrite(wp, "connTypes.push(\"TR069_VOICE_INTERNET\");");
	nBytes += boaWrite(wp, "connTypes.push(\"SPECIAL_SERVICE_1\");");
	nBytes += boaWrite(wp, "connTypes.push(\"SPECIAL_SERVICE_2\");");
	nBytes += boaWrite(wp, "connTypes.push(\"SPECIAL_SERVICE_3\");");
	nBytes += boaWrite(wp, "connTypes.push(\"SPECIAL_SERVICE_4\");");
#ifdef SUPPORT_CLOUD_VR_SERVICE
		nBytes += boaWrite(wp, "connTypes.push(\"SPECIAL_SERVICE_VR\");");
#endif
#else
	nBytes += boaWrite(wp, "connTypes.push(\"\");");
	nBytes += boaWrite(wp, "connTypes.push(\"TR069_INTERNET\");");
	nBytes += boaWrite(wp, "connTypes.push(\"INTERNET\");");
	nBytes += boaWrite(wp, "connTypes.push(\"TR069\");");
	nBytes += boaWrite(wp, "connTypes.push(\"Other\");");
	nBytes += boaWrite(wp, "connTypes.push(\"VOICE\");");
	nBytes += boaWrite(wp, "connTypes.push(\"TR069_VOICE\");");
	nBytes += boaWrite(wp, "connTypes.push(\"VOICE_INTERNET\");");
	nBytes += boaWrite(wp, "connTypes.push(\"TR069_VOICE_INTERNET\");");
#endif

	return nBytes;
}

int initRulePriority(int eid, request * wp, int argc, char **argv)
{
	int j, nBytes = 0;

	PRINT_FUNCTION
	int qEntryNum = mib_chain_total(MIB_IP_QOS_QUEUE_TBL);
    // only show priority. The entryNum +1 is priority.
	for (j=1; j<=qEntryNum; j++)
		nBytes += boaWrite(wp, "quekeys.add(new it(\"%d\", \"Queue %d\"));\n", j , j);
#if defined(CONFIG_QOS_SUPPORT_8_QUEUES)
	if(qEntryNum<8){
		for (j=qEntryNum; j<=8; j++)
			nBytes += boaWrite(wp, "quekeys.add(new it(\"%d\", \"Queue %d\"));\n", j , j);
	}
#endif
	return nBytes;
}

char* netmaskbits2str(const int netmaskbit, char* netmaskstr, int strlen)
{
	unsigned int netmaskaddr = 0, i=0;

	if(!netmaskstr || !netmaskbit)
		return NULL;
	for(i=0;i<netmaskbit;i++)
		netmaskaddr = netmaskaddr|(0x80000000>>i);
	netmaskaddr = htonl(netmaskaddr);//host byte order to network byte order
	strncpy(netmaskstr, inet_ntoa(*(struct in_addr*)&netmaskaddr), strlen );

	return netmaskstr;
}

int generateAppTypeStr(unsigned int apptype, char* wanname)
{
	unsigned int tmp_apptype;
	
	if(wanname==NULL)
		return -1;

	if(!apptype){
		sprintf(wanname, "none");
		return 0;
	}

	tmp_apptype = apptype;

	if (tmp_apptype&X_CT_SRV_TR069){
		strcat(wanname, "TR069");
		tmp_apptype &= ~X_CT_SRV_TR069;
		if(tmp_apptype)
			strcat(wanname, "_");
	}	
	
	
#ifdef CONFIG_USER_RTK_VOIP
	if (tmp_apptype&X_CT_SRV_VOICE){
		strcat(wanname, "VOICE");
		tmp_apptype &= ~X_CT_SRV_VOICE;
		if(tmp_apptype)
			strcat(wanname, "_");
	}	
	
#endif

#if defined(CONFIG_YUEME) || defined(CONFIG_CU_BASEON_YUEME)
	if (tmp_apptype&X_CT_SRV_INTERNET)
		strcat(wanname, "INTERNET");
	if (tmp_apptype&X_CT_SRV_OTHER)
		strcat(wanname, "Other");
	if (tmp_apptype&X_CT_SRV_SPECIAL_SERVICE_1)
		strcat(wanname, "SPECIAL_SERVICE_1");
	if (tmp_apptype&X_CT_SRV_SPECIAL_SERVICE_2)
		strcat(wanname, "SPECIAL_SERVICE_2");
	if (tmp_apptype&X_CT_SRV_SPECIAL_SERVICE_3)
		strcat(wanname, "SPECIAL_SERVICE_3");
	if (tmp_apptype&X_CT_SRV_SPECIAL_SERVICE_4)
		strcat(wanname, "SPECIAL_SERVICE_4");
#ifdef SUPPORT_CLOUD_VR_SERVICE
	if (tmp_apptype&X_CT_SRV_SPECIAL_SERVICE_VR)
		strcat(wanname, "SPECIAL_SERVICE_VR");
#endif
#endif

	return 0;
}

unsigned int getMibApplicationType(unsigned int web_apptype)
{
	unsigned int mib_apptype=0;
	
	switch( web_apptype )
	{
		//("", "TR069_INTERNET", "INTERNET", "TR069", "Other", "Voice", "TR069_Voice", "Voice_INTERNET", "TR069_Voice_INTERNET", "SPECIAL_SERVICE_1", "SPECIAL_SERVICE_2", "SPECIAL_SERVICE_3", "SPECIAL_SERVICE_4")
		//TR069(1), INTERNET(2), IPTV(4), VOICE(8), SPECIAL_SERVICE_1(16), SPECIAL_SERVICE_2(32), SPECIAL_SERVICE_3(64), SPECIAL_SERVICE_4(128)
		case 0:
			mib_apptype = 0;
			break;
		case 1:
			mib_apptype = (X_CT_SRV_TR069|X_CT_SRV_INTERNET);
			break;
		case 2:
			mib_apptype = X_CT_SRV_INTERNET;
			break;
		case 3:
			mib_apptype = X_CT_SRV_TR069;
			break;
		case 4:
			mib_apptype = (X_CT_SRV_OTHER);
			break;
		case 5:
			mib_apptype = (X_CT_SRV_VOICE);
			break;
		case 6:
			mib_apptype = (X_CT_SRV_TR069|X_CT_SRV_VOICE);
			break;
		case 7:
			mib_apptype = (X_CT_SRV_VOICE|X_CT_SRV_INTERNET);
			break;
		case 8:
			mib_apptype = (X_CT_SRV_TR069|X_CT_SRV_VOICE|X_CT_SRV_INTERNET);
			break;
#ifdef CONFIG_YUEME
		case 9:
			mib_apptype = X_CT_SRV_SPECIAL_SERVICE_1;
			break;
		case 10:
			mib_apptype = X_CT_SRV_SPECIAL_SERVICE_2;
			break;
		case 11:
			mib_apptype = X_CT_SRV_SPECIAL_SERVICE_3;
			break;
		case 12:
			mib_apptype = X_CT_SRV_SPECIAL_SERVICE_4;
			break;
#ifdef SUPPORT_CLOUD_VR_SERVICE
		case 13:
			mib_apptype = X_CT_SRV_SPECIAL_SERVICE_VR;
			break;
#endif
#endif
		default:
			mib_apptype = 0;
	}

	return mib_apptype;
}

unsigned int getWebApplicationType(unsigned int mib_apptype)
{
	int i;

	for(i=0 ; i<=12 ; i++)
	{
		if(mib_apptype == getMibApplicationType(i)){
			return i;
		}
	}

	return 0;
}

/******************************************************************
 * NAME:    intPageQosRule
 * DESC:    initialize the qos rules by reading mib setting and
 *          format them to send them to webs to dispaly
 * ARGS:
 * RETURN:
 ******************************************************************/
int initQosRulePage(int eid, request * wp, int argc, char **argv)
{
	MIB_CE_IP_QOS_T qEntry;
	MIB_CE_ATM_VC_T       vcEntry;
	char saddr[16]={0}, daddr[16]={0}, smask[16]={0}, dmask[16]={0};
	char smacaddr[20], dmacaddr[20];
	int i=0, qEntryNum = 0, vcEntryNum = 0, nBytes = 0;
	char wanifname[MAX_WAN_NAME_LEN]={0};
#ifdef CONFIG_IPV6
	unsigned char 	sip6Str[48]={0}, dip6Str[48]={0};
#endif

#ifdef CONFIG_BRIDGE_EBT_DHCP_OPT
	char duid_mac[20]={0};
#endif
	char apptypestr[48]={0};
	unsigned int apptype = 0;
	unsigned char phyPort=0;
#ifdef CONFIG_CU
	int rule_display_index=0;
#endif

	PRINT_FUNCTION

	//get number of  ip qos queue rules, if none, or cannot get, return
	if((qEntryNum=mib_chain_total(MIB_IP_QOS_TBL)) <=0)
		return -1;

	if((vcEntryNum=mib_chain_total(MIB_ATM_VC_TBL)) <=0)
		return -1;

	for(i=0;i<qEntryNum; i++)
	{
		char phyportName[8] = {0};
		if(!mib_chain_get(MIB_IP_QOS_TBL, i, (void*)&qEntry))
			continue;

#ifdef _PRMT_X_CT_COM_QOS_
		if(qEntry.modeTr69 == MODEVOIP || qEntry.modeTr69 == MODETR069)
			continue;
#endif
#ifdef CONFIG_CU
		if(qEntry.classtype == QOS_CLASSTYPE_APPBASED)
			continue;
#endif
		//src addr
		snprintf(saddr, 16, "%s", inet_ntoa(*((struct in_addr*)&(qEntry.sip))));

		//src subnet mask
		if(!netmaskbits2str(qEntry.smaskbit, smask, 16))
		{
			smask[0] = '\0';
		}

		//dst addr
		snprintf(daddr, 16, "%s", inet_ntoa(*((struct in_addr*)&(qEntry.dip))));
		//dst subnet mask
		if(!netmaskbits2str(qEntry.dmaskbit, dmask, 16))
		{
			dmask[0] = '\0';
		}

#ifdef CONFIG_IPV6
		inet_ntop(PF_INET6, (struct in6_addr *)qEntry.sip6, sip6Str, sizeof(sip6Str));
		inet_ntop(PF_INET6, (struct in6_addr *)qEntry.dip6, dip6Str, sizeof(dip6Str));
#endif

		// src mac
		snprintf(smacaddr, 18, "%02x:%02x:%02x:%02x:%02x:%02x",
			qEntry.smac[0], qEntry.smac[1],
			qEntry.smac[2], qEntry.smac[3],
			qEntry.smac[4], qEntry.smac[5]);

		// dst mac
		snprintf(dmacaddr, 18, "%02x:%02x:%02x:%02x:%02x:%02x",
			qEntry.dmac[0], qEntry.dmac[1],
			qEntry.dmac[2], qEntry.dmac[3],
			qEntry.dmac[4], qEntry.dmac[5]);

#ifdef CONFIG_BRIDGE_EBT_DHCP_OPT
		//ifdef DHCPOPT
		// duid mac
		snprintf(duid_mac, 18, "%02x:%02x:%02x:%02x:%02x:%02x",
			qEntry.duid_mac[0], qEntry.duid_mac[1],
			qEntry.duid_mac[2], qEntry.duid_mac[3],
			qEntry.duid_mac[4], qEntry.duid_mac[5]);
#endif
		memset(wanifname, 0, sizeof(wanifname));
		if(qEntry.outif==DUMMY_IFINDEX)
			strcpy(wanifname,"Any");
		else if(!getWanEntrybyindex(&vcEntry, qEntry.outif))
		{
			generateWanName(&vcEntry, wanifname);
		}
		
		sprintf(apptypestr, "");
		if(generateAppTypeStr(qEntry.applicationtype, apptypestr)){
			sprintf(apptypestr, "none");
		}

		apptype = getWebApplicationType(qEntry.applicationtype);

		phyPort = qEntry.phyPort;

		//now write into webs using boaWrite function
		nBytes += boaWrite(wp, "rules.push(\n"
			"new it_nr(\"%s\",    \n"  //qos queue rule name
			"new it(\"index\",%d),\n"  //index of queue rule(identifier)
			"new it(\"state\",%d),\n"  //enable or disable
#ifdef CONFIG_CU
			"new it(\"display_index\",%d),\n"  //index of queue rule(identifier)
#endif
			"new it(\"prio\", \"%d\"),\n"  //queue priority, queueKey
			"new it(\"outif\", \"%d\"),\n"  //outif
			"new it(\"ext_if\", \"%d\"),\n"  //wan intg
			"new it(\"ext_if6\", \"%d\"),\n"  //IPv6 wan intg
			"new it(\"wanifname\",  \"%s\"),\n" //WAN interface name
#ifdef CONFIG_IPV6
			//"new it(\"ipversion\",%d),\n"  //ipv4 or ipv6
			"new it(\"IpProtocolType\",%d),\n"  //ipv4 or ipv6
			"new it(\"sip6\",  \"%s\"),\n" //source ip6
			"new it(\"dip6\",  \"%s\"),\n" //dst ip6
			"new it(\"sip6PrefixLen\",%d),\n"  //source ip6 Prefix Len
			"new it(\"dip6PrefixLen\",%d),\n"  //dst ip6 Prefix Len
#endif
			"new it(\"mvid\",%d),\n"   //VLAN ID
			"new it(\"mdscp\",%d),\n"   //dscp mark
			"new it(\"m1p\",  %d),\n"     //802.1p mark for wan interface
			"new it(\"vlan1p\",%d),\n"    //802.1p match for packet
			"new it(\"ethType\",\"%04x\"),\n"    //Ethernet Type match for packet
			"new it(\"phypt\", %d),\n"    //Lan phy port number
			"new it(\"proto\",%d),\n"     //protocol index, reference to mib.h
			"new it(\"dscp\", %d),\n"     //dscp
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC) || defined(CONFIG_USER_AP_E8B_QOS)
			"new it(\"tos\", %d),\n"	  //tos
#endif
			"new it(\"sip\",  \"%s\"),\n" //source ip, if stype=1, it is DHCP OPT 60
			"new it(\"smsk\", \"%s\"),\n" //source ip subnet mask
			"new it(\"dip\",  \"%s\"),\n"
			"new it(\"dmsk\", \"%s\"),\n"
			"new it(\"spts\", %d),\n"     //source port start
			"new it(\"spte\", %d),\n"     //source port end
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
			"new it(\"dptNot\", %d),\n"
#endif
			"new it(\"dpts\", %d),\n"
			"new it(\"dpte\", %d),\n"
			"new it(\"dhcpopt_type_select\", \"%d\"),\n"
			"new it(\"opt60_vendorclass\", \"%s\"),\n"
			"new it(\"opt61_iaid\", \"%d\"),\n"
			"new it(\"dhcpopt61_DUID_select\", \"%d\"),\n"
			"new it(\"duid_hw_type\", \"%d\"),\n"
			"new it(\"duid_mac\", \"%s\"),\n"
			"new it(\"duid_time\", \"%d\"),\n"
			"new it(\"duid_ent_num\", \"%d\"),\n"
			"new it(\"duid_ent_id\", \"%s\"),\n"
			"new it(\"opt125_ent_num\", \"%d\"),\n"
			"new it(\"opt125_manufacturer\", \"%s\"),\n"
			"new it(\"opt125_product_class\", \"%s\"),\n"
			"new it(\"opt125_model\", \"%s\"),\n"
			"new it(\"opt125_serial\", \"%s\"),\n"
			"new it(\"smac\", \"%s\"), \n"  //source mac address,now supported now, always 00:00:00:00:00:00
			"new it(\"smacw\",\"%s\"), \n"  //source mac address wildword
			"new it(\"dmac\", \"%s\"), \n"
			"new it(\"dmacw\",\"%s\"), \n"
			"new it(\"conntypeStr\",\"%s\"), \n"
			"new it(\"conntype\",\"%d\"), \n"
			"new it(\"classtype\",\"%d\"), \n"
			"new it(\"direction\",\"%d\"))); \n",
			qEntry.RuleName,  i, !!(qEntry.enable),
#ifdef CONFIG_CU
            rule_display_index,
#endif
			qEntry.prior,
			qEntry.outif,
			qEntry.outif,
			qEntry.outif,
			wanifname,
#ifdef CONFIG_IPV6
			qEntry.IpProtocol, sip6Str, dip6Str, qEntry.sip6PrefixLen, qEntry.dip6PrefixLen,
#endif
			qEntry.m_vid,qEntry.m_dscp, qEntry.m_1p, qEntry.vlan1p, *(unsigned short *)&(qEntry.ethType), qEntry.phyPort, qEntry.protoType, qEntry.qosDscp,
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC) || defined(CONFIG_USER_AP_E8B_QOS)
			qEntry.tos,
#endif
			saddr, smask, daddr, dmask, qEntry.sPort,
			qEntry.sPortRangeMax, 
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
			qEntry.dportNot,
#endif
			qEntry.dPort, qEntry.dPortRangeMax,
#ifdef CONFIG_BRIDGE_EBT_DHCP_OPT
			qEntry.dhcpopt_type,qEntry.opt60_vendorclass,qEntry.opt61_iaid,
			qEntry.opt61_duid_type,qEntry.duid_hw_type,duid_mac,
			qEntry.duid_time,qEntry.duid_ent_num,qEntry.duid_ent_id,
			qEntry.opt125_ent_num,qEntry.opt125_manufacturer,
			qEntry.opt125_product_class,qEntry.opt125_model,qEntry.opt125_serial,
#else
			0,"",0,
			0,0,"",
			0,0,"",
			0,"",
			"","","",
#endif
			smacaddr, "00:00:00:00:00:00", dmacaddr, "00:00:00:00:00:00",
			apptypestr, apptype, qEntry.classtype, qEntry.direction);
#ifdef CONFIG_CU
			rule_display_index ++;
#endif
	}

	return nBytes;
}

//Used to get subnet mask bit number
static int getNetMaskBit(char* netmask)
{
	unsigned int bits = 0, mask = 0;
	int i=0, flag = 0;

	if(!netmask||strlen(netmask)>15)
		return 0;
	mask = inet_network(netmask);
	for(;i<32;i++)
	{
		if(mask&(0x80000000>>i)) {
			if(flag)
				return 0;
			else
				bits++;
		}
		else {
	    		flag = 1;
		}
	}
	return bits;
}

/*
 * Return index of this rule
 * -1 on fail
 */
 #ifdef CONFIG_CMCC_ENTERPRISE
 static int string_to_hex(char *string, unsigned char *key, int len)
{
	char tmpBuf[4];
	int idx, ii = 0;

	if (string == NULL || key == NULL)
		return 0;

	for (idx = 0; idx < len; idx += 2) {
		tmpBuf[0] = string[idx];
		tmpBuf[1] = string[idx + 1];
		tmpBuf[2] = 0;

		if (!isxdigit(tmpBuf[0]) || !isxdigit(tmpBuf[1]))
			return 0;

		key[ii++] = strtoul(tmpBuf, NULL, 16);
	}

	return 1;
}
 static int parseRuleArgs(char* args, MIB_CE_IP_QOS_Tp pEntry)
{
	char* p=NULL, *tmp=NULL, buff[32] = {0};
	int idx = 0;
	int ret = 0;
#ifdef CONFIG_IPV6
	char buff2[48+1] = {0};
	struct in6_addr ip6Addr;
	unsigned char empty_ipv6[IPV6_ADDR_LEN] = {0};
#endif
	tmp = strtok(args, ",");
	int tos_dscp_type = 1; //1--tos 2--dscp
	do {
		char name[128]={0};
		char val[128]={0};
		char *comm=strstr(tmp,":");
		if(comm)
			*comm=' ';
		sscanf(tmp,"\"%[^\"]\" \"%[^\"]\"",name,val);
		printf("%s %d tmp=%s name=%s val=%s\n",__func__, __LINE__,tmp,name,val);
		if(strlen(val)){
			p=val;
			if(!strcmp(name,"pq_lanport")){
				pEntry->phyPort = strtol(val, &tmp, 0);
				//pEntry->phyPort_end =pEntry->phyPort;
			} else if(!strcmp(name,"pq_lanport_end")){
				pEntry->phyPort_end = strtol(val, &tmp, 0);
			} else if(!strcmp(name,"pq_wanport")){
				pEntry->outif = strtol(val, &tmp, 0);
				int mibtotal = mib_chain_total(MIB_ATM_VC_TBL);
				if((pEntry->outif)>mibtotal){
					pEntry->outif=DUMMY_IFINDEX;
				}else{
					MIB_CE_ATM_VC_T Entry;
					if(!mib_chain_get(MIB_ATM_VC_TBL, pEntry->outif-1, (void *)&Entry)){
						pEntry->outif=DUMMY_IFINDEX;
					}else{
						pEntry->outif = Entry.ifIndex;
					}
					printf("%s %d pEntry->outif=%d\n",__FUNCTION__,__LINE__,pEntry->outif);
				}
			}
			else if(!strcmp(name,"ether_type")){
				pEntry->IpProtocol = strtol(val, &tmp, 0);
			}
			else if(!strcmp(name,"proto_type")){
				pEntry->protoType = clsTypeProtoToIPQosProto(strtol(val, &tmp, 0));
				printf("%s %d pEntry->protoType=%d\n",__FUNCTION__,__LINE__,pEntry->protoType);
			}
			else if(!strcmp(name,"ipv4_srcip")){
				p=val;
				for(idx=0; *p &&idx<32; ++p)
					buff[idx++] = *p;
				buff[idx] = '\0';
				{//ip address
					inet_aton(buff, (struct in_addr *)&pEntry->sip);
					inet_aton(buff, (struct in_addr *)&pEntry->sip_end);
				}
			}
			else if(!strcmp(name,"ipv4_srcip_end")){
				p=val;
				for(idx=0; *p&&idx<32; ++p)
					buff[idx++] = *p;
				buff[idx] = '\0';
				{//ip address
					inet_aton(buff, (struct in_addr *)&pEntry->sip_end);
				}
			}
			else if(!strcmp(name,"srcport_start")){
				pEntry->sPortRangeMax =pEntry->sPort = strtol(val, &tmp, 0);
			}
			else if(!strcmp(name,"srcport_end")){
				pEntry->sPortRangeMax = strtol(val, &tmp, 0);
			}
			else if(!strcmp(name,"ipv4_dstip")){
				p=val;
				for(idx=0; *p &&idx<32; ++p)
					buff[idx++] = *p;
				buff[idx] = '\0';
				{//ip address
					inet_aton(buff, (struct in_addr *)&pEntry->dip);
					inet_aton(buff, (struct in_addr *)&pEntry->dip_end);
				}
			}
			else if(!strcmp(name,"ipv4_dstip_end")){
				p=val;
				for(idx=0; *p&&idx<32; ++p)
					buff[idx++] = *p;
				buff[idx] = '\0';
				{//ip address
					inet_aton(buff, (struct in_addr *)&pEntry->dip_end);
				}
			}
			else if(!strcmp(name,"ipv6_srcip")){
				p=val;
				for(idx=0; *p&&idx<48; ++p)
					buff2[idx++] = *p;
				buff2[idx] = '\0';
				{//ip address
					inet_pton(PF_INET6, buff2, &ip6Addr);
					memcpy(pEntry->sip6, &ip6Addr, sizeof(pEntry->sip6));
					memcpy(pEntry->sip6_end, &ip6Addr, sizeof(pEntry->sip6_end));
				}
			}
			else if(!strcmp(name,"ipv6_srcip_end")){
				p=val;
				for(idx=0; *p &&idx<48; ++p)
					buff2[idx++] = *p;
				buff2[idx] = '\0';
				{//ip address
					inet_pton(PF_INET6, buff2, &ip6Addr);
					printf("buff2=%s\n",buff2);
					memcpy(pEntry->sip6_end, &ip6Addr, sizeof(pEntry->sip6_end));
				}
			}else if(!strcmp(name,"ipv6_dstip")){
				p=val;
				for(idx=0; *p&&idx<48; ++p)
					buff2[idx++] = *p;
				buff2[idx] = '\0';
				{//ip address
					inet_pton(PF_INET6, buff2, &ip6Addr);
					memcpy(pEntry->dip6, &ip6Addr, sizeof(pEntry->dip6));
					memcpy(pEntry->dip6_end, &ip6Addr, sizeof(pEntry->dip6_end));
				}
			}
			else if(!strcmp(name,"ipv6_dstip_end")){
				p=val;
				for(idx=0; *p &&idx<48; ++p)
					buff2[idx++] = *p;
				buff2[idx] = '\0';
				{//ip address
					inet_pton(PF_INET6, buff2, &ip6Addr);
					memcpy(pEntry->dip6_end, &ip6Addr, sizeof(pEntry->dip6_end));
				}
			}
			else if(!strcmp(name,"dstport_start")){
				pEntry->dPortRangeMax=pEntry->dPort = strtol(val, &tmp, 0);
			}
			else if(!strcmp(name,"dstport_end")){
				pEntry->dPortRangeMax = strtol(val, &tmp, 0);
			}
			else if(!strcmp(name,"src_mac")){
				p=val;
				for(idx=0; *p&&idx<32; ++p) {
					if (*p!=':')
						buff[idx++] = *p;
				}
				string_to_hex(buff, pEntry->smac, 12);
			}
			else if(!strcmp(name,"src_mac_end")){
				p=val;
				for(idx=0; *p&&idx<32; ++p) {
					if (*p!=':')
						buff[idx++] = *p;
				}
				string_to_hex(buff, pEntry->smac_end, 12);
			}
			else if(!strcmp(name,"dst_mac")){
				p=val;
				for(idx=0; *p &&idx<32; ++p) {
					if (*p!=':')
						buff[idx++] = *p;
				}
				string_to_hex(buff, pEntry->dmac, 12);
			}
			else if(!strcmp(name,"dst_mac_end")){
				p=val;
				for(idx=0; *p &&idx<32; ++p) {
					if (*p!=':')
						buff[idx++] = *p;
				}
				string_to_hex(buff, pEntry->dmac_end, 12);
			}
			else if(!strcmp(name,"tos_dscp_type")){
				tos_dscp_type = strtol(val, &tmp, 0);
				printf("%s %d tos_dscp_type=%d\n",__FUNCTION__,__LINE__,tos_dscp_type);
			}
			else if(!strcmp(name,"dscp")){
				printf("%s %d tos_dscp_type=%d strtol(val, &tmp, 0)=%d\n",__FUNCTION__,__LINE__,tos_dscp_type,strtol(val, &tmp, 0));
				if(tos_dscp_type==1)
					pEntry->tos = strtol(val, &tmp, 0);
				else if(tos_dscp_type==2)
					pEntry->qosDscp=pEntry->qosDscp_end = strtol(val, &tmp, 0);
				printf("%s %d pEntry->tos =%d pEntry->qosDscp=%d\n",__FUNCTION__,__LINE__,pEntry->tos,pEntry->qosDscp);
			}
			else if(!strcmp(name,"dscp_end")){
				printf("%s %d tos_dscp_type=%d strtol(val, &tmp, 0)=%d\n",__FUNCTION__,__LINE__,tos_dscp_type,strtol(val, &tmp, 0));
				if(tos_dscp_type==1)
					pEntry->tos_end = strtol(val, &tmp, 0);
				else if(tos_dscp_type==2)
					pEntry->qosDscp_end = strtol(val, &tmp, 0);
				printf("%s %d pEntry->tos_end =%d pEntry->qosDscp_end=%d\n",__FUNCTION__,__LINE__,pEntry->tos_end,pEntry->qosDscp_end);
			}
			else if(!strcmp(name,"ipv6_tc")){
				pEntry->tos= strtol(val, &tmp, 0);
			}
			else if(!strcmp(name,"ipv6_tc_end")){
				pEntry->tos_end= strtol(val, &tmp, 0);
			}
			else if(!strcmp(name,"vlan_8021p")){
				pEntry->vlan1p = strtol(val, &tmp, 0) + 1;
			}
			else if(!strcmp(name,"vlan_8021p_end")){
				pEntry->vlan1p_end = strtol(val, &tmp, 0);
			}
			else if(!strcmp(name,"vlanid")){
				pEntry->vid=pEntry->vid_end = strtol(val, &tmp, 0);
			}
			else if(!strcmp(name,"vlanid_end")){
				pEntry->vid_end = strtol(val, &tmp, 0);
			}
			else if(!strcmp(name,"act_priority")){
				pEntry->m_1p = strtol(val, &tmp, 0)+1;
			}
			else if(!strcmp(name,"act_DSCP_priority")){
				if(!pEntry->m_dscp)
					pEntry->m_dscp = strtol(val, &tmp, 0);
			}else if(!strcmp(name,"mark_ipv6_tc")){
				if(!pEntry->m_dscp)
					pEntry->m_dscp = strtol(val, &tmp, 0);
			}else if(!strcmp(name,"act_queue")){
				pEntry->prior = strtol(val, &tmp, 0);
			}
		}
	}while((tmp = strtok(NULL, ",")) );
	if(!memcmp(pEntry->sip_end,"\x00\x00\x00\x00", IP_ADDR_LEN)){
		memcpy(pEntry->sip_end,pEntry->sip,IP_ADDR_LEN);
	}
	if(!memcmp(pEntry->dip_end,"\x00\x00\x00\x00", IP_ADDR_LEN)){
		memcpy(pEntry->dip_end,pEntry->dip,IP_ADDR_LEN);
	}
	if(!memcmp(pEntry->sip6_end,empty_ipv6, IPV6_ADDR_LEN)){
		unsigned char ip6Str[55];
		inet_ntop(PF_INET6, (struct in6_addr *)pEntry->sip6_end, ip6Str, sizeof(ip6Str));
		printf("sip6_end: \"%s\",\n", ip6Str);
		memcpy(pEntry->sip6_end,pEntry->sip6,IPV6_ADDR_LEN);
	}
	if(!memcmp(pEntry->dip6_end,empty_ipv6, IPV6_ADDR_LEN)){
		memcpy(pEntry->dip6_end,pEntry->dip6,IPV6_ADDR_LEN);
	}
	if(!pEntry->sPortRangeMax){
		pEntry->sPortRangeMax=pEntry->sPort;
	}
	if(!pEntry->dPortRangeMax){
		pEntry->dPortRangeMax=pEntry->dPort;
	}
	return ret;
}
 #else
static int parseRuleArgs(char* args, MIB_CE_IP_QOS_Tp pEntry)
{
	char* p=NULL, *tmp=NULL, buff[32] = {0};
	int idx = 0;
	int ret=0;
#ifdef CONFIG_IPV6
	char buff2[48+1] = {0};
	struct in6_addr ip6Addr;
#endif
#ifndef CONFIG_CU
	p = strstr(args, "conntype=");
	if(p){
		p +=strlen("conntype=");
		if(*p == DELIM)//default
			pEntry->applicationtype= 0;
		else {		
			pEntry->applicationtype = getMibApplicationType(strtol(p, &tmp, 10));
			if(*tmp != DELIM) return -1;
		}
	}
	p = strstr(args, "classtype=");
	if(p){
		p +=strlen("classtype=");
		if(*p == DELIM)//default
			pEntry->classtype= 0;
		else {		
			pEntry->classtype= strtol(p, &tmp, 10);
			if(*tmp != DELIM) return -1;
		} 
	}
#endif
	p = strstr(args, "direction=");	
	if(p){
		p +=strlen("direction=");	
		if(*p == DELIM)//default
			pEntry->direction = 0;
		else {		
			pEntry->direction = strtol(p, &tmp, 10);
			if(*tmp != DELIM) return -1;
		}
	}
	
	//get index
	p = strstr(args, "index=");
	if(p){
		p +=strlen("index=");
		if(*p == DELIM) {
			//pEntry->index = 0;
			ret = 0;
		} else {
			//pEntry->index = strtol(p, &tmp, 0);
			ret = strtol(p, &tmp, 0);
			if(*tmp != DELIM) return -1;
		}
	}
	//get RuleName
	p = strstr(args, "name=");
	if(p){
		for(p+=strlen("name="); *p!=DELIM&&idx<sizeof(pEntry->RuleName);p++)
			pEntry->RuleName[idx++] = *p;
	}

	//state
#if 1 // always enabled
	pEntry->enable = 1;
#else
	p = strstr(args, "state=");
	p += strlen("state=");
	if(*p != DELIM) {
		pEntry->enable = strtol(p, &tmp, 0);
		if(*tmp != DELIM)
			pEntry->enable = 1;//default
	} else {
		pEntry->enable = 1;//default
	}
#endif

	//get prio
	p = strstr(args, "prio=");
	if(p){
		p += strlen("prio=");
		if(*p==DELIM) return 1;
		pEntry->prior = strtol(p, &tmp, 0);
		if(*tmp != DELIM) return -1;//invalid dscp value
	}
/* Remove WANInterface
	// Mason Yu. t123
	//if(*tmp != SUBDELIM) return -1;
	if(*tmp != DELIM) return -1;
*/

	/*
	   printf("[%s:%d]\n",__func__,__LINE__);
	//get vid
	p = strstr(args, "markvid=");
	p += strlen("markvid=");
	if(*p == DELIM)//default
	pEntry->m_vid = 0;
	else {
	pEntry->m_vid = strtol(p, &tmp, 10);
	if(*tmp != DELIM) return -1;//invalid vid value
	}
	*/

	//get ifIndex, cmode
	p = strstr(args, "outif=");
	if(p){
		p += strlen("outif=");
		//ifIndex
		if(*p == DELIM) 
			pEntry->outif = DUMMY_IFINDEX;
		else
			pEntry->outif = strtol(p, &tmp, 0);
	}
	
	//mark 802.1p
	p = strstr(args, "mark1p=");
	if(p){
		p += strlen("mark1p=");
		if(*p == DELIM)//default
			pEntry->m_1p = 0;
		else {
			pEntry->m_1p = strtol(p, &tmp, 16);
			if(*tmp != DELIM) return -1;//invalid 802.1p value
		}
	}

	//mark dscp
	p = strstr(args, "markdscp=");
	if(p){
		p += strlen("markdscp=");
		if(*p == DELIM)//default
			pEntry->m_dscp = 0;
		else {
			pEntry->m_dscp = strtol(p, &tmp, 0);
			if(*tmp != DELIM) return -1;//invalid dscp value
		}
	}
	//protocol
	p = strstr(args, "proto=");
	if(p){
		p += strlen("proto=");
		if(*p == DELIM) {//default, none
			pEntry->protoType = 0;
		} else {
			pEntry->protoType = strtol(p, &tmp, 0);
			if(*tmp != DELIM) return -1;
		}
	}
	//smac
	p = strstr(args, "smac=");
	if(p){
	p += strlen("smac=");
		if (*p==DELIM) {//default
			memset(pEntry->smac, 0, MAC_ADDR_LEN);
		} else {
			for(idx=0; *p != DELIM&&idx<32; ++p) {
				if (*p!=':')
					buff[idx++] = *p;
			}
			rtk_string_to_hex(buff, pEntry->smac, 12);
		}
	}
	//dmac
	p = strstr(args, "dmac=");
	if(p){
	p += strlen("dmac=");
		if (*p==DELIM) {//default
			memset(pEntry->dmac, 0, MAC_ADDR_LEN);
		} else {
			for(idx=0; *p != DELIM&&idx<32; ++p) {
				if (*p!=':')
					buff[idx++] = *p;
			}
			rtk_string_to_hex(buff, pEntry->dmac, 12);
		}
	}
	//vlan 802.1p match
	p = strstr(args, "vlan1p=");
	if(p){
		p += strlen("vlan1p=");
		if(*p=='\0') {//default
			pEntry->vlan1p =0;
		} else {
			pEntry->vlan1p = strtol(p, &tmp, 0);
			if(*tmp != '\0') return -1;
		}
	}
#ifdef CONFIG_IPV6
	//IPVersion
	p = strstr(args, "IPversion=");
	if(p){
		p += strlen("IPversion=");
		if(*p == DELIM)//default
			pEntry->IpProtocol = IPVER_IPV4_IPV6;
		else {
			pEntry->IpProtocol = strtol(p, &tmp, 0);
			if(*tmp != DELIM) return -1;//invalid dscp value
		}
	}
	// If this is a IPv4 rule
	if ( pEntry->IpProtocol == IPVER_IPV4) {
#endif
		//ip source address
		p = strstr(args, "sip=");
		if(p){
			p += strlen("sip=");
			if(*p==DELIM) {//default
				memset(pEntry->sip, 0, IP_ADDR_LEN);
			} else {
				for(idx=0; *p != DELIM&&idx<(sizeof(buff)-1); ++p)
					buff[idx++] = *p;
				buff[idx] = '\0';
				{//ip address
					inet_aton(buff, (struct in_addr *)&pEntry->sip);
				}
			}
		}
		//source ip netmaskbit
		p = strstr(args, "smask=");
		if(p){
			p += strlen("smask=");
			if(*p==DELIM) {//default
				pEntry->smaskbit =0;
			} else {
				for(idx=0; *p != DELIM&&idx<(sizeof(buff)-1); ++p)
					buff[idx++] = *p;
				buff[idx] = '\0';
				pEntry->smaskbit = getNetMaskBit(buff);
			}
		}

		//ip dest address
		p = strstr(args, "dip=");
		if(p){
			p += strlen("dip=");
			if(*p==DELIM) {//default
				memset(pEntry->dip, 0, IP_ADDR_LEN);
			} else {
				for(idx=0; *p != DELIM&&idx<(sizeof(buff)-1); ++p)
					buff[idx++] = *p;
				buff[idx] = '\0';
				{//ip address
					inet_aton(buff, (struct in_addr *)&pEntry->dip);
				}
			}
		}
		//destination ip netmaskbit
		p = strstr(args, "dmask=");
		if(p){
			p += strlen("dmask=");
			if(*p==DELIM) {//default
				pEntry->dmaskbit =0;
			} else {
				for(idx=0; *p != DELIM&&idx<(sizeof(buff)-1); ++p)
					buff[idx++] = *p;
				buff[idx] = '\0';
				pEntry->dmaskbit = getNetMaskBit(buff);
			}
		}
#ifdef CONFIG_IPV6
	}
#endif

#ifdef CONFIG_IPV6
	// If it is a IPv6 rule.
	if ( pEntry->IpProtocol == IPVER_IPV6 )
	{
		//ip6 source address
		p = strstr(args, "sip6=");
		if(p){
			p += strlen("sip6=");
			if(*p==DELIM) {//default
				memset(pEntry->sip6, 0, IP6_ADDR_LEN);
			} else {
				for(idx=0; *p != DELIM&&idx<48; ++p)
					buff2[idx++] = *p;
				buff2[idx] = '\0';
				{//ip address
					inet_pton(PF_INET6, buff2, &ip6Addr);
					memcpy(pEntry->sip6, &ip6Addr, sizeof(pEntry->sip6));
				}
			}
		}

		//ip6 dest address
		p = strstr(args, "dip6=");
		if(p){
			p += strlen("dip6=");
			if(*p==DELIM) {//default
				memset(pEntry->dip6, 0, IP6_ADDR_LEN);
			} else {
				for(idx=0; *p != DELIM&&idx<48; ++p)
					buff2[idx++] = *p;
				buff2[idx] = '\0';
				{//ip address
					inet_pton(PF_INET6, buff2, &ip6Addr);
					memcpy(pEntry->dip6, &ip6Addr, sizeof(pEntry->dip6));
				}
			}
		}
		// ip6 src IP prefix Len
		p = strstr(args, "sip6PrefixLen=");
		if(p){
			p += strlen("sip6PrefixLen=");
			if(*p == DELIM)//default
				pEntry->sip6PrefixLen = 0;
			else {
				pEntry->sip6PrefixLen = strtol(p, &tmp, 0);
				if(*tmp != DELIM) return -1;//invalid dscp value
			}
		}
		// ip6 dst IP prefix Len
		p = strstr(args, "dip6PrefixLen=");
		if(p){
			p += strlen("dip6PrefixLen=");
			if(*p == DELIM)//default
				pEntry->dip6PrefixLen = 0;
			else {
				pEntry->dip6PrefixLen = strtol(p, &tmp, 0);
				if(*tmp != DELIM) return -1;//invalid dscp value
			}
		}
	}
#endif
	//src port start
	p = strstr(args, "spts=");
	if(p){
		p += strlen("spts=");
		if(*p==DELIM) {//default
			pEntry->sPort =0;
		} else {
			pEntry->sPort = strtol(p, &tmp, 0);
			if(*tmp != DELIM) return -1;
		}
	}
	//src port end
	p = strstr(args, "spte=");
	if(p){
		p += strlen("spte=");
		if(*p==DELIM) {//default
			pEntry->sPortRangeMax =0;
		} else {
			pEntry->sPortRangeMax = strtol(p, &tmp, 0);
			if(*tmp != DELIM) return -1;
		}
	}

	//dst port start
	p = strstr(args, "dpts=");
	if(p){
		p += strlen("dpts=");
		if(*p==DELIM) {//default
			pEntry->dPort =0;
		} else {
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
		    if(p[0] == '!')
		    {
		        pEntry->dportNot = 1;
				pEntry->dPort = strtol(p+1, &tmp, 0);
				if(*tmp != DELIM) return -1;
		    }
		    else
		    {
		        pEntry->dportNot = 0;
				pEntry->dPort = strtol(p, &tmp, 0);
				if(*tmp != DELIM) return -1;        
		    }
#else
			pEntry->dPort = strtol(p, &tmp, 0);
			if(*tmp != DELIM) return -1;
#endif
		}
	}

	//dst port end
	p = strstr(args, "dpte=");
	if(p){
		p += strlen("dpte=");
		if(*p==DELIM) {//default
			pEntry->dPortRangeMax =0;
		} else {
			pEntry->dPortRangeMax = strtol(p, &tmp, 0);
			if(*tmp != DELIM) return -1;
		}	
	}
	//dscp match
	p = strstr(args, "matchdscp=");
	if(p){
		p += strlen("matchdscp=");
		if(*p == DELIM) {//default
			pEntry->qosDscp = 0;
		} else {
			pEntry->qosDscp = strtol(p, &tmp, 0);
			if(*tmp != DELIM) return -1;
		}
	}
	//phy port num
	p = strstr(args, "phyport=");
	if(p){
		p +=strlen("phyport=");
		if(*p == DELIM) {
			pEntry->phyPort = 0;//default phy port, none
		} else {
			pEntry->phyPort = strtol(p, &tmp, 0);
			if(*tmp != DELIM) return 1;
		}
	}
	return ret;
}
#endif

//parse formated string recieved from web client:
//inf=VAL&proto=VAL&srcip=VAL&srcnetmask=VAL&dstip=VAL&dstnetmask=VAL&sport=VAL&dport=VAL&uprate=VAL(old).
//where VAL is the value of the corresponding item. if none, VAL is ignored but the item name cannot be
//The argument action is not modified by the function, so it can be a const string or non-const string.
static int parseArgs(char* action, MIB_CE_IP_TC_Tp pEntry)
{
	char* p = NULL, *tmp = NULL;
	int i = 0;
#ifdef CONFIG_IPV6
	int idx = 0;
	char buff2[48] = {0};
	struct in6_addr ip6Addr;
#endif

	PRINT_FUNCTION

	//ifIndex
	tmp = strstr(action, "inf=");
	tmp += strlen("inf=");
	
	pEntry->ifIndex = strtol(tmp, &p,0);	
	
	if(*p != DELIM)
		return 1;

	//protocol
	tmp =strstr(action, "proto=");
	tmp += strlen("proto=");
	if(!tmp||*tmp == DELIM)//not set protocol, set it to default,none
		pEntry->protoType = 0;
	else
	{
		pEntry->protoType = strtol(tmp, &p, 0);
		if(*p != DELIM)
			return 1;
	}

#ifdef CONFIG_IPV6
	//IPVersion
	tmp = strstr(action, "IPversion=");
	tmp += strlen("IPversion=");
	if(*tmp == DELIM)//default
		pEntry->IpProtocol = IPVER_IPV4_IPV6;
	else {
		pEntry->IpProtocol = strtol(tmp, &p, 0);
		if(*p != DELIM) return -1;//invalid dscp value
	}

	// If this is a IPv4 rule
	if ( pEntry->IpProtocol == IPVER_IPV4) {
#endif
		//source ip
		tmp = strstr(action, "srcip=");
		tmp += strlen("srcip=");
		if(!tmp||*tmp == DELIM)//noet set, set default
			memset(pEntry->srcip, 0, IP_ADDR_LEN);
		else
		{
			char sip[16]={0};
			p = strchr(tmp, DELIM);
			if(p&&p-tmp>15)
				return 1;
			strncpy(sip, tmp, p-tmp);
			inet_aton(sip, (struct in_addr *)&pEntry->srcip);
		}

		//source ip address netmask
		tmp = strstr(action, "srcnetmask=");
		tmp += strlen("srcnetmask=");
		if(!tmp||*tmp==DELIM)
			pEntry->smaskbits = 0;
		else
		{
			char smask[16]={0};
			p = strchr(tmp, DELIM);
			if(p&&p-tmp>15) return 1;
			strncpy(smask, tmp, p-tmp);
			pEntry->smaskbits = getNetMaskBit(smask);
		}

		//destination ip
		tmp = strstr(action, "dstip=");
		tmp += strlen("dstip=");
		if(!tmp||*tmp == DELIM)//noet set, set default
			memset(pEntry->dstip, 0, IP_ADDR_LEN);
		else
		{
			char dip[16]={0};
			p = strchr(tmp, DELIM);
			if(p&&p-tmp>15)
				return 1;
			strncpy(dip, tmp, p-tmp);
			inet_aton(dip, (struct in_addr *)&pEntry->dstip);
		}

		//destination ip address netmask
		tmp = strstr(action, "dstnetmask=");
		tmp += strlen("dstnetmask=");
		if(!tmp||*tmp==DELIM)
			pEntry->dmaskbits = 0;
		else
		{
			char dmask[16]={0};
			p = strchr(tmp, DELIM);
			if(p&&p-tmp>15)
				return 1;
			strncpy(dmask, tmp, p-tmp);
			pEntry->dmaskbits = getNetMaskBit(dmask);

		}
#ifdef CONFIG_IPV6
	}
#endif

#ifdef CONFIG_IPV6
	// If it is a IPv6 rule.
	if ( pEntry->IpProtocol == IPVER_IPV6 )
	{
		//ip6 source address
		tmp = strstr(action, "sip6=");
		tmp += strlen("sip6=");
		if(*tmp==DELIM) {//default
			memset(pEntry->sip6, 0, IP6_ADDR_LEN);
		} else {
			for(idx=0; *tmp != DELIM&&idx<(sizeof(buff2)-1); ++tmp)
				buff2[idx++] = *tmp;
			buff2[idx] = '\0';
			{//ip address
				inet_pton(PF_INET6, buff2, &ip6Addr);
				memcpy(pEntry->sip6, &ip6Addr, sizeof(pEntry->sip6));
			}
		}

		// ip6 src IP prefix Len
		tmp = strstr(action, "sip6PrefixLen=");
		tmp += strlen("sip6PrefixLen=");
		if(*tmp == DELIM)//default
			pEntry->sip6PrefixLen = 0;
		else {
			pEntry->sip6PrefixLen = strtol(tmp, &p, 0);
			if(*p != DELIM) return -1;//invalid dscp value
		}

		//ip6 dest address
		tmp = strstr(action, "dip6=");
		tmp += strlen("dip6=");
		if(*tmp==DELIM) {//default
			memset(pEntry->dip6, 0, IP6_ADDR_LEN);
		} else {
			for(idx=0; *tmp != DELIM&&idx<sizeof(buff2)-1; ++tmp)
				buff2[idx++] = *tmp;
			buff2[idx] = '\0';
			{//ip address
				inet_pton(PF_INET6, buff2, &ip6Addr);
				memcpy(pEntry->dip6, &ip6Addr, sizeof(pEntry->dip6));
			}
		}

		// ip6 dst IP prefix Len
		tmp = strstr(action, "dip6PrefixLen=");
		tmp += strlen("dip6PrefixLen=");
		if(*tmp == DELIM)//default
			pEntry->dip6PrefixLen = 0;
		else {
			pEntry->dip6PrefixLen = strtol(tmp, &p, 0);
			if(*p != DELIM) return -1;//invalid dscp value
		}
	}
#endif

	//source port
	tmp = strstr(action, "sport=");
	tmp += strlen("sport=");
	if(!tmp||*tmp==DELIM)
		pEntry->sport = 0;
	else
	{
		pEntry->sport = strtol(tmp, &p, 0);
		if(*p != DELIM)
			return 1;
	}

	//destination port
	tmp = strstr(action, "dport=");
	tmp += strlen("dport=");
	if(!tmp||*tmp==DELIM)
		pEntry->dport = 0;
	else
	{
		pEntry->dport = strtol(tmp, &p, 0);
		if(*p != DELIM)
			return 1;
	}

	//rate limit
	tmp = strstr(action, "rate=");
	tmp += strlen("rate=");
	if(!tmp||*tmp=='\0')
		pEntry->limitSpeed = 0;
	else
	{
		pEntry->limitSpeed = strtol(tmp, &p, 0);
		if(*p != DELIM)
			return 1;
	}

	//direction limit
	tmp = strstr(action, "direction=");
	tmp += strlen("direction=");
	if(!tmp||*tmp=='\0')
		pEntry->direction = 0;
	else
	{
		pEntry->direction = strtol(tmp, &p, 0);
		if(*p != '\0')
			return 1;
	}
	return 0;
}

void formQosRuleEdit(request * wp, char* path, char* query)
{
	MIB_CE_IP_QOS_T entry;
	char* action = NULL, args[256]={0}, *p = NULL, *tmp=NULL;
	char* act1="addrule", *act2="editrule", *url = NULL;
	int entryNum = 0, index=0,i=0;
	int j;

	PRINT_FUNCTION
	action = boaGetVar(wp, "lst", "");
	if(action[0])
	{
		entryNum = mib_chain_total(MIB_IP_QOS_TBL);

		if(!strncmp(action, act1, strlen(act1)))
		{//add new one
			if( entryNum>=QUEUE_RULE_NUM_MAX)
			{
				ERR_MSG("伫列规则数目已达上限."); //You cannot add one new rule when queue is full.
				return;
			}

			//reset to zero
			bzero(&entry, sizeof(MIB_CE_IP_QOS_T));

			index = parseRuleArgs(action, &entry);
			if (index >= 0)
			{
				PRINT_QUEUE_RULE((&entry));

#ifdef _PRMT_X_CT_COM_QOS_
				// Mason Yu. 
				entry.modeTr69 = MODEOTHER;
				for(j=0;j<CT_TYPE_NUM;j++)
					entry.cttypemap[j]=0;
				updatecttypevalue(&entry);				
#endif

				if(!mib_chain_add(MIB_IP_QOS_TBL, &entry))
				{
					ERR_MSG("mib Error: qos规则加入失败"); //mib Error: Cannot add new one qos rule.
					return;
				}
			}
			else
			{
				ERR_MSG("AddQosRule:错误的格式!"); //AddQosRule:Wrong argument format!
				return;
			}

		} else if(!strncmp(action, act2, strlen(act2))) {//update old one
			MIB_CE_IP_QOS_T oldEntry;

			//reset to zero
			bzero(&entry, sizeof(MIB_CE_IP_QOS_T));

			index = parseRuleArgs(action, &entry);
			if(index<0)
			{
				ERR_MSG("UpdateQosRule: 错误的格式!"); //UpdateQosRule: Wrong argument format!
				return;
			}
			PRINT_QUEUE_RULE((&entry));
			mib_chain_get(MIB_IP_QOS_TBL, index, &oldEntry);
#ifdef _CWMP_MIB_
			entry.InstanceNum=oldEntry.InstanceNum;

#endif

#ifdef _PRMT_X_CT_COM_QOS_
			entry.modeTr69=oldEntry.modeTr69;
			entry.minphyPort=oldEntry.minphyPort;			
			for(j=0;j<CT_TYPE_NUM;j++)
				entry.cttypemap[j]=oldEntry.cttypemap[j];
			updatecttypevalue(&entry);
#endif
			if(!mib_chain_update(MIB_IP_QOS_TBL, &entry, index))
			{
				ERR_MSG("qos规则更新失败!"); //Updating qos rule into mib is wrong!
				return;
			}
		} else {//undefined operation
			ERR_MSG("错误的操作! 你只能新增或编辑qos规则!"); //Wrong operation happened! you only and add or edit qos rule in this page!
			return;
		}
	}
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif
	//redirect
	url = boaGetVar(wp, "submit-url","");
	if(url[0])
	{
		boaRedirect(wp, url);
	}
	return;
}
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC) || defined(CONFIG_USER_AP_E8B_QOS)
void formQosVlan(request * wp, char* path, char* query){
	char* url=NULL;
	url = boaGetVar(wp, "submit-url","");
	if(url[0])
		{
			boaRedirect(wp, url);
		}
	return;

}

static void log_QosClsRule(char *status, MIB_CE_IP_QOS_CLASSFICATION_Tp entry)
{
	int len=0;
	char tmplogBuf[200]={0};
	len += snprintf(tmplogBuf+len, sizeof(tmplogBuf)-len, ", ClsQueueValueFlag: %d, DSCPMarkValue: %d, v8021pValue: %d", entry->queue, entry->m_dscp, entry->m_1p);

	syslog(LOG_INFO, "QosClassficationRule: %s%s", status, tmplogBuf);
}
void formQosClassficationRuleEdit(request * wp, char* path, char* query){
	MIB_CE_IP_QOS_CLASSFICATION_T entry;
	char* action = NULL, args[256]={0}, *p = NULL, *tmp=NULL;
	char* act1="addrule", *act2="editrule", *url = NULL;
	int entryNum = 0, index=0,i=0;
	int j;
	char *ClsQueueValueFlag,*DSCPMarkValue,*v8021pValue;
#ifdef CONFIG_USER_AP_CT_QOS
	char *IpProtocol;
#endif
	
	action = boaGetVar(wp, "lst", "");
	
	if(!action)
		goto end;
	printf("action=%s\n",action);
	if(!strncmp(action,"addQosClsRule",strlen("addQosClsRule")))
	{
		char *EditClsIndexStr=boaGetVar(wp, "EditClsIndex", "-1");
		printf("EditClsIndexStr=%s\n",EditClsIndexStr);
		if(!strcmp(EditClsIndexStr,"-1")||!strlen(EditClsIndexStr)){
			//add classfication rule
			entryNum = mib_chain_total(MIB_IP_QOS_CLASSFICATION_TBL);
			
			if( entryNum>=MAX_QOS_CLASSFICATION_NUM)
			{
				ERR_MSG("规则数目已达上限."); //You cannot add one new rule when queue is full.
				return;
			}
			bzero(&entry, sizeof(MIB_CE_IP_QOS_CLASSFICATION_T));
			ClsQueueValueFlag=boaGetVar(wp, "ClsQueueValueFlag", "1");
			//printf("ClsQueueValueFlag=%s\n",ClsQueueValueFlag);
			entry.queue =atoi(ClsQueueValueFlag);
			DSCPMarkValue=boaGetVar(wp, "DSCPMarkValue", "0");
			//printf("DSCPMarkValue=%s\n",DSCPMarkValue);
			entry.m_dscp =atoi(DSCPMarkValue);
			v8021pValue=boaGetVar(wp, "v8021pValue", "0");
			//printf("v8021pValue=%s\n",v8021pValue);
			entry.m_1p =atoi(v8021pValue);
			entry.cls_id=getValidClsID();
			//printf("entry.cls_id=%d entryNum=%d\n",entry.cls_id,entryNum);
			entry.InstanceNum = find_max_classification_instanNum() + 1;

		#ifdef CONFIG_USER_AP_CT_QOS
			IpProtocol=boaGetVar(wp, "IpProtocol", "");
			if(IpProtocol[0]) {
				if(!strncmp(IpProtocol, "IPv4", sizeof("IPv4"))) {
					entry.ipProtocol = IPVER_IPV4;
				}
				else if(!strncmp(IpProtocol, "IPv6", sizeof("IPv6"))) {
					entry.ipProtocol = IPVER_IPV6;
				}
				else if(!strncmp(IpProtocol, "IPv4,IPv6", sizeof("IPv4,IPv6"))) {
					entry.ipProtocol = IPVER_IPV4_IPV6;
				}
				else {
					ERR_MSG("Invalid IpProtocol");
					return;
				}
			}
			else {
				entry.ipProtocol = IPVER_IPV4;
			}
		#endif
			
			if(!mib_chain_add(MIB_IP_QOS_CLASSFICATION_TBL, &entry)){
					ERR_MSG("mib Error: qos规则加入失败"); //mib Error: Cannot add new one qos rule.
					return;
			}	
			log_QosClsRule("Add", &entry);
			//printf("entry.cls_id=%d entryNum=%d\n",entry.cls_id,mib_chain_total(MIB_IP_QOS_CLASSFICATION_TBL));
		}else{
			//edit classfication rule
			int EditClsIndex = atoi(EditClsIndexStr);
			//find the cls postion
			int pos=EditClsIndex;
			if(!mib_chain_get(MIB_IP_QOS_CLASSFICATION_TBL,pos,&entry))
				return;
			ClsQueueValueFlag=boaGetVar(wp, "ClsQueueValueFlag", "0");
			//printf("ClsQueueValueFlag=%s\n",ClsQueueValueFlag);
			entry.queue =atoi(ClsQueueValueFlag);
			DSCPMarkValue=boaGetVar(wp, "DSCPMarkValue", "0");
			//printf("DSCPMarkValue=%s\n",DSCPMarkValue);
			entry.m_dscp =atoi(DSCPMarkValue);
			v8021pValue=boaGetVar(wp, "v8021pValue", "0");
			//printf("v8021pValue=%s\n",v8021pValue);
			entry.m_1p =atoi(v8021pValue);

		#ifdef CONFIG_USER_AP_CT_QOS
			IpProtocol=boaGetVar(wp, "IpProtocol", "");
			if(IpProtocol[0]) {
				if(!strncmp(IpProtocol, "IPv4", sizeof("IPv4"))) {
					entry.ipProtocol = IPVER_IPV4;
				}
				else if(!strncmp(IpProtocol, "IPv6", sizeof("IPv6"))) {
					entry.ipProtocol = IPVER_IPV6;
				}
				else if(!strncmp(IpProtocol, "IPv4,IPv6", sizeof("IPv4,IPv6"))) {
					entry.ipProtocol = IPVER_IPV4_IPV6;
				}
				else {
					ERR_MSG("Invalid IpProtocol");
					return;
				}
			}
			else {
				entry.ipProtocol = IPVER_IPV4;
			}
		#endif
		
			if(!mib_chain_update(MIB_IP_QOS_CLASSFICATION_TBL, &entry,pos)){
					ERR_MSG("mib Error: qos规则编辑失败"); //mib Error: Cannot add new one qos rule.
					return;
			}	
			log_QosClsRule("Update", &entry);
			QosClassficationToQosRule(QOSCLASSFICATION_TO_QOSRULE_ACTION_MODIFY,entry.cls_id);
		}
	}else if(!strncmp(action,"delQosClsRule",strlen("delQosClsRule"))){
		/*from ClsDelNo9 to ClsDelNo0*/
		int i=MAX_QOS_CLASSFICATION_NUM-1;
		for(;i>=0;i--){
			char clsdelstr[16]={0};
			sprintf(clsdelstr,"ClsDelNo%d",i);
			char* delNoStr = boaGetVar(wp, clsdelstr, "-1");
			printf("clsdelstr=%s delNoStr=%s\n",clsdelstr,delNoStr);
			if(!strcmp(delNoStr,"Yes")){
				int delNo = i;
				printf("delNo=%d \n",delNo);
				//clean up the clstype rule in this cls
				int totalQosRuleNums=mib_chain_total(MIB_IP_QOS_CLASSFICATIONTYPE_TBL);
				int qosRuleIdx = 0;
				int ClsIndexOfClassQueue =delNo ;
				for(qosRuleIdx=(totalQosRuleNums-1);qosRuleIdx>=0;qosRuleIdx--){
						MIB_CE_IP_QOS_CLASSFICATIONTYPE_T qosentry;
						mib_chain_get(MIB_IP_QOS_CLASSFICATIONTYPE_TBL,qosRuleIdx,&qosentry);						
						if(qosentry.cls_id==ClsIndexOfClassQueue){
							mib_chain_delete(MIB_IP_QOS_CLASSFICATIONTYPE_TBL,qosRuleIdx);
						}
					
				}
				
				int totalClsRuleNums=mib_chain_total(MIB_IP_QOS_CLASSFICATION_TBL);
				int clsRuleIdx=0;
				for(clsRuleIdx=0;clsRuleIdx<totalClsRuleNums;clsRuleIdx++){
						MIB_CE_IP_QOS_CLASSFICATION_T clsentry;
						mib_chain_get(MIB_IP_QOS_CLASSFICATION_TBL,clsRuleIdx,&clsentry);						
						if(clsentry.cls_id==ClsIndexOfClassQueue){
							mib_chain_delete(MIB_IP_QOS_CLASSFICATION_TBL,clsRuleIdx);
							log_QosClsRule("Delete", &clsentry);
							break;
						}
				}
				//MIB_CE_IP_QOS_CLASSFICATION_T cls_entry;
				//mib_chain_get(MIB_IP_QOS_CLASSFICATION_TBL,delNo,&cls_entry);
				//cls_entry.cls_id = 0xff;
				//mib_chain_update(MIB_IP_QOS_CLASSFICATION_TBL,&cls_entry, delNo);
				////mib_chain_d
				QosClassficationToQosRule(QOSCLASSFICATION_TO_QOSRULE_ACTION_DEL,ClsIndexOfClassQueue);
			}
		}
	}else if(!strncmp(action,"addQosTypeRule",strlen("addQosTypeRule"))||!strncmp(action,"editQosTypeRule",strlen("editQosTypeRule"))){
			char *MinStr,*MaxStr,*TypeStr,*ProtocolListStr;
			int ClsIndexOfClassQueue=0;
			char *ClsIndexOfClassQueueStr ;
			TypeStr = boaGetVar(wp, "Type", "-1");
			char* EditClsTypeIndexStr;
			int edit=0;
			
			
			ClsIndexOfClassQueueStr = boaGetVar(wp, "ClsIndexOfClassQueue", NULL);
			if(ClsIndexOfClassQueueStr)
				ClsIndexOfClassQueue =atoi(ClsIndexOfClassQueueStr);
			if(!strncmp(action,"editQosTypeRule",strlen("editQosTypeRule"))){
				//on do in edit mode
				EditClsTypeIndexStr = boaGetVar(wp, "EditClsTypeIndex",NULL);
				if(EditClsTypeIndexStr){
					int EditClsTypeIndex=atoi(EditClsTypeIndexStr);
					EditClsTypeIndex=EditClsTypeIndex%MAX_QOS_RULE_NUM_ONE_CLASSFICATION;
					printf("%s %d EditClsTypeIndex=%d ClsIndexOfClassQueue=%d\n",__FUNCTION__,__LINE__,EditClsTypeIndex,ClsIndexOfClassQueue);
					//deletet the old clstype rule
					int totalQosRuleNums=mib_chain_total(MIB_IP_QOS_CLASSFICATIONTYPE_TBL);
					int qosRuleIdx = 0;
					int qosentryno=-1;
					for(qosRuleIdx=0;qosRuleIdx<totalQosRuleNums;qosRuleIdx++){
							MIB_CE_IP_QOS_CLASSFICATIONTYPE_T qosentry;
							mib_chain_get(MIB_IP_QOS_CLASSFICATIONTYPE_TBL,qosRuleIdx,&qosentry);						
							if(qosentry.cls_id==ClsIndexOfClassQueue){
								qosentryno++;
								if(qosentryno==EditClsTypeIndex){													
									mib_chain_delete(MIB_IP_QOS_CLASSFICATIONTYPE_TBL,qosRuleIdx);
									break;
								}
					
						}
					}
						
				}
				edit = 1;
			}
			
			MIB_CE_IP_QOS_CLASSFICATIONTYPE_T entry;
			bzero(&entry, sizeof(MIB_CE_IP_QOS_CLASSFICATIONTYPE_T));
			entry.cls_id =ClsIndexOfClassQueue;
			ProtocolListStr = boaGetVar(wp, "ProtocolList", NULL);
			if(ProtocolListStr)
				entry.protoType = getProtoType(ProtocolListStr);
		#ifndef CONFIG_USER_AP_E8B_QOS
			if(!strcmp(TypeStr,"TOS")||!strcmp(TypeStr,"WANInterface")||!strcmp(TypeStr,"LANInterface"))
				entry.classficationType =1<<getQosClassficationType(TypeStr, ""); 
		#endif
			entryNum = mib_chain_total(MIB_IP_QOS_CLASSFICATIONTYPE_TBL);
	
			if( entryNum>=MAX_QOS_CLASSFICATIONTYPE_NUM)
			{
				ERR_MSG("伫列规则数目已达上限."); //You cannot add one new rule when queue is full.
				return;
			}
		#if defined(CONFIG_USER_AP_E8B_QOS)
			if(!strcmp(TypeStr,"SIP")||!strcmp(TypeStr,"DIP")||!strcmp(TypeStr,"SMAC")||!strcmp(TypeStr,"DMAC")||
			   !strcmp(TypeStr,"8021P")||!strcmp(TypeStr,"SPORT")||!strcmp(TypeStr,"DPORT")||!strcmp(TypeStr,"DSCP")
			  	||!strcmp(TypeStr,"EtherType") || !strcmp(TypeStr,"TOS") || !strcmp(TypeStr,"LANInterface") || !strcmp(TypeStr,"WANInterface")
			  	||!strcmp(TypeStr,"SIP6")||!strcmp(TypeStr,"DIP6") || !strcmp(TypeStr,"TrafficClass") || !strcmp(TypeStr,"FlowLabel"))
		#else
			
			if(!strcmp(TypeStr,"SIP")||!strcmp(TypeStr,"DIP")||!strcmp(TypeStr,"SMAC")||!strcmp(TypeStr,"DMAC")||
			   !strcmp(TypeStr,"8021P")||!strcmp(TypeStr,"SPORT")||!strcmp(TypeStr,"DPORT")||!strcmp(TypeStr,"DSCP")
			  	||!strcmp(TypeStr,"EtherType"))
		#endif		
				{
					printf("%s %d\n",__FUNCTION__,__LINE__);
					MinStr = boaGetVar(wp, "Min", NULL);
					MaxStr = boaGetVar(wp, "Max", NULL);
					if(!MinStr||!MaxStr)
					{
						ERR_MSG("参数错误."); //You cannot add one new rule when queue is full.
						return;
					}	
					entry.classficationType =1<<getQosClassficationType(TypeStr, MinStr); 
					//reset to zero
					switch(entry.classficationType){
						case (1<<IP_QOS_CLASSFICATIONTYPE_SMAC):	
							{
								int idx = 0;
								char buff[32]={0};
								char* p=MinStr;
								for(idx=0; *p != '\0'&&idx<32; ++p) {
									if (*p!=':')
										buff[idx++] = *p;
								}
								rtk_string_to_hex(buff, entry.smac, 12);
								printf("%s %d##################\n",__FUNCTION__,__LINE__);
								p=MaxStr;
								for(idx=0; *p != '\0'&&idx<32; ++p) {
									if (*p!=':')
										buff[idx++] = *p;
								}
								rtk_string_to_hex(buff, entry.smac_end, 12);
							}
		
							break;
						case (1<<IP_QOS_CLASSFICATIONTYPE_DMAC):
							{
								int idx = 0;
								char buff[32]={0};
								char* p=MinStr;
								for(idx=0; *p != '\0'&&idx<32; ++p) {
									if (*p!=':')
										buff[idx++] = *p;
								}
								rtk_string_to_hex(buff, entry.dmac, 12);
								printf("%s %d##################\n",__FUNCTION__,__LINE__);
								p=MaxStr;
								for(idx=0; *p != '\0'&&idx<32; ++p) {
									if (*p!=':')
										buff[idx++] = *p;
								}
								rtk_string_to_hex(buff, entry.dmac_end, 12);
							}
							break;
						case (1<<IP_QOS_CLASSFICATIONTYPE_8021P):
							entry.vlan1p = atoi(MinStr);
							entry.vlan1p_end = atoi(MaxStr);
							break;
						case (1<<IP_QOS_CLASSFICATIONTYPE_SIP):						
							inet_aton(MinStr, (struct in_addr *)&entry.sip);
							inet_aton(MaxStr, (struct in_addr *)&entry.sip_end);
							break;
						case (1<<IP_QOS_CLASSFICATIONTYPE_DIP):						
							inet_aton(MinStr, (struct in_addr *)&entry.dip);
							inet_aton(MaxStr, (struct in_addr *)&entry.dip_end);
							break;
						case (1<<IP_QOS_CLASSFICATIONTYPE_SPORT):
							entry.sPort = atoi(MinStr);
							entry.sPortRangeMax = atoi(MaxStr);
							break;
						case (1<<IP_QOS_CLASSFICATIONTYPE_DPORT):
							entry.dPort = atoi(MinStr);
							entry.dPortRangeMax = atoi(MaxStr);
							break;
						case (1<<IP_QOS_CLASSFICATIONTYPE_TOS):	
						#ifdef CONFIG_USER_AP_E8B_QOS
							entry.tos = atoi(MinStr);
							entry.tos_end = atoi(MaxStr);
						#endif
							break;
						case (1<<IP_QOS_CLASSFICATIONTYPE_DSCP):
							entry.qosDscp = atoi(MinStr);
							entry.qosDscp_end= atoi(MaxStr);
							break;
#ifdef CONFIG_IPV6
						case (1<<IP_QOS_CLASSFICATIONTYPE_SIP6):						
							inet_pton(AF_INET6, MinStr, (void *)&entry.sip6);
						#ifdef CONFIG_USER_AP_E8B_QOS
							inet_pton(AF_INET6, MaxStr, (void *)&entry.sip6_end);
						#endif
							break;
						case (1<<IP_QOS_CLASSFICATIONTYPE_DIP6):						
							inet_pton(AF_INET6, MinStr, (void *)&entry.dip6);
						#ifdef CONFIG_USER_AP_E8B_QOS
							inet_pton(AF_INET6, MaxStr, (void *)&entry.dip6_end);
						#endif
							break;
					#ifndef CONFIG_USER_AP_CT_QOS
						case (1<<IP_QOS_CLASSFICATIONTYPE_SPORT6):
							entry.sPort6 = atoi(MinStr);
							entry.sPort6RangeMax = atoi(MaxStr);
							break;
						case (1<<IP_QOS_CLASSFICATIONTYPE_DPORT6):
							entry.dPort6 = atoi(MinStr);
							entry.dPort6RangeMax = atoi(MaxStr);
							break;
					#endif
					#ifdef CONFIG_USER_AP_E8B_QOS
						case (1<<IP_QOS_CLASSFICATIONTYPE_FlowLabel):
							entry.flowlabel = atoi(MinStr);
							entry.flowlabel_end = atoi(MaxStr);
							break;
					#endif
						case (1<<IP_QOS_CLASSFICATIONTYPE_TrafficClass):
							entry.tc = atoi(MinStr);
							entry.tc_end= atoi(MaxStr);
							break;
#endif
						case (1<<IP_QOS_CLASSFICATIONTYPE_WANINTERFACE):
					#ifdef CONFIG_USER_AP_E8B_QOS
							entry.wanitf = atoi(MinStr);
					#endif
							break;
						case (1<<IP_QOS_CLASSFICATIONTYPE_LANINTERFACE):
					#ifdef CONFIG_USER_AP_E8B_QOS
							entry.phyPort = atoi(MinStr);
							entry.phyPort_end = atoi(MaxStr);
					#endif
							break;
						case (1<<IP_QOS_CLASSFICATIONTYPE_ETHERTYPE):
							if(!strcmp(MinStr,"IPv4"))
								entry.ethType=0x0800;
							else if(!strcmp(MinStr,"IPv6"))
								entry.ethType=0x86dd;
							break;
						default:
							break;			
			
					}
				}
			#ifndef CONFIG_USER_AP_E8B_QOS
				else if(!strcmp(TypeStr,"TOS")){
						char* tosStr = boaGetVar(wp, "Tos", NULL);
						if(tosStr)
							entry.tos = atoi(tosStr);
				}
			#endif
				else if(!strcmp(TypeStr,"WANInterface")){
						char* TypeWanInterFaceMinStr = boaGetVar(wp, "TypeWanInterFaceMin", NULL);						
						if(TypeWanInterFaceMinStr)
							entry.wanitf = atoi(TypeWanInterFaceMinStr);
				}else if(!strcmp(TypeStr,"LANInterface")){
						char* TypeLanInterFaceMinStr = boaGetVar(wp, "TypeLanInterFaceMin", NULL);										
						if(TypeLanInterFaceMinStr)
								entry.phyPort = atoi(TypeLanInterFaceMinStr);
						char* TypeLanInterFaceMaxStr = boaGetVar(wp, "TypeLanInterFaceMax", NULL);										
						if(TypeLanInterFaceMaxStr)
								entry.phyPort_end = atoi(TypeLanInterFaceMaxStr);
				}
				
				entry.InstanceNum = find_max_classification_type_instanNum_by_clsid(entry.cls_id) + 1;

				if(!mib_chain_add(MIB_IP_QOS_CLASSFICATIONTYPE_TBL, &entry))
				{
					ERR_MSG("mib Error: qos规则加入失败"); //mib Error: Cannot add new one qos rule.
					return;
				}

				syslog(LOG_INFO, "QosClassficationRule: %s QosTypeRule", edit? "Update":"Add");
			
				QosClassficationToQosRule(QOSCLASSFICATION_TO_QOSRULE_ACTION_MODIFY,ClsIndexOfClassQueue);
			
	}else if(!strncmp(action,"delQosTypeRule",strlen("delQosTypeRule"))){
			char* ClsIndexOfClassQueueStr;
			int ClsIndexOfClassQueue=0;
			ClsIndexOfClassQueueStr = boaGetVar(wp, "ClsIndexOfClassQueue", NULL);
			if(ClsIndexOfClassQueueStr)
				ClsIndexOfClassQueue =atoi(ClsIndexOfClassQueueStr);
			int delNo=0;
			for(delNo=MAX_QOS_RULE_NUM_ONE_CLASSFICATION-1;delNo>=0;delNo--){
				char delflags[32]={0};
				sprintf(delflags,"TypeDelFlag%d",delNo);
				char* TypeDelFlagStr = boaGetVar(wp, delflags, NULL);
				if(TypeDelFlagStr&&!strcmp(TypeDelFlagStr,"Yes")){
					printf("%s=TypeDelFlagStr=%s\n",delflags,TypeDelFlagStr);
					int totalQosRuleNums=mib_chain_total(MIB_IP_QOS_CLASSFICATIONTYPE_TBL);
					int qosRuleIdx = 0;
					int qosentryno=-1;
					for(qosRuleIdx=0;qosRuleIdx<totalQosRuleNums;qosRuleIdx++){
						MIB_CE_IP_QOS_CLASSFICATIONTYPE_T qosentry;
						mib_chain_get(MIB_IP_QOS_CLASSFICATIONTYPE_TBL,qosRuleIdx,&qosentry);						
						if(qosentry.cls_id==ClsIndexOfClassQueue){
							qosentryno++;
							if(qosentryno==delNo){
								printf("%s %d delete MIB_IP_QOS_CLASSFICATIONTYPE_TBL \n",__FUNCTION__,__LINE__);
								mib_chain_delete(MIB_IP_QOS_CLASSFICATIONTYPE_TBL,qosRuleIdx);								
								syslog(LOG_INFO, "QosClassficationRule: Delete QosTypeRule");
								break;
							}
							
						}
					}
				}
				
			}
			QosClassficationToQosRule(QOSCLASSFICATION_TO_QOSRULE_ACTION_MODIFY,ClsIndexOfClassQueue);
	}
	
end:
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif

	//redirect
	printf("%s %d\n",__FUNCTION__,__LINE__);
	url = boaGetVar(wp, "submit-url","");
	if(url[0])
	{
		boaRedirect(wp, url);
	}
	take_qos_effect();
	return;
}

#ifdef CONFIG_USER_AP_E8B_QOS
int updateQoSRuleStatus(void)
{
	int total = mib_chain_total(MIB_IP_QOS_TBL);
	int i = 0, queue_enable;
	
	for(i = 0; i < total; i++) {
		MIB_CE_IP_QOS_T qos_entity;
		memset(&qos_entity, 0, sizeof(qos_entity));
		
		if(!mib_chain_get(MIB_IP_QOS_TBL, i, &qos_entity)) {
			continue;
		}

		queue_enable = getQosQueueEnable(qos_entity.prior);
		
		if(queue_enable != qos_entity.enable) {
			printf("qos rule %d change from %s to %s!\n", i, 
				(qos_entity.enable == 0 ? "disable" : "enable"),  (queue_enable == 0 ? "disable" : "enable"));

			qos_entity.enable = queue_enable;
			if(!mib_chain_update(MIB_IP_QOS_TBL, &qos_entity, i))
			{
				printf("[%s:%d] mib_chain_update MIB_IP_QOS_TBL eror!\n", __FUNCTION__, __LINE__);
				return -1;
			}	
		}
	}

	return 0;
}
#endif
#endif
////////////////////////////////////////////////////////////////////////////////////////////
//Qos Traffic control code

//now the problem is that the ifIndex is used in c code, and ifname is used for displaying,
//how can i get the ifname or ifIndex
int initTraffictlPage(int eid, request * wp, int argc, char **argv)
{
	MIB_CE_IP_TC_T entry;
	int entryNum = 0, i=0, nBytes = 0;
	char sip[20], dip[20], wanname[MAX_WAN_NAME_LEN], *p = NULL;
	unsigned int total_bandwidth = 0;
	unsigned char totalBandWidthEn = 0;
#ifdef CONFIG_IPV6
	unsigned char 	sip6Str[55], dip6Str[55];
#endif

	PRINT_FUNCTION

	entryNum = mib_chain_total(MIB_IP_QOS_TC_TBL);

	if(mib_get_s(MIB_TOTAL_BANDWIDTH, &total_bandwidth, sizeof(total_bandwidth)))
	{
		nBytes += boaWrite(wp, "totalBandwidth=%u;\n", total_bandwidth);
	}
	else
	{
		nBytes += boaWrite(wp, "totalBandwidth=1024;\n");
	}

	if (mib_get_s(MIB_TOTAL_BANDWIDTH_LIMIT_EN, &totalBandWidthEn, sizeof(totalBandWidthEn)))
		nBytes += boaWrite(wp, "totalBandWidthEn=%d;\n", totalBandWidthEn);
	else
		nBytes += boaWrite(wp, "totalBandWidthEn=0;\n");

	if(mib_get(MIB_TOTAL_DOWNSTREAM_BANDWIDTH, &total_bandwidth))
	{
		nBytes += boaWrite(wp, "totalDownstreamBandwidth=%u;\n", total_bandwidth);
	}
	else
	{
		nBytes += boaWrite(wp, "totalDownstreamBandwidth=1024;\n");
	}

	if (mib_get(MIB_TOTAL_DOWNSTREAM_BANDWIDTH_LIMIT_EN, &totalBandWidthEn))
		nBytes += boaWrite(wp, "totalDownstreamBandWidthEn=%d;\n", totalBandWidthEn);
	else
		nBytes += boaWrite(wp, "totalDownstreamBandWidthEn=0;\n");

	for(;i<entryNum; i++)
	{
		MIB_CE_ATM_VC_T       vcEntry;

		if(!mib_chain_get(MIB_IP_QOS_TC_TBL, i, &entry))
			continue;
		wanname[0]='\0';
		if(entry.ifIndex==DUMMY_IFINDEX)
		{
			sprintf(wanname, "any");
		}
		else if(!getWanEntrybyindex(&vcEntry, entry.ifIndex))
		{
			generateWanName(&vcEntry, wanname);
		}
		
		strncpy(sip, inet_ntoa(*((struct in_addr*)&entry.srcip)), INET_ADDRSTRLEN);
		strncpy(dip, inet_ntoa(*((struct in_addr*)&entry.dstip)), INET_ADDRSTRLEN);
		if(entry.smaskbits)
		{
			p = sip + strlen(sip);
			snprintf(p,sizeof(sip)-strlen(sip), "/%d", entry.smaskbits );
		}

		if(entry.dmaskbits)
		{
			p = dip + strlen(dip);
			snprintf(p,sizeof(dip)-strlen(dip), "/%d", entry.dmaskbits );
		}

#ifdef CONFIG_IPV6
		inet_ntop(PF_INET6, (struct in6_addr *)entry.sip6, sip6Str, sizeof(sip6Str));
		if(entry.sip6PrefixLen)
		{
			p = sip6Str + strlen(sip6Str);
			snprintf(p,sizeof(sip6Str)-strlen(sip6Str), "/%d", entry.sip6PrefixLen );
		}

		inet_ntop(PF_INET6, (struct in6_addr *)entry.dip6, dip6Str, sizeof(dip6Str));
		if(entry.dip6PrefixLen)
		{
			p = dip6Str + strlen(dip6Str);
			snprintf(p,sizeof(dip6Str)-strlen(dip6Str), "/%d", entry.dip6PrefixLen );
		}
#endif

		nBytes += boaWrite(wp, "traffictlRules.push(new it_nr(\"\",\n"
#ifdef CONFIG_IPV6
			//"new it(\"ipversion\",%d),\n"  //ipv4 or ipv6
			"new it(\"IpProtocolType\",%d),\n"  //ipv4 or ipv6
			"new it(\"sip6\",  \"%s\"),\n" //source ip6
			"new it(\"dip6\",  \"%s\"),\n" //dst ip6
#endif
			"new it(\"id\",         %d),\n"
			"new it(\"inf\",    \"%s\"),\n"
			"new it(\"proto\",      %d),\n"
			"new it(\"sport\",      %d),\n"
			"new it(\"dport\",      %d),\n"
			"new it(\"srcip\",  \"%s\"),\n"
			"new it(\"dstip\",  \"%s\"),\n"
			"new it(\"rate\",  \"%d\"),\n"
			"new it(\"direction\",   %d)));\n",
#ifdef CONFIG_IPV6
			entry.IpProtocol, sip6Str, dip6Str,
#endif
			entry.entryid, wanname, entry.protoType, entry.sport,
			entry.dport, sip, dip, entry.limitSpeed,entry.direction);
	}

	return nBytes;
}

void formQosTraffictl(request * wp, char *path, char *query)
{
	char *action = NULL, *url = NULL;
	char *act1="applybandwidth", *act2 = "applysetting";
	char *act4="cancelbandwidth";
	char *act5="applydownstreambandwidth";
	char *act6="canceldownstreambandwidth";
	int entryNum = 0;

	PRINT_FUNCTION

	action = boaGetVar(wp, "lst", "");

	entryNum = mib_chain_total(MIB_IP_QOS_TC_TBL);

	if(action[0])
	{
		if( !strncmp(action, act1, strlen(act1)) )
		{//set total bandwidth
			unsigned int totalbandwidth = 0;
			unsigned char totalbandwidthEn=0;
			char* strbandwidth = NULL;
			strbandwidth = strstr(action, "bandwidth=");
			if(strbandwidth)//found it
			{
				strbandwidth += strlen("bandwidth=");
				totalbandwidth = strtoul(strbandwidth, NULL, 0);

				totalbandwidthEn = 1;
				if (!mib_set(MIB_TOTAL_BANDWIDTH_LIMIT_EN, (void *)&totalbandwidthEn)) {
					ERR_MSG("无法启用整体频宽限制!\n"); //Cannot set total bandwidth Enable into mib setting!
					return;
				}

				if(!mib_set(MIB_TOTAL_BANDWIDTH, (void*)&totalbandwidth))
				{
					ERR_MSG("无法设定整体频宽!\n"); //Cannot set total bandwidth into mib setting!
					return;
				}

				//take effect
				take_qos_effect();
			}
			else {
				totalbandwidthEn = 0;
				if (!mib_set(MIB_TOTAL_BANDWIDTH_LIMIT_EN, (void *)&totalbandwidthEn)) {
					ERR_MSG("无法关闭整体频宽限制!\n"); //Cannot set total bandwidth Disable into mib setting!
					return;
				}
			}
		}
		else if ( !strncmp(action, act4, strlen(act4)) )
		{//cancel total bandwidth restrict
			unsigned char totalbandwidthEn=0;
			if (!mib_set(MIB_TOTAL_BANDWIDTH_LIMIT_EN, (void *)&totalbandwidthEn)) {
				ERR_MSG("无法关闭整体频宽限制!\n"); //Cannot disable total bandwidth restrict into mib setting!
				return;
			}

			//take effect
			take_qos_effect();
		}
		if( !strncmp(action, act5, strlen(act5)) )
		{//set total bandwidth
			unsigned int totaldownstreambandwidth = 0;
			unsigned char totaldownstreambandwidthEn=0;
			char* strdownstreambandwidth = NULL;
			strdownstreambandwidth = strstr(action, "downstreambandwidth=");
			if(strdownstreambandwidth)//found it
			{
				strdownstreambandwidth += strlen("downstreambandwidth=");
				totaldownstreambandwidth = strtoul(strdownstreambandwidth, NULL, 0);

				totaldownstreambandwidthEn = 1;
				if (!mib_set(MIB_TOTAL_DOWNSTREAM_BANDWIDTH_LIMIT_EN, (void *)&totaldownstreambandwidthEn)) {
					ERR_MSG("无法启用整体频宽限制!\n"); //Cannot set total bandwidth Enable into mib setting!
					return;
				}

				if(!mib_set(MIB_TOTAL_DOWNSTREAM_BANDWIDTH, (void*)&totaldownstreambandwidth))
				{
					ERR_MSG("无法设定整体频宽!\n"); //Cannot set total bandwidth into mib setting!
					return;
				}

				//take effect
				take_qos_effect();
			}
			else {
				totaldownstreambandwidthEn = 0;
				if (!mib_set(MIB_TOTAL_DOWNSTREAM_BANDWIDTH_LIMIT_EN, (void *)&totaldownstreambandwidthEn)) {
					ERR_MSG("无法关闭整体频宽限制!\n"); //Cannot set total bandwidth Disable into mib setting!
					return;
				}
			}
		}
		else if ( !strncmp(action, act6, strlen(act6)) )
		{//cancel total bandwidth restrict
			unsigned char totaldownstreambandwidthEn=0;
			if (!mib_set(MIB_TOTAL_DOWNSTREAM_BANDWIDTH_LIMIT_EN, (void *)&totaldownstreambandwidthEn)) {
				ERR_MSG("无法关闭整体频宽限制!\n"); //Cannot disable total bandwidth restrict into mib setting!
				return;
			}

			//take effect
			take_qos_effect();
		}
		else if( !strncmp(action, act2, strlen(act2)) )
		{//delete some
			int idlst[TRAFFICTL_RULE_NUM_MAX+1] = {0};
			int  i=0, j=0, index=1;
			char stridlst[256]={0},err_msg[256], *p = NULL;
			MIB_CE_IP_TC_T entry;

			p = strstr(action, "id=");
			p += strlen("id=");
			if(*p == '\0') {//delete none
				goto done;
			}

			stridlst[0] = '\0';

			strncpy(stridlst, p, sizeof(stridlst)-1);

			//convert the id list, store them in idlst,
			//you can delete most 10 rules at one time
			p = strtok(stridlst, SUBDELIM1);
			if(p) index = atoi(p);
			if(index>0&&index<=TRAFFICTL_RULE_NUM_MAX) idlst[index]=1;
			while((p = strtok(NULL, SUBDELIM1)) != NULL)
			{
				index = atoi(p);
				idlst[index]=1;
				if(index > TRAFFICTL_RULE_NUM_MAX )
					break;
			}

			for(i=entryNum-1; i>=0; i--)
			{
				if(!mib_chain_get(MIB_IP_QOS_TC_TBL, i, &entry))
					continue;

				if( 1 == idlst[entry.entryid]) //delete it
				{
					//delete rules of  tc and iptables
					if(1 != mib_chain_delete(MIB_IP_QOS_TC_TBL, i)) {
						snprintf(err_msg, 256, "删除规则%d错误", entry.entryid); //Error happened when deleting rule
						ERR_MSG(err_msg);
						return;
					}
				}
			}

done:
			take_qos_effect();
		}
	}
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif

	//well, go back
	url = boaGetVar(wp, "submit-url", "");
	if(url[0])
		boaRedirect(wp, url);
	return;
}

//add traffic controlling rules's main function
void formQosTraffictlEdit(request * wp, char *path, char *query)
{
	MIB_CE_IP_TC_T entry;
	char* action=NULL, *url = NULL;
	int entryNum = 0, entryid = 1;
	unsigned char map[TRAFFICTL_RULE_NUM_MAX+1]={0};

	PRINT_FUNCTION

	entryNum = mib_chain_total(MIB_IP_QOS_TC_TBL);

	//You are allowed to have TRAFFICTL_RULE_NUM_MAX rules
	if(entryNum>=TRAFFICTL_RULE_NUM_MAX)
	{
		ERR_MSG("流量控制伫列已满,请删除规则!"); //Traffic controlling queue is full, you must delete some one!
		return;
	}

	action = boaGetVar(wp, "lst", "");

	if(action[0])
	{
		//allocate a free rule id for new entry
		{
			int i = 0;
			for(;i<entryNum;i++)
			{
				if(!mib_chain_get(MIB_IP_QOS_TC_TBL, i, &entry))
					continue;

				map[entry.entryid] = 1;
			}
			for(i=1;i<=TRAFFICTL_RULE_NUM_MAX;i++)
			{
				if(!map[i])
				{
					entryid = i;
					break;
				}
				else if(i==TRAFFICTL_RULE_NUM_MAX)
				{
					ERR_MSG("流量控制伫列已满,请删除规则!"); //Traffic controlling queue is full, you must delete some one!
					return;
				}
			}
		}

		memset(&entry, 0, sizeof(MIB_CE_IP_TC_T));

		entry.entryid = entryid;

		if(parseArgs(action, &entry))
		{//some arguments are wrong
			ERR_MSG("设定错误!"); //Wrong setting is found!
			return;
		}

		PRINT_TRAFFICTL_RULE((&entry));

		#if 0
		/*ql:20080814 START: patch for TnW - while one acl contain other acl, we should change the rule
		* order to enable CAR function.
		*/
		if (entryNum!=0 && !isTraffictlRuleWithPort(&entry)) {
			if (!mib_chain_insert(MIB_IP_QOS_TC_TBL, 0, &entry))
			{
				ERR_MSG("Cannot insert setting into mib!");
				return;
			}
		} else
		#endif
		/*ql:20080814 END*/
		if(!mib_chain_add(MIB_IP_QOS_TC_TBL, &entry))
		{//adding mib setting is wrong
			ERR_MSG("加入失败!"); //Cannot add setting into mib
			return;
		}
	}
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif
	//redirect
	url = boaGetVar(wp, "submit-url", "");
	if(url[0])
	boaRedirect(wp, url);
	return;
}

/******************************************************************
 * NAME:     formQosRule
 * DESC:     main function deal with qos rules, delete and change
 * ARGS:
 * RETURN:
 ******************************************************************/
void formQosRule(request * wp, char* path, char* query)
{
	MIB_CE_IP_QOS_T entry;
	int entryNum=0, i=0, id = 0;
	unsigned char statuslist[QUEUE_RULE_NUM_MAX+1] = {0}, dellist[QUEUE_RULE_NUM_MAX+1]= {0};
	char* action = NULL, *p=NULL, *url = NULL;

	PRINT_FUNCTION

	//abstract args from string
	action = boaGetVar(wp, "lst", "");
	entryNum = mib_chain_total(MIB_IP_QOS_TBL);
	
	p = strtok(action, ",&");
	if(p) id = atoi(p);
	if(id<0||id>QUEUE_RULE_NUM_MAX)
		goto END;
	p = strtok(NULL, ",&");
	if(p) statuslist[id] = !!atoi(p);
	p = strtok(NULL, ",&");
	if(p) dellist[id] = !!atoi(p);

	while( (p = strtok(NULL, ",&")) != NULL )
	{
		id = atoi(p);
		if(id<0||id>QUEUE_RULE_NUM_MAX) continue;
		p = strtok(NULL, ",&");
		if(p) statuslist[id] = !!atoi(p);
		p = strtok(NULL, ",&");
		if(p) dellist[id] = !!atoi(p);
	}
#ifndef CONFIG_CU
    /*This check may cause, hide rule change to disable, statuslist[i] default value is 0*/
	//change status of rules if neccessary
	//printf("check statuslist\n");
	for(i=0;i<entryNum;i++)
	{
		if(!mib_chain_get(MIB_IP_QOS_TBL, i, &entry))
			continue;

		if(statuslist[i] != entry.enable)
		{
			//printf("entry %d status changed\n", i);
			entry.enable = statuslist[i];
			if(!mib_chain_update(MIB_IP_QOS_TBL, &entry, i))
			{
				ERR_MSG("更新规则失败!"); //updating rule error!
				return;
			}
		}
	}
#endif
	//printf("check deletelist!\n");
	//delete some one
	for(i=entryNum-1;i>=0;i--)
	{
		if(!mib_chain_get(MIB_IP_QOS_TBL, i, &entry))
			continue;
		if(i<=QUEUE_RULE_NUM_MAX&&dellist[i])
		{
			//printf("entry %d deleted\n", i);
			if(1 != mib_chain_delete(MIB_IP_QOS_TBL, i))
			{
				ERR_MSG("删除规则失败!"); //Delete rule error!
				return;
			}
		}
	}

	//take effect
	take_qos_effect();

#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif

END:
	//redirect to show page
	url = boaGetVar(wp, "submit-url", "");
	if(url[0])
	{
		boaRedirect(wp, url);
	}
	return;
}
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC) || defined(CONFIG_USER_AP_E8B_QOS)
#if MAX_QOS_QUEUE_NUM==8
char* priorityQueueName[8]={"最高","较高","高","次高","中","次中","低","最低"};
#elif MAX_QOS_QUEUE_NUM==4
char* priorityQueueName[4]={"最高","高","中","低"};
#else
#error "please define MAX_QOS_QUEUE_NUM as 4 or 8"
#endif

int getQosClassficaitonQueueArray(int eid, request * wp, int argc, char **argv){
	MIB_CE_IP_QOS_CLASSFICATION_T entry;
	int entryNum = 0;
	int i=0;	
#ifdef CONFIG_USER_AP_CT_QOS
	char *strProto;
#endif

	entryNum = mib_chain_total(MIB_IP_QOS_CLASSFICATION_TBL);
	for (i =0;i< entryNum; i++) {
		if (!mib_chain_get(MIB_IP_QOS_CLASSFICATION_TBL, i, &entry)) {
		#ifndef CONFIG_USER_AP_CT_QOS
			boaWrite(wp,"[\"N/A\",\"N/A\",\"N/A\",\"N/A\"]");
		#else
			boaWrite(wp,"[\"N/A\",\"N/A\",\"N/A\",\"N/A\",\"N/A\"]");
		#endif
		}else{
		#ifndef CONFIG_USER_AP_CT_QOS
			boaWrite(wp,"[\"%d\",\"%d\",\"%d\",\"%d\"]", entry.cls_id, entry.queue,entry.m_dscp,entry.m_1p);
		#else
			strProto = "IPv4";
		#ifdef CONFIG_IPV6
			switch(entry.ipProtocol) {
			case IPVER_IPV6:
				strProto = "IPv6";
				break;
			case IPVER_IPV4_IPV6:
				strProto = "IPv4,IPv6";
				break;
			default:
				break;
			}
		#endif
		
			boaWrite(wp,"[\"%d\",\"%d\",\"%d\",\"%d\",\"%s\"]", entry.cls_id, entry.queue,entry.m_dscp,entry.m_1p,strProto);
		#endif
		}
		if(i!=(MAX_QOS_CLASSFICATION_NUM-1))
			boaWrite(wp,",");
		boaWrite(wp,"\n");
	}
	for(;entryNum<MAX_QOS_CLASSFICATION_NUM;entryNum++){
	#ifndef CONFIG_USER_AP_CT_QOS
		boaWrite(wp,"[\"N/A\",\"N/A\",\"N/A\",\"N/A\"]");
	#else
		boaWrite(wp,"[\"N/A\",\"N/A\",\"N/A\",\"N/A\",\"N/A\"]");
	#endif
		if(entryNum!=(MAX_QOS_CLASSFICATION_NUM-1))
			boaWrite(wp,",");
		boaWrite(wp,"\n");
	}
	return 0;

}


int getQosTypeQueueArray(int eid, request * wp, int argc, char **argv){
	MIB_CE_IP_QOS_CLASSFICATION_T entry;
	int entryNum = 0;
	int i=0;	
	int qos_classfication_index = 0;
	entryNum = mib_chain_total(MIB_IP_QOS_CLASSFICATION_TBL);
	for (qos_classfication_index = IP_QOS_CLASSFICATION_ID_START; qos_classfication_index < entryNum; qos_classfication_index++) {
		int totalQosRuleNum = mib_chain_total(MIB_IP_QOS_CLASSFICATIONTYPE_TBL);
		MIB_CE_IP_QOS_CLASSFICATIONTYPE_T qosentry;
		int j = 0;
		int totalQosRuleNumInOneClassfication = 0;
		MIB_CE_IP_QOS_CLASSFICATION_T clsentry;
		mib_chain_get(MIB_IP_QOS_CLASSFICATION_TBL,qos_classfication_index,&clsentry);
		for(j=0;j<totalQosRuleNum;j++){
			mib_chain_get(MIB_IP_QOS_CLASSFICATIONTYPE_TBL,j,&qosentry);
			if (qosentry.classficationType == 0) continue;
			if(qosentry.cls_id==clsentry.cls_id){
				boaWrite(wp,"vActObj[ClsCnttemp++] = new QosTypeConstruction(\"%d\",\"%s\",",clsentry.cls_id,ip_qos_classficationtype_str[getBitPos(qosentry.classficationType)]);
				switch(qosentry.classficationType){
					case (1<<IP_QOS_CLASSFICATIONTYPE_SMAC):	
						{
							char smacaddr_end[32]={0};
							snprintf(smacaddr_end, 18, "%02x:%02x:%02x:%02x:%02x:%02x",
							qosentry.smac_end[0],qosentry.smac_end[1],
							qosentry.smac_end[2], qosentry.smac_end[3],
							qosentry.smac_end[4], qosentry.smac_end[5]);
							boaWrite(wp,"\"%s\",",smacaddr_end);
							
							char smacaddr[32]={0};
							snprintf(smacaddr, 18, "%02x:%02x:%02x:%02x:%02x:%02x",
							qosentry.smac[0],qosentry.smac[1],
							qosentry.smac[2], qosentry.smac[3],
							qosentry.smac[4], qosentry.smac[5]);
							boaWrite(wp,"\"%s\",",smacaddr);
						}
						break;
					case (1<<IP_QOS_CLASSFICATIONTYPE_DMAC):
						{
							char dmacaddr_end[32]={0};
							snprintf(dmacaddr_end, 18, "%02x:%02x:%02x:%02x:%02x:%02x",
							qosentry.dmac_end[0],qosentry.dmac_end[1],
							qosentry.dmac_end[2], qosentry.dmac_end[3],
							qosentry.dmac_end[4], qosentry.dmac_end[5]);
							boaWrite(wp,"\"%s\",",dmacaddr_end);
							
							char dmacaddr[32]={0};
							snprintf(dmacaddr, 18, "%02x:%02x:%02x:%02x:%02x:%02x",
							qosentry.dmac[0],qosentry.dmac[1],
							qosentry.dmac[2], qosentry.dmac[3],
							qosentry.dmac[4], qosentry.dmac[5]);
							boaWrite(wp,"\"%s\",",dmacaddr);
						}
						break;
					case (1<<IP_QOS_CLASSFICATIONTYPE_8021P):
						boaWrite(wp,"\"%d\",",qosentry.vlan1p_end);
						boaWrite(wp,"\"%d\",",qosentry.vlan1p);
						break;
					case (1<<IP_QOS_CLASSFICATIONTYPE_SIP):						
						boaWrite(wp,"\"%s\",",inet_ntoa(*((struct in_addr*)&(qosentry.sip_end))));
						boaWrite(wp,"\"%s\",",inet_ntoa(*((struct in_addr*)&(qosentry.sip))));
						break;
					case (1<<IP_QOS_CLASSFICATIONTYPE_DIP):						
						boaWrite(wp,"\"%s\",",inet_ntoa(*((struct in_addr*)&(qosentry.dip_end))));
						boaWrite(wp,"\"%s\",",inet_ntoa(*((struct in_addr*)&(qosentry.dip))));
						break;
					case (1<<IP_QOS_CLASSFICATIONTYPE_SPORT):
						boaWrite(wp,"\"%d\",",qosentry.sPortRangeMax);
						boaWrite(wp,"\"%d\",",qosentry.sPort);
						break;
				#ifndef CONFIG_USER_AP_CT_QOS
					case (1<<IP_QOS_CLASSFICATIONTYPE_SPORT | 1<<IP_QOS_CLASSFICATIONTYPE_SPORT6):
						boaWrite(wp,"\"%d\",",qosentry.sPortRangeMax);
						boaWrite(wp,"\"%d\",",qosentry.sPort);
						break;	
				#endif
					case (1<<IP_QOS_CLASSFICATIONTYPE_DPORT):
						boaWrite(wp,"\"%d\",",qosentry.dPortRangeMax);
						boaWrite(wp,"\"%d\",",qosentry.dPort);
						break;
				#ifndef CONFIG_USER_AP_CT_QOS
					case (1<<IP_QOS_CLASSFICATIONTYPE_DPORT | 1<<IP_QOS_CLASSFICATIONTYPE_DPORT6):
						boaWrite(wp,"\"%d\",",qosentry.dPortRangeMax);
						boaWrite(wp,"\"%d\",",qosentry.dPort);
						break;
				#endif
					case (1<<IP_QOS_CLASSFICATIONTYPE_TOS):
					#if defined(CONFIG_USER_AP_E8B_QOS)
						boaWrite(wp,"\"%d\",",qosentry.tos_end);
					#else
						boaWrite(wp,"\"%d\",",qosentry.tos);
					#endif
						boaWrite(wp,"\"%d\",",qosentry.tos);
						break;
					case (1<<IP_QOS_CLASSFICATIONTYPE_DSCP):
						boaWrite(wp,"\"%d\",",qosentry.qosDscp_end);
						boaWrite(wp,"\"%d\",",qosentry.qosDscp);
						break;
				#ifndef CONFIG_USER_AP_CT_QOS
					case (1<<IP_QOS_CLASSFICATIONTYPE_DSCP | 1<<IP_QOS_CLASSFICATIONTYPE_TrafficClass):
						boaWrite(wp,"\"%d\",",qosentry.qosDscp_end);
						boaWrite(wp,"\"%d\",",qosentry.qosDscp);
						break;
				#endif
#ifdef CONFIG_IPV6
					case (1<<IP_QOS_CLASSFICATIONTYPE_SIP6):					
						{
							char sip6Str[INET6_ADDRSTRLEN] = "";
						#ifdef CONFIG_USER_AP_E8B_QOS
							char sip6Str_end[INET6_ADDRSTRLEN] = "";
						#endif
							inet_ntop(AF_INET6, (const void *)&(qosentry.sip6), sip6Str, INET6_ADDRSTRLEN);
						#ifndef CONFIG_USER_AP_E8B_QOS
							boaWrite(wp,"\"%s\",", sip6Str);
						#else
							inet_ntop(AF_INET6, (const void *)&(qosentry.sip6_end), sip6Str_end, INET6_ADDRSTRLEN);
							boaWrite(wp,"\"%s\",", sip6Str_end);
						#endif
							boaWrite(wp,"\"%s\",", sip6Str);
						}
						break;
					case (1<<IP_QOS_CLASSFICATIONTYPE_DIP6):					
						{
							char dip6Str[INET6_ADDRSTRLEN] = "";
						#ifdef CONFIG_USER_AP_E8B_QOS
							char dip6Str_end[INET6_ADDRSTRLEN] = "";
						#endif
							inet_ntop(AF_INET6, (const void *)&(qosentry.dip6), dip6Str, INET6_ADDRSTRLEN);
						#ifndef CONFIG_USER_AP_E8B_QOS
							boaWrite(wp,"\"%s\",", dip6Str);
						#else
							inet_ntop(AF_INET6, (const void *)&(qosentry.dip6_end), dip6Str_end, INET6_ADDRSTRLEN);
							boaWrite(wp,"\"%s\",", dip6Str_end);
						#endif
							boaWrite(wp,"\"%s\",", dip6Str);
						}
						break;
				#ifndef CONFIG_USER_AP_CT_QOS
					case (1<<IP_QOS_CLASSFICATIONTYPE_SPORT6):
						boaWrite(wp,"\"%d\",",qosentry.sPort6RangeMax);
						boaWrite(wp,"\"%d\",",qosentry.sPort6);
						break;
					case (1<<IP_QOS_CLASSFICATIONTYPE_DPORT6):
						boaWrite(wp,"\"%d\",",qosentry.dPort6RangeMax);
						boaWrite(wp,"\"%d\",",qosentry.dPort6);
						break;
				#endif
				#ifdef CONFIG_USER_AP_E8B_QOS
					case (1<<IP_QOS_CLASSFICATIONTYPE_FlowLabel):
						boaWrite(wp,"\"%d\",",qosentry.flowlabel_end);
						boaWrite(wp,"\"%d\",",qosentry.flowlabel);
						break;
				#endif
					case (1<<IP_QOS_CLASSFICATIONTYPE_TrafficClass):
						boaWrite(wp,"\"%d\",",qosentry.tc_end);
						boaWrite(wp,"\"%d\",",qosentry.tc);
						break;
#endif
					case (1<<IP_QOS_CLASSFICATIONTYPE_WANINTERFACE):
						{
							MIB_CE_ATM_VC_T entry;
							int i=0;				
							int totalWanItfNum = mib_chain_total(MIB_ATM_VC_TBL);
							for (i = 0; i < totalWanItfNum; i++) {
								if (mib_chain_get(MIB_ATM_VC_TBL, i, &entry)) {
									if(entry.ifIndex!=qosentry.wanitf)
										continue;
								}
							#if defined(CONFIG_USER_AP_E8B_QOS)
								// should return entry.ifIndex
								boaWrite(wp,"\"%d\",", entry.ifIndex);
								boaWrite(wp,"\"%d\",", entry.ifIndex);
							#else
								char wanItfName[MAX_WAN_NAME_LEN]={0};
								getWanName(&entry, wanItfName);
								boaWrite(wp,"\"%s\",",wanItfName);
								boaWrite(wp,"\"%s\",",wanItfName);
							#endif
								break;
							}							
							if(i == totalWanItfNum)
							{
								boaWrite(wp,"\"N/A\",");
								boaWrite(wp,"\"N/A\",");
							}
						}
						break;
					case (1<<IP_QOS_CLASSFICATIONTYPE_LANINTERFACE):
						boaWrite(wp,"\"%d\",",qosentry.phyPort_end);
						boaWrite(wp,"\"%d\",",qosentry.phyPort);
						break;
					case (1<<IP_QOS_CLASSFICATIONTYPE_ETHERTYPE):
						if(qosentry.ethType==0x0800){
							boaWrite(wp,"\"IPv4\",");
							boaWrite(wp,"\"IPv4\",");
						}else if(qosentry.ethType==0x86dd){
							boaWrite(wp,"\"IPv6\",");
							boaWrite(wp,"\"IPv6\",");
						}
						break;
					default:
						break;

				}

				boaWrite(wp,"\"%s\");\n",ip_qos_protocol_str[qosentry.protoType]);
				totalQosRuleNumInOneClassfication++;
			}
		
		}
		while(totalQosRuleNumInOneClassfication<MAX_QOS_RULE_NUM_ONE_CLASSFICATION){
			boaWrite(wp,"vActObj[ClsCnttemp++] = new QosTypeConstruction(\"%d\",\"N/A\",\"N/A\",\"N/A\",\"N/A\");\n",clsentry.cls_id);
			totalQosRuleNumInOneClassfication++;
		}
	}
#if 0	
	for(;entryNum<MAX_QOS_CLASSFICATION_NUM;entryNum++){
		int j = 0;
		for(j=0;j<MAX_QOS_RULE_NUM_ONE_CLASSFICATION;j++){
			boaWrite(wp,"vActObj[ClsCnttemp++] = new QosTypeConstruction(\"%d\",\"N/A\",\"N/A\",\"N/A\",\"N/A\");\n",entryNum);
		}
	}
#endif	
	return 0;

}



#endif

int initQueuePolicy(int eid, request * wp, int argc, char **argv)
{
	unsigned char policy = 0;
	char wanname[32];
	int nBytes=0;
	MIB_CE_IP_QOS_QUEUE_T qEntry;
	int qEntryNum, i;
	unsigned int total_bandwidth = 0;
	unsigned char total_bandwidth_en = 0;
	unsigned char m_dscp_enable = 0;
	unsigned char m_1p_enable = 0;
	unsigned char m_ip_qos_mandatory_bandwidth_en = 0;
	
	PRINT_FUNCTION

	if(mib_get_s(MIB_TOTAL_BANDWIDTH_LIMIT_EN, &total_bandwidth_en, sizeof(total_bandwidth_en)))
	{
		nBytes += boaWrite(wp, "totalBandwidthEnable=%u;\n", total_bandwidth_en);
	}
	else
	{
		nBytes += boaWrite(wp, "totalBandwidthEnable=1024;\n");
	}

	if(mib_get_s(MIB_TOTAL_BANDWIDTH, &total_bandwidth, sizeof(total_bandwidth)))
	{
		nBytes += boaWrite(wp, "totalBandwidth=%u;\n", total_bandwidth);
	}
	else
	{
		nBytes += boaWrite(wp, "totalBandwidth=1024;\n");
	}

	if(!mib_get_s(MIB_QOS_ENABLE_QOS, &policy, sizeof(policy))|| (policy !=0&&policy!=1&&policy!=2))
		policy = 0;
	nBytes += boaWrite(wp, "qosEnable=%d;\n", policy);
	if(!mib_get_s(MIB_QOS_POLICY, &policy, sizeof(policy))|| (policy !=0&&policy!=1&&policy!=2))
		policy = 0;
	nBytes += boaWrite(wp, "policy=%d;\n", policy);

	if(!mib_get_s(MIB_QOS_ENABLE_DSCP_MARK, &m_dscp_enable, sizeof(m_dscp_enable)))
			m_dscp_enable = 0;
	nBytes += boaWrite(wp, "m_dscp_enable=%d;\n", m_dscp_enable);
	
	if(!mib_get_s(MIB_QOS_ENABLE_1P, &m_1p_enable, sizeof(m_1p_enable)))
			m_1p_enable = 0;
	nBytes += boaWrite(wp, "m_1p_enable=%d;\n", m_1p_enable);
	
	if(!mib_get_s(MIB_QOS_ENABLE_FORCE_WEIGHT, &m_ip_qos_mandatory_bandwidth_en, sizeof(m_ip_qos_mandatory_bandwidth_en)))
				m_ip_qos_mandatory_bandwidth_en = 0;	
	nBytes += boaWrite(wp, "m_ip_qos_mandatory_bandwidth_en=%d;\n", m_ip_qos_mandatory_bandwidth_en);

	if((qEntryNum=mib_chain_total(MIB_IP_QOS_QUEUE_TBL)) <=0)
		return nBytes;
	for(i=0;i<qEntryNum; i++)
	{
		if(!mib_chain_get(MIB_IP_QOS_QUEUE_TBL, i, (void*)&qEntry))
			continue;
		nBytes += boaWrite(wp, "queues.push("
			"new it_nr(\"%d\","  //qos queue name
			"new it(\"qname\",\"Q%d\"),"  // name
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)		
			"new it(\"prio\",\"%s\"),"  // priority
#else
			"new it(\"prio\",%d),"  // priority
#endif			
			"new it(\"weight\", %d),"  // weight
			"new it(\"car\", %d),"  // car			
			"new it(\"enable\", %d)));\n",
			i, i+1,
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)	
			//priorityQueueName[(i>4)?4:i]
			priorityQueueName[i]
#else
			i+1
#endif			
			, qEntry.weight, qEntry.car, qEntry.enable);
	}
#if defined(_PRMT_X_CT_COM_DATA_SPEED_LIMIT_)
	unsigned char up_mode;
	//UP
	mib_get_s(MIB_DATA_SPEED_LIMIT_UP_MODE, &up_mode, sizeof(up_mode));
	nBytes += boaWrite(wp, "var up_mode=%d;\n",up_mode);
#endif
	return nBytes;
}

int initDownstreamQueuePolicy(int eid, request * wp, int argc, char **argv)
{
	unsigned char policy = 0;
	char wanname[32];
	int nBytes=0;
	MIB_CE_IP_QOS_QUEUE_T qEntry;
	int qEntryNum, i;
	unsigned int total_bandwidth = 0;
	unsigned char total_bandwidth_en = 0;
	unsigned char m_dscp_enable = 0;
	unsigned char m_1p_enable = 0;
	unsigned char m_ip_qos_mandatory_bandwidth_en = 0;
	
	PRINT_FUNCTION

	if(mib_get_s(MIB_TOTAL_DOWNSTREAM_BANDWIDTH_LIMIT_EN, &total_bandwidth_en, sizeof(total_bandwidth_en)))
	{
		nBytes += boaWrite(wp, "totalBandwidthEnable=%u;\n", total_bandwidth_en);
	}
	else
	{
		nBytes += boaWrite(wp, "totalBandwidthEnable=1024;\n");
	}

	if(mib_get_s(MIB_TOTAL_DOWNSTREAM_BANDWIDTH, &total_bandwidth, sizeof(total_bandwidth)))
	{
		nBytes += boaWrite(wp, "totalBandwidth=%u;\n", total_bandwidth);
	}
	else
	{
		nBytes += boaWrite(wp, "totalBandwidth=1024;\n");
	}

	if(!mib_get_s(MIB_QOS_ENABLE_DOWNSTREAM_QOS, &policy, sizeof(policy))|| (policy !=0&&policy!=1))
		policy = 0;
	nBytes += boaWrite(wp, "qosEnable=%d;\n", policy);
	if(!mib_get_s(MIB_QOS_DOWNSTREAM_POLICY, &policy, sizeof(policy))|| (policy !=0&&policy!=1))
		policy = 0;
	nBytes += boaWrite(wp, "policy=%d;\n", policy);

	if(!mib_get_s(MIB_QOS_ENABLE_DOWNSTREAM_DSCP_MARK, &m_dscp_enable, sizeof(m_dscp_enable)))
		m_dscp_enable = 0;
	nBytes += boaWrite(wp, "m_dscp_enable=%d;\n", m_dscp_enable);
	
	if(!mib_get_s(MIB_QOS_ENABLE_DOWNSTREAM_1P, &m_1p_enable, sizeof(m_1p_enable)))
		m_1p_enable = 0;
	nBytes += boaWrite(wp, "m_1p_enable=%d;\n", m_1p_enable);
	
	if(!mib_get_s(MIB_QOS_ENABLE_DOWNSTREAM_FORCE_WEIGHT, &m_ip_qos_mandatory_bandwidth_en, sizeof(m_ip_qos_mandatory_bandwidth_en)))
		m_ip_qos_mandatory_bandwidth_en = 0;	
	nBytes += boaWrite(wp, "m_ip_qos_mandatory_bandwidth_en=%d;\n", m_ip_qos_mandatory_bandwidth_en);

	if((qEntryNum=mib_chain_total(MIB_IP_QOS_DOWNSTREAM_QUEUE_TBL)) <=0)
		return nBytes;
	for(i=0;i<qEntryNum; i++)
	{
		if(!mib_chain_get(MIB_IP_QOS_DOWNSTREAM_QUEUE_TBL, i, (void*)&qEntry))
			continue;
		nBytes += boaWrite(wp, "queues.push("
			"new it_nr(\"%d\","  //qos queue name
			"new it(\"qname\",\"Q%d\"),"  // name
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)		
			"new it(\"prio\",\"%s\"),"  // priority
#else
			"new it(\"prio\",%d),"  // priority
#endif			
			"new it(\"weight\", %d),"  // weight
			"new it(\"car\", %d),"  // car	
			"new it(\"wifiPrior\", %d),"  // wifiPrior	
			"new it(\"enable\", %d)));\n",
			i, i+1,
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)	
			//priorityQueueName[(i>4)?4:i]
			priorityQueueName[i]
#else
			i+1
#endif			
			, qEntry.weight, qEntry.car, qEntry.wifiPrior, qEntry.enable);
	}
	return nBytes;
}

void formQosPolicy(request * wp, char *path, char *query)
{
	char *action=NULL,*url=NULL, *p=NULL, *tmp=NULL;
	unsigned char policy = 0, modeflag = 0, old_modeflag = 0;
	int num = 0, ret;
	MIB_CE_IP_QOS_QUEUE_T qEntry;
	unsigned char vChar;

	PRINT_FUNCTION

#if defined(CONFIG_USER_IP_QOS) && defined(_PRMT_X_CT_COM_QOS_)
	char *qosmode = NULL;
	char old_mode[MAX_QOS_MODE_LEN] = {0};
	mib_get_s(CTQOS_MODE, old_mode, sizeof(old_mode));

	qosmode = boaGetVar(wp, "TemplateString", "");
	//printf("old_mode = %s, qosmode = %s\n", old_mode, qosmode);
	if (qosmode[0] && strcmp(old_mode, qosmode)) {
		mib_set(CTQOS_MODE, qosmode);
		setMIBforQosMode(qosmode);
		syslog(LOG_INFO, "QoS: Change Template %s", qosmode);
	}
	action = boaGetVar(wp, "enable_force_weight", "");
	if (action[0]) {
		unsigned char value = atoi(action);
		if(!mib_set(MIB_TOTAL_BANDWIDTH_LIMIT_EN, (void *)&value)){
			ERR_MSG("qos force weight启用/关闭设定失败\n"); //Failed to set qos enable/disable force weight.
			return;
		}
	}

	action = boaGetVar(wp, "enable_dscp_remark", "0");
	if (action[0]) {
		unsigned char value = atoi(action);
		if(!mib_set(MIB_QOS_ENABLE_DSCP_MARK, (void *)&value)){
			ERR_MSG("qos差分服务代码点重标记启用/关闭设定失败\n"); //Failed to set qos enable/disable dscp remark.
			return;
		}
	}

	action = boaGetVar(wp, "enable_1p_remark", "");
	if (action[0]) {
		unsigned char value = atoi(action);
		if(!mib_set(MIB_QOS_ENABLE_1P, (void *)&value)){
		ERR_MSG("qos 1p重标记启用/关闭设定失败\n"); //Failed to set qos enable/disable 1p remark.
		return;
		}
	}

#endif

	action = boaGetVar(wp, "qosen", "");
	if (action[0]) {
		policy = (action[0]=='0') ? 0 : 1;
		mib_set(MIB_QOS_ENABLE_QOS, &policy);
	}
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC) || defined(CONFIG_USER_AP_E8B_QOS)
	else{
		policy =0;
		mib_set(MIB_QOS_ENABLE_QOS, &policy);
	}
#endif

	action = boaGetVar(wp, "lst", "");
	printf("policy: %s\n", action);
	if(action[0])
	{
		//policy
		p = strstr(action, "policy=");
		if(p)
		{
			p+=strlen("policy=");
			num = strtol(p, &tmp, 0);
			//if(tmp && tmp !=p && *tmp == DELIM)
			{
				printf("num=%d\n",num);
				policy = num;
				printf("policy=%d\n",policy);
				stopIPQ();
				if(!mib_set(MIB_QOS_POLICY, &policy)) {
					ERR_MSG("qos伫列法则设定失败\n"); //Failed to set qos queue policy.
					return;
				}
			}
		}
	}
	for (num=0; num<MAX_QOS_QUEUE_NUM; num++)
	{
		char wstr[]="w0";
		char qenstr[]="qen0";
		if(!mib_chain_get(MIB_IP_QOS_QUEUE_TBL, num, (void*)&qEntry))
			continue;
		if (policy == 1) { // WRR
			wstr[1] += num;
			p = boaGetVar(wp, wstr, "");
			if (p && p[0])
				qEntry.weight = atoi(p);
		}
		else if(policy == 2) { // CAR
			wstr[1] += num;
			p = boaGetVar(wp, wstr, "");
			if (p && p[0])
				qEntry.car = atoi(p);
		}		
		qenstr[3] += num;
		p = boaGetVar(wp, qenstr, "");
		if (p && p[0]){
			qEntry.enable = 1;
			//ramen 20171016 avoid the weight 0 cause crash
			if (policy == 1&&qEntry.weight ==0) { // WRR
				qEntry.enable = 0;
			}
		}else
			qEntry.enable = 0;
		mib_chain_update(MIB_IP_QOS_QUEUE_TBL, (void *)&qEntry, num);
	}
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC) || defined(CONFIG_USER_AP_E8B_QOS)
	action = boaGetVar(wp, "total_bandwidth", "0");
#else
	action = boaGetVar(wp, "totalbandwidth", "");
#endif
	if (action[0]) {
		unsigned int totalbandwidth = 0;
		totalbandwidth = strtoul(action, NULL, 0);
		if(!mib_set(MIB_TOTAL_BANDWIDTH, (void*)&totalbandwidth))
		{
			ERR_MSG("formQosPolicy: 整体频宽设定失败!\n"); //formQosPolicy: Cannot set total bandwidth into mib setting!
			return;
		}
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC) || defined(CONFIG_USER_AP_E8B_QOS)
		unsigned char totalBandWidthEn = 0;
		mib_get_s(MIB_QOS_ENABLE_QOS, &policy, sizeof(policy));
		if(policy==1){
			totalBandWidthEn = totalbandwidth?1:0;
		}
		else{
			totalBandWidthEn = 0;
		}
		mib_set(MIB_TOTAL_BANDWIDTH_LIMIT_EN, (void *)&totalBandWidthEn);			
#endif

	}
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC) || defined(CONFIG_USER_AP_E8B_QOS)	
	mib_get_s(MIB_QOS_POLICY, &policy, sizeof(policy));
	if(policy==0){
		//PRQ
		//action = boaGetVar(wp, "ip_qos_mandatory_bandwith_en", "");
		action = "";
	}else{
		action = boaGetVar(wp, "ip_qos_mandatory_bandwith_en", "0");
	}
	//printf("policy=%d\n",policy);
	if (action[0]) {
		policy = (action[0]=='0') ? 0 : 1;
		mib_set(MIB_QOS_ENABLE_FORCE_WEIGHT, &policy);
		//printf("ip_qos_mandatory_bandwith_en=%d\n",policy);
		unsigned int totalbandwidth = 0;
		uint queue_weight[MAX_QOS_QUEUE_NUM]={0};
		int totalweight = 0;
		if(mib_get_s(MIB_TOTAL_BANDWIDTH, (void*)&totalbandwidth, sizeof(totalbandwidth))){
			if(!policy)
				totalbandwidth = 0;
			totalbandwidth = totalbandwidth/1024;
			printf("totalbandwidth=%d\n",totalbandwidth);
			for (num=0; num<MAX_QOS_QUEUE_NUM; num++) {
				if(!mib_chain_get(MIB_IP_QOS_QUEUE_TBL, num, (void*)&qEntry))
					continue;
				queue_weight[num]=qEntry.weight;
				totalweight+=queue_weight[num];
			}
			//calc the uprate for each queue according with weight
						
			for (num=0; num<MAX_QOS_QUEUE_NUM; num++) {
				if(!mib_chain_get(MIB_IP_QOS_QUEUE_TBL, num, (void*)&qEntry))
					continue;
				qEntry.upmaxrate=totalbandwidth*queue_weight[num]/totalweight;
				printf("qEntry.upmaxrate=%d\n",qEntry.upmaxrate);
				mib_chain_update(MIB_IP_QOS_QUEUE_TBL,&qEntry,num);
			}
		}
	}else{
			for (num=0; num<MAX_QOS_QUEUE_NUM; num++) {
				if(!mib_chain_get(MIB_IP_QOS_QUEUE_TBL, num, (void*)&qEntry))
					continue;
				qEntry.upmaxrate=0;
				mib_chain_update(MIB_IP_QOS_QUEUE_TBL,&qEntry,num);
			}
	}
#endif

#ifdef CONFIG_USER_AP_E8B_QOS
	updateQoSRuleStatus();
#endif

	mib_get_s(MIB_QOS_ENABLE_QOS, &vChar, sizeof(vChar));
	if(vChar)
		syslog(LOG_INFO, "QoSPolicy: Configuration update");
	else
		syslog(LOG_INFO, "QoSPolicy: Disable");

done:

#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif

	//take effect
	take_qos_effect();

	//redirect web page
	url = boaGetVar(wp, "submit-url", "");
	if(url[0])
	{
		boaRedirect(wp, url);
	}
	return;
}

void formDownstreamQosPolicy(request * wp, char *path, char *query)
{
	char *action=NULL,*url=NULL, *p=NULL, *tmp=NULL;
	unsigned char policy = 0, modeflag = 0, old_modeflag = 0;
	int num = 0, ret;
	MIB_CE_IP_QOS_QUEUE_T qEntry;
	unsigned char vChar;

	PRINT_FUNCTION

#if defined(CONFIG_USER_IP_QOS) && defined(_PRMT_X_CT_COM_QOS_)
	char *qosmode = NULL;
	char old_mode[MAX_QOS_MODE_LEN] = {0};
	mib_get_s(CTQOS_MODE, old_mode, sizeof(old_mode));

	qosmode = boaGetVar(wp, "TemplateString", "");
	//printf("old_mode = %s, qosmode = %s\n", old_mode, qosmode);
	if (qosmode[0] && strcmp(old_mode, qosmode)) {
		mib_set(CTQOS_MODE, qosmode);
		setMIBforQosMode(qosmode);
		syslog(LOG_INFO, "QoS: Change Template %s", qosmode);
	}
	action = boaGetVar(wp, "enable_force_weight", "");
	if (action[0]) {
		unsigned char value = atoi(action);
		if(!mib_set(MIB_TOTAL_DOWNSTREAM_BANDWIDTH_LIMIT_EN, (void *)&value)){
			ERR_MSG("qos force weight启用/关闭设定失败\n"); //Failed to set qos enable/disable force weight.
			return;
		}
	}

	action = boaGetVar(wp, "enable_dscp_remark", "0");
	if (action[0]) {
		unsigned char value = atoi(action);
		if(!mib_set(MIB_QOS_ENABLE_DOWNSTREAM_DSCP_MARK, (void *)&value)){
			ERR_MSG("qos差分服务代码点重标记启用/关闭设定失败\n"); //Failed to set qos enable/disable dscp remark.
			return;
		}
	}

	action = boaGetVar(wp, "enable_1p_remark", "");
	if (action[0]) {
		unsigned char value = atoi(action);
		if(!mib_set(MIB_QOS_ENABLE_DOWNSTREAM_1P, (void *)&value)){
		ERR_MSG("qos 1p重标记启用/关闭设定失败\n"); //Failed to set qos enable/disable 1p remark.
		return;
		}
	}

#endif

	action = boaGetVar(wp, "qosen", "");
	if (action[0]) {
		policy = (action[0]=='0') ? 0 : 1;
		mib_set(MIB_QOS_ENABLE_DOWNSTREAM_QOS, &policy);
	}
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
	else{
		policy =0;
		mib_set(MIB_QOS_ENABLE_DOWNSTREAM_QOS, &policy);
	}
#endif

	action = boaGetVar(wp, "lst", "");
	printf("policy: %s\n", action);
	if(action[0])
	{
		//policy
		p = strstr(action, "policy=");
		if(p)
		{
			p+=strlen("policy=");
			num = strtol(p, &tmp, 0);
			//if(tmp && tmp !=p && *tmp == DELIM)
			{
				printf("num=%d\n",num);
				policy = num;
				printf("policy=%d\n",policy);
				stopIPQ();
				if(!mib_set(MIB_QOS_DOWNSTREAM_POLICY, &policy)) {
					ERR_MSG("qos伫列法则设定失败\n"); //Failed to set qos queue policy.
					return;
				}
			}
		}
	}
	for (num=0; num<MAX_QOS_QUEUE_NUM; num++)
	{
		char wstr[]="w0";
		char qenstr[]="qen0";
		char wifiqstr[]="wifiq0";
		if(!mib_chain_get(MIB_IP_QOS_DOWNSTREAM_QUEUE_TBL, num, (void*)&qEntry))
			continue;
		if (policy == 0) { // SP
			wifiqstr[5] += num;
			p = boaGetVar(wp, wifiqstr, "");
			if (p && p[0])
				qEntry.wifiPrior = atoi(p);
		}
		else if (policy == 1) { // WRR
			wstr[1] += num;
			p = boaGetVar(wp, wstr, "");
			if (p && p[0])
				qEntry.weight = atoi(p);
		}		
		qenstr[3] += num;
		p = boaGetVar(wp, qenstr, "");
		if (p && p[0]){
			qEntry.enable = 1;
			//ramen 20171016 avoid the weight 0 cause crash
			if (policy == 1&&qEntry.weight ==0) { // WRR
				qEntry.enable = 0;
			}
		}else
			qEntry.enable = 0;
		mib_chain_update(MIB_IP_QOS_DOWNSTREAM_QUEUE_TBL, (void *)&qEntry, num);
	}
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
	action = boaGetVar(wp, "total_bandwidth", "0");
#else
	action = boaGetVar(wp, "totalbandwidth", "");
#endif
	if (action[0]) {
		unsigned int totalbandwidth = 0;
		totalbandwidth = strtoul(action, NULL, 0);
		if(!mib_set(MIB_TOTAL_DOWNSTREAM_BANDWIDTH, (void*)&totalbandwidth))
		{
			ERR_MSG("formQosPolicy: 整体频宽设定失败!\n"); //formQosPolicy: Cannot set total bandwidth into mib setting!
			return;
		}
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
		unsigned char totalBandWidthEn = 0;
		mib_get_s(MIB_QOS_ENABLE_DOWNSTREAM_QOS, &policy, sizeof(policy));
		if(policy==1){
			totalBandWidthEn = totalbandwidth?1:0;
		}
		else{
			totalBandWidthEn = 0;
		}
		mib_set(MIB_TOTAL_DOWNSTREAM_BANDWIDTH_LIMIT_EN, (void *)&totalBandWidthEn);			
#endif

	}
#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
	mib_get_s(MIB_QOS_POLICY, &policy, sizeof(policy));
	if(policy==0){
		//PRQ
		//action = boaGetVar(wp, "ip_qos_mandatory_bandwith_en", "");
		action = "";
	}else{
		action = boaGetVar(wp, "ip_qos_mandatory_bandwith_en", "0");
	}
	//printf("policy=%d\n",policy);
	if (action[0]) {
		policy = (action[0]=='0') ? 0 : 1;
		mib_set(MIB_QOS_ENABLE_DOWNSTREAM_FORCE_WEIGHT, &policy);
		//printf("ip_qos_mandatory_bandwith_en=%d\n",policy);
		unsigned int totalbandwidth = 0;
		uint queue_weight[MAX_QOS_QUEUE_NUM]={0};
		int totalweight = 0;
		if(mib_get_s(MIB_TOTAL_DOWNSTREAM_BANDWIDTH, (void*)&totalbandwidth, sizeof(totalbandwidth))){
			if(!policy)
				totalbandwidth = 0;
			totalbandwidth = totalbandwidth/1024;
			printf("totalbandwidth=%d\n",totalbandwidth);
			for (num=0; num<MAX_QOS_QUEUE_NUM; num++) {
				if(!mib_chain_get(MIB_IP_QOS_DOWNSTREAM_QUEUE_TBL, num, (void*)&qEntry))
					continue;
				queue_weight[num]=qEntry.weight;
				totalweight+=queue_weight[num];
			}
			//calc the uprate for each queue according with weight
						
			for (num=0; num<MAX_QOS_QUEUE_NUM; num++) {
				if(!mib_chain_get(MIB_IP_QOS_DOWNSTREAM_QUEUE_TBL, num, (void*)&qEntry))
					continue;
				qEntry.upmaxrate=totalbandwidth*queue_weight[num]/totalweight;
				printf("qEntry.upmaxrate=%d\n",qEntry.upmaxrate);
				mib_chain_update(MIB_IP_QOS_DOWNSTREAM_QUEUE_TBL,&qEntry,num);
			}
		}
	}else{
			for (num=0; num<MAX_QOS_QUEUE_NUM; num++) {
				if(!mib_chain_get(MIB_IP_QOS_DOWNSTREAM_QUEUE_TBL, num, (void*)&qEntry))
					continue;
				qEntry.upmaxrate=0;
				mib_chain_update(MIB_IP_QOS_DOWNSTREAM_QUEUE_TBL,&qEntry,num);
			}
	}
#endif

	mib_get_s(MIB_QOS_ENABLE_DOWNSTREAM_QOS, &vChar, sizeof(vChar));
	if(vChar)
		syslog(LOG_INFO, "QoSPolicy: Configuration update");
	else
		syslog(LOG_INFO, "QoSPolicy: Disable");

done:

#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif

	//take effect
	take_qos_effect();

	//redirect web page
	url = boaGetVar(wp, "submit-url", "");
	if(url[0])
	{
		boaRedirect(wp, url);
	}
	return;
}

#ifdef _PRMT_X_CT_COM_DATA_SPEED_LIMIT_
int initQosSpeedLimitRule(int eid, request * wp, int argc, char **argv)
{
	int nBytes = 0;
	unsigned char mode = 0;
	int i = 0, totalNum = 0;
	MIB_CE_DATA_SPEED_LIMIT_IF_T if_entry;
	MIB_CE_DATA_SPEED_LIMIT_VLAN_T vlan_entry;
	MIB_CE_DATA_SPEED_LIMIT_IP_T ip_entry;
#ifdef CONFIG_USER_AP_MAC_SPEED_LIMIT_QOS
	MIB_CE_DATA_SPEED_LIMIT_MAC_T mac_entry;
#endif	

	mib_get_s(MIB_DATA_SPEED_LIMIT_UP_MODE, &mode, sizeof(mode));
	nBytes += boaWrite(wp, "rule_mode_up = %u;\n", mode);

	mib_get_s(MIB_DATA_SPEED_LIMIT_DOWN_MODE, &mode, sizeof(mode));
	nBytes += boaWrite(wp, "rule_mode_down = %u;\n", mode);


	totalNum = mib_chain_total(MIB_DATA_SPEED_LIMIT_UP_IF_TBL);
	for (i = 0; i < totalNum; i++)
	{
		if (!mib_chain_get(MIB_DATA_SPEED_LIMIT_UP_IF_TBL, i, (void*)&if_entry))
			continue;

		nBytes += boaWrite(wp, "rule_intf_up.push("
								"new it_nr(\"%d\","
								"new it(\"idx\", %d),"
								"new it(\"if_id\", \"%d\"),"
								"new it(\"speed_unit\", %d)));\n",
								i,
								i,
								if_entry.if_id,
								if_entry.speed_unit);
	}

	totalNum = mib_chain_total(MIB_DATA_SPEED_LIMIT_DOWN_IF_TBL);
	for (i = 0; i < totalNum; i++)
	{
		if (!mib_chain_get(MIB_DATA_SPEED_LIMIT_DOWN_IF_TBL, i, (void*)&if_entry))
			continue;

		nBytes += boaWrite(wp, "rule_intf_down.push("
								"new it_nr(\"%d\","
								"new it(\"idx\", %d),"
								"new it(\"if_id\", \"%d\"),"
								"new it(\"speed_unit\", %d)));\n",
								i,
								i,
								if_entry.if_id,
								if_entry.speed_unit);
	}

	totalNum = mib_chain_total(MIB_DATA_SPEED_LIMIT_UP_VLAN_TBL);
	for (i = 0; i < totalNum; i++)
	{
		if (!mib_chain_get(MIB_DATA_SPEED_LIMIT_UP_VLAN_TBL, i, (void*)&vlan_entry))
			continue;

		if(vlan_entry.vlan == -1)
		{
			nBytes += boaWrite(wp, "rule_vlan_up.push("
								"new it_nr(\"%d\","
								"new it(\"idx\", %d),"
								"new it(\"vlan\", \"untagged\"),"
								"new it(\"speed_unit\", %d)));\n",
								i,
								i,
								vlan_entry.speed_unit);
		}
		else
		{
			nBytes += boaWrite(wp, "rule_vlan_up.push("
								"new it_nr(\"%d\","
								"new it(\"idx\", %d),"
								"new it(\"vlan\", \"%d\"),"
								"new it(\"speed_unit\", %d)));\n",
								i,
								i,
								vlan_entry.vlan,
								vlan_entry.speed_unit);
		}
	}

	totalNum = mib_chain_total(MIB_DATA_SPEED_LIMIT_DOWN_VLAN_TBL);
	for (i = 0; i < totalNum; i++)
	{
		if (!mib_chain_get(MIB_DATA_SPEED_LIMIT_DOWN_VLAN_TBL, i, (void*)&vlan_entry))
			continue;
		
		if(vlan_entry.vlan == -1)
		{
			nBytes += boaWrite(wp, "rule_vlan_down.push("
								"new it_nr(\"%d\","
								"new it(\"idx\", %d),"
								"new it(\"vlan\", \"untagged\"),"
								"new it(\"speed_unit\", %d)));\n",
								i,
								i,
								vlan_entry.speed_unit);
		}
		else
		{
			nBytes += boaWrite(wp, "rule_vlan_down.push("
								"new it_nr(\"%d\","
								"new it(\"idx\", %d),"
								"new it(\"vlan\", %d),"
								"new it(\"speed_unit\", %d)));\n",
								i,
								i,
								vlan_entry.vlan,
								vlan_entry.speed_unit);
		}
	}

	totalNum = mib_chain_total(MIB_DATA_SPEED_LIMIT_UP_IP_TBL);
	for (i = 0; i < totalNum; i++)
	{
		if (!mib_chain_get(MIB_DATA_SPEED_LIMIT_UP_IP_TBL, i, (void*)&ip_entry))
			continue;

		nBytes += boaWrite(wp, "rule_ip_up.push("
								"new it_nr(\"%d\","
								"new it(\"idx\", %d),"
								"new it(\"ip_start\", \"%s\"),"
								"new it(\"ip_end\", \"%s\"),"
								"new it(\"speed_unit\", %d)));\n",
								i,
								i,
								ip_entry.ip_start,
								ip_entry.ip_end,
								ip_entry.speed_unit);
	}

	totalNum = mib_chain_total(MIB_DATA_SPEED_LIMIT_DOWN_IP_TBL);
	for (i = 0; i < totalNum; i++)
	{
		if (!mib_chain_get(MIB_DATA_SPEED_LIMIT_DOWN_IP_TBL, i, (void*)&ip_entry))
			continue;

		nBytes += boaWrite(wp, "rule_ip_down.push("
								"new it_nr(\"%d\","
								"new it(\"idx\", %d),"
								"new it(\"ip_start\", \"%s\"),"
								"new it(\"ip_end\", \"%s\"),"
								"new it(\"speed_unit\", %d)));\n",
								i,
								i,
								ip_entry.ip_start,
								ip_entry.ip_end,
								ip_entry.speed_unit);
	}

#ifdef CONFIG_USER_AP_MAC_SPEED_LIMIT_QOS
	totalNum = mib_chain_total(MIB_DATA_SPEED_LIMIT_UP_MAC_TBL);
	for (i = 0; i < totalNum; i++)
	{
		if (!mib_chain_get(MIB_DATA_SPEED_LIMIT_UP_MAC_TBL, i, (void*)&mac_entry))
			continue;

		nBytes += boaWrite(wp, "rule_mac_up.push("
								"new it_nr(\"%d\","
								"new it(\"idx\", %d),"
								"new it(\"mac\", \"%02x:%02x:%02x:%02x:%02x:%02x\"),"
								"new it(\"speed_unit\", %d)));\n",
								i,
								i,
								mac_entry.mac[0], mac_entry.mac[1], mac_entry.mac[2],
								mac_entry.mac[3], mac_entry.mac[4], mac_entry.mac[5],
								mac_entry.speed_unit);
	}

	totalNum = mib_chain_total(MIB_DATA_SPEED_LIMIT_DOWN_MAC_TBL);
	for (i = 0; i < totalNum; i++)
	{
		if (!mib_chain_get(MIB_DATA_SPEED_LIMIT_DOWN_MAC_TBL, i, (void*)&mac_entry))
			continue;

		nBytes += boaWrite(wp, "rule_mac_down.push("
								"new it_nr(\"%d\","
								"new it(\"idx\", %d),"
								"new it(\"mac\", \"%02x:%02x:%02x:%02x:%02x:%02x\"),"
								"new it(\"speed_unit\", %d)));\n",
								i,
								i,
								mac_entry.mac[0], mac_entry.mac[1], mac_entry.mac[2],
								mac_entry.mac[3], mac_entry.mac[4], mac_entry.mac[5],
								mac_entry.speed_unit);
	}
#endif

	return nBytes;
}

void formQosSpeedLimit(request * wp, char *path, char *query)
{
	char *action = NULL, *url = NULL;
	char Mode_up = 0, Mode_down = 0;
	int chain_id = 0, chain_index = -1, chain_action = 0;
	int len=0;
	char tmplogBuf[300]={0};
	char action_str[32]={0};

	enum
	{
		CHAIN_ACTION_NONE = 0,
		CHAIN_ACTION_ADD,
		CHAIN_ACTION_EDIT,
		CHAIN_ACTION_DEL
	};

	action = boaGetVar(wp, "ModeSwitch_up", "");
	if (action[0]) {
		printf("ModeSwitch_up = %s\n", action);
		Mode_up = atoi(action);
	}
	
	action = boaGetVar(wp, "ModeSwitch_down", "");
	if (action[0]) {
		printf("ModeSwitch_down = %s\n", action);
		Mode_down = atoi(action);
	}

	action = boaGetVar(wp, "submitAction", "");
	if (action[0]) {
		printf("submitAction = %s\n", action);
		if (strcmp(action, "mode") == 0) {
			mib_set(MIB_DATA_SPEED_LIMIT_UP_MODE, &Mode_up);
			mib_set(MIB_DATA_SPEED_LIMIT_DOWN_MODE, &Mode_down);
			syslog(LOG_INFO, "QosSpeedLimit: Up Mode: %d, Down Mode: %d", Mode_up, Mode_down);
		}
		else if (strcmp(action, "rule") == 0) {
			action = boaGetVar(wp, "ruleDirection", "");
			if (action[0]) {
				printf("ruleDirection = %s\n", action);
				len += snprintf(tmplogBuf+len, sizeof(tmplogBuf)-len, ", ruleDirection: %s", action);
				if (strcmp(action, "up") == 0) {
					action = boaGetVar(wp, "ruleIndex_up", "");
					if (action[0]) {
						printf("ruleIndex_up = %s\n", action);
						chain_index = atoi(action);
					}

					action = boaGetVar(wp, "ruleAction_up", "");
					if (action[0]) {
						printf("ruleAction_up = %s\n", action);
						if (strcmp(action, "add") == 0) {
							chain_action = CHAIN_ACTION_ADD;
							strcpy(action_str, "Add");
						}
						else if (strcmp(action, "edit") == 0) {
							chain_action = CHAIN_ACTION_EDIT;
							strcpy(action_str, "Update");
						}
						else if (strcmp(action, "del") == 0) {
							chain_action = CHAIN_ACTION_DEL;
							strcpy(action_str, "Delete");
						}
					}

					if (Mode_up == 1) { // Interface
						MIB_CE_DATA_SPEED_LIMIT_IF_T entry;
						chain_id = MIB_DATA_SPEED_LIMIT_UP_IF_TBL;

						memset(&entry, 0, sizeof(MIB_CE_DATA_SPEED_LIMIT_IF_T));

						action = boaGetVar(wp, "InterfaceName_up", "");
						if (action[0]) {
							printf("InterfaceName_up = %s\n", action);
							entry.if_id = atoi(action);
						}

						action = boaGetVar(wp, "InterfaceSpeed_up", "");
						if (action[0]) {
							printf("InterfaceSpeed_up = %s\n", action);
							entry.speed_unit = atoi(action);
						}

						switch (chain_action)
						{
							case CHAIN_ACTION_ADD:
								mib_chain_add(chain_id, (void *)&entry);
								break;

							case CHAIN_ACTION_EDIT:
								if (chain_index >= 0) {
									mib_chain_update(chain_id, (void *)&entry, chain_index);
								}
								break;

							case CHAIN_ACTION_DEL:
								if (chain_index >= 0) {
									mib_chain_delete(chain_id, chain_index);
								}
								break;

							default:
								break;
						}
						len += snprintf(tmplogBuf+len, sizeof(tmplogBuf)-len, ", %s, if_id: %d, speed_unit: %d", action_str, entry.if_id, entry.speed_unit);
					}
					else if (Mode_up == 2) { // VlanTag
						MIB_CE_DATA_SPEED_LIMIT_VLAN_T entry;
						chain_id = MIB_DATA_SPEED_LIMIT_UP_VLAN_TBL;

						memset(&entry, 0, sizeof(MIB_CE_DATA_SPEED_LIMIT_VLAN_T));

						action = boaGetVar(wp, "VlanTagValue_up", "");
						if (action[0]) {
							printf("VlanTagValue_up = %s\n", action);
							if (strcasecmp(action, "untagged") == 0) {
								entry.vlan = -1;
							}
							else {
								entry.vlan = atoi(action);
							}
						}

						action = boaGetVar(wp, "VlanTagSpeed_up", "");
						if (action[0]) {
							printf("VlanTagSpeed_up = %s\n", action);
							entry.speed_unit = atoi(action);
						}

						switch (chain_action)
						{
							case CHAIN_ACTION_ADD:
								mib_chain_add(chain_id, (void *)&entry);
								break;

							case CHAIN_ACTION_EDIT:
								if (chain_index >= 0) {
									mib_chain_update(chain_id, (void *)&entry, chain_index);
								}
								break;

							case CHAIN_ACTION_DEL:
								if (chain_index >= 0) {
									mib_chain_delete(chain_id, chain_index);
								}
								break;

							default:
								break;
						}
						len += snprintf(tmplogBuf+len, sizeof(tmplogBuf)-len, ", %s, vlan: %d, speed_unit: %d", action_str, entry.vlan, entry.speed_unit);
					}
					else if (Mode_up == 3) { // IP
						MIB_CE_DATA_SPEED_LIMIT_IP_T entry;
						chain_id = MIB_DATA_SPEED_LIMIT_UP_IP_TBL;
						char ip_start[64] = {0}, ip_end[64] = {0};
						struct addrinfo hint, *res_start = NULL, *res_end = NULL;
						int ret = 0;

						memset(&entry, 0, sizeof(MIB_CE_DATA_SPEED_LIMIT_IP_T));

						action = boaGetVar(wp, "IP_Start_up", "");
						if (action[0]) {
							printf("IP_Start_up = %s\n", action);
							strncpy(ip_start, action, sizeof(ip_start)-1);
						}

						action = boaGetVar(wp, "IP_End_up", "");
						if (action[0]) {
							printf("IP_End_up = %s\n", action);
							strncpy(ip_end, action, sizeof(ip_end)-1);
						}

						if(chain_action != CHAIN_ACTION_DEL) {	
							memset(&hint, 0, sizeof(hint));

							hint.ai_family = PF_UNSPEC;
							hint.ai_flags = AI_NUMERICHOST;

							ret = getaddrinfo(ip_start, NULL, &hint, &res_start);
							if (ret) {
								printf("Invalid start address %s: %s\n", ip_start, gai_strerror(ret));
								ERR_MSG("Invalid start address");
								return;
							}

							ret = getaddrinfo(ip_end, NULL, &hint, &res_end);
							if (ret) {
								printf("Invalid end address %s: %s\n", ip_end, gai_strerror(ret));
								ERR_MSG("Invalid end address");
								freeaddrinfo(res_start);
								return;
							}

							if (res_start->ai_family != res_end->ai_family) {
								printf("start address family != end address family\n");
								ERR_MSG("Invalid start or end address");
								freeaddrinfo(res_start);
								freeaddrinfo(res_end);
								return;
							}

							if(res_start->ai_family == AF_INET) {
								entry.ip_ver = IPVER_IPV4;
							}
							else if (res_start->ai_family == AF_INET6) {
								entry.ip_ver = IPVER_IPV6;
							}
							else {
								printf("%s is an is unknown address format %d\n", ip_start, res_start->ai_family);
								ERR_MSG("Unknown address format");
								freeaddrinfo(res_start);
								freeaddrinfo(res_end);
								return;
							}

							strcpy(entry.ip_start, ip_start);
							strcpy(entry.ip_end, ip_end);
							freeaddrinfo(res_start);
							freeaddrinfo(res_end);
						}

						action = boaGetVar(wp, "IPSpeed_up", "");
						if (action[0]) {
							printf("IPSpeed_up = %s\n", action);
							entry.speed_unit = atoi(action);
						}

						switch (chain_action)
						{
							case CHAIN_ACTION_ADD:
								mib_chain_add(chain_id, (void *)&entry);
								break;

							case CHAIN_ACTION_EDIT:
								if (chain_index >= 0) {
									mib_chain_update(chain_id, (void *)&entry, chain_index);
								}
								break;

							case CHAIN_ACTION_DEL:
								if (chain_index >= 0) {
									mib_chain_delete(chain_id, chain_index);
								}
								break;

							default:
								break;
						}
						len += snprintf(tmplogBuf+len, sizeof(tmplogBuf)-len, ", %s, ip_start: %s, ip_end: %s, speed_unit: %d", action_str, ip_start, ip_end, entry.speed_unit);
					}
				#ifdef CONFIG_USER_AP_E8B_QOS
					else if (Mode_up == 4) { // MAC
						MIB_CE_DATA_SPEED_LIMIT_MAC_T entry;
						chain_id = MIB_DATA_SPEED_LIMIT_UP_MAC_TBL;
						char mac[13] = {0}, *p = NULL;
						int index = 0;

						memset(&entry, 0, sizeof(MIB_CE_DATA_SPEED_LIMIT_MAC_T));
						
						action = boaGetVar(wp, "MAC_up", "");
						if (action[0]) {
							printf("MAC_up = %s\n", action);
						}

						p = action;
						for(index = 0; (*p && (index < 12)); ++p) {
							if (*p!=':')
								mac[index++] = *p;
						}
						rtk_string_to_hex(mac, entry.mac, 12);
						printf("entry.mac = %x:%x:%x:%x:%x:%x\n", 
							entry.mac[0], entry.mac[1], entry.mac[2], 
							entry.mac[3], entry.mac[4], entry.mac[5]);

						action = boaGetVar(wp, "MACSpeed_up", "");
						if (action[0]) {
							printf("MACSpeed_up = %s\n", action);
							entry.speed_unit = atoi(action);
						}

						switch (chain_action)
						{
							case CHAIN_ACTION_ADD:
								mib_chain_add(chain_id, (void *)&entry);
								break;

							case CHAIN_ACTION_EDIT:
								if (chain_index >= 0) {
									mib_chain_update(chain_id, (void *)&entry, chain_index);
								}
								break;

							case CHAIN_ACTION_DEL:
								if (chain_index >= 0) {
									mib_chain_delete(chain_id, chain_index);
								}
								break;

							default:
								break;
						}
						len += snprintf(tmplogBuf+len, sizeof(tmplogBuf)-len, ", %s, mac %02x:%02x:%02x:%02x:%02x:%02x, speed_unit: %d",
							action_str, entry.mac[0], entry.mac[1], entry.mac[2], 
							entry.mac[3], entry.mac[4], entry.mac[5], entry.speed_unit);
					}
				#endif
				}
				else if (strcmp(action, "down") == 0) {
					action = boaGetVar(wp, "ruleIndex_down", "");
					if (action[0]) {
						printf("ruleIndex_down = %s\n", action);
						chain_index = atoi(action);
					}
					
					action = boaGetVar(wp, "ruleAction_down", "");
					if (action[0]) {
						printf("ruleAction_down = %s\n", action);
						if (strcmp(action, "add") == 0) {
							chain_action = CHAIN_ACTION_ADD;
							strcpy(action_str, "Add");
						}
						else if (strcmp(action, "edit") == 0) {
							chain_action = CHAIN_ACTION_EDIT;
							strcpy(action_str, "Update");
						}
						else if (strcmp(action, "del") == 0) {
							chain_action = CHAIN_ACTION_DEL;
							strcpy(action_str, "Delete");
						}
					}

					if (Mode_down == 1) { // Interface
						MIB_CE_DATA_SPEED_LIMIT_IF_T entry;
						chain_id = MIB_DATA_SPEED_LIMIT_DOWN_IF_TBL;

						memset(&entry, 0, sizeof(MIB_CE_DATA_SPEED_LIMIT_IF_T));

						action = boaGetVar(wp, "InterfaceName_down", "");
						if (action[0]) {
							printf("InterfaceName_down = %s\n", action);
							entry.if_id = atoi(action);
						}

						action = boaGetVar(wp, "InterfaceSpeed_down", "");
						if (action[0]) {
							printf("InterfaceSpeed_down = %s\n", action);
							entry.speed_unit = atoi(action);
						}

						switch (chain_action)
						{
							case CHAIN_ACTION_ADD:
								mib_chain_add(chain_id, (void *)&entry);
								break;

							case CHAIN_ACTION_EDIT:
								if (chain_index >= 0) {
									mib_chain_update(chain_id, (void *)&entry, chain_index);
								}
								break;

							case CHAIN_ACTION_DEL:
								if (chain_index >= 0) {
									mib_chain_delete(chain_id, chain_index);
								}
								break;

							default:
								break;
						}

						len += snprintf(tmplogBuf+len, sizeof(tmplogBuf)-len, ", %s, if_id: %d, speed_unit: %d", action_str, entry.if_id, entry.speed_unit);
					}
					else if (Mode_down == 2) { // VlanTag
						MIB_CE_DATA_SPEED_LIMIT_VLAN_T entry;
						chain_id = MIB_DATA_SPEED_LIMIT_DOWN_VLAN_TBL;

						memset(&entry, 0, sizeof(MIB_CE_DATA_SPEED_LIMIT_VLAN_T));

						action = boaGetVar(wp, "VlanTagValue_down", "");
						if (action[0]) {
							printf("VlanTagValue_down = %s\n", action);
							if (strcasecmp(action, "untagged") == 0) {
								entry.vlan = -1;
							}
							else {
								entry.vlan = atoi(action);
							}
						}

						action = boaGetVar(wp, "VlanTagSpeed_down", "");
						if (action[0]) {
							printf("VlanTagSpeed_down = %s\n", action);
							entry.speed_unit = atoi(action);
						}

						switch (chain_action)
						{
							case CHAIN_ACTION_ADD:
								mib_chain_add(chain_id, (void *)&entry);
								break;

							case CHAIN_ACTION_EDIT:
								if (chain_index >= 0) {
									mib_chain_update(chain_id, (void *)&entry, chain_index);
								}
								break;

							case CHAIN_ACTION_DEL:
								if (chain_index >= 0) {
									mib_chain_delete(chain_id, chain_index);
								}
								break;

							default:
								break;
						}

						len += snprintf(tmplogBuf+len, sizeof(tmplogBuf)-len, ", %s, vlan: %d, speed_unit: %d", action_str, entry.vlan, entry.speed_unit);
					}
					else if (Mode_down == 3) { // IP
						MIB_CE_DATA_SPEED_LIMIT_IP_T entry;
						chain_id = MIB_DATA_SPEED_LIMIT_DOWN_IP_TBL;
						char ip_start[64] = {0}, ip_end[64] = {0};
						struct addrinfo hint, *res_start = NULL, *res_end = NULL;
						int ret = 0;

						memset(&entry, 0, sizeof(MIB_CE_DATA_SPEED_LIMIT_IP_T));

						action = boaGetVar(wp, "IP_Start_down", "");
						if (action[0]) {
							printf("IP_Start_down = %s\n", action);
							strncpy(ip_start, action, sizeof(ip_start));
							ip_start[sizeof(ip_start)-1] = '\0';
						}

						action = boaGetVar(wp, "IP_End_down", "");
						if (action[0]) {
							printf("IP_End_down = %s\n", action);
							strncpy(ip_end, action, sizeof(ip_end));
							ip_end[sizeof(ip_end)-1] = '\0';
						}

						if(chain_action != CHAIN_ACTION_DEL) {
							memset(&hint, 0, sizeof(hint));
							hint.ai_family = PF_UNSPEC;
							hint.ai_flags = AI_NUMERICHOST;

							ret = getaddrinfo(ip_start, NULL, &hint, &res_start);
							if (ret) {
								printf("Invalid start address %s: %s\n", ip_start, gai_strerror(ret));
								ERR_MSG("Invalid start address");
								return;
							}

							ret = getaddrinfo(ip_end, NULL, &hint, &res_end);
							if (ret) {
								printf("Invalid end address %s: %s\n", ip_end, gai_strerror(ret));
								ERR_MSG("Invalid end address");
								freeaddrinfo(res_start);
								return;
							}

							if (res_start->ai_family != res_end->ai_family) {
								printf("start address family != end address family\n");
								ERR_MSG("Invalid start or end address");
								freeaddrinfo(res_start);
								freeaddrinfo(res_end);
								return;
							}

							if(res_start->ai_family == AF_INET) {
								entry.ip_ver = IPVER_IPV4;
							}
							else if (res_start->ai_family == AF_INET6) {
								entry.ip_ver = IPVER_IPV6;
							}
							else {
								printf("%s is an is unknown address format %d\n", ip_start, res_start->ai_family);
								ERR_MSG("Unknown address format");
								freeaddrinfo(res_start);
								freeaddrinfo(res_end);
								return;
							}

							strcpy(entry.ip_start, ip_start);
							strcpy(entry.ip_end, ip_end);
							freeaddrinfo(res_start);
							freeaddrinfo(res_end);
						}

						action = boaGetVar(wp, "IPSpeed_down", "");
						if (action[0]) {
							printf("IPSpeed_down = %s\n", action);
							entry.speed_unit = atoi(action);
						}

						switch (chain_action)
						{
							case CHAIN_ACTION_ADD:
								mib_chain_add(chain_id, (void *)&entry);
								break;

							case CHAIN_ACTION_EDIT:
								if (chain_index >= 0) {
									mib_chain_update(chain_id, (void *)&entry, chain_index);
								}
								break;

							case CHAIN_ACTION_DEL:
								if (chain_index >= 0) {
									mib_chain_delete(chain_id, chain_index);
								}
								break;

							default:
								break;
						}

						len += snprintf(tmplogBuf+len, sizeof(tmplogBuf)-len, ", %s, ip_start: %s, ip_end: %s, speed_unit: %d", action_str, ip_start, ip_end, entry.speed_unit);
					}	
				#ifdef CONFIG_USER_AP_E8B_QOS
					else if (Mode_down == 4) { // MAC
						MIB_CE_DATA_SPEED_LIMIT_MAC_T entry;
						chain_id = MIB_DATA_SPEED_LIMIT_DOWN_MAC_TBL;
						char mac[13] = {0}, *p = NULL;
						int index = 0;
				
						memset(&entry, 0, sizeof(MIB_CE_DATA_SPEED_LIMIT_MAC_T));
						
						action = boaGetVar(wp, "MAC_down", "");
						if (action[0]) {
							printf("MAC_down = %s\n", action);
						}
				
						p = action;
						for(index = 0; (*p && (index < 12)); ++p) {
							if (*p!=':')
								mac[index++] = *p;
						}
						rtk_string_to_hex(mac, entry.mac, 12);
						printf("entry.mac = %x:%x:%x:%x:%x:%x\n", 
							entry.mac[0], entry.mac[1], entry.mac[2], 
							entry.mac[3], entry.mac[4], entry.mac[5]);
				
						action = boaGetVar(wp, "MACSpeed_down", "");
						if (action[0]) {
							printf("MACSpeed_down = %s\n", action);
							entry.speed_unit = atoi(action);
						}
				
						switch (chain_action)
						{
							case CHAIN_ACTION_ADD:
								mib_chain_add(chain_id, (void *)&entry);
								break;
				
							case CHAIN_ACTION_EDIT:
								if (chain_index >= 0) {
									mib_chain_update(chain_id, (void *)&entry, chain_index);
								}
								break;
				
							case CHAIN_ACTION_DEL:
								if (chain_index >= 0) {
									mib_chain_delete(chain_id, chain_index);
								}
								break;
				
							default:
								break;
						}
						len += snprintf(tmplogBuf+len, sizeof(tmplogBuf)-len, ", %s, mac %02x:%02x:%02x:%02x:%02x:%02x, speed_unit: %d",
							action_str, entry.mac[0], entry.mac[1], entry.mac[2], 
							entry.mac[3], entry.mac[4], entry.mac[5], entry.speed_unit);
					}
				#endif
				}
			}
			syslog(LOG_INFO, "QosSpeedLimit: Up Mode: %d, Down Mode: %d%s", Mode_up, Mode_down, tmplogBuf);
		}
	}

#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif
	//take effect
	take_qos_effect();

	//redirect web page
	url = boaGetVar(wp, "submit-url", "");
	if (url[0]) {
		boaRedirect(wp, url);
	}
	return;
}
#endif

int ipqos_dhcpopt(int eid, request * wp, int argc, char **argv)
{
	int nBytes = 0;

#ifdef CONFIG_BRIDGE_EBT_DHCP_OPT
	nBytes += boaWrite(wp, " <td><font size=2><input type=\"radio\"  name=qos_rule_type value=4 onClick=ruleType_click();> DHCP Option</td>");	
#endif

	return nBytes;
}


int ipqos_dhcpopt_getoption60(int eid, request * wp, int argc, char **argv)
{
	int nBytes = 0, index=0;
	MIB_CE_IP_QOS_T entry;
	int start=0,end=0,len=0;
	char index_buf[3]={0};

#ifdef CONFIG_BRIDGE_EBT_DHCP_OPT
	if(wp->query_string)
	{
		start = strstr(wp->query_string,"rule_index=")+sizeof("rule_index=")-1;
		end = strstr(wp->query_string,"&rule");
		len=end-start;
		if(start&&end&&(len>0))
		{
			memcpy(index_buf,start,len);

			index= atoi(index_buf);
	if(!mib_chain_get(MIB_IP_QOS_TBL, index, &entry))
			return;
	nBytes += boaWrite(wp, "%s", entry.opt60_vendorclass);	
		}
	}
#endif

	return nBytes;

}
#ifdef CONFIG_CMCC_ENTERPRISE
int cmccEnterpriseHtmlIPQosInitPage(int eid, request * wp, int argc, char **argv){
	MIB_CE_ATM_VC_T vcEntry;
	int entryNum, i, j, nBytes = 0;
	unsigned char policy = 0;
	unsigned int download_qos_enable = 0;
	int qEntryNum;
	unsigned int total_bandwidth = 0;
	char qos_serv_rule[32] = {0};
	unsigned char m_1p_enable = 0;
	unsigned char m_enableDSCP;
	unsigned char m_enableTC;
	MIB_CE_IP_QOS_QUEUE_T qEntry;
	MIB_CE_IP_QOS_T qos_entry;
#ifdef QOS_USING_CLASSFICATION
	MIB_CE_IP_QOS_CLASSFICATION_T qos_classfication_entry;
	MIB_CE_IP_QOS_CLASSFICATIONTYPE_T qos_classfication_type_entry,qos_classfication_type_entry_a;
#endif
	entryNum = mib_chain_total(MIB_ATM_VC_TBL);
	char Mode_up = 0, Mode_down = 0;
	//printf("%s %d############\n",__FUNCTION__,__LINE__);
	/*
	WanList[0] = new Object();
	WanList[0].index = 0;
	WanList[0].bridge = 0;
	WanList[0].service = 2;
	WanList[0].vlan_enable = 1;
	WanList[0].vlan_vid = 100;
	WanList[1] = new Object();
	WanList[1].index = 1;
	WanList[1].bridge = 0;
	WanList[1].service = 4;
	WanList[1].vlan_enable = 1;
	WanList[1].vlan_vid = 200;
	*/
	for(i=0; i<entryNum; i++)
	{
		// Kaohj --- E8 don't care enableIpQos.
		//if(!mib_chain_get(MIB_ATM_VC_TBL, i, &vcEntry)||!vcEntry.enableIpQos)
		if(!mib_chain_get(MIB_ATM_VC_TBL, i, &vcEntry))
			continue;

		boaWrite(wp,"WanList[%d]= new Object();\n",i);
		boaWrite(wp,"WanList[%d].index = %d;\n",i,i);
		boaWrite(wp,"WanList[%d].bridge= %d;\n",i,(vcEntry.cmode==CHANNEL_MODE_BRIDGE));
		boaWrite(wp,"WanList[%d].service= %d;\n",i,(vcEntry.applicationtype));
		boaWrite(wp,"WanList[%d].vlan_enable= %d;\n",i,(vcEntry.vlan));
		boaWrite(wp,"WanList[%d].vlan_vid= %d;\n",i,(vcEntry.vid));
	}
	/*
	IpQosConfig.qos_enable = 1;
	IpQosConfig.qos_usrate = 0;
	IpQosConfig.qos_mode = 1;
	IpQosConfig.serv_rule = "TR069,VOIP,IPTV,INTERNET";
	IpQosConfig.qosdown_enable = 1;
	*/
	//printf("%s %d############\n",__FUNCTION__,__LINE__);
	if(!mib_get(MIB_QOS_ENABLE_QOS, &policy)|| (policy !=0&&policy!=1))
		policy = 0;
	boaWrite(wp,"IpQosConfig.qosType= %d;\n",policy);
	mib_get(MIB_TOTAL_BANDWIDTH, &total_bandwidth);
	boaWrite(wp,"IpQosConfig.qos_usrate= %d;\n",total_bandwidth);
	if(!mib_get(MIB_QOS_POLICY, &policy)|| (policy !=0&&policy!=1))
		policy = 0;
	boaWrite(wp,"IpQosConfig.qos_mode= %d;\n",policy);
	//printf("%s %d############\n",__FUNCTION__,__LINE__);
	mib_get(CTQOS_MODE, qos_serv_rule);
	boaWrite(wp,"IpQosConfig.serv_rule= \"%s\";\n",qos_serv_rule);
	if(!mib_get(MIB_DOWNLOAD_QOS_ENABLE, &download_qos_enable))
			policy=0;
	boaWrite(wp,"IpQosConfig.qosdown_enable= %d;\n",download_qos_enable);
	/*
	IpQosConfig.qosQueueList[0] = {qid: 1,enable: 1,weight: 0};
	IpQosConfig.qosQueueList[1] = {qid: 2,enable: 1,weight: 0};
	IpQosConfig.qosQueueList[2] = {qid: 3,enable: 1,weight: 0};
	IpQosConfig.qosQueueList[3] = {qid: 4,enable: 1,weight: 0};
	*/
	if((qEntryNum=mib_chain_total(MIB_IP_QOS_QUEUE_TBL)) <=0)
		return -1;
	for(i=0;i<qEntryNum; i++)
	{
		if(!mib_chain_get(MIB_IP_QOS_QUEUE_TBL, i, (void*)&qEntry))
			continue;
		boaWrite(wp, "IpQosConfig.qosQueueList[%d]={qid: %d,enable: %d,weight: %d};\n", i,i+1, qEntry.enable,qEntry.weight);
	}
	//printf("%s %d############\n",__FUNCTION__,__LINE__);
	//DSCP

	if(!mib_get(MIB_QOS_ENABLE_DSCP_MARK, &m_enableDSCP))
			m_enableDSCP = 0;
	boaWrite(wp, "IpQosConfig.enableDSCP =%d;\n", m_enableDSCP);
	if(!mib_get(MIB_QOS_ENABLE_TC_MARK, &m_enableTC))
			m_enableTC = 0;
	boaWrite(wp, "IpQosConfig.enableTC =%d;\n", m_enableTC);
	/*
	IpQosConfig.enable8021p = 0;
	IpQosConfig.usRateCtlMode = 0;
	IpQosConfig.dsRateCtlMode = 0;
	*/
	if(!mib_get(MIB_QOS_ENABLE_1P, &m_1p_enable))
			m_1p_enable = 0;
	boaWrite(wp, "IpQosConfig.enable8021p =%d;\n", m_1p_enable);
	/*
	var qosServRule = new Array("OTHER","INTERNET,TR069","INTERNET,TR069,VOICE","INTERNET,TR069,IPTV","INTERNET,TR069,IPTV, VOICE","INTERNET,IPTV, VOICE,TR069","INTERNET,TR069,VOICE,IPTV");
	*/
	//printf("%s %d############\n",__FUNCTION__,__LINE__);
	boaWrite(wp, "var qosServRule = new Array(\"OTHER\",\"TR069,INTERNET\",\"VOICE,TR069,INTERNET\",\"IPTV,TR069,INTERNET\",\"VOICE,IPTV,TR069,INTERNET\",\"TR069,VOICE,IPTV,INTERNET\",\"IPTV,VOICE,TR069,INTERNET\");\n");
	/*
	IpQosConfig.qosPqList[0] = {
	pq_unitype: "0",
	pq_lanport: "0",
	pq_wanport: "0",
	ether_type: "0",
	proto_type: "0",
	ipv4_srcip: "192.168.1.2",
	ipv4_srcip_end: "0.0.0.0",
	ipv4_dstip: "0.0.0.0",
	ipv4_dstip_end: "0.0.0.0",
	tos_dscp_type: "2",
	dscp: "255",
	srcport_start: "",
	srcport_end: "",
	dstport_start: "",
	dstport_end: "",
	src_mac: "00:00:00:00:00:00",
	dst_mac: "00:00:00:00:00:00",
	pbit: "255",
	vlanid: "65535",
	act_priority: "1",
	act_queue: "1"
	}
	*/
	//support protocol type
	boaWrite(wp, "IpQosConfig.support_protocols =new Array;\n");
	boaWrite(wp, "IpQosConfig.support_protocols =[\n");
	for(i=0;i<IP_QOS_PROTOCOL_MAX;i++){
		if(i==IP_QOS_PROTOCOL_ICMP6)
			continue;
		if(get_clsType_protoStr(i))
			boaWrite(wp, "['%s',%d,%d],\n",get_clsType_protoStr(i),i,i==IP_QOS_PROTOCOL_ALL);
	}
	boaWrite(wp, "];\n");

	//var strProtoType = new Array("All", "TCP", "UDP", "ICMP","TCP & UDP","RTP","ICMPv6");
	boaWrite(wp, "var strProtoType = new Array(");
	for(i=0;i<IP_QOS_PROTOCOL_MAX;i++){
		if(get_clsType_protoStr(i))
			boaWrite(wp, "'%s',",get_clsType_protoStr(i),i);
	}
	boaWrite(wp, ");\n");
	/*
	var aryProtocolType = {
	NET_PROTO_ALL: 0,
	NET_PROTO_TCP: 1,
	NET_PROTO_UDP: 2,
	NET_PROTO_ICMP: 3,
	NET_PROTO_TCP_UDP: 4,
	NET_PROTO_RTP: 5,
	NET_PROTO_ICMPV6: 6,
	NET_PROTO_NONE: 7
	};
	*/
	boaWrite(wp, "var aryProtocolType = {\n");
	boaWrite(wp, "NET_PROTO_ALL:%d,\n",IP_QOS_PROTOCOL_ALL);
	boaWrite(wp, "NET_PROTO_TCP:%d,\n",IP_QOS_PROTOCOL_TCP);
	boaWrite(wp, "NET_PROTO_UDP:%d,\n",IP_QOS_PROTOCOL_UDP);
	boaWrite(wp, "NET_PROTO_TCP_UDP:%d,\n",IP_QOS_PROTOCOL_TCPUDP);
	boaWrite(wp, "NET_PROTO_ICMP:%d,\n",IP_QOS_PROTOCOL_ICMP);
	boaWrite(wp, "NET_PROTO_RTP:%d,\n",IP_QOS_PROTOCOL_RTP);
	boaWrite(wp, "NET_PROTO_NONE:%d,\n",IP_QOS_PROTOCOL_MAX);
	boaWrite(wp, "};\n");
#ifdef QOS_USING_CLASSFICATION
	qEntryNum=mib_chain_total(MIB_IP_QOS_CLASSFICATION_TBL);
	int qos_web_idx = 0;
	for(i=0;i<qEntryNum; i++)
	{
		if(!mib_chain_get(MIB_IP_QOS_CLASSFICATION_TBL, i, (void*)&qos_classfication_entry))
			continue;
		//if(qos_entry.modeTr69!=MODEINTERNET)
		//	continue;
		bzero(&qos_classfication_type_entry_a,sizeof(qos_classfication_type_entry_a));
		qos_classfication_type_entry_a.vid=0xffff;
		qos_classfication_type_entry_a.vid_end=0xffff;
		qos_classfication_type_entry_a.vlan1p=0xff;
		qos_classfication_type_entry_a.vlan1p_end=0xff;
		qos_classfication_type_entry_a.qosDscp = 0xff;
		qos_classfication_type_entry_a.qosDscp_end = 0xff;
		qos_classfication_type_entry_a.tc = 0xff;
		qos_classfication_type_entry_a.tc_end = 0xff;
		qos_classfication_type_entry_a.tos = 0xff;
		qos_classfication_type_entry_a.tos_end = 0xff;
		int z = 0;
		int tNum=mib_chain_total(MIB_IP_QOS_CLASSFICATIONTYPE_TBL);
		for(z=0;z<tNum;z++){
			if(!mib_chain_get(MIB_IP_QOS_CLASSFICATIONTYPE_TBL, z, (void*)&qos_classfication_type_entry))
				continue;
			//printf("%s %d cls_id=%d cls_cid=%d\n",__FUNCTION__,__LINE__,qos_classfication_type_entry.cls_id,qos_classfication_entry.cls_id);
			if(qos_classfication_type_entry.cls_id==qos_classfication_entry.cls_id){
				switch(qos_classfication_type_entry.classficationType){
					case (1<<IP_QOS_CLASSFICATIONTYPE_SMAC):
						qos_classfication_type_entry_a.classficationType|=qos_classfication_type_entry.classficationType;
						memcpy(&qos_classfication_type_entry_a.protoType,&qos_classfication_type_entry.protoType,sizeof(qos_classfication_type_entry.protoType));
						memcpy(qos_classfication_type_entry_a.smac,qos_classfication_type_entry.smac,sizeof(qos_classfication_type_entry.smac));
						memcpy(qos_classfication_type_entry_a.smac_end,qos_classfication_type_entry.smac_end,sizeof(qos_classfication_type_entry.smac_end));
						break;
					case 1<<IP_QOS_CLASSFICATIONTYPE_DMAC:
						qos_classfication_type_entry_a.classficationType|=qos_classfication_type_entry.classficationType;
						memcpy(&qos_classfication_type_entry_a.protoType,&qos_classfication_type_entry.protoType,sizeof(qos_classfication_type_entry.protoType));
						memcpy(qos_classfication_type_entry_a.dmac,qos_classfication_type_entry.dmac,sizeof(qos_classfication_type_entry.dmac));
						memcpy(qos_classfication_type_entry_a.dmac_end,qos_classfication_type_entry.dmac_end,sizeof(qos_classfication_type_entry.dmac_end));
						break;
					case 1<<IP_QOS_CLASSFICATIONTYPE_8021P:
						qos_classfication_type_entry_a.classficationType|=qos_classfication_type_entry.classficationType;
						memcpy(&qos_classfication_type_entry_a.protoType,&qos_classfication_type_entry.protoType,sizeof(qos_classfication_type_entry.protoType));
						memcpy(&qos_classfication_type_entry_a.vlan1p,&qos_classfication_type_entry.vlan1p,sizeof(qos_classfication_type_entry.vlan1p));
						memcpy(&qos_classfication_type_entry_a.vlan1p_end,&qos_classfication_type_entry.vlan1p_end,sizeof(qos_classfication_type_entry.vlan1p_end));
						break;
					case 1<<IP_QOS_CLASSFICATIONTYPE_SIP:
						qos_classfication_type_entry_a.classficationType|=qos_classfication_type_entry.classficationType;
						memcpy(&qos_classfication_type_entry_a.protoType,&qos_classfication_type_entry.protoType,sizeof(qos_classfication_type_entry.protoType));
						memcpy(qos_classfication_type_entry_a.sip,qos_classfication_type_entry.sip,sizeof(qos_classfication_type_entry.sip));
						memcpy(qos_classfication_type_entry_a.sip_end,qos_classfication_type_entry.sip_end,sizeof(qos_classfication_type_entry.sip_end));
						break;
					case 1<<IP_QOS_CLASSFICATIONTYPE_DIP:
						qos_classfication_type_entry_a.classficationType|=qos_classfication_type_entry.classficationType;
						memcpy(&qos_classfication_type_entry_a.protoType,&qos_classfication_type_entry.protoType,sizeof(qos_classfication_type_entry.protoType));
						memcpy(qos_classfication_type_entry_a.dip,qos_classfication_type_entry.dip,sizeof(qos_classfication_type_entry.sip));
						memcpy(qos_classfication_type_entry_a.dip_end,qos_classfication_type_entry.dip_end,sizeof(qos_classfication_type_entry.sip_end));
						break;
					case 1<<IP_QOS_CLASSFICATIONTYPE_SPORT:
						qos_classfication_type_entry_a.classficationType|=qos_classfication_type_entry.classficationType;
						memcpy(&qos_classfication_type_entry_a.protoType,&qos_classfication_type_entry.protoType,sizeof(qos_classfication_type_entry.protoType));
						memcpy(&qos_classfication_type_entry_a.sPort,&qos_classfication_type_entry.sPort,sizeof(qos_classfication_type_entry.sPort));
						memcpy(&qos_classfication_type_entry_a.sPortRangeMax,&qos_classfication_type_entry.sPortRangeMax,sizeof(qos_classfication_type_entry.sPortRangeMax));
						break;
					case 1<<IP_QOS_CLASSFICATIONTYPE_DPORT:
						qos_classfication_type_entry_a.classficationType|=qos_classfication_type_entry.classficationType;
						memcpy(&qos_classfication_type_entry_a.protoType,&qos_classfication_type_entry.protoType,sizeof(qos_classfication_type_entry.protoType));
						memcpy(&qos_classfication_type_entry_a.dPort,&qos_classfication_type_entry.dPort,sizeof(qos_classfication_type_entry.dPort));
						memcpy(&qos_classfication_type_entry_a.dPortRangeMax,&qos_classfication_type_entry.dPortRangeMax,sizeof(qos_classfication_type_entry.dPortRangeMax));
						break;
					case 1<<IP_QOS_CLASSFICATIONTYPE_TOS:
						qos_classfication_type_entry_a.classficationType|=qos_classfication_type_entry.classficationType;
						memcpy(&qos_classfication_type_entry_a.protoType,&qos_classfication_type_entry.protoType,sizeof(qos_classfication_type_entry.protoType));
						memcpy(&qos_classfication_type_entry_a.tos,&qos_classfication_type_entry.tos,sizeof(qos_classfication_type_entry.tos));
						memcpy(&qos_classfication_type_entry_a.tos_end,&qos_classfication_type_entry.tos_end,sizeof(qos_classfication_type_entry.tos_end));
						break;
					case 1<<IP_QOS_CLASSFICATIONTYPE_DSCP:
						qos_classfication_type_entry_a.classficationType|=qos_classfication_type_entry.classficationType;
						memcpy(&qos_classfication_type_entry_a.protoType,&qos_classfication_type_entry.protoType,sizeof(qos_classfication_type_entry.protoType));
						memcpy(&qos_classfication_type_entry_a.qosDscp,&qos_classfication_type_entry.qosDscp,sizeof(qos_classfication_type_entry.qosDscp));
						memcpy(&qos_classfication_type_entry_a.qosDscp_end,&qos_classfication_type_entry.qosDscp_end,sizeof(qos_classfication_type_entry.qosDscp_end));
						break;
					case 1<<IP_QOS_CLASSFICATIONTYPE_SIP6:
						qos_classfication_type_entry_a.classficationType|=qos_classfication_type_entry.classficationType;
						memcpy(&qos_classfication_type_entry_a.protoType,&qos_classfication_type_entry.protoType,sizeof(qos_classfication_type_entry.protoType));
						memcpy(qos_classfication_type_entry_a.sip6,qos_classfication_type_entry.sip6,sizeof(qos_classfication_type_entry.sip6));
						memcpy(qos_classfication_type_entry_a.sip6_end,qos_classfication_type_entry.sip6_end,sizeof(qos_classfication_type_entry.sip6_end));
						break;
					case 1<<IP_QOS_CLASSFICATIONTYPE_DIP6:
						qos_classfication_type_entry_a.classficationType|=qos_classfication_type_entry.classficationType;
						memcpy(&qos_classfication_type_entry_a.protoType,&qos_classfication_type_entry.protoType,sizeof(qos_classfication_type_entry.protoType));
						memcpy(qos_classfication_type_entry_a.dip6,qos_classfication_type_entry.dip6,sizeof(qos_classfication_type_entry.dip6));
						memcpy(qos_classfication_type_entry_a.dip6_end,qos_classfication_type_entry.dip6_end,sizeof(qos_classfication_type_entry.dip6_end));
						break;
					case 1<<IP_QOS_CLASSFICATIONTYPE_SPORT6:
						qos_classfication_type_entry_a.classficationType|=qos_classfication_type_entry.classficationType;
						memcpy(&qos_classfication_type_entry_a.protoType,&qos_classfication_type_entry.protoType,sizeof(qos_classfication_type_entry.protoType));
						memcpy(&qos_classfication_type_entry_a.sPort6,&qos_classfication_type_entry.sPort6,sizeof(qos_classfication_type_entry.sPort6));
						memcpy(&qos_classfication_type_entry_a.sPort6RangeMax,&qos_classfication_type_entry.sPort6RangeMax,sizeof(qos_classfication_type_entry.sPort6RangeMax));
						break;
					case 1<<IP_QOS_CLASSFICATIONTYPE_DPORT6:
						qos_classfication_type_entry_a.classficationType|=qos_classfication_type_entry.classficationType;
						memcpy(&qos_classfication_type_entry_a.protoType,&qos_classfication_type_entry.protoType,sizeof(qos_classfication_type_entry.protoType));
						memcpy(&qos_classfication_type_entry_a.dPort6,&qos_classfication_type_entry.dPort6,sizeof(qos_classfication_type_entry.dPort6));
						memcpy(&qos_classfication_type_entry_a.dPort6RangeMax,&qos_classfication_type_entry.dPort6RangeMax,sizeof(qos_classfication_type_entry.dPort6RangeMax));
						break;
					case 1<<IP_QOS_CLASSFICATIONTYPE_TrafficClass:
						qos_classfication_type_entry_a.classficationType|=qos_classfication_type_entry.classficationType;
						memcpy(&qos_classfication_type_entry_a.protoType,&qos_classfication_type_entry.protoType,sizeof(qos_classfication_type_entry.protoType));
						memcpy(&qos_classfication_type_entry_a.tc,&qos_classfication_type_entry.tc,sizeof(qos_classfication_type_entry.tc));
						memcpy(&qos_classfication_type_entry_a.tc_end,&qos_classfication_type_entry.tc_end,sizeof(qos_classfication_type_entry.tc_end));
						break;
					case 1<<IP_QOS_CLASSFICATIONTYPE_WANINTERFACE:
						qos_classfication_type_entry_a.classficationType|=qos_classfication_type_entry.classficationType;
						memcpy(&qos_classfication_type_entry_a.protoType,&qos_classfication_type_entry.protoType,sizeof(qos_classfication_type_entry.protoType));
						memcpy(&qos_classfication_type_entry_a.wanitf,&qos_classfication_type_entry.wanitf,sizeof(qos_classfication_type_entry.wanitf));
						break;
					case 1<<IP_QOS_CLASSFICATIONTYPE_LANINTERFACE:
						qos_classfication_type_entry_a.classficationType|=qos_classfication_type_entry.classficationType;
						memcpy(&qos_classfication_type_entry_a.protoType,&qos_classfication_type_entry.protoType,sizeof(qos_classfication_type_entry.protoType));
						memcpy(&qos_classfication_type_entry_a.phyPort,&qos_classfication_type_entry.phyPort,sizeof(qos_classfication_type_entry.phyPort));
						memcpy(&qos_classfication_type_entry_a.phyPort_end,&qos_classfication_type_entry.phyPort_end,sizeof(qos_classfication_type_entry.phyPort_end));
						break;
					case 1<<IP_QOS_CLASSFICATIONTYPE_ETHERTYPE:
						qos_classfication_type_entry_a.classficationType|=qos_classfication_type_entry.classficationType;
						memcpy(&qos_classfication_type_entry_a.protoType,&qos_classfication_type_entry.protoType,sizeof(qos_classfication_type_entry.protoType));
						memcpy(&qos_classfication_type_entry_a.ethType,&qos_classfication_type_entry.ethType,sizeof(qos_classfication_type_entry.ethType));
						printf("%s %d ethType=%d\n",__FUNCTION__,__LINE__,qos_classfication_type_entry_a.ethType);
						break;
					case 1<<IP_QOS_CLASSFICATIONTYPE_VID:
						qos_classfication_type_entry_a.classficationType|=qos_classfication_type_entry.classficationType;
						memcpy(&qos_classfication_type_entry_a.protoType,&qos_classfication_type_entry.protoType,sizeof(qos_classfication_type_entry.protoType));
						memcpy(&qos_classfication_type_entry_a.vid,&qos_classfication_type_entry.vid,sizeof(qos_classfication_type_entry.vid));
						memcpy(&qos_classfication_type_entry_a.vid_end,&qos_classfication_type_entry.vid_end,sizeof(qos_classfication_type_entry.vid_end));
						break;
					default:
						memcpy(&qos_classfication_type_entry_a.protoType,&qos_classfication_type_entry.protoType,sizeof(qos_classfication_type_entry.protoType));
						break;
				}
			}
		}

		boaWrite(wp, "IpQosConfig.qosPqList[%d]={\n",qos_web_idx++);
		boaWrite(wp, "proto_type: \"%d\",\n",typeProtoToIPQosProto(qos_classfication_type_entry_a.protoType));
		boaWrite(wp, "pq_unitype: \"%d\",\n",((qos_classfication_type_entry_a.phyPort==0)&&(qos_classfication_type_entry_a.wanitf==DUMMY_IFINDEX))?(0):(((qos_classfication_type_entry_a.phyPort))?1:2));
		boaWrite(wp, "pq_lanport: \"%d\",\n",qos_classfication_type_entry_a.phyPort);
		boaWrite(wp, "pq_lanport_end: \"%d\",\n",qos_classfication_type_entry_a.phyPort_end);
		boaWrite(wp, "pq_wanport: \"%d\",\n",getWANEntryIdxFromIfindex(qos_classfication_type_entry_a.wanitf)+1);
		if(qos_classfication_type_entry_a.ethType==0x0800)
			boaWrite(wp, "ether_type: \"%d\",\n",IPVER_IPV4);
		else if(qos_classfication_type_entry_a.ethType==0x86dd)
			boaWrite(wp, "ether_type: \"%d\",\n",IPVER_IPV6);
		else {
			struct in6_addr* ip6_src_addr=(struct in6_addr *)qos_classfication_type_entry_a.sip6;
			struct in6_addr* ip6_dst_addr=(struct in6_addr *)qos_classfication_type_entry_a.dip6;
			uint8 ip6_empty_addr[16]={0};
			uint32 ip4_src_addr=*((uint32 *)qos_classfication_type_entry_a.sip);
			uint32 ip4_dst_addr=*((uint32 *)qos_classfication_type_entry_a.dip);
			if(ip4_src_addr||ip4_dst_addr)
				boaWrite(wp, "ether_type: \"%d\",\n",IPVER_IPV4);
			else if((memcmp(ip6_src_addr,ip6_empty_addr,sizeof(ip6_empty_addr)))||(memcmp(ip6_dst_addr,ip6_empty_addr,sizeof(ip6_empty_addr))))
				boaWrite(wp, "ether_type: \"%d\",\n",IPVER_IPV6);
			else
				boaWrite(wp, "ether_type: \"%d\",\n",IPVER_IPV4_IPV6);
		}
		if(qos_classfication_type_entry_a.ethType==0x0800||qos_classfication_type_entry_a.ethType==0){
			boaWrite(wp, "ipv4_srcip: \"%s\",\n", inet_ntoa(*((struct in_addr *)qos_classfication_type_entry_a.sip)));
			boaWrite(wp, "ipv4_srcip_end: \"%s\",\n", inet_ntoa(*((struct in_addr *)qos_classfication_type_entry_a.sip_end)));
			boaWrite(wp, "ipv4_dstip: \"%s\",\n", inet_ntoa(*((struct in_addr *)qos_classfication_type_entry_a.dip)));
			boaWrite(wp, "ipv4_dstip_end: \"%s\",\n", inet_ntoa(*((struct in_addr *)qos_classfication_type_entry_a.dip_end)));
			//boaWrite(wp, "tos_dscp_type: \"%d\",\n",qos_entry.dscp);
			if(qos_classfication_type_entry_a.qosDscp!=0xff){
				boaWrite(wp, "tos_dscp_type: \"%d\",\n",2);
				boaWrite(wp, "dscp: \"%d\",\n",qos_classfication_type_entry_a.qosDscp);
				boaWrite(wp, "dscp_end: \"%d\",\n",qos_classfication_type_entry_a.qosDscp_end);
			}else if(qos_classfication_type_entry_a.tos!=0xff){
				boaWrite(wp, "tos_dscp_type: \"%d\",\n",1);
				boaWrite(wp, "dscp: \"%d\",\n",qos_classfication_type_entry_a.tos);
				boaWrite(wp, "dscp_end: \"%d\",\n",qos_classfication_type_entry_a.tos_end);
			}else{
				boaWrite(wp, "dscp: \"%d\",\n",0xff);
				boaWrite(wp, "dscp_end: \"%d\",\n",0xff);
			}
		}else if(qos_classfication_type_entry_a.ethType==0x86dd||qos_classfication_type_entry_a.ethType==0){
				unsigned char ip6Str[55];
				inet_ntop(PF_INET6, (struct in6_addr *)qos_classfication_type_entry_a.sip6, ip6Str, sizeof(ip6Str));
				boaWrite(wp, "ipv6_srcip: \"%s\",\n", ip6Str);
				inet_ntop(PF_INET6, (struct in6_addr *)qos_classfication_type_entry_a.sip6_end, ip6Str, sizeof(ip6Str));
				boaWrite(wp, "ipv6_srcip_end: \"%s\",\n",ip6Str);
				inet_ntop(PF_INET6, (struct in6_addr *)qos_classfication_type_entry_a.dip6, ip6Str, sizeof(ip6Str));
				boaWrite(wp, "ipv6_dstip: \"%s\",\n",ip6Str );
				inet_ntop(PF_INET6, (struct in6_addr *)qos_classfication_type_entry_a.dip6_end, ip6Str, sizeof(ip6Str));
				boaWrite(wp, "ipv6_dstip_end: \"%s\",\n",ip6Str);

				//boaWrite(wp, "tos_dscp_type: \"%d\",\n",qos_entry.dscp);
				if(1/*qos_classfication_type_entry_a.tc!=0xff*/){
					boaWrite(wp, "ipv6_tc: \"%d\",\n",qos_classfication_type_entry_a.tc);
					boaWrite(wp, "ipv6_tc_end: \"%d\",\n",qos_classfication_type_entry_a.tc_end);
				}
				if(qos_classfication_entry.m_dscp)
					boaWrite(wp, "mark_ipv6_tc: \"%d\",\n",qos_classfication_entry.m_dscp);
				else
					boaWrite(wp, "mark_ipv6_tc: \"\",\n");
			}
			boaWrite(wp, "srcport_start: \"%d\",\n",qos_classfication_type_entry_a.sPort);
			boaWrite(wp, "srcport_end: \"%d\",\n",qos_classfication_type_entry_a.sPortRangeMax);
			boaWrite(wp, "dstport_start: \"%d\",\n",qos_classfication_type_entry_a.dPort);
			boaWrite(wp, "dstport_end: \"%d\",\n",qos_classfication_type_entry_a.dPortRangeMax);
			boaWrite(wp, "src_mac: \"%02x:%02x:%02x:%02x:%02x:%02x\",\n",qos_classfication_type_entry_a.smac[0],qos_classfication_type_entry_a.smac[1],qos_classfication_type_entry_a.smac[2],qos_classfication_type_entry_a.smac[3],qos_classfication_type_entry_a.smac[4],qos_classfication_type_entry_a.smac[5]);
			boaWrite(wp, "src_mac_end: \"%02x:%02x:%02x:%02x:%02x:%02x\",\n",qos_classfication_type_entry_a.smac_end[0],qos_classfication_type_entry_a.smac_end[1],qos_classfication_type_entry_a.smac_end[2],qos_classfication_type_entry_a.smac_end[3],qos_classfication_type_entry_a.smac_end[4],qos_classfication_type_entry_a.smac_end[5]);
			boaWrite(wp, "dst_mac: \"%02x:%02x:%02x:%02x:%02x:%02x\",\n",qos_classfication_type_entry_a.dmac[0],qos_classfication_type_entry_a.dmac[1],qos_classfication_type_entry_a.dmac[2],qos_classfication_type_entry_a.dmac[3],qos_classfication_type_entry_a.dmac[4],qos_classfication_type_entry_a.dmac[5]);
			boaWrite(wp, "dst_mac_end: \"%02x:%02x:%02x:%02x:%02x:%02x\",\n",qos_classfication_type_entry_a.dmac_end[0],qos_classfication_type_entry_a.dmac_end[1],qos_classfication_type_entry_a.dmac_end[2],qos_classfication_type_entry_a.dmac_end[3],qos_classfication_type_entry_a.dmac_end[4],qos_classfication_type_entry_a.dmac_end[5]);
			boaWrite(wp, "pbit: \"255\",\n");
			boaWrite(wp, "vlanid: \"%d\",\n",qos_classfication_type_entry_a.vid);
			boaWrite(wp, "vlanid_end: \"%d\",\n",qos_classfication_type_entry_a.vid_end);
			boaWrite(wp, "vlan_8021p: \"%d\",\n",qos_classfication_type_entry_a.vlan1p);
			boaWrite(wp, "vlan_8021p_end: \"%d\",\n",qos_classfication_type_entry_a.vlan1p_end);
			boaWrite(wp, "act_priority: \"%d\",\n",qos_classfication_entry.m_1p-1);
			if(qos_classfication_type_entry_a.ethType==0x0800){
				boaWrite(wp, "act_DSCP_priority: \"%d\",\n",qos_classfication_entry.m_dscp);
			}else{
				//boaWrite(wp, "act_DSCP_priority: \"%d\",\n",0-1);
			}
			boaWrite(wp, "act_queue: \"%d\",\n",qos_classfication_entry.queue);
			boaWrite(wp, "};\n");
		}

#else
	qEntryNum=mib_chain_total(MIB_IP_QOS_TBL);
	int qos_web_idx = 0;
	for(i=0;i<qEntryNum; i++)
	{
		if(!mib_chain_get(MIB_IP_QOS_TBL, i, (void*)&qos_entry))
			continue;
		if(qos_entry.modeTr69!=MODEINTERNET)
			continue;
		boaWrite(wp, "IpQosConfig.qosPqList[%d]={\n",qos_web_idx++);
		boaWrite(wp, "pq_unitype: \"%d\",\n",((qos_entry.phyPort==0)&&(qos_entry.outif==DUMMY_IFINDEX))?(0):(((qos_entry.phyPort))?1:2));
		boaWrite(wp, "pq_lanport: \"%d\",\n",qos_entry.phyPort);
		boaWrite(wp, "pq_lanport_end: \"%d\",\n",qos_entry.phyPort_end);
		boaWrite(wp, "pq_wanport: \"%d\",\n",getWANEntryIdxFromIfindex(qos_entry.outif)+1);
		boaWrite(wp, "ether_type: \"%d\",\n",qos_entry.IpProtocol);
		boaWrite(wp, "proto_type: \"%d\",\n",typeProtoToIPQosProto(qos_entry.protoType));
		if(qos_entry.IpProtocol==IPVER_IPV4){
			boaWrite(wp, "ipv4_srcip: \"%s\",\n", inet_ntoa(*((struct in_addr *)qos_entry.sip)));
			boaWrite(wp, "ipv4_srcip_end: \"%s\",\n", inet_ntoa(*((struct in_addr *)qos_entry.sip_end)));
			boaWrite(wp, "ipv4_dstip: \"%s\",\n", inet_ntoa(*((struct in_addr *)qos_entry.dip)));
			boaWrite(wp, "ipv4_dstip_end: \"%s\",\n", inet_ntoa(*((struct in_addr *)qos_entry.dip_end)));
			//boaWrite(wp, "tos_dscp_type: \"%d\",\n",qos_entry.dscp);
			if(qos_entry.qosDscp){
				boaWrite(wp, "tos_dscp_type: \"%d\",\n",2);
				boaWrite(wp, "dscp: \"%d\",\n",qos_entry.qosDscp);
				boaWrite(wp, "dscp_end: \"%d\",\n",qos_entry.qosDscp_end);
			}else if(qos_entry.tos){
				boaWrite(wp, "tos_dscp_type: \"%d\",\n",1);
				boaWrite(wp, "dscp: \"%d\",\n",qos_entry.tos);
				boaWrite(wp, "dscp_end: \"%d\",\n",qos_entry.tos_end);
			}else{
				boaWrite(wp, "dscp: \"%d\",\n",qos_entry.qosDscp);
			}
		}else if(qos_entry.IpProtocol==IPVER_IPV6){
			unsigned char ip6Str[55];
			inet_ntop(PF_INET6, (struct in6_addr *)qos_entry.sip6, ip6Str, sizeof(ip6Str));
			boaWrite(wp, "ipv6_srcip: \"%s\",\n", ip6Str);
			inet_ntop(PF_INET6, (struct in6_addr *)qos_entry.sip6_end, ip6Str, sizeof(ip6Str));
			boaWrite(wp, "ipv6_srcip_end: \"%s\",\n",ip6Str);
			inet_ntop(PF_INET6, (struct in6_addr *)qos_entry.dip6, ip6Str, sizeof(ip6Str));
			boaWrite(wp, "ipv6_dstip: \"%s\",\n",ip6Str );
			inet_ntop(PF_INET6, (struct in6_addr *)qos_entry.dip6_end, ip6Str, sizeof(ip6Str));
			boaWrite(wp, "ipv6_dstip_end: \"%s\",\n",ip6Str);
			//boaWrite(wp, "tos_dscp_type: \"%d\",\n",qos_entry.dscp);
			if(qos_entry.tos){
				boaWrite(wp, "ipv6_tc: \"%d\",\n",qos_entry.tos);
				boaWrite(wp, "ipv6_tc_end: \"%d\",\n",qos_entry.tos_end);
			}else {
				boaWrite(wp, "ipv6_tc: \"\",\n");
				boaWrite(wp, "ipv6_tc_end: \"\",\n");
			}
			if(qos_entry.m_dscp)
				boaWrite(wp, "mark_ipv6_tc: \"%d\",\n",qos_entry.m_dscp);
			else
				boaWrite(wp, "mark_ipv6_tc: \"\",\n");
		}
		boaWrite(wp, "srcport_start: \"%d\",\n",qos_entry.sPort);
		boaWrite(wp, "srcport_end: \"%d\",\n",qos_entry.sPortRangeMax);
		boaWrite(wp, "dstport_start: \"%d\",\n",qos_entry.dPort);
		boaWrite(wp, "dstport_end: \"%d\",\n",qos_entry.dPortRangeMax);
		boaWrite(wp, "src_mac: \"%02x:%02x:%02x:%02x:%02x:%02x\",\n",qos_entry.smac[0],qos_entry.smac[1],qos_entry.smac[2],qos_entry.smac[3],qos_entry.smac[4],qos_entry.smac[5]);
		boaWrite(wp, "src_mac_end: \"%02x:%02x:%02x:%02x:%02x:%02x\",\n",qos_entry.smac_end[0],qos_entry.smac_end[1],qos_entry.smac_end[2],qos_entry.smac_end[3],qos_entry.smac_end[4],qos_entry.smac_end[5]);
		boaWrite(wp, "dst_mac: \"%02x:%02x:%02x:%02x:%02x:%02x\",\n",qos_entry.dmac[0],qos_entry.dmac[1],qos_entry.dmac[2],qos_entry.dmac[3],qos_entry.dmac[4],qos_entry.dmac[5]);
		boaWrite(wp, "dst_mac_end: \"%02x:%02x:%02x:%02x:%02x:%02x\",\n",qos_entry.dmac_end[0],qos_entry.dmac_end[1],qos_entry.dmac_end[2],qos_entry.dmac_end[3],qos_entry.dmac_end[4],qos_entry.dmac_end[5]);
		boaWrite(wp, "pbit: \"255\",\n");
		boaWrite(wp, "vlanid: \"%d\",\n",qos_entry.vid);
		boaWrite(wp, "vlanid_end: \"%d\",\n",qos_entry.vid_end);
		boaWrite(wp, "vlan_8021p: \"%d\",\n",qos_entry.vlan1p - 1);
		boaWrite(wp, "vlan_8021p_end: \"%d\",\n",qos_entry.vlan1p_end);
		boaWrite(wp, "act_priority: \"%d\",\n",qos_entry.m_1p-1);
		boaWrite(wp, "act_DSCP_priority: \"%d\",\n",qos_entry.m_dscp);
		boaWrite(wp, "act_queue: \"%d\",\n",qos_entry.prior);
		boaWrite(wp, "};\n");
	}
#endif
	//speed limit
	//upload
	mib_get(MIB_DATA_SPEED_LIMIT_UP_MODE, &Mode_up);
	boaWrite(wp, "IpQosConfig.usRateCtlMode = %d;\n",Mode_up);
	MIB_CE_DATA_SPEED_LIMIT_IF_T speed_limit_if_entry;
	int total=mib_chain_total(MIB_DATA_SPEED_LIMIT_UP_IF_TBL);
	for(i=0;i<total;i++){
		if(!mib_chain_get(MIB_DATA_SPEED_LIMIT_UP_IF_TBL,i,&speed_limit_if_entry))
			break;
		boaWrite(wp, "IpQosConfig.usRateCtlLanList[%d] = {InterfaceName_up: \"%d\",rate: \"%d\",};\n",i,speed_limit_if_entry.if_id,speed_limit_if_entry.speed_unit);
	}

	MIB_CE_DATA_SPEED_LIMIT_VLAN_T speed_limit_vlan_entry;
	total=mib_chain_total(MIB_DATA_SPEED_LIMIT_UP_VLAN_TBL);
	for(i=0;i<total;i++){
		if(!mib_chain_get(MIB_DATA_SPEED_LIMIT_UP_VLAN_TBL,i,&speed_limit_vlan_entry))
			break;
		if(speed_limit_vlan_entry.vlan==-1){
			//untag
			boaWrite(wp, "IpQosConfig.usRateCtlVlanList[%d] = {vlan: \"\",rate: \"%d\",};\n",i,speed_limit_vlan_entry.speed_unit);
		}else
			boaWrite(wp, "IpQosConfig.usRateCtlVlanList[%d] = {vlan: \"%d\",rate: \"%d\",};\n",i,speed_limit_vlan_entry.vlan,speed_limit_vlan_entry.speed_unit);
	}
	MIB_CE_DATA_SPEED_LIMIT_IP_T speed_limit_up_ip_entry;
	total=mib_chain_total(MIB_DATA_SPEED_LIMIT_UP_IP_TBL);
	for(i=0;i<total;i++){
		if(!mib_chain_get(MIB_DATA_SPEED_LIMIT_UP_IP_TBL,i,&speed_limit_up_ip_entry))
			break;
		boaWrite(wp, "IpQosConfig.usRateCtlIpList[%d] = {etherType: \"%d\",addrBegin:\"%s\",addrEnd:\"%s\",rate: \"%d\",};\n",i,speed_limit_up_ip_entry.ip_ver==IPVER_IPV4?0:1, speed_limit_up_ip_entry.ip_start,speed_limit_up_ip_entry.ip_end,speed_limit_up_ip_entry.speed_unit);
	}
	//download
	mib_get(MIB_DATA_SPEED_LIMIT_DOWN_MODE, &Mode_down);
	boaWrite(wp, "IpQosConfig.dsRateCtlMode = %d;\n",Mode_down);
	total=mib_chain_total(MIB_DATA_SPEED_LIMIT_DOWN_IF_TBL);
	for(i=0;i<total;i++){
		if(!mib_chain_get(MIB_DATA_SPEED_LIMIT_DOWN_IF_TBL,i,&speed_limit_if_entry))
			break;
		boaWrite(wp, "IpQosConfig.dsRateCtlLanList[%d] = {InterfaceName_down: \"%d\",rate: \"%d\",};\n",i,speed_limit_if_entry.if_id,speed_limit_if_entry.speed_unit);
	}

	total=mib_chain_total(MIB_DATA_SPEED_LIMIT_DOWN_VLAN_TBL);
	for(i=0;i<total;i++){
		if(!mib_chain_get(MIB_DATA_SPEED_LIMIT_DOWN_VLAN_TBL,i,&speed_limit_vlan_entry))
			break;
		if(speed_limit_vlan_entry.vlan==-1){
			boaWrite(wp, "IpQosConfig.dsRateCtlVlanList[%d] = {vlan: \"\",rate: \"%d\",};\n",i,speed_limit_vlan_entry.speed_unit);
		}else
			boaWrite(wp, "IpQosConfig.dsRateCtlVlanList[%d] = {vlan: \"%d\",rate: \"%d\",};\n",i,speed_limit_vlan_entry.vlan,speed_limit_vlan_entry.speed_unit);
	}
	MIB_CE_DATA_SPEED_LIMIT_IP_T speed_limit_ip_entry;
	total=mib_chain_total(MIB_DATA_SPEED_LIMIT_DOWN_IP_TBL);
	for(i=0;i<total;i++){
		if(!mib_chain_get(MIB_DATA_SPEED_LIMIT_DOWN_IP_TBL,i,&speed_limit_ip_entry))
			break;
		boaWrite(wp, "IpQosConfig.dsRateCtlIpList[%d] = {etherType: \"%d\",addrBegin:\"%s\",addrEnd:\"%s\",rate: \"%d\",};\n",i,speed_limit_ip_entry.ip_ver==IPVER_IPV4?0:1, speed_limit_ip_entry.ip_start,speed_limit_ip_entry.ip_end,speed_limit_ip_entry.speed_unit);
	}

	return 0;
}
void ip_qos_Form(request * wp, char* path, char* query)
{
	char *action=NULL,*url=NULL, *p=NULL, *tmp=NULL;
	unsigned char policy = 0, modeflag = 0, old_modeflag = 0;
	int num = 0, ret;
	int j = 0;
	MIB_CE_IP_QOS_QUEUE_T qos_queue_entry;
	MIB_CE_IP_QOS_T qos_entry;
	char *serv_rule = NULL;
	char old_serv_rule[32] = {0};
	unsigned char qos_enable=0;
	printf("%s %d \n",__FUNCTION__,__LINE__);
	//set qos mode PQ or WRR
	action = boaGetVar(wp, "qos_mode", "");
	if (action[0]) {
		policy = atoi(action);
		if(!mib_set(MIB_QOS_POLICY, (void *)&policy)){
			return;
		}
	}
	//set service rule
	//mib_get(CTQOS_MODE, old_serv_rule);
#ifdef QOS_USING_CLASSFICATION
	mib_chain_clear(MIB_IP_QOS_CLASSFICATION_TBL);
	mib_chain_clear(MIB_IP_QOS_CLASSFICATIONTYPE_TBL);
#endif
	serv_rule = boaGetVar(wp, "serv_rule", "");
	//if (serv_rule[0] && strcmp(old_serv_rule, serv_rule)) {
	mib_set(CTQOS_MODE, serv_rule);
	setMIBforQosMode(serv_rule);
	//}
	action = boaGetVar(wp, "qos_mode", "");
	if (action[0]) {
		policy = atoi(action);
		if(!mib_set(MIB_QOS_POLICY, (void *)&policy)){
			return;
		}
	}
	//set qos queue property
	for (num=0; num<MAX_QOS_QUEUE_NUM; num++)
	{
		char wstr[]="q1_weight";
		char qenstr[]="q1_enable";
		if(!mib_chain_get(MIB_IP_QOS_QUEUE_TBL, num, (void*)&qos_queue_entry))
			continue;
		if (policy == 1) { // WRR
			wstr[1] += num;
			p = boaGetVar(wp, wstr, "");
			if (p && p[0])
				qos_queue_entry.weight = atoi(p);
		}
		qenstr[1] += num;
		p = boaGetVar(wp, qenstr, "");
		if (p && p[0]){
			qos_queue_entry.enable = 1;
			//ramen 20171016 avoid the weight 0 cause crash
			if (policy == 1&&qos_queue_entry.weight ==0) { // WRR
				qos_queue_entry.enable = 0;
			}
		}else
			qos_queue_entry.enable = 0;
			mib_chain_update(MIB_IP_QOS_QUEUE_TBL, (void *)&qos_queue_entry, num);
	}
	//set qos enable
	action = boaGetVar(wp, "qosType", "");
	if (action[0]) {
		qos_enable = (action[0]=='0') ? 0 : 1;
		mib_set(MIB_QOS_ENABLE_QOS, &qos_enable);
	}
	//set qos bandwidth
	action = boaGetVar(wp, "qos_bandwidth", "0");
	if (action[0]) {
		unsigned int totalbandwidth = 0;
		totalbandwidth = strtoul(action, NULL, 0);
		if(!mib_set(MIB_TOTAL_BANDWIDTH, (void*)&totalbandwidth))
		{
			ERR_MSG("formQosPolicy: Ƶ趨ʧ!\n"); //formQosPolicy: Cannot set total bandwidth into mib setting!
			return;
		}
		unsigned char totalBandWidthEn = totalbandwidth?1:0;
		if(!qos_enable)
			totalBandWidthEn = 0;
		mib_set(MIB_TOTAL_BANDWIDTH_LIMIT_EN, (void *)&totalBandWidthEn);
	}

	//set DSCP
	action = boaGetVar(wp, "enableDSCP", "");
	if (action[0]) {
		unsigned char value = atoi(action);
		if(!mib_set(MIB_QOS_ENABLE_DSCP_MARK, (void *)&value)){
			ERR_MSG("DSCPر/ر趨ʧ\n"); //Failed to set qos enable/disable 1p remark.
			return;
		}
	}
	//set tc
	action = boaGetVar(wp, "enableTC", "");
	if (action[0]) {
		unsigned char value = atoi(action);
		if(!mib_set(MIB_QOS_ENABLE_TC_MARK, (void *)&value)){
			ERR_MSG("TCر/ر趨ʧ\n"); //Failed to set qos enable/disable 1p remark.
			return;
		}
	}
	//set 802.1p
	action = boaGetVar(wp, "enable8021p", "");
	if (action[0]) {
		unsigned char value = atoi(action);
		if(!mib_set(MIB_QOS_ENABLE_1P, (void *)&value)){
			ERR_MSG("qos 1pر/ر趨ʧ\n"); //Failed to set qos enable/disable 1p remark.
			return;
		}
	}
	//set qos rule
	action = boaGetVar(wp, "qospqrule", "");
	printf("action=%s\n",action);
	mib_chain_clear(MIB_IP_QOS_TBL);
	if(action[0])
	{
		while(1)
		{//add new one
			/*
			if( entryNum>=QUEUE_RULE_NUM_MAX)
			{
				ERR_MSG("йĿѴ."); //You cannot add one new rule when queue is full.
				return;
			}
			*/
			//reset to zero
			bzero(&qos_entry, sizeof(MIB_CE_IP_QOS_T));
			char *qos_rule_start=strstr(action,"{");
			char *qos_rule_end=strstr(action,"}");
			if(!qos_rule_start||!qos_rule_end){
				break;
			}
			*qos_rule_end = '\0';
			action=qos_rule_end+strlen("}");
			qos_rule_start+=strlen("{");
#ifdef QOS_USING_CLASSFICATION
			int ret=parseRuleArgs(wp,qos_rule_start);
#else
			int ret= parseRuleArgs(qos_rule_start, &qos_entry);
			printf("[%s:%d] ret=%d\n",__FUNCTION__, __LINE__, ret);
			if (ret>= 0)
			{
				qos_entry.enable = 1;
				PRINT_QUEUE_RULE((&qos_entry));
#ifdef _PRMT_X_CT_COM_QOS_
				// Mason Yu.
				qos_entry.modeTr69 = MODEINTERNET;
				printf("qos_entry.enable=%d qos_entry.modeTr69=%d\n",qos_entry.enable,qos_entry.modeTr69);
				for(j=0;j<CT_TYPE_NUM;j++)
					qos_entry.cttypemap[j]=0;
				updatecttypevalue(&qos_entry);
#endif

				if(!mib_chain_add(MIB_IP_QOS_TBL, &qos_entry))
				{
					ERR_MSG("mib Error: qosʧ"); //mib Error: Cannot add new one qos rule.
					return;
				}
			}
#endif
		}
	}
done:
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif
	//take effect
	take_qos_effect();
	//redirect web page
	url = boaGetVar(wp, "submit-url", "");
	printf("%s %d url=%s\n",__FUNCTION__,__LINE__,url);
	if(url[0])
	{
		boaRedirect(wp, url);
	}
	return;
}
void ip_download_qos_Form(request * wp, char* path, char* query)
{
		char *action=NULL,*url=NULL, *p=NULL, *tmp=NULL;
		unsigned char policy = 0, modeflag = 0, old_modeflag = 0;
		int num = 0, ret;
		int j = 0;
		unsigned int qosdown_enable=0;
		action = boaGetVar(wp, "qosdown_enable", "");
		if (action[0]) {
			printf("qosdown_enable = %s\n", action);
			qosdown_enable = atoi(action);
		}
		mib_set(MIB_DOWNLOAD_QOS_ENABLE, &qosdown_enable);
	//redirect web page
		url = boaGetVar(wp, "submit-url", "");
		printf("url=%s\n",url);
		if(url[0])
		{
			boaRedirect(wp, url);
		}
		return;
}

void ip_qos_car_Form(request * wp, char* path, char* query)
{
	char *action = NULL, *url = NULL;
	char Mode_up = 0, Mode_down = 0;
	int chain_id = 0, chain_index = -1, chain_action = 0;
	int i = 0;
	enum
	{
		CHAIN_ACTION_NONE = 0,
		CHAIN_ACTION_ADD,
		CHAIN_ACTION_EDIT,
		CHAIN_ACTION_DEL
	};

	action = boaGetVar(wp, "ModeSwitch_up", "");
	if (action[0]) {
		printf("ModeSwitch_up = %s\n", action);
		Mode_up = atoi(action);
	}
	action = boaGetVar(wp, "ModeSwitch_down", "");
	if (action[0]) {
		printf("ModeSwitch_down = %s\n", action);
		Mode_down = atoi(action);
	}
	mib_set(MIB_DATA_SPEED_LIMIT_UP_MODE, &Mode_up);
	mib_set(MIB_DATA_SPEED_LIMIT_DOWN_MODE, &Mode_down);
	action = boaGetVar(wp, "submitAction", "");
	if (action[0]) {
			printf("submitAction = %s\n", action);
			if (strcmp(action, "rule") == 0) {
					if (Mode_up == 1) { // Interface
						int uscarlan_count = 0;
						action = boaGetVar(wp, "uscarlan_count", "");
						if (action[0]) {
							printf("uscarlan_count = %s\n", action);
							uscarlan_count = atoi(action);
						}
						MIB_CE_DATA_SPEED_LIMIT_IF_T entry;
						chain_id = MIB_DATA_SPEED_LIMIT_UP_IF_TBL;
						mib_chain_clear(chain_id);
						for(i=0;i<uscarlan_count;i++){
							char InterfaceName_up[32]={0};
							char usrate[32]={0};
							sprintf(InterfaceName_up,"%s%d","InterfaceName_up",i);
							sprintf(usrate,"%s%d","usrate",i);
							action = boaGetVar(wp, InterfaceName_up, "");
							if (action[0]) {
								printf("InterfaceName_up = %s\n", action);
								entry.if_id = atoi(action);
								//if(entry.if_id >= 1 &&entry.if_id <= SW_LAN_PORT_NUM)
								//	entry.if_id =RG_get_lan_phyPortId(entry.if_id-1);
							}
							action = boaGetVar(wp, usrate, "");
							if (action[0]) {
								printf("InterfaceSpeed_up = %s\n", action);
								entry.speed_unit = atoi(action);
							}
							mib_chain_add(chain_id, (void *)&entry);
						}
					}
					else if (Mode_up == 2) { // VlanTag
						MIB_CE_DATA_SPEED_LIMIT_VLAN_T entry;
						chain_id = MIB_DATA_SPEED_LIMIT_UP_VLAN_TBL;
						int uscarvlan_count = 0;
						action = boaGetVar(wp, "uscarvlan_count", "");
						if (action[0]) {
							printf("uscarvlan_count = %s\n", action);
							uscarvlan_count = atoi(action);
						}
						mib_chain_clear(chain_id);
						for(i=0;i<uscarvlan_count;i++){
							char usvlanId[32]={0};
							char usrate[32]={0};
							sprintf(usvlanId,"%s%d","usvlanId",i);
							sprintf(usrate,"%s%d","usrate",i);
							action = boaGetVar(wp, usvlanId, "");
							if (action[0]) {
								entry.vlan = atoi(action);
							}else
								entry.vlan = -1;//untag
							action = boaGetVar(wp, usrate, "");
							if (action[0]) {
								printf("InterfaceSpeed_up = %s\n", action);
								entry.speed_unit = atoi(action);
							}
							mib_chain_add(chain_id, (void *)&entry);
						}
					}	else if (Mode_up == 3) { // IP
						MIB_CE_DATA_SPEED_LIMIT_IP_T entry;
						chain_id = MIB_DATA_SPEED_LIMIT_UP_IP_TBL;
						char ip_start[64] = {0}, ip_end[64] = {0};
						struct addrinfo hint, *res_start = NULL, *res_end = NULL;
						int ret = 0;
						int uscarip_count = 0;
						action = boaGetVar(wp, "uscarip_count", "");
						if (action[0]) {
							printf("uscarip_count = %s\n", action);
							uscarip_count = atoi(action);
						}
						mib_chain_clear(chain_id);
						for(i=0;i<uscarip_count;i++){
							char usaddrBegin[32]={0};
							char usaddrEnd[32]={0};
							char usrate[32]={0};
							sprintf(usaddrBegin,"%s%d","usaddrBegin",i);
							sprintf(usaddrEnd,"%s%d","usaddrEnd",i);
							sprintf(usrate,"%s%d","usrate",i);
							action = boaGetVar(wp, usrate, "");
							if (action[0]) {
								printf("InterfaceSpeed_up = %s\n", action);
								entry.speed_unit = atoi(action);
							}

							action = boaGetVar(wp, usaddrBegin, "");
							if (action[0]) {
								printf("IP_Start_up = %s\n", action);
								strncpy(ip_start, action, sizeof(ip_start));
							}

							action = boaGetVar(wp, usaddrEnd, "");
							if (action[0]) {
								printf("IP_End_up = %s\n", action);
								strncpy(ip_end, action, sizeof(ip_end));
							}

							memset(&hint, 0, sizeof(hint));

							hint.ai_family = PF_UNSPEC;
							hint.ai_flags = AI_NUMERICHOST;

							ret = getaddrinfo(ip_start, NULL, &hint, &res_start);
							if (ret) {
								printf("Invalid start address %s: %s\n", ip_start, gai_strerror(ret));
								ERR_MSG("Invalid start address");
								return;
							}

							ret = getaddrinfo(ip_end, NULL, &hint, &res_end);
							if (ret) {
								printf("Invalid end address %s: %s\n", ip_end, gai_strerror(ret));
								ERR_MSG("Invalid end address");
								return;
							}

							if (res_start->ai_family != res_end->ai_family) {
								printf("start address family != end address family\n");
								ERR_MSG("Invalid start or end address");
								return;
							}

							if(res_start->ai_family == AF_INET) {
								entry.ip_ver = IPVER_IPV4;
							}
							else if (res_start->ai_family == AF_INET6) {
								entry.ip_ver = IPVER_IPV6;
							}
							else {
								printf("%s is an is unknown address format %d\n", ip_start, res_start->ai_family);
								ERR_MSG("Unknown address format");
								return;
							}
							strcpy(entry.ip_start, ip_start);
							strcpy(entry.ip_end, ip_end);
							freeaddrinfo(res_start);
							freeaddrinfo(res_end);
							mib_chain_add(chain_id, (void *)&entry);
					}
				}

				//download
				if (Mode_down == 1) { // Interface
						int dscarlan_count = 0;
						action = boaGetVar(wp, "dscarlan_count", "");
						if (action[0]) {
							printf("dscarlan_count = %s\n", action);
							dscarlan_count = atoi(action);
						}
						MIB_CE_DATA_SPEED_LIMIT_IF_T entry;
						chain_id = MIB_DATA_SPEED_LIMIT_DOWN_IF_TBL;
						mib_chain_clear(chain_id);
						for(i=0;i<dscarlan_count;i++){
							char InterfaceName_down[32]={0};
							char dsrate[32]={0};
							sprintf(InterfaceName_down,"%s%d","InterfaceName_down",i);
							sprintf(dsrate,"%s%d","dsrate",i);
							action = boaGetVar(wp, InterfaceName_down, "");
							if (action[0]) {
								printf("InterfaceName_down = %s\n", action);
								entry.if_id = atoi(action);
								//if(entry.if_id >= 1 &&entry.if_id <= SW_LAN_PORT_NUM)
								//	entry.if_id =RG_get_lan_phyPortId(entry.if_id-1);
							}
							action = boaGetVar(wp, dsrate, "");
							if (action[0]) {
								printf("InterfaceName_down = %s\n", action);
								entry.speed_unit = atoi(action);
							}
							mib_chain_add(chain_id, (void *)&entry);
						}
					}
					else if (Mode_down == 2) { // VlanTag
						MIB_CE_DATA_SPEED_LIMIT_VLAN_T entry;
						chain_id = MIB_DATA_SPEED_LIMIT_DOWN_VLAN_TBL;
						int dscarvlan_count = 0;
						action = boaGetVar(wp, "dscarvlan_count", "");
						if (action[0]) {
							printf("dscarvlan_count = %s\n", action);
							dscarvlan_count = atoi(action);
						}
						mib_chain_clear(chain_id);
						for(i=0;i<dscarvlan_count;i++){
							char dsvlanId[32]={0};
							char dsrate[32]={0};
							sprintf(dsvlanId,"%s%d","dsvlanId",i);
							sprintf(dsrate,"%s%d","dsrate",i);
							action = boaGetVar(wp, dsvlanId, "");
							if (action[0]) {
								entry.vlan = atoi(action);
							}else
								entry.vlan = -1;//untag
							action = boaGetVar(wp, dsrate, "");
							if (action[0]) {
								entry.speed_unit = atoi(action);
							}
							mib_chain_add(chain_id, (void *)&entry);
						}
					}else if (Mode_down == 3) { // IP
						MIB_CE_DATA_SPEED_LIMIT_IP_T entry;
						chain_id = MIB_DATA_SPEED_LIMIT_DOWN_IP_TBL;
						char ip_start[64] = {0}, ip_end[64] = {0};
						struct addrinfo hint, *res_start = NULL, *res_end = NULL;
						int ret = 0;

						int dscarip_count = 0;
						action = boaGetVar(wp, "dscarip_count", "");
						if (action[0]) {
							printf("dscarip_count = %s\n", action);
							dscarip_count = atoi(action);
						}
						mib_chain_clear(chain_id);
						for(i=0;i<dscarip_count;i++){
							char dsaddrBegin[32]={0};
							char dsaddrEnd[32]={0};
							char dsrate[32]={0};
							sprintf(dsaddrBegin,"%s%d","dsaddrBegin",i);
							sprintf(dsaddrEnd,"%s%d","dsaddrEnd",i);
							sprintf(dsrate,"%s%d","dsrate",i);
							action = boaGetVar(wp, dsrate, "");
							if (action[0]) {
								printf("InterfaceSpeed_up = %s\n", action);
								entry.speed_unit = atoi(action);
							}

							action = boaGetVar(wp, dsaddrBegin, "");
							if (action[0]) {
								printf("IP_Start_up = %s\n", action);
								strncpy(ip_start, action, sizeof(ip_start));
							}

							action = boaGetVar(wp, dsaddrEnd, "");
							if (action[0]) {
								printf("IP_End_up = %s\n", action);
								strncpy(ip_end, action, sizeof(ip_end));
							}

							memset(&hint, 0, sizeof(hint));

							hint.ai_family = PF_UNSPEC;
							hint.ai_flags = AI_NUMERICHOST;

							ret = getaddrinfo(ip_start, NULL, &hint, &res_start);
							if (ret) {
								printf("Invalid start address %s: %s\n", ip_start, gai_strerror(ret));
								ERR_MSG("Invalid start address");
								return;
							}

							ret = getaddrinfo(ip_end, NULL, &hint, &res_end);
							if (ret) {
								printf("Invalid end address %s: %s\n", ip_end, gai_strerror(ret));
								ERR_MSG("Invalid end address");
								return;
							}

							if (res_start->ai_family != res_end->ai_family) {
								printf("start address family != end address family\n");
								ERR_MSG("Invalid start or end address");
								return;
							}

							if(res_start->ai_family == AF_INET) {
								entry.ip_ver = IPVER_IPV4;
							}
							else if (res_start->ai_family == AF_INET6) {
								entry.ip_ver = IPVER_IPV6;
							}
							else {
								printf("%s is an is unknown address format %d\n", ip_start, res_start->ai_family);
								ERR_MSG("Unknown address format");
								return;
							}
							strcpy(entry.ip_start, ip_start);
							strcpy(entry.ip_end, ip_end);
							freeaddrinfo(res_start);
							freeaddrinfo(res_end);
							mib_chain_add(chain_id, (void *)&entry);
					}
				}
		}
	}
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif
	//take effect
	take_qos_effect();
	//redirect web page
	url = boaGetVar(wp, "submit-url", "");
	if (url[0]) {
		boaRedirect(wp, url);
	}
	return;
}




#endif

