/*-- System inlcude files --*/
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <sys/wait.h>

#include "../webs.h"
#include "webform.h"
#include "mib.h"
#include "utility.h"

#ifdef CONFIG_IPV6
#include "../ipv6_info.h"

static const char RADVD_NEW_CONF[] ="/var/radvd2.conf";
static const char KEYWORD1[]= "AdvManagedFlag";
static const char KEYWORD2[]= "AdvOtherConfigFlag";
static const char KEYWORD3[]= "MaxRtrAdvInterval";
static const char KEYWORD4[]= "MinRtrAdvInterval";

void  radvd_modify_mo_flag(){

	FILE *fp=NULL;
	FILE *nfp=NULL;
	char buf[512];
	int radvdpid;
	unsigned char m_flag,o_flag;
	unsigned char max_interval_str[MAX_RADVD_CONF_PREFIX_LEN],
				  min_interval_str[MAX_RADVD_CONF_PREFIX_LEN];

	if ( !mib_get_s(MIB_V6_MANAGEDFLAG, (void *)&m_flag, sizeof(m_flag))){
		printf("ERROR: Get MIB_V6_MANAGEDFLAG failed!\n");
		return;
	}

	if ( !mib_get_s(MIB_V6_OTHERCONFIGFLAG, (void *)&o_flag, sizeof(o_flag))){
		printf("ERROR: Get MIB_V6_OTHERCONFIGFLAG failed!\n");
		return;
	}

	if ( !mib_get_s(MIB_V6_MAXRTRADVINTERVAL, (void *)max_interval_str, sizeof(max_interval_str))){
		printf("ERROR: MIB_V6_MAXRTRADVINTERVAL failed!\n");
		return;
	}

	if ( !mib_get_s(MIB_V6_MINRTRADVINTERVAL, (void *)min_interval_str, sizeof(min_interval_str))){
		printf("ERROR: Get MIB_V6_MINRTRADVINTERVAL failed!\n");
		return;
	}

	if ((fp = fopen(RADVD_CONF, "r")) == NULL)
	{
		printf("Open file %s Error!\n", RADVD_CONF);
		return;
	}

	if ((nfp = fopen(RADVD_NEW_CONF, "w")) == NULL)
	{
		printf("Open file %s Error!\n", RADVD_NEW_CONF);
		fclose(fp);
		return;
	}

	while(fgets(buf,sizeof(buf),fp)>0)
	{
		if(strstr(buf,KEYWORD1))
			fprintf(nfp,"\t%s %s;\n",KEYWORD1,(m_flag==1)?"on":"off");
		else if (strstr(buf,KEYWORD2))
			fprintf(nfp,"\t%s %s;\n",KEYWORD2,(o_flag==1)?"on":"off");
		else if(strstr(buf,KEYWORD3))
			fprintf(nfp,"\t%s %s;\n",KEYWORD3,max_interval_str);
		else if(strstr(buf,KEYWORD4))
			fprintf(nfp,"\t%s %s;\n",KEYWORD4,min_interval_str);
		else
			fprintf(nfp,"%s",buf);

	}

	fclose(fp);
	fclose(nfp);

	sprintf(buf,"cp %s %s\n",RADVD_NEW_CONF, RADVD_CONF);
	system(buf);
}

#if defined(CONFIG_CMCC) || defined(CONFIG_CU_BASEON_CMCC)
void formlanipv6raconf(request * wp, char *path, char *query)
{
	char *str=NULL, *submitUrl=NULL, *strVal=NULL, *pStr=NULL;
	static char tmpBuf[100]={0};
	unsigned char pre_static_prefix_len[32]={0},pre_static_ipaddr[64]={0}, value[64]={0}, cmdBuf[128]={0};
	unsigned char devAddr[MAC_ADDR_LEN];
	unsigned char meui64[8];	
	unsigned char vChar=0;
	unsigned char mode=0;
	unsigned char oriRadvdEnable, oriPrefixMode;
	unsigned char AdvManagedFlagAct = 0, AdvOtherConfigFlagAct = 0;
	char if_name[16];
	int radvdpid, i=0;
	unsigned int ext_if=DUMMY_IFINDEX;
	struct in6_addr ip6Addr;
	int len=0;
	char tmplogBuf[300]={0};
	unsigned char lanipv6prefix[64] = {0};
	char static_prefix_str[INET6_ADDRSTRLEN] = {0};
	unsigned char prefixLen = 0;
	PREFIX_V6_INFO_T prefixInfo;

#ifndef NO_ACTION
	int pid;
#endif

	//clear old static ipv6 info
	mib_get_s( MIB_V6_RADVD_PREFIX_MODE, (void *)&oriPrefixMode, sizeof(oriPrefixMode));
	if(oriPrefixMode == RADVD_MODE_MANUAL){
		//read and delete all static ipv6 address		
		memset(&prefixInfo, 0 ,sizeof(PREFIX_V6_INFO_T));
		mib_get_s(MIB_V6_PREFIX_IP, (void *)pre_static_ipaddr, sizeof(pre_static_ipaddr));
		mib_get_s(MIB_V6_PREFIX_LEN, (void *)pre_static_prefix_len, sizeof(pre_static_prefix_len));
		if(pre_static_ipaddr[0]){
			inet_pton(AF_INET6, pre_static_ipaddr, prefixInfo.prefixIP);
			prefixInfo.prefixLen = atoi(pre_static_prefix_len);
		
			//delete ipv6 radvd static address
			set_lan_ipv6_global_address(NULL,&prefixInfo,(char*)LANIF,0,0);
			//del radvd static prefix route for LAN route table(IP_ROUTE_LAN_TABLE)
			set_ipv6_lan_policy_route((char *)LANIF, (struct in6_addr *)&prefixInfo.prefixIP, prefixInfo.prefixLen, 0);
		}
	}

	//check box type will use default value
	strVal = boaGetVar(wp, "enableradvd", "0");
	printf("enableradvd: %s\n", strVal);
	if ( strVal[0] ) {
		vChar = strVal[0] - '0';
		mib_get_s( MIB_V6_RADVD_ENABLE, (void *)&oriRadvdEnable, sizeof(oriRadvdEnable));
		if(oriRadvdEnable!=vChar)
			syslog(LOG_INFO, "LanIPv6 RA: %s", vChar? "Enable":"Disable");
		mib_set( MIB_V6_RADVD_ENABLE, (void *)&vChar);
	}

	strVal = boaGetVar(wp, "ipv6lanprefixmode", "");
	printf("ipv6lanprefixmode: %s\n", strVal);
	if ( strVal[0] ) {
		mode = strVal[0] - '0';
		mib_get_s( MIB_V6_RADVD_PREFIX_MODE, (void *)&oriPrefixMode, sizeof(oriPrefixMode));
		if(oriPrefixMode!=mode)
			syslog(LOG_INFO, "LanIPv6 RA: Change Prefix mode %s", mode == RADVD_MODE_AUTO? "Auto":"Manual");
		mib_set( MIB_V6_RADVD_PREFIX_MODE, (void *)&mode);
	}

	if(mode == RADVD_MODE_AUTO) //auto
	{
		strVal = boaGetVar(wp, "ext_if", "");
		printf("ext_if: %s\n", strVal);
		if(strVal[0])
			ext_if = (unsigned int)atoi(strVal);
		else
			ext_if = DUMMY_IFINDEX;  // No interface selected.
				
		if(ext_if != DUMMY_IFINDEX)
		{
			ifGetName(ext_if, if_name, sizeof(if_name));
			len += snprintf(tmplogBuf+len, sizeof(tmplogBuf)-len, "Delegate wan interface %s", if_name);
		}

		mib_set( MIB_DNSINFO_WANCONN, (void *)&ext_if);
		mib_set(MIB_PREFIXINFO_DELEGATED_WANCONN, (void *)&ext_if);

	}
	else if(mode == RADVD_MODE_MANUAL) //static
	{
		str = boaGetVar(wp, "Prefix", "");
		printf("Prefix: %s\n", str);
		len += snprintf(tmplogBuf+len, sizeof(tmplogBuf)-len, "Prefix: %s", str);
		//if (str[0]) {
			if ( !mib_set(MIB_V6_PREFIX_IP, (void *)str)) {
				strcpy(tmpBuf, "prefix mib 设定错误!"); //Set ULA prefix mib error!
				goto setErr_radvd;
			}
		//}
		snprintf(lanipv6prefix, sizeof(lanipv6prefix), "%s", str);

		str = boaGetVar(wp, "Prefixlen", "");
		printf("Prefixlen: %s\n", str);
		len += snprintf(tmplogBuf+len, sizeof(tmplogBuf)-len, ", Prefixlen: %s", str);
		if (str[0]) {
			if ( !mib_set(MIB_V6_PREFIX_LEN, (void *)str)) {
				strcpy(tmpBuf, "prefix len mib 设定错误!"); //Set ULA prefix len mib error!
				goto setErr_radvd;
			}
		}
		prefixLen = atoi(str);

		str = boaGetVar(wp, "ULAPrefixValidTime", "");
		printf("ULAPrefixValidTime: %s\n", str);
		len += snprintf(tmplogBuf+len, sizeof(tmplogBuf)-len, ", ULAPrefixValidTime: %s", str);
		if (str[0]) {
			if ( !mib_set(MIB_V6_VALIDLIFETIME, (void *)str)) {
				strcpy(tmpBuf, "ULA prefix valid time mib 设定错误!"); //Set ULA prefix valid time mib error!
				goto setErr_radvd;
			}
		}
		
		str = boaGetVar(wp, "ULAPrefixPreferedTime", "");
		printf("ULAPrefixPreferedTime: %s\n", str);
		len += snprintf(tmplogBuf+len, sizeof(tmplogBuf)-len, ", ULAPrefixPreferedTime: %s", str);
		if (str[0]) {
			if ( !mib_set(MIB_V6_PREFERREDLIFETIME, (void *)str)) {
				strcpy(tmpBuf, "ULA prefix prefered time mib 设定错误!"); //Set ULA prefix prefered time mib error!
				goto setErr_radvd;
			}
		}
		/* Now we only have br0 for LAN bridge. Add static pd route for default wan interface policy route. */
		snprintf(static_prefix_str, sizeof(static_prefix_str), "%s/%d", lanipv6prefix, prefixLen);
		add_static_pd_route_for_default_waninf((char *)static_prefix_str, (char *)BRIF);
	}

	//check box type will use default value
	strVal = boaGetVar(wp, "AdvManagedFlagAct", "0");
	printf("AdvManagedFlagAct: %s\n", strVal);
	if ( strVal[0] ) {
		vChar = strVal[0] - '0';
		mib_set( MIB_V6_MANAGEDFLAG, (void *)&vChar);
		if(vChar) { //enable , M flag, disable autonomous
			mode = 0;
			mib_set(MIB_V6_AUTONOMOUS, &mode);
		} 
		else {
			mode = 1;
			mib_set(MIB_V6_AUTONOMOUS, &mode);
		}
		AdvManagedFlagAct = vChar;
	}

	//check box type will use default value
	strVal = boaGetVar(wp, "AdvOtherConfigFlagAct", "0");
	printf("AdvOtherConfigFlagAct: %s\n", strVal);
	
	if ( strVal[0] ) {
		vChar = strVal[0] - '0';
		mib_set( MIB_V6_OTHERCONFIGFLAG, (void *)&vChar);
		AdvOtherConfigFlagAct = vChar;
	}

	strVal = boaGetVar(wp, "V6MinRtrAdvInterval", "0");
	printf("V6MinRtrAdvInterval: %s\n", strVal);
	
	if ( strVal[0] ) {
		mib_set( MIB_V6_MINRTRADVINTERVAL, (void *)strVal);
	}
	strVal = boaGetVar(wp, "V6MaxRtrAdvInterval", "0");
	printf("V6MaxRtrAdvInterval: %s\n", strVal);
	
	if ( strVal[0] ) {
		mib_set( MIB_V6_MAXRTRADVINTERVAL, (void *)strVal);
	}

	syslog(LOG_INFO, "LanIPv6 RA: %s, AdvManagedFlagAct: %d, AdvOtherConfigFlagAct: %d", tmplogBuf, AdvManagedFlagAct, AdvOtherConfigFlagAct);
	
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif
	mib_get_s(MIB_V6_RADVD_ENABLE, (void *)&vChar, sizeof(vChar));
	radvdpid = read_pid((char *)RADVD_PID);
	if ( vChar==0 ){ //disable RADVD
		if(radvdpid>0){
			kill(radvdpid, SIGTERM);
			//Alan, mark unlink(RADVD_PID)
			//Alan, unlink(RADVD_PID) will cause the new radvd pid be removed. we need to wait the radvd process terminate
			//unlink(RADVD_PID); //remove pid file, since if the pid file still existing will impact next new radvd process

			//Alan, fix mutiple radvd instance problem, just wait the process terminate, the radvd will remove pid file itself
			//waitProcessTerminate(RADVD_PID, WAIT_INFINITE);
		}
	}
	else{ //RADVD is enabled
		restartRadvd();
	}

	restart_default_dhcpv6_server();

	submitUrl = boaGetVar(wp, "submit-url", "");
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
  return;

setErr_radvd:
	ERR_MSG(tmpBuf);
}
#else
void formRadvdSetup(request * wp, char *path, char *query)
{
	char *str, *submitUrl, *strVal, *pStr;
	static char tmpBuf[100];
	unsigned char vChar;
	char mode;
	int radvdpid;
	unsigned char oriPrefixMode=0;
	unsigned char pre_static_prefix_len[32]={0},pre_static_ipaddr[64]={0};
	PREFIX_V6_INFO_T prefixInfo;

#ifndef NO_ACTION
	int pid;
#endif

	//clear old static ipv6 info
	mib_get_s( MIB_V6_RADVD_PREFIX_MODE, (void *)&oriPrefixMode, sizeof(oriPrefixMode));
	if(oriPrefixMode == RADVD_MODE_MANUAL){
		//read and delete all static ipv6 address		
		memset(&prefixInfo, 0 ,sizeof(PREFIX_V6_INFO_T));
		mib_get_s(MIB_V6_PREFIX_IP, (void *)pre_static_ipaddr, sizeof(pre_static_ipaddr));
		mib_get_s(MIB_V6_PREFIX_LEN, (void *)pre_static_prefix_len, sizeof(pre_static_prefix_len));
		if(pre_static_ipaddr[0]){
			inet_pton(AF_INET6, pre_static_ipaddr, prefixInfo.prefixIP);
			prefixInfo.prefixLen = atoi(pre_static_prefix_len);
		
			//delete ipv6 radvd static address
			set_lan_ipv6_global_address(NULL,&prefixInfo,(char*)LANIF,0,0);
			//del radvd static prefix route for LAN route table(IP_ROUTE_LAN_TABLE)
			set_ipv6_lan_policy_route((char *)LANIF, (struct in6_addr *)&prefixInfo.prefixIP, prefixInfo.prefixLen, 0);
		}
	}

	str = boaGetVar(wp, "MaxRtrAdvIntervalAct", "");
	//if (str[0]) {
		if ( !mib_set(MIB_V6_MAXRTRADVINTERVAL, (void *)str)) {
			strcpy(tmpBuf, "MaxRtrAdvIntervalAct mib 设定错误!"); //Set MaxRtrAdvIntervalAct mib error!
			goto setErr_radvd;
		}
	//}

	str = boaGetVar(wp, "MinRtrAdvIntervalAct", "");
	//if (str[0]) {
		if ( !mib_set(MIB_V6_MINRTRADVINTERVAL, (void *)str)) {
			strcpy(tmpBuf, "MinRtrAdvIntervalAct mib 设定错误!"); //Set MinRtrAdvIntervalAct mib error!
			goto setErr_radvd;
		}
	//}

	str = boaGetVar(wp, "AdvCurHopLimitAct", "");
	//if (str[0]) {
		if ( !mib_set(MIB_V6_ADVCURHOPLIMIT, (void *)str)) {
			strcpy(tmpBuf, "AdvCurHopLimitAct mib 设定错误!"); //Set AdvCurHopLimitAct mib error!
			goto setErr_radvd;
		}
	//}

	str = boaGetVar(wp, "AdvDefaultLifetimeAct", "");
	//if (str[0]) {
		if ( !mib_set(MIB_V6_ADVDEFAULTLIFETIME, (void *)str)) {
			strcpy(tmpBuf, "AdvDefaultLifetime mib 设定错误!"); //Set AdvDefaultLifetime mib error!
			goto setErr_radvd;
		}
	//}

	str = boaGetVar(wp, "AdvReachableTimeAct", "");
	//if (str[0]) {
		if ( !mib_set(MIB_V6_ADVREACHABLETIME, (void *)str)) {
			strcpy(tmpBuf, "AdvReachableTime mib 设定错误!"); //Set AdvReachableTime mib error!
			goto setErr_radvd;
		}
	//}

	str = boaGetVar(wp, "AdvRetransTimerAct", "");
	//if (str[0]) {
		if ( !mib_set(MIB_V6_ADVRETRANSTIMER, (void *)str)) {
			strcpy(tmpBuf, "AdvRetransTimer mib 设定错误!"); //Set AdvRetransTimer mib error!
			goto setErr_radvd;
		}
	//}

	str = boaGetVar(wp, "AdvLinkMTUAct", "");
	//if (str[0]) {
		if ( !mib_set(MIB_V6_ADVLINKMTU, (void *)str)) {
			strcpy(tmpBuf, "AdvLinkMTU mib 设定错误!"); //Set AdvLinkMTU mib error!
			goto setErr_radvd;
		}
	//}

	strVal = boaGetVar(wp, "AdvSendAdvertAct", "");
	if ( strVal[0] ) {
		vChar = strVal[0] - '0';
		mib_set( MIB_V6_SENDADVERT, (void *)&vChar);
	}

	strVal = boaGetVar(wp, "radvd_enable", "");
	if ( strVal[0] ) {
		vChar = strVal[0] - '0';
		mib_set( MIB_V6_RADVD_ENABLE, (void *)&vChar);
	}
	
	strVal = boaGetVar(wp, "AdvManagedFlagAct", "0");
	printf("AdvManagedFlagAct: %s\n", strVal);
	if ( strVal[0] ) {
		vChar = strVal[0] - '0';
		mib_set( MIB_V6_MANAGEDFLAG, (void *)&vChar);
		if(vChar) { //enable , M flag, disable autonomous
			vChar = 0;
			mib_set(MIB_V6_AUTONOMOUS, &vChar);
		} 
		else {
			vChar = 1;
			mib_set(MIB_V6_AUTONOMOUS, &vChar);
		}
	}
	strVal = boaGetVar(wp, "AdvOtherConfigFlagAct", "");
	if ( strVal[0] ) {
		vChar = strVal[0] - '0';
		mib_set( MIB_V6_OTHERCONFIGFLAG, (void *)&vChar);
	}
	
	strVal = boaGetVar(wp, "EnableULA", "");
	if ( strVal[0] ) {
		vChar = strVal[0] - '0';
		mib_set( MIB_V6_ULAPREFIX_ENABLE, (void *)&vChar);
	}

	str = boaGetVar(wp, "ULAPrefix", "");
	if (str[0]) {
		if ( !mib_set(MIB_V6_ULAPREFIX, (void *)str)) {
			strcpy(tmpBuf, "ULA prefix mib 设定错误!"); //Set ULA prefix mib error!
			goto setErr_radvd;
		}
	}

	str = boaGetVar(wp, "ULAPrefixlen", "");
	if (str[0]) {
		if ( !mib_set(MIB_V6_ULAPREFIX_LEN, (void *)str)) {
			strcpy(tmpBuf, "ULA prefix len mib 设定错误!"); //Set ULA prefix len mib error!
			goto setErr_radvd;
		}
	}
	str = boaGetVar(wp, "ULAPrefixValidTime", "");
	if (str[0]) {
		if ( !mib_set(MIB_V6_ULAPREFIX_VALID_TIME, (void *)str)) {
			strcpy(tmpBuf, "ULA prefix valid time mib 设定错误!"); //Set ULA prefix valid time mib error!
			goto setErr_radvd;
		}
	}
	
	str = boaGetVar(wp, "ULAPrefixPreferedTime", "");
	if (str[0]) {
		if ( !mib_set(MIB_V6_ULAPREFIX_PREFER_TIME, (void *)str)) {
			strcpy(tmpBuf, "ULA prefix prefered time mib 设定错误!"); //Set ULA prefix prefered time mib error!
			goto setErr_radvd;
		}
	}

	strVal = boaGetVar(wp, "RDNSS1", "");
	mib_set( MIB_V6_RDNSS1, (void *)strVal);

	strVal = boaGetVar(wp, "RDNSS2", "");
	mib_set( MIB_V6_RDNSS2, (void *)strVal);

	strVal = boaGetVar(wp, "PrefixEnable", "");
	if ( strVal[0] ) {
		vChar = strVal[0] - '0';
		mib_set( MIB_V6_PREFIX_ENABLE, (void *)&vChar);
	}
	pStr = boaGetVar(wp, "PrefixMode", "");
	if (pStr[0]) {
		if (pStr[0] == '1') {
			mode = 1;    // Manual

			str = boaGetVar(wp, "prefix_ip", "");
			if (str[0]) {
				if ( !mib_set(MIB_V6_PREFIX_IP, (void *)str)) {
					strcpy(tmpBuf, "prefix_ip mib 设定错误!"); //Set prefix_ip mib error!
					goto setErr_radvd;
				}
			}

			str = boaGetVar(wp, "prefix_len", "");
			if (str[0]) {
				if ( !mib_set(MIB_V6_PREFIX_LEN, (void *)str)) {
					strcpy(tmpBuf, "prefix_len mib 设定错误!"); //Set prefix_len mib error!
					goto setErr_radvd;
				}
			}

			str = boaGetVar(wp, "AdvValidLifetimeAct", "");
			//if (str[0]) {
				if ( !mib_set(MIB_V6_VALIDLIFETIME, (void *)str)) {
					strcpy(tmpBuf, "AdvValidLifetime mib 设定错误!"); //Set AdvValidLifetime mib error!
					goto setErr_radvd;
				}
			//}

			str = boaGetVar(wp, "AdvPreferredLifetimeAct", "");
			//if (str[0]) {
				if ( !mib_set(MIB_V6_PREFERREDLIFETIME, (void *)str)) {
					strcpy(tmpBuf, "AdvPreferredLifetime mib 设定错误!"); //Set AdvPreferredLifetime mib error!
					goto setErr_radvd;
				}
			//}

			strVal = boaGetVar(wp, "AdvOnLinkAct", "");
			if ( strVal[0] ) {
				vChar = strVal[0] - '0';
				mib_set( MIB_V6_ONLINK, (void *)&vChar);
			}

			strVal = boaGetVar(wp, "AdvAutonomousAct", "");
			if ( strVal[0] ) {
				vChar = strVal[0] - '0';
				//don't know why do this, comment it 2019/10/16
				//mib_set( MIB_V6_MANAGEDFLAG, (void *)&vChar);
				if(vChar) { //enable , M flag, disable autonomous
					vChar = 0;
					mib_set(MIB_V6_AUTONOMOUS, &vChar);
				} 
				else {
					vChar = 1;
					mib_set(MIB_V6_AUTONOMOUS, &vChar);
				}
			}
	   	} else {
	   		mode = 0;     // Auto
	   	}
	} else {
		mode = 0;            // Auto
	}
	mib_set(MIB_V6_RADVD_PREFIX_MODE, (void *)&mode);

	// Magician: Commit immediately
#ifdef COMMIT_IMMEDIATELY
	Commit();
#endif

	mib_get_s(MIB_V6_RADVD_ENABLE, (void *)&vChar, sizeof(vChar));
	radvdpid = read_pid((char *)RADVD_PID);
	if ( vChar==0 ){ //disable RADVD
		if(radvdpid>0){
			kill(radvdpid, SIGTERM);
			//Alan, mark unlink(RADVD_PID)
			//Alan, unlink(RADVD_PID) will cause the new radvd pid be removed. we need to wait the radvd process terminate
			//unlink(RADVD_PID); //remove pid file, since if the pid file still existing will impact next new radvd process

			//Alan, fix mutiple radvd instance problem, just wait the process terminate, the radvd will remove pid file itself
			//waitProcessTerminate(RADVD_PID, WAIT_INFINITE);
		}
	}
	else{ //RADVD is enabled
		restartRadvd();
	}

#ifdef DHCPV6_ISC_DHCP_4XX
	restart_default_dhcpv6_server();
#endif

#ifndef NO_ACTION
	pid = fork();
	if (pid)
		waitpid(pid, NULL, 0);
	else if (pid == 0) {
		snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _CONFIG_SCRIPT_PROG);
#ifdef HOME_GATEWAY
		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "gw", "bridge", NULL);
#else
		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "ap", "bridge", NULL);
#endif
		exit(1);
	}
#endif

	submitUrl = boaGetVar(wp, "submit-url", "");
	if (submitUrl[0])
		boaRedirect(wp, submitUrl);
	else
		boaDone(wp, 200);
  return;

setErr_radvd:
	ERR_MSG(tmpBuf);
}
#endif // #ifdef CONFIG_CMCC
#endif // #ifdef CONFIG_IPV6
